!dirac_copyright_start
!      Copyright (c) by the authors of DIRAC.
!
!      This program is free software; you can redistribute it and/or
!      modify it under the terms of the GNU Lesser General Public
!      License version 2.1 as published by the Free Software Foundation.
!
!      This program is distributed in the hope that it will be useful,
!      but WITHOUT ANY WARRANTY; without even the implied warranty of
!      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
!      Lesser General Public License for more details.
!
!      If a copy of the GNU LGPL v2.1 was not distributed with this
!      code, you can obtain one at https://www.gnu.org/licenses/old-licenses/lgpl-2.1.en.html.
!dirac_copyright_end

MODULE RECP_NTR
  REAL(8), ALLOCATABLE :: ctranarg(:, :, :, :)
  INTEGER, ALLOCATABLE :: RECP_MCRS(:)
! READCP  
  INTEGER, ALLOCATABLE :: RECP_SET(:)
  INTEGER, ALLOCATABLE :: RECP_CENT(:)
  INTEGER, ALLOCATABLE :: RECP_CORE(:)
  INTEGER, ALLOCATABLE :: AREP_ANG(:)
  INTEGER, ALLOCATABLE :: AREP_BLK(:,:)
! INTEGER, ALLOCATABLE :: AREP_R(:,:,:)
! REAL(8), ALLOCATABLE :: AREP_E(:,:,:)
! REAL(8), ALLOCATABLE :: AREP_C(:,:,:)
  INTEGER, ALLOCATABLE :: RECPIN_R(:)
  REAL(8), ALLOCATABLE :: RECPIN_E(:)
  REAL(8), ALLOCATABLE :: RECPIN_C(:)
  INTEGER, ALLOCATABLE :: SOREP_ANG(:)
  INTEGER, ALLOCATABLE :: SOREP_BLK(:,:)
! INTEGER, ALLOCATABLE :: SOREP_R(:,:,:)
! REAL(8), ALLOCATABLE :: SOREP_E(:,:,:)
! REAL(8), ALLOCATABLE :: SOREP_C(:,:,:)
! IRREP
  CHARACTER*3, ALLOCATABLE :: RECP_ITYP(:)
  INTEGER, ALLOCATABLE :: RECP_MAXREP(:)
  INTEGER, ALLOCATABLE :: RECP_NDPT(:)
  INTEGER, ALLOCATABLE :: RECP_IRREP(:)
! BASISSET
  INTEGER,   ALLOCATABLE :: RECPIN_NONTYP(:)
  INTEGER,   ALLOCATABLE :: RECPIN_IQM(:)
  INTEGER,   ALLOCATABLE :: RECPIN_JCO(:,:)
  INTEGER,   ALLOCATABLE :: RECPIN_NUC(:)
  INTEGER,   ALLOCATABLE :: RECPIN_NRC(:)
  INTEGER,   ALLOCATABLE :: RECPIN_LMNP(:)
  INTEGER,   ALLOCATABLE :: RECPIN_NCONS0(:,:,:)   !RECP_LNK_RDORB
!FIXME : CHECK REAL(8)
  REAL(8),   ALLOCATABLE :: RECPIN_ALPHA(:,:)
  REAL(8),   ALLOCATABLE :: RECPIN_CPRIMU(:,:,:)
! AO2SO
  INTEGER,   ALLOCATABLE :: RECPIN_MXROW(:)
  INTEGER,   ALLOCATABLE :: RECPIN_LA1(:,:)
  INTEGER,   ALLOCATABLE :: RECPIN_AO2SO(:,:,:)
! GEO & GENERAL
  CHARACTER*4, ALLOCATABLE :: RECPIN_NAMN(:)
  INTEGER,   ALLOCATABLE :: RECPIN_BASISBLK(:) 
  INTEGER,   ALLOCATABLE :: RECPIN_NUC2(:) 
  REAL(8),   ALLOCATABLE :: RECPIN_CHARGE(:) 
  REAL(8),   ALLOCATABLE :: RECPIN_GEO(:,:,:) 
  INTEGER,   ALLOCATABLE :: RECPIN_ICA(:,:,:)
  INTEGER,   ALLOCATABLE :: RECPIN_BLKMATCH(:,:)
  INTEGER,   ALLOCATABLE :: RECPIN_GENVAL(:)
CONTAINS


SUBROUTINE RECP_NTRA_READCP(MXCENT)
  IMPLICIT NONE
#include "recpval.h"
  INTEGER :: MXCENT
  IF (.NOT.ALLOCATED(RECP_CENT)) ALLOCATE(RECP_CENT(MXCENT)) 
  IF (.NOT.ALLOCATED(RECP_CORE)) ALLOCATE(RECP_CORE(MXCENT))

  IF (.NOT.ALLOCATED(AREP_ANG)) ALLOCATE(AREP_ANG(MXCENT))
  IF (.NOT.ALLOCATED(AREP_BLK)) ALLOCATE(AREP_BLK(MXCENT,RECP_MXANG))
  IF (.NOT.ALLOCATED(RECPIN_R)) ALLOCATE(RECPIN_R(2000))
  IF (.NOT.ALLOCATED(RECPIN_E)) ALLOCATE(RECPIN_E(2000))
  IF (.NOT.ALLOCATED(RECPIN_C)) ALLOCATE(RECPIN_C(2000))

  IF (.NOT.ALLOCATED(SOREP_ANG)) ALLOCATE(SOREP_ANG(MXCENT))
  IF (.NOT.ALLOCATED(SOREP_BLK)) ALLOCATE(SOREP_BLK(MXCENT,RECP_MXANG))
END SUBROUTINE RECP_NTRA_READCP

SUBROUTINE RECP_NTRD_READCP
  IMPLICIT NONE

  DEALLOCATE(RECP_CENT)
  DEALLOCATE(RECP_CORE)

  DEALLOCATE(AREP_ANG)
  DEALLOCATE(AREP_BLK)
  DEALLOCATE(RECPIN_R)
  DEALLOCATE(RECPIN_E)
  DEALLOCATE(RECPIN_C)

  DEALLOCATE(SOREP_ANG)
  DEALLOCATE(SOREP_BLK)
END SUBROUTINE RECP_NTRD_READCP

SUBROUTINE RECP_NTRA_IRREP(MAXREP)
  IMPLICIT NONE
  INTEGER  :: MAXREP
  ALLOCATE ( RECP_MAXREP(1)    )
  ALLOCATE ( RECP_ITYP(MAXREP+1) )
  ALLOCATE ( RECP_NDPT(1)      )
  ALLOCATE ( RECP_IRREP(8)     )  ! 8 : nstag maximum
END SUBROUTINE RECP_NTRA_IRREP

SUBROUTINE RECP_NTRD_IRREP
  IMPLICIT NONE
  DEALLOCATE ( RECP_MAXREP )
  DEALLOCATE ( RECP_ITYP   )
  DEALLOCATE ( RECP_NDPT   )
  DEALLOCATE ( RECP_IRREP  )
END SUBROUTINE RECP_NTRD_IRREP

SUBROUTINE RECP_NTRA_BASIS(KATOM,KANG,KBLOCK,NONTYP,IQM,JCO,NUC,NRC)
  IMPLICIT NONE
  INTEGER  KATOM,KANG,KBLOCK,NONTYP,IQM(KATOM),JCO(KANG,KATOM),NUC(KBLOCK),NRC(KBLOCK) 
  INTEGER  I,J,K,MXIQM,MXJCO,MXNUC,MXNRC,KBCH,IERR

  MXIQM = 0
  MXJCO = 0
  MXNUC = 0
  MXNRC = 0
  KBCH  = 0
  DO I = 1,NONTYP
     MXIQM = MAX(MXIQM,IQM(I))
     DO J = 1,IQM(I)
        MXJCO = MAX(MXJCO,JCO(J,I))
        DO K = 1,JCO(J,I)
           KBCH = KBCH + 1
           MXNUC = MAX(MXNUC,NUC(KBCH))
           MXNRC = MAX(MXNRC,NRC(KBCH))
        ENDDO
     ENDDO
  ENDDO
  
  ALLOCATE ( RECPIN_NONTYP(1),STAT=IERR )
  IF (IERR.NE.0) CALL RECP_NTR_EXIT(1000,'RECPIN_NONTYP') 
  ALLOCATE ( RECPIN_IQM(NONTYP),STAT=IERR )
  IF (IERR.NE.0) CALL RECP_NTR_EXIT(1000,'RECPIN_IQM') 
! ALLOCATE ( RECPIN_JCO(MXJCO,MXIQM),STAT=IERR )
  ALLOCATE ( RECPIN_JCO(MXIQM,NONTYP),STAT=IERR )
  IF (IERR.NE.0) CALL RECP_NTR_EXIT(1000,'RECPIN_JCO') 
! DO I = 1,MXJCO
!    DO J = 1,MXIQM
!       RECPIN_JCO(MXJCO,MXIQM) = 0
!    ENDDO
! ENDDO
  ALLOCATE ( RECPIN_NUC(KBCH),STAT=IERR )
  IF (IERR.NE.0) CALL RECP_NTR_EXIT(1000,'RECPIN_NUC') 
  ALLOCATE ( RECPIN_NRC(KBCH),STAT=IERR )
  IF (IERR.NE.0) CALL RECP_NTR_EXIT(1000,'RECPIN_NRC') 
  ALLOCATE ( RECPIN_LMNP(KBCH),STAT=IERR )
  IF (IERR.NE.0) CALL RECP_NTR_EXIT(1000,'RECPIN_LMNP') 
  ALLOCATE ( RECPIN_ALPHA(MXNUC,KBCH),STAT=IERR )
  IF (IERR.NE.0) CALL RECP_NTR_EXIT(1000,'RECPIN_ALPHA') 
  ALLOCATE ( RECPIN_CPRIMU(MXNUC,MXNRC,KBCH),STAT=IERR )
  IF (IERR.NE.0) CALL RECP_NTR_EXIT(1000,'RECPIN_CPRIMU') 
  ALLOCATE ( RECPIN_NCONS0(MXJCO,MXIQM,NONTYP),STAT=IERR )
  IF (IERR.NE.0) CALL RECP_NTR_EXIT(1000,'RECPIN_NCONS0') 
END SUBROUTINE RECP_NTRA_BASIS

SUBROUTINE RECP_NTRD_BASIS
  IMPLICIT NONE
!#include "inc_print.h"
  INTEGER IERR,I,BLOCK1
  DEALLOCATE ( RECPIN_NONTYP,STAT=IERR )
  IF (IERR.NE.0) CALL RECP_NTR_EXIT(1100,'RECPIN_NONTYP') 
  DEALLOCATE ( RECPIN_IQM,STAT=IERR )
  IF (IERR.NE.0) CALL RECP_NTR_EXIT(1100,'RECPIN_IQM') 
  DEALLOCATE ( RECPIN_JCO,STAT=IERR )
  IF (IERR.NE.0) CALL RECP_NTR_EXIT(1100,'RECPIN_JCO') 
  DEALLOCATE ( RECPIN_NUC,STAT=IERR )
  IF (IERR.NE.0) CALL RECP_NTR_EXIT(1100,'RECPIN_NUC')
  DEALLOCATE ( RECPIN_NRC,STAT=IERR )
  IF (IERR.NE.0) CALL RECP_NTR_EXIT(1100,'RECPIN_NRC') 
  DEALLOCATE ( RECPIN_LMNP,STAT=IERR )
  IF (IERR.NE.0) CALL RECP_NTR_EXIT(1100,'RECPIN_LMNP') 
  DEALLOCATE ( RECPIN_ALPHA,STAT=IERR )
  IF (IERR.NE.0) CALL RECP_NTR_EXIT(1100,'RECPIN_ALPHA') 
  DEALLOCATE ( RECPIN_CPRIMU,STAT=IERR )
  IF (IERR.NE.0) CALL RECP_NTR_EXIT(1100,'RECPIN_CPRIMU') 
  DEALLOCATE ( RECPIN_NCONS0,STAT=IERR )
  IF (IERR.NE.0) CALL RECP_NTR_EXIT(1100,'RECPIN_NCONS0')
END SUBROUTINE RECP_NTRD_BASIS

SUBROUTINE RECP_NTRA_AOTOSO1 
  IMPLICIT NONE
#include "mxcent.h"
#include "maxorb.h"
#include "nuclei.h"
#include "shells.h"
  INTEGER  :: I,J,K,L,NHKT0,irowmax0
  NHKT0   = 0
  irowmax0 = 0
  DO I = 1, NUCIND
     DO J = 1, KMAX
        NHKT0 = MAX(NHKT0,NHKT(J))
        irowmax0 = MAX (irowmax0, (nucdeg(I)*KHKT(J)) )
     ENDDO
  ENDDO

! print *,'alloc,CTRANARG',NUCIND,NHKT0,irowmax0,irowmax0
  ALLOCATE(CTRANARG(NUCIND,NHKT0,irowmax0,irowmax0))
  DO I = 1, NUCIND
     DO J = 1, NHKT0
        DO K = 1, irowmax0
           DO L = 1, irowmax0
              CTRANARG(I,J,K,L) = 0.0d0
           ENDDO
        ENDDO
     ENDDO
  ENDDO
END SUBROUTINE RECP_NTRA_AOTOSO1 


SUBROUTINE RECP_NTRA_AOTOSO(NUCIND,MAXANG,irowmax)
  IMPLICIT NONE
  INTEGER  :: NUCIND,MAXANG(:),irowmax(:,:)
  INTEGER  :: IROW1,AORDS1,I0,J0

! Size of allocation variables
  AORDS1 = 0
  IROW1  = 0
  DO I0 = 1, NUCIND
     DO J0 = 1, MAXANG(I0)
        AORDS1 = AORDS1 + 1
        IROW1  = MAX(IROW1,irowmax(I0,J0))
     ENDDO
  ENDDO
  
  ALLOCATE ( RECPIN_MXROW(AORDS1) )
  ALLOCATE ( RECPIN_LA1(IROW1,AORDS1) )
  ALLOCATE ( RECPIN_AO2SO(IROW1,IROW1,AORDS1) )
END SUBROUTINE RECP_NTRA_AOTOSO

SUBROUTINE RECP_NTRD_AOTOSO
  IMPLICIT NONE
  DEALLOCATE ( RECPIN_MXROW )
  DEALLOCATE ( RECPIN_LA1 )
  DEALLOCATE ( RECPIN_AO2SO )
END SUBROUTINE RECP_NTRD_AOTOSO

SUBROUTINE RECP_NTRA_GEO(MXATOM,KATOM,KANG,NONTYP,NONT,MJ2,IQM,JCO,NGENP)
  IMPLICIT NONE
  INTEGER  MXATOM,KATOM,KANG,NONTYP,NONT(MXATOM),MJ2(MXATOM,MXATOM),IQM(KATOM),NGENP
  INTEGER  JCO(KANG,KATOM),I,N,J,ICENT,MJ3,MJ4,IBLK
! Size of allocation variables
  ICENT = 0
  MJ4   = 0
  IBLK  = 0
  DO I = 1,NONTYP            ! atomic type
     DO N = 1,NONT(I)        ! symmetry-independent center
        ICENT = ICENT + 1
        MJ3   = (MJ2(I,N)-1)
        MJ4   = MAX(MJ3,MJ4) ! MJ4 : maxium value of (MJ2(I,N)-1)
        DO J = 1,IQM(I)
           IBLK  = IBLK + JCO(J,I)
        ENDDO
     ENDDO
  ENDDO

  ALLOCATE ( RECPIN_NAMN(ICENT) )
  ALLOCATE ( RECPIN_BASISBLK(ICENT) )
  ALLOCATE ( RECPIN_NUC2(ICENT) )
  ALLOCATE ( RECPIN_CHARGE(ICENT) )
  ALLOCATE ( RECPIN_GEO(3,MJ4,ICENT) )
  ALLOCATE ( RECPIN_ICA(MJ4,ICENT,NGENP) )
  ALLOCATE ( RECPIN_BLKMATCH(2,IBLK) )
  ALLOCATE ( RECPIN_GENVAL(3) )
  
END SUBROUTINE RECP_NTRA_GEO

SUBROUTINE RECP_NTRD_GEO
  IMPLICIT NONE
  DEALLOCATE ( RECPIN_NAMN )
  DEALLOCATE ( RECPIN_BASISBLK )
  DEALLOCATE ( RECPIN_NUC2 )
  DEALLOCATE ( RECPIN_CHARGE )
  DEALLOCATE ( RECPIN_GEO )
  DEALLOCATE ( RECPIN_ICA )
  DEALLOCATE ( RECPIN_BLKMATCH )
  DEALLOCATE ( RECPIN_GENVAL )
END SUBROUTINE RECP_NTRD_GEO

SUBROUTINE RECP_NTR_EXIT(IERR,RECP_VAR)
  IMPLICIT NONE
#include "inc_print.h"
  INTEGER :: IERR
  CHARACTER(LEN=*) :: RECP_VAR

  IF (IERR.EQ.1000) THEN
     WRITE(RECP_OUT,'(A,A,A)') ' RECP : Not enough memory (',RECP_VAR,')' 
  ELSEIF (IERR.EQ.1100) THEN
     WRITE(RECP_OUT,'(A,A,A)') ' RECP : Deallocation error (',RECP_VAR,')' 
  ELSE
     WRITE(RECP_OUT,'(A,A,A)') ' RECP : Unknown error (',RECP_VAR,')' 
  ENDIF

  STOP
END SUBROUTINE RECP_NTR_EXIT

END MODULE RECP_NTR



