!dirac_copyright_start
!      Copyright (c) by the authors of DIRAC.
!
!      This program is free software; you can redistribute it and/or
!      modify it under the terms of the GNU Lesser General Public
!      License version 2.1 as published by the Free Software Foundation.
!
!      This program is distributed in the hope that it will be useful,
!      but WITHOUT ANY WARRANTY; without even the implied warranty of
!      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
!      Lesser General Public License for more details.
!
!      If a copy of the GNU LGPL v2.1 was not distributed with this
!      code, you can obtain one at https://www.gnu.org/licenses/old-licenses/lgpl-2.1.en.html.
!dirac_copyright_end

C
      PROGRAM DIRRCI
C
      IMPLICIT REAL*8 (A-H, O-Z)
C
C     ====================================================================
C     DIRECT RELATIVISTIC RAS CI PROGRAM
C
C     FIRST VERSION WRITTEN IN JULY 1991 BY LUUK VISSCHER
C     Large revisions in July 1995 by Bert de Jong
C
C     COMMON BLOCKS :
C
C     ABEL    :   MULTIPLICATION TABLE OF ABELIAN SUBGROUP
C     CHR     :   CHARACTER VARIABLES (REPR. NAMES)
C     CMTRIX  :   CI-MATRIX IN THE BASIS OF THE EXPANSION VECTORS
C     CONTROL :   NUMBER OF ITERATIONS, SELECTED VECTORS, ETC.
C     CRITERS :   CONVERGENCE CRITERIA
C     DELSP   :   REORDERING INFORMATION NECESSARY TO DELETE VIRTUALS
C     DGELM   :   DIAGONAL ELEMENTS OF THE LARGE CI-MATRIX
C     EIVALS  :   EIGEN VALUES, RESIDUES, DAVIDSON CORRECTION
C     FNAMES  :   FILE NAMES
C     FNUMBS  :   FILE NUMBERS
C     GMAT    :   G MATRIX ELEMENTS
C     RAS     :   NUMBER OF ORBITALS, ELECTRONS IN THE RAS SUBSPACES
C     RECIND  :   ADDRESSES OF STORED 1-ELECTRON EXCITATIONS
C     SHUF(I) :   WORKSPACE TO REORDER 2-EL. INTEGRALS (*)
C     TIMING  :   TIMING INFORMATION
C     TWOE    :   TWO ELECTRON INTEGRALS
C     VECTOR  :   EXPANSION VECTORS, SIGMA VECTORS (*)
C     VWEIGHT :   VERTEX WEIGHTS
C     IPOINT  :   POINTERS OF THE MAIN MEMORY BLOCK
C
C     BLOCK DATA :
C
C     DIRDAT  :   INITIALIZES FILES NAMES AND NUMBERS
C
C     SUBROUTINES AND FUNCTIONS :
C
C     DIRECT  :   MAIN PROGRAM
C     SETUP   :   GETS NECESSARY DATA TO SET UP CI SPACE
C     DRIVER  :   CONTROLS DIAGONALISATION PROCEDURE
C     ORBSIN  :   READS ORBITAL INFORMATION
C     USERIN  :   READS USER INPUT
C     SHUFFLE :   REORDERING 2-ELECTRON INTEGRALS
C     MAKEGM  :   MAKES GMATRIX
C     VERTEX  :   CALCULATES VERTEX WEIGHTS
C     DETIND  :   CALCULATES ADRESS OF A BIT REPRESENTATION
C     DIAGELM :   CALCULATES DIAGONAL ELEMENTS OF THE LARGE CI-MATRIX
C     TRIAL   :   READS TRIAL CI VECTORS
C     REAVEC  :   READS CI ROOTS FROM PREVIOUS RUN (RESTART)
C     EXPAND  :   CALCULATES SIGMA VECTOR
C     CALIDS  :   CALCULATE ADRESSES OF INTERACTING DETERMINANTS
C     MAKIDS  :   STORE 1-ELECTRON EXCITATIONS
C     GETIDS  :   GET ADRESSES OF INTERACTING DETERMINANTS
C     TWOLIN  :   READS (PART OF) 2-ELECTRON INTEGRALS
C     CINPRD  :   INNER PRODUCT OF TWO VECTORS
C     DIAG    :   DIAGONALISATION OF THE CI MATRIX
C     SELECV  :   SELECT THE APPROPRIATE VECTOR
C     WRIVEC  :   WRITE SELECTED ROOTS TO FILE
C     INITVEC :   INITIALISES TEMPORARY FILE FOR EXPANSION VECTORS
C     PUTVEC  :   GETS EXPANSION VECTOR FROM (TEMPORARY) FILE
C     GETVEC  :   GETS EXPANSION VECTOR FROM (TEMPORARY) FILE
C     RESIDUE :   CALCULATES RESIDUAL VECTOR
C     CRITER  :   CHECKS WHETHER CONVERGENCE OR MAXITER IS REACHED
C     DENSMT  :   CALCULATES DENSITY MATRIX
C     PRECOND :   PRECONDITIONS SELECTED RESIDUAL VECTOR
C     ORTHN   :   SCHMIDT ORTHONORMALIZATION OF THE SELECTED VECTORS
C     USEROUT :   FINAL OUTPUT
C     LEADING :   PRINT DETERMINANTS WITH COEFFICIENT HIGHER THEN COMIN
C     ZZERO   :   INITIALIZES A VECTOR TO ZERO
C     NOVERI  :   CALCULATES N OVER I
C
C     FILES :
C
C      8 (MRCONEE)  : 1-ELECTRON INTEGRALS
C      9 (MDCINT)   : 2-ELECTRON COULOMB INTEGRALS
C     10 (MDBINT)   : 2-ELECTRON BREIT INTEGRALS 
C     11 (MRCTRIV)  : TRIAL VECTORS
C     12 (MRCFINV)  : FINAL VECTORS
C     13 (MRCEXCS)  : COUPLING COEFFICIENTS (TEMPORARY FILE)
C     14 (MRCVECS)  : EXPANSION VECTORS (TEMPORARY FILE)
C     15 (MRCTWOE)  : SORTED TWO-ELECTRON INTEGRALS (TEMPORARY FILE)
C
C     =======================================================================
C
#include "files.inc"
#include "param.inc"
      LOGICAL DONE
      PARAMETER (MCORE = 60 000 000)
      REAL*8, allocatable :: CI(:)
C
      MAXCORE = MCORE
      allocate(ci(mcore))
      OPEN (5,FILE='DIRAC.INP')
      CALL SETUP   (CI,DONE)
      IF (DONE) GOTO 1000
      CALL DRIVER  (CI)
      CALL USEROUT (CI)
C
C     Clean up : Throw away Scratch Files 
C
      CLOSE (MRCEXCS,STATUS='DELETE')
      CLOSE (MRCVECS,STATUS='DELETE')
      CLOSE (MRCTWOE,STATUS='DELETE')
C
 1000 deallocate(ci)
C
      END
