/* dirac_copyright_start */
/*
 *
 *     Copyright (c) by the authors of DIRAC.
 *
 *     This program is free software; you can redistribute it and/or
 *     modify it under the terms of the GNU Lesser General Public
 *     License version 2.1 as published by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *     Lesser General Public License for more details.
 *
 *     If a copy of the GNU LGPL v2.1 was not distributed with this
 *     code, you can obtain one at https://www.gnu.org/licenses/old-licenses/lgpl-2.1.en.html.
 */
/* dirac_copyright_end */

/*-*-mode: C; c-indentation-style: "bsd"; c-basic-offset: 4; -*-*/
/* fun-srvwn5.c:

   Automatically generated code implementing SRVWN5 functional and
   its derivatives. It is generated by func-codegen.pl being a part of
   a "Automatic code generation framework for analytical functional
   derivative evaluation", Pawel Salek, 2005

    This functional is connected by making following changes:
    1. add "extern Functional SRVWN5Functional;" to 'functionals.h'
    2. add "&SRVWN5Functional," to 'functionals.c'
    3. add "fun-srvwn5.c" to 'Makefile.am', 'Makefile.in' or 'Makefile'.

    This functional has been generated from following input:
    ------ cut here -------
 This routine of short-range-(LDA-VWN5)corelation contains two parts, 
 the first is the well known SVWN5 correlation, and the second is the 
 MU- dependent part from the reference:
 J. Toulouse, A. Savin and H-J Flad, IJQC  100, (6) 1047 (200).   

PI: 3.14159265358979312;
rs(rhoa,rhob):= (3/(4*PI*(rhoa+rhob)))^(1/3);
x(rhoa,rhob):= sqrt(rs(rhoa,rhob));
zeta(rhoa,rhob):= (rhoa-rhob)/(rhoa+rhob);
f(rhoa,rhob):= ((1+zeta(rhoa,rhob))^(4/3) + (1-zeta(rhoa,rhob))^(4/3) -2)/(2^(4/3)-2);
 
 Evaluate f''(0) 
d2f0: 4/(9*(2^(1/3) - 1));

 Parameters [paramagnetic, ferromagnetic, spin stiffness] 

x0:[-0.10498,-0.32500,-0.00475840];
A: [0.0621814,0.0310907,-1/(3*PI^2)];
b: [3.72744,7.06042,1.13107];
c: [12.9352,18.0578,13.0045];

 Paramagnetic contribution 
X_p(rhoa,rhob):= x(rhoa,rhob)*x(rhoa,rhob) + b[1]*x(rhoa,rhob) + c[1];
X0_p: x0[1]*x0[1] + b[1]*x0[1] + c[1];  X_p(x0) 
Q_p: sqrt(4*c[1] - b[1]*b[1]);

 Write paramagnetic functional as sum/product of 6 terms: 
t1_p(rhoa,rhob):= log(x(rhoa,rhob)^2/X_p(rhoa,rhob));
t2_p(rhoa,rhob):= (2*b[1]/Q_p)*atan(Q_p/(2*x(rhoa,rhob) + b[1]));
t3_p: b[1]*x0[1]/X0_p;
t4_p(rhoa,rhob):=log((x(rhoa,rhob) - x0[1])^2/X_p(rhoa,rhob));
t5_p: 2*(b[1] + 2*x0[1])/Q_p;
t6_p(rhoa,rhob):=atan(Q_p/(2*x(rhoa,rhob) + b[1]));

E_para(rhoa,rhob):=  0.5 * A[1]*(t1_p(rhoa,rhob) + t2_p(rhoa,rhob) - t3_p*(t4_p(rhoa,rhob) + t5_p*t6_p(rhoa,rhob)));

 dfine Mu-dependentpart (1+ C1 MU + C2  MU^2)  

 VWN5 parametrization of the lDA correlation energy 

L(rhoa,grada,rhob,gradb,gradab):=  (E_para(rhoa,rhob) )*(rhoa+rhob);


 define parameters for he MU-dependent part 

u1:1.0271;
u2:-0.2302;
v1:0.6197;

C11(rhoa,rhob):=( u1 * rs(rhoa,rhob) + u2 * (rs(rhoa,rhob))^2 );
C12(rhoa,rhob):=( 1 + v1 * rs(rhoa,rhob) );
C1(rhoa,rhob):=( C11(rhoa,rhob)/C12(rhoa,rhob) );

DC:( 32/(3*PI) );
AC:3.2581;
bet:163.44;
gam:4.7125;
gamr(rhoa,rhob):= (gam + rs(rhoa,rhob) );

g0(rhoa,rhob):=  DC * ( (gamr(rhoa,rhob))^(3/2) + bet ) * exp(-AC *sqrt(gamr(rhoa,rhob)))  ; 

C2(rhoa,rhob):= 2 * E_para(rhoa,rhob) /( PI * (rhoa+rhob) *  (g0(rhoa,rhob)  -1/2) ); 
   
dnom(rhoa,rhob):= 1 + C1(rhoa,rhob) * MU + C2(rhoa,rhob) * MU^2;

K(rhoa,grada,rhob,gradb,gradab):= L(rhoa,grada,rhob,gradb,gradab) / dnom(rhoa,rhob);



    ------ cut here -------
*/

 
/* strictly conform to XOPEN ANSI C standard */
#define _XOPEN_SOURCE          500
#define _XOPEN_SOURCE_EXTENDED 1
#include <math.h>
#include <stddef.h>
 
#define __CVERSION__
 
#include "functionals.h"
#include "dcbham.h" 
#define MU dcrham_.hfxmu

/* INTERFACE PART */
static int srvwn5_isgga(void) { return 1; } /* FIXME: detect! */
static int srvwn5_read(const char *conf_line);
static real srvwn5_energy(const FunDensProp* dp);
static void srvwn5_first(FunFirstFuncDrv *ds,   real factor,
                         const FunDensProp* dp);
static void srvwn5_second(FunSecondFuncDrv *ds, real factor,
                          const FunDensProp* dp);
 
Functional SRVWN5Functional = {
  "SRVWN5",       /* name */
  srvwn5_isgga,   /* gga-corrected */
  srvwn5_read,
  NULL,
  srvwn5_energy,
  srvwn5_first,
  srvwn5_second
};
 
/* IMPLEMENTATION PART */

static int
srvwn5_read(const char *conf_line)
{
    fun_set_hf_weight(0);
    return 1;
}



static real
srvwn5_energy(const FunDensProp *dp)
{
    real res;
    real rhoa = dp->rhoa, rhob = dp->rhob;
    real grada = dp->grada, gradb = dp->gradb, gradab = dp->gradab;

    real t1, t2, t3, t4, t5, t6, t7, t8;
    t1 = rhob+rhoa;
    t2 = 1/pow(t1,.1666666666666667);
    t3 = atan(6.15199081975908/(1.575246635799487*t2+3.72744));
    t4 = 1/
        pow(t1,.3333333333333333);
    t5 = .6203504908994001*t4;
    t6 = 1/(2.935818660072219*t2+t5+12.9352);
    t7 = log(.6203504908994001*t4*t6)+.03116760867894378*
        (log(pow(.7876233178997433*t2+0.10498,2.0)*t6)+1.143525763628415*
        t3)+1.211783342728061*t3;
    t8 = sqrt(t5+4.7125);

   /* code */
    res = 0.0310907*t1*t7/(.01979295435674876*t7*pow(MU,2.0)/
        (t1*(3.395305452627101*(pow(t8,3.0)+163.44)/pow(2.718281828459045,
        3.2581*t8)-0.5))+(.6371619892027738*t4-.08858895520491096/
        pow(t1,.6666666666666666))*MU/(.3844311992103582*t4+1.0)+1.0);

    return res;
}

static void
srvwn5_first(FunFirstFuncDrv *ds, real factor, const FunDensProp *dp)
{
    real dfdra, dfdrb, dfdga, dfdgb, dfdgab;
    real rhoa = dp->rhoa, rhob = dp->rhob;
    real grada = dp->grada, gradb = dp->gradb, gradab = dp->gradab;

    real t1, t2, t3, t4, t5, t6, t7, t8, t9, t10;
    real t11, t12, t13, t14, t15, t16, t17, t18;
    real t19, t20, t21, t22, t23, t24, t25, t26;
    real t27, t28, t29, t30, t31, t32;

    t1 = rhob+rhoa;
    t2 = 1/pow(t1,1.166666666666667);
    t3 = 1/pow(t1,.1666666666666667);
    t4 = 1.575246635799487*t3+3.72744;
    t5 = 1/pow(t4,2.0);
    t6 = 1/(37.84699104639999*t5+1.0);
    t7 = pow(t1,.3333333333333333);
    t8 = 1/t7;
    t9 = .6203504908994001*t8;
    t10 = 2.935818660072219*t3+t9+12.9352;
    t11 = 1/pow(t1,1.333333333333333);
    t12 = -.4893031100120365*t2-.2067834969664667*t11;
    t13 = 1/pow(t10,2.0);
    t14 = 1/t10;
    t15 = .7876233178997433*t3+0.10498;
    t16 = pow(t15,2.0);
    t17 = .03116760867894378*(1.846966178830659*t2*t5*t6+
        1.0*t10*(-1.0*t12*t13*t16-.2625411059665811*t2*t15*t14)/t16)+
        1.957212440048146*t2*t5*t6+1.61199195401647*t7*t10*(-.2067834969664667*
        t11*t14-.6203504908994001*t8*t12*t13);
    t18 = .3844311992103582*t8+1.0;
    t19 = 1/t18;
    t20 = .6371619892027738*t8-.08858895520491096/pow(t1,
        .6666666666666666);
    t21 = 1/t1;
    t22 = sqrt(t9+4.7125);
    t23 = pow(t22,3.0)+163.44;
    t24 = 1/pow(2.718281828459045,3.2581*t22);
    t25 = 3.395305452627101*t23*t24-0.5;
    t26 = 1/t25;
    t27 = atan(6.15199081975908/t4);
    t28 = .03116760867894378*(log(t16*t14)+1.143525763628415*
        t27)+log(.6203504908994001*t8*t14)+1.211783342728061*t27;
    t29 = pow(MU,
        2.0);
    t30 = t19*t20*MU+.01979295435674876*t21*t26*t28*t29+1.0;
    t31 = 1/
        t30;
    t32 = -0.0310907*t1*t28*(.1281437330701194*t11*t20*MU/
        pow(t18,2.0)+(.05905930346994064/pow(t1,1.666666666666667)-
        .2123873297342579*t11)*t19*MU-.01979295435674876*t26*t28*t29/
        pow(t1,2.0)-.01979295435674876*t21*(1.143744821186551*t11*
        t23*t24/t22-1.053139702145316*t11*t22*t24)*t28*t29/pow(t25,
        2.0)+.01979295435674876*t21*t17*t26*t29)/pow(t30,2.0)+0.0310907*
        t28*t31+0.0310907*t1*t17*t31;

   /* code */
    dfdra = t32;
    dfdrb = t32;
    dfdga = 0.0;
    dfdgb = 0.0;
    dfdgab = 0.0;


    ds->df1000 += factor*dfdra;
    ds->df0100 += factor*dfdrb;
    ds->df0010 += factor*dfdga;
    ds->df0001 += factor*dfdgb;
    ds->df00001+= factor*dfdgab;
   
}

static void
srvwn5_second(FunSecondFuncDrv *ds, real factor, const FunDensProp* dp)
{
    real dfdra, dfdrb, dfdga, dfdgb, dfdgab;
    real d2fdrara, d2fdrarb, d2fdraga, d2fdragb, d2fdraab, d2fdrbrb,
        d2fdrbga, d2fdrbgb, d2fdrbgab, d2fdgaga, d2fdgagb, d2fdgagab,
        d2fdgbgb, d2fdgbgab, d2fdgabgab;
    real rhoa = dp->rhoa, rhob = dp->rhob;
    real grada = dp->grada, gradb = dp->gradb, gradab = dp->gradab;

    real t1, t2, t3, t4, t5, t6, t7, t8, t9, t10;
    real t11, t12, t13, t14, t15, t16, t17, t18;
    real t19, t20, t21, t22, t23, t24, t25, t26;
    real t27, t28, t29, t30, t31, t32, t33, t34;
    real t35, t36, t37, t38, t39, t40, t41, t42;
    real t43, t44, t45, t46, t47, t48, t49, t50;
    real t51, t52, t53, t54, t55, t56, t57, t58;

    t1 = rhob+rhoa;
    t2 = 1/pow(t1,1.166666666666667);
    t3 = 1/pow(t1,.1666666666666667);
    t4 = 1.575246635799487*t3+3.72744;
    t5 = 1/pow(t4,2.0);
    t6 = 37.84699104639999*t5+1.0;
    t7 = 1/t6;
    t8 = pow(t1,.3333333333333333);
    t9 = 1/t8;
    t10 = .6203504908994001*t9;
    t11 = 2.935818660072219*t3+t10+12.9352;
    t12 = 1/pow(t1,1.333333333333333);
    t13 = -.4893031100120365*t2-.2067834969664667*t12;
    t14 = 1/pow(t11,2.0);
    t15 = 1/t11;
    t16 = -.2067834969664667*t12*t15-.6203504908994001*t9*
        t13*t14;
    t17 = .7876233178997433*t3+0.10498;
    t18 = pow(t17,2.0);
    t19 = 1/t18;
    t20 = -1.0*t13*t14*t18-.2625411059665811*t2*t17*t15;
    t21 = .03116760867894378*
        (t19*t11*t20+1.846966178830659*t2*t5*t7)+1.61199195401647*
        t8*t11*t16+1.957212440048146*t2*t5*t7;
    t22 = .3844311992103582*t9+1.0;
    t23 = 1/t22;
    t24 = 1/pow(t1,.6666666666666666);
    t25 = .6371619892027738*t9-.08858895520491096*t24;
    t26 = 1/t1;
    t27 = t10+4.7125;
    t28 = sqrt(t27);
    t29 = pow(t28,3.0);
    t30 = t29+163.44;
    t31 = 1/pow(2.718281828459045,3.2581*t28);
    t32 = 3.395305452627101*t30*t31-0.5;
    t33 = 1/t32;
    t34 = atan(6.15199081975908/t4);
    t35 = .03116760867894378*(log(t18*t15)+1.143525763628415*
        t34)+log(.6203504908994001*t9*t15)+1.211783342728061*t34;
    t36 = pow(MU,
        2.0);
    t37 = t23*t25*MU+.01979295435674876*t26*t33*t35*t36+1.0;
    t38 = 1/
        t37;
    t39 = 1/pow(t37,2.0);
    t40 = .05905930346994064/pow(t1,1.666666666666667)-.2123873297342579*
        t12;
    t41 = 1/pow(t22,2.0);
    t42 = 1/pow(t1,2.0);
    t43 = 1/pow(t32,2.0);
    t44 = 1/t28;
    t45 = 1.143744821186551*t12*t44*t30*t31-1.053139702145316*
        t12*t28*t31;
    t46 = -.01979295435674876*t26*t43*t45*t35*t36-.01979295435674876*
        t42*t33*t35*t36+.01979295435674876*t26*t21*t33*t36+.1281437330701194*
        t12*t41*t25*MU+t40*t23*MU;
    t47 = -0.0310907*t1*t35*t39*t46+0.0310907*t35*t38+0.0310907*
        t1*t21*t38;
    t48 = 1/pow(t1,2.333333333333333);
    t49 = 1/pow(t4,5.0);
    t50 = 1/pow(t6,2.0);
    t51 = 1/pow(t4,3.0);
    t52 = 1/pow(t1,2.166666666666667);
    t53 = pow(t13,2.0);
    t54 = 1/pow(t11,3.0);
    t55 = 0.570853628347376*t52+.2757113292886222*t48;
    t56 = .03116760867894378*(0.969809086546143*t48*t51*t7-
        2.154793875302436*t52*t5*t7+t11*t19*(-1.0*t14*t18*t55+2.0*
        t18*t53*t54+.03446391616107778*t48*t15+.3062979569610113*t52*
        t17*t15+.5250822119331622*t2*t13*t17*t14)-36.70435581522923*
        t48*t49*t50+.2625411059665811*t11*t2*t20/pow(t17,3.0)+t13*
        t19*t20)+1.027697437243582*t48*t51*t7-2.283414513389504*t52*
        t5*t7-38.89525570576607*t48*t49*t50+1.61199195401647*t8*t13*
        t16+.5373306513388232*t24*t11*t16+1.61199195401647*t8*t11*
        (.2757113292886222*t48*t15+.4135669939329334*t12*t13*t14-.6203504908994001*
        t9*t55*t14+1.2407009817988*t9*t53*t54);
    t57 = 1/pow(t1,2.666666666666667);
    t58 = -0.0310907*t1*t35*t39*(.03284163265029202*t25*t57*
        MU/pow(t22,3.0)+.2562874661402388*t12*t40*t41*MU-.1708583107601592*
        t48*t41*t25*MU+(.2831831063123439*t48-.09843217244990106*t57)*
        t23*MU-.01979295435674876*t26*t35*t36*t43*(.1182537768811206*
        t30*t31*t57/t29+.3852826304563791*t30*t31*t57/t27-.7095226612867237*
        t57*t31+.1088859552019158*t57*t44*t31-1.524993094915402*t48*
        t44*t30*t31+1.404186269527088*t48*t28*t31)+.03958590871349752*
        t26*t35*t36*pow(t45,2.0)/pow(t32,3.0)-.03958590871349752*t26*
        t21*t43*t45*t36+.03958590871349752*t42*t43*t45*t35*t36+.03958590871349752*
        t33*t35*t36/pow(t1,3.0)+.01979295435674876*t26*t56*t33*t36-
        .03958590871349752*t42*t21*t33*t36)+0.0621814*t1*t35*pow(t46,
        2.0)/pow(t37,3.0)-0.0621814*t35*t39*t46-0.0621814*t1*t21*t39*
        t46+0.0310907*t1*t56*t38+0.0621814*t21*t38;

   /* code */
    dfdra = t47;
    dfdrb = t47;
    dfdga = 0.0;
    dfdgb = 0.0;
    dfdgab = 0.0;
    d2fdrara = t58;
    d2fdrarb = t58;
    d2fdraga = 0.0;
    d2fdragb = 0.0;
    d2fdraab = 0.0;
    d2fdrbrb = t58;
    d2fdrbga = 0.0;
    d2fdrbgb = 0.0;
    d2fdrbgab = 0.0;
    d2fdgaga = 0.0;
    d2fdgagb = 0.0;
    d2fdgagab = 0.0;
    d2fdgbgb = 0.0;
    d2fdgbgab = 0.0;
    d2fdgabgab = 0.0;


    ds->df1000 += factor*dfdra;
    ds->df0100 += factor*dfdrb;
    ds->df0010 += factor*dfdga;
    ds->df0001 += factor*dfdgb;
    ds->df00001+= factor*dfdgab;

    ds->df2000 += factor*d2fdrara;
    ds->df1100 += factor*d2fdrarb;
    ds->df1010 += factor*d2fdraga;
    ds->df1001 += factor*d2fdragb;
    ds->df10001+= factor*d2fdraab;
    ds->df0200 += factor*d2fdrbrb;
    ds->df0110 += factor*d2fdrbga;
    ds->df0101 += factor*d2fdrbgb;
    ds->df01001+= factor*d2fdrbgab;
    ds->df0020 += factor*d2fdgaga;
    ds->df0011 += factor*d2fdgagb;
    ds->df00101+= factor*d2fdgagab;
    ds->df0002 += factor*d2fdgbgb;
    ds->df00011+= factor*d2fdgbgab;
    ds->df00002+= factor*d2fdgabgab;

}
