/* dirac_copyright_start */
/*
 *
 *     Copyright (c) by the authors of DIRAC.
 *
 *     This program is free software; you can redistribute it and/or
 *     modify it under the terms of the GNU Lesser General Public
 *     License version 2.1 as published by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *     Lesser General Public License for more details.
 *
 *     If a copy of the GNU LGPL v2.1 was not distributed with this
 *     code, you can obtain one at https://www.gnu.org/licenses/old-licenses/lgpl-2.1.en.html.
 */
/* dirac_copyright_end */

/*-*-mode: C; c-indentation-style: "bsd"; c-basic-offset: 4; -*-*/
/* fun-srpbec.c:

   Automatically generated code implementing SRPBEC functional and
   its derivatives. It is generated by func-codegen.pl being a part of
   a "Automatic code generation framework for analytical functional
   derivative evaluation", Pawel Salek, 2005

    This functional is connected by making following changes:
    1. add "extern Functional srpbecFunctional;" to 'functionals.h'
    2. add "&srpbecFunctional," to 'functionals.c'
    3. add "fun-srpbec.c" to 'Makefile.am', 'Makefile.in' or 'Makefile'.

    This functional has been generated from following input:
    ------ cut here -------
  short-range corrlation srpbec using the pbe exchange-correlation functional
    the first oart of the input define the pbec forula and the second part define 
    define intrpolation foumula for the mu-dependet of the srpbe, so that the third  
    part gives the results of th srpbc correlation functioal.      
    For further details see J. Toulouse, F. Colonna and A. Savin Phy. Rev. A 70, 062505 (2004)
 

 Prat I  
pi:3.14159265358979312;
c:1.709921;
T:[0.031091,0.015545,0.016887];
U:[0.21370,0.20548,0.11125];
V:[7.5957,14.1189,10.357];
W:[3.5876,6.1977,3.6231];
X:[1.6382,3.3662,0.88026];
Y:[0.49294,0.62517,0.49671];
P:[1,1,1];
 funktionen fuer PW92C 
r(a,b):=(3/(4*pi*(a+b)))^(1/3);
zet(a,b):=(a-b)/(a+b);
omega(z):=((1+z)^(4/3)+(1-z)^(4/3)-2)/(2^(4/3)-2);
en(r,t,u,v,w,x,y,p):=-2*t*(1+u*r)*log(1+1/(2*t*(v*sqrt(r)+w*r+x*r^(3/2)+y*r^(p+1))));

eps(a,b):=en(r(a,b),T[1],U[1],V[1],W[1],X[1],Y[1],P[1]);

 parameter fuer pbec 

iota:0.0716;
nu:16/pi*(3*pi^2)^(1/3);
kappa:0.004235;
lamda:nu*kappa;
Z:-0.001667;
Xi:23.266;
Phi:0.007389;
Lamda:8.723;
Upsilon:0.472;

 funktionen fuer pbec (closed shell!) 
theta(r):=10^(-3)*(2.568+Xi*r+Phi*r^2)/(1+Lamda*r+Upsilon*r^2+10*Phi*r^3);
phi(r):=theta(r)-Z;
sigma(ga,gb,gab):=ga*ga+gb*gb+2*gab;
d(a,b,ga,gb,gab):=sqrt(sigma(ga,gb,gab))/4/(3/pi)^(1/6)/(a+b)^(7/6);
A(a,b):=2*iota/lamda*(1/(exp(-2*iota*eps(a,b)/lamda^2)-1));
L(d,a,b):=lamda^2/(2*iota)*log((1+2*(iota*(d^2+A(a,b)*d^4))/(lamda*(1+A(a,b)*d^2+(A(a,b))^2*d^4))));
H(d,a,b):=L(d,a,b);

 kernel must be define  at the end here we define the pbec kerneland pbec(rhoa,grada,rhob,gradb,gradab)
 to use it down for mu-dependent kernel
 

pbec(rhoa,grada,rhob,gradb,gradab):=(rhoa+rhob)*(eps(rhoa,rhob)+H(d(rhoa,rhob,grada,gradb,gradab),rhoa,rhob));

 Part II 

dc:32/(3*pi);
ac:3.2581; 
betc:163.44; 
gamc:4.7125;
rho(a,b):=a + b;

 rs:=r as defined above 

grs12: sqrt( gamc+ r(rhoa,rhob) );
expgrs12: exp(-ac * grs12);
g0:dc * ( grs12**3 + betc ) * expgrs12;

d2:2/(pi * rho(rhoa,rhob) * (g0 - 1/2));
d1:-2 * pbec(rhoa,grada,rhob,gradb,gradab) *(d2**2) * sqrt( 2*pi) * rho(rhoa,rhob) * g0/ 3; 
d2:d2 * pbec(rhoa,grada,rhob,gradb,gradab);

denom:1 + d1 * MU + d2 * MU^2;

 parzt III 

K(rhoa,grada,rhob,gradb,gradab):= pbec(rhoa,grada,rhob,gradb,gradab)/ denom; 

 
   

    ------ cut here -------
*/

 
/* strictly conform to XOPEN ANSI C standard */
#define _XOPEN_SOURCE          500
#define _XOPEN_SOURCE_EXTENDED 1
#include <math.h>
#include <stddef.h>
 
#define __CVERSION__
 
#include "functionals.h"
#include "dcbham.h" 
#define MU dcrham_.hfxmu
 
/* INTERFACE PART */
static int srpbec_isgga(void) { return 1; } /* FIXME: detect! */
static int srpbec_read(const char *conf_line);
static real srpbec_energy(const FunDensProp* dp);
static void srpbec_first(FunFirstFuncDrv *ds,   real factor,
                         const FunDensProp* dp);
static void srpbec_second(FunSecondFuncDrv *ds, real factor,
                          const FunDensProp* dp);
 
Functional SrpbecFunctional = {
  "SRPBEC",       /* name */
  srpbec_isgga,   /* gga-corrected */
  srpbec_read,
  NULL,
  srpbec_energy,
  srpbec_first,
  srpbec_second
};
 
/* IMPLEMENTATION PART */
static int
srpbec_read(const char *conf_line)
{
    fun_set_hf_weight(0);
    return 1;
}



static real
srpbec_energy(const FunDensProp *dp)
{
    real res;
    real rhoa = dp->rhoa, rhob = dp->rhob;
    real grada = dp->grada, gradb = dp->gradb, gradab = dp->gradab;

    real t1, t2, t3, t4, t5, t6, t7, t8, t9, t10;
    real t11, t12, t13, t14, t15;

    t1 = rhob+rhoa;
    t2 = 1/pow(t1,.3333333333333333);
    t3 = .1325688999052018*t2+1.0;
    t4 = log(16.0818243221511/(2.225569421150688*t2+.1897004325747559/
        pow(t1,.6666666666666666)+5.98255043577108/pow(t1,.1666666666666667)+
        .8004286349993636/sqrt(t1))+1.0);
    t5 = pow(gradb,2.0)+2.0*gradab+pow(grada,2.0);
    t6 = 1/pow(t1,2.333333333333333);
    t7 = pow(t5,2.0);
    t8 = 1/pow(t1,4.666666666666667);
    t9 = pow(2.718281828459045,1.999923215200099*t3*t4)-1.0;
    t10 = 1/
        t9;
    t11 = .03109219370393603*log(2.146079601698033*(.008644866148178816*
        t7*t8*t10+.06346820609770369*t5*t6)/(0.0185525709000164*t7*
        t8/pow(t9,2.0)+.1362078224626486*t5*t6*t10+1.0)+1.0)-0.062182*
        t3*t4;
    t12 = sqrt(.6203504908994001*t2+4.7125);
    t13 = pow(t12,3.0)+163.44;
    t14 = 1/pow(2.718281828459045,3.2581*t12);
    t15 = 3.395305452627101*t13*t14-0.5;

   /* code */
    res = t1*t11/(.6366197723675814*t11*pow(MU,2.0)/t15-2.299523075142916*
        t11*t13*t14*MU/pow(t15,2.0)+1.0);

    return res;
}

static void
srpbec_first(FunFirstFuncDrv *ds, real factor, const FunDensProp *dp)
{
    real dfdra, dfdrb, dfdga, dfdgb, dfdgab;
    real rhoa = dp->rhoa, rhob = dp->rhob;
    real grada = dp->grada, gradb = dp->gradb, gradab = dp->gradab;

    real t1, t2, t3, t4, t5, t6, t7, t8, t9, t10;
    real t11, t12, t13, t14, t15, t16, t17, t18;
    real t19, t20, t21, t22, t23, t24, t25, t26;
    real t27, t28, t29, t30, t31, t32, t33, t34;
    real t35, t36, t37, t38, t39, t40, t41, t42;
    real t43, t44, t45, t46;

    t1 = rhob+rhoa;
    t2 = sqrt(t1);
    t3 = 1/pow(t1,1.333333333333333);
    t4 = -.7418564737168959*t3-.4002143174996818/pow(t2,3.0)-
        .1264669550498373/pow(t1,1.666666666666667)-.9970917392951799/
        pow(t1,1.166666666666667);
    t5 = 1/pow(t1,.3333333333333333);
    t6 = .1325688999052018*t5+1.0;
    t7 = 2.225569421150688*t5+.8004286349993636/t2+.1897004325747559/
        pow(t1,.6666666666666666)+5.98255043577108/pow(t1,.1666666666666667);
    t8 = 1/
        pow(t7,2.0);
    t9 = 16.0818243221511/t7+1.0;
    t10 = 1/t9;
    t11 = log(t9);
    t12 = pow(gradb,2.0)+2.0*gradab+pow(grada,2.0);
    t13 = 1/pow(t1,2.333333333333333);
    t14 = pow(t12,2.0);
    t15 = 1/pow(t1,4.666666666666667);
    t16 = pow(2.718281828459045,1.999923215200099*t6*t11);
    t17 = t16-
        1.0;
    t18 = 1/t17;
    t19 = .008644866148178816*t14*t15*t18+.06346820609770369*
        t12*t13;
    t20 = 1/pow(t17,2.0);
    t21 = 0.0185525709000164*t14*t15*t20+.1362078224626486*
        t12*t13*t18+1.0;
    t22 = 1/t21;
    t23 = 2.146079601698033*t19*t22+1.0;
    t24 = 1/t23;
    t25 = 1/pow(t1,3.333333333333333);
    t26 = 1/pow(t1,5.666666666666667);
    t27 = -.08837587351131707*t3*t11-32.16241380463958*t4*
        t6*t8*t10;
    t28 = 1/pow(t21,2.0);
    t29 = .03109219370393603*t24*(2.146079601698033*t22*(-
        .008644866148178816*t14*t15*t27*t20*t16-.04034270869150115*
        t14*t26*t18-0.148092480894642*t12*t25)-2.146079601698033*t19*
        (-0.0371051418000328*t14*t15*t16*t27/pow(t17,3.0)-.08657866420007654*
        t14*t26*t20-.3178182524128468*t12*t25*t18-.1362078224626486*
        t12*t13*t27*t20*t16)*t28)+.002747799777968419*t3*t11+.9999999999999999*
        t4*t6*t8*t10;
    t30 = sqrt(.6203504908994001*t5+4.7125);
    t31 = pow(t30,3.0)+163.44;
    t32 = 1/pow(2.718281828459045,3.2581*t30);
    t33 = 3.395305452627101*t31*t32-0.5;
    t34 = 1/pow(t33,2.0);
    t35 = .03109219370393603*log(t23)-0.062182*t6*t11;
    t36 = 1/t33;
    t37 = pow(MU,2.0);
    t38 = -2.299523075142916*t31*t32*t34*t35*MU+.6366197723675814*
        t36*t35*t37+1.0;
    t39 = 1/t38;
    t40 = 1/pow(t38,2.0);
    t41 = 1/t30;
    t42 = 1.143744821186551*t3*t41*t31*t32-1.053139702145316*
        t3*t30*t32;
    t43 = -1.0*t1*t35*t40*(4.599046150285831*t31*t32*t35*
        t42*MU/pow(t33,3.0)-.7746188509663191*t3*t41*t31*t32*t34*t35*
        MU+.7132551342497029*t3*t30*t32*t34*t35*MU-2.299523075142916*
        t31*t32*t34*t29*MU-.6366197723675814*t34*t42*t35*t37+.6366197723675814*
        t36*t29*t37)+t35*t39+t1*t29*t39;
    t44 = 2.146079601698033*(.03457946459271526*grada*t12*
        t15*t18+.1269364121954074*grada*t13)*t22-2.146079601698033*
        t19*(.2724156449252972*grada*t13*t18+0.0742102836000656*grada*
        t12*t15*t20)*t28;
    t45 = 2.146079601698033*(.03457946459271526*gradb*t12*
        t15*t18+.1269364121954074*gradb*t13)*t22-2.146079601698033*
        t19*(.2724156449252972*gradb*t13*t18+0.0742102836000656*gradb*
        t12*t15*t20)*t28;
    t46 = 2.146079601698033*(.03457946459271526*t12*t15*t18+
        .1269364121954074*t13)*t22-2.146079601698033*t19*(.2724156449252972*
        t13*t18+0.0742102836000656*t12*t15*t20)*t28;

   /* code */
    dfdra = t43;
    dfdrb = t43;
    dfdga = .03109219370393603*t1*t44*t24*t39-1.0*t1*t35*
        (0.0197939052782085*t36*t44*t24*t37-.07149721687901418*t31*
        t32*t34*t44*t24*MU)*t40;
    dfdgb = .03109219370393603*t1*t45*t24*t39-1.0*t1*t35*
        (0.0197939052782085*t36*t45*t24*t37-.07149721687901418*t31*
        t32*t34*t45*t24*MU)*t40;
    dfdgab = .03109219370393603*t1*t46*t24*t39-1.0*t1*t35*
        (0.0197939052782085*t36*t46*t24*t37-.07149721687901418*t31*
        t32*t34*t46*t24*MU)*t40;


    ds->df1000 += factor*dfdra;
    ds->df0100 += factor*dfdrb;
    ds->df0010 += factor*dfdga;
    ds->df0001 += factor*dfdgb;
    ds->df00001+= factor*dfdgab;
   
}

static void
srpbec_second(FunSecondFuncDrv *ds, real factor, const FunDensProp* dp)
{
    real dfdra, dfdrb, dfdga, dfdgb, dfdgab;
    real d2fdrara, d2fdrarb, d2fdraga, d2fdragb, d2fdraab, d2fdrbrb,
        d2fdrbga, d2fdrbgb, d2fdrbgab, d2fdgaga, d2fdgagb, d2fdgagab,
        d2fdgbgb, d2fdgbgab, d2fdgabgab;
    real rhoa = dp->rhoa, rhob = dp->rhob;
    real grada = dp->grada, gradb = dp->gradb, gradab = dp->gradab;

    real t1, t2, t3, t4, t5, t6, t7, t8, t9, t10;
    real t11, t12, t13, t14, t15, t16, t17, t18;
    real t19, t20, t21, t22, t23, t24, t25, t26;
    real t27, t28, t29, t30, t31, t32, t33, t34;
    real t35, t36, t37, t38, t39, t40, t41, t42;
    real t43, t44, t45, t46, t47, t48, t49, t50;
    real t51, t52, t53, t54, t55, t56, t57, t58;
    real t59, t60, t61, t62, t63, t64, t65, t66;
    real t67, t68, t69, t70, t71, t72, t73, t74;
    real t75, t76, t77, t78, t79, t80, t81, t82;
    real t83, t84, t85, t86, t87, t88, t89, t90;
    real t91, t92, t93, t94, t95, t96, t97, t98;
    real t99, t100, t101, t102, t103, t104;

    t1 = rhob+rhoa;
    t2 = sqrt(t1);
    t3 = 1/pow(t1,1.333333333333333);
    t4 = -.7418564737168959*t3-.4002143174996818/pow(t2,3.0)-
        .1264669550498373/pow(t1,1.666666666666667)-.9970917392951799/
        pow(t1,1.166666666666667);
    t5 = 1/pow(t1,.3333333333333333);
    t6 = .1325688999052018*t5+1.0;
    t7 = 2.225569421150688*t5+.8004286349993636/t2+.1897004325747559/
        pow(t1,.6666666666666666)+5.98255043577108/pow(t1,.1666666666666667);
    t8 = 1/
        pow(t7,2.0);
    t9 = 16.0818243221511/t7+1.0;
    t10 = 1/t9;
    t11 = log(t9);
    t12 = pow(grada,2.0);
    t13 = pow(gradb,2.0);
    t14 = 2.0*gradab+t13+t12;
    t15 = 1/pow(t1,2.333333333333333);
    t16 = pow(t14,2.0);
    t17 = 1/pow(t1,4.666666666666667);
    t18 = pow(2.718281828459045,1.999923215200099*t6*t11);
    t19 = t18-
        1.0;
    t20 = 1/t19;
    t21 = .008644866148178816*t16*t17*t20+.06346820609770369*
        t14*t15;
    t22 = 1/pow(t19,2.0);
    t23 = 0.0185525709000164*t16*t17*t22+.1362078224626486*
        t14*t15*t20+1.0;
    t24 = 1/t23;
    t25 = 2.146079601698033*t21*t24+1.0;
    t26 = 1/t25;
    t27 = 1/pow(t1,3.333333333333333);
    t28 = 1/pow(t1,5.666666666666667);
    t29 = -.08837587351131707*t3*t11-32.16241380463958*t4*
        t6*t8*t10;
    t30 = -.008644866148178816*t16*t17*t29*t22*t18-.04034270869150115*
        t16*t28*t20-0.148092480894642*t14*t27;
    t31 = 1/pow(t23,2.0);
    t32 = 1/pow(t19,3.0);
    t33 = -.1362078224626486*t14*t15*t29*t22*t18-0.0371051418000328*
        t16*t17*t29*t32*t18-.3178182524128468*t14*t27*t20-.08657866420007654*
        t16*t28*t22;
    t34 = 2.146079601698033*t24*t30-2.146079601698033*t21*
        t31*t33;
    t35 = .03109219370393603*t26*t34+.002747799777968419*
        t3*t11+.9999999999999999*t4*t6*t8*t10;
    t36 = .6203504908994001*t5+4.7125;
    t37 = sqrt(t36);
    t38 = pow(t37,3.0);
    t39 = t38+163.44;
    t40 = 1/pow(2.718281828459045,3.2581*t37);
    t41 = 3.395305452627101*t39*t40-0.5;
    t42 = 1/pow(t41,2.0);
    t43 = .03109219370393603*log(t25)-0.062182*t6*t11;
    t44 = 1/t41;
    t45 = pow(MU,2.0);
    t46 = -2.299523075142916*t39*t40*t42*t43*MU+.6366197723675814*
        t44*t43*t45+1.0;
    t47 = 1/t46;
    t48 = 1/pow(t46,2.0);
    t49 = 1/t37;
    t50 = 1/pow(t41,3.0);
    t51 = 1.143744821186551*t3*t49*t39*t40-1.053139702145316*
        t3*t37*t40;
    t52 = -.6366197723675814*t42*t51*t43*t45+.6366197723675814*
        t44*t35*t45+4.599046150285831*t39*t40*t50*t51*t43*MU-.7746188509663191*
        t3*t49*t39*t40*t42*t43*MU+.7132551342497029*t3*t37*t40*t42*
        t43*MU-2.299523075142916*t39*t40*t42*t35*MU;
    t53 = -1.0*t1*t43*t48*t52+t43*t47+t1*t35*t47;
    t54 = .2724156449252972*grada*t15*t20+0.0742102836000656*
        grada*t14*t17*t22;
    t55 = .03457946459271526*grada*t14*t17*t20+.1269364121954074*
        grada*t15;
    t56 = 2.146079601698033*t55*t24-2.146079601698033*t21*
        t54*t31;
    t57 = 0.0197939052782085*t44*t56*t26*t45-.07149721687901418*
        t39*t40*t42*t56*t26*MU;
    t58 = .2724156449252972*gradb*t15*t20+0.0742102836000656*
        gradb*t14*t17*t22;
    t59 = .03457946459271526*gradb*t14*t17*t20+.1269364121954074*
        gradb*t15;
    t60 = 2.146079601698033*t59*t24-2.146079601698033*t21*
        t58*t31;
    t61 = 0.0197939052782085*t44*t60*t26*t45-.07149721687901418*
        t39*t40*t42*t60*t26*MU;
    t62 = 0.0742102836000656*t14*t17*t22;
    t63 = .2724156449252972*t15*t20;
    t64 = t63+t62;
    t65 = .1269364121954074*t15;
    t66 = .03457946459271526*t14*t17*t20;
    t67 = t66+t65;
    t68 = 2.146079601698033*t67*t24-2.146079601698033*t21*
        t64*t31;
    t69 = 0.0197939052782085*t44*t68*t26*t45-.07149721687901418*
        t39*t40*t42*t68*t26*MU;
    t70 = pow(t4,2.0);
    t71 = 1/pow(t7,4.0);
    t72 = 1/pow(t9,2.0);
    t73 = 1/pow(t7,3.0);
    t74 = 1/pow(t1,2.666666666666667);
    t75 = .2107782584163954*t74+.6003214762495227/pow(t2,
        5.0)+.9891419649558612*t15+1.163273695844377/pow(t1,2.166666666666667);
    t76 = 1/
        pow(t25,2.0);
    t77 = 1/pow(t23,3.0);
    t78 = 1/pow(t1,4.333333333333333);
    t79 = 1/pow(t1,6.666666666666667);
    t80 = .1178344980150894*t15*t11-32.16241380463958*t75*
        t6*t8*t10+2.842490544251296*t3*t4*t8*t10+64.32482760927915*
        t70*t6*t73*t10-517.2302885825411*t70*t6*t71*t72;
    t81 = pow(t29,2.0);
    t82 = pow(2.718281828459045,3.999846430400197*t6*t11);
    t83 = .03109219370393603*
        t26*(-2.146079601698033*t21*t31*(.1113154254000984*t16*t17*
        t81*t82/pow(t19,4.0)+.2724156449252972*t14*t15*t81*t32*t82+
        .4906124304671004*t16*t79*t22+1.059394174709489*t14*t78*t20-
        0.0371051418000328*t16*t17*t81*t32*t18-0.0371051418000328*
        t16*t17*t80*t32*t18+.3463146568003062*t16*t28*t29*t32*t18-
        .1362078224626486*t14*t15*t81*t22*t18-.1362078224626486*t14*
        t15*t80*t22*t18+.6356365048256936*t14*t27*t29*t22*t18)+2.146079601698033*
        t24*(.01728973229635763*t16*t17*t81*t32*t82-.008644866148178816*
        t16*t17*t81*t22*t18+.08068541738300229*t16*t28*t29*t22*t18-
        .008644866148178816*t16*t17*t80*t22*t18+.2286086825851732*
        t16*t79*t20+.4936416029821399*t14*t78)+4.292159203396066*t21*
        pow(t33,2.0)*t77-4.292159203396066*t31*t30*t33)-.03109219370393603*
        pow(t34,2.0)*t76+16.0818243221511*t70*t6*t71*t72-.003663733037291225*
        t15*t11+.9999999999999999*t75*t6*t8*t10-.08837926660346784*
        t3*t4*t8*t10-2.0*t70*t6*t73*t10;
    t84 = 1/pow(t46,3.0);
    t85 = 1/t38;
    t86 = 1/t36;
    t87 = -1.524993094915402*t15*t49*t39*t40+.3852826304563791*
        t74*t86*t39*t40+.1182537768811206*t74*t85*t39*t40+1.404186269527088*
        t15*t37*t40+.1088859552019158*t74*t49*t40-.7095226612867237*
        t74*t40;
    t88 = pow(t51,2.0);
    t89 = -1.0*t1*t43*t48*(-13.79713845085749*t39*t40*t43*
        t88*MU/pow(t41,4.0)-2.299523075142916*t39*t40*t42*t83*MU+4.599046150285831*
        t39*t40*t50*t87*t43*MU+3.098475403865276*t3*t49*t39*t40*t50*
        t51*t43*MU-2.853020536998812*t3*t37*t40*t50*t51*t43*MU+.4805351844568853*
        t74*t40*t42*t43*MU-.07374469544472012*t74*t49*t40*t42*t43*
        MU-.2609386140798297*t74*t86*t39*t40*t42*t43*MU-.08008919740948088*
        t74*t85*t39*t40*t42*t43*MU+1.032825134621759*t15*t49*t39*t40*
        t42*t43*MU-.9510068456662705*t15*t37*t40*t42*t43*MU+9.198092300571663*
        t39*t40*t50*t51*t35*MU-1.549237701932638*t3*t49*t39*t40*t42*
        t35*MU+1.426510268499406*t3*t37*t40*t42*t35*MU+.6366197723675814*
        t44*t83*t45+1.273239544735163*t50*t88*t43*t45-.6366197723675814*
        t42*t87*t43*t45-1.273239544735163*t42*t51*t35*t45)+2.0*t1*
        t43*pow(t52,2.0)*t84-2.0*t43*t48*t52-2.0*t1*t35*t48*t52+t1*
        t83*t47+2.0*t35*t47;
    t90 = .03109219370393603*t26*(-2.146079601698033*t55*
        t31*t33+4.292159203396066*t21*t54*t77*t33-2.146079601698033*
        t21*t31*(-.2724156449252972*grada*t15*t29*t22*t18-.1484205672001312*
        grada*t14*t17*t29*t32*t18-.6356365048256936*grada*t27*t20-
        .3463146568003062*grada*t14*t28*t22)-2.146079601698033*t54*
        t31*t30+2.146079601698033*t24*(-.03457946459271526*grada*t14*
        t17*t29*t22*t18-.1613708347660046*grada*t14*t28*t20-.2961849617892839*
        grada*t27))-.03109219370393603*t56*t76*t34;
    t91 = 2.0*t1*t43*t52*t57*t84-1.0*t43*t48*t57-1.0*t1*t35*
        t48*t57-.03109219370393603*t1*t56*t26*t48*t52-1.0*t1*t43*(.6366197723675814*
        t44*t90*t45-0.0197939052782085*t42*t51*t56*t26*t45-2.299523075142916*
        t39*t40*t42*t90*MU+.1429944337580284*t39*t40*t50*t51*t56*t26*
        MU-.02408459936096515*t3*t49*t39*t40*t42*t56*t26*MU+.02217666679441866*
        t3*t37*t40*t42*t56*t26*MU)*t48+t1*t90*t47+.03109219370393603*
        t56*t26*t47;
    t92 = .03109219370393603*t26*(-2.146079601698033*t59*
        t31*t33+4.292159203396066*t21*t58*t77*t33-2.146079601698033*
        t21*t31*(-.2724156449252972*gradb*t15*t29*t22*t18-.1484205672001312*
        gradb*t14*t17*t29*t32*t18-.6356365048256936*gradb*t27*t20-
        .3463146568003062*gradb*t14*t28*t22)-2.146079601698033*t58*
        t31*t30+2.146079601698033*t24*(-.03457946459271526*gradb*t14*
        t17*t29*t22*t18-.1613708347660046*gradb*t14*t28*t20-.2961849617892839*
        gradb*t27))-.03109219370393603*t60*t76*t34;
    t93 = 2.0*t1*t43*t52*t61*t84-1.0*t43*t48*t61-1.0*t1*t35*
        t48*t61-.03109219370393603*t1*t60*t26*t48*t52-1.0*t1*t43*(.6366197723675814*
        t44*t92*t45-0.0197939052782085*t42*t51*t60*t26*t45-2.299523075142916*
        t39*t40*t42*t92*MU+.1429944337580284*t39*t40*t50*t51*t60*t26*
        MU-.02408459936096515*t3*t49*t39*t40*t42*t60*t26*MU+.02217666679441866*
        t3*t37*t40*t42*t60*t26*MU)*t48+t1*t92*t47+.03109219370393603*
        t60*t26*t47;
    t94 = .03109219370393603*t26*(-2.146079601698033*t67*
        t31*t33+4.292159203396066*t21*t64*t77*t33-2.146079601698033*
        t21*t31*(-.2724156449252972*t15*t29*t22*t18-.1484205672001312*
        t14*t17*t29*t32*t18-.6356365048256936*t27*t20-.3463146568003062*
        t14*t28*t22)-2.146079601698033*t64*t31*t30+2.146079601698033*
        t24*(-.03457946459271526*t14*t17*t29*t22*t18-.1613708347660046*
        t14*t28*t20-.2961849617892839*t27))-.03109219370393603*t68*
        t76*t34;
    t95 = 2.0*t1*t43*t52*t69*t84-1.0*t43*t48*t69-1.0*t1*t35*
        t48*t69-.03109219370393603*t1*t68*t26*t48*t52-1.0*t1*t43*(.6366197723675814*
        t44*t94*t45-0.0197939052782085*t42*t51*t68*t26*t45-2.299523075142916*
        t39*t40*t42*t94*MU+.1429944337580284*t39*t40*t50*t51*t68*t26*
        MU-.02408459936096515*t3*t49*t39*t40*t42*t68*t26*MU+.02217666679441866*
        t3*t37*t40*t42*t68*t26*MU)*t48+t1*t94*t47+.03109219370393603*
        t68*t26*t47;
    t96 = pow(t56,2.0);
    t97 = 4.292159203396066*t21*pow(t54,2.0)*t77-2.146079601698033*
        t21*(t63+t62+.1484205672001312*t12*t17*t22)*t31-4.292159203396066*
        t55*t54*t31+2.146079601698033*(t66+.06915892918543053*t12*
        t17*t20+t65)*t24;
    t98 = .1484205672001312*grada*gradb*t17*t24*t20-.3185223517406537*
        grada*gradb*t17*t21*t31*t22-2.146079601698033*t55*t58*t31-
        2.146079601698033*t59*t54*t31+4.292159203396066*t21*t54*t58*
        t77;
    t99 = .1484205672001312*grada*t17*t24*t20-.3185223517406537*
        grada*t17*t21*t31*t22-2.146079601698033*t67*t54*t31-2.146079601698033*
        t55*t64*t31+4.292159203396066*t21*t64*t54*t77;
    t100 = pow(t60,2.0);
    t101 = 4.292159203396066*t21*pow(t58,2.0)*t77-2.146079601698033*
        t21*(t63+t62+.1484205672001312*t13*t17*t22)*t31-4.292159203396066*
        t59*t58*t31+2.146079601698033*(t66+.06915892918543053*t13*
        t17*t20+t65)*t24;
    t102 = .1484205672001312*gradb*t17*t24*t20-.3185223517406537*
        gradb*t17*t21*t31*t22-2.146079601698033*t67*t58*t31-2.146079601698033*
        t59*t64*t31+4.292159203396066*t21*t64*t58*t77;
    t103 = pow(t68,2.0);
    t104 = 4.292159203396066*t21*pow(t64,2.0)*t77-4.292159203396066*
        t67*t64*t31-.3185223517406537*t17*t21*t31*t22+.1484205672001312*
        t17*t24*t20;

   /* code */
    dfdra = t53;
    dfdrb = t53;
    dfdga = .03109219370393603*t1*t56*t26*t47-1.0*t1*t43*
        t48*t57;
    dfdgb = .03109219370393603*t1*t60*t26*t47-1.0*t1*t43*
        t48*t61;
    dfdgab = .03109219370393603*t1*t68*t26*t47-1.0*t1*t43*
        t48*t69;
    d2fdrara = t89;
    d2fdrarb = t89;
    d2fdraga = t91;
    d2fdragb = t93;
    d2fdraab = t95;
    d2fdrbrb = t89;
    d2fdrbga = t91;
    d2fdrbgb = t93;
    d2fdrbgab = t95;
    d2fdgaga = 2.0*t1*t43*pow(t57,2.0)*t84-.06218438740787206*
        t1*t56*t26*t57*t48-1.0*t1*t43*(0.0197939052782085*t44*t97*
        t26*t45-0.0197939052782085*t44*t96*t76*t45-.07149721687901418*
        t39*t40*t42*t97*t26*MU+.07149721687901418*t39*t40*t42*t96*
        t76*MU)*t48-.03109219370393603*t1*t96*t76*t47+.03109219370393603*
        t1*t97*t26*t47;
    d2fdgagb = 2.0*t1*t43*t57*t61*t84-.03109219370393603*
        t1*t56*t26*t61*t48-.03109219370393603*t1*t60*t26*t57*t48-1.0*
        t1*t43*(0.0197939052782085*t44*t26*t98*t45-0.0197939052782085*
        t44*t56*t60*t76*t45-.07149721687901418*t39*t40*t42*t26*t98*
        MU+.07149721687901418*t39*t40*t42*t56*t60*t76*MU)*t48+.03109219370393603*
        t1*t26*t98*t47-.03109219370393603*t1*t56*t60*t76*t47;
    d2fdgagab = 2.0*t1*t43*t57*t69*t84-.03109219370393603*
        t1*t56*t26*t69*t48-.03109219370393603*t1*t68*t26*t57*t48-1.0*
        t1*t43*(0.0197939052782085*t44*t26*t99*t45-0.0197939052782085*
        t44*t68*t56*t76*t45-.07149721687901418*t39*t40*t42*t26*t99*
        MU+.07149721687901418*t39*t40*t42*t68*t56*t76*MU)*t48+.03109219370393603*
        t1*t26*t99*t47-.03109219370393603*t1*t68*t56*t76*t47;
    d2fdgbgb = 2.0*t1*t43*pow(t61,2.0)*t84-.06218438740787206*
        t1*t60*t26*t61*t48-1.0*t1*t43*(0.0197939052782085*t44*t101*
        t26*t45-0.0197939052782085*t44*t100*t76*t45-.07149721687901418*
        t39*t40*t42*t101*t26*MU+.07149721687901418*t39*t40*t42*t100*
        t76*MU)*t48-.03109219370393603*t1*t100*t76*t47+.03109219370393603*
        t1*t101*t26*t47;
    d2fdgbgab = 2.0*t1*t43*t61*t69*t84-.03109219370393603*
        t1*t60*t26*t69*t48-.03109219370393603*t1*t68*t26*t61*t48-1.0*
        t1*t43*(0.0197939052782085*t44*t26*t102*t45-0.0197939052782085*
        t44*t68*t60*t76*t45-.07149721687901418*t39*t40*t42*t26*t102*
        MU+.07149721687901418*t39*t40*t42*t68*t60*t76*MU)*t48-.03109219370393603*
        t1*t68*t60*t76*t47+.03109219370393603*t1*t26*t102*t47;
    d2fdgabgab = 2.0*t1*t43*pow(t69,2.0)*t84-.06218438740787206*
        t1*t68*t26*t69*t48-1.0*t1*t43*(0.0197939052782085*t44*t26*
        t104*t45-0.0197939052782085*t44*t103*t76*t45-.07149721687901418*
        t39*t40*t42*t26*t104*MU+.07149721687901418*t39*t40*t42*t103*
        t76*MU)*t48-.03109219370393603*t1*t103*t76*t47+.03109219370393603*
        t1*t26*t104*t47;


    ds->df1000 += factor*dfdra;
    ds->df0100 += factor*dfdrb;
    ds->df0010 += factor*dfdga;
    ds->df0001 += factor*dfdgb;
    ds->df00001+= factor*dfdgab;

    ds->df2000 += factor*d2fdrara;
    ds->df1100 += factor*d2fdrarb;
    ds->df1010 += factor*d2fdraga;
    ds->df1001 += factor*d2fdragb;
    ds->df10001+= factor*d2fdraab;
    ds->df0200 += factor*d2fdrbrb;
    ds->df0110 += factor*d2fdrbga;
    ds->df0101 += factor*d2fdrbgb;
    ds->df01001+= factor*d2fdrbgab;
    ds->df0020 += factor*d2fdgaga;
    ds->df0011 += factor*d2fdgagb;
    ds->df00101+= factor*d2fdgagab;
    ds->df0002 += factor*d2fdgbgb;
    ds->df00011+= factor*d2fdgbgab;
    ds->df00002+= factor*d2fdgabgab;

}
