/* dirac_copyright_start */
/*
 *
 *     Copyright (c) by the authors of DIRAC.
 *
 *     This program is free software; you can redistribute it and/or
 *     modify it under the terms of the GNU Lesser General Public
 *     License version 2.1 as published by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *     Lesser General Public License for more details.
 *
 *     If a copy of the GNU LGPL v2.1 was not distributed with this
 *     code, you can obtain one at https://www.gnu.org/licenses/old-licenses/lgpl-2.1.en.html.
 */
/* dirac_copyright_end */

/*-*-mode: C; c-indentation-style: "bsd"; c-basic-offset: 4; -*-*/
/* fun-rpbex.c:

   Automatically generated code implementing RPBEX functional and
   its derivatives. It is generated by func-codegen.pl being a part of
   a "Automatic code generation framework for analytical functional
   derivative evaluation", Pawel Salek, 2005

    This functional is connected by making following changes:
    1. add "extern Functional rpbexFunctional;" to 'functionals.h'
    2. add "&rpbexFunctional," to 'functionals.c'
    3. add "fun-rpbex.c" to 'Makefile.am', 'Makefile.in' or 'Makefile'.

    This functional has been generated from following input:
    ------ cut here -------

 The revised PBE functional is one improved version of PBE for details see 
    B. Hammer, L. B. Hansen and  J. K. Norkov, Phy. Rev. B. 59 (11), 7413 (1999).   

pi:3.14159265358979312;

xa:sqrt(grada*grada)/rhoa^(4/3);
xb:sqrt(gradb*gradb)/rhob^(4/3);

 parameters for pbex 
R:0.804;
d:0.066725;
mu:d*pi^2/3;
Sa:xa/(2*(6*pi^2)^(1/3));
Sb:xb/(2*(6*pi^2)^(1/3));

 functions for pbex 
F(S):=1+R*(1-exp(-mu*S^2/R));
Ea(n):=-3/(4*pi)*(3*pi^2)^(1/3)*n^(4/3)*F(Sa);
Eb(n):=-3/(4*pi)*(3*pi^2)^(1/3)*n^(4/3)*F(Sb);

 kernel 
K(rhoa,grada,rhob,gradb,gradab):=0.5*(Ea(2*rhoa)+Eb(2*rhob));

    ------ cut here -------
*/

 
/* strictly conform to XOPEN ANSI C standard */
#define _XOPEN_SOURCE          500
#define _XOPEN_SOURCE_EXTENDED 1
#include <math.h>
#include <stddef.h>
 
#define __CVERSION__
 
#include "functionals.h"
 
/* INTERFACE PART */
static int rpbex_isgga(void) { return 1; } /* FIXME: detect! */
static int rpbex_read(const char *conf_line);
static real rpbex_energy(const FunDensProp* dp);
static void rpbex_first(FunFirstFuncDrv *ds,   real factor,
                         const FunDensProp* dp);
static void rpbex_second(FunSecondFuncDrv *ds, real factor,
                          const FunDensProp* dp);
 
Functional RpbexFunctional = {
  "RPBEX",       /* name */
  rpbex_isgga,   /* gga-corrected */
  rpbex_read,
  NULL,
  rpbex_energy,
  rpbex_first,
  rpbex_second
};
 
/* IMPLEMENTATION PART */
static int
rpbex_read(const char *conf_line)
{
    fun_set_hf_weight(0);
    return 1;
}



static real
rpbex_energy(const FunDensProp *dp)
{
    real res;
    real rhoa = dp->rhoa, rhob = dp->rhob;
    real grada = dp->grada, gradb = dp->gradb, gradab = dp->gradab;

    real t1;

    t1 = pow(2.0,.3333333333333333);

   /* code */
    res = 0.5*(-1.477117532764045*(0.804*(1.0-1.0/pow(2.718281828459045,
        .004492799480231091*pow(gradb,2.0)/pow(rhob,2.666666666666667)))+
        1.0)*t1*pow(rhob,1.333333333333333)-1.477117532764045*(0.804*
        (1.0-1.0/pow(2.718281828459045,.004492799480231091*pow(grada,
        2.0)/pow(rhoa,2.666666666666667)))+1.0)*t1*pow(rhoa,1.333333333333333));

    return res;
}

static void
rpbex_first(FunFirstFuncDrv *ds, real factor, const FunDensProp *dp)
{
    real dfdra, dfdrb, dfdga, dfdgb, dfdgab;
    real rhoa = dp->rhoa, rhob = dp->rhob;
    real grada = dp->grada, gradb = dp->gradb, gradab = dp->gradab;

    real t1, t2, t3, t4, t5;

    t1 = pow(2.0,.3333333333333333);
    t2 = pow(grada,2.0);
    t3 = 1/pow(2.718281828459045,.004492799480231091*t2/pow(rhoa,
        2.666666666666667));
    t4 = pow(gradb,2.0);
    t5 = 1/pow(2.718281828459045,.004492799480231091*t4/pow(rhob,
        2.666666666666667));

   /* code */
    dfdra = 0.5*(.01422842634210079*t1*t2*t3/pow(rhoa,2.333333333333333)-
        1.969490043685393*t1*(0.804*(1.0-1.0*t3)+1.0)*pow(rhoa,.3333333333333333));
    dfdrb = 0.5*
        (.01422842634210079*t1*t4*t5/pow(rhob,2.333333333333333)-1.969490043685393*
        t1*(0.804*(1.0-1.0*t5)+1.0)*pow(rhob,.3333333333333333));
    dfdga = -
        .005335659878287795*t1*t3*grada/pow(rhoa,1.333333333333333);
    dfdgb = -
        .005335659878287795*t1*t5*gradb/pow(rhob,1.333333333333333);
    dfdgab = 0.0;


    ds->df1000 += factor*dfdra;
    ds->df0100 += factor*dfdrb;
    ds->df0010 += factor*dfdga;
    ds->df0001 += factor*dfdgb;
    ds->df00001+= factor*dfdgab;
   
}

static void
rpbex_second(FunSecondFuncDrv *ds, real factor, const FunDensProp* dp)
{
    real dfdra, dfdrb, dfdga, dfdgb, dfdgab;
    real d2fdrara, d2fdrarb, d2fdraga, d2fdragb, d2fdraab, d2fdrbrb,
        d2fdrbga, d2fdrbgb, d2fdrbgab, d2fdgaga, d2fdgagb, d2fdgagab,
        d2fdgbgb, d2fdgbgab, d2fdgabgab;
    real rhoa = dp->rhoa, rhob = dp->rhob;
    real grada = dp->grada, gradb = dp->gradb, gradab = dp->gradab;

    real t1, t2, t3, t4, t5, t6, t7, t8, t9, t10;
    real t11;

    t1 = pow(2.0,.3333333333333333);
    t2 = pow(grada,2.0);
    t3 = 1/pow(2.718281828459045,.004492799480231091*t2/pow(rhoa,
        2.666666666666667));
    t4 = 0.804*(1.0-1.0*t3)+1.0;
    t5 = 1/pow(rhoa,2.333333333333333);
    t6 = pow(gradb,2.0);
    t7 = 1/pow(2.718281828459045,.004492799480231091*t6/pow(rhob,
        2.666666666666667));
    t8 = 0.804*(1.0-1.0*t7)+1.0;
    t9 = 1/pow(rhob,2.333333333333333);
    t10 = 1/pow(rhoa,1.333333333333333);
    t11 = 1/pow(rhob,1.333333333333333);

   /* code */
    dfdra = 0.5*(.01422842634210079*t1*t2*t5*t3-1.969490043685393*
        t1*t4*pow(rhoa,.3333333333333333));
    dfdrb = 0.5*(.01422842634210079*t1*t6*t9*t7-1.969490043685393*
        t1*t8*pow(rhob,.3333333333333333));
    dfdga = -.005335659878287795*t1*grada*t10*t3;
    dfdgb = -.005335659878287795*t1*gradb*t11*t7;
    dfdgab = 0.0;
    d2fdrara = 0.5*(1.704679105981247E-4*t1*t3*pow(grada,
        4.0)/pow(rhoa,6.0)-.01422842634210079*t1*t2*t3/pow(rhoa,3.333333333333333)-
        .6564966812284643*t1*t4/pow(rhoa,.6666666666666666));
    d2fdrarb = 0.0;
    d2fdraga = 0.5*(.01422842634210079*t1*grada*t5*t3-1.2785093294859354E-4*
        t1*t3*pow(grada,3.0)/pow(rhoa,5.0));
    d2fdragb = 0.0;
    d2fdraab = 0.0;
    d2fdrbrb = 0.5*(1.704679105981247E-4*t1*t7*pow(gradb,
        4.0)/pow(rhob,6.0)-.01422842634210079*t1*t6*t7/pow(rhob,3.333333333333333)-
        .6564966812284643*t1*t8/pow(rhob,.6666666666666666));
    d2fdrbga = 0.0;
    d2fdrbgb = 0.5*(.01422842634210079*t1*gradb*t9*t7-1.2785093294859354E-4*
        t1*t7*pow(gradb,3.0)/pow(rhob,5.0));
    d2fdrbgab = 0.0;
    d2fdgaga = 4.794409985572258E-5*t1*t2*t3/pow(rhoa,4.0)-
        .005335659878287795*t1*t10*t3;
    d2fdgagb = 0.0;
    d2fdgagab = 0.0;
    d2fdgbgb = 4.794409985572258E-5*t1*t6*t7/pow(rhob,4.0)-
        .005335659878287795*t1*t11*t7;
    d2fdgbgab = 0.0;
    d2fdgabgab = 0.0;


    ds->df1000 += factor*dfdra;
    ds->df0100 += factor*dfdrb;
    ds->df0010 += factor*dfdga;
    ds->df0001 += factor*dfdgb;
    ds->df00001+= factor*dfdgab;

    ds->df2000 += factor*d2fdrara;
    ds->df1100 += factor*d2fdrarb;
    ds->df1010 += factor*d2fdraga;
    ds->df1001 += factor*d2fdragb;
    ds->df10001+= factor*d2fdraab;
    ds->df0200 += factor*d2fdrbrb;
    ds->df0110 += factor*d2fdrbga;
    ds->df0101 += factor*d2fdrbgb;
    ds->df01001+= factor*d2fdrbgab;
    ds->df0020 += factor*d2fdgaga;
    ds->df0011 += factor*d2fdgagb;
    ds->df00101+= factor*d2fdgagab;
    ds->df0002 += factor*d2fdgbgb;
    ds->df00011+= factor*d2fdgbgab;
    ds->df00002+= factor*d2fdgabgab;

}
