/* dirac_copyright_start */
/*
 *
 *     Copyright (c) by the authors of DIRAC.
 *
 *     This program is free software; you can redistribute it and/or
 *     modify it under the terms of the GNU Lesser General Public
 *     License version 2.1 as published by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *     Lesser General Public License for more details.
 *
 *     If a copy of the GNU LGPL v2.1 was not distributed with this
 *     code, you can obtain one at https://www.gnu.org/licenses/old-licenses/lgpl-2.1.en.html.
 */
/* dirac_copyright_end */

/* Automatically generated functional code: pw91x
   Maxima input:
    >> PI:    3.14159265358979312;
    >> 
    >> rho:  rhoa + rhob;
    >> grad: sqrt(grada*grada + gradb*gradb + 2*gradab);
    >> zeta: (rhoa-rhob)/(rhoa+rhob);
    >> 
    >> kfa: (6*PI*PI*rhoa)^(1/3);
    >> kfb: (6*PI*PI*rhob)^(1/3);
    >> exa: -3*kfa/(4*PI);
    >> exb: -3*kfb/(4*PI);
    >> 
    >> sa:  grada/(2*kfa*rhoa);
    >> sb:  gradb/(2*kfb*rhob);
    >> F0a: 1+0.19645*sa*asinh(7.7956*sa);
    >> F0b: 1+0.19645*sb*asinh(7.7956*sb);
    >> F1a: F0a + (0.2743-0.1508*exp(-100*sa^2))*sa^2;
    >> F1b: F0b + (0.2743-0.1508*exp(-100*sb^2))*sb^2;
    >> F2a: F0a + 0.004*sa^4;
    >> F2b: F0b + 0.004*sb^4;
    >> Fa: F1a/F2a;
    >> Fb: F1b/F2b;
    >> 
    >> Exa: 2*rhoa*exa*Fa;
    >> Exb: 2*rhob*exb*Fb;
    >> 
    >> K(rhoa,rhob,grada,gradb,gradab):=(Exa+Exb)/2;
*/

#include <math.h>
#include <stddef.h>

#define __CVERSION__

#include "functionals.h"
#define LOG log
#define ABS fabs
#define ASINH asinh
#define SQRT sqrt

/* INTERFACE PART */
static int pw91x_read(const char* conf_line);
static real pw91x_energy(const FunDensProp* dp);
static void pw91x_first(FunFirstFuncDrv *ds, real factor, 
                        const FunDensProp* dp);
static void pw91x_second(FunSecondFuncDrv *ds, real factor,
                         const FunDensProp* dp);
static void pw91x_third(FunThirdFuncDrv *ds, real factor,
                        const FunDensProp* dp);

Functional PW91xFunctional = {
  "PW91x",
  fun_true,
  pw91x_read,
  NULL,
  pw91x_energy,
  pw91x_first,
  pw91x_second,
  pw91x_third
};

/* IMPLEMENTATION PART */
static int
pw91x_read(const char* conf_line)
{
    fun_set_hf_weight(0);
    return 1;
}


static real
pw91x_energy(const FunDensProp* dp)
{
    real t[11],zk;
    real rhoa = dp->rhoa;
    real rhob = dp->rhob;
    real grada = dp->grada;
    real gradb = dp->gradb;

    t[1] = pow(rhoa,1.333333333333333);
    t[2] = 1/t[1];
    t[3] = 0.02520026100493*grada*ASINH(1.000005877780776*grada*t[2])*t[2];
    t[4] = pow(grada,2.0);
    t[5] = 1/pow(rhoa,2.666666666666667);
    t[6] = pow(rhob,1.333333333333333);
    t[7] = 1/t[6];
    t[8] = 0.02520026100493*gradb*ASINH(1.000005877780776*gradb*t[7])*t[7];
    t[9] = pow(gradb,2.0);
    t[10] = 1/pow(rhob,2.666666666666667);
    zk = 0.5*(-1.8610514726982*t[6]*(0.01645530784602*(0.2743-0.1508/pow(2.718281828459045,1.645530784602056*t[9]*t[10]))*t[10]*t[9]+t[8]+1.0)/(1.083108625229223E-6*pow(gradb,4.0)/pow(rhob,5.333333333333333)+t[8]+1.0)-1.8610514726982*t[1]*(0.01645530784602*(0.2743-0.1508/pow(2.718281828459045,1.645530784602056*t[4]*t[5]))*t[4]*t[5]+t[3]+1.0)/(1.083108625229223E-6*pow(grada,4.0)/pow(rhoa,5.333333333333333)+t[3]+1.0));
    return zk;
}

static void
pw91x_first(FunFirstFuncDrv *ds, real factor, const FunDensProp* dp)
{
    real t[45];
    real dfdra, dfdrb, dfdga, dfdgb, dfdab;
    real rhoa = dp->rhoa;
    real rhob = dp->rhob;
    real grada = dp->grada;
    real gradb = dp->gradb;

    t[1] = pow(grada,4.0);
    t[2] = 1/pow(rhoa,5.333333333333333);
    t[3] = pow(rhoa,1.333333333333333);
    t[4] = 1/t[3];
    t[5] = ASINH(1.000005877780776*grada*t[4]);
    t[6] = 0.02520026100493*grada*t[5]*t[4];
    t[7] = t[6]+1.083108625229223E-6*t[1]*t[2]+1.0;
    t[8] = 1/t[7];
    t[9] = pow(grada,2.0);
    t[10] = 1/pow(rhoa,2.666666666666667);
    t[11] = 1/pow(2.718281828459045,1.645530784602056*t[9]*t[10]);
    t[12] = 0.2743-0.1508*t[11];
    t[13] = t[6]+0.01645530784602*t[9]*t[10]*t[12]+1.0;
    t[14] = 1/pow(rhoa,6.333333333333333);
    t[15] = 1/SQRT(1.0000117555961*t[9]*t[10]+1.0);
    t[16] = 1/pow(rhoa,3.666666666666667);
    t[17] = -0.03360054550205*t[9]*t[15]*t[16];
    t[18] = -0.03360034800657*t[5]*grada/pow(rhoa,2.333333333333334);
    t[19] = 1/pow(t[7],2.0);
    t[20] = pow(gradb,4.0);
    t[21] = 1/pow(rhob,5.333333333333333);
    t[22] = pow(rhob,1.333333333333333);
    t[23] = 1/t[22];
    t[24] = ASINH(1.000005877780776*gradb*t[23]);
    t[25] = 0.02520026100493*gradb*t[24]*t[23];
    t[26] = t[25]+1.083108625229223E-6*t[20]*t[21]+1.0;
    t[27] = 1/t[26];
    t[28] = pow(gradb,2.0);
    t[29] = 1/pow(rhob,2.666666666666667);
    t[30] = 1/pow(2.718281828459045,1.645530784602056*t[28]*t[29]);
    t[31] = 0.2743-0.1508*t[30];
    t[32] = 0.01645530784602*t[28]*t[29]*t[31]+t[25]+1.0;
    t[33] = 1/pow(rhob,6.333333333333333);
    t[34] = 1/SQRT(1.0000117555961*t[28]*t[29]+1.0);
    t[35] = 1/pow(rhob,3.666666666666667);
    t[36] = -0.03360054550205*t[28]*t[34]*t[35];
    t[37] = -0.03360034800657*t[24]*gradb/pow(rhob,2.333333333333334);
    t[38] = 1/pow(t[26],2.0);
    t[39] = pow(grada,3.0);
    t[40] = 0.02520040912654*grada*t[15]*t[10];
    t[41] = 0.02520026100493*t[5]*t[4];
    t[42] = pow(gradb,3.0);
    t[43] = 0.02520040912654*gradb*t[34]*t[29];
    t[44] = 0.02520026100493*t[24]*t[23];
    dfdra = 0.5*(-2.4814019635976*t[13]*t[8]*pow(rhoa,0.33333333333333)+1.8610514726982*(t[18]+t[17]-5.776579334555857E-6*t[1]*t[14])*t[19]*t[3]*t[13]-1.8610514726982*t[8]*t[3]*(-0.01088885204564*t[1]*t[14]*t[11]-0.04388082092272*t[9]*t[16]*t[12]+t[18]+t[17]));
    dfdrb = 0.5*(-2.4814019635976*t[27]*t[32]*pow(rhob,0.33333333333333)+1.8610514726982*(t[37]+t[36]-5.776579334555857E-6*t[20]*t[33])*t[38]*t[22]*t[32]-1.8610514726982*t[27]*t[22]*(-0.01088885204564*t[20]*t[33]*t[30]-0.04388082092272*t[28]*t[35]*t[31]+t[37]+t[36]));
    dfdga = 0.5*(1.8610514726982*(t[41]+t[40]+4.332434500916893E-6*t[39]*t[2])*t[19]*t[3]*t[13]-1.8610514726982*t[8]*t[3]*(0.00816663903423*t[39]*t[2]*t[11]+0.03291061569204*grada*t[10]*t[12]+t[41]+t[40]));
    dfdgb = 0.5*(1.8610514726982*(t[44]+t[43]+4.332434500916893E-6*t[42]*t[21])*t[38]*t[22]*t[32]-1.8610514726982*t[27]*t[22]*(0.00816663903423*t[42]*t[21]*t[30]+0.03291061569204*gradb*t[29]*t[31]+t[44]+t[43]));
    dfdab = 0.0;
    ds->df1000 += factor*dfdra;
    ds->df0100 += factor*dfdrb;
    ds->df0010 += factor*dfdga;
    ds->df0001 += factor*dfdgb;
    ds->df00001 += factor*dfdab;
}

static void
pw91x_second(FunSecondFuncDrv *ds, real factor, const FunDensProp* dp)
{
    real t[83];
    real dfdra, dfdrb, dfdga, dfdgb, dfdab;
    real d2fdraga, d2fdrara, d2fdrarb, d2fdragb, d2fdrbrb;
    real d2fdrbgb, d2fdgaga, d2fdgbgb, d2fdrbga;
    real d2fdraab, d2fdrbab;
    real d2fdgaab, d2fdgbab, d2fdabab, d2fdgagb;
    real rhoa = dp->rhoa;
    real rhob = dp->rhob;
    real grada = dp->grada;
    real gradb = dp->gradb;

    t[1] = pow(grada,4.0);
    t[2] = 1/pow(rhoa,5.333333333333333);
    t[3] = pow(rhoa,1.333333333333333);
    t[4] = 1/t[3];
    t[5] = ASINH(1.000005877780776*grada*t[4]);
    t[6] = 0.02520026100493*grada*t[5]*t[4];
    t[7] = t[6]+1.083108625229223E-6*t[1]*t[2]+1.0;
    t[8] = 1/t[7];
    t[9] = pow(rhoa,0.33333333333333);
    t[10] = pow(grada,2.0);
    t[11] = 1/pow(rhoa,2.666666666666667);
    t[12] = 1/pow(2.718281828459045,1.645530784602056*t[10]*t[11]);
    t[13] = 0.2743-0.1508*t[12];
    t[14] = t[6]+0.01645530784602*t[10]*t[11]*t[13]+1.0;
    t[15] = 1/pow(rhoa,6.333333333333333);
    t[16] = SQRT(1.0000117555961*t[10]*t[11]+1.0);
    t[17] = 1/t[16];
    t[18] = 1/pow(rhoa,3.666666666666667);
    t[19] = -0.03360054550205*t[10]*t[17]*t[18];
    t[20] = 1/pow(rhoa,2.333333333333334);
    t[21] = -0.03360034800657*grada*t[5]*t[20];
    t[22] = t[21]+t[19]-5.776579334555857E-6*t[1]*t[15];
    t[23] = 1/pow(t[7],2.0);
    t[24] = -0.01088885204564*t[1]*t[15]*t[12]-0.04388082092272*t[10]*t[18]*t[13]+t[21]+t[19];
    t[25] = pow(gradb,4.0);
    t[26] = 1/pow(rhob,5.333333333333333);
    t[27] = pow(rhob,1.333333333333333);
    t[28] = 1/t[27];
    t[29] = ASINH(1.000005877780776*gradb*t[28]);
    t[30] = 0.02520026100493*gradb*t[29]*t[28];
    t[31] = t[30]+1.083108625229223E-6*t[25]*t[26]+1.0;
    t[32] = 1/t[31];
    t[33] = pow(rhob,0.33333333333333);
    t[34] = pow(gradb,2.0);
    t[35] = 1/pow(rhob,2.666666666666667);
    t[36] = 1/pow(2.718281828459045,1.645530784602056*t[34]*t[35]);
    t[37] = 0.2743-0.1508*t[36];
    t[38] = 0.01645530784602*t[34]*t[35]*t[37]+t[30]+1.0;
    t[39] = 1/pow(rhob,6.333333333333333);
    t[40] = SQRT(1.0000117555961*t[34]*t[35]+1.0);
    t[41] = 1/t[40];
    t[42] = 1/pow(rhob,3.666666666666667);
    t[43] = -0.03360054550205*t[34]*t[41]*t[42];
    t[44] = 1/pow(rhob,2.333333333333334);
    t[45] = -0.03360034800657*gradb*t[29]*t[44];
    t[46] = t[45]+t[43]-5.776579334555857E-6*t[25]*t[39];
    t[47] = 1/pow(t[31],2.0);
    t[48] = -0.01088885204564*t[25]*t[39]*t[36]-0.04388082092272*t[34]*t[42]*t[37]+t[45]+t[43];
    t[49] = pow(grada,3.0);
    t[50] = 0.02520040912654*grada*t[17]*t[11];
    t[51] = 0.02520026100493*t[5]*t[4];
    t[52] = t[51]+t[50]+4.332434500916893E-6*t[49]*t[2];
    t[53] = 0.00816663903423*t[49]*t[2]*t[12]+0.03291061569204*grada*t[11]*t[13]+t[51]+t[50];
    t[54] = pow(gradb,3.0);
    t[55] = 0.02520040912654*gradb*t[41]*t[35];
    t[56] = 0.02520026100493*t[29]*t[28];
    t[57] = t[56]+t[55]+4.332434500916893E-6*t[54]*t[26];
    t[58] = 0.00816663903423*t[54]*t[26]*t[36]+0.03291061569204*gradb*t[35]*t[37]+t[56]+t[55];
    t[59] = 1/pow(t[7],3.0);
    t[60] = 1/pow(rhoa,7.333333333333333);
    t[61] = 1/pow(t[16],3.0);
    t[62] = -0.04480125399533*t[1]*t[61]*t[60];
    t[63] = 1/pow(rhoa,4.666666666666667);
    t[64] = 0.16800272751027*t[10]*t[17]*t[63];
    t[65] = 0.07840081201534*t[5]*grada/pow(rhoa,3.333333333333334);
    t[66] = 0.03360094049649*t[49]*t[61]*t[15];
    t[67] = -0.10080163650616*grada*t[17]*t[18];
    t[68] = -0.03360034800657*t[5]*t[20];
    t[69] = 1/pow(t[31],3.0);
    t[70] = 1/pow(rhob,7.333333333333333);
    t[71] = 1/pow(t[40],3.0);
    t[72] = -0.04480125399533*t[25]*t[71]*t[70];
    t[73] = 1/pow(rhob,4.666666666666667);
    t[74] = 0.16800272751027*t[34]*t[41]*t[73];
    t[75] = 0.07840081201534*t[29]*gradb/pow(rhob,3.333333333333334);
    t[76] = 0.03360094049649*t[54]*t[71]*t[39];
    t[77] = -0.10080163650616*gradb*t[41]*t[42];
    t[78] = -0.03360034800657*t[29]*t[44];
    t[79] = -0.02520070537237*t[10]*t[61]*t[2];
    t[80] = 0.05040081825308*t[17]*t[11];
    t[81] = -0.02520070537237*t[34]*t[71]*t[26];
    t[82] = 0.05040081825308*t[41]*t[35];
    dfdra = 0.5*(-1.8610514726982*t[8]*t[3]*t[24]+1.8610514726982*t[22]*t[23]*t[3]*t[14]-2.4814019635976*t[8]*t[9]*t[14]);
    dfdrb = 0.5*(-1.8610514726982*t[32]*t[27]*t[48]+1.8610514726982*t[46]*t[47]*t[27]*t[38]-2.4814019635976*t[32]*t[33]*t[38]);
    dfdga = 0.5*(1.8610514726982*t[52]*t[23]*t[3]*t[14]-1.8610514726982*t[8]*t[3]*t[53]);
    dfdgb = 0.5*(1.8610514726982*t[57]*t[47]*t[27]*t[38]-1.8610514726982*t[32]*t[27]*t[58]);
    dfdab = 0.0;
    d2fdrara = 0.5*(-1.8610514726982*t[3]*t[8]*(-0.04778117666686*t[12]*pow(grada,6.0)/pow(rhoa,10.0)+t[65]+t[64]+t[62]+0.16089634338331*t[10]*t[63]*t[13]+0.09799966841074*t[1]*t[60]*t[12])-0.82713398786587*t[14]*t[8]/pow(rhoa,0.66666666666667)-3.7221029453964*t[14]*pow(t[22],2.0)*t[3]*t[59]-4.9628039271952*t[8]*t[9]*t[24]+3.7221029453964*t[22]*t[23]*t[3]*t[24]+4.9628039271952*t[22]*t[23]*t[9]*t[14]+1.8610514726982*(t[65]+t[64]+t[62]+3.65850024521871E-5*t[1]*t[60])*t[23]*t[3]*t[14]);
    d2fdrarb = 0.0;
    d2fdraga =0.5*(-1.8610514726982*t[3]*t[8]*(0.03583588250015*t[12]*pow(grada,5.0)/pow(rhoa,9.0)+t[68]+t[67]+t[66]-0.08776164184544*grada*t[18]*t[13]-0.06533311227383*t[49]*t[15]*t[12])-2.4814019635976*t[8]*t[9]*t[53]+1.8610514726982*t[22]*t[23]*t[3]*t[53]+1.8610514726982*t[52]*t[23]*t[3]*t[24]+2.4814019635976*t[52]*t[23]*t[9]*t[14]-3.7221029453964*t[22]*t[52]*t[59]*t[3]*t[14]+1.8610514726982*(t[68]+t[67]+t[66]-2.310631733822343E-5*t[49]*t[15])*t[23]*t[3]*t[14]);
    d2fdragb = 0.0;
    d2fdraab = 0.0;
    d2fdrbrb = 0.5*(-1.8610514726982*t[27]*t[32]*(-0.04778117666686*t[36]*pow(gradb,6.0)/pow(rhob,10.0)+t[75]+t[74]+t[72]+0.16089634338331*t[34]*t[73]*t[37]+0.09799966841074*t[25]*t[70]*t[36])-0.82713398786587*t[32]*t[38]/pow(rhob,0.66666666666667)-3.7221029453964*t[27]*t[38]*pow(t[46],2.0)*t[69]-4.9628039271952*t[32]*t[33]*t[48]+3.7221029453964*t[46]*t[47]*t[27]*t[48]+4.9628039271952*t[46]*t[47]*t[33]*t[38]+1.8610514726982*(t[75]+t[74]+t[72]+3.65850024521871E-5*t[25]*t[70])*t[47]*t[27]*t[38]);
    d2fdrbga = 0.0;
    d2fdrbgb = 0.5*(-1.8610514726982*t[27]*t[32]*(0.03583588250015*t[36]*pow(gradb,5.0)/pow(rhob,9.0)+t[78]+t[77]+t[76]-0.08776164184544*gradb*t[42]*t[37]-0.06533311227383*t[54]*t[39]*t[36])-2.4814019635976*t[32]*t[33]*t[58]+1.8610514726982*t[46]*t[47]*t[27]*t[58]+1.8610514726982*t[57]*t[47]*t[27]*t[48]+2.4814019635976*t[57]*t[47]*t[33]*t[38]-3.7221029453964*t[46]*t[57]*t[69]*t[27]*t[38]+1.8610514726982*(t[78]+t[77]+t[76]-2.310631733822343E-5*t[54]*t[39])*t[47]*t[27]*t[38]);
    d2fdrbab = 0.0;
    d2fdgaga = 0.5*(-1.8610514726982*t[3]*t[8]*(-0.02687691187511*t[1]*t[12]/pow(rhoa,8.0)+t[80]+t[79]+0.03291061569204*t[11]*t[13]+0.04083319517114*t[10]*t[2]*t[12])-3.7221029453964*t[14]*t[3]*pow(t[52],2.0)*t[59]+3.7221029453964*t[52]*t[23]*t[3]*t[53]+1.8610514726982*(t[80]+t[79]+1.299730350275068E-5*t[10]*t[2])*t[23]*t[3]*t[14]);
    d2fdgagb = 0.0;
    d2fdgaab = 0.0;
    d2fdgbgb = 0.5*(-1.8610514726982*t[27]*t[32]*(-0.02687691187511*t[25]*t[36]/pow(rhob,8.0)+t[82]+t[81]+0.03291061569204*t[35]*t[37]+0.04083319517114*t[34]*t[26]*t[36])-3.7221029453964*t[27]*t[38]*pow(t[57],2.0)*t[69]+3.7221029453964*t[57]*t[47]*t[27]*t[58]+1.8610514726982*(t[82]+t[81]+1.299730350275068E-5*t[34]*t[26])*t[47]*t[27]*t[38]);
    d2fdgbab = 0.0;
    d2fdabab = 0.0;
    ds->df1000 += factor*dfdra;
    ds->df0100 += factor*dfdrb;
    ds->df0010 += factor*dfdga;
    ds->df0001 += factor*dfdgb;
    ds->df00001 += factor*dfdab;
    ds->df2000 += factor*d2fdrara;
    ds->df1100 += factor*d2fdrarb;
    ds->df1010 += factor*d2fdraga;
    ds->df1001 += factor*d2fdragb;
    ds->df10001 += factor*d2fdraab;
    ds->df0200 += factor*d2fdrbrb;
    ds->df0110 += factor*d2fdrbga;
    ds->df0101 += factor*d2fdrbgb;
    ds->df01001 += factor*d2fdrbab;
    ds->df0020 += factor*d2fdgaga;
    ds->df0011 += factor*d2fdgagb;
    ds->df00101+= factor*d2fdgaab;
    ds->df0002 += factor*d2fdgbgb;
    ds->df00011+= factor*d2fdgbab;
    ds->df00002+= factor*d2fdabab;
}

static void
pw91x_third(FunThirdFuncDrv *ds, real factor, const FunDensProp* dp)
{
    real t[146];
    real dfdra, dfdrb, dfdga, dfdgb, dfdab;
    real d2fdraga, d2fdrara, d2fdrarb, d2fdragb, d2fdrbrb;
    real d2fdrbgb, d2fdgaga, d2fdgbgb, d2fdrbga;
    real d2fdraab, d2fdrbab;
    real d3fdraraga, d3fdraragb, d3fdraraab, d3fdrbrbab;
    real d3fdrarara, d3fdrararb, d3fdragaga, d3fdrarbrb;
    real d3fdragbgb, d3fdrarbgb, d3fdrarbab, d3fdgagaga;
    real d3fdrbrbrb, d3fdrbrbga, d3fdrbrbgb, d3fdrbgbgb;
    real d3fdrbgbga, d3fdrarbga, d3fdrbgaga;
    real rhoa = dp->rhoa;
    real rhob = dp->rhob;
    real grada = dp->grada;
    real gradb = dp->gradb;

    t[1] = pow(grada,4.0);
    t[2] = 1/pow(rhoa,5.333333333333333);
    t[3] = pow(rhoa,1.333333333333333);
    t[4] = 1/t[3];
    t[5] = ASINH(1.000005877780776*grada*t[4]);
    t[6] = 0.02520026100493*grada*t[5]*t[4];
    t[7] = t[6]+1.083108625229223E-6*t[1]*t[2]+1.0;
    t[8] = 1/t[7];
    t[9] = pow(rhoa,0.33333333333333);
    t[10] = pow(grada,2.0);
    t[11] = 1/pow(rhoa,2.666666666666667);
    t[12] = 1/pow(2.718281828459045,1.645530784602056*t[10]*t[11]);
    t[13] = 0.2743-0.1508*t[12];
    t[14] = t[6]+0.01645530784602*t[10]*t[11]*t[13]+1.0;
    t[15] = 1/pow(rhoa,6.333333333333333);
    t[16] = SQRT(1.0000117555961*t[10]*t[11]+1.0);
    t[17] = 1/t[16];
    t[18] = 1/pow(rhoa,3.666666666666667);
    t[19] = -0.03360054550205*t[10]*t[17]*t[18];
    t[20] = 1/pow(rhoa,2.333333333333334);
    t[21] = -0.03360034800657*grada*t[5]*t[20];
    t[22] = t[21]+t[19]-5.776579334555857E-6*t[1]*t[15];
    t[23] = 1/pow(t[7],2.0);
    t[24] = -0.01088885204564*t[1]*t[15]*t[12]-0.04388082092272*t[10]*t[18]*t[13]+t[21]+t[19];
    t[25] = pow(gradb,4.0);
    t[26] = 1/pow(rhob,5.333333333333333);
    t[27] = pow(rhob,1.333333333333333);
    t[28] = 1/t[27];
    t[29] = ASINH(1.000005877780776*gradb*t[28]);
    t[30] = 0.02520026100493*gradb*t[29]*t[28];
    t[31] = t[30]+1.083108625229223E-6*t[25]*t[26]+1.0;
    t[32] = 1/t[31];
    t[33] = pow(rhob,0.33333333333333);
    t[34] = pow(gradb,2.0);
    t[35] = 1/pow(rhob,2.666666666666667);
    t[36] = 1/pow(2.718281828459045,1.645530784602056*t[34]*t[35]);
    t[37] = 0.2743-0.1508*t[36];
    t[38] = 0.01645530784602*t[34]*t[35]*t[37]+t[30]+1.0;
    t[39] = 1/pow(rhob,6.333333333333333);
    t[40] = SQRT(1.0000117555961*t[34]*t[35]+1.0);
    t[41] = 1/t[40];
    t[42] = 1/pow(rhob,3.666666666666667);
    t[43] = -0.03360054550205*t[34]*t[41]*t[42];
    t[44] = 1/pow(rhob,2.333333333333334);
    t[45] = -0.03360034800657*gradb*t[29]*t[44];
    t[46] = t[45]+t[43]-5.776579334555857E-6*t[25]*t[39];
    t[47] = 1/pow(t[31],2.0);
    t[48] = -0.01088885204564*t[25]*t[39]*t[36]-0.04388082092272*t[34]*t[42]*t[37]+t[45]+t[43];
    t[49] = pow(grada,3.0);
    t[50] = 0.02520040912654*grada*t[17]*t[11];
    t[51] = 0.02520026100493*t[5]*t[4];
    t[52] = t[51]+t[50]+4.332434500916893E-6*t[49]*t[2];
    t[53] = 0.00816663903423*t[49]*t[2]*t[12]+0.03291061569204*grada*t[11]*t[13]+t[51]+t[50];
    t[54] = pow(gradb,3.0);
    t[55] = 0.02520040912654*gradb*t[41]*t[35];
    t[56] = 0.02520026100493*t[29]*t[28];
    t[57] = t[56]+t[55]+4.332434500916893E-6*t[54]*t[26];
    t[58] = 0.00816663903423*t[54]*t[26]*t[36]+0.03291061569204*gradb*t[35]*t[37]+t[56]+t[55];
    t[59] = 1/pow(rhoa,0.66666666666667);
    t[60] = pow(t[22],2.0);
    t[61] = 1/pow(t[7],3.0);
    t[62] = 1/pow(rhoa,7.333333333333333);
    t[63] = 1/pow(t[16],3.0);
    t[64] = -0.04480125399533*t[1]*t[63]*t[62];
    t[65] = 1/pow(rhoa,4.666666666666667);
    t[66] = 0.16800272751027*t[10]*t[17]*t[65];
    t[67] = 1/pow(rhoa,3.333333333333334);
    t[68] = 0.07840081201534*grada*t[5]*t[67];
    t[69] = t[68]+t[66]+t[64]+3.65850024521871E-5*t[1]*t[62];
    t[70] = pow(grada,6.0);
    t[71] = 1/pow(rhoa,10.0);
    t[72] = 0.09799966841074*t[1]*t[62]*t[12]-0.04778117666686*t[70]*t[71]*t[12]+0.16089634338331*t[10]*t[65]*t[13]+t[68]+t[66]+t[64];
    t[73] = 0.03360094049649*t[49]*t[63]*t[15];
    t[74] = -0.10080163650616*grada*t[17]*t[18];
    t[75] = -0.03360034800657*t[5]*t[20];
    t[76] = t[75]+t[74]+t[73]-2.310631733822343E-5*t[49]*t[15];
    t[77] = pow(grada,5.0);
    t[78] = 1/pow(rhoa,9.0);
    t[79] = -0.06533311227383*t[49]*t[15]*t[12]+0.03583588250015*t[77]*t[78]*t[12]-0.08776164184544*grada*t[18]*t[13]+t[75]+t[74]+t[73];
    t[80] = 1/pow(rhob,0.66666666666667);
    t[81] = pow(t[46],2.0);
    t[82] = 1/pow(t[31],3.0);
    t[83] = 1/pow(rhob,7.333333333333333);
    t[84] = 1/pow(t[40],3.0);
    t[85] = -0.04480125399533*t[25]*t[84]*t[83];
    t[86] = 1/pow(rhob,4.666666666666667);
    t[87] = 0.16800272751027*t[34]*t[41]*t[86];
    t[88] = 1/pow(rhob,3.333333333333334);
    t[89] = 0.07840081201534*gradb*t[29]*t[88];
    t[90] = t[89]+t[87]+t[85]+3.65850024521871E-5*t[25]*t[83];
    t[91] = pow(gradb,6.0);
    t[92] = 1/pow(rhob,10.0);
    t[93] = 0.09799966841074*t[25]*t[83]*t[36]-0.04778117666686*t[91]*t[92]*t[36]+0.16089634338331*t[34]*t[86]*t[37]+t[89]+t[87]+t[85];
    t[94] = pow(t[52],2.0);
    t[95] = -0.02520070537237*t[10]*t[63]*t[2];
    t[96] = 0.05040081825308*t[17]*t[11];
    t[97] = t[96]+t[95]+1.299730350275068E-5*t[10]*t[2];
    t[98] = 1/pow(rhoa,8.0);
    t[99] = 0.04083319517114*t[10]*t[2]*t[12]-0.02687691187511*t[1]*t[98]*t[12]+0.03291061569204*t[11]*t[13]+t[96]+t[95];
    t[100] = pow(t[57],2.0);
    t[101] = -0.02520070537237*t[34]*t[84]*t[26];
    t[102] = 0.05040081825308*t[41]*t[35];
    t[103] = t[102]+t[101]+1.299730350275068E-5*t[34]*t[26];
    t[104] = -0.02687691187511*t[25]*t[36]/pow(rhob,8.0)+0.03291061569204*t[35]*t[37]+0.04083319517114*t[34]*t[26]*t[36]+t[102]+t[101];
    t[105] = 0.03360094049649*t[54]*t[84]*t[39];
    t[106] = -0.10080163650616*gradb*t[41]*t[42];
    t[107] = -0.03360034800657*t[29]*t[44];
    t[108] = t[107]+t[106]+t[105]-2.310631733822343E-5*t[54]*t[39];
    t[109] = pow(gradb,5.0);
    t[110] = 1/pow(rhob,9.0);
    t[111] = -0.06533311227383*t[54]*t[39]*t[36]+0.03583588250015*t[109]*t[110]*t[36]-0.08776164184544*gradb*t[42]*t[37]+t[107]+t[106]+t[105];
    t[112] = 1/pow(t[7],4.0);
    t[113] = 1/pow(t[16],5.0);
    t[114] = 0.13440534198232*t[77]*t[113]*t[71];
    t[115] = -0.34720971846378*t[49]*t[63]*t[62];
    t[116] = 0.41440672785865*grada*t[17]*t[65];
    t[117] = 0.07840081201534*t[5]*t[67];
    t[118] = -0.10080400648674*t[1]*t[113]*t[78];
    t[119] = 0.20160564297897*t[10]*t[63]*t[15];
    t[120] = -0.13440218200821*t[17]*t[18];
    t[121] = 1/pow(rhoa,11.0);
    t[122] = -0.17920712264309*t[70]*t[113]*t[121];
    t[123] = 1/pow(rhoa,8.333333333333334);
    t[124] = 0.55254879927569*t[1]*t[63]*t[123];
    t[125] = 1/pow(rhoa,5.666666666666667);
    t[126] = -0.88854775883207*t[10]*t[17]*t[125];
    t[127] = -0.26133604005113*t[5]*grada/pow(rhoa,4.333333333333333);
    t[128] = 1/pow(t[31],4.0);
    t[129] = 1/pow(t[40],5.0);
    t[130] = 1/pow(rhob,11.0);
    t[131] = -0.17920712264309*t[91]*t[129]*t[130];
    t[132] = 1/pow(rhob,8.333333333333334);
    t[133] = 0.55254879927569*t[25]*t[84]*t[132];
    t[134] = 1/pow(rhob,5.666666666666667);
    t[135] = -0.88854775883207*t[34]*t[41]*t[134];
    t[136] = -0.26133604005113*t[29]*gradb/pow(rhob,4.333333333333333);
    t[137] = 0.13440534198232*t[109]*t[129]*t[92];
    t[138] = -0.34720971846378*t[54]*t[84]*t[83];
    t[139] = 0.41440672785865*gradb*t[41]*t[86];
    t[140] = 0.07840081201534*t[29]*t[88];
    t[141] = -0.10080400648674*t[25]*t[129]*t[110];
    t[142] = 0.20160564297897*t[34]*t[84]*t[39];
    t[143] = -0.13440218200821*t[41]*t[42];
    t[144] = 0.07560300486505*t[49]*t[113]*t[98];
    t[145] = -0.10080282148948*grada*t[63]*t[2];
    dfdra = 0.5*(-1.8610514726982*t[8]*t[3]*t[24]+1.8610514726982*t[22]*t[23]*t[3]*t[14]-2.4814019635976*t[8]*t[9]*t[14]);
    dfdrb = 0.5*(-1.8610514726982*t[32]*t[27]*t[48]+1.8610514726982*t[46]*t[47]*t[27]*t[38]-2.4814019635976*t[32]*t[33]*t[38]);
    dfdga = 0.5*(1.8610514726982*t[52]*t[23]*t[3]*t[14]-1.8610514726982*t[8]*t[3]*t[53]);
    dfdgb = 0.5*(1.8610514726982*t[57]*t[47]*t[27]*t[38]-1.8610514726982*t[32]*t[27]*t[58]);
    dfdab = 0.0;
    d2fdrara = 0.5*(3.7221029453964*t[22]*t[23]*t[3]*t[24]-4.9628039271952*t[8]*t[9]*t[24]-1.8610514726982*t[8]*t[3]*t[72]+1.8610514726982*t[69]*t[23]*t[3]*t[14]-3.7221029453964*t[60]*t[61]*t[3]*t[14]+4.9628039271952*t[22]*t[23]*t[9]*t[14]-0.82713398786587*t[8]*t[59]*t[14]);
    d2fdrarb = 0.0;
    d2fdraga = 0.5*(1.8610514726982*t[22]*t[23]*t[3]*t[53]-2.4814019635976*t[8]*t[9]*t[53]+1.8610514726982*t[52]*t[23]*t[3]*t[24]-1.8610514726982*t[8]*t[3]*t[79]+1.8610514726982*t[76]*t[23]*t[3]*t[14]-3.7221029453964*t[22]*t[52]*t[61]*t[3]*t[14]+2.4814019635976*t[52]*t[23]*t[9]*t[14]);
    d2fdragb = 0.0;
    d2fdrbrb = 0.5*(3.7221029453964*t[46]*t[47]*t[27]*t[48]-4.9628039271952*t[32]*t[33]*t[48]-1.8610514726982*t[32]*t[27]*t[93]+1.8610514726982*t[90]*t[47]*t[27]*t[38]-3.7221029453964*t[81]*t[82]*t[27]*t[38]+4.9628039271952*t[46]*t[47]*t[33]*t[38]-0.82713398786587*t[32]*t[80]*t[38]);
    d2fdraab = 0.0;
    d2fdrbab = 0.0;
    d2fdgaga = 0.5*(3.7221029453964*t[52]*t[23]*t[3]*t[53]-1.8610514726982*t[8]*t[3]*t[99]+1.8610514726982*t[97]*t[23]*t[3]*t[14]-3.7221029453964*t[94]*t[61]*t[3]*t[14]);
    d2fdgbgb= 0.5*(3.7221029453964*t[57]*t[47]*t[27]*t[58]-1.8610514726982*t[32]*t[27]*t[104]+1.8610514726982*t[103]*t[47]*t[27]*t[38]-3.7221029453964*t[100]*t[82]*t[27]*t[38]);
    d2fdrbga = 0.0;
    d2fdrbgb = 0.5*(1.8610514726982*t[46]*t[47]*t[27]*t[58]-2.4814019635976*t[32]*t[33]*t[58]+1.8610514726982*t[57]*t[47]*t[27]*t[48]-1.8610514726982*t[32]*t[27]*t[111]+1.8610514726982*t[108]*t[47]*t[27]*t[38]-3.7221029453964*t[46]*t[57]*t[82]*t[27]*t[38]+2.4814019635976*t[57]*t[47]*t[33]*t[38]);
    d3fdrararb = 0.0;
    d3fdraraga = 0.5*(-1.8610514726982*t[3]*t[8]*(0.15725079425967*t[12]*pow(grada,7.0)/pow(rhoa,12.66666666666667)+0.32179268676662*grada*t[65]*t[13]-0.60921000250252*t[77]*t[71]*t[12]+0.47185025531097*t[49]*t[62]*t[12]+t[117]+t[116]+t[115]+t[114])-4.9628039271952*t[8]*t[9]*t[79]+3.7221029453964*t[22]*t[23]*t[3]*t[79]+1.8610514726982*t[52]*t[23]*t[3]*t[72]+4.9628039271952*t[22]*t[23]*t[9]*t[53]-0.82713398786587*t[8]*t[59]*t[53]-3.7221029453964*t[60]*t[61]*t[3]*t[53]+1.8610514726982*t[69]*t[23]*t[3]*t[53]+4.9628039271952*t[52]*t[23]*t[9]*t[24]-7.4442058907928*t[22]*t[52]*t[61]*t[3]*t[24]+3.7221029453964*t[76]*t[23]*t[3]*t[24]-9.9256078543904*t[22]*t[52]*t[61]*t[9]*t[14]+4.9628039271952*t[76]*t[23]*t[9]*t[14]+0.82713398786587*t[52]*t[23]*t[59]*t[14]-3.7221029453964*t[69]*t[52]*t[61]*t[3]*t[14]-7.4442058907928*t[76]*t[22]*t[61]*t[3]*t[14]+1.8610514726982*(t[117]+t[116]+t[115]+1.463400098087484E-4*t[49]*t[62]+t[114])*t[23]*t[3]*t[14]+11.1663088361892*t[60]*t[52]*t[112]*t[3]*t[14]);
    d3fdraragb = 0.0;
    d3fdrbrbab = 0.0;
    d3fdraraab = 0.0;
    d3fdrarbrb = 0.0;
    d3fdrarbga = 0.0;
    d3fdrarbgb = 0.0;
    d3fdrarbab= 0.0;
    d3fdragaga = 0.5*(-1.8610514726982*t[3]*t[8]*(-0.11793809569475*t[12]*t[70]/pow(rhoa,11.66666666666667)-0.08776164184544*t[18]*t[13]+t[120]+0.39419470750163*t[1]*t[78]*t[12]-0.23955474500403*t[10]*t[15]*t[12]+t[119]+t[118])-2.4814019635976*t[8]*t[9]*t[99]+1.8610514726982*t[22]*t[23]*t[3]*t[99]+3.7221029453964*t[52]*t[23]*t[3]*t[79]+4.9628039271952*t[52]*t[23]*t[9]*t[53]-7.4442058907928*t[22]*t[52]*t[61]*t[3]*t[53]+3.7221029453964*t[76]*t[23]*t[3]*t[53]-3.7221029453964*t[94]*t[61]*t[3]*t[24]+1.8610514726982*t[97]*t[23]*t[3]*t[24]-4.9628039271952*t[94]*t[61]*t[9]*t[14]+2.4814019635976*t[97]*t[23]*t[9]*t[14]-7.4442058907928*t[76]*t[52]*t[61]*t[3]*t[14]-3.7221029453964*t[97]*t[22]*t[61]*t[3]*t[14]+1.8610514726982*(t[120]+t[119]-6.931895201467029E-5*t[10]*t[15]+t[118])*t[23]*t[3]*t[14]+11.1663088361892*t[22]*t[94]*t[112]*t[3]*t[14]);
    d3fdragbgb = 0.0;
    d3fdrarara = 0.5*(-1.8610514726982*t[3]*t[8]*(-0.20966772567956*t[12]*pow(grada,8.0)/pow(rhoa,13.66666666666667)-0.75084960245546*t[10]*t[125]*t[13]+t[127]+t[126]+t[124]+t[122]-0.82513301056944*t[1]*t[123]*t[12]+0.90784235667042*t[70]*t[121]*t[12])+0.55142265857724*t[14]*t[8]/pow(rhoa,1.666666666666667)-7.4442058907928*t[8]*t[9]*t[72]+5.583154418094599*t[22]*t[23]*t[3]*t[72]+11.1663088361892*t[112]*t[14]*pow(t[22],3.0)*t[3]+14.8884117815856*t[22]*t[23]*t[9]*t[24]-2.4814019635976*t[8]*t[59]*t[24]-11.1663088361892*t[60]*t[61]*t[3]*t[24]+5.583154418094599*t[69]*t[23]*t[3]*t[24]-14.8884117815856*t[60]*t[61]*t[9]*t[14]+7.4442058907928*t[69]*t[23]*t[9]*t[14]+2.4814019635976*t[22]*t[23]*t[59]*t[14]-11.1663088361892*t[69]*t[22]*t[61]*t[3]*t[14]+1.8610514726982*(t[127]+t[126]+t[124]-2.682900179827054E-4*t[1]*t[123]+t[122])*t[23]*t[3]*t[14]);
    d3fdrbrbrb = 0.5*(-1.8610514726982*t[27]*t[32]*(-0.20966772567956*t[36]*pow(gradb,8.0)/pow(rhob,13.66666666666667)-0.75084960245546*t[34]*t[134]*t[37]-0.82513301056944*t[25]*t[132]*t[36]+0.90784235667042*t[91]*t[130]*t[36]+t[136]+t[135]+t[133]+t[131])+0.55142265857724*t[32]*t[38]/pow(rhob,1.666666666666667)-7.4442058907928*t[32]*t[33]*t[93]+5.583154418094599*t[46]*t[47]*t[27]*t[93]-2.4814019635976*t[32]*t[80]*t[48]+14.8884117815856*t[46]*t[47]*t[33]*t[48]-11.1663088361892*t[81]*t[82]*t[27]*t[48]+5.583154418094599*t[90]*t[47]*t[27]*t[48]+11.1663088361892*t[128]*t[27]*t[38]*pow(t[46],3.0)+2.4814019635976*t[46]*t[47]*t[80]*t[38]-14.8884117815856*t[81]*t[82]*t[33]*t[38]+7.4442058907928*t[90]*t[47]*t[33]*t[38]-11.1663088361892*t[90]*t[46]*t[82]*t[27]*t[38]+1.8610514726982*(t[136]+t[135]+t[133]-2.682900179827054E-4*t[25]*t[132]+t[131])*t[47]*t[27]*t[38]);
    d3fdrbrbga = 0.0;
    d3fdrbrbgb = 0.5*(-1.8610514726982*t[27]*t[32]*(0.15725079425967*t[36]*pow(gradb,7.0)/pow(rhob,12.66666666666667)+0.32179268676662*gradb*t[86]*t[37]-0.60921000250252*t[109]*t[92]*t[36]+0.47185025531097*t[54]*t[83]*t[36]+t[140]+t[139]+t[138]+t[137])+1.8610514726982*t[57]*t[47]*t[27]*t[93]-0.82713398786587*t[32]*t[80]*t[58]+4.9628039271952*t[46]*t[47]*t[33]*t[58]-3.7221029453964*t[81]*t[82]*t[27]*t[58]+1.8610514726982*t[90]*t[47]*t[27]*t[58]+4.9628039271952*t[57]*t[47]*t[33]*t[48]-7.4442058907928*t[46]*t[57]*t[82]*t[27]*t[48]+3.7221029453964*t[108]*t[47]*t[27]*t[48]+0.82713398786587*t[57]*t[47]*t[80]*t[38]-9.9256078543904*t[46]*t[57]*t[82]*t[33]*t[38]+4.9628039271952*t[108]*t[47]*t[33]*t[38]-3.7221029453964*t[90]*t[57]*t[82]*t[27]*t[38]-7.4442058907928*t[108]*t[46]*t[82]*t[27]*t[38]+1.8610514726982*(t[140]+t[139]+t[138]+1.463400098087484E-4*t[54]*t[83]+t[137])*t[47]*t[27]*t[38]+11.1663088361892*t[81]*t[57]*t[128]*t[27]*t[38]-4.9628039271952*t[32]*t[33]*t[111]+3.7221029453964*t[46]*t[47]*t[27]*t[111]);
    d3fdrbgaga = 0.0;
    d3fdrbgbga = 0.0;
    d3fdrbgbgb = 0.5*(-1.8610514726982*t[27]*t[32]*(-0.11793809569475*t[36]*t[91]/pow(rhob,11.66666666666667)-0.08776164184544*t[42]*t[37]-0.23955474500403*t[34]*t[39]*t[36]+0.39419470750163*t[25]*t[110]*t[36]+t[143]+t[142]+t[141])+4.9628039271952*t[57]*t[47]*t[33]*t[58]-7.4442058907928*t[46]*t[57]*t[82]*t[27]*t[58]+3.7221029453964*t[108]*t[47]*t[27]*t[58]-3.7221029453964*t[100]*t[82]*t[27]*t[48]+1.8610514726982*t[103]*t[47]*t[27]*t[48]-4.9628039271952*t[100]*t[82]*t[33]*t[38]+2.4814019635976*t[103]*t[47]*t[33]*t[38]-7.4442058907928*t[108]*t[57]*t[82]*t[27]*t[38]-3.7221029453964*t[103]*t[46]*t[82]*t[27]*t[38]+1.8610514726982*(t[143]+t[142]-6.931895201467029E-5*t[34]*t[39]+t[141])*t[47]*t[27]*t[38]+11.1663088361892*t[46]*t[100]*t[128]*t[27]*t[38]+3.7221029453964*t[57]*t[47]*t[27]*t[111]-2.4814019635976*t[32]*t[33]*t[104]+1.8610514726982*t[46]*t[47]*t[27]*t[104]);
    d3fdgagaga = 0.5*(-1.8610514726982*t[3]*t[8]*(0.08845357177106*t[12]*t[77]/pow(rhoa,10.66666666666667)+t[145]+t[144]-0.241892206876*t[49]*t[98]*t[12]+0.09799966841074*grada*t[2]*t[12])+5.583154418094599*t[52]*t[23]*t[3]*t[99]-11.1663088361892*t[94]*t[61]*t[3]*t[53]+5.583154418094599*t[97]*t[23]*t[3]*t[53]+11.1663088361892*t[112]*t[14]*t[3]*pow(t[52],3.0)-11.1663088361892*t[97]*t[52]*t[61]*t[3]*t[14]+1.8610514726982*(t[145]+2.599460700550136E-5*grada*t[2]+t[144])*t[23]*t[3]*t[14]);
    ds->df1000 += factor*dfdra;
    ds->df0100 += factor*dfdrb;
    ds->df0010 += factor*dfdga;
    ds->df0001 += factor*dfdgb;
    ds->df00001 += factor*dfdab;
    ds->df2000 += factor*d2fdrara;
    ds->df1100 += factor*d2fdrarb;
    ds->df1010 += factor*d2fdraga;
    ds->df1001 += factor*d2fdragb;
    ds->df10001 += factor*d2fdraab;
    ds->df0200 += factor*d2fdrbrb;
    ds->df0110 += factor*d2fdrbga;
    ds->df0101 += factor*d2fdrbgb;
    ds->df01001 += factor*d2fdrbab;
    ds->df0020 += factor*d2fdgaga;
    ds->df0002 += factor*d2fdgbgb;
    ds->df2010 += factor*d3fdraraga;
    ds->df2001 += factor*d3fdraragb;
    ds->df1101 += factor*d3fdrarbgb;
    ds->df11001 += factor*d3fdrarbab;
    ds->df1020 += factor*d3fdragaga;
    ds->df1002 += factor*d3fdragbgb;
    ds->df3000 += factor*d3fdrarara;
    ds->df2100 += factor*d3fdrararb;
    ds->df20001 += factor*d3fdraraab;
    ds->df02001 += factor*d3fdrbrbab;
    ds->df1200 += factor*d3fdrarbrb;
    ds->df1110 += factor*d3fdrarbga;
    ds->df0300 += factor*d3fdrbrbrb;
    ds->df0210 += factor*d3fdrbrbga;
    ds->df0201 += factor*d3fdrbrbgb;
    ds->df0120 += factor*d3fdrbgaga;
    ds->df0102 += factor*d3fdrbgbgb;
    ds->df0030 += factor*d3fdgagaga;
}
