/*-*-mode: C; c-indentation-style: "bsd"; c-basic-offset: 4; -*-*/
/* fun-hjsx.c:

   Automatically generated code implementing HJSX functional and
   its derivatives. It is generated by func-codegen.pl being a part of
   a "Automatic code generation framework for analytical functional
   derivative evaluation", Pawel Salek, 2005

    This functional is connected by making following changes:
    1. add "extern Functional hjsxFunctional;" to 'functionals.h'
    2. add "&hjsxFunctional," to 'functionals.c'
    3. add "fun-hjsx.c" to 'Makefile.am', 'Makefile.in' or 'Makefile'.

    This functional has been generated from following input:
    ------ cut here -------
 For details of the max-input see Weintraub et al JCTC 5(4), 754 (2009) (and  Henderson et al JCP 128, 194105 (2008)) 
 define constants where AE= A, B , C, D E and a[i], b[i] are the coefficient of hse function 

PI:3.14159265358979312;
AE:[0.757211,-0.106364,-0.118649,0.609650,-0.0477963];
a:[0.0159941, 0.0852995, -0.160368, 0.152645, -0.0971263, 0.0422061];
b:[5.33319, -12.4780, 11.0988, -5.11013, 1.71468, -0.610380, 0.307555, -0.0770547, 0.0334840];
kf(rhox):=(6.0 * PI * PI * rhox)^(1/3);

 define x_a,b = Abs(nabla_rho)/(2.0 * kf_a,b * rho)  

xa:sqrt(grada*grada)/(2.0 * kf(rhoa) * rhoa);
xb:sqrt(gradb*gradb)/(2.0 * kf(rhob) * rhob);

 define the function hse(sx), sx = sa,sb 
hse1(sx):= a[1]*sx^2   + a[2]*sx^3 + a[3]*sx^4 + a[4]*sx^5 + a[5]*sx^6 + a[6]*sx^7;
hse2(sx):= 1.0 + b[1]*sx + b[2]*sx^2 + b[3]*sx^3 + b[4]*sx^4 + b[5]*sx^5 + b[6]*sx^6 + b[7]*sx^7 + b[8]*sx^8 + b[9]*sx^9;

 define hse(s), f(s), (AE[5] * g(s)), xi, eta, lambda, nu, chi and gamma 

hse(sx):=hse1(sx)/hse2(sx);
xi(sx):=sx^2 * hse(sx);
eta(sx):=AE[1]  + xi(sx);
lamb(sx):=AE[4] + xi(sx);
nu(rhox):=MU/kf(rhox);
chi(sx,rhox):=nu(rhox)/sqrt(lamb(sx) + nu(rhox) * nu(rhox));
gama(sx,rhox):=(1.0 + chi(sx,rhox)) * (lamb(sx) + nu(rhox) * nu(rhox));

  note I put Fs(sx) = -H(s). First because it numerically behaves better, secondly it appears in all expressions in the form -H(s) 
Fs(sx):= -1.0 + (1.0/(27.0 * AE[3])) * (sx^2/(1.0 + sx^2/4.0)) + sx^2 * hse(sx)/(2.0 * AE[3]);

 note E= AE[5] is included in the definition pf eGs, whereas C=AE[3] is not included in the definition of Fs 

eGs(sx):=(2.0/5.0)*AE[3]*Fs(sx)*lamb(sx)-(4.0/15.0)*AE[2]*lamb(sx)^2-(6.0/5.0)*AE[1]*lamb(sx)^3-(4.0/5.0)*sqrt(PI)*lamb(sx)^(7/2)-(12.0/5.0)*lamb(sx)^(7/2)*(sqrt(xi(sx))-sqrt(eta(sx)));
 
 define the enhancment fator FHJS (Henderson, Janesko and Scuseria) of HSE-exchange-hole, which depend also on the short-range separation parameter MU 

tem01(sx,rhox):=sqrt(xi(sx) + nu(rhox) * nu(rhox));
tem02(sx,rhox):=sqrt(eta(sx)+ nu(rhox) * nu(rhox));

dnom1(sx,rhox):=(tem01(sx,rhox) + tem02(sx,rhox)) * (tem01(sx,rhox) + nu(rhox));
dnom2(sx,rhox):=(tem01(sx,rhox) + tem02(sx,rhox)) * (tem02(sx,rhox) + nu(rhox));
tem1(sx,rhox):=AE[1] * (xi(sx)/dnom1(sx,rhox) + eta(sx)/dnom2(sx,rhox));
tem2(sx,rhox):=-(4.0/9.0) * AE[2]/gama(sx,rhox);
tem3(sx,rhox):=(4.0/9.0) * AE[3] * Fs(sx) * (1.0 + 0.5 * chi(sx,rhox))/(gama(sx,rhox)*gama(sx,rhox));
tem40(sx,rhox):=-(8.0/9.0) * eGs(sx) * (1.0 + (9.0/8.0) * chi(sx,rhox) + (3.0/8.0) * chi(sx,rhox)* chi(sx,rhox));
tem4(sx,rhox):=tem40(sx,rhox)/(gama(sx,rhox)*gama(sx,rhox)*gama(sx,rhox));
tem50(sx,rhox):=sqrt( lamb(sx) + nu(rhox)* nu(rhox));
tem51(sx,rhox):=(nu(rhox) + tem50(sx,rhox)) * ( tem50(sx,rhox) +  tem01(sx,rhox) );
tem52(sx,rhox):=(nu(rhox) + tem50(sx,rhox)) * ( tem50(sx,rhox) +  tem02(sx,rhox) );    
tem5(sx,rhox):=2.0* xi(sx)   * log(1.0 - (lamb(sx) - xi(sx))/tem51(sx,rhox));
tem6(sx,rhox):=-2.0* eta(sx) * log(1.0 - (lamb(sx) - eta(sx))/tem52(sx,rhox));

FHJS(sx,rhox):= tem1(sx,rhox) + tem2(sx,rhox) + tem3(sx,rhox) + tem4(sx,rhox) + tem5(sx,rhox) + tem6(sx,rhox);


 LSDA exchange 
cx:(3.0/4.0)*(6.0/PI)^(1/3);
lda:-cx*(rhoa^(4/3) + rhob^(4/3));

  note that for spin-dependent density the enhancement factor: FHJS(x,rho) = (1/2) * (FHJS(xa,rhoa) + FHJS(xb,rhob)) 

K(rhoa,grada,rhob,gradb,gradab):= 0.50 * lda * (FHJS(xa,rhoa) + FHJS(xb,rhob));

    ------ cut here -------
*/

 
/* strictly conform to XOPEN ANSI C standard */
#define _XOPEN_SOURCE          500
#define _XOPEN_SOURCE_EXTENDED 1
#include <math.h>
#include <stddef.h>
 
#define __CVERSION__
 
#include "functionals.h"
#include "dcbham.h"
#define MU dcrham_.hfxmu
 
/* INTERFACE PART */
static int hjsx_isgga(void) { return 1; } /* FIXME: detect! */
static int hjsx_read(const char *conf_line);
static real hjsx_energy(const FunDensProp* dp);
static void hjsx_first(FunFirstFuncDrv *ds,   real factor,
                         const FunDensProp* dp);
static void hjsx_second(FunSecondFuncDrv *ds, real factor,
                          const FunDensProp* dp);
 
Functional HjsxFunctional = {
  "HJSX",       /* name */
  hjsx_isgga,   /* gga-corrected */
  hjsx_read,
  NULL,
  hjsx_energy,
  hjsx_first,
  hjsx_second
};
 
/* IMPLEMENTATION PART */
static int
hjsx_read(const char *conf_line)
{
    fun_set_hf_weight(0);
    return 1;
}



static real
hjsx_energy(const FunDensProp *dp)
{
    real res;
    real rhoa = dp->rhoa, rhob = dp->rhob;
    real grada = dp->grada, gradb = dp->gradb, gradab = dp->gradab;

    real t1, t2, t3, t4, t5, t6, t7, t8, t9, t10;
    real t11, t12, t13, t14, t15, t16, t17, t18;
    real t19, t20, t21, t22, t23, t24, t25, t26;
    real t27, t28, t29, t30, t31, t32, t33, t34;
    real t35, t36, t37, t38, t39, t40, t41, t42;
    real t43, t44, t45, t46, t47, t48, t49, t50;
    real t51, t52, t53, t54, t55, t56, t57, t58;
    real t59, t60, t61, t62, t63, t64, t65, t66;
    real t67, t68, t69, t70, t71;

    t1 = pow(rhoa,1.333333333333333);
    t2 = pow(rhob,1.333333333333333);
    t3 = pow(grada,2.0);
    t4 = 1/pow(rhoa,2.666666666666667);
    t5 = fabs(grada);
    t6 = pow(t5,7.0);
    t7 = 1/pow(rhoa,9.333333333333334);
    t8 = pow(grada,6.0);
    t9 = 1/pow(rhoa,8.0);
    t10 = pow(t5,5.0);
    t11 = 1/pow(rhoa,6.666666666666667);
    t12 = pow(grada,4.0);
    t13 = 1/pow(rhoa,5.333333333333333);
    t14 = pow(t5,3.0);
    t15 = 1/pow(rhoa,4.0);
    t16 = 2.6318783922003747E-4*t3*t4+1.8005513133540818E-4*
        t14*t15-4.342399100269002E-5*t12*t13+5.3020963068324E-6*t10*
        t11-4.3276773969754684E-7*t8*t9+2.412383024769541E-8*t6*t7;
    t17 = 1/
        t1;
    t18 = 1/(3.149302550983648E-10*pow(t5,9.0)/pow(rhoa,12.0)-
        5.649671283776347E-9*pow(grada,8.0)/pow(rhoa,10.66666666666667)-
        2.719683267627704E-6*t8*t9+1.7578986477855008E-7*t6*t7-.2053293313026446*
        t3*t4+.6841322473346062*t5*t17+.02342799068769956*t14*t15-
        .001383706469760653*t12*t13+5.955909787676884E-5*t10*t11+1.0);
    t19 = -
        .005136628594837796*t3*t4/(0.00411382696150514*t3*t4+1.0)-
        .06934448603031025*t3*t16*t18*t4-1.0;
    t20 = .01645530784602056*t3*t16*t18*t4;
    t21 = 1/pow(rhoa,.6666666666666666);
    t22 = pow(MU,2.0);
    t23 = .06582123138408225*t21*t22;
    t24 = t23+t20+0.60965;
    t25 = 1/pow(rhoa,.3333333333333333);
    t26 = sqrt(t24);
    t27 = 1/t26;
    t28 = .2565564877060844*t25*MU*t27+1.0;
    t29 = 1/t24;
    t30 = t20+0.60965;
    t31 = pow(sqrt(t30),7.0);
    t32 = t20+0.757211;
    t33 = pow(gradb,2.0);
    t34 = 1/pow(rhob,2.666666666666667);
    t35 = fabs(gradb);
    t36 = pow(t35,7.0);
    t37 = 1/pow(rhob,9.333333333333334);
    t38 = pow(gradb,6.0);
    t39 = 1/pow(rhob,8.0);
    t40 = pow(t35,5.0);
    t41 = 1/pow(rhob,6.666666666666667);
    t42 = pow(gradb,4.0);
    t43 = 1/pow(rhob,5.333333333333333);
    t44 = pow(t35,3.0);
    t45 = 1/pow(rhob,4.0);
    t46 = 2.6318783922003747E-4*t33*t34+1.8005513133540818E-4*
        t44*t45-4.342399100269002E-5*t42*t43+5.3020963068324E-6*t40*
        t41-4.3276773969754684E-7*t38*t39+2.412383024769541E-8*t36*
        t37;
    t47 = 1/t2;
    t48 = 1/(3.149302550983648E-10*pow(t35,9.0)/pow(rhob,
        12.0)-5.649671283776347E-9*pow(gradb,8.0)/pow(rhob,10.66666666666667)+
        .6841322473346062*t35*t47+.02342799068769956*t44*t45-.001383706469760653*
        t42*t43+5.955909787676884E-5*t40*t41-2.719683267627704E-6*
        t38*t39+1.7578986477855008E-7*t36*t37-.2053293313026446*t33*
        t34+1.0);
    t49 = -.005136628594837796*t33*t34/(0.00411382696150514*
        t33*t34+1.0)-.06934448603031025*t33*t46*t48*t34-1.0;
    t50 = .01645530784602056*t33*t46*t48*t34;
    t51 = 1/pow(rhob,.6666666666666666);
    t52 = .06582123138408225*t51*t22;
    t53 = t52+t50+0.60965;
    t54 = 1/pow(rhob,.3333333333333333);
    t55 = sqrt(t53);
    t56 = 1/t55;
    t57 = .2565564877060844*t54*MU*t56+1.0;
    t58 = 1/t53;
    t59 = t50+0.60965;
    t60 = pow(sqrt(t59),7.0);
    t61 = t50+0.757211;
    t62 = .2565564877060844*t25*MU;
    t63 = sqrt(t23+t20);
    t64 = sqrt(t23+t20+0.757211);
    t65 = 1/(t64+t63);
    t66 = .2565564877060844*t54*MU;
    t67 = sqrt(t52+t50);
    t68 = sqrt(t52+t50+0.757211);
    t69 = 1/(t68+t67);
    t70 = 1/(t26+t62);
    t71 = 1/(t55+t66);

   /* code */
    res = -0.46526286817455*(t2+t1)*(-2.0*t61*log(.1475609999999999*
        t71/(t68+t55)+1.0)+.03291061569204112*t33*t34*t46*t48*log(1.0-
        0.60965*t71/(t55+t67))-2.0*t32*log(.1475609999999999*t70/(t64+
        t26)+1.0)+.03291061569204112*t16*t18*t3*t4*log(1.0-0.60965*
        t70/(t26+t63))+0.757211*(1.0*t61*t69/(t68+t66)+.01645530784602056*
        t33*t34*t46*t48*t69/(t67+t66))+0.757211*(1.0*t32*t65/(t64+
        t62)+.01645530784602056*t16*t18*t3*t4*t65/(t63+t62))-.8888888888888888*
        (0.288626048669345*t54*MU*t56+.02468296176903084*t51*t22*t58+
        1.0)*(-2.4*t60*(.1282782438530422*t35*sqrt(t46*t48)*t47-1.0*
        sqrt(t61))-1.417963080724413*t60-.9086531999999999*pow(t59,
        3.0)+.02836373333333333*pow(t59,2.0)-0.0474596*t49*t59)/(pow(t53,
        3.0)*pow(t57,3.0))+.04727288888888889*t58/t57-.05273288888888888*
        t49*(.1282782438530422*t54*MU*t56+1.0)/(pow(t53,2.0)*pow(t57,
        2.0))-.8888888888888888*(0.288626048669345*t25*MU*t27+.02468296176903084*
        t21*t22*t29+1.0)*(-2.4*t31*(.1282782438530422*t5*sqrt(t16*
        t18)*t17-1.0*sqrt(t32))-1.417963080724413*t31-.9086531999999999*
        pow(t30,3.0)+.02836373333333333*pow(t30,2.0)-0.0474596*t19*
        t30)/(pow(t24,3.0)*pow(t28,3.0))+.04727288888888889*t29/t28-
        .05273288888888888*t19*(.1282782438530422*t25*MU*t27+1.0)/
        (pow(t24,2.0)*pow(t28,2.0)));

    return res;
}

static void
hjsx_first(FunFirstFuncDrv *ds, real factor, const FunDensProp *dp)
{
    real dfdra, dfdrb, dfdga, dfdgb, dfdgab;
    real rhoa = dp->rhoa, rhob = dp->rhob;
    real grada = dp->grada, gradb = dp->gradb, gradab = dp->gradab;

    real t1, t2, t3, t4, t5, t6, t7, t8, t9, t10;
    real t11, t12, t13, t14, t15, t16, t17, t18;
    real t19, t20, t21, t22, t23, t24, t25, t26;
    real t27, t28, t29, t30, t31, t32, t33, t34;
    real t35, t36, t37, t38, t39, t40, t41, t42;
    real t43, t44, t45, t46, t47, t48, t49, t50;
    real t51, t52, t53, t54, t55, t56, t57, t58;
    real t59, t60, t61, t62, t63, t64, t65, t66;
    real t67, t68, t69, t70, t71, t72, t73, t74;
    real t75, t76, t77, t78, t79, t80, t81, t82;
    real t83, t84, t85, t86, t87, t88, t89, t90;
    real t91, t92, t93, t94, t95, t96, t97, t98;
    real t99, t100, t101, t102, t103, t104, t105;
    real t106, t107, t108, t109, t110, t111, t112;
    real t113, t114, t115, t116, t117, t118, t119;
    real t120, t121, t122, t123, t124, t125, t126;
    real t127, t128, t129, t130, t131, t132, t133;
    real t134, t135, t136, t137, t138, t139, t140;
    real t141, t142, t143, t144, t145, t146, t147;
    real t148, t149, t150, t151, t152, t153, t154;
    real t155, t156, t157, t158, t159, t160, t161;
    real t162, t163, t164, t165, t166, t167, t168;
    real t169, t170, t171, t172, t173, t174, t175;
    real t176, t177, t178, t179, t180, t181, t182;
    real t183, t184, t185, t186, t187, t188, t189;
    real t190, t191, t192, t193, t194, t195, t196;
    real t197, t198, t199, t200, t201, t202, t203;
    real t204, t205, t206, t207, t208, t209, t210;
    real t211, t212, t213, t214, t215, t216, t217;
    real t218, t219, t220, t221, t222, t223, t224;
    real t225, t226, t227, t228, t229, t230, t231;
    real t232, t233, t234, t235, t236, t237, t238;
    real t239, t240, t241, t242, t243, t244, t245;
    real t246, t247, t248, t249, t250, t251;

    t1 = pow(rhoa,1.333333333333333);
    t2 = pow(rhob,1.333333333333333);
    t3 = t2+t1;
    t4 = pow(grada,2.0);
    t5 = 1/pow(rhoa,2.666666666666667);
    t6 = 0.00411382696150514*t4*t5+1.0;
    t7 = 1/t6;
    t8 = fabs(grada);
    t9 = pow(t8,7.0);
    t10 = 1/pow(rhoa,9.333333333333334);
    t11 = pow(grada,6.0);
    t12 = 1/pow(rhoa,8.0);
    t13 = pow(t8,5.0);
    t14 = 1/pow(rhoa,6.666666666666667);
    t15 = pow(grada,4.0);
    t16 = 1/pow(rhoa,5.333333333333333);
    t17 = pow(t8,3.0);
    t18 = 1/pow(rhoa,4.0);
    t19 = 2.6318783922003747E-4*t4*t5+1.8005513133540818E-4*
        t17*t18-4.342399100269002E-5*t15*t16+5.3020963068324E-6*t13*
        t14-4.3276773969754684E-7*t11*t12+2.412383024769541E-8*t9*
        t10;
    t20 = pow(t8,9.0);
    t21 = 1/pow(rhoa,12.0);
    t22 = pow(grada,8.0);
    t23 = 1/pow(rhoa,10.66666666666667);
    t24 = 1/t1;
    t25 = .6841322473346062*t8*t24-.2053293313026446*t4*t5+
        .02342799068769956*t17*t18-.001383706469760653*t15*t16+5.955909787676884E-5*
        t13*t14-2.719683267627704E-6*t11*t12+1.7578986477855008E-7*
        t9*t10-5.649671283776347E-9*t22*t23+3.149302550983648E-10*
        t20*t21+1.0;
    t26 = 1/t25;
    t27 = -.06934448603031025*t4*t19*t26*t5-.005136628594837796*
        t4*t7*t5-1.0;
    t28 = .01645530784602056*t4*t19*t26*t5;
    t29 = t28+0.60965;
    t30 = pow(t29,2.0);
    t31 = sqrt(t29);
    t32 = pow(t31,7.0);
    t33 = t28+0.757211;
    t34 = sqrt(t33);
    t35 = sqrt(t19*t26);
    t36 = .1282782438530422*t8*t35*t24-1.0*t34;
    t37 = -2.4*t32*t36-1.417963080724413*t32+.02836373333333333*
        t30-.9086531999999999*pow(t29,3.0)-0.0474596*t27*t29;
    t38 = 1/pow(rhoa,.6666666666666666);
    t39 = pow(MU,2.0);
    t40 = .06582123138408225*t38*t39;
    t41 = t40+t28+0.60965;
    t42 = 1/pow(t41,3.0);
    t43 = 1/pow(rhoa,3.666666666666667);
    t44 = -0.0438808209227215*t4*t19*t26*t43;
    t45 = 1/pow(rhoa,10.33333333333333);
    t46 = 1/pow(rhoa,9.0);
    t47 = 1/pow(rhoa,7.666666666666667);
    t48 = 1/pow(rhoa,6.333333333333333);
    t49 = 1/pow(rhoa,5.0);
    t50 = 1/pow(rhoa,2.333333333333333);
    t51 = -3.779163061180378E-9*t20/pow(rhoa,13.0)+6.026316036028103E-8*
        t22/pow(rhoa,11.66666666666667)-.9121763297794749*t8*t50-.09371196275079824*
        t17*t49+.007379767838723482*t15*t48-3.9706065251179234E-4*
        t13*t47+2.175746614102163E-5*t11*t46-1.6407054045998007E-6*
        t9*t45+.5475448834737188*t4*t43;
    t52 = 1/pow(t25,2.0);
    t53 = -.01645530784602056*t4*t19*t51*t52*t5;
    t54 = -7.018342379201E-4*t4*t43-7.202205253416327E-4*
        t17*t49+2.3159461868101347E-4*t15*t48-3.5347308712216E-5*t13*
        t47+3.462141917580374E-6*t11*t46-2.251557489784905E-7*t9*t45;
    t55 = .01645530784602056*
        t4*t54*t26*t5;
    t56 = 1/pow(rhoa,1.666666666666667);
    t57 = -0.0438808209227215*t56*t39+t55+t53+t44;
    t58 = 1/pow(t41,2.0);
    t59 = pow(rhoa,.3333333333333333);
    t60 = 1/t59;
    t61 = sqrt(t41);
    t62 = 1/pow(t61,3.0);
    t63 = 1/t41;
    t64 = 1/t61;
    t65 = .2565564877060844*t60*MU*t64+1.0;
    t66 = 1/pow(t65,3.0);
    t67 = -.08551882923536147*t24*MU*t64-.1282782438530422*
        t60*MU*t57*t62;
    t68 = .1282782438530422*t60*MU*t64+1.0;
    t69 = 1/pow(t65,2.0);
    t70 = 1/pow(t6,2.0);
    t71 = -.06934448603031025*t4*t54*t26*t5+.06934448603031025*
        t4*t19*t51*t52*t5+.1849186294141607*t4*t19*t26*t43+.01369767625290079*
        t4*t7*t43-5.634986987915197E-5*t15*t70*t48;
    t72 = 1/t65;
    t73 = 1/pow(t65,4.0);
    t74 = 0.288626048669345*t60*MU*t64+.02468296176903084*
        t38*t39*t63+1.0;
    t75 = 1/pow(t41,4.0);
    t76 = t55+t53+t44;
    t77 = pow(t31,5.0);
    t78 = 1/t34;
    t79 = 1/t35;
    t80 = sqrt(t40+t28);
    t81 = 1/t80;
    t82 = 0.5*t57*t81;
    t83 = 0.5*t57*t64;
    t84 = .2565564877060844*t60*MU;
    t85 = t61+t84;
    t86 = 1/t85;
    t87 = t61+t80;
    t88 = 1/pow(t87,2.0);
    t89 = -.08551882923536147*t24*MU;
    t90 = t83+t89;
    t91 = 1/pow(t85,2.0);
    t92 = 1/t87;
    t93 = 1.0-0.60965*t86*t92;
    t94 = 1/t93;
    t95 = t80+t84;
    t96 = 1/t95;
    t97 = sqrt(t40+t28+0.757211);
    t98 = 1/t97;
    t99 = 0.5*t57*t98;
    t100 = t99+t82;
    t101 = t97+t80;
    t102 = 1/pow(t101,2.0);
    t103 = t97+t84;
    t104 = 1/t103;
    t105 = 1/pow(t95,2.0);
    t106 = 1/t101;
    t107 = 1/pow(t103,2.0);
    t108 = t97+t61;
    t109 = 1/pow(t108,2.0);
    t110 = 1/t108;
    t111 = .1475609999999999*t86*t110+1.0;
    t112 = 1/t111;
    t113 = log(t93);
    t114 = log(t111);
    t115 = pow(gradb,2.0);
    t116 = 1/pow(rhob,2.666666666666667);
    t117 = 0.00411382696150514*t115*t116+1.0;
    t118 = 1/t117;
    t119 = fabs(gradb);
    t120 = pow(t119,7.0);
    t121 = 1/pow(rhob,9.333333333333334);
    t122 = pow(gradb,6.0);
    t123 = 1/pow(rhob,8.0);
    t124 = pow(t119,5.0);
    t125 = 1/pow(rhob,6.666666666666667);
    t126 = pow(gradb,4.0);
    t127 = 1/pow(rhob,5.333333333333333);
    t128 = pow(t119,3.0);
    t129 = 1/pow(rhob,4.0);
    t130 = 2.6318783922003747E-4*t115*t116+1.8005513133540818E-4*
        t128*t129-4.342399100269002E-5*t126*t127+5.3020963068324E-6*
        t124*t125-4.3276773969754684E-7*t122*t123+2.412383024769541E-8*
        t120*t121;
    t131 = pow(t119,9.0);
    t132 = 1/pow(rhob,12.0);
    t133 = pow(gradb,8.0);
    t134 = 1/pow(rhob,10.66666666666667);
    t135 = 1/t2;
    t136 = .6841322473346062*t119*t135-.2053293313026446*
        t115*t116+.02342799068769956*t128*t129-.001383706469760653*
        t126*t127+5.955909787676884E-5*t124*t125-2.719683267627704E-6*
        t122*t123+1.7578986477855008E-7*t120*t121-5.649671283776347E-9*
        t133*t134+3.149302550983648E-10*t131*t132+1.0;
    t137 = 1/t136;
    t138 = -.06934448603031025*t115*t130*t137*t116-.005136628594837796*
        t115*t118*t116-1.0;
    t139 = .01645530784602056*t115*t130*t137*t116;
    t140 = 1/pow(rhob,.6666666666666666);
    t141 = .06582123138408225*t140*t39;
    t142 = t141+t139+0.60965;
    t143 = 1/pow(t142,2.0);
    t144 = pow(rhob,.3333333333333333);
    t145 = 1/t144;
    t146 = sqrt(t142);
    t147 = 1/t146;
    t148 = .1282782438530422*t145*MU*t147+1.0;
    t149 = .2565564877060844*t145*MU*t147+1.0;
    t150 = 1/pow(t149,2.0);
    t151 = 1/t142;
    t152 = 1/t149;
    t153 = t139+0.60965;
    t154 = pow(t153,2.0);
    t155 = sqrt(t153);
    t156 = pow(t155,7.0);
    t157 = t139+0.757211;
    t158 = sqrt(t157);
    t159 = sqrt(t130*t137);
    t160 = .1282782438530422*t119*t159*t135-1.0*t158;
    t161 = -2.4*t156*t160-1.417963080724413*t156+.02836373333333333*
        t154-.9086531999999999*pow(t153,3.0)-0.0474596*t138*t153;
    t162 = 1/
        pow(t142,3.0);
    t163 = 1/pow(t149,3.0);
    t164 = 0.288626048669345*t145*MU*t147+.02468296176903084*
        t140*t39*t151+1.0;
    t165 = .2565564877060844*t145*MU;
    t166 = sqrt(t141+t139);
    t167 = t166+t165;
    t168 = 1/t167;
    t169 = sqrt(t141+t139+0.757211);
    t170 = t169+t166;
    t171 = 1/t170;
    t172 = t169+t165;
    t173 = 1/t172;
    t174 = t146+t165;
    t175 = 1/t174;
    t176 = t146+t166;
    t177 = 1/t176;
    t178 = 1.0-0.60965*t175*t177;
    t179 = log(t178);
    t180 = t169+t146;
    t181 = 1/t180;
    t182 = .1475609999999999*t175*t181+1.0;
    t183 = log(t182);
    t184 = -2.0*t157*t183+.03291061569204112*t115*t130*t137*
        t116*t179-2.0*t33*t114+.03291061569204112*t4*t19*t26*t5*t113+
        0.757211*(t157*t173*t171+.01645530784602056*t115*t130*t137*
        t116*t168*t171)+0.757211*(t33*t104*t106+.01645530784602056*
        t4*t19*t26*t5*t96*t106)-.8888888888888888*t161*t162*t163*t164+
        .04727288888888889*t151*t152-.05273288888888888*t138*t143*
        t148*t150-.8888888888888888*t37*t42*t66*t74+.04727288888888889*
        t63*t72-.05273288888888888*t27*t58*t68*t69;
    t185 = 1/pow(rhob,3.666666666666667);
    t186 = -0.0438808209227215*t115*t130*t137*t185;
    t187 = 1/pow(rhob,10.33333333333333);
    t188 = 1/pow(rhob,9.0);
    t189 = 1/pow(rhob,7.666666666666667);
    t190 = 1/pow(rhob,6.333333333333333);
    t191 = 1/pow(rhob,5.0);
    t192 = 1/pow(rhob,2.333333333333333);
    t193 = -3.779163061180378E-9*t131/pow(rhob,13.0)+6.026316036028103E-8*
        t133/pow(rhob,11.66666666666667)-.9121763297794749*t119*t192-
        .09371196275079824*t128*t191+.007379767838723482*t126*t190-
        3.9706065251179234E-4*t124*t189+2.175746614102163E-5*t122*
        t188-1.6407054045998007E-6*t120*t187+.5475448834737188*t115*
        t185;
    t194 = 1/pow(t136,2.0);
    t195 = -.01645530784602056*t115*t130*t193*t194*t116;
    t196 = -
        7.018342379201E-4*t115*t185-7.202205253416327E-4*t128*t191+
        2.3159461868101347E-4*t126*t190-3.5347308712216E-5*t124*t189+
        3.462141917580374E-6*t122*t188-2.251557489784905E-7*t120*t187;
    t197 = .01645530784602056*
        t115*t196*t137*t116;
    t198 = 1/pow(rhob,1.666666666666667);
    t199 = -0.0438808209227215*t198*t39+t197+t195+t186;
    t200 = 1/
        pow(t146,3.0);
    t201 = -.08551882923536147*t135*MU*t147-.1282782438530422*
        t145*MU*t199*t200;
    t202 = 1/pow(t117,2.0);
    t203 = -.06934448603031025*t115*t196*t137*t116+.06934448603031025*
        t115*t130*t193*t194*t116+.1849186294141607*t115*t130*t137*
        t185+.01369767625290079*t115*t118*t185-5.634986987915197E-5*
        t126*t202*t190;
    t204 = 1/pow(t149,4.0);
    t205 = 1/pow(t142,4.0);
    t206 = t197+t195+t186;
    t207 = pow(t155,5.0);
    t208 = 1/t158;
    t209 = 1/t159;
    t210 = 1/t166;
    t211 = 0.5*t199*t210;
    t212 = 0.5*t147*t199;
    t213 = 1/pow(t176,2.0);
    t214 = -.08551882923536147*t135*MU;
    t215 = t212+t214;
    t216 = 1/pow(t174,2.0);
    t217 = 1/t178;
    t218 = 1/t169;
    t219 = 0.5*t199*t218;
    t220 = t219+t211;
    t221 = 1/pow(t170,2.0);
    t222 = 1/pow(t167,2.0);
    t223 = 1/pow(t172,2.0);
    t224 = 1/pow(t180,2.0);
    t225 = 1/t182;
    t226 = 1/t8;
    t227 = pow(grada,7.0);
    t228 = pow(grada,5.0);
    t229 = pow(grada,3.0);
    t230 = 2.834372295885283E-9*t21*t226*pow(grada,9.0)-.4106586626052891*
        grada*t5+.6841322473346062*grada*t226*t24-4.519737027021078E-8*
        t227*t23+.07028397206309868*t229*t226*t18-.005534825879042611*
        t229*t16+2.977954893838442E-4*t228*t226*t14-1.6318099605766223E-5*
        t228*t12+1.2305290534498503E-6*t227*t226*t10;
    t231 = 5.263756784400749E-4*grada*t5+5.401653940062245E-4*
        t229*t226*t18-1.736959640107601E-4*t229*t16+2.6510481534162E-5*
        t228*t226*t14-2.5966064381852805E-6*t228*t12+1.6886681173386786E-7*
        t227*t226*t10;
    t232 = .03291061569204112*grada*t19*t26*t5+.01645530784602056*
        t4*t231*t26*t5-.01645530784602056*t4*t19*t230*t52*t5;
    t233 = 1/pow(t61,7.0);
    t234 = -.1386889720606205*grada*t19*t26*t5-.06934448603031025*
        t4*t231*t26*t5+.06934448603031025*t4*t19*t230*t52*t5-.01027325718967559*
        grada*t7*t5+4.2262402409363975E-5*t229*t70*t16;
    t235 = 0.5*t232*t81;
    t236 = 0.5*t232*t64;
    t237 = 0.5*t232*t98;
    t238 = t237+t235;
    t239 = 1/t119;
    t240 = pow(gradb,7.0);
    t241 = pow(gradb,5.0);
    t242 = pow(gradb,3.0);
    t243 = 2.834372295885283E-9*t132*t239*pow(gradb,9.0)+
        .6841322473346062*gradb*t239*t135-4.519737027021078E-8*t240*
        t134+.07028397206309868*t242*t239*t129-.005534825879042611*
        t242*t127+2.977954893838442E-4*t241*t239*t125-1.6318099605766223E-5*
        t241*t123+1.2305290534498503E-6*t240*t239*t121-.4106586626052891*
        gradb*t116;
    t244 = 5.263756784400749E-4*gradb*t116+5.401653940062245E-4*
        t242*t239*t129-1.736959640107601E-4*t242*t127+2.6510481534162E-5*
        t241*t239*t125-2.5966064381852805E-6*t241*t123+1.6886681173386786E-7*
        t240*t239*t121;
    t245 = .03291061569204112*gradb*t130*t137*t116+.01645530784602056*
        t115*t244*t137*t116-.01645530784602056*t115*t130*t243*t194*
        t116;
    t246 = 1/pow(t146,7.0);
    t247 = -.1386889720606205*gradb*t130*t137*t116-.06934448603031025*
        t115*t244*t137*t116+.06934448603031025*t115*t130*t243*t194*
        t116-.01027325718967559*gradb*t118*t116+4.2262402409363975E-5*
        t242*t202*t127;
    t248 = 0.5*t210*t245;
    t249 = 0.5*t147*t245;
    t250 = 0.5*t218*t245;
    t251 = t250+t248;

   /* code */
    dfdra = -0.46526286817455*t3*(0.757211*(-1.0*t106*t107*
        t33*(t99+t89)-1.0*t100*t102*t104*t33-.01645530784602056*t4*
        t19*t51*t52*t5*t96*t106+.01645530784602056*t4*t54*t26*t5*t96*
        t106-0.0438808209227215*t4*t19*t26*t43*t96*t106-.01645530784602056*
        t4*t19*t26*t5*(t82+t89)*t105*t106+t76*t104*t106-.01645530784602056*
        t4*t19*t26*t5*t96*t100*t102)+.03291061569204112*t4*t19*t26*
        t5*(0.60965*t90*t91*t92+0.60965*(t83+t82)*t86*t88)*t94-.8888888888888888*
        t42*t66*t74*(-2.4*t32*(0.0641391219265211*t24*(t54*t26-1.0*
        t19*t51*t52)*t79*t8-0.5*t76*t78-.1710376584707229*t8*t35*t50)-
        4.962870782535445*t76*t77-8.4*t76*t77*t36-2.7259596*t76*t30+
        .05672746666666666*t76*t29-0.0474596*t71*t29-0.0474596*t76*
        t27)+2.666666666666667*t37*t42*t67*t73*t74+2.666666666666667*
        t37*t57*t75*t66*t74-.04727288888888889*t57*t58*t72-.05273288888888888*
        t71*t58*t68*t69+.1054657777777778*t27*t57*t42*t68*t69-.04727288888888889*
        t63*t67*t69-.05273288888888888*t27*t58*(-.04275941461768074*
        t24*MU*t64-0.0641391219265211*t60*MU*t57*t62)*t69+.1054657777777778*
        t27*t58*t67*t68*t66-.8888888888888888*t37*t42*(-.09620868288978165*
        t24*MU*t64-.01645530784602056*t56*t39*t63-.1443130243346725*
        t60*MU*t57*t62-.02468296176903084*t38*t39*t57*t58)*t66-2.0*
        t76*t114-.03291061569204112*t4*t19*t51*t52*t5*t113+.03291061569204112*
        t4*t54*t26*t5*t113-0.087761641845443*t4*t19*t26*t43*t113-2.0*
        t33*(-.1475609999999999*t90*t91*t110-.1475609999999999*t86*
        (t99+t83)*t109)*t112)-0.6203504908994*t59*t184;
    dfdrb = -0.46526286817455*(-2.0*t157*(-.1475609999999999*
        t215*t216*t181-.1475609999999999*t175*(t219+t212)*t224)*t225+
        0.757211*(-1.0*t157*t171*(t219+t214)*t223-1.0*t157*t173*t220*
        t221-.01645530784602056*t115*t130*t137*t116*t168*t220*t221-
        .01645530784602056*t115*t130*t137*t116*(t211+t214)*t222*t171+
        t206*t173*t171-0.0438808209227215*t115*t130*t137*t185*t168*
        t171-.01645530784602056*t115*t130*t193*t194*t116*t168*t171+
        .01645530784602056*t115*t196*t137*t116*t168*t171)+.03291061569204112*
        t115*t130*t137*t116*(0.60965*t215*t216*t177+0.60965*(t212+
        t211)*t175*t213)*t217-.8888888888888888*t162*t163*t164*(-2.4*
        t156*(0.0641391219265211*t119*t135*(t196*t137-1.0*t130*t193*
        t194)*t209-0.5*t206*t208-.1710376584707229*t119*t159*t192)-
        4.962870782535445*t206*t207-8.4*t206*t207*t160-2.7259596*t206*
        t154+.05672746666666666*t206*t153-0.0474596*t203*t153-0.0474596*
        t206*t138)-2.0*t206*t183-0.087761641845443*t115*t130*t137*
        t185*t179-.03291061569204112*t115*t130*t193*t194*t116*t179+
        .03291061569204112*t115*t196*t137*t116*t179+2.666666666666667*
        t161*t162*t201*t204*t164+2.666666666666667*t161*t199*t205*
        t163*t164+.1054657777777778*t138*t143*t201*t148*t163-.8888888888888888*
        t161*t162*(-.09620868288978165*t135*MU*t147-.01645530784602056*
        t198*t39*t151-.1443130243346725*t145*MU*t199*t200-.02468296176903084*
        t140*t39*t199*t143)*t163-.04727288888888889*t199*t143*t152-
        .04727288888888889*t151*t201*t150+.1054657777777778*t138*t199*
        t162*t148*t150-.05273288888888888*t203*t143*t148*t150-.05273288888888888*
        t138*t143*(-.04275941461768074*t135*MU*t147-0.0641391219265211*
        t145*MU*t199*t200)*t150)*t3-0.6203504908994*t144*t184;
    dfdga = -0.46526286817455*t3*(-.3420753169414459*t232*
        t37*t60*t73*t74*MU/pow(t61,9.0)+.006064083168526658*t232*t60*
        t69*MU/pow(t61,5.0)+0.757211*(-0.5*t106*t107*t232*t33*t98-
        1.0*t102*t104*t238*t33-.01645530784602056*t4*t19*t230*t52*
        t5*t96*t106+.01645530784602056*t4*t231*t26*t5*t96*t106+.03291061569204112*
        grada*t19*t26*t5*t96*t106-0.00822765392301028*t4*t19*t232*
        t26*t5*t81*t105*t106+t232*t104*t106-.01645530784602056*t4*
        t19*t26*t5*t96*t238*t102)+.03291061569204112*t4*t19*t26*t5*
        (0.304825*t232*t64*t91*t92+0.60965*(t236+t235)*t86*t88)*t94-
        .8888888888888888*t42*t66*t74*(-2.4*t32*(0.0641391219265211*
        t24*(t231*t26-1.0*t19*t230*t52)*t79*t8-0.5*t232*t78+.1282782438530422*
        grada*t226*t35*t24)-4.962870782535445*t232*t77-8.4*t232*t77*
        t36-2.7259596*t232*t30-0.0474596*t234*t29+.05672746666666666*
        t232*t29-0.0474596*t232*t27)+2.666666666666667*t232*t37*t75*
        t66*t74-.04727288888888889*t232*t58*t72-.05273288888888888*
        t234*t58*t68*t69+.1054657777777778*t232*t27*t42*t68*t69+.003382241189982134*
        t232*t27*t60*MU*t233*t69-.01352896475992854*t232*t27*t60*MU*
        t233*t68*t66-.8888888888888888*t37*t42*(-.1443130243346725*
        t232*t60*MU*t62-.02468296176903084*t232*t38*t39*t58)*t66-2.0*
        t232*t114-.03291061569204112*t4*t19*t230*t52*t5*t113+.03291061569204112*
        t4*t231*t26*t5*t113+.06582123138408225*grada*t19*t26*t5*t113-
        2.0*t33*(-.07378049999999997*t232*t64*t91*t110-.1475609999999999*
        t86*(t237+t236)*t109)*t112);
    dfdgb = -0.46526286817455*t3*(-.3420753169414459*t145*
        t161*t164*t204*t245*MU/pow(t146,9.0)+.006064083168526658*t145*
        t150*t245*MU/pow(t146,5.0)+0.757211*(-1.0*t157*t173*t221*t251-
        0.5*t157*t171*t218*t223*t245-.01645530784602056*t115*t130*
        t137*t116*t168*t251*t221-0.00822765392301028*t115*t130*t245*
        t137*t116*t210*t222*t171+t245*t173*t171-.01645530784602056*
        t115*t130*t243*t194*t116*t168*t171+.01645530784602056*t115*
        t244*t137*t116*t168*t171+.03291061569204112*gradb*t130*t137*
        t116*t168*t171)-.8888888888888888*t162*t163*t164*(-2.4*t156*
        (-0.5*t208*t245+0.0641391219265211*t119*t135*t209*(t244*t137-
        1.0*t130*t194*t243)+.1282782438530422*gradb*t239*t159*t135)-
        4.962870782535445*t245*t207-8.4*t245*t207*t160-2.7259596*t245*
        t154-0.0474596*t247*t153+.05672746666666666*t245*t153-0.0474596*
        t245*t138)-2.0*t157*(-.07378049999999997*t245*t147*t216*t181-
        .1475609999999999*t175*(t250+t249)*t224)*t225+.03291061569204112*
        t115*t130*t137*t116*(0.304825*t245*t147*t216*t177+0.60965*
        (t249+t248)*t175*t213)*t217-2.0*t245*t183-.03291061569204112*
        t115*t130*t243*t194*t116*t179+.03291061569204112*t115*t244*
        t137*t116*t179+.06582123138408225*gradb*t130*t137*t116*t179+
        2.666666666666667*t245*t161*t205*t163*t164-.8888888888888888*
        t161*t162*(-.1443130243346725*t245*t145*MU*t200-.02468296176903084*
        t245*t140*t39*t143)*t163-.01352896475992854*t245*t138*t145*
        MU*t246*t148*t163-.04727288888888889*t245*t143*t152+.003382241189982134*
        t245*t138*t145*MU*t246*t150+.1054657777777778*t245*t138*t162*
        t148*t150-.05273288888888888*t247*t143*t148*t150);
    dfdgab = 0.0;


    ds->df1000 += factor*dfdra;
    ds->df0100 += factor*dfdrb;
    ds->df0010 += factor*dfdga;
    ds->df0001 += factor*dfdgb;
    ds->df00001+= factor*dfdgab;
   
}

static void
hjsx_second(FunSecondFuncDrv *ds, real factor, const FunDensProp* dp)
{
    real dfdra, dfdrb, dfdga, dfdgb, dfdgab;
    real d2fdrara, d2fdrarb, d2fdraga, d2fdragb, d2fdraab, d2fdrbrb,
        d2fdrbga, d2fdrbgb, d2fdrbgab, d2fdgaga, d2fdgagb, d2fdgagab,
        d2fdgbgb, d2fdgbgab, d2fdgabgab;
    real rhoa = dp->rhoa, rhob = dp->rhob;
    real grada = dp->grada, gradb = dp->gradb, gradab = dp->gradab;

    real t1, t2, t3, t4, t5, t6, t7, t8, t9, t10;
    real t11, t12, t13, t14, t15, t16, t17, t18;
    real t19, t20, t21, t22, t23, t24, t25, t26;
    real t27, t28, t29, t30, t31, t32, t33, t34;
    real t35, t36, t37, t38, t39, t40, t41, t42;
    real t43, t44, t45, t46, t47, t48, t49, t50;
    real t51, t52, t53, t54, t55, t56, t57, t58;
    real t59, t60, t61, t62, t63, t64, t65, t66;
    real t67, t68, t69, t70, t71, t72, t73, t74;
    real t75, t76, t77, t78, t79, t80, t81, t82;
    real t83, t84, t85, t86, t87, t88, t89, t90;
    real t91, t92, t93, t94, t95, t96, t97, t98;
    real t99, t100, t101, t102, t103, t104, t105;
    real t106, t107, t108, t109, t110, t111, t112;
    real t113, t114, t115, t116, t117, t118, t119;
    real t120, t121, t122, t123, t124, t125, t126;
    real t127, t128, t129, t130, t131, t132, t133;
    real t134, t135, t136, t137, t138, t139, t140;
    real t141, t142, t143, t144, t145, t146, t147;
    real t148, t149, t150, t151, t152, t153, t154;
    real t155, t156, t157, t158, t159, t160, t161;
    real t162, t163, t164, t165, t166, t167, t168;
    real t169, t170, t171, t172, t173, t174, t175;
    real t176, t177, t178, t179, t180, t181, t182;
    real t183, t184, t185, t186, t187, t188, t189;
    real t190, t191, t192, t193, t194, t195, t196;
    real t197, t198, t199, t200, t201, t202, t203;
    real t204, t205, t206, t207, t208, t209, t210;
    real t211, t212, t213, t214, t215, t216, t217;
    real t218, t219, t220, t221, t222, t223, t224;
    real t225, t226, t227, t228, t229, t230, t231;
    real t232, t233, t234, t235, t236, t237, t238;
    real t239, t240, t241, t242, t243, t244, t245;
    real t246, t247, t248, t249, t250, t251, t252;
    real t253, t254, t255, t256, t257, t258, t259;
    real t260, t261, t262, t263, t264, t265, t266;
    real t267, t268, t269, t270, t271, t272, t273;
    real t274, t275, t276, t277, t278, t279, t280;
    real t281, t282, t283, t284, t285, t286, t287;
    real t288, t289, t290, t291, t292, t293, t294;
    real t295, t296, t297, t298, t299, t300, t301;
    real t302, t303, t304, t305, t306, t307, t308;
    real t309, t310, t311, t312, t313, t314, t315;
    real t316, t317, t318, t319, t320, t321, t322;
    real t323, t324, t325, t326, t327, t328, t329;
    real t330, t331, t332, t333, t334, t335, t336;
    real t337, t338, t339, t340, t341, t342, t343;
    real t344, t345, t346, t347, t348, t349, t350;
    real t351, t352, t353, t354, t355, t356, t357;
    real t358, t359, t360, t361, t362, t363, t364;
    real t365, t366, t367, t368, t369, t370, t371;
    real t372, t373, t374, t375, t376, t377, t378;
    real t379, t380, t381, t382, t383, t384, t385;
    real t386, t387, t388, t389, t390, t391, t392;
    real t393, t394, t395, t396, t397, t398, t399;
    real t400, t401, t402, t403, t404, t405, t406;
    real t407, t408, t409, t410, t411, t412, t413;
    real t414, t415, t416, t417, t418, t419, t420;
    real t421, t422, t423, t424, t425, t426, t427;
    real t428, t429, t430, t431, t432, t433, t434;
    real t435, t436, t437, t438, t439, t440, t441;
    real t442, t443, t444, t445, t446, t447, t448;
    real t449, t450, t451, t452, t453, t454, t455;
    real t456, t457, t458, t459, t460, t461, t462;
    real t463, t464, t465, t466, t467;

    t1 = pow(rhoa,1.333333333333333);
    t2 = pow(rhob,1.333333333333333);
    t3 = t2+t1;
    t4 = pow(grada,2.0);
    t5 = 1/pow(rhoa,2.666666666666667);
    t6 = 0.00411382696150514*t4*t5+1.0;
    t7 = 1/t6;
    t8 = fabs(grada);
    t9 = pow(t8,7.0);
    t10 = 1/pow(rhoa,9.333333333333334);
    t11 = pow(grada,6.0);
    t12 = 1/pow(rhoa,8.0);
    t13 = pow(t8,5.0);
    t14 = 1/pow(rhoa,6.666666666666667);
    t15 = pow(grada,4.0);
    t16 = 1/pow(rhoa,5.333333333333333);
    t17 = pow(t8,3.0);
    t18 = 1/pow(rhoa,4.0);
    t19 = 2.6318783922003747E-4*t4*t5+1.8005513133540818E-4*
        t17*t18-4.342399100269002E-5*t15*t16+5.3020963068324E-6*t13*
        t14-4.3276773969754684E-7*t11*t12+2.412383024769541E-8*t9*
        t10;
    t20 = pow(t8,9.0);
    t21 = 1/pow(rhoa,12.0);
    t22 = pow(grada,8.0);
    t23 = 1/pow(rhoa,10.66666666666667);
    t24 = 1/t1;
    t25 = .6841322473346062*t8*t24-.2053293313026446*t4*t5+
        .02342799068769956*t17*t18-.001383706469760653*t15*t16+5.955909787676884E-5*
        t13*t14-2.719683267627704E-6*t11*t12+1.7578986477855008E-7*
        t9*t10-5.649671283776347E-9*t22*t23+3.149302550983648E-10*
        t20*t21+1.0;
    t26 = 1/t25;
    t27 = -.06934448603031025*t4*t19*t26*t5-.005136628594837796*
        t4*t7*t5-1.0;
    t28 = .01645530784602056*t4*t19*t26*t5;
    t29 = t28+0.60965;
    t30 = pow(t29,2.0);
    t31 = sqrt(t29);
    t32 = pow(t31,7.0);
    t33 = t28+0.757211;
    t34 = sqrt(t33);
    t35 = sqrt(t19*t26);
    t36 = .1282782438530422*t8*t35*t24-1.0*t34;
    t37 = -2.4*t32*t36-1.417963080724413*t32+.02836373333333333*
        t30-.9086531999999999*pow(t29,3.0)-0.0474596*t27*t29;
    t38 = 1/pow(rhoa,.6666666666666666);
    t39 = pow(MU,2.0);
    t40 = .06582123138408225*t38*t39;
    t41 = t40+t28+0.60965;
    t42 = 1/pow(t41,3.0);
    t43 = 1/pow(rhoa,3.666666666666667);
    t44 = -0.0438808209227215*t4*t19*t26*t43;
    t45 = 1/pow(rhoa,13.0);
    t46 = 1/pow(rhoa,11.66666666666667);
    t47 = 1/pow(rhoa,10.33333333333333);
    t48 = 1/pow(rhoa,9.0);
    t49 = 1/pow(rhoa,7.666666666666667);
    t50 = 1/pow(rhoa,6.333333333333333);
    t51 = 1/pow(rhoa,5.0);
    t52 = 1/pow(rhoa,2.333333333333333);
    t53 = -.9121763297794749*t8*t52+.5475448834737188*t4*
        t43-.09371196275079824*t17*t51+.007379767838723482*t15*t50-
        3.9706065251179234E-4*t13*t49+2.175746614102163E-5*t11*t48-
        1.6407054045998007E-6*t9*t47+6.026316036028103E-8*t22*t46-
        3.779163061180378E-9*t20*t45;
    t54 = 1/pow(t25,2.0);
    t55 = -.01645530784602056*t4*t19*t53*t54*t5;
    t56 = -7.018342379201E-4*t4*t43-7.202205253416327E-4*
        t17*t51+2.3159461868101347E-4*t15*t50-3.5347308712216E-5*t13*
        t49+3.462141917580374E-6*t11*t48-2.251557489784905E-7*t9*t47;
    t57 = .01645530784602056*
        t4*t56*t26*t5;
    t58 = 1/pow(rhoa,1.666666666666667);
    t59 = -0.0438808209227215*t58*t39+t57+t55+t44;
    t60 = 1/pow(t41,2.0);
    t61 = pow(rhoa,.3333333333333333);
    t62 = 1/t61;
    t63 = sqrt(t41);
    t64 = 1/pow(t63,3.0);
    t65 = 1/t41;
    t66 = 1/t63;
    t67 = -.09620868288978165*t24*MU*t66-.01645530784602056*
        t58*t39*t65-.1443130243346725*t62*MU*t59*t64-.02468296176903084*
        t38*t39*t59*t60;
    t68 = .2565564877060844*t62*MU*t66+1.0;
    t69 = 1/pow(t68,3.0);
    t70 = -.08551882923536147*t24*MU*t66-.1282782438530422*
        t62*MU*t59*t64;
    t71 = .1282782438530422*t62*MU*t66+1.0;
    t72 = 1/pow(t68,2.0);
    t73 = -.04275941461768074*t24*MU*t66-0.0641391219265211*
        t62*MU*t59*t64;
    t74 = 1/pow(t6,2.0);
    t75 = -.06934448603031025*t4*t56*t26*t5+.06934448603031025*
        t4*t19*t53*t54*t5+.1849186294141607*t4*t19*t26*t43+.01369767625290079*
        t4*t7*t43-5.634986987915197E-5*t15*t74*t50;
    t76 = 1/t68;
    t77 = 1/pow(t68,4.0);
    t78 = 0.288626048669345*t62*MU*t66+.02468296176903084*
        t38*t39*t65+1.0;
    t79 = 1/pow(t41,4.0);
    t80 = t57+t55+t44;
    t81 = pow(t31,5.0);
    t82 = 1/t34;
    t83 = 1/t35;
    t84 = t56*t26-1.0*t19*t53*t54;
    t85 = -0.5*t80*t82-.1710376584707229*t8*t35*t52+0.0641391219265211*
        t8*t83*t84*t24;
    t86 = -2.4*t32*t85-8.4*t80*t81*t36-4.962870782535445*
        t80*t81-2.7259596*t80*t30+.05672746666666666*t80*t29-0.0474596*
        t75*t29-0.0474596*t80*t27;
    t87 = t40+t28;
    t88 = sqrt(t87);
    t89 = 1/t88;
    t90 = 0.5*t59*t89;
    t91 = 0.5*t59*t66;
    t92 = t91+t90;
    t93 = .2565564877060844*t62*MU;
    t94 = t63+t93;
    t95 = 1/t94;
    t96 = t63+t88;
    t97 = 1/pow(t96,2.0);
    t98 = -.08551882923536147*t24*MU;
    t99 = t91+t98;
    t100 = 1/pow(t94,2.0);
    t101 = 1/t96;
    t102 = 0.60965*t99*t100*t101+0.60965*t92*t95*t97;
    t103 = 1.0-0.60965*t95*t101;
    t104 = 1/t103;
    t105 = t88+t93;
    t106 = 1/t105;
    t107 = t40+t28+0.757211;
    t108 = sqrt(t107);
    t109 = 1/t108;
    t110 = 0.5*t109*t59;
    t111 = t110+t90;
    t112 = t108+t88;
    t113 = 1/pow(t112,2.0);
    t114 = t108+t93;
    t115 = 1/t114;
    t116 = t90+t98;
    t117 = 1/pow(t105,2.0);
    t118 = 1/t112;
    t119 = t110+t98;
    t120 = 1/pow(t114,2.0);
    t121 = t110+t91;
    t122 = t108+t63;
    t123 = 1/pow(t122,2.0);
    t124 = 1/t122;
    t125 = -.1475609999999999*t99*t100*t124-.1475609999999999*
        t95*t121*t123;
    t126 = .1475609999999999*t95*t124+1.0;
    t127 = 1/t126;
    t128 = log(t103);
    t129 = log(t126);
    t130 = 2.666666666666667*t37*t42*t70*t77*t78+2.666666666666667*
        t37*t59*t79*t69*t78-.8888888888888888*t86*t42*t69*t78-.04727288888888889*
        t59*t60*t76-.05273288888888888*t27*t60*t73*t72-.05273288888888888*
        t75*t60*t71*t72+.1054657777777778*t27*t59*t42*t71*t72-.04727288888888889*
        t65*t70*t72+.1054657777777778*t27*t60*t70*t71*t69-.8888888888888888*
        t37*t42*t67*t69+0.757211*(-1.0*t118*t119*t120*t33-1.0*t111*
        t113*t115*t33-.01645530784602056*t4*t19*t26*t5*t116*t117*t118+
        t80*t115*t118-.01645530784602056*t4*t19*t53*t54*t5*t106*t118+
        .01645530784602056*t4*t56*t26*t5*t106*t118-0.0438808209227215*
        t4*t19*t26*t43*t106*t118-.01645530784602056*t4*t19*t26*t5*
        t106*t111*t113)-2.0*t80*t129-.03291061569204112*t4*t19*t53*
        t54*t5*t128+.03291061569204112*t4*t56*t26*t5*t128-0.087761641845443*
        t4*t19*t26*t43*t128-2.0*t33*t125*t127+.03291061569204112*t4*
        t19*t26*t5*t102*t104;
    t131 = pow(gradb,2.0);
    t132 = 1/pow(rhob,2.666666666666667);
    t133 = 0.00411382696150514*t131*t132+1.0;
    t134 = 1/t133;
    t135 = fabs(gradb);
    t136 = pow(t135,7.0);
    t137 = 1/pow(rhob,9.333333333333334);
    t138 = pow(gradb,6.0);
    t139 = 1/pow(rhob,8.0);
    t140 = pow(t135,5.0);
    t141 = 1/pow(rhob,6.666666666666667);
    t142 = pow(gradb,4.0);
    t143 = 1/pow(rhob,5.333333333333333);
    t144 = pow(t135,3.0);
    t145 = 1/pow(rhob,4.0);
    t146 = 2.6318783922003747E-4*t131*t132+1.8005513133540818E-4*
        t144*t145-4.342399100269002E-5*t142*t143+5.3020963068324E-6*
        t140*t141-4.3276773969754684E-7*t138*t139+2.412383024769541E-8*
        t136*t137;
    t147 = pow(t135,9.0);
    t148 = 1/pow(rhob,12.0);
    t149 = pow(gradb,8.0);
    t150 = 1/pow(rhob,10.66666666666667);
    t151 = 1/t2;
    t152 = .6841322473346062*t135*t151-.2053293313026446*
        t131*t132+.02342799068769956*t144*t145-.001383706469760653*
        t142*t143+5.955909787676884E-5*t140*t141-2.719683267627704E-6*
        t138*t139+1.7578986477855008E-7*t136*t137-5.649671283776347E-9*
        t149*t150+3.149302550983648E-10*t147*t148+1.0;
    t153 = 1/t152;
    t154 = -.06934448603031025*t131*t146*t153*t132-.005136628594837796*
        t131*t134*t132-1.0;
    t155 = .01645530784602056*t131*t146*t153*t132;
    t156 = 1/pow(rhob,.6666666666666666);
    t157 = .06582123138408225*t156*t39;
    t158 = t157+t155+0.60965;
    t159 = 1/pow(t158,2.0);
    t160 = pow(rhob,.3333333333333333);
    t161 = 1/t160;
    t162 = sqrt(t158);
    t163 = 1/t162;
    t164 = .1282782438530422*t161*MU*t163+1.0;
    t165 = .2565564877060844*t161*MU*t163+1.0;
    t166 = 1/pow(t165,2.0);
    t167 = 1/t158;
    t168 = 1/t165;
    t169 = t155+0.60965;
    t170 = pow(t169,2.0);
    t171 = sqrt(t169);
    t172 = pow(t171,7.0);
    t173 = t155+0.757211;
    t174 = sqrt(t173);
    t175 = sqrt(t146*t153);
    t176 = .1282782438530422*t135*t175*t151-1.0*t174;
    t177 = -2.4*t172*t176-1.417963080724413*t172+.02836373333333333*
        t170-.9086531999999999*pow(t169,3.0)-0.0474596*t154*t169;
    t178 = 1/
        pow(t158,3.0);
    t179 = 1/pow(t165,3.0);
    t180 = 0.288626048669345*t161*MU*t163+.02468296176903084*
        t156*t39*t167+1.0;
    t181 = .2565564877060844*t161*MU;
    t182 = t157+t155;
    t183 = sqrt(t182);
    t184 = t183+t181;
    t185 = 1/t184;
    t186 = t157+t155+0.757211;
    t187 = sqrt(t186);
    t188 = t187+t183;
    t189 = 1/t188;
    t190 = t187+t181;
    t191 = 1/t190;
    t192 = t162+t181;
    t193 = 1/t192;
    t194 = t162+t183;
    t195 = 1/t194;
    t196 = 1.0-0.60965*t193*t195;
    t197 = log(t196);
    t198 = t187+t162;
    t199 = 1/t198;
    t200 = .1475609999999999*t193*t199+1.0;
    t201 = log(t200);
    t202 = -2.0*t173*t201+.03291061569204112*t131*t146*t153*
        t132*t197-2.0*t33*t129+.03291061569204112*t4*t19*t26*t5*t128+
        0.757211*(t173*t191*t189+.01645530784602056*t131*t146*t153*
        t132*t185*t189)+0.757211*(t33*t115*t118+.01645530784602056*
        t4*t19*t26*t5*t106*t118)-.8888888888888888*t177*t178*t179*
        t180+.04727288888888889*t167*t168-.05273288888888888*t154*
        t159*t164*t166-.8888888888888888*t37*t42*t69*t78+.04727288888888889*
        t65*t76-.05273288888888888*t27*t60*t71*t72;
    t203 = 1/pow(rhob,3.666666666666667);
    t204 = -0.0438808209227215*t131*t146*t153*t203;
    t205 = 1/pow(rhob,13.0);
    t206 = 1/pow(rhob,11.66666666666667);
    t207 = 1/pow(rhob,10.33333333333333);
    t208 = 1/pow(rhob,9.0);
    t209 = 1/pow(rhob,7.666666666666667);
    t210 = 1/pow(rhob,6.333333333333333);
    t211 = 1/pow(rhob,5.0);
    t212 = 1/pow(rhob,2.333333333333333);
    t213 = -.9121763297794749*t135*t212+.5475448834737188*
        t131*t203-.09371196275079824*t144*t211+.007379767838723482*
        t142*t210-3.9706065251179234E-4*t140*t209+2.175746614102163E-5*
        t138*t208-1.6407054045998007E-6*t136*t207+6.026316036028103E-8*
        t149*t206-3.779163061180378E-9*t147*t205;
    t214 = 1/pow(t152,2.0);
    t215 = -.01645530784602056*t131*t146*t213*t214*t132;
    t216 = -
        7.018342379201E-4*t131*t203-7.202205253416327E-4*t144*t211+
        2.3159461868101347E-4*t142*t210-3.5347308712216E-5*t140*t209+
        3.462141917580374E-6*t138*t208-2.251557489784905E-7*t136*t207;
    t217 = .01645530784602056*
        t131*t216*t153*t132;
    t218 = 1/pow(rhob,1.666666666666667);
    t219 = -0.0438808209227215*t218*t39+t217+t215+t204;
    t220 = 1/
        pow(t162,3.0);
    t221 = -.09620868288978165*t151*MU*t163-.01645530784602056*
        t218*t39*t167-.1443130243346725*t161*MU*t219*t220-.02468296176903084*
        t156*t39*t219*t159;
    t222 = -.08551882923536147*t151*MU*t163-.1282782438530422*
        t161*MU*t219*t220;
    t223 = -.04275941461768074*t151*MU*t163-0.0641391219265211*
        t161*MU*t219*t220;
    t224 = 1/pow(t133,2.0);
    t225 = -.06934448603031025*t131*t216*t153*t132+.06934448603031025*
        t131*t146*t213*t214*t132+.1849186294141607*t131*t146*t153*
        t203+.01369767625290079*t131*t134*t203-5.634986987915197E-5*
        t142*t224*t210;
    t226 = 1/pow(t165,4.0);
    t227 = 1/pow(t158,4.0);
    t228 = t217+t215+t204;
    t229 = pow(t171,5.0);
    t230 = 1/t174;
    t231 = 1/t175;
    t232 = t216*t153-1.0*t146*t213*t214;
    t233 = -0.5*t228*t230-.1710376584707229*t135*t175*t212+
        0.0641391219265211*t135*t231*t232*t151;
    t234 = -2.4*t172*t233-8.4*t228*t229*t176-4.962870782535445*
        t228*t229-2.7259596*t228*t170+.05672746666666666*t228*t169-
        0.0474596*t225*t169-0.0474596*t228*t154;
    t235 = 1/t183;
    t236 = 0.5*t219*t235;
    t237 = 0.5*t163*t219;
    t238 = t237+t236;
    t239 = 1/pow(t194,2.0);
    t240 = -.08551882923536147*t151*MU;
    t241 = t237+t240;
    t242 = 1/pow(t192,2.0);
    t243 = 0.60965*t241*t242*t195+0.60965*t238*t193*t239;
    t244 = 1/
        t196;
    t245 = 1/t187;
    t246 = 0.5*t219*t245;
    t247 = t246+t236;
    t248 = 1/pow(t188,2.0);
    t249 = t236+t240;
    t250 = 1/pow(t184,2.0);
    t251 = t246+t240;
    t252 = 1/pow(t190,2.0);
    t253 = t246+t237;
    t254 = 1/pow(t198,2.0);
    t255 = -.1475609999999999*t241*t242*t199-.1475609999999999*
        t193*t253*t254;
    t256 = 1/t200;
    t257 = -2.0*t173*t255*t256+0.757211*(-1.0*t173*t189*t251*
        t252-1.0*t173*t191*t247*t248-.01645530784602056*t131*t146*
        t153*t132*t185*t247*t248-.01645530784602056*t131*t146*t153*
        t132*t249*t250*t189+t228*t191*t189-0.0438808209227215*t131*
        t146*t153*t203*t185*t189-.01645530784602056*t131*t146*t213*
        t214*t132*t185*t189+.01645530784602056*t131*t216*t153*t132*
        t185*t189)+.03291061569204112*t131*t146*t153*t132*t243*t244-
        2.0*t228*t201-0.087761641845443*t131*t146*t153*t203*t197-.03291061569204112*
        t131*t146*t213*t214*t132*t197+.03291061569204112*t131*t216*
        t153*t132*t197+2.666666666666667*t177*t178*t222*t226*t180+
        2.666666666666667*t177*t219*t227*t179*t180-.8888888888888888*
        t234*t178*t179*t180-.8888888888888888*t177*t178*t221*t179+
        .1054657777777778*t154*t159*t222*t164*t179-.04727288888888889*
        t219*t159*t168-.05273288888888888*t154*t159*t223*t166-.04727288888888889*
        t167*t222*t166+.1054657777777778*t154*t219*t178*t164*t166-
        .05273288888888888*t225*t159*t164*t166;
    t258 = pow(grada,9.0);
    t259 = 1/t8;
    t260 = pow(grada,7.0);
    t261 = pow(grada,5.0);
    t262 = pow(grada,3.0);
    t263 = .6841322473346062*grada*t259*t24-.4106586626052891*
        grada*t5+.07028397206309868*t262*t259*t18-.005534825879042611*
        t262*t16+2.977954893838442E-4*t261*t259*t14-1.6318099605766223E-5*
        t261*t12+1.2305290534498503E-6*t260*t259*t10-4.519737027021078E-8*
        t260*t23+2.834372295885283E-9*t258*t259*t21;
    t264 = 5.263756784400749E-4*grada*t5+5.401653940062245E-4*
        t262*t259*t18-1.736959640107601E-4*t262*t16+2.6510481534162E-5*
        t261*t259*t14-2.5966064381852805E-6*t261*t12+1.6886681173386786E-7*
        t260*t259*t10;
    t265 = .03291061569204112*grada*t19*t26*t5+.01645530784602056*
        t4*t264*t26*t5-.01645530784602056*t4*t19*t263*t54*t5;
    t266 = -.1443130243346725*t265*t62*MU*t64-.02468296176903084*
        t265*t38*t39*t60;
    t267 = 1/pow(t63,7.0);
    t268 = 1/pow(t63,5.0);
    t269 = -.1386889720606205*grada*t19*t26*t5-.06934448603031025*
        t4*t264*t26*t5+.06934448603031025*t4*t19*t263*t54*t5-.01027325718967559*
        grada*t7*t5+4.2262402409363975E-5*t262*t74*t16;
    t270 = 1/pow(t63,9.0);
    t271 = t264*t26-1.0*t19*t263*t54;
    t272 = -0.5*t265*t82+.1282782438530422*grada*t259*t35*
        t24+0.0641391219265211*t8*t83*t271*t24;
    t273 = -2.4*t32*t272-8.4*t265*t81*t36-4.962870782535445*
        t265*t81-2.7259596*t265*t30+.05672746666666666*t265*t29-0.0474596*
        t269*t29-0.0474596*t265*t27;
    t274 = 0.5*t265*t89;
    t275 = 0.5*t265*t66;
    t276 = t275+t274;
    t277 = 0.304825*t265*t66*t100*t101+0.60965*t276*t95*t97;
    t278 = 0.5*
        t109*t265;
    t279 = t278+t274;
    t280 = t278+t275;
    t281 = -.07378049999999997*t265*t66*t100*t124-.1475609999999999*
        t95*t280*t123;
    t282 = -.3420753169414459*t265*t37*t62*MU*t270*t77*t78+
        2.666666666666667*t265*t37*t79*t69*t78-.8888888888888888*t273*
        t42*t69*t78-.04727288888888889*t265*t60*t76-.05273288888888888*
        t269*t60*t71*t72+.1054657777777778*t265*t27*t42*t71*t72+.006064083168526658*
        t265*t62*MU*t268*t72+.003382241189982134*t265*t27*t62*MU*t267*
        t72-.01352896475992854*t265*t27*t62*MU*t267*t71*t69-.8888888888888888*
        t37*t42*t266*t69+0.757211*(-1.0*t113*t115*t279*t33-0.5*t109*
        t118*t120*t265*t33-0.00822765392301028*t4*t19*t265*t26*t5*
        t89*t117*t118+t265*t115*t118-.01645530784602056*t4*t19*t263*
        t54*t5*t106*t118+.01645530784602056*t4*t264*t26*t5*t106*t118+
        .03291061569204112*grada*t19*t26*t5*t106*t118-.01645530784602056*
        t4*t19*t26*t5*t106*t279*t113)-2.0*t265*t129-.03291061569204112*
        t4*t19*t263*t54*t5*t128+.03291061569204112*t4*t264*t26*t5*
        t128+.06582123138408225*grada*t19*t26*t5*t128-2.0*t33*t281*
        t127+.03291061569204112*t4*t19*t26*t5*t277*t104;
    t283 = pow(gradb,9.0);
    t284 = 1/t135;
    t285 = pow(gradb,7.0);
    t286 = pow(gradb,5.0);
    t287 = pow(gradb,3.0);
    t288 = .6841322473346062*gradb*t284*t151-.4106586626052891*
        gradb*t132+.07028397206309868*t287*t284*t145-.005534825879042611*
        t287*t143+2.977954893838442E-4*t286*t284*t141-1.6318099605766223E-5*
        t286*t139+1.2305290534498503E-6*t285*t284*t137-4.519737027021078E-8*
        t285*t150+2.834372295885283E-9*t283*t284*t148;
    t289 = 5.263756784400749E-4*gradb*t132+5.401653940062245E-4*
        t287*t284*t145-1.736959640107601E-4*t287*t143+2.6510481534162E-5*
        t286*t284*t141-2.5966064381852805E-6*t286*t139+1.6886681173386786E-7*
        t285*t284*t137;
    t290 = .03291061569204112*gradb*t146*t153*t132+.01645530784602056*
        t131*t289*t153*t132-.01645530784602056*t131*t146*t288*t214*
        t132;
    t291 = -.1443130243346725*t290*t161*MU*t220-.02468296176903084*
        t290*t156*t39*t159;
    t292 = 1/pow(t162,7.0);
    t293 = 1/pow(t162,5.0);
    t294 = -.1386889720606205*gradb*t146*t153*t132-.06934448603031025*
        t131*t289*t153*t132+.06934448603031025*t131*t146*t288*t214*
        t132-.01027325718967559*gradb*t134*t132+4.2262402409363975E-5*
        t287*t224*t143;
    t295 = 1/pow(t162,9.0);
    t296 = t289*t153-1.0*t146*t214*t288;
    t297 = -0.5*t230*t290+0.0641391219265211*t135*t231*t296*
        t151+.1282782438530422*gradb*t284*t175*t151;
    t298 = -2.4*t172*t297-8.4*t290*t229*t176-4.962870782535445*
        t290*t229-2.7259596*t290*t170+.05672746666666666*t290*t169-
        0.0474596*t294*t169-0.0474596*t290*t154;
    t299 = 0.5*t235*t290;
    t300 = 0.5*t163*t290;
    t301 = t300+t299;
    t302 = 0.304825*t290*t163*t242*t195+0.60965*t301*t193*
        t239;
    t303 = 0.5*t245*t290;
    t304 = t303+t299;
    t305 = t303+t300;
    t306 = -.07378049999999997*t290*t163*t242*t199-.1475609999999999*
        t193*t305*t254;
    t307 = 0.757211*(-1.0*t173*t191*t248*t304-0.5*t173*t189*
        t245*t252*t290-.01645530784602056*t131*t146*t153*t132*t185*
        t304*t248-0.00822765392301028*t131*t146*t290*t153*t132*t235*
        t250*t189+t290*t191*t189-.01645530784602056*t131*t146*t288*
        t214*t132*t185*t189+.01645530784602056*t131*t289*t153*t132*
        t185*t189+.03291061569204112*gradb*t146*t153*t132*t185*t189)-
        2.0*t173*t306*t256+.03291061569204112*t131*t146*t153*t132*
        t302*t244-2.0*t290*t201-.03291061569204112*t131*t146*t288*
        t214*t132*t197+.03291061569204112*t131*t289*t153*t132*t197+
        .06582123138408225*gradb*t146*t153*t132*t197-.3420753169414459*
        t290*t177*t161*MU*t295*t226*t180+2.666666666666667*t290*t177*
        t227*t179*t180-.8888888888888888*t298*t178*t179*t180-.8888888888888888*
        t177*t178*t291*t179-.01352896475992854*t290*t154*t161*MU*t292*
        t164*t179-.04727288888888889*t290*t159*t168+.006064083168526658*
        t290*t161*MU*t293*t166+.003382241189982134*t290*t154*t161*
        MU*t292*t166+.1054657777777778*t290*t154*t178*t164*t166-.05273288888888888*
        t294*t159*t164*t166;
    t308 = pow(t70,2.0);
    t309 = pow(t59,2.0);
    t310 = 1/pow(rhoa,4.666666666666667);
    t311 = .1608963433833122*t4*t19*t26*t310;
    t312 = 0.087761641845443*t4*t19*t53*t54*t43;
    t313 = -0.087761641845443*t4*t56*t26*t43;
    t314 = pow(t53,2.0);
    t315 = 1/pow(t25,3.0);
    t316 = .03291061569204112*t4*t19*t314*t315*t5;
    t317 = 1/pow(rhoa,11.33333333333333);
    t318 = 1/pow(rhoa,10.0);
    t319 = 1/pow(rhoa,8.666666666666666);
    t320 = 1/pow(rhoa,7.333333333333333);
    t321 = 1/pow(rhoa,6.0);
    t322 = 1/pow(rhoa,3.333333333333333);
    t323 = 4.912911979534491E-8*t20/pow(rhoa,14.0)-7.030702042032786E-7*
        t22/pow(rhoa,12.66666666666667)+2.128411436152108*t8*t322+
        .4685598137539912*t17*t321-.04673852964524872*t15*t320+.003044131669257075*
        t13*t319-1.9581719526919467E-4*t11*t318+1.6953955847531274E-5*
        t9*t317-2.007664572736969*t4*t310;
    t324 = -.01645530784602056*t4*t323*t19*t54*t5;
    t325 = -.03291061569204112*t4*t56*t53*t54*t5;
    t326 = .002573392205707033*t4*t310+.003601102626708164*
        t17*t321-.001466765918313085*t15*t320+2.7099603346032275E-4*
        t13*t319-3.1159277258223367E-5*t11*t318+2.3266094061110687E-6*
        t9*t317;
    t327 = .01645530784602056*t4*t326*t26*t5;
    t328 = .07313470153786916*t5*t39+t327+t325+t324+t316+
        t313+t312+t311;
    t329 = .1140251056471486*t52*MU*t66+.08551882923536147*
        t24*MU*t59*t64-.1282782438530422*t62*MU*t328*t64+.1924173657795633*
        t62*MU*t309*t268;
    t330 = 1/pow(t6,3.0);
    t331 = -.06934448603031025*t4*t326*t26*t5+.1386889720606205*
        t4*t56*t53*t54*t5+.06934448603031025*t4*t323*t19*t54*t5-.1386889720606205*
        t4*t19*t314*t315*t5+.3698372588283213*t4*t56*t26*t43-.3698372588283213*
        t4*t19*t53*t54*t43-.6780349745185891*t4*t19*t26*t310-0.0502248129273029*
        t4*t7*t310+5.071488289123677E-4*t15*t74*t320-1.2363392745928627E-6*
        t11*t330*t318;
    t332 = 1/pow(t68,5.0);
    t333 = 1/pow(t41,5.0);
    t334 = pow(t80,2.0);
    t335 = t327+t325+t324+t316+t313+t312+t311;
    t336 = pow(t31,3.0);
    t337 = 1/pow(t34,3.0);
    t338 = 1/pow(t35,3.0);
    t339 = 1/pow(t103,2.0);
    t340 = 1/pow(t96,3.0);
    t341 = 1/pow(t88,3.0);
    t342 = -0.25*t309*t341;
    t343 = 0.5*t328*t89;
    t344 = -0.25*t309*t64;
    t345 = 0.5*t328*t66;
    t346 = pow(t99,2.0);
    t347 = 1/pow(t94,3.0);
    t348 = .1140251056471486*t52*MU;
    t349 = t345+t344+t348;
    t350 = pow(t111,2.0);
    t351 = 1/pow(t112,3.0);
    t352 = 1/pow(t108,3.0);
    t353 = -0.25*t309*t352;
    t354 = 0.5*t109*t328;
    t355 = t354+t353+t343+t342;
    t356 = 1/pow(t105,3.0);
    t357 = 1/pow(t114,3.0);
    t358 = 1/pow(t126,2.0);
    t359 = 1/pow(t122,3.0);
    t360 = -.9121763297794749*grada*t259*t52+1.095089766947438*
        grada*t43-.2811358882523947*t262*t259*t51+.02951907135489393*
        t262*t50-.001985303262558962*t261*t259*t49+1.305447968461298E-4*
        t261*t48-1.1484937832198605E-5*t260*t259*t47+4.8210528288224824E-7*
        t260*t46-3.40124675506234E-8*t258*t259*t45;
    t361 = -0.0014036684758402*grada*t43-.002160661576024898*
        t262*t259*t51+9.263784747240539E-4*t262*t50-1.7673654356108E-4*
        t261*t259*t49+2.0772851505482245E-5*t261*t48-1.5760902428494333E-6*
        t260*t259*t47;
    t362 = .03291061569204112*grada*t56*t26*t5+.01645530784602056*
        t4*t361*t26*t5-.01645530784602056*t4*t56*t263*t54*t5-.03291061569204112*
        grada*t19*t53*t54*t5-.01645530784602056*t4*t264*t53*t54*t5-
        .01645530784602056*t4*t19*t360*t54*t5+.03291061569204112*t4*
        t19*t53*t263*t315*t5-0.087761641845443*grada*t19*t26*t43-0.0438808209227215*
        t4*t264*t26*t43+0.0438808209227215*t4*t19*t263*t54*t43;
    t363 = -.1282782438530422*t362*t62*MU*t64+.04275941461768074*
        t265*t24*MU*t64+.1924173657795633*t265*t62*MU*t59*t268;
    t364 = -.1386889720606205*grada*t56*t26*t5-.06934448603031025*
        t4*t361*t26*t5+.06934448603031025*t4*t56*t263*t54*t5+.1386889720606205*
        grada*t19*t53*t54*t5+.06934448603031025*t4*t264*t53*t54*t5+
        .06934448603031025*t4*t19*t360*t54*t5-.1386889720606205*t4*
        t19*t53*t263*t315*t5+.3698372588283213*grada*t19*t26*t43+.1849186294141607*
        t4*t264*t26*t43-.1849186294141607*t4*t19*t263*t54*t43+.02739535250580158*
        grada*t7*t43-3.380992192749118E-4*t262*t74*t50+9.272544559446472E-7*
        t261*t330*t48;
    t365 = 1/pow(t63,11.0);
    t366 = -0.25*t265*t341*t59;
    t367 = 0.5*t362*t89;
    t368 = -0.25*t265*t59*t64;
    t369 = 0.5*t362*t66;
    t370 = t369+t368;
    t371 = -0.25*t265*t352*t59;
    t372 = 0.5*t109*t362;
    t373 = t372+t371+t367+t366;
    t374 = pow(t222,2.0);
    t375 = pow(t219,2.0);
    t376 = 1/pow(rhob,4.666666666666667);
    t377 = .1608963433833122*t131*t146*t153*t376;
    t378 = 0.087761641845443*t131*t146*t213*t214*t203;
    t379 = -0.087761641845443*t131*t216*t153*t203;
    t380 = pow(t213,2.0);
    t381 = 1/pow(t152,3.0);
    t382 = .03291061569204112*t131*t146*t380*t381*t132;
    t383 = 1/
        pow(rhob,11.33333333333333);
    t384 = 1/pow(rhob,10.0);
    t385 = 1/pow(rhob,8.666666666666666);
    t386 = 1/pow(rhob,7.333333333333333);
    t387 = 1/pow(rhob,6.0);
    t388 = 1/pow(rhob,3.333333333333333);
    t389 = 4.912911979534491E-8*t147/pow(rhob,14.0)-7.030702042032786E-7*
        t149/pow(rhob,12.66666666666667)+2.128411436152108*t135*t388+
        .4685598137539912*t144*t387-.04673852964524872*t142*t386+.003044131669257075*
        t140*t385-1.9581719526919467E-4*t138*t384+1.6953955847531274E-5*
        t136*t383-2.007664572736969*t131*t376;
    t390 = -.01645530784602056*t131*t389*t146*t214*t132;
    t391 = -
        .03291061569204112*t131*t216*t213*t214*t132;
    t392 = .002573392205707033*t131*t376+.003601102626708164*
        t144*t387-.001466765918313085*t142*t386+2.7099603346032275E-4*
        t140*t385-3.1159277258223367E-5*t138*t384+2.3266094061110687E-6*
        t136*t383;
    t393 = .01645530784602056*t131*t392*t153*t132;
    t394 = .07313470153786916*t132*t39+t393+t391+t390+t382+
        t379+t378+t377;
    t395 = .1140251056471486*t212*MU*t163+.08551882923536147*
        t151*MU*t219*t220-.1282782438530422*t161*MU*t394*t220+.1924173657795633*
        t161*MU*t375*t293;
    t396 = 1/pow(t133,3.0);
    t397 = -.06934448603031025*t131*t392*t153*t132+.1386889720606205*
        t131*t216*t213*t214*t132+.06934448603031025*t131*t389*t146*
        t214*t132-.1386889720606205*t131*t146*t380*t381*t132+.3698372588283213*
        t131*t216*t153*t203-.3698372588283213*t131*t146*t213*t214*
        t203-.6780349745185891*t131*t146*t153*t376-0.0502248129273029*
        t131*t134*t376+5.071488289123677E-4*t142*t224*t386-1.2363392745928627E-6*
        t138*t396*t384;
    t398 = 1/pow(t165,5.0);
    t399 = 1/pow(t158,5.0);
    t400 = pow(t228,2.0);
    t401 = t393+t391+t390+t382+t379+t378+t377;
    t402 = pow(t171,3.0);
    t403 = 1/pow(t174,3.0);
    t404 = 1/pow(t175,3.0);
    t405 = 1/pow(t196,2.0);
    t406 = 1/pow(t194,3.0);
    t407 = 1/pow(t183,3.0);
    t408 = -0.25*t375*t407;
    t409 = 0.5*t235*t394;
    t410 = -0.25*t220*t375;
    t411 = 0.5*t163*t394;
    t412 = pow(t241,2.0);
    t413 = 1/pow(t192,3.0);
    t414 = .1140251056471486*t212*MU;
    t415 = t411+t410+t414;
    t416 = pow(t247,2.0);
    t417 = 1/pow(t188,3.0);
    t418 = 1/pow(t187,3.0);
    t419 = -0.25*t375*t418;
    t420 = 0.5*t245*t394;
    t421 = t420+t419+t409+t408;
    t422 = 1/pow(t184,3.0);
    t423 = 1/pow(t190,3.0);
    t424 = 1/pow(t200,2.0);
    t425 = 1/pow(t198,3.0);
    t426 = -.9121763297794749*gradb*t284*t212+1.095089766947438*
        gradb*t203-.2811358882523947*t287*t284*t211+.02951907135489393*
        t287*t210-.001985303262558962*t286*t284*t209+1.305447968461298E-4*
        t286*t208-1.1484937832198605E-5*t285*t284*t207+4.8210528288224824E-7*
        t285*t206-3.40124675506234E-8*t283*t284*t205;
    t427 = -0.0014036684758402*gradb*t203-.002160661576024898*
        t287*t284*t211+9.263784747240539E-4*t287*t210-1.7673654356108E-4*
        t286*t284*t209+2.0772851505482245E-5*t286*t208-1.5760902428494333E-6*
        t285*t284*t207;
    t428 = .03291061569204112*gradb*t216*t153*t132+.01645530784602056*
        t131*t427*t153*t132-.01645530784602056*t131*t216*t288*t214*
        t132-.03291061569204112*gradb*t146*t213*t214*t132-.01645530784602056*
        t131*t289*t213*t214*t132-.01645530784602056*t131*t146*t426*
        t214*t132+.03291061569204112*t131*t146*t213*t288*t381*t132-
        0.087761641845443*gradb*t146*t153*t203-0.0438808209227215*
        t131*t289*t153*t203+0.0438808209227215*t131*t146*t288*t214*
        t203;
    t429 = -.1282782438530422*t428*t161*MU*t220+.04275941461768074*
        t290*t151*MU*t220+.1924173657795633*t290*t161*MU*t219*t293;
    t430 = -
        .1386889720606205*gradb*t216*t153*t132-.06934448603031025*
        t131*t427*t153*t132+.06934448603031025*t131*t216*t288*t214*
        t132+.1386889720606205*gradb*t146*t213*t214*t132+.06934448603031025*
        t131*t289*t213*t214*t132+.06934448603031025*t131*t146*t426*
        t214*t132-.1386889720606205*t131*t146*t213*t288*t381*t132+
        .3698372588283213*gradb*t146*t153*t203+.1849186294141607*t131*
        t289*t153*t203-.1849186294141607*t131*t146*t288*t214*t203+
        .02739535250580158*gradb*t134*t203-3.380992192749118E-4*t287*
        t224*t210+9.272544559446472E-7*t286*t396*t208;
    t431 = 1/pow(t162,11.0);
    t432 = -0.25*t219*t290*t407;
    t433 = 0.5*t235*t428;
    t434 = -0.25*t219*t220*t290;
    t435 = 0.5*t163*t428;
    t436 = t435+t434;
    t437 = -0.25*t219*t290*t418;
    t438 = 0.5*t245*t428;
    t439 = t438+t437+t433+t432;
    t440 = pow(t265,2.0);
    t441 = pow(t263,2.0);
    t442 = -.4106586626052891*t5+.1405679441261974*t4*t259*
        t18-.01660447763712784*t4*t16+.001191181957535377*t15*t259*
        t14-8.159049802883112E-5*t15*t12+7.383174320699103E-6*t11*
        t259*t10-3.1638159189147547E-7*t11*t23+2.2674978367082266E-8*
        t22*t259*t21;
    t443 = 5.263756784400749E-4*t5+.001080330788012449*t4*
        t259*t18-5.210878920322803E-4*t4*t16+1.06041926136648E-4*t15*
        t259*t14-1.2983032190926405E-5*t15*t12+1.0132008704032072E-6*
        t11*t259*t10;
    t444 = .03291061569204112*t19*t26*t5+.06582123138408225*
        grada*t264*t26*t5+.01645530784602056*t4*t443*t26*t5-.06582123138408225*
        grada*t19*t263*t54*t5-.03291061569204112*t4*t264*t263*t54*
        t5-.01645530784602056*t4*t442*t19*t54*t5+.03291061569204112*
        t4*t19*t441*t315*t5;
    t445 = -.1386889720606205*t19*t26*t5-0.277377944121241*
        grada*t264*t26*t5-.06934448603031025*t4*t443*t26*t5+0.277377944121241*
        grada*t19*t263*t54*t5+.1386889720606205*t4*t264*t263*t54*t5+
        .06934448603031025*t4*t442*t19*t54*t5-.1386889720606205*t4*
        t19*t441*t315*t5-.01027325718967559*t7*t5+2.113120120468199E-4*
        t4*t74*t16-6.954408419584854E-7*t15*t330*t12;
    t446 = -0.25*t341*t440;
    t447 = 0.5*t444*t89;
    t448 = -0.25*t440*t64;
    t449 = 0.5*t444*t66;
    t450 = pow(t279,2.0);
    t451 = -0.25*t352*t440;
    t452 = 0.5*t109*t444;
    t453 = t452+t451+t447+t446;
    t454 = pow(t290,2.0);
    t455 = pow(t288,2.0);
    t456 = -.4106586626052891*t132+.1405679441261974*t131*
        t284*t145-.01660447763712784*t131*t143+.001191181957535377*
        t142*t284*t141-8.159049802883112E-5*t142*t139+7.383174320699103E-6*
        t138*t284*t137-3.1638159189147547E-7*t138*t150+2.2674978367082266E-8*
        t149*t284*t148;
    t457 = 5.263756784400749E-4*t132+.001080330788012449*
        t131*t284*t145-5.210878920322803E-4*t131*t143+1.06041926136648E-4*
        t142*t284*t141-1.2983032190926405E-5*t142*t139+1.0132008704032072E-6*
        t138*t284*t137;
    t458 = .03291061569204112*t146*t153*t132+.06582123138408225*
        gradb*t289*t153*t132+.01645530784602056*t131*t457*t153*t132-
        .06582123138408225*gradb*t146*t288*t214*t132-.03291061569204112*
        t131*t289*t288*t214*t132-.01645530784602056*t131*t456*t146*
        t214*t132+.03291061569204112*t131*t146*t455*t381*t132;
    t459 = -.1386889720606205*t146*t153*t132-0.277377944121241*
        gradb*t289*t153*t132-.06934448603031025*t131*t457*t153*t132+
        0.277377944121241*gradb*t146*t288*t214*t132+.1386889720606205*
        t131*t289*t288*t214*t132+.06934448603031025*t131*t456*t146*
        t214*t132-.1386889720606205*t131*t146*t455*t381*t132-.01027325718967559*
        t134*t132+2.113120120468199E-4*t131*t224*t143-6.954408419584854E-7*
        t142*t396*t139;
    t460 = -0.25*t407*t454;
    t461 = 0.5*t235*t458;
    t462 = -0.25*t220*t454;
    t463 = 0.5*t163*t458;
    t464 = pow(t304,2.0);
    t465 = -0.25*t418*t454;
    t466 = 0.5*t245*t458;
    t467 = t466+t465+t461+t460;

   /* code */
    dfdra = -0.6203504908994*t61*t202-0.46526286817455*t3*
        t130;
    dfdrb = -0.6203504908994*t160*t202-0.46526286817455*t3*
        t257;
    dfdga = -0.46526286817455*t3*t282;
    dfdgb = -0.46526286817455*t3*t307;
    dfdgab = 0.0;
    d2fdrara = -0.46526286817455*t3*(.03291061569204112*t104*
        t19*t26*t4*t5*(0.60965*(t345+t344+t343+t342)*t95*t97-1.2193*
        t99*t92*t100*t97-1.2193*t340*pow(t92,2.0)*t95-1.2193*t346*
        t347*t101+0.60965*t349*t100*t101)-2.0*t127*t33*(.2951219999999999*
        pow(t121,2.0)*t359*t95+.2951219999999999*t346*t347*t124-.1475609999999999*
        t349*t100*t124-.1475609999999999*t95*(t354+t353+t345+t344)*
        t123+.2951219999999999*t99*t100*t121*t123)-.8888888888888888*
        t42*t69*t78*(-16.8*t80*t81*t85-2.4*t32*(-.03206956096326055*
        t24*t338*t8*pow(t84,2.0)+0.0641391219265211*t24*(-2.0*t53*
        t54*t56-1.0*t19*t323*t54+2.0*t19*t314*t315+t326*t26)*t8*t83-
        0.5*t335*t82-.1710376584707229*t8*t83*t84*t52+0.25*t334*t337+
        .3990878697650202*t8*t35*t322)-4.962870782535445*t335*t81-
        .09491920000000001*t75*t80-8.4*t335*t81*t36-21.0*t334*t336*
        t36-12.40717695633861*t334*t336+.05672746666666666*t334-2.7259596*
        t335*t30+.05672746666666666*t335*t29-5.4519192*t334*t29-0.0474596*
        t331*t29-0.0474596*t335*t27)+0.757211*(-2.0*t118*t119*t120*
        t80-2.0*t111*t113*t115*t80+.03291061569204112*pow(t116,2.0)*
        t118*t19*t26*t356*t4*t5+2.0*t118*pow(t119,2.0)*t33*t357-1.0*
        t113*t115*t33*t355-1.0*t118*t120*t33*(t354+t353+t348)+2.0*
        t115*t33*t350*t351+.03291061569204112*t4*t19*t26*t5*t106*t350*
        t351+2.0*t111*t113*t119*t120*t33-.01645530784602056*t4*t19*
        t26*t5*(t343+t342+t348)*t117*t118+.03291061569204112*t4*t19*
        t53*t54*t5*t116*t117*t118-.03291061569204112*t4*t56*t26*t5*
        t116*t117*t118+0.087761641845443*t4*t19*t26*t43*t116*t117*
        t118+t335*t115*t118-.03291061569204112*t4*t56*t53*t54*t5*t106*
        t118-.01645530784602056*t4*t323*t19*t54*t5*t106*t118+.03291061569204112*
        t4*t19*t314*t315*t5*t106*t118+.01645530784602056*t4*t326*t26*
        t5*t106*t118+0.087761641845443*t4*t19*t53*t54*t43*t106*t118-
        0.087761641845443*t4*t56*t26*t43*t106*t118+.1608963433833122*
        t4*t19*t26*t310*t106*t118-.01645530784602056*t4*t19*t26*t5*
        t106*t355*t113+.03291061569204112*t4*t19*t26*t5*t116*t117*
        t111*t113+.03291061569204112*t4*t19*t53*t54*t5*t106*t111*t113-
        .03291061569204112*t4*t56*t26*t5*t106*t111*t113+0.087761641845443*
        t4*t19*t26*t43*t106*t111*t113)-16.0*t37*t59*t79*t70*t77*t78+
        5.333333333333333*t86*t42*t70*t77*t78+2.666666666666667*t37*
        t42*t329*t77*t78+5.333333333333333*t86*t59*t79*t69*t78+2.666666666666667*
        t37*t328*t79*t69*t78-10.66666666666667*t37*t309*t333*t69*t78-
        10.66666666666667*t37*t42*t308*t332*t78-.3163973333333333*
        t27*t60*t308*t71*t77+5.333333333333333*t37*t42*t67*t70*t77-
        .04727288888888889*t328*t60*t76+.09454577777777777*t309*t42*
        t76-.1054657777777778*t75*t60*t73*t72+.2109315555555555*t27*
        t59*t42*t73*t72-.3163973333333333*t27*t309*t79*t71*t72-.05273288888888888*
        t331*t60*t71*t72+.2109315555555555*t75*t59*t42*t71*t72+.1054657777777778*
        t27*t328*t42*t71*t72+.09454577777777777*t59*t60*t70*t72-.05273288888888888*
        t27*t60*(.05701255282357431*t52*MU*t66+.04275941461768074*
        t24*MU*t59*t64-0.0641391219265211*t62*MU*t328*t64+.09620868288978165*
        t62*MU*t309*t268)*t72-.04727288888888889*t65*t329*t72+.2109315555555555*
        t27*t60*t70*t73*t69+.2109315555555555*t75*t60*t70*t71*t69-
        .4218631111111111*t27*t59*t42*t70*t71*t69+.1054657777777778*
        t27*t60*t329*t71*t69+5.333333333333333*t37*t59*t79*t67*t69-
        1.777777777777778*t86*t42*t67*t69-.8888888888888888*t37*t42*
        (.1282782438530422*t52*MU*t66+.02742551307670094*t5*t39*t65+
        .09620868288978165*t24*MU*t59*t64-.1443130243346725*t62*MU*
        t328*t64+.03291061569204112*t58*t39*t59*t60-.02468296176903084*
        t38*t39*t328*t60+.2164695365020088*t62*MU*t309*t268+.04936592353806168*
        t38*t39*t309*t42)*t69+.09454577777777777*t65*t308*t69-.03291061569204112*
        pow(t102,2.0)*t19*t26*t339*t4*t5+2.0*pow(t125,2.0)*t33*t358-
        2.0*t335*t129-.06582123138408225*t4*t56*t53*t54*t5*t128-.03291061569204112*
        t4*t323*t19*t54*t5*t128+.06582123138408225*t4*t19*t314*t315*
        t5*t128+.03291061569204112*t4*t326*t26*t5*t128+0.175523283690886*
        t4*t19*t53*t54*t43*t128-0.175523283690886*t4*t56*t26*t43*t128+
        .3217926867666243*t4*t19*t26*t310*t128-4.0*t80*t125*t127-.06582123138408225*
        t4*t19*t53*t54*t5*t102*t104+.06582123138408225*t4*t56*t26*
        t5*t102*t104-0.175523283690886*t4*t19*t26*t43*t102*t104)-.2067834969664666*
        t38*t202-1.2407009817988*t61*t130;
    d2fdrarb = -0.6203504908994*t61*t257-0.6203504908994*
        t160*t130;
    d2fdraga = -0.46526286817455*t3*(-.8888888888888888*t42*
        t69*t78*(-8.4*t265*t81*t85-2.4*t32*(0.0641391219265211*t24*
        (-1.0*t263*t54*t56-1.0*t264*t53*t54-1.0*t19*t360*t54+2.0*t19*
        t263*t315*t53+t361*t26)*t8*t83-0.5*t362*t82+0.25*t265*t337*
        t80-.1710376584707229*grada*t259*t35*t52-.08551882923536147*
        t8*t83*t271*t52+0.0641391219265211*grada*t259*t83*t84*t24-
        .03206956096326055*t8*t338*t84*t271*t24)-4.962870782535445*
        t362*t81-8.4*t362*t81*t36-21.0*t80*t265*t336*t36-12.40717695633861*
        t80*t265*t336-2.7259596*t362*t30-0.0474596*t364*t29+.05672746666666666*
        t362*t29-5.4519192*t80*t265*t29-8.4*t80*t81*t272-0.0474596*
        t362*t27-0.0474596*t80*t269+.05672746666666666*t80*t265-0.0474596*
        t75*t265)+0.757211*(-1.0*t113*t115*t279*t80-0.5*t109*t118*
        t120*t265*t80-1.0*t113*t115*t33*t373-1.0*t118*t120*t33*(t372+
        t371)+2.0*t111*t115*t279*t33*t351+.03291061569204112*t4*t19*
        t26*t5*t106*t279*t111*t351+0.5*t109*t111*t113*t120*t265*t33-
        1.0*t118*t119*t120*t265-1.0*t111*t113*t115*t265+t265*t33*t109*
        t119*t357*t118+.01645530784602056*t4*t19*t265*t26*t5*t89*t116*
        t356*t118+0.00822765392301028*t4*t19*t265*t53*t54*t5*t89*t117*
        t118-0.00822765392301028*t4*t56*t265*t26*t5*t89*t117*t118+
        .02194041046136075*t4*t19*t265*t26*t43*t89*t117*t118-.01645530784602056*
        t4*t19*t26*t5*(t367+t366)*t117*t118+.01645530784602056*t4*
        t19*t263*t54*t5*t116*t117*t118-.01645530784602056*t4*t264*
        t26*t5*t116*t117*t118-.03291061569204112*grada*t19*t26*t5*
        t116*t117*t118+t362*t115*t118-.01645530784602056*t4*t264*t53*
        t54*t5*t106*t118-.03291061569204112*grada*t19*t53*t54*t5*t106*
        t118-.01645530784602056*t4*t19*t360*t54*t5*t106*t118-.01645530784602056*
        t4*t56*t263*t54*t5*t106*t118+.03291061569204112*t4*t19*t53*
        t263*t315*t5*t106*t118+.03291061569204112*grada*t56*t26*t5*
        t106*t118+.01645530784602056*t4*t361*t26*t5*t106*t118+0.0438808209227215*
        t4*t19*t263*t54*t43*t106*t118-0.0438808209227215*t4*t264*t26*
        t43*t106*t118-0.087761641845443*grada*t19*t26*t43*t106*t118-
        .01645530784602056*t4*t19*t26*t5*t106*t373*t113+.01645530784602056*
        t4*t19*t26*t5*t116*t117*t279*t113+.01645530784602056*t4*t19*
        t53*t54*t5*t106*t279*t113-.01645530784602056*t4*t56*t26*t5*
        t106*t279*t113+0.0438808209227215*t4*t19*t26*t43*t106*t279*
        t113+t33*t279*t119*t120*t113+0.00822765392301028*t4*t19*t265*
        t26*t5*t89*t117*t111*t113+.01645530784602056*t4*t19*t263*t54*
        t5*t106*t111*t113-.01645530784602056*t4*t264*t26*t5*t106*t111*
        t113-.03291061569204112*grada*t19*t26*t5*t106*t111*t113)-8.0*
        t265*t37*t79*t70*t77*t78+2.666666666666667*t273*t42*t70*t77*
        t78+1.026225950824338*t265*t37*t62*MU*t59*t365*t77*t78+2.666666666666667*
        t37*t42*t363*t77*t78-.3420753169414459*t265*t86*t62*MU*t270*
        t77*t78+2.666666666666667*t265*t86*t79*t69*t78+2.666666666666667*
        t273*t59*t79*t69*t78+2.666666666666667*t362*t37*t79*t69*t78-
        10.66666666666667*t265*t37*t59*t333*t69*t78+1.368301267765784*
        t265*t37*t62*MU*t270*t70*t332*t78+.04058689427978561*t265*
        t27*t62*MU*t267*t70*t71*t77+2.666666666666667*t37*t42*t266*
        t70*t77-.3420753169414459*t265*t37*t62*MU*t270*t67*t77-.04727288888888889*
        t362*t60*t76+.09454577777777777*t265*t59*t42*t76-.05273288888888888*
        t269*t60*t73*t72+.1054657777777778*t265*t27*t42*t73*t72-.3163973333333333*
        t265*t27*t59*t79*t71*t72-.05273288888888888*t364*t60*t71*t72+
        .1054657777777778*t269*t59*t42*t71*t72+.1054657777777778*t362*
        t27*t42*t71*t72+.1054657777777778*t75*t265*t42*t71*t72+.04727288888888889*
        t265*t60*t70*t72-.05273288888888888*t27*t60*(-0.0641391219265211*
        t362*t62*MU*t64+.02137970730884037*t265*t24*MU*t64+.09620868288978165*
        t265*t62*MU*t59*t268)*t72-.04727288888888889*t65*t363*t72-
        .006764482379964268*t265*t27*t62*MU*t59*t270*t72+.003382241189982134*
        t75*t265*t62*MU*t267*t72-.006064083168526658*t265*t62*MU*t59*
        t267*t72-.01352896475992854*t265*t27*t62*MU*t267*t73*t69+.1054657777777778*
        t269*t60*t70*t71*t69-.2109315555555555*t265*t27*t42*t70*t71*
        t69+.1054657777777778*t27*t60*t363*t71*t69+.02705792951985707*
        t265*t27*t62*MU*t59*t270*t71*t69-.01352896475992854*t75*t265*
        t62*MU*t267*t71*t69-.01212816633705332*t265*t62*MU*t268*t70*
        t69-.006764482379964268*t265*t27*t62*MU*t267*t70*t69+2.666666666666667*
        t265*t37*t79*t67*t69-.8888888888888888*t273*t42*t67*t69-.8888888888888888*
        t37*t42*(-.1443130243346725*t362*t62*MU*t64+.04810434144489083*
        t265*t24*MU*t64-.02468296176903084*t362*t38*t39*t60+.01645530784602056*
        t265*t58*t39*t60+.2164695365020088*t265*t62*MU*t59*t268+.04936592353806168*
        t265*t38*t39*t59*t42)*t69+2.666666666666667*t37*t59*t79*t266*
        t69-.8888888888888888*t86*t42*t266*t69+2.0*t33*t281*t125*t358-
        .03291061569204112*t4*t19*t26*t5*t277*t102*t339-2.0*t362*t129-
        .03291061569204112*t4*t264*t53*t54*t5*t128-.06582123138408225*
        grada*t19*t53*t54*t5*t128-.03291061569204112*t4*t19*t360*t54*
        t5*t128-.03291061569204112*t4*t56*t263*t54*t5*t128+.06582123138408225*
        t4*t19*t53*t263*t315*t5*t128+.06582123138408225*grada*t56*
        t26*t5*t128+.03291061569204112*t4*t361*t26*t5*t128+0.087761641845443*
        t4*t19*t263*t54*t43*t128-0.087761641845443*t4*t264*t26*t43*
        t128-0.175523283690886*grada*t19*t26*t43*t128-2.0*t80*t281*
        t127-2.0*t265*t125*t127-2.0*t33*(-.1475609999999999*t370*t100*
        t124+.1475609999999999*t265*t66*t99*t347*t124+.07378049999999997*
        t265*t66*t100*t121*t123+.1475609999999999*t99*t100*t280*t123-
        .1475609999999999*t95*(t372+t371+t369+t368)*t123+.2951219999999999*
        t95*t280*t121*t359)*t127-.03291061569204112*t4*t19*t53*t54*
        t5*t277*t104+.03291061569204112*t4*t56*t26*t5*t277*t104-0.087761641845443*
        t4*t19*t26*t43*t277*t104-.03291061569204112*t4*t19*t263*t54*
        t5*t102*t104+.03291061569204112*t4*t264*t26*t5*t102*t104+.06582123138408225*
        grada*t19*t26*t5*t102*t104+.03291061569204112*t4*t19*t26*t5*
        (0.60965*t370*t100*t101-0.60965*t265*t66*t99*t347*t101+0.60965*
        (t369+t368+t367+t366)*t95*t97-0.304825*t265*t66*t92*t100*t97-
        0.60965*t276*t99*t100*t97-1.2193*t276*t92*t95*t340)*t104)-
        0.6203504908994*t61*t282;
    d2fdragb = -0.6203504908994*t61*t307;
    d2fdraab = 0.0;
    d2fdrbrb = -0.46526286817455*t3*(-2.0*t173*t256*(.2951219999999999*
        t193*pow(t253,2.0)*t425-.1475609999999999*t193*(t420+t419+
        t411+t410)*t254+.2951219999999999*t241*t242*t253*t254+.2951219999999999*
        t412*t413*t199-.1475609999999999*t415*t242*t199)+2.0*t173*
        pow(t255,2.0)*t424+0.757211*(2.0*t173*t189*pow(t251,2.0)*t423+
        .03291061569204112*t131*t132*t146*t153*t189*pow(t249,2.0)*
        t422-1.0*t173*t191*t248*t421-1.0*t173*t189*t252*(t420+t419+
        t414)+2.0*t173*t191*t416*t417+.03291061569204112*t131*t146*
        t153*t132*t185*t416*t417+2.0*t173*t247*t248*t251*t252-2.0*
        t189*t228*t251*t252-.01645530784602056*t131*t146*t153*t132*
        t185*t421*t248+.03291061569204112*t131*t146*t153*t132*t249*
        t250*t247*t248-2.0*t191*t228*t247*t248+0.087761641845443*t131*
        t146*t153*t203*t185*t247*t248+.03291061569204112*t131*t146*
        t213*t214*t132*t185*t247*t248-.03291061569204112*t131*t216*
        t153*t132*t185*t247*t248-.01645530784602056*t131*t146*t153*
        t132*(t409+t408+t414)*t250*t189+0.087761641845443*t131*t146*
        t153*t203*t249*t250*t189+.03291061569204112*t131*t146*t213*
        t214*t132*t249*t250*t189-.03291061569204112*t131*t216*t153*
        t132*t249*t250*t189+t401*t191*t189+.1608963433833122*t131*
        t146*t153*t376*t185*t189+0.087761641845443*t131*t146*t213*
        t214*t203*t185*t189-0.087761641845443*t131*t216*t153*t203*
        t185*t189+.03291061569204112*t131*t146*t380*t381*t132*t185*
        t189-.03291061569204112*t131*t216*t213*t214*t132*t185*t189-
        .01645530784602056*t131*t389*t146*t214*t132*t185*t189+.01645530784602056*
        t131*t392*t153*t132*t185*t189)+.03291061569204112*t131*t132*
        t146*t153*t244*(-1.2193*t193*pow(t238,2.0)*t406-1.2193*t241*
        t238*t242*t239+0.60965*(t411+t410+t409+t408)*t193*t239-1.2193*
        t412*t413*t195+0.60965*t415*t242*t195)-.03291061569204112*
        t131*t132*t146*t153*pow(t243,2.0)*t405-.8888888888888888*t178*
        t179*t180*(-2.4*t172*(-.03206956096326055*t135*t151*pow(t232,
        2.0)*t404+0.25*t400*t403-0.5*t230*t401+0.0641391219265211*
        t135*t151*t231*(-1.0*t146*t214*t389+2.0*t146*t380*t381-2.0*
        t213*t214*t216+t392*t153)+.3990878697650202*t135*t175*t388-
        .1710376584707229*t135*t231*t232*t212)-12.40717695633861*t400*
        t402+.05672746666666666*t400-16.8*t228*t229*t233-4.962870782535445*
        t401*t229-.09491920000000001*t225*t228-21.0*t400*t402*t176-
        8.4*t401*t229*t176-2.7259596*t401*t170+.05672746666666666*
        t401*t169-5.4519192*t400*t169-0.0474596*t397*t169-0.0474596*
        t401*t154)-4.0*t228*t255*t256-0.175523283690886*t131*t146*
        t153*t203*t243*t244-.06582123138408225*t131*t146*t213*t214*
        t132*t243*t244+.06582123138408225*t131*t216*t153*t132*t243*
        t244+5.333333333333333*t177*t178*t221*t222*t226-.3163973333333333*
        t154*t159*t374*t164*t226-2.0*t401*t201+.3217926867666243*t131*
        t146*t153*t376*t197+0.175523283690886*t131*t146*t213*t214*
        t203*t197-0.175523283690886*t131*t216*t153*t203*t197+.06582123138408225*
        t131*t146*t380*t381*t132*t197-.06582123138408225*t131*t216*
        t213*t214*t132*t197-.03291061569204112*t131*t389*t146*t214*
        t132*t197+.03291061569204112*t131*t392*t153*t132*t197-10.66666666666667*
        t177*t178*t374*t398*t180+2.666666666666667*t177*t178*t395*
        t226*t180-16.0*t177*t219*t227*t222*t226*t180+5.333333333333333*
        t234*t178*t222*t226*t180-10.66666666666667*t177*t375*t399*
        t179*t180+2.666666666666667*t177*t394*t227*t179*t180+5.333333333333333*
        t234*t219*t227*t179*t180+.09454577777777777*t167*t374*t179+
        .2109315555555555*t154*t159*t222*t223*t179+5.333333333333333*
        t177*t219*t227*t221*t179-1.777777777777778*t234*t178*t221*
        t179+.1054657777777778*t154*t159*t395*t164*t179-.4218631111111111*
        t154*t219*t178*t222*t164*t179+.2109315555555555*t225*t159*
        t222*t164*t179-.8888888888888888*t177*t178*(.1282782438530422*
        t212*MU*t163+.02742551307670094*t132*t39*t167+.09620868288978165*
        t151*MU*t219*t220-.1443130243346725*t161*MU*t394*t220+.03291061569204112*
        t218*t39*t219*t159-.02468296176903084*t156*t39*t394*t159+.2164695365020088*
        t161*MU*t375*t293+.04936592353806168*t156*t39*t375*t178)*t179+
        .09454577777777777*t375*t178*t168-.04727288888888889*t394*
        t159*t168-.04727288888888889*t167*t395*t166+.2109315555555555*
        t154*t219*t178*t223*t166-.1054657777777778*t225*t159*t223*
        t166+.09454577777777777*t219*t159*t222*t166-.3163973333333333*
        t154*t375*t227*t164*t166+.1054657777777778*t154*t394*t178*
        t164*t166+.2109315555555555*t225*t219*t178*t164*t166-.05273288888888888*
        t397*t159*t164*t166-.05273288888888888*t154*t159*(.05701255282357431*
        t212*MU*t163+.04275941461768074*t151*MU*t219*t220-0.0641391219265211*
        t161*MU*t394*t220+.09620868288978165*t161*MU*t375*t293)*t166)-
        1.2407009817988*t160*t257-.2067834969664666*t156*t202;
    d2fdrbga = -0.6203504908994*t160*t282;
    d2fdrbgb = -0.46526286817455*t3*(0.757211*(-1.0*t173*
        t191*t248*t439-1.0*t173*t189*t252*(t438+t437)+2.0*t173*t191*
        t247*t304*t417+.03291061569204112*t131*t146*t153*t132*t185*
        t304*t247*t417-1.0*t191*t228*t248*t304-1.0*t189*t251*t252*
        t290+0.5*t173*t245*t247*t248*t252*t290-0.5*t189*t228*t245*
        t252*t290-1.0*t191*t247*t248*t290-.01645530784602056*t131*
        t146*t153*t132*t185*t439*t248+.01645530784602056*t131*t146*
        t153*t132*t249*t250*t304*t248+0.0438808209227215*t131*t146*
        t153*t203*t185*t304*t248+.01645530784602056*t131*t146*t213*
        t214*t132*t185*t304*t248-.01645530784602056*t131*t216*t153*
        t132*t185*t304*t248+t173*t304*t251*t252*t248+0.00822765392301028*
        t131*t146*t290*t153*t132*t235*t250*t247*t248+.01645530784602056*
        t131*t146*t288*t214*t132*t185*t247*t248-.01645530784602056*
        t131*t289*t153*t132*t185*t247*t248-.03291061569204112*gradb*
        t146*t153*t132*t185*t247*t248+t290*t173*t245*t251*t423*t189+
        .01645530784602056*t131*t146*t290*t153*t132*t235*t249*t422*
        t189-.01645530784602056*t131*t146*t153*t132*(t433+t432)*t250*
        t189+.01645530784602056*t131*t146*t288*t214*t132*t249*t250*
        t189-.01645530784602056*t131*t289*t153*t132*t249*t250*t189-
        .03291061569204112*gradb*t146*t153*t132*t249*t250*t189+.02194041046136075*
        t131*t146*t290*t153*t203*t235*t250*t189+0.00822765392301028*
        t131*t146*t290*t213*t214*t132*t235*t250*t189-0.00822765392301028*
        t131*t216*t290*t153*t132*t235*t250*t189+t428*t191*t189+0.0438808209227215*
        t131*t146*t288*t214*t203*t185*t189-0.0438808209227215*t131*
        t289*t153*t203*t185*t189-0.087761641845443*gradb*t146*t153*
        t203*t185*t189+.03291061569204112*t131*t146*t213*t288*t381*
        t132*t185*t189-.01645530784602056*t131*t146*t426*t214*t132*
        t185*t189-.01645530784602056*t131*t216*t288*t214*t132*t185*
        t189-.01645530784602056*t131*t289*t213*t214*t132*t185*t189-
        .03291061569204112*gradb*t146*t213*t214*t132*t185*t189+.01645530784602056*
        t131*t427*t153*t132*t185*t189+.03291061569204112*gradb*t216*
        t153*t132*t185*t189)-.8888888888888888*t178*t179*t180*(-2.4*
        t172*(-0.5*t230*t428+0.0641391219265211*t135*t151*t231*(-1.0*
        t146*t214*t426+2.0*t146*t213*t288*t381-1.0*t213*t214*t289-
        1.0*t214*t216*t288+t427*t153)+0.25*t228*t290*t403-.08551882923536147*
        t135*t231*t296*t212-.1710376584707229*gradb*t284*t175*t212-
        .03206956096326055*t135*t404*t232*t296*t151+0.0641391219265211*
        gradb*t284*t231*t232*t151)-12.40717695633861*t228*t290*t402-
        8.4*t228*t229*t297-0.0474596*t228*t294+.05672746666666666*
        t228*t290-0.0474596*t225*t290-8.4*t290*t229*t233-4.962870782535445*
        t428*t229-21.0*t228*t290*t402*t176-8.4*t428*t229*t176-2.7259596*
        t428*t170-0.0474596*t430*t169+.05672746666666666*t428*t169-
        5.4519192*t228*t290*t169-0.0474596*t428*t154)+2.0*t173*t306*
        t255*t424-.03291061569204112*t131*t146*t153*t132*t302*t243*
        t405-2.0*t228*t306*t256-2.0*t290*t255*t256-2.0*t173*(-.1475609999999999*
        t436*t242*t199+.1475609999999999*t290*t163*t241*t413*t199+
        .07378049999999997*t290*t163*t242*t253*t254+.1475609999999999*
        t241*t242*t305*t254-.1475609999999999*t193*(t438+t437+t435+
        t434)*t254+.2951219999999999*t193*t305*t253*t425)*t256-0.087761641845443*
        t131*t146*t153*t203*t302*t244-.03291061569204112*t131*t146*
        t213*t214*t132*t302*t244+.03291061569204112*t131*t216*t153*
        t132*t302*t244-.03291061569204112*t131*t146*t288*t214*t132*
        t243*t244+.03291061569204112*t131*t289*t153*t132*t243*t244+
        .06582123138408225*gradb*t146*t153*t132*t243*t244+.03291061569204112*
        t131*t146*t153*t132*(0.60965*t436*t242*t195-0.60965*t290*t163*
        t241*t413*t195+0.60965*(t435+t434+t433+t432)*t193*t239-0.304825*
        t290*t163*t238*t242*t239-0.60965*t301*t241*t242*t239-1.2193*
        t301*t238*t193*t406)*t244+2.666666666666667*t177*t178*t291*
        t222*t226-.3420753169414459*t290*t177*t161*MU*t295*t221*t226+
        .04058689427978561*t290*t154*t161*MU*t292*t222*t164*t226-2.0*
        t428*t201+0.087761641845443*t131*t146*t288*t214*t203*t197-
        0.087761641845443*t131*t289*t153*t203*t197-0.175523283690886*
        gradb*t146*t153*t203*t197+.06582123138408225*t131*t146*t213*
        t288*t381*t132*t197-.03291061569204112*t131*t146*t426*t214*
        t132*t197-.03291061569204112*t131*t216*t288*t214*t132*t197-
        .03291061569204112*t131*t289*t213*t214*t132*t197-.06582123138408225*
        gradb*t146*t213*t214*t132*t197+.03291061569204112*t131*t427*
        t153*t132*t197+.06582123138408225*gradb*t216*t153*t132*t197+
        1.368301267765784*t290*t177*t161*MU*t295*t222*t398*t180+1.026225950824338*
        t290*t177*t161*MU*t219*t431*t226*t180+2.666666666666667*t177*
        t178*t429*t226*t180-.3420753169414459*t290*t234*t161*MU*t295*
        t226*t180-8.0*t290*t177*t227*t222*t226*t180+2.666666666666667*
        t298*t178*t222*t226*t180-10.66666666666667*t290*t177*t219*
        t399*t179*t180+2.666666666666667*t290*t234*t227*t179*t180+
        2.666666666666667*t298*t219*t227*t179*t180+2.666666666666667*
        t428*t177*t227*t179*t180+2.666666666666667*t177*t219*t227*
        t291*t179-.8888888888888888*t234*t178*t291*t179-.01352896475992854*
        t290*t154*t161*MU*t292*t223*t179-.01212816633705332*t290*t161*
        MU*t293*t222*t179-.006764482379964268*t290*t154*t161*MU*t292*
        t222*t179+2.666666666666667*t290*t177*t227*t221*t179-.8888888888888888*
        t298*t178*t221*t179-.8888888888888888*t177*t178*(-.1443130243346725*
        t428*t161*MU*t220+.04810434144489083*t290*t151*MU*t220-.02468296176903084*
        t428*t156*t39*t159+.01645530784602056*t290*t218*t39*t159+.2164695365020088*
        t290*t161*MU*t219*t293+.04936592353806168*t290*t156*t39*t219*
        t178)*t179+.1054657777777778*t154*t159*t429*t164*t179+.02705792951985707*
        t290*t154*t161*MU*t219*t295*t164*t179-.01352896475992854*t225*
        t290*t161*MU*t292*t164*t179-.2109315555555555*t290*t154*t178*
        t222*t164*t179+.1054657777777778*t294*t159*t222*t164*t179+
        .09454577777777777*t290*t219*t178*t168-.04727288888888889*
        t428*t159*t168-.04727288888888889*t167*t429*t166-.006764482379964268*
        t290*t154*t161*MU*t219*t295*t166+.003382241189982134*t225*
        t290*t161*MU*t292*t166-.006064083168526658*t290*t161*MU*t219*
        t292*t166+.1054657777777778*t290*t154*t178*t223*t166-.05273288888888888*
        t294*t159*t223*t166+.04727288888888889*t290*t159*t222*t166-
        .05273288888888888*t154*t159*(-0.0641391219265211*t428*t161*
        MU*t220+.02137970730884037*t290*t151*MU*t220+.09620868288978165*
        t290*t161*MU*t219*t293)*t166-.3163973333333333*t290*t154*t219*
        t227*t164*t166+.1054657777777778*t225*t290*t178*t164*t166+
        .1054657777777778*t294*t219*t178*t164*t166+.1054657777777778*
        t428*t154*t178*t164*t166-.05273288888888888*t430*t159*t164*
        t166)-0.6203504908994*t160*t307;
    d2fdrbgab = 0.0;
    d2fdgaga = -0.46526286817455*t3*(.03291061569204112*t104*
        t19*t26*t4*t5*(0.60965*(t449+t448+t447+t446)*t95*t97-0.60965*
        t265*t66*t276*t100*t97-1.2193*pow(t276,2.0)*t340*t95-0.304825*
        t440*t65*t347*t101+0.304825*t444*t66*t100*t101-0.1524125*t440*
        t64*t100*t101)-2.0*t127*t33*(.2951219999999999*pow(t280,2.0)*
        t359*t95+.07378049999999997*t440*t65*t347*t124-.07378049999999997*
        t444*t66*t100*t124+.03689024999999999*t440*t64*t100*t124-.1475609999999999*
        t95*(t452+t451+t449+t448)*t123+.1475609999999999*t265*t66*
        t100*t280*t123)+0.757211*(0.00822765392301028*t118*t19*t26*
        t356*t4*t440*t5/t87-1.0*t113*t115*t33*t453+2.0*t115*t33*t351*
        t450-0.5*t109*t118*t120*t33*t444+0.5*t118*t33*t357*t440/t107+
        0.25*t118*t120*t33*t352*t440-1.0*t109*t118*t120*t440+.03291061569204112*
        t4*t19*t26*t5*t106*t450*t351-2.0*t113*t115*t265*t279+.01645530784602056*
        t4*t19*t265*t263*t54*t5*t89*t117*t118-0.00822765392301028*
        t4*t19*t444*t26*t5*t89*t117*t118-.01645530784602056*t4*t264*
        t265*t26*t5*t89*t117*t118-.03291061569204112*grada*t19*t265*
        t26*t5*t89*t117*t118+0.00411382696150514*t4*t19*t440*t26*t5*
        t341*t117*t118+t444*t115*t118-.03291061569204112*t4*t264*t263*
        t54*t5*t106*t118-.06582123138408225*grada*t19*t263*t54*t5*
        t106*t118-.01645530784602056*t4*t442*t19*t54*t5*t106*t118+
        .03291061569204112*t4*t19*t441*t315*t5*t106*t118+.01645530784602056*
        t4*t443*t26*t5*t106*t118+.06582123138408225*grada*t264*t26*
        t5*t106*t118+.03291061569204112*t19*t26*t5*t106*t118-.01645530784602056*
        t4*t19*t26*t5*t106*t453*t113+.01645530784602056*t4*t19*t265*
        t26*t5*t89*t117*t279*t113+.03291061569204112*t4*t19*t263*t54*
        t5*t106*t279*t113-.03291061569204112*t4*t264*t26*t5*t106*t279*
        t113-.06582123138408225*grada*t19*t26*t5*t106*t279*t113+t265*
        t33*t109*t279*t120*t113)-.8888888888888888*t42*t69*t78*(-2.4*
        t32*(0.0641391219265211*t24*(-1.0*t19*t442*t54-2.0*t263*t264*
        t54+2.0*t19*t315*t441+t443*t26)*t8*t83-0.5*t444*t82-.03206956096326055*
        t24*pow(t271,2.0)*t338*t8+0.25*t337*t440+.1282782438530422*
        grada*t259*t83*t271*t24)-4.962870782535445*t444*t81+.05672746666666666*
        t440-8.4*t444*t81*t36-21.0*t440*t336*t36-12.40717695633861*
        t440*t336-2.7259596*t444*t30-0.0474596*t445*t29+.05672746666666666*
        t444*t29-5.4519192*t440*t29-16.8*t265*t81*t272-0.0474596*t444*
        t27-.09491920000000001*t269*t265)+2.565564877060844*t440*t37*
        t62*MU*t365*t77*t78-.3420753169414459*t444*t37*t62*MU*t270*
        t77*t78-.6841506338828918*t265*t273*t62*MU*t270*t77*t78+2.666666666666667*
        t444*t37*t79*t69*t78+5.333333333333333*t265*t273*t79*t69*t78-
        10.66666666666667*t440*t37*t333*t69*t78-0.175523283690886*
        t332*t37*t38*t39*t440*t78/pow(t41,6.0)-.005206415521659982*
        t440*t27*t38*t39*t333*t71*t77-.6841506338828918*t265*t37*t62*
        MU*t270*t266*t77-.04727288888888889*t444*t60*t76+.09454577777777777*
        t440*t42*t76-.3163973333333333*t440*t27*t79*t71*t72-.05273288888888888*
        t445*t60*t71*t72+.1054657777777778*t444*t27*t42*t71*t72+.2109315555555555*
        t269*t265*t42*t71*t72-.01860232654490174*t440*t27*t62*MU*t270*
        t72+.006064083168526658*t444*t62*MU*t268*t72-0.0212242910898433*
        t440*t62*MU*t267*t72+.003382241189982134*t444*t27*t62*MU*t267*
        t72+.006764482379964268*t269*t265*t62*MU*t267*t72+.001555779878874783*
        t440*t38*t39*t79*t69+.07440930617960695*t440*t27*t62*MU*t270*
        t71*t69-.01352896475992854*t444*t27*t62*MU*t267*t71*t69-.02705792951985707*
        t269*t265*t62*MU*t267*t71*t69-.8888888888888888*t37*t42*(-
        .1443130243346725*t444*t62*MU*t64-.02468296176903084*t444*
        t38*t39*t60+.2164695365020088*t440*t62*MU*t268+.04936592353806168*
        t440*t38*t39*t42)*t69+.001735471840553327*t440*t27*t38*t39*
        t333*t69+5.333333333333333*t265*t37*t79*t266*t69-1.777777777777778*
        t273*t42*t266*t69-.03291061569204112*t19*t26*pow(t277,2.0)*
        t339*t4*t5+2.0*pow(t281,2.0)*t33*t358-2.0*t444*t129-.06582123138408225*
        t4*t264*t263*t54*t5*t128-.1316424627681645*grada*t19*t263*
        t54*t5*t128-.03291061569204112*t4*t442*t19*t54*t5*t128+.06582123138408225*
        t4*t19*t441*t315*t5*t128+.03291061569204112*t4*t443*t26*t5*
        t128+.1316424627681645*grada*t264*t26*t5*t128+.06582123138408225*
        t19*t26*t5*t128-4.0*t265*t281*t127-.06582123138408225*t4*t19*
        t263*t54*t5*t277*t104+.06582123138408225*t4*t264*t26*t5*t277*
        t104+.1316424627681645*grada*t19*t26*t5*t277*t104);
    d2fdgagb = 0.0;
    d2fdgagab = 0.0;
    d2fdgbgb = -0.46526286817455*t3*(0.757211*(-1.0*t173*
        t191*t248*t467+2.0*t173*t191*t417*t464-0.5*t173*t189*t245*
        t252*t458+0.5*t173*t189*t423*t454/t186+0.00822765392301028*
        t131*t132*t146*t153*t189*t422*t454/t182+0.25*t173*t189*t252*
        t418*t454-1.0*t189*t245*t252*t454+.03291061569204112*t131*
        t146*t153*t132*t185*t464*t417-2.0*t191*t248*t290*t304-.01645530784602056*
        t131*t146*t153*t132*t185*t467*t248+.01645530784602056*t131*
        t146*t290*t153*t132*t235*t250*t304*t248+.03291061569204112*
        t131*t146*t288*t214*t132*t185*t304*t248-.03291061569204112*
        t131*t289*t153*t132*t185*t304*t248-.06582123138408225*gradb*
        t146*t153*t132*t185*t304*t248+t290*t173*t245*t304*t252*t248+
        0.00411382696150514*t131*t146*t454*t153*t132*t407*t250*t189+
        .01645530784602056*t131*t146*t290*t288*t214*t132*t235*t250*
        t189-0.00822765392301028*t131*t146*t458*t153*t132*t235*t250*
        t189-.01645530784602056*t131*t289*t290*t153*t132*t235*t250*
        t189-.03291061569204112*gradb*t146*t290*t153*t132*t235*t250*
        t189+t458*t191*t189+.03291061569204112*t131*t146*t455*t381*
        t132*t185*t189-.03291061569204112*t131*t289*t288*t214*t132*
        t185*t189-.06582123138408225*gradb*t146*t288*t214*t132*t185*
        t189-.01645530784602056*t131*t456*t146*t214*t132*t185*t189+
        .01645530784602056*t131*t457*t153*t132*t185*t189+.06582123138408225*
        gradb*t289*t153*t132*t185*t189+.03291061569204112*t146*t153*
        t132*t185*t189)-.8888888888888888*t178*t179*t180*(-2.4*t172*
        (-0.5*t230*t458+0.0641391219265211*t135*t151*t231*(-1.0*t146*
        t214*t456+2.0*t146*t381*t455-2.0*t214*t288*t289+t457*t153)+
        0.25*t403*t454-.03206956096326055*t135*t151*pow(t296,2.0)*
        t404+.1282782438530422*gradb*t284*t231*t296*t151)+.05672746666666666*
        t454-12.40717695633861*t454*t402-16.8*t290*t229*t297-.09491920000000001*
        t294*t290-4.962870782535445*t458*t229-21.0*t454*t402*t176-
        8.4*t458*t229*t176-2.7259596*t458*t170-0.0474596*t459*t169+
        .05672746666666666*t458*t169-5.4519192*t454*t169-0.0474596*
        t458*t154)-0.175523283690886*t156*t177*t180*t39*t398*t454/
        pow(t158,6.0)-2.0*t173*t256*(.2951219999999999*t193*pow(t305,
        2.0)*t425-.1475609999999999*t193*(t466+t465+t463+t462)*t254+
        .1475609999999999*t290*t163*t242*t305*t254+.07378049999999997*
        t454*t167*t413*t199+.03689024999999999*t454*t220*t242*t199-
        .07378049999999997*t458*t163*t242*t199)+2.0*t173*pow(t306,
        2.0)*t424+.03291061569204112*t131*t132*t146*t153*t244*(-1.2193*
        t193*pow(t301,2.0)*t406-0.60965*t290*t163*t301*t242*t239+0.60965*
        (t463+t462+t461+t460)*t193*t239-0.304825*t454*t167*t413*t195-
        0.1524125*t454*t220*t242*t195+0.304825*t458*t163*t242*t195)-
        .03291061569204112*t131*t132*t146*t153*pow(t302,2.0)*t405-
        4.0*t290*t306*t256-.06582123138408225*t131*t146*t288*t214*
        t132*t302*t244+.06582123138408225*t131*t289*t153*t132*t302*
        t244+.1316424627681645*gradb*t146*t153*t132*t302*t244-.6841506338828918*
        t290*t177*t161*MU*t295*t291*t226-.005206415521659982*t454*
        t154*t156*t39*t399*t164*t226-2.0*t458*t201+.06582123138408225*
        t131*t146*t455*t381*t132*t197-.06582123138408225*t131*t289*
        t288*t214*t132*t197-.1316424627681645*gradb*t146*t288*t214*
        t132*t197-.03291061569204112*t131*t456*t146*t214*t132*t197+
        .03291061569204112*t131*t457*t153*t132*t197+.1316424627681645*
        gradb*t289*t153*t132*t197+.06582123138408225*t146*t153*t132*
        t197+2.565564877060844*t454*t177*t161*MU*t431*t226*t180-.6841506338828918*
        t290*t298*t161*MU*t295*t226*t180-.3420753169414459*t458*t177*
        t161*MU*t295*t226*t180-10.66666666666667*t454*t177*t399*t179*
        t180+5.333333333333333*t290*t298*t227*t179*t180+2.666666666666667*
        t458*t177*t227*t179*t180+.001735471840553327*t454*t154*t156*
        t39*t399*t179+5.333333333333333*t290*t177*t227*t291*t179-1.777777777777778*
        t298*t178*t291*t179+.001555779878874783*t454*t156*t39*t227*
        t179-.8888888888888888*t177*t178*(-.1443130243346725*t458*
        t161*MU*t220-.02468296176903084*t458*t156*t39*t159+.2164695365020088*
        t454*t161*MU*t293+.04936592353806168*t454*t156*t39*t178)*t179+
        .07440930617960695*t454*t154*t161*MU*t295*t164*t179-.02705792951985707*
        t294*t290*t161*MU*t292*t164*t179-.01352896475992854*t458*t154*
        t161*MU*t292*t164*t179+.09454577777777777*t454*t178*t168-.04727288888888889*
        t458*t159*t168-.01860232654490174*t454*t154*t161*MU*t295*t166+
        .006064083168526658*t458*t161*MU*t293*t166-0.0212242910898433*
        t454*t161*MU*t292*t166+.006764482379964268*t294*t290*t161*
        MU*t292*t166+.003382241189982134*t458*t154*t161*MU*t292*t166-
        .3163973333333333*t454*t154*t227*t164*t166+.2109315555555555*
        t294*t290*t178*t164*t166+.1054657777777778*t458*t154*t178*
        t164*t166-.05273288888888888*t459*t159*t164*t166);
    d2fdgbgab = 0.0;
    d2fdgabgab = 0.0;


    ds->df1000 += factor*dfdra;
    ds->df0100 += factor*dfdrb;
    ds->df0010 += factor*dfdga;
    ds->df0001 += factor*dfdgb;
    ds->df00001+= factor*dfdgab;

    ds->df2000 += factor*d2fdrara;
    ds->df1100 += factor*d2fdrarb;
    ds->df1010 += factor*d2fdraga;
    ds->df1001 += factor*d2fdragb;
    ds->df10001+= factor*d2fdraab;
    ds->df0200 += factor*d2fdrbrb;
    ds->df0110 += factor*d2fdrbga;
    ds->df0101 += factor*d2fdrbgb;
    ds->df01001+= factor*d2fdrbgab;
    ds->df0020 += factor*d2fdgaga;
    ds->df0011 += factor*d2fdgagb;
    ds->df00101+= factor*d2fdgagab;
    ds->df0002 += factor*d2fdgbgb;
    ds->df00011+= factor*d2fdgbgab;
    ds->df00002+= factor*d2fdgabgab;

}
