!dirac_copyright_start
!      Copyright (c) by the authors of DIRAC.
!
!      This program is free software; you can redistribute it and/or
!      modify it under the terms of the GNU Lesser General Public
!      License version 2.1 as published by the Free Software Foundation.
!
!      This program is distributed in the hope that it will be useful,
!      but WITHOUT ANY WARRANTY; without even the implied warranty of
!      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
!      Lesser General Public License for more details.
!
!      If a copy of the GNU LGPL v2.1 was not distributed with this
!      code, you can obtain one at https://www.gnu.org/licenses/old-licenses/lgpl-2.1.en.html.
!dirac_copyright_end

C
C
C  /* Deck twoint */
      SUBROUTINE TWOINT(WORK,LWORK,FMAT,DMAT,NDMAT,IREPDM,IFCTYP,GMAT,
     &               INDX,INDXAB,ITYPE,MAXDIF,JATOM,NODV,
     &               NOPV,NOCONT,TTIME,JPRINT,IPRNTA,IPRNTB,IPRNTC,
     &               IPRNTD,RETUR,ISHLA,I2TYP,ICEDIF,SCREEN,
     &               GABRAO,DMRAO,DMRSO,DINTSKP,RELCAL,GENCNT,
     &               INDEX,TIMES)
C
C     Trygve Helgaker, University of Oslo, Norway, 1984
C
C     General contraction, Feb - Mar 1988, TUH
C     Symmetry processing 880408  PRT & TUH
C
C     References for calculation of Cartesian integrals:
C     --------------------------------------------------
C
C     L. E. McMurchie & E. R. Davidson, J. Comput. Chem. 26, 218 (1978)
C     V. R. Saunders, in "Methods in Computational Molecular Physics",
C       G. H. F. Diercksen and S. Wilson, eds. (Reidel,Dordrecht,1983)
C     T. U. Helgaker et al., JCP 84, 6266 (1986)
C
C
C     References for symmetry:
C     ------------------------
C
C     E. R. Davidson, JCP 62, 400 (1975)
C     P. R. Taylor,   TCA 69, 447 (1986)
C     J. Almloef, MOLECULE Program Description, USIP Report 74 - 29
C
#include "implicit.h"
#include "priunit.h"
#include "maxaqn.h"
#include "mxcent.h"
#include "maxorb.h"
      PARAMETER (D0 = 0.00 D00)
      LOGICAL NOPV, NODV, PERTUR, EXPECT, UNDIFF, DIRFCK, RETUR, TTIME,
     &        NOCONT, SPNORB, DISTRI, SQ12EL, LONDON, SUSCEP, DDFOCK,
     &        ADISTR, SOFOCK, RELCAL, GENCNT
      DIMENSION DMAT(*), FMAT(*), GMAT(*), IREPDM(*), IFCTYP(*),
     &        INDX(2,*),INDXAB(*), WORK(LWORK),DINTSKP(*),
     &        GABRAO(*),DMRAO(*),DMRSO(*),INDEX(*),TIMES(*)
#include "ccom.h"
#include "symmet.h"
#include "nuclei.h"
#include "twosta.h"
C
      IF (JPRINT .GT. 5) CALL TITLER('Output from TWOINT','*',103)
C980827-hjaaj : "old" NOCONT does not work in this version
      IF (NOCONT) THEN
         WRITE (LUPRI,*)
     &      'TWOINT ERROR, .NOCONT is not implemented in this version'
         CALL QUIT('TWOINT: .NOCONT is not implemented in this version')
      END IF
C
      TKTIME = TTIME
C
C     CPU time statistics
C
      T2INT = SECOND()
      CALL DELSTA(-1,IDUM)
      CALL REDSTA(-1,IDUM,IDUM,IDUM,IDUM)
      IF (TKTIME) THEN
         TR000  = D0
         THERI  = D0
         TODCVE = D0
         TEXCOE = D0
         TC10IN = D0
         TC1EIN = D0
         TC2HIN = D0
         TC2EIN = D0
         TSYM2S = D0
         TSYMOU = D0
         TFCKOU = D0
         TDSOUT = D0
         TSPOSY = D0
         TDRSYM = D0
         TINTEX = D0
         TPATH1 = D0
         TPATH2 = D0
         MAXJ = 4*(NHTYP - 1) + 2
         DO 100 I = 0, MAXJ
            TR000X(I) = D0
            THERIX(I) = D0
  100    CONTINUE
      END IF
C
C     Work space statistics
C
      LWTOT  = 0
      MWTOT  = 0
      MWFCAB = 0
      MWFCCD = 0
      MWPSO  = 0
      MWSOIN = 0
      MWAOIN = 0
      MWHRIN = 0
      MWHRND = 0
      MWHCIN = 0
      MWRJ00 = 0
      MWHRSQ = 0
      MWC1DR = 0
      MWC2DR = 0
      MWC2HI = 0
      MWC2EI = 0
      MWINTE = 0
      MWPPRI = 0
      MWDRSY = 0
C
C     Threshold for integrals
C
      THRESH = MAX(THRS,1.00D-15)
C
C     Determine run type
C
      CALL TWORUN(ITYPE,MAXDIF,JATOM,PERTUR,EXPECT,UNDIFF,
     &            DIRFCK,SOFOCK,SPNORB,DISTRI,SQ12EL,LONDON,SUSCEP,
     &            DDFOCK,ADISTR,MAXDER,IATOM,MULE,MULTE,
     &            JPRINT)
      CALL WHTREP(ITYPE,MULE,JPRINT)
C
C
C     *******************************
C     ***** Calculate integrals *****
C     *******************************
C
      CALL TWOCAL(WORK,LWORK,FMAT,DMAT,NDMAT,GMAT,INDX,INDXAB,
     &            MAXDER,
     &            EXPECT,UNDIFF,DDFOCK,DIRFCK,SOFOCK,DISTRI,LONDON,
     &            SPNORB,SUSCEP,PERTUR,IATOM,MULE,MULTE,NODV,NOPV,
     &            NOCONT,THRESH,JPRINT,IPRNTA,IPRNTB,IPRNTC,IPRNTD,
     &            SQ12EL,RETUR,NHTYP,IREPDM,IFCTYP,
     &            ISHLA,ADISTR,I2TYP,ICEDIF,SCREEN,DINTSKP,
     &            GABRAO,DMRAO,DMRSO,RELCAL,GENCNT,INDEX,TIMES)
      T2INT = SECOND() - T2INT
C
C     *******************
C     ***** Timings *****
C     *******************
C
      IF (TKTIME) THEN
         CALL HEADER('Timings for TWOINT',1)
         WRITE (LUPRI, '(18(/,1X,A,F8.2,A))')
     &      ' Time in R000:   ', TR000, ' seconds',
     &      ' Time in HERI:   ', THERI, ' seconds',
     &      ' Time in ODCVEC: ', TODCVE,' seconds',
     &      ' Time in EXCOEF: ', TEXCOE,' seconds',
     &      ' Time in C10INT: ', TC10IN,' seconds',
     &      ' Time in C1EINT: ', TC1EIN,' seconds',
     &      ' Time in C2HINT: ', TC2HIN,' seconds',
     &      ' Time in C2EINT: ', TC2EIN,' seconds',
     &      ' Time in SYM2:   ', TSYM2S,' seconds',
     &      ' Time in DRSYM2: ', TDRSYM,' seconds',
     &      ' Time in SPOSYM: ', TSPOSY,' seconds',
     &      ' Time in UN2OUT: ', TSYMOU,' seconds',
     &      ' Time in FCKOUT: ', TFCKOU,' seconds',
     &      ' Time in DR2OUT: ', TDSOUT,' seconds',
     &      ' Time in INTEXP: ', TINTEX,' seconds',
     &      ' Time for PATH1: ', TPATH1,' seconds',
     &      ' Time for PATH2: ', TPATH2,' seconds'
C        WRITE (LUPRI, '(/,2(1X,A,I2,A,/,1X,10F6.2))')
C    &      ' Detailed timings for R000 integrals (JMAX = 1, ',
C    &        MAXJ,'):', (TR000X(I), I = 1, MAXJ),
C    &      ' Detailed timings for Hermitian integrals (JMAX = 1, ',
C    &        MAXJ,'):', (THERIX(I), I = 1, MAXJ)
      END IF
C
C     *********************************
C     ***** Work space statistics *****
C     *********************************
C
      IF (JPRINT .GT. 2 .OR. LWTOT .NE. 0) THEN
      IF (.NOT.DISTRI) THEN
         CALL HEADER('Maximum work space allocations in TWOINT',1)
         WRITE (LUPRI,'(15(1X,A,I7/))')
     &      ' Total allocation:                   ', MWTOT,
     &      ' Expansion coefficients (electron 1):', MWFCAB,
     &      ' Expansion coefficients (electron 2):', MWFCCD,
     &      ' Two-electron densities:             ', MWPSO ,
     &      ' SO integrals:                       ', MWSOIN,
     &      ' AO integrals:                       ', MWAOIN,
     &      ' Hermite integrals:                  ', MWHRIN,
     &      ' Hermite integral pointer:           ', MWHRND,
     &      ' Hermite-Cartesian integrals:        ', MWHCIN,
     &      ' Gamma functions:                    ', MWRJ00,
     &      ' Work space for Hermite integrals:   ', MWHRSQ,
     &      ' Allocations in C1DRIV:              ', MWC1DR,
     &      ' Allocations in C2DRIV:              ', MWC2DR,
     &      ' Allocations in C2HINT:              ', MWC2HI,
     &      ' Allocations in C2EINT:              ', MWC2EI,
     &      ' Allocations in INTEXP:              ', MWINTE,
     &      ' Allocations in PPRIM :              ', MWPPRI,
     &      ' Allocations in DRSYM2:              ', MWDRSY
      END IF
      END IF
      IF (LWTOT .NE. 0) THEN
         WRITE (LUPRI,'(1X,A)')    ' Error in work space statistics.'
         WRITE (LUPRI,'(1X,A,I7)') ' LWTOT at end of TWOINT:',LWTOT
      END IF
      IF (JPRINT .GT. 2) THEN
         IF (.NOT.DISTRI) THEN
            CALL TWOPER
            CALL REDSTA(1,IDUM,IDUM,IDUM,IDUM)
            CALL DELSTA(1,IDUM)
          ENDIF
      ENDIF
      RETURN
      END
C  /* Deck twocal */
      SUBROUTINE TWOCAL(WORK,LWORK,FMAT,DMAT,NDMAT,GMAT,INDX,INDXAB,
     &                 MAXDER,EXPECT,UNDIFF,DDFOCK,DIRFCK,
     &                 SOFOCK,DISTRI,
     &                 LONDON,SPNORB,SUSCEP,PERTUR,IATOM,MULE,MULTE,
     &                 NODV,NOPV,NOCONT,THRESH,JPRINT,IPRNTA,IPRNTB,
     &                 IPRNTC,IPRNTD,SQ12EL,RETUR,NHTYP,
     &                 IREPDM,IFCTYP,ISHLA,ADISTR,I2TYP,ICEDIF,SCREEN,
     &                 DINTSKP,GABRAO,DMRAO,DMRSO,RELCAL,GENCNT,
     &                 INDEX,TIMES)
#include "implicit.h"
#include "priunit.h"
#include "maxorb.h"
#include "maxaqn.h"
#include "aovec.h"
      LOGICAL NOPV, NODV, PERTUR, EXPECT, UNDIFF, DDFOCK, DIRFCK, RETUR,
     &        NOCONT, LONDON, SPNORB, DISTRI, SQ12EL, SUSCEP, ADISTR,
     &        SOFOCK, RELCAL, GENCNT
      DIMENSION DMAT(*), FMAT(*), GMAT(*), IREPDM(*), IFCTYP(*),
     &        INDX(2,*),INDXAB(*), GABRAO(*),DMRAO(*), DMRSO(*),
     &        DINTSKP(*), INDEX(*),TIMES(*),WORK(LWORK)
#include "hertop.h"
#include "infpar.h"
#include "twosta.h"
#include "blocks.h"
C
      CALL QENTER('TWOCAL')
#include "memint.h"
      IF (JPRINT .GT. 5) CALL TITLER('Output from TWOCAL','*',103)
C
      JTOP  = 4*(NHTYP - 1) + MAXDER
      JTOP3 = (JTOP + 1)**3
      NRTOP = (JTOP + 1)*(JTOP + 2)*(JTOP + 3)/6
      CALL MEMGET('INTE',KINDHR,JTOP3  ,WORK,KFREE,LFREE)
      CALL MEMGET('INTE',KINDSQ,NRTOP  ,WORK,KFREE,LFREE)
      CALL MEMGET('INTE',KIODHR,8*NRTOP,WORK,KFREE,LFREE)
      MWHRND = KFREE - 1
      LWTOT  = LWTOT + KFREE - 1
      CALL HERPRP(WORK(KINDHR),WORK(KINDSQ),WORK(KIODHR))
C
C     *******************************
C     ***** Calculate integrals *****
C     *******************************
C
      IF (DISTRI) THEN
C
C        Distributions
C        =============
C
         CALL TWODIS(WORK(KFREE),LFREE,FMAT,DMAT,NDMAT,GMAT,
     &               INDX,INDXAB,GABRAO,DMRAO,DINTSKP,SCREEN,
     &               MAXDER,EXPECT,SUSCEP,UNDIFF,DDFOCK,DIRFCK,
     &               SOFOCK,DISTRI,LONDON,SPNORB,PERTUR,IATOM,
     &               MULE,MULTE,NODV,NOPV,
     &               NOCONT,THRESH,JPRINT,IPRNTA,IPRNTB,IPRNTC,IPRNTD,
     &               SQ12EL,WORK(KINDHR),WORK(KINDSQ),
     &               WORK(KIODHR),IFCTYP,ADISTR,I2TYP,RELCAL,GENCNT)
      ELSE IF (ADISTR) THEN
C
C        All g_abcd for given index a
C        ============================
C
         CALL TWODSA(WORK(KFREE),LFREE,FMAT,DMAT,NDMAT,GMAT,MAXDER,
     &               EXPECT,SUSCEP,UNDIFF,DDFOCK,DIRFCK,SOFOCK,
     &               DISTRI,LONDON,SPNORB,PERTUR,IATOM,MULE,MULTE,
     &               NODV,NOPV,NOCONT,
     &               THRESH,JPRINT,IPRNTA,IPRNTB,IPRNTC,IPRNTD,RETUR,
     &               SQ12EL,WORK(KINDHR),WORK(KINDSQ),WORK(KIODHR),
     &               IREPDM,IFCTYP,ISHLA,ADISTR,I2TYP,RELCAL,GENCNT)
C
      ELSE
C
C        All integrals
C        =============
C
#if defined (VAR_MPI) 
         IF (PARHER) THEN
            CALL PARLOP(WORK(KFREE),LFREE,FMAT,DMAT,NDMAT,GMAT,MAXDER,
     &           EXPECT,SUSCEP,UNDIFF,DDFOCK,DIRFCK,SOFOCK,
     &           DISTRI,LONDON,
     &           SPNORB,PERTUR,IATOM,MULE,MULTE,NODV,NOPV,NOCONT,
     &           THRESH,JPRINT,IPRNTA,IPRNTB,IPRNTC,IPRNTD,RETUR,
     &           SQ12EL,WORK(KINDHR),WORK(KINDSQ),WORK(KIODHR),
     &           IREPDM,IFCTYP,ADISTR,I2TYP,ICEDIF,SCREEN,
     &           GABRAO,DMRAO,DMRSO,DINTSKP,RELCAL,GENCNT,
     &           INDEX,TIMES)
         ELSE
#endif
            CALL TWOLOP(WORK(KFREE),LFREE,FMAT,DMAT,NDMAT,GMAT,MAXDER,
     &                EXPECT,SUSCEP,UNDIFF,DDFOCK,DIRFCK,SOFOCK,
     &                DISTRI,LONDON,
     &                SPNORB,PERTUR,IATOM,MULE,MULTE,NODV,NOPV,NOCONT,
     &                THRESH,JPRINT,IPRNTA,IPRNTB,IPRNTC,IPRNTD,RETUR,
     &                SQ12EL,WORK(KINDHR),WORK(KINDSQ),WORK(KIODHR),
     &                IREPDM,IFCTYP,ADISTR,I2TYP,ICEDIF,SCREEN,
     &                GABRAO,DMRAO,DMRSO,DINTSKP,RELCAL,GENCNT)
         END IF
#if defined (VAR_MPI) || defined (VAR_MPI)
      END IF
#endif
      LWTOT  = LWTOT - KFREE + 1
      CALL MEMREL('TWOCAL',WORK,KWORK,KWORK,KFREE,LFREE)
      CALL QEXIT('TWOCAL')
      RETURN
      END
C  /* Deck twolop */
      SUBROUTINE TWOLOP(WORK,LWORK,FMAT,DMAT,NDMAT,GMAT,MAXDER,EXPECT,
     &                  SUSCEP,UNDIFF,DDFOCK,DIRFCK,SOFOCK,DISTRI,
     &                  LONDON,SPNORB,PERTUR,IATOM,MULE,MULTE,
     &                  NODV,NOPV,NOCONT,THRESH,JPRINT,IPRNTA,
     &                  IPRNTB,IPRNTC,IPRNTD,RETUR,
     &                  SQ12EL,INDHER,INDHSQ,IODDHR,IREPDM,IFCTYP,
     &                  ADISTR,I2TYP,ICEDIF,SCREEN,
     &                  GABRAO,DMRAO,DMRSO,DINTSKP,RELCAL,GENCNT)
C
#include "implicit.h"
#include "priunit.h"
#include "maxaqn.h"
#include "mxcent.h"
#include "aovec.h"
#include "maxorb.h"
      PARAMETER(D0 = 0.0D0)
      PARAMETER (LUPAS = 27, LUPAO = 29)
      LOGICAL PRINTA, PRINTB, PRINTC, PRINTD, NOPV, NODV, PERTUR,
     &        EXPECT, UNDIFF, DDFOCK, DIRFCK, DISTRI, NOCONT, SPNORB,
     &        RETUR, FIRST, SQ12EL, LONDON, SUSCEP, ADISTR, SOFOCK,
     &        RELCAL, GENCNT
      DIMENSION DMAT(*), FMAT(*), GMAT(*), IREPDM(*), IFCTYP(*),
     &        INDHSQ(*), IODDHR(*), INDHER(*), GABRAO(*),
     &        DMRAO(*),DMRSO(*),DINTSKP(*),WORK(LWORK)
#include "cbisol.h"
#include "twocom.h"
#include "nuclei.h"
#ifdef PRG_DIRAC
#include "dcbgrd.h"
#include "dcbham.h"
#else
#include "energy.h"
#endif
#include "taymol.h"
#include "taysol.h"
#include "suscpt.h"
#include "inforb.h"
#include "blocks.h"
#include "symmet.h"
C
      CALL QENTER('TWOLOP')
      IF (JPRINT .GT. 5) CALL TITLER('Output from TWOLOP','*',103)
      FIRST = .TRUE.
      DIRAC = RELCAL
      IF (EXPECT .AND. .NOT.NOPV) THEN
         REWIND LUPAO
      END IF
      IF (SUSCEP) THEN
         IF (.NOT.NOPV) THEN
            REWIND LUPAO
            REWIND LUPAS
         ENDIF
CMI ... we are entering more loops (LL,LS,SS integrals) and thus we need
CMI     to accumulate integral contributions
CMI      CALL DZERO(SUS2EL,9)
      END IF
C
C     For direct contributions: some parameters
C       SCREEN is threshold for screening
C       ICEFLG gives information about separate screening of
C              Coulomb/exchange for each DMAT
C       NCM    is the number of DMAT requiring Coulomb-contributions
C       NEM    is the number og DMAT requiring exchange-contributions
C
C       SOFOCK .OR. DIRFCK:
C
C       Screening proceeds in three steps as documented by DINTSKP:
C         Step 1: Screening on integral batches
C           DINTSKP(1,1) - total number of integrals
C           DINTSKP(2,1) - number of integrals skipped (batchwise)
C         Step 2: Screening on individual integrals 
C                 while unpacking indices
C           DINTSKP(1,2) - number of integrals remaining after step 1
C           DINTSKP(2,2) - number of integrals skipped
C         Step 3a: Screening on Coulomb contributions
C           DINTSKP(1,3) - NCM times number of integrals remaining 
C                         after step 2
C           DINTSKP(2,3) - NCM times number of integrals skipped
C         Step 3b: Screening on exchange contributions
C           DINTSKP(1,4) - NEM times number of integrals remaining 
C                         after step 2
C           DINTSKP(2,4) - NEM times number of integrals skipped
C
C       EXPECT .AND. (MAXDER.EQ.1):
C
C          I = 1,14 
C          DINTSKP(1,I,1) - total number of integrals, x direction
C          DINTSKP(1,I,2) - total number of integrals, y direction
C          DINTSKP(1,I,3) - total number of integrals, z direction
C
C          DINTSKP(2,I,1) - number of integrals skipped, x direction
C          DINTSKP(2,I,2) - number of integrals skipped, y direction
C          DINTSKP(2,I,3) - number of integrals skipped, z direction
C
      DOSCRN = .FALSE.
      LSCALE_GAUNT = LSCALE_DFT_GAUNT
      IF(DIRFCK.OR.SOFOCK.OR.(EXPECT.AND.MAXDER.EQ.1))  THEN
         IF (DIRFCK.OR.SOFOCK) THEN
            CALL DZERO(DINTSKP,8)
         ELSE
            CALL DZERO(DINTSKP,3*14*3)
         END IF
         IF(SCREEN.GT.D0) THEN
            DOSCRN = .TRUE.
            SCRTHR = SCREEN
         END IF
         ICEFLG = ICEDIF
         NCM = 0
         NEM = 0
         DO I = 1,NDMAT
            IY  = MOD(IFCTYP(I),10)
            IC  = MOD(IY,2)
            IE  = IY/2
            IX = IFCTYP(I)/10
            IF (IX.EQ.2) IC = 0
C           ... no Coulomb term for antisymmetric density matrix
            IF (HFXFAC.EQ.D0) IE = 0
            NCM = NCM + IC
            NEM = NEM + IE
         ENDDO
      ENDIF
C
      IF(I2TYP.EQ.0) THEN
C       Non-relativistic: all integrals (ab|cd) with (ab).ge.(cd)
        IASTRT = 1
        IBSTRT = 1
        ICSTRT = 1
        IDSTRT = 1
        IASMAX = MAXSHL
        IBSMAX = MAXSHL
        ICSMAX = MAXSHL
        IDSMAX = MAXSHL
      ELSEIF(I2TYP.EQ.1) THEN
C       Coulomb integral class (LL|LL)
        IASTRT = 1
        IBSTRT = 1
        ICSTRT = 1
        IDSTRT = 1
        IASMAX = NLRGBL
        IBSMAX = NLRGBL
        ICSMAX = NLRGBL
        IDSMAX = NLRGBL
      ELSEIF(I2TYP.EQ.2) THEN
C       Coulomb integral class (SS|LL)
        IASTRT = NLRGBL+1
        IBSTRT = NLRGBL+1
        ICSTRT = 1
        IDSTRT = 1
        IASMAX = MAXSHL
        IBSMAX = MAXSHL
        ICSMAX = NLRGBL
        IDSMAX = NLRGBL
      ELSEIF(I2TYP.EQ.3) THEN
C       Coulomb integral class (SS|SS)
        IASTRT = NLRGBL+1
        IBSTRT = NLRGBL+1
        ICSTRT = NLRGBL+1
        IDSTRT = NLRGBL+1
        IASMAX = MAXSHL
        IBSMAX = MAXSHL
        ICSMAX = MAXSHL
        IDSMAX = MAXSHL
      ELSEIF(I2TYP.EQ.4) THEN
C       Gaunt integral class (SL|SL)
        IASTRT = NLRGBL+1
        IBSTRT = 1
        ICSTRT = NLRGBL+1
        IDSTRT = 1
        IASMAX = MAXSHL
        IBSMAX = NLRGBL
        ICSMAX = MAXSHL
        IDSMAX = NLRGBL
      ELSE
        WRITE(LUPRI,'(A,I5)') 'TWOLOP: Unknown I2TYP =' ,I2TYP
        CALL QUIT('Unknown I2TYP !!!')
      ENDIF
C
C     *****************************
C     ***** First Shell Index *****
C     *****************************
C
      DO 100 ISHELA = IASTRT,IASMAX
C
         ICA    = LCLASH(ISHELA)
C
         NHKTA  = NHKTSH(ISHELA)
         KHKTA  = KHKTSH(ISHELA)
         KCKTA  = KCKTSH(ISHELA)
         SPHRA  = SPHRSH(ISHELA)
         NCENTA = NCNTSH(ISHELA)
         MULA   = ISTBSH(ISHELA)
         MULTA  = MULT(MULA)
         NSTRA  = IORBSB(IORBSH(ISHELA,1))
         NUCA   = NUCOSH(ISHELA)
         NORBA  = NORBSH(ISHELA)
         CORAX0 = CENTSH(ISHELA,1)
         CORAY0 = CENTSH(ISHELA,2)
         CORAZ0 = CENTSH(ISHELA,3)
         PRINTA = .TRUE.
         IF ((ISHELA .NE. IPRNTA).AND.(IPRNTA .NE. 0)) PRINTA = .FALSE.
C
C        ******************************
C        ***** Second Shell Index *****
C        ******************************
C
         IBMAX = ISHELA
         IF (I2TYP.EQ.4) IBMAX = NLRGBL
         DO 200 ISHELB = IBSTRT,IBMAX
C
            ICB    = LCLASH(ISHELB)
C
            NHKTB  = NHKTSH(ISHELB)
            KHKTB  = KHKTSH(ISHELB)
            KCKTB  = KCKTSH(ISHELB)
            SPHRB  = SPHRSH(ISHELB)
            NCENTB = NCNTSH(ISHELB)
            MULB   = ISTBSH(ISHELB)
            MULTB  = MULT(MULB)
            NSTRB  = IORBSB(IORBSH(ISHELB,1))
            NUCB   = NUCOSH(ISHELB)
            NORBB  = NORBSH(ISHELB)
            CORBX0 = CENTSH(ISHELB,1)
            CORBY0 = CENTSH(ISHELB,2)
            CORBZ0 = CENTSH(ISHELB,3)
            GENAB  = .NOT.(SEGMSH(ISHELA) .AND. SEGMSH(ISHELB))
            IGENAB = 1
            IF (.NOT.GENAB) IGENAB = 2
            NSETA  = NSETSH(ISHELA,IGENAB)
            NSETB  = NSETSH(ISHELB,IGENAB)
            PRINTB = PRINTA
            IF ((ISHELB.NE.IPRNTB).AND.(IPRNTB.NE.0)) PRINTB = .FALSE.
            IF (PRINTB) THEN
               IPRINT = JPRINT
            ELSE
               IPRINT = 0
            END IF
C
C           Skip two-center SS contributions if requested
C           This test is provisory, in SYMLOP we take out more integrals
C           in case of symmetry-degenerate nuclei. Testing at this place,
C           will, however, take out the work in ODCVEC and EXCOEF that 
C           otherwise would cause a quartic scaling term.
C
            IF (ONECAP) THEN
               IF (NCENTA.NE.NCENTB.AND.ICA.EQ.2.AND.ICB.EQ.2) GO TO 200
            ENDIF
C
C           *****************************
C           ***** Third Shell Index *****
C           *****************************
C
            ICMAX = ISHELA
            IF (SPNORB) ICMAX = MAXSHL
            IF(I2TYP.EQ.2) ICMAX = NLRGBL
            DO 300 ISHELC = ICSTRT, ICMAX
C
               ICC    = LCLASH(ISHELC)
C
               NHKTC  = NHKTSH(ISHELC)
               KHKTC  = KHKTSH(ISHELC)
               KCKTC  = KCKTSH(ISHELC)
               SPHRC  = SPHRSH(ISHELC)
               NCENTC = NCNTSH(ISHELC)
               MULC   = ISTBSH(ISHELC)
               MULTC  = MULT(MULC)
               NSTRC  = IORBSB(IORBSH(ISHELC,1))
               NUCC   = NUCOSH(ISHELC)
               NORBC  = NORBSH(ISHELC)
               CORCX0 = CENTSH(ISHELC,1)
               CORCY0 = CENTSH(ISHELC,2)
               CORCZ0 = CENTSH(ISHELC,3)
               PRINTC = PRINTB
               IF ((ISHELC.NE.IPRNTC).AND.(IPRNTC.NE.0)) PRINTC=.FALSE.
C
C              ******************************
C              ***** Fourth Shell Index *****
C              ******************************
C
               IDMAX = ISHELC
C              Note the order of these tests : can not be changed !
               IF (I2TYP.EQ.4) IDMAX = NLRGBL
               IF (.NOT.SPNORB.AND.(ISHELA.EQ.ISHELC)) IDMAX = ISHELB
               DO 400 ISHELD = IDSTRT,IDMAX
C
                  ICD    = LCLASH(ISHELD)
C
                  NHKTD  = NHKTSH(ISHELD)
                  KHKTD  = KHKTSH(ISHELD)
                  KCKTD  = KCKTSH(ISHELD)
                  SPHRD  = SPHRSH(ISHELD)
                  NCENTD = NCNTSH(ISHELD)
                  MULD   = ISTBSH(ISHELD)
                  MULTD  = MULT(MULD)
                  NSTRD  = IORBSB(IORBSH(ISHELD,1))
                  NUCD   = NUCOSH(ISHELD)
                  NORBD  = NORBSH(ISHELD)
                  CORDX0 = CENTSH(ISHELD,1)
                  CORDY0 = CENTSH(ISHELD,2)
                  CORDZ0 = CENTSH(ISHELD,3)
                  GENCD = .NOT.(SEGMSH(ISHELC) .AND. SEGMSH(ISHELD))
                  IGENCD = 1
                  IF (.NOT.GENCD) IGENCD = 2
                  NSETC = NSETSH(ISHELC,IGENCD)
                  NSETD = NSETSH(ISHELD,IGENCD)
                  PRINTD = PRINTC
                  IF ((ISHELD .NE. IPRNTD).AND.(IPRNTD .NE. 0))
     &               PRINTD = .FALSE.
                  IF (PRINTD) THEN
                     IPRINT = JPRINT
                  ELSE
                     IPRINT = 0
                  END IF
C
                  SHAEQB = ISHELA .EQ. ISHELB
                  SHCEQD = ISHELC .EQ. ISHELD
                  SHABAB = (ISHELA.EQ.ISHELC) .AND. (ISHELB.EQ.ISHELD)
C
                  IF (ONECAP) THEN
                     IF (NCENTC.NE.NCENTD.AND.ICC.EQ.2.AND.ICD.EQ.2)
     &                  GO TO 400
                  ENDIF

C
C                 *******************************
C                 ***** Calculate integrals *****
C                 *******************************
C
                  CALL TWOODS(FMAT,DMAT,NDMAT,GMAT,WORK,LWORK,UNDIFF,
     &                        PERTUR,LONDON,SPNORB,EXPECT,SUSCEP,DDFOCK,
     &                        DIRFCK,SOFOCK,DISTRI,IATOM,MULE,MULTE,
     &                        MAXDER,NOCONT,NODV,NOPV,THRESH,IPRINT,
     &                        FIRST,SQ12EL,INDHSQ,IODDHR,INDHER,IFCTYP,
     &                        ADISTR,DUM,ICEDIF,DINTSKP,
     &                        GABRAO,DMRAO,DMRSO,IREPDM,IDUM,IDUM,
     &                        GENCNT)

C
                  IF (RETUR) THEN
                     IF (ISHELA .EQ. IPRNTA .AND.
     &                   ISHELB .EQ. IPRNTB .AND.
     &                   ISHELC .EQ. IPRNTC .AND.
     &                   ISHELD .EQ. IPRNTD) GOTO 999
                  END IF
  400          CONTINUE
  300       CONTINUE
  200    CONTINUE
  100 CONTINUE
C
C     Symmetrize skeleton Fock matrices
C     =================================
C

      IF (DDFOCK.AND.(.NOT.LONDON)) THEN
         CALL SKLFCK(FMAT,WORK,LWORK,JPRINT,DIRFCK,DDFOCK,EXPECT,PERTUR,
     &               NODV,MAXDER,LONDON,NDMAT,IREPDM,IFCTYP,IATOM)
      END IF

CMI   ... fix 
      IPRINT = JPRINT

C
C     <<<<< Print Section - Gradient and Hessian Elements >>>>>
C
      IF (EXPECT) THEN
         IF (JPRINT .GT. 0) THEN
Cjth - This must be rewritten to work in Dirac. TODO ?
C      Eg. GRADNN is not defined in DIRAC
#if !defined (PRG_DIRAC)
            CALL HEADER('Two-electron integral gradient',-1)
            CALL PRIGRD(GRADEE)
            CALL HEADER('Potential energy (NN + NE + EE) gradient',-1)
            CALL ZERGRD
            CALL ADDGRD(GRADNN)
            CALL ADDGRD(GRADNA)
            CALL ADDGRD(GRADEE)
            CALL PRIGRD(GRDMOL)
            CALL HEADER('Molecular gradient',-1)
            CALL ADDGRD(GRADFS)
            CALL ADDGRD(GRADKE)
            IF (SOLVNT) THEN
               CALL ADDGRD(GSOLTT)
               CALL ADDGRD(GSOLNN)
            END IF
            CALL PRIGRD(GRDMOL)
            NCDEP3 = 3*NUCDEP
            GRDNRM = DDOT(NCDEP3,GRDMOL,1,GRDMOL,1)
            GRDNRM = SQRT(GRDNRM)
            WRITE (LUPRI,'(/19X,A,1P,E10.2)')
     *         'Molecular gradient norm:', GRDNRM
            CALL ZERGRD
            IF (MAXDER.EQ.2) THEN
               CALL HEADER('Two-electron integral Hessian',-1)
               CALL PRIHES(HESSEE,'CENTERS')
               CALL HEADER('Potential energy (NN + NE + EE) Hessian',-1)
               CALL ZERHES
               CALL ADDHES(HESSNN)
               CALL ADDHES(HESSNA)
               CALL ADDHES(HESSEE)
               IF (SOLVNT) CALL ADDHES(HSOLT2)
               IF (SOLVNT) CALL ADDHES(HSOLNN)
               CALL PRIHES(HESMOL,'CENTERS')
               CALL ZERHES
            END IF
#endif
         END IF
      END IF
      IF (LONDON .AND. MAXDER.EQ.2) THEN
         SUS2EL(2,1) = SUS2EL(1,2)
         SUS2EL(3,1) = SUS2EL(1,3)
         SUS2EL(3,2) = SUS2EL(2,3)
         IF (JPRINT .GT. 1) THEN
            CALL HEADER('Two-electron integral susceptibilities',-1)
            CALL OUTPUT(SUS2EL,1,3,1,3,3,3,1,LUPRI)
         END IF
      END IF
C
C     Print Fock matrices
      IF ((DIRFCK.OR.SOFOCK) .AND. IPRINT.GT.8) THEN
CMI      write(LUPRI,*) 'IPRINT=',IPRINT
         CALL HEADER('Fock matrix in TWOINT',-1)
         DO 700 I = 1, NDMAT
            ISTR = NBAST*NBAST*(I - 1) + 1
            WRITE (LUPRI,'(//,1X,A,I3)') ' Fock matrix No.',I
            CALL OUTPUT(FMAT(ISTR),1,NBAST,1,NBAST,NBAST,NBAST,1,LUPRI)
  700    CONTINUE
      END IF
 720  CONTINUE
 999  CONTINUE
      CALL QEXIT('TWOLOP')
      RETURN
      END
C  /* Deck twodsa */
      SUBROUTINE TWODSA(WORK,LWORK,FMAT,DMAT,NDMAT,GMAT,MAXDER,EXPECT,
     &                  SUSCEP,UNDIFF,DDFOCK,DIRFCK,SOFOCK,DISTRI,
     &                  LONDON,SPNORB,PERTUR,IATOM,MULE,MULTE,
     &                  NODV,NOPV,NOCONT,
     &                  THRESH,JPRINT,IPRNTA,IPRNTB,IPRNTC,IPRNTD,RETUR,
     &                  SQ12EL,INDHER,INDHSQ,IODDHR,IREPDM,IFCTYP,ISHLA,
     &                  ADISTR,I2TYP,RELCAL,GENCNT)
C
#include "implicit.h"
#include "priunit.h"
#include "maxaqn.h"
#include "mxcent.h"
#include "aovec.h"
#include "maxorb.h"
      PARAMETER (LUPAS = 27, LUPAO = 29)
      PARAMETER (LBUF = 600)
      LOGICAL PRINTA, PRINTB, PRINTC, PRINTD, NOPV, NODV, PERTUR,
     &        EXPECT, UNDIFF, DDFOCK, DIRFCK, DISTRI, NOCONT, SPNORB,
     &        RETUR, FIRST, SQ12EL, LONDON, SUSCEP, ADISTR, DOINDX,
     &        SOFOCK, RELCAL, GENCNT
      DIMENSION DMAT(*), FMAT(*), GMAT(*), IREPDM(*), IFCTYP(*),
     &        INDHSQ(*), IODDHR(*), INDHER(*), WORK(LWORK)
#include "cbisol.h"
#include "twocom.h"
#include "nuclei.h"
#ifdef PRG_DIRAC
#include "dcbgrd.h"
#else
#include "energy.h"
#endif
#include "taymol.h"
#include "taysol.h"
#include "suscpt.h"
#include "inforb.h"
#include "blocks.h"
#include "symmet.h"
#include "disbuf.h"
C
      CALL QENTER('TWODSA')
#include "memint.h"
      IF (JPRINT .GT. 5) CALL TITLER('Output from TWODSA','*',103)
C
      FIRST  = .TRUE.
      DIRAC = RELCAL
      IF(I2TYP.EQ.0) THEN
        IBSTRT = 1
        ICSTRT = 1
        IDSTRT = 1
        IASMAX = ISHLA
        IBSMAX = MAXSHL
        ICSMAX = MAXSHL
        IDSMAX = MAXSHL
      ELSEIF(I2TYP.EQ.1) THEN
        IBSTRT = 1
        ICSTRT = 1
        IDSTRT = 1
        IASMAX = ISHLA
        IBSMAX = NLRGBL
        ICSMAX = NLRGBL
        IDSMAX = NLRGBL
      ELSEIF(I2TYP.EQ.2) THEN
        IBSTRT = NLRGBL+1
        ICSTRT = 1
        IDSTRT = 1
        IASMAX = ISHLA
        IBSMAX = MAXSHL
        ICSMAX = NLRGBL
        IDSMAX = NLRGBL
      ELSEIF(I2TYP.EQ.3) THEN
        IBSTRT = NLRGBL+1
        ICSTRT = NLRGBL+1
        IDSTRT = NLRGBL+1
        IASMAX = ISHLA
        IBSMAX = MAXSHL
        ICSMAX = MAXSHL
        IDSMAX = MAXSHL
      ELSE
        WRITE(LUPRI,'(A,I5)') 'TWODSA: Unknown I2TYP =' ,I2TYP
      ENDIF
C
C     Allocation of memory for integral buffers.
C     Addresses are save in COMMON /DISBUF/
C
      DOINDX = .FALSE.
      CALL AINDEX(ISHLA,NDIST,IDUM,DOINDX,IPRINT)
      LDSBUF = LBUF
      CALL MEMGET('REAL',KDSBUF,  NDIST*LDSBUF,WORK,KFREE,LFREE)
      CALL MEMGET('INTE',KDSIBF,2*NDIST*LDSBUF,WORK,KFREE,LFREE)
      CALL MEMGET('INTE',KDSCNT,NDIST         ,WORK,KFREE,LFREE)
      CALL MEMGET('INTE',KDSORB,NDIST         ,WORK,KFREE,LFREE)
      CALL MEMGET('INTE',KORBDS,NBASIS        ,WORK,KFREE,LFREE)
C
C     *****************************
C     ***** First Shell Index *****
C     *****************************
C
      ISHELA = ISHLA
C
      NHKTA  = NHKTSH(ISHELA)
      KHKTA  = KHKTSH(ISHELA)
      KCKTA  = KCKTSH(ISHELA)
      SPHRA  = SPHRSH(ISHELA)
      NCENTA = NCNTSH(ISHELA)
      MULA   = ISTBSH(ISHELA)
      MULTA  = MULT(MULA)
      NSTRA  = IORBSB(IORBSH(ISHELA,1))
      NUCA   = NUCOSH(ISHELA)
      NORBA  = NORBSH(ISHELA)
      CORAX0 = CENTSH(ISHELA,1)
      CORAY0 = CENTSH(ISHELA,2)
      CORAZ0 = CENTSH(ISHELA,3)
      PRINTA = .TRUE.
      IF ((ISHELA .NE. IPRNTA).AND.(IPRNTA .NE. 0)) PRINTA = .FALSE.
C
C     ******************************
C     ***** Second Shell Index *****
C     ******************************
C
         DO 200 ISHELB = IBSTRT,IBSMAX
         NHKTB  = NHKTSH(ISHELB)
         KHKTB  = KHKTSH(ISHELB)
         KCKTB  = KCKTSH(ISHELB)
         SPHRB  = SPHRSH(ISHELB)
         NCENTB = NCNTSH(ISHELB)
         MULB   = ISTBSH(ISHELB)
         MULTB  = MULT(MULB)
         NSTRB  = IORBSB(IORBSH(ISHELB,1))
         NUCB   = NUCOSH(ISHELB)
         NORBB  = NORBSH(ISHELB)
         CORBX0 = CENTSH(ISHELB,1)
         CORBY0 = CENTSH(ISHELB,2)
         CORBZ0 = CENTSH(ISHELB,3)
         GENAB  = .NOT.(SEGMSH(ISHELA) .AND. SEGMSH(ISHELB))
         IGENAB = 1
         IF (.NOT.GENAB) IGENAB = 2
         NSETA  = NSETSH(ISHELA,IGENAB)
         NSETB  = NSETSH(ISHELB,IGENAB)
         PRINTB = PRINTA
         IF ((ISHELB.NE.IPRNTB).AND.(IPRNTB.NE.0)) PRINTB = .FALSE.
         IF (PRINTB) THEN
            IPRINT = JPRINT
         ELSE
            IPRINT = 0
         END IF
C
C        *****************************
C        ***** Third Shell Index *****
C        *****************************
C
         DO 300 ISHELC = ICSTRT,ICSMAX
            NHKTC  = NHKTSH(ISHELC)
            KHKTC  = KHKTSH(ISHELC)
            KCKTC  = KCKTSH(ISHELC)
            SPHRC  = SPHRSH(ISHELC)
            NCENTC = NCNTSH(ISHELC)
            MULC   = ISTBSH(ISHELC)
            MULTC  = MULT(MULC)
            NSTRC  = IORBSB(IORBSH(ISHELC,1))
            NUCC   = NUCOSH(ISHELC)
            NORBC  = NORBSH(ISHELC)
            CORCX0 = CENTSH(ISHELC,1)
            CORCY0 = CENTSH(ISHELC,2)
            CORCZ0 = CENTSH(ISHELC,3)
            PRINTC = PRINTB
            IF ((ISHELC.NE.IPRNTC).AND.(IPRNTC.NE.0)) PRINTC=.FALSE.
C
C           ******************************
C           ***** Fourth Shell Index *****
C           ******************************
C
            ICMAX = ISHELC
            IF (SPNORB) ICMAX = MAXSHL
            DO 400 ISHELD = IDSTRT, ICMAX
               NHKTD  = NHKTSH(ISHELD)
               KHKTD  = KHKTSH(ISHELD)
               KCKTD  = KCKTSH(ISHELD)
               SPHRD  = SPHRSH(ISHELD)
               NCENTD = NCNTSH(ISHELD)
               MULD   = ISTBSH(ISHELD)
               MULTD  = MULT(MULD)
               NSTRD  = IORBSB(IORBSH(ISHELD,1))
               NUCD   = NUCOSH(ISHELD)
               NORBD  = NORBSH(ISHELD)
               CORDX0 = CENTSH(ISHELD,1)
               CORDY0 = CENTSH(ISHELD,2)
               CORDZ0 = CENTSH(ISHELD,3)
               GENCD = .NOT.(SEGMSH(ISHELC) .AND. SEGMSH(ISHELD))
               IGENCD = 1
               IF (.NOT.GENCD) IGENCD = 2
               NSETC = NSETSH(ISHELC,IGENCD)
               NSETD = NSETSH(ISHELD,IGENCD)
               PRINTD = PRINTC
               IF ((ISHELD .NE. IPRNTD).AND.(IPRNTD .NE. 0))
     &            PRINTD = .FALSE.
               IF (PRINTD) THEN
                  IPRINT = JPRINT
               ELSE
                  IPRINT = 0
               END IF
C
               SHAEQB = .FALSE.
               SHCEQD = ISHELC .EQ. ISHELD
               SHABAB = .FALSE.
C
C              *******************************
C              ***** Calculate integrals *****
C              *******************************
C
               CALL TWOODS(FMAT,DMAT,NDMAT,GMAT,WORK(KFREE),LFREE,
     &                     UNDIFF,
     &                     PERTUR,LONDON,SPNORB,EXPECT,SUSCEP,DDFOCK,
     &                     DIRFCK,SOFOCK,DISTRI,IATOM,MULE,MULTE,
     &                     MAXDER,NOCONT,NODV,NOPV,THRESH,IPRINT,FIRST,
     &                     SQ12EL,INDHSQ,IODDHR,INDHER,IFCTYP,ADISTR,
     &                     WORK(KDSBUF),IDUM,DUM,
     &                     DUM,DUM,DUM,IDUM,IDUM,IDUM,GENCNT)
C
               IF (RETUR) THEN
                  IF (ISHELA .EQ. IPRNTA .AND.
     &                ISHELB .EQ. IPRNTB .AND.
     &                ISHELC .EQ. IPRNTC .AND.
     &                ISHELD .EQ. IPRNTD) GOTO 999
               END IF
  400       CONTINUE
  300    CONTINUE
  200 CONTINUE
  999 CONTINUE
      CALL MEMREL('TWODSA',WORK,KWORK,KWORK,KFREE,LFREE)
      CALL QEXIT('TWODSA')
      RETURN
      END
C  /* Deck twodis */
      SUBROUTINE TWODIS(WORK,LWORK,FMAT,DMAT,NDMAT,GMAT,INDX,INDXAB,
     &                GABRAO,DMRAO,DINTSKP,SCREEN,
     &                MAXDER,EXPECT,SUSCEP,UNDIFF,DDFOCK,DIRFCK,SOFOCK,
     &                DISTRI,LONDON,SPNORB,PERTUR,IATOM,MULE,MULTE,
     &                NODV,NOPV,NOCONT,THRESH,JPRINT,IPRNTA,IPRNTB,
     &                IPRNTC,IPRNTD,SQ12EL,
     &                INDHER,INDHSQ,IODDHR,IFCTYP,ADISTR,I2TYP,
     &                RELCAL,GENCNT)
C
#include "implicit.h"
#include "priunit.h"
#include "mxcent.h"
#include "maxorb.h"
#include "aovec.h"
#include "maxaqn.h"
      LOGICAL NOPV, NODV, PERTUR,
     &        EXPECT, UNDIFF, DDFOCK, DIRFCK, NOCONT, SPNORB, FIRST,
     &        DISTRI, SQ12EL, LONDON, SUSCEP, ADISTR, SOFOCK
     &        RELCAL, GENCNT
      DIMENSION DMAT(*), FMAT(*), GMAT(*), IFCTYP(*),
     &      GABRAO(*),DMRAO(NSYMBL,NSYMBL,*),DINTSKP(*),
     &      INDX(2,*), INDXAB(*), INDHSQ(*), IODDHR(*), WORK(LWORK)
#include "blocks.h"
#include "twocom.h"
#include "inforb.h"
#include "symmet.h"
#ifdef PRG_DIRAC
#include "dcbham.h"
#endif
#include "comdis.h"
C
      CALL QENTER('TWODIS')
      IF (JPRINT .GT. 5) CALL TITLER('Output from TWODIS','*',103)
C
      ISHELA = ISHLA
      ISHELB = ISHLB
C
C     First Shell Index
C     =================
C
      ICA    = LCLASH(ISHELA)
C
      NHKTA  = NHKTSH(ISHELA)
      KHKTA  = KHKTSH(ISHELA)
      KCKTA  = KCKTSH(ISHELA)
      SPHRA  = SPHRSH(ISHELA)
      NCENTA = NCNTSH(ISHELA)
      MULA   = ISTBSH(ISHELA)
      MULTA  = MULT(MULA)
      NSTRA  = IORBSB(IORBSH(ISHELA,1))
      NUCA   = NUCOSH(ISHELA)
      NORBA  = NORBSH(ISHELA)
      CORAX0 = CENTSH(ISHELA,1)
      CORAY0 = CENTSH(ISHELA,2)
      CORAZ0 = CENTSH(ISHELA,3)
C
C     Second Shell Index
C     ==================
C
      ICB    = LCLASH(ISHELB)
C
      NHKTB  = NHKTSH(ISHELB)
      KHKTB  = KHKTSH(ISHELB)
      KCKTB  = KCKTSH(ISHELB)
      SPHRB  = SPHRSH(ISHELB)
      NCENTB = NCNTSH(ISHELB)
      MULB   = ISTBSH(ISHELB)
      MULTB  = MULT(MULB)
      NSTRB  = IORBSB(IORBSH(ISHELB,1))
      NUCB   = NUCOSH(ISHELB)
      NORBB  = NORBSH(ISHELB)
      CORBX0 = CENTSH(ISHELB,1)
      CORBY0 = CENTSH(ISHELB,2)
      CORBZ0 = CENTSH(ISHELB,3)
      GENAB  = .NOT.(SEGMSH(ISHELA) .AND. SEGMSH(ISHELB))
      IGENAB = 1
      IF (.NOT.GENAB) IGENAB = 2
      NSETA  = NSETSH(ISHELA,IGENAB)
      NSETB  = NSETSH(ISHELB,IGENAB)
      SHAEQB = ISHELA .EQ. ISHELB
      DIAGAB = SHAEQB
C
C     Skip two-center SS contributions if requested
C     This test is provisory, in SYMLOP we take out more integrals
C     in case of symmetry-degenerate nuclei. Testing at this place,
C     will, however, take out the work in ODCVEC and EXCOEF that
C     otherwise would cause a quartic scaling term.
C
      IF (ONECAP) THEN
         IF (NCENTA.NE.NCENTB.AND.ICA.EQ.2.AND.ICB.EQ.2) GO TO 999
      ENDIF
C
      CALL DISLOP(GMAT,FMAT,DMAT,NDMAT,GABRAO,DMRAO,DINTSKP,SCREEN,
     &            WORK,LWORK,MAXDER,EXPECT,
     &            SUSCEP,UNDIFF,DDFOCK,DIRFCK,SOFOCK,
     &            DISTRI,LONDON,SPNORB,
     &            PERTUR,IATOM,MULE,MULTE,NODV,NOPV,NOCONT,THRESH,
     &            JPRINT,IPRNTA,IPRNTB,IPRNTC,IPRNTD,SQ12EL,INDHSQ,
     &            IODDHR,INDHER,IFCTYP,ADISTR,I2TYP,INDX,INDXAB,
     &            GENCNT)
C
 999  CONTINUE
      CALL QEXIT('TWODIS')
      RETURN
      END
C  /* Deck dislop */
      SUBROUTINE DISLOP(GMAT,FMAT,DMAT,NDMAT,GABRAO,DMRAO,DINTSKP,
     &                  SCREEN,WORK,LWORK,MAXDER,EXPECT,
     &                  SUSCEP,UNDIFF,DDFOCK,DIRFCK,SOFOCK,
     &                  DISTRI,LONDON,SPNORB,PERTUR,IATOM,MULE,MULTE,
     &                  NODV,NOPV,NOCONT,
     &                  THRESH,JPRINT,IPRNTA,IPRNTB,IPRNTC,IPRNTD,
     &                  SQ12EL,INDHSQ,IODDHR,INDHER,IFCTYP,ADISTR,
     &                  I2TYP,INDX,INDXAB,GENCNT)
C
#include "implicit.h"
#include "priunit.h"
      PARAMETER(D0=0.0D0)
#include "maxaqn.h"
#include "mxcent.h"
#include "aovec.h"
#include "maxorb.h"
      LOGICAL PRINTA, PRINTB, PRINTC, PRINTD, NOPV, NODV, PERTUR,
     &        EXPECT, UNDIFF, DDFOCK, DIRFCK, NOCONT, SPNORB, FIRST,
     &        SQ12EL, DISTRI, LONDON, SUSCEP, ADISTR, SOFOCK, GENCNT
      DIMENSION GMAT(*), DMAT(*), FMAT(*), IFCTYP(*), INDX(2,*),
     &          GABRAO(*),DMRAO(*),DINTSKP(*),
     &          INDXAB(*), INDHSQ(*), IODDHR(*), INDHER(*), WORK(LWORK)
      DIMENSION IDIS(2,2,2,2)
      DATA IDIS/1,5,5,2,5,4,4,5,5,4,4,5,2,5,5,3/
      SAVE IDIS
#include "twocom.h"
#include "nuclei.h"
#ifdef PRG_DIRAC
#include "dcbgrd.h"
#include "dcbham.h"
#else
#include "energy.h"
#endif
#include "taymol.h"
#include "inforb.h"
#include "blocks.h"
#include "symmet.h"
C
      CALL QENTER('DISLOP')
      IF (JPRINT .GT. 5) CALL TITLER('Output from DISLOP','*',103)
C
      FIRST = .TRUE.
C
      PRINTA = .TRUE.
      IF ((ISHELA .NE. IPRNTA).AND.(IPRNTA .NE. 0)) PRINTA = .FALSE.
      PRINTB = PRINTA
      IF ((ISHELB.NE.IPRNTB).AND.(IPRNTB.NE.0)) PRINTB = .FALSE.
      IF (PRINTB) THEN
         IPRINT = JPRINT
      ELSE
         IPRINT = 0
      END IF
      IF(I2TYP.EQ.0) THEN
        ICSTRT = 1
        IDSTRT = 1
        ICSMAX = MAXSHL
        IDSMAX = MAXSHL
      ELSEIF(I2TYP.EQ.1) THEN
        ICSTRT = 1
        IDSTRT = 1
        ICSMAX = NLRGBL
        IDSMAX = NLRGBL
      ELSEIF(I2TYP.EQ.2) THEN
        ICSTRT = NLRGBL+1
        IDSTRT = NLRGBL+1
        ICSMAX = MAXSHL
        IDSMAX = MAXSHL
      ELSEIF(I2TYP.EQ.12) THEN
        ICSTRT = 1
        IDSTRT = 1
        ICSMAX = MAXSHL
        IDSMAX = MAXSHL
      ELSEIF(I2TYP.EQ.4) THEN
        ICSTRT = NLRGBL+1
        IDSTRT = 1
        ICSMAX = MAXSHL
        IDSMAX = NLRGBL
      ELSE
        WRITE(LUPRI,'(A,I5)') 'DISLOP: Unknown I2TYP =' ,I2TYP
      ENDIF
C
C     Initialize screening
C     ********************
C
      ICA = LCLASH(ISHELA)
      ICB = LCLASH(ISHELB)
      DOSCRN = .FALSE.
      IF(SCREEN.GT.D0) THEN
        DOSCRN = .TRUE.
        SCRTHR = SCREEN
      ENDIF
C     *****************************
C     ***** Third Shell Index *****
C     *****************************
C
      DO 100 ISHELC = ICSTRT, ICSMAX
         ICC    = LCLASH(ISHELC)
         NHKTC  = NHKTSH(ISHELC)
         KHKTC  = KHKTSH(ISHELC)
         KCKTC  = KCKTSH(ISHELC)
         SPHRC  = SPHRSH(ISHELC)
         NCENTC = NCNTSH(ISHELC)
         MULC   = ISTBSH(ISHELC)
         MULTC  = MULT(MULC)
         NSTRC  = IORBSB(IORBSH(ISHELC,1))
         NUCC   = NUCOSH(ISHELC)
         NORBC  = NORBSH(ISHELC)
         CORCX0 = CENTSH(ISHELC,1)
         CORCY0 = CENTSH(ISHELC,2)
         CORCZ0 = CENTSH(ISHELC,3)
         PRINTC = PRINTB
         IF ((ISHELC.NE.IPRNTC).AND.(IPRNTC.NE.0)) PRINTC=.FALSE.
C
C        ******************************
C        ***** Fourth Shell Index *****
C        ******************************
C
         IDSMAX1 = ISHELC
         IDSTRT1 = IDSTRT
         IF ((I2TYP.EQ.12).AND.(ISHELC.GT.NLRGBL))
     &      IDSTRT1 = NLRGBL + 1
         IF (I2TYP.EQ.4)
     &      IDSMAX1 = NLRGBL
         DO 200 ISHELD = IDSTRT1, IDSMAX1
            ICD    = LCLASH(ISHELD)
            NHKTD  = NHKTSH(ISHELD)
            KHKTD  = KHKTSH(ISHELD)
            KCKTD  = KCKTSH(ISHELD)
            SPHRD  = SPHRSH(ISHELD)
            NCENTD = NCNTSH(ISHELD)
            MULD   = ISTBSH(ISHELD)
            MULTD  = MULT(MULD)
            NSTRD  = IORBSB(IORBSH(ISHELD,1))
            NUCD   = NUCOSH(ISHELD)
            NORBD  = NORBSH(ISHELD)
            CORDX0 = CENTSH(ISHELD,1)
            CORDY0 = CENTSH(ISHELD,2)
            CORDZ0 = CENTSH(ISHELD,3)
            JDIS = IDIS(ICA,ICB,ICC,ICD)
            GENCD = .NOT.(SEGMSH(ISHELC) .AND. SEGMSH(ISHELD))
            IGENCD = 1
            IF (.NOT.GENCD) IGENCD = 2
            NSETC = NSETSH(ISHELC,IGENCD)
            NSETD = NSETSH(ISHELD,IGENCD)
            SHCEQD = ISHELC .EQ. ISHELD
            SHABAB = (ISHELA.EQ.ISHELC) .AND. (ISHELB.EQ.ISHELD)
            PRINTD = PRINTC
            IF ((ISHELD .NE. IPRNTD).AND.(IPRNTD .NE. 0))
     &         PRINTD = .FALSE.
            IF (PRINTD) THEN
               IPRINT = JPRINT
            ELSE
               IPRINT = 0
            END IF
            IF (ONECAP) THEN
               IF (NCENTC.NE.NCENTD.AND.ICC.EQ.2.AND.ICD.EQ.2) GO TO 200
            ENDIF
C
C           *******************************
C           ***** Calculate integrals *****
C           *******************************
C
            CALL TWOODS(FMAT,DMAT,NDMAT,GMAT,WORK,LWORK,UNDIFF,PERTUR,
     &                  LONDON,SPNORB,EXPECT,SUSCEP,DDFOCK,DIRFCK,
     &                  SOFOCK,DISTRI,IATOM,MULE,MULTE,MAXDER,NOCONT,
     &                  NODV,NOPV,THRESH,IPRINT,FIRST,SQ12EL,INDHSQ,
     &                  IODDHR,INDHER,IFCTYP,ADISTR,DUM,IDUM,
     &                  DINTSKP,GABRAO,DMRAO,DUM,JDIS,INDX,INDXAB,
     &                  GENCNT)
  200    CONTINUE
  100 CONTINUE
 999  CONTINUE
      CALL QEXIT('DISLOP')
      RETURN
      END
C  /* Deck twoods */
      SUBROUTINE TWOODS(FMAT,DMAT,NDMAT,GMAT,WORK,LWORK,UNDIFF,PERTUR,
     &                  LONDON,SPNORB,EXPECT,SUSCEP,DDFOCK,DIRFCK,
     &                  SOFOCK,DISTRI,IATOM,MULE,MULTE,MAXDER,NOCONT,
     &                  NODV,NOPV,THRESH,IPRINT,FIRST,SQ12EL,INDHSQ,
     &                  IODDHR,INDHER,IFCTYP,ADISTR,WRKBUF,ICEDIF,
     &                  DINTSKP,GABRAO,DMRAO,DMRSO,IREPDM,INDX,INDXAB,
     &                  GENCNT)
#include "implicit.h"
#include "priunit.h"
#include "aovec.h"
#include "maxorb.h"
#include "maxaqn.h"
#include "mxcent.h"
      PARAMETER (LUPAS = 27, LUPAO = 29)
      LOGICAL NOPV, NODV, PERTUR, EXPECT, UNDIFF, NOCONT, SPNORB, FIRST,
     &        DDFOCK, DIRFCK, DISTRI, SQ12EL, LONDON, SUSCEP, ADISTR,
     &        SOFOCK, GENCNT
      DIMENSION DMAT(*), FMAT(*), GMAT(*), IFCTYP(*), INDX(2,*),
     &          INDXAB(*), INDHSQ(*), IODDHR(*), INDHER(*), WRKBUF(*), 
     &          GABRAO(*),DMRAO(*),DMRSO(*),DINTSKP(*),IREPDM(*),
     &          WORK(LWORK)
#include "symmet.h"
#include "twocom.h"
#include "blocks.h"
#include "twosta.h"
C
      CALL QENTER('TWOODS')
#include "memint.h"
      IF (IPRINT .GT. 5) THEN
         CALL TITLER('Output from TWOODS','*',103)
         WRITE (LUPRI,'(/2X,A,4I3)')
     &      'Shell quadruplet: ',ISHELA,ISHELB,ISHELC,ISHELD
      END IF
      JMAXA  = NHKTA - 1 + MAXDER
      JMAXB  = NHKTB - 1 + MAXDER
      JMAXC  = NHKTC - 1 + MAXDER
      JMAXD  = NHKTD - 1 + MAXDER
      IF (LONDON) JMAXB = NHKTB - 1
      IF (LONDON) JMAXD = NHKTD - 1
      MAXAB  = NHKTA + NHKTB - 2
      MAXCD  = NHKTC + NHKTD - 2
      TCONAB = SHAEQB .AND. MAXAB .EQ. 0
      TCONCD = SHCEQD .AND. MAXCD .EQ. 0
      DIAGAB = SHAEQB
      DIAGCD = SHCEQD
C     DIAGAB = SHAEQB .AND. .NOT.BIGVEC
C     DIAGCD = SHCEQD .AND. .NOT.BIGVEC
C aug2000: BIGVEC removed because obsolete
      SPHRAB = SPHRA .OR. SPHRB
      SPHRCD = SPHRC .OR. SPHRD
      DIACAB = DIAGAB .AND. .NOT.SPHRAB
      DIACCD = DIAGCD .AND. .NOT.SPHRCD
C
C     Number of two-electron densities elements
C
      IF ((EXPECT .OR. SUSCEP) .AND..NOT.NOPV) THEN
         READ (LUPAO) NPMAT
         IF (SUSCEP) THEN
            READ (LUPAS) NPMATA
            IF (NPMAT .NE. NPMATA) THEN
               WRITE (LUPRI,'(1X,A,I5,A,I5)')
     &         ' Error in TWOODS: NPMAT = ',NPMAT,', NPMATA = ',NPMATA
               CALL QUIT('Program aborted due to error in TWOODS')
            END IF
         ELSE
            NPMATA = 0
         END IF
      ELSE
         NPMAT  = 0
         NPMATA = 0
      END IF
C
      NODCAB = NODSYM(MAXOPR,MULA,MULB)
      NODCCD = NODSYM(MAXOPR,MULC,MULD)
      KCKMAX = MAX(KCKTA,KCKTB,KCKTC,KCKTD)
C
!radovan: these memgets are easily called 25 million times
!         if somebody modifies the code
!         please allocate buffers further upstream
!miro: I have replaced some of them with MEMGET2 to track response-magnetizability bug ifort-parallel
      CALL MEMGET2('REAL','KPSO',KPSO,NPMAT,WORK,KFREE,LFREE) ! 1
      CALL MEMGET2('REAL','KPSA',KPSA,NPMATA,WORK,KFREE,LFREE)
      CALL MEMGET2('INTE','KNPCOA',KNPCOA,2*NSETA*(NODCAB + 1),
     &              WORK,KFREE,LFREE)
      CALL MEMGET2('INTE','KNPCOB',KNPCOB,2*NSETB*(NODCAB + 1),
     &              WORK,KFREE,LFREE)
      CALL MEMGET2('INTE','KNPCOC',KNPCOC,2*NSETC*(NODCCD + 1),
     &              WORK,KFREE,LFREE)
      CALL MEMGET2('INTE','KNPCOD',KNPCOD,2*NSETD*(NODCCD + 1),
     &              WORK,KFREE,LFREE)
      CALL MEMGET2('INTE','KJSTRA',KJSTRA,NSETA,WORK,KFREE,LFREE)
      CALL MEMGET2('INTE','KJSTRB',KJSTRB,NSETB,WORK,KFREE,LFREE)
      CALL MEMGET2('INTE','KJSTRC',KJSTRC,NSETC,WORK,KFREE,LFREE)
      CALL MEMGET2('INTE','KJSTRD',KJSTRD,NSETD,WORK,KFREE,LFREE) ! 10
C
      LUUAB = NUCA*NUCB*NODCAB
      LUUCD = NUCC*NUCD*NODCCD
      CALL MEMGET2('REAL','KCORAB',KCORAB,9*LUUAB,WORK,KFREE,LFREE) ! 11
      CALL MEMGET2('REAL','KCORCD',KCORCD,9*LUUCD,WORK,KFREE,LFREE)
      CALL MEMGET2('REAL','KEXPAB',KEXPAB,3*LUUAB,WORK,KFREE,LFREE)
      CALL MEMGET2('REAL','KEXPCD',KEXPCD,3*LUUCD,WORK,KFREE,LFREE)
      CALL MEMGET2('REAL','KFACAB',KFACAB,  LUUAB,WORK,KFREE,LFREE)
      CALL MEMGET2('REAL','KFACCD',KFACCD,  LUUCD,WORK,KFREE,LFREE)
      CALL MEMGET2('INTE','KLMNVL',KLMNVL,20*KCKMAX,WORK,KFREE,LFREE) ! 17
C
      IF (GENAB) THEN
         LCONTA = 2*NORBA*NUCA*NODCAB
         LCONTB = 2*NORBB*NUCB*NODCAB
         LPNTAB = 2*LUUAB
         LREDAB = NORBA*NORBB
         LNCSAB = 0
      ELSE
         LCONTA = 0
         LCONTB = 0
         LPNTAB = 0
         LREDAB = 0
         LNCSAB = NORBA*NORBB*NODCAB
      END IF
      CALL MEMGET2('REAL','KCONTA',KCONTA,LCONTA,WORK,KFREE,LFREE)
      CALL MEMGET2('REAL','KCONTB',KCONTB,LCONTB,WORK,KFREE,LFREE)
      CALL MEMGET2('INTE','KPNTAB',KPNTAB,LPNTAB,WORK,KFREE,LFREE)
      CALL MEMGET2('INTE','KREDAB',KREDAB,LREDAB,WORK,KFREE,LFREE)
      CALL MEMGET2('INTE','KNCSAB',KNCSAB,LNCSAB,WORK,KFREE,LFREE)
C
      IF (GENCD) THEN
         LCONTC = 2*NORBC*NUCC*NODCCD
         LCONTD = 2*NORBD*NUCD*NODCCD
         LPNTCD = 2*LUUCD
         LREDCD = NORBC*NORBD
         LNCSCD = 0
      ELSE
         LCONTC = 0
         LCONTD = 0
         LPNTCD = 0
         LREDCD = 0
         LNCSCD = 0
         LNCSCD = NORBC*NORBD*NODCCD
      END IF
      CALL MEMGET2('REAL','KCONTC',KCONTC,LCONTC,WORK,KFREE,LFREE)
      CALL MEMGET2('REAL','KCONTD',KCONTD,LCONTD,WORK,KFREE,LFREE)
      CALL MEMGET2('INTE','KPNTCD',KPNTCD,LPNTCD,WORK,KFREE,LFREE)
      CALL MEMGET2('INTE','KREDCD',KREDCD,LREDCD,WORK,KFREE,LFREE)
      CALL MEMGET2('INTE','KNCSCD',KNCSCD,LNCSCD,WORK,KFREE,LFREE)
      CALL MEMGET2('INTE','KINDAB',KINDAB,2*NORBA*NORBB,
     &             WORK,KFREE,LFREE)
      CALL MEMGET2('INTE','KINDCD',KINDCD,2*NORBC*NORBD,
     &             WORK,KFREE,LFREE)
C
      LWTOT  = LWTOT + KFREE - 1
      MWTOT  = MAX(MWTOT,LWTOT)
      CALL TWOOD1(FMAT,DMAT,NDMAT,GMAT,WORK(KFREE),LFREE,WORK(KPSO),
     &            WORK(KPSA),NPMAT,WORK(KCORAB),WORK(KCORCD),
     &            WORK(KEXPAB),WORK(KEXPCD),WORK(KFACAB),WORK(KFACCD),
     &            WORK(KCONTA),WORK(KCONTB),WORK(KCONTC),WORK(KCONTD),
     &            UNDIFF,PERTUR,LONDON,SPNORB,EXPECT,SUSCEP,DDFOCK,
     &            DIRFCK,SOFOCK,DISTRI,IATOM,MULE,MULTE,MAXDER,
     &            NOCONT,NODV,NOPV,THRESH,IPRINT,FIRST,SQ12EL,
     &            WORK(KNPCOA),WORK(KNPCOB),WORK(KNPCOC),WORK(KNPCOD),
     &            WORK(KNCSAB),WORK(KNCSCD),WORK(KJSTRA),WORK(KJSTRB),
     &            WORK(KJSTRC),WORK(KJSTRD),WORK(KINDAB),WORK(KINDCD),
     &            INDHSQ,IODDHR,INDHER,WORK(KLMNVL),
     &            WORK(KPNTAB),WORK(KPNTCD),WORK(KREDAB),WORK(KREDCD),
     &            IFCTYP,ADISTR,WRKBUF,GABRAO,DMRAO,DMRSO,
     &            DINTSKP,IREPDM,INDX,INDXAB,GENCNT)
      LWTOT  = LWTOT - KFREE + 1
 999  CONTINUE
      ! miro: an error occurs here for mpi=2,ifort optimized !
      CALL MEMREL('TWOODS',WORK,KWORK,KWORK,KFREE,LFREE)
      CALL QEXIT('TWOODS')
      RETURN
      END
C  /* Deck twood1 */
      SUBROUTINE TWOOD1(FMAT,DMAT,NDMAT,GMAT,WORK,LWORK,PSO,PSA,NPMAT,
     &                  COORAB,COORCD,EXPAB,EXPCD,FACAB,FACCD,CONTA,
     &                  CONTB,CONTC,CONTD,UNDIFF,PERTUR,LONDON,SPNORB,
     &                  EXPECT,SUSCEP,DDFOCK,DIRFCK,SOFOCK,DISTRI,
     &                  IATOM,MULE,MULTE,MAXDER,NOCONT,NODV,NOPV,
     &                  THRESH,IPRINT,FIRST,SQ12EL,NPCOA,NPCOB,
     &                  NPCOC,NPCOD,NUCSAB,
     &                  NUCSCD,JSTRA,JSTRB,JSTRC,JSTRD,NINDAB,NINDCD,
     &                  INDHSQ,IODDHR,INDHER,LMNVLS,NPNTAB,NPNTCD,
     &                  NREDAB,NREDCD,IFCTYP,ADISTR,WRKBUF,
     &                  GABRAO,DMRAO,DMRSO,DINTSKP,IREPDM,INDX,INDXAB,
     &                  GENCNT)
#include "implicit.h"
#include "priunit.h"
#include "maxaqn.h"
#include "mxcent.h"
#include "aovec.h"
#include "maxorb.h"
      PARAMETER (LUPAS = 27, LUPAO = 29)
      LOGICAL NOPV, NODV, PERTUR, EXPECT, UNDIFF, DDFOCK, DIRFCK,
     &        DISTRI, NOCONT, LONDON, SPNORB, ONECEN, FIRST, LAST,
     &        SQ12EL, SUSCEP, TPRAB, TPRCD, ADISTR, SOFOCK, GENCNT
      DIMENSION WORK(LWORK), DMAT(*), FMAT(*), GMAT(*), PSO(*), PSA(*),
     &          IFCTYP(*), INDHSQ(*), IODDHR(*), INDHER(*),
     &          CONTA(*), CONTB(*), CONTC(*), CONTD(*),
     &          NPCOA(NSETA,2,0:NODCAB), NPCOB(NSETB,2,0:NODCAB),
     &          NPCOC(NSETC,2,0:NODCCD), NPCOD(NSETD,2,0:NODCCD),
     &          JSTRA(NSETA), JSTRB(NSETB), JSTRC(NSETC), JSTRD(NSETD),
     &          COORAB(NUCA*NUCB,3,3,NODCAB),
     &          COORCD(NUCC*NUCD,3,3,NODCCD),
     &          EXPAB(NUCA*NUCB,3,NODCAB), FACAB(NUCA*NUCB,NODCAB),
     &          EXPCD(NUCC*NUCD,3,NODCCD), FACCD(NUCC*NUCD,NODCCD),
     &          NUCSAB(NORBA*NORBB,NODCAB), NUCTAB(8),
     &          NUCSCD(NORBC*NORBD,NODCCD), NUCTCD(8),
     &          NINDAB(NORBA*NORBB,2), NORTAB(8),
     &          NINDCD(NORBC*NORBD,2), NORTCD(8),
     &          LMNVLS(KCKMAX,5,4), NPNTAB(*), NPNTCD(*),
     &          NREDAB(*), NREDCD(*), WRKBUF(*),GABRAO(*),
     &          DMRAO(*),DMRSO(*),DINTSKP(*),IREPDM(*),INDX(2,*),
     &          INDXAB(*)
#include "twocom.h"
#include "blocks.h"
#include "symmet.h"
#include "dorps.h"
#include "nuclei.h"
#include "twosta.h"
C
      CALL QENTER('TWOOD1')
#include "memint.h"
      IF (IPRINT .GE. 5) CALL TITLER('Output from TWOOD1','*',103)
C
      CALL ICOPY(NSETA,NPRIMS(ISHELA,1,IGENAB),MXSHEL,NPCOA(1,1,0),1)
      CALL ICOPY(NSETA,NCONTS(ISHELA,1,IGENAB),MXSHEL,NPCOA(1,2,0),1)
      CALL ICOPY(NSETB,NPRIMS(ISHELB,1,IGENAB),MXSHEL,NPCOB(1,1,0),1)
      CALL ICOPY(NSETB,NCONTS(ISHELB,1,IGENAB),MXSHEL,NPCOB(1,2,0),1)
      CALL ICOPY(NSETC,NPRIMS(ISHELC,1,IGENCD),MXSHEL,NPCOC(1,1,0),1)
      CALL ICOPY(NSETC,NCONTS(ISHELC,1,IGENCD),MXSHEL,NPCOC(1,2,0),1)
      CALL ICOPY(NSETD,NPRIMS(ISHELD,1,IGENCD),MXSHEL,NPCOD(1,1,0),1)
      CALL ICOPY(NSETD,NCONTS(ISHELD,1,IGENCD),MXSHEL,NPCOD(1,2,0),1)
      CALL ICOPY(NSETA,JSTRSH(ISHELA,1,IGENAB),MXSHEL,JSTRA,1)
      CALL ICOPY(NSETB,JSTRSH(ISHELB,1,IGENAB),MXSHEL,JSTRB,1)
      CALL ICOPY(NSETC,JSTRSH(ISHELC,1,IGENCD),MXSHEL,JSTRC,1)
      CALL ICOPY(NSETD,JSTRSH(ISHELD,1,IGENCD),MXSHEL,JSTRD,1)
C
C     Read two-electron densities
C
      IF ((EXPECT .OR. SUSCEP) .AND. .NOT.NOPV) THEN
         READ (LUPAO) (PSO(I),I=1,NPMAT)
         IF (SUSCEP) READ (LUPAS) (PSA(I),I=1,NPMAT)
      END IF
C
C     Overlap distributions for first electron
C     ========================================
C
      TPRAB = .FALSE.
      CALL ODCVEC(COORAB,EXPAB,FACAB,CONTA,CONTB,JMAXA,JMAXB,NSETA,
     &            NSETB,NUCA,NUCB,NUCTAB,NORBA,NORBB,NPCOA,NPCOB,NUCSAB,
     &            JSTRA,JSTRB,TCONAB,TPRAB,GENAB,12,THRESH,MAXDER,
     &            MULA,MULB,NODCAB,NORTAB,NINDAB,NPNTAB,NREDAB,
     &            KHKTA,KHKTB,EXPECT,DIRFCK,WORK,LWORK,RPRIAB,RCNTAB,
     &            IPRINT)
      IF (ISUM(NODCAB,NUCTAB,1) .EQ. 0) GOTO 999
C
C     Overlap distributions for second electron
C     =========================================
C
      TPRCD = .FALSE.
      CALL ODCVEC(COORCD,EXPCD,FACCD,CONTC,CONTD,JMAXC,JMAXD,NSETC,
     &            NSETD,NUCC,NUCD,NUCTCD,NORBC,NORBD,NPCOC,NPCOD,NUCSCD,
     &            JSTRC,JSTRD,TCONCD,TPRCD,GENCD,34,THRESH,MAXDER,
     &            MULC,MULD,NODCCD,NORTCD,NINDCD,NPNTCD,NREDCD,
     &            KHKTC,KHKTD,EXPECT,DIRFCK,WORK,LWORK,RPRICD,RCNTCD,
     &            IPRINT)
      IF (ISUM(NODCCD,NUCTCD,1) .EQ. 0) GOTO 999
C
      CALL GETLMN(LMNVLS,IPRINT)
      KHKTAB = KHKTA*KHKTB
      KHKTCD = KHKTC*KHKTD
      KCKTAB = KCKTA*KCKTB
      KCKTCD = KCKTC*KCKTD
      IF (DIAGAB) KHKTAB = KHKTA*(KHKTA + 1)/2
      IF (DIAGCD) KHKTCD = KHKTC*(KHKTC + 1)/2
      IF (DIACAB) KCKTAB = KCKTA*(KCKTA + 1)/2
      IF (DIACCD) KCKTCD = KCKTC*(KCKTC + 1)/2
      NORBAB = IMXVEC(NORTAB,NODCAB)
      NORBCD = IMXVEC(NORTCD,NODCCD)
      NOABCD = NORBAB*NORBCD
C
C     Allocate work space
C
      CALL MEMGET('INTE',KCORBA,NORBA,WORK,KFREE,LFREE)
      CALL MEMGET('INTE',KCORBB,NORBB,WORK,KFREE,LFREE)
      CALL MEMGET('INTE',KCORBC,NORBC,WORK,KFREE,LFREE)
      CALL MEMGET('INTE',KCORBD,NORBD,WORK,KFREE,LFREE)
C
      IF (MAXDER .EQ. 0) THEN
         NCFTYP = 1
      ELSE IF (MAXDER .EQ. 1) THEN
         NCFTYP = 3
      ELSE IF (MAXDER .EQ. 2) THEN
         NCFTYP = 6
      END IF
      MXUCAB = IMXVEC(NUCTAB,NODCAB)
      MXUCCD = IMXVEC(NUCTCD,NODCCD)
      LCOFAB = MXUCAB*(JMAXA+JMAXB+1)*(JMAXA+1)*(JMAXB+1)*3*NCFTYP
      LCOFCD = MXUCCD*(JMAXC+JMAXD+1)*(JMAXC+1)*(JMAXD+1)*3*NCFTYP
      CALL MEMGET2('REAL','COFAB',KCOFAB,LCOFAB,WORK,KFREE,LFREE)
      CALL MEMGET2('REAL','COFCD',KCOFCD,LCOFCD,WORK,KFREE,LFREE)
C
C     Number of SO integrals
C
      IF (EXPECT .OR. DIRFCK .OR. DDFOCK) THEN
         NINTS  = 0
         NINTMX = 0
      ELSE
         CALL NINTSO(MULE,LONDON,SPNORB,UNDIFF,SOFOCK,DISTRI,SQ12EL,
     &               IPRINT)
      END IF
      NSOINT = NOABCD*NINTS
      LAST   = (ISHELA.EQ.IASMAX) .AND. (ISHELB.EQ.IBSMAX) .AND.
     &         (ISHELC.EQ.ICSMAX) .AND. (ISHELD.EQ.IDSMAX)
      IF (EXPECT .OR. DIRFCK .OR. SUSCEP .OR. DDFOCK
     &           .OR. LAST .OR. (NSOINT .GT. 0)) THEN
C
         CALL MEMGET2('REAL','SOINT',KSOINT,NSOINT,WORK,KFREE,LFREE)
         CALL MEMGET2('INTE','PNTAO',KPNTAO,  NINTMX*NOPREP,
     &      WORK,KFREE,LFREE)
         CALL MEMGET2('INTE','PNTOP',KPNTOP,3*NINTMX*NOPREP,
     &      WORK,KFREE,LFREE)
         CALL MEMGET2('INTE','PNTNO',KPNTNO,4*NINTMX*NOPREP,
     &      WORK,KFREE,LFREE)
         CALL MEMGET2('INTE','PNTRP',KPNTRP,3*NINTMX*NOPREP,
     &      WORK,KFREE,LFREE)
         CALL MEMGET2('INTE','PNTLG',KPNTLG,3*NINTMX*NOPREP,
     &      WORK,KFREE,LFREE)
         CALL MEMGET2('REAL','DNSBUF',KDNSBF,2*NDMAT,WORK,KFREE,LFREE)
C
         MWFCAB = MAX(MWFCAB,LCOFAB)
         MWFCCD = MAX(MWFCCD,LCOFCD)
         MWPSO  = MAX(MWPSO, NPMAT)
         MWSOIN = MAX(MWSOIN,NSOINT)
         LWTOT  = LWTOT + KFREE - 1
         MWTOT  = MAX(MWTOT,LWTOT)
 
         CALL MEMCHK('TWOOD1-SYMLOP',WORK,1) ! mi check

         CALL SYMLOP(WORK(KSOINT),FMAT,DMAT,NDMAT,GMAT,PSO,PSA,
     &               WORK(KFREE),LFREE,WORK(KCOFAB),WORK(KCOFCD),COORAB,
     &               COORCD,EXPAB,EXPCD,FACAB,FACCD,CONTA,CONTB,CONTC,
     &               CONTD,NSOINT,NPMAT,UNDIFF,PERTUR,LONDON,SPNORB,
     &               EXPECT,SUSCEP,DDFOCK,DIRFCK,SOFOCK,DISTRI,
     &               IATOM,MULE,MULTE,MAXDER,NOCONT,NODV,NOPV,THRESH,
     &               IPRINT,FIRST,LAST,SQ12EL,NPCOA,NPCOB,NPCOC,NPCOD,
     &               NUCSAB,NUCSCD,NINDAB,NINDCD,JSTRA,JSTRB,JSTRC,
     &               JSTRD,WORK(KCORBA),WORK(KCORBB),WORK(KCORBC),
     &               WORK(KCORBD),WORK(KPNTAO),WORK(KPNTOP),
     &               WORK(KPNTNO),WORK(KPNTRP),WORK(KPNTLG),
     &               NUCTAB,NUCTCD,INDHSQ,IODDHR,INDHER,LMNVLS,NPNTAB,
     &               NPNTCD,NREDAB,NREDCD,IFCTYP,ADISTR,WRKBUF,
     &               GABRAO,DMRAO,DMRSO,DINTSKP,WORK(KDNSBF),IREPDM,
     &               INDX,INDXAB,GENCNT)
         LWTOT = LWTOT - KFREE + 1
         CALL MEMCHK('TWOOD1 point AB',WORK,1) ! mi check
      END IF
      CALL MEMREL('TWOOD1',WORK,KWORK,KWORK,KFREE,LFREE)
 999  CONTINUE
      CALL QEXIT('TWOOD1')
      RETURN
      END
C  /* Deck symlop */
      SUBROUTINE SYMLOP(SOINT,FMAT,DMAT,NDMAT,GMAT,PSO,PSA,WORK,LWORK,
     &                  COEFAB,COEFCD,COORAB,COORCD,EXPAB,EXPCD,FACAB,
     &                  FACCD,CONTA,CONTB,CONTC,CONTD,NSOINT,NPMAT,
     &                  UNDIFF,PERTUR,LONDON,SPNORB,EXPECT,SUSCEP,
     &                  DDFOCK,DIRFCK,SOFOCK,DISTRI,IATOM,MULE,MULTE,
     &                  MAXDER,
     &                  NOCONT,NODV,NOPV,THRESH,IPRINT,FIRST,LAST,
     &                  SQ12EL,NPCOA,NPCOB,NPCOC,NPCOD,NUCSAB,NUCSCD,
     &                  NINDAB,NINDCD,JSTRA,JSTRB,JSTRC,JSTRD,ICORBA,
     &                  ICORBB,ICORBC,ICORBD,IPNTAO,IPNTOP,IPNTNO,
     &                  IPNTRP,IPNTLG,NUCTAB,NUCTCD,INDHSQ,IODDHR,
     &                  INDHER,LMNVLS,NPNTAB,NPNTCD,NREDAB,NREDCD,
     &                  IFCTYP,ADISTR,WRKBUF,
     &                  GABRAO,DMRAO,DMRSO,DINTSKP,DNSBUF,IREPDM,INDX,
     &                  INDXAB,GENCNT)
#include "implicit.h"
#include "priunit.h"
#include "maxaqn.h"
#include "mxcent.h"
#include "aovec.h"
#include "maxorb.h"
      PARAMETER (D1 = 1.0D0, D0 = 0.0D0, DP25 = 0.25D00, D2= 2.0D00)
      CHARACTER COMP(2)*1,SPDCAR*1
      LOGICAL AACDX, AACDY, AACDZ, ABCCX, ABCCY, ABCCZ, NOPV, NODV,
     &        PERTUR, EXPECT, INTS, UNDIFF, CAEQCB, CCEQCD, ABADX,
     &        ABADY,  ABADZ, DDFOCK, DIRFCK, DISTRI, NOCONT, SPNORB,
     &        ONECEN, FIRST, LAST, SQ12EL, SOP000, IPNTLG(3,*),
     &        LONDON, SUSCEP, ADISTR, SOFOCK, DOGAB,
     &        DOXSAV, DOYSAV, DOZSAV, GENCNT
      DIMENSION SOINT(NSOINT), PSO(NPMAT), PSA(NPMAT), WORK(LWORK),
     &          DMAT(*), IFCTYP(*),
     &          INDHSQ(*), IODDHR(*), INDHER(*), FMAT(*), GMAT(*),
     &          CONTA(NORBA*NUCA,2,NODCAB), CONTB(NORBB*NUCB,2,NODCAB),
     &          CONTC(NORBC*NUCC,2,NODCCD), CONTD(NORBD*NUCD,2,NODCCD),
     &          NPCOA(NSETA,2,0:NODCAB), NPCOB(NSETB,2,0:NODCAB),
     &          NPCOC(NSETC,2,0:NODCCD), NPCOD(NSETD,2,0:NODCCD),
     &          JSTRA(NSETA), JSTRB(NSETB), JSTRC(NSETC), JSTRD(NSETD),
     &          ICORBA(NORBA),ICORBB(NORBB),ICORBC(NORBC),ICORBD(NORBD),
     &          IPNTAO(*), IPNTOP(3,*), IPNTNO(4,*), IPNTRP(3,*),
     &          COORAB(NUCA*NUCB,3,3,NODCAB),
     &          COORCD(NUCC*NUCD,3,3,NODCCD),
     &          EXPAB(NUCA*NUCB,3,NODCAB), FACAB(NUCA*NUCB,NODCAB),
     &          EXPCD(NUCC*NUCD,3,NODCCD), FACCD(NUCC*NUCD,NODCCD),
     &          NUCSAB(NORBA*NORBB,NODCAB), NUCTAB(8),
     &          NUCSCD(NORBC*NORBD,NODCCD), NUCTCD(8), SIGNT(3),
     &          NINDAB(*), NINDCD(*), LMNVLS(*),
     &          NPNTAB(NUCA*NUCB,2,NODCAB), NPNTCD(NUCC*NUCD,2,NODCCD),
     &          NREDAB(*), NREDCD(*), WRKBUF(*),
     &          IEFFB(0:7), IEFFC(0:7), IEFFD(0:7),
     &          GABRAO(NSYMBL,NSYMBL,0:7),DMRAO(NSYMBL,NSYMBL,*),
     &          DMRSO(*),DNSBUF(2,NDMAT),DINTSKP(2,*),IREPDM(*),
     &          INDX(2,*),INDXAB(*)
CMI ... added missing declarations (as in GABDR2)
      DIMENSION COEFAB(*),COEFCD(*)
#include "twocom.h"
#include "blocks.h"
#include "symmet.h"
#include "dorps.h"
#include "nuclei.h"
#include "twosta.h"
#ifdef PRG_DIRAC
#include "dcbgrd.h"
#include "dcbham.h"
#else
#include "energy.h"
#endif
#include "doxyz.h"
#include "chrxyz.h"
      IBTAXO(I,J) = IAND(I,IEOR(I,J))
      XAND(I)     = PT(IAND(ISYMAX(1,1),I))
      YAND(I)     = PT(IAND(ISYMAX(2,1),I))
      ZAND(I)     = PT(IAND(ISYMAX(3,1),I))
C
      CALL QENTER('SYMLOP')
#include "memint.h"
      IF (IPRINT .GE. 5) CALL TITLER('Output from SYMLOP','*',103)

      IF (.NOT.(EXPECT.OR.DIRFCK.OR.DDFOCK) .AND. NSOINT.EQ.0
     &                                      .AND. LAST) GOTO 400
C
      IF (EXPECT .OR. SUSCEP .OR. DIRFCK .OR. DDFOCK) THEN
         CALL SETEFF(IEFFB,IEFFC,IEFFD)
      END IF
C
      MULAB  = IAND(MULA,MULB)
      MULCD  = IAND(MULC,MULD)
      IF (NOCONT) THEN
        NCCINT = NUCAB *NUCCD *KHKTAB*KHKTCD
      ELSE
        NCCINT = NORBAB*NORBCD*KHKTAB*KHKTCD
      END IF
C
      IF(DISTRI) JDIS = IREPDM(1)
      IF(DIRAC) THEN
        COMP(1) = 'L'
        COMP(2) = 'S'
      ELSE
        COMP(1) = ' '
        COMP(2) = ' '
      ENDIF
C
C     ***** Both distributions *****
C
      JMAX0  = MAXAB + MAXCD
      HKABCD = FMULT(IAND(MULAB,MULCD))
      IF (SPNORB) HKABCD = - HKABCD
      IF (UNDIFF .OR. LONDON .OR. SPNORB .OR. 
     &    DIRFCK .OR. DISTRI .OR. SOFOCK) THEN
         DOX = .TRUE.
         DOY = .TRUE.
         DOZ = .TRUE.
      ELSE
         DOX = DOCOOR(1,NCENTA) .OR. DOCOOR(1,NCENTB)  .OR.
     &         DOCOOR(1,NCENTC) .OR. DOCOOR(1,NCENTD)
         DOY = DOCOOR(2,NCENTA) .OR. DOCOOR(2,NCENTB)  .OR.
     &         DOCOOR(2,NCENTC) .OR. DOCOOR(2,NCENTD)
         DOZ = DOCOOR(3,NCENTA) .OR. DOCOOR(3,NCENTB)  .OR.
     &         DOCOOR(3,NCENTC) .OR. DOCOOR(3,NCENTD)
      END IF
      DOXSAV = DOX
      DOYSAV = DOY
      DOZSAV = DOZ
C
      INTS = .FALSE.
C
      ICENTA = -1
      ICENTB = -2
      ICENTC = -3
      ICENTD = -4
      SIGNAX = D1
      SIGNAY = D1
      SIGNAZ = D1
      ICENTA = NUCNUM(NCNTSH(ISHELA),1)
      IDEG   = NDEGNM(ICENTA)
      ISYBLA = ISYMBL(ISHELA,IDEG)
      IF (NCENTA .LE. 0) ICENTA = -1
C
C     Symmetrization loop
C     ===================
C
      IF (.NOT.(EXPECT.OR.DIRFCK.OR.DDFOCK)) THEN
         CALL CPRLOP(IPNTAO,IPNTOP,IPNTNO,IPNTRP,IPNTLG,SQ12EL,IPRINT)
      END IF
C
C     **********************************
C     ***** First Symmetry Index R *****
C     **********************************
C
C     Generates distinct overlap distributions A*R(B)
C
      IF (UNDIFF .OR. DIRFCK .OR. DISTRI .OR. SOFOCK) THEN
         SOP000 = .TRUE.
         IF (LAST) CALL DZERO(SOINT,NSOINT)
      ELSE
         SOP000 = .FALSE.
         IF (PERTUR .OR. LONDON .OR. SPNORB .OR. LAST)
     &       CALL DZERO(SOINT,NSOINT)
      END IF
      NSYMR = 0
      DO 100 ISYMR = 0,MAXOPR
      IF (IAND(ISYMR,IOR(MULA,MULB)) .EQ. 0) THEN
         NSYMR = NSYMR + 1
         ICENTB = NUCNUM(NCNTSH(ISHELB),IBTAXO(ISYMR,MULB)+1)
         IDEG   = NDEGNM(ICENTB)
         ISYBLB = ISYMBL(ISHELB,IDEG)
         IF (NCENTB .LE. 0) ICENTB = -2
         NUCAB  = NUCTAB(NSYMR)
         SIGNBX = XAND(ISYMR)
         SIGNBY = YAND(ISYMR)
         SIGNBZ = ZAND(ISYMR)
C
C        ***************************************************
C        ***** Charge Distributions for First Electron *****
C        ***************************************************
C
         TPRIAB = .FALSE.
         CAEQCB = ICENTA .EQ. ICENTB .AND. IATOM  .NE. NCENTA
         CALL ODCOEF(COEFAB,COORAB(1,1,1,NSYMR),EXPAB(1,1,NSYMR),WORK,
     &               LWORK,JMAXA,JMAXB,NHKTA,NHKTB,NSETA,NSETB,NUCA,
     &               NUCB,NUCAB,MXUCAB,NORBA,NORBB,NPCOA,NPCOB,
     &               NUCSAB(1,NSYMR),JSTRA,JSTRB,D1,D1,D1,SIGNBX,SIGNBY,
     &               SIGNBZ,CORAX0,CORAY0,CORAZ0,CORBX0,CORBY0,CORBZ0,
     &               AACDX,AACDY,AACDZ,IAB0X,IAB0Y,IAB0Z,CAEQCB,.TRUE.,
     &               .TRUE.,BIGVEC,UNDIFF,LONDON,SPNORB,12,THRESH,
     &               MAXDER,IPRINT)
C
C        **********************************
C        **** Second Symmetry Index S *****
C        **********************************
C
C        Generates distinct overlap distributions C*S(D)
C
         NSYMS = 0
         DO 200 ISYMS = 0, MAXOPR
         IF (IAND(ISYMS,IOR(MULC,MULD)) .EQ. 0) THEN
            NSYMS = NSYMS + 1
            TPRICD = .FALSE.
C
C           ****************************************************
C           ***** Charge Distributions for Second Electron *****
C           ****************************************************
C
            SIGNDX = XAND(ISYMS)
            SIGNDY = YAND(ISYMS)
            SIGNDZ = ZAND(ISYMS)
            NUCCD = NUCTCD(NSYMS)
            CALL ODCOEF(COEFCD,COORCD(1,1,1,NSYMS),EXPCD(1,1,NSYMS),
     &                  WORK,LWORK,JMAXC,JMAXD,NHKTC,NHKTD,NSETC,NSETD,
     &                  NUCC,NUCD,NUCCD,MXUCCD,NORBC,NORBD,NPCOC,NPCOD,
     &                  NUCSCD(1,NSYMS),JSTRC,JSTRD,D1,D1,D1,SIGNDX,
     &                  SIGNDY,SIGNDZ,CORCX0,CORCY0,CORCZ0,CORDX0,
     &                  CORDY0,CORDZ0,ABCCX,ABCCY,ABCCZ,ICD0X,ICD0Y,
     &                  ICD0Z,.FALSE.,.TRUE.,.TRUE.,BIGVEC,UNDIFF,
     &                  LONDON,SPNORB,34,THRESH,MAXDER,IPRINT)
C
C           **********************************
C           ***** Third Symmetry Index T *****
C           **********************************
C
C           Generates distinct quadruplets A*R(B) * T(C*S(D))
C
            DO 300 ISYMT = 0, MAXOPR
            IF (IAND(ISYMT,IOR(MULAB,MULCD)) .EQ. 0) THEN
              ISYMTS = IEOR(ISYMT,ISYMS)
              ICENTC = NUCNUM(NCNTSH(ISHELC),IBTAXO(ISYMT,MULC)+1)
              IDEG   = NDEGNM(ICENTC)
              ISYBLC = ISYMBL(ISHELC,IDEG)
              IF (NCENTC .LE. 0) ICENTC = -3
              ICENTD = NUCNUM(NCNTSH(ISHELD),IBTAXO(ISYMTS,MULD)+1)
              IDEG   = NDEGNM(ICENTD)
              ISYBLD = ISYMBL(ISHELD,IDEG)
              IF (NCENTD .LE. 0) ICENTD = -4
C
C              ****************************************************
C              ***** Charge Distributions for Second Electron *****
C              ****************************************************
C
               SIGNT(1) = XAND(ISYMT)
               SIGNT(2) = YAND(ISYMT)
               SIGNT(3) = ZAND(ISYMT)
               SIGNCX = XAND(ISYMT)
               SIGNCY = YAND(ISYMT)
               SIGNCZ = ZAND(ISYMT)
               SIGNDX = XAND(ISYMTS)
               SIGNDY = YAND(ISYMTS)
               SIGNDZ = ZAND(ISYMTS)
               CCEQCD = (ICENTC .EQ. ICENTD) .AND. (NCENTC .NE. IATOM)
C
C              If necessary change sign of expansion coefficients
C              ==================================================
C

               IF (IPRINT .GT. 15) THEN
                 WRITE(LUPRI,'(/,2X,A)') 'SYMLOP: EXCSGN start '
                 CALL FLSHFO(LUPRI)
               ENDIF

               CALL EXCSGN(COEFCD,JMAXC,JMAXD,NHKTC,NHKTD,NUCCD,
     &                     MXUCCD,ICD0X,ICD0Y,ICD0Z,MAXDER,LONDON,
     &                     SPNORB,ISYMT,IPRINT)

               IF (IPRINT .GT. 15) THEN
                 WRITE(LUPRI,'(/,2X,A)') 'SYMLOP: EXCSGN end '
                 CALL FLSHFO(LUPRI)
               ENDIF
C
C              Check whether this integral gives zero contribution
C              ===================================================
C
C              a) no contribution to direct Fock matrix construction
C
C              Screening: pretty thorough, taking care also of 
C                         non-symmetric density matrices
                  IF(DIRFCK.OR.SOFOCK) THEN
                    DINTSKP(1,1) = DINTSKP(1,1) + NCCINT
                    IF(DOSCRN) THEN
                      ULINT = GABRAO(ISYBLA,ISYBLB,0)*
     &                        GABRAO(ISYBLC,ISYBLD,0)
                      DNSMAX   = D0
                      DO I = 1,NDMAT 
C Largest Coulomb contribution
                        IY  = MOD(IFCTYP(I),10)
                        IC  = MOD(IY,2)
                        IE  = IY/2
                        IX = IFCTYP(I)/10
                        IF (IX.EQ.2) IC = 0
C                       ... no Coulomb term for antisym. density matrix
                        IF (HFXFAC.EQ.D0) IE = 0
                        IF (IC .NE. 0) THEN
                          DNSBUF(1,I) = MAX(DMRAO(ISYBLA,ISYBLB,I),
     &                                      DMRAO(ISYBLB,ISYBLA,I),
     &                                      DMRAO(ISYBLC,ISYBLD,I),
     &                                      DMRAO(ISYBLD,ISYBLC,I))
                        ELSE
                          DNSBUF(1,I) = D0
                        END IF
C Largest exchange contribution
                        IF (IE .NE. 0) THEN
                          DNSBUF(2,I) = MAX(DMRAO(ISYBLC,ISYBLA,I),
     &                                      DMRAO(ISYBLA,ISYBLC,I),
     &                                      DMRAO(ISYBLC,ISYBLB,I),
     &                                      DMRAO(ISYBLB,ISYBLC,I),
     &                                      DMRAO(ISYBLD,ISYBLA,I),
     &                                      DMRAO(ISYBLA,ISYBLD,I),
     &                                      DMRAO(ISYBLB,ISYBLD,I),
     &                                      DMRAO(ISYBLD,ISYBLB,I))
                        ELSE
                          DNSBUF(2,I) = D0
                        END IF
                        DNSMAX = MAX(DNSMAX,DNSBUF(1,I),DNSBUF(2,I))
                      ENDDO
                      FCKMAX = DNSMAX*ULINT
                      IF(FCKMAX.LT.SCRTHR) THEN
                        DINTSKP(2,1) = DINTSKP(2,1) + NCCINT
                        IF(IPRINT.GE.4) THEN
                   WRITE(LUPRI,
     &              '(A,1P,2(D8.2,1X),4(I4,A1,A6,1X,3A1))')
     &        '*Skip: ',DNSMAX,ULINT,
     &        ISHELA,'(',NAMDEP(ICENTA),COMP(LCLASH(ISHELA)),
     &        SPDCAR(NHKTSH(ISHELA)-1),')',
     &        ISHELB,'(',NAMDEP(ICENTB),COMP(LCLASH(ISHELB)),
     &        SPDCAR(NHKTSH(ISHELB)-1),')',
     &        ISHELC,'(',NAMDEP(ICENTC),COMP(LCLASH(ISHELC)),
     &        SPDCAR(NHKTSH(ISHELC)-1),')',
     &        ISHELD,'(',NAMDEP(ICENTD),COMP(LCLASH(ISHELD)),
     &        SPDCAR(NHKTSH(ISHELD)-1),')'
                        ENDIF
                        GOTO 300
                      ENDIF
                    ENDIF
                  ENDIF
                  IF(DISTRI) THEN
                    DINTSKP(1,JDIS) = DINTSKP(1,JDIS) + NCCINT
                    IF(DOSCRN) THEN
                      ULINT = GABRAO(ISYBLA,ISYBLB,0)*
     &                        GABRAO(ISYBLC,ISYBLD,0)
                      DNSMAX = D0
C                     We take the product of the maximum density for
C                     electron 1 and the maximum density for electron 2
C                     These maxima are stored in the array DMRAO that has
C                     as last dimension twice the number of density matrices
C                     (first the ones for elec. 1, then those for elec. 2).
C                     This why the offset is needed.
                      IOFF = NDMAT
                      DO I = 1,NDMAT
                        FAC = DMRAO(ISYBLC,ISYBLD,I)*
     &                        DMRAO(ISYBLA,ISYBLB,I+IOFF)
                        DNSMAX = MAX(DNSMAX,FAC)
                      ENDDO
                      FAC = D1
                      DISMAX = FAC*DNSMAX*ULINT
                      IF(DISMAX.LT.SCRTHR) THEN
                        DINTSKP(2,JDIS) = DINTSKP(2,JDIS) + NCCINT
                        IF(IPRINT.GE.4) THEN
                   WRITE(LUPRI,
     &              '(A,1P,D8.2,4(I4,A1,A6,1X,3A1),I3)')
     &        '*Skip: ',DISMAX,
     &        ISHELA,'(',NAMDEP(ICENTA),COMP(LCLASH(ISHELA)),
     &        SPDCAR(NHKTSH(ISHELA)-1),')',
     &        ISHELB,'(',NAMDEP(ICENTB),COMP(LCLASH(ISHELB)),
     &        SPDCAR(NHKTSH(ISHELB)-1),')',
     &        ISHELC,'(',NAMDEP(ICENTC),COMP(LCLASH(ISHELC)),
     &        SPDCAR(NHKTSH(ISHELC)-1),')',
     &        ISHELD,'(',NAMDEP(ICENTD),COMP(LCLASH(ISHELD)),
     &        SPDCAR(NHKTSH(ISHELD)-1),')',JDIS
                        ENDIF
                        GOTO 300
                      ENDIF
                    ENDIF
                  ENDIF
C
C              b) atom to be differentiated does not enter integral
C
               IF (PERTUR .AND. MAXDER .GT. 0) THEN
                  IF (IATOM .NE. NCENTA .AND. IATOM .NE. NCENTB
     &                                  .AND. IATOM .NE. NCENTC
     &                                  .AND. IATOM .NE. NCENTD)
     &                    GO TO 300
               END IF
C
C              c) one-center integrals
C
               ONECEN = (ICENTA .EQ. ICENTB) .AND.
     &                  (ICENTA .EQ. ICENTC) .AND.
     &                  (ICENTA .EQ. ICENTD) .AND.
     &                  (ICENTA .NE. 0)
               IF (ONECEN) THEN
                  IF (MAXDER .EQ. 0) THEN
                     IF (IAND(JMAX0,1).EQ.1)              GO TO 300
                  ELSE
                     IF (PERTUR .OR. EXPECT .OR. LONDON)    GO TO 300
                  END IF
               END IF
               IF (LONDON) THEN
                  IF ((ICENTA .EQ. ICENTB) .AND.
     &                (ICENTC .EQ. ICENTD)) GO TO 300
               END IF
C
C              d) screening of gradient and hessian 
C                 expectation value (static term) calculation
C                 for RHF and ROHF /980113-hjaaj+jth
C                 Extension to MCSCF requires that max value
C                 of PV is found (or safely approximated).
C
               DOX = DOXSAV
               DOY = DOYSAV
               DOZ = DOZSAV
               IF (MAXDER .EQ. 1 .AND. EXPECT .AND. NOPV) THEN
C     No screening for Hessian because this requires
C     4'th derivative integrals in GAB, and this is
C     not implemented. /980116-hjaaj/jth
                     IT = IMULTI(ICENTA,ICENTB,ICENTC,ICENTD,ICEN)
                     DO IXYZ = 1,3
                        IF (DOXYZ(IXYZ)) 
     &                     CALL ADDDINT(DINTSKP,NCCINT,ICEN,1,IXYZ)
                     END DO
                  IF (DOSCRN) THEN
                     IF (MAXDER .GE. 1) THEN
                        CALL SCRINT_GEOM(GABRAO,ISYBLA,ISYBLB,ISYBLC,
     &                         ISYBLD,IT,ULXINT,ULYINT,ULZINT,IPRINT)
                     END IF
C
c                    IF (MAXDER .EQ. 2) THEN
c                       UXXINT = MAX(GABRAO(ISYBLA,ISYBLB,0)*
c    &                               GABRAO(ISYBLC,ISYBLD,IXX),
c    &                               GABRAO(ISYBLA,ISYBLB,IXX)*
c    &                               GABRAO(ISYBLC,ISYBLD,0),
c    &                               GABRAO(ISYBLA,ISYBLB,IX*
c    &                               GABRAO(ISYBLC,ISYBLD,IX)
c     and so on .... /jth
c                    END IF
                     DNSMAX   = D0
                     DO I = 1,NDMAT 
                        IY  = MOD(IFCTYP(I),10)
                        IC  = MOD(IY,2)
                        IE  = IY/2
                        IX = IFCTYP(I)/10
                        IF (IX.EQ.2) IC = 0
C                       ... no Coulomb term for antisym. density matrix
                        IF (HFXFAC.EQ.D0) IE = 0
C Largest Coulomb contribution to gradient/Hessian expectation value
                        IF (IC .NE. 0) THEN
                           DNSBUF(1,I) = DMRAO(ISYBLA,ISYBLB,I)
     &                                  *DMRAO(ISYBLC,ISYBLD,I)
c DMRAO is always symmetric here.
c                          DNSBUF(1,I) = MAX(DMRAO(ISYBLA,ISYBLB,I),
c    &                                       DMRAO(ISYBLB,ISYBLA,I))
c    &                                  *MAX(DMRAO(ISYBLC,ISYBLD,I),
c    &                                       DMRAO(ISYBLD,ISYBLC,I))
                        ELSE
                           DNSBUF(1,I) = D0
                        END IF
C Largest exchange contribution to gradient/Hessian expectation value
                        IF (IE .NE. 0) THEN
C                          DNS21       = DMRAO(ISYBLC,ISYBLA,I)
C    &                                  *DMRAO(ISYBLB,ISYBLD,I)
c                          DNS21       = MAX(DMRAO(ISYBLC,ISYBLA,I),
c    &                                       DMRAO(ISYBLA,ISYBLC,I))
c    &                                  *MAX(DMRAO(ISYBLB,ISYBLD,I),
c    &                                       DMRAO(ISYBLD,ISYBLB,I))
c                          DNS22       = MAX(DMRAO(ISYBLD,ISYBLA,I),
c    &                                       DMRAO(ISYBLA,ISYBLD,I))
c    &                                  *MAX(DMRAO(ISYBLC,ISYBLB,I),
c    &                                       DMRAO(ISYBLB,ISYBLC,I))
                           DNSBUF(2,I) = DMRAO(ISYBLC,ISYBLA,I)
     &                                  *DMRAO(ISYBLD,ISYBLB,I)
     &                                 + DMRAO(ISYBLD,ISYBLA,I)
     &                                  *DMRAO(ISYBLC,ISYBLB,I)
                        ELSE
                           DNSBUF(2,I) = D0
                        END IF
                        DNSMAX = DNSMAX+DNSBUF(1,I)+DP25*DNSBUF(2,I)
c                       DNSMAX = MAX(DNSMAX,DNSBUF(1,I),DNSBUF(2,I))
                     ENDDO
Cjth - we may introduce a expectation value threshold later - TODO ?
                     EXPTHR = SCRTHR
C
                     DO 20 I = 1,3
C
C                    If direction requested then check if
C                    integral gives a contribution.
C
                        IF (.NOT. DOXYZ(I)) GOTO 20
                        IF (I.EQ.1) ULINT = ULXINT
                        IF (I.EQ.2) ULINT = ULYINT
                        IF (I.EQ.3) ULINT = ULZINT
                        EXPMAX = DNSMAX*ULINT
                        IF(EXPMAX.LT.EXPTHR) THEN
                           DOXYZ(I) = .FALSE.
                           CALL ADDDINT(DINTSKP,NCCINT,ICEN,2,I)
                           IF(IPRINT.GE.4) THEN
                              WRITE(LUPRI,
     &              '(A,A1,A,1P,D8.2,4(I4,A1,A6,1X,3A1))')
     &        '*GrdSkip (',CHRXYZ(I),'): ',EXPMAX,
     &        ISYBLA,'(',NAMDEP(ICENTA),COMP(LCLASH(ISHELA)),
     &        SPDCAR(NHKTSH(ISHELA)-1),')',
     &        ISYBLB,'(',NAMDEP(ICENTB),COMP(LCLASH(ISHELB)),
     &        SPDCAR(NHKTSH(ISHELB)-1),')',
     &        ISYBLC,'(',NAMDEP(ICENTC),COMP(LCLASH(ISHELC)),
     &        SPDCAR(NHKTSH(ISHELC)-1),')',
     &        ISYBLD,'(',NAMDEP(ICENTD),COMP(LCLASH(ISHELD)),
     &        SPDCAR(NHKTSH(ISHELD)-1),')'
                           ENDIF
C                          Item (e) below makes sure we jump to 300 
C                          if DOX = DOY = DOZ = FALSE
                        END IF
 20                  CONTINUE
                  ENDIF
               END IF
 21            CONTINUE
C
C              e) none of the directions are requested
C                 or all directions screened away
C
               IF (.NOT. (DOX .OR. DOY .OR. DOZ)) GO TO 300
C
C
C              f) One-center models :
c
C                 (i)   Skip two-center SS contributions if requested (type 2)
C                 (ii)  Skip multicenter SS and LS contributions if requested 
C                       (type 1 or 3)
C                 (iii) For type 4 this point is never reached since we 
C                       have INTFLG = 1 0 0 in this case.
C
               IF (ONECAP) THEN
                  IF (INTV1C .NE. 1) THEN
C                 ... only atomic contributions to SS and LS
                     IF ((LCLASH(ISHELA).EQ.2 .OR. LCLASH(ISHELB).EQ.2
     &               .OR. LCLASH(ISHELC).EQ.2 .OR. LCLASH(ISHELD).EQ.2)
     &              .AND. (.NOT.ONECEN) ) GO TO 300
                  ELSE IF ((ICENTA.NE.ICENTB.AND.LCLASH(ISHELA).EQ.2
     &               .AND.LCLASH(ISHELB).EQ.2).OR.(ICENTC.NE.ICENTD
     &               .AND.LCLASH(ISHELC).EQ.2.AND.LCLASH(ISHELD).EQ.2))
     &               THEN
C                 ... only one-center SS distributions
                     GO TO 300
                  END IF
               ENDIF
C
C              Integral contributes
C              ====================
C
               IF (IPRINT .GE. 5) THEN
                  WRITE (LUPRI, '(/,1X,A,3I5)')
     &               ' Symmetry operations:',ISYMR, ISYMS, ISYMT
                  WRITE (LUPRI, '(/,1X,A,I5)') ' ISYMTS ', ISYMTS
                  WRITE (LUPRI, '(1X,A,4I5)')
     &               ' ICENTA-D ',ICENTA, ICENTB, ICENTC, ICENTD
                  WRITE (LUPRI, '(1X,A,4I5)')
     &               ' NCENTA-D ',NCENTA, NCENTB, NCENTC, NCENTD
               END IF
C
C              Local symmetries
C              ================
C
               ABADX  = ABS(CORAX0 - XAND(ISYMT)*CORCX0) .LT. THRESH
               ABADY  = ABS(CORAY0 - YAND(ISYMT)*CORCY0) .LT. THRESH
               ABADZ  = ABS(CORAZ0 - ZAND(ISYMT)*CORCZ0) .LT. THRESH
               ISAMEX = 0
               ISAMEY = 0
               ISAMEZ = 0
               IF (AACDX .AND. ABADX .AND. ABCCX) ISAMEX = 1
               IF (AACDY .AND. ABADY .AND. ABCCY) ISAMEY = 1
               IF (AACDZ .AND. ABADZ .AND. ABCCZ) ISAMEZ = 1
               ISMXYZ = ISAMEX + 2*ISAMEY + 4*ISAMEZ
C
               IF (EXPECT .OR. SUSCEP .OR. DIRFCK .OR. DDFOCK) THEN
                  DO 55 I = 1, NORBA
                     ICORBA(I) = IORBSH(ISHELA,I)
   55             CONTINUE
                  DO 65 I = 1, NORBB
                     ICORBB(I) = IORBSH(ISHELB,I) + IEFFB(ISYMR)
   65             CONTINUE
                  DO 75 I = 1, NORBC
                     ICORBC(I) = IORBSH(ISHELC,I) + IEFFC(ISYMT)
   75             CONTINUE
                  DO 85 I = 1, NORBD
                     ICORBD(I) = IORBSH(ISHELD,I) + IEFFD(ISYMTS)
   85             CONTINUE
               END IF
C
C              *******************************
C              ***** Integral Directives *****
C              *******************************
C
C
C              DOGAB is only true when called from GABDR2
C
               DOGAB = .FALSE.
               CALL DIRECT(BIGVEC,ICENTA,ICENTB,ICENTC,ICENTD,
     &                     NCENTA,NCENTB,NCENTC,NCENTD,
     &                     0,     ISYMR, ISYMT, ISYMTS,
     &                     SIGNAX,SIGNAY,SIGNAZ,SIGNBX,SIGNBY,SIGNBZ,
     &                     SIGNCX,SIGNCY,SIGNCZ,SIGNDX,SIGNDY,SIGNDZ,
     &                     NCCINT,MAXDER,EXPECT,LONDON,SPNORB,IATOM,
     &                     MULTE,NINTYP,DOGAB,IPRINT)
C
C              ************************
C              ***** AO integrals *****
C              ************************
C
               LAOINT = NCCINT*NINTYP
               CALL MEMGET('REAL',KAOINT,LAOINT,WORK,KFREE,LFREE)
               MWAOIN = MAX(MWAOIN,LAOINT)
               LWTOT  = LWTOT + KFREE - 1
               MWTOT  = MAX(MWTOT,LWTOT)
               CALL CAOINT(SOINT,DMAT,NDMAT,PSO,PSA,FMAT,WORK(KAOINT),
     &                     WORK(KFREE),LFREE,COEFAB,COEFCD,
     &                     COORAB(1,1,1,NSYMR),COORCD(1,1,1,NSYMS),
     &                     EXPAB(1,1,NSYMR),EXPCD(1,1,NSYMS),
     &                     FACAB(1,NSYMR),FACCD(1,NSYMS),
     &                     CONTA(1,1,NSYMR),CONTB(1,1,NSYMR),
     &                     CONTC(1,1,NSYMS),CONTD(1,1,NSYMS),
     &                     NCCINT,NINTYP,UNDIFF,PERTUR,LONDON,SPNORB,
     &                     EXPECT,SUSCEP,DDFOCK,DIRFCK,SOFOCK,
     &                     DISTRI,IATOM,
     &                     MULE,MULTE,MAXDER,BIGVEC,NOCONT,NODV,NOPV,
     &                     ISMXYZ,THRESH,ONECEN,IPRINT,ICORBA,ICORBB,
     &                     ICORBC,ICORBD,INTS,HKABCD,JMAX0,ISYMR,ISYMS,
     &                     ISYMT,ISYMTS,SQ12EL,SOP000,IPNTAO,IPNTOP,
     &                     NPCOA(1,1,NSYMR),NPCOB(1,1,NSYMR),
     &                     NPCOC(1,1,NSYMS),NPCOD(1,1,NSYMS),
     &                     NUCSAB(1,NSYMR), NUCSCD(1,NSYMS),
     &                     SIGNT,INDHSQ,IODDHR,INDHER,LMNVLS,NINDAB,
     &                     NINDCD,NPNTAB(1,1,NSYMR),NPNTCD(1,1,NSYMS),
     &                     NREDAB,NREDCD,IFCTYP,DNSBUF,DINTSKP,DOGAB,
     &                     HFXFAC,GENCNT)
               LWTOT  = LWTOT - KFREE + 1
               CALL MEMREL('SYMLOP',WORK,KWORK,KWORK,KFREE,LFREE)
            END IF
  300       CONTINUE
         END IF
  200    CONTINUE
      END IF
  100 CONTINUE
C
C     ********************************
C     ***** Process SO integrals *****
C     ********************************
C
  400 CONTINUE

      IF (.NOT. (EXPECT.OR.DIRFCK.OR.DDFOCK) .AND. (INTS.OR.LAST)) THEN
C
C        A) Undifferentiated integrals
C        =============================
C
         IF (UNDIFF) THEN
            IF (TKTIME) TIMSTR = SECOND()
            IF (.NOT.ADISTR) THEN
               CALL UN2OUT(SOINT,IPNTNO,IPNTRP,IPNTLG,FIRST,LAST,
     &                     THRESH,NINDAB,NINDCD,IPRINT)
            ELSE
               CALL DS2OUT(SOINT,WRKBUF,IPNTNO,IPNTRP,IPNTLG,FIRST,LAST,
     &                     THRESH,NINDAB,NINDCD,IPRINT)
            END IF
            IF (TKTIME) TSYMOU = TSYMOU + SECOND() - TIMSTR
            FIRST = .FALSE.
C
C        B) Differentiated integrals
C        ===========================
C
         ELSE IF (PERTUR .OR. SPNORB) THEN
            CALL MEMCHK('SYMLOP diff intgrls ',WORK,1) ! mi check
            IF (TKTIME) TIMSTR = SECOND()
            CALL DR2OUT(SOINT,IATOM,MULE,FIRST,LAST,SPNORB,SQ12EL,
     &                  THRESH,IPNTNO,IPNTRP,IPNTLG,NINDAB,NINDCD,
     &                  IPRINT)
            IF (TKTIME) TDSOUT = TDSOUT + SECOND() - TIMSTR
            FIRST = .FALSE.
C
C        C) London orbitals
C        ==================
C
         ELSE IF (LONDON) THEN

            CALL MEMCHK('SYMLOP london ',WORK,1) ! mi check
            IF (TKTIME) TIMSTR = SECOND()
            CALL MG2OUT(SOINT,FIRST,LAST,THRESH,IPNTNO,IPNTRP,IPNTLG,
     &                  NINDAB,NINDCD,IPRINT)
            IF (TKTIME) TDSOUT = TDSOUT + SECOND() - TIMSTR
            FIRST = .FALSE.
C
C        D) Direct calculation of Fock matrices in SO basis
C        ==================================================
C
         ELSE IF (SOFOCK) THEN
            IF (TKTIME) TIMSTR = SECOND()
            CALL FCKOUT(FMAT,DMAT,NDMAT,SOINT,IPNTNO,IPNTRP,IPNTLG,
     &                  NINDAB,NINDCD,IFCTYP,DINTSKP,IREPDM,
     &                  DMRSO,DNSBUF,HFXFAC,WORK,LWORK,IPRINT)
            IF (TKTIME) TFCKOU = TFCKOU + SECOND() - TIMSTR
            FIRST = .FALSE.
C
C        E) Calculation of distributions
C        ===============================
C
         ELSE IF (DISTRI) THEN
            IF (TKTIME) TIMSTR = SECOND()
            CALL DT2OUT (SOINT,IPNTNO,IPNTRP,IPNTLG,FIRST,LAST,THRESH,
     &                  NINDAB,NINDCD,IPRINT,INDX,INDXAB,GMAT)
            IF (TKTIME) TFCKOU = TFCKOU + SECOND() - TIMSTR
            FIRST = .FALSE.
         END IF
      ELSE IF (EXPECT) THEN
         IF (IPRINT .GE. 6) CALL PRIGRD(GRADEE)
      END IF

      CALL QEXIT('SYMLOP')
      RETURN
C
      END
C  /* Deck caoint */
      SUBROUTINE CAOINT(SOINT,DMAT,NDMAT,PSO,PSA,FMAT,AOINT,WORK,LWORK,
     &                  COEFAB,COEFCD,COORAB,COORCD,EXPAB,EXPCD,FACAB,
     &                  FACCD,CONTA,CONTB,CONTC,CONTD,NCCINT,NINTYP,
     &                  UNDIFF,PERTUR,LONDON,SPNORB,EXPECT,SUSCEP,
     &                  DDFOCK,DIRFCK,SOFOCK,DISTRI,IATOM,
     &                  MULE,MULTE,MAXDER,
     &                  BIGVEC,NOCONT,NODV,NOPV,ISMXYZ,THRESH,ONECEN,
     &                  IPRINT,ICORBA,ICORBB,ICORBC,ICORBD,INTS,HKABCD,
     &                  JMAX0,ISYMR,ISYMS,ISYMT,ISYMTS,SQ12EL,SOP000,
     &                  IPNTAO,IPNTOP,NPCOA,NPCOB,NPCOC,NPCOD,NUCSAB,
     &                  NUCSCD,SIGNT,INDHSQ,IODDHR,INDHER,LMNVLS,NINDAB,
     &                  NINDCD,NPNTAB,NPNTCD,NREDAB,NREDCD,IFCTYP,
     &                  DNSBUF,DINTSKP,DOGAB,HFXFAC,GENCNT)
#include "implicit.h"
#include "priunit.h"
#include "mxcent.h"
#include "maxorb.h"
#include "maxaqn.h"
      LOGICAL NOPV, NODV, PERTUR, EXPECT, NOINT, DDFOCK, DIRFCK, DISTRI,
     &        INTS, UNDIFF, NOCONT, SPNORB, BIGVEC, ONECEN,
     &        SQ12EL, SOP000, LONDON, SUSCEP, SOFOCK, DOGAB, GENCNT
      DIMENSION AOINT(NCCINT,NINTYP), SOINT(*), PSO(*),PSA(*),COEFAB(*),
     &          COEFCD(*), COORAB(*), COORCD(*), EXPAB(*), EXPCD(*),
     &          CONTA(*), CONTB(*), CONTC(*), CONTD(*), FACAB(*),
     &          FACCD(*), NPCOA(*), NPCOB(*), NPCOC(*),
     &          NPCOD(*), NUCSAB(*), NUCSCD(*), ICORBA(*), ICORBB(*),
     &          ICORBC(*), ICORBD(*), IPNTAO(*), IPNTOP(3,*),
     &          SIGNT(3), INDHSQ(*), IODDHR(*), INDHER(*), LMNVLS(*),
     &          NPNTAB(*), NPNTCD(*), NREDAB(*), NREDCD(*),
     &          FMAT(NBASIS,NBASIS,*), DMAT(NBASIS,NBASIS,*), IFCTYP(*),
     &          DNSBUF(*),DINTSKP(*),WORK(LWORK)
#include "ccom.h"
#include "symmet.h"
#include "nuclei.h"
#include "twocom.h"
#include "twosta.h"
C
C     *************************
C     ***** Print Section *****
C     *************************
C
      IF (IPRINT .GE. 10) THEN
         CALL TITLER('Output from CAOINT','*',103)
         WRITE (LUPRI, 1005) NHKTA, NHKTB, NHKTC, NHKTD
         WRITE (LUPRI, 1010) MAXAB, MAXCD, JMAX0
         WRITE (LUPRI, 1020) KHKTA, KHKTB, KHKTC, KHKTD
         WRITE (LUPRI, 1021) KCKTA, KCKTB, KCKTC, KCKTD
         WRITE (LUPRI, 1030) KHKTAB, KHKTCD
         WRITE (LUPRI, 1031) KCKTAB, KCKTCD
         WRITE (LUPRI, 1050) DIAGAB, IAB0X, IAB0Y, IAB0Z
         WRITE (LUPRI, 1060) DIAGCD, ICD0X, ICD0Y, ICD0Z
         WRITE (LUPRI, 1075) TPRIAB, TCONAB
         WRITE (LUPRI, 1076) TPRICD, TCONCD
         WRITE (LUPRI, 1080) ISMXYZ
         WRITE (LUPRI, 1090) NORBA, NORBB, NORBC, NORBD
         WRITE (LUPRI, 1100) NORBAB, NORBCD
         WRITE (LUPRI, 1110) NUCAB, NUCCD
      END IF
C
C     **********************************
C     ***** Calculate AO integrals *****
C     **********************************
C
      CALL INTDER(AOINT,NCCINT,NINTYP,WORK,LWORK,COEFAB,COEFCD,COORAB,
     &            COORCD,EXPAB,EXPCD,FACAB,FACCD,CONTA,CONTB,CONTC,
     &            CONTD,IPRINT,NOINT,NOCONT,SPNORB,MAXDER,THRESH,
     &            JMAX0,ISMXYZ,ONECEN,NPCOA,NPCOB,NPCOC,NPCOD,NUCSAB,
     &            NUCSCD,SIGNT,IODDHR,INDHSQ,INDHER,LMNVLS,
     &            NPNTAB,NPNTCD,NREDAB,NREDCD)
      INTS = INTS .OR. .NOT.NOINT
C
C     ********************************
C     ***** Process AO integrals *****
C     ********************************
C
      IF (.NOT.NOINT) THEN
C
C        A) Contributions to SO integrals
C        ================================
C
C        a) Undifferentiated integrals
C
         IF (UNDIFF .OR. DISTRI. OR. SOFOCK) THEN
            IF (TKTIME) TIMSTR = SECOND()
            CALL SYM2(SOINT,AOINT,IPNTAO,IPNTOP,ISYMR,ISYMT,ISYMTS,
     &                HKABCD,SQ12EL,SOP000,NINTS,IPRINT)
            IF (TKTIME) TSYM2S = TSYM2S + SECOND() - TIMSTR
            SOP000 = .FALSE.
C
C        b) Spin-orbit integrals
C
         ELSE IF (SPNORB) THEN
            IF (TKTIME) TIMSTR = SECOND()
            CALL SPOSYM(SOINT,AOINT,NCCINT,HKABCD,ISYMR,ISYMT,ISYMTS,
     &                  IPNTAO,IPNTOP,SQ12EL,SOP000,IPRINT)
            IF (TKTIME) TSPOSY = TSPOSY + SECOND() - TIMSTR
            SOP000 = .FALSE.
C
C        c) First derivative integrals
C
         ELSE IF (PERTUR .AND. .NOT.DDFOCK) THEN
            IF (TKTIME) TIMSTR = SECOND()
            CALL DRSYM2(SOINT,AOINT,WORK,NCCINT,LWORK,HKABCD,ISYMR,
     &                  ISYMT,ISYMTS,IPNTAO,IPNTOP,MULE,SQ12EL,SOP000,
     &                  IPRINT)
            IF (TKTIME) TDRSYM = TDRSYM + SECOND() - TIMSTR
            SOP000 = .FALSE.
C
C        d) London orbitals
C
         ELSE IF (LONDON) THEN
            IF (TKTIME) TIMSTR = SECOND()
            IF (.NOT. DDFOCK) THEN
               CALL MGSYM2(SOINT,AOINT,WORK,NCCINT,LWORK,HKABCD,ISYMR,
     &                     ISYMT,ISYMTS,IPNTAO,IPNTOP,SOP000,IPRINT)
            END IF
            IF (TKTIME) TDRSYM = TDRSYM + SECOND() - TIMSTR
            SOP000 = .FALSE.
C
            IF (SUSCEP .OR. DDFOCK) THEN
               IF (TKTIME) TIMSTR = SECOND()
               IADRT = 1
               IADRA = 4
               CALL INTEXP(AOINT,DMAT,NDMAT,PSO,PSA,FMAT(1,1,IADRT),
     &                     FMAT(1,1,IADRA),NINDAB,NINDCD,NCCINT,
     &                     NINTYP,WORK,LWORK,ISYMR,ISYMS,ISYMT,ICORBA,
     &                     ICORBB,ICORBC,ICORBD,THRESH,HKABCD,IPRINT,
     &                     NOPV,NODV,EXPECT,LONDON,SUSCEP,DDFOCK,
     &                     DINTSKP,GENCNT)
               IF (TKTIME) TINTEX = TINTEX + SECOND() - TIMSTR
            END IF
C
C        e) Contributions to expectation values
C        ======================================
C
         ELSE IF ((EXPECT.AND..NOT. DOGAB) .OR. DDFOCK) THEN
            IF (TKTIME) TIMSTR = SECOND()
            IF (PERTUR) THEN
               IADRT = 1
               IADRA = 1 + 3*NUCDEG(IATOM)
            ELSE
               IADRT = 1
               IADRA = 1 + 3*NUCDEP
            END IF
            CALL INTEXP(AOINT,DMAT,NDMAT,PSO,PSA,FMAT(1,1,IADRT),
     &                  FMAT(1,1,IADRA),NINDAB,NINDCD,NCCINT,
     &                  NINTYP,WORK,LWORK,ISYMR,ISYMS,ISYMT,ICORBA,
     &                  ICORBB,ICORBC,ICORBD,THRESH,HKABCD,IPRINT,
     &                  NOPV,NODV,EXPECT,LONDON,SUSCEP,DDFOCK,
     &                  DINTSKP,GENCNT)
            IF (TKTIME) TINTEX = TINTEX + SECOND() - TIMSTR
C
C        f) Contributions to Fock matrices
C        =================================
C
         ELSE IF (DIRFCK) THEN
            IF (TKTIME) TIMSTR = SECOND()
            CALL INTFCK(FMAT,AOINT,DMAT,NDMAT,NCCINT,NINTYP,
     &                  ICORBA,ICORBB,ICORBC,ICORBD,HKABCD,
     &                  IPRINT,NODV,NINDAB,NINDCD,SUSCEP,IFCTYP,
     &                  DNSBUF,DINTSKP,HFXFAC,WORK,LWORK)
            IF (TKTIME) TINTEX = TINTEX + SECOND() - TIMSTR
         END IF
      END IF
      RETURN
C
 1005 FORMAT(//,'  NHKTA-D   ',4I5)
 1010 FORMAT(   '  JMAX0     ',I1,' + ',I1,' = ',I2)
 1020 FORMAT(   '  KHKTA-D   ',4I5)
 1021 FORMAT(   '  KCKTA-D   ',4I5)
 1030 FORMAT(   '  KHKTAB-CD ',2I5)
 1031 FORMAT(   '  KCKTAB-CD ',2I5)
 1050 FORMAT(   '  DIAGAB    ',L5,3I5)
 1060 FORMAT(   '  DIAGCD    ',L5,3I5)
 1075 FORMAT(   '  TPRI/CONAB',2L5)
 1076 FORMAT(   '  TPRI/CONCD',2L5)
 1080 FORMAT(   '  ISMXYZ    ', I5)
 1090 FORMAT(   '  NORBA-D   ',4I5)
 1100 FORMAT(   '  NORBAB-CD ',2I5)
 1110 FORMAT(   '  NUCAB-CD  ',2I5)
      END
C  /* Deck paovec */
      SUBROUTINE PAOVEC(WORK,LWORK,IATOM1,IPRINT)
#include "implicit.h"
#include "aovec.h"
#include "maxorb.h"
      DIMENSION WORK(LWORK)
#include "shells.h"
#include "blocks.h"
C
      CALL QENTER('PAOVEC')
C
C aug2000 th+hjaaj: if (SEGMEN) then make as small vector shell blocks
C          as possible
C
      IF (IATOM1 .EQ. -10000) THEN
C        PAOVEC for generating GAB matrix
         SEGMEN = .TRUE.
         IATOM = 0
      ELSE
         SEGMEN = .FALSE.
         IATOM = IATOM1
      END IF
C
#include "memint.h"
C
      CALL MEMGET('LOGI',KORBOU,KMAX       ,WORK,KFREE,LFREE)
      CALL MEMGET('INTE',KIPRVO,KMAX       ,WORK,KFREE,LFREE)
      CALL MEMGET('INTE',KIPRVP,KMAX       ,WORK,KFREE,LFREE)
      CALL MEMGET('INTE',KJORBS,KMAX*MXAOVC,WORK,KFREE,LFREE)
      CALL MEMGET('INTE',KKORBS,KMAX*MXAOVC,WORK,KFREE,LFREE)
C
      CALL PAOVE2(IATOM,IPRINT,WORK(KORBOU),
     &            WORK(KIPRVO),WORK(KIPRVP),WORK(KJORBS),WORK(KKORBS))
C
      CALL MEMREL('PAOVEC',WORK,KWORK,KWORK,KFREE,LFREE)
      CALL QEXIT('PAOVEC')
      RETURN
      END
C  /* Deck paove2 */
      SUBROUTINE PAOVE2(IATOM,IPRINT,ORBOUT,
     &                  IPRVOR,IPRVPR,JORBSH,KORBSH)
C
CHJMAERKE TODO
C hjaaj aug2000: possibilities:
C                here we can also split a contracted block
C                in more blocks, if needed for memory
C
#include "implicit.h"
#include "maxaqn.h"
#include "aovec.h"
#include "maxorb.h"
#include "mxcent.h"

      PARAMETER (DSM = 1.0D-12)
      LOGICAL   ORBOUT(KMAX)
      DIMENSION IPRVOR(KMAX), IPRVPR(KMAX),
     *          JORBSH(KMAX,MXAOVC), KORBSH(KMAX,MXAOVC)

#ifdef PRG_DIRAC
#include "dcbgen.h"
#else
#include "gnrinf.h"
#endif
#include "priunit.h"
#include "shells.h"
#include "blocks.h"
#include "symmet.h"
#include "nuclei.h"
#include "primit.h"
C
C
      MXAOSH = 0
      NLRGBL = 0
C
C     Set up information needed below
C
      IORB = 0
      INUC = 0
C     Loop over symmetry independent orbital shells
      DO 100 IA = 1, KMAX
C
        ORBOUT(IA) = .FALSE.
C
C        ... find off-set to this sym. indep. orb. shell
C            in total list of contracted orbitals
        IPRVOR(IA) = IORB
        IORB = IORB + KHKT(IA)*MULT(ISTBAO(IA))
C
C        ... find off-set to input block of primitives used for
C            this sym. indep. orb. shell
        IPRVPR(IA) = INUC
        IF (IA.LT.KMAX) THEN
          IF (NUMCF(IA + 1) .EQ. 1) INUC = INUC + NUCO(IA)
        END IF
 100  CONTINUE
C
C     Assign each orbital shell to a vector orbital shell
C
      MAXSHL = 0
      NAOOUT = 0
      NSYMBL = 0
 1000 CONTINUE
      DO 200 IA = 1, KMAX
      IF (.NOT.ORBOUT(IA)) THEN
        NHKTA  = NHKT(IA)
        KHKTA  = KHKT(IA)
        KCKTA  = KCKT(IA)
        NCENTA = NCENT(IA)
        NBCHA  = NBCH(IA)
        NUCA   = NUCO(IA)
        MAXSHL = MAXSHL + 1
        LCLASH(MAXSHL) = LCLASS(IA)
        IF(LCLASS(IA).EQ.1) NLRGBL = NLRGBL + 1
        NHKTSH(MAXSHL) = NHKTA
        KHKTSH(MAXSHL) = KHKTA
        KCKTSH(MAXSHL) = KCKTA
        ISTBSH(MAXSHL) = ISTBAO(IA)
        SEGMSH(MAXSHL) = SEGM(IA)
        SPHRSH(MAXSHL) = SPHR(IA)
C
C       Make offsets for symmetry-dependent centers
C               
        NDEG = NUCDEG(NCENTA)
        DO IDEG = 1,NDEG
          NSYMBL = NSYMBL + 1
          ISYMBL(MAXSHL,IDEG) = NSYMBL
        ENDDO
        NCNTSH(MAXSHL)   = NCENTA
        CENTSH(MAXSHL,1) = CENT(IA,1,1)
        CENTSH(MAXSHL,2) = CENT(IA,2,1)
        CENTSH(MAXSHL,3) = CENT(IA,3,1)
C
        IF (SEGMEN) THEN
C aug2000 hjaaj   Task: make vector shells as small as possible
C                 for calc. of GAB matrix. That is, for segmented
C                 blocks we keep just one orbital shell in each
C                 vector orbital shell.
C
          NAOOUT     = NAOOUT + 1
          ORBOUT(IA) = .TRUE.
          IPTSHL(IA) = MAXSHL
          IORB       = 1
          JORBSH(MAXSHL,IORB) = IA
C
C         find first and last primitive shell
C         contributing to this orbital shell
C
          K = NUMCF(IA)
          JSTR  = IPRVPR(IA)
          IOFF  = NUCA
          ILAST = 0
          DO I = 1,NUCA
            IF (ABS(PRICCF(JSTR+I,K)) .GT. DSM) THEN
              IOFF  = MIN(IOFF,I-1)
              ILAST = MAX(ILAST,I)
            END IF
          END DO
CMI    .... we might get negative value !!!!
          NPRI = ILAST - IOFF
          NUCOSH(MAXSHL) = NPRI
CMI     ... check !!!
          IF (NPRI.LT.0) THEN
            write(LUPRI,*) 'NPRI=',NPRI,' MAXSHL=',MAXSHL
            write(LUPRI,*) 'ILAST,IOFF:',ILAST,IOFF
            write(LUPRI,*) 'DSM:',DSM
            call quit('PAOVE2: negative NPRI ! Decrease DMS !')
          ENDIF 
C
C         set gen.cont. shell info
          NSET       = 1
          KORBSH(MAXSHL,NSET) = IA
          NSETSH(MAXSHL,1) = NSET
          NPRIMS(MAXSHL,NSET,1) = NPRI
          NCONTS(MAXSHL,NSET,1) = 1
          JSTRSH(MAXSHL,NSET,1) = JSTR+IOFF
C
C         as we only use one contracted at a time
C         this can always be treated in code for segm.cont.
          SEGMSH(MAXSHL) = .TRUE.
C
C         set segm.cont. shell info
          NSETSH(MAXSHL,2) = NSET
          NPRIMS(MAXSHL,NSET,2) = NPRI
          NCONTS(MAXSHL,NSET,2) = -K
C      ... used for getting PRICCF(IPRIM,-K)
          JSTRSH(MAXSHL,NSET,2) = JSTR+IOFF
C
        ELSE ! not SEGMEN
C aug2000 hjaaj   Task: which orbital shells should we treat together
C                 with IA in TWOINT ?
C                 if (mxaosh .eq. 0) then
C                    use the blocking specified by user in input
C                 else
C                    try to merge compatible user specified blocks
C                    for higher efficiency in TWOINT
C                 end if
C
C aug2000 th+hjj: the next section can be used to collect
C                 input blocks for efficiency, e.g. by
C                 defining max MXAOSH = 50 in a block;
          IF (MXAOSH .EQ. 0) THEN
            MAXVC = NUCA
C aug2000  ... keep shell blocking from input
          ELSE
             NPRIA = KHKTA * MULT( ISTBSH(MAXSHL) )
C            each primitive gives NPRIA basis functions
             MAXVC = MAX(NUCA, MXAOSH / NPRIA)
C aug2000      we divide by NPRIA so MXAOSH is max number
C              of primitive basis fu. in a shell
          END IF
          NUCSH  = 0
          IORB = 1
          NSET = 0
          LBCH = 0
          DO 210 IB = IA, KMAX
            IF (ORBOUT(IB))                 GO TO 210 ! orbital alrady checked out
            IF (NHKT(IB) .NE. NHKTA)        GO TO 210 ! not the same angular quantum number L+1
            IF (KHKT(IB) .NE. KHKTA)        GO TO 210 ! not the same number of components
            IF (NCENT(IB) .NE. NCENTA)      GO TO 210 ! not the same index of symmetry independent center
            IF (LCLASS(IB).NE.LCLASS(IA))   GO TO 210 ! not the same class (large, small ...)
C
C           Orbital type is correct ..
C
            NUCB  = NUCO(IB) ! number of uncontracted functions
            NBCHB = NBCH(IB) ! index of block in AO-vector
            IF (NBCHB.EQ.LBCH .OR. NUCSH+NUCB.LE.MAXVC) THEN
              ORBOUT(IB) = .TRUE.
              IPTSHL(IB) = MAXSHL
              JORBSH(MAXSHL,IORB) = IB
              IORB       = IORB   + 1
              NAOOUT     = NAOOUT + 1
              IF (NBCHB .NE. LBCH) THEN
                NSET  = NSET + 1
                LBCH  = NBCHB
                NUCSH = NUCSH  + NUCB
                KORBSH(MAXSHL,NSET) = IB
              END IF
            END IF
  210     CONTINUE
          NUCOSH(MAXSHL) = NUCSH
          IF (NUCSH.LT.0) THEN
            write(LUPRI,*) '...NUCSH, indx MAXSHL:',NUCSH,MAXSHL
            call quit('PAOVE2: negative NUCSH !')
          ENDIF
          NSETSH(MAXSHL,1) = NSET
        END IF ! IF(SEGMEN)
        IF (NAOOUT .LT. KMAX) THEN
          GO TO 1000
        ELSE
          GO TO 1100
        END IF
      END IF
  200 CONTINUE
      IF (NAOOUT .LT. KMAX) GO TO 1000
 1100 CONTINUE
C      
      NSMLBL = MAXSHL - NLRGBL
C
C     All orbitals have now been assigned to a shell
C
C
C     Determine NORBSH()
C
      CALL IZERO(NORBSH,MAXSHL)
      DO 300 J = 1, KMAX
        ISHL = IPTSHL(J)
        NORBSH(ISHL) = NORBSH(ISHL) + 1
  300 CONTINUE
C
C     Determine and NSTRSH()
C
C     NSTRSH(1) = 0
C     DO 500 IA = 1,MAXSHL - 1
C        NSTRSH(IA + 1)   = NSTRSH(IA)   + KHKTSH(IA)*NORBSH(IA)
C 500 CONTINUE
C
C     Determine IORBSH(MAXSHL,NORBSH)
C
      DO 810 I = 1, MAXSHL
         DO 820 J = 1, NORBSH(I)
            IORBSH(I,J) = IPRVOR(JORBSH(I,J))
  820    CONTINUE
  810 CONTINUE
C
C     IORBSB()
C
      IORBB = 0
      DO 900 I = 1, MAXSHL
         DO 910 J = 1, NORBSH(I)
            IORBS = IORBSH(I,J)
            DO 920 ICMP = 1, KHKTSH(I)
               IORBSB(IORBS) = IORBB
               IORBB = IORBB + 1
               IORBS = IORBS + 1
  920       CONTINUE
  910    CONTINUE
  900 CONTINUE
      NTOT = IORBB
C
      IF (.NOT. SEGMEN) CALL PAOSET(KORBSH,IPRVPR)
C     ... PAOSET work is done in 200 loop for SEGMEN
C
C     Print Section
C
      IF (IPRINT .GE. 5) THEN
         CALL HEADER('Output from PAOVEC',-1)
         WRITE (LUPRI,'(A,L5)') ' SEGMEN ', SEGMEN
         WRITE (LUPRI,'(A,I5)') ' MAXSHL ', MAXSHL
         WRITE (LUPRI,'(A,(T11,10I5))') ' NHKTSH',(NHKTSH(I),I=1,MAXSHL)
         WRITE (LUPRI,'(A,(T11,10I5))') ' KHKTSH',(KHKTSH(I),I=1,MAXSHL)
         WRITE (LUPRI,'(A,(T11,10L5))') ' SPHRSH',(SPHRSH(I),I=1,MAXSHL)
         WRITE (LUPRI,'(A,(T11,10I5))') ' KCKTSH',(KCKTSH(I),I=1,MAXSHL)
         WRITE (LUPRI,'(A,(T11,10I5))') ' NUCOSH',(NUCOSH(I),I=1,MAXSHL)
         WRITE (LUPRI,'(A,(T11,10I5))') ' NORBSH',(NORBSH(I),I=1,MAXSHL)
C        WRITE (LUPRI,'(A,(T11,10I5))') ' NSTRSH',(NSTRSH(I),I=1,MAXSHL)
         WRITE (LUPRI,'(A,(T11,10I5))') ' IORBSB',(IORBSB(I),I=0,NTOT)
         WRITE (LUPRI,'(A,(T11,10I5))') ' NCNTSH',(NCNTSH(I),I=1,MAXSHL)
         CALL FLSHFO(LUPRI)
         DO 2000 I = 1, MAXSHL
            WRITE (LUPRI,'(A,I5)')'JSTRSH (gen. con.) for ISHELL =',I
            WRITE (LUPRI,'(15I5)')(JSTRSH(I,J,1),J=1,NORBSH(I))
            WRITE (LUPRI,'(A,I5)')'JSTRSH (seg. con.) for ISHELL =',I
            WRITE (LUPRI,'(15I5)')(JSTRSH(I,J,2),J=1,NORBSH(I))
            CALL FLSHFO(LUPRI)
 2000    CONTINUE
         DO 2001 I = 1, MAXSHL
            WRITE (LUPRI,'(A,I5)')'NPRIMS (gen. con.) for ISHELL =',I
            WRITE (LUPRI,'(15I5)')(NPRIMS(I,J,1),J=1,NORBSH(I))
            WRITE (LUPRI,'(A,I5)')'NPRIMS (seg. con.) for ISHELL =',I
            WRITE (LUPRI,'(15I5)')(NPRIMS(I,J,2),J=1,NORBSH(I))
            CALL FLSHFO(LUPRI)
 2001    CONTINUE
         DO 2002 I = 1, MAXSHL
            WRITE (LUPRI,'(A,I5)')'CENTSH for ISHELL =',I
            WRITE (LUPRI,'(3F20.10)')
     *             CENTSH(I,1),CENTSH(I,2),CENTSH(I,3)
            CALL FLSHFO(LUPRI)
 2002    CONTINUE
         DO 2003 I = 1, MAXSHL
            WRITE (LUPRI,'(A,I5,A,I5,A,I5)')
     &            'IORBSH for ISHELL =',I,'/',MAXSHL,
     &            ' and for NORBSH(ISHELL)=',NORBSH(I)
            WRITE (LUPRI,'(15I5)')(IORBSH(I,J),J=1,NORBSH(I))
            CALL FLSHFO(LUPRI)
 2003    CONTINUE
      END IF
      RETURN
      END
#ifdef BIGVEC
C aug2000: th+hjaaj: CORDIF is used for BIGVEC option which is "dead"
C  /* Deck cordif */
      SUBROUTINE CORDIF(NORBA,NORBB,THRESH,D0X,D0Y,D0Z,
     &                  IPRINT,NUCOA,NUCOB,JSTRA,JSTRB)
#include "implicit.h"
#include "priunit.h"
#include "aovec.h"
#include "maxorb.h"
      LOGICAL DIFX, DIFY, DIFZ, D0X, D0Y, D0Z
      DIMENSION NUCOA(*), NUCOB(*), JSTRA(*), JSTRB(*)
#include "primit.h"
C
      DIFX = .FALSE.
      DIFY = .FALSE.
      DIFZ = .FALSE.
C
C     A - A
C
      DO 100 I = 1, NORBA
      DO 100 J = 1, NUCOA(I)
         IJ  = JSTRA(I) + J
         CRX = PRICRX(IJ)
         CRY = PRICRY(IJ)
         CRZ = PRICRZ(IJ)
         DO 200 K = 1, I
         DO 200 L = 1, NUCOA(K)
            KL   = JSTRA(K) + L
            DIFX = DIFX .OR. ABS(PRICRX(KL)-CRX) .GT. THRESH
            DIFY = DIFY .OR. ABS(PRICRY(KL)-CRY) .GT. THRESH
            DIFZ = DIFZ .OR. ABS(PRICRZ(KL)-CRZ) .GT. THRESH
  200    CONTINUE
  100 CONTINUE
C
C     B - B
C
      IF (.NOT.(DIFX .AND. DIFY .AND. DIFZ)) THEN
         DO 300 I = 1, NORBB
         DO 300 J = 1, NUCOB(I)
            IJ  = JSTRB(I) + J
            CRX = PRICRX(IJ)
            CRY = PRICRY(IJ)
            CRZ = PRICRZ(IJ)
            DO 400 K = 1, I
            DO 400 L = 1, NUCOB(K)
               KL   = JSTRB(K) + L
               DIFX = DIFX .OR. ABS(PRICRX(KL)-CRX) .GT. THRESH
               DIFY = DIFY .OR. ABS(PRICRY(KL)-CRY) .GT. THRESH
               DIFZ = DIFZ .OR. ABS(PRICRZ(KL)-CRZ) .GT. THRESH
  400       CONTINUE
  300    CONTINUE
      END IF
C
C     A - B
C
      IF (.NOT.(DIFX .AND. DIFY .AND. DIFZ)) THEN
         DO 500 I = 1, NORBA
         DO 500 J = 1, NUCOA(I)
            IJ  = JSTRA(I) + J
            CRX = PRICRX(IJ)
            CRY = PRICRY(IJ)
            CRZ = PRICRZ(IJ)
            DO 600 K = 1, NORBB
            DO 600 L = 1, NUCOB(K)
               KL   = JSTRB(K) + L
               DIFX = DIFX .OR. ABS(PRICRX(KL)-CRX) .GT. THRESH
               DIFY = DIFY .OR. ABS(PRICRY(KL)-CRY) .GT. THRESH
               DIFZ = DIFZ .OR. ABS(PRICRZ(KL)-CRZ) .GT. THRESH
  600       CONTINUE
  500    CONTINUE
      END IF
      D0X = .NOT.DIFX
      D0Y = .NOT.DIFY
      D0Z = .NOT.DIFZ
C
      IF (IPRINT .LT. 05) RETURN
C
C     *************************
C     ***** PRINT SECTION *****
C     *************************
C
      CALL HEADER('SUBROUTINE CORDIF',-1)
      WRITE (LUPRI, 1010) NORBA, NORBB
      WRITE (LUPRI, 1020) (NUCOA(I), I = 1, NORBA)
      WRITE (LUPRI, 1030) (NUCOB(I), I = 1, NORBB)
      WRITE (LUPRI, 1040) (JSTRA(I), I = 1, NORBA)
      WRITE (LUPRI, 1050) (JSTRB(I), I = 1, NORBB)
      WRITE (LUPRI, 1060) D0X, D0Y, D0Z
 1010 FORMAT(  '  NORB     ',2I7)
 1020 FORMAT(  '  NUCOA:   ',15I7)
 1030 FORMAT(  '  NUCOB:   ',15I7)
 1040 FORMAT(  '  JSTRA:   ',15I7)
 1050 FORMAT(  '  JSTRB:   ',15I7)
 1060 FORMAT(  '  D0X/Y/Z: ',3L5)
      RETURN
      END
#endif
C  /* Deck nintso */
      SUBROUTINE NINTSO(MULE,LONDON,SPNORB,UNDIFF,SOFOCK,DISTRI,SQ12EL,
     &                  IPRINT)
#include "implicit.h"
#include "priunit.h"
#include "mxcent.h"
#include "maxorb.h"
#include "maxaqn.h"
      LOGICAL LONDON, SPNORB, UNDIFF, SOFOCK, DISTRI, SQ12EL
#include "twocom.h"
#include "symmet.h"
#include "dorps.h"
C
      IF (UNDIFF .OR. SOFOCK .OR. DISTRI) THEN
         NINTS     = NMBOSO(SQ12EL,0)
         NINTMX    = NINTS
         NINTSR(1) = NINTS
      ELSE
         NINTS  = 0
         NINTMX = 0
         IRPXYZ = IEOR(ISYMAX(1,1),IEOR(ISYMAX(2,1),ISYMAX(3,1)))
         DO 100 IREPX = 1, NOPREP
            IREPE  = IPTREP(IREPX,1)
            NINTE  = NMBOSO(SQ12EL,IREPE)
            NINTMX = MAX(NINTMX,NINTE)
            NINTSR(IREPX) = NINTE
            NTYPE = 0
            DO 200 ICOOR = 1, 3
               IF (SPNORB) THEN
                 IF(IREPE .EQ. IEOR(ISYMAX(ICOOR,1),IRPXYZ)) THEN
                    NTYPE = NTYPE + 1
                 END IF
               ELSE IF (LONDON) THEN
                 IF(IREPE .EQ. ISYMAX(ICOOR,2)) NTYPE = NTYPE + 2
               ELSE
                 IF(IAND(MULE,IEOR(IREPE,ISYMAX(ICOOR,1))).EQ.0)THEN
                    NTYPE = NTYPE + 1
                 END IF
               END IF
  200       CONTINUE
            NINTS  = NINTS + NTYPE*NINTE
  100    CONTINUE
      END IF
      IF (IPRINT .GT. 5) THEN
         CALL TITLER('Output from NINTSO','*',103)
         WRITE (LUPRI,'(2X,A, I5)') ' NINTS  ', NINTS
         WRITE (LUPRI,'(2X,A,8I5)') ' NINTSR ', (NINTSR(I),I=1,NOPREP)
         WRITE (LUPRI,'(2X,A, I5)') ' NINTMX ', NINTMX
      END IF
      RETURN
      END
C  /* Deck nmboso */
      FUNCTION NMBOSO(SQ12EL,IREPE)
#include "implicit.h"
#include "mxcent.h"
#include "maxaqn.h"
#include "maxorb.h"
      LOGICAL SQ12EL, DCMPAC, DCABAB, NOTEST
#include "twocom.h"
#include "symmet.h"
C
      NOTEST = .NOT.(SHAEQB .OR. SHCEQD .OR. SHABAB)
      IF (NOTEST) THEN
        NMBOSO = 0
        DO 100 NA = 1,KHKTA
          ISA = ISYMAO(NHKTA,NA)
          DO 110 IREPA = 0, MAXREP
          IF (IAND(MULA,IEOR(IREPA,ISA)) .EQ. 0) THEN
            IRPAE = IEOR(IREPA,IREPE)
            DO 200 NB = 1,KHKTB
              ISB = ISYMAO(NHKTB,NB)
              DO 210 IREPB = 0, MAXREP
              IF (IAND(MULB,IEOR(IREPB,ISB)) .EQ. 0) THEN
                IRPABE = IEOR(IREPB,IRPAE)
                DO 300 NC = 1,KHKTC
                  ISC = ISYMAO(NHKTC,NC)
                  DO 410 IREPC = 0, MAXREP
                  IF (IAND(MULC,IEOR(IREPC,ISC)) .EQ. 0) THEN
                    IREPD=IEOR(IREPC,IRPABE)
                    DO 500 ND = 1,KHKTD
                      ISD = ISYMAO(NHKTD,ND)
                      IF (IAND(MULD,IEOR(IREPD,ISD)) .EQ. 0) THEN
                         NMBOSO = NMBOSO + 1
                      END IF
  500               CONTINUE
                  END IF
  410             CONTINUE
  300           CONTINUE
              END IF
  210         CONTINUE
  200       CONTINUE
          END IF
  110     CONTINUE
  100   CONTINUE
      ELSE
        NMBOSO = 0
        DO 600 NA = 1,KHKTA
          ISA = ISYMAO(NHKTA,NA)
          KHKTBB = KHKTB
          IF (DIAGAB) KHKTBB = NA
          DO 610 NB = 1,KHKTBB
            ISB = ISYMAO(NHKTB,NB)
            KHKTCC = KHKTC
            IF (.NOT.SQ12EL .AND. SHABAB) KHKTCC = NA
            DO 620 NC = 1,KHKTCC
              ISC = ISYMAO(NHKTC,NC)
              DCMPAC = SHABAB .AND. NA .EQ. NC
              KHKTDD = KHKTD
              IF (DIAGCD) KHKTDD = NC
              IF (.NOT.SQ12EL .AND. DCMPAC) KHKTDD = NB
              DO 630 ND = 1,KHKTDD
                ISD = ISYMAO(NHKTD,ND)
                DCABAB = .NOT.SQ12EL .AND. DCMPAC .AND. NB .EQ. ND
C
                DO 700 IREPA = 0, MAXREP
                IF (IAND(MULA,IEOR(IREPA,ISA)) .EQ. 0) THEN
                  DO 710 IREPB = 0, MAXREP
                  IF (IAND(MULB,IEOR(IREPB,ISB)) .EQ. 0) THEN
                   DO 720 IREPC = 0, MAXREP
                   IF (IAND(MULC,IEOR(IREPC,ISC)) .EQ. 0) THEN
                   IREPD=IEOR(IEOR(IEOR(IREPA,IREPB),IREPC),IREPE)
                    IF (IAND(MULD,IEOR(IREPD,ISD)) .EQ. 0) THEN
                     IF (.NOT.(DCABAB .AND. (IREPA .LT. IREPC .OR.
     &                  (IREPA.EQ.IREPC .AND. IREPB.LT.IREPD)))) THEN
                         NMBOSO = NMBOSO + 1
                     END IF
                    END IF
                   END IF
  720              CONTINUE
                  END IF
  710             CONTINUE
                END IF
  700           CONTINUE
C
  630         CONTINUE
  620       CONTINUE
  610     CONTINUE
  600   CONTINUE
      END IF
      RETURN
      END
C  /* Deck intder */
      SUBROUTINE INTDER(AOINT,NCCINT,NINTYP,WORK,LWORK,COEFAB,COEFCD,
     &                  COORAB,COORCD,EXPAB,EXPCD,FACAB,FACCD,CONTA,
     &                  CONTB,CONTC,CONTD,IPRINT,NOINT,NOCONT,SPNORB,
     &                  MAXDER,THRESH,JMAX0,ISMXYZ,ONECEN,NPCOA,NPCOB,
     &                  NPCOC,NPCOD,NUCSAB,NUCSCD,SIGNT,IODDHR,INDHSQ,
     &                  INDHER,LMNVLS,NPNTAB,NPNTCD,NREDAB,NREDCD)
#include "implicit.h"
#include "priunit.h"
#include "maxaqn.h"
      LOGICAL NOINT, NOCONT, SPNORB, ONECEN
      DIMENSION AOINT(NCCINT,NINTYP), INDHSQ(*), IODDHR(*),
     &          WORK(LWORK), COEFAB(*), COEFCD(*), COORAB(*), COORCD(*),
     &          EXPAB(*), EXPCD(*), FACAB(*), FACCD(*), LMNVLS(*),
     &          CONTA(*), CONTB(*), CONTC(*), CONTD(*),
     &          NPCOA(*), NPCOB(*), NPCOC(*), NPCOD(*),
     &          NUCSAB(*), NUCSCD(*), SIGNT(*), INDHER(*),
     &          NPNTAB(*), NPNTCD(*), NREDAB(*), NREDCD(*)
#include "twocom.h"
#include "twosta.h"
      IF (IPRINT .GT. 5) CALL TITLER('Output from INTDER','*',103)
      CALL QENTER('INTDER')
#include "memint.h"
C
      JMAX   = JMAX0 + MAXDER
      NUABCD = NUCAB*NUCCD
      NRTUV  = (JMAX + 1)**3
      NTUV   = (JMAX + 1)*(JMAX + 2)*(JMAX + 3)/6
C
C     Allocate work space for Hermite integrals
C
      LHRINT = NUABCD*NTUV
      CALL MEMGET('REAL',KHRINT,LHRINT,WORK,KFREE,LFREE)
      MWHRIN = MAX(MWHRIN,LHRINT)
      LWTOT  = LWTOT + KFREE - 1
      MWTOT  = MAX(MWTOT,LWTOT)
      CALL INTDR1(AOINT,NCCINT,NINTYP,WORK(KHRINT),INDHER,NTUV,COEFAB,
     &            COEFCD,COORAB,COORCD,EXPAB,EXPCD,FACAB,FACCD,CONTA,
     &            CONTB,CONTC,CONTD,WORK(KFREE),LFREE,NUABCD,IPRINT,
     &            NOINT,NOCONT,SPNORB,MAXDER,THRESH,JMAX,ISMXYZ,
     &            ONECEN,NPCOA,NPCOB,NPCOC,NPCOD,NUCSAB,NUCSCD,
     &            SIGNT,INDHSQ,IODDHR,LMNVLS,NPNTAB,NPNTCD,
     &            NREDAB,NREDCD)
      LWTOT  = LWTOT - KFREE + 1
      CALL MEMREL('INTDER',WORK,KWORK,KWORK,KFREE,LFREE)
      CALL QEXIT('INTDER')
      RETURN
      END
C  /* Deck intdr1 */
      SUBROUTINE INTDR1(AOINT,NCCINT,NINTYP,HERINT,INDHER,NTUV,COEFAB,
     &                  COEFCD,COORAB,COORCD,EXPAB,EXPCD,FACAB,FACCD,
     &                  CONTA,CONTB,CONTC,CONTD,WORK,LWORK,NUABCD,
     &                  IPRINT,NOINT,NOCONT,SPNORB,MAXDER,THRESH,
     &                  JMAX,ISMXYZ,ONECEN,NPCOA,NPCOB,NPCOC,NPCOD,
     &                  NUCSAB,NUCSCD,SIGNT,INDHSQ,IODDHR,LMNVLS,
     &                  NPNTAB,NPNTCD,NREDAB,NREDCD)
C
C     tuh
C
#include "implicit.h"
#include "priunit.h"
#include "maxaqn.h"
      LOGICAL NOINT,NOCONT,SPNORB,PQSYM,ONECEN
      DIMENSION HERINT(NUABCD,NTUV), INDHER(*),
     &          AOINT(NCCINT,NINTYP), WORK(LWORK),
     &          COEFAB(*), COEFCD(*), COORAB(*), COORCD(*),
     &          EXPAB(*), EXPCD(*), FACAB(*), FACCD(*),
     &          CONTA(*), CONTB(*), CONTC(*), CONTD(*),
     &          NPCOA(NSETA,2), NPCOB(NSETB,2),
     &          NPCOC(NSETC,2), NPCOD(NSETD,2),
     &          NUCSAB(*), NUCSCD(*), SIGNT(*),
     &          INDHSQ(*), IODDHR(NRTOP,0:7),
     &          LMNVLS(KCKMAX,5,4),
     &          NPNTAB(*), NPNTCD(*), NREDAB(*), NREDCD(*)
#include "hertop.h"
#include "ccom.h"
#include "twocom.h"
#include "twosta.h"
#include "twoao.h"
#include "crossd.h"
#include "subdir.h"
C
      IF (IPRINT .GT. 5) CALL TITLER('Output from INTDR1','*',103)
C
C     ***************************************
C     ********** Hermite Integrals **********
C     ***************************************
C
      NOINT = .FALSE.
      IF (.NOT.DPATH1) THEN
         CALL HR2DRV(HERINT,INDHER,COORCD,COORAB,EXPCD,EXPAB,FACCD,
     &               FACAB,NTUV,WORK,LWORK,JMAX,MAXDER,NUABCD,IPQ0X,
     &               IPQ0Y,IPQ0Z,NOINT,ONECEN,NUCC,NUCD,NUCCD,NUCA,NUCB,
     &               NUCAB,THRESH,IPRINT,SIGNT,IODDHR(1,ISMXYZ))
      ELSE
         CALL HR2DRV(HERINT,INDHER,COORAB,COORCD,EXPAB,EXPCD,FACAB,
     &               FACCD,NTUV,WORK,LWORK,JMAX,MAXDER,NUABCD,IPQ0X,
     &               IPQ0Y,IPQ0Z,NOINT,ONECEN,NUCA,NUCB,NUCAB,NUCC,NUCD,
     &               NUCCD,THRESH,IPRINT,SIGNT,IODDHR(1,ISMXYZ))
      END IF
C
C     *****************************************
C     ********** Cartesian Integrals **********
C     *****************************************
C
      IHRSYM = ISMXYZ
      KCKMX  = KCKMAX
      NOCNT  = NOCONT
      IDERIV = MAXDER
      JM1234 = JMAX
      NU1234 = NUABCD
      NC1234 = NCCINT
      SPIORB = SPNORB
      IF (.NOT.NOINT) THEN
         IF (NOCONT) THEN
            NRBA  = NUCA
            NRBB  = NUCB
            NRBC  = NUCC
            NRBD  = NUCD
         ELSE
            NRBA  = NORBA
            NRBB  = NORBB
            NRBC  = NORBC
            NRBD  = NORBD
         END IF
         CALL DZERO(AOINT,NCCINT*NINTYP)
         IF (DPATH1) THEN
            IF (TKTIME) TIMSTR = SECOND()
            IPATH  = 1
            PATH1  = .TRUE.
            NHKT1  = NHKTA
            NHKT2  = NHKTB
            NHKT3  = NHKTC
            NHKT4  = NHKTD
            KCKT1  = KCKTA
            KCKT2  = KCKTB
            KCKT3  = KCKTC
            KCKT4  = KCKTD
            KCKT12 = KCKTAB
            KCKT34 = KCKTCD
            KHKT1  = KHKTA
            KHKT2  = KHKTB
            KHKT3  = KHKTC
            KHKT4  = KHKTD
            KHKT12 = KHKTAB
            KHKT34 = KHKTCD
            NORB1  = NRBA
            NORB2  = NRBB
            NORB3  = NRBC
            NORB4  = NRBD
            NORR1  = ISUM(NSETA,NPCOA(1,2),1)
            NORR2  = ISUM(NSETB,NPCOB(1,2),1)
            NORR3  = ISUM(NSETC,NPCOC(1,2),1)
            NORR4  = ISUM(NSETD,NPCOD(1,2),1)
            NORB12 = NORBAB
            NORB34 = NORBCD
            NUC1   = NUCA
            NUC2   = NUCB
            NUC3   = NUCC
            NUC4   = NUCD
            NUC12  = NUCAB
            NUC34  = NUCCD
            NUCR1  = ISUM(NSETA,NPCOA(1,1),1)
            NUCR2  = ISUM(NSETB,NPCOB(1,1),1)
            NUCR3  = ISUM(NSETC,NPCOC(1,1),1)
            NUCR4  = ISUM(NSETD,NPCOD(1,1),1)
            MXUC12 = MXUCAB
            MXUC34 = MXUCCD
            NSET1  = NSETA
            NSET2  = NSETB
            NSET3  = NSETC
            NSET4  = NSETD
            MAX12  = MAXAB
            MAX34  = MAXCD
            JMAX1  = JMAXA
            JMAX2  = JMAXB
            JMAX3  = JMAXC
            JMAX4  = JMAXD
            TPRI12 = TPRIAB
            TPRI34 = TPRICD
            TCON12 = TCONAB
            TCON34 = TCONCD
            DIAG12 = DIAGAB
            DIAG34 = DIAGCD
            DIAC12 = DIACAB
            DIAC34 = DIACCD
            I120X  = IAB0X
            I120Y  = IAB0Y
            I120Z  = IAB0Z
            I340X  = ICD0X
            I340Y  = ICD0Y
            I340Z  = ICD0Z
            NO1234 = NOABCD
            GEN12  = GENAB
            GEN34  = GENCD
            RPRI12 = RPRIAB
            RPRI34 = RPRICD
            RCNT12 = RCNTAB
            RCNT34 = RCNTCD
            SPHR1  = SPHRA
            SPHR2  = SPHRB
            SPHR3  = SPHRC
            SPHR4  = SPHRD
            SPHR12 = SPHRAB
            SPHR34 = SPHRCD
            DC10   = DC101
            DC1E   = DC1E1
            DC2H   = DC2H1
            DC2E   = DC2E1
            CROSS  = CROSS1
            MAX34D = MAX34 + IDERIV
            NTUV34 = (MAX34D + 1)*(MAX34D + 2)*(MAX34D + 3)/6
            MAX34D = MAX34 + IDERIV - 1
            KTUV34 = (MAX34D + 1)*(MAX34D + 2)*(MAX34D + 3)/6
            NCCPP  = NORB12*NUC34
            CALL CCDRIV(AOINT,NCCINT,HERINT,INDHER,COEFAB,COEFCD,CONTA,
     &                  CONTB,CONTC,CONTD,WORK,LWORK,IPRINT,NPCOA,NPCOB,
     &                  NPCOC,NPCOD,NUCSAB,NUCSCD,INDHSQ,
     &                  IODDHR(1,ISMXYZ),LMNVLS(1,1,1),LMNVLS(1,1,3),
     &                  NPNTAB,NPNTCD,NREDAB,NREDCD)
            IF (TKTIME) TPATH1 = TPATH1 + SECOND() - TIMSTR
         END IF
         IF (DPATH2) THEN
            IF (TKTIME) TIMSTR = SECOND()
            IPATH  = 2
            PATH1  = .FALSE.
            NHKT1  = NHKTC
            NHKT2  = NHKTD
            NHKT3  = NHKTA
            NHKT4  = NHKTB
            KCKT1  = KCKTC
            KCKT2  = KCKTD
            KCKT3  = KCKTA
            KCKT4  = KCKTB
            KCKT12 = KCKTCD
            KCKT34 = KCKTAB
            KHKT1  = KHKTC
            KHKT2  = KHKTD
            KHKT3  = KHKTA
            KHKT4  = KHKTB
            KHKT12 = KHKTCD
            KHKT34 = KHKTAB
            NORB1  = NRBC
            NORB2  = NRBD
            NORB3  = NRBA
            NORB4  = NRBB
            NORR1  = ISUM(NSETC,NPCOC(1,2),1)
            NORR2  = ISUM(NSETD,NPCOD(1,2),1)
            NORR3  = ISUM(NSETA,NPCOA(1,2),1)
            NORR4  = ISUM(NSETB,NPCOB(1,2),1)
            NORB12 = NORBCD
            NORB34 = NORBAB
            NUC1   = NUCC
            NUC2   = NUCD
            NUC3   = NUCA
            NUC4   = NUCB
            NUCR1  = ISUM(NSETC,NPCOC(1,1),1)
            NUCR2  = ISUM(NSETD,NPCOD(1,1),1)
            NUCR3  = ISUM(NSETA,NPCOA(1,1),1)
            NUCR4  = ISUM(NSETB,NPCOB(1,1),1)
            NUC12  = NUCCD
            NUC34  = NUCAB
            MXUC12 = MXUCCD
            MXUC34 = MXUCAB
            NSET1  = NSETC
            NSET2  = NSETD
            NSET3  = NSETA
            NSET4  = NSETB
            MAX12  = MAXCD
            MAX34  = MAXAB
            JMAX1  = JMAXC
            JMAX2  = JMAXD
            JMAX3  = JMAXA
            JMAX4  = JMAXB
            TPRI12 = TPRICD
            TPRI34 = TPRIAB
            TCON12 = TCONCD
            TCON34 = TCONAB
            DIAG12 = DIAGCD
            DIAG34 = DIAGAB
            DIAC12 = DIACCD
            DIAC34 = DIACAB
            I120X  = ICD0X
            I120Y  = ICD0Y
            I120Z  = ICD0Z
            I340X  = IAB0X
            I340Y  = IAB0Y
            I340Z  = IAB0Z
            NO1234 = NOABCD
            GEN12  = GENCD
            GEN34  = GENAB
            RPRI12 = RPRICD
            RPRI34 = RPRIAB
            RCNT12 = RCNTCD
            RCNT34 = RCNTAB
            SPHR1  = SPHRC
            SPHR2  = SPHRD
            SPHR3  = SPHRA
            SPHR4  = SPHRB
            SPHR12 = SPHRCD
            SPHR34 = SPHRAB
            DC10   = DC102
            DC1E   = DC1E2
            DC2H   = DC2H2
            DC2E   = DC2E2
            CROSS  = CROSS2
            IF (DPATH1) THEN
               CALL HERSWP(HERINT,NTUV,NUABCD,WORK,LWORK,JMAX,NUCAB,
     &                     NUCCD,IPRINT)
            END IF
            MAX34D = MAX34 + IDERIV
            NTUV34 = (MAX34D + 1)*(MAX34D + 2)*(MAX34D + 3)/6
            MAX34D = MAX34 + IDERIV - 1
            KTUV34 = (MAX34D + 1)*(MAX34D + 2)*(MAX34D + 3)/6
            NCCPP  = NORB12*NUC34
            CALL CCDRIV(AOINT,NCCINT,HERINT,INDHER,COEFCD,COEFAB,CONTC,
     &                  CONTD,CONTA,CONTB,WORK,LWORK,IPRINT,NPCOC,NPCOD,
     &                  NPCOA,NPCOB,NUCSCD,NUCSAB,INDHSQ,
     &                  IODDHR(1,ISMXYZ),LMNVLS(1,1,3),LMNVLS(1,1,1),
     &                  NPNTCD,NPNTAB,NREDCD,NREDAB)
            IF (TKTIME) TPATH2 = TPATH2 + SECOND() - TIMSTR
          END IF
      END IF
      RETURN
      END
C  /* Deck ccdriv */
      SUBROUTINE CCDRIV(AOINT,NCCINT,HERINT,INDHER,COEF12,COEF34,CONT1,
     &                  CONT2,CONT3,CONT4,WORK,LWORK,IPRINT,NPCO1,NPCO2,
     &                  NPCO3,NPCO4,NUCS12,NUCS34,INDHSQ,IODDHR,
     &                  LMNV12,LMNV34,NPNT12,NPNT34,NRED12,NRED34)
C
#include "implicit.h"
#include "priunit.h"
#include "maxaqn.h"
      DIMENSION HERINT(NU1234,*), INDHER(*), AOINT(NCCINT,*),
     &          WORK(LWORK), COEF12(*), COEF34(*),
     &          CONT1(NORB1*NUC1,2), CONT2(NORB2*NUC2,2),
     &          CONT3(NORB3*NUC3,2), CONT4(NORB4*NUC4,2),
     &          NPCO1(*), NPCO2(*), NPCO3(*), NPCO4(*),
     &          INDHSQ(*), IODDHR(*), NPNT12(*), NPNT34(*),
     &          LMNV12(KCKMX,5,2), LMNV34(KCKMX,5,2),
     &          NRED12(*), NRED34(*), NUCS12(*), NUCS34(*)
#include "twoao.h"
#include "crsdir.h"
#include "twosta.h"
C
      CALL QENTER('CCDRIV')
#include "memint.h"
      IF (IPRINT .GT. 5) CALL TITLER('Output from CCDRIV','*',103)
C
C     Allocations
C
      NHCINT = 0
      IF (DC10) NHCINT = NHCINT + 1
      IF (DC1E) THEN
         IF (DHCEX1) NHCINT = NHCINT + 1
         IF (DHCEX2) NHCINT = NHCINT + 1
         IF (DHCEY1) NHCINT = NHCINT + 1
         IF (DHCEY2) NHCINT = NHCINT + 1
         IF (DHCEZ1) NHCINT = NHCINT + 1
         IF (DHCEZ2) NHCINT = NHCINT + 1
      END IF
      LHCINT = NCCPP*NTUV34*KHKT12*NHCINT
C
      CALL MEMGET('INTE',KODD12,2*KCKT12,WORK,KFREE,LFREE)
      CALL MEMGET('INTE',KODD34,2*KCKT34,WORK,KFREE,LFREE)
      CALL MEMGET('REAL',KHCINT,LHCINT  ,WORK,KFREE,LFREE)
      MWHCIN = MAX(MWHCIN,LHCINT)
      LWTOT  = LWTOT + KFREE - 1
      MWTOT  = MAX(MWTOT,LWTOT)
C
      CALL GETODA(WORK(KODD12),WORK(KODD34),LMNV12,LMNV34,IPRINT)
      IF (.NOT. GEN12) THEN
C     ... 980826-hjaaj: check if no contraction
         NOCNT = .TRUE.
         DO IJ = 1,NORB12
            IF (NUCS12(IJ) .NE. 1) THEN
               NOCNT = .FALSE.
               GO TO 100
            END IF
         END DO
  100    IF (IPRINT .GT. 5) WRITE (LUPRI,*) 'NOCNT for C1DRIV:', NOCNT
      ELSE
         NOCNT = .FALSE.
      END IF
      CALL C1DRIV(HERINT,INDHER,WORK(KHCINT),COEF12,CONT1(1,2),
     &            CONT2(1,2),WORK(KFREE),LFREE,NPCO1,NPCO2,NUCS12,
     &            INDHSQ,
     &            IODDHR,IPRINT,LMNV12,WORK(KODD12),NPNT12,NRED12,
     &            NHCINT)
      IF (.NOT. GEN34) THEN
C     ... 980826-hjaaj: check if no contraction
         NOCNT = .TRUE.
         DO IJ = 1,NORB34
            IF (NUCS34(IJ) .NE. 1) THEN
               NOCNT = .FALSE.
               GO TO 200
            END IF
         END DO
  200    IF (IPRINT .GT. 5) WRITE (LUPRI,*) 'NOCNT for C2DRIV:', NOCNT
      ELSE
         NOCNT = .FALSE.
      END IF
      CALL C2DRIV(AOINT,WORK(KHCINT),COEF34,INDHER,CONT3,CONT4,
     &            WORK(KFREE),LFREE,NPCO3,NPCO4,NUCS34,IPRINT,LMNV12,
     &            LMNV34,WORK(KODD12),WORK(KODD34),NPNT34,NRED34)
C
      LWTOT = LWTOT - KFREE + 1
      CALL MEMREL('CCDRIV',WORK,KWORK,KWORK,KFREE,LFREE)
 999  CONTINUE
      CALL QEXIT('CCDRIV')
      RETURN
      END
#ifdef NOT_USED
C  /* Deck ndistr */
      FUNCTION NDISTR(INDXAB,MAXDIS,IPRINT)
C
#include "implicit.h"
#include "priunit.h"
#include "maxorb.h"
#include "mxcent.h"
#include "maxaqn.h"
      LOGICAL DCMPAB
      DIMENSION INDXAB(MAXDIS)
#include "twocom.h"
#include "symmet.h"
C
      IF (IPRINT .GT. 6) CALL HEADER('Subroutine NDISTR',-1)
C
      IJ = 0
C
C     Loop over components
C
      DO 100 NA = 1,KHKTA
         NSTRNA = NSTRA + NA
         ITYNA  = ISYMAO(NHKTA,NA)
         KHKTBB = KHKTB
         IF (DIAGAB) KHKTBB = NA
         DO 200 NB = 1,KHKTBB
            NSTRNB = NSTRB + NB
            ITYNB  = ISYMAO(NHKTB,NB)
            DCMPAB = SHAEQB .AND. NA .EQ. NB
C
C           Loop over symmetries
C
            DO 300 IREPA = 0, MAXREP
            IF (IAND(MULA,IEOR(IREPA,ITYNA)) .EQ. 0) THEN
               DO 400 IREPB = 0, MAXREP
               IF (IAND(MULB,IEOR(IREPB,ITYNB)) .EQ. 0) THEN
C
C                 Loop over contracted orbitals
C
                  DO 500 IA = 1,NORBA
                     INDA = IPTSYM(NSTRNA + KHKTA*(IA-1),IREPA)
                     NORBBB = NORBB
                     IF (DCMPAB) NORBBB = IA
                     IF (DCMPAB .AND. IREPA.LT.IREPB) NORBBB = IA - 1
                     DO 600 IB = 1,NORBBB
                        IJ = IJ + 1
                        INDB = IPTSYM(NSTRNB+KHKTB*(IB-1),IREPB)
                        MAXAB = MAX(INDA,INDB)
                        INDXAB(IJ) = MAXAB*(MAXAB-1)/2 + MIN(INDA,INDB)
 600                 CONTINUE
 500              CONTINUE
C
               END IF
 400           CONTINUE
            END IF
 300        CONTINUE
C
 200     CONTINUE
 100  CONTINUE
      NDISTR = IJ
      IF (NDISTR .GT. MAXDIS) THEN
         WRITE (LUPRI,'(1X,A)')    ' Too many distributions in NDISTR.'
         WRITE (LUPRI,'(1X,A,I5)') ' Number of distributions:',NDISTR
         WRITE (LUPRI,'(1X,A,I5)') ' Maximum allowed:        ',MAXDIS
         CALL QUIT('Too many distributions required in NDISTR')
      END IF
      RETURN
      END
#endif
C  /* Deck paoset */
      SUBROUTINE PAOSET(KORBSH,IPRVPR)
#include "implicit.h"
#include "maxorb.h"
#include "aovec.h"
      PARAMETER (DSM = 1.0D-10)
C
      DIMENSION KORBSH(KMAX,MXAOVC), IPRVPR(KMAX)
C
#include "shells.h"
#include "blocks.h"
#include "primit.h"
C
C     Parameters for sets of primitives
C     =================================
C
C     Determine NPRIMS(MAXSHL,NSETSH,2), NCONTS(MAXSHL,NSETSH,2),
C           and JSTRSH(MAXSHL,NSETSH,2)
C
      DO 200 I = 1, MAXSHL
         DO 300 J = 1, NSETSH(I,1)
            NPRIMS(I,J,1) = NUCO  (KORBSH(I,J))
            NCONTS(I,J,1) = NRCO  (KORBSH(I,J))
            JSTRSH(I,J,1) = IPRVPR(KORBSH(I,J))
  300    CONTINUE
C
C           Segmented transformation matrix: Each contracted is one set
C
         IF (SEGMSH(I)) THEN
            ISET = 0
            DO 600 J = 1, NSETSH(I,1)
               JSTR = IPRVPR(KORBSH(I,J))
               NPRS = NUCO(KORBSH(I,J))
               NCRS = NRCO(KORBSH(I,J))
               IOFF = JSTR
               DO 700 K = 1, NCRS
                  ISET = ISET + 1
                  NPRI = NDXGTA(NPRS,DSM,PRICCF(JSTR+1,K),1)
                  NPRIMS(I,ISET,2) = NPRI
                  NCONTS(I,ISET,2) = -K
                  JSTRSH(I,ISET,2) = IOFF
                  IOFF = IOFF + NPRI
  700          CONTINUE
  600       CONTINUE
            NSETSH(I,2) = ISET
         END IF
  200 CONTINUE
      RETURN
      END
C  /* Deck cprlop */
      SUBROUTINE CPRLOP(IPNTAO,IPNTOP,IPNTNO,IPNTRP,IPNTLG,SQ12EL,
     &                  IPRINT)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C
C     Called from GABDR2
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
#include "implicit.h"
#include "priunit.h"
#include "maxaqn.h"
#include "maxorb.h"
#include "mxcent.h"
      LOGICAL SQ12EL, DCMPAB, DCMPCD, DCABAB, IPNTLG(3,NINTMX,*)
      DIMENSION IPNTAO(NINTMX,*), IPNTOP(3,NINTMX,*),
     &          IPNTNO(4,NINTMX,*), IPNTRP(3,NINTMX,*)
#include "twocom.h"
#include "symmet.h"
C
      IF (IPRINT .GT. 5) THEN
        CALL TITLER('Output from CPRLOP','*',103)
        IF (IPRINT .GT. 10) THEN
          WRITE (LUPRI,'(2X,A,4I5)')'NHKT?     ',NHKTA,NHKTB,NHKTC,NHKTD
          WRITE (LUPRI,'(2X,A,4I5)')'KHKT?     ',KHKTA,KHKTB,KHKTC,KHKTD
          WRITE (LUPRI,'(2X,A,4I5)')'MUL?      ',MULA,MULB,MULC,MULD
          WRITE (LUPRI,'(2X,A,2L5)')'DIAGAB/CD ',DIAGAB,DIAGCD
          WRITE (LUPRI,'(2X,A, L5)')'SQ12EL    ',SQ12EL
          WRITE (LUPRI,'(2X,A, I5)')'NOABCD    ',NOABCD
          WRITE (LUPRI,'(2X,A, I5)')'NOPREP    ',NOPREP
          CALL FLSHFO(LUPRI)
        END IF
      END IF
      DO 100 IREPX = 1, NOPREP
      IREPE = IPTREP(IREPX,1)
      IF (.NOT.(SHAEQB .OR. SHCEQD .OR. SHABAB)) THEN
         IAOFF = 1
         ISOFF = 1
         DO 200 ICOMPA = 1,KHKTA
           ITYNA  = ISYMAO(NHKTA,ICOMPA)
           NSTRNA = NSTRA + ICOMPA
         DO 200 ICOMPB = 1,KHKTB
           ITYNB  = ISYMAO(NHKTB,ICOMPB)
           NSTRNB = NSTRB + ICOMPB
         DO 200 ICOMPC = 1,KHKTC
           ITYNC  = ISYMAO(NHKTC,ICOMPC)
           NSTRNC = NSTRC + ICOMPC
         DO 200 ICOMPD = 1,KHKTD
           ITYND  = ISYMAO(NHKTD,ICOMPD)
           NSTRND = NSTRD + ICOMPD
           DO 300 IREPA = 0, MAXREP
           IF (IAND(MULA,IEOR(IREPA,ITYNA)) .EQ. 0) THEN
             IRPAE = IEOR(IREPA,IREPE)
             DO 310 IREPB = 0, MAXREP
             IF (IAND(MULB,IEOR(IREPB,ITYNB)) .EQ. 0) THEN
               IRPABE = IEOR(IREPB,IRPAE)
               IRPTYB = IEOR(IREPB,ITYNB)
               DO 320 IREPC = 0, MAXREP
               IF (IAND(MULC,IEOR(IREPC,ITYNC)) .EQ. 0) THEN
                 IREPD = IEOR(IREPC,IRPABE)
                 IF (IAND(MULD,IEOR(IREPD,ITYND)) .EQ. 0) THEN
                   IPNTAO(ISOFF,IREPX)   = IAOFF
                   IPNTOP(1,ISOFF,IREPX) = IRPTYB
                   IPNTOP(2,ISOFF,IREPX) = IEOR(IREPC,ITYNC)
                   IPNTOP(3,ISOFF,IREPX) = IEOR(IREPD,ITYND)
                   IPNTNO(1,ISOFF,IREPX) = NSTRNA
                   IPNTNO(2,ISOFF,IREPX) = NSTRNB
                   IPNTNO(3,ISOFF,IREPX) = NSTRNC
                   IPNTNO(4,ISOFF,IREPX) = NSTRND
                   IPNTRP(1,ISOFF,IREPX) = IREPA
                   IPNTRP(2,ISOFF,IREPX) = IREPB
                   IPNTRP(3,ISOFF,IREPX) = IREPC
                   ISOFF = ISOFF + 1
                 END IF
               END IF
  320          CONTINUE
             END IF
  310        CONTINUE
           END IF
  300      CONTINUE
           IAOFF = IAOFF + 1
  200    CONTINUE
      ELSE
         IAOFF = 1
         ISOFF = 1
         DO 400 ICOMPA = 1,KHKTA
           ITYNA  = ISYMAO(NHKTA,ICOMPA)
           NSTRNA = NSTRA + ICOMPA
           KHKTBB = KHKTB
           IF (DIAGAB) KHKTBB = ICOMPA
         DO 400 ICOMPB = 1,KHKTBB
           ITYNB  = ISYMAO(NHKTB,ICOMPB)
           NSTRNB = NSTRB + ICOMPB
         DO 400 ICOMPC = 1,KHKTC
           ITYNC  = ISYMAO(NHKTC,ICOMPC)
           NSTRNC = NSTRC + ICOMPC
           KHKTDD = KHKTD
           IF (DIAGCD) KHKTDD = ICOMPC
         DO 400 ICOMPD = 1,KHKTDD
           IF (SQ12EL .OR. .NOT.(SHABAB .AND. (ICOMPA .LT. ICOMPC .OR.
     &         (ICOMPA .EQ. ICOMPC .AND. ICOMPB .LT. ICOMPD)))) THEN
             ITYND  = ISYMAO(NHKTD,ICOMPD)
             NSTRND = NSTRD + ICOMPD
             DCMPAB = SHAEQB.AND.ICOMPA.EQ.ICOMPB
             DCMPCD = SHCEQD.AND.ICOMPC.EQ.ICOMPD
             DCABAB = .NOT.SQ12EL .AND. SHABAB .AND.
     &                ICOMPA.EQ.ICOMPC .AND. ICOMPB.EQ.ICOMPD
             DO 500 IREPA = 0, MAXREP
             IF (IAND(MULA,IEOR(IREPA,ITYNA)) .EQ. 0) THEN
               IRPAE = IEOR(IREPA,IREPE)
               DO 510 IREPB = 0, MAXREP
               IF (IAND(MULB,IEOR(IREPB,ITYNB)) .EQ. 0) THEN
                 IRPABE = IEOR(IREPB,IRPAE)
                 IRPTYB = IEOR(IREPB,ITYNB)
                 DO 520 IREPC = 0, MAXREP
                 IF (IAND(MULC,IEOR(IREPC,ITYNC)) .EQ. 0) THEN
                   IREPD = IEOR(IREPC,IRPABE)
                   IF (IAND(MULD,IEOR(IREPD,ITYND)) .EQ. 0) THEN
                   IF (.NOT.(DCABAB .AND. (IREPA .LT. IREPC .OR.
     &               (IREPA.EQ.IREPC .AND. IREPB.LT.IREPD)))) THEN
                     IPNTAO(ISOFF,IREPX)   = IAOFF
                     IPNTOP(1,ISOFF,IREPX) = IRPTYB
                     IPNTOP(2,ISOFF,IREPX) = IEOR(IREPC,ITYNC)
                     IPNTOP(3,ISOFF,IREPX) = IEOR(IREPD,ITYND)
                     IPNTNO(1,ISOFF,IREPX) = NSTRNA
                     IPNTNO(2,ISOFF,IREPX) = NSTRNB
                     IPNTNO(3,ISOFF,IREPX) = NSTRNC
                     IPNTNO(4,ISOFF,IREPX) = NSTRND
                     IPNTRP(1,ISOFF,IREPX) = IREPA
                     IPNTRP(2,ISOFF,IREPX) = IREPB
                     IPNTRP(3,ISOFF,IREPX) = IREPC
                     IPNTLG(1,ISOFF,IREPX) = DCMPAB
                     IPNTLG(2,ISOFF,IREPX) = DCMPCD
                     IPNTLG(3,ISOFF,IREPX) = DCABAB
                     ISOFF = ISOFF + 1
                   END IF
                   END IF
                 END IF
  520            CONTINUE
               END IF
  510          CONTINUE
             END IF
  500        CONTINUE
           END IF
           IAOFF = IAOFF + 1
  400    CONTINUE
      END IF
  100 CONTINUE
C
      IF (IPRINT .GT. 10) THEN
        WRITE(LUPRI,'(2X,A)') '...reached end of CPRLOP'
        CALL FLSHFO(LUPRI)
      ENDIF
C
      RETURN
      END
C  /* Deck twoper */
      SUBROUTINE TWOPER
#include "implicit.h"
#include "priunit.h"
#include "mxcent.h"
#include "maxaqn.h"
      PARAMETER (DMEGA = 1.0D6)
#include "twosta.h"
#include "nuclei.h"
      ITRI(I) = I*(I + 1)/2
C
      CALL HEADER('Performance of TWOINT',1)
      N2CART = ITRI(NBASIS)
      N2CART = ITRI(N2CART)
      N2PRIM = ITRI(NPBAS)
      N2PRIM = ITRI(N2PRIM)
      WRITE (LUPRI,'(2(2X,A,I4,/),/,3(2X,A,I10,/))')
     &   'Number of contracted functions:',NBASIS,
     &   'Number of primitive  functions:',NPBAS,
     &   'Number of integrals written                    :',N2WRIT,
     &   'Number of contracted integrals (counting zeros):',N2CART,
     &   'Number of primitive integrals (counting zeros) :',N2PRIM
      IF (N2WRIT .GT. 0) THEN
         PRFNON = DMEGA*T2INT/dble(N2WRIT)
         PRFCAR = DMEGA*T2INT/dble(N2CART)
         PRFPRM = DMEGA*T2INT/dble(N2PRIM)
         WRITE (LUPRI,'(3(/,2X,A,F7.1,A))')
     &      'Average time for non-zero (written) integrals:',
     &       PRFNON,' microseconds',
     &      'Average time for zero/non-zero integrals     :',
     &       PRFCAR,' microseconds',
     &      'Average time for primitive integrals         :',
     &       PRFPRM,' microseconds'
      ELSE
         PRFCAR = DMEGA*T2INT/dble(N2CART)
         PRFPRM = DMEGA*T2INT/dble(N2PRIM)
         WRITE (LUPRI,'(2(/,2X,A,F7.1,A))')
     &      'Average time for zero/non-zero integrals     :',
     &       PRFCAR,' microseconds',
     &      'Average time for primitive integrals         :',
     &       PRFPRM,' microseconds'
      END IF
      RETURN
      END
C  /* Deck delsta */
      SUBROUTINE DELSTA(ITYPE,ICOUNT)
#include "implicit.h"
#include "priunit.h"
#include "maxaqn.h"
      PARAMETER (D0 = 0.D0, D100 = 100.0D0, DMEGA = 1.D6)
      CHARACTER*1 SPDCAR
      DIMENSION TMEINT(MXQN,MXQN,MXQN,MXQN), INTWRT(MXQN,MXQN,MXQN,MXQN)
#include "twocom.h"
#include "twosta.h"
      SAVE TMEINT, INTWRT, TIMOLD
C
      IF (.NOT.TKTIME) RETURN
      IF (ITYPE .EQ. -1) THEN
         TIMOLD = SECOND()
         CALL DZERO(TMEINT,MXQN**4)
         CALL IZERO(INTWRT,MXQN**4)
      ELSE IF (ITYPE .EQ. 0) THEN
         TIMNOW = SECOND()
         TMEINT(NHKTA,NHKTB,NHKTC,NHKTD)
     & = TMEINT(NHKTA,NHKTB,NHKTC,NHKTD) + TIMNOW - TIMOLD
         INTWRT(NHKTA,NHKTB,NHKTC,NHKTD)
     & = INTWRT(NHKTA,NHKTB,NHKTC,NHKTD) + ICOUNT
         TIMOLD = TIMNOW
      ELSE
         TOTTIM = DSUM(MXQN**4,TMEINT,1)
         NINTOT = ISUM(MXQN**4,INTWRT,1)
         CALL HEADER('               # int'/
     &        /'               time               time/int',3)
         DO 100 I = 0, 4*(MXQN - 1)
            NINTI = 0
            TIMEI = D0
            DO 200 IA = 0, MXQN - 1
            DO 200 IB = 0, MIN(I - IA,MXQN - 1)
            DO 200 IC = 0, MIN(I - IA - IB,MXQN - 1)
               ID = I - IA - IB - IC
               IF (ID .LT. MXQN) THEN
                  NINTI = NINTI + INTWRT(IA+1,IB+1,IC+1,ID+1)
                  TIMEI = TIMEI + TMEINT(IA+1,IB+1,IC+1,ID+1)
               END IF
  200       CONTINUE
            IF (NINTI .GT. 0) THEN
               PERINT = DMEGA*TIMEI/dble(NINTI)
               WRITE (LUPRI,2000) ' j =',I,
     &             NINTI, ' (',D100*dble(NINTI)/dble(NINTOT),'%)',
     &             TIMEI, ' (',D100*TIMEI/TOTTIM,'%)',PERINT
               DO 300 IA = 0, MXQN - 1
               DO 300 IB = 0, MIN(I - IA,MXQN - 1)
               DO 300 IC = 0, MIN(I - IA - IB,MXQN - 1)
                  ID = I - IA - IB - IC
                  IF (ID .LT. MXQN) THEN
                     NINTX = INTWRT(IA+1,IB+1,IC+1,ID+1)
                     IF (NINTX .GT. 0) THEN
                        TIME  = TMEINT(IA+1,IB+1,IC+1,ID+1)
                        PERINT = DMEGA*TIME/dble(NINTX)
                        WRITE (LUPRI,1000)'(',SPDCAR(IA),SPDCAR(IB),
     &                                    '|',SPDCAR(IC),SPDCAR(ID),')',
     &                                        NINTX, TIME, PERINT
                     END IF
                  END IF
  300          CONTINUE
               WRITE (LUPRI,'()')
            END IF
  100    CONTINUE
      END IF
      RETURN
 1000 FORMAT(5X,7A1,2X,I10,11X,F8.2,14X,F8.2)
 2000 FORMAT(5X,A,I2,3X,I10,A,F5.2,A,2X,F8.2,A,F5.2,A,5X,F8.2)
      END
C  /* Deck redsta */
      SUBROUTINE REDSTA(ITYPE,NREDPR,NTOTPR,NREDCN,NTOTCN)
#include "implicit.h"
#include "priunit.h"
      PARAMETER (D0 = 0.D0, D1 = 1.0D0, D100 = 100.0D0)
      SAVE NODC, REDPR, REDCN
C
      IF (ITYPE .EQ. -1) THEN
         NODC  = 0
         REDPR = D0
         REDCN = D0
      ELSE IF (ITYPE .EQ. 0) THEN
         NODC  = NODC + 1
         REDPR = REDPR + dble(NREDPR)/dble(NTOTPR)
         REDCN = REDCN + dble(NREDCN)/dble(NTOTCN)
      ELSE
         WRITE (LUPRI,'(2(/1X,A,F5.2,A))')
     &      ' Average reduction of primitive ODC vectors:   ',
     &      D100*(D1 - REDPR/dble(NODC)),' %',
     &      ' Average reduction of contracted ODC vectors:  ',
     &      D100*(D1 - REDCN/dble(NODC)),' %'
      END IF
      RETURN
      END
C  /* Deck nodsym */
      FUNCTION NODSYM(MAXOPR,MULA,MULB)
#include "implicit.h"
      NODSYM = 0
      DO 100 I = 0, MAXOPR
         IF (IAND(I,IOR(MULA,MULB)).EQ.0) NODSYM = NODSYM + 1
  100 CONTINUE
      RETURN
      END
C  /* Deck herprp */
      SUBROUTINE HERPRP(INDHER,INDHSQ,IODDHR)
#include "implicit.h"
#include "priunit.h"
      INTEGER T, U, V, TUV
      DIMENSION INDHER(0:JTOP,0:JTOP,0:JTOP),
     &          INDHSQ(NRTOP), IODDHR(NRTOP,0:7)
#include "hertop.h"
C
      TUV = 0
      DO 100 J = 0, JTOP
         DO 110 T = J, 0, -1
            DO 120 U = J - T, 0, -1
               V = J - T - U
               TUV = TUV + 1
               INDHER(T,U,V) = TUV
               INDHSQ(TUV)   = T + U*(JTOP + 1) + V*(JTOP + 1)**2
               IBTUV = MOD(T,2) + 2*MOD(U,2) + 4*MOD(V,2)
               DO 200 ISYM = 0, 7
                  IODDHR(TUV,ISYM) = IAND(IBTUV,ISYM)
  200          CONTINUE
  120       CONTINUE
  110    CONTINUE
  100 CONTINUE
      RETURN
      END
C  /* Deck getlmn */
      SUBROUTINE GETLMN(LMNVLS,IPRINT)
#include "implicit.h"
#include "priunit.h"
      DIMENSION LMNVLS(KCKMAX,5,4)
#include "twocom.h"
C
      IF (IPRINT .GT. 5) CALL TITLER('Output from GETLMN','*',103)
C
      CALL GETLM1(NHKTA,KCKTA,KHKTA,LMNVLS(1,1,1),'A',IPRINT)
      CALL GETLM1(NHKTB,KCKTB,KHKTB,LMNVLS(1,1,2),'B',IPRINT)
      CALL GETLM1(NHKTC,KCKTC,KHKTC,LMNVLS(1,1,3),'C',IPRINT)
      CALL GETLM1(NHKTD,KCKTD,KHKTD,LMNVLS(1,1,4),'D',IPRINT)
      RETURN
      END
C  /* Deck getlm1 */
      SUBROUTINE GETLM1(NHKTX,KCKTX,KHKTX,LMN,TYPE,IPRINT)
#include "implicit.h"
#include "priunit.h"
#include "maxaqn.h"
      CHARACTER*1 TYPE
      DIMENSION LMN(KCKMAX,5)
#include "ccom.h"
#include "sphtrm.h"
#include "twocom.h"
      CALL LMNVAL(NHKTX,KCKTX,LMN(1,1),LMN(1,2),LMN(1,3))
      DO 100 I = 1, KCKTX
         LMN(I,4) = MOD(LMN(I,1),2)+2*MOD(LMN(I,2),2)+4*MOD(LMN(I,3),2)
  100 CONTINUE
      DO 200 I = 1, KHKTX
         IF (DOCART) THEN
            LMN(I,5) = LMN(I,4)
         ELSE
            INDMAX = IDMAX(KCKTX,CSP(ISPADR(NHKTX)+I-1),KHKTX)
            LMN(I,5) = LMN(INDMAX,4)
         END IF
  200 CONTINUE
      IF (IPRINT .GT. 5) THEN
         CALL HEADER('Cartesian components for orbital '//TYPE,1)
         WRITE (LUPRI,'(5X,A,/)')'   cmp        x    y    z        odd '
         DO 300 I = 1, KCKTX
            WRITE (LUPRI,'(5X,I5,5X,3I5,5X,I5)') I, (LMN(I,J),J=1,4)
  300    CONTINUE
         WRITE (LUPRI,'(/,A,/)') ' Odd for spherical integrals:'
         WRITE (LUPRI,'(15I5)') (LMN(I,5),I=1,KHKTX)
      END IF
      RETURN
      END
C  /* Deck getoda */
      SUBROUTINE GETODA(IODD12,IODD34,LMNV12,LMNV34,IPRINT)
C
C     TUH
C
#include "implicit.h"
#include "priunit.h"
      DIMENSION LMNV12(KCKMX,5,2), LMNV34(KCKMX,5,2),
     &          IODD12(KCKT12,2),  IODD34(KCKT34,2)
#include "twoao.h"
C
      IF (IHRSYM .GT. 0) THEN
         IJ = 0
         DO 100 I = 1, KCKT1
            IODD = LMNV12(I,4,1)
            MAXJ = KCKT2
            IF (DIAC12) MAXJ = I
            DO 110 J = 1, MAXJ
               IJ = IJ + 1
               IODD12(IJ,1) = IAND(IHRSYM,IEOR(IODD,LMNV12(J,4,2)))
  110       CONTINUE
  100    CONTINUE
C
         IJ = 0
         DO 200 I = 1, KHKT1
            IODD = LMNV12(I,5,1)
            MAXJ = KHKT2
            IF (DIAG12) MAXJ = I
            DO 210 J = 1, MAXJ
               IJ = IJ + 1
               IODD12(IJ,2) = IAND(IHRSYM,IEOR(IODD,LMNV12(J,5,2)))
  210       CONTINUE
  200    CONTINUE
C
         IJ = 0
         DO 300 I = 1, KCKT3
            IODD = LMNV34(I,4,1)
            MAXJ = KCKT4
            IF (DIAC34) MAXJ = I
            DO 310 J = 1, MAXJ
               IJ = IJ + 1
               IODD34(IJ,1) = IAND(IHRSYM,IEOR(IODD,LMNV34(J,4,2)))
  310       CONTINUE
  300    CONTINUE
C
         IJ = 0
         DO 400 I = 1, KHKT3
            IODD = LMNV34(I,5,1)
            MAXJ = KHKT4
            IF (DIAG34) MAXJ = I
            DO 410 J = 1, MAXJ
               IJ = IJ + 1
               IODD34(IJ,2) = IAND(IHRSYM,IEOR(IODD,LMNV34(J,5,2)))
  410       CONTINUE
  400    CONTINUE
      ELSE
         CALL IZERO(IODD12,2*KCKT12)
         CALL IZERO(IODD34,2*KCKT34)
      END IF
C
      IF (IPRINT .GE. 10) THEN
         CALL TITLER('Output from GETODA','*',103)
         CALL HEADER('IODD12 (Cartesian)',1)
         WRITE (LUPRI,'(1X,(10I7))') (IODD12(I,1),I=1,KCKT12)
         CALL HEADER('IODD12 (spherical)',1)
         WRITE (LUPRI,'(1X,(10I7))') (IODD12(I,2),I=1,KHKT12)
         CALL HEADER('IODD34 (Cartesian)',1)
         WRITE (LUPRI,'(1X,(10I7))') (IODD34(I,1),I=1,KCKT34)
         CALL HEADER('IODD34 (spherical)',1)
         WRITE (LUPRI,'(1X,(10I7))') (IODD34(I,2),I=1,KHKT34)
      END IF
      RETURN
      END
C  /* Deck whtrep */
      SUBROUTINE WHTREP(ITYPE,MULE,IPRINT)
#include "implicit.h"
#include "priunit.h"
#include "mxcent.h"
#include "maxaqn.h"
#include "maxorb.h"
      LOGICAL DOPREP(0:7)
#include "dorps.h"
#include "symmet.h"
#include "twocom.h"
C
      DO 100 I = 0, MAXREP
         DOPREP(I) = .FALSE.
  100 CONTINUE
C
C     Undifferentiated integrals written on file
C
      IF (ITYPE .EQ. 0) THEN
         DOPREP(0) = .TRUE.
C
C     Differentiated integrals written on file (atom JATOM)
C
      ELSE IF (ITYPE .EQ. 1 .OR. ITYPE .EQ. 8) THEN
         DO 200 IREPE = 0, MAXREP
         IF (DOREPS(IREPE)) THEN
            DO 210 ICOOR = 1, 3
            IF (IAND(MULE,IEOR(IREPE,ISYMAX(ICOOR,1))).EQ.0) THEN
               DOPREP(IREPE) = .TRUE.
            END IF
  210       CONTINUE
         END IF
  200    CONTINUE
C
C     Differentiated integrals for expectation values
C
      ELSE IF (ITYPE .EQ. 2 .OR. ITYPE .EQ. 6 .OR. ITYPE .EQ. 10) THEN
         DO 220 IREPE = 0, MAXREP
            DOPREP(IREPE) = DOREPS(IREPE)
  220    CONTINUE
         IF (ITYPE .EQ. 10) DOPREP(0) = .TRUE.
C
C     Spin-orbit integrals
C
      ELSE IF (ITYPE .EQ. -2) THEN
         IRPXYZ = IEOR(ISYMAX(1,1),IEOR(ISYMAX(2,1),ISYMAX(3,1)))
         DO 300 ICOOR = 1, 3
            DOPREP(IEOR(ISYMAX(ICOOR,1),IRPXYZ)) = .TRUE.
  300    CONTINUE
C
C     Direct calculation of Fock matrix in AO basis
C
      ELSE IF (ITYPE .EQ. 3) THEN
         DOPREP(0) = .TRUE.
C
C     Direct calculations of Fock matrices in SO basis
C
      ELSE IF (ITYPE .EQ. 9) THEN
         DOPREP(0) = .TRUE.
C
C     Calculation of distributions
C
      ELSE IF (ITYPE .EQ. 4) THEN
         DOPREP(0) = .TRUE.
C
C     Magnetic field derivatives
C
      ELSE IF (ITYPE .EQ. 5 .OR. ITYPE .EQ. -5) THEN
         DOPREP(ISYMAX(1,2)) = .TRUE.
         DOPREP(ISYMAX(2,2)) = .TRUE.
         DOPREP(ISYMAX(3,2)) = .TRUE.
      ELSE IF (ITYPE .EQ. 7) THEN
         DOPREP(0) = .TRUE.
      END IF
C
      NOPREP = 0
      DO 400 IREP = 0, MAXREP
         IF (DOPREP(IREP)) THEN
            NOPREP = NOPREP + 1
            IPTREP(NOPREP,1) = IREP
            IPTREP(IREP  ,2) = NOPREP
         END IF
  400 CONTINUE
C
      IF (IPRINT .GT. 5) THEN
         CALL TITLER('Output from WHTREP','*',103)
         WRITE (LUPRI,'(/,1X,A,I2,/,1X,A,8I2)')
     &         ' Number of perturbation representations:', NOPREP,
     &         ' Perturbation representations:          ',
     &           (IPTREP(I,1),I=1,NOPREP)
      END IF
      RETURN
      END
C  /* Deck seteff */
      SUBROUTINE SETEFF(IEFFB,IEFFC,IEFFD)
#include "implicit.h"
#include "mxcent.h"
#include "maxaqn.h"
#include "maxorb.h"
      DIMENSION IEFFB(0:7), IEFFC(0:7), IEFFD(0:7)
#include "symmet.h"
#include "twocom.h"
C
      IOFF = 0
      DO 100 I = 0, MAXOPR
        IF (IAND(I,MULB).EQ.0) THEN
            IEFFB(I) = IOFF
            IOFF = IOFF + KHKTB
         ELSE
            IEFFB(I) = IEFFB(IEOR(I,IAND(I,MULB)))
         END IF
 100  CONTINUE
      IOFF = 0
      DO 200 I = 0, MAXOPR
         IF (IAND(I,MULC).EQ.0) THEN
            IEFFC(I) = IOFF
            IOFF = IOFF + KHKTC
         ELSE
            IEFFC(I) = IEFFC(IEOR(I,IAND(I,MULC)))
         END IF
 200  CONTINUE
      IOFF = 0
      DO 300 I = 0, MAXOPR
         IF (IAND(I,MULD).EQ.0) THEN
            IEFFD(I) = IOFF
            IOFF = IOFF + KHKTD
         ELSE
            IEFFD(I) = IEFFD(IEOR(I,IAND(I,MULD)))
         END IF
 300  CONTINUE
      RETURN
      END
C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
C/* Deck Tworun */
      SUBROUTINE TWORUN(ITYPE,MAXDIF,JATOM,PERTUR,EXPECT,UNDIFF,
     &           DIRFCK,SOFOCK,SPNORB,DISTRI,SQ12EL,LONDON,SUSCEP,
     &           DDFOCK,ADISTR,MAXDER,IATOM,MULE,MULTE,IPRINT)
C*****************************************************************************
C
C     Determine run type for two-electron integrals
C
C     Compiled by T.Saue Oct 7 1996
C
C*****************************************************************************
#include "implicit.h"
#include "priunit.h"
#include "mxcent.h"
#include "maxorb.h"
#include "maxaqn.h"
      LOGICAL PERTUR, EXPECT, UNDIFF, DIRFCK, SPNORB, DISTRI, 
     &        SQ12EL, LONDON, SUSCEP, DDFOCK, ADISTR, SOFOCK
#include "nuclei.h"
#include "symmet.h"
C
C
C     *****************************
C     **** Determine run type *****
C     *****************************
C
      PERTUR = .FALSE.
      EXPECT = .FALSE.
      UNDIFF = .FALSE.
      DIRFCK = .FALSE.
      SOFOCK = .FALSE.
      SPNORB = .FALSE.
      DISTRI = .FALSE.
      SQ12EL = .FALSE.
      LONDON = .FALSE.
      SUSCEP = .FALSE.
      DDFOCK = .FALSE.
      ADISTR = .FALSE.
      IATOM  = 0
      MULTE  = 1
C
C     a) Undifferentiated integrals written on file
C     =============================================
C
      IF (ITYPE .EQ. 0) THEN
         UNDIFF = .TRUE.
         MAXDER = 0
C
C     b) Differentiated integrals written on file (atom JATOM)
C     ========================================================
C
      ELSE IF (ITYPE .EQ. 1) THEN
         PERTUR = .TRUE.
         MAXDER = MAXDIF
         IATOM  = JATOM
         MULE   = ISTBNU(IATOM)
         MULTE  = MULT(MULE)
C
C     c) Expectation values of differentiated integrals (all atoms)
C     =============================================================
C
      ELSE IF (ITYPE .EQ. 2) THEN
         EXPECT = .TRUE.
         MAXDER = MAXDIF
C
C     d) Direct calculation of Fock matrices 
C        using skeleton matrix approach (AO basis)
C     ============================================
C
      ELSE IF (ITYPE .EQ. 3) THEN
         DIRFCK = .TRUE.
         MAXDER = MAXDIF
C
C     e) Direct calculation of Fock matrices in SO basis
C     ==================================================
C
      ELSE IF (ITYPE .EQ. 9) THEN
         SOFOCK = .TRUE.
         MAXDER = MAXDIF
C
C     f) Spin-orbit integrals
C     =======================
C
      ELSE IF (ITYPE .EQ. -2) THEN
         SPNORB = .TRUE.
         SQ12EL = .TRUE.
         MAXDER = 1
C
C     g) Integral distributions
C     =========================
C
      ELSE IF (ITYPE .EQ. 4) THEN
         DISTRI = .TRUE.
         SQ12EL = .TRUE.
         MAXDER = 0
C
C     h) Derivatives with respect to magnetic field
C     =============================================
C
      ELSE IF (ITYPE .EQ. 5 .OR. ITYPE .EQ. -5) THEN
         LONDON = .TRUE.
         MAXDER = MAXDIF
         IF (MAXDER .EQ. 2) SUSCEP = .TRUE.
         IF (ITYPE .EQ. -5) DDFOCK = .TRUE.
C
C     i) Expectation values and Fock matrics of differentiated integrals
C     ==================================================================
C
      ELSE IF (ITYPE .EQ. 6 .OR. ITYPE .EQ. -6) THEN
         EXPECT = .TRUE.
         MAXDER = MAXDIF
         DDFOCK = MAXDIF .GT. 1
         IF (ITYPE .EQ. -6) DDFOCK = .TRUE.
C
C     j) Distributions (all gabcd for fixed a)
C     ======================================
C
      ELSE IF (ITYPE .EQ. 7) THEN
         UNDIFF = .TRUE.
         ADISTR = .TRUE.
         MAXDER = 0
C
C     k) Derivative Fock matrix for specified atom
C     ============================================
C
      ELSE IF (ITYPE .EQ. 8) THEN
         PERTUR = .TRUE.
         MAXDER = MAXDIF
         IATOM  = JATOM
         MULE   = ISTBNU(IATOM)
         MULTE  = MULT(MULE)
         DDFOCK = .TRUE.
C
C     l) integrals for GAB
C     ============================================
C
      ELSE IF (ITYPE .EQ. 10) THEN
         MAXDER = MAXDIF
         EXPECT = .TRUE.
C
C     x) Error
C     ========
C
      ELSE
         WRITE (LUPRI,'(1X,A,I5)')
     &       ' Wrong run type in TWORUN, ITYPE =', ITYPE
         CALL QUIT('ERROR in TWORUN.')
      END IF
      IF (IPRINT .GT. 5) THEN
         WRITE (LUPRI,'(A,I5)') ' ITYPE  ', ITYPE
         WRITE (LUPRI,'(A,I5)') ' MAXDER ', MAXDER
         WRITE (LUPRI,'(A,I5)') ' IATOM  ', IATOM
         WRITE (LUPRI,'(A,I5)') ' MULTE  ', MULTE
         WRITE (LUPRI,'(A,L5)') ' UNDIFF ', UNDIFF
         WRITE (LUPRI,'(A,L5)') ' PERTUR ', PERTUR
         WRITE (LUPRI,'(A,L5)') ' EXPECT ', EXPECT
         WRITE (LUPRI,'(A,L5)') ' DDFOCK ', DDFOCK
         WRITE (LUPRI,'(A,L5)') ' DIRFCK ', DIRFCK
         WRITE (LUPRI,'(A,L5)') ' SOFOCK ', SOFOCK
         WRITE (LUPRI,'(A,L5)') ' SPNORB ', SPNORB
         WRITE (LUPRI,'(A,L5)') ' LONDON ', LONDON
         WRITE (LUPRI,'(A,L5)') ' SUSCEP ', SUSCEP
         WRITE (LUPRI,'(A,L5)') ' DISTRI ', DISTRI
         WRITE (LUPRI,'(A,L5)') ' ADISTR ', ADISTR
         WRITE (LUPRI,'(A,L5)') ' SQ12EL ', SQ12EL
      END IF
C
C
      RETURN
      END
C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
C/* Deck imulti */
      INTEGER FUNCTION IMULTI(ICENTA,ICENTB,ICENTC,ICENTD,ICEN)
C*****************************************************************************
C
C     Determine type of multicenter integral
C
C     Written by J. Thyssen - Jan 22 1998
C
C*****************************************************************************
#include "implicit.h"
      IF(ICENTA.EQ.ICENTB) THEN
         IF(ICENTA.EQ.ICENTC) THEN
            IF(ICENTA.EQ.ICENTD) THEN
               IMULTI = 1111
               ICEN   = 0
            ELSE
               IMULTI = 1112
               ICEN   = 6
            END IF
         ELSE
            IF(ICENTA.EQ.ICENTD) THEN
               IMULTI = 1121
               ICEN   = 7
            ELSE IF(ICENTC.EQ.ICENTD) THEN
               IMULTI = 1122
               ICEN   = 1
            ELSE
               IMULTI = 1123
               ICEN   = 12
            END IF
         END IF
      ELSE
         IF(ICENTA.EQ.ICENTC) THEN
            IF(ICENTA.EQ.ICENTD) THEN
               IMULTI = 1211
               ICEN   = 5
            ELSE IF(ICENTB.EQ.ICENTD) THEN
               IMULTI = 1212
               ICEN   = 2
            ELSE
               IMULTI = 1213
               ICEN   = 8
            END IF
         ELSE IF(ICENTB.EQ.ICENTC) THEN
            IF(ICENTA.EQ.ICENTD) THEN
               IMULTI = 1221
               ICEN   = 3
            ELSE IF(ICENTB.EQ.ICENTD) THEN
               IMULTI = 1222
               ICEN   = 4
            ELSE
               IMULTI = 1223
               ICEN   = 9
            END IF
         ELSE
            IF(ICENTA.EQ.ICENTD) THEN
               IMULTI = 1231
               ICEN   = 10
            ELSE IF(ICENTB.EQ.ICENTD) THEN
               IMULTI = 1232
               ICEN   = 11
            ELSE IF(ICENTC.EQ.ICENTD) THEN
               IMULTI = 1233
               ICEN   = 13
            ELSE
               IMULTI = 1234
               ICEN   = 14
            END IF
         END IF
      END IF
      RETURN
      END
C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
C/* Deck scrint */
      SUBROUTINE SCRINT_GEOM(GABRAO,ISYBLA,ISYBLB,ISYBLC,ISYBLD,
     &                  IT,ULXINT,ULYINT,ULZINT,IPRINT)
C*****************************************************************************
C
C     Calculate ULXINT, ULYINT og ULZINT for screening of gradient
C     See technical notes by J. Thyssen (Available by request)
C
C     Written by J. Thyssen - Jan 22 1998
C
C*****************************************************************************
#include "implicit.h"
#include "priunit.h"
#include "maxaqn.h"
#include "mxcent.h"
#include "aovec.h"
#include "maxorb.h"
#include "blocks.h"
      PARAMETER (D0 = 0.0D00, D1 = 1.0D00, D2 = 2.0D00)
      DIMENSION GABRAO(NSYMBL,NSYMBL,0:3)
C
      ULXINT = D0
      ULYINT = D0
      ULZINT = D0
C 
C     Please note that
C        GABRAO(I,J,1) = ( I_x J | I_x J )
C     while
C        GABRAO(J,I,1) = ( I J_x | I J_x )
C
C     ( 1 2 | 3 4 ) or ( 1 1 | 2 2 )
C
      IF (IT .EQ. 1234) THEN
C
         ULXINT = MAX(GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,1),
     &                GABRAO(ISYBLB,ISYBLA,0)*
     &                GABRAO(ISYBLC,ISYBLD,1),
     &                GABRAO(ISYBLA,ISYBLB,1)*
     &                GABRAO(ISYBLC,ISYBLD,0),
     &                GABRAO(ISYBLB,ISYBLA,1)*
     &                GABRAO(ISYBLC,ISYBLD,0))
         ULYINT = MAX(GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,2),
     &                GABRAO(ISYBLB,ISYBLA,0)*
     &                GABRAO(ISYBLC,ISYBLD,2),
     &                GABRAO(ISYBLA,ISYBLB,2)*
     &                GABRAO(ISYBLC,ISYBLD,0),
     &                GABRAO(ISYBLB,ISYBLA,2)*
     &                GABRAO(ISYBLC,ISYBLD,0))
         ULZINT = MAX(GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,3),
     &                GABRAO(ISYBLB,ISYBLA,0)*
     &                GABRAO(ISYBLC,ISYBLD,3),
     &                GABRAO(ISYBLA,ISYBLB,3)*
     &                GABRAO(ISYBLC,ISYBLD,0),
     &                GABRAO(ISYBLB,ISYBLA,3)*
     &                GABRAO(ISYBLC,ISYBLD,0))
C
C     ( 1 1 | 2 2 )
C
      ELSE IF (IT .EQ. 1122) THEN
         ULXINT = MIN(GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,1),
     &                GABRAO(ISYBLA,ISYBLB,1)*
     &                GABRAO(ISYBLC,ISYBLD,0))
         ULYINT = MIN(GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,2),
     &                GABRAO(ISYBLA,ISYBLB,2)*
     &                GABRAO(ISYBLC,ISYBLD,0))
         ULZINT = MIN(GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,3),
     &                GABRAO(ISYBLA,ISYBLB,3)*
     &                GABRAO(ISYBLC,ISYBLD,0))
C
C     ( 1 2 | 1 2 )
C
      ELSE IF (IT .EQ. 1212) THEN
         ULXINT = MIN(GABRAO(ISYBLA,ISYBLB,1)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,1),
     &                GABRAO(ISYBLB,ISYBLA,1)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLD,ISYBLC,1))
         ULYINT = MIN(GABRAO(ISYBLA,ISYBLB,2)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,2),
     &                GABRAO(ISYBLB,ISYBLA,2)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLD,ISYBLC,2))
         ULZINT = MIN(GABRAO(ISYBLA,ISYBLB,3)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,3),
     &                GABRAO(ISYBLB,ISYBLA,3)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLD,ISYBLC,3))
C
C     ( 1 2 | 2 1 )
C
      ELSE IF (IT .EQ. 1221) THEN
         ULXINT = MIN(GABRAO(ISYBLA,ISYBLB,1)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLD,ISYBLC,1),
     &                GABRAO(ISYBLB,ISYBLA,1)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,1))
         ULYINT = MIN(GABRAO(ISYBLA,ISYBLB,2)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLD,ISYBLC,2),
     &                GABRAO(ISYBLB,ISYBLA,2)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,2))
         ULZINT = MIN(GABRAO(ISYBLA,ISYBLB,3)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLD,ISYBLC,3),
     &                GABRAO(ISYBLB,ISYBLA,3)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,3))
C
C     ( 1 2 | 1 3 )
C
      ELSE IF (IT .EQ. 1213) THEN
         ULXINT = MAX(GABRAO(ISYBLA,ISYBLB,1)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,1),
     &                GABRAO(ISYBLB,ISYBLA,1)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLD,ISYBLC,1))
         ULYINT = MAX(GABRAO(ISYBLA,ISYBLB,2)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,2),
     &                GABRAO(ISYBLB,ISYBLA,2)*
     &                GABRAO(ISYBLC,ISYBLD,0),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLD,ISYBLC,2))
         ULZINT = MAX(GABRAO(ISYBLA,ISYBLB,3)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,3),
     &                GABRAO(ISYBLB,ISYBLA,3)*
     &                GABRAO(ISYBLC,ISYBLD,0),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLD,ISYBLC,3))
C
C     ( 1 2 | 2 3 ) 
C
      ELSE IF (IT .EQ. 1223) THEN
         ULXINT = MAX(GABRAO(ISYBLB,ISYBLA,1)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,1),
     &                GABRAO(ISYBLA,ISYBLB,1)*
     &                GABRAO(ISYBLC,ISYBLD,0),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,1))
         ULYINT = MAX(GABRAO(ISYBLB,ISYBLA,2)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,2),
     &                GABRAO(ISYBLA,ISYBLB,2)*
     &                GABRAO(ISYBLC,ISYBLD,0),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,2))
         ULZINT = MAX(GABRAO(ISYBLB,ISYBLA,3)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,3),
     &                GABRAO(ISYBLA,ISYBLB,3)*
     &                GABRAO(ISYBLC,ISYBLD,0),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,3))
C
C     ( 1 2 | 3 1 ) 
C
      ELSE IF (IT .EQ. 1231) THEN
         ULXINT = MAX(GABRAO(ISYBLA,ISYBLB,1)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLD,ISYBLC,1),
     &                GABRAO(ISYBLB,ISYBLA,1)*
     &                GABRAO(ISYBLC,ISYBLD,0),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,1))
         ULYINT = MAX(GABRAO(ISYBLA,ISYBLB,2)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLD,ISYBLC,2),
     &                GABRAO(ISYBLB,ISYBLA,2)*
     &                GABRAO(ISYBLC,ISYBLD,0),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,2))
         ULZINT = MAX(GABRAO(ISYBLA,ISYBLB,3)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLD,ISYBLC,3),
     &                GABRAO(ISYBLB,ISYBLA,3)*
     &                GABRAO(ISYBLC,ISYBLD,0),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,3))
C
C     ( 1 2 | 3 2 ) 
C
      ELSE IF (IT .EQ. 1232) THEN
         ULXINT = MAX(GABRAO(ISYBLA,ISYBLB,1)*
     &                GABRAO(ISYBLC,ISYBLD,0),
     &                GABRAO(ISYBLB,ISYBLA,1)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLD,ISYBLC,1),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,1))
         ULYINT = MAX(GABRAO(ISYBLA,ISYBLB,2)*
     &                GABRAO(ISYBLC,ISYBLD,0),
     &                GABRAO(ISYBLB,ISYBLA,2)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLD,ISYBLC,2),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,2))
         ULZINT = MAX(GABRAO(ISYBLA,ISYBLB,3)*
     &                GABRAO(ISYBLC,ISYBLD,0),
     &                GABRAO(ISYBLB,ISYBLA,3)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLD,ISYBLC,3),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,3))
C
C     ( 1 2 | 2 2 ) 
C
      ELSE IF (IT .EQ. 1222) THEN
         ULXINT = MIN(GABRAO(ISYBLA,ISYBLB,1)*
     &                GABRAO(ISYBLC,ISYBLD,0),
     &                GABRAO(ISYBLB,ISYBLA,1)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,1))
         ULYINT = MIN(GABRAO(ISYBLA,ISYBLB,2)*
     &                GABRAO(ISYBLC,ISYBLD,0),
     &                GABRAO(ISYBLB,ISYBLA,2)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,2))
         ULZINT = MIN(GABRAO(ISYBLA,ISYBLB,3)*
     &                GABRAO(ISYBLC,ISYBLD,0),
     &                GABRAO(ISYBLB,ISYBLA,3)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,3))
C
C     ( 1 2 | 1 1 ) 
C
      ELSE IF (IT .EQ. 1211) THEN
         ULXINT = MIN(GABRAO(ISYBLA,ISYBLB,1)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,1),
     &                GABRAO(ISYBLB,ISYBLA,1)*
     &                GABRAO(ISYBLC,ISYBLD,0))
         ULYINT = MIN(GABRAO(ISYBLA,ISYBLB,2)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,2),
     &                GABRAO(ISYBLB,ISYBLA,2)*
     &                GABRAO(ISYBLC,ISYBLD,0))
         ULZINT = MIN(GABRAO(ISYBLA,ISYBLB,3)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,3),
     &                GABRAO(ISYBLB,ISYBLA,3)*
     &                GABRAO(ISYBLC,ISYBLD,0))
C
C     ( 1 1 | 1 2 ) 
C
      ELSE IF (IT .EQ. 1112) THEN
         ULXINT = MIN(GABRAO(ISYBLA,ISYBLB,1)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,1),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLD,ISYBLC,1))
         ULYINT = MIN(GABRAO(ISYBLA,ISYBLB,2)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,2),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLD,ISYBLC,2))
         ULZINT = MIN(GABRAO(ISYBLA,ISYBLB,3)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,3),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLD,ISYBLC,3))
C
C     ( 1 1 | 2 1 ) 
C
      ELSE IF (IT .EQ. 1121) THEN
         ULXINT = MIN(GABRAO(ISYBLA,ISYBLB,1)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLD,ISYBLC,1),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,1))
         ULYINT = MIN(GABRAO(ISYBLA,ISYBLB,2)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLD,ISYBLC,2),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,2))
         ULZINT = MIN(GABRAO(ISYBLA,ISYBLB,3)*
     &                GABRAO(ISYBLC,ISYBLD,0)+
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLD,ISYBLC,3),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,3))
C
C     ( 1 1 | 2 3 ) 
C
      ELSE IF (IT .EQ. 1123) THEN
         ULXINT = MAX(GABRAO(ISYBLA,ISYBLB,1)*
     &                GABRAO(ISYBLC,ISYBLD,0),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,1),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLD,ISYBLC,1))
         ULYINT = MAX(GABRAO(ISYBLA,ISYBLB,2)*
     &                GABRAO(ISYBLC,ISYBLD,0),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,2),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLD,ISYBLC,2))
         ULZINT = MAX(GABRAO(ISYBLA,ISYBLB,3)*
     &                GABRAO(ISYBLC,ISYBLD,0),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,3),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLD,ISYBLC,3))
C
C     ( 1 2 | 3 3 ) 
C
      ELSE IF (IT .EQ. 1233) THEN
         ULXINT = MAX(GABRAO(ISYBLA,ISYBLB,1)*
     &                GABRAO(ISYBLC,ISYBLD,0),
     &                GABRAO(ISYBLB,ISYBLA,0)*
     &                GABRAO(ISYBLC,ISYBLD,1),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,1))
         ULYINT = MAX(GABRAO(ISYBLA,ISYBLB,3)*
     &                GABRAO(ISYBLC,ISYBLD,0),
     &                GABRAO(ISYBLB,ISYBLA,0)*
     &                GABRAO(ISYBLC,ISYBLD,3),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,3))
         ULZINT = MAX(GABRAO(ISYBLA,ISYBLB,3)*
     &                GABRAO(ISYBLC,ISYBLD,0),
     &                GABRAO(ISYBLB,ISYBLA,0)*
     &                GABRAO(ISYBLC,ISYBLD,3),
     &                GABRAO(ISYBLA,ISYBLB,0)*
     &                GABRAO(ISYBLC,ISYBLD,3))
      ELSE
         WRITE(LUPRI,'(A,I4)') 'SCRINT_GEOM ERROR: Unknown IT ',IT
         WRITE(LUPRI,'(A)') 'Please report to Joern Thyssen'
         CALL QUIT('SCRINT_GEOM ERROR: Unknown IT')
      END IF
      IF (IPRINT .LE. 30) RETURN
      WRITE(LUPRI,'(A,2X,I4,2X,3F17.13)') 
     &   'SCRINT_GEOM IT UL?INT',IT,ULXINT,ULYINT,ULZINT
      RETURN 
      END
C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
C/* Deck adddint */
      SUBROUTINE ADDDINT(DINTSKP,NCCINT,ICEN,IFLAG,IXYZ)
C*****************************************************************************
C
C     Add NCCINT to the proper DINTSKP element
C
C     Written by J. Thyssen - Feb 6 1998
C
C*****************************************************************************
#include "implicit.h"
      DIMENSION DINTSKP(3,14,3)
C
      DINTSKP(IFLAG,ICEN,IXYZ) = DINTSKP(IFLAG,ICEN,IXYZ) + NCCINT
      RETURN
      END
C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
C/* Deck prdint */
      SUBROUTINE PRDINT(DINTSKP)
C*****************************************************************************
C
C     Written by J. Thyssen - Jun 2 1998
C
C*****************************************************************************
#include "implicit.h"
#include "priunit.h"
#include "chrxyz.h"
      DIMENSION DINTSKP(3,14,3)
C
      DO I = 1,3
         CALL HEADER('Screening statistic '//CHRXYZ(I)//'-direction',-1)
         CALL OUTPUT(DINTSKP(1,1,I),1,3,1,14,3,14,1,LUPRI)
      END DO
      RETURN
      END
