program test

  use unit_testing
  use unit_test_generator
  implicit none

  integer :: ier
  logical :: psymm 
  logical :: ksymm 
  logical :: tsymm 
  logical :: spinfr
  logical :: levyle
  integer :: nasht 
  integer :: nnashx
  integer :: nz    
  integer :: nzinci
  integer :: nm5   
  integer :: nbsym 
  integer :: nfsym 
  integer :: iprint
  integer :: lupri 
  integer, allocatable, dimension(:) :: nash  
  integer, allocatable, dimension(:,:) :: ipqtoq
  real*8,  allocatable, dimension(:,:,:,:,:) :: vmuuuu
  real*8,  allocatable, dimension(:,:,:,:,:) :: vduuuu

  allocate( nash  (2) , stat=ier ); call errall(ier,'test','nash  ')
  allocate( ipqtoq(4,8) , stat=ier ); call errall(ier,'test','ipqtoq')
  allocate( vmuuuu(8,8,8,8,2) , stat=ier ); call errall(ier,'test','vmuuuu')
  allocate( vduuuu(4,4,10,2,3) , stat=ier ); call errall(ier,'test','vduuuu')

  call get_data_psymm (psymm )
  call get_data_ksymm (ksymm )
  call get_data_tsymm (tsymm )
  call get_data_spinfr(spinfr)
  call get_data_levyle(levyle)
  call get_data_nasht (nasht )
  call get_data_nnashx(nnashx)
  call get_data_nz    (nz    )
  call get_data_nzinci(nzinci)
  call get_data_nm5   (nm5   )
  call get_data_nbsym (nbsym )
  call get_data_nfsym (nfsym )
  call get_data_iprint(iprint)
  call get_data_lupri (lupri )
  call get_data_nash  (nash  )
  call get_data_ipqtoq(ipqtoq)
  call get_data_vmuuuu(vmuuuu)

  !------------------------------------------------------------------------------!
  !            Generate test with input data writen to the test.F90              !
  !------------------------------------------------------------------------------!
  call unit_test__constructor
  call unit_test__set_suffix(psymm)
  call unit_test__set_suffix(ksymm)
  call unit_test__set_suffix(tsymm)
  call unit_test__set_suffix(1)
  call unit_test__set_routine_name('m2dnz390')
  call unit_test__add_module('mcscf_routines')

  call unit_test__add_inp_variable(psymm ,'psymm ')
  call unit_test__add_inp_variable(ksymm ,'ksymm ')
  call unit_test__add_inp_variable(tsymm ,'tsymm ')
  call unit_test__add_inp_variable(spinfr,'spinfr')
  call unit_test__add_inp_variable(levyle,'levyle')
  call unit_test__add_inp_variable(nasht ,'nasht ')
  call unit_test__add_inp_variable(nnashx,'nnashx')
  call unit_test__add_inp_variable(nz    ,'nz    ')
  call unit_test__add_inp_variable(nzinci,'nzinci')
  call unit_test__add_inp_variable(nm5   ,'nm5   ')
  call unit_test__add_inp_variable(nbsym ,'nbsym ')
  call unit_test__add_inp_variable(nfsym ,'nfsym ')
  call unit_test__add_inp_variable(iprint,'iprint')
  call unit_test__add_inp_variable(lupri ,'lupri ')
  call unit_test__add_inp_variable(nash  ,'nash  ')
  call unit_test__add_inp_variable(ipqtoq,'ipqtoq')
  call unit_test__add_inp_variable(vmuuuu,'vmuuuu')

  call get_data_vduuuu_ref(vduuuu)
  call unit_test__add_out_variable(vduuuu,'vduuuu')

  call unit_test__generate_test()

  ! compare input file and test
  call compare_text_files(60, 'test.F90_T_T_T_1', 'test.F90_T_T_T_1_ref')

  deallocate( nash   )
  deallocate( ipqtoq )
  deallocate( vmuuuu )
  deallocate( vduuuu )

  if(all_tests_passed()) write(6,*) ' test result: =====  OK  ====='

contains

  subroutine errall(ier,chsub,charr)
  implicit none

  integer      :: ier
  character(*) :: chsub, charr

  if(ier /= 0)then
    write(6,*)
    write(6,'(a,a,a,a)')' Error in allocation of ',charr,' in subroutine ',chsub
    write(6,'(a,i4)'   )' iostat =',ier
    stop 'ERROR in allocation (see output form more information)'
  endif

  end subroutine

  subroutine get_data_psymm (psymm )
  implicit none
  logical :: psymm

  psymm  = .True.

  end subroutine

  subroutine get_data_ksymm (ksymm )
  implicit none
  logical :: ksymm

  ksymm  = .True.

  end subroutine

  subroutine get_data_tsymm (tsymm )
  implicit none
  logical :: tsymm

  tsymm  = .True.

  end subroutine

  subroutine get_data_spinfr(spinfr)
  implicit none
  logical :: spinfr

  spinfr = .False.

  end subroutine

  subroutine get_data_levyle(levyle)
  implicit none
  logical :: levyle

  levyle = .False.

  end subroutine

  subroutine get_data_nasht (nasht )
  implicit none
  integer :: nasht

  nasht  =            4

  end subroutine

  subroutine get_data_nnashx(nnashx)
  implicit none
  integer :: nnashx

  nnashx =           10

  end subroutine

  subroutine get_data_nz    (nz    )
  implicit none
  integer :: nz

  nz     =            2

  end subroutine

  subroutine get_data_nzinci(nzinci)
  implicit none
  integer :: nzinci

  nzinci =            2

  end subroutine

  subroutine get_data_nm5   (nm5   )
  implicit none
  integer :: nm5

  nm5    =            2

  end subroutine

  subroutine get_data_nbsym (nbsym )
  implicit none
  integer :: nbsym

  nbsym  =            2

  end subroutine

  subroutine get_data_nfsym (nfsym )
  implicit none
  integer :: nfsym

  nfsym  =            1

  end subroutine

  subroutine get_data_iprint(iprint)
  implicit none
  integer :: iprint

  iprint =            1

  end subroutine

  subroutine get_data_lupri (lupri )
  implicit none
  integer :: lupri

  lupri  =            6

  end subroutine

  subroutine get_data_nash  (nash  )
  implicit none
  integer :: i
  integer, dimension(*) :: nash

  do i=1,2
    nash  (i) = 0
  enddo

  nash  (           1) =            4

  end subroutine

  subroutine get_data_ipqtoq(ipqtoq)
  implicit none
  integer :: i
  integer, dimension(*) :: ipqtoq

  do i=1,32
    ipqtoq(i) = 0
  enddo

  ipqtoq(           1) =            1
  ipqtoq(           2) =            2
  ipqtoq(           5) =            4
  ipqtoq(           6) =            3

  end subroutine

  subroutine get_data_vmuuuu(vmuuuu)
  implicit none
  integer :: i
  real(8), dimension(*) :: vmuuuu

  do i=1,8192
    vmuuuu(i) = 0.0d0
  enddo

  vmuuuu(         289) =   0.3655564670697051D-01
  vmuuuu(         290) =   0.1656603202118298D-15
  vmuuuu(         291) =  -0.7633167397132649D-15
  vmuuuu(         292) =   0.1129872667515467D-14
  vmuuuu(         297) =  -0.7876836713470050D-17
  vmuuuu(         298) =   0.4109989717305933D-30
  vmuuuu(         299) =  -0.5590499332228012D-30
  vmuuuu(         300) =   0.4294937212574331D-30
  vmuuuu(         305) =   0.3629427560982316D-16
  vmuuuu(         306) =  -0.5590499332228011D-30
  vmuuuu(         307) =   0.4140590412373477D-30
  vmuuuu(         308) =   0.3178991899942014D-31
  vmuuuu(         313) =  -0.5372332069412866D-16
  vmuuuu(         314) =   0.4294937212574332D-30
  vmuuuu(         315) =   0.3178991899941961D-31
  vmuuuu(         316) =  -0.6466802959773192D-30
  vmuuuu(         353) =   0.1656603202118298D-15
  vmuuuu(         354) =   0.1416429256471581D+00
  vmuuuu(         355) =  -0.7120926125610262D-15
  vmuuuu(         356) =  -0.2019642016872428D-15
  vmuuuu(         361) =  -0.4823903659340462D-30
  vmuuuu(         362) =  -0.3052054326611325D-16
  vmuuuu(         363) =   0.1500673260344331D-30
  vmuuuu(         364) =  -0.4022396587220409D-31
  vmuuuu(         369) =   0.8880016471714548D-30
  vmuuuu(         370) =   0.1406301856134139D-15
  vmuuuu(         371) =  -0.7015410675267788D-30
  vmuuuu(         372) =  -0.6488013814515927D-31
  vmuuuu(         377) =  -0.9164128875560361D-30
  vmuuuu(         378) =  -0.2081628695997299D-15
  vmuuuu(         379) =   0.1041435084843718D-29
  vmuuuu(         380) =   0.1706537417797537D-30
  vmuuuu(         417) =  -0.7633167397132649D-15
  vmuuuu(         418) =  -0.7124983299021093D-15
  vmuuuu(         419) =   0.1409517314470652D+00
  vmuuuu(         420) =   0.2693290137735762D-15
  vmuuuu(         425) =   0.8880016471714548D-30
  vmuuuu(         426) =   0.1568967478669275D-30
  vmuuuu(         427) =  -0.3037160803060579D-16
  vmuuuu(         428) =  -0.1186590865573691D-30
  vmuuuu(         433) =  -0.1929777165488844D-29
  vmuuuu(         434) =  -0.7128641189407785D-30
  vmuuuu(         435) =   0.1399439334182557D-15
  vmuuuu(         436) =   0.3656001676799264D-30
  vmuuuu(         441) =   0.2211798346722220D-29
  vmuuuu(         442) =   0.1052188279923740D-29
  vmuuuu(         443) =  -0.2071470690047855D-15
  vmuuuu(         444) =  -0.4871474855279624D-30
  vmuuuu(         481) =   0.1129872667515467D-14
  vmuuuu(         482) =  -0.2019642016872428D-15
  vmuuuu(         483) =   0.2693290137735762D-15
  vmuuuu(         484) =   0.1409517314473795D+00
  vmuuuu(         489) =  -0.9164128875560359D-30
  vmuuuu(         490) =   0.1248476226599924D-30
  vmuuuu(         491) =   0.6950608812292405D-32
  vmuuuu(         492) =  -0.3037160803067352D-16
  vmuuuu(         497) =   0.2211798346722219D-29
  vmuuuu(         498) =  -0.3322519244350145D-30
  vmuuuu(         499) =   0.1621460849698637D-30
  vmuuuu(         500) =   0.1399439334185678D-15
  vmuuuu(         505) =  -0.2674312061074297D-29
  vmuuuu(         506) =   0.4193369670727552D-30
  vmuuuu(         507) =  -0.2979142900982947D-30
  vmuuuu(         508) =  -0.2071470690052475D-15
  vmuuuu(         801) =  -0.7876836713470050D-17
  vmuuuu(         802) =  -0.4823903659340465D-30
  vmuuuu(         803) =   0.8880016471714552D-30
  vmuuuu(         804) =  -0.9164128875560361D-30
  vmuuuu(         809) =  -0.3155472578492548D-02
  vmuuuu(         810) =  -0.1429974969292629D-16
  vmuuuu(         811) =   0.6588927451282811D-16
  vmuuuu(         812) =  -0.9753027345166485D-16
  vmuuuu(         817) =   0.3387795578375481D-16
  vmuuuu(         818) =   0.1501547480754971D-30
  vmuuuu(         819) =  -0.7019438840085933D-30
  vmuuuu(         820) =   0.1042031339726059D-29
  vmuuuu(         825) =   0.9603018010725434D-17
  vmuuuu(         826) =  -0.3781105337651705D-31
  vmuuuu(         827) =  -0.6878841048850757D-31
  vmuuuu(         828) =   0.1742888365111539D-30
  vmuuuu(         865) =   0.4109989717305933D-30
  vmuuuu(         866) =  -0.3052054326611325D-16
  vmuuuu(         867) =   0.1568093258258636D-30
  vmuuuu(         868) =   0.1272605351556795D-30
  vmuuuu(         873) =  -0.1429974969292629D-16
  vmuuuu(         874) =  -0.1222657531953445D-01
  vmuuuu(         875) =   0.6146762305411425D-16
  vmuuuu(         876) =   0.1743348997132398D-16
  vmuuuu(         881) =   0.1568967478669275D-30
  vmuuuu(         882) =   0.1312676208581776D-15
  vmuuuu(         883) =  -0.6599065879552483D-30
  vmuuuu(         884) =  -0.1865384158801652D-30
  vmuuuu(         889) =   0.1248476226599924D-30
  vmuuuu(         890) =   0.3720901389010682D-16
  vmuuuu(         891) =  -0.1864500447481628D-30
  vmuuuu(         892) =  -0.3780828096326975D-31
  vmuuuu(         929) =  -0.5590499332228011D-30
  vmuuuu(         930) =   0.1501547480754971D-30
  vmuuuu(         931) =  -0.3037160803060579D-16
  vmuuuu(         932) =   0.2591619295745679D-32
  vmuuuu(         937) =   0.6588927451282811D-16
  vmuuuu(         938) =   0.6150264445462917D-16
  vmuuuu(         939) =  -0.1216691164124448D-01
  vmuuuu(         940) =  -0.2324840056496410D-16
  vmuuuu(         945) =  -0.7128641189407785D-30
  vmuuuu(         946) =  -0.6603334653960974D-30
  vmuuuu(         947) =   0.1306270564404163D-15
  vmuuuu(         948) =   0.2500582503975957D-30
  vmuuuu(         953) =  -0.3322519244350145D-30
  vmuuuu(         954) =  -0.1877841354881072D-30
  vmuuuu(         955) =   0.3702744001711235D-16
  vmuuuu(         956) =   0.8178963308041476D-31
  vmuuuu(         993) =   0.4294937212574332D-30
  vmuuuu(         994) =  -0.3781105337651705D-31
  vmuuuu(         995) =  -0.1230180760739158D-30
  vmuuuu(         996) =  -0.3037160803067352D-16
  vmuuuu(        1001) =  -0.9753027345166485D-16
  vmuuuu(        1002) =   0.1743348997132398D-16
  vmuuuu(        1003) =  -0.2324840056496410D-16
  vmuuuu(        1004) =  -0.1216691164127161D-01
  vmuuuu(        1009) =   0.1052188279923740D-29
  vmuuuu(        1010) =  -0.1877841354881072D-30
  vmuuuu(        1011) =   0.2491103316075667D-30
  vmuuuu(        1012) =   0.1306270564407076D-15
  vmuuuu(        1017) =   0.4193369670727552D-30
  vmuuuu(        1018) =  -0.6786273192871167D-31
  vmuuuu(        1019) =   0.5891997717027451D-31
  vmuuuu(        1020) =   0.3702744001719493D-16
  vmuuuu(        1313) =   0.3629427560982316D-16
  vmuuuu(        1314) =   0.8880016471714553D-30
  vmuuuu(        1315) =  -0.1929777165488845D-29
  vmuuuu(        1316) =   0.2211798346722220D-29
  vmuuuu(        1321) =   0.3385866468710928D-16
  vmuuuu(        1322) =   0.1568093258258636D-30
  vmuuuu(        1323) =  -0.7124613024589638D-30
  vmuuuu(        1324) =   0.1051592025041398D-29
  vmuuuu(        1329) =  -0.3154856379613794D-02
  vmuuuu(        1330) =  -0.1429695724599226D-16
  vmuuuu(        1331) =   0.6587640769302006D-16
  vmuuuu(        1332) =  -0.9751122779569715D-16
  vmuuuu(        1337) =  -0.1280608815063061D-16
  vmuuuu(        1338) =  -0.1230180760739158D-30
  vmuuuu(        1339) =   0.3726605638620988D-30
  vmuuuu(        1340) =  -0.4937143792110736D-30
  vmuuuu(        1377) =  -0.5590499332228012D-30
  vmuuuu(        1378) =   0.1406301856134139D-15
  vmuuuu(        1379) =  -0.7124613024589639D-30
  vmuuuu(        1380) =  -0.3361601967783629D-30
  vmuuuu(        1385) =   0.1500673260344332D-30
  vmuuuu(        1386) =   0.1311928732442257D-15
  vmuuuu(        1387) =  -0.6595816821826394D-30
  vmuuuu(        1388) =  -0.1876957643561048D-30
  vmuuuu(        1393) =  -0.1429695724599226D-16
  vmuuuu(        1394) =  -0.1222418772090524D-01
  vmuuuu(        1395) =   0.6145561969187185D-16
  vmuuuu(        1396) =   0.1743008556938231D-16
  vmuuuu(        1401) =   0.6950608812292383D-32
  vmuuuu(        1402) =  -0.4962001647217057D-16
  vmuuuu(        1403) =   0.2499490157488613D-30
  vmuuuu(        1404) =   0.8293429698484602D-31
  vmuuuu(        1441) =   0.4140590412373477D-30
  vmuuuu(        1442) =  -0.7019438840085933D-30
  vmuuuu(        1443) =   0.1399439334182557D-15
  vmuuuu(        1444) =   0.1692064811520360D-30
  vmuuuu(        1449) =  -0.7015410675267787D-30
  vmuuuu(        1450) =  -0.6599065879552482D-30
  vmuuuu(        1451) =   0.1305526735825367D-15
  vmuuuu(        1452) =   0.2490010969588322D-30
  vmuuuu(        1457) =   0.6587640769302006D-16
  vmuuuu(        1458) =   0.6149063425342772D-16
  vmuuuu(        1459) =  -0.1216453569370421D-01
  vmuuuu(        1460) =  -0.2324386063061050D-16
  vmuuuu(        1465) =   0.1621460849698637D-30
  vmuuuu(        1466) =   0.2491103316075667D-30
  vmuuuu(        1467) =  -0.4937787894615308D-16
  vmuuuu(        1468) =  -0.8553103841787232D-31
  vmuuuu(        1505) =   0.3178991899941961D-31
  vmuuuu(        1506) =  -0.6878841048850754D-31
  vmuuuu(        1507) =   0.3726605638620989D-30
  vmuuuu(        1508) =   0.1399439334185678D-15
  vmuuuu(        1513) =   0.1041435084843718D-29
  vmuuuu(        1514) =  -0.1864500447481628D-30
  vmuuuu(        1515) =   0.2499490157488612D-30
  vmuuuu(        1516) =   0.1305526735828279D-15
  vmuuuu(        1521) =  -0.9751122779569715D-16
  vmuuuu(        1522) =   0.1743008556938231D-16
  vmuuuu(        1523) =  -0.2324386063061050D-16
  vmuuuu(        1524) =  -0.1216453569373134D-01
  vmuuuu(        1529) =  -0.2979142900982947D-30
  vmuuuu(        1530) =   0.5891997717027450D-31
  vmuuuu(        1531) =  -0.1038045125101727D-30
  vmuuuu(        1532) =  -0.4937787894626319D-16
  vmuuuu(        1825) =  -0.5372332069412866D-16
  vmuuuu(        1826) =  -0.9164128875560363D-30
  vmuuuu(        1827) =   0.2211798346722220D-29
  vmuuuu(        1828) =  -0.2674312061074297D-29
  vmuuuu(        1833) =   0.9603018010725434D-17
  vmuuuu(        1834) =   0.1272605351556795D-30
  vmuuuu(        1835) =  -0.3361601967783629D-30
  vmuuuu(        1836) =   0.4229720618041554D-30
  vmuuuu(        1841) =  -0.1280608815063061D-16
  vmuuuu(        1842) =   0.2591619295745668D-32
  vmuuuu(        1843) =   0.1692064811520360D-30
  vmuuuu(        1844) =  -0.3044811837814060D-30
  vmuuuu(        1849) =  -0.3154856379613910D-02
  vmuuuu(        1850) =  -0.1429695724599278D-16
  vmuuuu(        1851) =   0.6587640769302247D-16
  vmuuuu(        1852) =  -0.9751122779570073D-16
  vmuuuu(        1889) =   0.4294937212574331D-30
  vmuuuu(        1890) =  -0.2081628695997299D-15
  vmuuuu(        1891) =   0.1051592025041398D-29
  vmuuuu(        1892) =   0.4229720618041553D-30
  vmuuuu(        1897) =  -0.4022396587220409D-31
  vmuuuu(        1898) =   0.3720901389010682D-16
  vmuuuu(        1899) =  -0.1876957643561048D-30
  vmuuuu(        1900) =  -0.6875439983174135D-31
  vmuuuu(        1905) =  -0.1186590865573691D-30
  vmuuuu(        1906) =  -0.4962001647217057D-16
  vmuuuu(        1907) =   0.2490010969588322D-30
  vmuuuu(        1908) =   0.5938613464809186D-31
  vmuuuu(        1913) =  -0.1429695724599278D-16
  vmuuuu(        1914) =  -0.1222418772090569D-01
  vmuuuu(        1915) =   0.6145561969187410D-16
  vmuuuu(        1916) =   0.1743008556938296D-16
  vmuuuu(        1953) =   0.3178991899941996D-31
  vmuuuu(        1954) =   0.1042031339726059D-29
  vmuuuu(        1955) =  -0.2071470690047855D-15
  vmuuuu(        1956) =  -0.3044811837814060D-30
  vmuuuu(        1961) =  -0.6488013814515927D-31
  vmuuuu(        1962) =  -0.1865384158801652D-30
  vmuuuu(        1963) =   0.3702744001711235D-16
  vmuuuu(        1964) =   0.5938613464809186D-31
  vmuuuu(        1969) =   0.3656001676799264D-30
  vmuuuu(        1970) =   0.2500582503975957D-30
  vmuuuu(        1971) =  -0.4937787894615308D-16
  vmuuuu(        1972) =  -0.1025787729088377D-30
  vmuuuu(        1977) =   0.6587640769302247D-16
  vmuuuu(        1978) =   0.6149063425342999D-16
  vmuuuu(        1979) =  -0.1216453569370466D-01
  vmuuuu(        1980) =  -0.2324386063061135D-16
  vmuuuu(        2017) =  -0.6466802959773192D-30
  vmuuuu(        2018) =   0.1742888365111538D-30
  vmuuuu(        2019) =  -0.4937143792110736D-30
  vmuuuu(        2020) =  -0.2071470690052475D-15
  vmuuuu(        2025) =   0.1706537417797537D-30
  vmuuuu(        2026) =  -0.3780828096326975D-31
  vmuuuu(        2027) =   0.8293429698484602D-31
  vmuuuu(        2028) =   0.3702744001719493D-16
  vmuuuu(        2033) =  -0.4871474855279624D-30
  vmuuuu(        2034) =   0.8178963308041476D-31
  vmuuuu(        2035) =  -0.8553103841787232D-31
  vmuuuu(        2036) =  -0.4937787894626319D-16
  vmuuuu(        2041) =  -0.9751122779570073D-16
  vmuuuu(        2042) =   0.1743008556938296D-16
  vmuuuu(        2043) =  -0.2324386063061135D-16
  vmuuuu(        2044) =  -0.1216453569373179D-01
  vmuuuu(        2305) =  -0.3655564670697051D-01
  vmuuuu(        2306) =  -0.1656603202118298D-15
  vmuuuu(        2307) =   0.7633167397132649D-15
  vmuuuu(        2308) =  -0.1129872667515467D-14
  vmuuuu(        2313) =   0.7876836713470050D-17
  vmuuuu(        2314) =   0.4823903659340465D-30
  vmuuuu(        2315) =  -0.8880016471714552D-30
  vmuuuu(        2316) =   0.9164128875560361D-30
  vmuuuu(        2321) =  -0.3629427560982316D-16
  vmuuuu(        2322) =  -0.8880016471714553D-30
  vmuuuu(        2323) =   0.1929777165488845D-29
  vmuuuu(        2324) =  -0.2211798346722220D-29
  vmuuuu(        2329) =   0.5372332069412866D-16
  vmuuuu(        2330) =   0.9164128875560363D-30
  vmuuuu(        2331) =  -0.2211798346722220D-29
  vmuuuu(        2332) =   0.2674312061074297D-29
  vmuuuu(        2369) =  -0.1656603202118298D-15
  vmuuuu(        2370) =  -0.1416429256471581D+00
  vmuuuu(        2371) =   0.7120926125610262D-15
  vmuuuu(        2372) =   0.2019642016872428D-15
  vmuuuu(        2377) =  -0.4109989717305933D-30
  vmuuuu(        2378) =   0.3052054326611325D-16
  vmuuuu(        2379) =  -0.1568093258258636D-30
  vmuuuu(        2380) =  -0.1272605351556795D-30
  vmuuuu(        2385) =   0.5590499332228012D-30
  vmuuuu(        2386) =  -0.1406301856134139D-15
  vmuuuu(        2387) =   0.7124613024589639D-30
  vmuuuu(        2388) =   0.3361601967783629D-30
  vmuuuu(        2393) =  -0.4294937212574331D-30
  vmuuuu(        2394) =   0.2081628695997299D-15
  vmuuuu(        2395) =  -0.1051592025041398D-29
  vmuuuu(        2396) =  -0.4229720618041553D-30
  vmuuuu(        2433) =   0.7633167397132649D-15
  vmuuuu(        2434) =   0.7124983299021093D-15
  vmuuuu(        2435) =  -0.1409517314470652D+00
  vmuuuu(        2436) =  -0.2693290137735762D-15
  vmuuuu(        2441) =   0.5590499332228011D-30
  vmuuuu(        2442) =  -0.1501547480754971D-30
  vmuuuu(        2443) =   0.3037160803060579D-16
  vmuuuu(        2444) =  -0.2591619295745679D-32
  vmuuuu(        2449) =  -0.4140590412373477D-30
  vmuuuu(        2450) =   0.7019438840085933D-30
  vmuuuu(        2451) =  -0.1399439334182557D-15
  vmuuuu(        2452) =  -0.1692064811520360D-30
  vmuuuu(        2457) =  -0.3178991899941996D-31
  vmuuuu(        2458) =  -0.1042031339726059D-29
  vmuuuu(        2459) =   0.2071470690047855D-15
  vmuuuu(        2460) =   0.3044811837814060D-30
  vmuuuu(        2497) =  -0.1129872667515467D-14
  vmuuuu(        2498) =   0.2019642016872428D-15
  vmuuuu(        2499) =  -0.2693290137735762D-15
  vmuuuu(        2500) =  -0.1409517314473795D+00
  vmuuuu(        2505) =  -0.4294937212574332D-30
  vmuuuu(        2506) =   0.3781105337651705D-31
  vmuuuu(        2507) =   0.1230180760739158D-30
  vmuuuu(        2508) =   0.3037160803067352D-16
  vmuuuu(        2513) =  -0.3178991899941961D-31
  vmuuuu(        2514) =   0.6878841048850754D-31
  vmuuuu(        2515) =  -0.3726605638620989D-30
  vmuuuu(        2516) =  -0.1399439334185678D-15
  vmuuuu(        2521) =   0.6466802959773192D-30
  vmuuuu(        2522) =  -0.1742888365111538D-30
  vmuuuu(        2523) =   0.4937143792110736D-30
  vmuuuu(        2524) =   0.2071470690052475D-15
  vmuuuu(        2817) =   0.7876836713470050D-17
  vmuuuu(        2818) =  -0.4109989717305933D-30
  vmuuuu(        2819) =   0.5590499332228012D-30
  vmuuuu(        2820) =  -0.4294937212574331D-30
  vmuuuu(        2825) =   0.3155472578492548D-02
  vmuuuu(        2826) =   0.1429974969292629D-16
  vmuuuu(        2827) =  -0.6588927451282811D-16
  vmuuuu(        2828) =   0.9753027345166485D-16
  vmuuuu(        2833) =  -0.3385866468710928D-16
  vmuuuu(        2834) =  -0.1568093258258636D-30
  vmuuuu(        2835) =   0.7124613024589638D-30
  vmuuuu(        2836) =  -0.1051592025041398D-29
  vmuuuu(        2841) =  -0.9603018010725434D-17
  vmuuuu(        2842) =  -0.1272605351556795D-30
  vmuuuu(        2843) =   0.3361601967783629D-30
  vmuuuu(        2844) =  -0.4229720618041554D-30
  vmuuuu(        2881) =   0.4823903659340462D-30
  vmuuuu(        2882) =   0.3052054326611325D-16
  vmuuuu(        2883) =  -0.1500673260344331D-30
  vmuuuu(        2884) =   0.4022396587220409D-31
  vmuuuu(        2889) =   0.1429974969292629D-16
  vmuuuu(        2890) =   0.1222657531953445D-01
  vmuuuu(        2891) =  -0.6146762305411425D-16
  vmuuuu(        2892) =  -0.1743348997132398D-16
  vmuuuu(        2897) =  -0.1500673260344332D-30
  vmuuuu(        2898) =  -0.1311928732442257D-15
  vmuuuu(        2899) =   0.6595816821826394D-30
  vmuuuu(        2900) =   0.1876957643561048D-30
  vmuuuu(        2905) =   0.4022396587220409D-31
  vmuuuu(        2906) =  -0.3720901389010682D-16
  vmuuuu(        2907) =   0.1876957643561048D-30
  vmuuuu(        2908) =   0.6875439983174135D-31
  vmuuuu(        2945) =  -0.8880016471714548D-30
  vmuuuu(        2946) =  -0.1568967478669275D-30
  vmuuuu(        2947) =   0.3037160803060579D-16
  vmuuuu(        2948) =   0.1186590865573691D-30
  vmuuuu(        2953) =  -0.6588927451282811D-16
  vmuuuu(        2954) =  -0.6150264445462917D-16
  vmuuuu(        2955) =   0.1216691164124448D-01
  vmuuuu(        2956) =   0.2324840056496410D-16
  vmuuuu(        2961) =   0.7015410675267787D-30
  vmuuuu(        2962) =   0.6599065879552482D-30
  vmuuuu(        2963) =  -0.1305526735825367D-15
  vmuuuu(        2964) =  -0.2490010969588322D-30
  vmuuuu(        2969) =   0.6488013814515927D-31
  vmuuuu(        2970) =   0.1865384158801652D-30
  vmuuuu(        2971) =  -0.3702744001711235D-16
  vmuuuu(        2972) =  -0.5938613464809186D-31
  vmuuuu(        3009) =   0.9164128875560359D-30
  vmuuuu(        3010) =  -0.1248476226599924D-30
  vmuuuu(        3011) =  -0.6950608812292405D-32
  vmuuuu(        3012) =   0.3037160803067352D-16
  vmuuuu(        3017) =   0.9753027345166485D-16
  vmuuuu(        3018) =  -0.1743348997132398D-16
  vmuuuu(        3019) =   0.2324840056496410D-16
  vmuuuu(        3020) =   0.1216691164127161D-01
  vmuuuu(        3025) =  -0.1041435084843718D-29
  vmuuuu(        3026) =   0.1864500447481628D-30
  vmuuuu(        3027) =  -0.2499490157488612D-30
  vmuuuu(        3028) =  -0.1305526735828279D-15
  vmuuuu(        3033) =  -0.1706537417797537D-30
  vmuuuu(        3034) =   0.3780828096326975D-31
  vmuuuu(        3035) =  -0.8293429698484602D-31
  vmuuuu(        3036) =  -0.3702744001719493D-16
  vmuuuu(        3329) =  -0.3629427560982316D-16
  vmuuuu(        3330) =   0.5590499332228011D-30
  vmuuuu(        3331) =  -0.4140590412373477D-30
  vmuuuu(        3332) =  -0.3178991899942014D-31
  vmuuuu(        3337) =  -0.3387795578375481D-16
  vmuuuu(        3338) =  -0.1501547480754971D-30
  vmuuuu(        3339) =   0.7019438840085933D-30
  vmuuuu(        3340) =  -0.1042031339726059D-29
  vmuuuu(        3345) =   0.3154856379613794D-02
  vmuuuu(        3346) =   0.1429695724599226D-16
  vmuuuu(        3347) =  -0.6587640769302006D-16
  vmuuuu(        3348) =   0.9751122779569715D-16
  vmuuuu(        3353) =   0.1280608815063061D-16
  vmuuuu(        3354) =  -0.2591619295745668D-32
  vmuuuu(        3355) =  -0.1692064811520360D-30
  vmuuuu(        3356) =   0.3044811837814060D-30
  vmuuuu(        3393) =  -0.8880016471714548D-30
  vmuuuu(        3394) =  -0.1406301856134139D-15
  vmuuuu(        3395) =   0.7015410675267788D-30
  vmuuuu(        3396) =   0.6488013814515927D-31
  vmuuuu(        3401) =  -0.1568967478669275D-30
  vmuuuu(        3402) =  -0.1312676208581776D-15
  vmuuuu(        3403) =   0.6599065879552483D-30
  vmuuuu(        3404) =   0.1865384158801652D-30
  vmuuuu(        3409) =   0.1429695724599226D-16
  vmuuuu(        3410) =   0.1222418772090524D-01
  vmuuuu(        3411) =  -0.6145561969187185D-16
  vmuuuu(        3412) =  -0.1743008556938231D-16
  vmuuuu(        3417) =   0.1186590865573691D-30
  vmuuuu(        3418) =   0.4962001647217057D-16
  vmuuuu(        3419) =  -0.2490010969588322D-30
  vmuuuu(        3420) =  -0.5938613464809186D-31
  vmuuuu(        3457) =   0.1929777165488844D-29
  vmuuuu(        3458) =   0.7128641189407785D-30
  vmuuuu(        3459) =  -0.1399439334182557D-15
  vmuuuu(        3460) =  -0.3656001676799264D-30
  vmuuuu(        3465) =   0.7128641189407785D-30
  vmuuuu(        3466) =   0.6603334653960974D-30
  vmuuuu(        3467) =  -0.1306270564404163D-15
  vmuuuu(        3468) =  -0.2500582503975957D-30
  vmuuuu(        3473) =  -0.6587640769302006D-16
  vmuuuu(        3474) =  -0.6149063425342772D-16
  vmuuuu(        3475) =   0.1216453569370421D-01
  vmuuuu(        3476) =   0.2324386063061050D-16
  vmuuuu(        3481) =  -0.3656001676799264D-30
  vmuuuu(        3482) =  -0.2500582503975957D-30
  vmuuuu(        3483) =   0.4937787894615308D-16
  vmuuuu(        3484) =   0.1025787729088377D-30
  vmuuuu(        3521) =  -0.2211798346722219D-29
  vmuuuu(        3522) =   0.3322519244350145D-30
  vmuuuu(        3523) =  -0.1621460849698637D-30
  vmuuuu(        3524) =  -0.1399439334185678D-15
  vmuuuu(        3529) =  -0.1052188279923740D-29
  vmuuuu(        3530) =   0.1877841354881072D-30
  vmuuuu(        3531) =  -0.2491103316075667D-30
  vmuuuu(        3532) =  -0.1306270564407076D-15
  vmuuuu(        3537) =   0.9751122779569715D-16
  vmuuuu(        3538) =  -0.1743008556938231D-16
  vmuuuu(        3539) =   0.2324386063061050D-16
  vmuuuu(        3540) =   0.1216453569373134D-01
  vmuuuu(        3545) =   0.4871474855279624D-30
  vmuuuu(        3546) =  -0.8178963308041476D-31
  vmuuuu(        3547) =   0.8553103841787232D-31
  vmuuuu(        3548) =   0.4937787894626319D-16
  vmuuuu(        3841) =   0.5372332069412866D-16
  vmuuuu(        3842) =  -0.4294937212574332D-30
  vmuuuu(        3843) =  -0.3178991899941961D-31
  vmuuuu(        3844) =   0.6466802959773192D-30
  vmuuuu(        3849) =  -0.9603018010725434D-17
  vmuuuu(        3850) =   0.3781105337651705D-31
  vmuuuu(        3851) =   0.6878841048850757D-31
  vmuuuu(        3852) =  -0.1742888365111539D-30
  vmuuuu(        3857) =   0.1280608815063061D-16
  vmuuuu(        3858) =   0.1230180760739158D-30
  vmuuuu(        3859) =  -0.3726605638620988D-30
  vmuuuu(        3860) =   0.4937143792110736D-30
  vmuuuu(        3865) =   0.3154856379613910D-02
  vmuuuu(        3866) =   0.1429695724599278D-16
  vmuuuu(        3867) =  -0.6587640769302247D-16
  vmuuuu(        3868) =   0.9751122779570073D-16
  vmuuuu(        3905) =   0.9164128875560361D-30
  vmuuuu(        3906) =   0.2081628695997299D-15
  vmuuuu(        3907) =  -0.1041435084843718D-29
  vmuuuu(        3908) =  -0.1706537417797537D-30
  vmuuuu(        3913) =  -0.1248476226599924D-30
  vmuuuu(        3914) =  -0.3720901389010682D-16
  vmuuuu(        3915) =   0.1864500447481628D-30
  vmuuuu(        3916) =   0.3780828096326975D-31
  vmuuuu(        3921) =  -0.6950608812292383D-32
  vmuuuu(        3922) =   0.4962001647217057D-16
  vmuuuu(        3923) =  -0.2499490157488613D-30
  vmuuuu(        3924) =  -0.8293429698484602D-31
  vmuuuu(        3929) =   0.1429695724599278D-16
  vmuuuu(        3930) =   0.1222418772090569D-01
  vmuuuu(        3931) =  -0.6145561969187410D-16
  vmuuuu(        3932) =  -0.1743008556938296D-16
  vmuuuu(        3969) =  -0.2211798346722220D-29
  vmuuuu(        3970) =  -0.1052188279923740D-29
  vmuuuu(        3971) =   0.2071470690047855D-15
  vmuuuu(        3972) =   0.4871474855279624D-30
  vmuuuu(        3977) =   0.3322519244350145D-30
  vmuuuu(        3978) =   0.1877841354881072D-30
  vmuuuu(        3979) =  -0.3702744001711235D-16
  vmuuuu(        3980) =  -0.8178963308041476D-31
  vmuuuu(        3985) =  -0.1621460849698637D-30
  vmuuuu(        3986) =  -0.2491103316075667D-30
  vmuuuu(        3987) =   0.4937787894615308D-16
  vmuuuu(        3988) =   0.8553103841787232D-31
  vmuuuu(        3993) =  -0.6587640769302247D-16
  vmuuuu(        3994) =  -0.6149063425342999D-16
  vmuuuu(        3995) =   0.1216453569370466D-01
  vmuuuu(        3996) =   0.2324386063061135D-16
  vmuuuu(        4033) =   0.2674312061074297D-29
  vmuuuu(        4034) =  -0.4193369670727552D-30
  vmuuuu(        4035) =   0.2979142900982947D-30
  vmuuuu(        4036) =   0.2071470690052475D-15
  vmuuuu(        4041) =  -0.4193369670727552D-30
  vmuuuu(        4042) =   0.6786273192871167D-31
  vmuuuu(        4043) =  -0.5891997717027451D-31
  vmuuuu(        4044) =  -0.3702744001719493D-16
  vmuuuu(        4049) =   0.2979142900982947D-30
  vmuuuu(        4050) =  -0.5891997717027450D-31
  vmuuuu(        4051) =   0.1038045125101727D-30
  vmuuuu(        4052) =   0.4937787894626319D-16
  vmuuuu(        4057) =   0.9751122779570073D-16
  vmuuuu(        4058) =  -0.1743008556938296D-16
  vmuuuu(        4059) =   0.2324386063061135D-16
  vmuuuu(        4060) =   0.1216453569373179D-01
  vmuuuu(        4386) =  -0.5860247351846986D-15
  vmuuuu(        4387) =   0.9492032011663304D-15
  vmuuuu(        4388) =  -0.8828564778655597D-15
  vmuuuu(        4393) =   0.2786437417965807D-16
  vmuuuu(        4394) =   0.2525476398273761D-30
  vmuuuu(        4395) =  -0.7863644735076172D-30
  vmuuuu(        4396) =   0.1051473973602726D-29
  vmuuuu(        4401) =  -0.4513282730547527D-16
  vmuuuu(        4402) =  -0.7863644735076173D-30
  vmuuuu(        4403) =   0.1884832888829078D-29
  vmuuuu(        4404) =  -0.2271522782166755D-29
  vmuuuu(        4409) =   0.4197816537287913D-16
  vmuuuu(        4410) =   0.1051473973602726D-29
  vmuuuu(        4411) =  -0.2271522782166756D-29
  vmuuuu(        4412) =   0.2594946934872107D-29
  vmuuuu(        4449) =   0.5860247351846984D-15
  vmuuuu(        4450) =  -0.4843315697447869D-32
  vmuuuu(        4451) =   0.4422460035975300D-17
  vmuuuu(        4452) =   0.1098625831140716D-15
  vmuuuu(        4457) =   0.4379057701015053D-46
  vmuuuu(        4458) =   0.1079666709707346D-15
  vmuuuu(        4459) =  -0.5437422612675534D-30
  vmuuuu(        4460) =  -0.1776189535604835D-30
  vmuuuu(        4465) =   0.3773049001167533D-30
  vmuuuu(        4466) =  -0.1748771059508155D-15
  vmuuuu(        4467) =   0.8835642589105590D-30
  vmuuuu(        4468) =   0.3584288471879036D-30
  vmuuuu(        4473) =  -0.6710065523410866D-30
  vmuuuu(        4474) =   0.1626536716578194D-15
  vmuuuu(        4475) =  -0.8242209727865854D-30
  vmuuuu(        4476) =  -0.3933802500615907D-30
  vmuuuu(        4513) =  -0.9492032011663300D-15
  vmuuuu(        4514) =  -0.4422460035975288D-17
  vmuuuu(        4515) =  -0.6448587185455455D-32
  vmuuuu(        4516) =   0.7953521470747876D-16
  vmuuuu(        4521) =  -0.3773049001167533D-30
  vmuuuu(        4522) =  -0.5421456561844816D-30
  vmuuuu(        4523) =   0.1074398113592336D-15
  vmuuuu(        4524) =   0.1881569370975474D-30
  vmuuuu(        4530) =   0.8752834918221036D-30
  vmuuuu(        4531) =  -0.1740237344124208D-15
  vmuuuu(        4532) =  -0.2535560904726020D-30
  vmuuuu(        4537) =   0.5184345882456554D-30
  vmuuuu(        4538) =  -0.8116881016935582D-30
  vmuuuu(        4539) =   0.1618599484700213D-15
  vmuuuu(        4540) =   0.1923927673902781D-30
  vmuuuu(        4577) =   0.8828564778655597D-15
  vmuuuu(        4578) =  -0.1066970508053803D-15
  vmuuuu(        4579) =  -0.8525383159579913D-16
  vmuuuu(        4580) =  -0.1123526299209829D-31
  vmuuuu(        4585) =   0.6710065523410867D-30
  vmuuuu(        4586) =  -0.1309557146692097D-30
  vmuuuu(        4587) =   0.2236648962455350D-30
  vmuuuu(        4588) =   0.1074398113594732D-15
  vmuuuu(        4593) =  -0.5184345882456556D-30
  vmuuuu(        4594) =   0.1434176041249746D-30
  vmuuuu(        4595) =  -0.4171669031044744D-30
  vmuuuu(        4596) =  -0.1740237344128089D-15
  vmuuuu(        4601) =   0.1751623080406021D-45
  vmuuuu(        4602) =  -0.7511744498203060D-31
  vmuuuu(        4603) =   0.4345718991779399D-30
  vmuuuu(        4604) =   0.1618599484703822D-15
  vmuuuu(        4897) =  -0.2786437417965808D-16
  vmuuuu(        4898) =  -0.2189528850507527D-46
  vmuuuu(        4899) =   0.3773049001167534D-30
  vmuuuu(        4900) =  -0.6710065523410870D-30
  vmuuuu(        4905) =  -0.2302905538984881D-33
  vmuuuu(        4906) =   0.5058548128054501D-16
  vmuuuu(        4907) =  -0.8193493871704841D-16
  vmuuuu(        4908) =   0.7620790924533359D-16
  vmuuuu(        4913) =  -0.2102796585849933D-18
  vmuuuu(        4914) =  -0.5440515174515227D-30
  vmuuuu(        4915) =   0.8840651711454524D-30
  vmuuuu(        4916) =  -0.8246868726180166D-30
  vmuuuu(        4921) =  -0.5073244129482152D-17
  vmuuuu(        4922) =  -0.1769368597294908D-30
  vmuuuu(        4923) =   0.3552859482813571D-30
  vmuuuu(        4924) =  -0.3887280848639492D-30
  vmuuuu(        4961) =  -0.2525476398273761D-30
  vmuuuu(        4962) =  -0.1079666709707346D-15
  vmuuuu(        4963) =   0.5418364000005127D-30
  vmuuuu(        4964) =   0.1302736208382169D-30
  vmuuuu(        4969) =  -0.5058548128054499D-16
  vmuuuu(        4970) =  -0.4742380313983468D-33
  vmuuuu(        4971) =  -0.3817454382591532D-18
  vmuuuu(        4972) =  -0.9483305580604264D-17
  vmuuuu(        4977) =   0.5421456561844816D-30
  vmuuuu(        4978) =  -0.8147749726551715D-18
  vmuuuu(        4979) =   0.8194698329527875D-32
  vmuuuu(        4980) =   0.1029769416085036D-30
  vmuuuu(        4985) =   0.1309557146692096D-30
  vmuuuu(        4986) =  -0.1965740468995998D-16
  vmuuuu(        4987) =   0.9998697763437624D-31
  vmuuuu(        4988) =   0.5688932496790040D-31
  vmuuuu(        5025) =   0.7863644735076173D-30
  vmuuuu(        5026) =   0.5440515174515226D-30
  vmuuuu(        5027) =  -0.1074398113592336D-15
  vmuuuu(        5028) =  -0.2224326759043859D-30
  vmuuuu(        5033) =   0.8193493871704837D-16
  vmuuuu(        5034) =   0.3817454382591521D-18
  vmuuuu(        5035) =  -0.3313171388064380D-33
  vmuuuu(        5036) =  -0.6865456137207681D-17
  vmuuuu(        5041) =  -0.8752834918221038D-30
  vmuuuu(        5042) =  -0.6842277657836021D-48
  vmuuuu(        5043) =  -0.8107990046856659D-18
  vmuuuu(        5044) =   0.7216001662323424D-31
  vmuuuu(        5049) =  -0.1434176041249746D-30
  vmuuuu(        5050) =   0.9771975954082557D-31
  vmuuuu(        5051) =  -0.1956147978549686D-16
  vmuuuu(        5052) =  -0.1648428609493801D-31
  vmuuuu(        5089) =  -0.1051473973602726D-29
  vmuuuu(        5090) =   0.1769368597294908D-30
  vmuuuu(        5091) =  -0.1869247167563983D-30
  vmuuuu(        5092) =  -0.1074398113594732D-15
  vmuuuu(        5097) =  -0.7620790924533359D-16
  vmuuuu(        5098) =   0.9210057770861569D-17
  vmuuuu(        5099) =   0.7359085450420144D-17
  vmuuuu(        5100) =   0.8186729671998025D-34
  vmuuuu(        5105) =   0.8116881016935582D-30
  vmuuuu(        5106) =  -0.9771975954082559D-31
  vmuuuu(        5107) =  -0.8055827801016497D-31
  vmuuuu(        5108) =  -0.8107990046874741D-18
  vmuuuu(        5113) =   0.7511744498203056D-31
  vmuuuu(        5115) =  -0.5977369066506413D-31
  vmuuuu(        5116) =  -0.1956147978554048D-16
  vmuuuu(        5409) =   0.4513282730547529D-16
  vmuuuu(        5410) =  -0.3773049001167534D-30
  vmuuuu(        5411) =  -0.1751623080406021D-45
  vmuuuu(        5412) =   0.5184345882456563D-30
  vmuuuu(        5417) =   0.2102796585849939D-18
  vmuuuu(        5418) =  -0.5418364000005127D-30
  vmuuuu(        5419) =   0.8747825795872111D-30
  vmuuuu(        5420) =  -0.8112222018621270D-30
  vmuuuu(        5425) =  -0.3066181945529090D-33
  vmuuuu(        5426) =   0.5057560297671858D-16
  vmuuuu(        5427) =  -0.8191893850912002D-16
  vmuuuu(        5428) =   0.7619302740844196D-16
  vmuuuu(        5433) =  -0.4053659378534932D-17
  vmuuuu(        5434) =   0.1869247167563983D-30
  vmuuuu(        5435) =  -0.2478783614170767D-30
  vmuuuu(        5436) =   0.1839885093154369D-30
  vmuuuu(        5473) =   0.7863644735076172D-30
  vmuuuu(        5474) =   0.1748771059508156D-15
  vmuuuu(        5475) =  -0.8747825795872113D-30
  vmuuuu(        5476) =  -0.1402747052184281D-30
  vmuuuu(        5481) =   0.5437422612675534D-30
  vmuuuu(        5482) =   0.8147749726551737D-18
  vmuuuu(        5484) =   0.1005954409566125D-30
  vmuuuu(        5489) =  -0.5057560297671856D-16
  vmuuuu(        5490) =  -0.7700679715010693D-33
  vmuuuu(        5491) =  -0.3816708912285030D-18
  vmuuuu(        5492) =  -0.9481453686119274D-17
  vmuuuu(        5497) =  -0.2236648962455350D-30
  vmuuuu(        5498) =  -0.1570679842037220D-16
  vmuuuu(        5499) =   0.7741475638264346D-31
  vmuuuu(        5500) =  -0.1609097079398156D-31
  vmuuuu(        5537) =  -0.1884832888829078D-29
  vmuuuu(        5538) =  -0.8840651711454524D-30
  vmuuuu(        5539) =   0.1740237344124208D-15
  vmuuuu(        5540) =   0.4114891740489492D-30
  vmuuuu(        5545) =  -0.8835642589105590D-30
  vmuuuu(        5546) =  -0.8194698329527875D-32
  vmuuuu(        5547) =   0.8107990046856681D-18
  vmuuuu(        5548) =   0.7521657599718537D-31
  vmuuuu(        5553) =   0.8191893850911998D-16
  vmuuuu(        5554) =   0.3816708912285019D-18
  vmuuuu(        5555) =  -0.6257309350107612D-33
  vmuuuu(        5556) =  -0.6864115454863389D-17
  vmuuuu(        5561) =   0.4171669031044745D-30
  vmuuuu(        5562) =   0.8055827801016497D-31
  vmuuuu(        5563) =  -0.1563015182527690D-16
  vmuuuu(        5564) =  -0.5772851100499692D-31
  vmuuuu(        5601) =   0.2271522782166756D-29
  vmuuuu(        5602) =  -0.3552859482813572D-30
  vmuuuu(        5603) =   0.2478783614170767D-30
  vmuuuu(        5604) =   0.1740237344128089D-15
  vmuuuu(        5609) =   0.8242209727865854D-30
  vmuuuu(        5610) =  -0.9998697763437622D-31
  vmuuuu(        5611) =  -0.7741475638264345D-31
  vmuuuu(        5612) =   0.8107990046874763D-18
  vmuuuu(        5617) =  -0.7619302740844196D-16
  vmuuuu(        5618) =   0.9208259236052441D-17
  vmuuuu(        5619) =   0.7357648372426150D-17
  vmuuuu(        5620) =  -0.2126271859050388D-33
  vmuuuu(        5625) =  -0.4345718991779398D-30
  vmuuuu(        5626) =   0.5977369066506414D-31
  vmuuuu(        5627) =  -0.5473822126268817D-47
  vmuuuu(        5628) =  -0.1563015182531176D-16
  vmuuuu(        5921) =  -0.4197816537287913D-16
  vmuuuu(        5922) =   0.6710065523410869D-30
  vmuuuu(        5923) =  -0.5184345882456559D-30
  vmuuuu(        5924) =  -0.1751623080406021D-45
  vmuuuu(        5929) =   0.5223759238199143D-17
  vmuuuu(        5930) =  -0.1302736208382169D-30
  vmuuuu(        5931) =   0.1402747052184281D-30
  vmuuuu(        5932) =  -0.7046527978438905D-31
  vmuuuu(        5937) =   0.3781749898952898D-17
  vmuuuu(        5938) =   0.2224326759043859D-30
  vmuuuu(        5939) =  -0.4114891740489492D-30
  vmuuuu(        5940) =   0.4261676411030987D-30
  vmuuuu(        5945) =  -0.5342156281509563D-33
  vmuuuu(        5946) =   0.5057560297672044D-16
  vmuuuu(        5947) =  -0.8191893850912303D-16
  vmuuuu(        5948) =   0.7619302740844476D-16
  vmuuuu(        5985) =  -0.1051473973602726D-29
  vmuuuu(        5986) =  -0.1626536716578194D-15
  vmuuuu(        5987) =   0.8112222018621270D-30
  vmuuuu(        5988) =   0.7046527978438909D-31
  vmuuuu(        5993) =   0.1776189535604835D-30
  vmuuuu(        5994) =   0.2024060871651354D-16
  vmuuuu(        5995) =  -0.1005954409566125D-30
  vmuuuu(        6001) =  -0.1881569370975474D-30
  vmuuuu(        6002) =   0.1465322509672336D-16
  vmuuuu(        6003) =  -0.7521657599718538D-31
  vmuuuu(        6004) =  -0.5938037536410768D-31
  vmuuuu(        6009) =  -0.5057560297672043D-16
  vmuuuu(        6010) =  -0.1651944487680019D-32
  vmuuuu(        6011) =  -0.3816708912285170D-18
  vmuuuu(        6012) =  -0.9481453686119622D-17
  vmuuuu(        6049) =   0.2271522782166755D-29
  vmuuuu(        6050) =   0.8246868726180166D-30
  vmuuuu(        6051) =  -0.1618599484700213D-15
  vmuuuu(        6052) =  -0.4261676411030987D-30
  vmuuuu(        6057) =  -0.3584288471879036D-30
  vmuuuu(        6058) =  -0.1029769416085036D-30
  vmuuuu(        6059) =   0.2014183787224239D-16
  vmuuuu(        6060) =   0.5938037536410768D-31
  vmuuuu(        6065) =   0.2535560904726020D-30
  vmuuuu(        6066) =  -0.7216001662323424D-31
  vmuuuu(        6067) =   0.1458171976630720D-16
  vmuuuu(        6073) =   0.8191893850912300D-16
  vmuuuu(        6074) =   0.3816708912285159D-18
  vmuuuu(        6075) =  -0.1503304038715019D-32
  vmuuuu(        6076) =  -0.6864115454863641D-17
  vmuuuu(        6113) =  -0.2594946934872107D-29
  vmuuuu(        6114) =   0.3887280848639492D-30
  vmuuuu(        6115) =  -0.1839885093154370D-30
  vmuuuu(        6116) =  -0.1618599484703822D-15
  vmuuuu(        6121) =   0.3933802500615907D-30
  vmuuuu(        6122) =  -0.5688932496790040D-31
  vmuuuu(        6123) =   0.1609097079398156D-31
  vmuuuu(        6124) =   0.2014183787228731D-16
  vmuuuu(        6129) =  -0.1923927673902780D-30
  vmuuuu(        6130) =   0.1648428609493801D-31
  vmuuuu(        6131) =   0.5772851100499691D-31
  vmuuuu(        6132) =   0.1458171976633972D-16
  vmuuuu(        6137) =  -0.7619302740844476D-16
  vmuuuu(        6138) =   0.9208259236052780D-17
  vmuuuu(        6139) =   0.7357648372426421D-17
  vmuuuu(        6140) =  -0.1090200289611239D-32
  vmuuuu(        6402) =   0.5860247351846986D-15
  vmuuuu(        6403) =  -0.9492032011663304D-15
  vmuuuu(        6404) =   0.8828564778655597D-15
  vmuuuu(        6409) =   0.2786437417965808D-16
  vmuuuu(        6410) =   0.2189528850507527D-46
  vmuuuu(        6411) =  -0.3773049001167534D-30
  vmuuuu(        6412) =   0.6710065523410870D-30
  vmuuuu(        6417) =  -0.4513282730547529D-16
  vmuuuu(        6418) =   0.3773049001167534D-30
  vmuuuu(        6419) =   0.1751623080406021D-45
  vmuuuu(        6420) =  -0.5184345882456563D-30
  vmuuuu(        6425) =   0.4197816537287913D-16
  vmuuuu(        6426) =  -0.6710065523410869D-30
  vmuuuu(        6427) =   0.5184345882456559D-30
  vmuuuu(        6428) =   0.1751623080406021D-45
  vmuuuu(        6465) =  -0.5860247351846984D-15
  vmuuuu(        6466) =   0.4843315697447869D-32
  vmuuuu(        6467) =  -0.4422460035975300D-17
  vmuuuu(        6468) =  -0.1098625831140716D-15
  vmuuuu(        6473) =   0.2525476398273761D-30
  vmuuuu(        6474) =   0.1079666709707346D-15
  vmuuuu(        6475) =  -0.5418364000005127D-30
  vmuuuu(        6476) =  -0.1302736208382169D-30
  vmuuuu(        6481) =  -0.7863644735076172D-30
  vmuuuu(        6482) =  -0.1748771059508156D-15
  vmuuuu(        6483) =   0.8747825795872113D-30
  vmuuuu(        6484) =   0.1402747052184281D-30
  vmuuuu(        6489) =   0.1051473973602726D-29
  vmuuuu(        6490) =   0.1626536716578194D-15
  vmuuuu(        6491) =  -0.8112222018621270D-30
  vmuuuu(        6492) =  -0.7046527978438909D-31
  vmuuuu(        6529) =   0.9492032011663300D-15
  vmuuuu(        6530) =   0.4422460035975288D-17
  vmuuuu(        6531) =   0.6448587185455455D-32
  vmuuuu(        6532) =  -0.7953521470747876D-16
  vmuuuu(        6537) =  -0.7863644735076173D-30
  vmuuuu(        6538) =  -0.5440515174515226D-30
  vmuuuu(        6539) =   0.1074398113592336D-15
  vmuuuu(        6540) =   0.2224326759043859D-30
  vmuuuu(        6545) =   0.1884832888829078D-29
  vmuuuu(        6546) =   0.8840651711454524D-30
  vmuuuu(        6547) =  -0.1740237344124208D-15
  vmuuuu(        6548) =  -0.4114891740489492D-30
  vmuuuu(        6553) =  -0.2271522782166755D-29
  vmuuuu(        6554) =  -0.8246868726180166D-30
  vmuuuu(        6555) =   0.1618599484700213D-15
  vmuuuu(        6556) =   0.4261676411030987D-30
  vmuuuu(        6593) =  -0.8828564778655597D-15
  vmuuuu(        6594) =   0.1066970508053803D-15
  vmuuuu(        6595) =   0.8525383159579913D-16
  vmuuuu(        6596) =   0.1123526299209829D-31
  vmuuuu(        6601) =   0.1051473973602726D-29
  vmuuuu(        6602) =  -0.1769368597294908D-30
  vmuuuu(        6603) =   0.1869247167563983D-30
  vmuuuu(        6604) =   0.1074398113594732D-15
  vmuuuu(        6609) =  -0.2271522782166756D-29
  vmuuuu(        6610) =   0.3552859482813572D-30
  vmuuuu(        6611) =  -0.2478783614170767D-30
  vmuuuu(        6612) =  -0.1740237344128089D-15
  vmuuuu(        6617) =   0.2594946934872107D-29
  vmuuuu(        6618) =  -0.3887280848639492D-30
  vmuuuu(        6619) =   0.1839885093154370D-30
  vmuuuu(        6620) =   0.1618599484703822D-15
  vmuuuu(        6913) =  -0.2786437417965807D-16
  vmuuuu(        6914) =  -0.2525476398273761D-30
  vmuuuu(        6915) =   0.7863644735076172D-30
  vmuuuu(        6916) =  -0.1051473973602726D-29
  vmuuuu(        6921) =   0.2302905538984881D-33
  vmuuuu(        6922) =  -0.5058548128054501D-16
  vmuuuu(        6923) =   0.8193493871704841D-16
  vmuuuu(        6924) =  -0.7620790924533359D-16
  vmuuuu(        6929) =  -0.2102796585849939D-18
  vmuuuu(        6930) =   0.5418364000005127D-30
  vmuuuu(        6931) =  -0.8747825795872111D-30
  vmuuuu(        6932) =   0.8112222018621270D-30
  vmuuuu(        6937) =  -0.5223759238199143D-17
  vmuuuu(        6938) =   0.1302736208382169D-30
  vmuuuu(        6939) =  -0.1402747052184281D-30
  vmuuuu(        6940) =   0.7046527978438905D-31
  vmuuuu(        6977) =  -0.4379057701015053D-46
  vmuuuu(        6978) =  -0.1079666709707346D-15
  vmuuuu(        6979) =   0.5437422612675534D-30
  vmuuuu(        6980) =   0.1776189535604835D-30
  vmuuuu(        6985) =   0.5058548128054499D-16
  vmuuuu(        6986) =   0.4742380313983468D-33
  vmuuuu(        6987) =   0.3817454382591532D-18
  vmuuuu(        6988) =   0.9483305580604264D-17
  vmuuuu(        6993) =  -0.5437422612675534D-30
  vmuuuu(        6994) =  -0.8147749726551737D-18
  vmuuuu(        6996) =  -0.1005954409566125D-30
  vmuuuu(        7001) =  -0.1776189535604835D-30
  vmuuuu(        7002) =  -0.2024060871651354D-16
  vmuuuu(        7003) =   0.1005954409566125D-30
  vmuuuu(        7041) =   0.3773049001167533D-30
  vmuuuu(        7042) =   0.5421456561844816D-30
  vmuuuu(        7043) =  -0.1074398113592336D-15
  vmuuuu(        7044) =  -0.1881569370975474D-30
  vmuuuu(        7049) =  -0.8193493871704837D-16
  vmuuuu(        7050) =  -0.3817454382591521D-18
  vmuuuu(        7051) =   0.3313171388064380D-33
  vmuuuu(        7052) =   0.6865456137207681D-17
  vmuuuu(        7057) =   0.8835642589105590D-30
  vmuuuu(        7058) =   0.8194698329527875D-32
  vmuuuu(        7059) =  -0.8107990046856681D-18
  vmuuuu(        7060) =  -0.7521657599718537D-31
  vmuuuu(        7065) =   0.3584288471879036D-30
  vmuuuu(        7066) =   0.1029769416085036D-30
  vmuuuu(        7067) =  -0.2014183787224239D-16
  vmuuuu(        7068) =  -0.5938037536410768D-31
  vmuuuu(        7105) =  -0.6710065523410867D-30
  vmuuuu(        7106) =   0.1309557146692097D-30
  vmuuuu(        7107) =  -0.2236648962455350D-30
  vmuuuu(        7108) =  -0.1074398113594732D-15
  vmuuuu(        7113) =   0.7620790924533359D-16
  vmuuuu(        7114) =  -0.9210057770861569D-17
  vmuuuu(        7115) =  -0.7359085450420144D-17
  vmuuuu(        7116) =  -0.8186729671998025D-34
  vmuuuu(        7121) =  -0.8242209727865854D-30
  vmuuuu(        7122) =   0.9998697763437622D-31
  vmuuuu(        7123) =   0.7741475638264345D-31
  vmuuuu(        7124) =  -0.8107990046874763D-18
  vmuuuu(        7129) =  -0.3933802500615907D-30
  vmuuuu(        7130) =   0.5688932496790040D-31
  vmuuuu(        7131) =  -0.1609097079398156D-31
  vmuuuu(        7132) =  -0.2014183787228731D-16
  vmuuuu(        7425) =   0.4513282730547527D-16
  vmuuuu(        7426) =   0.7863644735076173D-30
  vmuuuu(        7427) =  -0.1884832888829078D-29
  vmuuuu(        7428) =   0.2271522782166755D-29
  vmuuuu(        7433) =   0.2102796585849933D-18
  vmuuuu(        7434) =   0.5440515174515227D-30
  vmuuuu(        7435) =  -0.8840651711454524D-30
  vmuuuu(        7436) =   0.8246868726180166D-30
  vmuuuu(        7441) =   0.3066181945529090D-33
  vmuuuu(        7442) =  -0.5057560297671858D-16
  vmuuuu(        7443) =   0.8191893850912002D-16
  vmuuuu(        7444) =  -0.7619302740844196D-16
  vmuuuu(        7449) =  -0.3781749898952898D-17
  vmuuuu(        7450) =  -0.2224326759043859D-30
  vmuuuu(        7451) =   0.4114891740489492D-30
  vmuuuu(        7452) =  -0.4261676411030987D-30
  vmuuuu(        7489) =  -0.3773049001167533D-30
  vmuuuu(        7490) =   0.1748771059508155D-15
  vmuuuu(        7491) =  -0.8835642589105590D-30
  vmuuuu(        7492) =  -0.3584288471879036D-30
  vmuuuu(        7497) =  -0.5421456561844816D-30
  vmuuuu(        7498) =   0.8147749726551715D-18
  vmuuuu(        7499) =  -0.8194698329527875D-32
  vmuuuu(        7500) =  -0.1029769416085036D-30
  vmuuuu(        7505) =   0.5057560297671856D-16
  vmuuuu(        7506) =   0.7700679715010693D-33
  vmuuuu(        7507) =   0.3816708912285030D-18
  vmuuuu(        7508) =   0.9481453686119274D-17
  vmuuuu(        7513) =   0.1881569370975474D-30
  vmuuuu(        7514) =  -0.1465322509672336D-16
  vmuuuu(        7515) =   0.7521657599718538D-31
  vmuuuu(        7516) =   0.5938037536410768D-31
  vmuuuu(        7554) =  -0.8752834918221036D-30
  vmuuuu(        7555) =   0.1740237344124208D-15
  vmuuuu(        7556) =   0.2535560904726020D-30
  vmuuuu(        7561) =   0.8752834918221038D-30
  vmuuuu(        7562) =   0.6842277657836021D-48
  vmuuuu(        7563) =   0.8107990046856659D-18
  vmuuuu(        7564) =  -0.7216001662323424D-31
  vmuuuu(        7569) =  -0.8191893850911998D-16
  vmuuuu(        7570) =  -0.3816708912285019D-18
  vmuuuu(        7571) =   0.6257309350107612D-33
  vmuuuu(        7572) =   0.6864115454863389D-17
  vmuuuu(        7577) =  -0.2535560904726020D-30
  vmuuuu(        7578) =   0.7216001662323424D-31
  vmuuuu(        7579) =  -0.1458171976630720D-16
  vmuuuu(        7617) =   0.5184345882456556D-30
  vmuuuu(        7618) =  -0.1434176041249746D-30
  vmuuuu(        7619) =   0.4171669031044744D-30
  vmuuuu(        7620) =   0.1740237344128089D-15
  vmuuuu(        7625) =  -0.8116881016935582D-30
  vmuuuu(        7626) =   0.9771975954082559D-31
  vmuuuu(        7627) =   0.8055827801016497D-31
  vmuuuu(        7628) =   0.8107990046874741D-18
  vmuuuu(        7633) =   0.7619302740844196D-16
  vmuuuu(        7634) =  -0.9208259236052441D-17
  vmuuuu(        7635) =  -0.7357648372426150D-17
  vmuuuu(        7636) =   0.2126271859050388D-33
  vmuuuu(        7641) =   0.1923927673902780D-30
  vmuuuu(        7642) =  -0.1648428609493801D-31
  vmuuuu(        7643) =  -0.5772851100499691D-31
  vmuuuu(        7644) =  -0.1458171976633972D-16
  vmuuuu(        7937) =  -0.4197816537287913D-16
  vmuuuu(        7938) =  -0.1051473973602726D-29
  vmuuuu(        7939) =   0.2271522782166756D-29
  vmuuuu(        7940) =  -0.2594946934872107D-29
  vmuuuu(        7945) =   0.5073244129482152D-17
  vmuuuu(        7946) =   0.1769368597294908D-30
  vmuuuu(        7947) =  -0.3552859482813571D-30
  vmuuuu(        7948) =   0.3887280848639492D-30
  vmuuuu(        7953) =   0.4053659378534932D-17
  vmuuuu(        7954) =  -0.1869247167563983D-30
  vmuuuu(        7955) =   0.2478783614170767D-30
  vmuuuu(        7956) =  -0.1839885093154369D-30
  vmuuuu(        7961) =   0.5342156281509563D-33
  vmuuuu(        7962) =  -0.5057560297672044D-16
  vmuuuu(        7963) =   0.8191893850912303D-16
  vmuuuu(        7964) =  -0.7619302740844476D-16
  vmuuuu(        8001) =   0.6710065523410866D-30
  vmuuuu(        8002) =  -0.1626536716578194D-15
  vmuuuu(        8003) =   0.8242209727865854D-30
  vmuuuu(        8004) =   0.3933802500615907D-30
  vmuuuu(        8009) =  -0.1309557146692096D-30
  vmuuuu(        8010) =   0.1965740468995998D-16
  vmuuuu(        8011) =  -0.9998697763437624D-31
  vmuuuu(        8012) =  -0.5688932496790040D-31
  vmuuuu(        8017) =   0.2236648962455350D-30
  vmuuuu(        8018) =   0.1570679842037220D-16
  vmuuuu(        8019) =  -0.7741475638264346D-31
  vmuuuu(        8020) =   0.1609097079398156D-31
  vmuuuu(        8025) =   0.5057560297672043D-16
  vmuuuu(        8026) =   0.1651944487680019D-32
  vmuuuu(        8027) =   0.3816708912285170D-18
  vmuuuu(        8028) =   0.9481453686119622D-17
  vmuuuu(        8065) =  -0.5184345882456554D-30
  vmuuuu(        8066) =   0.8116881016935582D-30
  vmuuuu(        8067) =  -0.1618599484700213D-15
  vmuuuu(        8068) =  -0.1923927673902781D-30
  vmuuuu(        8073) =   0.1434176041249746D-30
  vmuuuu(        8074) =  -0.9771975954082557D-31
  vmuuuu(        8075) =   0.1956147978549686D-16
  vmuuuu(        8076) =   0.1648428609493801D-31
  vmuuuu(        8081) =  -0.4171669031044745D-30
  vmuuuu(        8082) =  -0.8055827801016497D-31
  vmuuuu(        8083) =   0.1563015182527690D-16
  vmuuuu(        8084) =   0.5772851100499692D-31
  vmuuuu(        8089) =  -0.8191893850912300D-16
  vmuuuu(        8090) =  -0.3816708912285159D-18
  vmuuuu(        8091) =   0.1503304038715019D-32
  vmuuuu(        8092) =   0.6864115454863641D-17
  vmuuuu(        8129) =  -0.1751623080406021D-45
  vmuuuu(        8130) =   0.7511744498203060D-31
  vmuuuu(        8131) =  -0.4345718991779399D-30
  vmuuuu(        8132) =  -0.1618599484703822D-15
  vmuuuu(        8137) =  -0.7511744498203056D-31
  vmuuuu(        8139) =   0.5977369066506413D-31
  vmuuuu(        8140) =   0.1956147978554048D-16
  vmuuuu(        8145) =   0.4345718991779398D-30
  vmuuuu(        8146) =  -0.5977369066506414D-31
  vmuuuu(        8147) =   0.5473822126268817D-47
  vmuuuu(        8148) =   0.1563015182531176D-16
  vmuuuu(        8153) =   0.7619302740844476D-16
  vmuuuu(        8154) =  -0.9208259236052780D-17
  vmuuuu(        8155) =  -0.7357648372426421D-17
  vmuuuu(        8156) =   0.1090200289611239D-32

  end subroutine

  subroutine get_data_vduuuu_ref(vduuuu_ref)
  implicit none
  integer :: i
  real(8), dimension(*) :: vduuuu_ref

  do i=1,960
    vduuuu_ref(i) = 0.0d0
  enddo

  vduuuu_ref(           1) =  -0.1462225868278820D+00
  vduuuu_ref(           2) =  -0.3155669669967194D-15
  vduuuu_ref(           3) =   0.1454044928206883D-14
  vduuuu_ref(           4) =  -0.2152298693642677D-14
  vduuuu_ref(           5) =  -0.3155669669967194D-15
  vduuuu_ref(           6) =   0.1929561463736185D-29
  vduuuu_ref(           7) =  -0.3552006588685820D-29
  vduuuu_ref(           8) =   0.3665651550224144D-29
  vduuuu_ref(           9) =   0.1454044928206883D-14
  vduuuu_ref(          10) =  -0.3552006588685820D-29
  vduuuu_ref(          11) =   0.7719108661955379D-29
  vduuuu_ref(          12) =  -0.8847193386888877D-29
  vduuuu_ref(          13) =  -0.2152298693642678D-14
  vduuuu_ref(          14) =   0.3665651550224144D-29
  vduuuu_ref(          15) =  -0.8847193386888877D-29
  vduuuu_ref(          16) =   0.1069724824429719D-28
  vduuuu_ref(          17) =  -0.3155669669967194D-15
  vduuuu_ref(          18) =  -0.1643995886922373D-29
  vduuuu_ref(          19) =   0.2236199732891205D-29
  vduuuu_ref(          20) =  -0.1717974885029733D-29
  vduuuu_ref(          21) =  -0.2769749061373312D+00
  vduuuu_ref(          22) =   0.8964058591807906D-16
  vduuuu_ref(          23) =  -0.4130389202524841D-15
  vduuuu_ref(          24) =   0.6113862861027895D-15
  vduuuu_ref(          25) =   0.1356854321992271D-14
  vduuuu_ref(          26) =  -0.6274121473855821D-30
  vduuuu_ref(          27) =   0.2850650842799484D-29
  vduuuu_ref(          28) =  -0.4207560609930276D-29
  vduuuu_ref(          29) =   0.3847223673530347D-15
  vduuuu_ref(          30) =  -0.5042163156313438D-30
  vduuuu_ref(          31) =   0.1336824242426755D-29
  vduuuu_ref(          32) =  -0.1684618057753821D-29
  vduuuu_ref(          33) =   0.1929561463736185D-29
  vduuuu_ref(          34) =   0.8964058591807908D-16
  vduuuu_ref(          35) =  -0.6004441482198605D-30
  vduuuu_ref(          36) =   0.1560700384974423D-30
  vduuuu_ref(          37) =   0.8964058591807906D-16
  vduuuu_ref(          38) =   0.4890630127813779D-01
  vduuuu_ref(          39) =  -0.3854307616111467D-15
  vduuuu_ref(          40) =  -0.1092850077228616D-15
  vduuuu_ref(          41) =  -0.6004441482198605D-30
  vduuuu_ref(          42) =  -0.3854307616111467D-15
  vduuuu_ref(          43) =   0.2639830295157474D-29
  vduuuu_ref(          44) =   0.7509597996884239D-30
  vduuuu_ref(          45) =   0.1560700384974423D-30
  vduuuu_ref(          46) =  -0.1092850077228616D-15
  vduuuu_ref(          47) =   0.7509597996884239D-30
  vduuuu_ref(          48) =   0.2732342635209060D-30
  vduuuu_ref(          49) =   0.1454044928206883D-14
  vduuuu_ref(          50) =   0.2236199732891205D-29
  vduuuu_ref(          51) =  -0.1656236164949391D-29
  vduuuu_ref(          52) =  -0.1271596759976793D-30
  vduuuu_ref(          53) =   0.1356854321992271D-14
  vduuuu_ref(          54) =  -0.6004441482198605D-30
  vduuuu_ref(          55) =   0.2806969903070745D-29
  vduuuu_ref(          56) =  -0.4166932849139554D-29
  vduuuu_ref(          57) =  -0.2755937501349027D+00
  vduuuu_ref(          58) =   0.8933713055319609D-16
  vduuuu_ref(          59) =  -0.4116406822225516D-15
  vduuuu_ref(          60) =   0.6093165936009654D-15
  vduuuu_ref(          61) =  -0.5130458512458912D-15
  vduuuu_ref(          62) =  -0.1908445621607614D-31
  vduuuu_ref(          63) =  -0.6627051322437996D-30
  vduuuu_ref(          64) =   0.1204790947759401D-29
  vduuuu_ref(          65) =  -0.3552006588685821D-29
  vduuuu_ref(          66) =  -0.4130389202524841D-15
  vduuuu_ref(          67) =   0.2806969903070744D-29
  vduuuu_ref(          68) =   0.2673370972673337D-30
  vduuuu_ref(          69) =  -0.6274121473855821D-30
  vduuuu_ref(          70) =  -0.3854307616111467D-15
  vduuuu_ref(          71) =   0.2639626351820993D-29
  vduuuu_ref(          72) =   0.7459769212566560D-30
  vduuuu_ref(          73) =   0.8933713055319609D-16
  vduuuu_ref(          74) =   0.4878219872429944D-01
  vduuuu_ref(          75) =  -0.3841259839682526D-15
  vduuuu_ref(          76) =  -0.1089150511729893D-15
  vduuuu_ref(          77) =   0.4833543252625699D-30
  vduuuu_ref(          78) =   0.1457368340742694D-15
  vduuuu_ref(          79) =  -0.9962228571327978D-30
  vduuuu_ref(          80) =  -0.2366122236367327D-30
  vduuuu_ref(          81) =   0.7719108661955379D-29
  vduuuu_ref(          82) =   0.2850650842799485D-29
  vduuuu_ref(          83) =  -0.4116406822225516D-15
  vduuuu_ref(          84) =  -0.1476521463084051D-29
  vduuuu_ref(          85) =   0.2850650842799485D-29
  vduuuu_ref(          86) =   0.2639830295157474D-29
  vduuuu_ref(          87) =  -0.3841259839682526D-15
  vduuuu_ref(          88) =  -0.1000014532292914D-29
  vduuuu_ref(          89) =  -0.4116406822225516D-15
  vduuuu_ref(          90) =  -0.3841259839682526D-15
  vduuuu_ref(          91) =   0.4865814277481686D-01
  vduuuu_ref(          92) =   0.1452434791535272D-15
  vduuuu_ref(          93) =  -0.1476521463084051D-29
  vduuuu_ref(          94) =  -0.1000014532292914D-29
  vduuuu_ref(          95) =   0.1452434791535272D-15
  vduuuu_ref(          96) =   0.4127665708380207D-30
  vduuuu_ref(          97) =  -0.2152298693642678D-14
  vduuuu_ref(          98) =  -0.1717974885029733D-29
  vduuuu_ref(          99) =  -0.1271596759976793D-30
  vduuuu_ref(         100) =   0.2586721183909277D-29
  vduuuu_ref(         101) =   0.3847223673530347D-15
  vduuuu_ref(         102) =   0.1560700384974423D-30
  vduuuu_ref(         103) =   0.2673370972673337D-30
  vduuuu_ref(         104) =  -0.6898851565818151D-30
  vduuuu_ref(         105) =  -0.5130458512458912D-15
  vduuuu_ref(         106) =   0.4833543252625699D-30
  vduuuu_ref(         107) =  -0.1476521463084050D-29
  vduuuu_ref(         108) =   0.1961723729478072D-29
  vduuuu_ref(         109) =  -0.2755937501355312D+00
  vduuuu_ref(         110) =   0.8933713055333262D-16
  vduuuu_ref(         111) =  -0.4116406822231806D-15
  vduuuu_ref(         112) =   0.6093165936018964D-15
  vduuuu_ref(         113) =   0.3665651550224145D-29
  vduuuu_ref(         114) =   0.6113862861027894D-15
  vduuuu_ref(         115) =  -0.4166932849139554D-29
  vduuuu_ref(         116) =  -0.6898851565818151D-30
  vduuuu_ref(         117) =  -0.5042163156313438D-30
  vduuuu_ref(         118) =  -0.1092850077228616D-15
  vduuuu_ref(         119) =   0.7459769212566560D-30
  vduuuu_ref(         120) =   0.1512331238530790D-30
  vduuuu_ref(         121) =  -0.1908445621607614D-31
  vduuuu_ref(         122) =   0.1457368340742694D-15
  vduuuu_ref(         123) =  -0.1000014532292914D-29
  vduuuu_ref(         124) =  -0.3294478601305216D-30
  vduuuu_ref(         125) =   0.8933713055333262D-16
  vduuuu_ref(         126) =   0.4878219872435460D-01
  vduuuu_ref(         127) =  -0.3841259839688396D-15
  vduuuu_ref(         128) =  -0.1089150511731558D-15
  vduuuu_ref(         129) =  -0.8847193386888878D-29
  vduuuu_ref(         130) =  -0.4207560609930276D-29
  vduuuu_ref(         131) =   0.6093165936009654D-15
  vduuuu_ref(         132) =   0.1961723729478072D-29
  vduuuu_ref(         133) =   0.1336824242426755D-29
  vduuuu_ref(         134) =   0.7509597996884240D-30
  vduuuu_ref(         135) =  -0.1089150511729893D-15
  vduuuu_ref(         136) =  -0.3294478601305216D-30
  vduuuu_ref(         137) =  -0.6627051322437995D-30
  vduuuu_ref(         138) =  -0.9962228571327976D-30
  vduuuu_ref(         139) =   0.1452434791535272D-15
  vduuuu_ref(         140) =   0.3421241536714893D-30
  vduuuu_ref(         141) =  -0.4116406822231806D-15
  vduuuu_ref(         142) =  -0.3841259839688396D-15
  vduuuu_ref(         143) =   0.4865814277487202D-01
  vduuuu_ref(         144) =   0.1452434791537491D-15
  vduuuu_ref(         145) =   0.1069724824429719D-28
  vduuuu_ref(         146) =  -0.1684618057753821D-29
  vduuuu_ref(         147) =   0.1204790947759401D-29
  vduuuu_ref(         148) =   0.6093165936018964D-15
  vduuuu_ref(         149) =  -0.1684618057753821D-29
  vduuuu_ref(         150) =   0.2732342635209060D-30
  vduuuu_ref(         151) =  -0.2366122236367327D-30
  vduuuu_ref(         152) =  -0.1089150511731558D-15
  vduuuu_ref(         153) =   0.1204790947759401D-29
  vduuuu_ref(         154) =  -0.2366122236367327D-30
  vduuuu_ref(         155) =   0.4127665708380207D-30
  vduuuu_ref(         156) =   0.1452434791537491D-15
  vduuuu_ref(         157) =   0.6093165936018964D-15
  vduuuu_ref(         158) =  -0.1089150511731558D-15
  vduuuu_ref(         159) =   0.1452434791537491D-15
  vduuuu_ref(         160) =   0.4865814277492716D-01
  vduuuu_ref(         162) =   0.1116320722010081D-14
  vduuuu_ref(         163) =  -0.1808140747721710D-14
  vduuuu_ref(         164) =   0.1681756624985361D-14
  vduuuu_ref(         165) =  -0.1116320722010081D-14
  vduuuu_ref(         167) =  -0.1509219600467013D-29
  vduuuu_ref(         168) =   0.2684026209364347D-29
  vduuuu_ref(         169) =   0.1808140747721710D-14
  vduuuu_ref(         170) =   0.1509219600467013D-29
  vduuuu_ref(         172) =  -0.2073738352982623D-29
  vduuuu_ref(         173) =  -0.1681756624985361D-14
  vduuuu_ref(         174) =  -0.2684026209364347D-29
  vduuuu_ref(         175) =   0.2073738352982623D-29
  vduuuu_ref(         177) =   0.1116320722010081D-14
  vduuuu_ref(         178) =  -0.1010190559309504D-29
  vduuuu_ref(         179) =   0.3145457894030469D-29
  vduuuu_ref(         180) =  -0.4205895894410904D-29
  vduuuu_ref(         182) =  -0.3171043045025591D-15
  vduuuu_ref(         183) =   0.5136240893357279D-15
  vduuuu_ref(         184) =  -0.4777231618063059D-15
  vduuuu_ref(         185) =   0.8424360754780602D-17
  vduuuu_ref(         186) =   0.2167964112369989D-29
  vduuuu_ref(         187) =  -0.3500132142818630D-29
  vduuuu_ref(         188) =   0.3245820607111370D-29
  vduuuu_ref(         189) =   0.2062626305517706D-15
  vduuuu_ref(         190) =   0.5224586710148532D-30
  vduuuu_ref(         191) =  -0.5673846186868054D-30
  vduuuu_ref(         192) =   0.2911654495328393D-30
  vduuuu_ref(         194) =  -0.3171043045025592D-15
  vduuuu_ref(         195) =   0.2175587557438152D-29
  vduuuu_ref(         196) =   0.7091116265799486D-30
  vduuuu_ref(         197) =   0.3171043045025591D-15
  vduuuu_ref(         199) =   0.2393040821828650D-17
  vduuuu_ref(         200) =   0.5859137675793935D-16
  vduuuu_ref(         201) =  -0.2175587557438152D-29
  vduuuu_ref(         202) =  -0.2393040821828650D-17
  vduuuu_ref(         204) =  -0.3966304009948762D-30
  vduuuu_ref(         205) =  -0.7091116265799486D-30
  vduuuu_ref(         206) =  -0.5859137675793935D-16
  vduuuu_ref(         207) =   0.3966304009948762D-30
  vduuuu_ref(         209) =  -0.1808140747721710D-14
  vduuuu_ref(         210) =   0.3145457894030469D-29
  vduuuu_ref(         211) =  -0.7539331555316313D-29
  vduuuu_ref(         212) =   0.9086091128667022D-29
  vduuuu_ref(         213) =  -0.8424360754780602D-17
  vduuuu_ref(         214) =   0.2175587557438152D-29
  vduuuu_ref(         215) =  -0.3535258860112023D-29
  vduuuu_ref(         216) =   0.3297815690809204D-29
  vduuuu_ref(         218) =  -0.3160308286719044D-15
  vduuuu_ref(         219) =   0.5118853458430816D-15
  vduuuu_ref(         220) =  -0.4761059517569265D-15
  vduuuu_ref(         221) =   0.1569536370257901D-15
  vduuuu_ref(         222) =  -0.8921951442998417D-30
  vduuuu_ref(         223) =   0.1657312154306848D-29
  vduuuu_ref(         224) =  -0.1721479080562077D-29
  vduuuu_ref(         225) =  -0.1509219600467013D-29
  vduuuu_ref(         226) =   0.5136240893357279D-15
  vduuuu_ref(         227) =  -0.3535258860112023D-29
  vduuuu_ref(         228) =  -0.1427429590938522D-29
  vduuuu_ref(         229) =  -0.2167964112369989D-29
  vduuuu_ref(         230) =   0.2393040821828650D-17
  vduuuu_ref(         231) =  -0.3277879331811150D-31
  vduuuu_ref(         232) =  -0.4059278384857596D-30
  vduuuu_ref(         233) =   0.3160308286719044D-15
  vduuuu_ref(         235) =   0.2384939791828339D-17
  vduuuu_ref(         236) =   0.5839303057991096D-16
  vduuuu_ref(         237) =   0.7501633077078915D-30
  vduuuu_ref(         238) =  -0.4458456510472339D-16
  vduuuu_ref(         239) =   0.3115497080147007D-30
  vduuuu_ref(         240) =   0.2383081320583436D-30
  vduuuu_ref(         242) =  -0.3500132142818629D-29
  vduuuu_ref(         243) =   0.5118853458430816D-15
  vduuuu_ref(         244) =   0.1002868903779357D-29
  vduuuu_ref(         245) =   0.3500132142818630D-29
  vduuuu_ref(         247) =   0.2384939791828339D-17
  vduuuu_ref(         248) =  -0.2991495460117554D-30
  vduuuu_ref(         249) =  -0.5118853458430816D-15
  vduuuu_ref(         250) =  -0.2384939791828339D-17
  vduuuu_ref(         252) =   0.4443363541887364D-16
  vduuuu_ref(         253) =  -0.1002868903779357D-29
  vduuuu_ref(         254) =   0.2991495460117554D-30
  vduuuu_ref(         255) =  -0.4443363541887364D-16
  vduuuu_ref(         257) =   0.1681756624985361D-14
  vduuuu_ref(         258) =  -0.4205895894410904D-29
  vduuuu_ref(         259) =   0.9086091128667021D-29
  vduuuu_ref(         260) =  -0.1037978773948843D-28
  vduuuu_ref(         261) =  -0.2062626305517706D-15
  vduuuu_ref(         262) =   0.7091116265799485D-30
  vduuuu_ref(         263) =  -0.1427429590938522D-29
  vduuuu_ref(         264) =   0.1564216669851080D-29
  vduuuu_ref(         265) =  -0.1569536370257901D-15
  vduuuu_ref(         266) =  -0.7501633077078914D-30
  vduuuu_ref(         267) =   0.1002868903779357D-29
  vduuuu_ref(         268) =  -0.7527625534114299D-30
  vduuuu_ref(         270) =  -0.3160308286723873D-15
  vduuuu_ref(         271) =   0.5118853458438638D-15
  vduuuu_ref(         272) =  -0.4761059517576540D-15
  vduuuu_ref(         273) =   0.2684026209364347D-29
  vduuuu_ref(         274) =  -0.4777231618063059D-15
  vduuuu_ref(         275) =   0.3297815690809204D-29
  vduuuu_ref(         276) =   0.1564216669851080D-29
  vduuuu_ref(         277) =  -0.5224586710148532D-30
  vduuuu_ref(         278) =   0.5859137675793935D-16
  vduuuu_ref(         279) =  -0.4059278384857596D-30
  vduuuu_ref(         280) =  -0.2275572998716016D-30
  vduuuu_ref(         281) =   0.8921951442998417D-30
  vduuuu_ref(         282) =   0.4458456510472339D-16
  vduuuu_ref(         283) =  -0.2991495460117554D-30
  vduuuu_ref(         284) =   0.6515051377783914D-31
  vduuuu_ref(         285) =   0.3160308286723873D-15
  vduuuu_ref(         287) =   0.2384939791831983D-17
  vduuuu_ref(         288) =   0.5839303058000019D-16
  vduuuu_ref(         289) =  -0.2073738352982623D-29
  vduuuu_ref(         290) =   0.3245820607111371D-29
  vduuuu_ref(         291) =  -0.4761059517569265D-15
  vduuuu_ref(         292) =  -0.7527625534114299D-30
  vduuuu_ref(         293) =   0.5673846186868054D-30
  vduuuu_ref(         294) =  -0.3966304009948762D-30
  vduuuu_ref(         295) =   0.5839303057991096D-16
  vduuuu_ref(         296) =   0.6515051377783915D-31
  vduuuu_ref(         297) =  -0.1657312154306847D-29
  vduuuu_ref(         298) =  -0.3115497080147007D-30
  vduuuu_ref(         299) =   0.4443363541887364D-16
  vduuuu_ref(         300) =   0.2309140440199877D-30
  vduuuu_ref(         301) =  -0.5118853458438638D-15
  vduuuu_ref(         302) =  -0.2384939791831983D-17
  vduuuu_ref(         304) =   0.4443363541894154D-16
  vduuuu_ref(         306) =   0.2911654495328393D-30
  vduuuu_ref(         307) =  -0.1721479080562077D-29
  vduuuu_ref(         308) =  -0.4761059517576540D-15
  vduuuu_ref(         309) =  -0.2911654495328393D-30
  vduuuu_ref(         311) =   0.2383081320583436D-30
  vduuuu_ref(         312) =   0.5839303058000018D-16
  vduuuu_ref(         313) =   0.1721479080562077D-29
  vduuuu_ref(         314) =  -0.2383081320583436D-30
  vduuuu_ref(         316) =   0.4443363541894154D-16
  vduuuu_ref(         317) =   0.4761059517576540D-15
  vduuuu_ref(         318) =  -0.5839303058000019D-16
  vduuuu_ref(         319) =  -0.4443363541894154D-16
  vduuuu_ref(         646) =  -0.8758115402030107D-46
  vduuuu_ref(         649) =  -0.1232595164407831D-31
  vduuuu_ref(         653) =   0.1170965406187439D-30
  vduuuu_ref(         658) =   0.2769749061373312D+00
  vduuuu_ref(         659) =  -0.1356854321992275D-14
  vduuuu_ref(         660) =  -0.3847223673530310D-15
  vduuuu_ref(         661) =  -0.2769749061373312D+00
  vduuuu_ref(         663) =  -0.4130389202524835D-15
  vduuuu_ref(         664) =   0.6113862861027894D-15
  vduuuu_ref(         665) =   0.1356854321992275D-14
  vduuuu_ref(         666) =   0.4130389202524835D-15
  vduuuu_ref(         667) =   0.8758115402030107D-46
  vduuuu_ref(         668) =  -0.4434269946406887D-29
  vduuuu_ref(         669) =   0.3847223673530310D-15
  vduuuu_ref(         670) =  -0.6113862861027893D-15
  vduuuu_ref(         671) =   0.4434269946406888D-29
  vduuuu_ref(         673) =  -0.8758115402030107D-46
  vduuuu_ref(         675) =  -0.2189528850507527D-46
  vduuuu_ref(         679) =  -0.1232595164407831D-31
  vduuuu_ref(         682) =   0.2465190328815662D-31
  vduuuu_ref(         683) =  -0.8758115402030107D-46
  vduuuu_ref(         687) =  -0.2189528850507527D-46
  vduuuu_ref(         690) =  -0.1356854321992275D-14
  vduuuu_ref(         691) =   0.2755937501349027D+00
  vduuuu_ref(         692) =   0.5130458512458823D-15
  vduuuu_ref(         693) =   0.1356854321992275D-14
  vduuuu_ref(         695) =  -0.8933713055319323D-16
  vduuuu_ref(         696) =  -0.4690914935192846D-29
  vduuuu_ref(         697) =  -0.2755937501349027D+00
  vduuuu_ref(         698) =   0.8933713055319326D-16
  vduuuu_ref(         700) =   0.6093165936009669D-15
  vduuuu_ref(         701) =  -0.5130458512458824D-15
  vduuuu_ref(         702) =   0.4690914935192846D-29
  vduuuu_ref(         703) =  -0.6093165936009669D-15
  vduuuu_ref(         706) =  -0.4130389202524835D-15
  vduuuu_ref(         707) =  -0.8933713055319323D-16
  vduuuu_ref(         708) =   0.1355908698642831D-29
  vduuuu_ref(         709) =   0.4130389202524835D-15
  vduuuu_ref(         710) =   0.1232595164407831D-31
  vduuuu_ref(         711) =  -0.4878219872429944D-01
  vduuuu_ref(         712) =  -0.1457368340742686D-15
  vduuuu_ref(         713) =   0.8933713055319326D-16
  vduuuu_ref(         714) =   0.4878219872429944D-01
  vduuuu_ref(         715) =  -0.2465190328815662D-31
  vduuuu_ref(         716) =  -0.1089150511729883D-15
  vduuuu_ref(         717) =  -0.1355908698642831D-29
  vduuuu_ref(         718) =   0.1457368340742686D-15
  vduuuu_ref(         719) =   0.1089150511729883D-15
  vduuuu_ref(         725) =   0.8758115402030107D-46
  vduuuu_ref(         726) =  -0.8758115402030107D-46
  vduuuu_ref(         728) =   0.4379057701015053D-46
  vduuuu_ref(         729) =   0.1232595164407831D-31
  vduuuu_ref(         730) =  -0.1232595164407831D-31
  vduuuu_ref(         734) =  -0.8758115402030107D-46
  vduuuu_ref(         737) =   0.1972152263052530D-30
  vduuuu_ref(         738) =  -0.3847223673530310D-15
  vduuuu_ref(         739) =   0.5130458512458823D-15
  vduuuu_ref(         740) =   0.2755937501355312D+00
  vduuuu_ref(         741) =   0.3847223673530310D-15
  vduuuu_ref(         743) =   0.1355908698642831D-29
  vduuuu_ref(         744) =  -0.8933713055333432D-16
  vduuuu_ref(         745) =  -0.5130458512458824D-15
  vduuuu_ref(         746) =  -0.1355908698642831D-29
  vduuuu_ref(         748) =   0.4116406822231818D-15
  vduuuu_ref(         749) =  -0.2755937501355312D+00
  vduuuu_ref(         750) =   0.8933713055333429D-16
  vduuuu_ref(         751) =  -0.4116406822231818D-15
  vduuuu_ref(         752) =   0.4930380657631324D-31
  vduuuu_ref(         754) =   0.6113862861027894D-15
  vduuuu_ref(         755) =  -0.4690914935192846D-29
  vduuuu_ref(         756) =  -0.8933713055333432D-16
  vduuuu_ref(         757) =  -0.6113862861027892D-15
  vduuuu_ref(         759) =  -0.1457368340742686D-15
  vduuuu_ref(         760) =  -0.4878219872435460D-01
  vduuuu_ref(         761) =   0.4690914935192845D-29
  vduuuu_ref(         762) =   0.1457368340742686D-15
  vduuuu_ref(         763) =  -0.8758115402030107D-46
  vduuuu_ref(         764) =   0.3841259839688394D-15
  vduuuu_ref(         765) =   0.8933713055333429D-16
  vduuuu_ref(         766) =   0.4878219872435460D-01
  vduuuu_ref(         767) =  -0.3841259839688394D-15
  vduuuu_ref(         770) =  -0.4434269946406888D-29
  vduuuu_ref(         771) =   0.6093165936009669D-15
  vduuuu_ref(         772) =   0.4116406822231818D-15
  vduuuu_ref(         773) =   0.4434269946406888D-29
  vduuuu_ref(         774) =  -0.2189528850507527D-46
  vduuuu_ref(         775) =  -0.1089150511729883D-15
  vduuuu_ref(         776) =   0.3841259839688394D-15
  vduuuu_ref(         777) =  -0.6093165936009669D-15
  vduuuu_ref(         778) =   0.1089150511729883D-15
  vduuuu_ref(         780) =  -0.4865814277487202D-01
  vduuuu_ref(         781) =  -0.4116406822231818D-15
  vduuuu_ref(         782) =  -0.3841259839688394D-15
  vduuuu_ref(         783) =   0.4865814277487202D-01
  vduuuu_ref(         786) =  -0.2189528850507527D-46
  vduuuu_ref(         797) =   0.3697785493223493D-31
  vduuuu_ref(         799) =   0.3081487911019577D-32
  vduuuu_ref(         805) =   0.7395570986446986D-31
  vduuuu_ref(         806) =   0.4379057701015053D-46
  vduuuu_ref(         807) =   0.8758115402030107D-46
  vduuuu_ref(         809) =  -0.6162975822039155D-32
  vduuuu_ref(         813) =   0.1848892746611746D-31
  vduuuu_ref(         817) =  -0.9860761315262648D-31
  vduuuu_ref(         819) =  -0.8424360754779092D-17
  vduuuu_ref(         820) =  -0.2062626305517733D-15
  vduuuu_ref(         823) =  -0.5136240893357256D-15
  vduuuu_ref(         824) =   0.4777231618063067D-15
  vduuuu_ref(         825) =   0.8424360754779092D-17
  vduuuu_ref(         826) =   0.5136240893357258D-15
  vduuuu_ref(         828) =  -0.4725245281747725D-29
  vduuuu_ref(         829) =   0.2062626305517733D-15
  vduuuu_ref(         830) =  -0.4777231618063067D-15
  vduuuu_ref(         831) =   0.4725245281747726D-29
  vduuuu_ref(         832) =  -0.4379057701015053D-46
  vduuuu_ref(         833) =  -0.4379057701015053D-46
  vduuuu_ref(         835) =  -0.8758115402030107D-46
  vduuuu_ref(         836) =  -0.2189528850507527D-46
  vduuuu_ref(         839) =   0.9629649721936179D-34
  vduuuu_ref(         840) =   0.1540743955509789D-32
  vduuuu_ref(         842) =  -0.9629649721936179D-34
  vduuuu_ref(         845) =  -0.2189528850507527D-46
  vduuuu_ref(         847) =  -0.2189528850507527D-46
  vduuuu_ref(         850) =   0.8424360754779092D-17
  vduuuu_ref(         852) =  -0.1569536370257880D-15
  vduuuu_ref(         853) =  -0.8424360754779092D-17
  vduuuu_ref(         855) =  -0.3160308286719009D-15
  vduuuu_ref(         856) =  -0.3995983914819262D-29
  vduuuu_ref(         858) =   0.3160308286719009D-15
  vduuuu_ref(         859) =  -0.2465190328815662D-31
  vduuuu_ref(         860) =   0.4761059517569275D-15
  vduuuu_ref(         861) =   0.1569536370257880D-15
  vduuuu_ref(         862) =   0.3995983914819262D-29
  vduuuu_ref(         863) =  -0.4761059517569274D-15
  vduuuu_ref(         864) =   0.4379057701015053D-46
  vduuuu_ref(         866) =   0.5136240893357256D-15
  vduuuu_ref(         867) =   0.3160308286719009D-15
  vduuuu_ref(         868) =   0.3248105256130364D-30
  vduuuu_ref(         869) =  -0.5136240893357258D-15
  vduuuu_ref(         870) =   0.9629649721936179D-34
  vduuuu_ref(         872) =   0.4458456510472379D-16
  vduuuu_ref(         873) =  -0.3160308286719009D-15
  vduuuu_ref(         875) =   0.9629649721936179D-34
  vduuuu_ref(         876) =  -0.5839303057991126D-16
  vduuuu_ref(         877) =  -0.3248105256130364D-30
  vduuuu_ref(         878) =  -0.4458456510472379D-16
  vduuuu_ref(         879) =   0.5839303057991127D-16
  vduuuu_ref(         883) =   0.2465190328815662D-31
  vduuuu_ref(         884) =  -0.1751623080406021D-45
  vduuuu_ref(         887) =   0.9629649721936179D-34
  vduuuu_ref(         888) =   0.1094764425253763D-46
  vduuuu_ref(         889) =   0.3697785493223493D-31
  vduuuu_ref(         890) =  -0.9629649721936179D-34
  vduuuu_ref(         892) =  -0.7703719777548943D-33
  vduuuu_ref(         893) =   0.8758115402030107D-46
  vduuuu_ref(         895) =  -0.3081487911019577D-32
  vduuuu_ref(         896) =   0.1094764425253763D-46
  vduuuu_ref(         898) =   0.2062626305517733D-15
  vduuuu_ref(         899) =   0.1569536370257880D-15
  vduuuu_ref(         901) =  -0.2062626305517733D-15
  vduuuu_ref(         902) =   0.2189528850507527D-46
  vduuuu_ref(         903) =  -0.3248105256130364D-30
  vduuuu_ref(         904) =  -0.3160308286723876D-15
  vduuuu_ref(         905) =  -0.1569536370257880D-15
  vduuuu_ref(         906) =   0.3248105256130364D-30
  vduuuu_ref(         907) =  -0.8758115402030107D-46
  vduuuu_ref(         908) =   0.5118853458438656D-15
  vduuuu_ref(         910) =   0.3160308286723877D-15
  vduuuu_ref(         911) =  -0.5118853458438654D-15
  vduuuu_ref(         912) =  -0.2465190328815662D-31
  vduuuu_ref(         914) =  -0.4777231618063067D-15
  vduuuu_ref(         915) =   0.3995983914819263D-29
  vduuuu_ref(         916) =   0.3160308286723876D-15
  vduuuu_ref(         917) =   0.4777231618063067D-15
  vduuuu_ref(         919) =  -0.4458456510472379D-16
  vduuuu_ref(         921) =  -0.3995983914819262D-29
  vduuuu_ref(         922) =   0.4458456510472378D-16
  vduuuu_ref(         924) =   0.2384939791831745D-17
  vduuuu_ref(         925) =  -0.3160308286723877D-15
  vduuuu_ref(         927) =  -0.2384939791831745D-17
  vduuuu_ref(         928) =   0.3081487911019577D-32
  vduuuu_ref(         930) =   0.4725245281747726D-29
  vduuuu_ref(         931) =  -0.4761059517569275D-15
  vduuuu_ref(         932) =  -0.5118853458438656D-15
  vduuuu_ref(         933) =  -0.4725245281747726D-29
  vduuuu_ref(         934) =   0.2189528850507527D-46
  vduuuu_ref(         935) =   0.5839303057991126D-16
  vduuuu_ref(         936) =  -0.2384939791831745D-17
  vduuuu_ref(         937) =   0.4761059517569274D-15
  vduuuu_ref(         938) =  -0.5839303057991127D-16
  vduuuu_ref(         939) =  -0.1540743955509789D-32
  vduuuu_ref(         941) =   0.5118853458438655D-15
  vduuuu_ref(         942) =   0.2384939791831745D-17
  vduuuu_ref(         944) =   0.3081487911019577D-32
  vduuuu_ref(         946) =  -0.4379057701015053D-46
  vduuuu_ref(         947) =   0.2189528850507527D-46
  vduuuu_ref(         948) =   0.2465190328815662D-31
  vduuuu_ref(         949) =   0.4379057701015053D-46
  vduuuu_ref(         955) =  -0.1094764425253763D-46
  vduuuu_ref(         956) =   0.3081487911019577D-32
  vduuuu_ref(         957) =   0.2465190328815662D-31
  vduuuu_ref(         958) =  -0.1540743955509789D-32
  vduuuu_ref(         959) =  -0.1540743955509789D-32

  end subroutine
end program
