if(NOT DEFINED DEFAULT_Fortran_FLAGS_SET)

# work-around for error in Macports cmake on OSX
if(${CMAKE_SYSTEM_NAME} STREQUAL "Darwin")
    if(${CMAKE_HOST_SYSTEM_PROCESSOR} MATCHES "i386")
        set(CMAKE_HOST_SYSTEM_PROCESSOR x86_64)
    endif()
endif()

if(CMAKE_Fortran_COMPILER_ID MATCHES GNU)
    set(CMAKE_Fortran_FLAGS         "-cpp")
    if(NOT DEFINED HOST_PROGRAM)
        set(CMAKE_Fortran_FLAGS_DEBUG   "-O0 -fimplicit-none -fbacktrace -fbounds-check -g -pedantic -std=f2008 -Wall -Wcharacter-truncation -Warray-temporaries -Wconversion-extra -Wextra -Wunderflow -Wrealloc-lhs -Wsurprising -Wintrinsics-std")
    else()
        set(CMAKE_Fortran_FLAGS_DEBUG   "-O0 -fbacktrace -g")
    endif()
    set(CMAKE_Fortran_FLAGS_RELEASE "-O3 -ffast-math -funroll-loops -ftree-vectorize")
    set(CMAKE_Fortran_FLAGS_PROFILE "${CMAKE_Fortran_FLAGS_RELEASE} -g -pg")
    if(${CMAKE_HOST_SYSTEM_PROCESSOR} MATCHES "x86_64")
        set(CMAKE_Fortran_FLAGS "${CMAKE_Fortran_FLAGS} -m64")
    elseif(${CMAKE_HOST_SYSTEM_PROCESSOR} MATCHES "i386")
        set(CMAKE_Fortran_FLAGS "${CMAKE_Fortran_FLAGS} -m32")
    endif()
    if(ENABLE_STATIC_LINKING)
        set(CMAKE_Fortran_FLAGS "${CMAKE_Fortran_FLAGS} -static")
    endif()
    if(ENABLE_64BIT_INTEGERS)
        set(CMAKE_Fortran_FLAGS "${CMAKE_Fortran_FLAGS} -fdefault-integer-8")
    endif()
endif()

if(CMAKE_Fortran_COMPILER_ID MATCHES Intel)
    set(CMAKE_Fortran_FLAGS         "-fpp")
    set(CMAKE_Fortran_FLAGS_DEBUG   "-O0 -g -traceback -check all -debug all -fpstkchk -ftrapuv -traceback")
    set(CMAKE_Fortran_FLAGS_RELEASE "-O3 -ip")
    set(CMAKE_Fortran_FLAGS_PROFILE "${CMAKE_Fortran_FLAGS_RELEASE} -g -pg")
    if(DEFINED MKL_FLAG)
        set(CMAKE_Fortran_FLAGS "${CMAKE_Fortran_FLAGS} ${MKL_FLAG}")
    endif()
    if(ENABLE_STATIC_LINKING)
        set(CMAKE_Fortran_FLAGS "${CMAKE_Fortran_FLAGS} -static-libgcc -static-intel")
    endif()
    if(ENABLE_64BIT_INTEGERS)
        set(CMAKE_Fortran_FLAGS "${CMAKE_Fortran_FLAGS} -i8")
    endif()
    if(${CMAKE_SYSTEM_NAME} MATCHES "Darwin")
        message("--Switch off warnings due to incompatibility XCode 4 and Intel 11 on OsX 10.6")
        set(CMAKE_Fortran_FLAGS "${CMAKE_Fortran_FLAGS} -Qoption,ld,-w")
    endif()
endif()

if(CMAKE_Fortran_COMPILER_ID MATCHES PGI)
    set(CMAKE_Fortran_FLAGS         "-mcmodel=medium -Mpreprocess")
    set(CMAKE_Fortran_FLAGS_DEBUG   "-O0 -g -Mframe")
    set(CMAKE_Fortran_FLAGS_RELEASE "-O3 -Mipa=fast")
    set(CMAKE_Fortran_FLAGS_PROFILE "${CMAKE_Fortran_FLAGS_RELEASE} -g -pg")
    if(ENABLE_64BIT_INTEGERS)
        set(CMAKE_Fortran_FLAGS "${CMAKE_Fortran_FLAGS} -i8 -i8storage")
    endif()
endif()

if(CMAKE_Fortran_COMPILER_ID MATCHES XL)
    set(CMAKE_Fortran_FLAGS         "-qzerosize -qextname -qfree=f90 -qlanglvl=extended -qinit=f90ptr -qsuffix=cpp=f90 -qsuppress=cmpmsg -qflag=w:w")
    set(CMAKE_Fortran_FLAGS_DEBUG   "-g")
    set(CMAKE_Fortran_FLAGS_RELEASE "-qstrict -O3")
    set(CMAKE_Fortran_FLAGS_PROFILE "${CMAKE_Fortran_FLAGS_RELEASE} -g -pg")
    if(ENABLE_64BIT_INTEGERS)
        set(CMAKE_Fortran_FLAGS "${CMAKE_Fortran_FLAGS} -q64")
    endif()
endif()

if(CMAKE_Fortran_COMPILER_ID MATCHES Cray)
    add_definitions(-DVAR_CRAY)
    set(CMAKE_Fortran_FLAGS         "-eZ")
    set(CMAKE_Fortran_FLAGS_DEBUG   "-O0 -g")
    set(CMAKE_Fortran_FLAGS_RELEASE " ")
    set(CMAKE_Fortran_FLAGS_PROFILE "-g")
    if(ENABLE_64BIT_INTEGERS)
        set(CMAKE_Fortran_FLAGS "${CMAKE_Fortran_FLAGS} -s integer64")
    endif()
endif()

if(DEFINED EXTRA_Fortran_FLAGS)
    set(CMAKE_Fortran_FLAGS "${CMAKE_Fortran_FLAGS} ${EXTRA_Fortran_FLAGS}")
endif()

save_compiler_flags(Fortran)

endif()
