  ! number of test cases
  integer, parameter :: NUM_TESTS = 6
  ! ID of block of sub-shells on bra center
  integer, parameter :: BRA_BLOCK(NUM_TESTS) = (/12, 12, 12, 12, 12, 12/)
  ! ID of block of sub-shells on ket center
  integer, parameter :: KET_BLOCK(NUM_TESTS) = (/6, 6, 6, 6, 6, 6/)
  ! orders of electronic derivatives
  integer, parameter :: ORDER_ELEC(NUM_TESTS) = (/0, 0, 0, 0, 0, 0/)
  ! indices of nuclear potential origin
  integer, parameter :: IDX_NUCORG(NUM_TESTS) = (/1, 2, 3, 1, 2, 3/)
  ! coordinates of nuclear potential origin
  real(REALK), parameter :: NUC_ORIGIN(3*NUM_TESTS) =  &
    (/0.0_REALK, -0.224905893_REALK, 0.0_REALK,        &
      1.45235_REALK, 0.899623_REALK, 0.0_REALK,        &
     -1.45235_REALK, 0.899623_REALK, 0.0_REALK,        &
      0.0_REALK, -0.224905893_REALK, 0.0_REALK,        &
      1.45235_REALK, 0.899623_REALK, 0.0_REALK,        &
     -1.45235_REALK, 0.899623_REALK, 0.0_REALK/)
  ! indices of dipole origin
  integer, parameter :: IDX_DIPORG(NUM_TESTS) = (/-1, -1, -1, -1, -1, -1/)
  ! coordinates of dipole origin
  real(REALK), parameter :: DIP_ORIGIN(3*NUM_TESTS) =                      &
    (/0.0_REALK, 0.0_REALK, 0.0_REALK,    0.0_REALK, 0.0_REALK, 0.0_REALK, &
      0.0_REALK, 0.0_REALK, 0.0_REALK,    0.0_REALK, 0.0_REALK, 0.0_REALK, &
      0.0_REALK, 0.0_REALK, 0.0_REALK,    0.0_REALK, 0.0_REALK, 0.0_REALK/)
  ! scale constants
  real(REALK), parameter :: SCAL_CONST(NUM_TESTS) = &
    (/-1.0_REALK, -1.0_REALK, -1.0_REALK, 1.0_REALK, 1.0_REALK, 1.0_REALK/)
  ! orders of Cartesian multipole moments
  integer, parameter :: ORDER_MOM(NUM_TESTS) = (/0, 0, 0, 0, 0, 0/)
  ! orders of partial geometric derivatives on bra center
  integer, parameter :: ORDER_GEO_BRA(NUM_TESTS) = (/0, 0, 0, 0, 0, 0/)
  ! orders of partial geometric derivatives on ket center
  integer, parameter :: ORDER_GEO_KET(NUM_TESTS) = (/0, 0, 0, 0, 0, 0/)
  ! orders of geometric derivatives on nuclear potential origin
  integer, parameter :: ORDER_GEO_POT(NUM_TESTS) = (/0, 0, 0, 1, 1, 1/)
  ! orders of geometric derivatives on dipole origin
  integer, parameter :: ORDER_GEO_MOM(NUM_TESTS) = (/0, 0, 0, 0, 0, 0/)
  ! numbers of differentiated centers of total geometric derivatives
  integer, parameter :: NUM_CENTS(NUM_TESTS) = (/0, 0, 0, 0, 0, 0/)
  ! indices of differentiated centers
  integer, parameter :: IDX_CENT(3*NUM_TESTS) = &
    (/0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0/)
  ! orders of geometric derivatives of differentiated centers
  integer, parameter :: ORDER_CENT(3*NUM_TESTS) = &
    (/0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0/)
  ! referenced results from Dalton
  real(REALK) REF_CONTR_INTS(4752)
  ! results of test 1, ket-major order, POT.E O1
  data REF_CONTR_INTS(1:396)                                                               &
     /0.130728003061335_REALK,      0.000000000000000_REALK,      0.006360521798264_REALK, &
      0.000000000000000_REALK,     -0.001931911860703_REALK,      0.000000000000000_REALK, &
     -0.029879483223009_REALK,      0.000000000000000_REALK,      0.049418768980465_REALK, &
      0.034508737163461_REALK,      0.000000000000000_REALK,     -0.005248534884903_REALK, &
      0.000000000000000_REALK,     -0.001588089441362_REALK,      0.000000000000000_REALK, &
      0.025139532558999_REALK,      0.000000000000000_REALK,      0.008270831826089_REALK, &
      0.000000000000000_REALK,      0.002111021202980_REALK,      0.000000000000000_REALK, &
     -0.037932837240375_REALK,      0.000000000000000_REALK,      0.003968305122225_REALK, &
      0.000000000000000_REALK,     -0.103920359283052_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.004927669983783_REALK,      0.000000000000000_REALK, &
      0.003295381032719_REALK,      0.000000000000000_REALK,      0.018799674404354_REALK, &
      0.000000000000000_REALK,     -0.064250124059540_REALK,      0.000000000000000_REALK, &
     -0.003756476388900_REALK,      0.000000000000000_REALK,     -0.063590867471040_REALK, &
      0.000000000000000_REALK,      0.042076611926831_REALK,      0.000000000000000_REALK, &
      0.007911201311258_REALK,      0.000000000000000_REALK,     -0.030039742457352_REALK, &
      0.006631285991072_REALK,      0.000000000000000_REALK,     -0.043765145947721_REALK, &
      0.000000000000000_REALK,      0.006794140105967_REALK,      0.000000000000000_REALK, &
      0.017161084888994_REALK,      0.000000000000000_REALK,      0.000507921780210_REALK, &
      0.000000000000000_REALK,     -0.056787401853258_REALK,      0.000000000000000_REALK, &
      0.046160078303563_REALK,      0.000000000000000_REALK,      0.071536016655574_REALK, &
      0.000000000000000_REALK,      0.008169087550408_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.005195631371531_REALK,      0.000000000000000_REALK, &
      0.011019203573743_REALK,      0.000000000000000_REALK,      0.028610044336135_REALK, &
      0.000000000000000_REALK,     -0.009485750363944_REALK,      0.000000000000000_REALK, &
     -0.005662807431860_REALK,      0.000000000000000_REALK,      0.041642899701515_REALK, &
      0.000000000000000_REALK,     -0.047283416520729_REALK,      0.000000000000000_REALK, &
      0.031613829494671_REALK,      0.000000000000000_REALK,     -0.008173818982382_REALK, &
      0.009948366163256_REALK,      0.000000000000000_REALK,      0.010431856214080_REALK, &
      0.000000000000000_REALK,     -0.029917530135045_REALK,      0.000000000000000_REALK, &
      0.030567766880639_REALK,      0.000000000000000_REALK,     -0.002490322686861_REALK, &
      0.000000000000000_REALK,      0.028371992543662_REALK,      0.000000000000000_REALK, &
     -0.045200345963544_REALK,      0.000000000000000_REALK,     -0.058377088280072_REALK, &
      0.000000000000000_REALK,     -0.012189542772522_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.023847214005633_REALK,      0.000000000000000_REALK, &
     -0.024129335240041_REALK,      0.000000000000000_REALK,     -0.031163485664101_REALK, &
      0.000000000000000_REALK,      0.010245548834111_REALK,      0.000000000000000_REALK, &
      0.008794904294270_REALK,      0.000000000000000_REALK,      0.064220553457880_REALK, &
      0.000000000000000_REALK,     -0.061067412683972_REALK,      0.000000000000000_REALK, &
      0.000469291317098_REALK,      0.000000000000000_REALK,     -0.001627515158544_REALK, &
     -0.000691030286226_REALK,      0.000000000000000_REALK,      0.027429096684140_REALK, &
      0.000000000000000_REALK,     -0.038639047126407_REALK,      0.000000000000000_REALK, &
     -0.014485507203629_REALK,      0.000000000000000_REALK,     -0.010721401460092_REALK, &
      0.000000000000000_REALK,      0.009595044286253_REALK,      0.000000000000000_REALK, &
      0.035740436820235_REALK,      0.000000000000000_REALK,      0.000070579438955_REALK, &
      0.000000000000000_REALK,      0.058629051523797_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.012196420477719_REALK,      0.000000000000000_REALK, &
      0.031563136926741_REALK,      0.000000000000000_REALK,     -0.014833177630493_REALK, &
      0.000000000000000_REALK,      0.022807295914651_REALK,      0.000000000000000_REALK, &
     -0.041429146902772_REALK,      0.000000000000000_REALK,      0.011041514555722_REALK, &
      0.000000000000000_REALK,     -0.018077498787425_REALK,      0.000000000000000_REALK, &
      0.059548009640622_REALK,      0.000000000000000_REALK,     -0.010953151482179_REALK, &
      0.011731147375406_REALK,      0.000000000000000_REALK,     -0.000231644706849_REALK, &
      0.000000000000000_REALK,     -0.002918986436950_REALK,      0.000000000000000_REALK, &
      0.066228180010931_REALK,      0.000000000000000_REALK,      0.007863718801288_REALK, &
      0.000000000000000_REALK,     -0.091920193185325_REALK,      0.000000000000000_REALK, &
      0.007973267332583_REALK,      0.000000000000000_REALK,      0.039653500957961_REALK, &
      0.000000000000000_REALK,     -0.017609459118203_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.062034805822637_REALK,      0.000000000000000_REALK, &
     -0.022548264411170_REALK,      0.000000000000000_REALK,     -0.021059817843838_REALK, &
      0.000000000000000_REALK,     -0.007788794728016_REALK,      0.000000000000000_REALK, &
      0.044871554296868_REALK,      0.000000000000000_REALK,     -0.009500104651702_REALK, &
      0.000000000000000_REALK,     -0.012551945529881_REALK,      0.000000000000000_REALK, &
      0.002395130678031_REALK,      0.000000000000000_REALK,     -0.124855190644658_REALK, &
      0.025309809908498_REALK,      0.000000000000000_REALK,      0.008619198245547_REALK, &
      0.000000000000000_REALK,     -0.010318075358419_REALK,      0.000000000000000_REALK, &
     -0.001849145033780_REALK,      0.000000000000000_REALK,     -0.056514894561487_REALK, &
      0.084930817314801_REALK,      0.000000000000000_REALK,     -0.005996460879929_REALK, &
      0.000000000000000_REALK,     -0.003907427054177_REALK,      0.000000000000000_REALK, &
      0.032321121396997_REALK,      0.000000000000000_REALK,      0.023392442551371_REALK, &
      0.062768271017953_REALK,      0.000000000000000_REALK,     -0.018169288795023_REALK, &
      0.000000000000000_REALK,      0.001721659726379_REALK,      0.000000000000000_REALK, &
      0.077255773784734_REALK,      0.000000000000000_REALK,      0.024685639859609_REALK, &
      0.000000000000000_REALK,      0.003808110852074_REALK,      0.000000000000000_REALK, &
     -0.008364803068824_REALK,      0.000000000000000_REALK,      0.033770744386378_REALK, &
      0.000000000000000_REALK,     -0.134516867186984_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.046612930469104_REALK,      0.000000000000000_REALK, &
      0.058311809055582_REALK,      0.000000000000000_REALK,      0.020889369001213_REALK, &
      0.000000000000000_REALK,     -0.082482798961410_REALK,      0.000000000000000_REALK, &
      0.008337150062575_REALK,      0.000000000000000_REALK,     -0.083917155619431_REALK, &
      0.000000000000000_REALK,      0.025144004812638_REALK,      0.000000000000000_REALK, &
      0.028343255156091_REALK,      0.000000000000000_REALK,     -0.004245756661865_REALK, &
      0.018191131168796_REALK,      0.000000000000000_REALK,     -0.096002125412754_REALK, &
      0.000000000000000_REALK,     -0.044424937374862_REALK,      0.000000000000000_REALK, &
      0.050604351150050_REALK,      0.000000000000000_REALK,      0.010531035065789_REALK, &
      0.000000000000000_REALK,     -0.006073332859593_REALK,      0.000000000000000_REALK, &
      0.027963647792804_REALK,      0.000000000000000_REALK,      0.061300278335417_REALK, &
      0.000000000000000_REALK,     -0.014865951377435_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.034247525134216_REALK,      0.000000000000000_REALK, &
      0.018872827277635_REALK,      0.000000000000000_REALK,      0.067355633514236_REALK, &
      0.000000000000000_REALK,     -0.011946633338819_REALK,      0.000000000000000_REALK, &
      0.016232710365305_REALK,      0.000000000000000_REALK,      0.030194462417081_REALK, &
      0.000000000000000_REALK,     -0.060572073522957_REALK,      0.000000000000000_REALK, &
      0.056082742731531_REALK,      0.000000000000000_REALK,     -0.009525337128874_REALK, &
      0.018777892840500_REALK,      0.000000000000000_REALK,     -0.024307908395100_REALK, &
      0.000000000000000_REALK,     -0.049496315587940_REALK,      0.000000000000000_REALK, &
      0.068181012541423_REALK,      0.000000000000000_REALK,      0.013932113560009_REALK, &
      0.000000000000000_REALK,     -0.030484729846979_REALK,      0.000000000000000_REALK, &
     -0.048153983435719_REALK,      0.000000000000000_REALK,     -0.062191766061511_REALK, &
      0.000000000000000_REALK,      0.013097244326660_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.073759228830201_REALK,      0.000000000000000_REALK, &
     -0.058572700731547_REALK,      0.000000000000000_REALK,     -0.075647733408183_REALK, &
      0.000000000000000_REALK,      0.031689394860453_REALK,      0.000000000000000_REALK, &
      0.003656791182549_REALK,      0.000000000000000_REALK,      0.063170402532481_REALK, &
      0.000000000000000_REALK,     -0.078229960589431_REALK,      0.000000000000000_REALK, &
     -0.021040617837377_REALK,      0.000000000000000_REALK,     -0.021896187001204_REALK, &
     -0.017625653438508_REALK,      0.000000000000000_REALK,      0.005896297020617_REALK, &
      0.000000000000000_REALK,     -0.063925413025510_REALK,      0.000000000000000_REALK, &
     -0.056133961217798_REALK,      0.000000000000000_REALK,     -0.005219636400043_REALK, &
      0.000000000000000_REALK,      0.024575791615549_REALK,      0.000000000000000_REALK, &
      0.057524769333277_REALK,      0.000000000000000_REALK,     -0.023087507630117_REALK, &
      0.000000000000000_REALK,      0.057013078198676_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.004716701459347_REALK,      0.000000000000000_REALK, &
      0.090712262853280_REALK,      0.000000000000000_REALK,     -0.049038348885589_REALK, &
      0.000000000000000_REALK,     -0.012726518030919_REALK,      0.000000000000000_REALK, &
      0.009038540612539_REALK,      0.000000000000000_REALK,      0.002604987201711_REALK, &
      0.000000000000000_REALK,     -0.010802692890338_REALK,      0.000000000000000_REALK, &
      0.117158607836652_REALK,      0.000000000000000_REALK,      0.008819767173238_REALK, &
      0.042864281640212_REALK,      0.000000000000000_REALK,     -0.009170228463467_REALK, &
      0.000000000000000_REALK,      0.019086416770486_REALK,      0.000000000000000_REALK, &
      0.173202107771670_REALK,      0.000000000000000_REALK,      0.023567858711035_REALK, &
      0.000000000000000_REALK,     -0.120528682229584_REALK,      0.000000000000000_REALK, &
     -0.035796023766357_REALK,      0.000000000000000_REALK,     -0.021523372555037_REALK, &
      0.000000000000000_REALK,     -0.021874112134338_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.137513359141989_REALK,      0.000000000000000_REALK, &
     -0.043068599703525_REALK,      0.000000000000000_REALK,     -0.085790259642732_REALK, &
      0.000000000000000_REALK,      0.024460062475563_REALK,      0.000000000000000_REALK, &
      0.053726610573337_REALK,      0.000000000000000_REALK,      0.015650214948288_REALK, &
      0.000000000000000_REALK,     -0.025387189003627_REALK,      0.000000000000000_REALK, &
     -0.001165909788981_REALK,      0.000000000000000_REALK,     -0.124107960028467_REALK, &
      0.018844412862346_REALK,      0.000000000000000_REALK,      0.014083098940254_REALK, &
      0.000000000000000_REALK,      0.011185903221608_REALK,      0.000000000000000_REALK, &
     -0.008971773676580_REALK,      0.000000000000000_REALK,     -0.055224217608314_REALK/
  ! results of test 2, ket-major order, POT.E H1
  data REF_CONTR_INTS(397:792)                                                             &
     /0.142623764893998_REALK,      0.000000000000000_REALK,      0.006925742098710_REALK, &
      0.000000000000000_REALK,     -0.001704540362529_REALK,      0.000000000000000_REALK, &
     -0.034306777239075_REALK,      0.000000000000000_REALK,      0.054160878541577_REALK, &
      0.049027765217658_REALK,      0.000000000000000_REALK,     -0.002705890275552_REALK, &
      0.000000000000000_REALK,     -0.001985331475642_REALK,      0.000000000000000_REALK, &
      0.014607823309974_REALK,      0.000000000000000_REALK,      0.014299396317021_REALK, &
      0.000000000000000_REALK,      0.003090085145773_REALK,      0.000000000000000_REALK, &
     -0.041072919925380_REALK,      0.000000000000000_REALK,      0.002714308326558_REALK, &
      0.000000000000000_REALK,     -0.109250300073676_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.002333215125300_REALK,      0.000000000000000_REALK, &
     -0.005750002317596_REALK,      0.000000000000000_REALK,      0.016787018108697_REALK, &
      0.000000000000000_REALK,     -0.071723524858459_REALK,      0.000000000000000_REALK, &
     -0.003634578038524_REALK,      0.000000000000000_REALK,     -0.068614656078839_REALK, &
      0.000000000000000_REALK,      0.045786065130127_REALK,      0.000000000000000_REALK, &
      0.007750489819192_REALK,      0.000000000000000_REALK,     -0.034697005172189_REALK, &
      0.004008757825993_REALK,      0.000000000000000_REALK,     -0.045041651845893_REALK, &
      0.000000000000000_REALK,      0.014276403469012_REALK,      0.000000000000000_REALK, &
      0.014586251255014_REALK,      0.000000000000000_REALK,     -0.003718842136535_REALK, &
      0.000000000000000_REALK,     -0.062756836163732_REALK,      0.000000000000000_REALK, &
      0.050459184958696_REALK,      0.000000000000000_REALK,      0.077541730493072_REALK, &
      0.000000000000000_REALK,      0.009919901727809_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.005863022639875_REALK,      0.000000000000000_REALK, &
      0.016311403541118_REALK,      0.000000000000000_REALK,      0.034267562043786_REALK, &
      0.000000000000000_REALK,     -0.006853070125956_REALK,      0.000000000000000_REALK, &
     -0.007556191804126_REALK,      0.000000000000000_REALK,      0.045102019360586_REALK, &
      0.000000000000000_REALK,     -0.050382895754488_REALK,      0.000000000000000_REALK, &
      0.033311623178047_REALK,      0.000000000000000_REALK,     -0.007426004555053_REALK, &
      0.007688608047201_REALK,      0.000000000000000_REALK,      0.016835655071996_REALK, &
      0.000000000000000_REALK,     -0.032426623558694_REALK,      0.000000000000000_REALK, &
      0.029524836136659_REALK,      0.000000000000000_REALK,     -0.004940887080547_REALK, &
      0.000000000000000_REALK,      0.032488116616510_REALK,      0.000000000000000_REALK, &
     -0.048718444536460_REALK,      0.000000000000000_REALK,     -0.062920778081358_REALK, &
      0.000000000000000_REALK,     -0.013957965288697_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.013776856944123_REALK,      0.000000000000000_REALK, &
     -0.026353168293320_REALK,      0.000000000000000_REALK,     -0.034035607452198_REALK, &
      0.000000000000000_REALK,      0.005918991651110_REALK,      0.000000000000000_REALK, &
      0.008686539975309_REALK,      0.000000000000000_REALK,      0.069090283434472_REALK, &
      0.000000000000000_REALK,     -0.065070447815546_REALK,      0.000000000000000_REALK, &
      0.001106786430783_REALK,      0.000000000000000_REALK,      0.000633711811762_REALK, &
      0.002108011235580_REALK,      0.000000000000000_REALK,      0.034348133279061_REALK, &
      0.000000000000000_REALK,     -0.041879587993361_REALK,      0.000000000000000_REALK, &
     -0.010606277020109_REALK,      0.000000000000000_REALK,     -0.010717047004789_REALK, &
      0.000000000000000_REALK,      0.009268924230340_REALK,      0.000000000000000_REALK, &
      0.037757561032057_REALK,      0.000000000000000_REALK,      0.000922810538601_REALK, &
      0.000000000000000_REALK,      0.061916086606887_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.012506122955540_REALK,      0.000000000000000_REALK, &
      0.030580460782267_REALK,      0.000000000000000_REALK,     -0.011549443621279_REALK, &
      0.000000000000000_REALK,      0.030865780903295_REALK,      0.000000000000000_REALK, &
     -0.046669321639481_REALK,      0.000000000000000_REALK,      0.012438950616853_REALK, &
      0.000000000000000_REALK,     -0.019671202099403_REALK,      0.000000000000000_REALK, &
      0.062559421676353_REALK,      0.000000000000000_REALK,     -0.011827891560531_REALK, &
      0.002384980278835_REALK,      0.000000000000000_REALK,      0.001817056296557_REALK, &
      0.000000000000000_REALK,     -0.006133613296828_REALK,      0.000000000000000_REALK, &
      0.061533304851305_REALK,      0.000000000000000_REALK,      0.003874442454716_REALK, &
      0.000000000000000_REALK,     -0.097885606061520_REALK,      0.000000000000000_REALK, &
      0.010439896359587_REALK,      0.000000000000000_REALK,      0.044392087080333_REALK, &
      0.000000000000000_REALK,     -0.017767799032271_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.064700040562441_REALK,      0.000000000000000_REALK, &
     -0.017269011217724_REALK,      0.000000000000000_REALK,     -0.008881589929505_REALK, &
      0.000000000000000_REALK,     -0.011404175845668_REALK,      0.000000000000000_REALK, &
      0.048263221802041_REALK,      0.000000000000000_REALK,     -0.013201381041301_REALK, &
      0.000000000000000_REALK,     -0.011074675930693_REALK,      0.000000000000000_REALK, &
      0.002141831470113_REALK,      0.000000000000000_REALK,     -0.135006831421692_REALK, &
      0.028770528752954_REALK,      0.000000000000000_REALK,      0.007099185213060_REALK, &
      0.000000000000000_REALK,     -0.012899021455335_REALK,      0.000000000000000_REALK, &
     -0.000520068038968_REALK,      0.000000000000000_REALK,     -0.067717502159194_REALK, &
      0.094697453783447_REALK,      0.000000000000000_REALK,     -0.010776320308144_REALK, &
      0.000000000000000_REALK,     -0.004657962081182_REALK,      0.000000000000000_REALK, &
      0.054251334428165_REALK,      0.000000000000000_REALK,      0.023642723394768_REALK, &
      0.075205866567097_REALK,      0.000000000000000_REALK,     -0.020731922928047_REALK, &
      0.000000000000000_REALK,      0.001273752381340_REALK,      0.000000000000000_REALK, &
      0.088882341281885_REALK,      0.000000000000000_REALK,      0.027663819900151_REALK, &
      0.000000000000000_REALK,      0.007774860916952_REALK,      0.000000000000000_REALK, &
     -0.000886952662431_REALK,      0.000000000000000_REALK,      0.046648264162466_REALK, &
      0.000000000000000_REALK,     -0.167889422886752_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.049816947940491_REALK,      0.000000000000000_REALK, &
      0.061656048241484_REALK,      0.000000000000000_REALK,      0.028202723953849_REALK, &
      0.000000000000000_REALK,     -0.106213844212973_REALK,      0.000000000000000_REALK, &
      0.014043330510266_REALK,      0.000000000000000_REALK,     -0.108609065094739_REALK, &
      0.000000000000000_REALK,      0.024852092112325_REALK,      0.000000000000000_REALK, &
      0.039948646910383_REALK,      0.000000000000000_REALK,     -0.001029200070256_REALK, &
      0.021329612465818_REALK,      0.000000000000000_REALK,     -0.113608881936177_REALK, &
      0.000000000000000_REALK,     -0.043570695203350_REALK,      0.000000000000000_REALK, &
      0.058109077752720_REALK,      0.000000000000000_REALK,      0.011087442366593_REALK, &
      0.000000000000000_REALK,      0.004583566564502_REALK,      0.000000000000000_REALK, &
      0.030599417051110_REALK,      0.000000000000000_REALK,      0.073765481564163_REALK, &
      0.000000000000000_REALK,     -0.022530661271796_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.037870927663042_REALK,      0.000000000000000_REALK, &
      0.022811151173207_REALK,      0.000000000000000_REALK,      0.078540117651794_REALK, &
      0.000000000000000_REALK,     -0.015786969219083_REALK,      0.000000000000000_REALK, &
      0.023773739230310_REALK,      0.000000000000000_REALK,      0.032600098907998_REALK, &
      0.000000000000000_REALK,     -0.076604127563135_REALK,      0.000000000000000_REALK, &
      0.074665766458171_REALK,      0.000000000000000_REALK,     -0.009615581796228_REALK, &
      0.022837662089251_REALK,      0.000000000000000_REALK,     -0.021698068620971_REALK, &
      0.000000000000000_REALK,     -0.060934017197646_REALK,      0.000000000000000_REALK, &
      0.080715098408609_REALK,      0.000000000000000_REALK,      0.013777081171802_REALK, &
      0.000000000000000_REALK,     -0.051334468474420_REALK,      0.000000000000000_REALK, &
     -0.060483178756496_REALK,      0.000000000000000_REALK,     -0.078115151343645_REALK, &
      0.000000000000000_REALK,      0.022054978980085_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.084819611207358_REALK,      0.000000000000000_REALK, &
     -0.068303653659383_REALK,      0.000000000000000_REALK,     -0.088215440269887_REALK, &
      0.000000000000000_REALK,      0.036441299537550_REALK,      0.000000000000000_REALK, &
      0.001558491126148_REALK,      0.000000000000000_REALK,      0.075271437249513_REALK, &
      0.000000000000000_REALK,     -0.098935656841606_REALK,      0.000000000000000_REALK, &
     -0.031817863805564_REALK,      0.000000000000000_REALK,     -0.028574489111411_REALK, &
     -0.018662045347311_REALK,      0.000000000000000_REALK,      0.015205546057189_REALK, &
      0.000000000000000_REALK,     -0.078697417583383_REALK,      0.000000000000000_REALK, &
     -0.062908737793548_REALK,      0.000000000000000_REALK,     -0.008900744560478_REALK, &
      0.000000000000000_REALK,      0.031949362159861_REALK,      0.000000000000000_REALK, &
      0.076301001596136_REALK,      0.000000000000000_REALK,     -0.033874088374683_REALK, &
      0.000000000000000_REALK,      0.065778397919914_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.009070504166165_REALK,      0.000000000000000_REALK, &
      0.103908380360532_REALK,      0.000000000000000_REALK,     -0.055574734727512_REALK, &
      0.000000000000000_REALK,     -0.005767038029087_REALK,      0.000000000000000_REALK, &
      0.022382684340941_REALK,      0.000000000000000_REALK,      0.001188865688002_REALK, &
      0.000000000000000_REALK,     -0.010677277576597_REALK,      0.000000000000000_REALK, &
      0.158668044111408_REALK,      0.000000000000000_REALK,      0.016193554052026_REALK, &
      0.048785906611682_REALK,      0.000000000000000_REALK,     -0.009664974863564_REALK, &
      0.000000000000000_REALK,      0.018719406188776_REALK,      0.000000000000000_REALK, &
      0.201140332599633_REALK,      0.000000000000000_REALK,      0.027358655916766_REALK, &
      0.000000000000000_REALK,     -0.154772147435333_REALK,      0.000000000000000_REALK, &
     -0.052962095186108_REALK,      0.000000000000000_REALK,     -0.041908939589307_REALK, &
      0.000000000000000_REALK,     -0.024716066359033_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.162414311997570_REALK,      0.000000000000000_REALK, &
     -0.052519990323214_REALK,      0.000000000000000_REALK,     -0.096337185876778_REALK, &
      0.000000000000000_REALK,      0.022767002454245_REALK,      0.000000000000000_REALK, &
      0.066785510245235_REALK,      0.000000000000000_REALK,      0.021944811072432_REALK, &
      0.000000000000000_REALK,     -0.030263537127400_REALK,      0.000000000000000_REALK, &
     -0.003103626532747_REALK,      0.000000000000000_REALK,     -0.150417166164619_REALK, &
      0.027974390586311_REALK,      0.000000000000000_REALK,      0.017246763310960_REALK, &
      0.000000000000000_REALK,      0.008275776361415_REALK,      0.000000000000000_REALK, &
     -0.010045081555058_REALK,      0.000000000000000_REALK,     -0.075606974389984_REALK/
  ! results of test 3, ket-major order, POT.E H2
  data REF_CONTR_INTS(793:1188)                                                            &
     /0.057818583246522_REALK,      0.000000000000000_REALK,      0.000909587656008_REALK, &
      0.000000000000000_REALK,     -0.000596614566423_REALK,      0.000000000000000_REALK, &
     -0.011347216949944_REALK,      0.000000000000000_REALK,      0.018718999853539_REALK, &
      0.018749794922194_REALK,      0.000000000000000_REALK,     -0.002788516413237_REALK, &
      0.000000000000000_REALK,     -0.002936261035286_REALK,      0.000000000000000_REALK, &
      0.013334690975940_REALK,      0.000000000000000_REALK,     -0.004071004626732_REALK, &
      0.000000000000000_REALK,     -0.002068029593307_REALK,      0.000000000000000_REALK, &
     -0.014579641582226_REALK,      0.000000000000000_REALK,      0.007468779976285_REALK, &
      0.000000000000000_REALK,     -0.049211522326330_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.000737123558735_REALK,      0.000000000000000_REALK, &
      0.001321972889925_REALK,      0.000000000000000_REALK,      0.007291022632698_REALK, &
      0.000000000000000_REALK,     -0.028153258949693_REALK,      0.000000000000000_REALK, &
     -0.000876621123953_REALK,      0.000000000000000_REALK,     -0.027432791441437_REALK, &
      0.000000000000000_REALK,      0.016630769399182_REALK,      0.000000000000000_REALK, &
      0.005094414155029_REALK,      0.000000000000000_REALK,     -0.013326918310458_REALK, &
      0.006426960301215_REALK,      0.000000000000000_REALK,     -0.019379324683104_REALK, &
      0.000000000000000_REALK,     -0.002233926920602_REALK,      0.000000000000000_REALK, &
      0.015356363013939_REALK,      0.000000000000000_REALK,     -0.001560553360435_REALK, &
      0.000000000000000_REALK,     -0.025462726711129_REALK,      0.000000000000000_REALK, &
      0.019910886273090_REALK,      0.000000000000000_REALK,      0.033633043382951_REALK, &
      0.000000000000000_REALK,      0.000047188664926_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.003626548053027_REALK,      0.000000000000000_REALK, &
      0.005362742936303_REALK,      0.000000000000000_REALK,      0.012388945971348_REALK, &
      0.000000000000000_REALK,     -0.004396063447954_REALK,      0.000000000000000_REALK, &
     -0.002051544837718_REALK,      0.000000000000000_REALK,      0.018906037055434_REALK, &
      0.000000000000000_REALK,     -0.023591280232040_REALK,      0.000000000000000_REALK, &
      0.017777252758153_REALK,      0.000000000000000_REALK,     -0.006268312676873_REALK, &
      0.006634451594658_REALK,      0.000000000000000_REALK,      0.003929344462866_REALK, &
      0.000000000000000_REALK,     -0.018821412586507_REALK,      0.000000000000000_REALK, &
      0.020617222127919_REALK,      0.000000000000000_REALK,     -0.003219794834002_REALK, &
      0.000000000000000_REALK,      0.012651655532078_REALK,      0.000000000000000_REALK, &
     -0.019057027688496_REALK,      0.000000000000000_REALK,     -0.027936883224947_REALK, &
      0.000000000000000_REALK,     -0.001463384456919_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.011539962119274_REALK,      0.000000000000000_REALK, &
     -0.009422449669699_REALK,      0.000000000000000_REALK,     -0.018717973126401_REALK, &
      0.000000000000000_REALK,      0.009073327835161_REALK,      0.000000000000000_REALK, &
      0.003034746120215_REALK,      0.000000000000000_REALK,      0.027758868025709_REALK, &
      0.000000000000000_REALK,     -0.027134786230035_REALK,      0.000000000000000_REALK, &
      0.002285660726057_REALK,      0.000000000000000_REALK,     -0.002274221771976_REALK, &
     -0.000332959344771_REALK,      0.000000000000000_REALK,      0.010791844723884_REALK, &
      0.000000000000000_REALK,     -0.015360069379270_REALK,      0.000000000000000_REALK, &
     -0.005174158590006_REALK,      0.000000000000000_REALK,     -0.003290853674521_REALK, &
      0.000000000000000_REALK,      0.004953054187145_REALK,      0.000000000000000_REALK, &
      0.014137960117906_REALK,      0.000000000000000_REALK,     -0.004128997517837_REALK, &
      0.000000000000000_REALK,      0.027346618202052_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.001792404857956_REALK,      0.000000000000000_REALK, &
      0.012493988778823_REALK,      0.000000000000000_REALK,     -0.014245163010637_REALK, &
      0.000000000000000_REALK,      0.014241256646240_REALK,      0.000000000000000_REALK, &
     -0.016798445648407_REALK,      0.000000000000000_REALK,      0.007069705560191_REALK, &
      0.000000000000000_REALK,     -0.011553530767619_REALK,      0.000000000000000_REALK, &
      0.029171573346896_REALK,      0.000000000000000_REALK,     -0.007062494775051_REALK, &
      0.006124739747383_REALK,      0.000000000000000_REALK,      0.003050362897453_REALK, &
      0.000000000000000_REALK,     -0.003302601010911_REALK,      0.000000000000000_REALK, &
      0.028512971062388_REALK,      0.000000000000000_REALK,      0.003696397806977_REALK, &
      0.000000000000000_REALK,     -0.042003017174050_REALK,      0.000000000000000_REALK, &
      0.004432057054519_REALK,      0.000000000000000_REALK,      0.016920153483261_REALK, &
      0.000000000000000_REALK,     -0.006231971365626_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.026970870371071_REALK,      0.000000000000000_REALK, &
     -0.008343322739723_REALK,      0.000000000000000_REALK,     -0.015734135874845_REALK, &
      0.000000000000000_REALK,      0.006523985660148_REALK,      0.000000000000000_REALK, &
      0.015983474968389_REALK,      0.000000000000000_REALK,     -0.002844198458590_REALK, &
      0.000000000000000_REALK,     -0.007789631994921_REALK,      0.000000000000000_REALK, &
      0.005212525879056_REALK,      0.000000000000000_REALK,     -0.058934496567211_REALK, &
      0.007810776099131_REALK,      0.000000000000000_REALK,      0.003871672689961_REALK, &
      0.000000000000000_REALK,     -0.002236853215113_REALK,      0.000000000000000_REALK, &
     -0.003217598156201_REALK,      0.000000000000000_REALK,     -0.021346043675997_REALK, &
      0.039708571522845_REALK,      0.000000000000000_REALK,     -0.006397710746743_REALK, &
      0.000000000000000_REALK,     -0.004771548730176_REALK,      0.000000000000000_REALK, &
      0.023909869661086_REALK,      0.000000000000000_REALK,      0.009836355016604_REALK, &
      0.051329280729726_REALK,      0.000000000000000_REALK,     -0.015751686487765_REALK, &
      0.000000000000000_REALK,     -0.004579756501630_REALK,      0.000000000000000_REALK, &
      0.045448723829356_REALK,      0.000000000000000_REALK,      0.006795940502447_REALK, &
      0.000000000000000_REALK,      0.008639388006789_REALK,      0.000000000000000_REALK, &
     -0.000495323121275_REALK,      0.000000000000000_REALK,      0.025962667922154_REALK, &
      0.000000000000000_REALK,     -0.072985985023820_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.027837315555150_REALK,      0.000000000000000_REALK, &
      0.030942033761111_REALK,      0.000000000000000_REALK,      0.004010482291829_REALK, &
      0.000000000000000_REALK,     -0.040218966213381_REALK,      0.000000000000000_REALK, &
      0.008971005045744_REALK,      0.000000000000000_REALK,     -0.044843302379544_REALK, &
      0.000000000000000_REALK,      0.006118652121820_REALK,      0.000000000000000_REALK, &
      0.017537661199875_REALK,      0.000000000000000_REALK,     -0.001686890527998_REALK, &
      0.021355087197244_REALK,      0.000000000000000_REALK,     -0.060026599153304_REALK, &
      0.000000000000000_REALK,     -0.042336316464214_REALK,      0.000000000000000_REALK, &
      0.047774202271386_REALK,      0.000000000000000_REALK,      0.008716588113769_REALK, &
      0.000000000000000_REALK,      0.003396402582639_REALK,      0.000000000000000_REALK, &
      0.011109430969365_REALK,      0.000000000000000_REALK,      0.034263288664603_REALK, &
      0.000000000000000_REALK,     -0.013920774792372_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.023515275772843_REALK,      0.000000000000000_REALK, &
      0.012140202923608_REALK,      0.000000000000000_REALK,      0.039123198757145_REALK, &
      0.000000000000000_REALK,     -0.004068745537321_REALK,      0.000000000000000_REALK, &
      0.013005937962716_REALK,      0.000000000000000_REALK,      0.010162002596258_REALK, &
      0.000000000000000_REALK,     -0.036348093136420_REALK,      0.000000000000000_REALK, &
      0.038335204483808_REALK,      0.000000000000000_REALK,     -0.004741385912340_REALK, &
      0.017554824535926_REALK,      0.000000000000000_REALK,     -0.027318729570287_REALK, &
      0.000000000000000_REALK,     -0.042595455490381_REALK,      0.000000000000000_REALK, &
      0.056244346546600_REALK,      0.000000000000000_REALK,      0.008916615438647_REALK, &
      0.000000000000000_REALK,     -0.021383400951839_REALK,      0.000000000000000_REALK, &
     -0.020637873497834_REALK,      0.000000000000000_REALK,     -0.036982137003249_REALK, &
      0.000000000000000_REALK,      0.013347196114072_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.048304702052354_REALK,      0.000000000000000_REALK, &
     -0.025593030873820_REALK,      0.000000000000000_REALK,     -0.057983873635780_REALK, &
      0.000000000000000_REALK,      0.022058826377457_REALK,      0.000000000000000_REALK, &
      0.001950381609155_REALK,      0.000000000000000_REALK,      0.028718419735964_REALK, &
      0.000000000000000_REALK,     -0.038975097058276_REALK,      0.000000000000000_REALK, &
     -0.005473632154488_REALK,      0.000000000000000_REALK,     -0.010221146443050_REALK, &
     -0.009045789778269_REALK,      0.000000000000000_REALK,     -0.002259392174091_REALK, &
      0.000000000000000_REALK,     -0.029000013468155_REALK,      0.000000000000000_REALK, &
     -0.025711238669633_REALK,      0.000000000000000_REALK,      0.001642180971509_REALK, &
      0.000000000000000_REALK,      0.005588415273323_REALK,      0.000000000000000_REALK, &
      0.028247128356013_REALK,      0.000000000000000_REALK,     -0.020343865318332_REALK, &
      0.000000000000000_REALK,      0.030269631707894_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.018484666125300_REALK,      0.000000000000000_REALK, &
      0.050622718876068_REALK,      0.000000000000000_REALK,     -0.048371821156217_REALK, &
      0.000000000000000_REALK,     -0.000850958367452_REALK,      0.000000000000000_REALK, &
      0.011682010793571_REALK,      0.000000000000000_REALK,     -0.000231832778193_REALK, &
      0.000000000000000_REALK,     -0.011615801262689_REALK,      0.000000000000000_REALK, &
      0.067245187450186_REALK,      0.000000000000000_REALK,      0.003294000603973_REALK, &
      0.021443015608444_REALK,      0.000000000000000_REALK,     -0.003577513869993_REALK, &
      0.000000000000000_REALK,      0.007001697010315_REALK,      0.000000000000000_REALK, &
      0.093848939075879_REALK,      0.000000000000000_REALK,      0.015904790235119_REALK, &
      0.000000000000000_REALK,     -0.061200525177679_REALK,      0.000000000000000_REALK, &
     -0.016759377948554_REALK,      0.000000000000000_REALK,     -0.019772850575697_REALK, &
      0.000000000000000_REALK,     -0.009160912778680_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.082507716796037_REALK,      0.000000000000000_REALK, &
     -0.015172243734086_REALK,      0.000000000000000_REALK,     -0.066739909464890_REALK, &
      0.000000000000000_REALK,      0.032050239326180_REALK,      0.000000000000000_REALK, &
      0.033562824459296_REALK,      0.000000000000000_REALK,      0.007032001503576_REALK, &
      0.000000000000000_REALK,     -0.013114925173471_REALK,      0.000000000000000_REALK, &
      0.004690882656025_REALK,      0.000000000000000_REALK,     -0.061133109433149_REALK, &
      0.006531877526726_REALK,      0.000000000000000_REALK,      0.010142352564207_REALK, &
      0.000000000000000_REALK,      0.013712212852856_REALK,      0.000000000000000_REALK, &
     -0.012673909201874_REALK,      0.000000000000000_REALK,     -0.013603073791324_REALK/
  ! results of test 4, ket-major order, NEF 001
  data REF_CONTR_INTS(1189:1584)                                                           &
    /-0.097858471452339_REALK,      0.000000000000000_REALK,     -0.015792926759089_REALK, &
      0.000000000000000_REALK,      0.006107235432210_REALK,      0.000000000000000_REALK, &
      0.028013536962707_REALK,      0.000000000000000_REALK,     -0.053981785012554_REALK, &
     -0.023013648274516_REALK,      0.000000000000000_REALK,      0.003658106885719_REALK, &
      0.000000000000000_REALK,     -0.008149270076565_REALK,      0.000000000000000_REALK, &
     -0.007415836320105_REALK,      0.000000000000000_REALK,     -0.040622237521848_REALK, &
      0.000000000000000_REALK,     -0.015799094706614_REALK,      0.000000000000000_REALK, &
      0.037969427741775_REALK,      0.000000000000000_REALK,      0.018244294501256_REALK, &
      0.000000000000000_REALK,      0.068223905590596_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.018713795292009_REALK,      0.000000000000000_REALK, &
      0.002987287626402_REALK,      0.000000000000000_REALK,     -0.007869472150682_REALK, &
      0.000000000000000_REALK,      0.047227053499412_REALK,      0.000000000000000_REALK, &
      0.004268797791002_REALK,      0.000000000000000_REALK,      0.051745455797407_REALK, &
      0.000000000000000_REALK,     -0.038089618220918_REALK,      0.000000000000000_REALK, &
     -0.001536510930135_REALK,      0.000000000000000_REALK,      0.028019788734603_REALK, &
      0.004301087691554_REALK,      0.000000000000000_REALK,      0.034083530025225_REALK, &
      0.000000000000000_REALK,     -0.021930834315746_REALK,      0.000000000000000_REALK, &
      0.009649801950596_REALK,      0.000000000000000_REALK,      0.001258676840060_REALK, &
      0.000000000000000_REALK,      0.042236007209402_REALK,      0.000000000000000_REALK, &
     -0.036901910312202_REALK,      0.000000000000000_REALK,     -0.048453679223146_REALK, &
      0.000000000000000_REALK,     -0.017989312871751_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.008331745975485_REALK,      0.000000000000000_REALK, &
     -0.008273431681644_REALK,      0.000000000000000_REALK,     -0.021113677449509_REALK, &
      0.000000000000000_REALK,      0.001892437589075_REALK,      0.000000000000000_REALK, &
      0.005524303495105_REALK,      0.000000000000000_REALK,     -0.029400676340360_REALK, &
      0.000000000000000_REALK,      0.027671049856060_REALK,      0.000000000000000_REALK, &
     -0.012741576676301_REALK,      0.000000000000000_REALK,     -0.003002528556495_REALK, &
     -0.002365290298534_REALK,      0.000000000000000_REALK,     -0.014766604181357_REALK, &
      0.000000000000000_REALK,      0.014348504773035_REALK,      0.000000000000000_REALK, &
     -0.010619192156958_REALK,      0.000000000000000_REALK,      0.002220123944398_REALK, &
      0.000000000000000_REALK,     -0.022038108608079_REALK,      0.000000000000000_REALK, &
      0.038188211798883_REALK,      0.000000000000000_REALK,      0.039269718073002_REALK, &
      0.000000000000000_REALK,      0.022669517133722_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.011982586365025_REALK,      0.000000000000000_REALK, &
      0.026471162231497_REALK,      0.000000000000000_REALK,      0.017938319173994_REALK, &
      0.000000000000000_REALK,      0.006148089312141_REALK,      0.000000000000000_REALK, &
     -0.010922611891915_REALK,      0.000000000000000_REALK,     -0.052192441094473_REALK, &
      0.000000000000000_REALK,      0.046801367146901_REALK,      0.000000000000000_REALK, &
      0.006369322282859_REALK,      0.000000000000000_REALK,     -0.007221139856510_REALK, &
     -0.003669251489998_REALK,      0.000000000000000_REALK,     -0.034576427993986_REALK, &
      0.000000000000000_REALK,      0.040212241389373_REALK,      0.000000000000000_REALK, &
      0.017352581593069_REALK,      0.000000000000000_REALK,      0.014534484630856_REALK, &
      0.000000000000000_REALK,     -0.002251279254763_REALK,      0.000000000000000_REALK, &
     -0.034382642762065_REALK,      0.000000000000000_REALK,     -0.014383090061588_REALK, &
      0.000000000000000_REALK,     -0.042718973262329_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.022579832822557_REALK,      0.000000000000000_REALK, &
     -0.032930918471335_REALK,      0.000000000000000_REALK,     -0.008596613783333_REALK, &
      0.000000000000000_REALK,     -0.023466191976997_REALK,      0.000000000000000_REALK, &
      0.038556887804575_REALK,      0.000000000000000_REALK,      0.001869399697498_REALK, &
      0.000000000000000_REALK,      0.000358738066624_REALK,      0.000000000000000_REALK, &
     -0.036149373053101_REALK,      0.000000000000000_REALK,      0.003354709612877_REALK, &
      0.002445900810524_REALK,      0.000000000000000_REALK,      0.014772172973153_REALK, &
      0.000000000000000_REALK,     -0.011016439631158_REALK,      0.000000000000000_REALK, &
     -0.045591714569099_REALK,      0.000000000000000_REALK,     -0.010944131988430_REALK, &
      0.000000000000000_REALK,      0.061891237409423_REALK,      0.000000000000000_REALK, &
     -0.001512543633817_REALK,      0.000000000000000_REALK,     -0.029063188236691_REALK, &
      0.000000000000000_REALK,      0.019332871776484_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.051642004984092_REALK,      0.000000000000000_REALK, &
      0.024423686970206_REALK,      0.000000000000000_REALK,     -0.005340264807022_REALK, &
      0.000000000000000_REALK,      0.044024792122344_REALK,      0.000000000000000_REALK, &
     -0.055327492734793_REALK,      0.000000000000000_REALK,      0.013835110686414_REALK, &
      0.000000000000000_REALK,      0.001010568832713_REALK,      0.000000000000000_REALK, &
      0.013876652139235_REALK,      0.000000000000000_REALK,      0.083188801906733_REALK, &
     -0.041605514827572_REALK,      0.000000000000000_REALK,     -0.007984859098924_REALK, &
      0.000000000000000_REALK,      0.014665056265395_REALK,      0.000000000000000_REALK, &
      0.001881687421609_REALK,      0.000000000000000_REALK,      0.049512911734689_REALK, &
     -0.059993953889227_REALK,      0.000000000000000_REALK,     -0.003608233162300_REALK, &
      0.000000000000000_REALK,     -0.000058551555153_REALK,      0.000000000000000_REALK, &
     -0.004163790928224_REALK,      0.000000000000000_REALK,     -0.018568615404236_REALK, &
     -0.013779759667517_REALK,      0.000000000000000_REALK,      0.004420794689395_REALK, &
      0.000000000000000_REALK,     -0.012221338106657_REALK,      0.000000000000000_REALK, &
     -0.030453164082560_REALK,      0.000000000000000_REALK,     -0.035922508610064_REALK, &
      0.000000000000000_REALK,      0.003387757519021_REALK,      0.000000000000000_REALK, &
      0.016393836099936_REALK,      0.000000000000000_REALK,     -0.000603675562801_REALK, &
      0.000000000000000_REALK,      0.069626069210465_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.022482644348738_REALK,      0.000000000000000_REALK, &
     -0.025890140207179_REALK,      0.000000000000000_REALK,     -0.014481777229190_REALK, &
      0.000000000000000_REALK,      0.043228292142560_REALK,      0.000000000000000_REALK, &
      0.002971847950369_REALK,      0.000000000000000_REALK,      0.046634310178825_REALK, &
      0.000000000000000_REALK,     -0.026013225929590_REALK,      0.000000000000000_REALK, &
     -0.012140726530397_REALK,      0.000000000000000_REALK,      0.004972623078512_REALK, &
      0.003619059986540_REALK,      0.000000000000000_REALK,      0.039974772343774_REALK, &
      0.000000000000000_REALK,     -0.006536409324076_REALK,      0.000000000000000_REALK, &
      0.004997604077638_REALK,      0.000000000000000_REALK,      0.001495050493692_REALK, &
      0.000000000000000_REALK,      0.013546611249874_REALK,      0.000000000000000_REALK, &
     -0.022802318299756_REALK,      0.000000000000000_REALK,     -0.031169130080295_REALK, &
      0.000000000000000_REALK,     -0.006521998737788_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.003432789562995_REALK,      0.000000000000000_REALK, &
     -0.004759951003594_REALK,      0.000000000000000_REALK,     -0.023271068787023_REALK, &
      0.000000000000000_REALK,      0.004746253260042_REALK,      0.000000000000000_REALK, &
     -0.002514717853753_REALK,      0.000000000000000_REALK,     -0.023652934321944_REALK, &
      0.000000000000000_REALK,      0.026100426757596_REALK,      0.000000000000000_REALK, &
     -0.015007283134983_REALK,      0.000000000000000_REALK,      0.003262196616334_REALK, &
     -0.003506208284765_REALK,      0.000000000000000_REALK,     -0.009563819231673_REALK, &
      0.000000000000000_REALK,      0.010888496844742_REALK,      0.000000000000000_REALK, &
     -0.014369909588391_REALK,      0.000000000000000_REALK,     -0.000949665549505_REALK, &
      0.000000000000000_REALK,      0.009394234972259_REALK,      0.000000000000000_REALK, &
      0.036252187234140_REALK,      0.000000000000000_REALK,      0.028731751329572_REALK, &
      0.000000000000000_REALK,      0.008328770268124_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.029519335861410_REALK,      0.000000000000000_REALK, &
      0.039385470043617_REALK,      0.000000000000000_REALK,      0.019467018179384_REALK, &
      0.000000000000000_REALK,     -0.008564716781595_REALK,      0.000000000000000_REALK, &
     -0.004465996495198_REALK,      0.000000000000000_REALK,     -0.043074338135527_REALK, &
      0.000000000000000_REALK,      0.048351394160928_REALK,      0.000000000000000_REALK, &
      0.023235988642297_REALK,      0.000000000000000_REALK,      0.012984821999293_REALK, &
      0.008519093740632_REALK,      0.000000000000000_REALK,     -0.021774403856600_REALK, &
      0.000000000000000_REALK,      0.046403517871364_REALK,      0.000000000000000_REALK, &
      0.040369118392663_REALK,      0.000000000000000_REALK,      0.012761526647170_REALK, &
      0.000000000000000_REALK,     -0.023539338642006_REALK,      0.000000000000000_REALK, &
     -0.039515506369075_REALK,      0.000000000000000_REALK,     -0.002621604659871_REALK, &
      0.000000000000000_REALK,     -0.033519029003324_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.035558871187199_REALK,      0.000000000000000_REALK, &
     -0.048980832663716_REALK,      0.000000000000000_REALK,     -0.002642324879303_REALK, &
      0.000000000000000_REALK,     -0.000691508209410_REALK,      0.000000000000000_REALK, &
      0.009582242264679_REALK,      0.000000000000000_REALK,      0.000646591951833_REALK, &
      0.000000000000000_REALK,     -0.006923654085129_REALK,      0.000000000000000_REALK, &
     -0.054548720747163_REALK,      0.000000000000000_REALK,     -0.010333688596694_REALK, &
     -0.017018173545798_REALK,      0.000000000000000_REALK,      0.011939731548311_REALK, &
      0.000000000000000_REALK,     -0.022666386439707_REALK,      0.000000000000000_REALK, &
     -0.077836666642902_REALK,      0.000000000000000_REALK,     -0.016577014336461_REALK, &
      0.000000000000000_REALK,      0.069707563914391_REALK,      0.000000000000000_REALK, &
      0.023755610814444_REALK,      0.000000000000000_REALK,     -0.001325211131421_REALK, &
      0.000000000000000_REALK,      0.016711925018371_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.066888984072367_REALK,      0.000000000000000_REALK, &
      0.036415099895122_REALK,      0.000000000000000_REALK,      0.011842233390861_REALK, &
      0.000000000000000_REALK,      0.025273948977362_REALK,      0.000000000000000_REALK, &
     -0.029563845142126_REALK,      0.000000000000000_REALK,     -0.007909483125236_REALK, &
      0.000000000000000_REALK,      0.014093779071476_REALK,      0.000000000000000_REALK, &
      0.013247375416410_REALK,      0.000000000000000_REALK,      0.074490239598740_REALK, &
     -0.018058018742232_REALK,      0.000000000000000_REALK,     -0.006352068346945_REALK, &
      0.000000000000000_REALK,      0.006469804115934_REALK,      0.000000000000000_REALK, &
      0.000183453407938_REALK,      0.000000000000000_REALK,      0.050339199866548_REALK/
  ! results of test 4, ket-major order, NEF 002
  data REF_CONTR_INTS(1585:1980)                                                           &
    /-0.083678571896778_REALK,      0.000000000000000_REALK,      0.010160335893479_REALK, &
      0.000000000000000_REALK,     -0.007281773061458_REALK,      0.000000000000000_REALK, &
      0.022747304393444_REALK,      0.000000000000000_REALK,     -0.011346283584422_REALK, &
     -0.046191908179510_REALK,      0.000000000000000_REALK,     -0.002441897924896_REALK, &
      0.000000000000000_REALK,      0.014690273752207_REALK,      0.000000000000000_REALK, &
     -0.007932078745469_REALK,      0.000000000000000_REALK,      0.031593713667793_REALK, &
      0.000000000000000_REALK,      0.012091496152578_REALK,      0.000000000000000_REALK, &
      0.010031297459408_REALK,      0.000000000000000_REALK,     -0.019682403055756_REALK, &
      0.000000000000000_REALK,      0.052770382621275_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.027475955138162_REALK,      0.000000000000000_REALK, &
      0.013692433640148_REALK,      0.000000000000000_REALK,     -0.018010602872658_REALK, &
      0.000000000000000_REALK,      0.057508375506198_REALK,      0.000000000000000_REALK, &
     -0.002167356468883_REALK,      0.000000000000000_REALK,      0.030172148884843_REALK, &
      0.000000000000000_REALK,     -0.017499944956954_REALK,      0.000000000000000_REALK, &
     -0.005178050532990_REALK,      0.000000000000000_REALK,      0.023903497284592_REALK, &
     -0.009474507614915_REALK,      0.000000000000000_REALK,      0.022587254866461_REALK, &
      0.000000000000000_REALK,     -0.001667237027147_REALK,      0.000000000000000_REALK, &
     -0.031989752194803_REALK,      0.000000000000000_REALK,      0.003454612098204_REALK, &
      0.000000000000000_REALK,      0.041871279950679_REALK,      0.000000000000000_REALK, &
     -0.027150231621038_REALK,      0.000000000000000_REALK,     -0.049176403508927_REALK, &
      0.000000000000000_REALK,      0.003705015117991_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.002526821942586_REALK,      0.000000000000000_REALK, &
     -0.014494204004997_REALK,      0.000000000000000_REALK,     -0.023594582727474_REALK, &
      0.000000000000000_REALK,      0.009164683484366_REALK,      0.000000000000000_REALK, &
      0.010581847255141_REALK,      0.000000000000000_REALK,     -0.026709287741871_REALK, &
      0.000000000000000_REALK,      0.032488895145187_REALK,      0.000000000000000_REALK, &
     -0.026774742220509_REALK,      0.000000000000000_REALK,      0.007835893969868_REALK, &
     -0.009607085845835_REALK,      0.000000000000000_REALK,     -0.013338043680070_REALK, &
      0.000000000000000_REALK,      0.032790673581183_REALK,      0.000000000000000_REALK, &
     -0.029744134097928_REALK,      0.000000000000000_REALK,      0.009416600977142_REALK, &
      0.000000000000000_REALK,     -0.026954577552594_REALK,      0.000000000000000_REALK, &
      0.019517387929758_REALK,      0.000000000000000_REALK,      0.038188211798883_REALK, &
      0.000000000000000_REALK,     -0.005469046258456_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000814355633034_REALK,      0.000000000000000_REALK, &
      0.004246472631780_REALK,      0.000000000000000_REALK,      0.026471162231497_REALK, &
      0.000000000000000_REALK,     -0.014939130746448_REALK,      0.000000000000000_REALK, &
      0.005524303495105_REALK,      0.000000000000000_REALK,     -0.029400676340360_REALK, &
      0.000000000000000_REALK,      0.027671049856060_REALK,      0.000000000000000_REALK, &
     -0.012741576676301_REALK,      0.000000000000000_REALK,     -0.003002528556495_REALK, &
     -0.002365290298534_REALK,      0.000000000000000_REALK,     -0.014766604181356_REALK, &
      0.000000000000000_REALK,      0.014348504773035_REALK,      0.000000000000000_REALK, &
     -0.010619192156958_REALK,      0.000000000000000_REALK,      0.002220123944398_REALK, &
      0.000000000000000_REALK,     -0.004918233529089_REALK,      0.000000000000000_REALK, &
     -0.005169454254697_REALK,      0.000000000000000_REALK,      0.013079195159956_REALK, &
      0.000000000000000_REALK,     -0.026133246333690_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.006688184575821_REALK,      0.000000000000000_REALK, &
     -0.000612231002265_REALK,      0.000000000000000_REALK,      0.026311445026823_REALK, &
      0.000000000000000_REALK,     -0.026999092354218_REALK,      0.000000000000000_REALK, &
      0.026076834340661_REALK,      0.000000000000000_REALK,     -0.022535793957030_REALK, &
      0.000000000000000_REALK,      0.028190363378142_REALK,      0.000000000000000_REALK, &
     -0.033578059512477_REALK,      0.000000000000000_REALK,      0.012704455538855_REALK, &
     -0.003802507556326_REALK,      0.000000000000000_REALK,     -0.023131043988982_REALK, &
      0.000000000000000_REALK,      0.027113195133263_REALK,      0.000000000000000_REALK, &
     -0.027709625889018_REALK,      0.000000000000000_REALK,      0.010661731585378_REALK, &
      0.000000000000000_REALK,      0.052512091538047_REALK,      0.000000000000000_REALK, &
     -0.021947200135925_REALK,      0.000000000000000_REALK,     -0.033469556615341_REALK, &
      0.000000000000000_REALK,     -0.005758827971404_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.029913805416369_REALK,      0.000000000000000_REALK, &
     -0.005164609059797_REALK,      0.000000000000000_REALK,      0.012784336580456_REALK, &
      0.000000000000000_REALK,     -0.031890906622843_REALK,      0.000000000000000_REALK, &
      0.004019434871406_REALK,      0.000000000000000_REALK,      0.014897453273315_REALK, &
      0.000000000000000_REALK,      0.002631041317028_REALK,      0.000000000000000_REALK, &
     -0.018925296496013_REALK,      0.000000000000000_REALK,      0.085024279619017_REALK, &
      0.005603036942901_REALK,      0.000000000000000_REALK,     -0.004038869561197_REALK, &
      0.000000000000000_REALK,      0.008122696476309_REALK,      0.000000000000000_REALK, &
     -0.003355937380181_REALK,      0.000000000000000_REALK,      0.047175185485234_REALK, &
     -0.046069757578199_REALK,      0.000000000000000_REALK,      0.005876667344515_REALK, &
      0.000000000000000_REALK,      0.004450299816179_REALK,      0.000000000000000_REALK, &
     -0.005577095959226_REALK,      0.000000000000000_REALK,     -0.015576626656004_REALK, &
     -0.043926832726728_REALK,      0.000000000000000_REALK,      0.007893846212048_REALK, &
      0.000000000000000_REALK,      0.017209343802053_REALK,      0.000000000000000_REALK, &
     -0.021479837520202_REALK,      0.000000000000000_REALK,      0.029572569764926_REALK, &
      0.000000000000000_REALK,     -0.005921251805820_REALK,      0.000000000000000_REALK, &
      0.004660815639266_REALK,      0.000000000000000_REALK,     -0.028303807759783_REALK, &
      0.000000000000000_REALK,      0.063939979812760_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.007175481619529_REALK,      0.000000000000000_REALK, &
      0.008765456157498_REALK,      0.000000000000000_REALK,     -0.014029486662283_REALK, &
      0.000000000000000_REALK,      0.053921221731935_REALK,      0.000000000000000_REALK, &
     -0.007648058335310_REALK,      0.000000000000000_REALK,      0.032144949909550_REALK, &
      0.000000000000000_REALK,     -0.006580520936772_REALK,      0.000000000000000_REALK, &
     -0.009216013961173_REALK,      0.000000000000000_REALK,      0.008986918338489_REALK, &
     -0.020490669909826_REALK,      0.000000000000000_REALK,      0.036692268777203_REALK, &
      0.000000000000000_REALK,      0.014025554102256_REALK,      0.000000000000000_REALK, &
     -0.045964095140944_REALK,      0.000000000000000_REALK,     -0.006237069793917_REALK, &
      0.000000000000000_REALK,      0.013255863971879_REALK,      0.000000000000000_REALK, &
     -0.012522809512516_REALK,      0.000000000000000_REALK,     -0.038418896284984_REALK, &
      0.000000000000000_REALK,      0.016969852328102_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.016363155995786_REALK,      0.000000000000000_REALK, &
     -0.013185418903394_REALK,      0.000000000000000_REALK,     -0.027486284431565_REALK, &
      0.000000000000000_REALK,      0.011225265045960_REALK,      0.000000000000000_REALK, &
     -0.007623972018567_REALK,      0.000000000000000_REALK,     -0.013059771865561_REALK, &
      0.000000000000000_REALK,      0.034851305470976_REALK,      0.000000000000000_REALK, &
     -0.037753288887697_REALK,      0.000000000000000_REALK,      0.008826003045777_REALK, &
     -0.015118844440062_REALK,      0.000000000000000_REALK,      0.006965415320181_REALK, &
      0.000000000000000_REALK,      0.040771591831630_REALK,      0.000000000000000_REALK, &
     -0.044198991760384_REALK,      0.000000000000000_REALK,     -0.000855291516577_REALK, &
      0.000000000000000_REALK,     -0.001990425055564_REALK,      0.000000000000000_REALK, &
      0.009980803407879_REALK,      0.000000000000000_REALK,      0.036252187234140_REALK, &
      0.000000000000000_REALK,     -0.015114272902643_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.019771113514339_REALK,      0.000000000000000_REALK, &
     -0.000904577412613_REALK,      0.000000000000000_REALK,      0.039385470043617_REALK, &
      0.000000000000000_REALK,     -0.013812488670563_REALK,      0.000000000000000_REALK, &
     -0.002514717853753_REALK,      0.000000000000000_REALK,     -0.023652934321944_REALK, &
      0.000000000000000_REALK,      0.026100426757596_REALK,      0.000000000000000_REALK, &
     -0.015007283134983_REALK,      0.000000000000000_REALK,      0.003262196616334_REALK, &
     -0.003506208284765_REALK,      0.000000000000000_REALK,     -0.009563819231673_REALK, &
      0.000000000000000_REALK,      0.010888496844742_REALK,      0.000000000000000_REALK, &
     -0.014369909588391_REALK,      0.000000000000000_REALK,     -0.000949665549505_REALK, &
      0.000000000000000_REALK,      0.005799420845132_REALK,      0.000000000000000_REALK, &
     -0.008677924367318_REALK,      0.000000000000000_REALK,      0.020869185801295_REALK, &
      0.000000000000000_REALK,     -0.030273203876096_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.027948241525075_REALK,      0.000000000000000_REALK, &
     -0.006785984889646_REALK,      0.000000000000000_REALK,      0.038895182780087_REALK, &
      0.000000000000000_REALK,     -0.023941968451455_REALK,      0.000000000000000_REALK, &
     -0.000759184772894_REALK,      0.000000000000000_REALK,     -0.007915668948929_REALK, &
      0.000000000000000_REALK,      0.026203428223684_REALK,      0.000000000000000_REALK, &
     -0.044932268391779_REALK,      0.000000000000000_REALK,      0.012257677521476_REALK, &
     -0.009619312267888_REALK,      0.000000000000000_REALK,     -0.011692921308628_REALK, &
      0.000000000000000_REALK,      0.026875135848386_REALK,      0.000000000000000_REALK, &
     -0.043634396247877_REALK,      0.000000000000000_REALK,      0.001977445870336_REALK, &
      0.000000000000000_REALK,      0.043798145254599_REALK,      0.000000000000000_REALK, &
     -0.005994044687183_REALK,      0.000000000000000_REALK,     -0.001020760816927_REALK, &
      0.000000000000000_REALK,      0.005839757101894_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.038891747877780_REALK,      0.000000000000000_REALK, &
     -0.001529743440687_REALK,      0.000000000000000_REALK,      0.042989584244712_REALK, &
      0.000000000000000_REALK,     -0.030836173549336_REALK,      0.000000000000000_REALK, &
     -0.024385780196893_REALK,      0.000000000000000_REALK,     -0.000049574995619_REALK, &
      0.000000000000000_REALK,      0.010220625385895_REALK,      0.000000000000000_REALK, &
     -0.018029399641210_REALK,      0.000000000000000_REALK,      0.057064987316090_REALK, &
     -0.016227033434364_REALK,      0.000000000000000_REALK,     -0.007127188618810_REALK, &
      0.000000000000000_REALK,      0.000904261322510_REALK,      0.000000000000000_REALK, &
      0.005699243184528_REALK,      0.000000000000000_REALK,      0.026062342858895_REALK/
  ! results of test 4, ket-major order, NEF 003
  data REF_CONTR_INTS(1981:2376)                                                           &
     /0.000000000000000_REALK,      0.011609668971787_REALK,      0.000000000000000_REALK, &
      0.005066673242411_REALK,      0.000000000000000_REALK,     -0.004814650625358_REALK, &
      0.000000000000000_REALK,      0.019753191949585_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.003541754180992_REALK,      0.000000000000000_REALK, &
     -0.000688529492783_REALK,      0.000000000000000_REALK,      0.001554216598903_REALK, &
      0.000000000000000_REALK,      0.004849715466083_REALK,      0.000000000000000_REALK, &
     -0.024177576709270_REALK,      0.000000000000000_REALK,      0.003359324577804_REALK, &
      0.000000000000000_REALK,     -0.003875786296910_REALK,      0.000000000000000_REALK, &
     -0.000068110103708_REALK,      0.000000000000000_REALK,     -0.033349679638198_REALK, &
     -0.011047326000450_REALK,      0.000000000000000_REALK,      0.008850929943924_REALK, &
      0.000000000000000_REALK,     -0.003683697682179_REALK,      0.000000000000000_REALK, &
     -0.011182483945452_REALK,      0.000000000000000_REALK,     -0.028383227450350_REALK, &
      0.000000000000000_REALK,     -0.017833468406687_REALK,      0.000000000000000_REALK, &
      0.008016328554315_REALK,      0.000000000000000_REALK,      0.007684069516140_REALK, &
      0.000000000000000_REALK,      0.016287773859383_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.022121184272812_REALK,      0.000000000000000_REALK, &
     -0.001490851774345_REALK,      0.000000000000000_REALK,     -0.010360488755783_REALK, &
      0.000000000000000_REALK,      0.035445348341821_REALK,      0.000000000000000_REALK, &
     -0.012093347704422_REALK,      0.000000000000000_REALK,      0.013188701703611_REALK, &
      0.000000000000000_REALK,     -0.007965351104175_REALK,      0.000000000000000_REALK, &
      0.005531679101313_REALK,      0.000000000000000_REALK,      0.010813431920290_REALK, &
      0.003666866811278_REALK,      0.000000000000000_REALK,      0.031004493719959_REALK, &
      0.000000000000000_REALK,     -0.022103848224979_REALK,      0.000000000000000_REALK, &
      0.017660026072974_REALK,      0.000000000000000_REALK,     -0.005642447238127_REALK, &
      0.000000000000000_REALK,      0.020363764290866_REALK,      0.000000000000000_REALK, &
     -0.008365668804021_REALK,      0.000000000000000_REALK,     -0.014898374754151_REALK, &
      0.000000000000000_REALK,      0.000365297555509_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.007502440532608_REALK,      0.000000000000000_REALK, &
     -0.003823113958789_REALK,      0.000000000000000_REALK,     -0.022952709491811_REALK, &
      0.000000000000000_REALK,      0.018580798638322_REALK,      0.000000000000000_REALK, &
      0.002636256717952_REALK,      0.000000000000000_REALK,     -0.014953810769189_REALK, &
      0.000000000000000_REALK,      0.011065222424972_REALK,      0.000000000000000_REALK, &
     -0.003867327027097_REALK,      0.000000000000000_REALK,     -0.004755920909445_REALK, &
     -0.008096251319718_REALK,      0.000000000000000_REALK,     -0.029786248085792_REALK, &
      0.000000000000000_REALK,      0.032583689625768_REALK,      0.000000000000000_REALK, &
     -0.007703264675205_REALK,      0.000000000000000_REALK,      0.014605986843906_REALK, &
      0.000000000000000_REALK,      0.019471441164602_REALK,      0.000000000000000_REALK, &
     -0.014898374754151_REALK,      0.000000000000000_REALK,     -0.016071649337793_REALK, &
      0.000000000000000_REALK,     -0.015422568584734_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.006646922390244_REALK,      0.000000000000000_REALK, &
     -0.022952709491811_REALK,      0.000000000000000_REALK,     -0.015695088953373_REALK, &
      0.000000000000000_REALK,     -0.014026787327664_REALK,      0.000000000000000_REALK, &
      0.016120166384704_REALK,      0.000000000000000_REALK,      0.005531679101313_REALK, &
      0.000000000000000_REALK,     -0.002059984446838_REALK,      0.000000000000000_REALK, &
     -0.006770074027996_REALK,      0.000000000000000_REALK,      0.013465765607565_REALK, &
     -0.000753233620787_REALK,      0.000000000000000_REALK,      0.017660026072974_REALK, &
      0.000000000000000_REALK,     -0.005716456558313_REALK,      0.000000000000000_REALK, &
     -0.032714404890979_REALK,      0.000000000000000_REALK,     -0.002402427381394_REALK, &
      0.000000000000000_REALK,      0.016287773859383_REALK,      0.000000000000000_REALK, &
      0.000118429628822_REALK,      0.000000000000000_REALK,     -0.006059716686939_REALK, &
      0.000000000000000_REALK,      0.013079672344715_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.035445348341821_REALK,      0.000000000000000_REALK, &
      0.011898653030799_REALK,      0.000000000000000_REALK,     -0.004265766519140_REALK, &
      0.000000000000000_REALK,      0.045151793098612_REALK,      0.000000000000000_REALK, &
     -0.033349679638198_REALK,      0.000000000000000_REALK,     -0.005524766324275_REALK, &
      0.000000000000000_REALK,      0.006992085772410_REALK,      0.000000000000000_REALK, &
     -0.001948134185931_REALK,      0.000000000000000_REALK,      0.017500608511736_REALK, &
     -0.028383227450350_REALK,      0.000000000000000_REALK,     -0.008266110652269_REALK, &
      0.000000000000000_REALK,      0.006645549620205_REALK,      0.000000000000000_REALK, &
     -0.009605157039072_REALK,      0.000000000000000_REALK,      0.024424121512068_REALK, &
      0.000000000000000_REALK,      0.015748060925869_REALK,      0.000000000000000_REALK, &
     -0.003650483080164_REALK,      0.000000000000000_REALK,     -0.002966464741251_REALK, &
      0.000000000000000_REALK,     -0.010573869355612_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.007641975956230_REALK,      0.000000000000000_REALK, &
      0.003393520267125_REALK,      0.000000000000000_REALK,      0.004006712701174_REALK, &
      0.000000000000000_REALK,     -0.004263883451378_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.014921492621590_REALK,      0.000000000000000_REALK, &
      0.003288702805496_REALK,      0.000000000000000_REALK,     -0.000513691887398_REALK, &
      0.000000000000000_REALK,      0.023864389665372_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.005189014151328_REALK,      0.000000000000000_REALK, &
     -0.008670928550406_REALK,      0.000000000000000_REALK,      0.009014960126558_REALK, &
      0.000000000000000_REALK,      0.003918731978951_REALK,      0.000000000000000_REALK, &
     -0.012901924670377_REALK,      0.000000000000000_REALK,      0.019126977176408_REALK, &
      0.000000000000000_REALK,     -0.003962331451736_REALK,      0.000000000000000_REALK, &
     -0.024786663214358_REALK,      0.000000000000000_REALK,     -0.020759059732966_REALK, &
     -0.002214744412576_REALK,      0.000000000000000_REALK,      0.019563457693036_REALK, &
      0.000000000000000_REALK,      0.005597889853132_REALK,      0.000000000000000_REALK, &
     -0.034780747042906_REALK,      0.000000000000000_REALK,     -0.022660094588656_REALK, &
      0.000000000000000_REALK,     -0.012778490138115_REALK,      0.000000000000000_REALK, &
     -0.009872888183473_REALK,      0.000000000000000_REALK,     -0.008114945476024_REALK, &
      0.000000000000000_REALK,      0.015060576710073_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.023381466227637_REALK,      0.000000000000000_REALK, &
     -0.026652618926422_REALK,      0.000000000000000_REALK,     -0.027881353766858_REALK, &
      0.000000000000000_REALK,      0.036698250113447_REALK,      0.000000000000000_REALK, &
     -0.002083754865715_REALK,      0.000000000000000_REALK,      0.004230025178427_REALK, &
      0.000000000000000_REALK,      0.005103158937805_REALK,      0.000000000000000_REALK, &
      0.000455733689852_REALK,      0.000000000000000_REALK,     -0.000291372092213_REALK, &
      0.006937073357901_REALK,      0.000000000000000_REALK,      0.037976255546427_REALK, &
      0.000000000000000_REALK,     -0.012112363792742_REALK,      0.000000000000000_REALK, &
      0.021542585850824_REALK,      0.000000000000000_REALK,     -0.003103390136203_REALK, &
      0.000000000000000_REALK,      0.012788256078341_REALK,      0.000000000000000_REALK, &
      0.001285851615744_REALK,      0.000000000000000_REALK,      0.002723674952107_REALK, &
      0.000000000000000_REALK,      0.004302454892069_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.006453210766809_REALK,      0.000000000000000_REALK, &
      0.001856968555879_REALK,      0.000000000000000_REALK,     -0.011937172026173_REALK, &
      0.000000000000000_REALK,      0.022406361614538_REALK,      0.000000000000000_REALK, &
     -0.002791131677114_REALK,      0.000000000000000_REALK,     -0.008999854981544_REALK, &
      0.000000000000000_REALK,     -0.000492225304508_REALK,      0.000000000000000_REALK, &
     -0.002327525936184_REALK,      0.000000000000000_REALK,      0.005035322020729_REALK, &
     -0.006857488423078_REALK,      0.000000000000000_REALK,     -0.032176854450745_REALK, &
      0.000000000000000_REALK,      0.025959787667969_REALK,      0.000000000000000_REALK, &
     -0.008321518894750_REALK,      0.000000000000000_REALK,      0.012371205108935_REALK, &
      0.000000000000000_REALK,      0.009176199007129_REALK,      0.000000000000000_REALK, &
      0.002723674952107_REALK,      0.000000000000000_REALK,      0.002694635225206_REALK, &
      0.000000000000000_REALK,     -0.011527817342674_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.023044875310166_REALK,      0.000000000000000_REALK, &
     -0.011937172026173_REALK,      0.000000000000000_REALK,     -0.004317370375711_REALK, &
      0.000000000000000_REALK,     -0.005301304499363_REALK,      0.000000000000000_REALK, &
      0.006546490788453_REALK,      0.000000000000000_REALK,      0.000455733689852_REALK, &
      0.000000000000000_REALK,      0.001319769575017_REALK,      0.000000000000000_REALK, &
      0.002585698683252_REALK,      0.000000000000000_REALK,      0.003852150382693_REALK, &
     -0.014668710687889_REALK,      0.000000000000000_REALK,      0.021542585850824_REALK, &
      0.000000000000000_REALK,     -0.003132477238124_REALK,      0.000000000000000_REALK, &
     -0.039751253913298_REALK,      0.000000000000000_REALK,     -0.009928075279546_REALK, &
      0.000000000000000_REALK,      0.015060576710073_REALK,      0.000000000000000_REALK, &
     -0.001945996850892_REALK,      0.000000000000000_REALK,      0.008277486040502_REALK, &
      0.000000000000000_REALK,      0.015805509839730_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.036698250113447_REALK,      0.000000000000000_REALK, &
      0.002720644614391_REALK,      0.000000000000000_REALK,      0.018738386410734_REALK, &
      0.000000000000000_REALK,      0.046269437627070_REALK,      0.000000000000000_REALK, &
     -0.020759059732966_REALK,      0.000000000000000_REALK,     -0.017508067872433_REALK, &
      0.000000000000000_REALK,      0.007148216967314_REALK,      0.000000000000000_REALK, &
     -0.021009354111598_REALK,      0.000000000000000_REALK,      0.013041351125697_REALK, &
     -0.022660094588655_REALK,      0.000000000000000_REALK,     -0.012517573982122_REALK, &
      0.000000000000000_REALK,     -0.010098834919978_REALK,      0.000000000000000_REALK, &
     -0.025321118547238_REALK,      0.000000000000000_REALK,      0.026104316808923_REALK, &
      0.000000000000000_REALK,      0.023915931441701_REALK,      0.000000000000000_REALK, &
      0.006038304420796_REALK,      0.000000000000000_REALK,      0.008531381342056_REALK, &
      0.000000000000000_REALK,     -0.014934822260950_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.018883067481702_REALK,      0.000000000000000_REALK, &
      0.008743585070310_REALK,      0.000000000000000_REALK,      0.008181356235419_REALK, &
      0.000000000000000_REALK,     -0.009059063065654_REALK,      0.000000000000000_REALK/
  ! results of test 5, ket-major order, NEF 004
  data REF_CONTR_INTS(2377:2772)                                                           &
     /0.110659639543636_REALK,      0.000000000000000_REALK,     -0.005020946120050_REALK, &
      0.000000000000000_REALK,      0.008421170251025_REALK,      0.000000000000000_REALK, &
     -0.034136074128505_REALK,      0.000000000000000_REALK,      0.047598849727497_REALK, &
      0.047869188339062_REALK,      0.000000000000000_REALK,     -0.002233141456474_REALK, &
      0.000000000000000_REALK,     -0.002752690229113_REALK,      0.000000000000000_REALK, &
     -0.000311045972956_REALK,      0.000000000000000_REALK,      0.004949674189506_REALK, &
      0.000000000000000_REALK,      0.002275749783201_REALK,      0.000000000000000_REALK, &
     -0.021437736720652_REALK,      0.000000000000000_REALK,      0.010880176240507_REALK, &
      0.000000000000000_REALK,     -0.070095778756444_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.006682675139600_REALK,      0.000000000000000_REALK, &
     -0.007283470264318_REALK,      0.000000000000000_REALK,      0.016800529132446_REALK, &
      0.000000000000000_REALK,     -0.050987896670079_REALK,      0.000000000000000_REALK, &
      0.009220226797993_REALK,      0.000000000000000_REALK,     -0.047880517461541_REALK, &
      0.000000000000000_REALK,      0.030930916053742_REALK,      0.000000000000000_REALK, &
     -0.000423674316185_REALK,      0.000000000000000_REALK,     -0.035253259854566_REALK, &
      0.004601310048565_REALK,      0.000000000000000_REALK,     -0.026884634802172_REALK, &
      0.000000000000000_REALK,      0.009213354521478_REALK,      0.000000000000000_REALK, &
      0.011407581324175_REALK,      0.000000000000000_REALK,     -0.009416589255178_REALK, &
      0.000000000000000_REALK,     -0.058951923941962_REALK,      0.000000000000000_REALK, &
      0.037243043197681_REALK,      0.000000000000000_REALK,      0.067076436067484_REALK, &
      0.000000000000000_REALK,     -0.003726434008274_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.015419073194149_REALK,      0.000000000000000_REALK, &
      0.015225896872079_REALK,      0.000000000000000_REALK,      0.031151218197261_REALK, &
      0.000000000000000_REALK,     -0.007392328459872_REALK,      0.000000000000000_REALK, &
     -0.016037470099859_REALK,      0.000000000000000_REALK,      0.035355033055194_REALK, &
      0.000000000000000_REALK,     -0.041053527780283_REALK,      0.000000000000000_REALK, &
      0.033226904271203_REALK,      0.000000000000000_REALK,     -0.006960001831790_REALK, &
      0.002033908206918_REALK,      0.000000000000000_REALK,      0.015466869391874_REALK, &
      0.000000000000000_REALK,     -0.027165131895040_REALK,      0.000000000000000_REALK, &
      0.025001145452704_REALK,      0.000000000000000_REALK,     -0.007049944425819_REALK, &
      0.000000000000000_REALK,      0.037464424569779_REALK,      0.000000000000000_REALK, &
     -0.030382108213511_REALK,      0.000000000000000_REALK,     -0.052354084206687_REALK, &
      0.000000000000000_REALK,      0.001391644096872_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.004795662177322_REALK,      0.000000000000000_REALK, &
     -0.013318745696127_REALK,      0.000000000000000_REALK,     -0.028174905454889_REALK, &
      0.000000000000000_REALK,      0.008497674708439_REALK,      0.000000000000000_REALK, &
     -0.006954481685100_REALK,      0.000000000000000_REALK,      0.046603397191061_REALK, &
      0.000000000000000_REALK,     -0.042893805595584_REALK,      0.000000000000000_REALK, &
      0.015320007181880_REALK,      0.000000000000000_REALK,      0.007862311777162_REALK, &
     -0.000271893506656_REALK,      0.000000000000000_REALK,      0.021714754265775_REALK, &
      0.000000000000000_REALK,     -0.023402361369956_REALK,      0.000000000000000_REALK, &
      0.005474908224093_REALK,      0.000000000000000_REALK,     -0.002581720408342_REALK, &
      0.000000000000000_REALK,      0.000651909497165_REALK,      0.000000000000000_REALK, &
      0.015733887045730_REALK,      0.000000000000000_REALK,     -0.006248063963794_REALK, &
      0.000000000000000_REALK,      0.038192730631570_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.001994185629327_REALK,      0.000000000000000_REALK, &
      0.009620493167634_REALK,      0.000000000000000_REALK,     -0.013917436494421_REALK, &
      0.000000000000000_REALK,      0.023568929598624_REALK,      0.000000000000000_REALK, &
     -0.040643872422597_REALK,      0.000000000000000_REALK,      0.020007593907439_REALK, &
      0.000000000000000_REALK,     -0.028565596338183_REALK,      0.000000000000000_REALK, &
      0.045781958647272_REALK,      0.000000000000000_REALK,     -0.019489735009752_REALK, &
     -0.005048382560466_REALK,      0.000000000000000_REALK,      0.011647984851276_REALK, &
      0.000000000000000_REALK,     -0.017871654323415_REALK,      0.000000000000000_REALK, &
      0.034545532140147_REALK,      0.000000000000000_REALK,     -0.007884790588002_REALK, &
      0.000000000000000_REALK,     -0.071824513264005_REALK,      0.000000000000000_REALK, &
      0.021785674383822_REALK,      0.000000000000000_REALK,      0.045676186076220_REALK, &
      0.000000000000000_REALK,     -0.008989359752424_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.040281778297581_REALK,      0.000000000000000_REALK, &
      0.003968143444018_REALK,      0.000000000000000_REALK,      0.005154798815128_REALK, &
      0.000000000000000_REALK,      0.003827389300237_REALK,      0.000000000000000_REALK, &
      0.032974135509572_REALK,      0.000000000000000_REALK,     -0.023167137213057_REALK, &
      0.000000000000000_REALK,      0.000264457862195_REALK,      0.000000000000000_REALK, &
      0.010651026034302_REALK,      0.000000000000000_REALK,     -0.107413109492555_REALK, &
      0.008774489679331_REALK,      0.000000000000000_REALK,     -0.001465946551356_REALK, &
      0.000000000000000_REALK,     -0.006923193670067_REALK,      0.000000000000000_REALK, &
      0.008494043826714_REALK,      0.000000000000000_REALK,     -0.055008432458092_REALK, &
      0.085660230051904_REALK,      0.000000000000000_REALK,     -0.011578031073445_REALK, &
      0.000000000000000_REALK,     -0.013642408996538_REALK,      0.000000000000000_REALK, &
      0.007856725471734_REALK,      0.000000000000000_REALK,      0.064456150720505_REALK, &
      0.052878878069465_REALK,      0.000000000000000_REALK,     -0.015341879707601_REALK, &
      0.000000000000000_REALK,     -0.017973762738847_REALK,      0.000000000000000_REALK, &
      0.026736046443519_REALK,      0.000000000000000_REALK,      0.001275518697266_REALK, &
      0.000000000000000_REALK,      0.046845968761739_REALK,      0.000000000000000_REALK, &
     -0.021977095450964_REALK,      0.000000000000000_REALK,      0.056350739874072_REALK, &
      0.000000000000000_REALK,     -0.140264502343916_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.024722270565000_REALK,      0.000000000000000_REALK, &
     -0.005499686487291_REALK,      0.000000000000000_REALK,      0.033647786562671_REALK, &
      0.000000000000000_REALK,     -0.081655526791215_REALK,      0.000000000000000_REALK, &
      0.013136682360019_REALK,      0.000000000000000_REALK,     -0.069327626899076_REALK, &
      0.000000000000000_REALK,      0.020170231927642_REALK,      0.000000000000000_REALK, &
      0.001628344455680_REALK,      0.000000000000000_REALK,     -0.014577009165778_REALK, &
      0.019170087863867_REALK,      0.000000000000000_REALK,     -0.053880707672276_REALK, &
      0.000000000000000_REALK,     -0.010638909676788_REALK,      0.000000000000000_REALK, &
      0.029350971952927_REALK,      0.000000000000000_REALK,      0.003523340743816_REALK, &
      0.000000000000000_REALK,     -0.024808127120756_REALK,      0.000000000000000_REALK, &
      0.020223193906789_REALK,      0.000000000000000_REALK,      0.078809311541866_REALK, &
      0.000000000000000_REALK,     -0.035845765544962_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.013469665240771_REALK,      0.000000000000000_REALK, &
      0.011388045014352_REALK,      0.000000000000000_REALK,      0.045593378274352_REALK, &
      0.000000000000000_REALK,     -0.017692592930572_REALK,      0.000000000000000_REALK, &
      0.023078508210528_REALK,      0.000000000000000_REALK,      0.021288776881695_REALK, &
      0.000000000000000_REALK,     -0.071803555013410_REALK,      0.000000000000000_REALK, &
      0.080492997827280_REALK,      0.000000000000000_REALK,     -0.015685949735094_REALK, &
      0.019956181480489_REALK,      0.000000000000000_REALK,     -0.006276713970167_REALK, &
      0.000000000000000_REALK,     -0.052558330201142_REALK,      0.000000000000000_REALK, &
      0.061320988010260_REALK,      0.000000000000000_REALK,      0.000406964996623_REALK, &
      0.000000000000000_REALK,      0.003385231837306_REALK,      0.000000000000000_REALK, &
     -0.014251294895631_REALK,      0.000000000000000_REALK,     -0.075822563649710_REALK, &
      0.000000000000000_REALK,      0.019695885500747_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.024268252179655_REALK,      0.000000000000000_REALK, &
     -0.003440903494817_REALK,      0.000000000000000_REALK,     -0.055393782252953_REALK, &
      0.000000000000000_REALK,      0.014349782833752_REALK,      0.000000000000000_REALK, &
      0.020088068484479_REALK,      0.000000000000000_REALK,      0.057639698464518_REALK, &
      0.000000000000000_REALK,     -0.055853110555576_REALK,      0.000000000000000_REALK, &
      0.044489141288813_REALK,      0.000000000000000_REALK,     -0.008465017790595_REALK, &
      0.008319281085507_REALK,      0.000000000000000_REALK,      0.023187427319663_REALK, &
      0.000000000000000_REALK,     -0.026368727201999_REALK,      0.000000000000000_REALK, &
      0.022081138609138_REALK,      0.000000000000000_REALK,     -0.002385787836423_REALK, &
      0.000000000000000_REALK,     -0.026656857504214_REALK,      0.000000000000000_REALK, &
      0.019254106804349_REALK,      0.000000000000000_REALK,     -0.033845228123844_REALK, &
      0.000000000000000_REALK,      0.078649143094462_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.029696556485716_REALK,      0.000000000000000_REALK, &
      0.016384360062694_REALK,      0.000000000000000_REALK,     -0.040174157959669_REALK, &
      0.000000000000000_REALK,      0.038115425756481_REALK,      0.000000000000000_REALK, &
     -0.002338676668144_REALK,      0.000000000000000_REALK,     -0.006177122962615_REALK, &
      0.000000000000000_REALK,     -0.053951202074367_REALK,      0.000000000000000_REALK, &
      0.086041785891453_REALK,      0.000000000000000_REALK,     -0.024440155519460_REALK, &
      0.011094095999304_REALK,      0.000000000000000_REALK,     -0.004559058888221_REALK, &
      0.000000000000000_REALK,     -0.035479102548644_REALK,      0.000000000000000_REALK, &
      0.069402472020084_REALK,      0.000000000000000_REALK,     -0.001071710578907_REALK, &
      0.000000000000000_REALK,     -0.079206848388611_REALK,      0.000000000000000_REALK, &
      0.012576683612798_REALK,      0.000000000000000_REALK,      0.003016178209855_REALK, &
      0.000000000000000_REALK,     -0.051103709964284_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.055446168456965_REALK,      0.000000000000000_REALK, &
      0.005050592505020_REALK,      0.000000000000000_REALK,     -0.041867035114746_REALK, &
      0.000000000000000_REALK,     -0.000443858534364_REALK,      0.000000000000000_REALK, &
      0.102771203464863_REALK,      0.000000000000000_REALK,      0.004716069006021_REALK, &
      0.000000000000000_REALK,     -0.027702447297058_REALK,      0.000000000000000_REALK, &
      0.040048815102589_REALK,      0.000000000000000_REALK,     -0.099634703414512_REALK, &
      0.052406076310517_REALK,      0.000000000000000_REALK,      0.006929560698074_REALK, &
      0.000000000000000_REALK,     -0.006582332796490_REALK,      0.000000000000000_REALK, &
      0.011419203524654_REALK,      0.000000000000000_REALK,     -0.041871214726331_REALK/
  ! results of test 5, ket-major order, NEF 005
  data REF_CONTR_INTS(2773:3168)                                                           &
     /0.091777909329394_REALK,      0.000000000000000_REALK,      0.017237737826717_REALK, &
      0.000000000000000_REALK,     -0.010391384886926_REALK,      0.000000000000000_REALK, &
     -0.024566848586047_REALK,      0.000000000000000_REALK,      0.028924067867825_REALK, &
      0.029788888299666_REALK,      0.000000000000000_REALK,      0.003530926737857_REALK, &
      0.000000000000000_REALK,      0.001273238751639_REALK,      0.000000000000000_REALK, &
     -0.001649216684176_REALK,      0.000000000000000_REALK,      0.024761397817580_REALK, &
      0.000000000000000_REALK,      0.008319515360721_REALK,      0.000000000000000_REALK, &
     -0.037116969367804_REALK,      0.000000000000000_REALK,     -0.021437736720652_REALK, &
      0.000000000000000_REALK,     -0.058435520559293_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.010722571635897_REALK,      0.000000000000000_REALK, &
     -0.011518654340153_REALK,      0.000000000000000_REALK,     -0.007283470264318_REALK, &
      0.000000000000000_REALK,     -0.031964609191407_REALK,      0.000000000000000_REALK, &
     -0.013122570230263_REALK,      0.000000000000000_REALK,     -0.047278816343338_REALK, &
      0.000000000000000_REALK,      0.035395117303038_REALK,      0.000000000000000_REALK, &
      0.006601841932020_REALK,      0.000000000000000_REALK,     -0.027811472767723_REALK, &
     -0.004260059532764_REALK,      0.000000000000000_REALK,     -0.026014503333904_REALK, &
      0.000000000000000_REALK,      0.017558110733799_REALK,      0.000000000000000_REALK, &
     -0.000904642631390_REALK,      0.000000000000000_REALK,     -0.003964209003837_REALK, &
      0.000000000000000_REALK,     -0.032620055660312_REALK,      0.000000000000000_REALK, &
      0.035608661976024_REALK,      0.000000000000000_REALK,      0.037243043197681_REALK, &
      0.000000000000000_REALK,      0.028510224716431_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.008630371328158_REALK,      0.000000000000000_REALK, &
      0.011910231861993_REALK,      0.000000000000000_REALK,      0.015225896872079_REALK, &
      0.000000000000000_REALK,      0.007764235419130_REALK,      0.000000000000000_REALK, &
     -0.002559095017822_REALK,      0.000000000000000_REALK,      0.026881016648625_REALK, &
      0.000000000000000_REALK,     -0.021659429958108_REALK,      0.000000000000000_REALK, &
      0.003684396718838_REALK,      0.000000000000000_REALK,      0.009300591234870_REALK, &
      0.000540040681208_REALK,      0.000000000000000_REALK,      0.011013268304016_REALK, &
      0.000000000000000_REALK,     -0.009351568512687_REALK,      0.000000000000000_REALK, &
      0.002989152755491_REALK,      0.000000000000000_REALK,      0.002097971331259_REALK, &
      0.000000000000000_REALK,      0.015905663371738_REALK,      0.000000000000000_REALK, &
     -0.036639354356503_REALK,      0.000000000000000_REALK,     -0.030382108213511_REALK, &
      0.000000000000000_REALK,     -0.029419151835771_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.004197299214595_REALK,      0.000000000000000_REALK, &
     -0.021285966442261_REALK,      0.000000000000000_REALK,     -0.013318745696127_REALK, &
      0.000000000000000_REALK,     -0.011832619041420_REALK,      0.000000000000000_REALK, &
      0.015428230743815_REALK,      0.000000000000000_REALK,      0.047440628981784_REALK, &
      0.000000000000000_REALK,     -0.041053527780283_REALK,      0.000000000000000_REALK, &
     -0.013504523728767_REALK,      0.000000000000000_REALK,      0.010481765349298_REALK, &
      0.005574700515994_REALK,      0.000000000000000_REALK,      0.025630771255497_REALK, &
      0.000000000000000_REALK,     -0.027165131895040_REALK,      0.000000000000000_REALK, &
     -0.014299659490945_REALK,      0.000000000000000_REALK,     -0.005087246204085_REALK, &
      0.000000000000000_REALK,      0.005486393123015_REALK,      0.000000000000000_REALK, &
      0.032804295085960_REALK,      0.000000000000000_REALK,      0.015733887045730_REALK, &
      0.000000000000000_REALK,      0.036998399165752_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.011059045817249_REALK,      0.000000000000000_REALK, &
      0.025053909478502_REALK,      0.000000000000000_REALK,      0.009620493167634_REALK, &
      0.000000000000000_REALK,      0.018016885417356_REALK,      0.000000000000000_REALK, &
     -0.035292760371540_REALK,      0.000000000000000_REALK,     -0.001867393245311_REALK, &
      0.000000000000000_REALK,      0.004523176693431_REALK,      0.000000000000000_REALK, &
      0.026847548119714_REALK,      0.000000000000000_REALK,      0.007731957662232_REALK, &
     -0.009507084699620_REALK,      0.000000000000000_REALK,     -0.008689885405070_REALK, &
      0.000000000000000_REALK,      0.010425734926384_REALK,      0.000000000000000_REALK, &
      0.025774099806802_REALK,      0.000000000000000_REALK,      0.008628266227477_REALK, &
      0.000000000000000_REALK,     -0.050827746314896_REALK,      0.000000000000000_REALK, &
      0.001656121199159_REALK,      0.000000000000000_REALK,      0.021785674383822_REALK, &
      0.000000000000000_REALK,     -0.006590780853160_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.034646916621923_REALK,      0.000000000000000_REALK, &
     -0.014683528925014_REALK,      0.000000000000000_REALK,      0.003968143444018_REALK, &
      0.000000000000000_REALK,     -0.021428690008395_REALK,      0.000000000000000_REALK, &
      0.033241971181795_REALK,      0.000000000000000_REALK,     -0.015386396277646_REALK, &
      0.000000000000000_REALK,      0.002807708650319_REALK,      0.000000000000000_REALK, &
     -0.014478433874440_REALK,      0.000000000000000_REALK,     -0.077153195111468_REALK, &
      0.029922308447473_REALK,      0.000000000000000_REALK,      0.002519232112186_REALK, &
      0.000000000000000_REALK,     -0.005884519351891_REALK,      0.000000000000000_REALK, &
     -0.010466925782852_REALK,      0.000000000000000_REALK,     -0.033613703789490_REALK, &
      0.085739010896057_REALK,      0.000000000000000_REALK,      0.016529183447475_REALK, &
      0.000000000000000_REALK,      0.008362967422046_REALK,      0.000000000000000_REALK, &
      0.000097564012871_REALK,      0.000000000000000_REALK,     -0.022224491210430_REALK, &
      0.017397319213592_REALK,      0.000000000000000_REALK,      0.008019220546688_REALK, &
      0.000000000000000_REALK,      0.020309764924711_REALK,      0.000000000000000_REALK, &
      0.021389342779076_REALK,      0.000000000000000_REALK,      0.022484375779166_REALK, &
      0.000000000000000_REALK,     -0.070167190815843_REALK,      0.000000000000000_REALK, &
     -0.026988980109663_REALK,      0.000000000000000_REALK,     -0.021977095450964_REALK, &
      0.000000000000000_REALK,     -0.079114543084598_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.014978263531897_REALK,      0.000000000000000_REALK, &
      0.019451066540041_REALK,      0.000000000000000_REALK,     -0.005499686487291_REALK, &
      0.000000000000000_REALK,     -0.035330020668911_REALK,      0.000000000000000_REALK, &
     -0.016015086911186_REALK,      0.000000000000000_REALK,     -0.051827028712241_REALK, &
      0.000000000000000_REALK,      0.049547017086642_REALK,      0.000000000000000_REALK, &
      0.033295730766626_REALK,      0.000000000000000_REALK,     -0.001425698768797_REALK, &
     -0.010581171576940_REALK,      0.000000000000000_REALK,     -0.031676344228547_REALK, &
      0.000000000000000_REALK,      0.021769423771957_REALK,      0.000000000000000_REALK, &
      0.002719773815934_REALK,      0.000000000000000_REALK,     -0.003668007719893_REALK, &
      0.000000000000000_REALK,     -0.023278679845614_REALK,      0.000000000000000_REALK, &
      0.040301097933169_REALK,      0.000000000000000_REALK,      0.020223193906789_REALK, &
      0.000000000000000_REALK,      0.030390326902961_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.007594823226263_REALK,      0.000000000000000_REALK, &
      0.012824658148965_REALK,      0.000000000000000_REALK,      0.011388045014351_REALK, &
      0.000000000000000_REALK,      0.004399721517557_REALK,      0.000000000000000_REALK, &
     -0.009712220768209_REALK,      0.000000000000000_REALK,      0.051568290032487_REALK, &
      0.000000000000000_REALK,     -0.018713703988104_REALK,      0.000000000000000_REALK, &
     -0.016245972239254_REALK,      0.000000000000000_REALK,     -0.010253459348217_REALK, &
     -0.004722121245931_REALK,      0.000000000000000_REALK,      0.026339879747069_REALK, &
      0.000000000000000_REALK,      0.000816350103478_REALK,      0.000000000000000_REALK, &
     -0.009272477582536_REALK,      0.000000000000000_REALK,     -0.004103643780442_REALK, &
      0.000000000000000_REALK,     -0.013225485650084_REALK,      0.000000000000000_REALK, &
     -0.068451276320790_REALK,      0.000000000000000_REALK,     -0.014251294895631_REALK, &
      0.000000000000000_REALK,     -0.021633892299303_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.021729996476807_REALK,      0.000000000000000_REALK, &
     -0.053614021991367_REALK,      0.000000000000000_REALK,     -0.003440903494817_REALK, &
      0.000000000000000_REALK,      0.004268853030523_REALK,      0.000000000000000_REALK, &
     -0.005018824687783_REALK,      0.000000000000000_REALK,      0.061352502396505_REALK, &
      0.000000000000000_REALK,     -0.071803555013410_REALK,      0.000000000000000_REALK, &
     -0.074421589395248_REALK,      0.000000000000000_REALK,     -0.031260595323209_REALK, &
     -0.013688645240119_REALK,      0.000000000000000_REALK,      0.026256009661537_REALK, &
      0.000000000000000_REALK,     -0.052558330201142_REALK,      0.000000000000000_REALK, &
     -0.064473440437667_REALK,      0.000000000000000_REALK,     -0.018242714456707_REALK, &
      0.000000000000000_REALK,      0.079478505895647_REALK,      0.000000000000000_REALK, &
      0.064649343066937_REALK,      0.000000000000000_REALK,      0.019254106804349_REALK, &
      0.000000000000000_REALK,      0.032467587886362_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.062193698451061_REALK,      0.000000000000000_REALK, &
      0.055282123054112_REALK,      0.000000000000000_REALK,      0.016384360062694_REALK, &
      0.000000000000000_REALK,     -0.004409140328881_REALK,      0.000000000000000_REALK, &
     -0.019059281993856_REALK,      0.000000000000000_REALK,      0.020618843018593_REALK, &
      0.000000000000000_REALK,      0.037199913782190_REALK,      0.000000000000000_REALK, &
      0.059632496130536_REALK,      0.000000000000000_REALK,      0.028253419408819_REALK, &
      0.010514499976104_REALK,      0.000000000000000_REALK,      0.004737509035936_REALK, &
      0.000000000000000_REALK,      0.042372366767260_REALK,      0.000000000000000_REALK, &
      0.065586375069694_REALK,      0.000000000000000_REALK,      0.018151926832428_REALK, &
      0.000000000000000_REALK,     -0.106438038129737_REALK,      0.000000000000000_REALK, &
     -0.055986060183310_REALK,      0.000000000000000_REALK,      0.012576683612797_REALK, &
      0.000000000000000_REALK,      0.009109536860539_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.073164864757354_REALK,      0.000000000000000_REALK, &
     -0.053925587818768_REALK,      0.000000000000000_REALK,      0.005050592505020_REALK, &
      0.000000000000000_REALK,     -0.011231094802353_REALK,      0.000000000000000_REALK, &
     -0.028067954734946_REALK,      0.000000000000000_REALK,      0.020008182496808_REALK, &
      0.000000000000000_REALK,     -0.024362485026597_REALK,      0.000000000000000_REALK, &
     -0.046488157506687_REALK,      0.000000000000000_REALK,     -0.124054063640415_REALK, &
     -0.014969869030101_REALK,      0.000000000000000_REALK,      0.009490170023091_REALK, &
      0.000000000000000_REALK,     -0.010364503489731_REALK,      0.000000000000000_REALK, &
     -0.019055489892435_REALK,      0.000000000000000_REALK,     -0.068527876826843_REALK/
  ! results of test 5, ket-major order, NEF 006
  data REF_CONTR_INTS(3169:3564)                                                           &
     /0.000000000000000_REALK,      0.020079286227347_REALK,      0.000000000000000_REALK, &
      0.008602676248214_REALK,      0.000000000000000_REALK,     -0.009216706012008_REALK, &
      0.000000000000000_REALK,      0.033665633814456_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.008472041248141_REALK,      0.000000000000000_REALK, &
      0.002787642961784_REALK,      0.000000000000000_REALK,     -0.001874372246466_REALK, &
      0.000000000000000_REALK,      0.013980024474312_REALK,      0.000000000000000_REALK, &
     -0.019855477372828_REALK,      0.000000000000000_REALK,      0.011313886258962_REALK, &
      0.000000000000000_REALK,     -0.008060304596115_REALK,      0.000000000000000_REALK, &
     -0.006877742359623_REALK,      0.000000000000000_REALK,     -0.027723993109493_REALK, &
     -0.013663878412450_REALK,      0.000000000000000_REALK,      0.008198510180810_REALK, &
      0.000000000000000_REALK,     -0.004123268944386_REALK,      0.000000000000000_REALK, &
     -0.007627732704539_REALK,      0.000000000000000_REALK,     -0.021817945304677_REALK, &
      0.000000000000000_REALK,     -0.008284866280692_REALK,      0.000000000000000_REALK, &
     -0.003645348620254_REALK,      0.000000000000000_REALK,     -0.003380119029218_REALK, &
      0.000000000000000_REALK,      0.006414729713366_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.013291834792842_REALK,      0.000000000000000_REALK, &
      0.000411735410857_REALK,      0.000000000000000_REALK,     -0.001850775637545_REALK, &
      0.000000000000000_REALK,      0.016889535846990_REALK,      0.000000000000000_REALK, &
     -0.010762765976607_REALK,      0.000000000000000_REALK,     -0.002808923456389_REALK, &
      0.000000000000000_REALK,      0.007452134305183_REALK,      0.000000000000000_REALK, &
     -0.000622413214566_REALK,      0.000000000000000_REALK,      0.010215437901597_REALK, &
     -0.002706393849800_REALK,      0.000000000000000_REALK,      0.010613005302998_REALK, &
      0.000000000000000_REALK,     -0.005740515263595_REALK,      0.000000000000000_REALK, &
      0.005420284617093_REALK,      0.000000000000000_REALK,      0.000437714253782_REALK, &
      0.000000000000000_REALK,      0.012400885136970_REALK,      0.000000000000000_REALK, &
     -0.001309566334715_REALK,      0.000000000000000_REALK,     -0.002314498314385_REALK, &
      0.000000000000000_REALK,     -0.000529989072312_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.011479152286595_REALK,      0.000000000000000_REALK, &
     -0.003103022053274_REALK,      0.000000000000000_REALK,     -0.009505581163709_REALK, &
      0.000000000000000_REALK,      0.005654175921322_REALK,      0.000000000000000_REALK, &
      0.002844433453356_REALK,      0.000000000000000_REALK,     -0.001886327305630_REALK, &
      0.000000000000000_REALK,     -0.002249366596238_REALK,      0.000000000000000_REALK, &
     -0.000487838497064_REALK,      0.000000000000000_REALK,     -0.005131480725765_REALK, &
     -0.002487939958761_REALK,      0.000000000000000_REALK,     -0.012698993383026_REALK, &
      0.000000000000000_REALK,      0.010542605550657_REALK,      0.000000000000000_REALK, &
     -0.003284190303403_REALK,      0.000000000000000_REALK,      0.004488351073982_REALK, &
      0.000000000000000_REALK,      0.012421248386371_REALK,      0.000000000000000_REALK, &
     -0.002314498314385_REALK,      0.000000000000000_REALK,     -0.002506708925797_REALK, &
      0.000000000000000_REALK,     -0.009051459934833_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.006894103053750_REALK,      0.000000000000000_REALK, &
     -0.009505581163709_REALK,      0.000000000000000_REALK,     -0.008019653875099_REALK, &
      0.000000000000000_REALK,     -0.011158484612991_REALK,      0.000000000000000_REALK, &
      0.013311394284658_REALK,      0.000000000000000_REALK,     -0.000622413214566_REALK, &
      0.000000000000000_REALK,      0.001927257262568_REALK,      0.000000000000000_REALK, &
     -0.000563202847080_REALK,      0.000000000000000_REALK,      0.011563436520037_REALK, &
      0.007074982017958_REALK,      0.000000000000000_REALK,      0.005420284617093_REALK, &
      0.000000000000000_REALK,     -0.001484601495299_REALK,      0.000000000000000_REALK, &
     -0.008943849513174_REALK,      0.000000000000000_REALK,      0.004422911826833_REALK, &
      0.000000000000000_REALK,      0.006414729713366_REALK,      0.000000000000000_REALK, &
     -0.000206193408882_REALK,      0.000000000000000_REALK,      0.002824513816138_REALK, &
      0.000000000000000_REALK,      0.003889875597691_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.016889535846989_REALK,      0.000000000000000_REALK, &
      0.003003053617923_REALK,      0.000000000000000_REALK,     -0.001667023802179_REALK, &
      0.000000000000000_REALK,      0.018763411269101_REALK,      0.000000000000000_REALK, &
     -0.027723993109493_REALK,      0.000000000000000_REALK,     -0.014806174916901_REALK, &
      0.000000000000000_REALK,      0.014541137402936_REALK,      0.000000000000000_REALK, &
     -0.009263449618795_REALK,      0.000000000000000_REALK,      0.014792103426114_REALK, &
     -0.021817945304677_REALK,      0.000000000000000_REALK,     -0.009217745851225_REALK, &
      0.000000000000000_REALK,      0.007438555150693_REALK,      0.000000000000000_REALK, &
     -0.007787303906333_REALK,      0.000000000000000_REALK,      0.013602721309503_REALK, &
      0.000000000000000_REALK,      0.028438383327597_REALK,      0.000000000000000_REALK, &
     -0.009552768810196_REALK,      0.000000000000000_REALK,     -0.009208948041817_REALK, &
      0.000000000000000_REALK,     -0.018727424324234_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.012540532710248_REALK,      0.000000000000000_REALK, &
      0.000485476268414_REALK,      0.000000000000000_REALK,      0.001469625618554_REALK, &
      0.000000000000000_REALK,     -0.008099762536689_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.043698016263876_REALK,      0.000000000000000_REALK, &
      0.001678347671683_REALK,      0.000000000000000_REALK,      0.008589239485879_REALK, &
      0.000000000000000_REALK,      0.065394450445917_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.018099361598945_REALK,      0.000000000000000_REALK, &
     -0.013693573600120_REALK,      0.000000000000000_REALK,      0.016889026533953_REALK, &
      0.000000000000000_REALK,      0.020474451852817_REALK,      0.000000000000000_REALK, &
     -0.011408663861458_REALK,      0.000000000000000_REALK,      0.071204810225437_REALK, &
      0.000000000000000_REALK,     -0.000785619947130_REALK,      0.000000000000000_REALK, &
     -0.108445703066609_REALK,      0.000000000000000_REALK,     -0.024783142162223_REALK, &
     -0.003750406015804_REALK,      0.000000000000000_REALK,      0.044507177943326_REALK, &
      0.000000000000000_REALK,      0.012370097252442_REALK,      0.000000000000000_REALK, &
     -0.075334738345697_REALK,      0.000000000000000_REALK,     -0.023573972500812_REALK, &
      0.000000000000000_REALK,     -0.015605062756303_REALK,      0.000000000000000_REALK, &
     -0.061015591079583_REALK,      0.000000000000000_REALK,     -0.042703616308171_REALK, &
      0.000000000000000_REALK,      0.018914029588264_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.021138466175197_REALK,      0.000000000000000_REALK, &
     -0.051226790367416_REALK,      0.000000000000000_REALK,     -0.038576045914080_REALK, &
      0.000000000000000_REALK,      0.034730124702520_REALK,      0.000000000000000_REALK, &
      0.001973605659968_REALK,      0.000000000000000_REALK,     -0.008733553162863_REALK, &
      0.000000000000000_REALK,      0.044473585964231_REALK,      0.000000000000000_REALK, &
     -0.014461725997506_REALK,      0.000000000000000_REALK,     -0.004443135758881_REALK, &
      0.006317782276230_REALK,      0.000000000000000_REALK,      0.032641847044714_REALK, &
      0.000000000000000_REALK,      0.008321672022130_REALK,      0.000000000000000_REALK, &
      0.011102264453286_REALK,      0.000000000000000_REALK,     -0.003570100716388_REALK, &
      0.000000000000000_REALK,      0.018857581400794_REALK,      0.000000000000000_REALK, &
      0.020445298840092_REALK,      0.000000000000000_REALK,      0.053081518594033_REALK, &
      0.000000000000000_REALK,      0.006064912035033_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.001645285825522_REALK,      0.000000000000000_REALK, &
      0.008936499990519_REALK,      0.000000000000000_REALK,      0.019752748656891_REALK, &
      0.000000000000000_REALK,      0.019780369524574_REALK,      0.000000000000000_REALK, &
     -0.006451875780125_REALK,      0.000000000000000_REALK,     -0.006828314125080_REALK, &
      0.000000000000000_REALK,     -0.038722333034117_REALK,      0.000000000000000_REALK, &
     -0.001765926035378_REALK,      0.000000000000000_REALK,      0.011639462393356_REALK, &
     -0.007070855379004_REALK,      0.000000000000000_REALK,     -0.033993276210483_REALK, &
      0.000000000000000_REALK,     -0.000344678947190_REALK,      0.000000000000000_REALK, &
     -0.008791278548156_REALK,      0.000000000000000_REALK,      0.012756128307105_REALK, &
      0.000000000000000_REALK,      0.013740644561357_REALK,      0.000000000000000_REALK, &
      0.053081518594034_REALK,      0.000000000000000_REALK,      0.047900988184645_REALK, &
      0.000000000000000_REALK,     -0.016872497577680_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.013224907879073_REALK,      0.000000000000000_REALK, &
      0.019752748656892_REALK,      0.000000000000000_REALK,      0.019153339018286_REALK, &
      0.000000000000000_REALK,     -0.010181049940108_REALK,      0.000000000000000_REALK, &
      0.002054403428432_REALK,      0.000000000000000_REALK,     -0.014461725997505_REALK, &
      0.000000000000000_REALK,      0.011501676973588_REALK,      0.000000000000000_REALK, &
      0.043445602675667_REALK,      0.000000000000000_REALK,     -0.000293224030391_REALK, &
     -0.012058184747347_REALK,      0.000000000000000_REALK,      0.011102264453286_REALK, &
      0.000000000000000_REALK,      0.002152135507032_REALK,      0.000000000000000_REALK, &
     -0.007416081529547_REALK,      0.000000000000000_REALK,     -0.008512954950798_REALK, &
      0.000000000000000_REALK,      0.018914029588264_REALK,      0.000000000000000_REALK, &
     -0.021966827470601_REALK,      0.000000000000000_REALK,      0.055652680904742_REALK, &
      0.000000000000000_REALK,      0.020292541415143_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.034730124702520_REALK,      0.000000000000000_REALK, &
     -0.014807747226178_REALK,      0.000000000000000_REALK,      0.045079876692861_REALK, &
      0.000000000000000_REALK,      0.044777063013233_REALK,      0.000000000000000_REALK, &
     -0.024783142162223_REALK,      0.000000000000000_REALK,     -0.055933239007824_REALK, &
      0.000000000000000_REALK,      0.001417292294785_REALK,      0.000000000000000_REALK, &
     -0.084785487060830_REALK,      0.000000000000000_REALK,      0.019563639339097_REALK, &
     -0.023573972500812_REALK,      0.000000000000000_REALK,     -0.030645489608704_REALK, &
      0.000000000000000_REALK,     -0.022316189381002_REALK,      0.000000000000000_REALK, &
     -0.056064629226400_REALK,      0.000000000000000_REALK,      0.025710758317492_REALK, &
      0.000000000000000_REALK,      0.080876982426479_REALK,      0.000000000000000_REALK, &
      0.031579625231847_REALK,      0.000000000000000_REALK,      0.039797300561236_REALK, &
      0.000000000000000_REALK,     -0.047702080197846_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.049446966802486_REALK,      0.000000000000000_REALK, &
      0.022347178601759_REALK,      0.000000000000000_REALK,      0.023540315523788_REALK, &
      0.000000000000000_REALK,     -0.025592180107701_REALK,      0.000000000000000_REALK/
  ! results of test 6, ket-major order, NEF 007
  data REF_CONTR_INTS(3565:3960)                                                           &
    /-0.024682241031687_REALK,      0.000000000000000_REALK,      0.000540279782671_REALK, &
      0.000000000000000_REALK,      0.000085112586891_REALK,      0.000000000000000_REALK, &
      0.004501172074531_REALK,      0.000000000000000_REALK,     -0.006114926019135_REALK, &
     -0.010654319301512_REALK,      0.000000000000000_REALK,      0.001756879754186_REALK, &
      0.000000000000000_REALK,      0.001564956657320_REALK,      0.000000000000000_REALK, &
     -0.005063428828588_REALK,      0.000000000000000_REALK,      0.004591579821745_REALK, &
      0.000000000000000_REALK,      0.002236992950580_REALK,      0.000000000000000_REALK, &
      0.005014044156470_REALK,      0.000000000000000_REALK,     -0.005459584255155_REALK, &
      0.000000000000000_REALK,      0.020874694622705_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.001552521802117_REALK,      0.000000000000000_REALK, &
      0.000174773719262_REALK,      0.000000000000000_REALK,     -0.000949134295786_REALK, &
      0.000000000000000_REALK,      0.009912863302731_REALK,      0.000000000000000_REALK, &
      0.000037279217371_REALK,      0.000000000000000_REALK,      0.010728353401801_REALK, &
      0.000000000000000_REALK,     -0.005737869556105_REALK,      0.000000000000000_REALK, &
     -0.002930169767916_REALK,      0.000000000000000_REALK,      0.006796472776213_REALK, &
     -0.004466710281753_REALK,      0.000000000000000_REALK,      0.007318852087836_REALK, &
      0.000000000000000_REALK,      0.003859612125650_REALK,      0.000000000000000_REALK, &
     -0.010622001656815_REALK,      0.000000000000000_REALK,      0.003383489793816_REALK, &
      0.000000000000000_REALK,      0.011519834538114_REALK,      0.000000000000000_REALK, &
     -0.008338585343168_REALK,      0.000000000000000_REALK,     -0.015202565286274_REALK, &
      0.000000000000000_REALK,      0.001298599878299_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.001469268260803_REALK,      0.000000000000000_REALK, &
     -0.002264192707081_REALK,      0.000000000000000_REALK,     -0.003458220123043_REALK, &
      0.000000000000000_REALK,      0.000545494262235_REALK,      0.000000000000000_REALK, &
      0.001389429880586_REALK,      0.000000000000000_REALK,     -0.008158623828815_REALK, &
      0.000000000000000_REALK,      0.010996113382762_REALK,      0.000000000000000_REALK, &
     -0.009153414805289_REALK,      0.000000000000000_REALK,      0.003805574059808_REALK, &
     -0.003549243903355_REALK,      0.000000000000000_REALK,     -0.002589626463252_REALK, &
      0.000000000000000_REALK,      0.012708259519008_REALK,      0.000000000000000_REALK, &
     -0.014611828264243_REALK,      0.000000000000000_REALK,      0.005575801628906_REALK, &
      0.000000000000000_REALK,     -0.006245698213451_REALK,      0.000000000000000_REALK, &
      0.007559486998175_REALK,      0.000000000000000_REALK,      0.012874553737116_REALK, &
      0.000000000000000_REALK,     -0.001076364957124_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.003914716735266_REALK,      0.000000000000000_REALK, &
      0.003515319493191_REALK,      0.000000000000000_REALK,      0.012017174784765_REALK, &
      0.000000000000000_REALK,     -0.007522157047602_REALK,      0.000000000000000_REALK, &
     -0.000585754853638_REALK,      0.000000000000000_REALK,     -0.011070617171975_REALK, &
      0.000000000000000_REALK,      0.010992155447986_REALK,      0.000000000000000_REALK, &
     -0.002134582166488_REALK,      0.000000000000000_REALK,      0.000934733897934_REALK, &
     -0.000452986456627_REALK,      0.000000000000000_REALK,     -0.004326233601438_REALK, &
      0.000000000000000_REALK,      0.005046333644701_REALK,      0.000000000000000_REALK, &
      0.002334897331389_REALK,      0.000000000000000_REALK,     -0.000101879594595_REALK, &
      0.000000000000000_REALK,     -0.002218846830373_REALK,      0.000000000000000_REALK, &
     -0.004765512919896_REALK,      0.000000000000000_REALK,      0.003692954648224_REALK, &
      0.000000000000000_REALK,     -0.011907144155002_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.000225662550914_REALK,      0.000000000000000_REALK, &
     -0.003985535871505_REALK,      0.000000000000000_REALK,      0.011536555884373_REALK, &
      0.000000000000000_REALK,     -0.011060910226311_REALK,      0.000000000000000_REALK, &
      0.007423723193165_REALK,      0.000000000000000_REALK,     -0.004137420940412_REALK, &
      0.000000000000000_REALK,      0.006555454762903_REALK,      0.000000000000000_REALK, &
     -0.012896992347687_REALK,      0.000000000000000_REALK,      0.004214087081463_REALK, &
     -0.002878888296636_REALK,      0.000000000000000_REALK,     -0.002335556205465_REALK, &
      0.000000000000000_REALK,      0.000823815221764_REALK,      0.000000000000000_REALK, &
     -0.008117811687442_REALK,      0.000000000000000_REALK,     -0.004011749855194_REALK, &
      0.000000000000000_REALK,      0.017346834938640_REALK,      0.000000000000000_REALK, &
     -0.002894240648540_REALK,      0.000000000000000_REALK,     -0.007144254369691_REALK, &
      0.000000000000000_REALK,      0.001237090408245_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.010107183375477_REALK,      0.000000000000000_REALK, &
      0.002430490019916_REALK,      0.000000000000000_REALK,      0.009520219863268_REALK, &
      0.000000000000000_REALK,     -0.007849045296346_REALK,      0.000000000000000_REALK, &
     -0.004307758237989_REALK,      0.000000000000000_REALK,      0.001365307994717_REALK, &
      0.000000000000000_REALK,      0.003764858068315_REALK,      0.000000000000000_REALK, &
     -0.004312680773073_REALK,      0.000000000000000_REALK,      0.026588639612173_REALK, &
     -0.001823330906701_REALK,      0.000000000000000_REALK,     -0.001553509490799_REALK, &
      0.000000000000000_REALK,     -0.001092876600515_REALK,      0.000000000000000_REALK, &
      0.004164276949295_REALK,      0.000000000000000_REALK,      0.004522482166274_REALK, &
     -0.017353613057678_REALK,      0.000000000000000_REALK,      0.003017859860469_REALK, &
      0.000000000000000_REALK,      0.003138012279541_REALK,      0.000000000000000_REALK, &
     -0.009116200158718_REALK,      0.000000000000000_REALK,     -0.003980693881323_REALK, &
     -0.027735599427123_REALK,      0.000000000000000_REALK,      0.008698857139212_REALK, &
      0.000000000000000_REALK,      0.002448250103720_REALK,      0.000000000000000_REALK, &
     -0.014769085738059_REALK,      0.000000000000000_REALK,     -0.001936116710915_REALK, &
      0.000000000000000_REALK,     -0.004681305402372_REALK,      0.000000000000000_REALK, &
      0.001290046513807_REALK,      0.000000000000000_REALK,     -0.013512540896549_REALK, &
      0.000000000000000_REALK,      0.031305462824204_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.008692069189891_REALK,      0.000000000000000_REALK, &
     -0.008041770726680_REALK,      0.000000000000000_REALK,      0.002120622794681_REALK, &
      0.000000000000000_REALK,      0.013011350407545_REALK,      0.000000000000000_REALK, &
     -0.004924018410774_REALK,      0.000000000000000_REALK,      0.017300531671074_REALK, &
      0.000000000000000_REALK,     -0.001208890296481_REALK,      0.000000000000000_REALK, &
     -0.007634141020470_REALK,      0.000000000000000_REALK,      0.002248129864071_REALK, &
     -0.015373529258020_REALK,      0.000000000000000_REALK,      0.024181591677949_REALK, &
      0.000000000000000_REALK,      0.019878965007980_REALK,      0.000000000000000_REALK, &
     -0.025515666388723_REALK,      0.000000000000000_REALK,     -0.001954491742224_REALK, &
      0.000000000000000_REALK,     -0.000577119501093_REALK,      0.000000000000000_REALK, &
     -0.004184784088959_REALK,      0.000000000000000_REALK,     -0.015854370716838_REALK, &
      0.000000000000000_REALK,      0.007742761361156_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.009171700249210_REALK,      0.000000000000000_REALK, &
     -0.004204895110998_REALK,      0.000000000000000_REALK,     -0.010466846439891_REALK, &
      0.000000000000000_REALK,     -0.000702318897671_REALK,      0.000000000000000_REALK, &
     -0.006552652830732_REALK,      0.000000000000000_REALK,     -0.003372388620927_REALK, &
      0.000000000000000_REALK,      0.016873457202686_REALK,      0.000000000000000_REALK, &
     -0.018432043414613_REALK,      0.000000000000000_REALK,      0.003343979039486_REALK, &
     -0.012567687870830_REALK,      0.000000000000000_REALK,      0.011995428762343_REALK, &
      0.000000000000000_REALK,      0.027062913189581_REALK,      0.000000000000000_REALK, &
     -0.034450600728040_REALK,      0.000000000000000_REALK,      0.003242429582025_REALK, &
      0.000000000000000_REALK,      0.007383535664171_REALK,      0.000000000000000_REALK, &
      0.006618171552054_REALK,      0.000000000000000_REALK,      0.017086552819050_REALK, &
      0.000000000000000_REALK,     -0.007367760240875_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.020619599554955_REALK,      0.000000000000000_REALK, &
      0.005958091892169_REALK,      0.000000000000000_REALK,      0.030031962622830_REALK, &
      0.000000000000000_REALK,     -0.014165919486501_REALK,      0.000000000000000_REALK, &
     -0.001550880112620_REALK,      0.000000000000000_REALK,     -0.010866829555986_REALK, &
      0.000000000000000_REALK,      0.015113064599399_REALK,      0.000000000000000_REALK, &
     -0.001233947651324_REALK,      0.000000000000000_REALK,      0.003782762135806_REALK, &
      0.002525593076025_REALK,      0.000000000000000_REALK,     -0.000825201273264_REALK, &
      0.000000000000000_REALK,      0.007948005460730_REALK,      0.000000000000000_REALK, &
      0.008713905462391_REALK,      0.000000000000000_REALK,     -0.004022022581912_REALK, &
      0.000000000000000_REALK,      0.000431725419289_REALK,      0.000000000000000_REALK, &
     -0.009744566191055_REALK,      0.000000000000000_REALK,      0.010954085573695_REALK, &
      0.000000000000000_REALK,     -0.014687128425552_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.013494918088604_REALK,      0.000000000000000_REALK, &
     -0.017164628038146_REALK,      0.000000000000000_REALK,      0.029216865424657_REALK, &
      0.000000000000000_REALK,     -0.011064872939167_REALK,      0.000000000000000_REALK, &
     -0.004930982288511_REALK,      0.000000000000000_REALK,      0.000007962661778_REALK, &
      0.000000000000000_REALK,      0.007956074255459_REALK,      0.000000000000000_REALK, &
     -0.026759569637810_REALK,      0.000000000000000_REALK,      0.001080346495607_REALK, &
     -0.005941983817484_REALK,      0.000000000000000_REALK,     -0.000283583878840_REALK, &
      0.000000000000000_REALK,     -0.002924526001687_REALK,      0.000000000000000_REALK, &
     -0.026219017911203_REALK,      0.000000000000000_REALK,     -0.012882809264017_REALK, &
      0.000000000000000_REALK,      0.023259352767225_REALK,      0.000000000000000_REALK, &
      0.004211521394550_REALK,      0.000000000000000_REALK,      0.007231048769108_REALK, &
      0.000000000000000_REALK,      0.003206155072921_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.032320999626203_REALK,      0.000000000000000_REALK, &
      0.002899959297636_REALK,      0.000000000000000_REALK,      0.031538758760055_REALK, &
      0.000000000000000_REALK,     -0.018935561866994_REALK,      0.000000000000000_REALK, &
     -0.015946176228381_REALK,      0.000000000000000_REALK,     -0.001586702001480_REALK, &
      0.000000000000000_REALK,      0.006465997351302_REALK,      0.000000000000000_REALK, &
     -0.005033541092597_REALK,      0.000000000000000_REALK,      0.026180816456432_REALK, &
     -0.000390375739678_REALK,      0.000000000000000_REALK,     -0.005241155764266_REALK, &
      0.000000000000000_REALK,     -0.007818681861069_REALK,      0.000000000000000_REALK, &
      0.010203686470370_REALK,      0.000000000000000_REALK,     -0.001852064144126_REALK/
  ! results of test 6, ket-major order, NEF 008
  data REF_CONTR_INTS(3961:4356)                                                           &
     /0.005454930528571_REALK,      0.000000000000000_REALK,      0.000512605428621_REALK, &
      0.000000000000000_REALK,     -0.000149774211603_REALK,      0.000000000000000_REALK, &
     -0.001262958628970_REALK,      0.000000000000000_REALK,      0.002095580345187_REALK, &
      0.001359029421645_REALK,      0.000000000000000_REALK,     -0.000431669506137_REALK, &
      0.000000000000000_REALK,      0.001432677288963_REALK,      0.000000000000000_REALK, &
     -0.000645995901692_REALK,      0.000000000000000_REALK,      0.003685811068859_REALK, &
      0.000000000000000_REALK,      0.000174284003348_REALK,      0.000000000000000_REALK, &
     -0.001897774925222_REALK,      0.000000000000000_REALK,     -0.000506460115126_REALK, &
      0.000000000000000_REALK,     -0.004346592371887_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000957336908720_REALK,      0.000000000000000_REALK, &
      0.000513556564592_REALK,      0.000000000000000_REALK,     -0.000309107728120_REALK, &
      0.000000000000000_REALK,     -0.001281885658327_REALK,      0.000000000000000_REALK, &
     -0.000427982249091_REALK,      0.000000000000000_REALK,     -0.002914173672806_REALK, &
      0.000000000000000_REALK,      0.002168203287251_REALK,      0.000000000000000_REALK, &
      0.000197163390408_REALK,      0.000000000000000_REALK,     -0.000855834366090_REALK, &
      0.000663914207662_REALK,      0.000000000000000_REALK,     -0.002234021692072_REALK, &
      0.000000000000000_REALK,      0.001187884695201_REALK,      0.000000000000000_REALK, &
     -0.000774370915534_REALK,      0.000000000000000_REALK,      0.001912959981677_REALK, &
      0.000000000000000_REALK,     -0.002191857445851_REALK,      0.000000000000000_REALK, &
      0.002038949945354_REALK,      0.000000000000000_REALK,      0.002656080447537_REALK, &
      0.000000000000000_REALK,      0.000918766257906_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.001064344676392_REALK,      0.000000000000000_REALK, &
      0.000237781226497_REALK,      0.000000000000000_REALK,      0.000112630165759_REALK, &
      0.000000000000000_REALK,      0.000359871226470_REALK,      0.000000000000000_REALK, &
     -0.000147501614312_REALK,      0.000000000000000_REALK,      0.001830184132388_REALK, &
      0.000000000000000_REALK,     -0.001699727964843_REALK,      0.000000000000000_REALK, &
      0.000766602748358_REALK,      0.000000000000000_REALK,      0.000039195231331_REALK, &
     -0.000130234458650_REALK,      0.000000000000000_REALK,     -0.000083413801318_REALK, &
      0.000000000000000_REALK,     -0.000404868015667_REALK,      0.000000000000000_REALK, &
      0.000492057018899_REALK,      0.000000000000000_REALK,      0.000704253352953_REALK, &
      0.000000000000000_REALK,      0.000948661484298_REALK,      0.000000000000000_REALK, &
     -0.002117050113830_REALK,      0.000000000000000_REALK,     -0.002098275432480_REALK, &
      0.000000000000000_REALK,     -0.001113816027076_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.001457017190485_REALK,      0.000000000000000_REALK, &
     -0.001170885031053_REALK,      0.000000000000000_REALK,     -0.000789675231234_REALK, &
      0.000000000000000_REALK,     -0.000043382851288_REALK,      0.000000000000000_REALK, &
      0.000572815467132_REALK,      0.000000000000000_REALK,      0.002951749519397_REALK, &
      0.000000000000000_REALK,     -0.002725792134232_REALK,      0.000000000000000_REALK, &
     -0.000436812651196_REALK,      0.000000000000000_REALK,     -0.000103066023052_REALK, &
      0.000075186896652_REALK,      0.000000000000000_REALK,      0.000458279695103_REALK, &
      0.000000000000000_REALK,     -0.000958791235570_REALK,      0.000000000000000_REALK, &
     -0.001707370248764_REALK,      0.000000000000000_REALK,      0.000082229901740_REALK, &
      0.000000000000000_REALK,      0.000564823074182_REALK,      0.000000000000000_REALK, &
      0.001837018975583_REALK,      0.000000000000000_REALK,      0.000556129699392_REALK, &
      0.000000000000000_REALK,      0.002341582998821_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000150061269914_REALK,      0.000000000000000_REALK, &
      0.001737464899212_REALK,      0.000000000000000_REALK,      0.000633978030899_REALK, &
      0.000000000000000_REALK,     -0.000876288239978_REALK,      0.000000000000000_REALK, &
     -0.001684003895925_REALK,      0.000000000000000_REALK,      0.000266887241075_REALK, &
      0.000000000000000_REALK,     -0.000256082590607_REALK,      0.000000000000000_REALK, &
      0.002278885419565_REALK,      0.000000000000000_REALK,      0.000099644118843_REALK, &
      0.000877480033242_REALK,      0.000000000000000_REALK,     -0.000600793835122_REALK, &
      0.000000000000000_REALK,      0.001179691316535_REALK,      0.000000000000000_REALK, &
      0.002304539997869_REALK,      0.000000000000000_REALK,      0.001089899600670_REALK, &
      0.000000000000000_REALK,     -0.004038408433155_REALK,      0.000000000000000_REALK, &
      0.000049528242109_REALK,      0.000000000000000_REALK,      0.001627826305502_REALK, &
      0.000000000000000_REALK,     -0.000907454899693_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.003306004981416_REALK,      0.000000000000000_REALK, &
     -0.001182479977371_REALK,      0.000000000000000_REALK,      0.000614079251669_REALK, &
      0.000000000000000_REALK,     -0.002152760441514_REALK,      0.000000000000000_REALK, &
      0.002061291554777_REALK,      0.000000000000000_REALK,     -0.000235613127800_REALK, &
      0.000000000000000_REALK,     -0.000380700716844_REALK,      0.000000000000000_REALK, &
     -0.000565608438047_REALK,      0.000000000000000_REALK,     -0.004696962928372_REALK, &
      0.000075043401367_REALK,      0.000000000000000_REALK,      0.000862771655675_REALK, &
      0.000000000000000_REALK,     -0.001051828293821_REALK,      0.000000000000000_REALK, &
      0.000731144786011_REALK,      0.000000000000000_REALK,     -0.002523998022632_REALK, &
      0.003006167909087_REALK,      0.000000000000000_REALK,      0.000810364911822_REALK, &
      0.000000000000000_REALK,      0.000971323101269_REALK,      0.000000000000000_REALK, &
     -0.000086780633840_REALK,      0.000000000000000_REALK,      0.000994029109651_REALK, &
     -0.005031085281273_REALK,      0.000000000000000_REALK,      0.002393257936704_REALK, &
      0.000000000000000_REALK,      0.003150552419745_REALK,      0.000000000000000_REALK, &
      0.000192345128669_REALK,      0.000000000000000_REALK,      0.003403894885509_REALK, &
      0.000000000000000_REALK,     -0.002933098301186_REALK,      0.000000000000000_REALK, &
     -0.000186309310767_REALK,      0.000000000000000_REALK,     -0.001167504702573_REALK, &
      0.000000000000000_REALK,     -0.003896399907971_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000692722798119_REALK,      0.000000000000000_REALK, &
      0.003638343762126_REALK,      0.000000000000000_REALK,      0.001557483594080_REALK, &
      0.000000000000000_REALK,     -0.003112357711459_REALK,      0.000000000000000_REALK, &
     -0.001324497926020_REALK,      0.000000000000000_REALK,     -0.002468824622756_REALK, &
      0.000000000000000_REALK,      0.002802306586010_REALK,      0.000000000000000_REALK, &
      0.000232203900982_REALK,      0.000000000000000_REALK,     -0.000048682659296_REALK, &
     -0.004031684809334_REALK,      0.000000000000000_REALK,     -0.000301503622451_REALK, &
      0.000000000000000_REALK,      0.004229446125143_REALK,      0.000000000000000_REALK, &
     -0.005383495928338_REALK,      0.000000000000000_REALK,      0.002036430376467_REALK, &
      0.000000000000000_REALK,     -0.001932345979347_REALK,      0.000000000000000_REALK, &
      0.001826269678082_REALK,      0.000000000000000_REALK,      0.000901136747093_REALK, &
      0.000000000000000_REALK,      0.000807598871284_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000719690764541_REALK,      0.000000000000000_REALK, &
      0.000878693435353_REALK,      0.000000000000000_REALK,      0.002033913779305_REALK, &
      0.000000000000000_REALK,     -0.000681909607570_REALK,      0.000000000000000_REALK, &
     -0.001106783917411_REALK,      0.000000000000000_REALK,      0.003236184666754_REALK, &
      0.000000000000000_REALK,     -0.000335309309285_REALK,      0.000000000000000_REALK, &
     -0.000743368228444_REALK,      0.000000000000000_REALK,     -0.000588429193209_REALK, &
     -0.004576287784624_REALK,      0.000000000000000_REALK,      0.003477187758696_REALK, &
      0.000000000000000_REALK,      0.005087358038824_REALK,      0.000000000000000_REALK, &
     -0.005110419923842_REALK,      0.000000000000000_REALK,      0.001086120333815_REALK, &
      0.000000000000000_REALK,      0.000446050964732_REALK,      0.000000000000000_REALK, &
     -0.003067875404523_REALK,      0.000000000000000_REALK,     -0.000309164046524_REALK, &
      0.000000000000000_REALK,     -0.000852398507615_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.001188243587797_REALK,      0.000000000000000_REALK, &
     -0.005000128390610_REALK,      0.000000000000000_REALK,      0.003030385187061_REALK, &
      0.000000000000000_REALK,     -0.000968567285057_REALK,      0.000000000000000_REALK, &
     -0.000323816828315_REALK,      0.000000000000000_REALK,      0.003431337304546_REALK, &
      0.000000000000000_REALK,     -0.003039612648850_REALK,      0.000000000000000_REALK, &
     -0.002595669637844_REALK,      0.000000000000000_REALK,     -0.001261212113278_REALK, &
     -0.000196448803530_REALK,      0.000000000000000_REALK,     -0.000545031649227_REALK, &
      0.000000000000000_REALK,     -0.002407353173988_REALK,      0.000000000000000_REALK, &
     -0.004422812513605_REALK,      0.000000000000000_REALK,     -0.000350139281710_REALK, &
      0.000000000000000_REALK,      0.003748012797208_REALK,      0.000000000000000_REALK, &
      0.002114353250187_REALK,      0.000000000000000_REALK,      0.001692007445995_REALK, &
      0.000000000000000_REALK,      0.001224063446687_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.006585155737529_REALK,      0.000000000000000_REALK, &
      0.002525035114294_REALK,      0.000000000000000_REALK,      0.006533089335025_REALK, &
      0.000000000000000_REALK,     -0.006213671773316_REALK,      0.000000000000000_REALK, &
     -0.001252279365377_REALK,      0.000000000000000_REALK,      0.001347892645552_REALK, &
      0.000000000000000_REALK,      0.001545744642821_REALK,      0.000000000000000_REALK, &
      0.002754788547480_REALK,      0.000000000000000_REALK,      0.000503163411168_REALK, &
      0.003454056168800_REALK,      0.000000000000000_REALK,     -0.000367471173823_REALK, &
      0.000000000000000_REALK,      0.002343797562867_REALK,      0.000000000000000_REALK, &
      0.007559022090035_REALK,      0.000000000000000_REALK,     -0.001503830869779_REALK, &
      0.000000000000000_REALK,     -0.004762177601172_REALK,      0.000000000000000_REALK, &
     -0.002364794626148_REALK,      0.000000000000000_REALK,      0.001055135574812_REALK, &
      0.000000000000000_REALK,     -0.001064787522927_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.001521175412489_REALK,      0.000000000000000_REALK, &
     -0.004204337267243_REALK,      0.000000000000000_REALK,      0.004779131302666_REALK, &
      0.000000000000000_REALK,     -0.004557044144863_REALK,      0.000000000000000_REALK, &
     -0.001513114928632_REALK,      0.000000000000000_REALK,      0.001653015630159_REALK, &
      0.000000000000000_REALK,     -0.000533910452429_REALK,      0.000000000000000_REALK, &
     -0.001720230906915_REALK,      0.000000000000000_REALK,     -0.005477003263556_REALK, &
      0.000116969334984_REALK,      0.000000000000000_REALK,     -0.000074944939362_REALK, &
      0.000000000000000_REALK,     -0.003308090559428_REALK,      0.000000000000000_REALK, &
      0.005155159518172_REALK,      0.000000000000000_REALK,     -0.009422167201409_REALK/
  ! results of test 6, ket-major order, NEF 009
  data REF_CONTR_INTS(4357:4752)                                                           &
     /0.000000000000000_REALK,      0.001492598316003_REALK,      0.000000000000000_REALK, &
      0.000174760767276_REALK,      0.000000000000000_REALK,     -0.000665637509267_REALK, &
      0.000000000000000_REALK,      0.001715518158971_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000897141664356_REALK,      0.000000000000000_REALK, &
     -0.000172799383929_REALK,      0.000000000000000_REALK,      0.000534947405313_REALK, &
      0.000000000000000_REALK,     -0.000129475502791_REALK,      0.000000000000000_REALK, &
     -0.002432029965830_REALK,      0.000000000000000_REALK,      0.000622819111724_REALK, &
      0.000000000000000_REALK,     -0.000213216190196_REALK,      0.000000000000000_REALK, &
     -0.000396250861707_REALK,      0.000000000000000_REALK,     -0.002911436204385_REALK, &
     -0.000563349522650_REALK,      0.000000000000000_REALK,      0.000251989221086_REALK, &
      0.000000000000000_REALK,      0.001424355119442_REALK,      0.000000000000000_REALK, &
     -0.003415827173049_REALK,      0.000000000000000_REALK,      0.001573885944995_REALK, &
      0.000000000000000_REALK,     -0.001161417859989_REALK,      0.000000000000000_REALK, &
      0.000294444924859_REALK,      0.000000000000000_REALK,      0.000044126881074_REALK, &
      0.000000000000000_REALK,      0.001527341902360_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000319868306326_REALK,      0.000000000000000_REALK, &
     -0.000628560582054_REALK,      0.000000000000000_REALK,     -0.003552372310966_REALK, &
      0.000000000000000_REALK,      0.006239113733394_REALK,      0.000000000000000_REALK, &
     -0.001169329675883_REALK,      0.000000000000000_REALK,      0.000821787686651_REALK, &
      0.000000000000000_REALK,     -0.000371519200383_REALK,      0.000000000000000_REALK, &
      0.000432249404930_REALK,      0.000000000000000_REALK,      0.000091925379422_REALK, &
      0.001125717690557_REALK,      0.000000000000000_REALK,      0.002544036301201_REALK, &
      0.000000000000000_REALK,     -0.000459262807735_REALK,      0.000000000000000_REALK, &
     -0.000816155251388_REALK,      0.000000000000000_REALK,      0.001631209344373_REALK, &
      0.000000000000000_REALK,      0.002091100535964_REALK,      0.000000000000000_REALK, &
     -0.000645230552458_REALK,      0.000000000000000_REALK,     -0.001497335406832_REALK, &
      0.000000000000000_REALK,      0.000754842803053_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.001364154796061_REALK,      0.000000000000000_REALK, &
     -0.000791424673098_REALK,      0.000000000000000_REALK,     -0.005865356757968_REALK, &
      0.000000000000000_REALK,      0.006086847585222_REALK,      0.000000000000000_REALK, &
      0.000499335668229_REALK,      0.000000000000000_REALK,     -0.001046237379825_REALK, &
      0.000000000000000_REALK,      0.000825942350609_REALK,      0.000000000000000_REALK, &
     -0.000655054975492_REALK,      0.000000000000000_REALK,      0.000519078793766_REALK, &
     -0.000544986139170_REALK,      0.000000000000000_REALK,     -0.003035890042053_REALK, &
      0.000000000000000_REALK,      0.004801583291793_REALK,      0.000000000000000_REALK, &
     -0.004402535622330_REALK,      0.000000000000000_REALK,      0.003995597542425_REALK, &
      0.000000000000000_REALK,      0.001666430497060_REALK,      0.000000000000000_REALK, &
     -0.000859952857261_REALK,      0.000000000000000_REALK,     -0.001048605058414_REALK, &
      0.000000000000000_REALK,     -0.000773820116048_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.000732888716533_REALK,      0.000000000000000_REALK, &
     -0.000960927097915_REALK,      0.000000000000000_REALK,      0.000172762927088_REALK, &
      0.000000000000000_REALK,     -0.000992094660244_REALK,      0.000000000000000_REALK, &
      0.001222193901746_REALK,      0.000000000000000_REALK,      0.000032649700754_REALK, &
      0.000000000000000_REALK,      0.000238580612036_REALK,      0.000000000000000_REALK, &
     -0.000769724484696_REALK,      0.000000000000000_REALK,      0.001575540419740_REALK, &
     -0.001253921277499_REALK,      0.000000000000000_REALK,     -0.000333308186568_REALK, &
      0.000000000000000_REALK,      0.002704410252029_REALK,      0.000000000000000_REALK, &
     -0.005920837472545_REALK,      0.000000000000000_REALK,      0.003541211963075_REALK, &
      0.000000000000000_REALK,      0.001923348532384_REALK,      0.000000000000000_REALK, &
     -0.000186297476952_REALK,      0.000000000000000_REALK,     -0.000622069643843_REALK, &
      0.000000000000000_REALK,      0.001207960513174_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.002596514016112_REALK,      0.000000000000000_REALK, &
      0.000760916751180_REALK,      0.000000000000000_REALK,      0.001693593768178_REALK, &
      0.000000000000000_REALK,      0.001143873142519_REALK,      0.000000000000000_REALK, &
     -0.002321163619694_REALK,      0.000000000000000_REALK,     -0.000990387968059_REALK, &
      0.000000000000000_REALK,      0.001119540373893_REALK,      0.000000000000000_REALK, &
     -0.000906297550537_REALK,      0.000000000000000_REALK,      0.001933386997061_REALK, &
     -0.002231071444785_REALK,      0.000000000000000_REALK,     -0.000572755387024_REALK, &
      0.000000000000000_REALK,     -0.000032674302225_REALK,      0.000000000000000_REALK, &
     -0.000436223757679_REALK,      0.000000000000000_REALK,      0.003797980061785_REALK, &
      0.000000000000000_REALK,      0.001209216555021_REALK,      0.000000000000000_REALK, &
     -0.000275955087468_REALK,      0.000000000000000_REALK,      0.000508779660561_REALK, &
      0.000000000000000_REALK,     -0.001746162110478_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000409761960514_REALK,      0.000000000000000_REALK, &
      0.000259748744534_REALK,      0.000000000000000_REALK,     -0.000127465809802_REALK, &
      0.000000000000000_REALK,     -0.000211281700865_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.001799422815071_REALK,      0.000000000000000_REALK, &
     -0.000342018319242_REALK,      0.000000000000000_REALK,      0.000657310269791_REALK, &
      0.000000000000000_REALK,      0.003031074058722_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.004057009179143_REALK,      0.000000000000000_REALK, &
     -0.002584841218745_REALK,      0.000000000000000_REALK,      0.003931675239297_REALK, &
      0.000000000000000_REALK,     -0.000711928507412_REALK,      0.000000000000000_REALK, &
     -0.000422791932563_REALK,      0.000000000000000_REALK,      0.003694242962087_REALK, &
      0.000000000000000_REALK,      0.001719398096170_REALK,      0.000000000000000_REALK, &
     -0.005757117203017_REALK,      0.000000000000000_REALK,     -0.003182530675216_REALK, &
     -0.001681041952801_REALK,      0.000000000000000_REALK,      0.004678990792986_REALK, &
      0.000000000000000_REALK,      0.005529772062104_REALK,      0.000000000000000_REALK, &
     -0.011714865882134_REALK,      0.000000000000000_REALK,      0.004848963542140_REALK, &
      0.000000000000000_REALK,     -0.001415357392724_REALK,      0.000000000000000_REALK, &
     -0.002377849193902_REALK,      0.000000000000000_REALK,     -0.002296709711141_REALK, &
      0.000000000000000_REALK,      0.002307801992302_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.003174518981157_REALK,      0.000000000000000_REALK, &
     -0.005120654413061_REALK,      0.000000000000000_REALK,     -0.008097441982084_REALK, &
      0.000000000000000_REALK,      0.013339673297263_REALK,      0.000000000000000_REALK, &
      0.000329085754586_REALK,      0.000000000000000_REALK,      0.001271399639443_REALK, &
      0.000000000000000_REALK,      0.001448167439603_REALK,      0.000000000000000_REALK, &
     -0.000621891495353_REALK,      0.000000000000000_REALK,     -0.000898295553734_REALK, &
      0.000723913579257_REALK,      0.000000000000000_REALK,      0.007505614038640_REALK, &
      0.000000000000000_REALK,      0.002129965692197_REALK,      0.000000000000000_REALK, &
     -0.001180471139692_REALK,      0.000000000000000_REALK,      0.005677365462384_REALK, &
      0.000000000000000_REALK,      0.001538574651180_REALK,      0.000000000000000_REALK, &
      0.000281290305202_REALK,      0.000000000000000_REALK,      0.001574537516538_REALK, &
      0.000000000000000_REALK,      0.002283206453442_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.004974576283975_REALK,      0.000000000000000_REALK, &
     -0.000255110576732_REALK,      0.000000000000000_REALK,     -0.007903879961048_REALK, &
      0.000000000000000_REALK,      0.013081188473254_REALK,      0.000000000000000_REALK, &
     -0.000992588987631_REALK,      0.000000000000000_REALK,     -0.001687288010518_REALK, &
      0.000000000000000_REALK,     -0.000618121486251_REALK,      0.000000000000000_REALK, &
     -0.000455459923977_REALK,      0.000000000000000_REALK,      0.001484098421177_REALK, &
     -0.004902645524396_REALK,      0.000000000000000_REALK,     -0.004730739609362_REALK, &
      0.000000000000000_REALK,      0.007543500472808_REALK,      0.000000000000000_REALK, &
     -0.010263465960212_REALK,      0.000000000000000_REALK,      0.006469099534201_REALK, &
      0.000000000000000_REALK,      0.001079042524602_REALK,      0.000000000000000_REALK, &
      0.001187259040048_REALK,      0.000000000000000_REALK,      0.001819689449767_REALK, &
      0.000000000000000_REALK,     -0.000415353502620_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.003396279593322_REALK,      0.000000000000000_REALK, &
     -0.000723570585499_REALK,      0.000000000000000_REALK,      0.002155052436263_REALK, &
      0.000000000000000_REALK,     -0.000474049202509_REALK,      0.000000000000000_REALK, &
     -0.000682892889763_REALK,      0.000000000000000_REALK,     -0.000507487960352_REALK, &
      0.000000000000000_REALK,     -0.000064211074850_REALK,      0.000000000000000_REALK, &
      0.000556680461096_REALK,      0.000000000000000_REALK,      0.001251225893189_REALK, &
     -0.009122890064517_REALK,      0.000000000000000_REALK,      0.001346592408597_REALK, &
      0.000000000000000_REALK,      0.004697827725815_REALK,      0.000000000000000_REALK, &
     -0.013229400126573_REALK,      0.000000000000000_REALK,      0.003971259355632_REALK, &
      0.000000000000000_REALK,      0.002589098903691_REALK,      0.000000000000000_REALK, &
     -0.000767870824508_REALK,      0.000000000000000_REALK,      0.002884663758466_REALK, &
      0.000000000000000_REALK,      0.002926191233180_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.004276035545197_REALK,      0.000000000000000_REALK, &
     -0.000425804854944_REALK,      0.000000000000000_REALK,      0.009948374031795_REALK, &
      0.000000000000000_REALK,      0.003280910913079_REALK,      0.000000000000000_REALK, &
     -0.002603097868768_REALK,      0.000000000000000_REALK,     -0.002656833988809_REALK, &
      0.000000000000000_REALK,      0.000965725659284_REALK,      0.000000000000000_REALK, &
     -0.004651146264561_REALK,      0.000000000000000_REALK,      0.001936426810370_REALK, &
     -0.008008401070521_REALK,      0.000000000000000_REALK,     -0.002524720231734_REALK, &
      0.000000000000000_REALK,     -0.005823129148470_REALK,      0.000000000000000_REALK, &
     -0.000123778300126_REALK,      0.000000000000000_REALK,      0.004257488838484_REALK, &
      0.000000000000000_REALK,      0.004513094346573_REALK,      0.000000000000000_REALK, &
      0.000590782593021_REALK,      0.000000000000000_REALK,      0.003581843854937_REALK, &
      0.000000000000000_REALK,     -0.003441544383908_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.002893467376220_REALK,      0.000000000000000_REALK, &
      0.001238812115201_REALK,      0.000000000000000_REALK,     -0.000240687137814_REALK, &
      0.000000000000000_REALK,     -0.000175330108582_REALK,      0.000000000000000_REALK/
