  ! number of test cases
  integer, parameter :: NUM_TESTS = 6
  ! ID of block of sub-shells on bra center
  integer, parameter :: BRA_BLOCK(NUM_TESTS) = (/12, 12, 12, 12, 12, 12/)
  ! ID of block of sub-shells on ket center
  integer, parameter :: KET_BLOCK(NUM_TESTS) = (/6, 6, 6, 6, 6, 6/)
  ! orders of electronic derivatives
  integer, parameter :: ORDER_ELEC(NUM_TESTS) = (/0, 0, 0, 0, 0, 0/)
  ! indices of nuclear potential origin
  integer, parameter :: IDX_NUCORG(NUM_TESTS) = (/1, 2, 3, 1, 2, 3/)
  ! coordinates of nuclear potential origin
  real(REALK), parameter :: NUC_ORIGIN(3*NUM_TESTS) =  &
    (/0.0_REALK, -0.224905893_REALK, 0.0_REALK,        &
      1.45235_REALK, 0.899623_REALK, 0.0_REALK,        &
     -1.45235_REALK, 0.899623_REALK, 0.0_REALK,        &
      0.0_REALK, -0.224905893_REALK, 0.0_REALK,        &
      1.45235_REALK, 0.899623_REALK, 0.0_REALK,        &
     -1.45235_REALK, 0.899623_REALK, 0.0_REALK/)
  ! indices of dipole origin
  integer, parameter :: IDX_DIPORG(NUM_TESTS) = (/-1, -1, -1, -1, -1, -1/)
  ! coordinates of dipole origin
  real(REALK), parameter :: DIP_ORIGIN(3*NUM_TESTS) =                      &
    (/0.0_REALK, 0.0_REALK, 0.0_REALK,    0.0_REALK, 0.0_REALK, 0.0_REALK, &
      0.0_REALK, 0.0_REALK, 0.0_REALK,    0.0_REALK, 0.0_REALK, 0.0_REALK, &
      0.0_REALK, 0.0_REALK, 0.0_REALK,    0.0_REALK, 0.0_REALK, 0.0_REALK/)
  ! scale constants
  real(REALK), parameter :: SCAL_CONST(NUM_TESTS) = &
    (/-1.0_REALK, -1.0_REALK, -1.0_REALK, 1.0_REALK, 1.0_REALK, 1.0_REALK/)
  ! orders of Cartesian multipole moments
  integer, parameter :: ORDER_MOM(NUM_TESTS) = (/0, 0, 0, 0, 0, 0/)
  ! orders of partial geometric derivatives on bra center
  integer, parameter :: ORDER_GEO_BRA(NUM_TESTS) = (/0, 0, 0, 0, 0, 0/)
  ! orders of partial geometric derivatives on ket center
  integer, parameter :: ORDER_GEO_KET(NUM_TESTS) = (/0, 0, 0, 0, 0, 0/)
  ! orders of geometric derivatives on nuclear potential origin
  integer, parameter :: ORDER_GEO_POT(NUM_TESTS) = (/0, 0, 0, 1, 1, 1/)
  ! orders of geometric derivatives on dipole origin
  integer, parameter :: ORDER_GEO_MOM(NUM_TESTS) = (/0, 0, 0, 0, 0, 0/)
  ! numbers of differentiated centers of total geometric derivatives
  integer, parameter :: NUM_CENTS(NUM_TESTS) = (/0, 0, 0, 0, 0, 0/)
  ! indices of differentiated centers
  integer, parameter :: IDX_CENT(3*NUM_TESTS) = &
    (/0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0/)
  ! orders of geometric derivatives of differentiated centers
  integer, parameter :: ORDER_CENT(3*NUM_TESTS) = &
    (/0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0/)
  ! referenced results from Dalton
  real(REALK) REF_CONTR_INTS(15120)
  ! results of test 1, ket-major order, POT.E O1
  data REF_CONTR_INTS(1:1260)                                                              &
   /-16.085752683610771_REALK,    -15.117988832278110_REALK,      0.000000000000000_REALK, &
    -17.756985982775170_REALK,      0.000000000000000_REALK,     -2.403248846478230_REALK, &
    -25.219513252865966_REALK,      0.000000000000000_REALK,     -2.690801828983969_REALK, &
      0.000000000000000_REALK,    -47.186473022032963_REALK,      0.000000000000000_REALK, &
     -4.297753681088805_REALK,      0.000000000000000_REALK,     -1.823452714893532_REALK, &
    -11.885068850214799_REALK,    -17.635320312679543_REALK,      0.000000000000000_REALK, &
    -25.526497387315889_REALK,      0.000000000000000_REALK,     -2.607893545521748_REALK, &
    -40.827037956597316_REALK,      0.000000000000000_REALK,     -3.483669683484749_REALK, &
      0.000000000000000_REALK,    -79.657039608416937_REALK,      0.000000000000000_REALK, &
     -5.976166126082523_REALK,      0.000000000000000_REALK,     -1.935338709559905_REALK, &
    -11.275394075901405_REALK,     -7.815946822259690_REALK,      0.000000000000000_REALK, &
     -6.884690843527324_REALK,      0.000000000000000_REALK,     -1.491233484281056_REALK, &
     -7.142575628586490_REALK,      0.000000000000000_REALK,     -1.214086062036985_REALK, &
      0.000000000000000_REALK,     -9.120289536873599_REALK,      0.000000000000000_REALK, &
     -1.396845762634770_REALK,      0.000000000000000_REALK,     -0.947354252608502_REALK, &
    -11.067213482518113_REALK,     -5.945783234077322_REALK,      0.000000000000000_REALK, &
     -3.351526251922301_REALK,      0.000000000000000_REALK,     -1.131013151366844_REALK, &
     -0.573259749363918_REALK,      0.000000000000000_REALK,     -0.793038811045290_REALK, &
      0.000000000000000_REALK,      5.250514454911045_REALK,      0.000000000000000_REALK, &
     -0.592379831384767_REALK,      0.000000000000000_REALK,     -0.635961649129117_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.129831575076759_REALK, &
      0.000000000000000_REALK,      2.018650433735404_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.432359450155092_REALK,      0.000000000000000_REALK, &
      1.007873628212878_REALK,      0.000000000000000_REALK,      3.814161686838472_REALK, &
      0.000000000000000_REALK,      1.244891609845582_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.742991255304551_REALK, &
      0.000000000000000_REALK,      3.786364515616816_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.836019962657895_REALK,      0.000000000000000_REALK, &
      1.521866164384347_REALK,      0.000000000000000_REALK,      7.779304441195031_REALK, &
      0.000000000000000_REALK,      2.040890879373470_REALK,      0.000000000000000_REALK, &
    -11.012103912615800_REALK,     -6.093865747863903_REALK,      0.000000000000000_REALK, &
     -4.572743318728387_REALK,      0.000000000000000_REALK,     -1.278197420748326_REALK, &
     -4.149183730392179_REALK,      0.000000000000000_REALK,     -0.814574570421714_REALK, &
      0.000000000000000_REALK,     -4.801511283658951_REALK,      0.000000000000000_REALK, &
     -0.768370360644921_REALK,      0.000000000000000_REALK,     -0.674912278850916_REALK, &
     -5.516877766786298_REALK,     -4.816459563973545_REALK,      0.000000000000000_REALK, &
     -4.795399358274037_REALK,      0.000000000000000_REALK,     -0.962850646167520_REALK, &
     -5.856441467816003_REALK,      0.000000000000000_REALK,     -0.727197034384160_REALK, &
      0.000000000000000_REALK,     -9.349533989219930_REALK,      0.000000000000000_REALK, &
     -0.781002468467127_REALK,      0.000000000000000_REALK,     -0.501324221169924_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.510866082946600_REALK, &
      0.000000000000000_REALK,      1.046275125821230_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.935583080531819_REALK,      0.000000000000000_REALK, &
      0.619846401680800_REALK,      0.000000000000000_REALK,      1.037587999948183_REALK, &
      0.000000000000000_REALK,      0.538543442481286_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.209764648703425_REALK, &
      0.000000000000000_REALK,      0.849572163948496_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.544647563226205_REALK,      0.000000000000000_REALK, &
      0.570278460503974_REALK,      0.000000000000000_REALK,      0.099377713563754_REALK, &
      0.000000000000000_REALK,      0.432646140779950_REALK,      0.000000000000000_REALK, &
     -2.510674406884104_REALK,     -2.082195544659918_REALK,      0.000000000000000_REALK, &
     -2.128937315014927_REALK,      0.000000000000000_REALK,     -0.861906594193338_REALK, &
     -2.596148252811467_REALK,      0.000000000000000_REALK,     -0.827891322459906_REALK, &
      0.000000000000000_REALK,     -3.925801499980513_REALK,      0.000000000000000_REALK, &
     -1.066375686030977_REALK,      0.000000000000000_REALK,     -0.749908826643540_REALK, &
     -3.140880406745332_REALK,     -4.120295309074676_REALK,      0.000000000000000_REALK, &
     -5.272414561006162_REALK,      0.000000000000000_REALK,     -1.621309836037692_REALK, &
     -7.282134331536712_REALK,      0.000000000000000_REALK,     -1.863427070710100_REALK, &
      0.000000000000000_REALK,    -11.562427684644179_REALK,      0.000000000000000_REALK, &
     -2.590398127011909_REALK,      0.000000000000000_REALK,     -1.392478000483860_REALK, &
    -13.531041578759513_REALK,     -5.770376421816365_REALK,      0.000000000000000_REALK, &
     -3.562512454049387_REALK,      0.000000000000000_REALK,     -1.344805418346567_REALK, &
     -2.577075987206374_REALK,      0.000000000000000_REALK,     -0.651777523270111_REALK, &
      0.000000000000000_REALK,     -2.272958963603799_REALK,      0.000000000000000_REALK, &
     -0.491752260696436_REALK,      0.000000000000000_REALK,     -0.583954657986279_REALK, &
    -16.105092779347132_REALK,     -5.616528960956032_REALK,      0.000000000000000_REALK, &
     -2.212063706676047_REALK,      0.000000000000000_REALK,     -1.218419428443134_REALK, &
     -0.022659043479265_REALK,      0.000000000000000_REALK,     -0.513299468689580_REALK, &
      0.000000000000000_REALK,      2.681443817739043_REALK,      0.000000000000000_REALK, &
     -0.249300283912256_REALK,      0.000000000000000_REALK,     -0.441247055935256_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.531817584983720_REALK, &
      0.000000000000000_REALK,      0.830939452868530_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.622314853241442_REALK,      0.000000000000000_REALK, &
      0.532507005745670_REALK,      0.000000000000000_REALK,      0.585030680111978_REALK, &
      0.000000000000000_REALK,      0.350928718262044_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.239029498107225_REALK, &
      0.000000000000000_REALK,      1.260739682074276_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.025924736986090_REALK,      0.000000000000000_REALK, &
      0.634462767446330_REALK,      0.000000000000000_REALK,      1.149771461934054_REALK, &
      0.000000000000000_REALK,      0.438172701693718_REALK,      0.000000000000000_REALK, &
     -2.113034644980435_REALK,     -1.274104592120754_REALK,      0.000000000000000_REALK, &
     -0.965689483377521_REALK,      0.000000000000000_REALK,     -0.624704791727337_REALK, &
     -0.849806833393490_REALK,      0.000000000000000_REALK,     -0.431126950122462_REALK, &
      0.000000000000000_REALK,     -0.876345725431886_REALK,      0.000000000000000_REALK, &
     -0.399869899956408_REALK,      0.000000000000000_REALK,     -0.448994536788514_REALK, &
     -4.279209084766262_REALK,     -2.010985688455756_REALK,      0.000000000000000_REALK, &
     -0.954139620522626_REALK,      0.000000000000000_REALK,     -0.965643202759013_REALK, &
     -0.134559645279658_REALK,      0.000000000000000_REALK,     -0.554774184888744_REALK, &
      0.000000000000000_REALK,      0.968637906543464_REALK,      0.000000000000000_REALK, &
     -0.326369375457049_REALK,      0.000000000000000_REALK,     -0.580290561240428_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.040426496242684_REALK, &
      0.000000000000000_REALK,      0.848238041821937_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.866670342913414_REALK,      0.000000000000000_REALK, &
      0.595520377427196_REALK,      0.000000000000000_REALK,      1.096853418146586_REALK, &
      0.000000000000000_REALK,      0.592747476819457_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.801867526067527_REALK, &
      0.000000000000000_REALK,      3.233427018297094_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.391629702943929_REALK,      0.000000000000000_REALK, &
      1.773060860338030_REALK,      0.000000000000000_REALK,      4.305408869122721_REALK, &
      0.000000000000000_REALK,      1.870730136875399_REALK,      0.000000000000000_REALK, &
    -20.372522144628263_REALK,     -6.742626142791136_REALK,      0.000000000000000_REALK, &
     -3.586482934402081_REALK,      0.000000000000000_REALK,     -1.739184252204222_REALK, &
     -2.195161835538290_REALK,      0.000000000000000_REALK,     -0.638027406480488_REALK, &
      0.000000000000000_REALK,     -1.715972424850553_REALK,      0.000000000000000_REALK, &
     -0.402217555804333_REALK,      0.000000000000000_REALK,     -0.615010065578848_REALK, &
    -10.949019464143390_REALK,     -5.746653435932085_REALK,      0.000000000000000_REALK, &
     -4.159909459950132_REALK,      0.000000000000000_REALK,     -1.501272915673928_REALK, &
     -3.956625520818247_REALK,      0.000000000000000_REALK,     -0.650603471783989_REALK, &
      0.000000000000000_REALK,     -5.384529961214921_REALK,      0.000000000000000_REALK, &
     -0.468513361344871_REALK,      0.000000000000000_REALK,     -0.542079498258818_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.945518016298722_REALK, &
      0.000000000000000_REALK,      0.808454932271714_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.492604732296749_REALK,      0.000000000000000_REALK, &
      0.569057475997956_REALK,      0.000000000000000_REALK,      0.359952637088175_REALK, &
      0.000000000000000_REALK,      0.277746817159375_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.739631028574029_REALK, &
      0.000000000000000_REALK,      0.789093184692824_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.357816102533115_REALK,      0.000000000000000_REALK, &
      0.616528828075117_REALK,      0.000000000000000_REALK,      0.001566108460323_REALK, &
      0.000000000000000_REALK,      0.276937642160696_REALK,      0.000000000000000_REALK, &
     -2.560914658195808_REALK,     -1.223412103003156_REALK,      0.000000000000000_REALK, &
     -0.782193107771811_REALK,      0.000000000000000_REALK,     -0.651359155279632_REALK, &
     -0.594880916897950_REALK,      0.000000000000000_REALK,     -0.347589133647062_REALK, &
      0.000000000000000_REALK,     -0.553632023650239_REALK,      0.000000000000000_REALK, &
     -0.263103189208294_REALK,      0.000000000000000_REALK,     -0.381694720234892_REALK, &
     -2.363162504326926_REALK,     -1.823764762984984_REALK,      0.000000000000000_REALK, &
     -1.599183999908730_REALK,      0.000000000000000_REALK,     -0.965467848226072_REALK, &
     -1.674759118250414_REALK,      0.000000000000000_REALK,     -0.622269122913897_REALK, &
      0.000000000000000_REALK,     -2.185417915073596_REALK,      0.000000000000000_REALK, &
     -0.544143688866192_REALK,      0.000000000000000_REALK,     -0.578069647752810_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.907665014537390_REALK, &
      0.000000000000000_REALK,      0.535127657062777_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.400564702393951_REALK,      0.000000000000000_REALK, &
      0.439319321322819_REALK,      0.000000000000000_REALK,      0.356659152720266_REALK, &
      0.000000000000000_REALK,      0.306110973639516_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.380580701469701_REALK, &
      0.000000000000000_REALK,      0.851171783923517_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.466329950261485_REALK,      0.000000000000000_REALK, &
      0.812260797517806_REALK,      0.000000000000000_REALK,      0.069629365309530_REALK, &
      0.000000000000000_REALK,      0.500158215992184_REALK,      0.000000000000000_REALK, &
     -1.753329231145444_REALK,     -1.255490585305749_REALK,      0.000000000000000_REALK, &
     -1.093752175096349_REALK,      0.000000000000000_REALK,     -0.733242192220168_REALK, &
     -1.117355746526620_REALK,      0.000000000000000_REALK,     -0.589518012312589_REALK, &
      0.000000000000000_REALK,     -1.357763803743682_REALK,      0.000000000000000_REALK, &
     -0.609296264096404_REALK,      0.000000000000000_REALK,     -0.595084083002363_REALK, &
     -4.025038367525853_REALK,     -4.679653966577075_REALK,      0.000000000000000_REALK, &
     -5.275786731682156_REALK,      0.000000000000000_REALK,     -2.708470017500575_REALK, &
     -6.244697149542335_REALK,      0.000000000000000_REALK,     -2.657709221417825_REALK, &
      0.000000000000000_REALK,     -8.099130948803500_REALK,      0.000000000000000_REALK, &
     -3.006132208904783_REALK,      0.000000000000000_REALK,     -2.250576782002717_REALK, &
    -46.632093664894235_REALK,    -11.022173594518208_REALK,      0.000000000000000_REALK, &
     -4.865762670915363_REALK,      0.000000000000000_REALK,     -3.041305596126032_REALK, &
     -2.299140911469862_REALK,      0.000000000000000_REALK,     -0.794851153927622_REALK, &
      0.000000000000000_REALK,     -1.409080908342747_REALK,      0.000000000000000_REALK, &
     -0.413259334977376_REALK,      0.000000000000000_REALK,     -0.817940250583029_REALK, &
   -111.652561001049577_REALK,    -23.130340465083588_REALK,      0.000000000000000_REALK, &
     -6.400316610759549_REALK,      0.000000000000000_REALK,     -5.812435528201956_REALK, &
      0.707683272710558_REALK,      0.000000000000000_REALK,     -1.290098456092480_REALK, &
      0.000000000000000_REALK,      5.297397710553169_REALK,      0.000000000000000_REALK, &
     -0.400857327947752_REALK,      0.000000000000000_REALK,     -1.176098236087186_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.603948745329764_REALK, &
      0.000000000000000_REALK,      1.095787690525714_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.547611180704576_REALK,      0.000000000000000_REALK, &
      0.809323424947198_REALK,      0.000000000000000_REALK,      0.322176240197997_REALK, &
      0.000000000000000_REALK,      0.284895955127771_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      9.963772613787661_REALK, &
      0.000000000000000_REALK,      3.064746251286488_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.586631058964014_REALK,      0.000000000000000_REALK, &
      1.744094074415165_REALK,      0.000000000000000_REALK,      1.190404612992845_REALK, &
      0.000000000000000_REALK,      0.594045487453923_REALK,      0.000000000000000_REALK, &
     -4.924028899238250_REALK,     -1.715019814824714_REALK,      0.000000000000000_REALK, &
     -0.858094131256777_REALK,      0.000000000000000_REALK,     -0.957692114808501_REALK, &
     -0.498211036948334_REALK,      0.000000000000000_REALK,     -0.372811754064602_REALK, &
      0.000000000000000_REALK,     -0.342284699917739_REALK,      0.000000000000000_REALK, &
     -0.218820029263155_REALK,      0.000000000000000_REALK,     -0.427186055965352_REALK, &
    -18.078959528089001_REALK,     -5.381411191427690_REALK,      0.000000000000000_REALK, &
     -1.712966046252300_REALK,      0.000000000000000_REALK,     -2.812309283353080_REALK, &
     -0.016738898289969_REALK,      0.000000000000000_REALK,     -0.910794572068507_REALK, &
      0.000000000000000_REALK,      1.176231370332838_REALK,      0.000000000000000_REALK, &
     -0.325594538743346_REALK,      0.000000000000000_REALK,     -0.945469596762351_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.356044538437218_REALK, &
      0.000000000000000_REALK,      0.596605026720413_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.358261068557425_REALK,      0.000000000000000_REALK, &
      0.504266292744812_REALK,      0.000000000000000_REALK,      0.262291315065038_REALK, &
      0.000000000000000_REALK,      0.258797871577751_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.439285816546322_REALK, &
      0.000000000000000_REALK,      2.921060387583116_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.832742737790302_REALK,      0.000000000000000_REALK, &
      1.867191072671305_REALK,      0.000000000000000_REALK,      1.514786541681312_REALK, &
      0.000000000000000_REALK,      0.947852488847118_REALK,      0.000000000000000_REALK, &
     -2.311814467521882_REALK,     -1.136741427752975_REALK,      0.000000000000000_REALK, &
     -0.697893607347670_REALK,      0.000000000000000_REALK,     -0.742946167809226_REALK, &
     -0.492255753875456_REALK,      0.000000000000000_REALK,     -0.411140944991107_REALK, &
      0.000000000000000_REALK,     -0.395008468158900_REALK,      0.000000000000000_REALK, &
     -0.296557590989688_REALK,      0.000000000000000_REALK,     -0.460763070265822_REALK, &
    -14.402156939782007_REALK,     -5.781008525882310_REALK,      0.000000000000000_REALK, &
     -2.214119412026028_REALK,      0.000000000000000_REALK,     -3.716178560775421_REALK, &
     -0.242681749499767_REALK,      0.000000000000000_REALK,     -1.639099352225660_REALK, &
      0.000000000000000_REALK,      1.272969574553489_REALK,      0.000000000000000_REALK, &
     -0.708536773403637_REALK,      0.000000000000000_REALK,     -1.742581758720017_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.540527739180195_REALK, &
      0.000000000000000_REALK,      1.017593635884330_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.833217152350640_REALK,      0.000000000000000_REALK, &
      0.792003150734712_REALK,      0.000000000000000_REALK,      0.820355009509394_REALK, &
      0.000000000000000_REALK,      0.613234018210636_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     18.219519295819506_REALK, &
      0.000000000000000_REALK,     12.487993061232810_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     10.087949789934765_REALK,      0.000000000000000_REALK, &
      7.318653214751135_REALK,      0.000000000000000_REALK,      9.429979104316100_REALK, &
      0.000000000000000_REALK,      5.666703616783136_REALK,      0.000000000000000_REALK, &
    -13.374876317826486_REALK,     -5.817603904189117_REALK,      0.000000000000000_REALK, &
    -13.529451421303408_REALK,      0.000000000000000_REALK,     -5.182812416724118_REALK, &
    -11.829071638851152_REALK,      0.000000000000000_REALK,     -2.411280280559015_REALK, &
      0.000000000000000_REALK,    -83.135824016993112_REALK,      0.000000000000000_REALK, &
    -14.401235156605500_REALK,      0.000000000000000_REALK,    -17.353497371691688_REALK, &
     -5.348632629208876_REALK,     -4.202334750509911_REALK,      0.000000000000000_REALK, &
    -12.118015050114618_REALK,      0.000000000000000_REALK,     -3.315228705880239_REALK, &
    -14.099417314465018_REALK,      0.000000000000000_REALK,     -2.335379807939395_REALK, &
      0.000000000000000_REALK,   -101.079980155634289_REALK,      0.000000000000000_REALK, &
    -14.523699548178350_REALK,      0.000000000000000_REALK,    -12.758930284533688_REALK, &
    -10.586612442328390_REALK,     -3.784978697115335_REALK,      0.000000000000000_REALK, &
     -5.365466298156942_REALK,      0.000000000000000_REALK,     -3.556111366840242_REALK, &
     -4.241984977855701_REALK,      0.000000000000000_REALK,     -1.398085898949167_REALK, &
      0.000000000000000_REALK,    -15.595819991089794_REALK,      0.000000000000000_REALK, &
     -4.738124412833934_REALK,      0.000000000000000_REALK,     -9.932362349890173_REALK, &
     -5.934854599357440_REALK,     -1.930217587264928_REALK,      0.000000000000000_REALK, &
     -1.621500789988504_REALK,      0.000000000000000_REALK,     -1.751795810361931_REALK, &
     -0.001320356545817_REALK,      0.000000000000000_REALK,     -0.724744836590509_REALK, &
      0.000000000000000_REALK,      7.694446330769125_REALK,      0.000000000000000_REALK, &
     -1.468836006592556_REALK,      0.000000000000000_REALK,     -5.158220829221540_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.937420935500676_REALK, &
      0.000000000000000_REALK,      1.956959263158743_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.984164645654926_REALK,      0.000000000000000_REALK, &
      2.229540047337891_REALK,      0.000000000000000_REALK,      7.948800571500655_REALK, &
      0.000000000000000_REALK,      5.230436831022764_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.004889410220093_REALK, &
      0.000000000000000_REALK,      2.367477461044790_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.916594288708343_REALK,      0.000000000000000_REALK, &
      2.372360732383106_REALK,      0.000000000000000_REALK,     12.034874753202898_REALK, &
      0.000000000000000_REALK,      6.557669925014205_REALK,      0.000000000000000_REALK, &
    -11.430316691404803_REALK,     -2.776565722876654_REALK,      0.000000000000000_REALK, &
     -3.515254569098735_REALK,      0.000000000000000_REALK,     -3.230988391834199_REALK, &
     -2.278243303976972_REALK,      0.000000000000000_REALK,     -0.882053207144446_REALK, &
      0.000000000000000_REALK,     -7.059658662608414_REALK,      0.000000000000000_REALK, &
     -2.452654593717502_REALK,      0.000000000000000_REALK,     -7.131127884349430_REALK, &
     -3.404686783772891_REALK,     -1.479858989870684_REALK,      0.000000000000000_REALK, &
     -2.089301211556279_REALK,      0.000000000000000_REALK,     -1.606477668118490_REALK, &
     -2.390875964202367_REALK,      0.000000000000000_REALK,     -0.591439576949255_REALK, &
      0.000000000000000_REALK,     -8.966978190965483_REALK,      0.000000000000000_REALK, &
     -1.496514395967145_REALK,      0.000000000000000_REALK,     -3.780692486230497_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.868076828562869_REALK, &
      0.000000000000000_REALK,      0.968864499548958_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.950634582581863_REALK,      0.000000000000000_REALK, &
      1.890120656008749_REALK,      0.000000000000000_REALK,      1.952050784227703_REALK, &
      0.000000000000000_REALK,      2.022811405170881_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.100699194136005_REALK, &
      0.000000000000000_REALK,      0.602158714086966_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.435958351209322_REALK,      0.000000000000000_REALK, &
      1.443711448664463_REALK,      0.000000000000000_REALK,     -0.021665846670080_REALK, &
      0.000000000000000_REALK,      1.331066797765864_REALK,      0.000000000000000_REALK, &
     -1.862938251462096_REALK,     -1.074474009401551_REALK,      0.000000000000000_REALK, &
     -1.378320615743908_REALK,      0.000000000000000_REALK,     -1.557291311987014_REALK, &
     -1.652878226816455_REALK,      0.000000000000000_REALK,     -1.041955824508566_REALK, &
      0.000000000000000_REALK,     -5.482359123861330_REALK,      0.000000000000000_REALK, &
     -2.833791183313972_REALK,      0.000000000000000_REALK,     -5.657083114853172_REALK, &
     -1.425803767333716_REALK,     -1.555625797207154_REALK,      0.000000000000000_REALK, &
     -2.435430685249801_REALK,      0.000000000000000_REALK,     -1.975744219678626_REALK, &
     -3.708019835366574_REALK,      0.000000000000000_REALK,     -1.922949238077572_REALK, &
      0.000000000000000_REALK,    -12.211110418777157_REALK,      0.000000000000000_REALK, &
     -5.235326481695822_REALK,      0.000000000000000_REALK,     -7.621240070052765_REALK, &
    -15.503757037460113_REALK,     -1.867429008203061_REALK,      0.000000000000000_REALK, &
     -3.048460037190680_REALK,      0.000000000000000_REALK,     -3.605107121801744_REALK, &
     -0.955776251774127_REALK,      0.000000000000000_REALK,     -0.476666165124985_REALK, &
      0.000000000000000_REALK,     -3.672940308065687_REALK,      0.000000000000000_REALK, &
     -1.637028286741792_REALK,      0.000000000000000_REALK,     -6.045177852109132_REALK, &
    -11.428290026447932_REALK,     -1.108178310860457_REALK,      0.000000000000000_REALK, &
     -1.219842890152315_REALK,      0.000000000000000_REALK,     -2.208759282155777_REALK, &
      0.541020731343101_REALK,      0.000000000000000_REALK,     -0.245852705634517_REALK, &
      0.000000000000000_REALK,      2.352248279756590_REALK,      0.000000000000000_REALK, &
     -0.587083992441532_REALK,      0.000000000000000_REALK,     -3.353354256411694_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.224648935607530_REALK, &
      0.000000000000000_REALK,      0.619096275752239_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.685647303549462_REALK,      0.000000000000000_REALK, &
      1.912659716970245_REALK,      0.000000000000000_REALK,      0.792903312689072_REALK, &
      0.000000000000000_REALK,      0.957266778895196_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.056386218749711_REALK, &
      0.000000000000000_REALK,      0.627331379123925_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.697820068871300_REALK,      0.000000000000000_REALK, &
      1.660661859852304_REALK,      0.000000000000000_REALK,      1.111950335796513_REALK, &
      0.000000000000000_REALK,      0.859790081537992_REALK,      0.000000000000000_REALK, &
     -1.900824130385947_REALK,     -0.693544353333393_REALK,      0.000000000000000_REALK, &
     -0.668077468211124_REALK,      0.000000000000000_REALK,     -1.313733720256894_REALK, &
     -0.567692780152124_REALK,      0.000000000000000_REALK,     -0.568028006426462_REALK, &
      0.000000000000000_REALK,     -1.158089520371774_REALK,      0.000000000000000_REALK, &
     -1.048774310005091_REALK,      0.000000000000000_REALK,     -3.639372604561706_REALK, &
     -2.593962373491146_REALK,     -0.804324823804361_REALK,      0.000000000000000_REALK, &
     -0.461683924272403_REALK,      0.000000000000000_REALK,     -1.490044441243110_REALK, &
      0.002791546574701_REALK,      0.000000000000000_REALK,     -0.610893387305746_REALK, &
      0.000000000000000_REALK,      1.130887262399067_REALK,      0.000000000000000_REALK, &
     -0.643835309840568_REALK,      0.000000000000000_REALK,     -3.739967977424843_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.082056246515305_REALK, &
      0.000000000000000_REALK,      0.729866368017189_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.803862549399489_REALK,      0.000000000000000_REALK, &
      1.533051093021445_REALK,      0.000000000000000_REALK,      1.767796575226144_REALK, &
      0.000000000000000_REALK,      1.927821020461653_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.559060129605002_REALK, &
      0.000000000000000_REALK,      2.021174283493700_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.442971629782283_REALK,      0.000000000000000_REALK, &
      3.386714222866340_REALK,      0.000000000000000_REALK,      5.301334983425152_REALK, &
      0.000000000000000_REALK,      4.783296149824730_REALK,      0.000000000000000_REALK, &
    -25.668584966592718_REALK,     -0.481131359927574_REALK,      0.000000000000000_REALK, &
     -3.700089869685238_REALK,      0.000000000000000_REALK,     -4.864118986078430_REALK, &
      0.086781805226951_REALK,      0.000000000000000_REALK,     -0.041358911714949_REALK, &
      0.000000000000000_REALK,     -3.332662819728818_REALK,      0.000000000000000_REALK, &
     -1.492149039949607_REALK,      0.000000000000000_REALK,     -6.010802730205015_REALK, &
     -9.970591645875352_REALK,     -0.340286534090709_REALK,      0.000000000000000_REALK, &
     -2.499772070018364_REALK,      0.000000000000000_REALK,     -3.221338366506036_REALK, &
     -0.754980121773491_REALK,      0.000000000000000_REALK,     -0.029636797500915_REALK, &
      0.000000000000000_REALK,     -4.661609178498145_REALK,      0.000000000000000_REALK, &
     -0.971632643457086_REALK,      0.000000000000000_REALK,     -3.920372865714055_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.171455101400811_REALK, &
      0.000000000000000_REALK,      0.382853172976610_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.624151695086082_REALK,      0.000000000000000_REALK, &
      2.243716529444936_REALK,      0.000000000000000_REALK,      0.258642588678933_REALK, &
      0.000000000000000_REALK,      0.407141445154171_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.298401995463672_REALK, &
      0.000000000000000_REALK,      0.268476817226442_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.368599446503664_REALK,      0.000000000000000_REALK, &
      2.056986785645665_REALK,      0.000000000000000_REALK,     -0.231663875835316_REALK, &
      0.000000000000000_REALK,      0.268758419979635_REALK,      0.000000000000000_REALK, &
     -2.607710548745849_REALK,     -0.570155296587248_REALK,      0.000000000000000_REALK, &
     -0.537963265307160_REALK,      0.000000000000000_REALK,     -1.471759418501612_REALK, &
     -0.323268305918797_REALK,      0.000000000000000_REALK,     -0.376779290336925_REALK, &
      0.000000000000000_REALK,     -0.605589335217597_REALK,      0.000000000000000_REALK, &
     -0.625786808672110_REALK,      0.000000000000000_REALK,     -3.009487842951032_REALK, &
     -1.785341863572824_REALK,     -0.676180045794408_REALK,      0.000000000000000_REALK, &
     -0.740809002084513_REALK,      0.000000000000000_REALK,     -1.715817899065586_REALK, &
     -0.745305574048929_REALK,      0.000000000000000_REALK,     -0.557361715426968_REALK, &
      0.000000000000000_REALK,     -1.669704246487157_REALK,      0.000000000000000_REALK, &
     -0.828517127549520_REALK,      0.000000000000000_REALK,     -3.454670859265911_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.161700443448606_REALK, &
      0.000000000000000_REALK,      0.444925430058394_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.407532622487711_REALK,      0.000000000000000_REALK, &
      1.359380877265318_REALK,      0.000000000000000_REALK,      0.501805867104636_REALK, &
      0.000000000000000_REALK,      0.860958481487870_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.554860725951759_REALK, &
      0.000000000000000_REALK,      0.641798265740161_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.412575254222258_REALK,      0.000000000000000_REALK, &
      2.304325575117460_REALK,      0.000000000000000_REALK,     -0.010557130194147_REALK, &
      0.000000000000000_REALK,      1.225318631977546_REALK,      0.000000000000000_REALK, &
     -1.276095243852638_REALK,     -0.664174507485923_REALK,      0.000000000000000_REALK, &
     -0.634455740132170_REALK,      0.000000000000000_REALK,     -1.184500481196867_REALK, &
     -0.706131765510148_REALK,      0.000000000000000_REALK,     -0.744771195875540_REALK, &
      0.000000000000000_REALK,     -1.413713049388982_REALK,      0.000000000000000_REALK, &
     -1.208382356793590_REALK,      0.000000000000000_REALK,     -3.348679754036984_REALK, &
     -2.231599866765736_REALK,     -2.154462496727465_REALK,      0.000000000000000_REALK, &
     -2.591323368874216_REALK,      0.000000000000000_REALK,     -3.515024434205045_REALK, &
     -3.485390237480588_REALK,      0.000000000000000_REALK,     -3.039568480593482_REALK, &
      0.000000000000000_REALK,     -6.813962911004775_REALK,      0.000000000000000_REALK, &
     -4.831786957538101_REALK,      0.000000000000000_REALK,     -9.768506308514626_REALK, &
    -58.805397992839687_REALK,      3.349092126630638_REALK,      0.000000000000000_REALK, &
     -6.401743787601601_REALK,      0.000000000000000_REALK,     -8.280956536387752_REALK, &
      1.859059434408826_REALK,      0.000000000000000_REALK,      0.706638878309070_REALK, &
      0.000000000000000_REALK,     -4.313370222785559_REALK,      0.000000000000000_REALK, &
     -1.827152279468904_REALK,      0.000000000000000_REALK,     -7.110858026425499_REALK, &
   -103.554523655072700_REALK,      6.836511961780860_REALK,      0.000000000000000_REALK, &
     -7.182670723803680_REALK,      0.000000000000000_REALK,    -11.616701005041982_REALK, &
      4.156462572262422_REALK,      0.000000000000000_REALK,      1.116885816673297_REALK, &
      0.000000000000000_REALK,      0.433739609123546_REALK,      0.000000000000000_REALK, &
     -1.435073823759071_REALK,      0.000000000000000_REALK,     -6.904206320975626_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.929135318193098_REALK, &
      0.000000000000000_REALK,      0.076069190640813_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.797561379048710_REALK,      0.000000000000000_REALK, &
      3.169899856169081_REALK,      0.000000000000000_REALK,     -0.054270038434205_REALK, &
      0.000000000000000_REALK,     -0.002402546398305_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     12.006625707871809_REALK, &
      0.000000000000000_REALK,      0.174041986112962_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.274590692953049_REALK,      0.000000000000000_REALK, &
      4.997734102785362_REALK,      0.000000000000000_REALK,      0.304137139110800_REALK, &
      0.000000000000000_REALK,      0.000926021050906_REALK,      0.000000000000000_REALK, &
     -5.141842261555793_REALK,     -0.507703653642483_REALK,      0.000000000000000_REALK, &
     -0.613473194040263_REALK,      0.000000000000000_REALK,     -2.158867819052872_REALK, &
     -0.160709662035393_REALK,      0.000000000000000_REALK,     -0.238943262745345_REALK, &
      0.000000000000000_REALK,     -0.378967062066828_REALK,      0.000000000000000_REALK, &
     -0.502654497621131_REALK,      0.000000000000000_REALK,     -3.070999857507017_REALK, &
    -14.662100041415622_REALK,     -1.125590755278338_REALK,      0.000000000000000_REALK, &
     -0.905359855093354_REALK,      0.000000000000000_REALK,     -4.907028284503502_REALK, &
      0.288186559547225_REALK,      0.000000000000000_REALK,     -0.394379477047433_REALK, &
      0.000000000000000_REALK,      0.706648127940144_REALK,      0.000000000000000_REALK, &
     -0.512529912608470_REALK,      0.000000000000000_REALK,     -4.835913770303550_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.801960647438593_REALK, &
      0.000000000000000_REALK,      0.375915670976133_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.343855120297345_REALK,      0.000000000000000_REALK, &
      1.595109508740483_REALK,      0.000000000000000_REALK,      0.248122081709200_REALK, &
      0.000000000000000_REALK,      0.494258353398337_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.427588605024586_REALK, &
      0.000000000000000_REALK,      1.398267203012260_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.119829372590225_REALK,      0.000000000000000_REALK, &
      4.426955278743636_REALK,      0.000000000000000_REALK,      0.996040289465804_REALK, &
      0.000000000000000_REALK,      1.266689814242696_REALK,      0.000000000000000_REALK, &
     -1.893654768960704_REALK,     -0.563746802372004_REALK,      0.000000000000000_REALK, &
     -0.405081381342381_REALK,      0.000000000000000_REALK,     -1.313211339071872_REALK, &
     -0.285337516576240_REALK,      0.000000000000000_REALK,     -0.474231329540976_REALK, &
      0.000000000000000_REALK,     -0.361349104907615_REALK,      0.000000000000000_REALK, &
     -0.539555479452662_REALK,      0.000000000000000_REALK,     -2.592823449456895_REALK, &
     -9.966076036206420_REALK,     -2.492868766458002_REALK,      0.000000000000000_REALK, &
     -1.028849984746472_REALK,      0.000000000000000_REALK,     -5.518539055300752_REALK, &
      0.003759328647809_REALK,      0.000000000000000_REALK,     -1.630150310772008_REALK, &
      0.000000000000000_REALK,      1.007125270092530_REALK,      0.000000000000000_REALK, &
     -0.944249235701212_REALK,      0.000000000000000_REALK,     -7.563581495767181_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.461993929141208_REALK, &
      0.000000000000000_REALK,      0.735922430052762_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.672243531227646_REALK,      0.000000000000000_REALK, &
      1.790377436731311_REALK,      0.000000000000000_REALK,      0.916579851565112_REALK, &
      0.000000000000000_REALK,      1.386257552917436_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     13.299716083185787_REALK, &
      0.000000000000000_REALK,      7.500816843830827_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      6.531083441882872_REALK,      0.000000000000000_REALK, &
     12.642950218848000_REALK,      0.000000000000000_REALK,      7.853820149476831_REALK, &
      0.000000000000000_REALK,      9.789212527183700_REALK,      0.000000000000000_REALK/
  ! results of test 2, ket-major order, POT.E H1
  data REF_CONTR_INTS(1261:2520)                                                           &
   /-15.496707928707824_REALK,    -13.737359339460165_REALK,      0.000000000000000_REALK, &
    -16.097990627720403_REALK,      0.000000000000000_REALK,     -2.691518895638242_REALK, &
    -23.321795465442602_REALK,      0.000000000000000_REALK,     -2.912997783549268_REALK, &
      0.000000000000000_REALK,    -47.537382726835013_REALK,      0.000000000000000_REALK, &
     -4.914558755769198_REALK,      0.000000000000000_REALK,     -2.473263741013678_REALK, &
    -10.116422787771246_REALK,    -12.281086167230217_REALK,      0.000000000000000_REALK, &
    -17.073398030948258_REALK,      0.000000000000000_REALK,     -2.183100857830562_REALK, &
    -27.816670084525246_REALK,      0.000000000000000_REALK,     -2.821936321564456_REALK, &
      0.000000000000000_REALK,    -59.010054936074546_REALK,      0.000000000000000_REALK, &
     -5.080860069219417_REALK,      0.000000000000000_REALK,     -1.949628150688869_REALK, &
    -11.826478777157389_REALK,     -7.768728937206862_REALK,      0.000000000000000_REALK, &
     -6.964918004213374_REALK,      0.000000000000000_REALK,     -1.801430427520978_REALK, &
     -7.580415086024245_REALK,      0.000000000000000_REALK,     -1.429107296497797_REALK, &
      0.000000000000000_REALK,    -10.945851075183873_REALK,      0.000000000000000_REALK, &
     -1.766211770641655_REALK,      0.000000000000000_REALK,     -1.373712034350430_REALK, &
     -7.893061374088836_REALK,     -4.653833911916534_REALK,      0.000000000000000_REALK, &
     -3.293909068220489_REALK,      0.000000000000000_REALK,     -1.075385476761460_REALK, &
     -2.027856632827342_REALK,      0.000000000000000_REALK,     -0.806410841626892_REALK, &
      0.000000000000000_REALK,      0.718737011467801_REALK,      0.000000000000000_REALK, &
     -0.769489859408791_REALK,      0.000000000000000_REALK,     -0.749977842714324_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.063980817085645_REALK, &
      0.000000000000000_REALK,      1.880668809998360_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.282543881147532_REALK,      0.000000000000000_REALK, &
      1.137055931028092_REALK,      0.000000000000000_REALK,      3.806377385621883_REALK, &
      0.000000000000000_REALK,      1.421694571617315_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.458826240085779_REALK, &
      0.000000000000000_REALK,      2.518776495770343_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.328808542342817_REALK,      0.000000000000000_REALK, &
      1.266815091613222_REALK,      0.000000000000000_REALK,      5.741967664092380_REALK, &
      0.000000000000000_REALK,      1.740457216784627_REALK,      0.000000000000000_REALK, &
    -11.762539531274339_REALK,     -6.033574030414698_REALK,      0.000000000000000_REALK, &
     -4.558063300285288_REALK,      0.000000000000000_REALK,     -1.563060414943460_REALK, &
     -4.223768247194715_REALK,      0.000000000000000_REALK,     -0.955027613030405_REALK, &
      0.000000000000000_REALK,     -5.253848001911000_REALK,      0.000000000000000_REALK, &
     -0.955146934549315_REALK,      0.000000000000000_REALK,     -0.985050175211538_REALK, &
     -5.784155621274731_REALK,     -3.811560150285515_REALK,      0.000000000000000_REALK, &
     -3.370568034238114_REALK,      0.000000000000000_REALK,     -0.938116748853171_REALK, &
     -3.827169131830009_REALK,      0.000000000000000_REALK,     -0.642358087670516_REALK, &
      0.000000000000000_REALK,     -6.029716253978249_REALK,      0.000000000000000_REALK, &
     -0.673533014377545_REALK,      0.000000000000000_REALK,     -0.562535794244589_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.569235050706688_REALK, &
      0.000000000000000_REALK,      1.046786191525140_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.962012882216843_REALK,      0.000000000000000_REALK, &
      0.743776422357606_REALK,      0.000000000000000_REALK,      1.157269114429428_REALK, &
      0.000000000000000_REALK,      0.654483649391462_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.129807013675348_REALK, &
      0.000000000000000_REALK,      0.769324756378224_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.577706089480575_REALK,      0.000000000000000_REALK, &
      0.571105132526029_REALK,      0.000000000000000_REALK,      0.369576958465532_REALK, &
      0.000000000000000_REALK,      0.460355365398872_REALK,      0.000000000000000_REALK, &
     -2.119628422444594_REALK,     -1.670059518008506_REALK,      0.000000000000000_REALK, &
     -1.702479891744941_REALK,      0.000000000000000_REALK,     -0.842231437260167_REALK, &
     -2.123520475382535_REALK,      0.000000000000000_REALK,     -0.788750746155548_REALK, &
      0.000000000000000_REALK,     -3.434145818085716_REALK,      0.000000000000000_REALK, &
     -1.057025027051648_REALK,      0.000000000000000_REALK,     -0.873861343830210_REALK, &
     -2.439423010753736_REALK,     -2.662820664008847_REALK,      0.000000000000000_REALK, &
     -3.242694190885478_REALK,      0.000000000000000_REALK,     -1.229072916889063_REALK, &
     -4.510492136803507_REALK,      0.000000000000000_REALK,     -1.361416765950956_REALK, &
      0.000000000000000_REALK,     -7.568721158674587_REALK,      0.000000000000000_REALK, &
     -1.941370744720000_REALK,      0.000000000000000_REALK,     -1.226272256160744_REALK, &
    -14.262802568635314_REALK,     -5.572387820099273_REALK,      0.000000000000000_REALK, &
     -3.523066083023344_REALK,      0.000000000000000_REALK,     -1.625849057179017_REALK, &
     -2.633501443037800_REALK,      0.000000000000000_REALK,     -0.747996137394499_REALK, &
      0.000000000000000_REALK,     -2.583937790138643_REALK,      0.000000000000000_REALK, &
     -0.605517063337707_REALK,      0.000000000000000_REALK,     -0.839560336678767_REALK, &
    -11.541819461043632_REALK,     -4.031581882239244_REALK,      0.000000000000000_REALK, &
     -1.941531724877215_REALK,      0.000000000000000_REALK,     -1.116300463515107_REALK, &
     -0.688340189748566_REALK,      0.000000000000000_REALK,     -0.475961028267450_REALK, &
      0.000000000000000_REALK,      0.716121573050333_REALK,      0.000000000000000_REALK, &
     -0.289600436216665_REALK,      0.000000000000000_REALK,     -0.495757455556109_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.590835820114196_REALK, &
      0.000000000000000_REALK,      0.816156961925367_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.623400722435218_REALK,      0.000000000000000_REALK, &
      0.639126315488657_REALK,      0.000000000000000_REALK,      0.616724441297237_REALK, &
      0.000000000000000_REALK,      0.418010766102047_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.623743033055766_REALK, &
      0.000000000000000_REALK,      0.867302211164740_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.692942214515115_REALK,      0.000000000000000_REALK, &
      0.570741218245745_REALK,      0.000000000000000_REALK,      0.768437141817958_REALK, &
      0.000000000000000_REALK,      0.381718871994483_REALK,      0.000000000000000_REALK, &
     -1.883139922182468_REALK,     -1.082277001508655_REALK,      0.000000000000000_REALK, &
     -0.832338976098759_REALK,      0.000000000000000_REALK,     -0.641145611469271_REALK, &
     -0.765934154752881_REALK,      0.000000000000000_REALK,     -0.433194297029432_REALK, &
      0.000000000000000_REALK,     -0.872377802175455_REALK,      0.000000000000000_REALK, &
     -0.424159011864146_REALK,      0.000000000000000_REALK,     -0.545371722851101_REALK, &
     -2.697501665130007_REALK,     -1.339674319336066_REALK,      0.000000000000000_REALK, &
     -0.765658436028439_REALK,      0.000000000000000_REALK,     -0.773650503964975_REALK, &
     -0.347201155035007_REALK,      0.000000000000000_REALK,     -0.470479263909892_REALK, &
      0.000000000000000_REALK,      0.213448538174628_REALK,      0.000000000000000_REALK, &
     -0.339009902242202_REALK,      0.000000000000000_REALK,     -0.567005135957185_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.879515972835633_REALK, &
      0.000000000000000_REALK,      0.691972926831170_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.713303828644578_REALK,      0.000000000000000_REALK, &
      0.585378506454571_REALK,      0.000000000000000_REALK,      0.946575279692320_REALK, &
      0.000000000000000_REALK,      0.584491859248414_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.228732365862973_REALK, &
      0.000000000000000_REALK,      1.903666910448010_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.057617222593565_REALK,      0.000000000000000_REALK, &
      1.290794387101535_REALK,      0.000000000000000_REALK,      2.757335683879216_REALK, &
      0.000000000000000_REALK,      1.381915004473810_REALK,      0.000000000000000_REALK, &
    -20.920264106671464_REALK,     -6.145703499496180_REALK,      0.000000000000000_REALK, &
     -3.371921932173607_REALK,      0.000000000000000_REALK,     -2.029824584776315_REALK, &
     -2.074373105738240_REALK,      0.000000000000000_REALK,     -0.690380589513809_REALK, &
      0.000000000000000_REALK,     -1.752130511310801_REALK,      0.000000000000000_REALK, &
     -0.469630568581469_REALK,      0.000000000000000_REALK,     -0.848759764354042_REALK, &
    -12.027911301228441_REALK,     -4.485077040637533_REALK,      0.000000000000000_REALK, &
     -2.806873545353361_REALK,      0.000000000000000_REALK,     -1.470645185254401_REALK, &
     -2.282590063595810_REALK,      0.000000000000000_REALK,     -0.543588537600701_REALK, &
      0.000000000000000_REALK,     -2.880074703277287_REALK,      0.000000000000000_REALK, &
     -0.371296790618754_REALK,      0.000000000000000_REALK,     -0.582889629830332_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.987684721200201_REALK, &
      0.000000000000000_REALK,      0.768070646826871_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.483483081484591_REALK,      0.000000000000000_REALK, &
      0.668248289278413_REALK,      0.000000000000000_REALK,      0.373562964199099_REALK, &
      0.000000000000000_REALK,      0.318709760900531_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.652614025182110_REALK, &
      0.000000000000000_REALK,      0.673276283252738_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.346245566932018_REALK,      0.000000000000000_REALK, &
      0.601181188319737_REALK,      0.000000000000000_REALK,      0.121027512778679_REALK, &
      0.000000000000000_REALK,      0.266450542226421_REALK,      0.000000000000000_REALK, &
     -2.284714152884662_REALK,     -1.013085011235222_REALK,      0.000000000000000_REALK, &
     -0.648279028600823_REALK,      0.000000000000000_REALK,     -0.662046943717648_REALK, &
     -0.501156036278397_REALK,      0.000000000000000_REALK,     -0.339227129715954_REALK, &
      0.000000000000000_REALK,     -0.491992098943007_REALK,      0.000000000000000_REALK, &
     -0.267606135902489_REALK,      0.000000000000000_REALK,     -0.456213659905042_REALK, &
     -2.170200144471901_REALK,     -1.284969010263954_REALK,      0.000000000000000_REALK, &
     -0.993189220289085_REALK,      0.000000000000000_REALK,     -0.814516124786278_REALK, &
     -0.959296152235448_REALK,      0.000000000000000_REALK,     -0.471399048179676_REALK, &
      0.000000000000000_REALK,     -1.216725789497713_REALK,      0.000000000000000_REALK, &
     -0.394103560002318_REALK,      0.000000000000000_REALK,     -0.537937216613596_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.801635503444237_REALK, &
      0.000000000000000_REALK,      0.455072930964759_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.348542459284277_REALK,      0.000000000000000_REALK, &
      0.446531699958414_REALK,      0.000000000000000_REALK,      0.330682933516045_REALK, &
      0.000000000000000_REALK,      0.311799599994359_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.148769414028415_REALK, &
      0.000000000000000_REALK,      0.673979583729064_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.414735176366398_REALK,      0.000000000000000_REALK, &
      0.702000618451292_REALK,      0.000000000000000_REALK,      0.189507910271326_REALK, &
      0.000000000000000_REALK,      0.444631472900361_REALK,      0.000000000000000_REALK, &
     -1.290309179133929_REALK,     -0.878421697745482_REALK,      0.000000000000000_REALK, &
     -0.760855825015779_REALK,      0.000000000000000_REALK,     -0.620828367000258_REALK, &
     -0.792873262432901_REALK,      0.000000000000000_REALK,     -0.487412927807034_REALK, &
      0.000000000000000_REALK,     -1.016141277938864_REALK,      0.000000000000000_REALK, &
     -0.518157299918791_REALK,      0.000000000000000_REALK,     -0.593262638166191_REALK, &
     -2.890788820389528_REALK,     -2.815185205909322_REALK,      0.000000000000000_REALK, &
     -2.979744068722490_REALK,      0.000000000000000_REALK,     -1.865516608160571_REALK, &
     -3.485604491457952_REALK,      0.000000000000000_REALK,     -1.741875106729155_REALK, &
      0.000000000000000_REALK,     -4.644290144217697_REALK,      0.000000000000000_REALK, &
     -1.974063907493770_REALK,      0.000000000000000_REALK,     -1.728910986152601_REALK, &
    -42.838619967265814_REALK,     -8.748118025693151_REALK,      0.000000000000000_REALK, &
     -4.150781314730213_REALK,      0.000000000000000_REALK,     -3.248569670096303_REALK, &
     -1.949588896594482_REALK,      0.000000000000000_REALK,     -0.768287967188727_REALK, &
      0.000000000000000_REALK,     -1.351224028861727_REALK,      0.000000000000000_REALK, &
     -0.445197774039435_REALK,      0.000000000000000_REALK,     -1.044765103543673_REALK, &
    -74.213734046704715_REALK,    -13.366413614520134_REALK,      0.000000000000000_REALK, &
     -4.422187841214953_REALK,      0.000000000000000_REALK,     -4.531253231177699_REALK, &
     -0.505774605496704_REALK,      0.000000000000000_REALK,     -0.922238930229049_REALK, &
      0.000000000000000_REALK,      1.651864391829677_REALK,      0.000000000000000_REALK, &
     -0.358352801494173_REALK,      0.000000000000000_REALK,     -1.090513941652895_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.375027412122606_REALK, &
      0.000000000000000_REALK,      0.936311545107735_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.491230954144128_REALK,      0.000000000000000_REALK, &
      0.886424585267694_REALK,      0.000000000000000_REALK,      0.298780292182143_REALK, &
      0.000000000000000_REALK,      0.298757419147865_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.714111865598812_REALK, &
      0.000000000000000_REALK,      1.806059252638122_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.897051756242641_REALK,      0.000000000000000_REALK, &
      1.382865008202473_REALK,      0.000000000000000_REALK,      0.623707023851098_REALK, &
      0.000000000000000_REALK,      0.431535073403150_REALK,      0.000000000000000_REALK, &
     -4.046883484339177_REALK,     -1.297431915111319_REALK,      0.000000000000000_REALK, &
     -0.662970521518779_REALK,      0.000000000000000_REALK,     -0.914512890485573_REALK, &
     -0.396447774166019_REALK,      0.000000000000000_REALK,     -0.339079375460346_REALK, &
      0.000000000000000_REALK,     -0.297425390478262_REALK,      0.000000000000000_REALK, &
     -0.210557063820650_REALK,      0.000000000000000_REALK,     -0.484481805263592_REALK, &
    -11.026565863472820_REALK,     -3.103152653516411_REALK,      0.000000000000000_REALK, &
     -1.117962816255861_REALK,      0.000000000000000_REALK,     -2.009055078099000_REALK, &
     -0.236658872922220_REALK,      0.000000000000000_REALK,     -0.638194721989501_REALK, &
      0.000000000000000_REALK,      0.346756787783070_REALK,      0.000000000000000_REALK, &
     -0.268915739091375_REALK,      0.000000000000000_REALK,     -0.798991025738715_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.127907181092728_REALK, &
      0.000000000000000_REALK,      0.471416899505679_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.288587944949791_REALK,      0.000000000000000_REALK, &
      0.489977714040230_REALK,      0.000000000000000_REALK,      0.220094166278132_REALK, &
      0.000000000000000_REALK,      0.248137424473610_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.878946304098479_REALK, &
      0.000000000000000_REALK,      1.625009788834499_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.985017526272259_REALK,      0.000000000000000_REALK, &
      1.322753560013158_REALK,      0.000000000000000_REALK,      0.798913302435328_REALK, &
      0.000000000000000_REALK,      0.641708901451971_REALK,      0.000000000000000_REALK, &
     -1.670167521224820_REALK,     -0.785966140796035_REALK,      0.000000000000000_REALK, &
     -0.489497682748539_REALK,      0.000000000000000_REALK,     -0.625373087097034_REALK, &
     -0.360291700596892_REALK,      0.000000000000000_REALK,     -0.339979185872921_REALK, &
      0.000000000000000_REALK,     -0.314915260092992_REALK,      0.000000000000000_REALK, &
     -0.256523350513284_REALK,      0.000000000000000_REALK,     -0.459352757775527_REALK, &
     -8.012528565384637_REALK,     -3.214484532292544_REALK,      0.000000000000000_REALK, &
     -1.385759135915046_REALK,      0.000000000000000_REALK,     -2.421789492751673_REALK, &
     -0.409073344277297_REALK,      0.000000000000000_REALK,     -1.095941820380973_REALK, &
      0.000000000000000_REALK,      0.335442434154187_REALK,      0.000000000000000_REALK, &
     -0.551129725655147_REALK,      0.000000000000000_REALK,     -1.338665168419267_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.083429083813291_REALK, &
      0.000000000000000_REALK,      0.694203285368530_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.574925328984496_REALK,      0.000000000000000_REALK, &
      0.653984160154905_REALK,      0.000000000000000_REALK,      0.589831177416033_REALK, &
      0.000000000000000_REALK,      0.506368357254470_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      9.321926232898241_REALK, &
      0.000000000000000_REALK,      6.240449439707191_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.084630759073558_REALK,      0.000000000000000_REALK, &
      4.417943623636977_REALK,      0.000000000000000_REALK,      4.914292589503020_REALK, &
      0.000000000000000_REALK,      3.420735533738353_REALK,      0.000000000000000_REALK, &
    -24.243386859411977_REALK,     -4.965104042503837_REALK,      0.000000000000000_REALK, &
    -20.687381617997701_REALK,      0.000000000000000_REALK,    -10.079134975665980_REALK, &
     -9.771030973762892_REALK,      0.000000000000000_REALK,     -2.392355275191879_REALK, &
      0.000000000000000_REALK,   -128.014975591981397_REALK,      0.000000000000000_REALK, &
    -25.072414538404132_REALK,      0.000000000000000_REALK,    -36.518742497786384_REALK, &
     -8.752497415498537_REALK,     -2.515750695927051_REALK,      0.000000000000000_REALK, &
    -13.093162940406332_REALK,      0.000000000000000_REALK,     -4.750442823138759_REALK, &
     -8.268577487517422_REALK,      0.000000000000000_REALK,     -1.720890358165545_REALK, &
      0.000000000000000_REALK,   -112.544017763800682_REALK,      0.000000000000000_REALK, &
    -18.485857085641790_REALK,      0.000000000000000_REALK,    -19.975072149392144_REALK, &
    -18.941375003517912_REALK,     -4.278538874240892_REALK,      0.000000000000000_REALK, &
     -8.953110296107837_REALK,      0.000000000000000_REALK,     -7.021258089837556_REALK, &
     -4.999261874716023_REALK,      0.000000000000000_REALK,     -1.781080852076459_REALK, &
      0.000000000000000_REALK,    -30.222451121074599_REALK,      0.000000000000000_REALK, &
     -9.405796902802303_REALK,      0.000000000000000_REALK,    -22.123380900158704_REALK, &
     -6.984613105869713_REALK,     -1.748535213894340_REALK,      0.000000000000000_REALK, &
     -2.655617058535992_REALK,      0.000000000000000_REALK,     -2.692701751009653_REALK, &
     -0.890853542419370_REALK,      0.000000000000000_REALK,     -0.819082285171920_REALK, &
      0.000000000000000_REALK,      1.313374622461172_REALK,      0.000000000000000_REALK, &
     -3.021798564206402_REALK,      0.000000000000000_REALK,     -9.252510211102459_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.481308474178052_REALK, &
      0.000000000000000_REALK,      2.704070906783233_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.164991714916819_REALK,      0.000000000000000_REALK, &
      3.110130339143326_REALK,      0.000000000000000_REALK,     11.683644555687934_REALK, &
      0.000000000000000_REALK,      8.560553758945712_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.749593982390598_REALK, &
      0.000000000000000_REALK,      2.340161672670028_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.325318406569690_REALK,      0.000000000000000_REALK, &
      2.478285896617546_REALK,      0.000000000000000_REALK,     13.091926184156796_REALK, &
      0.000000000000000_REALK,      8.132727415924034_REALK,      0.000000000000000_REALK, &
    -19.654024159704665_REALK,     -3.058907206156781_REALK,      0.000000000000000_REALK, &
     -5.928063622743777_REALK,      0.000000000000000_REALK,     -6.219480759325222_REALK, &
     -2.656755669480403_REALK,      0.000000000000000_REALK,     -1.123156776499961_REALK, &
      0.000000000000000_REALK,    -13.719336741263058_REALK,      0.000000000000000_REALK, &
     -5.100902945318386_REALK,      0.000000000000000_REALK,    -16.052344275902950_REALK, &
     -5.978071090395022_REALK,     -1.317152893755346_REALK,      0.000000000000000_REALK, &
     -2.371731368493863_REALK,      0.000000000000000_REALK,     -2.455087458852820_REALK, &
     -1.762324721803646_REALK,      0.000000000000000_REALK,     -0.587553795814887_REALK, &
      0.000000000000000_REALK,     -8.863704600115970_REALK,      0.000000000000000_REALK, &
     -2.151799497183783_REALK,      0.000000000000000_REALK,     -6.674103252471628_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.713216990141251_REALK, &
      0.000000000000000_REALK,      1.317750958666069_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.276213833702454_REALK,      0.000000000000000_REALK, &
      2.994323774118091_REALK,      0.000000000000000_REALK,      3.169988856613526_REALK, &
      0.000000000000000_REALK,      3.395849776539928_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.402847781691817_REALK, &
      0.000000000000000_REALK,      0.716024037849389_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.601051853005612_REALK,      0.000000000000000_REALK, &
      1.887184347338265_REALK,      0.000000000000000_REALK,      0.653309442928461_REALK, &
      0.000000000000000_REALK,      1.951165030078350_REALK,      0.000000000000000_REALK, &
     -2.426370579671250_REALK,     -1.086712017070817_REALK,      0.000000000000000_REALK, &
     -1.617385148308764_REALK,      0.000000000000000_REALK,     -2.313352251089761_REALK, &
     -1.652413609346314_REALK,      0.000000000000000_REALK,     -1.204982779673755_REALK, &
      0.000000000000000_REALK,     -7.155884882712091_REALK,      0.000000000000000_REALK, &
     -4.165432278973409_REALK,      0.000000000000000_REALK,     -9.932480259138000_REALK, &
     -1.682528872602896_REALK,     -1.254584183582280_REALK,      0.000000000000000_REALK, &
     -2.067324038267073_REALK,      0.000000000000000_REALK,     -2.193719235762032_REALK, &
     -2.800093425912757_REALK,      0.000000000000000_REALK,     -1.730266514785276_REALK, &
      0.000000000000000_REALK,    -11.651599993258278_REALK,      0.000000000000000_REALK, &
     -5.685576558771626_REALK,      0.000000000000000_REALK,    -10.031603704041553_REALK, &
    -25.298085531394893_REALK,     -1.392702286357465_REALK,      0.000000000000000_REALK, &
     -5.291978478027612_REALK,      0.000000000000000_REALK,     -6.648848604421881_REALK, &
     -0.732574502914417_REALK,      0.000000000000000_REALK,     -0.441462772850079_REALK, &
      0.000000000000000_REALK,     -8.146423104101530_REALK,      0.000000000000000_REALK, &
     -3.561513804728310_REALK,      0.000000000000000_REALK,    -13.397810779336247_REALK, &
    -12.546890301122275_REALK,     -0.531183300051494_REALK,      0.000000000000000_REALK, &
     -1.892847737092385_REALK,      0.000000000000000_REALK,     -3.099967624146244_REALK, &
      0.355635627376768_REALK,      0.000000000000000_REALK,     -0.170832343304625_REALK, &
      0.000000000000000_REALK,     -0.003147349389724_REALK,      0.000000000000000_REALK, &
     -1.193920727405305_REALK,      0.000000000000000_REALK,     -5.836662840600773_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.321131409048200_REALK, &
      0.000000000000000_REALK,      0.738278493208371_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.999813602153376_REALK,      0.000000000000000_REALK, &
      3.160028483859693_REALK,      0.000000000000000_REALK,      1.162163012592033_REALK, &
      0.000000000000000_REALK,      1.477989318050216_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.237308940398036_REALK, &
      0.000000000000000_REALK,      0.533271834914418_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.697003099784198_REALK,      0.000000000000000_REALK, &
      2.153339435530923_REALK,      0.000000000000000_REALK,      1.011856689019062_REALK, &
      0.000000000000000_REALK,      0.998269754132211_REALK,      0.000000000000000_REALK, &
     -2.514802549471314_REALK,     -0.726831565071596_REALK,      0.000000000000000_REALK, &
     -0.844805558202006_REALK,      0.000000000000000_REALK,     -1.980811253711500_REALK, &
     -0.642454163061520_REALK,      0.000000000000000_REALK,     -0.692130489783530_REALK, &
      0.000000000000000_REALK,     -1.789744123112691_REALK,      0.000000000000000_REALK, &
     -1.687261429699682_REALK,      0.000000000000000_REALK,     -6.595126771955372_REALK, &
     -2.349410496928330_REALK,     -0.667998215801778_REALK,      0.000000000000000_REALK, &
     -0.538352093743075_REALK,      0.000000000000000_REALK,     -1.724443235267145_REALK, &
     -0.185217204493099_REALK,      0.000000000000000_REALK,     -0.643079862431364_REALK, &
      0.000000000000000_REALK,      0.362600350962831_REALK,      0.000000000000000_REALK, &
     -1.010408138348838_REALK,      0.000000000000000_REALK,     -5.373303666563381_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.290490472141517_REALK, &
      0.000000000000000_REALK,      0.809580365458379_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.867710088227305_REALK,      0.000000000000000_REALK, &
      2.049002488565835_REALK,      0.000000000000000_REALK,      2.209811599872817_REALK, &
      0.000000000000000_REALK,      2.681923202757329_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.131509192108711_REALK, &
      0.000000000000000_REALK,      1.624504563793425_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.954459991779067_REALK,      0.000000000000000_REALK, &
      3.412121533736086_REALK,      0.000000000000000_REALK,      4.905136905662802_REALK, &
      0.000000000000000_REALK,      5.035934781079574_REALK,      0.000000000000000_REALK, &
    -39.412468981159350_REALK,      1.514619935918711_REALK,      0.000000000000000_REALK, &
     -6.455273371652825_REALK,      0.000000000000000_REALK,     -8.455182048363934_REALK, &
      1.252642855637329_REALK,      0.000000000000000_REALK,      0.401149964727634_REALK, &
      0.000000000000000_REALK,     -7.567691448985491_REALK,      0.000000000000000_REALK, &
     -3.266095914774834_REALK,      0.000000000000000_REALK,    -12.791676809312181_REALK, &
    -16.588417871758807_REALK,      0.979491481323215_REALK,      0.000000000000000_REALK, &
     -3.262467299470215_REALK,      0.000000000000000_REALK,     -4.605935126208379_REALK, &
      0.390470395628706_REALK,      0.000000000000000_REALK,      0.295287231090160_REALK, &
      0.000000000000000_REALK,     -4.842718825734395_REALK,      0.000000000000000_REALK, &
     -1.523561168656182_REALK,      0.000000000000000_REALK,     -6.443165299564805_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.657535169401509_REALK, &
      0.000000000000000_REALK,      0.299150742637393_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.974593898154125_REALK,      0.000000000000000_REALK, &
      3.702721990351014_REALK,      0.000000000000000_REALK,      0.246131973579323_REALK, &
      0.000000000000000_REALK,      0.448962971186083_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.053812066805040_REALK, &
      0.000000000000000_REALK,      0.158827543693044_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.550537045385607_REALK,      0.000000000000000_REALK, &
      2.770946664230979_REALK,      0.000000000000000_REALK,     -0.172858398578852_REALK, &
      0.000000000000000_REALK,      0.221554353304494_REALK,      0.000000000000000_REALK, &
     -3.380714995525646_REALK,     -0.531585854037370_REALK,      0.000000000000000_REALK, &
     -0.684082740110168_REALK,      0.000000000000000_REALK,     -2.166836607159651_REALK, &
     -0.329217228428568_REALK,      0.000000000000000_REALK,     -0.421775344288930_REALK, &
      0.000000000000000_REALK,     -0.908617344062408_REALK,      0.000000000000000_REALK, &
     -1.021991173958517_REALK,      0.000000000000000_REALK,     -5.389784591703632_REALK, &
     -2.395689619390342_REALK,     -0.533436696722635_REALK,      0.000000000000000_REALK, &
     -0.667105987642702_REALK,      0.000000000000000_REALK,     -2.057622319821351_REALK, &
     -0.505668471201588_REALK,      0.000000000000000_REALK,     -0.489526473243893_REALK, &
      0.000000000000000_REALK,     -1.347851264294812_REALK,      0.000000000000000_REALK, &
     -0.930419926022683_REALK,      0.000000000000000_REALK,     -4.779583057312371_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.440434036821441_REALK, &
      0.000000000000000_REALK,      0.482173052526012_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.487467098978414_REALK,      0.000000000000000_REALK, &
      1.903446212575481_REALK,      0.000000000000000_REALK,      0.661862625008604_REALK, &
      0.000000000000000_REALK,      1.190510013848876_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.733089205991145_REALK, &
      0.000000000000000_REALK,      0.619483838253337_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.488054248120068_REALK,      0.000000000000000_REALK, &
      2.655327021670584_REALK,      0.000000000000000_REALK,      0.229812971459342_REALK, &
      0.000000000000000_REALK,      1.436843547945018_REALK,      0.000000000000000_REALK, &
     -1.348665349935052_REALK,     -0.603017593332633_REALK,      0.000000000000000_REALK, &
     -0.611576538724937_REALK,      0.000000000000000_REALK,     -1.436746591885040_REALK, &
     -0.657918347392163_REALK,      0.000000000000000_REALK,     -0.795507589686502_REALK, &
      0.000000000000000_REALK,     -1.558569903666188_REALK,      0.000000000000000_REALK, &
     -1.502003085273904_REALK,      0.000000000000000_REALK,     -4.951629394516562_REALK, &
     -2.235350601565102_REALK,     -1.648093022580633_REALK,      0.000000000000000_REALK, &
     -1.914430535719666_REALK,      0.000000000000000_REALK,     -3.328543269918292_REALK, &
     -2.507559193561577_REALK,      0.000000000000000_REALK,     -2.563850400946221_REALK, &
      0.000000000000000_REALK,     -5.509706385862384_REALK,      0.000000000000000_REALK, &
     -4.447535574016817_REALK,      0.000000000000000_REALK,    -10.821586954685086_REALK, &
    -79.973556721484584_REALK,      8.823420798726509_REALK,      0.000000000000000_REALK, &
    -10.733389734201543_REALK,      0.000000000000000_REALK,    -13.111099112102570_REALK, &
      4.654250791970008_REALK,      0.000000000000000_REALK,      1.826393173523853_REALK, &
      0.000000000000000_REALK,     -9.772485262076437_REALK,      0.000000000000000_REALK, &
     -3.864266948242967_REALK,      0.000000000000000_REALK,    -14.119274205918600_REALK, &
    -99.686685803552848_REALK,     12.138167538377161_REALK,      0.000000000000000_REALK, &
     -9.508596338606543_REALK,      0.000000000000000_REALK,    -13.182496380369910_REALK, &
      5.302500530865628_REALK,      0.000000000000000_REALK,      1.999309133583718_REALK, &
      0.000000000000000_REALK,     -3.810433350988036_REALK,      0.000000000000000_REALK, &
     -2.386704739944583_REALK,      0.000000000000000_REALK,     -9.864617647149945_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.058090831366570_REALK, &
      0.000000000000000_REALK,     -0.325164267712256_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.264020921810580_REALK,      0.000000000000000_REALK, &
      5.000390249677414_REALK,      0.000000000000000_REALK,     -0.356677681601969_REALK, &
      0.000000000000000_REALK,     -0.343191667944057_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     11.740576565302932_REALK, &
      0.000000000000000_REALK,     -0.525681771724091_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.363647368911271_REALK,      0.000000000000000_REALK, &
      5.796169860246465_REALK,      0.000000000000000_REALK,     -0.151190283642121_REALK, &
      0.000000000000000_REALK,     -0.387917114689763_REALK,      0.000000000000000_REALK, &
     -6.125057861656575_REALK,     -0.290680060557037_REALK,      0.000000000000000_REALK, &
     -0.781859816425399_REALK,      0.000000000000000_REALK,     -2.987444182778002_REALK, &
     -0.095970093620859_REALK,      0.000000000000000_REALK,     -0.179686977337299_REALK, &
      0.000000000000000_REALK,     -0.621561255755329_REALK,      0.000000000000000_REALK, &
     -0.829944193642068_REALK,      0.000000000000000_REALK,     -5.268631640940791_REALK, &
    -12.620121297929616_REALK,     -0.395472552059158_REALK,      0.000000000000000_REALK, &
     -0.954866522690467_REALK,      0.000000000000000_REALK,     -4.968215911249034_REALK, &
      0.198040037395564_REALK,      0.000000000000000_REALK,     -0.196126709968399_REALK, &
      0.000000000000000_REALK,      0.135989809050234_REALK,      0.000000000000000_REALK, &
     -0.711320167472721_REALK,      0.000000000000000_REALK,     -6.094736029626645_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.138718663559724_REALK, &
      0.000000000000000_REALK,      0.346271038988357_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.414997739954995_REALK,      0.000000000000000_REALK, &
      2.195927539115257_REALK,      0.000000000000000_REALK,      0.282690882349555_REALK, &
      0.000000000000000_REALK,      0.604850966616913_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.529262321645290_REALK, &
      0.000000000000000_REALK,      0.906174550545425_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.884539883649371_REALK,      0.000000000000000_REALK, &
      4.511442787590917_REALK,      0.000000000000000_REALK,      0.693971081613248_REALK, &
      0.000000000000000_REALK,      1.099140796347459_REALK,      0.000000000000000_REALK, &
     -1.949201141957826_REALK,     -0.485815846211685_REALK,      0.000000000000000_REALK, &
     -0.403225628298310_REALK,      0.000000000000000_REALK,     -1.573984579868346_REALK, &
     -0.274649870199339_REALK,      0.000000000000000_REALK,     -0.496585560007524_REALK, &
      0.000000000000000_REALK,     -0.442434162933508_REALK,      0.000000000000000_REALK, &
     -0.701437268349822_REALK,      0.000000000000000_REALK,     -3.833958977906132_REALK, &
     -7.585352003127644_REALK,     -1.685841735486895_REALK,      0.000000000000000_REALK, &
     -0.878798228359586_REALK,      0.000000000000000_REALK,     -4.944458160355213_REALK, &
     -0.173789790513175_REALK,      0.000000000000000_REALK,     -1.372936334370915_REALK, &
      0.000000000000000_REALK,      0.381468608288845_REALK,      0.000000000000000_REALK, &
     -1.076422022969101_REALK,      0.000000000000000_REALK,     -8.378963196650435_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.460955265037958_REALK, &
      0.000000000000000_REALK,      0.669654667840309_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.637863637170845_REALK,      0.000000000000000_REALK, &
      2.086293282348103_REALK,      0.000000000000000_REALK,      0.955423651234530_REALK, &
      0.000000000000000_REALK,      1.615379953366784_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      9.451590903117793_REALK, &
      0.000000000000000_REALK,      4.950973473889797_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.445658751565199_REALK,      0.000000000000000_REALK, &
     10.700607722836216_REALK,      0.000000000000000_REALK,      5.809420900692983_REALK, &
      0.000000000000000_REALK,      8.285291119212491_REALK,      0.000000000000000_REALK/
  ! results of test 3, ket-major order, POT.E H2
  data REF_CONTR_INTS(2521:3780)                                                           &
    /-6.475054034855385_REALK,     -5.800524531349403_REALK,      0.000000000000000_REALK, &
     -6.734540506640443_REALK,      0.000000000000000_REALK,     -1.069185843641872_REALK, &
     -9.619789122898490_REALK,      0.000000000000000_REALK,     -1.158595266850848_REALK, &
      0.000000000000000_REALK,    -18.696876825861768_REALK,      0.000000000000000_REALK, &
     -1.871333265559280_REALK,      0.000000000000000_REALK,     -0.890072309131191_REALK, &
     -2.000708912970137_REALK,     -5.180307532736234_REALK,      0.000000000000000_REALK, &
     -8.259857798449822_REALK,      0.000000000000000_REALK,     -1.006931907913462_REALK, &
    -13.844658572090024_REALK,      0.000000000000000_REALK,     -1.358317912957781_REALK, &
      0.000000000000000_REALK,    -28.650639899273969_REALK,      0.000000000000000_REALK, &
     -2.396889377773061_REALK,      0.000000000000000_REALK,     -0.877435686048540_REALK, &
     -4.916261429359829_REALK,     -3.202163742250891_REALK,      0.000000000000000_REALK, &
     -2.778528432989277_REALK,      0.000000000000000_REALK,     -0.705448166179611_REALK, &
     -2.890789945173093_REALK,      0.000000000000000_REALK,     -0.549299141402312_REALK, &
      0.000000000000000_REALK,     -3.814683349467285_REALK,      0.000000000000000_REALK, &
     -0.634592359702622_REALK,      0.000000000000000_REALK,     -0.483268950045660_REALK, &
     -5.639547686622895_REALK,     -2.596532080460112_REALK,      0.000000000000000_REALK, &
     -1.451392502511139_REALK,      0.000000000000000_REALK,     -0.533923248679754_REALK, &
     -0.461823658430362_REALK,      0.000000000000000_REALK,     -0.358639165001459_REALK, &
      0.000000000000000_REALK,      1.565006231093058_REALK,      0.000000000000000_REALK, &
     -0.282151845217903_REALK,      0.000000000000000_REALK,     -0.317856686228269_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.915083465426907_REALK, &
      0.000000000000000_REALK,      0.830936430881007_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.991160030036263_REALK,      0.000000000000000_REALK, &
      0.471916177883412_REALK,      0.000000000000000_REALK,      1.581785522292748_REALK, &
      0.000000000000000_REALK,      0.571294623184813_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.548552069953444_REALK, &
      0.000000000000000_REALK,      1.444742753805810_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.811721084668042_REALK,      0.000000000000000_REALK, &
      0.664884946413499_REALK,      0.000000000000000_REALK,      2.976500727782485_REALK, &
      0.000000000000000_REALK,      0.876334874672063_REALK,      0.000000000000000_REALK, &
     -5.042781965072079_REALK,     -2.562073459670756_REALK,      0.000000000000000_REALK, &
     -1.873524077741408_REALK,      0.000000000000000_REALK,     -0.629293560955062_REALK, &
     -1.673977622861604_REALK,      0.000000000000000_REALK,     -0.375741473143194_REALK, &
      0.000000000000000_REALK,     -1.958626697567390_REALK,      0.000000000000000_REALK, &
     -0.351818546463994_REALK,      0.000000000000000_REALK,     -0.354330095042455_REALK, &
     -1.006790316377221_REALK,     -1.509989865874719_REALK,      0.000000000000000_REALK, &
     -1.613662243881318_REALK,      0.000000000000000_REALK,     -0.416956173400685_REALK, &
     -1.994083541241920_REALK,      0.000000000000000_REALK,     -0.303618276541537_REALK, &
      0.000000000000000_REALK,     -3.266413226480317_REALK,      0.000000000000000_REALK, &
     -0.321431865309293_REALK,      0.000000000000000_REALK,     -0.249786074218837_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.696336281885249_REALK, &
      0.000000000000000_REALK,      0.456083320380011_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.402708368003699_REALK,      0.000000000000000_REALK, &
      0.306720900241601_REALK,      0.000000000000000_REALK,      0.451345042915758_REALK, &
      0.000000000000000_REALK,      0.257345060274631_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.448553271223797_REALK, &
      0.000000000000000_REALK,      0.343758002469892_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.240235415187656_REALK,      0.000000000000000_REALK, &
      0.270281068788062_REALK,      0.000000000000000_REALK,      0.083043342224129_REALK, &
      0.000000000000000_REALK,      0.205598577263257_REALK,      0.000000000000000_REALK, &
     -1.041171840138623_REALK,     -0.818357568214921_REALK,      0.000000000000000_REALK, &
     -0.820935824478244_REALK,      0.000000000000000_REALK,     -0.391211922457292_REALK, &
     -1.000365371306445_REALK,      0.000000000000000_REALK,     -0.361583907272652_REALK, &
      0.000000000000000_REALK,     -1.547968680317665_REALK,      0.000000000000000_REALK, &
     -0.464966270436837_REALK,      0.000000000000000_REALK,     -0.368797400099123_REALK, &
     -0.683991497381909_REALK,     -1.280065688634292_REALK,      0.000000000000000_REALK, &
     -1.766012935261523_REALK,      0.000000000000000_REALK,     -0.646323547941831_REALK, &
     -2.529940697236918_REALK,      0.000000000000000_REALK,     -0.744964455121186_REALK, &
      0.000000000000000_REALK,     -4.180496768662649_REALK,      0.000000000000000_REALK, &
     -1.049744790763765_REALK,      0.000000000000000_REALK,     -0.640952662204571_REALK, &
     -6.547918733606255_REALK,     -2.498249517251356_REALK,      0.000000000000000_REALK, &
     -1.505741149638765_REALK,      0.000000000000000_REALK,     -0.690127268452537_REALK, &
     -1.065536668450139_REALK,      0.000000000000000_REALK,     -0.306831018737461_REALK, &
      0.000000000000000_REALK,     -0.953669633136039_REALK,      0.000000000000000_REALK, &
     -0.229742711558155_REALK,      0.000000000000000_REALK,     -0.315880255722904_REALK, &
     -8.955310565925046_REALK,     -2.611101574654767_REALK,      0.000000000000000_REALK, &
     -1.023957260365239_REALK,      0.000000000000000_REALK,     -0.643307824212911_REALK, &
     -0.155511314514438_REALK,      0.000000000000000_REALK,     -0.245157848755839_REALK, &
      0.000000000000000_REALK,      0.811826305772980_REALK,      0.000000000000000_REALK, &
     -0.123677650911070_REALK,      0.000000000000000_REALK,     -0.238035602884446_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.741347373298263_REALK, &
      0.000000000000000_REALK,      0.371135741494361_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.271462786050155_REALK,      0.000000000000000_REALK, &
      0.273520132989976_REALK,      0.000000000000000_REALK,      0.252852989808389_REALK, &
      0.000000000000000_REALK,      0.170253060556992_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.108746226065144_REALK, &
      0.000000000000000_REALK,      0.538016533083025_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.406505084268139_REALK,      0.000000000000000_REALK, &
      0.318234277533870_REALK,      0.000000000000000_REALK,      0.439951041953671_REALK, &
      0.000000000000000_REALK,      0.201772499403530_REALK,      0.000000000000000_REALK, &
     -0.953851188192413_REALK,     -0.536363570323388_REALK,      0.000000000000000_REALK, &
     -0.397298315973870_REALK,      0.000000000000000_REALK,     -0.302646429348406_REALK, &
     -0.347968226258101_REALK,      0.000000000000000_REALK,     -0.198302202242039_REALK, &
      0.000000000000000_REALK,     -0.366041123693377_REALK,      0.000000000000000_REALK, &
     -0.182546548157402_REALK,      0.000000000000000_REALK,     -0.231715661247987_REALK, &
     -2.166331368429473_REALK,     -0.915912657228825_REALK,      0.000000000000000_REALK, &
     -0.437324157863082_REALK,      0.000000000000000_REALK,     -0.479712609067167_REALK, &
     -0.118117297819030_REALK,      0.000000000000000_REALK,     -0.262472549550192_REALK, &
      0.000000000000000_REALK,      0.284195919660213_REALK,      0.000000000000000_REALK, &
     -0.160646687487226_REALK,      0.000000000000000_REALK,     -0.299392080201679_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.459190716297184_REALK, &
      0.000000000000000_REALK,      0.355805278547658_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.357159543880235_REALK,      0.000000000000000_REALK, &
      0.283607412917968_REALK,      0.000000000000000_REALK,      0.454010915181807_REALK, &
      0.000000000000000_REALK,      0.273429835477996_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.641865511638202_REALK, &
      0.000000000000000_REALK,      1.291991670303677_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.314706516662214_REALK,      0.000000000000000_REALK, &
      0.805275390788860_REALK,      0.000000000000000_REALK,      1.670106100265133_REALK, &
      0.000000000000000_REALK,      0.820396697612380_REALK,      0.000000000000000_REALK, &
    -10.287875193095383_REALK,     -2.958012316882712_REALK,      0.000000000000000_REALK, &
     -1.545089481015689_REALK,      0.000000000000000_REALK,     -0.927518690868174_REALK, &
     -0.903191908868815_REALK,      0.000000000000000_REALK,     -0.303365392697600_REALK, &
      0.000000000000000_REALK,     -0.706754610463890_REALK,      0.000000000000000_REALK, &
     -0.190287181221397_REALK,      0.000000000000000_REALK,     -0.342672819736247_REALK, &
     -2.356999538360061_REALK,     -1.858542038151738_REALK,      0.000000000000000_REALK, &
     -1.436776837938672_REALK,      0.000000000000000_REALK,     -0.706701194401750_REALK, &
     -1.330977671577222_REALK,      0.000000000000000_REALK,     -0.281472276160118_REALK, &
      0.000000000000000_REALK,     -1.819762538806198_REALK,      0.000000000000000_REALK, &
     -0.197099836217382_REALK,      0.000000000000000_REALK,     -0.292019347656359_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.985899273254307_REALK, &
      0.000000000000000_REALK,      0.370198988468222_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.220846955931028_REALK,      0.000000000000000_REALK, &
      0.303660237408523_REALK,      0.000000000000000_REALK,      0.158596421201469_REALK, &
      0.000000000000000_REALK,      0.137026415923034_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.693608165367038_REALK, &
      0.000000000000000_REALK,      0.328449187941583_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.162661497375437_REALK,      0.000000000000000_REALK, &
      0.314050274964016_REALK,      0.000000000000000_REALK,      0.024607497032308_REALK, &
      0.000000000000000_REALK,      0.135450973587049_REALK,      0.000000000000000_REALK, &
     -1.215606187422737_REALK,     -0.529335223451028_REALK,      0.000000000000000_REALK, &
     -0.327019738001761_REALK,      0.000000000000000_REALK,     -0.329638367803086_REALK, &
     -0.242547467074409_REALK,      0.000000000000000_REALK,     -0.163354711605394_REALK, &
      0.000000000000000_REALK,     -0.224983382131136_REALK,      0.000000000000000_REALK, &
     -0.121280175963195_REALK,      0.000000000000000_REALK,     -0.203643013296431_REALK, &
     -0.568408875718911_REALK,     -0.604983338057430_REALK,      0.000000000000000_REALK, &
     -0.556555376931015_REALK,      0.000000000000000_REALK,     -0.432150119003013_REALK, &
     -0.583019167976822_REALK,      0.000000000000000_REALK,     -0.266959078678078_REALK, &
      0.000000000000000_REALK,     -0.767460226137118_REALK,      0.000000000000000_REALK, &
     -0.227479589028198_REALK,      0.000000000000000_REALK,     -0.295314405912644_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.431210057082077_REALK, &
      0.000000000000000_REALK,      0.238573717649140_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.174910578836706_REALK,      0.000000000000000_REALK, &
      0.222060015706106_REALK,      0.000000000000000_REALK,      0.155492549146898_REALK, &
      0.000000000000000_REALK,      0.147707459850890_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.538613031501576_REALK, &
      0.000000000000000_REALK,      0.356321396335771_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.212162118665706_REALK,      0.000000000000000_REALK, &
      0.396284473119114_REALK,      0.000000000000000_REALK,      0.061179669472720_REALK, &
      0.000000000000000_REALK,      0.243335633259654_REALK,      0.000000000000000_REALK, &
     -0.750690547829268_REALK,     -0.505579586330020_REALK,      0.000000000000000_REALK, &
     -0.428381333507847_REALK,      0.000000000000000_REALK,     -0.340533615342010_REALK, &
     -0.433319815527923_REALK,      0.000000000000000_REALK,     -0.261201332856619_REALK, &
      0.000000000000000_REALK,     -0.531551926585463_REALK,      0.000000000000000_REALK, &
     -0.266247988829263_REALK,      0.000000000000000_REALK,     -0.295900066127477_REALK, &
     -1.020530635269673_REALK,     -1.522833170729139_REALK,      0.000000000000000_REALK, &
     -1.823147645200726_REALK,      0.000000000000000_REALK,     -1.112792340282788_REALK, &
     -2.217422807168409_REALK,      0.000000000000000_REALK,     -1.088841414112628_REALK, &
      0.000000000000000_REALK,     -2.948865139823757_REALK,      0.000000000000000_REALK, &
     -1.234953636029108_REALK,      0.000000000000000_REALK,     -1.056697994754662_REALK, &
    -25.499975332622263_REALK,     -4.945937863548582_REALK,      0.000000000000000_REALK, &
     -2.181081468303148_REALK,      0.000000000000000_REALK,     -1.714494951282524_REALK, &
     -0.951922239792401_REALK,      0.000000000000000_REALK,     -0.381727677011189_REALK, &
      0.000000000000000_REALK,     -0.593679650788401_REALK,      0.000000000000000_REALK, &
     -0.200643848449411_REALK,      0.000000000000000_REALK,     -0.473342163608163_REALK, &
    -66.927565288687703_REALK,    -11.137333508945600_REALK,      0.000000000000000_REALK, &
     -3.283495504493205_REALK,      0.000000000000000_REALK,     -3.515907030101126_REALK, &
     -0.100991783220374_REALK,      0.000000000000000_REALK,     -0.655688395675304_REALK, &
      0.000000000000000_REALK,      1.588377263210389_REALK,      0.000000000000000_REALK, &
     -0.218961542063004_REALK,      0.000000000000000_REALK,     -0.716059580852087_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.950726619762516_REALK, &
      0.000000000000000_REALK,      0.514079437085273_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.251205382874037_REALK,      0.000000000000000_REALK, &
      0.452403533755280_REALK,      0.000000000000000_REALK,      0.141196027868260_REALK, &
      0.000000000000000_REALK,      0.142271381089950_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.690731386488245_REALK, &
      0.000000000000000_REALK,      1.437511758916920_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.675290510270131_REALK,      0.000000000000000_REALK, &
      1.014150162177404_REALK,      0.000000000000000_REALK,      0.456514858666496_REALK, &
      0.000000000000000_REALK,      0.295284346550891_REALK,      0.000000000000000_REALK, &
     -2.536011239737384_REALK,     -0.776226339523889_REALK,      0.000000000000000_REALK, &
     -0.373577398384227_REALK,      0.000000000000000_REALK,     -0.513708007695488_REALK, &
     -0.209046871149012_REALK,      0.000000000000000_REALK,     -0.180470227968937_REALK, &
      0.000000000000000_REALK,     -0.143463664744238_REALK,      0.000000000000000_REALK, &
     -0.103560649403425_REALK,      0.000000000000000_REALK,     -0.237325814084380_REALK, &
    -10.063618949482638_REALK,     -2.638399125586320_REALK,      0.000000000000000_REALK, &
     -0.859666365991297_REALK,      0.000000000000000_REALK,     -1.603346671958007_REALK, &
     -0.116279855326900_REALK,      0.000000000000000_REALK,     -0.470456348762660_REALK, &
      0.000000000000000_REALK,      0.347428275965219_REALK,      0.000000000000000_REALK, &
     -0.173858966329965_REALK,      0.000000000000000_REALK,     -0.548928717358004_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.689656431183263_REALK, &
      0.000000000000000_REALK,      0.275513909848339_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.159337976014816_REALK,      0.000000000000000_REALK, &
      0.267727897701801_REALK,      0.000000000000000_REALK,      0.113717017687523_REALK, &
      0.000000000000000_REALK,      0.127648337282194_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.360483814126467_REALK, &
      0.000000000000000_REALK,      1.333222638729039_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.768536025854108_REALK,      0.000000000000000_REALK, &
      1.009045702165064_REALK,      0.000000000000000_REALK,      0.597338291090294_REALK, &
      0.000000000000000_REALK,      0.461014222298406_REALK,      0.000000000000000_REALK, &
     -1.101930889161515_REALK,     -0.497427461192733_REALK,      0.000000000000000_REALK, &
     -0.294358772968989_REALK,      0.000000000000000_REALK,     -0.373822718077221_REALK, &
     -0.204008975274395_REALK,      0.000000000000000_REALK,     -0.193653553724631_REALK, &
      0.000000000000000_REALK,     -0.164638648156998_REALK,      0.000000000000000_REALK, &
     -0.136661452168998_REALK,      0.000000000000000_REALK,     -0.242906656132237_REALK, &
     -7.394800439302272_REALK,     -2.782217785373888_REALK,      0.000000000000000_REALK, &
     -1.096892685844989_REALK,      0.000000000000000_REALK,     -1.984251660269341_REALK, &
     -0.245041934136763_REALK,      0.000000000000000_REALK,     -0.834161281568759_REALK, &
      0.000000000000000_REALK,      0.360236324677476_REALK,      0.000000000000000_REALK, &
     -0.373272563147878_REALK,      0.000000000000000_REALK,     -0.959335344270729_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.707411227055810_REALK, &
      0.000000000000000_REALK,      0.437582420867717_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.347402335711120_REALK,      0.000000000000000_REALK, &
      0.386752907766172_REALK,      0.000000000000000_REALK,      0.338477130228143_REALK, &
      0.000000000000000_REALK,      0.285659456055447_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.290482769298805_REALK, &
      0.000000000000000_REALK,      5.296537784115438_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.109924786643884_REALK,      0.000000000000000_REALK, &
      3.534088992398855_REALK,      0.000000000000000_REALK,      3.765172175288479_REALK, &
      0.000000000000000_REALK,      2.595229745867702_REALK,      0.000000000000000_REALK, &
     -6.977458377941071_REALK,     -2.217875227134714_REALK,      0.000000000000000_REALK, &
     -6.346619402079518_REALK,      0.000000000000000_REALK,     -2.883964821734311_REALK, &
     -4.340514882973180_REALK,      0.000000000000000_REALK,     -1.034779002410029_REALK, &
      0.000000000000000_REALK,    -39.587449557745479_REALK,      0.000000000000000_REALK, &
     -7.475839040999775_REALK,      0.000000000000000_REALK,    -10.180298872927398_REALK, &
     -0.948213914736912_REALK,     -1.046801458206759_REALK,      0.000000000000000_REALK, &
     -5.088800211596912_REALK,      0.000000000000000_REALK,     -1.703971873029380_REALK, &
     -4.672925457943174_REALK,      0.000000000000000_REALK,     -0.940954821101382_REALK, &
      0.000000000000000_REALK,    -45.811717699799708_REALK,      0.000000000000000_REALK, &
     -7.252779261207147_REALK,      0.000000000000000_REALK,     -7.288150199249039_REALK, &
     -5.765971985183943_REALK,     -1.593398864978154_REALK,      0.000000000000000_REALK, &
     -2.626908201997696_REALK,      0.000000000000000_REALK,     -2.053858992517365_REALK, &
     -1.755306773906767_REALK,      0.000000000000000_REALK,     -0.647972443487884_REALK, &
      0.000000000000000_REALK,     -7.834708077271154_REALK,      0.000000000000000_REALK, &
     -2.571144363352106_REALK,      0.000000000000000_REALK,     -6.032252692814475_REALK, &
     -4.346077542130598_REALK,     -0.927379836741113_REALK,      0.000000000000000_REALK, &
     -0.854800306033896_REALK,      0.000000000000000_REALK,     -1.034272788336281_REALK, &
     -0.093361206034962_REALK,      0.000000000000000_REALK,     -0.348625060390958_REALK, &
      0.000000000000000_REALK,      3.024330775052639_REALK,      0.000000000000000_REALK, &
     -0.850910185389883_REALK,      0.000000000000000_REALK,     -3.166022503832500_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.988591282582816_REALK, &
      0.000000000000000_REALK,      0.944592640400410_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.884619977295821_REALK,      0.000000000000000_REALK, &
      1.207925628456552_REALK,      0.000000000000000_REALK,      3.902211043275642_REALK, &
      0.000000000000000_REALK,      2.785447924651540_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.055994298744855_REALK, &
      0.000000000000000_REALK,      1.102720156795904_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.233756294342154_REALK,      0.000000000000000_REALK, &
      1.247167196218099_REALK,      0.000000000000000_REALK,      5.720064052009501_REALK, &
      0.000000000000000_REALK,      3.442722648595157_REALK,      0.000000000000000_REALK, &
     -6.499705514564723_REALK,     -1.111611911272946_REALK,      0.000000000000000_REALK, &
     -1.805988662559440_REALK,      0.000000000000000_REALK,     -1.930579443691034_REALK, &
     -0.898369723488862_REALK,      0.000000000000000_REALK,     -0.391975164556808_REALK, &
      0.000000000000000_REALK,     -3.642975761078401_REALK,      0.000000000000000_REALK, &
     -1.386595948730026_REALK,      0.000000000000000_REALK,     -4.449180875515078_REALK, &
     -0.421832855487036_REALK,     -0.459538853522481_REALK,      0.000000000000000_REALK, &
     -0.917337623532466_REALK,      0.000000000000000_REALK,     -0.913535246497597_REALK, &
     -0.875791510360618_REALK,      0.000000000000000_REALK,     -0.257033447411146_REALK, &
      0.000000000000000_REALK,     -4.003813568369378_REALK,      0.000000000000000_REALK, &
     -0.797204170276026_REALK,      0.000000000000000_REALK,     -2.376819797462833_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.039497113413540_REALK, &
      0.000000000000000_REALK,      0.464551425216096_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.469432371167889_REALK,      0.000000000000000_REALK, &
      1.100944182156318_REALK,      0.000000000000000_REALK,      0.967668787284932_REALK, &
      0.000000000000000_REALK,      1.073927180643534_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.508908460762505_REALK, &
      0.000000000000000_REALK,      0.281322674628451_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.230723931395087_REALK,      0.000000000000000_REALK, &
      0.845860368078187_REALK,      0.000000000000000_REALK,      0.040285977401348_REALK, &
      0.000000000000000_REALK,      0.729510085000337_REALK,      0.000000000000000_REALK, &
     -0.968223878368847_REALK,     -0.475630222800589_REALK,      0.000000000000000_REALK, &
     -0.635101994530322_REALK,      0.000000000000000_REALK,     -0.866701107299193_REALK, &
     -0.707261446882463_REALK,      0.000000000000000_REALK,     -0.505402570725297_REALK, &
      0.000000000000000_REALK,     -2.601364157027006_REALK,      0.000000000000000_REALK, &
     -1.474120097625903_REALK,      0.000000000000000_REALK,     -3.347108215902055_REALK, &
     -0.338317642511569_REALK,     -0.570682590841975_REALK,      0.000000000000000_REALK, &
     -1.014363447411266_REALK,      0.000000000000000_REALK,     -1.021205933177546_REALK, &
     -1.509955384558655_REALK,      0.000000000000000_REALK,     -0.910500787366595_REALK, &
      0.000000000000000_REALK,     -5.557790074082431_REALK,      0.000000000000000_REALK, &
     -2.641113753209271_REALK,      0.000000000000000_REALK,     -4.427642625708664_REALK, &
     -9.281132759604123_REALK,     -0.512556634870754_REALK,      0.000000000000000_REALK, &
     -1.719869661464833_REALK,      0.000000000000000_REALK,     -2.236413940462615_REALK, &
     -0.225490329780310_REALK,      0.000000000000000_REALK,     -0.151791671585068_REALK, &
      0.000000000000000_REALK,     -2.144980809039273_REALK,      0.000000000000000_REALK, &
     -0.991545984138596_REALK,      0.000000000000000_REALK,     -3.872608702805439_REALK, &
     -8.960339078324411_REALK,     -0.275016664311923_REALK,      0.000000000000000_REALK, &
     -0.804177781338748_REALK,      0.000000000000000_REALK,     -1.472828452304730_REALK, &
      0.312963636722292_REALK,      0.000000000000000_REALK,     -0.067013044128401_REALK, &
      0.000000000000000_REALK,      0.724534774484879_REALK,      0.000000000000000_REALK, &
     -0.395308470455501_REALK,      0.000000000000000_REALK,     -2.221060978594002_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.312544711973247_REALK, &
      0.000000000000000_REALK,      0.274679677901220_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.364387370658479_REALK,      0.000000000000000_REALK, &
      1.168525806088719_REALK,      0.000000000000000_REALK,      0.364209401142791_REALK, &
      0.000000000000000_REALK,      0.477082126445514_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.351523628127645_REALK, &
      0.000000000000000_REALK,      0.280966534345975_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.349550817144264_REALK,      0.000000000000000_REALK, &
      1.048144928799515_REALK,      0.000000000000000_REALK,      0.492603614473042_REALK, &
      0.000000000000000_REALK,      0.430828574329085_REALK,      0.000000000000000_REALK, &
     -1.062449424168730_REALK,     -0.314955279800480_REALK,      0.000000000000000_REALK, &
     -0.328878563623460_REALK,      0.000000000000000_REALK,     -0.771287029028800_REALK, &
     -0.253730653075959_REALK,      0.000000000000000_REALK,     -0.281109675271868_REALK, &
      0.000000000000000_REALK,     -0.581498562213048_REALK,      0.000000000000000_REALK, &
     -0.572098921894589_REALK,      0.000000000000000_REALK,     -2.236837160913812_REALK, &
     -1.769929553139195_REALK,     -0.412940302122773_REALK,      0.000000000000000_REALK, &
     -0.256588997514072_REALK,      0.000000000000000_REALK,     -0.923459302746637_REALK, &
     -0.027766956457694_REALK,      0.000000000000000_REALK,     -0.321807968777352_REALK, &
      0.000000000000000_REALK,      0.439911432576178_REALK,      0.000000000000000_REALK, &
     -0.383188382468889_REALK,      0.000000000000000_REALK,     -2.360862717515998_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.586395507427328_REALK, &
      0.000000000000000_REALK,      0.353819954536087_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.384171114601680_REALK,      0.000000000000000_REALK, &
      0.873911099161363_REALK,      0.000000000000000_REALK,      0.866743065063040_REALK, &
      0.000000000000000_REALK,      1.031423366989161_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.435694784883766_REALK, &
      0.000000000000000_REALK,      0.978875426962037_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.141102584986896_REALK,      0.000000000000000_REALK, &
      1.921675463164767_REALK,      0.000000000000000_REALK,      2.545314768891493_REALK, &
      0.000000000000000_REALK,      2.555301872139191_REALK,      0.000000000000000_REALK, &
    -16.116397370535338_REALK,      0.651654453310555_REALK,      0.000000000000000_REALK, &
     -2.329971281220313_REALK,      0.000000000000000_REALK,     -3.138419034897523_REALK, &
      0.483771048048471_REALK,      0.000000000000000_REALK,      0.157758242545013_REALK, &
      0.000000000000000_REALK,     -2.203373476989359_REALK,      0.000000000000000_REALK, &
     -0.978072410925676_REALK,      0.000000000000000_REALK,     -3.956564053029755_REALK, &
     -2.440798860498911_REALK,      0.376038760299586_REALK,      0.000000000000000_REALK, &
     -1.429695788018771_REALK,      0.000000000000000_REALK,     -2.020841107022931_REALK, &
      0.070464386906060_REALK,      0.000000000000000_REALK,      0.138765033469423_REALK, &
      0.000000000000000_REALK,     -2.387032304167026_REALK,      0.000000000000000_REALK, &
     -0.631592836738075_REALK,      0.000000000000000_REALK,     -2.673789728618766_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.968734755666484_REALK, &
      0.000000000000000_REALK,      0.117553153733625_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.366307172383487_REALK,      0.000000000000000_REALK, &
      1.429098290123861_REALK,      0.000000000000000_REALK,      0.073289249115177_REALK, &
      0.000000000000000_REALK,      0.148453811651035_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.219643834864997_REALK, &
      0.000000000000000_REALK,      0.063892518152924_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.240122892828227_REALK,      0.000000000000000_REALK, &
      1.340943567654665_REALK,      0.000000000000000_REALK,     -0.139589581647407_REALK, &
      0.000000000000000_REALK,      0.084207330804914_REALK,      0.000000000000000_REALK, &
     -1.541729135805584_REALK,     -0.241278953399222_REALK,      0.000000000000000_REALK, &
     -0.281944480094365_REALK,      0.000000000000000_REALK,     -0.903926382929058_REALK, &
     -0.134136137175322_REALK,      0.000000000000000_REALK,     -0.175564749716113_REALK, &
      0.000000000000000_REALK,     -0.312570878633888_REALK,      0.000000000000000_REALK, &
     -0.356879110282344_REALK,      0.000000000000000_REALK,     -1.908149260126578_REALK, &
     -0.535073756608506_REALK,     -0.241115120341420_REALK,      0.000000000000000_REALK, &
     -0.340346064283282_REALK,      0.000000000000000_REALK,     -1.018291472609580_REALK, &
     -0.294052048718831_REALK,      0.000000000000000_REALK,     -0.259061554341736_REALK, &
      0.000000000000000_REALK,     -0.748683134924053_REALK,      0.000000000000000_REALK, &
     -0.449962382202162_REALK,      0.000000000000000_REALK,     -2.240189993704424_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.676608315004079_REALK, &
      0.000000000000000_REALK,      0.217153348819588_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.210231488728062_REALK,      0.000000000000000_REALK, &
      0.821739043167401_REALK,      0.000000000000000_REALK,      0.248865476503021_REALK, &
      0.000000000000000_REALK,      0.460052146512035_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.796358649859613_REALK, &
      0.000000000000000_REALK,      0.313333120915282_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.232716947046270_REALK,      0.000000000000000_REALK, &
      1.420754955257779_REALK,      0.000000000000000_REALK,      0.026922210624968_REALK, &
      0.000000000000000_REALK,      0.687849621618004_REALK,      0.000000000000000_REALK, &
     -0.686865674267156_REALK,     -0.309255276520533_REALK,      0.000000000000000_REALK, &
     -0.296254063688292_REALK,      0.000000000000000_REALK,     -0.674410629333868_REALK, &
     -0.316609680763968_REALK,      0.000000000000000_REALK,     -0.377099060149698_REALK, &
      0.000000000000000_REALK,     -0.667383604843317_REALK,      0.000000000000000_REALK, &
     -0.630541832732729_REALK,      0.000000000000000_REALK,     -2.005641943532439_REALK, &
     -0.724707845675074_REALK,     -0.876402859815479_REALK,      0.000000000000000_REALK, &
     -1.123176011206353_REALK,      0.000000000000000_REALK,     -1.886994625000923_REALK, &
     -1.520473883828373_REALK,      0.000000000000000_REALK,     -1.528230866374179_REALK, &
      0.000000000000000_REALK,     -3.121145963585816_REALK,      0.000000000000000_REALK, &
     -2.473957484086337_REALK,      0.000000000000000_REALK,     -5.814678119671066_REALK, &
    -39.894789341232972_REALK,      4.266613202927286_REALK,      0.000000000000000_REALK, &
     -4.538030245754472_REALK,      0.000000000000000_REALK,     -5.625219281066644_REALK, &
      1.919478423567959_REALK,      0.000000000000000_REALK,      0.764234307235441_REALK, &
      0.000000000000000_REALK,     -3.233979020006789_REALK,      0.000000000000000_REALK, &
     -1.298220287407091_REALK,      0.000000000000000_REALK,     -4.831771584746433_REALK, &
    -86.191620542932441_REALK,      9.537945356479627_REALK,      0.000000000000000_REALK, &
     -6.433238910240664_REALK,      0.000000000000000_REALK,     -9.106451134623082_REALK, &
      3.456418200613014_REALK,      0.000000000000000_REALK,      1.270555115737416_REALK, &
      0.000000000000000_REALK,     -1.424259462710557_REALK,      0.000000000000000_REALK, &
     -1.203641185456703_REALK,      0.000000000000000_REALK,     -5.151655698120453_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.927168178809443_REALK, &
      0.000000000000000_REALK,     -0.154460188681993_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.522489103364541_REALK,      0.000000000000000_REALK, &
      2.111387453802845_REALK,      0.000000000000000_REALK,     -0.136362072415401_REALK, &
      0.000000000000000_REALK,     -0.133464158329837_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      9.255463004752139_REALK, &
      0.000000000000000_REALK,     -0.375408493423810_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.872439656648936_REALK,      0.000000000000000_REALK, &
      3.703492810818301_REALK,      0.000000000000000_REALK,     -0.039095452799611_REALK, &
      0.000000000000000_REALK,     -0.213838729468685_REALK,      0.000000000000000_REALK, &
     -3.292904673991612_REALK,     -0.146826080975436_REALK,      0.000000000000000_REALK, &
     -0.359164349620862_REALK,      0.000000000000000_REALK,     -1.399939974190053_REALK, &
     -0.039230652577606_REALK,      0.000000000000000_REALK,     -0.079086789749718_REALK, &
      0.000000000000000_REALK,     -0.223484240275114_REALK,      0.000000000000000_REALK, &
     -0.309644817678991_REALK,      0.000000000000000_REALK,     -2.014469767504174_REALK, &
    -11.126260126365686_REALK,     -0.303751863982706_REALK,      0.000000000000000_REALK, &
     -0.660069029837654_REALK,      0.000000000000000_REALK,     -3.596242863178016_REALK, &
      0.175436987675888_REALK,      0.000000000000000_REALK,     -0.119283236001607_REALK, &
      0.000000000000000_REALK,      0.204824042684751_REALK,      0.000000000000000_REALK, &
     -0.371397872806639_REALK,      0.000000000000000_REALK,     -3.438806697359101_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.125711018211610_REALK, &
      0.000000000000000_REALK,      0.171572333377759_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.189695308071607_REALK,      0.000000000000000_REALK, &
      1.013634479458734_REALK,      0.000000000000000_REALK,      0.113558078051161_REALK, &
      0.000000000000000_REALK,      0.247815655610964_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.507060349937953_REALK, &
      0.000000000000000_REALK,      0.681939233730380_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.609317014986698_REALK,      0.000000000000000_REALK, &
      3.055671931207183_REALK,      0.000000000000000_REALK,      0.448783411249199_REALK, &
      0.000000000000000_REALK,      0.661685434635046_REALK,      0.000000000000000_REALK, &
     -1.125276279548999_REALK,     -0.269456323287703_REALK,      0.000000000000000_REALK, &
     -0.205200920932775_REALK,      0.000000000000000_REALK,     -0.801911886060316_REALK, &
     -0.131966652029074_REALK,      0.000000000000000_REALK,     -0.243529690378335_REALK, &
      0.000000000000000_REALK,     -0.181313496925277_REALK,      0.000000000000000_REALK, &
     -0.296955304676318_REALK,      0.000000000000000_REALK,     -1.625247543227606_REALK, &
     -6.809605952830680_REALK,     -1.382103388045659_REALK,      0.000000000000000_REALK, &
     -0.630807239622207_REALK,      0.000000000000000_REALK,     -3.737524650690471_REALK, &
     -0.059294475158947_REALK,      0.000000000000000_REALK,     -0.938292646932702_REALK, &
      0.000000000000000_REALK,      0.382027357802911_REALK,      0.000000000000000_REALK, &
     -0.597407735133834_REALK,      0.000000000000000_REALK,     -5.077901525067995_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.834708333780068_REALK, &
      0.000000000000000_REALK,      0.366572210056888_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.332281808393528_REALK,      0.000000000000000_REALK, &
      1.058938262528163_REALK,      0.000000000000000_REALK,      0.448541995086094_REALK, &
      0.000000000000000_REALK,      0.747602655850467_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.009347160499136_REALK, &
      0.000000000000000_REALK,      3.925037591742840_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.284076577040961_REALK,      0.000000000000000_REALK, &
      7.765090379965753_REALK,      0.000000000000000_REALK,      3.860936099765312_REALK, &
      0.000000000000000_REALK,      5.436672811760498_REALK,      0.000000000000000_REALK/
  ! results of test 4, ket-major order, NEF 001
  data REF_CONTR_INTS(3781:5040)                                                           &
    /14.554349854482110_REALK,     14.683762851640999_REALK,      0.000000000000000_REALK, &
     17.582304618668317_REALK,      0.000000000000000_REALK,      1.781630175215623_REALK, &
     24.724136314492043_REALK,      0.000000000000000_REALK,      2.102817973071729_REALK, &
      0.000000000000000_REALK,     43.699327673386748_REALK,      0.000000000000000_REALK, &
      3.323154690718732_REALK,      0.000000000000000_REALK,      1.146355694838967_REALK, &
     28.479953995081331_REALK,     27.326729473821597_REALK,      0.000000000000000_REALK, &
     32.554767942784316_REALK,      0.000000000000000_REALK,      2.375363832159666_REALK, &
     46.436570688737262_REALK,      0.000000000000000_REALK,      3.037330239166937_REALK, &
      0.000000000000000_REALK,     81.268280805408139_REALK,      0.000000000000000_REALK, &
      4.944927834309054_REALK,      0.000000000000000_REALK,      1.285457615266595_REALK, &
      8.690987645265093_REALK,      6.698545530611775_REALK,      0.000000000000000_REALK, &
      6.142329550356543_REALK,      0.000000000000000_REALK,      0.983535244014621_REALK, &
      6.440094128144096_REALK,      0.000000000000000_REALK,      0.869303229476703_REALK, &
      0.000000000000000_REALK,      7.976806368176971_REALK,      0.000000000000000_REALK, &
      1.012940272101981_REALK,      0.000000000000000_REALK,      0.549410907205543_REALK, &
      4.362158676019086_REALK,      4.031827541862591_REALK,      0.000000000000000_REALK, &
      2.843477910427990_REALK,      0.000000000000000_REALK,      0.683805252204123_REALK, &
      0.619251031237635_REALK,      0.000000000000000_REALK,      0.552748533140840_REALK, &
      0.000000000000000_REALK,     -4.430381970509194_REALK,      0.000000000000000_REALK, &
      0.432198741932907_REALK,      0.000000000000000_REALK,      0.362386307120635_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.625815625500515_REALK, &
      0.000000000000000_REALK,     -1.654789715008216_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.040145879763376_REALK,      0.000000000000000_REALK, &
     -0.658158474436788_REALK,      0.000000000000000_REALK,     -3.139768409242399_REALK, &
      0.000000000000000_REALK,     -0.847792467448279_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.323186223737946_REALK, &
      0.000000000000000_REALK,     -2.954198874255495_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.086386387019033_REALK,      0.000000000000000_REALK, &
     -0.987945293831924_REALK,      0.000000000000000_REALK,     -6.560587971769175_REALK, &
      0.000000000000000_REALK,     -1.397869317702264_REALK,      0.000000000000000_REALK, &
      7.608607366119871_REALK,      4.865696764752329_REALK,      0.000000000000000_REALK, &
      3.886003577492846_REALK,      0.000000000000000_REALK,      0.769484633294753_REALK, &
      3.658502133773020_REALK,      0.000000000000000_REALK,      0.552213111144300_REALK, &
      0.000000000000000_REALK,      4.216070440402266_REALK,      0.000000000000000_REALK, &
      0.539814269610166_REALK,      0.000000000000000_REALK,      0.366342381325579_REALK, &
     10.099885817588108_REALK,      6.447930098063905_REALK,      0.000000000000000_REALK, &
      5.526725611361021_REALK,      0.000000000000000_REALK,      0.706961625145824_REALK, &
      6.136274019754467_REALK,      0.000000000000000_REALK,      0.549922710386609_REALK, &
      0.000000000000000_REALK,      8.901956874829978_REALK,      0.000000000000000_REALK, &
      0.589795447918986_REALK,      0.000000000000000_REALK,      0.277534730680239_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.002137097922978_REALK, &
      0.000000000000000_REALK,     -0.767986307277289_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.715511191046252_REALK,      0.000000000000000_REALK, &
     -0.363398601993408_REALK,      0.000000000000000_REALK,     -0.798495098282086_REALK, &
      0.000000000000000_REALK,     -0.340429861521786_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.179375133281152_REALK, &
      0.000000000000000_REALK,     -0.735665962108674_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.447673823553619_REALK,      0.000000000000000_REALK, &
     -0.345715070343996_REALK,      0.000000000000000_REALK,     -0.091474302518328_REALK, &
      0.000000000000000_REALK,     -0.270735629861005_REALK,      0.000000000000000_REALK, &
      1.966608003527661_REALK,      1.779412918765904_REALK,      0.000000000000000_REALK, &
      1.891055993886821_REALK,      0.000000000000000_REALK,      0.570089048380173_REALK, &
      2.328348822817748_REALK,      0.000000000000000_REALK,      0.587611710371620_REALK, &
      0.000000000000000_REALK,      3.435371268477184_REALK,      0.000000000000000_REALK, &
      0.770978181368279_REALK,      0.000000000000000_REALK,      0.436781280124511_REALK, &
      6.427777950444342_REALK,      5.596341502155122_REALK,      0.000000000000000_REALK, &
      5.884866074960099_REALK,      0.000000000000000_REALK,      1.290508088896388_REALK, &
      7.272890429479679_REALK,      0.000000000000000_REALK,      1.418451046798271_REALK, &
      0.000000000000000_REALK,     10.619543119518921_REALK,      0.000000000000000_REALK, &
      1.909891369020216_REALK,      0.000000000000000_REALK,      0.817428953288361_REALK, &
      8.019454329636098_REALK,      4.156572670602194_REALK,      0.000000000000000_REALK, &
      2.774349454215272_REALK,      0.000000000000000_REALK,      0.725460090263254_REALK, &
      2.129515197409430_REALK,      0.000000000000000_REALK,      0.412460595660688_REALK, &
      0.000000000000000_REALK,      1.902439673719690_REALK,      0.000000000000000_REALK, &
      0.327111080016462_REALK,      0.000000000000000_REALK,      0.293299361938498_REALK, &
      3.920467993331965_REALK,      2.612160297665647_REALK,      0.000000000000000_REALK, &
      1.416812717717609_REALK,      0.000000000000000_REALK,      0.510312466618294_REALK, &
      0.106699086121473_REALK,      0.000000000000000_REALK,      0.282320253736492_REALK, &
      0.000000000000000_REALK,     -1.897966111111284_REALK,      0.000000000000000_REALK, &
      0.156004046084358_REALK,      0.000000000000000_REALK,      0.199294897740307_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.893135480892635_REALK, &
      0.000000000000000_REALK,     -0.561877229588488_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.450159831623530_REALK,      0.000000000000000_REALK, &
     -0.284035285137442_REALK,      0.000000000000000_REALK,     -0.439408340342954_REALK, &
      0.000000000000000_REALK,     -0.210276551098707_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.848747674383291_REALK, &
      0.000000000000000_REALK,     -0.694245702162841_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.681017321689404_REALK,      0.000000000000000_REALK, &
     -0.295087752010064_REALK,      0.000000000000000_REALK,     -0.827963783307997_REALK, &
      0.000000000000000_REALK,     -0.244076553057805_REALK,      0.000000000000000_REALK, &
      1.353197206599490_REALK,      0.930558172916416_REALK,      0.000000000000000_REALK, &
      0.753275690866972_REALK,      0.000000000000000_REALK,      0.358068092050253_REALK, &
      0.687095848047899_REALK,      0.000000000000000_REALK,      0.274583603415102_REALK, &
      0.000000000000000_REALK,      0.710858428911895_REALK,      0.000000000000000_REALK, &
      0.265917486774791_REALK,      0.000000000000000_REALK,      0.236368915824667_REALK, &
      1.084265884315828_REALK,      0.903949490671776_REALK,      0.000000000000000_REALK, &
      0.575279515629629_REALK,      0.000000000000000_REALK,      0.417599704712038_REALK, &
      0.111037338759104_REALK,      0.000000000000000_REALK,      0.295933364803588_REALK, &
      0.000000000000000_REALK,     -0.671162604676589_REALK,      0.000000000000000_REALK, &
      0.194685217360895_REALK,      0.000000000000000_REALK,      0.268862472374632_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.676219466788840_REALK, &
      0.000000000000000_REALK,     -0.606926526946191_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.650326205967739_REALK,      0.000000000000000_REALK, &
     -0.345223338512467_REALK,      0.000000000000000_REALK,     -0.834573337962369_REALK, &
      0.000000000000000_REALK,     -0.369123415993923_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.567882029203362_REALK, &
      0.000000000000000_REALK,     -1.795601159589851_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.192650357917410_REALK,      0.000000000000000_REALK, &
     -0.881167043958705_REALK,      0.000000000000000_REALK,     -2.981840211550508_REALK, &
      0.000000000000000_REALK,     -1.046330336823202_REALK,      0.000000000000000_REALK, &
     10.681281340855946_REALK,      4.478753774226612_REALK,      0.000000000000000_REALK, &
      2.586754031010751_REALK,      0.000000000000000_REALK,      0.835123681212099_REALK, &
      1.735914404674083_REALK,      0.000000000000000_REALK,      0.377042208704302_REALK, &
      0.000000000000000_REALK,      1.406323415246979_REALK,      0.000000000000000_REALK, &
      0.252475347638964_REALK,      0.000000000000000_REALK,      0.282261975417781_REALK, &
     16.207503845120552_REALK,      6.915792917757202_REALK,      0.000000000000000_REALK, &
      4.322025038799548_REALK,      0.000000000000000_REALK,      0.893491301763186_REALK, &
      3.733567142913916_REALK,      0.000000000000000_REALK,      0.424424883721625_REALK, &
      0.000000000000000_REALK,      4.536124274694149_REALK,      0.000000000000000_REALK, &
      0.308558114999877_REALK,      0.000000000000000_REALK,      0.239435847428175_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.995240075780746_REALK, &
      0.000000000000000_REALK,     -0.497183994559150_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.327279493408380_REALK,      0.000000000000000_REALK, &
     -0.271843760019645_REALK,      0.000000000000000_REALK,     -0.254207688215392_REALK, &
      0.000000000000000_REALK,     -0.155318338777939_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.424214442101788_REALK, &
      0.000000000000000_REALK,     -0.604378635333042_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.262130368214681_REALK,      0.000000000000000_REALK, &
     -0.301852354647436_REALK,      0.000000000000000_REALK,     -0.015195959456625_REALK, &
      0.000000000000000_REALK,     -0.148593597924241_REALK,      0.000000000000000_REALK, &
      1.439744499170716_REALK,      0.811067592124719_REALK,      0.000000000000000_REALK, &
      0.565862874660551_REALK,      0.000000000000000_REALK,      0.330197349232636_REALK, &
      0.459408900684299_REALK,      0.000000000000000_REALK,      0.203745694569577_REALK, &
      0.000000000000000_REALK,      0.441730589101847_REALK,      0.000000000000000_REALK, &
      0.165251756308458_REALK,      0.000000000000000_REALK,      0.182751228753653_REALK, &
      3.744072755386150_REALK,      2.131925106654650_REALK,      0.000000000000000_REALK, &
      1.583875388193275_REALK,      0.000000000000000_REALK,      0.604167270890932_REALK, &
      1.491535960017589_REALK,      0.000000000000000_REALK,      0.394424889424273_REALK, &
      0.000000000000000_REALK,      1.780751628022775_REALK,      0.000000000000000_REALK, &
      0.345786765137882_REALK,      0.000000000000000_REALK,      0.265063359039139_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.497820766136559_REALK, &
      0.000000000000000_REALK,     -0.332502241243386_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.266310127270737_REALK,      0.000000000000000_REALK, &
     -0.221680000646179_REALK,      0.000000000000000_REALK,     -0.246842662837511_REALK, &
      0.000000000000000_REALK,     -0.171907938099247_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.175784358909542_REALK, &
      0.000000000000000_REALK,     -0.629561800743468_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.322169632550102_REALK,      0.000000000000000_REALK, &
     -0.409974946518869_REALK,      0.000000000000000_REALK,     -0.054404794893855_REALK, &
      0.000000000000000_REALK,     -0.260548436461453_REALK,      0.000000000000000_REALK, &
      1.120554575249381_REALK,      0.893389565026299_REALK,      0.000000000000000_REALK, &
      0.829165947592576_REALK,      0.000000000000000_REALK,      0.409544628266643_REALK, &
      0.879234454713886_REALK,      0.000000000000000_REALK,      0.362723473828963_REALK, &
      0.000000000000000_REALK,      1.080128370255753_REALK,      0.000000000000000_REALK, &
      0.394748152277055_REALK,      0.000000000000000_REALK,      0.306848324991589_REALK, &
      7.117937747983769_REALK,      5.549492123231634_REALK,      0.000000000000000_REALK, &
      5.057613892658936_REALK,      0.000000000000000_REALK,      1.839395189395186_REALK, &
      5.291581620011669_REALK,      0.000000000000000_REALK,      1.696508226690797_REALK, &
      0.000000000000000_REALK,      6.351559258928336_REALK,      0.000000000000000_REALK, &
      1.863182904817240_REALK,      0.000000000000000_REALK,      1.097105484912752_REALK, &
     16.923621613282595_REALK,      5.706645968996781_REALK,      0.000000000000000_REALK, &
      2.841013913256822_REALK,      0.000000000000000_REALK,      1.158205526675698_REALK, &
      1.582199839741413_REALK,      0.000000000000000_REALK,      0.407885871252123_REALK, &
      0.000000000000000_REALK,      1.035915672553436_REALK,      0.000000000000000_REALK, &
      0.229563603371614_REALK,      0.000000000000000_REALK,      0.324672928006875_REALK, &
      9.533697742509027_REALK,      4.412010539886397_REALK,      0.000000000000000_REALK, &
      1.861883436508595_REALK,      0.000000000000000_REALK,      1.019601421282174_REALK, &
     -0.086492823191836_REALK,      0.000000000000000_REALK,      0.369693340040385_REALK, &
      0.000000000000000_REALK,     -2.164776069524479_REALK,      0.000000000000000_REALK, &
      0.147802510568002_REALK,      0.000000000000000_REALK,      0.290376328393680_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.374983961589934_REALK, &
      0.000000000000000_REALK,     -0.553041694015604_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.312261628677463_REALK,      0.000000000000000_REALK, &
     -0.321063567101773_REALK,      0.000000000000000_REALK,     -0.207702239444015_REALK, &
      0.000000000000000_REALK,     -0.142471358458604_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.381221611810903_REALK, &
      0.000000000000000_REALK,     -0.741668516814201_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.533192135801634_REALK,      0.000000000000000_REALK, &
     -0.381405799828745_REALK,      0.000000000000000_REALK,     -0.503949806515548_REALK, &
      0.000000000000000_REALK,     -0.190330367869700_REALK,      0.000000000000000_REALK, &
      1.891855702295946_REALK,      0.860443187035090_REALK,      0.000000000000000_REALK, &
      0.498144997639218_REALK,      0.000000000000000_REALK,      0.381851258914174_REALK, &
      0.326849941655338_REALK,      0.000000000000000_REALK,      0.185080913224087_REALK, &
      0.000000000000000_REALK,      0.242200396482404_REALK,      0.000000000000000_REALK, &
      0.121093756032989_REALK,      0.000000000000000_REALK,      0.175921836115312_REALK, &
      1.595825907277614_REALK,      0.957142164760135_REALK,      0.000000000000000_REALK, &
      0.467389393968501_REALK,      0.000000000000000_REALK,      0.506819996505598_REALK, &
      0.031662100842064_REALK,      0.000000000000000_REALK,      0.244734885158919_REALK, &
      0.000000000000000_REALK,     -0.467668439988325_REALK,      0.000000000000000_REALK, &
      0.114216913203646_REALK,      0.000000000000000_REALK,      0.238649002468188_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.549887403786942_REALK, &
      0.000000000000000_REALK,     -0.299582784573472_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.204637417389131_REALK,      0.000000000000000_REALK, &
     -0.210039482890266_REALK,      0.000000000000000_REALK,     -0.165304882746116_REALK, &
      0.000000000000000_REALK,     -0.128209058053187_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.938820607725418_REALK, &
      0.000000000000000_REALK,     -0.687888201279272_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.593280980003244_REALK,      0.000000000000000_REALK, &
     -0.425121496649777_REALK,      0.000000000000000_REALK,     -0.612886616865247_REALK, &
      0.000000000000000_REALK,     -0.295748912451234_REALK,      0.000000000000000_REALK, &
      0.959860654162644_REALK,      0.578769513564750_REALK,      0.000000000000000_REALK, &
      0.405998802273060_REALK,      0.000000000000000_REALK,      0.315177427542631_REALK, &
      0.315919484386543_REALK,      0.000000000000000_REALK,      0.205639719381906_REALK, &
      0.000000000000000_REALK,      0.270431884865113_REALK,      0.000000000000000_REALK, &
      0.164119409135868_REALK,      0.000000000000000_REALK,      0.199348218081940_REALK, &
      1.321132603115819_REALK,      0.994497991248189_REALK,      0.000000000000000_REALK, &
      0.569592543757521_REALK,      0.000000000000000_REALK,      0.691047578865474_REALK, &
      0.097194685602486_REALK,      0.000000000000000_REALK,      0.427380752559102_REALK, &
      0.000000000000000_REALK,     -0.495505822991923_REALK,      0.000000000000000_REALK, &
      0.236902479700570_REALK,      0.000000000000000_REALK,      0.451314812731269_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.697503641620402_REALK, &
      0.000000000000000_REALK,     -0.541990448956590_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.494864254227572_REALK,      0.000000000000000_REALK, &
     -0.359642380268602_REALK,      0.000000000000000_REALK,     -0.524691727770328_REALK, &
      0.000000000000000_REALK,     -0.316703735635161_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.882429386063862_REALK, &
      0.000000000000000_REALK,     -2.964977596044950_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.181925194338154_REALK,      0.000000000000000_REALK, &
     -1.779421431394538_REALK,      0.000000000000000_REALK,     -3.669435404286447_REALK, &
      0.000000000000000_REALK,     -1.775929053333903_REALK,      0.000000000000000_REALK, &
      8.195096732760900_REALK,      5.314389270829621_REALK,      0.000000000000000_REALK, &
      9.904647280217954_REALK,      0.000000000000000_REALK,      2.709465765578259_REALK, &
     11.415369001896698_REALK,      0.000000000000000_REALK,      1.794987948063400_REALK, &
      0.000000000000000_REALK,     57.482391356616020_REALK,      0.000000000000000_REALK, &
      8.431011216778133_REALK,      0.000000000000000_REALK,      8.069991626232579_REALK, &
      7.520347817024271_REALK,      5.852901943669457_REALK,      0.000000000000000_REALK, &
     10.434227351062308_REALK,      0.000000000000000_REALK,      1.912131291152767_REALK, &
     14.594984175302011_REALK,      0.000000000000000_REALK,      1.773521673221883_REALK, &
      0.000000000000000_REALK,     70.897892438979554_REALK,      0.000000000000000_REALK, &
      8.465818654814800_REALK,      0.000000000000000_REALK,      5.846548143635191_REALK, &
      5.821175852512726_REALK,      2.974555620065168_REALK,      0.000000000000000_REALK, &
      3.670333663326586_REALK,      0.000000000000000_REALK,      1.713632637733459_REALK, &
      3.552236827167830_REALK,      0.000000000000000_REALK,      0.927659715844673_REALK, &
      0.000000000000000_REALK,     10.287727666805388_REALK,      0.000000000000000_REALK, &
      2.615748902319058_REALK,      0.000000000000000_REALK,      4.328589281703115_REALK, &
      1.716136926847680_REALK,      1.215734404860834_REALK,      0.000000000000000_REALK, &
      1.092098616875326_REALK,      0.000000000000000_REALK,      0.775701219034913_REALK, &
      0.113469358329174_REALK,      0.000000000000000_REALK,      0.445956102498721_REALK, &
      0.000000000000000_REALK,     -4.828907837285136_REALK,      0.000000000000000_REALK, &
      0.780626880791892_REALK,      0.000000000000000_REALK,      2.106221909007208_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.132822207016311_REALK, &
      0.000000000000000_REALK,     -1.261382916650116_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.438834135564247_REALK,      0.000000000000000_REALK, &
     -1.149395897160358_REALK,      0.000000000000000_REALK,     -5.026297621005738_REALK, &
      0.000000000000000_REALK,     -2.809819260190416_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.962529646117195_REALK, &
      0.000000000000000_REALK,     -1.450097852496420_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.050035426202477_REALK,      0.000000000000000_REALK, &
     -1.163627173815481_REALK,      0.000000000000000_REALK,     -7.361612764387224_REALK, &
      0.000000000000000_REALK,     -3.321632733102978_REALK,      0.000000000000000_REALK, &
      5.648198119376222_REALK,      2.168350444788205_REALK,      0.000000000000000_REALK, &
      2.229287051602496_REALK,      0.000000000000000_REALK,      1.435569719706543_REALK, &
      1.915163144297176_REALK,      0.000000000000000_REALK,      0.589506986641333_REALK, &
      0.000000000000000_REALK,      4.487185625621974_REALK,      0.000000000000000_REALK, &
      1.270919767786609_REALK,      0.000000000000000_REALK,      2.934160558079378_REALK, &
      3.747366059360727_REALK,      1.618158884918050_REALK,      0.000000000000000_REALK, &
      1.633924114579923_REALK,      0.000000000000000_REALK,      0.739348815517421_REALK, &
      2.019563926085644_REALK,      0.000000000000000_REALK,      0.382286255275566_REALK, &
      0.000000000000000_REALK,      5.889714351911850_REALK,      0.000000000000000_REALK, &
      0.783913927923357_REALK,      0.000000000000000_REALK,      1.445616497926452_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.924895397798293_REALK, &
      0.000000000000000_REALK,     -0.607395826440036_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.599059343553825_REALK,      0.000000000000000_REALK, &
     -0.853285389086027_REALK,      0.000000000000000_REALK,     -1.218249342922728_REALK, &
      0.000000000000000_REALK,     -1.078073261046351_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.684847060710202_REALK, &
      0.000000000000000_REALK,     -0.391527860349160_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.266162750574664_REALK,      0.000000000000000_REALK, &
     -0.601969246976198_REALK,      0.000000000000000_REALK,     -0.026596751571607_REALK, &
      0.000000000000000_REALK,     -0.651287969089356_REALK,      0.000000000000000_REALK, &
      1.041645715582365_REALK,      0.758756618495231_REALK,      0.000000000000000_REALK, &
      0.956762451635175_REALK,      0.000000000000000_REALK,      0.757524746219170_REALK, &
      1.255808682939750_REALK,      0.000000000000000_REALK,      0.623209505490645_REALK, &
      0.000000000000000_REALK,      3.645874351561480_REALK,      0.000000000000000_REALK, &
      1.580060134835137_REALK,      0.000000000000000_REALK,      2.479537986121866_REALK, &
      1.830808722432257_REALK,      1.477985385572953_REALK,      0.000000000000000_REALK, &
      1.875635152917618_REALK,      0.000000000000000_REALK,      1.011630105124715_REALK, &
      2.773414479859174_REALK,      0.000000000000000_REALK,      1.082293953958019_REALK, &
      0.000000000000000_REALK,      7.820775415948100_REALK,      0.000000000000000_REALK, &
      2.758594498810156_REALK,      0.000000000000000_REALK,      3.126323337862577_REALK, &
      6.689345471244834_REALK,      1.693877844226851_REALK,      0.000000000000000_REALK, &
      1.657788149119483_REALK,      0.000000000000000_REALK,      1.455226172603799_REALK, &
      0.994718857244895_REALK,      0.000000000000000_REALK,      0.382121724727603_REALK, &
      0.000000000000000_REALK,      1.984968777164789_REALK,      0.000000000000000_REALK, &
      0.756442330938238_REALK,      0.000000000000000_REALK,      2.337229226204201_REALK, &
      2.040903325914105_REALK,      0.730167501202357_REALK,      0.000000000000000_REALK, &
      0.537227959093749_REALK,      0.000000000000000_REALK,      0.695120345046833_REALK, &
     -0.131066821286746_REALK,      0.000000000000000_REALK,      0.185590308840341_REALK, &
      0.000000000000000_REALK,     -1.494827872916961_REALK,      0.000000000000000_REALK, &
      0.234639468172606_REALK,      0.000000000000000_REALK,      1.131064872141998_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.962003813765899_REALK, &
      0.000000000000000_REALK,     -0.401172568389670_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.384943916017910_REALK,      0.000000000000000_REALK, &
     -0.778899268110515_REALK,      0.000000000000000_REALK,     -0.525663604482010_REALK, &
      0.000000000000000_REALK,     -0.537727262237352_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.582387041993274_REALK, &
      0.000000000000000_REALK,     -0.328276329780109_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.364585721166114_REALK,      0.000000000000000_REALK, &
     -0.565917118945902_REALK,      0.000000000000000_REALK,     -0.654623477399378_REALK, &
      0.000000000000000_REALK,     -0.426429995771215_REALK,      0.000000000000000_REALK, &
      0.892827314184912_REALK,      0.445426701665940_REALK,      0.000000000000000_REALK, &
      0.414009276245903_REALK,      0.000000000000000_REALK,      0.565907737260160_REALK, &
      0.399457181208259_REALK,      0.000000000000000_REALK,      0.319956844619397_REALK, &
      0.000000000000000_REALK,      0.726897917726753_REALK,      0.000000000000000_REALK, &
      0.544742698243921_REALK,      0.000000000000000_REALK,      1.474425239053755_REALK, &
      0.495063922407232_REALK,      0.331197143419051_REALK,      0.000000000000000_REALK, &
      0.231316845715390_REALK,      0.000000000000000_REALK,      0.493233246740669_REALK, &
      0.020603923001022_REALK,      0.000000000000000_REALK,      0.282078782779074_REALK, &
      0.000000000000000_REALK,     -0.618076830705392_REALK,      0.000000000000000_REALK, &
      0.296259356135427_REALK,      0.000000000000000_REALK,      1.308402810124240_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.521870496560554_REALK, &
      0.000000000000000_REALK,     -0.424705349167043_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.491425075349251_REALK,      0.000000000000000_REALK, &
     -0.679086911587254_REALK,      0.000000000000000_REALK,     -1.059171627004485_REALK, &
      0.000000000000000_REALK,     -0.971242099826731_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.817250267205956_REALK, &
      0.000000000000000_REALK,     -0.922836447566103_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.270458188850741_REALK,      0.000000000000000_REALK, &
     -1.264296690515192_REALK,      0.000000000000000_REALK,     -2.823364810693490_REALK, &
      0.000000000000000_REALK,     -2.091176547534233_REALK,      0.000000000000000_REALK, &
      9.653745072552658_REALK,      1.368754912154790_REALK,      0.000000000000000_REALK, &
      1.628850684472877_REALK,      0.000000000000000_REALK,      1.758212999446267_REALK, &
      0.539679600558905_REALK,      0.000000000000000_REALK,      0.228695441401798_REALK, &
      0.000000000000000_REALK,      1.434219733850751_REALK,      0.000000000000000_REALK, &
      0.589923518005869_REALK,      0.000000000000000_REALK,      2.164034701072455_REALK, &
      8.100380043932024_REALK,      1.335848397467564_REALK,      0.000000000000000_REALK, &
      1.311013561485105_REALK,      0.000000000000000_REALK,      1.139130813627988_REALK, &
      0.938444938328666_REALK,      0.000000000000000_REALK,      0.172906652090051_REALK, &
      0.000000000000000_REALK,      2.382960185918107_REALK,      0.000000000000000_REALK, &
      0.358177358992366_REALK,      0.000000000000000_REALK,      1.199709961752589_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.197115106638821_REALK, &
      0.000000000000000_REALK,     -0.295447896759816_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.295934721011998_REALK,      0.000000000000000_REALK, &
     -0.823330462423741_REALK,      0.000000000000000_REALK,     -0.224913402328901_REALK, &
      0.000000000000000_REALK,     -0.283130712163477_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.081324583398888_REALK, &
      0.000000000000000_REALK,     -0.236339044781162_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.153785776699286_REALK,      0.000000000000000_REALK, &
     -0.652487112356539_REALK,      0.000000000000000_REALK,      0.057426568460440_REALK, &
      0.000000000000000_REALK,     -0.181262764336913_REALK,      0.000000000000000_REALK, &
      1.054335120583124_REALK,      0.364100433524574_REALK,      0.000000000000000_REALK, &
      0.297089440442244_REALK,      0.000000000000000_REALK,      0.562637790670390_REALK, &
      0.232151632366466_REALK,      0.000000000000000_REALK,      0.215397931991768_REALK, &
      0.000000000000000_REALK,      0.361849519412931_REALK,      0.000000000000000_REALK, &
      0.300000792609396_REALK,      0.000000000000000_REALK,      1.128807599194756_REALK, &
      1.573272710608953_REALK,      0.587764599840992_REALK,      0.000000000000000_REALK, &
      0.472935229690905_REALK,      0.000000000000000_REALK,      0.643545975473448_REALK, &
      0.494691868311594_REALK,      0.000000000000000_REALK,      0.283978749654510_REALK, &
      0.000000000000000_REALK,      0.947321093485588_REALK,      0.000000000000000_REALK, &
      0.368794150367606_REALK,      0.000000000000000_REALK,      1.101259656672241_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.473025787743704_REALK, &
      0.000000000000000_REALK,     -0.241790044750262_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.219552739436645_REALK,      0.000000000000000_REALK, &
     -0.529363682532052_REALK,      0.000000000000000_REALK,     -0.291779633913051_REALK, &
      0.000000000000000_REALK,     -0.422690688268012_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.777747912214904_REALK, &
      0.000000000000000_REALK,     -0.340552234809311_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.198113424378011_REALK,      0.000000000000000_REALK, &
     -0.765549761717678_REALK,      0.000000000000000_REALK,     -0.013989941345898_REALK, &
      0.000000000000000_REALK,     -0.504565103026108_REALK,      0.000000000000000_REALK, &
      0.584369946820956_REALK,      0.383516602993817_REALK,      0.000000000000000_REALK, &
      0.384001904271496_REALK,      0.000000000000000_REALK,      0.497131888353885_REALK, &
      0.458274872568211_REALK,      0.000000000000000_REALK,      0.381361710812250_REALK, &
      0.000000000000000_REALK,      0.883152326255784_REALK,      0.000000000000000_REALK, &
      0.624606496188514_REALK,      0.000000000000000_REALK,      1.342344129886057_REALK, &
      2.281091473271823_REALK,      1.621243245257586_REALK,      0.000000000000000_REALK, &
      1.629283631665575_REALK,      0.000000000000000_REALK,      1.467214768221768_REALK, &
      2.047105331026003_REALK,      0.000000000000000_REALK,      1.349411202864060_REALK, &
      0.000000000000000_REALK,      3.757128863940279_REALK,      0.000000000000000_REALK, &
      2.159421080899772_REALK,      0.000000000000000_REALK,      3.351825751923738_REALK, &
     16.645774561674060_REALK,      0.845683120818265_REALK,      0.000000000000000_REALK, &
      2.071429452253458_REALK,      0.000000000000000_REALK,      2.520694730530162_REALK, &
      0.072129141680979_REALK,      0.000000000000000_REALK,      0.052377425778934_REALK, &
      0.000000000000000_REALK,      1.350077398751018_REALK,      0.000000000000000_REALK, &
      0.593134854395176_REALK,      0.000000000000000_REALK,      2.327340659154209_REALK, &
      6.720155450288442_REALK,      0.428239565057569_REALK,      0.000000000000000_REALK, &
      1.008771961851809_REALK,      0.000000000000000_REALK,      1.673155100359702_REALK, &
     -0.581157971539480_REALK,      0.000000000000000_REALK,      0.005701020465583_REALK, &
      0.000000000000000_REALK,     -0.924247359548042_REALK,      0.000000000000000_REALK, &
      0.284963460231976_REALK,      0.000000000000000_REALK,      1.506678538927178_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.786526080486533_REALK, &
      0.000000000000000_REALK,     -0.223933983988150_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.298085525075188_REALK,      0.000000000000000_REALK, &
     -1.014437720809283_REALK,      0.000000000000000_REALK,     -0.094434826597649_REALK, &
      0.000000000000000_REALK,     -0.133694266318093_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.314244395173204_REALK, &
      0.000000000000000_REALK,     -0.226449889943498_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.303513679933972_REALK,      0.000000000000000_REALK, &
     -0.911525505699005_REALK,      0.000000000000000_REALK,     -0.227372196814779_REALK, &
      0.000000000000000_REALK,     -0.128013706795743_REALK,      0.000000000000000_REALK, &
      1.547447363514248_REALK,      0.338540051183226_REALK,      0.000000000000000_REALK, &
      0.266951660158047_REALK,      0.000000000000000_REALK,      0.690008262151643_REALK, &
      0.137747434681019_REALK,      0.000000000000000_REALK,      0.157313661902039_REALK, &
      0.000000000000000_REALK,      0.186367039052654_REALK,      0.000000000000000_REALK, &
      0.207334015016277_REALK,      0.000000000000000_REALK,      1.042659351088768_REALK, &
      1.000071508050278_REALK,      0.297343749979031_REALK,      0.000000000000000_REALK, &
      0.186771249867723_REALK,      0.000000000000000_REALK,      0.735082063196385_REALK, &
     -0.039826403389910_REALK,      0.000000000000000_REALK,      0.162844741793300_REALK, &
      0.000000000000000_REALK,     -0.302673451178970_REALK,      0.000000000000000_REALK, &
      0.138422643217407_REALK,      0.000000000000000_REALK,      1.087488827755731_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.578739348253417_REALK, &
      0.000000000000000_REALK,     -0.193739849894005_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.159474479350747_REALK,      0.000000000000000_REALK, &
     -0.536968471521455_REALK,      0.000000000000000_REALK,     -0.148429553640186_REALK, &
      0.000000000000000_REALK,     -0.247121570031066_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.748549188937791_REALK, &
      0.000000000000000_REALK,     -0.342792577342069_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.322453200515099_REALK,      0.000000000000000_REALK, &
     -0.847396263307640_REALK,      0.000000000000000_REALK,     -0.396797942920446_REALK, &
      0.000000000000000_REALK,     -0.421320952622879_REALK,      0.000000000000000_REALK, &
      0.620114725108182_REALK,      0.267659998192538_REALK,      0.000000000000000_REALK, &
      0.200718299194900_REALK,      0.000000000000000_REALK,      0.448517617626443_REALK, &
      0.165933945500213_REALK,      0.000000000000000_REALK,      0.220187707053017_REALK, &
      0.000000000000000_REALK,      0.205969967665742_REALK,      0.000000000000000_REALK, &
      0.250647790125902_REALK,      0.000000000000000_REALK,      0.924753452909785_REALK, &
      0.723261268111528_REALK,      0.413655645940386_REALK,      0.000000000000000_REALK, &
      0.241177232436106_REALK,      0.000000000000000_REALK,      0.868221452685500_REALK, &
      0.017681777976602_REALK,      0.000000000000000_REALK,      0.417603864174075_REALK, &
      0.000000000000000_REALK,     -0.372275091356333_REALK,      0.000000000000000_REALK, &
      0.292698152857601_REALK,      0.000000000000000_REALK,      1.765841795894459_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.523070046650166_REALK, &
      0.000000000000000_REALK,     -0.341406679276206_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.339439061702148_REALK,      0.000000000000000_REALK, &
     -0.655085577553879_REALK,      0.000000000000000_REALK,     -0.495795618154715_REALK, &
      0.000000000000000_REALK,     -0.621821007621591_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.732758051599391_REALK, &
      0.000000000000000_REALK,     -1.609460850274234_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.873398383523963_REALK,      0.000000000000000_REALK, &
     -2.640425101102892_REALK,      0.000000000000000_REALK,     -2.829842562532816_REALK, &
      0.000000000000000_REALK,     -2.873851954463476_REALK,      0.000000000000000_REALK/
  ! results of test 4, ket-major order, NEF 002
  data REF_CONTR_INTS(5041:6300)                                                           &
     /8.690987645265093_REALK,      6.698545530611777_REALK,      0.000000000000000_REALK, &
      6.142329550356540_REALK,      0.000000000000000_REALK,      0.983535244014621_REALK, &
      6.440094128144094_REALK,      0.000000000000000_REALK,      0.869303229476703_REALK, &
      0.000000000000000_REALK,      7.976806368176963_REALK,      0.000000000000000_REALK, &
      1.012940272101981_REALK,      0.000000000000000_REALK,      0.549410907205544_REALK, &
      4.362158676019091_REALK,      4.031827541862596_REALK,      0.000000000000000_REALK, &
      2.843477910427997_REALK,      0.000000000000000_REALK,      0.683805252204124_REALK, &
      0.619251031237639_REALK,      0.000000000000000_REALK,      0.552748533140841_REALK, &
      0.000000000000000_REALK,     -4.430381970509154_REALK,      0.000000000000000_REALK, &
      0.432198741932909_REALK,      0.000000000000000_REALK,      0.362386307120635_REALK, &
      7.608607366119877_REALK,      4.865696764752332_REALK,      0.000000000000000_REALK, &
      3.886003577492846_REALK,      0.000000000000000_REALK,      0.769484633294753_REALK, &
      3.658502133773021_REALK,      0.000000000000000_REALK,      0.552213111144301_REALK, &
      0.000000000000000_REALK,      4.216070440402269_REALK,      0.000000000000000_REALK, &
      0.539814269610166_REALK,      0.000000000000000_REALK,      0.366342381325579_REALK, &
     10.099885817588103_REALK,      6.447930098063904_REALK,      0.000000000000000_REALK, &
      5.526725611361025_REALK,      0.000000000000000_REALK,      0.706961625145825_REALK, &
      6.136274019754468_REALK,      0.000000000000000_REALK,      0.549922710386609_REALK, &
      0.000000000000000_REALK,      8.901956874829983_REALK,      0.000000000000000_REALK, &
      0.589795447918987_REALK,      0.000000000000000_REALK,      0.277534730680240_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.002137097922978_REALK, &
      0.000000000000000_REALK,     -0.767986307277289_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.715511191046252_REALK,      0.000000000000000_REALK, &
     -0.363398601993408_REALK,      0.000000000000000_REALK,     -0.798495098282086_REALK, &
      0.000000000000000_REALK,     -0.340429861521787_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.179375133281154_REALK, &
      0.000000000000000_REALK,     -0.735665962108674_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.447673823553621_REALK,      0.000000000000000_REALK, &
     -0.345715070343997_REALK,      0.000000000000000_REALK,     -0.091474302518334_REALK, &
      0.000000000000000_REALK,     -0.270735629861006_REALK,      0.000000000000000_REALK, &
      8.019454329636092_REALK,      4.156572670602200_REALK,      0.000000000000000_REALK, &
      2.774349454215271_REALK,      0.000000000000000_REALK,      0.725460090263254_REALK, &
      2.129515197409431_REALK,      0.000000000000000_REALK,      0.412460595660688_REALK, &
      0.000000000000000_REALK,      1.902439673719690_REALK,      0.000000000000000_REALK, &
      0.327111080016462_REALK,      0.000000000000000_REALK,      0.293299361938498_REALK, &
      3.920467993331958_REALK,      2.612160297665645_REALK,      0.000000000000000_REALK, &
      1.416812717717608_REALK,      0.000000000000000_REALK,      0.510312466618295_REALK, &
      0.106699086121473_REALK,      0.000000000000000_REALK,      0.282320253736492_REALK, &
      0.000000000000000_REALK,     -1.897966111111286_REALK,      0.000000000000000_REALK, &
      0.156004046084358_REALK,      0.000000000000000_REALK,      0.199294897740307_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.893135480892635_REALK, &
      0.000000000000000_REALK,     -0.561877229588488_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.450159831623530_REALK,      0.000000000000000_REALK, &
     -0.284035285137442_REALK,      0.000000000000000_REALK,     -0.439408340342954_REALK, &
      0.000000000000000_REALK,     -0.210276551098707_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.848747674383291_REALK, &
      0.000000000000000_REALK,     -0.694245702162841_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.681017321689404_REALK,      0.000000000000000_REALK, &
     -0.295087752010064_REALK,      0.000000000000000_REALK,     -0.827963783307997_REALK, &
      0.000000000000000_REALK,     -0.244076553057805_REALK,      0.000000000000000_REALK, &
      1.353197206599490_REALK,      0.930558172916416_REALK,      0.000000000000000_REALK, &
      0.753275690866973_REALK,      0.000000000000000_REALK,      0.358068092050253_REALK, &
      0.687095848047899_REALK,      0.000000000000000_REALK,      0.274583603415103_REALK, &
      0.000000000000000_REALK,      0.710858428911896_REALK,      0.000000000000000_REALK, &
      0.265917486774791_REALK,      0.000000000000000_REALK,      0.236368915824667_REALK, &
      1.084265884315829_REALK,      0.903949490671776_REALK,      0.000000000000000_REALK, &
      0.575279515629629_REALK,      0.000000000000000_REALK,      0.417599704712040_REALK, &
      0.111037338759104_REALK,      0.000000000000000_REALK,      0.295933364803588_REALK, &
      0.000000000000000_REALK,     -0.671162604676588_REALK,      0.000000000000000_REALK, &
      0.194685217360894_REALK,      0.000000000000000_REALK,      0.268862472374631_REALK, &
     10.681281340855950_REALK,      4.478753774226612_REALK,      0.000000000000000_REALK, &
      2.586754031010750_REALK,      0.000000000000000_REALK,      0.835123681212099_REALK, &
      1.735914404674084_REALK,      0.000000000000000_REALK,      0.377042208704302_REALK, &
      0.000000000000000_REALK,      1.406323415246980_REALK,      0.000000000000000_REALK, &
      0.252475347638964_REALK,      0.000000000000000_REALK,      0.282261975417781_REALK, &
     16.207503845120570_REALK,      6.915792917757210_REALK,      0.000000000000000_REALK, &
      4.322025038799547_REALK,      0.000000000000000_REALK,      0.893491301763184_REALK, &
      3.733567142913918_REALK,      0.000000000000000_REALK,      0.424424883721624_REALK, &
      0.000000000000000_REALK,      4.536124274694146_REALK,      0.000000000000000_REALK, &
      0.308558114999878_REALK,      0.000000000000000_REALK,      0.239435847428175_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.995240075780746_REALK, &
      0.000000000000000_REALK,     -0.497183994559151_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.327279493408380_REALK,      0.000000000000000_REALK, &
     -0.271843760019645_REALK,      0.000000000000000_REALK,     -0.254207688215392_REALK, &
      0.000000000000000_REALK,     -0.155318338777939_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.424214442101787_REALK, &
      0.000000000000000_REALK,     -0.604378635333042_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.262130368214681_REALK,      0.000000000000000_REALK, &
     -0.301852354647437_REALK,      0.000000000000000_REALK,     -0.015195959456625_REALK, &
      0.000000000000000_REALK,     -0.148593597924240_REALK,      0.000000000000000_REALK, &
      1.439744499170716_REALK,      0.811067592124720_REALK,      0.000000000000000_REALK, &
      0.565862874660552_REALK,      0.000000000000000_REALK,      0.330197349232636_REALK, &
      0.459408900684299_REALK,      0.000000000000000_REALK,      0.203745694569577_REALK, &
      0.000000000000000_REALK,      0.441730589101847_REALK,      0.000000000000000_REALK, &
      0.165251756308458_REALK,      0.000000000000000_REALK,      0.182751228753653_REALK, &
      3.744072755386147_REALK,      2.131925106654650_REALK,      0.000000000000000_REALK, &
      1.583875388193274_REALK,      0.000000000000000_REALK,      0.604167270890933_REALK, &
      1.491535960017591_REALK,      0.000000000000000_REALK,      0.394424889424273_REALK, &
      0.000000000000000_REALK,      1.780751628022775_REALK,      0.000000000000000_REALK, &
      0.345786765137882_REALK,      0.000000000000000_REALK,      0.265063359039139_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.497820766136559_REALK, &
      0.000000000000000_REALK,     -0.332502241243386_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.266310127270737_REALK,      0.000000000000000_REALK, &
     -0.221680000646179_REALK,      0.000000000000000_REALK,     -0.246842662837511_REALK, &
      0.000000000000000_REALK,     -0.171907938099247_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.175784358909546_REALK, &
      0.000000000000000_REALK,     -0.629561800743467_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.322169632550101_REALK,      0.000000000000000_REALK, &
     -0.409974946518869_REALK,      0.000000000000000_REALK,     -0.054404794893853_REALK, &
      0.000000000000000_REALK,     -0.260548436461453_REALK,      0.000000000000000_REALK, &
     16.923621613282585_REALK,      5.706645968996779_REALK,      0.000000000000000_REALK, &
      2.841013913256825_REALK,      0.000000000000000_REALK,      1.158205526675698_REALK, &
      1.582199839741414_REALK,      0.000000000000000_REALK,      0.407885871252123_REALK, &
      0.000000000000000_REALK,      1.035915672553436_REALK,      0.000000000000000_REALK, &
      0.229563603371614_REALK,      0.000000000000000_REALK,      0.324672928006875_REALK, &
      9.533697742509034_REALK,      4.412010539886394_REALK,      0.000000000000000_REALK, &
      1.861883436508596_REALK,      0.000000000000000_REALK,      1.019601421282175_REALK, &
     -0.086492823191839_REALK,      0.000000000000000_REALK,      0.369693340040386_REALK, &
      0.000000000000000_REALK,     -2.164776069524473_REALK,      0.000000000000000_REALK, &
      0.147802510568002_REALK,      0.000000000000000_REALK,      0.290376328393680_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.374983961589935_REALK, &
      0.000000000000000_REALK,     -0.553041694015604_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.312261628677463_REALK,      0.000000000000000_REALK, &
     -0.321063567101773_REALK,      0.000000000000000_REALK,     -0.207702239444015_REALK, &
      0.000000000000000_REALK,     -0.142471358458604_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.381221611810902_REALK, &
      0.000000000000000_REALK,     -0.741668516814201_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.533192135801633_REALK,      0.000000000000000_REALK, &
     -0.381405799828745_REALK,      0.000000000000000_REALK,     -0.503949806515549_REALK, &
      0.000000000000000_REALK,     -0.190330367869700_REALK,      0.000000000000000_REALK, &
      1.891855702295947_REALK,      0.860443187035090_REALK,      0.000000000000000_REALK, &
      0.498144997639218_REALK,      0.000000000000000_REALK,      0.381851258914175_REALK, &
      0.326849941655338_REALK,      0.000000000000000_REALK,      0.185080913224087_REALK, &
      0.000000000000000_REALK,      0.242200396482404_REALK,      0.000000000000000_REALK, &
      0.121093756032989_REALK,      0.000000000000000_REALK,      0.175921836115312_REALK, &
      1.595825907277611_REALK,      0.957142164760136_REALK,      0.000000000000000_REALK, &
      0.467389393968501_REALK,      0.000000000000000_REALK,      0.506819996505601_REALK, &
      0.031662100842065_REALK,      0.000000000000000_REALK,      0.244734885158919_REALK, &
      0.000000000000000_REALK,     -0.467668439988325_REALK,      0.000000000000000_REALK, &
      0.114216913203646_REALK,      0.000000000000000_REALK,      0.238649002468188_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.549887403786942_REALK, &
      0.000000000000000_REALK,     -0.299582784573472_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.204637417389131_REALK,      0.000000000000000_REALK, &
     -0.210039482890266_REALK,      0.000000000000000_REALK,     -0.165304882746116_REALK, &
      0.000000000000000_REALK,     -0.128209058053187_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.938820607725418_REALK, &
      0.000000000000000_REALK,     -0.687888201279273_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.593280980003244_REALK,      0.000000000000000_REALK, &
     -0.425121496649778_REALK,      0.000000000000000_REALK,     -0.612886616865246_REALK, &
      0.000000000000000_REALK,     -0.295748912451235_REALK,      0.000000000000000_REALK, &
      0.959860654162643_REALK,      0.578769513564750_REALK,      0.000000000000000_REALK, &
      0.405998802273060_REALK,      0.000000000000000_REALK,      0.315177427542631_REALK, &
      0.315919484386543_REALK,      0.000000000000000_REALK,      0.205639719381906_REALK, &
      0.000000000000000_REALK,      0.270431884865113_REALK,      0.000000000000000_REALK, &
      0.164119409135868_REALK,      0.000000000000000_REALK,      0.199348218081940_REALK, &
      1.321132603115826_REALK,      0.994497991248188_REALK,      0.000000000000000_REALK, &
      0.569592543757522_REALK,      0.000000000000000_REALK,      0.691047578865475_REALK, &
      0.097194685602486_REALK,      0.000000000000000_REALK,      0.427380752559103_REALK, &
      0.000000000000000_REALK,     -0.495505822991923_REALK,      0.000000000000000_REALK, &
      0.236902479700571_REALK,      0.000000000000000_REALK,      0.451314812731271_REALK, &
     42.264178977091312_REALK,     10.786209863312777_REALK,      0.000000000000000_REALK, &
      4.538484049989044_REALK,      0.000000000000000_REALK,      2.211194961907309_REALK, &
      2.095303492794815_REALK,      0.000000000000000_REALK,      0.582053959801419_REALK, &
      0.000000000000000_REALK,      1.205270287250715_REALK,      0.000000000000000_REALK, &
      0.275979453292167_REALK,      0.000000000000000_REALK,      0.474918029003571_REALK, &
    120.918654442002691_REALK,     33.411400110973091_REALK,      0.000000000000000_REALK, &
     15.471051705034233_REALK,      0.000000000000000_REALK,      4.889590011404336_REALK, &
     10.158861441284786_REALK,      0.000000000000000_REALK,      1.330805803778661_REALK, &
      0.000000000000000_REALK,      9.997343764333664_REALK,      0.000000000000000_REALK, &
      0.655061596224238_REALK,      0.000000000000000_REALK,      0.779758835949881_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.800321391252985_REALK, &
      0.000000000000000_REALK,     -0.853822349986547_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.394864378972651_REALK,      0.000000000000000_REALK, &
     -0.503730806071598_REALK,      0.000000000000000_REALK,     -0.207504078737867_REALK, &
      0.000000000000000_REALK,     -0.166500316464347_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.142667394601634_REALK, &
      0.000000000000000_REALK,     -2.204592526478563_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.662418168226778_REALK,      0.000000000000000_REALK, &
     -1.126933012048708_REALK,      0.000000000000000_REALK,      0.027722068554736_REALK, &
      0.000000000000000_REALK,     -0.317638694704739_REALK,      0.000000000000000_REALK, &
      4.097512252892656_REALK,      1.436935544071695_REALK,      0.000000000000000_REALK, &
      0.686981795461524_REALK,      0.000000000000000_REALK,      0.632638218197755_REALK, &
      0.378832114010820_REALK,      0.000000000000000_REALK,      0.234703602214974_REALK, &
      0.000000000000000_REALK,      0.246639087301336_REALK,      0.000000000000000_REALK, &
      0.125539578184723_REALK,      0.000000000000000_REALK,      0.223529528766961_REALK, &
     17.663597645882614_REALK,      6.603398992453277_REALK,      0.000000000000000_REALK, &
      3.482563210917256_REALK,      0.000000000000000_REALK,      2.111052696858702_REALK, &
      2.446910102923171_REALK,      0.000000000000000_REALK,      0.802933476145172_REALK, &
      0.000000000000000_REALK,      2.312520655230951_REALK,      0.000000000000000_REALK, &
      0.451427915249451_REALK,      0.000000000000000_REALK,      0.554925585616319_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.934391309870575_REALK, &
      0.000000000000000_REALK,     -0.386505100420341_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.207865328950277_REALK,      0.000000000000000_REALK, &
     -0.275652473400930_REALK,      0.000000000000000_REALK,     -0.129167617517777_REALK, &
      0.000000000000000_REALK,     -0.126116464545628_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.078995917738028_REALK, &
      0.000000000000000_REALK,     -1.439663379532090_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.501266280087212_REALK,      0.000000000000000_REALK, &
     -0.932104302755570_REALK,      0.000000000000000_REALK,     -0.025129824972584_REALK, &
      0.000000000000000_REALK,     -0.351567971927913_REALK,      0.000000000000000_REALK, &
      1.668038343452529_REALK,      0.782909330677088_REALK,      0.000000000000000_REALK, &
      0.451649380279174_REALK,      0.000000000000000_REALK,      0.419340694294985_REALK, &
      0.300285919765566_REALK,      0.000000000000000_REALK,      0.211665455422201_REALK, &
      0.000000000000000_REALK,      0.231331098177092_REALK,      0.000000000000000_REALK, &
      0.137042354194615_REALK,      0.000000000000000_REALK,      0.203738186246180_REALK, &
     12.216918797006272_REALK,      6.107260197798458_REALK,      0.000000000000000_REALK, &
      3.821699726458607_REALK,      0.000000000000000_REALK,      2.383243670335119_REALK, &
      2.917175119337105_REALK,      0.000000000000000_REALK,      1.242363127525892_REALK, &
      0.000000000000000_REALK,      2.708134482138846_REALK,      0.000000000000000_REALK, &
      0.839364950319102_REALK,      0.000000000000000_REALK,      0.863669071954940_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.784525956876998_REALK, &
      0.000000000000000_REALK,     -0.432140167418623_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.282156219849920_REALK,      0.000000000000000_REALK, &
     -0.316703735635161_REALK,      0.000000000000000_REALK,     -0.208500964589609_REALK, &
      0.000000000000000_REALK,     -0.195831705476875_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.612254281999935_REALK, &
      0.000000000000000_REALK,     -2.497291368631956_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.022158718331467_REALK,      0.000000000000000_REALK, &
     -1.775929053333895_REALK,      0.000000000000000_REALK,     -0.135503845248236_REALK, &
      0.000000000000000_REALK,     -0.860846423034081_REALK,      0.000000000000000_REALK, &
      5.821175852512728_REALK,      2.974555620065168_REALK,      0.000000000000000_REALK, &
      3.670333663326586_REALK,      0.000000000000000_REALK,      1.713632637733459_REALK, &
      3.552236827167833_REALK,      0.000000000000000_REALK,      0.927659715844673_REALK, &
      0.000000000000000_REALK,     10.287727666805385_REALK,      0.000000000000000_REALK, &
      2.615748902319060_REALK,      0.000000000000000_REALK,      4.328589281703116_REALK, &
      1.716136926847680_REALK,      1.215734404860834_REALK,      0.000000000000000_REALK, &
      1.092098616875321_REALK,      0.000000000000000_REALK,      0.775701219034913_REALK, &
      0.113469358329175_REALK,      0.000000000000000_REALK,      0.445956102498722_REALK, &
      0.000000000000000_REALK,     -4.828907837285132_REALK,      0.000000000000000_REALK, &
      0.780626880791888_REALK,      0.000000000000000_REALK,      2.106221909007203_REALK, &
      5.648198119376226_REALK,      2.168350444788206_REALK,      0.000000000000000_REALK, &
      2.229287051602495_REALK,      0.000000000000000_REALK,      1.435569719706543_REALK, &
      1.915163144297176_REALK,      0.000000000000000_REALK,      0.589506986641333_REALK, &
      0.000000000000000_REALK,      4.487185625621974_REALK,      0.000000000000000_REALK, &
      1.270919767786609_REALK,      0.000000000000000_REALK,      2.934160558079379_REALK, &
      3.747366059360729_REALK,      1.618158884918049_REALK,      0.000000000000000_REALK, &
      1.633924114579923_REALK,      0.000000000000000_REALK,      0.739348815517421_REALK, &
      2.019563926085646_REALK,      0.000000000000000_REALK,      0.382286255275566_REALK, &
      0.000000000000000_REALK,      5.889714351911856_REALK,      0.000000000000000_REALK, &
      0.783913927923358_REALK,      0.000000000000000_REALK,      1.445616497926450_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.924895397798293_REALK, &
      0.000000000000000_REALK,     -0.607395826440036_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.599059343553825_REALK,      0.000000000000000_REALK, &
     -0.853285389086027_REALK,      0.000000000000000_REALK,     -1.218249342922728_REALK, &
      0.000000000000000_REALK,     -1.078073261046352_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.684847060710203_REALK, &
      0.000000000000000_REALK,     -0.391527860349159_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.266162750574664_REALK,      0.000000000000000_REALK, &
     -0.601969246976200_REALK,      0.000000000000000_REALK,     -0.026596751571603_REALK, &
      0.000000000000000_REALK,     -0.651287969089353_REALK,      0.000000000000000_REALK, &
      6.689345471244836_REALK,      1.693877844226851_REALK,      0.000000000000000_REALK, &
      1.657788149119483_REALK,      0.000000000000000_REALK,      1.455226172603799_REALK, &
      0.994718857244895_REALK,      0.000000000000000_REALK,      0.382121724727603_REALK, &
      0.000000000000000_REALK,      1.984968777164788_REALK,      0.000000000000000_REALK, &
      0.756442330938238_REALK,      0.000000000000000_REALK,      2.337229226204202_REALK, &
      2.040903325914107_REALK,      0.730167501202357_REALK,      0.000000000000000_REALK, &
      0.537227959093749_REALK,      0.000000000000000_REALK,      0.695120345046833_REALK, &
     -0.131066821286746_REALK,      0.000000000000000_REALK,      0.185590308840341_REALK, &
      0.000000000000000_REALK,     -1.494827872916960_REALK,      0.000000000000000_REALK, &
      0.234639468172605_REALK,      0.000000000000000_REALK,      1.131064872141997_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.962003813765900_REALK, &
      0.000000000000000_REALK,     -0.401172568389670_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.384943916017910_REALK,      0.000000000000000_REALK, &
     -0.778899268110514_REALK,      0.000000000000000_REALK,     -0.525663604482010_REALK, &
      0.000000000000000_REALK,     -0.537727262237353_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.582387041993274_REALK, &
      0.000000000000000_REALK,     -0.328276329780109_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.364585721166114_REALK,      0.000000000000000_REALK, &
     -0.565917118945901_REALK,      0.000000000000000_REALK,     -0.654623477399379_REALK, &
      0.000000000000000_REALK,     -0.426429995771215_REALK,      0.000000000000000_REALK, &
      0.892827314184913_REALK,      0.445426701665940_REALK,      0.000000000000000_REALK, &
      0.414009276245903_REALK,      0.000000000000000_REALK,      0.565907737260160_REALK, &
      0.399457181208258_REALK,      0.000000000000000_REALK,      0.319956844619397_REALK, &
      0.000000000000000_REALK,      0.726897917726752_REALK,      0.000000000000000_REALK, &
      0.544742698243920_REALK,      0.000000000000000_REALK,      1.474425239053755_REALK, &
      0.495063922407232_REALK,      0.331197143419051_REALK,      0.000000000000000_REALK, &
      0.231316845715389_REALK,      0.000000000000000_REALK,      0.493233246740669_REALK, &
      0.020603923001022_REALK,      0.000000000000000_REALK,      0.282078782779075_REALK, &
      0.000000000000000_REALK,     -0.618076830705396_REALK,      0.000000000000000_REALK, &
      0.296259356135425_REALK,      0.000000000000000_REALK,      1.308402810124240_REALK, &
      9.653745072552653_REALK,      1.368754912154790_REALK,      0.000000000000000_REALK, &
      1.628850684472877_REALK,      0.000000000000000_REALK,      1.758212999446269_REALK, &
      0.539679600558905_REALK,      0.000000000000000_REALK,      0.228695441401798_REALK, &
      0.000000000000000_REALK,      1.434219733850748_REALK,      0.000000000000000_REALK, &
      0.589923518005868_REALK,      0.000000000000000_REALK,      2.164034701072455_REALK, &
      8.100380043932022_REALK,      1.335848397467566_REALK,      0.000000000000000_REALK, &
      1.311013561485105_REALK,      0.000000000000000_REALK,      1.139130813627988_REALK, &
      0.938444938328668_REALK,      0.000000000000000_REALK,      0.172906652090052_REALK, &
      0.000000000000000_REALK,      2.382960185918102_REALK,      0.000000000000000_REALK, &
      0.358177358992365_REALK,      0.000000000000000_REALK,      1.199709961752591_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.197115106638821_REALK, &
      0.000000000000000_REALK,     -0.295447896759816_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.295934721011998_REALK,      0.000000000000000_REALK, &
     -0.823330462423742_REALK,      0.000000000000000_REALK,     -0.224913402328901_REALK, &
      0.000000000000000_REALK,     -0.283130712163477_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.081324583398886_REALK, &
      0.000000000000000_REALK,     -0.236339044781162_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.153785776699286_REALK,      0.000000000000000_REALK, &
     -0.652487112356539_REALK,      0.000000000000000_REALK,      0.057426568460440_REALK, &
      0.000000000000000_REALK,     -0.181262764336913_REALK,      0.000000000000000_REALK, &
      1.054335120583124_REALK,      0.364100433524574_REALK,      0.000000000000000_REALK, &
      0.297089440442244_REALK,      0.000000000000000_REALK,      0.562637790670389_REALK, &
      0.232151632366466_REALK,      0.000000000000000_REALK,      0.215397931991768_REALK, &
      0.000000000000000_REALK,      0.361849519412931_REALK,      0.000000000000000_REALK, &
      0.300000792609396_REALK,      0.000000000000000_REALK,      1.128807599194756_REALK, &
      1.573272710608955_REALK,      0.587764599840992_REALK,      0.000000000000000_REALK, &
      0.472935229690905_REALK,      0.000000000000000_REALK,      0.643545975473449_REALK, &
      0.494691868311594_REALK,      0.000000000000000_REALK,      0.283978749654510_REALK, &
      0.000000000000000_REALK,      0.947321093485588_REALK,      0.000000000000000_REALK, &
      0.368794150367606_REALK,      0.000000000000000_REALK,      1.101259656672241_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.473025787743704_REALK, &
      0.000000000000000_REALK,     -0.241790044750262_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.219552739436645_REALK,      0.000000000000000_REALK, &
     -0.529363682532052_REALK,      0.000000000000000_REALK,     -0.291779633913052_REALK, &
      0.000000000000000_REALK,     -0.422690688268012_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.777747912214904_REALK, &
      0.000000000000000_REALK,     -0.340552234809311_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.198113424378010_REALK,      0.000000000000000_REALK, &
     -0.765549761717679_REALK,      0.000000000000000_REALK,     -0.013989941345896_REALK, &
      0.000000000000000_REALK,     -0.504565103026108_REALK,      0.000000000000000_REALK, &
     16.645774561674074_REALK,      0.845683120818262_REALK,      0.000000000000000_REALK, &
      2.071429452253460_REALK,      0.000000000000000_REALK,      2.520694730530163_REALK, &
      0.072129141680976_REALK,      0.000000000000000_REALK,      0.052377425778934_REALK, &
      0.000000000000000_REALK,      1.350077398751015_REALK,      0.000000000000000_REALK, &
      0.593134854395176_REALK,      0.000000000000000_REALK,      2.327340659154209_REALK, &
      6.720155450288413_REALK,      0.428239565057584_REALK,      0.000000000000000_REALK, &
      1.008771961851798_REALK,      0.000000000000000_REALK,      1.673155100359699_REALK, &
     -0.581157971539470_REALK,      0.000000000000000_REALK,      0.005701020465585_REALK, &
      0.000000000000000_REALK,     -0.924247359548059_REALK,      0.000000000000000_REALK, &
      0.284963460231973_REALK,      0.000000000000000_REALK,      1.506678538927175_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.786526080486533_REALK, &
      0.000000000000000_REALK,     -0.223933983988151_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.298085525075188_REALK,      0.000000000000000_REALK, &
     -1.014437720809283_REALK,      0.000000000000000_REALK,     -0.094434826597649_REALK, &
      0.000000000000000_REALK,     -0.133694266318094_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.314244395173204_REALK, &
      0.000000000000000_REALK,     -0.226449889943498_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.303513679933971_REALK,      0.000000000000000_REALK, &
     -0.911525505699006_REALK,      0.000000000000000_REALK,     -0.227372196814781_REALK, &
      0.000000000000000_REALK,     -0.128013706795745_REALK,      0.000000000000000_REALK, &
      1.547447363514247_REALK,      0.338540051183226_REALK,      0.000000000000000_REALK, &
      0.266951660158047_REALK,      0.000000000000000_REALK,      0.690008262151642_REALK, &
      0.137747434681019_REALK,      0.000000000000000_REALK,      0.157313661902039_REALK, &
      0.000000000000000_REALK,      0.186367039052654_REALK,      0.000000000000000_REALK, &
      0.207334015016277_REALK,      0.000000000000000_REALK,      1.042659351088769_REALK, &
      1.000071508050273_REALK,      0.297343749979031_REALK,      0.000000000000000_REALK, &
      0.186771249867722_REALK,      0.000000000000000_REALK,      0.735082063196385_REALK, &
     -0.039826403389909_REALK,      0.000000000000000_REALK,      0.162844741793301_REALK, &
      0.000000000000000_REALK,     -0.302673451178972_REALK,      0.000000000000000_REALK, &
      0.138422643217406_REALK,      0.000000000000000_REALK,      1.087488827755729_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.578739348253418_REALK, &
      0.000000000000000_REALK,     -0.193739849894005_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.159474479350747_REALK,      0.000000000000000_REALK, &
     -0.536968471521455_REALK,      0.000000000000000_REALK,     -0.148429553640186_REALK, &
      0.000000000000000_REALK,     -0.247121570031066_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.748549188937791_REALK, &
      0.000000000000000_REALK,     -0.342792577342069_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.322453200515098_REALK,      0.000000000000000_REALK, &
     -0.847396263307642_REALK,      0.000000000000000_REALK,     -0.396797942920447_REALK, &
      0.000000000000000_REALK,     -0.421320952622880_REALK,      0.000000000000000_REALK, &
      0.620114725108182_REALK,      0.267659998192538_REALK,      0.000000000000000_REALK, &
      0.200718299194900_REALK,      0.000000000000000_REALK,      0.448517617626443_REALK, &
      0.165933945500213_REALK,      0.000000000000000_REALK,      0.220187707053017_REALK, &
      0.000000000000000_REALK,      0.205969967665742_REALK,      0.000000000000000_REALK, &
      0.250647790125902_REALK,      0.000000000000000_REALK,      0.924753452909785_REALK, &
      0.723261268111527_REALK,      0.413655645940385_REALK,      0.000000000000000_REALK, &
      0.241177232436106_REALK,      0.000000000000000_REALK,      0.868221452685501_REALK, &
      0.017681777976602_REALK,      0.000000000000000_REALK,      0.417603864174076_REALK, &
      0.000000000000000_REALK,     -0.372275091356334_REALK,      0.000000000000000_REALK, &
      0.292698152857601_REALK,      0.000000000000000_REALK,      1.765841795894458_REALK, &
     40.347169965775137_REALK,     -0.650571151868289_REALK,      0.000000000000000_REALK, &
      3.732388556434350_REALK,      0.000000000000000_REALK,      4.571790383015936_REALK, &
     -0.682490235824203_REALK,      0.000000000000000_REALK,     -0.267211801577574_REALK, &
      0.000000000000000_REALK,      1.939998440523945_REALK,      0.000000000000000_REALK, &
      0.789229880894298_REALK,      0.000000000000000_REALK,      2.979629085049774_REALK, &
     77.156864645949554_REALK,     -0.068079493641125_REALK,      0.000000000000000_REALK, &
      6.111079977831590_REALK,      0.000000000000000_REALK,      6.790721113280513_REALK, &
      0.618485116188750_REALK,      0.000000000000000_REALK,     -0.321326455711797_REALK, &
      0.000000000000000_REALK,      4.469727141977927_REALK,      0.000000000000000_REALK, &
      0.833572856784375_REALK,      0.000000000000000_REALK,      3.053675682526472_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.545183582284919_REALK, &
      0.000000000000000_REALK,     -0.124911805976145_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.404483715046338_REALK,      0.000000000000000_REALK, &
     -1.519021737049703_REALK,      0.000000000000000_REALK,      0.016791484137106_REALK, &
      0.000000000000000_REALK,      0.001458776597946_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -7.339244735736679_REALK, &
      0.000000000000000_REALK,     -0.187420526791676_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.470857050782994_REALK,      0.000000000000000_REALK, &
     -2.395562959751870_REALK,      0.000000000000000_REALK,      0.248354415941358_REALK, &
      0.000000000000000_REALK,      0.032239174296217_REALK,      0.000000000000000_REALK, &
      3.295749975109592_REALK,      0.389932792363011_REALK,      0.000000000000000_REALK, &
      0.350394371226079_REALK,      0.000000000000000_REALK,      1.101575991842554_REALK, &
      0.097622788152215_REALK,      0.000000000000000_REALK,      0.119370219339039_REALK, &
      0.000000000000000_REALK,      0.165498295103391_REALK,      0.000000000000000_REALK, &
      0.197402127659074_REALK,      0.000000000000000_REALK,      1.177610415257664_REALK, &
      9.844595636961872_REALK,      1.300847548148708_REALK,      0.000000000000000_REALK, &
      0.995138840674543_REALK,      0.000000000000000_REALK,      2.555199248343902_REALK, &
      0.534666604941559_REALK,      0.000000000000000_REALK,      0.288660643373800_REALK, &
      0.000000000000000_REALK,      0.838387569218531_REALK,      0.000000000000000_REALK, &
      0.354862746945821_REALK,      0.000000000000000_REALK,      1.887081163652488_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.981732958376563_REALK, &
      0.000000000000000_REALK,     -0.192823639171356_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.151734894148807_REALK,      0.000000000000000_REALK, &
     -0.688999987325745_REALK,      0.000000000000000_REALK,     -0.080618571851463_REALK, &
      0.000000000000000_REALK,     -0.163182753661939_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.257402269585667_REALK, &
      0.000000000000000_REALK,     -0.536110688698302_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.252528172343528_REALK,      0.000000000000000_REALK, &
     -1.746947738439430_REALK,      0.000000000000000_REALK,      0.052156451741371_REALK, &
      0.000000000000000_REALK,     -0.307572889476693_REALK,      0.000000000000000_REALK, &
      1.084070944659042_REALK,      0.305751613495130_REALK,      0.000000000000000_REALK, &
      0.193923758073064_REALK,      0.000000000000000_REALK,      0.589871022072869_REALK, &
      0.121895104624457_REALK,      0.000000000000000_REALK,      0.183491883311709_REALK, &
      0.000000000000000_REALK,      0.128689025290372_REALK,      0.000000000000000_REALK, &
      0.170233619800696_REALK,      0.000000000000000_REALK,      0.864028056874403_REALK, &
      5.707392761002852_REALK,      1.741319288054716_REALK,      0.000000000000000_REALK, &
      1.077580232142273_REALK,      0.000000000000000_REALK,      2.408309896566966_REALK, &
      0.831492928761017_REALK,      0.000000000000000_REALK,      0.773887903036160_REALK, &
      0.000000000000000_REALK,      1.003200328364748_REALK,      0.000000000000000_REALK, &
      0.617856167815323_REALK,      0.000000000000000_REALK,      2.438468239481467_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.648973282942497_REALK, &
      0.000000000000000_REALK,     -0.259896752564350_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.188229014488423_REALK,      0.000000000000000_REALK, &
     -0.621821007621590_REALK,      0.000000000000000_REALK,     -0.169580920259430_REALK, &
      0.000000000000000_REALK,     -0.333457167791429_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.897467136447906_REALK, &
      0.000000000000000_REALK,     -1.281678407575232_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.541836276359144_REALK,      0.000000000000000_REALK, &
     -2.873851954463469_REALK,      0.000000000000000_REALK,     -0.028309066362039_REALK, &
      0.000000000000000_REALK,     -1.153964491574424_REALK,      0.000000000000000_REALK/
  ! results of test 4, ket-major order, NEF 003
  data REF_CONTR_INTS(6301:7560)                                                           &
     /0.000000000000000_REALK,      0.000000000000000_REALK,     -1.625815625500515_REALK, &
      0.000000000000000_REALK,     -1.654789715008215_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.040145879763374_REALK,      0.000000000000000_REALK, &
     -0.658158474436788_REALK,      0.000000000000000_REALK,     -3.139768409242401_REALK, &
      0.000000000000000_REALK,     -0.847792467448280_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.323186223737945_REALK, &
      0.000000000000000_REALK,     -2.954198874255495_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.086386387019042_REALK,      0.000000000000000_REALK, &
     -0.987945293831926_REALK,      0.000000000000000_REALK,     -6.560587971769188_REALK, &
      0.000000000000000_REALK,     -1.397869317702264_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.002137097922978_REALK, &
      0.000000000000000_REALK,     -0.767986307277289_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.715511191046252_REALK,      0.000000000000000_REALK, &
     -0.363398601993409_REALK,      0.000000000000000_REALK,     -0.798495098282086_REALK, &
      0.000000000000000_REALK,     -0.340429861521787_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.179375133281153_REALK, &
      0.000000000000000_REALK,     -0.735665962108674_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.447673823553619_REALK,      0.000000000000000_REALK, &
     -0.345715070343996_REALK,      0.000000000000000_REALK,     -0.091474302518328_REALK, &
      0.000000000000000_REALK,     -0.270735629861005_REALK,      0.000000000000000_REALK, &
      1.966608003527662_REALK,      1.779412918765905_REALK,      0.000000000000000_REALK, &
      1.891055993886821_REALK,      0.000000000000000_REALK,      0.570089048380173_REALK, &
      2.328348822817747_REALK,      0.000000000000000_REALK,      0.587611710371620_REALK, &
      0.000000000000000_REALK,      3.435371268477181_REALK,      0.000000000000000_REALK, &
      0.770978181368280_REALK,      0.000000000000000_REALK,      0.436781280124511_REALK, &
      6.427777950444345_REALK,      5.596341502155119_REALK,      0.000000000000000_REALK, &
      5.884866074960099_REALK,      0.000000000000000_REALK,      1.290508088896389_REALK, &
      7.272890429479682_REALK,      0.000000000000000_REALK,      1.418451046798272_REALK, &
      0.000000000000000_REALK,     10.619543119518926_REALK,      0.000000000000000_REALK, &
      1.909891369020217_REALK,      0.000000000000000_REALK,      0.817428953288363_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.893135480892635_REALK, &
      0.000000000000000_REALK,     -0.561877229588488_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.450159831623530_REALK,      0.000000000000000_REALK, &
     -0.284035285137442_REALK,      0.000000000000000_REALK,     -0.439408340342954_REALK, &
      0.000000000000000_REALK,     -0.210276551098706_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.848747674383291_REALK, &
      0.000000000000000_REALK,     -0.694245702162841_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.681017321689404_REALK,      0.000000000000000_REALK, &
     -0.295087752010063_REALK,      0.000000000000000_REALK,     -0.827963783307996_REALK, &
      0.000000000000000_REALK,     -0.244076553057805_REALK,      0.000000000000000_REALK, &
      1.353197206599490_REALK,      0.930558172916416_REALK,      0.000000000000000_REALK, &
      0.753275690866972_REALK,      0.000000000000000_REALK,      0.358068092050252_REALK, &
      0.687095848047899_REALK,      0.000000000000000_REALK,      0.274583603415103_REALK, &
      0.000000000000000_REALK,      0.710858428911895_REALK,      0.000000000000000_REALK, &
      0.265917486774791_REALK,      0.000000000000000_REALK,      0.236368915824667_REALK, &
      1.084265884315827_REALK,      0.903949490671775_REALK,      0.000000000000000_REALK, &
      0.575279515629629_REALK,      0.000000000000000_REALK,      0.417599704712039_REALK, &
      0.111037338759104_REALK,      0.000000000000000_REALK,      0.295933364803589_REALK, &
      0.000000000000000_REALK,     -0.671162604676590_REALK,      0.000000000000000_REALK, &
      0.194685217360894_REALK,      0.000000000000000_REALK,      0.268862472374632_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.676219466788840_REALK, &
      0.000000000000000_REALK,     -0.606926526946191_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.650326205967738_REALK,      0.000000000000000_REALK, &
     -0.345223338512467_REALK,      0.000000000000000_REALK,     -0.834573337962370_REALK, &
      0.000000000000000_REALK,     -0.369123415993923_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.567882029203362_REALK, &
      0.000000000000000_REALK,     -1.795601159589852_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.192650357917413_REALK,      0.000000000000000_REALK, &
     -0.881167043958707_REALK,      0.000000000000000_REALK,     -2.981840211550509_REALK, &
      0.000000000000000_REALK,     -1.046330336823202_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.995240075780745_REALK, &
      0.000000000000000_REALK,     -0.497183994559151_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.327279493408380_REALK,      0.000000000000000_REALK, &
     -0.271843760019645_REALK,      0.000000000000000_REALK,     -0.254207688215392_REALK, &
      0.000000000000000_REALK,     -0.155318338777939_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.424214442101788_REALK, &
      0.000000000000000_REALK,     -0.604378635333042_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.262130368214680_REALK,      0.000000000000000_REALK, &
     -0.301852354647436_REALK,      0.000000000000000_REALK,     -0.015195959456625_REALK, &
      0.000000000000000_REALK,     -0.148593597924241_REALK,      0.000000000000000_REALK, &
      1.439744499170715_REALK,      0.811067592124719_REALK,      0.000000000000000_REALK, &
      0.565862874660552_REALK,      0.000000000000000_REALK,      0.330197349232636_REALK, &
      0.459408900684299_REALK,      0.000000000000000_REALK,      0.203745694569577_REALK, &
      0.000000000000000_REALK,      0.441730589101847_REALK,      0.000000000000000_REALK, &
      0.165251756308458_REALK,      0.000000000000000_REALK,      0.182751228753653_REALK, &
      3.744072755386149_REALK,      2.131925106654651_REALK,      0.000000000000000_REALK, &
      1.583875388193275_REALK,      0.000000000000000_REALK,      0.604167270890932_REALK, &
      1.491535960017590_REALK,      0.000000000000000_REALK,      0.394424889424273_REALK, &
      0.000000000000000_REALK,      1.780751628022775_REALK,      0.000000000000000_REALK, &
      0.345786765137882_REALK,      0.000000000000000_REALK,      0.265063359039139_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.497820766136559_REALK, &
      0.000000000000000_REALK,     -0.332502241243386_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.266310127270737_REALK,      0.000000000000000_REALK, &
     -0.221680000646179_REALK,      0.000000000000000_REALK,     -0.246842662837511_REALK, &
      0.000000000000000_REALK,     -0.171907938099247_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.175784358909546_REALK, &
      0.000000000000000_REALK,     -0.629561800743467_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.322169632550102_REALK,      0.000000000000000_REALK, &
     -0.409974946518868_REALK,      0.000000000000000_REALK,     -0.054404794893855_REALK, &
      0.000000000000000_REALK,     -0.260548436461453_REALK,      0.000000000000000_REALK, &
      1.120554575249381_REALK,      0.893389565026298_REALK,      0.000000000000000_REALK, &
      0.829165947592576_REALK,      0.000000000000000_REALK,      0.409544628266643_REALK, &
      0.879234454713885_REALK,      0.000000000000000_REALK,      0.362723473828963_REALK, &
      0.000000000000000_REALK,      1.080128370255753_REALK,      0.000000000000000_REALK, &
      0.394748152277055_REALK,      0.000000000000000_REALK,      0.306848324991590_REALK, &
      7.117937747983760_REALK,      5.549492123231635_REALK,      0.000000000000000_REALK, &
      5.057613892658936_REALK,      0.000000000000000_REALK,      1.839395189395189_REALK, &
      5.291581620011671_REALK,      0.000000000000000_REALK,      1.696508226690800_REALK, &
      0.000000000000000_REALK,      6.351559258928328_REALK,      0.000000000000000_REALK, &
      1.863182904817239_REALK,      0.000000000000000_REALK,      1.097105484912754_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.374983961589935_REALK, &
      0.000000000000000_REALK,     -0.553041694015604_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.312261628677463_REALK,      0.000000000000000_REALK, &
     -0.321063567101773_REALK,      0.000000000000000_REALK,     -0.207702239444015_REALK, &
      0.000000000000000_REALK,     -0.142471358458604_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.381221611810904_REALK, &
      0.000000000000000_REALK,     -0.741668516814201_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.533192135801634_REALK,      0.000000000000000_REALK, &
     -0.381405799828745_REALK,      0.000000000000000_REALK,     -0.503949806515549_REALK, &
      0.000000000000000_REALK,     -0.190330367869700_REALK,      0.000000000000000_REALK, &
      1.891855702295945_REALK,      0.860443187035090_REALK,      0.000000000000000_REALK, &
      0.498144997639218_REALK,      0.000000000000000_REALK,      0.381851258914175_REALK, &
      0.326849941655338_REALK,      0.000000000000000_REALK,      0.185080913224087_REALK, &
      0.000000000000000_REALK,      0.242200396482404_REALK,      0.000000000000000_REALK, &
      0.121093756032989_REALK,      0.000000000000000_REALK,      0.175921836115312_REALK, &
      1.595825907277608_REALK,      0.957142164760137_REALK,      0.000000000000000_REALK, &
      0.467389393968501_REALK,      0.000000000000000_REALK,      0.506819996505601_REALK, &
      0.031662100842066_REALK,      0.000000000000000_REALK,      0.244734885158919_REALK, &
      0.000000000000000_REALK,     -0.467668439988326_REALK,      0.000000000000000_REALK, &
      0.114216913203645_REALK,      0.000000000000000_REALK,      0.238649002468188_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.549887403786942_REALK, &
      0.000000000000000_REALK,     -0.299582784573472_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.204637417389131_REALK,      0.000000000000000_REALK, &
     -0.210039482890266_REALK,      0.000000000000000_REALK,     -0.165304882746116_REALK, &
      0.000000000000000_REALK,     -0.128209058053187_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.938820607725416_REALK, &
      0.000000000000000_REALK,     -0.687888201279273_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.593280980003243_REALK,      0.000000000000000_REALK, &
     -0.425121496649778_REALK,      0.000000000000000_REALK,     -0.612886616865247_REALK, &
      0.000000000000000_REALK,     -0.295748912451235_REALK,      0.000000000000000_REALK, &
      0.959860654162644_REALK,      0.578769513564750_REALK,      0.000000000000000_REALK, &
      0.405998802273059_REALK,      0.000000000000000_REALK,      0.315177427542631_REALK, &
      0.315919484386543_REALK,      0.000000000000000_REALK,      0.205639719381906_REALK, &
      0.000000000000000_REALK,      0.270431884865113_REALK,      0.000000000000000_REALK, &
      0.164119409135868_REALK,      0.000000000000000_REALK,      0.199348218081940_REALK, &
      1.321132603115825_REALK,      0.994497991248188_REALK,      0.000000000000000_REALK, &
      0.569592543757521_REALK,      0.000000000000000_REALK,      0.691047578865475_REALK, &
      0.097194685602485_REALK,      0.000000000000000_REALK,      0.427380752559103_REALK, &
      0.000000000000000_REALK,     -0.495505822991920_REALK,      0.000000000000000_REALK, &
      0.236902479700570_REALK,      0.000000000000000_REALK,      0.451314812731271_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.697503641620401_REALK, &
      0.000000000000000_REALK,     -0.541990448956590_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.494864254227572_REALK,      0.000000000000000_REALK, &
     -0.359642380268602_REALK,      0.000000000000000_REALK,     -0.524691727770328_REALK, &
      0.000000000000000_REALK,     -0.316703735635161_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.882429386063868_REALK, &
      0.000000000000000_REALK,     -2.964977596044956_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.181925194338156_REALK,      0.000000000000000_REALK, &
     -1.779421431394548_REALK,      0.000000000000000_REALK,     -3.669435404286453_REALK, &
      0.000000000000000_REALK,     -1.775929053333901_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.800321391252985_REALK, &
      0.000000000000000_REALK,     -0.853822349986548_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.394864378972652_REALK,      0.000000000000000_REALK, &
     -0.503730806071597_REALK,      0.000000000000000_REALK,     -0.207504078737867_REALK, &
      0.000000000000000_REALK,     -0.166500316464347_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.142667394601634_REALK, &
      0.000000000000000_REALK,     -2.204592526478562_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.662418168226778_REALK,      0.000000000000000_REALK, &
     -1.126933012048708_REALK,      0.000000000000000_REALK,      0.027722068554734_REALK, &
      0.000000000000000_REALK,     -0.317638694704739_REALK,      0.000000000000000_REALK, &
      4.097512252892655_REALK,      1.436935544071695_REALK,      0.000000000000000_REALK, &
      0.686981795461524_REALK,      0.000000000000000_REALK,      0.632638218197755_REALK, &
      0.378832114010820_REALK,      0.000000000000000_REALK,      0.234703602214974_REALK, &
      0.000000000000000_REALK,      0.246639087301336_REALK,      0.000000000000000_REALK, &
      0.125539578184723_REALK,      0.000000000000000_REALK,      0.223529528766961_REALK, &
     17.663597645882632_REALK,      6.603398992453274_REALK,      0.000000000000000_REALK, &
      3.482563210917260_REALK,      0.000000000000000_REALK,      2.111052696858701_REALK, &
      2.446910102923168_REALK,      0.000000000000000_REALK,      0.802933476145172_REALK, &
      0.000000000000000_REALK,      2.312520655230953_REALK,      0.000000000000000_REALK, &
      0.451427915249451_REALK,      0.000000000000000_REALK,      0.554925585616317_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.934391309870576_REALK, &
      0.000000000000000_REALK,     -0.386505100420341_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.207865328950277_REALK,      0.000000000000000_REALK, &
     -0.275652473400930_REALK,      0.000000000000000_REALK,     -0.129167617517777_REALK, &
      0.000000000000000_REALK,     -0.126116464545628_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.078995917738024_REALK, &
      0.000000000000000_REALK,     -1.439663379532093_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.501266280087212_REALK,      0.000000000000000_REALK, &
     -0.932104302755571_REALK,      0.000000000000000_REALK,     -0.025129824972584_REALK, &
      0.000000000000000_REALK,     -0.351567971927913_REALK,      0.000000000000000_REALK, &
      1.668038343452531_REALK,      0.782909330677088_REALK,      0.000000000000000_REALK, &
      0.451649380279174_REALK,      0.000000000000000_REALK,      0.419340694294984_REALK, &
      0.300285919765566_REALK,      0.000000000000000_REALK,      0.211665455422201_REALK, &
      0.000000000000000_REALK,      0.231331098177092_REALK,      0.000000000000000_REALK, &
      0.137042354194615_REALK,      0.000000000000000_REALK,      0.203738186246180_REALK, &
     12.216918797006265_REALK,      6.107260197798463_REALK,      0.000000000000000_REALK, &
      3.821699726458605_REALK,      0.000000000000000_REALK,      2.383243670335117_REALK, &
      2.917175119337105_REALK,      0.000000000000000_REALK,      1.242363127525895_REALK, &
      0.000000000000000_REALK,      2.708134482138850_REALK,      0.000000000000000_REALK, &
      0.839364950319103_REALK,      0.000000000000000_REALK,      0.863669071954939_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.784525956876999_REALK, &
      0.000000000000000_REALK,     -0.432140167418624_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.282156219849920_REALK,      0.000000000000000_REALK, &
     -0.316703735635161_REALK,      0.000000000000000_REALK,     -0.208500964589609_REALK, &
      0.000000000000000_REALK,     -0.195831705476875_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.612254281999943_REALK, &
      0.000000000000000_REALK,     -2.497291368631957_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.022158718331470_REALK,      0.000000000000000_REALK, &
     -1.775929053333900_REALK,      0.000000000000000_REALK,     -0.135503845248235_REALK, &
      0.000000000000000_REALK,     -0.860846423034080_REALK,      0.000000000000000_REALK, &
      2.194397922677669_REALK,      1.454622226938939_REALK,      0.000000000000000_REALK, &
      1.113801680052418_REALK,      0.000000000000000_REALK,      0.736694552399892_REALK, &
      0.963405333689301_REALK,      0.000000000000000_REALK,      0.532170542086267_REALK, &
      0.000000000000000_REALK,      0.943706245242559_REALK,      0.000000000000000_REALK, &
      0.461436619528979_REALK,      0.000000000000000_REALK,      0.444477511716115_REALK, &
     38.588069525825389_REALK,     26.497618843310384_REALK,      0.000000000000000_REALK, &
     20.315075456757263_REALK,      0.000000000000000_REALK,     10.187103498048542_REALK, &
     17.171152901454793_REALK,      0.000000000000000_REALK,      7.489539347508553_REALK, &
      0.000000000000000_REALK,     16.000994723914818_REALK,      0.000000000000000_REALK, &
      6.313241726465586_REALK,      0.000000000000000_REALK,      4.628016021680082_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.132822207016311_REALK, &
      0.000000000000000_REALK,     -1.261382916650117_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.438834135564247_REALK,      0.000000000000000_REALK, &
     -1.149395897160359_REALK,      0.000000000000000_REALK,     -5.026297621005739_REALK, &
      0.000000000000000_REALK,     -2.809819260190416_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.962529646117196_REALK, &
      0.000000000000000_REALK,     -1.450097852496421_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.050035426202476_REALK,      0.000000000000000_REALK, &
     -1.163627173815478_REALK,      0.000000000000000_REALK,     -7.361612764387218_REALK, &
      0.000000000000000_REALK,     -3.321632733102976_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.924895397798293_REALK, &
      0.000000000000000_REALK,     -0.607395826440036_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.599059343553825_REALK,      0.000000000000000_REALK, &
     -0.853285389086027_REALK,      0.000000000000000_REALK,     -1.218249342922729_REALK, &
      0.000000000000000_REALK,     -1.078073261046351_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.684847060710202_REALK, &
      0.000000000000000_REALK,     -0.391527860349160_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.266162750574664_REALK,      0.000000000000000_REALK, &
     -0.601969246976199_REALK,      0.000000000000000_REALK,     -0.026596751571606_REALK, &
      0.000000000000000_REALK,     -0.651287969089356_REALK,      0.000000000000000_REALK, &
      1.041645715582365_REALK,      0.758756618495231_REALK,      0.000000000000000_REALK, &
      0.956762451635175_REALK,      0.000000000000000_REALK,      0.757524746219170_REALK, &
      1.255808682939750_REALK,      0.000000000000000_REALK,      0.623209505490645_REALK, &
      0.000000000000000_REALK,      3.645874351561481_REALK,      0.000000000000000_REALK, &
      1.580060134835138_REALK,      0.000000000000000_REALK,      2.479537986121864_REALK, &
      1.830808722432255_REALK,      1.477985385572952_REALK,      0.000000000000000_REALK, &
      1.875635152917619_REALK,      0.000000000000000_REALK,      1.011630105124716_REALK, &
      2.773414479859176_REALK,      0.000000000000000_REALK,      1.082293953958018_REALK, &
      0.000000000000000_REALK,      7.820775415948100_REALK,      0.000000000000000_REALK, &
      2.758594498810155_REALK,      0.000000000000000_REALK,      3.126323337862583_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.962003813765900_REALK, &
      0.000000000000000_REALK,     -0.401172568389670_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.384943916017910_REALK,      0.000000000000000_REALK, &
     -0.778899268110514_REALK,      0.000000000000000_REALK,     -0.525663604482010_REALK, &
      0.000000000000000_REALK,     -0.537727262237352_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.582387041993274_REALK, &
      0.000000000000000_REALK,     -0.328276329780109_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.364585721166114_REALK,      0.000000000000000_REALK, &
     -0.565917118945901_REALK,      0.000000000000000_REALK,     -0.654623477399379_REALK, &
      0.000000000000000_REALK,     -0.426429995771215_REALK,      0.000000000000000_REALK, &
      0.892827314184913_REALK,      0.445426701665940_REALK,      0.000000000000000_REALK, &
      0.414009276245903_REALK,      0.000000000000000_REALK,      0.565907737260160_REALK, &
      0.399457181208258_REALK,      0.000000000000000_REALK,      0.319956844619397_REALK, &
      0.000000000000000_REALK,      0.726897917726752_REALK,      0.000000000000000_REALK, &
      0.544742698243921_REALK,      0.000000000000000_REALK,      1.474425239053754_REALK, &
      0.495063922407232_REALK,      0.331197143419051_REALK,      0.000000000000000_REALK, &
      0.231316845715390_REALK,      0.000000000000000_REALK,      0.493233246740669_REALK, &
      0.020603923001022_REALK,      0.000000000000000_REALK,      0.282078782779074_REALK, &
      0.000000000000000_REALK,     -0.618076830705393_REALK,      0.000000000000000_REALK, &
      0.296259356135427_REALK,      0.000000000000000_REALK,      1.308402810124239_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.521870496560554_REALK, &
      0.000000000000000_REALK,     -0.424705349167043_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.491425075349251_REALK,      0.000000000000000_REALK, &
     -0.679086911587254_REALK,      0.000000000000000_REALK,     -1.059171627004485_REALK, &
      0.000000000000000_REALK,     -0.971242099826731_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.817250267205957_REALK, &
      0.000000000000000_REALK,     -0.922836447566102_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.270458188850741_REALK,      0.000000000000000_REALK, &
     -1.264296690515192_REALK,      0.000000000000000_REALK,     -2.823364810693492_REALK, &
      0.000000000000000_REALK,     -2.091176547534232_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.197115106638820_REALK, &
      0.000000000000000_REALK,     -0.295447896759816_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.295934721011998_REALK,      0.000000000000000_REALK, &
     -0.823330462423741_REALK,      0.000000000000000_REALK,     -0.224913402328901_REALK, &
      0.000000000000000_REALK,     -0.283130712163477_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.081324583398886_REALK, &
      0.000000000000000_REALK,     -0.236339044781162_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.153785776699286_REALK,      0.000000000000000_REALK, &
     -0.652487112356539_REALK,      0.000000000000000_REALK,      0.057426568460440_REALK, &
      0.000000000000000_REALK,     -0.181262764336913_REALK,      0.000000000000000_REALK, &
      1.054335120583124_REALK,      0.364100433524574_REALK,      0.000000000000000_REALK, &
      0.297089440442244_REALK,      0.000000000000000_REALK,      0.562637790670389_REALK, &
      0.232151632366466_REALK,      0.000000000000000_REALK,      0.215397931991768_REALK, &
      0.000000000000000_REALK,      0.361849519412931_REALK,      0.000000000000000_REALK, &
      0.300000792609396_REALK,      0.000000000000000_REALK,      1.128807599194756_REALK, &
      1.573272710608954_REALK,      0.587764599840992_REALK,      0.000000000000000_REALK, &
      0.472935229690905_REALK,      0.000000000000000_REALK,      0.643545975473449_REALK, &
      0.494691868311594_REALK,      0.000000000000000_REALK,      0.283978749654510_REALK, &
      0.000000000000000_REALK,      0.947321093485587_REALK,      0.000000000000000_REALK, &
      0.368794150367606_REALK,      0.000000000000000_REALK,      1.101259656672242_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.473025787743704_REALK, &
      0.000000000000000_REALK,     -0.241790044750262_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.219552739436645_REALK,      0.000000000000000_REALK, &
     -0.529363682532052_REALK,      0.000000000000000_REALK,     -0.291779633913051_REALK, &
      0.000000000000000_REALK,     -0.422690688268012_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.777747912214904_REALK, &
      0.000000000000000_REALK,     -0.340552234809311_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.198113424378011_REALK,      0.000000000000000_REALK, &
     -0.765549761717679_REALK,      0.000000000000000_REALK,     -0.013989941345898_REALK, &
      0.000000000000000_REALK,     -0.504565103026108_REALK,      0.000000000000000_REALK, &
      0.584369946820956_REALK,      0.383516602993817_REALK,      0.000000000000000_REALK, &
      0.384001904271496_REALK,      0.000000000000000_REALK,      0.497131888353885_REALK, &
      0.458274872568211_REALK,      0.000000000000000_REALK,      0.381361710812250_REALK, &
      0.000000000000000_REALK,      0.883152326255784_REALK,      0.000000000000000_REALK, &
      0.624606496188514_REALK,      0.000000000000000_REALK,      1.342344129886057_REALK, &
      2.281091473271825_REALK,      1.621243245257587_REALK,      0.000000000000000_REALK, &
      1.629283631665577_REALK,      0.000000000000000_REALK,      1.467214768221768_REALK, &
      2.047105331026003_REALK,      0.000000000000000_REALK,      1.349411202864060_REALK, &
      0.000000000000000_REALK,      3.757128863940281_REALK,      0.000000000000000_REALK, &
      2.159421080899769_REALK,      0.000000000000000_REALK,      3.351825751923736_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.786526080486534_REALK, &
      0.000000000000000_REALK,     -0.223933983988151_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.298085525075188_REALK,      0.000000000000000_REALK, &
     -1.014437720809283_REALK,      0.000000000000000_REALK,     -0.094434826597649_REALK, &
      0.000000000000000_REALK,     -0.133694266318094_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.314244395173205_REALK, &
      0.000000000000000_REALK,     -0.226449889943499_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.303513679933971_REALK,      0.000000000000000_REALK, &
     -0.911525505699005_REALK,      0.000000000000000_REALK,     -0.227372196814781_REALK, &
      0.000000000000000_REALK,     -0.128013706795744_REALK,      0.000000000000000_REALK, &
      1.547447363514248_REALK,      0.338540051183226_REALK,      0.000000000000000_REALK, &
      0.266951660158047_REALK,      0.000000000000000_REALK,      0.690008262151642_REALK, &
      0.137747434681019_REALK,      0.000000000000000_REALK,      0.157313661902039_REALK, &
      0.000000000000000_REALK,      0.186367039052654_REALK,      0.000000000000000_REALK, &
      0.207334015016277_REALK,      0.000000000000000_REALK,      1.042659351088768_REALK, &
      1.000071508050273_REALK,      0.297343749979032_REALK,      0.000000000000000_REALK, &
      0.186771249867723_REALK,      0.000000000000000_REALK,      0.735082063196386_REALK, &
     -0.039826403389909_REALK,      0.000000000000000_REALK,      0.162844741793301_REALK, &
      0.000000000000000_REALK,     -0.302673451178971_REALK,      0.000000000000000_REALK, &
      0.138422643217406_REALK,      0.000000000000000_REALK,      1.087488827755730_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.578739348253418_REALK, &
      0.000000000000000_REALK,     -0.193739849894005_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.159474479350747_REALK,      0.000000000000000_REALK, &
     -0.536968471521455_REALK,      0.000000000000000_REALK,     -0.148429553640186_REALK, &
      0.000000000000000_REALK,     -0.247121570031066_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.748549188937789_REALK, &
      0.000000000000000_REALK,     -0.342792577342069_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.322453200515098_REALK,      0.000000000000000_REALK, &
     -0.847396263307642_REALK,      0.000000000000000_REALK,     -0.396797942920446_REALK, &
      0.000000000000000_REALK,     -0.421320952622880_REALK,      0.000000000000000_REALK, &
      0.620114725108182_REALK,      0.267659998192538_REALK,      0.000000000000000_REALK, &
      0.200718299194900_REALK,      0.000000000000000_REALK,      0.448517617626444_REALK, &
      0.165933945500212_REALK,      0.000000000000000_REALK,      0.220187707053017_REALK, &
      0.000000000000000_REALK,      0.205969967665742_REALK,      0.000000000000000_REALK, &
      0.250647790125902_REALK,      0.000000000000000_REALK,      0.924753452909785_REALK, &
      0.723261268111527_REALK,      0.413655645940386_REALK,      0.000000000000000_REALK, &
      0.241177232436106_REALK,      0.000000000000000_REALK,      0.868221452685502_REALK, &
      0.017681777976603_REALK,      0.000000000000000_REALK,      0.417603864174076_REALK, &
      0.000000000000000_REALK,     -0.372275091356334_REALK,      0.000000000000000_REALK, &
      0.292698152857601_REALK,      0.000000000000000_REALK,      1.765841795894460_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.523070046650166_REALK, &
      0.000000000000000_REALK,     -0.341406679276206_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.339439061702148_REALK,      0.000000000000000_REALK, &
     -0.655085577553879_REALK,      0.000000000000000_REALK,     -0.495795618154715_REALK, &
      0.000000000000000_REALK,     -0.621821007621591_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.732758051599387_REALK, &
      0.000000000000000_REALK,     -1.609460850274234_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.873398383523961_REALK,      0.000000000000000_REALK, &
     -2.640425101102892_REALK,      0.000000000000000_REALK,     -2.829842562532814_REALK, &
      0.000000000000000_REALK,     -2.873851954463476_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.545183582284916_REALK, &
      0.000000000000000_REALK,     -0.124911805976145_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.404483715046338_REALK,      0.000000000000000_REALK, &
     -1.519021737049703_REALK,      0.000000000000000_REALK,      0.016791484137105_REALK, &
      0.000000000000000_REALK,      0.001458776597946_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -7.339244735736679_REALK, &
      0.000000000000000_REALK,     -0.187420526791673_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.470857050782995_REALK,      0.000000000000000_REALK, &
     -2.395562959751875_REALK,      0.000000000000000_REALK,      0.248354415941357_REALK, &
      0.000000000000000_REALK,      0.032239174296218_REALK,      0.000000000000000_REALK, &
      3.295749975109593_REALK,      0.389932792363011_REALK,      0.000000000000000_REALK, &
      0.350394371226079_REALK,      0.000000000000000_REALK,      1.101575991842553_REALK, &
      0.097622788152215_REALK,      0.000000000000000_REALK,      0.119370219339039_REALK, &
      0.000000000000000_REALK,      0.165498295103391_REALK,      0.000000000000000_REALK, &
      0.197402127659074_REALK,      0.000000000000000_REALK,      1.177610415257663_REALK, &
      9.844595636961868_REALK,      1.300847548148708_REALK,      0.000000000000000_REALK, &
      0.995138840674543_REALK,      0.000000000000000_REALK,      2.555199248343901_REALK, &
      0.534666604941559_REALK,      0.000000000000000_REALK,      0.288660643373800_REALK, &
      0.000000000000000_REALK,      0.838387569218533_REALK,      0.000000000000000_REALK, &
      0.354862746945821_REALK,      0.000000000000000_REALK,      1.887081163652488_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.981732958376563_REALK, &
      0.000000000000000_REALK,     -0.192823639171356_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.151734894148807_REALK,      0.000000000000000_REALK, &
     -0.688999987325744_REALK,      0.000000000000000_REALK,     -0.080618571851463_REALK, &
      0.000000000000000_REALK,     -0.163182753661939_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.257402269585668_REALK, &
      0.000000000000000_REALK,     -0.536110688698302_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.252528172343528_REALK,      0.000000000000000_REALK, &
     -1.746947738439432_REALK,      0.000000000000000_REALK,      0.052156451741371_REALK, &
      0.000000000000000_REALK,     -0.307572889476693_REALK,      0.000000000000000_REALK, &
      1.084070944659041_REALK,      0.305751613495130_REALK,      0.000000000000000_REALK, &
      0.193923758073064_REALK,      0.000000000000000_REALK,      0.589871022072868_REALK, &
      0.121895104624457_REALK,      0.000000000000000_REALK,      0.183491883311709_REALK, &
      0.000000000000000_REALK,      0.128689025290372_REALK,      0.000000000000000_REALK, &
      0.170233619800696_REALK,      0.000000000000000_REALK,      0.864028056874402_REALK, &
      5.707392761002844_REALK,      1.741319288054713_REALK,      0.000000000000000_REALK, &
      1.077580232142274_REALK,      0.000000000000000_REALK,      2.408309896566967_REALK, &
      0.831492928761016_REALK,      0.000000000000000_REALK,      0.773887903036160_REALK, &
      0.000000000000000_REALK,      1.003200328364746_REALK,      0.000000000000000_REALK, &
      0.617856167815322_REALK,      0.000000000000000_REALK,      2.438468239481467_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.648973282942498_REALK, &
      0.000000000000000_REALK,     -0.259896752564350_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.188229014488423_REALK,      0.000000000000000_REALK, &
     -0.621821007621591_REALK,      0.000000000000000_REALK,     -0.169580920259430_REALK, &
      0.000000000000000_REALK,     -0.333457167791429_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.897467136447903_REALK, &
      0.000000000000000_REALK,     -1.281678407575230_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.541836276359145_REALK,      0.000000000000000_REALK, &
     -2.873851954463471_REALK,      0.000000000000000_REALK,     -0.028309066362041_REALK, &
      0.000000000000000_REALK,     -1.153964491574424_REALK,      0.000000000000000_REALK, &
      1.009681361770694_REALK,      0.537808997193626_REALK,      0.000000000000000_REALK, &
      0.420864380336718_REALK,      0.000000000000000_REALK,      0.735212402919253_REALK, &
      0.400460480481837_REALK,      0.000000000000000_REALK,      0.454662105210431_REALK, &
      0.000000000000000_REALK,      0.524374309846439_REALK,      0.000000000000000_REALK, &
      0.500044648717118_REALK,      0.000000000000000_REALK,      1.332070468775940_REALK, &
     13.665962611286346_REALK,      8.025489658161600_REALK,      0.000000000000000_REALK, &
      6.178493196625644_REALK,      0.000000000000000_REALK,      7.702084394591450_REALK, &
      5.692600825704169_REALK,      0.000000000000000_REALK,      5.134170047144373_REALK, &
      0.000000000000000_REALK,      6.570467970185137_REALK,      0.000000000000000_REALK, &
      5.046505172478811_REALK,      0.000000000000000_REALK,      9.640873790026657_REALK/
  ! results of test 5, ket-major order, NEF 004
  data REF_CONTR_INTS(7561:8820)                                                           &
   /-12.596986330406081_REALK,     -9.565644212411055_REALK,      0.000000000000000_REALK, &
     -9.711912232037452_REALK,      0.000000000000000_REALK,     -1.849241517347952_REALK, &
    -12.205906677444391_REALK,      0.000000000000000_REALK,     -1.667142388114482_REALK, &
      0.000000000000000_REALK,    -18.700537028120443_REALK,      0.000000000000000_REALK, &
     -2.084146441653162_REALK,      0.000000000000000_REALK,     -1.195798404289586_REALK, &
     -6.744778912653936_REALK,     -6.656437880809407_REALK,      0.000000000000000_REALK, &
     -7.916339000131511_REALK,      0.000000000000000_REALK,     -1.147620191300331_REALK, &
    -11.119547047462611_REALK,      0.000000000000000_REALK,     -1.235225241749726_REALK, &
      0.000000000000000_REALK,    -18.553469396134698_REALK,      0.000000000000000_REALK, &
     -1.722681493461892_REALK,      0.000000000000000_REALK,     -0.747774108041095_REALK, &
    -10.803524940408980_REALK,     -6.302301924876641_REALK,      0.000000000000000_REALK, &
     -5.164385564222298_REALK,      0.000000000000000_REALK,     -1.421593374298785_REALK, &
     -5.137114225305275_REALK,      0.000000000000000_REALK,     -0.973725389204930_REALK, &
      0.000000000000000_REALK,     -6.211027121567183_REALK,      0.000000000000000_REALK, &
     -0.975209095184021_REALK,      0.000000000000000_REALK,     -0.809277956773738_REALK, &
     -5.876308962696559_REALK,     -3.449599229328291_REALK,      0.000000000000000_REALK, &
     -2.614759965744545_REALK,      0.000000000000000_REALK,     -0.728029750784371_REALK, &
     -2.205773123032849_REALK,      0.000000000000000_REALK,     -0.513313575998535_REALK, &
      0.000000000000000_REALK,     -1.854627361612639_REALK,      0.000000000000000_REALK, &
     -0.474674662042661_REALK,      0.000000000000000_REALK,     -0.396138786999605_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.430837463453104_REALK, &
      0.000000000000000_REALK,      1.118113710930519_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.182849098887178_REALK,      0.000000000000000_REALK, &
      0.660661709580328_REALK,      0.000000000000000_REALK,      1.554367713876993_REALK, &
      0.000000000000000_REALK,      0.628146243142803_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.288523058917384_REALK, &
      0.000000000000000_REALK,      1.158232839057435_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.339898642855033_REALK,      0.000000000000000_REALK, &
      0.567727365543545_REALK,      0.000000000000000_REALK,      1.896626918441562_REALK, &
      0.000000000000000_REALK,      0.622430714725189_REALK,      0.000000000000000_REALK, &
    -11.253216170331413_REALK,     -5.189846235629036_REALK,      0.000000000000000_REALK, &
     -3.641800920722475_REALK,      0.000000000000000_REALK,     -1.319263310268053_REALK, &
     -3.073787748511879_REALK,      0.000000000000000_REALK,     -0.706374856799852_REALK, &
      0.000000000000000_REALK,     -3.240110104913932_REALK,      0.000000000000000_REALK, &
     -0.599948893447051_REALK,      0.000000000000000_REALK,     -0.655431092358779_REALK, &
     -5.139881480393374_REALK,     -2.795475920748747_REALK,      0.000000000000000_REALK, &
     -2.107865117532933_REALK,      0.000000000000000_REALK,     -0.668709174831901_REALK, &
     -1.945210387638100_REALK,      0.000000000000000_REALK,     -0.392041092272781_REALK, &
      0.000000000000000_REALK,     -2.306633407937456_REALK,      0.000000000000000_REALK, &
     -0.338110664651797_REALK,      0.000000000000000_REALK,     -0.321820833086897_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.217585510026127_REALK, &
      0.000000000000000_REALK,      0.724206176576625_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.608303494877145_REALK,      0.000000000000000_REALK, &
      0.494946522502431_REALK,      0.000000000000000_REALK,      0.626136870971337_REALK, &
      0.000000000000000_REALK,      0.354406832317734_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.788795795633888_REALK, &
      0.000000000000000_REALK,      0.505741992302636_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.396995593186786_REALK,      0.000000000000000_REALK, &
      0.332570225416120_REALK,      0.000000000000000_REALK,      0.336808182164877_REALK, &
      0.000000000000000_REALK,      0.242405654365148_REALK,      0.000000000000000_REALK, &
     -1.449555016071946_REALK,     -1.012651393203694_REALK,      0.000000000000000_REALK, &
     -0.925607521082394_REALK,      0.000000000000000_REALK,     -0.505416689292625_REALK, &
     -1.024237138436385_REALK,      0.000000000000000_REALK,     -0.407927337817612_REALK, &
      0.000000000000000_REALK,     -1.370431215272607_REALK,      0.000000000000000_REALK, &
     -0.447806599061727_REALK,      0.000000000000000_REALK,     -0.409593779355405_REALK, &
     -1.399507946535888_REALK,     -1.292499023736129_REALK,      0.000000000000000_REALK, &
     -1.391816301983917_REALK,      0.000000000000000_REALK,     -0.581312685304354_REALK, &
     -1.718122927081261_REALK,      0.000000000000000_REALK,     -0.557111143670293_REALK, &
      0.000000000000000_REALK,     -2.462028628698691_REALK,      0.000000000000000_REALK, &
     -0.670892724309850_REALK,      0.000000000000000_REALK,     -0.466311482665402_REALK, &
    -13.800177091450079_REALK,     -4.950911943325838_REALK,      0.000000000000000_REALK, &
     -2.999501343659373_REALK,      0.000000000000000_REALK,     -1.420898787124031_REALK, &
     -2.106303960308445_REALK,      0.000000000000000_REALK,     -0.586505397647994_REALK, &
      0.000000000000000_REALK,     -1.884896409353968_REALK,      0.000000000000000_REALK, &
     -0.426212973200462_REALK,      0.000000000000000_REALK,     -0.608275866454484_REALK, &
     -8.958893540622102_REALK,     -3.141032712180141_REALK,      0.000000000000000_REALK, &
     -1.669251215981302_REALK,      0.000000000000000_REALK,     -0.824013853498413_REALK, &
     -0.950272575941291_REALK,      0.000000000000000_REALK,     -0.338008658197063_REALK, &
      0.000000000000000_REALK,     -0.497781679174572_REALK,      0.000000000000000_REALK, &
     -0.214492869623227_REALK,      0.000000000000000_REALK,     -0.316564162384731_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.290562935632585_REALK, &
      0.000000000000000_REALK,      0.599843471439668_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.424876328982294_REALK,      0.000000000000000_REALK, &
      0.456142127651216_REALK,      0.000000000000000_REALK,      0.367291053306200_REALK, &
      0.000000000000000_REALK,      0.252395598816481_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.060951107173219_REALK, &
      0.000000000000000_REALK,      0.515231481434135_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.364476433523183_REALK,      0.000000000000000_REALK, &
      0.338513507886196_REALK,      0.000000000000000_REALK,      0.329507882087306_REALK, &
      0.000000000000000_REALK,      0.194721027455428_REALK,      0.000000000000000_REALK, &
     -1.409947200280566_REALK,     -0.743889124850408_REALK,      0.000000000000000_REALK, &
     -0.536876729704851_REALK,      0.000000000000000_REALK,     -0.430271792732361_REALK, &
     -0.461816444959720_REALK,      0.000000000000000_REALK,     -0.260238034027653_REALK, &
      0.000000000000000_REALK,     -0.475091938396647_REALK,      0.000000000000000_REALK, &
     -0.223513039693184_REALK,      0.000000000000000_REALK,     -0.299788365375868_REALK, &
     -1.663175296521073_REALK,     -0.837566700468891_REALK,      0.000000000000000_REALK, &
     -0.524868657815800_REALK,      0.000000000000000_REALK,     -0.447208346283056_REALK, &
     -0.349306735600108_REALK,      0.000000000000000_REALK,     -0.265255235197768_REALK, &
      0.000000000000000_REALK,     -0.201738751950663_REALK,      0.000000000000000_REALK, &
     -0.198351811846105_REALK,      0.000000000000000_REALK,     -0.280356898015023_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.532192029240594_REALK, &
      0.000000000000000_REALK,      0.373130268492075_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.344521042911556_REALK,      0.000000000000000_REALK, &
      0.308777622305663_REALK,      0.000000000000000_REALK,      0.389972226338776_REALK, &
      0.000000000000000_REALK,      0.256433893083029_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.044862184716384_REALK, &
      0.000000000000000_REALK,      0.811910066226904_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.794753650855329_REALK,      0.000000000000000_REALK, &
      0.541218868702073_REALK,      0.000000000000000_REALK,      0.936472229048969_REALK, &
      0.000000000000000_REALK,      0.499756016012014_REALK,      0.000000000000000_REALK, &
    -19.962547665804259_REALK,     -5.463956989551663_REALK,      0.000000000000000_REALK, &
     -2.929486783588620_REALK,      0.000000000000000_REALK,     -1.783451363332341_REALK, &
     -1.704811894329410_REALK,      0.000000000000000_REALK,     -0.555418033738183_REALK, &
      0.000000000000000_REALK,     -1.337535484097166_REALK,      0.000000000000000_REALK, &
     -0.353321100124273_REALK,      0.000000000000000_REALK,     -0.646979922131900_REALK, &
    -11.294819359876849_REALK,     -3.568491209311359_REALK,      0.000000000000000_REALK, &
     -1.950989477850182_REALK,      0.000000000000000_REALK,     -1.127181600712326_REALK, &
     -1.241713087605760_REALK,      0.000000000000000_REALK,     -0.370665895917472_REALK, &
      0.000000000000000_REALK,     -1.129477395882047_REALK,      0.000000000000000_REALK, &
     -0.222199761392097_REALK,      0.000000000000000_REALK,     -0.384705132061556_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.638985585554641_REALK, &
      0.000000000000000_REALK,      0.585762935091831_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.352248582790113_REALK,      0.000000000000000_REALK, &
      0.496825719684459_REALK,      0.000000000000000_REALK,      0.249427901012601_REALK, &
      0.000000000000000_REALK,      0.208680671604712_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.252289206973811_REALK, &
      0.000000000000000_REALK,      0.480463100720071_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.263062297015945_REALK,      0.000000000000000_REALK, &
      0.391154840002544_REALK,      0.000000000000000_REALK,      0.147562749632917_REALK, &
      0.000000000000000_REALK,      0.163269162226754_REALK,      0.000000000000000_REALK, &
     -1.762395669885480_REALK,     -0.724866213968928_REALK,      0.000000000000000_REALK, &
     -0.439936322028634_REALK,      0.000000000000000_REALK,     -0.466136333901886_REALK, &
     -0.317360542485278_REALK,      0.000000000000000_REALK,     -0.217278165335028_REALK, &
      0.000000000000000_REALK,     -0.280685708727527_REALK,      0.000000000000000_REALK, &
     -0.154979409004259_REALK,      0.000000000000000_REALK,     -0.274793135261176_REALK, &
     -1.585051470866626_REALK,     -0.796463745109567_REALK,      0.000000000000000_REALK, &
     -0.535159291305662_REALK,      0.000000000000000_REALK,     -0.492068080756528_REALK, &
     -0.433509717818657_REALK,      0.000000000000000_REALK,     -0.251949779698343_REALK, &
      0.000000000000000_REALK,     -0.443228269723139_REALK,      0.000000000000000_REALK, &
     -0.182580136016814_REALK,      0.000000000000000_REALK,     -0.279155854581374_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.530410721611834_REALK, &
      0.000000000000000_REALK,      0.277703129299087_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.199240153868298_REALK,      0.000000000000000_REALK, &
      0.263760571425581_REALK,      0.000000000000000_REALK,      0.172350904465571_REALK, &
      0.000000000000000_REALK,      0.161552829590726_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.696982708566849_REALK, &
      0.000000000000000_REALK,      0.393858796573912_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.258390546331177_REALK,      0.000000000000000_REALK, &
      0.368288340442897_REALK,      0.000000000000000_REALK,      0.171067385880324_REALK, &
      0.000000000000000_REALK,      0.223078670121904_REALK,      0.000000000000000_REALK, &
     -0.773353011233946_REALK,     -0.480449690221729_REALK,      0.000000000000000_REALK, &
     -0.383208721191097_REALK,      0.000000000000000_REALK,     -0.337448080615594_REALK, &
     -0.364228118951275_REALK,      0.000000000000000_REALK,     -0.236600549746442_REALK, &
      0.000000000000000_REALK,     -0.411613070739606_REALK,      0.000000000000000_REALK, &
     -0.220195010947641_REALK,      0.000000000000000_REALK,     -0.272877701258628_REALK, &
     -1.489384594880464_REALK,     -1.265239707275655_REALK,      0.000000000000000_REALK, &
     -1.214441499767902_REALK,      0.000000000000000_REALK,     -0.821165254718180_REALK, &
     -1.297293688564894_REALK,      0.000000000000000_REALK,     -0.686581567052233_REALK, &
      0.000000000000000_REALK,     -1.558498018158266_REALK,      0.000000000000000_REALK, &
     -0.695481517854503_REALK,      0.000000000000000_REALK,     -0.656597276907199_REALK, &
    -38.057218129033899_REALK,     -7.445498796981805_REALK,      0.000000000000000_REALK, &
     -3.553879348633433_REALK,      0.000000000000000_REALK,     -2.759208036148774_REALK, &
     -1.622309753198743_REALK,      0.000000000000000_REALK,     -0.614614734368650_REALK, &
      0.000000000000000_REALK,     -1.105529372581390_REALK,      0.000000000000000_REALK, &
     -0.347729931090281_REALK,      0.000000000000000_REALK,     -0.809885848738127_REALK, &
    -52.458822872423347_REALK,     -9.536286637643114_REALK,      0.000000000000000_REALK, &
     -3.574372026543819_REALK,      0.000000000000000_REALK,     -3.106475313381745_REALK, &
     -1.113847721692166_REALK,      0.000000000000000_REALK,     -0.631979657183980_REALK, &
      0.000000000000000_REALK,     -0.181975006717697_REALK,      0.000000000000000_REALK, &
     -0.274046351778948_REALK,      0.000000000000000_REALK,     -0.707814520488574_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.695181541875879_REALK, &
      0.000000000000000_REALK,      0.708518133884048_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.364028663847268_REALK,      0.000000000000000_REALK, &
      0.662242609988588_REALK,      0.000000000000000_REALK,      0.207701291392405_REALK, &
      0.000000000000000_REALK,      0.203821979771606_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.292099168034198_REALK, &
      0.000000000000000_REALK,      1.089577844420930_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.498661219211463_REALK,      0.000000000000000_REALK, &
      0.844766208170876_REALK,      0.000000000000000_REALK,      0.284103543580308_REALK, &
      0.000000000000000_REALK,      0.244143372035132_REALK,      0.000000000000000_REALK, &
     -3.041603529283097_REALK,     -0.928915745896580_REALK,      0.000000000000000_REALK, &
     -0.464270753355666_REALK,      0.000000000000000_REALK,     -0.649162867868619_REALK, &
     -0.268187802699437_REALK,      0.000000000000000_REALK,     -0.225076065090901_REALK, &
      0.000000000000000_REALK,     -0.193079384267535_REALK,      0.000000000000000_REALK, &
     -0.132028182343319_REALK,      0.000000000000000_REALK,     -0.308602167513810_REALK, &
     -6.774240551001514_REALK,     -1.922700724118210_REALK,      0.000000000000000_REALK, &
     -0.771149360208144_REALK,      0.000000000000000_REALK,     -1.184723276833809_REALK, &
     -0.302110557581940_REALK,      0.000000000000000_REALK,     -0.375408318788127_REALK, &
      0.000000000000000_REALK,     -0.064070537305133_REALK,      0.000000000000000_REALK, &
     -0.172945064918560_REALK,      0.000000000000000_REALK,     -0.439581815867170_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.755963597802672_REALK, &
      0.000000000000000_REALK,      0.297087473533316_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.173188142898810_REALK,      0.000000000000000_REALK, &
      0.303301954902458_REALK,      0.000000000000000_REALK,      0.122066143308266_REALK, &
      0.000000000000000_REALK,      0.139006626365383_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.099393459598597_REALK, &
      0.000000000000000_REALK,      0.821799515349633_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.455976751008981_REALK,      0.000000000000000_REALK, &
      0.676262955560877_REALK,      0.000000000000000_REALK,      0.321478227872189_REALK, &
      0.000000000000000_REALK,      0.300182054357393_REALK,      0.000000000000000_REALK, &
     -1.052194568555549_REALK,     -0.469419660370545_REALK,      0.000000000000000_REALK, &
     -0.281396475654044_REALK,      0.000000000000000_REALK,     -0.368342391029203_REALK, &
     -0.198960290283281_REALK,      0.000000000000000_REALK,     -0.186124178351440_REALK, &
      0.000000000000000_REALK,     -0.165433541195769_REALK,      0.000000000000000_REALK, &
     -0.130193525707297_REALK,      0.000000000000000_REALK,     -0.239512616368778_REALK, &
     -4.256636915904189_REALK,     -1.736106518126808_REALK,      0.000000000000000_REALK, &
     -0.827394919510281_REALK,      0.000000000000000_REALK,     -1.223881532171206_REALK, &
     -0.384727712748504_REALK,      0.000000000000000_REALK,     -0.556525989472130_REALK, &
      0.000000000000000_REALK,     -0.108864077354444_REALK,      0.000000000000000_REALK, &
     -0.303452031662451_REALK,      0.000000000000000_REALK,     -0.623518580073091_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.585575862140632_REALK, &
      0.000000000000000_REALK,      0.346338706888072_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.265235367866381_REALK,      0.000000000000000_REALK, &
      0.322636940760057_REALK,      0.000000000000000_REALK,      0.245666622684139_REALK, &
      0.000000000000000_REALK,      0.221583828120885_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.008141225306220_REALK, &
      0.000000000000000_REALK,      2.515364978614462_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.922684534467514_REALK,      0.000000000000000_REALK, &
      1.772167899508672_REALK,      0.000000000000000_REALK,      1.723747591367712_REALK, &
      0.000000000000000_REALK,      1.257031297843313_REALK,      0.000000000000000_REALK, &
     -9.323231375423196_REALK,    -11.770166669676946_REALK,      0.000000000000000_REALK, &
     -4.477069281877380_REALK,      0.000000000000000_REALK,     -2.495714455812482_REALK, &
    -17.715014679544087_REALK,      0.000000000000000_REALK,     -4.630996925494509_REALK, &
      0.000000000000000_REALK,     -9.382201425684459_REALK,      0.000000000000000_REALK, &
     -1.976514001488835_REALK,      0.000000000000000_REALK,     -3.265835637633883_REALK, &
     -2.230530479187280_REALK,     -4.643533469816484_REALK,      0.000000000000000_REALK, &
     -1.977708090791120_REALK,      0.000000000000000_REALK,     -0.862620572016876_REALK, &
     -9.311806633183245_REALK,      0.000000000000000_REALK,     -2.124110626583980_REALK, &
      0.000000000000000_REALK,     -6.096348044754742_REALK,      0.000000000000000_REALK, &
     -1.091669547966279_REALK,      0.000000000000000_REALK,     -1.386510865907751_REALK, &
    -14.474252455600187_REALK,     -6.280549679675837_REALK,      0.000000000000000_REALK, &
     -4.314462746950401_REALK,      0.000000000000000_REALK,     -3.452212119702568_REALK, &
     -6.604806243702575_REALK,      0.000000000000000_REALK,     -2.232064426330489_REALK, &
      0.000000000000000_REALK,     -5.697402178598535_REALK,      0.000000000000000_REALK, &
     -1.686332320982524_REALK,      0.000000000000000_REALK,     -4.040082932390403_REALK, &
     -4.489525550961281_REALK,     -2.050160034054874_REALK,      0.000000000000000_REALK, &
     -1.361993135054288_REALK,      0.000000000000000_REALK,     -1.151745008995628_REALK, &
     -1.802327175183607_REALK,      0.000000000000000_REALK,     -0.786325199943065_REALK, &
      0.000000000000000_REALK,     -1.277629115781756_REALK,      0.000000000000000_REALK, &
     -0.592493236092134_REALK,      0.000000000000000_REALK,     -1.511615114805731_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.172203163991719_REALK, &
      0.000000000000000_REALK,      0.936356150076487_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.078638497215486_REALK,      0.000000000000000_REALK, &
      3.397516826653178_REALK,      0.000000000000000_REALK,      1.453500467473533_REALK, &
      0.000000000000000_REALK,      1.119232914570417_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.443432346213867_REALK, &
      0.000000000000000_REALK,      0.633790939871681_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.349069157842145_REALK,      0.000000000000000_REALK, &
      1.683029053681001_REALK,      0.000000000000000_REALK,      1.297327533656893_REALK, &
      0.000000000000000_REALK,      0.865075302651801_REALK,      0.000000000000000_REALK, &
    -19.445614713908054_REALK,     -3.645572216853785_REALK,      0.000000000000000_REALK, &
     -4.139039011411468_REALK,      0.000000000000000_REALK,     -4.222727874467431_REALK, &
     -2.869714162572931_REALK,      0.000000000000000_REALK,     -1.131474305616679_REALK, &
      0.000000000000000_REALK,     -4.096134607514285_REALK,      0.000000000000000_REALK, &
     -1.462049879380716_REALK,      0.000000000000000_REALK,     -4.478083530520529_REALK, &
     -5.536213784077966_REALK,     -1.215406846906123_REALK,      0.000000000000000_REALK, &
     -1.360308166049061_REALK,      0.000000000000000_REALK,     -1.438182664352081_REALK, &
     -1.040626567261868_REALK,      0.000000000000000_REALK,     -0.414131779174481_REALK, &
      0.000000000000000_REALK,     -1.632790064666284_REALK,      0.000000000000000_REALK, &
     -0.529114098708011_REALK,      0.000000000000000_REALK,     -1.680106650891271_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.885750574281436_REALK, &
      0.000000000000000_REALK,      0.684644433957625_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.126881728302890_REALK,      0.000000000000000_REALK, &
      2.689936003938764_REALK,      0.000000000000000_REALK,      0.716171954622778_REALK, &
      0.000000000000000_REALK,      0.732850985497833_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.157373520571271_REALK, &
      0.000000000000000_REALK,      0.349726933100085_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.465493275090194_REALK,      0.000000000000000_REALK, &
      1.197079865061826_REALK,      0.000000000000000_REALK,      0.290066126601864_REALK, &
      0.000000000000000_REALK,      0.417187918038477_REALK,      0.000000000000000_REALK, &
     -1.622620172590374_REALK,     -0.826796249016822_REALK,      0.000000000000000_REALK, &
     -0.680533254301191_REALK,      0.000000000000000_REALK,     -1.075976296556161_REALK, &
     -1.009496111288064_REALK,      0.000000000000000_REALK,     -0.773810523885598_REALK, &
      0.000000000000000_REALK,     -1.190882692106703_REALK,      0.000000000000000_REALK, &
     -0.732899034984733_REALK,      0.000000000000000_REALK,     -1.925405379192117_REALK, &
     -0.912346595585869_REALK,     -0.666664408009835_REALK,      0.000000000000000_REALK, &
     -0.657192619865199_REALK,      0.000000000000000_REALK,     -0.793612128917369_REALK, &
     -1.087919701088724_REALK,      0.000000000000000_REALK,     -0.720539556858206_REALK, &
      0.000000000000000_REALK,     -1.556788579508783_REALK,      0.000000000000000_REALK, &
     -0.810525596396154_REALK,      0.000000000000000_REALK,     -1.612721249712865_REALK, &
    -27.108006203964788_REALK,     -1.558706131060559_REALK,      0.000000000000000_REALK, &
     -4.455792829865715_REALK,      0.000000000000000_REALK,     -5.279511719689736_REALK, &
     -0.825972966653147_REALK,      0.000000000000000_REALK,     -0.413297968283791_REALK, &
      0.000000000000000_REALK,     -3.463133944227822_REALK,      0.000000000000000_REALK, &
     -1.403916076645858_REALK,      0.000000000000000_REALK,     -4.990151559705014_REALK, &
    -10.604740879185524_REALK,     -0.545509404109621_REALK,      0.000000000000000_REALK, &
     -1.511219350170433_REALK,      0.000000000000000_REALK,     -2.069569127182815_REALK, &
     -0.111374780518649_REALK,      0.000000000000000_REALK,     -0.143287840403009_REALK, &
      0.000000000000000_REALK,     -0.820116547715043_REALK,      0.000000000000000_REALK, &
     -0.485720973396331_REALK,      0.000000000000000_REALK,     -1.998725358329863_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.202540782497496_REALK, &
      0.000000000000000_REALK,      0.469742346509439_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.826495737963705_REALK,      0.000000000000000_REALK, &
      2.540049559597615_REALK,      0.000000000000000_REALK,      0.368064279089553_REALK, &
      0.000000000000000_REALK,      0.443864644899396_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.591925446178664_REALK, &
      0.000000000000000_REALK,      0.276589938610872_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.391525757333226_REALK,      0.000000000000000_REALK, &
      1.247447959397087_REALK,      0.000000000000000_REALK,      0.227114168384736_REALK, &
      0.000000000000000_REALK,      0.268028347804755_REALK,      0.000000000000000_REALK, &
     -1.961425358909521_REALK,     -0.550541729519211_REALK,      0.000000000000000_REALK, &
     -0.486640432478769_REALK,      0.000000000000000_REALK,     -1.151630934340744_REALK, &
     -0.422825905782475_REALK,      0.000000000000000_REALK,     -0.434407710680799_REALK, &
      0.000000000000000_REALK,     -0.513841599721261_REALK,      0.000000000000000_REALK, &
     -0.459923098728780_REALK,      0.000000000000000_REALK,     -1.814021777051725_REALK, &
     -1.434860866691496_REALK,     -0.415195747683101_REALK,      0.000000000000000_REALK, &
     -0.315676151141398_REALK,      0.000000000000000_REALK,     -0.833040135484240_REALK, &
     -0.213319899791887_REALK,      0.000000000000000_REALK,     -0.324438016346519_REALK, &
      0.000000000000000_REALK,     -0.162648720045899_REALK,      0.000000000000000_REALK, &
     -0.306199483650508_REALK,      0.000000000000000_REALK,     -1.347507778259412_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.879837637067377_REALK, &
      0.000000000000000_REALK,      0.362721169278668_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.445588658495659_REALK,      0.000000000000000_REALK, &
      1.155960920487693_REALK,      0.000000000000000_REALK,      0.452559058715106_REALK, &
      0.000000000000000_REALK,      0.571825597139381_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.006812403479688_REALK, &
      0.000000000000000_REALK,      0.560996705736200_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.667832823819174_REALK,      0.000000000000000_REALK, &
      1.303444370849475_REALK,      0.000000000000000_REALK,      0.838467268676393_REALK, &
      0.000000000000000_REALK,      0.910427634757856_REALK,      0.000000000000000_REALK, &
    -41.820588610985055_REALK,      1.305991771098565_REALK,      0.000000000000000_REALK, &
     -5.751291075635872_REALK,      0.000000000000000_REALK,     -7.133345741762692_REALK, &
      0.926763105708369_REALK,      0.000000000000000_REALK,      0.287431277550325_REALK, &
      0.000000000000000_REALK,     -3.832372643320708_REALK,      0.000000000000000_REALK, &
     -1.575151318254383_REALK,      0.000000000000000_REALK,     -5.847909141043167_REALK, &
    -16.418885893593718_REALK,      0.746148404606505_REALK,      0.000000000000000_REALK, &
     -2.375800378721739_REALK,      0.000000000000000_REALK,     -3.244954444891051_REALK, &
      0.438426978579631_REALK,      0.000000000000000_REALK,      0.173583915121854_REALK, &
      0.000000000000000_REALK,     -1.642582914031928_REALK,      0.000000000000000_REALK, &
     -0.654019896441471_REALK,      0.000000000000000_REALK,     -2.680861611169000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.215780890895165_REALK, &
      0.000000000000000_REALK,      0.218691224596733_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.776769321037018_REALK,      0.000000000000000_REALK, &
      2.792338949649658_REALK,      0.000000000000000_REALK,      0.113314778924388_REALK, &
      0.000000000000000_REALK,      0.177935481305177_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.273037614703806_REALK, &
      0.000000000000000_REALK,      0.117449075051182_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.375467892744283_REALK,      0.000000000000000_REALK, &
      1.588613431479360_REALK,      0.000000000000000_REALK,      0.012783396363314_REALK, &
      0.000000000000000_REALK,      0.096751304533223_REALK,      0.000000000000000_REALK, &
     -2.757129345843358_REALK,     -0.398686181138647_REALK,      0.000000000000000_REALK, &
     -0.453717609944337_REALK,      0.000000000000000_REALK,     -1.403637434733766_REALK, &
     -0.214477209707537_REALK,      0.000000000000000_REALK,     -0.261188072124683_REALK, &
      0.000000000000000_REALK,     -0.337736782698887_REALK,      0.000000000000000_REALK, &
     -0.367974355429585_REALK,      0.000000000000000_REALK,     -1.896143978776191_REALK, &
     -1.752959894941249_REALK,     -0.316847888006627_REALK,      0.000000000000000_REALK, &
     -0.342039328040705_REALK,      0.000000000000000_REALK,     -1.095002195263223_REALK, &
     -0.192518566028738_REALK,      0.000000000000000_REALK,     -0.225104253188825_REALK, &
      0.000000000000000_REALK,     -0.312130800831954_REALK,      0.000000000000000_REALK, &
     -0.285072538133847_REALK,      0.000000000000000_REALK,     -1.519337774161213_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.995839513339005_REALK, &
      0.000000000000000_REALK,      0.259110914685812_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.275791121636047_REALK,      0.000000000000000_REALK, &
      1.084031079166123_REALK,      0.000000000000000_REALK,      0.201676140519199_REALK, &
      0.000000000000000_REALK,      0.347767041472471_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.968297008474552_REALK, &
      0.000000000000000_REALK,      0.299741264932847_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.258186714009592_REALK,      0.000000000000000_REALK, &
      1.154163119708366_REALK,      0.000000000000000_REALK,      0.151921702978275_REALK, &
      0.000000000000000_REALK,      0.417661713250238_REALK,      0.000000000000000_REALK, &
     -0.833698302959653_REALK,     -0.330921029060768_REALK,      0.000000000000000_REALK, &
     -0.277963959440074_REALK,      0.000000000000000_REALK,     -0.705500144786257_REALK, &
     -0.284442860857513_REALK,      0.000000000000000_REALK,     -0.357265268887112_REALK, &
      0.000000000000000_REALK,     -0.368971398129110_REALK,      0.000000000000000_REALK, &
     -0.371611567725848_REALK,      0.000000000000000_REALK,     -1.322963393661246_REALK, &
     -1.105826620143463_REALK,     -0.667481985943833_REALK,      0.000000000000000_REALK, &
     -0.651448037390310_REALK,      0.000000000000000_REALK,     -1.249479770581921_REALK, &
     -0.763309100643891_REALK,      0.000000000000000_REALK,     -0.822520846743814_REALK, &
      0.000000000000000_REALK,     -1.088305382383584_REALK,      0.000000000000000_REALK, &
     -0.924129616339119_REALK,      0.000000000000000_REALK,     -2.467602995531107_REALK, &
    -78.156334066946329_REALK,      7.590670881694013_REALK,      0.000000000000000_REALK, &
     -9.304979415657511_REALK,      0.000000000000000_REALK,    -11.003783256955435_REALK, &
      3.536976616716817_REALK,      0.000000000000000_REALK,      1.343668862447501_REALK, &
      0.000000000000000_REALK,     -5.477960221591667_REALK,      0.000000000000000_REALK, &
     -2.109987350615610_REALK,      0.000000000000000_REALK,     -7.460711045038047_REALK, &
    -71.355107860450133_REALK,      7.733248095670861_REALK,      0.000000000000000_REALK, &
     -6.536326768923669_REALK,      0.000000000000000_REALK,     -8.486084606839215_REALK, &
      2.808980686160067_REALK,      0.000000000000000_REALK,      1.113311694012557_REALK, &
      0.000000000000000_REALK,     -2.687846227738516_REALK,      0.000000000000000_REALK, &
     -1.209482196803936_REALK,      0.000000000000000_REALK,     -4.679066894327863_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.805119683994290_REALK, &
      0.000000000000000_REALK,     -0.211476240502596_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.957373603738905_REALK,      0.000000000000000_REALK, &
      3.607543466307157_REALK,      0.000000000000000_REALK,     -0.149098138632259_REALK, &
      0.000000000000000_REALK,     -0.139521487866823_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.339948911573953_REALK, &
      0.000000000000000_REALK,     -0.290381330110068_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.754071618540991_REALK,      0.000000000000000_REALK, &
      3.161194598133266_REALK,      0.000000000000000_REALK,     -0.119221865213119_REALK, &
      0.000000000000000_REALK,     -0.155666197601553_REALK,      0.000000000000000_REALK, &
     -4.857493552163216_REALK,     -0.220156086541486_REALK,      0.000000000000000_REALK, &
     -0.551267944286317_REALK,      0.000000000000000_REALK,     -2.015477172644055_REALK, &
     -0.070902139598993_REALK,      0.000000000000000_REALK,     -0.115063440946951_REALK, &
      0.000000000000000_REALK,     -0.291734037319882_REALK,      0.000000000000000_REALK, &
     -0.366385366195310_REALK,      0.000000000000000_REALK,     -2.224579553720288_REALK, &
     -7.556573174831203_REALK,     -0.270944702070594_REALK,      0.000000000000000_REALK, &
     -0.591107755720174_REALK,      0.000000000000000_REALK,     -2.644437611628290_REALK, &
      0.005669205921104_REALK,      0.000000000000000_REALK,     -0.116381883787995_REALK, &
      0.000000000000000_REALK,     -0.124730256924876_REALK,      0.000000000000000_REALK, &
     -0.320691452068052_REALK,      0.000000000000000_REALK,     -2.363588239625863_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.460184117409689_REALK, &
      0.000000000000000_REALK,      0.201929154881281_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.243520029025333_REALK,      0.000000000000000_REALK, &
      1.260839710568710_REALK,      0.000000000000000_REALK,      0.107083909961818_REALK, &
      0.000000000000000_REALK,      0.219817026579277_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.849921159338292_REALK, &
      0.000000000000000_REALK,      0.410046702015041_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.375404256290702_REALK,      0.000000000000000_REALK, &
      1.998542551091584_REALK,      0.000000000000000_REALK,      0.190704036957615_REALK, &
      0.000000000000000_REALK,      0.360244216643633_REALK,      0.000000000000000_REALK, &
     -1.257558888147180_REALK,     -0.284582371323212_REALK,      0.000000000000000_REALK, &
     -0.219042931080960_REALK,      0.000000000000000_REALK,     -0.857295091832736_REALK, &
     -0.139621217589160_REALK,      0.000000000000000_REALK,     -0.242294774937730_REALK, &
      0.000000000000000_REALK,     -0.157176592188089_REALK,      0.000000000000000_REALK, &
     -0.237057391577043_REALK,      0.000000000000000_REALK,     -1.299995154861865_REALK, &
     -3.782322294475655_REALK,     -0.828399263294699_REALK,      0.000000000000000_REALK, &
     -0.463452536705761_REALK,      0.000000000000000_REALK,     -2.170337820120800_REALK, &
     -0.183348239837839_REALK,      0.000000000000000_REALK,     -0.575559670579195_REALK, &
      0.000000000000000_REALK,     -0.068889544239188_REALK,      0.000000000000000_REALK, &
     -0.408789517140675_REALK,      0.000000000000000_REALK,     -2.653623158160282_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.790462412313811_REALK, &
      0.000000000000000_REALK,      0.301002232025280_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.267390097234190_REALK,      0.000000000000000_REALK, &
      0.937328994168732_REALK,      0.000000000000000_REALK,      0.257710284893965_REALK, &
      0.000000000000000_REALK,      0.450109225447822_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.779113036432991_REALK, &
      0.000000000000000_REALK,      1.723212565543977_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.395556641599758_REALK,      0.000000000000000_REALK, &
      3.624954498671241_REALK,      0.000000000000000_REALK,      1.387302485301791_REALK, &
      0.000000000000000_REALK,      2.063736248659170_REALK,      0.000000000000000_REALK/
  ! results of test 5, ket-major order, NEF 005
  data REF_CONTR_INTS(8821:10080)                                                          &
    /-9.565644212411030_REALK,     -9.711912232037456_REALK,      0.000000000000000_REALK, &
    -12.205906677444391_REALK,      0.000000000000000_REALK,     -1.667142388114481_REALK, &
    -18.700537028120426_REALK,      0.000000000000000_REALK,     -2.084146441653161_REALK, &
      0.000000000000000_REALK,    -41.049704740586400_REALK,      0.000000000000000_REALK, &
     -3.900795324311174_REALK,      0.000000000000000_REALK,     -1.611412494513608_REALK, &
     -6.656437880809393_REALK,     -7.916339000131509_REALK,      0.000000000000000_REALK, &
    -11.119547047462618_REALK,      0.000000000000000_REALK,     -1.235225241749726_REALK, &
    -18.553469396134695_REALK,      0.000000000000000_REALK,     -1.722681493461891_REALK, &
      0.000000000000000_REALK,    -41.129911917361838_REALK,      0.000000000000000_REALK, &
     -3.315156172427407_REALK,      0.000000000000000_REALK,     -1.108967823428217_REALK, &
     -6.302301924876631_REALK,     -5.164385564222302_REALK,      0.000000000000000_REALK, &
     -5.137114225305277_REALK,      0.000000000000000_REALK,     -0.973725389204929_REALK, &
     -6.211027121567177_REALK,      0.000000000000000_REALK,     -0.975209095184021_REALK, &
      0.000000000000000_REALK,    -10.215126725631398_REALK,      0.000000000000000_REALK, &
     -1.391011819409796_REALK,      0.000000000000000_REALK,     -0.794236373095826_REALK, &
     -3.449599229328284_REALK,     -2.614759965744546_REALK,      0.000000000000000_REALK, &
     -2.205773123032852_REALK,      0.000000000000000_REALK,     -0.513313575998535_REALK, &
     -1.854627361612647_REALK,      0.000000000000000_REALK,     -0.474674662042660_REALK, &
      0.000000000000000_REALK,     -1.035099196794611_REALK,      0.000000000000000_REALK, &
     -0.547344602414206_REALK,      0.000000000000000_REALK,     -0.378149619757266_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.118113710930520_REALK, &
      0.000000000000000_REALK,      1.182849098887179_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.554367713876994_REALK,      0.000000000000000_REALK, &
      0.628146243142802_REALK,      0.000000000000000_REALK,      2.832824344371839_REALK, &
      0.000000000000000_REALK,      0.939814308947235_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.158232839057435_REALK, &
      0.000000000000000_REALK,      1.339898642855034_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.896626918441561_REALK,      0.000000000000000_REALK, &
      0.622430714725189_REALK,      0.000000000000000_REALK,      3.488046776888988_REALK, &
      0.000000000000000_REALK,      0.962441616137296_REALK,      0.000000000000000_REALK, &
     -5.189846235629029_REALK,     -3.641800920722478_REALK,      0.000000000000000_REALK, &
     -3.073787748511879_REALK,      0.000000000000000_REALK,     -0.706374856799853_REALK, &
     -3.240110104913926_REALK,      0.000000000000000_REALK,     -0.599948893447051_REALK, &
      0.000000000000000_REALK,     -4.563599458576594_REALK,      0.000000000000000_REALK, &
     -0.698199032500975_REALK,      0.000000000000000_REALK,     -0.482831286618171_REALK, &
     -2.795475920748741_REALK,     -2.107865117532934_REALK,      0.000000000000000_REALK, &
     -1.945210387638099_REALK,      0.000000000000000_REALK,     -0.392041092272781_REALK, &
     -2.306633407937460_REALK,      0.000000000000000_REALK,     -0.338110664651797_REALK, &
      0.000000000000000_REALK,     -3.723259154735373_REALK,      0.000000000000000_REALK, &
     -0.394714624879658_REALK,      0.000000000000000_REALK,     -0.239752472180441_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.724206176576625_REALK, &
      0.000000000000000_REALK,      0.608303494877145_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.626136870971337_REALK,      0.000000000000000_REALK, &
      0.354406832317734_REALK,      0.000000000000000_REALK,      0.863643487422386_REALK, &
      0.000000000000000_REALK,      0.406542812074074_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.505741992302636_REALK, &
      0.000000000000000_REALK,      0.396995593186786_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.336808182164877_REALK,      0.000000000000000_REALK, &
      0.242405654365148_REALK,      0.000000000000000_REALK,      0.289869223425215_REALK, &
      0.000000000000000_REALK,      0.240732490434762_REALK,      0.000000000000000_REALK, &
     -1.012651393203693_REALK,     -0.925607521082394_REALK,      0.000000000000000_REALK, &
     -1.024237138436385_REALK,      0.000000000000000_REALK,     -0.407927337817612_REALK, &
     -1.370431215272607_REALK,      0.000000000000000_REALK,     -0.447806599061727_REALK, &
      0.000000000000000_REALK,     -2.390862879144258_REALK,      0.000000000000000_REALK, &
     -0.667867490943086_REALK,      0.000000000000000_REALK,     -0.446183563343733_REALK, &
     -1.292499023736128_REALK,     -1.391816301983916_REALK,      0.000000000000000_REALK, &
     -1.718122927081264_REALK,      0.000000000000000_REALK,     -0.557111143670293_REALK, &
     -2.462028628698690_REALK,      0.000000000000000_REALK,     -0.670892724309849_REALK, &
      0.000000000000000_REALK,     -4.317168824643114_REALK,      0.000000000000000_REALK, &
     -1.023929373277095_REALK,      0.000000000000000_REALK,     -0.554721511995761_REALK, &
     -4.950911943325834_REALK,     -2.999501343659372_REALK,      0.000000000000000_REALK, &
     -2.106303960308447_REALK,      0.000000000000000_REALK,     -0.586505397647994_REALK, &
     -1.884896409353963_REALK,      0.000000000000000_REALK,     -0.426212973200462_REALK, &
      0.000000000000000_REALK,     -2.144504174139946_REALK,      0.000000000000000_REALK, &
     -0.399077229023465_REALK,      0.000000000000000_REALK,     -0.333170329546976_REALK, &
     -3.141032712180138_REALK,     -1.669251215981303_REALK,      0.000000000000000_REALK, &
     -0.950272575941291_REALK,      0.000000000000000_REALK,     -0.338008658197063_REALK, &
     -0.497781679174581_REALK,      0.000000000000000_REALK,     -0.214492869623227_REALK, &
      0.000000000000000_REALK,      0.090275240268123_REALK,      0.000000000000000_REALK, &
     -0.156871680353688_REALK,      0.000000000000000_REALK,     -0.163890709540855_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.599843471439668_REALK, &
      0.000000000000000_REALK,      0.424876328982294_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.367291053306200_REALK,      0.000000000000000_REALK, &
      0.252395598816481_REALK,      0.000000000000000_REALK,      0.425912881277232_REALK, &
      0.000000000000000_REALK,      0.236102831593015_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.515231481434135_REALK, &
      0.000000000000000_REALK,      0.364476433523183_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.329507882087306_REALK,      0.000000000000000_REALK, &
      0.194721027455428_REALK,      0.000000000000000_REALK,      0.403880985357225_REALK, &
      0.000000000000000_REALK,      0.172514429429338_REALK,      0.000000000000000_REALK, &
     -0.743889124850408_REALK,     -0.536876729704851_REALK,      0.000000000000000_REALK, &
     -0.461816444959719_REALK,      0.000000000000000_REALK,     -0.260238034027653_REALK, &
     -0.475091938396647_REALK,      0.000000000000000_REALK,     -0.223513039693184_REALK, &
      0.000000000000000_REALK,     -0.610646258335232_REALK,      0.000000000000000_REALK, &
     -0.251738260097010_REALK,      0.000000000000000_REALK,     -0.236932678520289_REALK, &
     -0.837566700468891_REALK,     -0.524868657815800_REALK,      0.000000000000000_REALK, &
     -0.349306735600108_REALK,      0.000000000000000_REALK,     -0.265255235197768_REALK, &
     -0.201738751950664_REALK,      0.000000000000000_REALK,     -0.198351811846105_REALK, &
      0.000000000000000_REALK,      0.023237633314392_REALK,      0.000000000000000_REALK, &
     -0.167460772400510_REALK,      0.000000000000000_REALK,     -0.208200182926571_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.373130268492075_REALK, &
      0.000000000000000_REALK,      0.344521042911556_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.389972226338775_REALK,      0.000000000000000_REALK, &
      0.256433893083029_REALK,      0.000000000000000_REALK,      0.567328305294531_REALK, &
      0.000000000000000_REALK,      0.307091579047144_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.811910066226904_REALK, &
      0.000000000000000_REALK,      0.794753650855329_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.936472229048969_REALK,      0.000000000000000_REALK, &
      0.499756016012014_REALK,      0.000000000000000_REALK,      1.350443481876457_REALK, &
      0.000000000000000_REALK,      0.608263098833308_REALK,      0.000000000000000_REALK, &
     -5.463956989551660_REALK,     -2.929486783588622_REALK,      0.000000000000000_REALK, &
     -1.704811894329409_REALK,      0.000000000000000_REALK,     -0.555418033738183_REALK, &
     -1.337535484097163_REALK,      0.000000000000000_REALK,     -0.353321100124273_REALK, &
      0.000000000000000_REALK,     -1.279196296993014_REALK,      0.000000000000000_REALK, &
     -0.265460432605356_REALK,      0.000000000000000_REALK,     -0.258640470670884_REALK, &
     -3.568491209311357_REALK,     -1.950989477850183_REALK,      0.000000000000000_REALK, &
     -1.241713087605759_REALK,      0.000000000000000_REALK,     -0.370665895917472_REALK, &
     -1.129477395882056_REALK,      0.000000000000000_REALK,     -0.222199761392097_REALK, &
      0.000000000000000_REALK,     -1.444680512405603_REALK,      0.000000000000000_REALK, &
     -0.165680779831523_REALK,      0.000000000000000_REALK,     -0.148608864468541_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.585762935091831_REALK, &
      0.000000000000000_REALK,      0.352248582790113_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.249427901012601_REALK,      0.000000000000000_REALK, &
      0.208680671604712_REALK,      0.000000000000000_REALK,      0.236665608627321_REALK, &
      0.000000000000000_REALK,      0.160905166741620_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.480463100720071_REALK, &
      0.000000000000000_REALK,      0.263062297015945_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.147562749632917_REALK,      0.000000000000000_REALK, &
      0.163269162226754_REALK,      0.000000000000000_REALK,      0.070037409684725_REALK, &
      0.000000000000000_REALK,      0.104705232293845_REALK,      0.000000000000000_REALK, &
     -0.724866213968927_REALK,     -0.439936322028634_REALK,      0.000000000000000_REALK, &
     -0.317360542485278_REALK,      0.000000000000000_REALK,     -0.217278165335029_REALK, &
     -0.280685708727527_REALK,      0.000000000000000_REALK,     -0.154979409004259_REALK, &
      0.000000000000000_REALK,     -0.310441170188676_REALK,      0.000000000000000_REALK, &
     -0.141902888541757_REALK,      0.000000000000000_REALK,     -0.162206969545945_REALK, &
     -0.796463745109567_REALK,     -0.535159291305662_REALK,      0.000000000000000_REALK, &
     -0.433509717818657_REALK,      0.000000000000000_REALK,     -0.251949779698343_REALK, &
     -0.443228269723139_REALK,      0.000000000000000_REALK,     -0.182580136016814_REALK, &
      0.000000000000000_REALK,     -0.585864289537623_REALK,      0.000000000000000_REALK, &
     -0.170238203235798_REALK,      0.000000000000000_REALK,     -0.165217201886431_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.277703129299087_REALK, &
      0.000000000000000_REALK,      0.199240153868299_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.172350904465571_REALK,      0.000000000000000_REALK, &
      0.161552829590726_REALK,      0.000000000000000_REALK,      0.186461843622566_REALK, &
      0.000000000000000_REALK,      0.146333304707935_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.393858796573912_REALK, &
      0.000000000000000_REALK,      0.258390546331177_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.171067385880324_REALK,      0.000000000000000_REALK, &
      0.223078670121904_REALK,      0.000000000000000_REALK,      0.091878156512798_REALK, &
      0.000000000000000_REALK,      0.168714378788276_REALK,      0.000000000000000_REALK, &
     -0.480449690221729_REALK,     -0.383208721191097_REALK,      0.000000000000000_REALK, &
     -0.364228118951275_REALK,      0.000000000000000_REALK,     -0.236600549746442_REALK, &
     -0.411613070739606_REALK,      0.000000000000000_REALK,     -0.220195010947640_REALK, &
      0.000000000000000_REALK,     -0.571515132935126_REALK,      0.000000000000000_REALK, &
     -0.261935366990058_REALK,      0.000000000000000_REALK,     -0.239512616368778_REALK, &
     -1.265239707275654_REALK,     -1.214441499767901_REALK,      0.000000000000000_REALK, &
     -1.297293688564893_REALK,      0.000000000000000_REALK,     -0.686581567052233_REALK, &
     -1.558498018158265_REALK,      0.000000000000000_REALK,     -0.695481517854502_REALK, &
      0.000000000000000_REALK,     -2.160463747873751_REALK,      0.000000000000000_REALK, &
     -0.840751996781423_REALK,      0.000000000000000_REALK,     -0.623518580073091_REALK, &
     -7.445498796981797_REALK,     -3.553879348633434_REALK,      0.000000000000000_REALK, &
     -1.622309753198743_REALK,      0.000000000000000_REALK,     -0.614614734368651_REALK, &
     -1.105529372581388_REALK,      0.000000000000000_REALK,     -0.347729931090281_REALK, &
      0.000000000000000_REALK,     -0.829107522333123_REALK,      0.000000000000000_REALK, &
     -0.200546603551979_REALK,      0.000000000000000_REALK,     -0.226328408917684_REALK, &
     -9.536286637643116_REALK,     -3.574372026543823_REALK,      0.000000000000000_REALK, &
     -1.113847721692165_REALK,      0.000000000000000_REALK,     -0.631979657183981_REALK, &
     -0.181975006717716_REALK,      0.000000000000000_REALK,     -0.274046351778948_REALK, &
      0.000000000000000_REALK,      0.646342293866753_REALK,      0.000000000000000_REALK, &
     -0.106006430430374_REALK,      0.000000000000000_REALK,     -0.171708156201073_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.708518133884047_REALK, &
      0.000000000000000_REALK,      0.364028663847268_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.207701291392405_REALK,      0.000000000000000_REALK, &
      0.203821979771606_REALK,      0.000000000000000_REALK,      0.165814142616076_REALK, &
      0.000000000000000_REALK,      0.131748079153483_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.089577844420931_REALK, &
      0.000000000000000_REALK,      0.498661219211463_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.284103543580308_REALK,      0.000000000000000_REALK, &
      0.244143372035131_REALK,      0.000000000000000_REALK,      0.242253608330985_REALK, &
      0.000000000000000_REALK,      0.132392947347485_REALK,      0.000000000000000_REALK, &
     -0.928915745896581_REALK,     -0.464270753355666_REALK,      0.000000000000000_REALK, &
     -0.268187802699437_REALK,      0.000000000000000_REALK,     -0.225076065090901_REALK, &
     -0.193079384267534_REALK,      0.000000000000000_REALK,     -0.132028182343319_REALK, &
      0.000000000000000_REALK,     -0.166929797296717_REALK,      0.000000000000000_REALK, &
     -0.095065027032538_REALK,      0.000000000000000_REALK,     -0.132772555661791_REALK, &
     -1.922700724118209_REALK,     -0.771149360208144_REALK,      0.000000000000000_REALK, &
     -0.302110557581940_REALK,      0.000000000000000_REALK,     -0.375408318788127_REALK, &
     -0.064070537305134_REALK,      0.000000000000000_REALK,     -0.172945064918560_REALK, &
      0.000000000000000_REALK,      0.138416199186490_REALK,      0.000000000000000_REALK, &
     -0.082586762340528_REALK,      0.000000000000000_REALK,     -0.164888703231810_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.297087473533316_REALK, &
      0.000000000000000_REALK,      0.173188142898810_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.122066143308266_REALK,      0.000000000000000_REALK, &
      0.139006626365383_REALK,      0.000000000000000_REALK,      0.109321521094696_REALK, &
      0.000000000000000_REALK,      0.100451799050720_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.821799515349633_REALK, &
      0.000000000000000_REALK,      0.455976751008982_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.321478227872189_REALK,      0.000000000000000_REALK, &
      0.300182054357392_REALK,      0.000000000000000_REALK,      0.298140565055607_REALK, &
      0.000000000000000_REALK,      0.195461701578938_REALK,      0.000000000000000_REALK, &
     -0.469419660370544_REALK,     -0.281396475654044_REALK,      0.000000000000000_REALK, &
     -0.198960290283281_REALK,      0.000000000000000_REALK,     -0.186124178351440_REALK, &
     -0.165433541195769_REALK,      0.000000000000000_REALK,     -0.130193525707297_REALK, &
      0.000000000000000_REALK,     -0.163144845512231_REALK,      0.000000000000000_REALK, &
     -0.113658030185786_REALK,      0.000000000000000_REALK,     -0.148993076943052_REALK, &
     -1.736106518126808_REALK,     -0.827394919510281_REALK,      0.000000000000000_REALK, &
     -0.384727712748504_REALK,      0.000000000000000_REALK,     -0.556525989472130_REALK, &
     -0.108864077354444_REALK,      0.000000000000000_REALK,     -0.303452031662451_REALK, &
      0.000000000000000_REALK,      0.142709407256813_REALK,      0.000000000000000_REALK, &
     -0.170128390930401_REALK,      0.000000000000000_REALK,     -0.334090821016778_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.346338706888072_REALK, &
      0.000000000000000_REALK,      0.265235367866381_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.245666622684139_REALK,      0.000000000000000_REALK, &
      0.221583828120885_REALK,      0.000000000000000_REALK,      0.279369203974659_REALK, &
      0.000000000000000_REALK,      0.208025736902232_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.515364978614463_REALK, &
      0.000000000000000_REALK,      1.922684534467514_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.723747591367711_REALK,      0.000000000000000_REALK, &
      1.257031297843312_REALK,      0.000000000000000_REALK,      1.815518238986838_REALK, &
      0.000000000000000_REALK,      1.121985656722484_REALK,      0.000000000000000_REALK, &
    -11.770166669676907_REALK,     -4.477069281877381_REALK,      0.000000000000000_REALK, &
    -17.715014679544090_REALK,      0.000000000000000_REALK,     -4.630996925494514_REALK, &
     -9.382201425684405_REALK,      0.000000000000000_REALK,     -1.976514001488834_REALK, &
      0.000000000000000_REALK,   -129.034090488359595_REALK,      0.000000000000000_REALK, &
    -20.523343098286755_REALK,      0.000000000000000_REALK,    -16.048928987922444_REALK, &
     -4.643533469816514_REALK,     -1.977708090791111_REALK,      0.000000000000000_REALK, &
     -9.311806633183227_REALK,      0.000000000000000_REALK,     -2.124110626583982_REALK, &
     -6.096348044754752_REALK,      0.000000000000000_REALK,     -1.091669547966282_REALK, &
      0.000000000000000_REALK,    -86.179923291477223_REALK,      0.000000000000000_REALK, &
    -12.154631942052328_REALK,      0.000000000000000_REALK,     -8.258678355687255_REALK, &
     -6.280549679675821_REALK,     -4.314462746950403_REALK,      0.000000000000000_REALK, &
     -6.604806243702576_REALK,      0.000000000000000_REALK,     -2.232064426330489_REALK, &
     -5.697402178598532_REALK,      0.000000000000000_REALK,     -1.686332320982525_REALK, &
      0.000000000000000_REALK,    -31.442381197937955_REALK,      0.000000000000000_REALK, &
     -6.767758928665331_REALK,      0.000000000000000_REALK,     -6.866140636731163_REALK, &
     -2.050160034054884_REALK,     -1.361993135054286_REALK,      0.000000000000000_REALK, &
     -1.802327175183603_REALK,      0.000000000000000_REALK,     -0.786325199943064_REALK, &
     -1.277629115781762_REALK,      0.000000000000000_REALK,     -0.592493236092136_REALK, &
      0.000000000000000_REALK,     -2.736122200223746_REALK,      0.000000000000000_REALK, &
     -1.932635365922618_REALK,      0.000000000000000_REALK,     -2.567097342100559_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.936356150076486_REALK, &
      0.000000000000000_REALK,      2.078638497215485_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.453500467473530_REALK,      0.000000000000000_REALK, &
      1.119232914570414_REALK,      0.000000000000000_REALK,     10.248521972383720_REALK, &
      0.000000000000000_REALK,      6.426863184011113_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.633790939871679_REALK, &
      0.000000000000000_REALK,      1.349069157842146_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.297327533656894_REALK,      0.000000000000000_REALK, &
      0.865075302651804_REALK,      0.000000000000000_REALK,      8.482978706374121_REALK, &
      0.000000000000000_REALK,      4.497263591157074_REALK,      0.000000000000000_REALK, &
     -3.645572216853775_REALK,     -4.139039011411468_REALK,      0.000000000000000_REALK, &
     -2.869714162572930_REALK,      0.000000000000000_REALK,     -1.131474305616679_REALK, &
     -4.096134607514299_REALK,      0.000000000000000_REALK,     -1.462049879380714_REALK, &
      0.000000000000000_REALK,    -10.351073777025745_REALK,      0.000000000000000_REALK, &
     -2.498567987044496_REALK,      0.000000000000000_REALK,     -2.951769803384728_REALK, &
     -1.215406846906125_REALK,     -1.360308166049059_REALK,      0.000000000000000_REALK, &
     -1.040626567261866_REALK,      0.000000000000000_REALK,     -0.414131779174480_REALK, &
     -1.632790064666279_REALK,      0.000000000000000_REALK,     -0.529114098708012_REALK, &
      0.000000000000000_REALK,     -5.173538720026558_REALK,      0.000000000000000_REALK, &
     -0.914020828277213_REALK,      0.000000000000000_REALK,     -1.088675346683087_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.684644433957626_REALK, &
      0.000000000000000_REALK,      1.126881728302888_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.716171954622777_REALK,      0.000000000000000_REALK, &
      0.732850985497834_REALK,      0.000000000000000_REALK,      3.296107202456991_REALK, &
      0.000000000000000_REALK,      2.931994879275415_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.349726933100084_REALK, &
      0.000000000000000_REALK,      0.465493275090195_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.290066126601864_REALK,      0.000000000000000_REALK, &
      0.417187918038478_REALK,      0.000000000000000_REALK,      0.806977587296172_REALK, &
      0.000000000000000_REALK,      1.222003897287280_REALK,      0.000000000000000_REALK, &
     -0.826796249016820_REALK,     -0.680533254301191_REALK,      0.000000000000000_REALK, &
     -1.009496111288063_REALK,      0.000000000000000_REALK,     -0.773810523885599_REALK, &
     -1.190882692106704_REALK,      0.000000000000000_REALK,     -0.732899034984732_REALK, &
      0.000000000000000_REALK,     -5.561221309223015_REALK,      0.000000000000000_REALK, &
     -2.611682252456347_REALK,      0.000000000000000_REALK,     -3.338462564050839_REALK, &
     -0.666664408009835_REALK,     -0.657192619865198_REALK,      0.000000000000000_REALK, &
     -1.087919701088724_REALK,      0.000000000000000_REALK,     -0.720539556858205_REALK, &
     -1.556788579508784_REALK,      0.000000000000000_REALK,     -0.810525596396156_REALK, &
      0.000000000000000_REALK,     -6.966636480918462_REALK,      0.000000000000000_REALK, &
     -2.887723303013340_REALK,      0.000000000000000_REALK,     -3.182795721537421_REALK, &
     -1.558706131060558_REALK,     -4.455792829865716_REALK,      0.000000000000000_REALK, &
     -0.825972966653146_REALK,      0.000000000000000_REALK,     -0.413297968283790_REALK, &
     -3.463133944227838_REALK,      0.000000000000000_REALK,     -1.403916076645857_REALK, &
      0.000000000000000_REALK,     -1.809984117972645_REALK,      0.000000000000000_REALK, &
     -0.593366205567602_REALK,      0.000000000000000_REALK,     -0.881308902770768_REALK, &
     -0.545509404109623_REALK,     -1.511219350170434_REALK,      0.000000000000000_REALK, &
     -0.111374780518644_REALK,      0.000000000000000_REALK,     -0.143287840403009_REALK, &
     -0.820116547715041_REALK,      0.000000000000000_REALK,     -0.485720973396332_REALK, &
      0.000000000000000_REALK,      1.019756494268658_REALK,      0.000000000000000_REALK, &
     -0.079732293253770_REALK,      0.000000000000000_REALK,     -0.284313298336532_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.469742346509439_REALK, &
      0.000000000000000_REALK,      0.826495737963705_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.368064279089553_REALK,      0.000000000000000_REALK, &
      0.443864644899396_REALK,      0.000000000000000_REALK,      1.626216408040554_REALK, &
      0.000000000000000_REALK,      1.747870735168849_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.276589938610871_REALK, &
      0.000000000000000_REALK,      0.391525757333226_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.227114168384735_REALK,      0.000000000000000_REALK, &
      0.268028347804754_REALK,      0.000000000000000_REALK,      0.803828332325339_REALK, &
      0.000000000000000_REALK,      0.766158353600966_REALK,      0.000000000000000_REALK, &
     -0.550541729519211_REALK,     -0.486640432478769_REALK,      0.000000000000000_REALK, &
     -0.422825905782475_REALK,      0.000000000000000_REALK,     -0.434407710680799_REALK, &
     -0.513841599721262_REALK,      0.000000000000000_REALK,     -0.459923098728781_REALK, &
      0.000000000000000_REALK,     -1.323759499213337_REALK,      0.000000000000000_REALK, &
     -0.878431305628380_REALK,      0.000000000000000_REALK,     -1.501895907313542_REALK, &
     -0.415195747683101_REALK,     -0.315676151141398_REALK,      0.000000000000000_REALK, &
     -0.213319899791887_REALK,      0.000000000000000_REALK,     -0.324438016346519_REALK, &
     -0.162648720045900_REALK,      0.000000000000000_REALK,     -0.306199483650508_REALK, &
      0.000000000000000_REALK,      0.053063848544532_REALK,      0.000000000000000_REALK, &
     -0.417102469372028_REALK,      0.000000000000000_REALK,     -1.044698983080099_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.362721169278667_REALK, &
      0.000000000000000_REALK,      0.445588658495659_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.452559058715105_REALK,      0.000000000000000_REALK, &
      0.571825597139378_REALK,      0.000000000000000_REALK,      1.494156493136724_REALK, &
      0.000000000000000_REALK,      1.525770989243240_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.560996705736200_REALK, &
      0.000000000000000_REALK,      0.667832823819174_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.838467268676392_REALK,      0.000000000000000_REALK, &
      0.910427634757854_REALK,      0.000000000000000_REALK,      2.468020922846989_REALK, &
      0.000000000000000_REALK,      2.124611396412773_REALK,      0.000000000000000_REALK, &
      1.305991771098568_REALK,     -5.751291075635871_REALK,      0.000000000000000_REALK, &
      0.926763105708371_REALK,      0.000000000000000_REALK,      0.287431277550327_REALK, &
     -3.832372643320720_REALK,      0.000000000000000_REALK,     -1.575151318254382_REALK, &
      0.000000000000000_REALK,      2.536632308859708_REALK,      0.000000000000000_REALK, &
      0.507822690625969_REALK,      0.000000000000000_REALK,      0.471371497853397_REALK, &
      0.746148404606509_REALK,     -2.375800378721739_REALK,      0.000000000000000_REALK, &
      0.438426978579635_REALK,      0.000000000000000_REALK,      0.173583915121854_REALK, &
     -1.642582914031922_REALK,      0.000000000000000_REALK,     -0.654019896441472_REALK, &
      0.000000000000000_REALK,      0.263124251436628_REALK,      0.000000000000000_REALK, &
      0.211078618528645_REALK,      0.000000000000000_REALK,      0.247896323260120_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.218691224596733_REALK, &
      0.000000000000000_REALK,      0.776769321037017_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.113314778924388_REALK,      0.000000000000000_REALK, &
      0.177935481305177_REALK,      0.000000000000000_REALK,      1.054993266034737_REALK, &
      0.000000000000000_REALK,      1.291525671875768_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.117449075051181_REALK, &
      0.000000000000000_REALK,      0.375467892744283_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.012783396363314_REALK,      0.000000000000000_REALK, &
      0.096751304533224_REALK,      0.000000000000000_REALK,      0.282711879127144_REALK, &
      0.000000000000000_REALK,      0.542947899000549_REALK,      0.000000000000000_REALK, &
     -0.398686181138648_REALK,     -0.453717609944337_REALK,      0.000000000000000_REALK, &
     -0.214477209707537_REALK,      0.000000000000000_REALK,     -0.261188072124685_REALK, &
     -0.337736782698887_REALK,      0.000000000000000_REALK,     -0.367974355429585_REALK, &
      0.000000000000000_REALK,     -0.465660920274376_REALK,      0.000000000000000_REALK, &
     -0.346735723442262_REALK,      0.000000000000000_REALK,     -0.700138766721171_REALK, &
     -0.316847888006628_REALK,     -0.342039328040706_REALK,      0.000000000000000_REALK, &
     -0.192518566028738_REALK,      0.000000000000000_REALK,     -0.225104253188824_REALK, &
     -0.312130800831953_REALK,      0.000000000000000_REALK,     -0.285072538133847_REALK, &
      0.000000000000000_REALK,     -0.581355521046788_REALK,      0.000000000000000_REALK, &
     -0.271001569770720_REALK,      0.000000000000000_REALK,     -0.528300296347856_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.259110914685812_REALK, &
      0.000000000000000_REALK,      0.275791121636047_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.201676140519199_REALK,      0.000000000000000_REALK, &
      0.347767041472470_REALK,      0.000000000000000_REALK,      0.489572350188332_REALK, &
      0.000000000000000_REALK,      0.732022508606024_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.299741264932847_REALK, &
      0.000000000000000_REALK,      0.258186714009592_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.151921702978276_REALK,      0.000000000000000_REALK, &
      0.417661713250237_REALK,      0.000000000000000_REALK,      0.169583773034616_REALK, &
      0.000000000000000_REALK,      0.603979701594145_REALK,      0.000000000000000_REALK, &
     -0.330921029060768_REALK,     -0.277963959440074_REALK,      0.000000000000000_REALK, &
     -0.284442860857514_REALK,      0.000000000000000_REALK,     -0.357265268887110_REALK, &
     -0.368971398129110_REALK,      0.000000000000000_REALK,     -0.371611567725848_REALK, &
      0.000000000000000_REALK,     -0.953014591721395_REALK,      0.000000000000000_REALK, &
     -0.737087214522669_REALK,      0.000000000000000_REALK,     -1.299995154861864_REALK, &
     -0.667481985943833_REALK,     -0.651448037390309_REALK,      0.000000000000000_REALK, &
     -0.763309100643892_REALK,      0.000000000000000_REALK,     -0.822520846743815_REALK, &
     -1.088305382383584_REALK,      0.000000000000000_REALK,     -0.924129616339119_REALK, &
      0.000000000000000_REALK,     -2.584016724894752_REALK,      0.000000000000000_REALK, &
     -1.756606490517661_REALK,      0.000000000000000_REALK,     -2.653623158160281_REALK, &
      7.590670881694030_REALK,     -9.304979415657515_REALK,      0.000000000000000_REALK, &
      3.536976616716817_REALK,      0.000000000000000_REALK,      1.343668862447500_REALK, &
     -5.477960221591689_REALK,      0.000000000000000_REALK,     -2.109987350615613_REALK, &
      0.000000000000000_REALK,      6.479369088291635_REALK,      0.000000000000000_REALK, &
      1.473785283149293_REALK,      0.000000000000000_REALK,      1.669650217303788_REALK, &
      7.733248095670834_REALK,     -6.536326768923677_REALK,      0.000000000000000_REALK, &
      2.808980686160079_REALK,      0.000000000000000_REALK,      1.113311694012553_REALK, &
     -2.687846227738509_REALK,      0.000000000000000_REALK,     -1.209482196803939_REALK, &
      0.000000000000000_REALK,      4.058742801906890_REALK,      0.000000000000000_REALK, &
      0.824291515136768_REALK,      0.000000000000000_REALK,      0.977810440011648_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.211476240502597_REALK, &
      0.000000000000000_REALK,      0.957373603738904_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.149098138632259_REALK,      0.000000000000000_REALK, &
     -0.139521487866824_REALK,      0.000000000000000_REALK,      0.965143114998092_REALK, &
      0.000000000000000_REALK,      1.196646593539941_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.290381330110065_REALK, &
      0.000000000000000_REALK,      0.754071618540992_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.119221865213120_REALK,      0.000000000000000_REALK, &
     -0.155666197601553_REALK,      0.000000000000000_REALK,      0.568545698123312_REALK, &
      0.000000000000000_REALK,      0.665339124666953_REALK,      0.000000000000000_REALK, &
     -0.220156086541487_REALK,     -0.551267944286317_REALK,      0.000000000000000_REALK, &
     -0.070902139598994_REALK,      0.000000000000000_REALK,     -0.115063440946952_REALK, &
     -0.291734037319883_REALK,      0.000000000000000_REALK,     -0.366385366195310_REALK, &
      0.000000000000000_REALK,     -0.077603993904201_REALK,      0.000000000000000_REALK, &
     -0.087044572043115_REALK,      0.000000000000000_REALK,     -0.230742159849389_REALK, &
     -0.270944702070598_REALK,     -0.591107755720175_REALK,      0.000000000000000_REALK, &
      0.005669205921104_REALK,      0.000000000000000_REALK,     -0.116381883787995_REALK, &
     -0.124730256924877_REALK,      0.000000000000000_REALK,     -0.320691452068051_REALK, &
      0.000000000000000_REALK,      0.253070465420357_REALK,      0.000000000000000_REALK, &
     -0.003361535234869_REALK,      0.000000000000000_REALK,     -0.167846392849547_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.201929154881281_REALK, &
      0.000000000000000_REALK,      0.243520029025333_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.107083909961818_REALK,      0.000000000000000_REALK, &
      0.219817026579277_REALK,      0.000000000000000_REALK,      0.264339935805239_REALK, &
      0.000000000000000_REALK,      0.481563324261941_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.410046702015042_REALK, &
      0.000000000000000_REALK,      0.375404256290702_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.190704036957615_REALK,      0.000000000000000_REALK, &
      0.360244216643633_REALK,      0.000000000000000_REALK,      0.354128942147378_REALK, &
      0.000000000000000_REALK,      0.520137893015116_REALK,      0.000000000000000_REALK, &
     -0.284582371323213_REALK,     -0.219042931080960_REALK,      0.000000000000000_REALK, &
     -0.139621217589160_REALK,      0.000000000000000_REALK,     -0.242294774937730_REALK, &
     -0.157176592188089_REALK,      0.000000000000000_REALK,     -0.237057391577043_REALK, &
      0.000000000000000_REALK,     -0.236426320413633_REALK,      0.000000000000000_REALK, &
     -0.268778086129091_REALK,      0.000000000000000_REALK,     -0.650558683572143_REALK, &
     -0.828399263294701_REALK,     -0.463452536705762_REALK,      0.000000000000000_REALK, &
     -0.183348239837839_REALK,      0.000000000000000_REALK,     -0.575559670579194_REALK, &
     -0.068889544239189_REALK,      0.000000000000000_REALK,     -0.408789517140675_REALK, &
      0.000000000000000_REALK,      0.169483274447479_REALK,      0.000000000000000_REALK, &
     -0.264031383267007_REALK,      0.000000000000000_REALK,     -1.095052718189422_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.301002232025281_REALK, &
      0.000000000000000_REALK,      0.267390097234190_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.257710284893965_REALK,      0.000000000000000_REALK, &
      0.450109225447823_REALK,      0.000000000000000_REALK,      0.501476006051275_REALK, &
      0.000000000000000_REALK,      0.704516154741009_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.723212565543979_REALK, &
      0.000000000000000_REALK,      1.395556641599757_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.387302485301793_REALK,      0.000000000000000_REALK, &
      2.063736248659167_REALK,      0.000000000000000_REALK,      2.170241677820895_REALK, &
      0.000000000000000_REALK,      2.557515155693467_REALK,      0.000000000000000_REALK/
  ! results of test 5, ket-major order, NEF 006
  data REF_CONTR_INTS(10081:11340)                                                         &
     /0.000000000000000_REALK,      0.000000000000000_REALK,     -1.849241517347954_REALK, &
      0.000000000000000_REALK,     -1.667142388114481_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.084146441653161_REALK,      0.000000000000000_REALK, &
     -1.195798404289585_REALK,      0.000000000000000_REALK,     -3.900795324311171_REALK, &
      0.000000000000000_REALK,     -1.611412494513607_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.147620191300331_REALK, &
      0.000000000000000_REALK,     -1.235225241749726_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.722681493461892_REALK,      0.000000000000000_REALK, &
     -0.747774108041095_REALK,      0.000000000000000_REALK,     -3.315156172427407_REALK, &
      0.000000000000000_REALK,     -1.108967823428217_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.421593374298786_REALK, &
      0.000000000000000_REALK,     -0.973725389204929_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.975209095184021_REALK,      0.000000000000000_REALK, &
     -0.809277956773739_REALK,      0.000000000000000_REALK,     -1.391011819409794_REALK, &
      0.000000000000000_REALK,     -0.794236373095826_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.728029750784371_REALK, &
      0.000000000000000_REALK,     -0.513313575998535_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.474674662042660_REALK,      0.000000000000000_REALK, &
     -0.396138786999605_REALK,      0.000000000000000_REALK,     -0.547344602414206_REALK, &
      0.000000000000000_REALK,     -0.378149619757266_REALK,      0.000000000000000_REALK, &
      1.430837463453102_REALK,      1.118113710930520_REALK,      0.000000000000000_REALK, &
      1.182849098887179_REALK,      0.000000000000000_REALK,      0.660661709580329_REALK, &
      1.554367713876994_REALK,      0.000000000000000_REALK,      0.628146243142802_REALK, &
      0.000000000000000_REALK,      2.832824344371840_REALK,      0.000000000000000_REALK, &
      0.939814308947235_REALK,      0.000000000000000_REALK,      0.885370831089801_REALK, &
      1.288523058917382_REALK,      1.158232839057435_REALK,      0.000000000000000_REALK, &
      1.339898642855034_REALK,      0.000000000000000_REALK,      0.567727365543545_REALK, &
      1.896626918441561_REALK,      0.000000000000000_REALK,      0.622430714725189_REALK, &
      0.000000000000000_REALK,      3.488046776888992_REALK,      0.000000000000000_REALK, &
      0.962441616137296_REALK,      0.000000000000000_REALK,      0.684478480915702_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.319263310268053_REALK, &
      0.000000000000000_REALK,     -0.706374856799853_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.599948893447051_REALK,      0.000000000000000_REALK, &
     -0.655431092358778_REALK,      0.000000000000000_REALK,     -0.698199032500975_REALK, &
      0.000000000000000_REALK,     -0.482831286618171_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.668709174831902_REALK, &
      0.000000000000000_REALK,     -0.392041092272781_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.338110664651797_REALK,      0.000000000000000_REALK, &
     -0.321820833086897_REALK,      0.000000000000000_REALK,     -0.394714624879658_REALK, &
      0.000000000000000_REALK,     -0.239752472180441_REALK,      0.000000000000000_REALK, &
      1.217585510026126_REALK,      0.724206176576625_REALK,      0.000000000000000_REALK, &
      0.608303494877145_REALK,      0.000000000000000_REALK,      0.494946522502432_REALK, &
      0.626136870971337_REALK,      0.000000000000000_REALK,      0.354406832317734_REALK, &
      0.000000000000000_REALK,      0.863643487422387_REALK,      0.000000000000000_REALK, &
      0.406542812074074_REALK,      0.000000000000000_REALK,      0.556484608831104_REALK, &
      0.788795795633887_REALK,      0.505741992302636_REALK,      0.000000000000000_REALK, &
      0.396995593186786_REALK,      0.000000000000000_REALK,      0.332570225416120_REALK, &
      0.336808182164877_REALK,      0.000000000000000_REALK,      0.242405654365148_REALK, &
      0.000000000000000_REALK,      0.289869223425215_REALK,      0.000000000000000_REALK, &
      0.240732490434762_REALK,      0.000000000000000_REALK,      0.336314783540005_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.505416689292625_REALK, &
      0.000000000000000_REALK,     -0.407927337817612_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.447806599061727_REALK,      0.000000000000000_REALK, &
     -0.409593779355404_REALK,      0.000000000000000_REALK,     -0.667867490943086_REALK, &
      0.000000000000000_REALK,     -0.446183563343733_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.581312685304354_REALK, &
      0.000000000000000_REALK,     -0.557111143670293_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.670892724309850_REALK,      0.000000000000000_REALK, &
     -0.466311482665402_REALK,      0.000000000000000_REALK,     -1.023929373277094_REALK, &
      0.000000000000000_REALK,     -0.554721511995761_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.420898787124032_REALK, &
      0.000000000000000_REALK,     -0.586505397647994_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.426212973200462_REALK,      0.000000000000000_REALK, &
     -0.608275866454483_REALK,      0.000000000000000_REALK,     -0.399077229023465_REALK, &
      0.000000000000000_REALK,     -0.333170329546976_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.824013853498413_REALK, &
      0.000000000000000_REALK,     -0.338008658197063_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.214492869623227_REALK,      0.000000000000000_REALK, &
     -0.316564162384731_REALK,      0.000000000000000_REALK,     -0.156871680353688_REALK, &
      0.000000000000000_REALK,     -0.163890709540855_REALK,      0.000000000000000_REALK, &
      1.290562935632584_REALK,      0.599843471439668_REALK,      0.000000000000000_REALK, &
      0.424876328982294_REALK,      0.000000000000000_REALK,      0.456142127651216_REALK, &
      0.367291053306200_REALK,      0.000000000000000_REALK,      0.252395598816481_REALK, &
      0.000000000000000_REALK,      0.425912881277232_REALK,      0.000000000000000_REALK, &
      0.236102831593015_REALK,      0.000000000000000_REALK,      0.426064326189858_REALK, &
      1.060951107173218_REALK,      0.515231481434135_REALK,      0.000000000000000_REALK, &
      0.364476433523183_REALK,      0.000000000000000_REALK,      0.338513507886196_REALK, &
      0.329507882087306_REALK,      0.000000000000000_REALK,      0.194721027455428_REALK, &
      0.000000000000000_REALK,      0.403880985357224_REALK,      0.000000000000000_REALK, &
      0.172514429429338_REALK,      0.000000000000000_REALK,      0.269277782717746_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.430271792732361_REALK, &
      0.000000000000000_REALK,     -0.260238034027653_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.223513039693184_REALK,      0.000000000000000_REALK, &
     -0.299788365375867_REALK,      0.000000000000000_REALK,     -0.251738260097010_REALK, &
      0.000000000000000_REALK,     -0.236932678520289_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.447208346283056_REALK, &
      0.000000000000000_REALK,     -0.265255235197768_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.198351811846105_REALK,      0.000000000000000_REALK, &
     -0.280356898015023_REALK,      0.000000000000000_REALK,     -0.167460772400510_REALK, &
      0.000000000000000_REALK,     -0.208200182926571_REALK,      0.000000000000000_REALK, &
      0.532192029240594_REALK,      0.373130268492075_REALK,      0.000000000000000_REALK, &
      0.344521042911557_REALK,      0.000000000000000_REALK,      0.308777622305663_REALK, &
      0.389972226338775_REALK,      0.000000000000000_REALK,      0.256433893083029_REALK, &
      0.000000000000000_REALK,      0.567328305294531_REALK,      0.000000000000000_REALK, &
      0.307091579047144_REALK,      0.000000000000000_REALK,      0.388874731091015_REALK, &
      1.044862184716384_REALK,      0.811910066226904_REALK,      0.000000000000000_REALK, &
      0.794753650855329_REALK,      0.000000000000000_REALK,      0.541218868702073_REALK, &
      0.936472229048969_REALK,      0.000000000000000_REALK,      0.499756016012014_REALK, &
      0.000000000000000_REALK,      1.350443481876458_REALK,      0.000000000000000_REALK, &
      0.608263098833307_REALK,      0.000000000000000_REALK,      0.583617246333368_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.783451363332341_REALK, &
      0.000000000000000_REALK,     -0.555418033738183_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.353321100124273_REALK,      0.000000000000000_REALK, &
     -0.646979922131901_REALK,      0.000000000000000_REALK,     -0.265460432605356_REALK, &
      0.000000000000000_REALK,     -0.258640470670884_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.127181600712326_REALK, &
      0.000000000000000_REALK,     -0.370665895917471_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.222199761392097_REALK,      0.000000000000000_REALK, &
     -0.384705132061556_REALK,      0.000000000000000_REALK,     -0.165680779831523_REALK, &
      0.000000000000000_REALK,     -0.148608864468541_REALK,      0.000000000000000_REALK, &
      1.638985585554639_REALK,      0.585762935091831_REALK,      0.000000000000000_REALK, &
      0.352248582790113_REALK,      0.000000000000000_REALK,      0.496825719684459_REALK, &
      0.249427901012601_REALK,      0.000000000000000_REALK,      0.208680671604712_REALK, &
      0.000000000000000_REALK,      0.236665608627321_REALK,      0.000000000000000_REALK, &
      0.160905166741620_REALK,      0.000000000000000_REALK,      0.380454555070243_REALK, &
      1.252289206973810_REALK,      0.480463100720071_REALK,      0.000000000000000_REALK, &
      0.263062297015945_REALK,      0.000000000000000_REALK,      0.391154840002545_REALK, &
      0.147562749632917_REALK,      0.000000000000000_REALK,      0.163269162226754_REALK, &
      0.000000000000000_REALK,      0.070037409684724_REALK,      0.000000000000000_REALK, &
      0.104705232293845_REALK,      0.000000000000000_REALK,      0.259425254157871_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.466136333901886_REALK, &
      0.000000000000000_REALK,     -0.217278165335029_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.154979409004259_REALK,      0.000000000000000_REALK, &
     -0.274793135261176_REALK,      0.000000000000000_REALK,     -0.141902888541757_REALK, &
      0.000000000000000_REALK,     -0.162206969545945_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.492068080756529_REALK, &
      0.000000000000000_REALK,     -0.251949779698343_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.182580136016814_REALK,      0.000000000000000_REALK, &
     -0.279155854581374_REALK,      0.000000000000000_REALK,     -0.170238203235799_REALK, &
      0.000000000000000_REALK,     -0.165217201886431_REALK,      0.000000000000000_REALK, &
      0.530410721611834_REALK,      0.277703129299087_REALK,      0.000000000000000_REALK, &
      0.199240153868298_REALK,      0.000000000000000_REALK,      0.263760571425581_REALK, &
      0.172350904465571_REALK,      0.000000000000000_REALK,      0.161552829590726_REALK, &
      0.000000000000000_REALK,      0.186461843622566_REALK,      0.000000000000000_REALK, &
      0.146333304707935_REALK,      0.000000000000000_REALK,      0.272870576518750_REALK, &
      0.696982708566848_REALK,      0.393858796573912_REALK,      0.000000000000000_REALK, &
      0.258390546331177_REALK,      0.000000000000000_REALK,      0.368288340442897_REALK, &
      0.171067385880324_REALK,      0.000000000000000_REALK,      0.223078670121904_REALK, &
      0.000000000000000_REALK,      0.091878156512798_REALK,      0.000000000000000_REALK, &
      0.168714378788276_REALK,      0.000000000000000_REALK,      0.336757568859492_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.337448080615594_REALK, &
      0.000000000000000_REALK,     -0.236600549746442_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.220195010947640_REALK,      0.000000000000000_REALK, &
     -0.272877701258628_REALK,      0.000000000000000_REALK,     -0.261935366990058_REALK, &
      0.000000000000000_REALK,     -0.239512616368778_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.821165254718180_REALK, &
      0.000000000000000_REALK,     -0.686581567052233_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.695481517854503_REALK,      0.000000000000000_REALK, &
     -0.656597276907199_REALK,      0.000000000000000_REALK,     -0.840751996781423_REALK, &
      0.000000000000000_REALK,     -0.623518580073091_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.759208036148775_REALK, &
      0.000000000000000_REALK,     -0.614614734368650_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.347729931090281_REALK,      0.000000000000000_REALK, &
     -0.809885848738127_REALK,      0.000000000000000_REALK,     -0.200546603551979_REALK, &
      0.000000000000000_REALK,     -0.226328408917684_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.106475313381746_REALK, &
      0.000000000000000_REALK,     -0.631979657183981_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.274046351778948_REALK,      0.000000000000000_REALK, &
     -0.707814520488574_REALK,      0.000000000000000_REALK,     -0.106006430430374_REALK, &
      0.000000000000000_REALK,     -0.171708156201073_REALK,      0.000000000000000_REALK, &
      2.695181541875876_REALK,      0.708518133884047_REALK,      0.000000000000000_REALK, &
      0.364028663847268_REALK,      0.000000000000000_REALK,      0.662242609988588_REALK, &
      0.207701291392405_REALK,      0.000000000000000_REALK,      0.203821979771606_REALK, &
      0.000000000000000_REALK,      0.165814142616076_REALK,      0.000000000000000_REALK, &
      0.131748079153483_REALK,      0.000000000000000_REALK,      0.400751865766690_REALK, &
      4.292099168034198_REALK,      1.089577844420931_REALK,      0.000000000000000_REALK, &
      0.498661219211463_REALK,      0.000000000000000_REALK,      0.844766208170877_REALK, &
      0.284103543580308_REALK,      0.000000000000000_REALK,      0.244143372035132_REALK, &
      0.000000000000000_REALK,      0.242253608330984_REALK,      0.000000000000000_REALK, &
      0.132392947347485_REALK,      0.000000000000000_REALK,      0.376340096062046_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.649162867868619_REALK, &
      0.000000000000000_REALK,     -0.225076065090901_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.132028182343319_REALK,      0.000000000000000_REALK, &
     -0.308602167513810_REALK,      0.000000000000000_REALK,     -0.095065027032538_REALK, &
      0.000000000000000_REALK,     -0.132772555661791_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.184723276833809_REALK, &
      0.000000000000000_REALK,     -0.375408318788127_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.172945064918559_REALK,      0.000000000000000_REALK, &
     -0.439581815867169_REALK,      0.000000000000000_REALK,     -0.082586762340528_REALK, &
      0.000000000000000_REALK,     -0.164888703231810_REALK,      0.000000000000000_REALK, &
      0.755963597802671_REALK,      0.297087473533316_REALK,      0.000000000000000_REALK, &
      0.173188142898810_REALK,      0.000000000000000_REALK,      0.303301954902458_REALK, &
      0.122066143308266_REALK,      0.000000000000000_REALK,      0.139006626365383_REALK, &
      0.000000000000000_REALK,      0.109321521094696_REALK,      0.000000000000000_REALK, &
      0.100451799050720_REALK,      0.000000000000000_REALK,      0.247736158220385_REALK, &
      2.099393459598595_REALK,      0.821799515349633_REALK,      0.000000000000000_REALK, &
      0.455976751008982_REALK,      0.000000000000000_REALK,      0.676262955560877_REALK, &
      0.321478227872189_REALK,      0.000000000000000_REALK,      0.300182054357393_REALK, &
      0.000000000000000_REALK,      0.298140565055606_REALK,      0.000000000000000_REALK, &
      0.195461701578938_REALK,      0.000000000000000_REALK,      0.409434000640164_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.368342391029203_REALK, &
      0.000000000000000_REALK,     -0.186124178351440_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.130193525707297_REALK,      0.000000000000000_REALK, &
     -0.239512616368778_REALK,      0.000000000000000_REALK,     -0.113658030185786_REALK, &
      0.000000000000000_REALK,     -0.148993076943052_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.223881532171206_REALK, &
      0.000000000000000_REALK,     -0.556525989472130_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.303452031662451_REALK,      0.000000000000000_REALK, &
     -0.623518580073090_REALK,      0.000000000000000_REALK,     -0.170128390930401_REALK, &
      0.000000000000000_REALK,     -0.334090821016779_REALK,      0.000000000000000_REALK, &
      0.585575862140633_REALK,      0.346338706888072_REALK,      0.000000000000000_REALK, &
      0.265235367866381_REALK,      0.000000000000000_REALK,      0.322636940760057_REALK, &
      0.245666622684139_REALK,      0.000000000000000_REALK,      0.221583828120885_REALK, &
      0.000000000000000_REALK,      0.279369203974659_REALK,      0.000000000000000_REALK, &
      0.208025736902232_REALK,      0.000000000000000_REALK,      0.328115714819620_REALK, &
      4.008141225306219_REALK,      2.515364978614462_REALK,      0.000000000000000_REALK, &
      1.922684534467515_REALK,      0.000000000000000_REALK,      1.772167899508672_REALK, &
      1.723747591367711_REALK,      0.000000000000000_REALK,      1.257031297843313_REALK, &
      0.000000000000000_REALK,      1.815518238986838_REALK,      0.000000000000000_REALK, &
      1.121985656722485_REALK,      0.000000000000000_REALK,      1.338197192410408_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.495714455812483_REALK, &
      0.000000000000000_REALK,     -4.630996925494513_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.976514001488834_REALK,      0.000000000000000_REALK, &
     -3.265835637633863_REALK,      0.000000000000000_REALK,    -20.523343098286784_REALK, &
      0.000000000000000_REALK,    -16.048928987922416_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.862620572016870_REALK, &
      0.000000000000000_REALK,     -2.124110626583982_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.091669547966280_REALK,      0.000000000000000_REALK, &
     -1.386510865907750_REALK,      0.000000000000000_REALK,    -12.154631942052342_REALK, &
      0.000000000000000_REALK,     -8.258678355687259_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.452212119702569_REALK, &
      0.000000000000000_REALK,     -2.232064426330490_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.686332320982523_REALK,      0.000000000000000_REALK, &
     -4.040082932390392_REALK,      0.000000000000000_REALK,     -6.767758928665329_REALK, &
      0.000000000000000_REALK,     -6.866140636731161_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.151745008995624_REALK, &
      0.000000000000000_REALK,     -0.786325199943065_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.592493236092136_REALK,      0.000000000000000_REALK, &
     -1.511615114805730_REALK,      0.000000000000000_REALK,     -1.932635365922620_REALK, &
      0.000000000000000_REALK,     -2.567097342100557_REALK,      0.000000000000000_REALK, &
      3.172203163991709_REALK,      0.936356150076487_REALK,      0.000000000000000_REALK, &
      2.078638497215486_REALK,      0.000000000000000_REALK,      3.397516826653180_REALK, &
      1.453500467473530_REALK,      0.000000000000000_REALK,      1.119232914570415_REALK, &
      0.000000000000000_REALK,     10.248521972383706_REALK,      0.000000000000000_REALK, &
      6.426863184011110_REALK,      0.000000000000000_REALK,     17.461654923703922_REALK, &
      1.443432346213872_REALK,      0.633790939871679_REALK,      0.000000000000000_REALK, &
      1.349069157842145_REALK,      0.000000000000000_REALK,      1.683029053681002_REALK, &
      1.297327533656893_REALK,      0.000000000000000_REALK,      0.865075302651803_REALK, &
      0.000000000000000_REALK,      8.482978706374110_REALK,      0.000000000000000_REALK, &
      4.497263591157073_REALK,      0.000000000000000_REALK,      9.279725977401521_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.222727874467433_REALK, &
      0.000000000000000_REALK,     -1.131474305616680_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.462049879380715_REALK,      0.000000000000000_REALK, &
     -4.478083530520524_REALK,      0.000000000000000_REALK,     -2.498567987044497_REALK, &
      0.000000000000000_REALK,     -2.951769803384722_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.438182664352078_REALK, &
      0.000000000000000_REALK,     -0.414131779174481_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.529114098708011_REALK,      0.000000000000000_REALK, &
     -1.680106650891270_REALK,      0.000000000000000_REALK,     -0.914020828277216_REALK, &
      0.000000000000000_REALK,     -1.088675346683089_REALK,      0.000000000000000_REALK, &
      2.885750574281431_REALK,      0.684644433957625_REALK,      0.000000000000000_REALK, &
      1.126881728302889_REALK,      0.000000000000000_REALK,      2.689936003938763_REALK, &
      0.716171954622777_REALK,      0.000000000000000_REALK,      0.732850985497834_REALK, &
      0.000000000000000_REALK,      3.296107202456987_REALK,      0.000000000000000_REALK, &
      2.931994879275411_REALK,      0.000000000000000_REALK,     11.672595005364183_REALK, &
      1.157373520571273_REALK,      0.349726933100085_REALK,      0.000000000000000_REALK, &
      0.465493275090194_REALK,      0.000000000000000_REALK,      1.197079865061827_REALK, &
      0.290066126601865_REALK,      0.000000000000000_REALK,      0.417187918038478_REALK, &
      0.000000000000000_REALK,      0.806977587296170_REALK,      0.000000000000000_REALK, &
      1.222003897287279_REALK,      0.000000000000000_REALK,      5.251033329564494_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.075976296556161_REALK, &
      0.000000000000000_REALK,     -0.773810523885600_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.732899034984732_REALK,      0.000000000000000_REALK, &
     -1.925405379192116_REALK,      0.000000000000000_REALK,     -2.611682252456343_REALK, &
      0.000000000000000_REALK,     -3.338462564050839_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.793612128917368_REALK, &
      0.000000000000000_REALK,     -0.720539556858205_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.810525596396156_REALK,      0.000000000000000_REALK, &
     -1.612721249712865_REALK,      0.000000000000000_REALK,     -2.887723303013339_REALK, &
      0.000000000000000_REALK,     -3.182795721537422_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.279511719689732_REALK, &
      0.000000000000000_REALK,     -0.413297968283790_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.403916076645857_REALK,      0.000000000000000_REALK, &
     -4.990151559705017_REALK,      0.000000000000000_REALK,     -0.593366205567601_REALK, &
      0.000000000000000_REALK,     -0.881308902770772_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.069569127182812_REALK, &
      0.000000000000000_REALK,     -0.143287840403009_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.485720973396331_REALK,      0.000000000000000_REALK, &
     -1.998725358329864_REALK,      0.000000000000000_REALK,     -0.079732293253772_REALK, &
      0.000000000000000_REALK,     -0.284313298336532_REALK,      0.000000000000000_REALK, &
      3.202540782497494_REALK,      0.469742346509439_REALK,      0.000000000000000_REALK, &
      0.826495737963705_REALK,      0.000000000000000_REALK,      2.540049559597614_REALK, &
      0.368064279089553_REALK,      0.000000000000000_REALK,      0.443864644899396_REALK, &
      0.000000000000000_REALK,      1.626216408040550_REALK,      0.000000000000000_REALK, &
      1.747870735168848_REALK,      0.000000000000000_REALK,      8.940552704002874_REALK, &
      1.591925446178663_REALK,      0.276589938610871_REALK,      0.000000000000000_REALK, &
      0.391525757333226_REALK,      0.000000000000000_REALK,      1.247447959397088_REALK, &
      0.227114168384736_REALK,      0.000000000000000_REALK,      0.268028347804755_REALK, &
      0.000000000000000_REALK,      0.803828332325339_REALK,      0.000000000000000_REALK, &
      0.766158353600965_REALK,      0.000000000000000_REALK,      4.064434577973515_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.151630934340744_REALK, &
      0.000000000000000_REALK,     -0.434407710680799_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.459923098728780_REALK,      0.000000000000000_REALK, &
     -1.814021777051720_REALK,      0.000000000000000_REALK,     -0.878431305628380_REALK, &
      0.000000000000000_REALK,     -1.501895907313544_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.833040135484239_REALK, &
      0.000000000000000_REALK,     -0.324438016346519_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.306199483650508_REALK,      0.000000000000000_REALK, &
     -1.347507778259412_REALK,      0.000000000000000_REALK,     -0.417102469372029_REALK, &
      0.000000000000000_REALK,     -1.044698983080100_REALK,      0.000000000000000_REALK, &
      0.879837637067377_REALK,      0.362721169278668_REALK,      0.000000000000000_REALK, &
      0.445588658495659_REALK,      0.000000000000000_REALK,      1.155960920487693_REALK, &
      0.452559058715105_REALK,      0.000000000000000_REALK,      0.571825597139378_REALK, &
      0.000000000000000_REALK,      1.494156493136724_REALK,      0.000000000000000_REALK, &
      1.525770989243236_REALK,      0.000000000000000_REALK,      5.567989402420978_REALK, &
      1.006812403479689_REALK,      0.560996705736200_REALK,      0.000000000000000_REALK, &
      0.667832823819174_REALK,      0.000000000000000_REALK,      1.303444370849477_REALK, &
      0.838467268676392_REALK,      0.000000000000000_REALK,      0.910427634757855_REALK, &
      0.000000000000000_REALK,      2.468020922846988_REALK,      0.000000000000000_REALK, &
      2.124611396412776_REALK,      0.000000000000000_REALK,      5.828476912723731_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -7.133345741762696_REALK, &
      0.000000000000000_REALK,      0.287431277550325_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.575151318254384_REALK,      0.000000000000000_REALK, &
     -5.847909141043167_REALK,      0.000000000000000_REALK,      0.507822690625967_REALK, &
      0.000000000000000_REALK,      0.471371497853396_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.244954444891047_REALK, &
      0.000000000000000_REALK,      0.173583915121854_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.654019896441471_REALK,      0.000000000000000_REALK, &
     -2.680861611169000_REALK,      0.000000000000000_REALK,      0.211078618528642_REALK, &
      0.000000000000000_REALK,      0.247896323260121_REALK,      0.000000000000000_REALK, &
      4.215780890895164_REALK,      0.218691224596733_REALK,      0.000000000000000_REALK, &
      0.776769321037018_REALK,      0.000000000000000_REALK,      2.792338949649657_REALK, &
      0.113314778924388_REALK,      0.000000000000000_REALK,      0.177935481305176_REALK, &
      0.000000000000000_REALK,      1.054993266034734_REALK,      0.000000000000000_REALK, &
      1.291525671875768_REALK,      0.000000000000000_REALK,      7.690523624894010_REALK, &
      2.273037614703807_REALK,      0.117449075051181_REALK,      0.000000000000000_REALK, &
      0.375467892744283_REALK,      0.000000000000000_REALK,      1.588613431479360_REALK, &
      0.012783396363314_REALK,      0.000000000000000_REALK,      0.096751304533224_REALK, &
      0.000000000000000_REALK,      0.282711879127145_REALK,      0.000000000000000_REALK, &
      0.542947899000548_REALK,      0.000000000000000_REALK,      3.795115782359112_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.403637434733765_REALK, &
      0.000000000000000_REALK,     -0.261188072124684_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.367974355429585_REALK,      0.000000000000000_REALK, &
     -1.896143978776190_REALK,      0.000000000000000_REALK,     -0.346735723442262_REALK, &
      0.000000000000000_REALK,     -0.700138766721172_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.095002195263224_REALK, &
      0.000000000000000_REALK,     -0.225104253188825_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.285072538133847_REALK,      0.000000000000000_REALK, &
     -1.519337774161214_REALK,      0.000000000000000_REALK,     -0.271001569770720_REALK, &
      0.000000000000000_REALK,     -0.528300296347856_REALK,      0.000000000000000_REALK, &
      0.995839513339006_REALK,      0.259110914685812_REALK,      0.000000000000000_REALK, &
      0.275791121636047_REALK,      0.000000000000000_REALK,      1.084031079166124_REALK, &
      0.201676140519199_REALK,      0.000000000000000_REALK,      0.347767041472471_REALK, &
      0.000000000000000_REALK,      0.489572350188332_REALK,      0.000000000000000_REALK, &
      0.732022508606023_REALK,      0.000000000000000_REALK,      4.035547599635055_REALK, &
      0.968297008474553_REALK,      0.299741264932847_REALK,      0.000000000000000_REALK, &
      0.258186714009592_REALK,      0.000000000000000_REALK,      1.154163119708366_REALK, &
      0.151921702978276_REALK,      0.000000000000000_REALK,      0.417661713250238_REALK, &
      0.000000000000000_REALK,      0.169583773034615_REALK,      0.000000000000000_REALK, &
      0.603979701594144_REALK,      0.000000000000000_REALK,      3.769884643312750_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.705500144786257_REALK, &
      0.000000000000000_REALK,     -0.357265268887111_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.371611567725848_REALK,      0.000000000000000_REALK, &
     -1.322963393661249_REALK,      0.000000000000000_REALK,     -0.737087214522669_REALK, &
      0.000000000000000_REALK,     -1.299995154861866_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.249479770581920_REALK, &
      0.000000000000000_REALK,     -0.822520846743815_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.924129616339118_REALK,      0.000000000000000_REALK, &
     -2.467602995531111_REALK,      0.000000000000000_REALK,     -1.756606490517662_REALK, &
      0.000000000000000_REALK,     -2.653623158160285_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -11.003783256955428_REALK, &
      0.000000000000000_REALK,      1.343668862447501_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.109987350615614_REALK,      0.000000000000000_REALK, &
     -7.460711045038033_REALK,      0.000000000000000_REALK,      1.473785283149292_REALK, &
      0.000000000000000_REALK,      1.669650217303787_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.486084606839217_REALK, &
      0.000000000000000_REALK,      1.113311694012557_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.209482196803936_REALK,      0.000000000000000_REALK, &
     -4.679066894327861_REALK,      0.000000000000000_REALK,      0.824291515136764_REALK, &
      0.000000000000000_REALK,      0.977810440011648_REALK,      0.000000000000000_REALK, &
      6.805119683994287_REALK,     -0.211476240502596_REALK,      0.000000000000000_REALK, &
      0.957373603738905_REALK,      0.000000000000000_REALK,      3.607543466307155_REALK, &
     -0.149098138632259_REALK,      0.000000000000000_REALK,     -0.139521487866823_REALK, &
      0.000000000000000_REALK,      0.965143114998089_REALK,      0.000000000000000_REALK, &
      1.196646593539941_REALK,      0.000000000000000_REALK,      7.446346697125802_REALK, &
      7.339948911573960_REALK,     -0.290381330110068_REALK,      0.000000000000000_REALK, &
      0.754071618540991_REALK,      0.000000000000000_REALK,      3.161194598133265_REALK, &
     -0.119221865213120_REALK,      0.000000000000000_REALK,     -0.155666197601553_REALK, &
      0.000000000000000_REALK,      0.568545698123314_REALK,      0.000000000000000_REALK, &
      0.665339124666952_REALK,      0.000000000000000_REALK,      4.600729099392280_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.015477172644054_REALK, &
      0.000000000000000_REALK,     -0.115063440946951_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.366385366195310_REALK,      0.000000000000000_REALK, &
     -2.224579553720289_REALK,      0.000000000000000_REALK,     -0.087044572043115_REALK, &
      0.000000000000000_REALK,     -0.230742159849389_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.644437611628294_REALK, &
      0.000000000000000_REALK,     -0.116381883787994_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.320691452068052_REALK,      0.000000000000000_REALK, &
     -2.363588239625865_REALK,      0.000000000000000_REALK,     -0.003361535234870_REALK, &
      0.000000000000000_REALK,     -0.167846392849546_REALK,      0.000000000000000_REALK, &
      1.460184117409687_REALK,      0.201929154881281_REALK,      0.000000000000000_REALK, &
      0.243520029025333_REALK,      0.000000000000000_REALK,      1.260839710568709_REALK, &
      0.107083909961818_REALK,      0.000000000000000_REALK,      0.219817026579277_REALK, &
      0.000000000000000_REALK,      0.264339935805239_REALK,      0.000000000000000_REALK, &
      0.481563324261941_REALK,      0.000000000000000_REALK,      3.480657612271552_REALK, &
      2.849921159338293_REALK,      0.410046702015040_REALK,      0.000000000000000_REALK, &
      0.375404256290702_REALK,      0.000000000000000_REALK,      1.998542551091584_REALK, &
      0.190704036957615_REALK,      0.000000000000000_REALK,      0.360244216643633_REALK, &
      0.000000000000000_REALK,      0.354128942147378_REALK,      0.000000000000000_REALK, &
      0.520137893015116_REALK,      0.000000000000000_REALK,      3.878555652497624_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.857295091832735_REALK, &
      0.000000000000000_REALK,     -0.242294774937730_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.237057391577043_REALK,      0.000000000000000_REALK, &
     -1.299995154861867_REALK,      0.000000000000000_REALK,     -0.268778086129091_REALK, &
      0.000000000000000_REALK,     -0.650558683572143_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.170337820120804_REALK, &
      0.000000000000000_REALK,     -0.575559670579195_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.408789517140675_REALK,      0.000000000000000_REALK, &
     -2.653623158160284_REALK,      0.000000000000000_REALK,     -0.264031383267007_REALK, &
      0.000000000000000_REALK,     -1.095052718189422_REALK,      0.000000000000000_REALK, &
      0.790462412313811_REALK,      0.301002232025281_REALK,      0.000000000000000_REALK, &
      0.267390097234190_REALK,      0.000000000000000_REALK,      0.937328994168734_REALK, &
      0.257710284893964_REALK,      0.000000000000000_REALK,      0.450109225447823_REALK, &
      0.000000000000000_REALK,      0.501476006051275_REALK,      0.000000000000000_REALK, &
      0.704516154741010_REALK,      0.000000000000000_REALK,      3.204040950766415_REALK, &
      3.779113036432993_REALK,      1.723212565543977_REALK,      0.000000000000000_REALK, &
      1.395556641599759_REALK,      0.000000000000000_REALK,      3.624954498671252_REALK, &
      1.387302485301792_REALK,      0.000000000000000_REALK,      2.063736248659173_REALK, &
      0.000000000000000_REALK,      2.170241677820897_REALK,      0.000000000000000_REALK, &
      2.557515155693467_REALK,      0.000000000000000_REALK,      8.636406427517247_REALK/
  ! results of test 6, ket-major order, NEF 007
  data REF_CONTR_INTS(11341:12600)                                                         &
     /2.701098140226768_REALK,      2.320900570076323_REALK,      0.000000000000000_REALK, &
      2.591248245411444_REALK,      0.000000000000000_REALK,      0.419740313592309_REALK, &
      3.562835536716130_REALK,      0.000000000000000_REALK,      0.435246421152016_REALK, &
      0.000000000000000_REALK,      6.588129335809307_REALK,      0.000000000000000_REALK, &
      0.666928397524714_REALK,      0.000000000000000_REALK,      0.322802075231706_REALK, &
     -0.105824584138353_REALK,      1.752067727662201_REALK,      0.000000000000000_REALK, &
      2.956073603466896_REALK,      0.000000000000000_REALK,      0.366887791130976_REALK, &
      4.844952273056722_REALK,      0.000000000000000_REALK,      0.484598729990133_REALK, &
      0.000000000000000_REALK,      9.590332735199061_REALK,      0.000000000000000_REALK, &
      0.815751568391501_REALK,      0.000000000000000_REALK,      0.305889395666046_REALK, &
      2.158568783819077_REALK,      1.353518689104662_REALK,      0.000000000000000_REALK, &
      1.138090827431470_REALK,      0.000000000000000_REALK,      0.289763276240379_REALK, &
      1.150419764869625_REALK,      0.000000000000000_REALK,      0.216785471058380_REALK, &
      0.000000000000000_REALK,      1.467503833015667_REALK,      0.000000000000000_REALK, &
      0.239676914876257_REALK,      0.000000000000000_REALK,      0.182919881598370_REALK, &
      3.357358728950524_REALK,      1.343557596330297_REALK,      0.000000000000000_REALK, &
      0.741683644566042_REALK,      0.000000000000000_REALK,      0.237007527273046_REALK, &
      0.368374407514577_REALK,      0.000000000000000_REALK,      0.152211965769313_REALK, &
      0.000000000000000_REALK,     -0.230945463591693_REALK,      0.000000000000000_REALK, &
      0.123240633571778_REALK,      0.000000000000000_REALK,      0.123054000704305_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.372361844912733_REALK, &
      0.000000000000000_REALK,     -0.323547401934018_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.370735152682574_REALK,      0.000000000000000_REALK, &
     -0.179985612292851_REALK,      0.000000000000000_REALK,     -0.563767601542687_REALK, &
      0.000000000000000_REALK,     -0.206379723638673_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.650342364316210_REALK, &
      0.000000000000000_REALK,     -0.550615773330281_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.649336297002367_REALK,      0.000000000000000_REALK, &
     -0.245552494716919_REALK,      0.000000000000000_REALK,     -1.011150963095073_REALK, &
      0.000000000000000_REALK,     -0.303917692445544_REALK,      0.000000000000000_REALK, &
      2.285416893487947_REALK,      1.117256754835302_REALK,      0.000000000000000_REALK, &
      0.788984612359543_REALK,      0.000000000000000_REALK,      0.267056060625690_REALK, &
      0.678017823370460_REALK,      0.000000000000000_REALK,      0.152780472345493_REALK, &
      0.000000000000000_REALK,      0.754964641712753_REALK,      0.000000000000000_REALK, &
      0.136614440987299_REALK,      0.000000000000000_REALK,      0.138517925098524_REALK, &
     -0.447737299814500_REALK,      0.478496030823798_REALK,      0.000000000000000_REALK, &
      0.599077665565435_REALK,      0.000000000000000_REALK,      0.161816220476865_REALK, &
      0.713442892118047_REALK,      0.000000000000000_REALK,      0.117974946695935_REALK, &
      0.000000000000000_REALK,      1.078872503766642_REALK,      0.000000000000000_REALK, &
      0.117693350700113_REALK,      0.000000000000000_REALK,      0.096665890318759_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.297318918377936_REALK, &
      0.000000000000000_REALK,     -0.187511289127568_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.160259351509218_REALK,      0.000000000000000_REALK, &
     -0.122384202765108_REALK,      0.000000000000000_REALK,     -0.173049129714675_REALK, &
      0.000000000000000_REALK,     -0.097873622405618_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.151206449935744_REALK, &
      0.000000000000000_REALK,     -0.138770989243744_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.107328003889462_REALK,      0.000000000000000_REALK, &
     -0.107103721030918_REALK,      0.000000000000000_REALK,     -0.060831863363168_REALK, &
      0.000000000000000_REALK,     -0.081541158972604_REALK,      0.000000000000000_REALK, &
      0.437648444320209_REALK,      0.329857708378514_REALK,      0.000000000000000_REALK, &
      0.318408720085290_REALK,      0.000000000000000_REALK,      0.154987448865335_REALK, &
      0.373332548763704_REALK,      0.000000000000000_REALK,      0.136979508219872_REALK, &
      0.000000000000000_REALK,      0.552530926507434_REALK,      0.000000000000000_REALK, &
      0.167983352086219_REALK,      0.000000000000000_REALK,      0.135741136573662_REALK, &
      0.119349521288635_REALK,      0.444752350677262_REALK,      0.000000000000000_REALK, &
      0.631924927455185_REALK,      0.000000000000000_REALK,      0.236100948381035_REALK, &
      0.884729879116064_REALK,      0.000000000000000_REALK,      0.265832012901386_REALK, &
      0.000000000000000_REALK,      1.407115108614382_REALK,      0.000000000000000_REALK, &
      0.359605951187384_REALK,      0.000000000000000_REALK,      0.225240696595461_REALK, &
      3.111659788698682_REALK,      1.137137423994155_REALK,      0.000000000000000_REALK, &
      0.662866899461146_REALK,      0.000000000000000_REALK,      0.304047138141298_REALK, &
      0.453420248428358_REALK,      0.000000000000000_REALK,      0.129412730496203_REALK, &
      0.000000000000000_REALK,      0.392098488857551_REALK,      0.000000000000000_REALK, &
      0.092939723393949_REALK,      0.000000000000000_REALK,      0.127849368945360_REALK, &
      5.679228721147677_REALK,      1.476056342136931_REALK,      0.000000000000000_REALK, &
      0.582374138876282_REALK,      0.000000000000000_REALK,      0.317116335240199_REALK, &
      0.190618730337245_REALK,      0.000000000000000_REALK,      0.114015160847198_REALK, &
      0.000000000000000_REALK,     -0.133264648616140_REALK,      0.000000000000000_REALK, &
      0.059473907358084_REALK,      0.000000000000000_REALK,      0.100806240309775_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.330015941546816_REALK, &
      0.000000000000000_REALK,     -0.158255142744398_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.111416639779977_REALK,      0.000000000000000_REALK, &
     -0.113113834030808_REALK,      0.000000000000000_REALK,     -0.099106351370962_REALK, &
      0.000000000000000_REALK,     -0.066984647329884_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.554955610632287_REALK, &
      0.000000000000000_REALK,     -0.237867404058701_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.161507271608222_REALK,      0.000000000000000_REALK, &
     -0.135258793047917_REALK,      0.000000000000000_REALK,     -0.156706191605185_REALK, &
      0.000000000000000_REALK,     -0.078768936091027_REALK,      0.000000000000000_REALK, &
      0.426526391693766_REALK,      0.230444667285884_REALK,      0.000000000000000_REALK, &
      0.165360754930663_REALK,      0.000000000000000_REALK,      0.126370205110169_REALK, &
      0.140705243948726_REALK,      0.000000000000000_REALK,      0.079492300108247_REALK, &
      0.000000000000000_REALK,      0.143828105536542_REALK,      0.000000000000000_REALK, &
      0.070346646435697_REALK,      0.000000000000000_REALK,      0.089518203684166_REALK, &
      1.160054979164201_REALK,      0.460330899712574_REALK,      0.000000000000000_REALK, &
      0.226006582227151_REALK,      0.000000000000000_REALK,      0.214480594606604_REALK, &
      0.096587797159174_REALK,      0.000000000000000_REALK,      0.113738249311035_REALK, &
      0.000000000000000_REALK,     -0.034818935376573_REALK,      0.000000000000000_REALK, &
      0.072432452570726_REALK,      0.000000000000000_REALK,      0.118768034682612_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.189421285865727_REALK, &
      0.000000000000000_REALK,     -0.140299380875752_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.135199834850250_REALK,      0.000000000000000_REALK, &
     -0.109617415410657_REALK,      0.000000000000000_REALK,     -0.164402727738490_REALK, &
      0.000000000000000_REALK,     -0.100458579357807_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.679252718227887_REALK, &
      0.000000000000000_REALK,     -0.494261544282247_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.474788735531560_REALK,      0.000000000000000_REALK, &
     -0.300489847894725_REALK,      0.000000000000000_REALK,     -0.573624581464552_REALK, &
      0.000000000000000_REALK,     -0.288295818528966_REALK,      0.000000000000000_REALK, &
      5.027788384585276_REALK,      1.392435804334947_REALK,      0.000000000000000_REALK, &
      0.705118191474882_REALK,      0.000000000000000_REALK,      0.423584313925244_REALK, &
      0.396345293434733_REALK,      0.000000000000000_REALK,      0.132618298882758_REALK, &
      0.000000000000000_REALK,      0.296218270335332_REALK,      0.000000000000000_REALK, &
      0.079850819452496_REALK,      0.000000000000000_REALK,      0.143885101535448_REALK, &
     -1.014521759697077_REALK,      0.575236860846269_REALK,      0.000000000000000_REALK, &
      0.549716938930188_REALK,      0.000000000000000_REALK,      0.285974539610668_REALK, &
      0.481906108852080_REALK,      0.000000000000000_REALK,      0.117012186051561_REALK, &
      0.000000000000000_REALK,      0.585720130345402_REALK,      0.000000000000000_REALK, &
      0.077507645717117_REALK,      0.000000000000000_REALK,      0.122718227087600_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.455248222189159_REALK, &
      0.000000000000000_REALK,     -0.164324641224992_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.094817347796324_REALK,      0.000000000000000_REALK, &
     -0.130465996567812_REALK,      0.000000000000000_REALK,     -0.065526156771225_REALK, &
      0.000000000000000_REALK,     -0.056123912838097_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.228763205009934_REALK, &
      0.000000000000000_REALK,     -0.136690324305627_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.077104632682170_REALK,      0.000000000000000_REALK, &
     -0.131949752884489_REALK,      0.000000000000000_REALK,     -0.028242699887609_REALK, &
      0.000000000000000_REALK,     -0.057500617795425_REALK,      0.000000000000000_REALK, &
      0.562601759749127_REALK,      0.235889861269050_REALK,      0.000000000000000_REALK, &
      0.140854857549217_REALK,      0.000000000000000_REALK,      0.143174938323022_REALK, &
      0.100512006441326_REALK,      0.000000000000000_REALK,      0.067973862600696_REALK, &
      0.000000000000000_REALK,      0.089034803695006_REALK,      0.000000000000000_REALK, &
      0.048372072133269_REALK,      0.000000000000000_REALK,      0.081823330971038_REALK, &
      0.009585802813230_REALK,      0.208351216936940_REALK,      0.000000000000000_REALK, &
      0.208808854201079_REALK,      0.000000000000000_REALK,      0.170317172138583_REALK, &
      0.209624587558393_REALK,      0.000000000000000_REALK,      0.104652307127617_REALK, &
      0.000000000000000_REALK,      0.255400737000638_REALK,      0.000000000000000_REALK, &
      0.084519203590154_REALK,      0.000000000000000_REALK,      0.116342640687366_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.187820149833568_REALK, &
      0.000000000000000_REALK,     -0.100097091171354_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.071079023666522_REALK,      0.000000000000000_REALK, &
     -0.090518865195722_REALK,      0.000000000000000_REALK,     -0.061131320466194_REALK, &
      0.000000000000000_REALK,     -0.057576184136522_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.193241049178993_REALK, &
      0.000000000000000_REALK,     -0.145374478454151_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.095974090721383_REALK,      0.000000000000000_REALK, &
     -0.158404974407181_REALK,      0.000000000000000_REALK,     -0.045875001458375_REALK, &
      0.000000000000000_REALK,     -0.098267513257085_REALK,      0.000000000000000_REALK, &
      0.320433979689413_REALK,      0.206951755950123_REALK,      0.000000000000000_REALK, &
      0.168773316435485_REALK,      0.000000000000000_REALK,      0.137279733922107_REALK, &
      0.164282005917992_REALK,      0.000000000000000_REALK,      0.100649226534253_REALK, &
      0.000000000000000_REALK,      0.193363449861016_REALK,      0.000000000000000_REALK, &
      0.098138029609103_REALK,      0.000000000000000_REALK,      0.111306292238031_REALK, &
      0.262866959106174_REALK,      0.536225537956331_REALK,      0.000000000000000_REALK, &
      0.652513425866809_REALK,      0.000000000000000_REALK,      0.407385253661003_REALK, &
      0.776876015405800_REALK,      0.000000000000000_REALK,      0.389690184703725_REALK, &
      0.000000000000000_REALK,      0.999793701811812_REALK,      0.000000000000000_REALK, &
      0.426685046170568_REALK,      0.000000000000000_REALK,      0.375242064197229_REALK, &
     13.722145408550512_REALK,      2.522552468379467_REALK,      0.000000000000000_REALK, &
      1.070911511547497_REALK,      0.000000000000000_REALK,      0.837905262938787_REALK, &
      0.447376105931694_REALK,      0.000000000000000_REALK,      0.177036409447469_REALK, &
      0.000000000000000_REALK,      0.268532170171159_REALK,      0.000000000000000_REALK, &
      0.089156637051880_REALK,      0.000000000000000_REALK,      0.209473260539896_REALK, &
     42.910107977673910_REALK,      6.790674506388519_REALK,      0.000000000000000_REALK, &
      2.123150972849554_REALK,      0.000000000000000_REALK,      1.948696417117233_REALK, &
      0.429426296220983_REALK,      0.000000000000000_REALK,      0.348853014081117_REALK, &
      0.000000000000000_REALK,     -0.247755480975558_REALK,      0.000000000000000_REALK, &
      0.123183779208107_REALK,      0.000000000000000_REALK,      0.348199277693076_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.973135155472990_REALK, &
      0.000000000000000_REALK,     -0.243549895083689_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.114223963563787_REALK,      0.000000000000000_REALK, &
     -0.205869089019671_REALK,      0.000000000000000_REALK,     -0.061112031591708_REALK, &
      0.000000000000000_REALK,     -0.061335217256131_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.173124620655492_REALK, &
      0.000000000000000_REALK,     -0.729622823748489_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.306681485416590_REALK,      0.000000000000000_REALK, &
     -0.499074057329995_REALK,      0.000000000000000_REALK,     -0.174287063451320_REALK, &
      0.000000000000000_REALK,     -0.133243480093999_REALK,      0.000000000000000_REALK, &
      1.284352529793511_REALK,      0.373806909379863_REALK,      0.000000000000000_REALK, &
      0.173115837618518_REALK,      0.000000000000000_REALK,      0.238344026364687_REALK, &
      0.093231958488416_REALK,      0.000000000000000_REALK,      0.079693982427010_REALK, &
      0.000000000000000_REALK,      0.061811566444364_REALK,      0.000000000000000_REALK, &
      0.043826174565441_REALK,      0.000000000000000_REALK,      0.100514377136206_REALK, &
      5.749708489492345_REALK,      1.455900171199422_REALK,      0.000000000000000_REALK, &
      0.503491802142386_REALK,      0.000000000000000_REALK,      0.811093090043552_REALK, &
      0.142864055350447_REALK,      0.000000000000000_REALK,      0.231107320581282_REALK, &
      0.000000000000000_REALK,     -0.041802132096845_REALK,      0.000000000000000_REALK, &
      0.090220537156505_REALK,      0.000000000000000_REALK,      0.248131090503108_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.323518133835389_REALK, &
      0.000000000000000_REALK,     -0.123008157203369_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.068180014414776_REALK,      0.000000000000000_REALK, &
     -0.115567873342518_REALK,      0.000000000000000_REALK,     -0.046418042643024_REALK, &
      0.000000000000000_REALK,     -0.052322137804862_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.656545803289484_REALK, &
      0.000000000000000_REALK,     -0.603414569556965_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.317136326616763_REALK,      0.000000000000000_REALK, &
     -0.448729626246742_REALK,      0.000000000000000_REALK,     -0.220774229085043_REALK, &
      0.000000000000000_REALK,     -0.189394361901901_REALK,      0.000000000000000_REALK, &
      0.518901710418269_REALK,      0.223684090950578_REALK,      0.000000000000000_REALK, &
      0.127689879981750_REALK,      0.000000000000000_REALK,      0.162852738511341_REALK, &
      0.085723228730756_REALK,      0.000000000000000_REALK,      0.080613273787539_REALK, &
      0.000000000000000_REALK,      0.067288834928127_REALK,      0.000000000000000_REALK, &
      0.054675512998053_REALK,      0.000000000000000_REALK,      0.097496873109806_REALK, &
      3.740158955402680_REALK,      1.389016184439662_REALK,      0.000000000000000_REALK, &
      0.584636956296663_REALK,      0.000000000000000_REALK,      0.909098559009018_REALK, &
      0.209848757740847_REALK,      0.000000000000000_REALK,      0.377819460892106_REALK, &
      0.000000000000000_REALK,     -0.022771849599313_REALK,      0.000000000000000_REALK, &
      0.179231353670592_REALK,      0.000000000000000_REALK,      0.400071891998185_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.303506524428758_REALK, &
      0.000000000000000_REALK,     -0.178440257772552_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.135480772988701_REALK,      0.000000000000000_REALK, &
     -0.154466484098024_REALK,      0.000000000000000_REALK,     -0.126211389931195_REALK, &
      0.000000000000000_REALK,     -0.108286282439973_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.418553330530143_REALK, &
      0.000000000000000_REALK,     -2.053257953378807_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.513712033151589_REALK,      0.000000000000000_REALK, &
     -1.352088240302873_REALK,      0.000000000000000_REALK,     -1.323183752598956_REALK, &
      0.000000000000000_REALK,     -0.937369382601499_REALK,      0.000000000000000_REALK, &
      2.655490379483420_REALK,      0.992647194250360_REALK,      0.000000000000000_REALK, &
      2.212770885523600_REALK,      0.000000000000000_REALK,      1.021616031438875_REALK, &
      1.781670819380065_REALK,      0.000000000000000_REALK,      0.428867370718361_REALK, &
      0.000000000000000_REALK,     12.680593443110210_REALK,      0.000000000000000_REALK, &
      2.413372060497046_REALK,      0.000000000000000_REALK,      3.330649700496281_REALK, &
     -0.792319435522079_REALK,      0.381020414153909_REALK,      0.000000000000000_REALK, &
      1.640112775741183_REALK,      0.000000000000000_REALK,      0.560777407156120_REALK, &
      1.758763620041745_REALK,      0.000000000000000_REALK,      0.361238499692517_REALK, &
      0.000000000000000_REALK,     13.568995111841220_REALK,      0.000000000000000_REALK, &
      2.179197219676625_REALK,      0.000000000000000_REALK,      2.245786660297965_REALK, &
      2.375400266603721_REALK,      0.681515751088952_REALK,      0.000000000000000_REALK, &
      0.988872617369811_REALK,      0.000000000000000_REALK,      0.771114284080702_REALK, &
      0.707982084094037_REALK,      0.000000000000000_REALK,      0.257321500901523_REALK, &
      0.000000000000000_REALK,      2.698632363175691_REALK,      0.000000000000000_REALK, &
      0.869821126184822_REALK,      0.000000000000000_REALK,      2.035925203866346_REALK, &
      2.972897793806686_REALK,      0.490236576422815_REALK,      0.000000000000000_REALK, &
      0.387148838211783_REALK,      0.000000000000000_REALK,      0.406998346642862_REALK, &
      0.126882772938387_REALK,      0.000000000000000_REALK,      0.142119219112937_REALK, &
      0.000000000000000_REALK,     -0.566886039448656_REALK,      0.000000000000000_REALK, &
      0.312788630905055_REALK,      0.000000000000000_REALK,      1.044557201792298_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.411787285307435_REALK, &
      0.000000000000000_REALK,     -0.338744527502771_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.337026802303790_REALK,      0.000000000000000_REALK, &
     -0.468440622526532_REALK,      0.000000000000000_REALK,     -1.259764020986233_REALK, &
      0.000000000000000_REALK,     -0.905643175212977_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.455376442035299_REALK, &
      0.000000000000000_REALK,     -0.379791589081251_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.431647259634236_REALK,      0.000000000000000_REALK, &
     -0.452218884178989_REALK,      0.000000000000000_REALK,     -1.708742027761662_REALK, &
      0.000000000000000_REALK,     -1.044460726557295_REALK,      0.000000000000000_REALK, &
      2.811465732428767_REALK,      0.473720051377377_REALK,      0.000000000000000_REALK, &
      0.712032568509978_REALK,      0.000000000000000_REALK,      0.757089366836020_REALK, &
      0.355783888489302_REALK,      0.000000000000000_REALK,      0.154027972426510_REALK, &
      0.000000000000000_REALK,      1.270967327969816_REALK,      0.000000000000000_REALK, &
      0.482815744665238_REALK,      0.000000000000000_REALK,      1.542607113454200_REALK, &
     -1.154973271974134_REALK,      0.132593588029479_REALK,      0.000000000000000_REALK, &
      0.323784316492992_REALK,      0.000000000000000_REALK,      0.334797151188723_REALK, &
      0.290711450941707_REALK,      0.000000000000000_REALK,      0.095038272980639_REALK, &
      0.000000000000000_REALK,      1.166242835931429_REALK,      0.000000000000000_REALK, &
      0.260688072642994_REALK,      0.000000000000000_REALK,      0.803925837308264_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.434740103898028_REALK, &
      0.000000000000000_REALK,     -0.176582337665590_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.181936088063266_REALK,      0.000000000000000_REALK, &
     -0.425533555297194_REALK,      0.000000000000000_REALK,     -0.331541246310193_REALK, &
      0.000000000000000_REALK,     -0.363256826785639_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.162011749344452_REALK, &
      0.000000000000000_REALK,     -0.105777292537953_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.096903607299829_REALK,      0.000000000000000_REALK, &
     -0.314640581033114_REALK,      0.000000000000000_REALK,     -0.056529374321740_REALK, &
      0.000000000000000_REALK,     -0.248476943074367_REALK,      0.000000000000000_REALK, &
      0.393137589722309_REALK,      0.188498976671643_REALK,      0.000000000000000_REALK, &
      0.231652973444469_REALK,      0.000000000000000_REALK,      0.321754099813840_REALK, &
      0.258382594550207_REALK,      0.000000000000000_REALK,      0.186300228823618_REALK, &
      0.000000000000000_REALK,      0.843932801254711_REALK,      0.000000000000000_REALK, &
      0.482215619497918_REALK,      0.000000000000000_REALK,      1.110610386003702_REALK, &
      0.005883694770450_REALK,      0.195133808563213_REALK,      0.000000000000000_REALK, &
      0.339377264539001_REALK,      0.000000000000000_REALK,      0.350852314565482_REALK, &
      0.500087031764021_REALK,      0.000000000000000_REALK,      0.307163230805839_REALK, &
      0.000000000000000_REALK,      1.653727861974365_REALK,      0.000000000000000_REALK, &
      0.798061558337720_REALK,      0.000000000000000_REALK,      1.374730228205687_REALK, &
      4.200694524366036_REALK,      0.224885308175285_REALK,      0.000000000000000_REALK, &
      0.708072685129797_REALK,      0.000000000000000_REALK,      0.910826616964685_REALK, &
      0.093727029421861_REALK,      0.000000000000000_REALK,      0.060644482422418_REALK, &
      0.000000000000000_REALK,      0.782227325912667_REALK,      0.000000000000000_REALK, &
      0.356596716449159_REALK,      0.000000000000000_REALK,      1.380776206531235_REALK, &
      6.125862026142823_REALK,      0.173360692769081_REALK,      0.000000000000000_REALK, &
      0.399639289601587_REALK,      0.000000000000000_REALK,      0.652539312417267_REALK, &
     -0.068556876737877_REALK,      0.000000000000000_REALK,      0.031040798892566_REALK, &
      0.000000000000000_REALK,     -0.081905566222030_REALK,      0.000000000000000_REALK, &
      0.153354146682559_REALK,      0.000000000000000_REALK,      0.791792224719626_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.559689956892259_REALK, &
      0.000000000000000_REALK,     -0.108732301503624_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.142806145846960_REALK,      0.000000000000000_REALK, &
     -0.455524223051386_REALK,      0.000000000000000_REALK,     -0.127811237538687_REALK, &
      0.000000000000000_REALK,     -0.166341512964229_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.653562146410469_REALK, &
      0.000000000000000_REALK,     -0.112729794075987_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.129830337161372_REALK,      0.000000000000000_REALK, &
     -0.404791060877733_REALK,      0.000000000000000_REALK,     -0.149017344399772_REALK, &
      0.000000000000000_REALK,     -0.144095870758387_REALK,      0.000000000000000_REALK, &
      0.455380579064296_REALK,      0.129514729476747_REALK,      0.000000000000000_REALK, &
      0.128273238527442_REALK,      0.000000000000000_REALK,      0.299995624980951_REALK, &
      0.097383443872684_REALK,      0.000000000000000_REALK,      0.106240176671394_REALK, &
      0.000000000000000_REALK,      0.204297556506631_REALK,      0.000000000000000_REALK, &
      0.197181704968332_REALK,      0.000000000000000_REALK,      0.769064585320470_REALK, &
      0.931018823512272_REALK,      0.192752075443579_REALK,      0.000000000000000_REALK, &
      0.118416210471307_REALK,      0.000000000000000_REALK,      0.368675793620354_REALK, &
      0.036887985776719_REALK,      0.000000000000000_REALK,      0.124288710773616_REALK, &
      0.000000000000000_REALK,     -0.076685936310467_REALK,      0.000000000000000_REALK, &
      0.144529975676765_REALK,      0.000000000000000_REALK,      0.792926922616158_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.234721403924342_REALK, &
      0.000000000000000_REALK,     -0.130873505876153_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.139341830951155_REALK,      0.000000000000000_REALK, &
     -0.322595880540108_REALK,      0.000000000000000_REALK,     -0.284079225034353_REALK, &
      0.000000000000000_REALK,     -0.340641653779730_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.565955297148033_REALK, &
      0.000000000000000_REALK,     -0.341192109222744_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.377721350708107_REALK,      0.000000000000000_REALK, &
     -0.659439098944888_REALK,      0.000000000000000_REALK,     -0.765857915064187_REALK, &
      0.000000000000000_REALK,     -0.782094375029168_REALK,      0.000000000000000_REALK, &
      7.519310251242884_REALK,     -0.283132293688668_REALK,      0.000000000000000_REALK, &
      0.992002248880838_REALK,      0.000000000000000_REALK,      1.323305895150148_REALK, &
     -0.192717470710430_REALK,      0.000000000000000_REALK,     -0.062290351743604_REALK, &
      0.000000000000000_REALK,      0.820461661426642_REALK,      0.000000000000000_REALK, &
      0.362365854272424_REALK,      0.000000000000000_REALK,      1.454642417916659_REALK, &
     -2.167112880234813_REALK,     -0.126183258524820_REALK,      0.000000000000000_REALK, &
      0.541415855087923_REALK,      0.000000000000000_REALK,      0.783059952929746_REALK, &
     -0.073645199663639_REALK,      0.000000000000000_REALK,     -0.055412490525311_REALK, &
      0.000000000000000_REALK,      0.740636679369007_REALK,      0.000000000000000_REALK, &
      0.227570011234293_REALK,      0.000000000000000_REALK,      0.978269518022212_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.861244510331195_REALK, &
      0.000000000000000_REALK,     -0.048777406461239_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.147013783131567_REALK,      0.000000000000000_REALK, &
     -0.567542236044321_REALK,      0.000000000000000_REALK,     -0.027570839772876_REALK, &
      0.000000000000000_REALK,     -0.053906059682387_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.394294303591318_REALK, &
      0.000000000000000_REALK,     -0.027484783094850_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.100727812537560_REALK,      0.000000000000000_REALK, &
     -0.515524582479401_REALK,      0.000000000000000_REALK,      0.030838848406412_REALK, &
      0.000000000000000_REALK,     -0.033962741419256_REALK,      0.000000000000000_REALK, &
      0.684603843977610_REALK,      0.102190151051361_REALK,      0.000000000000000_REALK, &
      0.114536114439716_REALK,      0.000000000000000_REALK,      0.365058999024289_REALK, &
      0.052241773092686_REALK,      0.000000000000000_REALK,      0.067820825431999_REALK, &
      0.000000000000000_REALK,      0.111841018750632_REALK,      0.000000000000000_REALK, &
      0.127401693392975_REALK,      0.000000000000000_REALK,      0.678001913655530_REALK, &
     -0.039418423053385_REALK,      0.081226308774599_REALK,      0.000000000000000_REALK, &
      0.122691993597519_REALK,      0.000000000000000_REALK,      0.381449554400878_REALK, &
      0.094795757584020_REALK,      0.000000000000000_REALK,      0.093247606545900_REALK, &
      0.000000000000000_REALK,      0.219619016873194_REALK,      0.000000000000000_REALK, &
      0.149808111194618_REALK,      0.000000000000000_REALK,      0.773142723850615_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.280928543952920_REALK, &
      0.000000000000000_REALK,     -0.084740300461475_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.080051976946793_REALK,      0.000000000000000_REALK, &
     -0.312044952639903_REALK,      0.000000000000000_REALK,     -0.087255438445996_REALK, &
      0.000000000000000_REALK,     -0.159082061924956_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.277985562982027_REALK, &
      0.000000000000000_REALK,     -0.119248885703748_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.095319242884727_REALK,      0.000000000000000_REALK, &
     -0.514084010426869_REALK,      0.000000000000000_REALK,     -0.035902892513765_REALK, &
      0.000000000000000_REALK,     -0.238852702646974_REALK,      0.000000000000000_REALK, &
      0.284787105191334_REALK,      0.121317697421357_REALK,      0.000000000000000_REALK, &
      0.110526883528945_REALK,      0.000000000000000_REALK,      0.256502460297475_REALK, &
      0.113416945069003_REALK,      0.000000000000000_REALK,      0.136340640474859_REALK, &
      0.000000000000000_REALK,      0.220518808903518_REALK,      0.000000000000000_REALK, &
      0.210236884154648_REALK,      0.000000000000000_REALK,      0.679190957308784_REALK, &
      0.177903313067088_REALK,      0.297970989841829_REALK,      0.000000000000000_REALK, &
      0.375643786336417_REALK,      0.000000000000000_REALK,      0.650089714858188_REALK, &
      0.487998045362232_REALK,      0.000000000000000_REALK,      0.499860966567364_REALK, &
      0.000000000000000_REALK,      0.934935579727619_REALK,      0.000000000000000_REALK, &
      0.753742622970808_REALK,      0.000000000000000_REALK,      1.825418859722555_REALK, &
     20.156937874784106_REALK,     -1.988292684689328_REALK,      0.000000000000000_REALK, &
      2.030325069974077_REALK,      0.000000000000000_REALK,      2.499131785578872_REALK, &
     -0.798113878264950_REALK,      0.000000000000000_REALK,     -0.315675657243652_REALK, &
      0.000000000000000_REALK,      1.248977920344708_REALK,      0.000000000000000_REALK, &
      0.499122964731242_REALK,      0.000000000000000_REALK,      1.847651822933849_REALK, &
     54.062079230546466_REALK,     -5.022584466987309_REALK,      0.000000000000000_REALK, &
      3.341942027939970_REALK,      0.000000000000000_REALK,      4.518343649203884_REALK, &
     -1.415023154565824_REALK,      0.000000000000000_REALK,     -0.551290728889458_REALK, &
      0.000000000000000_REALK,      0.859659119267675_REALK,      0.000000000000000_REALK, &
      0.504002598039515_REALK,      0.000000000000000_REALK,      2.078380252283425_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.820155677175086_REALK, &
      0.000000000000000_REALK,      0.065205141095838_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.216958154282777_REALK,      0.000000000000000_REALK, &
     -0.868244908264426_REALK,      0.000000000000000_REALK,      0.050562641097888_REALK, &
      0.000000000000000_REALK,      0.049081290022261_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.824457174784596_REALK, &
      0.000000000000000_REALK,      0.176542411136514_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.371692154997699_REALK,      0.000000000000000_REALK, &
     -1.597554322392080_REALK,      0.000000000000000_REALK,      0.040004511896613_REALK, &
      0.000000000000000_REALK,      0.083965454318683_REALK,      0.000000000000000_REALK, &
      1.575636579656968_REALK,      0.066678208938470_REALK,      0.000000000000000_REALK, &
      0.154600380105766_REALK,      0.000000000000000_REALK,      0.595143847207765_REALK, &
      0.016576352618727_REALK,      0.000000000000000_REALK,      0.032002342126990_REALK, &
      0.000000000000000_REALK,      0.084745030597104_REALK,      0.000000000000000_REALK, &
      0.115598644644837_REALK,      0.000000000000000_REALK,      0.744754523242990_REALK, &
      6.064667257461404_REALK,      0.176602414281519_REALK,      0.000000000000000_REALK, &
      0.334563514962121_REALK,      0.000000000000000_REALK,      1.621820163459598_REALK, &
     -0.034653786391153_REALK,      0.000000000000000_REALK,      0.057353875432238_REALK, &
      0.000000000000000_REALK,     -0.010705275763772_REALK,      0.000000000000000_REALK, &
      0.154670294102837_REALK,      0.000000000000000_REALK,      1.298849001650552_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.494719975193396_REALK, &
      0.000000000000000_REALK,     -0.070567791241431_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.075149513769710_REALK,      0.000000000000000_REALK, &
     -0.399212074606140_REALK,      0.000000000000000_REALK,     -0.041233169151057_REALK, &
      0.000000000000000_REALK,     -0.089313197171518_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.072064648229465_REALK, &
      0.000000000000000_REALK,     -0.277892447304802_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.230013297704188_REALK,      0.000000000000000_REALK, &
     -1.203026467579728_REALK,      0.000000000000000_REALK,     -0.139418698555045_REALK, &
      0.000000000000000_REALK,     -0.231263817724852_REALK,      0.000000000000000_REALK, &
      0.504644654990279_REALK,      0.113535445179148_REALK,      0.000000000000000_REALK, &
      0.082953608389512_REALK,      0.000000000000000_REALK,      0.323238942262380_REALK, &
      0.051062825150696_REALK,      0.000000000000000_REALK,      0.092676998327514_REALK, &
      0.000000000000000_REALK,      0.065864213603836_REALK,      0.000000000000000_REALK, &
      0.105619386109668_REALK,      0.000000000000000_REALK,      0.576550552106595_REALK, &
      3.205269254842626_REALK,      0.624957890638766_REALK,      0.000000000000000_REALK, &
      0.298333684387659_REALK,      0.000000000000000_REALK,      1.515081277974189_REALK, &
      0.074785194761007_REALK,      0.000000000000000_REALK,      0.368120291451958_REALK, &
      0.000000000000000_REALK,     -0.053714872169266_REALK,      0.000000000000000_REALK, &
      0.238704625925072_REALK,      0.000000000000000_REALK,      1.777432904979887_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.341148751158172_REALK, &
      0.000000000000000_REALK,     -0.139511810117093_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.120910670550858_REALK,      0.000000000000000_REALK, &
     -0.392795481614922_REALK,      0.000000000000000_REALK,     -0.150782302954703_REALK, &
      0.000000000000000_REALK,     -0.253469569402606_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.076956436320883_REALK, &
      0.000000000000000_REALK,     -1.370704574296483_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.080225490867434_REALK,      0.000000000000000_REALK, &
     -2.663560504679927_REALK,      0.000000000000000_REALK,     -1.181304416559051_REALK, &
      0.000000000000000_REALK,     -1.698304345236222_REALK,      0.000000000000000_REALK/
  ! results of test 6, ket-major order, NEF 008
  data REF_CONTR_INTS(12601:13860)                                                         &
    /-0.739461672069956_REALK,     -0.745774673054482_REALK,      0.000000000000000_REALK, &
     -0.903806324553673_REALK,      0.000000000000000_REALK,     -0.110546747074411_REALK, &
     -1.316070802237606_REALK,      0.000000000000000_REALK,     -0.133426985626123_REALK, &
      0.000000000000000_REALK,     -2.495277595757547_REALK,      0.000000000000000_REALK, &
     -0.217556888826189_REALK,      0.000000000000000_REALK,     -0.079601550501254_REALK, &
      1.471572399384274_REALK,     -0.209417435662664_REALK,      0.000000000000000_REALK, &
     -1.130103945882427_REALK,      0.000000000000000_REALK,     -0.110199560981410_REALK, &
     -2.230441714028300_REALK,      0.000000000000000_REALK,     -0.189184873998331_REALK, &
      0.000000000000000_REALK,     -4.670888835844669_REALK,      0.000000000000000_REALK, &
     -0.348128607996363_REALK,      0.000000000000000_REALK,     -0.104303672276781_REALK, &
     -0.475483730920752_REALK,     -0.361905708495221_REALK,      0.000000000000000_REALK, &
     -0.324119652347425_REALK,      0.000000000000000_REALK,     -0.061041454723181_REALK, &
     -0.337976791399390_REALK,      0.000000000000000_REALK,     -0.055089688623789_REALK, &
      0.000000000000000_REALK,     -0.420795738425703_REALK,      0.000000000000000_REALK, &
     -0.063790975055864_REALK,      0.000000000000000_REALK,     -0.036088866513759_REALK, &
     -1.545209900781215_REALK,     -0.550907865704818_REALK,      0.000000000000000_REALK, &
     -0.202877585978168_REALK,      0.000000000000000_REALK,     -0.070039927210035_REALK, &
      0.041784176239693_REALK,      0.000000000000000_REALK,     -0.041393353337012_REALK, &
      0.000000000000000_REALK,      0.484155573332194_REALK,      0.000000000000000_REALK, &
     -0.022115430217405_REALK,      0.000000000000000_REALK,     -0.028854526995485_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.102453907785196_REALK, &
      0.000000000000000_REALK,      0.103881181430328_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.128653823890309_REALK,      0.000000000000000_REALK, &
      0.047176622636164_REALK,      0.000000000000000_REALK,      0.204273850582463_REALK, &
      0.000000000000000_REALK,      0.062073228501068_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.330216651367461_REALK, &
      0.000000000000000_REALK,      0.270966549005705_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.314893747102347_REALK,      0.000000000000000_REALK, &
      0.095310347891983_REALK,      0.000000000000000_REALK,      0.491251041372367_REALK, &
      0.000000000000000_REALK,      0.125703074910157_REALK,      0.000000000000000_REALK, &
     -0.424903978149634_REALK,     -0.275803154807362_REALK,      0.000000000000000_REALK, &
     -0.212261640253342_REALK,      0.000000000000000_REALK,     -0.047843379530943_REALK, &
     -0.198604434805827_REALK,      0.000000000000000_REALK,     -0.035963828474814_REALK, &
      0.000000000000000_REALK,     -0.232979869939811_REALK,      0.000000000000000_REALK, &
     -0.034507283420340_REALK,      0.000000000000000_REALK,     -0.023319115833420_REALK, &
      0.656409768844605_REALK,     -0.004002114799226_REALK,      0.000000000000000_REALK, &
     -0.187564234363459_REALK,      0.000000000000000_REALK,     -0.028675947321678_REALK, &
     -0.321731088894092_REALK,      0.000000000000000_REALK,     -0.034451029705710_REALK, &
      0.000000000000000_REALK,     -0.588815452152522_REALK,      0.000000000000000_REALK, &
     -0.043448495602638_REALK,      0.000000000000000_REALK,     -0.021448410803314_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.065428379681205_REALK, &
      0.000000000000000_REALK,      0.050079974261640_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.045467179602946_REALK,      0.000000000000000_REALK, &
      0.025695889378100_REALK,      0.000000000000000_REALK,      0.050089371456029_REALK, &
      0.000000000000000_REALK,      0.024519726833532_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.001308865176325_REALK, &
      0.000000000000000_REALK,      0.024541297215439_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.016601002928358_REALK,      0.000000000000000_REALK, &
      0.023832104981634_REALK,      0.000000000000000_REALK,     -0.013471046842826_REALK, &
      0.000000000000000_REALK,      0.019345915587107_REALK,      0.000000000000000_REALK, &
     -0.124949892808123_REALK,     -0.110646357224635_REALK,      0.000000000000000_REALK, &
     -0.116024900983087_REALK,      0.000000000000000_REALK,     -0.042626262947544_REALK, &
     -0.143983225342509_REALK,      0.000000000000000_REALK,     -0.043836895084084_REALK, &
      0.000000000000000_REALK,     -0.219559916986375_REALK,      0.000000000000000_REALK, &
     -0.057484606855113_REALK,      0.000000000000000_REALK,     -0.035099934365033_REALK, &
      0.215680952057660_REALK,     -0.089991829443776_REALK,      0.000000000000000_REALK, &
     -0.254942384911369_REALK,      0.000000000000000_REALK,     -0.075211317117420_REALK, &
     -0.424613025869650_REALK,      0.000000000000000_REALK,     -0.108199801367071_REALK, &
      0.000000000000000_REALK,     -0.722608379905891_REALK,      0.000000000000000_REALK, &
     -0.161760940562958_REALK,      0.000000000000000_REALK,     -0.080899908825516_REALK, &
     -0.494675980042852_REALK,     -0.262943862556640_REALK,      0.000000000000000_REALK, &
     -0.161301490615833_REALK,      0.000000000000000_REALK,     -0.046000890726718_REALK, &
     -0.119726574510250_REALK,      0.000000000000000_REALK,     -0.028329991467745_REALK, &
      0.000000000000000_REALK,     -0.102540425504056_REALK,      0.000000000000000_REALK, &
     -0.021174428333942_REALK,      0.000000000000000_REALK,     -0.018144786162169_REALK, &
     -1.621816029349614_REALK,     -0.490548610423350_REALK,      0.000000000000000_REALK, &
     -0.136447041270085_REALK,      0.000000000000000_REALK,     -0.069368029287374_REALK, &
      0.040096310212287_REALK,      0.000000000000000_REALK,     -0.028568198336878_REALK, &
      0.000000000000000_REALK,      0.247276635107028_REALK,      0.000000000000000_REALK, &
     -0.009569380161925_REALK,      0.000000000000000_REALK,     -0.018187118257073_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.062568383682513_REALK, &
      0.000000000000000_REALK,      0.039488982830349_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.030091784530281_REALK,      0.000000000000000_REALK, &
      0.020346415663043_REALK,      0.000000000000000_REALK,      0.028843486336313_REALK, &
      0.000000000000000_REALK,      0.015664661833131_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.180515509415345_REALK, &
      0.000000000000000_REALK,      0.092605212196801_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.069809200399909_REALK,      0.000000000000000_REALK, &
      0.035872114484399_REALK,      0.000000000000000_REALK,      0.078124048770132_REALK, &
      0.000000000000000_REALK,      0.026195149686584_REALK,      0.000000000000000_REALK, &
     -0.099587907923474_REALK,     -0.065200806407382_REALK,      0.000000000000000_REALK, &
     -0.049770884742834_REALK,      0.000000000000000_REALK,     -0.028100521352046_REALK, &
     -0.043649362624484_REALK,      0.000000000000000_REALK,     -0.021307192768633_REALK, &
      0.000000000000000_REALK,     -0.043736755937781_REALK,      0.000000000000000_REALK, &
     -0.019818310707801_REALK,      0.000000000000000_REALK,     -0.018673175127472_REALK, &
     -0.462948630065225_REALK,     -0.176923987796274_REALK,      0.000000000000000_REALK, &
     -0.063385791302459_REALK,      0.000000000000000_REALK,     -0.066074039347768_REALK, &
      0.007876841690921_REALK,      0.000000000000000_REALK,     -0.033740621396512_REALK, &
      0.000000000000000_REALK,      0.094653340924738_REALK,      0.000000000000000_REALK, &
     -0.014908816070563_REALK,      0.000000000000000_REALK,     -0.030555965806287_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.055046854980664_REALK, &
      0.000000000000000_REALK,      0.047526044682082_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.049433514028264_REALK,      0.000000000000000_REALK, &
      0.030258710627741_REALK,      0.000000000000000_REALK,      0.062966497443557_REALK, &
      0.000000000000000_REALK,      0.031932866599181_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.343838910047406_REALK, &
      0.000000000000000_REALK,      0.258389132797418_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.250102700338636_REALK,      0.000000000000000_REALK, &
      0.126496000877934_REALK,      0.000000000000000_REALK,      0.303989909560324_REALK, &
      0.000000000000000_REALK,      0.130027015397657_REALK,      0.000000000000000_REALK, &
     -0.654839299872506_REALK,     -0.310882289972119_REALK,      0.000000000000000_REALK, &
     -0.159830282775817_REALK,      0.000000000000000_REALK,     -0.053458620379247_REALK, &
     -0.105002035986162_REALK,      0.000000000000000_REALK,     -0.028302682828235_REALK, &
      0.000000000000000_REALK,     -0.080749221878807_REALK,      0.000000000000000_REALK, &
     -0.017061517269845_REALK,      0.000000000000000_REALK,     -0.017133922868837_REALK, &
      0.842293651679185_REALK,      0.008134068586744_REALK,      0.000000000000000_REALK, &
     -0.148472251753300_REALK,      0.000000000000000_REALK,     -0.032158225169054_REALK, &
     -0.225397181418054_REALK,      0.000000000000000_REALK,     -0.028476962274283_REALK, &
      0.000000000000000_REALK,     -0.369921934573235_REALK,      0.000000000000000_REALK, &
     -0.025402105259374_REALK,      0.000000000000000_REALK,     -0.018392763310907_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.072322859771557_REALK, &
      0.000000000000000_REALK,      0.038157364860835_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.023177300103341_REALK,      0.000000000000000_REALK, &
      0.019834340513758_REALK,      0.000000000000000_REALK,      0.017279240868493_REALK, &
      0.000000000000000_REALK,      0.012272642544450_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.002045734269121_REALK, &
      0.000000000000000_REALK,      0.019968236008414_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.009103939563758_REALK,      0.000000000000000_REALK, &
      0.021126381281279_REALK,      0.000000000000000_REALK,     -0.010943684383030_REALK, &
      0.000000000000000_REALK,      0.012046983386390_REALK,      0.000000000000000_REALK, &
     -0.110753093904024_REALK,     -0.061876891888520_REALK,      0.000000000000000_REALK, &
     -0.040328437380764_REALK,      0.000000000000000_REALK,     -0.027281031274609_REALK, &
     -0.031347831022380_REALK,      0.000000000000000_REALK,     -0.017042748467007_REALK, &
      0.000000000000000_REALK,     -0.029325830552021_REALK,      0.000000000000000_REALK, &
     -0.013052126208062_REALK,      0.000000000000000_REALK,     -0.014706766424673_REALK, &
      0.152679801893750_REALK,     -0.023598429807477_REALK,      0.000000000000000_REALK, &
     -0.070006186758576_REALK,      0.000000000000000_REALK,     -0.032908078158820_REALK, &
     -0.099152639460373_REALK,      0.000000000000000_REALK,     -0.032128904216986_REALK, &
      0.000000000000000_REALK,     -0.148205885622784_REALK,      0.000000000000000_REALK, &
     -0.033112298998334_REALK,      0.000000000000000_REALK,     -0.027437617455144_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.043896048467262_REALK, &
      0.000000000000000_REALK,      0.028464638129256_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.021494699050593_REALK,      0.000000000000000_REALK, &
      0.020229833881578_REALK,      0.000000000000000_REALK,      0.018935805853840_REALK, &
      0.000000000000000_REALK,      0.015415144722995_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.013226399758615_REALK, &
      0.000000000000000_REALK,      0.028492847928360_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.016057369317249_REALK,      0.000000000000000_REALK, &
      0.037155581644512_REALK,      0.000000000000000_REALK,     -0.009135729869275_REALK, &
      0.000000000000000_REALK,      0.024990234989628_REALK,      0.000000000000000_REALK, &
     -0.096858045988795_REALK,     -0.073721227071320_REALK,      0.000000000000000_REALK, &
     -0.065414977861465_REALK,      0.000000000000000_REALK,     -0.040131805278771_REALK, &
     -0.067430454973902_REALK,      0.000000000000000_REALK,     -0.034272296410740_REALK, &
      0.000000000000000_REALK,     -0.082028245891661_REALK,      0.000000000000000_REALK, &
     -0.035846340917816_REALK,      0.000000000000000_REALK,     -0.030701824962977_REALK, &
      0.151452282138480_REALK,     -0.135735160271974_REALK,      0.000000000000000_REALK, &
     -0.276670614728528_REALK,      0.000000000000000_REALK,     -0.136698182947857_REALK, &
     -0.391813882691164_REALK,      0.000000000000000_REALK,     -0.166631015375253_REALK, &
      0.000000000000000_REALK,     -0.547884287893007_REALK,      0.000000000000000_REALK, &
     -0.204706826286663_REALK,      0.000000000000000_REALK,     -0.143596756107020_REALK, &
     -1.559148179524265_REALK,     -0.603900891304342_REALK,      0.000000000000000_REALK, &
     -0.226743275621727_REALK,      0.000000000000000_REALK,     -0.089565710773335_REALK, &
     -0.119372833836624_REALK,      0.000000000000000_REALK,     -0.039538329495090_REALK, &
      0.000000000000000_REALK,     -0.065231389566505_REALK,      0.000000000000000_REALK, &
     -0.017486564003970_REALK,      0.000000000000000_REALK,     -0.020785886440519_REALK, &
     -6.981183714457899_REALK,     -2.000757447881561_REALK,      0.000000000000000_REALK, &
     -0.392129854483315_REALK,      0.000000000000000_REALK,     -0.290306930092985_REALK, &
      0.135945386532491_REALK,      0.000000000000000_REALK,     -0.091925984081103_REALK, &
      0.000000000000000_REALK,      0.526644315746957_REALK,      0.000000000000000_REALK, &
     -0.018178166047370_REALK,      0.000000000000000_REALK,     -0.047049467784742_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.136632654325196_REALK, &
      0.000000000000000_REALK,      0.057618597907318_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.026988997052019_REALK,      0.000000000000000_REALK, &
      0.027067371518457_REALK,      0.000000000000000_REALK,      0.016620969377409_REALK, &
      0.000000000000000_REALK,      0.013438393276154_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.665306373410382_REALK, &
      0.000000000000000_REALK,      0.249727560868024_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.123482852932572_REALK,      0.000000000000000_REALK, &
      0.096457953472186_REALK,      0.000000000000000_REALK,      0.097100821262810_REALK, &
      0.000000000000000_REALK,      0.041877408935296_REALK,      0.000000000000000_REALK, &
     -0.229161189836748_REALK,     -0.096801107896848_REALK,      0.000000000000000_REALK, &
     -0.046877358281733_REALK,      0.000000000000000_REALK,     -0.040025301399494_REALK, &
     -0.027253084707379_REALK,      0.000000000000000_REALK,     -0.019280889476541_REALK, &
      0.000000000000000_REALK,     -0.017859621928096_REALK,      0.000000000000000_REALK, &
     -0.010992947952754_REALK,      0.000000000000000_REALK,     -0.015674149436499_REALK, &
     -1.459991639737663_REALK,     -0.463555330125558_REALK,      0.000000000000000_REALK, &
     -0.124656176222930_REALK,      0.000000000000000_REALK,     -0.188854558018725_REALK, &
      0.019914763330784_REALK,      0.000000000000000_REALK,     -0.066126570383725_REALK, &
      0.000000000000000_REALK,      0.120993971018251_REALK,      0.000000000000000_REALK, &
     -0.018650989786075_REALK,      0.000000000000000_REALK,     -0.052431435795303_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.068446094654151_REALK, &
      0.000000000000000_REALK,      0.034094517480762_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.020313790226899_REALK,      0.000000000000000_REALK, &
      0.022908604955515_REALK,      0.000000000000000_REALK,      0.014841690441942_REALK, &
      0.000000000000000_REALK,      0.013450766691120_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.537598413239325_REALK, &
      0.000000000000000_REALK,      0.252878518182790_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.154549631088374_REALK,      0.000000000000000_REALK, &
      0.134519126991613_REALK,      0.000000000000000_REALK,      0.126652320365507_REALK, &
      0.000000000000000_REALK,      0.072968804192713_REALK,      0.000000000000000_REALK, &
     -0.135891994016053_REALK,     -0.070760603723237_REALK,      0.000000000000000_REALK, &
     -0.042733830629571_REALK,      0.000000000000000_REALK,     -0.040153606024383_REALK, &
     -0.029417223220446_REALK,      0.000000000000000_REALK,     -0.023845223552063_REALK, &
      0.000000000000000_REALK,     -0.022597203941715_REALK,      0.000000000000000_REALK, &
     -0.016947841409630_REALK,      0.000000000000000_REALK,     -0.022326977558824_REALK, &
     -1.362563384922431_REALK,     -0.527651260439944_REALK,      0.000000000000000_REALK, &
     -0.177734019106349_REALK,      0.000000000000000_REALK,     -0.303508297603083_REALK, &
      0.004500389860763_REALK,      0.000000000000000_REALK,     -0.129250883691337_REALK, &
      0.000000000000000_REALK,      0.137210526462408_REALK,      0.000000000000000_REALK, &
     -0.046457363360140_REALK,      0.000000000000000_REALK,     -0.121087081879580_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.098176647215010_REALK, &
      0.000000000000000_REALK,      0.066936180167221_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.054518708095563_REALK,      0.000000000000000_REALK, &
      0.046882632514018_REALK,      0.000000000000000_REALK,      0.053020216243764_REALK, &
      0.000000000000000_REALK,      0.037745294331981_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.779861587483093_REALK, &
      0.000000000000000_REALK,      1.180450002401083_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.913770100025630_REALK,      0.000000000000000_REALK, &
      0.650175870387458_REALK,      0.000000000000000_REALK,      0.819559519479399_REALK, &
      0.000000000000000_REALK,      0.493517010085538_REALK,      0.000000000000000_REALK, &
     -0.375140322597673_REALK,     -0.299178858487428_REALK,      0.000000000000000_REALK, &
     -0.572503376474164_REALK,      0.000000000000000_REALK,     -0.137431601062016_REALK, &
     -0.649911602262966_REALK,      0.000000000000000_REALK,     -0.124245933266991_REALK, &
      0.000000000000000_REALK,     -3.917782432157510_REALK,      0.000000000000000_REALK, &
     -0.581539540587833_REALK,      0.000000000000000_REALK,     -0.417966144967906_REALK, &
      1.178804260707567_REALK,      0.121592132813256_REALK,      0.000000000000000_REALK, &
     -0.529494943387804_REALK,      0.000000000000000_REALK,     -0.105664539323410_REALK, &
     -0.855106236377256_REALK,      0.000000000000000_REALK,     -0.137760711046961_REALK, &
      0.000000000000000_REALK,     -5.848252400059942_REALK,      0.000000000000000_REALK, &
     -0.760098381475959_REALK,      0.000000000000000_REALK,     -0.464062057397886_REALK, &
     -0.220819808697720_REALK,     -0.188921154389229_REALK,      0.000000000000000_REALK, &
     -0.185009886414493_REALK,      0.000000000000000_REALK,     -0.067338099185273_REALK, &
     -0.212623170407772_REALK,      0.000000000000000_REALK,     -0.068067520071369_REALK, &
      0.000000000000000_REALK,     -0.560628669178621_REALK,      0.000000000000000_REALK, &
     -0.147889562365820_REALK,      0.000000000000000_REALK,     -0.162113961073442_REALK, &
     -0.864762219439718_REALK,     -0.270375074634936_REALK,      0.000000000000000_REALK, &
     -0.065337150721850_REALK,      0.000000000000000_REALK,     -0.056125884018223_REALK, &
      0.038707552980389_REALK,      0.000000000000000_REALK,     -0.039005886875760_REALK, &
      0.000000000000000_REALK,      0.736861586551276_REALK,      0.000000000000000_REALK, &
     -0.024034991409248_REALK,      0.000000000000000_REALK,     -0.106604157771621_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.063881325378740_REALK, &
      0.000000000000000_REALK,      0.088534935769809_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.096684939810567_REALK,      0.000000000000000_REALK, &
      0.069710885277165_REALK,      0.000000000000000_REALK,      0.377247645709308_REALK, &
      0.000000000000000_REALK,      0.215485729746964_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.168462510434431_REALK, &
      0.000000000000000_REALK,      0.156125837540314_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.188545264809742_REALK,      0.000000000000000_REALK, &
      0.116336611761522_REALK,      0.000000000000000_REALK,      0.710482989386803_REALK, &
      0.000000000000000_REALK,      0.342788256542079_REALK,      0.000000000000000_REALK, &
     -0.152899910910515_REALK,     -0.170107475198924_REALK,      0.000000000000000_REALK, &
     -0.089602355821287_REALK,      0.000000000000000_REALK,     -0.038784831905202_REALK, &
     -0.138091046730725_REALK,      0.000000000000000_REALK,     -0.052404294720152_REALK, &
      0.000000000000000_REALK,     -0.211234433621634_REALK,      0.000000000000000_REALK, &
     -0.054720229087484_REALK,      0.000000000000000_REALK,     -0.071241252074410_REALK, &
      0.375807841815618_REALK,      0.054650507160254_REALK,      0.000000000000000_REALK, &
     -0.064463861098812_REALK,      0.000000000000000_REALK,     -0.019552373053807_REALK, &
     -0.161420060186350_REALK,      0.000000000000000_REALK,     -0.036369788415992_REALK, &
      0.000000000000000_REALK,     -0.553116629759706_REALK,      0.000000000000000_REALK, &
     -0.057615070396835_REALK,      0.000000000000000_REALK,     -0.055127651478385_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.041906139295045_REALK, &
      0.000000000000000_REALK,      0.045801047920528_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.035762121578552_REALK,      0.000000000000000_REALK, &
      0.039028904638754_REALK,      0.000000000000000_REALK,      0.087478018472367_REALK, &
      0.000000000000000_REALK,      0.084500107869256_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.006474475498493_REALK, &
      0.000000000000000_REALK,      0.018891833548309_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.008459391503244_REALK,      0.000000000000000_REALK, &
      0.035268627531124_REALK,      0.000000000000000_REALK,     -0.032455244979200_REALK, &
      0.000000000000000_REALK,      0.054721934505243_REALK,      0.000000000000000_REALK, &
     -0.060736325914164_REALK,     -0.054583101904851_REALK,      0.000000000000000_REALK, &
     -0.065012714929073_REALK,      0.000000000000000_REALK,     -0.046878458269289_REALK, &
     -0.089437509836096_REALK,      0.000000000000000_REALK,     -0.051244160003990_REALK, &
      0.000000000000000_REALK,     -0.273868035402391_REALK,      0.000000000000000_REALK, &
     -0.122024123653209_REALK,      0.000000000000000_REALK,     -0.146269074958504_REALK, &
      0.141791212305648_REALK,     -0.027125589458374_REALK,      0.000000000000000_REALK, &
     -0.122996502144537_REALK,      0.000000000000000_REALK,     -0.074490007282795_REALK, &
     -0.232761883200759_REALK,      0.000000000000000_REALK,     -0.112485045253561_REALK, &
      0.000000000000000_REALK,     -0.762793050879167_REALK,      0.000000000000000_REALK, &
     -0.297788123043355_REALK,      0.000000000000000_REALK,     -0.303492453449855_REALK, &
     -0.079919515278951_REALK,     -0.204251978090275_REALK,      0.000000000000000_REALK, &
     -0.025054438907675_REALK,      0.000000000000000_REALK,     -0.016161530972877_REALK, &
     -0.113687239202425_REALK,      0.000000000000000_REALK,     -0.051625773514569_REALK, &
      0.000000000000000_REALK,     -0.014414535794402_REALK,      0.000000000000000_REALK, &
     -0.011167008082320_REALK,      0.000000000000000_REALK,     -0.021877383411306_REALK, &
     -0.252376169357753_REALK,     -0.320181467902892_REALK,      0.000000000000000_REALK, &
      0.020722712553322_REALK,      0.000000000000000_REALK,     -0.015054867180968_REALK, &
      0.003658182592383_REALK,      0.000000000000000_REALK,     -0.038577644687914_REALK, &
      0.000000000000000_REALK,      0.311954407064421_REALK,      0.000000000000000_REALK, &
      0.011487630353726_REALK,      0.000000000000000_REALK,     -0.012765957549967_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.031162637693219_REALK, &
      0.000000000000000_REALK,      0.037997556406656_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.018370779363718_REALK,      0.000000000000000_REALK, &
      0.023859008815408_REALK,      0.000000000000000_REALK,      0.045426065778585_REALK, &
      0.000000000000000_REALK,      0.051757064967142_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.073625047968373_REALK, &
      0.000000000000000_REALK,      0.057090760329389_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.033787203606103_REALK,      0.000000000000000_REALK, &
      0.033840567801616_REALK,      0.000000000000000_REALK,      0.082258792953792_REALK, &
      0.000000000000000_REALK,      0.056120559569957_REALK,      0.000000000000000_REALK, &
     -0.045702450886658_REALK,     -0.036671142686387_REALK,      0.000000000000000_REALK, &
     -0.025859200715580_REALK,      0.000000000000000_REALK,     -0.028182367393886_REALK, &
     -0.029341519561896_REALK,      0.000000000000000_REALK,     -0.028181489229820_REALK, &
      0.000000000000000_REALK,     -0.045025234380772_REALK,      0.000000000000000_REALK, &
     -0.035490300783053_REALK,      0.000000000000000_REALK,     -0.064751948373457_REALK, &
     -0.205701026440564_REALK,     -0.080632543374689_REALK,      0.000000000000000_REALK, &
     -0.019969202770231_REALK,      0.000000000000000_REALK,     -0.053751455711368_REALK, &
      0.011775446352068_REALK,      0.000000000000000_REALK,     -0.035086106666279_REALK, &
      0.000000000000000_REALK,      0.116505834203749_REALK,      0.000000000000000_REALK, &
     -0.013416216772598_REALK,      0.000000000000000_REALK,     -0.089214945232093_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.037116589337576_REALK, &
      0.000000000000000_REALK,      0.036853510943175_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.040030977727934_REALK,      0.000000000000000_REALK, &
      0.048103503862722_REALK,      0.000000000000000_REALK,      0.089986095237975_REALK, &
      0.000000000000000_REALK,      0.085747298289804_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.192212094657154_REALK, &
      0.000000000000000_REALK,      0.152751260200984_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.170281668977478_REALK,      0.000000000000000_REALK, &
      0.175109468129459_REALK,      0.000000000000000_REALK,      0.349001936611866_REALK, &
      0.000000000000000_REALK,      0.281358049611614_REALK,      0.000000000000000_REALK, &
      0.110633316129010_REALK,     -0.335714291506692_REALK,      0.000000000000000_REALK, &
      0.057313380359099_REALK,      0.000000000000000_REALK,      0.018508341134169_REALK, &
     -0.155599946268827_REALK,      0.000000000000000_REALK,     -0.068620423515444_REALK, &
      0.000000000000000_REALK,      0.086706531502322_REALK,      0.000000000000000_REALK, &
      0.018884057781220_REALK,      0.000000000000000_REALK,      0.018343505655806_REALK, &
     -0.184539162063021_REALK,      0.057374039048179_REALK,      0.000000000000000_REALK, &
      0.011833959441221_REALK,      0.000000000000000_REALK,      0.013948259325383_REALK, &
     -0.182978361150382_REALK,      0.000000000000000_REALK,     -0.055985362375676_REALK, &
      0.000000000000000_REALK,     -0.171160168080241_REALK,      0.000000000000000_REALK, &
      0.008326025123473_REALK,      0.000000000000000_REALK,      0.020328323202530_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.016454344515485_REALK, &
      0.000000000000000_REALK,      0.043762236102429_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.005236823608236_REALK,      0.000000000000000_REALK, &
      0.010151292859775_REALK,      0.000000000000000_REALK,      0.031585254250348_REALK, &
      0.000000000000000_REALK,      0.043142742665738_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.002624951267085_REALK, &
      0.000000000000000_REALK,      0.023572523161732_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.007863587698961_REALK,      0.000000000000000_REALK, &
      0.008430826319323_REALK,      0.000000000000000_REALK,     -0.006657280426146_REALK, &
      0.000000000000000_REALK,      0.036740617690561_REALK,      0.000000000000000_REALK, &
     -0.039864875664922_REALK,     -0.038541001626405_REALK,      0.000000000000000_REALK, &
     -0.015500214365250_REALK,      0.000000000000000_REALK,     -0.020102807801183_REALK, &
     -0.020988887193462_REALK,      0.000000000000000_REALK,     -0.023887563458691_REALK, &
      0.000000000000000_REALK,     -0.019838668044073_REALK,      0.000000000000000_REALK, &
     -0.015427553932946_REALK,      0.000000000000000_REALK,     -0.033441594439188_REALK, &
      0.066023787162147_REALK,     -0.008510472938742_REALK,      0.000000000000000_REALK, &
     -0.027221350371814_REALK,      0.000000000000000_REALK,     -0.025566470942668_REALK, &
     -0.055101430965610_REALK,      0.000000000000000_REALK,     -0.037566992054703_REALK, &
      0.000000000000000_REALK,     -0.113012870019781_REALK,      0.000000000000000_REALK, &
     -0.035799994914087_REALK,      0.000000000000000_REALK,     -0.057777098425671_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.028375565673704_REALK, &
      0.000000000000000_REALK,      0.023688998487153_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.016274836879889_REALK,      0.000000000000000_REALK, &
      0.029578165178041_REALK,      0.000000000000000_REALK,      0.024653275723887_REALK, &
      0.000000000000000_REALK,      0.039596542489673_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.011745974281013_REALK, &
      0.000000000000000_REALK,      0.025147029552169_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.009070458968569_REALK,      0.000000000000000_REALK, &
      0.060422812182788_REALK,      0.000000000000000_REALK,     -0.018388959985547_REALK, &
      0.000000000000000_REALK,      0.058084767995480_REALK,      0.000000000000000_REALK, &
     -0.047084518746205_REALK,     -0.036819861642595_REALK,      0.000000000000000_REALK, &
     -0.033354989613135_REALK,      0.000000000000000_REALK,     -0.040133632749415_REALK, &
     -0.040546618427569_REALK,      0.000000000000000_REALK,     -0.038742287575039_REALK, &
      0.000000000000000_REALK,     -0.076415893552527_REALK,      0.000000000000000_REALK, &
     -0.056793539916511_REALK,      0.000000000000000_REALK,     -0.095405507290579_REALK, &
      0.086453199472478_REALK,     -0.070141265934449_REALK,      0.000000000000000_REALK, &
     -0.147434707407277_REALK,      0.000000000000000_REALK,     -0.149642030308446_REALK, &
     -0.236931706503886_REALK,      0.000000000000000_REALK,     -0.191026523747579_REALK, &
      0.000000000000000_REALK,     -0.472067006644006_REALK,      0.000000000000000_REALK, &
     -0.307674244191591_REALK,      0.000000000000000_REALK,     -0.439948665280667_REALK, &
      1.011978361110829_REALK,     -0.887670897557748_REALK,      0.000000000000000_REALK, &
      0.293319524220728_REALK,      0.000000000000000_REALK,      0.115873812755065_REALK, &
     -0.319817634424386_REALK,      0.000000000000000_REALK,     -0.127649804338713_REALK, &
      0.000000000000000_REALK,      0.268342445912743_REALK,      0.000000000000000_REALK, &
      0.063904964141122_REALK,      0.000000000000000_REALK,      0.075928582089675_REALK, &
      5.182516488076624_REALK,     -2.943489100239491_REALK,      0.000000000000000_REALK, &
      0.982881432669403_REALK,      0.000000000000000_REALK,      0.385615203472116_REALK, &
     -0.486840680977494_REALK,      0.000000000000000_REALK,     -0.267798641991750_REALK, &
      0.000000000000000_REALK,      0.813280039363407_REALK,      0.000000000000000_REALK, &
      0.130766788404633_REALK,      0.000000000000000_REALK,      0.151787655575476_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.028188458827500_REALK, &
      0.000000000000000_REALK,      0.079717307251889_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.012794525535448_REALK,      0.000000000000000_REALK, &
     -0.012394278710649_REALK,      0.000000000000000_REALK,      0.039376797907844_REALK, &
      0.000000000000000_REALK,      0.052128859827905_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.148645892485747_REALK, &
      0.000000000000000_REALK,      0.259721430246348_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.023352461649666_REALK,      0.000000000000000_REALK, &
     -0.043308807913624_REALK,      0.000000000000000_REALK,      0.106238696923300_REALK, &
      0.000000000000000_REALK,      0.102514551566288_REALK,      0.000000000000000_REALK, &
     -0.033769519907500_REALK,     -0.067075907900907_REALK,      0.000000000000000_REALK, &
     -0.006102705402255_REALK,      0.000000000000000_REALK,     -0.011699756407441_REALK, &
     -0.021574522096407_REALK,      0.000000000000000_REALK,     -0.029313159313362_REALK, &
      0.000000000000000_REALK,     -0.001783875791570_REALK,      0.000000000000000_REALK, &
     -0.003972462335398_REALK,      0.000000000000000_REALK,     -0.012883714380401_REALK, &
     -0.181852316815690_REALK,     -0.287418468638657_REALK,      0.000000000000000_REALK, &
      0.018926610993232_REALK,      0.000000000000000_REALK,     -0.040492222793592_REALK, &
     -0.002609285088520_REALK,      0.000000000000000_REALK,     -0.081189058721715_REALK, &
      0.000000000000000_REALK,      0.109372988048641_REALK,      0.000000000000000_REALK, &
      0.011203690914417_REALK,      0.000000000000000_REALK,     -0.026035577733707_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.030362175639064_REALK, &
      0.000000000000000_REALK,      0.027374386852327_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.010378061285165_REALK,      0.000000000000000_REALK, &
      0.022430008293142_REALK,      0.000000000000000_REALK,      0.016008368672559_REALK, &
      0.000000000000000_REALK,      0.030376678479945_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.226759505419466_REALK, &
      0.000000000000000_REALK,      0.154879313594782_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.067818708726872_REALK,      0.000000000000000_REALK, &
      0.115709620873509_REALK,      0.000000000000000_REALK,      0.091433818706934_REALK, &
      0.000000000000000_REALK,      0.108292117659077_REALK,      0.000000000000000_REALK, &
     -0.056784313831739_REALK,     -0.035575611415206_REALK,      0.000000000000000_REALK, &
     -0.018513151390918_REALK,      0.000000000000000_REALK,     -0.033520667971432_REALK, &
     -0.016557662156063_REALK,      0.000000000000000_REALK,     -0.026426301130322_REALK, &
      0.000000000000000_REALK,     -0.015900530940917_REALK,      0.000000000000000_REALK, &
     -0.020743640484978_REALK,      0.000000000000000_REALK,     -0.052858957439755_REALK, &
     -0.601465942076740_REALK,     -0.248039625283321_REALK,      0.000000000000000_REALK, &
     -0.056644276823868_REALK,      0.000000000000000_REALK,     -0.247274667086382_REALK, &
      0.016936952198172_REALK,      0.000000000000000_REALK,     -0.122535089934113_REALK, &
      0.000000000000000_REALK,      0.118786047110674_REALK,      0.000000000000000_REALK, &
     -0.031558640692135_REALK,      0.000000000000000_REALK,     -0.242278463230329_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.059244544618263_REALK, &
      0.000000000000000_REALK,      0.043426095400780_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.037195223121682_REALK,      0.000000000000000_REALK, &
      0.062658554821448_REALK,      0.000000000000000_REALK,      0.052030194784605_REALK, &
      0.000000000000000_REALK,      0.069527247531444_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.071420513679591_REALK, &
      0.000000000000000_REALK,      0.698172443372275_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.565955928175870_REALK,      0.000000000000000_REALK, &
      0.818407014674888_REALK,      0.000000000000000_REALK,      0.644877735266676_REALK, &
      0.000000000000000_REALK,      0.732044062180683_REALK,      0.000000000000000_REALK/
  ! results of test 6, ket-major order, NEF 009
  data REF_CONTR_INTS(13861:15120)                                                         &
     /0.000000000000000_REALK,      0.000000000000000_REALK,     -0.120986130714317_REALK, &
      0.000000000000000_REALK,     -0.110546747074411_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.133426985626123_REALK,      0.000000000000000_REALK, &
     -0.064730968136354_REALK,      0.000000000000000_REALK,     -0.217556888826189_REALK, &
      0.000000000000000_REALK,     -0.079601550501254_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.011088897903795_REALK, &
      0.000000000000000_REALK,     -0.110199560981410_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.189184873998332_REALK,      0.000000000000000_REALK, &
     -0.070542966570193_REALK,      0.000000000000000_REALK,     -0.348128607996363_REALK, &
      0.000000000000000_REALK,     -0.104303672276780_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.092181857432987_REALK, &
      0.000000000000000_REALK,     -0.061041454723181_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.055089688623789_REALK,      0.000000000000000_REALK, &
     -0.042063007898083_REALK,      0.000000000000000_REALK,     -0.063790975055864_REALK, &
      0.000000000000000_REALK,     -0.036088866513759_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.164745990510300_REALK, &
      0.000000000000000_REALK,     -0.070039927210035_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.041393353337012_REALK,      0.000000000000000_REALK, &
     -0.040196431432071_REALK,      0.000000000000000_REALK,     -0.022115430217405_REALK, &
      0.000000000000000_REALK,     -0.028854526995485_REALK,      0.000000000000000_REALK, &
      0.130389583484098_REALK,      0.102453907785196_REALK,      0.000000000000000_REALK, &
      0.103881181430328_REALK,      0.000000000000000_REALK,      0.050523676020143_REALK, &
      0.128653823890309_REALK,      0.000000000000000_REALK,      0.047176622636164_REALK, &
      0.000000000000000_REALK,      0.204273850582463_REALK,      0.000000000000000_REALK, &
      0.062073228501068_REALK,      0.000000000000000_REALK,      0.050119559102157_REALK, &
      0.628164568508621_REALK,      0.330216651367461_REALK,      0.000000000000000_REALK, &
      0.270966549005705_REALK,      0.000000000000000_REALK,      0.104466561576533_REALK, &
      0.314893747102347_REALK,      0.000000000000000_REALK,      0.095310347891983_REALK, &
      0.000000000000000_REALK,      0.491251041372367_REALK,      0.000000000000000_REALK, &
      0.125703074910157_REALK,      0.000000000000000_REALK,      0.078913952093499_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.093405614919061_REALK, &
      0.000000000000000_REALK,     -0.047843379530943_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.035963828474814_REALK,      0.000000000000000_REALK, &
     -0.036495389823368_REALK,      0.000000000000000_REALK,     -0.034507283420340_REALK, &
      0.000000000000000_REALK,     -0.023319115833420_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.009174561390297_REALK, &
      0.000000000000000_REALK,     -0.028675947321678_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.034451029705711_REALK,      0.000000000000000_REALK, &
     -0.027973024846728_REALK,      0.000000000000000_REALK,     -0.043448495602638_REALK, &
      0.000000000000000_REALK,     -0.021448410803314_REALK,      0.000000000000000_REALK, &
      0.112955203511961_REALK,      0.065428379681205_REALK,      0.000000000000000_REALK, &
      0.050079974261640_REALK,      0.000000000000000_REALK,      0.038258186968941_REALK, &
      0.045467179602946_REALK,      0.000000000000000_REALK,      0.025695889378100_REALK, &
      0.000000000000000_REALK,      0.050089371456029_REALK,      0.000000000000000_REALK, &
      0.024519726833532_REALK,      0.000000000000000_REALK,      0.031195337250586_REALK, &
     -0.178285531084856_REALK,     -0.001308865176325_REALK,      0.000000000000000_REALK, &
      0.024541297215439_REALK,      0.000000000000000_REALK,      0.026710858166775_REALK, &
      0.016601002928358_REALK,      0.000000000000000_REALK,      0.023832104981634_REALK, &
      0.000000000000000_REALK,     -0.013471046842826_REALK,      0.000000000000000_REALK, &
      0.019345915587107_REALK,      0.000000000000000_REALK,      0.032398298914413_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.053940096825049_REALK, &
      0.000000000000000_REALK,     -0.042626262947544_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.043836895084084_REALK,      0.000000000000000_REALK, &
     -0.035502018369347_REALK,      0.000000000000000_REALK,     -0.057484606855113_REALK, &
      0.000000000000000_REALK,     -0.035099934365033_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.027167825227970_REALK, &
      0.000000000000000_REALK,     -0.075211317117420_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.108199801367071_REALK,      0.000000000000000_REALK, &
     -0.067412792408463_REALK,      0.000000000000000_REALK,     -0.161760940562958_REALK, &
      0.000000000000000_REALK,     -0.080899908825516_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.120634803342018_REALK, &
      0.000000000000000_REALK,     -0.046000890726718_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.028329991467745_REALK,      0.000000000000000_REALK, &
     -0.038977889255175_REALK,      0.000000000000000_REALK,     -0.021174428333942_REALK, &
      0.000000000000000_REALK,     -0.018144786162169_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.256280495578256_REALK, &
      0.000000000000000_REALK,     -0.069368029287374_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.028568198336878_REALK,      0.000000000000000_REALK, &
     -0.047197356476415_REALK,      0.000000000000000_REALK,     -0.009569380161925_REALK, &
      0.000000000000000_REALK,     -0.018187118257073_REALK,      0.000000000000000_REALK, &
      0.143204711708694_REALK,      0.062568383682513_REALK,      0.000000000000000_REALK, &
      0.039488982830349_REALK,      0.000000000000000_REALK,      0.040123054384072_REALK, &
      0.030091784530281_REALK,      0.000000000000000_REALK,      0.020346415663043_REALK, &
      0.000000000000000_REALK,      0.028843486336313_REALK,      0.000000000000000_REALK, &
      0.015664661833131_REALK,      0.000000000000000_REALK,      0.026485187820261_REALK, &
      0.573304733412881_REALK,      0.180515509415345_REALK,      0.000000000000000_REALK, &
      0.092605212196801_REALK,      0.000000000000000_REALK,      0.079312743354461_REALK, &
      0.069809200399909_REALK,      0.000000000000000_REALK,      0.035872114484399_REALK, &
      0.000000000000000_REALK,      0.078124048770132_REALK,      0.000000000000000_REALK, &
      0.026195149686584_REALK,      0.000000000000000_REALK,      0.036318591533277_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.049853831172286_REALK, &
      0.000000000000000_REALK,     -0.028100521352046_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.021307192768633_REALK,      0.000000000000000_REALK, &
     -0.027127529182993_REALK,      0.000000000000000_REALK,     -0.019818310707801_REALK, &
      0.000000000000000_REALK,     -0.018673175127472_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.161058878273054_REALK, &
      0.000000000000000_REALK,     -0.066074039347768_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.033740621396512_REALK,      0.000000000000000_REALK, &
     -0.053971436853787_REALK,      0.000000000000000_REALK,     -0.014908816070563_REALK, &
      0.000000000000000_REALK,     -0.030555965806287_REALK,      0.000000000000000_REALK, &
      0.081541092215629_REALK,      0.055046854980664_REALK,      0.000000000000000_REALK, &
      0.047526044682082_REALK,      0.000000000000000_REALK,      0.038613378671963_REALK, &
      0.049433514028264_REALK,      0.000000000000000_REALK,      0.030258710627741_REALK, &
      0.000000000000000_REALK,      0.062966497443557_REALK,      0.000000000000000_REALK, &
      0.031932866599181_REALK,      0.000000000000000_REALK,      0.036173774596059_REALK, &
      0.624917067771947_REALK,      0.343838910047406_REALK,      0.000000000000000_REALK, &
      0.258389132797418_REALK,      0.000000000000000_REALK,      0.165664263077798_REALK, &
      0.250102700338636_REALK,      0.000000000000000_REALK,      0.126496000877934_REALK, &
      0.000000000000000_REALK,      0.303989909560324_REALK,      0.000000000000000_REALK, &
      0.130027015397657_REALK,      0.000000000000000_REALK,      0.114786542630844_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.186762386538989_REALK, &
      0.000000000000000_REALK,     -0.053458620379247_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.028302682828235_REALK,      0.000000000000000_REALK, &
     -0.051003281298439_REALK,      0.000000000000000_REALK,     -0.017061517269845_REALK, &
      0.000000000000000_REALK,     -0.017133922868837_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.019260416659481_REALK, &
      0.000000000000000_REALK,     -0.032158225169054_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.028476962274283_REALK,      0.000000000000000_REALK, &
     -0.044495898824666_REALK,      0.000000000000000_REALK,     -0.025402105259374_REALK, &
      0.000000000000000_REALK,     -0.018392763310907_REALK,      0.000000000000000_REALK, &
      0.213978615505123_REALK,      0.072322859771557_REALK,      0.000000000000000_REALK, &
      0.038157364860835_REALK,      0.000000000000000_REALK,      0.052510218057461_REALK, &
      0.023177300103341_REALK,      0.000000000000000_REALK,      0.019834340513758_REALK, &
      0.000000000000000_REALK,      0.017279240868493_REALK,      0.000000000000000_REALK, &
      0.012272642544450_REALK,      0.000000000000000_REALK,      0.028140578125896_REALK, &
     -0.283797786146578_REALK,     -0.002045734269121_REALK,      0.000000000000000_REALK, &
      0.019968236008414_REALK,      0.000000000000000_REALK,      0.037555039931658_REALK, &
      0.009103939563758_REALK,      0.000000000000000_REALK,      0.021126381281279_REALK, &
      0.000000000000000_REALK,     -0.010943684383030_REALK,      0.000000000000000_REALK, &
      0.012046983386390_REALK,      0.000000000000000_REALK,      0.034523587081384_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.062928829554878_REALK, &
      0.000000000000000_REALK,     -0.027281031274609_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.017042748467007_REALK,      0.000000000000000_REALK, &
     -0.028852955330516_REALK,      0.000000000000000_REALK,     -0.013052126208062_REALK, &
      0.000000000000000_REALK,     -0.014706766424673_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.011691685429661_REALK, &
      0.000000000000000_REALK,     -0.032908078158820_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.032128904216986_REALK,      0.000000000000000_REALK, &
     -0.043705457620812_REALK,      0.000000000000000_REALK,     -0.033112298998334_REALK, &
      0.000000000000000_REALK,     -0.027437617455144_REALK,      0.000000000000000_REALK, &
      0.088112487488995_REALK,      0.043896048467262_REALK,      0.000000000000000_REALK, &
      0.028464638129256_REALK,      0.000000000000000_REALK,      0.036263806829736_REALK, &
      0.021494699050593_REALK,      0.000000000000000_REALK,      0.020229833881578_REALK, &
      0.000000000000000_REALK,      0.018935805853840_REALK,      0.000000000000000_REALK, &
      0.015415144722995_REALK,      0.000000000000000_REALK,      0.027471953322029_REALK, &
     -0.128876707367116_REALK,      0.013226399758615_REALK,      0.000000000000000_REALK, &
      0.028492847928360_REALK,      0.000000000000000_REALK,      0.050462100699608_REALK, &
      0.016057369317249_REALK,      0.000000000000000_REALK,      0.037155581644512_REALK, &
      0.000000000000000_REALK,     -0.009135729869275_REALK,      0.000000000000000_REALK, &
      0.024990234989628_REALK,      0.000000000000000_REALK,      0.058069343209800_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.060052976578182_REALK, &
      0.000000000000000_REALK,     -0.040131805278771_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.034272296410740_REALK,      0.000000000000000_REALK, &
     -0.038958743045912_REALK,      0.000000000000000_REALK,     -0.035846340917816_REALK, &
      0.000000000000000_REALK,     -0.030701824962977_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.076056727505408_REALK, &
      0.000000000000000_REALK,     -0.136698182947857_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.166631015375253_REALK,      0.000000000000000_REALK, &
     -0.145668978935541_REALK,      0.000000000000000_REALK,     -0.204706826286663_REALK, &
      0.000000000000000_REALK,     -0.143596756107020_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.472241858935862_REALK, &
      0.000000000000000_REALK,     -0.089565710773335_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.039538329495090_REALK,      0.000000000000000_REALK, &
     -0.092842481698955_REALK,      0.000000000000000_REALK,     -0.017486564003970_REALK, &
      0.000000000000000_REALK,     -0.020785886440519_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.806500843886805_REALK, &
      0.000000000000000_REALK,     -0.290306930092985_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.091925984081103_REALK,      0.000000000000000_REALK, &
     -0.255513866933347_REALK,      0.000000000000000_REALK,     -0.018178166047370_REALK, &
      0.000000000000000_REALK,     -0.047049467784742_REALK,      0.000000000000000_REALK, &
      0.599610382395013_REALK,      0.136632654325196_REALK,      0.000000000000000_REALK, &
      0.057618597907317_REALK,      0.000000000000000_REALK,      0.103862526422793_REALK, &
      0.026988997052019_REALK,      0.000000000000000_REALK,      0.027067371518457_REALK, &
      0.000000000000000_REALK,      0.016620969377409_REALK,      0.000000000000000_REALK, &
      0.013438393276154_REALK,      0.000000000000000_REALK,      0.040363601851598_REALK, &
      3.211645453974452_REALK,      0.665306373410382_REALK,      0.000000000000000_REALK, &
      0.249727560868024_REALK,      0.000000000000000_REALK,      0.410082259680663_REALK, &
      0.123482852932572_REALK,      0.000000000000000_REALK,      0.096457953472186_REALK, &
      0.000000000000000_REALK,      0.097100821262810_REALK,      0.000000000000000_REALK, &
      0.041877408935296_REALK,      0.000000000000000_REALK,      0.112961072456375_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.133323590249765_REALK, &
      0.000000000000000_REALK,     -0.040025301399494_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.019280889476541_REALK,      0.000000000000000_REALK, &
     -0.044233220884414_REALK,      0.000000000000000_REALK,     -0.010992947952754_REALK, &
      0.000000000000000_REALK,     -0.015674149436499_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.735983010180235_REALK, &
      0.000000000000000_REALK,     -0.188854558018725_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.066126570383725_REALK,      0.000000000000000_REALK, &
     -0.179083916340340_REALK,      0.000000000000000_REALK,     -0.018650989786075_REALK, &
      0.000000000000000_REALK,     -0.052431435795303_REALK,      0.000000000000000_REALK, &
      0.197660474725632_REALK,      0.068446094654151_REALK,      0.000000000000000_REALK, &
      0.034094517480762_REALK,      0.000000000000000_REALK,      0.057861962681485_REALK, &
      0.020313790226899_REALK,      0.000000000000000_REALK,      0.022908604955515_REALK, &
      0.000000000000000_REALK,      0.014841690441942_REALK,      0.000000000000000_REALK, &
      0.013450766691120_REALK,      0.000000000000000_REALK,      0.031892078131169_REALK, &
      1.633162432430162_REALK,      0.537598413239324_REALK,      0.000000000000000_REALK, &
      0.252878518182790_REALK,      0.000000000000000_REALK,      0.361318711005118_REALK, &
      0.154549631088374_REALK,      0.000000000000000_REALK,      0.134519126991613_REALK, &
      0.000000000000000_REALK,      0.126652320365507_REALK,      0.000000000000000_REALK, &
      0.072968804192713_REALK,      0.000000000000000_REALK,      0.143719436929372_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.090325124851868_REALK, &
      0.000000000000000_REALK,     -0.040153606024383_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.023845223552063_REALK,      0.000000000000000_REALK, &
     -0.042552966465747_REALK,      0.000000000000000_REALK,     -0.016947841409630_REALK, &
      0.000000000000000_REALK,     -0.022326977558824_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.808174357609801_REALK, &
      0.000000000000000_REALK,     -0.303508297603083_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.129250883691337_REALK,      0.000000000000000_REALK, &
     -0.283933205578585_REALK,      0.000000000000000_REALK,     -0.046457363360140_REALK, &
      0.000000000000000_REALK,     -0.121087081879580_REALK,      0.000000000000000_REALK, &
      0.183400571272394_REALK,      0.098176647215010_REALK,      0.000000000000000_REALK, &
      0.066936180167221_REALK,      0.000000000000000_REALK,      0.076548998006200_REALK, &
      0.054518708095563_REALK,      0.000000000000000_REALK,      0.046882632514018_REALK, &
      0.000000000000000_REALK,      0.053020216243764_REALK,      0.000000000000000_REALK, &
      0.037745294331981_REALK,      0.000000000000000_REALK,      0.055209013272987_REALK, &
      3.266439875519326_REALK,      1.779861587483093_REALK,      0.000000000000000_REALK, &
      1.180450002401083_REALK,      0.000000000000000_REALK,      1.060750282431790_REALK, &
      0.913770100025630_REALK,      0.000000000000000_REALK,      0.650175870387458_REALK, &
      0.000000000000000_REALK,      0.819559519479399_REALK,      0.000000000000000_REALK, &
      0.493517010085538_REALK,      0.000000000000000_REALK,      0.564847714310062_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.139117010684075_REALK, &
      0.000000000000000_REALK,     -0.137431601062016_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.124245933266991_REALK,      0.000000000000000_REALK, &
     -0.172793988402010_REALK,      0.000000000000000_REALK,     -0.581539540587833_REALK, &
      0.000000000000000_REALK,     -0.417966144967906_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.081142211445492_REALK, &
      0.000000000000000_REALK,     -0.105664539323410_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.137760711046961_REALK,      0.000000000000000_REALK, &
     -0.142465450811149_REALK,      0.000000000000000_REALK,     -0.760098381475959_REALK, &
      0.000000000000000_REALK,     -0.464062057397886_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.147242440983510_REALK, &
      0.000000000000000_REALK,     -0.067338099185273_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.068067520071369_REALK,      0.000000000000000_REALK, &
     -0.159203069479764_REALK,      0.000000000000000_REALK,     -0.147889562365821_REALK, &
      0.000000000000000_REALK,     -0.162113961073442_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.246954384578895_REALK, &
      0.000000000000000_REALK,     -0.056125884018223_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.039005886875760_REALK,      0.000000000000000_REALK, &
     -0.123499987906661_REALK,      0.000000000000000_REALK,     -0.024034991409248_REALK, &
      0.000000000000000_REALK,     -0.106604157771621_REALK,      0.000000000000000_REALK, &
      0.133553263939285_REALK,      0.063881325378740_REALK,      0.000000000000000_REALK, &
      0.088534935769809_REALK,      0.000000000000000_REALK,      0.122852645722512_REALK, &
      0.096684939810567_REALK,      0.000000000000000_REALK,      0.069710885277165_REALK, &
      0.000000000000000_REALK,      0.377247645709308_REALK,      0.000000000000000_REALK, &
      0.215485729746964_REALK,      0.000000000000000_REALK,      0.496013962631589_REALK, &
      0.617660864926283_REALK,      0.168462510434431_REALK,      0.000000000000000_REALK, &
      0.156125837540314_REALK,      0.000000000000000_REALK,      0.167287982556690_REALK, &
      0.188545264809742_REALK,      0.000000000000000_REALK,      0.116336611761522_REALK, &
      0.000000000000000_REALK,      0.710482989386802_REALK,      0.000000000000000_REALK, &
      0.342788256542079_REALK,      0.000000000000000_REALK,      0.590320695750605_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.180698211321095_REALK, &
      0.000000000000000_REALK,     -0.038784831905203_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.052404294720152_REALK,      0.000000000000000_REALK, &
     -0.167186075488919_REALK,      0.000000000000000_REALK,     -0.054720229087485_REALK, &
      0.000000000000000_REALK,     -0.071241252074410_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.059295103162775_REALK, &
      0.000000000000000_REALK,     -0.019552373053807_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.036369788415992_REALK,      0.000000000000000_REALK, &
     -0.112728149826849_REALK,      0.000000000000000_REALK,     -0.057615070396835_REALK, &
      0.000000000000000_REALK,     -0.055127651478385_REALK,      0.000000000000000_REALK, &
      0.140255221931008_REALK,      0.041906139295045_REALK,      0.000000000000000_REALK, &
      0.045801047920528_REALK,      0.000000000000000_REALK,      0.107127416337666_REALK, &
      0.035762121578552_REALK,      0.000000000000000_REALK,      0.039028904638754_REALK, &
      0.000000000000000_REALK,      0.087478018472367_REALK,      0.000000000000000_REALK, &
      0.084500107869256_REALK,      0.000000000000000_REALK,      0.329602055014576_REALK, &
     -0.331897019813339_REALK,     -0.006474475498493_REALK,      0.000000000000000_REALK, &
      0.018891833548309_REALK,      0.000000000000000_REALK,      0.067640605219791_REALK, &
      0.008459391503244_REALK,      0.000000000000000_REALK,      0.035268627531124_REALK, &
      0.000000000000000_REALK,     -0.032455244979200_REALK,      0.000000000000000_REALK, &
      0.054721934505243_REALK,      0.000000000000000_REALK,      0.303861960562168_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.076048808368816_REALK, &
      0.000000000000000_REALK,     -0.046878458269289_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.051244160003990_REALK,      0.000000000000000_REALK, &
     -0.118582460740525_REALK,      0.000000000000000_REALK,     -0.122024123653209_REALK, &
      0.000000000000000_REALK,     -0.146269074958504_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.016276349452101_REALK, &
      0.000000000000000_REALK,     -0.074490007282795_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.112485045253561_REALK,      0.000000000000000_REALK, &
     -0.194088836704478_REALK,      0.000000000000000_REALK,     -0.297788123043355_REALK, &
      0.000000000000000_REALK,     -0.303492453449855_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.262283961338198_REALK, &
      0.000000000000000_REALK,     -0.016161530972877_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.051625773514569_REALK,      0.000000000000000_REALK, &
     -0.199396114183932_REALK,      0.000000000000000_REALK,     -0.011167008082320_REALK, &
      0.000000000000000_REALK,     -0.021877383411306_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.478327700149935_REALK, &
      0.000000000000000_REALK,     -0.015054867180968_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.038577644687914_REALK,      0.000000000000000_REALK, &
     -0.192298573624629_REALK,      0.000000000000000_REALK,      0.011487630353726_REALK, &
      0.000000000000000_REALK,     -0.012765957549967_REALK,      0.000000000000000_REALK, &
      0.198293534250069_REALK,      0.031162637693219_REALK,      0.000000000000000_REALK, &
      0.037997556406656_REALK,      0.000000000000000_REALK,      0.121152072073547_REALK, &
      0.018370779363718_REALK,      0.000000000000000_REALK,      0.023859008815408_REALK, &
      0.000000000000000_REALK,      0.045426065778585_REALK,      0.000000000000000_REALK, &
      0.051757064967142_REALK,      0.000000000000000_REALK,      0.275516108720126_REALK, &
      0.772152352736019_REALK,      0.073625047968373_REALK,      0.000000000000000_REALK, &
      0.057090760329389_REALK,      0.000000000000000_REALK,      0.179334761224034_REALK, &
      0.033787203606103_REALK,      0.000000000000000_REALK,      0.033840567801616_REALK, &
      0.000000000000000_REALK,      0.082258792953792_REALK,      0.000000000000000_REALK, &
      0.056120559569957_REALK,      0.000000000000000_REALK,      0.289459396616401_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.085740792305618_REALK, &
      0.000000000000000_REALK,     -0.028182367393886_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.028181489229820_REALK,      0.000000000000000_REALK, &
     -0.109860475291318_REALK,      0.000000000000000_REALK,     -0.035490300783053_REALK, &
      0.000000000000000_REALK,     -0.064751948373457_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.233394583180771_REALK, &
      0.000000000000000_REALK,     -0.053751455711368_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.035086106666279_REALK,      0.000000000000000_REALK, &
     -0.185203001491822_REALK,      0.000000000000000_REALK,     -0.013416216772598_REALK, &
      0.000000000000000_REALK,     -0.089214945232093_REALK,      0.000000000000000_REALK, &
      0.082623787186710_REALK,      0.037116589337576_REALK,      0.000000000000000_REALK, &
      0.036853510943175_REALK,      0.000000000000000_REALK,      0.085430959059058_REALK, &
      0.040030977727934_REALK,      0.000000000000000_REALK,      0.048103503862722_REALK, &
      0.000000000000000_REALK,      0.089986095237975_REALK,      0.000000000000000_REALK, &
      0.085747298289804_REALK,      0.000000000000000_REALK,      0.276773581481627_REALK, &
      0.533402598243831_REALK,      0.192212094657154_REALK,      0.000000000000000_REALK, &
      0.152751260200984_REALK,      0.000000000000000_REALK,      0.271261425535933_REALK, &
      0.170281668977477_REALK,      0.000000000000000_REALK,      0.175109468129459_REALK, &
      0.000000000000000_REALK,      0.349001936611866_REALK,      0.000000000000000_REALK, &
      0.281358049611614_REALK,      0.000000000000000_REALK,      0.681497198539149_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.447310204739011_REALK, &
      0.000000000000000_REALK,      0.018508341134169_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.068620423515444_REALK,      0.000000000000000_REALK, &
     -0.274897731740291_REALK,      0.000000000000000_REALK,      0.018884057781220_REALK, &
      0.000000000000000_REALK,      0.018343505655806_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.062440619984398_REALK, &
      0.000000000000000_REALK,      0.013948259325384_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.055985362375676_REALK,      0.000000000000000_REALK, &
     -0.241837350033666_REALK,      0.000000000000000_REALK,      0.008326025123473_REALK, &
      0.000000000000000_REALK,      0.020328323202530_REALK,      0.000000000000000_REALK, &
      0.336676587654799_REALK,      0.016454344515485_REALK,      0.000000000000000_REALK, &
      0.043762236102429_REALK,      0.000000000000000_REALK,      0.168750007676457_REALK, &
      0.005236823608236_REALK,      0.000000000000000_REALK,      0.010151292859775_REALK, &
      0.000000000000000_REALK,      0.031585254250348_REALK,      0.000000000000000_REALK, &
      0.043142742665738_REALK,      0.000000000000000_REALK,      0.278196038825675_REALK, &
     -0.562361096708552_REALK,     -0.002624951267085_REALK,      0.000000000000000_REALK, &
      0.023572523161732_REALK,      0.000000000000000_REALK,      0.130927435230142_REALK, &
     -0.007863587698961_REALK,      0.000000000000000_REALK,      0.008430826319323_REALK, &
      0.000000000000000_REALK,     -0.006657280426146_REALK,      0.000000000000000_REALK, &
      0.036740617690561_REALK,      0.000000000000000_REALK,      0.316730338856834_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.122754854877196_REALK, &
      0.000000000000000_REALK,     -0.020102807801183_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.023887563458691_REALK,      0.000000000000000_REALK, &
     -0.126969696215278_REALK,      0.000000000000000_REALK,     -0.015427553932946_REALK, &
      0.000000000000000_REALK,     -0.033441594439188_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.022780031952809_REALK, &
      0.000000000000000_REALK,     -0.025566470942668_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.037566992054703_REALK,      0.000000000000000_REALK, &
     -0.194223930617813_REALK,      0.000000000000000_REALK,     -0.035799994914087_REALK, &
      0.000000000000000_REALK,     -0.057777098425671_REALK,      0.000000000000000_REALK, &
      0.109446959341684_REALK,      0.028375565673704_REALK,      0.000000000000000_REALK, &
      0.023688998487153_REALK,      0.000000000000000_REALK,      0.092324002057267_REALK, &
      0.016274836879889_REALK,      0.000000000000000_REALK,      0.029578165178041_REALK, &
      0.000000000000000_REALK,      0.024653275723887_REALK,      0.000000000000000_REALK, &
      0.039596542489673_REALK,      0.000000000000000_REALK,      0.216179142527219_REALK, &
     -0.188803603379516_REALK,      0.011745974281013_REALK,      0.000000000000000_REALK, &
      0.025147029552169_REALK,      0.000000000000000_REALK,      0.143678007443225_REALK, &
      0.009070458968569_REALK,      0.000000000000000_REALK,      0.060422812182788_REALK, &
      0.000000000000000_REALK,     -0.018388959985547_REALK,      0.000000000000000_REALK, &
      0.058084767995480_REALK,      0.000000000000000_REALK,      0.445769625303075_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.085640542179358_REALK, &
      0.000000000000000_REALK,     -0.040133632749415_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.038742287575039_REALK,      0.000000000000000_REALK, &
     -0.125643794345531_REALK,      0.000000000000000_REALK,     -0.056793539916511_REALK, &
      0.000000000000000_REALK,     -0.095405507290579_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.107566863786322_REALK, &
      0.000000000000000_REALK,     -0.149642030308446_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.191026523747579_REALK,      0.000000000000000_REALK, &
     -0.462424462644257_REALK,      0.000000000000000_REALK,     -0.307674244191591_REALK, &
      0.000000000000000_REALK,     -0.439948665280667_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.091158403660770_REALK, &
      0.000000000000000_REALK,      0.115873812755065_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.127649804338713_REALK,      0.000000000000000_REALK, &
     -0.471812493040087_REALK,      0.000000000000000_REALK,      0.063904964141122_REALK, &
      0.000000000000000_REALK,      0.075928582089675_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.932484338697555_REALK, &
      0.000000000000000_REALK,      0.385615203472116_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.267798641991750_REALK,      0.000000000000000_REALK, &
     -1.093016458374958_REALK,      0.000000000000000_REALK,      0.130766788404633_REALK, &
      0.000000000000000_REALK,      0.151787655575476_REALK,      0.000000000000000_REALK, &
      0.925535267697063_REALK,     -0.028188458827500_REALK,      0.000000000000000_REALK, &
      0.079717307251889_REALK,      0.000000000000000_REALK,      0.318449444783843_REALK, &
     -0.012794525535448_REALK,      0.000000000000000_REALK,     -0.012394278710649_REALK, &
      0.000000000000000_REALK,      0.039376797907844_REALK,      0.000000000000000_REALK, &
      0.052128859827905_REALK,      0.000000000000000_REALK,      0.348364260282429_REALK, &
      4.949338414753391_REALK,     -0.148645892485747_REALK,      0.000000000000000_REALK, &
      0.259721430246348_REALK,      0.000000000000000_REALK,      1.113879622324748_REALK, &
     -0.023352461649666_REALK,      0.000000000000000_REALK,     -0.043308807913624_REALK, &
      0.000000000000000_REALK,      0.106238696923300_REALK,      0.000000000000000_REALK, &
      0.102514551566288_REALK,      0.000000000000000_REALK,      0.734401515712129_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.257643831854852_REALK, &
      0.000000000000000_REALK,     -0.011699756407441_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.029313159313362_REALK,      0.000000000000000_REALK, &
     -0.188362445591640_REALK,      0.000000000000000_REALK,     -0.003972462335398_REALK, &
      0.000000000000000_REALK,     -0.012883714380401_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.359965292999314_REALK, &
      0.000000000000000_REALK,     -0.040492222793592_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.081189058721715_REALK,      0.000000000000000_REALK, &
     -0.665388323936883_REALK,      0.000000000000000_REALK,      0.011203690914417_REALK, &
      0.000000000000000_REALK,     -0.026035577733707_REALK,      0.000000000000000_REALK, &
      0.249210265439004_REALK,      0.030362175639064_REALK,      0.000000000000000_REALK, &
      0.027374386852327_REALK,      0.000000000000000_REALK,      0.145272682175583_REALK, &
      0.010378061285165_REALK,      0.000000000000000_REALK,      0.022430008293142_REALK, &
      0.000000000000000_REALK,      0.016008368672559_REALK,      0.000000000000000_REALK, &
      0.030376678479945_REALK,      0.000000000000000_REALK,      0.226170245082465_REALK, &
      2.026504584323845_REALK,      0.226759505419466_REALK,      0.000000000000000_REALK, &
      0.154879313594782_REALK,      0.000000000000000_REALK,      0.814578606344102_REALK, &
      0.067818708726872_REALK,      0.000000000000000_REALK,      0.115709620873509_REALK, &
      0.000000000000000_REALK,      0.091433818706934_REALK,      0.000000000000000_REALK, &
      0.108292117659077_REALK,      0.000000000000000_REALK,      0.788804838827519_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.138590938147846_REALK, &
      0.000000000000000_REALK,     -0.033520667971432_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.026426301130322_REALK,      0.000000000000000_REALK, &
     -0.144192267052158_REALK,      0.000000000000000_REALK,     -0.020743640484978_REALK, &
      0.000000000000000_REALK,     -0.052858957439755_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.227725263087739_REALK, &
      0.000000000000000_REALK,     -0.247274667086382_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.122535089934113_REALK,      0.000000000000000_REALK, &
     -0.885893654373738_REALK,      0.000000000000000_REALK,     -0.031558640692135_REALK, &
      0.000000000000000_REALK,     -0.242278463230329_REALK,      0.000000000000000_REALK, &
      0.169867666799456_REALK,      0.059244544618263_REALK,      0.000000000000000_REALK, &
      0.043426095400780_REALK,      0.000000000000000_REALK,      0.141507892923860_REALK, &
      0.037195223121682_REALK,      0.000000000000000_REALK,      0.062658554821448_REALK, &
      0.000000000000000_REALK,      0.052030194784605_REALK,      0.000000000000000_REALK, &
      0.069527247531444_REALK,      0.000000000000000_REALK,      0.289379155637450_REALK, &
      2.861822708748238_REALK,      1.071420513679591_REALK,      0.000000000000000_REALK, &
      0.698172443372275_REALK,      0.000000000000000_REALK,      1.738711579391412_REALK, &
      0.565955928175869_REALK,      0.000000000000000_REALK,      0.818407014674889_REALK, &
      0.000000000000000_REALK,      0.644877735266676_REALK,      0.000000000000000_REALK, &
      0.732044062180683_REALK,      0.000000000000000_REALK,      2.303761521066341_REALK/
