  ! created by GeomPartOne.py on 2011-11-07
  ! number of total geometric derivatives, according to
  ! (1) numbers of differentiated centers
  ! (2) indices of differentiated centers
  ! (3) different indices of bra, ket and operator centers
  ! (4) orders of partial geoemtric derivatives on bra, ket and operator centers
  integer, parameter :: NUM_TOT_GEO = 480
  ! numbers of differentiated centers
  integer, parameter :: NUM_CENTS(NUM_TOT_GEO) = (/                      &
    1,          1,          1,          1,          1,          1,       &
    1,          1,          1,          1,          1,          1,       &
    1,          1,          1,          1,          1,          1,       &
    1,          1,          1,          1,          1,          1,       &
    1,          1,          1,          1,          1,          1,       &
    1,          1,          1,          1,          1,          1,       &
    1,          1,          1,          1,          1,          1,       &
    1,          1,          1,          1,          1,          1,       &
    1,          1,          1,          1,          1,          1,       &
    1,          1,          1,          1,          1,          1,       &
    1,          1,          1,          1,          1,          1,       &
    1,          1,          1,          1,          1,          1,       &
    1,          1,          1,          1,          1,          1,       &
    1,          1,          1,          1,          1,          1,       &
    1,          1,          1,          1,          1,          1,       &
    1,          1,          1,          1,          1,          1,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    2,          2,          2,          2,          2,          2,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3,       &
    3,          3,          3,          3,          3,          3/)
  ! indices of differentiated centers
  integer, parameter :: IDX_GEO_CENT(NUM_TOT_GEO*3) = (/                 &
    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0, &
    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0, &
    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0, &
    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0, &
    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0, &
    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0, &
    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0, &
    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0, &
    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0, &
    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0, &
    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0, &
    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0, &
    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0, &
    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0, &
    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0, &
    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3/)
  ! orders of differentiated centers
  integer, parameter :: ORDER_GEO_CENT(NUM_TOT_GEO*3) = (/               &
    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0, &
    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0, &
    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0, &
    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0, &
    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0, &
    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0, &
    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0, &
    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0, &
    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0, &
    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0, &
    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0, &
    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0, &
    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0, &
    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0, &
    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0, &
    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2/)
  ! indices of bra and ket centers
  integer, parameter :: IDX_BK_OPT(NUM_TOT_GEO*3) = (/                   &
    6, 7, 8,    6, 7, 8,    6, 7, 8,    6, 7, 8,    6, 7, 8,    6, 7, 8, &
    6, 7, 8,    6, 7, 8,    1, 7, 8,    1, 7, 8,    1, 7, 8,    1, 7, 8, &
    1, 7, 8,    1, 7, 8,    1, 7, 8,    1, 7, 8,    6, 1, 8,    6, 1, 8, &
    6, 1, 8,    6, 1, 8,    6, 1, 8,    6, 1, 8,    6, 1, 8,    6, 1, 8, &
    6, 7, 1,    6, 7, 1,    6, 7, 1,    6, 7, 1,    6, 7, 1,    6, 7, 1, &
    6, 7, 1,    6, 7, 1,    1, 1, 8,    1, 1, 8,    1, 1, 8,    1, 1, 8, &
    1, 1, 8,    1, 1, 8,    1, 1, 8,    1, 1, 8,    1, 7, 1,    1, 7, 1, &
    1, 7, 1,    1, 7, 1,    1, 7, 1,    1, 7, 1,    1, 7, 1,    1, 7, 1, &
    6, 1, 1,    6, 1, 1,    6, 1, 1,    6, 1, 1,    6, 1, 1,    6, 1, 1, &
    6, 1, 1,    6, 1, 1,    1, 1, 1,    1, 1, 1,    1, 1, 1,    1, 1, 1, &
    1, 1, 1,    1, 1, 1,    1, 1, 1,    1, 1, 1,    6, 7,-1,    6, 7,-1, &
    6, 7,-1,    6, 7,-1,    6, 7,-1,    6, 7,-1,    6, 7,-1,    6, 7,-1, &
    1, 7,-1,    1, 7,-1,    1, 7,-1,    1, 7,-1,    1, 7,-1,    1, 7,-1, &
    1, 7,-1,    1, 7,-1,    6, 1,-1,    6, 1,-1,    6, 1,-1,    6, 1,-1, &
    6, 1,-1,    6, 1,-1,    6, 1,-1,    6, 1,-1,    1, 1,-1,    1, 1,-1, &
    1, 1,-1,    1, 1,-1,    1, 1,-1,    1, 1,-1,    1, 1,-1,    1, 1,-1, &
    6, 7, 8,    6, 7, 8,    6, 7, 8,    6, 7, 8,    6, 7, 8,    6, 7, 8, &
    6, 7, 8,    6, 7, 8,    1, 7, 8,    1, 7, 8,    1, 7, 8,    1, 7, 8, &
    1, 7, 8,    1, 7, 8,    1, 7, 8,    1, 7, 8,    6, 1, 8,    6, 1, 8, &
    6, 1, 8,    6, 1, 8,    6, 1, 8,    6, 1, 8,    6, 1, 8,    6, 1, 8, &
    6, 7, 1,    6, 7, 1,    6, 7, 1,    6, 7, 1,    6, 7, 1,    6, 7, 1, &
    6, 7, 1,    6, 7, 1,    1, 2, 8,    1, 2, 8,    1, 2, 8,    1, 2, 8, &
    1, 2, 8,    1, 2, 8,    1, 2, 8,    1, 2, 8,    1, 7, 2,    1, 7, 2, &
    1, 7, 2,    1, 7, 2,    1, 7, 2,    1, 7, 2,    1, 7, 2,    1, 7, 2, &
    2, 1, 8,    2, 1, 8,    2, 1, 8,    2, 1, 8,    2, 1, 8,    2, 1, 8, &
    2, 1, 8,    2, 1, 8,    6, 1, 2,    6, 1, 2,    6, 1, 2,    6, 1, 2, &
    6, 1, 2,    6, 1, 2,    6, 1, 2,    6, 1, 2,    2, 7, 1,    2, 7, 1, &
    2, 7, 1,    2, 7, 1,    2, 7, 1,    2, 7, 1,    2, 7, 1,    2, 7, 1, &
    6, 2, 1,    6, 2, 1,    6, 2, 1,    6, 2, 1,    6, 2, 1,    6, 2, 1, &
    6, 2, 1,    6, 2, 1,    1, 1, 2,    1, 1, 2,    1, 1, 2,    1, 1, 2, &
    1, 1, 2,    1, 1, 2,    1, 1, 2,    1, 1, 2,    1, 2, 1,    1, 2, 1, &
    1, 2, 1,    1, 2, 1,    1, 2, 1,    1, 2, 1,    1, 2, 1,    1, 2, 1, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    2, 1, 1,    2, 1, 1,    2, 1, 1,    2, 1, 1, &
    2, 1, 1,    2, 1, 1,    2, 1, 1,    2, 1, 1,    2, 1, 2,    2, 1, 2, &
    2, 1, 2,    2, 1, 2,    2, 1, 2,    2, 1, 2,    2, 1, 2,    2, 1, 2, &
    2, 2, 1,    2, 2, 1,    2, 2, 1,    2, 2, 1,    2, 2, 1,    2, 2, 1, &
    2, 2, 1,    2, 2, 1,    6, 7,-1,    6, 7,-1,    6, 7,-1,    6, 7,-1, &
    6, 7,-1,    6, 7,-1,    6, 7,-1,    6, 7,-1,    1, 7,-1,    1, 7,-1, &
    1, 7,-1,    1, 7,-1,    1, 7,-1,    1, 7,-1,    1, 7,-1,    1, 7,-1, &
    6, 1,-1,    6, 1,-1,    6, 1,-1,    6, 1,-1,    6, 1,-1,    6, 1,-1, &
    6, 1,-1,    6, 1,-1,    1, 2,-1,    1, 2,-1,    1, 2,-1,    1, 2,-1, &
    1, 2,-1,    1, 2,-1,    1, 2,-1,    1, 2,-1,    2, 1,-1,    2, 1,-1, &
    2, 1,-1,    2, 1,-1,    2, 1,-1,    2, 1,-1,    2, 1,-1,    2, 1,-1, &
    6, 7, 8,    6, 7, 8,    6, 7, 8,    6, 7, 8,    6, 7, 8,    6, 7, 8, &
    6, 7, 8,    6, 7, 8,    1, 7, 8,    1, 7, 8,    1, 7, 8,    1, 7, 8, &
    1, 7, 8,    1, 7, 8,    1, 7, 8,    1, 7, 8,    6, 1, 8,    6, 1, 8, &
    6, 1, 8,    6, 1, 8,    6, 1, 8,    6, 1, 8,    6, 1, 8,    6, 1, 8, &
    6, 7, 1,    6, 7, 1,    6, 7, 1,    6, 7, 1,    6, 7, 1,    6, 7, 1, &
    6, 7, 1,    6, 7, 1,    1, 2, 8,    1, 2, 8,    1, 2, 8,    1, 2, 8, &
    1, 2, 8,    1, 2, 8,    1, 2, 8,    1, 2, 8,    1, 7, 2,    1, 7, 2, &
    1, 7, 2,    1, 7, 2,    1, 7, 2,    1, 7, 2,    1, 7, 2,    1, 7, 2, &
    2, 1, 8,    2, 1, 8,    2, 1, 8,    2, 1, 8,    2, 1, 8,    2, 1, 8, &
    2, 1, 8,    2, 1, 8,    6, 1, 2,    6, 1, 2,    6, 1, 2,    6, 1, 2, &
    6, 1, 2,    6, 1, 2,    6, 1, 2,    6, 1, 2,    2, 7, 1,    2, 7, 1, &
    2, 7, 1,    2, 7, 1,    2, 7, 1,    2, 7, 1,    2, 7, 1,    2, 7, 1, &
    6, 2, 1,    6, 2, 1,    6, 2, 1,    6, 2, 1,    6, 2, 1,    6, 2, 1, &
    6, 2, 1,    6, 2, 1,    1, 1, 2,    1, 1, 2,    1, 1, 2,    1, 1, 2, &
    1, 1, 2,    1, 1, 2,    1, 1, 2,    1, 1, 2,    1, 2, 1,    1, 2, 1, &
    1, 2, 1,    1, 2, 1,    1, 2, 1,    1, 2, 1,    1, 2, 1,    1, 2, 1, &
    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2,    1, 2, 2, &
    1, 2, 2,    1, 2, 2,    2, 1, 1,    2, 1, 1,    2, 1, 1,    2, 1, 1, &
    2, 1, 1,    2, 1, 1,    2, 1, 1,    2, 1, 1,    2, 1, 2,    2, 1, 2, &
    2, 1, 2,    2, 1, 2,    2, 1, 2,    2, 1, 2,    2, 1, 2,    2, 1, 2, &
    2, 2, 1,    2, 2, 1,    2, 2, 1,    2, 2, 1,    2, 2, 1,    2, 2, 1, &
    2, 2, 1,    2, 2, 1,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 3, 2,    1, 3, 2, &
    1, 3, 2,    1, 3, 2,    1, 3, 2,    1, 3, 2,    1, 3, 2,    1, 3, 2, &
    2, 1, 3,    2, 1, 3,    2, 1, 3,    2, 1, 3,    2, 1, 3,    2, 1, 3, &
    2, 1, 3,    2, 1, 3,    2, 3, 1,    2, 3, 1,    2, 3, 1,    2, 3, 1, &
    2, 3, 1,    2, 3, 1,    2, 3, 1,    2, 3, 1,    3, 1, 2,    3, 1, 2, &
    3, 1, 2,    3, 1, 2,    3, 1, 2,    3, 1, 2,    3, 1, 2,    3, 1, 2, &
    3, 2, 1,    3, 2, 1,    3, 2, 1,    3, 2, 1,    3, 2, 1,    3, 2, 1, &
    3, 2, 1,    3, 2, 1,    6, 7,-1,    6, 7,-1,    6, 7,-1,    6, 7,-1, &
    6, 7,-1,    6, 7,-1,    6, 7,-1,    6, 7,-1,    1, 7,-1,    1, 7,-1, &
    1, 7,-1,    1, 7,-1,    1, 7,-1,    1, 7,-1,    1, 7,-1,    1, 7,-1, &
    6, 1,-1,    6, 1,-1,    6, 1,-1,    6, 1,-1,    6, 1,-1,    6, 1,-1, &
    6, 1,-1,    6, 1,-1,    1, 2,-1,    1, 2,-1,    1, 2,-1,    1, 2,-1, &
    1, 2,-1,    1, 2,-1,    1, 2,-1,    1, 2,-1,    2, 1,-1,    2, 1,-1, &
    2, 1,-1,    2, 1,-1,    2, 1,-1,    2, 1,-1,    2, 1,-1,    2, 1,-1/)
  ! orders of partial geoemtric derivatives on bra center
  integer, parameter :: ORDER_GEO_BRA(NUM_TOT_GEO) = (/                  &
    0,          2,          0,          0,          2,          2,       &
    0,          2,          0,          2,          0,          0,       &
    2,          2,          0,          2,          0,          2,       &
    0,          0,          2,          2,          0,          2,       &
    0,          2,          0,          0,          2,          2,       &
    0,          2,          0,          2,          0,          0,       &
    2,          2,          0,          2,          0,          2,       &
    0,          0,          2,          2,          0,          2,       &
    0,          2,          0,          0,          2,          2,       &
    0,          2,          0,          2,          0,          0,       &
    2,          2,          0,          2,          0,          2,       &
    0,          0,          2,          2,          0,          2,       &
    0,          2,          0,          0,          2,          2,       &
    0,          2,          0,          2,          0,          0,       &
    2,          2,          0,          2,          0,          2,       &
    0,          0,          2,          2,          0,          2,       &
    0,          2,          0,          0,          2,          2,       &
    0,          2,          0,          2,          0,          0,       &
    2,          2,          0,          2,          0,          2,       &
    0,          0,          2,          2,          0,          2,       &
    0,          2,          0,          0,          2,          2,       &
    0,          2,          0,          2,          0,          0,       &
    2,          2,          0,          2,          0,          2,       &
    0,          0,          2,          2,          0,          2,       &
    0,          2,          0,          0,          2,          2,       &
    0,          2,          0,          2,          0,          0,       &
    2,          2,          0,          2,          0,          2,       &
    0,          0,          2,          2,          0,          2,       &
    0,          2,          0,          0,          2,          2,       &
    0,          2,          0,          2,          0,          0,       &
    2,          2,          0,          2,          0,          2,       &
    0,          0,          2,          2,          0,          2,       &
    0,          2,          0,          0,          2,          2,       &
    0,          2,          0,          2,          0,          0,       &
    2,          2,          0,          2,          0,          2,       &
    0,          0,          2,          2,          0,          2,       &
    0,          2,          0,          0,          2,          2,       &
    0,          2,          0,          2,          0,          0,       &
    2,          2,          0,          2,          0,          2,       &
    0,          0,          2,          2,          0,          2,       &
    0,          2,          0,          0,          2,          2,       &
    0,          2,          0,          2,          0,          0,       &
    2,          2,          0,          2,          0,          2,       &
    0,          0,          2,          2,          0,          2,       &
    0,          2,          0,          0,          2,          2,       &
    0,          2,          0,          2,          0,          0,       &
    2,          2,          0,          2,          0,          2,       &
    0,          0,          2,          2,          0,          2,       &
    0,          2,          0,          0,          2,          2,       &
    0,          2,          0,          2,          0,          0,       &
    2,          2,          0,          2,          0,          2,       &
    0,          0,          2,          2,          0,          2,       &
    0,          2,          0,          0,          2,          2,       &
    0,          2,          0,          2,          0,          0,       &
    2,          2,          0,          2,          0,          2,       &
    0,          0,          2,          2,          0,          2,       &
    0,          2,          0,          0,          2,          2,       &
    0,          2,          0,          2,          0,          0,       &
    2,          2,          0,          2,          0,          2,       &
    0,          0,          2,          2,          0,          2,       &
    0,          2,          0,          0,          2,          2,       &
    0,          2,          0,          2,          0,          0,       &
    2,          2,          0,          2,          0,          2,       &
    0,          0,          2,          2,          0,          2,       &
    0,          2,          0,          0,          2,          2,       &
    0,          2,          0,          2,          0,          0,       &
    2,          2,          0,          2,          0,          2,       &
    0,          0,          2,          2,          0,          2,       &
    0,          2,          0,          0,          2,          2,       &
    0,          2,          0,          2,          0,          0,       &
    2,          2,          0,          2,          0,          2,       &
    0,          0,          2,          2,          0,          2,       &
    0,          2,          0,          0,          2,          2,       &
    0,          2,          0,          2,          0,          0,       &
    2,          2,          0,          2,          0,          2,       &
    0,          0,          2,          2,          0,          2,       &
    0,          2,          0,          0,          2,          2,       &
    0,          2,          0,          2,          0,          0,       &
    2,          2,          0,          2,          0,          2,       &
    0,          0,          2,          2,          0,          2/)
  ! orders of partial geoemtric derivatives on ket center
  integer, parameter :: ORDER_GEO_KET(NUM_TOT_GEO) = (/                  &
    0,          0,          2,          0,          2,          0,       &
    2,          2,          0,          0,          2,          0,       &
    2,          0,          2,          2,          0,          0,       &
    2,          0,          2,          0,          2,          2,       &
    0,          0,          2,          0,          2,          0,       &
    2,          2,          0,          0,          2,          0,       &
    2,          0,          2,          2,          0,          0,       &
    2,          0,          2,          0,          2,          2,       &
    0,          0,          2,          0,          2,          0,       &
    2,          2,          0,          0,          2,          0,       &
    2,          0,          2,          2,          0,          0,       &
    2,          0,          2,          0,          2,          2,       &
    0,          0,          2,          0,          2,          0,       &
    2,          2,          0,          0,          2,          0,       &
    2,          0,          2,          2,          0,          0,       &
    2,          0,          2,          0,          2,          2,       &
    0,          0,          2,          0,          2,          0,       &
    2,          2,          0,          0,          2,          0,       &
    2,          0,          2,          2,          0,          0,       &
    2,          0,          2,          0,          2,          2,       &
    0,          0,          2,          0,          2,          0,       &
    2,          2,          0,          0,          2,          0,       &
    2,          0,          2,          2,          0,          0,       &
    2,          0,          2,          0,          2,          2,       &
    0,          0,          2,          0,          2,          0,       &
    2,          2,          0,          0,          2,          0,       &
    2,          0,          2,          2,          0,          0,       &
    2,          0,          2,          0,          2,          2,       &
    0,          0,          2,          0,          2,          0,       &
    2,          2,          0,          0,          2,          0,       &
    2,          0,          2,          2,          0,          0,       &
    2,          0,          2,          0,          2,          2,       &
    0,          0,          2,          0,          2,          0,       &
    2,          2,          0,          0,          2,          0,       &
    2,          0,          2,          2,          0,          0,       &
    2,          0,          2,          0,          2,          2,       &
    0,          0,          2,          0,          2,          0,       &
    2,          2,          0,          0,          2,          0,       &
    2,          0,          2,          2,          0,          0,       &
    2,          0,          2,          0,          2,          2,       &
    0,          0,          2,          0,          2,          0,       &
    2,          2,          0,          0,          2,          0,       &
    2,          0,          2,          2,          0,          0,       &
    2,          0,          2,          0,          2,          2,       &
    0,          0,          2,          0,          2,          0,       &
    2,          2,          0,          0,          2,          0,       &
    2,          0,          2,          2,          0,          0,       &
    2,          0,          2,          0,          2,          2,       &
    0,          0,          2,          0,          2,          0,       &
    2,          2,          0,          0,          2,          0,       &
    2,          0,          2,          2,          0,          0,       &
    2,          0,          2,          0,          2,          2,       &
    0,          0,          2,          0,          2,          0,       &
    2,          2,          0,          0,          2,          0,       &
    2,          0,          2,          2,          0,          0,       &
    2,          0,          2,          0,          2,          2,       &
    0,          0,          2,          0,          2,          0,       &
    2,          2,          0,          0,          2,          0,       &
    2,          0,          2,          2,          0,          0,       &
    2,          0,          2,          0,          2,          2,       &
    0,          0,          2,          0,          2,          0,       &
    2,          2,          0,          0,          2,          0,       &
    2,          0,          2,          2,          0,          0,       &
    2,          0,          2,          0,          2,          2,       &
    0,          0,          2,          0,          2,          0,       &
    2,          2,          0,          0,          2,          0,       &
    2,          0,          2,          2,          0,          0,       &
    2,          0,          2,          0,          2,          2,       &
    0,          0,          2,          0,          2,          0,       &
    2,          2,          0,          0,          2,          0,       &
    2,          0,          2,          2,          0,          0,       &
    2,          0,          2,          0,          2,          2,       &
    0,          0,          2,          0,          2,          0,       &
    2,          2,          0,          0,          2,          0,       &
    2,          0,          2,          2,          0,          0,       &
    2,          0,          2,          0,          2,          2,       &
    0,          0,          2,          0,          2,          0,       &
    2,          2,          0,          0,          2,          0,       &
    2,          0,          2,          2,          0,          0,       &
    2,          0,          2,          0,          2,          2/)
  ! orders of partial geoemtric derivatives on operator center
  integer, parameter :: ORDER_GEO_OPT(NUM_TOT_GEO) = (/                  &
    0,          0,          0,          2,          0,          2,       &
    2,          2,          0,          0,          0,          2,       &
    0,          2,          2,          2,          0,          0,       &
    0,          2,          0,          2,          2,          2,       &
    0,          0,          0,          2,          0,          2,       &
    2,          2,          0,          0,          0,          2,       &
    0,          2,          2,          2,          0,          0,       &
    0,          2,          0,          2,          2,          2,       &
    0,          0,          0,          2,          0,          2,       &
    2,          2,          0,          0,          0,          2,       &
    0,          2,          2,          2,          0,          0,       &
    0,          2,          0,          2,          2,          2,       &
    0,          0,          0,          2,          0,          2,       &
    2,          2,          0,          0,          0,          2,       &
    0,          2,          2,          2,          0,          0,       &
    0,          2,          0,          2,          2,          2,       &
    0,          0,          0,          2,          0,          2,       &
    2,          2,          0,          0,          0,          2,       &
    0,          2,          2,          2,          0,          0,       &
    0,          2,          0,          2,          2,          2,       &
    0,          0,          0,          2,          0,          2,       &
    2,          2,          0,          0,          0,          2,       &
    0,          2,          2,          2,          0,          0,       &
    0,          2,          0,          2,          2,          2,       &
    0,          0,          0,          2,          0,          2,       &
    2,          2,          0,          0,          0,          2,       &
    0,          2,          2,          2,          0,          0,       &
    0,          2,          0,          2,          2,          2,       &
    0,          0,          0,          2,          0,          2,       &
    2,          2,          0,          0,          0,          2,       &
    0,          2,          2,          2,          0,          0,       &
    0,          2,          0,          2,          2,          2,       &
    0,          0,          0,          2,          0,          2,       &
    2,          2,          0,          0,          0,          2,       &
    0,          2,          2,          2,          0,          0,       &
    0,          2,          0,          2,          2,          2,       &
    0,          0,          0,          2,          0,          2,       &
    2,          2,          0,          0,          0,          2,       &
    0,          2,          2,          2,          0,          0,       &
    0,          2,          0,          2,          2,          2,       &
    0,          0,          0,          2,          0,          2,       &
    2,          2,          0,          0,          0,          2,       &
    0,          2,          2,          2,          0,          0,       &
    0,          2,          0,          2,          2,          2,       &
    0,          0,          0,          2,          0,          2,       &
    2,          2,          0,          0,          0,          2,       &
    0,          2,          2,          2,          0,          0,       &
    0,          2,          0,          2,          2,          2,       &
    0,          0,          0,          2,          0,          2,       &
    2,          2,          0,          0,          0,          2,       &
    0,          2,          2,          2,          0,          0,       &
    0,          2,          0,          2,          2,          2,       &
    0,          0,          0,          2,          0,          2,       &
    2,          2,          0,          0,          0,          2,       &
    0,          2,          2,          2,          0,          0,       &
    0,          2,          0,          2,          2,          2,       &
    0,          0,          0,          2,          0,          2,       &
    2,          2,          0,          0,          0,          2,       &
    0,          2,          2,          2,          0,          0,       &
    0,          2,          0,          2,          2,          2,       &
    0,          0,          0,          2,          0,          2,       &
    2,          2,          0,          0,          0,          2,       &
    0,          2,          2,          2,          0,          0,       &
    0,          2,          0,          2,          2,          2,       &
    0,          0,          0,          2,          0,          2,       &
    2,          2,          0,          0,          0,          2,       &
    0,          2,          2,          2,          0,          0,       &
    0,          2,          0,          2,          2,          2,       &
    0,          0,          0,          2,          0,          2,       &
    2,          2,          0,          0,          0,          2,       &
    0,          2,          2,          2,          0,          0,       &
    0,          2,          0,          2,          2,          2,       &
    0,          0,          0,          2,          0,          2,       &
    2,          2,          0,          0,          0,          2,       &
    0,          2,          2,          2,          0,          0,       &
    0,          2,          0,          2,          2,          2,       &
    0,          0,          0,          2,          0,          2,       &
    2,          2,          0,          0,          0,          2,       &
    0,          2,          2,          2,          0,          0,       &
    0,          2,          0,          2,          2,          2/)
  ! referenced results indicating if the total geometric derivatives are zero
  logical, parameter :: REF_ZERO_INTS(NUM_TOT_GEO) = (/                     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true./)
  ! referenced results indicating if the integrals will be multiplied by -1
  logical, parameter :: REF_NEG_ONE(NUM_TOT_GEO) = (/                       &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false./)
  ! referenced final orders of partial geometric derivatives by adding
  ! those from total geometric derivatives
  integer, parameter :: REF_ORDER_PART(NUM_TOT_GEO*3) = (/               &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    2, 0, 0,    4, 0, 0,    2, 2, 0,    2, 0, 2, &
    4, 2, 0,    4, 0, 2,    2, 2, 2,    4, 2, 2,    0, 2, 0,    2, 2, 0, &
    0, 4, 0,    0, 2, 2,    2, 4, 0,    2, 2, 2,    0, 4, 2,    2, 4, 2, &
    0, 0, 2,    2, 0, 2,    0, 2, 2,    0, 0, 4,    2, 2, 2,    2, 0, 4, &
    0, 2, 4,    2, 2, 4,    0, 0, 2,    2, 0, 2,    0, 2, 2,    0, 0, 4, &
    2, 2, 2,    2, 0, 4,    0, 2, 4,    2, 2, 4,    0, 2, 0,    2, 2, 0, &
    0, 4, 0,    0, 2, 2,    2, 4, 0,    2, 2, 2,    0, 4, 2,    2, 4, 2, &
    2, 0, 0,    4, 0, 0,    2, 2, 0,    2, 0, 2,    4, 2, 0,    4, 0, 2, &
    2, 2, 2,    4, 2, 2,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    2, 0, 0,    4, 0, 0,    2, 2, 0,    2, 0, 2,    4, 2, 0,    4, 0, 2, &
    2, 2, 2,    4, 2, 2,    0, 2, 0,    2, 2, 0,    0, 4, 0,    0, 2, 2, &
    2, 4, 0,    2, 2, 2,    0, 4, 2,    2, 4, 2,    0, 0, 2,    2, 0, 2, &
    0, 2, 2,    0, 0, 4,    2, 2, 2,    2, 0, 4,    0, 2, 4,    2, 2, 4, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    2, 3, 0,    4, 3, 0,    2, 5, 0,    2, 3, 2, &
    4, 5, 0,    4, 3, 2,    2, 5, 2,    4, 5, 2,    2, 0, 3,    4, 0, 3, &
    2, 2, 3,    2, 0, 5,    4, 2, 3,    4, 0, 5,    2, 2, 5,    4, 2, 5, &
    3, 2, 0,    5, 2, 0,    3, 4, 0,    3, 2, 2,    5, 4, 0,    5, 2, 2, &
    3, 4, 2,    5, 4, 2,    0, 2, 3,    2, 2, 3,    0, 4, 3,    0, 2, 5, &
    2, 4, 3,    2, 2, 5,    0, 4, 5,    2, 4, 5,    3, 0, 2,    5, 0, 2, &
    3, 2, 2,    3, 0, 4,    5, 2, 2,    5, 0, 4,    3, 2, 4,    5, 2, 4, &
    0, 3, 2,    2, 3, 2,    0, 5, 2,    0, 3, 4,    2, 5, 2,    2, 3, 4, &
    0, 5, 4,    2, 5, 4,    0, 0, 5,    2, 0, 5,    0, 2, 5,    0, 0, 7, &
    2, 2, 5,    2, 0, 7,    0, 2, 7,    2, 2, 7,    0, 5, 0,    2, 5, 0, &
    0, 7, 0,    0, 5, 2,    2, 7, 0,    2, 5, 2,    0, 7, 2,    2, 7, 2, &
    5, 0, 0,    7, 0, 0,    5, 2, 0,    5, 0, 2,    7, 2, 0,    7, 0, 2, &
    5, 2, 2,    7, 2, 2,    5, 0, 0,    7, 0, 0,    5, 2, 0,    5, 0, 2, &
    7, 2, 0,    7, 0, 2,    5, 2, 2,    7, 2, 2,    0, 5, 0,    2, 5, 0, &
    0, 7, 0,    0, 5, 2,    2, 7, 0,    2, 5, 2,    0, 7, 2,    2, 7, 2, &
    0, 0, 5,    2, 0, 5,    0, 2, 5,    0, 0, 7,    2, 2, 5,    2, 0, 7, &
    0, 2, 7,    2, 2, 7,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    2, 3, 0,    4, 3, 0,    2, 5, 0,    2, 3, 2, &
    4, 5, 0,    4, 3, 2,    2, 5, 2,    4, 5, 2,    3, 2, 0,    5, 2, 0, &
    3, 4, 0,    3, 2, 2,    5, 4, 0,    5, 2, 2,    3, 4, 2,    5, 4, 2, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    1, 2, 2,    3, 2, 2,    1, 4, 2,    1, 2, 4, &
    3, 4, 2,    3, 2, 4,    1, 4, 4,    3, 4, 4,    1, 2, 2,    3, 2, 2, &
    1, 4, 2,    1, 2, 4,    3, 4, 2,    3, 2, 4,    1, 4, 4,    3, 4, 4, &
    2, 1, 2,    4, 1, 2,    2, 3, 2,    2, 1, 4,    4, 3, 2,    4, 1, 4, &
    2, 3, 4,    4, 3, 4,    2, 2, 1,    4, 2, 1,    2, 4, 1,    2, 2, 3, &
    4, 4, 1,    4, 2, 3,    2, 4, 3,    4, 4, 3,    2, 1, 2,    4, 1, 2, &
    2, 3, 2,    2, 1, 4,    4, 3, 2,    4, 1, 4,    2, 3, 4,    4, 3, 4, &
    2, 2, 1,    4, 2, 1,    2, 4, 1,    2, 2, 3,    4, 4, 1,    4, 2, 3, &
    2, 4, 3,    4, 4, 3,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0/)
  ! referenced results indicating if scattering the geometric derivatives later on
  logical, parameter :: REF_SCATTER_DER(NUM_TOT_GEO) = (/                   &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .false.,    .false.,    &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .false.,    .false.,    .false.,    .true.,     .false.,    .true.,     &
    .true.,     .true.,     .false.,    .false.,    .false.,    .true.,     &
    .false.,    .true.,     .true.,     .true.,     .false.,    .false.,    &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .false.,    .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .false.,    .false.,    .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .false.,    .false.,    &
    .false.,    .true.,     .false.,    .true.,     .true.,     .true.,     &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .false.,    .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .false.,    .false.,    .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .true.,     .true.,     .true.,     .true.,     &
    .true.,     .true.,     .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false.,    &
    .false.,    .false.,    .false.,    .false.,    .false.,    .false./)
  ! referenced sequences of bra and ket centers for partial derivative terms
  integer, parameter :: REF_SEQ_PART(NUM_TOT_GEO*3) = (/                 &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0, &
    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    2, 0, 0,    2, 0, 0, &
    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0, &
    3, 0, 0,    3, 0, 0,    3, 0, 0,    3, 0, 0,    3, 0, 0,    3, 0, 0, &
    3, 0, 0,    3, 0, 0,    3, 0, 0,    3, 0, 0,    3, 0, 0,    3, 0, 0, &
    3, 0, 0,    3, 0, 0,    3, 0, 0,    3, 0, 0,    2, 0, 0,    2, 0, 0, &
    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0, &
    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0, &
    1, 0, 0,    1, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0,    1, 0, 0, &
    1, 0, 0,    1, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0, &
    2, 0, 0,    2, 0, 0,    2, 0, 0,    2, 0, 0,    3, 0, 0,    3, 0, 0, &
    3, 0, 0,    3, 0, 0,    3, 0, 0,    3, 0, 0,    3, 0, 0,    3, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 3, 0,    1, 3, 0, &
    1, 3, 0,    1, 3, 0,    1, 3, 0,    1, 3, 0,    1, 3, 0,    1, 3, 0, &
    2, 1, 0,    2, 1, 0,    2, 1, 0,    2, 1, 0,    2, 1, 0,    2, 1, 0, &
    2, 1, 0,    2, 1, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0, &
    2, 3, 0,    2, 3, 0,    2, 3, 0,    2, 3, 0,    3, 1, 0,    3, 1, 0, &
    3, 1, 0,    3, 1, 0,    3, 1, 0,    3, 1, 0,    3, 1, 0,    3, 1, 0, &
    3, 2, 0,    3, 2, 0,    3, 2, 0,    3, 2, 0,    3, 2, 0,    3, 2, 0, &
    3, 2, 0,    3, 2, 0,    3, 3, 0,    3, 3, 0,    3, 3, 0,    3, 3, 0, &
    3, 3, 0,    3, 3, 0,    3, 3, 0,    3, 3, 0,    2, 2, 0,    2, 2, 0, &
    2, 2, 0,    2, 2, 0,    2, 2, 0,    2, 2, 0,    2, 2, 0,    2, 2, 0, &
    1, 1, 0,    1, 1, 0,    1, 1, 0,    1, 1, 0,    1, 1, 0,    1, 1, 0, &
    1, 1, 0,    1, 1, 0,    1, 1, 0,    1, 1, 0,    1, 1, 0,    1, 1, 0, &
    1, 1, 0,    1, 1, 0,    1, 1, 0,    1, 1, 0,    2, 2, 0,    2, 2, 0, &
    2, 2, 0,    2, 2, 0,    2, 2, 0,    2, 2, 0,    2, 2, 0,    2, 2, 0, &
    3, 3, 0,    3, 3, 0,    3, 3, 0,    3, 3, 0,    3, 3, 0,    3, 3, 0, &
    3, 3, 0,    3, 3, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0, &
    1, 2, 0,    1, 2, 0,    1, 2, 0,    1, 2, 0,    2, 1, 0,    2, 1, 0, &
    2, 1, 0,    2, 1, 0,    2, 1, 0,    2, 1, 0,    2, 1, 0,    2, 1, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3, &
    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 2, 3,    1, 3, 2,    1, 3, 2, &
    1, 3, 2,    1, 3, 2,    1, 3, 2,    1, 3, 2,    1, 3, 2,    1, 3, 2, &
    2, 1, 3,    2, 1, 3,    2, 1, 3,    2, 1, 3,    2, 1, 3,    2, 1, 3, &
    2, 1, 3,    2, 1, 3,    3, 1, 2,    3, 1, 2,    3, 1, 2,    3, 1, 2, &
    3, 1, 2,    3, 1, 2,    3, 1, 2,    3, 1, 2,    2, 3, 1,    2, 3, 1, &
    2, 3, 1,    2, 3, 1,    2, 3, 1,    2, 3, 1,    2, 3, 1,    2, 3, 1, &
    3, 2, 1,    3, 2, 1,    3, 2, 1,    3, 2, 1,    3, 2, 1,    3, 2, 1, &
    3, 2, 1,    3, 2, 1,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0, &
    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0/)
