  ! results of water molecule using cc-pV6Z basis sets
  !
  ! number of test cases
  integer, parameter :: NUM_TESTS = 3
  ! ID of block of sub-shells on bra center
  integer, parameter :: BRA_BLOCK(NUM_TESTS) = (/1, 13, 13/)
  ! ID of block of sub-shells on ket center
  integer, parameter :: KET_BLOCK(NUM_TESTS) = (/1, 1, 7/)
  ! coordinates of dipole origin
  real(REALK), parameter :: DIP_ORIGIN(3) = (/0.0_REALK, 0.0_REALK, 0.0_REALK/)
  ! orders of spherical multipole integrals
  integer, parameter :: ORDER_MOM = 4
  ! referenced results from Dalton
  real(REALK) REF_CONTR_INTS(2421)
  ! results of test 1, ket-major order, SM04-04
  data REF_CONTR_INTS(1:49) /                                                              &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK/
  ! results of test 1, ket-major order, SM04-03
  data REF_CONTR_INTS(50:98) /                                                             &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK/
  ! results of test 1, ket-major order, SM04-02
  data REF_CONTR_INTS(99:147) /                                                            &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK/
  ! results of test 1, ket-major order, SM04-01
  data REF_CONTR_INTS(148:196) /                                                           &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK/
  ! results of test 1, ket-major order, SM04+00
  data REF_CONTR_INTS(197:245) /                                                           &
      0.000959477086542_REALK,     -0.000000000002422_REALK,      0.000777266550152_REALK, &
      0.000545897009356_REALK,      0.000355234720302_REALK,      0.000209601664994_REALK, &
      0.000116398118561_REALK,     -0.000000000002422_REALK,      0.000959477086542_REALK, &
      0.000270908783883_REALK,      0.000620790530831_REALK,      0.000857414302294_REALK, &
      0.000913112513588_REALK,      0.000769667343396_REALK,      0.000777266550152_REALK, &
      0.000270908783883_REALK,      0.000959477086542_REALK,      0.000829770933019_REALK, &
      0.000594803702988_REALK,      0.000367807987871_REALK,      0.000208318205185_REALK, &
      0.000545897009356_REALK,      0.000620790530831_REALK,      0.000829770933019_REALK, &
      0.000959477086542_REALK,      0.000856361263562_REALK,      0.000616072243567_REALK, &
      0.000379313654600_REALK,      0.000355234720302_REALK,      0.000857414302294_REALK, &
      0.000594803702988_REALK,      0.000856361263562_REALK,      0.000959477086542_REALK, &
      0.000847396092223_REALK,      0.000598450660894_REALK,      0.000209601664994_REALK, &
      0.000913112513588_REALK,      0.000367807987871_REALK,      0.000616072243567_REALK, &
      0.000847396092223_REALK,      0.000959477086542_REALK,      0.000842235897860_REALK, &
      0.000116398118561_REALK,      0.000769667343396_REALK,      0.000208318205185_REALK, &
      0.000379313654600_REALK,      0.000598450660894_REALK,      0.000842235897860_REALK, &
      0.000959477086544_REALK/
  ! results of test 1, ket-major order, SM04+01
  data REF_CONTR_INTS(246:294) /                                                           &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK/
  ! results of test 1, ket-major order, SM04+02
  data REF_CONTR_INTS(295:343) /                                                           &
      0.001430303992240_REALK,     -0.000000000003611_REALK,      0.001158680561851_REALK, &
      0.000813775214422_REALK,      0.000529552655042_REALK,      0.000312455714083_REALK, &
      0.000173516070371_REALK,     -0.000000000003611_REALK,      0.001430303992241_REALK, &
      0.000403846970976_REALK,      0.000925419884484_REALK,      0.001278157776540_REALK, &
      0.001361187767659_REALK,      0.001147352333263_REALK,      0.001158680561851_REALK, &
      0.000403846970976_REALK,      0.001430303992240_REALK,      0.001236949474656_REALK, &
      0.000886681008767_REALK,      0.000548295775699_REALK,      0.000310542445163_REALK, &
      0.000813775214422_REALK,      0.000925419884484_REALK,      0.001236949474656_REALK, &
      0.001430303992240_REALK,      0.001276587999081_REALK,      0.000918386277112_REALK, &
      0.000565447410986_REALK,      0.000529552655042_REALK,      0.001278157776540_REALK, &
      0.000886681008767_REALK,      0.001276587999081_REALK,      0.001430303992240_REALK, &
      0.001263223510719_REALK,      0.000892117572626_REALK,      0.000312455714083_REALK, &
      0.001361187767659_REALK,      0.000548295775699_REALK,      0.000918386277112_REALK, &
      0.001263223510719_REALK,      0.001430303992240_REALK,      0.001255531147137_REALK, &
      0.000173516070371_REALK,      0.001147352333263_REALK,      0.000310542445163_REALK, &
      0.000565447410986_REALK,      0.000892117572626_REALK,      0.001255531147137_REALK, &
      0.001430303992240_REALK/
  ! results of test 1, ket-major order, SM04+03
  data REF_CONTR_INTS(344:392) /                                                           &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK/
  ! results of test 1, ket-major order, SM04+04
  data REF_CONTR_INTS(393:441) /                                                           &
      0.001892114331346_REALK,     -0.000000000004777_REALK,      0.001532790307812_REALK, &
      0.001076523420235_REALK,      0.000700532315678_REALK,      0.000413340057592_REALK, &
      0.000229540185337_REALK,     -0.000000000004777_REALK,      0.001892114331346_REALK, &
      0.000534239326464_REALK,      0.001224215436329_REALK,      0.001690843806513_REALK, &
      0.001800682160445_REALK,      0.001517804469991_REALK,      0.001532790307812_REALK, &
      0.000534239326464_REALK,      0.001892114331346_REALK,      0.001636330347146_REALK, &
      0.001172968720720_REALK,      0.000725327133703_REALK,      0.000410809040716_REALK, &
      0.001076523420235_REALK,      0.001224215436329_REALK,      0.001636330347146_REALK, &
      0.001892114331346_REALK,      0.001688767186129_REALK,      0.001214910848366_REALK, &
      0.000748016614477_REALK,      0.000700532315678_REALK,      0.001690843806513_REALK, &
      0.001172968720720_REALK,      0.001688767186129_REALK,      0.001892114331346_REALK, &
      0.001671087629826_REALK,      0.001180160618700_REALK,      0.000413340057592_REALK, &
      0.001800682160445_REALK,      0.000725327133703_REALK,      0.001214910848366_REALK, &
      0.001671087629826_REALK,      0.001892114331345_REALK,      0.001660911589309_REALK, &
      0.000229540185337_REALK,      0.001517804469991_REALK,      0.000410809040716_REALK, &
      0.000748016614477_REALK,      0.001180160618700_REALK,      0.001660911589309_REALK, &
      0.001892114331346_REALK/
  ! results of test 2, ket-major order, SM04-04
  data REF_CONTR_INTS(442:518) /                                                           &
     -0.000043308907576_REALK,      0.000000000000000_REALK,      0.000130848785780_REALK, &
      0.000000000000000_REALK,      0.000253094323753_REALK,      0.000000000000000_REALK, &
      0.000119054258010_REALK,      0.000000000000000_REALK,      0.000271951742863_REALK, &
      0.000000000000000_REALK,      0.000894519359639_REALK,      0.018545469175395_REALK, &
      0.000000000000000_REALK,     -0.005440226367175_REALK,      0.000000000000000_REALK, &
     -0.001859659815756_REALK,      0.000000000000000_REALK,     -0.003063303591417_REALK, &
      0.000000000000000_REALK,      0.000162444901427_REALK,      0.000000000000000_REALK, &
     -0.006204659670831_REALK,     -0.000588399804680_REALK,      0.000000000000000_REALK, &
      0.000394482129092_REALK,      0.000000000000000_REALK,      0.000703090811946_REALK, &
      0.000000000000000_REALK,      0.000389127226221_REALK,      0.000000000000000_REALK, &
      0.000737387038720_REALK,      0.000000000000000_REALK,      0.002655942785032_REALK, &
      0.005975316209307_REALK,      0.000000000000000_REALK,      0.003714696813421_REALK, &
      0.000000000000000_REALK,      0.005683339188741_REALK,      0.000000000000000_REALK, &
      0.001644889985750_REALK,      0.000000000000000_REALK,      0.006149397954769_REALK, &
      0.000000000000000_REALK,      0.020485613699187_REALK,      0.030565202046373_REALK, &
      0.000000000000000_REALK,      0.002559842928331_REALK,      0.000000000000000_REALK, &
      0.001529836964288_REALK,      0.000000000000000_REALK,     -0.006940462737872_REALK, &
      0.000000000000000_REALK,      0.006846883481567_REALK,      0.000000000000000_REALK, &
      0.000554316724510_REALK,      0.017646670096683_REALK,      0.000000000000000_REALK, &
     -0.014527108154232_REALK,      0.000000000000000_REALK,     -0.006650473725508_REALK, &
      0.000000000000000_REALK,     -0.001223701187978_REALK,      0.000000000000000_REALK, &
     -0.007795346886486_REALK,      0.000000000000000_REALK,     -0.024500538082503_REALK, &
     -0.029193271519616_REALK,      0.000000000000000_REALK,     -0.004725940117866_REALK, &
      0.000000000000000_REALK,     -0.002481254243525_REALK,      0.000000000000000_REALK, &
      0.002747178544272_REALK,      0.000000000000000_REALK,     -0.001514450889288_REALK, &
      0.000000000000000_REALK,      0.013812323790768_REALK/
  ! results of test 2, ket-major order, SM04-03
  data REF_CONTR_INTS(519:595) /                                                           &
      0.000000000000000_REALK,      0.000685409979730_REALK,      0.000000000000000_REALK, &
      0.000188141034165_REALK,      0.000000000000000_REALK,     -0.000296303170514_REALK, &
      0.000000000000000_REALK,     -0.000261078375398_REALK,      0.000000000000000_REALK, &
     -0.000360090943636_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.015114321959334_REALK,      0.000000000000000_REALK,      0.001832614037616_REALK, &
      0.000000000000000_REALK,     -0.007180294002498_REALK,      0.000000000000000_REALK, &
     -0.014225755917141_REALK,      0.000000000000000_REALK,     -0.027843432721066_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.001886260458987_REALK, &
      0.000000000000000_REALK,      0.000240048514099_REALK,      0.000000000000000_REALK, &
     -0.000422250649064_REALK,      0.000000000000000_REALK,     -0.000819040556289_REALK, &
      0.000000000000000_REALK,     -0.000559885120895_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.016936324593090_REALK,      0.000000000000000_REALK, &
      0.006692520103662_REALK,      0.000000000000000_REALK,     -0.011240622585791_REALK, &
      0.000000000000000_REALK,     -0.004552421155743_REALK,      0.000000000000000_REALK, &
     -0.015083983179968_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.038947939415739_REALK,      0.000000000000000_REALK,      0.013287220873150_REALK, &
      0.000000000000000_REALK,     -0.025314127735197_REALK,      0.000000000000000_REALK, &
     -0.014685587539679_REALK,      0.000000000000000_REALK,     -0.044761366268746_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000890986340470_REALK, &
      0.000000000000000_REALK,     -0.010914261853369_REALK,      0.000000000000000_REALK, &
      0.009390794000159_REALK,      0.000000000000000_REALK,     -0.016343803139010_REALK, &
      0.000000000000000_REALK,     -0.019452524084264_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.036764686485968_REALK,      0.000000000000000_REALK, &
     -0.000861596567706_REALK,      0.000000000000000_REALK,      0.010856613790583_REALK, &
      0.000000000000000_REALK,      0.000704846704870_REALK,      0.000000000000000_REALK, &
      0.021077747858825_REALK,      0.000000000000000_REALK/
  ! results of test 2, ket-major order, SM04-02
  data REF_CONTR_INTS(596:672) /                                                           &
     -0.000088695383372_REALK,      0.000000000000000_REALK,     -0.000511826265089_REALK, &
      0.000000000000000_REALK,     -0.000149117246427_REALK,      0.000000000000000_REALK, &
      0.000192965293108_REALK,      0.000000000000000_REALK,     -0.000323140198965_REALK, &
      0.000000000000000_REALK,     -0.000092479285441_REALK,     -0.008132071254351_REALK, &
      0.000000000000000_REALK,     -0.045380774119038_REALK,      0.000000000000000_REALK, &
     -0.034983108045604_REALK,      0.000000000000000_REALK,     -0.025882396125596_REALK, &
      0.000000000000000_REALK,     -0.006678415109274_REALK,      0.000000000000000_REALK, &
      0.012155528795665_REALK,     -0.000039036591045_REALK,      0.000000000000000_REALK, &
     -0.001016414097712_REALK,      0.000000000000000_REALK,     -0.000210721270001_REALK, &
      0.000000000000000_REALK,      0.000571219735897_REALK,      0.000000000000000_REALK, &
     -0.000781623805776_REALK,      0.000000000000000_REALK,     -0.000429178538419_REALK, &
     -0.005731645534174_REALK,      0.000000000000000_REALK,     -0.015711845218875_REALK, &
      0.000000000000000_REALK,     -0.003796756788356_REALK,      0.000000000000000_REALK, &
      0.006302234987119_REALK,      0.000000000000000_REALK,     -0.008480748785200_REALK, &
      0.000000000000000_REALK,     -0.000816710743841_REALK,     -0.015345428441591_REALK, &
      0.000000000000000_REALK,     -0.037757414848711_REALK,      0.000000000000000_REALK, &
     -0.036180976310730_REALK,      0.000000000000000_REALK,     -0.017699571533170_REALK, &
      0.000000000000000_REALK,     -0.023009407246510_REALK,      0.000000000000000_REALK, &
      0.003771537812946_REALK,     -0.001912786239652_REALK,      0.000000000000000_REALK, &
     -0.047081809669095_REALK,      0.000000000000000_REALK,     -0.041039015646833_REALK, &
      0.000000000000000_REALK,     -0.040342255294927_REALK,      0.000000000000000_REALK, &
      0.002811707748784_REALK,      0.000000000000000_REALK,      0.020294231648270_REALK, &
      0.002552841140762_REALK,      0.000000000000000_REALK,     -0.043734018028858_REALK, &
      0.000000000000000_REALK,     -0.001900374244744_REALK,      0.000000000000000_REALK, &
     -0.007691378897303_REALK,      0.000000000000000_REALK,      0.026213482894317_REALK, &
      0.000000000000000_REALK,      0.011950168349162_REALK/
  ! results of test 2, ket-major order, SM04-01
  data REF_CONTR_INTS(673:749) /                                                           &
      0.000000000000000_REALK,     -0.000077727691869_REALK,      0.000000000000000_REALK, &
     -0.000022383791997_REALK,      0.000000000000000_REALK,     -0.000064671037140_REALK, &
      0.000000000000000_REALK,      0.000347037695826_REALK,      0.000000000000000_REALK, &
     -0.000047233804901_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.024422256328043_REALK,      0.000000000000000_REALK,     -0.009697142538710_REALK, &
      0.000000000000000_REALK,     -0.001499630835399_REALK,      0.000000000000000_REALK, &
      0.056062192410255_REALK,      0.000000000000000_REALK,      0.025863013499502_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.000488286607557_REALK, &
      0.000000000000000_REALK,      0.000010598549184_REALK,      0.000000000000000_REALK, &
     -0.000116057818732_REALK,      0.000000000000000_REALK,      0.000601266073368_REALK, &
      0.000000000000000_REALK,     -0.000104778879314_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000885025261431_REALK,      0.000000000000000_REALK, &
      0.000246446144831_REALK,      0.000000000000000_REALK,     -0.003309315083055_REALK, &
      0.000000000000000_REALK,      0.009843612840445_REALK,      0.000000000000000_REALK, &
     -0.002233563659066_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.024399300123583_REALK,      0.000000000000000_REALK,      0.001057892890339_REALK, &
      0.000000000000000_REALK,     -0.011111202329931_REALK,      0.000000000000000_REALK, &
      0.040775368806993_REALK,      0.000000000000000_REALK,      0.012922604337389_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.027828222900428_REALK, &
      0.000000000000000_REALK,     -0.014230828188805_REALK,      0.000000000000000_REALK, &
      0.002756401611247_REALK,      0.000000000000000_REALK,      0.069080199615773_REALK, &
      0.000000000000000_REALK,      0.040549234347107_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.008507756639368_REALK,      0.000000000000000_REALK, &
     -0.030229165692207_REALK,      0.000000000000000_REALK,      0.020674115873463_REALK, &
      0.000000000000000_REALK,      0.046666672332697_REALK,      0.000000000000000_REALK, &
      0.018985535385938_REALK,      0.000000000000000_REALK/
  ! results of test 2, ket-major order, SM04+00
  data REF_CONTR_INTS(750:826) /                                                           &
      0.000006370105563_REALK,      0.000000000000000_REALK,      0.000044155196213_REALK, &
      0.000000000000000_REALK,     -0.000569001371686_REALK,      0.000000000000000_REALK, &
     -0.000514181554657_REALK,      0.000000000000000_REALK,     -0.000343010552362_REALK, &
      0.000000000000000_REALK,     -0.000216502297469_REALK,     -0.004921138681258_REALK, &
      0.000000000000000_REALK,     -0.057491966462051_REALK,      0.000000000000000_REALK, &
     -0.026134305214707_REALK,      0.000000000000000_REALK,     -0.021650946245713_REALK, &
      0.000000000000000_REALK,      0.008393918331079_REALK,      0.000000000000000_REALK, &
      0.013141693323253_REALK,      0.000196493620592_REALK,      0.000000000000000_REALK, &
      0.000496009429032_REALK,      0.000000000000000_REALK,     -0.001423125223300_REALK, &
      0.000000000000000_REALK,     -0.001298016835892_REALK,      0.000000000000000_REALK, &
     -0.001039689433765_REALK,      0.000000000000000_REALK,     -0.000721928612001_REALK, &
     -0.002545681378110_REALK,      0.000000000000000_REALK,     -0.001117344413903_REALK, &
      0.000000000000000_REALK,     -0.013638609103043_REALK,      0.000000000000000_REALK, &
     -0.012149467682996_REALK,      0.000000000000000_REALK,     -0.007074357034564_REALK, &
      0.000000000000000_REALK,     -0.003891488422019_REALK,     -0.007267406776885_REALK, &
      0.000000000000000_REALK,     -0.044665592139188_REALK,      0.000000000000000_REALK, &
     -0.020012824826517_REALK,      0.000000000000000_REALK,     -0.012011849920557_REALK, &
      0.000000000000000_REALK,      0.000772176142344_REALK,      0.000000000000000_REALK, &
      0.013438110258706_REALK,     -0.002866557377489_REALK,      0.000000000000000_REALK, &
     -0.075626598644523_REALK,      0.000000000000000_REALK,     -0.025665533881443_REALK, &
      0.000000000000000_REALK,     -0.022228705935768_REALK,      0.000000000000000_REALK, &
      0.017638198120950_REALK,      0.000000000000000_REALK,      0.016358497779329_REALK, &
     -0.000323019319952_REALK,      0.000000000000000_REALK,     -0.030607593029612_REALK, &
      0.000000000000000_REALK,     -0.031769597030480_REALK,      0.000000000000000_REALK, &
     -0.037830513622129_REALK,      0.000000000000000_REALK,      0.008675190731666_REALK, &
      0.000000000000000_REALK,      0.003253005641035_REALK/
  ! results of test 2, ket-major order, SM04+01
  data REF_CONTR_INTS(827:903) /                                                           &
      0.000000000000000_REALK,      0.000491257695898_REALK,      0.000000000000000_REALK, &
      0.000670993633081_REALK,      0.000000000000000_REALK,     -0.000627777485771_REALK, &
      0.000000000000000_REALK,     -0.000310799905340_REALK,      0.000000000000000_REALK, &
     -0.000010793148926_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
     -0.013941539703067_REALK,      0.000000000000000_REALK,      0.030193180609639_REALK, &
      0.000000000000000_REALK,     -0.024038551456255_REALK,      0.000000000000000_REALK, &
     -0.038046243117575_REALK,      0.000000000000000_REALK,     -0.027241389538063_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.001245897087390_REALK, &
      0.000000000000000_REALK,      0.001912097461757_REALK,      0.000000000000000_REALK, &
     -0.001660224612004_REALK,      0.000000000000000_REALK,     -0.000598036713325_REALK, &
      0.000000000000000_REALK,      0.000691531303088_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.013919894349547_REALK,      0.000000000000000_REALK, &
      0.013933901516672_REALK,      0.000000000000000_REALK,     -0.015264213081769_REALK, &
      0.000000000000000_REALK,     -0.008435547803729_REALK,      0.000000000000000_REALK, &
     -0.009169256601314_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.004615857358902_REALK,      0.000000000000000_REALK,      0.035621705399819_REALK, &
      0.000000000000000_REALK,     -0.038430776817869_REALK,      0.000000000000000_REALK, &
     -0.025210302739578_REALK,      0.000000000000000_REALK,     -0.041820720836313_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.034852740933661_REALK, &
      0.000000000000000_REALK,      0.030577447053068_REALK,      0.000000000000000_REALK, &
     -0.017128558194098_REALK,      0.000000000000000_REALK,     -0.045683707371725_REALK, &
      0.000000000000000_REALK,     -0.016888879474717_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.018366343600072_REALK,      0.000000000000000_REALK, &
     -0.007228912301421_REALK,      0.000000000000000_REALK,      0.019996214101591_REALK, &
      0.000000000000000_REALK,     -0.042486554316068_REALK,      0.000000000000000_REALK, &
      0.001121441695074_REALK,      0.000000000000000_REALK/
  ! results of test 2, ket-major order, SM04+02
  data REF_CONTR_INTS(904:980) /                                                           &
      0.000070186922329_REALK,      0.000000000000000_REALK,     -0.000113315918878_REALK, &
      0.000000000000000_REALK,      0.000627698053448_REALK,      0.000000000000000_REALK, &
      0.000270614266945_REALK,      0.000000000000000_REALK,      0.000821867412915_REALK, &
      0.000000000000000_REALK,      0.000285388097497_REALK,      0.003314016166862_REALK, &
      0.000000000000000_REALK,     -0.001188506174696_REALK,      0.000000000000000_REALK, &
      0.002843809965111_REALK,      0.000000000000000_REALK,     -0.013915617620145_REALK, &
      0.000000000000000_REALK,      0.025366332826582_REALK,      0.000000000000000_REALK, &
      0.002824946758440_REALK,     -0.000330865482619_REALK,      0.000000000000000_REALK, &
     -0.000524870051267_REALK,      0.000000000000000_REALK,      0.001670575875525_REALK, &
      0.000000000000000_REALK,      0.001062824590972_REALK,      0.000000000000000_REALK, &
      0.001875060843941_REALK,      0.000000000000000_REALK,      0.000837635095697_REALK, &
      0.008733300249548_REALK,      0.000000000000000_REALK,      0.000522792419049_REALK, &
      0.000000000000000_REALK,      0.016431864484740_REALK,      0.000000000000000_REALK, &
      0.002898096365760_REALK,      0.000000000000000_REALK,      0.024899808340340_REALK, &
      0.000000000000000_REALK,      0.006026356452730_REALK,      0.020337893517311_REALK, &
      0.000000000000000_REALK,      0.011772612589764_REALK,      0.000000000000000_REALK, &
      0.021742889149311_REALK,      0.000000000000000_REALK,     -0.017600860843064_REALK, &
      0.000000000000000_REALK,      0.057474253024077_REALK,      0.000000000000000_REALK, &
      0.001498299588270_REALK,     -0.012401207620033_REALK,      0.000000000000000_REALK, &
     -0.006958876188184_REALK,      0.000000000000000_REALK,     -0.014191413695475_REALK, &
      0.000000000000000_REALK,     -0.016742551212594_REALK,      0.000000000000000_REALK, &
      0.002752206204129_REALK,      0.000000000000000_REALK,      0.002294628760558_REALK, &
     -0.011357498271395_REALK,      0.000000000000000_REALK,     -0.026731900161199_REALK, &
      0.000000000000000_REALK,     -0.020553142065282_REALK,      0.000000000000000_REALK, &
      0.007810463112206_REALK,      0.000000000000000_REALK,     -0.036075940700984_REALK, &
      0.000000000000000_REALK,      0.002835085335025_REALK/
  ! results of test 2, ket-major order, SM04+03
  data REF_CONTR_INTS(981:1057) /                                                          &
      0.000000000000000_REALK,     -0.000687867609518_REALK,      0.000000000000000_REALK, &
     -0.000356951239842_REALK,      0.000000000000000_REALK,      0.000211255331979_REALK, &
      0.000000000000000_REALK,      0.000305727024600_REALK,      0.000000000000000_REALK, &
     -0.000589470649078_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
     -0.003976630559771_REALK,      0.000000000000000_REALK,      0.011470571998092_REALK, &
      0.000000000000000_REALK,     -0.004156851791527_REALK,      0.000000000000000_REALK, &
     -0.028571805624140_REALK,      0.000000000000000_REALK,     -0.003424672296837_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.001647493623354_REALK, &
      0.000000000000000_REALK,     -0.001329893526003_REALK,      0.000000000000000_REALK, &
      0.000773423802468_REALK,      0.000000000000000_REALK,      0.000939220003879_REALK, &
      0.000000000000000_REALK,     -0.001942398742622_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.019872552494588_REALK,      0.000000000000000_REALK, &
     -0.005295644959155_REALK,      0.000000000000000_REALK,      0.003373127882272_REALK, &
      0.000000000000000_REALK,      0.007677508464526_REALK,      0.000000000000000_REALK, &
     -0.010018415943341_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
     -0.004219807000969_REALK,      0.000000000000000_REALK,      0.010196375466670_REALK, &
      0.000000000000000_REALK,     -0.000693680440659_REALK,      0.000000000000000_REALK, &
     -0.023310883568446_REALK,      0.000000000000000_REALK,      0.010827039156797_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.007626943458001_REALK, &
      0.000000000000000_REALK,      0.017189262455716_REALK,      0.000000000000000_REALK, &
     -0.008347138161384_REALK,      0.000000000000000_REALK,     -0.041576585009803_REALK, &
      0.000000000000000_REALK,     -0.004967051977615_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.021854180737400_REALK,      0.000000000000000_REALK, &
     -0.000439792519074_REALK,      0.000000000000000_REALK,     -0.004214391306318_REALK, &
      0.000000000000000_REALK,     -0.006271371050795_REALK,      0.000000000000000_REALK, &
     -0.037123740271523_REALK,      0.000000000000000_REALK/
  ! results of test 2, ket-major order, SM04+04
  data REF_CONTR_INTS(1058:1134) /                                                         &
      0.000531309450526_REALK,      0.000000000000000_REALK,      0.000036089116559_REALK, &
      0.000000000000000_REALK,      0.000008328028475_REALK,      0.000000000000000_REALK, &
     -0.000051840021935_REALK,      0.000000000000000_REALK,     -0.000015930022901_REALK, &
      0.000000000000000_REALK,     -0.000215847363750_REALK,      0.019429760585312_REALK, &
      0.000000000000000_REALK,      0.011577595442437_REALK,      0.000000000000000_REALK, &
      0.005962428828563_REALK,      0.000000000000000_REALK,      0.002796522813876_REALK, &
      0.000000000000000_REALK,     -0.000812641796748_REALK,      0.000000000000000_REALK, &
      0.008837748940292_REALK,      0.002008609899017_REALK,      0.000000000000000_REALK, &
      0.000018286694942_REALK,      0.000000000000000_REALK,     -0.000180708698897_REALK, &
      0.000000000000000_REALK,     -0.000150105889907_REALK,      0.000000000000000_REALK, &
     -0.000459069566676_REALK,      0.000000000000000_REALK,     -0.000374159424577_REALK, &
      0.008065849848226_REALK,      0.000000000000000_REALK,      0.001221696172922_REALK, &
      0.000000000000000_REALK,      0.002008417165971_REALK,      0.000000000000000_REALK, &
     -0.001475431434047_REALK,      0.000000000000000_REALK,      0.003823995788119_REALK, &
      0.000000000000000_REALK,     -0.008720776003203_REALK,      0.018962656358151_REALK, &
      0.000000000000000_REALK,      0.011318123590668_REALK,      0.000000000000000_REALK, &
      0.011823701911990_REALK,      0.000000000000000_REALK,      0.003079195498553_REALK, &
      0.000000000000000_REALK,      0.010028557497982_REALK,      0.000000000000000_REALK, &
      0.015533909015787_REALK,      0.026682246115715_REALK,      0.000000000000000_REALK, &
      0.013840360641137_REALK,      0.000000000000000_REALK,      0.001791701772575_REALK, &
      0.000000000000000_REALK,      0.003694732420414_REALK,      0.000000000000000_REALK, &
     -0.011825876547230_REALK,      0.000000000000000_REALK,      0.015662853956212_REALK, &
     -0.013748934856501_REALK,      0.000000000000000_REALK,      0.001975563748873_REALK, &
      0.000000000000000_REALK,     -0.002811834723662_REALK,      0.000000000000000_REALK, &
     -0.000050480248872_REALK,      0.000000000000000_REALK,     -0.004520758438978_REALK, &
      0.000000000000000_REALK,     -0.029255187192513_REALK/
  ! results of test 3, ket-major order, SM04-04
  data REF_CONTR_INTS(1135:1277) /                                                         &
     -0.090684435228478_REALK,      0.000000000000000_REALK,      0.002497895420412_REALK, &
      0.000000000000000_REALK,     -0.024703158549833_REALK,      0.000000000000000_REALK, &
      0.015869170469250_REALK,      0.000000000000000_REALK,     -0.026136809562418_REALK, &
      0.000000000000000_REALK,     -0.037033998242201_REALK,      0.000000000000000_REALK, &
     -0.059816218910054_REALK,      0.000000000000000_REALK,     -0.015616442276542_REALK, &
      0.000000000000000_REALK,      0.006708111240508_REALK,      0.000000000000000_REALK, &
      0.011768605475483_REALK,      0.000000000000000_REALK,      0.041552384818861_REALK, &
      0.000000000000000_REALK,     -0.005728718326814_REALK,      0.000000000000000_REALK, &
      0.045417311455292_REALK,      0.000000000000000_REALK,      0.017722498024952_REALK, &
      0.000000000000000_REALK,      0.053012109142633_REALK,      0.000000000000000_REALK, &
      0.009811620172645_REALK,      0.000000000000000_REALK,      0.005661463609654_REALK, &
      0.000000000000000_REALK,      0.033559094781526_REALK,      0.000000000000000_REALK, &
      0.018245740741268_REALK,      0.000000000000000_REALK,     -0.042364155835631_REALK, &
      0.000000000000000_REALK,      0.001715739589579_REALK,      0.000000000000000_REALK, &
     -0.014111540929805_REALK,      0.000000000000000_REALK,     -0.017960001660718_REALK, &
      0.000000000000000_REALK,      0.026283872118214_REALK,      0.000000000000000_REALK, &
     -0.023884437256157_REALK,      0.000000000000000_REALK,      0.022883784848992_REALK, &
      0.000000000000000_REALK,     -0.058714523267316_REALK,      0.000000000000000_REALK, &
     -0.003531735134371_REALK,      0.000000000000000_REALK,      0.030014675443027_REALK, &
      0.000000000000000_REALK,     -0.039840963084499_REALK,      0.000000000000000_REALK, &
     -0.017591082157685_REALK,      0.000000000000000_REALK,      0.045204210530592_REALK, &
      0.000000000000000_REALK,     -0.010870954751081_REALK,      0.000000000000000_REALK, &
     -0.005372595519092_REALK,      0.000000000000000_REALK,     -0.060405485715412_REALK, &
      0.000000000000000_REALK,     -0.022856458127049_REALK,      0.000000000000000_REALK, &
     -0.028983527002761_REALK,      0.000000000000000_REALK,      0.043379357646851_REALK, &
      0.000000000000000_REALK,      0.009476335232773_REALK,      0.000000000000000_REALK, &
      0.009163941925865_REALK,      0.000000000000000_REALK,     -0.031931049202567_REALK, &
      0.000000000000000_REALK,     -0.034625905741782_REALK,      0.000000000000000_REALK, &
     -0.029286796367734_REALK,      0.000000000000000_REALK,     -0.046988337288510_REALK, &
      0.000000000000000_REALK,      0.038507283955746_REALK,      0.000000000000000_REALK, &
      0.016117666570088_REALK,      0.000000000000000_REALK,      0.057263942438311_REALK, &
      0.000000000000000_REALK,     -0.038626283416179_REALK,      0.000000000000000_REALK, &
      0.012638195466502_REALK,      0.000000000000000_REALK,     -0.002368194886597_REALK, &
      0.000000000000000_REALK,      0.032540598006711_REALK,      0.000000000000000_REALK, &
     -0.023901963290794_REALK,      0.000000000000000_REALK,      0.014124125796393_REALK, &
      0.000000000000000_REALK,      0.083857811139252_REALK,      0.000000000000000_REALK, &
      0.016881983928441_REALK,      0.000000000000000_REALK,     -0.024350244562675_REALK, &
      0.000000000000000_REALK,     -0.017650344475507_REALK,      0.000000000000000_REALK, &
     -0.046139309738026_REALK,      0.000000000000000_REALK,     -0.014673393765274_REALK, &
      0.000000000000000_REALK,     -0.025848985665753_REALK,      0.000000000000000_REALK, &
      0.005264871805255_REALK,      0.000000000000000_REALK,      0.063199296806405_REALK, &
      0.000000000000000_REALK,     -0.024454346946838_REALK,      0.000000000000000_REALK, &
     -0.051401762692392_REALK,      0.000000000000000_REALK,     -0.003161887726033_REALK, &
      0.000000000000000_REALK,     -0.038925752125089_REALK,      0.000000000000000_REALK, &
      0.012452152003245_REALK,      0.000000000000000_REALK,      0.019251262821378_REALK, &
      0.000000000000000_REALK,      0.025049042653325_REALK,      0.000000000000000_REALK, &
     -0.009872191943540_REALK,      0.000000000000000_REALK,     -0.011586863989448_REALK, &
      0.000000000000000_REALK,      0.024016975419779_REALK/
  ! results of test 3, ket-major order, SM04-03
  data REF_CONTR_INTS(1278:1420) /                                                         &
      0.000000000000000_REALK,     -0.039708248108721_REALK,      0.000000000000000_REALK, &
     -0.026146283308508_REALK,      0.000000000000000_REALK,      0.005226880329415_REALK, &
      0.000000000000000_REALK,      0.016936848806547_REALK,      0.000000000000000_REALK, &
      0.025421089266893_REALK,      0.000000000000000_REALK,     -0.000183512183847_REALK, &
      0.000000000000000_REALK,      0.057929465559968_REALK,      0.000000000000000_REALK, &
      0.006460369273151_REALK,      0.000000000000000_REALK,     -0.004737955346566_REALK, &
      0.000000000000000_REALK,      0.082162965429253_REALK,      0.000000000000000_REALK, &
     -0.016633683482213_REALK,      0.000000000000000_REALK,     -0.039016190363834_REALK, &
      0.000000000000000_REALK,      0.048793546375760_REALK,      0.000000000000000_REALK, &
     -0.025636602535666_REALK,      0.000000000000000_REALK,     -0.042454091272128_REALK, &
      0.000000000000000_REALK,     -0.018198193574435_REALK,      0.000000000000000_REALK, &
     -0.004740158775405_REALK,      0.000000000000000_REALK,     -0.018506177845797_REALK, &
      0.000000000000000_REALK,     -0.014964165390926_REALK,      0.000000000000000_REALK, &
     -0.015736949691634_REALK,      0.000000000000000_REALK,      0.007001844653651_REALK, &
      0.000000000000000_REALK,      0.015216647378717_REALK,      0.000000000000000_REALK, &
     -0.011985754455861_REALK,      0.000000000000000_REALK,     -0.040701104258958_REALK, &
      0.000000000000000_REALK,      0.031675616651851_REALK,      0.000000000000000_REALK, &
     -0.018887646877392_REALK,      0.000000000000000_REALK,      0.016440920615066_REALK, &
      0.000000000000000_REALK,     -0.020609228904208_REALK,      0.000000000000000_REALK, &
      0.026870808697120_REALK,      0.000000000000000_REALK,      0.010049979815605_REALK, &
      0.000000000000000_REALK,      0.023507881729602_REALK,      0.000000000000000_REALK, &
     -0.020865790643850_REALK,      0.000000000000000_REALK,      0.001566729965901_REALK, &
      0.000000000000000_REALK,      0.028509446923645_REALK,      0.000000000000000_REALK, &
      0.030310418791200_REALK,      0.000000000000000_REALK,     -0.039200483813447_REALK, &
      0.000000000000000_REALK,     -0.009360560945135_REALK,      0.000000000000000_REALK, &
     -0.040466006179048_REALK,      0.000000000000000_REALK,      0.023772130548330_REALK, &
      0.000000000000000_REALK,      0.053159796036360_REALK,      0.000000000000000_REALK, &
      0.045359348287930_REALK,      0.000000000000000_REALK,      0.027637973988793_REALK, &
      0.000000000000000_REALK,     -0.000242596579457_REALK,      0.000000000000000_REALK, &
      0.004766435254443_REALK,      0.000000000000000_REALK,     -0.003389720558792_REALK, &
      0.000000000000000_REALK,     -0.029779747280081_REALK,      0.000000000000000_REALK, &
      0.021991056251544_REALK,      0.000000000000000_REALK,      0.053915286824896_REALK, &
      0.000000000000000_REALK,      0.020689040418209_REALK,      0.000000000000000_REALK, &
     -0.038618625271192_REALK,      0.000000000000000_REALK,     -0.002331343531633_REALK, &
      0.000000000000000_REALK,     -0.010852560599041_REALK,      0.000000000000000_REALK, &
      0.004198100909205_REALK,      0.000000000000000_REALK,     -0.021814522916370_REALK, &
      0.000000000000000_REALK,     -0.008641525215659_REALK,      0.000000000000000_REALK, &
     -0.009841301288894_REALK,      0.000000000000000_REALK,     -0.059887680046602_REALK, &
      0.000000000000000_REALK,      0.038926173391195_REALK,      0.000000000000000_REALK, &
     -0.049088372112788_REALK,      0.000000000000000_REALK,      0.004141053804038_REALK, &
      0.000000000000000_REALK,     -0.003944520818970_REALK,      0.000000000000000_REALK, &
      0.047776411630259_REALK,      0.000000000000000_REALK,     -0.012684934958758_REALK, &
      0.000000000000000_REALK,     -0.013282387444422_REALK,      0.000000000000000_REALK, &
     -0.049138199353468_REALK,      0.000000000000000_REALK,      0.002771739701026_REALK, &
      0.000000000000000_REALK,      0.026623519692333_REALK,      0.000000000000000_REALK, &
     -0.012505198380165_REALK,      0.000000000000000_REALK,     -0.002034505104404_REALK, &
      0.000000000000000_REALK,     -0.019825276709205_REALK,      0.000000000000000_REALK, &
      0.031821336186197_REALK,      0.000000000000000_REALK/
  ! results of test 3, ket-major order, SM04-02
  data REF_CONTR_INTS(1421:1563) /                                                         &
     -0.000649228904189_REALK,      0.000000000000000_REALK,      0.059983802670208_REALK, &
      0.000000000000000_REALK,      0.011926347481677_REALK,      0.000000000000000_REALK, &
      0.029044965411554_REALK,      0.000000000000000_REALK,      0.000164650311938_REALK, &
      0.000000000000000_REALK,      0.011375644696093_REALK,      0.000000000000000_REALK, &
     -0.039647364642991_REALK,      0.000000000000000_REALK,      0.002485695296987_REALK, &
      0.000000000000000_REALK,      0.021085962135752_REALK,      0.000000000000000_REALK, &
     -0.078089817603425_REALK,      0.000000000000000_REALK,     -0.018316622972480_REALK, &
      0.000000000000000_REALK,     -0.000036683474316_REALK,      0.000000000000000_REALK, &
      0.001520010421923_REALK,      0.000000000000000_REALK,     -0.031088704391158_REALK, &
      0.000000000000000_REALK,     -0.015997660166743_REALK,      0.000000000000000_REALK, &
      0.073374862427414_REALK,      0.000000000000000_REALK,      0.006916183317785_REALK, &
      0.000000000000000_REALK,      0.002248325721062_REALK,      0.000000000000000_REALK, &
      0.031413904973349_REALK,      0.000000000000000_REALK,     -0.013471751882558_REALK, &
      0.000000000000000_REALK,      0.019171878803563_REALK,      0.000000000000000_REALK, &
     -0.018870390425670_REALK,      0.000000000000000_REALK,      0.007337096100007_REALK, &
      0.000000000000000_REALK,      0.021615932749475_REALK,      0.000000000000000_REALK, &
      0.011041987633911_REALK,      0.000000000000000_REALK,      0.014722643628543_REALK, &
      0.000000000000000_REALK,      0.016131997374341_REALK,      0.000000000000000_REALK, &
      0.009751863794405_REALK,      0.000000000000000_REALK,     -0.014904190098951_REALK, &
      0.000000000000000_REALK,     -0.035549645689110_REALK,      0.000000000000000_REALK, &
      0.014699982332993_REALK,      0.000000000000000_REALK,     -0.023217072333099_REALK, &
      0.000000000000000_REALK,     -0.007954971087183_REALK,      0.000000000000000_REALK, &
      0.017578606947106_REALK,      0.000000000000000_REALK,      0.008565822487438_REALK, &
      0.000000000000000_REALK,      0.009407405633413_REALK,      0.000000000000000_REALK, &
     -0.005699390664384_REALK,      0.000000000000000_REALK,     -0.001439764215740_REALK, &
      0.000000000000000_REALK,      0.000976544415630_REALK,      0.000000000000000_REALK, &
     -0.030842474010604_REALK,      0.000000000000000_REALK,     -0.047034674495583_REALK, &
      0.000000000000000_REALK,      0.031919673026783_REALK,      0.000000000000000_REALK, &
      0.002768795124426_REALK,      0.000000000000000_REALK,      0.023201666628760_REALK, &
      0.000000000000000_REALK,     -0.015763706770027_REALK,      0.000000000000000_REALK, &
     -0.010838445400662_REALK,      0.000000000000000_REALK,     -0.003692994427431_REALK, &
      0.000000000000000_REALK,     -0.000386367676881_REALK,      0.000000000000000_REALK, &
     -0.023999330110367_REALK,      0.000000000000000_REALK,     -0.018132985010745_REALK, &
      0.000000000000000_REALK,     -0.012055982389262_REALK,      0.000000000000000_REALK, &
     -0.027797147283877_REALK,      0.000000000000000_REALK,      0.005865070350653_REALK, &
      0.000000000000000_REALK,     -0.030194880662957_REALK,      0.000000000000000_REALK, &
     -0.010854071356478_REALK,      0.000000000000000_REALK,      0.027327565548779_REALK, &
      0.000000000000000_REALK,      0.077902010807715_REALK,      0.000000000000000_REALK, &
      0.005792945734547_REALK,      0.000000000000000_REALK,      0.019732831717494_REALK, &
      0.000000000000000_REALK,      0.002321142350917_REALK,      0.000000000000000_REALK, &
     -0.006199382524194_REALK,      0.000000000000000_REALK,      0.006629714232115_REALK, &
      0.000000000000000_REALK,     -0.063983973048694_REALK,      0.000000000000000_REALK, &
      0.010332462959227_REALK,      0.000000000000000_REALK,      0.011458168341492_REALK, &
      0.000000000000000_REALK,      0.045333506254432_REALK,      0.000000000000000_REALK, &
     -0.013663220616351_REALK,      0.000000000000000_REALK,     -0.005361486293175_REALK, &
      0.000000000000000_REALK,     -0.006395321603847_REALK,      0.000000000000000_REALK, &
      0.017164176790014_REALK,      0.000000000000000_REALK,     -0.048014056615892_REALK, &
      0.000000000000000_REALK,      0.009006021954928_REALK/
  ! results of test 3, ket-major order, SM04-01
  data REF_CONTR_INTS(1564:1706) /                                                         &
      0.000000000000000_REALK,      0.050216409925581_REALK,      0.000000000000000_REALK, &
     -0.016400975624234_REALK,      0.000000000000000_REALK,     -0.030378212012772_REALK, &
      0.000000000000000_REALK,      0.024303221440290_REALK,      0.000000000000000_REALK, &
     -0.025740007097069_REALK,      0.000000000000000_REALK,     -0.012924221686055_REALK, &
      0.000000000000000_REALK,      0.005701327684518_REALK,      0.000000000000000_REALK, &
     -0.003460939872239_REALK,      0.000000000000000_REALK,      0.019702949657532_REALK, &
      0.000000000000000_REALK,     -0.033612829986307_REALK,      0.000000000000000_REALK, &
      0.010945089166343_REALK,      0.000000000000000_REALK,     -0.001129637821343_REALK, &
      0.000000000000000_REALK,     -0.016164866623663_REALK,      0.000000000000000_REALK, &
     -0.007330930853043_REALK,      0.000000000000000_REALK,      0.011097280754458_REALK, &
      0.000000000000000_REALK,      0.002876940378393_REALK,      0.000000000000000_REALK, &
     -0.019081681055591_REALK,      0.000000000000000_REALK,     -0.014309790470663_REALK, &
      0.000000000000000_REALK,      0.004559210954678_REALK,      0.000000000000000_REALK, &
     -0.007512803468693_REALK,      0.000000000000000_REALK,      0.007921096470191_REALK, &
      0.000000000000000_REALK,      0.013350604560596_REALK,      0.000000000000000_REALK, &
      0.006040849478493_REALK,      0.000000000000000_REALK,      0.008156324853125_REALK, &
      0.000000000000000_REALK,     -0.025677188915487_REALK,      0.000000000000000_REALK, &
      0.020113769050707_REALK,      0.000000000000000_REALK,      0.005872517811558_REALK, &
      0.000000000000000_REALK,     -0.012820306941794_REALK,      0.000000000000000_REALK, &
      0.005054393430146_REALK,      0.000000000000000_REALK,      0.002939887449749_REALK, &
      0.000000000000000_REALK,     -0.023021185997746_REALK,      0.000000000000000_REALK, &
      0.009420683392337_REALK,      0.000000000000000_REALK,      0.019227646082975_REALK, &
      0.000000000000000_REALK,     -0.014481793298458_REALK,      0.000000000000000_REALK, &
     -0.011021400285348_REALK,      0.000000000000000_REALK,      0.025102067303383_REALK, &
      0.000000000000000_REALK,     -0.003551708506448_REALK,      0.000000000000000_REALK, &
     -0.008069032826853_REALK,      0.000000000000000_REALK,     -0.012112289407246_REALK, &
      0.000000000000000_REALK,     -0.001060084831162_REALK,      0.000000000000000_REALK, &
     -0.008235902461364_REALK,      0.000000000000000_REALK,     -0.016297113620745_REALK, &
      0.000000000000000_REALK,      0.000258697288103_REALK,      0.000000000000000_REALK, &
     -0.004821723021193_REALK,      0.000000000000000_REALK,      0.005374363352937_REALK, &
      0.000000000000000_REALK,      0.012298096623972_REALK,      0.000000000000000_REALK, &
      0.001313742569107_REALK,      0.000000000000000_REALK,     -0.012998243389499_REALK, &
      0.000000000000000_REALK,     -0.022882287103380_REALK,      0.000000000000000_REALK, &
      0.005317284679367_REALK,      0.000000000000000_REALK,      0.016917948647003_REALK, &
      0.000000000000000_REALK,      0.002054551778560_REALK,      0.000000000000000_REALK, &
     -0.036231609001961_REALK,      0.000000000000000_REALK,      0.025973136789616_REALK, &
      0.000000000000000_REALK,      0.014033802520672_REALK,      0.000000000000000_REALK, &
     -0.002716204196773_REALK,      0.000000000000000_REALK,     -0.004758923097799_REALK, &
      0.000000000000000_REALK,      0.000350543300731_REALK,      0.000000000000000_REALK, &
      0.005397657654586_REALK,      0.000000000000000_REALK,      0.006925191134925_REALK, &
      0.000000000000000_REALK,     -0.025370047732460_REALK,      0.000000000000000_REALK, &
     -0.029176347866800_REALK,      0.000000000000000_REALK,      0.016179200912742_REALK, &
      0.000000000000000_REALK,     -0.026551746240716_REALK,      0.000000000000000_REALK, &
      0.015042920514248_REALK,      0.000000000000000_REALK,      0.016750221763160_REALK, &
      0.000000000000000_REALK,     -0.002211425106878_REALK,      0.000000000000000_REALK, &
      0.005445357848335_REALK,      0.000000000000000_REALK,      0.004742628987644_REALK, &
      0.000000000000000_REALK,      0.009890517643205_REALK,      0.000000000000000_REALK, &
     -0.016240415462309_REALK,      0.000000000000000_REALK/
  ! results of test 3, ket-major order, SM04+00
  data REF_CONTR_INTS(1707:1849) /                                                         &
      0.025846754832962_REALK,      0.000000000000000_REALK,     -0.043862023236888_REALK, &
      0.000000000000000_REALK,      0.002537120073124_REALK,      0.000000000000000_REALK, &
     -0.032542039239916_REALK,      0.000000000000000_REALK,     -0.007050336366147_REALK, &
      0.000000000000000_REALK,      0.000011736376135_REALK,      0.000000000000000_REALK, &
      0.044316909220489_REALK,      0.000000000000000_REALK,     -0.017339977571244_REALK, &
      0.000000000000000_REALK,      0.007522567097519_REALK,      0.000000000000000_REALK, &
      0.085309849876391_REALK,      0.000000000000000_REALK,      0.017590390282004_REALK, &
      0.000000000000000_REALK,     -0.019327788904713_REALK,      0.000000000000000_REALK, &
     -0.010445862474902_REALK,      0.000000000000000_REALK,      0.013256845610596_REALK, &
      0.000000000000000_REALK,      0.004817560180362_REALK,      0.000000000000000_REALK, &
     -0.087816491885395_REALK,      0.000000000000000_REALK,     -0.015040381660386_REALK, &
      0.000000000000000_REALK,     -0.003023136760182_REALK,      0.000000000000000_REALK, &
     -0.026596893541750_REALK,      0.000000000000000_REALK,      0.013758258277416_REALK, &
      0.000000000000000_REALK,     -0.001878405092654_REALK,      0.000000000000000_REALK, &
      0.017931083799971_REALK,      0.000000000000000_REALK,      0.009106696502243_REALK, &
      0.000000000000000_REALK,     -0.023810980417646_REALK,      0.000000000000000_REALK, &
      0.002190610500009_REALK,      0.000000000000000_REALK,      0.001009819925769_REALK, &
      0.000000000000000_REALK,      0.001454404627061_REALK,      0.000000000000000_REALK, &
      0.001459208532630_REALK,      0.000000000000000_REALK,      0.009461376397035_REALK, &
      0.000000000000000_REALK,      0.032093346873243_REALK,      0.000000000000000_REALK, &
     -0.013146281170109_REALK,      0.000000000000000_REALK,      0.005936602748002_REALK, &
      0.000000000000000_REALK,     -0.000693023990642_REALK,      0.000000000000000_REALK, &
      0.012953020091421_REALK,      0.000000000000000_REALK,      0.018981706274528_REALK, &
      0.000000000000000_REALK,      0.012734461764152_REALK,      0.000000000000000_REALK, &
     -0.000768206846258_REALK,      0.000000000000000_REALK,      0.001907234468995_REALK, &
      0.000000000000000_REALK,      0.021205728197802_REALK,      0.000000000000000_REALK, &
     -0.024461189384619_REALK,      0.000000000000000_REALK,      0.037950502682209_REALK, &
      0.000000000000000_REALK,     -0.003118201606059_REALK,      0.000000000000000_REALK, &
      0.027435304780292_REALK,      0.000000000000000_REALK,      0.005080374670573_REALK, &
      0.000000000000000_REALK,     -0.033157079237184_REALK,      0.000000000000000_REALK, &
      0.000659774955203_REALK,      0.000000000000000_REALK,     -0.019114350942036_REALK, &
      0.000000000000000_REALK,     -0.000500306896458_REALK,      0.000000000000000_REALK, &
      0.036485207445624_REALK,      0.000000000000000_REALK,     -0.005858103816496_REALK, &
      0.000000000000000_REALK,      0.022010143075320_REALK,      0.000000000000000_REALK, &
      0.008753155538147_REALK,      0.000000000000000_REALK,     -0.012966533241970_REALK, &
      0.000000000000000_REALK,     -0.013356289672147_REALK,      0.000000000000000_REALK, &
     -0.011464760644858_REALK,      0.000000000000000_REALK,      0.011413730040326_REALK, &
      0.000000000000000_REALK,     -0.045141929784346_REALK,      0.000000000000000_REALK, &
     -0.008860738673743_REALK,      0.000000000000000_REALK,     -0.028076862649866_REALK, &
      0.000000000000000_REALK,     -0.032066339362136_REALK,      0.000000000000000_REALK, &
      0.034970462707431_REALK,      0.000000000000000_REALK,      0.028347075243899_REALK, &
      0.000000000000000_REALK,      0.061041099254862_REALK,      0.000000000000000_REALK, &
      0.015395659900689_REALK,      0.000000000000000_REALK,      0.017185128424258_REALK, &
      0.000000000000000_REALK,     -0.044060339927533_REALK,      0.000000000000000_REALK, &
     -0.039179010957887_REALK,      0.000000000000000_REALK,     -0.047152408511266_REALK, &
      0.000000000000000_REALK,     -0.045824116163147_REALK,      0.000000000000000_REALK, &
     -0.009019786470369_REALK,      0.000000000000000_REALK,      0.036242432707417_REALK, &
      0.000000000000000_REALK,      0.005375230657002_REALK/
  ! results of test 3, ket-major order, SM04+01
  data REF_CONTR_INTS(1850:1992) /                                                         &
      0.000000000000000_REALK,      0.054117048487269_REALK,      0.000000000000000_REALK, &
      0.004463986032417_REALK,      0.000000000000000_REALK,     -0.007139261447703_REALK, &
      0.000000000000000_REALK,      0.013127559481512_REALK,      0.000000000000000_REALK, &
     -0.028217231008161_REALK,      0.000000000000000_REALK,     -0.032849011009146_REALK, &
      0.000000000000000_REALK,     -0.060134782331424_REALK,      0.000000000000000_REALK, &
     -0.056073847226321_REALK,      0.000000000000000_REALK,      0.001447267233960_REALK, &
      0.000000000000000_REALK,     -0.051233704093839_REALK,      0.000000000000000_REALK, &
      0.007155380037295_REALK,      0.000000000000000_REALK,      0.007161851050889_REALK, &
      0.000000000000000_REALK,     -0.009713149954550_REALK,      0.000000000000000_REALK, &
      0.017238964034655_REALK,      0.000000000000000_REALK,      0.040407603085771_REALK, &
      0.000000000000000_REALK,      0.001054541237488_REALK,      0.000000000000000_REALK, &
      0.016058962163433_REALK,      0.000000000000000_REALK,     -0.011818678471364_REALK, &
      0.000000000000000_REALK,      0.042003671592326_REALK,      0.000000000000000_REALK, &
      0.012057306748935_REALK,      0.000000000000000_REALK,      0.037082166247051_REALK, &
      0.000000000000000_REALK,      0.012407741015757_REALK,      0.000000000000000_REALK, &
      0.006597136884323_REALK,      0.000000000000000_REALK,      0.034040036950367_REALK, &
      0.000000000000000_REALK,     -0.052133765335808_REALK,      0.000000000000000_REALK, &
     -0.005768958849663_REALK,      0.000000000000000_REALK,     -0.020818642356907_REALK, &
      0.000000000000000_REALK,     -0.005934837755403_REALK,      0.000000000000000_REALK, &
      0.000190434399799_REALK,      0.000000000000000_REALK,     -0.011321449972946_REALK, &
      0.000000000000000_REALK,     -0.018419708891012_REALK,      0.000000000000000_REALK, &
      0.004605445932498_REALK,      0.000000000000000_REALK,      0.002245006459629_REALK, &
      0.000000000000000_REALK,      0.032287042420287_REALK,      0.000000000000000_REALK, &
     -0.014935769753097_REALK,      0.000000000000000_REALK,      0.040928845082113_REALK, &
      0.000000000000000_REALK,     -0.004228414013136_REALK,      0.000000000000000_REALK, &
     -0.011108800334923_REALK,      0.000000000000000_REALK,      0.040161689237232_REALK, &
      0.000000000000000_REALK,      0.005165364339273_REALK,      0.000000000000000_REALK, &
     -0.027731938068068_REALK,      0.000000000000000_REALK,     -0.006951461840969_REALK, &
      0.000000000000000_REALK,      0.014356743106292_REALK,      0.000000000000000_REALK, &
      0.025958965220311_REALK,      0.000000000000000_REALK,     -0.058286741567284_REALK, &
      0.000000000000000_REALK,      0.002840579953584_REALK,      0.000000000000000_REALK, &
     -0.021908895703811_REALK,      0.000000000000000_REALK,     -0.022416741692115_REALK, &
      0.000000000000000_REALK,      0.009161430413344_REALK,      0.000000000000000_REALK, &
     -0.033249716425542_REALK,      0.000000000000000_REALK,      0.038041897485030_REALK, &
      0.000000000000000_REALK,      0.042590262038147_REALK,      0.000000000000000_REALK, &
     -0.021714540059311_REALK,      0.000000000000000_REALK,      0.024462097927501_REALK, &
      0.000000000000000_REALK,     -0.028823669805767_REALK,      0.000000000000000_REALK, &
      0.018903355876602_REALK,      0.000000000000000_REALK,      0.009822345965969_REALK, &
      0.000000000000000_REALK,      0.018218402882050_REALK,      0.000000000000000_REALK, &
      0.020309436132769_REALK,      0.000000000000000_REALK,     -0.009378443396006_REALK, &
      0.000000000000000_REALK,      0.046303954699984_REALK,      0.000000000000000_REALK, &
     -0.061780988728323_REALK,      0.000000000000000_REALK,     -0.050743218289672_REALK, &
      0.000000000000000_REALK,     -0.007800549211167_REALK,      0.000000000000000_REALK, &
      0.027798195638268_REALK,      0.000000000000000_REALK,      0.047075507480051_REALK, &
      0.000000000000000_REALK,     -0.003809744618967_REALK,      0.000000000000000_REALK, &
      0.005034066027170_REALK,      0.000000000000000_REALK,     -0.049792811155072_REALK, &
      0.000000000000000_REALK,     -0.062545137870065_REALK,      0.000000000000000_REALK, &
     -0.103066382555602_REALK,      0.000000000000000_REALK/
  ! results of test 3, ket-major order, SM04+02
  data REF_CONTR_INTS(1993:2135) /                                                         &
      0.013964771412251_REALK,      0.000000000000000_REALK,      0.003159108446302_REALK, &
      0.000000000000000_REALK,      0.013390238105268_REALK,      0.000000000000000_REALK, &
     -0.016756940250811_REALK,      0.000000000000000_REALK,      0.043962012753924_REALK, &
      0.000000000000000_REALK,      0.013840504859607_REALK,      0.000000000000000_REALK, &
     -0.029605788034673_REALK,      0.000000000000000_REALK,      0.025401461155206_REALK, &
      0.000000000000000_REALK,     -0.049126503376799_REALK,      0.000000000000000_REALK, &
     -0.048253526670908_REALK,      0.000000000000000_REALK,     -0.024175295500585_REALK, &
      0.000000000000000_REALK,      0.038316412881369_REALK,      0.000000000000000_REALK, &
     -0.018132391131534_REALK,      0.000000000000000_REALK,      0.000118503490923_REALK, &
      0.000000000000000_REALK,      0.013437684143339_REALK,      0.000000000000000_REALK, &
      0.059585619102219_REALK,      0.000000000000000_REALK,     -0.010553462776773_REALK, &
      0.000000000000000_REALK,     -0.010018000693914_REALK,      0.000000000000000_REALK, &
      0.049025852858512_REALK,      0.000000000000000_REALK,     -0.019282780443171_REALK, &
      0.000000000000000_REALK,     -0.006724935783899_REALK,      0.000000000000000_REALK, &
     -0.024677404281314_REALK,      0.000000000000000_REALK,     -0.003141193797881_REALK, &
      0.000000000000000_REALK,     -0.006625117448575_REALK,      0.000000000000000_REALK, &
      0.011743092580063_REALK,      0.000000000000000_REALK,      0.004233842506572_REALK, &
      0.000000000000000_REALK,     -0.019098810555114_REALK,      0.000000000000000_REALK, &
     -0.003637219763977_REALK,      0.000000000000000_REALK,     -0.001405112955117_REALK, &
      0.000000000000000_REALK,     -0.014877509776076_REALK,      0.000000000000000_REALK, &
      0.016825943709097_REALK,      0.000000000000000_REALK,     -0.004878812654805_REALK, &
      0.000000000000000_REALK,      0.033531598064447_REALK,      0.000000000000000_REALK, &
     -0.036722750833067_REALK,      0.000000000000000_REALK,     -0.005934095637929_REALK, &
      0.000000000000000_REALK,     -0.034331726644779_REALK,      0.000000000000000_REALK, &
      0.001373128395112_REALK,      0.000000000000000_REALK,     -0.001540834119891_REALK, &
      0.000000000000000_REALK,     -0.001916036410946_REALK,      0.000000000000000_REALK, &
      0.042053945825322_REALK,      0.000000000000000_REALK,     -0.034629648012022_REALK, &
      0.000000000000000_REALK,     -0.005210358420394_REALK,      0.000000000000000_REALK, &
     -0.028932399315277_REALK,      0.000000000000000_REALK,     -0.008236168436399_REALK, &
      0.000000000000000_REALK,      0.017779737824621_REALK,      0.000000000000000_REALK, &
      0.015872818329379_REALK,      0.000000000000000_REALK,      0.031001915022155_REALK, &
      0.000000000000000_REALK,      0.000607849895146_REALK,      0.000000000000000_REALK, &
     -0.012247014878064_REALK,      0.000000000000000_REALK,      0.032067442016009_REALK, &
      0.000000000000000_REALK,     -0.038130060489025_REALK,      0.000000000000000_REALK, &
      0.013049925961984_REALK,      0.000000000000000_REALK,      0.024276720969089_REALK, &
      0.000000000000000_REALK,      0.027311324729402_REALK,      0.000000000000000_REALK, &
      0.032239651805011_REALK,      0.000000000000000_REALK,     -0.048488596959509_REALK, &
      0.000000000000000_REALK,      0.032514695333002_REALK,      0.000000000000000_REALK, &
     -0.001976373995285_REALK,      0.000000000000000_REALK,      0.015641938688819_REALK, &
      0.000000000000000_REALK,      0.024696140528039_REALK,      0.000000000000000_REALK, &
     -0.022517150466501_REALK,      0.000000000000000_REALK,     -0.037933808237547_REALK, &
      0.000000000000000_REALK,     -0.034466729922268_REALK,      0.000000000000000_REALK, &
     -0.001923647823648_REALK,      0.000000000000000_REALK,     -0.048950453773207_REALK, &
      0.000000000000000_REALK,     -0.010624456582908_REALK,      0.000000000000000_REALK, &
      0.055976282542347_REALK,      0.000000000000000_REALK,      0.067972513496657_REALK, &
      0.000000000000000_REALK,      0.054426785166756_REALK,      0.000000000000000_REALK, &
      0.003392807161226_REALK,      0.000000000000000_REALK,     -0.014854449715692_REALK, &
      0.000000000000000_REALK,     -0.004126317893529_REALK/
  ! results of test 3, ket-major order, SM04+03
  data REF_CONTR_INTS(2136:2278) /                                                         &
      0.000000000000000_REALK,     -0.002857276836562_REALK,      0.000000000000000_REALK, &
     -0.028655197951964_REALK,      0.000000000000000_REALK,     -0.027939901117359_REALK, &
      0.000000000000000_REALK,      0.044296917654367_REALK,      0.000000000000000_REALK, &
      0.010823294837966_REALK,      0.000000000000000_REALK,      0.005389401137585_REALK, &
      0.000000000000000_REALK,      0.072309231415218_REALK,      0.000000000000000_REALK, &
      0.079251762678204_REALK,      0.000000000000000_REALK,      0.053735596970396_REALK, &
      0.000000000000000_REALK,      0.008807724940721_REALK,      0.000000000000000_REALK, &
     -0.039541779371940_REALK,      0.000000000000000_REALK,     -0.034245173896538_REALK, &
      0.000000000000000_REALK,      0.020620053636913_REALK,      0.000000000000000_REALK, &
     -0.097969675626387_REALK,      0.000000000000000_REALK,     -0.027103166261688_REALK, &
      0.000000000000000_REALK,      0.011472163651551_REALK,      0.000000000000000_REALK, &
     -0.014283771255746_REALK,      0.000000000000000_REALK,     -0.035578493358559_REALK, &
      0.000000000000000_REALK,     -0.023137125432694_REALK,      0.000000000000000_REALK, &
     -0.001912623090591_REALK,      0.000000000000000_REALK,      0.018149619518171_REALK, &
      0.000000000000000_REALK,      0.017624889276982_REALK,      0.000000000000000_REALK, &
      0.036139012272455_REALK,      0.000000000000000_REALK,     -0.019319733527786_REALK, &
      0.000000000000000_REALK,     -0.002817532052053_REALK,      0.000000000000000_REALK, &
      0.061151161055936_REALK,      0.000000000000000_REALK,      0.040554570154195_REALK, &
      0.000000000000000_REALK,     -0.015421037412151_REALK,      0.000000000000000_REALK, &
     -0.015284859434206_REALK,      0.000000000000000_REALK,      0.016468548787405_REALK, &
      0.000000000000000_REALK,     -0.018447028667630_REALK,      0.000000000000000_REALK, &
     -0.034061376217678_REALK,      0.000000000000000_REALK,      0.006063087592374_REALK, &
      0.000000000000000_REALK,     -0.044828284924580_REALK,      0.000000000000000_REALK, &
      0.001471937599069_REALK,      0.000000000000000_REALK,     -0.001615397182795_REALK, &
      0.000000000000000_REALK,     -0.034835749335698_REALK,      0.000000000000000_REALK, &
     -0.003102693670700_REALK,      0.000000000000000_REALK,     -0.041435038996146_REALK, &
      0.000000000000000_REALK,     -0.011784208270019_REALK,      0.000000000000000_REALK, &
      0.021095174209538_REALK,      0.000000000000000_REALK,     -0.024010700171273_REALK, &
      0.000000000000000_REALK,     -0.070784826078456_REALK,      0.000000000000000_REALK, &
     -0.006761684805667_REALK,      0.000000000000000_REALK,      0.067172971163931_REALK, &
      0.000000000000000_REALK,      0.022242745678212_REALK,      0.000000000000000_REALK, &
      0.043405339980598_REALK,      0.000000000000000_REALK,      0.020169342534394_REALK, &
      0.000000000000000_REALK,     -0.063348630273581_REALK,      0.000000000000000_REALK, &
      0.029959452335557_REALK,      0.000000000000000_REALK,     -0.045577521185123_REALK, &
      0.000000000000000_REALK,     -0.022454004850859_REALK,      0.000000000000000_REALK, &
     -0.023229718596044_REALK,      0.000000000000000_REALK,      0.037338945878490_REALK, &
      0.000000000000000_REALK,      0.035992378901512_REALK,      0.000000000000000_REALK, &
     -0.040716926352582_REALK,      0.000000000000000_REALK,     -0.012314252334981_REALK, &
      0.000000000000000_REALK,     -0.048839659360403_REALK,      0.000000000000000_REALK, &
      0.011146620656449_REALK,      0.000000000000000_REALK,      0.031800539261902_REALK, &
      0.000000000000000_REALK,     -0.068463292243075_REALK,      0.000000000000000_REALK, &
      0.032117188997260_REALK,      0.000000000000000_REALK,      0.088423932104935_REALK, &
      0.000000000000000_REALK,     -0.062581971675660_REALK,      0.000000000000000_REALK, &
      0.017422284764712_REALK,      0.000000000000000_REALK,     -0.012875812571057_REALK, &
      0.000000000000000_REALK,      0.009394162384795_REALK,      0.000000000000000_REALK, &
     -0.002993526916908_REALK,      0.000000000000000_REALK,      0.047429451556294_REALK, &
      0.000000000000000_REALK,      0.077510139901666_REALK,      0.000000000000000_REALK, &
      0.047167242564500_REALK,      0.000000000000000_REALK/
  ! results of test 3, ket-major order, SM04+04
  data REF_CONTR_INTS(2279:2421) /                                                         &
     -0.021379748763863_REALK,      0.000000000000000_REALK,     -0.003465878382675_REALK, &
      0.000000000000000_REALK,      0.018942372344782_REALK,      0.000000000000000_REALK, &
     -0.008487763178009_REALK,      0.000000000000000_REALK,     -0.015522805862073_REALK, &
      0.000000000000000_REALK,     -0.038584742059904_REALK,      0.000000000000000_REALK, &
     -0.047073645538935_REALK,      0.000000000000000_REALK,     -0.022735480258032_REALK, &
      0.000000000000000_REALK,      0.010734017072786_REALK,      0.000000000000000_REALK, &
      0.014798252453313_REALK,      0.000000000000000_REALK,      0.079355678125577_REALK, &
      0.000000000000000_REALK,      0.015992504432289_REALK,      0.000000000000000_REALK, &
      0.034323879259098_REALK,      0.000000000000000_REALK,      0.052210501706978_REALK, &
      0.000000000000000_REALK,      0.027142219555127_REALK,      0.000000000000000_REALK, &
      0.025751835248654_REALK,      0.000000000000000_REALK,      0.014906459812222_REALK, &
      0.000000000000000_REALK,      0.018577383587912_REALK,      0.000000000000000_REALK, &
      0.023340289707058_REALK,      0.000000000000000_REALK,     -0.012250243067490_REALK, &
      0.000000000000000_REALK,     -0.048112144492828_REALK,      0.000000000000000_REALK, &
     -0.017150073159122_REALK,      0.000000000000000_REALK,     -0.006019470907876_REALK, &
      0.000000000000000_REALK,     -0.046141946712863_REALK,      0.000000000000000_REALK, &
     -0.024864174185569_REALK,      0.000000000000000_REALK,      0.001045437240204_REALK, &
      0.000000000000000_REALK,     -0.053889927753518_REALK,      0.000000000000000_REALK, &
      0.001820034242058_REALK,      0.000000000000000_REALK,     -0.015261961798481_REALK, &
      0.000000000000000_REALK,      0.008515038271807_REALK,      0.000000000000000_REALK, &
      0.008463674833062_REALK,      0.000000000000000_REALK,      0.023327595051391_REALK, &
      0.000000000000000_REALK,      0.002609288143947_REALK,      0.000000000000000_REALK, &
      0.013013950887474_REALK,      0.000000000000000_REALK,      0.081156747732641_REALK, &
      0.000000000000000_REALK,      0.068178111971048_REALK,      0.000000000000000_REALK, &
      0.007207181122329_REALK,      0.000000000000000_REALK,      0.035929616986199_REALK, &
      0.000000000000000_REALK,     -0.011932692383718_REALK,      0.000000000000000_REALK, &
     -0.005267704491893_REALK,      0.000000000000000_REALK,     -0.010662966579053_REALK, &
      0.000000000000000_REALK,      0.063135725556379_REALK,      0.000000000000000_REALK, &
      0.107466318475242_REALK,      0.000000000000000_REALK,      0.061352547900000_REALK, &
      0.000000000000000_REALK,     -0.035967977602246_REALK,      0.000000000000000_REALK, &
     -0.081941861224460_REALK,      0.000000000000000_REALK,     -0.104749780342598_REALK, &
      0.000000000000000_REALK,     -0.007089855009924_REALK,      0.000000000000000_REALK, &
     -0.022473542023436_REALK,      0.000000000000000_REALK,      0.012062201381864_REALK, &
      0.000000000000000_REALK,      0.000593238174253_REALK,      0.000000000000000_REALK, &
      0.029150335175767_REALK,      0.000000000000000_REALK,     -0.069398889538224_REALK, &
      0.000000000000000_REALK,     -0.068391282874932_REALK,      0.000000000000000_REALK, &
     -0.092757203191679_REALK,      0.000000000000000_REALK,      0.031959903731842_REALK, &
      0.000000000000000_REALK,      0.061606776714858_REALK,      0.000000000000000_REALK, &
      0.082600046081799_REALK,      0.000000000000000_REALK,      0.023870324620121_REALK, &
      0.000000000000000_REALK,     -0.017924087684502_REALK,      0.000000000000000_REALK, &
     -0.005247602320292_REALK,      0.000000000000000_REALK,     -0.004616996845246_REALK, &
      0.000000000000000_REALK,      0.004048980576818_REALK,      0.000000000000000_REALK, &
      0.051967018750058_REALK,      0.000000000000000_REALK,      0.084283523478597_REALK, &
      0.000000000000000_REALK,      0.077832845452548_REALK,      0.000000000000000_REALK, &
     -0.112410420716582_REALK,      0.000000000000000_REALK,     -0.050108655764542_REALK, &
      0.000000000000000_REALK,     -0.036110010814345_REALK,      0.000000000000000_REALK, &
     -0.000837267343735_REALK,      0.000000000000000_REALK,     -0.012914620480295_REALK, &
      0.000000000000000_REALK,      0.027146840528582_REALK/
