  ! results of water molecule using cc-pV6Z basis sets
  !
  ! number of test cases
  integer, parameter :: NUM_TESTS = 3
  ! ID of block of sub-shells on bra center
  integer, parameter :: BRA_BLOCK(NUM_TESTS) = (/1, 13, 13/)
  ! ID of block of sub-shells on ket center
  integer, parameter :: KET_BLOCK(NUM_TESTS) = (/1, 1, 7/)
  ! coordinates of dipole origin
  real(REALK), parameter :: DIP_ORIGIN(3) = (/0.0_REALK, 0.0_REALK, 0.0_REALK/)
  ! orders of Cartesian multipole integrals
  integer, parameter :: ORDER_MOM = 4
  ! referenced results from Dalton
  real(REALK) REF_CONTR_INTS(4035)
  ! results of test 1, ket-major order, CM040000
  data REF_CONTR_INTS(1:49) /                                                              &
      0.001473278646187_REALK,      0.005940632495116_REALK,      0.003404887200033_REALK, &
      0.005450447378042_REALK,      0.006076775328851_REALK,      0.005667198284414_REALK, &
      0.004592081882060_REALK,      0.005940632495116_REALK,      0.988388582066790_REALK, &
      0.014433316948670_REALK,      0.100876530415392_REALK,      0.395470415033860_REALK, &
      1.147668624762451_REALK,      2.266391757685122_REALK,      0.003404887200033_REALK, &
      0.014433316948670_REALK,      0.009288133198666_REALK,      0.016187413212651_REALK, &
      0.016379030417031_REALK,      0.012178386889356_REALK,      0.007530918974364_REALK, &
      0.005450447378042_REALK,      0.100876530415392_REALK,      0.016187413212651_REALK, &
      0.055562651111890_REALK,      0.093765542363761_REALK,      0.099244891812071_REALK, &
      0.074571834062396_REALK,      0.006076775328851_REALK,      0.395470415033860_REALK, &
      0.016379030417031_REALK,      0.093765542363761_REALK,      0.268987655704581_REALK, &
      0.459456173499678_REALK,      0.475465736765610_REALK,      0.005667198284414_REALK, &
      1.147668624762451_REALK,      0.012178386889356_REALK,      0.099244891812071_REALK, &
      0.459456173499678_REALK,      1.401244334862570_REALK,      2.408736235140004_REALK, &
      0.004592081882060_REALK,      2.266391757685122_REALK,      0.007530918974364_REALK, &
      0.074571834062396_REALK,      0.475465736765610_REALK,      2.408736235140004_REALK, &
      7.606799464481321_REALK/
  ! results of test 1, ket-major order, CM030100
  data REF_CONTR_INTS(50:98) /                                                             &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK/
  ! results of test 1, ket-major order, CM020200
  data REF_CONTR_INTS(99:147) /                                                            &
      0.001387176505413_REALK,      0.002723924028511_REALK,      0.002506116883970_REALK, &
      0.003210577872165_REALK,      0.003156766891276_REALK,      0.002666064901667_REALK, &
      0.002007649645748_REALK,      0.002723924028511_REALK,      0.356123025968071_REALK, &
      0.007059400223562_REALK,      0.041670753760255_REALK,      0.149573179984659_REALK, &
      0.412347664953296_REALK,      0.792245493467605_REALK,      0.002506116883970_REALK, &
      0.007059400223562_REALK,      0.005910570368069_REALK,      0.008851150659852_REALK, &
      0.008402435593452_REALK,      0.006054858771072_REALK,      0.003691201474573_REALK, &
      0.003210577872165_REALK,      0.041670753760255_REALK,      0.008851150659852_REALK, &
      0.025404751519169_REALK,      0.039703569369955_REALK,      0.040453771747018_REALK, &
      0.029871578894492_REALK,      0.003156766891276_REALK,      0.149573179984659_REALK, &
      0.008402435593452_REALK,      0.039703569369955_REALK,      0.104808875025891_REALK, &
      0.171755315994011_REALK,      0.174392255209655_REALK,      0.002666064901667_REALK, &
      0.412347664953296_REALK,      0.006054858771072_REALK,      0.040453771747018_REALK, &
      0.171755315994011_REALK,      0.501651333353676_REALK,      0.845377479990781_REALK, &
      0.002007649645748_REALK,      0.792245493467605_REALK,      0.003691201474573_REALK, &
      0.029871578894492_REALK,      0.174392255209655_REALK,      0.845377479990781_REALK, &
      2.616145459560855_REALK/
  ! results of test 1, ket-major order, CM010300
  data REF_CONTR_INTS(148:196) /                                                           &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK/
  ! results of test 1, ket-major order, CM000400
  data REF_CONTR_INTS(197:245) /                                                           &
      0.009408385950400_REALK,      0.010402911669491_REALK,      0.013704524904190_REALK, &
      0.015268745213232_REALK,      0.013811118606277_REALK,      0.010888128898904_REALK, &
      0.007764210975261_REALK,      0.010402911669491_REALK,      1.150908179305748_REALK, &
      0.028645507816389_REALK,      0.150803433561685_REALK,      0.504255103013543_REALK, &
      1.328852331660229_REALK,      2.489133649369560_REALK,      0.013704524904190_REALK, &
      0.028645507816389_REALK,      0.028733894573859_REALK,      0.039132213234515_REALK, &
      0.035621726351648_REALK,      0.025131587038069_REALK,      0.015171805086903_REALK, &
      0.015268745213232_REALK,      0.150803433561685_REALK,      0.039132213234515_REALK, &
      0.099424463567232_REALK,      0.146739503892136_REALK,      0.145120597986218_REALK, &
      0.105669142383489_REALK,      0.013811118606277_REALK,      0.504255103013543_REALK, &
      0.035621726351648_REALK,      0.146739503892136_REALK,      0.362424200014878_REALK, &
      0.573335445376982_REALK,      0.572483662921374_REALK,      0.010888128898904_REALK, &
      1.328852331660229_REALK,      0.025131587038069_REALK,      0.145120597986218_REALK, &
      0.573335445376982_REALK,      1.611222270823596_REALK,      2.665774607198972_REALK, &
      0.007764210975261_REALK,      2.489133649369560_REALK,      0.015171805086903_REALK, &
      0.105669142383489_REALK,      0.572483662921374_REALK,      2.665774607198972_REALK, &
      8.092631898447923_REALK/
  ! results of test 1, ket-major order, CM030001
  data REF_CONTR_INTS(246:294) /                                                           &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK/
  ! results of test 1, ket-major order, CM020101
  data REF_CONTR_INTS(295:343) /                                                           &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK/
  ! results of test 1, ket-major order, CM010201
  data REF_CONTR_INTS(344:392) /                                                           &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK/
  ! results of test 1, ket-major order, CM000301
  data REF_CONTR_INTS(393:441) /                                                           &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK/
  ! results of test 1, ket-major order, CM020002
  data REF_CONTR_INTS(442:490) /                                                           &
      0.000491092882062_REALK,      0.001980210831705_REALK,      0.001134962400011_REALK, &
      0.001816815792681_REALK,      0.002025591776284_REALK,      0.001889066094805_REALK, &
      0.001530693960687_REALK,      0.001980210831705_REALK,      0.329462860688930_REALK, &
      0.004811105649557_REALK,      0.033625510138464_REALK,      0.131823471677953_REALK, &
      0.382556208254150_REALK,      0.755463919228374_REALK,      0.001134962400011_REALK, &
      0.004811105649557_REALK,      0.003096044399555_REALK,      0.005395804404217_REALK, &
      0.005459676805677_REALK,      0.004059462296452_REALK,      0.002510306324788_REALK, &
      0.001816815792681_REALK,      0.033625510138464_REALK,      0.005395804404217_REALK, &
      0.018520883703963_REALK,      0.031255180787920_REALK,      0.033081630604024_REALK, &
      0.024857278020799_REALK,      0.002025591776284_REALK,      0.131823471677953_REALK, &
      0.005459676805677_REALK,      0.031255180787920_REALK,      0.089662551901527_REALK, &
      0.153152057833226_REALK,      0.158488578921870_REALK,      0.001889066094805_REALK, &
      0.382556208254150_REALK,      0.004059462296452_REALK,      0.033081630604024_REALK, &
      0.153152057833226_REALK,      0.467081444954190_REALK,      0.802912078380001_REALK, &
      0.001530693960687_REALK,      0.755463919228374_REALK,      0.002510306324788_REALK, &
      0.024857278020799_REALK,      0.158488578921870_REALK,      0.802912078380001_REALK, &
      2.535599821493773_REALK/
  ! results of test 1, ket-major order, CM010102
  data REF_CONTR_INTS(491:539) /                                                           &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK/
  ! results of test 1, ket-major order, CM000202
  data REF_CONTR_INTS(540:588) /                                                           &
      0.001387176505413_REALK,      0.002723924028511_REALK,      0.002506116883970_REALK, &
      0.003210577872165_REALK,      0.003156766891276_REALK,      0.002666064901667_REALK, &
      0.002007649645748_REALK,      0.002723924028511_REALK,      0.356123025968071_REALK, &
      0.007059400223562_REALK,      0.041670753760255_REALK,      0.149573179984659_REALK, &
      0.412347664953296_REALK,      0.792245493467605_REALK,      0.002506116883970_REALK, &
      0.007059400223562_REALK,      0.005910570368069_REALK,      0.008851150659852_REALK, &
      0.008402435593452_REALK,      0.006054858771072_REALK,      0.003691201474573_REALK, &
      0.003210577872165_REALK,      0.041670753760255_REALK,      0.008851150659852_REALK, &
      0.025404751519169_REALK,      0.039703569369955_REALK,      0.040453771747018_REALK, &
      0.029871578894492_REALK,      0.003156766891276_REALK,      0.149573179984659_REALK, &
      0.008402435593452_REALK,      0.039703569369955_REALK,      0.104808875025891_REALK, &
      0.171755315994011_REALK,      0.174392255209655_REALK,      0.002666064901667_REALK, &
      0.412347664953296_REALK,      0.006054858771072_REALK,      0.040453771747018_REALK, &
      0.171755315994011_REALK,      0.501651333353676_REALK,      0.845377479990781_REALK, &
      0.002007649645748_REALK,      0.792245493467605_REALK,      0.003691201474573_REALK, &
      0.029871578894492_REALK,      0.174392255209655_REALK,      0.845377479990781_REALK, &
      2.616145459560855_REALK/
  ! results of test 1, ket-major order, CM010003
  data REF_CONTR_INTS(589:637) /                                                           &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK/
  ! results of test 1, ket-major order, CM000103
  data REF_CONTR_INTS(638:686) /                                                           &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK/
  ! results of test 1, ket-major order, CM000004
  data REF_CONTR_INTS(687:735) /                                                           &
      0.001473278646187_REALK,      0.005940632495116_REALK,      0.003404887200033_REALK, &
      0.005450447378042_REALK,      0.006076775328851_REALK,      0.005667198284414_REALK, &
      0.004592081882060_REALK,      0.005940632495116_REALK,      0.988388582066790_REALK, &
      0.014433316948670_REALK,      0.100876530415392_REALK,      0.395470415033860_REALK, &
      1.147668624762451_REALK,      2.266391757685122_REALK,      0.003404887200033_REALK, &
      0.014433316948670_REALK,      0.009288133198666_REALK,      0.016187413212651_REALK, &
      0.016379030417031_REALK,      0.012178386889356_REALK,      0.007530918974364_REALK, &
      0.005450447378042_REALK,      0.100876530415392_REALK,      0.016187413212651_REALK, &
      0.055562651111890_REALK,      0.093765542363761_REALK,      0.099244891812071_REALK, &
      0.074571834062396_REALK,      0.006076775328851_REALK,      0.395470415033860_REALK, &
      0.016379030417031_REALK,      0.093765542363761_REALK,      0.268987655704581_REALK, &
      0.459456173499678_REALK,      0.475465736765610_REALK,      0.005667198284414_REALK, &
      1.147668624762451_REALK,      0.012178386889356_REALK,      0.099244891812071_REALK, &
      0.459456173499678_REALK,      1.401244334862570_REALK,      2.408736235140004_REALK, &
      0.004592081882060_REALK,      2.266391757685122_REALK,      0.007530918974364_REALK, &
      0.074571834062396_REALK,      0.475465736765610_REALK,      2.408736235140004_REALK, &
      7.606799464481321_REALK/
  ! results of test 2, ket-major order, CM040000
  data REF_CONTR_INTS(736:812) /                                                           &
      0.001018509799452_REALK,      0.000000000000000_REALK,      0.000158909656631_REALK, &
      0.000000000000000_REALK,     -0.000512031278719_REALK,      0.000000000000000_REALK, &
     -0.000354245568247_REALK,      0.000000000000000_REALK,     -0.000677826853885_REALK, &
      0.000000000000000_REALK,     -0.000172007382339_REALK,     -0.005473294513392_REALK, &
      0.000000000000000_REALK,     -0.002026873371189_REALK,      0.000000000000000_REALK, &
     -0.000814467432235_REALK,      0.000000000000000_REALK,      0.000704937914343_REALK, &
      0.000000000000000_REALK,     -0.000648783253608_REALK,      0.000000000000000_REALK, &
      0.005330622630341_REALK,      0.004296970896521_REALK,      0.000000000000000_REALK, &
      0.000826458379569_REALK,      0.000000000000000_REALK,     -0.001913634538619_REALK, &
      0.000000000000000_REALK,     -0.001372768002743_REALK,      0.000000000000000_REALK, &
     -0.002623858381057_REALK,      0.000000000000000_REALK,      0.000073619934783_REALK, &
      0.002202770363376_REALK,      0.000000000000000_REALK,     -0.004291077132982_REALK, &
      0.000000000000000_REALK,     -0.003278472338614_REALK,      0.000000000000000_REALK, &
     -0.000662642763392_REALK,      0.000000000000000_REALK,     -0.004045368623718_REALK, &
      0.000000000000000_REALK,     -0.015991414462856_REALK,     -0.022369646020687_REALK, &
      0.000000000000000_REALK,     -0.000264340231698_REALK,      0.000000000000000_REALK, &
     -0.001476985753498_REALK,      0.000000000000000_REALK,     -0.000556179525226_REALK, &
      0.000000000000000_REALK,      0.001839570788390_REALK,      0.000000000000000_REALK, &
      0.003405345710421_REALK,      0.008433906912397_REALK,      0.000000000000000_REALK, &
     -0.002043561844438_REALK,      0.000000000000000_REALK,      0.000026897828509_REALK, &
      0.000000000000000_REALK,      0.002225262632792_REALK,      0.000000000000000_REALK, &
     -0.003253994437486_REALK,      0.000000000000000_REALK,      0.015136513333483_REALK, &
      0.006677359015106_REALK,      0.000000000000000_REALK,     -0.001975622630084_REALK, &
      0.000000000000000_REALK,      0.000444120664812_REALK,      0.000000000000000_REALK, &
     -0.000988881954528_REALK,      0.000000000000000_REALK,      0.001925064386155_REALK, &
      0.000000000000000_REALK,     -0.004133932866434_REALK/
  ! results of test 2, ket-major order, CM030100
  data REF_CONTR_INTS(813:889) /                                                           &
     -0.000225983031099_REALK,      0.000000000000000_REALK,      0.000065608716214_REALK, &
      0.000000000000000_REALK,      0.000150465305869_REALK,      0.000000000000000_REALK, &
      0.000066890215863_REALK,      0.000000000000000_REALK,      0.000199668574931_REALK, &
      0.000000000000000_REALK,      0.000331363483667_REALK,      0.006491289969023_REALK, &
      0.000000000000000_REALK,      0.002379147548564_REALK,      0.000000000000000_REALK, &
      0.001367631099541_REALK,      0.000000000000000_REALK,      0.000331544260234_REALK, &
      0.000000000000000_REALK,     -0.000066636184856_REALK,      0.000000000000000_REALK, &
     -0.002787841260570_REALK,     -0.000942861895237_REALK,      0.000000000000000_REALK, &
      0.000267955647452_REALK,      0.000000000000000_REALK,      0.000396208213714_REALK, &
      0.000000000000000_REALK,      0.000133055603394_REALK,      0.000000000000000_REALK, &
      0.000609076307580_REALK,      0.000000000000000_REALK,      0.001132603972131_REALK, &
      0.000762004220765_REALK,      0.000000000000000_REALK,      0.001507023483364_REALK, &
      0.000000000000000_REALK,      0.002627818153281_REALK,      0.000000000000000_REALK, &
      0.001135897983507_REALK,      0.000000000000000_REALK,      0.002650938972343_REALK, &
      0.000000000000000_REALK,      0.006903548828488_REALK,      0.011308634048093_REALK, &
      0.000000000000000_REALK,      0.004241754260479_REALK,      0.000000000000000_REALK, &
      0.001734319061050_REALK,      0.000000000000000_REALK,     -0.000965862974959_REALK, &
      0.000000000000000_REALK,      0.001056837537237_REALK,      0.000000000000000_REALK, &
      0.003167597239702_REALK,      0.004544368969779_REALK,      0.000000000000000_REALK, &
      0.000455432684009_REALK,      0.000000000000000_REALK,      0.000591694670823_REALK, &
      0.000000000000000_REALK,      0.001029159015000_REALK,      0.000000000000000_REALK, &
     -0.001568532587714_REALK,      0.000000000000000_REALK,     -0.010644523090788_REALK, &
     -0.005912659634052_REALK,      0.000000000000000_REALK,      0.000863778977106_REALK, &
      0.000000000000000_REALK,      0.000083521871520_REALK,      0.000000000000000_REALK, &
      0.001222187164254_REALK,      0.000000000000000_REALK,     -0.001090732523744_REALK, &
      0.000000000000000_REALK,     -0.002584344143855_REALK/
  ! results of test 2, ket-major order, CM020200
  data REF_CONTR_INTS(890:966) /                                                           &
      0.000053575567302_REALK,      0.000000000000000_REALK,      0.000036106521146_REALK, &
      0.000000000000000_REALK,     -0.000106747523043_REALK,      0.000000000000000_REALK, &
     -0.000079711745620_REALK,      0.000000000000000_REALK,     -0.000107995454450_REALK, &
      0.000000000000000_REALK,     -0.000007364677586_REALK,     -0.004647916315234_REALK, &
      0.000000000000000_REALK,     -0.003620323588610_REALK,      0.000000000000000_REALK, &
     -0.001653989592874_REALK,      0.000000000000000_REALK,     -0.000754309691081_REALK, &
      0.000000000000000_REALK,      0.000313076534110_REALK,      0.000000000000000_REALK, &
      0.000057229176642_REALK,      0.000206322247704_REALK,      0.000000000000000_REALK, &
      0.000199480931858_REALK,      0.000000000000000_REALK,     -0.000332666151516_REALK, &
      0.000000000000000_REALK,     -0.000289595774965_REALK,      0.000000000000000_REALK, &
     -0.000319596117989_REALK,      0.000000000000000_REALK,      0.000031765537017_REALK, &
     -0.001063803195717_REALK,      0.000000000000000_REALK,     -0.001116534521317_REALK, &
      0.000000000000000_REALK,     -0.001077792586005_REALK,      0.000000000000000_REALK, &
     -0.000123080376091_REALK,      0.000000000000000_REALK,     -0.001226970359623_REALK, &
      0.000000000000000_REALK,     -0.002056195883233_REALK,     -0.005233091274496_REALK, &
      0.000000000000000_REALK,     -0.003037053249800_REALK,      0.000000000000000_REALK, &
     -0.002939550572000_REALK,      0.000000000000000_REALK,     -0.001129649126255_REALK, &
      0.000000000000000_REALK,     -0.001757338045486_REALK,      0.000000000000000_REALK, &
     -0.002536094685213_REALK,     -0.005465896885298_REALK,      0.000000000000000_REALK, &
     -0.004203581575336_REALK,      0.000000000000000_REALK,     -0.000596657896418_REALK, &
      0.000000000000000_REALK,     -0.000555697950395_REALK,      0.000000000000000_REALK, &
      0.002413384548263_REALK,      0.000000000000000_REALK,      0.001629280846350_REALK, &
      0.002213939385235_REALK,      0.000000000000000_REALK,     -0.001701358348972_REALK, &
      0.000000000000000_REALK,      0.000150904201343_REALK,      0.000000000000000_REALK, &
     -0.000243760921221_REALK,      0.000000000000000_REALK,      0.001154181391609_REALK, &
      0.000000000000000_REALK,      0.005948991151835_REALK/
  ! results of test 2, ket-major order, CM010300
  data REF_CONTR_INTS(967:1043) /                                                          &
     -0.000211341948097_REALK,      0.000000000000000_REALK,      0.000021373753003_REALK, &
      0.000000000000000_REALK,      0.000064903808042_REALK,      0.000000000000000_REALK, &
      0.000026642530783_REALK,      0.000000000000000_REALK,      0.000107732105907_REALK, &
      0.000000000000000_REALK,      0.000028960746573_REALK,      0.000221777097215_REALK, &
      0.000000000000000_REALK,      0.004218279732926_REALK,      0.000000000000000_REALK, &
      0.001996310861795_REALK,      0.000000000000000_REALK,      0.001367129885758_REALK, &
      0.000000000000000_REALK,     -0.000121552584696_REALK,      0.000000000000000_REALK, &
     -0.000690283452592_REALK,     -0.000743946455874_REALK,      0.000000000000000_REALK, &
      0.000134596347525_REALK,      0.000000000000000_REALK,      0.000158520137243_REALK, &
      0.000000000000000_REALK,      0.000001506591045_REALK,      0.000000000000000_REALK, &
      0.000359793990318_REALK,      0.000000000000000_REALK,      0.000234731434096_REALK, &
     -0.001258021346292_REALK,      0.000000000000000_REALK,      0.000251226756609_REALK, &
      0.000000000000000_REALK,      0.000706498834709_REALK,      0.000000000000000_REALK, &
      0.000579823675500_REALK,      0.000000000000000_REALK,      0.000572063034146_REALK, &
      0.000000000000000_REALK,     -0.000021852602949_REALK,      0.000975709825641_REALK, &
      0.000000000000000_REALK,      0.003376369403552_REALK,      0.000000000000000_REALK, &
      0.001217139773287_REALK,      0.000000000000000_REALK,      0.001380441670120_REALK, &
      0.000000000000000_REALK,     -0.001257831545194_REALK,      0.000000000000000_REALK, &
      0.002980203984428_REALK,     -0.001421294355822_REALK,      0.000000000000000_REALK, &
      0.005366491590189_REALK,      0.000000000000000_REALK,      0.002839965136852_REALK, &
      0.000000000000000_REALK,      0.001442845521214_REALK,      0.000000000000000_REALK, &
      0.001066775647565_REALK,      0.000000000000000_REALK,     -0.002361829489362_REALK, &
      0.003956467419648_REALK,      0.000000000000000_REALK,      0.002461438336388_REALK, &
      0.000000000000000_REALK,      0.000922338903911_REALK,      0.000000000000000_REALK, &
      0.000293471310178_REALK,      0.000000000000000_REALK,     -0.000578754678681_REALK, &
      0.000000000000000_REALK,     -0.007253761831637_REALK/
  ! results of test 2, ket-major order, CM000400
  data REF_CONTR_INTS(1044:1120) /                                                         &
      0.000021405112661_REALK,      0.000000000000000_REALK,      0.000106530862900_REALK, &
      0.000000000000000_REALK,     -0.000117192309622_REALK,      0.000000000000000_REALK, &
     -0.000194125409641_REALK,      0.000000000000000_REALK,      0.000008312804575_REALK, &
      0.000000000000000_REALK,     -0.000164059591731_REALK,      0.003859628345243_REALK, &
      0.000000000000000_REALK,     -0.004039301684148_REALK,      0.000000000000000_REALK, &
     -0.001046794776247_REALK,      0.000000000000000_REALK,     -0.001449207013483_REALK, &
      0.000000000000000_REALK,      0.001428350182919_REALK,      0.000000000000000_REALK, &
      0.006963570220085_REALK,     -0.000342901086705_REALK,      0.000000000000000_REALK, &
      0.000395155336436_REALK,      0.000000000000000_REALK,     -0.000326725131659_REALK, &
      0.000000000000000_REALK,     -0.000567786857473_REALK,      0.000000000000000_REALK, &
      0.000085506317138_REALK,      0.000000000000000_REALK,     -0.000388982600086_REALK, &
      0.002321430169888_REALK,      0.000000000000000_REALK,     -0.000756095245273_REALK, &
      0.000000000000000_REALK,     -0.000472407476469_REALK,      0.000000000000000_REALK, &
     -0.002070986939625_REALK,      0.000000000000000_REALK,      0.001854532562610_REALK, &
      0.000000000000000_REALK,     -0.008138402346367_REALK,      0.016613289896989_REALK, &
      0.000000000000000_REALK,     -0.002653082773988_REALK,      0.000000000000000_REALK, &
     -0.000171754514404_REALK,      0.000000000000000_REALK,     -0.002057882949517_REALK, &
      0.000000000000000_REALK,      0.001177485799830_REALK,      0.000000000000000_REALK, &
      0.002383765053912_REALK,     -0.005148306095526_REALK,      0.000000000000000_REALK, &
     -0.004462344115045_REALK,      0.000000000000000_REALK,     -0.001184022204945_REALK, &
      0.000000000000000_REALK,     -0.000563260214845_REALK,      0.000000000000000_REALK, &
      0.001742797919405_REALK,      0.000000000000000_REALK,      0.015819216004271_REALK, &
     -0.011985675970828_REALK,      0.000000000000000_REALK,     -0.005561077691193_REALK, &
      0.000000000000000_REALK,     -0.003340989985229_REALK,      0.000000000000000_REALK, &
     -0.000541945328181_REALK,      0.000000000000000_REALK,     -0.001113157203385_REALK, &
      0.000000000000000_REALK,      0.000267646291633_REALK/
  ! results of test 2, ket-major order, CM030001
  data REF_CONTR_INTS(1121:1197) /                                                         &
      0.000000000000000_REALK,     -0.000233750758582_REALK,      0.000000000000000_REALK, &
     -0.000402715561843_REALK,      0.000000000000000_REALK,      0.000297302169563_REALK, &
      0.000000000000000_REALK,      0.000130956281060_REALK,      0.000000000000000_REALK, &
     -0.000337329228784_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.001188406880238_REALK,      0.000000000000000_REALK,     -0.000613398514723_REALK, &
      0.000000000000000_REALK,      0.001701050851975_REALK,      0.000000000000000_REALK, &
      0.001435231461643_REALK,      0.000000000000000_REALK,      0.006633664605470_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.000499347003858_REALK, &
      0.000000000000000_REALK,     -0.001476033592953_REALK,      0.000000000000000_REALK, &
      0.001063837483928_REALK,      0.000000000000000_REALK,      0.000282324179389_REALK, &
      0.000000000000000_REALK,     -0.001339134328377_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.007788288225946_REALK,      0.000000000000000_REALK, &
     -0.004224743668252_REALK,      0.000000000000000_REALK,      0.003458153227159_REALK, &
      0.000000000000000_REALK,      0.004155461847169_REALK,      0.000000000000000_REALK, &
     -0.002361241328190_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
     -0.005703723240248_REALK,      0.000000000000000_REALK,      0.001794836940986_REALK, &
      0.000000000000000_REALK,      0.001308463286685_REALK,      0.000000000000000_REALK, &
      0.002965173542012_REALK,      0.000000000000000_REALK,      0.011971653287445_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.009916250341735_REALK, &
      0.000000000000000_REALK,     -0.001941813922402_REALK,      0.000000000000000_REALK, &
      0.002120965342529_REALK,      0.000000000000000_REALK,     -0.001871273654399_REALK, &
      0.000000000000000_REALK,      0.004802965052512_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.002895281329450_REALK,      0.000000000000000_REALK, &
     -0.000825821680488_REALK,      0.000000000000000_REALK,     -0.001512857067854_REALK, &
      0.000000000000000_REALK,      0.003016047078734_REALK,      0.000000000000000_REALK, &
     -0.004710743490371_REALK,      0.000000000000000_REALK/
  ! results of test 2, ket-major order, CM020101
  data REF_CONTR_INTS(1198:1274) /                                                         &
      0.000000000000000_REALK,      0.000141774443372_REALK,      0.000000000000000_REALK, &
      0.000034243212125_REALK,      0.000000000000000_REALK,     -0.000036532003035_REALK, &
      0.000000000000000_REALK,     -0.000080153006304_REALK,      0.000000000000000_REALK, &
     -0.000017857639335_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.000292004561184_REALK,      0.000000000000000_REALK,      0.000779720497897_REALK, &
      0.000000000000000_REALK,     -0.001119975891459_REALK,      0.000000000000000_REALK, &
     -0.003795535387820_REALK,      0.000000000000000_REALK,     -0.005157661802821_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000425809000080_REALK, &
      0.000000000000000_REALK,      0.000027755898369_REALK,      0.000000000000000_REALK, &
     -0.000030852452190_REALK,      0.000000000000000_REALK,     -0.000232343762684_REALK, &
      0.000000000000000_REALK,     -0.000013164418746_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.003103203416149_REALK,      0.000000000000000_REALK, &
      0.001183454803253_REALK,      0.000000000000000_REALK,     -0.001426280745466_REALK, &
      0.000000000000000_REALK,     -0.001630637699884_REALK,      0.000000000000000_REALK, &
     -0.001147501469257_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.003626612004516_REALK,      0.000000000000000_REALK,      0.002720867669003_REALK, &
      0.000000000000000_REALK,     -0.003575327552253_REALK,      0.000000000000000_REALK, &
     -0.003457186889133_REALK,      0.000000000000000_REALK,     -0.005495376948486_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.002336009905918_REALK, &
      0.000000000000000_REALK,     -0.001467754351305_REALK,      0.000000000000000_REALK, &
      0.001255169133733_REALK,      0.000000000000000_REALK,     -0.004148140012367_REALK, &
      0.000000000000000_REALK,     -0.005942556902064_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.005235832340035_REALK,      0.000000000000000_REALK, &
      0.000517978295775_REALK,      0.000000000000000_REALK,      0.000787282850423_REALK, &
      0.000000000000000_REALK,     -0.001676025269441_REALK,      0.000000000000000_REALK, &
      0.000617040977505_REALK,      0.000000000000000_REALK/
  ! results of test 2, ket-major order, CM010201
  data REF_CONTR_INTS(1275:1351) /                                                         &
      0.000000000000000_REALK,      0.000031704286650_REALK,      0.000000000000000_REALK, &
     -0.000077353409415_REALK,      0.000000000000000_REALK,      0.000065434267634_REALK, &
      0.000000000000000_REALK,     -0.000005069731173_REALK,      0.000000000000000_REALK, &
     -0.000018502785043_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.001029866641918_REALK,      0.000000000000000_REALK,     -0.002032460280581_REALK, &
      0.000000000000000_REALK,      0.001229468708791_REALK,      0.000000000000000_REALK, &
      0.005031722420856_REALK,      0.000000000000000_REALK,      0.002756990376060_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000096101867025_REALK, &
      0.000000000000000_REALK,     -0.000280074292365_REALK,      0.000000000000000_REALK, &
      0.000231356727196_REALK,      0.000000000000000_REALK,     -0.000055569622750_REALK, &
      0.000000000000000_REALK,     -0.000136830036403_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000570869695622_REALK,      0.000000000000000_REALK, &
     -0.000564313708076_REALK,      0.000000000000000_REALK,      0.000615163216008_REALK, &
      0.000000000000000_REALK,      0.000161636913695_REALK,      0.000000000000000_REALK, &
      0.000809492538029_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
     -0.001228756539626_REALK,      0.000000000000000_REALK,     -0.001026654308909_REALK, &
      0.000000000000000_REALK,      0.000546701990017_REALK,      0.000000000000000_REALK, &
      0.004703302507320_REALK,      0.000000000000000_REALK,      0.002265112835203_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.002089957977541_REALK, &
      0.000000000000000_REALK,     -0.003386617742191_REALK,      0.000000000000000_REALK, &
      0.002037220225717_REALK,      0.000000000000000_REALK,      0.006002045299486_REALK, &
      0.000000000000000_REALK,      0.002392556701197_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.004447859383271_REALK,      0.000000000000000_REALK, &
     -0.000205186880034_REALK,      0.000000000000000_REALK,      0.000167335785414_REALK, &
      0.000000000000000_REALK,      0.002004778639533_REALK,      0.000000000000000_REALK, &
      0.004345933030946_REALK,      0.000000000000000_REALK/
  ! results of test 2, ket-major order, CM000301
  data REF_CONTR_INTS(1352:1428) /                                                         &
      0.000000000000000_REALK,      0.000097634683357_REALK,      0.000000000000000_REALK, &
      0.000012781017726_REALK,      0.000000000000000_REALK,      0.000032064001469_REALK, &
      0.000000000000000_REALK,     -0.000115639681490_REALK,      0.000000000000000_REALK, &
      0.000118583481112_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
     -0.006350014323044_REALK,      0.000000000000000_REALK,      0.001463004402640_REALK, &
      0.000000000000000_REALK,      0.000072909451711_REALK,      0.000000000000000_REALK, &
     -0.004585393978829_REALK,      0.000000000000000_REALK,     -0.002161278460345_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000375622014146_REALK, &
      0.000000000000000_REALK,     -0.000031497445566_REALK,      0.000000000000000_REALK, &
      0.000109317065860_REALK,      0.000000000000000_REALK,     -0.000305455006020_REALK, &
      0.000000000000000_REALK,      0.000228183029534_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.001212498372192_REALK,      0.000000000000000_REALK, &
      0.000350727811183_REALK,      0.000000000000000_REALK,      0.001095203244110_REALK, &
      0.000000000000000_REALK,     -0.002715439496820_REALK,      0.000000000000000_REALK, &
      0.003769018887995_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
     -0.007740840572178_REALK,      0.000000000000000_REALK,      0.001810096396555_REALK, &
      0.000000000000000_REALK,      0.001376485219023_REALK,      0.000000000000000_REALK, &
     -0.003350506918476_REALK,      0.000000000000000_REALK,      0.004913895377463_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.007434002663617_REALK, &
      0.000000000000000_REALK,      0.000814752152851_REALK,      0.000000000000000_REALK, &
     -0.000724150860142_REALK,      0.000000000000000_REALK,     -0.004630587598272_REALK, &
      0.000000000000000_REALK,     -0.008527585382481_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.001869385020390_REALK,      0.000000000000000_REALK, &
      0.001965856834296_REALK,      0.000000000000000_REALK,     -0.002828605609931_REALK, &
      0.000000000000000_REALK,     -0.005365056987064_REALK,      0.000000000000000_REALK, &
     -0.008225967971968_REALK,      0.000000000000000_REALK/
  ! results of test 2, ket-major order, CM020002
  data REF_CONTR_INTS(1429:1505) /                                                         &
      0.000170726932869_REALK,      0.000000000000000_REALK,     -0.000029561546987_REALK, &
      0.000000000000000_REALK,      0.000130204376470_REALK,      0.000000000000000_REALK, &
      0.000103809021359_REALK,      0.000000000000000_REALK,      0.000080386259161_REALK, &
      0.000000000000000_REALK,      0.000098544754899_REALK,     -0.000131933510020_REALK, &
      0.000000000000000_REALK,      0.007309682077378_REALK,      0.000000000000000_REALK, &
      0.003129813007646_REALK,      0.000000000000000_REALK,     -0.000165756294280_REALK, &
      0.000000000000000_REALK,      0.002912042473685_REALK,      0.000000000000000_REALK, &
     -0.001042383056796_REALK,      0.000599383395077_REALK,      0.000000000000000_REALK, &
     -0.000090535360569_REALK,      0.000000000000000_REALK,      0.000253914606116_REALK, &
      0.000000000000000_REALK,      0.000255517861539_REALK,      0.000000000000000_REALK, &
      0.000057144054860_REALK,      0.000000000000000_REALK,      0.000410152180962_REALK, &
      0.001913456388477_REALK,      0.000000000000000_REALK,     -0.001618337374319_REALK, &
      0.000000000000000_REALK,      0.004906242623101_REALK,      0.000000000000000_REALK, &
      0.003403988522783_REALK,      0.000000000000000_REALK,      0.004595677027001_REALK, &
      0.000000000000000_REALK,     -0.000564692857846_REALK,      0.000000435392900_REALK, &
      0.000000000000000_REALK,      0.006800753530803_REALK,      0.000000000000000_REALK, &
      0.005964383609278_REALK,      0.000000000000000_REALK,     -0.000843955374220_REALK, &
      0.000000000000000_REALK,      0.009337676177955_REALK,      0.000000000000000_REALK, &
     -0.001757141578060_REALK,     -0.000715238570369_REALK,      0.000000000000000_REALK, &
      0.010025077776851_REALK,      0.000000000000000_REALK,     -0.000509684825532_REALK, &
      0.000000000000000_REALK,     -0.001915463371190_REALK,      0.000000000000000_REALK, &
     -0.002389960099196_REALK,      0.000000000000000_REALK,     -0.000291802049417_REALK, &
     -0.000138970461408_REALK,      0.000000000000000_REALK,      0.000626108233036_REALK, &
      0.000000000000000_REALK,      0.000283285315022_REALK,      0.000000000000000_REALK, &
      0.004592527795546_REALK,      0.000000000000000_REALK,     -0.006330317124555_REALK, &
      0.000000000000000_REALK,      0.000015926240413_REALK/
  ! results of test 2, ket-major order, CM010102
  data REF_CONTR_INTS(1506:1582) /                                                         &
     -0.000086109423633_REALK,      0.000000000000000_REALK,     -0.000061801476558_REALK, &
      0.000000000000000_REALK,      0.000013665765676_REALK,      0.000000000000000_REALK, &
      0.000044354358620_REALK,      0.000000000000000_REALK,      0.000003062550063_REALK, &
      0.000000000000000_REALK,      0.000046268040456_REALK,     -0.000093413097134_REALK, &
      0.000000000000000_REALK,     -0.005665395173200_REALK,      0.000000000000000_REALK, &
     -0.004654316850057_REALK,      0.000000000000000_REALK,     -0.003575207452829_REALK, &
      0.000000000000000_REALK,     -0.001026924139345_REALK,      0.000000000000000_REALK, &
      0.001232351793777_REALK,     -0.000286953956598_REALK,      0.000000000000000_REALK, &
     -0.000084426068555_REALK,      0.000000000000000_REALK,      0.000061042252891_REALK, &
      0.000000000000000_REALK,      0.000107579443043_REALK,      0.000000000000000_REALK, &
      0.000044960785480_REALK,      0.000000000000000_REALK,      0.000163911075279_REALK, &
     -0.000937092790078_REALK,      0.000000000000000_REALK,     -0.002049141890762_REALK, &
      0.000000000000000_REALK,     -0.000010267586855_REALK,      0.000000000000000_REALK, &
      0.001225435332593_REALK,      0.000000000000000_REALK,     -0.000727068384506_REALK, &
      0.000000000000000_REALK,      0.001025201321511_REALK,     -0.000240170763661_REALK, &
      0.000000000000000_REALK,     -0.004358855806420_REALK,      0.000000000000000_REALK, &
     -0.004901631695817_REALK,      0.000000000000000_REALK,     -0.002569399892192_REALK, &
      0.000000000000000_REALK,     -0.003463538916338_REALK,      0.000000000000000_REALK, &
      0.001586861199319_REALK,      0.000235371098440_REALK,      0.000000000000000_REALK, &
     -0.006048221082554_REALK,      0.000000000000000_REALK,     -0.005545791946454_REALK, &
      0.000000000000000_REALK,     -0.005601867590971_REALK,      0.000000000000000_REALK, &
      0.000335518487252_REALK,      0.000000000000000_REALK,      0.000857560004419_REALK, &
      0.000054523052699_REALK,      0.000000000000000_REALK,     -0.005965279597200_REALK, &
      0.000000000000000_REALK,     -0.000115647603691_REALK,      0.000000000000000_REALK, &
     -0.000893953324600_REALK,      0.000000000000000_REALK,      0.003629427444844_REALK, &
      0.000000000000000_REALK,      0.000141741588838_REALK/
  ! results of test 2, ket-major order, CM000202
  data REF_CONTR_INTS(1583:1659) /                                                         &
     -0.000016382878858_REALK,      0.000000000000000_REALK,     -0.000004507066270_REALK, &
      0.000000000000000_REALK,      0.000008867469072_REALK,      0.000000000000000_REALK, &
      0.000049814128251_REALK,      0.000000000000000_REALK,     -0.000050290651598_REALK, &
      0.000000000000000_REALK,      0.000014783095204_REALK,      0.000435504909401_REALK, &
      0.000000000000000_REALK,      0.007328621438325_REALK,      0.000000000000000_REALK, &
      0.002243231464033_REALK,      0.000000000000000_REALK,      0.003624055144088_REALK, &
      0.000000000000000_REALK,     -0.004304547892243_REALK,      0.000000000000000_REALK, &
     -0.001612461523130_REALK,     -0.000075283574055_REALK,      0.000000000000000_REALK, &
     -0.000005933185893_REALK,      0.000000000000000_REALK,      0.000020330011376_REALK, &
      0.000000000000000_REALK,      0.000072808314608_REALK,      0.000000000000000_REALK, &
     -0.000050330296641_REALK,      0.000000000000000_REALK,      0.000083317223241_REALK, &
     -0.000670534047225_REALK,      0.000000000000000_REALK,     -0.001185040311316_REALK, &
      0.000000000000000_REALK,      0.000474884635466_REALK,      0.000000000000000_REALK, &
      0.002305219096187_REALK,      0.000000000000000_REALK,     -0.001844694652040_REALK, &
      0.000000000000000_REALK,     -0.001052569863091_REALK,      0.000434003055998_REALK, &
      0.000000000000000_REALK,      0.002892714837290_REALK,      0.000000000000000_REALK, &
     -0.000300554939553_REALK,      0.000000000000000_REALK,      0.004153323562746_REALK, &
      0.000000000000000_REALK,     -0.007908182882519_REALK,      0.000000000000000_REALK, &
     -0.002374111651483_REALK,      0.000718385027174_REALK,      0.000000000000000_REALK, &
      0.011696683425588_REALK,      0.000000000000000_REALK,      0.003519557264879_REALK, &
      0.000000000000000_REALK,      0.002611447171288_REALK,      0.000000000000000_REALK, &
     -0.002377710727785_REALK,      0.000000000000000_REALK,     -0.000862144389850_REALK, &
      0.000136675466160_REALK,      0.000000000000000_REALK,      0.007998445179942_REALK, &
      0.000000000000000_REALK,      0.005780196581239_REALK,      0.000000000000000_REALK, &
      0.002338387039317_REALK,      0.000000000000000_REALK,      0.003919080045142_REALK, &
      0.000000000000000_REALK,     -0.000095736370727_REALK/
  ! results of test 2, ket-major order, CM010003
  data REF_CONTR_INTS(1660:1736) /                                                         &
      0.000000000000000_REALK,      0.000003814469763_REALK,      0.000000000000000_REALK, &
     -0.000147864910842_REALK,      0.000000000000000_REALK,      0.000073531656017_REALK, &
      0.000000000000000_REALK,     -0.000003868647329_REALK,      0.000000000000000_REALK, &
     -0.000270287103743_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
     -0.002744996813519_REALK,      0.000000000000000_REALK,      0.007563527956651_REALK, &
      0.000000000000000_REALK,     -0.005403767754718_REALK,      0.000000000000000_REALK, &
     -0.007181063054530_REALK,      0.000000000000000_REALK,     -0.001571492520669_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000091553400007_REALK, &
      0.000000000000000_REALK,     -0.000712422605251_REALK,      0.000000000000000_REALK, &
      0.000446386538203_REALK,      0.000000000000000_REALK,     -0.000019049896372_REALK, &
      0.000000000000000_REALK,     -0.000888291874479_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.001011206804395_REALK,      0.000000000000000_REALK, &
      0.000814493516270_REALK,      0.000000000000000_REALK,     -0.001771980670477_REALK, &
      0.000000000000000_REALK,      0.000570269633546_REALK,      0.000000000000000_REALK, &
     -0.004063385123689_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
     -0.003739697574047_REALK,      0.000000000000000_REALK,      0.011840709294353_REALK, &
      0.000000000000000_REALK,     -0.010761504741880_REALK,      0.000000000000000_REALK, &
     -0.002220840678946_REALK,      0.000000000000000_REALK,     -0.002547298531295_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.002016748165558_REALK, &
      0.000000000000000_REALK,      0.005673114023645_REALK,      0.000000000000000_REALK, &
     -0.002297886516625_REALK,      0.000000000000000_REALK,     -0.011348377991712_REALK, &
      0.000000000000000_REALK,      0.000055908688465_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.000300592272008_REALK,      0.000000000000000_REALK, &
     -0.003059239208201_REALK,      0.000000000000000_REALK,      0.005314217152311_REALK, &
      0.000000000000000_REALK,     -0.009669808868423_REALK,      0.000000000000000_REALK, &
      0.000081023157383_REALK,      0.000000000000000_REALK/
  ! results of test 2, ket-major order, CM000103
  data REF_CONTR_INTS(1737:1813) /                                                         &
      0.000000000000000_REALK,      0.000154977190690_REALK,      0.000000000000000_REALK, &
      0.000028189795850_REALK,      0.000000000000000_REALK,     -0.000023801778775_REALK, &
      0.000000000000000_REALK,     -0.000037101560570_REALK,      0.000000000000000_REALK, &
      0.000060607740728_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.003179488238312_REALK,      0.000000000000000_REALK,     -0.001384462046361_REALK, &
      0.000000000000000_REALK,     -0.001259524738739_REALK,      0.000000000000000_REALK, &
      0.011442724838914_REALK,      0.000000000000000_REALK,      0.002689397784036_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.000446663477586_REALK, &
      0.000000000000000_REALK,      0.000000545395134_REALK,      0.000000000000000_REALK, &
      0.000022147755506_REALK,      0.000000000000000_REALK,     -0.000213212049366_REALK, &
      0.000000000000000_REALK,      0.000128129967160_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.003516645902546_REALK,      0.000000000000000_REALK, &
      0.001228570074651_REALK,      0.000000000000000_REALK,     -0.001294805441777_REALK, &
      0.000000000000000_REALK,     -0.000146734199459_REALK,      0.000000000000000_REALK, &
      0.001259823217891_REALK,      0.000000000000000_REALK,      0.000000000000000_REALK, &
      0.004630064744709_REALK,      0.000000000000000_REALK,      0.003732758154565_REALK, &
      0.000000000000000_REALK,     -0.005162802440478_REALK,      0.000000000000000_REALK, &
      0.007788533430641_REALK,      0.000000000000000_REALK,      0.003650375122465_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.001472547332869_REALK, &
      0.000000000000000_REALK,     -0.004989934655556_REALK,      0.000000000000000_REALK, &
      0.001269914428963_REALK,      0.000000000000000_REALK,      0.015261031492514_REALK, &
      0.000000000000000_REALK,      0.001970187077870_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000165553386149_REALK,      0.000000000000000_REALK, &
     -0.007696425187847_REALK,      0.000000000000000_REALK,      0.005006737407407_REALK, &
      0.000000000000000_REALK,      0.009476485846830_REALK,      0.000000000000000_REALK, &
      0.000297058195881_REALK,      0.000000000000000_REALK/
  ! results of test 2, ket-major order, CM000004
  data REF_CONTR_INTS(1814:1890) /                                                         &
      0.000039252500076_REALK,      0.000000000000000_REALK,     -0.000184670729242_REALK, &
      0.000000000000000_REALK,      0.000164233652849_REALK,      0.000000000000000_REALK, &
      0.000212110820095_REALK,      0.000000000000000_REALK,      0.000079340629653_REALK, &
      0.000000000000000_REALK,      0.000255029876306_REALK,      0.000080637566363_REALK, &
      0.000000000000000_REALK,     -0.008586997577733_REALK,      0.000000000000000_REALK, &
     -0.008076706276832_REALK,      0.000000000000000_REALK,     -0.010431216515801_REALK, &
      0.000000000000000_REALK,      0.003689257076331_REALK,      0.000000000000000_REALK, &
      0.000523915382085_REALK,      0.000131275219198_REALK,      0.000000000000000_REALK, &
     -0.000401112052750_REALK,      0.000000000000000_REALK,      0.000489243119167_REALK, &
      0.000000000000000_REALK,      0.000631866596354_REALK,      0.000000000000000_REALK, &
      0.000172330953353_REALK,      0.000000000000000_REALK,      0.000852916447334_REALK, &
      0.000284362842461_REALK,      0.000000000000000_REALK,     -0.006797386937972_REALK, &
      0.000000000000000_REALK,      0.004719697042818_REALK,      0.000000000000000_REALK, &
      0.006095576594613_REALK,      0.000000000000000_REALK,      0.002920381382953_REALK, &
      0.000000000000000_REALK,      0.001847551631051_REALK,      0.000119360572070_REALK, &
      0.000000000000000_REALK,     -0.012213363470426_REALK,      0.000000000000000_REALK, &
     -0.000198398287879_REALK,      0.000000000000000_REALK,     -0.000256235082259_REALK, &
      0.000000000000000_REALK,      0.005247263342185_REALK,      0.000000000000000_REALK, &
      0.000775505047362_REALK,      0.000010204350571_REALK,      0.000000000000000_REALK, &
     -0.004868914120896_REALK,      0.000000000000000_REALK,     -0.015754501499925_REALK, &
      0.000000000000000_REALK,     -0.020347231979407_REALK,      0.000000000000000_REALK, &
      0.002091845923090_REALK,      0.000000000000000_REALK,      0.000066299325109_REALK, &
      0.000000260013773_REALK,      0.000000000000000_REALK,     -0.000631651408469_REALK, &
      0.000000000000000_REALK,     -0.012606003497548_REALK,      0.000000000000000_REALK, &
     -0.016280888195608_REALK,      0.000000000000000_REALK,      0.000271378256180_REALK, &
      0.000000000000000_REALK,      0.000001689351766_REALK/
  ! results of test 3, ket-major order, CM040000
  data REF_CONTR_INTS(1891:2033) /                                                         &
      0.037998582889204_REALK,      0.000000000000000_REALK,      0.061661810162782_REALK, &
      0.000000000000000_REALK,      0.050432524671980_REALK,      0.000000000000000_REALK, &
      0.002723524441331_REALK,      0.000000000000000_REALK,      0.002415650992887_REALK, &
      0.000000000000000_REALK,     -0.049528281894321_REALK,      0.000000000000000_REALK, &
     -0.083638383829317_REALK,      0.000000000000000_REALK,     -0.011799629279533_REALK, &
      0.000000000000000_REALK,     -0.020083845029964_REALK,      0.000000000000000_REALK, &
     -0.032544935848930_REALK,      0.000000000000000_REALK,      0.007442806230306_REALK, &
      0.000000000000000_REALK,     -0.004760333426033_REALK,      0.000000000000000_REALK, &
      0.018216911793896_REALK,      0.000000000000000_REALK,      0.022582584276356_REALK, &
      0.000000000000000_REALK,      0.016885226261911_REALK,      0.000000000000000_REALK, &
      0.085683113950591_REALK,      0.000000000000000_REALK,      0.006119259939723_REALK, &
      0.000000000000000_REALK,      0.021858445357581_REALK,      0.000000000000000_REALK, &
      0.044565769333715_REALK,      0.000000000000000_REALK,     -0.023821236760052_REALK, &
      0.000000000000000_REALK,     -0.015591887235501_REALK,      0.000000000000000_REALK, &
     -0.005321297314950_REALK,      0.000000000000000_REALK,      0.001195870561700_REALK, &
      0.000000000000000_REALK,      0.000511449708827_REALK,      0.000000000000000_REALK, &
     -0.025834383916888_REALK,      0.000000000000000_REALK,     -0.019597043444856_REALK, &
      0.000000000000000_REALK,     -0.039004609600109_REALK,      0.000000000000000_REALK, &
     -0.002627049424686_REALK,      0.000000000000000_REALK,     -0.005230745267439_REALK, &
      0.000000000000000_REALK,     -0.026196410665536_REALK,      0.000000000000000_REALK, &
      0.019366130110257_REALK,      0.000000000000000_REALK,      0.002954648115296_REALK, &
      0.000000000000000_REALK,      0.005275121937700_REALK,      0.000000000000000_REALK, &
      0.035630421662366_REALK,      0.000000000000000_REALK,      0.097702260037476_REALK, &
      0.000000000000000_REALK,      0.130074281139548_REALK,      0.000000000000000_REALK, &
      0.024379778129416_REALK,      0.000000000000000_REALK,      0.041234617489672_REALK, &
      0.000000000000000_REALK,     -0.013227946250126_REALK,      0.000000000000000_REALK, &
     -0.011215099867453_REALK,      0.000000000000000_REALK,     -0.059120406151110_REALK, &
      0.000000000000000_REALK,      0.136288353679171_REALK,      0.000000000000000_REALK, &
      0.157457540784323_REALK,      0.000000000000000_REALK,      0.117417449434148_REALK, &
      0.000000000000000_REALK,     -0.056267683873556_REALK,      0.000000000000000_REALK, &
     -0.148829491740248_REALK,      0.000000000000000_REALK,     -0.170702172203358_REALK, &
      0.000000000000000_REALK,     -0.020787664733870_REALK,      0.000000000000000_REALK, &
     -0.060914819700378_REALK,      0.000000000000000_REALK,      0.018944151520458_REALK, &
      0.000000000000000_REALK,      0.024347324863409_REALK,      0.000000000000000_REALK, &
      0.022364509356661_REALK,      0.000000000000000_REALK,     -0.101694832990852_REALK, &
      0.000000000000000_REALK,     -0.151685314724324_REALK,      0.000000000000000_REALK, &
     -0.125992724775063_REALK,      0.000000000000000_REALK,      0.074621503691308_REALK, &
      0.000000000000000_REALK,      0.161296002913971_REALK,      0.000000000000000_REALK, &
      0.140147187026076_REALK,      0.000000000000000_REALK,      0.015190171930797_REALK, &
      0.000000000000000_REALK,      0.028098736862512_REALK,      0.000000000000000_REALK, &
     -0.014446769304636_REALK,      0.000000000000000_REALK,     -0.039795268683006_REALK, &
      0.000000000000000_REALK,     -0.038333068096473_REALK,      0.000000000000000_REALK, &
      0.086968947451307_REALK,      0.000000000000000_REALK,      0.123317838066133_REALK, &
      0.000000000000000_REALK,      0.177381215620070_REALK,      0.000000000000000_REALK, &
     -0.165989859937648_REALK,      0.000000000000000_REALK,     -0.062231983850609_REALK, &
      0.000000000000000_REALK,     -0.042129209617784_REALK,      0.000000000000000_REALK, &
     -0.003116350069592_REALK,      0.000000000000000_REALK,     -0.025328311800712_REALK, &
      0.000000000000000_REALK,     -0.022557022049134_REALK/
  ! results of test 3, ket-major order, CM030100
  data REF_CONTR_INTS(2034:2176) /                                                         &
     -0.010884815143271_REALK,      0.000000000000000_REALK,     -0.004764159851116_REALK, &
      0.000000000000000_REALK,     -0.009748250336354_REALK,      0.000000000000000_REALK, &
     -0.000408891070827_REALK,      0.000000000000000_REALK,      0.000460284131490_REALK, &
      0.000000000000000_REALK,     -0.023011510376712_REALK,      0.000000000000000_REALK, &
     -0.028220985725925_REALK,      0.000000000000000_REALK,     -0.001936825476033_REALK, &
      0.000000000000000_REALK,      0.009011113187128_REALK,      0.000000000000000_REALK, &
      0.001719316666119_REALK,      0.000000000000000_REALK,      0.003777514390122_REALK, &
      0.000000000000000_REALK,      0.009450963665766_REALK,      0.000000000000000_REALK, &
      0.008235828628187_REALK,      0.000000000000000_REALK,      0.009961520554919_REALK, &
      0.000000000000000_REALK,     -0.002543826356317_REALK,      0.000000000000000_REALK, &
      0.027816080192434_REALK,      0.000000000000000_REALK,      0.001135037206223_REALK, &
      0.000000000000000_REALK,      0.002669558619791_REALK,      0.000000000000000_REALK, &
      0.014137158520405_REALK,      0.000000000000000_REALK,     -0.010153320856664_REALK, &
      0.000000000000000_REALK,     -0.008645540212374_REALK,      0.000000000000000_REALK, &
     -0.002991029664174_REALK,      0.000000000000000_REALK,     -0.002515617636180_REALK, &
      0.000000000000000_REALK,      0.006039976013567_REALK,      0.000000000000000_REALK, &
     -0.008755830562343_REALK,      0.000000000000000_REALK,     -0.008915211440769_REALK, &
      0.000000000000000_REALK,     -0.002343647561975_REALK,      0.000000000000000_REALK, &
     -0.001351072204174_REALK,      0.000000000000000_REALK,     -0.002570803133764_REALK, &
      0.000000000000000_REALK,     -0.009675693050355_REALK,      0.000000000000000_REALK, &
      0.011064047662878_REALK,      0.000000000000000_REALK,     -0.005488854694719_REALK, &
      0.000000000000000_REALK,      0.004942781016023_REALK,      0.000000000000000_REALK, &
     -0.007142726594985_REALK,      0.000000000000000_REALK,     -0.016802836468465_REALK, &
      0.000000000000000_REALK,     -0.011542262454410_REALK,      0.000000000000000_REALK, &
      0.007164386173272_REALK,      0.000000000000000_REALK,     -0.001140783451901_REALK, &
      0.000000000000000_REALK,      0.002170751850961_REALK,      0.000000000000000_REALK, &
     -0.000375671341119_REALK,      0.000000000000000_REALK,     -0.011540517269988_REALK, &
      0.000000000000000_REALK,     -0.005987120662838_REALK,      0.000000000000000_REALK, &
     -0.022598564601728_REALK,      0.000000000000000_REALK,     -0.013814606611275_REALK, &
      0.000000000000000_REALK,      0.008623742180629_REALK,      0.000000000000000_REALK, &
      0.016923991138493_REALK,      0.000000000000000_REALK,      0.019038229630948_REALK, &
      0.000000000000000_REALK,      0.004095677012090_REALK,      0.000000000000000_REALK, &
     -0.009502963205607_REALK,      0.000000000000000_REALK,     -0.002123760507103_REALK, &
      0.000000000000000_REALK,     -0.000378743269086_REALK,      0.000000000000000_REALK, &
     -0.006158371932749_REALK,      0.000000000000000_REALK,      0.019726799353604_REALK, &
      0.000000000000000_REALK,      0.010646474538577_REALK,      0.000000000000000_REALK, &
      0.019809384596173_REALK,      0.000000000000000_REALK,     -0.012313063141204_REALK, &
      0.000000000000000_REALK,      0.004038277483221_REALK,      0.000000000000000_REALK, &
     -0.018994813920838_REALK,      0.000000000000000_REALK,     -0.001386441200572_REALK, &
      0.000000000000000_REALK,     -0.003792025623416_REALK,      0.000000000000000_REALK, &
      0.000170530943776_REALK,      0.000000000000000_REALK,      0.001458277687923_REALK, &
      0.000000000000000_REALK,     -0.006259850513317_REALK,      0.000000000000000_REALK, &
     -0.006192766302695_REALK,      0.000000000000000_REALK,     -0.019094412911894_REALK, &
      0.000000000000000_REALK,      0.006081260116734_REALK,      0.000000000000000_REALK, &
      0.003762274002948_REALK,      0.000000000000000_REALK,      0.010778079879734_REALK, &
      0.000000000000000_REALK,      0.006418575248085_REALK,      0.000000000000000_REALK, &
      0.001702740994750_REALK,      0.000000000000000_REALK,     -0.008792846460887_REALK, &
      0.000000000000000_REALK,     -0.004871815216889_REALK/
  ! results of test 3, ket-major order, CM020200
  data REF_CONTR_INTS(2177:2319) /                                                         &
      0.020884620052574_REALK,      0.000000000000000_REALK,      0.008393193362929_REALK, &
      0.000000000000000_REALK,      0.004877394106025_REALK,      0.000000000000000_REALK, &
     -0.000181007501270_REALK,      0.000000000000000_REALK,      0.007035641895268_REALK, &
      0.000000000000000_REALK,     -0.001211242864805_REALK,      0.000000000000000_REALK, &
     -0.005918626316889_REALK,      0.000000000000000_REALK,      0.005423727540253_REALK, &
      0.000000000000000_REALK,     -0.002388921076024_REALK,      0.000000000000000_REALK, &
     -0.013218430203418_REALK,      0.000000000000000_REALK,     -0.016491666408996_REALK, &
      0.000000000000000_REALK,     -0.000452799736879_REALK,      0.000000000000000_REALK, &
     -0.009038232583332_REALK,      0.000000000000000_REALK,     -0.007110940740515_REALK, &
      0.000000000000000_REALK,     -0.010898324751416_REALK,      0.000000000000000_REALK, &
      0.015205488507836_REALK,      0.000000000000000_REALK,     -0.002126031028557_REALK, &
      0.000000000000000_REALK,     -0.006074487860600_REALK,      0.000000000000000_REALK, &
      0.005528741622512_REALK,      0.000000000000000_REALK,      0.003965229759090_REALK, &
      0.000000000000000_REALK,      0.002366408284870_REALK,      0.000000000000000_REALK, &
      0.006145057686604_REALK,      0.000000000000000_REALK,      0.003388477487186_REALK, &
      0.000000000000000_REALK,      0.008203203844628_REALK,      0.000000000000000_REALK, &
      0.002261207105374_REALK,      0.000000000000000_REALK,     -0.008943394782294_REALK, &
      0.000000000000000_REALK,      0.010697082374182_REALK,      0.000000000000000_REALK, &
     -0.000411419694313_REALK,      0.000000000000000_REALK,     -0.004309115142320_REALK, &
      0.000000000000000_REALK,     -0.002363108898530_REALK,      0.000000000000000_REALK, &
      0.008886977335098_REALK,      0.000000000000000_REALK,     -0.014287790658017_REALK, &
      0.000000000000000_REALK,      0.003921860370582_REALK,      0.000000000000000_REALK, &
      0.000243452620304_REALK,      0.000000000000000_REALK,      0.002240359807172_REALK, &
      0.000000000000000_REALK,      0.004976390265328_REALK,      0.000000000000000_REALK, &
      0.010300543469587_REALK,      0.000000000000000_REALK,     -0.007108174920035_REALK, &
      0.000000000000000_REALK,     -0.000005312810691_REALK,      0.000000000000000_REALK, &
     -0.002523615090007_REALK,      0.000000000000000_REALK,     -0.006832659882875_REALK, &
      0.000000000000000_REALK,      0.010838015251734_REALK,      0.000000000000000_REALK, &
     -0.000668338196810_REALK,      0.000000000000000_REALK,      0.006931805475869_REALK, &
      0.000000000000000_REALK,     -0.005329120526217_REALK,      0.000000000000000_REALK, &
     -0.001155079478915_REALK,      0.000000000000000_REALK,     -0.006897183542879_REALK, &
      0.000000000000000_REALK,      0.007208306135153_REALK,      0.000000000000000_REALK, &
     -0.011731892634063_REALK,      0.000000000000000_REALK,     -0.000033810928959_REALK, &
      0.000000000000000_REALK,     -0.001065538555230_REALK,      0.000000000000000_REALK, &
     -0.000676898594904_REALK,      0.000000000000000_REALK,      0.003391236213824_REALK, &
      0.000000000000000_REALK,     -0.016328480345385_REALK,      0.000000000000000_REALK, &
      0.003303793719378_REALK,      0.000000000000000_REALK,      0.001438409315782_REALK, &
      0.000000000000000_REALK,      0.016867580574624_REALK,      0.000000000000000_REALK, &
      0.003392728579703_REALK,      0.000000000000000_REALK,      0.002038693577668_REALK, &
      0.000000000000000_REALK,      0.006445797723400_REALK,      0.000000000000000_REALK, &
     -0.001062777728344_REALK,      0.000000000000000_REALK,     -0.012777870809623_REALK, &
      0.000000000000000_REALK,     -0.004641727809458_REALK,      0.000000000000000_REALK, &
      0.007147977073079_REALK,      0.000000000000000_REALK,     -0.005215391838028_REALK, &
      0.000000000000000_REALK,      0.017959782405208_REALK,      0.000000000000000_REALK, &
     -0.005668433608645_REALK,      0.000000000000000_REALK,      0.004014706758260_REALK, &
      0.000000000000000_REALK,      0.000412525351354_REALK,      0.000000000000000_REALK, &
      0.003542468821140_REALK,      0.000000000000000_REALK,     -0.004329699094180_REALK, &
      0.000000000000000_REALK,     -0.009040553621044_REALK/
  ! results of test 3, ket-major order, CM010300
  data REF_CONTR_INTS(2320:2462) /                                                         &
      0.019772119365129_REALK,      0.000000000000000_REALK,     -0.005608602628087_REALK, &
      0.000000000000000_REALK,     -0.001397058514904_REALK,      0.000000000000000_REALK, &
     -0.005773649847267_REALK,      0.000000000000000_REALK,      0.009296138454173_REALK, &
      0.000000000000000_REALK,     -0.010491733903110_REALK,      0.000000000000000_REALK, &
     -0.007999412960483_REALK,      0.000000000000000_REALK,      0.003342495577464_REALK, &
      0.000000000000000_REALK,      0.006743357684685_REALK,      0.000000000000000_REALK, &
     -0.002259198129811_REALK,      0.000000000000000_REALK,     -0.010269755539389_REALK, &
      0.000000000000000_REALK,      0.011387623932985_REALK,      0.000000000000000_REALK, &
     -0.007118024977721_REALK,      0.000000000000000_REALK,      0.003970222710837_REALK, &
      0.000000000000000_REALK,     -0.020465190193929_REALK,      0.000000000000000_REALK, &
      0.024499147178558_REALK,      0.000000000000000_REALK,     -0.000778886816853_REALK, &
      0.000000000000000_REALK,     -0.008675486075987_REALK,      0.000000000000000_REALK, &
      0.007968972353143_REALK,      0.000000000000000_REALK,      0.004168377764322_REALK, &
      0.000000000000000_REALK,     -0.009225566058030_REALK,      0.000000000000000_REALK, &
      0.001779541878866_REALK,      0.000000000000000_REALK,      0.003555971091215_REALK, &
      0.000000000000000_REALK,     -0.002845594527013_REALK,      0.000000000000000_REALK, &
     -0.000681417054808_REALK,      0.000000000000000_REALK,     -0.016651342692536_REALK, &
      0.000000000000000_REALK,      0.017505484099517_REALK,      0.000000000000000_REALK, &
     -0.000157127814019_REALK,      0.000000000000000_REALK,     -0.012717615395751_REALK, &
      0.000000000000000_REALK,      0.003793010734984_REALK,      0.000000000000000_REALK, &
      0.017010918835216_REALK,      0.000000000000000_REALK,     -0.020770667039349_REALK, &
      0.000000000000000_REALK,      0.008617834480358_REALK,      0.000000000000000_REALK, &
     -0.005326457810226_REALK,      0.000000000000000_REALK,      0.003617944836064_REALK, &
      0.000000000000000_REALK,     -0.003815369320770_REALK,      0.000000000000000_REALK, &
      0.016962606638641_REALK,      0.000000000000000_REALK,     -0.015805682924952_REALK, &
      0.000000000000000_REALK,     -0.001032834165524_REALK,      0.000000000000000_REALK, &
     -0.003473649144611_REALK,      0.000000000000000_REALK,     -0.000745852433390_REALK, &
      0.000000000000000_REALK,      0.005718571961760_REALK,      0.000000000000000_REALK, &
     -0.012697820378704_REALK,      0.000000000000000_REALK,      0.002070350661527_REALK, &
      0.000000000000000_REALK,     -0.004394095768667_REALK,      0.000000000000000_REALK, &
      0.011475225347291_REALK,      0.000000000000000_REALK,     -0.000320516206759_REALK, &
      0.000000000000000_REALK,      0.017153744121504_REALK,      0.000000000000000_REALK, &
     -0.013775453073849_REALK,      0.000000000000000_REALK,     -0.001323164513330_REALK, &
      0.000000000000000_REALK,     -0.011379473211799_REALK,      0.000000000000000_REALK, &
      0.001921966455882_REALK,      0.000000000000000_REALK,      0.014951973349147_REALK, &
      0.000000000000000_REALK,     -0.017702639812047_REALK,      0.000000000000000_REALK, &
      0.014102232378021_REALK,      0.000000000000000_REALK,     -0.004081178022874_REALK, &
      0.000000000000000_REALK,      0.010005182975580_REALK,      0.000000000000000_REALK, &
     -0.003396880346706_REALK,      0.000000000000000_REALK,      0.003574071268240_REALK, &
      0.000000000000000_REALK,      0.004946526462915_REALK,      0.000000000000000_REALK, &
     -0.001609320578948_REALK,      0.000000000000000_REALK,     -0.019906984148791_REALK, &
      0.000000000000000_REALK,      0.002007227634174_REALK,      0.000000000000000_REALK, &
      0.011184201073314_REALK,      0.000000000000000_REALK,     -0.018025499766042_REALK, &
      0.000000000000000_REALK,      0.019240566127545_REALK,      0.000000000000000_REALK, &
     -0.000447321695479_REALK,      0.000000000000000_REALK,      0.004269965206780_REALK, &
      0.000000000000000_REALK,     -0.002049546742048_REALK,      0.000000000000000_REALK, &
      0.005040151004581_REALK,      0.000000000000000_REALK,     -0.004875771501030_REALK, &
      0.000000000000000_REALK,     -0.012991034801583_REALK/
  ! results of test 3, ket-major order, CM000400
  data REF_CONTR_INTS(2463:2605) /                                                         &
      0.058398440413751_REALK,      0.000000000000000_REALK,     -0.015989372963592_REALK, &
      0.000000000000000_REALK,      0.004446602495125_REALK,      0.000000000000000_REALK, &
     -0.015287120109788_REALK,      0.000000000000000_REALK,      0.018807535707270_REALK, &
      0.000000000000000_REALK,     -0.009915269565755_REALK,      0.000000000000000_REALK, &
     -0.015528560972515_REALK,      0.000000000000000_REALK,      0.013598013923658_REALK, &
      0.000000000000000_REALK,      0.020265358892849_REALK,      0.000000000000000_REALK, &
     -0.026754755734033_REALK,      0.000000000000000_REALK,      0.000915657723236_REALK, &
      0.000000000000000_REALK,      0.023669348068302_REALK,      0.000000000000000_REALK, &
     -0.026031951142504_REALK,      0.000000000000000_REALK,      0.005353255535212_REALK, &
      0.000000000000000_REALK,     -0.045572195026743_REALK,      0.000000000000000_REALK, &
      0.040372654100371_REALK,      0.000000000000000_REALK,      0.001281766582115_REALK, &
      0.000000000000000_REALK,     -0.033184164871502_REALK,      0.000000000000000_REALK, &
      0.020168512645382_REALK,      0.000000000000000_REALK,      0.031047263234674_REALK, &
      0.000000000000000_REALK,     -0.035269156850845_REALK,      0.000000000000000_REALK, &
      0.019000511755634_REALK,      0.000000000000000_REALK,      0.010995184043008_REALK, &
      0.000000000000000_REALK,     -0.013687526778388_REALK,      0.000000000000000_REALK, &
      0.005779126383944_REALK,      0.000000000000000_REALK,     -0.032649636078334_REALK, &
      0.000000000000000_REALK,      0.030314621080565_REALK,      0.000000000000000_REALK, &
      0.002619666752294_REALK,      0.000000000000000_REALK,     -0.041261884705666_REALK, &
      0.000000000000000_REALK,      0.023532190593706_REALK,      0.000000000000000_REALK, &
      0.045400711173610_REALK,      0.000000000000000_REALK,     -0.057136726126973_REALK, &
      0.000000000000000_REALK,      0.021784441848462_REALK,      0.000000000000000_REALK, &
     -0.016571632399141_REALK,      0.000000000000000_REALK,      0.025483851839430_REALK, &
      0.000000000000000_REALK,     -0.008022305288881_REALK,      0.000000000000000_REALK, &
      0.047169370352320_REALK,      0.000000000000000_REALK,     -0.035297957143242_REALK, &
      0.000000000000000_REALK,     -0.002939875795564_REALK,      0.000000000000000_REALK, &
     -0.011049827254953_REALK,      0.000000000000000_REALK,      0.003705484338153_REALK, &
      0.000000000000000_REALK,      0.014114821158187_REALK,      0.000000000000000_REALK, &
     -0.016146583886209_REALK,      0.000000000000000_REALK,      0.007137170454857_REALK, &
      0.000000000000000_REALK,     -0.024344622170972_REALK,      0.000000000000000_REALK, &
      0.031093394619996_REALK,      0.000000000000000_REALK,     -0.012328485115395_REALK, &
      0.000000000000000_REALK,      0.054450267741517_REALK,      0.000000000000000_REALK, &
     -0.039866311559886_REALK,      0.000000000000000_REALK,     -0.002835943783373_REALK, &
      0.000000000000000_REALK,     -0.029938351767531_REALK,      0.000000000000000_REALK, &
      0.012992546754814_REALK,      0.000000000000000_REALK,      0.028197823447129_REALK, &
      0.000000000000000_REALK,     -0.038767461280930_REALK,      0.000000000000000_REALK, &
      0.020384855196668_REALK,      0.000000000000000_REALK,     -0.022773370005128_REALK, &
      0.000000000000000_REALK,      0.023217047670846_REALK,      0.000000000000000_REALK, &
     -0.008095166928971_REALK,      0.000000000000000_REALK,      0.029320559798325_REALK, &
      0.000000000000000_REALK,     -0.013661740872005_REALK,      0.000000000000000_REALK, &
      0.000974049449584_REALK,      0.000000000000000_REALK,     -0.043115275419255_REALK, &
      0.000000000000000_REALK,      0.015957922298626_REALK,      0.000000000000000_REALK, &
      0.026191150190634_REALK,      0.000000000000000_REALK,     -0.040638063539982_REALK, &
      0.000000000000000_REALK,      0.035626695598133_REALK,      0.000000000000000_REALK, &
     -0.020027374265326_REALK,      0.000000000000000_REALK,      0.018560954611161_REALK, &
      0.000000000000000_REALK,     -0.004225285118950_REALK,      0.000000000000000_REALK, &
      0.023238970903785_REALK,      0.000000000000000_REALK,     -0.018113637079770_REALK, &
      0.000000000000000_REALK,      0.005022928763141_REALK/
  ! results of test 3, ket-major order, CM030001
  data REF_CONTR_INTS(2606:2748) /                                                         &
      0.000000000000000_REALK,     -0.027350138533759_REALK,      0.000000000000000_REALK, &
     -0.007689023172393_REALK,      0.000000000000000_REALK,     -0.003095791252956_REALK, &
      0.000000000000000_REALK,     -0.009115221985546_REALK,      0.000000000000000_REALK, &
      0.013484639911433_REALK,      0.000000000000000_REALK,      0.019781579977819_REALK, &
      0.000000000000000_REALK,      0.045581568098322_REALK,      0.000000000000000_REALK, &
      0.030437910539026_REALK,      0.000000000000000_REALK,      0.009038570225382_REALK, &
      0.000000000000000_REALK,      0.048417562558134_REALK,      0.000000000000000_REALK, &
     -0.008831533094072_REALK,      0.000000000000000_REALK,     -0.022339275207526_REALK, &
      0.000000000000000_REALK,      0.031727714151599_REALK,      0.000000000000000_REALK, &
     -0.031424813088315_REALK,      0.000000000000000_REALK,     -0.041551494299043_REALK, &
      0.000000000000000_REALK,     -0.022153120222632_REALK,      0.000000000000000_REALK, &
     -0.004032582480440_REALK,      0.000000000000000_REALK,     -0.021123462134104_REALK, &
      0.000000000000000_REALK,     -0.020218334848401_REALK,      0.000000000000000_REALK, &
     -0.005764614159706_REALK,      0.000000000000000_REALK,      0.010266128427138_REALK, &
      0.000000000000000_REALK,      0.002679763281147_REALK,      0.000000000000000_REALK, &
      0.004806702016707_REALK,      0.000000000000000_REALK,     -0.014754758455224_REALK, &
      0.000000000000000_REALK,      0.020804755654011_REALK,      0.000000000000000_REALK, &
      0.010553242176490_REALK,      0.000000000000000_REALK,      0.008370618720767_REALK, &
      0.000000000000000_REALK,      0.000974314206060_REALK,      0.000000000000000_REALK, &
      0.012224297988698_REALK,      0.000000000000000_REALK,      0.007158010884421_REALK, &
      0.000000000000000_REALK,      0.004936727332568_REALK,      0.000000000000000_REALK, &
     -0.006731036895273_REALK,      0.000000000000000_REALK,     -0.001721348543160_REALK, &
      0.000000000000000_REALK,     -0.021349504135734_REALK,      0.000000000000000_REALK, &
     -0.001737353434163_REALK,      0.000000000000000_REALK,     -0.011569846447713_REALK, &
      0.000000000000000_REALK,     -0.003245187103365_REALK,      0.000000000000000_REALK, &
      0.014507366049619_REALK,      0.000000000000000_REALK,     -0.022147484755746_REALK, &
      0.000000000000000_REALK,      0.005096278952201_REALK,      0.000000000000000_REALK, &
      0.008241789091109_REALK,      0.000000000000000_REALK,     -0.001663469463221_REALK, &
      0.000000000000000_REALK,     -0.035285824654811_REALK,      0.000000000000000_REALK, &
     -0.007874324006332_REALK,      0.000000000000000_REALK,      0.035930506262978_REALK, &
      0.000000000000000_REALK,      0.002926275777199_REALK,      0.000000000000000_REALK, &
      0.012620931074259_REALK,      0.000000000000000_REALK,      0.013819928412918_REALK, &
      0.000000000000000_REALK,     -0.017095961966201_REALK,      0.000000000000000_REALK, &
      0.022395912122684_REALK,      0.000000000000000_REALK,     -0.001595727204977_REALK, &
      0.000000000000000_REALK,     -0.012921444947697_REALK,      0.000000000000000_REALK, &
      0.009072680179311_REALK,      0.000000000000000_REALK,      0.018646806764248_REALK, &
      0.000000000000000_REALK,      0.010407873728747_REALK,      0.000000000000000_REALK, &
     -0.040170044161812_REALK,      0.000000000000000_REALK,     -0.026984770906908_REALK, &
      0.000000000000000_REALK,     -0.003659899597991_REALK,      0.000000000000000_REALK, &
     -0.025545948815844_REALK,      0.000000000000000_REALK,      0.020145311540785_REALK, &
      0.000000000000000_REALK,     -0.026985625022490_REALK,      0.000000000000000_REALK, &
      0.051600698243814_REALK,      0.000000000000000_REALK,      0.043030665641462_REALK, &
      0.000000000000000_REALK,      0.005541749359928_REALK,      0.000000000000000_REALK, &
     -0.017545297162526_REALK,      0.000000000000000_REALK,     -0.028032438964809_REALK, &
      0.000000000000000_REALK,      0.002532452088229_REALK,      0.000000000000000_REALK, &
     -0.009739811377478_REALK,      0.000000000000000_REALK,      0.023238610815189_REALK, &
      0.000000000000000_REALK,      0.036561226995251_REALK,      0.000000000000000_REALK, &
      0.050910620091812_REALK,      0.000000000000000_REALK/
  ! results of test 3, ket-major order, CM020101
  data REF_CONTR_INTS(2749:2891) /                                                         &
      0.000000000000000_REALK,     -0.012005021071336_REALK,      0.000000000000000_REALK, &
     -0.002132781421191_REALK,      0.000000000000000_REALK,      0.004572788858515_REALK, &
      0.000000000000000_REALK,     -0.002291010728080_REALK,      0.000000000000000_REALK, &
      0.007465229846009_REALK,      0.000000000000000_REALK,      0.002662442485600_REALK, &
      0.000000000000000_REALK,      0.009437234782320_REALK,      0.000000000000000_REALK, &
      0.000571496378418_REALK,      0.000000000000000_REALK,     -0.002397370773909_REALK, &
      0.000000000000000_REALK,      0.018062274111843_REALK,      0.000000000000000_REALK, &
     -0.004216749277018_REALK,      0.000000000000000_REALK,     -0.007756842717285_REALK, &
      0.000000000000000_REALK,      0.010033190389049_REALK,      0.000000000000000_REALK, &
     -0.000103621313134_REALK,      0.000000000000000_REALK,     -0.010453970489959_REALK, &
      0.000000000000000_REALK,     -0.007383948917301_REALK,      0.000000000000000_REALK, &
      0.002584878417323_REALK,      0.000000000000000_REALK,     -0.002500482342172_REALK, &
      0.000000000000000_REALK,     -0.002969816789714_REALK,      0.000000000000000_REALK, &
     -0.002852799958735_REALK,      0.000000000000000_REALK,      0.003009957903545_REALK, &
      0.000000000000000_REALK,      0.000758316389161_REALK,      0.000000000000000_REALK, &
     -0.002208580119776_REALK,      0.000000000000000_REALK,     -0.005652887749172_REALK, &
      0.000000000000000_REALK,      0.007556994155603_REALK,      0.000000000000000_REALK, &
     -0.005779042738930_REALK,      0.000000000000000_REALK,     -0.000678787056362_REALK, &
      0.000000000000000_REALK,      0.000136014350658_REALK,      0.000000000000000_REALK, &
      0.006328402599631_REALK,      0.000000000000000_REALK,      0.000662024101850_REALK, &
      0.000000000000000_REALK,      0.004334098615863_REALK,      0.000000000000000_REALK, &
     -0.000028202467951_REALK,      0.000000000000000_REALK,     -0.001629087479015_REALK, &
      0.000000000000000_REALK,      0.003859459598124_REALK,      0.000000000000000_REALK, &
      0.004129303348634_REALK,      0.000000000000000_REALK,     -0.007459726066716_REALK, &
      0.000000000000000_REALK,     -0.001472513399189_REALK,      0.000000000000000_REALK, &
     -0.002450127946859_REALK,      0.000000000000000_REALK,      0.004685530347959_REALK, &
      0.000000000000000_REALK,      0.010187915590506_REALK,      0.000000000000000_REALK, &
      0.007266898721080_REALK,      0.000000000000000_REALK,      0.005738370688651_REALK, &
      0.000000000000000_REALK,      0.000921441404181_REALK,      0.000000000000000_REALK, &
      0.000431511912911_REALK,      0.000000000000000_REALK,     -0.002008470727737_REALK, &
      0.000000000000000_REALK,     -0.006147728176863_REALK,      0.000000000000000_REALK, &
      0.003066226221657_REALK,      0.000000000000000_REALK,      0.008152652566993_REALK, &
      0.000000000000000_REALK,      0.008419808991911_REALK,      0.000000000000000_REALK, &
     -0.004432356396092_REALK,      0.000000000000000_REALK,      0.002642922346524_REALK, &
      0.000000000000000_REALK,     -0.002790377720505_REALK,      0.000000000000000_REALK, &
      0.003994414375354_REALK,      0.000000000000000_REALK,     -0.003544557194398_REALK, &
      0.000000000000000_REALK,     -0.003015830519736_REALK,      0.000000000000000_REALK, &
     -0.003154451707066_REALK,      0.000000000000000_REALK,     -0.011129809655854_REALK, &
      0.000000000000000_REALK,      0.008329052440353_REALK,      0.000000000000000_REALK, &
     -0.011682768320661_REALK,      0.000000000000000_REALK,      0.002520426448516_REALK, &
      0.000000000000000_REALK,      0.002125521161495_REALK,      0.000000000000000_REALK, &
      0.012078120673249_REALK,      0.000000000000000_REALK,     -0.003303794159081_REALK, &
      0.000000000000000_REALK,      0.005611058849636_REALK,      0.000000000000000_REALK, &
     -0.012932612342313_REALK,      0.000000000000000_REALK,     -0.003199166184443_REALK, &
      0.000000000000000_REALK,      0.004306970550875_REALK,      0.000000000000000_REALK, &
     -0.003327892282728_REALK,      0.000000000000000_REALK,     -0.001643192452896_REALK, &
      0.000000000000000_REALK,     -0.001875572317752_REALK,      0.000000000000000_REALK, &
      0.006835460631744_REALK,      0.000000000000000_REALK/
  ! results of test 3, ket-major order, CM010201
  data REF_CONTR_INTS(2892:3034) /                                                         &
      0.000000000000000_REALK,     -0.008661366308607_REALK,      0.000000000000000_REALK, &
      0.002003593928979_REALK,      0.000000000000000_REALK,      0.003420678803340_REALK, &
      0.000000000000000_REALK,     -0.010097733099959_REALK,      0.000000000000000_REALK, &
      0.002770038418798_REALK,      0.000000000000000_REALK,      0.005734984469030_REALK, &
      0.000000000000000_REALK,      0.003670381085247_REALK,      0.000000000000000_REALK, &
     -0.002483893032747_REALK,      0.000000000000000_REALK,     -0.005550652970030_REALK, &
      0.000000000000000_REALK,      0.014735554875072_REALK,      0.000000000000000_REALK, &
      0.003357684431220_REALK,      0.000000000000000_REALK,     -0.001988983526139_REALK, &
      0.000000000000000_REALK,      0.007289814312820_REALK,      0.000000000000000_REALK, &
      0.005137883524677_REALK,      0.000000000000000_REALK,     -0.009531234137079_REALK, &
      0.000000000000000_REALK,     -0.009212621168517_REALK,      0.000000000000000_REALK, &
      0.000932122113727_REALK,      0.000000000000000_REALK,     -0.001371229626146_REALK, &
      0.000000000000000_REALK,     -0.003052224382145_REALK,      0.000000000000000_REALK, &
     -0.001616735141669_REALK,      0.000000000000000_REALK,      0.000529650209493_REALK, &
      0.000000000000000_REALK,     -0.001915515159644_REALK,      0.000000000000000_REALK, &
     -0.004157016845248_REALK,      0.000000000000000_REALK,     -0.001839386386791_REALK, &
      0.000000000000000_REALK,      0.007383931206848_REALK,      0.000000000000000_REALK, &
     -0.006227534899580_REALK,      0.000000000000000_REALK,     -0.003672724758085_REALK, &
      0.000000000000000_REALK,      0.002782326748769_REALK,      0.000000000000000_REALK, &
      0.006510619500955_REALK,      0.000000000000000_REALK,     -0.000238487127183_REALK, &
      0.000000000000000_REALK,      0.004585364633624_REALK,      0.000000000000000_REALK, &
      0.003184471878732_REALK,      0.000000000000000_REALK,     -0.001540019614561_REALK, &
      0.000000000000000_REALK,      0.000027505107989_REALK,      0.000000000000000_REALK, &
     -0.000813691401996_REALK,      0.000000000000000_REALK,     -0.003599179625462_REALK, &
      0.000000000000000_REALK,      0.004469828863362_REALK,      0.000000000000000_REALK, &
      0.005330245782036_REALK,      0.000000000000000_REALK,     -0.000779249046971_REALK, &
      0.000000000000000_REALK,      0.003576736032425_REALK,      0.000000000000000_REALK, &
     -0.000614544400848_REALK,      0.000000000000000_REALK,      0.003271946948907_REALK, &
      0.000000000000000_REALK,     -0.000481401653507_REALK,      0.000000000000000_REALK, &
     -0.001547206785172_REALK,      0.000000000000000_REALK,      0.001271894499776_REALK, &
      0.000000000000000_REALK,     -0.002569263538900_REALK,      0.000000000000000_REALK, &
     -0.002710263527607_REALK,      0.000000000000000_REALK,      0.001392379440496_REALK, &
      0.000000000000000_REALK,      0.004396825379950_REALK,      0.000000000000000_REALK, &
      0.002690851434035_REALK,      0.000000000000000_REALK,      0.006731498566742_REALK, &
      0.000000000000000_REALK,     -0.000728792450315_REALK,      0.000000000000000_REALK, &
      0.006726203293474_REALK,      0.000000000000000_REALK,      0.000265125407235_REALK, &
      0.000000000000000_REALK,     -0.002266591554563_REALK,      0.000000000000000_REALK, &
     -0.006901210019168_REALK,      0.000000000000000_REALK,     -0.007032477409858_REALK, &
      0.000000000000000_REALK,      0.006563307885696_REALK,      0.000000000000000_REALK, &
     -0.010291684259413_REALK,      0.000000000000000_REALK,      0.001647248604517_REALK, &
      0.000000000000000_REALK,      0.001915363069589_REALK,      0.000000000000000_REALK, &
      0.012081914995815_REALK,      0.000000000000000_REALK,      0.000251980093599_REALK, &
      0.000000000000000_REALK,      0.011820551516683_REALK,      0.000000000000000_REALK, &
     -0.008624914146276_REALK,      0.000000000000000_REALK,     -0.007292207714489_REALK, &
      0.000000000000000_REALK,     -0.000652938856329_REALK,      0.000000000000000_REALK, &
     -0.002769543923973_REALK,      0.000000000000000_REALK,      0.000187665281713_REALK, &
      0.000000000000000_REALK,     -0.000165235898114_REALK,      0.000000000000000_REALK, &
      0.009453454999070_REALK,      0.000000000000000_REALK/
  ! results of test 3, ket-major order, CM000301
  data REF_CONTR_INTS(3035:3177) /                                                         &
      0.000000000000000_REALK,     -0.017030889547570_REALK,      0.000000000000000_REALK, &
      0.006101970071664_REALK,      0.000000000000000_REALK,      0.011219439812631_REALK, &
      0.000000000000000_REALK,     -0.014970394682463_REALK,      0.000000000000000_REALK, &
      0.010242084269133_REALK,      0.000000000000000_REALK,      0.008075063061719_REALK, &
      0.000000000000000_REALK,      0.000616122522669_REALK,      0.000000000000000_REALK, &
     -0.001374158137600_REALK,      0.000000000000000_REALK,     -0.004926936409740_REALK, &
      0.000000000000000_REALK,      0.014905411572011_REALK,      0.000000000000000_REALK, &
     -0.004697826080432_REALK,      0.000000000000000_REALK,     -0.004617221371820_REALK, &
      0.000000000000000_REALK,      0.006771794135469_REALK,      0.000000000000000_REALK, &
      0.011945776379302_REALK,      0.000000000000000_REALK,     -0.011064973681181_REALK, &
      0.000000000000000_REALK,     -0.013451446112556_REALK,      0.000000000000000_REALK, &
      0.010020864604431_REALK,      0.000000000000000_REALK,      0.001346198257775_REALK, &
      0.000000000000000_REALK,     -0.001755210933124_REALK,      0.000000000000000_REALK, &
     -0.001034698878167_REALK,      0.000000000000000_REALK,      0.005682351691372_REALK, &
      0.000000000000000_REALK,     -0.004999999746594_REALK,      0.000000000000000_REALK, &
     -0.000895453707287_REALK,      0.000000000000000_REALK,      0.002500186449207_REALK, &
      0.000000000000000_REALK,      0.007527141170569_REALK,      0.000000000000000_REALK, &
     -0.008307105852444_REALK,      0.000000000000000_REALK,     -0.009896624642254_REALK, &
      0.000000000000000_REALK,      0.010261139053027_REALK,      0.000000000000000_REALK, &
      0.006138504074593_REALK,      0.000000000000000_REALK,     -0.002818737053987_REALK, &
      0.000000000000000_REALK,      0.001763378732360_REALK,      0.000000000000000_REALK, &
      0.009891148569711_REALK,      0.000000000000000_REALK,     -0.005636302628383_REALK, &
      0.000000000000000_REALK,     -0.002051743845406_REALK,      0.000000000000000_REALK, &
     -0.002103241834158_REALK,      0.000000000000000_REALK,     -0.003637762298714_REALK, &
      0.000000000000000_REALK,      0.000057663898851_REALK,      0.000000000000000_REALK, &
      0.011996067475704_REALK,      0.000000000000000_REALK,      0.002691338829400_REALK, &
      0.000000000000000_REALK,      0.005148503135904_REALK,      0.000000000000000_REALK, &
      0.000114779853441_REALK,      0.000000000000000_REALK,      0.004001633179774_REALK, &
      0.000000000000000_REALK,      0.002880307561460_REALK,      0.000000000000000_REALK, &
     -0.000984256173526_REALK,      0.000000000000000_REALK,     -0.004404815787403_REALK, &
      0.000000000000000_REALK,     -0.004205742159430_REALK,      0.000000000000000_REALK, &
     -0.001315057167559_REALK,      0.000000000000000_REALK,     -0.001318479616455_REALK, &
      0.000000000000000_REALK,      0.015368173772725_REALK,      0.000000000000000_REALK, &
      0.005166165122641_REALK,      0.000000000000000_REALK,      0.009043362434449_REALK, &
      0.000000000000000_REALK,     -0.003182616796512_REALK,      0.000000000000000_REALK, &
      0.009976167001441_REALK,      0.000000000000000_REALK,     -0.000204334827743_REALK, &
      0.000000000000000_REALK,     -0.004916052292792_REALK,      0.000000000000000_REALK, &
     -0.004758313179772_REALK,      0.000000000000000_REALK,     -0.004757641552216_REALK, &
      0.000000000000000_REALK,      0.006376886885432_REALK,      0.000000000000000_REALK, &
     -0.011579574268039_REALK,      0.000000000000000_REALK,      0.005581476953797_REALK, &
      0.000000000000000_REALK,      0.008262405137663_REALK,      0.000000000000000_REALK, &
      0.013392868407019_REALK,      0.000000000000000_REALK,     -0.003846823609143_REALK, &
      0.000000000000000_REALK,      0.023183372338443_REALK,      0.000000000000000_REALK, &
     -0.015305284355562_REALK,      0.000000000000000_REALK,     -0.010922643588648_REALK, &
      0.000000000000000_REALK,      0.000192434685642_REALK,      0.000000000000000_REALK, &
     -0.004005048500435_REALK,      0.000000000000000_REALK,     -0.003956897876040_REALK, &
      0.000000000000000_REALK,      0.003851578211070_REALK,      0.000000000000000_REALK, &
      0.005292873336436_REALK,      0.000000000000000_REALK/
  ! results of test 3, ket-major order, CM020002
  data REF_CONTR_INTS(3178:3320) /                                                         &
      0.005071730531789_REALK,      0.000000000000000_REALK,      0.019806959760283_REALK, &
      0.000000000000000_REALK,      0.009718228434903_REALK,      0.000000000000000_REALK, &
      0.004572053612331_REALK,      0.000000000000000_REALK,      0.009070990137591_REALK, &
      0.000000000000000_REALK,     -0.005621567284702_REALK,      0.000000000000000_REALK, &
     -0.027566088825608_REALK,      0.000000000000000_REALK,      0.006021032995307_REALK, &
      0.000000000000000_REALK,     -0.012149360545426_REALK,      0.000000000000000_REALK, &
     -0.031897422009676_REALK,      0.000000000000000_REALK,     -0.008537579429666_REALK, &
      0.000000000000000_REALK,      0.009556959483064_REALK,      0.000000000000000_REALK, &
      0.001281399103130_REALK,      0.000000000000000_REALK,     -0.000665432797180_REALK, &
      0.000000000000000_REALK,      0.001597720496860_REALK,      0.000000000000000_REALK, &
      0.045805835894076_REALK,      0.000000000000000_REALK,      0.002414342750648_REALK, &
      0.000000000000000_REALK,      0.001978055384307_REALK,      0.000000000000000_REALK, &
      0.024610903869170_REALK,      0.000000000000000_REALK,     -0.012145834942412_REALK, &
      0.000000000000000_REALK,     -0.002176535725969_REALK,      0.000000000000000_REALK, &
     -0.011369799726045_REALK,      0.000000000000000_REALK,     -0.001702921614039_REALK, &
      0.000000000000000_REALK,      0.001444594962521_REALK,      0.000000000000000_REALK, &
     -0.001608475013309_REALK,      0.000000000000000_REALK,     -0.002306817052761_REALK, &
      0.000000000000000_REALK,     -0.006818968271195_REALK,      0.000000000000000_REALK, &
     -0.000367876193029_REALK,      0.000000000000000_REALK,     -0.003664145555962_REALK, &
      0.000000000000000_REALK,     -0.014638781797201_REALK,      0.000000000000000_REALK, &
      0.010148771184936_REALK,      0.000000000000000_REALK,     -0.003697908063729_REALK, &
      0.000000000000000_REALK,      0.005285956378292_REALK,      0.000000000000000_REALK, &
     -0.002206060443494_REALK,      0.000000000000000_REALK,      0.013435619122549_REALK, &
      0.000000000000000_REALK,      0.012214167243341_REALK,      0.000000000000000_REALK, &
      0.003800496806865_REALK,      0.000000000000000_REALK,      0.003814768643890_REALK, &
      0.000000000000000_REALK,     -0.006628521848857_REALK,      0.000000000000000_REALK, &
      0.009594919301019_REALK,      0.000000000000000_REALK,     -0.024815651990512_REALK, &
      0.000000000000000_REALK,      0.023856470182052_REALK,      0.000000000000000_REALK, &
      0.014266123465451_REALK,      0.000000000000000_REALK,      0.016513641045777_REALK, &
      0.000000000000000_REALK,      0.000697761563554_REALK,      0.000000000000000_REALK, &
     -0.020992735467992_REALK,      0.000000000000000_REALK,     -0.018060407397369_REALK, &
      0.000000000000000_REALK,     -0.002547306803209_REALK,      0.000000000000000_REALK, &
     -0.017094726438318_REALK,      0.000000000000000_REALK,      0.008668951804803_REALK, &
      0.000000000000000_REALK,     -0.010592655065932_REALK,      0.000000000000000_REALK, &
      0.001989413433381_REALK,      0.000000000000000_REALK,     -0.007773356905679_REALK, &
      0.000000000000000_REALK,     -0.021659031274444_REALK,      0.000000000000000_REALK, &
     -0.012785671166583_REALK,      0.000000000000000_REALK,      0.003027020845699_REALK, &
      0.000000000000000_REALK,      0.044736465899200_REALK,      0.000000000000000_REALK, &
      0.024351752070182_REALK,      0.000000000000000_REALK,      0.011265638692840_REALK, &
      0.000000000000000_REALK,      0.015994407100602_REALK,      0.000000000000000_REALK, &
     -0.013648385888178_REALK,      0.000000000000000_REALK,     -0.018485902551340_REALK, &
      0.000000000000000_REALK,     -0.025226244574672_REALK,      0.000000000000000_REALK, &
      0.010681331202366_REALK,      0.000000000000000_REALK,      0.007876498959329_REALK, &
      0.000000000000000_REALK,      0.037054706600635_REALK,      0.000000000000000_REALK, &
     -0.010144063222850_REALK,      0.000000000000000_REALK,      0.009717663474741_REALK, &
      0.000000000000000_REALK,      0.010587974490894_REALK,      0.000000000000000_REALK, &
      0.001967189259834_REALK,      0.000000000000000_REALK,     -0.013684371170241_REALK, &
      0.000000000000000_REALK,     -0.006391108265309_REALK/
  ! results of test 3, ket-major order, CM010102
  data REF_CONTR_INTS(3321:3463) /                                                         &
      0.001384436039461_REALK,      0.000000000000000_REALK,      0.007213063608101_REALK, &
      0.000000000000000_REALK,     -0.000079676562389_REALK,      0.000000000000000_REALK, &
      0.003299344317942_REALK,      0.000000000000000_REALK,      0.001650615050278_REALK, &
      0.000000000000000_REALK,     -0.003888093058080_REALK,      0.000000000000000_REALK, &
     -0.011947013279098_REALK,      0.000000000000000_REALK,      0.000604823927266_REALK, &
      0.000000000000000_REALK,      0.005769054792404_REALK,      0.000000000000000_REALK, &
     -0.011730922944737_REALK,      0.000000000000000_REALK,     -0.003812521130524_REALK, &
      0.000000000000000_REALK,      0.003467629483644_REALK,      0.000000000000000_REALK, &
      0.000412890383739_REALK,      0.000000000000000_REALK,     -0.002312473212442_REALK, &
      0.000000000000000_REALK,     -0.006219626465959_REALK,      0.000000000000000_REALK, &
      0.019657283243658_REALK,      0.000000000000000_REALK,      0.001090362134456_REALK, &
      0.000000000000000_REALK,     -0.000665827299509_REALK,      0.000000000000000_REALK, &
      0.008367263609533_REALK,      0.000000000000000_REALK,     -0.003005740714418_REALK, &
      0.000000000000000_REALK,     -0.000120542760990_REALK,      0.000000000000000_REALK, &
     -0.003014946347802_REALK,      0.000000000000000_REALK,      0.001267141951644_REALK, &
      0.000000000000000_REALK,      0.003754709916085_REALK,      0.000000000000000_REALK, &
      0.000073167727551_REALK,      0.000000000000000_REALK,     -0.002066370224756_REALK, &
      0.000000000000000_REALK,      0.004931788939049_REALK,      0.000000000000000_REALK, &
      0.001202355353742_REALK,      0.000000000000000_REALK,     -0.004769855235641_REALK, &
      0.000000000000000_REALK,     -0.006279875341687_REALK,      0.000000000000000_REALK, &
      0.006870505067323_REALK,      0.000000000000000_REALK,     -0.007837583754034_REALK, &
      0.000000000000000_REALK,      0.001074245508731_REALK,      0.000000000000000_REALK, &
      0.000542266604697_REALK,      0.000000000000000_REALK,     -0.000920564514393_REALK, &
      0.000000000000000_REALK,     -0.001157232063315_REALK,      0.000000000000000_REALK, &
      0.003171550471593_REALK,      0.000000000000000_REALK,     -0.003039038440007_REALK, &
      0.000000000000000_REALK,      0.000335227593999_REALK,      0.000000000000000_REALK, &
     -0.005239277979754_REALK,      0.000000000000000_REALK,     -0.009059243582009_REALK, &
      0.000000000000000_REALK,      0.004713545796984_REALK,      0.000000000000000_REALK, &
     -0.005469983222473_REALK,      0.000000000000000_REALK,      0.001501324259922_REALK, &
      0.000000000000000_REALK,     -0.001644973592350_REALK,      0.000000000000000_REALK, &
      0.003117502701877_REALK,      0.000000000000000_REALK,      0.002569099798681_REALK, &
      0.000000000000000_REALK,      0.003483973896278_REALK,      0.000000000000000_REALK, &
     -0.007457344949325_REALK,      0.000000000000000_REALK,     -0.003277593311340_REALK, &
      0.000000000000000_REALK,     -0.003756902490676_REALK,      0.000000000000000_REALK, &
     -0.004849821639966_REALK,      0.000000000000000_REALK,      0.006654108516917_REALK, &
      0.000000000000000_REALK,     -0.005677214594569_REALK,      0.000000000000000_REALK, &
      0.004033906736651_REALK,      0.000000000000000_REALK,      0.001341379421097_REALK, &
      0.000000000000000_REALK,      0.013953522859799_REALK,      0.000000000000000_REALK, &
     -0.002868387681096_REALK,      0.000000000000000_REALK,      0.003306201885203_REALK, &
      0.000000000000000_REALK,      0.000538432278723_REALK,      0.000000000000000_REALK, &
     -0.001163947655370_REALK,      0.000000000000000_REALK,     -0.002086484963851_REALK, &
      0.000000000000000_REALK,     -0.010246938027017_REALK,      0.000000000000000_REALK, &
      0.002372178431892_REALK,      0.000000000000000_REALK,     -0.004478569225708_REALK, &
      0.000000000000000_REALK,      0.010978224483601_REALK,      0.000000000000000_REALK, &
     -0.001484300621404_REALK,      0.000000000000000_REALK,      0.001708764326954_REALK, &
      0.000000000000000_REALK,     -0.000225186838606_REALK,      0.000000000000000_REALK, &
      0.003682499738575_REALK,      0.000000000000000_REALK,     -0.009435615958230_REALK, &
      0.000000000000000_REALK,     -0.001634603183207_REALK/
  ! results of test 3, ket-major order, CM000202
  data REF_CONTR_INTS(3464:3606) /                                                         &
      0.004308216363475_REALK,      0.000000000000000_REALK,      0.005923231741324_REALK, &
      0.000000000000000_REALK,     -0.001938289613011_REALK,      0.000000000000000_REALK, &
      0.006566233853241_REALK,      0.000000000000000_REALK,     -0.001303968936076_REALK, &
      0.000000000000000_REALK,     -0.003145839857807_REALK,      0.000000000000000_REALK, &
     -0.007387711073077_REALK,      0.000000000000000_REALK,      0.002680721013057_REALK, &
      0.000000000000000_REALK,      0.009222200248030_REALK,      0.000000000000000_REALK, &
     -0.016545969885160_REALK,      0.000000000000000_REALK,     -0.002417756965450_REALK, &
      0.000000000000000_REALK,      0.002871492551228_REALK,      0.000000000000000_REALK, &
     -0.000687376830973_REALK,      0.000000000000000_REALK,     -0.003572318502207_REALK, &
      0.000000000000000_REALK,     -0.012818193078539_REALK,      0.000000000000000_REALK, &
      0.020489093279843_REALK,      0.000000000000000_REALK,      0.004754528546630_REALK, &
      0.000000000000000_REALK,     -0.004208922247176_REALK,      0.000000000000000_REALK, &
      0.005928009134910_REALK,      0.000000000000000_REALK,      0.002747929438860_REALK, &
      0.000000000000000_REALK,     -0.003451092187577_REALK,      0.000000000000000_REALK, &
      0.000041215583221_REALK,      0.000000000000000_REALK,      0.000866820347854_REALK, &
      0.000000000000000_REALK,      0.001053327277842_REALK,      0.000000000000000_REALK, &
      0.000159329600150_REALK,      0.000000000000000_REALK,     -0.005744537111770_REALK, &
      0.000000000000000_REALK,      0.010428402001000_REALK,      0.000000000000000_REALK, &
      0.001590985921982_REALK,      0.000000000000000_REALK,     -0.009250411717839_REALK, &
      0.000000000000000_REALK,     -0.001915065161298_REALK,      0.000000000000000_REALK, &
      0.009471340839611_REALK,      0.000000000000000_REALK,     -0.012258556204690_REALK, &
      0.000000000000000_REALK,     -0.001959681325422_REALK,      0.000000000000000_REALK, &
      0.000042206170725_REALK,      0.000000000000000_REALK,      0.003168423253728_REALK, &
      0.000000000000000_REALK,     -0.000566187219708_REALK,      0.000000000000000_REALK, &
      0.007189374386241_REALK,      0.000000000000000_REALK,     -0.008481272483712_REALK, &
      0.000000000000000_REALK,     -0.004342591751465_REALK,      0.000000000000000_REALK, &
     -0.002915599475233_REALK,      0.000000000000000_REALK,     -0.004020103976732_REALK, &
      0.000000000000000_REALK,      0.005047643510573_REALK,      0.000000000000000_REALK, &
     -0.006041922430154_REALK,      0.000000000000000_REALK,      0.000589145548952_REALK, &
      0.000000000000000_REALK,      0.000717378194255_REALK,      0.000000000000000_REALK, &
      0.004262052154849_REALK,      0.000000000000000_REALK,     -0.000907778139003_REALK, &
      0.000000000000000_REALK,      0.009811122784601_REALK,      0.000000000000000_REALK, &
     -0.009935287376396_REALK,      0.000000000000000_REALK,     -0.004521728107480_REALK, &
      0.000000000000000_REALK,     -0.008272080205803_REALK,      0.000000000000000_REALK, &
     -0.003463316540572_REALK,      0.000000000000000_REALK,      0.006637499386294_REALK, &
      0.000000000000000_REALK,     -0.010982052853947_REALK,      0.000000000000000_REALK, &
      0.001998585094449_REALK,      0.000000000000000_REALK,      0.001251048420967_REALK, &
      0.000000000000000_REALK,      0.012029297487707_REALK,      0.000000000000000_REALK, &
      0.000233933957997_REALK,      0.000000000000000_REALK,      0.008957178243017_REALK, &
      0.000000000000000_REALK,      0.001671360944505_REALK,      0.000000000000000_REALK, &
     -0.004364932215450_REALK,      0.000000000000000_REALK,     -0.007729560492102_REALK, &
      0.000000000000000_REALK,     -0.005901752699713_REALK,      0.000000000000000_REALK, &
      0.001125219298713_REALK,      0.000000000000000_REALK,     -0.004855279019510_REALK, &
      0.000000000000000_REALK,      0.016596554216096_REALK,      0.000000000000000_REALK, &
     -0.002505885329786_REALK,      0.000000000000000_REALK,      0.002917665114363_REALK, &
      0.000000000000000_REALK,      0.000678363050081_REALK,      0.000000000000000_REALK, &
      0.005348203095790_REALK,      0.000000000000000_REALK,     -0.008053184139066_REALK, &
      0.000000000000000_REALK,     -0.000564219489036_REALK/
  ! results of test 3, ket-major order, CM010003
  data REF_CONTR_INTS(3607:3749) /                                                         &
      0.000000000000000_REALK,     -0.009895315285220_REALK,      0.000000000000000_REALK, &
     -0.002852435601998_REALK,      0.000000000000000_REALK,     -0.002013967035830_REALK, &
      0.000000000000000_REALK,     -0.010258417506037_REALK,      0.000000000000000_REALK, &
      0.003267936822781_REALK,      0.000000000000000_REALK,      0.008749653967852_REALK, &
      0.000000000000000_REALK,      0.017922674011103_REALK,      0.000000000000000_REALK, &
      0.003233405689360_REALK,      0.000000000000000_REALK,      0.003073604025739_REALK, &
      0.000000000000000_REALK,      0.031163318284542_REALK,      0.000000000000000_REALK, &
     -0.001842656652944_REALK,      0.000000000000000_REALK,     -0.015981417891881_REALK, &
      0.000000000000000_REALK,      0.026191578637200_REALK,      0.000000000000000_REALK, &
     -0.014263758087605_REALK,      0.000000000000000_REALK,     -0.025534040273183_REALK, &
      0.000000000000000_REALK,     -0.023190830823659_REALK,      0.000000000000000_REALK, &
      0.002752944454457_REALK,      0.000000000000000_REALK,     -0.020608413110459_REALK, &
      0.000000000000000_REALK,     -0.004170192190763_REALK,      0.000000000000000_REALK, &
     -0.001723156798636_REALK,      0.000000000000000_REALK,      0.019823244568843_REALK, &
      0.000000000000000_REALK,      0.004496858313855_REALK,      0.000000000000000_REALK, &
      0.002573461737632_REALK,      0.000000000000000_REALK,     -0.001681203791566_REALK, &
      0.000000000000000_REALK,      0.004655370999456_REALK,      0.000000000000000_REALK, &
      0.001419975488410_REALK,      0.000000000000000_REALK,     -0.003060012292017_REALK, &
      0.000000000000000_REALK,      0.000940720231058_REALK,      0.000000000000000_REALK, &
      0.014111408762061_REALK,      0.000000000000000_REALK,      0.001609485984912_REALK, &
      0.000000000000000_REALK,      0.001316745581359_REALK,      0.000000000000000_REALK, &
     -0.001203553883661_REALK,      0.000000000000000_REALK,     -0.001736092740868_REALK, &
      0.000000000000000_REALK,     -0.005781439974951_REALK,      0.000000000000000_REALK, &
     -0.006636388729883_REALK,      0.000000000000000_REALK,      0.001566067691084_REALK, &
      0.000000000000000_REALK,     -0.000418660597171_REALK,      0.000000000000000_REALK, &
      0.011365297760702_REALK,      0.000000000000000_REALK,     -0.004494809085086_REALK, &
      0.000000000000000_REALK,      0.008138192864140_REALK,      0.000000000000000_REALK, &
     -0.003049175304887_REALK,      0.000000000000000_REALK,     -0.000991887134256_REALK, &
      0.000000000000000_REALK,     -0.022285418931458_REALK,      0.000000000000000_REALK, &
      0.001142797486100_REALK,      0.000000000000000_REALK,      0.009469914497843_REALK, &
      0.000000000000000_REALK,      0.001166029431638_REALK,      0.000000000000000_REALK, &
      0.000504799515677_REALK,      0.000000000000000_REALK,      0.004320434743387_REALK, &
      0.000000000000000_REALK,     -0.006627253766557_REALK,      0.000000000000000_REALK, &
      0.008300589121597_REALK,      0.000000000000000_REALK,      0.015881732778056_REALK, &
      0.000000000000000_REALK,      0.003230545369886_REALK,      0.000000000000000_REALK, &
      0.004982422111550_REALK,      0.000000000000000_REALK,      0.021919543708311_REALK, &
      0.000000000000000_REALK,     -0.003008883080446_REALK,      0.000000000000000_REALK, &
     -0.029325674636656_REALK,      0.000000000000000_REALK,     -0.022406837715712_REALK, &
      0.000000000000000_REALK,      0.007938721059564_REALK,      0.000000000000000_REALK, &
     -0.020455817189116_REALK,      0.000000000000000_REALK,      0.013378695905142_REALK, &
      0.000000000000000_REALK,     -0.004160100312155_REALK,      0.000000000000000_REALK, &
      0.028225095881853_REALK,      0.000000000000000_REALK,      0.016415569741048_REALK, &
      0.000000000000000_REALK,      0.010554975406707_REALK,      0.000000000000000_REALK, &
     -0.010837097175613_REALK,      0.000000000000000_REALK,     -0.011606902444948_REALK, &
      0.000000000000000_REALK,      0.000204887893974_REALK,      0.000000000000000_REALK, &
     -0.007790105022335_REALK,      0.000000000000000_REALK,      0.001823837637410_REALK, &
      0.000000000000000_REALK,      0.007518484098987_REALK,      0.000000000000000_REALK, &
      0.012680604411166_REALK,      0.000000000000000_REALK/
  ! results of test 3, ket-major order, CM000103
  data REF_CONTR_INTS(3750:3892) /                                                         &
      0.000000000000000_REALK,     -0.005897109836027_REALK,      0.000000000000000_REALK, &
     -0.002209552394293_REALK,      0.000000000000000_REALK,      0.002237737382974_REALK, &
      0.000000000000000_REALK,     -0.005260700634832_REALK,      0.000000000000000_REALK, &
      0.005140780644792_REALK,      0.000000000000000_REALK,      0.003966131409202_REALK, &
      0.000000000000000_REALK,      0.009342936095747_REALK,      0.000000000000000_REALK, &
     -0.001696441603503_REALK,      0.000000000000000_REALK,      0.000737389366407_REALK, &
      0.000000000000000_REALK,      0.014096454126816_REALK,      0.000000000000000_REALK, &
     -0.003224790422160_REALK,      0.000000000000000_REALK,     -0.009637770911480_REALK, &
      0.000000000000000_REALK,      0.007491958733027_REALK,      0.000000000000000_REALK, &
      0.006563372413144_REALK,      0.000000000000000_REALK,     -0.012629939826511_REALK, &
      0.000000000000000_REALK,     -0.014716777843570_REALK,      0.000000000000000_REALK, &
      0.003420149894260_REALK,      0.000000000000000_REALK,     -0.005390866136004_REALK, &
      0.000000000000000_REALK,     -0.002102021697132_REALK,      0.000000000000000_REALK, &
     -0.005291381185105_REALK,      0.000000000000000_REALK,      0.009024102837360_REALK, &
      0.000000000000000_REALK,      0.001040569337096_REALK,      0.000000000000000_REALK, &
     -0.000417741034869_REALK,      0.000000000000000_REALK,      0.000214730412238_REALK, &
      0.000000000000000_REALK,      0.003193261406293_REALK,      0.000000000000000_REALK, &
     -0.004204079190447_REALK,      0.000000000000000_REALK,     -0.006074505585519_REALK, &
      0.000000000000000_REALK,      0.003743728028911_REALK,      0.000000000000000_REALK, &
      0.010948519548653_REALK,      0.000000000000000_REALK,     -0.000687860673528_REALK, &
      0.000000000000000_REALK,     -0.002706830207958_REALK,      0.000000000000000_REALK, &
      0.010376291239831_REALK,      0.000000000000000_REALK,      0.000631272986034_REALK, &
      0.000000000000000_REALK,     -0.003223758328151_REALK,      0.000000000000000_REALK, &
     -0.001965726654756_REALK,      0.000000000000000_REALK,     -0.000385145608319_REALK, &
      0.000000000000000_REALK,     -0.002184285971791_REALK,      0.000000000000000_REALK, &
      0.004607802421882_REALK,      0.000000000000000_REALK,      0.001702409662416_REALK, &
      0.000000000000000_REALK,      0.011167085786861_REALK,      0.000000000000000_REALK, &
      0.002931837894400_REALK,      0.000000000000000_REALK,      0.002151403068508_REALK, &
      0.000000000000000_REALK,      0.002933118989722_REALK,      0.000000000000000_REALK, &
     -0.001939320894805_REALK,      0.000000000000000_REALK,     -0.003110441969493_REALK, &
      0.000000000000000_REALK,     -0.003876103130562_REALK,      0.000000000000000_REALK, &
      0.001728818668323_REALK,      0.000000000000000_REALK,      0.001015224243700_REALK, &
      0.000000000000000_REALK,      0.010604972541419_REALK,      0.000000000000000_REALK, &
      0.002231829600344_REALK,      0.000000000000000_REALK,      0.014114638691959_REALK, &
      0.000000000000000_REALK,     -0.003830039568663_REALK,      0.000000000000000_REALK, &
     -0.000979504741289_REALK,      0.000000000000000_REALK,      0.005401758006824_REALK, &
      0.000000000000000_REALK,     -0.001511034089562_REALK,      0.000000000000000_REALK, &
     -0.006793512850319_REALK,      0.000000000000000_REALK,     -0.013420492025915_REALK, &
      0.000000000000000_REALK,      0.011140306019221_REALK,      0.000000000000000_REALK, &
     -0.015739867719691_REALK,      0.000000000000000_REALK,      0.008266365273572_REALK, &
      0.000000000000000_REALK,     -0.000231768793808_REALK,      0.000000000000000_REALK, &
      0.009876870503753_REALK,      0.000000000000000_REALK,     -0.000246650765594_REALK, &
      0.000000000000000_REALK,      0.013199423993512_REALK,      0.000000000000000_REALK, &
     -0.016421433374817_REALK,      0.000000000000000_REALK,     -0.005294472121367_REALK, &
      0.000000000000000_REALK,      0.002675239906126_REALK,      0.000000000000000_REALK, &
     -0.003777732239831_REALK,      0.000000000000000_REALK,     -0.002700316776893_REALK, &
      0.000000000000000_REALK,      0.004609660719049_REALK,      0.000000000000000_REALK, &
      0.003960580175303_REALK,      0.000000000000000_REALK/
  ! results of test 3, ket-major order, CM000004
  data REF_CONTR_INTS(3893:4035) /                                                         &
      0.002174246740718_REALK,      0.000000000000000_REALK,      0.009906492296040_REALK, &
      0.000000000000000_REALK,      0.001639218271616_REALK,      0.000000000000000_REALK, &
      0.005719927158424_REALK,      0.000000000000000_REALK,      0.003015300804389_REALK, &
      0.000000000000000_REALK,     -0.003090721105261_REALK,      0.000000000000000_REALK, &
     -0.018917916437215_REALK,      0.000000000000000_REALK,      0.004023094557110_REALK, &
      0.000000000000000_REALK,      0.000464709313767_REALK,      0.000000000000000_REALK, &
     -0.027869118811945_REALK,      0.000000000000000_REALK,     -0.006041293079175_REALK, &
      0.000000000000000_REALK,      0.011206286509972_REALK,      0.000000000000000_REALK, &
      0.001045518534796_REALK,      0.000000000000000_REALK,     -0.004599142661519_REALK, &
      0.000000000000000_REALK,     -0.009912500714301_REALK,      0.000000000000000_REALK, &
      0.052393266236376_REALK,      0.000000000000000_REALK,      0.005285370557175_REALK, &
      0.000000000000000_REALK,     -0.000912726635621_REALK,      0.000000000000000_REALK, &
      0.036597933511445_REALK,      0.000000000000000_REALK,     -0.020119140480543_REALK, &
      0.000000000000000_REALK,     -0.001463203514565_REALK,      0.000000000000000_REALK, &
     -0.025793167308709_REALK,      0.000000000000000_REALK,     -0.000514610888466_REALK, &
      0.000000000000000_REALK,     -0.017528587678943_REALK,      0.000000000000000_REALK, &
      0.003667990506357_REALK,      0.000000000000000_REALK,      0.003155808340092_REALK, &
      0.000000000000000_REALK,      0.007518639730668_REALK,      0.000000000000000_REALK, &
      0.005439870992368_REALK,      0.000000000000000_REALK,     -0.008615722827711_REALK, &
      0.000000000000000_REALK,     -0.014796779801420_REALK,      0.000000000000000_REALK, &
      0.014761256420760_REALK,      0.000000000000000_REALK,     -0.010898667809366_REALK, &
      0.000000000000000_REALK,     -0.003802930529778_REALK,      0.000000000000000_REALK, &
     -0.000868178165824_REALK,      0.000000000000000_REALK,      0.020918771594140_REALK, &
      0.000000000000000_REALK,     -0.001823381807944_REALK,      0.000000000000000_REALK, &
     -0.002354931549782_REALK,      0.000000000000000_REALK,     -0.008987393490357_REALK, &
      0.000000000000000_REALK,     -0.005640694728011_REALK,      0.000000000000000_REALK, &
      0.005818829081145_REALK,      0.000000000000000_REALK,     -0.022651674627508_REALK, &
      0.000000000000000_REALK,      0.019064437469008_REALK,      0.000000000000000_REALK, &
     -0.000382447303001_REALK,      0.000000000000000_REALK,      0.004481897889481_REALK, &
      0.000000000000000_REALK,      0.005314795197604_REALK,      0.000000000000000_REALK, &
     -0.004514928954947_REALK,      0.000000000000000_REALK,     -0.002209523399459_REALK, &
      0.000000000000000_REALK,      0.003261435318487_REALK,      0.000000000000000_REALK, &
      0.001987009699628_REALK,      0.000000000000000_REALK,      0.000568347570786_REALK, &
      0.000000000000000_REALK,     -0.031688273734417_REALK,      0.000000000000000_REALK, &
     -0.008419775879050_REALK,      0.000000000000000_REALK,      0.008643845618405_REALK, &
      0.000000000000000_REALK,     -0.027613390796312_REALK,      0.000000000000000_REALK, &
     -0.006700913058897_REALK,      0.000000000000000_REALK,      0.003726080721170_REALK, &
      0.000000000000000_REALK,      0.043312280976099_REALK,      0.000000000000000_REALK, &
      0.012832265439603_REALK,      0.000000000000000_REALK,      0.014371043576034_REALK, &
      0.000000000000000_REALK,      0.010682742984193_REALK,      0.000000000000000_REALK, &
     -0.013220138361551_REALK,      0.000000000000000_REALK,     -0.009624456740864_REALK, &
      0.000000000000000_REALK,     -0.020470917037007_REALK,      0.000000000000000_REALK, &
      0.003019291983389_REALK,      0.000000000000000_REALK,     -0.000844583325071_REALK, &
      0.000000000000000_REALK,      0.023545639011929_REALK,      0.000000000000000_REALK, &
     -0.003121068583195_REALK,      0.000000000000000_REALK,      0.004119183152142_REALK, &
      0.000000000000000_REALK,      0.005048437972538_REALK,      0.000000000000000_REALK, &
      0.002723556167828_REALK,      0.000000000000000_REALK,     -0.009432228069688_REALK, &
      0.000000000000000_REALK,     -0.002135052408005_REALK/
