  ! number of test cases
  integer, parameter :: NUM_TESTS = 3
  ! ID of block of sub-shells on bra center
  integer, parameter :: BRA_BLOCK(NUM_TESTS) = (/8, 8, 8/)
  ! ID of block of sub-shells on ket center
  integer, parameter :: KET_BLOCK(NUM_TESTS) = (/6, 6, 6/)
  ! orders of electronic derivatives
  integer, parameter :: ORDER_ELEC(NUM_TESTS) = (/0, 0, 0/)
  ! indices of Dirac delta function origin
  integer, parameter :: IDX_DELORG(NUM_TESTS) = (/1, 2, 3/)
  ! coordinates of Dirac delta function origin
  real(REALK), parameter :: DEL_ORIGIN(3*NUM_TESTS) = &
    (/0.0_REALK, -0.224905893_REALK, 0.0_REALK,       &
      1.45235_REALK, 0.899623_REALK, 0.0_REALK,       &
     -1.45235_REALK, 0.899623_REALK, 0.0_REALK/)
  ! indices of dipole origin
  integer, parameter :: IDX_DIPORG(NUM_TESTS) = (/0, 0, 0/)
  ! coordinates of dipole origin
  real(REALK), parameter :: DIP_ORIGIN(3*NUM_TESTS) = &
    (/0.0_REALK, 0.0_REALK, 0.0_REALK,                &
      0.0_REALK, 0.0_REALK, 0.0_REALK,                &
      0.0_REALK, 0.0_REALK, 0.0_REALK/)
  ! scale constants
  real(REALK), parameter :: SCAL_CONST(NUM_TESTS) =       &
    (/8.3872954891254174_REALK, 8.3872954891254174_REALK, &
      8.3872954891254174_REALK/)
  ! orders of Cartesian multipole moments
  integer, parameter :: ORDER_MOM(NUM_TESTS) = (/0, 0, 0/)
  ! orders of partial geometric derivatives on bra center
  integer, parameter :: ORDER_GEO_BRA(NUM_TESTS) = (/0, 0, 0/)
  ! orders of partial geometric derivatives on ket center
  integer, parameter :: ORDER_GEO_KET(NUM_TESTS) = (/0, 0, 0/)
  ! orders of geometric derivatives on Dirac delta function origin
  integer, parameter :: ORDER_GEO_POT(NUM_TESTS) = (/0, 0, 0/)
  ! orders of geometric derivatives on dipole origin
  integer, parameter :: ORDER_GEO_MOM(NUM_TESTS) = (/0, 0, 0/)
  ! numbers of differentiated centers of total geometric derivatives
  integer, parameter :: NUM_CENTS(NUM_TESTS) = (/0, 0, 0/)
  ! indices of differentiated centers
  integer, parameter :: IDX_CENT(3*NUM_TESTS) = &
    (/0, 0, 0,    0, 0, 0,    0, 0, 0/)
  ! orders of geometric derivatives of differentiated centers
  integer, parameter :: ORDER_CENT(3*NUM_TESTS) = &
    (/0, 0, 0,    0, 0, 0,    0, 0, 0/)
  ! referenced results from Dalton
  real(REALK) REF_CONTR_INTS(756)
  ! results of test 1, ket-major order, FC O1 01
  data REF_CONTR_INTS(1:252) /                                             &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK/
  ! results of test 1, ket-major order, FC H1 02
  data REF_CONTR_INTS(253:504) /                                           &
      0.1196201409039677754365_REALK,      0.2359317544575769698412_REALK, &
      0.1177670830648006178310_REALK,      0.0624115844347142498250_REALK, &
      0.0344563856162323628451_REALK,      0.0189395380786545400320_REALK, &
      0.0926197573802753360006_REALK,      0.1826777806064150133647_REALK, &
      0.0911849675014282240459_REALK,      0.0483241849104866227904_REALK, &
      0.0266789693763919803782_REALK,      0.0146645490339936939578_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0717138384251520683010_REALK,      0.1414441714469850397418_REALK, &
      0.0706029060230812383070_REALK,      0.0374165608582757713840_REALK, &
      0.0206570536710950977688_REALK,      0.0113545006999284901761_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0555267554907681384901_REALK,      0.1095177178631736580883_REALK, &
      0.0546665801994826103249_REALK,      0.0289709806601879601984_REALK, &
      0.0159943909508026040067_REALK,      0.0087915888750358453518_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0429933837462837253884_REALK,      0.0847976300702730084735_REALK, &
      0.0423273652465451857840_REALK,      0.0224317174310087602551_REALK, &
      0.0123841737529626245984_REALK,      0.0068071716220987881635_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0332890158918529438514_REALK,      0.0656573037297811246127_REALK, &
      0.0327733295585114631221_REALK,      0.0173684816819506884777_REALK, &
      0.0095888464909551513610_REALK,      0.0052706724747201188011_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
     16.3034077129766608038610_REALK,     32.1558857588019080253620_REALK, &
     16.0508485934223159574690_REALK,      8.5062724334097943312827_REALK, &
      4.6961698821937103431878_REALK,      2.5813296060204593551646_REALK, &
     12.6234399611672838403820_REALK,     24.8977330641924901044600_REALK, &
     12.4278879061326819055470_REALK,      6.5862561525105736137675_REALK, &
      3.6361612000986220927246_REALK,      1.9986778148010553302072_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      9.7741060800656924811847_REALK,     19.2778739290707328279950_REALK, &
      9.6226935858515307842254_REALK,      5.0996215376439240074546_REALK, &
      2.8154152436509480850191_REALK,      1.5475408479649459536631_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      7.5679172997423780344661_REALK,     14.9265164931672611459130_REALK, &
      7.4506812860369908690927_REALK,      3.9485466743179533644081_REALK, &
      2.1799261798313946947303_REALK,      1.1982334813469910361761_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      5.8597043848898984208518_REALK,     11.5573374657676311016980_REALK, &
      5.7689306149915609012169_REALK,      3.0572897859535230757899_REALK, &
      1.6878782482373508866402_REALK,      0.9277709714150635944563_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      4.5370653666454243690964_REALK,      8.9486417918594671760957_REALK, &
      4.4667808436466884813854_REALK,      2.3672053558567305309168_REALK, &
      1.3068942458836556586022_REALK,      0.7183566381677393142269_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK/
  ! results of test 1, ket-major order, FC H2 03
  data REF_CONTR_INTS(505:756) /                                           &
     -0.0065973796309580310521_REALK,     -0.0000000624754092320226_REALK, &
     -0.0002929355744997045089_REALK,     -0.0047685889834441896190_REALK, &
     -0.0107505970852849533359_REALK,     -0.0112101044647024191553_REALK, &
      0.0051082342500788253947_REALK,      0.0000000483736033211061_REALK, &
      0.0002268148292852768019_REALK,      0.0036922340281092640157_REALK, &
      0.0083239969975587944223_REALK,      0.0086797854264510400368_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
     -0.0039552153450792349246_REALK,     -0.0000000374548246587286_REALK, &
     -0.0001756187068490076006_REALK,     -0.0028588314416818547646_REALK, &
     -0.0064451235094847058107_REALK,     -0.0067206041911966954427_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0030624532196636927543_REALK,      0.0000000290006076434669_REALK, &
      0.0001359784556085007743_REALK,      0.0022135425733384441957_REALK, &
      0.0049903450307220102028_REALK,      0.0052036448455383202405_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
     -0.0023712033111665219154_REALK,     -0.0000000224546570796538_REALK, &
     -0.0001052857108529465938_REALK,     -0.0017139068265945897173_REALK, &
     -0.0038639358096091667993_REALK,     -0.0040290900800209064961_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0018359807447130673322_REALK,      0.0000000173862434457794_REALK, &
      0.0000815208619645279171_REALK,      0.0013270477133029618712_REALK, &
      0.0029917770913366987726_REALK,      0.0031196531190712918982_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
     -0.8991777567554134487082_REALK,     -0.0000085149713170998718_REALK, &
     -0.0399251168625342767182_REALK,     -0.6499260895797923653916_REALK, &
     -1.4652329124076892696849_REALK,     -1.5278606279173974069607_REALK, &
      0.6962174182630826990703_REALK,      0.0000065929915441491871_REALK, &
      0.0309133111635083064617_REALK,      0.5032262650511121204744_REALK, &
      1.1345039040017796949655_REALK,      1.1829954353773095565572_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
     -0.5390688213217903479446_REALK,     -0.0000051048366321482042_REALK, &
     -0.0239356295532513092816_REALK,     -0.3896391880514005756631_REALK, &
     -0.8784262879273585511442_REALK,     -0.9159724221908622787680_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.4173914448251507813836_REALK,      0.0000039525846296660365_REALK, &
      0.0185329342133616382926_REALK,      0.3016907252445074072433_REALK, &
      0.6801499233277459310898_REALK,      0.7092212303816702867465_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
     -0.3231788063461957238864_REALK,     -0.0000030604163032927070_REALK, &
     -0.0143497228594990106770_REALK,     -0.2335937875082266801385_REALK, &
     -0.5266280444478155242649_REALK,     -0.5491374428293438469950_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.2502316282862593888048_REALK,      0.0000023696261628814678_REALK, &
      0.0111107363666121915224_REALK,      0.1808675341882489684409_REALK, &
      0.4077587715396818190961_REALK,      0.4251874002063779078853_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK, &
      0.0000000000000000000000_REALK,      0.0000000000000000000000_REALK/
