  ! number of test cases
  integer, parameter :: NUM_TESTS = 8
  ! ID of block of sub-shells on bra center
  integer, parameter :: BRA_BLOCK(NUM_TESTS) = &
    (/12,    12,    12,    12,    12,    12,    12,    12/)
  ! ID of block of sub-shells on ket center
  integer, parameter :: KET_BLOCK(NUM_TESTS) = &
    (/6,    6,    6,    6,    6,    6,    6,    6/)
  ! coordinates of dipole origin
  real(REALK), parameter :: DIP_ORIGIN(3*NUM_TESTS) =                      &
    (/0.0_REALK, 0.0_REALK, 0.0_REALK,    0.0_REALK, 0.0_REALK, 0.0_REALK, &
      0.0_REALK, 0.0_REALK, 0.0_REALK,    0.0_REALK, 0.0_REALK, 0.0_REALK, &
      0.0_REALK, 0.0_REALK, 0.0_REALK,    0.0_REALK, 0.0_REALK, 0.0_REALK, &
      0.0_REALK, 0.0_REALK, 0.0_REALK,    0.0_REALK, 0.0_REALK, 0.0_REALK/)
  ! orders of electronic derivatives
  integer, parameter :: ORDER_ELEC(NUM_TESTS) = &
    (/0,    0,    0,    0,    1,    2,    0,    0/)
  ! indices of dipole origin
  integer, parameter :: IDX_DIPORG(NUM_TESTS) = &
    (/-1,    -1,    -1,    -1,    -1,    -1,    -1,    -1/)
  ! scale constants
  real(REALK), parameter :: SCAL_CONST(NUM_TESTS) =                      &
    (/1.0_REALK,    1.0_REALK,    1.0_REALK,   -1.0_REALK,    1.0_REALK, &
     -0.25_REALK,  -1.0_REALK,   -1.0_REALK/)
  ! orders of Cartesian multipole moments
  integer, parameter :: ORDER_MOM(NUM_TESTS) = &
    (/0,    3,    0,    1,    0,    0,    3,    0/)
  ! orders of partial geometric derivatives on bra center
  integer, parameter :: ORDER_GEO_BRA(NUM_TESTS) = &
    (/0,    0,    1,    0,    0,    0,    0,    0/)
  ! orders of partial geometric derivatives on ket center
  integer, parameter :: ORDER_GEO_KET(NUM_TESTS) = &
    (/0,    0,    0,    0,    0,    0,    0,    1/)
  ! orders of geometric derivatives on dipole origin
  integer, parameter :: ORDER_GEO_MOM(NUM_TESTS) = &
    (/0,    0,    0,    0,    0,    0,    0,    0/)
  ! numbers of differentiated centers of total geometric derivatives
  integer, parameter :: NUM_CENTS(NUM_TESTS) = &
    (/0,    0,    0,    1,    0,    0,    1,    0/)
  ! indices of differentiated centers
  integer, parameter :: IDX_CENT(3*NUM_TESTS) =                            &
    (/0, 0, 0,    0, 0, 0,    0, 0, 0,    1, 0, 0,    0, 0, 0,    0, 0, 0, &
      1, 0, 0,    0, 0, 0/)
  ! orders of geometric derivatives of differentiated centers
  integer, parameter :: ORDER_CENT(3*NUM_TESTS) =                          &
    (/0, 0, 0,    0, 0, 0,    0, 0, 0,    1, 0, 0,    0, 0, 0,    0, 0, 0, &
      1, 0, 0,    0, 0, 0/)
  ! referenced results from Dalton
  real(REALK) REF_CONTR_INTS(25740)
  ! results of test 1, ket-major order, OVERLAP
  data REF_CONTR_INTS(1:396) /                                                             &
     -0.131856477632209_REALK,      0.000000000000000_REALK,     -0.006223983864281_REALK, &
      0.000000000000000_REALK,      0.002561999725877_REALK,      0.000000000000000_REALK, &
      0.026817410304216_REALK,      0.000000000000000_REALK,     -0.049213577104994_REALK, &
     -0.035591067920879_REALK,      0.000000000000000_REALK,      0.006116448548602_REALK, &
      0.000000000000000_REALK,      0.001551526019142_REALK,      0.000000000000000_REALK, &
     -0.028735153537594_REALK,      0.000000000000000_REALK,     -0.008420731979325_REALK, &
      0.000000000000000_REALK,     -0.000889128559830_REALK,      0.000000000000000_REALK, &
      0.038583578071128_REALK,      0.000000000000000_REALK,     -0.006968037659677_REALK, &
      0.000000000000000_REALK,      0.112159830564952_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.006350588857812_REALK,      0.000000000000000_REALK, &
     -0.005483885281614_REALK,      0.000000000000000_REALK,     -0.020183378232000_REALK, &
      0.000000000000000_REALK,      0.067508829525106_REALK,      0.000000000000000_REALK, &
      0.004124802805307_REALK,      0.000000000000000_REALK,      0.066218952913817_REALK, &
      0.000000000000000_REALK,     -0.042921766478385_REALK,      0.000000000000000_REALK, &
     -0.009548857398053_REALK,      0.000000000000000_REALK,      0.027535597630424_REALK, &
     -0.007630498266331_REALK,      0.000000000000000_REALK,      0.047270554803964_REALK, &
      0.000000000000000_REALK,     -0.005575493329234_REALK,      0.000000000000000_REALK, &
     -0.019088040241696_REALK,      0.000000000000000_REALK,     -0.000983452305925_REALK, &
      0.000000000000000_REALK,      0.055615577645261_REALK,      0.000000000000000_REALK, &
     -0.046363945369439_REALK,      0.000000000000000_REALK,     -0.073088463001808_REALK, &
      0.000000000000000_REALK,     -0.006381865620954_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.007229495481639_REALK,      0.000000000000000_REALK, &
     -0.011300345926358_REALK,      0.000000000000000_REALK,     -0.030438000158461_REALK, &
      0.000000000000000_REALK,      0.010368145136505_REALK,      0.000000000000000_REALK, &
      0.003440823818468_REALK,      0.000000000000000_REALK,     -0.042831726802595_REALK, &
      0.000000000000000_REALK,      0.050111349509205_REALK,      0.000000000000000_REALK, &
     -0.034240971889927_REALK,      0.000000000000000_REALK,      0.010375515099243_REALK, &
     -0.010877782405821_REALK,      0.000000000000000_REALK,     -0.009793644005199_REALK, &
      0.000000000000000_REALK,      0.031786679965335_REALK,      0.000000000000000_REALK, &
     -0.033240928866771_REALK,      0.000000000000000_REALK,      0.001938587469313_REALK, &
      0.000000000000000_REALK,     -0.025584346272327_REALK,      0.000000000000000_REALK, &
      0.046736950080410_REALK,      0.000000000000000_REALK,      0.060361641103056_REALK, &
      0.000000000000000_REALK,      0.010991878089408_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.027285286005720_REALK,      0.000000000000000_REALK, &
      0.025993378442047_REALK,      0.000000000000000_REALK,      0.033570932161285_REALK, &
      0.000000000000000_REALK,     -0.011722657839959_REALK,      0.000000000000000_REALK, &
     -0.010081919221752_REALK,      0.000000000000000_REALK,     -0.066917556256538_REALK, &
      0.000000000000000_REALK,      0.064719740784547_REALK,      0.000000000000000_REALK, &
      0.000629309772438_REALK,      0.000000000000000_REALK,      0.005348363979607_REALK, &
      0.001442676879280_REALK,      0.000000000000000_REALK,     -0.028026101393958_REALK, &
      0.000000000000000_REALK,      0.041053088929084_REALK,      0.000000000000000_REALK, &
      0.016528690767702_REALK,      0.000000000000000_REALK,      0.011090841934131_REALK, &
      0.000000000000000_REALK,     -0.011818871632589_REALK,      0.000000000000000_REALK, &
     -0.038367538540440_REALK,      0.000000000000000_REALK,      0.001521225048630_REALK, &
      0.000000000000000_REALK,     -0.062637572126819_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.012735251674513_REALK,      0.000000000000000_REALK, &
     -0.034561103372356_REALK,      0.000000000000000_REALK,      0.016625410484481_REALK, &
      0.000000000000000_REALK,     -0.022608971602090_REALK,      0.000000000000000_REALK, &
      0.039120106824575_REALK,      0.000000000000000_REALK,     -0.010621817869528_REALK, &
      0.000000000000000_REALK,      0.018440605028191_REALK,      0.000000000000000_REALK, &
     -0.064833204490236_REALK,      0.000000000000000_REALK,      0.010836806480908_REALK, &
     -0.013965289323442_REALK,      0.000000000000000_REALK,      0.000619415855201_REALK, &
      0.000000000000000_REALK,      0.002395415630750_REALK,      0.000000000000000_REALK, &
     -0.072723101235182_REALK,      0.000000000000000_REALK,     -0.009135785916988_REALK, &
      0.000000000000000_REALK,      0.097212448475336_REALK,      0.000000000000000_REALK, &
     -0.004763220834051_REALK,      0.000000000000000_REALK,     -0.037636316120449_REALK, &
      0.000000000000000_REALK,      0.020193950795157_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.066866225402749_REALK,      0.000000000000000_REALK, &
      0.024849306645568_REALK,      0.000000000000000_REALK,      0.024831410402800_REALK, &
      0.000000000000000_REALK,      0.007180524044817_REALK,      0.000000000000000_REALK, &
     -0.047040672053755_REALK,      0.000000000000000_REALK,      0.005393437871645_REALK, &
      0.000000000000000_REALK,      0.016645728855913_REALK,      0.000000000000000_REALK, &
     -0.002980460551185_REALK,      0.000000000000000_REALK,      0.129050130306843_REALK, &
     -0.026412456605804_REALK,      0.000000000000000_REALK,     -0.009139167451813_REALK, &
      0.000000000000000_REALK,      0.010080516858248_REALK,      0.000000000000000_REALK, &
      0.002302632705377_REALK,      0.000000000000000_REALK,      0.058827715217292_REALK, &
     -0.088203159053668_REALK,      0.000000000000000_REALK,      0.012747146667779_REALK, &
      0.000000000000000_REALK,      0.004183539588829_REALK,      0.000000000000000_REALK, &
     -0.061660857502746_REALK,      0.000000000000000_REALK,     -0.021129422689185_REALK, &
     -0.094876713535980_REALK,      0.000000000000000_REALK,      0.027274085878400_REALK, &
      0.000000000000000_REALK,     -0.004168830122417_REALK,      0.000000000000000_REALK, &
     -0.115275804500593_REALK,      0.000000000000000_REALK,     -0.042430494907430_REALK, &
      0.000000000000000_REALK,     -0.011153540639177_REALK,      0.000000000000000_REALK, &
     -0.006193214753922_REALK,      0.000000000000000_REALK,     -0.047547527455424_REALK, &
      0.000000000000000_REALK,      0.163630759795993_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.080258597729313_REALK,      0.000000000000000_REALK, &
     -0.100608504892522_REALK,      0.000000000000000_REALK,     -0.020673759988532_REALK, &
      0.000000000000000_REALK,      0.102416071428915_REALK,      0.000000000000000_REALK, &
     -0.016222390749281_REALK,      0.000000000000000_REALK,      0.109980295755761_REALK, &
      0.000000000000000_REALK,     -0.019083206036637_REALK,      0.000000000000000_REALK, &
     -0.042535597106091_REALK,      0.000000000000000_REALK,     -0.000869081791540_REALK, &
     -0.025444076836327_REALK,      0.000000000000000_REALK,      0.140896519884865_REALK, &
      0.000000000000000_REALK,      0.085987533709514_REALK,      0.000000000000000_REALK, &
     -0.077373665997330_REALK,      0.000000000000000_REALK,     -0.018342154587137_REALK, &
      0.000000000000000_REALK,     -0.011507227430941_REALK,      0.000000000000000_REALK, &
     -0.028218343646399_REALK,      0.000000000000000_REALK,     -0.072223350391372_REALK, &
      0.000000000000000_REALK,      0.023832201488903_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.052488625756977_REALK,      0.000000000000000_REALK, &
     -0.028114609186089_REALK,      0.000000000000000_REALK,     -0.103750067136139_REALK, &
      0.000000000000000_REALK,      0.012246321948731_REALK,      0.000000000000000_REALK, &
     -0.024939143896904_REALK,      0.000000000000000_REALK,     -0.027884379631850_REALK, &
      0.000000000000000_REALK,      0.075788282484187_REALK,      0.000000000000000_REALK, &
     -0.076610899352975_REALK,      0.000000000000000_REALK,      0.007098350320562_REALK, &
     -0.025368260588556_REALK,      0.000000000000000_REALK,      0.051531730377272_REALK, &
      0.000000000000000_REALK,      0.067617724245616_REALK,      0.000000000000000_REALK, &
     -0.098956310262270_REALK,      0.000000000000000_REALK,     -0.025595374647261_REALK, &
      0.000000000000000_REALK,      0.058461763047570_REALK,      0.000000000000000_REALK, &
      0.060626098591308_REALK,      0.000000000000000_REALK,      0.078299734970959_REALK, &
      0.000000000000000_REALK,     -0.025117099552621_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.110096463240233_REALK,      0.000000000000000_REALK, &
      0.088974492762511_REALK,      0.000000000000000_REALK,      0.114912213788386_REALK, &
      0.000000000000000_REALK,     -0.047301067970637_REALK,      0.000000000000000_REALK, &
      0.000982970626926_REALK,      0.000000000000000_REALK,     -0.070765758290324_REALK, &
      0.000000000000000_REALK,      0.097881977734038_REALK,      0.000000000000000_REALK, &
      0.035433488129804_REALK,      0.000000000000000_REALK,      0.027566512497508_REALK, &
      0.029744954118173_REALK,      0.000000000000000_REALK,      0.010327059761239_REALK, &
      0.000000000000000_REALK,      0.087329549662465_REALK,      0.000000000000000_REALK, &
      0.089609776472071_REALK,      0.000000000000000_REALK,      0.001592232045846_REALK, &
      0.000000000000000_REALK,     -0.031236666505035_REALK,      0.000000000000000_REALK, &
     -0.078746691790697_REALK,      0.000000000000000_REALK,      0.036643360504824_REALK, &
      0.000000000000000_REALK,     -0.059615240767834_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.001843105964510_REALK,      0.000000000000000_REALK, &
     -0.141945012264917_REALK,      0.000000000000000_REALK,      0.077444091872651_REALK, &
      0.000000000000000_REALK,      0.039052678642825_REALK,      0.000000000000000_REALK, &
     -0.028261763981451_REALK,      0.000000000000000_REALK,      0.000188040122935_REALK, &
      0.000000000000000_REALK,      0.008198774050235_REALK,      0.000000000000000_REALK, &
     -0.165158668597780_REALK,      0.000000000000000_REALK,     -0.019155768252382_REALK, &
     -0.064177837166301_REALK,      0.000000000000000_REALK,      0.015533659306526_REALK, &
      0.000000000000000_REALK,     -0.036943077524173_REALK,      0.000000000000000_REALK, &
     -0.260888060115620_REALK,      0.000000000000000_REALK,     -0.033753560510505_REALK, &
      0.000000000000000_REALK,      0.155983202806113_REALK,      0.000000000000000_REALK, &
      0.056322498664794_REALK,      0.000000000000000_REALK,      0.050819200194558_REALK, &
      0.000000000000000_REALK,      0.021030502861661_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.202897153293897_REALK,      0.000000000000000_REALK, &
      0.056764439126907_REALK,      0.000000000000000_REALK,      0.133878506599030_REALK, &
      0.000000000000000_REALK,     -0.049514590096289_REALK,      0.000000000000000_REALK, &
     -0.064720745283270_REALK,      0.000000000000000_REALK,     -0.021907832468676_REALK, &
      0.000000000000000_REALK,      0.027181137043168_REALK,      0.000000000000000_REALK, &
      0.004332062634994_REALK,      0.000000000000000_REALK,      0.144502163697844_REALK, &
     -0.014052504331571_REALK,      0.000000000000000_REALK,     -0.020022096235976_REALK, &
      0.000000000000000_REALK,     -0.027085567247806_REALK,      0.000000000000000_REALK, &
      0.013650045528515_REALK,      0.000000000000000_REALK,      0.058226010410960_REALK/
  ! results of test 2, ket-major order, CM030000
  data REF_CONTR_INTS(397:792) /                                                           &
     -0.077101153308400_REALK,      0.000000000000000_REALK,     -0.016085765656125_REALK, &
      0.000000000000000_REALK,      0.008900368442212_REALK,      0.000000000000000_REALK, &
      0.014312063914125_REALK,      0.000000000000000_REALK,     -0.023186285290142_REALK, &
     -0.002979090137971_REALK,      0.000000000000000_REALK,      0.005081414163837_REALK, &
      0.000000000000000_REALK,     -0.013218965518146_REALK,      0.000000000000000_REALK, &
     -0.020601332809316_REALK,      0.000000000000000_REALK,     -0.038607594109776_REALK, &
      0.000000000000000_REALK,     -0.002312060227977_REALK,      0.000000000000000_REALK, &
      0.036637056533005_REALK,      0.000000000000000_REALK,      0.018758309024058_REALK, &
      0.000000000000000_REALK,      0.063860895562387_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.022595273857796_REALK,      0.000000000000000_REALK, &
     -0.004600059361251_REALK,      0.000000000000000_REALK,      0.004373885274212_REALK, &
      0.000000000000000_REALK,      0.023176186763058_REALK,      0.000000000000000_REALK, &
      0.014129800320374_REALK,      0.000000000000000_REALK,      0.041546512510688_REALK, &
      0.000000000000000_REALK,     -0.031023458442322_REALK,      0.000000000000000_REALK, &
     -0.010866169711448_REALK,      0.000000000000000_REALK,      0.012576491628890_REALK, &
     -0.001037635306193_REALK,      0.000000000000000_REALK,      0.022349471029224_REALK, &
      0.000000000000000_REALK,     -0.009487880031362_REALK,      0.000000000000000_REALK, &
      0.007274284220061_REALK,      0.000000000000000_REALK,      0.008367046744477_REALK, &
      0.000000000000000_REALK,      0.018741767548556_REALK,      0.000000000000000_REALK, &
     -0.029640177117149_REALK,      0.000000000000000_REALK,     -0.028200030866621_REALK, &
      0.000000000000000_REALK,     -0.025520122899246_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.011436890893878_REALK,      0.000000000000000_REALK, &
     -0.003047679010191_REALK,      0.000000000000000_REALK,     -0.011574662573907_REALK, &
      0.000000000000000_REALK,     -0.002373747298909_REALK,      0.000000000000000_REALK, &
     -0.001569118054617_REALK,      0.000000000000000_REALK,     -0.022044086448236_REALK, &
      0.000000000000000_REALK,      0.018995639946817_REALK,      0.000000000000000_REALK, &
     -0.001901055260454_REALK,      0.000000000000000_REALK,     -0.001748815599518_REALK, &
     -0.000043749051960_REALK,      0.000000000000000_REALK,     -0.009834717277598_REALK, &
      0.000000000000000_REALK,      0.006461474176770_REALK,      0.000000000000000_REALK, &
     -0.004961823613809_REALK,      0.000000000000000_REALK,     -0.001376190934517_REALK, &
      0.000000000000000_REALK,      0.001777378688853_REALK,      0.000000000000000_REALK, &
      0.041826453017049_REALK,      0.000000000000000_REALK,      0.026380764853590_REALK, &
      0.000000000000000_REALK,      0.031082607386612_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.019604395568746_REALK,      0.000000000000000_REALK, &
      0.038011532951005_REALK,      0.000000000000000_REALK,      0.015473706779851_REALK, &
      0.000000000000000_REALK,      0.017411273267946_REALK,      0.000000000000000_REALK, &
     -0.020236954407152_REALK,      0.000000000000000_REALK,     -0.047248901866874_REALK, &
      0.000000000000000_REALK,      0.047343804922498_REALK,      0.000000000000000_REALK, &
      0.028214253010350_REALK,      0.000000000000000_REALK,      0.008628507210770_REALK, &
     -0.007129708933785_REALK,      0.000000000000000_REALK,     -0.036799072300345_REALK, &
      0.000000000000000_REALK,      0.046750339306455_REALK,      0.000000000000000_REALK, &
      0.037075192779411_REALK,      0.000000000000000_REALK,      0.021173341836506_REALK, &
      0.000000000000000_REALK,     -0.019830403239753_REALK,      0.000000000000000_REALK, &
     -0.046485935264374_REALK,      0.000000000000000_REALK,     -0.016831406738415_REALK, &
      0.000000000000000_REALK,     -0.045212595304355_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.031420994478147_REALK,      0.000000000000000_REALK, &
     -0.050128270192740_REALK,      0.000000000000000_REALK,     -0.014958691212676_REALK, &
      0.000000000000000_REALK,     -0.031549555672049_REALK,      0.000000000000000_REALK, &
      0.032217918369219_REALK,      0.000000000000000_REALK,      0.012554490514090_REALK, &
      0.000000000000000_REALK,     -0.017865735815654_REALK,      0.000000000000000_REALK, &
     -0.038116249891797_REALK,      0.000000000000000_REALK,     -0.015023268833190_REALK, &
      0.012511369825126_REALK,      0.000000000000000_REALK,      0.023370992687317_REALK, &
      0.000000000000000_REALK,     -0.031209007154411_REALK,      0.000000000000000_REALK, &
     -0.044836511628021_REALK,      0.000000000000000_REALK,     -0.021080636994366_REALK, &
      0.000000000000000_REALK,      0.054019653191005_REALK,      0.000000000000000_REALK, &
      0.022142869012019_REALK,      0.000000000000000_REALK,     -0.006458401263408_REALK, &
      0.000000000000000_REALK,      0.021585062461731_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.046918207238407_REALK,      0.000000000000000_REALK, &
      0.042546967117249_REALK,      0.000000000000000_REALK,      0.009674237973600_REALK, &
      0.000000000000000_REALK,      0.042424871508414_REALK,      0.000000000000000_REALK, &
     -0.046036073970659_REALK,      0.000000000000000_REALK,     -0.005695219875446_REALK, &
      0.000000000000000_REALK,      0.015180816356395_REALK,      0.000000000000000_REALK, &
      0.024610669898017_REALK,      0.000000000000000_REALK,      0.070665797598530_REALK, &
     -0.046299617059190_REALK,      0.000000000000000_REALK,     -0.010230590125574_REALK, &
      0.000000000000000_REALK,      0.012527789849031_REALK,      0.000000000000000_REALK, &
      0.019126903108094_REALK,      0.000000000000000_REALK,      0.037336116513420_REALK, &
     -0.005345966937238_REALK,      0.000000000000000_REALK,     -0.025806664933133_REALK, &
      0.000000000000000_REALK,     -0.059612449688957_REALK,      0.000000000000000_REALK, &
     -0.094056686942345_REALK,      0.000000000000000_REALK,     -0.004885929074429_REALK, &
     -0.098321938613357_REALK,      0.000000000000000_REALK,     -0.056338982571350_REALK, &
      0.000000000000000_REALK,     -0.123669879968571_REALK,      0.000000000000000_REALK, &
     -0.202179295697359_REALK,      0.000000000000000_REALK,     -0.219251936763994_REALK, &
      0.000000000000000_REALK,      0.077861456579087_REALK,      0.000000000000000_REALK, &
     -0.065926530466901_REALK,      0.000000000000000_REALK,      0.023096117579477_REALK, &
      0.000000000000000_REALK,      0.019923739753980_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.127616940743186_REALK,      0.000000000000000_REALK, &
     -0.274876002916442_REALK,      0.000000000000000_REALK,      0.030790275470544_REALK, &
      0.000000000000000_REALK,      0.022756422974224_REALK,      0.000000000000000_REALK, &
     -0.012820672111975_REALK,      0.000000000000000_REALK,      0.059897653403945_REALK, &
      0.000000000000000_REALK,     -0.008674093355625_REALK,      0.000000000000000_REALK, &
     -0.090059611615593_REALK,      0.000000000000000_REALK,      0.004601072490720_REALK, &
      0.040823868930968_REALK,      0.000000000000000_REALK,      0.071382653138108_REALK, &
      0.000000000000000_REALK,      0.103514787077491_REALK,      0.000000000000000_REALK, &
      0.016193150467353_REALK,      0.000000000000000_REALK,      0.059716416591744_REALK, &
      0.000000000000000_REALK,     -0.028617573951580_REALK,      0.000000000000000_REALK, &
     -0.030904717000386_REALK,      0.000000000000000_REALK,     -0.021733479020050_REALK, &
      0.000000000000000_REALK,      0.013443939539798_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.045878454223426_REALK,      0.000000000000000_REALK, &
      0.024251203959310_REALK,      0.000000000000000_REALK,     -0.054638821923461_REALK, &
      0.000000000000000_REALK,      0.007134178911720_REALK,      0.000000000000000_REALK, &
      0.002283064637174_REALK,      0.000000000000000_REALK,     -0.019419232754644_REALK, &
      0.000000000000000_REALK,      0.008272672338244_REALK,      0.000000000000000_REALK, &
      0.017112287713739_REALK,      0.000000000000000_REALK,     -0.003218281011000_REALK, &
     -0.011997137320470_REALK,      0.000000000000000_REALK,     -0.005052214713200_REALK, &
      0.000000000000000_REALK,     -0.035039912617185_REALK,      0.000000000000000_REALK, &
     -0.017626942415700_REALK,      0.000000000000000_REALK,     -0.017765698644448_REALK, &
      0.000000000000000_REALK,      0.112590296201941_REALK,      0.000000000000000_REALK, &
      0.157018166748819_REALK,      0.000000000000000_REALK,      0.008763490015347_REALK, &
      0.000000000000000_REALK,     -0.072814545116187_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.142761561728391_REALK,      0.000000000000000_REALK, &
      0.286383157224487_REALK,      0.000000000000000_REALK,      0.003449625989719_REALK, &
      0.000000000000000_REALK,     -0.145987177602384_REALK,      0.000000000000000_REALK, &
      0.081967868388350_REALK,      0.000000000000000_REALK,      0.017151590658744_REALK, &
      0.000000000000000_REALK,      0.144744084190864_REALK,      0.000000000000000_REALK, &
      0.228357004249404_REALK,      0.000000000000000_REALK,      0.035277920970626_REALK, &
      0.126309261316567_REALK,      0.000000000000000_REALK,      0.099422537278732_REALK, &
      0.000000000000000_REALK,      0.250320064006257_REALK,      0.000000000000000_REALK, &
      0.370785548791922_REALK,      0.000000000000000_REALK,      0.020504740946887_REALK, &
      0.000000000000000_REALK,     -0.160533482423476_REALK,      0.000000000000000_REALK, &
     -0.189005117892876_REALK,      0.000000000000000_REALK,      0.017736560016752_REALK, &
      0.000000000000000_REALK,      0.092228728360327_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.212973832918698_REALK,      0.000000000000000_REALK, &
     -0.348309872084588_REALK,      0.000000000000000_REALK,      0.032706453473537_REALK, &
      0.000000000000000_REALK,      0.204218064851029_REALK,      0.000000000000000_REALK, &
     -0.095723970459958_REALK,      0.000000000000000_REALK,     -0.055582609784809_REALK, &
      0.000000000000000_REALK,     -0.141719595131776_REALK,      0.000000000000000_REALK, &
     -0.216082303349179_REALK,      0.000000000000000_REALK,     -0.055517587119967_REALK, &
     -0.155142058261823_REALK,      0.000000000000000_REALK,     -0.073306573615391_REALK, &
      0.000000000000000_REALK,     -0.261266226899569_REALK,      0.000000000000000_REALK, &
     -0.382985517555025_REALK,      0.000000000000000_REALK,     -0.033676080451849_REALK, &
      0.000000000000000_REALK,      0.217305565411475_REALK,      0.000000000000000_REALK, &
      0.196118893816496_REALK,      0.000000000000000_REALK,      0.024988076490998_REALK, &
      0.000000000000000_REALK,     -0.096471288625771_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.309227257139057_REALK,      0.000000000000000_REALK, &
      0.233174304639745_REALK,      0.000000000000000_REALK,      0.006340857292962_REALK, &
      0.000000000000000_REALK,     -0.156035922615030_REALK,      0.000000000000000_REALK, &
      0.141092723800888_REALK,      0.000000000000000_REALK,      0.007669071721805_REALK, &
      0.000000000000000_REALK,      0.027812459049990_REALK,      0.000000000000000_REALK, &
      0.102040797590086_REALK,      0.000000000000000_REALK,      0.156837970749100_REALK, &
      0.212282734419440_REALK,      0.000000000000000_REALK,      0.025140032585179_REALK, &
      0.000000000000000_REALK,     -0.022070718326625_REALK,      0.000000000000000_REALK, &
      0.027288577998823_REALK,      0.000000000000000_REALK,      0.090991113024813_REALK/
  ! results of test 2, ket-major order, CM020100
  data REF_CONTR_INTS(793:1188) /                                                          &
     -0.025549259819364_REALK,      0.000000000000000_REALK,      0.000362855447190_REALK, &
      0.000000000000000_REALK,     -0.000138057547509_REALK,      0.000000000000000_REALK, &
      0.006100124242638_REALK,      0.000000000000000_REALK,     -0.008055440987258_REALK, &
     -0.029915900389755_REALK,      0.000000000000000_REALK,     -0.005079508696934_REALK, &
      0.000000000000000_REALK,      0.006897149415151_REALK,      0.000000000000000_REALK, &
      0.014350429934790_REALK,      0.000000000000000_REALK,      0.005754069275934_REALK, &
      0.000000000000000_REALK,     -0.000648103638007_REALK,      0.000000000000000_REALK, &
      0.005807497343767_REALK,      0.000000000000000_REALK,     -0.001709702527955_REALK, &
      0.000000000000000_REALK,      0.019327939040884_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.010114923833461_REALK,      0.000000000000000_REALK, &
      0.018003799463713_REALK,      0.000000000000000_REALK,      0.003762917605350_REALK, &
      0.000000000000000_REALK,      0.023636812859677_REALK,      0.000000000000000_REALK, &
     -0.000516210106311_REALK,      0.000000000000000_REALK,      0.013135776270249_REALK, &
      0.000000000000000_REALK,     -0.008861437825579_REALK,      0.000000000000000_REALK, &
     -0.000061110908451_REALK,      0.000000000000000_REALK,      0.005245129965184_REALK, &
      0.003479130802921_REALK,      0.000000000000000_REALK,      0.013236918519423_REALK, &
      0.000000000000000_REALK,     -0.013123997891579_REALK,      0.000000000000000_REALK, &
     -0.009243379772091_REALK,      0.000000000000000_REALK,     -0.006494894475847_REALK, &
      0.000000000000000_REALK,      0.013615658910686_REALK,      0.000000000000000_REALK, &
     -0.009105863277900_REALK,      0.000000000000000_REALK,     -0.015002445925531_REALK, &
      0.000000000000000_REALK,     -0.000564000797994_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.001241594525192_REALK,      0.000000000000000_REALK, &
     -0.011297037215855_REALK,      0.000000000000000_REALK,     -0.008139578640868_REALK, &
      0.000000000000000_REALK,     -0.003673599365023_REALK,      0.000000000000000_REALK, &
      0.001673773624617_REALK,      0.000000000000000_REALK,     -0.009336028988590_REALK, &
      0.000000000000000_REALK,      0.009921588543149_REALK,      0.000000000000000_REALK, &
     -0.007043564732619_REALK,      0.000000000000000_REALK,      0.001385581827491_REALK, &
     -0.001490425093644_REALK,      0.000000000000000_REALK,     -0.006268551296678_REALK, &
      0.000000000000000_REALK,      0.008951492944343_REALK,      0.000000000000000_REALK, &
     -0.002164024755362_REALK,      0.000000000000000_REALK,      0.003586375445344_REALK, &
      0.000000000000000_REALK,     -0.010015366938303_REALK,      0.000000000000000_REALK, &
      0.004373501438950_REALK,      0.000000000000000_REALK,      0.010749189476825_REALK, &
      0.000000000000000_REALK,     -0.001057298343167_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.008477036656988_REALK,      0.000000000000000_REALK, &
     -0.005601704491704_REALK,      0.000000000000000_REALK,      0.004419974202075_REALK, &
      0.000000000000000_REALK,     -0.004501624674129_REALK,      0.000000000000000_REALK, &
      0.002255314533333_REALK,      0.000000000000000_REALK,     -0.010585906451162_REALK, &
      0.000000000000000_REALK,      0.007984890933889_REALK,      0.000000000000000_REALK, &
     -0.006505467396234_REALK,      0.000000000000000_REALK,     -0.002898542071684_REALK, &
      0.000786907955382_REALK,      0.000000000000000_REALK,     -0.001360832499735_REALK, &
      0.000000000000000_REALK,     -0.003765871787178_REALK,      0.000000000000000_REALK, &
     -0.011976740377594_REALK,      0.000000000000000_REALK,     -0.005731904786456_REALK, &
      0.000000000000000_REALK,      0.002546231273074_REALK,      0.000000000000000_REALK, &
      0.000269129385633_REALK,      0.000000000000000_REALK,      0.001986199657836_REALK, &
      0.000000000000000_REALK,     -0.006360491468082_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.008733057780268_REALK,      0.000000000000000_REALK, &
      0.009489439337854_REALK,      0.000000000000000_REALK,      0.004122076543803_REALK, &
      0.000000000000000_REALK,      0.000477488805941_REALK,      0.000000000000000_REALK, &
      0.003777293128613_REALK,      0.000000000000000_REALK,     -0.007304607292488_REALK, &
      0.000000000000000_REALK,      0.009536619447094_REALK,      0.000000000000000_REALK, &
     -0.006766753213538_REALK,      0.000000000000000_REALK,      0.005476544603356_REALK, &
     -0.000851603367868_REALK,      0.000000000000000_REALK,     -0.009017694429675_REALK, &
      0.000000000000000_REALK,      0.011632919178064_REALK,      0.000000000000000_REALK, &
      0.001832723302977_REALK,      0.000000000000000_REALK,      0.006400527808951_REALK, &
      0.000000000000000_REALK,      0.017484210412072_REALK,      0.000000000000000_REALK, &
     -0.009710675426797_REALK,      0.000000000000000_REALK,     -0.012012255344007_REALK, &
      0.000000000000000_REALK,     -0.002257504224462_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.008342360742746_REALK,      0.000000000000000_REALK, &
     -0.009312669196518_REALK,      0.000000000000000_REALK,     -0.007994003823262_REALK, &
      0.000000000000000_REALK,     -0.005064358647599_REALK,      0.000000000000000_REALK, &
     -0.000216295007405_REALK,      0.000000000000000_REALK,      0.005186932517289_REALK, &
      0.000000000000000_REALK,     -0.002087942535426_REALK,      0.000000000000000_REALK, &
     -0.005750879388383_REALK,      0.000000000000000_REALK,      0.020575476197101_REALK, &
     -0.003117593473171_REALK,      0.000000000000000_REALK,     -0.001476314191656_REALK, &
      0.000000000000000_REALK,      0.002501730282851_REALK,      0.000000000000000_REALK, &
      0.001081708407154_REALK,      0.000000000000000_REALK,      0.010733918245729_REALK, &
     -0.019821403885427_REALK,      0.000000000000000_REALK,      0.007262386205357_REALK, &
      0.000000000000000_REALK,      0.003187127809271_REALK,      0.000000000000000_REALK, &
     -0.026890111866380_REALK,      0.000000000000000_REALK,     -0.004054640934662_REALK, &
      0.014144470382928_REALK,      0.000000000000000_REALK,      0.014925312591570_REALK, &
      0.000000000000000_REALK,      0.029485736382517_REALK,      0.000000000000000_REALK, &
      0.036840405491456_REALK,      0.000000000000000_REALK,      0.077750499122342_REALK, &
      0.000000000000000_REALK,     -0.020814821839173_REALK,      0.000000000000000_REALK, &
     -0.040979407781408_REALK,      0.000000000000000_REALK,      0.001531685402195_REALK, &
      0.000000000000000_REALK,      0.028329643140961_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.058815889975604_REALK,      0.000000000000000_REALK, &
      0.033589720879475_REALK,      0.000000000000000_REALK,      0.018136398178703_REALK, &
      0.000000000000000_REALK,      0.015939573841789_REALK,      0.000000000000000_REALK, &
     -0.002744301658058_REALK,      0.000000000000000_REALK,      0.034185579149568_REALK, &
      0.000000000000000_REALK,      0.025134671765105_REALK,      0.000000000000000_REALK, &
     -0.009541220281328_REALK,      0.000000000000000_REALK,     -0.005078891957186_REALK, &
     -0.020089294396894_REALK,      0.000000000000000_REALK,      0.035106015492892_REALK, &
      0.000000000000000_REALK,     -0.004473665152126_REALK,      0.000000000000000_REALK, &
     -0.066301341341869_REALK,      0.000000000000000_REALK,     -0.037880698516285_REALK, &
      0.000000000000000_REALK,     -0.007248063796358_REALK,      0.000000000000000_REALK, &
     -0.003049069717749_REALK,      0.000000000000000_REALK,     -0.015843650313293_REALK, &
      0.000000000000000_REALK,      0.002798683068627_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.043490961155658_REALK,      0.000000000000000_REALK, &
     -0.054408103785633_REALK,      0.000000000000000_REALK,     -0.027860972721153_REALK, &
      0.000000000000000_REALK,      0.001677242966480_REALK,      0.000000000000000_REALK, &
     -0.004263916409049_REALK,      0.000000000000000_REALK,      0.002963102051859_REALK, &
      0.000000000000000_REALK,      0.004041111374435_REALK,      0.000000000000000_REALK, &
     -0.025740417328933_REALK,      0.000000000000000_REALK,     -0.003823675655311_REALK, &
      0.003360051690382_REALK,      0.000000000000000_REALK,      0.014520758522083_REALK, &
      0.000000000000000_REALK,      0.016102840787382_REALK,      0.000000000000000_REALK, &
     -0.004608780091007_REALK,      0.000000000000000_REALK,      0.004576834490674_REALK, &
      0.000000000000000_REALK,      0.002258202548595_REALK,      0.000000000000000_REALK, &
     -0.005803012009314_REALK,      0.000000000000000_REALK,      0.023824598988073_REALK, &
      0.000000000000000_REALK,     -0.002481931569977_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.028702101050616_REALK,      0.000000000000000_REALK, &
     -0.044804529395110_REALK,      0.000000000000000_REALK,      0.039824487823940_REALK, &
      0.000000000000000_REALK,      0.018988356691436_REALK,      0.000000000000000_REALK, &
     -0.007020715022852_REALK,      0.000000000000000_REALK,     -0.012148483083982_REALK, &
      0.000000000000000_REALK,     -0.016466770094116_REALK,      0.000000000000000_REALK, &
     -0.015777709611462_REALK,      0.000000000000000_REALK,     -0.011312216771959_REALK, &
     -0.029058191266542_REALK,      0.000000000000000_REALK,     -0.011005108065929_REALK, &
      0.000000000000000_REALK,     -0.072355857047945_REALK,      0.000000000000000_REALK, &
     -0.072238944072886_REALK,      0.000000000000000_REALK,     -0.022660493698156_REALK, &
      0.000000000000000_REALK,      0.026398468440629_REALK,      0.000000000000000_REALK, &
      0.013283671167703_REALK,      0.000000000000000_REALK,      0.006472470432553_REALK, &
      0.000000000000000_REALK,     -0.004294913203577_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.070284644530160_REALK,      0.000000000000000_REALK, &
      0.061134429457114_REALK,      0.000000000000000_REALK,      0.003174402317792_REALK, &
      0.000000000000000_REALK,     -0.021287531014244_REALK,      0.000000000000000_REALK, &
      0.002154581884214_REALK,      0.000000000000000_REALK,      0.004715045130325_REALK, &
      0.000000000000000_REALK,      0.011423725841133_REALK,      0.000000000000000_REALK, &
     -0.029853135291065_REALK,      0.000000000000000_REALK,      0.009366044889157_REALK, &
      0.030153178349568_REALK,      0.000000000000000_REALK,      0.009543175141050_REALK, &
      0.000000000000000_REALK,      0.038536434308323_REALK,      0.000000000000000_REALK, &
      0.016822584622142_REALK,      0.000000000000000_REALK,      0.013082522227410_REALK, &
      0.000000000000000_REALK,      0.014110330660227_REALK,      0.000000000000000_REALK, &
     -0.017317159358702_REALK,      0.000000000000000_REALK,      0.045470477154741_REALK, &
      0.000000000000000_REALK,      0.000779272895504_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.019622966380795_REALK,      0.000000000000000_REALK, &
     -0.040811535145703_REALK,      0.000000000000000_REALK,      0.046924612983433_REALK, &
      0.000000000000000_REALK,      0.019040523208992_REALK,      0.000000000000000_REALK, &
     -0.021296628163595_REALK,      0.000000000000000_REALK,     -0.019749017663559_REALK, &
      0.000000000000000_REALK,     -0.030364958957465_REALK,      0.000000000000000_REALK, &
     -0.017182684862709_REALK,      0.000000000000000_REALK,     -0.015899755297467_REALK, &
     -0.043969791035583_REALK,      0.000000000000000_REALK,     -0.030133578756106_REALK, &
      0.000000000000000_REALK,     -0.016843577114682_REALK,      0.000000000000000_REALK, &
      0.013180739318724_REALK,      0.000000000000000_REALK,     -0.001514202400876_REALK/
  ! results of test 2, ket-major order, CM010200
  data REF_CONTR_INTS(1189:1584) /                                                         &
     -0.013661440666760_REALK,      0.000000000000000_REALK,      0.003367988553131_REALK, &
      0.000000000000000_REALK,     -0.003053742552298_REALK,      0.000000000000000_REALK, &
      0.002919077466265_REALK,      0.000000000000000_REALK,     -0.010061741186116_REALK, &
     -0.000691941097138_REALK,      0.000000000000000_REALK,      0.002351379689567_REALK, &
      0.000000000000000_REALK,     -0.001945205167737_REALK,      0.000000000000000_REALK, &
     -0.005125666873088_REALK,      0.000000000000000_REALK,     -0.006097902284105_REALK, &
      0.000000000000000_REALK,      0.000765223889987_REALK,      0.000000000000000_REALK, &
     -0.000534591632278_REALK,      0.000000000000000_REALK,     -0.008841344471074_REALK, &
      0.000000000000000_REALK,      0.013455587794553_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.001524988663484_REALK,      0.000000000000000_REALK, &
     -0.010477384671169_REALK,      0.000000000000000_REALK,     -0.014569953127049_REALK, &
      0.000000000000000_REALK,      0.006317515927953_REALK,      0.000000000000000_REALK, &
     -0.003254229187689_REALK,      0.000000000000000_REALK,      0.005626946598426_REALK, &
      0.000000000000000_REALK,     -0.002249005775182_REALK,      0.000000000000000_REALK, &
      0.000794386505971_REALK,      0.000000000000000_REALK,      0.004037331607521_REALK, &
     -0.002721877324569_REALK,      0.000000000000000_REALK,     -0.000808533681208_REALK, &
      0.000000000000000_REALK,      0.005185792159875_REALK,      0.000000000000000_REALK, &
      0.005859174096505_REALK,      0.000000000000000_REALK,      0.005902655149210_REALK, &
      0.000000000000000_REALK,      0.009725713986719_REALK,      0.000000000000000_REALK, &
     -0.003828270648029_REALK,      0.000000000000000_REALK,     -0.012662653743566_REALK, &
      0.000000000000000_REALK,      0.007162927783054_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.007696491005525_REALK,      0.000000000000000_REALK, &
      0.003309164078722_REALK,      0.000000000000000_REALK,     -0.007449304600500_REALK, &
      0.000000000000000_REALK,      0.007864653832250_REALK,      0.000000000000000_REALK, &
      0.001475348392027_REALK,      0.000000000000000_REALK,     -0.005144018757034_REALK, &
      0.000000000000000_REALK,      0.008642882931966_REALK,      0.000000000000000_REALK, &
     -0.009801330124339_REALK,      0.000000000000000_REALK,      0.003932021552490_REALK, &
     -0.000310972217522_REALK,      0.000000000000000_REALK,     -0.001752120538987_REALK, &
      0.000000000000000_REALK,      0.002992578467656_REALK,      0.000000000000000_REALK, &
     -0.007986874093811_REALK,      0.000000000000000_REALK,     -0.000648016329623_REALK, &
      0.000000000000000_REALK,     -0.005320894933955_REALK,      0.000000000000000_REALK, &
      0.003722316783305_REALK,      0.000000000000000_REALK,      0.010375331937483_REALK, &
      0.000000000000000_REALK,     -0.005055313632388_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.002318655409016_REALK,      0.000000000000000_REALK, &
      0.005823807245201_REALK,      0.000000000000000_REALK,      0.005774157634246_REALK, &
      0.000000000000000_REALK,     -0.000866683017767_REALK,      0.000000000000000_REALK, &
      0.000970653821670_REALK,      0.000000000000000_REALK,     -0.006409518521012_REALK, &
      0.000000000000000_REALK,      0.007370229540519_REALK,      0.000000000000000_REALK, &
     -0.004888691696061_REALK,      0.000000000000000_REALK,      0.001774148282297_REALK, &
     -0.001075973558772_REALK,      0.000000000000000_REALK,     -0.005354130222121_REALK, &
      0.000000000000000_REALK,      0.008772133466902_REALK,      0.000000000000000_REALK, &
      0.001076823903926_REALK,      0.000000000000000_REALK,      0.004312053983879_REALK, &
      0.000000000000000_REALK,     -0.000638852974423_REALK,      0.000000000000000_REALK, &
     -0.001582175810118_REALK,      0.000000000000000_REALK,      0.004646365095560_REALK, &
      0.000000000000000_REALK,     -0.007708220013662_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.003485889065035_REALK,      0.000000000000000_REALK, &
     -0.004480730587524_REALK,      0.000000000000000_REALK,      0.002272152719513_REALK, &
      0.000000000000000_REALK,     -0.005296118874169_REALK,      0.000000000000000_REALK, &
      0.004569387823724_REALK,      0.000000000000000_REALK,     -0.004105239536459_REALK, &
      0.000000000000000_REALK,      0.007610290776132_REALK,      0.000000000000000_REALK, &
     -0.011735317623346_REALK,      0.000000000000000_REALK,      0.005926087800953_REALK, &
     -0.000758936390389_REALK,      0.000000000000000_REALK,     -0.003237656843232_REALK, &
      0.000000000000000_REALK,      0.007013798722212_REALK,      0.000000000000000_REALK, &
     -0.011720981661597_REALK,      0.000000000000000_REALK,      0.003846161452809_REALK, &
      0.000000000000000_REALK,      0.013493784510674_REALK,      0.000000000000000_REALK, &
     -0.002561810249863_REALK,      0.000000000000000_REALK,     -0.007014741568427_REALK, &
      0.000000000000000_REALK,      0.004719013721294_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.006225577962328_REALK,      0.000000000000000_REALK, &
     -0.005160187900110_REALK,      0.000000000000000_REALK,     -0.003573979224405_REALK, &
      0.000000000000000_REALK,     -0.003033869281775_REALK,      0.000000000000000_REALK, &
     -0.006158532088125_REALK,      0.000000000000000_REALK,      0.000305736403713_REALK, &
      0.000000000000000_REALK,      0.003859588817626_REALK,      0.000000000000000_REALK, &
     -0.004997010119383_REALK,      0.000000000000000_REALK,      0.018595795849963_REALK, &
      0.010625086846438_REALK,      0.000000000000000_REALK,      0.003265507294420_REALK, &
      0.000000000000000_REALK,      0.000350703780082_REALK,      0.000000000000000_REALK, &
     -0.013618467587164_REALK,      0.000000000000000_REALK,      0.013722631210022_REALK, &
     -0.010894800674083_REALK,      0.000000000000000_REALK,      0.023543726858758_REALK, &
      0.000000000000000_REALK,      0.015392062766302_REALK,      0.000000000000000_REALK, &
     -0.022519384190276_REALK,      0.000000000000000_REALK,     -0.012207870461532_REALK, &
     -0.029527782248816_REALK,      0.000000000000000_REALK,      0.013491727620772_REALK, &
      0.000000000000000_REALK,      0.002688947664540_REALK,      0.000000000000000_REALK, &
     -0.035079440156672_REALK,      0.000000000000000_REALK,     -0.043579341323611_REALK, &
      0.000000000000000_REALK,     -0.055944055664605_REALK,      0.000000000000000_REALK, &
     -0.010015466527303_REALK,      0.000000000000000_REALK,     -0.025078769092388_REALK, &
      0.000000000000000_REALK,      0.021821714770162_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.094806328642412_REALK,      0.000000000000000_REALK, &
     -0.045199937482651_REALK,      0.000000000000000_REALK,     -0.023060226596172_REALK, &
      0.000000000000000_REALK,      0.021053178526875_REALK,      0.000000000000000_REALK, &
     -0.010655083498966_REALK,      0.000000000000000_REALK,      0.026268237420749_REALK, &
      0.000000000000000_REALK,      0.028950228691184_REALK,      0.000000000000000_REALK, &
      0.000048320123868_REALK,      0.000000000000000_REALK,     -0.007051899477931_REALK, &
      0.007273004113841_REALK,      0.000000000000000_REALK,      0.026102554000455_REALK, &
      0.000000000000000_REALK,      0.063506125316276_REALK,      0.000000000000000_REALK, &
      0.026734250813499_REALK,      0.000000000000000_REALK,      0.005379925243578_REALK, &
      0.000000000000000_REALK,     -0.024243380844582_REALK,      0.000000000000000_REALK, &
      0.003185675731395_REALK,      0.000000000000000_REALK,     -0.024044904843669_REALK, &
      0.000000000000000_REALK,      0.006178495359479_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.005689420287159_REALK,      0.000000000000000_REALK, &
      0.025026059927348_REALK,      0.000000000000000_REALK,     -0.041621633266265_REALK, &
      0.000000000000000_REALK,     -0.004223727716456_REALK,      0.000000000000000_REALK, &
     -0.011132336948883_REALK,      0.000000000000000_REALK,      0.030026406726685_REALK, &
      0.000000000000000_REALK,      0.024473638171827_REALK,      0.000000000000000_REALK, &
     -0.043281995491897_REALK,      0.000000000000000_REALK,     -0.012811626686743_REALK, &
     -0.001638461295460_REALK,      0.000000000000000_REALK,      0.039618997380515_REALK, &
      0.000000000000000_REALK,      0.011302256437576_REALK,      0.000000000000000_REALK, &
     -0.044877881222570_REALK,      0.000000000000000_REALK,     -0.021579457376985_REALK, &
      0.000000000000000_REALK,      0.029216168625132_REALK,      0.000000000000000_REALK, &
     -0.004757505459243_REALK,      0.000000000000000_REALK,      0.033502390179956_REALK, &
      0.000000000000000_REALK,     -0.002829244552337_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.042280268466008_REALK,      0.000000000000000_REALK, &
      0.017990240068616_REALK,      0.000000000000000_REALK,      0.037398073209998_REALK, &
      0.000000000000000_REALK,      0.007627577482364_REALK,      0.000000000000000_REALK, &
     -0.002784613675595_REALK,      0.000000000000000_REALK,      0.006144722627860_REALK, &
      0.000000000000000_REALK,      0.003819419952691_REALK,      0.000000000000000_REALK, &
     -0.019908556212191_REALK,      0.000000000000000_REALK,     -0.002134573569366_REALK, &
      0.008071484813475_REALK,      0.000000000000000_REALK,      0.015637919098565_REALK, &
      0.000000000000000_REALK,      0.024322118615314_REALK,      0.000000000000000_REALK, &
      0.009649545950562_REALK,      0.000000000000000_REALK,      0.007883682057807_REALK, &
      0.000000000000000_REALK,      0.031384003495076_REALK,      0.000000000000000_REALK, &
     -0.013127553884044_REALK,      0.000000000000000_REALK,      0.026511472357702_REALK, &
      0.000000000000000_REALK,     -0.005238228071141_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.009626241082707_REALK,      0.000000000000000_REALK, &
     -0.039668551711256_REALK,      0.000000000000000_REALK,      0.025341916240626_REALK, &
      0.000000000000000_REALK,      0.018114246597522_REALK,      0.000000000000000_REALK, &
     -0.011963390789194_REALK,      0.000000000000000_REALK,      0.024999423859569_REALK, &
      0.000000000000000_REALK,      0.020175099124506_REALK,      0.000000000000000_REALK, &
     -0.048180043906758_REALK,      0.000000000000000_REALK,     -0.013364802363660_REALK, &
     -0.018280263285847_REALK,      0.000000000000000_REALK,      0.028876855318238_REALK, &
      0.000000000000000_REALK,      0.018076244351887_REALK,      0.000000000000000_REALK, &
     -0.073424131027929_REALK,      0.000000000000000_REALK,     -0.014308251507779_REALK, &
      0.000000000000000_REALK,      0.017869841758560_REALK,      0.000000000000000_REALK, &
     -0.015559810635745_REALK,      0.000000000000000_REALK,      0.044300634954401_REALK, &
      0.000000000000000_REALK,      0.009992691418981_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.021758046689529_REALK,      0.000000000000000_REALK, &
     -0.026148190947122_REALK,      0.000000000000000_REALK,      0.042401685918704_REALK, &
      0.000000000000000_REALK,     -0.009597847363536_REALK,      0.000000000000000_REALK, &
     -0.040625492752708_REALK,      0.000000000000000_REALK,      0.000711765088810_REALK, &
      0.000000000000000_REALK,     -0.007291800727448_REALK,      0.000000000000000_REALK, &
     -0.010621030743792_REALK,      0.000000000000000_REALK,     -0.010728029493493_REALK, &
     -0.021116605654928_REALK,      0.000000000000000_REALK,      0.004850292318845_REALK, &
      0.000000000000000_REALK,     -0.019281447029895_REALK,      0.000000000000000_REALK, &
     -0.030284682000798_REALK,      0.000000000000000_REALK,     -0.032025271610695_REALK/
  ! results of test 2, ket-major order, CM000300
  data REF_CONTR_INTS(1585:1980) /                                                         &
     -0.014275890187023_REALK,      0.000000000000000_REALK,      0.002682288734360_REALK, &
      0.000000000000000_REALK,      0.000273320010381_REALK,      0.000000000000000_REALK, &
      0.001393097372775_REALK,      0.000000000000000_REALK,     -0.005677184129899_REALK, &
     -0.007108436692554_REALK,      0.000000000000000_REALK,      0.004275713379582_REALK, &
      0.000000000000000_REALK,      0.008533546503257_REALK,      0.000000000000000_REALK, &
     -0.015854502033187_REALK,      0.000000000000000_REALK,      0.024295424057148_REALK, &
      0.000000000000000_REALK,      0.002640762332282_REALK,      0.000000000000000_REALK, &
     -0.000252656653752_REALK,      0.000000000000000_REALK,     -0.016169303959836_REALK, &
      0.000000000000000_REALK,      0.019534423630493_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.007159621659595_REALK,      0.000000000000000_REALK, &
      0.002177438661747_REALK,      0.000000000000000_REALK,     -0.010587628307239_REALK, &
      0.000000000000000_REALK,      0.016351162361036_REALK,      0.000000000000000_REALK, &
     -0.003953952500922_REALK,      0.000000000000000_REALK,      0.003904189830587_REALK, &
      0.000000000000000_REALK,      0.002424170238485_REALK,      0.000000000000000_REALK, &
     -0.005241482076432_REALK,      0.000000000000000_REALK,      0.006843755123633_REALK, &
     -0.005238850945534_REALK,      0.000000000000000_REALK,      0.005560339265727_REALK, &
      0.000000000000000_REALK,      0.008781929917089_REALK,      0.000000000000000_REALK, &
     -0.022842412718547_REALK,      0.000000000000000_REALK,      0.008689112234846_REALK, &
      0.000000000000000_REALK,      0.006456701675259_REALK,      0.000000000000000_REALK, &
     -0.002773013747681_REALK,      0.000000000000000_REALK,     -0.015135485910338_REALK, &
      0.000000000000000_REALK,      0.012242905378940_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.002033421345950_REALK,      0.000000000000000_REALK, &
     -0.006163774948314_REALK,      0.000000000000000_REALK,     -0.009090091978980_REALK, &
      0.000000000000000_REALK,      0.004067695602664_REALK,      0.000000000000000_REALK, &
     -0.000916945894367_REALK,      0.000000000000000_REALK,     -0.003023159270792_REALK, &
      0.000000000000000_REALK,      0.012757951646240_REALK,      0.000000000000000_REALK, &
     -0.016034115466061_REALK,      0.000000000000000_REALK,      0.009712969726019_REALK, &
     -0.006653329021342_REALK,      0.000000000000000_REALK,     -0.001617536203330_REALK, &
      0.000000000000000_REALK,      0.019978841639581_REALK,      0.000000000000000_REALK, &
     -0.020244051557548_REALK,      0.000000000000000_REALK,      0.010661263128577_REALK, &
      0.000000000000000_REALK,     -0.003731563659527_REALK,      0.000000000000000_REALK, &
      0.001389034026716_REALK,      0.000000000000000_REALK,      0.014238354633043_REALK, &
      0.000000000000000_REALK,     -0.011735096743987_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.001593757821475_REALK,      0.000000000000000_REALK, &
     -0.002722563447939_REALK,      0.000000000000000_REALK,      0.017357911796086_REALK, &
      0.000000000000000_REALK,     -0.014719292524531_REALK,      0.000000000000000_REALK, &
      0.001095013330038_REALK,      0.000000000000000_REALK,     -0.003295745737410_REALK, &
      0.000000000000000_REALK,      0.006194651497492_REALK,      0.000000000000000_REALK, &
     -0.007764841942039_REALK,      0.000000000000000_REALK,      0.003121508053293_REALK, &
     -0.000222547170070_REALK,      0.000000000000000_REALK,     -0.000416792482587_REALK, &
      0.000000000000000_REALK,      0.000751088463847_REALK,      0.000000000000000_REALK, &
     -0.007756960327653_REALK,      0.000000000000000_REALK,     -0.001494947572474_REALK, &
      0.000000000000000_REALK,      0.000444726152658_REALK,      0.000000000000000_REALK, &
      0.000253624567482_REALK,      0.000000000000000_REALK,      0.012199560062003_REALK, &
      0.000000000000000_REALK,     -0.011900107063324_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.003217735212834_REALK,      0.000000000000000_REALK, &
      0.001908652191571_REALK,      0.000000000000000_REALK,      0.023507236426610_REALK, &
      0.000000000000000_REALK,     -0.018647278211237_REALK,      0.000000000000000_REALK, &
      0.001606206407472_REALK,      0.000000000000000_REALK,     -0.003753855841598_REALK, &
      0.000000000000000_REALK,      0.011746769114343_REALK,      0.000000000000000_REALK, &
     -0.015250526815013_REALK,      0.000000000000000_REALK,      0.011764491256352_REALK, &
     -0.000803744795948_REALK,      0.000000000000000_REALK,     -0.002138739626549_REALK, &
      0.000000000000000_REALK,      0.006437168198745_REALK,      0.000000000000000_REALK, &
     -0.011442463586720_REALK,      0.000000000000000_REALK,      0.001500451584650_REALK, &
      0.000000000000000_REALK,      0.009315363841715_REALK,      0.000000000000000_REALK, &
     -0.002812130133628_REALK,      0.000000000000000_REALK,     -0.002338259615630_REALK, &
      0.000000000000000_REALK,      0.001434556665902_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.007273430269756_REALK,      0.000000000000000_REALK, &
      0.005450211525553_REALK,      0.000000000000000_REALK,      0.021018499634058_REALK, &
      0.000000000000000_REALK,     -0.012515441489569_REALK,      0.000000000000000_REALK, &
     -0.004372298517956_REALK,      0.000000000000000_REALK,      0.000527399761099_REALK, &
      0.000000000000000_REALK,      0.007779592223544_REALK,      0.000000000000000_REALK, &
     -0.012976782602071_REALK,      0.000000000000000_REALK,      0.025604595844673_REALK, &
     -0.008178211909126_REALK,      0.000000000000000_REALK,     -0.003180220833626_REALK, &
      0.000000000000000_REALK,      0.004829547213453_REALK,      0.000000000000000_REALK, &
      0.002219120949877_REALK,      0.000000000000000_REALK,      0.015588496647508_REALK, &
     -0.029882399802661_REALK,      0.000000000000000_REALK,      0.041243237052464_REALK, &
      0.000000000000000_REALK,      0.036918782819339_REALK,      0.000000000000000_REALK, &
     -0.029873225372751_REALK,      0.000000000000000_REALK,      0.008261201865675_REALK, &
     -0.174088040813375_REALK,      0.000000000000000_REALK,      0.103346148128983_REALK, &
      0.000000000000000_REALK,      0.074224066935012_REALK,      0.000000000000000_REALK, &
     -0.071475638377767_REALK,      0.000000000000000_REALK,      0.002084475736410_REALK, &
      0.000000000000000_REALK,     -0.107571568526534_REALK,      0.000000000000000_REALK, &
      0.027260419667504_REALK,      0.000000000000000_REALK,     -0.072244232003353_REALK, &
      0.000000000000000_REALK,      0.027553842377966_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.099736142546081_REALK,      0.000000000000000_REALK, &
      0.041070389071948_REALK,      0.000000000000000_REALK,     -0.027821060663132_REALK, &
      0.000000000000000_REALK,     -0.007189293434831_REALK,      0.000000000000000_REALK, &
     -0.038722457648267_REALK,      0.000000000000000_REALK,      0.043037608708960_REALK, &
      0.000000000000000_REALK,      0.045780479102738_REALK,      0.000000000000000_REALK, &
     -0.023120936247427_REALK,      0.000000000000000_REALK,     -0.018685799465112_REALK, &
     -0.093412263105536_REALK,      0.000000000000000_REALK,      0.127728665785603_REALK, &
      0.000000000000000_REALK,      0.128600674069192_REALK,      0.000000000000000_REALK, &
     -0.142783950244264_REALK,      0.000000000000000_REALK,     -0.064770166316680_REALK, &
      0.000000000000000_REALK,     -0.063992328343135_REALK,      0.000000000000000_REALK, &
      0.017217887194816_REALK,      0.000000000000000_REALK,     -0.053984032828828_REALK, &
      0.000000000000000_REALK,      0.007117787853938_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.073305381922499_REALK,      0.000000000000000_REALK, &
      0.000408695589190_REALK,      0.000000000000000_REALK,     -0.057906880037495_REALK, &
      0.000000000000000_REALK,     -0.025332036203579_REALK,      0.000000000000000_REALK, &
     -0.037662279547835_REALK,      0.000000000000000_REALK,      0.079088508007084_REALK, &
      0.000000000000000_REALK,      0.071735865310806_REALK,      0.000000000000000_REALK, &
     -0.075621320173614_REALK,      0.000000000000000_REALK,     -0.031017203603322_REALK, &
     -0.057159719930012_REALK,      0.000000000000000_REALK,      0.165137580881453_REALK, &
      0.000000000000000_REALK,      0.165020063647573_REALK,      0.000000000000000_REALK, &
     -0.139088461051858_REALK,      0.000000000000000_REALK,     -0.054109999019723_REALK, &
      0.000000000000000_REALK,      0.068178925433353_REALK,      0.000000000000000_REALK, &
     -0.028095099440063_REALK,      0.000000000000000_REALK,      0.071368612799471_REALK, &
      0.000000000000000_REALK,     -0.006744360972229_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.110350328292181_REALK,      0.000000000000000_REALK, &
     -0.073371213579760_REALK,      0.000000000000000_REALK,      0.150884532026688_REALK, &
      0.000000000000000_REALK,      0.001707402689788_REALK,      0.000000000000000_REALK, &
     -0.009107040344187_REALK,      0.000000000000000_REALK,      0.027855177097214_REALK, &
      0.000000000000000_REALK,      0.020032800182976_REALK,      0.000000000000000_REALK, &
     -0.035347970268460_REALK,      0.000000000000000_REALK,     -0.011982573585919_REALK, &
     -0.002925792241288_REALK,      0.000000000000000_REALK,      0.035064297877331_REALK, &
      0.000000000000000_REALK,      0.004838832111589_REALK,      0.000000000000000_REALK, &
     -0.043024070465835_REALK,      0.000000000000000_REALK,     -0.021169602482054_REALK, &
      0.000000000000000_REALK,      0.079676539300564_REALK,      0.000000000000000_REALK, &
     -0.032806513058763_REALK,      0.000000000000000_REALK,      0.074126942592960_REALK, &
      0.000000000000000_REALK,     -0.012747459226456_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.178907958776642_REALK,      0.000000000000000_REALK, &
     -0.068418236146974_REALK,      0.000000000000000_REALK,      0.183829609809569_REALK, &
      0.000000000000000_REALK,     -0.025377895693942_REALK,      0.000000000000000_REALK, &
     -0.033949951903428_REALK,      0.000000000000000_REALK,      0.061946673619296_REALK, &
      0.000000000000000_REALK,      0.056099636213281_REALK,      0.000000000000000_REALK, &
     -0.066137804335942_REALK,      0.000000000000000_REALK,     -0.030803180370349_REALK, &
      0.000901291496543_REALK,      0.000000000000000_REALK,      0.079547895399904_REALK, &
      0.000000000000000_REALK,      0.052808548277955_REALK,      0.000000000000000_REALK, &
     -0.071976758449568_REALK,      0.000000000000000_REALK,     -0.051353472592183_REALK, &
      0.000000000000000_REALK,      0.020459528034650_REALK,      0.000000000000000_REALK, &
     -0.029484323920940_REALK,      0.000000000000000_REALK,      0.059453546192057_REALK, &
      0.000000000000000_REALK,     -0.002376297263920_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.164617470474316_REALK,      0.000000000000000_REALK, &
     -0.058382777494368_REALK,      0.000000000000000_REALK,      0.187685694997357_REALK, &
      0.000000000000000_REALK,     -0.066904159276846_REALK,      0.000000000000000_REALK, &
     -0.100604093431082_REALK,      0.000000000000000_REALK,      0.035430524158662_REALK, &
      0.000000000000000_REALK,      0.016868831386224_REALK,      0.000000000000000_REALK, &
     -0.029667792750313_REALK,      0.000000000000000_REALK,     -0.045861942227298_REALK, &
     -0.055699594492265_REALK,      0.000000000000000_REALK,      0.000835794903255_REALK, &
      0.000000000000000_REALK,     -0.015848281714131_REALK,      0.000000000000000_REALK, &
      0.047600514872521_REALK,      0.000000000000000_REALK,     -0.086603782157061_REALK/
  ! results of test 2, ket-major order, CM020001
  data REF_CONTR_INTS(1981:2376) /                                                         &
      0.000000000000000_REALK,      0.009085141080870_REALK,      0.000000000000000_REALK, &
      0.009575809747965_REALK,      0.000000000000000_REALK,      0.001145868670408_REALK, &
      0.000000000000000_REALK,      0.021076679658148_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.000825417913637_REALK,      0.000000000000000_REALK, &
     -0.001831185954110_REALK,      0.000000000000000_REALK,     -0.000993969819196_REALK, &
      0.000000000000000_REALK,      0.009031824526915_REALK,      0.000000000000000_REALK, &
     -0.012570511047447_REALK,      0.000000000000000_REALK,      0.010949352964159_REALK, &
      0.000000000000000_REALK,     -0.009458465582244_REALK,      0.000000000000000_REALK, &
     -0.007866647114503_REALK,      0.000000000000000_REALK,     -0.015428202730066_REALK, &
      0.003835632751129_REALK,      0.000000000000000_REALK,      0.013076875672728_REALK, &
      0.000000000000000_REALK,     -0.009358973314894_REALK,      0.000000000000000_REALK, &
     -0.010169261866869_REALK,      0.000000000000000_REALK,     -0.017270504490558_REALK, &
      0.000000000000000_REALK,     -0.008858720815798_REALK,      0.000000000000000_REALK, &
     -0.001471508284330_REALK,      0.000000000000000_REALK,     -0.000281736399114_REALK, &
      0.000000000000000_REALK,      0.008668879083480_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.019075547207723_REALK,      0.000000000000000_REALK, &
     -0.005239915156688_REALK,      0.000000000000000_REALK,      0.000338478932974_REALK, &
      0.000000000000000_REALK,      0.005840049875937_REALK,      0.000000000000000_REALK, &
     -0.000527230996180_REALK,      0.000000000000000_REALK,     -0.000875590326637_REALK, &
      0.000000000000000_REALK,      0.003628372476272_REALK,      0.000000000000000_REALK, &
      0.000746197034425_REALK,      0.000000000000000_REALK,      0.006416397468024_REALK, &
     -0.002572578042347_REALK,      0.000000000000000_REALK,      0.006457167610767_REALK, &
      0.000000000000000_REALK,     -0.001158346814221_REALK,      0.000000000000000_REALK, &
      0.005539613502402_REALK,      0.000000000000000_REALK,      0.004087983858187_REALK, &
      0.000000000000000_REALK,      0.007316481673851_REALK,      0.000000000000000_REALK, &
     -0.000812533417170_REALK,      0.000000000000000_REALK,     -0.001291312120307_REALK, &
      0.000000000000000_REALK,     -0.003108137915382_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.008263015212889_REALK,      0.000000000000000_REALK, &
      0.000904741622360_REALK,      0.000000000000000_REALK,     -0.002784102992221_REALK, &
      0.000000000000000_REALK,      0.001394836846305_REALK,      0.000000000000000_REALK, &
     -0.005423448757298_REALK,      0.000000000000000_REALK,     -0.003584339328132_REALK, &
      0.000000000000000_REALK,      0.000314399769006_REALK,      0.000000000000000_REALK, &
      0.000694386956075_REALK,      0.000000000000000_REALK,     -0.001679368049799_REALK, &
     -0.007772604952040_REALK,      0.000000000000000_REALK,     -0.017607941273288_REALK, &
      0.000000000000000_REALK,      0.014143504856134_REALK,      0.000000000000000_REALK, &
      0.005550047093021_REALK,      0.000000000000000_REALK,      0.009485797315935_REALK, &
      0.000000000000000_REALK,      0.006771741220809_REALK,      0.000000000000000_REALK, &
     -0.004424605643342_REALK,      0.000000000000000_REALK,     -0.003585744007521_REALK, &
      0.000000000000000_REALK,     -0.014085416957900_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.003707959704221_REALK,      0.000000000000000_REALK, &
     -0.018327594851089_REALK,      0.000000000000000_REALK,     -0.009441733156202_REALK, &
      0.000000000000000_REALK,     -0.026758597208203_REALK,      0.000000000000000_REALK, &
      0.012861677352009_REALK,      0.000000000000000_REALK,      0.001935723889738_REALK, &
      0.000000000000000_REALK,      0.000281151117414_REALK,      0.000000000000000_REALK, &
     -0.000249538491201_REALK,      0.000000000000000_REALK,      0.002240399083586_REALK, &
      0.013251096359147_REALK,      0.000000000000000_REALK,      0.015950545483671_REALK, &
      0.000000000000000_REALK,     -0.011590718801286_REALK,      0.000000000000000_REALK, &
     -0.009336826585815_REALK,      0.000000000000000_REALK,     -0.009138549034989_REALK, &
      0.000000000000000_REALK,      0.004250044091842_REALK,      0.000000000000000_REALK, &
      0.001156635568619_REALK,      0.000000000000000_REALK,      0.002197248395531_REALK, &
      0.000000000000000_REALK,      0.007730973203986_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.009783412657864_REALK,      0.000000000000000_REALK, &
      0.011521513759133_REALK,      0.000000000000000_REALK,      0.007115363535609_REALK, &
      0.000000000000000_REALK,      0.028679351847633_REALK,      0.000000000000000_REALK, &
     -0.019790105403405_REALK,      0.000000000000000_REALK,     -0.009355190192558_REALK, &
      0.000000000000000_REALK,      0.005954879990334_REALK,      0.000000000000000_REALK, &
     -0.005597389344744_REALK,      0.000000000000000_REALK,      0.009100542129764_REALK, &
     -0.026561483875095_REALK,      0.000000000000000_REALK,     -0.003609671853731_REALK, &
      0.000000000000000_REALK,     -0.001391483798454_REALK,      0.000000000000000_REALK, &
     -0.007862996025208_REALK,      0.000000000000000_REALK,      0.004658412791432_REALK, &
      0.000000000000000_REALK,      0.017797731887542_REALK,      0.000000000000000_REALK, &
      0.002506422865611_REALK,      0.000000000000000_REALK,     -0.002763220845626_REALK, &
      0.000000000000000_REALK,     -0.004266090538415_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.013342491900902_REALK,      0.000000000000000_REALK, &
      0.007995442065123_REALK,      0.000000000000000_REALK,      0.001586281693578_REALK, &
      0.000000000000000_REALK,      0.003965265167472_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.041726060690354_REALK,      0.000000000000000_REALK, &
     -0.017057232890615_REALK,      0.000000000000000_REALK,      0.024733050358097_REALK, &
      0.000000000000000_REALK,      0.004223166212370_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.029790458716619_REALK,      0.000000000000000_REALK, &
     -0.089246125369880_REALK,      0.000000000000000_REALK,      0.026936508141861_REALK, &
      0.000000000000000_REALK,      0.009755523140761_REALK,      0.000000000000000_REALK, &
     -0.009704797522307_REALK,      0.000000000000000_REALK,      0.030815795020502_REALK, &
      0.000000000000000_REALK,     -0.021681054404403_REALK,      0.000000000000000_REALK, &
     -0.120177465693760_REALK,      0.000000000000000_REALK,     -0.006567831896459_REALK, &
     -0.003856528494020_REALK,      0.000000000000000_REALK,      0.031228151092956_REALK, &
      0.000000000000000_REALK,      0.014668279518001_REALK,      0.000000000000000_REALK, &
     -0.102960946754989_REALK,      0.000000000000000_REALK,     -0.059630199170210_REALK, &
      0.000000000000000_REALK,     -0.005540388231406_REALK,      0.000000000000000_REALK, &
     -0.093290235030016_REALK,      0.000000000000000_REALK,     -0.033639042337749_REALK, &
      0.000000000000000_REALK,      0.030161588125247_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.045755820618656_REALK,      0.000000000000000_REALK, &
     -0.162336761530852_REALK,      0.000000000000000_REALK,     -0.056188700918266_REALK, &
      0.000000000000000_REALK,      0.018825693606929_REALK,      0.000000000000000_REALK, &
      0.001613510542882_REALK,      0.000000000000000_REALK,      0.021941872746521_REALK, &
      0.000000000000000_REALK,      0.020204868631554_REALK,      0.000000000000000_REALK, &
      0.018637061835790_REALK,      0.000000000000000_REALK,     -0.000681792418667_REALK, &
      0.006896528423744_REALK,      0.000000000000000_REALK,      0.065989038335043_REALK, &
      0.000000000000000_REALK,      0.034419329831789_REALK,      0.000000000000000_REALK, &
      0.031216938200350_REALK,      0.000000000000000_REALK,      0.020973999815623_REALK, &
      0.000000000000000_REALK,      0.004647916687646_REALK,      0.000000000000000_REALK, &
      0.032427068285084_REALK,      0.000000000000000_REALK,      0.036761284111018_REALK, &
      0.000000000000000_REALK,     -0.002438923259716_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.008395764821472_REALK,      0.000000000000000_REALK, &
      0.034784606232945_REALK,      0.000000000000000_REALK,      0.023902927053787_REALK, &
      0.000000000000000_REALK,      0.009478661701314_REALK,      0.000000000000000_REALK, &
      0.004606322681759_REALK,      0.000000000000000_REALK,     -0.036936983735988_REALK, &
      0.000000000000000_REALK,     -0.031453462945312_REALK,      0.000000000000000_REALK, &
     -0.019405124994738_REALK,      0.000000000000000_REALK,      0.016686592663884_REALK, &
      0.026888417210312_REALK,      0.000000000000000_REALK,     -0.091126498547769_REALK, &
      0.000000000000000_REALK,     -0.004654743400509_REALK,      0.000000000000000_REALK, &
      0.038076350086373_REALK,      0.000000000000000_REALK,      0.037994846640085_REALK, &
      0.000000000000000_REALK,     -0.020993098205540_REALK,      0.000000000000000_REALK, &
      0.083529266255990_REALK,      0.000000000000000_REALK,      0.022318839187471_REALK, &
      0.000000000000000_REALK,     -0.029465246025704_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.115728082148738_REALK,      0.000000000000000_REALK, &
      0.045177974711012_REALK,      0.000000000000000_REALK,     -0.005847107633466_REALK, &
      0.000000000000000_REALK,     -0.018089089459913_REALK,      0.000000000000000_REALK, &
     -0.007700321256495_REALK,      0.000000000000000_REALK,      0.022461825906995_REALK, &
      0.000000000000000_REALK,      0.032362277898490_REALK,      0.000000000000000_REALK, &
      0.044530805548551_REALK,      0.000000000000000_REALK,     -0.023368191829463_REALK, &
     -0.042721533137551_REALK,      0.000000000000000_REALK,      0.090769620893206_REALK, &
      0.000000000000000_REALK,      0.005325675152788_REALK,      0.000000000000000_REALK, &
     -0.042860907877782_REALK,      0.000000000000000_REALK,     -0.054921670604271_REALK, &
      0.000000000000000_REALK,      0.025507854233404_REALK,      0.000000000000000_REALK, &
     -0.043776887902711_REALK,      0.000000000000000_REALK,      0.052366120742843_REALK, &
      0.000000000000000_REALK,      0.035733535001710_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.104333678658512_REALK,      0.000000000000000_REALK, &
     -0.082548776029975_REALK,      0.000000000000000_REALK,      0.078811494062235_REALK, &
      0.000000000000000_REALK,      0.071071860469398_REALK,      0.000000000000000_REALK, &
     -0.003776439309366_REALK,      0.000000000000000_REALK,     -0.051831211046185_REALK, &
      0.000000000000000_REALK,     -0.077284139515571_REALK,      0.000000000000000_REALK, &
     -0.079109097114333_REALK,      0.000000000000000_REALK,      0.034216994481034_REALK, &
      0.010459418964524_REALK,      0.000000000000000_REALK,     -0.053677863052081_REALK, &
      0.000000000000000_REALK,     -0.147997336576066_REALK,      0.000000000000000_REALK, &
     -0.155759115486125_REALK,      0.000000000000000_REALK,      0.051766131103519_REALK, &
      0.000000000000000_REALK,      0.071870935961598_REALK,      0.000000000000000_REALK, &
      0.077985883225659_REALK,      0.000000000000000_REALK,      0.006941948090536_REALK, &
      0.000000000000000_REALK,     -0.044494404095971_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.085660210589068_REALK,      0.000000000000000_REALK, &
      0.076862832220828_REALK,      0.000000000000000_REALK,     -0.004698964723378_REALK, &
      0.000000000000000_REALK,     -0.056867194272672_REALK,      0.000000000000000_REALK/
  ! results of test 2, ket-major order, CM010101
  data REF_CONTR_INTS(2377:2772) /                                                         &
      0.000000000000000_REALK,      0.005838730366428_REALK,      0.000000000000000_REALK, &
      0.000136771567863_REALK,      0.000000000000000_REALK,     -0.003981955696482_REALK, &
      0.000000000000000_REALK,      0.007517471540348_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.006177663876957_REALK,      0.000000000000000_REALK, &
      0.003430623867512_REALK,      0.000000000000000_REALK,     -0.000505064981366_REALK, &
      0.000000000000000_REALK,      0.006077122742149_REALK,      0.000000000000000_REALK, &
     -0.004705581631228_REALK,      0.000000000000000_REALK,      0.002956744897772_REALK, &
      0.000000000000000_REALK,     -0.000448663267389_REALK,      0.000000000000000_REALK, &
     -0.002613391238912_REALK,      0.000000000000000_REALK,     -0.006459236768447_REALK, &
     -0.014779838716943_REALK,      0.000000000000000_REALK,      0.000604732744995_REALK, &
      0.000000000000000_REALK,      0.001003657819171_REALK,      0.000000000000000_REALK, &
     -0.000566339440865_REALK,      0.000000000000000_REALK,     -0.005938291971342_REALK, &
      0.000000000000000_REALK,     -0.003041353032119_REALK,      0.000000000000000_REALK, &
     -0.000761481963836_REALK,      0.000000000000000_REALK,     -0.000982442431139_REALK, &
      0.000000000000000_REALK,      0.002003826197483_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.001847677558820_REALK,      0.000000000000000_REALK, &
      0.006378904237367_REALK,      0.000000000000000_REALK,      0.002562218053697_REALK, &
      0.000000000000000_REALK,      0.012043854114182_REALK,      0.000000000000000_REALK, &
     -0.003501581666906_REALK,      0.000000000000000_REALK,     -0.000605694450941_REALK, &
      0.000000000000000_REALK,      0.001966065105502_REALK,      0.000000000000000_REALK, &
     -0.000683897654686_REALK,      0.000000000000000_REALK,      0.000409345247844_REALK, &
      0.002091881684133_REALK,      0.000000000000000_REALK,      0.007317830387084_REALK, &
      0.000000000000000_REALK,     -0.006497068390233_REALK,      0.000000000000000_REALK, &
     -0.000271953754390_REALK,      0.000000000000000_REALK,     -0.005996394648350_REALK, &
      0.000000000000000_REALK,      0.004710806761912_REALK,      0.000000000000000_REALK, &
     -0.000463108083412_REALK,      0.000000000000000_REALK,     -0.000772066560705_REALK, &
      0.000000000000000_REALK,      0.001054201300783_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.002883499738968_REALK,      0.000000000000000_REALK, &
     -0.003491035854419_REALK,      0.000000000000000_REALK,     -0.002330240178191_REALK, &
      0.000000000000000_REALK,     -0.000907422070663_REALK,      0.000000000000000_REALK, &
      0.002795387354590_REALK,      0.000000000000000_REALK,     -0.000024325337141_REALK, &
      0.000000000000000_REALK,     -0.001083377082408_REALK,      0.000000000000000_REALK, &
     -0.000815044109955_REALK,      0.000000000000000_REALK,     -0.000268758862502_REALK, &
      0.002115283602910_REALK,      0.000000000000000_REALK,      0.000300292285033_REALK, &
      0.000000000000000_REALK,     -0.002119431145265_REALK,      0.000000000000000_REALK, &
     -0.005180865012444_REALK,      0.000000000000000_REALK,     -0.003019111314749_REALK, &
      0.000000000000000_REALK,      0.004863931219654_REALK,      0.000000000000000_REALK, &
      0.000753145353785_REALK,      0.000000000000000_REALK,      0.000104132136337_REALK, &
      0.000000000000000_REALK,      0.000266095581782_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.009820894214691_REALK,      0.000000000000000_REALK, &
      0.005326943580160_REALK,      0.000000000000000_REALK,     -0.000181446791235_REALK, &
      0.000000000000000_REALK,      0.006421353982101_REALK,      0.000000000000000_REALK, &
      0.000296002912362_REALK,      0.000000000000000_REALK,     -0.001386566030034_REALK, &
      0.000000000000000_REALK,      0.000954974469342_REALK,      0.000000000000000_REALK, &
      0.000786798420432_REALK,      0.000000000000000_REALK,      0.003496823502955_REALK, &
     -0.002222904577431_REALK,      0.000000000000000_REALK,     -0.004844425797962_REALK, &
      0.000000000000000_REALK,      0.004349293614186_REALK,      0.000000000000000_REALK, &
      0.002902141719519_REALK,      0.000000000000000_REALK,      0.005353391286423_REALK, &
      0.000000000000000_REALK,      0.003851895932347_REALK,      0.000000000000000_REALK, &
     -0.000977205430763_REALK,      0.000000000000000_REALK,      0.000068384647894_REALK, &
      0.000000000000000_REALK,      0.000380763543330_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.008470705382640_REALK,      0.000000000000000_REALK, &
     -0.004151777977951_REALK,      0.000000000000000_REALK,     -0.005308614749423_REALK, &
      0.000000000000000_REALK,      0.000478784348751_REALK,      0.000000000000000_REALK, &
     -0.004588087538391_REALK,      0.000000000000000_REALK,     -0.005085289255127_REALK, &
      0.000000000000000_REALK,      0.005196392849850_REALK,      0.000000000000000_REALK, &
     -0.004319792594037_REALK,      0.000000000000000_REALK,      0.003003120012711_REALK, &
     -0.003458405895830_REALK,      0.000000000000000_REALK,     -0.006267619286110_REALK, &
      0.000000000000000_REALK,      0.006053987423112_REALK,      0.000000000000000_REALK, &
     -0.001736194176010_REALK,      0.000000000000000_REALK,      0.003689792332331_REALK, &
      0.000000000000000_REALK,      0.005170144679658_REALK,      0.000000000000000_REALK, &
     -0.003274215607169_REALK,      0.000000000000000_REALK,     -0.000445972888964_REALK, &
      0.000000000000000_REALK,     -0.006844974289611_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.001979102386443_REALK,      0.000000000000000_REALK, &
     -0.000832436008345_REALK,      0.000000000000000_REALK,      0.002716189449063_REALK, &
      0.000000000000000_REALK,     -0.006360842640532_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000809560973879_REALK,      0.000000000000000_REALK, &
     -0.018923717710093_REALK,      0.000000000000000_REALK,      0.017678616126796_REALK, &
      0.000000000000000_REALK,      0.012740601441301_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.025781119547351_REALK,      0.000000000000000_REALK, &
      0.000652381204009_REALK,      0.000000000000000_REALK,      0.022976581071323_REALK, &
      0.000000000000000_REALK,      0.002707620715264_REALK,      0.000000000000000_REALK, &
      0.002770597346714_REALK,      0.000000000000000_REALK,      0.035994372551136_REALK, &
      0.000000000000000_REALK,      0.032609436500197_REALK,      0.000000000000000_REALK, &
     -0.041025039402669_REALK,      0.000000000000000_REALK,     -0.006486873619900_REALK, &
     -0.000621718982892_REALK,      0.000000000000000_REALK,      0.040526203634969_REALK, &
      0.000000000000000_REALK,      0.033203059083796_REALK,      0.000000000000000_REALK, &
     -0.051932793354272_REALK,      0.000000000000000_REALK,      0.014530063002305_REALK, &
      0.000000000000000_REALK,     -0.005775626526374_REALK,      0.000000000000000_REALK, &
     -0.028168310745604_REALK,      0.000000000000000_REALK,     -0.024858308937301_REALK, &
      0.000000000000000_REALK,      0.006911578252361_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.008658734596148_REALK,      0.000000000000000_REALK, &
     -0.024495766318826_REALK,      0.000000000000000_REALK,     -0.024963883921571_REALK, &
      0.000000000000000_REALK,      0.030587982963168_REALK,      0.000000000000000_REALK, &
      0.002415584576119_REALK,      0.000000000000000_REALK,      0.016951791972694_REALK, &
      0.000000000000000_REALK,      0.009596606542682_REALK,      0.000000000000000_REALK, &
     -0.007420873195991_REALK,      0.000000000000000_REALK,     -0.001474209889245_REALK, &
      0.005738048329776_REALK,      0.000000000000000_REALK,      0.043579597928348_REALK, &
      0.000000000000000_REALK,     -0.000166579487693_REALK,      0.000000000000000_REALK, &
      0.006434514080549_REALK,      0.000000000000000_REALK,     -0.018395045731057_REALK, &
      0.000000000000000_REALK,      0.003787379610187_REALK,      0.000000000000000_REALK, &
      0.001222767968081_REALK,      0.000000000000000_REALK,      0.035673342814891_REALK, &
      0.000000000000000_REALK,      0.010270521147596_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.016408404513040_REALK,      0.000000000000000_REALK, &
     -0.015148841205911_REALK,      0.000000000000000_REALK,      0.033363486719098_REALK, &
      0.000000000000000_REALK,      0.006396031611912_REALK,      0.000000000000000_REALK, &
     -0.003820254760499_REALK,      0.000000000000000_REALK,     -0.016883234145093_REALK, &
      0.000000000000000_REALK,     -0.012785853329711_REALK,      0.000000000000000_REALK, &
     -0.001077528164944_REALK,      0.000000000000000_REALK,     -0.001874714503182_REALK, &
     -0.009674632564845_REALK,      0.000000000000000_REALK,     -0.018305701346946_REALK, &
      0.000000000000000_REALK,     -0.028933765728875_REALK,      0.000000000000000_REALK, &
     -0.032202403370342_REALK,      0.000000000000000_REALK,     -0.018007907304790_REALK, &
      0.000000000000000_REALK,      0.006383416582216_REALK,      0.000000000000000_REALK, &
      0.019834319260488_REALK,      0.000000000000000_REALK,      0.029851115500750_REALK, &
      0.000000000000000_REALK,      0.003163548146131_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.029912206296310_REALK,      0.000000000000000_REALK, &
      0.031382366081898_REALK,      0.000000000000000_REALK,      0.023763882257001_REALK, &
      0.000000000000000_REALK,      0.011904080972834_REALK,      0.000000000000000_REALK, &
     -0.004009173459228_REALK,      0.000000000000000_REALK,     -0.008504282078681_REALK, &
      0.000000000000000_REALK,     -0.006881289005200_REALK,      0.000000000000000_REALK, &
      0.011164216015062_REALK,      0.000000000000000_REALK,      0.004840742199051_REALK, &
      0.004679239236100_REALK,      0.000000000000000_REALK,     -0.015944003405728_REALK, &
      0.000000000000000_REALK,      0.006096934174571_REALK,      0.000000000000000_REALK, &
      0.009300448419102_REALK,      0.000000000000000_REALK,      0.013498640847159_REALK, &
      0.000000000000000_REALK,      0.008685837156541_REALK,      0.000000000000000_REALK, &
     -0.014512529314963_REALK,      0.000000000000000_REALK,      0.040895001810082_REALK, &
      0.000000000000000_REALK,      0.012811285949102_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.006630472540853_REALK,      0.000000000000000_REALK, &
     -0.019558692881251_REALK,      0.000000000000000_REALK,      0.059840830035786_REALK, &
      0.000000000000000_REALK,      0.022122940754350_REALK,      0.000000000000000_REALK, &
     -0.006828594011580_REALK,      0.000000000000000_REALK,     -0.013532840800934_REALK, &
      0.000000000000000_REALK,     -0.016456468739784_REALK,      0.000000000000000_REALK, &
     -0.033304020258389_REALK,      0.000000000000000_REALK,     -0.002747964347352_REALK, &
     -0.015647483005476_REALK,      0.000000000000000_REALK,     -0.019722629986056_REALK, &
      0.000000000000000_REALK,     -0.016204053624159_REALK,      0.000000000000000_REALK, &
     -0.007144789861620_REALK,      0.000000000000000_REALK,     -0.004682552789628_REALK, &
      0.000000000000000_REALK,      0.024644512599932_REALK,      0.000000000000000_REALK, &
     -0.000600347543217_REALK,      0.000000000000000_REALK,      0.023811016585755_REALK, &
      0.000000000000000_REALK,     -0.010136346275712_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.022413035811242_REALK,      0.000000000000000_REALK, &
     -0.000698499408126_REALK,      0.000000000000000_REALK,      0.023241710794981_REALK, &
      0.000000000000000_REALK,     -0.004890825891436_REALK,      0.000000000000000_REALK/
  ! results of test 2, ket-major order, CM000201
  data REF_CONTR_INTS(2773:3168) /                                                         &
      0.000000000000000_REALK,      0.004481367866908_REALK,      0.000000000000000_REALK, &
     -0.001362709040278_REALK,      0.000000000000000_REALK,     -0.004009022939903_REALK, &
      0.000000000000000_REALK,      0.004903392449991_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.002181437242305_REALK,      0.000000000000000_REALK, &
     -0.002109214978061_REALK,      0.000000000000000_REALK,      0.003270164782233_REALK, &
      0.000000000000000_REALK,     -0.003938909610905_REALK,      0.000000000000000_REALK, &
     -0.003415140312578_REALK,      0.000000000000000_REALK,      0.001257512228930_REALK, &
      0.000000000000000_REALK,      0.001739771234136_REALK,      0.000000000000000_REALK, &
     -0.002631837906484_REALK,      0.000000000000000_REALK,     -0.007374905315474_REALK, &
     -0.000183562096843_REALK,      0.000000000000000_REALK,     -0.000487147629781_REALK, &
      0.000000000000000_REALK,      0.005165032597424_REALK,      0.000000000000000_REALK, &
     -0.006802211666613_REALK,      0.000000000000000_REALK,     -0.005090832092859_REALK, &
      0.000000000000000_REALK,     -0.000943180974781_REALK,      0.000000000000000_REALK, &
     -0.000819931049498_REALK,      0.000000000000000_REALK,     -0.001414523130955_REALK, &
      0.000000000000000_REALK,      0.001288819002631_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.001769867690592_REALK,      0.000000000000000_REALK, &
     -0.006650398378889_REALK,      0.000000000000000_REALK,     -0.010400432024235_REALK, &
      0.000000000000000_REALK,      0.004491399031654_REALK,      0.000000000000000_REALK, &
     -0.003818291584509_REALK,      0.000000000000000_REALK,     -0.000129243418003_REALK, &
      0.000000000000000_REALK,      0.001554923233655_REALK,      0.000000000000000_REALK, &
     -0.000467855180275_REALK,      0.000000000000000_REALK,     -0.002540282792681_REALK, &
     -0.003038455031838_REALK,      0.000000000000000_REALK,     -0.001007748611156_REALK, &
      0.000000000000000_REALK,      0.003094185885886_REALK,      0.000000000000000_REALK, &
      0.004233546085908_REALK,      0.000000000000000_REALK,      0.002406278474866_REALK, &
      0.000000000000000_REALK,      0.004311482898199_REALK,      0.000000000000000_REALK, &
     -0.000578400415896_REALK,      0.000000000000000_REALK,     -0.001751746337317_REALK, &
      0.000000000000000_REALK,      0.003679921185886_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.009854339929490_REALK,      0.000000000000000_REALK, &
      0.000181251700889_REALK,      0.000000000000000_REALK,     -0.010687318818163_REALK, &
      0.000000000000000_REALK,      0.014858920697643_REALK,      0.000000000000000_REALK, &
      0.001891615294713_REALK,      0.000000000000000_REALK,     -0.000796110803539_REALK, &
      0.000000000000000_REALK,      0.000121628205955_REALK,      0.000000000000000_REALK, &
     -0.000821314368147_REALK,      0.000000000000000_REALK,      0.003376760477514_REALK, &
     -0.002009934828271_REALK,      0.000000000000000_REALK,     -0.005487470954961_REALK, &
      0.000000000000000_REALK,      0.008005032560496_REALK,      0.000000000000000_REALK, &
     -0.004689502359047_REALK,      0.000000000000000_REALK,      0.009134123370922_REALK, &
      0.000000000000000_REALK,      0.003040250268134_REALK,      0.000000000000000_REALK, &
     -0.000465028183639_REALK,      0.000000000000000_REALK,     -0.000469503867833_REALK, &
      0.000000000000000_REALK,      0.000765247024648_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.000161638287548_REALK,      0.000000000000000_REALK, &
     -0.004539249043202_REALK,      0.000000000000000_REALK,     -0.002152589494824_REALK, &
      0.000000000000000_REALK,     -0.001957218669210_REALK,      0.000000000000000_REALK, &
      0.001467321504324_REALK,      0.000000000000000_REALK,     -0.000636991589940_REALK, &
      0.000000000000000_REALK,      0.000345011057112_REALK,      0.000000000000000_REALK, &
     -0.001199389127140_REALK,      0.000000000000000_REALK,      0.004714074248621_REALK, &
      0.000175856194572_REALK,      0.000000000000000_REALK,     -0.001321234646535_REALK, &
      0.000000000000000_REALK,      0.004059518127272_REALK,      0.000000000000000_REALK, &
     -0.009336992114017_REALK,      0.000000000000000_REALK,      0.009238162951174_REALK, &
      0.000000000000000_REALK,      0.003885892698465_REALK,      0.000000000000000_REALK, &
     -0.000286022196624_REALK,      0.000000000000000_REALK,      0.000483843296574_REALK, &
      0.000000000000000_REALK,      0.002259036348598_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.007143365929047_REALK,      0.000000000000000_REALK, &
     -0.002793731012322_REALK,      0.000000000000000_REALK,     -0.001548771867539_REALK, &
      0.000000000000000_REALK,      0.002161412755898_REALK,      0.000000000000000_REALK, &
     -0.004932411079764_REALK,      0.000000000000000_REALK,     -0.003374858334606_REALK, &
      0.000000000000000_REALK,      0.004059003146974_REALK,      0.000000000000000_REALK, &
     -0.004178328481680_REALK,      0.000000000000000_REALK,      0.002754316929520_REALK, &
      0.004001072400658_REALK,      0.000000000000000_REALK,     -0.001273472346382_REALK, &
      0.000000000000000_REALK,      0.000851292563118_REALK,      0.000000000000000_REALK, &
     -0.005738042398554_REALK,      0.000000000000000_REALK,      0.012269635925612_REALK, &
      0.000000000000000_REALK,      0.003066109993112_REALK,      0.000000000000000_REALK, &
     -0.000593933891797_REALK,      0.000000000000000_REALK,      0.004350977774165_REALK, &
      0.000000000000000_REALK,     -0.006462786329490_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.000541260919137_REALK,      0.000000000000000_REALK, &
     -0.001547026048711_REALK,      0.000000000000000_REALK,      0.003475097290483_REALK, &
      0.000000000000000_REALK,     -0.006946278666999_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.009124970640264_REALK,      0.000000000000000_REALK, &
     -0.013708830799806_REALK,      0.000000000000000_REALK,      0.014834412901674_REALK, &
      0.000000000000000_REALK,      0.006690018653976_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.029571488036172_REALK,      0.000000000000000_REALK, &
     -0.036749634142164_REALK,      0.000000000000000_REALK,      0.062516455999910_REALK, &
      0.000000000000000_REALK,     -0.020563315515849_REALK,      0.000000000000000_REALK, &
      0.015770538622508_REALK,      0.000000000000000_REALK,      0.045023564635024_REALK, &
      0.000000000000000_REALK,      0.049138057052569_REALK,      0.000000000000000_REALK, &
     -0.038729921389214_REALK,      0.000000000000000_REALK,     -0.008301795667070_REALK, &
      0.015603372535157_REALK,      0.000000000000000_REALK,      0.065867756801409_REALK, &
      0.000000000000000_REALK,      0.077129420639166_REALK,      0.000000000000000_REALK, &
     -0.068114656485523_REALK,      0.000000000000000_REALK,     -0.003995893527588_REALK, &
      0.000000000000000_REALK,     -0.002941693330567_REALK,      0.000000000000000_REALK, &
     -0.011875980706478_REALK,      0.000000000000000_REALK,     -0.016683970603125_REALK, &
      0.000000000000000_REALK,      0.005743776540525_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.038874234938719_REALK,      0.000000000000000_REALK, &
     -0.029606549598757_REALK,      0.000000000000000_REALK,     -0.030735249209268_REALK, &
      0.000000000000000_REALK,      0.046266373946956_REALK,      0.000000000000000_REALK, &
      0.007801605940465_REALK,      0.000000000000000_REALK,      0.025711516924266_REALK, &
      0.000000000000000_REALK,      0.018779375868989_REALK,      0.000000000000000_REALK, &
     -0.012570368422650_REALK,      0.000000000000000_REALK,     -0.001216994466031_REALK, &
      0.007053014237657_REALK,      0.000000000000000_REALK,      0.028503256461850_REALK, &
      0.000000000000000_REALK,      0.031690150149581_REALK,      0.000000000000000_REALK, &
      0.027105936382549_REALK,      0.000000000000000_REALK,      0.020795543373075_REALK, &
      0.000000000000000_REALK,     -0.000874935394225_REALK,      0.000000000000000_REALK, &
     -0.011998912104272_REALK,      0.000000000000000_REALK,      0.035227876533608_REALK, &
      0.000000000000000_REALK,      0.021462456690569_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.037342308791341_REALK,      0.000000000000000_REALK, &
     -0.011226931933136_REALK,      0.000000000000000_REALK,      0.010232810754024_REALK, &
      0.000000000000000_REALK,      0.066102346402529_REALK,      0.000000000000000_REALK, &
     -0.011453807649949_REALK,      0.000000000000000_REALK,     -0.020302687165979_REALK, &
      0.000000000000000_REALK,     -0.015277479344819_REALK,      0.000000000000000_REALK, &
      0.002688562152791_REALK,      0.000000000000000_REALK,      0.001612833484245_REALK, &
     -0.031395264550533_REALK,      0.000000000000000_REALK,     -0.023067992774115_REALK, &
      0.000000000000000_REALK,      0.007716363307902_REALK,      0.000000000000000_REALK, &
     -0.037836682888040_REALK,      0.000000000000000_REALK,      0.003948148271929_REALK, &
      0.000000000000000_REALK,      0.001773888900774_REALK,      0.000000000000000_REALK, &
     -0.001869281210276_REALK,      0.000000000000000_REALK,      0.028512097415981_REALK, &
      0.000000000000000_REALK,      0.008623847666047_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.021703154883647_REALK,      0.000000000000000_REALK, &
     -0.020137093030332_REALK,      0.000000000000000_REALK,      0.026524842295537_REALK, &
      0.000000000000000_REALK,      0.004135263537519_REALK,      0.000000000000000_REALK, &
     -0.014496249620627_REALK,      0.000000000000000_REALK,     -0.016151667193504_REALK, &
      0.000000000000000_REALK,     -0.016222912684566_REALK,      0.000000000000000_REALK, &
      0.005333855494659_REALK,      0.000000000000000_REALK,      0.001586963445073_REALK, &
     -0.051983917969853_REALK,      0.000000000000000_REALK,     -0.014424605561860_REALK, &
      0.000000000000000_REALK,     -0.001699750038233_REALK,      0.000000000000000_REALK, &
     -0.047032395049031_REALK,      0.000000000000000_REALK,     -0.007520184893291_REALK, &
      0.000000000000000_REALK,      0.008923322502770_REALK,      0.000000000000000_REALK, &
     -0.017546729933440_REALK,      0.000000000000000_REALK,      0.044949920139485_REALK, &
      0.000000000000000_REALK,      0.020472167541804_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.000226027740099_REALK,      0.000000000000000_REALK, &
     -0.030236831987346_REALK,      0.000000000000000_REALK,      0.085262319928697_REALK, &
      0.000000000000000_REALK,      0.028840810314027_REALK,      0.000000000000000_REALK, &
     -0.012075218774667_REALK,      0.000000000000000_REALK,      0.005046840070449_REALK, &
      0.000000000000000_REALK,     -0.003942838678097_REALK,      0.000000000000000_REALK, &
     -0.030588679307492_REALK,      0.000000000000000_REALK,      0.001769256619445_REALK, &
     -0.042957077022915_REALK,      0.000000000000000_REALK,     -0.014444431674289_REALK, &
      0.000000000000000_REALK,     -0.049289355430680_REALK,      0.000000000000000_REALK, &
     -0.001029903206148_REALK,      0.000000000000000_REALK,      0.015706038303131_REALK, &
      0.000000000000000_REALK,      0.045602763775976_REALK,      0.000000000000000_REALK, &
     -0.013865770298810_REALK,      0.000000000000000_REALK,      0.041249945693267_REALK, &
      0.000000000000000_REALK,     -0.009363458465569_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.046487166246768_REALK,      0.000000000000000_REALK, &
     -0.019589689116162_REALK,      0.000000000000000_REALK,      0.023523166026833_REALK, &
      0.000000000000000_REALK,     -0.002233047767889_REALK,      0.000000000000000_REALK/
  ! results of test 2, ket-major order, CM010002
  data REF_CONTR_INTS(3169:3564) /                                                         &
     -0.007182949505706_REALK,      0.000000000000000_REALK,      0.001074919580121_REALK, &
      0.000000000000000_REALK,     -0.000745783215308_REALK,      0.000000000000000_REALK, &
     -0.004326883947671_REALK,      0.000000000000000_REALK,     -0.003192437836687_REALK, &
     -0.001870966996323_REALK,      0.000000000000000_REALK,      0.001694852585417_REALK, &
      0.000000000000000_REALK,     -0.000896388130325_REALK,      0.000000000000000_REALK, &
     -0.004559747107973_REALK,      0.000000000000000_REALK,     -0.003728540038946_REALK, &
      0.000000000000000_REALK,     -0.001847181384376_REALK,      0.000000000000000_REALK, &
      0.003935013658431_REALK,      0.000000000000000_REALK,      0.000912535314474_REALK, &
      0.000000000000000_REALK,      0.017683553264690_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.005321770280794_REALK,      0.000000000000000_REALK, &
     -0.004563319321719_REALK,      0.000000000000000_REALK,     -0.004500897892964_REALK, &
      0.000000000000000_REALK,      0.014569887001578_REALK,      0.000000000000000_REALK, &
      0.000523981864306_REALK,      0.000000000000000_REALK,      0.011764339158976_REALK, &
      0.000000000000000_REALK,     -0.008098658275699_REALK,      0.000000000000000_REALK, &
     -0.000440257221642_REALK,      0.000000000000000_REALK,     -0.005656723584615_REALK, &
      0.007566880306820_REALK,      0.000000000000000_REALK,      0.019924166882524_REALK, &
      0.000000000000000_REALK,     -0.011640694075367_REALK,      0.000000000000000_REALK, &
      0.000601285342961_REALK,      0.000000000000000_REALK,     -0.010523894123182_REALK, &
      0.000000000000000_REALK,      0.001563808326262_REALK,      0.000000000000000_REALK, &
     -0.003174995951989_REALK,      0.000000000000000_REALK,     -0.004189880640046_REALK, &
      0.000000000000000_REALK,     -0.000865679077913_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.017721990151674_REALK,      0.000000000000000_REALK, &
     -0.002120243236217_REALK,      0.000000000000000_REALK,     -0.000432482569509_REALK, &
      0.000000000000000_REALK,     -0.001358906441900_REALK,      0.000000000000000_REALK, &
     -0.002173785506527_REALK,      0.000000000000000_REALK,     -0.005872602264191_REALK, &
      0.000000000000000_REALK,      0.005359382094883_REALK,      0.000000000000000_REALK, &
     -0.002371178475683_REALK,      0.000000000000000_REALK,      0.001990103816520_REALK, &
     -0.003543444315216_REALK,      0.000000000000000_REALK,     -0.002729918036830_REALK, &
      0.000000000000000_REALK,      0.003658446479937_REALK,      0.000000000000000_REALK, &
     -0.001486245905562_REALK,      0.000000000000000_REALK,      0.001915451616245_REALK, &
      0.000000000000000_REALK,      0.001885887016299_REALK,      0.000000000000000_REALK, &
      0.003373151759414_REALK,      0.000000000000000_REALK,      0.003061378548529_REALK, &
      0.000000000000000_REALK,      0.000135012672526_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.011050034418803_REALK,      0.000000000000000_REALK, &
     -0.002250683206580_REALK,      0.000000000000000_REALK,     -0.001327494946625_REALK, &
      0.000000000000000_REALK,     -0.015399519700912_REALK,      0.000000000000000_REALK, &
      0.001660710073813_REALK,      0.000000000000000_REALK,     -0.009292801468109_REALK, &
      0.000000000000000_REALK,      0.008335041349195_REALK,      0.000000000000000_REALK, &
      0.000892756970176_REALK,      0.000000000000000_REALK,      0.004472543448678_REALK, &
      0.011624691793212_REALK,      0.000000000000000_REALK,      0.002827153621735_REALK, &
      0.000000000000000_REALK,      0.000957355440673_REALK,      0.000000000000000_REALK, &
      0.003748108943181_REALK,      0.000000000000000_REALK,     -0.003659920245104_REALK, &
      0.000000000000000_REALK,     -0.002671507669785_REALK,      0.000000000000000_REALK, &
     -0.003905092871204_REALK,      0.000000000000000_REALK,     -0.000723273835539_REALK, &
      0.000000000000000_REALK,     -0.004355415585219_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.009283978826713_REALK,      0.000000000000000_REALK, &
      0.000762862358069_REALK,      0.000000000000000_REALK,      0.003427786529415_REALK, &
      0.000000000000000_REALK,      0.017826042648386_REALK,      0.000000000000000_REALK, &
     -0.005738564964130_REALK,      0.000000000000000_REALK,     -0.001071024902600_REALK, &
      0.000000000000000_REALK,      0.000816502116009_REALK,      0.000000000000000_REALK, &
     -0.006848988618072_REALK,      0.000000000000000_REALK,     -0.001264407943709_REALK, &
     -0.020683336506230_REALK,      0.000000000000000_REALK,      0.004211696036486_REALK, &
      0.000000000000000_REALK,     -0.004006945267864_REALK,      0.000000000000000_REALK, &
     -0.017332017985224_REALK,      0.000000000000000_REALK,     -0.007756879364795_REALK, &
      0.000000000000000_REALK,      0.015691786587552_REALK,      0.000000000000000_REALK, &
      0.002738861066853_REALK,      0.000000000000000_REALK,     -0.001291973122461_REALK, &
      0.000000000000000_REALK,      0.005069594276269_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.017048165710665_REALK,      0.000000000000000_REALK, &
      0.007749206539333_REALK,      0.000000000000000_REALK,      0.002754559865213_REALK, &
      0.000000000000000_REALK,      0.012496019274804_REALK,      0.000000000000000_REALK, &
     -0.003685311353076_REALK,      0.000000000000000_REALK,     -0.004657493552222_REALK, &
      0.000000000000000_REALK,      0.002624078442172_REALK,      0.000000000000000_REALK, &
     -0.000411422905165_REALK,      0.000000000000000_REALK,      0.006442375171131_REALK, &
     -0.003630847606816_REALK,      0.000000000000000_REALK,     -0.002319878012629_REALK, &
      0.000000000000000_REALK,     -0.000124861677248_REALK,      0.000000000000000_REALK, &
     -0.001591198524177_REALK,      0.000000000000000_REALK,      0.005316857176509_REALK, &
     -0.006371709692687_REALK,      0.000000000000000_REALK,      0.002318140058591_REALK, &
      0.000000000000000_REALK,     -0.014979548651813_REALK,      0.000000000000000_REALK, &
     -0.053727101964240_REALK,      0.000000000000000_REALK,     -0.001017277739017_REALK, &
     -0.006801641737454_REALK,      0.000000000000000_REALK,      0.000824566992042_REALK, &
      0.000000000000000_REALK,     -0.007452360536543_REALK,      0.000000000000000_REALK, &
     -0.043761814546461_REALK,      0.000000000000000_REALK,     -0.017283317876647_REALK, &
      0.000000000000000_REALK,      0.005685066740817_REALK,      0.000000000000000_REALK, &
     -0.071449626865475_REALK,      0.000000000000000_REALK,      0.008242765313071_REALK, &
      0.000000000000000_REALK,      0.035671264761443_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.043988524320484_REALK,      0.000000000000000_REALK, &
     -0.141991319288283_REALK,      0.000000000000000_REALK,      0.010582811370993_REALK, &
      0.000000000000000_REALK,      0.042994358863717_REALK,      0.000000000000000_REALK, &
     -0.001750090123588_REALK,      0.000000000000000_REALK,      0.050818085566629_REALK, &
      0.000000000000000_REALK,      0.016565018570844_REALK,      0.000000000000000_REALK, &
     -0.019614728226239_REALK,      0.000000000000000_REALK,     -0.006382535067758_REALK, &
      0.013916729763870_REALK,      0.000000000000000_REALK,      0.097863827953564_REALK, &
      0.000000000000000_REALK,      0.066863068844392_REALK,      0.000000000000000_REALK, &
     -0.023981041240803_REALK,      0.000000000000000_REALK,     -0.026421697495363_REALK, &
      0.000000000000000_REALK,     -0.012364253426356_REALK,      0.000000000000000_REALK, &
     -0.003088055783598_REALK,      0.000000000000000_REALK,     -0.007678995165662_REALK, &
      0.000000000000000_REALK,      0.005090275097808_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.051211781644840_REALK,      0.000000000000000_REALK, &
     -0.068290938034840_REALK,      0.000000000000000_REALK,     -0.098982755748470_REALK, &
      0.000000000000000_REALK,     -0.006500701392630_REALK,      0.000000000000000_REALK, &
     -0.000723135844394_REALK,      0.000000000000000_REALK,     -0.015305166081251_REALK, &
      0.000000000000000_REALK,     -0.006503429442067_REALK,      0.000000000000000_REALK, &
     -0.012962640638588_REALK,      0.000000000000000_REALK,     -0.000695037996885_REALK, &
     -0.000544492956787_REALK,      0.000000000000000_REALK,      0.018316952658200_REALK, &
      0.000000000000000_REALK,     -0.016769211413331_REALK,      0.000000000000000_REALK, &
     -0.012613614618408_REALK,      0.000000000000000_REALK,      0.004415116664807_REALK, &
      0.000000000000000_REALK,      0.019673860340702_REALK,      0.000000000000000_REALK, &
      0.017136144844487_REALK,      0.000000000000000_REALK,      0.016047347080335_REALK, &
      0.000000000000000_REALK,     -0.010905255268621_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.013509039859690_REALK,      0.000000000000000_REALK, &
      0.090778679490679_REALK,      0.000000000000000_REALK,      0.072346631840913_REALK, &
      0.000000000000000_REALK,     -0.054800632564027_REALK,      0.000000000000000_REALK, &
      0.005581712744033_REALK,      0.000000000000000_REALK,     -0.028386572347741_REALK, &
      0.000000000000000_REALK,      0.000946687999125_REALK,      0.000000000000000_REALK, &
      0.027476251530947_REALK,      0.000000000000000_REALK,     -0.002337764167280_REALK, &
      0.015846978093448_REALK,      0.000000000000000_REALK,      0.050737475887969_REALK, &
      0.000000000000000_REALK,      0.003538710232691_REALK,      0.000000000000000_REALK, &
      0.080211705563675_REALK,      0.000000000000000_REALK,     -0.041862363415737_REALK, &
      0.000000000000000_REALK,     -0.015234243439038_REALK,      0.000000000000000_REALK, &
     -0.005290203014608_REALK,      0.000000000000000_REALK,     -0.006163280351456_REALK, &
      0.000000000000000_REALK,      0.006675952369542_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.008872439869436_REALK,      0.000000000000000_REALK, &
     -0.094796418261469_REALK,      0.000000000000000_REALK,     -0.013614240512628_REALK, &
      0.000000000000000_REALK,      0.095642214049269_REALK,      0.000000000000000_REALK, &
     -0.011153051023821_REALK,      0.000000000000000_REALK,     -0.002020755883854_REALK, &
      0.000000000000000_REALK,     -0.017819339702540_REALK,      0.000000000000000_REALK, &
     -0.060194128692986_REALK,      0.000000000000000_REALK,     -0.000174070081722_REALK, &
     -0.034639445434911_REALK,      0.000000000000000_REALK,      0.022804464851873_REALK, &
      0.000000000000000_REALK,     -0.075302664542914_REALK,      0.000000000000000_REALK, &
     -0.212026607261218_REALK,      0.000000000000000_REALK,      0.005584381864712_REALK, &
      0.000000000000000_REALK,      0.049964186524076_REALK,      0.000000000000000_REALK, &
      0.022451797999712_REALK,      0.000000000000000_REALK,      0.056965633672245_REALK, &
      0.000000000000000_REALK,      0.001561218488995_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.099900635387545_REALK,      0.000000000000000_REALK, &
      0.010630844818864_REALK,      0.000000000000000_REALK,      0.072536018533573_REALK, &
      0.000000000000000_REALK,     -0.001734135339976_REALK,      0.000000000000000_REALK, &
     -0.001332319923939_REALK,      0.000000000000000_REALK,     -0.031299357450932_REALK, &
      0.000000000000000_REALK,     -0.034218902936088_REALK,      0.000000000000000_REALK, &
     -0.004757209700334_REALK,      0.000000000000000_REALK,      0.013894860630219_REALK, &
      0.003092324597174_REALK,      0.000000000000000_REALK,     -0.033570168904023_REALK, &
      0.000000000000000_REALK,     -0.059012489077871_REALK,      0.000000000000000_REALK, &
     -0.025708316188642_REALK,      0.000000000000000_REALK,      0.016219902158713_REALK/
  ! results of test 2, ket-major order, CM000102
  data REF_CONTR_INTS(3565:3960) /                                                         &
     -0.003552385111794_REALK,      0.000000000000000_REALK,     -0.000572437718295_REALK, &
      0.000000000000000_REALK,      0.001643070004215_REALK,      0.000000000000000_REALK, &
     -0.002589526546835_REALK,      0.000000000000000_REALK,     -0.000694835590291_REALK, &
     -0.003640562568807_REALK,      0.000000000000000_REALK,     -0.000813903670664_REALK, &
      0.000000000000000_REALK,      0.001111589629005_REALK,      0.000000000000000_REALK, &
     -0.002256222738856_REALK,      0.000000000000000_REALK,      0.003361261063407_REALK, &
      0.000000000000000_REALK,      0.001996651590142_REALK,      0.000000000000000_REALK, &
     -0.000193220988494_REALK,      0.000000000000000_REALK,     -0.003999522456594_REALK, &
      0.000000000000000_REALK,      0.009032043199362_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.007238718591229_REALK,      0.000000000000000_REALK, &
      0.003386156628422_REALK,      0.000000000000000_REALK,     -0.001895761675858_REALK, &
      0.000000000000000_REALK,      0.013594059635931_REALK,      0.000000000000000_REALK, &
     -0.000092343967076_REALK,      0.000000000000000_REALK,      0.004059175582141_REALK, &
      0.000000000000000_REALK,     -0.002070138587155_REALK,      0.000000000000000_REALK, &
      0.000378072716782_REALK,      0.000000000000000_REALK,     -0.002071433547550_REALK, &
     -0.011972862360616_REALK,      0.000000000000000_REALK,      0.005463099078529_REALK, &
      0.000000000000000_REALK,     -0.000255450293985_REALK,      0.000000000000000_REALK, &
     -0.005284327564317_REALK,      0.000000000000000_REALK,     -0.010214877216864_REALK, &
      0.000000000000000_REALK,      0.001783528475855_REALK,      0.000000000000000_REALK, &
     -0.001244768557952_REALK,      0.000000000000000_REALK,     -0.003377264123385_REALK, &
      0.000000000000000_REALK,      0.001924900550902_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.007812000602443_REALK,      0.000000000000000_REALK, &
      0.003202430030018_REALK,      0.000000000000000_REALK,      0.000017546208531_REALK, &
      0.000000000000000_REALK,      0.009427908838358_REALK,      0.000000000000000_REALK, &
     -0.002814129913968_REALK,      0.000000000000000_REALK,     -0.003011895666778_REALK, &
      0.000000000000000_REALK,      0.003886038256622_REALK,      0.000000000000000_REALK, &
     -0.003513830525697_REALK,      0.000000000000000_REALK,     -0.000617186752460_REALK, &
     -0.002535840539180_REALK,      0.000000000000000_REALK,      0.003310017574511_REALK, &
      0.000000000000000_REALK,      0.000487994073916_REALK,      0.000000000000000_REALK, &
     -0.003284073970877_REALK,      0.000000000000000_REALK,     -0.010811282301105_REALK, &
      0.000000000000000_REALK,     -0.000123815394833_REALK,      0.000000000000000_REALK, &
      0.000707865135097_REALK,      0.000000000000000_REALK,      0.002586879345497_REALK, &
      0.000000000000000_REALK,     -0.001167615213408_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.013179007078343_REALK,      0.000000000000000_REALK, &
      0.000932218622983_REALK,      0.000000000000000_REALK,     -0.000835723216765_REALK, &
      0.000000000000000_REALK,      0.008095199236546_REALK,      0.000000000000000_REALK, &
     -0.002232479896764_REALK,      0.000000000000000_REALK,     -0.003604538432624_REALK, &
      0.000000000000000_REALK,      0.003193588006992_REALK,      0.000000000000000_REALK, &
     -0.002219100292793_REALK,      0.000000000000000_REALK,      0.000721998045035_REALK, &
     -0.005656769548820_REALK,      0.000000000000000_REALK,     -0.006507748014900_REALK, &
      0.000000000000000_REALK,      0.005496174185661_REALK,      0.000000000000000_REALK, &
     -0.001593626995093_REALK,      0.000000000000000_REALK,      0.004237118475543_REALK, &
      0.000000000000000_REALK,      0.000781889166523_REALK,      0.000000000000000_REALK, &
     -0.000103117783945_REALK,      0.000000000000000_REALK,      0.001575803820069_REALK, &
      0.000000000000000_REALK,     -0.002666495028437_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.012305307619941_REALK,      0.000000000000000_REALK, &
     -0.003142565318033_REALK,      0.000000000000000_REALK,     -0.002803663316827_REALK, &
      0.000000000000000_REALK,     -0.001825352947257_REALK,      0.000000000000000_REALK, &
     -0.002570129245680_REALK,      0.000000000000000_REALK,     -0.003433260999159_REALK, &
      0.000000000000000_REALK,      0.004328647054924_REALK,      0.000000000000000_REALK, &
     -0.004432900544945_REALK,      0.000000000000000_REALK,      0.000268030169243_REALK, &
     -0.004815069745850_REALK,      0.000000000000000_REALK,     -0.010437157646191_REALK, &
      0.000000000000000_REALK,      0.011743970370358_REALK,      0.000000000000000_REALK, &
     -0.008178170117996_REALK,      0.000000000000000_REALK,      0.002246045052178_REALK, &
      0.000000000000000_REALK,      0.007552986995427_REALK,      0.000000000000000_REALK, &
     -0.001928330353942_REALK,      0.000000000000000_REALK,     -0.001317072985679_REALK, &
      0.000000000000000_REALK,     -0.000925921884587_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.005179660957774_REALK,      0.000000000000000_REALK, &
     -0.000381281934432_REALK,      0.000000000000000_REALK,      0.006397885354903_REALK, &
      0.000000000000000_REALK,     -0.009770861473372_REALK,      0.000000000000000_REALK, &
      0.000266114248431_REALK,      0.000000000000000_REALK,     -0.002208951855526_REALK, &
      0.000000000000000_REALK,      0.001028225908480_REALK,      0.000000000000000_REALK, &
     -0.000304421473155_REALK,      0.000000000000000_REALK,      0.004089889094261_REALK, &
      0.000254071753112_REALK,      0.000000000000000_REALK,     -0.001775552543172_REALK, &
      0.000000000000000_REALK,     -0.000138338118689_REALK,      0.000000000000000_REALK, &
      0.002129400484191_REALK,      0.000000000000000_REALK,      0.003040171126430_REALK, &
     -0.003860225450683_REALK,      0.000000000000000_REALK,      0.011995092499198_REALK, &
      0.000000000000000_REALK,      0.008910984878483_REALK,      0.000000000000000_REALK, &
     -0.025550966693536_REALK,      0.000000000000000_REALK,     -0.001385849049035_REALK, &
     -0.017242824143884_REALK,      0.000000000000000_REALK,      0.006068567887872_REALK, &
      0.000000000000000_REALK,     -0.007261305863354_REALK,      0.000000000000000_REALK, &
     -0.016511523238450_REALK,      0.000000000000000_REALK,      0.011350392610012_REALK, &
      0.000000000000000_REALK,     -0.017784313036637_REALK,      0.000000000000000_REALK, &
     -0.027357902739253_REALK,      0.000000000000000_REALK,      0.003286521898589_REALK, &
      0.000000000000000_REALK,      0.027424872888336_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.006754243924140_REALK,      0.000000000000000_REALK, &
     -0.022662110079129_REALK,      0.000000000000000_REALK,      0.040622837874125_REALK, &
      0.000000000000000_REALK,      0.037840859262824_REALK,      0.000000000000000_REALK, &
      0.000642247030783_REALK,      0.000000000000000_REALK,      0.022396851346201_REALK, &
      0.000000000000000_REALK,      0.019065246728784_REALK,      0.000000000000000_REALK, &
     -0.000805264170888_REALK,      0.000000000000000_REALK,     -0.004356477831245_REALK, &
     -0.006929812559370_REALK,      0.000000000000000_REALK,      0.062242952934909_REALK, &
      0.000000000000000_REALK,      0.067108092694726_REALK,      0.000000000000000_REALK, &
     -0.076447903490127_REALK,      0.000000000000000_REALK,     -0.022814758451647_REALK, &
      0.000000000000000_REALK,     -0.011767337448582_REALK,      0.000000000000000_REALK, &
     -0.006081327384692_REALK,      0.000000000000000_REALK,     -0.003360293334500_REALK, &
      0.000000000000000_REALK,      0.005112381896806_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.033332478414795_REALK,      0.000000000000000_REALK, &
     -0.028844824705634_REALK,      0.000000000000000_REALK,     -0.072035487564725_REALK, &
      0.000000000000000_REALK,      0.010712763434769_REALK,      0.000000000000000_REALK, &
     -0.000557384061226_REALK,      0.000000000000000_REALK,      0.000910012888352_REALK, &
      0.000000000000000_REALK,      0.002725372448452_REALK,      0.000000000000000_REALK, &
     -0.029445546363684_REALK,      0.000000000000000_REALK,     -0.004991269627526_REALK, &
      0.021738944492671_REALK,      0.000000000000000_REALK,      0.058825451413313_REALK, &
      0.000000000000000_REALK,      0.015251197585531_REALK,      0.000000000000000_REALK, &
     -0.046591399135085_REALK,      0.000000000000000_REALK,     -0.032293119818652_REALK, &
      0.000000000000000_REALK,      0.012025184862792_REALK,      0.000000000000000_REALK, &
      0.003795001441728_REALK,      0.000000000000000_REALK,      0.012759305603426_REALK, &
      0.000000000000000_REALK,     -0.001998686373614_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.043495840199532_REALK,      0.000000000000000_REALK, &
      0.009797333192321_REALK,      0.000000000000000_REALK,      0.070637099866006_REALK, &
      0.000000000000000_REALK,      0.044592909289257_REALK,      0.000000000000000_REALK, &
     -0.001619883543062_REALK,      0.000000000000000_REALK,     -0.008378833789979_REALK, &
      0.000000000000000_REALK,     -0.008550648487548_REALK,      0.000000000000000_REALK, &
     -0.015148576613213_REALK,      0.000000000000000_REALK,     -0.000420701987149_REALK, &
     -0.003248067664999_REALK,      0.000000000000000_REALK,     -0.001172018275709_REALK, &
      0.000000000000000_REALK,     -0.012844490204396_REALK,      0.000000000000000_REALK, &
     -0.021746164524885_REALK,      0.000000000000000_REALK,      0.014208289359792_REALK, &
      0.000000000000000_REALK,      0.012846001656915_REALK,      0.000000000000000_REALK, &
      0.003683498720166_REALK,      0.000000000000000_REALK,      0.004947857773350_REALK, &
      0.000000000000000_REALK,     -0.004799712198080_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.046209785056072_REALK,      0.000000000000000_REALK, &
     -0.005108783859019_REALK,      0.000000000000000_REALK,      0.041206907745287_REALK, &
      0.000000000000000_REALK,      0.017838704068104_REALK,      0.000000000000000_REALK, &
     -0.003043629683861_REALK,      0.000000000000000_REALK,     -0.002524956384123_REALK, &
      0.000000000000000_REALK,      0.005631370715989_REALK,      0.000000000000000_REALK, &
     -0.037413606259853_REALK,      0.000000000000000_REALK,     -0.004418908112272_REALK, &
     -0.003282584430990_REALK,      0.000000000000000_REALK,     -0.006095708046403_REALK, &
      0.000000000000000_REALK,      0.031322036084711_REALK,      0.000000000000000_REALK, &
     -0.083699943896422_REALK,      0.000000000000000_REALK,     -0.006737440466659_REALK, &
      0.000000000000000_REALK,      0.013334232614494_REALK,      0.000000000000000_REALK, &
     -0.005467190206922_REALK,      0.000000000000000_REALK,      0.050187659587795_REALK, &
      0.000000000000000_REALK,      0.002783040824778_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.042155601040229_REALK,      0.000000000000000_REALK, &
     -0.007791395812197_REALK,      0.000000000000000_REALK,      0.091591226859500_REALK, &
      0.000000000000000_REALK,     -0.034687485781227_REALK,      0.000000000000000_REALK, &
     -0.007703962699889_REALK,      0.000000000000000_REALK,     -0.021508454037213_REALK, &
      0.000000000000000_REALK,     -0.023606017661544_REALK,      0.000000000000000_REALK, &
      0.005336491290106_REALK,      0.000000000000000_REALK,      0.002829394132788_REALK, &
     -0.009734120330516_REALK,      0.000000000000000_REALK,     -0.031014511754121_REALK, &
      0.000000000000000_REALK,     -0.033496452820075_REALK,      0.000000000000000_REALK, &
      0.025493425374577_REALK,      0.000000000000000_REALK,     -0.001676979559996_REALK/
  ! results of test 2, ket-major order, CM000003
  data REF_CONTR_INTS(3961:4356) /                                                         &
      0.000000000000000_REALK,      0.003271006626310_REALK,      0.000000000000000_REALK, &
      0.000713365777125_REALK,      0.000000000000000_REALK,     -0.000321366557419_REALK, &
      0.000000000000000_REALK,      0.005603900340011_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.001327403945458_REALK,      0.000000000000000_REALK, &
     -0.001060490003766_REALK,      0.000000000000000_REALK,      0.001305301356079_REALK, &
      0.000000000000000_REALK,      0.001664956097831_REALK,      0.000000000000000_REALK, &
     -0.004930607194196_REALK,      0.000000000000000_REALK,      0.005742308316762_REALK, &
      0.000000000000000_REALK,     -0.002453651206422_REALK,      0.000000000000000_REALK, &
     -0.005318179260353_REALK,      0.000000000000000_REALK,     -0.006731101246288_REALK, &
     -0.002330573002940_REALK,      0.000000000000000_REALK,      0.006340871673141_REALK, &
      0.000000000000000_REALK,      0.000303974605497_REALK,      0.000000000000000_REALK, &
     -0.010078515347036_REALK,      0.000000000000000_REALK,     -0.007994194704257_REALK, &
      0.000000000000000_REALK,     -0.008362581802184_REALK,      0.000000000000000_REALK, &
      0.000663823919038_REALK,      0.000000000000000_REALK,     -0.000022622543664_REALK, &
      0.000000000000000_REALK,      0.008829509307405_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.013336916399295_REALK,      0.000000000000000_REALK, &
     -0.008235552921878_REALK,      0.000000000000000_REALK,     -0.012422312803078_REALK, &
      0.000000000000000_REALK,      0.021730461078726_REALK,      0.000000000000000_REALK, &
      0.000801832980670_REALK,      0.000000000000000_REALK,      0.004070355962678_REALK, &
      0.000000000000000_REALK,     -0.002201108454357_REALK,      0.000000000000000_REALK, &
      0.001369029603707_REALK,      0.000000000000000_REALK,     -0.001567296514956_REALK, &
      0.013123883160337_REALK,      0.000000000000000_REALK,      0.030662060795724_REALK, &
      0.000000000000000_REALK,     -0.020017744364426_REALK,      0.000000000000000_REALK, &
      0.014674001744051_REALK,      0.000000000000000_REALK,     -0.009589305298451_REALK, &
      0.000000000000000_REALK,      0.006119659375147_REALK,      0.000000000000000_REALK, &
     -0.000988453129651_REALK,      0.000000000000000_REALK,     -0.002523014303568_REALK, &
      0.000000000000000_REALK,      0.001261022133652_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.020518110850601_REALK,      0.000000000000000_REALK, &
      0.001606502764249_REALK,      0.000000000000000_REALK,     -0.000835959300525_REALK, &
      0.000000000000000_REALK,      0.002863828210458_REALK,      0.000000000000000_REALK, &
     -0.001213473563947_REALK,      0.000000000000000_REALK,     -0.005026061125915_REALK, &
      0.000000000000000_REALK,      0.003435829180701_REALK,      0.000000000000000_REALK, &
     -0.001299830680761_REALK,      0.000000000000000_REALK,      0.002189158687215_REALK, &
      0.001142880941944_REALK,      0.000000000000000_REALK,     -0.012682955686449_REALK, &
      0.000000000000000_REALK,      0.013046456327336_REALK,      0.000000000000000_REALK, &
     -0.003280042663823_REALK,      0.000000000000000_REALK,     -0.002061806550092_REALK, &
      0.000000000000000_REALK,      0.004988944863143_REALK,      0.000000000000000_REALK, &
     -0.002523014303568_REALK,      0.000000000000000_REALK,     -0.002293447763667_REALK, &
      0.000000000000000_REALK,     -0.005155550857979_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.022040483768415_REALK,      0.000000000000000_REALK, &
     -0.000835959300525_REALK,      0.000000000000000_REALK,      0.001174114251866_REALK, &
      0.000000000000000_REALK,      0.014077403508926_REALK,      0.000000000000000_REALK, &
      0.000418598212829_REALK,      0.000000000000000_REALK,      0.001369029603707_REALK, &
      0.000000000000000_REALK,     -0.000569246618571_REALK,      0.000000000000000_REALK, &
     -0.000869221031917_REALK,      0.000000000000000_REALK,     -0.000288244540086_REALK, &
     -0.021247002758771_REALK,      0.000000000000000_REALK,      0.014674001744051_REALK, &
      0.000000000000000_REALK,     -0.005176952216191_REALK,      0.000000000000000_REALK, &
     -0.022283004261504_REALK,      0.000000000000000_REALK,     -0.016138775428127_REALK, &
      0.000000000000000_REALK,      0.008829509307405_REALK,      0.000000000000000_REALK, &
      0.000889276723758_REALK,      0.000000000000000_REALK,     -0.000899657629743_REALK, &
      0.000000000000000_REALK,      0.008395255477609_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.021730461078726_REALK,      0.000000000000000_REALK, &
      0.005921942704773_REALK,      0.000000000000000_REALK,      0.003491395314665_REALK, &
      0.000000000000000_REALK,      0.027906092480799_REALK,      0.000000000000000_REALK, &
     -0.006731101246288_REALK,      0.000000000000000_REALK,     -0.006470111114541_REALK, &
      0.000000000000000_REALK,      0.004426492684738_REALK,      0.000000000000000_REALK, &
     -0.005444397820111_REALK,      0.000000000000000_REALK,      0.003481470148904_REALK, &
     -0.007994194704257_REALK,      0.000000000000000_REALK,     -0.004740073514555_REALK, &
      0.000000000000000_REALK,     -0.000548383308946_REALK,      0.000000000000000_REALK, &
     -0.007721489677475_REALK,      0.000000000000000_REALK,      0.007660033539354_REALK, &
      0.000000000000000_REALK,      0.004344196486534_REALK,      0.000000000000000_REALK, &
      0.000633869097980_REALK,      0.000000000000000_REALK,      0.001009920576600_REALK, &
      0.000000000000000_REALK,     -0.002945224333497_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.003232357177314_REALK,      0.000000000000000_REALK, &
      0.001722103717619_REALK,      0.000000000000000_REALK,      0.001812419454662_REALK, &
      0.000000000000000_REALK,     -0.001732762328718_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.009551980770612_REALK,      0.000000000000000_REALK, &
     -0.023023465977187_REALK,      0.000000000000000_REALK,      0.022768378790088_REALK, &
      0.000000000000000_REALK,      0.012637270890066_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.007066271105095_REALK,      0.000000000000000_REALK, &
     -0.046762459049219_REALK,      0.000000000000000_REALK,      0.039684225246510_REALK, &
      0.000000000000000_REALK,      0.000760976599900_REALK,      0.000000000000000_REALK, &
     -0.003063646059726_REALK,      0.000000000000000_REALK,      0.037239165210734_REALK, &
      0.000000000000000_REALK,      0.017110368238234_REALK,      0.000000000000000_REALK, &
     -0.061576924018028_REALK,      0.000000000000000_REALK,     -0.009024452967442_REALK, &
      0.002402507274635_REALK,      0.000000000000000_REALK,      0.066317663488233_REALK, &
      0.000000000000000_REALK,      0.062529458105609_REALK,      0.000000000000000_REALK, &
     -0.112009614877040_REALK,      0.000000000000000_REALK,     -0.023801024204469_REALK, &
      0.000000000000000_REALK,     -0.013880000901746_REALK,      0.000000000000000_REALK, &
     -0.050266545920917_REALK,      0.000000000000000_REALK,     -0.041315432802222_REALK, &
      0.000000000000000_REALK,      0.022408475723535_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.074757829918469_REALK,      0.000000000000000_REALK, &
     -0.171960091061206_REALK,      0.000000000000000_REALK,     -0.118669718219614_REALK, &
      0.000000000000000_REALK,      0.094430648222159_REALK,      0.000000000000000_REALK, &
      0.003503692920006_REALK,      0.000000000000000_REALK,      0.026213307659618_REALK, &
      0.000000000000000_REALK,     -0.002879198227766_REALK,      0.000000000000000_REALK, &
      0.005956713515108_REALK,      0.000000000000000_REALK,     -0.003296744866455_REALK, &
      0.030286473954962_REALK,      0.000000000000000_REALK,      0.171274373236044_REALK, &
      0.000000000000000_REALK,      0.009453504240886_REALK,      0.000000000000000_REALK, &
      0.103993211366623_REALK,      0.000000000000000_REALK,     -0.014430174066945_REALK, &
      0.000000000000000_REALK,      0.002507326608880_REALK,      0.000000000000000_REALK, &
      0.013762471970673_REALK,      0.000000000000000_REALK,      0.032412402472672_REALK, &
      0.000000000000000_REALK,      0.010087415415274_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.098836256811954_REALK,      0.000000000000000_REALK, &
     -0.017661936634588_REALK,      0.000000000000000_REALK,     -0.026692356754169_REALK, &
      0.000000000000000_REALK,      0.017716254347993_REALK,      0.000000000000000_REALK, &
     -0.002204848267081_REALK,      0.000000000000000_REALK,     -0.028388405237002_REALK, &
      0.000000000000000_REALK,      0.000016876793108_REALK,      0.000000000000000_REALK, &
     -0.007341757129590_REALK,      0.000000000000000_REALK,      0.003977641442943_REALK, &
      0.014386013089678_REALK,      0.000000000000000_REALK,     -0.078239598215403_REALK, &
      0.000000000000000_REALK,      0.015300616400079_REALK,      0.000000000000000_REALK, &
     -0.020234180934738_REALK,      0.000000000000000_REALK,     -0.025952988565505_REALK, &
      0.000000000000000_REALK,     -0.005126721805748_REALK,      0.000000000000000_REALK, &
      0.032412402472672_REALK,      0.000000000000000_REALK,      0.030527343752249_REALK, &
      0.000000000000000_REALK,     -0.006441978783966_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.109107420342180_REALK,      0.000000000000000_REALK, &
     -0.026692356754169_REALK,      0.000000000000000_REALK,     -0.031468193017743_REALK, &
      0.000000000000000_REALK,      0.066037351410824_REALK,      0.000000000000000_REALK, &
     -0.004383697843813_REALK,      0.000000000000000_REALK,      0.005956713515108_REALK, &
      0.000000000000000_REALK,     -0.000744612948129_REALK,      0.000000000000000_REALK, &
      0.004720971071030_REALK,      0.000000000000000_REALK,     -0.003784798699088_REALK, &
     -0.062500625561603_REALK,      0.000000000000000_REALK,      0.103993211366623_REALK, &
      0.000000000000000_REALK,      0.002444847872950_REALK,      0.000000000000000_REALK, &
     -0.203942110811868_REALK,      0.000000000000000_REALK,     -0.042718365674032_REALK, &
      0.000000000000000_REALK,      0.022408475723535_REALK,      0.000000000000000_REALK, &
     -0.009908825401782_REALK,      0.000000000000000_REALK,      0.042144226901114_REALK, &
      0.000000000000000_REALK,      0.028649835897709_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.094430648222159_REALK,      0.000000000000000_REALK, &
     -0.064153707775345_REALK,      0.000000000000000_REALK,      0.157861260745993_REALK, &
      0.000000000000000_REALK,      0.104465429499267_REALK,      0.000000000000000_REALK, &
     -0.009024452967442_REALK,      0.000000000000000_REALK,     -0.026473259827877_REALK, &
      0.000000000000000_REALK,     -0.030867842846402_REALK,      0.000000000000000_REALK, &
     -0.046317610255151_REALK,      0.000000000000000_REALK,      0.008214507924833_REALK, &
     -0.023801024204469_REALK,      0.000000000000000_REALK,     -0.045801753430381_REALK, &
      0.000000000000000_REALK,     -0.112805841417348_REALK,      0.000000000000000_REALK, &
     -0.083440218797445_REALK,      0.000000000000000_REALK,      0.032147425546873_REALK, &
      0.000000000000000_REALK,      0.021676908327767_REALK,      0.000000000000000_REALK, &
      0.019454025428027_REALK,      0.000000000000000_REALK,      0.017044229452695_REALK, &
      0.000000000000000_REALK,     -0.011889795172410_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.036751665994833_REALK,      0.000000000000000_REALK, &
      0.018391571856523_REALK,      0.000000000000000_REALK,      0.008349593266685_REALK, &
      0.000000000000000_REALK,     -0.016374116975904_REALK,      0.000000000000000_REALK/
  ! results of test 3, ket-major order, 1DOVL001
  data REF_CONTR_INTS(4357:4752) /                                                         &
      0.266923705412279_REALK,      0.000000000000000_REALK,     -0.027890755869561_REALK, &
      0.000000000000000_REALK,     -0.040950697864850_REALK,      0.000000000000000_REALK, &
      0.046554579007678_REALK,      0.000000000000000_REALK,     -0.359884862997085_REALK, &
      0.017872340907200_REALK,      0.000000000000000_REALK,      0.016987604978031_REALK, &
      0.000000000000000_REALK,     -0.011222829469930_REALK,      0.000000000000000_REALK, &
      0.063591204908042_REALK,      0.000000000000000_REALK,     -0.155189018516716_REALK, &
      0.000000000000000_REALK,     -0.262679404603372_REALK,      0.000000000000000_REALK, &
     -0.029704712312351_REALK,      0.000000000000000_REALK,      0.129820767198447_REALK, &
      0.000000000000000_REALK,     -0.278172623791831_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.114499955930671_REALK,      0.000000000000000_REALK, &
      0.044777330434753_REALK,      0.000000000000000_REALK,     -0.035372297931612_REALK, &
      0.000000000000000_REALK,      0.027155726221655_REALK,      0.000000000000000_REALK, &
     -0.079904923396842_REALK,      0.000000000000000_REALK,     -0.095687333145286_REALK, &
      0.000000000000000_REALK,      0.033637962344327_REALK,      0.000000000000000_REALK, &
      0.149827065855015_REALK,      0.000000000000000_REALK,      0.015913966968947_REALK, &
      0.033385581745565_REALK,      0.000000000000000_REALK,     -0.007085287738772_REALK, &
      0.000000000000000_REALK,     -0.065847375971192_REALK,      0.000000000000000_REALK, &
      0.131534523403374_REALK,      0.000000000000000_REALK,      0.013568539905119_REALK, &
      0.000000000000000_REALK,     -0.000750980722374_REALK,      0.000000000000000_REALK, &
      0.089102807570017_REALK,      0.000000000000000_REALK,      0.071142740400548_REALK, &
      0.000000000000000_REALK,      0.065430918071202_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.053912279940686_REALK,      0.000000000000000_REALK, &
      0.019281813724385_REALK,      0.000000000000000_REALK,     -0.014714806205260_REALK, &
      0.000000000000000_REALK,      0.002386924848429_REALK,      0.000000000000000_REALK, &
      0.029402544521619_REALK,      0.000000000000000_REALK,      0.103829528822969_REALK, &
      0.000000000000000_REALK,     -0.119945600365518_REALK,      0.000000000000000_REALK, &
      0.053862218892226_REALK,      0.000000000000000_REALK,     -0.042296330249361_REALK, &
      0.004134284218545_REALK,      0.000000000000000_REALK,     -0.019141583964691_REALK, &
      0.000000000000000_REALK,     -0.006904376310866_REALK,      0.000000000000000_REALK, &
      0.008532980224226_REALK,      0.000000000000000_REALK,      0.008393137363237_REALK, &
      0.000000000000000_REALK,     -0.052392559772688_REALK,      0.000000000000000_REALK, &
     -0.088092420314111_REALK,      0.000000000000000_REALK,     -0.072211640864250_REALK, &
      0.000000000000000_REALK,     -0.007794562870140_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.049344086541291_REALK,      0.000000000000000_REALK, &
     -0.021381820419342_REALK,      0.000000000000000_REALK,     -0.004500114203810_REALK, &
      0.000000000000000_REALK,      0.053518706239223_REALK,      0.000000000000000_REALK, &
      0.022009353063383_REALK,      0.000000000000000_REALK,      0.094889931688547_REALK, &
      0.000000000000000_REALK,     -0.110349893145570_REALK,      0.000000000000000_REALK, &
     -0.079899495116732_REALK,      0.000000000000000_REALK,     -0.081261795578802_REALK, &
     -0.043784310713606_REALK,      0.000000000000000_REALK,     -0.062827469753346_REALK, &
      0.000000000000000_REALK,      0.019349533093988_REALK,      0.000000000000000_REALK, &
     -0.068384421516178_REALK,      0.000000000000000_REALK,      0.017695470663138_REALK, &
      0.000000000000000_REALK,      0.153253164275562_REALK,      0.000000000000000_REALK, &
      0.052655701980762_REALK,      0.000000000000000_REALK,     -0.096102426931858_REALK, &
      0.000000000000000_REALK,      0.109340127718411_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.004515832181080_REALK,      0.000000000000000_REALK, &
      0.019453369183892_REALK,      0.000000000000000_REALK,     -0.059744132296878_REALK, &
      0.000000000000000_REALK,     -0.071707712651228_REALK,      0.000000000000000_REALK, &
      0.007673069075851_REALK,      0.000000000000000_REALK,      0.111056467134271_REALK, &
      0.000000000000000_REALK,     -0.065291927805443_REALK,      0.000000000000000_REALK, &
      0.146714425362068_REALK,      0.000000000000000_REALK,      0.079563305797438_REALK, &
      0.052043699066469_REALK,      0.000000000000000_REALK,      0.082420956053712_REALK, &
      0.000000000000000_REALK,      0.021686144854974_REALK,      0.000000000000000_REALK, &
      0.052991296703704_REALK,      0.000000000000000_REALK,      0.004761557609857_REALK, &
      0.000000000000000_REALK,     -0.205462751021305_REALK,      0.000000000000000_REALK, &
      0.000393608332111_REALK,      0.000000000000000_REALK,     -0.028513019639788_REALK, &
      0.000000000000000_REALK,      0.182065378416091_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.039350224511548_REALK,      0.000000000000000_REALK, &
     -0.038549028878923_REALK,      0.000000000000000_REALK,     -0.099482449113681_REALK, &
      0.000000000000000_REALK,      0.200965072367411_REALK,      0.000000000000000_REALK, &
     -0.305907500467742_REALK,      0.000000000000000_REALK,      0.059116340588066_REALK, &
      0.000000000000000_REALK,     -0.081559688324868_REALK,      0.000000000000000_REALK, &
      0.058663957880079_REALK,      0.000000000000000_REALK,     -0.338568754305416_REALK, &
     -0.163053906417852_REALK,      0.000000000000000_REALK,      0.005012997029676_REALK, &
      0.000000000000000_REALK,      0.038817352038487_REALK,      0.000000000000000_REALK, &
     -0.065365776141699_REALK,      0.000000000000000_REALK,      0.008284652259266_REALK, &
      0.037518221242093_REALK,      0.000000000000000_REALK,      0.034438248837846_REALK, &
      0.000000000000000_REALK,     -0.033972640185296_REALK,      0.000000000000000_REALK, &
      0.161964106236714_REALK,      0.000000000000000_REALK,     -0.392175351282081_REALK, &
      0.156510986396623_REALK,      0.000000000000000_REALK,      0.116821313853568_REALK, &
      0.000000000000000_REALK,      0.068595469419345_REALK,      0.000000000000000_REALK, &
     -0.029517988847773_REALK,      0.000000000000000_REALK,     -0.107593325904448_REALK, &
      0.000000000000000_REALK,     -0.282975530154336_REALK,      0.000000000000000_REALK, &
      0.101202792614176_REALK,      0.000000000000000_REALK,     -0.055568282920905_REALK, &
      0.000000000000000_REALK,      0.036360885179511_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.206929444465883_REALK,      0.000000000000000_REALK, &
      0.135014061218469_REALK,      0.000000000000000_REALK,     -0.391305961293784_REALK, &
      0.000000000000000_REALK,      0.273193368190327_REALK,      0.000000000000000_REALK, &
      0.076265352202248_REALK,      0.000000000000000_REALK,     -0.024378476495390_REALK, &
      0.000000000000000_REALK,     -0.142219218875322_REALK,      0.000000000000000_REALK, &
      0.304053307370285_REALK,      0.000000000000000_REALK,      0.033719995147471_REALK, &
      0.046683392405504_REALK,      0.000000000000000_REALK,      0.051350789399852_REALK, &
      0.000000000000000_REALK,     -0.281699236014113_REALK,      0.000000000000000_REALK, &
      0.381354324939051_REALK,      0.000000000000000_REALK,      0.043600125676722_REALK, &
      0.000000000000000_REALK,      0.136712061049800_REALK,      0.000000000000000_REALK, &
      0.039774020041487_REALK,      0.000000000000000_REALK,     -0.038895636137997_REALK, &
      0.000000000000000_REALK,      0.005708515905883_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.023823021634371_REALK,      0.000000000000000_REALK, &
      0.144124333682990_REALK,      0.000000000000000_REALK,      0.023401962596882_REALK, &
      0.000000000000000_REALK,      0.020043573797916_REALK,      0.000000000000000_REALK, &
      0.013558492912436_REALK,      0.000000000000000_REALK,     -0.031877410439798_REALK, &
      0.000000000000000_REALK,     -0.025904426415366_REALK,      0.000000000000000_REALK, &
      0.024960158130108_REALK,      0.000000000000000_REALK,      0.015688661016197_REALK, &
     -0.019644722764756_REALK,      0.000000000000000_REALK,     -0.175444887684224_REALK, &
      0.000000000000000_REALK,      0.050939168883393_REALK,      0.000000000000000_REALK, &
     -0.037567140187790_REALK,      0.000000000000000_REALK,      0.029211371355019_REALK, &
      0.000000000000000_REALK,     -0.129552055405002_REALK,      0.000000000000000_REALK, &
     -0.048679234552097_REALK,      0.000000000000000_REALK,     -0.008957695772100_REALK, &
      0.000000000000000_REALK,      0.124906589069321_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.071291427169428_REALK,      0.000000000000000_REALK, &
     -0.079077296462281_REALK,      0.000000000000000_REALK,     -0.023008229415483_REALK, &
      0.000000000000000_REALK,      0.099777853693470_REALK,      0.000000000000000_REALK, &
     -0.102721697436690_REALK,      0.000000000000000_REALK,     -0.128986025923035_REALK, &
      0.000000000000000_REALK,      0.033939535940256_REALK,      0.000000000000000_REALK, &
     -0.161749094581387_REALK,      0.000000000000000_REALK,      0.030070956705191_REALK, &
     -0.053594178197192_REALK,      0.000000000000000_REALK,     -0.340138174817934_REALK, &
      0.000000000000000_REALK,      0.125918708763147_REALK,      0.000000000000000_REALK, &
     -0.118149767087870_REALK,      0.000000000000000_REALK,      0.120770197954257_REALK, &
      0.000000000000000_REALK,      0.031961386752765_REALK,      0.000000000000000_REALK, &
      0.044238517609506_REALK,      0.000000000000000_REALK,     -0.141342372359368_REALK, &
      0.000000000000000_REALK,     -0.151776601520854_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.217528347568604_REALK,      0.000000000000000_REALK, &
      0.089357232978504_REALK,      0.000000000000000_REALK,     -0.195341507531070_REALK, &
      0.000000000000000_REALK,     -0.292256714683161_REALK,      0.000000000000000_REALK, &
      0.130313629139571_REALK,      0.000000000000000_REALK,      0.189717751733822_REALK, &
      0.000000000000000_REALK,      0.038498396506135_REALK,      0.000000000000000_REALK, &
      0.134052498894732_REALK,      0.000000000000000_REALK,      0.024127872766240_REALK, &
      0.000290260981437_REALK,      0.000000000000000_REALK,      0.293107746998212_REALK, &
      0.000000000000000_REALK,      0.222877740723575_REALK,      0.000000000000000_REALK, &
     -0.019997577945709_REALK,      0.000000000000000_REALK,     -0.143378786580104_REALK, &
      0.000000000000000_REALK,     -0.098555148789816_REALK,      0.000000000000000_REALK, &
     -0.094348311145522_REALK,      0.000000000000000_REALK,     -0.240895883187504_REALK, &
      0.000000000000000_REALK,      0.464022775976619_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.050083980613176_REALK,      0.000000000000000_REALK, &
     -0.041259538693190_REALK,      0.000000000000000_REALK,     -0.076346541545266_REALK, &
      0.000000000000000_REALK,      0.535094223483070_REALK,      0.000000000000000_REALK, &
     -0.383253961486073_REALK,      0.000000000000000_REALK,      0.014909101646956_REALK, &
      0.000000000000000_REALK,      0.080553868366866_REALK,      0.000000000000000_REALK, &
     -0.144704565593863_REALK,      0.000000000000000_REALK,     -0.010276287028979_REALK, &
     -0.454847657841651_REALK,      0.000000000000000_REALK,      0.036318595642620_REALK, &
      0.000000000000000_REALK,      0.145455592963228_REALK,      0.000000000000000_REALK, &
     -0.201361809240887_REALK,      0.000000000000000_REALK,      0.266738999776154_REALK/
  ! results of test 3, ket-major order, 1DOVL002
  data REF_CONTR_INTS(4753:5148) /                                                         &
     -0.090814369625795_REALK,      0.000000000000000_REALK,      0.033902330115830_REALK, &
      0.000000000000000_REALK,      0.025598789094933_REALK,      0.000000000000000_REALK, &
      0.034356480303109_REALK,      0.000000000000000_REALK,      0.528781378778865_REALK, &
     -0.100283848390972_REALK,      0.000000000000000_REALK,     -0.057880739293964_REALK, &
      0.000000000000000_REALK,      0.026014520116425_REALK,      0.000000000000000_REALK, &
      0.048741979336563_REALK,      0.000000000000000_REALK,      0.180389239901962_REALK, &
      0.000000000000000_REALK,      0.296029679845542_REALK,      0.000000000000000_REALK, &
     -0.040916258649342_REALK,      0.000000000000000_REALK,     -0.029704712312351_REALK, &
      0.000000000000000_REALK,     -0.157930226071824_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.234952237060658_REALK,      0.000000000000000_REALK, &
      0.089212139068105_REALK,      0.000000000000000_REALK,      0.044777330434753_REALK, &
      0.000000000000000_REALK,      0.053920378351878_REALK,      0.000000000000000_REALK, &
      0.094775581604103_REALK,      0.000000000000000_REALK,     -0.109179150494494_REALK, &
      0.000000000000000_REALK,      0.064136520564888_REALK,      0.000000000000000_REALK, &
     -0.109100874300936_REALK,      0.000000000000000_REALK,      0.023346248411419_REALK, &
     -0.005705667305763_REALK,      0.000000000000000_REALK,     -0.030492266805699_REALK, &
      0.000000000000000_REALK,     -0.046036444325121_REALK,      0.000000000000000_REALK, &
     -0.113468544992181_REALK,      0.000000000000000_REALK,      0.012650428941709_REALK, &
      0.000000000000000_REALK,     -0.030039480599330_REALK,      0.000000000000000_REALK, &
     -0.034168663560976_REALK,      0.000000000000000_REALK,      0.089102807570017_REALK, &
      0.000000000000000_REALK,     -0.150475380812365_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.045622507344164_REALK,      0.000000000000000_REALK, &
     -0.053621544573043_REALK,      0.000000000000000_REALK,      0.019281813724385_REALK, &
      0.000000000000000_REALK,     -0.014352801185518_REALK,      0.000000000000000_REALK, &
      0.044399870566668_REALK,      0.000000000000000_REALK,     -0.012834506095905_REALK, &
      0.000000000000000_REALK,     -0.048309672196585_REALK,      0.000000000000000_REALK, &
      0.101120518306900_REALK,      0.000000000000000_REALK,     -0.038543310309181_REALK, &
      0.009533617111689_REALK,      0.000000000000000_REALK,     -0.079893430201798_REALK, &
      0.000000000000000_REALK,      0.022920727289821_REALK,      0.000000000000000_REALK, &
      0.031474204966874_REALK,      0.000000000000000_REALK,      0.044094258977032_REALK, &
      0.000000000000000_REALK,     -0.017861612541325_REALK,      0.000000000000000_REALK, &
     -0.026647041549531_REALK,      0.000000000000000_REALK,     -0.088092420314111_REALK, &
      0.000000000000000_REALK,      0.046812288815508_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.062420783236996_REALK,      0.000000000000000_REALK, &
      0.006559339907596_REALK,      0.000000000000000_REALK,     -0.021381820419342_REALK, &
      0.000000000000000_REALK,     -0.014922385468500_REALK,      0.000000000000000_REALK, &
      0.029402544521619_REALK,      0.000000000000000_REALK,      0.103829528822969_REALK, &
      0.000000000000000_REALK,     -0.119945600365518_REALK,      0.000000000000000_REALK, &
      0.053862218892226_REALK,      0.000000000000000_REALK,     -0.042296330249361_REALK, &
      0.004134284218545_REALK,      0.000000000000000_REALK,     -0.019141583964691_REALK, &
      0.000000000000000_REALK,     -0.006904376310866_REALK,      0.000000000000000_REALK, &
      0.008532980224226_REALK,      0.000000000000000_REALK,      0.008393137363237_REALK, &
      0.000000000000000_REALK,     -0.087311089268725_REALK,      0.000000000000000_REALK, &
      0.105664594654231_REALK,      0.000000000000000_REALK,      0.052655701980762_REALK, &
      0.000000000000000_REALK,      0.117861726803690_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.033249382090701_REALK,      0.000000000000000_REALK, &
      0.042071110992997_REALK,      0.000000000000000_REALK,      0.019453369183892_REALK, &
      0.000000000000000_REALK,     -0.043493600011512_REALK,      0.000000000000000_REALK, &
      0.027267122512817_REALK,      0.000000000000000_REALK,     -0.140074404706119_REALK, &
      0.000000000000000_REALK,      0.038105580705936_REALK,      0.000000000000000_REALK, &
      0.147949749215238_REALK,      0.000000000000000_REALK,     -0.103016479497200_REALK, &
      0.030896818556053_REALK,      0.000000000000000_REALK,     -0.133971233112661_REALK, &
      0.000000000000000_REALK,      0.028308036254969_REALK,      0.000000000000000_REALK, &
      0.079605834155361_REALK,      0.000000000000000_REALK,      0.044180826467113_REALK, &
      0.000000000000000_REALK,     -0.114924386913575_REALK,      0.000000000000000_REALK, &
     -0.131874551219042_REALK,      0.000000000000000_REALK,      0.000393608332111_REALK, &
      0.000000000000000_REALK,     -0.368739552616067_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.001854555139205_REALK,      0.000000000000000_REALK, &
      0.002353051783535_REALK,      0.000000000000000_REALK,     -0.038549028878924_REALK, &
      0.000000000000000_REALK,     -0.168446286327456_REALK,      0.000000000000000_REALK, &
      0.572507375306938_REALK,      0.000000000000000_REALK,      0.063095694053597_REALK, &
      0.000000000000000_REALK,     -0.071970409787431_REALK,      0.000000000000000_REALK, &
     -0.054328923228208_REALK,      0.000000000000000_REALK,      0.036837007096452_REALK, &
      0.158300252411724_REALK,      0.000000000000000_REALK,     -0.014004694000661_REALK, &
      0.000000000000000_REALK,      0.024714155555700_REALK,      0.000000000000000_REALK, &
      0.060900195343331_REALK,      0.000000000000000_REALK,      0.108148736292108_REALK, &
     -0.251957925687603_REALK,      0.000000000000000_REALK,     -0.133668930702923_REALK, &
      0.000000000000000_REALK,      0.067271986612029_REALK,      0.000000000000000_REALK, &
      0.122766094213872_REALK,      0.000000000000000_REALK,      0.436747988477135_REALK, &
     -0.044055065936340_REALK,      0.000000000000000_REALK,     -0.137221157045140_REALK, &
      0.000000000000000_REALK,     -0.040135125106262_REALK,      0.000000000000000_REALK, &
     -0.013420852712362_REALK,      0.000000000000000_REALK,      0.378452234327263_REALK, &
      0.000000000000000_REALK,      0.548497904046468_REALK,      0.000000000000000_REALK, &
      0.200742198196494_REALK,      0.000000000000000_REALK,      0.101202792614176_REALK, &
      0.000000000000000_REALK,      0.109113849501558_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.610141280234109_REALK,      0.000000000000000_REALK, &
      0.246642482404748_REALK,      0.000000000000000_REALK,      0.135014061218469_REALK, &
      0.000000000000000_REALK,      0.240941418190375_REALK,      0.000000000000000_REALK, &
     -0.001720678227880_REALK,      0.000000000000000_REALK,     -0.077062261183436_REALK, &
      0.000000000000000_REALK,     -0.093182289816150_REALK,      0.000000000000000_REALK, &
     -0.257183095090554_REALK,      0.000000000000000_REALK,      0.031219311498693_REALK, &
     -0.146937932498505_REALK,      0.000000000000000_REALK,     -0.034703003901670_REALK, &
      0.000000000000000_REALK,     -0.294425009540685_REALK,      0.000000000000000_REALK, &
     -0.437644688437441_REALK,      0.000000000000000_REALK,      0.034113834045306_REALK, &
      0.000000000000000_REALK,      0.112066605245787_REALK,      0.000000000000000_REALK, &
     -0.127372671357010_REALK,      0.000000000000000_REALK,      0.039774020041487_REALK, &
      0.000000000000000_REALK,     -0.053905331476937_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.009388578255102_REALK,      0.000000000000000_REALK, &
     -0.155312503360126_REALK,      0.000000000000000_REALK,      0.144124333682990_REALK, &
      0.000000000000000_REALK,      0.177719428795617_REALK,      0.000000000000000_REALK, &
      0.030724886518225_REALK,      0.000000000000000_REALK,     -0.178906342183252_REALK, &
      0.000000000000000_REALK,      0.047338246134448_REALK,      0.000000000000000_REALK, &
      0.082122536843502_REALK,      0.000000000000000_REALK,      0.099814397831324_REALK, &
     -0.065223673918006_REALK,      0.000000000000000_REALK,     -0.265003894442353_REALK, &
      0.000000000000000_REALK,      0.099571120499361_REALK,      0.000000000000000_REALK, &
     -0.038350961442507_REALK,      0.000000000000000_REALK,      0.093582335864592_REALK, &
      0.000000000000000_REALK,     -0.152192190662253_REALK,      0.000000000000000_REALK, &
      0.016220972374429_REALK,      0.000000000000000_REALK,     -0.048679234552097_REALK, &
      0.000000000000000_REALK,     -0.024046697289345_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.042506237640157_REALK,      0.000000000000000_REALK, &
      0.017893420412590_REALK,      0.000000000000000_REALK,     -0.079077296462281_REALK, &
      0.000000000000000_REALK,     -0.150160987613774_REALK,      0.000000000000000_REALK, &
      0.013558492912436_REALK,      0.000000000000000_REALK,     -0.031877410439798_REALK, &
      0.000000000000000_REALK,     -0.025904426415367_REALK,      0.000000000000000_REALK, &
      0.024960158130109_REALK,      0.000000000000000_REALK,      0.015688661016197_REALK, &
     -0.019644722764757_REALK,      0.000000000000000_REALK,     -0.175444887684224_REALK, &
      0.000000000000000_REALK,      0.050939168883393_REALK,      0.000000000000000_REALK, &
     -0.037567140187790_REALK,      0.000000000000000_REALK,      0.029211371355019_REALK, &
      0.000000000000000_REALK,     -0.082548810257711_REALK,      0.000000000000000_REALK, &
      0.098342368597790_REALK,      0.000000000000000_REALK,      0.044238517609506_REALK, &
      0.000000000000000_REALK,     -0.085813734398905_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.015479481147804_REALK,      0.000000000000000_REALK, &
      0.161227046185623_REALK,      0.000000000000000_REALK,      0.089357232978504_REALK, &
      0.000000000000000_REALK,     -0.246960499621623_REALK,      0.000000000000000_REALK, &
      0.081650800673011_REALK,      0.000000000000000_REALK,     -0.307718615432339_REALK, &
      0.000000000000000_REALK,      0.069227236764713_REALK,      0.000000000000000_REALK, &
      0.191397816819899_REALK,      0.000000000000000_REALK,      0.098314312219980_REALK, &
     -0.040180125088926_REALK,      0.000000000000000_REALK,     -0.423353564653295_REALK, &
      0.000000000000000_REALK,     -0.005047090631265_REALK,      0.000000000000000_REALK, &
      0.122949581842510_REALK,      0.000000000000000_REALK,      0.103628067803220_REALK, &
      0.000000000000000_REALK,     -0.002149923383739_REALK,      0.000000000000000_REALK, &
     -0.021004126194546_REALK,      0.000000000000000_REALK,     -0.094348311145522_REALK, &
      0.000000000000000_REALK,     -0.413581870077142_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.079987425450073_REALK,      0.000000000000000_REALK, &
      0.337325701653716_REALK,      0.000000000000000_REALK,     -0.041259538693190_REALK, &
      0.000000000000000_REALK,     -0.286863931430606_REALK,      0.000000000000000_REALK, &
      0.404891587435478_REALK,      0.000000000000000_REALK,     -0.026375111025739_REALK, &
      0.000000000000000_REALK,      0.047968777827186_REALK,      0.000000000000000_REALK, &
      0.130406229553323_REALK,      0.000000000000000_REALK,      0.243036535891595_REALK, &
      0.134814800955294_REALK,      0.000000000000000_REALK,     -0.046978364844328_REALK, &
      0.000000000000000_REALK,      0.126975706646250_REALK,      0.000000000000000_REALK, &
      0.268520702679649_REALK,      0.000000000000000_REALK,      0.391309397873544_REALK/
  ! results of test 3, ket-major order, 1DOVL003
  data REF_CONTR_INTS(5149:5544) /                                                         &
      0.000000000000000_REALK,     -0.119408803430892_REALK,      0.000000000000000_REALK, &
     -0.051095849541178_REALK,      0.000000000000000_REALK,      0.041177401077306_REALK, &
      0.000000000000000_REALK,     -0.204571592354560_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.035621603444357_REALK,      0.000000000000000_REALK, &
      0.014903935480409_REALK,      0.000000000000000_REALK,     -0.023375976038296_REALK, &
      0.000000000000000_REALK,     -0.044679998181525_REALK,      0.000000000000000_REALK, &
     -0.148707961041400_REALK,      0.000000000000000_REALK,     -0.160997094930544_REALK, &
      0.000000000000000_REALK,      0.050309377102597_REALK,      0.000000000000000_REALK, &
      0.197797709587242_REALK,      0.000000000000000_REALK,     -0.203011171337462_REALK, &
     -0.021418115053691_REALK,      0.000000000000000_REALK,     -0.062555734981275_REALK, &
      0.000000000000000_REALK,     -0.034113581870999_REALK,      0.000000000000000_REALK, &
      0.113037798887674_REALK,      0.000000000000000_REALK,     -0.073467160960582_REALK, &
      0.000000000000000_REALK,     -0.176380954019944_REALK,      0.000000000000000_REALK, &
      0.231271903915932_REALK,      0.000000000000000_REALK,      0.192599826632614_REALK, &
      0.000000000000000_REALK,      0.213698307372406_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.065403878352583_REALK,      0.000000000000000_REALK, &
      0.080092948382882_REALK,      0.000000000000000_REALK,      0.006115308465413_REALK, &
      0.000000000000000_REALK,      0.104748049763248_REALK,      0.000000000000000_REALK, &
     -0.053466592867691_REALK,      0.000000000000000_REALK,      0.329069950260810_REALK, &
      0.000000000000000_REALK,     -0.322817922099215_REALK,      0.000000000000000_REALK, &
      0.144805270177500_REALK,      0.000000000000000_REALK,      0.033753883151258_REALK, &
      0.013986387843992_REALK,      0.000000000000000_REALK,      0.104759039977911_REALK, &
      0.000000000000000_REALK,     -0.133583620914307_REALK,      0.000000000000000_REALK, &
      0.086175539450124_REALK,      0.000000000000000_REALK,     -0.015286086785642_REALK, &
      0.000000000000000_REALK,      0.159838792763440_REALK,      0.000000000000000_REALK, &
     -0.147021918038664_REALK,      0.000000000000000_REALK,     -0.292268370666804_REALK, &
      0.000000000000000_REALK,      0.042584334036157_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.011146572339996_REALK,      0.000000000000000_REALK, &
     -0.034890598902438_REALK,      0.000000000000000_REALK,     -0.173211929228240_REALK, &
      0.000000000000000_REALK,      0.063594308395330_REALK,      0.000000000000000_REALK, &
     -0.001972923717340_REALK,      0.000000000000000_REALK,     -0.279669881956683_REALK, &
      0.000000000000000_REALK,      0.304016764155132_REALK,      0.000000000000000_REALK, &
     -0.072327710297397_REALK,      0.000000000000000_REALK,      0.003559239544518_REALK, &
     -0.022721629080529_REALK,      0.000000000000000_REALK,     -0.077556243658972_REALK, &
      0.000000000000000_REALK,      0.182572064954986_REALK,      0.000000000000000_REALK, &
     -0.020057453036682_REALK,      0.000000000000000_REALK,      0.040990799607970_REALK, &
      0.000000000000000_REALK,      0.123077253662694_REALK,      0.000000000000000_REALK, &
     -0.292268370666804_REALK,      0.000000000000000_REALK,     -0.298193734573096_REALK, &
      0.000000000000000_REALK,     -0.139021861991318_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.058455247874722_REALK,      0.000000000000000_REALK, &
     -0.173211929228240_REALK,      0.000000000000000_REALK,     -0.124482099779274_REALK, &
      0.000000000000000_REALK,     -0.020417659339387_REALK,      0.000000000000000_REALK, &
      0.095853588981396_REALK,      0.000000000000000_REALK,      0.144805270177500_REALK, &
      0.000000000000000_REALK,     -0.083486577049495_REALK,      0.000000000000000_REALK, &
     -0.193399965165305_REALK,      0.000000000000000_REALK,      0.069526704530096_REALK, &
     -0.013780721974207_REALK,      0.000000000000000_REALK,      0.086175539450124_REALK, &
      0.000000000000000_REALK,     -0.034547150255757_REALK,      0.000000000000000_REALK, &
     -0.206169745646511_REALK,      0.000000000000000_REALK,     -0.013597073166231_REALK, &
      0.000000000000000_REALK,      0.213698307372406_REALK,      0.000000000000000_REALK, &
      0.042237956775083_REALK,      0.000000000000000_REALK,     -0.192385593789357_REALK, &
      0.000000000000000_REALK,      0.229204604274978_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.104748049763248_REALK,      0.000000000000000_REALK, &
      0.095489646004897_REALK,      0.000000000000000_REALK,     -0.103206775114424_REALK, &
      0.000000000000000_REALK,      0.133401141518235_REALK,      0.000000000000000_REALK, &
     -0.203011171337462_REALK,      0.000000000000000_REALK,      0.153566432056267_REALK, &
      0.000000000000000_REALK,     -0.090760287825555_REALK,      0.000000000000000_REALK, &
      0.172436106542956_REALK,      0.000000000000000_REALK,      0.105001738503804_REALK, &
     -0.073467160960582_REALK,      0.000000000000000_REALK,      0.038983469138901_REALK, &
      0.000000000000000_REALK,      0.061542374159363_REALK,      0.000000000000000_REALK, &
      0.081707529485793_REALK,      0.000000000000000_REALK,      0.070396198468813_REALK, &
      0.000000000000000_REALK,     -0.158585831087377_REALK,      0.000000000000000_REALK, &
      0.013063326949997_REALK,      0.000000000000000_REALK,      0.000376846311623_REALK, &
      0.000000000000000_REALK,      0.107516050462758_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.086742054635898_REALK,      0.000000000000000_REALK, &
     -0.040401628723591_REALK,      0.000000000000000_REALK,     -0.045618947812683_REALK, &
      0.000000000000000_REALK,      0.046499615093161_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.090164585206883_REALK,      0.000000000000000_REALK, &
      0.025361045119409_REALK,      0.000000000000000_REALK,     -0.047407789630480_REALK, &
      0.000000000000000_REALK,     -0.119287749348849_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.040142591087036_REALK,      0.000000000000000_REALK, &
      0.149366948013994_REALK,      0.000000000000000_REALK,     -0.136789221716837_REALK, &
      0.000000000000000_REALK,     -0.004323011673665_REALK,      0.000000000000000_REALK, &
     -0.061469386689034_REALK,      0.000000000000000_REALK,     -0.152082488118773_REALK, &
      0.000000000000000_REALK,     -0.071100033594918_REALK,      0.000000000000000_REALK, &
      0.275226983300812_REALK,      0.000000000000000_REALK,     -0.181067779468744_REALK, &
      0.012025048631064_REALK,      0.000000000000000_REALK,     -0.132536755665305_REALK, &
      0.000000000000000_REALK,     -0.175147019035706_REALK,      0.000000000000000_REALK, &
      0.149637397187710_REALK,      0.000000000000000_REALK,     -0.119129076756403_REALK, &
      0.000000000000000_REALK,     -0.154349581794645_REALK,      0.000000000000000_REALK, &
      0.199184900091616_REALK,      0.000000000000000_REALK,      0.031784065386022_REALK, &
      0.000000000000000_REALK,      0.252751936373717_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.234971223497940_REALK,      0.000000000000000_REALK, &
      0.106262424779548_REALK,      0.000000000000000_REALK,     -0.155452701495508_REALK, &
      0.000000000000000_REALK,      0.210743420325301_REALK,      0.000000000000000_REALK, &
      0.029276600004426_REALK,      0.000000000000000_REALK,      0.262679681557968_REALK, &
      0.000000000000000_REALK,     -0.327504632269893_REALK,      0.000000000000000_REALK, &
      0.204012605382803_REALK,      0.000000000000000_REALK,     -0.037603263103146_REALK, &
      0.054410596551981_REALK,      0.000000000000000_REALK,      0.117208181443734_REALK, &
      0.000000000000000_REALK,     -0.204055923359347_REALK,      0.000000000000000_REALK, &
      0.217086573445957_REALK,      0.000000000000000_REALK,      0.003767109800918_REALK, &
      0.000000000000000_REALK,     -0.009328082130717_REALK,      0.000000000000000_REALK, &
     -0.092133729114273_REALK,      0.000000000000000_REALK,     -0.408486160998099_REALK, &
      0.000000000000000_REALK,      0.149012655602549_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.186700883671519_REALK,      0.000000000000000_REALK, &
      0.024051395238044_REALK,      0.000000000000000_REALK,     -0.480766295345317_REALK, &
      0.000000000000000_REALK,      0.124855373031126_REALK,      0.000000000000000_REALK, &
     -0.054305359805984_REALK,      0.000000000000000_REALK,     -0.201955476198693_REALK, &
      0.000000000000000_REALK,      0.431508088514162_REALK,      0.000000000000000_REALK, &
     -0.052229353669675_REALK,      0.000000000000000_REALK,      0.097969213103357_REALK, &
     -0.027884600509700_REALK,      0.000000000000000_REALK,      0.039401488198990_REALK, &
      0.000000000000000_REALK,      0.483086183095003_REALK,      0.000000000000000_REALK, &
      0.010189940381869_REALK,      0.000000000000000_REALK,      0.050305022918487_REALK, &
      0.000000000000000_REALK,     -0.120690704390340_REALK,      0.000000000000000_REALK, &
     -0.408486160998099_REALK,      0.000000000000000_REALK,     -0.303417607853440_REALK, &
      0.000000000000000_REALK,     -0.060422104594150_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.274575557391323_REALK,      0.000000000000000_REALK, &
     -0.480766295345317_REALK,      0.000000000000000_REALK,     -0.224618394209464_REALK, &
      0.000000000000000_REALK,      0.083400791372380_REALK,      0.000000000000000_REALK, &
     -0.019039680101700_REALK,      0.000000000000000_REALK,      0.204012605382803_REALK, &
      0.000000000000000_REALK,     -0.084698645410596_REALK,      0.000000000000000_REALK, &
     -0.473415410489150_REALK,      0.000000000000000_REALK,     -0.024475720324368_REALK, &
     -0.164221606816866_REALK,      0.000000000000000_REALK,      0.217086573445957_REALK, &
      0.000000000000000_REALK,     -0.052772567449679_REALK,      0.000000000000000_REALK, &
     -0.666058916013591_REALK,      0.000000000000000_REALK,     -0.097855529355452_REALK, &
      0.000000000000000_REALK,      0.252751936373717_REALK,      0.000000000000000_REALK, &
      0.215351788050640_REALK,      0.000000000000000_REALK,     -0.246658846774569_REALK, &
      0.000000000000000_REALK,      0.325357237060081_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.210743420325301_REALK,      0.000000000000000_REALK, &
      0.344999675415476_REALK,      0.000000000000000_REALK,     -0.235688497696717_REALK, &
      0.000000000000000_REALK,      0.165006150401727_REALK,      0.000000000000000_REALK, &
     -0.181067779468744_REALK,      0.000000000000000_REALK,      0.094537522870483_REALK, &
      0.000000000000000_REALK,      0.128267529536721_REALK,      0.000000000000000_REALK, &
      0.198812063918508_REALK,      0.000000000000000_REALK,      0.164816938460873_REALK, &
     -0.119129076756404_REALK,      0.000000000000000_REALK,      0.133962664208251_REALK, &
      0.000000000000000_REALK,      0.315972782311553_REALK,      0.000000000000000_REALK, &
      0.136590526267972_REALK,      0.000000000000000_REALK,      0.160904551526614_REALK, &
      0.000000000000000_REALK,     -0.204616141392793_REALK,      0.000000000000000_REALK, &
     -0.093315812541997_REALK,      0.000000000000000_REALK,     -0.108181100006084_REALK, &
      0.000000000000000_REALK,      0.112232056958643_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.208781559305621_REALK,      0.000000000000000_REALK, &
     -0.091042612963534_REALK,      0.000000000000000_REALK,     -0.066838091235948_REALK, &
      0.000000000000000_REALK,      0.093019284485295_REALK,      0.000000000000000_REALK/
  ! results of test 4, ket-major order, 01 DPG X
  data REF_CONTR_INTS(5545:5940) /                                                         &
      0.315494316255590_REALK,      0.000000000000000_REALK,     -0.018840483799308_REALK, &
      0.000000000000000_REALK,     -0.012863808998892_REALK,      0.000000000000000_REALK, &
     -0.021016936416447_REALK,      0.000000000000000_REALK,     -0.216682335085740_REALK, &
      0.064500928594501_REALK,      0.000000000000000_REALK,      0.004643073016029_REALK, &
      0.000000000000000_REALK,     -0.010255892273132_REALK,      0.000000000000000_REALK, &
      0.088644198059396_REALK,      0.000000000000000_REALK,     -0.107038440201481_REALK, &
      0.000000000000000_REALK,     -0.186334423247266_REALK,      0.000000000000000_REALK, &
     -0.074775245723246_REALK,      0.000000000000000_REALK,      0.062379632228293_REALK, &
      0.000000000000000_REALK,     -0.274793632833234_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.092463263612788_REALK,      0.000000000000000_REALK, &
      0.052003600512415_REALK,      0.000000000000000_REALK,      0.060266298314427_REALK, &
      0.000000000000000_REALK,     -0.100642464487385_REALK,      0.000000000000000_REALK, &
     -0.075326664114652_REALK,      0.000000000000000_REALK,     -0.126481240974204_REALK, &
      0.000000000000000_REALK,      0.083532415504358_REALK,      0.000000000000000_REALK, &
      0.105943624567182_REALK,      0.000000000000000_REALK,      0.025336927630934_REALK, &
      0.004342893742576_REALK,      0.000000000000000_REALK,     -0.060819765749567_REALK, &
      0.000000000000000_REALK,     -0.009324452967220_REALK,      0.000000000000000_REALK, &
      0.068268916672010_REALK,      0.000000000000000_REALK,      0.020334829593428_REALK, &
      0.000000000000000_REALK,     -0.017769213071471_REALK,      0.000000000000000_REALK, &
      0.103547760163585_REALK,      0.000000000000000_REALK,      0.087807829712669_REALK, &
      0.000000000000000_REALK,      0.077766195533505_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.061368394019540_REALK,      0.000000000000000_REALK, &
      0.009659617878665_REALK,      0.000000000000000_REALK,      0.012803149186646_REALK, &
      0.000000000000000_REALK,     -0.003751887388307_REALK,      0.000000000000000_REALK, &
      0.018363895610162_REALK,      0.000000000000000_REALK,      0.099737925823421_REALK, &
      0.000000000000000_REALK,     -0.100404794842573_REALK,      0.000000000000000_REALK, &
      0.024875436579128_REALK,      0.000000000000000_REALK,     -0.028830909457045_REALK, &
      0.007858708693694_REALK,      0.000000000000000_REALK,      0.014459053131374_REALK, &
      0.000000000000000_REALK,     -0.018940825612034_REALK,      0.000000000000000_REALK, &
      0.009018152432563_REALK,      0.000000000000000_REALK,     -0.001213915701100_REALK, &
      0.000000000000000_REALK,     -0.050179690220656_REALK,      0.000000000000000_REALK, &
     -0.113432457102127_REALK,      0.000000000000000_REALK,     -0.070793511869537_REALK, &
      0.000000000000000_REALK,     -0.041526586882752_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.077480723214195_REALK,      0.000000000000000_REALK, &
     -0.043189162066933_REALK,      0.000000000000000_REALK,     -0.001736244257341_REALK, &
      0.000000000000000_REALK,      0.059937059715345_REALK,      0.000000000000000_REALK, &
      0.023860661629856_REALK,      0.000000000000000_REALK,      0.117200611870172_REALK, &
      0.000000000000000_REALK,     -0.137780071946736_REALK,      0.000000000000000_REALK, &
     -0.097119225999508_REALK,      0.000000000000000_REALK,     -0.087790842962240_REALK, &
     -0.055298812248867_REALK,      0.000000000000000_REALK,     -0.023318472740742_REALK, &
      0.000000000000000_REALK,     -0.038526336721887_REALK,      0.000000000000000_REALK, &
     -0.089902322888536_REALK,      0.000000000000000_REALK,     -0.011585331956270_REALK, &
      0.000000000000000_REALK,      0.147994976229356_REALK,      0.000000000000000_REALK, &
      0.094483445832024_REALK,      0.000000000000000_REALK,     -0.038272321474601_REALK, &
      0.000000000000000_REALK,      0.104795930250430_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.082973477021720_REALK,      0.000000000000000_REALK, &
      0.051055158186226_REALK,      0.000000000000000_REALK,     -0.040034374721885_REALK, &
      0.000000000000000_REALK,     -0.067287121110967_REALK,      0.000000000000000_REALK, &
     -0.019515015136982_REALK,      0.000000000000000_REALK,      0.071361770278792_REALK, &
      0.000000000000000_REALK,     -0.025096987249541_REALK,      0.000000000000000_REALK, &
      0.153218512822256_REALK,      0.000000000000000_REALK,      0.089916778290846_REALK, &
      0.092545545862171_REALK,      0.000000000000000_REALK,      0.054920070873687_REALK, &
      0.000000000000000_REALK,      0.003406132707574_REALK,      0.000000000000000_REALK, &
      0.142928916769875_REALK,      0.000000000000000_REALK,      0.030889936816817_REALK, &
      0.000000000000000_REALK,     -0.244647022592399_REALK,      0.000000000000000_REALK, &
     -0.017662536683389_REALK,      0.000000000000000_REALK,      0.031913423766829_REALK, &
      0.000000000000000_REALK,      0.086879108796190_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.134538949413317_REALK,      0.000000000000000_REALK, &
     -0.054403567923954_REALK,      0.000000000000000_REALK,     -0.061189530421581_REALK, &
      0.000000000000000_REALK,      0.117647402526668_REALK,      0.000000000000000_REALK, &
     -0.168811252224062_REALK,      0.000000000000000_REALK,      0.030185807334635_REALK, &
      0.000000000000000_REALK,     -0.070059251368681_REALK,      0.000000000000000_REALK, &
      0.010635989833357_REALK,      0.000000000000000_REALK,     -0.350892285706240_REALK, &
     -0.127442947060926_REALK,      0.000000000000000_REALK,      0.005626695510238_REALK, &
      0.000000000000000_REALK,     -0.008275100813774_REALK,      0.000000000000000_REALK, &
     -0.006266427146732_REALK,      0.000000000000000_REALK,     -0.156137650833765_REALK, &
     -0.043836753415913_REALK,      0.000000000000000_REALK,      0.072290469381628_REALK, &
      0.000000000000000_REALK,      0.033558838351393_REALK,      0.000000000000000_REALK, &
      0.099130044185031_REALK,      0.000000000000000_REALK,     -0.218756347452423_REALK, &
      0.213304224146219_REALK,      0.000000000000000_REALK,      0.145333255971880_REALK, &
      0.000000000000000_REALK,      0.048648185906212_REALK,      0.000000000000000_REALK, &
      0.097249638062672_REALK,      0.000000000000000_REALK,     -0.098438181872620_REALK, &
      0.000000000000000_REALK,     -0.252948071624270_REALK,      0.000000000000000_REALK, &
      0.100772423994070_REALK,      0.000000000000000_REALK,     -0.075457660670200_REALK, &
      0.000000000000000_REALK,      0.074284689125160_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.069354433038463_REALK,      0.000000000000000_REALK, &
      0.203252531817127_REALK,      0.000000000000000_REALK,     -0.179995370806929_REALK, &
      0.000000000000000_REALK,      0.021062213958498_REALK,      0.000000000000000_REALK, &
      0.066995407577475_REALK,      0.000000000000000_REALK,     -0.024665209490323_REALK, &
      0.000000000000000_REALK,     -0.075307401568534_REALK,      0.000000000000000_REALK, &
      0.272185570677856_REALK,      0.000000000000000_REALK,      0.026842340548228_REALK, &
     -0.000406546857049_REALK,      0.000000000000000_REALK,     -0.006301118621323_REALK, &
      0.000000000000000_REALK,     -0.227516763080633_REALK,      0.000000000000000_REALK, &
      0.269567311388013_REALK,      0.000000000000000_REALK,      0.032436979772014_REALK, &
      0.000000000000000_REALK,      0.110792528543637_REALK,      0.000000000000000_REALK, &
      0.066866143995754_REALK,      0.000000000000000_REALK,      0.016391913662961_REALK, &
      0.000000000000000_REALK,     -0.053155187242664_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.049302656237704_REALK,      0.000000000000000_REALK, &
      0.124743300796311_REALK,      0.000000000000000_REALK,      0.126568586088137_REALK, &
      0.000000000000000_REALK,     -0.014469160420302_REALK,      0.000000000000000_REALK, &
     -0.002073088209387_REALK,      0.000000000000000_REALK,     -0.021077964226480_REALK, &
      0.000000000000000_REALK,     -0.007461327829686_REALK,      0.000000000000000_REALK, &
     -0.009825219869295_REALK,      0.000000000000000_REALK,      0.008609888548280_REALK, &
     -0.002805151576133_REALK,      0.000000000000000_REALK,     -0.112412808313772_REALK, &
      0.000000000000000_REALK,      0.055608933449128_REALK,      0.000000000000000_REALK, &
     -0.026831649557498_REALK,      0.000000000000000_REALK,      0.017103094546813_REALK, &
      0.000000000000000_REALK,     -0.103101657312396_REALK,      0.000000000000000_REALK, &
     -0.115061783648790_REALK,      0.000000000000000_REALK,     -0.006856372316735_REALK, &
      0.000000000000000_REALK,      0.181177223983541_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.053348327337601_REALK,      0.000000000000000_REALK, &
     -0.185067009599963_REALK,      0.000000000000000_REALK,      0.001962603170161_REALK, &
      0.000000000000000_REALK,      0.221812900850639_REALK,      0.000000000000000_REALK, &
     -0.133693857501985_REALK,      0.000000000000000_REALK,     -0.162241961954784_REALK, &
      0.000000000000000_REALK,     -0.032720673143258_REALK,      0.000000000000000_REALK, &
     -0.210286795586297_REALK,      0.000000000000000_REALK,      0.047431648425407_REALK, &
     -0.096612091523508_REALK,      0.000000000000000_REALK,     -0.427669639411490_REALK, &
      0.000000000000000_REALK,      0.000064313215213_REALK,      0.000000000000000_REALK, &
     -0.187481427102041_REALK,      0.000000000000000_REALK,      0.166882743435838_REALK, &
      0.000000000000000_REALK,      0.060187587171381_REALK,      0.000000000000000_REALK, &
      0.108044148626011_REALK,      0.000000000000000_REALK,     -0.107822948513222_REALK, &
      0.000000000000000_REALK,     -0.241600298376325_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.132975248649625_REALK,      0.000000000000000_REALK, &
      0.206048211248746_REALK,      0.000000000000000_REALK,     -0.163648660240528_REALK, &
      0.000000000000000_REALK,     -0.415423178052124_REALK,      0.000000000000000_REALK, &
      0.174435462693373_REALK,      0.000000000000000_REALK,      0.212215823406748_REALK, &
      0.000000000000000_REALK,      0.096320073751482_REALK,      0.000000000000000_REALK, &
      0.197606016297133_REALK,      0.000000000000000_REALK,     -0.026415740943476_REALK, &
      0.158129931314929_REALK,      0.000000000000000_REALK,      0.317305984764801_REALK, &
      0.000000000000000_REALK,      0.177232965798238_REALK,      0.000000000000000_REALK, &
      0.285177755093587_REALK,      0.000000000000000_REALK,     -0.162291940193675_REALK, &
      0.000000000000000_REALK,     -0.130153750553857_REALK,      0.000000000000000_REALK, &
     -0.167224534298801_REALK,      0.000000000000000_REALK,     -0.106980027133621_REALK, &
      0.000000000000000_REALK,      0.397758263704925_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.116073675580065_REALK,      0.000000000000000_REALK, &
     -0.117699162904503_REALK,      0.000000000000000_REALK,     -0.060697607064248_REALK, &
      0.000000000000000_REALK,      0.574545437534198_REALK,      0.000000000000000_REALK, &
     -0.385693683226282_REALK,      0.000000000000000_REALK,     -0.027542993614511_REALK, &
      0.000000000000000_REALK,      0.044211785293802_REALK,      0.000000000000000_REALK, &
     -0.144257062063652_REALK,      0.000000000000000_REALK,     -0.016784199864410_REALK, &
     -0.382532620047192_REALK,      0.000000000000000_REALK,     -0.028963561969032_REALK, &
      0.000000000000000_REALK,      0.080198174698093_REALK,      0.000000000000000_REALK, &
     -0.085278792543727_REALK,      0.000000000000000_REALK,      0.131679935343519_REALK/
  ! results of test 4, ket-major order, 01 DPG Y
  data REF_CONTR_INTS(5941:6336) /                                                         &
      0.068599223871835_REALK,      0.000000000000000_REALK,     -0.005181865352373_REALK, &
      0.000000000000000_REALK,     -0.040806207333881_REALK,      0.000000000000000_REALK, &
      0.059266394345874_REALK,      0.000000000000000_REALK,     -0.162373847343154_REALK, &
     -0.054707450904668_REALK,      0.000000000000000_REALK,     -0.000479836464260_REALK, &
      0.000000000000000_REALK,     -0.015346346518900_REALK,      0.000000000000000_REALK, &
      0.027271219972755_REALK,      0.000000000000000_REALK,     -0.127528036213320_REALK, &
      0.000000000000000_REALK,     -0.105160087700135_REALK,      0.000000000000000_REALK, &
      0.015666637990715_REALK,      0.000000000000000_REALK,      0.085156141252966_REALK, &
      0.000000000000000_REALK,     -0.107016638124108_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.067510320517645_REALK,      0.000000000000000_REALK, &
     -0.008137921860754_REALK,      0.000000000000000_REALK,     -0.044850488126630_REALK, &
      0.000000000000000_REALK,      0.053982209390661_REALK,      0.000000000000000_REALK, &
     -0.026139113464912_REALK,      0.000000000000000_REALK,     -0.019882714222325_REALK, &
      0.000000000000000_REALK,     -0.021294106722979_REALK,      0.000000000000000_REALK, &
      0.069022719984042_REALK,      0.000000000000000_REALK,     -0.033094554347424_REALK, &
      0.035666469261996_REALK,      0.000000000000000_REALK,      0.013982613098518_REALK, &
      0.000000000000000_REALK,     -0.032862182307358_REALK,      0.000000000000000_REALK, &
      0.082840590495254_REALK,      0.000000000000000_REALK,     -0.002763831781645_REALK, &
      0.000000000000000_REALK,     -0.025425822472833_REALK,      0.000000000000000_REALK, &
      0.028624731625966_REALK,      0.000000000000000_REALK,      0.038140943136634_REALK, &
      0.000000000000000_REALK,      0.008883619924953_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.024436085412105_REALK,      0.000000000000000_REALK, &
      0.005916446183025_REALK,      0.000000000000000_REALK,     -0.031582102386739_REALK, &
      0.000000000000000_REALK,      0.004839110462495_REALK,      0.000000000000000_REALK, &
      0.013116161430887_REALK,      0.000000000000000_REALK,      0.045662253335534_REALK, &
      0.000000000000000_REALK,     -0.065347943167225_REALK,      0.000000000000000_REALK, &
      0.055711668975837_REALK,      0.000000000000000_REALK,     -0.022085542511499_REALK, &
      0.008731312801332_REALK,      0.000000000000000_REALK,      0.001406033768730_REALK, &
      0.000000000000000_REALK,     -0.024149529321347_REALK,      0.000000000000000_REALK, &
      0.025104004793916_REALK,      0.000000000000000_REALK,      0.002352695194742_REALK, &
      0.000000000000000_REALK,      0.016187470121184_REALK,      0.000000000000000_REALK, &
     -0.016668890486483_REALK,      0.000000000000000_REALK,     -0.050454683448148_REALK, &
      0.000000000000000_REALK,      0.016175946686059_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.026828027711875_REALK,      0.000000000000000_REALK, &
      0.002316336650102_REALK,      0.000000000000000_REALK,     -0.016183681421276_REALK, &
      0.000000000000000_REALK,     -0.002634358249730_REALK,      0.000000000000000_REALK, &
      0.016854686223557_REALK,      0.000000000000000_REALK,      0.035564894197704_REALK, &
      0.000000000000000_REALK,     -0.025475104073009_REALK,      0.000000000000000_REALK, &
      0.008604331988679_REALK,      0.000000000000000_REALK,     -0.000179137656368_REALK, &
      0.006828275788306_REALK,      0.000000000000000_REALK,      0.018795677315982_REALK, &
      0.000000000000000_REALK,      0.008494030333664_REALK,      0.000000000000000_REALK, &
     -0.008842717045824_REALK,      0.000000000000000_REALK,     -0.003255143863335_REALK, &
      0.000000000000000_REALK,      0.027331324478276_REALK,      0.000000000000000_REALK, &
     -0.012172537360721_REALK,      0.000000000000000_REALK,     -0.068447016563455_REALK, &
      0.000000000000000_REALK,      0.065795258081796_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.017719288977454_REALK,      0.000000000000000_REALK, &
     -0.008134126154465_REALK,      0.000000000000000_REALK,     -0.030945138077313_REALK, &
      0.000000000000000_REALK,      0.043188179871989_REALK,      0.000000000000000_REALK, &
     -0.006581476307155_REALK,      0.000000000000000_REALK,      0.057049879973809_REALK, &
      0.000000000000000_REALK,     -0.058474656279239_REALK,      0.000000000000000_REALK, &
      0.044061235239981_REALK,      0.000000000000000_REALK,     -0.007051488297594_REALK, &
     -0.017403943898992_REALK,      0.000000000000000_REALK,      0.024752792622592_REALK, &
      0.000000000000000_REALK,      0.005852163861219_REALK,      0.000000000000000_REALK, &
     -0.030665755337416_REALK,      0.000000000000000_REALK,      0.014982893547104_REALK, &
      0.000000000000000_REALK,     -0.037725576898525_REALK,      0.000000000000000_REALK, &
      0.025166362842928_REALK,      0.000000000000000_REALK,     -0.043885162011935_REALK, &
      0.000000000000000_REALK,      0.108091429096891_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.048575056194980_REALK,      0.000000000000000_REALK, &
     -0.023885133043976_REALK,      0.000000000000000_REALK,     -0.087913585150646_REALK, &
      0.000000000000000_REALK,      0.082602895340379_REALK,      0.000000000000000_REALK, &
     -0.152279592873453_REALK,      0.000000000000000_REALK,      0.037705623798189_REALK, &
      0.000000000000000_REALK,     -0.033336767583525_REALK,      0.000000000000000_REALK, &
      0.061468654287824_REALK,      0.000000000000000_REALK,     -0.102529818084412_REALK, &
     -0.038943765369333_REALK,      0.000000000000000_REALK,      0.014670882936459_REALK, &
      0.000000000000000_REALK,      0.027685663978196_REALK,      0.000000000000000_REALK, &
     -0.066550454139249_REALK,      0.000000000000000_REALK,      0.087220820484293_REALK, &
      0.182082853352980_REALK,      0.000000000000000_REALK,     -0.019719267865182_REALK, &
      0.000000000000000_REALK,     -0.050736292018085_REALK,      0.000000000000000_REALK, &
      0.125795348606275_REALK,      0.000000000000000_REALK,     -0.192661186386128_REALK, &
     -0.000567228323098_REALK,      0.000000000000000_REALK,     -0.010358801002275_REALK, &
      0.000000000000000_REALK,      0.072122722956905_REALK,      0.000000000000000_REALK, &
     -0.047768844023991_REALK,      0.000000000000000_REALK,      0.008549479397278_REALK, &
      0.000000000000000_REALK,     -0.062037994113184_REALK,      0.000000000000000_REALK, &
      0.064628243872123_REALK,      0.000000000000000_REALK,     -0.096199957245283_REALK, &
      0.000000000000000_REALK,     -0.015985064593132_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.172787301567892_REALK,      0.000000000000000_REALK, &
      0.077479380238413_REALK,      0.000000000000000_REALK,     -0.344862982810515_REALK, &
      0.000000000000000_REALK,      0.329664114641968_REALK,      0.000000000000000_REALK, &
      0.049346218527325_REALK,      0.000000000000000_REALK,     -0.054621382327156_REALK, &
      0.000000000000000_REALK,     -0.157806496220447_REALK,      0.000000000000000_REALK, &
      0.177654587568987_REALK,      0.000000000000000_REALK,      0.012991525560621_REALK, &
      0.073057123835306_REALK,      0.000000000000000_REALK,     -0.005661678056169_REALK, &
      0.000000000000000_REALK,     -0.189353169043947_REALK,      0.000000000000000_REALK, &
      0.264482212924125_REALK,      0.000000000000000_REALK,      0.017900178578461_REALK, &
      0.000000000000000_REALK,      0.040047786487604_REALK,      0.000000000000000_REALK, &
      0.021074938888076_REALK,      0.000000000000000_REALK,     -0.025891062880873_REALK, &
      0.000000000000000_REALK,      0.071078769565487_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.063101175619269_REALK,      0.000000000000000_REALK, &
      0.069697843286617_REALK,      0.000000000000000_REALK,     -0.063522731430884_REALK, &
      0.000000000000000_REALK,      0.041054529378725_REALK,      0.000000000000000_REALK, &
      0.015187419825930_REALK,      0.000000000000000_REALK,     -0.052966064339078_REALK, &
      0.000000000000000_REALK,     -0.024173808081781_REALK,      0.000000000000000_REALK, &
      0.059785859707693_REALK,      0.000000000000000_REALK,      0.030539351312020_REALK, &
     -0.018683609493155_REALK,      0.000000000000000_REALK,     -0.126308070873810_REALK, &
      0.000000000000000_REALK,     -0.000255279764938_REALK,      0.000000000000000_REALK, &
      0.016822607803186_REALK,      0.000000000000000_REALK,      0.037369482729789_REALK, &
      0.000000000000000_REALK,     -0.068639846948452_REALK,      0.000000000000000_REALK, &
     -0.002816217462376_REALK,      0.000000000000000_REALK,     -0.052421046490636_REALK, &
      0.000000000000000_REALK,     -0.021484068345290_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.061884712098206_REALK,      0.000000000000000_REALK, &
     -0.008363096648656_REALK,      0.000000000000000_REALK,     -0.090917830454414_REALK, &
      0.000000000000000_REALK,     -0.066034015485403_REALK,      0.000000000000000_REALK, &
     -0.003909517013817_REALK,      0.000000000000000_REALK,     -0.019952626513589_REALK, &
      0.000000000000000_REALK,      0.060693753015852_REALK,      0.000000000000000_REALK, &
     -0.050057794663502_REALK,      0.000000000000000_REALK,      0.008945103497697_REALK, &
     -0.016119765657648_REALK,      0.000000000000000_REALK,      0.015618002014317_REALK, &
      0.000000000000000_REALK,      0.094906798054962_REALK,      0.000000000000000_REALK, &
     -0.099215380945129_REALK,      0.000000000000000_REALK,     -0.035654209319137_REALK, &
      0.000000000000000_REALK,     -0.058972420055341_REALK,      0.000000000000000_REALK, &
      0.019299695827599_REALK,      0.000000000000000_REALK,     -0.083360511473208_REALK, &
      0.000000000000000_REALK,      0.021614223859779_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.069482725256424_REALK,      0.000000000000000_REALK, &
      0.019748358425355_REALK,      0.000000000000000_REALK,     -0.099463479097208_REALK, &
      0.000000000000000_REALK,      0.005280066761424_REALK,      0.000000000000000_REALK, &
     -0.030590069811644_REALK,      0.000000000000000_REALK,      0.038507176632585_REALK, &
      0.000000000000000_REALK,      0.022431414991295_REALK,      0.000000000000000_REALK, &
      0.047201158422612_REALK,      0.000000000000000_REALK,      0.048275193515221_REALK, &
     -0.117643988703610_REALK,      0.000000000000000_REALK,      0.037147727785128_REALK, &
      0.000000000000000_REALK,      0.190678759900766_REALK,      0.000000000000000_REALK, &
     -0.142035842644987_REALK,      0.000000000000000_REALK,      0.028547509104271_REALK, &
      0.000000000000000_REALK,     -0.094385226783030_REALK,      0.000000000000000_REALK, &
      0.007891079431814_REALK,      0.000000000000000_REALK,     -0.246913241727394_REALK, &
      0.000000000000000_REALK,      0.233405398285229_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.106853259144819_REALK,      0.000000000000000_REALK, &
     -0.010156745898484_REALK,      0.000000000000000_REALK,     -0.126458976628025_REALK, &
      0.000000000000000_REALK,      0.135635916565466_REALK,      0.000000000000000_REALK, &
     -0.077236811328915_REALK,      0.000000000000000_REALK,      0.063834626040952_REALK, &
      0.000000000000000_REALK,      0.099512429011340_REALK,      0.000000000000000_REALK, &
     -0.109500962127667_REALK,      0.000000000000000_REALK,      0.022318933473716_REALK, &
     -0.253514732136659_REALK,      0.000000000000000_REALK,      0.096305776597303_REALK, &
      0.000000000000000_REALK,      0.146746043266043_REALK,      0.000000000000000_REALK, &
     -0.214011742555205_REALK,      0.000000000000000_REALK,      0.161092259819385_REALK/
  ! results of test 4, ket-major order, 01 DPG Z
  data REF_CONTR_INTS(6337:6732) /                                                         &
      0.000000000000000_REALK,     -0.085747977041291_REALK,      0.000000000000000_REALK, &
     -0.003458513499154_REALK,      0.000000000000000_REALK,      0.001617089630326_REALK, &
      0.000000000000000_REALK,     -0.004299052175454_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.018685548838236_REALK,      0.000000000000000_REALK, &
      0.004416019060699_REALK,      0.000000000000000_REALK,     -0.022200724183157_REALK, &
      0.000000000000000_REALK,      0.029936488700256_REALK,      0.000000000000000_REALK, &
      0.119643125777256_REALK,      0.000000000000000_REALK,     -0.018525057329973_REALK, &
      0.000000000000000_REALK,     -0.000905298741864_REALK,      0.000000000000000_REALK, &
      0.064767197850840_REALK,      0.000000000000000_REALK,     -0.000686589716080_REALK, &
      0.036551424634056_REALK,      0.000000000000000_REALK,      0.013780537248172_REALK, &
      0.000000000000000_REALK,     -0.020047067412614_REALK,      0.000000000000000_REALK, &
      0.071938273871205_REALK,      0.000000000000000_REALK,     -0.062076394072814_REALK, &
      0.000000000000000_REALK,      0.008324208072256_REALK,      0.000000000000000_REALK, &
      0.002971702355701_REALK,      0.000000000000000_REALK,      0.013231704952136_REALK, &
      0.000000000000000_REALK,     -0.088300628776968_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.067395981872373_REALK,      0.000000000000000_REALK, &
      0.051505475714400_REALK,      0.000000000000000_REALK,      0.055691635341529_REALK, &
      0.000000000000000_REALK,     -0.086300944759850_REALK,      0.000000000000000_REALK, &
     -0.023567184927322_REALK,      0.000000000000000_REALK,     -0.023708589117589_REALK, &
      0.000000000000000_REALK,      0.006275084805778_REALK,      0.000000000000000_REALK, &
     -0.001096484125992_REALK,      0.000000000000000_REALK,      0.002647345780880_REALK, &
     -0.005034362617356_REALK,      0.000000000000000_REALK,     -0.057269715249345_REALK, &
      0.000000000000000_REALK,      0.002597396186685_REALK,      0.000000000000000_REALK, &
      0.019107733623443_REALK,      0.000000000000000_REALK,      0.005955997156747_REALK, &
      0.000000000000000_REALK,     -0.046315449520676_REALK,      0.000000000000000_REALK, &
      0.010875309169398_REALK,      0.000000000000000_REALK,      0.018912254144499_REALK, &
      0.000000000000000_REALK,      0.005584656430533_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.040545764614290_REALK,      0.000000000000000_REALK, &
     -0.004049361037022_REALK,      0.000000000000000_REALK,      0.004167176819023_REALK, &
      0.000000000000000_REALK,     -0.017675884445875_REALK,      0.000000000000000_REALK, &
      0.017359739713497_REALK,      0.000000000000000_REALK,      0.033325887468329_REALK, &
      0.000000000000000_REALK,     -0.021322624830259_REALK,      0.000000000000000_REALK, &
      0.000749416481596_REALK,      0.000000000000000_REALK,     -0.033066849982308_REALK, &
     -0.020010010490833_REALK,      0.000000000000000_REALK,      0.016318266661647_REALK, &
      0.000000000000000_REALK,     -0.021283546195418_REALK,      0.000000000000000_REALK, &
     -0.017981696135852_REALK,      0.000000000000000_REALK,     -0.012499484408326_REALK, &
      0.000000000000000_REALK,     -0.000862014818560_REALK,      0.000000000000000_REALK, &
      0.018912254144499_REALK,      0.000000000000000_REALK,      0.005607863329168_REALK, &
      0.000000000000000_REALK,      0.055718306356097_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.088158825372125_REALK,      0.000000000000000_REALK, &
      0.004167176819023_REALK,      0.000000000000000_REALK,     -0.030953443293980_REALK, &
      0.000000000000000_REALK,     -0.036885718951216_REALK,      0.000000000000000_REALK, &
     -0.037883914917022_REALK,      0.000000000000000_REALK,     -0.001096484125992_REALK, &
      0.000000000000000_REALK,      0.000517425654180_REALK,      0.000000000000000_REALK, &
      0.016685895662047_REALK,      0.000000000000000_REALK,      0.019987979252061_REALK, &
      0.065093773848062_REALK,      0.000000000000000_REALK,      0.019107733623443_REALK, &
      0.000000000000000_REALK,     -0.013936575471588_REALK,      0.000000000000000_REALK, &
      0.090861870641428_REALK,      0.000000000000000_REALK,      0.020732162521246_REALK, &
      0.000000000000000_REALK,     -0.088300628776968_REALK,      0.000000000000000_REALK, &
     -0.003419366947989_REALK,      0.000000000000000_REALK,      0.002600124041173_REALK, &
      0.000000000000000_REALK,     -0.029045276449712_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.086300944759850_REALK,      0.000000000000000_REALK, &
     -0.014435580808131_REALK,      0.000000000000000_REALK,     -0.053673010634422_REALK, &
      0.000000000000000_REALK,      0.052967210052468_REALK,      0.000000000000000_REALK, &
     -0.000686589716080_REALK,      0.000000000000000_REALK,      0.063705750616509_REALK, &
      0.000000000000000_REALK,     -0.037133532359469_REALK,      0.000000000000000_REALK, &
      0.022990037198200_REALK,      0.000000000000000_REALK,     -0.114783577158300_REALK, &
     -0.062076394072814_REALK,      0.000000000000000_REALK,      0.022816084754401_REALK, &
      0.000000000000000_REALK,      0.022008190164984_REALK,      0.000000000000000_REALK, &
     -0.007522852302245_REALK,      0.000000000000000_REALK,     -0.091287359425972_REALK, &
      0.000000000000000_REALK,      0.005313783751427_REALK,      0.000000000000000_REALK, &
     -0.009933229790317_REALK,      0.000000000000000_REALK,     -0.037971519925579_REALK, &
      0.000000000000000_REALK,      0.087485157790597_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.008092050760262_REALK,      0.000000000000000_REALK, &
     -0.009957071544293_REALK,      0.000000000000000_REALK,      0.005201253061613_REALK, &
      0.000000000000000_REALK,      0.020472027216431_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.120372881100684_REALK,      0.000000000000000_REALK, &
      0.025693758180744_REALK,      0.000000000000000_REALK,     -0.134111352372121_REALK, &
      0.000000000000000_REALK,      0.182046728932427_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.084663809149238_REALK,      0.000000000000000_REALK, &
      0.026312606473376_REALK,      0.000000000000000_REALK,     -0.108876870258399_REALK, &
      0.000000000000000_REALK,      0.119995802678591_REALK,      0.000000000000000_REALK, &
      0.038655861216227_REALK,      0.000000000000000_REALK,      0.095350905865611_REALK, &
      0.000000000000000_REALK,     -0.065148398445479_REALK,      0.000000000000000_REALK, &
      0.233771068167276_REALK,      0.000000000000000_REALK,     -0.060477903856725_REALK, &
      0.111394994074778_REALK,      0.000000000000000_REALK,      0.152972838962820_REALK, &
      0.000000000000000_REALK,     -0.000706655455773_REALK,      0.000000000000000_REALK, &
      0.119586534031497_REALK,      0.000000000000000_REALK,     -0.137561034180252_REALK, &
      0.000000000000000_REALK,     -0.065549581742492_REALK,      0.000000000000000_REALK, &
      0.131739878471040_REALK,      0.000000000000000_REALK,     -0.013678646007540_REALK, &
      0.000000000000000_REALK,     -0.104771264070968_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.121550280309958_REALK,      0.000000000000000_REALK, &
      0.197754367573046_REALK,      0.000000000000000_REALK,     -0.138784787917749_REALK, &
      0.000000000000000_REALK,     -0.144866419936210_REALK,      0.000000000000000_REALK, &
     -0.007713819377018_REALK,      0.000000000000000_REALK,     -0.124472636657002_REALK, &
      0.000000000000000_REALK,      0.027094483452315_REALK,      0.000000000000000_REALK, &
     -0.042160299479272_REALK,      0.000000000000000_REALK,      0.007599834375636_REALK, &
      0.037803657785916_REALK,      0.000000000000000_REALK,     -0.122464867936734_REALK, &
      0.000000000000000_REALK,     -0.142235134934864_REALK,      0.000000000000000_REALK, &
      0.082050571349663_REALK,      0.000000000000000_REALK,     -0.000675289591697_REALK, &
      0.000000000000000_REALK,      0.021003927839029_REALK,      0.000000000000000_REALK, &
     -0.028443179054541_REALK,      0.000000000000000_REALK,     -0.053888335447825_REALK, &
      0.000000000000000_REALK,     -0.018859979843318_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.127264318829819_REALK,      0.000000000000000_REALK, &
      0.048963713029716_REALK,      0.000000000000000_REALK,      0.067600038569255_REALK, &
      0.000000000000000_REALK,     -0.014781373160417_REALK,      0.000000000000000_REALK, &
     -0.017253277604924_REALK,      0.000000000000000_REALK,      0.110660912376616_REALK, &
      0.000000000000000_REALK,     -0.010126685763905_REALK,      0.000000000000000_REALK, &
      0.007662233378261_REALK,      0.000000000000000_REALK,     -0.017019714604374_REALK, &
     -0.072827842254937_REALK,      0.000000000000000_REALK,     -0.050173058560699_REALK, &
      0.000000000000000_REALK,      0.072955796715041_REALK,      0.000000000000000_REALK, &
     -0.075007187637473_REALK,      0.000000000000000_REALK,      0.071743285498220_REALK, &
      0.000000000000000_REALK,      0.091013689594042_REALK,      0.000000000000000_REALK, &
     -0.053888335447825_REALK,      0.000000000000000_REALK,     -0.003270504288221_REALK, &
      0.000000000000000_REALK,     -0.001069572711946_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.104950124007979_REALK,      0.000000000000000_REALK, &
      0.067600038569255_REALK,      0.000000000000000_REALK,      0.070438242194078_REALK, &
      0.000000000000000_REALK,     -0.199354415270234_REALK,      0.000000000000000_REALK, &
      0.060784458990155_REALK,      0.000000000000000_REALK,     -0.042160299479272_REALK, &
      0.000000000000000_REALK,      0.021448005641563_REALK,      0.000000000000000_REALK, &
      0.023248810896613_REALK,      0.000000000000000_REALK,      0.023531830447455_REALK, &
      0.159506664389296_REALK,      0.000000000000000_REALK,      0.082050571349663_REALK, &
      0.000000000000000_REALK,     -0.036891348354913_REALK,      0.000000000000000_REALK, &
      0.318167682303179_REALK,      0.000000000000000_REALK,     -0.041427589498469_REALK, &
      0.000000000000000_REALK,     -0.104771264070968_REALK,      0.000000000000000_REALK, &
     -0.017216220754922_REALK,      0.000000000000000_REALK,     -0.146407835595427_REALK, &
      0.000000000000000_REALK,     -0.014417521893129_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.144866419936211_REALK,      0.000000000000000_REALK, &
      0.002136195554627_REALK,      0.000000000000000_REALK,     -0.277155660881994_REALK, &
      0.000000000000000_REALK,      0.303300414638707_REALK,      0.000000000000000_REALK, &
     -0.060477903856725_REALK,      0.000000000000000_REALK,      0.120238992815493_REALK, &
      0.000000000000000_REALK,      0.161227147925955_REALK,      0.000000000000000_REALK, &
     -0.104459856679488_REALK,      0.000000000000000_REALK,     -0.095615851105125_REALK, &
     -0.137561034180252_REALK,      0.000000000000000_REALK,      0.160320277521039_REALK, &
      0.000000000000000_REALK,      0.264021003205169_REALK,      0.000000000000000_REALK, &
     -0.222687358273276_REALK,      0.000000000000000_REALK,     -0.049781059747269_REALK, &
      0.000000000000000_REALK,      0.047911767072308_REALK,      0.000000000000000_REALK, &
     -0.062705241367881_REALK,      0.000000000000000_REALK,      0.016613583702901_REALK, &
      0.000000000000000_REALK,      0.134901517087350_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.096813266789804_REALK,      0.000000000000000_REALK, &
     -0.053372783847488_REALK,      0.000000000000000_REALK,      0.160027345283575_REALK, &
      0.000000000000000_REALK,      0.042350466579297_REALK,      0.000000000000000_REALK/
  ! results of test 4, ket-major order, 02 DPG X
  data REF_CONTR_INTS(6733:7128) /                                                         &
     -0.106571422068323_REALK,      0.000000000000000_REALK,      0.015512528650562_REALK, &
      0.000000000000000_REALK,      0.033212383673416_REALK,      0.000000000000000_REALK, &
      0.054834490754909_REALK,      0.000000000000000_REALK,      0.401936577701521_REALK, &
     -0.182750139141954_REALK,      0.000000000000000_REALK,     -0.042355061255811_REALK, &
      0.000000000000000_REALK,      0.032532157288417_REALK,      0.000000000000000_REALK, &
      0.053086420226428_REALK,      0.000000000000000_REALK,      0.131707615079844_REALK, &
      0.000000000000000_REALK,      0.224611560136180_REALK,      0.000000000000000_REALK, &
     -0.010067010194405_REALK,      0.000000000000000_REALK,     -0.036191667652119_REALK, &
      0.000000000000000_REALK,     -0.088803497305535_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.174202866256303_REALK,      0.000000000000000_REALK, &
      0.101329990209104_REALK,      0.000000000000000_REALK,      0.046519715230801_REALK, &
      0.000000000000000_REALK,      0.088811788425873_REALK,      0.000000000000000_REALK, &
      0.073250118857150_REALK,      0.000000000000000_REALK,     -0.073268812940737_REALK, &
      0.000000000000000_REALK,      0.041593084321346_REALK,      0.000000000000000_REALK, &
     -0.091779903444974_REALK,      0.000000000000000_REALK,      0.002995010047623_REALK, &
      0.001279215367481_REALK,      0.000000000000000_REALK,      0.014247337698071_REALK, &
      0.000000000000000_REALK,     -0.040485398309616_REALK,      0.000000000000000_REALK, &
     -0.105745823763926_REALK,      0.000000000000000_REALK,     -0.027119544948541_REALK, &
      0.000000000000000_REALK,     -0.049232465728003_REALK,      0.000000000000000_REALK, &
     -0.028070598949571_REALK,      0.000000000000000_REALK,      0.057183814794146_REALK, &
      0.000000000000000_REALK,     -0.101675725270071_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.011090771526804_REALK,      0.000000000000000_REALK, &
     -0.058869167027344_REALK,      0.000000000000000_REALK,     -0.001640728047693_REALK, &
      0.000000000000000_REALK,     -0.039841999277126_REALK,      0.000000000000000_REALK, &
      0.009647047741243_REALK,      0.000000000000000_REALK,      0.002096569978696_REALK, &
      0.000000000000000_REALK,     -0.027604674744306_REALK,      0.000000000000000_REALK, &
      0.068454909187193_REALK,      0.000000000000000_REALK,     -0.026249872457247_REALK, &
      0.011103814564700_REALK,      0.000000000000000_REALK,     -0.030925122660241_REALK, &
      0.000000000000000_REALK,      0.015350724687934_REALK,      0.000000000000000_REALK, &
      0.043551813098898_REALK,      0.000000000000000_REALK,      0.015331203182623_REALK, &
      0.000000000000000_REALK,      0.004404074678952_REALK,      0.000000000000000_REALK, &
     -0.036481394943759_REALK,      0.000000000000000_REALK,     -0.066695507021718_REALK, &
      0.000000000000000_REALK,      0.014422903563205_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.037925803559714_REALK,      0.000000000000000_REALK, &
     -0.002492560765276_REALK,      0.000000000000000_REALK,     -0.017195783624886_REALK, &
      0.000000000000000_REALK,      0.009402314169207_REALK,      0.000000000000000_REALK, &
      0.018363895610162_REALK,      0.000000000000000_REALK,      0.099737925823421_REALK, &
      0.000000000000000_REALK,     -0.100404794842573_REALK,      0.000000000000000_REALK, &
      0.024875436579128_REALK,      0.000000000000000_REALK,     -0.028830909457045_REALK, &
      0.007858708693694_REALK,      0.000000000000000_REALK,      0.014459053131374_REALK, &
      0.000000000000000_REALK,     -0.018940825612034_REALK,      0.000000000000000_REALK, &
      0.009018152432563_REALK,      0.000000000000000_REALK,     -0.001213915701100_REALK, &
      0.000000000000000_REALK,     -0.049432291045774_REALK,      0.000000000000000_REALK, &
      0.092397931053682_REALK,      0.000000000000000_REALK,      0.056115907291584_REALK, &
      0.000000000000000_REALK,      0.103150228388948_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.002244660744852_REALK,      0.000000000000000_REALK, &
      0.018841743066413_REALK,      0.000000000000000_REALK,      0.016494054813870_REALK, &
      0.000000000000000_REALK,      0.006324402450166_REALK,      0.000000000000000_REALK, &
     -0.017230166270522_REALK,      0.000000000000000_REALK,     -0.116629724853385_REALK, &
      0.000000000000000_REALK,      0.055606103827143_REALK,      0.000000000000000_REALK, &
      0.105704746286177_REALK,      0.000000000000000_REALK,     -0.071764024848459_REALK, &
      0.017192485513569_REALK,      0.000000000000000_REALK,     -0.098521913066126_REALK, &
      0.000000000000000_REALK,      0.027455985623256_REALK,      0.000000000000000_REALK, &
      0.038516420294047_REALK,      0.000000000000000_REALK,      0.019004152831195_REALK, &
      0.000000000000000_REALK,     -0.080378846155887_REALK,      0.000000000000000_REALK, &
     -0.129079424608157_REALK,      0.000000000000000_REALK,     -0.022425757517440_REALK, &
      0.000000000000000_REALK,     -0.299600316645864_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.065127314242706_REALK,      0.000000000000000_REALK, &
     -0.010619495681815_REALK,      0.000000000000000_REALK,     -0.029554261278386_REALK, &
      0.000000000000000_REALK,     -0.142234193697442_REALK,      0.000000000000000_REALK, &
      0.438202395719496_REALK,      0.000000000000000_REALK,      0.082121156490444_REALK, &
      0.000000000000000_REALK,     -0.064490020748418_REALK,      0.000000000000000_REALK, &
     -0.059424527399325_REALK,      0.000000000000000_REALK,      0.067391959411600_REALK, &
      0.102339789805014_REALK,      0.000000000000000_REALK,     -0.014783907232983_REALK, &
      0.000000000000000_REALK,      0.028658285106597_REALK,      0.000000000000000_REALK, &
      0.062424165293934_REALK,      0.000000000000000_REALK,      0.131187747495482_REALK, &
     -0.133082804011144_REALK,      0.000000000000000_REALK,     -0.121513065100330_REALK, &
      0.000000000000000_REALK,      0.077528746219312_REALK,      0.000000000000000_REALK, &
      0.183882343728359_REALK,      0.000000000000000_REALK,      0.441647084510408_REALK, &
     -0.035629506821109_REALK,      0.000000000000000_REALK,     -0.084195480268485_REALK, &
      0.000000000000000_REALK,     -0.047877587976614_REALK,      0.000000000000000_REALK, &
      0.013842613977211_REALK,      0.000000000000000_REALK,      0.275481158408699_REALK, &
      0.000000000000000_REALK,      0.498251952804759_REALK,      0.000000000000000_REALK, &
      0.312679342978283_REALK,      0.000000000000000_REALK,      0.094579209240148_REALK, &
      0.000000000000000_REALK,      0.076314724205079_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.592261660112101_REALK,      0.000000000000000_REALK, &
      0.334902594751938_REALK,      0.000000000000000_REALK,      0.102644026924604_REALK, &
      0.000000000000000_REALK,      0.193048552691334_REALK,      0.000000000000000_REALK, &
     -0.018286546275021_REALK,      0.000000000000000_REALK,     -0.059540124984525_REALK, &
      0.000000000000000_REALK,     -0.165196114492659_REALK,      0.000000000000000_REALK, &
     -0.249438037610634_REALK,      0.000000000000000_REALK,     -0.036891953575927_REALK, &
     -0.108977017606367_REALK,      0.000000000000000_REALK,      0.052488395009638_REALK, &
      0.000000000000000_REALK,     -0.363538219849636_REALK,      0.000000000000000_REALK, &
     -0.432413132422907_REALK,      0.000000000000000_REALK,     -0.073554577752819_REALK, &
      0.000000000000000_REALK,      0.008321801651810_REALK,      0.000000000000000_REALK, &
     -0.127473033197689_REALK,      0.000000000000000_REALK,      0.038647800349355_REALK, &
      0.000000000000000_REALK,     -0.046867833102663_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.064772901644886_REALK,      0.000000000000000_REALK, &
     -0.181777769273216_REALK,      0.000000000000000_REALK,      0.096628691610222_REALK, &
      0.000000000000000_REALK,      0.123667804528307_REALK,      0.000000000000000_REALK, &
      0.019219775409062_REALK,      0.000000000000000_REALK,     -0.130901240090891_REALK, &
      0.000000000000000_REALK,      0.067882111496657_REALK,      0.000000000000000_REALK, &
      0.100833034491170_REALK,      0.000000000000000_REALK,      0.061634336125351_REALK, &
      0.006643130708873_REALK,      0.000000000000000_REALK,     -0.155439600249476_REALK, &
      0.000000000000000_REALK,      0.098530789163925_REALK,      0.000000000000000_REALK, &
      0.097983313063866_REALK,      0.000000000000000_REALK,      0.045531524335991_REALK, &
      0.000000000000000_REALK,     -0.097776867659300_REALK,      0.000000000000000_REALK, &
     -0.013764464179871_REALK,      0.000000000000000_REALK,     -0.054435685057483_REALK, &
      0.000000000000000_REALK,      0.006608159610930_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.045850850007422_REALK,      0.000000000000000_REALK, &
     -0.026148046625531_REALK,      0.000000000000000_REALK,     -0.096092516837452_REALK, &
      0.000000000000000_REALK,     -0.043593388198850_REALK,      0.000000000000000_REALK, &
     -0.002073088209387_REALK,      0.000000000000000_REALK,     -0.021077964226480_REALK, &
      0.000000000000000_REALK,     -0.007461327829686_REALK,      0.000000000000000_REALK, &
     -0.009825219869295_REALK,      0.000000000000000_REALK,      0.008609888548280_REALK, &
     -0.002805151576133_REALK,      0.000000000000000_REALK,     -0.112412808313772_REALK, &
      0.000000000000000_REALK,      0.055608933449128_REALK,      0.000000000000000_REALK, &
     -0.026831649557498_REALK,      0.000000000000000_REALK,      0.017103094546813_REALK, &
      0.000000000000000_REALK,     -0.028769660964310_REALK,      0.000000000000000_REALK, &
      0.085685886428359_REALK,      0.000000000000000_REALK,      0.029297456835313_REALK, &
      0.000000000000000_REALK,     -0.060185631219580_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.013428881005203_REALK,      0.000000000000000_REALK, &
      0.096074545076573_REALK,      0.000000000000000_REALK,      0.064103198983829_REALK, &
      0.000000000000000_REALK,     -0.084942834537100_REALK,      0.000000000000000_REALK, &
      0.047385405567904_REALK,      0.000000000000000_REALK,     -0.248765070263050_REALK, &
      0.000000000000000_REALK,      0.088339549346487_REALK,      0.000000000000000_REALK, &
      0.204957146713687_REALK,      0.000000000000000_REALK,      0.056308939660522_REALK, &
     -0.041246476789395_REALK,      0.000000000000000_REALK,     -0.319620172285617_REALK, &
      0.000000000000000_REALK,     -0.017157323920517_REALK,      0.000000000000000_REALK, &
      0.085587582221287_REALK,      0.000000000000000_REALK,      0.051327238832626_REALK, &
      0.000000000000000_REALK,     -0.071936697974644_REALK,      0.000000000000000_REALK, &
      0.011444447276275_REALK,      0.000000000000000_REALK,     -0.110902035634008_REALK, &
      0.000000000000000_REALK,     -0.316756184095383_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.202916949387631_REALK,      0.000000000000000_REALK, &
      0.382997760277044_REALK,      0.000000000000000_REALK,     -0.060934723777596_REALK, &
      0.000000000000000_REALK,     -0.153682524978595_REALK,      0.000000000000000_REALK, &
      0.277582909485610_REALK,      0.000000000000000_REALK,      0.003452037521793_REALK, &
      0.000000000000000_REALK,      0.096711770766848_REALK,      0.000000000000000_REALK, &
      0.166258415839998_REALK,      0.000000000000000_REALK,      0.125654849408667_REALK, &
      0.118570916877403_REALK,      0.000000000000000_REALK,     -0.031896386609187_REALK, &
      0.000000000000000_REALK,      0.200304013905365_REALK,      0.000000000000000_REALK, &
      0.317079822424344_REALK,      0.000000000000000_REALK,      0.433235907299120_REALK/
  ! results of test 4, ket-major order, 02 DPG Y
  data REF_CONTR_INTS(7129:7524) /                                                         &
      0.100921796740223_REALK,      0.000000000000000_REALK,      0.029844290511706_REALK, &
      0.000000000000000_REALK,     -0.009938235752917_REALK,      0.000000000000000_REALK, &
     -0.046236752314719_REALK,      0.000000000000000_REALK,      0.229890301150686_REALK, &
      0.085173226277373_REALK,      0.000000000000000_REALK,     -0.024458835376405_REALK, &
      0.000000000000000_REALK,     -0.001176010940653_REALK,      0.000000000000000_REALK, &
      0.037858267188628_REALK,      0.000000000000000_REALK,      0.096034864508532_REALK, &
      0.000000000000000_REALK,      0.099479074272634_REALK,      0.000000000000000_REALK, &
     -0.062201097489341_REALK,      0.000000000000000_REALK,      0.022634675650392_REALK, &
      0.000000000000000_REALK,     -0.169087472907424_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.088122776774182_REALK,      0.000000000000000_REALK, &
     -0.034599040835647_REALK,      0.000000000000000_REALK,      0.012045456371246_REALK, &
      0.000000000000000_REALK,     -0.136016294704581_REALK,      0.000000000000000_REALK, &
      0.040730212513756_REALK,      0.000000000000000_REALK,     -0.086637414450303_REALK, &
      0.000000000000000_REALK,      0.053550248884407_REALK,      0.000000000000000_REALK, &
     -0.021526708964566_REALK,      0.000000000000000_REALK,      0.007005143728519_REALK, &
      0.033366953670650_REALK,      0.000000000000000_REALK,     -0.101520318145716_REALK, &
      0.000000000000000_REALK,      0.024292728893629_REALK,      0.000000000000000_REALK, &
      0.029859201048162_REALK,      0.000000000000000_REALK,      0.056012238453371_REALK, &
      0.000000000000000_REALK,     -0.023379730060996_REALK,      0.000000000000000_REALK, &
      0.019164522585897_REALK,      0.000000000000000_REALK,      0.101713194627774_REALK, &
      0.000000000000000_REALK,     -0.081927730106362_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.070055935717384_REALK,      0.000000000000000_REALK, &
      0.006636624964795_REALK,      0.000000000000000_REALK,      0.036354446341487_REALK, &
      0.000000000000000_REALK,     -0.033908952993970_REALK,      0.000000000000000_REALK, &
      0.041097291160712_REALK,      0.000000000000000_REALK,      0.008546390306343_REALK, &
      0.000000000000000_REALK,     -0.066895906138091_REALK,      0.000000000000000_REALK, &
      0.079670617820693_REALK,      0.000000000000000_REALK,     -0.035154490030401_REALK, &
      0.033213557018790_REALK,      0.000000000000000_REALK,     -0.044882425796855_REALK, &
      0.000000000000000_REALK,     -0.035945327095935_REALK,      0.000000000000000_REALK, &
      0.043840843997748_REALK,      0.000000000000000_REALK,      0.029152457145609_REALK, &
      0.000000000000000_REALK,      0.000380646634097_REALK,      0.000000000000000_REALK, &
     -0.010372477483232_REALK,      0.000000000000000_REALK,     -0.077030531589539_REALK, &
      0.000000000000000_REALK,      0.054119450830775_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.064448512968441_REALK,      0.000000000000000_REALK, &
      0.012446260562051_REALK,      0.000000000000000_REALK,     -0.031254595511183_REALK, &
      0.000000000000000_REALK,      0.010428080614977_REALK,      0.000000000000000_REALK, &
      0.013116161430887_REALK,      0.000000000000000_REALK,      0.045662253335534_REALK, &
      0.000000000000000_REALK,     -0.065347943167225_REALK,      0.000000000000000_REALK, &
      0.055711668975837_REALK,      0.000000000000000_REALK,     -0.022085542511499_REALK, &
      0.008731312801332_REALK,      0.000000000000000_REALK,      0.001406033768730_REALK, &
      0.000000000000000_REALK,     -0.024149529321347_REALK,      0.000000000000000_REALK, &
      0.025104004793916_REALK,      0.000000000000000_REALK,      0.002352695194742_REALK, &
      0.000000000000000_REALK,     -0.053091113554354_REALK,      0.000000000000000_REALK, &
      0.033315860773360_REALK,      0.000000000000000_REALK,     -0.013693762409351_REALK, &
      0.000000000000000_REALK,      0.062893418058992_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.068752780180519_REALK,      0.000000000000000_REALK, &
      0.036477944547917_REALK,      0.000000000000000_REALK,     -0.024759536638946_REALK, &
      0.000000000000000_REALK,     -0.003098933906145_REALK,      0.000000000000000_REALK, &
      0.035027620756227_REALK,      0.000000000000000_REALK,     -0.018848737714505_REALK, &
      0.000000000000000_REALK,     -0.048565729904241_REALK,      0.000000000000000_REALK, &
      0.101381751307699_REALK,      0.000000000000000_REALK,     -0.074063571618347_REALK, &
      0.054269816300785_REALK,      0.000000000000000_REALK,     -0.029870549704049_REALK, &
      0.000000000000000_REALK,     -0.011755278719885_REALK,      0.000000000000000_REALK, &
      0.108703023155942_REALK,      0.000000000000000_REALK,      0.019058070945279_REALK, &
      0.000000000000000_REALK,     -0.110429420230976_REALK,      0.000000000000000_REALK, &
      0.006078898645816_REALK,      0.000000000000000_REALK,      0.062802678963377_REALK, &
      0.000000000000000_REALK,     -0.110855668792238_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.127605397156591_REALK,      0.000000000000000_REALK, &
     -0.052525475081361_REALK,      0.000000000000000_REALK,     -0.048716543446776_REALK, &
      0.000000000000000_REALK,     -0.080225818017485_REALK,      0.000000000000000_REALK, &
      0.225500080862526_REALK,      0.000000000000000_REALK,     -0.027082765105900_REALK, &
      0.000000000000000_REALK,     -0.024496537512597_REALK,      0.000000000000000_REALK, &
      0.015958817771284_REALK,      0.000000000000000_REALK,     -0.122241440511385_REALK, &
      0.187612743979762_REALK,      0.000000000000000_REALK,      0.019517256365509_REALK, &
      0.000000000000000_REALK,     -0.033544470948157_REALK,      0.000000000000000_REALK, &
     -0.024206882421355_REALK,      0.000000000000000_REALK,     -0.080810907935707_REALK, &
     -0.097519491884153_REALK,      0.000000000000000_REALK,     -0.083649286021898_REALK, &
      0.000000000000000_REALK,     -0.042289889392345_REALK,      0.000000000000000_REALK, &
     -0.034998386360164_REALK,      0.000000000000000_REALK,      0.057029229586240_REALK, &
      0.055176906408869_REALK,      0.000000000000000_REALK,     -0.159900095238988_REALK, &
      0.000000000000000_REALK,     -0.028258201027064_REALK,      0.000000000000000_REALK, &
      0.041281369098481_REALK,      0.000000000000000_REALK,      0.217867669591208_REALK, &
      0.000000000000000_REALK,      0.268214628190276_REALK,      0.000000000000000_REALK, &
     -0.043959665500118_REALK,      0.000000000000000_REALK,      0.112175771327547_REALK, &
      0.000000000000000_REALK,      0.040255838100607_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.255957505069156_REALK,      0.000000000000000_REALK, &
     -0.029770905298545_REALK,      0.000000000000000_REALK,      0.098153140226945_REALK, &
      0.000000000000000_REALK,      0.054733820105279_REALK,      0.000000000000000_REALK, &
     -0.005153525469108_REALK,      0.000000000000000_REALK,     -0.086789181321611_REALK, &
      0.000000000000000_REALK,     -0.012045869540073_REALK,      0.000000000000000_REALK, &
     -0.088964380021055_REALK,      0.000000000000000_REALK,      0.089438554245228_REALK, &
     -0.022057912982369_REALK,      0.000000000000000_REALK,     -0.236707279973921_REALK, &
      0.000000000000000_REALK,     -0.063438097830733_REALK,      0.000000000000000_REALK, &
      0.000231955990576_REALK,      0.000000000000000_REALK,      0.185227456615065_REALK, &
      0.000000000000000_REALK,      0.166141865405855_REALK,      0.000000000000000_REALK, &
     -0.019422077172822_REALK,      0.000000000000000_REALK,      0.093298289279447_REALK, &
      0.000000000000000_REALK,      0.031675298931971_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.179026123185598_REALK,      0.000000000000000_REALK, &
      0.023754126277618_REALK,      0.000000000000000_REALK,      0.173447910422755_REALK, &
      0.000000000000000_REALK,      0.090953717919708_REALK,      0.000000000000000_REALK, &
      0.016828315740440_REALK,      0.000000000000000_REALK,     -0.154622562924882_REALK, &
      0.000000000000000_REALK,     -0.051748725945701_REALK,      0.000000000000000_REALK, &
      0.048358240226830_REALK,      0.000000000000000_REALK,      0.093607574297101_REALK, &
     -0.070709477932837_REALK,      0.000000000000000_REALK,     -0.300310227290741_REALK, &
      0.000000000000000_REALK,     -0.069280347195736_REALK,      0.000000000000000_REALK, &
     -0.053587133383781_REALK,      0.000000000000000_REALK,      0.127584591233523_REALK, &
      0.000000000000000_REALK,     -0.124229916928424_REALK,      0.000000000000000_REALK, &
      0.034821144146508_REALK,      0.000000000000000_REALK,     -0.081115952433334_REALK, &
      0.000000000000000_REALK,     -0.063393973826509_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.102772213224721_REALK,      0.000000000000000_REALK, &
      0.073341820445597_REALK,      0.000000000000000_REALK,     -0.123275310437042_REALK, &
      0.000000000000000_REALK,     -0.162699430641332_REALK,      0.000000000000000_REALK, &
      0.015187419825930_REALK,      0.000000000000000_REALK,     -0.052966064339078_REALK, &
      0.000000000000000_REALK,     -0.024173808081781_REALK,      0.000000000000000_REALK, &
      0.059785859707693_REALK,      0.000000000000000_REALK,      0.030539351312020_REALK, &
     -0.018683609493155_REALK,      0.000000000000000_REALK,     -0.126308070873810_REALK, &
      0.000000000000000_REALK,     -0.000255279764937_REALK,      0.000000000000000_REALK, &
      0.016822607803186_REALK,      0.000000000000000_REALK,      0.037369482729790_REALK, &
      0.000000000000000_REALK,     -0.107425566429708_REALK,      0.000000000000000_REALK, &
      0.063129914933939_REALK,      0.000000000000000_REALK,     -0.017343664677225_REALK, &
      0.000000000000000_REALK,     -0.082825650430359_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.126317579331478_REALK,      0.000000000000000_REALK, &
      0.158011394760257_REALK,      0.000000000000000_REALK,     -0.057695733447296_REALK, &
      0.000000000000000_REALK,     -0.249255536478293_REALK,      0.000000000000000_REALK, &
      0.054570359807679_REALK,      0.000000000000000_REALK,     -0.193736471959700_REALK, &
      0.000000000000000_REALK,     -0.065355920541080_REALK,      0.000000000000000_REALK, &
      0.115579846573975_REALK,      0.000000000000000_REALK,      0.103084566103494_REALK, &
      0.021120369322596_REALK,      0.000000000000000_REALK,     -0.272223850933726_REALK, &
      0.000000000000000_REALK,     -0.022644651006926_REALK,      0.000000000000000_REALK, &
      0.224058684651408_REALK,      0.000000000000000_REALK,      0.123304295087628_REALK, &
      0.000000000000000_REALK,      0.050453293328227_REALK,      0.000000000000000_REALK, &
      0.070437307647085_REALK,      0.000000000000000_REALK,     -0.042928120762744_REALK, &
      0.000000000000000_REALK,     -0.160183579332926_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.255931396917542_REALK,      0.000000000000000_REALK, &
      0.025131121194860_REALK,      0.000000000000000_REALK,     -0.144035252497515_REALK, &
      0.000000000000000_REALK,     -0.208759694759175_REALK,      0.000000000000000_REALK, &
      0.194628325011469_REALK,      0.000000000000000_REALK,     -0.070465405531587_REALK, &
      0.000000000000000_REALK,     -0.013426103283729_REALK,      0.000000000000000_REALK, &
      0.072277904395112_REALK,      0.000000000000000_REALK,      0.207291135403646_REALK, &
      0.139771662398810_REALK,      0.000000000000000_REALK,     -0.018205444114005_REALK, &
      0.000000000000000_REALK,     -0.034926169815559_REALK,      0.000000000000000_REALK, &
     -0.012709814831567_REALK,      0.000000000000000_REALK,      0.060284492624991_REALK/
  ! results of test 4, ket-major order, 02 DPG Z
  data REF_CONTR_INTS(7525:7920) /                                                         &
      0.000000000000000_REALK,      0.058675245014502_REALK,      0.000000000000000_REALK, &
     -0.012146528615228_REALK,      0.000000000000000_REALK,     -0.003458513499154_REALK, &
      0.000000000000000_REALK,     -0.082977189818993_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.036012269357808_REALK,      0.000000000000000_REALK, &
      0.023458736062415_REALK,      0.000000000000000_REALK,      0.004416019060699_REALK, &
      0.000000000000000_REALK,     -0.006994347230922_REALK,      0.000000000000000_REALK, &
     -0.082143518032607_REALK,      0.000000000000000_REALK,     -0.062097063170249_REALK, &
      0.000000000000000_REALK,      0.033256778002681_REALK,      0.000000000000000_REALK, &
      0.009730793611666_REALK,      0.000000000000000_REALK,      0.108683196480275_REALK, &
     -0.124293222689598_REALK,      0.000000000000000_REALK,     -0.043535862291289_REALK, &
      0.000000000000000_REALK,     -0.003120746699759_REALK,      0.000000000000000_REALK, &
     -0.003275497285562_REALK,      0.000000000000000_REALK,      0.047286417720790_REALK, &
      0.000000000000000_REALK,      0.077216594744394_REALK,      0.000000000000000_REALK, &
      0.005283042130954_REALK,      0.000000000000000_REALK,      0.002971702355701_REALK, &
      0.000000000000000_REALK,     -0.001209932425067_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.102249304679759_REALK,      0.000000000000000_REALK, &
      0.052071262544694_REALK,      0.000000000000000_REALK,      0.051505475714400_REALK, &
      0.000000000000000_REALK,      0.079730455849945_REALK,      0.000000000000000_REALK, &
      0.016913554854600_REALK,      0.000000000000000_REALK,     -0.009510865893657_REALK, &
      0.000000000000000_REALK,      0.004305133169332_REALK,      0.000000000000000_REALK, &
     -0.016808050057157_REALK,      0.000000000000000_REALK,      0.040030275296102_REALK, &
     -0.026928719245109_REALK,      0.000000000000000_REALK,      0.008357035636557_REALK, &
      0.000000000000000_REALK,     -0.005304154460566_REALK,      0.000000000000000_REALK, &
     -0.080278226781759_REALK,      0.000000000000000_REALK,     -0.016973952359671_REALK, &
      0.000000000000000_REALK,     -0.019739137506485_REALK,      0.000000000000000_REALK, &
     -0.006149625492355_REALK,      0.000000000000000_REALK,      0.010875309169398_REALK, &
      0.000000000000000_REALK,     -0.046867372568386_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.066420765579767_REALK,      0.000000000000000_REALK, &
     -0.031269228532617_REALK,      0.000000000000000_REALK,     -0.004049361037022_REALK, &
      0.000000000000000_REALK,     -0.029526766275799_REALK,      0.000000000000000_REALK, &
      0.014973490535609_REALK,      0.000000000000000_REALK,      0.021863024139349_REALK, &
      0.000000000000000_REALK,     -0.016509730916256_REALK,      0.000000000000000_REALK, &
      0.015817475019883_REALK,      0.000000000000000_REALK,     -0.024753788980029_REALK, &
      0.027076399494901_REALK,      0.000000000000000_REALK,      0.001517100045340_REALK, &
      0.000000000000000_REALK,     -0.016479473021137_REALK,      0.000000000000000_REALK, &
      0.029066511929906_REALK,      0.000000000000000_REALK,      0.013918754013626_REALK, &
      0.000000000000000_REALK,     -0.046315449520676_REALK,      0.000000000000000_REALK, &
      0.010875309169398_REALK,      0.000000000000000_REALK,      0.018912254144498_REALK, &
      0.000000000000000_REALK,      0.005584656430533_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.040545764614290_REALK,      0.000000000000000_REALK, &
     -0.004049361037022_REALK,      0.000000000000000_REALK,      0.004167176819023_REALK, &
      0.000000000000000_REALK,     -0.017675884445875_REALK,      0.000000000000000_REALK, &
      0.012104348371149_REALK,      0.000000000000000_REALK,     -0.016808050057157_REALK, &
      0.000000000000000_REALK,      0.002541062885972_REALK,      0.000000000000000_REALK, &
      0.004073318678840_REALK,      0.000000000000000_REALK,     -0.033050949138251_REALK, &
      0.029017536861217_REALK,      0.000000000000000_REALK,     -0.080278226781759_REALK, &
      0.000000000000000_REALK,      0.017495152740627_REALK,      0.000000000000000_REALK, &
      0.017652775577367_REALK,      0.000000000000000_REALK,      0.038301571497107_REALK, &
      0.000000000000000_REALK,     -0.001209932425067_REALK,      0.000000000000000_REALK, &
     -0.010554669395872_REALK,      0.000000000000000_REALK,     -0.003419366947989_REALK, &
      0.000000000000000_REALK,     -0.093260551149034_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.079730455849944_REALK,      0.000000000000000_REALK, &
      0.007374519224152_REALK,      0.000000000000000_REALK,     -0.014435580808131_REALK, &
      0.000000000000000_REALK,     -0.113421247256952_REALK,      0.000000000000000_REALK, &
      0.108683196480275_REALK,      0.000000000000000_REALK,      0.006810509471059_REALK, &
      0.000000000000000_REALK,     -0.009928709033541_REALK,      0.000000000000000_REALK, &
      0.057440231229197_REALK,      0.000000000000000_REALK,      0.085906180496169_REALK, &
      0.047286417720790_REALK,      0.000000000000000_REALK,     -0.038081930158594_REALK, &
      0.000000000000000_REALK,      0.023914746017519_REALK,      0.000000000000000_REALK, &
      0.060862831968580_REALK,      0.000000000000000_REALK,      0.081912157409966_REALK, &
      0.000000000000000_REALK,     -0.077648972593944_REALK,      0.000000000000000_REALK, &
     -0.030439957475166_REALK,      0.000000000000000_REALK,     -0.009933229790317_REALK, &
      0.000000000000000_REALK,     -0.065507604972925_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.021973723951375_REALK,      0.000000000000000_REALK, &
      0.002972254698025_REALK,      0.000000000000000_REALK,     -0.009957071544293_REALK, &
      0.000000000000000_REALK,     -0.027149336202667_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.222689148195514_REALK,      0.000000000000000_REALK, &
      0.137469015769015_REALK,      0.000000000000000_REALK,      0.025693758180744_REALK, &
      0.000000000000000_REALK,     -0.049285789811448_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.176207506019065_REALK,      0.000000000000000_REALK, &
      0.155794255337386_REALK,      0.000000000000000_REALK,      0.026312606473376_REALK, &
      0.000000000000000_REALK,     -0.041028377256763_REALK,      0.000000000000000_REALK, &
     -0.125958510845010_REALK,      0.000000000000000_REALK,     -0.180097149071124_REALK, &
      0.000000000000000_REALK,     -0.088719329828147_REALK,      0.000000000000000_REALK, &
     -0.104939010780984_REALK,      0.000000000000000_REALK,      0.050582857649567_REALK, &
     -0.161184866881878_REALK,      0.000000000000000_REALK,     -0.172783542139085_REALK, &
      0.000000000000000_REALK,     -0.230699772584642_REALK,      0.000000000000000_REALK, &
     -0.252960561785160_REALK,      0.000000000000000_REALK,      0.048103381088048_REALK, &
      0.000000000000000_REALK,      0.085105237508218_REALK,      0.000000000000000_REALK, &
      0.036032053081110_REALK,      0.000000000000000_REALK,      0.131739878471040_REALK, &
      0.000000000000000_REALK,      0.047803372285785_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.286210103093993_REALK,      0.000000000000000_REALK, &
      0.019561376729839_REALK,      0.000000000000000_REALK,      0.197754367573046_REALK, &
      0.000000000000000_REALK,      0.248747981969004_REALK,      0.000000000000000_REALK, &
     -0.026257829616991_REALK,      0.000000000000000_REALK,     -0.097444328675397_REALK, &
      0.000000000000000_REALK,      0.028210209230277_REALK,      0.000000000000000_REALK, &
     -0.030718392408736_REALK,      0.000000000000000_REALK,     -0.011986377315625_REALK, &
     -0.052090849276732_REALK,      0.000000000000000_REALK,      0.084024091782837_REALK, &
      0.000000000000000_REALK,     -0.110183607869135_REALK,      0.000000000000000_REALK, &
     -0.259116448437086_REALK,      0.000000000000000_REALK,     -0.107841898228290_REALK, &
      0.000000000000000_REALK,      0.050716460136148_REALK,      0.000000000000000_REALK, &
      0.029332991885744_REALK,      0.000000000000000_REALK,     -0.028443179054541_REALK, &
      0.000000000000000_REALK,     -0.059822369213999_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.158507852391903_REALK,      0.000000000000000_REALK, &
      0.024850781501560_REALK,      0.000000000000000_REALK,      0.048963713029716_REALK, &
      0.000000000000000_REALK,      0.086164188424299_REALK,      0.000000000000000_REALK, &
      0.028814052822860_REALK,      0.000000000000000_REALK,      0.075188492107598_REALK, &
      0.000000000000000_REALK,     -0.007840913506967_REALK,      0.000000000000000_REALK, &
      0.046511062399091_REALK,      0.000000000000000_REALK,      0.010198849372856_REALK, &
     -0.004146498295605_REALK,      0.000000000000000_REALK,     -0.069911082042690_REALK, &
      0.000000000000000_REALK,      0.056488381807345_REALK,      0.000000000000000_REALK, &
      0.062034592059957_REALK,      0.000000000000000_REALK,      0.084508292354760_REALK, &
      0.000000000000000_REALK,      0.021003927839029_REALK,      0.000000000000000_REALK, &
     -0.028443179054541_REALK,      0.000000000000000_REALK,     -0.053888335447825_REALK, &
      0.000000000000000_REALK,     -0.018859979843318_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.127264318829819_REALK,      0.000000000000000_REALK, &
      0.048963713029716_REALK,      0.000000000000000_REALK,      0.067600038569255_REALK, &
      0.000000000000000_REALK,     -0.014781373160417_REALK,      0.000000000000000_REALK, &
      0.030226857045835_REALK,      0.000000000000000_REALK,     -0.030718392408736_REALK, &
      0.000000000000000_REALK,     -0.011354993187742_REALK,      0.000000000000000_REALK, &
      0.019068512427555_REALK,      0.000000000000000_REALK,      0.034509888262603_REALK, &
     -0.006375079396467_REALK,      0.000000000000000_REALK,     -0.259116448437086_REALK, &
      0.000000000000000_REALK,     -0.028357600104656_REALK,      0.000000000000000_REALK, &
      0.067505132712968_REALK,      0.000000000000000_REALK,      0.136514787944504_REALK, &
      0.000000000000000_REALK,      0.047803372285785_REALK,      0.000000000000000_REALK, &
      0.136804075435983_REALK,      0.000000000000000_REALK,     -0.017216220754922_REALK, &
      0.000000000000000_REALK,     -0.147022350137943_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.248747981969004_REALK,      0.000000000000000_REALK, &
      0.328377966397705_REALK,      0.000000000000000_REALK,      0.002136195554627_REALK, &
      0.000000000000000_REALK,     -0.145484191737012_REALK,      0.000000000000000_REALK, &
      0.050582857649567_REALK,      0.000000000000000_REALK,     -0.173580405143067_REALK, &
      0.000000000000000_REALK,      0.103618495671803_REALK,      0.000000000000000_REALK, &
      0.247534307329335_REALK,      0.000000000000000_REALK,      0.081855399077837_REALK, &
      0.048103381088048_REALK,      0.000000000000000_REALK,     -0.191786089441533_REALK, &
      0.000000000000000_REALK,      0.076850782452595_REALK,      0.000000000000000_REALK, &
      0.233394827665036_REALK,      0.000000000000000_REALK,      0.208891445435731_REALK, &
      0.000000000000000_REALK,     -0.143048221900874_REALK,      0.000000000000000_REALK, &
      0.005201701415831_REALK,      0.000000000000000_REALK,     -0.062705241367881_REALK, &
      0.000000000000000_REALK,     -0.172402043191796_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.034787055173887_REALK,      0.000000000000000_REALK, &
      0.144802535362044_REALK,      0.000000000000000_REALK,     -0.053372783847488_REALK, &
      0.000000000000000_REALK,     -0.115429952887864_REALK,      0.000000000000000_REALK/
  ! results of test 4, ket-major order, 03 DPG X
  data REF_CONTR_INTS(7921:8316) /                                                         &
      0.000000000000000_REALK,     -0.084342141350406_REALK,      0.000000000000000_REALK, &
     -0.064464506990999_REALK,      0.000000000000000_REALK,      0.012634524543530_REALK, &
      0.000000000000000_REALK,     -0.181639315457364_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.008644386201250_REALK,      0.000000000000000_REALK, &
      0.013086803019187_REALK,      0.000000000000000_REALK,      0.009711998861734_REALK, &
      0.000000000000000_REALK,     -0.076804343035423_REALK,      0.000000000000000_REALK, &
     -0.097590299109227_REALK,      0.000000000000000_REALK,     -0.168837651840904_REALK, &
      0.000000000000000_REALK,      0.094196394919501_REALK,      0.000000000000000_REALK, &
      0.127425432061376_REALK,      0.000000000000000_REALK,     -0.136911910869619_REALK, &
     -0.003536263655944_REALK,      0.000000000000000_REALK,     -0.076824498006421_REALK, &
      0.000000000000000_REALK,     -0.005766481953177_REALK,      0.000000000000000_REALK, &
      0.066995854907880_REALK,      0.000000000000000_REALK,     -0.073304522999577_REALK, &
      0.000000000000000_REALK,     -0.129791705410780_REALK,      0.000000000000000_REALK, &
      0.198387840062707_REALK,      0.000000000000000_REALK,      0.177479705348690_REALK, &
      0.000000000000000_REALK,      0.165258615909015_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.063159040182261_REALK,      0.000000000000000_REALK, &
      0.067552479741280_REALK,      0.000000000000000_REALK,      0.087433793675212_REALK, &
      0.000000000000000_REALK,      0.031510243518099_REALK,      0.000000000000000_REALK, &
     -0.022567086893571_REALK,      0.000000000000000_REALK,      0.251816154165774_REALK, &
      0.000000000000000_REALK,     -0.231443510588356_REALK,      0.000000000000000_REALK, &
      0.066106783892080_REALK,      0.000000000000000_REALK,      0.042644477061214_REALK, &
      0.005054717208617_REALK,      0.000000000000000_REALK,      0.084430570345490_REALK, &
      0.000000000000000_REALK,     -0.095159367726904_REALK,      0.000000000000000_REALK, &
      0.060299005971840_REALK,      0.000000000000000_REALK,     -0.001581979517682_REALK, &
      0.000000000000000_REALK,      0.100829537949887_REALK,      0.000000000000000_REALK, &
     -0.111792160077922_REALK,      0.000000000000000_REALK,     -0.174461642666230_REALK, &
      0.000000000000000_REALK,     -0.011300172903144_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.021418317465409_REALK,      0.000000000000000_REALK, &
     -0.033947266087167_REALK,      0.000000000000000_REALK,     -0.076364202006410_REALK, &
      0.000000000000000_REALK,      0.009755649142342_REALK,      0.000000000000000_REALK, &
     -0.021687365530156_REALK,      0.000000000000000_REALK,     -0.225844693482139_REALK, &
      0.000000000000000_REALK,      0.229335853399153_REALK,      0.000000000000000_REALK, &
      0.003186722749854_REALK,      0.000000000000000_REALK,     -0.012352725359834_REALK, &
     -0.014422546963421_REALK,      0.000000000000000_REALK,     -0.092226357296274_REALK, &
      0.000000000000000_REALK,      0.137714383537297_REALK,      0.000000000000000_REALK, &
      0.046033647942070_REALK,      0.000000000000000_REALK,      0.030455161697981_REALK, &
      0.000000000000000_REALK,      0.066955937100537_REALK,      0.000000000000000_REALK, &
     -0.263610140565145_REALK,      0.000000000000000_REALK,     -0.224146984245879_REALK, &
      0.000000000000000_REALK,     -0.152576493004156_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.051210941739117_REALK,      0.000000000000000_REALK, &
     -0.187944829557942_REALK,      0.000000000000000_REALK,     -0.116986402884992_REALK, &
      0.000000000000000_REALK,     -0.051301776621821_REALK,      0.000000000000000_REALK, &
      0.084614636485354_REALK,      0.000000000000000_REALK,      0.149932694151862_REALK, &
      0.000000000000000_REALK,     -0.125544840511025_REALK,      0.000000000000000_REALK, &
     -0.143787370884043_REALK,      0.000000000000000_REALK,      0.032382184560475_REALK, &
      0.027068976650492_REALK,      0.000000000000000_REALK,      0.094775080914369_REALK, &
      0.000000000000000_REALK,     -0.116685293311740_REALK,      0.000000000000000_REALK, &
     -0.131003425166361_REALK,      0.000000000000000_REALK,     -0.030989460962714_REALK, &
      0.000000000000000_REALK,      0.146868320656304_REALK,      0.000000000000000_REALK, &
      0.080457207906518_REALK,      0.000000000000000_REALK,     -0.080964784154862_REALK, &
      0.000000000000000_REALK,      0.167222652626381_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.086738607832528_REALK,      0.000000000000000_REALK, &
      0.122934827112320_REALK,      0.000000000000000_REALK,     -0.041721407038979_REALK, &
      0.000000000000000_REALK,      0.123579845820354_REALK,      0.000000000000000_REALK, &
     -0.158050701342726_REALK,      0.000000000000000_REALK,      0.094765802995228_REALK, &
      0.000000000000000_REALK,     -0.049932754704182_REALK,      0.000000000000000_REALK, &
      0.155809510912487_REALK,      0.000000000000000_REALK,      0.066274256850105_REALK, &
     -0.074213302464650_REALK,      0.000000000000000_REALK,      0.007051812766937_REALK, &
      0.000000000000000_REALK,      0.032865442888087_REALK,      0.000000000000000_REALK, &
      0.150386923776587_REALK,      0.000000000000000_REALK,      0.021107353909334_REALK, &
      0.000000000000000_REALK,     -0.148392593300486_REALK,      0.000000000000000_REALK, &
     -0.002401916373333_REALK,      0.000000000000000_REALK,      0.021536720913786_REALK, &
      0.000000000000000_REALK,      0.055555718055564_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.097632734645186_REALK,      0.000000000000000_REALK, &
     -0.049247275182270_REALK,      0.000000000000000_REALK,     -0.034060654132012_REALK, &
      0.000000000000000_REALK,      0.009118621828818_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.102737584903160_REALK,      0.000000000000000_REALK, &
      0.035486090511220_REALK,      0.000000000000000_REALK,     -0.058932110437856_REALK, &
      0.000000000000000_REALK,     -0.076676219177197_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.042236176168685_REALK,      0.000000000000000_REALK, &
      0.185388620195658_REALK,      0.000000000000000_REALK,     -0.076188785576690_REALK, &
      0.000000000000000_REALK,     -0.041938224682343_REALK,      0.000000000000000_REALK, &
     -0.066392690981996_REALK,      0.000000000000000_REALK,     -0.117797524342586_REALK, &
      0.000000000000000_REALK,     -0.018052048368528_REALK,      0.000000000000000_REALK, &
      0.226508319540004_REALK,      0.000000000000000_REALK,     -0.092042853643248_REALK, &
      0.015356776048262_REALK,      0.000000000000000_REALK,     -0.102789698768311_REALK, &
      0.000000000000000_REALK,     -0.189705259188863_REALK,      0.000000000000000_REALK, &
      0.101453815102341_REALK,      0.000000000000000_REALK,     -0.165739951587671_REALK, &
      0.000000000000000_REALK,     -0.061022978843134_REALK,      0.000000000000000_REALK, &
      0.187722629341697_REALK,      0.000000000000000_REALK,      0.062368172688409_REALK, &
      0.000000000000000_REALK,      0.183965262421383_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.163234126014220_REALK,      0.000000000000000_REALK, &
      0.053197946233103_REALK,      0.000000000000000_REALK,      0.071494269703747_REALK, &
      0.000000000000000_REALK,      0.042393635893168_REALK,      0.000000000000000_REALK, &
      0.018532373541262_REALK,      0.000000000000000_REALK,      0.218698103674184_REALK, &
      0.000000000000000_REALK,     -0.220166581739717_REALK,      0.000000000000000_REALK, &
      0.056342579111170_REALK,      0.000000000000000_REALK,     -0.013309442225402_REALK, &
      0.042596761272343_REALK,      0.000000000000000_REALK,      0.086319569107995_REALK, &
      0.000000000000000_REALK,     -0.110509235680230_REALK,      0.000000000000000_REALK, &
      0.154338357742187_REALK,      0.000000000000000_REALK,      0.022114786916749_REALK, &
      0.000000000000000_REALK,     -0.009441334223102_REALK,      0.000000000000000_REALK, &
     -0.103101898753072_REALK,      0.000000000000000_REALK,     -0.244973359435273_REALK, &
      0.000000000000000_REALK,      0.044194098491503_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.011607531582681_REALK,      0.000000000000000_REALK, &
     -0.025420551084449_REALK,      0.000000000000000_REALK,     -0.206896837579224_REALK, &
      0.000000000000000_REALK,      0.017619349191157_REALK,      0.000000000000000_REALK, &
     -0.013446248737029_REALK,      0.000000000000000_REALK,     -0.163413690963546_REALK, &
      0.000000000000000_REALK,      0.368968583893870_REALK,      0.000000000000000_REALK, &
      0.144895542803031_REALK,      0.000000000000000_REALK,      0.089744929211495_REALK, &
      0.042373869678449_REALK,      0.000000000000000_REALK,     -0.010176528090133_REALK, &
      0.000000000000000_REALK,      0.411181688189563_REALK,      0.000000000000000_REALK, &
      0.272049984296227_REALK,      0.000000000000000_REALK,      0.077909973695079_REALK, &
      0.000000000000000_REALK,     -0.218052196438104_REALK,      0.000000000000000_REALK, &
     -0.497036368684725_REALK,      0.000000000000000_REALK,     -0.209574854745749_REALK, &
      0.000000000000000_REALK,     -0.061518565860540_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.316575244575746_REALK,      0.000000000000000_REALK, &
     -0.652547892436188_REALK,      0.000000000000000_REALK,     -0.169717040477894_REALK, &
      0.000000000000000_REALK,      0.087165508957705_REALK,      0.000000000000000_REALK, &
     -0.011043137820295_REALK,      0.000000000000000_REALK,      0.145528900648194_REALK, &
      0.000000000000000_REALK,     -0.217440552338417_REALK,      0.000000000000000_REALK, &
     -0.475053851440395_REALK,      0.000000000000000_REALK,     -0.096324163983648_REALK, &
     -0.076394040819279_REALK,      0.000000000000000_REALK,      0.092777278586148_REALK, &
      0.000000000000000_REALK,     -0.358435308331365_REALK,      0.000000000000000_REALK, &
     -0.557960128549820_REALK,      0.000000000000000_REALK,     -0.128319239774178_REALK, &
      0.000000000000000_REALK,      0.302632971498051_REALK,      0.000000000000000_REALK, &
      0.295151055282237_REALK,      0.000000000000000_REALK,     -0.128361568076952_REALK, &
      0.000000000000000_REALK,      0.176221832436960_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.281028769841542_REALK,      0.000000000000000_REALK, &
      0.470244606647436_REALK,      0.000000000000000_REALK,     -0.182854969949303_REALK, &
      0.000000000000000_REALK,      0.102604971600624_REALK,      0.000000000000000_REALK, &
     -0.102858132457357_REALK,      0.000000000000000_REALK,      0.085200774878102_REALK, &
      0.000000000000000_REALK,      0.186812072965736_REALK,      0.000000000000000_REALK, &
      0.252744179378753_REALK,      0.000000000000000_REALK,      0.173497651839011_REALK, &
     -0.023638242852293_REALK,      0.000000000000000_REALK,      0.095710696205796_REALK, &
      0.000000000000000_REALK,      0.299563063000534_REALK,      0.000000000000000_REALK, &
      0.352322408059353_REALK,      0.000000000000000_REALK,      0.113884460812892_REALK, &
      0.000000000000000_REALK,     -0.198719331725335_REALK,      0.000000000000000_REALK, &
     -0.151758931014151_REALK,      0.000000000000000_REALK,     -0.063738627038537_REALK, &
      0.000000000000000_REALK,      0.101649372396582_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.223995300796721_REALK,      0.000000000000000_REALK, &
     -0.143125242718991_REALK,      0.000000000000000_REALK,     -0.051653160013835_REALK, &
      0.000000000000000_REALK,      0.120639907636242_REALK,      0.000000000000000_REALK/
  ! results of test 4, ket-major order, 03 DPG Y
  data REF_CONTR_INTS(8317:8712) /                                                         &
      0.000000000000000_REALK,     -0.068175388469724_REALK,      0.000000000000000_REALK, &
      0.006876542471408_REALK,      0.000000000000000_REALK,      0.046788687179501_REALK, &
      0.000000000000000_REALK,     -0.068897272893091_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.061701007514896_REALK,      0.000000000000000_REALK, &
     -0.019183450493998_REALK,      0.000000000000000_REALK,     -0.029588493367285_REALK, &
      0.000000000000000_REALK,     -0.008298957728281_REALK,      0.000000000000000_REALK, &
     -0.057306666530131_REALK,      0.000000000000000_REALK,     -0.011883363478780_REALK, &
      0.000000000000000_REALK,     -0.043495736223840_REALK,      0.000000000000000_REALK, &
      0.107489440635906_REALK,      0.000000000000000_REALK,     -0.072692904843840_REALK, &
     -0.048089549314206_REALK,      0.000000000000000_REALK,     -0.016330395775111_REALK, &
      0.000000000000000_REALK,     -0.016468541646317_REALK,      0.000000000000000_REALK, &
      0.121929847727897_REALK,      0.000000000000000_REALK,     -0.009825241132279_REALK, &
      0.000000000000000_REALK,     -0.060382829046234_REALK,      0.000000000000000_REALK, &
      0.057353837421715_REALK,      0.000000000000000_REALK,      0.035767324245114_REALK, &
      0.000000000000000_REALK,      0.061320310721629_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.006309206450896_REALK,      0.000000000000000_REALK, &
      0.066001614964898_REALK,      0.000000000000000_REALK,     -0.043269041695019_REALK, &
      0.000000000000000_REALK,      0.096320254478440_REALK,      0.000000000000000_REALK, &
     -0.040211542735207_REALK,      0.000000000000000_REALK,      0.119544609203562_REALK, &
      0.000000000000000_REALK,     -0.139493625684286_REALK,      0.000000000000000_REALK, &
      0.107767663577570_REALK,      0.000000000000000_REALK,     -0.008256259266856_REALK, &
      0.000316528414965_REALK,      0.000000000000000_REALK,      0.057428951923765_REALK, &
      0.000000000000000_REALK,     -0.089744220783261_REALK,      0.000000000000000_REALK, &
      0.034744071833587_REALK,      0.000000000000000_REALK,     -0.020501617052783_REALK, &
      0.000000000000000_REALK,      0.074669718224564_REALK,      0.000000000000000_REALK, &
     -0.052583993643560_REALK,      0.000000000000000_REALK,     -0.161196225838851_REALK, &
      0.000000000000000_REALK,      0.066707237550016_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.003053454096299_REALK,      0.000000000000000_REALK, &
     -0.032653964487626_REALK,      0.000000000000000_REALK,     -0.139099340179309_REALK, &
      0.000000000000000_REALK,      0.061389873850333_REALK,      0.000000000000000_REALK, &
      0.028743466052237_REALK,      0.000000000000000_REALK,     -0.081124135909733_REALK, &
      0.000000000000000_REALK,      0.109195529359592_REALK,      0.000000000000000_REALK, &
     -0.100530310594680_REALK,      0.000000000000000_REALK,      0.014629914259503_REALK, &
     -0.009942842327741_REALK,      0.000000000000000_REALK,     -0.018970663847635_REALK, &
      0.000000000000000_REALK,      0.065568275810274_REALK,      0.000000000000000_REALK, &
     -0.095164012597045_REALK,      0.000000000000000_REALK,      0.012207798606828_REALK, &
      0.000000000000000_REALK,      0.073148738306892_REALK,      0.000000000000000_REALK, &
     -0.046059281177449_REALK,      0.000000000000000_REALK,     -0.107396114505063_REALK, &
      0.000000000000000_REALK,      0.019966663114537_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.034565247189209_REALK,      0.000000000000000_REALK, &
      0.005009117534163_REALK,      0.000000000000000_REALK,     -0.048367444193038_REALK, &
      0.000000000000000_REALK,      0.014347701049037_REALK,      0.000000000000000_REALK, &
      0.009753537635489_REALK,      0.000000000000000_REALK,     -0.000495060060421_REALK, &
      0.000000000000000_REALK,      0.048763427983056_REALK,      0.000000000000000_REALK, &
     -0.066412813971218_REALK,      0.000000000000000_REALK,      0.046211281925981_REALK, &
     -0.015353831854369_REALK,      0.000000000000000_REALK,     -0.009782420775422_REALK, &
      0.000000000000000_REALK,      0.095707546891263_REALK,      0.000000000000000_REALK, &
     -0.070681623580554_REALK,      0.000000000000000_REALK,      0.044079697382413_REALK, &
      0.000000000000000_REALK,      0.085071719401773_REALK,      0.000000000000000_REALK, &
     -0.051774114310663_REALK,      0.000000000000000_REALK,     -0.153961593657337_REALK, &
      0.000000000000000_REALK,      0.077484598576079_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.024991793812503_REALK,      0.000000000000000_REALK, &
     -0.053414823728985_REALK,      0.000000000000000_REALK,     -0.108596748911655_REALK, &
      0.000000000000000_REALK,      0.025180568487734_REALK,      0.000000000000000_REALK, &
     -0.045391763419440_REALK,      0.000000000000000_REALK,      0.102903143314287_REALK, &
      0.000000000000000_REALK,     -0.076516124614063_REALK,      0.000000000000000_REALK, &
      0.040804197999768_REALK,      0.000000000000000_REALK,      0.042888996428860_REALK, &
     -0.008651535534925_REALK,      0.000000000000000_REALK,      0.063097401761889_REALK, &
      0.000000000000000_REALK,      0.000699274009933_REALK,      0.000000000000000_REALK, &
     -0.043439788045362_REALK,      0.000000000000000_REALK,      0.050679073835810_REALK, &
      0.000000000000000_REALK,     -0.043387920326975_REALK,      0.000000000000000_REALK, &
      0.027628016803438_REALK,      0.000000000000000_REALK,     -0.021035419659760_REALK, &
      0.000000000000000_REALK,      0.087651664967825_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.012506087329819_REALK,      0.000000000000000_REALK, &
      0.003388035126271_REALK,      0.000000000000000_REALK,     -0.031609824393652_REALK, &
      0.000000000000000_REALK,      0.069133458076328_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.003663404049200_REALK,      0.000000000000000_REALK, &
      0.042711477622751_REALK,      0.000000000000000_REALK,     -0.043996161298695_REALK, &
      0.000000000000000_REALK,     -0.055709416710953_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.135572756271695_REALK,      0.000000000000000_REALK, &
      0.032448289638112_REALK,      0.000000000000000_REALK,     -0.154603196761033_REALK, &
      0.000000000000000_REALK,      0.038233334601097_REALK,      0.000000000000000_REALK, &
      0.050151054818549_REALK,      0.000000000000000_REALK,     -0.111652470010095_REALK, &
      0.000000000000000_REALK,     -0.133097890689956_REALK,      0.000000000000000_REALK, &
      0.176665669927200_REALK,      0.000000000000000_REALK,     -0.096536392879040_REALK, &
     -0.005528659337511_REALK,      0.000000000000000_REALK,     -0.144269398429332_REALK, &
      0.000000000000000_REALK,     -0.070114031846038_REALK,      0.000000000000000_REALK, &
      0.245229638071667_REALK,      0.000000000000000_REALK,      0.054434921075063_REALK, &
      0.000000000000000_REALK,     -0.134557079127456_REALK,      0.000000000000000_REALK, &
      0.064645346855574_REALK,      0.000000000000000_REALK,     -0.072969884051592_REALK, &
      0.000000000000000_REALK,      0.092372459546804_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.095868012143513_REALK,      0.000000000000000_REALK, &
      0.222939623263937_REALK,      0.000000000000000_REALK,     -0.240981112072968_REALK, &
      0.000000000000000_REALK,      0.210727716337336_REALK,      0.000000000000000_REALK, &
      0.033783895675606_REALK,      0.000000000000000_REALK,      0.030245458393593_REALK, &
      0.000000000000000_REALK,     -0.177186252846300_REALK,      0.000000000000000_REALK, &
      0.234204237381354_REALK,      0.000000000000000_REALK,     -0.029541460580118_REALK, &
      0.014177089414233_REALK,      0.000000000000000_REALK,     -0.007709089973636_REALK, &
      0.000000000000000_REALK,     -0.204850809255905_REALK,      0.000000000000000_REALK, &
      0.094016945586368_REALK,      0.000000000000000_REALK,     -0.030222793192017_REALK, &
      0.000000000000000_REALK,     -0.090962582536446_REALK,      0.000000000000000_REALK, &
      0.023594703365183_REALK,      0.000000000000000_REALK,     -0.336775022889550_REALK, &
      0.000000000000000_REALK,      0.161669016102669_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.230780187269857_REALK,      0.000000000000000_REALK, &
      0.050395954570179_REALK,      0.000000000000000_REALK,     -0.492860011875862_REALK, &
      0.000000000000000_REALK,      0.137956052045147_REALK,      0.000000000000000_REALK, &
     -0.055561240716670_REALK,      0.000000000000000_REALK,      0.012613730894824_REALK, &
      0.000000000000000_REALK,      0.188637130407951_REALK,      0.000000000000000_REALK, &
     -0.238454985505061_REALK,      0.000000000000000_REALK,      0.015656788590421_REALK, &
     -0.096125938098749_REALK,      0.000000000000000_REALK,      0.120808824620813_REALK, &
      0.000000000000000_REALK,      0.209721772314119_REALK,      0.000000000000000_REALK, &
     -0.323513327229152_REALK,      0.000000000000000_REALK,     -0.025936063495890_REALK, &
      0.000000000000000_REALK,      0.017702716424607_REALK,      0.000000000000000_REALK, &
     -0.011230953935653_REALK,      0.000000000000000_REALK,     -0.176732951389072_REALK, &
      0.000000000000000_REALK,      0.057783385882190_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.050146129348387_REALK,      0.000000000000000_REALK, &
      0.082706621894491_REALK,      0.000000000000000_REALK,     -0.156378837045318_REALK, &
      0.000000000000000_REALK,     -0.001137980269355_REALK,      0.000000000000000_REALK, &
     -0.071210359104305_REALK,      0.000000000000000_REALK,      0.119018442787194_REALK, &
      0.000000000000000_REALK,      0.161467061593929_REALK,      0.000000000000000_REALK, &
     -0.181341468135920_REALK,      0.000000000000000_REALK,      0.056666284731980_REALK, &
     -0.098883786202195_REALK,      0.000000000000000_REALK,      0.173524225362660_REALK, &
      0.000000000000000_REALK,      0.373036525706237_REALK,      0.000000000000000_REALK, &
     -0.234034080826892_REALK,      0.000000000000000_REALK,      0.045875157607264_REALK, &
      0.000000000000000_REALK,     -0.060889095892393_REALK,      0.000000000000000_REALK, &
      0.006111853465594_REALK,      0.000000000000000_REALK,     -0.239515085804989_REALK, &
      0.000000000000000_REALK,      0.185292882599418_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.097474001686393_REALK,      0.000000000000000_REALK, &
     -0.031503808673634_REALK,      0.000000000000000_REALK,     -0.242846465305645_REALK, &
      0.000000000000000_REALK,      0.064659488486248_REALK,      0.000000000000000_REALK, &
     -0.082568258948957_REALK,      0.000000000000000_REALK,      0.058615996200344_REALK, &
      0.000000000000000_REALK,      0.040903536103677_REALK,      0.000000000000000_REALK, &
      0.015094298994082_REALK,      0.000000000000000_REALK,      0.009534946796025_REALK, &
     -0.129092081180295_REALK,      0.000000000000000_REALK,      0.120095688141960_REALK, &
      0.000000000000000_REALK,      0.181602247051055_REALK,      0.000000000000000_REALK, &
     -0.143726569021610_REALK,      0.000000000000000_REALK,      0.066704974838637_REALK, &
      0.000000000000000_REALK,     -0.114664142096238_REALK,      0.000000000000000_REALK, &
      0.016396645236134_REALK,      0.000000000000000_REALK,     -0.113553916399555_REALK, &
      0.000000000000000_REALK,      0.061079253924318_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.114730837454247_REALK,      0.000000000000000_REALK, &
      0.006202541809379_REALK,      0.000000000000000_REALK,     -0.071028587933360_REALK, &
      0.000000000000000_REALK,      0.025583489229684_REALK,      0.000000000000000_REALK/
  ! results of test 4, ket-major order, 03 DPG Z
  data REF_CONTR_INTS(8713:9108) /                                                         &
      0.072203122810340_REALK,      0.000000000000000_REALK,     -0.003704465299322_REALK, &
      0.000000000000000_REALK,     -0.003426014075825_REALK,      0.000000000000000_REALK, &
      0.038645382288642_REALK,      0.000000000000000_REALK,      0.026948800813256_REALK, &
      0.026511853595545_REALK,      0.000000000000000_REALK,     -0.007684775191160_REALK, &
      0.000000000000000_REALK,      0.001223067364900_REALK,      0.000000000000000_REALK, &
      0.041995397024281_REALK,      0.000000000000000_REALK,      0.006272619127346_REALK, &
      0.000000000000000_REALK,      0.000571501810837_REALK,      0.000000000000000_REALK, &
      0.006643876628840_REALK,      0.000000000000000_REALK,      0.009769442690484_REALK, &
      0.000000000000000_REALK,     -0.072092551254095_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.007841107981807_REALK,      0.000000000000000_REALK, &
      0.031796530746789_REALK,      0.000000000000000_REALK,      0.017039598291833_REALK, &
      0.000000000000000_REALK,     -0.083353533646043_REALK,      0.000000000000000_REALK, &
     -0.001609526528628_REALK,      0.000000000000000_REALK,     -0.050996648447077_REALK, &
      0.000000000000000_REALK,      0.013578869053941_REALK,      0.000000000000000_REALK, &
      0.007611523018079_REALK,      0.000000000000000_REALK,     -0.086054773207986_REALK, &
      0.011991393362286_REALK,      0.000000000000000_REALK,     -0.075635121989651_REALK, &
      0.000000000000000_REALK,     -0.014680198888431_REALK,      0.000000000000000_REALK, &
      0.037846350149608_REALK,      0.000000000000000_REALK,     -0.065679127680656_REALK, &
      0.000000000000000_REALK,     -0.110862271614651_REALK,      0.000000000000000_REALK, &
      0.045339717924444_REALK,      0.000000000000000_REALK,      0.070430436110845_REALK, &
      0.000000000000000_REALK,      0.020850251560617_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.072918340160149_REALK,      0.000000000000000_REALK, &
      0.043335560358362_REALK,      0.000000000000000_REALK,      0.096913261856633_REALK, &
      0.000000000000000_REALK,     -0.013550543052986_REALK,      0.000000000000000_REALK, &
     -0.036385926513105_REALK,      0.000000000000000_REALK,      0.066418018123239_REALK, &
      0.000000000000000_REALK,     -0.054062619499154_REALK,      0.000000000000000_REALK, &
      0.047582804782231_REALK,      0.000000000000000_REALK,     -0.001422201890125_REALK, &
      0.014773586629336_REALK,      0.000000000000000_REALK,      0.066750502762658_REALK, &
      0.000000000000000_REALK,     -0.103240483499651_REALK,      0.000000000000000_REALK, &
      0.116423573794812_REALK,      0.000000000000000_REALK,     -0.031671243223415_REALK, &
      0.000000000000000_REALK,      0.076083124962406_REALK,      0.000000000000000_REALK, &
     -0.061804351821959_REALK,      0.000000000000000_REALK,     -0.079821470953189_REALK, &
      0.000000000000000_REALK,     -0.032687817204559_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.014977076967280_REALK,      0.000000000000000_REALK, &
     -0.105149159860382_REALK,      0.000000000000000_REALK,     -0.135802097459514_REALK, &
      0.000000000000000_REALK,      0.006434645716865_REALK,      0.000000000000000_REALK, &
      0.011751625176222_REALK,      0.000000000000000_REALK,      0.101006196941013_REALK, &
      0.000000000000000_REALK,     -0.069822879535028_REALK,      0.000000000000000_REALK, &
      0.002579287401581_REALK,      0.000000000000000_REALK,      0.030726016365592_REALK, &
      0.023476805864181_REALK,      0.000000000000000_REALK,      0.135865324297262_REALK, &
      0.000000000000000_REALK,     -0.133337006406930_REALK,      0.000000000000000_REALK, &
     -0.041641120053153_REALK,      0.000000000000000_REALK,     -0.038467005487383_REALK, &
      0.000000000000000_REALK,      0.011396972214627_REALK,      0.000000000000000_REALK, &
      0.035436277075750_REALK,      0.000000000000000_REALK,     -0.000144110065019_REALK, &
      0.000000000000000_REALK,      0.098653185353185_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.048289422116832_REALK,      0.000000000000000_REALK, &
      0.092972066147441_REALK,      0.000000000000000_REALK,     -0.038245432729027_REALK, &
      0.000000000000000_REALK,      0.152785806415091_REALK,      0.000000000000000_REALK, &
     -0.103311677587529_REALK,      0.000000000000000_REALK,      0.008007827745979_REALK, &
      0.000000000000000_REALK,     -0.005833929530355_REALK,      0.000000000000000_REALK, &
      0.050484813513223_REALK,      0.000000000000000_REALK,     -0.020678086739151_REALK, &
     -0.056647168840819_REALK,      0.000000000000000_REALK,     -0.005873187052131_REALK, &
      0.000000000000000_REALK,      0.006307097112910_REALK,      0.000000000000000_REALK, &
      0.132099718186509_REALK,      0.000000000000000_REALK,     -0.000326450377991_REALK, &
      0.000000000000000_REALK,     -0.062484878846048_REALK,      0.000000000000000_REALK, &
     -0.013342940197756_REALK,      0.000000000000000_REALK,     -0.016573717804342_REALK, &
      0.000000000000000_REALK,     -0.012979989586196_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.082560106701586_REALK,      0.000000000000000_REALK, &
     -0.029933578437477_REALK,      0.000000000000000_REALK,     -0.051977755101123_REALK, &
      0.000000000000000_REALK,     -0.008865833651334_REALK,      0.000000000000000_REALK, &
      0.025758942468129_REALK,      0.000000000000000_REALK,      0.039782342762419_REALK, &
      0.000000000000000_REALK,     -0.022259370595054_REALK,      0.000000000000000_REALK, &
      0.004192940978443_REALK,      0.000000000000000_REALK,     -0.070666398606717_REALK, &
      0.019674688722138_REALK,      0.000000000000000_REALK,      0.020982327985126_REALK, &
      0.000000000000000_REALK,      0.007946467567116_REALK,      0.000000000000000_REALK, &
     -0.001343131588406_REALK,      0.000000000000000_REALK,     -0.043820875975636_REALK, &
      0.028219760709135_REALK,      0.000000000000000_REALK,     -0.024738339793126_REALK, &
      0.000000000000000_REALK,      0.012165312904331_REALK,      0.000000000000000_REALK, &
      0.152202123665189_REALK,      0.000000000000000_REALK,      0.006760157556808_REALK, &
      0.050437814861056_REALK,      0.000000000000000_REALK,     -0.012273827490735_REALK, &
      0.000000000000000_REALK,      0.024078887175507_REALK,      0.000000000000000_REALK, &
      0.111622507454876_REALK,      0.000000000000000_REALK,      0.022556656600382_REALK, &
      0.000000000000000_REALK,     -0.000448133329253_REALK,      0.000000000000000_REALK, &
      0.150517134805551_REALK,      0.000000000000000_REALK,     -0.044610221047220_REALK, &
      0.000000000000000_REALK,      0.006574450170375_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.047741249938595_REALK,      0.000000000000000_REALK, &
      0.232186548979221_REALK,      0.000000000000000_REALK,     -0.094408776287829_REALK, &
      0.000000000000000_REALK,     -0.060921463894841_REALK,      0.000000000000000_REALK, &
      0.009948158225684_REALK,      0.000000000000000_REALK,      0.063450209064794_REALK, &
      0.000000000000000_REALK,     -0.106484975283553_REALK,      0.000000000000000_REALK, &
     -0.028586444917822_REALK,      0.000000000000000_REALK,     -0.066262399135771_REALK, &
      0.070415255533555_REALK,      0.000000000000000_REALK,     -0.067778464015799_REALK, &
      0.000000000000000_REALK,     -0.194129775167339_REALK,      0.000000000000000_REALK, &
      0.041637104841832_REALK,      0.000000000000000_REALK,     -0.134066411735351_REALK, &
      0.000000000000000_REALK,     -0.083257279485603_REALK,      0.000000000000000_REALK, &
     -0.081455927534927_REALK,      0.000000000000000_REALK,     -0.138242507633150_REALK, &
      0.000000000000000_REALK,      0.001847984574143_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.116811159215641_REALK,      0.000000000000000_REALK, &
     -0.030434774800253_REALK,      0.000000000000000_REALK,      0.006260638893372_REALK, &
      0.000000000000000_REALK,     -0.038351224573785_REALK,      0.000000000000000_REALK, &
      0.011214752331238_REALK,      0.000000000000000_REALK,      0.043153363121455_REALK, &
      0.000000000000000_REALK,      0.071360025798642_REALK,      0.000000000000000_REALK, &
      0.018140360708679_REALK,      0.000000000000000_REALK,     -0.031697336580712_REALK, &
      0.100826632977510_REALK,      0.000000000000000_REALK,      0.090781641801176_REALK, &
      0.000000000000000_REALK,     -0.082513075083770_REALK,      0.000000000000000_REALK, &
      0.278742555280027_REALK,      0.000000000000000_REALK,     -0.035671618600044_REALK, &
      0.000000000000000_REALK,      0.026611126925337_REALK,      0.000000000000000_REALK, &
      0.050661137583923_REALK,      0.000000000000000_REALK,      0.065429802318125_REALK, &
      0.000000000000000_REALK,     -0.011433016887418_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.176868462639703_REALK,      0.000000000000000_REALK, &
     -0.148370916878709_REALK,      0.000000000000000_REALK,     -0.191623801282617_REALK, &
      0.000000000000000_REALK,      0.075988518858482_REALK,      0.000000000000000_REALK, &
      0.024527218099326_REALK,      0.000000000000000_REALK,      0.059228742739851_REALK, &
      0.000000000000000_REALK,      0.092162801786417_REALK,      0.000000000000000_REALK, &
      0.009913047189955_REALK,      0.000000000000000_REALK,     -0.035370673459568_REALK, &
      0.002134513469543_REALK,      0.000000000000000_REALK,      0.245072837483546_REALK, &
      0.000000000000000_REALK,     -0.106567172567894_REALK,      0.000000000000000_REALK, &
     -0.134266709144589_REALK,      0.000000000000000_REALK,     -0.117069392918202_REALK, &
      0.000000000000000_REALK,      0.029222358661868_REALK,      0.000000000000000_REALK, &
     -0.087046873808199_REALK,      0.000000000000000_REALK,      0.015335813371113_REALK, &
      0.000000000000000_REALK,      0.118611793232462_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.102259736006387_REALK,      0.000000000000000_REALK, &
      0.083125941843994_REALK,      0.000000000000000_REALK,     -0.068838194916440_REALK, &
      0.000000000000000_REALK,      0.298412832476173_REALK,      0.000000000000000_REALK, &
     -0.060760722051844_REALK,      0.000000000000000_REALK,      0.002813112620865_REALK, &
      0.000000000000000_REALK,      0.045749453756279_REALK,      0.000000000000000_REALK, &
     -0.104003322173033_REALK,      0.000000000000000_REALK,     -0.002842639850318_REALK, &
     -0.038476606051598_REALK,      0.000000000000000_REALK,     -0.010424231613221_REALK, &
      0.000000000000000_REALK,      0.083404547431085_REALK,      0.000000000000000_REALK, &
      0.135016649242664_REALK,      0.000000000000000_REALK,      0.053040758045990_REALK, &
      0.000000000000000_REALK,      0.006267182255603_REALK,      0.000000000000000_REALK, &
      0.001313815060370_REALK,      0.000000000000000_REALK,     -0.130786655828482_REALK, &
      0.000000000000000_REALK,      0.000844975561406_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.120691913156808_REALK,      0.000000000000000_REALK, &
      0.031244543572462_REALK,      0.000000000000000_REALK,     -0.178201742850809_REALK, &
      0.000000000000000_REALK,      0.029453397994402_REALK,      0.000000000000000_REALK, &
      0.020706786065332_REALK,      0.000000000000000_REALK,      0.094974627202921_REALK, &
      0.000000000000000_REALK,      0.079040016283957_REALK,      0.000000000000000_REALK, &
      0.000151521831094_REALK,      0.000000000000000_REALK,     -0.046232091064042_REALK, &
      0.007470511839991_REALK,      0.000000000000000_REALK,      0.105336676742797_REALK, &
      0.000000000000000_REALK,      0.156444445730129_REALK,      0.000000000000000_REALK, &
      0.009573227516736_REALK,      0.000000000000000_REALK,     -0.030953778053160_REALK/
  ! results of test 5, ket-major order, XDIPVEL
  data REF_CONTR_INTS(9109:9504) /                                                         &
      0.266923705412279_REALK,      0.000000000000000_REALK,     -0.027890755869561_REALK, &
      0.000000000000000_REALK,     -0.040950697864850_REALK,      0.000000000000000_REALK, &
      0.046554579007678_REALK,      0.000000000000000_REALK,     -0.359884862997085_REALK, &
      0.017872340907200_REALK,      0.000000000000000_REALK,      0.016987604978031_REALK, &
      0.000000000000000_REALK,     -0.011222829469930_REALK,      0.000000000000000_REALK, &
      0.063591204908042_REALK,      0.000000000000000_REALK,     -0.155189018516716_REALK, &
      0.000000000000000_REALK,     -0.262679404603372_REALK,      0.000000000000000_REALK, &
     -0.029704712312351_REALK,      0.000000000000000_REALK,      0.129820767198447_REALK, &
      0.000000000000000_REALK,     -0.278172623791831_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.114499955930671_REALK,      0.000000000000000_REALK, &
      0.044777330434753_REALK,      0.000000000000000_REALK,     -0.035372297931612_REALK, &
      0.000000000000000_REALK,      0.027155726221655_REALK,      0.000000000000000_REALK, &
     -0.079904923396842_REALK,      0.000000000000000_REALK,     -0.095687333145286_REALK, &
      0.000000000000000_REALK,      0.033637962344327_REALK,      0.000000000000000_REALK, &
      0.149827065855015_REALK,      0.000000000000000_REALK,      0.015913966968947_REALK, &
      0.033385581745565_REALK,      0.000000000000000_REALK,     -0.007085287738772_REALK, &
      0.000000000000000_REALK,     -0.065847375971192_REALK,      0.000000000000000_REALK, &
      0.131534523403374_REALK,      0.000000000000000_REALK,      0.013568539905119_REALK, &
      0.000000000000000_REALK,     -0.000750980722374_REALK,      0.000000000000000_REALK, &
      0.089102807570017_REALK,      0.000000000000000_REALK,      0.071142740400548_REALK, &
      0.000000000000000_REALK,      0.065430918071202_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.053912279940686_REALK,      0.000000000000000_REALK, &
      0.019281813724385_REALK,      0.000000000000000_REALK,     -0.014714806205260_REALK, &
      0.000000000000000_REALK,      0.002386924848429_REALK,      0.000000000000000_REALK, &
      0.029402544521619_REALK,      0.000000000000000_REALK,      0.103829528822969_REALK, &
      0.000000000000000_REALK,     -0.119945600365518_REALK,      0.000000000000000_REALK, &
      0.053862218892226_REALK,      0.000000000000000_REALK,     -0.042296330249361_REALK, &
      0.004134284218545_REALK,      0.000000000000000_REALK,     -0.019141583964691_REALK, &
      0.000000000000000_REALK,     -0.006904376310866_REALK,      0.000000000000000_REALK, &
      0.008532980224226_REALK,      0.000000000000000_REALK,      0.008393137363237_REALK, &
      0.000000000000000_REALK,     -0.052392559772688_REALK,      0.000000000000000_REALK, &
     -0.088092420314111_REALK,      0.000000000000000_REALK,     -0.072211640864250_REALK, &
      0.000000000000000_REALK,     -0.007794562870140_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.049344086541291_REALK,      0.000000000000000_REALK, &
     -0.021381820419342_REALK,      0.000000000000000_REALK,     -0.004500114203810_REALK, &
      0.000000000000000_REALK,      0.053518706239223_REALK,      0.000000000000000_REALK, &
      0.022009353063383_REALK,      0.000000000000000_REALK,      0.094889931688547_REALK, &
      0.000000000000000_REALK,     -0.110349893145570_REALK,      0.000000000000000_REALK, &
     -0.079899495116732_REALK,      0.000000000000000_REALK,     -0.081261795578802_REALK, &
     -0.043784310713606_REALK,      0.000000000000000_REALK,     -0.062827469753346_REALK, &
      0.000000000000000_REALK,      0.019349533093988_REALK,      0.000000000000000_REALK, &
     -0.068384421516178_REALK,      0.000000000000000_REALK,      0.017695470663138_REALK, &
      0.000000000000000_REALK,      0.153253164275562_REALK,      0.000000000000000_REALK, &
      0.052655701980762_REALK,      0.000000000000000_REALK,     -0.096102426931858_REALK, &
      0.000000000000000_REALK,      0.109340127718411_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.004515832181080_REALK,      0.000000000000000_REALK, &
      0.019453369183892_REALK,      0.000000000000000_REALK,     -0.059744132296878_REALK, &
      0.000000000000000_REALK,     -0.071707712651228_REALK,      0.000000000000000_REALK, &
      0.007673069075851_REALK,      0.000000000000000_REALK,      0.111056467134271_REALK, &
      0.000000000000000_REALK,     -0.065291927805443_REALK,      0.000000000000000_REALK, &
      0.146714425362068_REALK,      0.000000000000000_REALK,      0.079563305797438_REALK, &
      0.052043699066469_REALK,      0.000000000000000_REALK,      0.082420956053712_REALK, &
      0.000000000000000_REALK,      0.021686144854974_REALK,      0.000000000000000_REALK, &
      0.052991296703704_REALK,      0.000000000000000_REALK,      0.004761557609857_REALK, &
      0.000000000000000_REALK,     -0.205462751021305_REALK,      0.000000000000000_REALK, &
      0.000393608332111_REALK,      0.000000000000000_REALK,     -0.028513019639788_REALK, &
      0.000000000000000_REALK,      0.182065378416091_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.039350224511548_REALK,      0.000000000000000_REALK, &
     -0.038549028878923_REALK,      0.000000000000000_REALK,     -0.099482449113681_REALK, &
      0.000000000000000_REALK,      0.200965072367411_REALK,      0.000000000000000_REALK, &
     -0.305907500467742_REALK,      0.000000000000000_REALK,      0.059116340588066_REALK, &
      0.000000000000000_REALK,     -0.081559688324868_REALK,      0.000000000000000_REALK, &
      0.058663957880079_REALK,      0.000000000000000_REALK,     -0.338568754305416_REALK, &
     -0.163053906417852_REALK,      0.000000000000000_REALK,      0.005012997029676_REALK, &
      0.000000000000000_REALK,      0.038817352038487_REALK,      0.000000000000000_REALK, &
     -0.065365776141699_REALK,      0.000000000000000_REALK,      0.008284652259266_REALK, &
      0.037518221242093_REALK,      0.000000000000000_REALK,      0.034438248837846_REALK, &
      0.000000000000000_REALK,     -0.033972640185296_REALK,      0.000000000000000_REALK, &
      0.161964106236714_REALK,      0.000000000000000_REALK,     -0.392175351282081_REALK, &
      0.156510986396623_REALK,      0.000000000000000_REALK,      0.116821313853568_REALK, &
      0.000000000000000_REALK,      0.068595469419345_REALK,      0.000000000000000_REALK, &
     -0.029517988847773_REALK,      0.000000000000000_REALK,     -0.107593325904448_REALK, &
      0.000000000000000_REALK,     -0.282975530154336_REALK,      0.000000000000000_REALK, &
      0.101202792614176_REALK,      0.000000000000000_REALK,     -0.055568282920905_REALK, &
      0.000000000000000_REALK,      0.036360885179511_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.206929444465883_REALK,      0.000000000000000_REALK, &
      0.135014061218469_REALK,      0.000000000000000_REALK,     -0.391305961293784_REALK, &
      0.000000000000000_REALK,      0.273193368190327_REALK,      0.000000000000000_REALK, &
      0.076265352202248_REALK,      0.000000000000000_REALK,     -0.024378476495390_REALK, &
      0.000000000000000_REALK,     -0.142219218875322_REALK,      0.000000000000000_REALK, &
      0.304053307370285_REALK,      0.000000000000000_REALK,      0.033719995147471_REALK, &
      0.046683392405504_REALK,      0.000000000000000_REALK,      0.051350789399852_REALK, &
      0.000000000000000_REALK,     -0.281699236014113_REALK,      0.000000000000000_REALK, &
      0.381354324939051_REALK,      0.000000000000000_REALK,      0.043600125676722_REALK, &
      0.000000000000000_REALK,      0.136712061049800_REALK,      0.000000000000000_REALK, &
      0.039774020041487_REALK,      0.000000000000000_REALK,     -0.038895636137997_REALK, &
      0.000000000000000_REALK,      0.005708515905883_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.023823021634371_REALK,      0.000000000000000_REALK, &
      0.144124333682990_REALK,      0.000000000000000_REALK,      0.023401962596882_REALK, &
      0.000000000000000_REALK,      0.020043573797916_REALK,      0.000000000000000_REALK, &
      0.013558492912436_REALK,      0.000000000000000_REALK,     -0.031877410439798_REALK, &
      0.000000000000000_REALK,     -0.025904426415366_REALK,      0.000000000000000_REALK, &
      0.024960158130108_REALK,      0.000000000000000_REALK,      0.015688661016197_REALK, &
     -0.019644722764756_REALK,      0.000000000000000_REALK,     -0.175444887684224_REALK, &
      0.000000000000000_REALK,      0.050939168883393_REALK,      0.000000000000000_REALK, &
     -0.037567140187790_REALK,      0.000000000000000_REALK,      0.029211371355019_REALK, &
      0.000000000000000_REALK,     -0.129552055405002_REALK,      0.000000000000000_REALK, &
     -0.048679234552097_REALK,      0.000000000000000_REALK,     -0.008957695772100_REALK, &
      0.000000000000000_REALK,      0.124906589069321_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.071291427169428_REALK,      0.000000000000000_REALK, &
     -0.079077296462281_REALK,      0.000000000000000_REALK,     -0.023008229415483_REALK, &
      0.000000000000000_REALK,      0.099777853693470_REALK,      0.000000000000000_REALK, &
     -0.102721697436690_REALK,      0.000000000000000_REALK,     -0.128986025923035_REALK, &
      0.000000000000000_REALK,      0.033939535940256_REALK,      0.000000000000000_REALK, &
     -0.161749094581387_REALK,      0.000000000000000_REALK,      0.030070956705191_REALK, &
     -0.053594178197192_REALK,      0.000000000000000_REALK,     -0.340138174817934_REALK, &
      0.000000000000000_REALK,      0.125918708763147_REALK,      0.000000000000000_REALK, &
     -0.118149767087870_REALK,      0.000000000000000_REALK,      0.120770197954257_REALK, &
      0.000000000000000_REALK,      0.031961386752765_REALK,      0.000000000000000_REALK, &
      0.044238517609506_REALK,      0.000000000000000_REALK,     -0.141342372359368_REALK, &
      0.000000000000000_REALK,     -0.151776601520854_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.217528347568604_REALK,      0.000000000000000_REALK, &
      0.089357232978504_REALK,      0.000000000000000_REALK,     -0.195341507531070_REALK, &
      0.000000000000000_REALK,     -0.292256714683161_REALK,      0.000000000000000_REALK, &
      0.130313629139571_REALK,      0.000000000000000_REALK,      0.189717751733822_REALK, &
      0.000000000000000_REALK,      0.038498396506135_REALK,      0.000000000000000_REALK, &
      0.134052498894732_REALK,      0.000000000000000_REALK,      0.024127872766240_REALK, &
      0.000290260981437_REALK,      0.000000000000000_REALK,      0.293107746998212_REALK, &
      0.000000000000000_REALK,      0.222877740723575_REALK,      0.000000000000000_REALK, &
     -0.019997577945709_REALK,      0.000000000000000_REALK,     -0.143378786580104_REALK, &
      0.000000000000000_REALK,     -0.098555148789816_REALK,      0.000000000000000_REALK, &
     -0.094348311145522_REALK,      0.000000000000000_REALK,     -0.240895883187504_REALK, &
      0.000000000000000_REALK,      0.464022775976619_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.050083980613176_REALK,      0.000000000000000_REALK, &
     -0.041259538693190_REALK,      0.000000000000000_REALK,     -0.076346541545266_REALK, &
      0.000000000000000_REALK,      0.535094223483070_REALK,      0.000000000000000_REALK, &
     -0.383253961486073_REALK,      0.000000000000000_REALK,      0.014909101646956_REALK, &
      0.000000000000000_REALK,      0.080553868366866_REALK,      0.000000000000000_REALK, &
     -0.144704565593863_REALK,      0.000000000000000_REALK,     -0.010276287028979_REALK, &
     -0.454847657841651_REALK,      0.000000000000000_REALK,      0.036318595642620_REALK, &
      0.000000000000000_REALK,      0.145455592963228_REALK,      0.000000000000000_REALK, &
     -0.201361809240887_REALK,      0.000000000000000_REALK,      0.266738999776154_REALK/
  ! results of test 5, ket-major order, YDIPVEL
  data REF_CONTR_INTS(9505:9900) /                                                         &
     -0.090814369625795_REALK,      0.000000000000000_REALK,      0.033902330115830_REALK, &
      0.000000000000000_REALK,      0.025598789094933_REALK,      0.000000000000000_REALK, &
      0.034356480303109_REALK,      0.000000000000000_REALK,      0.528781378778865_REALK, &
     -0.100283848390972_REALK,      0.000000000000000_REALK,     -0.057880739293964_REALK, &
      0.000000000000000_REALK,      0.026014520116425_REALK,      0.000000000000000_REALK, &
      0.048741979336563_REALK,      0.000000000000000_REALK,      0.180389239901962_REALK, &
      0.000000000000000_REALK,      0.296029679845542_REALK,      0.000000000000000_REALK, &
     -0.040916258649342_REALK,      0.000000000000000_REALK,     -0.029704712312351_REALK, &
      0.000000000000000_REALK,     -0.157930226071824_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.234952237060658_REALK,      0.000000000000000_REALK, &
      0.089212139068105_REALK,      0.000000000000000_REALK,      0.044777330434753_REALK, &
      0.000000000000000_REALK,      0.053920378351878_REALK,      0.000000000000000_REALK, &
      0.094775581604103_REALK,      0.000000000000000_REALK,     -0.109179150494494_REALK, &
      0.000000000000000_REALK,      0.064136520564888_REALK,      0.000000000000000_REALK, &
     -0.109100874300936_REALK,      0.000000000000000_REALK,      0.023346248411419_REALK, &
     -0.005705667305763_REALK,      0.000000000000000_REALK,     -0.030492266805699_REALK, &
      0.000000000000000_REALK,     -0.046036444325121_REALK,      0.000000000000000_REALK, &
     -0.113468544992181_REALK,      0.000000000000000_REALK,      0.012650428941709_REALK, &
      0.000000000000000_REALK,     -0.030039480599330_REALK,      0.000000000000000_REALK, &
     -0.034168663560976_REALK,      0.000000000000000_REALK,      0.089102807570017_REALK, &
      0.000000000000000_REALK,     -0.150475380812365_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.045622507344164_REALK,      0.000000000000000_REALK, &
     -0.053621544573043_REALK,      0.000000000000000_REALK,      0.019281813724385_REALK, &
      0.000000000000000_REALK,     -0.014352801185518_REALK,      0.000000000000000_REALK, &
      0.044399870566668_REALK,      0.000000000000000_REALK,     -0.012834506095905_REALK, &
      0.000000000000000_REALK,     -0.048309672196585_REALK,      0.000000000000000_REALK, &
      0.101120518306900_REALK,      0.000000000000000_REALK,     -0.038543310309181_REALK, &
      0.009533617111689_REALK,      0.000000000000000_REALK,     -0.079893430201798_REALK, &
      0.000000000000000_REALK,      0.022920727289821_REALK,      0.000000000000000_REALK, &
      0.031474204966874_REALK,      0.000000000000000_REALK,      0.044094258977032_REALK, &
      0.000000000000000_REALK,     -0.017861612541325_REALK,      0.000000000000000_REALK, &
     -0.026647041549531_REALK,      0.000000000000000_REALK,     -0.088092420314111_REALK, &
      0.000000000000000_REALK,      0.046812288815508_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.062420783236996_REALK,      0.000000000000000_REALK, &
      0.006559339907596_REALK,      0.000000000000000_REALK,     -0.021381820419342_REALK, &
      0.000000000000000_REALK,     -0.014922385468500_REALK,      0.000000000000000_REALK, &
      0.029402544521619_REALK,      0.000000000000000_REALK,      0.103829528822969_REALK, &
      0.000000000000000_REALK,     -0.119945600365518_REALK,      0.000000000000000_REALK, &
      0.053862218892226_REALK,      0.000000000000000_REALK,     -0.042296330249361_REALK, &
      0.004134284218545_REALK,      0.000000000000000_REALK,     -0.019141583964691_REALK, &
      0.000000000000000_REALK,     -0.006904376310866_REALK,      0.000000000000000_REALK, &
      0.008532980224226_REALK,      0.000000000000000_REALK,      0.008393137363237_REALK, &
      0.000000000000000_REALK,     -0.087311089268725_REALK,      0.000000000000000_REALK, &
      0.105664594654231_REALK,      0.000000000000000_REALK,      0.052655701980762_REALK, &
      0.000000000000000_REALK,      0.117861726803690_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.033249382090701_REALK,      0.000000000000000_REALK, &
      0.042071110992997_REALK,      0.000000000000000_REALK,      0.019453369183892_REALK, &
      0.000000000000000_REALK,     -0.043493600011512_REALK,      0.000000000000000_REALK, &
      0.027267122512817_REALK,      0.000000000000000_REALK,     -0.140074404706119_REALK, &
      0.000000000000000_REALK,      0.038105580705936_REALK,      0.000000000000000_REALK, &
      0.147949749215238_REALK,      0.000000000000000_REALK,     -0.103016479497200_REALK, &
      0.030896818556053_REALK,      0.000000000000000_REALK,     -0.133971233112661_REALK, &
      0.000000000000000_REALK,      0.028308036254969_REALK,      0.000000000000000_REALK, &
      0.079605834155361_REALK,      0.000000000000000_REALK,      0.044180826467113_REALK, &
      0.000000000000000_REALK,     -0.114924386913575_REALK,      0.000000000000000_REALK, &
     -0.131874551219042_REALK,      0.000000000000000_REALK,      0.000393608332111_REALK, &
      0.000000000000000_REALK,     -0.368739552616067_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.001854555139205_REALK,      0.000000000000000_REALK, &
      0.002353051783535_REALK,      0.000000000000000_REALK,     -0.038549028878924_REALK, &
      0.000000000000000_REALK,     -0.168446286327456_REALK,      0.000000000000000_REALK, &
      0.572507375306938_REALK,      0.000000000000000_REALK,      0.063095694053597_REALK, &
      0.000000000000000_REALK,     -0.071970409787431_REALK,      0.000000000000000_REALK, &
     -0.054328923228208_REALK,      0.000000000000000_REALK,      0.036837007096452_REALK, &
      0.158300252411724_REALK,      0.000000000000000_REALK,     -0.014004694000661_REALK, &
      0.000000000000000_REALK,      0.024714155555700_REALK,      0.000000000000000_REALK, &
      0.060900195343331_REALK,      0.000000000000000_REALK,      0.108148736292108_REALK, &
     -0.251957925687603_REALK,      0.000000000000000_REALK,     -0.133668930702923_REALK, &
      0.000000000000000_REALK,      0.067271986612029_REALK,      0.000000000000000_REALK, &
      0.122766094213872_REALK,      0.000000000000000_REALK,      0.436747988477135_REALK, &
     -0.044055065936340_REALK,      0.000000000000000_REALK,     -0.137221157045140_REALK, &
      0.000000000000000_REALK,     -0.040135125106262_REALK,      0.000000000000000_REALK, &
     -0.013420852712362_REALK,      0.000000000000000_REALK,      0.378452234327263_REALK, &
      0.000000000000000_REALK,      0.548497904046468_REALK,      0.000000000000000_REALK, &
      0.200742198196494_REALK,      0.000000000000000_REALK,      0.101202792614176_REALK, &
      0.000000000000000_REALK,      0.109113849501558_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.610141280234109_REALK,      0.000000000000000_REALK, &
      0.246642482404748_REALK,      0.000000000000000_REALK,      0.135014061218469_REALK, &
      0.000000000000000_REALK,      0.240941418190375_REALK,      0.000000000000000_REALK, &
     -0.001720678227880_REALK,      0.000000000000000_REALK,     -0.077062261183436_REALK, &
      0.000000000000000_REALK,     -0.093182289816150_REALK,      0.000000000000000_REALK, &
     -0.257183095090554_REALK,      0.000000000000000_REALK,      0.031219311498693_REALK, &
     -0.146937932498505_REALK,      0.000000000000000_REALK,     -0.034703003901670_REALK, &
      0.000000000000000_REALK,     -0.294425009540685_REALK,      0.000000000000000_REALK, &
     -0.437644688437441_REALK,      0.000000000000000_REALK,      0.034113834045306_REALK, &
      0.000000000000000_REALK,      0.112066605245787_REALK,      0.000000000000000_REALK, &
     -0.127372671357010_REALK,      0.000000000000000_REALK,      0.039774020041487_REALK, &
      0.000000000000000_REALK,     -0.053905331476937_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.009388578255102_REALK,      0.000000000000000_REALK, &
     -0.155312503360126_REALK,      0.000000000000000_REALK,      0.144124333682990_REALK, &
      0.000000000000000_REALK,      0.177719428795617_REALK,      0.000000000000000_REALK, &
      0.030724886518225_REALK,      0.000000000000000_REALK,     -0.178906342183252_REALK, &
      0.000000000000000_REALK,      0.047338246134448_REALK,      0.000000000000000_REALK, &
      0.082122536843502_REALK,      0.000000000000000_REALK,      0.099814397831324_REALK, &
     -0.065223673918006_REALK,      0.000000000000000_REALK,     -0.265003894442353_REALK, &
      0.000000000000000_REALK,      0.099571120499361_REALK,      0.000000000000000_REALK, &
     -0.038350961442507_REALK,      0.000000000000000_REALK,      0.093582335864592_REALK, &
      0.000000000000000_REALK,     -0.152192190662253_REALK,      0.000000000000000_REALK, &
      0.016220972374429_REALK,      0.000000000000000_REALK,     -0.048679234552097_REALK, &
      0.000000000000000_REALK,     -0.024046697289345_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.042506237640157_REALK,      0.000000000000000_REALK, &
      0.017893420412590_REALK,      0.000000000000000_REALK,     -0.079077296462281_REALK, &
      0.000000000000000_REALK,     -0.150160987613774_REALK,      0.000000000000000_REALK, &
      0.013558492912436_REALK,      0.000000000000000_REALK,     -0.031877410439798_REALK, &
      0.000000000000000_REALK,     -0.025904426415367_REALK,      0.000000000000000_REALK, &
      0.024960158130109_REALK,      0.000000000000000_REALK,      0.015688661016197_REALK, &
     -0.019644722764757_REALK,      0.000000000000000_REALK,     -0.175444887684224_REALK, &
      0.000000000000000_REALK,      0.050939168883393_REALK,      0.000000000000000_REALK, &
     -0.037567140187790_REALK,      0.000000000000000_REALK,      0.029211371355019_REALK, &
      0.000000000000000_REALK,     -0.082548810257711_REALK,      0.000000000000000_REALK, &
      0.098342368597790_REALK,      0.000000000000000_REALK,      0.044238517609506_REALK, &
      0.000000000000000_REALK,     -0.085813734398905_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.015479481147804_REALK,      0.000000000000000_REALK, &
      0.161227046185623_REALK,      0.000000000000000_REALK,      0.089357232978504_REALK, &
      0.000000000000000_REALK,     -0.246960499621623_REALK,      0.000000000000000_REALK, &
      0.081650800673011_REALK,      0.000000000000000_REALK,     -0.307718615432339_REALK, &
      0.000000000000000_REALK,      0.069227236764713_REALK,      0.000000000000000_REALK, &
      0.191397816819899_REALK,      0.000000000000000_REALK,      0.098314312219980_REALK, &
     -0.040180125088926_REALK,      0.000000000000000_REALK,     -0.423353564653295_REALK, &
      0.000000000000000_REALK,     -0.005047090631265_REALK,      0.000000000000000_REALK, &
      0.122949581842510_REALK,      0.000000000000000_REALK,      0.103628067803220_REALK, &
      0.000000000000000_REALK,     -0.002149923383739_REALK,      0.000000000000000_REALK, &
     -0.021004126194546_REALK,      0.000000000000000_REALK,     -0.094348311145522_REALK, &
      0.000000000000000_REALK,     -0.413581870077142_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.079987425450073_REALK,      0.000000000000000_REALK, &
      0.337325701653716_REALK,      0.000000000000000_REALK,     -0.041259538693190_REALK, &
      0.000000000000000_REALK,     -0.286863931430606_REALK,      0.000000000000000_REALK, &
      0.404891587435478_REALK,      0.000000000000000_REALK,     -0.026375111025739_REALK, &
      0.000000000000000_REALK,      0.047968777827186_REALK,      0.000000000000000_REALK, &
      0.130406229553323_REALK,      0.000000000000000_REALK,      0.243036535891595_REALK, &
      0.134814800955294_REALK,      0.000000000000000_REALK,     -0.046978364844328_REALK, &
      0.000000000000000_REALK,      0.126975706646250_REALK,      0.000000000000000_REALK, &
      0.268520702679649_REALK,      0.000000000000000_REALK,      0.391309397873544_REALK/
  ! results of test 5, ket-major order, ZDIPVEL
  data REF_CONTR_INTS(9901:10296) /                                                        &
      0.000000000000000_REALK,     -0.119408803430892_REALK,      0.000000000000000_REALK, &
     -0.051095849541178_REALK,      0.000000000000000_REALK,      0.041177401077306_REALK, &
      0.000000000000000_REALK,     -0.204571592354560_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.035621603444357_REALK,      0.000000000000000_REALK, &
      0.014903935480409_REALK,      0.000000000000000_REALK,     -0.023375976038296_REALK, &
      0.000000000000000_REALK,     -0.044679998181525_REALK,      0.000000000000000_REALK, &
     -0.148707961041400_REALK,      0.000000000000000_REALK,     -0.160997094930544_REALK, &
      0.000000000000000_REALK,      0.050309377102597_REALK,      0.000000000000000_REALK, &
      0.197797709587242_REALK,      0.000000000000000_REALK,     -0.203011171337462_REALK, &
     -0.021418115053691_REALK,      0.000000000000000_REALK,     -0.062555734981275_REALK, &
      0.000000000000000_REALK,     -0.034113581870999_REALK,      0.000000000000000_REALK, &
      0.113037798887674_REALK,      0.000000000000000_REALK,     -0.073467160960582_REALK, &
      0.000000000000000_REALK,     -0.176380954019944_REALK,      0.000000000000000_REALK, &
      0.231271903915932_REALK,      0.000000000000000_REALK,      0.192599826632614_REALK, &
      0.000000000000000_REALK,      0.213698307372406_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.065403878352583_REALK,      0.000000000000000_REALK, &
      0.080092948382882_REALK,      0.000000000000000_REALK,      0.006115308465413_REALK, &
      0.000000000000000_REALK,      0.104748049763248_REALK,      0.000000000000000_REALK, &
     -0.053466592867691_REALK,      0.000000000000000_REALK,      0.329069950260810_REALK, &
      0.000000000000000_REALK,     -0.322817922099215_REALK,      0.000000000000000_REALK, &
      0.144805270177500_REALK,      0.000000000000000_REALK,      0.033753883151258_REALK, &
      0.013986387843992_REALK,      0.000000000000000_REALK,      0.104759039977911_REALK, &
      0.000000000000000_REALK,     -0.133583620914307_REALK,      0.000000000000000_REALK, &
      0.086175539450124_REALK,      0.000000000000000_REALK,     -0.015286086785642_REALK, &
      0.000000000000000_REALK,      0.159838792763440_REALK,      0.000000000000000_REALK, &
     -0.147021918038664_REALK,      0.000000000000000_REALK,     -0.292268370666804_REALK, &
      0.000000000000000_REALK,      0.042584334036157_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.011146572339996_REALK,      0.000000000000000_REALK, &
     -0.034890598902438_REALK,      0.000000000000000_REALK,     -0.173211929228240_REALK, &
      0.000000000000000_REALK,      0.063594308395330_REALK,      0.000000000000000_REALK, &
     -0.001972923717340_REALK,      0.000000000000000_REALK,     -0.279669881956683_REALK, &
      0.000000000000000_REALK,      0.304016764155132_REALK,      0.000000000000000_REALK, &
     -0.072327710297397_REALK,      0.000000000000000_REALK,      0.003559239544518_REALK, &
     -0.022721629080529_REALK,      0.000000000000000_REALK,     -0.077556243658972_REALK, &
      0.000000000000000_REALK,      0.182572064954986_REALK,      0.000000000000000_REALK, &
     -0.020057453036682_REALK,      0.000000000000000_REALK,      0.040990799607970_REALK, &
      0.000000000000000_REALK,      0.123077253662694_REALK,      0.000000000000000_REALK, &
     -0.292268370666804_REALK,      0.000000000000000_REALK,     -0.298193734573096_REALK, &
      0.000000000000000_REALK,     -0.139021861991318_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.058455247874722_REALK,      0.000000000000000_REALK, &
     -0.173211929228240_REALK,      0.000000000000000_REALK,     -0.124482099779274_REALK, &
      0.000000000000000_REALK,     -0.020417659339387_REALK,      0.000000000000000_REALK, &
      0.095853588981396_REALK,      0.000000000000000_REALK,      0.144805270177500_REALK, &
      0.000000000000000_REALK,     -0.083486577049495_REALK,      0.000000000000000_REALK, &
     -0.193399965165305_REALK,      0.000000000000000_REALK,      0.069526704530096_REALK, &
     -0.013780721974207_REALK,      0.000000000000000_REALK,      0.086175539450124_REALK, &
      0.000000000000000_REALK,     -0.034547150255757_REALK,      0.000000000000000_REALK, &
     -0.206169745646511_REALK,      0.000000000000000_REALK,     -0.013597073166231_REALK, &
      0.000000000000000_REALK,      0.213698307372406_REALK,      0.000000000000000_REALK, &
      0.042237956775083_REALK,      0.000000000000000_REALK,     -0.192385593789357_REALK, &
      0.000000000000000_REALK,      0.229204604274978_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.104748049763248_REALK,      0.000000000000000_REALK, &
      0.095489646004897_REALK,      0.000000000000000_REALK,     -0.103206775114424_REALK, &
      0.000000000000000_REALK,      0.133401141518235_REALK,      0.000000000000000_REALK, &
     -0.203011171337462_REALK,      0.000000000000000_REALK,      0.153566432056267_REALK, &
      0.000000000000000_REALK,     -0.090760287825555_REALK,      0.000000000000000_REALK, &
      0.172436106542956_REALK,      0.000000000000000_REALK,      0.105001738503804_REALK, &
     -0.073467160960582_REALK,      0.000000000000000_REALK,      0.038983469138901_REALK, &
      0.000000000000000_REALK,      0.061542374159363_REALK,      0.000000000000000_REALK, &
      0.081707529485793_REALK,      0.000000000000000_REALK,      0.070396198468813_REALK, &
      0.000000000000000_REALK,     -0.158585831087377_REALK,      0.000000000000000_REALK, &
      0.013063326949997_REALK,      0.000000000000000_REALK,      0.000376846311623_REALK, &
      0.000000000000000_REALK,      0.107516050462758_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.086742054635898_REALK,      0.000000000000000_REALK, &
     -0.040401628723591_REALK,      0.000000000000000_REALK,     -0.045618947812683_REALK, &
      0.000000000000000_REALK,      0.046499615093161_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.090164585206883_REALK,      0.000000000000000_REALK, &
      0.025361045119409_REALK,      0.000000000000000_REALK,     -0.047407789630480_REALK, &
      0.000000000000000_REALK,     -0.119287749348849_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.040142591087036_REALK,      0.000000000000000_REALK, &
      0.149366948013994_REALK,      0.000000000000000_REALK,     -0.136789221716837_REALK, &
      0.000000000000000_REALK,     -0.004323011673665_REALK,      0.000000000000000_REALK, &
     -0.061469386689034_REALK,      0.000000000000000_REALK,     -0.152082488118773_REALK, &
      0.000000000000000_REALK,     -0.071100033594918_REALK,      0.000000000000000_REALK, &
      0.275226983300812_REALK,      0.000000000000000_REALK,     -0.181067779468744_REALK, &
      0.012025048631064_REALK,      0.000000000000000_REALK,     -0.132536755665305_REALK, &
      0.000000000000000_REALK,     -0.175147019035706_REALK,      0.000000000000000_REALK, &
      0.149637397187710_REALK,      0.000000000000000_REALK,     -0.119129076756403_REALK, &
      0.000000000000000_REALK,     -0.154349581794645_REALK,      0.000000000000000_REALK, &
      0.199184900091616_REALK,      0.000000000000000_REALK,      0.031784065386022_REALK, &
      0.000000000000000_REALK,      0.252751936373717_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.234971223497940_REALK,      0.000000000000000_REALK, &
      0.106262424779548_REALK,      0.000000000000000_REALK,     -0.155452701495508_REALK, &
      0.000000000000000_REALK,      0.210743420325301_REALK,      0.000000000000000_REALK, &
      0.029276600004426_REALK,      0.000000000000000_REALK,      0.262679681557968_REALK, &
      0.000000000000000_REALK,     -0.327504632269893_REALK,      0.000000000000000_REALK, &
      0.204012605382803_REALK,      0.000000000000000_REALK,     -0.037603263103146_REALK, &
      0.054410596551981_REALK,      0.000000000000000_REALK,      0.117208181443734_REALK, &
      0.000000000000000_REALK,     -0.204055923359347_REALK,      0.000000000000000_REALK, &
      0.217086573445957_REALK,      0.000000000000000_REALK,      0.003767109800918_REALK, &
      0.000000000000000_REALK,     -0.009328082130717_REALK,      0.000000000000000_REALK, &
     -0.092133729114273_REALK,      0.000000000000000_REALK,     -0.408486160998099_REALK, &
      0.000000000000000_REALK,      0.149012655602549_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.186700883671519_REALK,      0.000000000000000_REALK, &
      0.024051395238044_REALK,      0.000000000000000_REALK,     -0.480766295345317_REALK, &
      0.000000000000000_REALK,      0.124855373031126_REALK,      0.000000000000000_REALK, &
     -0.054305359805984_REALK,      0.000000000000000_REALK,     -0.201955476198693_REALK, &
      0.000000000000000_REALK,      0.431508088514162_REALK,      0.000000000000000_REALK, &
     -0.052229353669675_REALK,      0.000000000000000_REALK,      0.097969213103357_REALK, &
     -0.027884600509700_REALK,      0.000000000000000_REALK,      0.039401488198990_REALK, &
      0.000000000000000_REALK,      0.483086183095003_REALK,      0.000000000000000_REALK, &
      0.010189940381869_REALK,      0.000000000000000_REALK,      0.050305022918487_REALK, &
      0.000000000000000_REALK,     -0.120690704390340_REALK,      0.000000000000000_REALK, &
     -0.408486160998099_REALK,      0.000000000000000_REALK,     -0.303417607853440_REALK, &
      0.000000000000000_REALK,     -0.060422104594150_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.274575557391323_REALK,      0.000000000000000_REALK, &
     -0.480766295345317_REALK,      0.000000000000000_REALK,     -0.224618394209464_REALK, &
      0.000000000000000_REALK,      0.083400791372380_REALK,      0.000000000000000_REALK, &
     -0.019039680101700_REALK,      0.000000000000000_REALK,      0.204012605382803_REALK, &
      0.000000000000000_REALK,     -0.084698645410596_REALK,      0.000000000000000_REALK, &
     -0.473415410489150_REALK,      0.000000000000000_REALK,     -0.024475720324368_REALK, &
     -0.164221606816866_REALK,      0.000000000000000_REALK,      0.217086573445957_REALK, &
      0.000000000000000_REALK,     -0.052772567449679_REALK,      0.000000000000000_REALK, &
     -0.666058916013591_REALK,      0.000000000000000_REALK,     -0.097855529355452_REALK, &
      0.000000000000000_REALK,      0.252751936373717_REALK,      0.000000000000000_REALK, &
      0.215351788050640_REALK,      0.000000000000000_REALK,     -0.246658846774569_REALK, &
      0.000000000000000_REALK,      0.325357237060081_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.210743420325301_REALK,      0.000000000000000_REALK, &
      0.344999675415476_REALK,      0.000000000000000_REALK,     -0.235688497696717_REALK, &
      0.000000000000000_REALK,      0.165006150401727_REALK,      0.000000000000000_REALK, &
     -0.181067779468744_REALK,      0.000000000000000_REALK,      0.094537522870483_REALK, &
      0.000000000000000_REALK,      0.128267529536721_REALK,      0.000000000000000_REALK, &
      0.198812063918508_REALK,      0.000000000000000_REALK,      0.164816938460873_REALK, &
     -0.119129076756404_REALK,      0.000000000000000_REALK,      0.133962664208251_REALK, &
      0.000000000000000_REALK,      0.315972782311553_REALK,      0.000000000000000_REALK, &
      0.136590526267972_REALK,      0.000000000000000_REALK,      0.160904551526614_REALK, &
      0.000000000000000_REALK,     -0.204616141392793_REALK,      0.000000000000000_REALK, &
     -0.093315812541997_REALK,      0.000000000000000_REALK,     -0.108181100006084_REALK, &
      0.000000000000000_REALK,      0.112232056958643_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.208781559305621_REALK,      0.000000000000000_REALK, &
     -0.091042612963534_REALK,      0.000000000000000_REALK,     -0.066838091235948_REALK, &
      0.000000000000000_REALK,      0.093019284485295_REALK,      0.000000000000000_REALK/
  ! results of test 6, ket-major order, dd/dxdx
  data REF_CONTR_INTS(10297:10692) /                                                       &
     -0.313296136054994_REALK,      0.000000000000000_REALK,      0.037721429076586_REALK, &
      0.000000000000000_REALK,     -0.078170081465931_REALK,      0.000000000000000_REALK, &
      0.149869320365419_REALK,      0.000000000000000_REALK,     -0.510936369614808_REALK, &
     -0.094234196496968_REALK,      0.000000000000000_REALK,      0.034373979685106_REALK, &
      0.000000000000000_REALK,      0.032485586910348_REALK,      0.000000000000000_REALK, &
     -0.059132700043255_REALK,      0.000000000000000_REALK,      0.031566523721206_REALK, &
      0.000000000000000_REALK,     -0.322412550115877_REALK,      0.000000000000000_REALK, &
      0.054468808460129_REALK,      0.000000000000000_REALK,      0.058199581078666_REALK, &
      0.000000000000000_REALK,      0.089543615777903_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.007434874354505_REALK,      0.000000000000000_REALK, &
     -0.007053096725403_REALK,      0.000000000000000_REALK,     -0.117484468547307_REALK, &
      0.000000000000000_REALK,      0.164166188477305_REALK,      0.000000000000000_REALK, &
      0.029886795540289_REALK,      0.000000000000000_REALK,      0.052517156807655_REALK, &
      0.000000000000000_REALK,     -0.055790654809287_REALK,      0.000000000000000_REALK, &
      0.160492842178804_REALK,      0.000000000000000_REALK,      0.094146900589459_REALK, &
      0.026709534353716_REALK,      0.000000000000000_REALK,      0.063896245884156_REALK, &
      0.000000000000000_REALK,     -0.032439868902442_REALK,      0.000000000000000_REALK, &
      0.056101361998525_REALK,      0.000000000000000_REALK,     -0.013202193031805_REALK, &
      0.000000000000000_REALK,      0.156824321465403_REALK,      0.000000000000000_REALK, &
     -0.007826755860030_REALK,      0.000000000000000_REALK,     -0.092456322617806_REALK, &
      0.000000000000000_REALK,      0.017729452208572_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.022438436008732_REALK,      0.000000000000000_REALK, &
      0.024885991976507_REALK,      0.000000000000000_REALK,     -0.002996634932661_REALK, &
      0.000000000000000_REALK,     -0.023476711237227_REALK,      0.000000000000000_REALK, &
      0.010721263272632_REALK,      0.000000000000000_REALK,      0.025901433404116_REALK, &
      0.000000000000000_REALK,     -0.031129080740050_REALK,      0.000000000000000_REALK, &
     -0.015604069311181_REALK,      0.000000000000000_REALK,     -0.032192012797223_REALK, &
     -0.010790330451840_REALK,      0.000000000000000_REALK,     -0.033623295372639_REALK, &
      0.000000000000000_REALK,      0.023128482015484_REALK,      0.000000000000000_REALK, &
     -0.016705385980629_REALK,      0.000000000000000_REALK,      0.007253717237079_REALK, &
      0.000000000000000_REALK,     -0.110099140337200_REALK,      0.000000000000000_REALK, &
      0.002741509491849_REALK,      0.000000000000000_REALK,      0.042709299660069_REALK, &
      0.000000000000000_REALK,      0.065299443433542_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.048229408722923_REALK,      0.000000000000000_REALK, &
     -0.008725921888429_REALK,      0.000000000000000_REALK,     -0.001762678093313_REALK, &
      0.000000000000000_REALK,      0.022400712281122_REALK,      0.000000000000000_REALK, &
     -0.071489529193986_REALK,      0.000000000000000_REALK,     -0.048239369840169_REALK, &
      0.000000000000000_REALK,      0.013127701619622_REALK,      0.000000000000000_REALK, &
     -0.086292709736965_REALK,      0.000000000000000_REALK,     -0.042342404913867_REALK, &
     -0.000038245240414_REALK,      0.000000000000000_REALK,     -0.065319986233735_REALK, &
      0.000000000000000_REALK,      0.032940762341641_REALK,      0.000000000000000_REALK, &
      0.002565676572255_REALK,      0.000000000000000_REALK,      0.044572156903450_REALK, &
      0.000000000000000_REALK,      0.109412566005766_REALK,      0.000000000000000_REALK, &
     -0.025070342916703_REALK,      0.000000000000000_REALK,     -0.087423395110337_REALK, &
      0.000000000000000_REALK,     -0.077462334613213_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.078925685832760_REALK,      0.000000000000000_REALK, &
     -0.004435504723072_REALK,      0.000000000000000_REALK,     -0.007835447207020_REALK, &
      0.000000000000000_REALK,     -0.050121524369404_REALK,      0.000000000000000_REALK, &
      0.146743698492705_REALK,      0.000000000000000_REALK,      0.113576524247550_REALK, &
      0.000000000000000_REALK,     -0.017815012308843_REALK,      0.000000000000000_REALK, &
     -0.009162454860404_REALK,      0.000000000000000_REALK,      0.041707103809461_REALK, &
     -0.024029857436488_REALK,      0.000000000000000_REALK,      0.044695348356389_REALK, &
      0.000000000000000_REALK,      0.050094716368272_REALK,      0.000000000000000_REALK, &
     -0.071002563748835_REALK,      0.000000000000000_REALK,     -0.057800899098948_REALK, &
      0.000000000000000_REALK,      0.118969321478664_REALK,      0.000000000000000_REALK, &
     -0.048299484184128_REALK,      0.000000000000000_REALK,     -0.177999274598737_REALK, &
      0.000000000000000_REALK,      0.316737740576556_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.097298512079819_REALK,      0.000000000000000_REALK, &
     -0.018432129036677_REALK,      0.000000000000000_REALK,      0.024789856390693_REALK, &
      0.000000000000000_REALK,      0.064225139901988_REALK,      0.000000000000000_REALK, &
     -0.414051209015400_REALK,      0.000000000000000_REALK,      0.059193218102986_REALK, &
      0.000000000000000_REALK,      0.007499943330590_REALK,      0.000000000000000_REALK, &
     -0.058326707850278_REALK,      0.000000000000000_REALK,      0.212167136667090_REALK, &
     -0.042768580435542_REALK,      0.000000000000000_REALK,     -0.022823091822832_REALK, &
      0.000000000000000_REALK,      0.034314362850305_REALK,      0.000000000000000_REALK, &
     -0.063447996385215_REALK,      0.000000000000000_REALK,      0.186742397236890_REALK, &
     -0.243114940171123_REALK,      0.000000000000000_REALK,      0.082770495018242_REALK, &
      0.000000000000000_REALK,      0.066898431498606_REALK,      0.000000000000000_REALK, &
     -0.119787320272241_REALK,      0.000000000000000_REALK,      0.044393516945161_REALK, &
     -0.160196658852310_REALK,      0.000000000000000_REALK,      0.074497797203930_REALK, &
      0.000000000000000_REALK,      0.131268399482244_REALK,      0.000000000000000_REALK, &
     -0.247270935756113_REALK,      0.000000000000000_REALK,      0.201871948367579_REALK, &
      0.000000000000000_REALK,     -0.031880066119718_REALK,      0.000000000000000_REALK, &
     -0.009577015882883_REALK,      0.000000000000000_REALK,     -0.271586137460051_REALK, &
      0.000000000000000_REALK,      0.392419803023858_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.016507377147898_REALK,      0.000000000000000_REALK, &
     -0.068920889643369_REALK,      0.000000000000000_REALK,     -0.216936023384193_REALK, &
      0.000000000000000_REALK,      0.269175385477124_REALK,      0.000000000000000_REALK, &
      0.074450029706802_REALK,      0.000000000000000_REALK,      0.147247155602962_REALK, &
      0.000000000000000_REALK,     -0.082828670614493_REALK,      0.000000000000000_REALK, &
      0.140956535167318_REALK,      0.000000000000000_REALK,     -0.028577083772336_REALK, &
     -0.025978764763437_REALK,      0.000000000000000_REALK,      0.167573195976524_REALK, &
      0.000000000000000_REALK,      0.043153505872877_REALK,      0.000000000000000_REALK, &
      0.016011318998444_REALK,      0.000000000000000_REALK,     -0.034508566289969_REALK, &
      0.000000000000000_REALK,     -0.035127308858159_REALK,      0.000000000000000_REALK, &
      0.051777291343175_REALK,      0.000000000000000_REALK,     -0.013658561566339_REALK, &
      0.000000000000000_REALK,     -0.056241303270044_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.151294797645699_REALK,      0.000000000000000_REALK, &
      0.092232686130403_REALK,      0.000000000000000_REALK,     -0.031816682637729_REALK, &
      0.000000000000000_REALK,     -0.049724633741341_REALK,      0.000000000000000_REALK, &
     -0.027184077497285_REALK,      0.000000000000000_REALK,     -0.076583632398025_REALK, &
      0.000000000000000_REALK,      0.054221685324496_REALK,      0.000000000000000_REALK, &
     -0.040085358586840_REALK,      0.000000000000000_REALK,      0.018576493061243_REALK, &
     -0.000975206410214_REALK,      0.000000000000000_REALK,     -0.072677170983218_REALK, &
      0.000000000000000_REALK,      0.016702921762152_REALK,      0.000000000000000_REALK, &
     -0.018991278730956_REALK,      0.000000000000000_REALK,     -0.006751726589960_REALK, &
      0.000000000000000_REALK,      0.099845637407771_REALK,      0.000000000000000_REALK, &
     -0.018199598873171_REALK,      0.000000000000000_REALK,     -0.001860841602584_REALK, &
      0.000000000000000_REALK,      0.063607182892367_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.172135390719351_REALK,      0.000000000000000_REALK, &
     -0.005928220468399_REALK,      0.000000000000000_REALK,      0.027503781740414_REALK, &
      0.000000000000000_REALK,     -0.060097539333538_REALK,      0.000000000000000_REALK, &
     -0.014396326145982_REALK,      0.000000000000000_REALK,     -0.156654116831185_REALK, &
      0.000000000000000_REALK,      0.081546217673497_REALK,      0.000000000000000_REALK, &
     -0.005517898815903_REALK,      0.000000000000000_REALK,      0.108362655139079_REALK, &
      0.114871408916979_REALK,      0.000000000000000_REALK,     -0.068388753244155_REALK, &
      0.000000000000000_REALK,     -0.001076980794334_REALK,      0.000000000000000_REALK, &
      0.143411765444036_REALK,      0.000000000000000_REALK,      0.025950976082882_REALK, &
      0.000000000000000_REALK,     -0.176546763964644_REALK,      0.000000000000000_REALK, &
     -0.011644422624727_REALK,      0.000000000000000_REALK,     -0.017414597398679_REALK, &
      0.000000000000000_REALK,     -0.131922264018616_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.199915012783089_REALK,      0.000000000000000_REALK, &
     -0.020852427611472_REALK,      0.000000000000000_REALK,     -0.077067491612431_REALK, &
      0.000000000000000_REALK,      0.062952882256583_REALK,      0.000000000000000_REALK, &
     -0.040262003600180_REALK,      0.000000000000000_REALK,      0.108676994729595_REALK, &
      0.000000000000000_REALK,      0.110093510679309_REALK,      0.000000000000000_REALK, &
     -0.156394619334251_REALK,      0.000000000000000_REALK,     -0.132489810377888_REALK, &
     -0.159546410522423_REALK,      0.000000000000000_REALK,      0.086861068574199_REALK, &
      0.000000000000000_REALK,      0.192092216646562_REALK,      0.000000000000000_REALK, &
     -0.298314098839896_REALK,      0.000000000000000_REALK,     -0.116253046014377_REALK, &
      0.000000000000000_REALK,      0.232825090530514_REALK,      0.000000000000000_REALK, &
     -0.047547106059897_REALK,      0.000000000000000_REALK,      0.029956899477882_REALK, &
      0.000000000000000_REALK,      0.178011806022505_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.241592642702753_REALK,      0.000000000000000_REALK, &
     -0.042148894747514_REALK,      0.000000000000000_REALK,      0.311882411858871_REALK, &
      0.000000000000000_REALK,     -0.124622765458686_REALK,      0.000000000000000_REALK, &
     -0.114029298476717_REALK,      0.000000000000000_REALK,     -0.055713933236123_REALK, &
      0.000000000000000_REALK,      0.091699316306011_REALK,      0.000000000000000_REALK, &
     -0.162583010321041_REALK,      0.000000000000000_REALK,      0.451687678796141_REALK, &
      0.009445321549548_REALK,      0.000000000000000_REALK,     -0.035872285848074_REALK, &
      0.000000000000000_REALK,     -0.056374037951704_REALK,      0.000000000000000_REALK, &
      0.006798313832660_REALK,      0.000000000000000_REALK,      0.254319314258875_REALK/
  ! results of test 6, ket-major order, dd/dxdy
  data REF_CONTR_INTS(10693:11088) /                                                       &
      0.252869548742529_REALK,      0.000000000000000_REALK,     -0.031864423746406_REALK, &
      0.000000000000000_REALK,      0.014077042381805_REALK,      0.000000000000000_REALK, &
      0.061862619696413_REALK,      0.000000000000000_REALK,      0.170597502580223_REALK, &
      0.156963791628608_REALK,      0.000000000000000_REALK,     -0.009555203801639_REALK, &
      0.000000000000000_REALK,     -0.003778069289258_REALK,      0.000000000000000_REALK, &
      0.024711734623566_REALK,      0.000000000000000_REALK,      0.060668092081574_REALK, &
      0.000000000000000_REALK,      0.086437436399938_REALK,      0.000000000000000_REALK, &
      0.012513432772156_REALK,      0.000000000000000_REALK,      0.054468808460129_REALK, &
      0.000000000000000_REALK,     -0.218861228533503_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.047757605317593_REALK,      0.000000000000000_REALK, &
      0.042526751179821_REALK,      0.000000000000000_REALK,     -0.007053096725403_REALK, &
      0.000000000000000_REALK,     -0.061108081750977_REALK,      0.000000000000000_REALK, &
      0.024535195875257_REALK,      0.000000000000000_REALK,     -0.087061390638217_REALK, &
      0.000000000000000_REALK,      0.001559453783779_REALK,      0.000000000000000_REALK, &
     -0.003219517347522_REALK,      0.000000000000000_REALK,     -0.019189541600042_REALK, &
     -0.016519494565416_REALK,      0.000000000000000_REALK,     -0.043620939024636_REALK, &
      0.000000000000000_REALK,     -0.044240912719688_REALK,      0.000000000000000_REALK, &
     -0.005897786443499_REALK,      0.000000000000000_REALK,      0.012483749274191_REALK, &
      0.000000000000000_REALK,      0.029706227680622_REALK,      0.000000000000000_REALK, &
     -0.042315636784400_REALK,      0.000000000000000_REALK,     -0.007826755860030_REALK, &
      0.000000000000000_REALK,     -0.050204746334200_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.012307744342873_REALK,      0.000000000000000_REALK, &
      0.005874374513483_REALK,      0.000000000000000_REALK,      0.024885991976507_REALK, &
      0.000000000000000_REALK,      0.031879110328688_REALK,      0.000000000000000_REALK, &
      0.041278156053786_REALK,      0.000000000000000_REALK,     -0.017031231217807_REALK, &
      0.000000000000000_REALK,     -0.013423414099542_REALK,      0.000000000000000_REALK, &
      0.054823245759352_REALK,      0.000000000000000_REALK,      0.002672439373926_REALK, &
     -0.004955894767119_REALK,      0.000000000000000_REALK,     -0.031909214272477_REALK, &
      0.000000000000000_REALK,      0.018522701020141_REALK,      0.000000000000000_REALK, &
     -0.002335404389793_REALK,      0.000000000000000_REALK,      0.013007192420399_REALK, &
      0.000000000000000_REALK,     -0.084297273650545_REALK,      0.000000000000000_REALK, &
      0.009965956183219_REALK,      0.000000000000000_REALK,      0.002741509491849_REALK, &
      0.000000000000000_REALK,      0.031562476821839_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.001038910653377_REALK,      0.000000000000000_REALK, &
     -0.004852609738526_REALK,      0.000000000000000_REALK,     -0.008725921888429_REALK, &
      0.000000000000000_REALK,     -0.010705692904047_REALK,      0.000000000000000_REALK, &
      0.010721263272632_REALK,      0.000000000000000_REALK,      0.025901433404116_REALK, &
      0.000000000000000_REALK,     -0.031129080740050_REALK,      0.000000000000000_REALK, &
     -0.015604069311181_REALK,      0.000000000000000_REALK,     -0.032192012797222_REALK, &
     -0.010790330451840_REALK,      0.000000000000000_REALK,     -0.033623295372639_REALK, &
      0.000000000000000_REALK,      0.023128482015484_REALK,      0.000000000000000_REALK, &
     -0.016705385980629_REALK,      0.000000000000000_REALK,      0.007253717237079_REALK, &
      0.000000000000000_REALK,      0.012964666412075_REALK,      0.000000000000000_REALK, &
      0.045994997221249_REALK,      0.000000000000000_REALK,     -0.025070342916703_REALK, &
      0.000000000000000_REALK,      0.061976886116572_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.011243594989287_REALK,      0.000000000000000_REALK, &
      0.020729758301049_REALK,      0.000000000000000_REALK,     -0.004435504723072_REALK, &
      0.000000000000000_REALK,     -0.043141230252660_REALK,      0.000000000000000_REALK, &
      0.022268951081944_REALK,      0.000000000000000_REALK,     -0.036094075555922_REALK, &
      0.000000000000000_REALK,      0.010136241859252_REALK,      0.000000000000000_REALK, &
      0.133977708569472_REALK,      0.000000000000000_REALK,      0.028061602027989_REALK, &
      0.000674468520900_REALK,      0.000000000000000_REALK,     -0.010356464918675_REALK, &
      0.000000000000000_REALK,      0.009656372794513_REALK,      0.000000000000000_REALK, &
      0.055026952666773_REALK,      0.000000000000000_REALK,      0.005691830160734_REALK, &
      0.000000000000000_REALK,     -0.202551103907784_REALK,      0.000000000000000_REALK, &
     -0.075642414493209_REALK,      0.000000000000000_REALK,     -0.048299484184128_REALK, &
      0.000000000000000_REALK,     -0.115863142100700_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.106961223769589_REALK,      0.000000000000000_REALK, &
      0.034088714151416_REALK,      0.000000000000000_REALK,     -0.018432129036677_REALK, &
      0.000000000000000_REALK,      0.019110071079893_REALK,      0.000000000000000_REALK, &
      0.240808126263022_REALK,      0.000000000000000_REALK,      0.012492156685969_REALK, &
      0.000000000000000_REALK,     -0.041826744109071_REALK,      0.000000000000000_REALK, &
      0.005907043781025_REALK,      0.000000000000000_REALK,     -0.349754709341937_REALK, &
      0.003811982349504_REALK,      0.000000000000000_REALK,      0.017042031611427_REALK, &
      0.000000000000000_REALK,      0.021163971853593_REALK,      0.000000000000000_REALK, &
      0.017813508002609_REALK,      0.000000000000000_REALK,     -0.082628687471859_REALK, &
      0.368274553086636_REALK,      0.000000000000000_REALK,     -0.027512548433130_REALK, &
      0.000000000000000_REALK,     -0.005952504347445_REALK,      0.000000000000000_REALK, &
      0.064782629740449_REALK,      0.000000000000000_REALK,      0.144229951192424_REALK, &
      0.333936971309217_REALK,      0.000000000000000_REALK,      0.012965460137019_REALK, &
      0.000000000000000_REALK,     -0.030459713240576_REALK,      0.000000000000000_REALK, &
      0.019757216678421_REALK,      0.000000000000000_REALK,      0.099639297609938_REALK, &
      0.000000000000000_REALK,      0.118813581749872_REALK,      0.000000000000000_REALK, &
      0.101667160364823_REALK,      0.000000000000000_REALK,     -0.009577015882883_REALK, &
      0.000000000000000_REALK,     -0.143001724468127_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.011214443542822_REALK,      0.000000000000000_REALK, &
      0.084857725673970_REALK,      0.000000000000000_REALK,     -0.068920889643369_REALK, &
      0.000000000000000_REALK,     -0.225400526065652_REALK,      0.000000000000000_REALK, &
     -0.033162927027998_REALK,      0.000000000000000_REALK,     -0.101901643470080_REALK, &
      0.000000000000000_REALK,     -0.100053432787149_REALK,      0.000000000000000_REALK, &
     -0.012748090844881_REALK,      0.000000000000000_REALK,      0.023299149049862_REALK, &
     -0.075578322111311_REALK,      0.000000000000000_REALK,     -0.158875493597032_REALK, &
      0.000000000000000_REALK,     -0.132362855881542_REALK,      0.000000000000000_REALK, &
     -0.034931251503675_REALK,      0.000000000000000_REALK,      0.085337598376997_REALK, &
      0.000000000000000_REALK,     -0.021859126752286_REALK,      0.000000000000000_REALK, &
      0.009630283683116_REALK,      0.000000000000000_REALK,      0.051777291343175_REALK, &
      0.000000000000000_REALK,      0.070025161408340_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.050990968646357_REALK,      0.000000000000000_REALK, &
      0.009888172585214_REALK,      0.000000000000000_REALK,      0.092232686130403_REALK, &
      0.000000000000000_REALK,      0.080403594848849_REALK,      0.000000000000000_REALK, &
     -0.008879605881996_REALK,      0.000000000000000_REALK,     -0.076483399657505_REALK, &
      0.000000000000000_REALK,      0.044289275534890_REALK,      0.000000000000000_REALK, &
     -0.000033009454225_REALK,      0.000000000000000_REALK,      0.035724278839089_REALK, &
     -0.022870102296380_REALK,      0.000000000000000_REALK,     -0.030406195782242_REALK, &
      0.000000000000000_REALK,      0.008397439359047_REALK,      0.000000000000000_REALK, &
     -0.061368805094329_REALK,      0.000000000000000_REALK,     -0.023433882958804_REALK, &
      0.000000000000000_REALK,     -0.013391183504330_REALK,      0.000000000000000_REALK, &
     -0.009757501798643_REALK,      0.000000000000000_REALK,     -0.018199598873171_REALK, &
      0.000000000000000_REALK,     -0.021790615837288_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.074438854746867_REALK,      0.000000000000000_REALK, &
      0.002450481809639_REALK,      0.000000000000000_REALK,     -0.005928220468399_REALK, &
      0.000000000000000_REALK,     -0.035565184635343_REALK,      0.000000000000000_REALK, &
     -0.027184077497285_REALK,      0.000000000000000_REALK,     -0.076583632398024_REALK, &
      0.000000000000000_REALK,      0.054221685324496_REALK,      0.000000000000000_REALK, &
     -0.040085358586840_REALK,      0.000000000000000_REALK,      0.018576493061243_REALK, &
     -0.000975206410214_REALK,      0.000000000000000_REALK,     -0.072677170983218_REALK, &
      0.000000000000000_REALK,      0.016702921762152_REALK,      0.000000000000000_REALK, &
     -0.018991278730956_REALK,      0.000000000000000_REALK,     -0.006751726589960_REALK, &
      0.000000000000000_REALK,     -0.025462635000365_REALK,      0.000000000000000_REALK, &
      0.045935005732933_REALK,      0.000000000000000_REALK,     -0.011644422624727_REALK, &
      0.000000000000000_REALK,     -0.098446333942314_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.014734088278180_REALK,      0.000000000000000_REALK, &
      0.094849828162893_REALK,      0.000000000000000_REALK,     -0.020852427611472_REALK, &
      0.000000000000000_REALK,     -0.099199410395391_REALK,      0.000000000000000_REALK, &
      0.005651568296366_REALK,      0.000000000000000_REALK,     -0.027561772368338_REALK, &
      0.000000000000000_REALK,      0.023717236702843_REALK,      0.000000000000000_REALK, &
      0.134181183907803_REALK,      0.000000000000000_REALK,      0.021478007200153_REALK, &
     -0.007620923878475_REALK,      0.000000000000000_REALK,      0.027783434535725_REALK, &
      0.000000000000000_REALK,      0.002394084119581_REALK,      0.000000000000000_REALK, &
      0.088025744021276_REALK,      0.000000000000000_REALK,     -0.049459522121143_REALK, &
      0.000000000000000_REALK,     -0.254560919658368_REALK,      0.000000000000000_REALK, &
      0.070718241002187_REALK,      0.000000000000000_REALK,     -0.047547106059897_REALK, &
      0.000000000000000_REALK,      0.040781130743472_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.217974557551688_REALK,      0.000000000000000_REALK, &
      0.131534734786118_REALK,      0.000000000000000_REALK,     -0.042148894747514_REALK, &
      0.000000000000000_REALK,      0.016368299231548_REALK,      0.000000000000000_REALK, &
      0.020771659486263_REALK,      0.000000000000000_REALK,      0.031779108631604_REALK, &
      0.000000000000000_REALK,      0.050018883106435_REALK,      0.000000000000000_REALK, &
      0.041093364816176_REALK,      0.000000000000000_REALK,     -0.209851737664759_REALK, &
     -0.018435659142362_REALK,      0.000000000000000_REALK,      0.134005944732472_REALK, &
      0.000000000000000_REALK,      0.037245862873257_REALK,      0.000000000000000_REALK, &
      0.038583597452414_REALK,      0.000000000000000_REALK,     -0.141510344491186_REALK/
  ! results of test 6, ket-major order, dd/dydy
  data REF_CONTR_INTS(11089:11484) /                                                       &
     -0.706983447891185_REALK,      0.000000000000000_REALK,     -0.086003810316239_REALK, &
      0.000000000000000_REALK,      0.079891711768394_REALK,      0.000000000000000_REALK, &
      0.098316506067093_REALK,      0.000000000000000_REALK,      0.099805424297182_REALK, &
     -0.141992165664072_REALK,      0.000000000000000_REALK,     -0.015049489562027_REALK, &
      0.000000000000000_REALK,     -0.022264285573497_REALK,      0.000000000000000_REALK, &
     -0.064154202136404_REALK,      0.000000000000000_REALK,     -0.088442518468698_REALK, &
      0.000000000000000_REALK,      0.272829071702321_REALK,      0.000000000000000_REALK, &
      0.110716166267167_REALK,      0.000000000000000_REALK,      0.012513432772156_REALK, &
      0.000000000000000_REALK,      0.285185522363604_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.027565639907514_REALK,      0.000000000000000_REALK, &
      0.015892066944069_REALK,      0.000000000000000_REALK,      0.042526751179821_REALK, &
      0.000000000000000_REALK,      0.185322910484908_REALK,      0.000000000000000_REALK, &
      0.002595915041360_REALK,      0.000000000000000_REALK,      0.058956191502698_REALK, &
      0.000000000000000_REALK,     -0.024260698370487_REALK,      0.000000000000000_REALK, &
     -0.142272244225726_REALK,      0.000000000000000_REALK,      0.100857407313728_REALK, &
     -0.043203144718358_REALK,      0.000000000000000_REALK,      0.075691818771154_REALK, &
      0.000000000000000_REALK,     -0.037538725379150_REALK,      0.000000000000000_REALK, &
     -0.078814590925515_REALK,      0.000000000000000_REALK,     -0.019413423334997_REALK, &
      0.000000000000000_REALK,      0.130894988641254_REALK,      0.000000000000000_REALK, &
     -0.099816750302527_REALK,      0.000000000000000_REALK,     -0.042315636784400_REALK, &
      0.000000000000000_REALK,     -0.106224320024571_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000048753969842_REALK,      0.000000000000000_REALK, &
     -0.016573524625590_REALK,      0.000000000000000_REALK,      0.005874374513483_REALK, &
      0.000000000000000_REALK,      0.062805749268093_REALK,      0.000000000000000_REALK, &
      0.048377124784396_REALK,      0.000000000000000_REALK,     -0.083745058114588_REALK, &
      0.000000000000000_REALK,      0.030900115802059_REALK,      0.000000000000000_REALK, &
      0.019487011650336_REALK,      0.000000000000000_REALK,      0.047201618743498_REALK, &
     -0.035621198707335_REALK,      0.000000000000000_REALK,     -0.028952486593053_REALK, &
      0.000000000000000_REALK,      0.016718766570717_REALK,      0.000000000000000_REALK, &
     -0.032250790047973_REALK,      0.000000000000000_REALK,      0.013746006213117_REALK, &
      0.000000000000000_REALK,     -0.080425377140238_REALK,      0.000000000000000_REALK, &
      0.038044008559546_REALK,      0.000000000000000_REALK,      0.009965956183219_REALK, &
      0.000000000000000_REALK,      0.016556166511063_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.015395411360712_REALK,      0.000000000000000_REALK, &
      0.003603821635450_REALK,      0.000000000000000_REALK,     -0.004852609738526_REALK, &
      0.000000000000000_REALK,     -0.049736031244354_REALK,      0.000000000000000_REALK, &
      0.041278156053786_REALK,      0.000000000000000_REALK,     -0.017031231217807_REALK, &
      0.000000000000000_REALK,     -0.013423414099542_REALK,      0.000000000000000_REALK, &
      0.054823245759352_REALK,      0.000000000000000_REALK,      0.002672439373926_REALK, &
     -0.004955894767119_REALK,      0.000000000000000_REALK,     -0.031909214272477_REALK, &
      0.000000000000000_REALK,      0.018522701020141_REALK,      0.000000000000000_REALK, &
     -0.002335404389793_REALK,      0.000000000000000_REALK,      0.013007192420399_REALK, &
      0.000000000000000_REALK,     -0.087547894448885_REALK,      0.000000000000000_REALK, &
      0.005722119694206_REALK,      0.000000000000000_REALK,      0.045994997221249_REALK, &
      0.000000000000000_REALK,     -0.067725575894979_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.028683683828831_REALK,      0.000000000000000_REALK, &
     -0.009106788807127_REALK,      0.000000000000000_REALK,      0.020729758301049_REALK, &
      0.000000000000000_REALK,     -0.043171459287816_REALK,      0.000000000000000_REALK, &
      0.135795075112586_REALK,      0.000000000000000_REALK,     -0.154378892891395_REALK, &
      0.000000000000000_REALK,      0.052207711097320_REALK,      0.000000000000000_REALK, &
     -0.026081633294298_REALK,      0.000000000000000_REALK,      0.038862577640626_REALK, &
     -0.041802969238739_REALK,      0.000000000000000_REALK,     -0.065358556977157_REALK, &
      0.000000000000000_REALK,     -0.020029606670965_REALK,      0.000000000000000_REALK, &
     -0.071233140295978_REALK,      0.000000000000000_REALK,      0.031393863965067_REALK, &
      0.000000000000000_REALK,      0.272782361971680_REALK,      0.000000000000000_REALK, &
     -0.086876540399554_REALK,      0.000000000000000_REALK,     -0.075642414493209_REALK, &
      0.000000000000000_REALK,     -0.289139196328040_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.172715613574273_REALK,      0.000000000000000_REALK, &
      0.101091608425002_REALK,      0.000000000000000_REALK,      0.034088714151416_REALK, &
      0.000000000000000_REALK,      0.018287502111098_REALK,      0.000000000000000_REALK, &
      0.135585500492443_REALK,      0.000000000000000_REALK,      0.047379130540937_REALK, &
      0.000000000000000_REALK,      0.003685768719052_REALK,      0.000000000000000_REALK, &
      0.045767273274103_REALK,      0.000000000000000_REALK,      0.636772824208385_REALK, &
     -0.129757555606250_REALK,      0.000000000000000_REALK,     -0.058450107828051_REALK, &
      0.000000000000000_REALK,      0.032095094141160_REALK,      0.000000000000000_REALK, &
      0.062173977099473_REALK,      0.000000000000000_REALK,      0.198848275396142_REALK, &
     -0.370507558494454_REALK,      0.000000000000000_REALK,     -0.046794764462657_REALK, &
      0.000000000000000_REALK,     -0.040046528290060_REALK,      0.000000000000000_REALK, &
     -0.135975033528170_REALK,      0.000000000000000_REALK,     -0.203476441890533_REALK, &
     -0.144990332524812_REALK,      0.000000000000000_REALK,      0.034983363847087_REALK, &
      0.000000000000000_REALK,     -0.144676784710414_REALK,      0.000000000000000_REALK, &
     -0.257971149282226_REALK,      0.000000000000000_REALK,     -0.271453997150519_REALK, &
      0.000000000000000_REALK,      0.085838623165698_REALK,      0.000000000000000_REALK, &
      0.058340199805119_REALK,      0.000000000000000_REALK,      0.101667160364823_REALK, &
      0.000000000000000_REALK,      0.451031435882454_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.135194796153519_REALK,      0.000000000000000_REALK, &
     -0.213039396804010_REALK,      0.000000000000000_REALK,      0.084857725673970_REALK, &
      0.000000000000000_REALK,      0.291047024133563_REALK,      0.000000000000000_REALK, &
     -0.102465948065857_REALK,      0.000000000000000_REALK,      0.172743337292725_REALK, &
      0.000000000000000_REALK,     -0.088737975603461_REALK,      0.000000000000000_REALK, &
     -0.187577661400400_REALK,      0.000000000000000_REALK,     -0.039718969181567_REALK, &
     -0.069294312823092_REALK,      0.000000000000000_REALK,      0.237435698983875_REALK, &
      0.000000000000000_REALK,     -0.051389629787456_REALK,      0.000000000000000_REALK, &
     -0.168129907496136_REALK,      0.000000000000000_REALK,     -0.096116239016722_REALK, &
      0.000000000000000_REALK,      0.015797961142571_REALK,      0.000000000000000_REALK, &
     -0.040092720122690_REALK,      0.000000000000000_REALK,      0.009630283683116_REALK, &
      0.000000000000000_REALK,      0.140651364614583_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.121826621089340_REALK,      0.000000000000000_REALK, &
     -0.097466970195382_REALK,      0.000000000000000_REALK,      0.009888172585214_REALK, &
      0.000000000000000_REALK,      0.148674187049440_REALK,      0.000000000000000_REALK, &
     -0.080269231012014_REALK,      0.000000000000000_REALK,     -0.076517613489574_REALK, &
      0.000000000000000_REALK,      0.043210509310225_REALK,      0.000000000000000_REALK, &
     -0.070210603671084_REALK,      0.000000000000000_REALK,      0.043414837846435_REALK, &
     -0.075379946500746_REALK,      0.000000000000000_REALK,      0.050060439205439_REALK, &
      0.000000000000000_REALK,     -0.011034820294855_REALK,      0.000000000000000_REALK, &
     -0.125816347013282_REALK,      0.000000000000000_REALK,     -0.073110089205682_REALK, &
      0.000000000000000_REALK,      0.024349684343426_REALK,      0.000000000000000_REALK, &
      0.009203721265518_REALK,      0.000000000000000_REALK,     -0.009757501798643_REALK, &
      0.000000000000000_REALK,     -0.116965584996257_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.122908752602785_REALK,      0.000000000000000_REALK, &
      0.029121276433264_REALK,      0.000000000000000_REALK,      0.002450481809639_REALK, &
      0.000000000000000_REALK,     -0.066663145495788_REALK,      0.000000000000000_REALK, &
     -0.008879605881996_REALK,      0.000000000000000_REALK,     -0.076483399657505_REALK, &
      0.000000000000000_REALK,      0.044289275534890_REALK,      0.000000000000000_REALK, &
     -0.000033009454225_REALK,      0.000000000000000_REALK,      0.035724278839089_REALK, &
     -0.022870102296380_REALK,      0.000000000000000_REALK,     -0.030406195782242_REALK, &
      0.000000000000000_REALK,      0.008397439359047_REALK,      0.000000000000000_REALK, &
     -0.061368805094329_REALK,      0.000000000000000_REALK,     -0.023433882958805_REALK, &
      0.000000000000000_REALK,      0.057678788159919_REALK,      0.000000000000000_REALK, &
     -0.023513859149967_REALK,      0.000000000000000_REALK,      0.045935005732933_REALK, &
      0.000000000000000_REALK,     -0.111285757551277_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.156799561231861_REALK,      0.000000000000000_REALK, &
     -0.010791817333326_REALK,      0.000000000000000_REALK,      0.094849828162893_REALK, &
      0.000000000000000_REALK,      0.026688937962312_REALK,      0.000000000000000_REALK, &
     -0.086637433356806_REALK,      0.000000000000000_REALK,     -0.159685373086010_REALK, &
      0.000000000000000_REALK,     -0.036382826835252_REALK,      0.000000000000000_REALK, &
     -0.157929655769268_REALK,      0.000000000000000_REALK,      0.084818367312360_REALK, &
     -0.153182105907775_REALK,      0.000000000000000_REALK,     -0.089190419468353_REALK, &
      0.000000000000000_REALK,     -0.188553706456203_REALK,      0.000000000000000_REALK, &
     -0.300150385023276_REALK,      0.000000000000000_REALK,     -0.023664209432381_REALK, &
      0.000000000000000_REALK,      0.411100619421828_REALK,      0.000000000000000_REALK, &
      0.225456025777775_REALK,      0.000000000000000_REALK,      0.070718241002187_REALK, &
      0.000000000000000_REALK,      0.025720572024543_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.408091393985330_REALK,      0.000000000000000_REALK, &
      0.285872455986109_REALK,      0.000000000000000_REALK,      0.131534734786118_REALK, &
      0.000000000000000_REALK,      0.127768827639555_REALK,      0.000000000000000_REALK, &
     -0.302139375069178_REALK,      0.000000000000000_REALK,     -0.137900662868475_REALK, &
      0.000000000000000_REALK,      0.082761865543496_REALK,      0.000000000000000_REALK, &
      0.153308004061911_REALK,      0.000000000000000_REALK,      0.493965850200616_REALK, &
     -0.243328224739658_REALK,      0.000000000000000_REALK,     -0.113039480752903_REALK, &
      0.000000000000000_REALK,     -0.030742421370841_REALK,      0.000000000000000_REALK, &
      0.036811769978811_REALK,      0.000000000000000_REALK,      0.263065289277112_REALK/
  ! results of test 6, ket-major order, dd/dxdz
  data REF_CONTR_INTS(11485:11880) /                                                       &
      0.000000000000000_REALK,     -0.166008083551938_REALK,      0.000000000000000_REALK, &
     -0.006695682134362_REALK,      0.000000000000000_REALK,      0.003130685524310_REALK, &
      0.000000000000000_REALK,     -0.008322965011679_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.036175222550825_REALK,      0.000000000000000_REALK, &
      0.008549412901514_REALK,      0.000000000000000_REALK,     -0.042980602018593_REALK, &
      0.000000000000000_REALK,      0.057957042123695_REALK,      0.000000000000000_REALK, &
     -0.191369179680721_REALK,      0.000000000000000_REALK,      0.018682399648702_REALK, &
      0.000000000000000_REALK,     -0.038577874218490_REALK,      0.000000000000000_REALK, &
      0.213072678864109_REALK,      0.000000000000000_REALK,      0.001098200250870_REALK, &
     -0.024233594532379_REALK,      0.000000000000000_REALK,      0.035244810663025_REALK, &
      0.000000000000000_REALK,     -0.007607512151415_REALK,      0.000000000000000_REALK, &
      0.028519029318985_REALK,      0.000000000000000_REALK,      0.041156649270275_REALK, &
      0.000000000000000_REALK,      0.053877286664571_REALK,      0.000000000000000_REALK, &
      0.123166766630240_REALK,      0.000000000000000_REALK,     -0.020653909339413_REALK, &
      0.000000000000000_REALK,      0.210324464118252_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.042874493429564_REALK,      0.000000000000000_REALK, &
      0.008153450676785_REALK,      0.000000000000000_REALK,     -0.076108897578242_REALK, &
      0.000000000000000_REALK,      0.048176842809365_REALK,      0.000000000000000_REALK, &
      0.037695712291251_REALK,      0.000000000000000_REALK,      0.177054903772370_REALK, &
      0.000000000000000_REALK,     -0.163103434761780_REALK,      0.000000000000000_REALK, &
     -0.008810212935707_REALK,      0.000000000000000_REALK,     -0.004234429576517_REALK, &
      0.003337782415307_REALK,      0.000000000000000_REALK,      0.001981748928217_REALK, &
      0.000000000000000_REALK,      0.009635055492195_REALK,      0.000000000000000_REALK, &
     -0.042882419541249_REALK,      0.000000000000000_REALK,     -0.003948826114923_REALK, &
      0.000000000000000_REALK,      0.054134933987392_REALK,      0.000000000000000_REALK, &
     -0.103800991451948_REALK,      0.000000000000000_REALK,     -0.167668723536164_REALK, &
      0.000000000000000_REALK,      0.005173240822708_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.033642448963084_REALK,      0.000000000000000_REALK, &
     -0.007797716007019_REALK,      0.000000000000000_REALK,     -0.029988458519761_REALK, &
      0.000000000000000_REALK,      0.010564456639554_REALK,      0.000000000000000_REALK, &
     -0.027766903671739_REALK,      0.000000000000000_REALK,     -0.126696689209244_REALK, &
      0.000000000000000_REALK,      0.165206961351054_REALK,      0.000000000000000_REALK, &
      0.016958717375769_REALK,      0.000000000000000_REALK,      0.052890426546702_REALK, &
      0.013266636955422_REALK,      0.000000000000000_REALK,      0.036618263967469_REALK, &
      0.000000000000000_REALK,      0.020976737036526_REALK,      0.000000000000000_REALK, &
      0.023259503143412_REALK,      0.000000000000000_REALK,      0.008287158162720_REALK, &
      0.000000000000000_REALK,     -0.058338406168244_REALK,      0.000000000000000_REALK, &
     -0.167668723536164_REALK,      0.000000000000000_REALK,     -0.086595805497320_REALK, &
      0.000000000000000_REALK,     -0.084871689861685_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.054589270718788_REALK,      0.000000000000000_REALK, &
     -0.029988458519761_REALK,      0.000000000000000_REALK,      0.038284678278110_REALK, &
      0.000000000000000_REALK,      0.038492694742762_REALK,      0.000000000000000_REALK, &
      0.060595321909776_REALK,      0.000000000000000_REALK,     -0.008810212935707_REALK, &
      0.000000000000000_REALK,      0.015214912676925_REALK,      0.000000000000000_REALK, &
     -0.201843619092628_REALK,      0.000000000000000_REALK,     -0.031970772813672_REALK, &
     -0.043157172061265_REALK,      0.000000000000000_REALK,     -0.042882419541249_REALK, &
      0.000000000000000_REALK,      0.026242718318921_REALK,      0.000000000000000_REALK, &
     -0.087699788815791_REALK,      0.000000000000000_REALK,     -0.013745423751586_REALK, &
      0.000000000000000_REALK,      0.210324464118252_REALK,      0.000000000000000_REALK, &
     -0.011223836145227_REALK,      0.000000000000000_REALK,     -0.152339614090958_REALK, &
      0.000000000000000_REALK,      0.046953417750380_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.048176842809365_REALK,      0.000000000000000_REALK, &
      0.008619489561120_REALK,      0.000000000000000_REALK,     -0.014175160180782_REALK, &
      0.000000000000000_REALK,     -0.064749144908962_REALK,      0.000000000000000_REALK, &
      0.001098200250870_REALK,      0.000000000000000_REALK,      0.117206977118285_REALK, &
      0.000000000000000_REALK,     -0.001745809780461_REALK,      0.000000000000000_REALK, &
     -0.001754026681726_REALK,      0.000000000000000_REALK,      0.183596331664702_REALK, &
      0.041156649270275_REALK,      0.000000000000000_REALK,      0.034038139156307_REALK, &
      0.000000000000000_REALK,      0.062099552145752_REALK,      0.000000000000000_REALK, &
     -0.049838874041094_REALK,      0.000000000000000_REALK,      0.060523519299419_REALK, &
      0.000000000000000_REALK,      0.010287485342762_REALK,      0.000000000000000_REALK, &
     -0.019230732874053_REALK,      0.000000000000000_REALK,     -0.073512862575922_REALK, &
      0.000000000000000_REALK,      0.169371265482595_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.015666210271867_REALK,      0.000000000000000_REALK, &
     -0.019276890509751_REALK,      0.000000000000000_REALK,      0.010069625927282_REALK, &
      0.000000000000000_REALK,      0.039633844691011_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.090580593028265_REALK,      0.000000000000000_REALK, &
      0.019334553031010_REALK,      0.000000000000000_REALK,     -0.100918792660021_REALK, &
      0.000000000000000_REALK,      0.136990163521651_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.063709516384802_REALK,      0.000000000000000_REALK, &
      0.019800236371216_REALK,      0.000000000000000_REALK,     -0.081929844869445_REALK, &
      0.000000000000000_REALK,      0.090296841515640_REALK,      0.000000000000000_REALK, &
     -0.061830050015355_REALK,      0.000000000000000_REALK,      0.083628874824520_REALK, &
      0.000000000000000_REALK,     -0.024676344474155_REALK,      0.000000000000000_REALK, &
      0.082320135637703_REALK,      0.000000000000000_REALK,      0.096734407218831_REALK, &
     -0.073854881071578_REALK,      0.000000000000000_REALK,      0.080080837947785_REALK, &
      0.000000000000000_REALK,      0.061320928196649_REALK,      0.000000000000000_REALK, &
     -0.057819940985916_REALK,      0.000000000000000_REALK,      0.091202965661507_REALK, &
      0.000000000000000_REALK,      0.107987659578500_REALK,      0.000000000000000_REALK, &
      0.023004435836688_REALK,      0.000000000000000_REALK,     -0.179079318432788_REALK, &
      0.000000000000000_REALK,      0.122344162801216_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.030241748399732_REALK,      0.000000000000000_REALK, &
      0.011008701910764_REALK,      0.000000000000000_REALK,     -0.166597312362099_REALK, &
      0.000000000000000_REALK,      0.057165632160687_REALK,      0.000000000000000_REALK, &
      0.012338254093541_REALK,      0.000000000000000_REALK,      0.011475092183149_REALK, &
      0.000000000000000_REALK,      0.012965541480745_REALK,      0.000000000000000_REALK, &
     -0.097757813328658_REALK,      0.000000000000000_REALK,     -0.012155935083830_REALK, &
     -0.025063825112062_REALK,      0.000000000000000_REALK,     -0.021078927015642_REALK, &
      0.000000000000000_REALK,      0.094111669904059_REALK,      0.000000000000000_REALK, &
     -0.138445498314149_REALK,      0.000000000000000_REALK,      0.000447716999295_REALK, &
      0.000000000000000_REALK,     -0.077434154228547_REALK,      0.000000000000000_REALK, &
     -0.022333407153820_REALK,      0.000000000000000_REALK,     -0.075815654088883_REALK, &
      0.000000000000000_REALK,      0.027269322993257_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.073005231103657_REALK,      0.000000000000000_REALK, &
      0.002566368275217_REALK,      0.000000000000000_REALK,     -0.051968591257322_REALK, &
      0.000000000000000_REALK,     -0.006845412600393_REALK,      0.000000000000000_REALK, &
      0.027596617529075_REALK,      0.000000000000000_REALK,      0.075173117029187_REALK, &
      0.000000000000000_REALK,      0.056526930882060_REALK,      0.000000000000000_REALK, &
      0.055348439221160_REALK,      0.000000000000000_REALK,      0.027223033509695_REALK, &
      0.048284859415023_REALK,      0.000000000000000_REALK,      0.181710443322551_REALK, &
      0.000000000000000_REALK,      0.011733316858884_REALK,      0.000000000000000_REALK, &
      0.039988109596312_REALK,      0.000000000000000_REALK,     -0.047565798285320_REALK, &
      0.000000000000000_REALK,     -0.138232154615492_REALK,      0.000000000000000_REALK, &
     -0.075815654088883_REALK,      0.000000000000000_REALK,      0.083708134018625_REALK, &
      0.000000000000000_REALK,      0.082585219659069_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.002842672228048_REALK,      0.000000000000000_REALK, &
     -0.051968591257322_REALK,      0.000000000000000_REALK,      0.146645021916823_REALK, &
      0.000000000000000_REALK,      0.146528818264458_REALK,      0.000000000000000_REALK, &
     -0.097224742154753_REALK,      0.000000000000000_REALK,     -0.097757813328658_REALK, &
      0.000000000000000_REALK,      0.061582835661533_REALK,      0.000000000000000_REALK, &
     -0.214412493435019_REALK,      0.000000000000000_REALK,     -0.037639162800705_REALK, &
     -0.105752918490103_REALK,      0.000000000000000_REALK,     -0.138445498314149_REALK, &
      0.000000000000000_REALK,      0.060619748497264_REALK,      0.000000000000000_REALK, &
     -0.137241302257166_REALK,      0.000000000000000_REALK,      0.027466491837485_REALK, &
      0.000000000000000_REALK,      0.122344162801217_REALK,      0.000000000000000_REALK, &
      0.020897932436602_REALK,      0.000000000000000_REALK,     -0.042084186695839_REALK, &
      0.000000000000000_REALK,     -0.140133516311271_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.057165632160687_REALK,      0.000000000000000_REALK, &
      0.005100109008386_REALK,      0.000000000000000_REALK,      0.033566723648507_REALK, &
      0.000000000000000_REALK,     -0.261752290176432_REALK,      0.000000000000000_REALK, &
      0.096734407218831_REALK,      0.000000000000000_REALK,      0.078778031818378_REALK, &
      0.000000000000000_REALK,      0.145341650063973_REALK,      0.000000000000000_REALK, &
     -0.114839070624801_REALK,      0.000000000000000_REALK,      0.152937553842647_REALK, &
      0.091202965661507_REALK,      0.000000000000000_REALK,      0.121266774221130_REALK, &
      0.000000000000000_REALK,      0.137744232538251_REALK,      0.000000000000000_REALK, &
     -0.129182852938608_REALK,      0.000000000000000_REALK,      0.033004842612439_REALK, &
      0.000000000000000_REALK,      0.036053604721912_REALK,      0.000000000000000_REALK, &
     -0.047185694129331_REALK,      0.000000000000000_REALK,      0.012501721736433_REALK, &
      0.000000000000000_REALK,      0.101513391608231_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.072851983259327_REALK,      0.000000000000000_REALK, &
     -0.040163019845234_REALK,      0.000000000000000_REALK,      0.120420577325890_REALK, &
      0.000000000000000_REALK,      0.031868726100921_REALK,      0.000000000000000_REALK/
  ! results of test 6, ket-major order, dd/dydz
  data REF_CONTR_INTS(11881:12276) /                                                       &
      0.000000000000000_REALK,      0.113595274348076_REALK,      0.000000000000000_REALK, &
     -0.023515679399082_REALK,      0.000000000000000_REALK,     -0.006695682134362_REALK, &
      0.000000000000000_REALK,     -0.160643839489570_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.069719753476716_REALK,      0.000000000000000_REALK, &
      0.045416113016836_REALK,      0.000000000000000_REALK,      0.008549412901514_REALK, &
      0.000000000000000_REALK,     -0.013541056239065_REALK,      0.000000000000000_REALK, &
      0.131388557093155_REALK,      0.000000000000000_REALK,     -0.159366811480944_REALK, &
      0.000000000000000_REALK,      0.032621856740003_REALK,      0.000000000000000_REALK, &
     -0.009177037433557_REALK,      0.000000000000000_REALK,     -0.173838772770200_REALK, &
      0.082406406643203_REALK,      0.000000000000000_REALK,     -0.038467697637520_REALK, &
      0.000000000000000_REALK,     -0.048264702983082_REALK,      0.000000000000000_REALK, &
     -0.055713102562686_REALK,      0.000000000000000_REALK,     -0.031350894948884_REALK, &
      0.000000000000000_REALK,     -0.178993283662929_REALK,      0.000000000000000_REALK, &
      0.040400842423401_REALK,      0.000000000000000_REALK,      0.123166766630240_REALK, &
      0.000000000000000_REALK,     -0.046595677292302_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.074987756402100_REALK,      0.000000000000000_REALK, &
     -0.044050862916192_REALK,      0.000000000000000_REALK,      0.008153450676785_REALK, &
      0.000000000000000_REALK,     -0.065361320060910_REALK,      0.000000000000000_REALK, &
     -0.027053230989933_REALK,      0.000000000000000_REALK,      0.037386363315912_REALK, &
      0.000000000000000_REALK,     -0.097546208842507_REALK,      0.000000000000000_REALK, &
      0.173048933599596_REALK,      0.000000000000000_REALK,     -0.064028425336115_REALK, &
      0.017853740859508_REALK,      0.000000000000000_REALK,     -0.057800809392827_REALK, &
      0.000000000000000_REALK,      0.019353787595628_REALK,      0.000000000000000_REALK, &
      0.073840240325217_REALK,      0.000000000000000_REALK,      0.011253730414462_REALK, &
      0.000000000000000_REALK,     -0.001260898924723_REALK,      0.000000000000000_REALK, &
      0.020247854390223_REALK,      0.000000000000000_REALK,     -0.103800991451948_REALK, &
      0.000000000000000_REALK,      0.110477514955756_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.048826953019646_REALK,      0.000000000000000_REALK, &
      0.053593973673576_REALK,      0.000000000000000_REALK,     -0.007797716007019_REALK, &
      0.000000000000000_REALK,      0.005938322243174_REALK,      0.000000000000000_REALK, &
     -0.023950098111706_REALK,      0.000000000000000_REALK,     -0.073198769246075_REALK, &
      0.000000000000000_REALK,      0.127916825396078_REALK,      0.000000000000000_REALK, &
     -0.083151012704285_REALK,      0.000000000000000_REALK,      0.039593685473557_REALK, &
     -0.017951652865119_REALK,      0.000000000000000_REALK,      0.035258045485772_REALK, &
      0.000000000000000_REALK,      0.016241916121071_REALK,      0.000000000000000_REALK, &
     -0.008690837957720_REALK,      0.000000000000000_REALK,     -0.009228133911034_REALK, &
      0.000000000000000_REALK,      0.054134933987392_REALK,      0.000000000000000_REALK, &
     -0.103800991451948_REALK,      0.000000000000000_REALK,     -0.167668723536164_REALK, &
      0.000000000000000_REALK,      0.005173240822708_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.033642448963084_REALK,      0.000000000000000_REALK, &
     -0.007797716007019_REALK,      0.000000000000000_REALK,     -0.029988458519761_REALK, &
      0.000000000000000_REALK,      0.010564456639554_REALK,      0.000000000000000_REALK, &
     -0.019360905219652_REALK,      0.000000000000000_REALK,      0.173048933599596_REALK, &
      0.000000000000000_REALK,     -0.099355769711112_REALK,      0.000000000000000_REALK, &
     -0.056579826735874_REALK,      0.000000000000000_REALK,      0.052864993146632_REALK, &
     -0.019238626938987_REALK,      0.000000000000000_REALK,      0.073840240325217_REALK, &
      0.000000000000000_REALK,     -0.025669511809596_REALK,      0.000000000000000_REALK, &
     -0.008569151363811_REALK,      0.000000000000000_REALK,     -0.025393941902582_REALK, &
      0.000000000000000_REALK,     -0.046595677292302_REALK,      0.000000000000000_REALK, &
      0.143855681033279_REALK,      0.000000000000000_REALK,     -0.011223836145227_REALK, &
      0.000000000000000_REALK,      0.257064713012710_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.065361320060910_REALK,      0.000000000000000_REALK, &
      0.065799752208599_REALK,      0.000000000000000_REALK,      0.008619489561120_REALK, &
      0.000000000000000_REALK,      0.058050601024340_REALK,      0.000000000000000_REALK, &
     -0.173838772770200_REALK,      0.000000000000000_REALK,     -0.079466048797687_REALK, &
      0.000000000000000_REALK,      0.033288231874401_REALK,      0.000000000000000_REALK, &
      0.187701636611479_REALK,      0.000000000000000_REALK,     -0.137406935703622_REALK, &
     -0.031350894948884_REALK,      0.000000000000000_REALK,     -0.044846372278686_REALK, &
      0.000000000000000_REALK,      0.024594043281068_REALK,      0.000000000000000_REALK, &
      0.052662429581937_REALK,      0.000000000000000_REALK,     -0.054307760362807_REALK, &
      0.000000000000000_REALK,     -0.150328410941876_REALK,      0.000000000000000_REALK, &
     -0.058931757671922_REALK,      0.000000000000000_REALK,     -0.019230732874053_REALK, &
      0.000000000000000_REALK,     -0.126822723227583_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.042541129569862_REALK,      0.000000000000000_REALK, &
      0.005754285095376_REALK,      0.000000000000000_REALK,     -0.019276890509751_REALK, &
      0.000000000000000_REALK,     -0.052561114888363_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.167573584017124_REALK,      0.000000000000000_REALK, &
      0.103445434366184_REALK,      0.000000000000000_REALK,      0.019334553031010_REALK, &
      0.000000000000000_REALK,     -0.037087556833115_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.132596148279346_REALK,      0.000000000000000_REALK, &
      0.117235177141383_REALK,      0.000000000000000_REALK,      0.019800236371216_REALK, &
      0.000000000000000_REALK,     -0.030873853885714_REALK,      0.000000000000000_REALK, &
      0.201470638096593_REALK,      0.000000000000000_REALK,     -0.095092731429502_REALK, &
      0.000000000000000_REALK,     -0.107423687039301_REALK,      0.000000000000000_REALK, &
     -0.125508270718228_REALK,      0.000000000000000_REALK,     -0.080907280810482_REALK, &
      0.106865566742685_REALK,      0.000000000000000_REALK,     -0.081748990776445_REALK, &
      0.000000000000000_REALK,     -0.170079957867486_REALK,      0.000000000000000_REALK, &
     -0.184445277192716_REALK,      0.000000000000000_REALK,     -0.031892541661376_REALK, &
      0.000000000000000_REALK,     -0.177431515321447_REALK,      0.000000000000000_REALK, &
     -0.098867838068624_REALK,      0.000000000000000_REALK,      0.023004435836688_REALK, &
      0.000000000000000_REALK,     -0.152993815665082_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.194242028875696_REALK,      0.000000000000000_REALK, &
     -0.142876701769306_REALK,      0.000000000000000_REALK,      0.011008701910764_REALK, &
      0.000000000000000_REALK,     -0.162287758029020_REALK,      0.000000000000000_REALK, &
      0.041999398472378_REALK,      0.000000000000000_REALK,     -0.131585728421533_REALK, &
      0.000000000000000_REALK,      0.039198160714556_REALK,      0.000000000000000_REALK, &
      0.177723042254954_REALK,      0.000000000000000_REALK,      0.019172210516343_REALK, &
      0.034536233070473_REALK,      0.000000000000000_REALK,     -0.165793669506995_REALK, &
      0.000000000000000_REALK,      0.091036992254231_REALK,      0.000000000000000_REALK, &
      0.162459177036264_REALK,      0.000000000000000_REALK,      0.071499178525357_REALK, &
      0.000000000000000_REALK,     -0.116131620710810_REALK,      0.000000000000000_REALK, &
      0.123337018539227_REALK,      0.000000000000000_REALK,     -0.022333407153820_REALK, &
      0.000000000000000_REALK,      0.026697838777820_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.073738514918386_REALK,      0.000000000000000_REALK, &
      0.167500329086114_REALK,      0.000000000000000_REALK,      0.002566368275217_REALK, &
      0.000000000000000_REALK,     -0.116069628430050_REALK,      0.000000000000000_REALK, &
     -0.046088077490165_REALK,      0.000000000000000_REALK,      0.076186194037958_REALK, &
      0.000000000000000_REALK,      0.043767801844934_REALK,      0.000000000000000_REALK, &
     -0.026671820850826_REALK,      0.000000000000000_REALK,     -0.016313059571883_REALK, &
      0.002749128369987_REALK,      0.000000000000000_REALK,      0.137187092288438_REALK, &
      0.000000000000000_REALK,      0.009084899520460_REALK,      0.000000000000000_REALK, &
      0.044526821163630_REALK,      0.000000000000000_REALK,     -0.056028997831206_REALK, &
      0.000000000000000_REALK,     -0.077434154228547_REALK,      0.000000000000000_REALK, &
     -0.022333407153820_REALK,      0.000000000000000_REALK,     -0.075815654088883_REALK, &
      0.000000000000000_REALK,      0.027269322993257_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.073005231103657_REALK,      0.000000000000000_REALK, &
      0.002566368275217_REALK,      0.000000000000000_REALK,     -0.051968591257322_REALK, &
      0.000000000000000_REALK,     -0.006845412600393_REALK,      0.000000000000000_REALK, &
     -0.048347857844813_REALK,      0.000000000000000_REALK,      0.177723042254954_REALK, &
      0.000000000000000_REALK,     -0.065067399814564_REALK,      0.000000000000000_REALK, &
     -0.025545108620545_REALK,      0.000000000000000_REALK,     -0.055198566276033_REALK, &
      0.004226677639858_REALK,      0.000000000000000_REALK,      0.162459177036264_REALK, &
      0.000000000000000_REALK,     -0.023313459571113_REALK,      0.000000000000000_REALK, &
      0.043209118838315_REALK,      0.000000000000000_REALK,     -0.090509304407206_REALK, &
      0.000000000000000_REALK,     -0.152993815665081_REALK,      0.000000000000000_REALK, &
      0.161499442690312_REALK,      0.000000000000000_REALK,      0.020897932436602_REALK, &
      0.000000000000000_REALK,      0.152541547554559_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.162287758029020_REALK,      0.000000000000000_REALK, &
      0.099393509103330_REALK,      0.000000000000000_REALK,      0.005100109008386_REALK, &
      0.000000000000000_REALK,      0.014987514976165_REALK,      0.000000000000000_REALK, &
     -0.080907280810482_REALK,      0.000000000000000_REALK,     -0.112163285134154_REALK, &
      0.000000000000000_REALK,      0.063580301758058_REALK,      0.000000000000000_REALK, &
      0.133133123402208_REALK,      0.000000000000000_REALK,     -0.130927710825000_REALK, &
     -0.031892541661376_REALK,      0.000000000000000_REALK,     -0.044386013995746_REALK, &
      0.000000000000000_REALK,     -0.013942678901320_REALK,      0.000000000000000_REALK, &
      0.049126504411609_REALK,      0.000000000000000_REALK,     -0.138495028323890_REALK, &
      0.000000000000000_REALK,     -0.107643786980408_REALK,      0.000000000000000_REALK, &
      0.003914280315413_REALK,      0.000000000000000_REALK,     -0.047185694129331_REALK, &
      0.000000000000000_REALK,     -0.129732537501826_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.026177259018350_REALK,      0.000000000000000_REALK, &
      0.108963907859938_REALK,      0.000000000000000_REALK,     -0.040163019845234_REALK, &
      0.000000000000000_REALK,     -0.086861039548118_REALK,      0.000000000000000_REALK/
  ! results of test 6, ket-major order, dd/dzdz
  data REF_CONTR_INTS(12277:12672) /                                                       &
     -0.115488894935139_REALK,      0.000000000000000_REALK,     -0.019221477580735_REALK, &
      0.000000000000000_REALK,     -0.001672731781500_REALK,      0.000000000000000_REALK, &
      0.126735966459773_REALK,      0.000000000000000_REALK,     -0.043104606900804_REALK, &
     -0.017577358933846_REALK,      0.000000000000000_REALK,     -0.003036280379993_REALK, &
      0.000000000000000_REALK,      0.005371612791506_REALK,      0.000000000000000_REALK, &
      0.025671831390226_REALK,      0.000000000000000_REALK,     -0.004158746481431_REALK, &
      0.000000000000000_REALK,     -0.002336278277882_REALK,      0.000000000000000_REALK, &
      0.162258159444840_REALK,      0.000000000000000_REALK,     -0.008066600769493_REALK, &
      0.000000000000000_REALK,      0.294711684719566_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.009409095004667_REALK,      0.000000000000000_REALK, &
      0.040324479715373_REALK,      0.000000000000000_REALK,     -0.045161378221315_REALK, &
      0.000000000000000_REALK,      0.100021746782471_REALK,      0.000000000000000_REALK, &
      0.002574437682541_REALK,      0.000000000000000_REALK,      0.355260019643267_REALK, &
      0.000000000000000_REALK,     -0.265114054040882_REALK,      0.000000000000000_REALK, &
     -0.035450707795969_REALK,      0.000000000000000_REALK,      0.137644609746174_REALK, &
     -0.007950293799196_REALK,      0.000000000000000_REALK,      0.118541413555903_REALK, &
      0.000000000000000_REALK,     -0.035862016971256_REALK,      0.000000000000000_REALK, &
     -0.059081993774176_REALK,      0.000000000000000_REALK,      0.043545261652275_REALK, &
      0.000000000000000_REALK,      0.266281319891229_REALK,      0.000000000000000_REALK, &
     -0.299970251033578_REALK,      0.000000000000000_REALK,     -0.455159178901757_REALK, &
      0.000000000000000_REALK,     -0.043557771431922_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.043551704021852_REALK,      0.000000000000000_REALK, &
     -0.091232829504663_REALK,      0.000000000000000_REALK,     -0.183112661055678_REALK, &
      0.000000000000000_REALK,      0.015858090269633_REALK,      0.000000000000000_REALK, &
      0.058199289457712_REALK,      0.000000000000000_REALK,     -0.272898813416225_REALK, &
      0.000000000000000_REALK,      0.326759266073624_REALK,      0.000000000000000_REALK, &
     -0.195655969083132_REALK,      0.000000000000000_REALK,      0.002274811923255_REALK, &
     -0.009794887935250_REALK,      0.000000000000000_REALK,     -0.053565874838517_REALK, &
      0.000000000000000_REALK,      0.156311775872685_REALK,      0.000000000000000_REALK, &
     -0.124443844942206_REALK,      0.000000000000000_REALK,      0.020998034257124_REALK, &
      0.000000000000000_REALK,     -0.162617120239955_REALK,      0.000000000000000_REALK, &
      0.312134189865641_REALK,      0.000000000000000_REALK,      0.403127117029410_REALK, &
      0.000000000000000_REALK,      0.069865672622700_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.028019946651099_REALK,      0.000000000000000_REALK, &
      0.147476568170313_REALK,      0.000000000000000_REALK,      0.190468733276162_REALK, &
      0.000000000000000_REALK,     -0.012038292258174_REALK,      0.000000000000000_REALK, &
     -0.018796724469366_REALK,      0.000000000000000_REALK,     -0.415088779993410_REALK, &
      0.000000000000000_REALK,      0.422015675218429_REALK,      0.000000000000000_REALK, &
     -0.010502746925490_REALK,      0.000000000000000_REALK,     -0.049146263176765_REALK, &
     -0.015565122287952_REALK,      0.000000000000000_REALK,     -0.124560858441512_REALK, &
      0.000000000000000_REALK,      0.201879568503621_REALK,      0.000000000000000_REALK, &
      0.053414749725791_REALK,      0.000000000000000_REALK,      0.025503624638135_REALK, &
      0.000000000000000_REALK,     -0.037133742233622_REALK,      0.000000000000000_REALK, &
     -0.212855877408000_REALK,      0.000000000000000_REALK,     -0.012968973663120_REALK, &
      0.000000000000000_REALK,     -0.257984566589265_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.040459358723662_REALK,      0.000000000000000_REALK, &
     -0.153963557581730_REALK,      0.000000000000000_REALK,      0.053586219716409_REALK, &
      0.000000000000000_REALK,     -0.116286737825392_REALK,      0.000000000000000_REALK, &
      0.165247028301252_REALK,      0.000000000000000_REALK,     -0.067530851331551_REALK, &
      0.000000000000000_REALK,      0.113901732363517_REALK,      0.000000000000000_REALK, &
     -0.313827917049970_REALK,      0.000000000000000_REALK,      0.033074599739273_REALK, &
      0.037557072941463_REALK,      0.000000000000000_REALK,      0.009048643467033_REALK, &
      0.000000000000000_REALK,      0.015407504041434_REALK,      0.000000000000000_REALK, &
     -0.206533399900775_REALK,      0.000000000000000_REALK,      0.000216436600608_REALK, &
      0.000000000000000_REALK,      0.255435875050554_REALK,      0.000000000000000_REALK, &
     -0.044275123292300_REALK,      0.000000000000000_REALK,     -0.177814533687584_REALK, &
      0.000000000000000_REALK,      0.053061717639973_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.099069658185174_REALK,      0.000000000000000_REALK, &
      0.038265107476685_REALK,      0.000000000000000_REALK,     -0.004481712796132_REALK, &
      0.000000000000000_REALK,      0.010638735152548_REALK,      0.000000000000000_REALK, &
     -0.041201428477772_REALK,      0.000000000000000_REALK,      0.087460311307548_REALK, &
      0.000000000000000_REALK,     -0.010868010406978_REALK,      0.000000000000000_REALK, &
      0.002347362107171_REALK,      0.000000000000000_REALK,      0.113030904571444_REALK, &
     -0.013044318622778_REALK,      0.000000000000000_REALK,      0.022928358792493_REALK, &
      0.000000000000000_REALK,      0.034900241847503_REALK,      0.000000000000000_REALK, &
      0.001857594162455_REALK,      0.000000000000000_REALK,      0.029053240771846_REALK, &
     -0.045137507254261_REALK,      0.000000000000000_REALK,     -0.009023372826823_REALK, &
      0.000000000000000_REALK,      0.012302511501103_REALK,      0.000000000000000_REALK, &
      0.068132302787238_REALK,      0.000000000000000_REALK,     -0.010812872012114_REALK, &
     -0.033440271252880_REALK,      0.000000000000000_REALK,      0.011287694436718_REALK, &
      0.000000000000000_REALK,      0.014982317932451_REALK,      0.000000000000000_REALK, &
     -0.002749106026902_REALK,      0.000000000000000_REALK,     -0.014955063326054_REALK, &
      0.000000000000000_REALK,     -0.017123298992224_REALK,      0.000000000000000_REALK, &
      0.103943355736525_REALK,      0.000000000000000_REALK,     -0.105128220158446_REALK, &
      0.000000000000000_REALK,      0.251211567246177_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.084863899003823_REALK,      0.000000000000000_REALK, &
      0.023304578243618_REALK,      0.000000000000000_REALK,     -0.102156612939333_REALK, &
      0.000000000000000_REALK,      0.108292785919650_REALK,      0.000000000000000_REALK, &
     -0.015912079081981_REALK,      0.000000000000000_REALK,      0.292925593896555_REALK, &
      0.000000000000000_REALK,     -0.104947862225124_REALK,      0.000000000000000_REALK, &
     -0.136606622410553_REALK,      0.000000000000000_REALK,      0.105986707417666_REALK, &
     -0.046685314418747_REALK,      0.000000000000000_REALK,      0.203447845794758_REALK, &
      0.000000000000000_REALK,      0.111025903628186_REALK,      0.000000000000000_REALK, &
     -0.153382734986341_REALK,      0.000000000000000_REALK,      0.088886030980538_REALK, &
      0.000000000000000_REALK,      0.114764208261432_REALK,      0.000000000000000_REALK, &
     -0.228709690615078_REALK,      0.000000000000000_REALK,     -0.445510478602155_REALK, &
      0.000000000000000_REALK,      0.035163754955160_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.042645839683095_REALK,      0.000000000000000_REALK, &
     -0.101458867089200_REALK,      0.000000000000000_REALK,     -0.347781504707903_REALK, &
      0.000000000000000_REALK,      0.033546173344428_REALK,      0.000000000000000_REALK, &
     -0.017937996353814_REALK,      0.000000000000000_REALK,     -0.144782871144340_REALK, &
      0.000000000000000_REALK,      0.375967724383826_REALK,      0.000000000000000_REALK, &
     -0.294356376125288_REALK,      0.000000000000000_REALK,      0.050699889860848_REALK, &
     -0.066848057664089_REALK,      0.000000000000000_REALK,      0.045727144322100_REALK, &
      0.000000000000000_REALK,      0.345863354805574_REALK,      0.000000000000000_REALK, &
     -0.308161304665776_REALK,      0.000000000000000_REALK,      0.023650283131829_REALK, &
      0.000000000000000_REALK,      0.050945092477512_REALK,      0.000000000000000_REALK, &
      0.354451680622352_REALK,      0.000000000000000_REALK,      0.457780944141444_REALK, &
      0.000000000000000_REALK,     -0.021887690222991_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.190257745858397_REALK,      0.000000000000000_REALK, &
      0.319739383287343_REALK,      0.000000000000000_REALK,      0.412949365914934_REALK, &
      0.000000000000000_REALK,     -0.081740996067706_REALK,      0.000000000000000_REALK, &
     -0.039231285349872_REALK,      0.000000000000000_REALK,     -0.315641745933222_REALK, &
      0.000000000000000_REALK,      0.485569315210871_REALK,      0.000000000000000_REALK, &
      0.117292419780230_REALK,      0.000000000000000_REALK,      0.056575392198579_REALK, &
     -0.001415182430307_REALK,      0.000000000000000_REALK,     -0.101179656319786_REALK, &
      0.000000000000000_REALK,      0.446688961465284_REALK,      0.000000000000000_REALK, &
      0.221593507771895_REALK,      0.000000000000000_REALK,      0.077617007504768_REALK, &
      0.000000000000000_REALK,     -0.096704210754462_REALK,      0.000000000000000_REALK, &
     -0.358947464399623_REALK,      0.000000000000000_REALK,      0.116911946279978_REALK, &
      0.000000000000000_REALK,     -0.285074140883473_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.066576225717765_REALK,      0.000000000000000_REALK, &
     -0.459071267250033_REALK,      0.000000000000000_REALK,      0.245191667228166_REALK, &
      0.000000000000000_REALK,     -0.171955781991510_REALK,      0.000000000000000_REALK, &
      0.097186774921925_REALK,      0.000000000000000_REALK,      0.016084142285199_REALK, &
      0.000000000000000_REALK,      0.045089059342912_REALK,      0.000000000000000_REALK, &
     -0.490128559054940_REALK,      0.000000000000000_REALK,      0.004546802440584_REALK, &
      0.025509989812210_REALK,      0.000000000000000_REALK,      0.050272980924783_REALK, &
      0.000000000000000_REALK,     -0.047700386183696_REALK,      0.000000000000000_REALK, &
     -0.466472994232203_REALK,      0.000000000000000_REALK,     -0.035166022584491_REALK, &
      0.000000000000000_REALK,      0.239470774870541_REALK,      0.000000000000000_REALK, &
      0.085754006323443_REALK,      0.000000000000000_REALK,     -0.021934062218122_REALK, &
      0.000000000000000_REALK,      0.032286750916757_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.214539551056817_REALK,      0.000000000000000_REALK, &
      0.108941999924273_REALK,      0.000000000000000_REALK,      0.067390340936307_REALK, &
      0.000000000000000_REALK,     -0.052355776104128_REALK,      0.000000000000000_REALK, &
     -0.033120504311498_REALK,      0.000000000000000_REALK,      0.054982763037519_REALK, &
      0.000000000000000_REALK,      0.079931417878661_REALK,      0.000000000000000_REALK, &
      0.003373897310731_REALK,      0.000000000000000_REALK,      0.073948229656936_REALK, &
     -0.004952949349914_REALK,      0.000000000000000_REALK,      0.064199221831383_REALK, &
      0.000000000000000_REALK,      0.097342556057948_REALK,      0.000000000000000_REALK, &
      0.017475512966551_REALK,      0.000000000000000_REALK,      0.020522354849245_REALK/
  ! results of test 7, ket-major order, 01ODGXXX
  data REF_CONTR_INTS(12673:13068) /                                                       &
      0.311005728362798_REALK,      0.000000000000000_REALK,      0.016872886428355_REALK, &
      0.000000000000000_REALK,     -0.019821298374452_REALK,      0.000000000000000_REALK, &
     -0.049496024093027_REALK,      0.000000000000000_REALK,     -0.161264215037823_REALK, &
      0.076854762287476_REALK,      0.000000000000000_REALK,     -0.013307568328481_REALK, &
      0.000000000000000_REALK,      0.053149345794725_REALK,      0.000000000000000_REALK, &
      0.075061371897431_REALK,      0.000000000000000_REALK,      0.068234576400216_REALK, &
      0.000000000000000_REALK,     -0.145276280683054_REALK,      0.000000000000000_REALK, &
     -0.134458072833011_REALK,      0.000000000000000_REALK,     -0.020362616768595_REALK, &
      0.000000000000000_REALK,     -0.262941793963895_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.005427990052182_REALK,      0.000000000000000_REALK, &
      0.047829303710460_REALK,      0.000000000000000_REALK,      0.010998116617070_REALK, &
      0.000000000000000_REALK,     -0.083856285795590_REALK,      0.000000000000000_REALK, &
     -0.075901353101238_REALK,      0.000000000000000_REALK,     -0.147378890119413_REALK, &
      0.000000000000000_REALK,      0.119323750549986_REALK,      0.000000000000000_REALK, &
      0.102937949189073_REALK,      0.000000000000000_REALK,      0.033519070466336_REALK, &
     -0.021100439801500_REALK,      0.000000000000000_REALK,     -0.079057521699516_REALK, &
      0.000000000000000_REALK,      0.023551404386988_REALK,      0.000000000000000_REALK, &
      0.008962484879088_REALK,      0.000000000000000_REALK,     -0.007721644340339_REALK, &
      0.000000000000000_REALK,     -0.000359067453036_REALK,      0.000000000000000_REALK, &
      0.121677656567026_REALK,      0.000000000000000_REALK,      0.081652548098072_REALK, &
      0.000000000000000_REALK,      0.111705395347469_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.000457311605518_REALK,      0.000000000000000_REALK, &
      0.005149059059493_REALK,      0.000000000000000_REALK,      0.022413743627699_REALK, &
      0.000000000000000_REALK,      0.009918966062092_REALK,      0.000000000000000_REALK, &
      0.015090327997846_REALK,      0.000000000000000_REALK,      0.091948146542353_REALK, &
      0.000000000000000_REALK,     -0.082684476295847_REALK,      0.000000000000000_REALK, &
     -0.012373136134091_REALK,      0.000000000000000_REALK,     -0.017115856460913_REALK, &
      0.008900627857298_REALK,      0.000000000000000_REALK,      0.032525728109046_REALK, &
      0.000000000000000_REALK,     -0.020815139661148_REALK,      0.000000000000000_REALK, &
      0.008380097461219_REALK,      0.000000000000000_REALK,     -0.000576375581269_REALK, &
      0.000000000000000_REALK,     -0.088552868177349_REALK,      0.000000000000000_REALK, &
     -0.168121144420139_REALK,      0.000000000000000_REALK,     -0.068353007654017_REALK, &
      0.000000000000000_REALK,     -0.089090183241782_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.121470985503015_REALK,      0.000000000000000_REALK, &
     -0.115153316855344_REALK,      0.000000000000000_REALK,     -0.013513915049614_REALK, &
      0.000000000000000_REALK,      0.017695192550924_REALK,      0.000000000000000_REALK, &
      0.034229797638013_REALK,      0.000000000000000_REALK,      0.143000906735234_REALK, &
      0.000000000000000_REALK,     -0.186091608536804_REALK,      0.000000000000000_REALK, &
     -0.168193362680981_REALK,      0.000000000000000_REALK,     -0.115645923619609_REALK, &
     -0.052894761782683_REALK,      0.000000000000000_REALK,      0.054118390325222_REALK, &
      0.000000000000000_REALK,     -0.140321056922640_REALK,      0.000000000000000_REALK, &
     -0.165845718685401_REALK,      0.000000000000000_REALK,     -0.089100754740910_REALK, &
      0.000000000000000_REALK,      0.181878181998162_REALK,      0.000000000000000_REALK, &
      0.180102633432341_REALK,      0.000000000000000_REALK,      0.017098944272943_REALK, &
      0.000000000000000_REALK,      0.123413792570749_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.179391771772300_REALK,      0.000000000000000_REALK, &
      0.148872018565821_REALK,      0.000000000000000_REALK,     -0.006623333380819_REALK, &
      0.000000000000000_REALK,      0.000384172089181_REALK,      0.000000000000000_REALK, &
     -0.043658537681652_REALK,      0.000000000000000_REALK,      0.015316753414579_REALK, &
      0.000000000000000_REALK,      0.056959413596736_REALK,      0.000000000000000_REALK, &
      0.176313388010471_REALK,      0.000000000000000_REALK,      0.140799378715313_REALK, &
      0.056006276718563_REALK,      0.000000000000000_REALK,     -0.012604244826839_REALK, &
      0.000000000000000_REALK,      0.097743905304965_REALK,      0.000000000000000_REALK, &
      0.180391006267823_REALK,      0.000000000000000_REALK,      0.107619660613957_REALK, &
      0.000000000000000_REALK,     -0.264573754354031_REALK,      0.000000000000000_REALK, &
     -0.091630403035146_REALK,      0.000000000000000_REALK,      0.027144963981119_REALK, &
      0.000000000000000_REALK,      0.021726048950074_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.233700003859597_REALK,      0.000000000000000_REALK, &
     -0.132039130432810_REALK,      0.000000000000000_REALK,     -0.003631406488233_REALK, &
      0.000000000000000_REALK,     -0.033507616064233_REALK,      0.000000000000000_REALK, &
     -0.044754534707991_REALK,      0.000000000000000_REALK,      0.018322584266979_REALK, &
      0.000000000000000_REALK,     -0.073483275662910_REALK,      0.000000000000000_REALK, &
     -0.086817206930379_REALK,      0.000000000000000_REALK,     -0.358049266054868_REALK, &
     -0.021610901471500_REALK,      0.000000000000000_REALK,      0.001010844347306_REALK, &
      0.000000000000000_REALK,     -0.027336051648163_REALK,      0.000000000000000_REALK, &
     -0.051616895910090_REALK,      0.000000000000000_REALK,     -0.217841056026803_REALK, &
     -0.218755251854822_REALK,      0.000000000000000_REALK,      0.172680947237205_REALK, &
      0.000000000000000_REALK,      0.172289153311739_REALK,      0.000000000000000_REALK, &
      0.075002358841360_REALK,      0.000000000000000_REALK,      0.106351503321860_REALK, &
      0.483166925000468_REALK,      0.000000000000000_REALK,      0.365554612133428_REALK, &
      0.000000000000000_REALK,      0.287540222892086_REALK,      0.000000000000000_REALK, &
      0.250545986990012_REALK,      0.000000000000000_REALK,      0.340471846023255_REALK, &
      0.000000000000000_REALK,     -0.191802735151057_REALK,      0.000000000000000_REALK, &
      0.123216037189505_REALK,      0.000000000000000_REALK,     -0.164251552244838_REALK, &
      0.000000000000000_REALK,      0.361058017120210_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.258000550490171_REALK,      0.000000000000000_REALK, &
      0.553554672685987_REALK,      0.000000000000000_REALK,     -0.285374892508099_REALK, &
      0.000000000000000_REALK,      0.066918746128293_REALK,      0.000000000000000_REALK, &
      0.078442664573572_REALK,      0.000000000000000_REALK,      0.094615993630085_REALK, &
      0.000000000000000_REALK,     -0.005574368031454_REALK,      0.000000000000000_REALK, &
      0.366695796059052_REALK,      0.000000000000000_REALK,     -0.073985045278887_REALK, &
     -0.179453149781884_REALK,      0.000000000000000_REALK,      0.026644817426507_REALK, &
      0.000000000000000_REALK,     -0.273197011092624_REALK,      0.000000000000000_REALK, &
      0.133097608128302_REALK,      0.000000000000000_REALK,     -0.068164409658638_REALK, &
      0.000000000000000_REALK,      0.030566901925515_REALK,      0.000000000000000_REALK, &
      0.159811928882528_REALK,      0.000000000000000_REALK,      0.064925736752493_REALK, &
      0.000000000000000_REALK,     -0.195895468374304_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.125144014272146_REALK,      0.000000000000000_REALK, &
      0.106363155855617_REALK,      0.000000000000000_REALK,      0.165463457146648_REALK, &
      0.000000000000000_REALK,     -0.033420770378713_REALK,      0.000000000000000_REALK, &
     -0.017232129112186_REALK,      0.000000000000000_REALK,     -0.069532890088892_REALK, &
      0.000000000000000_REALK,      0.026183196296815_REALK,      0.000000000000000_REALK, &
     -0.096761556380692_REALK,      0.000000000000000_REALK,      0.027779014742550_REALK, &
      0.050341273569904_REALK,      0.000000000000000_REALK,     -0.093201986034876_REALK, &
      0.000000000000000_REALK,      0.104758289026330_REALK,      0.000000000000000_REALK, &
     -0.006968550693565_REALK,      0.000000000000000_REALK,      0.019086725498637_REALK, &
      0.000000000000000_REALK,     -0.033226030515080_REALK,      0.000000000000000_REALK, &
     -0.382441879223173_REALK,      0.000000000000000_REALK,      0.064589895517696_REALK, &
      0.000000000000000_REALK,      0.440902544910502_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.080300953098816_REALK,      0.000000000000000_REALK, &
     -0.661238789936875_REALK,      0.000000000000000_REALK,      0.164675601921707_REALK, &
      0.000000000000000_REALK,      0.618905660035665_REALK,      0.000000000000000_REALK, &
     -0.263722109596143_REALK,      0.000000000000000_REALK,     -0.468032298795574_REALK, &
      0.000000000000000_REALK,     -0.266754900740741_REALK,      0.000000000000000_REALK, &
     -0.472312473672539_REALK,      0.000000000000000_REALK,      0.208028649479915_REALK, &
     -0.278169858831583_REALK,      0.000000000000000_REALK,     -0.877198640129199_REALK, &
      0.000000000000000_REALK,     -0.487095382392622_REALK,      0.000000000000000_REALK, &
     -0.623339322132578_REALK,      0.000000000000000_REALK,      0.345453967813162_REALK, &
      0.000000000000000_REALK,      0.058538674846347_REALK,      0.000000000000000_REALK, &
      0.412335306678541_REALK,      0.000000000000000_REALK,     -0.178414488241189_REALK, &
      0.000000000000000_REALK,     -0.615887525676797_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.064961289351296_REALK,      0.000000000000000_REALK, &
      0.776900488300210_REALK,      0.000000000000000_REALK,     -0.332748860728883_REALK, &
      0.000000000000000_REALK,     -0.942223413693785_REALK,      0.000000000000000_REALK, &
      0.344804615509942_REALK,      0.000000000000000_REALK,      0.430089352028908_REALK, &
      0.000000000000000_REALK,      0.398224926053669_REALK,      0.000000000000000_REALK, &
      0.377156474193203_REALK,      0.000000000000000_REALK,     -0.204232925933681_REALK, &
      0.407084489036604_REALK,      0.000000000000000_REALK,      0.685057940945000_REALK, &
      0.000000000000000_REALK,      0.681660971301561_REALK,      0.000000000000000_REALK, &
      0.706694547114087_REALK,      0.000000000000000_REALK,     -0.385093885405863_REALK, &
      0.000000000000000_REALK,     -0.190626129356779_REALK,      0.000000000000000_REALK, &
     -0.491682042988035_REALK,      0.000000000000000_REALK,      0.144741172470893_REALK, &
      0.000000000000000_REALK,      0.615954135559824_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.265042012276800_REALK,      0.000000000000000_REALK, &
     -0.525306864500360_REALK,      0.000000000000000_REALK,      0.260490324088151_REALK, &
      0.000000000000000_REALK,      0.995314602970030_REALK,      0.000000000000000_REALK, &
     -0.688680696676057_REALK,      0.000000000000000_REALK,     -0.216985322637516_REALK, &
      0.000000000000000_REALK,     -0.061323376605346_REALK,      0.000000000000000_REALK, &
     -0.237469918811586_REALK,      0.000000000000000_REALK,      0.143309774350488_REALK, &
     -0.861414957237836_REALK,      0.000000000000000_REALK,     -0.204320449504457_REALK, &
      0.000000000000000_REALK,      0.025357695593160_REALK,      0.000000000000000_REALK, &
     -0.061353769468337_REALK,      0.000000000000000_REALK,      0.467277283482449_REALK/
  ! results of test 7, ket-major order, 01ODGXXY
  data REF_CONTR_INTS(13069:13464) /                                                       &
      0.090266575208516_REALK,      0.000000000000000_REALK,     -0.006148438905139_REALK, &
      0.000000000000000_REALK,     -0.007042812279831_REALK,      0.000000000000000_REALK, &
     -0.002819901778572_REALK,      0.000000000000000_REALK,     -0.054322460035037_REALK, &
      0.030179269475980_REALK,      0.000000000000000_REALK,     -0.003820284187544_REALK, &
      0.000000000000000_REALK,     -0.018208371293183_REALK,      0.000000000000000_REALK, &
     -0.021126481186628_REALK,      0.000000000000000_REALK,     -0.094330197926239_REALK, &
      0.000000000000000_REALK,     -0.051334644384155_REALK,      0.000000000000000_REALK, &
     -0.008151650373959_REALK,      0.000000000000000_REALK,      0.031012235594602_REALK, &
      0.000000000000000_REALK,     -0.079582837186495_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.082418149986718_REALK,      0.000000000000000_REALK, &
     -0.041608648581769_REALK,      0.000000000000000_REALK,      0.018837406289962_REALK, &
      0.000000000000000_REALK,     -0.060670990795587_REALK,      0.000000000000000_REALK, &
     -0.018076133163431_REALK,      0.000000000000000_REALK,     -0.037481601038161_REALK, &
      0.000000000000000_REALK,      0.019128637175084_REALK,      0.000000000000000_REALK, &
      0.025151506491752_REALK,      0.000000000000000_REALK,     -0.006080190118787_REALK, &
      0.009929370384134_REALK,      0.000000000000000_REALK,     -0.023587023020042_REALK, &
      0.000000000000000_REALK,      0.030355244863656_REALK,      0.000000000000000_REALK, &
      0.044818296174247_REALK,      0.000000000000000_REALK,      0.032106568051373_REALK, &
      0.000000000000000_REALK,     -0.025217130359711_REALK,      0.000000000000000_REALK, &
      0.029817264953867_REALK,      0.000000000000000_REALK,      0.035761772528328_REALK, &
      0.000000000000000_REALK,      0.015932400736067_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.028027769477359_REALK,      0.000000000000000_REALK, &
      0.027491055823686_REALK,      0.000000000000000_REALK,      0.008328850261268_REALK, &
      0.000000000000000_REALK,     -0.000271342381916_REALK,      0.000000000000000_REALK, &
      0.003231731338788_REALK,      0.000000000000000_REALK,      0.036833046769155_REALK, &
      0.000000000000000_REALK,     -0.037211263816800_REALK,      0.000000000000000_REALK, &
      0.020533990065102_REALK,      0.000000000000000_REALK,     -0.007927111494749_REALK, &
     -0.001068341737767_REALK,      0.000000000000000_REALK,      0.014474242475932_REALK, &
      0.000000000000000_REALK,     -0.022378118020815_REALK,      0.000000000000000_REALK, &
     -0.000222942380169_REALK,      0.000000000000000_REALK,     -0.010452475605647_REALK, &
      0.000000000000000_REALK,      0.019122274851719_REALK,      0.000000000000000_REALK, &
     -0.013459615286931_REALK,      0.000000000000000_REALK,     -0.029175179937963_REALK, &
      0.000000000000000_REALK,     -0.003648647531091_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.017055637060025_REALK,      0.000000000000000_REALK, &
      0.012878500337501_REALK,      0.000000000000000_REALK,     -0.012071481999525_REALK, &
      0.000000000000000_REALK,     -0.007230381606789_REALK,      0.000000000000000_REALK, &
      0.008730978212445_REALK,      0.000000000000000_REALK,      0.036476687232043_REALK, &
      0.000000000000000_REALK,     -0.023150578896665_REALK,      0.000000000000000_REALK, &
      0.009415413567306_REALK,      0.000000000000000_REALK,      0.003865334684308_REALK, &
      0.020288422861095_REALK,      0.000000000000000_REALK,      0.015465942709490_REALK, &
      0.000000000000000_REALK,      0.010541028319918_REALK,      0.000000000000000_REALK, &
      0.027651759606965_REALK,      0.000000000000000_REALK,      0.011504336153828_REALK, &
      0.000000000000000_REALK,      0.009138885643596_REALK,      0.000000000000000_REALK, &
     -0.007149565688782_REALK,      0.000000000000000_REALK,     -0.020230488363140_REALK, &
      0.000000000000000_REALK,      0.028870458923583_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.024888414724067_REALK,      0.000000000000000_REALK, &
     -0.023141301359534_REALK,      0.000000000000000_REALK,     -0.005745888011626_REALK, &
      0.000000000000000_REALK,      0.019884870662535_REALK,      0.000000000000000_REALK, &
     -0.010107306828018_REALK,      0.000000000000000_REALK,      0.036748514367445_REALK, &
      0.000000000000000_REALK,     -0.039369920888943_REALK,      0.000000000000000_REALK, &
      0.023486645960310_REALK,      0.000000000000000_REALK,     -0.010372166745935_REALK, &
     -0.008048580400675_REALK,      0.000000000000000_REALK,      0.024250730032039_REALK, &
      0.000000000000000_REALK,     -0.035967943258752_REALK,      0.000000000000000_REALK, &
     -0.002296238313316_REALK,      0.000000000000000_REALK,     -0.017831032537521_REALK, &
      0.000000000000000_REALK,     -0.049606629037243_REALK,      0.000000000000000_REALK, &
      0.032473108827092_REALK,      0.000000000000000_REALK,      0.015695358817451_REALK, &
      0.000000000000000_REALK,      0.045965195752998_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.002554924871913_REALK,      0.000000000000000_REALK, &
      0.009061965378438_REALK,      0.000000000000000_REALK,     -0.008358548884684_REALK, &
      0.000000000000000_REALK,      0.019539970310525_REALK,      0.000000000000000_REALK, &
     -0.070759490625401_REALK,      0.000000000000000_REALK,      0.009822857881739_REALK, &
      0.000000000000000_REALK,     -0.008159353945664_REALK,      0.000000000000000_REALK, &
      0.034201334757035_REALK,      0.000000000000000_REALK,     -0.065068603339771_REALK, &
     -0.015246968728212_REALK,      0.000000000000000_REALK,      0.022247918537464_REALK, &
      0.000000000000000_REALK,     -0.023417132751006_REALK,      0.000000000000000_REALK, &
      0.001403738657458_REALK,      0.000000000000000_REALK,     -0.037993056636457_REALK, &
      0.061025438943322_REALK,      0.000000000000000_REALK,      0.055820611982701_REALK, &
      0.000000000000000_REALK,      0.048105921676305_REALK,      0.000000000000000_REALK, &
      0.015770473663817_REALK,      0.000000000000000_REALK,     -0.030958153693904_REALK, &
     -0.189501853905474_REALK,      0.000000000000000_REALK,     -0.012171855004382_REALK, &
      0.000000000000000_REALK,      0.028105432440859_REALK,      0.000000000000000_REALK, &
     -0.066139906229043_REALK,      0.000000000000000_REALK,     -0.045806625625773_REALK, &
      0.000000000000000_REALK,     -0.034658014791389_REALK,      0.000000000000000_REALK, &
      0.111406170485283_REALK,      0.000000000000000_REALK,     -0.147720079824010_REALK, &
      0.000000000000000_REALK,      0.015616316331997_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.146432865241185_REALK,      0.000000000000000_REALK, &
     -0.008096741947259_REALK,      0.000000000000000_REALK,     -0.115140543510207_REALK, &
      0.000000000000000_REALK,      0.107687181534532_REALK,      0.000000000000000_REALK, &
      0.003163152969863_REALK,      0.000000000000000_REALK,     -0.028017389225243_REALK, &
      0.000000000000000_REALK,     -0.119174535471856_REALK,      0.000000000000000_REALK, &
      0.104330932275394_REALK,      0.000000000000000_REALK,      0.016982633924979_REALK, &
      0.085662280833773_REALK,      0.000000000000000_REALK,      0.023173534988722_REALK, &
      0.000000000000000_REALK,     -0.057181799769242_REALK,      0.000000000000000_REALK, &
      0.183803823023306_REALK,      0.000000000000000_REALK,      0.017768252807407_REALK, &
      0.000000000000000_REALK,      0.009752031788729_REALK,      0.000000000000000_REALK, &
      0.039451624183029_REALK,      0.000000000000000_REALK,      0.050633554849817_REALK, &
      0.000000000000000_REALK,      0.013891918678229_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.039105981544984_REALK,      0.000000000000000_REALK, &
      0.122674662700515_REALK,      0.000000000000000_REALK,      0.056229993464536_REALK, &
      0.000000000000000_REALK,     -0.049095087592522_REALK,      0.000000000000000_REALK, &
     -0.000570951564338_REALK,      0.000000000000000_REALK,     -0.035536790430222_REALK, &
      0.000000000000000_REALK,      0.041265674430759_REALK,      0.000000000000000_REALK, &
      0.014856308750993_REALK,      0.000000000000000_REALK,      0.007948629480892_REALK, &
     -0.030073109184392_REALK,      0.000000000000000_REALK,     -0.073473130035395_REALK, &
      0.000000000000000_REALK,      0.020868257789527_REALK,      0.000000000000000_REALK, &
     -0.027153944135689_REALK,      0.000000000000000_REALK,      0.007213055575640_REALK, &
      0.000000000000000_REALK,     -0.003384157645680_REALK,      0.000000000000000_REALK, &
     -0.027764843019486_REALK,      0.000000000000000_REALK,     -0.059133025586600_REALK, &
      0.000000000000000_REALK,     -0.005293915493488_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.017024523288103_REALK,      0.000000000000000_REALK, &
      0.019340671494882_REALK,      0.000000000000000_REALK,     -0.097617580671141_REALK, &
      0.000000000000000_REALK,     -0.098662313679597_REALK,      0.000000000000000_REALK, &
      0.021816282836221_REALK,      0.000000000000000_REALK,     -0.038642005952839_REALK, &
      0.000000000000000_REALK,      0.075455340163876_REALK,      0.000000000000000_REALK, &
     -0.033427304499176_REALK,      0.000000000000000_REALK,      0.005220597970594_REALK, &
      0.078276142241615_REALK,      0.000000000000000_REALK,      0.028031177930760_REALK, &
      0.000000000000000_REALK,      0.134687754138760_REALK,      0.000000000000000_REALK, &
      0.043739166639229_REALK,      0.000000000000000_REALK,     -0.042554783717783_REALK, &
      0.000000000000000_REALK,     -0.047804229749725_REALK,      0.000000000000000_REALK, &
      0.001295267346096_REALK,      0.000000000000000_REALK,     -0.006839900386735_REALK, &
      0.000000000000000_REALK,     -0.025728723402804_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.059719701319823_REALK,      0.000000000000000_REALK, &
     -0.055162288913628_REALK,      0.000000000000000_REALK,      0.013214368474026_REALK, &
      0.000000000000000_REALK,      0.090149160218451_REALK,      0.000000000000000_REALK, &
     -0.032807021570770_REALK,      0.000000000000000_REALK,      0.038194267463934_REALK, &
      0.000000000000000_REALK,      0.054384246839849_REALK,      0.000000000000000_REALK, &
      0.050891744372093_REALK,      0.000000000000000_REALK,     -0.006591093227192_REALK, &
     -0.087414271024526_REALK,      0.000000000000000_REALK,     -0.022061194738726_REALK, &
      0.000000000000000_REALK,      0.028599386851742_REALK,      0.000000000000000_REALK, &
     -0.026188189270441_REALK,      0.000000000000000_REALK,      0.044519348568182_REALK, &
      0.000000000000000_REALK,     -0.031447481631256_REALK,      0.000000000000000_REALK, &
     -0.008423911014992_REALK,      0.000000000000000_REALK,     -0.073850730415114_REALK, &
      0.000000000000000_REALK,      0.093339274760751_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.019764846982619_REALK,      0.000000000000000_REALK, &
      0.000810491429761_REALK,      0.000000000000000_REALK,     -0.048956281274708_REALK, &
      0.000000000000000_REALK,     -0.062416680726117_REALK,      0.000000000000000_REALK, &
     -0.023856455711896_REALK,      0.000000000000000_REALK,      0.055475646176360_REALK, &
      0.000000000000000_REALK,      0.090393294943531_REALK,      0.000000000000000_REALK, &
     -0.052324314494200_REALK,      0.000000000000000_REALK,      0.031032168810846_REALK, &
      0.054278759499735_REALK,      0.000000000000000_REALK,      0.058030543622927_REALK, &
      0.000000000000000_REALK,      0.036005672161523_REALK,      0.000000000000000_REALK, &
     -0.063975657041221_REALK,      0.000000000000000_REALK,     -0.117362653625642_REALK/
  ! results of test 7, ket-major order, 01ODGXYY
  data REF_CONTR_INTS(13465:13860) /                                                       &
      0.037728931920482_REALK,      0.000000000000000_REALK,     -0.005355581434642_REALK, &
      0.000000000000000_REALK,     -0.008694810810786_REALK,      0.000000000000000_REALK, &
      0.022342398913257_REALK,      0.000000000000000_REALK,     -0.028352596136316_REALK, &
      0.011625593675736_REALK,      0.000000000000000_REALK,      0.013414037546587_REALK, &
      0.000000000000000_REALK,     -0.022239839721162_REALK,      0.000000000000000_REALK, &
      0.037048692612970_REALK,      0.000000000000000_REALK,     -0.030891511749702_REALK, &
      0.000000000000000_REALK,     -0.028835929881218_REALK,      0.000000000000000_REALK, &
      0.010470329563693_REALK,      0.000000000000000_REALK,      0.040564338978608_REALK, &
      0.000000000000000_REALK,     -0.052246734811740_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.001947349481074_REALK,      0.000000000000000_REALK, &
      0.020345207641778_REALK,      0.000000000000000_REALK,      0.013662320958363_REALK, &
      0.000000000000000_REALK,     -0.019278824342280_REALK,      0.000000000000000_REALK, &
     -0.005086290277939_REALK,      0.000000000000000_REALK,     -0.011312780213761_REALK, &
      0.000000000000000_REALK,     -0.007874005026757_REALK,      0.000000000000000_REALK, &
      0.018390822069849_REALK,      0.000000000000000_REALK,     -0.018936949397423_REALK, &
     -0.006191167762969_REALK,      0.000000000000000_REALK,      0.000676463447890_REALK, &
      0.000000000000000_REALK,     -0.029464126673158_REALK,      0.000000000000000_REALK, &
      0.009034793404626_REALK,      0.000000000000000_REALK,     -0.021787549997328_REALK, &
      0.000000000000000_REALK,     -0.019100512518001_REALK,      0.000000000000000_REALK, &
      0.008999105540010_REALK,      0.000000000000000_REALK,      0.023232369979593_REALK, &
      0.000000000000000_REALK,     -0.007783539077992_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.012872403877518_REALK,      0.000000000000000_REALK, &
     -0.006708897116516_REALK,      0.000000000000000_REALK,      0.007656106771978_REALK, &
      0.000000000000000_REALK,      0.004189375644530_REALK,      0.000000000000000_REALK, &
      0.003551406330859_REALK,      0.000000000000000_REALK,      0.018228626159504_REALK, &
      0.000000000000000_REALK,     -0.028024532889010_REALK,      0.000000000000000_REALK, &
      0.029812736359775_REALK,      0.000000000000000_REALK,     -0.009215025768654_REALK, &
      0.011595867526208_REALK,      0.000000000000000_REALK,      0.007029855221590_REALK, &
      0.000000000000000_REALK,     -0.011810302909237_REALK,      0.000000000000000_REALK, &
      0.022939629561593_REALK,      0.000000000000000_REALK,      0.000207191721918_REALK, &
      0.000000000000000_REALK,      0.006897084589834_REALK,      0.000000000000000_REALK, &
     -0.009575533869716_REALK,      0.000000000000000_REALK,     -0.024864431831653_REALK, &
      0.000000000000000_REALK,      0.011891544722941_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.013865280403073_REALK,      0.000000000000000_REALK, &
     -0.008917043120441_REALK,      0.000000000000000_REALK,     -0.009019778462659_REALK, &
      0.000000000000000_REALK,      0.011308272125704_REALK,      0.000000000000000_REALK, &
      0.003273018403289_REALK,      0.000000000000000_REALK,      0.016522880133806_REALK, &
      0.000000000000000_REALK,     -0.016607254538111_REALK,      0.000000000000000_REALK, &
      0.005548660113523_REALK,      0.000000000000000_REALK,     -0.004366869676316_REALK, &
     -0.006681294825058_REALK,      0.000000000000000_REALK,      0.001903295540772_REALK, &
      0.000000000000000_REALK,     -0.011139578052345_REALK,      0.000000000000000_REALK, &
     -0.008998195754468_REALK,      0.000000000000000_REALK,     -0.006617993707300_REALK, &
      0.000000000000000_REALK,      0.013081772984863_REALK,      0.000000000000000_REALK, &
      0.001064365515011_REALK,      0.000000000000000_REALK,     -0.027492603666976_REALK, &
      0.000000000000000_REALK,      0.029985152950225_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.008215879796145_REALK,      0.000000000000000_REALK, &
      0.006030127126289_REALK,      0.000000000000000_REALK,     -0.020761021328233_REALK, &
      0.000000000000000_REALK,      0.011211413522651_REALK,      0.000000000000000_REALK, &
     -0.005057622592698_REALK,      0.000000000000000_REALK,      0.020538477179215_REALK, &
      0.000000000000000_REALK,     -0.023635333492507_REALK,      0.000000000000000_REALK, &
      0.033026825983482_REALK,      0.000000000000000_REALK,     -0.003926394812823_REALK, &
      0.006621703346967_REALK,      0.000000000000000_REALK,      0.016162396436409_REALK, &
      0.000000000000000_REALK,     -0.014082089556116_REALK,      0.000000000000000_REALK, &
      0.016701312403477_REALK,      0.000000000000000_REALK,     -0.003730175198946_REALK, &
      0.000000000000000_REALK,     -0.033519193397049_REALK,      0.000000000000000_REALK, &
      0.002998469409581_REALK,      0.000000000000000_REALK,     -0.010768652299093_REALK, &
      0.000000000000000_REALK,      0.022296689367786_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.009913229086277_REALK,      0.000000000000000_REALK, &
      0.010517188798330_REALK,      0.000000000000000_REALK,     -0.033202829863295_REALK, &
      0.000000000000000_REALK,      0.053907550485838_REALK,      0.000000000000000_REALK, &
     -0.035774864489106_REALK,      0.000000000000000_REALK,      0.013149396041857_REALK, &
      0.000000000000000_REALK,     -0.019088734456936_REALK,      0.000000000000000_REALK, &
      0.025284828019903_REALK,      0.000000000000000_REALK,     -0.072307197035689_REALK, &
     -0.034940362786660_REALK,      0.000000000000000_REALK,      0.004381483473541_REALK, &
      0.000000000000000_REALK,      0.007964479741405_REALK,      0.000000000000000_REALK, &
      0.014730791911242_REALK,      0.000000000000000_REALK,      0.013485572169336_REALK, &
      0.151758092485092_REALK,      0.000000000000000_REALK,     -0.029325598653267_REALK, &
      0.000000000000000_REALK,     -0.010058433849430_REALK,      0.000000000000000_REALK, &
      0.037533560326241_REALK,      0.000000000000000_REALK,     -0.006125997480479_REALK, &
      0.248783828737388_REALK,      0.000000000000000_REALK,      0.010122600203215_REALK, &
      0.000000000000000_REALK,     -0.005730260073195_REALK,      0.000000000000000_REALK, &
      0.018074871052588_REALK,      0.000000000000000_REALK,     -0.028376694646826_REALK, &
      0.000000000000000_REALK,      0.021806188708893_REALK,      0.000000000000000_REALK, &
      0.061116500842656_REALK,      0.000000000000000_REALK,     -0.099183128483447_REALK, &
      0.000000000000000_REALK,     -0.001071282054930_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.030332767684420_REALK,      0.000000000000000_REALK, &
      0.086241043186885_REALK,      0.000000000000000_REALK,     -0.152087898309832_REALK, &
      0.000000000000000_REALK,     -0.021003619904724_REALK,      0.000000000000000_REALK, &
      0.016760937530538_REALK,      0.000000000000000_REALK,     -0.062230573071663_REALK, &
      0.000000000000000_REALK,     -0.127146923115663_REALK,      0.000000000000000_REALK, &
      0.081360970729399_REALK,      0.000000000000000_REALK,      0.029860428417903_REALK, &
     -0.028562476876985_REALK,      0.000000000000000_REALK,     -0.093681957510944_REALK, &
      0.000000000000000_REALK,     -0.184667899562599_REALK,      0.000000000000000_REALK, &
      0.089862050228452_REALK,      0.000000000000000_REALK,      0.039800291489563_REALK, &
      0.000000000000000_REALK,     -0.000585527892826_REALK,      0.000000000000000_REALK, &
      0.023551751814019_REALK,      0.000000000000000_REALK,      0.017110359939026_REALK, &
      0.000000000000000_REALK,      0.056648113857431_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.031660415746690_REALK,      0.000000000000000_REALK, &
      0.006120076804793_REALK,      0.000000000000000_REALK,      0.056893803939986_REALK, &
      0.000000000000000_REALK,      0.071521362385788_REALK,      0.000000000000000_REALK, &
     -0.004527925803681_REALK,      0.000000000000000_REALK,     -0.067926639507729_REALK, &
      0.000000000000000_REALK,     -0.002819139916921_REALK,      0.000000000000000_REALK, &
      0.037199376441502_REALK,      0.000000000000000_REALK,      0.023869656936094_REALK, &
      0.002762247518188_REALK,      0.000000000000000_REALK,     -0.074753240263183_REALK, &
      0.000000000000000_REALK,      0.003105851662792_REALK,      0.000000000000000_REALK, &
      0.025342451965105_REALK,      0.000000000000000_REALK,      0.013428458223722_REALK, &
      0.000000000000000_REALK,     -0.031745090885803_REALK,      0.000000000000000_REALK, &
     -0.002471152618767_REALK,      0.000000000000000_REALK,     -0.054025457041323_REALK, &
      0.000000000000000_REALK,     -0.033674017696873_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.019253897696564_REALK,      0.000000000000000_REALK, &
     -0.012637921606943_REALK,      0.000000000000000_REALK,     -0.055154813133371_REALK, &
      0.000000000000000_REALK,     -0.005473550689173_REALK,      0.000000000000000_REALK, &
     -0.013552399867496_REALK,      0.000000000000000_REALK,     -0.023506471709531_REALK, &
      0.000000000000000_REALK,      0.051973270685925_REALK,      0.000000000000000_REALK, &
     -0.021646433486238_REALK,      0.000000000000000_REALK,      0.002543312438510_REALK, &
     -0.035543039172265_REALK,      0.000000000000000_REALK,     -0.056753157091058_REALK, &
      0.000000000000000_REALK,      0.029662604814433_REALK,      0.000000000000000_REALK, &
     -0.046308919933078_REALK,      0.000000000000000_REALK,      0.011819684216816_REALK, &
      0.000000000000000_REALK,     -0.056424010617114_REALK,      0.000000000000000_REALK, &
      0.025484751792892_REALK,      0.000000000000000_REALK,     -0.044709459549765_REALK, &
      0.000000000000000_REALK,     -0.019492998565235_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.059981759360290_REALK,      0.000000000000000_REALK, &
      0.048572538018445_REALK,      0.000000000000000_REALK,     -0.087489836510173_REALK, &
      0.000000000000000_REALK,     -0.075641638546460_REALK,      0.000000000000000_REALK, &
     -0.024779920615536_REALK,      0.000000000000000_REALK,     -0.009037028020999_REALK, &
      0.000000000000000_REALK,      0.029380101968209_REALK,      0.000000000000000_REALK, &
      0.045323402133806_REALK,      0.000000000000000_REALK,      0.017683491743779_REALK, &
     -0.009325722344950_REALK,      0.000000000000000_REALK,      0.012686269918694_REALK, &
      0.000000000000000_REALK,      0.054580159241338_REALK,      0.000000000000000_REALK, &
      0.022640496396595_REALK,      0.000000000000000_REALK,     -0.031263393249900_REALK, &
      0.000000000000000_REALK,     -0.113857518120868_REALK,      0.000000000000000_REALK, &
      0.049921538849465_REALK,      0.000000000000000_REALK,     -0.133275459559492_REALK, &
      0.000000000000000_REALK,      0.093770124340919_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.092903641258487_REALK,      0.000000000000000_REALK, &
      0.078752022380663_REALK,      0.000000000000000_REALK,     -0.110278193217789_REALK, &
      0.000000000000000_REALK,      0.135869720165877_REALK,      0.000000000000000_REALK, &
     -0.037185167559457_REALK,      0.000000000000000_REALK,      0.059127031680000_REALK, &
      0.000000000000000_REALK,      0.085230051461506_REALK,      0.000000000000000_REALK, &
     -0.057725210932341_REALK,      0.000000000000000_REALK,      0.025380509137647_REALK, &
     -0.039507443149824_REALK,      0.000000000000000_REALK,      0.070891236924856_REALK, &
      0.000000000000000_REALK,      0.084396891105728_REALK,      0.000000000000000_REALK, &
     -0.033232028490380_REALK,      0.000000000000000_REALK,      0.111156163079607_REALK/
  ! results of test 7, ket-major order, 01ODGYYY
  data REF_CONTR_INTS(13861:14256) /                                                       &
      0.024520266565899_REALK,      0.000000000000000_REALK,     -0.001752247462125_REALK, &
      0.000000000000000_REALK,     -0.030067329425716_REALK,      0.000000000000000_REALK, &
      0.044464264392021_REALK,      0.000000000000000_REALK,     -0.067197492752451_REALK, &
     -0.019366759368381_REALK,      0.000000000000000_REALK,     -0.001964030644905_REALK, &
      0.000000000000000_REALK,     -0.005228363475704_REALK,      0.000000000000000_REALK, &
      0.022997322476239_REALK,      0.000000000000000_REALK,     -0.035961994135148_REALK, &
      0.000000000000000_REALK,     -0.022778919180808_REALK,      0.000000000000000_REALK, &
      0.005166774120521_REALK,      0.000000000000000_REALK,      0.038352397954731_REALK, &
      0.000000000000000_REALK,     -0.049605480342944_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.011403925520468_REALK,      0.000000000000000_REALK, &
      0.002467981351137_REALK,      0.000000000000000_REALK,     -0.030770510205125_REALK, &
      0.000000000000000_REALK,      0.035708551688649_REALK,      0.000000000000000_REALK, &
      0.002218488970424_REALK,      0.000000000000000_REALK,     -0.004463716510901_REALK, &
      0.000000000000000_REALK,     -0.023416126834751_REALK,      0.000000000000000_REALK, &
      0.036514920788763_REALK,      0.000000000000000_REALK,     -0.029286135445259_REALK, &
      0.012614656550962_REALK,      0.000000000000000_REALK,      0.004683754513461_REALK, &
      0.000000000000000_REALK,     -0.018358368290281_REALK,      0.000000000000000_REALK, &
      0.036479576544294_REALK,      0.000000000000000_REALK,     -0.003065858541410_REALK, &
      0.000000000000000_REALK,     -0.008140794797882_REALK,      0.000000000000000_REALK, &
      0.004634453626159_REALK,      0.000000000000000_REALK,      0.015603579589807_REALK, &
      0.000000000000000_REALK,     -0.011430546057518_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.010622994849916_REALK,      0.000000000000000_REALK, &
      0.006016770785092_REALK,      0.000000000000000_REALK,     -0.019645450719695_REALK, &
      0.000000000000000_REALK,      0.012270774990481_REALK,      0.000000000000000_REALK, &
      0.009010905840876_REALK,      0.000000000000000_REALK,      0.008495614852513_REALK, &
      0.000000000000000_REALK,     -0.032109372952558_REALK,      0.000000000000000_REALK, &
      0.039130091306501_REALK,      0.000000000000000_REALK,     -0.015670432271337_REALK, &
      0.003071966193357_REALK,      0.000000000000000_REALK,      0.000261906349376_REALK, &
      0.000000000000000_REALK,     -0.019289006798944_REALK,      0.000000000000000_REALK, &
      0.018083819046888_REALK,      0.000000000000000_REALK,     -0.003586863050687_REALK, &
      0.000000000000000_REALK,      0.003310297891994_REALK,      0.000000000000000_REALK, &
     -0.002110972522861_REALK,      0.000000000000000_REALK,     -0.029170288939219_REALK, &
      0.000000000000000_REALK,      0.023196436844123_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.001010283458289_REALK,      0.000000000000000_REALK, &
      0.002469232060569_REALK,      0.000000000000000_REALK,     -0.014636215458724_REALK, &
      0.000000000000000_REALK,      0.002866275799901_REALK,      0.000000000000000_REALK, &
      0.003681713292417_REALK,      0.000000000000000_REALK,      0.007351984885526_REALK, &
      0.000000000000000_REALK,     -0.007610086177264_REALK,      0.000000000000000_REALK, &
      0.008375632133243_REALK,      0.000000000000000_REALK,      0.001523764315658_REALK, &
      0.004715676072020_REALK,      0.000000000000000_REALK,      0.003975133349907_REALK, &
      0.000000000000000_REALK,      0.008067308193914_REALK,      0.000000000000000_REALK, &
     -0.002221499179919_REALK,      0.000000000000000_REALK,      0.007143378577166_REALK, &
      0.000000000000000_REALK,      0.003161981128331_REALK,      0.000000000000000_REALK, &
     -0.002496813598119_REALK,      0.000000000000000_REALK,     -0.042313443492024_REALK, &
      0.000000000000000_REALK,      0.040467823128938_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.004002527107992_REALK,      0.000000000000000_REALK, &
     -0.002265753292676_REALK,      0.000000000000000_REALK,     -0.023457517973747_REALK, &
      0.000000000000000_REALK,      0.020200429029157_REALK,      0.000000000000000_REALK, &
      0.000202706781441_REALK,      0.000000000000000_REALK,      0.012623452701378_REALK, &
      0.000000000000000_REALK,     -0.020047706129608_REALK,      0.000000000000000_REALK, &
      0.023789876013323_REALK,      0.000000000000000_REALK,     -0.005379041781345_REALK, &
      0.000144303581323_REALK,      0.000000000000000_REALK,      0.002758676172908_REALK, &
      0.000000000000000_REALK,      0.017112036209876_REALK,      0.000000000000000_REALK, &
     -0.012417949259909_REALK,      0.000000000000000_REALK,      0.023173005243587_REALK, &
      0.000000000000000_REALK,     -0.013166564110556_REALK,      0.000000000000000_REALK, &
      0.001883995029611_REALK,      0.000000000000000_REALK,     -0.038868633219223_REALK, &
      0.000000000000000_REALK,      0.039658382569780_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.005812884364277_REALK,      0.000000000000000_REALK, &
     -0.012842722004950_REALK,      0.000000000000000_REALK,     -0.039866019995697_REALK, &
      0.000000000000000_REALK,      0.039059523635961_REALK,      0.000000000000000_REALK, &
     -0.024654257684085_REALK,      0.000000000000000_REALK,      0.010265774860465_REALK, &
      0.000000000000000_REALK,     -0.014128165581142_REALK,      0.000000000000000_REALK, &
      0.023865143961876_REALK,      0.000000000000000_REALK,     -0.058895873410973_REALK, &
     -0.016622612815600_REALK,      0.000000000000000_REALK,     -0.003169284100652_REALK, &
      0.000000000000000_REALK,      0.028776625542173_REALK,      0.000000000000000_REALK, &
     -0.049740951087054_REALK,      0.000000000000000_REALK,      0.034605337048879_REALK, &
      0.341782553459633_REALK,      0.000000000000000_REALK,     -0.140986677274852_REALK, &
      0.000000000000000_REALK,     -0.093701166077901_REALK,      0.000000000000000_REALK, &
      0.097987242139509_REALK,      0.000000000000000_REALK,      0.013765551910681_REALK, &
      0.151635368534086_REALK,      0.000000000000000_REALK,     -0.062457616859475_REALK, &
      0.000000000000000_REALK,      0.059996692777281_REALK,      0.000000000000000_REALK, &
     -0.084516961446629_REALK,      0.000000000000000_REALK,      0.304117682934910_REALK, &
      0.000000000000000_REALK,      0.052866555603675_REALK,      0.000000000000000_REALK, &
      0.021426603786966_REALK,      0.000000000000000_REALK,     -0.092659717737961_REALK, &
      0.000000000000000_REALK,      0.065385125281240_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.222632199332107_REALK,      0.000000000000000_REALK, &
      0.127509183776363_REALK,      0.000000000000000_REALK,     -0.404883992670664_REALK, &
      0.000000000000000_REALK,      0.364118088292745_REALK,      0.000000000000000_REALK, &
      0.072260894633832_REALK,      0.000000000000000_REALK,     -0.125996409671008_REALK, &
      0.000000000000000_REALK,     -0.169745864821570_REALK,      0.000000000000000_REALK, &
      0.130488029160604_REALK,      0.000000000000000_REALK,      0.069397337411987_REALK, &
      0.027302786420712_REALK,      0.000000000000000_REALK,     -0.152385785644658_REALK, &
      0.000000000000000_REALK,     -0.191514792658960_REALK,      0.000000000000000_REALK, &
      0.178447780761913_REALK,      0.000000000000000_REALK,      0.101529010045780_REALK, &
      0.000000000000000_REALK,     -0.024333510705972_REALK,      0.000000000000000_REALK, &
      0.018880190425276_REALK,      0.000000000000000_REALK,     -0.027994513161831_REALK, &
      0.000000000000000_REALK,      0.106581673908404_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.143011632690384_REALK,      0.000000000000000_REALK, &
      0.063470401994747_REALK,      0.000000000000000_REALK,     -0.133570944089634_REALK, &
      0.000000000000000_REALK,      0.111157957420866_REALK,      0.000000000000000_REALK, &
     -0.011010565640762_REALK,      0.000000000000000_REALK,     -0.132247691299309_REALK, &
      0.000000000000000_REALK,     -0.066393299396825_REALK,      0.000000000000000_REALK, &
      0.052246148511745_REALK,      0.000000000000000_REALK,      0.058380519376315_REALK, &
     -0.046134015088825_REALK,      0.000000000000000_REALK,     -0.173177347818471_REALK, &
      0.000000000000000_REALK,     -0.076243338898966_REALK,      0.000000000000000_REALK, &
      0.018425094790364_REALK,      0.000000000000000_REALK,      0.045615418793238_REALK, &
      0.000000000000000_REALK,     -0.056350980143572_REALK,      0.000000000000000_REALK, &
      0.032367817950512_REALK,      0.000000000000000_REALK,     -0.072557379438987_REALK, &
      0.000000000000000_REALK,     -0.069017768080808_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.035563099002070_REALK,      0.000000000000000_REALK, &
      0.049222216519484_REALK,      0.000000000000000_REALK,     -0.101444745224240_REALK, &
      0.000000000000000_REALK,     -0.101049819878799_REALK,      0.000000000000000_REALK, &
     -0.032551358606131_REALK,      0.000000000000000_REALK,     -0.016590879083104_REALK, &
      0.000000000000000_REALK,      0.044358688913824_REALK,      0.000000000000000_REALK, &
     -0.033800505075927_REALK,      0.000000000000000_REALK,      0.006835083167764_REALK, &
     -0.034467176390914_REALK,      0.000000000000000_REALK,      0.036455254101223_REALK, &
      0.000000000000000_REALK,      0.094738449287646_REALK,      0.000000000000000_REALK, &
     -0.095206326563284_REALK,      0.000000000000000_REALK,     -0.027704655017381_REALK, &
      0.000000000000000_REALK,     -0.130364449279953_REALK,      0.000000000000000_REALK, &
      0.063784381867173_REALK,      0.000000000000000_REALK,     -0.113533542427829_REALK, &
      0.000000000000000_REALK,     -0.024412701649989_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.111269507453561_REALK,      0.000000000000000_REALK, &
      0.078276792711618_REALK,      0.000000000000000_REALK,     -0.130341199733963_REALK, &
      0.000000000000000_REALK,     -0.083744888593854_REALK,      0.000000000000000_REALK, &
     -0.091126357530798_REALK,      0.000000000000000_REALK,     -0.035977058536840_REALK, &
      0.000000000000000_REALK,      0.023109032174519_REALK,      0.000000000000000_REALK, &
      0.000625503557418_REALK,      0.000000000000000_REALK,      0.048010605473595_REALK, &
     -0.180579356921535_REALK,      0.000000000000000_REALK,      0.054808499032387_REALK, &
      0.000000000000000_REALK,      0.215190752907194_REALK,      0.000000000000000_REALK, &
     -0.180605206403519_REALK,      0.000000000000000_REALK,     -0.006017913430534_REALK, &
      0.000000000000000_REALK,     -0.235571817667466_REALK,      0.000000000000000_REALK, &
      0.116407397586259_REALK,      0.000000000000000_REALK,     -0.251037456369875_REALK, &
      0.000000000000000_REALK,      0.138453556459135_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.331035956295201_REALK,      0.000000000000000_REALK, &
      0.100568993081538_REALK,      0.000000000000000_REALK,     -0.134110116458373_REALK, &
      0.000000000000000_REALK,      0.054863028597428_REALK,      0.000000000000000_REALK, &
     -0.061764130346343_REALK,      0.000000000000000_REALK,      0.076615503537730_REALK, &
      0.000000000000000_REALK,      0.107691969282777_REALK,      0.000000000000000_REALK, &
     -0.106740959674170_REALK,      0.000000000000000_REALK,      0.126745422612177_REALK, &
     -0.569032525378859_REALK,      0.000000000000000_REALK,      0.212147151930801_REALK, &
      0.000000000000000_REALK,      0.214092383105796_REALK,      0.000000000000000_REALK, &
     -0.250470828511711_REALK,      0.000000000000000_REALK,      0.146890239038720_REALK/
  ! results of test 7, ket-major order, 01ODGXXZ
  data REF_CONTR_INTS(14257:14652) /                                                       &
      0.000000000000000_REALK,     -0.081949301485603_REALK,      0.000000000000000_REALK, &
     -0.024041189175487_REALK,      0.000000000000000_REALK,      0.006782673544881_REALK, &
      0.000000000000000_REALK,     -0.043363813753608_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.021031051515891_REALK,      0.000000000000000_REALK, &
      0.011005615159077_REALK,      0.000000000000000_REALK,      0.002275654153480_REALK, &
      0.000000000000000_REALK,     -0.011013709824835_REALK,      0.000000000000000_REALK, &
      0.081100700172751_REALK,      0.000000000000000_REALK,     -0.033889851059859_REALK, &
      0.000000000000000_REALK,      0.030300166495856_REALK,      0.000000000000000_REALK, &
      0.059082172546389_REALK,      0.000000000000000_REALK,      0.013210497737749_REALK, &
      0.034133296274263_REALK,      0.000000000000000_REALK,     -0.024360360234976_REALK, &
      0.000000000000000_REALK,      0.019053562468558_REALK,      0.000000000000000_REALK, &
      0.050900879181434_REALK,      0.000000000000000_REALK,      0.041364008644695_REALK, &
      0.000000000000000_REALK,      0.025997915274775_REALK,      0.000000000000000_REALK, &
      0.008313317874623_REALK,      0.000000000000000_REALK,      0.000949355043049_REALK, &
      0.000000000000000_REALK,     -0.058851330656150_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.036060383824648_REALK,      0.000000000000000_REALK, &
      0.036403500325528_REALK,      0.000000000000000_REALK,      0.014054585630723_REALK, &
      0.000000000000000_REALK,     -0.038488515922186_REALK,      0.000000000000000_REALK, &
     -0.017329930136873_REALK,      0.000000000000000_REALK,     -0.003944095235739_REALK, &
      0.000000000000000_REALK,     -0.009186389579447_REALK,      0.000000000000000_REALK, &
     -0.006899782314792_REALK,      0.000000000000000_REALK,     -0.005220856896720_REALK, &
     -0.017513897926341_REALK,      0.000000000000000_REALK,     -0.040838508270448_REALK, &
      0.000000000000000_REALK,      0.014309499828716_REALK,      0.000000000000000_REALK, &
     -0.020648783242569_REALK,      0.000000000000000_REALK,     -0.001688795925244_REALK, &
      0.000000000000000_REALK,     -0.026714217353230_REALK,      0.000000000000000_REALK, &
      0.001457247609950_REALK,      0.000000000000000_REALK,      0.002903062200218_REALK, &
      0.000000000000000_REALK,      0.020053547827266_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.013760913846421_REALK,      0.000000000000000_REALK, &
     -0.008315265800356_REALK,      0.000000000000000_REALK,      0.000070502179738_REALK, &
      0.000000000000000_REALK,      0.002294349691503_REALK,      0.000000000000000_REALK, &
      0.021364651520980_REALK,      0.000000000000000_REALK,      0.019917604771756_REALK, &
      0.000000000000000_REALK,     -0.006567616204605_REALK,      0.000000000000000_REALK, &
     -0.003978813624519_REALK,      0.000000000000000_REALK,     -0.023586665387089_REALK, &
     -0.007742889133744_REALK,      0.000000000000000_REALK,      0.053896431820558_REALK, &
      0.000000000000000_REALK,     -0.046973803164552_REALK,      0.000000000000000_REALK, &
     -0.033568871801249_REALK,      0.000000000000000_REALK,     -0.055092542311330_REALK, &
      0.000000000000000_REALK,      0.000784159714249_REALK,      0.000000000000000_REALK, &
      0.016826030158692_REALK,      0.000000000000000_REALK,      0.008778925923643_REALK, &
      0.000000000000000_REALK,      0.065678968651960_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.089511222662896_REALK,      0.000000000000000_REALK, &
      0.039395411801385_REALK,      0.000000000000000_REALK,     -0.000489948474580_REALK, &
      0.000000000000000_REALK,      0.041491131336305_REALK,      0.000000000000000_REALK, &
     -0.041565846147679_REALK,      0.000000000000000_REALK,     -0.010376571302948_REALK, &
      0.000000000000000_REALK,      0.003011835162134_REALK,      0.000000000000000_REALK, &
      0.001351660435769_REALK,      0.000000000000000_REALK,      0.032743589153924_REALK, &
      0.007720538203862_REALK,      0.000000000000000_REALK,     -0.046252444759356_REALK, &
      0.000000000000000_REALK,      0.041589275222846_REALK,      0.000000000000000_REALK, &
      0.046593772856703_REALK,      0.000000000000000_REALK,      0.074025799122483_REALK, &
      0.000000000000000_REALK,     -0.044529761097042_REALK,      0.000000000000000_REALK, &
     -0.010204505717805_REALK,      0.000000000000000_REALK,     -0.010845267246270_REALK, &
      0.000000000000000_REALK,     -0.034497654543430_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.098924678713348_REALK,      0.000000000000000_REALK, &
     -0.027476247546650_REALK,      0.000000000000000_REALK,     -0.003846188457211_REALK, &
      0.000000000000000_REALK,     -0.074648615796872_REALK,      0.000000000000000_REALK, &
      0.039149530512437_REALK,      0.000000000000000_REALK,      0.053347014519110_REALK, &
      0.000000000000000_REALK,     -0.026547334740747_REALK,      0.000000000000000_REALK, &
      0.016623307151379_REALK,      0.000000000000000_REALK,     -0.077956984797676_REALK, &
      0.025563329724356_REALK,      0.000000000000000_REALK,      0.021201966121303_REALK, &
      0.000000000000000_REALK,      0.006998028484334_REALK,      0.000000000000000_REALK, &
      0.028749028876408_REALK,      0.000000000000000_REALK,     -0.079061840159746_REALK, &
      0.000000000000000_REALK,     -0.037751338977216_REALK,      0.000000000000000_REALK, &
     -0.014015915411006_REALK,      0.000000000000000_REALK,     -0.006320338092283_REALK, &
      0.000000000000000_REALK,      0.057902221800930_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.028693784022094_REALK,      0.000000000000000_REALK, &
     -0.020678771353075_REALK,      0.000000000000000_REALK,     -0.009796401447594_REALK, &
      0.000000000000000_REALK,      0.030800932436995_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.066679533179859_REALK,      0.000000000000000_REALK, &
      0.002422255849243_REALK,      0.000000000000000_REALK,     -0.073242649748330_REALK, &
      0.000000000000000_REALK,      0.197786251513221_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.033392796726219_REALK,      0.000000000000000_REALK, &
      0.095656635197420_REALK,      0.000000000000000_REALK,     -0.093654008375738_REALK, &
      0.000000000000000_REALK,      0.057232678676789_REALK,      0.000000000000000_REALK, &
     -0.000122709110550_REALK,      0.000000000000000_REALK,      0.197457546558463_REALK, &
      0.000000000000000_REALK,      0.061517836874652_REALK,      0.000000000000000_REALK, &
      0.256511466216317_REALK,      0.000000000000000_REALK,     -0.028068686066270_REALK, &
      0.097551948356590_REALK,      0.000000000000000_REALK,      0.220785600841036_REALK, &
      0.000000000000000_REALK,      0.013128171777999_REALK,      0.000000000000000_REALK, &
      0.187333404514296_REALK,      0.000000000000000_REALK,      0.080375038216374_REALK, &
      0.000000000000000_REALK,     -0.072603168464263_REALK,      0.000000000000000_REALK, &
      0.257956162892583_REALK,      0.000000000000000_REALK,     -0.055424484448113_REALK, &
      0.000000000000000_REALK,     -0.080748551687014_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.012369405673321_REALK,      0.000000000000000_REALK, &
      0.413502087083773_REALK,      0.000000000000000_REALK,     -0.109285774130078_REALK, &
      0.000000000000000_REALK,     -0.043898568933999_REALK,      0.000000000000000_REALK, &
      0.009206583529321_REALK,      0.000000000000000_REALK,     -0.166521758055533_REALK, &
      0.000000000000000_REALK,     -0.021085080877309_REALK,      0.000000000000000_REALK, &
     -0.036646081283283_REALK,      0.000000000000000_REALK,      0.009761367775544_REALK, &
     -0.050429766462260_REALK,      0.000000000000000_REALK,     -0.207495322244944_REALK, &
      0.000000000000000_REALK,     -0.137938982399517_REALK,      0.000000000000000_REALK, &
     -0.012112088513686_REALK,      0.000000000000000_REALK,     -0.020759019957405_REALK, &
      0.000000000000000_REALK,      0.023951759945727_REALK,      0.000000000000000_REALK, &
     -0.078406237568524_REALK,      0.000000000000000_REALK,     -0.034601986402555_REALK, &
      0.000000000000000_REALK,     -0.000651787045058_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.017038240383573_REALK,      0.000000000000000_REALK, &
     -0.041777062227916_REALK,      0.000000000000000_REALK,      0.044041562928154_REALK, &
      0.000000000000000_REALK,     -0.012598901718491_REALK,      0.000000000000000_REALK, &
     -0.060780330877374_REALK,      0.000000000000000_REALK,      0.162930803345079_REALK, &
      0.000000000000000_REALK,      0.044016622840287_REALK,      0.000000000000000_REALK, &
     -0.023932815056270_REALK,      0.000000000000000_REALK,     -0.008871214649935_REALK, &
     -0.151524241452054_REALK,      0.000000000000000_REALK,      0.116453095031375_REALK, &
      0.000000000000000_REALK,      0.042056965845200_REALK,      0.000000000000000_REALK, &
     -0.223411189512208_REALK,      0.000000000000000_REALK,      0.034060335506080_REALK, &
      0.000000000000000_REALK,      0.137373808513764_REALK,      0.000000000000000_REALK, &
     -0.146584370293187_REALK,      0.000000000000000_REALK,      0.066211969427520_REALK, &
      0.000000000000000_REALK,     -0.013532779677148_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.283998355717381_REALK,      0.000000000000000_REALK, &
      0.013786774085897_REALK,      0.000000000000000_REALK,      0.159586893362710_REALK, &
      0.000000000000000_REALK,     -0.278153898776693_REALK,      0.000000000000000_REALK, &
      0.094637007142161_REALK,      0.000000000000000_REALK,     -0.136639121046004_REALK, &
      0.000000000000000_REALK,     -0.035973458541170_REALK,      0.000000000000000_REALK, &
      0.026228579661207_REALK,      0.000000000000000_REALK,      0.017329928492341_REALK, &
      0.231950910249656_REALK,      0.000000000000000_REALK,     -0.155639223737718_REALK, &
      0.000000000000000_REALK,      0.025330822174221_REALK,      0.000000000000000_REALK, &
      0.324051777829965_REALK,      0.000000000000000_REALK,     -0.025377219135317_REALK, &
      0.000000000000000_REALK,     -0.137188592421156_REALK,      0.000000000000000_REALK, &
      0.020474642127901_REALK,      0.000000000000000_REALK,     -0.180085585606135_REALK, &
      0.000000000000000_REALK,     -0.023877079618749_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.318179004799665_REALK,      0.000000000000000_REALK, &
      0.103826452143083_REALK,      0.000000000000000_REALK,     -0.236027802155117_REALK, &
      0.000000000000000_REALK,      0.111615891013304_REALK,      0.000000000000000_REALK, &
     -0.094514589822110_REALK,      0.000000000000000_REALK,      0.171286296161517_REALK, &
      0.000000000000000_REALK,      0.245403028911552_REALK,      0.000000000000000_REALK, &
     -0.036574810777925_REALK,      0.000000000000000_REALK,     -0.050884019330139_REALK, &
     -0.220942474325278_REALK,      0.000000000000000_REALK,      0.279404227590597_REALK, &
      0.000000000000000_REALK,      0.349152252154053_REALK,      0.000000000000000_REALK, &
      0.072024104844208_REALK,      0.000000000000000_REALK,     -0.023175924554795_REALK, &
      0.000000000000000_REALK,      0.023527248867075_REALK,      0.000000000000000_REALK, &
     -0.157383882687298_REALK,      0.000000000000000_REALK,      0.114755983816743_REALK, &
      0.000000000000000_REALK,      0.166551932610059_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.033577412114239_REALK,      0.000000000000000_REALK, &
     -0.140623637692417_REALK,      0.000000000000000_REALK,      0.143203343348159_REALK, &
      0.000000000000000_REALK,      0.263827040662855_REALK,      0.000000000000000_REALK/
  ! results of test 7, ket-major order, 01ODGXYZ
  data REF_CONTR_INTS(14653:15048) /                                                       &
      0.000000000000000_REALK,     -0.030082555804066_REALK,      0.000000000000000_REALK, &
      0.002300028358908_REALK,      0.000000000000000_REALK,      0.004177736229317_REALK, &
      0.000000000000000_REALK,     -0.005388112076716_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.016735025035076_REALK,      0.000000000000000_REALK, &
     -0.005049209871397_REALK,      0.000000000000000_REALK,     -0.011612818246922_REALK, &
      0.000000000000000_REALK,      0.014410193143047_REALK,      0.000000000000000_REALK, &
      0.030408259240915_REALK,      0.000000000000000_REALK,     -0.003565156086626_REALK, &
      0.000000000000000_REALK,     -0.007715690739221_REALK,      0.000000000000000_REALK, &
      0.023326756033763_REALK,      0.000000000000000_REALK,      0.007721072041803_REALK, &
      0.025220393633222_REALK,      0.000000000000000_REALK,      0.001229922781861_REALK, &
      0.000000000000000_REALK,     -0.009460533162958_REALK,      0.000000000000000_REALK, &
      0.019326225020712_REALK,      0.000000000000000_REALK,     -0.027423383412566_REALK, &
      0.000000000000000_REALK,      0.005410628307603_REALK,      0.000000000000000_REALK, &
      0.005101716823748_REALK,      0.000000000000000_REALK,      0.005302751217731_REALK, &
      0.000000000000000_REALK,     -0.015135647306287_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.031649671786698_REALK,      0.000000000000000_REALK, &
     -0.008070249256397_REALK,      0.000000000000000_REALK,      0.014783388302412_REALK, &
      0.000000000000000_REALK,     -0.045304476489463_REALK,      0.000000000000000_REALK, &
     -0.000116002989275_REALK,      0.000000000000000_REALK,      0.000876099283550_REALK, &
      0.000000000000000_REALK,     -0.005254689123165_REALK,      0.000000000000000_REALK, &
      0.001585377090015_REALK,      0.000000000000000_REALK,     -0.001524415458094_REALK, &
      0.000674487260291_REALK,      0.000000000000000_REALK,     -0.020768112960621_REALK, &
      0.000000000000000_REALK,      0.017776564615255_REALK,      0.000000000000000_REALK, &
      0.006913923057944_REALK,      0.000000000000000_REALK,      0.020931836733230_REALK, &
      0.000000000000000_REALK,     -0.017758397242487_REALK,      0.000000000000000_REALK, &
      0.000509154554931_REALK,      0.000000000000000_REALK,      0.000889647603746_REALK, &
      0.000000000000000_REALK,     -0.002007466475372_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.004019857040113_REALK,      0.000000000000000_REALK, &
      0.005482905903152_REALK,      0.000000000000000_REALK,      0.003509537627381_REALK, &
      0.000000000000000_REALK,     -0.007098776544664_REALK,      0.000000000000000_REALK, &
     -0.000190886801034_REALK,      0.000000000000000_REALK,      0.002910736229735_REALK, &
      0.000000000000000_REALK,      0.002254405230187_REALK,      0.000000000000000_REALK, &
      0.003819805421226_REALK,      0.000000000000000_REALK,      0.000361385868418_REALK, &
      0.014577026463211_REALK,      0.000000000000000_REALK,      0.008966610757883_REALK, &
      0.000000000000000_REALK,     -0.000588643222037_REALK,      0.000000000000000_REALK, &
      0.018750394580875_REALK,      0.000000000000000_REALK,      0.005752215183234_REALK, &
      0.000000000000000_REALK,     -0.014632826430321_REALK,      0.000000000000000_REALK, &
     -0.005323459301691_REALK,      0.000000000000000_REALK,     -0.003033766392008_REALK, &
      0.000000000000000_REALK,      0.004122511089617_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.025999055701811_REALK,      0.000000000000000_REALK, &
     -0.012723338003714_REALK,      0.000000000000000_REALK,     -0.000634363257185_REALK, &
      0.000000000000000_REALK,      0.005680922509827_REALK,      0.000000000000000_REALK, &
     -0.007483441767503_REALK,      0.000000000000000_REALK,      0.003827430877648_REALK, &
      0.000000000000000_REALK,     -0.001990149124479_REALK,      0.000000000000000_REALK, &
     -0.004597937626341_REALK,      0.000000000000000_REALK,     -0.010218967415820_REALK, &
     -0.005677042839643_REALK,      0.000000000000000_REALK,      0.013704384936989_REALK, &
      0.000000000000000_REALK,     -0.017483124001862_REALK,      0.000000000000000_REALK, &
     -0.001105820961589_REALK,      0.000000000000000_REALK,     -0.020213208772779_REALK, &
      0.000000000000000_REALK,     -0.019487883480050_REALK,      0.000000000000000_REALK, &
      0.003347422945811_REALK,      0.000000000000000_REALK,     -0.001989594797478_REALK, &
      0.000000000000000_REALK,     -0.000013831680925_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.013264580583411_REALK,      0.000000000000000_REALK, &
      0.001381713945526_REALK,      0.000000000000000_REALK,     -0.005091494862671_REALK, &
      0.000000000000000_REALK,      0.001793830808856_REALK,      0.000000000000000_REALK, &
     -0.002057924082821_REALK,      0.000000000000000_REALK,      0.027033004369098_REALK, &
      0.000000000000000_REALK,     -0.017587510862158_REALK,      0.000000000000000_REALK, &
      0.010977981811698_REALK,      0.000000000000000_REALK,     -0.020418462666722_REALK, &
     -0.009018370015024_REALK,      0.000000000000000_REALK,      0.019652696943977_REALK, &
      0.000000000000000_REALK,     -0.010551283666903_REALK,      0.000000000000000_REALK, &
     -0.002919337644536_REALK,      0.000000000000000_REALK,     -0.022422774825657_REALK, &
      0.000000000000000_REALK,      0.006449395339925_REALK,      0.000000000000000_REALK, &
      0.002879462877843_REALK,      0.000000000000000_REALK,     -0.017352156144634_REALK, &
      0.000000000000000_REALK,      0.037396243351243_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.009519931172710_REALK,      0.000000000000000_REALK, &
     -0.004896994298401_REALK,      0.000000000000000_REALK,     -0.011461358055460_REALK, &
      0.000000000000000_REALK,      0.013591866991698_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.062497071377265_REALK,      0.000000000000000_REALK, &
      0.043294382702716_REALK,      0.000000000000000_REALK,     -0.105605976625420_REALK, &
      0.000000000000000_REALK,      0.059716723011798_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.074706884874479_REALK,      0.000000000000000_REALK, &
      0.030713543055790_REALK,      0.000000000000000_REALK,     -0.086465973490704_REALK, &
      0.000000000000000_REALK,      0.101752767487766_REALK,      0.000000000000000_REALK, &
      0.014838479244108_REALK,      0.000000000000000_REALK,      0.005521762194103_REALK, &
      0.000000000000000_REALK,     -0.052704549418981_REALK,      0.000000000000000_REALK, &
      0.106584603073691_REALK,      0.000000000000000_REALK,     -0.009523850174768_REALK, &
     -0.034277826691482_REALK,      0.000000000000000_REALK,      0.013452922630100_REALK, &
      0.000000000000000_REALK,     -0.014431806452724_REALK,      0.000000000000000_REALK, &
      0.082137177389098_REALK,      0.000000000000000_REALK,     -0.056642267516161_REALK, &
      0.000000000000000_REALK,     -0.015820031777887_REALK,      0.000000000000000_REALK, &
      0.079767406172929_REALK,      0.000000000000000_REALK,     -0.026262012841362_REALK, &
      0.000000000000000_REALK,     -0.037297488805660_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.080860137757405_REALK,      0.000000000000000_REALK, &
      0.068724559377265_REALK,      0.000000000000000_REALK,     -0.064483187996819_REALK, &
      0.000000000000000_REALK,     -0.075925615235104_REALK,      0.000000000000000_REALK, &
     -0.001689666605976_REALK,      0.000000000000000_REALK,     -0.059036436837845_REALK, &
      0.000000000000000_REALK,      0.006614261275270_REALK,      0.000000000000000_REALK, &
     -0.032568040393568_REALK,      0.000000000000000_REALK,     -0.002499670880297_REALK, &
      0.037888078393668_REALK,      0.000000000000000_REALK,     -0.069334466285932_REALK, &
      0.000000000000000_REALK,     -0.024306216668754_REALK,      0.000000000000000_REALK, &
      0.000377209817187_REALK,      0.000000000000000_REALK,      0.019794675604548_REALK, &
      0.000000000000000_REALK,      0.009468547562436_REALK,      0.000000000000000_REALK, &
      0.002711981694184_REALK,      0.000000000000000_REALK,     -0.053558532321372_REALK, &
      0.000000000000000_REALK,     -0.014258972217331_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.060559148937154_REALK,      0.000000000000000_REALK, &
      0.045440724086443_REALK,      0.000000000000000_REALK,     -0.010643262409858_REALK, &
      0.000000000000000_REALK,     -0.021409614797488_REALK,      0.000000000000000_REALK, &
      0.009814012885103_REALK,      0.000000000000000_REALK,      0.057026971477069_REALK, &
      0.000000000000000_REALK,      0.021752087628711_REALK,      0.000000000000000_REALK, &
      0.021841170707658_REALK,      0.000000000000000_REALK,      0.003919206084221_REALK, &
      0.044914701158469_REALK,      0.000000000000000_REALK,      0.043568828321206_REALK, &
      0.000000000000000_REALK,      0.075144325333556_REALK,      0.000000000000000_REALK, &
      0.063532030165750_REALK,      0.000000000000000_REALK,      0.002825229100827_REALK, &
      0.000000000000000_REALK,      0.010274758855107_REALK,      0.000000000000000_REALK, &
     -0.036582012137832_REALK,      0.000000000000000_REALK,     -0.000094922576600_REALK, &
      0.000000000000000_REALK,      0.003588786720120_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.026914365078093_REALK,      0.000000000000000_REALK, &
     -0.032204311624495_REALK,      0.000000000000000_REALK,      0.049090241142007_REALK, &
      0.000000000000000_REALK,      0.055629802441449_REALK,      0.000000000000000_REALK, &
      0.000230901389672_REALK,      0.000000000000000_REALK,     -0.000048300093472_REALK, &
      0.000000000000000_REALK,      0.011686857205546_REALK,      0.000000000000000_REALK, &
     -0.001774386568915_REALK,      0.000000000000000_REALK,      0.000658908070269_REALK, &
     -0.034841691825062_REALK,      0.000000000000000_REALK,      0.024254418860263_REALK, &
      0.000000000000000_REALK,     -0.036116874080828_REALK,      0.000000000000000_REALK, &
      0.035450512457554_REALK,      0.000000000000000_REALK,      0.012053688149666_REALK, &
      0.000000000000000_REALK,     -0.014884081080405_REALK,      0.000000000000000_REALK, &
      0.019380620925590_REALK,      0.000000000000000_REALK,     -0.113664186112994_REALK, &
      0.000000000000000_REALK,     -0.015877490766531_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.013791488711354_REALK,      0.000000000000000_REALK, &
      0.012563882897161_REALK,      0.000000000000000_REALK,     -0.155241343597703_REALK, &
      0.000000000000000_REALK,     -0.024094166169665_REALK,      0.000000000000000_REALK, &
      0.011073296714840_REALK,      0.000000000000000_REALK,      0.069598701667277_REALK, &
      0.000000000000000_REALK,      0.150857166535721_REALK,      0.000000000000000_REALK, &
     -0.065486113514576_REALK,      0.000000000000000_REALK,     -0.016288784365325_REALK, &
      0.051696895486072_REALK,      0.000000000000000_REALK,      0.061196698603960_REALK, &
      0.000000000000000_REALK,      0.169241034686705_REALK,      0.000000000000000_REALK, &
     -0.122039390168952_REALK,      0.000000000000000_REALK,     -0.053929204757473_REALK, &
      0.000000000000000_REALK,     -0.005895300331846_REALK,      0.000000000000000_REALK, &
     -0.032385799218553_REALK,      0.000000000000000_REALK,      0.029536743936684_REALK, &
      0.000000000000000_REALK,      0.033589946698949_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.006799769961648_REALK,      0.000000000000000_REALK, &
     -0.036433239965723_REALK,      0.000000000000000_REALK,      0.058043021931962_REALK, &
      0.000000000000000_REALK,     -0.016836211384142_REALK,      0.000000000000000_REALK/
  ! results of test 7, ket-major order, 01ODGYYZ
  data REF_CONTR_INTS(15049:15444) /                                                       &
      0.000000000000000_REALK,     -0.013424938254510_REALK,      0.000000000000000_REALK, &
      0.003409787814001_REALK,      0.000000000000000_REALK,     -0.009071782192502_REALK, &
      0.000000000000000_REALK,      0.007939246619305_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.001922054677798_REALK,      0.000000000000000_REALK, &
     -0.000899207089808_REALK,      0.000000000000000_REALK,     -0.017590063721581_REALK, &
      0.000000000000000_REALK,      0.014644376222793_REALK,      0.000000000000000_REALK, &
      0.015944488918294_REALK,      0.000000000000000_REALK,      0.001832411730441_REALK, &
      0.000000000000000_REALK,     -0.014707535958120_REALK,      0.000000000000000_REALK, &
      0.021802283205050_REALK,      0.000000000000000_REALK,      0.008303834459751_REALK, &
      0.000651254847332_REALK,      0.000000000000000_REALK,      0.010097707643672_REALK, &
      0.000000000000000_REALK,     -0.014331607807307_REALK,      0.000000000000000_REALK, &
      0.019712784899619_REALK,      0.000000000000000_REALK,     -0.014528087978480_REALK, &
      0.000000000000000_REALK,     -0.001983953458892_REALK,      0.000000000000000_REALK, &
      0.004697856718412_REALK,      0.000000000000000_REALK,      0.005794743175215_REALK, &
      0.000000000000000_REALK,     -0.009071778958818_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.002889749436236_REALK,      0.000000000000000_REALK, &
      0.009975842014143_REALK,      0.000000000000000_REALK,      0.006544869866295_REALK, &
      0.000000000000000_REALK,     -0.014133791458221_REALK,      0.000000000000000_REALK, &
      0.000842452382823_REALK,      0.000000000000000_REALK,      0.000708141733324_REALK, &
      0.000000000000000_REALK,     -0.005340690854735_REALK,      0.000000000000000_REALK, &
      0.004120200359528_REALK,      0.000000000000000_REALK,     -0.001812123160603_REALK, &
     -0.010702236795754_REALK,      0.000000000000000_REALK,      0.000692180077270_REALK, &
      0.000000000000000_REALK,     -0.010954899173879_REALK,      0.000000000000000_REALK, &
     -0.000063001156477_REALK,      0.000000000000000_REALK,     -0.018497632882755_REALK, &
      0.000000000000000_REALK,     -0.013894486992542_REALK,      0.000000000000000_REALK, &
      0.000844886134901_REALK,      0.000000000000000_REALK,      0.002367486480733_REALK, &
      0.000000000000000_REALK,     -0.010142946815686_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.015091342363142_REALK,      0.000000000000000_REALK, &
     -0.001404112937382_REALK,      0.000000000000000_REALK,      0.004406341320648_REALK, &
      0.000000000000000_REALK,     -0.006919914436955_REALK,      0.000000000000000_REALK, &
     -0.000082376642860_REALK,      0.000000000000000_REALK,      0.002993084232507_REALK, &
      0.000000000000000_REALK,      0.000001530667555_REALK,      0.000000000000000_REALK, &
      0.000931810022147_REALK,      0.000000000000000_REALK,     -0.006628756761094_REALK, &
     -0.002220431820916_REALK,      0.000000000000000_REALK,      0.006975865786699_REALK, &
      0.000000000000000_REALK,     -0.008146238703804_REALK,      0.000000000000000_REALK, &
      0.000509481083723_REALK,      0.000000000000000_REALK,     -0.008530865333365_REALK, &
      0.000000000000000_REALK,     -0.005616789126327_REALK,      0.000000000000000_REALK, &
     -0.000323085018626_REALK,      0.000000000000000_REALK,     -0.002573763411904_REALK, &
      0.000000000000000_REALK,      0.001128711229919_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.012000403914672_REALK,      0.000000000000000_REALK, &
      0.002826563387773_REALK,      0.000000000000000_REALK,     -0.009567130742156_REALK, &
      0.000000000000000_REALK,      0.004481407083259_REALK,      0.000000000000000_REALK, &
     -0.005705852344911_REALK,      0.000000000000000_REALK,      0.002645621013854_REALK, &
      0.000000000000000_REALK,      0.000999899175790_REALK,      0.000000000000000_REALK, &
      0.000960108466546_REALK,      0.000000000000000_REALK,     -0.010385520789695_REALK, &
      0.004100529606414_REALK,      0.000000000000000_REALK,      0.009322797145946_REALK, &
      0.000000000000000_REALK,     -0.004894291717026_REALK,      0.000000000000000_REALK, &
      0.008977740299129_REALK,      0.000000000000000_REALK,     -0.003909904055930_REALK, &
      0.000000000000000_REALK,     -0.014855252022959_REALK,      0.000000000000000_REALK, &
     -0.000359299022129_REALK,      0.000000000000000_REALK,     -0.004613655418160_REALK, &
      0.000000000000000_REALK,     -0.005373027887401_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.001211754137978_REALK,      0.000000000000000_REALK, &
      0.001907075633362_REALK,      0.000000000000000_REALK,     -0.018325946463759_REALK, &
      0.000000000000000_REALK,      0.021568891802797_REALK,      0.000000000000000_REALK, &
     -0.003012101152884_REALK,      0.000000000000000_REALK,      0.014504509027438_REALK, &
      0.000000000000000_REALK,     -0.007462449942279_REALK,      0.000000000000000_REALK, &
      0.008693692558926_REALK,      0.000000000000000_REALK,     -0.024367770454381_REALK, &
     -0.018782269309715_REALK,      0.000000000000000_REALK,      0.004963690009391_REALK, &
      0.000000000000000_REALK,      0.011630478445014_REALK,      0.000000000000000_REALK, &
     -0.009124788946108_REALK,      0.000000000000000_REALK,     -0.004079842053644_REALK, &
      0.000000000000000_REALK,      0.005566682958071_REALK,      0.000000000000000_REALK, &
     -0.003122399180864_REALK,      0.000000000000000_REALK,     -0.021592970545141_REALK, &
      0.000000000000000_REALK,      0.028185565321786_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.007818536719570_REALK,      0.000000000000000_REALK, &
     -0.000096300440778_REALK,      0.000000000000000_REALK,      0.008209266188380_REALK, &
      0.000000000000000_REALK,     -0.005004682046249_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.105686010136528_REALK,      0.000000000000000_REALK, &
      0.061952269370624_REALK,      0.000000000000000_REALK,     -0.147029937717487_REALK, &
      0.000000000000000_REALK,      0.073462758380712_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.142628407575811_REALK,      0.000000000000000_REALK, &
      0.057164740891260_REALK,      0.000000000000000_REALK,     -0.104306270577570_REALK, &
      0.000000000000000_REALK,      0.026702109410001_REALK,      0.000000000000000_REALK, &
      0.018785014233639_REALK,      0.000000000000000_REALK,     -0.066114590137492_REALK, &
      0.000000000000000_REALK,     -0.077069174760323_REALK,      0.000000000000000_REALK, &
      0.089804137844596_REALK,      0.000000000000000_REALK,     -0.017144054652046_REALK, &
      0.139120281922014_REALK,      0.000000000000000_REALK,     -0.039725477914666_REALK, &
      0.000000000000000_REALK,      0.027263144979631_REALK,      0.000000000000000_REALK, &
     -0.012413975281713_REALK,      0.000000000000000_REALK,     -0.086918030762422_REALK, &
      0.000000000000000_REALK,     -0.009348219957377_REALK,      0.000000000000000_REALK, &
      0.040460513623142_REALK,      0.000000000000000_REALK,     -0.034010950299134_REALK, &
      0.000000000000000_REALK,     -0.042938946053742_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.042090791048767_REALK,      0.000000000000000_REALK, &
      0.057867984638338_REALK,      0.000000000000000_REALK,     -0.134652986681612_REALK, &
      0.000000000000000_REALK,     -0.093041665412298_REALK,      0.000000000000000_REALK, &
      0.007719714988230_REALK,      0.000000000000000_REALK,     -0.037444693766175_REALK, &
      0.000000000000000_REALK,      0.002599644038119_REALK,      0.000000000000000_REALK, &
     -0.037926086491231_REALK,      0.000000000000000_REALK,     -0.017143928463567_REALK, &
      0.029112407220543_REALK,      0.000000000000000_REALK,     -0.016453684420244_REALK, &
      0.000000000000000_REALK,     -0.068471913604308_REALK,      0.000000000000000_REALK, &
     -0.023261079770743_REALK,      0.000000000000000_REALK,     -0.026921474817269_REALK, &
      0.000000000000000_REALK,      0.018550333795648_REALK,      0.000000000000000_REALK, &
      0.032424895496334_REALK,      0.000000000000000_REALK,     -0.057593360721177_REALK, &
      0.000000000000000_REALK,     -0.025198696830173_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.038191940199982_REALK,      0.000000000000000_REALK, &
      0.048678444292055_REALK,      0.000000000000000_REALK,     -0.030039787603130_REALK, &
      0.000000000000000_REALK,      0.011642719928168_REALK,      0.000000000000000_REALK, &
      0.006888209040443_REALK,      0.000000000000000_REALK,      0.037559116713390_REALK, &
      0.000000000000000_REALK,      0.017177622096632_REALK,      0.000000000000000_REALK, &
      0.029107764064743_REALK,      0.000000000000000_REALK,      0.010228861427591_REALK, &
     -0.020197378419468_REALK,      0.000000000000000_REALK,      0.007336942357199_REALK, &
      0.000000000000000_REALK,      0.029672431440497_REALK,      0.000000000000000_REALK, &
      0.038909266589232_REALK,      0.000000000000000_REALK,      0.017935569867809_REALK, &
      0.000000000000000_REALK,      0.011945322115988_REALK,      0.000000000000000_REALK, &
      0.006088789207282_REALK,      0.000000000000000_REALK,     -0.015562590505152_REALK, &
      0.000000000000000_REALK,      0.004559050051328_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.012697054195112_REALK,      0.000000000000000_REALK, &
      0.030773598229865_REALK,      0.000000000000000_REALK,     -0.011327420291696_REALK, &
      0.000000000000000_REALK,      0.020712895810253_REALK,      0.000000000000000_REALK, &
      0.018077370019625_REALK,      0.000000000000000_REALK,      0.038006040574395_REALK, &
      0.000000000000000_REALK,      0.035084903552295_REALK,      0.000000000000000_REALK, &
     -0.001774386172026_REALK,      0.000000000000000_REALK,      0.007528621919276_REALK, &
      0.027901983884218_REALK,      0.000000000000000_REALK,      0.057477864991507_REALK, &
      0.000000000000000_REALK,      0.017945895124979_REALK,      0.000000000000000_REALK, &
      0.077314821911394_REALK,      0.000000000000000_REALK,      0.018970959665157_REALK, &
      0.000000000000000_REALK,      0.000843566969508_REALK,      0.000000000000000_REALK, &
      0.028571909783417_REALK,      0.000000000000000_REALK,     -0.095944384231159_REALK, &
      0.000000000000000_REALK,     -0.021694104643295_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.002503508958529_REALK,      0.000000000000000_REALK, &
      0.045040209692085_REALK,      0.000000000000000_REALK,     -0.157141441398627_REALK, &
      0.000000000000000_REALK,      0.126143126653103_REALK,      0.000000000000000_REALK, &
      0.034681809423993_REALK,      0.000000000000000_REALK,      0.058805689120559_REALK, &
      0.000000000000000_REALK,      0.143886142926057_REALK,      0.000000000000000_REALK, &
     -0.087679664883226_REALK,      0.000000000000000_REALK,     -0.030301503077524_REALK, &
      0.028517560659387_REALK,      0.000000000000000_REALK,      0.125267317615837_REALK, &
      0.000000000000000_REALK,      0.223225878374620_REALK,      0.000000000000000_REALK, &
     -0.202759044420329_REALK,      0.000000000000000_REALK,      0.044650091126372_REALK, &
      0.000000000000000_REALK,     -0.044727139079354_REALK,      0.000000000000000_REALK, &
      0.000450559316673_REALK,      0.000000000000000_REALK,      0.011861527920406_REALK, &
      0.000000000000000_REALK,      0.010826984483680_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.084125500817692_REALK,      0.000000000000000_REALK, &
     -0.039750970736004_REALK,      0.000000000000000_REALK,      0.167871940080950_REALK, &
      0.000000000000000_REALK,     -0.114998072083166_REALK,      0.000000000000000_REALK/
  ! results of test 7, ket-major order, 01ODGXZZ
  data REF_CONTR_INTS(15445:15840) /                                                       &
      0.022309030989647_REALK,      0.000000000000000_REALK,      0.005279829370610_REALK, &
      0.000000000000000_REALK,     -0.000946353044274_REALK,      0.000000000000000_REALK, &
      0.021121954485209_REALK,      0.000000000000000_REALK,     -0.015321901787989_REALK, &
      0.006204398672037_REALK,      0.000000000000000_REALK,      0.004825012945279_REALK, &
      0.000000000000000_REALK,      0.000010299623432_REALK,      0.000000000000000_REALK, &
      0.014019264849284_REALK,      0.000000000000000_REALK,     -0.010296117756972_REALK, &
      0.000000000000000_REALK,     -0.039527879348168_REALK,      0.000000000000000_REALK, &
     -0.001053588649548_REALK,      0.000000000000000_REALK,      0.010233387868617_REALK, &
      0.000000000000000_REALK,     -0.058293091394407_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.026682357718196_REALK,      0.000000000000000_REALK, &
      0.022181764511693_REALK,      0.000000000000000_REALK,      0.010734101773111_REALK, &
      0.000000000000000_REALK,     -0.029042650390742_REALK,      0.000000000000000_REALK, &
      0.012845878948811_REALK,      0.000000000000000_REALK,     -0.044730014422029_REALK, &
      0.000000000000000_REALK,      0.026399290526813_REALK,      0.000000000000000_REALK, &
      0.018500281102453_REALK,      0.000000000000000_REALK,      0.020495010802999_REALK, &
      0.022928276257839_REALK,      0.000000000000000_REALK,     -0.040062352660258_REALK, &
      0.000000000000000_REALK,      0.007574057430051_REALK,      0.000000000000000_REALK, &
      0.031561927905212_REALK,      0.000000000000000_REALK,      0.034154585841827_REALK, &
      0.000000000000000_REALK,      0.016816934539171_REALK,      0.000000000000000_REALK, &
      0.006605606187762_REALK,      0.000000000000000_REALK,      0.004170820281356_REALK, &
      0.000000000000000_REALK,     -0.001712677400143_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.054282289551255_REALK,      0.000000000000000_REALK, &
      0.018496578107108_REALK,      0.000000000000000_REALK,      0.014021378890969_REALK, &
      0.000000000000000_REALK,     -0.013033096408016_REALK,      0.000000000000000_REALK, &
      0.003097142538118_REALK,      0.000000000000000_REALK,      0.023015802588294_REALK, &
      0.000000000000000_REALK,     -0.019230390041071_REALK,      0.000000000000000_REALK, &
      0.005071746654086_REALK,      0.000000000000000_REALK,     -0.005986433201538_REALK, &
     -0.010943924056832_REALK,      0.000000000000000_REALK,     -0.011992313266703_REALK, &
      0.000000000000000_REALK,      0.006879615391573_REALK,      0.000000000000000_REALK, &
     -0.010558907279056_REALK,      0.000000000000000_REALK,      0.003622415269064_REALK, &
      0.000000000000000_REALK,     -0.020072699706908_REALK,      0.000000000000000_REALK, &
     -0.007033154740572_REALK,      0.000000000000000_REALK,     -0.003084223793831_REALK, &
      0.000000000000000_REALK,      0.011465529872491_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.011588820562177_REALK,      0.000000000000000_REALK, &
     -0.003103652973564_REALK,      0.000000000000000_REALK,     -0.008011316441395_REALK, &
      0.000000000000000_REALK,      0.039521023360751_REALK,      0.000000000000000_REALK, &
     -0.016036121220802_REALK,      0.000000000000000_REALK,      0.027777495095340_REALK, &
      0.000000000000000_REALK,     -0.024934403990992_REALK,      0.000000000000000_REALK, &
     -0.013518210338104_REALK,      0.000000000000000_REALK,     -0.003923308677699_REALK, &
     -0.016814362587643_REALK,      0.000000000000000_REALK,     -0.043806993952592_REALK, &
      0.000000000000000_REALK,      0.023562877213311_REALK,      0.000000000000000_REALK, &
     -0.011729639683828_REALK,      0.000000000000000_REALK,      0.059757480693910_REALK, &
      0.000000000000000_REALK,      0.018400084503674_REALK,      0.000000000000000_REALK, &
      0.007025818323304_REALK,      0.000000000000000_REALK,     -0.005323117812189_REALK, &
      0.000000000000000_REALK,     -0.002259285580157_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.033958478971782_REALK,      0.000000000000000_REALK, &
      0.004287421074835_REALK,      0.000000000000000_REALK,      0.006124872040223_REALK, &
      0.000000000000000_REALK,     -0.080176085058100_REALK,      0.000000000000000_REALK, &
      0.027274825357524_REALK,      0.000000000000000_REALK,      0.018647383708657_REALK, &
      0.000000000000000_REALK,     -0.009078507506152_REALK,      0.000000000000000_REALK, &
      0.032263023855785_REALK,      0.000000000000000_REALK,     -0.007670316822174_REALK, &
      0.042698373059084_REALK,      0.000000000000000_REALK,      0.018073679846956_REALK, &
      0.000000000000000_REALK,      0.000027315029014_REALK,      0.000000000000000_REALK, &
      0.063004336472774_REALK,      0.000000000000000_REALK,     -0.035733361399734_REALK, &
      0.000000000000000_REALK,     -0.051897968305558_REALK,      0.000000000000000_REALK, &
     -0.013324842995739_REALK,      0.000000000000000_REALK,     -0.009092227329066_REALK, &
      0.000000000000000_REALK,      0.018430018836697_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.038824244732585_REALK,      0.000000000000000_REALK, &
     -0.016440689060417_REALK,      0.000000000000000_REALK,     -0.023461214215406_REALK, &
      0.000000000000000_REALK,      0.033949808347442_REALK,      0.000000000000000_REALK, &
     -0.011936872593980_REALK,      0.000000000000000_REALK,      0.016491224490924_REALK, &
      0.000000000000000_REALK,     -0.004512253299907_REALK,      0.000000000000000_REALK, &
     -0.008292715911174_REALK,      0.000000000000000_REALK,     -0.024812069417780_REALK, &
     -0.012258844465268_REALK,      0.000000000000000_REALK,      0.004875774766595_REALK, &
      0.000000000000000_REALK,      0.005987672512156_REALK,      0.000000000000000_REALK, &
     -0.004802640455781_REALK,      0.000000000000000_REALK,     -0.015019012200247_REALK, &
     -0.004659518857984_REALK,      0.000000000000000_REALK,      0.110048639221941_REALK, &
      0.000000000000000_REALK,      0.077670486410000_REALK,      0.000000000000000_REALK, &
      0.023323501058537_REALK,      0.000000000000000_REALK,     -0.023252162781933_REALK, &
      0.037672946687782_REALK,      0.000000000000000_REALK,      0.120333720389778_REALK, &
      0.000000000000000_REALK,      0.083605647673944_REALK,      0.000000000000000_REALK, &
     -0.014615487583517_REALK,      0.000000000000000_REALK,     -0.017385761545853_REALK, &
      0.000000000000000_REALK,     -0.080659461614882_REALK,      0.000000000000000_REALK, &
      0.126694573725950_REALK,      0.000000000000000_REALK,     -0.166075701061641_REALK, &
      0.000000000000000_REALK,      0.023687719746543_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.036747315280005_REALK,      0.000000000000000_REALK, &
      0.193464964074313_REALK,      0.000000000000000_REALK,     -0.260685051279986_REALK, &
      0.000000000000000_REALK,      0.011159774262716_REALK,      0.000000000000000_REALK, &
      0.018410016375917_REALK,      0.000000000000000_REALK,     -0.033333613653367_REALK, &
      0.000000000000000_REALK,     -0.088111430344396_REALK,      0.000000000000000_REALK, &
      0.144281945409322_REALK,      0.000000000000000_REALK,      0.003194855062318_REALK, &
      0.041057405023538_REALK,      0.000000000000000_REALK,      0.025405767613758_REALK, &
      0.000000000000000_REALK,     -0.263896103954526_REALK,      0.000000000000000_REALK, &
      0.271890037828290_REALK,      0.000000000000000_REALK,      0.059960155484732_REALK, &
      0.000000000000000_REALK,      0.033775271446215_REALK,      0.000000000000000_REALK, &
      0.058004921968485_REALK,      0.000000000000000_REALK,      0.080383792821448_REALK, &
      0.000000000000000_REALK,     -0.031358061602117_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.055861486748592_REALK,      0.000000000000000_REALK, &
      0.254243046432353_REALK,      0.000000000000000_REALK,      0.231115887781464_REALK, &
      0.000000000000000_REALK,     -0.027110103497396_REALK,      0.000000000000000_REALK, &
     -0.003949213541683_REALK,      0.000000000000000_REALK,     -0.012841706602773_REALK, &
      0.000000000000000_REALK,      0.056585525280712_REALK,      0.000000000000000_REALK, &
     -0.006393767610261_REALK,      0.000000000000000_REALK,      0.005780797661212_REALK, &
     -0.035131131345541_REALK,      0.000000000000000_REALK,     -0.158739551613433_REALK, &
      0.000000000000000_REALK,      0.088139465066210_REALK,      0.000000000000000_REALK, &
     -0.061107358103674_REALK,      0.000000000000000_REALK,      0.000214469631300_REALK, &
      0.000000000000000_REALK,     -0.009596033285135_REALK,      0.000000000000000_REALK, &
     -0.072214872561148_REALK,      0.000000000000000_REALK,     -0.062789832181937_REALK, &
      0.000000000000000_REALK,      0.054948320376787_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.173250759918963_REALK,      0.000000000000000_REALK, &
     -0.190694654126450_REALK,      0.000000000000000_REALK,     -0.084833766862753_REALK, &
      0.000000000000000_REALK,      0.041848621200367_REALK,      0.000000000000000_REALK, &
     -0.002058276611647_REALK,      0.000000000000000_REALK,     -0.061876439459538_REALK, &
      0.000000000000000_REALK,      0.052412204882818_REALK,      0.000000000000000_REALK, &
     -0.091517513970256_REALK,      0.000000000000000_REALK,      0.027304052397153_REALK, &
      0.090544496551747_REALK,      0.000000000000000_REALK,     -0.401750192024845_REALK, &
      0.000000000000000_REALK,      0.101459843349027_REALK,      0.000000000000000_REALK, &
     -0.051723237766952_REALK,      0.000000000000000_REALK,      0.108041216189999_REALK, &
      0.000000000000000_REALK,     -0.017657169695011_REALK,      0.000000000000000_REALK, &
      0.029342521391099_REALK,      0.000000000000000_REALK,      0.014830401144545_REALK, &
      0.000000000000000_REALK,     -0.085641627984212_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.240484514861790_REALK,      0.000000000000000_REALK, &
      0.204643268564591_REALK,      0.000000000000000_REALK,     -0.080340040600535_REALK, &
      0.000000000000000_REALK,     -0.218967577208124_REALK,      0.000000000000000_REALK, &
      0.012470926582833_REALK,      0.000000000000000_REALK,      0.081753729032870_REALK, &
      0.000000000000000_REALK,      0.081896206745470_REALK,      0.000000000000000_REALK, &
      0.117175969971334_REALK,      0.000000000000000_REALK,     -0.028171210635378_REALK, &
     -0.032210736241003_REALK,      0.000000000000000_REALK,      0.234512408148712_REALK, &
      0.000000000000000_REALK,      0.202283583664092_REALK,      0.000000000000000_REALK, &
      0.277513903116522_REALK,      0.000000000000000_REALK,     -0.102022806789073_REALK, &
      0.000000000000000_REALK,     -0.041503109232735_REALK,      0.000000000000000_REALK, &
     -0.091291625294050_REALK,      0.000000000000000_REALK,     -0.048653916395285_REALK, &
      0.000000000000000_REALK,      0.126836181028356_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.061501417651041_REALK,      0.000000000000000_REALK, &
     -0.064236514459009_REALK,      0.000000000000000_REALK,     -0.026411919549357_REALK, &
      0.000000000000000_REALK,      0.304421814306357_REALK,      0.000000000000000_REALK, &
     -0.040996352383746_REALK,      0.000000000000000_REALK,      0.029576084448628_REALK, &
      0.000000000000000_REALK,      0.082081352425503_REALK,      0.000000000000000_REALK, &
     -0.085211399096316_REALK,      0.000000000000000_REALK,     -0.001784034849533_REALK, &
     -0.067561395275025_REALK,      0.000000000000000_REALK,      0.060153101638280_REALK, &
      0.000000000000000_REALK,      0.086242991729462_REALK,      0.000000000000000_REALK, &
     -0.056031748311495_REALK,      0.000000000000000_REALK,      0.023256788298043_REALK/
  ! results of test 7, ket-major order, 01ODGYZZ
  data REF_CONTR_INTS(15841:16236) /                                                       &
      0.004850744157250_REALK,      0.000000000000000_REALK,      0.006503526100734_REALK, &
      0.000000000000000_REALK,     -0.005796659580187_REALK,      0.000000000000000_REALK, &
      0.010034383831104_REALK,      0.000000000000000_REALK,     -0.011481674964160_REALK, &
     -0.005262355800757_REALK,      0.000000000000000_REALK,      0.002623795880579_REALK, &
      0.000000000000000_REALK,      0.003171995061637_REALK,      0.000000000000000_REALK, &
     -0.000756777617673_REALK,      0.000000000000000_REALK,     -0.012267029262536_REALK, &
      0.000000000000000_REALK,     -0.022308037271985_REALK,      0.000000000000000_REALK, &
      0.004687974346499_REALK,      0.000000000000000_REALK,      0.009756187902490_REALK, &
      0.000000000000000_REALK,     -0.022701874867227_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.019481623850802_REALK,      0.000000000000000_REALK, &
     -0.001849477158815_REALK,      0.000000000000000_REALK,     -0.018132548818229_REALK, &
      0.000000000000000_REALK,      0.015577782625239_REALK,      0.000000000000000_REALK, &
      0.007448414563002_REALK,      0.000000000000000_REALK,     -0.010763531594299_REALK, &
      0.000000000000000_REALK,      0.000183440894704_REALK,      0.000000000000000_REALK, &
      0.008210175489452_REALK,      0.000000000000000_REALK,      0.006662860793164_REALK, &
      0.024818782605770_REALK,      0.000000000000000_REALK,      0.000279542244128_REALK, &
      0.000000000000000_REALK,     -0.013696658217740_REALK,      0.000000000000000_REALK, &
      0.032286635547258_REALK,      0.000000000000000_REALK,     -0.011858930801987_REALK, &
      0.000000000000000_REALK,      0.004235013076735_REALK,      0.000000000000000_REALK, &
      0.001645299090799_REALK,      0.000000000000000_REALK,      0.001941305901580_REALK, &
      0.000000000000000_REALK,     -0.000999774691028_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.008150775110918_REALK,      0.000000000000000_REALK, &
      0.000147696308817_REALK,      0.000000000000000_REALK,      0.008409518000077_REALK, &
      0.000000000000000_REALK,     -0.024437851190662_REALK,      0.000000000000000_REALK, &
      0.006108324057257_REALK,      0.000000000000000_REALK,      0.011111868331373_REALK, &
      0.000000000000000_REALK,     -0.012044844513452_REALK,      0.000000000000000_REALK, &
      0.010906329229173_REALK,      0.000000000000000_REALK,      0.000769700421583_REALK, &
      0.002595086581287_REALK,      0.000000000000000_REALK,     -0.011241208979641_REALK, &
      0.000000000000000_REALK,      0.004243703079721_REALK,      0.000000000000000_REALK, &
      0.009000922724198_REALK,      0.000000000000000_REALK,      0.016707880660198_REALK, &
      0.000000000000000_REALK,     -0.006872279793758_REALK,      0.000000000000000_REALK, &
     -0.001522475233087_REALK,      0.000000000000000_REALK,     -0.004059193451249_REALK, &
      0.000000000000000_REALK,      0.001180285497447_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.031330822548187_REALK,      0.000000000000000_REALK, &
     -0.004180502156322_REALK,      0.000000000000000_REALK,     -0.003389720585087_REALK, &
      0.000000000000000_REALK,     -0.002024956331206_REALK,      0.000000000000000_REALK, &
      0.001678584324461_REALK,      0.000000000000000_REALK,      0.010858949534814_REALK, &
      0.000000000000000_REALK,     -0.007075428000198_REALK,      0.000000000000000_REALK, &
      0.002883060091046_REALK,      0.000000000000000_REALK,     -0.004190971453336_REALK, &
     -0.012176694486445_REALK,      0.000000000000000_REALK,      0.010439593395023_REALK, &
      0.000000000000000_REALK,     -0.005489686321213_REALK,      0.000000000000000_REALK, &
     -0.005586131077901_REALK,      0.000000000000000_REALK,     -0.018234410983589_REALK, &
      0.000000000000000_REALK,     -0.000777845613840_REALK,      0.000000000000000_REALK, &
     -0.000077701703863_REALK,      0.000000000000000_REALK,     -0.005555412852146_REALK, &
      0.000000000000000_REALK,      0.008116686941697_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.013838123469445_REALK,      0.000000000000000_REALK, &
     -0.000052651141259_REALK,      0.000000000000000_REALK,     -0.005879553079115_REALK, &
      0.000000000000000_REALK,      0.004641253972852_REALK,      0.000000000000000_REALK, &
      0.006026519080461_REALK,      0.000000000000000_REALK,      0.017409741668053_REALK, &
      0.000000000000000_REALK,     -0.015475284626871_REALK,      0.000000000000000_REALK, &
      0.015205211670499_REALK,      0.000000000000000_REALK,     -0.003618755784438_REALK, &
     -0.011016339734395_REALK,      0.000000000000000_REALK,      0.020341137706777_REALK, &
      0.000000000000000_REALK,     -0.008453054551433_REALK,      0.000000000000000_REALK, &
      0.002000982821567_REALK,      0.000000000000000_REALK,     -0.011306733636453_REALK, &
      0.000000000000000_REALK,     -0.008002880122725_REALK,      0.000000000000000_REALK, &
     -0.001108490162224_REALK,      0.000000000000000_REALK,     -0.016224005322168_REALK, &
      0.000000000000000_REALK,      0.022929874649319_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.014017426758844_REALK,      0.000000000000000_REALK, &
     -0.009861740546099_REALK,      0.000000000000000_REALK,     -0.022268513989353_REALK, &
      0.000000000000000_REALK,      0.023836926319848_REALK,      0.000000000000000_REALK, &
     -0.010767896540338_REALK,      0.000000000000000_REALK,      0.005929475457751_REALK, &
      0.000000000000000_REALK,      0.002544070464776_REALK,      0.000000000000000_REALK, &
     -0.007606782631497_REALK,      0.000000000000000_REALK,     -0.007250022492180_REALK, &
     -0.003746033606131_REALK,      0.000000000000000_REALK,     -0.000193819928891_REALK, &
      0.000000000000000_REALK,      0.004573396975542_REALK,      0.000000000000000_REALK, &
     -0.010716620431337_REALK,      0.000000000000000_REALK,      0.008389844217419_REALK, &
      0.019354044786669_REALK,      0.000000000000000_REALK,      0.038337438302164_REALK, &
      0.000000000000000_REALK,      0.052110143849683_REALK,      0.000000000000000_REALK, &
     -0.016678180795517_REALK,      0.000000000000000_REALK,     -0.020478442430498_REALK, &
     -0.000100181618350_REALK,      0.000000000000000_REALK,      0.066577667983395_REALK, &
      0.000000000000000_REALK,      0.099974123124233_REALK,      0.000000000000000_REALK, &
     -0.081487216325422_REALK,      0.000000000000000_REALK,      0.001509975167304_REALK, &
      0.000000000000000_REALK,     -0.019782523633030_REALK,      0.000000000000000_REALK, &
      0.059530868626969_REALK,      0.000000000000000_REALK,     -0.133292839593697_REALK, &
      0.000000000000000_REALK,     -0.005097278250361_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.091551025203758_REALK,      0.000000000000000_REALK, &
      0.075154962656104_REALK,      0.000000000000000_REALK,     -0.258293513561621_REALK, &
      0.000000000000000_REALK,      0.174671908146574_REALK,      0.000000000000000_REALK, &
      0.008264204758283_REALK,      0.000000000000000_REALK,     -0.017082981369911_REALK, &
      0.000000000000000_REALK,     -0.083157226860546_REALK,      0.000000000000000_REALK, &
      0.077198974487378_REALK,      0.000000000000000_REALK,      0.011465394107339_REALK, &
      0.004575589580463_REALK,      0.000000000000000_REALK,     -0.001670893019246_REALK, &
      0.000000000000000_REALK,     -0.175347965292445_REALK,      0.000000000000000_REALK, &
      0.260689218495629_REALK,      0.000000000000000_REALK,     -0.026817316843279_REALK, &
      0.000000000000000_REALK,      0.014251610099299_REALK,      0.000000000000000_REALK, &
      0.033559959166286_REALK,      0.000000000000000_REALK,      0.035964179472109_REALK, &
      0.000000000000000_REALK,      0.015885291287807_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.078277360768815_REALK,      0.000000000000000_REALK, &
      0.082281440920772_REALK,      0.000000000000000_REALK,      0.095351544047473_REALK, &
      0.000000000000000_REALK,     -0.053701879032535_REALK,      0.000000000000000_REALK, &
     -0.004526443230080_REALK,      0.000000000000000_REALK,     -0.022176635869309_REALK, &
      0.000000000000000_REALK,      0.029616070717895_REALK,      0.000000000000000_REALK, &
      0.027078425085755_REALK,      0.000000000000000_REALK,      0.005025025502232_REALK, &
     -0.002774146740636_REALK,      0.000000000000000_REALK,     -0.132151329865625_REALK, &
      0.000000000000000_REALK,      0.050014556359021_REALK,      0.000000000000000_REALK, &
     -0.007816726898932_REALK,      0.000000000000000_REALK,      0.020112266848576_REALK, &
      0.000000000000000_REALK,     -0.019576213978898_REALK,      0.000000000000000_REALK, &
     -0.026092472715300_REALK,      0.000000000000000_REALK,     -0.044594450795203_REALK, &
      0.000000000000000_REALK,     -0.010710240363133_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.041572035383669_REALK,      0.000000000000000_REALK, &
     -0.037270930432785_REALK,      0.000000000000000_REALK,     -0.103758769729226_REALK, &
      0.000000000000000_REALK,     -0.016564133716056_REALK,      0.000000000000000_REALK, &
     -0.004659231012001_REALK,      0.000000000000000_REALK,     -0.015421490267950_REALK, &
      0.000000000000000_REALK,      0.051587545627871_REALK,      0.000000000000000_REALK, &
     -0.017995301925873_REALK,      0.000000000000000_REALK,     -0.003207114805398_REALK, &
     -0.033357654783344_REALK,      0.000000000000000_REALK,     -0.012892420623317_REALK, &
      0.000000000000000_REALK,      0.052472541178730_REALK,      0.000000000000000_REALK, &
     -0.072497473359287_REALK,      0.000000000000000_REALK,     -0.033305741290703_REALK, &
      0.000000000000000_REALK,     -0.021962420537662_REALK,      0.000000000000000_REALK, &
     -0.000908159894639_REALK,      0.000000000000000_REALK,      0.001607096439135_REALK, &
      0.000000000000000_REALK,     -0.008042625938132_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.027543296852911_REALK,      0.000000000000000_REALK, &
     -0.005930344775149_REALK,      0.000000000000000_REALK,     -0.128212316826642_REALK, &
      0.000000000000000_REALK,     -0.046588656223897_REALK,      0.000000000000000_REALK, &
      0.000756553005463_REALK,      0.000000000000000_REALK,      0.022320994504197_REALK, &
      0.000000000000000_REALK,      0.036288253932491_REALK,      0.000000000000000_REALK, &
      0.053427028110363_REALK,      0.000000000000000_REALK,     -0.002094737423249_REALK, &
      0.007259781089944_REALK,      0.000000000000000_REALK,      0.014155132907178_REALK, &
      0.000000000000000_REALK,      0.183704713750833_REALK,      0.000000000000000_REALK, &
     -0.077312510754004_REALK,      0.000000000000000_REALK,     -0.054417856964305_REALK, &
      0.000000000000000_REALK,     -0.030097329969079_REALK,      0.000000000000000_REALK, &
     -0.012518253007661_REALK,      0.000000000000000_REALK,     -0.059996342877859_REALK, &
      0.000000000000000_REALK,      0.074427741800137_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.056615997427492_REALK,      0.000000000000000_REALK, &
     -0.028938037866216_REALK,      0.000000000000000_REALK,      0.035691193090341_REALK, &
      0.000000000000000_REALK,      0.071866434068597_REALK,      0.000000000000000_REALK, &
     -0.008209695081730_REALK,      0.000000000000000_REALK,      0.038983565496791_REALK, &
      0.000000000000000_REALK,      0.076681114023943_REALK,      0.000000000000000_REALK, &
     -0.071391753180163_REALK,      0.000000000000000_REALK,      0.002372335615829_REALK, &
     -0.044774767244200_REALK,      0.000000000000000_REALK,      0.020879031815873_REALK, &
      0.000000000000000_REALK,      0.033070551801793_REALK,      0.000000000000000_REALK, &
     -0.036547955361120_REALK,      0.000000000000000_REALK,      0.028451476478168_REALK/
  ! results of test 7, ket-major order, 01ODGZZZ
  data REF_CONTR_INTS(16237:16632) /                                                       &
      0.000000000000000_REALK,     -0.018190067255259_REALK,      0.000000000000000_REALK, &
     -0.000146024384496_REALK,      0.000000000000000_REALK,     -0.004044640959435_REALK, &
      0.000000000000000_REALK,     -0.000911975429668_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.005392136063362_REALK,      0.000000000000000_REALK, &
      0.001420092224529_REALK,      0.000000000000000_REALK,     -0.007167549348848_REALK, &
      0.000000000000000_REALK,      0.008638848220543_REALK,      0.000000000000000_REALK, &
      0.025380383066877_REALK,      0.000000000000000_REALK,     -0.004586714157620_REALK, &
      0.000000000000000_REALK,     -0.002984607057636_REALK,      0.000000000000000_REALK, &
      0.032739762338332_REALK,      0.000000000000000_REALK,     -0.000145649070021_REALK, &
      0.010547737004826_REALK,      0.000000000000000_REALK,      0.008904435878262_REALK, &
      0.000000000000000_REALK,     -0.007777080113339_REALK,      0.000000000000000_REALK, &
      0.029221624591923_REALK,      0.000000000000000_REALK,     -0.017913541960219_REALK, &
      0.000000000000000_REALK,     -0.000499892519772_REALK,      0.000000000000000_REALK, &
      0.007916055029197_REALK,      0.000000000000000_REALK,      0.013214137424498_REALK, &
      0.000000000000000_REALK,     -0.041608479318919_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.038696395854679_REALK,      0.000000000000000_REALK, &
      0.034927398855438_REALK,      0.000000000000000_REALK,      0.028471539558587_REALK, &
      0.000000000000000_REALK,     -0.048804357148562_REALK,      0.000000000000000_REALK, &
     -0.005489430677444_REALK,      0.000000000000000_REALK,     -0.023931745736642_REALK, &
      0.000000000000000_REALK,      0.013774329892266_REALK,      0.000000000000000_REALK, &
     -0.004503460610789_REALK,      0.000000000000000_REALK,      0.010368224404953_REALK, &
      0.019941594972367_REALK,      0.000000000000000_REALK,     -0.055971693116862_REALK, &
      0.000000000000000_REALK,      0.010131279974577_REALK,      0.000000000000000_REALK, &
      0.008890998321343_REALK,      0.000000000000000_REALK,      0.025419227494303_REALK, &
      0.000000000000000_REALK,     -0.008733829823308_REALK,      0.000000000000000_REALK, &
     -0.001334366909223_REALK,      0.000000000000000_REALK,     -0.000562878508978_REALK, &
      0.000000000000000_REALK,     -0.000644130940302_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.058907190118582_REALK,      0.000000000000000_REALK, &
      0.003764403805485_REALK,      0.000000000000000_REALK,      0.005246303955374_REALK, &
      0.000000000000000_REALK,     -0.009755306069789_REALK,      0.000000000000000_REALK, &
      0.001727935963386_REALK,      0.000000000000000_REALK,      0.022729622298258_REALK, &
      0.000000000000000_REALK,     -0.015050947642196_REALK,      0.000000000000000_REALK, &
      0.002303796020218_REALK,      0.000000000000000_REALK,     -0.010000407962494_REALK, &
     -0.016766409452435_REALK,      0.000000000000000_REALK,     -0.006960526502984_REALK, &
      0.000000000000000_REALK,      0.003528694064453_REALK,      0.000000000000000_REALK, &
     -0.010820141772303_REALK,      0.000000000000000_REALK,      0.036730043583134_REALK, &
      0.000000000000000_REALK,      0.007915967531483_REALK,      0.000000000000000_REALK, &
     -0.000562878508978_REALK,      0.000000000000000_REALK,     -0.005214205918718_REALK, &
      0.000000000000000_REALK,      0.013598897500213_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.020278301725543_REALK,      0.000000000000000_REALK, &
      0.005246303955374_REALK,      0.000000000000000_REALK,      0.005288926754627_REALK, &
      0.000000000000000_REALK,     -0.068851714124205_REALK,      0.000000000000000_REALK, &
      0.006136892233401_REALK,      0.000000000000000_REALK,     -0.004503460610789_REALK, &
      0.000000000000000_REALK,      0.001996879984545_REALK,      0.000000000000000_REALK, &
      0.007848111154992_REALK,      0.000000000000000_REALK,      0.005807484812412_REALK, &
      0.055523910500570_REALK,      0.000000000000000_REALK,      0.008890998321343_REALK, &
      0.000000000000000_REALK,     -0.011616337072043_REALK,      0.000000000000000_REALK, &
      0.078418307776713_REALK,      0.000000000000000_REALK,     -0.020446844477506_REALK, &
      0.000000000000000_REALK,     -0.041608479318919_REALK,      0.000000000000000_REALK, &
     -0.003791679836228_REALK,      0.000000000000000_REALK,     -0.004166577796751_REALK, &
      0.000000000000000_REALK,     -0.012352715795788_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.048804357148562_REALK,      0.000000000000000_REALK, &
     -0.008216402740026_REALK,      0.000000000000000_REALK,     -0.038485528022746_REALK, &
      0.000000000000000_REALK,      0.033859854919883_REALK,      0.000000000000000_REALK, &
     -0.000145649070021_REALK,      0.000000000000000_REALK,      0.026660671743728_REALK, &
      0.000000000000000_REALK,     -0.008533386305041_REALK,      0.000000000000000_REALK, &
      0.006978122700255_REALK,      0.000000000000000_REALK,     -0.024349507246139_REALK, &
     -0.017913541960219_REALK,      0.000000000000000_REALK,      0.012043012920569_REALK, &
      0.000000000000000_REALK,      0.015754411042182_REALK,      0.000000000000000_REALK, &
     -0.008258394834765_REALK,      0.000000000000000_REALK,     -0.026343024074444_REALK, &
      0.000000000000000_REALK,      0.001127234567549_REALK,      0.000000000000000_REALK, &
     -0.005637984998496_REALK,      0.000000000000000_REALK,     -0.008146781517763_REALK, &
      0.000000000000000_REALK,      0.018558582475731_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.002335143543746_REALK,      0.000000000000000_REALK, &
     -0.003533674906048_REALK,      0.000000000000000_REALK,      0.002771362983749_REALK, &
      0.000000000000000_REALK,      0.005907664644988_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.038384209534657_REALK,      0.000000000000000_REALK, &
      0.014794409799736_REALK,      0.000000000000000_REALK,     -0.077150487380154_REALK, &
      0.000000000000000_REALK,      0.058050615093248_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.044858959280769_REALK,      0.000000000000000_REALK, &
      0.013451936356328_REALK,      0.000000000000000_REALK,     -0.061335467718862_REALK, &
      0.000000000000000_REALK,      0.063579549282192_REALK,      0.000000000000000_REALK, &
      0.012326486357215_REALK,      0.000000000000000_REALK,      0.062420820121673_REALK, &
      0.000000000000000_REALK,     -0.026044715142483_REALK,      0.000000000000000_REALK, &
      0.136399670642426_REALK,      0.000000000000000_REALK,     -0.019285045872680_REALK, &
      0.059022427097198_REALK,      0.000000000000000_REALK,      0.148991897522026_REALK, &
      0.000000000000000_REALK,      0.043407083368095_REALK,      0.000000000000000_REALK, &
      0.071397798331768_REALK,      0.000000000000000_REALK,     -0.072886453998720_REALK, &
      0.000000000000000_REALK,     -0.042230442190166_REALK,      0.000000000000000_REALK, &
      0.117106030934821_REALK,      0.000000000000000_REALK,     -0.005887160958941_REALK, &
      0.000000000000000_REALK,     -0.060685238587320_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.109960890975209_REALK,      0.000000000000000_REALK, &
      0.242078514882833_REALK,      0.000000000000000_REALK,     -0.261408260862800_REALK, &
      0.000000000000000_REALK,     -0.138960585832109_REALK,      0.000000000000000_REALK, &
      0.001148287573657_REALK,      0.000000000000000_REALK,     -0.096276071724248_REALK, &
      0.000000000000000_REALK,      0.012636742540573_REALK,      0.000000000000000_REALK, &
     -0.021801850602854_REALK,      0.000000000000000_REALK,      0.006565590072005_REALK, &
      0.064593319175967_REALK,      0.000000000000000_REALK,     -0.117294622729546_REALK, &
      0.000000000000000_REALK,     -0.306695663360770_REALK,      0.000000000000000_REALK, &
      0.155690154248954_REALK,      0.000000000000000_REALK,      0.055513508262124_REALK, &
      0.000000000000000_REALK,      0.025598346121776_REALK,      0.000000000000000_REALK, &
     -0.019868896161985_REALK,      0.000000000000000_REALK,     -0.040569400578696_REALK, &
      0.000000000000000_REALK,     -0.011702571644019_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.175468774789195_REALK,      0.000000000000000_REALK, &
      0.149758290909173_REALK,      0.000000000000000_REALK,      0.205692989859970_REALK, &
      0.000000000000000_REALK,     -0.000017898715517_REALK,      0.000000000000000_REALK, &
     -0.007650246641731_REALK,      0.000000000000000_REALK,      0.071744890587620_REALK, &
      0.000000000000000_REALK,      0.003437146446822_REALK,      0.000000000000000_REALK, &
     -0.001635089859883_REALK,      0.000000000000000_REALK,      0.001294903716306_REALK, &
     -0.022285998758088_REALK,      0.000000000000000_REALK,     -0.203471348712673_REALK, &
      0.000000000000000_REALK,      0.197841534790513_REALK,      0.000000000000000_REALK, &
     -0.108264802844534_REALK,      0.000000000000000_REALK,      0.121806102519980_REALK, &
      0.000000000000000_REALK,      0.052476215878555_REALK,      0.000000000000000_REALK, &
     -0.040569400578696_REALK,      0.000000000000000_REALK,      0.005250052756870_REALK, &
      0.000000000000000_REALK,     -0.019820726766475_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.037443445198647_REALK,      0.000000000000000_REALK, &
      0.205692989859970_REALK,      0.000000000000000_REALK,      0.218183367134515_REALK, &
      0.000000000000000_REALK,     -0.275343749551867_REALK,      0.000000000000000_REALK, &
      0.026353697778171_REALK,      0.000000000000000_REALK,     -0.021801850602854_REALK, &
      0.000000000000000_REALK,      0.001220426862036_REALK,      0.000000000000000_REALK, &
      0.049962936496871_REALK,      0.000000000000000_REALK,      0.003196243605461_REALK, &
      0.089784713900035_REALK,      0.000000000000000_REALK,      0.155690154248953_REALK, &
      0.000000000000000_REALK,     -0.072593806655058_REALK,      0.000000000000000_REALK, &
      0.500714814027657_REALK,      0.000000000000000_REALK,     -0.089917508564104_REALK, &
      0.000000000000000_REALK,     -0.060685238587320_REALK,      0.000000000000000_REALK, &
     -0.014148766652173_REALK,      0.000000000000000_REALK,     -0.137305573931333_REALK, &
      0.000000000000000_REALK,      0.012930582254417_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.138960585832109_REALK,      0.000000000000000_REALK, &
      0.016243564451483_REALK,      0.000000000000000_REALK,     -0.352655697929744_REALK, &
      0.000000000000000_REALK,      0.344114015395160_REALK,      0.000000000000000_REALK, &
     -0.019285045872680_REALK,      0.000000000000000_REALK,      0.075096532576596_REALK, &
      0.000000000000000_REALK,      0.144040238376580_REALK,      0.000000000000000_REALK, &
     -0.071532178743584_REALK,      0.000000000000000_REALK,     -0.030489748439134_REALK, &
     -0.072886453998720_REALK,      0.000000000000000_REALK,      0.170125027826955_REALK, &
      0.000000000000000_REALK,      0.276375058169318_REALK,      0.000000000000000_REALK, &
     -0.221611087784950_REALK,      0.000000000000000_REALK,     -0.026376400431262_REALK, &
      0.000000000000000_REALK,      0.015277986949078_REALK,      0.000000000000000_REALK, &
     -0.048101836902694_REALK,      0.000000000000000_REALK,      0.056410481711685_REALK, &
      0.000000000000000_REALK,      0.043017065397752_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.051296326451680_REALK,      0.000000000000000_REALK, &
     -0.049118062162041_REALK,      0.000000000000000_REALK,      0.129366245201519_REALK, &
      0.000000000000000_REALK,      0.022439314683485_REALK,      0.000000000000000_REALK/
  ! results of test 7, ket-major order, 02ODGXXX
  data REF_CONTR_INTS(16633:17028) /                                                       &
     -0.086317072935991_REALK,      0.000000000000000_REALK,     -0.015554342288843_REALK, &
      0.000000000000000_REALK,      0.051277032389818_REALK,      0.000000000000000_REALK, &
      0.087358070204478_REALK,      0.000000000000000_REALK,      0.284579407612444_REALK, &
     -0.165162267212297_REALK,      0.000000000000000_REALK,     -0.052882401648688_REALK, &
      0.000000000000000_REALK,      0.044176189040388_REALK,      0.000000000000000_REALK, &
      0.061886526476182_REALK,      0.000000000000000_REALK,      0.094346063376405_REALK, &
      0.000000000000000_REALK,      0.156212269861700_REALK,      0.000000000000000_REALK, &
      0.027278301154328_REALK,      0.000000000000000_REALK,     -0.022286268156527_REALK, &
      0.000000000000000_REALK,     -0.049176105286794_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.115872911168920_REALK,      0.000000000000000_REALK, &
      0.113917521872445_REALK,      0.000000000000000_REALK,      0.037949969350281_REALK, &
      0.000000000000000_REALK,      0.101395307900842_REALK,      0.000000000000000_REALK, &
      0.063987724853366_REALK,      0.000000000000000_REALK,     -0.043015189594399_REALK, &
      0.000000000000000_REALK,      0.009749241627997_REALK,      0.000000000000000_REALK, &
     -0.070800951123807_REALK,      0.000000000000000_REALK,     -0.025324213332563_REALK, &
      0.028987836706141_REALK,      0.000000000000000_REALK,      0.023262053032989_REALK, &
      0.000000000000000_REALK,     -0.046514961016900_REALK,      0.000000000000000_REALK, &
     -0.081734615020014_REALK,      0.000000000000000_REALK,     -0.023091195975684_REALK, &
      0.000000000000000_REALK,     -0.057426315568545_REALK,      0.000000000000000_REALK, &
     -0.030793301644978_REALK,      0.000000000000000_REALK,      0.024194176793203_REALK, &
      0.000000000000000_REALK,     -0.055022645786664_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.024783380394619_REALK,      0.000000000000000_REALK, &
     -0.059138998710225_REALK,      0.000000000000000_REALK,     -0.010124782482061_REALK, &
      0.000000000000000_REALK,     -0.054926484059621_REALK,      0.000000000000000_REALK, &
     -0.010406154714914_REALK,      0.000000000000000_REALK,      0.007291863282574_REALK, &
      0.000000000000000_REALK,     -0.008215532121347_REALK,      0.000000000000000_REALK, &
      0.041992709866728_REALK,      0.000000000000000_REALK,     -0.007482759143807_REALK, &
     -0.002412042475340_REALK,      0.000000000000000_REALK,     -0.016331429703474_REALK, &
      0.000000000000000_REALK,      0.017798239733255_REALK,      0.000000000000000_REALK, &
      0.033336933964788_REALK,      0.000000000000000_REALK,      0.007698563636894_REALK, &
      0.000000000000000_REALK,      0.004917461561441_REALK,      0.000000000000000_REALK, &
     -0.044640882994505_REALK,      0.000000000000000_REALK,     -0.044777657792003_REALK, &
      0.000000000000000_REALK,     -0.018873911762794_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.005743787030419_REALK,      0.000000000000000_REALK, &
     -0.003874892068663_REALK,      0.000000000000000_REALK,     -0.013347658065239_REALK, &
      0.000000000000000_REALK,      0.002876664552443_REALK,      0.000000000000000_REALK, &
      0.015090327997846_REALK,      0.000000000000000_REALK,      0.091948146542353_REALK, &
      0.000000000000000_REALK,     -0.082684476295847_REALK,      0.000000000000000_REALK, &
     -0.012373136134091_REALK,      0.000000000000000_REALK,     -0.017115856460913_REALK, &
      0.008900627857298_REALK,      0.000000000000000_REALK,      0.032525728109046_REALK, &
      0.000000000000000_REALK,     -0.020815139661148_REALK,      0.000000000000000_REALK, &
      0.008380097461219_REALK,      0.000000000000000_REALK,     -0.000576375581269_REALK, &
      0.000000000000000_REALK,     -0.010508009735000_REALK,      0.000000000000000_REALK, &
      0.088273800543792_REALK,      0.000000000000000_REALK,      0.051195613359195_REALK, &
      0.000000000000000_REALK,      0.098939872571844_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.015061053400743_REALK,      0.000000000000000_REALK, &
      0.007710953450793_REALK,      0.000000000000000_REALK,      0.016727518273608_REALK, &
      0.000000000000000_REALK,      0.014944107143070_REALK,      0.000000000000000_REALK, &
     -0.051082737712943_REALK,      0.000000000000000_REALK,     -0.095286739148699_REALK, &
      0.000000000000000_REALK,      0.067934540941794_REALK,      0.000000000000000_REALK, &
      0.082813483912124_REALK,      0.000000000000000_REALK,     -0.032843677221861_REALK, &
      0.004245089903182_REALK,      0.000000000000000_REALK,     -0.058972228060821_REALK, &
      0.000000000000000_REALK,      0.019885822525838_REALK,      0.000000000000000_REALK, &
      0.007703805335982_REALK,      0.000000000000000_REALK,     -0.017528398308296_REALK, &
      0.000000000000000_REALK,     -0.077997091291472_REALK,      0.000000000000000_REALK, &
     -0.128519850414652_REALK,      0.000000000000000_REALK,     -0.046878510236082_REALK, &
      0.000000000000000_REALK,     -0.224281636750539_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.047880112988635_REALK,      0.000000000000000_REALK, &
      0.003439064510463_REALK,      0.000000000000000_REALK,     -0.023700349063392_REALK, &
      0.000000000000000_REALK,     -0.089892208594622_REALK,      0.000000000000000_REALK, &
      0.333813705609507_REALK,      0.000000000000000_REALK,      0.089252679400106_REALK, &
      0.000000000000000_REALK,     -0.060488650420886_REALK,      0.000000000000000_REALK, &
     -0.059755642844984_REALK,      0.000000000000000_REALK,      0.026664013507553_REALK, &
      0.022994283129581_REALK,      0.000000000000000_REALK,     -0.004935508809943_REALK, &
      0.000000000000000_REALK,      0.039775631243828_REALK,      0.000000000000000_REALK, &
      0.068535232225451_REALK,      0.000000000000000_REALK,      0.138448972624428_REALK, &
      0.275612527428637_REALK,      0.000000000000000_REALK,      0.001650796005079_REALK, &
      0.000000000000000_REALK,      0.162228655183997_REALK,      0.000000000000000_REALK, &
      0.359353336821325_REALK,      0.000000000000000_REALK,      0.648327166967120_REALK, &
      0.372178526731837_REALK,      0.000000000000000_REALK,      0.026453540981224_REALK, &
      0.000000000000000_REALK,     -0.058742995572500_REALK,      0.000000000000000_REALK, &
      0.034091763088684_REALK,      0.000000000000000_REALK,      0.402427785360068_REALK, &
      0.000000000000000_REALK,      0.623737068045619_REALK,      0.000000000000000_REALK, &
      0.657481602826440_REALK,      0.000000000000000_REALK,     -0.003699908962676_REALK, &
      0.000000000000000_REALK,     -0.074090723996477_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.807807910902538_REALK,      0.000000000000000_REALK, &
      0.663395520899334_REALK,      0.000000000000000_REALK,     -0.026381667206948_REALK, &
      0.000000000000000_REALK,     -0.082354285896456_REALK,      0.000000000000000_REALK, &
     -0.132069419917292_REALK,      0.000000000000000_REALK,     -0.088798420787848_REALK, &
      0.000000000000000_REALK,     -0.377588458010237_REALK,      0.000000000000000_REALK, &
     -0.341577119703090_REALK,      0.000000000000000_REALK,     -0.132904383935080_REALK, &
     -0.212123532965422_REALK,      0.000000000000000_REALK,     -0.018990902340044_REALK, &
      0.000000000000000_REALK,     -0.619961812318197_REALK,      0.000000000000000_REALK, &
     -0.634657528258641_REALK,      0.000000000000000_REALK,     -0.101263228552584_REALK, &
      0.000000000000000_REALK,     -0.195709402341278_REALK,      0.000000000000000_REALK, &
     -0.196641760631247_REALK,      0.000000000000000_REALK,      0.076766823460924_REALK, &
      0.000000000000000_REALK,      0.032174226996603_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.254686804971588_REALK,      0.000000000000000_REALK, &
     -0.317806497320835_REALK,      0.000000000000000_REALK,      0.113988068114996_REALK, &
      0.000000000000000_REALK,      0.165138202160730_REALK,      0.000000000000000_REALK, &
      0.037960533676288_REALK,      0.000000000000000_REALK,     -0.074868235923156_REALK, &
      0.000000000000000_REALK,      0.153696249832628_REALK,      0.000000000000000_REALK, &
      0.149891706971968_REALK,      0.000000000000000_REALK,      0.046660655700218_REALK, &
      0.050587844685631_REALK,      0.000000000000000_REALK,     -0.065628187935177_REALK, &
      0.000000000000000_REALK,      0.202316190853284_REALK,      0.000000000000000_REALK, &
      0.212563983205844_REALK,      0.000000000000000_REALK,      0.030908668722725_REALK, &
      0.000000000000000_REALK,     -0.020994351444807_REALK,      0.000000000000000_REALK, &
     -0.076150282293583_REALK,      0.000000000000000_REALK,     -0.056419140201050_REALK, &
      0.000000000000000_REALK,      0.056484173361994_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.027887847215896_REALK,      0.000000000000000_REALK, &
     -0.060905964597129_REALK,      0.000000000000000_REALK,     -0.086262235759530_REALK, &
      0.000000000000000_REALK,     -0.013646503565365_REALK,      0.000000000000000_REALK, &
     -0.017232129112186_REALK,      0.000000000000000_REALK,     -0.069532890088892_REALK, &
      0.000000000000000_REALK,      0.026183196296815_REALK,      0.000000000000000_REALK, &
     -0.096761556380692_REALK,      0.000000000000000_REALK,      0.027779014742550_REALK, &
      0.050341273569904_REALK,      0.000000000000000_REALK,     -0.093201986034876_REALK, &
      0.000000000000000_REALK,      0.104758289026330_REALK,      0.000000000000000_REALK, &
     -0.006968550693565_REALK,      0.000000000000000_REALK,      0.019086725498637_REALK, &
      0.000000000000000_REALK,      0.012872494703305_REALK,      0.000000000000000_REALK, &
      0.105655803884915_REALK,      0.000000000000000_REALK,      0.023362659573928_REALK, &
      0.000000000000000_REALK,     -0.114855998004821_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.107399029230573_REALK,      0.000000000000000_REALK, &
      0.030454560804664_REALK,      0.000000000000000_REALK,      0.076365795569683_REALK, &
      0.000000000000000_REALK,     -0.052952652072543_REALK,      0.000000000000000_REALK, &
      0.042236653049613_REALK,      0.000000000000000_REALK,     -0.136711592561863_REALK, &
      0.000000000000000_REALK,      0.147952321178213_REALK,      0.000000000000000_REALK, &
      0.298513044882523_REALK,      0.000000000000000_REALK,     -0.015559668678000_REALK, &
     -0.096658515162978_REALK,      0.000000000000000_REALK,     -0.188545170004884_REALK, &
      0.000000000000000_REALK,     -0.086372575379317_REALK,      0.000000000000000_REALK, &
      0.049510659669702_REALK,      0.000000000000000_REALK,     -0.094545335929910_REALK, &
      0.000000000000000_REALK,     -0.260146900868752_REALK,      0.000000000000000_REALK, &
      0.095970385290069_REALK,      0.000000000000000_REALK,     -0.100798777274912_REALK, &
      0.000000000000000_REALK,     -0.089144804931663_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.302676041877945_REALK,      0.000000000000000_REALK, &
      0.715498734333912_REALK,      0.000000000000000_REALK,     -0.078900026040351_REALK, &
      0.000000000000000_REALK,     -0.060547526597224_REALK,      0.000000000000000_REALK, &
      0.051592676661613_REALK,      0.000000000000000_REALK,      0.072302565958909_REALK, &
      0.000000000000000_REALK,      0.254921543632556_REALK,      0.000000000000000_REALK, &
      0.286152877731931_REALK,      0.000000000000000_REALK,      0.031431491650594_REALK, &
      0.199842637155653_REALK,      0.000000000000000_REALK,      0.130643335346602_REALK, &
      0.000000000000000_REALK,      0.435278390480916_REALK,      0.000000000000000_REALK, &
      0.613786984043599_REALK,      0.000000000000000_REALK,      0.691137308190209_REALK/
  ! results of test 7, ket-major order, 02ODGXXY
  data REF_CONTR_INTS(17029:17424) /                                                       &
      0.054456077701145_REALK,      0.000000000000000_REALK,      0.024254364763424_REALK, &
      0.000000000000000_REALK,     -0.012570443485966_REALK,      0.000000000000000_REALK, &
     -0.022155790610574_REALK,      0.000000000000000_REALK,      0.116173690739777_REALK, &
     -0.000388452055629_REALK,      0.000000000000000_REALK,      0.000824092359952_REALK, &
      0.000000000000000_REALK,      0.011848470594195_REALK,      0.000000000000000_REALK, &
      0.012878535881867_REALK,      0.000000000000000_REALK,      0.083631591973188_REALK, &
      0.000000000000000_REALK,      0.054895402416842_REALK,      0.000000000000000_REALK, &
     -0.039173764159671_REALK,      0.000000000000000_REALK,     -0.015415055719982_REALK, &
      0.000000000000000_REALK,     -0.078397339352307_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.038369821616939_REALK,      0.000000000000000_REALK, &
     -0.019804848338601_REALK,      0.000000000000000_REALK,     -0.011822139924976_REALK, &
      0.000000000000000_REALK,     -0.054240704380818_REALK,      0.000000000000000_REALK, &
      0.008777331708641_REALK,      0.000000000000000_REALK,     -0.051035215544466_REALK, &
      0.000000000000000_REALK,      0.038541892508305_REALK,      0.000000000000000_REALK, &
     -0.013183537280185_REALK,      0.000000000000000_REALK,      0.004217697655439_REALK, &
     -0.009310904612624_REALK,      0.000000000000000_REALK,     -0.042544346288385_REALK, &
      0.000000000000000_REALK,      0.030853223267919_REALK,      0.000000000000000_REALK, &
     -0.003047818589870_REALK,      0.000000000000000_REALK,      0.012061484928350_REALK, &
      0.000000000000000_REALK,     -0.021830776103291_REALK,      0.000000000000000_REALK, &
      0.016393545898206_REALK,      0.000000000000000_REALK,      0.043254985219065_REALK, &
      0.000000000000000_REALK,     -0.024881119455520_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.010319249458745_REALK,      0.000000000000000_REALK, &
      0.012945154928598_REALK,      0.000000000000000_REALK,      0.018381702184673_REALK, &
      0.000000000000000_REALK,     -0.004055309567644_REALK,      0.000000000000000_REALK, &
      0.007971992481769_REALK,      0.000000000000000_REALK,      0.014359389729355_REALK, &
      0.000000000000000_REALK,     -0.027354885657027_REALK,      0.000000000000000_REALK, &
      0.027828327770795_REALK,      0.000000000000000_REALK,     -0.013848037320585_REALK, &
      0.010500268308004_REALK,      0.000000000000000_REALK,      0.005083085185655_REALK, &
      0.000000000000000_REALK,     -0.016468429749232_REALK,      0.000000000000000_REALK, &
      0.010981989562968_REALK,      0.000000000000000_REALK,     -0.003966507322337_REALK, &
      0.000000000000000_REALK,      0.011230370909789_REALK,      0.000000000000000_REALK, &
     -0.013045517573851_REALK,      0.000000000000000_REALK,     -0.033317574183720_REALK, &
      0.000000000000000_REALK,      0.012784331153529_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.014637285515742_REALK,      0.000000000000000_REALK, &
     -0.007382550194827_REALK,      0.000000000000000_REALK,     -0.012017068603304_REALK, &
      0.000000000000000_REALK,      0.009338056992525_REALK,      0.000000000000000_REALK, &
      0.003231731338788_REALK,      0.000000000000000_REALK,      0.036833046769155_REALK, &
      0.000000000000000_REALK,     -0.037211263816800_REALK,      0.000000000000000_REALK, &
      0.020533990065102_REALK,      0.000000000000000_REALK,     -0.007927111494749_REALK, &
     -0.001068341737767_REALK,      0.000000000000000_REALK,      0.014474242475932_REALK, &
      0.000000000000000_REALK,     -0.022378118020815_REALK,      0.000000000000000_REALK, &
     -0.000222942380169_REALK,      0.000000000000000_REALK,     -0.010452475605647_REALK, &
      0.000000000000000_REALK,     -0.020862008802857_REALK,      0.000000000000000_REALK, &
      0.021903329607405_REALK,      0.000000000000000_REALK,      0.008971316561943_REALK, &
      0.000000000000000_REALK,      0.031644524789394_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.006453248645470_REALK,      0.000000000000000_REALK, &
      0.026106138434660_REALK,      0.000000000000000_REALK,      0.003690630973934_REALK, &
      0.000000000000000_REALK,      0.013081760565280_REALK,      0.000000000000000_REALK, &
     -0.001006225825406_REALK,      0.000000000000000_REALK,     -0.015749636088085_REALK, &
      0.000000000000000_REALK,     -0.005414503116660_REALK,      0.000000000000000_REALK, &
      0.041049988403280_REALK,      0.000000000000000_REALK,     -0.028354882084542_REALK, &
      0.001978503519782_REALK,      0.000000000000000_REALK,     -0.023810092597251_REALK, &
      0.000000000000000_REALK,      0.020565719388376_REALK,      0.000000000000000_REALK, &
      0.047697573196841_REALK,      0.000000000000000_REALK,      0.014142102398115_REALK, &
      0.000000000000000_REALK,     -0.052010486094090_REALK,      0.000000000000000_REALK, &
     -0.010761419979787_REALK,      0.000000000000000_REALK,      0.021340203303459_REALK, &
      0.000000000000000_REALK,     -0.069346972301002_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.050733494697254_REALK,      0.000000000000000_REALK, &
     -0.058773868007104_REALK,      0.000000000000000_REALK,     -0.010799509255249_REALK, &
      0.000000000000000_REALK,     -0.087905090444553_REALK,      0.000000000000000_REALK, &
      0.115134467212984_REALK,      0.000000000000000_REALK,      0.003844708142414_REALK, &
      0.000000000000000_REALK,     -0.013152402083576_REALK,      0.000000000000000_REALK, &
     -0.009434892373866_REALK,      0.000000000000000_REALK,     -0.033844929264031_REALK, &
      0.114831712474467_REALK,      0.000000000000000_REALK,      0.031161434888475_REALK, &
      0.000000000000000_REALK,     -0.034611732928008_REALK,      0.000000000000000_REALK, &
     -0.035777307123597_REALK,      0.000000000000000_REALK,     -0.034588769636099_REALK, &
     -0.016143068228952_REALK,      0.000000000000000_REALK,     -0.086651146505892_REALK, &
      0.000000000000000_REALK,     -0.083937386620448_REALK,      0.000000000000000_REALK, &
     -0.051292440892124_REALK,      0.000000000000000_REALK,     -0.025332793478188_REALK, &
     -0.064807294900822_REALK,      0.000000000000000_REALK,     -0.082440760523695_REALK, &
      0.000000000000000_REALK,     -0.012971112680700_REALK,      0.000000000000000_REALK, &
      0.028244382437502_REALK,      0.000000000000000_REALK,      0.054697875810185_REALK, &
      0.000000000000000_REALK,      0.109580431046375_REALK,      0.000000000000000_REALK, &
      0.020562015181635_REALK,      0.000000000000000_REALK,      0.056670040746133_REALK, &
      0.000000000000000_REALK,      0.030847598867574_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.022927259144367_REALK,      0.000000000000000_REALK, &
     -0.003550153293922_REALK,      0.000000000000000_REALK,      0.036947042374099_REALK, &
      0.000000000000000_REALK,      0.040189675553262_REALK,      0.000000000000000_REALK, &
     -0.004791930674080_REALK,      0.000000000000000_REALK,     -0.048622548037949_REALK, &
      0.000000000000000_REALK,     -0.076424728784495_REALK,      0.000000000000000_REALK, &
     -0.036425421363425_REALK,      0.000000000000000_REALK,      0.050387324337322_REALK, &
      0.001386439171192_REALK,      0.000000000000000_REALK,     -0.068064111742527_REALK, &
      0.000000000000000_REALK,     -0.048251746177458_REALK,      0.000000000000000_REALK, &
      0.030890570061844_REALK,      0.000000000000000_REALK,      0.059752968889309_REALK, &
      0.000000000000000_REALK,      0.068666783375347_REALK,      0.000000000000000_REALK, &
      0.037313405184240_REALK,      0.000000000000000_REALK,      0.063149264754366_REALK, &
      0.000000000000000_REALK,      0.034894365828734_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.091216050415072_REALK,      0.000000000000000_REALK, &
      0.091693622611534_REALK,      0.000000000000000_REALK,      0.099026130523012_REALK, &
      0.000000000000000_REALK,      0.041116818764824_REALK,      0.000000000000000_REALK, &
     -0.010150667036057_REALK,      0.000000000000000_REALK,     -0.090928733843155_REALK, &
      0.000000000000000_REALK,     -0.000007064660693_REALK,      0.000000000000000_REALK, &
      0.019249497930781_REALK,      0.000000000000000_REALK,      0.020126882043300_REALK, &
     -0.023222619909154_REALK,      0.000000000000000_REALK,     -0.100267062463471_REALK, &
      0.000000000000000_REALK,     -0.031155708889802_REALK,      0.000000000000000_REALK, &
     -0.038918547779223_REALK,      0.000000000000000_REALK,      0.004480497650861_REALK, &
      0.000000000000000_REALK,     -0.040064291834804_REALK,      0.000000000000000_REALK, &
     -0.005954502857505_REALK,      0.000000000000000_REALK,     -0.066214130037169_REALK, &
      0.000000000000000_REALK,     -0.036447621565149_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.026119881501528_REALK,      0.000000000000000_REALK, &
     -0.013117968390701_REALK,      0.000000000000000_REALK,     -0.074553682927914_REALK, &
      0.000000000000000_REALK,     -0.023260881871206_REALK,      0.000000000000000_REALK, &
     -0.000570951564338_REALK,      0.000000000000000_REALK,     -0.035536790430222_REALK, &
      0.000000000000000_REALK,      0.041265674430759_REALK,      0.000000000000000_REALK, &
      0.014856308750993_REALK,      0.000000000000000_REALK,      0.007948629480892_REALK, &
     -0.030073109184392_REALK,      0.000000000000000_REALK,     -0.073473130035395_REALK, &
      0.000000000000000_REALK,      0.020868257789527_REALK,      0.000000000000000_REALK, &
     -0.027153944135689_REALK,      0.000000000000000_REALK,      0.007213055575640_REALK, &
      0.000000000000000_REALK,     -0.038922290337602_REALK,      0.000000000000000_REALK, &
      0.031835154417273_REALK,      0.000000000000000_REALK,      0.000718395583582_REALK, &
      0.000000000000000_REALK,     -0.047168261664130_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.028108367821455_REALK,      0.000000000000000_REALK, &
      0.125032943893304_REALK,      0.000000000000000_REALK,     -0.000560452231521_REALK, &
      0.000000000000000_REALK,     -0.084899667174777_REALK,      0.000000000000000_REALK, &
     -0.003679923522237_REALK,      0.000000000000000_REALK,     -0.124407284608255_REALK, &
      0.000000000000000_REALK,     -0.019675013344364_REALK,      0.000000000000000_REALK, &
      0.081094232583569_REALK,      0.000000000000000_REALK,      0.036027817004480_REALK, &
      0.025233234561845_REALK,      0.000000000000000_REALK,     -0.132436077558983_REALK, &
      0.000000000000000_REALK,      0.067354940664036_REALK,      0.000000000000000_REALK, &
      0.181835786797595_REALK,      0.000000000000000_REALK,      0.072973065034842_REALK, &
      0.000000000000000_REALK,      0.012173852454635_REALK,      0.000000000000000_REALK, &
      0.145624645869635_REALK,      0.000000000000000_REALK,     -0.080684536798704_REALK, &
      0.000000000000000_REALK,     -0.071577835707635_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.185564870973203_REALK,      0.000000000000000_REALK, &
     -0.041445437824508_REALK,      0.000000000000000_REALK,     -0.080213923239417_REALK, &
      0.000000000000000_REALK,     -0.085008310528321_REALK,      0.000000000000000_REALK, &
      0.063159958778537_REALK,      0.000000000000000_REALK,     -0.000557651858482_REALK, &
      0.000000000000000_REALK,      0.051083281320110_REALK,      0.000000000000000_REALK, &
      0.073766956049325_REALK,      0.000000000000000_REALK,      0.079751295685339_REALK, &
     -0.011187012670448_REALK,      0.000000000000000_REALK,      0.003483993728354_REALK, &
      0.000000000000000_REALK,     -0.040214173558130_REALK,      0.000000000000000_REALK, &
     -0.087885796741571_REALK,      0.000000000000000_REALK,     -0.188289286865099_REALK/
  ! results of test 7, ket-major order, 02ODGXYY
  data REF_CONTR_INTS(17425:17820) /                                                       &
      0.010624836081255_REALK,      0.000000000000000_REALK,     -0.002350738086818_REALK, &
      0.000000000000000_REALK,      0.008944742906198_REALK,      0.000000000000000_REALK, &
     -0.014118234660825_REALK,      0.000000000000000_REALK,      0.091156779910614_REALK, &
      0.049505341778912_REALK,      0.000000000000000_REALK,      0.015411995263525_REALK, &
      0.000000000000000_REALK,     -0.023092360091508_REALK,      0.000000000000000_REALK, &
     -0.021225276961403_REALK,      0.000000000000000_REALK,      0.011793029477538_REALK, &
      0.000000000000000_REALK,      0.039820819290316_REALK,      0.000000000000000_REALK, &
     -0.008526422849625_REALK,      0.000000000000000_REALK,      0.024210617906324_REALK, &
      0.000000000000000_REALK,     -0.053144970012802_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.010752173744152_REALK,      0.000000000000000_REALK, &
     -0.025699118763978_REALK,      0.000000000000000_REALK,      0.027376109118515_REALK, &
      0.000000000000000_REALK,     -0.069391118195671_REALK,      0.000000000000000_REALK, &
      0.019796011522772_REALK,      0.000000000000000_REALK,     -0.027559626663069_REALK, &
      0.000000000000000_REALK,      0.015910649475437_REALK,      0.000000000000000_REALK, &
     -0.016919703853945_REALK,      0.000000000000000_REALK,      0.000511264595356_REALK, &
      0.010201591250480_REALK,      0.000000000000000_REALK,     -0.015691843481818_REALK, &
      0.000000000000000_REALK,      0.009018200423369_REALK,      0.000000000000000_REALK, &
     -0.002388497232429_REALK,      0.000000000000000_REALK,      0.007893558135593_REALK, &
      0.000000000000000_REALK,     -0.015568277668709_REALK,      0.000000000000000_REALK, &
      0.004694183928890_REALK,      0.000000000000000_REALK,      0.047990041678235_REALK, &
      0.000000000000000_REALK,     -0.044770693410555_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.009596459644765_REALK,      0.000000000000000_REALK, &
     -0.003706482631219_REALK,      0.000000000000000_REALK,      0.023644749495975_REALK, &
      0.000000000000000_REALK,     -0.028965982813310_REALK,      0.000000000000000_REALK, &
      0.012722620709106_REALK,      0.000000000000000_REALK,      0.004973650524976_REALK, &
      0.000000000000000_REALK,     -0.030780090984314_REALK,      0.000000000000000_REALK, &
      0.040702206977942_REALK,      0.000000000000000_REALK,     -0.015861102595208_REALK, &
      0.005905577420508_REALK,      0.000000000000000_REALK,     -0.003146929304358_REALK, &
      0.000000000000000_REALK,     -0.014316857445824_REALK,      0.000000000000000_REALK, &
      0.023485160688963_REALK,      0.000000000000000_REALK,     -0.000819010840912_REALK, &
      0.000000000000000_REALK,      0.004809687909201_REALK,      0.000000000000000_REALK, &
     -0.004176790201741_REALK,      0.000000000000000_REALK,     -0.037404033733365_REALK, &
      0.000000000000000_REALK,      0.028357458147538_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.004065045322128_REALK,      0.000000000000000_REALK, &
      0.001808441873545_REALK,      0.000000000000000_REALK,     -0.017132788123148_REALK, &
      0.000000000000000_REALK,      0.006618209193714_REALK,      0.000000000000000_REALK, &
      0.003551406330859_REALK,      0.000000000000000_REALK,      0.018228626159504_REALK, &
      0.000000000000000_REALK,     -0.028024532889010_REALK,      0.000000000000000_REALK, &
      0.029812736359775_REALK,      0.000000000000000_REALK,     -0.009215025768654_REALK, &
      0.011595867526208_REALK,      0.000000000000000_REALK,      0.007029855221590_REALK, &
      0.000000000000000_REALK,     -0.011810302909237_REALK,      0.000000000000000_REALK, &
      0.022939629561593_REALK,      0.000000000000000_REALK,      0.000207191721918_REALK, &
      0.000000000000000_REALK,     -0.020681810656961_REALK,      0.000000000000000_REALK, &
      0.008210105336939_REALK,      0.000000000000000_REALK,     -0.010734994109517_REALK, &
      0.000000000000000_REALK,      0.023534125868098_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.022296436608717_REALK,      0.000000000000000_REALK, &
     -0.005325654203324_REALK,      0.000000000000000_REALK,     -0.008203884091406_REALK, &
      0.000000000000000_REALK,      0.008679174788158_REALK,      0.000000000000000_REALK, &
      0.014847296917705_REALK,      0.000000000000000_REALK,     -0.002201809177009_REALK, &
      0.000000000000000_REALK,     -0.029075468317257_REALK,      0.000000000000000_REALK, &
      0.044223114127320_REALK,      0.000000000000000_REALK,     -0.034288043856815_REALK, &
      0.026555420770569_REALK,      0.000000000000000_REALK,      0.009655014148333_REALK, &
      0.000000000000000_REALK,     -0.042684434997475_REALK,      0.000000000000000_REALK, &
      0.023866110675612_REALK,      0.000000000000000_REALK,     -0.022826622486454_REALK, &
      0.000000000000000_REALK,     -0.039342235116375_REALK,      0.000000000000000_REALK, &
      0.009893478453310_REALK,      0.000000000000000_REALK,      0.033111812430330_REALK, &
      0.000000000000000_REALK,     -0.047626434250960_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.013155922789211_REALK,      0.000000000000000_REALK, &
      0.031178447979673_REALK,      0.000000000000000_REALK,      0.019096056569067_REALK, &
      0.000000000000000_REALK,      0.008208181822352_REALK,      0.000000000000000_REALK, &
      0.072362058010856_REALK,      0.000000000000000_REALK,     -0.014249813385747_REALK, &
      0.000000000000000_REALK,     -0.006436143699342_REALK,      0.000000000000000_REALK, &
      0.020141065670202_REALK,      0.000000000000000_REALK,     -0.036831314683761_REALK, &
      0.026718850573364_REALK,      0.000000000000000_REALK,     -0.016782355033829_REALK, &
      0.000000000000000_REALK,     -0.005265171333704_REALK,      0.000000000000000_REALK, &
      0.030683737800199_REALK,      0.000000000000000_REALK,     -0.045447389757878_REALK, &
     -0.033568814405749_REALK,      0.000000000000000_REALK,     -0.078859062181412_REALK, &
      0.000000000000000_REALK,     -0.058301963433400_REALK,      0.000000000000000_REALK, &
     -0.019830483123191_REALK,      0.000000000000000_REALK,     -0.007179615060460_REALK, &
      0.063842431711022_REALK,      0.000000000000000_REALK,     -0.069159636677097_REALK, &
      0.000000000000000_REALK,     -0.108521012930906_REALK,      0.000000000000000_REALK, &
     -0.068248690567159_REALK,      0.000000000000000_REALK,     -0.069133186924111_REALK, &
      0.000000000000000_REALK,      0.174951237209936_REALK,      0.000000000000000_REALK, &
     -0.037124375842895_REALK,      0.000000000000000_REALK,      0.107904000935018_REALK, &
      0.000000000000000_REALK,      0.097554296704636_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.168002206836618_REALK,      0.000000000000000_REALK, &
     -0.076324743553402_REALK,      0.000000000000000_REALK,      0.094036582566219_REALK, &
      0.000000000000000_REALK,      0.073215414955788_REALK,      0.000000000000000_REALK, &
     -0.009935377615380_REALK,      0.000000000000000_REALK,     -0.036059686346263_REALK, &
      0.000000000000000_REALK,     -0.067016880757304_REALK,      0.000000000000000_REALK, &
     -0.065350145100426_REALK,      0.000000000000000_REALK,      0.037108358747678_REALK, &
     -0.014007530851966_REALK,      0.000000000000000_REALK,     -0.060067190257753_REALK, &
      0.000000000000000_REALK,     -0.112114749272982_REALK,      0.000000000000000_REALK, &
     -0.054294792605848_REALK,      0.000000000000000_REALK,      0.029162712905205_REALK, &
      0.000000000000000_REALK,      0.090577496523577_REALK,      0.000000000000000_REALK, &
     -0.022232293314349_REALK,      0.000000000000000_REALK,      0.086727118498938_REALK, &
      0.000000000000000_REALK,      0.074694621874347_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.053184652686932_REALK,      0.000000000000000_REALK, &
     -0.061644954111776_REALK,      0.000000000000000_REALK,      0.126390953062836_REALK, &
      0.000000000000000_REALK,      0.085565742756709_REALK,      0.000000000000000_REALK, &
     -0.018718689182751_REALK,      0.000000000000000_REALK,     -0.142129611967598_REALK, &
      0.000000000000000_REALK,     -0.055413423316157_REALK,      0.000000000000000_REALK, &
      0.030971503903928_REALK,      0.000000000000000_REALK,      0.064340622117817_REALK, &
     -0.042695627625836_REALK,      0.000000000000000_REALK,     -0.176580699800599_REALK, &
      0.000000000000000_REALK,     -0.055752056158531_REALK,      0.000000000000000_REALK, &
      0.017145645896177_REALK,      0.000000000000000_REALK,      0.048392625031809_REALK, &
      0.000000000000000_REALK,     -0.069374772661214_REALK,      0.000000000000000_REALK, &
      0.035063394968083_REALK,      0.000000000000000_REALK,     -0.085727211856046_REALK, &
      0.000000000000000_REALK,     -0.078053610469199_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.041202760316076_REALK,      0.000000000000000_REALK, &
      0.052974673657991_REALK,      0.000000000000000_REALK,     -0.117588504159960_REALK, &
      0.000000000000000_REALK,     -0.107739395442966_REALK,      0.000000000000000_REALK, &
     -0.004527925803681_REALK,      0.000000000000000_REALK,     -0.067926639507729_REALK, &
      0.000000000000000_REALK,     -0.002819139916921_REALK,      0.000000000000000_REALK, &
      0.037199376441502_REALK,      0.000000000000000_REALK,      0.023869656936094_REALK, &
      0.002762247518188_REALK,      0.000000000000000_REALK,     -0.074753240263183_REALK, &
      0.000000000000000_REALK,      0.003105851662792_REALK,      0.000000000000000_REALK, &
      0.025342451965105_REALK,      0.000000000000000_REALK,      0.013428458223722_REALK, &
      0.000000000000000_REALK,     -0.066958850696073_REALK,      0.000000000000000_REALK, &
      0.052986840731243_REALK,      0.000000000000000_REALK,     -0.038622635696198_REALK, &
      0.000000000000000_REALK,     -0.072636898295089_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.077883429250598_REALK,      0.000000000000000_REALK, &
      0.041641852129886_REALK,      0.000000000000000_REALK,     -0.049840401047584_REALK, &
      0.000000000000000_REALK,     -0.079989694748921_REALK,      0.000000000000000_REALK, &
     -0.009794893177793_REALK,      0.000000000000000_REALK,     -0.156728398652004_REALK, &
      0.000000000000000_REALK,     -0.083396621838821_REALK,      0.000000000000000_REALK, &
      0.055035158156423_REALK,      0.000000000000000_REALK,      0.076307668694854_REALK, &
     -0.035606187363512_REALK,      0.000000000000000_REALK,     -0.180328937408767_REALK, &
      0.000000000000000_REALK,     -0.156789416793931_REALK,      0.000000000000000_REALK, &
      0.011084518217346_REALK,      0.000000000000000_REALK,      0.037635835444770_REALK, &
      0.000000000000000_REALK,      0.061208492892226_REALK,      0.000000000000000_REALK, &
      0.111957884203224_REALK,      0.000000000000000_REALK,     -0.056772348023201_REALK, &
      0.000000000000000_REALK,     -0.034480102442910_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.085787997650846_REALK,      0.000000000000000_REALK, &
      0.211701942155665_REALK,      0.000000000000000_REALK,     -0.085184642245011_REALK, &
      0.000000000000000_REALK,      0.002000657895022_REALK,      0.000000000000000_REALK, &
      0.041396749776306_REALK,      0.000000000000000_REALK,     -0.067143439359537_REALK, &
      0.000000000000000_REALK,     -0.004216286881538_REALK,      0.000000000000000_REALK, &
      0.051485608029501_REALK,      0.000000000000000_REALK,      0.183173156306906_REALK, &
      0.064525071309064_REALK,      0.000000000000000_REALK,     -0.041541302370076_REALK, &
      0.000000000000000_REALK,      0.024785016932824_REALK,      0.000000000000000_REALK, &
      0.076444045018840_REALK,      0.000000000000000_REALK,      0.260320304211411_REALK/
  ! results of test 7, ket-major order, 02ODGYYY
  data REF_CONTR_INTS(17821:18216) /                                                       &
      0.026735105603254_REALK,      0.000000000000000_REALK,     -0.008055655287555_REALK, &
      0.000000000000000_REALK,      0.004804332344550_REALK,      0.000000000000000_REALK, &
     -0.014554630397256_REALK,      0.000000000000000_REALK,      0.079013867237274_REALK, &
      0.050566885090510_REALK,      0.000000000000000_REALK,     -0.038679792570771_REALK, &
      0.000000000000000_REALK,     -0.016558578093688_REALK,      0.000000000000000_REALK, &
      0.063065598501755_REALK,      0.000000000000000_REALK,     -0.028103641658358_REALK, &
      0.000000000000000_REALK,      0.034515104688953_REALK,      0.000000000000000_REALK, &
     -0.010233301640987_REALK,      0.000000000000000_REALK,      0.066584961465040_REALK, &
      0.000000000000000_REALK,     -0.087105917745211_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.031455533507162_REALK,      0.000000000000000_REALK, &
      0.020609701673989_REALK,      0.000000000000000_REALK,      0.055497807196212_REALK, &
      0.000000000000000_REALK,     -0.042988596446481_REALK,      0.000000000000000_REALK, &
      0.032256981812206_REALK,      0.000000000000000_REALK,     -0.027522081958069_REALK, &
      0.000000000000000_REALK,     -0.001014907533415_REALK,      0.000000000000000_REALK, &
      0.005441889078978_REALK,      0.000000000000000_REALK,     -0.007910539283401_REALK, &
      0.053374468491663_REALK,      0.000000000000000_REALK,     -0.030451738261629_REALK, &
      0.000000000000000_REALK,     -0.052261130539777_REALK,      0.000000000000000_REALK, &
      0.049731325445186_REALK,      0.000000000000000_REALK,     -0.022828592875955_REALK, &
      0.000000000000000_REALK,     -0.001932827724837_REALK,      0.000000000000000_REALK, &
      0.002542110651371_REALK,      0.000000000000000_REALK,      0.069678535319292_REALK, &
      0.000000000000000_REALK,     -0.065860288594712_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.009424363215752_REALK,      0.000000000000000_REALK, &
      0.002479376823510_REALK,      0.000000000000000_REALK,      0.038672620926776_REALK, &
      0.000000000000000_REALK,     -0.019173329165197_REALK,      0.000000000000000_REALK, &
      0.033521022660093_REALK,      0.000000000000000_REALK,     -0.006347090733404_REALK, &
      0.000000000000000_REALK,     -0.053635573040665_REALK,      0.000000000000000_REALK, &
      0.069246895592305_REALK,      0.000000000000000_REALK,     -0.030239726632097_REALK, &
      0.057351190686402_REALK,      0.000000000000000_REALK,     -0.020536742363415_REALK, &
      0.000000000000000_REALK,     -0.070338157912597_REALK,      0.000000000000000_REALK, &
      0.080342756359882_REALK,      0.000000000000000_REALK,     -0.010235261953201_REALK, &
      0.000000000000000_REALK,     -0.009274982942502_REALK,      0.000000000000000_REALK, &
      0.001329641884004_REALK,      0.000000000000000_REALK,     -0.060633779907346_REALK, &
      0.000000000000000_REALK,      0.052179413865585_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.039589308462868_REALK,      0.000000000000000_REALK, &
      0.010752381297509_REALK,      0.000000000000000_REALK,     -0.060437284338566_REALK, &
      0.000000000000000_REALK,      0.047413441518076_REALK,      0.000000000000000_REALK, &
      0.009010905840876_REALK,      0.000000000000000_REALK,      0.008495614852513_REALK, &
      0.000000000000000_REALK,     -0.032109372952558_REALK,      0.000000000000000_REALK, &
      0.039130091306501_REALK,      0.000000000000000_REALK,     -0.015670432271337_REALK, &
      0.003071966193357_REALK,      0.000000000000000_REALK,      0.000261906349376_REALK, &
      0.000000000000000_REALK,     -0.019289006798944_REALK,      0.000000000000000_REALK, &
      0.018083819046888_REALK,      0.000000000000000_REALK,     -0.003586863050687_REALK, &
      0.000000000000000_REALK,     -0.027298087624454_REALK,      0.000000000000000_REALK, &
      0.010159142914633_REALK,      0.000000000000000_REALK,     -0.043382715247796_REALK, &
      0.000000000000000_REALK,      0.045141272600067_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.044268570021897_REALK,      0.000000000000000_REALK, &
      0.026893622741251_REALK,      0.000000000000000_REALK,     -0.074239944229090_REALK, &
      0.000000000000000_REALK,      0.065096172911825_REALK,      0.000000000000000_REALK, &
      0.030898738221270_REALK,      0.000000000000000_REALK,     -0.006082120939164_REALK, &
      0.000000000000000_REALK,     -0.050234328781556_REALK,      0.000000000000000_REALK, &
      0.073487165922540_REALK,      0.000000000000000_REALK,     -0.048381507938730_REALK, &
      0.014952225839307_REALK,      0.000000000000000_REALK,     -0.010025586227710_REALK, &
      0.000000000000000_REALK,     -0.026243595398864_REALK,      0.000000000000000_REALK, &
      0.061770633316372_REALK,      0.000000000000000_REALK,     -0.003688189063867_REALK, &
      0.000000000000000_REALK,     -0.041197510474718_REALK,      0.000000000000000_REALK, &
      0.008092166978176_REALK,      0.000000000000000_REALK,      0.021866213929306_REALK, &
      0.000000000000000_REALK,     -0.040801744241969_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.052549987171279_REALK,      0.000000000000000_REALK, &
      0.009784687770232_REALK,      0.000000000000000_REALK,     -0.064766072838372_REALK, &
      0.000000000000000_REALK,      0.047393404873062_REALK,      0.000000000000000_REALK, &
      0.100164760197819_REALK,      0.000000000000000_REALK,     -0.018401293339483_REALK, &
      0.000000000000000_REALK,     -0.031609419837682_REALK,      0.000000000000000_REALK, &
      0.045437923552468_REALK,      0.000000000000000_REALK,     -0.082354465272853_REALK, &
      0.035474784262229_REALK,      0.000000000000000_REALK,     -0.015646561741896_REALK, &
      0.000000000000000_REALK,      0.002199094467474_REALK,      0.000000000000000_REALK, &
      0.021668052458074_REALK,      0.000000000000000_REALK,     -0.039550528386663_REALK, &
     -0.011830761216450_REALK,      0.000000000000000_REALK,     -0.074657543660040_REALK, &
      0.000000000000000_REALK,     -0.064087207104028_REALK,      0.000000000000000_REALK, &
     -0.021031913418018_REALK,      0.000000000000000_REALK,     -0.064198646992507_REALK, &
      0.293852206516996_REALK,      0.000000000000000_REALK,     -0.290838930571772_REALK, &
      0.000000000000000_REALK,     -0.139413392671949_REALK,      0.000000000000000_REALK, &
      0.107534624096749_REALK,      0.000000000000000_REALK,      0.362845984463018_REALK, &
      0.000000000000000_REALK,      0.288972976153727_REALK,      0.000000000000000_REALK, &
     -0.148746870390710_REALK,      0.000000000000000_REALK,      0.206823010334952_REALK, &
      0.000000000000000_REALK,      0.150642302685522_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.410609061027961_REALK,      0.000000000000000_REALK, &
     -0.104285601285256_REALK,      0.000000000000000_REALK,      0.183052893001215_REALK, &
      0.000000000000000_REALK,      0.285104730213264_REALK,      0.000000000000000_REALK, &
      0.004604431280142_REALK,      0.000000000000000_REALK,     -0.067538954539683_REALK, &
      0.000000000000000_REALK,     -0.068607233643385_REALK,      0.000000000000000_REALK, &
     -0.046345530770576_REALK,      0.000000000000000_REALK,      0.099576946991475_REALK, &
      0.033392211017841_REALK,      0.000000000000000_REALK,     -0.347114238342238_REALK, &
      0.000000000000000_REALK,     -0.321742689491816_REALK,      0.000000000000000_REALK, &
      0.096327445912444_REALK,      0.000000000000000_REALK,      0.287421087570992_REALK, &
      0.000000000000000_REALK,      0.182081853980767_REALK,      0.000000000000000_REALK, &
     -0.090059306585850_REALK,      0.000000000000000_REALK,      0.162851836186129_REALK, &
      0.000000000000000_REALK,      0.136264838455317_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.157141005424291_REALK,      0.000000000000000_REALK, &
     -0.104129613111704_REALK,      0.000000000000000_REALK,      0.225601703604120_REALK, &
      0.000000000000000_REALK,      0.225627986823708_REALK,      0.000000000000000_REALK, &
     -0.023264235012457_REALK,      0.000000000000000_REALK,     -0.266853461390087_REALK, &
      0.000000000000000_REALK,     -0.163707949507113_REALK,      0.000000000000000_REALK, &
      0.053772623010078_REALK,      0.000000000000000_REALK,      0.156862324061861_REALK, &
     -0.044223651773835_REALK,      0.000000000000000_REALK,     -0.537050741734380_REALK, &
      0.000000000000000_REALK,     -0.367142569514007_REALK,      0.000000000000000_REALK, &
      0.086966521383850_REALK,      0.000000000000000_REALK,      0.250463635321000_REALK, &
      0.000000000000000_REALK,     -0.149001905690618_REALK,      0.000000000000000_REALK, &
      0.105565834682372_REALK,      0.000000000000000_REALK,     -0.154993396342204_REALK, &
      0.000000000000000_REALK,     -0.138038047804344_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.240216955675626_REALK,      0.000000000000000_REALK, &
      0.229334083775828_REALK,      0.000000000000000_REALK,     -0.312947910509939_REALK, &
      0.000000000000000_REALK,     -0.243196455365165_REALK,      0.000000000000000_REALK, &
     -0.011010565640762_REALK,      0.000000000000000_REALK,     -0.132247691299309_REALK, &
      0.000000000000000_REALK,     -0.066393299396825_REALK,      0.000000000000000_REALK, &
      0.052246148511745_REALK,      0.000000000000000_REALK,      0.058380519376315_REALK, &
     -0.046134015088825_REALK,      0.000000000000000_REALK,     -0.173177347818471_REALK, &
      0.000000000000000_REALK,     -0.076243338898966_REALK,      0.000000000000000_REALK, &
      0.018425094790364_REALK,      0.000000000000000_REALK,      0.045615418793238_REALK, &
      0.000000000000000_REALK,     -0.146021637479029_REALK,      0.000000000000000_REALK, &
      0.117895989474533_REALK,      0.000000000000000_REALK,     -0.116928134376467_REALK, &
      0.000000000000000_REALK,     -0.125788462368378_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.342741905399633_REALK,      0.000000000000000_REALK, &
      0.307733939720449_REALK,      0.000000000000000_REALK,     -0.339218286629936_REALK, &
      0.000000000000000_REALK,     -0.275206577947644_REALK,      0.000000000000000_REALK, &
     -0.005097739820123_REALK,      0.000000000000000_REALK,     -0.265474388127037_REALK, &
      0.000000000000000_REALK,     -0.173541257037800_REALK,      0.000000000000000_REALK, &
      0.090844923231148_REALK,      0.000000000000000_REALK,      0.180769083225335_REALK, &
     -0.087024200857304_REALK,      0.000000000000000_REALK,     -0.379168780615826_REALK, &
      0.000000000000000_REALK,     -0.184912275527809_REALK,      0.000000000000000_REALK, &
      0.165577384165774_REALK,      0.000000000000000_REALK,      0.188638764363965_REALK, &
      0.000000000000000_REALK,      0.057452174136298_REALK,      0.000000000000000_REALK, &
      0.075220861801098_REALK,      0.000000000000000_REALK,     -0.050805945565344_REALK, &
      0.000000000000000_REALK,     -0.013119217828578_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.391041317061062_REALK,      0.000000000000000_REALK, &
      0.208439514490423_REALK,      0.000000000000000_REALK,     -0.340534483921136_REALK, &
      0.000000000000000_REALK,     -0.041796261423791_REALK,      0.000000000000000_REALK, &
      0.106118214783358_REALK,      0.000000000000000_REALK,     -0.169482514757161_REALK, &
      0.000000000000000_REALK,     -0.088842408989777_REALK,      0.000000000000000_REALK, &
      0.035037856549288_REALK,      0.000000000000000_REALK,      0.325476618896424_REALK, &
     -0.039879489096718_REALK,      0.000000000000000_REALK,     -0.111500412681766_REALK, &
      0.000000000000000_REALK,     -0.021019819117071_REALK,      0.000000000000000_REALK, &
     -0.033076208409839_REALK,      0.000000000000000_REALK,      0.430636018139918_REALK/
  ! results of test 7, ket-major order, 02ODGXXZ
  data REF_CONTR_INTS(18217:18612) /                                                       &
      0.000000000000000_REALK,      0.046808956801748_REALK,      0.000000000000000_REALK, &
      0.000927568094687_REALK,      0.000000000000000_REALK,     -0.007392297907150_REALK, &
      0.000000000000000_REALK,     -0.048323395684889_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.041182237454846_REALK,      0.000000000000000_REALK, &
      0.028545136277276_REALK,      0.000000000000000_REALK,      0.007625759007427_REALK, &
      0.000000000000000_REALK,      0.010746631475868_REALK,      0.000000000000000_REALK, &
     -0.046618473034439_REALK,      0.000000000000000_REALK,     -0.053600614179840_REALK, &
      0.000000000000000_REALK,      0.030043789576992_REALK,      0.000000000000000_REALK, &
      0.009580624965807_REALK,      0.000000000000000_REALK,      0.052298616485254_REALK, &
     -0.075590299651390_REALK,      0.000000000000000_REALK,     -0.026444776345978_REALK, &
      0.000000000000000_REALK,     -0.001479886905678_REALK,      0.000000000000000_REALK, &
     -0.011947737138564_REALK,      0.000000000000000_REALK,      0.008227608569732_REALK, &
      0.000000000000000_REALK,      0.035282857227467_REALK,      0.000000000000000_REALK, &
      0.010337579397536_REALK,      0.000000000000000_REALK,      0.009373854407024_REALK, &
      0.000000000000000_REALK,     -0.000160296896348_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.030906824866714_REALK,      0.000000000000000_REALK, &
      0.036624846522063_REALK,      0.000000000000000_REALK,      0.025410113304840_REALK, &
      0.000000000000000_REALK,      0.064488380597924_REALK,      0.000000000000000_REALK, &
      0.022417311962789_REALK,      0.000000000000000_REALK,      0.003701888523334_REALK, &
      0.000000000000000_REALK,     -0.006993491595284_REALK,      0.000000000000000_REALK, &
     -0.002137227077502_REALK,      0.000000000000000_REALK,      0.008188460082972_REALK, &
      0.015426616824683_REALK,      0.000000000000000_REALK,      0.007591250493565_REALK, &
      0.000000000000000_REALK,     -0.008352355915991_REALK,      0.000000000000000_REALK, &
     -0.021383472622894_REALK,      0.000000000000000_REALK,      0.000711682175921_REALK, &
      0.000000000000000_REALK,     -0.014843463870251_REALK,      0.000000000000000_REALK, &
     -0.005106993070023_REALK,      0.000000000000000_REALK,     -0.003284913084103_REALK, &
      0.000000000000000_REALK,     -0.013481967583346_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.000947335377809_REALK,      0.000000000000000_REALK, &
     -0.016085624048259_REALK,      0.000000000000000_REALK,     -0.008183625442719_REALK, &
      0.000000000000000_REALK,     -0.030088192187061_REALK,      0.000000000000000_REALK, &
      0.003868212614025_REALK,      0.000000000000000_REALK,      0.008714278865362_REALK, &
      0.000000000000000_REALK,     -0.000672709382879_REALK,      0.000000000000000_REALK, &
      0.003132065054666_REALK,      0.000000000000000_REALK,     -0.005347477011957_REALK, &
      0.010479953878087_REALK,      0.000000000000000_REALK,      0.018887427057925_REALK, &
      0.000000000000000_REALK,     -0.009744396559579_REALK,      0.000000000000000_REALK, &
      0.012185044438601_REALK,      0.000000000000000_REALK,     -0.002865871016862_REALK, &
      0.000000000000000_REALK,     -0.026714217353230_REALK,      0.000000000000000_REALK, &
      0.001457247609950_REALK,      0.000000000000000_REALK,      0.002903062200218_REALK, &
      0.000000000000000_REALK,      0.020053547827266_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.013760913846421_REALK,      0.000000000000000_REALK, &
     -0.008315265800356_REALK,      0.000000000000000_REALK,      0.000070502179738_REALK, &
      0.000000000000000_REALK,      0.002294349691503_REALK,      0.000000000000000_REALK, &
     -0.009310846945702_REALK,      0.000000000000000_REALK,     -0.001685637516650_REALK, &
      0.000000000000000_REALK,     -0.004871995371943_REALK,      0.000000000000000_REALK, &
     -0.005362935638577_REALK,      0.000000000000000_REALK,     -0.017451385077162_REALK, &
      0.000057596229602_REALK,      0.000000000000000_REALK,     -0.024555569471341_REALK, &
      0.000000000000000_REALK,      0.007468384203319_REALK,      0.000000000000000_REALK, &
     -0.011719520231133_REALK,      0.000000000000000_REALK,     -0.006656622608348_REALK, &
      0.000000000000000_REALK,      0.004498809243704_REALK,      0.000000000000000_REALK, &
     -0.000114777861944_REALK,      0.000000000000000_REALK,     -0.007156140146213_REALK, &
      0.000000000000000_REALK,     -0.041358600521160_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.036678735037264_REALK,      0.000000000000000_REALK, &
      0.014473655236633_REALK,      0.000000000000000_REALK,     -0.004377702424106_REALK, &
      0.000000000000000_REALK,     -0.038489709863080_REALK,      0.000000000000000_REALK, &
      0.065712904529393_REALK,      0.000000000000000_REALK,     -0.003133057865396_REALK, &
      0.000000000000000_REALK,      0.008825293523074_REALK,      0.000000000000000_REALK, &
      0.045126175462497_REALK,      0.000000000000000_REALK,      0.045333261101993_REALK, &
     -0.007846101203350_REALK,      0.000000000000000_REALK,     -0.029781609564698_REALK, &
      0.000000000000000_REALK,      0.025448592353656_REALK,      0.000000000000000_REALK, &
      0.043782878058999_REALK,      0.000000000000000_REALK,      0.064282922438565_REALK, &
      0.000000000000000_REALK,     -0.052700179779645_REALK,      0.000000000000000_REALK, &
     -0.040828366026937_REALK,      0.000000000000000_REALK,     -0.013395585769133_REALK, &
      0.000000000000000_REALK,     -0.063952749461400_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.001708778341857_REALK,      0.000000000000000_REALK, &
      0.000409922945450_REALK,      0.000000000000000_REALK,     -0.007959950283273_REALK, &
      0.000000000000000_REALK,     -0.027505078755000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.245694231889235_REALK,      0.000000000000000_REALK, &
      0.298841029977850_REALK,      0.000000000000000_REALK,     -0.021156541832631_REALK, &
      0.000000000000000_REALK,     -0.072214941088423_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.288022593805682_REALK,      0.000000000000000_REALK, &
      0.280027107633123_REALK,      0.000000000000000_REALK,     -0.027525172241556_REALK, &
      0.000000000000000_REALK,     -0.076394260532566_REALK,      0.000000000000000_REALK, &
     -0.045255776211560_REALK,      0.000000000000000_REALK,     -0.143497407080493_REALK, &
      0.000000000000000_REALK,     -0.219401705608859_REALK,      0.000000000000000_REALK, &
     -0.132121558414011_REALK,      0.000000000000000_REALK,      0.090345005784844_REALK, &
     -0.051861406231115_REALK,      0.000000000000000_REALK,     -0.108632904327390_REALK, &
      0.000000000000000_REALK,     -0.413347086966024_REALK,      0.000000000000000_REALK, &
     -0.379523628717143_REALK,      0.000000000000000_REALK,      0.117993945996697_REALK, &
      0.000000000000000_REALK,      0.050010460134071_REALK,      0.000000000000000_REALK, &
      0.037361239444171_REALK,      0.000000000000000_REALK,      0.116580856082167_REALK, &
      0.000000000000000_REALK,      0.048912861392357_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.186018658518020_REALK,      0.000000000000000_REALK, &
     -0.024116057502381_REALK,      0.000000000000000_REALK,      0.140969588487640_REALK, &
      0.000000000000000_REALK,      0.196724005162270_REALK,      0.000000000000000_REALK, &
     -0.005091222359336_REALK,      0.000000000000000_REALK,     -0.074048655706641_REALK, &
      0.000000000000000_REALK,      0.039492697193377_REALK,      0.000000000000000_REALK, &
      0.022212619287209_REALK,      0.000000000000000_REALK,     -0.029612661005340_REALK, &
     -0.028115244295263_REALK,      0.000000000000000_REALK,      0.047692071255168_REALK, &
      0.000000000000000_REALK,     -0.082758161162394_REALK,      0.000000000000000_REALK, &
     -0.107512220483947_REALK,      0.000000000000000_REALK,     -0.075036824692734_REALK, &
      0.000000000000000_REALK,      0.005921924872506_REALK,      0.000000000000000_REALK, &
      0.047855219482355_REALK,      0.000000000000000_REALK,     -0.034134811513855_REALK, &
      0.000000000000000_REALK,     -0.040685489010165_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.019364488921440_REALK,      0.000000000000000_REALK, &
      0.060913028302782_REALK,      0.000000000000000_REALK,     -0.001684750205130_REALK, &
      0.000000000000000_REALK,     -0.033863845313862_REALK,      0.000000000000000_REALK, &
      0.001553542179422_REALK,      0.000000000000000_REALK,      0.086027727949665_REALK, &
      0.000000000000000_REALK,      0.024092100104942_REALK,      0.000000000000000_REALK, &
      0.020258662465604_REALK,      0.000000000000000_REALK,      0.000403674220555_REALK, &
      0.020438435463324_REALK,      0.000000000000000_REALK,      0.054056074570455_REALK, &
      0.000000000000000_REALK,      0.084647726458629_REALK,      0.000000000000000_REALK, &
      0.030920934651354_REALK,      0.000000000000000_REALK,      0.013510447839046_REALK, &
      0.000000000000000_REALK,      0.023951759945727_REALK,      0.000000000000000_REALK, &
     -0.078406237568524_REALK,      0.000000000000000_REALK,     -0.034601986402555_REALK, &
      0.000000000000000_REALK,     -0.000651787045058_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.017038240383573_REALK,      0.000000000000000_REALK, &
     -0.041777062227916_REALK,      0.000000000000000_REALK,      0.044041562928154_REALK, &
      0.000000000000000_REALK,     -0.012598901718491_REALK,      0.000000000000000_REALK, &
      0.010076810284000_REALK,      0.000000000000000_REALK,     -0.053199093825233_REALK, &
      0.000000000000000_REALK,     -0.026956037336584_REALK,      0.000000000000000_REALK, &
     -0.012049429818983_REALK,      0.000000000000000_REALK,      0.010247600611858_REALK, &
     -0.023294768104207_REALK,      0.000000000000000_REALK,     -0.149393662915679_REALK, &
      0.000000000000000_REALK,     -0.060645473069030_REALK,      0.000000000000000_REALK, &
      0.007314137273497_REALK,      0.000000000000000_REALK,     -0.009401720404835_REALK, &
      0.000000000000000_REALK,     -0.000374653252250_REALK,      0.000000000000000_REALK, &
      0.230412423067137_REALK,      0.000000000000000_REALK,     -0.034711506367547_REALK, &
      0.000000000000000_REALK,     -0.107465787706496_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.118806740849034_REALK,      0.000000000000000_REALK, &
      0.431501884766339_REALK,      0.000000000000000_REALK,     -0.001776947691602_REALK, &
      0.000000000000000_REALK,     -0.074578714088175_REALK,      0.000000000000000_REALK, &
      0.037273520768514_REALK,      0.000000000000000_REALK,     -0.097371891534427_REALK, &
      0.000000000000000_REALK,      0.221533547121722_REALK,      0.000000000000000_REALK, &
      0.329467931795208_REALK,      0.000000000000000_REALK,      0.026469848983476_REALK, &
     -0.007372828330824_REALK,      0.000000000000000_REALK,     -0.106015419140591_REALK, &
      0.000000000000000_REALK,      0.130906202890153_REALK,      0.000000000000000_REALK, &
      0.267313146593516_REALK,      0.000000000000000_REALK,      0.177127411471706_REALK, &
      0.000000000000000_REALK,     -0.169490665412773_REALK,      0.000000000000000_REALK, &
      0.004930573213743_REALK,      0.000000000000000_REALK,     -0.056547383674573_REALK, &
      0.000000000000000_REALK,     -0.061916909213037_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.072419166856315_REALK,      0.000000000000000_REALK, &
      0.254998664803308_REALK,      0.000000000000000_REALK,     -0.045523808643254_REALK, &
      0.000000000000000_REALK,     -0.049167701981030_REALK,      0.000000000000000_REALK/
  ! results of test 7, ket-major order, 02ODGXYZ
  data REF_CONTR_INTS(18613:19008) /                                                       &
      0.000000000000000_REALK,      0.007766861752138_REALK,      0.000000000000000_REALK, &
     -0.013575877297606_REALK,      0.000000000000000_REALK,      0.003043569432271_REALK, &
      0.000000000000000_REALK,     -0.046606276383719_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.008157550755800_REALK,      0.000000000000000_REALK, &
     -0.003707290707466_REALK,      0.000000000000000_REALK,     -0.001317876018643_REALK, &
      0.000000000000000_REALK,     -0.023824825367555_REALK,      0.000000000000000_REALK, &
     -0.003480246015435_REALK,      0.000000000000000_REALK,     -0.022666000362424_REALK, &
      0.000000000000000_REALK,      0.009615589908202_REALK,      0.000000000000000_REALK, &
      0.003973478200167_REALK,      0.000000000000000_REALK,      0.036025624175652_REALK, &
     -0.013483713134387_REALK,      0.000000000000000_REALK,     -0.022086544418382_REALK, &
      0.000000000000000_REALK,      0.011895239590155_REALK,      0.000000000000000_REALK, &
      0.012508071833968_REALK,      0.000000000000000_REALK,      0.046594989975028_REALK, &
      0.000000000000000_REALK,      0.021383566082550_REALK,      0.000000000000000_REALK, &
     -0.000071283368036_REALK,      0.000000000000000_REALK,      0.003140910723074_REALK, &
      0.000000000000000_REALK,     -0.008358506981307_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.032985334921353_REALK,      0.000000000000000_REALK, &
     -0.002625880987392_REALK,      0.000000000000000_REALK,     -0.001465227310469_REALK, &
      0.000000000000000_REALK,     -0.020174703935628_REALK,      0.000000000000000_REALK, &
      0.003345333506587_REALK,      0.000000000000000_REALK,     -0.003964897022173_REALK, &
      0.000000000000000_REALK,     -0.002515541200796_REALK,      0.000000000000000_REALK, &
      0.002947483958840_REALK,      0.000000000000000_REALK,      0.011981387994104_REALK, &
     -0.020565179295908_REALK,      0.000000000000000_REALK,     -0.025751513843903_REALK, &
      0.000000000000000_REALK,      0.020614550653389_REALK,      0.000000000000000_REALK, &
     -0.013151024585682_REALK,      0.000000000000000_REALK,      0.014783715338442_REALK, &
      0.000000000000000_REALK,     -0.012195978092024_REALK,      0.000000000000000_REALK, &
      0.001568826565468_REALK,      0.000000000000000_REALK,      0.002641729651459_REALK, &
      0.000000000000000_REALK,     -0.010903386363856_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000024192019685_REALK,      0.000000000000000_REALK, &
      0.003584179001897_REALK,      0.000000000000000_REALK,      0.003876215928375_REALK, &
      0.000000000000000_REALK,     -0.007356389076344_REALK,      0.000000000000000_REALK, &
      0.000247810830090_REALK,      0.000000000000000_REALK,      0.004523438637696_REALK, &
      0.000000000000000_REALK,     -0.000290964274759_REALK,      0.000000000000000_REALK, &
      0.002291658271331_REALK,      0.000000000000000_REALK,     -0.007553344557769_REALK, &
      0.002119825645146_REALK,      0.000000000000000_REALK,      0.012092843132312_REALK, &
      0.000000000000000_REALK,     -0.010750346575491_REALK,      0.000000000000000_REALK, &
      0.005317311564052_REALK,      0.000000000000000_REALK,     -0.009762323495621_REALK, &
      0.000000000000000_REALK,     -0.017758397242487_REALK,      0.000000000000000_REALK, &
      0.000509154554931_REALK,      0.000000000000000_REALK,      0.000889647603746_REALK, &
      0.000000000000000_REALK,     -0.002007466475372_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.004019857040113_REALK,      0.000000000000000_REALK, &
      0.005482905903152_REALK,      0.000000000000000_REALK,      0.003509537627381_REALK, &
      0.000000000000000_REALK,     -0.007098776544664_REALK,      0.000000000000000_REALK, &
      0.004223043058580_REALK,      0.000000000000000_REALK,      0.002457356316441_REALK, &
      0.000000000000000_REALK,     -0.002386694827876_REALK,      0.000000000000000_REALK, &
      0.000660336692356_REALK,      0.000000000000000_REALK,     -0.011581855355585_REALK, &
      0.002677389124842_REALK,      0.000000000000000_REALK,     -0.011946690214233_REALK, &
      0.000000000000000_REALK,      0.010500315416534_REALK,      0.000000000000000_REALK, &
      0.011980427027987_REALK,      0.000000000000000_REALK,      0.008056897938477_REALK, &
      0.000000000000000_REALK,     -0.010914504375991_REALK,      0.000000000000000_REALK, &
      0.002415370424798_REALK,      0.000000000000000_REALK,      0.000053211962855_REALK, &
      0.000000000000000_REALK,     -0.017238355833397_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.014912736932858_REALK,      0.000000000000000_REALK, &
     -0.020163485484116_REALK,      0.000000000000000_REALK,     -0.002928985311649_REALK, &
      0.000000000000000_REALK,     -0.064278573036338_REALK,      0.000000000000000_REALK, &
      0.029715969128317_REALK,      0.000000000000000_REALK,      0.009846967639677_REALK, &
      0.000000000000000_REALK,     -0.015174325453274_REALK,      0.000000000000000_REALK, &
      0.024529039464169_REALK,      0.000000000000000_REALK,      0.012779768465953_REALK, &
      0.048805147283402_REALK,      0.000000000000000_REALK,      0.010750600325972_REALK, &
      0.000000000000000_REALK,     -0.009997035026749_REALK,      0.000000000000000_REALK, &
      0.015356987780571_REALK,      0.000000000000000_REALK,      0.007155841098578_REALK, &
      0.000000000000000_REALK,     -0.034794884578935_REALK,      0.000000000000000_REALK, &
      0.001066231728799_REALK,      0.000000000000000_REALK,      0.002092880247465_REALK, &
      0.000000000000000_REALK,     -0.005929186633088_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.029083465398140_REALK,      0.000000000000000_REALK, &
     -0.013792097211803_REALK,      0.000000000000000_REALK,     -0.009732827105514_REALK, &
      0.000000000000000_REALK,     -0.011325116187280_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.064405142897898_REALK,      0.000000000000000_REALK, &
      0.044322009054042_REALK,      0.000000000000000_REALK,      0.009525748795537_REALK, &
      0.000000000000000_REALK,     -0.006038954658940_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.025968309195426_REALK,      0.000000000000000_REALK, &
      0.055964007374611_REALK,      0.000000000000000_REALK,     -0.005378508510589_REALK, &
      0.000000000000000_REALK,      0.007768534054019_REALK,      0.000000000000000_REALK, &
     -0.027491984803056_REALK,      0.000000000000000_REALK,     -0.122804837519803_REALK, &
      0.000000000000000_REALK,     -0.102469661343561_REALK,      0.000000000000000_REALK, &
     -0.043933921704635_REALK,      0.000000000000000_REALK,     -0.016339262505731_REALK, &
     -0.050099135053452_REALK,      0.000000000000000_REALK,     -0.158032126263259_REALK, &
      0.000000000000000_REALK,     -0.088200478457723_REALK,      0.000000000000000_REALK, &
      0.010179587153491_REALK,      0.000000000000000_REALK,     -0.018137146001023_REALK, &
      0.000000000000000_REALK,      0.026872162815690_REALK,      0.000000000000000_REALK, &
      0.014505575115090_REALK,      0.000000000000000_REALK,      0.093934056169971_REALK, &
      0.000000000000000_REALK,      0.003995210898643_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.032832264753386_REALK,      0.000000000000000_REALK, &
      0.026783764857805_REALK,      0.000000000000000_REALK,      0.113870076000274_REALK, &
      0.000000000000000_REALK,     -0.019778668903288_REALK,      0.000000000000000_REALK, &
     -0.014775960642108_REALK,      0.000000000000000_REALK,     -0.075745246795930_REALK, &
      0.000000000000000_REALK,     -0.013245947576126_REALK,      0.000000000000000_REALK, &
     -0.026727129850045_REALK,      0.000000000000000_REALK,     -0.002333582172824_REALK, &
     -0.027741637861591_REALK,      0.000000000000000_REALK,     -0.084003188717644_REALK, &
      0.000000000000000_REALK,     -0.022640109993810_REALK,      0.000000000000000_REALK, &
     -0.086092749633613_REALK,      0.000000000000000_REALK,      0.002836717866414_REALK, &
      0.000000000000000_REALK,      0.030435045439428_REALK,      0.000000000000000_REALK, &
      0.047793427120221_REALK,      0.000000000000000_REALK,     -0.038212755544511_REALK, &
      0.000000000000000_REALK,     -0.023342554219593_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.078768014181131_REALK,      0.000000000000000_REALK, &
      0.081325399594995_REALK,      0.000000000000000_REALK,     -0.001604243089235_REALK, &
      0.000000000000000_REALK,      0.014207210870013_REALK,      0.000000000000000_REALK, &
      0.010216030754779_REALK,      0.000000000000000_REALK,      0.049698036390427_REALK, &
      0.000000000000000_REALK,      0.019463664888355_REALK,      0.000000000000000_REALK, &
      0.035656087378146_REALK,      0.000000000000000_REALK,      0.011423820183777_REALK, &
     -0.013119491401579_REALK,      0.000000000000000_REALK,      0.018359308110281_REALK, &
      0.000000000000000_REALK,      0.039026781176279_REALK,      0.000000000000000_REALK, &
      0.054032813758120_REALK,      0.000000000000000_REALK,      0.016839784967882_REALK, &
      0.000000000000000_REALK,      0.009468547562436_REALK,      0.000000000000000_REALK, &
      0.002711981694184_REALK,      0.000000000000000_REALK,     -0.053558532321372_REALK, &
      0.000000000000000_REALK,     -0.014258972217331_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.060559148937154_REALK,      0.000000000000000_REALK, &
      0.045440724086443_REALK,      0.000000000000000_REALK,     -0.010643262409858_REALK, &
      0.000000000000000_REALK,     -0.021409614797488_REALK,      0.000000000000000_REALK, &
      0.009695522043080_REALK,      0.000000000000000_REALK,      0.002797335444130_REALK, &
      0.000000000000000_REALK,      0.007965014084873_REALK,      0.000000000000000_REALK, &
      0.021584795603756_REALK,      0.000000000000000_REALK,      0.016941104550624_REALK, &
      0.014385827892748_REALK,      0.000000000000000_REALK,     -0.053845530603869_REALK, &
      0.000000000000000_REALK,      0.015196168315987_REALK,      0.000000000000000_REALK, &
      0.071250345708002_REALK,      0.000000000000000_REALK,      0.048240101025818_REALK, &
      0.000000000000000_REALK,      0.020523655596858_REALK,      0.000000000000000_REALK, &
      0.102578431501171_REALK,      0.000000000000000_REALK,     -0.043596814060837_REALK, &
      0.000000000000000_REALK,     -0.056981214383747_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.019688289068359_REALK,      0.000000000000000_REALK, &
      0.108858958632905_REALK,      0.000000000000000_REALK,     -0.075731916310977_REALK, &
      0.000000000000000_REALK,     -0.120272421696262_REALK,      0.000000000000000_REALK, &
      0.007171624904396_REALK,      0.000000000000000_REALK,     -0.094582722151401_REALK, &
      0.000000000000000_REALK,      0.016201402920165_REALK,      0.000000000000000_REALK, &
      0.095215622440132_REALK,      0.000000000000000_REALK,      0.020207961921246_REALK, &
      0.044384590467932_REALK,      0.000000000000000_REALK,     -0.080501081973394_REALK, &
      0.000000000000000_REALK,      0.050647101024284_REALK,      0.000000000000000_REALK, &
      0.096969706788929_REALK,      0.000000000000000_REALK,     -0.041212713439928_REALK, &
      0.000000000000000_REALK,     -0.052625907856261_REALK,      0.000000000000000_REALK, &
      0.065918648612698_REALK,      0.000000000000000_REALK,     -0.059008813263294_REALK, &
      0.000000000000000_REALK,     -0.071748000366867_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.127958570795333_REALK,      0.000000000000000_REALK, &
      0.003132284229590_REALK,      0.000000000000000_REALK,     -0.055654403362139_REALK, &
      0.000000000000000_REALK,     -0.071457121356256_REALK,      0.000000000000000_REALK/
  ! results of test 7, ket-major order, 02ODGYYZ
  data REF_CONTR_INTS(19009:19404) /                                                       &
      0.000000000000000_REALK,      0.000722638393140_REALK,      0.000000000000000_REALK, &
     -0.000200653652528_REALK,      0.000000000000000_REALK,      0.015493642973996_REALK, &
      0.000000000000000_REALK,     -0.032800554336998_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.015939515120741_REALK,      0.000000000000000_REALK, &
     -0.004000709234044_REALK,      0.000000000000000_REALK,     -0.008540863434665_REALK, &
      0.000000000000000_REALK,     -0.010855712952992_REALK,      0.000000000000000_REALK, &
     -0.010116770826772_REALK,      0.000000000000000_REALK,     -0.013142320990006_REALK, &
      0.000000000000000_REALK,     -0.002650244748639_REALK,      0.000000000000000_REALK, &
      0.006492526055784_REALK,      0.000000000000000_REALK,      0.037249923846055_REALK, &
      0.013416515652361_REALK,      0.000000000000000_REALK,     -0.002749940932829_REALK, &
      0.000000000000000_REALK,     -0.019165320075510_REALK,      0.000000000000000_REALK, &
      0.014181278559145_REALK,      0.000000000000000_REALK,      0.022281411626054_REALK, &
      0.000000000000000_REALK,      0.011877425293363_REALK,      0.000000000000000_REALK, &
      0.002146294760232_REALK,      0.000000000000000_REALK,      0.007961369948654_REALK, &
      0.000000000000000_REALK,     -0.005494610563067_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.007061957261359_REALK,      0.000000000000000_REALK, &
     -0.009231192589191_REALK,      0.000000000000000_REALK,      0.026602188801467_REALK, &
      0.000000000000000_REALK,     -0.055034385487340_REALK,      0.000000000000000_REALK, &
      0.003424657438978_REALK,      0.000000000000000_REALK,     -0.003488223287083_REALK, &
      0.000000000000000_REALK,     -0.003469870875376_REALK,      0.000000000000000_REALK, &
      0.000459783483497_REALK,      0.000000000000000_REALK,      0.018749318352941_REALK, &
      0.001224860286043_REALK,      0.000000000000000_REALK,     -0.011635277821830_REALK, &
      0.000000000000000_REALK,      0.008290349004901_REALK,      0.000000000000000_REALK, &
     -0.010523732998889_REALK,      0.000000000000000_REALK,      0.013971411885498_REALK, &
      0.000000000000000_REALK,     -0.011780507494918_REALK,      0.000000000000000_REALK, &
      0.001790730652671_REALK,      0.000000000000000_REALK,      0.009038247119453_REALK, &
      0.000000000000000_REALK,     -0.023355777232859_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.010288181196578_REALK,      0.000000000000000_REALK, &
     -0.006185979139245_REALK,      0.000000000000000_REALK,      0.031049441787130_REALK, &
      0.000000000000000_REALK,     -0.063392162917489_REALK,      0.000000000000000_REALK, &
      0.004100672824010_REALK,      0.000000000000000_REALK,      0.004063280226005_REALK, &
      0.000000000000000_REALK,     -0.002098538478177_REALK,      0.000000000000000_REALK, &
      0.005920767675652_REALK,      0.000000000000000_REALK,     -0.015285714031258_REALK, &
      0.033848853707778_REALK,      0.000000000000000_REALK,      0.011125418197099_REALK, &
      0.000000000000000_REALK,     -0.024129919025447_REALK,      0.000000000000000_REALK, &
      0.034243771139451_REALK,      0.000000000000000_REALK,     -0.014433659795992_REALK, &
      0.000000000000000_REALK,     -0.013894486992542_REALK,      0.000000000000000_REALK, &
      0.000844886134901_REALK,      0.000000000000000_REALK,      0.002367486480733_REALK, &
      0.000000000000000_REALK,     -0.010142946815686_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.015091342363142_REALK,      0.000000000000000_REALK, &
     -0.001404112937382_REALK,      0.000000000000000_REALK,      0.004406341320648_REALK, &
      0.000000000000000_REALK,     -0.006919914436955_REALK,      0.000000000000000_REALK, &
      0.011182133703953_REALK,      0.000000000000000_REALK,      0.002887379518336_REALK, &
      0.000000000000000_REALK,     -0.003879104763507_REALK,      0.000000000000000_REALK, &
      0.005294528129213_REALK,      0.000000000000000_REALK,     -0.018214529142043_REALK, &
      0.041320454887161_REALK,      0.000000000000000_REALK,      0.012038796726451_REALK, &
      0.000000000000000_REALK,     -0.032567416965687_REALK,      0.000000000000000_REALK, &
      0.025264957345644_REALK,      0.000000000000000_REALK,     -0.032695906675025_REALK, &
      0.000000000000000_REALK,     -0.015527818983745_REALK,      0.000000000000000_REALK, &
      0.004489415834432_REALK,      0.000000000000000_REALK,      0.002989795187926_REALK, &
      0.000000000000000_REALK,     -0.018330552988583_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.018748266035413_REALK,      0.000000000000000_REALK, &
      0.017177182746283_REALK,      0.000000000000000_REALK,      0.010241500360901_REALK, &
      0.000000000000000_REALK,     -0.008668124369398_REALK,      0.000000000000000_REALK, &
      0.022530641006934_REALK,      0.000000000000000_REALK,      0.007389812084011_REALK, &
      0.000000000000000_REALK,     -0.017513068267883_REALK,      0.000000000000000_REALK, &
      0.025102323455748_REALK,      0.000000000000000_REALK,      0.005757280039744_REALK, &
      0.021517324693037_REALK,      0.000000000000000_REALK,      0.005593100978482_REALK, &
      0.000000000000000_REALK,     -0.011646771063436_REALK,      0.000000000000000_REALK, &
      0.018416600384074_REALK,      0.000000000000000_REALK,     -0.033295959031756_REALK, &
      0.000000000000000_REALK,     -0.028553313737781_REALK,      0.000000000000000_REALK, &
      0.007896076934186_REALK,      0.000000000000000_REALK,     -0.008555100539274_REALK, &
      0.000000000000000_REALK,      0.011820524792830_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.016309126728030_REALK,      0.000000000000000_REALK, &
      0.009308243165602_REALK,      0.000000000000000_REALK,     -0.008259994757321_REALK, &
      0.000000000000000_REALK,      0.019898806691641_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.087665355488543_REALK,      0.000000000000000_REALK, &
      0.012767258774098_REALK,      0.000000000000000_REALK,      0.032718939604049_REALK, &
      0.000000000000000_REALK,      0.024022655904206_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.047448344642757_REALK,      0.000000000000000_REALK, &
      0.042324036306064_REALK,      0.000000000000000_REALK,     -0.045561635694144_REALK, &
      0.000000000000000_REALK,     -0.018963311176065_REALK,      0.000000000000000_REALK, &
     -0.053438367754612_REALK,      0.000000000000000_REALK,     -0.125176465905888_REALK, &
      0.000000000000000_REALK,     -0.106142695864586_REALK,      0.000000000000000_REALK, &
     -0.031391452230942_REALK,      0.000000000000000_REALK,     -0.030591948893965_REALK, &
     -0.018284213300925_REALK,      0.000000000000000_REALK,     -0.219566526301258_REALK, &
      0.000000000000000_REALK,     -0.180890292443600_REALK,      0.000000000000000_REALK, &
      0.000047790517653_REALK,      0.000000000000000_REALK,     -0.088059273705947_REALK, &
      0.000000000000000_REALK,      0.030614844464357_REALK,      0.000000000000000_REALK, &
     -0.007426417436750_REALK,      0.000000000000000_REALK,      0.092045819524155_REALK, &
      0.000000000000000_REALK,      0.003705161786932_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.148047776938839_REALK,      0.000000000000000_REALK, &
     -0.028262575126042_REALK,      0.000000000000000_REALK,      0.143231377859772_REALK, &
      0.000000000000000_REALK,     -0.069339636575195_REALK,      0.000000000000000_REALK, &
     -0.024571347321890_REALK,      0.000000000000000_REALK,     -0.083798681693734_REALK, &
      0.000000000000000_REALK,     -0.039006710762942_REALK,      0.000000000000000_REALK, &
     -0.043261559967979_REALK,      0.000000000000000_REALK,     -0.025371225603518_REALK, &
      0.005439598961595_REALK,      0.000000000000000_REALK,     -0.057933774123421_REALK, &
      0.000000000000000_REALK,     -0.053033167759360_REALK,      0.000000000000000_REALK, &
     -0.135522833876680_REALK,      0.000000000000000_REALK,     -0.053164784518861_REALK, &
      0.000000000000000_REALK,      0.054008868138139_REALK,      0.000000000000000_REALK, &
      0.052919357951649_REALK,      0.000000000000000_REALK,     -0.038070912978555_REALK, &
      0.000000000000000_REALK,     -0.039302230186537_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.223581670280842_REALK,      0.000000000000000_REALK, &
      0.042534560167921_REALK,      0.000000000000000_REALK,      0.044758371278621_REALK, &
      0.000000000000000_REALK,     -0.029356966585192_REALK,      0.000000000000000_REALK, &
      0.021882939554250_REALK,      0.000000000000000_REALK,      0.045395473834004_REALK, &
      0.000000000000000_REALK,      0.023191307750157_REALK,      0.000000000000000_REALK, &
      0.049779250180040_REALK,      0.000000000000000_REALK,      0.031989706485417_REALK, &
      0.054405785095662_REALK,      0.000000000000000_REALK,     -0.019999201931279_REALK, &
      0.000000000000000_REALK,     -0.014420914671856_REALK,      0.000000000000000_REALK, &
      0.163278340204686_REALK,      0.000000000000000_REALK,      0.095116006683676_REALK, &
      0.000000000000000_REALK,      0.018550333795648_REALK,      0.000000000000000_REALK, &
      0.032424895496334_REALK,      0.000000000000000_REALK,     -0.057593360721177_REALK, &
      0.000000000000000_REALK,     -0.025198696830173_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.038191940199982_REALK,      0.000000000000000_REALK, &
      0.048678444292055_REALK,      0.000000000000000_REALK,     -0.030039787603130_REALK, &
      0.000000000000000_REALK,      0.011642719928168_REALK,      0.000000000000000_REALK, &
      0.024363556960482_REALK,      0.000000000000000_REALK,      0.015121923397888_REALK, &
      0.000000000000000_REALK,      0.010513078406414_REALK,      0.000000000000000_REALK, &
      0.034130963525129_REALK,      0.000000000000000_REALK,      0.036382456406552_REALK, &
      0.072196358385768_REALK,      0.000000000000000_REALK,     -0.023693155475158_REALK, &
      0.000000000000000_REALK,     -0.080585290681417_REALK,      0.000000000000000_REALK, &
      0.129013993865043_REALK,      0.000000000000000_REALK,      0.113215695109384_REALK, &
      0.000000000000000_REALK,      0.033493792473488_REALK,      0.000000000000000_REALK, &
      0.084427551393196_REALK,      0.000000000000000_REALK,     -0.060342320234740_REALK, &
      0.000000000000000_REALK,     -0.069041992363739_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.126861713809350_REALK,      0.000000000000000_REALK, &
      0.158325870002825_REALK,      0.000000000000000_REALK,     -0.138715706318609_REALK, &
      0.000000000000000_REALK,     -0.027589434435051_REALK,      0.000000000000000_REALK, &
      0.004698917980380_REALK,      0.000000000000000_REALK,     -0.111577889809200_REALK, &
      0.000000000000000_REALK,     -0.042251341521346_REALK,      0.000000000000000_REALK, &
      0.067650669473539_REALK,      0.000000000000000_REALK,      0.025894815707257_REALK, &
      0.098170097832334_REALK,      0.000000000000000_REALK,     -0.051714337075095_REALK, &
      0.000000000000000_REALK,     -0.000755648288870_REALK,      0.000000000000000_REALK, &
      0.034000225436370_REALK,      0.000000000000000_REALK,      0.107133976427859_REALK, &
      0.000000000000000_REALK,     -0.064809625114005_REALK,      0.000000000000000_REALK, &
      0.086014463867432_REALK,      0.000000000000000_REALK,     -0.075000547925556_REALK, &
      0.000000000000000_REALK,     -0.082220763335807_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.086649994509360_REALK,      0.000000000000000_REALK, &
      0.115095382436930_REALK,      0.000000000000000_REALK,     -0.086946045774781_REALK, &
      0.000000000000000_REALK,     -0.104008493516853_REALK,      0.000000000000000_REALK/
  ! results of test 7, ket-major order, 02ODGXZZ
  data REF_CONTR_INTS(19405:19800) /                                                       &
     -0.007535809791283_REALK,      0.000000000000000_REALK,     -0.017214258492439_REALK, &
      0.000000000000000_REALK,      0.007443882008771_REALK,      0.000000000000000_REALK, &
      0.012149533046325_REALK,      0.000000000000000_REALK,      0.028421480533271_REALK, &
     -0.017578889875140_REALK,      0.000000000000000_REALK,     -0.009354750099961_REALK, &
      0.000000000000000_REALK,     -0.001285089630525_REALK,      0.000000000000000_REALK, &
      0.001237287424249_REALK,      0.000000000000000_REALK,      0.012669066475553_REALK, &
      0.000000000000000_REALK,      0.047647764135804_REALK,      0.000000000000000_REALK, &
      0.010043622544688_REALK,      0.000000000000000_REALK,      0.003070856268103_REALK, &
      0.000000000000000_REALK,     -0.018838247201004_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.050270161482196_REALK,      0.000000000000000_REALK, &
      0.030104953121153_REALK,      0.000000000000000_REALK,      0.017367661202240_REALK, &
      0.000000000000000_REALK,      0.025628642292961_REALK,      0.000000000000000_REALK, &
     -0.017179750160845_REALK,      0.000000000000000_REALK,     -0.031290676187427_REALK, &
      0.000000000000000_REALK,      0.017478645719502_REALK,      0.000000000000000_REALK, &
     -0.016378271281985_REALK,      0.000000000000000_REALK,      0.007574710489437_REALK, &
     -0.044693009735048_REALK,      0.000000000000000_REALK,     -0.010058309922086_REALK, &
      0.000000000000000_REALK,     -0.007768097844819_REALK,      0.000000000000000_REALK, &
     -0.038645299456163_REALK,      0.000000000000000_REALK,     -0.018954821124896_REALK, &
      0.000000000000000_REALK,      0.006361701021222_REALK,      0.000000000000000_REALK, &
     -0.004333148747249_REALK,      0.000000000000000_REALK,      0.003308507544794_REALK, &
      0.000000000000000_REALK,     -0.011096544235826_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.011408274494894_REALK,      0.000000000000000_REALK, &
      0.010152085477684_REALK,      0.000000000000000_REALK,      0.014109888042301_REALK, &
      0.000000000000000_REALK,      0.046250307385846_REALK,      0.000000000000000_REALK, &
      0.007770626571404_REALK,      0.000000000000000_REALK,      0.005993376780066_REALK, &
      0.000000000000000_REALK,     -0.007207895010599_REALK,      0.000000000000000_REALK, &
      0.012406758090129_REALK,      0.000000000000000_REALK,      0.005723056291048_REALK, &
      0.007461790672414_REALK,      0.000000000000000_REALK,     -0.004807762195517_REALK, &
      0.000000000000000_REALK,      0.001730995389893_REALK,      0.000000000000000_REALK, &
      0.005292295855474_REALK,      0.000000000000000_REALK,      0.010543332434043_REALK, &
      0.000000000000000_REALK,     -0.012765695713540_REALK,      0.000000000000000_REALK, &
     -0.002148439845100_REALK,      0.000000000000000_REALK,     -0.004326258971733_REALK, &
      0.000000000000000_REALK,      0.004749664606179_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.022662942573902_REALK,      0.000000000000000_REALK, &
     -0.006976398324150_REALK,      0.000000000000000_REALK,     -0.007974928045292_REALK, &
      0.000000000000000_REALK,     -0.001771751614145_REALK,      0.000000000000000_REALK, &
      0.003097142538118_REALK,      0.000000000000000_REALK,      0.023015802588294_REALK, &
      0.000000000000000_REALK,     -0.019230390041071_REALK,      0.000000000000000_REALK, &
      0.005071746654086_REALK,      0.000000000000000_REALK,     -0.005986433201538_REALK, &
     -0.010943924056832_REALK,      0.000000000000000_REALK,     -0.011992313266704_REALK, &
      0.000000000000000_REALK,      0.006879615391573_REALK,      0.000000000000000_REALK, &
     -0.010558907279056_REALK,      0.000000000000000_REALK,      0.003622415269064_REALK, &
      0.000000000000000_REALK,      0.001373290766683_REALK,      0.000000000000000_REALK, &
      0.007262054214039_REALK,      0.000000000000000_REALK,      0.003598241309211_REALK, &
      0.000000000000000_REALK,      0.004219664491882_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.031790025099984_REALK,      0.000000000000000_REALK, &
      0.011248055821196_REALK,      0.000000000000000_REALK,      0.005069911825876_REALK, &
      0.000000000000000_REALK,     -0.014649073859813_REALK,      0.000000000000000_REALK, &
      0.012108584068398_REALK,      0.000000000000000_REALK,     -0.019166605498400_REALK, &
      0.000000000000000_REALK,      0.009328470662780_REALK,      0.000000000000000_REALK, &
      0.024227250843455_REALK,      0.000000000000000_REALK,      0.020413209488492_REALK, &
     -0.017110889455801_REALK,      0.000000000000000_REALK,     -0.045416575431539_REALK, &
      0.000000000000000_REALK,      0.018356758635291_REALK,      0.000000000000000_REALK, &
      0.029711319908506_REALK,      0.000000000000000_REALK,      0.047279212973902_REALK, &
      0.000000000000000_REALK,     -0.017051091674987_REALK,      0.000000000000000_REALK, &
     -0.020030405587638_REALK,      0.000000000000000_REALK,     -0.012216924689475_REALK, &
      0.000000000000000_REALK,     -0.063555434163314_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.018793953706052_REALK,      0.000000000000000_REALK, &
      0.006379477952578_REALK,      0.000000000000000_REALK,     -0.009366452866842_REALK, &
      0.000000000000000_REALK,     -0.041044880828427_REALK,      0.000000000000000_REALK, &
      0.030985885710614_REALK,      0.000000000000000_REALK,      0.006840526636951_REALK, &
      0.000000000000000_REALK,      0.000146252132957_REALK,      0.000000000000000_REALK, &
      0.014763200574584_REALK,      0.000000000000000_REALK,      0.004765376849922_REALK, &
      0.009844150616104_REALK,      0.000000000000000_REALK,     -0.004706635247310_REALK, &
      0.000000000000000_REALK,      0.007181771466174_REALK,      0.000000000000000_REALK, &
      0.013815137645481_REALK,      0.000000000000000_REALK,      0.012619059974556_REALK, &
     -0.014145706208668_REALK,      0.000000000000000_REALK,     -0.099700114926240_REALK, &
      0.000000000000000_REALK,     -0.066305462689361_REALK,      0.000000000000000_REALK, &
     -0.015239638200356_REALK,      0.000000000000000_REALK,      0.046943780241327_REALK, &
     -0.006292742285607_REALK,      0.000000000000000_REALK,     -0.084315707791204_REALK, &
      0.000000000000000_REALK,     -0.138383188969487_REALK,      0.000000000000000_REALK, &
     -0.112559816644298_REALK,      0.000000000000000_REALK,      0.048654390393624_REALK, &
      0.000000000000000_REALK,      0.158881362501518_REALK,      0.000000000000000_REALK, &
      0.152196289794315_REALK,      0.000000000000000_REALK,      0.074631334669646_REALK, &
      0.000000000000000_REALK,      0.024335052361313_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.313808721359291_REALK,      0.000000000000000_REALK, &
      0.133480289307247_REALK,      0.000000000000000_REALK,      0.082901823253136_REALK, &
      0.000000000000000_REALK,      0.102286410821971_REALK,      0.000000000000000_REALK, &
     -0.027411550307326_REALK,      0.000000000000000_REALK,     -0.038016345136027_REALK, &
      0.000000000000000_REALK,     -0.113257357750295_REALK,      0.000000000000000_REALK, &
     -0.090637884034931_REALK,      0.000000000000000_REALK,      0.003434416680138_REALK, &
     -0.097256003195067_REALK,      0.000000000000000_REALK,      0.065564521179591_REALK, &
      0.000000000000000_REALK,     -0.352213565802154_REALK,      0.000000000000000_REALK, &
     -0.353442400044302_REALK,      0.000000000000000_REALK,     -0.000256677764514_REALK, &
      0.000000000000000_REALK,      0.013500927636785_REALK,      0.000000000000000_REALK, &
      0.032499203808814_REALK,      0.000000000000000_REALK,      0.051502288945704_REALK, &
      0.000000000000000_REALK,      0.011726632931107_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.011245692226341_REALK,      0.000000000000000_REALK, &
     -0.035227503567880_REALK,      0.000000000000000_REALK,      0.168278649347621_REALK, &
      0.000000000000000_REALK,      0.205886836352826_REALK,      0.000000000000000_REALK, &
     -0.002073774974698_REALK,      0.000000000000000_REALK,     -0.057250624081655_REALK, &
      0.000000000000000_REALK,      0.046954158072826_REALK,      0.000000000000000_REALK, &
      0.038770322263792_REALK,      0.000000000000000_REALK,      0.005913077790166_REALK, &
     -0.001473580045405_REALK,      0.000000000000000_REALK,     -0.098643884571529_REALK, &
      0.000000000000000_REALK,      0.051810876756081_REALK,      0.000000000000000_REALK, &
      0.012421885767035_REALK,      0.000000000000000_REALK,     -0.019233208925860_REALK, &
      0.000000000000000_REALK,     -0.024339556483785_REALK,      0.000000000000000_REALK, &
     -0.038144894224974_REALK,      0.000000000000000_REALK,     -0.057146751878288_REALK, &
      0.000000000000000_REALK,     -0.002687334405739_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.001118505075056_REALK,      0.000000000000000_REALK, &
     -0.061632055104213_REALK,      0.000000000000000_REALK,     -0.121353347349457_REALK, &
      0.000000000000000_REALK,     -0.030553404840021_REALK,      0.000000000000000_REALK, &
     -0.003949213541683_REALK,      0.000000000000000_REALK,     -0.012841706602773_REALK, &
      0.000000000000000_REALK,      0.056585525280712_REALK,      0.000000000000000_REALK, &
     -0.006393767610261_REALK,      0.000000000000000_REALK,      0.005780797661212_REALK, &
     -0.035131131345541_REALK,      0.000000000000000_REALK,     -0.158739551613433_REALK, &
      0.000000000000000_REALK,      0.088139465066210_REALK,      0.000000000000000_REALK, &
     -0.061107358103674_REALK,      0.000000000000000_REALK,      0.000214469631300_REALK, &
      0.000000000000000_REALK,      0.005080692785707_REALK,      0.000000000000000_REALK, &
      0.016178884273257_REALK,      0.000000000000000_REALK,      0.022863759710850_REALK, &
      0.000000000000000_REALK,     -0.038607488949505_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.074808469979388_REALK,      0.000000000000000_REALK, &
      0.193384039406582_REALK,      0.000000000000000_REALK,      0.118671280250861_REALK, &
      0.000000000000000_REALK,     -0.066603234283155_REALK,      0.000000000000000_REALK, &
      0.006268518036538_REALK,      0.000000000000000_REALK,     -0.125916625635566_REALK, &
      0.000000000000000_REALK,      0.023210787021185_REALK,      0.000000000000000_REALK, &
      0.118289706400504_REALK,      0.000000000000000_REALK,      0.023001466713126_REALK, &
     -0.060023319906390_REALK,      0.000000000000000_REALK,     -0.298205031029769_REALK, &
      0.000000000000000_REALK,     -0.026199551904029_REALK,      0.000000000000000_REALK, &
      0.146209791445770_REALK,      0.000000000000000_REALK,      0.080129037720597_REALK, &
      0.000000000000000_REALK,     -0.022938998078649_REALK,      0.000000000000000_REALK, &
      0.180405653160650_REALK,      0.000000000000000_REALK,     -0.073016315126467_REALK, &
      0.000000000000000_REALK,     -0.101006436254905_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.107515162162291_REALK,      0.000000000000000_REALK, &
      0.401889497857196_REALK,      0.000000000000000_REALK,     -0.055758143842915_REALK, &
      0.000000000000000_REALK,     -0.081428395431965_REALK,      0.000000000000000_REALK, &
      0.029504986127297_REALK,      0.000000000000000_REALK,      0.003633189160367_REALK, &
      0.000000000000000_REALK,      0.115112256367731_REALK,      0.000000000000000_REALK, &
      0.158384526170199_REALK,      0.000000000000000_REALK,      0.013356170217758_REALK, &
      0.020941525411057_REALK,      0.000000000000000_REALK,      0.008011927043673_REALK, &
      0.000000000000000_REALK,      0.083301667666832_REALK,      0.000000000000000_REALK, &
      0.133979713891791_REALK,      0.000000000000000_REALK,      0.076516408918954_REALK/
  ! results of test 7, ket-major order, 02ODGYZZ
  data REF_CONTR_INTS(19801:20196) /                                                       &
      0.007136317122064_REALK,      0.000000000000000_REALK,     -0.005873408239200_REALK, &
      0.000000000000000_REALK,     -0.001904291208060_REALK,      0.000000000000000_REALK, &
      0.009520841719522_REALK,      0.000000000000000_REALK,      0.016255854981664_REALK, &
      0.008192884405288_REALK,      0.000000000000000_REALK,     -0.007013505010990_REALK, &
      0.000000000000000_REALK,      0.001520502482535_REALK,      0.000000000000000_REALK, &
      0.010149123376238_REALK,      0.000000000000000_REALK,      0.009237674539105_REALK, &
      0.000000000000000_REALK,      0.021102900779091_REALK,      0.000000000000000_REALK, &
     -0.005849970866389_REALK,      0.000000000000000_REALK,      0.006849322532212_REALK, &
      0.000000000000000_REALK,     -0.035869213599369_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.025429812458883_REALK,      0.000000000000000_REALK, &
     -0.002115355317831_REALK,      0.000000000000000_REALK,      0.002957208859242_REALK, &
      0.000000000000000_REALK,     -0.039250565997859_REALK,      0.000000000000000_REALK, &
     -0.005279135172062_REALK,      0.000000000000000_REALK,     -0.021264300540802_REALK, &
      0.000000000000000_REALK,      0.013312671721585_REALK,      0.000000000000000_REALK, &
     -0.008539929732845_REALK,      0.000000000000000_REALK,      0.011218515995036_REALK, &
     -0.015297011462974_REALK,      0.000000000000000_REALK,     -0.039431957954426_REALK, &
      0.000000000000000_REALK,      0.014568648700310_REALK,      0.000000000000000_REALK, &
      0.006620066846371_REALK,      0.000000000000000_REALK,      0.046323058935477_REALK, &
      0.000000000000000_REALK,      0.009351014599779_REALK,      0.000000000000000_REALK, &
     -0.000082465014575_REALK,      0.000000000000000_REALK,      0.007192966708802_REALK, &
      0.000000000000000_REALK,     -0.009990136851933_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.050854255800039_REALK,      0.000000000000000_REALK, &
     -0.001274299983803_REALK,      0.000000000000000_REALK,      0.004853245045203_REALK, &
      0.000000000000000_REALK,     -0.008944060667702_REALK,      0.000000000000000_REALK, &
      0.005145132637360_REALK,      0.000000000000000_REALK,      0.004080374979785_REALK, &
      0.000000000000000_REALK,     -0.010893221672749_REALK,      0.000000000000000_REALK, &
      0.013695796394657_REALK,      0.000000000000000_REALK,      0.008814517288817_REALK, &
     -0.035570354434305_REALK,      0.000000000000000_REALK,     -0.030656435253622_REALK, &
      0.000000000000000_REALK,      0.015915875131209_REALK,      0.000000000000000_REALK, &
     -0.007566184852614_REALK,      0.000000000000000_REALK,      0.035368414054710_REALK, &
      0.000000000000000_REALK,     -0.010328521050714_REALK,      0.000000000000000_REALK, &
      0.000217994041763_REALK,      0.000000000000000_REALK,     -0.005018481511223_REALK, &
      0.000000000000000_REALK,      0.002935623331748_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.014858604937646_REALK,      0.000000000000000_REALK, &
     -0.000490725744451_REALK,      0.000000000000000_REALK,      0.002110840284467_REALK, &
      0.000000000000000_REALK,     -0.032979573523158_REALK,      0.000000000000000_REALK, &
      0.006108324057257_REALK,      0.000000000000000_REALK,      0.011111868331373_REALK, &
      0.000000000000000_REALK,     -0.012044844513452_REALK,      0.000000000000000_REALK, &
      0.010906329229173_REALK,      0.000000000000000_REALK,      0.000769700421583_REALK, &
      0.002595086581287_REALK,      0.000000000000000_REALK,     -0.011241208979641_REALK, &
      0.000000000000000_REALK,      0.004243703079721_REALK,      0.000000000000000_REALK, &
      0.009000922724198_REALK,      0.000000000000000_REALK,      0.016707880660198_REALK, &
      0.000000000000000_REALK,     -0.008492509995878_REALK,      0.000000000000000_REALK, &
      0.003477751044967_REALK,      0.000000000000000_REALK,     -0.000636663863407_REALK, &
      0.000000000000000_REALK,      0.003180890356394_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.018724160040226_REALK,      0.000000000000000_REALK, &
     -0.006638426819059_REALK,      0.000000000000000_REALK,      0.002648563959537_REALK, &
      0.000000000000000_REALK,     -0.063094496503578_REALK,      0.000000000000000_REALK, &
      0.011677012524340_REALK,      0.000000000000000_REALK,      0.001864308857610_REALK, &
      0.000000000000000_REALK,     -0.011356717621936_REALK,      0.000000000000000_REALK, &
      0.020997293935124_REALK,      0.000000000000000_REALK,      0.009222977255273_REALK, &
      0.034772387665992_REALK,      0.000000000000000_REALK,     -0.001356159079254_REALK, &
      0.000000000000000_REALK,     -0.012613056357296_REALK,      0.000000000000000_REALK, &
      0.043415550998951_REALK,      0.000000000000000_REALK,      0.023833933147494_REALK, &
      0.000000000000000_REALK,     -0.023425842221251_REALK,      0.000000000000000_REALK, &
     -0.000455084746776_REALK,      0.000000000000000_REALK,      0.001611370157522_REALK, &
      0.000000000000000_REALK,     -0.023516264062842_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.036823412030567_REALK,      0.000000000000000_REALK, &
     -0.014295186239231_REALK,      0.000000000000000_REALK,     -0.019780279479973_REALK, &
      0.000000000000000_REALK,     -0.023150967107778_REALK,      0.000000000000000_REALK, &
      0.015945416550879_REALK,      0.000000000000000_REALK,      0.008072920334225_REALK, &
      0.000000000000000_REALK,     -0.004754383490738_REALK,      0.000000000000000_REALK, &
      0.006325219559315_REALK,      0.000000000000000_REALK,     -0.008643858047757_REALK, &
      0.018046627931874_REALK,      0.000000000000000_REALK,      0.006696471249631_REALK, &
      0.000000000000000_REALK,      0.000654407708540_REALK,      0.000000000000000_REALK, &
      0.000645831286340_REALK,      0.000000000000000_REALK,     -0.007773269328175_REALK, &
     -0.010365592249591_REALK,      0.000000000000000_REALK,     -0.086171350485957_REALK, &
      0.000000000000000_REALK,     -0.047192763497113_REALK,      0.000000000000000_REALK, &
      0.002512384828968_REALK,      0.000000000000000_REALK,      0.006061780355680_REALK, &
      0.009745126529295_REALK,      0.000000000000000_REALK,     -0.081471236744549_REALK, &
      0.000000000000000_REALK,     -0.035041533775220_REALK,      0.000000000000000_REALK, &
      0.023267280150663_REALK,      0.000000000000000_REALK,      0.038478924336137_REALK, &
      0.000000000000000_REALK,      0.085527623785164_REALK,      0.000000000000000_REALK, &
      0.036166462109865_REALK,      0.000000000000000_REALK,      0.060506717932020_REALK, &
      0.000000000000000_REALK,      0.012836683067796_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.135618600354551_REALK,      0.000000000000000_REALK, &
      0.077499390551736_REALK,      0.000000000000000_REALK,      0.050658279500191_REALK, &
      0.000000000000000_REALK,      0.029000611147269_REALK,      0.000000000000000_REALK, &
     -0.012110922825982_REALK,      0.000000000000000_REALK,     -0.040095848278745_REALK, &
      0.000000000000000_REALK,     -0.049261214824639_REALK,      0.000000000000000_REALK, &
     -0.047990498976768_REALK,      0.000000000000000_REALK,      0.004078774094689_REALK, &
     -0.073448437925246_REALK,      0.000000000000000_REALK,     -0.172321489549424_REALK, &
      0.000000000000000_REALK,     -0.111998615586695_REALK,      0.000000000000000_REALK, &
     -0.002451038342366_REALK,      0.000000000000000_REALK,      0.023681558930162_REALK, &
      0.000000000000000_REALK,      0.047381824659208_REALK,      0.000000000000000_REALK, &
      0.033120040708685_REALK,      0.000000000000000_REALK,      0.044360412935851_REALK, &
      0.000000000000000_REALK,      0.025763066165213_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.073523502895498_REALK,      0.000000000000000_REALK, &
      0.046018009750740_REALK,      0.000000000000000_REALK,      0.225224586700609_REALK, &
      0.000000000000000_REALK,      0.052586763588152_REALK,      0.000000000000000_REALK, &
     -0.016719639636778_REALK,      0.000000000000000_REALK,     -0.059037327320772_REALK, &
      0.000000000000000_REALK,      0.005517925616446_REALK,      0.000000000000000_REALK, &
      0.027073229034179_REALK,      0.000000000000000_REALK,      0.008502473843371_REALK, &
     -0.122153006663856_REALK,      0.000000000000000_REALK,     -0.230883824471580_REALK, &
      0.000000000000000_REALK,      0.031846805619551_REALK,      0.000000000000000_REALK, &
     -0.106925772580311_REALK,      0.000000000000000_REALK,     -0.008374764442545_REALK, &
      0.000000000000000_REALK,     -0.028174112980901_REALK,      0.000000000000000_REALK, &
     -0.014686868925539_REALK,      0.000000000000000_REALK,     -0.045553231091519_REALK, &
      0.000000000000000_REALK,     -0.031002367206200_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.052888395335461_REALK,      0.000000000000000_REALK, &
      0.012941573531490_REALK,      0.000000000000000_REALK,     -0.126826519021442_REALK, &
      0.000000000000000_REALK,     -0.133384774779824_REALK,      0.000000000000000_REALK, &
     -0.004526443230080_REALK,      0.000000000000000_REALK,     -0.022176635869309_REALK, &
      0.000000000000000_REALK,      0.029616070717895_REALK,      0.000000000000000_REALK, &
      0.027078425085755_REALK,      0.000000000000000_REALK,      0.005025025502232_REALK, &
     -0.002774146740636_REALK,      0.000000000000000_REALK,     -0.132151329865625_REALK, &
      0.000000000000000_REALK,      0.050014556359021_REALK,      0.000000000000000_REALK, &
     -0.007816726898932_REALK,      0.000000000000000_REALK,      0.020112266848576_REALK, &
      0.000000000000000_REALK,     -0.016007222519044_REALK,      0.000000000000000_REALK, &
      0.013914336773816_REALK,      0.000000000000000_REALK,     -0.001829247129679_REALK, &
      0.000000000000000_REALK,     -0.035108988195826_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.015364621997673_REALK,      0.000000000000000_REALK, &
      0.084203333960426_REALK,      0.000000000000000_REALK,     -0.018315431393999_REALK, &
      0.000000000000000_REALK,     -0.222398607403916_REALK,      0.000000000000000_REALK, &
     -0.006676420191774_REALK,      0.000000000000000_REALK,     -0.076900353635485_REALK, &
      0.000000000000000_REALK,     -0.020154231677519_REALK,      0.000000000000000_REALK, &
      0.072055643288155_REALK,      0.000000000000000_REALK,      0.019078005841828_REALK, &
      0.016237188549170_REALK,      0.000000000000000_REALK,     -0.233548719023684_REALK, &
      0.000000000000000_REALK,     -0.010865318104657_REALK,      0.000000000000000_REALK, &
      0.193619012473310_REALK,      0.000000000000000_REALK,      0.010604908056490_REALK, &
      0.000000000000000_REALK,      0.016088422617419_REALK,      0.000000000000000_REALK, &
      0.097395107670763_REALK,      0.000000000000000_REALK,     -0.072852424443887_REALK, &
      0.000000000000000_REALK,     -0.051078947491367_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.135604766999758_REALK,      0.000000000000000_REALK, &
      0.101914339341968_REALK,      0.000000000000000_REALK,     -0.132619183862840_REALK, &
      0.000000000000000_REALK,     -0.110610929755833_REALK,      0.000000000000000_REALK, &
      0.020687534546287_REALK,      0.000000000000000_REALK,      0.006239787129691_REALK, &
      0.000000000000000_REALK,      0.031393097582813_REALK,      0.000000000000000_REALK, &
      0.059080492450680_REALK,      0.000000000000000_REALK,      0.022033496535252_REALK, &
      0.024685917060899_REALK,      0.000000000000000_REALK,      0.042261671331515_REALK, &
      0.000000000000000_REALK,      0.061946896880730_REALK,      0.000000000000000_REALK, &
      0.056734432827403_REALK,      0.000000000000000_REALK,      0.010647208164075_REALK/
  ! results of test 7, ket-major order, 02ODGZZZ
  data REF_CONTR_INTS(20197:20592) /                                                       &
      0.000000000000000_REALK,      0.012447018458740_REALK,      0.000000000000000_REALK, &
      0.001847881222179_REALK,      0.000000000000000_REALK,     -0.000146024384496_REALK, &
      0.000000000000000_REALK,     -0.017602288888204_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.010392151603831_REALK,      0.000000000000000_REALK, &
      0.007926983634371_REALK,      0.000000000000000_REALK,      0.001420092224529_REALK, &
      0.000000000000000_REALK,     -0.002018376461405_REALK,      0.000000000000000_REALK, &
     -0.017425438700171_REALK,      0.000000000000000_REALK,     -0.028694664215270_REALK, &
      0.000000000000000_REALK,      0.009880327654071_REALK,      0.000000000000000_REALK, &
      0.002447482208450_REALK,      0.000000000000000_REALK,      0.023055408672099_REALK, &
     -0.035867609471796_REALK,      0.000000000000000_REALK,     -0.020039266933812_REALK, &
      0.000000000000000_REALK,     -0.007531989208119_REALK,      0.000000000000000_REALK, &
     -0.007372286915801_REALK,      0.000000000000000_REALK,      0.013645561096804_REALK, &
      0.000000000000000_REALK,      0.036089725109341_REALK,      0.000000000000000_REALK, &
      0.007950590578386_REALK,      0.000000000000000_REALK,      0.007916055029197_REALK, &
      0.000000000000000_REALK,      0.002398577926438_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.059811719818778_REALK,      0.000000000000000_REALK, &
      0.030722886688136_REALK,      0.000000000000000_REALK,      0.034927398855438_REALK, &
      0.000000000000000_REALK,      0.047403943210956_REALK,      0.000000000000000_REALK, &
     -0.007990507134693_REALK,      0.000000000000000_REALK,     -0.014759404500260_REALK, &
      0.000000000000000_REALK,      0.009881322483166_REALK,      0.000000000000000_REALK, &
     -0.010289135239102_REALK,      0.000000000000000_REALK,      0.005422623272369_REALK, &
     -0.040228820182749_REALK,      0.000000000000000_REALK,     -0.002923385632826_REALK, &
      0.000000000000000_REALK,      0.000715400986059_REALK,      0.000000000000000_REALK, &
     -0.066025369652282_REALK,      0.000000000000000_REALK,     -0.038687938680427_REALK, &
      0.000000000000000_REALK,     -0.000722575631738_REALK,      0.000000000000000_REALK, &
     -0.004507565497587_REALK,      0.000000000000000_REALK,     -0.001334366909223_REALK, &
      0.000000000000000_REALK,     -0.016689415661971_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.036350630465623_REALK,      0.000000000000000_REALK, &
      0.001763529619676_REALK,      0.000000000000000_REALK,      0.003764403805485_REALK, &
      0.000000000000000_REALK,      0.044522059094015_REALK,      0.000000000000000_REALK, &
      0.007367197070225_REALK,      0.000000000000000_REALK,      0.015809175226251_REALK, &
      0.000000000000000_REALK,     -0.011653682301566_REALK,      0.000000000000000_REALK, &
      0.008705069329117_REALK,      0.000000000000000_REALK,     -0.004401042062743_REALK, &
     -0.018660473068818_REALK,      0.000000000000000_REALK,     -0.009906288766994_REALK, &
      0.000000000000000_REALK,      0.002732205343088_REALK,      0.000000000000000_REALK, &
      0.009087581728638_REALK,      0.000000000000000_REALK,      0.025291748877755_REALK, &
      0.000000000000000_REALK,     -0.008733829823308_REALK,      0.000000000000000_REALK, &
     -0.001334366909223_REALK,      0.000000000000000_REALK,     -0.000562878508978_REALK, &
      0.000000000000000_REALK,     -0.000644130940302_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.058907190118582_REALK,      0.000000000000000_REALK, &
      0.003764403805485_REALK,      0.000000000000000_REALK,      0.005246303955374_REALK, &
      0.000000000000000_REALK,     -0.009755306069789_REALK,      0.000000000000000_REALK, &
      0.002853629295970_REALK,      0.000000000000000_REALK,     -0.010289135239102_REALK, &
      0.000000000000000_REALK,      0.004577248009907_REALK,      0.000000000000000_REALK, &
      0.002306130983877_REALK,      0.000000000000000_REALK,      0.005502037832349_REALK, &
     -0.019530158999513_REALK,      0.000000000000000_REALK,     -0.066025369652282_REALK, &
      0.000000000000000_REALK,      0.018571681798818_REALK,      0.000000000000000_REALK, &
      0.020303401975333_REALK,      0.000000000000000_REALK,      0.055891179293114_REALK, &
      0.000000000000000_REALK,      0.002398577926438_REALK,      0.000000000000000_REALK, &
     -0.004926486670362_REALK,      0.000000000000000_REALK,     -0.003791679836228_REALK, &
      0.000000000000000_REALK,     -0.046041272189080_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.047403943210956_REALK,      0.000000000000000_REALK, &
      0.013053652220618_REALK,      0.000000000000000_REALK,     -0.008216402740026_REALK, &
      0.000000000000000_REALK,     -0.063556567839817_REALK,      0.000000000000000_REALK, &
      0.023055408672099_REALK,      0.000000000000000_REALK,     -0.002669696164600_REALK, &
      0.000000000000000_REALK,      0.000150490839356_REALK,      0.000000000000000_REALK, &
      0.028959988890991_REALK,      0.000000000000000_REALK,      0.018223627597830_REALK, &
      0.013645561096804_REALK,      0.000000000000000_REALK,     -0.018772162398569_REALK, &
      0.000000000000000_REALK,      0.011361167753740_REALK,      0.000000000000000_REALK, &
      0.027890938696430_REALK,      0.000000000000000_REALK,      0.023637598329155_REALK, &
      0.000000000000000_REALK,     -0.016471992489169_REALK,      0.000000000000000_REALK, &
     -0.006125923736107_REALK,      0.000000000000000_REALK,     -0.005637984998496_REALK, &
      0.000000000000000_REALK,     -0.013896394775758_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.006341013067923_REALK,      0.000000000000000_REALK, &
      0.002162805069834_REALK,      0.000000000000000_REALK,     -0.003533674906048_REALK, &
      0.000000000000000_REALK,     -0.007834552578684_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.071010570215406_REALK,      0.000000000000000_REALK, &
      0.094106274110859_REALK,      0.000000000000000_REALK,      0.014794409799736_REALK, &
      0.000000000000000_REALK,     -0.015716131955181_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.093363214068738_REALK,      0.000000000000000_REALK, &
      0.101056340158098_REALK,      0.000000000000000_REALK,      0.013451936356328_REALK, &
      0.000000000000000_REALK,     -0.021738808154414_REALK,      0.000000000000000_REALK, &
     -0.040165341468434_REALK,      0.000000000000000_REALK,     -0.109376439285287_REALK, &
      0.000000000000000_REALK,     -0.105180849019373_REALK,      0.000000000000000_REALK, &
     -0.073235377704397_REALK,      0.000000000000000_REALK,      0.016129737770908_REALK, &
     -0.085403497111557_REALK,      0.000000000000000_REALK,     -0.165029469404201_REALK, &
      0.000000000000000_REALK,     -0.277075667890734_REALK,      0.000000000000000_REALK, &
     -0.265850046507789_REALK,      0.000000000000000_REALK,      0.025487485564137_REALK, &
      0.000000000000000_REALK,      0.059876408533894_REALK,      0.000000000000000_REALK, &
      0.041757982802485_REALK,      0.000000000000000_REALK,      0.117106030934821_REALK, &
      0.000000000000000_REALK,      0.040862881694029_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.304974482962999_REALK,      0.000000000000000_REALK, &
     -0.026788692247305_REALK,      0.000000000000000_REALK,      0.242078514882833_REALK, &
      0.000000000000000_REALK,      0.262612031877162_REALK,      0.000000000000000_REALK, &
     -0.014227350569352_REALK,      0.000000000000000_REALK,     -0.058139133334269_REALK, &
      0.000000000000000_REALK,      0.008759015529327_REALK,      0.000000000000000_REALK, &
     -0.046477422178506_REALK,      0.000000000000000_REALK,     -0.009778065440586_REALK, &
     -0.075797771668567_REALK,      0.000000000000000_REALK,      0.195594487013173_REALK, &
      0.000000000000000_REALK,     -0.234102274975789_REALK,      0.000000000000000_REALK, &
     -0.396154433357833_REALK,      0.000000000000000_REALK,     -0.099257123403696_REALK, &
      0.000000000000000_REALK,      0.037127141713104_REALK,      0.000000000000000_REALK, &
      0.029250288938049_REALK,      0.000000000000000_REALK,     -0.019868896161985_REALK, &
      0.000000000000000_REALK,     -0.018675827828491_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.097332633161123_REALK,      0.000000000000000_REALK, &
      0.079197722026596_REALK,      0.000000000000000_REALK,      0.149758290909173_REALK, &
      0.000000000000000_REALK,      0.249613381226246_REALK,      0.000000000000000_REALK, &
      0.005031598708691_REALK,      0.000000000000000_REALK,      0.045440622530192_REALK, &
      0.000000000000000_REALK,      0.002661321643491_REALK,      0.000000000000000_REALK, &
      0.037827042161953_REALK,      0.000000000000000_REALK,      0.007075119434683_REALK, &
     -0.088734260870213_REALK,      0.000000000000000_REALK,     -0.185408319203054_REALK, &
      0.000000000000000_REALK,      0.153185197856850_REALK,      0.000000000000000_REALK, &
      0.023914550581594_REALK,      0.000000000000000_REALK,      0.054690969304042_REALK, &
      0.000000000000000_REALK,      0.025598346121776_REALK,      0.000000000000000_REALK, &
     -0.019868896161985_REALK,      0.000000000000000_REALK,     -0.040569400578696_REALK, &
      0.000000000000000_REALK,     -0.011702571644019_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.175468774789195_REALK,      0.000000000000000_REALK, &
      0.149758290909173_REALK,      0.000000000000000_REALK,      0.205692989859970_REALK, &
      0.000000000000000_REALK,     -0.000017898715517_REALK,      0.000000000000000_REALK, &
      0.005156411300706_REALK,      0.000000000000000_REALK,     -0.046477422178506_REALK, &
      0.000000000000000_REALK,      0.004909836970210_REALK,      0.000000000000000_REALK, &
      0.022279692642561_REALK,      0.000000000000000_REALK,      0.019088063752933_REALK, &
     -0.089841226753691_REALK,      0.000000000000000_REALK,     -0.396154433357833_REALK, &
      0.000000000000000_REALK,     -0.069226317016036_REALK,      0.000000000000000_REALK, &
      0.101280979144649_REALK,      0.000000000000000_REALK,      0.122386486737628_REALK, &
      0.000000000000000_REALK,      0.040862881694029_REALK,      0.000000000000000_REALK, &
      0.121894287026669_REALK,      0.000000000000000_REALK,     -0.014148766652173_REALK, &
      0.000000000000000_REALK,     -0.082562771365583_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.262612031877162_REALK,      0.000000000000000_REALK, &
      0.476474604248707_REALK,      0.000000000000000_REALK,      0.016243564451482_REALK, &
      0.000000000000000_REALK,     -0.123673864106347_REALK,      0.000000000000000_REALK, &
      0.016129737770908_REALK,      0.000000000000000_REALK,     -0.108199580477668_REALK, &
      0.000000000000000_REALK,      0.064403165115940_REALK,      0.000000000000000_REALK, &
      0.150662177816274_REALK,      0.000000000000000_REALK,      0.026101849195739_REALK, &
      0.025487485564137_REALK,      0.000000000000000_REALK,     -0.165828197289898_REALK, &
      0.000000000000000_REALK,      0.041776366436132_REALK,      0.000000000000000_REALK, &
      0.199975140390118_REALK,      0.000000000000000_REALK,      0.110680737602825_REALK, &
      0.000000000000000_REALK,     -0.045614866677575_REALK,      0.000000000000000_REALK, &
      0.053754022057477_REALK,      0.000000000000000_REALK,     -0.048101836902694_REALK, &
      0.000000000000000_REALK,     -0.054975141323914_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.018431855443600_REALK,      0.000000000000000_REALK, &
      0.128706722514128_REALK,      0.000000000000000_REALK,     -0.049118062162041_REALK, &
      0.000000000000000_REALK,     -0.061160342399080_REALK,      0.000000000000000_REALK/
  ! results of test 7, ket-major order, 03ODGXXX
  data REF_CONTR_INTS(20593:20988) /                                                       &
      0.000000000000000_REALK,     -0.070605239630551_REALK,      0.000000000000000_REALK, &
     -0.083160921180356_REALK,      0.000000000000000_REALK,     -0.021263511377143_REALK, &
      0.000000000000000_REALK,     -0.154073577045885_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.016857502335193_REALK,      0.000000000000000_REALK, &
      0.016212481549831_REALK,      0.000000000000000_REALK,     -0.004016798589927_REALK, &
      0.000000000000000_REALK,     -0.054944098229806_REALK,      0.000000000000000_REALK, &
     -0.076359128403249_REALK,      0.000000000000000_REALK,     -0.157303509307560_REALK, &
      0.000000000000000_REALK,      0.115383888169764_REALK,      0.000000000000000_REALK, &
      0.102565043868377_REALK,      0.000000000000000_REALK,     -0.073926973498155_REALK, &
      0.012351324591592_REALK,      0.000000000000000_REALK,     -0.076510676143896_REALK, &
      0.000000000000000_REALK,      0.028322493124220_REALK,      0.000000000000000_REALK, &
      0.011418318332704_REALK,      0.000000000000000_REALK,     -0.041145534361829_REALK, &
      0.000000000000000_REALK,     -0.056446502420232_REALK,      0.000000000000000_REALK, &
      0.167225689551561_REALK,      0.000000000000000_REALK,      0.127219637692473_REALK, &
      0.000000000000000_REALK,      0.144654281717422_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.042688875973331_REALK,      0.000000000000000_REALK, &
      0.041888795402147_REALK,      0.000000000000000_REALK,      0.056494226895037_REALK, &
      0.000000000000000_REALK,      0.024568656205285_REALK,      0.000000000000000_REALK, &
      0.009528783172840_REALK,      0.000000000000000_REALK,      0.179472334523252_REALK, &
      0.000000000000000_REALK,     -0.155823890651925_REALK,      0.000000000000000_REALK, &
     -0.008088905511311_REALK,      0.000000000000000_REALK,      0.035993135211120_REALK, &
     -0.007492959695770_REALK,      0.000000000000000_REALK,      0.061455627413453_REALK, &
      0.000000000000000_REALK,     -0.050582280463365_REALK,      0.000000000000000_REALK, &
      0.023713215160014_REALK,      0.000000000000000_REALK,      0.010485825177445_REALK, &
      0.000000000000000_REALK,      0.045896824081501_REALK,      0.000000000000000_REALK, &
     -0.084515100529627_REALK,      0.000000000000000_REALK,     -0.092841647894211_REALK, &
      0.000000000000000_REALK,     -0.039323947315054_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.016392277488187_REALK,      0.000000000000000_REALK, &
     -0.021785527894875_REALK,      0.000000000000000_REALK,     -0.036650919211943_REALK, &
      0.000000000000000_REALK,     -0.002153999699047_REALK,      0.000000000000000_REALK, &
     -0.044493843889015_REALK,      0.000000000000000_REALK,     -0.177397546532505_REALK, &
      0.000000000000000_REALK,      0.183042566914705_REALK,      0.000000000000000_REALK, &
      0.075311289818649_REALK,      0.000000000000000_REALK,     -0.003787844555874_REALK, &
     -0.022047186424197_REALK,      0.000000000000000_REALK,     -0.092027777565733_REALK, &
      0.000000000000000_REALK,      0.129145817650679_REALK,      0.000000000000000_REALK, &
      0.087231234584450_REALK,      0.000000000000000_REALK,      0.019914861827264_REALK, &
      0.000000000000000_REALK,     -0.013695094939181_REALK,      0.000000000000000_REALK, &
     -0.256095032153934_REALK,      0.000000000000000_REALK,     -0.155478731108493_REALK, &
      0.000000000000000_REALK,     -0.164098829736786_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.061399749711495_REALK,      0.000000000000000_REALK, &
     -0.208575623512567_REALK,      0.000000000000000_REALK,     -0.096650517431293_REALK, &
      0.000000000000000_REALK,     -0.075772207346623_REALK,      0.000000000000000_REALK, &
      0.083945882457302_REALK,      0.000000000000000_REALK,      0.145602672162298_REALK, &
      0.000000000000000_REALK,     -0.153606847827689_REALK,      0.000000000000000_REALK, &
     -0.148824222560339_REALK,      0.000000000000000_REALK,     -0.001658800534756_REALK, &
      0.037313744118627_REALK,      0.000000000000000_REALK,      0.106249447793351_REALK, &
      0.000000000000000_REALK,     -0.146429781432360_REALK,      0.000000000000000_REALK, &
     -0.142664972984523_REALK,      0.000000000000000_REALK,     -0.024527658201787_REALK, &
      0.000000000000000_REALK,      0.118768163559875_REALK,      0.000000000000000_REALK, &
      0.126692002298652_REALK,      0.000000000000000_REALK,     -0.002357616328388_REALK, &
      0.000000000000000_REALK,      0.126282620852101_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.083391977405614_REALK,      0.000000000000000_REALK, &
      0.157026372102147_REALK,      0.000000000000000_REALK,      0.027125809739787_REALK, &
      0.000000000000000_REALK,      0.093164808891135_REALK,      0.000000000000000_REALK, &
     -0.108898653747788_REALK,      0.000000000000000_REALK,      0.032029428066752_REALK, &
      0.000000000000000_REALK,      0.016259186177713_REALK,      0.000000000000000_REALK, &
      0.131265963678821_REALK,      0.000000000000000_REALK,      0.059058827333064_REALK, &
     -0.059499885743554_REALK,      0.000000000000000_REALK,     -0.039525010181094_REALK, &
      0.000000000000000_REALK,      0.083161465750555_REALK,      0.000000000000000_REALK, &
      0.143072531166192_REALK,      0.000000000000000_REALK,      0.020504217751801_REALK, &
      0.000000000000000_REALK,     -0.133064224408848_REALK,      0.000000000000000_REALK, &
     -0.037602233885794_REALK,      0.000000000000000_REALK,      0.015631528110348_REALK, &
      0.000000000000000_REALK,      0.022421229840106_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.110544661979461_REALK,      0.000000000000000_REALK, &
     -0.077778322695471_REALK,      0.000000000000000_REALK,     -0.013149185589320_REALK, &
      0.000000000000000_REALK,     -0.042660050274615_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.142919023750667_REALK,      0.000000000000000_REALK, &
      0.069312832721939_REALK,      0.000000000000000_REALK,     -0.083816273586057_REALK, &
      0.000000000000000_REALK,      0.085986507640847_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.177301506262503_REALK,      0.000000000000000_REALK, &
      0.401309923857960_REALK,      0.000000000000000_REALK,     -0.115193843708542_REALK, &
      0.000000000000000_REALK,      0.002014756519113_REALK,      0.000000000000000_REALK, &
     -0.042864528972300_REALK,      0.000000000000000_REALK,      0.017353476487950_REALK, &
      0.000000000000000_REALK,      0.042843991881421_REALK,      0.000000000000000_REALK, &
      0.269315690648697_REALK,      0.000000000000000_REALK,     -0.017873520942794_REALK, &
     -0.034436564731069_REALK,      0.000000000000000_REALK,      0.006996207449579_REALK, &
      0.000000000000000_REALK,     -0.249089208042111_REALK,      0.000000000000000_REALK, &
     -0.046740952934457_REALK,      0.000000000000000_REALK,     -0.224902568003497_REALK, &
      0.000000000000000_REALK,      0.083794741858515_REALK,      0.000000000000000_REALK, &
      0.236019081367192_REALK,      0.000000000000000_REALK,      0.027219286269776_REALK, &
      0.000000000000000_REALK,      0.064613958565367_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.221460942851634_REALK,      0.000000000000000_REALK, &
     -0.002800546300683_REALK,      0.000000000000000_REALK,      0.051452979787260_REALK, &
      0.000000000000000_REALK,      0.019608661702311_REALK,      0.000000000000000_REALK, &
     -0.001248801263486_REALK,      0.000000000000000_REALK,      0.099350539685189_REALK, &
      0.000000000000000_REALK,     -0.118756799301110_REALK,      0.000000000000000_REALK, &
     -0.172500539834043_REALK,      0.000000000000000_REALK,      0.001940184324124_REALK, &
      0.031788186419989_REALK,      0.000000000000000_REALK,      0.016963556735821_REALK, &
      0.000000000000000_REALK,      0.048352111045797_REALK,      0.000000000000000_REALK, &
      0.083935634306224_REALK,      0.000000000000000_REALK,      0.082808633165248_REALK, &
      0.000000000000000_REALK,     -0.034495772403487_REALK,      0.000000000000000_REALK, &
     -0.151645136417427_REALK,      0.000000000000000_REALK,     -0.108544824468941_REALK, &
      0.000000000000000_REALK,      0.004351977777259_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.061060350390178_REALK,      0.000000000000000_REALK, &
     -0.035052521692248_REALK,      0.000000000000000_REALK,     -0.098361947573234_REALK, &
      0.000000000000000_REALK,     -0.001176179443611_REALK,      0.000000000000000_REALK, &
      0.099435051651830_REALK,      0.000000000000000_REALK,      0.037725136151110_REALK, &
      0.000000000000000_REALK,      0.470041246992694_REALK,      0.000000000000000_REALK, &
      0.542448128538268_REALK,      0.000000000000000_REALK,      0.130510097192647_REALK, &
      0.142274986840662_REALK,      0.000000000000000_REALK,      0.218964667802243_REALK, &
      0.000000000000000_REALK,      0.684654762641621_REALK,      0.000000000000000_REALK, &
      0.717032700596683_REALK,      0.000000000000000_REALK,      0.118350966904119_REALK, &
      0.000000000000000_REALK,     -0.491603494954881_REALK,      0.000000000000000_REALK, &
     -0.910519546880820_REALK,      0.000000000000000_REALK,     -0.018778852685726_REALK, &
      0.000000000000000_REALK,      0.163247988469885_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.534705110597771_REALK,      0.000000000000000_REALK, &
     -1.346318292756306_REALK,      0.000000000000000_REALK,      0.058999209901730_REALK, &
      0.000000000000000_REALK,      0.341037096969156_REALK,      0.000000000000000_REALK, &
     -0.138542284715149_REALK,      0.000000000000000_REALK,     -0.102112849714142_REALK, &
      0.000000000000000_REALK,     -0.530930183034223_REALK,      0.000000000000000_REALK, &
     -0.779523131405848_REALK,      0.000000000000000_REALK,     -0.199437400663274_REALK, &
     -0.196128131481846_REALK,      0.000000000000000_REALK,     -0.257844604422406_REALK, &
      0.000000000000000_REALK,     -0.836440058355178_REALK,      0.000000000000000_REALK, &
     -1.017569163617629_REALK,      0.000000000000000_REALK,     -0.179559062256559_REALK, &
      0.000000000000000_REALK,      0.513848367484094_REALK,      0.000000000000000_REALK, &
      0.614465686401317_REALK,      0.000000000000000_REALK,     -0.108623434667648_REALK, &
      0.000000000000000_REALK,     -0.145984912494541_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.538703682333787_REALK,      0.000000000000000_REALK, &
      0.991467936221935_REALK,      0.000000000000000_REALK,     -0.199219356160007_REALK, &
      0.000000000000000_REALK,     -0.258596542038869_REALK,      0.000000000000000_REALK, &
      0.089621117699572_REALK,      0.000000000000000_REALK,      0.190063351746048_REALK, &
      0.000000000000000_REALK,      0.451323492135446_REALK,      0.000000000000000_REALK, &
      0.429344699822630_REALK,      0.000000000000000_REALK,      0.275094305007067_REALK, &
      0.134996964150851_REALK,      0.000000000000000_REALK,      0.303070214616770_REALK, &
      0.000000000000000_REALK,      0.677093024095495_REALK,      0.000000000000000_REALK, &
      0.700583107122811_REALK,      0.000000000000000_REALK,      0.193257177139798_REALK, &
      0.000000000000000_REALK,     -0.257524254640890_REALK,      0.000000000000000_REALK, &
     -0.363397452503676_REALK,      0.000000000000000_REALK,      0.046941191566861_REALK, &
      0.000000000000000_REALK,      0.218211344388892_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.339264934478338_REALK,      0.000000000000000_REALK, &
     -0.375900699793831_REALK,      0.000000000000000_REALK,      0.090716888940051_REALK, &
      0.000000000000000_REALK,      0.340788825232097_REALK,      0.000000000000000_REALK/
  ! results of test 7, ket-major order, 03ODGXXY
  data REF_CONTR_INTS(20989:21384) /                                                       &
      0.000000000000000_REALK,     -0.032680599739854_REALK,      0.000000000000000_REALK, &
     -0.005980837986484_REALK,      0.000000000000000_REALK,      0.016555294798267_REALK, &
      0.000000000000000_REALK,     -0.047095740947544_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.042106247139880_REALK,      0.000000000000000_REALK, &
     -0.031743738968047_REALK,      0.000000000000000_REALK,      0.002541806222761_REALK, &
      0.000000000000000_REALK,     -0.046983882254106_REALK,      0.000000000000000_REALK, &
     -0.019949846499183_REALK,      0.000000000000000_REALK,     -0.032180264765095_REALK, &
      0.000000000000000_REALK,      0.009688045311757_REALK,      0.000000000000000_REALK, &
      0.037723449096438_REALK,      0.000000000000000_REALK,     -0.026356409560787_REALK, &
     -0.027146712381369_REALK,      0.000000000000000_REALK,     -0.038963854989801_REALK, &
      0.000000000000000_REALK,      0.033488917351561_REALK,      0.000000000000000_REALK, &
      0.054855196395185_REALK,      0.000000000000000_REALK,      0.000912188363213_REALK, &
      0.000000000000000_REALK,     -0.037145567322226_REALK,      0.000000000000000_REALK, &
      0.044075074408443_REALK,      0.000000000000000_REALK,      0.043363573917464_REALK, &
      0.000000000000000_REALK,      0.031608547550751_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.005749198789458_REALK,      0.000000000000000_REALK, &
      0.055899568915469_REALK,      0.000000000000000_REALK,      0.030770329288539_REALK, &
      0.000000000000000_REALK,      0.029717079188265_REALK,      0.000000000000000_REALK, &
     -0.012355924040770_REALK,      0.000000000000000_REALK,      0.070834969162128_REALK, &
      0.000000000000000_REALK,     -0.068392664829511_REALK,      0.000000000000000_REALK, &
      0.034856246952076_REALK,      0.000000000000000_REALK,      0.006307649116698_REALK, &
      0.006911216861869_REALK,      0.000000000000000_REALK,      0.038568449328013_REALK, &
      0.000000000000000_REALK,     -0.047217263973524_REALK,      0.000000000000000_REALK, &
     -0.004116229861361_REALK,      0.000000000000000_REALK,     -0.005652763861393_REALK, &
      0.000000000000000_REALK,      0.031972470936451_REALK,      0.000000000000000_REALK, &
     -0.029586767487600_REALK,      0.000000000000000_REALK,     -0.058157525952495_REALK, &
      0.000000000000000_REALK,      0.007943128836318_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000390853740412_REALK,      0.000000000000000_REALK, &
     -0.024928346959374_REALK,      0.000000000000000_REALK,     -0.034270331810360_REALK, &
      0.000000000000000_REALK,      0.000837149588659_REALK,      0.000000000000000_REALK, &
      0.011917160928956_REALK,      0.000000000000000_REALK,     -0.047485125578261_REALK, &
      0.000000000000000_REALK,      0.046189985554812_REALK,      0.000000000000000_REALK, &
     -0.033288103457728_REALK,      0.000000000000000_REALK,     -0.006329907935778_REALK, &
      0.007439979625722_REALK,      0.000000000000000_REALK,     -0.006780142454947_REALK, &
      0.000000000000000_REALK,      0.002500009813460_REALK,      0.000000000000000_REALK, &
     -0.037058516059815_REALK,      0.000000000000000_REALK,     -0.006744304391933_REALK, &
      0.000000000000000_REALK,      0.040480666218684_REALK,      0.000000000000000_REALK, &
     -0.027671593094105_REALK,      0.000000000000000_REALK,     -0.052077893279171_REALK, &
      0.000000000000000_REALK,     -0.003576350996188_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.027509810190593_REALK,      0.000000000000000_REALK, &
      0.022901749543813_REALK,      0.000000000000000_REALK,     -0.013321426833497_REALK, &
      0.000000000000000_REALK,      0.013877934470564_REALK,      0.000000000000000_REALK, &
     -0.000624836460528_REALK,      0.000000000000000_REALK,      0.011760870436812_REALK, &
      0.000000000000000_REALK,      0.004547651549119_REALK,      0.000000000000000_REALK, &
     -0.011739316431827_REALK,      0.000000000000000_REALK,      0.015894934147938_REALK, &
     -0.008312428869166_REALK,      0.000000000000000_REALK,     -0.008669783236022_REALK, &
      0.000000000000000_REALK,      0.029465927471421_REALK,      0.000000000000000_REALK, &
      0.015506926689922_REALK,      0.000000000000000_REALK,      0.013399778360587_REALK, &
      0.000000000000000_REALK,      0.029026350449695_REALK,      0.000000000000000_REALK, &
     -0.023960948939236_REALK,      0.000000000000000_REALK,     -0.051637467897441_REALK, &
      0.000000000000000_REALK,      0.020954991298519_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.003421981071814_REALK,      0.000000000000000_REALK, &
     -0.037060833567683_REALK,      0.000000000000000_REALK,     -0.033969996807629_REALK, &
      0.000000000000000_REALK,     -0.004990049068520_REALK,      0.000000000000000_REALK, &
     -0.016459581786505_REALK,      0.000000000000000_REALK,      0.060024558010344_REALK, &
      0.000000000000000_REALK,     -0.049513150605533_REALK,      0.000000000000000_REALK, &
      0.024208720822396_REALK,      0.000000000000000_REALK,      0.012463615484646_REALK, &
     -0.005510994223765_REALK,      0.000000000000000_REALK,      0.044543451641541_REALK, &
      0.000000000000000_REALK,     -0.040010190220418_REALK,      0.000000000000000_REALK, &
      0.006044150346630_REALK,      0.000000000000000_REALK,      0.002187313737128_REALK, &
      0.000000000000000_REALK,     -0.033046443950947_REALK,      0.000000000000000_REALK, &
      0.022656730586696_REALK,      0.000000000000000_REALK,      0.009837976889030_REALK, &
      0.000000000000000_REALK,      0.039326886652541_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.012941541156975_REALK,      0.000000000000000_REALK, &
      0.009128488013763_REALK,      0.000000000000000_REALK,      0.001095283657068_REALK, &
      0.000000000000000_REALK,      0.023331497932858_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.007110116426512_REALK,      0.000000000000000_REALK, &
      0.081280280853400_REALK,      0.000000000000000_REALK,     -0.072227881662533_REALK, &
      0.000000000000000_REALK,     -0.017696586255066_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.104986902445723_REALK,      0.000000000000000_REALK, &
     -0.015666612832831_REALK,      0.000000000000000_REALK,     -0.061776506601644_REALK, &
      0.000000000000000_REALK,      0.007171688714078_REALK,      0.000000000000000_REALK, &
     -0.001117802020187_REALK,      0.000000000000000_REALK,     -0.058549924832854_REALK, &
      0.000000000000000_REALK,     -0.074812997885468_REALK,      0.000000000000000_REALK, &
      0.075411421028800_REALK,      0.000000000000000_REALK,     -0.015648715323207_REALK, &
     -0.011673901659685_REALK,      0.000000000000000_REALK,     -0.064133731173149_REALK, &
      0.000000000000000_REALK,      0.032400818159770_REALK,      0.000000000000000_REALK, &
      0.202505503652101_REALK,      0.000000000000000_REALK,      0.104444067959851_REALK, &
      0.000000000000000_REALK,     -0.056932547275225_REALK,      0.000000000000000_REALK, &
      0.034009295006358_REALK,      0.000000000000000_REALK,     -0.005472595100876_REALK, &
      0.000000000000000_REALK,      0.034485555913268_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.082550793061520_REALK,      0.000000000000000_REALK, &
      0.225833502852174_REALK,      0.000000000000000_REALK,      0.020757140041169_REALK, &
      0.000000000000000_REALK,      0.026850030011973_REALK,      0.000000000000000_REALK, &
      0.006870426988339_REALK,      0.000000000000000_REALK,      0.024031520152527_REALK, &
      0.000000000000000_REALK,     -0.012682817204416_REALK,      0.000000000000000_REALK, &
      0.067765127131151_REALK,      0.000000000000000_REALK,     -0.002295393431095_REALK, &
     -0.005555803547765_REALK,      0.000000000000000_REALK,     -0.003809555212131_REALK, &
      0.000000000000000_REALK,     -0.097313513739207_REALK,      0.000000000000000_REALK, &
     -0.069432241023422_REALK,      0.000000000000000_REALK,     -0.048527859405657_REALK, &
      0.000000000000000_REALK,     -0.026388183472870_REALK,      0.000000000000000_REALK, &
     -0.002910405533632_REALK,      0.000000000000000_REALK,     -0.124383124846928_REALK, &
      0.000000000000000_REALK,      0.020389020863944_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.072064915132720_REALK,      0.000000000000000_REALK, &
     -0.057045098670942_REALK,      0.000000000000000_REALK,     -0.138491776221955_REALK, &
      0.000000000000000_REALK,      0.004641005266587_REALK,      0.000000000000000_REALK, &
     -0.015660263374383_REALK,      0.000000000000000_REALK,      0.002237995784015_REALK, &
      0.000000000000000_REALK,      0.025569716295342_REALK,      0.000000000000000_REALK, &
     -0.078586171062960_REALK,      0.000000000000000_REALK,     -0.025167911917222_REALK, &
     -0.036218353111958_REALK,      0.000000000000000_REALK,      0.024330807253634_REALK, &
      0.000000000000000_REALK,     -0.066395434789280_REALK,      0.000000000000000_REALK, &
     -0.182002929221866_REALK,      0.000000000000000_REALK,     -0.054120213213358_REALK, &
      0.000000000000000_REALK,      0.042090342404484_REALK,      0.000000000000000_REALK, &
     -0.005383828658931_REALK,      0.000000000000000_REALK,     -0.080040648706885_REALK, &
      0.000000000000000_REALK,      0.003746763922646_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.149267202084447_REALK,      0.000000000000000_REALK, &
      0.171558922630318_REALK,      0.000000000000000_REALK,     -0.081110816860432_REALK, &
      0.000000000000000_REALK,     -0.034820361786194_REALK,      0.000000000000000_REALK, &
     -0.003760824163919_REALK,      0.000000000000000_REALK,      0.056396856283083_REALK, &
      0.000000000000000_REALK,      0.072833411025640_REALK,      0.000000000000000_REALK, &
     -0.051967304633115_REALK,      0.000000000000000_REALK,      0.033920049124182_REALK, &
      0.028908095656606_REALK,      0.000000000000000_REALK,      0.059342111969650_REALK, &
      0.000000000000000_REALK,      0.195321153574739_REALK,      0.000000000000000_REALK, &
      0.115105094903713_REALK,      0.000000000000000_REALK,      0.065485157360487_REALK, &
      0.000000000000000_REALK,     -0.039849845628273_REALK,      0.000000000000000_REALK, &
     -0.020825750629246_REALK,      0.000000000000000_REALK,     -0.069294496210093_REALK, &
      0.000000000000000_REALK,      0.038314835394119_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.121002362146819_REALK,      0.000000000000000_REALK, &
     -0.121844583131625_REALK,      0.000000000000000_REALK,     -0.078556824579890_REALK, &
      0.000000000000000_REALK,      0.024317873068572_REALK,      0.000000000000000_REALK, &
     -0.030668445683395_REALK,      0.000000000000000_REALK,      0.033718370692220_REALK, &
      0.000000000000000_REALK,      0.071923857111302_REALK,      0.000000000000000_REALK, &
      0.005348801157018_REALK,      0.000000000000000_REALK,     -0.027964493169438_REALK, &
     -0.051255457301823_REALK,      0.000000000000000_REALK,      0.014747745477667_REALK, &
      0.000000000000000_REALK,      0.049861677087366_REALK,      0.000000000000000_REALK, &
     -0.044394609770266_REALK,      0.000000000000000_REALK,     -0.032849275543972_REALK, &
      0.000000000000000_REALK,     -0.044596941772065_REALK,      0.000000000000000_REALK, &
     -0.009166154687088_REALK,      0.000000000000000_REALK,     -0.041274291883116_REALK, &
      0.000000000000000_REALK,      0.019761603062348_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.013500429347090_REALK,      0.000000000000000_REALK, &
      0.001378956939363_REALK,      0.000000000000000_REALK,     -0.027165016130884_REALK, &
      0.000000000000000_REALK,     -0.032446978825356_REALK,      0.000000000000000_REALK/
  ! results of test 7, ket-major order, 03ODGXYY
  data REF_CONTR_INTS(21385:21780) /                                                       &
      0.000000000000000_REALK,     -0.021559828808316_REALK,      0.000000000000000_REALK, &
      0.006439601516813_REALK,      0.000000000000000_REALK,      0.023298444768766_REALK, &
      0.000000000000000_REALK,     -0.031582669137720_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.003544462097468_REALK,      0.000000000000000_REALK, &
      0.016293210514192_REALK,      0.000000000000000_REALK,      0.010359108543835_REALK, &
      0.000000000000000_REALK,     -0.003500844552448_REALK,      0.000000000000000_REALK, &
     -0.008513389627534_REALK,      0.000000000000000_REALK,     -0.003651439476957_REALK, &
      0.000000000000000_REALK,     -0.020488233940652_REALK,      0.000000000000000_REALK, &
      0.034076207528487_REALK,      0.000000000000000_REALK,     -0.024875307462830_REALK, &
      0.004833642408285_REALK,      0.000000000000000_REALK,      0.017415265610315_REALK, &
      0.000000000000000_REALK,     -0.044972379736423_REALK,      0.000000000000000_REALK, &
      0.019964308588279_REALK,      0.000000000000000_REALK,     -0.017906521944058_REALK, &
      0.000000000000000_REALK,     -0.025053051176722_REALK,      0.000000000000000_REALK, &
      0.014459157173380_REALK,      0.000000000000000_REALK,      0.015473796727745_REALK, &
      0.000000000000000_REALK,      0.009593254404079_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.018035611771779_REALK,      0.000000000000000_REALK, &
     -0.017486427710798_REALK,      0.000000000000000_REALK,     -0.004289489605926_REALK, &
      0.000000000000000_REALK,     -0.008929121023741_REALK,      0.000000000000000_REALK, &
     -0.015017420730308_REALK,      0.000000000000000_REALK,      0.037069796509755_REALK, &
      0.000000000000000_REALK,     -0.048179561202036_REALK,      0.000000000000000_REALK, &
      0.047239119096620_REALK,      0.000000000000000_REALK,     -0.005579492299523_REALK, &
     -0.009426434651626_REALK,      0.000000000000000_REALK,      0.007602814746220_REALK, &
      0.000000000000000_REALK,     -0.015055619587760_REALK,      0.000000000000000_REALK, &
      0.042527975224301_REALK,      0.000000000000000_REALK,      0.001820776471968_REALK, &
      0.000000000000000_REALK,      0.022811562797129_REALK,      0.000000000000000_REALK, &
     -0.014089140570237_REALK,      0.000000000000000_REALK,     -0.054996001658133_REALK, &
      0.000000000000000_REALK,      0.026969210055590_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.009189794119905_REALK,      0.000000000000000_REALK, &
      0.003344348507725_REALK,      0.000000000000000_REALK,     -0.024393411454781_REALK, &
      0.000000000000000_REALK,      0.013753322018302_REALK,      0.000000000000000_REALK, &
      0.006467168775509_REALK,      0.000000000000000_REALK,     -0.028835030757109_REALK, &
      0.000000000000000_REALK,      0.042161206640916_REALK,      0.000000000000000_REALK, &
     -0.034137456992561_REALK,      0.000000000000000_REALK,      0.007328660016179_REALK, &
     -0.003743151975566_REALK,      0.000000000000000_REALK,     -0.016019100041787_REALK, &
      0.000000000000000_REALK,      0.030453254353695_REALK,      0.000000000000000_REALK, &
     -0.003449740151069_REALK,      0.000000000000000_REALK,      0.006053681808512_REALK, &
      0.000000000000000_REALK,      0.020133620726559_REALK,      0.000000000000000_REALK, &
     -0.021850193467421_REALK,      0.000000000000000_REALK,     -0.042068406905146_REALK, &
      0.000000000000000_REALK,      0.006936891614916_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.006572979662686_REALK,      0.000000000000000_REALK, &
     -0.028387774033604_REALK,      0.000000000000000_REALK,     -0.027303824191804_REALK, &
      0.000000000000000_REALK,     -0.003177425360917_REALK,      0.000000000000000_REALK, &
      0.005550117409855_REALK,      0.000000000000000_REALK,      0.006679077868050_REALK, &
      0.000000000000000_REALK,      0.009288133171496_REALK,      0.000000000000000_REALK, &
     -0.026776656131526_REALK,      0.000000000000000_REALK,      0.011022777688444_REALK, &
      0.003953376905178_REALK,      0.000000000000000_REALK,      0.007257126820440_REALK, &
      0.000000000000000_REALK,     -0.001998826684169_REALK,      0.000000000000000_REALK, &
     -0.025441894473076_REALK,      0.000000000000000_REALK,     -0.002572251361495_REALK, &
      0.000000000000000_REALK,      0.027848590803677_REALK,      0.000000000000000_REALK, &
     -0.006872587687860_REALK,      0.000000000000000_REALK,     -0.052126416810395_REALK, &
      0.000000000000000_REALK,      0.039224864525899_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.013485407751252_REALK,      0.000000000000000_REALK, &
     -0.002785337053376_REALK,      0.000000000000000_REALK,     -0.040377273802140_REALK, &
      0.000000000000000_REALK,      0.021856171014307_REALK,      0.000000000000000_REALK, &
     -0.023122051538477_REALK,      0.000000000000000_REALK,      0.029776415893198_REALK, &
      0.000000000000000_REALK,     -0.024982189277220_REALK,      0.000000000000000_REALK, &
      0.030902131048535_REALK,      0.000000000000000_REALK,      0.005097527558518_REALK, &
      0.003858791201656_REALK,      0.000000000000000_REALK,      0.024717321245196_REALK, &
      0.000000000000000_REALK,     -0.018230598528506_REALK,      0.000000000000000_REALK, &
      0.007556729760279_REALK,      0.000000000000000_REALK,      0.003827829160858_REALK, &
      0.000000000000000_REALK,     -0.023192148371772_REALK,      0.000000000000000_REALK, &
      0.003644490932714_REALK,      0.000000000000000_REALK,     -0.011061416473958_REALK, &
      0.000000000000000_REALK,      0.023856747410526_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.000265297594972_REALK,      0.000000000000000_REALK, &
      0.011452602033807_REALK,      0.000000000000000_REALK,     -0.019156742541888_REALK, &
      0.000000000000000_REALK,      0.038990462550004_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.026251547309321_REALK,      0.000000000000000_REALK, &
      0.054730926137797_REALK,      0.000000000000000_REALK,     -0.049317451933789_REALK, &
      0.000000000000000_REALK,     -0.011242334898558_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.036720610210137_REALK,      0.000000000000000_REALK, &
      0.094217844655262_REALK,      0.000000000000000_REALK,     -0.075032165436798_REALK, &
      0.000000000000000_REALK,     -0.006009264224031_REALK,      0.000000000000000_REALK, &
      0.047318453974176_REALK,      0.000000000000000_REALK,     -0.101171716177923_REALK, &
      0.000000000000000_REALK,     -0.113966887634776_REALK,      0.000000000000000_REALK, &
      0.066819939651367_REALK,      0.000000000000000_REALK,     -0.018522924578252_REALK, &
      0.038804095820143_REALK,      0.000000000000000_REALK,     -0.124894270819462_REALK, &
      0.000000000000000_REALK,     -0.193147310257345_REALK,      0.000000000000000_REALK, &
      0.030462560454657_REALK,      0.000000000000000_REALK,     -0.073050800907816_REALK, &
      0.000000000000000_REALK,     -0.083011390661134_REALK,      0.000000000000000_REALK, &
      0.026543212183065_REALK,      0.000000000000000_REALK,     -0.047553650062559_REALK, &
      0.000000000000000_REALK,      0.010568815621246_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.128654944063481_REALK,      0.000000000000000_REALK, &
     -0.049716800760906_REALK,      0.000000000000000_REALK,     -0.041548666701344_REALK, &
      0.000000000000000_REALK,     -0.023180845249157_REALK,      0.000000000000000_REALK, &
      0.020544351834078_REALK,      0.000000000000000_REALK,     -0.063981268296608_REALK, &
      0.000000000000000_REALK,     -0.061041700241918_REALK,      0.000000000000000_REALK, &
      0.130662702924858_REALK,      0.000000000000000_REALK,      0.006267156813844_REALK, &
      0.015934968286673_REALK,      0.000000000000000_REALK,     -0.091658039181213_REALK, &
      0.000000000000000_REALK,     -0.025926717684302_REALK,      0.000000000000000_REALK, &
      0.163532203823756_REALK,      0.000000000000000_REALK,      0.038179267391202_REALK, &
      0.000000000000000_REALK,     -0.093080033337400_REALK,      0.000000000000000_REALK, &
      0.057922019678832_REALK,      0.000000000000000_REALK,     -0.184564417563811_REALK, &
      0.000000000000000_REALK,      0.039755656944961_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.037283005942618_REALK,      0.000000000000000_REALK, &
      0.111188245210466_REALK,      0.000000000000000_REALK,     -0.173026155535665_REALK, &
      0.000000000000000_REALK,     -0.016412306226123_REALK,      0.000000000000000_REALK, &
     -0.027988333839289_REALK,      0.000000000000000_REALK,      0.074948693676291_REALK, &
      0.000000000000000_REALK,      0.093650903185928_REALK,      0.000000000000000_REALK, &
     -0.107519814469911_REALK,      0.000000000000000_REALK,     -0.004047815851874_REALK, &
      0.001971054998370_REALK,      0.000000000000000_REALK,      0.085770971308179_REALK, &
      0.000000000000000_REALK,      0.140975583350438_REALK,      0.000000000000000_REALK, &
      0.006985789209051_REALK,      0.000000000000000_REALK,      0.010877679292967_REALK, &
      0.000000000000000_REALK,     -0.032586578210104_REALK,      0.000000000000000_REALK, &
     -0.000965536654632_REALK,      0.000000000000000_REALK,     -0.098071419139650_REALK, &
      0.000000000000000_REALK,      0.015630857503094_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.092553479020857_REALK,      0.000000000000000_REALK, &
     -0.083532821932078_REALK,      0.000000000000000_REALK,     -0.110690992607644_REALK, &
      0.000000000000000_REALK,      0.005057741061619_REALK,      0.000000000000000_REALK, &
     -0.035683025102557_REALK,      0.000000000000000_REALK,      0.101691694792274_REALK, &
      0.000000000000000_REALK,      0.095963791425807_REALK,      0.000000000000000_REALK, &
     -0.094134639156817_REALK,      0.000000000000000_REALK,     -0.014644118668680_REALK, &
     -0.019115297046533_REALK,      0.000000000000000_REALK,      0.100487399925632_REALK, &
      0.000000000000000_REALK,      0.042527781557804_REALK,      0.000000000000000_REALK, &
     -0.122710937307687_REALK,      0.000000000000000_REALK,     -0.050954250533976_REALK, &
      0.000000000000000_REALK,     -0.076826444915810_REALK,      0.000000000000000_REALK, &
      0.048009764923931_REALK,      0.000000000000000_REALK,     -0.125257847027566_REALK, &
      0.000000000000000_REALK,      0.058382925473265_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.039297283534736_REALK,      0.000000000000000_REALK, &
      0.091708550801341_REALK,      0.000000000000000_REALK,     -0.186117486441601_REALK, &
      0.000000000000000_REALK,      0.016220241235485_REALK,      0.000000000000000_REALK, &
     -0.035840474831335_REALK,      0.000000000000000_REALK,      0.006531158805064_REALK, &
      0.000000000000000_REALK,      0.061766481528641_REALK,      0.000000000000000_REALK, &
      0.028036931969138_REALK,      0.000000000000000_REALK,     -0.003107056294656_REALK, &
      0.012102152743587_REALK,      0.000000000000000_REALK,      0.039267823881642_REALK, &
      0.000000000000000_REALK,      0.078867428709942_REALK,      0.000000000000000_REALK, &
      0.000687322072946_REALK,      0.000000000000000_REALK,     -0.015434742228440_REALK, &
      0.000000000000000_REALK,     -0.091329347504364_REALK,      0.000000000000000_REALK, &
      0.027526335144058_REALK,      0.000000000000000_REALK,     -0.076267642001325_REALK, &
      0.000000000000000_REALK,     -0.001196660372801_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.082505673483843_REALK,      0.000000000000000_REALK, &
      0.049039579252445_REALK,      0.000000000000000_REALK,     -0.064610005110408_REALK, &
      0.000000000000000_REALK,      0.019813030967924_REALK,      0.000000000000000_REALK/
  ! results of test 7, ket-major order, 03ODGYYY
  data REF_CONTR_INTS(21781:22176) /                                                       &
      0.000000000000000_REALK,     -0.020231123427700_REALK,      0.000000000000000_REALK, &
      0.004192845323390_REALK,      0.000000000000000_REALK,      0.019042797108724_REALK, &
      0.000000000000000_REALK,     -0.028589274662270_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.020224002938547_REALK,      0.000000000000000_REALK, &
      0.003874634183994_REALK,      0.000000000000000_REALK,     -0.030211320228727_REALK, &
      0.000000000000000_REALK,      0.026279146075138_REALK,      0.000000000000000_REALK, &
     -0.012338049599865_REALK,      0.000000000000000_REALK,      0.000988338349462_REALK, &
      0.000000000000000_REALK,     -0.038449487695362_REALK,      0.000000000000000_REALK, &
      0.057952543517212_REALK,      0.000000000000000_REALK,     -0.035198168537066_REALK, &
     -0.007058476428280_REALK,      0.000000000000000_REALK,      0.002575561230995_REALK, &
      0.000000000000000_REALK,     -0.026589723774817_REALK,      0.000000000000000_REALK, &
      0.052630482344455_REALK,      0.000000000000000_REALK,     -0.002163381934572_REALK, &
      0.000000000000000_REALK,     -0.015911815525909_REALK,      0.000000000000000_REALK, &
      0.010010355867898_REALK,      0.000000000000000_REALK,     -0.011024076765608_REALK, &
      0.000000000000000_REALK,      0.021299511465805_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.001623162121139_REALK,      0.000000000000000_REALK, &
      0.021697531066352_REALK,      0.000000000000000_REALK,     -0.052618611106512_REALK, &
      0.000000000000000_REALK,      0.054907409515179_REALK,      0.000000000000000_REALK, &
     -0.011285372237828_REALK,      0.000000000000000_REALK,      0.024459416657689_REALK, &
      0.000000000000000_REALK,     -0.052107960292399_REALK,      0.000000000000000_REALK, &
      0.058246922764825_REALK,      0.000000000000000_REALK,     -0.018073107198149_REALK, &
      0.005264732586198_REALK,      0.000000000000000_REALK,      0.018708128701539_REALK, &
      0.000000000000000_REALK,     -0.041376523566445_REALK,      0.000000000000000_REALK, &
      0.016870195878684_REALK,      0.000000000000000_REALK,     -0.008727751503276_REALK, &
      0.000000000000000_REALK,      0.014763578139683_REALK,      0.000000000000000_REALK, &
     -0.009467273055034_REALK,      0.000000000000000_REALK,     -0.078770552897325_REALK, &
      0.000000000000000_REALK,      0.052415037533661_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.008099302638569_REALK,      0.000000000000000_REALK, &
     -0.013591164736583_REALK,      0.000000000000000_REALK,     -0.089629142953881_REALK, &
      0.000000000000000_REALK,      0.043868603577985_REALK,      0.000000000000000_REALK, &
      0.006553651893327_REALK,      0.000000000000000_REALK,     -0.015624381766472_REALK, &
      0.000000000000000_REALK,      0.047521198649755_REALK,      0.000000000000000_REALK, &
     -0.056619665079122_REALK,      0.000000000000000_REALK,      0.019751080439677_REALK, &
      0.000958441452020_REALK,      0.000000000000000_REALK,      0.000812167192575_REALK, &
      0.000000000000000_REALK,      0.039797218171890_REALK,      0.000000000000000_REALK, &
     -0.064999169884801_REALK,      0.000000000000000_REALK,      0.010346208603357_REALK, &
      0.000000000000000_REALK,      0.016072762835471_REALK,      0.000000000000000_REALK, &
     -0.008055916687314_REALK,      0.000000000000000_REALK,     -0.040574815686256_REALK, &
      0.000000000000000_REALK,      0.022657264791408_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.010432018981584_REALK,      0.000000000000000_REALK, &
      0.010128489385286_REALK,      0.000000000000000_REALK,     -0.016430440137183_REALK, &
      0.000000000000000_REALK,      0.013818489250322_REALK,      0.000000000000000_REALK, &
      0.000281141191642_REALK,      0.000000000000000_REALK,     -0.000124846133319_REALK, &
      0.000000000000000_REALK,      0.035089668043725_REALK,      0.000000000000000_REALK, &
     -0.044723658172965_REALK,      0.000000000000000_REALK,      0.025742802657514_REALK, &
     -0.004083399280214_REALK,      0.000000000000000_REALK,     -0.001490772113703_REALK, &
      0.000000000000000_REALK,      0.060672009358359_REALK,      0.000000000000000_REALK, &
     -0.063522877553527_REALK,      0.000000000000000_REALK,      0.023411597764770_REALK, &
      0.000000000000000_REALK,      0.019255591820513_REALK,      0.000000000000000_REALK, &
     -0.010018115744372_REALK,      0.000000000000000_REALK,     -0.071842664138560_REALK, &
      0.000000000000000_REALK,      0.053266065805727_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.007169081054693_REALK,      0.000000000000000_REALK, &
      0.001617701477392_REALK,      0.000000000000000_REALK,     -0.039675703253293_REALK, &
      0.000000000000000_REALK,      0.029370264915871_REALK,      0.000000000000000_REALK, &
     -0.016176819069080_REALK,      0.000000000000000_REALK,      0.022164011313006_REALK, &
      0.000000000000000_REALK,     -0.013779234408146_REALK,      0.000000000000000_REALK, &
      0.013410793118060_REALK,      0.000000000000000_REALK,      0.009294864593235_REALK, &
     -0.014811906190632_REALK,      0.000000000000000_REALK,      0.001070181907418_REALK, &
      0.000000000000000_REALK,      0.041620284792951_REALK,      0.000000000000000_REALK, &
     -0.027692600836207_REALK,      0.000000000000000_REALK,      0.026966052242643_REALK, &
      0.000000000000000_REALK,     -0.015078267604423_REALK,      0.000000000000000_REALK, &
      0.003831825656307_REALK,      0.000000000000000_REALK,     -0.033347354665450_REALK, &
      0.000000000000000_REALK,      0.040086391499297_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.011785308526467_REALK,      0.000000000000000_REALK, &
     -0.010578585207840_REALK,      0.000000000000000_REALK,     -0.030156690031713_REALK, &
      0.000000000000000_REALK,      0.025945893719552_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.034885845455487_REALK,      0.000000000000000_REALK, &
      0.030562612134103_REALK,      0.000000000000000_REALK,     -0.045367826206528_REALK, &
      0.000000000000000_REALK,      0.016527931152598_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.194060605152709_REALK,      0.000000000000000_REALK, &
      0.106236306349171_REALK,      0.000000000000000_REALK,     -0.235722019600299_REALK, &
      0.000000000000000_REALK,      0.101927111249235_REALK,      0.000000000000000_REALK, &
      0.128773150847784_REALK,      0.000000000000000_REALK,     -0.196344773034868_REALK, &
      0.000000000000000_REALK,     -0.183976081195075_REALK,      0.000000000000000_REALK, &
      0.142262453123845_REALK,      0.000000000000000_REALK,      0.009456161398830_REALK, &
      0.044030831636902_REALK,      0.000000000000000_REALK,     -0.262513511577468_REALK, &
      0.000000000000000_REALK,     -0.167606011194242_REALK,      0.000000000000000_REALK, &
      0.162113152245581_REALK,      0.000000000000000_REALK,      0.103873937597643_REALK, &
      0.000000000000000_REALK,     -0.142336917996842_REALK,      0.000000000000000_REALK, &
      0.073638998609858_REALK,      0.000000000000000_REALK,     -0.147923932335509_REALK, &
      0.000000000000000_REALK,      0.039828676257376_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.277532873864257_REALK,      0.000000000000000_REALK, &
      0.245860690184404_REALK,      0.000000000000000_REALK,     -0.431532764384794_REALK, &
      0.000000000000000_REALK,      0.153079651499466_REALK,      0.000000000000000_REALK, &
      0.065613372325730_REALK,      0.000000000000000_REALK,     -0.179069563854323_REALK, &
      0.000000000000000_REALK,     -0.171011771773306_REALK,      0.000000000000000_REALK, &
      0.186783006596159_REALK,      0.000000000000000_REALK,      0.018058361177690_REALK, &
      0.017962260424469_REALK,      0.000000000000000_REALK,     -0.180432885027645_REALK, &
      0.000000000000000_REALK,     -0.209807312846533_REALK,      0.000000000000000_REALK, &
      0.064511170921991_REALK,      0.000000000000000_REALK,      0.013999829227592_REALK, &
      0.000000000000000_REALK,     -0.255125378342120_REALK,      0.000000000000000_REALK, &
      0.146883539502635_REALK,      0.000000000000000_REALK,     -0.364990597879133_REALK, &
      0.000000000000000_REALK,      0.080174532417345_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.401919637928563_REALK,      0.000000000000000_REALK, &
      0.241946511998471_REALK,      0.000000000000000_REALK,     -0.667950319492449_REALK, &
      0.000000000000000_REALK,      0.080328654514140_REALK,      0.000000000000000_REALK, &
     -0.090674408098700_REALK,      0.000000000000000_REALK,      0.203141414249123_REALK, &
      0.000000000000000_REALK,      0.208816105883251_REALK,      0.000000000000000_REALK, &
     -0.207192022873642_REALK,      0.000000000000000_REALK,     -0.025386677582197_REALK, &
     -0.115254914798841_REALK,      0.000000000000000_REALK,      0.342819465154713_REALK, &
      0.000000000000000_REALK,      0.341432506679680_REALK,      0.000000000000000_REALK, &
     -0.332916774726271_REALK,      0.000000000000000_REALK,     -0.058115571246018_REALK, &
      0.000000000000000_REALK,     -0.081415016346480_REALK,      0.000000000000000_REALK, &
      0.055843103352843_REALK,      0.000000000000000_REALK,     -0.150529581841160_REALK, &
      0.000000000000000_REALK,      0.028628271228698_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.016370714277991_REALK,      0.000000000000000_REALK, &
      0.122236691375132_REALK,      0.000000000000000_REALK,     -0.140858205806593_REALK, &
      0.000000000000000_REALK,     -0.015976876368305_REALK,      0.000000000000000_REALK, &
     -0.118252995150403_REALK,      0.000000000000000_REALK,      0.204285571502180_REALK, &
      0.000000000000000_REALK,      0.219522601788962_REALK,      0.000000000000000_REALK, &
     -0.171843728072986_REALK,      0.000000000000000_REALK,     -0.017710286682648_REALK, &
     -0.167360098312448_REALK,      0.000000000000000_REALK,      0.400677165094657_REALK, &
      0.000000000000000_REALK,      0.480512217656303_REALK,      0.000000000000000_REALK, &
     -0.344210780582063_REALK,      0.000000000000000_REALK,     -0.023334965107843_REALK, &
      0.000000000000000_REALK,     -0.217351017047033_REALK,      0.000000000000000_REALK, &
      0.102745385099179_REALK,      0.000000000000000_REALK,     -0.256932051274413_REALK, &
      0.000000000000000_REALK,      0.073228980286277_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.162889584093222_REALK,      0.000000000000000_REALK, &
      0.146306167830195_REALK,      0.000000000000000_REALK,     -0.256018394397491_REALK, &
      0.000000000000000_REALK,     -0.012208387370386_REALK,      0.000000000000000_REALK, &
     -0.079859852638856_REALK,      0.000000000000000_REALK,      0.017512174615627_REALK, &
      0.000000000000000_REALK,      0.065876190793062_REALK,      0.000000000000000_REALK, &
     -0.025596510099866_REALK,      0.000000000000000_REALK,     -0.002623398418999_REALK, &
     -0.222250131860149_REALK,      0.000000000000000_REALK,      0.182046063128585_REALK, &
      0.000000000000000_REALK,      0.314271421516242_REALK,      0.000000000000000_REALK, &
     -0.203366213044782_REALK,      0.000000000000000_REALK,      0.045871403415179_REALK, &
      0.000000000000000_REALK,     -0.165875628325839_REALK,      0.000000000000000_REALK, &
      0.083849141812187_REALK,      0.000000000000000_REALK,     -0.144788192533494_REALK, &
      0.000000000000000_REALK,     -0.003854419989717_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.234528747005623_REALK,      0.000000000000000_REALK, &
      0.064780710734897_REALK,      0.000000000000000_REALK,     -0.100295749944583_REALK, &
      0.000000000000000_REALK,     -0.072808818945891_REALK,      0.000000000000000_REALK/
  ! results of test 7, ket-major order, 03ODGXXZ
  data REF_CONTR_INTS(22177:22572) /                                                       &
      0.046426538235838_REALK,      0.000000000000000_REALK,     -0.011707671780878_REALK, &
      0.000000000000000_REALK,      0.012372556816167_REALK,      0.000000000000000_REALK, &
      0.032953573091155_REALK,      0.000000000000000_REALK,      0.018513162072120_REALK, &
      0.008312740972123_REALK,      0.000000000000000_REALK,     -0.017121194157502_REALK, &
      0.000000000000000_REALK,      0.014072817002364_REALK,      0.000000000000000_REALK, &
      0.029941633030223_REALK,      0.000000000000000_REALK,      0.033408493002994_REALK, &
      0.000000000000000_REALK,      0.004611600014459_REALK,      0.000000000000000_REALK, &
      0.010983646720925_REALK,      0.000000000000000_REALK,      0.004684512454362_REALK, &
      0.000000000000000_REALK,     -0.045005849978860_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.029587036159196_REALK,      0.000000000000000_REALK, &
      0.031170001376762_REALK,      0.000000000000000_REALK,      0.009177920208195_REALK, &
      0.000000000000000_REALK,     -0.034305083148171_REALK,      0.000000000000000_REALK, &
     -0.010871288754249_REALK,      0.000000000000000_REALK,     -0.026344994579220_REALK, &
      0.000000000000000_REALK,      0.003706405057999_REALK,      0.000000000000000_REALK, &
     -0.000144087105568_REALK,      0.000000000000000_REALK,     -0.041226031858949_REALK, &
      0.015430905975515_REALK,      0.000000000000000_REALK,     -0.049560638725544_REALK, &
      0.000000000000000_REALK,      0.013259598854353_REALK,      0.000000000000000_REALK, &
     -0.021395422254542_REALK,      0.000000000000000_REALK,     -0.023020125060164_REALK, &
      0.000000000000000_REALK,     -0.044348255735314_REALK,      0.000000000000000_REALK, &
      0.014177781803529_REALK,      0.000000000000000_REALK,      0.017607944285466_REALK, &
      0.000000000000000_REALK,      0.031632568936018_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.037165278326986_REALK,      0.000000000000000_REALK, &
      0.004858339909894_REALK,      0.000000000000000_REALK,      0.022761381497640_REALK, &
      0.000000000000000_REALK,      0.006071740977321_REALK,      0.000000000000000_REALK, &
     -0.006234976832869_REALK,      0.000000000000000_REALK,      0.027774939448493_REALK, &
      0.000000000000000_REALK,     -0.014020206367681_REALK,      0.000000000000000_REALK, &
      0.008064321687457_REALK,      0.000000000000000_REALK,      0.011648246556882_REALK, &
     -0.005901116861598_REALK,      0.000000000000000_REALK,      0.030070083772329_REALK, &
      0.000000000000000_REALK,     -0.019639994959048_REALK,      0.000000000000000_REALK, &
      0.023567864864152_REALK,      0.000000000000000_REALK,      0.002044163239280_REALK, &
      0.000000000000000_REALK,      0.022161351780730_REALK,      0.000000000000000_REALK, &
     -0.033994866257048_REALK,      0.000000000000000_REALK,     -0.027114418354125_REALK, &
      0.000000000000000_REALK,     -0.046640329277819_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.015238575327294_REALK,      0.000000000000000_REALK, &
     -0.079256013001439_REALK,      0.000000000000000_REALK,     -0.052830258212398_REALK, &
      0.000000000000000_REALK,     -0.047037923124332_REALK,      0.000000000000000_REALK, &
      0.032082680113644_REALK,      0.000000000000000_REALK,      0.059481000862250_REALK, &
      0.000000000000000_REALK,     -0.035970740912932_REALK,      0.000000000000000_REALK, &
     -0.017488292877719_REALK,      0.000000000000000_REALK,      0.016945260696313_REALK, &
      0.031253535097667_REALK,      0.000000000000000_REALK,      0.106452077444983_REALK, &
      0.000000000000000_REALK,     -0.093992134532475_REALK,      0.000000000000000_REALK, &
     -0.063311496541278_REALK,      0.000000000000000_REALK,     -0.015635709741090_REALK, &
      0.000000000000000_REALK,      0.009348304703244_REALK,      0.000000000000000_REALK, &
      0.029177643788260_REALK,      0.000000000000000_REALK,      0.014156853607042_REALK, &
      0.000000000000000_REALK,      0.062272927136023_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.036360906604877_REALK,      0.000000000000000_REALK, &
      0.084599211344763_REALK,      0.000000000000000_REALK,      0.036588084326888_REALK, &
      0.000000000000000_REALK,      0.082246848576487_REALK,      0.000000000000000_REALK, &
     -0.057523369739755_REALK,      0.000000000000000_REALK,     -0.011674336352696_REALK, &
      0.000000000000000_REALK,      0.010641682013318_REALK,      0.000000000000000_REALK, &
      0.021377642819641_REALK,      0.000000000000000_REALK,      0.001905972702776_REALK, &
     -0.041666396523882_REALK,      0.000000000000000_REALK,     -0.047670419740866_REALK, &
      0.000000000000000_REALK,      0.044679086400629_REALK,      0.000000000000000_REALK, &
      0.067383495835499_REALK,      0.000000000000000_REALK,      0.009773360323166_REALK, &
      0.000000000000000_REALK,     -0.038746694918528_REALK,      0.000000000000000_REALK, &
     -0.016067709304442_REALK,      0.000000000000000_REALK,     -0.016143203833388_REALK, &
      0.000000000000000_REALK,     -0.014423770350536_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.063917057782275_REALK,      0.000000000000000_REALK, &
     -0.030885284964781_REALK,      0.000000000000000_REALK,     -0.016373518788384_REALK, &
      0.000000000000000_REALK,     -0.057365418599008_REALK,      0.000000000000000_REALK, &
      0.027122224157353_REALK,      0.000000000000000_REALK,      0.033819809704267_REALK, &
      0.000000000000000_REALK,     -0.017895684819380_REALK,      0.000000000000000_REALK, &
      0.002227091654310_REALK,      0.000000000000000_REALK,     -0.041190437804881_REALK, &
      0.031987586241987_REALK,      0.000000000000000_REALK,      0.015067222928408_REALK, &
      0.000000000000000_REALK,      0.002680952244263_REALK,      0.000000000000000_REALK, &
      0.012869447401025_REALK,      0.000000000000000_REALK,     -0.027603347368564_REALK, &
      0.011748118176310_REALK,      0.000000000000000_REALK,      0.031649863098583_REALK, &
      0.000000000000000_REALK,      0.089508706829148_REALK,      0.000000000000000_REALK, &
      0.185302955965076_REALK,      0.000000000000000_REALK,     -0.000505596678917_REALK, &
      0.028517141667112_REALK,      0.000000000000000_REALK,      0.036293518164478_REALK, &
      0.000000000000000_REALK,      0.045547668530942_REALK,      0.000000000000000_REALK, &
      0.143771863184083_REALK,      0.000000000000000_REALK,      0.081429424408725_REALK, &
      0.000000000000000_REALK,      0.001937333875618_REALK,      0.000000000000000_REALK, &
      0.258005054642156_REALK,      0.000000000000000_REALK,     -0.054401211117992_REALK, &
      0.000000000000000_REALK,      0.002840961153698_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.054140129749425_REALK,      0.000000000000000_REALK, &
      0.385145561400012_REALK,      0.000000000000000_REALK,     -0.077925034727043_REALK, &
      0.000000000000000_REALK,     -0.020773624332699_REALK,      0.000000000000000_REALK, &
     -0.010698302621038_REALK,      0.000000000000000_REALK,      0.029074570649729_REALK, &
      0.000000000000000_REALK,     -0.152373602577673_REALK,      0.000000000000000_REALK, &
     -0.091347729863765_REALK,      0.000000000000000_REALK,     -0.022227313693451_REALK, &
      0.013997190706147_REALK,      0.000000000000000_REALK,     -0.060315418826726_REALK, &
      0.000000000000000_REALK,     -0.245425173389667_REALK,      0.000000000000000_REALK, &
     -0.060471728764840_REALK,      0.000000000000000_REALK,     -0.093040400608755_REALK, &
      0.000000000000000_REALK,     -0.025091103295432_REALK,      0.000000000000000_REALK, &
     -0.173709351752405_REALK,      0.000000000000000_REALK,     -0.116916364565420_REALK, &
      0.000000000000000_REALK,      0.030997331363623_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.085279633547969_REALK,      0.000000000000000_REALK, &
     -0.132576877059744_REALK,      0.000000000000000_REALK,     -0.015147860951355_REALK, &
      0.000000000000000_REALK,      0.004241789691456_REALK,      0.000000000000000_REALK, &
      0.003714439411416_REALK,      0.000000000000000_REALK,      0.033360370200467_REALK, &
      0.000000000000000_REALK,      0.108841393230931_REALK,      0.000000000000000_REALK, &
      0.013384839486253_REALK,      0.000000000000000_REALK,      0.000276972369340_REALK, &
      0.007365262690435_REALK,      0.000000000000000_REALK,      0.055635735227287_REALK, &
      0.000000000000000_REALK,      0.123339831220671_REALK,      0.000000000000000_REALK, &
      0.068359302608383_REALK,      0.000000000000000_REALK,      0.022277149299062_REALK, &
      0.000000000000000_REALK,     -0.039482142979079_REALK,      0.000000000000000_REALK, &
      0.144638081377363_REALK,      0.000000000000000_REALK,      0.056206462624151_REALK, &
      0.000000000000000_REALK,     -0.041528824632709_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.197272299259806_REALK,      0.000000000000000_REALK, &
     -0.132106507461910_REALK,      0.000000000000000_REALK,     -0.082439351246752_REALK, &
      0.000000000000000_REALK,      0.000081781208459_REALK,      0.000000000000000_REALK, &
      0.001514668224421_REALK,      0.000000000000000_REALK,      0.073600826371092_REALK, &
      0.000000000000000_REALK,      0.179786677494750_REALK,      0.000000000000000_REALK, &
      0.035471971486518_REALK,      0.000000000000000_REALK,     -0.066855122249552_REALK, &
     -0.047552383249959_REALK,      0.000000000000000_REALK,      0.165419577464430_REALK, &
      0.000000000000000_REALK,      0.010947470891565_REALK,      0.000000000000000_REALK, &
     -0.292357998591599_REALK,      0.000000000000000_REALK,     -0.133755475926080_REALK, &
      0.000000000000000_REALK,      0.067123526326778_REALK,      0.000000000000000_REALK, &
     -0.186385200447944_REALK,      0.000000000000000_REALK,      0.054969221824787_REALK, &
      0.000000000000000_REALK,      0.066582103486898_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.239448615655940_REALK,      0.000000000000000_REALK, &
      0.035282722592855_REALK,      0.000000000000000_REALK,      0.096920271530688_REALK, &
      0.000000000000000_REALK,      0.054472341871786_REALK,      0.000000000000000_REALK, &
     -0.017404815221386_REALK,      0.000000000000000_REALK,     -0.031455189037432_REALK, &
      0.000000000000000_REALK,     -0.043232146105859_REALK,      0.000000000000000_REALK, &
     -0.116007328702656_REALK,      0.000000000000000_REALK,      0.066231594939182_REALK, &
      0.019441652125517_REALK,      0.000000000000000_REALK,     -0.045265746445684_REALK, &
      0.000000000000000_REALK,      0.042861682317606_REALK,      0.000000000000000_REALK, &
      0.134935530532621_REALK,      0.000000000000000_REALK,      0.107593364088111_REALK, &
      0.000000000000000_REALK,      0.007141844659018_REALK,      0.000000000000000_REALK, &
      0.046960376488382_REALK,      0.000000000000000_REALK,     -0.120332711452389_REALK, &
      0.000000000000000_REALK,     -0.001312725566295_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.140267625813937_REALK,      0.000000000000000_REALK, &
      0.122955821972181_REALK,      0.000000000000000_REALK,     -0.154207246527403_REALK, &
      0.000000000000000_REALK,      0.028953918187109_REALK,      0.000000000000000_REALK, &
     -0.015577004584704_REALK,      0.000000000000000_REALK,      0.099543347254728_REALK, &
      0.000000000000000_REALK,      0.146984162831439_REALK,      0.000000000000000_REALK, &
      0.030214534555134_REALK,      0.000000000000000_REALK,     -0.044660539108847_REALK, &
     -0.053468128439158_REALK,      0.000000000000000_REALK,      0.122708115358006_REALK, &
      0.000000000000000_REALK,      0.241123462599257_REALK,      0.000000000000000_REALK, &
      0.142791931034072_REALK,      0.000000000000000_REALK,     -0.044641832793384_REALK/
  ! results of test 7, ket-major order, 03ODGXYZ
  data REF_CONTR_INTS(22573:22968) /                                                       &
      0.019012950420688_REALK,      0.000000000000000_REALK,      0.001986483233960_REALK, &
      0.000000000000000_REALK,     -0.007238458684642_REALK,      0.000000000000000_REALK, &
      0.015133331301270_REALK,      0.000000000000000_REALK,      0.006482934995235_REALK, &
      0.023408931432252_REALK,      0.000000000000000_REALK,      0.003788574058103_REALK, &
      0.000000000000000_REALK,     -0.006153023320751_REALK,      0.000000000000000_REALK, &
      0.010967794902436_REALK,      0.000000000000000_REALK,     -0.006409159628604_REALK, &
      0.000000000000000_REALK,     -0.001056159566558_REALK,      0.000000000000000_REALK, &
      0.004474238466237_REALK,      0.000000000000000_REALK,      0.003664540100593_REALK, &
      0.000000000000000_REALK,     -0.016955029367906_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.019812296578228_REALK,      0.000000000000000_REALK, &
     -0.011517269304687_REALK,      0.000000000000000_REALK,      0.005543614807792_REALK, &
      0.000000000000000_REALK,     -0.047942413845495_REALK,      0.000000000000000_REALK, &
      0.003842907207488_REALK,      0.000000000000000_REALK,     -0.006762048536915_REALK, &
      0.000000000000000_REALK,     -0.000965112684881_REALK,      0.000000000000000_REALK, &
      0.000983474858500_REALK,      0.000000000000000_REALK,     -0.014278263853563_REALK, &
     -0.013940143630503_REALK,      0.000000000000000_REALK,     -0.033443660590924_REALK, &
      0.000000000000000_REALK,      0.023467339971265_REALK,      0.000000000000000_REALK, &
      0.018233846812656_REALK,      0.000000000000000_REALK,     -0.000782001395133_REALK, &
      0.000000000000000_REALK,     -0.026990180257698_REALK,      0.000000000000000_REALK, &
      0.004637185306138_REALK,      0.000000000000000_REALK,      0.008783132593575_REALK, &
      0.000000000000000_REALK,     -0.002735975574525_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.009862933090885_REALK,      0.000000000000000_REALK, &
      0.029317534530134_REALK,      0.000000000000000_REALK,      0.030978502522866_REALK, &
      0.000000000000000_REALK,      0.004456830085076_REALK,      0.000000000000000_REALK, &
     -0.010520269551934_REALK,      0.000000000000000_REALK,      0.013335589643486_REALK, &
      0.000000000000000_REALK,     -0.008714899457369_REALK,      0.000000000000000_REALK, &
      0.011322981164956_REALK,      0.000000000000000_REALK,     -0.002644492885665_REALK, &
      0.002910869186446_REALK,      0.000000000000000_REALK,      0.023496089263032_REALK, &
      0.000000000000000_REALK,     -0.022384767395686_REALK,      0.000000000000000_REALK, &
      0.007189149612916_REALK,      0.000000000000000_REALK,     -0.003745430122737_REALK, &
      0.000000000000000_REALK,      0.021895474545620_REALK,      0.000000000000000_REALK, &
     -0.001489410220417_REALK,      0.000000000000000_REALK,     -0.009269462755648_REALK, &
      0.000000000000000_REALK,      0.006156211580832_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.021107860610732_REALK,      0.000000000000000_REALK, &
      0.013870213052960_REALK,      0.000000000000000_REALK,     -0.006448947397451_REALK, &
      0.000000000000000_REALK,      0.016053025925483_REALK,      0.000000000000000_REALK, &
     -0.011687706758062_REALK,      0.000000000000000_REALK,      0.010909531710860_REALK, &
      0.000000000000000_REALK,     -0.003189662173229_REALK,      0.000000000000000_REALK, &
      0.010427352827522_REALK,      0.000000000000000_REALK,      0.006062568005580_REALK, &
     -0.012973812891142_REALK,      0.000000000000000_REALK,      0.002853827037172_REALK, &
      0.000000000000000_REALK,      0.006005170772973_REALK,      0.000000000000000_REALK, &
      0.034899898148207_REALK,      0.000000000000000_REALK,      0.007913144236152_REALK, &
      0.000000000000000_REALK,     -0.000901919797759_REALK,      0.000000000000000_REALK, &
     -0.005105202038792_REALK,      0.000000000000000_REALK,     -0.006097907273747_REALK, &
      0.000000000000000_REALK,      0.009623415105601_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.010272628153286_REALK,      0.000000000000000_REALK, &
     -0.023096604452582_REALK,      0.000000000000000_REALK,     -0.013997247251622_REALK, &
      0.000000000000000_REALK,     -0.005265137982779_REALK,      0.000000000000000_REALK, &
     -0.012757735618771_REALK,      0.000000000000000_REALK,      0.009450347234259_REALK, &
      0.000000000000000_REALK,     -0.005208018531667_REALK,      0.000000000000000_REALK, &
      0.004411467837071_REALK,      0.000000000000000_REALK,     -0.007090584549545_REALK, &
     -0.003755263072846_REALK,      0.000000000000000_REALK,      0.030494616398503_REALK, &
      0.000000000000000_REALK,     -0.030156300750362_REALK,      0.000000000000000_REALK, &
      0.016615126543993_REALK,      0.000000000000000_REALK,     -0.011482531631378_REALK, &
      0.000000000000000_REALK,     -0.016055890330299_REALK,      0.000000000000000_REALK, &
     -0.002415086232385_REALK,      0.000000000000000_REALK,     -0.008376826947009_REALK, &
      0.000000000000000_REALK,      0.000784847155273_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.017540083388223_REALK,      0.000000000000000_REALK, &
     -0.001275794116986_REALK,      0.000000000000000_REALK,     -0.006974554585744_REALK, &
      0.000000000000000_REALK,      0.007605642959242_REALK,      0.000000000000000_REALK, &
      0.000449777687307_REALK,      0.000000000000000_REALK,      0.015716205239509_REALK, &
      0.000000000000000_REALK,     -0.008602375785342_REALK,      0.000000000000000_REALK, &
      0.002215018529131_REALK,      0.000000000000000_REALK,     -0.017849187487024_REALK, &
      0.001412065479135_REALK,      0.000000000000000_REALK,      0.013199107051257_REALK, &
      0.000000000000000_REALK,     -0.007098213904424_REALK,      0.000000000000000_REALK, &
     -0.004878575234814_REALK,      0.000000000000000_REALK,     -0.021825333578396_REALK, &
      0.006960206064679_REALK,      0.000000000000000_REALK,     -0.028163548406611_REALK, &
      0.000000000000000_REALK,     -0.011543308469906_REALK,      0.000000000000000_REALK, &
      0.063814834495930_REALK,      0.000000000000000_REALK,      0.003378612789463_REALK, &
      0.003196039330687_REALK,      0.000000000000000_REALK,     -0.021202489644671_REALK, &
      0.000000000000000_REALK,      0.011452281698006_REALK,      0.000000000000000_REALK, &
      0.056638569861854_REALK,      0.000000000000000_REALK,     -0.030944462021364_REALK, &
      0.000000000000000_REALK,     -0.001407446761384_REALK,      0.000000000000000_REALK, &
      0.087760457422268_REALK,      0.000000000000000_REALK,     -0.055467383762120_REALK, &
      0.000000000000000_REALK,      0.001967161970044_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.011391694675079_REALK,      0.000000000000000_REALK, &
      0.105080332187143_REALK,      0.000000000000000_REALK,     -0.086539630797150_REALK, &
      0.000000000000000_REALK,     -0.035582501525781_REALK,      0.000000000000000_REALK, &
      0.011958038285777_REALK,      0.000000000000000_REALK,      0.024865525705473_REALK, &
      0.000000000000000_REALK,     -0.036819937679167_REALK,      0.000000000000000_REALK, &
     -0.000928698517206_REALK,      0.000000000000000_REALK,     -0.009232184734540_REALK, &
     -0.012941262843352_REALK,      0.000000000000000_REALK,     -0.034140532524448_REALK, &
      0.000000000000000_REALK,     -0.053456060121325_REALK,      0.000000000000000_REALK, &
      0.047995472065758_REALK,      0.000000000000000_REALK,      0.044639820184887_REALK, &
      0.000000000000000_REALK,     -0.019460322592486_REALK,      0.000000000000000_REALK, &
     -0.020762457158977_REALK,      0.000000000000000_REALK,     -0.120471848217821_REALK, &
      0.000000000000000_REALK,     -0.013618152486797_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.037078277616083_REALK,      0.000000000000000_REALK, &
      0.071070455672701_REALK,      0.000000000000000_REALK,     -0.014382603162443_REALK, &
      0.000000000000000_REALK,     -0.002330992643944_REALK,      0.000000000000000_REALK, &
      0.009444139182643_REALK,      0.000000000000000_REALK,      0.028882883196229_REALK, &
      0.000000000000000_REALK,      0.071808693951829_REALK,      0.000000000000000_REALK, &
     -0.005179504231310_REALK,      0.000000000000000_REALK,     -0.007191191762634_REALK, &
      0.011369538366750_REALK,      0.000000000000000_REALK,      0.030125422671194_REALK, &
      0.000000000000000_REALK,      0.046636586688252_REALK,      0.000000000000000_REALK, &
      0.021755495631543_REALK,      0.000000000000000_REALK,     -0.010039314867794_REALK, &
      0.000000000000000_REALK,      0.015097025931706_REALK,      0.000000000000000_REALK, &
      0.027154042143384_REALK,      0.000000000000000_REALK,      0.078725502266598_REALK, &
      0.000000000000000_REALK,      0.017646237475713_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.049606011283553_REALK,      0.000000000000000_REALK, &
      0.048629069718265_REALK,      0.000000000000000_REALK,      0.014005845549613_REALK, &
      0.000000000000000_REALK,      0.022367336620122_REALK,      0.000000000000000_REALK, &
     -0.000473101123178_REALK,      0.000000000000000_REALK,      0.020333634762464_REALK, &
      0.000000000000000_REALK,      0.080120507739213_REALK,      0.000000000000000_REALK, &
      0.009182565979640_REALK,      0.000000000000000_REALK,      0.010748248692102_REALK, &
      0.008373963017384_REALK,      0.000000000000000_REALK,      0.010660960317137_REALK, &
      0.000000000000000_REALK,      0.135576352929181_REALK,      0.000000000000000_REALK, &
      0.112071729378897_REALK,      0.000000000000000_REALK,      0.050338376496052_REALK, &
      0.000000000000000_REALK,     -0.011987210707839_REALK,      0.000000000000000_REALK, &
     -0.070116269707529_REALK,      0.000000000000000_REALK,      0.026260777815289_REALK, &
      0.000000000000000_REALK,      0.021074053971350_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.082702443799793_REALK,      0.000000000000000_REALK, &
     -0.101994861362658_REALK,      0.000000000000000_REALK,      0.016393251246356_REALK, &
      0.000000000000000_REALK,      0.001063908229902_REALK,      0.000000000000000_REALK, &
      0.000643285854037_REALK,      0.000000000000000_REALK,      0.024183878707172_REALK, &
      0.000000000000000_REALK,      0.054572682903249_REALK,      0.000000000000000_REALK, &
     -0.056997819327365_REALK,      0.000000000000000_REALK,     -0.020628155147452_REALK, &
     -0.004667382548959_REALK,      0.000000000000000_REALK,      0.019918978889786_REALK, &
      0.000000000000000_REALK,      0.046300595061622_REALK,      0.000000000000000_REALK, &
      0.020142832677816_REALK,      0.000000000000000_REALK,     -0.043432980593913_REALK, &
      0.000000000000000_REALK,      0.000983453593968_REALK,      0.000000000000000_REALK, &
      0.007303584677131_REALK,      0.000000000000000_REALK,     -0.094654787645820_REALK, &
      0.000000000000000_REALK,      0.000351394249493_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.002520865969152_REALK,      0.000000000000000_REALK, &
      0.000178982461352_REALK,      0.000000000000000_REALK,     -0.121900405484846_REALK, &
      0.000000000000000_REALK,     -0.005872952217269_REALK,      0.000000000000000_REALK, &
      0.012195412820215_REALK,      0.000000000000000_REALK,      0.060843341370864_REALK, &
      0.000000000000000_REALK,      0.080108976852397_REALK,      0.000000000000000_REALK, &
     -0.006815401468824_REALK,      0.000000000000000_REALK,      0.000015962589573_REALK, &
      0.032190731326896_REALK,      0.000000000000000_REALK,      0.069326241534257_REALK, &
      0.000000000000000_REALK,      0.081410154581657_REALK,      0.000000000000000_REALK, &
     -0.041811311823707_REALK,      0.000000000000000_REALK,     -0.011318442781696_REALK/
  ! results of test 7, ket-major order, 03ODGYYZ
  data REF_CONTR_INTS(22969:23364) /                                                       &
      0.012166904383462_REALK,      0.000000000000000_REALK,      0.002916323234551_REALK, &
      0.000000000000000_REALK,     -0.010189049694101_REALK,      0.000000000000000_REALK, &
      0.014832538980243_REALK,      0.000000000000000_REALK,      0.004446514825882_REALK, &
      0.007010320383817_REALK,      0.000000000000000_REALK,      0.004961869357581_REALK, &
      0.000000000000000_REALK,     -0.008215084715034_REALK,      0.000000000000000_REALK, &
      0.012057570327858_REALK,      0.000000000000000_REALK,     -0.015123291547931_REALK, &
      0.000000000000000_REALK,     -0.003307004305415_REALK,      0.000000000000000_REALK, &
      0.003098925559317_REALK,      0.000000000000000_REALK,      0.004454468628450_REALK, &
      0.000000000000000_REALK,     -0.016066490962879_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.004268783393801_REALK,      0.000000000000000_REALK, &
      0.010365216964622_REALK,      0.000000000000000_REALK,      0.005214283582680_REALK, &
      0.000000000000000_REALK,     -0.014169537990384_REALK,      0.000000000000000_REALK, &
      0.005160920623120_REALK,      0.000000000000000_REALK,     -0.000993944667144_REALK, &
      0.000000000000000_REALK,     -0.005544120678075_REALK,      0.000000000000000_REALK, &
      0.005353612781963_REALK,      0.000000000000000_REALK,     -0.014551007233491_REALK, &
      0.010245130901124_REALK,      0.000000000000000_REALK,      0.013580036951642_REALK, &
      0.000000000000000_REALK,     -0.037434288589981_REALK,      0.000000000000000_REALK, &
      0.021493851921756_REALK,      0.000000000000000_REALK,     -0.028528461124310_REALK, &
      0.000000000000000_REALK,     -0.020173577336706_REALK,      0.000000000000000_REALK, &
      0.002490645502757_REALK,      0.000000000000000_REALK,      0.009699126122279_REALK, &
      0.000000000000000_REALK,     -0.015496078827332_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.020505301970286_REALK,      0.000000000000000_REALK, &
     -0.012534738773793_REALK,      0.000000000000000_REALK,      0.007130654086403_REALK, &
      0.000000000000000_REALK,     -0.025002420429798_REALK,      0.000000000000000_REALK, &
     -0.011474387855736_REALK,      0.000000000000000_REALK,      0.009971295419474_REALK, &
      0.000000000000000_REALK,     -0.011994597894455_REALK,      0.000000000000000_REALK, &
      0.019824055368299_REALK,      0.000000000000000_REALK,     -0.015804628747945_REALK, &
     -0.006543058026748_REALK,      0.000000000000000_REALK,      0.013068233521238_REALK, &
      0.000000000000000_REALK,     -0.036273427247808_REALK,      0.000000000000000_REALK, &
      0.065614075920854_REALK,      0.000000000000000_REALK,     -0.018336222513949_REALK, &
      0.000000000000000_REALK,      0.015108930106068_REALK,      0.000000000000000_REALK, &
     -0.004682745667503_REALK,      0.000000000000000_REALK,     -0.015080254893595_REALK, &
      0.000000000000000_REALK,      0.015223690593646_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.001879550211332_REALK,      0.000000000000000_REALK, &
     -0.021156923325291_REALK,      0.000000000000000_REALK,     -0.047012738700439_REALK, &
      0.000000000000000_REALK,      0.023683036138563_REALK,      0.000000000000000_REALK, &
     -0.006354517779076_REALK,      0.000000000000000_REALK,      0.009362849317193_REALK, &
      0.000000000000000_REALK,     -0.006529002612525_REALK,      0.000000000000000_REALK, &
      0.007365565686001_REALK,      0.000000000000000_REALK,     -0.003544536173339_REALK, &
      0.005489961826102_REALK,      0.000000000000000_REALK,      0.020899163237234_REALK, &
      0.000000000000000_REALK,     -0.022565123812217_REALK,      0.000000000000000_REALK, &
     -0.002117100459819_REALK,      0.000000000000000_REALK,     -0.006419651833492_REALK, &
      0.000000000000000_REALK,      0.004506754962401_REALK,      0.000000000000000_REALK, &
     -0.000607701426403_REALK,      0.000000000000000_REALK,     -0.011261149841611_REALK, &
      0.000000000000000_REALK,      0.019079849269223_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.012398243354329_REALK,      0.000000000000000_REALK, &
      0.002952298424318_REALK,      0.000000000000000_REALK,     -0.043594389652652_REALK, &
      0.000000000000000_REALK,      0.048801601649326_REALK,      0.000000000000000_REALK, &
     -0.016738544426817_REALK,      0.000000000000000_REALK,      0.005971475298178_REALK, &
      0.000000000000000_REALK,     -0.003501203027707_REALK,      0.000000000000000_REALK, &
      0.011146791801055_REALK,      0.000000000000000_REALK,     -0.014679438526304_REALK, &
     -0.001446186629329_REALK,      0.000000000000000_REALK,      0.018677553537899_REALK, &
      0.000000000000000_REALK,     -0.016093151682304_REALK,      0.000000000000000_REALK, &
      0.019498364365263_REALK,      0.000000000000000_REALK,     -0.001729580055775_REALK, &
      0.000000000000000_REALK,     -0.011691070506413_REALK,      0.000000000000000_REALK, &
     -0.002642343733129_REALK,      0.000000000000000_REALK,     -0.009079885197885_REALK, &
      0.000000000000000_REALK,     -0.001759755632262_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.006312637296988_REALK,      0.000000000000000_REALK, &
      0.004287473472109_REALK,      0.000000000000000_REALK,     -0.023957817154593_REALK, &
      0.000000000000000_REALK,      0.034355651026284_REALK,      0.000000000000000_REALK, &
      0.002246693819261_REALK,      0.000000000000000_REALK,      0.008742695293863_REALK, &
      0.000000000000000_REALK,     -0.001521752897999_REALK,      0.000000000000000_REALK, &
      0.000696069965920_REALK,      0.000000000000000_REALK,     -0.019485225815735_REALK, &
     -0.010182149837014_REALK,      0.000000000000000_REALK,      0.002439264280737_REALK, &
      0.000000000000000_REALK,      0.009738486568850_REALK,      0.000000000000000_REALK, &
     -0.007370025661824_REALK,      0.000000000000000_REALK,     -0.008336160360534_REALK, &
      0.007426271421330_REALK,      0.000000000000000_REALK,     -0.056191295971534_REALK, &
      0.000000000000000_REALK,     -0.037732460303728_REALK,      0.000000000000000_REALK, &
      0.049791581966825_REALK,      0.000000000000000_REALK,      0.002767233619436_REALK, &
      0.075037806687005_REALK,      0.000000000000000_REALK,     -0.028915808419205_REALK, &
      0.000000000000000_REALK,      0.008382406461218_REALK,      0.000000000000000_REALK, &
      0.006826171663088_REALK,      0.000000000000000_REALK,      0.006392843335699_REALK, &
      0.000000000000000_REALK,     -0.003352686351816_REALK,      0.000000000000000_REALK, &
      0.056720480732754_REALK,      0.000000000000000_REALK,     -0.078510494343046_REALK, &
      0.000000000000000_REALK,      0.002152454658585_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.067473185776257_REALK,      0.000000000000000_REALK, &
      0.091755008800832_REALK,      0.000000000000000_REALK,     -0.151837873822090_REALK, &
      0.000000000000000_REALK,     -0.012306399095198_REALK,      0.000000000000000_REALK, &
      0.036156256032224_REALK,      0.000000000000000_REALK,      0.013920941810440_REALK, &
      0.000000000000000_REALK,     -0.013913432946888_REALK,      0.000000000000000_REALK, &
      0.012566162785954_REALK,      0.000000000000000_REALK,     -0.014724884798142_REALK, &
      0.111674413596211_REALK,      0.000000000000000_REALK,     -0.024302353898619_REALK, &
      0.000000000000000_REALK,     -0.101892418941120_REALK,      0.000000000000000_REALK, &
      0.053527096710029_REALK,      0.000000000000000_REALK,     -0.066756554364772_REALK, &
      0.000000000000000_REALK,     -0.003390965044277_REALK,      0.000000000000000_REALK, &
      0.031939805751404_REALK,      0.000000000000000_REALK,     -0.120128499351322_REALK, &
      0.000000000000000_REALK,     -0.034699913079685_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.002776377037953_REALK,      0.000000000000000_REALK, &
      0.005755777915290_REALK,      0.000000000000000_REALK,     -0.074502012395770_REALK, &
      0.000000000000000_REALK,     -0.049358542696213_REALK,      0.000000000000000_REALK, &
      0.040716793740436_REALK,      0.000000000000000_REALK,      0.036737717872241_REALK, &
      0.000000000000000_REALK,      0.068882569338188_REALK,      0.000000000000000_REALK, &
      0.002149172381758_REALK,      0.000000000000000_REALK,     -0.017721902478584_REALK, &
      0.096723279331603_REALK,      0.000000000000000_REALK,     -0.058302735982332_REALK, &
      0.000000000000000_REALK,     -0.023802979077995_REALK,      0.000000000000000_REALK, &
      0.229492316694801_REALK,      0.000000000000000_REALK,     -0.002385391218694_REALK, &
      0.000000000000000_REALK,     -0.010749622847980_REALK,      0.000000000000000_REALK, &
     -0.024184531786399_REALK,      0.000000000000000_REALK,      0.073838616956607_REALK, &
      0.000000000000000_REALK,      0.039848728471047_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.130801226056387_REALK,      0.000000000000000_REALK, &
     -0.058282247167578_REALK,      0.000000000000000_REALK,     -0.096305475561590_REALK, &
      0.000000000000000_REALK,      0.084606306096540_REALK,      0.000000000000000_REALK, &
      0.009496469937340_REALK,      0.000000000000000_REALK,      0.024309893250619_REALK, &
      0.000000000000000_REALK,      0.056152517738386_REALK,      0.000000000000000_REALK, &
     -0.006420028076869_REALK,      0.000000000000000_REALK,     -0.007590882130662_REALK, &
      0.009989426271630_REALK,      0.000000000000000_REALK,      0.027209633378026_REALK, &
      0.000000000000000_REALK,      0.022088635236432_REALK,      0.000000000000000_REALK, &
     -0.003308982458381_REALK,      0.000000000000000_REALK,     -0.021004193534237_REALK, &
      0.000000000000000_REALK,     -0.017116312952314_REALK,      0.000000000000000_REALK, &
     -0.036053186022025_REALK,      0.000000000000000_REALK,      0.025000964716244_REALK, &
      0.000000000000000_REALK,      0.035991154342066_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.094587209461875_REALK,      0.000000000000000_REALK, &
      0.004990031655347_REALK,      0.000000000000000_REALK,     -0.091230807269575_REALK, &
      0.000000000000000_REALK,      0.135805985188847_REALK,      0.000000000000000_REALK, &
      0.021559642302998_REALK,      0.000000000000000_REALK,      0.052521912935253_REALK, &
      0.000000000000000_REALK,      0.087184197126329_REALK,      0.000000000000000_REALK, &
     -0.050321858798135_REALK,      0.000000000000000_REALK,     -0.016195559803493_REALK, &
      0.025576529800210_REALK,      0.000000000000000_REALK,      0.027553598814616_REALK, &
      0.000000000000000_REALK,      0.087889942059846_REALK,      0.000000000000000_REALK, &
      0.030442715986224_REALK,      0.000000000000000_REALK,      0.028203661121145_REALK, &
      0.000000000000000_REALK,      0.001184216163886_REALK,      0.000000000000000_REALK, &
      0.024315797324641_REALK,      0.000000000000000_REALK,     -0.082074883837462_REALK, &
      0.000000000000000_REALK,      0.000305534760456_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.062688585187469_REALK,      0.000000000000000_REALK, &
      0.039891765639860_REALK,      0.000000000000000_REALK,     -0.110949350139953_REALK, &
      0.000000000000000_REALK,      0.050717504412120_REALK,      0.000000000000000_REALK, &
      0.027866046770198_REALK,      0.000000000000000_REALK,      0.058180265870977_REALK, &
      0.000000000000000_REALK,      0.079066061130549_REALK,      0.000000000000000_REALK, &
     -0.017799895740112_REALK,      0.000000000000000_REALK,      0.000091847031682_REALK, &
      0.014800020425095_REALK,      0.000000000000000_REALK,      0.109046036108902_REALK, &
      0.000000000000000_REALK,      0.127792753909125_REALK,      0.000000000000000_REALK, &
     -0.064133152345384_REALK,      0.000000000000000_REALK,      0.041966385970438_REALK/
  ! results of test 7, ket-major order, 03ODGXZZ
  data REF_CONTR_INTS(23365:23760) /                                                       &
      0.000000000000000_REALK,     -0.017891841610184_REALK,      0.000000000000000_REALK, &
     -0.006667344396337_REALK,      0.000000000000000_REALK,     -0.000627249417672_REALK, &
      0.000000000000000_REALK,     -0.038531887029564_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.002494532378198_REALK,      0.000000000000000_REALK, &
      0.009031857899142_REALK,      0.000000000000000_REALK,      0.000432488558325_REALK, &
      0.000000000000000_REALK,     -0.022163623423073_REALK,      0.000000000000000_REALK, &
      0.009804274534673_REALK,      0.000000000000000_REALK,     -0.034503219692931_REALK, &
      0.000000000000000_REALK,      0.018515616542413_REALK,      0.000000000000000_REALK, &
      0.025173213866497_REALK,      0.000000000000000_REALK,      0.013754665919510_REALK, &
      0.001646396959720_REALK,      0.000000000000000_REALK,     -0.041564332508700_REALK, &
      0.000000000000000_REALK,      0.010917118761274_REALK,      0.000000000000000_REALK, &
      0.032575735137855_REALK,      0.000000000000000_REALK,      0.034128774192888_REALK, &
      0.000000000000000_REALK,     -0.001041232214463_REALK,      0.000000000000000_REALK, &
      0.024741533245797_REALK,      0.000000000000000_REALK,      0.022218180475299_REALK, &
      0.000000000000000_REALK,      0.005767984645657_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.038121142433836_REALK,      0.000000000000000_REALK, &
      0.035460295887610_REALK,      0.000000000000000_REALK,      0.029801212087323_REALK, &
      0.000000000000000_REALK,     -0.014115538844491_REALK,      0.000000000000000_REALK, &
      0.009097267054267_REALK,      0.000000000000000_REALK,      0.029585435898682_REALK, &
      0.000000000000000_REALK,     -0.029971430584522_REALK,      0.000000000000000_REALK, &
      0.006404503540528_REALK,      0.000000000000000_REALK,     -0.015738427751153_REALK, &
      0.020082861441025_REALK,      0.000000000000000_REALK,     -0.025171121668664_REALK, &
      0.000000000000000_REALK,      0.004995693441009_REALK,      0.000000000000000_REALK, &
     -0.025669720124049_REALK,      0.000000000000000_REALK,     -0.006490309821590_REALK, &
      0.000000000000000_REALK,     -0.008581286142617_REALK,      0.000000000000000_REALK, &
     -0.010057669966567_REALK,      0.000000000000000_REALK,     -0.015240627382661_REALK, &
      0.000000000000000_REALK,      0.002699870581295_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.028264261004016_REALK,      0.000000000000000_REALK, &
     -0.007841687184711_REALK,      0.000000000000000_REALK,     -0.007203407783197_REALK, &
      0.000000000000000_REALK,     -0.002586490033454_REALK,      0.000000000000000_REALK, &
      0.002738680470221_REALK,      0.000000000000000_REALK,     -0.016327484345872_REALK, &
      0.000000000000000_REALK,      0.022245026784394_REALK,      0.000000000000000_REALK, &
     -0.000315060523733_REALK,      0.000000000000000_REALK,      0.011836959074347_REALK, &
      0.019626027071520_REALK,      0.000000000000000_REALK,      0.058095450442307_REALK, &
      0.000000000000000_REALK,     -0.028117825749652_REALK,      0.000000000000000_REALK, &
     -0.008970989818550_REALK,      0.000000000000000_REALK,     -0.003250131954120_REALK, &
      0.000000000000000_REALK,     -0.012227705161485_REALK,      0.000000000000000_REALK, &
     -0.020115157120422_REALK,      0.000000000000000_REALK,     -0.017275305145727_REALK, &
      0.000000000000000_REALK,      0.009069602005607_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.014778924020002_REALK,      0.000000000000000_REALK, &
      0.026182947113435_REALK,      0.000000000000000_REALK,      0.022508447858695_REALK, &
      0.000000000000000_REALK,      0.063305094546012_REALK,      0.000000000000000_REALK, &
     -0.019129475518260_REALK,      0.000000000000000_REALK,      0.013332872175635_REALK, &
      0.000000000000000_REALK,     -0.013161940991957_REALK,      0.000000000000000_REALK, &
     -0.014840740356067_REALK,      0.000000000000000_REALK,     -0.012878034747228_REALK, &
     -0.034557253196876_REALK,      0.000000000000000_REALK,     -0.041774351068106_REALK, &
      0.000000000000000_REALK,      0.019400380924444_REALK,      0.000000000000000_REALK, &
      0.007315701523149_REALK,      0.000000000000000_REALK,     -0.001874872432033_REALK, &
      0.000000000000000_REALK,      0.006823950763458_REALK,      0.000000000000000_REALK, &
      0.006954384544472_REALK,      0.000000000000000_REALK,     -0.011305444901073_REALK, &
      0.000000000000000_REALK,      0.006926930432453_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.028948313742785_REALK,      0.000000000000000_REALK, &
      0.004873615344055_REALK,      0.000000000000000_REALK,     -0.010828530921480_REALK, &
      0.000000000000000_REALK,     -0.061098390709092_REALK,      0.000000000000000_REALK, &
      0.015878345291547_REALK,      0.000000000000000_REALK,      0.026197851310049_REALK, &
      0.000000000000000_REALK,     -0.012925229354409_REALK,      0.000000000000000_REALK, &
      0.027320483061440_REALK,      0.000000000000000_REALK,     -0.006658151626450_REALK, &
      0.034551879451411_REALK,      0.000000000000000_REALK,      0.013148770095826_REALK, &
      0.000000000000000_REALK,      0.005993001077886_REALK,      0.000000000000000_REALK, &
      0.052498530622593_REALK,      0.000000000000000_REALK,     -0.009827062313538_REALK, &
      0.000000000000000_REALK,     -0.031479124586442_REALK,      0.000000000000000_REALK, &
     -0.007389757653091_REALK,      0.000000000000000_REALK,     -0.003846304753809_REALK, &
      0.000000000000000_REALK,      0.011785260512424_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.028174125041897_REALK,      0.000000000000000_REALK, &
     -0.014719024444897_REALK,      0.000000000000000_REALK,     -0.012911224062302_REALK, &
      0.000000000000000_REALK,      0.002631383752064_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.032760709471671_REALK,      0.000000000000000_REALK, &
      0.097113618691613_REALK,      0.000000000000000_REALK,     -0.075607534151627_REALK, &
      0.000000000000000_REALK,     -0.024450324992729_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.022378758125407_REALK,      0.000000000000000_REALK, &
      0.188267611484758_REALK,      0.000000000000000_REALK,     -0.100068124664945_REALK, &
      0.000000000000000_REALK,     -0.022220889093435_REALK,      0.000000000000000_REALK, &
     -0.000416937086114_REALK,      0.000000000000000_REALK,     -0.042390793026779_REALK, &
      0.000000000000000_REALK,     -0.049218922834721_REALK,      0.000000000000000_REALK, &
      0.085862088847804_REALK,      0.000000000000000_REALK,     -0.000578016625445_REALK, &
     -0.003444520303022_REALK,      0.000000000000000_REALK,     -0.100274569567063_REALK, &
      0.000000000000000_REALK,     -0.153726295439554_REALK,      0.000000000000000_REALK, &
      0.162993507615271_REALK,      0.000000000000000_REALK,      0.037175421877058_REALK, &
      0.000000000000000_REALK,     -0.009088769235687_REALK,      0.000000000000000_REALK, &
      0.022591355663461_REALK,      0.000000000000000_REALK,      0.018498350783959_REALK, &
      0.000000000000000_REALK,      0.031045450474832_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.004682596828151_REALK,      0.000000000000000_REALK, &
      0.218107583914611_REALK,      0.000000000000000_REALK,      0.140694820854445_REALK, &
      0.000000000000000_REALK,     -0.011046897236385_REALK,      0.000000000000000_REALK, &
      0.004421600916583_REALK,      0.000000000000000_REALK,      0.079414607022592_REALK, &
      0.000000000000000_REALK,      0.013369912908288_REALK,      0.000000000000000_REALK, &
      0.014917542384544_REALK,      0.000000000000000_REALK,     -0.008963493047820_REALK, &
      0.030849862637827_REALK,      0.000000000000000_REALK,     -0.023644710833450_REALK, &
      0.000000000000000_REALK,     -0.057922527815853_REALK,      0.000000000000000_REALK, &
     -0.007748635626266_REALK,      0.000000000000000_REALK,     -0.024134301771881_REALK, &
      0.000000000000000_REALK,     -0.018347977804289_REALK,      0.000000000000000_REALK, &
     -0.037073246007380_REALK,      0.000000000000000_REALK,     -0.069144715299615_REALK, &
      0.000000000000000_REALK,      0.008772180509702_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.045797054195253_REALK,      0.000000000000000_REALK, &
     -0.077682125382632_REALK,      0.000000000000000_REALK,     -0.172499025494732_REALK, &
      0.000000000000000_REALK,     -0.013843825560870_REALK,      0.000000000000000_REALK, &
      0.007792162876147_REALK,      0.000000000000000_REALK,     -0.047529750270265_REALK, &
      0.000000000000000_REALK,      0.038691203881361_REALK,      0.000000000000000_REALK, &
      0.036007737158424_REALK,      0.000000000000000_REALK,     -0.003429289068499_REALK, &
      0.024270806314755_REALK,      0.000000000000000_REALK,      0.132137731400439_REALK, &
      0.000000000000000_REALK,      0.130256023010650_REALK,      0.000000000000000_REALK, &
      0.049001924249152_REALK,      0.000000000000000_REALK,     -0.046836854088599_REALK, &
      0.000000000000000_REALK,     -0.048161659977634_REALK,      0.000000000000000_REALK, &
     -0.116069173251650_REALK,      0.000000000000000_REALK,     -0.067684172579084_REALK, &
      0.000000000000000_REALK,      0.017253234652280_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.004981782445941_REALK,      0.000000000000000_REALK, &
     -0.290325237287466_REALK,      0.000000000000000_REALK,     -0.095896076869685_REALK, &
      0.000000000000000_REALK,      0.127470625703164_REALK,      0.000000000000000_REALK, &
     -0.018277949874783_REALK,      0.000000000000000_REALK,      0.047447758065355_REALK, &
      0.000000000000000_REALK,     -0.031189091602402_REALK,      0.000000000000000_REALK, &
     -0.139852222118841_REALK,      0.000000000000000_REALK,     -0.001998661975657_REALK, &
     -0.036835251740840_REALK,      0.000000000000000_REALK,     -0.033454274950503_REALK, &
      0.000000000000000_REALK,     -0.117946567463281_REALK,      0.000000000000000_REALK, &
     -0.177849059548995_REALK,      0.000000000000000_REALK,      0.043101964402056_REALK, &
      0.000000000000000_REALK,      0.057558478910564_REALK,      0.000000000000000_REALK, &
      0.040488680872890_REALK,      0.000000000000000_REALK,     -0.011573662386291_REALK, &
      0.000000000000000_REALK,      0.027393352121933_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.008764509502744_REALK,      0.000000000000000_REALK, &
      0.244816408060800_REALK,      0.000000000000000_REALK,     -0.163051916319882_REALK, &
      0.000000000000000_REALK,     -0.059306032111983_REALK,      0.000000000000000_REALK, &
     -0.000645935108151_REALK,      0.000000000000000_REALK,      0.035798716843492_REALK, &
      0.000000000000000_REALK,      0.109731774580996_REALK,      0.000000000000000_REALK, &
      0.070503180146255_REALK,      0.000000000000000_REALK,      0.001089541700079_REALK, &
      0.005302050845607_REALK,      0.000000000000000_REALK,      0.080047038701149_REALK, &
      0.000000000000000_REALK,      0.273456298286032_REALK,      0.000000000000000_REALK, &
      0.267973443003994_REALK,      0.000000000000000_REALK,     -0.025544250709649_REALK, &
      0.000000000000000_REALK,     -0.063367133840987_REALK,      0.000000000000000_REALK, &
     -0.076997639440491_REALK,      0.000000000000000_REALK,     -0.038986219527088_REALK, &
      0.000000000000000_REALK,      0.032413702932583_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.118683486822706_REALK,      0.000000000000000_REALK, &
     -0.062523543158993_REALK,      0.000000000000000_REALK,     -0.034568040681372_REALK, &
      0.000000000000000_REALK,      0.063920827076779_REALK,      0.000000000000000_REALK/
  ! results of test 7, ket-major order, 03ODGYZZ
  data REF_CONTR_INTS(23761:24156) /                                                       &
      0.000000000000000_REALK,     -0.014462322543429_REALK,      0.000000000000000_REALK, &
      0.001338557221916_REALK,      0.000000000000000_REALK,      0.003594737490384_REALK, &
      0.000000000000000_REALK,     -0.014615458823312_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.017805215712263_REALK,      0.000000000000000_REALK, &
     -0.005105390839458_REALK,      0.000000000000000_REALK,     -0.011989088996120_REALK, &
      0.000000000000000_REALK,     -0.002394851210547_REALK,      0.000000000000000_REALK, &
      0.005757235057754_REALK,      0.000000000000000_REALK,     -0.005339883098873_REALK, &
      0.000000000000000_REALK,     -0.006337520605599_REALK,      0.000000000000000_REALK, &
      0.016955775682884_REALK,      0.000000000000000_REALK,      0.007302992226863_REALK, &
      0.022389305631138_REALK,      0.000000000000000_REALK,     -0.002180828590727_REALK, &
      0.000000000000000_REALK,     -0.012957669409790_REALK,      0.000000000000000_REALK, &
      0.039592717242715_REALK,      0.000000000000000_REALK,      0.004574389441101_REALK, &
      0.000000000000000_REALK,     -0.002685824218121_REALK,      0.000000000000000_REALK, &
      0.007819644880672_REALK,      0.000000000000000_REALK,      0.006824491622498_REALK, &
      0.000000000000000_REALK,      0.002356733606124_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.009680796643751_REALK,      0.000000000000000_REALK, &
      0.003500786018102_REALK,      0.000000000000000_REALK,      0.010194007636132_REALK, &
      0.000000000000000_REALK,     -0.044084501049831_REALK,      0.000000000000000_REALK, &
      0.010982152716569_REALK,      0.000000000000000_REALK,      0.013933357375879_REALK, &
      0.000000000000000_REALK,     -0.017733913204734_REALK,      0.000000000000000_REALK, &
      0.013194477120772_REALK,      0.000000000000000_REALK,     -0.001099053607604_REALK, &
     -0.005324673024599_REALK,      0.000000000000000_REALK,     -0.027738126588895_REALK, &
      0.000000000000000_REALK,      0.009900647165730_REALK,      0.000000000000000_REALK, &
      0.010184120974727_REALK,      0.000000000000000_REALK,      0.000490245094425_REALK, &
      0.000000000000000_REALK,     -0.006328329164400_REALK,      0.000000000000000_REALK, &
     -0.004003924866881_REALK,      0.000000000000000_REALK,     -0.012615828430618_REALK, &
      0.000000000000000_REALK,      0.000308620244261_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.029572582432271_REALK,      0.000000000000000_REALK, &
      0.016053821526812_REALK,      0.000000000000000_REALK,      0.023417300973988_REALK, &
      0.000000000000000_REALK,     -0.025453469002205_REALK,      0.000000000000000_REALK, &
     -0.010968465500333_REALK,      0.000000000000000_REALK,     -0.007928832135046_REALK, &
      0.000000000000000_REALK,      0.012049168789116_REALK,      0.000000000000000_REALK, &
     -0.007097179240267_REALK,      0.000000000000000_REALK,     -0.001881070965730_REALK, &
     -0.017506576147868_REALK,      0.000000000000000_REALK,      0.010442506135389_REALK, &
      0.000000000000000_REALK,     -0.004985440750814_REALK,      0.000000000000000_REALK, &
      0.033691293259228_REALK,      0.000000000000000_REALK,     -0.009947541451358_REALK, &
      0.000000000000000_REALK,     -0.003933752107176_REALK,      0.000000000000000_REALK, &
     -0.006320282528056_REALK,      0.000000000000000_REALK,     -0.011388628372535_REALK, &
      0.000000000000000_REALK,     -0.000385456480836_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.023408273307896_REALK,      0.000000000000000_REALK, &
     -0.019701797909070_REALK,      0.000000000000000_REALK,     -0.015843687200616_REALK, &
      0.000000000000000_REALK,     -0.019226778601713_REALK,      0.000000000000000_REALK, &
     -0.003670457763089_REALK,      0.000000000000000_REALK,      0.004246360047183_REALK, &
      0.000000000000000_REALK,      0.002401817242708_REALK,      0.000000000000000_REALK, &
     -0.006140635756216_REALK,      0.000000000000000_REALK,     -0.007896877103557_REALK, &
     -0.001280238689278_REALK,      0.000000000000000_REALK,      0.030983551649383_REALK, &
      0.000000000000000_REALK,     -0.020826853569059_REALK,      0.000000000000000_REALK, &
      0.013177951302034_REALK,      0.000000000000000_REALK,     -0.028023807485963_REALK, &
      0.000000000000000_REALK,      0.000992933706686_REALK,      0.000000000000000_REALK, &
     -0.004916485753045_REALK,      0.000000000000000_REALK,     -0.017037910096134_REALK, &
      0.000000000000000_REALK,      0.005634665403308_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.024927696135671_REALK,      0.000000000000000_REALK, &
     -0.007471613601274_REALK,      0.000000000000000_REALK,     -0.022418447783358_REALK, &
      0.000000000000000_REALK,      0.000193273815751_REALK,      0.000000000000000_REALK, &
      0.004560220782590_REALK,      0.000000000000000_REALK,      0.020532170640418_REALK, &
      0.000000000000000_REALK,     -0.015014224406503_REALK,      0.000000000000000_REALK, &
      0.013349361166692_REALK,      0.000000000000000_REALK,     -0.004308783755592_REALK, &
      0.004027941123018_REALK,      0.000000000000000_REALK,      0.028850525625042_REALK, &
      0.000000000000000_REALK,     -0.009800276597881_REALK,      0.000000000000000_REALK, &
     -0.002673962135051_REALK,      0.000000000000000_REALK,     -0.023594924248495_REALK, &
      0.000000000000000_REALK,     -0.009204056072757_REALK,      0.000000000000000_REALK, &
      0.001499387850690_REALK,      0.000000000000000_REALK,     -0.007296426921965_REALK, &
      0.000000000000000_REALK,      0.018593904320710_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.003608913234846_REALK,      0.000000000000000_REALK, &
     -0.002449622095441_REALK,      0.000000000000000_REALK,     -0.007977073982571_REALK, &
      0.000000000000000_REALK,      0.019950016759233_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.001168177311607_REALK,      0.000000000000000_REALK, &
      0.049624350914643_REALK,      0.000000000000000_REALK,     -0.065188856321557_REALK, &
      0.000000000000000_REALK,     -0.017764482369564_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.071832968706303_REALK,      0.000000000000000_REALK, &
      0.055994229801011_REALK,      0.000000000000000_REALK,     -0.123617449014154_REALK, &
      0.000000000000000_REALK,      0.020257860085357_REALK,      0.000000000000000_REALK, &
      0.000314941815918_REALK,      0.000000000000000_REALK,     -0.037154479469808_REALK, &
      0.000000000000000_REALK,     -0.046600043105604_REALK,      0.000000000000000_REALK, &
      0.049207969268059_REALK,      0.000000000000000_REALK,     -0.000606235441817_REALK, &
      0.001240076646081_REALK,      0.000000000000000_REALK,     -0.115132295433098_REALK, &
      0.000000000000000_REALK,     -0.083722925574328_REALK,      0.000000000000000_REALK, &
      0.186296418991800_REALK,      0.000000000000000_REALK,     -0.012209736617060_REALK, &
      0.000000000000000_REALK,     -0.026798040879427_REALK,      0.000000000000000_REALK, &
      0.011988540124709_REALK,      0.000000000000000_REALK,     -0.014866771862367_REALK, &
      0.000000000000000_REALK,      0.016817867332404_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.020217336542844_REALK,      0.000000000000000_REALK, &
      0.117012512752121_REALK,      0.000000000000000_REALK,     -0.025965448161558_REALK, &
      0.000000000000000_REALK,     -0.023709673930909_REALK,      0.000000000000000_REALK, &
      0.006322610672523_REALK,      0.000000000000000_REALK,      0.014587156476159_REALK, &
      0.000000000000000_REALK,      0.001194162697731_REALK,      0.000000000000000_REALK, &
      0.077942047180316_REALK,      0.000000000000000_REALK,      0.003971460630952_REALK, &
     -0.021622185905272_REALK,      0.000000000000000_REALK,     -0.065648376062540_REALK, &
      0.000000000000000_REALK,     -0.069123200516963_REALK,      0.000000000000000_REALK, &
      0.061462775407928_REALK,      0.000000000000000_REALK,      0.007379378361047_REALK, &
      0.000000000000000_REALK,     -0.029060524297929_REALK,      0.000000000000000_REALK, &
     -0.004904567554989_REALK,      0.000000000000000_REALK,     -0.076434897402090_REALK, &
      0.000000000000000_REALK,      0.014846529917997_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.042917524333252_REALK,      0.000000000000000_REALK, &
      0.045037647731788_REALK,      0.000000000000000_REALK,     -0.190462446728483_REALK, &
      0.000000000000000_REALK,     -0.070267421098995_REALK,      0.000000000000000_REALK, &
     -0.003921643040897_REALK,      0.000000000000000_REALK,      0.000214991958314_REALK, &
      0.000000000000000_REALK,      0.014870459137033_REALK,      0.000000000000000_REALK, &
     -0.062324481935628_REALK,      0.000000000000000_REALK,     -0.006651587438957_REALK, &
      0.008155104073142_REALK,      0.000000000000000_REALK,      0.065017177399199_REALK, &
      0.000000000000000_REALK,      0.082153684944492_REALK,      0.000000000000000_REALK, &
     -0.002336928716646_REALK,      0.000000000000000_REALK,     -0.010771385311968_REALK, &
      0.000000000000000_REALK,     -0.008564928941003_REALK,      0.000000000000000_REALK, &
     -0.015831086392106_REALK,      0.000000000000000_REALK,     -0.051094967067847_REALK, &
      0.000000000000000_REALK,      0.005403295403148_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.039355610288699_REALK,      0.000000000000000_REALK, &
     -0.038287700697145_REALK,      0.000000000000000_REALK,     -0.145185646975861_REALK, &
      0.000000000000000_REALK,     -0.048283113603752_REALK,      0.000000000000000_REALK, &
      0.002048214759925_REALK,      0.000000000000000_REALK,      0.035928668032728_REALK, &
      0.000000000000000_REALK,      0.045055811453316_REALK,      0.000000000000000_REALK, &
     -0.052961701263116_REALK,      0.000000000000000_REALK,     -0.013060391021755_REALK, &
      0.036400991323820_REALK,      0.000000000000000_REALK,      0.094662087141892_REALK, &
      0.000000000000000_REALK,      0.115106959422716_REALK,      0.000000000000000_REALK, &
     -0.052145638778894_REALK,      0.000000000000000_REALK,     -0.070624705723948_REALK, &
      0.000000000000000_REALK,     -0.017424202469741_REALK,      0.000000000000000_REALK, &
     -0.011062100428651_REALK,      0.000000000000000_REALK,     -0.034547047081143_REALK, &
      0.000000000000000_REALK,      0.034103034562182_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.026657420178771_REALK,      0.000000000000000_REALK, &
     -0.008077592067687_REALK,      0.000000000000000_REALK,     -0.227521725683036_REALK, &
      0.000000000000000_REALK,     -0.009652619518221_REALK,      0.000000000000000_REALK, &
     -0.000518517457004_REALK,      0.000000000000000_REALK,      0.014448919806046_REALK, &
      0.000000000000000_REALK,      0.057025751127081_REALK,      0.000000000000000_REALK, &
      0.026557804877924_REALK,      0.000000000000000_REALK,      0.000059878171446_REALK, &
      0.028955315437789_REALK,      0.000000000000000_REALK,      0.074942991200584_REALK, &
      0.000000000000000_REALK,      0.156041273012608_REALK,      0.000000000000000_REALK, &
     -0.044950938910157_REALK,      0.000000000000000_REALK,     -0.014961906029115_REALK, &
      0.000000000000000_REALK,     -0.036563820821504_REALK,      0.000000000000000_REALK, &
     -0.015395458700781_REALK,      0.000000000000000_REALK,     -0.038106413718099_REALK, &
      0.000000000000000_REALK,      0.019476802909540_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.060789917407761_REALK,      0.000000000000000_REALK, &
     -0.033658470209186_REALK,      0.000000000000000_REALK,     -0.004733008299168_REALK, &
      0.000000000000000_REALK,      0.013555363420885_REALK,      0.000000000000000_REALK/
  ! results of test 7, ket-major order, 03ODGZZZ
  data REF_CONTR_INTS(24157:24552) /                                                       &
      0.015316742216873_REALK,      0.000000000000000_REALK,     -0.002294678425497_REALK, &
      0.000000000000000_REALK,     -0.000896226240339_REALK,      0.000000000000000_REALK, &
      0.019511174495044_REALK,      0.000000000000000_REALK,      0.005716758763949_REALK, &
      0.007650592611258_REALK,      0.000000000000000_REALK,     -0.003120449113182_REALK, &
      0.000000000000000_REALK,      0.001133388027732_REALK,      0.000000000000000_REALK, &
      0.018060578300171_REALK,      0.000000000000000_REALK,      0.001810105558103_REALK, &
      0.000000000000000_REALK,      0.000327801313382_REALK,      0.000000000000000_REALK, &
      0.003949220810722_REALK,      0.000000000000000_REALK,      0.005626837274542_REALK, &
      0.000000000000000_REALK,     -0.041350757841916_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.004992950906566_REALK,      0.000000000000000_REALK, &
      0.025152211908424_REALK,      0.000000000000000_REALK,      0.009305493452409_REALK, &
      0.000000000000000_REALK,     -0.053076695582957_REALK,      0.000000000000000_REALK, &
     -0.000508117655346_REALK,      0.000000000000000_REALK,     -0.029296768735550_REALK, &
      0.000000000000000_REALK,      0.012767151629106_REALK,      0.000000000000000_REALK, &
      0.000878591308419_REALK,      0.000000000000000_REALK,     -0.000031025242146_REALK, &
     -0.001854556357255_REALK,      0.000000000000000_REALK,     -0.080039874312508_REALK, &
      0.000000000000000_REALK,      0.009903085303635_REALK,      0.000000000000000_REALK, &
      0.024778065044803_REALK,      0.000000000000000_REALK,      0.037008576071118_REALK, &
      0.000000000000000_REALK,     -0.026657428519508_REALK,      0.000000000000000_REALK, &
      0.012198434082648_REALK,      0.000000000000000_REALK,      0.019338550920798_REALK, &
      0.000000000000000_REALK,      0.003724830053870_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.050402826791656_REALK,      0.000000000000000_REALK, &
      0.036749435312852_REALK,      0.000000000000000_REALK,      0.058813784740312_REALK, &
      0.000000000000000_REALK,     -0.007742419438178_REALK,      0.000000000000000_REALK, &
      0.006459369698262_REALK,      0.000000000000000_REALK,      0.025133717758337_REALK, &
      0.000000000000000_REALK,     -0.020801326027738_REALK,      0.000000000000000_REALK, &
      0.015698102649848_REALK,      0.000000000000000_REALK,     -0.004170443110611_REALK, &
      0.032160743393238_REALK,      0.000000000000000_REALK,     -0.011767363542680_REALK, &
      0.000000000000000_REALK,     -0.011749418400195_REALK,      0.000000000000000_REALK, &
      0.005001670762373_REALK,      0.000000000000000_REALK,      0.017333315777605_REALK, &
      0.000000000000000_REALK,      0.010809911392370_REALK,      0.000000000000000_REALK, &
     -0.015222296984690_REALK,      0.000000000000000_REALK,     -0.019659879940243_REALK, &
      0.000000000000000_REALK,     -0.004644294089732_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.063288975533308_REALK,      0.000000000000000_REALK, &
     -0.010789361332761_REALK,      0.000000000000000_REALK,     -0.013934661020430_REALK, &
      0.000000000000000_REALK,      0.027191029079297_REALK,      0.000000000000000_REALK, &
      0.001788063154204_REALK,      0.000000000000000_REALK,      0.037066698004321_REALK, &
      0.000000000000000_REALK,     -0.026865299810829_REALK,      0.000000000000000_REALK, &
      0.002464220948489_REALK,      0.000000000000000_REALK,     -0.009019340305315_REALK, &
     -0.024469019323747_REALK,      0.000000000000000_REALK,     -0.011169184132322_REALK, &
      0.000000000000000_REALK,     -0.015174592595837_REALK,      0.000000000000000_REALK, &
     -0.009117596597077_REALK,      0.000000000000000_REALK,     -0.014201082966673_REALK, &
      0.000000000000000_REALK,      0.004668652535238_REALK,      0.000000000000000_REALK, &
      0.010311934987959_REALK,      0.000000000000000_REALK,     -0.000540391562207_REALK, &
      0.000000000000000_REALK,      0.027876392824780_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.007780481440069_REALK,      0.000000000000000_REALK, &
      0.032171978170913_REALK,      0.000000000000000_REALK,     -0.002341046153689_REALK, &
      0.000000000000000_REALK,     -0.050451984575677_REALK,      0.000000000000000_REALK, &
     -0.000889662033678_REALK,      0.000000000000000_REALK,      0.006935693250430_REALK, &
      0.000000000000000_REALK,     -0.005485188980885_REALK,      0.000000000000000_REALK, &
      0.021473908815952_REALK,      0.000000000000000_REALK,     -0.000600827745652_REALK, &
      0.040152760339824_REALK,      0.000000000000000_REALK,      0.003992198667492_REALK, &
      0.000000000000000_REALK,     -0.004254691724694_REALK,      0.000000000000000_REALK, &
      0.106885207697008_REALK,      0.000000000000000_REALK,      0.005915328873711_REALK, &
      0.000000000000000_REALK,     -0.035840000790617_REALK,      0.000000000000000_REALK, &
     -0.007725449340221_REALK,      0.000000000000000_REALK,     -0.009685803059964_REALK, &
      0.000000000000000_REALK,     -0.007445046635645_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.052571468287171_REALK,      0.000000000000000_REALK, &
     -0.018914068951204_REALK,      0.000000000000000_REALK,     -0.037276265670645_REALK, &
      0.000000000000000_REALK,     -0.005645461364593_REALK,      0.000000000000000_REALK, &
      0.005464349271983_REALK,      0.000000000000000_REALK,      0.017504894227425_REALK, &
      0.000000000000000_REALK,     -0.005822927629363_REALK,      0.000000000000000_REALK, &
      0.001432714321349_REALK,      0.000000000000000_REALK,     -0.014990750659041_REALK, &
      0.005677574660101_REALK,      0.000000000000000_REALK,      0.010145307687078_REALK, &
      0.000000000000000_REALK,      0.007363806329726_REALK,      0.000000000000000_REALK, &
     -0.000280211927664_REALK,      0.000000000000000_REALK,     -0.012645500954878_REALK, &
      0.008998648185311_REALK,      0.000000000000000_REALK,     -0.014476515118397_REALK, &
      0.000000000000000_REALK,      0.012130006942975_REALK,      0.000000000000000_REALK, &
      0.090776927046759_REALK,      0.000000000000000_REALK,      0.002155662486227_REALK, &
      0.026724380887172_REALK,      0.000000000000000_REALK,     -0.005324105463584_REALK, &
      0.000000000000000_REALK,      0.026937372033198_REALK,      0.000000000000000_REALK, &
      0.085815658169446_REALK,      0.000000000000000_REALK,      0.011951601872333_REALK, &
      0.000000000000000_REALK,      0.002132909718547_REALK,      0.000000000000000_REALK, &
      0.111348920215799_REALK,      0.000000000000000_REALK,     -0.022108142518750_REALK, &
      0.000000000000000_REALK,     -0.031291376354179_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.070509262654822_REALK,      0.000000000000000_REALK, &
      0.335511882948706_REALK,      0.000000000000000_REALK,     -0.134847568087182_REALK, &
      0.000000000000000_REALK,     -0.089975178794072_REALK,      0.000000000000000_REALK, &
      0.002458460209517_REALK,      0.000000000000000_REALK,      0.004089102585474_REALK, &
      0.000000000000000_REALK,     -0.049629587297149_REALK,      0.000000000000000_REALK, &
     -0.009694959147705_REALK,      0.000000000000000_REALK,     -0.011147260643516_REALK, &
      0.003097954351931_REALK,      0.000000000000000_REALK,     -0.196617974880610_REALK, &
      0.000000000000000_REALK,     -0.305785920672455_REALK,      0.000000000000000_REALK, &
      0.118898141336597_REALK,      0.000000000000000_REALK,      0.015453131679534_REALK, &
      0.000000000000000_REALK,     -0.034041264461275_REALK,      0.000000000000000_REALK, &
     -0.058432550161378_REALK,      0.000000000000000_REALK,     -0.097218185567944_REALK, &
      0.000000000000000_REALK,     -0.004167698201113_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.007939964466593_REALK,      0.000000000000000_REALK, &
      0.109147786190638_REALK,      0.000000000000000_REALK,      0.204159848512629_REALK, &
      0.000000000000000_REALK,     -0.018769689584064_REALK,      0.000000000000000_REALK, &
      0.008882799397811_REALK,      0.000000000000000_REALK,      0.044235931975835_REALK, &
      0.000000000000000_REALK,      0.030750724947402_REALK,      0.000000000000000_REALK, &
      0.029874703494226_REALK,      0.000000000000000_REALK,     -0.005729531416131_REALK, &
      0.064929087778698_REALK,      0.000000000000000_REALK,      0.019710377051278_REALK, &
      0.000000000000000_REALK,     -0.035001114244162_REALK,      0.000000000000000_REALK, &
      0.236573802500705_REALK,      0.000000000000000_REALK,      0.034887942826133_REALK, &
      0.000000000000000_REALK,     -0.005914399639304_REALK,      0.000000000000000_REALK, &
      0.035162097806295_REALK,      0.000000000000000_REALK,      0.045412503908846_REALK, &
      0.000000000000000_REALK,      0.002541020947547_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.197270201900547_REALK,      0.000000000000000_REALK, &
     -0.205968125291322_REALK,      0.000000000000000_REALK,     -0.266011668200731_REALK, &
      0.000000000000000_REALK,      0.084753778223723_REALK,      0.000000000000000_REALK, &
      0.002454021188353_REALK,      0.000000000000000_REALK,      0.066362803361892_REALK, &
      0.000000000000000_REALK,      0.039715133737661_REALK,      0.000000000000000_REALK, &
      0.002889128280670_REALK,      0.000000000000000_REALK,     -0.012398723221280_REALK, &
     -0.049307331296983_REALK,      0.000000000000000_REALK,      0.141370655181582_REALK, &
      0.000000000000000_REALK,     -0.045204590641415_REALK,      0.000000000000000_REALK, &
     -0.142667014154712_REALK,      0.000000000000000_REALK,     -0.028756024022653_REALK, &
      0.000000000000000_REALK,      0.019314306088673_REALK,      0.000000000000000_REALK, &
     -0.058548521655289_REALK,      0.000000000000000_REALK,      0.008489959327882_REALK, &
      0.000000000000000_REALK,      0.064368710152144_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.025032676080536_REALK,      0.000000000000000_REALK, &
      0.154422419170706_REALK,      0.000000000000000_REALK,     -0.044910970263186_REALK, &
      0.000000000000000_REALK,      0.048631606232019_REALK,      0.000000000000000_REALK, &
     -0.008903484806853_REALK,      0.000000000000000_REALK,      0.005429712618247_REALK, &
      0.000000000000000_REALK,      0.021322505855385_REALK,      0.000000000000000_REALK, &
     -0.023622897738285_REALK,      0.000000000000000_REALK,      0.000439418054583_REALK, &
      0.023269635504514_REALK,      0.000000000000000_REALK,     -0.028978647351526_REALK, &
      0.000000000000000_REALK,      0.131375706289772_REALK,      0.000000000000000_REALK, &
      0.387603600406193_REALK,      0.000000000000000_REALK,      0.006997205853267_REALK, &
      0.000000000000000_REALK,     -0.029828921591647_REALK,      0.000000000000000_REALK, &
     -0.011464180733615_REALK,      0.000000000000000_REALK,     -0.106775923544898_REALK, &
      0.000000000000000_REALK,     -0.004021697270014_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.178250418998911_REALK,      0.000000000000000_REALK, &
      0.043351707417923_REALK,      0.000000000000000_REALK,     -0.258951603036781_REALK, &
      0.000000000000000_REALK,      0.043499853437758_REALK,      0.000000000000000_REALK, &
      0.006602929230017_REALK,      0.000000000000000_REALK,      0.058335475782370_REALK, &
      0.000000000000000_REALK,      0.078810627711509_REALK,      0.000000000000000_REALK, &
      0.000538598802460_REALK,      0.000000000000000_REALK,     -0.014742375977054_REALK, &
      0.003958236580709_REALK,      0.000000000000000_REALK,      0.105985157929905_REALK, &
      0.000000000000000_REALK,      0.175016486702367_REALK,      0.000000000000000_REALK, &
      0.013989587087835_REALK,      0.000000000000000_REALK,     -0.016400800805277_REALK/
  ! results of test 8, ket-major order, SQHDR001
  data REF_CONTR_INTS(24553:24948) /                                                       &
      0.266923705412279_REALK,      0.000000000000000_REALK,     -0.027890755869562_REALK, &
      0.000000000000000_REALK,     -0.040950697864850_REALK,      0.000000000000000_REALK, &
      0.046554579007678_REALK,      0.000000000000000_REALK,     -0.359884862997084_REALK, &
      0.017872340907200_REALK,      0.000000000000000_REALK,      0.016987604978031_REALK, &
      0.000000000000000_REALK,     -0.011222829469930_REALK,      0.000000000000000_REALK, &
      0.063591204908042_REALK,      0.000000000000000_REALK,     -0.155189018516716_REALK, &
      0.000000000000000_REALK,     -0.262679404603372_REALK,      0.000000000000000_REALK, &
     -0.029704712312351_REALK,      0.000000000000000_REALK,      0.129820767198447_REALK, &
      0.000000000000000_REALK,     -0.278172623791831_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.114499955930671_REALK,      0.000000000000000_REALK, &
      0.044777330434753_REALK,      0.000000000000000_REALK,     -0.035372297931612_REALK, &
      0.000000000000000_REALK,      0.027155726221655_REALK,      0.000000000000000_REALK, &
     -0.079904923396842_REALK,      0.000000000000000_REALK,     -0.095687333145286_REALK, &
      0.000000000000000_REALK,      0.033637962344327_REALK,      0.000000000000000_REALK, &
      0.149827065855015_REALK,      0.000000000000000_REALK,      0.015913966968947_REALK, &
      0.033385581745565_REALK,      0.000000000000000_REALK,     -0.007085287738772_REALK, &
      0.000000000000000_REALK,     -0.065847375971192_REALK,      0.000000000000000_REALK, &
      0.131534523403374_REALK,      0.000000000000000_REALK,      0.013568539905119_REALK, &
      0.000000000000000_REALK,     -0.000750980722374_REALK,      0.000000000000000_REALK, &
      0.089102807570017_REALK,      0.000000000000000_REALK,      0.071142740400548_REALK, &
      0.000000000000000_REALK,      0.065430918071202_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.053912279940686_REALK,      0.000000000000000_REALK, &
      0.019281813724385_REALK,      0.000000000000000_REALK,     -0.014714806205259_REALK, &
      0.000000000000000_REALK,      0.002386924848429_REALK,      0.000000000000000_REALK, &
      0.029402544521619_REALK,      0.000000000000000_REALK,      0.103829528822969_REALK, &
      0.000000000000000_REALK,     -0.119945600365518_REALK,      0.000000000000000_REALK, &
      0.053862218892226_REALK,      0.000000000000000_REALK,     -0.042296330249361_REALK, &
      0.004134284218545_REALK,      0.000000000000000_REALK,     -0.019141583964691_REALK, &
      0.000000000000000_REALK,     -0.006904376310866_REALK,      0.000000000000000_REALK, &
      0.008532980224226_REALK,      0.000000000000000_REALK,      0.008393137363237_REALK, &
      0.000000000000000_REALK,     -0.052392559772688_REALK,      0.000000000000000_REALK, &
     -0.088092420314111_REALK,      0.000000000000000_REALK,     -0.072211640864250_REALK, &
      0.000000000000000_REALK,     -0.007794562870140_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.049344086541291_REALK,      0.000000000000000_REALK, &
     -0.021381820419342_REALK,      0.000000000000000_REALK,     -0.004500114203810_REALK, &
      0.000000000000000_REALK,      0.053518706239223_REALK,      0.000000000000000_REALK, &
      0.022009353063383_REALK,      0.000000000000000_REALK,      0.094889931688548_REALK, &
      0.000000000000000_REALK,     -0.110349893145570_REALK,      0.000000000000000_REALK, &
     -0.079899495116732_REALK,      0.000000000000000_REALK,     -0.081261795578802_REALK, &
     -0.043784310713606_REALK,      0.000000000000000_REALK,     -0.062827469753346_REALK, &
      0.000000000000000_REALK,      0.019349533093988_REALK,      0.000000000000000_REALK, &
     -0.068384421516178_REALK,      0.000000000000000_REALK,      0.017695470663138_REALK, &
      0.000000000000000_REALK,      0.153253164275562_REALK,      0.000000000000000_REALK, &
      0.052655701980762_REALK,      0.000000000000000_REALK,     -0.096102426931858_REALK, &
      0.000000000000000_REALK,      0.109340127718411_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.004515832181081_REALK,      0.000000000000000_REALK, &
      0.019453369183892_REALK,      0.000000000000000_REALK,     -0.059744132296878_REALK, &
      0.000000000000000_REALK,     -0.071707712651228_REALK,      0.000000000000000_REALK, &
      0.007673069075851_REALK,      0.000000000000000_REALK,      0.111056467134271_REALK, &
      0.000000000000000_REALK,     -0.065291927805443_REALK,      0.000000000000000_REALK, &
      0.146714425362068_REALK,      0.000000000000000_REALK,      0.079563305797438_REALK, &
      0.052043699066469_REALK,      0.000000000000000_REALK,      0.082420956053712_REALK, &
      0.000000000000000_REALK,      0.021686144854974_REALK,      0.000000000000000_REALK, &
      0.052991296703704_REALK,      0.000000000000000_REALK,      0.004761557609857_REALK, &
      0.000000000000000_REALK,     -0.205462751021305_REALK,      0.000000000000000_REALK, &
      0.000393608332111_REALK,      0.000000000000000_REALK,     -0.028513019639788_REALK, &
      0.000000000000000_REALK,      0.182065378416090_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.039350224511548_REALK,      0.000000000000000_REALK, &
     -0.038549028878924_REALK,      0.000000000000000_REALK,     -0.099482449113681_REALK, &
      0.000000000000000_REALK,      0.200965072367411_REALK,      0.000000000000000_REALK, &
     -0.305907500467742_REALK,      0.000000000000000_REALK,      0.059116340588066_REALK, &
      0.000000000000000_REALK,     -0.081559688324868_REALK,      0.000000000000000_REALK, &
      0.058663957880079_REALK,      0.000000000000000_REALK,     -0.338568754305415_REALK, &
     -0.163053906417852_REALK,      0.000000000000000_REALK,      0.005012997029676_REALK, &
      0.000000000000000_REALK,      0.038817352038487_REALK,      0.000000000000000_REALK, &
     -0.065365776141699_REALK,      0.000000000000000_REALK,      0.008284652259266_REALK, &
      0.037518221242093_REALK,      0.000000000000000_REALK,      0.034438248837846_REALK, &
      0.000000000000000_REALK,     -0.033972640185297_REALK,      0.000000000000000_REALK, &
      0.161964106236714_REALK,      0.000000000000000_REALK,     -0.392175351282081_REALK, &
      0.156510986396623_REALK,      0.000000000000000_REALK,      0.116821313853568_REALK, &
      0.000000000000000_REALK,      0.068595469419345_REALK,      0.000000000000000_REALK, &
     -0.029517988847773_REALK,      0.000000000000000_REALK,     -0.107593325904448_REALK, &
      0.000000000000000_REALK,     -0.282975530154336_REALK,      0.000000000000000_REALK, &
      0.101202792614176_REALK,      0.000000000000000_REALK,     -0.055568282920905_REALK, &
      0.000000000000000_REALK,      0.036360885179511_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.206929444465882_REALK,      0.000000000000000_REALK, &
      0.135014061218470_REALK,      0.000000000000000_REALK,     -0.391305961293784_REALK, &
      0.000000000000000_REALK,      0.273193368190327_REALK,      0.000000000000000_REALK, &
      0.076265352202248_REALK,      0.000000000000000_REALK,     -0.024378476495390_REALK, &
      0.000000000000000_REALK,     -0.142219218875321_REALK,      0.000000000000000_REALK, &
      0.304053307370285_REALK,      0.000000000000000_REALK,      0.033719995147471_REALK, &
      0.046683392405504_REALK,      0.000000000000000_REALK,      0.051350789399852_REALK, &
      0.000000000000000_REALK,     -0.281699236014113_REALK,      0.000000000000000_REALK, &
      0.381354324939051_REALK,      0.000000000000000_REALK,      0.043600125676722_REALK, &
      0.000000000000000_REALK,      0.136712061049800_REALK,      0.000000000000000_REALK, &
      0.039774020041487_REALK,      0.000000000000000_REALK,     -0.038895636137997_REALK, &
      0.000000000000000_REALK,      0.005708515905883_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.023823021634371_REALK,      0.000000000000000_REALK, &
      0.144124333682990_REALK,      0.000000000000000_REALK,      0.023401962596882_REALK, &
      0.000000000000000_REALK,      0.020043573797916_REALK,      0.000000000000000_REALK, &
      0.013558492912436_REALK,      0.000000000000000_REALK,     -0.031877410439798_REALK, &
      0.000000000000000_REALK,     -0.025904426415367_REALK,      0.000000000000000_REALK, &
      0.024960158130109_REALK,      0.000000000000000_REALK,      0.015688661016197_REALK, &
     -0.019644722764757_REALK,      0.000000000000000_REALK,     -0.175444887684224_REALK, &
      0.000000000000000_REALK,      0.050939168883393_REALK,      0.000000000000000_REALK, &
     -0.037567140187790_REALK,      0.000000000000000_REALK,      0.029211371355019_REALK, &
      0.000000000000000_REALK,     -0.129552055405002_REALK,      0.000000000000000_REALK, &
     -0.048679234552097_REALK,      0.000000000000000_REALK,     -0.008957695772100_REALK, &
      0.000000000000000_REALK,      0.124906589069321_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.071291427169428_REALK,      0.000000000000000_REALK, &
     -0.079077296462281_REALK,      0.000000000000000_REALK,     -0.023008229415483_REALK, &
      0.000000000000000_REALK,      0.099777853693470_REALK,      0.000000000000000_REALK, &
     -0.102721697436690_REALK,      0.000000000000000_REALK,     -0.128986025923035_REALK, &
      0.000000000000000_REALK,      0.033939535940255_REALK,      0.000000000000000_REALK, &
     -0.161749094581386_REALK,      0.000000000000000_REALK,      0.030070956705191_REALK, &
     -0.053594178197192_REALK,      0.000000000000000_REALK,     -0.340138174817934_REALK, &
      0.000000000000000_REALK,      0.125918708763147_REALK,      0.000000000000000_REALK, &
     -0.118149767087870_REALK,      0.000000000000000_REALK,      0.120770197954257_REALK, &
      0.000000000000000_REALK,      0.031961386752765_REALK,      0.000000000000000_REALK, &
      0.044238517609506_REALK,      0.000000000000000_REALK,     -0.141342372359368_REALK, &
      0.000000000000000_REALK,     -0.151776601520854_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.217528347568604_REALK,      0.000000000000000_REALK, &
      0.089357232978504_REALK,      0.000000000000000_REALK,     -0.195341507531070_REALK, &
      0.000000000000000_REALK,     -0.292256714683161_REALK,      0.000000000000000_REALK, &
      0.130313629139571_REALK,      0.000000000000000_REALK,      0.189717751733822_REALK, &
      0.000000000000000_REALK,      0.038498396506135_REALK,      0.000000000000000_REALK, &
      0.134052498894732_REALK,      0.000000000000000_REALK,      0.024127872766241_REALK, &
      0.000290260981437_REALK,      0.000000000000000_REALK,      0.293107746998212_REALK, &
      0.000000000000000_REALK,      0.222877740723576_REALK,      0.000000000000000_REALK, &
     -0.019997577945709_REALK,      0.000000000000000_REALK,     -0.143378786580104_REALK, &
      0.000000000000000_REALK,     -0.098555148789816_REALK,      0.000000000000000_REALK, &
     -0.094348311145522_REALK,      0.000000000000000_REALK,     -0.240895883187504_REALK, &
      0.000000000000000_REALK,      0.464022775976619_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.050083980613176_REALK,      0.000000000000000_REALK, &
     -0.041259538693190_REALK,      0.000000000000000_REALK,     -0.076346541545266_REALK, &
      0.000000000000000_REALK,      0.535094223483070_REALK,      0.000000000000000_REALK, &
     -0.383253961486073_REALK,      0.000000000000000_REALK,      0.014909101646956_REALK, &
      0.000000000000000_REALK,      0.080553868366866_REALK,      0.000000000000000_REALK, &
     -0.144704565593864_REALK,      0.000000000000000_REALK,     -0.010276287028979_REALK, &
     -0.454847657841652_REALK,      0.000000000000000_REALK,      0.036318595642620_REALK, &
      0.000000000000000_REALK,      0.145455592963228_REALK,      0.000000000000000_REALK, &
     -0.201361809240886_REALK,      0.000000000000000_REALK,      0.266738999776154_REALK/
  ! results of test 8, ket-major order, SQHDR002
  data REF_CONTR_INTS(24949:25344) /                                                       &
     -0.090814369625795_REALK,      0.000000000000000_REALK,      0.033902330115830_REALK, &
      0.000000000000000_REALK,      0.025598789094933_REALK,      0.000000000000000_REALK, &
      0.034356480303109_REALK,      0.000000000000000_REALK,      0.528781378778865_REALK, &
     -0.100283848390972_REALK,      0.000000000000000_REALK,     -0.057880739293964_REALK, &
      0.000000000000000_REALK,      0.026014520116425_REALK,      0.000000000000000_REALK, &
      0.048741979336563_REALK,      0.000000000000000_REALK,      0.180389239901961_REALK, &
      0.000000000000000_REALK,      0.296029679845542_REALK,      0.000000000000000_REALK, &
     -0.040916258649342_REALK,      0.000000000000000_REALK,     -0.029704712312351_REALK, &
      0.000000000000000_REALK,     -0.157930226071824_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.234952237060658_REALK,      0.000000000000000_REALK, &
      0.089212139068105_REALK,      0.000000000000000_REALK,      0.044777330434753_REALK, &
      0.000000000000000_REALK,      0.053920378351878_REALK,      0.000000000000000_REALK, &
      0.094775581604103_REALK,      0.000000000000000_REALK,     -0.109179150494494_REALK, &
      0.000000000000000_REALK,      0.064136520564888_REALK,      0.000000000000000_REALK, &
     -0.109100874300936_REALK,      0.000000000000000_REALK,      0.023346248411419_REALK, &
     -0.005705667305763_REALK,      0.000000000000000_REALK,     -0.030492266805699_REALK, &
      0.000000000000000_REALK,     -0.046036444325121_REALK,      0.000000000000000_REALK, &
     -0.113468544992181_REALK,      0.000000000000000_REALK,      0.012650428941709_REALK, &
      0.000000000000000_REALK,     -0.030039480599330_REALK,      0.000000000000000_REALK, &
     -0.034168663560976_REALK,      0.000000000000000_REALK,      0.089102807570017_REALK, &
      0.000000000000000_REALK,     -0.150475380812364_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.045622507344164_REALK,      0.000000000000000_REALK, &
     -0.053621544573043_REALK,      0.000000000000000_REALK,      0.019281813724385_REALK, &
      0.000000000000000_REALK,     -0.014352801185518_REALK,      0.000000000000000_REALK, &
      0.044399870566668_REALK,      0.000000000000000_REALK,     -0.012834506095905_REALK, &
      0.000000000000000_REALK,     -0.048309672196585_REALK,      0.000000000000000_REALK, &
      0.101120518306900_REALK,      0.000000000000000_REALK,     -0.038543310309181_REALK, &
      0.009533617111689_REALK,      0.000000000000000_REALK,     -0.079893430201798_REALK, &
      0.000000000000000_REALK,      0.022920727289821_REALK,      0.000000000000000_REALK, &
      0.031474204966874_REALK,      0.000000000000000_REALK,      0.044094258977032_REALK, &
      0.000000000000000_REALK,     -0.017861612541325_REALK,      0.000000000000000_REALK, &
     -0.026647041549531_REALK,      0.000000000000000_REALK,     -0.088092420314111_REALK, &
      0.000000000000000_REALK,      0.046812288815508_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.062420783236996_REALK,      0.000000000000000_REALK, &
      0.006559339907596_REALK,      0.000000000000000_REALK,     -0.021381820419342_REALK, &
      0.000000000000000_REALK,     -0.014922385468500_REALK,      0.000000000000000_REALK, &
      0.029402544521619_REALK,      0.000000000000000_REALK,      0.103829528822969_REALK, &
      0.000000000000000_REALK,     -0.119945600365518_REALK,      0.000000000000000_REALK, &
      0.053862218892226_REALK,      0.000000000000000_REALK,     -0.042296330249361_REALK, &
      0.004134284218545_REALK,      0.000000000000000_REALK,     -0.019141583964691_REALK, &
      0.000000000000000_REALK,     -0.006904376310866_REALK,      0.000000000000000_REALK, &
      0.008532980224226_REALK,      0.000000000000000_REALK,      0.008393137363237_REALK, &
      0.000000000000000_REALK,     -0.087311089268725_REALK,      0.000000000000000_REALK, &
      0.105664594654231_REALK,      0.000000000000000_REALK,      0.052655701980762_REALK, &
      0.000000000000000_REALK,      0.117861726803690_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.033249382090701_REALK,      0.000000000000000_REALK, &
      0.042071110992997_REALK,      0.000000000000000_REALK,      0.019453369183892_REALK, &
      0.000000000000000_REALK,     -0.043493600011512_REALK,      0.000000000000000_REALK, &
      0.027267122512817_REALK,      0.000000000000000_REALK,     -0.140074404706119_REALK, &
      0.000000000000000_REALK,      0.038105580705936_REALK,      0.000000000000000_REALK, &
      0.147949749215238_REALK,      0.000000000000000_REALK,     -0.103016479497200_REALK, &
      0.030896818556053_REALK,      0.000000000000000_REALK,     -0.133971233112661_REALK, &
      0.000000000000000_REALK,      0.028308036254969_REALK,      0.000000000000000_REALK, &
      0.079605834155361_REALK,      0.000000000000000_REALK,      0.044180826467113_REALK, &
      0.000000000000000_REALK,     -0.114924386913575_REALK,      0.000000000000000_REALK, &
     -0.131874551219042_REALK,      0.000000000000000_REALK,      0.000393608332110_REALK, &
      0.000000000000000_REALK,     -0.368739552616067_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.001854555139205_REALK,      0.000000000000000_REALK, &
      0.002353051783535_REALK,      0.000000000000000_REALK,     -0.038549028878924_REALK, &
      0.000000000000000_REALK,     -0.168446286327456_REALK,      0.000000000000000_REALK, &
      0.572507375306939_REALK,      0.000000000000000_REALK,      0.063095694053597_REALK, &
      0.000000000000000_REALK,     -0.071970409787431_REALK,      0.000000000000000_REALK, &
     -0.054328923228208_REALK,      0.000000000000000_REALK,      0.036837007096452_REALK, &
      0.158300252411724_REALK,      0.000000000000000_REALK,     -0.014004694000661_REALK, &
      0.000000000000000_REALK,      0.024714155555700_REALK,      0.000000000000000_REALK, &
      0.060900195343330_REALK,      0.000000000000000_REALK,      0.108148736292108_REALK, &
     -0.251957925687603_REALK,      0.000000000000000_REALK,     -0.133668930702924_REALK, &
      0.000000000000000_REALK,      0.067271986612029_REALK,      0.000000000000000_REALK, &
      0.122766094213872_REALK,      0.000000000000000_REALK,      0.436747988477135_REALK, &
     -0.044055065936340_REALK,      0.000000000000000_REALK,     -0.137221157045140_REALK, &
      0.000000000000000_REALK,     -0.040135125106262_REALK,      0.000000000000000_REALK, &
     -0.013420852712362_REALK,      0.000000000000000_REALK,      0.378452234327264_REALK, &
      0.000000000000000_REALK,      0.548497904046468_REALK,      0.000000000000000_REALK, &
      0.200742198196494_REALK,      0.000000000000000_REALK,      0.101202792614176_REALK, &
      0.000000000000000_REALK,      0.109113849501558_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.610141280234110_REALK,      0.000000000000000_REALK, &
      0.246642482404748_REALK,      0.000000000000000_REALK,      0.135014061218469_REALK, &
      0.000000000000000_REALK,      0.240941418190375_REALK,      0.000000000000000_REALK, &
     -0.001720678227880_REALK,      0.000000000000000_REALK,     -0.077062261183436_REALK, &
      0.000000000000000_REALK,     -0.093182289816150_REALK,      0.000000000000000_REALK, &
     -0.257183095090554_REALK,      0.000000000000000_REALK,      0.031219311498693_REALK, &
     -0.146937932498505_REALK,      0.000000000000000_REALK,     -0.034703003901670_REALK, &
      0.000000000000000_REALK,     -0.294425009540685_REALK,      0.000000000000000_REALK, &
     -0.437644688437441_REALK,      0.000000000000000_REALK,      0.034113834045306_REALK, &
      0.000000000000000_REALK,      0.112066605245788_REALK,      0.000000000000000_REALK, &
     -0.127372671357010_REALK,      0.000000000000000_REALK,      0.039774020041487_REALK, &
      0.000000000000000_REALK,     -0.053905331476937_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.009388578255103_REALK,      0.000000000000000_REALK, &
     -0.155312503360125_REALK,      0.000000000000000_REALK,      0.144124333682990_REALK, &
      0.000000000000000_REALK,      0.177719428795616_REALK,      0.000000000000000_REALK, &
      0.030724886518225_REALK,      0.000000000000000_REALK,     -0.178906342183252_REALK, &
      0.000000000000000_REALK,      0.047338246134448_REALK,      0.000000000000000_REALK, &
      0.082122536843502_REALK,      0.000000000000000_REALK,      0.099814397831324_REALK, &
     -0.065223673918006_REALK,      0.000000000000000_REALK,     -0.265003894442354_REALK, &
      0.000000000000000_REALK,      0.099571120499361_REALK,      0.000000000000000_REALK, &
     -0.038350961442507_REALK,      0.000000000000000_REALK,      0.093582335864592_REALK, &
      0.000000000000000_REALK,     -0.152192190662253_REALK,      0.000000000000000_REALK, &
      0.016220972374429_REALK,      0.000000000000000_REALK,     -0.048679234552097_REALK, &
      0.000000000000000_REALK,     -0.024046697289345_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.042506237640157_REALK,      0.000000000000000_REALK, &
      0.017893420412589_REALK,      0.000000000000000_REALK,     -0.079077296462281_REALK, &
      0.000000000000000_REALK,     -0.150160987613774_REALK,      0.000000000000000_REALK, &
      0.013558492912436_REALK,      0.000000000000000_REALK,     -0.031877410439798_REALK, &
      0.000000000000000_REALK,     -0.025904426415366_REALK,      0.000000000000000_REALK, &
      0.024960158130109_REALK,      0.000000000000000_REALK,      0.015688661016197_REALK, &
     -0.019644722764756_REALK,      0.000000000000000_REALK,     -0.175444887684224_REALK, &
      0.000000000000000_REALK,      0.050939168883393_REALK,      0.000000000000000_REALK, &
     -0.037567140187790_REALK,      0.000000000000000_REALK,      0.029211371355019_REALK, &
      0.000000000000000_REALK,     -0.082548810257711_REALK,      0.000000000000000_REALK, &
      0.098342368597790_REALK,      0.000000000000000_REALK,      0.044238517609506_REALK, &
      0.000000000000000_REALK,     -0.085813734398905_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.015479481147804_REALK,      0.000000000000000_REALK, &
      0.161227046185623_REALK,      0.000000000000000_REALK,      0.089357232978504_REALK, &
      0.000000000000000_REALK,     -0.246960499621623_REALK,      0.000000000000000_REALK, &
      0.081650800673011_REALK,      0.000000000000000_REALK,     -0.307718615432339_REALK, &
      0.000000000000000_REALK,      0.069227236764713_REALK,      0.000000000000000_REALK, &
      0.191397816819898_REALK,      0.000000000000000_REALK,      0.098314312219980_REALK, &
     -0.040180125088926_REALK,      0.000000000000000_REALK,     -0.423353564653295_REALK, &
      0.000000000000000_REALK,     -0.005047090631265_REALK,      0.000000000000000_REALK, &
      0.122949581842510_REALK,      0.000000000000000_REALK,      0.103628067803220_REALK, &
      0.000000000000000_REALK,     -0.002149923383738_REALK,      0.000000000000000_REALK, &
     -0.021004126194546_REALK,      0.000000000000000_REALK,     -0.094348311145522_REALK, &
      0.000000000000000_REALK,     -0.413581870077142_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.079987425450073_REALK,      0.000000000000000_REALK, &
      0.337325701653716_REALK,      0.000000000000000_REALK,     -0.041259538693190_REALK, &
      0.000000000000000_REALK,     -0.286863931430606_REALK,      0.000000000000000_REALK, &
      0.404891587435478_REALK,      0.000000000000000_REALK,     -0.026375111025739_REALK, &
      0.000000000000000_REALK,      0.047968777827186_REALK,      0.000000000000000_REALK, &
      0.130406229553323_REALK,      0.000000000000000_REALK,      0.243036535891595_REALK, &
      0.134814800955295_REALK,      0.000000000000000_REALK,     -0.046978364844328_REALK, &
      0.000000000000000_REALK,      0.126975706646250_REALK,      0.000000000000000_REALK, &
      0.268520702679649_REALK,      0.000000000000000_REALK,      0.391309397873544_REALK/
  ! results of test 8, ket-major order, SQHDR003
  data REF_CONTR_INTS(25345:25740) /                                                       &
      0.000000000000000_REALK,     -0.119408803430892_REALK,      0.000000000000000_REALK, &
     -0.051095849541178_REALK,      0.000000000000000_REALK,      0.041177401077306_REALK, &
      0.000000000000000_REALK,     -0.204571592354560_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.035621603444357_REALK,      0.000000000000000_REALK, &
      0.014903935480409_REALK,      0.000000000000000_REALK,     -0.023375976038296_REALK, &
      0.000000000000000_REALK,     -0.044679998181525_REALK,      0.000000000000000_REALK, &
     -0.148707961041400_REALK,      0.000000000000000_REALK,     -0.160997094930544_REALK, &
      0.000000000000000_REALK,      0.050309377102597_REALK,      0.000000000000000_REALK, &
      0.197797709587243_REALK,      0.000000000000000_REALK,     -0.203011171337462_REALK, &
     -0.021418115053691_REALK,      0.000000000000000_REALK,     -0.062555734981275_REALK, &
      0.000000000000000_REALK,     -0.034113581870999_REALK,      0.000000000000000_REALK, &
      0.113037798887674_REALK,      0.000000000000000_REALK,     -0.073467160960582_REALK, &
      0.000000000000000_REALK,     -0.176380954019944_REALK,      0.000000000000000_REALK, &
      0.231271903915932_REALK,      0.000000000000000_REALK,      0.192599826632614_REALK, &
      0.000000000000000_REALK,      0.213698307372406_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.065403878352583_REALK,      0.000000000000000_REALK, &
      0.080092948382882_REALK,      0.000000000000000_REALK,      0.006115308465413_REALK, &
      0.000000000000000_REALK,      0.104748049763248_REALK,      0.000000000000000_REALK, &
     -0.053466592867691_REALK,      0.000000000000000_REALK,      0.329069950260810_REALK, &
      0.000000000000000_REALK,     -0.322817922099215_REALK,      0.000000000000000_REALK, &
      0.144805270177500_REALK,      0.000000000000000_REALK,      0.033753883151258_REALK, &
      0.013986387843992_REALK,      0.000000000000000_REALK,      0.104759039977911_REALK, &
      0.000000000000000_REALK,     -0.133583620914307_REALK,      0.000000000000000_REALK, &
      0.086175539450124_REALK,      0.000000000000000_REALK,     -0.015286086785642_REALK, &
      0.000000000000000_REALK,      0.159838792763440_REALK,      0.000000000000000_REALK, &
     -0.147021918038664_REALK,      0.000000000000000_REALK,     -0.292268370666804_REALK, &
      0.000000000000000_REALK,      0.042584334036157_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.011146572339996_REALK,      0.000000000000000_REALK, &
     -0.034890598902438_REALK,      0.000000000000000_REALK,     -0.173211929228240_REALK, &
      0.000000000000000_REALK,      0.063594308395330_REALK,      0.000000000000000_REALK, &
     -0.001972923717340_REALK,      0.000000000000000_REALK,     -0.279669881956683_REALK, &
      0.000000000000000_REALK,      0.304016764155133_REALK,      0.000000000000000_REALK, &
     -0.072327710297397_REALK,      0.000000000000000_REALK,      0.003559239544518_REALK, &
     -0.022721629080529_REALK,      0.000000000000000_REALK,     -0.077556243658972_REALK, &
      0.000000000000000_REALK,      0.182572064954986_REALK,      0.000000000000000_REALK, &
     -0.020057453036682_REALK,      0.000000000000000_REALK,      0.040990799607970_REALK, &
      0.000000000000000_REALK,      0.123077253662694_REALK,      0.000000000000000_REALK, &
     -0.292268370666804_REALK,      0.000000000000000_REALK,     -0.298193734573095_REALK, &
      0.000000000000000_REALK,     -0.139021861991318_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.058455247874722_REALK,      0.000000000000000_REALK, &
     -0.173211929228240_REALK,      0.000000000000000_REALK,     -0.124482099779274_REALK, &
      0.000000000000000_REALK,     -0.020417659339387_REALK,      0.000000000000000_REALK, &
      0.095853588981396_REALK,      0.000000000000000_REALK,      0.144805270177500_REALK, &
      0.000000000000000_REALK,     -0.083486577049495_REALK,      0.000000000000000_REALK, &
     -0.193399965165305_REALK,      0.000000000000000_REALK,      0.069526704530096_REALK, &
     -0.013780721974206_REALK,      0.000000000000000_REALK,      0.086175539450124_REALK, &
      0.000000000000000_REALK,     -0.034547150255757_REALK,      0.000000000000000_REALK, &
     -0.206169745646511_REALK,      0.000000000000000_REALK,     -0.013597073166231_REALK, &
      0.000000000000000_REALK,      0.213698307372406_REALK,      0.000000000000000_REALK, &
      0.042237956775083_REALK,      0.000000000000000_REALK,     -0.192385593789357_REALK, &
      0.000000000000000_REALK,      0.229204604274978_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.104748049763248_REALK,      0.000000000000000_REALK, &
      0.095489646004897_REALK,      0.000000000000000_REALK,     -0.103206775114424_REALK, &
      0.000000000000000_REALK,      0.133401141518235_REALK,      0.000000000000000_REALK, &
     -0.203011171337462_REALK,      0.000000000000000_REALK,      0.153566432056267_REALK, &
      0.000000000000000_REALK,     -0.090760287825555_REALK,      0.000000000000000_REALK, &
      0.172436106542956_REALK,      0.000000000000000_REALK,      0.105001738503804_REALK, &
     -0.073467160960582_REALK,      0.000000000000000_REALK,      0.038983469138901_REALK, &
      0.000000000000000_REALK,      0.061542374159363_REALK,      0.000000000000000_REALK, &
      0.081707529485793_REALK,      0.000000000000000_REALK,      0.070396198468813_REALK, &
      0.000000000000000_REALK,     -0.158585831087377_REALK,      0.000000000000000_REALK, &
      0.013063326949997_REALK,      0.000000000000000_REALK,      0.000376846311623_REALK, &
      0.000000000000000_REALK,      0.107516050462758_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.086742054635898_REALK,      0.000000000000000_REALK, &
     -0.040401628723591_REALK,      0.000000000000000_REALK,     -0.045618947812683_REALK, &
      0.000000000000000_REALK,      0.046499615093161_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.090164585206883_REALK,      0.000000000000000_REALK, &
      0.025361045119409_REALK,      0.000000000000000_REALK,     -0.047407789630480_REALK, &
      0.000000000000000_REALK,     -0.119287749348849_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.040142591087036_REALK,      0.000000000000000_REALK, &
      0.149366948013994_REALK,      0.000000000000000_REALK,     -0.136789221716837_REALK, &
      0.000000000000000_REALK,     -0.004323011673665_REALK,      0.000000000000000_REALK, &
     -0.061469386689034_REALK,      0.000000000000000_REALK,     -0.152082488118773_REALK, &
      0.000000000000000_REALK,     -0.071100033594918_REALK,      0.000000000000000_REALK, &
      0.275226983300812_REALK,      0.000000000000000_REALK,     -0.181067779468744_REALK, &
      0.012025048631064_REALK,      0.000000000000000_REALK,     -0.132536755665305_REALK, &
      0.000000000000000_REALK,     -0.175147019035706_REALK,      0.000000000000000_REALK, &
      0.149637397187710_REALK,      0.000000000000000_REALK,     -0.119129076756403_REALK, &
      0.000000000000000_REALK,     -0.154349581794645_REALK,      0.000000000000000_REALK, &
      0.199184900091616_REALK,      0.000000000000000_REALK,      0.031784065386022_REALK, &
      0.000000000000000_REALK,      0.252751936373717_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.234971223497940_REALK,      0.000000000000000_REALK, &
      0.106262424779549_REALK,      0.000000000000000_REALK,     -0.155452701495508_REALK, &
      0.000000000000000_REALK,      0.210743420325301_REALK,      0.000000000000000_REALK, &
      0.029276600004426_REALK,      0.000000000000000_REALK,      0.262679681557968_REALK, &
      0.000000000000000_REALK,     -0.327504632269893_REALK,      0.000000000000000_REALK, &
      0.204012605382803_REALK,      0.000000000000000_REALK,     -0.037603263103146_REALK, &
      0.054410596551981_REALK,      0.000000000000000_REALK,      0.117208181443734_REALK, &
      0.000000000000000_REALK,     -0.204055923359347_REALK,      0.000000000000000_REALK, &
      0.217086573445956_REALK,      0.000000000000000_REALK,      0.003767109800918_REALK, &
      0.000000000000000_REALK,     -0.009328082130717_REALK,      0.000000000000000_REALK, &
     -0.092133729114273_REALK,      0.000000000000000_REALK,     -0.408486160998098_REALK, &
      0.000000000000000_REALK,      0.149012655602549_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.186700883671519_REALK,      0.000000000000000_REALK, &
      0.024051395238044_REALK,      0.000000000000000_REALK,     -0.480766295345317_REALK, &
      0.000000000000000_REALK,      0.124855373031126_REALK,      0.000000000000000_REALK, &
     -0.054305359805984_REALK,      0.000000000000000_REALK,     -0.201955476198693_REALK, &
      0.000000000000000_REALK,      0.431508088514162_REALK,      0.000000000000000_REALK, &
     -0.052229353669675_REALK,      0.000000000000000_REALK,      0.097969213103357_REALK, &
     -0.027884600509700_REALK,      0.000000000000000_REALK,      0.039401488198990_REALK, &
      0.000000000000000_REALK,      0.483086183095003_REALK,      0.000000000000000_REALK, &
      0.010189940381869_REALK,      0.000000000000000_REALK,      0.050305022918487_REALK, &
      0.000000000000000_REALK,     -0.120690704390340_REALK,      0.000000000000000_REALK, &
     -0.408486160998098_REALK,      0.000000000000000_REALK,     -0.303417607853439_REALK, &
      0.000000000000000_REALK,     -0.060422104594150_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.274575557391323_REALK,      0.000000000000000_REALK, &
     -0.480766295345317_REALK,      0.000000000000000_REALK,     -0.224618394209465_REALK, &
      0.000000000000000_REALK,      0.083400791372380_REALK,      0.000000000000000_REALK, &
     -0.019039680101700_REALK,      0.000000000000000_REALK,      0.204012605382803_REALK, &
      0.000000000000000_REALK,     -0.084698645410596_REALK,      0.000000000000000_REALK, &
     -0.473415410489150_REALK,      0.000000000000000_REALK,     -0.024475720324368_REALK, &
     -0.164221606816866_REALK,      0.000000000000000_REALK,      0.217086573445957_REALK, &
      0.000000000000000_REALK,     -0.052772567449679_REALK,      0.000000000000000_REALK, &
     -0.666058916013591_REALK,      0.000000000000000_REALK,     -0.097855529355452_REALK, &
      0.000000000000000_REALK,      0.252751936373717_REALK,      0.000000000000000_REALK, &
      0.215351788050640_REALK,      0.000000000000000_REALK,     -0.246658846774569_REALK, &
      0.000000000000000_REALK,      0.325357237060081_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.210743420325301_REALK,      0.000000000000000_REALK, &
      0.344999675415476_REALK,      0.000000000000000_REALK,     -0.235688497696717_REALK, &
      0.000000000000000_REALK,      0.165006150401727_REALK,      0.000000000000000_REALK, &
     -0.181067779468744_REALK,      0.000000000000000_REALK,      0.094537522870483_REALK, &
      0.000000000000000_REALK,      0.128267529536721_REALK,      0.000000000000000_REALK, &
      0.198812063918508_REALK,      0.000000000000000_REALK,      0.164816938460873_REALK, &
     -0.119129076756404_REALK,      0.000000000000000_REALK,      0.133962664208251_REALK, &
      0.000000000000000_REALK,      0.315972782311553_REALK,      0.000000000000000_REALK, &
      0.136590526267972_REALK,      0.000000000000000_REALK,      0.160904551526614_REALK, &
      0.000000000000000_REALK,     -0.204616141392793_REALK,      0.000000000000000_REALK, &
     -0.093315812541997_REALK,      0.000000000000000_REALK,     -0.108181100006084_REALK, &
      0.000000000000000_REALK,      0.112232056958643_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.208781559305621_REALK,      0.000000000000000_REALK, &
     -0.091042612963534_REALK,      0.000000000000000_REALK,     -0.066838091235948_REALK, &
      0.000000000000000_REALK,      0.093019284485295_REALK,      0.000000000000000_REALK/
