  ! number of test cases
  integer, parameter :: NUM_TESTS = 8
  ! ID of block of sub-shells on bra center
  integer, parameter :: BRA_BLOCK(NUM_TESTS) = &
    (/13,    13,    13,    13,    13,    13,    13,    13/)
  ! ID of block of sub-shells on ket center
  integer, parameter :: KET_BLOCK(NUM_TESTS) = &
    (/7,    7,    7,    7,    7,    7,    7,    7/)
  ! order of partial magnetic derivatives on bra center
  integer, parameter :: ORDER_MAG_BRA(NUM_TESTS) = &
    (/0,    0,    0,    0,    0,    0,    0,    0/)
  ! order of partial magnetic derivatives on ket center
  integer, parameter :: ORDER_MAG_KET(NUM_TESTS) = &
    (/0,    0,    0,    0,    0,    0,    0,    0/)
  ! order of magnetic derivatives
  integer, parameter :: ORDER_MAG(NUM_TESTS) = &
    (/0,    0,    0,    0,    0,    0,    0,    0/)
  ! order of partial derivatives with respect to total rotational anuglar momentum on bra center
  integer, parameter :: ORDER_RAM_BRA(NUM_TESTS) = &
    (/0,    0,    0,    0,    0,    0,    0,    0/)
  ! order of partial derivatives with respect to total rotational anuglar momentum on ket center
  integer, parameter :: ORDER_RAM_KET(NUM_TESTS) = &
    (/0,    0,    0,    0,    0,    0,    0,    0/)
  ! order of derivatives with respect to total rotational anuglar momentum
  integer, parameter :: ORDER_RAM(NUM_TESTS) = &
    (/0,    0,    0,    0,    0,    0,    0,    0/)
  ! order of partial geometric derivatives on bra center
  integer, parameter :: ORDER_GEO_BRA(NUM_TESTS) = &
    (/0,    0,    1,    0,    0,    0,    0,    0/)
  ! order of partial geometric derivatives on ket center
  integer, parameter :: ORDER_GEO_KET(NUM_TESTS) = &
    (/0,    0,    0,    0,    0,    0,    0,    1/)
  ! numbers of differentiated centers of total geometric derivatives
  integer, parameter :: NUM_CENTS(NUM_TESTS) = &
    (/0,    0,    0,    1,    0,    0,    1,    0/)
  ! indices of differentiated centers
  integer, parameter :: IDX_CENT(3*NUM_TESTS) =                            &
    (/0, 0, 0,    0, 0, 0,    0, 0, 0,    1, 0, 0,    0, 0, 0,    0, 0, 0, &
      1, 0, 0,    0, 0, 0/)
  ! orders of geometric derivatives of differentiated centers
  integer, parameter :: ORDER_CENT(3*NUM_TESTS) =                          &
    (/0, 0, 0,    0, 0, 0,    0, 0, 0,    1, 0, 0,    0, 0, 0,    0, 0, 0, &
      1, 0, 0,    0, 0, 0/)
  ! coordinates of dipole origin
  real(REALK), parameter :: DIP_ORIGIN(3*NUM_TESTS) =                      &
    (/0.0_REALK, 0.0_REALK, 0.0_REALK,    0.0_REALK, 0.0_REALK, 0.0_REALK, &
      0.0_REALK, 0.0_REALK, 0.0_REALK,    0.0_REALK, 0.0_REALK, 0.0_REALK, &
      0.0_REALK, 0.0_REALK, 0.0_REALK,    0.0_REALK, 0.0_REALK, 0.0_REALK, &
      0.0_REALK, 0.0_REALK, 0.0_REALK,    0.0_REALK, 0.0_REALK, 0.0_REALK/)
  ! index of dipole origin
  integer, parameter :: IDX_DIPORG(NUM_TESTS) = &
    (/-1,    -1,    -1,    -1,    -1,    -1,    -1,    -1/)
  ! scale constant
  real(REALK), parameter :: SCAL_CONST(NUM_TESTS) =                      &
    (/1.0_REALK,    1.0_REALK,    1.0_REALK,   -1.0_REALK,    1.0_REALK, &
     -0.25_REALK,  -1.0_REALK,   -1.0_REALK/)
  ! order of geometric derivatives on dipole origin
  integer, parameter :: ORDER_GEO_MOM(NUM_TESTS) = &
    (/0,    0,    0,    0,    0,    0,    0,    0/)
  ! order of Cartesian multipole moments
  integer, parameter :: ORDER_MOM(NUM_TESTS) = &
    (/0,    3,    0,    1,    0,    0,    3,    0/)
  ! order of electronic derivatives
  integer, parameter :: ORDER_ELEC(NUM_TESTS) = &
    (/0,    0,    0,    0,    1,    2,    0,    0/)
  ! referenced results from Dalton
  real(REALK), parameter :: REF_CONTR_INTS(38220) = (/                                     &
    ! results of test 1, ket-major order, OVERLAP
    -87.914141587943590_REALK,    -80.568443078345581_REALK,      0.000000000000000_REALK, &
    -95.621092771099129_REALK,      0.000000000000000_REALK,    -20.858879212050208_REALK, &
   -160.079507296206970_REALK,      0.000000000000000_REALK,    -24.312705967448803_REALK, &
      0.000000000000000_REALK,   -287.258478803935589_REALK,      0.000000000000000_REALK, &
    -35.255482945151691_REALK,      0.000000000000000_REALK,    -23.071997160997167_REALK, &
  -1097.303513810786626_REALK,      0.000000000000000_REALK,   -113.440799546606755_REALK, &
      0.000000000000000_REALK,    -51.687805341358043_REALK,      0.000000000000000_REALK, &
    -66.737362404903720_REALK,    -40.313548259932148_REALK,      0.000000000000000_REALK, &
    -35.360320030275084_REALK,      0.000000000000000_REALK,    -14.179703859298275_REALK, &
    -38.128904238943477_REALK,      0.000000000000000_REALK,    -10.494777089718445_REALK, &
      0.000000000000000_REALK,    -44.669285290976944_REALK,      0.000000000000000_REALK, &
    -11.339386453767386_REALK,      0.000000000000000_REALK,    -13.641489250342838_REALK, &
    -76.774251783798547_REALK,      0.000000000000000_REALK,    -21.417650264878517_REALK, &
      0.000000000000000_REALK,    -17.685281269048939_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     16.596169898513217_REALK, &
      0.000000000000000_REALK,     14.821077573250705_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     19.805818692238010_REALK,      0.000000000000000_REALK, &
     12.961382300433945_REALK,      0.000000000000000_REALK,     31.293604614110816_REALK, &
      0.000000000000000_REALK,     14.258518541726607_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     90.647636539174442_REALK,      0.000000000000000_REALK, &
     33.375789818267911_REALK,      0.000000000000000_REALK,     36.403138065602725_REALK, &
    -72.517077714338342_REALK,    -31.414657032630057_REALK,      0.000000000000000_REALK, &
    -24.523179342179485_REALK,      0.000000000000000_REALK,    -13.276072445674236_REALK, &
    -23.113097370243636_REALK,      0.000000000000000_REALK,     -6.952232350304716_REALK, &
      0.000000000000000_REALK,    -29.101367701110089_REALK,      0.000000000000000_REALK, &
     -6.712871170145021_REALK,      0.000000000000000_REALK,    -10.902407399521477_REALK, &
    -60.875070996285473_REALK,      0.000000000000000_REALK,    -10.201603091543497_REALK, &
      0.000000000000000_REALK,     -9.205678568547004_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     12.696282697709222_REALK, &
      0.000000000000000_REALK,      7.533528140434150_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      7.006765221306541_REALK,      0.000000000000000_REALK, &
      8.429266683504990_REALK,      0.000000000000000_REALK,      7.492229276703862_REALK, &
      0.000000000000000_REALK,      6.186588185539336_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     12.182804825046158_REALK,      0.000000000000000_REALK, &
      9.277887329210884_REALK,      0.000000000000000_REALK,     18.602446846565307_REALK, &
    -16.940489024900216_REALK,    -13.270558583018346_REALK,      0.000000000000000_REALK, &
    -14.217328408860441_REALK,      0.000000000000000_REALK,     -9.304146001815070_REALK, &
    -19.336755242751298_REALK,      0.000000000000000_REALK,     -8.810537698213095_REALK, &
      0.000000000000000_REALK,    -31.709962014671344_REALK,      0.000000000000000_REALK, &
    -11.675373652897765_REALK,      0.000000000000000_REALK,    -12.734387451748246_REALK, &
    -82.556517550341738_REALK,      0.000000000000000_REALK,    -25.604430973258893_REALK, &
      0.000000000000000_REALK,    -19.443869244449903_REALK,      0.000000000000000_REALK, &
    -91.761869412650611_REALK,    -27.398305237216171_REALK,      0.000000000000000_REALK, &
    -18.808504130789721_REALK,      0.000000000000000_REALK,    -14.866671052312684_REALK, &
    -12.494787041676425_REALK,      0.000000000000000_REALK,     -5.194216105414232_REALK, &
      0.000000000000000_REALK,    -11.510645383909674_REALK,      0.000000000000000_REALK, &
     -4.350866633294892_REALK,      0.000000000000000_REALK,    -10.317072944220758_REALK, &
    -10.915712214969314_REALK,      0.000000000000000_REALK,     -4.314859246509659_REALK, &
      0.000000000000000_REALK,     -5.381198891039826_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     13.488699345176316_REALK, &
      0.000000000000000_REALK,      5.856817909275633_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.723604742719658_REALK,      0.000000000000000_REALK, &
      7.671629917236889_REALK,      0.000000000000000_REALK,      4.504194197851100_REALK, &
      0.000000000000000_REALK,      4.064475320560440_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      7.071579247328128_REALK,      0.000000000000000_REALK, &
      4.893646334186626_REALK,      0.000000000000000_REALK,     13.246325517104784_REALK, &
    -14.610144241125054_REALK,     -7.654183608183884_REALK,      0.000000000000000_REALK, &
     -5.902758418659458_REALK,      0.000000000000000_REALK,     -7.101126312593482_REALK, &
     -5.272010865094090_REALK,      0.000000000000000_REALK,     -4.353278433888923_REALK, &
      0.000000000000000_REALK,     -5.378930969389726_REALK,      0.000000000000000_REALK, &
     -4.096356807999005_REALK,      0.000000000000000_REALK,     -8.213320239991390_REALK, &
     -6.526161870223057_REALK,      0.000000000000000_REALK,     -5.461794127360781_REALK, &
      0.000000000000000_REALK,     -7.516648199142290_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      9.453159328231889_REALK, &
      0.000000000000000_REALK,      7.422323130351196_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      8.215538323620263_REALK,      0.000000000000000_REALK, &
      8.960728045881480_REALK,      0.000000000000000_REALK,     11.304824192251800_REALK, &
      0.000000000000000_REALK,      8.584823605539436_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     23.116388716117907_REALK,      0.000000000000000_REALK, &
     14.185472462430695_REALK,      0.000000000000000_REALK,     21.661030391863147_REALK, &
   -154.152075412601164_REALK,    -28.899120800595718_REALK,      0.000000000000000_REALK, &
    -19.833638681379700_REALK,      0.000000000000000_REALK,    -20.474650581670257_REALK, &
     -9.962138932095463_REALK,      0.000000000000000_REALK,     -4.504501851980001_REALK, &
      0.000000000000000_REALK,    -10.226459475780302_REALK,      0.000000000000000_REALK, &
     -3.759237037353116_REALK,      0.000000000000000_REALK,    -11.642200308772203_REALK, &
    -11.599919654812158_REALK,      0.000000000000000_REALK,     -2.654755821522001_REALK, &
      0.000000000000000_REALK,     -3.601140055196517_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     18.450985004960099_REALK, &
      0.000000000000000_REALK,      5.322620656970363_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.638498665984715_REALK,      0.000000000000000_REALK, &
      8.627857231281382_REALK,      0.000000000000000_REALK,      2.426787072380425_REALK, &
      0.000000000000000_REALK,      3.026523730350401_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.565181570965344_REALK,      0.000000000000000_REALK, &
      2.908810722565737_REALK,      0.000000000000000_REALK,     11.495952007962549_REALK, &
    -19.728986122972955_REALK,     -7.268880776373662_REALK,      0.000000000000000_REALK, &
     -4.840375461613142_REALK,      0.000000000000000_REALK,     -7.861277821605096_REALK, &
     -3.766721888187682_REALK,      0.000000000000000_REALK,     -3.398998240630425_REALK, &
      0.000000000000000_REALK,     -3.977236827044014_REALK,      0.000000000000000_REALK, &
     -2.752311716821926_REALK,      0.000000000000000_REALK,     -7.450071876030750_REALK, &
     -5.989721110257719_REALK,      0.000000000000000_REALK,     -3.011319234417831_REALK, &
      0.000000000000000_REALK,     -4.528902090285660_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.813188551152331_REALK, &
      0.000000000000000_REALK,      4.460894434794204_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.425659767928718_REALK,      0.000000000000000_REALK, &
      6.868552234588444_REALK,      0.000000000000000_REALK,      3.071852550231918_REALK, &
      0.000000000000000_REALK,      4.227554975765600_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.596132310737570_REALK,      0.000000000000000_REALK, &
      4.564426511942629_REALK,      0.000000000000000_REALK,     12.812539965708257_REALK, &
    -13.826481296110575_REALK,     -9.211825048000533_REALK,      0.000000000000000_REALK, &
     -8.418632013375889_REALK,      0.000000000000000_REALK,     -9.182243331922143_REALK, &
     -9.453883837287465_REALK,      0.000000000000000_REALK,     -7.179229305131456_REALK, &
      0.000000000000000_REALK,    -13.001247570653542_REALK,      0.000000000000000_REALK, &
     -7.978272110563565_REALK,      0.000000000000000_REALK,    -12.182716868907097_REALK, &
    -24.369114049533529_REALK,      0.000000000000000_REALK,    -12.596568530164296_REALK, &
      0.000000000000000_REALK,    -13.392074378028269_REALK,      0.000000000000000_REALK, &
   -286.138220584963051_REALK,    -30.337856078974330_REALK,      0.000000000000000_REALK, &
    -25.526786080272348_REALK,      0.000000000000000_REALK,    -33.590617041046251_REALK, &
     -6.884009782715496_REALK,      0.000000000000000_REALK,     -3.999795482681402_REALK, &
      0.000000000000000_REALK,     -7.581721726543447_REALK,      0.000000000000000_REALK, &
     -3.960634386819266_REALK,      0.000000000000000_REALK,    -15.635358776723713_REALK, &
     -2.016761909763644_REALK,      0.000000000000000_REALK,     -1.408337343504384_REALK, &
      0.000000000000000_REALK,     -2.454846022495767_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     30.194720962961192_REALK, &
      0.000000000000000_REALK,      5.641780309516705_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.856291168011293_REALK,      0.000000000000000_REALK, &
     11.942772903340973_REALK,      0.000000000000000_REALK,      1.935934279403557_REALK, &
      0.000000000000000_REALK,      2.626068439616896_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.146152729342989_REALK,      0.000000000000000_REALK, &
      2.366771270273002_REALK,      0.000000000000000_REALK,     12.216319845301479_REALK, &
    -30.683788933008504_REALK,     -7.849464628851443_REALK,      0.000000000000000_REALK, &
     -4.557132132364923_REALK,      0.000000000000000_REALK,    -10.806183822383906_REALK, &
     -2.489440665985212_REALK,      0.000000000000000_REALK,     -3.104661029660561_REALK, &
      0.000000000000000_REALK,     -1.870613822885979_REALK,      0.000000000000000_REALK, &
     -2.121199375271799_REALK,      0.000000000000000_REALK,     -8.383222059885558_REALK, &
     -1.288405114029566_REALK,      0.000000000000000_REALK,     -1.527876498584413_REALK, &
      0.000000000000000_REALK,     -3.175772700070874_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     11.593315807214987_REALK, &
      0.000000000000000_REALK,      4.257163605702919_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.823369545397841_REALK,      0.000000000000000_REALK, &
      7.642414163065197_REALK,      0.000000000000000_REALK,      2.195951915756423_REALK, &
      0.000000000000000_REALK,      3.302622687016027_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.504021364917010_REALK,      0.000000000000000_REALK, &
      2.888038287859815_REALK,      0.000000000000000_REALK,     10.944447088348126_REALK, &
    -14.656237445191612_REALK,     -6.578645245571241_REALK,      0.000000000000000_REALK, &
     -4.290556527867450_REALK,      0.000000000000000_REALK,     -8.602696596729048_REALK, &
     -3.151160126692375_REALK,      0.000000000000000_REALK,     -4.336699908342524_REALK, &
      0.000000000000000_REALK,     -2.622416629502394_REALK,      0.000000000000000_REALK, &
     -3.328528250565101_REALK,      0.000000000000000_REALK,     -9.343320814952444_REALK, &
     -2.310890988051882_REALK,      0.000000000000000_REALK,     -3.223336850076560_REALK, &
      0.000000000000000_REALK,     -6.210443672927389_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     13.541392275070640_REALK, &
      0.000000000000000_REALK,      8.991812160847966_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      8.184251211149977_REALK,      0.000000000000000_REALK, &
     12.497244253857263_REALK,      0.000000000000000_REALK,      9.185827420625184_REALK, &
      0.000000000000000_REALK,      9.765936155244299_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     13.642386705147027_REALK,      0.000000000000000_REALK, &
     11.720393900015317_REALK,      0.000000000000000_REALK,     23.010284261964042_REALK, &
  -1010.960572395016015_REALK,    -34.073416408967375_REALK,      0.000000000000000_REALK, &
    -55.027853752972028_REALK,      0.000000000000000_REALK,    -82.123538825162257_REALK, &
     -4.353575667748107_REALK,      0.000000000000000_REALK,     -3.186841044941430_REALK, &
      0.000000000000000_REALK,    -12.442155744537926_REALK,      0.000000000000000_REALK, &
     -6.128844382878989_REALK,      0.000000000000000_REALK,    -27.440052008400713_REALK, &
     -2.490946007168679_REALK,      0.000000000000000_REALK,     -0.623855151942790_REALK, &
      0.000000000000000_REALK,     -1.369996083245627_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     82.391374691963719_REALK, &
      0.000000000000000_REALK,      7.679264060820361_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.856047996773804_REALK,      0.000000000000000_REALK, &
     23.117865094537141_REALK,      0.000000000000000_REALK,      1.472038994925615_REALK, &
      0.000000000000000_REALK,      2.565883158831799_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.606369253522898_REALK,      0.000000000000000_REALK, &
      2.517465636264879_REALK,      0.000000000000000_REALK,     16.563625329849035_REALK, &
    -94.087579991461055_REALK,    -13.838210677795152_REALK,      0.000000000000000_REALK, &
     -7.403748092318877_REALK,      0.000000000000000_REALK,    -22.929099035254534_REALK, &
     -2.862401057900088_REALK,      0.000000000000000_REALK,     -3.882807985606471_REALK, &
      0.000000000000000_REALK,     -2.243227108355864_REALK,      0.000000000000000_REALK, &
     -2.473824625882787_REALK,      0.000000000000000_REALK,    -12.768886140603467_REALK, &
     -1.792249846448884_REALK,      0.000000000000000_REALK,     -1.230522069566645_REALK, &
      0.000000000000000_REALK,     -2.781977333907404_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     26.505507154343654_REALK, &
      0.000000000000000_REALK,      5.960682732237824_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.136327198909689_REALK,      0.000000000000000_REALK, &
     12.395123092825637_REALK,      0.000000000000000_REALK,      1.596985122719403_REALK, &
      0.000000000000000_REALK,      3.319418657103857_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.189002962128860_REALK,      0.000000000000000_REALK, &
      2.247134344893759_REALK,      0.000000000000000_REALK,     12.433304008924862_REALK, &
    -36.125090532071489_REALK,    -10.442010080787000_REALK,      0.000000000000000_REALK, &
     -5.420627223133289_REALK,      0.000000000000000_REALK,    -14.672779314453216_REALK, &
     -3.246853549540677_REALK,      0.000000000000000_REALK,     -4.883136154845103_REALK, &
      0.000000000000000_REALK,     -2.617282791147708_REALK,      0.000000000000000_REALK, &
     -3.018669495753964_REALK,      0.000000000000000_REALK,    -11.439484272894591_REALK, &
     -2.776332179769276_REALK,      0.000000000000000_REALK,     -2.326324921248485_REALK, &
      0.000000000000000_REALK,     -4.898177765197254_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     21.100773403366681_REALK, &
      0.000000000000000_REALK,      8.326091644658817_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.921439166108074_REALK,      0.000000000000000_REALK, &
     13.814689718320125_REALK,      0.000000000000000_REALK,      3.369134219850094_REALK, &
      0.000000000000000_REALK,      6.491353300048115_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.778108716923544_REALK,      0.000000000000000_REALK, &
      4.936598761900823_REALK,      0.000000000000000_REALK,     17.816455736373289_REALK, &
    -42.195350320982499_REALK,    -22.055199640985979_REALK,      0.000000000000000_REALK, &
    -15.713059945849158_REALK,      0.000000000000000_REALK,    -23.993636443032148_REALK, &
    -13.581825791413726_REALK,      0.000000000000000_REALK,    -14.439553180890201_REALK, &
      0.000000000000000_REALK,    -14.259456590038713_REALK,      0.000000000000000_REALK, &
    -12.250528565677524_REALK,      0.000000000000000_REALK,    -24.051081137740777_REALK, &
    -18.825794580074213_REALK,      0.000000000000000_REALK,    -13.623662128748398_REALK, &
      0.000000000000000_REALK,    -18.622326331309132_REALK,      0.000000000000000_REALK, &
    ! results of test 2, ket-major order, CM030000
    -35.548516864995186_REALK,    -57.579566633169414_REALK,      0.000000000000000_REALK, &
    -53.490907200350797_REALK,      0.000000000000000_REALK,    -11.668559100302767_REALK, &
   -173.273437574948758_REALK,      0.000000000000000_REALK,    -26.316586119506653_REALK, &
      0.000000000000000_REALK,   -226.939527046135254_REALK,      0.000000000000000_REALK, &
    -27.852485533827156_REALK,      0.000000000000000_REALK,    -18.227305754481137_REALK, &
  -2131.633922893770887_REALK,      0.000000000000000_REALK,   -220.371349868324955_REALK, &
      0.000000000000000_REALK,   -100.409301418283263_REALK,      0.000000000000000_REALK, &
    -27.228492897060530_REALK,    -23.073848323102375_REALK,      0.000000000000000_REALK, &
    -19.983711221348976_REALK,      0.000000000000000_REALK,     -8.013590003875876_REALK, &
    -33.801805801375274_REALK,      0.000000000000000_REALK,     -9.303766373465939_REALK, &
      0.000000000000000_REALK,    -36.840029037178674_REALK,      0.000000000000000_REALK, &
     -9.351914262773391_REALK,      0.000000000000000_REALK,    -11.250523862635092_REALK, &
   -130.586028707078668_REALK,      0.000000000000000_REALK,    -36.429477687437483_REALK, &
      0.000000000000000_REALK,    -30.081057044962858_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      9.498977974194720_REALK, &
      0.000000000000000_REALK,      8.376059208725142_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     17.558134715251079_REALK,      0.000000000000000_REALK, &
     11.490446321013680_REALK,      0.000000000000000_REALK,     25.808725059111350_REALK, &
      0.000000000000000_REALK,     11.759405454612555_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    154.183396025377618_REALK,      0.000000000000000_REALK, &
     56.769186883166739_REALK,      0.000000000000000_REALK,     61.918431271064684_REALK, &
    -25.618519419010354_REALK,    -14.503927215360054_REALK,      0.000000000000000_REALK, &
    -12.660681492111125_REALK,      0.000000000000000_REALK,     -6.854091892227538_REALK, &
    -16.914187482175119_REALK,      0.000000000000000_REALK,     -5.087650500018527_REALK, &
      0.000000000000000_REALK,    -22.967892418405455_REALK,      0.000000000000000_REALK, &
     -5.298050058610306_REALK,      0.000000000000000_REALK,     -8.604589407125529_REALK, &
    -89.160191302395305_REALK,      0.000000000000000_REALK,    -14.941697288346928_REALK, &
      0.000000000000000_REALK,    -13.483024312038904_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.861784833809879_REALK, &
      0.000000000000000_REALK,      3.889365198819940_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.127557708874646_REALK,      0.000000000000000_REALK, &
      6.168545683782277_REALK,      0.000000000000000_REALK,      5.913148748496719_REALK, &
      0.000000000000000_REALK,      4.882687760308444_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     17.843448738928615_REALK,      0.000000000000000_REALK, &
     13.588784302280120_REALK,      0.000000000000000_REALK,     27.245926655816280_REALK, &
     -5.984662657829740_REALK,     -6.126923989504257_REALK,      0.000000000000000_REALK, &
     -7.340037934792820_REALK,      0.000000000000000_REALK,     -4.803489280138773_REALK, &
    -14.150656583738542_REALK,      0.000000000000000_REALK,     -6.447560188891162_REALK, &
      0.000000000000000_REALK,    -25.026693027795837_REALK,      0.000000000000000_REALK, &
     -9.214643406406370_REALK,      0.000000000000000_REALK,    -10.050456872337625_REALK, &
   -120.915750529427200_REALK,      0.000000000000000_REALK,    -37.501327331577777_REALK, &
      0.000000000000000_REALK,    -28.478309316463829_REALK,      0.000000000000000_REALK, &
    -27.975946116924607_REALK,    -10.350770496143381_REALK,      0.000000000000000_REALK, &
     -8.397645491623608_REALK,      0.000000000000000_REALK,     -6.637690709998153_REALK, &
     -7.513630775997798_REALK,      0.000000000000000_REALK,     -3.123496371458564_REALK, &
      0.000000000000000_REALK,     -8.191329687454456_REALK,      0.000000000000000_REALK, &
     -3.096210666804356_REALK,      0.000000000000000_REALK,     -7.341946787255122_REALK, &
    -13.470038394881655_REALK,      0.000000000000000_REALK,     -5.324555885532625_REALK, &
      0.000000000000000_REALK,     -6.640423844575022_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.095878376584785_REALK, &
      0.000000000000000_REALK,      2.614959710196998_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.840498349444914_REALK,      0.000000000000000_REALK, &
      4.613267473543329_REALK,      0.000000000000000_REALK,      3.205323282957923_REALK, &
      0.000000000000000_REALK,      2.892405790189006_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      8.726360873029481_REALK,      0.000000000000000_REALK, &
      6.038781777525180_REALK,      0.000000000000000_REALK,     16.346025783073799_REALK, &
     -4.454275078160750_REALK,     -2.891664180601849_REALK,      0.000000000000000_REALK, &
     -2.635471288833303_REALK,      0.000000000000000_REALK,     -3.170520151402205_REALK, &
     -3.170277568976557_REALK,      0.000000000000000_REALK,     -2.617805866418892_REALK, &
      0.000000000000000_REALK,     -3.827812904211347_REALK,      0.000000000000000_REALK, &
     -2.915093638335277_REALK,      0.000000000000000_REALK,     -5.844851584817094_REALK, &
     -8.053313355271923_REALK,      0.000000000000000_REALK,     -6.739878731833686_REALK, &
      0.000000000000000_REALK,     -9.275577978724620_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.571296904054315_REALK, &
      0.000000000000000_REALK,      3.313928526135814_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.940342030948329_REALK,      0.000000000000000_REALK, &
      5.388455345121941_REALK,      0.000000000000000_REALK,      8.044860989887669_REALK, &
      0.000000000000000_REALK,      6.109224818958839_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     28.525728548441087_REALK,      0.000000000000000_REALK, &
     17.504937374259551_REALK,      0.000000000000000_REALK,     26.729809773746883_REALK, &
    -34.473100837082946_REALK,     -8.271780273067169_REALK,      0.000000000000000_REALK, &
     -7.095195564408187_REALK,      0.000000000000000_REALK,     -7.324508241962622_REALK, &
     -4.762412478216411_REALK,      0.000000000000000_REALK,     -2.153382518979400_REALK, &
      0.000000000000000_REALK,     -6.189610646684062_REALK,      0.000000000000000_REALK, &
     -2.275295144415998_REALK,      0.000000000000000_REALK,     -7.046494160825538_REALK, &
    -11.688933955653399_REALK,      0.000000000000000_REALK,     -2.675127620671399_REALK, &
      0.000000000000000_REALK,     -3.628774122826608_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.281215813996008_REALK, &
      0.000000000000000_REALK,      1.904090070563715_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.739388656087990_REALK,      0.000000000000000_REALK, &
      4.124557509045027_REALK,      0.000000000000000_REALK,      1.468823803195582_REALK, &
      0.000000000000000_REALK,      1.831817116000397_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.584866004208430_REALK,      0.000000000000000_REALK, &
      2.931132062752027_REALK,      0.000000000000000_REALK,     11.584168492295587_REALK, &
     -4.412002408726962_REALK,     -2.080567953196880_REALK,      0.000000000000000_REALK, &
     -1.731573870887858_REALK,      0.000000000000000_REALK,     -2.812257721665466_REALK, &
     -1.800685921422160_REALK,      0.000000000000000_REALK,     -1.624895190174692_REALK, &
      0.000000000000000_REALK,     -2.407240498762861_REALK,      0.000000000000000_REALK, &
     -1.665849060056478_REALK,      0.000000000000000_REALK,     -4.509189550073771_REALK, &
     -6.035684431791796_REALK,      0.000000000000000_REALK,     -3.034427194148421_REALK, &
      0.000000000000000_REALK,     -4.563655525235355_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.522594362065870_REALK, &
      0.000000000000000_REALK,      1.595820056798738_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.637640765312640_REALK,      0.000000000000000_REALK, &
      3.283519642945265_REALK,      0.000000000000000_REALK,      1.859252588345908_REALK, &
      0.000000000000000_REALK,      2.558746685440157_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.623727950440135_REALK,      0.000000000000000_REALK, &
      4.599452550638788_REALK,      0.000000000000000_REALK,     12.910859550755971_REALK, &
     -3.092022489266454_REALK,     -2.636695878631232_REALK,      0.000000000000000_REALK, &
     -3.011643071614845_REALK,      0.000000000000000_REALK,     -3.284813906645121_REALK, &
     -4.519440519871965_REALK,      0.000000000000000_REALK,     -3.432039189554172_REALK, &
      0.000000000000000_REALK,     -7.869063635765515_REALK,      0.000000000000000_REALK, &
     -4.828885120470177_REALK,      0.000000000000000_REALK,     -7.373644242752079_REALK, &
    -24.556115314524170_REALK,      0.000000000000000_REALK,    -12.693230815255744_REALK, &
      0.000000000000000_REALK,    -13.494841136165212_REALK,      0.000000000000000_REALK, &
    -50.271155918062291_REALK,     -6.589337637989568_REALK,      0.000000000000000_REALK, &
     -6.994011589397113_REALK,      0.000000000000000_REALK,     -9.203397722741093_REALK, &
     -2.509790147919944_REALK,      0.000000000000000_REALK,     -1.458255814995165_REALK, &
      0.000000000000000_REALK,     -3.664890240675299_REALK,      0.000000000000000_REALK, &
     -1.914511087939194_REALK,      0.000000000000000_REALK,     -7.557897250390893_REALK, &
     -1.586337603143357_REALK,      0.000000000000000_REALK,     -1.107765113519946_REALK, &
      0.000000000000000_REALK,     -1.930924288364968_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.558248901698902_REALK, &
      0.000000000000000_REALK,      1.545775357129144_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.405936639614655_REALK,      0.000000000000000_REALK, &
      4.354127131967384_REALK,      0.000000000000000_REALK,      0.935801510933257_REALK, &
      0.000000000000000_REALK,      1.269401983193747_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.688113386197643_REALK,      0.000000000000000_REALK, &
      1.861646754580685_REALK,      0.000000000000000_REALK,      9.609070584290903_REALK, &
     -5.390784685998169_REALK,     -1.704892151321303_REALK,      0.000000000000000_REALK, &
     -1.248595684860073_REALK,      0.000000000000000_REALK,     -2.960755602105248_REALK, &
     -0.907606737138648_REALK,      0.000000000000000_REALK,     -1.131905373585826_REALK, &
      0.000000000000000_REALK,     -0.904226584782958_REALK,      0.000000000000000_REALK, &
     -1.025355871575143_REALK,      0.000000000000000_REALK,     -4.052323445890375_REALK, &
     -1.013429235534717_REALK,      0.000000000000000_REALK,     -1.201791808408119_REALK, &
      0.000000000000000_REALK,     -2.497988299347122_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.518051110754818_REALK, &
      0.000000000000000_REALK,      1.166408160534409_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.029351394410935_REALK,      0.000000000000000_REALK, &
      2.786291184673289_REALK,      0.000000000000000_REALK,      1.061490125240594_REALK, &
      0.000000000000000_REALK,      1.596438129864737_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.969604459015063_REALK,      0.000000000000000_REALK, &
      2.271663161214060_REALK,      0.000000000000000_REALK,      8.608645312968134_REALK, &
     -2.574930382502314_REALK,     -1.428872053805631_REALK,      0.000000000000000_REALK, &
     -1.175557392399640_REALK,      0.000000000000000_REALK,     -2.357028397871391_REALK, &
     -1.148858135028821_REALK,      0.000000000000000_REALK,     -1.581085304639117_REALK, &
      0.000000000000000_REALK,     -1.267636753113806_REALK,      0.000000000000000_REALK, &
     -1.608960489620808_REALK,      0.000000000000000_REALK,     -4.516420742578326_REALK, &
     -1.817692635588020_REALK,      0.000000000000000_REALK,     -2.535401143843184_REALK, &
      0.000000000000000_REALK,     -4.884989290442845_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.941170449112396_REALK, &
      0.000000000000000_REALK,      2.463641065698216_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.983835541521193_REALK,      0.000000000000000_REALK, &
      4.556277735576885_REALK,      0.000000000000000_REALK,      4.440290804727924_REALK, &
      0.000000000000000_REALK,      4.720706641224915_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     10.730781319414158_REALK,      0.000000000000000_REALK, &
      9.218986870604512_REALK,      0.000000000000000_REALK,     18.099349758172117_REALK, &
    -81.090081136790289_REALK,     -3.867074892908088_REALK,      0.000000000000000_REALK, &
     -8.803069555382820_REALK,      0.000000000000000_REALK,    -13.137696186688711_REALK, &
     -1.001531453315389_REALK,      0.000000000000000_REALK,     -0.733126465877242_REALK, &
      0.000000000000000_REALK,     -4.134021077877613_REALK,      0.000000000000000_REALK, &
     -2.036365110843137_REALK,      0.000000000000000_REALK,     -9.117210530866837_REALK, &
     -1.380965776359617_REALK,      0.000000000000000_REALK,     -0.345861617136321_REALK, &
      0.000000000000000_REALK,     -0.759517749186129_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      9.350797485033629_REALK, &
      0.000000000000000_REALK,      1.228488684385624_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.347172234616798_REALK,      0.000000000000000_REALK, &
      5.318219043992620_REALK,      0.000000000000000_REALK,      0.489098541878626_REALK, &
      0.000000000000000_REALK,      0.852538360696736_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.890561640809281_REALK,      0.000000000000000_REALK, &
      1.395668102334651_REALK,      0.000000000000000_REALK,      9.182776201144632_REALK, &
     -7.546851681264870_REALK,     -1.570532183581999_REALK,      0.000000000000000_REALK, &
     -1.184413074146033_REALK,      0.000000000000000_REALK,     -3.668077889348994_REALK, &
     -0.658489689918041_REALK,      0.000000000000000_REALK,     -0.893232281128700_REALK, &
      0.000000000000000_REALK,     -0.745332910053039_REALK,      0.000000000000000_REALK, &
     -0.821951063493294_REALK,      0.000000000000000_REALK,     -4.242580267446608_REALK, &
     -0.993612745321977_REALK,      0.000000000000000_REALK,     -0.682194178531495_REALK, &
      0.000000000000000_REALK,     -1.542311827585968_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.008174466866276_REALK, &
      0.000000000000000_REALK,      0.953558990779735_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.721505855719135_REALK,      0.000000000000000_REALK, &
      2.851473499621521_REALK,      0.000000000000000_REALK,      0.530613045997051_REALK, &
      0.000000000000000_REALK,      1.102907484564458_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.659176230221266_REALK,      0.000000000000000_REALK, &
      1.245798028640462_REALK,      0.000000000000000_REALK,      6.892950418831525_REALK, &
     -2.897626873202096_REALK,     -1.185089118456505_REALK,      0.000000000000000_REALK, &
     -0.867163722089865_REALK,      0.000000000000000_REALK,     -2.347274844767823_REALK, &
     -0.746932223611888_REALK,      0.000000000000000_REALK,     -1.123355793751165_REALK, &
      0.000000000000000_REALK,     -0.869616362913708_REALK,      0.000000000000000_REALK, &
     -1.002980800017025_REALK,      0.000000000000000_REALK,     -3.800874227519323_REALK, &
     -1.539182187423318_REALK,      0.000000000000000_REALK,     -1.289700817155887_REALK, &
      0.000000000000000_REALK,     -2.715520866689339_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.394778089455895_REALK, &
      0.000000000000000_REALK,      1.331964793710761_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.132167325573329_REALK,      0.000000000000000_REALK, &
      3.178041988149690_REALK,      0.000000000000000_REALK,      1.119425939124209_REALK, &
      0.000000000000000_REALK,      2.156812044257682_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.540167089144758_REALK,      0.000000000000000_REALK, &
      2.736821240679205_REALK,      0.000000000000000_REALK,      9.877337990125049_REALK, &
     -3.384528016772961_REALK,     -2.503098244274857_REALK,      0.000000000000000_REALK, &
     -2.513693524231611_REALK,      0.000000000000000_REALK,     -3.838377041611808_REALK, &
     -3.124472103315249_REALK,      0.000000000000000_REALK,     -3.321790589196792_REALK, &
      0.000000000000000_REALK,     -4.737836056117469_REALK,      0.000000000000000_REALK, &
     -4.070351179126273_REALK,      0.000000000000000_REALK,     -7.991193681433667_REALK, &
    -10.436909492634529_REALK,      0.000000000000000_REALK,     -7.552877940486863_REALK, &
      0.000000000000000_REALK,    -10.324107895445442_REALK,      0.000000000000000_REALK, &
    ! results of test 2, ket-major order, CM020100
    -16.090771252927922_REALK,     -9.750045429070642_REALK,      0.000000000000000_REALK, &
     -4.957046086776171_REALK,      0.000000000000000_REALK,     -4.735658494012235_REALK, &
      1.570991322282867_REALK,      0.000000000000000_REALK,     -3.931383423021308_REALK, &
      0.000000000000000_REALK,     20.457140419438979_REALK,      0.000000000000000_REALK, &
     -2.319782821452209_REALK,      0.000000000000000_REALK,     -6.648535658351165_REALK, &
    238.170685507709550_REALK,      0.000000000000000_REALK,      1.693116446457222_REALK, &
      0.000000000000000_REALK,    -12.710999423932199_REALK,      0.000000000000000_REALK, &
    -17.587357641767518_REALK,     -8.679599789016315_REALK,      0.000000000000000_REALK, &
     -7.302427497874257_REALK,      0.000000000000000_REALK,     -4.705399381070142_REALK, &
     -9.491544954994286_REALK,      0.000000000000000_REALK,     -3.044607819031540_REALK, &
      0.000000000000000_REALK,    -14.135024877571661_REALK,      0.000000000000000_REALK, &
     -3.055809156656939_REALK,      0.000000000000000_REALK,     -5.907132601557930_REALK, &
    -65.655686325833713_REALK,      0.000000000000000_REALK,     -8.384664747610058_REALK, &
      0.000000000000000_REALK,     -8.068659835119668_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.464041849517838_REALK, &
      0.000000000000000_REALK,      1.643483429713474_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.271912889150541_REALK,      0.000000000000000_REALK, &
      3.645323225792339_REALK,      0.000000000000000_REALK,     -0.274822754318001_REALK, &
      0.000000000000000_REALK,      2.063220092822974_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -9.908405230922662_REALK,      0.000000000000000_REALK, &
      3.370756778035349_REALK,      0.000000000000000_REALK,     16.101073792450691_REALK, &
    -20.176493187578597_REALK,     -6.398022379591708_REALK,      0.000000000000000_REALK, &
     -4.979397783349204_REALK,      0.000000000000000_REALK,     -4.787159684673208_REALK, &
     -3.548099882588776_REALK,      0.000000000000000_REALK,     -1.930696820551798_REALK, &
      0.000000000000000_REALK,     -2.727695865673282_REALK,      0.000000000000000_REALK, &
     -1.835903235787462_REALK,      0.000000000000000_REALK,     -5.295075230610358_REALK, &
      3.298914144152763_REALK,      0.000000000000000_REALK,     -2.514371104399504_REALK, &
      0.000000000000000_REALK,     -4.104581430280499_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.498369052562852_REALK, &
      0.000000000000000_REALK,      1.564872976256768_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.638342554275428_REALK,      0.000000000000000_REALK, &
      3.167052069923018_REALK,      0.000000000000000_REALK,      1.798695330032644_REALK, &
      0.000000000000000_REALK,      1.730905313678579_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.370424320347937_REALK,      0.000000000000000_REALK, &
      3.483048375661231_REALK,      0.000000000000000_REALK,     11.221702424190186_REALK, &
     -2.632269132605564_REALK,     -1.221896613503160_REALK,      0.000000000000000_REALK, &
     -0.653740063315437_REALK,      0.000000000000000_REALK,     -1.873629756221975_REALK, &
      0.147343564404703_REALK,      0.000000000000000_REALK,     -1.106175518043800_REALK, &
      0.000000000000000_REALK,      2.125571236704676_REALK,      0.000000000000000_REALK, &
     -0.723101597718172_REALK,      0.000000000000000_REALK,     -3.454035087955901_REALK, &
     14.688119253063206_REALK,      0.000000000000000_REALK,      0.313246311844049_REALK, &
      0.000000000000000_REALK,     -3.919472183706051_REALK,      0.000000000000000_REALK, &
    -25.786140524485223_REALK,     -5.281121260232481_REALK,      0.000000000000000_REALK, &
     -4.760090184561361_REALK,      0.000000000000000_REALK,     -5.478787640618298_REALK, &
     -2.889584294402108_REALK,      0.000000000000000_REALK,     -1.374827887948510_REALK, &
      0.000000000000000_REALK,     -4.208522691789821_REALK,      0.000000000000000_REALK, &
     -1.526470973998882_REALK,      0.000000000000000_REALK,     -5.270831002256515_REALK, &
     -9.027590788384343_REALK,      0.000000000000000_REALK,     -1.623128360588444_REALK, &
      0.000000000000000_REALK,     -2.316792218361849_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.808858311632198_REALK, &
      0.000000000000000_REALK,      1.176956912411890_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.031373380448898_REALK,      0.000000000000000_REALK, &
      2.974666384300693_REALK,      0.000000000000000_REALK,      0.693610548486096_REALK, &
      0.000000000000000_REALK,      1.132283524966230_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.860755040026943_REALK,      0.000000000000000_REALK, &
      1.738019604486705_REALK,      0.000000000000000_REALK,      8.354602046047198_REALK, &
     -3.028881685529443_REALK,     -1.245076378243081_REALK,      0.000000000000000_REALK, &
     -0.998737126216387_REALK,      0.000000000000000_REALK,     -1.930641717532305_REALK, &
     -1.010470730031535_REALK,      0.000000000000000_REALK,     -0.972387667174581_REALK, &
      0.000000000000000_REALK,     -1.481476999127869_REALK,      0.000000000000000_REALK, &
     -0.960828371762157_REALK,      0.000000000000000_REALK,     -3.095601583939299_REALK, &
     -4.444550847490095_REALK,      0.000000000000000_REALK,     -1.702795487886666_REALK, &
      0.000000000000000_REALK,     -2.731032977883888_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.490735789064166_REALK, &
      0.000000000000000_REALK,      0.674326962391931_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.406223881906665_REALK,      0.000000000000000_REALK, &
      1.940407193261570_REALK,      0.000000000000000_REALK,     -0.086411646152483_REALK, &
      0.000000000000000_REALK,      1.081219572703298_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.012243569330173_REALK,      0.000000000000000_REALK, &
      1.140914118249434_REALK,      0.000000000000000_REALK,      7.629716727080456_REALK, &
    -38.528239942191902_REALK,     -4.000883602765637_REALK,      0.000000000000000_REALK, &
     -4.911482047975238_REALK,      0.000000000000000_REALK,     -7.053562013237650_REALK, &
     -1.242902105136293_REALK,      0.000000000000000_REALK,     -0.885417032694635_REALK, &
      0.000000000000000_REALK,     -2.114116994790570_REALK,      0.000000000000000_REALK, &
     -1.344448278198156_REALK,      0.000000000000000_REALK,     -5.792436505659660_REALK, &
      0.856974297346856_REALK,      0.000000000000000_REALK,     -0.548589129147543_REALK, &
      0.000000000000000_REALK,     -1.172409693951934_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.905619850473211_REALK, &
      0.000000000000000_REALK,      0.986900864455770_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.943227728903779_REALK,      0.000000000000000_REALK, &
      3.256920072754481_REALK,      0.000000000000000_REALK,      0.567795704601214_REALK, &
      0.000000000000000_REALK,      0.810450178790833_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.147804587019215_REALK,      0.000000000000000_REALK, &
      1.248958730334754_REALK,      0.000000000000000_REALK,      7.187657575894156_REALK, &
     -3.887880325410844_REALK,     -1.053828615271507_REALK,      0.000000000000000_REALK, &
     -0.740356876423653_REALK,      0.000000000000000_REALK,     -2.135322429714797_REALK, &
     -0.428591642773500_REALK,      0.000000000000000_REALK,     -0.699653800118602_REALK, &
      0.000000000000000_REALK,     -0.301105584935970_REALK,      0.000000000000000_REALK, &
     -0.607986459914043_REALK,      0.000000000000000_REALK,     -2.922570556082420_REALK, &
      0.248196474367419_REALK,      0.000000000000000_REALK,     -0.567512232292615_REALK, &
      0.000000000000000_REALK,     -1.544057522011135_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.728666076316354_REALK, &
      0.000000000000000_REALK,      0.698014811695953_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.593709266930482_REALK,      0.000000000000000_REALK, &
      1.912815442511090_REALK,      0.000000000000000_REALK,      0.595664512624166_REALK, &
      0.000000000000000_REALK,      0.955358079877650_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.212144654807069_REALK,      0.000000000000000_REALK, &
      1.310249811172796_REALK,      0.000000000000000_REALK,      5.909917019558383_REALK, &
     -1.521663939818419_REALK,     -0.603781703071420_REALK,      0.000000000000000_REALK, &
     -0.291602100692389_REALK,      0.000000000000000_REALK,     -1.392894014743582_REALK, &
      0.053394962720924_REALK,      0.000000000000000_REALK,     -0.668100671010855_REALK, &
      0.000000000000000_REALK,      0.703914294777570_REALK,      0.000000000000000_REALK, &
     -0.399109615351713_REALK,      0.000000000000000_REALK,     -2.668994326110945_REALK, &
      3.315217602883170_REALK,      0.000000000000000_REALK,      0.117836698396795_REALK, &
      0.000000000000000_REALK,     -2.064192623414861_REALK,      0.000000000000000_REALK, &
    -63.355530530193320_REALK,     -1.672453544247448_REALK,      0.000000000000000_REALK, &
     -6.619586506639854_REALK,      0.000000000000000_REALK,    -10.264457750980451_REALK, &
     -0.285454646310709_REALK,      0.000000000000000_REALK,     -0.317066514146547_REALK, &
      0.000000000000000_REALK,     -3.167136962110390_REALK,      0.000000000000000_REALK, &
     -1.531272123379604_REALK,      0.000000000000000_REALK,     -7.123259738316711_REALK, &
     -1.026849965847997_REALK,      0.000000000000000_REALK,     -0.098576839764021_REALK, &
      0.000000000000000_REALK,     -0.328480359631705_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.166530440267365_REALK, &
      0.000000000000000_REALK,      0.745908087211201_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.946039645670854_REALK,      0.000000000000000_REALK, &
      4.075928147068158_REALK,      0.000000000000000_REALK,      0.242212125911742_REALK, &
      0.000000000000000_REALK,      0.517640305510426_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.513726571903162_REALK,      0.000000000000000_REALK, &
      0.980095434777396_REALK,      0.000000000000000_REALK,      7.037757504319325_REALK, &
     -5.645102217239665_REALK,     -1.002706869717027_REALK,      0.000000000000000_REALK, &
     -0.794609957897467_REALK,      0.000000000000000_REALK,     -2.743750043157243_REALK, &
     -0.399537309024836_REALK,      0.000000000000000_REALK,     -0.570284489489416_REALK, &
      0.000000000000000_REALK,     -0.506776701144586_REALK,      0.000000000000000_REALK, &
     -0.551438103996863_REALK,      0.000000000000000_REALK,     -3.173482173239960_REALK, &
     -0.767386427275655_REALK,      0.000000000000000_REALK,     -0.413919960321333_REALK, &
      0.000000000000000_REALK,     -0.984689572702112_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.169521323214767_REALK, &
      0.000000000000000_REALK,      0.589414262980981_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.427818090466537_REALK,      0.000000000000000_REALK, &
      2.056507236581677_REALK,      0.000000000000000_REALK,      0.250567021767475_REALK, &
      0.000000000000000_REALK,      0.681729613413008_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.219504323050072_REALK,      0.000000000000000_REALK, &
      0.738698001541116_REALK,      0.000000000000000_REALK,      4.971255184243250_REALK, &
     -1.989248453350724_REALK,     -0.709194076182853_REALK,      0.000000000000000_REALK, &
     -0.500162666069259_REALK,      0.000000000000000_REALK,     -1.611426542777576_REALK, &
     -0.419147581651045_REALK,      0.000000000000000_REALK,     -0.672250940428539_REALK, &
      0.000000000000000_REALK,     -0.535184016879074_REALK,      0.000000000000000_REALK, &
     -0.578499236273178_REALK,      0.000000000000000_REALK,     -2.609336367079620_REALK, &
     -1.133421333216241_REALK,      0.000000000000000_REALK,     -0.723726948009079_REALK, &
      0.000000000000000_REALK,     -1.625051890540743_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.415202324441487_REALK, &
      0.000000000000000_REALK,      0.562832738897735_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.280839006761341_REALK,      0.000000000000000_REALK, &
      1.878074811442740_REALK,      0.000000000000000_REALK,     -0.052027055792118_REALK, &
      0.000000000000000_REALK,      0.911378766082297_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.855249445656947_REALK,      0.000000000000000_REALK, &
      0.678880357659560_REALK,      0.000000000000000_REALK,      5.837046757887757_REALK, &
   -131.653864004269963_REALK,      5.026564265594053_REALK,      0.000000000000000_REALK, &
    -11.194072906294803_REALK,      0.000000000000000_REALK,    -17.486413050224900_REALK, &
      2.201072425955575_REALK,      0.000000000000000_REALK,      0.783489857691385_REALK, &
      0.000000000000000_REALK,     -3.925480966883057_REALK,      0.000000000000000_REALK, &
     -2.121707173564741_REALK,      0.000000000000000_REALK,     -9.943042622417206_REALK, &
      3.187164429755720_REALK,      0.000000000000000_REALK,      0.586551731131902_REALK, &
      0.000000000000000_REALK,      0.626363758321571_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     12.739190594919704_REALK, &
      0.000000000000000_REALK,      0.324904613820531_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.280556736798198_REALK,      0.000000000000000_REALK, &
      5.956967482522076_REALK,      0.000000000000000_REALK,      0.055442133035731_REALK, &
      0.000000000000000_REALK,      0.184745745977675_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.705805895061747_REALK,      0.000000000000000_REALK, &
      1.023745645882845_REALK,      0.000000000000000_REALK,      7.937198131162944_REALK, &
    -10.481987624437631_REALK,     -0.925744498131705_REALK,      0.000000000000000_REALK, &
     -0.969426388538573_REALK,      0.000000000000000_REALK,     -4.176687860425822_REALK, &
     -0.202554702612845_REALK,      0.000000000000000_REALK,     -0.432886990064618_REALK, &
      0.000000000000000_REALK,     -0.288932948262769_REALK,      0.000000000000000_REALK, &
     -0.551230711115511_REALK,      0.000000000000000_REALK,     -3.958214614728391_REALK, &
      0.084320838657912_REALK,      0.000000000000000_REALK,     -0.161933078710336_REALK, &
      0.000000000000000_REALK,     -0.576788410987084_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.405260715429471_REALK, &
      0.000000000000000_REALK,      0.584382309573563_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.461151070550347_REALK,      0.000000000000000_REALK, &
      2.653887518752923_REALK,      0.000000000000000_REALK,      0.232799160139598_REALK, &
      0.000000000000000_REALK,      0.553814571651275_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.338810086927331_REALK,      0.000000000000000_REALK, &
      0.614448110736761_REALK,      0.000000000000000_REALK,      4.950539609684366_REALK, &
     -3.173208549162646_REALK,     -0.731520438550358_REALK,      0.000000000000000_REALK, &
     -0.438394044362004_REALK,      0.000000000000000_REALK,     -2.107345492850984_REALK, &
     -0.209541650268950_REALK,      0.000000000000000_REALK,     -0.570109933957469_REALK, &
      0.000000000000000_REALK,     -0.123454838982391_REALK,      0.000000000000000_REALK, &
     -0.415462627658907_REALK,      0.000000000000000_REALK,     -2.795960916774874_REALK, &
      0.073262879419103_REALK,      0.000000000000000_REALK,     -0.279198031514409_REALK, &
      0.000000000000000_REALK,     -1.063478308702859_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.999937099083020_REALK, &
      0.000000000000000_REALK,      0.688869440465327_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.483781480072426_REALK,      0.000000000000000_REALK, &
      2.182109379789190_REALK,      0.000000000000000_REALK,      0.407042524685479_REALK, &
      0.000000000000000_REALK,      0.913970698604297_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.596336752365100_REALK,      0.000000000000000_REALK, &
      0.902441931923206_REALK,      0.000000000000000_REALK,      5.233485355716824_REALK, &
     -2.069918403963078_REALK,     -0.698530181313674_REALK,      0.000000000000000_REALK, &
     -0.287781537836448_REALK,      0.000000000000000_REALK,     -1.924502096919138_REALK, &
      0.043508659090149_REALK,      0.000000000000000_REALK,     -0.762158600592637_REALK, &
      0.000000000000000_REALK,      0.481014137381123_REALK,      0.000000000000000_REALK, &
     -0.381819656572552_REALK,      0.000000000000000_REALK,     -3.282904216257005_REALK, &
      1.630981987873080_REALK,      0.000000000000000_REALK,      0.081160689240986_REALK, &
      0.000000000000000_REALK,     -1.827931226490827_REALK,      0.000000000000000_REALK, &
    ! results of test 2, ket-major order, CM010200
    -12.841315048024716_REALK,     -6.218482067973838_REALK,      0.000000000000000_REALK, &
     -5.973289396353412_REALK,      0.000000000000000_REALK,     -3.435622173032111_REALK, &
     -9.836523772609244_REALK,      0.000000000000000_REALK,     -2.181303238269039_REALK, &
      0.000000000000000_REALK,    -19.039885604114129_REALK,      0.000000000000000_REALK, &
     -2.499611593275262_REALK,      0.000000000000000_REALK,     -4.313061251845893_REALK, &
   -108.524621986204181_REALK,      0.000000000000000_REALK,     -8.689412999284972_REALK, &
      0.000000000000000_REALK,     -5.780775348739766_REALK,      0.000000000000000_REALK, &
    -14.822094448330979_REALK,     -4.032575338315663_REALK,      0.000000000000000_REALK, &
     -3.007820970915987_REALK,      0.000000000000000_REALK,     -3.516752506285465_REALK, &
     -1.322807370910285_REALK,      0.000000000000000_REALK,     -1.216888582502659_REALK, &
      0.000000000000000_REALK,      0.634763283209321_REALK,      0.000000000000000_REALK, &
     -1.108983152870312_REALK,      0.000000000000000_REALK,     -3.889878406989100_REALK, &
     15.647217482596345_REALK,      0.000000000000000_REALK,     -0.937411217318028_REALK, &
      0.000000000000000_REALK,     -2.587054697191266_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.554315439149990_REALK, &
      0.000000000000000_REALK,      1.121150142639517_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.340142604619735_REALK,      0.000000000000000_REALK, &
      2.312406117607845_REALK,      0.000000000000000_REALK,      1.864070544620624_REALK, &
      0.000000000000000_REALK,      1.240103681749449_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      7.233964254793984_REALK,      0.000000000000000_REALK, &
      2.849087640429108_REALK,      0.000000000000000_REALK,      8.193465962276683_REALK, &
    -19.521029960025729_REALK,     -3.432533920674207_REALK,      0.000000000000000_REALK, &
     -3.375485587487803_REALK,      0.000000000000000_REALK,     -4.147638052913449_REALK, &
     -2.005194089825141_REALK,      0.000000000000000_REALK,     -0.893587389482588_REALK, &
      0.000000000000000_REALK,     -3.548824495002989_REALK,      0.000000000000000_REALK, &
     -1.082454443649685_REALK,      0.000000000000000_REALK,     -3.990207445413585_REALK, &
     -9.679373831577765_REALK,      0.000000000000000_REALK,     -1.126351427776208_REALK, &
      0.000000000000000_REALK,     -1.505829441290089_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.798070859512836_REALK, &
      0.000000000000000_REALK,      0.741817883349638_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.623004350632967_REALK,      0.000000000000000_REALK, &
      2.185255172465947_REALK,      0.000000000000000_REALK,      0.258592817688406_REALK, &
      0.000000000000000_REALK,      0.713660932685160_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.200306677193137_REALK,      0.000000000000000_REALK, &
      1.049856235972784_REALK,      0.000000000000000_REALK,      6.137473913502811_REALK, &
     -2.211521750982418_REALK,     -0.892032503752099_REALK,      0.000000000000000_REALK, &
     -0.816953798926378_REALK,      0.000000000000000_REALK,     -1.409647716540112_REALK, &
     -1.047197205998694_REALK,      0.000000000000000_REALK,     -0.696665217110125_REALK, &
      0.000000000000000_REALK,     -1.995550261342504_REALK,      0.000000000000000_REALK, &
     -0.785944937684506_REALK,      0.000000000000000_REALK,     -2.260236927696540_REALK, &
     -7.346556370282542_REALK,      0.000000000000000_REALK,     -1.764685135655982_REALK, &
      0.000000000000000_REALK,     -1.956643164758276_REALK,      0.000000000000000_REALK, &
    -29.744449851708147_REALK,     -2.348284139858621_REALK,      0.000000000000000_REALK, &
     -3.514335438104707_REALK,      0.000000000000000_REALK,     -5.445468619730696_REALK, &
     -0.474220306166104_REALK,      0.000000000000000_REALK,     -0.519687894344195_REALK, &
      0.000000000000000_REALK,     -1.059694549232893_REALK,      0.000000000000000_REALK, &
     -0.961999287102852_REALK,      0.000000000000000_REALK,     -4.471858497048061_REALK, &
      2.743991547140387_REALK,      0.000000000000000_REALK,     -0.209310213337532_REALK, &
      0.000000000000000_REALK,     -0.688135762765178_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.713729551060695_REALK, &
      0.000000000000000_REALK,      0.641449140563382_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.668863715011095_REALK,      0.000000000000000_REALK, &
      2.465604895671709_REALK,      0.000000000000000_REALK,      0.394015358299155_REALK, &
      0.000000000000000_REALK,      0.526762706750185_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.967882872970382_REALK,      0.000000000000000_REALK, &
      0.885664353016983_REALK,      0.000000000000000_REALK,      5.441313668022710_REALK, &
     -2.856122164109487_REALK,     -0.664212006871163_REALK,      0.000000000000000_REALK, &
     -0.447214911472910_REALK,      0.000000000000000_REALK,     -1.568654693193027_REALK, &
     -0.159788112773668_REALK,      0.000000000000000_REALK,     -0.440981055133033_REALK, &
      0.000000000000000_REALK,      0.070070410741867_REALK,      0.000000000000000_REALK, &
     -0.367256142957194_REALK,      0.000000000000000_REALK,     -2.146984434382947_REALK, &
      1.177231065477775_REALK,      0.000000000000000_REALK,     -0.211580673825531_REALK, &
      0.000000000000000_REALK,     -0.973195765001410_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.262176283155411_REALK, &
      0.000000000000000_REALK,      0.500091328543082_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.485646351121592_REALK,      0.000000000000000_REALK, &
      1.396631957246259_REALK,      0.000000000000000_REALK,      0.617314480067259_REALK, &
      0.000000000000000_REALK,      0.684464403039761_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.632759458371035_REALK,      0.000000000000000_REALK, &
      1.071767067311633_REALK,      0.000000000000000_REALK,      4.315094279745677_REALK, &
    -49.763620645495145_REALK,     -0.339933486766419_REALK,      0.000000000000000_REALK, &
     -5.086255076046133_REALK,      0.000000000000000_REALK,     -8.062383463241197_REALK, &
      0.069162002257704_REALK,      0.000000000000000_REALK,     -0.064445153685395_REALK, &
      0.000000000000000_REALK,     -2.609383248656780_REALK,      0.000000000000000_REALK, &
     -1.176575093102139_REALK,      0.000000000000000_REALK,     -5.595078952231136_REALK, &
     -1.218151078102589_REALK,      0.000000000000000_REALK,      0.023883904859953_REALK, &
      0.000000000000000_REALK,     -0.066765067626519_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.532682147201803_REALK, &
      0.000000000000000_REALK,      0.437804321470271_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.676924117844168_REALK,      0.000000000000000_REALK, &
      3.146685147090509_REALK,      0.000000000000000_REALK,      0.092414284304727_REALK, &
      0.000000000000000_REALK,      0.303824514850029_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.257503841737865_REALK,      0.000000000000000_REALK, &
      0.701292213942386_REALK,      0.000000000000000_REALK,      5.433267272779543_REALK, &
     -4.273544131410612_REALK,     -0.651722460666475_REALK,      0.000000000000000_REALK, &
     -0.563475555412056_REALK,      0.000000000000000_REALK,     -2.077116842841826_REALK, &
     -0.277254362253174_REALK,      0.000000000000000_REALK,     -0.370663871959763_REALK, &
      0.000000000000000_REALK,     -0.427337976346721_REALK,      0.000000000000000_REALK, &
     -0.391036997254818_REALK,      0.000000000000000_REALK,     -2.402439423712927_REALK, &
     -0.822790961286946_REALK,      0.000000000000000_REALK,     -0.287235039207856_REALK, &
      0.000000000000000_REALK,     -0.640011882530680_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.593777950479236_REALK, &
      0.000000000000000_REALK,      0.371498766326648_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.258424869879940_REALK,      0.000000000000000_REALK, &
      1.510755323578999_REALK,      0.000000000000000_REALK,      0.093416734102541_REALK, &
      0.000000000000000_REALK,      0.429683715270812_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.051080945838334_REALK,      0.000000000000000_REALK, &
      0.446212862856408_REALK,      0.000000000000000_REALK,      3.651993098234303_REALK, &
     -1.452439111012775_REALK,     -0.508100690430124_REALK,      0.000000000000000_REALK, &
     -0.409126465213527_REALK,      0.000000000000000_REALK,     -1.176574465251877_REALK, &
     -0.434381880999547_REALK,      0.000000000000000_REALK,     -0.481632854031302_REALK, &
      0.000000000000000_REALK,     -0.720893139331950_REALK,      0.000000000000000_REALK, &
     -0.473204746618167_REALK,      0.000000000000000_REALK,     -1.905192982279640_REALK, &
     -1.873472483829528_REALK,      0.000000000000000_REALK,     -0.750031460918632_REALK, &
      0.000000000000000_REALK,     -1.164265206518222_REALK,      0.000000000000000_REALK, &
   -104.833841172721520_REALK,      5.664361898454571_REALK,      0.000000000000000_REALK, &
     -8.896754900662163_REALK,      0.000000000000000_REALK,    -13.924147705443925_REALK, &
      2.290574228265770_REALK,      0.000000000000000_REALK,      0.882903284080103_REALK, &
      0.000000000000000_REALK,     -3.024878984642309_REALK,      0.000000000000000_REALK, &
     -1.686277090760004_REALK,      0.000000000000000_REALK,     -7.917483918423227_REALK, &
      3.435612638766994_REALK,      0.000000000000000_REALK,      0.610402576049774_REALK, &
      0.000000000000000_REALK,      0.705840176260077_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     10.006202186155212_REALK, &
      0.000000000000000_REALK,      0.066038281674489_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.983934298036853_REALK,      0.000000000000000_REALK, &
      4.678995937955320_REALK,      0.000000000000000_REALK,     -0.013432918257759_REALK, &
      0.000000000000000_REALK,      0.037550379687056_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.581508820556380_REALK,      0.000000000000000_REALK, &
      0.786609780343345_REALK,      0.000000000000000_REALK,      6.234399956592400_REALK, &
     -8.092270908536420_REALK,     -0.543357752527799_REALK,      0.000000000000000_REALK, &
     -0.693658142002059_REALK,      0.000000000000000_REALK,     -3.224473342075183_REALK, &
     -0.077283281355384_REALK,      0.000000000000000_REALK,     -0.254079286989801_REALK, &
      0.000000000000000_REALK,     -0.144826739069934_REALK,      0.000000000000000_REALK, &
     -0.394424657103962_REALK,      0.000000000000000_REALK,     -3.055808318437005_REALK, &
      0.269991374585475_REALK,      0.000000000000000_REALK,     -0.061784394641455_REALK, &
      0.000000000000000_REALK,     -0.338540985456049_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.577904063792595_REALK, &
      0.000000000000000_REALK,      0.379826934737887_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.327012458155918_REALK,      0.000000000000000_REALK, &
      2.009087700228780_REALK,      0.000000000000000_REALK,      0.161548324072950_REALK, &
      0.000000000000000_REALK,      0.359959033183225_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.285700618411172_REALK,      0.000000000000000_REALK, &
      0.435718791374573_REALK,      0.000000000000000_REALK,      3.747735414191917_REALK, &
     -2.331108601612479_REALK,     -0.461066108393369_REALK,      0.000000000000000_REALK, &
     -0.264813308261104_REALK,      0.000000000000000_REALK,     -1.548102221724610_REALK, &
     -0.078121599915680_REALK,      0.000000000000000_REALK,     -0.359331543937546_REALK, &
      0.000000000000000_REALK,      0.028729228909543_REALK,      0.000000000000000_REALK, &
     -0.250961513515355_REALK,      0.000000000000000_REALK,     -2.053974216282168_REALK, &
      0.347496223781341_REALK,      0.000000000000000_REALK,     -0.104090985669049_REALK, &
      0.000000000000000_REALK,     -0.670294060581651_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.460243368484584_REALK, &
      0.000000000000000_REALK,      0.493539145448813_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.395726871086360_REALK,      0.000000000000000_REALK, &
      1.593255484188056_REALK,      0.000000000000000_REALK,      0.421836854749850_REALK, &
      0.000000000000000_REALK,      0.654812495746244_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.803265904722698_REALK,      0.000000000000000_REALK, &
      0.738185599836597_REALK,      0.000000000000000_REALK,      3.821201320906862_REALK, &
   -236.696444081570831_REALK,     24.799750353801972_REALK,      0.000000000000000_REALK, &
    -19.916360724989506_REALK,      0.000000000000000_REALK,    -27.786499796732453_REALK, &
      7.097854988141232_REALK,      0.000000000000000_REALK,      3.269642033324498_REALK, &
      0.000000000000000_REALK,     -7.250048405889999_REALK,      0.000000000000000_REALK, &
     -3.090143150008664_REALK,      0.000000000000000_REALK,    -12.933727681762782_REALK, &
      4.461868230579772_REALK,      0.000000000000000_REALK,      1.452086001341362_REALK, &
      0.000000000000000_REALK,      2.006719537347643_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     20.534453222333713_REALK, &
      0.000000000000000_REALK,     -1.105815143830220_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.729812562310834_REALK,      0.000000000000000_REALK, &
      8.121893619399071_REALK,      0.000000000000000_REALK,     -0.445125409135938_REALK, &
      0.000000000000000_REALK,     -0.514721610900819_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.634809369185614_REALK,      0.000000000000000_REALK, &
      1.061660154034982_REALK,      0.000000000000000_REALK,      8.307924048052170_REALK, &
    -16.640206244732067_REALK,     -0.097389085107012_REALK,      0.000000000000000_REALK, &
     -1.232354060656540_REALK,      0.000000000000000_REALK,     -5.860329958452901_REALK, &
      0.013779722726526_REALK,      0.000000000000000_REALK,     -0.038519836898772_REALK, &
      0.000000000000000_REALK,     -0.424055142986828_REALK,      0.000000000000000_REALK, &
     -0.573621432877293_REALK,      0.000000000000000_REALK,     -4.546327195003478_REALK, &
     -0.143781005561479_REALK,      0.000000000000000_REALK,      0.008457206792891_REALK, &
      0.000000000000000_REALK,     -0.039402126436868_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.755249542750661_REALK, &
      0.000000000000000_REALK,      0.318228200475711_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.404607718673372_REALK,      0.000000000000000_REALK, &
      3.134701672821689_REALK,      0.000000000000000_REALK,      0.045055189840403_REALK, &
      0.000000000000000_REALK,      0.246875096162961_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.091181205598940_REALK,      0.000000000000000_REALK, &
      0.413875181517429_REALK,      0.000000000000000_REALK,      4.489101985830267_REALK, &
     -4.287026636339078_REALK,     -0.560144763539685_REALK,      0.000000000000000_REALK, &
     -0.409575244503397_REALK,      0.000000000000000_REALK,     -2.516334058617512_REALK, &
     -0.165719099152147_REALK,      0.000000000000000_REALK,     -0.369252278246259_REALK, &
      0.000000000000000_REALK,     -0.208342182111455_REALK,      0.000000000000000_REALK, &
     -0.317740312522875_REALK,      0.000000000000000_REALK,     -2.732970542770761_REALK, &
     -0.291347388449555_REALK,      0.000000000000000_REALK,     -0.169514863600187_REALK, &
      0.000000000000000_REALK,     -0.528793904032194_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.283043337939181_REALK, &
      0.000000000000000_REALK,      0.450054122695937_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.257440714289575_REALK,      0.000000000000000_REALK, &
      2.107002711153547_REALK,      0.000000000000000_REALK,      0.075906531855004_REALK, &
      0.000000000000000_REALK,      0.488800227365795_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.030145972407244_REALK,      0.000000000000000_REALK, &
      0.368672282842984_REALK,      0.000000000000000_REALK,      3.879473773540746_REALK, &
     -2.428368962272820_REALK,     -0.727840346856339_REALK,      0.000000000000000_REALK, &
     -0.495638395233497_REALK,      0.000000000000000_REALK,     -1.995514202035583_REALK, &
     -0.432727630939412_REALK,      0.000000000000000_REALK,     -0.671718122310167_REALK, &
      0.000000000000000_REALK,     -0.585767620442487_REALK,      0.000000000000000_REALK, &
     -0.538308945666588_REALK,      0.000000000000000_REALK,     -2.786544271105364_REALK, &
     -1.105650039879887_REALK,      0.000000000000000_REALK,     -0.619694845036133_REALK, &
      0.000000000000000_REALK,     -1.236786656666255_REALK,      0.000000000000000_REALK, &
    ! results of test 2, ket-major order, CM000300
    -10.912608867612734_REALK,     -2.337855493337198_REALK,      0.000000000000000_REALK, &
     -1.395097137474050_REALK,      0.000000000000000_REALK,     -2.589171504679721_REALK, &
      0.983365417179090_REALK,      0.000000000000000_REALK,     -0.705482084947587_REALK, &
      0.000000000000000_REALK,      5.163997444290630_REALK,      0.000000000000000_REALK, &
     -0.514372110918942_REALK,      0.000000000000000_REALK,     -2.863881467360669_REALK, &
     36.058167804933952_REALK,      0.000000000000000_REALK,      0.696864708390577_REALK, &
      0.000000000000000_REALK,     -1.499825676640331_REALK,      0.000000000000000_REALK, &
    -14.918542319962285_REALK,     -2.267397684201558_REALK,      0.000000000000000_REALK, &
     -2.539110803888300_REALK,      0.000000000000000_REALK,     -3.169746368249193_REALK, &
     -1.675474544127996_REALK,      0.000000000000000_REALK,     -0.590268887174339_REALK, &
      0.000000000000000_REALK,     -3.702343147353301_REALK,      0.000000000000000_REALK, &
     -0.814244854955331_REALK,      0.000000000000000_REALK,     -3.049433291262297_REALK, &
    -12.770873210666696_REALK,      0.000000000000000_REALK,     -0.941142383451682_REALK, &
      0.000000000000000_REALK,     -0.994692045843802_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.060049811460135_REALK, &
      0.000000000000000_REALK,      0.430063388318269_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.288963869394542_REALK,      0.000000000000000_REALK, &
      1.608870801368678_REALK,      0.000000000000000_REALK,     -0.192236027435110_REALK, &
      0.000000000000000_REALK,      0.413739606054087_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.629557342809648_REALK,      0.000000000000000_REALK, &
      0.486947675319543_REALK,      0.000000000000000_REALK,      4.518649674424003_REALK, &
    -23.094806825211315_REALK,     -1.274155477744433_REALK,      0.000000000000000_REALK, &
     -2.523587771070747_REALK,      0.000000000000000_REALK,     -4.228084448440667_REALK, &
      0.059197667913141_REALK,      0.000000000000000_REALK,     -0.281977451560011_REALK, &
      0.000000000000000_REALK,     -0.170555894907463_REALK,      0.000000000000000_REALK, &
     -0.690796220073060_REALK,      0.000000000000000_REALK,     -3.472133747771228_REALK, &
      4.767249558667538_REALK,      0.000000000000000_REALK,      0.026128523681658_REALK, &
      0.000000000000000_REALK,     -0.373375579503715_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.838140794099805_REALK, &
      0.000000000000000_REALK,      0.423716219404707_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.503133265154157_REALK,      0.000000000000000_REALK, &
      1.884287409819440_REALK,      0.000000000000000_REALK,      0.329226335832295_REALK, &
      0.000000000000000_REALK,      0.347958845858839_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.009752532769165_REALK,      0.000000000000000_REALK, &
      0.666215236024108_REALK,      0.000000000000000_REALK,      4.158411128860283_REALK, &
     -2.102789464990629_REALK,     -0.385071959908594_REALK,      0.000000000000000_REALK, &
     -0.207428649798118_REALK,      0.000000000000000_REALK,     -1.154905278389190_REALK, &
      0.118785325538222_REALK,      0.000000000000000_REALK,     -0.255655479614922_REALK, &
      0.000000000000000_REALK,      0.570044663204115_REALK,      0.000000000000000_REALK, &
     -0.170341918190467_REALK,      0.000000000000000_REALK,     -1.580694378850896_REALK, &
      2.712865424884174_REALK,      0.000000000000000_REALK,      0.157287540241252_REALK, &
      0.000000000000000_REALK,     -0.564202990501685_REALK,      0.000000000000000_REALK, &
    -39.270437397027735_REALK,      0.442177673594048_REALK,      0.000000000000000_REALK, &
     -3.989103354374512_REALK,      0.000000000000000_REALK,     -6.362345041562134_REALK, &
      0.204463418966842_REALK,      0.000000000000000_REALK,      0.083828776041119_REALK, &
      0.000000000000000_REALK,     -2.329810939547300_REALK,      0.000000000000000_REALK, &
     -0.922777088524586_REALK,      0.000000000000000_REALK,     -4.415297658710664_REALK, &
     -1.830688276254629_REALK,      0.000000000000000_REALK,      0.070607916002039_REALK, &
      0.000000000000000_REALK,      0.086846466822874_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.295800596479451_REALK, &
      0.000000000000000_REALK,      0.237548244232112_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.486088324754701_REALK,      0.000000000000000_REALK, &
      2.443214985455297_REALK,      0.000000000000000_REALK,     -0.011536220700734_REALK, &
      0.000000000000000_REALK,      0.164852141739762_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.041444771232903_REALK,      0.000000000000000_REALK, &
      0.503586662747988_REALK,      0.000000000000000_REALK,      4.218610823873760_REALK, &
     -3.265967477701246_REALK,     -0.430502372942919_REALK,      0.000000000000000_REALK, &
     -0.423858088974549_REALK,      0.000000000000000_REALK,     -1.587393471906817_REALK, &
     -0.231664669550339_REALK,      0.000000000000000_REALK,     -0.244846059593687_REALK, &
      0.000000000000000_REALK,     -0.445824196310327_REALK,      0.000000000000000_REALK, &
     -0.294146201699147_REALK,      0.000000000000000_REALK,     -1.836014507800072_REALK, &
     -1.085582520968236_REALK,      0.000000000000000_REALK,     -0.240004196509644_REALK, &
      0.000000000000000_REALK,     -0.422766822950001_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.173402008470118_REALK, &
      0.000000000000000_REALK,      0.215373640604445_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.119863449223780_REALK,      0.000000000000000_REALK, &
      1.112277485368320_REALK,      0.000000000000000_REALK,     -0.069445323425314_REALK, &
      0.000000000000000_REALK,      0.249105931040828_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.415559438831179_REALK,      0.000000000000000_REALK, &
      0.206963876405682_REALK,      0.000000000000000_REALK,      2.688740947318665_REALK, &
    -83.767622790150568_REALK,      5.793997052707661_REALK,      0.000000000000000_REALK, &
     -7.131577369449198_REALK,      0.000000000000000_REALK,    -11.126109084777774_REALK, &
      2.268889088670220_REALK,      0.000000000000000_REALK,      0.903109497149489_REALK, &
      0.000000000000000_REALK,     -2.282878952979582_REALK,      0.000000000000000_REALK, &
     -1.351708086078625_REALK,      0.000000000000000_REALK,     -6.326476249523679_REALK, &
      3.730346498362352_REALK,      0.000000000000000_REALK,      0.604623822011690_REALK, &
      0.000000000000000_REALK,      0.721994105293543_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.896289125196159_REALK, &
      0.000000000000000_REALK,     -0.085901080345870_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.771690674199160_REALK,      0.000000000000000_REALK, &
      3.692380391117203_REALK,      0.000000000000000_REALK,     -0.039711695787083_REALK, &
      0.000000000000000_REALK,     -0.048844671616612_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.519205299671065_REALK,      0.000000000000000_REALK, &
      0.616930859037982_REALK,      0.000000000000000_REALK,      4.919811099507633_REALK, &
     -6.283169947390817_REALK,     -0.294820479773747_REALK,      0.000000000000000_REALK, &
     -0.498104758435952_REALK,      0.000000000000000_REALK,     -2.503612920041730_REALK, &
      0.009647393764938_REALK,      0.000000000000000_REALK,     -0.137860878845328_REALK, &
      0.000000000000000_REALK,     -0.023309598135126_REALK,      0.000000000000000_REALK, &
     -0.283230004308620_REALK,      0.000000000000000_REALK,     -2.372654500621857_REALK, &
      0.469067137862724_REALK,      0.000000000000000_REALK,      0.007712643319239_REALK, &
      0.000000000000000_REALK,     -0.183688951323324_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.970109720196438_REALK, &
      0.000000000000000_REALK,      0.250898820557876_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.245985605326707_REALK,      0.000000000000000_REALK, &
      1.535403610452696_REALK,      0.000000000000000_REALK,      0.134984491528384_REALK, &
      0.000000000000000_REALK,      0.237774861693651_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.298059745771765_REALK,      0.000000000000000_REALK, &
      0.327756781050196_REALK,      0.000000000000000_REALK,      2.864129069784481_REALK, &
     -1.716253832142401_REALK,     -0.267299639527445_REALK,      0.000000000000000_REALK, &
     -0.122826555134893_REALK,      0.000000000000000_REALK,     -1.139773740590707_REALK, &
      0.058075031468048_REALK,      0.000000000000000_REALK,     -0.208319784119547_REALK, &
      0.000000000000000_REALK,      0.233721244737458_REALK,      0.000000000000000_REALK, &
     -0.116401771417534_REALK,      0.000000000000000_REALK,     -1.512216598307578_REALK, &
      0.800786284374528_REALK,      0.000000000000000_REALK,      0.077380484716069_REALK, &
      0.000000000000000_REALK,     -0.388597985211267_REALK,      0.000000000000000_REALK, &
   -191.241086685086827_REALK,     22.463873489995184_REALK,      0.000000000000000_REALK, &
    -16.506864679688118_REALK,      0.000000000000000_REALK,    -22.450360151886205_REALK, &
      6.298878348251308_REALK,      0.000000000000000_REALK,      2.961675982472619_REALK, &
      0.000000000000000_REALK,     -6.301110334927731_REALK,      0.000000000000000_REALK, &
     -2.561139332752523_REALK,      0.000000000000000_REALK,    -10.449925204186398_REALK, &
      3.541869703310772_REALK,      0.000000000000000_REALK,      1.288630591767442_REALK, &
      0.000000000000000_REALK,      1.817707564542812_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     16.408082661937510_REALK, &
      0.000000000000000_REALK,     -1.131122940068477_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.386605819819394_REALK,      0.000000000000000_REALK, &
      6.489810097968482_REALK,      0.000000000000000_REALK,     -0.440911353762606_REALK, &
      0.000000000000000_REALK,     -0.526501581288080_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.479091215029037_REALK,      0.000000000000000_REALK, &
      0.851019457442658_REALK,      0.000000000000000_REALK,      6.638457963968433_REALK, &
    -13.131443595363391_REALK,      0.126681485533262_REALK,      0.000000000000000_REALK, &
     -0.966524022810819_REALK,      0.000000000000000_REALK,     -4.624617698113251_REALK, &
      0.040736952793566_REALK,      0.000000000000000_REALK,      0.050105719295683_REALK, &
      0.000000000000000_REALK,     -0.378621389407086_REALK,      0.000000000000000_REALK, &
     -0.449886045394859_REALK,      0.000000000000000_REALK,     -3.587686249150579_REALK, &
     -0.216080095450470_REALK,      0.000000000000000_REALK,      0.025002014969736_REALK, &
      0.000000000000000_REALK,      0.051253381266567_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.692170140749608_REALK, &
      0.000000000000000_REALK,      0.172667437439360_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.290542297088071_REALK,      0.000000000000000_REALK, &
      2.433910526145643_REALK,      0.000000000000000_REALK,     -0.005624310328461_REALK, &
      0.000000000000000_REALK,      0.133951956986627_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.014675447874037_REALK,      0.000000000000000_REALK, &
      0.297197113144767_REALK,      0.000000000000000_REALK,      3.485522297379749_REALK, &
     -3.276271202492730_REALK,     -0.370009727221588_REALK,      0.000000000000000_REALK, &
     -0.308091058714238_REALK,      0.000000000000000_REALK,     -1.923056120579733_REALK, &
     -0.138469454659852_REALK,      0.000000000000000_REALK,     -0.243913615984680_REALK, &
      0.000000000000000_REALK,     -0.217354859709491_REALK,      0.000000000000000_REALK, &
     -0.239010903601019_REALK,      0.000000000000000_REALK,     -2.088616060987908_REALK, &
     -0.384400956393439_REALK,      0.000000000000000_REALK,     -0.141641071183394_REALK, &
      0.000000000000000_REALK,     -0.349300575356586_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.680866294678394_REALK, &
      0.000000000000000_REALK,      0.260915522903341_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.119406975031923_REALK,      0.000000000000000_REALK, &
      1.551258261777394_REALK,      0.000000000000000_REALK,     -0.056428365917592_REALK, &
      0.000000000000000_REALK,      0.283378288269972_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.245246895314404_REALK,      0.000000000000000_REALK, &
      0.170998756719100_REALK,      0.000000000000000_REALK,      2.856221167014549_REALK, &
   -808.857417275759644_REALK,    112.079817670966236_REALK,      0.000000000000000_REALK, &
    -56.223567387000628_REALK,      0.000000000000000_REALK,    -65.706057511520200_REALK, &
     23.557332069964335_REALK,      0.000000000000000_REALK,     10.482675378844164_REALK, &
      0.000000000000000_REALK,    -15.794583345713630_REALK,      0.000000000000000_REALK, &
     -6.262019534909194_REALK,      0.000000000000000_REALK,    -21.954456190953369_REALK, &
     13.891866925639887_REALK,      0.000000000000000_REALK,      3.375699447869268_REALK, &
      0.000000000000000_REALK,      4.506413720806025_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     55.066450044169081_REALK, &
      0.000000000000000_REALK,     -5.686163712738114_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.786806201788505_REALK,      0.000000000000000_REALK, &
     15.450874173608577_REALK,      0.000000000000000_REALK,     -1.346917689774261_REALK, &
      0.000000000000000_REALK,     -1.899925773266950_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.335041072484457_REALK,      0.000000000000000_REALK, &
      1.627916043285381_REALK,      0.000000000000000_REALK,     11.070334124009101_REALK, &
    -51.128036316522746_REALK,      2.774428759792582_REALK,      0.000000000000000_REALK, &
     -2.662164174335508_REALK,      0.000000000000000_REALK,    -12.459878426951091_REALK, &
      0.651915273610979_REALK,      0.000000000000000_REALK,      0.778465828772546_REALK, &
      0.000000000000000_REALK,     -0.500761379297218_REALK,      0.000000000000000_REALK, &
     -0.889512610436672_REALK,      0.000000000000000_REALK,     -6.938727453480763_REALK, &
      0.576358555735128_REALK,      0.000000000000000_REALK,      0.280252877021501_REALK, &
      0.000000000000000_REALK,      0.557759821988313_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     11.343304861197863_REALK, &
      0.000000000000000_REALK,     -0.096198680931293_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.665184921809162_REALK,      0.000000000000000_REALK, &
      5.304620629036086_REALK,      0.000000000000000_REALK,     -0.026132901436516_REALK, &
      0.000000000000000_REALK,     -0.053571664625779_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.240660016526463_REALK,      0.000000000000000_REALK, &
      0.476595644747294_REALK,      0.000000000000000_REALK,      5.320960545441812_REALK, &
    -11.504903585166119_REALK,     -0.423520280016995_REALK,      0.000000000000000_REALK, &
     -0.557816275816405_REALK,      0.000000000000000_REALK,     -4.672899329880910_REALK, &
      0.008315897913179_REALK,      0.000000000000000_REALK,     -0.198056425502439_REALK, &
      0.000000000000000_REALK,     -0.015339244988581_REALK,      0.000000000000000_REALK, &
     -0.310639877403105_REALK,      0.000000000000000_REALK,     -3.643178790287992_REALK, &
      0.217420171214703_REALK,      0.000000000000000_REALK,      0.005958223942907_REALK, &
      0.000000000000000_REALK,     -0.198666502200217_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.716889754979740_REALK, &
      0.000000000000000_REALK,      0.468293209811870_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.353392711000496_REALK,      0.000000000000000_REALK, &
      3.088150711583459_REALK,      0.000000000000000_REALK,      0.148047753634207_REALK, &
      0.000000000000000_REALK,      0.365100073676522_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.230259152428884_REALK,      0.000000000000000_REALK, &
      0.354481272795949_REALK,      0.000000000000000_REALK,      3.982709824254152_REALK, &
     -5.237625548833504_REALK,     -0.639975996398346_REALK,      0.000000000000000_REALK, &
     -0.229251144450818_REALK,      0.000000000000000_REALK,     -2.978282732279059_REALK, &
      0.083432901631274_REALK,      0.000000000000000_REALK,     -0.418992690381922_REALK, &
      0.000000000000000_REALK,      0.256339857032357_REALK,      0.000000000000000_REALK, &
     -0.178733340513405_REALK,      0.000000000000000_REALK,     -2.985413228847095_REALK, &
      0.618628894818781_REALK,      0.000000000000000_REALK,      0.083689901468488_REALK, &
      0.000000000000000_REALK,     -0.540364269792751_REALK,      0.000000000000000_REALK, &
    ! results of test 2, ket-major order, CM020001
      0.000000000000000_REALK,      0.000000000000000_REALK,      9.498977974194720_REALK, &
      0.000000000000000_REALK,      8.376059208725142_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     17.558134715251079_REALK,      0.000000000000000_REALK, &
     11.490446321013680_REALK,      0.000000000000000_REALK,     25.808725059111350_REALK, &
      0.000000000000000_REALK,     11.759405454612555_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    154.183396025377590_REALK,      0.000000000000000_REALK, &
     56.769186883166732_REALK,      0.000000000000000_REALK,     61.918431271064669_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.861784833809879_REALK, &
      0.000000000000000_REALK,      3.889365198819940_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.127557708874646_REALK,      0.000000000000000_REALK, &
      6.168545683782278_REALK,      0.000000000000000_REALK,      5.913148748496719_REALK, &
      0.000000000000000_REALK,      4.882687760308444_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     17.843448738928611_REALK,      0.000000000000000_REALK, &
     13.588784302280118_REALK,      0.000000000000000_REALK,     27.245926655816277_REALK, &
     -5.984662657829741_REALK,     -6.126923989504257_REALK,      0.000000000000000_REALK, &
     -7.340037934792820_REALK,      0.000000000000000_REALK,     -4.803489280138773_REALK, &
    -14.150656583738543_REALK,      0.000000000000000_REALK,     -6.447560188891163_REALK, &
      0.000000000000000_REALK,    -25.026693027795837_REALK,      0.000000000000000_REALK, &
     -9.214643406406370_REALK,      0.000000000000000_REALK,    -10.050456872337625_REALK, &
   -120.915750529427186_REALK,      0.000000000000000_REALK,    -37.501327331577777_REALK, &
      0.000000000000000_REALK,    -28.478309316463825_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.095878376584786_REALK, &
      0.000000000000000_REALK,      2.614959710196998_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.840498349444914_REALK,      0.000000000000000_REALK, &
      4.613267473543329_REALK,      0.000000000000000_REALK,      3.205323282957923_REALK, &
      0.000000000000000_REALK,      2.892405790189006_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      8.726360873029481_REALK,      0.000000000000000_REALK, &
      6.038781777525180_REALK,      0.000000000000000_REALK,     16.346025783073799_REALK, &
     -4.454275078160751_REALK,     -2.891664180601849_REALK,      0.000000000000000_REALK, &
     -2.635471288833303_REALK,      0.000000000000000_REALK,     -3.170520151402206_REALK, &
     -3.170277568976557_REALK,      0.000000000000000_REALK,     -2.617805866418892_REALK, &
      0.000000000000000_REALK,     -3.827812904211348_REALK,      0.000000000000000_REALK, &
     -2.915093638335278_REALK,      0.000000000000000_REALK,     -5.844851584817095_REALK, &
     -8.053313355271923_REALK,      0.000000000000000_REALK,     -6.739878731833686_REALK, &
      0.000000000000000_REALK,     -9.275577978724620_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.571296904054316_REALK, &
      0.000000000000000_REALK,      3.313928526135815_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.940342030948329_REALK,      0.000000000000000_REALK, &
      5.388455345121941_REALK,      0.000000000000000_REALK,      8.044860989887669_REALK, &
      0.000000000000000_REALK,      6.109224818958840_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     28.525728548441087_REALK,      0.000000000000000_REALK, &
     17.504937374259551_REALK,      0.000000000000000_REALK,     26.729809773746883_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.281215813996009_REALK, &
      0.000000000000000_REALK,      1.904090070563716_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.739388656087990_REALK,      0.000000000000000_REALK, &
      4.124557509045027_REALK,      0.000000000000000_REALK,      1.468823803195582_REALK, &
      0.000000000000000_REALK,      1.831817116000397_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.584866004208430_REALK,      0.000000000000000_REALK, &
      2.931132062752027_REALK,      0.000000000000000_REALK,     11.584168492295587_REALK, &
     -4.412002408726964_REALK,     -2.080567953196880_REALK,      0.000000000000000_REALK, &
     -1.731573870887858_REALK,      0.000000000000000_REALK,     -2.812257721665466_REALK, &
     -1.800685921422160_REALK,      0.000000000000000_REALK,     -1.624895190174692_REALK, &
      0.000000000000000_REALK,     -2.407240498762861_REALK,      0.000000000000000_REALK, &
     -1.665849060056478_REALK,      0.000000000000000_REALK,     -4.509189550073771_REALK, &
     -6.035684431791796_REALK,      0.000000000000000_REALK,     -3.034427194148421_REALK, &
      0.000000000000000_REALK,     -4.563655525235355_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.522594362065871_REALK, &
      0.000000000000000_REALK,      1.595820056798738_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.637640765312640_REALK,      0.000000000000000_REALK, &
      3.283519642945265_REALK,      0.000000000000000_REALK,      1.859252588345908_REALK, &
      0.000000000000000_REALK,      2.558746685440157_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.623727950440135_REALK,      0.000000000000000_REALK, &
      4.599452550638788_REALK,      0.000000000000000_REALK,     12.910859550755971_REALK, &
     -3.092022489266455_REALK,     -2.636695878631232_REALK,      0.000000000000000_REALK, &
     -3.011643071614846_REALK,      0.000000000000000_REALK,     -3.284813906645122_REALK, &
     -4.519440519871965_REALK,      0.000000000000000_REALK,     -3.432039189554172_REALK, &
      0.000000000000000_REALK,     -7.869063635765515_REALK,      0.000000000000000_REALK, &
     -4.828885120470177_REALK,      0.000000000000000_REALK,     -7.373644242752079_REALK, &
    -24.556115314524170_REALK,      0.000000000000000_REALK,    -12.693230815255744_REALK, &
      0.000000000000000_REALK,    -13.494841136165212_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.558248901698905_REALK, &
      0.000000000000000_REALK,      1.545775357129144_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.405936639614655_REALK,      0.000000000000000_REALK, &
      4.354127131967385_REALK,      0.000000000000000_REALK,      0.935801510933257_REALK, &
      0.000000000000000_REALK,      1.269401983193748_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.688113386197643_REALK,      0.000000000000000_REALK, &
      1.861646754580685_REALK,      0.000000000000000_REALK,      9.609070584290903_REALK, &
     -5.390784685998170_REALK,     -1.704892151321304_REALK,      0.000000000000000_REALK, &
     -1.248595684860073_REALK,      0.000000000000000_REALK,     -2.960755602105248_REALK, &
     -0.907606737138649_REALK,      0.000000000000000_REALK,     -1.131905373585826_REALK, &
      0.000000000000000_REALK,     -0.904226584782958_REALK,      0.000000000000000_REALK, &
     -1.025355871575143_REALK,      0.000000000000000_REALK,     -4.052323445890375_REALK, &
     -1.013429235534717_REALK,      0.000000000000000_REALK,     -1.201791808408119_REALK, &
      0.000000000000000_REALK,     -2.497988299347122_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.518051110754819_REALK, &
      0.000000000000000_REALK,      1.166408160534409_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.029351394410935_REALK,      0.000000000000000_REALK, &
      2.786291184673290_REALK,      0.000000000000000_REALK,      1.061490125240595_REALK, &
      0.000000000000000_REALK,      1.596438129864738_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.969604459015063_REALK,      0.000000000000000_REALK, &
      2.271663161214060_REALK,      0.000000000000000_REALK,      8.608645312968134_REALK, &
     -2.574930382502315_REALK,     -1.428872053805631_REALK,      0.000000000000000_REALK, &
     -1.175557392399640_REALK,      0.000000000000000_REALK,     -2.357028397871391_REALK, &
     -1.148858135028821_REALK,      0.000000000000000_REALK,     -1.581085304639117_REALK, &
      0.000000000000000_REALK,     -1.267636753113806_REALK,      0.000000000000000_REALK, &
     -1.608960489620808_REALK,      0.000000000000000_REALK,     -4.516420742578327_REALK, &
     -1.817692635588020_REALK,      0.000000000000000_REALK,     -2.535401143843184_REALK, &
      0.000000000000000_REALK,     -4.884989290442845_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.941170449112397_REALK, &
      0.000000000000000_REALK,      2.463641065698216_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.983835541521193_REALK,      0.000000000000000_REALK, &
      4.556277735576886_REALK,      0.000000000000000_REALK,      4.440290804727925_REALK, &
      0.000000000000000_REALK,      4.720706641224915_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     10.730781319414158_REALK,      0.000000000000000_REALK, &
      9.218986870604512_REALK,      0.000000000000000_REALK,     18.099349758172117_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      9.350797485033633_REALK, &
      0.000000000000000_REALK,      1.228488684385625_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.347172234616798_REALK,      0.000000000000000_REALK, &
      5.318219043992621_REALK,      0.000000000000000_REALK,      0.489098541878626_REALK, &
      0.000000000000000_REALK,      0.852538360696736_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.890561640809281_REALK,      0.000000000000000_REALK, &
      1.395668102334651_REALK,      0.000000000000000_REALK,      9.182776201144632_REALK, &
     -7.546851681264873_REALK,     -1.570532183581999_REALK,      0.000000000000000_REALK, &
     -1.184413074146033_REALK,      0.000000000000000_REALK,     -3.668077889348995_REALK, &
     -0.658489689918041_REALK,      0.000000000000000_REALK,     -0.893232281128700_REALK, &
      0.000000000000000_REALK,     -0.745332910053039_REALK,      0.000000000000000_REALK, &
     -0.821951063493294_REALK,      0.000000000000000_REALK,     -4.242580267446608_REALK, &
     -0.993612745321977_REALK,      0.000000000000000_REALK,     -0.682194178531495_REALK, &
      0.000000000000000_REALK,     -1.542311827585968_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.008174466866277_REALK, &
      0.000000000000000_REALK,      0.953558990779735_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.721505855719135_REALK,      0.000000000000000_REALK, &
      2.851473499621521_REALK,      0.000000000000000_REALK,      0.530613045997051_REALK, &
      0.000000000000000_REALK,      1.102907484564458_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.659176230221266_REALK,      0.000000000000000_REALK, &
      1.245798028640462_REALK,      0.000000000000000_REALK,      6.892950418831525_REALK, &
     -2.897626873202098_REALK,     -1.185089118456506_REALK,      0.000000000000000_REALK, &
     -0.867163722089865_REALK,      0.000000000000000_REALK,     -2.347274844767824_REALK, &
     -0.746932223611888_REALK,      0.000000000000000_REALK,     -1.123355793751166_REALK, &
      0.000000000000000_REALK,     -0.869616362913708_REALK,      0.000000000000000_REALK, &
     -1.002980800017025_REALK,      0.000000000000000_REALK,     -3.800874227519323_REALK, &
     -1.539182187423318_REALK,      0.000000000000000_REALK,     -1.289700817155887_REALK, &
      0.000000000000000_REALK,     -2.715520866689339_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.394778089455896_REALK, &
      0.000000000000000_REALK,      1.331964793710761_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.132167325573329_REALK,      0.000000000000000_REALK, &
      3.178041988149691_REALK,      0.000000000000000_REALK,      1.119425939124209_REALK, &
      0.000000000000000_REALK,      2.156812044257682_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.540167089144758_REALK,      0.000000000000000_REALK, &
      2.736821240679205_REALK,      0.000000000000000_REALK,      9.877337990125049_REALK, &
     -3.384528016772963_REALK,     -2.503098244274858_REALK,      0.000000000000000_REALK, &
     -2.513693524231611_REALK,      0.000000000000000_REALK,     -3.838377041611809_REALK, &
     -3.124472103315249_REALK,      0.000000000000000_REALK,     -3.321790589196793_REALK, &
      0.000000000000000_REALK,     -4.737836056117469_REALK,      0.000000000000000_REALK, &
     -4.070351179126273_REALK,      0.000000000000000_REALK,     -7.991193681433667_REALK, &
    -10.436909492634529_REALK,      0.000000000000000_REALK,     -7.552877940486863_REALK, &
      0.000000000000000_REALK,    -10.324107895445442_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     16.305159002129546_REALK, &
      0.000000000000000_REALK,      0.751249850267578_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.702950782853468_REALK,      0.000000000000000_REALK, &
      7.624448449006821_REALK,      0.000000000000000_REALK,      0.194521409239006_REALK, &
      0.000000000000000_REALK,      0.427172185618651_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.921278896991963_REALK,      0.000000000000000_REALK, &
      1.361430071000250_REALK,      0.000000000000000_REALK,     10.158987464370615_REALK, &
    -13.676763719026132_REALK,     -1.524673964642288_REALK,      0.000000000000000_REALK, &
     -1.380475247649801_REALK,      0.000000000000000_REALK,     -5.449689032449463_REALK, &
     -0.409018373154035_REALK,      0.000000000000000_REALK,     -0.712952142535973_REALK, &
      0.000000000000000_REALK,     -0.500874618058999_REALK,      0.000000000000000_REALK, &
     -0.784959396026470_REALK,      0.000000000000000_REALK,     -5.164627928831454_REALK, &
     -0.156085564649661_REALK,      0.000000000000000_REALK,     -0.326991195758720_REALK, &
      0.000000000000000_REALK,     -0.949953551022120_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.552441491121554_REALK, &
      0.000000000000000_REALK,      0.915313590062735_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.687372907535032_REALK,      0.000000000000000_REALK, &
      3.547942041088828_REALK,      0.000000000000000_REALK,      0.383683434089444_REALK, &
      0.000000000000000_REALK,      0.867435573429817_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.498298969693209_REALK,      0.000000000000000_REALK, &
      0.915871200087398_REALK,      0.000000000000000_REALK,      6.618301447654484_REALK, &
     -4.399848405955452_REALK,     -1.183459469730099_REALK,      0.000000000000000_REALK, &
     -0.739341970730247_REALK,      0.000000000000000_REALK,     -2.921963862086696_REALK, &
     -0.443735702041571_REALK,      0.000000000000000_REALK,     -0.922328296754379_REALK, &
      0.000000000000000_REALK,     -0.370737551917929_REALK,      0.000000000000000_REALK, &
     -0.700668637835003_REALK,      0.000000000000000_REALK,     -3.876771410448867_REALK, &
     -0.299145038510347_REALK,      0.000000000000000_REALK,     -0.591243480060676_REALK, &
      0.000000000000000_REALK,     -1.720503500600836_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.913196425140102_REALK, &
      0.000000000000000_REALK,      1.151125912284402_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.838762621438156_REALK,      0.000000000000000_REALK, &
      3.178556589295346_REALK,      0.000000000000000_REALK,      0.725360687685035_REALK, &
      0.000000000000000_REALK,      1.527278309110940_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.968982969049853_REALK,      0.000000000000000_REALK, &
      1.564620787886099_REALK,      0.000000000000000_REALK,      7.623325171720532_REALK, &
     -3.502676016822250_REALK,     -1.653097882465687_REALK,      0.000000000000000_REALK, &
     -1.160155271160578_REALK,      0.000000000000000_REALK,     -3.256605345552082_REALK, &
     -0.936142182571942_REALK,      0.000000000000000_REALK,     -1.803676923985238_REALK, &
      0.000000000000000_REALK,     -0.866229317738632_REALK,      0.000000000000000_REALK, &
     -1.539258183605638_REALK,      0.000000000000000_REALK,     -5.555267222993960_REALK, &
     -0.894247166628019_REALK,      0.000000000000000_REALK,     -1.746271807818181_REALK, &
      0.000000000000000_REALK,     -4.325867830251959_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.763799305772991_REALK, &
      0.000000000000000_REALK,      3.403907509693149_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.403912044098840_REALK,      0.000000000000000_REALK, &
      6.682794486739481_REALK,      0.000000000000000_REALK,      4.247931507862635_REALK, &
      0.000000000000000_REALK,      5.806542031421881_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      7.390886029794241_REALK,      0.000000000000000_REALK, &
      8.163808835586606_REALK,      0.000000000000000_REALK,     19.589474165637384_REALK, &
    ! results of test 2, ket-major order, CM010101
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.464041849517839_REALK, &
      0.000000000000000_REALK,      1.643483429713474_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.271912889150540_REALK,      0.000000000000000_REALK, &
      3.645323225792339_REALK,      0.000000000000000_REALK,     -0.274822754318001_REALK, &
      0.000000000000000_REALK,      2.063220092822974_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -9.908405230922664_REALK,      0.000000000000000_REALK, &
      3.370756778035349_REALK,      0.000000000000000_REALK,     16.101073792450695_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.498369052562852_REALK, &
      0.000000000000000_REALK,      1.564872976256768_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.638342554275428_REALK,      0.000000000000000_REALK, &
      3.167052069923019_REALK,      0.000000000000000_REALK,      1.798695330032644_REALK, &
      0.000000000000000_REALK,      1.730905313678579_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.370424320347937_REALK,      0.000000000000000_REALK, &
      3.483048375661231_REALK,      0.000000000000000_REALK,     11.221702424190186_REALK, &
     -2.632269132605564_REALK,     -1.221896613503160_REALK,      0.000000000000000_REALK, &
     -0.653740063315437_REALK,      0.000000000000000_REALK,     -1.873629756221975_REALK, &
      0.147343564404703_REALK,      0.000000000000000_REALK,     -1.106175518043800_REALK, &
      0.000000000000000_REALK,      2.125571236704676_REALK,      0.000000000000000_REALK, &
     -0.723101597718172_REALK,      0.000000000000000_REALK,     -3.454035087955901_REALK, &
     14.688119253063206_REALK,      0.000000000000000_REALK,      0.313246311844049_REALK, &
      0.000000000000000_REALK,     -3.919472183706051_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.808858311632199_REALK, &
      0.000000000000000_REALK,      1.176956912411891_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.031373380448898_REALK,      0.000000000000000_REALK, &
      2.974666384300693_REALK,      0.000000000000000_REALK,      0.693610548486096_REALK, &
      0.000000000000000_REALK,      1.132283524966230_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.860755040026943_REALK,      0.000000000000000_REALK, &
      1.738019604486705_REALK,      0.000000000000000_REALK,      8.354602046047198_REALK, &
     -3.028881685529443_REALK,     -1.245076378243081_REALK,      0.000000000000000_REALK, &
     -0.998737126216387_REALK,      0.000000000000000_REALK,     -1.930641717532305_REALK, &
     -1.010470730031535_REALK,      0.000000000000000_REALK,     -0.972387667174581_REALK, &
      0.000000000000000_REALK,     -1.481476999127869_REALK,      0.000000000000000_REALK, &
     -0.960828371762157_REALK,      0.000000000000000_REALK,     -3.095601583939300_REALK, &
     -4.444550847490095_REALK,      0.000000000000000_REALK,     -1.702795487886666_REALK, &
      0.000000000000000_REALK,     -2.731032977883888_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.490735789064166_REALK, &
      0.000000000000000_REALK,      0.674326962391932_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.406223881906665_REALK,      0.000000000000000_REALK, &
      1.940407193261570_REALK,      0.000000000000000_REALK,     -0.086411646152483_REALK, &
      0.000000000000000_REALK,      1.081219572703298_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.012243569330173_REALK,      0.000000000000000_REALK, &
      1.140914118249434_REALK,      0.000000000000000_REALK,      7.629716727080456_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.905619850473211_REALK, &
      0.000000000000000_REALK,      0.986900864455770_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.943227728903779_REALK,      0.000000000000000_REALK, &
      3.256920072754481_REALK,      0.000000000000000_REALK,      0.567795704601214_REALK, &
      0.000000000000000_REALK,      0.810450178790833_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.147804587019215_REALK,      0.000000000000000_REALK, &
      1.248958730334754_REALK,      0.000000000000000_REALK,      7.187657575894156_REALK, &
     -3.887880325410844_REALK,     -1.053828615271507_REALK,      0.000000000000000_REALK, &
     -0.740356876423653_REALK,      0.000000000000000_REALK,     -2.135322429714797_REALK, &
     -0.428591642773500_REALK,      0.000000000000000_REALK,     -0.699653800118602_REALK, &
      0.000000000000000_REALK,     -0.301105584935970_REALK,      0.000000000000000_REALK, &
     -0.607986459914043_REALK,      0.000000000000000_REALK,     -2.922570556082420_REALK, &
      0.248196474367419_REALK,      0.000000000000000_REALK,     -0.567512232292615_REALK, &
      0.000000000000000_REALK,     -1.544057522011135_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.728666076316354_REALK, &
      0.000000000000000_REALK,      0.698014811695953_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.593709266930482_REALK,      0.000000000000000_REALK, &
      1.912815442511090_REALK,      0.000000000000000_REALK,      0.595664512624166_REALK, &
      0.000000000000000_REALK,      0.955358079877650_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.212144654807069_REALK,      0.000000000000000_REALK, &
      1.310249811172796_REALK,      0.000000000000000_REALK,      5.909917019558383_REALK, &
     -1.521663939818419_REALK,     -0.603781703071420_REALK,      0.000000000000000_REALK, &
     -0.291602100692389_REALK,      0.000000000000000_REALK,     -1.392894014743582_REALK, &
      0.053394962720924_REALK,      0.000000000000000_REALK,     -0.668100671010855_REALK, &
      0.000000000000000_REALK,      0.703914294777570_REALK,      0.000000000000000_REALK, &
     -0.399109615351713_REALK,      0.000000000000000_REALK,     -2.668994326110945_REALK, &
      3.315217602883170_REALK,      0.000000000000000_REALK,      0.117836698396795_REALK, &
      0.000000000000000_REALK,     -2.064192623414861_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.166530440267366_REALK, &
      0.000000000000000_REALK,      0.745908087211201_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.946039645670854_REALK,      0.000000000000000_REALK, &
      4.075928147068159_REALK,      0.000000000000000_REALK,      0.242212125911742_REALK, &
      0.000000000000000_REALK,      0.517640305510426_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.513726571903162_REALK,      0.000000000000000_REALK, &
      0.980095434777396_REALK,      0.000000000000000_REALK,      7.037757504319325_REALK, &
     -5.645102217239666_REALK,     -1.002706869717027_REALK,      0.000000000000000_REALK, &
     -0.794609957897467_REALK,      0.000000000000000_REALK,     -2.743750043157243_REALK, &
     -0.399537309024836_REALK,      0.000000000000000_REALK,     -0.570284489489416_REALK, &
      0.000000000000000_REALK,     -0.506776701144586_REALK,      0.000000000000000_REALK, &
     -0.551438103996863_REALK,      0.000000000000000_REALK,     -3.173482173239960_REALK, &
     -0.767386427275655_REALK,      0.000000000000000_REALK,     -0.413919960321333_REALK, &
      0.000000000000000_REALK,     -0.984689572702112_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.169521323214767_REALK, &
      0.000000000000000_REALK,      0.589414262980981_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.427818090466537_REALK,      0.000000000000000_REALK, &
      2.056507236581677_REALK,      0.000000000000000_REALK,      0.250567021767475_REALK, &
      0.000000000000000_REALK,      0.681729613413008_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.219504323050072_REALK,      0.000000000000000_REALK, &
      0.738698001541116_REALK,      0.000000000000000_REALK,      4.971255184243250_REALK, &
     -1.989248453350724_REALK,     -0.709194076182853_REALK,      0.000000000000000_REALK, &
     -0.500162666069259_REALK,      0.000000000000000_REALK,     -1.611426542777576_REALK, &
     -0.419147581651045_REALK,      0.000000000000000_REALK,     -0.672250940428539_REALK, &
      0.000000000000000_REALK,     -0.535184016879074_REALK,      0.000000000000000_REALK, &
     -0.578499236273178_REALK,      0.000000000000000_REALK,     -2.609336367079620_REALK, &
     -1.133421333216241_REALK,      0.000000000000000_REALK,     -0.723726948009079_REALK, &
      0.000000000000000_REALK,     -1.625051890540743_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.415202324441487_REALK, &
      0.000000000000000_REALK,      0.562832738897735_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.280839006761341_REALK,      0.000000000000000_REALK, &
      1.878074811442740_REALK,      0.000000000000000_REALK,     -0.052027055792118_REALK, &
      0.000000000000000_REALK,      0.911378766082297_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.855249445656947_REALK,      0.000000000000000_REALK, &
      0.678880357659560_REALK,      0.000000000000000_REALK,      5.837046757887757_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     12.739190594919704_REALK, &
      0.000000000000000_REALK,      0.324904613820531_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.280556736798198_REALK,      0.000000000000000_REALK, &
      5.956967482522077_REALK,      0.000000000000000_REALK,      0.055442133035731_REALK, &
      0.000000000000000_REALK,      0.184745745977675_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.705805895061747_REALK,      0.000000000000000_REALK, &
      1.023745645882845_REALK,      0.000000000000000_REALK,      7.937198131162944_REALK, &
    -10.481987624437631_REALK,     -0.925744498131705_REALK,      0.000000000000000_REALK, &
     -0.969426388538573_REALK,      0.000000000000000_REALK,     -4.176687860425822_REALK, &
     -0.202554702612845_REALK,      0.000000000000000_REALK,     -0.432886990064618_REALK, &
      0.000000000000000_REALK,     -0.288932948262769_REALK,      0.000000000000000_REALK, &
     -0.551230711115511_REALK,      0.000000000000000_REALK,     -3.958214614728391_REALK, &
      0.084320838657912_REALK,      0.000000000000000_REALK,     -0.161933078710336_REALK, &
      0.000000000000000_REALK,     -0.576788410987084_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.405260715429471_REALK, &
      0.000000000000000_REALK,      0.584382309573563_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.461151070550347_REALK,      0.000000000000000_REALK, &
      2.653887518752924_REALK,      0.000000000000000_REALK,      0.232799160139598_REALK, &
      0.000000000000000_REALK,      0.553814571651275_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.338810086927331_REALK,      0.000000000000000_REALK, &
      0.614448110736761_REALK,      0.000000000000000_REALK,      4.950539609684366_REALK, &
     -3.173208549162646_REALK,     -0.731520438550358_REALK,      0.000000000000000_REALK, &
     -0.438394044362004_REALK,      0.000000000000000_REALK,     -2.107345492850984_REALK, &
     -0.209541650268950_REALK,      0.000000000000000_REALK,     -0.570109933957469_REALK, &
      0.000000000000000_REALK,     -0.123454838982391_REALK,      0.000000000000000_REALK, &
     -0.415462627658907_REALK,      0.000000000000000_REALK,     -2.795960916774874_REALK, &
      0.073262879419103_REALK,      0.000000000000000_REALK,     -0.279198031514409_REALK, &
      0.000000000000000_REALK,     -1.063478308702859_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.999937099083020_REALK, &
      0.000000000000000_REALK,      0.688869440465327_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.483781480072426_REALK,      0.000000000000000_REALK, &
      2.182109379789190_REALK,      0.000000000000000_REALK,      0.407042524685479_REALK, &
      0.000000000000000_REALK,      0.913970698604297_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.596336752365100_REALK,      0.000000000000000_REALK, &
      0.902441931923206_REALK,      0.000000000000000_REALK,      5.233485355716824_REALK, &
     -2.069918403963078_REALK,     -0.698530181313674_REALK,      0.000000000000000_REALK, &
     -0.287781537836448_REALK,      0.000000000000000_REALK,     -1.924502096919138_REALK, &
      0.043508659090149_REALK,      0.000000000000000_REALK,     -0.762158600592637_REALK, &
      0.000000000000000_REALK,      0.481014137381123_REALK,      0.000000000000000_REALK, &
     -0.381819656572552_REALK,      0.000000000000000_REALK,     -3.282904216257005_REALK, &
      1.630981987873080_REALK,      0.000000000000000_REALK,      0.081160689240986_REALK, &
      0.000000000000000_REALK,     -1.827931226490827_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     25.787857066889764_REALK, &
      0.000000000000000_REALK,     -0.981302216556161_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.176484364573301_REALK,      0.000000000000000_REALK, &
     10.199747200560907_REALK,      0.000000000000000_REALK,     -0.427732597377162_REALK, &
      0.000000000000000_REALK,     -0.456764822316343_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.823812162069630_REALK,      0.000000000000000_REALK, &
      1.335801794999572_REALK,      0.000000000000000_REALK,     10.433370470304496_REALK, &
    -21.185136473028560_REALK,     -0.479148794982235_REALK,      0.000000000000000_REALK, &
     -1.603866536254477_REALK,      0.000000000000000_REALK,     -7.460958603569372_REALK, &
     -0.056873510724914_REALK,      0.000000000000000_REALK,     -0.189515420672433_REALK, &
      0.000000000000000_REALK,     -0.514696611936151_REALK,      0.000000000000000_REALK, &
     -0.746548617838038_REALK,      0.000000000000000_REALK,     -5.788062999981201_REALK, &
     -0.121201321662305_REALK,      0.000000000000000_REALK,     -0.034905712602793_REALK, &
      0.000000000000000_REALK,     -0.193856235339083_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.159515347619530_REALK, &
      0.000000000000000_REALK,      0.542180551156617_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.565462114170923_REALK,      0.000000000000000_REALK, &
      4.060405850496126_REALK,      0.000000000000000_REALK,      0.118086867162407_REALK, &
      0.000000000000000_REALK,      0.420612866818173_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.181908774091322_REALK,      0.000000000000000_REALK, &
      0.578413916351026_REALK,      0.000000000000000_REALK,      5.814772143957008_REALK, &
     -5.662911818854918_REALK,     -0.861810105275315_REALK,      0.000000000000000_REALK, &
     -0.577580632673042_REALK,      0.000000000000000_REALK,     -3.323930334358950_REALK, &
     -0.238809454218104_REALK,      0.000000000000000_REALK,     -0.568112683545621_REALK, &
      0.000000000000000_REALK,     -0.247071333707171_REALK,      0.000000000000000_REALK, &
     -0.448075544593053_REALK,      0.000000000000000_REALK,     -3.610094478082170_REALK, &
     -0.271728837624439_REALK,      0.000000000000000_REALK,     -0.244279339347909_REALK, &
      0.000000000000000_REALK,     -0.813575275118398_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.107779977752304_REALK, &
      0.000000000000000_REALK,      0.714048990399970_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.426188837192315_REALK,      0.000000000000000_REALK, &
      2.868145658900870_REALK,      0.000000000000000_REALK,      0.203600284278069_REALK, &
      0.000000000000000_REALK,      0.775522967697887_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.129542849243257_REALK,      0.000000000000000_REALK, &
      0.610330856032163_REALK,      0.000000000000000_REALK,      5.280911981508028_REALK, &
     -3.325873811672387_REALK,     -1.015901123772191_REALK,      0.000000000000000_REALK, &
     -0.605924676705756_REALK,      0.000000000000000_REALK,     -2.733039553906486_REALK, &
     -0.417551348146655_REALK,      0.000000000000000_REALK,     -0.937567144031571_REALK, &
      0.000000000000000_REALK,     -0.434868153075531_REALK,      0.000000000000000_REALK, &
     -0.658090004744652_REALK,      0.000000000000000_REALK,     -3.816427717664862_REALK, &
     -0.668900852874912_REALK,      0.000000000000000_REALK,     -0.597961395306875_REALK, &
      0.000000000000000_REALK,     -1.726275494070265_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.838134090607111_REALK, &
      0.000000000000000_REALK,      0.954585329710158_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.391677288445360_REALK,      0.000000000000000_REALK, &
      3.367660620702102_REALK,      0.000000000000000_REALK,     -0.059185013991820_REALK, &
      0.000000000000000_REALK,      1.332986895844519_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.706628588678785_REALK,      0.000000000000000_REALK, &
      0.721167448039699_REALK,      0.000000000000000_REALK,      7.578551742795987_REALK, &
    ! results of test 2, ket-major order, CM000201
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.554315439149990_REALK, &
      0.000000000000000_REALK,      1.121150142639517_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.340142604619735_REALK,      0.000000000000000_REALK, &
      2.312406117607845_REALK,      0.000000000000000_REALK,      1.864070544620624_REALK, &
      0.000000000000000_REALK,      1.240103681749449_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      7.233964254793984_REALK,      0.000000000000000_REALK, &
      2.849087640429108_REALK,      0.000000000000000_REALK,      8.193465962276683_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.798070859512836_REALK, &
      0.000000000000000_REALK,      0.741817883349638_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.623004350632967_REALK,      0.000000000000000_REALK, &
      2.185255172465948_REALK,      0.000000000000000_REALK,      0.258592817688406_REALK, &
      0.000000000000000_REALK,      0.713660932685160_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.200306677193137_REALK,      0.000000000000000_REALK, &
      1.049856235972784_REALK,      0.000000000000000_REALK,      6.137473913502811_REALK, &
     -2.211521750982418_REALK,     -0.892032503752099_REALK,      0.000000000000000_REALK, &
     -0.816953798926378_REALK,      0.000000000000000_REALK,     -1.409647716540112_REALK, &
     -1.047197205998694_REALK,      0.000000000000000_REALK,     -0.696665217110125_REALK, &
      0.000000000000000_REALK,     -1.995550261342504_REALK,      0.000000000000000_REALK, &
     -0.785944937684506_REALK,      0.000000000000000_REALK,     -2.260236927696540_REALK, &
     -7.346556370282542_REALK,      0.000000000000000_REALK,     -1.764685135655982_REALK, &
      0.000000000000000_REALK,     -1.956643164758276_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.713729551060696_REALK, &
      0.000000000000000_REALK,      0.641449140563382_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.668863715011095_REALK,      0.000000000000000_REALK, &
      2.465604895671709_REALK,      0.000000000000000_REALK,      0.394015358299155_REALK, &
      0.000000000000000_REALK,      0.526762706750185_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.967882872970382_REALK,      0.000000000000000_REALK, &
      0.885664353016983_REALK,      0.000000000000000_REALK,      5.441313668022710_REALK, &
     -2.856122164109488_REALK,     -0.664212006871164_REALK,      0.000000000000000_REALK, &
     -0.447214911472910_REALK,      0.000000000000000_REALK,     -1.568654693193028_REALK, &
     -0.159788112773668_REALK,      0.000000000000000_REALK,     -0.440981055133033_REALK, &
      0.000000000000000_REALK,      0.070070410741867_REALK,      0.000000000000000_REALK, &
     -0.367256142957194_REALK,      0.000000000000000_REALK,     -2.146984434382947_REALK, &
      1.177231065477775_REALK,      0.000000000000000_REALK,     -0.211580673825531_REALK, &
      0.000000000000000_REALK,     -0.973195765001410_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.262176283155411_REALK, &
      0.000000000000000_REALK,      0.500091328543082_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.485646351121592_REALK,      0.000000000000000_REALK, &
      1.396631957246259_REALK,      0.000000000000000_REALK,      0.617314480067259_REALK, &
      0.000000000000000_REALK,      0.684464403039761_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.632759458371035_REALK,      0.000000000000000_REALK, &
      1.071767067311633_REALK,      0.000000000000000_REALK,      4.315094279745677_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.532682147201803_REALK, &
      0.000000000000000_REALK,      0.437804321470272_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.676924117844168_REALK,      0.000000000000000_REALK, &
      3.146685147090509_REALK,      0.000000000000000_REALK,      0.092414284304727_REALK, &
      0.000000000000000_REALK,      0.303824514850029_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.257503841737865_REALK,      0.000000000000000_REALK, &
      0.701292213942387_REALK,      0.000000000000000_REALK,      5.433267272779544_REALK, &
     -4.273544131410613_REALK,     -0.651722460666475_REALK,      0.000000000000000_REALK, &
     -0.563475555412056_REALK,      0.000000000000000_REALK,     -2.077116842841826_REALK, &
     -0.277254362253174_REALK,      0.000000000000000_REALK,     -0.370663871959763_REALK, &
      0.000000000000000_REALK,     -0.427337976346721_REALK,      0.000000000000000_REALK, &
     -0.391036997254819_REALK,      0.000000000000000_REALK,     -2.402439423712928_REALK, &
     -0.822790961286946_REALK,      0.000000000000000_REALK,     -0.287235039207856_REALK, &
      0.000000000000000_REALK,     -0.640011882530680_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.593777950479236_REALK, &
      0.000000000000000_REALK,      0.371498766326648_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.258424869879940_REALK,      0.000000000000000_REALK, &
      1.510755323578999_REALK,      0.000000000000000_REALK,      0.093416734102541_REALK, &
      0.000000000000000_REALK,      0.429683715270812_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.051080945838334_REALK,      0.000000000000000_REALK, &
      0.446212862856408_REALK,      0.000000000000000_REALK,      3.651993098234304_REALK, &
     -1.452439111012775_REALK,     -0.508100690430124_REALK,      0.000000000000000_REALK, &
     -0.409126465213527_REALK,      0.000000000000000_REALK,     -1.176574465251877_REALK, &
     -0.434381880999547_REALK,      0.000000000000000_REALK,     -0.481632854031302_REALK, &
      0.000000000000000_REALK,     -0.720893139331950_REALK,      0.000000000000000_REALK, &
     -0.473204746618167_REALK,      0.000000000000000_REALK,     -1.905192982279640_REALK, &
     -1.873472483829529_REALK,      0.000000000000000_REALK,     -0.750031460918633_REALK, &
      0.000000000000000_REALK,     -1.164265206518222_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     10.006202186155214_REALK, &
      0.000000000000000_REALK,      0.066038281674489_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.983934298036853_REALK,      0.000000000000000_REALK, &
      4.678995937955321_REALK,      0.000000000000000_REALK,     -0.013432918257759_REALK, &
      0.000000000000000_REALK,      0.037550379687056_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.581508820556380_REALK,      0.000000000000000_REALK, &
      0.786609780343345_REALK,      0.000000000000000_REALK,      6.234399956592400_REALK, &
     -8.092270908536422_REALK,     -0.543357752527799_REALK,      0.000000000000000_REALK, &
     -0.693658142002059_REALK,      0.000000000000000_REALK,     -3.224473342075183_REALK, &
     -0.077283281355384_REALK,      0.000000000000000_REALK,     -0.254079286989801_REALK, &
      0.000000000000000_REALK,     -0.144826739069934_REALK,      0.000000000000000_REALK, &
     -0.394424657103962_REALK,      0.000000000000000_REALK,     -3.055808318437006_REALK, &
      0.269991374585475_REALK,      0.000000000000000_REALK,     -0.061784394641455_REALK, &
      0.000000000000000_REALK,     -0.338540985456049_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.577904063792595_REALK, &
      0.000000000000000_REALK,      0.379826934737887_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.327012458155918_REALK,      0.000000000000000_REALK, &
      2.009087700228781_REALK,      0.000000000000000_REALK,      0.161548324072950_REALK, &
      0.000000000000000_REALK,      0.359959033183225_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.285700618411172_REALK,      0.000000000000000_REALK, &
      0.435718791374573_REALK,      0.000000000000000_REALK,      3.747735414191917_REALK, &
     -2.331108601612479_REALK,     -0.461066108393369_REALK,      0.000000000000000_REALK, &
     -0.264813308261104_REALK,      0.000000000000000_REALK,     -1.548102221724610_REALK, &
     -0.078121599915680_REALK,      0.000000000000000_REALK,     -0.359331543937546_REALK, &
      0.000000000000000_REALK,      0.028729228909543_REALK,      0.000000000000000_REALK, &
     -0.250961513515355_REALK,      0.000000000000000_REALK,     -2.053974216282169_REALK, &
      0.347496223781341_REALK,      0.000000000000000_REALK,     -0.104090985669049_REALK, &
      0.000000000000000_REALK,     -0.670294060581651_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.460243368484584_REALK, &
      0.000000000000000_REALK,      0.493539145448813_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.395726871086360_REALK,      0.000000000000000_REALK, &
      1.593255484188056_REALK,      0.000000000000000_REALK,      0.421836854749850_REALK, &
      0.000000000000000_REALK,      0.654812495746244_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.803265904722698_REALK,      0.000000000000000_REALK, &
      0.738185599836597_REALK,      0.000000000000000_REALK,      3.821201320906862_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     20.534453222333717_REALK, &
      0.000000000000000_REALK,     -1.105815143830220_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.729812562310834_REALK,      0.000000000000000_REALK, &
      8.121893619399073_REALK,      0.000000000000000_REALK,     -0.445125409135938_REALK, &
      0.000000000000000_REALK,     -0.514721610900819_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.634809369185614_REALK,      0.000000000000000_REALK, &
      1.061660154034982_REALK,      0.000000000000000_REALK,      8.307924048052172_REALK, &
    -16.640206244732070_REALK,     -0.097389085107012_REALK,      0.000000000000000_REALK, &
     -1.232354060656540_REALK,      0.000000000000000_REALK,     -5.860329958452903_REALK, &
      0.013779722726526_REALK,      0.000000000000000_REALK,     -0.038519836898772_REALK, &
      0.000000000000000_REALK,     -0.424055142986828_REALK,      0.000000000000000_REALK, &
     -0.573621432877293_REALK,      0.000000000000000_REALK,     -4.546327195003478_REALK, &
     -0.143781005561479_REALK,      0.000000000000000_REALK,      0.008457206792891_REALK, &
      0.000000000000000_REALK,     -0.039402126436868_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.755249542750661_REALK, &
      0.000000000000000_REALK,      0.318228200475711_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.404607718673372_REALK,      0.000000000000000_REALK, &
      3.134701672821690_REALK,      0.000000000000000_REALK,      0.045055189840403_REALK, &
      0.000000000000000_REALK,      0.246875096162961_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.091181205598940_REALK,      0.000000000000000_REALK, &
      0.413875181517429_REALK,      0.000000000000000_REALK,      4.489101985830268_REALK, &
     -4.287026636339078_REALK,     -0.560144763539685_REALK,      0.000000000000000_REALK, &
     -0.409575244503397_REALK,      0.000000000000000_REALK,     -2.516334058617513_REALK, &
     -0.165719099152147_REALK,      0.000000000000000_REALK,     -0.369252278246259_REALK, &
      0.000000000000000_REALK,     -0.208342182111455_REALK,      0.000000000000000_REALK, &
     -0.317740312522875_REALK,      0.000000000000000_REALK,     -2.732970542770761_REALK, &
     -0.291347388449555_REALK,      0.000000000000000_REALK,     -0.169514863600187_REALK, &
      0.000000000000000_REALK,     -0.528793904032194_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.283043337939182_REALK, &
      0.000000000000000_REALK,      0.450054122695937_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.257440714289575_REALK,      0.000000000000000_REALK, &
      2.107002711153547_REALK,      0.000000000000000_REALK,      0.075906531855004_REALK, &
      0.000000000000000_REALK,      0.488800227365795_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.030145972407244_REALK,      0.000000000000000_REALK, &
      0.368672282842984_REALK,      0.000000000000000_REALK,      3.879473773540747_REALK, &
     -2.428368962272821_REALK,     -0.727840346856339_REALK,      0.000000000000000_REALK, &
     -0.495638395233497_REALK,      0.000000000000000_REALK,     -1.995514202035583_REALK, &
     -0.432727630939412_REALK,      0.000000000000000_REALK,     -0.671718122310168_REALK, &
      0.000000000000000_REALK,     -0.585767620442487_REALK,      0.000000000000000_REALK, &
     -0.538308945666588_REALK,      0.000000000000000_REALK,     -2.786544271105364_REALK, &
     -1.105650039879887_REALK,      0.000000000000000_REALK,     -0.619694845036133_REALK, &
      0.000000000000000_REALK,     -1.236786656666255_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     68.154982486128532_REALK, &
      0.000000000000000_REALK,     -6.277432100459325_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.568971744419261_REALK,      0.000000000000000_REALK, &
     19.123332952333193_REALK,      0.000000000000000_REALK,     -1.517766483874707_REALK, &
      0.000000000000000_REALK,     -2.097487100288359_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.536096320312193_REALK,      0.000000000000000_REALK, &
      1.964162412257800_REALK,      0.000000000000000_REALK,     13.701599208451684_REALK, &
    -63.985920337107970_REALK,      2.712353564212039_REALK,      0.000000000000000_REALK, &
     -3.321091665617860_REALK,      0.000000000000000_REALK,    -15.593338721270191_REALK, &
      0.658146020536124_REALK,      0.000000000000000_REALK,      0.761048398822952_REALK, &
      0.000000000000000_REALK,     -0.663522947889826_REALK,      0.000000000000000_REALK, &
     -1.109680967636262_REALK,      0.000000000000000_REALK,     -8.683706515359470_REALK, &
      0.530820592514501_REALK,      0.000000000000000_REALK,      0.282931422566373_REALK, &
      0.000000000000000_REALK,      0.545280478298305_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     14.374271268533811_REALK, &
      0.000000000000000_REALK,      0.073954781039729_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.848135504273415_REALK,      0.000000000000000_REALK, &
      6.722031791568467_REALK,      0.000000000000000_REALK,     -0.008839741589403_REALK, &
      0.000000000000000_REALK,      0.041184356053312_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.269538701654323_REALK,      0.000000000000000_REALK, &
      0.607677165009804_REALK,      0.000000000000000_REALK,      6.742737784556851_REALK, &
    -14.817488205363235_REALK,     -0.780553059531621_REALK,      0.000000000000000_REALK, &
     -0.776812096066471_REALK,      0.000000000000000_REALK,     -6.018358188993061_REALK, &
     -0.066616942752206_REALK,      0.000000000000000_REALK,     -0.365020416211526_REALK, &
      0.000000000000000_REALK,     -0.095305496843521_REALK,      0.000000000000000_REALK, &
     -0.432595506350482_REALK,      0.000000000000000_REALK,     -4.692152207579092_REALK, &
      0.125145349461779_REALK,      0.000000000000000_REALK,     -0.047730102924958_REALK, &
      0.000000000000000_REALK,     -0.366144795032253_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.172087342735153_REALK, &
      0.000000000000000_REALK,      0.708932684681068_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.469799112696734_REALK,      0.000000000000000_REALK, &
      4.040869494416388_REALK,      0.000000000000000_REALK,      0.177182328218364_REALK, &
      0.000000000000000_REALK,      0.552712211037042_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.220711394869599_REALK,      0.000000000000000_REALK, &
      0.471246243182735_REALK,      0.000000000000000_REALK,      5.211407129054595_REALK, &
     -7.114025757874034_REALK,     -1.103896895058318_REALK,      0.000000000000000_REALK, &
     -0.494264077649924_REALK,      0.000000000000000_REALK,     -4.045264380609161_REALK, &
     -0.112232599729692_REALK,      0.000000000000000_REALK,     -0.722721996711954_REALK, &
      0.000000000000000_REALK,      0.031509529395133_REALK,      0.000000000000000_REALK, &
     -0.385347998614246_REALK,      0.000000000000000_REALK,     -4.054949405966260_REALK, &
      0.268450158383343_REALK,      0.000000000000000_REALK,     -0.112578311784489_REALK, &
      0.000000000000000_REALK,     -0.932076270019014_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.894615604177296_REALK, &
      0.000000000000000_REALK,      1.289641147401906_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.795923762467725_REALK,      0.000000000000000_REALK, &
      4.120081634152798_REALK,      0.000000000000000_REALK,      0.647724766409799_REALK, &
      0.000000000000000_REALK,      1.292728759493224_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.868762255314202_REALK,      0.000000000000000_REALK, &
      1.026482734876675_REALK,      0.000000000000000_REALK,      6.494357248056429_REALK, &
    ! results of test 2, ket-major order, CM010002
     -5.984662657829742_REALK,     -6.126923989504258_REALK,      0.000000000000000_REALK, &
     -7.340037934792821_REALK,      0.000000000000000_REALK,     -4.803489280138773_REALK, &
    -14.150656583738542_REALK,      0.000000000000000_REALK,     -6.447560188891162_REALK, &
      0.000000000000000_REALK,    -25.026693027795840_REALK,      0.000000000000000_REALK, &
     -9.214643406406370_REALK,      0.000000000000000_REALK,    -10.050456872337627_REALK, &
   -120.915750529427200_REALK,      0.000000000000000_REALK,    -37.501327331577777_REALK, &
      0.000000000000000_REALK,    -28.478309316463825_REALK,      0.000000000000000_REALK, &
     -4.454275078160751_REALK,     -2.891664180601849_REALK,      0.000000000000000_REALK, &
     -2.635471288833303_REALK,      0.000000000000000_REALK,     -3.170520151402205_REALK, &
     -3.170277568976558_REALK,      0.000000000000000_REALK,     -2.617805866418892_REALK, &
      0.000000000000000_REALK,     -3.827812904211348_REALK,      0.000000000000000_REALK, &
     -2.915093638335277_REALK,      0.000000000000000_REALK,     -5.844851584817094_REALK, &
     -8.053313355271923_REALK,      0.000000000000000_REALK,     -6.739878731833685_REALK, &
      0.000000000000000_REALK,     -9.275577978724618_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.571296904054316_REALK, &
      0.000000000000000_REALK,      3.313928526135814_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.940342030948329_REALK,      0.000000000000000_REALK, &
      5.388455345121941_REALK,      0.000000000000000_REALK,      8.044860989887669_REALK, &
      0.000000000000000_REALK,      6.109224818958839_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     28.525728548441084_REALK,      0.000000000000000_REALK, &
     17.504937374259551_REALK,      0.000000000000000_REALK,     26.729809773746890_REALK, &
     -4.412002408726964_REALK,     -2.080567953196881_REALK,      0.000000000000000_REALK, &
     -1.731573870887858_REALK,      0.000000000000000_REALK,     -2.812257721665466_REALK, &
     -1.800685921422160_REALK,      0.000000000000000_REALK,     -1.624895190174692_REALK, &
      0.000000000000000_REALK,     -2.407240498762861_REALK,      0.000000000000000_REALK, &
     -1.665849060056478_REALK,      0.000000000000000_REALK,     -4.509189550073771_REALK, &
     -6.035684431791796_REALK,      0.000000000000000_REALK,     -3.034427194148421_REALK, &
      0.000000000000000_REALK,     -4.563655525235355_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.522594362065871_REALK, &
      0.000000000000000_REALK,      1.595820056798738_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.637640765312640_REALK,      0.000000000000000_REALK, &
      3.283519642945264_REALK,      0.000000000000000_REALK,      1.859252588345908_REALK, &
      0.000000000000000_REALK,      2.558746685440157_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.623727950440135_REALK,      0.000000000000000_REALK, &
      4.599452550638787_REALK,      0.000000000000000_REALK,     12.910859550755974_REALK, &
     -3.092022489266455_REALK,     -2.636695878631233_REALK,      0.000000000000000_REALK, &
     -3.011643071614846_REALK,      0.000000000000000_REALK,     -3.284813906645122_REALK, &
     -4.519440519871964_REALK,      0.000000000000000_REALK,     -3.432039189554172_REALK, &
      0.000000000000000_REALK,     -7.869063635765515_REALK,      0.000000000000000_REALK, &
     -4.828885120470177_REALK,      0.000000000000000_REALK,     -7.373644242752082_REALK, &
    -24.556115314524167_REALK,      0.000000000000000_REALK,    -12.693230815255742_REALK, &
      0.000000000000000_REALK,    -13.494841136165213_REALK,      0.000000000000000_REALK, &
     -5.390784685998170_REALK,     -1.704892151321304_REALK,      0.000000000000000_REALK, &
     -1.248595684860073_REALK,      0.000000000000000_REALK,     -2.960755602105248_REALK, &
     -0.907606737138649_REALK,      0.000000000000000_REALK,     -1.131905373585826_REALK, &
      0.000000000000000_REALK,     -0.904226584782958_REALK,      0.000000000000000_REALK, &
     -1.025355871575143_REALK,      0.000000000000000_REALK,     -4.052323445890374_REALK, &
     -1.013429235534717_REALK,      0.000000000000000_REALK,     -1.201791808408119_REALK, &
      0.000000000000000_REALK,     -2.497988299347121_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.518051110754819_REALK, &
      0.000000000000000_REALK,      1.166408160534408_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.029351394410935_REALK,      0.000000000000000_REALK, &
      2.786291184673290_REALK,      0.000000000000000_REALK,      1.061490125240594_REALK, &
      0.000000000000000_REALK,      1.596438129864737_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.969604459015062_REALK,      0.000000000000000_REALK, &
      2.271663161214060_REALK,      0.000000000000000_REALK,      8.608645312968136_REALK, &
     -2.574930382502315_REALK,     -1.428872053805631_REALK,      0.000000000000000_REALK, &
     -1.175557392399639_REALK,      0.000000000000000_REALK,     -2.357028397871391_REALK, &
     -1.148858135028821_REALK,      0.000000000000000_REALK,     -1.581085304639117_REALK, &
      0.000000000000000_REALK,     -1.267636753113806_REALK,      0.000000000000000_REALK, &
     -1.608960489620808_REALK,      0.000000000000000_REALK,     -4.516420742578328_REALK, &
     -1.817692635588020_REALK,      0.000000000000000_REALK,     -2.535401143843184_REALK, &
      0.000000000000000_REALK,     -4.884989290442846_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.941170449112396_REALK, &
      0.000000000000000_REALK,      2.463641065698216_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.983835541521193_REALK,      0.000000000000000_REALK, &
      4.556277735576887_REALK,      0.000000000000000_REALK,      4.440290804727924_REALK, &
      0.000000000000000_REALK,      4.720706641224917_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     10.730781319414158_REALK,      0.000000000000000_REALK, &
      9.218986870604514_REALK,      0.000000000000000_REALK,     18.099349758172117_REALK, &
     -7.546851681264874_REALK,     -1.570532183582000_REALK,      0.000000000000000_REALK, &
     -1.184413074146033_REALK,      0.000000000000000_REALK,     -3.668077889348995_REALK, &
     -0.658489689918042_REALK,      0.000000000000000_REALK,     -0.893232281128700_REALK, &
      0.000000000000000_REALK,     -0.745332910053039_REALK,      0.000000000000000_REALK, &
     -0.821951063493294_REALK,      0.000000000000000_REALK,     -4.242580267446607_REALK, &
     -0.993612745321977_REALK,      0.000000000000000_REALK,     -0.682194178531495_REALK, &
      0.000000000000000_REALK,     -1.542311827585968_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.008174466866277_REALK, &
      0.000000000000000_REALK,      0.953558990779735_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.721505855719135_REALK,      0.000000000000000_REALK, &
      2.851473499621521_REALK,      0.000000000000000_REALK,      0.530613045997051_REALK, &
      0.000000000000000_REALK,      1.102907484564458_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.659176230221266_REALK,      0.000000000000000_REALK, &
      1.245798028640462_REALK,      0.000000000000000_REALK,      6.892950418831527_REALK, &
     -2.897626873202098_REALK,     -1.185089118456506_REALK,      0.000000000000000_REALK, &
     -0.867163722089865_REALK,      0.000000000000000_REALK,     -2.347274844767823_REALK, &
     -0.746932223611888_REALK,      0.000000000000000_REALK,     -1.123355793751166_REALK, &
      0.000000000000000_REALK,     -0.869616362913708_REALK,      0.000000000000000_REALK, &
     -1.002980800017025_REALK,      0.000000000000000_REALK,     -3.800874227519324_REALK, &
     -1.539182187423318_REALK,      0.000000000000000_REALK,     -1.289700817155887_REALK, &
      0.000000000000000_REALK,     -2.715520866689340_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.394778089455896_REALK, &
      0.000000000000000_REALK,      1.331964793710761_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.132167325573329_REALK,      0.000000000000000_REALK, &
      3.178041988149692_REALK,      0.000000000000000_REALK,      1.119425939124209_REALK, &
      0.000000000000000_REALK,      2.156812044257682_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.540167089144758_REALK,      0.000000000000000_REALK, &
      2.736821240679205_REALK,      0.000000000000000_REALK,      9.877337990125049_REALK, &
     -3.384528016772963_REALK,     -2.503098244274859_REALK,      0.000000000000000_REALK, &
     -2.513693524231611_REALK,      0.000000000000000_REALK,     -3.838377041611810_REALK, &
     -3.124472103315249_REALK,      0.000000000000000_REALK,     -3.321790589196794_REALK, &
      0.000000000000000_REALK,     -4.737836056117468_REALK,      0.000000000000000_REALK, &
     -4.070351179126274_REALK,      0.000000000000000_REALK,     -7.991193681433667_REALK, &
    -10.436909492634527_REALK,      0.000000000000000_REALK,     -7.552877940486865_REALK, &
      0.000000000000000_REALK,    -10.324107895445442_REALK,      0.000000000000000_REALK, &
    -13.676763719026130_REALK,     -1.524673964642288_REALK,      0.000000000000000_REALK, &
     -1.380475247649801_REALK,      0.000000000000000_REALK,     -5.449689032449463_REALK, &
     -0.409018373154035_REALK,      0.000000000000000_REALK,     -0.712952142535973_REALK, &
      0.000000000000000_REALK,     -0.500874618058999_REALK,      0.000000000000000_REALK, &
     -0.784959396026470_REALK,      0.000000000000000_REALK,     -5.164627928831453_REALK, &
     -0.156085564649661_REALK,      0.000000000000000_REALK,     -0.326991195758720_REALK, &
      0.000000000000000_REALK,     -0.949953551022120_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.552441491121553_REALK, &
      0.000000000000000_REALK,      0.915313590062735_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.687372907535032_REALK,      0.000000000000000_REALK, &
      3.547942041088827_REALK,      0.000000000000000_REALK,      0.383683434089444_REALK, &
      0.000000000000000_REALK,      0.867435573429817_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.498298969693209_REALK,      0.000000000000000_REALK, &
      0.915871200087397_REALK,      0.000000000000000_REALK,      6.618301447654485_REALK, &
     -4.399848405955450_REALK,     -1.183459469730099_REALK,      0.000000000000000_REALK, &
     -0.739341970730247_REALK,      0.000000000000000_REALK,     -2.921963862086695_REALK, &
     -0.443735702041571_REALK,      0.000000000000000_REALK,     -0.922328296754379_REALK, &
      0.000000000000000_REALK,     -0.370737551917929_REALK,      0.000000000000000_REALK, &
     -0.700668637835003_REALK,      0.000000000000000_REALK,     -3.876771410448867_REALK, &
     -0.299145038510347_REALK,      0.000000000000000_REALK,     -0.591243480060676_REALK, &
      0.000000000000000_REALK,     -1.720503500600836_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.913196425140102_REALK, &
      0.000000000000000_REALK,      1.151125912284402_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.838762621438156_REALK,      0.000000000000000_REALK, &
      3.178556589295347_REALK,      0.000000000000000_REALK,      0.725360687685035_REALK, &
      0.000000000000000_REALK,      1.527278309110940_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.968982969049852_REALK,      0.000000000000000_REALK, &
      1.564620787886100_REALK,      0.000000000000000_REALK,      7.623325171720532_REALK, &
     -3.502676016822249_REALK,     -1.653097882465687_REALK,      0.000000000000000_REALK, &
     -1.160155271160578_REALK,      0.000000000000000_REALK,     -3.256605345552083_REALK, &
     -0.936142182571942_REALK,      0.000000000000000_REALK,     -1.803676923985239_REALK, &
      0.000000000000000_REALK,     -0.866229317738632_REALK,      0.000000000000000_REALK, &
     -1.539258183605639_REALK,      0.000000000000000_REALK,     -5.555267222993960_REALK, &
     -0.894247166628019_REALK,      0.000000000000000_REALK,     -1.746271807818182_REALK, &
      0.000000000000000_REALK,     -4.325867830251959_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.763799305772992_REALK, &
      0.000000000000000_REALK,      3.403907509693150_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.403912044098841_REALK,      0.000000000000000_REALK, &
      6.682794486739482_REALK,      0.000000000000000_REALK,      4.247931507862636_REALK, &
      0.000000000000000_REALK,      5.806542031421881_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      7.390886029794243_REALK,      0.000000000000000_REALK, &
      8.163808835586606_REALK,      0.000000000000000_REALK,     19.589474165637384_REALK, &
    -27.115303448894029_REALK,     -1.107895810568965_REALK,      0.000000000000000_REALK, &
     -2.132904927224217_REALK,      0.000000000000000_REALK,     -9.549438438264595_REALK, &
     -0.199543467193986_REALK,      0.000000000000000_REALK,     -0.438200706753291_REALK, &
      0.000000000000000_REALK,     -0.671826532262888_REALK,      0.000000000000000_REALK, &
     -0.992799082346173_REALK,      0.000000000000000_REALK,     -7.408264035760059_REALK, &
     -0.162998376424909_REALK,      0.000000000000000_REALK,     -0.122468383415390_REALK, &
      0.000000000000000_REALK,     -0.448237610600283_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.036857040043214_REALK, &
      0.000000000000000_REALK,      0.892955423610083_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.805225091173206_REALK,      0.000000000000000_REALK, &
      5.297965749465027_REALK,      0.000000000000000_REALK,      0.238452613909154_REALK, &
      0.000000000000000_REALK,      0.692737022499686_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.315344747950686_REALK,      0.000000000000000_REALK, &
      0.823668618741136_REALK,      0.000000000000000_REALK,      7.587040506274374_REALK, &
     -7.570661068007643_REALK,     -1.349846647458437_REALK,      0.000000000000000_REALK, &
     -0.860918046536439_REALK,      0.000000000000000_REALK,     -4.443712136098447_REALK, &
     -0.393589184052398_REALK,      0.000000000000000_REALK,     -0.889830597910765_REALK, &
      0.000000000000000_REALK,     -0.363375813700071_REALK,      0.000000000000000_REALK, &
     -0.667883063818332_REALK,      0.000000000000000_REALK,     -4.826280647006887_REALK, &
     -0.351834781980295_REALK,      0.000000000000000_REALK,     -0.402604269456571_REALK, &
      0.000000000000000_REALK,     -1.274296797927211_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.309127676081046_REALK, &
      0.000000000000000_REALK,      1.155194024673706_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.718758155694299_REALK,      0.000000000000000_REALK, &
      3.976859985673832_REALK,      0.000000000000000_REALK,      0.431153973274687_REALK, &
      0.000000000000000_REALK,      1.254647104507488_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.389019978421169_REALK,      0.000000000000000_REALK, &
      1.029309644370268_REALK,      0.000000000000000_REALK,      7.322308573119313_REALK, &
     -4.844614214653800_REALK,     -1.697607760191931_REALK,      0.000000000000000_REALK, &
     -1.050530024736998_REALK,      0.000000000000000_REALK,     -3.981065735446097_REALK, &
     -0.744087692728180_REALK,      0.000000000000000_REALK,     -1.566708828413395_REALK, &
      0.000000000000000_REALK,     -0.706613892974299_REALK,      0.000000000000000_REALK, &
     -1.140972360990828_REALK,      0.000000000000000_REALK,     -5.559176630607297_REALK, &
     -0.908365007543849_REALK,      0.000000000000000_REALK,     -1.065583231737388_REALK, &
      0.000000000000000_REALK,     -2.884669193081821_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.802635791179950_REALK, &
      0.000000000000000_REALK,      2.259061998164489_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.578997993408512_REALK,      0.000000000000000_REALK, &
      5.698690376560559_REALK,      0.000000000000000_REALK,      1.273438192132135_REALK, &
      0.000000000000000_REALK,      3.154563501796035_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.272524761119127_REALK,      0.000000000000000_REALK, &
      2.907296355849529_REALK,      0.000000000000000_REALK,     12.824279150769591_REALK, &
     -7.922146832716860_REALK,     -5.019867715394648_REALK,      0.000000000000000_REALK, &
     -4.263318026449967_REALK,      0.000000000000000_REALK,     -8.370039482004191_REALK, &
     -4.357602511711166_REALK,      0.000000000000000_REALK,     -5.956452474256476_REALK, &
      0.000000000000000_REALK,     -5.389674449245748_REALK,      0.000000000000000_REALK, &
     -5.953314895171336_REALK,      0.000000000000000_REALK,    -14.285281623756113_REALK, &
     -8.623236954317504_REALK,      0.000000000000000_REALK,     -8.023342623248663_REALK, &
      0.000000000000000_REALK,    -13.404344547713560_REALK,      0.000000000000000_REALK, &
    ! results of test 2, ket-major order, CM000102
     -2.632269132605565_REALK,     -1.221896613503160_REALK,      0.000000000000000_REALK, &
     -0.653740063315437_REALK,      0.000000000000000_REALK,     -1.873629756221975_REALK, &
      0.147343564404703_REALK,      0.000000000000000_REALK,     -1.106175518043800_REALK, &
      0.000000000000000_REALK,      2.125571236704677_REALK,      0.000000000000000_REALK, &
     -0.723101597718172_REALK,      0.000000000000000_REALK,     -3.454035087955901_REALK, &
     14.688119253063206_REALK,      0.000000000000000_REALK,      0.313246311844049_REALK, &
      0.000000000000000_REALK,     -3.919472183706050_REALK,      0.000000000000000_REALK, &
     -3.028881685529444_REALK,     -1.245076378243081_REALK,      0.000000000000000_REALK, &
     -0.998737126216387_REALK,      0.000000000000000_REALK,     -1.930641717532305_REALK, &
     -1.010470730031535_REALK,      0.000000000000000_REALK,     -0.972387667174581_REALK, &
      0.000000000000000_REALK,     -1.481476999127870_REALK,      0.000000000000000_REALK, &
     -0.960828371762157_REALK,      0.000000000000000_REALK,     -3.095601583939300_REALK, &
     -4.444550847490095_REALK,      0.000000000000000_REALK,     -1.702795487886665_REALK, &
      0.000000000000000_REALK,     -2.731032977883888_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.490735789064166_REALK, &
      0.000000000000000_REALK,      0.674326962391931_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.406223881906665_REALK,      0.000000000000000_REALK, &
      1.940407193261570_REALK,      0.000000000000000_REALK,     -0.086411646152483_REALK, &
      0.000000000000000_REALK,      1.081219572703298_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.012243569330173_REALK,      0.000000000000000_REALK, &
      1.140914118249434_REALK,      0.000000000000000_REALK,      7.629716727080456_REALK, &
     -3.887880325410845_REALK,     -1.053828615271508_REALK,      0.000000000000000_REALK, &
     -0.740356876423653_REALK,      0.000000000000000_REALK,     -2.135322429714797_REALK, &
     -0.428591642773500_REALK,      0.000000000000000_REALK,     -0.699653800118602_REALK, &
      0.000000000000000_REALK,     -0.301105584935970_REALK,      0.000000000000000_REALK, &
     -0.607986459914043_REALK,      0.000000000000000_REALK,     -2.922570556082420_REALK, &
      0.248196474367419_REALK,      0.000000000000000_REALK,     -0.567512232292615_REALK, &
      0.000000000000000_REALK,     -1.544057522011134_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.728666076316354_REALK, &
      0.000000000000000_REALK,      0.698014811695953_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.593709266930482_REALK,      0.000000000000000_REALK, &
      1.912815442511090_REALK,      0.000000000000000_REALK,      0.595664512624166_REALK, &
      0.000000000000000_REALK,      0.955358079877650_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.212144654807069_REALK,      0.000000000000000_REALK, &
      1.310249811172796_REALK,      0.000000000000000_REALK,      5.909917019558383_REALK, &
     -1.521663939818419_REALK,     -0.603781703071420_REALK,      0.000000000000000_REALK, &
     -0.291602100692389_REALK,      0.000000000000000_REALK,     -1.392894014743582_REALK, &
      0.053394962720924_REALK,      0.000000000000000_REALK,     -0.668100671010855_REALK, &
      0.000000000000000_REALK,      0.703914294777570_REALK,      0.000000000000000_REALK, &
     -0.399109615351713_REALK,      0.000000000000000_REALK,     -2.668994326110946_REALK, &
      3.315217602883169_REALK,      0.000000000000000_REALK,      0.117836698396795_REALK, &
      0.000000000000000_REALK,     -2.064192623414862_REALK,      0.000000000000000_REALK, &
     -5.645102217239667_REALK,     -1.002706869717027_REALK,      0.000000000000000_REALK, &
     -0.794609957897467_REALK,      0.000000000000000_REALK,     -2.743750043157243_REALK, &
     -0.399537309024836_REALK,      0.000000000000000_REALK,     -0.570284489489416_REALK, &
      0.000000000000000_REALK,     -0.506776701144586_REALK,      0.000000000000000_REALK, &
     -0.551438103996863_REALK,      0.000000000000000_REALK,     -3.173482173239961_REALK, &
     -0.767386427275656_REALK,      0.000000000000000_REALK,     -0.413919960321333_REALK, &
      0.000000000000000_REALK,     -0.984689572702112_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.169521323214767_REALK, &
      0.000000000000000_REALK,      0.589414262980981_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.427818090466537_REALK,      0.000000000000000_REALK, &
      2.056507236581677_REALK,      0.000000000000000_REALK,      0.250567021767475_REALK, &
      0.000000000000000_REALK,      0.681729613413008_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.219504323050072_REALK,      0.000000000000000_REALK, &
      0.738698001541116_REALK,      0.000000000000000_REALK,      4.971255184243252_REALK, &
     -1.989248453350724_REALK,     -0.709194076182853_REALK,      0.000000000000000_REALK, &
     -0.500162666069259_REALK,      0.000000000000000_REALK,     -1.611426542777576_REALK, &
     -0.419147581651045_REALK,      0.000000000000000_REALK,     -0.672250940428539_REALK, &
      0.000000000000000_REALK,     -0.535184016879074_REALK,      0.000000000000000_REALK, &
     -0.578499236273178_REALK,      0.000000000000000_REALK,     -2.609336367079621_REALK, &
     -1.133421333216241_REALK,      0.000000000000000_REALK,     -0.723726948009079_REALK, &
      0.000000000000000_REALK,     -1.625051890540744_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.415202324441487_REALK, &
      0.000000000000000_REALK,      0.562832738897735_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.280839006761341_REALK,      0.000000000000000_REALK, &
      1.878074811442741_REALK,      0.000000000000000_REALK,     -0.052027055792118_REALK, &
      0.000000000000000_REALK,      0.911378766082297_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.855249445656947_REALK,      0.000000000000000_REALK, &
      0.678880357659560_REALK,      0.000000000000000_REALK,      5.837046757887759_REALK, &
    -10.481987624437631_REALK,     -0.925744498131705_REALK,      0.000000000000000_REALK, &
     -0.969426388538573_REALK,      0.000000000000000_REALK,     -4.176687860425822_REALK, &
     -0.202554702612845_REALK,      0.000000000000000_REALK,     -0.432886990064618_REALK, &
      0.000000000000000_REALK,     -0.288932948262769_REALK,      0.000000000000000_REALK, &
     -0.551230711115511_REALK,      0.000000000000000_REALK,     -3.958214614728391_REALK, &
      0.084320838657912_REALK,      0.000000000000000_REALK,     -0.161933078710336_REALK, &
      0.000000000000000_REALK,     -0.576788410987084_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.405260715429471_REALK, &
      0.000000000000000_REALK,      0.584382309573563_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.461151070550347_REALK,      0.000000000000000_REALK, &
      2.653887518752924_REALK,      0.000000000000000_REALK,      0.232799160139598_REALK, &
      0.000000000000000_REALK,      0.553814571651275_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.338810086927331_REALK,      0.000000000000000_REALK, &
      0.614448110736761_REALK,      0.000000000000000_REALK,      4.950539609684368_REALK, &
     -3.173208549162646_REALK,     -0.731520438550358_REALK,      0.000000000000000_REALK, &
     -0.438394044362004_REALK,      0.000000000000000_REALK,     -2.107345492850984_REALK, &
     -0.209541650268950_REALK,      0.000000000000000_REALK,     -0.570109933957469_REALK, &
      0.000000000000000_REALK,     -0.123454838982391_REALK,      0.000000000000000_REALK, &
     -0.415462627658907_REALK,      0.000000000000000_REALK,     -2.795960916774875_REALK, &
      0.073262879419103_REALK,      0.000000000000000_REALK,     -0.279198031514409_REALK, &
      0.000000000000000_REALK,     -1.063478308702860_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.999937099083020_REALK, &
      0.000000000000000_REALK,      0.688869440465327_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.483781480072426_REALK,      0.000000000000000_REALK, &
      2.182109379789191_REALK,      0.000000000000000_REALK,      0.407042524685479_REALK, &
      0.000000000000000_REALK,      0.913970698604298_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.596336752365100_REALK,      0.000000000000000_REALK, &
      0.902441931923206_REALK,      0.000000000000000_REALK,      5.233485355716824_REALK, &
     -2.069918403963078_REALK,     -0.698530181313674_REALK,      0.000000000000000_REALK, &
     -0.287781537836448_REALK,      0.000000000000000_REALK,     -1.924502096919139_REALK, &
      0.043508659090149_REALK,      0.000000000000000_REALK,     -0.762158600592637_REALK, &
      0.000000000000000_REALK,      0.481014137381123_REALK,      0.000000000000000_REALK, &
     -0.381819656572553_REALK,      0.000000000000000_REALK,     -3.282904216257006_REALK, &
      1.630981987873080_REALK,      0.000000000000000_REALK,      0.081160689240986_REALK, &
      0.000000000000000_REALK,     -1.827931226490827_REALK,      0.000000000000000_REALK, &
    -21.185136473028560_REALK,     -0.479148794982235_REALK,      0.000000000000000_REALK, &
     -1.603866536254478_REALK,      0.000000000000000_REALK,     -7.460958603569372_REALK, &
     -0.056873510724914_REALK,      0.000000000000000_REALK,     -0.189515420672433_REALK, &
      0.000000000000000_REALK,     -0.514696611936151_REALK,      0.000000000000000_REALK, &
     -0.746548617838037_REALK,      0.000000000000000_REALK,     -5.788062999981201_REALK, &
     -0.121201321662305_REALK,      0.000000000000000_REALK,     -0.034905712602793_REALK, &
      0.000000000000000_REALK,     -0.193856235339083_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.159515347619530_REALK, &
      0.000000000000000_REALK,      0.542180551156617_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.565462114170923_REALK,      0.000000000000000_REALK, &
      4.060405850496126_REALK,      0.000000000000000_REALK,      0.118086867162407_REALK, &
      0.000000000000000_REALK,      0.420612866818173_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.181908774091322_REALK,      0.000000000000000_REALK, &
      0.578413916351026_REALK,      0.000000000000000_REALK,      5.814772143957009_REALK, &
     -5.662911818854918_REALK,     -0.861810105275315_REALK,      0.000000000000000_REALK, &
     -0.577580632673042_REALK,      0.000000000000000_REALK,     -3.323930334358950_REALK, &
     -0.238809454218104_REALK,      0.000000000000000_REALK,     -0.568112683545621_REALK, &
      0.000000000000000_REALK,     -0.247071333707171_REALK,      0.000000000000000_REALK, &
     -0.448075544593053_REALK,      0.000000000000000_REALK,     -3.610094478082170_REALK, &
     -0.271728837624439_REALK,      0.000000000000000_REALK,     -0.244279339347909_REALK, &
      0.000000000000000_REALK,     -0.813575275118399_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.107779977752303_REALK, &
      0.000000000000000_REALK,      0.714048990399971_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.426188837192315_REALK,      0.000000000000000_REALK, &
      2.868145658900870_REALK,      0.000000000000000_REALK,      0.203600284278069_REALK, &
      0.000000000000000_REALK,      0.775522967697887_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.129542849243257_REALK,      0.000000000000000_REALK, &
      0.610330856032163_REALK,      0.000000000000000_REALK,      5.280911981508028_REALK, &
     -3.325873811672387_REALK,     -1.015901123772191_REALK,      0.000000000000000_REALK, &
     -0.605924676705756_REALK,      0.000000000000000_REALK,     -2.733039553906488_REALK, &
     -0.417551348146655_REALK,      0.000000000000000_REALK,     -0.937567144031571_REALK, &
      0.000000000000000_REALK,     -0.434868153075531_REALK,      0.000000000000000_REALK, &
     -0.658090004744652_REALK,      0.000000000000000_REALK,     -3.816427717664862_REALK, &
     -0.668900852874912_REALK,      0.000000000000000_REALK,     -0.597961395306875_REALK, &
      0.000000000000000_REALK,     -1.726275494070265_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.838134090607112_REALK, &
      0.000000000000000_REALK,      0.954585329710158_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.391677288445361_REALK,      0.000000000000000_REALK, &
      3.367660620702102_REALK,      0.000000000000000_REALK,     -0.059185013991820_REALK, &
      0.000000000000000_REALK,      1.332986895844519_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.706628588678785_REALK,      0.000000000000000_REALK, &
      0.721167448039699_REALK,      0.000000000000000_REALK,      7.578551742795989_REALK, &
    -80.355671031556582_REALK,      2.406947110008042_REALK,      0.000000000000000_REALK, &
     -4.178663192199147_REALK,      0.000000000000000_REALK,    -19.582639273898959_REALK, &
      0.632429650250292_REALK,      0.000000000000000_REALK,      0.675355627781257_REALK, &
      0.000000000000000_REALK,     -0.861074679765957_REALK,      0.000000000000000_REALK, &
     -1.396222532051946_REALK,      0.000000000000000_REALK,    -10.905290732813556_REALK, &
      0.492434010736218_REALK,      0.000000000000000_REALK,      0.271876171905909_REALK, &
      0.000000000000000_REALK,      0.483882812587963_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     18.300307943636628_REALK, &
      0.000000000000000_REALK,      0.363853343312800_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.103819265048508_REALK,      0.000000000000000_REALK, &
      8.558016576597280_REALK,      0.000000000000000_REALK,      0.036484561269335_REALK, &
      0.000000000000000_REALK,      0.202624704332936_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.327152397091569_REALK,      0.000000000000000_REALK, &
      0.790870984987850_REALK,      0.000000000000000_REALK,      8.584377985874127_REALK, &
    -19.193219029534287_REALK,     -1.329865446843510_REALK,      0.000000000000000_REALK, &
     -1.085638730757612_REALK,      0.000000000000000_REALK,     -7.795630765390138_REALK, &
     -0.174598888550038_REALK,      0.000000000000000_REALK,     -0.621902679112463_REALK, &
      0.000000000000000_REALK,     -0.190136837751691_REALK,      0.000000000000000_REALK, &
     -0.604576626476214_REALK,      0.000000000000000_REALK,     -6.077784830453369_REALK, &
      0.039084066433441_REALK,      0.000000000000000_REALK,     -0.125097648988111_REALK, &
      0.000000000000000_REALK,     -0.623818336894581_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.152966922087314_REALK, &
      0.000000000000000_REALK,      1.090727596482863_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.662507982067170_REALK,      0.000000000000000_REALK, &
      5.337752610261822_REALK,      0.000000000000000_REALK,      0.255328536755277_REALK, &
      0.000000000000000_REALK,      0.850374759858017_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.261739884559862_REALK,      0.000000000000000_REALK, &
      0.664548717079558_REALK,      0.000000000000000_REALK,      6.883964464748393_REALK, &
     -9.683927783645096_REALK,     -1.751425936730276_REALK,      0.000000000000000_REALK, &
     -0.818245991512476_REALK,      0.000000000000000_REALK,     -5.506593518334093_REALK, &
     -0.301035874671249_REALK,      0.000000000000000_REALK,     -1.146659670620722_REALK, &
      0.000000000000000_REALK,     -0.135402307181136_REALK,      0.000000000000000_REALK, &
     -0.637937227205876_REALK,      0.000000000000000_REALK,     -5.519777204946009_REALK, &
      0.056597540455730_REALK,      0.000000000000000_REALK,     -0.301963160781085_REALK, &
      0.000000000000000_REALK,     -1.478817959929013_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.703624576431810_REALK, &
      0.000000000000000_REALK,      1.800048453712682_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.973027620728386_REALK,      0.000000000000000_REALK, &
      5.642829331896922_REALK,      0.000000000000000_REALK,      0.625008273345633_REALK, &
      0.000000000000000_REALK,      1.804358064476760_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.644960602542069_REALK,      0.000000000000000_REALK, &
      1.254889099100516_REALK,      0.000000000000000_REALK,      8.894617346261814_REALK, &
     -8.843703791932686_REALK,     -2.341415684013636_REALK,      0.000000000000000_REALK, &
     -0.751986779729460_REALK,      0.000000000000000_REALK,     -6.465619376183884_REALK, &
      0.087508779850838_REALK,      0.000000000000000_REALK,     -1.970905284040862_REALK, &
      0.000000000000000_REALK,      0.738590680891922_REALK,      0.000000000000000_REALK, &
     -0.753787159221291_REALK,      0.000000000000000_REALK,     -7.921343378354043_REALK, &
      1.763968297211134_REALK,      0.000000000000000_REALK,      0.112857858884005_REALK, &
      0.000000000000000_REALK,     -3.106677040217304_REALK,      0.000000000000000_REALK, &
    ! results of test 2, ket-major order, CM000003
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.571296904054316_REALK, &
      0.000000000000000_REALK,      3.313928526135815_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.940342030948329_REALK,      0.000000000000000_REALK, &
      5.388455345121941_REALK,      0.000000000000000_REALK,      8.044860989887669_REALK, &
      0.000000000000000_REALK,      6.109224818958840_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     28.525728548441084_REALK,      0.000000000000000_REALK, &
     17.504937374259551_REALK,      0.000000000000000_REALK,     26.729809773746890_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.522594362065871_REALK, &
      0.000000000000000_REALK,      1.595820056798738_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.637640765312640_REALK,      0.000000000000000_REALK, &
      3.283519642945265_REALK,      0.000000000000000_REALK,      1.859252588345908_REALK, &
      0.000000000000000_REALK,      2.558746685440158_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.623727950440135_REALK,      0.000000000000000_REALK, &
      4.599452550638787_REALK,      0.000000000000000_REALK,     12.910859550755974_REALK, &
     -3.092022489266455_REALK,     -2.636695878631233_REALK,      0.000000000000000_REALK, &
     -3.011643071614846_REALK,      0.000000000000000_REALK,     -3.284813906645122_REALK, &
     -4.519440519871965_REALK,      0.000000000000000_REALK,     -3.432039189554172_REALK, &
      0.000000000000000_REALK,     -7.869063635765516_REALK,      0.000000000000000_REALK, &
     -4.828885120470178_REALK,      0.000000000000000_REALK,     -7.373644242752083_REALK, &
    -24.556115314524167_REALK,      0.000000000000000_REALK,    -12.693230815255742_REALK, &
      0.000000000000000_REALK,    -13.494841136165213_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.518051110754819_REALK, &
      0.000000000000000_REALK,      1.166408160534409_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.029351394410935_REALK,      0.000000000000000_REALK, &
      2.786291184673290_REALK,      0.000000000000000_REALK,      1.061490125240595_REALK, &
      0.000000000000000_REALK,      1.596438129864738_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.969604459015062_REALK,      0.000000000000000_REALK, &
      2.271663161214060_REALK,      0.000000000000000_REALK,      8.608645312968136_REALK, &
     -2.574930382502315_REALK,     -1.428872053805632_REALK,      0.000000000000000_REALK, &
     -1.175557392399640_REALK,      0.000000000000000_REALK,     -2.357028397871392_REALK, &
     -1.148858135028821_REALK,      0.000000000000000_REALK,     -1.581085304639117_REALK, &
      0.000000000000000_REALK,     -1.267636753113806_REALK,      0.000000000000000_REALK, &
     -1.608960489620808_REALK,      0.000000000000000_REALK,     -4.516420742578329_REALK, &
     -1.817692635588020_REALK,      0.000000000000000_REALK,     -2.535401143843184_REALK, &
      0.000000000000000_REALK,     -4.884989290442846_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.941170449112397_REALK, &
      0.000000000000000_REALK,      2.463641065698216_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.983835541521193_REALK,      0.000000000000000_REALK, &
      4.556277735576887_REALK,      0.000000000000000_REALK,      4.440290804727925_REALK, &
      0.000000000000000_REALK,      4.720706641224917_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     10.730781319414158_REALK,      0.000000000000000_REALK, &
      9.218986870604514_REALK,      0.000000000000000_REALK,     18.099349758172117_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.008174466866277_REALK, &
      0.000000000000000_REALK,      0.953558990779735_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.721505855719135_REALK,      0.000000000000000_REALK, &
      2.851473499621521_REALK,      0.000000000000000_REALK,      0.530613045997051_REALK, &
      0.000000000000000_REALK,      1.102907484564458_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.659176230221266_REALK,      0.000000000000000_REALK, &
      1.245798028640462_REALK,      0.000000000000000_REALK,      6.892950418831528_REALK, &
     -2.897626873202098_REALK,     -1.185089118456506_REALK,      0.000000000000000_REALK, &
     -0.867163722089865_REALK,      0.000000000000000_REALK,     -2.347274844767824_REALK, &
     -0.746932223611888_REALK,      0.000000000000000_REALK,     -1.123355793751166_REALK, &
      0.000000000000000_REALK,     -0.869616362913708_REALK,      0.000000000000000_REALK, &
     -1.002980800017025_REALK,      0.000000000000000_REALK,     -3.800874227519325_REALK, &
     -1.539182187423318_REALK,      0.000000000000000_REALK,     -1.289700817155887_REALK, &
      0.000000000000000_REALK,     -2.715520866689340_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.394778089455896_REALK, &
      0.000000000000000_REALK,      1.331964793710761_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.132167325573329_REALK,      0.000000000000000_REALK, &
      3.178041988149692_REALK,      0.000000000000000_REALK,      1.119425939124209_REALK, &
      0.000000000000000_REALK,      2.156812044257683_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.540167089144758_REALK,      0.000000000000000_REALK, &
      2.736821240679206_REALK,      0.000000000000000_REALK,      9.877337990125049_REALK, &
     -3.384528016772963_REALK,     -2.503098244274859_REALK,      0.000000000000000_REALK, &
     -2.513693524231611_REALK,      0.000000000000000_REALK,     -3.838377041611810_REALK, &
     -3.124472103315249_REALK,      0.000000000000000_REALK,     -3.321790589196794_REALK, &
      0.000000000000000_REALK,     -4.737836056117469_REALK,      0.000000000000000_REALK, &
     -4.070351179126275_REALK,      0.000000000000000_REALK,     -7.991193681433667_REALK, &
    -10.436909492634529_REALK,      0.000000000000000_REALK,     -7.552877940486866_REALK, &
      0.000000000000000_REALK,    -10.324107895445444_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.552441491121554_REALK, &
      0.000000000000000_REALK,      0.915313590062735_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.687372907535032_REALK,      0.000000000000000_REALK, &
      3.547942041088828_REALK,      0.000000000000000_REALK,      0.383683434089444_REALK, &
      0.000000000000000_REALK,      0.867435573429817_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.498298969693209_REALK,      0.000000000000000_REALK, &
      0.915871200087397_REALK,      0.000000000000000_REALK,      6.618301447654485_REALK, &
     -4.399848405955451_REALK,     -1.183459469730099_REALK,      0.000000000000000_REALK, &
     -0.739341970730247_REALK,      0.000000000000000_REALK,     -2.921963862086695_REALK, &
     -0.443735702041571_REALK,      0.000000000000000_REALK,     -0.922328296754379_REALK, &
      0.000000000000000_REALK,     -0.370737551917929_REALK,      0.000000000000000_REALK, &
     -0.700668637835003_REALK,      0.000000000000000_REALK,     -3.876771410448868_REALK, &
     -0.299145038510347_REALK,      0.000000000000000_REALK,     -0.591243480060676_REALK, &
      0.000000000000000_REALK,     -1.720503500600836_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.913196425140103_REALK, &
      0.000000000000000_REALK,      1.151125912284402_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.838762621438156_REALK,      0.000000000000000_REALK, &
      3.178556589295348_REALK,      0.000000000000000_REALK,      0.725360687685035_REALK, &
      0.000000000000000_REALK,      1.527278309110941_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.968982969049852_REALK,      0.000000000000000_REALK, &
      1.564620787886100_REALK,      0.000000000000000_REALK,      7.623325171720531_REALK, &
     -3.502676016822249_REALK,     -1.653097882465687_REALK,      0.000000000000000_REALK, &
     -1.160155271160578_REALK,      0.000000000000000_REALK,     -3.256605345552083_REALK, &
     -0.936142182571943_REALK,      0.000000000000000_REALK,     -1.803676923985239_REALK, &
      0.000000000000000_REALK,     -0.866229317738632_REALK,      0.000000000000000_REALK, &
     -1.539258183605639_REALK,      0.000000000000000_REALK,     -5.555267222993960_REALK, &
     -0.894247166628019_REALK,      0.000000000000000_REALK,     -1.746271807818182_REALK, &
      0.000000000000000_REALK,     -4.325867830251958_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.763799305772993_REALK, &
      0.000000000000000_REALK,      3.403907509693150_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.403912044098842_REALK,      0.000000000000000_REALK, &
      6.682794486739482_REALK,      0.000000000000000_REALK,      4.247931507862637_REALK, &
      0.000000000000000_REALK,      5.806542031421881_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      7.390886029794243_REALK,      0.000000000000000_REALK, &
      8.163808835586606_REALK,      0.000000000000000_REALK,     19.589474165637384_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.036857040043214_REALK, &
      0.000000000000000_REALK,      0.892955423610083_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.805225091173206_REALK,      0.000000000000000_REALK, &
      5.297965749465028_REALK,      0.000000000000000_REALK,      0.238452613909154_REALK, &
      0.000000000000000_REALK,      0.692737022499686_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.315344747950686_REALK,      0.000000000000000_REALK, &
      0.823668618741136_REALK,      0.000000000000000_REALK,      7.587040506274376_REALK, &
     -7.570661068007644_REALK,     -1.349846647458437_REALK,      0.000000000000000_REALK, &
     -0.860918046536439_REALK,      0.000000000000000_REALK,     -4.443712136098448_REALK, &
     -0.393589184052398_REALK,      0.000000000000000_REALK,     -0.889830597910765_REALK, &
      0.000000000000000_REALK,     -0.363375813700071_REALK,      0.000000000000000_REALK, &
     -0.667883063818332_REALK,      0.000000000000000_REALK,     -4.826280647006887_REALK, &
     -0.351834781980295_REALK,      0.000000000000000_REALK,     -0.402604269456571_REALK, &
      0.000000000000000_REALK,     -1.274296797927211_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.309127676081046_REALK, &
      0.000000000000000_REALK,      1.155194024673706_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.718758155694299_REALK,      0.000000000000000_REALK, &
      3.976859985673832_REALK,      0.000000000000000_REALK,      0.431153973274687_REALK, &
      0.000000000000000_REALK,      1.254647104507488_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.389019978421169_REALK,      0.000000000000000_REALK, &
      1.029309644370269_REALK,      0.000000000000000_REALK,      7.322308573119313_REALK, &
     -4.844614214653800_REALK,     -1.697607760191931_REALK,      0.000000000000000_REALK, &
     -1.050530024736998_REALK,      0.000000000000000_REALK,     -3.981065735446098_REALK, &
     -0.744087692728180_REALK,      0.000000000000000_REALK,     -1.566708828413395_REALK, &
      0.000000000000000_REALK,     -0.706613892974299_REALK,      0.000000000000000_REALK, &
     -1.140972360990828_REALK,      0.000000000000000_REALK,     -5.559176630607296_REALK, &
     -0.908365007543849_REALK,      0.000000000000000_REALK,     -1.065583231737389_REALK, &
      0.000000000000000_REALK,     -2.884669193081821_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.802635791179951_REALK, &
      0.000000000000000_REALK,      2.259061998164489_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.578997993408512_REALK,      0.000000000000000_REALK, &
      5.698690376560559_REALK,      0.000000000000000_REALK,      1.273438192132135_REALK, &
      0.000000000000000_REALK,      3.154563501796035_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.272524761119127_REALK,      0.000000000000000_REALK, &
      2.907296355849529_REALK,      0.000000000000000_REALK,     12.824279150769593_REALK, &
     -7.922146832716861_REALK,     -5.019867715394649_REALK,      0.000000000000000_REALK, &
     -4.263318026449968_REALK,      0.000000000000000_REALK,     -8.370039482004193_REALK, &
     -4.357602511711166_REALK,      0.000000000000000_REALK,     -5.956452474256476_REALK, &
      0.000000000000000_REALK,     -5.389674449245748_REALK,      0.000000000000000_REALK, &
     -5.953314895171336_REALK,      0.000000000000000_REALK,    -14.285281623756113_REALK, &
     -8.623236954317505_REALK,      0.000000000000000_REALK,     -8.023342623248663_REALK, &
      0.000000000000000_REALK,    -13.404344547713562_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     23.422950507383504_REALK, &
      0.000000000000000_REALK,      0.841307750200455_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.467916123922063_REALK,      0.000000000000000_REALK, &
     10.953586099883497_REALK,      0.000000000000000_REALK,      0.128007850437571_REALK, &
      0.000000000000000_REALK,      0.468512210401276_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.427027602984854_REALK,      0.000000000000000_REALK, &
      1.051741265590949_REALK,      0.000000000000000_REALK,     10.987326624179492_REALK, &
    -25.043067315063723_REALK,     -2.190249283005965_REALK,      0.000000000000000_REALK, &
     -1.545963069934728_REALK,      0.000000000000000_REALK,    -10.171639562943289_REALK, &
     -0.352567244443283_REALK,      0.000000000000000_REALK,     -1.024255423929250_REALK, &
      0.000000000000000_REALK,     -0.329608362633717_REALK,      0.000000000000000_REALK, &
     -0.860924643712465_REALK,      0.000000000000000_REALK,     -7.930216103995041_REALK, &
     -0.072348172470365_REALK,      0.000000000000000_REALK,     -0.252609473956824_REALK, &
      0.000000000000000_REALK,     -1.027410455961797_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     10.899578033387327_REALK, &
      0.000000000000000_REALK,      1.708398381952651_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.987507276856597_REALK,      0.000000000000000_REALK, &
      7.135960645302191_REALK,      0.000000000000000_REALK,      0.420814790502477_REALK, &
      0.000000000000000_REALK,      1.331935552450869_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.384949326587708_REALK,      0.000000000000000_REALK, &
      0.990549112924112_REALK,      0.000000000000000_REALK,      9.203067862242820_REALK, &
    -13.427360213529626_REALK,     -2.833470537695260_REALK,      0.000000000000000_REALK, &
     -1.379953974482852_REALK,      0.000000000000000_REALK,     -7.635229874910133_REALK, &
     -0.637488370524394_REALK,      0.000000000000000_REALK,     -1.855074956542411_REALK, &
      0.000000000000000_REALK,     -0.406616057354656_REALK,      0.000000000000000_REALK, &
     -1.075867185766587_REALK,      0.000000000000000_REALK,     -7.653509865533303_REALK, &
     -0.231097570194678_REALK,      0.000000000000000_REALK,     -0.639452037186431_REALK, &
      0.000000000000000_REALK,     -2.392443227086209_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      9.764794683041082_REALK, &
      0.000000000000000_REALK,      3.007946494239111_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.686999671363383_REALK,      0.000000000000000_REALK, &
      8.219593628667134_REALK,      0.000000000000000_REALK,      1.113781493255853_REALK, &
      0.000000000000000_REALK,      3.015148010710852_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.047991486509579_REALK,      0.000000000000000_REALK, &
      2.175680785089458_REALK,      0.000000000000000_REALK,     12.956291209358394_REALK, &
    -14.965145057203497_REALK,     -5.541048064574326_REALK,      0.000000000000000_REALK, &
     -3.031540636362906_REALK,      0.000000000000000_REALK,    -10.940996456430604_REALK, &
     -1.882858765976507_REALK,      0.000000000000000_REALK,     -4.664221301735472_REALK, &
      0.000000000000000_REALK,     -1.330083363205179_REALK,      0.000000000000000_REALK, &
     -3.038798641074536_REALK,      0.000000000000000_REALK,    -13.404344547713562_REALK, &
     -0.967161908305182_REALK,      0.000000000000000_REALK,     -2.428275303018682_REALK, &
      0.000000000000000_REALK,     -7.352067776126393_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     20.530109890677309_REALK, &
      0.000000000000000_REALK,     11.435877562639300_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      8.802351936864763_REALK,      0.000000000000000_REALK, &
     21.121690786341201_REALK,      0.000000000000000_REALK,      8.386252956754067_REALK, &
      0.000000000000000_REALK,     14.010647354244140_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     10.277384043666459_REALK,      0.000000000000000_REALK, &
     13.874875106176399_REALK,      0.000000000000000_REALK,     39.346825705001393_REALK, &
    ! results of test 3, ket-major order, 1DOVL001
   -368.081576156876679_REALK,   -252.275650762442581_REALK,      0.000000000000000_REALK, &
   -267.576145315328347_REALK,      0.000000000000000_REALK,    -58.369323476769061_REALK, &
   -212.812013375536452_REALK,      0.000000000000000_REALK,    -32.321663121852929_REALK, &
      0.000000000000000_REALK,   -347.178460395950651_REALK,      0.000000000000000_REALK, &
    -42.609514401027205_REALK,      0.000000000000000_REALK,    -27.884644122487078_REALK, &
   1493.591423951312436_REALK,      0.000000000000000_REALK,    154.409607912918915_REALK, &
      0.000000000000000_REALK,     70.354702968744220_REALK,      0.000000000000000_REALK, &
   -237.316939587498979_REALK,   -106.418651285549601_REALK,      0.000000000000000_REALK, &
    -72.117952837457210_REALK,      0.000000000000000_REALK,    -28.919738658995044_REALK, &
    -34.690097216891402_REALK,      0.000000000000000_REALK,     -9.548263837597904_REALK, &
      0.000000000000000_REALK,    -18.429659043415967_REALK,      0.000000000000000_REALK, &
     -4.678405413096594_REALK,      0.000000000000000_REALK,     -5.628207258982632_REALK, &
    127.919849816262015_REALK,      0.000000000000000_REALK,     35.685695941600102_REALK, &
      0.000000000000000_REALK,     29.466891195056860_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     43.810135632764215_REALK, &
      0.000000000000000_REALK,     30.227830871237565_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     18.019552085425982_REALK,      0.000000000000000_REALK, &
     11.792408437694146_REALK,      0.000000000000000_REALK,     12.911119117323972_REALK, &
      0.000000000000000_REALK,      5.882781277481658_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,   -151.035428973562375_REALK,      0.000000000000000_REALK, &
    -55.610128680575734_REALK,      0.000000000000000_REALK,    -60.654240790337965_REALK, &
   -189.451652162756744_REALK,    -60.864740075256634_REALK,      0.000000000000000_REALK, &
    -31.947986982321318_REALK,      0.000000000000000_REALK,    -17.295628097505062_REALK, &
     -8.909570141355884_REALK,      0.000000000000000_REALK,     -2.679926483751512_REALK, &
      0.000000000000000_REALK,      8.332022125918709_REALK,      0.000000000000000_REALK, &
      1.921964345200057_REALK,      0.000000000000000_REALK,      3.121471836360725_REALK, &
    121.574584081994246_REALK,      0.000000000000000_REALK,     20.373785730774198_REALK, &
      0.000000000000000_REALK,     18.384808836312011_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     24.598579749427053_REALK, &
      0.000000000000000_REALK,      9.814431302044669_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.700947657652063_REALK,      0.000000000000000_REALK, &
      3.249289420359949_REALK,      0.000000000000000_REALK,     -2.145102620162118_REALK, &
      0.000000000000000_REALK,     -1.771284091362302_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -24.330475600553722_REALK,      0.000000000000000_REALK, &
    -18.529018114446949_REALK,      0.000000000000000_REALK,    -37.151246007032697_REALK, &
    -44.257211340685600_REALK,    -25.711218109747914_REALK,      0.000000000000000_REALK, &
    -18.521865235818655_REALK,      0.000000000000000_REALK,    -12.121133691516972_REALK, &
     -7.453876664895813_REALK,      0.000000000000000_REALK,     -3.396260671940497_REALK, &
      0.000000000000000_REALK,      9.078889618930353_REALK,      0.000000000000000_REALK, &
      3.342780057742844_REALK,      0.000000000000000_REALK,      3.645986645635922_REALK, &
    164.874949961916059_REALK,      0.000000000000000_REALK,     51.135021204657370_REALK, &
      0.000000000000000_REALK,     38.831664220694179_REALK,      0.000000000000000_REALK, &
   -193.706713632843247_REALK,    -36.761912833559968_REALK,      0.000000000000000_REALK, &
    -11.922304524514065_REALK,      0.000000000000000_REALK,     -9.423661675534200_REALK, &
      2.367549647182789_REALK,      0.000000000000000_REALK,      0.984215614619604_REALK, &
      0.000000000000000_REALK,     10.760807668304754_REALK,      0.000000000000000_REALK, &
      4.067438225208238_REALK,      0.000000000000000_REALK,      9.644988091442833_REALK, &
     25.764347231784374_REALK,      0.000000000000000_REALK,     10.184358994999654_REALK, &
      0.000000000000000_REALK,     12.701239646270103_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     18.098578918374461_REALK, &
      0.000000000000000_REALK,      3.712510371556063_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.895042765015098_REALK,      0.000000000000000_REALK, &
     -1.453643398906157_REALK,      0.000000000000000_REALK,     -4.210777575645122_REALK, &
      0.000000000000000_REALK,     -3.799703295373921_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -16.691043114473906_REALK,      0.000000000000000_REALK, &
    -11.550469717461985_REALK,      0.000000000000000_REALK,    -31.265292034716101_REALK, &
    -30.841601688859878_REALK,    -10.270067005236037_REALK,      0.000000000000000_REALK, &
     -3.741631068187574_REALK,      0.000000000000000_REALK,     -4.501250592660736_REALK, &
      0.998956398533598_REALK,      0.000000000000000_REALK,      0.824872227582946_REALK, &
      0.000000000000000_REALK,      5.028531389178368_REALK,      0.000000000000000_REALK, &
      3.829507927787099_REALK,      0.000000000000000_REALK,      7.678280102720219_REALK, &
     15.403694894472887_REALK,      0.000000000000000_REALK,     12.891468521208120_REALK, &
      0.000000000000000_REALK,     17.741539022647558_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     12.683858224711301_REALK, &
      0.000000000000000_REALK,      4.704850317922435_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.556704791736422_REALK,      0.000000000000000_REALK, &
     -1.697905570760429_REALK,      0.000000000000000_REALK,    -10.568394281946100_REALK, &
      0.000000000000000_REALK,     -8.025582632809336_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -54.561594690103163_REALK,      0.000000000000000_REALK, &
    -33.481959854875775_REALK,      0.000000000000000_REALK,    -51.126513545205746_REALK, &
   -140.168445601901226_REALK,    -11.454492788479527_REALK,      0.000000000000000_REALK, &
      3.692933594604102_REALK,      0.000000000000000_REALK,      3.812287104020728_REALK, &
      8.730404374702454_REALK,      0.000000000000000_REALK,      3.947558144133365_REALK, &
      0.000000000000000_REALK,     16.329150167377964_REALK,      0.000000000000000_REALK, &
      6.002580486735293_REALK,      0.000000000000000_REALK,     18.589741402767334_REALK, &
     32.178013078482017_REALK,      0.000000000000000_REALK,      7.364255105825086_REALK, &
      0.000000000000000_REALK,      9.989511586443433_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.313256210732290_REALK, &
      0.000000000000000_REALK,     -0.991047832988569_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.188628956831898_REALK,      0.000000000000000_REALK, &
     -7.561095366137721_REALK,      0.000000000000000_REALK,     -3.874984360227746_REALK, &
      0.000000000000000_REALK,     -4.832616859732261_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -7.115777401523780_REALK,      0.000000000000000_REALK, &
     -8.068999808521925_REALK,      0.000000000000000_REALK,    -31.889608296412867_REALK, &
    -17.939306433318006_REALK,     -2.881102958383884_REALK,      0.000000000000000_REALK, &
      0.901255964165071_REALK,      0.000000000000000_REALK,      1.463734286496647_REALK, &
      3.300998457768357_REALK,      0.000000000000000_REALK,      2.978740741509009_REALK, &
      0.000000000000000_REALK,      6.350672738090728_REALK,      0.000000000000000_REALK, &
      4.394767459633417_REALK,      0.000000000000000_REALK,     11.895939421613262_REALK, &
     16.615401654301696_REALK,      0.000000000000000_REALK,      8.353356970742787_REALK, &
      0.000000000000000_REALK,     12.563110351537722_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.493206779515719_REALK, &
      0.000000000000000_REALK,     -0.830598317579516_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.002105795554918_REALK,      0.000000000000000_REALK, &
     -6.019313611811878_REALK,      0.000000000000000_REALK,     -4.904995878933219_REALK, &
      0.000000000000000_REALK,     -6.750369490400300_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -9.975620174132931_REALK,      0.000000000000000_REALK, &
    -12.661654594834204_REALK,      0.000000000000000_REALK,    -35.541804672250557_REALK, &
    -12.572236774835890_REALK,     -3.651210855483261_REALK,      0.000000000000000_REALK, &
      1.567511109900016_REALK,      0.000000000000000_REALK,      1.709692075116795_REALK, &
      8.284990740800923_REALK,      0.000000000000000_REALK,      6.291578079741552_REALK, &
      0.000000000000000_REALK,     20.759806895754675_REALK,      0.000000000000000_REALK, &
     12.739345780241841_REALK,      0.000000000000000_REALK,     19.452813915722633_REALK, &
     67.599577749800176_REALK,      0.000000000000000_REALK,     34.942702964280606_REALK, &
      0.000000000000000_REALK,     37.149424936355366_REALK,      0.000000000000000_REALK, &
   -159.934503395555510_REALK,      5.783899699880886_REALK,      0.000000000000000_REALK, &
     22.396921670558012_REALK,      0.000000000000000_REALK,     29.472038366609656_REALK, &
     10.776715898919161_REALK,      0.000000000000000_REALK,      6.261562800050882_REALK, &
      0.000000000000000_REALK,     17.206359458634335_REALK,      0.000000000000000_REALK, &
      8.988472724507288_REALK,      0.000000000000000_REALK,     35.483708460990002_REALK, &
      6.553990365628093_REALK,      0.000000000000000_REALK,      4.576757095716737_REALK, &
      0.000000000000000_REALK,      7.977658196858384_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.756611049278956_REALK, &
      0.000000000000000_REALK,     -4.950036063192255_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.036910994158355_REALK,      0.000000000000000_REALK, &
    -18.696061552348134_REALK,      0.000000000000000_REALK,     -4.393511434624525_REALK, &
      0.000000000000000_REALK,     -5.959738323925989_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.974479358809809_REALK,      0.000000000000000_REALK, &
     -7.691436469480196_REALK,      0.000000000000000_REALK,    -39.700096566639601_REALK, &
    -17.150440564222365_REALK,      1.496497181371506_REALK,      0.000000000000000_REALK, &
      3.998377668461710_REALK,      0.000000000000000_REALK,      9.481226969447041_REALK, &
      3.897146525256106_REALK,      0.000000000000000_REALK,      4.860256004153977_REALK, &
      0.000000000000000_REALK,      4.245269742911059_REALK,      0.000000000000000_REALK, &
      4.813961821703113_REALK,      0.000000000000000_REALK,     19.025326619275166_REALK, &
      4.187006241785560_REALK,      0.000000000000000_REALK,      4.965230552557087_REALK, &
      0.000000000000000_REALK,     10.320496226611368_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.210260858361950_REALK, &
      0.000000000000000_REALK,     -3.735188578610963_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.419902415712555_REALK,      0.000000000000000_REALK, &
    -11.963975766568646_REALK,      0.000000000000000_REALK,     -4.983609182608159_REALK, &
      0.000000000000000_REALK,     -7.495146242322710_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.137466213310390_REALK,      0.000000000000000_REALK, &
     -9.385428702596126_REALK,      0.000000000000000_REALK,    -35.566816502681014_REALK, &
     -8.191978172828716_REALK,      1.254215992139703_REALK,      0.000000000000000_REALK, &
      3.764487161664786_REALK,      0.000000000000000_REALK,      7.547911485081903_REALK, &
      4.933048980062629_REALK,      0.000000000000000_REALK,      6.788976821099273_REALK, &
      0.000000000000000_REALK,      5.951450713305195_REALK,      0.000000000000000_REALK, &
      7.553937695567864_REALK,      0.000000000000000_REALK,     21.204225409194169_REALK, &
      7.509839013909092_REALK,      0.000000000000000_REALK,     10.475068255851591_REALK, &
      0.000000000000000_REALK,     20.182445831403221_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.581660830345608_REALK, &
      0.000000000000000_REALK,     -7.889317206231479_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -12.812205811996519_REALK,      0.000000000000000_REALK, &
    -19.564070228571573_REALK,      0.000000000000000_REALK,    -20.846801587416589_REALK, &
      0.000000000000000_REALK,    -22.163330968599862_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -44.334470319396857_REALK,      0.000000000000000_REALK, &
    -38.088456713796766_REALK,      0.000000000000000_REALK,    -74.777880637853912_REALK, &
   1631.939744209949822_REALK,     66.678922075088806_REALK,      0.000000000000000_REALK, &
    128.369292562735581_REALK,      0.000000000000000_REALK,    191.578261966378278_REALK, &
     12.009561885415737_REALK,      0.000000000000000_REALK,      8.791064556827514_REALK, &
      0.000000000000000_REALK,     40.434008834936115_REALK,      0.000000000000000_REALK, &
     19.917267796142742_REALK,      0.000000000000000_REALK,     89.173558675782814_REALK, &
      9.810088580821398_REALK,      0.000000000000000_REALK,      2.456927723261620_REALK, &
      0.000000000000000_REALK,      5.395453331119860_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,   -161.233261343850870_REALK, &
      0.000000000000000_REALK,    -17.914231205804722_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -16.154208905158963_REALK,      0.000000000000000_REALK, &
    -63.771817168195319_REALK,      0.000000000000000_REALK,     -4.783772117008109_REALK, &
      0.000000000000000_REALK,     -8.338502140930380_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.326361400534545_REALK,      0.000000000000000_REALK, &
     -9.914530792662015_REALK,      0.000000000000000_REALK,    -65.232498511700086_REALK, &
    151.880563314988393_REALK,     27.080259882614119_REALK,      0.000000000000000_REALK, &
     17.271505975686832_REALK,      0.000000000000000_REALK,     53.489133620763035_REALK, &
      7.896080203772298_REALK,      0.000000000000000_REALK,     10.710925076546836_REALK, &
      0.000000000000000_REALK,      7.289947705231664_REALK,      0.000000000000000_REALK, &
      8.039334085890911_REALK,      0.000000000000000_REALK,     41.495803912284821_REALK, &
      7.058414635254074_REALK,      0.000000000000000_REALK,      4.846163051452691_REALK, &
      0.000000000000000_REALK,     10.956256778319199_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -51.869135307490311_REALK, &
      0.000000000000000_REALK,    -13.905114834447943_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.651719520405454_REALK,      0.000000000000000_REALK, &
    -34.192583113556687_REALK,      0.000000000000000_REALK,     -5.189816932619979_REALK, &
      0.000000000000000_REALK,    -10.787310982432464_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.682648418622781_REALK,      0.000000000000000_REALK, &
     -8.849885510553761_REALK,      0.000000000000000_REALK,    -48.966060817381326_REALK, &
     58.314807334973636_REALK,     20.434169797568266_REALK,      0.000000000000000_REALK, &
     12.645270248112194_REALK,      0.000000000000000_REALK,     34.228743664634948_REALK, &
      8.956612130336497_REALK,      0.000000000000000_REALK,     13.470381663736459_REALK, &
      0.000000000000000_REALK,      8.505538563705132_REALK,      0.000000000000000_REALK, &
      9.809948658989468_REALK,      0.000000000000000_REALK,     37.175568097223696_REALK, &
     10.934024477021602_REALK,      0.000000000000000_REALK,      9.161761627727889_REALK, &
      0.000000000000000_REALK,     19.290485471346052_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -41.292508171176749_REALK, &
      0.000000000000000_REALK,    -19.423154299919059_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -13.576042485843718_REALK,      0.000000000000000_REALK, &
    -38.108530495761059_REALK,      0.000000000000000_REALK,    -10.948874584800778_REALK, &
      0.000000000000000_REALK,    -21.095334447976306_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -10.941021010386971_REALK,      0.000000000000000_REALK, &
    -19.441798819744914_REALK,      0.000000000000000_REALK,    -70.166518450060451_REALK, &
     68.113704025608030_REALK,     43.160243180804045_REALK,      0.000000000000000_REALK, &
     36.655516282707488_REALK,      0.000000000000000_REALK,     55.972492585778092_REALK, &
     37.466163403859824_REALK,      0.000000000000000_REALK,     39.832248422444557_REALK, &
      0.000000000000000_REALK,     46.339798792192802_REALK,      0.000000000000000_REALK, &
     39.811266666927416_REALK,      0.000000000000000_REALK,     78.160219754530303_REALK, &
     74.141595965299175_REALK,      0.000000000000000_REALK,     53.654046251333824_REALK, &
      0.000000000000000_REALK,     73.340277294390361_REALK,      0.000000000000000_REALK, &
    ! results of test 3, ket-major order, 1DOVL002
    268.081400799919891_REALK,    174.035363909044975_REALK,      0.000000000000000_REALK, &
    158.616345528919794_REALK,      0.000000000000000_REALK,     63.606121350670271_REALK, &
    190.803764182147404_REALK,      0.000000000000000_REALK,     52.517716229715788_REALK, &
      0.000000000000000_REALK,    230.377654580037586_REALK,      0.000000000000000_REALK, &
     58.481823440395729_REALK,      0.000000000000000_REALK,     70.354702968744220_REALK, &
    484.690210523204769_REALK,      0.000000000000000_REALK,    135.213631844042283_REALK, &
      0.000000000000000_REALK,    111.650488312102596_REALK,      0.000000000000000_REALK, &
    144.158937528096743_REALK,     21.715090492174152_REALK,      0.000000000000000_REALK, &
    -14.007850403117398_REALK,      0.000000000000000_REALK,     30.629485031450596_REALK, &
    -69.037371553160995_REALK,      0.000000000000000_REALK,      5.653063152095154_REALK, &
      0.000000000000000_REALK,   -164.022232624932315_REALK,      0.000000000000000_REALK, &
     -4.492052927448399_REALK,      0.000000000000000_REALK,     29.466891195056863_REALK, &
   -600.698879868927520_REALK,      0.000000000000000_REALK,    -38.779459012668617_REALK, &
      0.000000000000000_REALK,      9.526263494862029_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -50.607608673017324_REALK, &
      0.000000000000000_REALK,    -32.014912171960987_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -32.853907962456049_REALK,      0.000000000000000_REALK, &
    -39.523852029286438_REALK,      0.000000000000000_REALK,    -37.299824668698484_REALK, &
      0.000000000000000_REALK,    -30.799732108515894_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -72.698254151001990_REALK,      0.000000000000000_REALK, &
    -55.363786971017014_REALK,      0.000000000000000_REALK,   -111.006080135326002_REALK, &
    122.286075202492327_REALK,     -9.572344611272168_REALK,      0.000000000000000_REALK, &
    -17.146748322875830_REALK,      0.000000000000000_REALK,     22.387537455393847_REALK, &
    -35.573058824432330_REALK,      0.000000000000000_REALK,     -2.118411281893910_REALK, &
      0.000000000000000_REALK,    -45.101874832714842_REALK,      0.000000000000000_REALK, &
     -4.693678208371160_REALK,      0.000000000000000_REALK,     18.384808836312008_REALK, &
    -81.714711163707264_REALK,      0.000000000000000_REALK,    -15.701150783286911_REALK, &
      0.000000000000000_REALK,     -2.805057764826317_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -27.425156738343528_REALK, &
      0.000000000000000_REALK,     -4.057971881811810_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.775702226274909_REALK,      0.000000000000000_REALK, &
    -18.208003514771452_REALK,      0.000000000000000_REALK,     13.565661711541690_REALK, &
      0.000000000000000_REALK,     -3.332436068901574_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     44.734336670515503_REALK,      0.000000000000000_REALK, &
      3.675398233197309_REALK,      0.000000000000000_REALK,    -40.183023065153407_REALK, &
     51.657559819178431_REALK,     28.665646300575418_REALK,      0.000000000000000_REALK, &
     23.583715789530544_REALK,      0.000000000000000_REALK,     28.371641335068414_REALK, &
     23.048082479157177_REALK,      0.000000000000000_REALK,     19.031584525616747_REALK, &
      0.000000000000000_REALK,     25.430987124137005_REALK,      0.000000000000000_REALK, &
     19.367119197648464_REALK,      0.000000000000000_REALK,     38.831664220694179_REALK, &
     36.466060089950325_REALK,      0.000000000000000_REALK,     30.518720927844328_REALK, &
      0.000000000000000_REALK,     42.000574051892343_REALK,      0.000000000000000_REALK, &
    112.967069255110957_REALK,    -45.040310344531605_REALK,      0.000000000000000_REALK, &
    -30.838191373128456_REALK,      0.000000000000000_REALK,     18.302201874366201_REALK, &
    -48.331820122646256_REALK,      0.000000000000000_REALK,     -8.538816666172448_REALK, &
      0.000000000000000_REALK,    -57.553152816264060_REALK,      0.000000000000000_REALK, &
     -7.133627264746941_REALK,      0.000000000000000_REALK,     12.701239646270103_REALK, &
   -121.462407871754522_REALK,      0.000000000000000_REALK,    -16.690560652313554_REALK, &
      0.000000000000000_REALK,     -8.846199280562121_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -22.746091741392647_REALK, &
      0.000000000000000_REALK,      1.784628089201305_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.302771658193903_REALK,      0.000000000000000_REALK, &
    -12.936725286703453_REALK,      0.000000000000000_REALK,      6.932345007255728_REALK, &
      0.000000000000000_REALK,      1.238484265227013_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     10.959673282656432_REALK,      0.000000000000000_REALK, &
      3.421665718895505_REALK,      0.000000000000000_REALK,    -22.337374993547041_REALK, &
     31.559276468769632_REALK,      4.122963541282409_REALK,      0.000000000000000_REALK, &
     -2.338354314201049_REALK,      0.000000000000000_REALK,     15.339096236159747_REALK, &
     -9.545665688290645_REALK,      0.000000000000000_REALK,      2.344914779518027_REALK, &
      0.000000000000000_REALK,    -19.751027154063486_REALK,      0.000000000000000_REALK, &
     -1.622755487368680_REALK,      0.000000000000000_REALK,     17.741539022647558_REALK, &
    -51.062146933401657_REALK,      0.000000000000000_REALK,     -9.889293124043032_REALK, &
      0.000000000000000_REALK,      4.048879418645533_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -28.826035822259257_REALK, &
      0.000000000000000_REALK,    -16.032911369344504_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -13.627941573151460_REALK,      0.000000000000000_REALK, &
    -27.324438177264419_REALK,      0.000000000000000_REALK,    -13.474573015194164_REALK, &
      0.000000000000000_REALK,    -18.544020998794444_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -18.539050394451674_REALK,      0.000000000000000_REALK, &
    -23.530873119993736_REALK,      0.000000000000000_REALK,    -66.052164820507798_REALK, &
    132.269150381151718_REALK,    -94.065437100770325_REALK,      0.000000000000000_REALK, &
    -33.008199566534628_REALK,      0.000000000000000_REALK,     17.568136073029471_REALK, &
    -45.059065464197076_REALK,      0.000000000000000_REALK,    -14.661966312102955_REALK, &
      0.000000000000000_REALK,    -28.068422208675038_REALK,      0.000000000000000_REALK, &
     -6.256322823071021_REALK,      0.000000000000000_REALK,      9.989511586443433_REALK, &
    -37.578074839513356_REALK,      0.000000000000000_REALK,    -12.007543477237650_REALK, &
      0.000000000000000_REALK,    -11.721561209092901_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -22.714812963400519_REALK, &
      0.000000000000000_REALK,      8.749902016221135_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.965637532483454_REALK,      0.000000000000000_REALK, &
    -10.621664004972891_REALK,      0.000000000000000_REALK,      9.387197706293769_REALK, &
      0.000000000000000_REALK,      4.975328470131388_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     12.825891340689335_REALK,      0.000000000000000_REALK, &
      4.769250181030952_REALK,      0.000000000000000_REALK,    -14.152545223298370_REALK, &
     33.269132689082063_REALK,     -2.214897067232918_REALK,      0.000000000000000_REALK, &
     -3.384418417792649_REALK,      0.000000000000000_REALK,     13.256529926197084_REALK, &
     -5.797311245540121_REALK,      0.000000000000000_REALK,     -1.035707073250141_REALK, &
      0.000000000000000_REALK,     -6.164000242042247_REALK,      0.000000000000000_REALK, &
     -1.924432213945290_REALK,      0.000000000000000_REALK,     12.563110351537720_REALK, &
     -8.040209604120790_REALK,      0.000000000000000_REALK,     -4.634681131184143_REALK, &
      0.000000000000000_REALK,     -1.379999516591753_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -19.037310615613311_REALK, &
      0.000000000000000_REALK,     -2.402882666219449_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.357061517543908_REALK,      0.000000000000000_REALK, &
    -14.836714500148565_REALK,      0.000000000000000_REALK,      5.561991095728443_REALK, &
      0.000000000000000_REALK,     -2.277193222176212_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     13.204725497163485_REALK,      0.000000000000000_REALK, &
      1.808179442396803_REALK,      0.000000000000000_REALK,    -27.676283298200328_REALK, &
     42.161845717248461_REALK,     19.898402690198154_REALK,      0.000000000000000_REALK, &
     13.964833548922291_REALK,      0.000000000000000_REALK,     27.999916855754069_REALK, &
     11.268379399478285_REALK,      0.000000000000000_REALK,     15.507805996574429_REALK, &
      0.000000000000000_REALK,     10.426835560825714_REALK,      0.000000000000000_REALK, &
     13.234364188268087_REALK,      0.000000000000000_REALK,     37.149424936355366_REALK, &
     10.764087483792657_REALK,      0.000000000000000_REALK,     15.014243433960624_REALK, &
      0.000000000000000_REALK,     28.928131770037503_REALK,      0.000000000000000_REALK, &
    145.996836624073325_REALK,   -198.264262423764819_REALK,      0.000000000000000_REALK, &
    -40.608694137727369_REALK,      0.000000000000000_REALK,     17.139003025243390_REALK, &
    -65.242748222172452_REALK,      0.000000000000000_REALK,    -26.139503699779731_REALK, &
      0.000000000000000_REALK,    -30.888126485271286_REALK,      0.000000000000000_REALK, &
     -6.300683129475772_REALK,      0.000000000000000_REALK,      7.977658196858385_REALK, &
    -59.246813350100140_REALK,      0.000000000000000_REALK,    -13.347424192342570_REALK, &
      0.000000000000000_REALK,    -16.042934436337756_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -25.908377017156603_REALK, &
      0.000000000000000_REALK,     18.363760423821219_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      6.417845484897529_REALK,      0.000000000000000_REALK, &
    -10.247415877417513_REALK,      0.000000000000000_REALK,      8.756291196561296_REALK, &
      0.000000000000000_REALK,      8.547743626304687_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.890515781553314_REALK,      0.000000000000000_REALK, &
      3.938907009073205_REALK,      0.000000000000000_REALK,    -10.482130989138419_REALK, &
     37.774488810997440_REALK,    -12.903802620669488_REALK,      0.000000000000000_REALK, &
     -7.471817632772150_REALK,      0.000000000000000_REALK,     13.303378887771510_REALK, &
     -9.629551754109348_REALK,      0.000000000000000_REALK,     -5.103779050557536_REALK, &
      0.000000000000000_REALK,     -9.353057071783860_REALK,      0.000000000000000_REALK, &
     -3.477892331060445_REALK,      0.000000000000000_REALK,     10.320496226611370_REALK, &
    -14.336470619819607_REALK,      0.000000000000000_REALK,     -5.910068883358306_REALK, &
      0.000000000000000_REALK,     -5.220680139025152_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -19.549892705715333_REALK, &
      0.000000000000000_REALK,      1.297198217317053_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.974116257191086_REALK,      0.000000000000000_REALK, &
    -12.887458548104158_REALK,      0.000000000000000_REALK,      3.379760203640965_REALK, &
      0.000000000000000_REALK,      1.006340525961691_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.880781801695964_REALK,      0.000000000000000_REALK, &
      2.019333014605779_REALK,      0.000000000000000_REALK,    -18.455700669124081_REALK, &
     31.658842095669691_REALK,      3.543619527172108_REALK,      0.000000000000000_REALK, &
     -1.699686935441418_REALK,      0.000000000000000_REALK,     18.582628329493428_REALK, &
     -5.705587842930244_REALK,      0.000000000000000_REALK,      2.335984675421368_REALK, &
      0.000000000000000_REALK,     -9.629315258612799_REALK,      0.000000000000000_REALK, &
     -1.318583252542561_REALK,      0.000000000000000_REALK,     20.182445831403221_REALK, &
    -18.080926818161480_REALK,      0.000000000000000_REALK,     -5.836273247329419_REALK, &
      0.000000000000000_REALK,      3.345285944184851_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -41.292508171176749_REALK, &
      0.000000000000000_REALK,    -19.423154299919059_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -13.576042485843717_REALK,      0.000000000000000_REALK, &
    -38.108530495761059_REALK,      0.000000000000000_REALK,    -10.948874584800777_REALK, &
      0.000000000000000_REALK,    -21.095334447976299_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -10.941021010386971_REALK,      0.000000000000000_REALK, &
    -19.441798819744907_REALK,      0.000000000000000_REALK,    -70.166518450060451_REALK, &
    198.782079067839192_REALK,   -618.235218390498972_REALK,      0.000000000000000_REALK, &
    -43.992043127041207_REALK,      0.000000000000000_REALK,     16.147699755886784_REALK, &
   -115.673363262100239_REALK,      0.000000000000000_REALK,    -57.822712749070078_REALK, &
      0.000000000000000_REALK,    -10.289858387015085_REALK,      0.000000000000000_REALK, &
     -4.899707475797649_REALK,      0.000000000000000_REALK,      5.395453331119860_REALK, &
    -43.570504444004733_REALK,      0.000000000000000_REALK,    -16.575667708777356_REALK, &
      0.000000000000000_REALK,    -24.857496458634589_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -42.038704390991001_REALK, &
      0.000000000000000_REALK,     50.185603788629606_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      9.315957802483425_REALK,      0.000000000000000_REALK, &
    -11.795471315941615_REALK,      0.000000000000000_REALK,     13.951152388000732_REALK, &
      0.000000000000000_REALK,     16.768585447404671_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      6.544389054949806_REALK,      0.000000000000000_REALK, &
      4.004851676346596_REALK,      0.000000000000000_REALK,     -8.451289367217845_REALK, &
     80.731214507358459_REALK,    -45.042800612554110_REALK,      0.000000000000000_REALK, &
    -12.321712545920560_REALK,      0.000000000000000_REALK,     19.674159042496324_REALK, &
    -12.946729365234587_REALK,      0.000000000000000_REALK,    -12.638378615895656_REALK, &
      0.000000000000000_REALK,     -6.156954490104537_REALK,      0.000000000000000_REALK, &
     -4.117070914496795_REALK,      0.000000000000000_REALK,     10.956256778319199_REALK, &
     -5.806014253988650_REALK,      0.000000000000000_REALK,     -5.565689744509520_REALK, &
      0.000000000000000_REALK,     -9.055220597335309_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -32.630650198303186_REALK, &
      0.000000000000000_REALK,      9.798817766312338_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.142283389267276_REALK,      0.000000000000000_REALK, &
    -15.259505258725873_REALK,      0.000000000000000_REALK,      6.177392014154761_REALK, &
      0.000000000000000_REALK,      5.456820967024782_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.945007156075714_REALK,      0.000000000000000_REALK, &
      3.684373753866079_REALK,      0.000000000000000_REALK,    -15.306509381689066_REALK, &
     60.918002720733945_REALK,     -3.181779728610420_REALK,      0.000000000000000_REALK, &
     -3.790133793432318_REALK,      0.000000000000000_REALK,     24.742814399455987_REALK, &
     -4.997188843275743_REALK,      0.000000000000000_REALK,     -1.487938003250785_REALK, &
      0.000000000000000_REALK,     -4.056316598606449_REALK,      0.000000000000000_REALK, &
     -2.110671107991641_REALK,      0.000000000000000_REALK,     19.290485471346052_REALK, &
     -3.726766613187118_REALK,      0.000000000000000_REALK,     -3.580415551524280_REALK, &
      0.000000000000000_REALK,     -1.492521324903787_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -45.579641826344528_REALK, &
      0.000000000000000_REALK,     -4.484890100572001_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.949608588040498_REALK,      0.000000000000000_REALK, &
    -29.841020386610591_REALK,      0.000000000000000_REALK,      6.100258467713711_REALK, &
      0.000000000000000_REALK,     -3.496599292583713_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     10.201004812508831_REALK,      0.000000000000000_REALK, &
      1.955614001731741_REALK,      0.000000000000000_REALK,    -38.485208838328575_REALK, &
    128.668589796520479_REALK,     47.641291663947740_REALK,      0.000000000000000_REALK, &
     26.064836465043374_REALK,      0.000000000000000_REALK,     73.165108044621718_REALK, &
     16.188602334168454_REALK,      0.000000000000000_REALK,     31.190783841715476_REALK, &
      0.000000000000000_REALK,     11.435903227215629_REALK,      0.000000000000000_REALK, &
     20.321186629156664_REALK,      0.000000000000000_REALK,     73.340277294390347_REALK, &
      8.315546449490537_REALK,      0.000000000000000_REALK,     16.238468371226396_REALK, &
      0.000000000000000_REALK,     40.225964609379986_REALK,      0.000000000000000_REALK, &
    ! results of test 3, ket-major order, 1DOVL003
      0.000000000000000_REALK,      0.000000000000000_REALK,    -71.646396619838185_REALK, &
      0.000000000000000_REALK,    -66.483141539920339_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -99.111811226098368_REALK,      0.000000000000000_REALK, &
    -64.861043905918038_REALK,      0.000000000000000_REALK,   -161.393834429899812_REALK, &
      0.000000000000000_REALK,    -73.536973740040580_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,   -572.275483209269282_REALK,      0.000000000000000_REALK, &
   -210.707603363557325_REALK,      0.000000000000000_REALK,   -229.819819050918937_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -50.607608673017317_REALK, &
      0.000000000000000_REALK,    -32.014912171960987_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -32.853907962456063_REALK,      0.000000000000000_REALK, &
    -39.523852029286431_REALK,      0.000000000000000_REALK,    -37.299824668698484_REALK, &
      0.000000000000000_REALK,    -30.799732108515890_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -72.698254151001990_REALK,      0.000000000000000_REALK, &
    -55.363786971017014_REALK,      0.000000000000000_REALK,   -111.006080135325973_REALK, &
    -59.346952150658275_REALK,    -50.607608673017317_REALK,      0.000000000000000_REALK, &
    -57.804184117816604_REALK,      0.000000000000000_REALK,     13.750159185285716_REALK, &
    -86.744200991959303_REALK,      0.000000000000000_REALK,     14.366441000216813_REALK, &
      0.000000000000000_REALK,   -151.035428973562375_REALK,      0.000000000000000_REALK, &
     20.213607522666855_REALK,      0.000000000000000_REALK,     38.587345497901389_REALK, &
   -471.319534588135070_REALK,      0.000000000000000_REALK,     53.133586634013348_REALK, &
      0.000000000000000_REALK,     70.620453091746384_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -50.516463188864023_REALK, &
      0.000000000000000_REALK,    -23.400166364043397_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -20.650570436029948_REALK,      0.000000000000000_REALK, &
    -33.538693983493879_REALK,      0.000000000000000_REALK,    -21.295328997903074_REALK, &
      0.000000000000000_REALK,    -19.216387072406029_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -39.513674176625884_REALK,      0.000000000000000_REALK, &
    -27.344096703399018_REALK,      0.000000000000000_REALK,    -74.016138717269598_REALK, &
    -49.422108258305215_REALK,    -27.425156738343524_REALK,      0.000000000000000_REALK, &
    -22.563143883744878_REALK,      0.000000000000000_REALK,      9.866469333135338_REALK, &
    -22.050689800650556_REALK,      0.000000000000000_REALK,      6.618388512154012_REALK, &
      0.000000000000000_REALK,    -24.330475600553722_REALK,      0.000000000000000_REALK, &
      6.735073426949993_REALK,      0.000000000000000_REALK,     23.635082175148799_REALK, &
    -34.888012051438238_REALK,      0.000000000000000_REALK,     10.613133747355885_REALK, &
      0.000000000000000_REALK,     25.563854628483188_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     10.779631264129824_REALK, &
      0.000000000000000_REALK,      9.029446852836827_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     10.936002332034318_REALK,      0.000000000000000_REALK, &
     -8.512969108415160_REALK,      0.000000000000000_REALK,     16.274030495212610_REALK, &
      0.000000000000000_REALK,     -8.820188789819186_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     39.329194890491927_REALK,      0.000000000000000_REALK, &
    -17.224795105780448_REALK,      0.000000000000000_REALK,    -53.368528725850112_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -60.349185952614846_REALK, &
      0.000000000000000_REALK,    -19.130043647801532_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -14.474656151860151_REALK,      0.000000000000000_REALK, &
    -34.323296011526629_REALK,      0.000000000000000_REALK,    -10.645016017012454_REALK, &
      0.000000000000000_REALK,    -13.275739743349789_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -13.224215992567705_REALK,      0.000000000000000_REALK, &
    -14.995718709389532_REALK,      0.000000000000000_REALK,    -59.264792057693690_REALK, &
    -55.615806156436840_REALK,    -22.746091741392647_REALK,      0.000000000000000_REALK, &
    -16.643968179501520_REALK,      0.000000000000000_REALK,      9.825641173121500_REALK, &
    -14.336296417105237_REALK,      0.000000000000000_REALK,      4.702342788595687_REALK, &
      0.000000000000000_REALK,    -16.691043114473906_REALK,      0.000000000000000_REALK, &
      4.198455697024438_REALK,      0.000000000000000_REALK,     19.890523896039888_REALK, &
    -29.542402083184026_REALK,      0.000000000000000_REALK,      5.398659419156672_REALK, &
      0.000000000000000_REALK,     14.210712971771084_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.777058388962942_REALK, &
      0.000000000000000_REALK,      4.881760367658329_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.149486236902592_REALK,      0.000000000000000_REALK, &
     -5.937867452441230_REALK,      0.000000000000000_REALK,      4.102788009074026_REALK, &
      0.000000000000000_REALK,     -4.029796990217645_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.644838880772461_REALK,      0.000000000000000_REALK, &
     -5.113488691708699_REALK,      0.000000000000000_REALK,    -29.124747756361163_REALK, &
    -38.976706597947029_REALK,    -28.826035822259257_REALK,      0.000000000000000_REALK, &
    -28.948052575009086_REALK,      0.000000000000000_REALK,     -5.743500871593929_REALK, &
    -35.981865666605927_REALK,      0.000000000000000_REALK,     -4.970514083809957_REALK, &
      0.000000000000000_REALK,    -54.561594690103163_REALK,      0.000000000000000_REALK, &
     -6.090612071603113_REALK,      0.000000000000000_REALK,      8.625241879119585_REALK, &
   -120.192935933090965_REALK,      0.000000000000000_REALK,    -11.301641439584259_REALK, &
      0.000000000000000_REALK,     11.143257357312541_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -91.329855070638999_REALK, &
      0.000000000000000_REALK,    -18.362774719378336_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -13.789890138531389_REALK,      0.000000000000000_REALK, &
    -42.706714589560590_REALK,      0.000000000000000_REALK,     -7.697353715964177_REALK, &
      0.000000000000000_REALK,    -10.441355306900729_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -9.996739721462651_REALK,      0.000000000000000_REALK, &
    -11.024376804906083_REALK,      0.000000000000000_REALK,    -56.903391905851869_REALK, &
    -84.448801302326629_REALK,    -22.714812963400515_REALK,      0.000000000000000_REALK, &
    -14.190612362043597_REALK,      0.000000000000000_REALK,     12.231276833085117_REALK, &
     -8.516872554457844_REALK,      0.000000000000000_REALK,      3.860846081968408_REALK, &
      0.000000000000000_REALK,     -7.115777401523779_REALK,      0.000000000000000_REALK, &
      2.932983596689775_REALK,      0.000000000000000_REALK,     20.287704818200382_REALK, &
     -5.741661436231061_REALK,      0.000000000000000_REALK,      2.474932279009892_REALK, &
      0.000000000000000_REALK,      9.003643357664146_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     10.677104168671530_REALK, &
      0.000000000000000_REALK,      4.218971014330597_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.074133897940817_REALK,      0.000000000000000_REALK, &
     -5.938828935456613_REALK,      0.000000000000000_REALK,      2.658506496656801_REALK, &
      0.000000000000000_REALK,     -2.853573425494394_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.551402167368902_REALK,      0.000000000000000_REALK, &
     -2.923344275010952_REALK,      0.000000000000000_REALK,    -22.478467671456915_REALK, &
    -40.337315790789816_REALK,    -19.037310615613311_REALK,      0.000000000000000_REALK, &
    -13.360513308795834_REALK,      0.000000000000000_REALK,     -4.872975071975088_REALK, &
    -10.780746681145290_REALK,      0.000000000000000_REALK,     -2.698906301459367_REALK, &
      0.000000000000000_REALK,     -9.975620174132931_REALK,      0.000000000000000_REALK, &
     -2.303247081593286_REALK,      0.000000000000000_REALK,      5.996040818381408_REALK, &
    -10.298277711684792_REALK,      0.000000000000000_REALK,     -2.613008972675587_REALK, &
      0.000000000000000_REALK,      4.669096740792727_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     23.157189929675553_REALK, &
      0.000000000000000_REALK,     16.546652712571142_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     16.546674754661304_REALK,      0.000000000000000_REALK, &
      5.279118268915298_REALK,      0.000000000000000_REALK,     20.649517417036993_REALK, &
      0.000000000000000_REALK,      4.586916772336586_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     35.927657853495397_REALK,      0.000000000000000_REALK, &
      6.449055474232404_REALK,      0.000000000000000_REALK,    -13.970483217551541_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,   -161.233261343850870_REALK, &
      0.000000000000000_REALK,    -17.914231205804722_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -16.154208905158967_REALK,      0.000000000000000_REALK, &
    -63.771817168195312_REALK,      0.000000000000000_REALK,     -4.783772117008108_REALK, &
      0.000000000000000_REALK,     -8.338502140930379_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.326361400534545_REALK,      0.000000000000000_REALK, &
     -9.914530792662013_REALK,      0.000000000000000_REALK,    -65.232498511700072_REALK, &
   -145.308018202186844_REALK,    -25.908377017156603_REALK,      0.000000000000000_REALK, &
    -16.524091364405759_REALK,      0.000000000000000_REALK,     18.601281832536049_REALK, &
     -7.554381817745369_REALK,      0.000000000000000_REALK,      3.724811425225386_REALK, &
      0.000000000000000_REALK,     -6.974479358809810_REALK,      0.000000000000000_REALK, &
      2.795743900767207_REALK,      0.000000000000000_REALK,     25.256623816499925_REALK, &
     -6.752965750930061_REALK,      0.000000000000000_REALK,      1.685292668331846_REALK, &
      0.000000000000000_REALK,      6.668579224827673_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     15.793306855856832_REALK, &
      0.000000000000000_REALK,      4.233880980365026_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.634307674622794_REALK,      0.000000000000000_REALK, &
     -7.430382468167779_REALK,      0.000000000000000_REALK,      1.580214724164732_REALK, &
      0.000000000000000_REALK,     -2.344188098814930_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.425790172421145_REALK,      0.000000000000000_REALK, &
     -1.923166609686150_REALK,      0.000000000000000_REALK,    -21.590877056100510_REALK, &
    -55.791267169017324_REALK,    -19.549892705715333_REALK,      0.000000000000000_REALK, &
    -12.098053360346791_REALK,      0.000000000000000_REALK,     -5.957011068356593_REALK, &
     -8.569019827545160_REALK,      0.000000000000000_REALK,     -2.344322463367912_REALK, &
      0.000000000000000_REALK,     -8.137466213310390_REALK,      0.000000000000000_REALK, &
     -1.707277757961889_REALK,      0.000000000000000_REALK,      6.000260411550254_REALK, &
    -10.460860778052041_REALK,      0.000000000000000_REALK,     -1.594470307083116_REALK, &
      0.000000000000000_REALK,      3.113548554001714_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     23.345977032373213_REALK, &
      0.000000000000000_REALK,     10.981471803610930_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      7.675629069349364_REALK,      0.000000000000000_REALK, &
      4.501718635143991_REALK,      0.000000000000000_REALK,      6.190279687721118_REALK, &
      0.000000000000000_REALK,      2.491968568811993_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      6.185839430250521_REALK,      0.000000000000000_REALK, &
      2.296638230574161_REALK,      0.000000000000000_REALK,     -9.145798153545963_REALK, &
    -65.166122170911677_REALK,    -41.292508171176756_REALK,      0.000000000000000_REALK, &
    -35.069269635060579_REALK,      0.000000000000000_REALK,    -22.258084089929476_REALK, &
    -35.844836462473900_REALK,      0.000000000000000_REALK,    -15.839736519130879_REALK, &
      0.000000000000000_REALK,    -44.334470319396864_REALK,      0.000000000000000_REALK, &
    -15.831392890732712_REALK,      0.000000000000000_REALK,     -6.805391574572039_REALK, &
    -70.933160510616204_REALK,      0.000000000000000_REALK,    -21.336128123952694_REALK, &
      0.000000000000000_REALK,     -6.385720341415646_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,   -469.904924497791228_REALK, &
      0.000000000000000_REALK,    -16.878089492300809_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -29.448937919381731_REALK,      0.000000000000000_REALK, &
   -131.848736502003874_REALK,      0.000000000000000_REALK,     -2.568059018697501_REALK, &
      0.000000000000000_REALK,     -5.639499467469042_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.566912758314405_REALK,      0.000000000000000_REALK, &
    -12.659850000782846_REALK,      0.000000000000000_REALK,    -94.467766063279214_REALK, &
   -480.665882221765855_REALK,    -42.038704390991001_REALK,      0.000000000000000_REALK, &
    -29.672551430849147_REALK,      0.000000000000000_REALK,     42.578260790628818_REALK, &
     -6.767024320974095_REALK,      0.000000000000000_REALK,      4.287510807515904_REALK, &
      0.000000000000000_REALK,     -6.326361400534544_REALK,      0.000000000000000_REALK, &
      3.603811733028169_REALK,      0.000000000000000_REALK,     41.499966448566660_REALK, &
     -1.388619760914135_REALK,      0.000000000000000_REALK,      1.057417734256099_REALK, &
      0.000000000000000_REALK,      5.376587332827091_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     39.947848711040365_REALK, &
      0.000000000000000_REALK,      6.261420386310239_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.619295276943769_REALK,      0.000000000000000_REALK, &
    -13.332859860140267_REALK,      0.000000000000000_REALK,      1.542320770113038_REALK, &
      0.000000000000000_REALK,     -2.488594170605030_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.410870899115306_REALK,      0.000000000000000_REALK, &
     -1.850746264400700_REALK,      0.000000000000000_REALK,    -27.136565574699208_REALK, &
   -154.631392275101604_REALK,    -32.630650198303186_REALK,      0.000000000000000_REALK, &
    -15.891746475590484_REALK,      0.000000000000000_REALK,    -11.424867584908135_REALK, &
     -7.341406853302884_REALK,      0.000000000000000_REALK,     -2.775815016155714_REALK, &
      0.000000000000000_REALK,     -4.682648418622781_REALK,      0.000000000000000_REALK, &
     -1.609858555368732_REALK,      0.000000000000000_REALK,      8.260765092932846_REALK, &
     -2.661352526655902_REALK,      0.000000000000000_REALK,     -0.956834957354930_REALK, &
      0.000000000000000_REALK,      2.582267723484568_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     47.467407962682088_REALK, &
      0.000000000000000_REALK,     14.621856168664570_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      8.200633421672466_REALK,      0.000000000000000_REALK, &
      6.493123045195934_REALK,      0.000000000000000_REALK,      5.414176358820876_REALK, &
      0.000000000000000_REALK,      2.381836367766757_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.094366143505583_REALK,      0.000000000000000_REALK, &
      1.718693609789213_REALK,      0.000000000000000_REALK,     -9.239944235948949_REALK, &
   -123.100529653865436_REALK,    -45.579641826344528_REALK,      0.000000000000000_REALK, &
    -24.936895471244174_REALK,      0.000000000000000_REALK,    -29.094918808739113_REALK, &
    -15.488049762909812_REALK,      0.000000000000000_REALK,    -12.403362035660281_REALK, &
      0.000000000000000_REALK,    -10.941021010386971_REALK,      0.000000000000000_REALK, &
     -8.080945834344458_REALK,      0.000000000000000_REALK,     -6.385720341415646_REALK, &
     -7.955695899927299_REALK,      0.000000000000000_REALK,     -6.457407519318764_REALK, &
      0.000000000000000_REALK,     -3.502465083791431_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     92.971769271573592_REALK, &
      0.000000000000000_REALK,     51.788021390692606_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     39.861950943233893_REALK,      0.000000000000000_REALK, &
     35.187605239459280_REALK,      0.000000000000000_REALK,     37.977623066812939_REALK, &
      0.000000000000000_REALK,     23.340987861124610_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     46.541717658170157_REALK,      0.000000000000000_REALK, &
     23.114798569944799_REALK,      0.000000000000000_REALK,     12.260336615196316_REALK, &
    ! results of test 4, ket-major order, 001DPG X
   -252.837514082522631_REALK,   -154.856302403022852_REALK,      0.000000000000000_REALK, &
   -203.180975429481578_REALK,      0.000000000000000_REALK,    -44.322097790865705_REALK, &
    -88.212070054173907_REALK,      0.000000000000000_REALK,    -13.397555741089811_REALK, &
      0.000000000000000_REALK,   -310.648358053129073_REALK,      0.000000000000000_REALK, &
    -38.126143168629142_REALK,      0.000000000000000_REALK,    -24.950623093573348_REALK, &
   2509.425473530384352_REALK,      0.000000000000000_REALK,    259.427978254880827_REALK, &
      0.000000000000000_REALK,    118.204939437430511_REALK,      0.000000000000000_REALK, &
   -135.644765982671032_REALK,    -57.944470803576515_REALK,      0.000000000000000_REALK, &
    -44.671328882593400_REALK,      0.000000000000000_REALK,    -17.913475161258727_REALK, &
     -7.608074676417748_REALK,      0.000000000000000_REALK,     -2.094081888914741_REALK, &
      0.000000000000000_REALK,     -5.534955496832779_REALK,      0.000000000000000_REALK, &
     -1.405059404334568_REALK,      0.000000000000000_REALK,     -1.690312155641813_REALK, &
    195.731093252413189_REALK,      0.000000000000000_REALK,     54.602943094095458_REALK, &
      0.000000000000000_REALK,     45.087504688620839_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     23.854419262106727_REALK, &
      0.000000000000000_REALK,     18.723734120682415_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.951966379464793_REALK,      0.000000000000000_REALK, &
      2.586257497286871_REALK,      0.000000000000000_REALK,      3.877579588441991_REALK, &
      0.000000000000000_REALK,      1.766768039048151_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,   -231.100409164836321_REALK,      0.000000000000000_REALK, &
    -85.089462645481774_REALK,      0.000000000000000_REALK,    -92.807495297565040_REALK, &
    -97.740020259147343_REALK,    -28.187011171174515_REALK,      0.000000000000000_REALK, &
    -13.801454311018301_REALK,      0.000000000000000_REALK,     -7.471670158754284_REALK, &
      5.334440563743046_REALK,      0.000000000000000_REALK,      1.604556484315162_REALK, &
      0.000000000000000_REALK,     18.323382990415020_REALK,      0.000000000000000_REALK, &
      4.226691703262821_REALK,      0.000000000000000_REALK,      6.864590982483149_REALK, &
    170.008715449945697_REALK,      0.000000000000000_REALK,     28.490503727368690_REALK, &
      0.000000000000000_REALK,     25.709137791055198_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     11.391824582423537_REALK, &
      0.000000000000000_REALK,      4.239810955186367_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.617142523930259_REALK,      0.000000000000000_REALK, &
     -1.945452026563364_REALK,      0.000000000000000_REALK,     -4.717406683391317_REALK, &
      0.000000000000000_REALK,     -3.895322924059333_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -34.023500342363114_REALK,      0.000000000000000_REALK, &
    -25.910798642431416_REALK,      0.000000000000000_REALK,    -51.951940931673619_REALK, &
    -22.832742199238218_REALK,    -11.907097462141149_REALK,      0.000000000000000_REALK, &
     -8.001401682943079_REALK,      0.000000000000000_REALK,     -5.236300895383080_REALK, &
      4.462870981147787_REALK,      0.000000000000000_REALK,      2.033448348910746_REALK, &
      0.000000000000000_REALK,     19.965858119588358_REALK,      0.000000000000000_REALK, &
      7.351281396650165_REALK,      0.000000000000000_REALK,      8.018078766030555_REALK, &
    230.559525780444943_REALK,      0.000000000000000_REALK,     71.506716104793711_REALK, &
      0.000000000000000_REALK,     54.301821411055769_REALK,      0.000000000000000_REALK, &
    -61.072093193830220_REALK,     -8.447648959588838_REALK,      0.000000000000000_REALK, &
      1.156324454522646_REALK,      0.000000000000000_REALK,      0.913985247077237_REALK, &
      8.698088649348719_REALK,      0.000000000000000_REALK,      3.615888129831309_REALK, &
      0.000000000000000_REALK,     14.320113260081889_REALK,      0.000000000000000_REALK, &
      5.412807092066954_REALK,      0.000000000000000_REALK,     12.835218890531596_REALK, &
     32.879463924754283_REALK,      0.000000000000000_REALK,     12.996885236810504_REALK, &
      0.000000000000000_REALK,     16.208831024991355_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.158935963480897_REALK, &
      0.000000000000000_REALK,     -0.360070196283986_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.288277956208134_REALK,      0.000000000000000_REALK, &
     -5.340508556292231_REALK,      0.000000000000000_REALK,     -5.603558176572316_REALK, &
      0.000000000000000_REALK,     -5.056514642922987_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -21.300463971073999_REALK,      0.000000000000000_REALK, &
    -14.740262928949663_REALK,      0.000000000000000_REALK,    -39.899557023675456_REALK, &
     -9.723778475531793_REALK,     -2.359994738154335_REALK,      0.000000000000000_REALK, &
      0.362894564138247_REALK,      0.000000000000000_REALK,      0.436568796370373_REALK, &
      3.670043972095220_REALK,      0.000000000000000_REALK,      3.030479959919623_REALK, &
      0.000000000000000_REALK,      6.691796865490804_REALK,      0.000000000000000_REALK, &
      5.096177624084609_REALK,      0.000000000000000_REALK,     10.217991446631697_REALK, &
     19.657599939731387_REALK,      0.000000000000000_REALK,     16.451593761213722_REALK, &
      0.000000000000000_REALK,     22.641066238430778_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.914668293259718_REALK, &
      0.000000000000000_REALK,     -0.456315594547699_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.719143543832909_REALK,      0.000000000000000_REALK, &
     -6.237897984640245_REALK,      0.000000000000000_REALK,    -14.064056134042215_REALK, &
      0.000000000000000_REALK,    -10.680169725408856_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -69.629397871069870_REALK,      0.000000000000000_REALK, &
    -42.728382802587149_REALK,      0.000000000000000_REALK,    -65.245680109227081_REALK, &
    -18.733205691375634_REALK,      6.030971088010679_REALK,      0.000000000000000_REALK, &
     11.686240691681750_REALK,      0.000000000000000_REALK,     12.063933331613750_REALK, &
     11.316171158984002_REALK,      0.000000000000000_REALK,      5.116743933247291_REALK, &
      0.000000000000000_REALK,     17.787912833477193_REALK,      0.000000000000000_REALK, &
      6.538820292515169_REALK,      0.000000000000000_REALK,     20.250453714971549_REALK, &
     37.050284061392574_REALK,      0.000000000000000_REALK,      8.479322290842065_REALK, &
      0.000000000000000_REALK,     11.502085010954366_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.850544723420759_REALK, &
      0.000000000000000_REALK,     -3.136158075031845_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.133035480298945_REALK,      0.000000000000000_REALK, &
     -9.800536795356786_REALK,      0.000000000000000_REALK,     -4.221155621957671_REALK, &
      0.000000000000000_REALK,     -5.264338105619432_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.193221048206844_REALK,      0.000000000000000_REALK, &
     -9.290776725955723_REALK,      0.000000000000000_REALK,    -36.718210136434429_REALK, &
     -2.397549005647289_REALK,      1.516946141960225_REALK,      0.000000000000000_REALK, &
      2.852012865174693_REALK,      0.000000000000000_REALK,      4.631968255714237_REALK, &
      4.278686523603559_REALK,      0.000000000000000_REALK,      3.860982678743753_REALK, &
      0.000000000000000_REALK,      6.918009323276196_REALK,      0.000000000000000_REALK, &
      4.787373482028177_REALK,      0.000000000000000_REALK,     12.958661738975229_REALK, &
     19.131241869550845_REALK,      0.000000000000000_REALK,      9.618190156035398_REALK, &
      0.000000000000000_REALK,     14.465368202934807_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.839228456531133_REALK, &
      0.000000000000000_REALK,     -2.628417654604680_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.891267982765703_REALK,      0.000000000000000_REALK, &
     -7.802110895142457_REALK,      0.000000000000000_REALK,     -5.343183095794812_REALK, &
      0.000000000000000_REALK,     -7.353412936877002_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -11.486090214418523_REALK,      0.000000000000000_REALK, &
    -14.578833636547646_REALK,      0.000000000000000_REALK,    -40.923408041063979_REALK, &
     -1.680251903289161_REALK,      1.922420094218180_REALK,      0.000000000000000_REALK, &
      4.960368673821386_REALK,      0.000000000000000_REALK,      5.410298502975823_REALK, &
     10.738835138629669_REALK,      0.000000000000000_REALK,      8.155014516483240_REALK, &
      0.000000000000000_REALK,     22.614381747755008_REALK,      0.000000000000000_REALK, &
     13.877413703205256_REALK,      0.000000000000000_REALK,     21.190628707059588_REALK, &
     77.835245823028984_REALK,      0.000000000000000_REALK,     40.233592656633192_REALK, &
      0.000000000000000_REALK,     42.774447982612294_REALK,      0.000000000000000_REALK, &
    151.181657308085363_REALK,     23.779756569227480_REALK,      0.000000000000000_REALK, &
     28.316164972719868_REALK,      0.000000000000000_REALK,     37.261151900544029_REALK, &
     10.773873337527856_REALK,      0.000000000000000_REALK,      6.259911195162009_REALK, &
      0.000000000000000_REALK,     16.260869654754970_REALK,      0.000000000000000_REALK, &
      8.494555964608100_REALK,      0.000000000000000_REALK,     33.533877955917148_REALK, &
      6.715451634758502_REALK,      0.000000000000000_REALK,      4.689508102042821_REALK, &
      0.000000000000000_REALK,      8.174192330309147_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -23.667562806871953_REALK, &
      0.000000000000000_REALK,     -6.258272446901516_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.035318645406129_REALK,      0.000000000000000_REALK, &
    -18.691130114678568_REALK,      0.000000000000000_REALK,     -4.152087891506556_REALK, &
      0.000000000000000_REALK,     -5.632250581233651_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -7.146299612727646_REALK,      0.000000000000000_REALK, &
     -7.880919368373529_REALK,      0.000000000000000_REALK,    -40.678130957697967_REALK, &
     16.211836551930702_REALK,      6.152654874060548_REALK,      0.000000000000000_REALK, &
      5.055101917520792_REALK,      0.000000000000000_REALK,     11.987003882037257_REALK, &
      3.896118579604309_REALK,      0.000000000000000_REALK,      4.858974020273280_REALK, &
      0.000000000000000_REALK,      4.011992083782197_REALK,      0.000000000000000_REALK, &
      4.549434521222894_REALK,      0.000000000000000_REALK,     17.979884532746357_REALK, &
      4.290155514814870_REALK,      0.000000000000000_REALK,      5.087551822778259_REALK, &
      0.000000000000000_REALK,     10.574747503443172_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -9.087202042494159_REALK, &
      0.000000000000000_REALK,     -4.722355042889782_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.418736583368259_REALK,      0.000000000000000_REALK, &
    -11.960820043069992_REALK,      0.000000000000000_REALK,     -4.709759756179312_REALK, &
      0.000000000000000_REALK,     -7.083287803137032_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.337937307866387_REALK,      0.000000000000000_REALK, &
     -9.616644060739077_REALK,      0.000000000000000_REALK,    -36.443025195566534_REALK, &
      7.743650122430823_REALK,      5.156547057503173_REALK,      0.000000000000000_REALK, &
      4.759396897275940_REALK,      0.000000000000000_REALK,      9.542735825701586_REALK, &
      4.931747795666226_REALK,      0.000000000000000_REALK,      6.787186100848399_REALK, &
      0.000000000000000_REALK,      5.624418374985834_REALK,      0.000000000000000_REALK, &
      7.138848664824909_REALK,      0.000000000000000_REALK,     20.039052789631562_REALK, &
      7.694848156508682_REALK,      0.000000000000000_REALK,     10.733127502274572_REALK, &
      0.000000000000000_REALK,     20.679651829017136_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -10.614165057390696_REALK, &
      0.000000000000000_REALK,     -9.974371068477383_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -12.808826351878963_REALK,      0.000000000000000_REALK, &
    -19.558909837297449_REALK,      0.000000000000000_REALK,    -19.701269414164937_REALK, &
      0.000000000000000_REALK,    -20.945455478947725_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -45.426675135799314_REALK,      0.000000000000000_REALK, &
    -39.026787443191871_REALK,      0.000000000000000_REALK,    -76.620076130540312_REALK, &
    846.489112179212725_REALK,     36.365574520182427_REALK,      0.000000000000000_REALK, &
     75.336149287504924_REALK,      0.000000000000000_REALK,    112.431627966527415_REALK, &
      7.743517562742622_REALK,      0.000000000000000_REALK,      5.668296932102576_REALK, &
      0.000000000000000_REALK,     28.987967826354659_REALK,      0.000000000000000_REALK, &
     14.279096599608481_REALK,      0.000000000000000_REALK,     63.930347851674398_REALK, &
      8.239309624543512_REALK,      0.000000000000000_REALK,      2.063527568614703_REALK, &
      0.000000000000000_REALK,      4.531540178625892_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -87.933937713165236_REALK, &
      0.000000000000000_REALK,    -10.513333598312258_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -10.415900393603863_REALK,      0.000000000000000_REALK, &
    -41.118751121938814_REALK,      0.000000000000000_REALK,     -3.429584060846997_REALK, &
      0.000000000000000_REALK,     -5.978042710729928_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.313392427227241_REALK,      0.000000000000000_REALK, &
     -8.327028681730146_REALK,      0.000000000000000_REALK,    -54.787553485624947_REALK, &
     78.780631242009420_REALK,     14.769123107270909_REALK,      0.000000000000000_REALK, &
     10.136137129278641_REALK,      0.000000000000000_REALK,     31.391193916128795_REALK, &
      5.091229498470462_REALK,      0.000000000000000_REALK,      6.906183359126730_REALK, &
      0.000000000000000_REALK,      5.226312592395646_REALK,      0.000000000000000_REALK, &
      5.763563013958823_REALK,      0.000000000000000_REALK,     29.749190431464541_REALK, &
      5.928230225358297_REALK,      0.000000000000000_REALK,      4.070201562705773_REALK, &
      0.000000000000000_REALK,      9.201954822207835_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -28.288563261382809_REALK, &
      0.000000000000000_REALK,     -8.160501519597577_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.578450129437311_REALK,      0.000000000000000_REALK, &
    -22.046671675583564_REALK,      0.000000000000000_REALK,     -3.720685892947431_REALK, &
      0.000000000000000_REALK,     -7.733643848379711_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.932868685746535_REALK,      0.000000000000000_REALK, &
     -7.432853053515288_REALK,      0.000000000000000_REALK,    -41.125677188824362_REALK, &
     30.247960847219321_REALK,     11.144456170042851_REALK,      0.000000000000000_REALK, &
      7.421135913225162_REALK,      0.000000000000000_REALK,     20.087839475959207_REALK, &
      5.775038589722326_REALK,      0.000000000000000_REALK,      8.685423996745458_REALK, &
      0.000000000000000_REALK,      6.097794538182668_REALK,      0.000000000000000_REALK, &
      7.032952811230374_REALK,      0.000000000000000_REALK,     26.651925024996842_REALK, &
      9.183282328830439_REALK,      0.000000000000000_REALK,      7.694791961887804_REALK, &
      0.000000000000000_REALK,     16.201717374591766_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -22.520246823023797_REALK, &
      0.000000000000000_REALK,    -11.398876029933954_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.753551913441152_REALK,      0.000000000000000_REALK, &
    -24.571593701731715_REALK,      0.000000000000000_REALK,     -7.849472098961583_REALK, &
      0.000000000000000_REALK,    -15.123676674269452_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -9.189158586136456_REALK,      0.000000000000000_REALK, &
    -16.328802621326638_REALK,      0.000000000000000_REALK,    -58.931544401802611_REALK, &
     35.330660370544258_REALK,     23.538878416978886_REALK,      0.000000000000000_REALK, &
     21.512040705023349_REALK,      0.000000000000000_REALK,     32.848604002200638_REALK, &
     24.157408662733275_REALK,      0.000000000000000_REALK,     25.683011434188483_REALK, &
      0.000000000000000_REALK,     33.221949422615438_REALK,      0.000000000000000_REALK, &
     28.541511230768400_REALK,      0.000000000000000_REALK,     56.034659951587614_REALK, &
     62.270137540874011_REALK,      0.000000000000000_REALK,     45.063028333766880_REALK, &
      0.000000000000000_REALK,     61.597125000451804_REALK,      0.000000000000000_REALK, &
    ! results of test 4, ket-major order, 002DPG X
    198.042046041847755_REALK,    143.623270496084302_REALK,      0.000000000000000_REALK, &
    132.130271268781968_REALK,      0.000000000000000_REALK,     52.985044135232627_REALK, &
    183.036446518299698_REALK,      0.000000000000000_REALK,     50.379803559677505_REALK, &
      0.000000000000000_REALK,    217.811470958051871_REALK,      0.000000000000000_REALK, &
     55.291872864502352_REALK,      0.000000000000000_REALK,     66.517134096072354_REALK, &
    579.602352171405983_REALK,      0.000000000000000_REALK,    161.691194418488067_REALK, &
      0.000000000000000_REALK,    133.513911033865554_REALK,      0.000000000000000_REALK, &
    104.414149010262463_REALK,     16.903173881000143_REALK,      0.000000000000000_REALK, &
    -11.329829713399464_REALK,      0.000000000000000_REALK,     24.773740411892451_REALK, &
    -62.292677251489458_REALK,      0.000000000000000_REALK,      5.100779918085220_REALK, &
      0.000000000000000_REALK,   -152.529625009080121_REALK,      0.000000000000000_REALK, &
     -4.177306561308778_REALK,      0.000000000000000_REALK,     27.402223419571893_REALK, &
   -683.794514375699123_REALK,      0.000000000000000_REALK,    -44.143883453064078_REALK, &
      0.000000000000000_REALK,     10.844046723885176_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -39.393306208413357_REALK, &
      0.000000000000000_REALK,    -25.894301606550229_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -29.644203409156443_REALK,      0.000000000000000_REALK, &
    -35.662518760583346_REALK,      0.000000000000000_REALK,    -34.686323790206757_REALK, &
      0.000000000000000_REALK,    -28.641675666216678_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -82.754719642547755_REALK,      0.000000000000000_REALK, &
    -63.022347959274960_REALK,      0.000000000000000_REALK,   -126.361728317934848_REALK, &
     80.738790234314109_REALK,     -6.879829767804624_REALK,      0.000000000000000_REALK, &
    -13.138803213658338_REALK,      0.000000000000000_REALK,     17.154590685418746_REALK, &
    -30.075358703508979_REALK,      0.000000000000000_REALK,     -1.791017733362885_REALK, &
      0.000000000000000_REALK,    -40.486521170142964_REALK,      0.000000000000000_REALK, &
     -4.213365915583140_REALK,      0.000000000000000_REALK,     16.503459222508198_REALK, &
    -87.921902997934893_REALK,      0.000000000000000_REALK,    -16.893837553417562_REALK, &
      0.000000000000000_REALK,     -3.018134839987047_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -19.710992173534837_REALK, &
      0.000000000000000_REALK,     -3.109446350860184_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.346726507870901_REALK,      0.000000000000000_REALK, &
    -15.394016007568956_REALK,      0.000000000000000_REALK,     12.177463843985194_REALK, &
      0.000000000000000_REALK,     -2.991422062877703_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     48.132434826116068_REALK,      0.000000000000000_REALK, &
      3.954587886758374_REALK,      0.000000000000000_REALK,    -43.235395509387075_REALK, &
     34.106654247843373_REALK,     20.602556086397325_REALK,      0.000000000000000_REALK, &
     18.071169820116619_REALK,      0.000000000000000_REALK,     21.739947734150814_REALK, &
     19.486076567377498_REALK,      0.000000000000000_REALK,     16.090315261586397_REALK, &
      0.000000000000000_REALK,     22.828589773659978_REALK,      0.000000000000000_REALK, &
     17.385248048081621_REALK,      0.000000000000000_REALK,     34.857952166605862_REALK, &
     39.236085550400553_REALK,      0.000000000000000_REALK,     32.836976143296063_REALK, &
      0.000000000000000_REALK,     45.191010835857654_REALK,      0.000000000000000_REALK, &
     72.019711990811601_REALK,    -30.414758408688066_REALK,      0.000000000000000_REALK, &
    -22.216019972097289_REALK,      0.000000000000000_REALK,     13.185017157931563_REALK, &
    -38.098843087556013_REALK,      0.000000000000000_REALK,     -6.730949413706869_REALK, &
      0.000000000000000_REALK,    -49.063271318292465_REALK,      0.000000000000000_REALK, &
     -6.081319143213661_REALK,      0.000000000000000_REALK,     10.827632133951521_REALK, &
   -122.375089617839564_REALK,      0.000000000000000_REALK,    -16.815975340744430_REALK, &
      0.000000000000000_REALK,     -8.912670584293616_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -15.359949337922519_REALK, &
      0.000000000000000_REALK,      1.285656891895725_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.603497630344715_REALK,      0.000000000000000_REALK, &
    -10.197717890909564_REALK,      0.000000000000000_REALK,      5.909728786689199_REALK, &
      0.000000000000000_REALK,      1.055790804758439_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     11.042025459954786_REALK,      0.000000000000000_REALK, &
      3.447376487334571_REALK,      0.000000000000000_REALK,    -22.505220459228912_REALK, &
     20.119934215398398_REALK,      2.784149111689203_REALK,      0.000000000000000_REALK, &
     -1.684564620459460_REALK,      0.000000000000000_REALK,     11.050377897109364_REALK, &
     -7.524624942772385_REALK,      0.000000000000000_REALK,      1.848441461791505_REALK, &
      0.000000000000000_REALK,    -16.837479037307116_REALK,      0.000000000000000_REALK, &
     -1.383376737225734_REALK,      0.000000000000000_REALK,     15.124418039288482_REALK, &
    -51.445833460275466_REALK,      0.000000000000000_REALK,     -9.963602348387834_REALK, &
      0.000000000000000_REALK,      4.079303139056221_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -19.465605558835801_REALK, &
      0.000000000000000_REALK,    -11.550206524193088_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -10.742587518623139_REALK,      0.000000000000000_REALK, &
    -21.539215364319343_REALK,      0.000000000000000_REALK,    -11.486888196258647_REALK, &
      0.000000000000000_REALK,    -15.808522888408202_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -18.678354835893661_REALK,      0.000000000000000_REALK, &
    -23.707686660432906_REALK,      0.000000000000000_REALK,    -66.548487972480487_REALK, &
     70.272400242446039_REALK,    -55.475608300662905_REALK,      0.000000000000000_REALK, &
    -21.391065470166655_REALK,      0.000000000000000_REALK,     11.385084732339543_REALK, &
    -32.321265046462365_REALK,      0.000000000000000_REALK,    -10.517157743813526_REALK, &
      0.000000000000000_REALK,    -22.199990154340270_REALK,      0.000000000000000_REALK, &
     -4.948276181752198_REALK,      0.000000000000000_REALK,      7.900944955757847_REALK, &
    -34.930635315355119_REALK,      0.000000000000000_REALK,    -11.161591540491431_REALK, &
      0.000000000000000_REALK,    -10.895757211354395_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -13.396185734304186_REALK, &
      0.000000000000000_REALK,      5.670400971408676_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.279204414741559_REALK,      0.000000000000000_REALK, &
     -7.619013266308863_REALK,      0.000000000000000_REALK,      7.424560422643185_REALK, &
      0.000000000000000_REALK,      3.935106940830771_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     11.922285399913752_REALK,      0.000000000000000_REALK, &
      4.433248363913347_REALK,      0.000000000000000_REALK,    -13.155474251685090_REALK, &
     17.675337002689105_REALK,     -1.306247713455783_REALK,      0.000000000000000_REALK, &
     -2.193282787433199_REALK,      0.000000000000000_REALK,      8.590935079234203_REALK, &
     -4.158462484598665_REALK,      0.000000000000000_REALK,     -0.742921817844007_REALK, &
      0.000000000000000_REALK,     -4.875256032111274_REALK,      0.000000000000000_REALK, &
     -1.522079719503315_REALK,      0.000000000000000_REALK,      9.936466112649144_REALK, &
     -7.473763111601678_REALK,      0.000000000000000_REALK,     -4.308159933358890_REALK, &
      0.000000000000000_REALK,     -1.282776194770537_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -11.227358521477255_REALK, &
      0.000000000000000_REALK,     -1.557195518241505_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.973432194854167_REALK,      0.000000000000000_REALK, &
    -10.642506160253703_REALK,      0.000000000000000_REALK,      4.399112520316064_REALK, &
      0.000000000000000_REALK,     -1.801086884613625_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     12.274430043334512_REALK,      0.000000000000000_REALK, &
      1.680790113831804_REALK,      0.000000000000000_REALK,    -25.726441892051511_REALK, &
     22.399887567622436_REALK,     11.735192303074415_REALK,      0.000000000000000_REALK, &
      9.049953425143391_REALK,      0.000000000000000_REALK,     18.145432422430638_REALK, &
      8.082907922358601_REALK,      0.000000000000000_REALK,     11.123886009190922_REALK, &
      0.000000000000000_REALK,      8.246835004488229_REALK,      0.000000000000000_REALK, &
     10.467376915390011_REALK,      0.000000000000000_REALK,     29.382373604584007_REALK, &
     10.005739144560565_REALK,      0.000000000000000_REALK,     13.956464352351132_REALK, &
      0.000000000000000_REALK,     26.890095501944529_REALK,      0.000000000000000_REALK, &
     75.728735116206835_REALK,   -108.130029482796189_REALK,      0.000000000000000_REALK, &
    -23.832044119393558_REALK,      0.000000000000000_REALK,     10.058375058176154_REALK, &
    -42.067177097734707_REALK,      0.000000000000000_REALK,    -16.854212327797431_REALK, &
      0.000000000000000_REALK,    -22.144329552546846_REALK,      0.000000000000000_REALK, &
     -4.517088587157097_REALK,      0.000000000000000_REALK,      5.719346307813388_REALK, &
    -49.760288649517285_REALK,      0.000000000000000_REALK,    -11.210251538995303_REALK, &
      0.000000000000000_REALK,    -13.474160097356693_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -14.129997693324821_REALK, &
      0.000000000000000_REALK,     10.777149029569195_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.138094270334999_REALK,      0.000000000000000_REALK, &
     -6.607322196813278_REALK,      0.000000000000000_REALK,      6.277564228674702_REALK, &
      0.000000000000000_REALK,      6.128052210671675_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.947333856634136_REALK,      0.000000000000000_REALK, &
      3.308214208532803_REALK,      0.000000000000000_REALK,     -8.803745453774754_REALK, &
     19.593672873090551_REALK,     -7.037519221850081_REALK,      0.000000000000000_REALK, &
     -4.384989255560784_REALK,      0.000000000000000_REALK,      7.807360451313512_REALK, &
     -6.208936166092586_REALK,      0.000000000000000_REALK,     -3.290811362764546_REALK, &
      0.000000000000000_REALK,     -6.705397888736394_REALK,      0.000000000000000_REALK, &
     -2.493372136506955_REALK,      0.000000000000000_REALK,      7.398974803372292_REALK, &
    -12.040933105414860_REALK,      0.000000000000000_REALK,     -4.963756140547720_REALK, &
      0.000000000000000_REALK,     -4.384751448649146_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -10.662186159078143_REALK, &
      0.000000000000000_REALK,      0.761287349990829_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.272869406420126_REALK,      0.000000000000000_REALK, &
     -8.309567206406674_REALK,      0.000000000000000_REALK,      2.423019207516405_REALK, &
      0.000000000000000_REALK,      0.721466103151489_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.259395935728605_REALK,      0.000000000000000_REALK, &
      1.695999970369969_REALK,      0.000000000000000_REALK,    -15.500597257407854_REALK, &
     16.421479551108746_REALK,      1.932631122042316_REALK,      0.000000000000000_REALK, &
     -0.997496100150726_REALK,      0.000000000000000_REALK,     10.905596144037068_REALK, &
     -3.678845247565141_REALK,      0.000000000000000_REALK,      1.506194691614000_REALK, &
      0.000000000000000_REALK,     -6.903453032470873_REALK,      0.000000000000000_REALK, &
     -0.945319299333190_REALK,      0.000000000000000_REALK,     14.469208156089744_REALK, &
    -15.185831720703090_REALK,      0.000000000000000_REALK,     -4.901776568276491_REALK, &
      0.000000000000000_REALK,      2.809642996563500_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -22.520246823023793_REALK, &
      0.000000000000000_REALK,    -11.398876029933955_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.753551913441152_REALK,      0.000000000000000_REALK, &
    -24.571593701731715_REALK,      0.000000000000000_REALK,     -7.849472098961582_REALK, &
      0.000000000000000_REALK,    -15.123676674269452_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -9.189158586136458_REALK,      0.000000000000000_REALK, &
    -16.328802621326641_REALK,      0.000000000000000_REALK,    -58.931544401802618_REALK, &
     57.858512533766628_REALK,   -218.145754812297270_REALK,      0.000000000000000_REALK, &
    -18.504307662408792_REALK,      0.000000000000000_REALK,      6.792182928632020_REALK, &
    -57.535324268936044_REALK,      0.000000000000000_REALK,    -28.760714085827068_REALK, &
      0.000000000000000_REALK,     -6.029491690370040_REALK,      0.000000000000000_REALK, &
     -2.871054624798953_REALK,      0.000000000000000_REALK,      3.161544095380269_REALK, &
    -30.940073260024853_REALK,      0.000000000000000_REALK,    -11.770631985739797_REALK, &
      0.000000000000000_REALK,    -17.651683663185519_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -14.833455985536135_REALK, &
      0.000000000000000_REALK,     21.109495870577664_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.633708555937035_REALK,      0.000000000000000_REALK, &
     -5.867005574393908_REALK,      0.000000000000000_REALK,      8.174879986753472_REALK, &
      0.000000000000000_REALK,      9.825795731258445_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.647269509181012_REALK,      0.000000000000000_REALK, &
      2.843905661476716_REALK,      0.000000000000000_REALK,     -6.001388221232292_REALK, &
     23.498033667542586_REALK,    -15.893458421967548_REALK,      0.000000000000000_REALK, &
     -5.182863619655927_REALK,      0.000000000000000_REALK,      8.275512252754051_REALK, &
     -6.439635290651119_REALK,      0.000000000000000_REALK,     -6.286263244991934_REALK, &
      0.000000000000000_REALK,     -3.607756738704810_REALK,      0.000000000000000_REALK, &
     -2.412457386094664_REALK,      0.000000000000000_REALK,      6.419977488300431_REALK, &
     -4.122938411191140_REALK,      0.000000000000000_REALK,     -3.952280347339314_REALK, &
      0.000000000000000_REALK,     -6.430248909036941_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -11.513801876341438_REALK, &
      0.000000000000000_REALK,      4.121662141312687_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.557744790508682_REALK,      0.000000000000000_REALK, &
     -7.589997891346728_REALK,      0.000000000000000_REALK,      3.619732402197725_REALK, &
      0.000000000000000_REALK,      3.197503351264027_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.221639370201762_REALK,      0.000000000000000_REALK, &
      2.616329448478970_REALK,      0.000000000000000_REALK,    -10.869383489313709_REALK, &
     17.731100512067531_REALK,     -1.122698480929586_REALK,      0.000000000000000_REALK, &
     -1.594238339711347_REALK,      0.000000000000000_REALK,     10.407533215932409_REALK, &
     -2.485575524241554_REALK,      0.000000000000000_REALK,     -0.740092559728968_REALK, &
      0.000000000000000_REALK,     -2.376857513964526_REALK,      0.000000000000000_REALK, &
     -1.236778333392734_REALK,      0.000000000000000_REALK,     11.303539609394516_REALK, &
     -2.646433258150951_REALK,      0.000000000000000_REALK,     -2.542507158893834_REALK, &
      0.000000000000000_REALK,     -1.059861934672372_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -16.082884110302718_REALK, &
      0.000000000000000_REALK,     -1.886472651734228_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.969725087496998_REALK,      0.000000000000000_REALK, &
    -14.842767047148733_REALK,      0.000000000000000_REALK,      3.574534882482390_REALK, &
      0.000000000000000_REALK,     -2.048883044473373_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      7.243887585247590_REALK,      0.000000000000000_REALK, &
      1.388711038672363_REALK,      0.000000000000000_REALK,    -27.328928046164265_REALK, &
     37.450927419384769_REALK,     16.810342117553496_REALK,      0.000000000000000_REALK, &
     10.963613390873979_REALK,      0.000000000000000_REALK,     30.775330563786870_REALK, &
      8.052125904273828_REALK,      0.000000000000000_REALK,     15.514132311248938_REALK, &
      0.000000000000000_REALK,      6.701033278299059_REALK,      0.000000000000000_REALK, &
     11.907493894529885_REALK,      0.000000000000000_REALK,     42.974798669142672_REALK, &
      5.904995125200765_REALK,      0.000000000000000_REALK,     11.531181643353500_REALK, &
      0.000000000000000_REALK,     28.565065010182245_REALK,      0.000000000000000_REALK, &
    ! results of test 4, ket-major order, 003DPG X
      0.000000000000000_REALK,      0.000000000000000_REALK,    -59.126430230459384_REALK, &
      0.000000000000000_REALK,    -55.381653745571086_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -95.077127081725280_REALK,      0.000000000000000_REALK, &
    -62.220654004882881_REALK,      0.000000000000000_REALK,   -152.590443482112050_REALK, &
      0.000000000000000_REALK,    -69.525824669584864_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,   -684.338591860708675_REALK,      0.000000000000000_REALK, &
   -251.968411736821366_REALK,      0.000000000000000_REALK,   -274.823185625578731_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -39.393306208413357_REALK, &
      0.000000000000000_REALK,    -25.894301606550229_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -29.644203409156443_REALK,      0.000000000000000_REALK, &
    -35.662518760583346_REALK,      0.000000000000000_REALK,    -34.686323790206764_REALK, &
      0.000000000000000_REALK,    -28.641675666216678_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -82.754719642547755_REALK,      0.000000000000000_REALK, &
    -63.022347959274960_REALK,      0.000000000000000_REALK,   -126.361728317934862_REALK, &
    -42.984927687581028_REALK,    -39.393306208413357_REALK,      0.000000000000000_REALK, &
    -46.753180818600420_REALK,      0.000000000000000_REALK,     11.121403899826991_REALK, &
    -78.269615344054088_REALK,      0.000000000000000_REALK,     12.962893174314317_REALK, &
      0.000000000000000_REALK,   -140.452772625661794_REALK,      0.000000000000000_REALK, &
     18.797293063089544_REALK,      0.000000000000000_REALK,     35.883631412026368_REALK, &
   -536.517917828974760_REALK,      0.000000000000000_REALK,     60.483640451222541_REALK, &
      0.000000000000000_REALK,     80.389493047497353_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -36.307162072048065_REALK, &
      0.000000000000000_REALK,    -17.930523924110883_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -17.459092184367115_REALK,      0.000000000000000_REALK, &
    -28.355398308002908_REALK,      0.000000000000000_REALK,    -19.116140770125615_REALK, &
      0.000000000000000_REALK,    -17.249940604604305_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -42.515201713058389_REALK,      0.000000000000000_REALK, &
    -29.421201931509543_REALK,      0.000000000000000_REALK,    -79.638533574989808_REALK, &
    -32.630708157060390_REALK,    -19.710992173534837_REALK,      0.000000000000000_REALK, &
    -17.289150210158454_REALK,      0.000000000000000_REALK,      7.560243874852546_REALK, &
    -18.642827671565996_REALK,      0.000000000000000_REALK,      5.595538171867948_REALK, &
      0.000000000000000_REALK,    -21.840695517316959_REALK,      0.000000000000000_REALK, &
      6.045861594314238_REALK,      0.000000000000000_REALK,     21.216462916263030_REALK, &
    -37.538166233398009_REALK,      0.000000000000000_REALK,     11.419325878417544_REALK, &
      0.000000000000000_REALK,     27.505729566808711_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.747530105590484_REALK, &
      0.000000000000000_REALK,      6.918870160900110_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      9.245878869782320_REALK,      0.000000000000000_REALK, &
     -7.197317521416794_REALK,      0.000000000000000_REALK,     14.608680517424002_REALK, &
      0.000000000000000_REALK,     -7.917603458573956_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     42.316709058925319_REALK,      0.000000000000000_REALK, &
    -18.533220553343405_REALK,      0.000000000000000_REALK,    -57.422495153611067_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -40.752514733340966_REALK, &
      0.000000000000000_REALK,    -13.781399388972572_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -11.410032812268375_REALK,      0.000000000000000_REALK, &
    -27.056251257919552_REALK,      0.000000000000000_REALK,     -9.074729766718521_REALK, &
      0.000000000000000_REALK,    -11.317385566320231_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -13.323584190137533_REALK,      0.000000000000000_REALK, &
    -15.108398171087199_REALK,      0.000000000000000_REALK,    -59.710114152359530_REALK, &
    -35.456654474039752_REALK,    -15.359949337922515_REALK,      0.000000000000000_REALK, &
    -11.990415553778504_REALK,      0.000000000000000_REALK,      7.078451453250198_REALK, &
    -11.300967070264726_REALK,      0.000000000000000_REALK,      3.706746809699883_REALK, &
      0.000000000000000_REALK,    -14.228884723745864_REALK,      0.000000000000000_REALK, &
      3.579125745527009_REALK,      0.000000000000000_REALK,     16.956398091515251_REALK, &
    -29.764386906219201_REALK,      0.000000000000000_REALK,      5.439225533327563_REALK, &
      0.000000000000000_REALK,     14.317493814959121_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.926959836582648_REALK, &
      0.000000000000000_REALK,      3.516849756675210_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.270942923989950_REALK,      0.000000000000000_REALK, &
     -4.680681997309357_REALK,      0.000000000000000_REALK,      3.497570357149073_REALK, &
      0.000000000000000_REALK,     -3.435346517329530_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.687254814198655_REALK,      0.000000000000000_REALK, &
     -5.151912002011135_REALK,      0.000000000000000_REALK,    -29.343594279349876_REALK, &
    -24.848756385768681_REALK,    -19.465605558835797_REALK,      0.000000000000000_REALK, &
    -20.854352526008146_REALK,      0.000000000000000_REALK,     -4.137652838625089_REALK, &
    -28.363662915049328_REALK,      0.000000000000000_REALK,     -3.918139967893141_REALK, &
      0.000000000000000_REALK,    -46.513009154951931_REALK,      0.000000000000000_REALK, &
     -5.192163034360906_REALK,      0.000000000000000_REALK,      7.352900089629047_REALK, &
   -121.096078728929214_REALK,      0.000000000000000_REALK,    -11.386563202814902_REALK, &
      0.000000000000000_REALK,     11.226989005319112_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -53.862283769833155_REALK, &
      0.000000000000000_REALK,    -11.900052756418223_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -9.891609813417421_REALK,      0.000000000000000_REALK, &
    -30.633903018019538_REALK,      0.000000000000000_REALK,     -6.088022170910113_REALK, &
      0.000000000000000_REALK,     -8.258319020850548_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -9.292452342070636_REALK,      0.000000000000000_REALK, &
    -10.247690638646532_REALK,      0.000000000000000_REALK,    -52.894450802999451_REALK, &
    -44.866243927711409_REALK,    -13.396185734304190_REALK,      0.000000000000000_REALK, &
     -9.196270080904005_REALK,      0.000000000000000_REALK,      7.926516652108481_REALK, &
     -6.109227796086909_REALK,      0.000000000000000_REALK,      2.769418944519607_REALK, &
      0.000000000000000_REALK,     -5.628039477241497_REALK,      0.000000000000000_REALK, &
      2.319767263199802_REALK,      0.000000000000000_REALK,     16.046033648411164_REALK, &
     -5.337151586124880_REALK,      0.000000000000000_REALK,      2.300569074853013_REALK, &
      0.000000000000000_REALK,      8.369321312474220_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.296880840643495_REALK, &
      0.000000000000000_REALK,      2.734117169958564_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.205103356673220_REALK,      0.000000000000000_REALK, &
     -4.259974371661403_REALK,      0.000000000000000_REALK,      2.102676723766463_REALK, &
      0.000000000000000_REALK,     -2.256959849032181_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.301199821872861_REALK,      0.000000000000000_REALK, &
     -2.717389680225639_REALK,      0.000000000000000_REALK,    -20.894821249705092_REALK, &
    -21.430545155752728_REALK,    -11.227358521477250_REALK,      0.000000000000000_REALK, &
     -8.658321830834984_REALK,      0.000000000000000_REALK,     -3.157946515349807_REALK, &
     -7.733124672923679_REALK,      0.000000000000000_REALK,     -1.935949292475850_REALK, &
      0.000000000000000_REALK,     -7.889957903680947_REALK,      0.000000000000000_REALK, &
     -1.821693508607001_REALK,      0.000000000000000_REALK,      4.742412884609841_REALK, &
     -9.572746466108610_REALK,      0.000000000000000_REALK,     -2.428918029731211_REALK, &
      0.000000000000000_REALK,      4.340150904517651_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     13.657079980466236_REALK, &
      0.000000000000000_REALK,     10.723109292079435_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     11.869075731452130_REALK,      0.000000000000000_REALK, &
      3.786758092371225_REALK,      0.000000000000000_REALK,     16.332199934217073_REALK, &
      0.000000000000000_REALK,      3.627902787965711_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     33.396493023525295_REALK,      0.000000000000000_REALK, &
      5.994708506515597_REALK,      0.000000000000000_REALK,    -12.986238825051762_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -87.933937713165236_REALK, &
      0.000000000000000_REALK,    -10.513333598312260_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -10.415900393603863_REALK,      0.000000000000000_REALK, &
    -41.118751121938814_REALK,      0.000000000000000_REALK,     -3.429584060846997_REALK, &
      0.000000000000000_REALK,     -5.978042710729927_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.313392427227242_REALK,      0.000000000000000_REALK, &
     -8.327028681730148_REALK,      0.000000000000000_REALK,    -54.787553485624962_REALK, &
    -75.371444170591772_REALK,    -14.129997693324817_REALK,      0.000000000000000_REALK, &
     -9.697501552101059_REALK,      0.000000000000000_REALK,     10.916543334458547_REALK, &
     -4.870909433625004_REALK,      0.000000000000000_REALK,      2.401681507146729_REALK, &
      0.000000000000000_REALK,     -5.000146883384655_REALK,      0.000000000000000_REALK, &
      2.004325976605707_REALK,      0.000000000000000_REALK,     18.106990122692338_REALK, &
     -5.671689429453863_REALK,      0.000000000000000_REALK,      1.415445741183773_REALK, &
      0.000000000000000_REALK,      5.600814767011319_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.613406748537397_REALK, &
      0.000000000000000_REALK,      2.484739794343148_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.698547202532119_REALK,      0.000000000000000_REALK, &
     -4.790957213020794_REALK,      0.000000000000000_REALK,      1.132888251813419_REALK, &
      0.000000000000000_REALK,     -1.680596387678910_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.197494456184153_REALK,      0.000000000000000_REALK, &
     -1.615231608383814_REALK,      0.000000000000000_REALK,    -18.133773172899271_REALK, &
    -28.938997521699545_REALK,    -10.662186159078137_REALK,      0.000000000000000_REALK, &
     -7.099990471614264_REALK,      0.000000000000000_REALK,     -3.495993988856078_REALK, &
     -5.525127074840723_REALK,      0.000000000000000_REALK,     -1.511570725145818_REALK, &
      0.000000000000000_REALK,     -5.833915942949374_REALK,      0.000000000000000_REALK, &
     -1.223982339235404_REALK,      0.000000000000000_REALK,      4.301709396904592_REALK, &
     -8.785881001942718_REALK,      0.000000000000000_REALK,     -1.339165741365687_REALK, &
      0.000000000000000_REALK,      2.615011103734788_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     12.732507381585537_REALK, &
      0.000000000000000_REALK,      6.444701709242858_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.949087158273723_REALK,      0.000000000000000_REALK, &
      2.902615236622065_REALK,      0.000000000000000_REALK,      4.437938101966089_REALK, &
      0.000000000000000_REALK,      1.786543228792947_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.195370656813823_REALK,      0.000000000000000_REALK, &
      1.928903426443874_REALK,      0.000000000000000_REALK,     -7.681384538969589_REALK, &
    -33.801746110008615_REALK,    -22.520246823023786_REALK,      0.000000000000000_REALK, &
    -20.581119361856089_REALK,      0.000000000000000_REALK,    -13.062612657410071_REALK, &
    -23.112010523704058_REALK,      0.000000000000000_REALK,    -10.213135091468805_REALK, &
      0.000000000000000_REALK,    -31.784288430652264_REALK,      0.000000000000000_REALK, &
    -11.349849322049423_REALK,      0.000000000000000_REALK,     -4.878924392947861_REALK, &
    -59.575432706793627_REALK,      0.000000000000000_REALK,    -17.919814317054598_REALK, &
      0.000000000000000_REALK,     -5.363246889689534_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,   -165.807060800342128_REALK, &
      0.000000000000000_REALK,     -7.099405677005869_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -14.647747284119431_REALK,      0.000000000000000_REALK, &
    -65.580870091098788_REALK,      0.000000000000000_REALK,     -1.504791410264310_REALK, &
      0.000000000000000_REALK,     -3.304546466826037_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.083494137533934_REALK,      0.000000000000000_REALK, &
     -8.989950689888294_REALK,      0.000000000000000_REALK,    -67.082987447739697_REALK, &
   -139.905031185386491_REALK,    -14.833455985536107_REALK,      0.000000000000000_REALK, &
    -12.481121170468588_REALK,      0.000000000000000_REALK,     17.909630501243431_REALK, &
     -3.365882409425768_REALK,      0.000000000000000_REALK,      2.132585390968909_REALK, &
      0.000000000000000_REALK,     -3.707023173704343_REALK,      0.000000000000000_REALK, &
      2.111705728173266_REALK,      0.000000000000000_REALK,     24.317506951118954_REALK, &
     -0.986079864836518_REALK,      0.000000000000000_REALK,      0.750888303493952_REALK, &
      0.000000000000000_REALK,      3.817995868750790_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     14.095692627935987_REALK, &
      0.000000000000000_REALK,      2.633731943237341_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.800218490337744_REALK,      0.000000000000000_REALK, &
     -6.631694573860373_REALK,      0.000000000000000_REALK,      0.903745213735571_REALK, &
      0.000000000000000_REALK,     -1.458227830550261_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.001880734136710_REALK,      0.000000000000000_REALK, &
     -1.314242874554471_REALK,      0.000000000000000_REALK,    -19.270085063755129_REALK, &
    -45.007791396574774_REALK,    -11.513801876341438_REALK,      0.000000000000000_REALK, &
     -6.684521681071217_REALK,      0.000000000000000_REALK,     -4.805625057761214_REALK, &
     -3.651577268812441_REALK,      0.000000000000000_REALK,     -1.380675832025604_REALK, &
      0.000000000000000_REALK,     -2.743865723617675_REALK,      0.000000000000000_REALK, &
     -0.943319958077930_REALK,      0.000000000000000_REALK,      4.840515059642726_REALK, &
     -1.889866624135886_REALK,      0.000000000000000_REALK,     -0.679462954493952_REALK, &
      0.000000000000000_REALK,      1.833707310969783_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     16.748986843486598_REALK, &
      0.000000000000000_REALK,      6.150369610229483_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.078952057938384_REALK,      0.000000000000000_REALK, &
      3.229645351254796_REALK,      0.000000000000000_REALK,      3.172515124882896_REALK, &
      0.000000000000000_REALK,      1.395671548346435_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.617586339768602_REALK,      0.000000000000000_REALK, &
      1.220470290096307_REALK,      0.000000000000000_REALK,     -6.561423954735804_REALK, &
    -35.830259806573302_REALK,    -16.082884110302707_REALK,      0.000000000000000_REALK, &
    -10.489169248463273_REALK,      0.000000000000000_REALK,    -12.238152419858379_REALK, &
     -7.703674729188048_REALK,      0.000000000000000_REALK,     -6.169367230463686_REALK, &
      0.000000000000000_REALK,     -6.411049869212910_REALK,      0.000000000000000_REALK, &
     -4.735147358295617_REALK,      0.000000000000000_REALK,     -3.741805405619544_REALK, &
     -5.649459815058646_REALK,      0.000000000000000_REALK,     -4.585502607029298_REALK, &
      0.000000000000000_REALK,     -2.487153354454700_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     32.805308045669669_REALK, &
      0.000000000000000_REALK,     21.783518402938913_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     19.827125353956227_REALK,      0.000000000000000_REALK, &
     17.502130314239093_REALK,      0.000000000000000_REALK,     22.253538784393303_REALK, &
      0.000000000000000_REALK,     13.676990203409769_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     33.049976638252431_REALK,      0.000000000000000_REALK, &
     16.414167572100325_REALK,      0.000000000000000_REALK,      8.706250200850000_REALK, &
    ! results of test 4, ket-major order, 001DPG Y
   -119.598412805165353_REALK,    -41.519738546625263_REALK,      0.000000000000000_REALK, &
    -19.852197005226689_REALK,      0.000000000000000_REALK,    -18.965574200208362_REALK, &
      2.125696993991477_REALK,      0.000000000000000_REALK,     -5.319526470967738_REALK, &
      0.000000000000000_REALK,     27.878240877906855_REALK,      0.000000000000000_REALK, &
     -3.161314971442556_REALK,      0.000000000000000_REALK,     -9.060380618629480_REALK, &
   -216.960671512297182_REALK,      0.000000000000000_REALK,     -1.542337926217971_REALK, &
      0.000000000000000_REALK,     11.579036121636740_REALK,      0.000000000000000_REALK, &
   -116.883119751532405_REALK,    -35.667486404572422_REALK,      0.000000000000000_REALK, &
    -22.104881068957564_REALK,      0.000000000000000_REALK,    -14.243522956000604_REALK, &
     -9.976649513678872_REALK,      0.000000000000000_REALK,     -3.200215060995010_REALK, &
      0.000000000000000_REALK,     -6.633045785850044_REALK,      0.000000000000000_REALK, &
     -1.433978519633670_REALK,      0.000000000000000_REALK,     -2.771999437467747_REALK, &
     80.363716398307972_REALK,      0.000000000000000_REALK,     10.262977322753144_REALK, &
      0.000000000000000_REALK,      9.876181744350102_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     14.234949603194789_REALK, &
      0.000000000000000_REALK,      4.974921800071858_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.336919244143567_REALK,      0.000000000000000_REALK, &
      3.831632506641312_REALK,      0.000000000000000_REALK,     -0.128964181398589_REALK, &
      0.000000000000000_REALK,      0.968193084944303_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     12.128062510620161_REALK,      0.000000000000000_REALK, &
     -4.125865662470743_REALK,      0.000000000000000_REALK,    -19.707997895920336_REALK, &
   -110.225169596490844_REALK,    -22.157115477966528_REALK,      0.000000000000000_REALK, &
    -10.466889134455700_REALK,      0.000000000000000_REALK,    -10.062797122970165_REALK, &
     -1.792883563439939_REALK,      0.000000000000000_REALK,     -0.975596716580445_REALK, &
      0.000000000000000_REALK,      0.935546999446719_REALK,      0.000000000000000_REALK, &
      0.629679351400687_REALK,      0.000000000000000_REALK,      1.816108535479789_REALK, &
     -5.379088689279501_REALK,      0.000000000000000_REALK,      4.099841516730410_REALK, &
      0.000000000000000_REALK,      6.692780284986484_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     12.115269763580606_REALK, &
      0.000000000000000_REALK,      3.289424276718133_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.827867741621033_REALK,      0.000000000000000_REALK, &
      1.600337022243158_REALK,      0.000000000000000_REALK,     -0.616917758357019_REALK, &
      0.000000000000000_REALK,     -0.593667092038018_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.756817381688615_REALK,      0.000000000000000_REALK, &
     -5.679331229320169_REALK,      0.000000000000000_REALK,    -18.297697347296289_REALK, &
    -14.380215078390263_REALK,     -4.231573877247594_REALK,      0.000000000000000_REALK, &
     -1.374187213633753_REALK,      0.000000000000000_REALK,     -3.938443119160089_REALK, &
      0.074453894631371_REALK,      0.000000000000000_REALK,     -0.558959434685748_REALK, &
      0.000000000000000_REALK,     -0.729029881092875_REALK,      0.000000000000000_REALK, &
      0.248009882096363_REALK,      0.000000000000000_REALK,      1.184667324237492_REALK, &
    -23.949909785006728_REALK,      0.000000000000000_REALK,     -0.510767973754466_REALK, &
      0.000000000000000_REALK,      6.390947921057112_REALK,      0.000000000000000_REALK, &
   -129.319499694287146_REALK,    -14.600178878365073_REALK,      0.000000000000000_REALK, &
     -5.466001443994157_REALK,      0.000000000000000_REALK,     -6.291280205590595_REALK, &
      0.821556359267037_REALK,      0.000000000000000_REALK,      0.390886189556716_REALK, &
      0.000000000000000_REALK,      5.141284299655559_REALK,      0.000000000000000_REALK, &
      1.864792428899261_REALK,      0.000000000000000_REALK,      6.439038746519036_REALK, &
     19.655810884853942_REALK,      0.000000000000000_REALK,      3.534044114917076_REALK, &
      0.000000000000000_REALK,      5.044361310906466_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     10.529963227871356_REALK, &
      0.000000000000000_REALK,      1.351497121551936_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.293236421975313_REALK,      0.000000000000000_REALK, &
     -0.845746597340843_REALK,      0.000000000000000_REALK,     -0.847339858702405_REALK, &
      0.000000000000000_REALK,     -1.383238712487919_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.874125520479237_REALK,      0.000000000000000_REALK, &
     -3.784197297014738_REALK,      0.000000000000000_REALK,    -18.190509703498261_REALK, &
    -15.190077159236930_REALK,     -3.442136043430990_REALK,      0.000000000000000_REALK, &
     -1.146847719771175_REALK,      0.000000000000000_REALK,     -2.216951781731711_REALK, &
      0.287293454535606_REALK,      0.000000000000000_REALK,      0.276465813157880_REALK, &
      0.000000000000000_REALK,      1.809826153670492_REALK,      0.000000000000000_REALK, &
      1.173782864956715_REALK,      0.000000000000000_REALK,      3.781699419738061_REALK, &
      9.677139003552156_REALK,      0.000000000000000_REALK,      3.707503681773862_REALK, &
      0.000000000000000_REALK,      5.946289435566249_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.121285633907106_REALK, &
      0.000000000000000_REALK,      0.774328218005841_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.115496133514118_REALK,      0.000000000000000_REALK, &
     -0.551689691932451_REALK,      0.000000000000000_REALK,      0.105563607994285_REALK, &
      0.000000000000000_REALK,     -1.320857132234131_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.381266273600762_REALK,      0.000000000000000_REALK, &
     -2.484117044054027_REALK,      0.000000000000000_REALK,    -16.612213890494615_REALK, &
   -103.431853848360120_REALK,     -3.981916580291823_REALK,      0.000000000000000_REALK, &
      1.958816364563390_REALK,      0.000000000000000_REALK,      2.813129023995622_REALK, &
      1.926344162668774_REALK,      0.000000000000000_REALK,      1.372286622904865_REALK, &
      0.000000000000000_REALK,      5.006625827886269_REALK,      0.000000000000000_REALK, &
      3.183905853115261_REALK,      0.000000000000000_REALK,     13.717576788364992_REALK, &
     -2.538335041386676_REALK,      0.000000000000000_REALK,      1.624906387683025_REALK, &
      0.000000000000000_REALK,      3.472646283830475_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.882363737276713_REALK, &
      0.000000000000000_REALK,     -0.393599639500803_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.461886034412893_REALK,      0.000000000000000_REALK, &
     -5.047822305958212_REALK,      0.000000000000000_REALK,     -1.344646794204944_REALK, &
      0.000000000000000_REALK,     -1.919298131251818_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.399766612505725_REALK,      0.000000000000000_REALK, &
     -3.699382490548074_REALK,      0.000000000000000_REALK,    -21.289650281071541_REALK, &
    -10.437296647891769_REALK,     -1.048832721110630_REALK,      0.000000000000000_REALK, &
      0.295272007713750_REALK,      0.000000000000000_REALK,      0.851617592834107_REALK, &
      0.664263907683077_REALK,      0.000000000000000_REALK,      1.084376644128149_REALK, &
      0.000000000000000_REALK,      0.713074537585168_REALK,      0.000000000000000_REALK, &
      1.439826045914901_REALK,      0.000000000000000_REALK,      6.921195594168974_REALK, &
     -0.735151345829092_REALK,      0.000000000000000_REALK,      1.680956115141163_REALK, &
      0.000000000000000_REALK,      4.573457250902162_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.720470974540198_REALK, &
      0.000000000000000_REALK,     -0.278384980847345_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.920175753140660_REALK,      0.000000000000000_REALK, &
     -2.964626776893177_REALK,      0.000000000000000_REALK,     -1.410645362110095_REALK, &
      0.000000000000000_REALK,     -2.262467237802575_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.590340179457192_REALK,      0.000000000000000_REALK, &
     -3.880925039370521_REALK,      0.000000000000000_REALK,    -17.505016788574320_REALK, &
     -4.085017183908883_REALK,     -0.600919350084315_REALK,      0.000000000000000_REALK, &
      0.116297883449007_REALK,      0.000000000000000_REALK,      0.555519406063374_REALK, &
     -0.082755572082719_REALK,      0.000000000000000_REALK,      1.035473206102369_REALK, &
      0.000000000000000_REALK,     -1.667001162913820_REALK,      0.000000000000000_REALK, &
      0.945166475318740_REALK,      0.000000000000000_REALK,      6.320679489600701_REALK, &
     -9.819586231784944_REALK,      0.000000000000000_REALK,     -0.349029161817268_REALK, &
      0.000000000000000_REALK,      6.114083566342276_REALK,      0.000000000000000_REALK, &
   -128.501247908114408_REALK,      0.991324984190903_REALK,      0.000000000000000_REALK, &
     15.271095865765005_REALK,      0.000000000000000_REALK,     23.679654033992573_REALK, &
      0.966194982140757_REALK,      0.000000000000000_REALK,      1.073193514040122_REALK, &
      0.000000000000000_REALK,     12.676000442493534_REALK,      0.000000000000000_REALK, &
      6.128691731918035_REALK,      0.000000000000000_REALK,     28.509800704903071_REALK, &
      4.274332561480140_REALK,      0.000000000000000_REALK,      0.410332775015635_REALK, &
      0.000000000000000_REALK,      1.367321754567063_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.247867272509743_REALK, &
      0.000000000000000_REALK,     -1.720777256317440_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.202115538727353_REALK,      0.000000000000000_REALK, &
    -13.796031608387839_REALK,      0.000000000000000_REALK,     -0.969418453311436_REALK, &
      0.000000000000000_REALK,     -2.071779282109233_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.138421665301146_REALK,      0.000000000000000_REALK, &
     -4.079713657844056_REALK,      0.000000000000000_REALK,    -29.295142485269590_REALK, &
    -11.449713599011783_REALK,      0.594341394527412_REALK,      0.000000000000000_REALK, &
      1.833130336883126_REALK,      0.000000000000000_REALK,      6.329711062575100_REALK, &
      1.352337221155798_REALK,      0.000000000000000_REALK,      1.930275156697395_REALK, &
      0.000000000000000_REALK,      2.028299301484486_REALK,      0.000000000000000_REALK, &
      2.207050005697990_REALK,      0.000000000000000_REALK,     12.701396217936326_REALK, &
      3.194298001104070_REALK,      0.000000000000000_REALK,      1.722969881765390_REALK, &
      0.000000000000000_REALK,      4.098837068251272_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.285955414926309_REALK, &
      0.000000000000000_REALK,     -1.359752864563855_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.448060830748931_REALK,      0.000000000000000_REALK, &
     -6.960779929147439_REALK,      0.000000000000000_REALK,     -1.002857696650539_REALK, &
      0.000000000000000_REALK,     -2.728522632480671_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.913701618155770_REALK,      0.000000000000000_REALK, &
     -3.074880485076315_REALK,      0.000000000000000_REALK,    -20.693186553196892_REALK, &
     -4.034705518455620_REALK,      0.420365521528788_REALK,      0.000000000000000_REALK, &
      1.153853343310620_REALK,      0.000000000000000_REALK,      3.717490388668696_REALK, &
      1.418713254107921_REALK,      0.000000000000000_REALK,      2.275406947394719_REALK, &
      0.000000000000000_REALK,      2.141995409713568_REALK,      0.000000000000000_REALK, &
      2.315358212388358_REALK,      0.000000000000000_REALK,     10.443485501074145_REALK, &
      4.717943099351699_REALK,      0.000000000000000_REALK,      3.012562460321064_REALK, &
      0.000000000000000_REALK,      6.764388606758646_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.838842685185110_REALK, &
      0.000000000000000_REALK,     -1.298430453847384_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.950572157886208_REALK,      0.000000000000000_REALK, &
     -6.356829297939979_REALK,      0.000000000000000_REALK,      0.208230648100256_REALK, &
      0.000000000000000_REALK,     -3.647659630873833_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.560033768653037_REALK,      0.000000000000000_REALK, &
     -2.825885489217508_REALK,      0.000000000000000_REALK,    -24.297102643925378_REALK, &
   1407.654970549814834_REALK,    -51.115100852026487_REALK,      0.000000000000000_REALK, &
    105.785398441624949_REALK,      0.000000000000000_REALK,    165.248805087973238_REALK, &
    -18.932286813021445_REALK,      0.000000000000000_REALK,     -6.739103414312589_REALK, &
      0.000000000000000_REALK,     30.366991804299285_REALK,      0.000000000000000_REALK, &
     16.413240796305011_REALK,      0.000000000000000_REALK,     76.918037909757714_REALK, &
    -21.045848534121056_REALK,      0.000000000000000_REALK,     -3.873185448350145_REALK, &
      0.000000000000000_REALK,     -4.136076777786252_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,   -129.544750176500941_REALK, &
      0.000000000000000_REALK,     -3.070389510255895_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -11.014570504596096_REALK,      0.000000000000000_REALK, &
    -51.238212602653071_REALK,      0.000000000000000_REALK,     -0.428892870380081_REALK, &
      0.000000000000000_REALK,     -1.429168196537680_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.660658177305963_REALK,      0.000000000000000_REALK, &
     -6.760114288288643_REALK,      0.000000000000000_REALK,    -52.411814117344605_REALK, &
    112.074355677876071_REALK,      9.413890061866832_REALK,      0.000000000000000_REALK, &
      9.161201434887078_REALK,      0.000000000000000_REALK,     39.470226179515628_REALK, &
      1.742252403860687_REALK,      0.000000000000000_REALK,      3.723430704453454_REALK, &
      0.000000000000000_REALK,      2.235146354270666_REALK,      0.000000000000000_REALK, &
      4.264246503279896_REALK,      0.000000000000000_REALK,     30.620214893197350_REALK, &
     -0.556797001778930_REALK,      0.000000000000000_REALK,      1.069295018287756_REALK, &
      0.000000000000000_REALK,      3.808715176581376_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -34.628075102517464_REALK, &
      0.000000000000000_REALK,     -5.522486406687010_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.966541140962521_REALK,      0.000000000000000_REALK, &
    -22.827126941411134_REALK,      0.000000000000000_REALK,     -1.800902933334122_REALK, &
      0.000000000000000_REALK,     -4.284234900211374_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.237269500353869_REALK,      0.000000000000000_REALK, &
     -4.057394011401620_REALK,      0.000000000000000_REALK,    -32.689969119532634_REALK, &
     33.928231583655560_REALK,      7.438826804177176_REALK,      0.000000000000000_REALK, &
      4.142878918645547_REALK,      0.000000000000000_REALK,     19.914680249227690_REALK, &
      1.802349879715232_REALK,      0.000000000000000_REALK,      4.903739039822606_REALK, &
      0.000000000000000_REALK,      0.955029998924218_REALK,      0.000000000000000_REALK, &
      3.213962904303287_REALK,      0.000000000000000_REALK,     21.629176898610996_REALK, &
     -0.483777821135585_REALK,      0.000000000000000_REALK,      1.843632360922009_REALK, &
      0.000000000000000_REALK,      7.022481549845797_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -20.337347960925051_REALK, &
      0.000000000000000_REALK,     -6.509902949882108_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.161194164968359_REALK,      0.000000000000000_REALK, &
    -18.769178218939118_REALK,      0.000000000000000_REALK,     -3.148826122303170_REALK, &
      0.000000000000000_REALK,     -7.070354167561901_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.937799019226591_REALK,      0.000000000000000_REALK, &
     -5.959107736261878_REALK,      0.000000000000000_REALK,    -34.558348817416487_REALK, &
     22.131753989967695_REALK,      7.103349082877603_REALK,      0.000000000000000_REALK, &
      2.719571767935609_REALK,      0.000000000000000_REALK,     18.186787135346563_REALK, &
     -0.374235033355188_REALK,      0.000000000000000_REALK,      6.555624909601202_REALK, &
      0.000000000000000_REALK,     -3.721060550499386_REALK,      0.000000000000000_REALK, &
      2.953705413343441_REALK,      0.000000000000000_REALK,     25.396104648173790_REALK, &
    -10.769886723820045_REALK,      0.000000000000000_REALK,     -0.535929541866038_REALK, &
      0.000000000000000_REALK,     12.070404452419762_REALK,      0.000000000000000_REALK, &
    ! results of test 4, ket-major order, 002DPG Y
    132.035203754609000_REALK,     58.330038025801997_REALK,      0.000000000000000_REALK, &
     48.617512222121384_REALK,      0.000000000000000_REALK,     31.327228101303795_REALK, &
     54.873939073570263_REALK,      0.000000000000000_REALK,     17.601942018569201_REALK, &
      0.000000000000000_REALK,     82.915561664286457_REALK,      0.000000000000000_REALK, &
     17.925269658712374_REALK,      0.000000000000000_REALK,     34.651033282633890_REALK, &
    304.499314809008240_REALK,      0.000000000000000_REALK,     38.886573477885101_REALK, &
      0.000000000000000_REALK,     37.420999287523728_REALK,      0.000000000000000_REALK, &
    115.053958060529951_REALK,     28.549866673409280_REALK,      0.000000000000000_REALK, &
     25.371964920540254_REALK,      0.000000000000000_REALK,     24.445542861588496_REALK, &
     23.580457234970964_REALK,      0.000000000000000_REALK,      7.432352139948203_REALK, &
      0.000000000000000_REALK,     41.072330821198072_REALK,      0.000000000000000_REALK, &
      8.136309713235288_REALK,      0.000000000000000_REALK,     23.517670994692935_REALK, &
    123.953066786884563_REALK,      0.000000000000000_REALK,     13.245541570762084_REALK, &
      0.000000000000000_REALK,     12.524633630796645_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -24.925212650848540_REALK, &
      0.000000000000000_REALK,    -10.730181512759437_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -10.070054675531118_REALK,      0.000000000000000_REALK, &
    -19.466251072556361_REALK,      0.000000000000000_REALK,    -10.727190394268552_REALK, &
      0.000000000000000_REALK,    -10.322899350577773_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -26.164935943686306_REALK,      0.000000000000000_REALK, &
    -16.969559982931191_REALK,      0.000000000000000_REALK,    -54.672611993724729_REALK, &
    117.033930760268248_REALK,      3.152775336843898_REALK,      0.000000000000000_REALK, &
      6.163564113684829_REALK,      0.000000000000000_REALK,     21.426000500129508_REALK, &
     -6.985155155661895_REALK,      0.000000000000000_REALK,      0.697726117693475_REALK, &
      0.000000000000000_REALK,     -9.818226181956458_REALK,      0.000000000000000_REALK, &
      1.687187915839714_REALK,      0.000000000000000_REALK,     17.595187684507962_REALK, &
    -43.121898536043282_REALK,      0.000000000000000_REALK,     -3.083090911158145_REALK, &
      0.000000000000000_REALK,      0.923882005768235_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -21.888152668729617_REALK, &
      0.000000000000000_REALK,     -5.335209458690649_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.027539378864271_REALK,      0.000000000000000_REALK, &
    -14.531897284177735_REALK,      0.000000000000000_REALK,     -4.633497751384850_REALK, &
      0.000000000000000_REALK,     -4.381312870839179_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -11.201795301736299_REALK,      0.000000000000000_REALK, &
     -6.657129563644173_REALK,      0.000000000000000_REALK,    -32.070268619886285_REALK, &
     25.442333618965357_REALK,      9.607634915054490_REALK,      0.000000000000000_REALK, &
      7.228647128498413_REALK,      0.000000000000000_REALK,     13.973574568585159_REALK, &
      6.628480728066416_REALK,      0.000000000000000_REALK,      6.378663647065783_REALK, &
      0.000000000000000_REALK,      9.152904108338685_REALK,      0.000000000000000_REALK, &
      5.936217677687459_REALK,      0.000000000000000_REALK,     19.125335372805353_REALK, &
     22.909252281344337_REALK,      0.000000000000000_REALK,      8.776988441376437_REALK, &
      0.000000000000000_REALK,     14.076995769852651_REALK,      0.000000000000000_REALK, &
    136.627310064683030_REALK,    -17.947471844412689_REALK,      0.000000000000000_REALK, &
      4.353129629901409_REALK,      0.000000000000000_REALK,     22.135482728231615_REALK, &
     -8.956366839786833_REALK,      0.000000000000000_REALK,     -3.402511450930491_REALK, &
      0.000000000000000_REALK,      2.254698458676699_REALK,      0.000000000000000_REALK, &
      1.006985261849750_REALK,      0.000000000000000_REALK,     15.361434255127218_REALK, &
      3.302688207941511_REALK,      0.000000000000000_REALK,     -3.092926845802539_REALK, &
      0.000000000000000_REALK,     -3.524995971463784_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -21.769155004122666_REALK, &
      0.000000000000000_REALK,     -0.587790311941659_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.187213137139290_REALK,      0.000000000000000_REALK, &
    -12.381097430444031_REALK,      0.000000000000000_REALK,      1.361240980351149_REALK, &
      0.000000000000000_REALK,     -0.407910789366998_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.385811045961545_REALK,      0.000000000000000_REALK, &
     -1.229950754328959_REALK,      0.000000000000000_REALK,    -21.377992498590313_REALK, &
     25.187613987171634_REALK,      5.420657097669539_REALK,      0.000000000000000_REALK, &
      4.235385296412046_REALK,      0.000000000000000_REALK,     12.242208255021236_REALK, &
      3.260424846399892_REALK,      0.000000000000000_REALK,      3.082971463548515_REALK, &
      0.000000000000000_REALK,      4.945797337030344_REALK,      0.000000000000000_REALK, &
      2.939244360502991_REALK,      0.000000000000000_REALK,     14.159609675557638_REALK, &
     10.536576513175293_REALK,      0.000000000000000_REALK,      3.377794495203546_REALK, &
      0.000000000000000_REALK,      5.323255163071958_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -14.197372521453929_REALK, &
      0.000000000000000_REALK,     -5.373622399680424_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.177101759504643_REALK,      0.000000000000000_REALK, &
    -13.457807037154229_REALK,      0.000000000000000_REALK,     -3.875200795159789_REALK, &
      0.000000000000000_REALK,     -6.215250887608446_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.672416988447236_REALK,      0.000000000000000_REALK, &
     -7.212450316477002_REALK,      0.000000000000000_REALK,    -32.531951170375159_REALK, &
    200.132699145983707_REALK,    -58.075037550616372_REALK,      0.000000000000000_REALK, &
      3.425333161819806_REALK,      0.000000000000000_REALK,     26.581848307996189_REALK, &
    -21.970988809668565_REALK,      0.000000000000000_REALK,     -9.052147849257995_REALK, &
      0.000000000000000_REALK,     -5.605116514823499_REALK,      0.000000000000000_REALK, &
      0.649232321615084_REALK,      0.000000000000000_REALK,     15.114846592602676_REALK, &
    -29.708838515703388_REALK,      0.000000000000000_REALK,     -5.854928428988851_REALK, &
      0.000000000000000_REALK,     -7.236771851074977_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -27.472287404423337_REALK, &
      0.000000000000000_REALK,      3.486623845978115_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.842111432207224_REALK,      0.000000000000000_REALK, &
    -12.846304599910271_REALK,      0.000000000000000_REALK,      1.739541073392732_REALK, &
      0.000000000000000_REALK,      1.982547787778050_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.502466259829903_REALK,      0.000000000000000_REALK, &
     -0.673228984938111_REALK,      0.000000000000000_REALK,    -17.116706640068493_REALK, &
     31.840234999290018_REALK,      0.729504957332681_REALK,      0.000000000000000_REALK, &
      1.216561852591660_REALK,      0.000000000000000_REALK,     12.687166571786033_REALK, &
     -1.138364815227763_REALK,      0.000000000000000_REALK,      0.341123502061618_REALK, &
      0.000000000000000_REALK,     -1.341841082803658_REALK,      0.000000000000000_REALK, &
      0.691755725910303_REALK,      0.000000000000000_REALK,     12.023529126932912_REALK, &
     -4.242921474235165_REALK,      0.000000000000000_REALK,     -0.910069807550671_REALK, &
      0.000000000000000_REALK,      0.454520665255151_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -15.193771365907580_REALK, &
      0.000000000000000_REALK,     -3.159184612983068_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.458001493967739_REALK,      0.000000000000000_REALK, &
    -11.841254917153153_REALK,      0.000000000000000_REALK,     -1.899757916958365_REALK, &
      0.000000000000000_REALK,     -2.993934697447022_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.306556954768385_REALK,      0.000000000000000_REALK, &
     -3.275096753769153_REALK,      0.000000000000000_REALK,    -22.088578013013375_REALK, &
     20.765513285653324_REALK,      6.669188143730232_REALK,      0.000000000000000_REALK, &
      4.280362553308436_REALK,      0.000000000000000_REALK,     13.790493171590086_REALK, &
      3.240713658219856_REALK,      0.000000000000000_REALK,      5.197627040615130_REALK, &
      0.000000000000000_REALK,      3.752737775211003_REALK,      0.000000000000000_REALK, &
      4.056466315180720_REALK,      0.000000000000000_REALK,     18.296800435249367_REALK, &
      6.762375620957928_REALK,      0.000000000000000_REALK,      4.318000134653503_REALK, &
      0.000000000000000_REALK,      9.695610066029815_REALK,      0.000000000000000_REALK, &
    311.161184202617562_REALK,   -143.217097742919776_REALK,      0.000000000000000_REALK, &
     16.155613036472989_REALK,      0.000000000000000_REALK,     36.528137189156226_REALK, &
    -35.977835935538728_REALK,      0.000000000000000_REALK,    -18.881990180969904_REALK, &
      0.000000000000000_REALK,      8.499151706440232_REALK,      0.000000000000000_REALK, &
      2.506640527765094_REALK,      0.000000000000000_REALK,     17.002680531290789_REALK, &
    -15.598353886352442_REALK,      0.000000000000000_REALK,     -7.360380285006814_REALK, &
      0.000000000000000_REALK,    -11.588687144944762_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -39.201230279273020_REALK, &
      0.000000000000000_REALK,     11.337597624103386_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.665993881991151_REALK,      0.000000000000000_REALK, &
    -15.505074258881908_REALK,      0.000000000000000_REALK,      4.269604216419266_REALK, &
      0.000000000000000_REALK,      5.277289378232434_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.176305067757191_REALK,      0.000000000000000_REALK, &
     -0.408749007115852_REALK,      0.000000000000000_REALK,    -15.860215035878614_REALK, &
     45.686117461895179_REALK,     -5.141852541618689_REALK,      0.000000000000000_REALK, &
      1.054724329740762_REALK,      0.000000000000000_REALK,     16.089687766466351_REALK, &
     -1.784451688218233_REALK,      0.000000000000000_REALK,     -2.033732230291037_REALK, &
      0.000000000000000_REALK,      0.366414737190677_REALK,      0.000000000000000_REALK, &
      0.490940469652135_REALK,      0.000000000000000_REALK,     12.482059128136825_REALK, &
      0.389823430057234_REALK,      0.000000000000000_REALK,     -1.095194528851693_REALK, &
      0.000000000000000_REALK,     -2.080314480231250_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -18.710231606523337_REALK, &
      0.000000000000000_REALK,     -0.427248987853932_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.709615134598538_REALK,      0.000000000000000_REALK, &
    -12.333946681150080_REALK,      0.000000000000000_REALK,      0.663652499715571_REALK, &
      0.000000000000000_REALK,     -0.331451250405503_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.844807308636175_REALK,      0.000000000000000_REALK, &
     -0.725868734295139_REALK,      0.000000000000000_REALK,    -17.663034737731792_REALK, &
     25.267077804386552_REALK,      4.658965850430772_REALK,      0.000000000000000_REALK, &
      3.078587796191987_REALK,      0.000000000000000_REALK,     14.830887193929637_REALK, &
      1.948804931354990_REALK,      0.000000000000000_REALK,      3.071230629153597_REALK, &
      0.000000000000000_REALK,      2.411248862754703_REALK,      0.000000000000000_REALK, &
      2.388307061080294_REALK,      0.000000000000000_REALK,     16.107709421711089_REALK, &
      3.730964722207188_REALK,      0.000000000000000_REALK,      1.993441937665357_REALK, &
      0.000000000000000_REALK,      4.398207215637774_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -20.337347960925044_REALK, &
      0.000000000000000_REALK,     -6.509902949882108_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.161194164968359_REALK,      0.000000000000000_REALK, &
    -18.769178218939114_REALK,      0.000000000000000_REALK,     -3.148826122303170_REALK, &
      0.000000000000000_REALK,     -7.070354167561901_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.937799019226591_REALK,      0.000000000000000_REALK, &
     -5.959107736261879_REALK,      0.000000000000000_REALK,    -34.558348817416480_REALK, &
    858.577094934390630_REALK,   -510.791085700966278_REALK,      0.000000000000000_REALK, &
     70.886631050697616_REALK,      0.000000000000000_REALK,     69.744944872774994_REALK, &
    -95.147433939929471_REALK,      0.000000000000000_REALK,    -47.773606783780899_REALK, &
      0.000000000000000_REALK,     23.082555597521466_REALK,      0.000000000000000_REALK, &
      7.895149472603569_REALK,      0.000000000000000_REALK,     23.303975230614466_REALK, &
    -52.625999436739598_REALK,      0.000000000000000_REALK,    -13.634359751065132_REALK, &
      0.000000000000000_REALK,    -20.537470571425818_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -89.596551152175110_REALK, &
      0.000000000000000_REALK,     36.251800678638567_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.706226277815896_REALK,      0.000000000000000_REALK, &
    -25.139536634941091_REALK,      0.000000000000000_REALK,      7.693303629975082_REALK, &
      0.000000000000000_REALK,     12.112864475285271_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.800748757957467_REALK,      0.000000000000000_REALK, &
     -1.593275413685753_REALK,      0.000000000000000_REALK,    -18.012124566189971_REALK, &
    122.152110436428742_REALK,    -27.808963819055961_REALK,      0.000000000000000_REALK, &
      1.278651097248678_REALK,      0.000000000000000_REALK,     29.768411918091786_REALK, &
     -6.312879396741950_REALK,      0.000000000000000_REALK,     -7.802805528993140_REALK, &
      0.000000000000000_REALK,     -1.229511478662152_REALK,      0.000000000000000_REALK, &
      0.427237465786753_REALK,      0.000000000000000_REALK,     16.577601317184843_REALK, &
     -4.590175005725617_REALK,      0.000000000000000_REALK,     -2.713853601599209_REALK, &
      0.000000000000000_REALK,     -5.590600463122244_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -39.464934264939124_REALK, &
      0.000000000000000_REALK,      3.904591345489549_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.725886480057158_REALK,      0.000000000000000_REALK, &
    -18.455512479565151_REALK,      0.000000000000000_REALK,      1.144732163025158_REALK, &
      0.000000000000000_REALK,      2.174410875869301_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.232901202031767_REALK,      0.000000000000000_REALK, &
     -0.520087457838434_REALK,      0.000000000000000_REALK,    -18.512361319893195_REALK, &
     58.301595669552590_REALK,      1.047960250388397_REALK,      0.000000000000000_REALK, &
      1.362400158641015_REALK,      0.000000000000000_REALK,     23.680119117774105_REALK, &
     -0.981252120732710_REALK,      0.000000000000000_REALK,      0.490071600000450_REALK, &
      0.000000000000000_REALK,     -0.883019474876786_REALK,      0.000000000000000_REALK, &
      0.758701093177694_REALK,      0.000000000000000_REALK,     18.461965822740389_REALK, &
     -1.966662421891349_REALK,      0.000000000000000_REALK,     -0.703053349237559_REALK, &
      0.000000000000000_REALK,      0.491581176186350_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -36.377336632910016_REALK, &
      0.000000000000000_REALK,     -5.896499232290506_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.531262776302863_REALK,      0.000000000000000_REALK, &
    -23.816265345153194_REALK,      0.000000000000000_REALK,     -2.083608930699599_REALK, &
      0.000000000000000_REALK,     -4.597146102134770_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.554403983306768_REALK,      0.000000000000000_REALK, &
     -3.542140187263338_REALK,      0.000000000000000_REALK,    -30.715234723291399_REALK, &
     63.371734927934121_REALK,     15.967549881463885_REALK,      0.000000000000000_REALK, &
      7.989135679435996_REALK,      0.000000000000000_REALK,     36.035211393160175_REALK, &
      4.655738223924065_REALK,      0.000000000000000_REALK,     10.453965025709801_REALK, &
      0.000000000000000_REALK,      4.115912808260587_REALK,      0.000000000000000_REALK, &
      6.228648983284654_REALK,      0.000000000000000_REALK,     36.121485590160532_REALK, &
      5.224116644318165_REALK,      0.000000000000000_REALK,      4.670079376422218_REALK, &
      0.000000000000000_REALK,     13.482214146522400_REALK,      0.000000000000000_REALK, &
    ! results of test 4, ket-major order, 003DPG Y
      0.000000000000000_REALK,      0.000000000000000_REALK,    -23.279609396396456_REALK, &
      0.000000000000000_REALK,    -10.941851289069065_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -7.353372998503337_REALK,      0.000000000000000_REALK, &
    -21.074887760010604_REALK,      0.000000000000000_REALK,      1.612100666943999_REALK, &
      0.000000000000000_REALK,    -12.102776918695309_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     45.953408950639492_REALK,      0.000000000000000_REALK, &
    -15.632966262904283_REALK,      0.000000000000000_REALK,    -74.673896685189504_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -24.925212650848547_REALK, &
      0.000000000000000_REALK,    -10.730181512759437_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -10.070054675531118_REALK,      0.000000000000000_REALK, &
    -19.466251072556368_REALK,      0.000000000000000_REALK,    -10.727190394268552_REALK, &
      0.000000000000000_REALK,    -10.322899350577771_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -26.164935943686306_REALK,      0.000000000000000_REALK, &
    -16.969559982931191_REALK,      0.000000000000000_REALK,    -54.672611993724743_REALK, &
    -19.283228886788297_REALK,     -8.329042752335328_REALK,      0.000000000000000_REALK, &
     -4.288648562004498_REALK,      0.000000000000000_REALK,      4.467752044393709_REALK, &
      0.866454315102108_REALK,      0.000000000000000_REALK,      2.364440929482369_REALK, &
      0.000000000000000_REALK,     12.128062510620159_REALK,      0.000000000000000_REALK, &
      1.499702143677329_REALK,      0.000000000000000_REALK,     12.537941518557989_REALK, &
     68.464374581490929_REALK,      0.000000000000000_REALK,     -0.530730871798105_REALK, &
      0.000000000000000_REALK,     11.622773500144872_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -29.391064468647869_REALK, &
      0.000000000000000_REALK,     -8.518564076518835_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.765597827393652_REALK,      0.000000000000000_REALK, &
    -19.513201337508118_REALK,      0.000000000000000_REALK,     -4.285284781716332_REALK, &
      0.000000000000000_REALK,     -6.995506871567102_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.436726013732431_REALK,      0.000000000000000_REALK, &
     -8.958549683730880_REALK,      0.000000000000000_REALK,    -43.063448377740123_REALK, &
    -24.341331082262929_REALK,     -9.191869971020395_REALK,      0.000000000000000_REALK, &
     -6.915831529717378_REALK,      0.000000000000000_REALK,      4.859424357124280_REALK, &
     -6.341636989383411_REALK,      0.000000000000000_REALK,      2.218232231152941_REALK, &
      0.000000000000000_REALK,     -8.756817381688615_REALK,      0.000000000000000_REALK, &
      2.064368042018250_REALK,      0.000000000000000_REALK,     11.640728828785029_REALK, &
    -21.917867400795714_REALK,      0.000000000000000_REALK,      3.052269210350047_REALK, &
      0.000000000000000_REALK,      8.568032261217924_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.502557240912811_REALK, &
      0.000000000000000_REALK,      1.486073948941907_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.811371553653690_REALK,      0.000000000000000_REALK, &
     -2.766065077899826_REALK,      0.000000000000000_REALK,     -0.162555004085948_REALK, &
      0.000000000000000_REALK,     -1.451634081126656_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.158112883618463_REALK,      0.000000000000000_REALK, &
     -1.277954077003549_REALK,      0.000000000000000_REALK,    -17.340697668166406_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -40.289396211337241_REALK, &
      0.000000000000000_REALK,     -7.597593206680443_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.636174345715366_REALK,      0.000000000000000_REALK, &
    -22.914391477843793_REALK,      0.000000000000000_REALK,     -3.693895337604618_REALK, &
      0.000000000000000_REALK,     -5.272526918636875_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.318248235037301_REALK,      0.000000000000000_REALK, &
     -6.875065131134470_REALK,      0.000000000000000_REALK,    -39.565449821804542_REALK, &
    -32.357921379183082_REALK,     -8.280455658946348_REALK,      0.000000000000000_REALK, &
     -5.452943554429630_REALK,      0.000000000000000_REALK,      5.716672049770021_REALK, &
     -2.884910248085150_REALK,      0.000000000000000_REALK,      1.711834340458382_REALK, &
      0.000000000000000_REALK,     -1.874125520479236_REALK,      0.000000000000000_REALK, &
      1.375509835439583_REALK,      0.000000000000000_REALK,     11.572537609334477_REALK, &
      1.307108735758676_REALK,      0.000000000000000_REALK,      1.086378757184719_REALK, &
      0.000000000000000_REALK,      5.173248221391359_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.322868685760643_REALK, &
      0.000000000000000_REALK,      1.636180495058361_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.271859449071433_REALK,      0.000000000000000_REALK, &
     -2.924512989754470_REALK,      0.000000000000000_REALK,      1.179935522795978_REALK, &
      0.000000000000000_REALK,     -1.350634758338569_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.031642292551609_REALK,      0.000000000000000_REALK, &
     -1.567335939671491_REALK,      0.000000000000000_REALK,    -14.344493847160939_REALK, &
    -12.664454152142460_REALK,     -4.744213193222041_REALK,      0.000000000000000_REALK, &
     -2.147734215841617_REALK,      0.000000000000000_REALK,     -1.866199322877698_REALK, &
      0.359408956630369_REALK,      0.000000000000000_REALK,     -0.818051383787497_REALK, &
      0.000000000000000_REALK,      4.381266273600761_REALK,      0.000000000000000_REALK, &
     -0.451878961726526_REALK,      0.000000000000000_REALK,      2.802545157445457_REALK, &
     17.459353122215003_REALK,      0.000000000000000_REALK,      0.112887730604289_REALK, &
      0.000000000000000_REALK,      1.833966657642460_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -67.393315100942559_REALK, &
      0.000000000000000_REALK,     -6.383437352092654_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -7.314472837625563_REALK,      0.000000000000000_REALK, &
    -31.513759340077545_REALK,      0.000000000000000_REALK,     -1.698403849621194_REALK, &
      0.000000000000000_REALK,     -3.629720371301132_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.065066753083098_REALK,      0.000000000000000_REALK, &
     -5.847581371654254_REALK,      0.000000000000000_REALK,    -41.989645314310351_REALK, &
    -56.378411100912444_REALK,     -9.021302399463247_REALK,      0.000000000000000_REALK, &
     -6.505949206598804_REALK,      0.000000000000000_REALK,      8.165657095783326_REALK, &
     -2.955414606197464_REALK,      0.000000000000000_REALK,      1.533354471346072_REALK, &
      0.000000000000000_REALK,     -3.399766612505724_REALK,      0.000000000000000_REALK, &
      1.344680681637841_REALK,      0.000000000000000_REALK,     13.544165753634582_REALK, &
     -4.380355936834670_REALK,      0.000000000000000_REALK,      0.858818886858526_REALK, &
      0.000000000000000_REALK,      3.575842317402345_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.212063100828304_REALK, &
      0.000000000000000_REALK,      1.535868350824011_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.007156373014169_REALK,      0.000000000000000_REALK, &
     -3.455279587917683_REALK,      0.000000000000000_REALK,      0.534974474136520_REALK, &
      0.000000000000000_REALK,     -1.038810908177024_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.398763180329914_REALK,      0.000000000000000_REALK, &
     -0.957754253666037_REALK,      0.000000000000000_REALK,    -13.078233327978623_REALK, &
    -19.866897492548961_REALK,     -6.380582814755248_REALK,      0.000000000000000_REALK, &
     -4.095132294961153_REALK,      0.000000000000000_REALK,     -2.400033178726783_REALK, &
     -3.100473615310954_REALK,      0.000000000000000_REALK,     -0.904570793292773_REALK, &
      0.000000000000000_REALK,     -3.590340179457190_REALK,      0.000000000000000_REALK, &
     -0.705968497550023_REALK,      0.000000000000000_REALK,      2.953164482182074_REALK, &
     -6.469737656834251_REALK,      0.000000000000000_REALK,     -0.751484624949072_REALK, &
      0.000000000000000_REALK,      1.564903731743413_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.524318901081248_REALK, &
      0.000000000000000_REALK,      2.723262004761177_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.227642496396067_REALK,      0.000000000000000_REALK, &
      1.715310428099051_REALK,      0.000000000000000_REALK,     -0.206260052731667_REALK, &
      0.000000000000000_REALK,      0.754918615993907_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.884971316125021_REALK,      0.000000000000000_REALK, &
      0.478472846005093_REALK,      0.000000000000000_REALK,     -4.539340535284643_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,   -129.544750176500941_REALK, &
      0.000000000000000_REALK,     -3.070389510255895_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -11.014570504596096_REALK,      0.000000000000000_REALK, &
    -51.238212602653071_REALK,      0.000000000000000_REALK,     -0.428892870380081_REALK, &
      0.000000000000000_REALK,     -1.429168196537680_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.660658177305963_REALK,      0.000000000000000_REALK, &
     -6.760114288288643_REALK,      0.000000000000000_REALK,    -52.411814117344612_REALK, &
   -107.224401591563364_REALK,     -9.006509316311829_REALK,      0.000000000000000_REALK, &
     -8.764755646143318_REALK,      0.000000000000000_REALK,     13.726092599752224_REALK, &
     -1.666857420642770_REALK,      0.000000000000000_REALK,      1.294853351121991_REALK, &
      0.000000000000000_REALK,     -2.138421665301145_REALK,      0.000000000000000_REALK, &
      1.482926449571913_REALK,      0.000000000000000_REALK,     18.637143417503964_REALK, &
      0.532701927774793_REALK,      0.000000000000000_REALK,      0.371856050956423_REALK, &
      0.000000000000000_REALK,      2.318193103149675_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     10.543684846096488_REALK, &
      0.000000000000000_REALK,      1.681507160492630_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.207747170339952_REALK,      0.000000000000000_REALK, &
     -4.960557769525553_REALK,      0.000000000000000_REALK,      0.548345610065552_REALK, &
      0.000000000000000_REALK,     -0.931006112826316_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.681212122177707_REALK,      0.000000000000000_REALK, &
     -0.881711370815225_REALK,      0.000000000000000_REALK,    -14.414169578799639_REALK, &
    -32.460006632325339_REALK,     -7.116915799308345_REALK,      0.000000000000000_REALK, &
     -3.963598186500770_REALK,      0.000000000000000_REALK,     -3.465858163821591_REALK, &
     -1.724354212363689_REALK,      0.000000000000000_REALK,     -0.853423894921885_REALK, &
      0.000000000000000_REALK,     -0.913701618155770_REALK,      0.000000000000000_REALK, &
     -0.559343129324473_REALK,      0.000000000000000_REALK,      3.491021133550472_REALK, &
      0.462842610700579_REALK,      0.000000000000000_REALK,     -0.320857186217440_REALK, &
      0.000000000000000_REALK,      1.133451893033170_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     11.498339031063209_REALK, &
      0.000000000000000_REALK,      3.680571887784048_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.352657847759607_REALK,      0.000000000000000_REALK, &
      2.217182301582992_REALK,      0.000000000000000_REALK,      1.780284743796216_REALK, &
      0.000000000000000_REALK,      0.835213132049841_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.226354598753497_REALK,      0.000000000000000_REALK, &
      0.703942817951085_REALK,      0.000000000000000_REALK,     -4.504480053814796_REALK, &
    -21.174014906377305_REALK,     -6.795955685854408_REALK,      0.000000000000000_REALK, &
     -2.601883844332192_REALK,      0.000000000000000_REALK,     -7.232178141143692_REALK, &
      0.358040224843604_REALK,      0.000000000000000_REALK,     -2.606917143743841_REALK, &
      0.000000000000000_REALK,      3.560033768653035_REALK,      0.000000000000000_REALK, &
     -1.174573802771523_REALK,      0.000000000000000_REALK,     -2.211232736325744_REALK, &
     10.303825992893824_REALK,      0.000000000000000_REALK,      0.213118341850701_REALK, &
      0.000000000000000_REALK,     -1.050967218620352_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,   -405.323790294339233_REALK, &
      0.000000000000000_REALK,     12.938500199762496_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -24.268012772306946_REALK,      0.000000000000000_REALK, &
   -113.728175293389626_REALK,      0.000000000000000_REALK,      4.048376648426292_REALK, &
      0.000000000000000_REALK,      4.323159029325773_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.433974196867230_REALK,      0.000000000000000_REALK, &
    -10.432613982736747_REALK,      0.000000000000000_REALK,    -81.484638711393771_REALK, &
   -386.196626625272017_REALK,     -7.205176460211319_REALK,      0.000000000000000_REALK, &
    -20.231904372733844_REALK,      0.000000000000000_REALK,     34.210001776921082_REALK, &
     -0.606702914345675_REALK,      0.000000000000000_REALK,      0.734853092899683_REALK, &
      0.000000000000000_REALK,     -4.660658177305963_REALK,      0.000000000000000_REALK, &
      2.457219579849108_REALK,      0.000000000000000_REALK,     33.343633572278264_REALK, &
     -0.905619680297049_REALK,      0.000000000000000_REALK,      0.094803622777822_REALK, &
      0.000000000000000_REALK,      0.921514139124089_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     29.477961546151906_REALK, &
      0.000000000000000_REALK,      2.176652787062037_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.919756918191883_REALK,      0.000000000000000_REALK, &
     -9.838465472831022_REALK,      0.000000000000000_REALK,      0.340309621977998_REALK, &
      0.000000000000000_REALK,     -0.865108090994323_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.432582382482802_REALK,      0.000000000000000_REALK, &
     -0.981678109419486_REALK,      0.000000000000000_REALK,    -20.024373334640586_REALK, &
   -103.232634073539515_REALK,    -12.959427110595481_REALK,      0.000000000000000_REALK, &
     -7.285865665028133_REALK,      0.000000000000000_REALK,     -7.627294544649653_REALK, &
     -2.547519750419777_REALK,      0.000000000000000_REALK,     -1.102428917467203_REALK, &
      0.000000000000000_REALK,     -2.237269500353869_REALK,      0.000000000000000_REALK, &
     -0.738069487336004_REALK,      0.000000000000000_REALK,      5.514925057966489_REALK, &
     -2.030365508245546_REALK,      0.000000000000000_REALK,     -0.332028451829651_REALK, &
      0.000000000000000_REALK,      1.025560635144246_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     27.617088757281426_REALK, &
      0.000000000000000_REALK,      5.322920219994905_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.686714530854644_REALK,      0.000000000000000_REALK, &
      3.777774332908693_REALK,      0.000000000000000_REALK,      1.089501249699783_REALK, &
      0.000000000000000_REALK,      0.867080404598376_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.572012278365631_REALK,      0.000000000000000_REALK, &
      0.563083222730614_REALK,      0.000000000000000_REALK,     -5.375906775384721_REALK, &
    -60.629359092610606_REALK,    -15.276563229543335_REALK,      0.000000000000000_REALK, &
     -7.643410370553079_REALK,      0.000000000000000_REALK,    -14.329802521446787_REALK, &
     -4.454263796635606_REALK,      0.000000000000000_REALK,     -4.157135440392252_REALK, &
      0.000000000000000_REALK,     -3.937799019226590_REALK,      0.000000000000000_REALK, &
     -2.476891530677156_REALK,      0.000000000000000_REALK,     -3.145089080715582_REALK, &
     -4.998045963712977_REALK,      0.000000000000000_REALK,     -1.857108995239973_REALK, &
      0.000000000000000_REALK,     -1.173893149833440_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     30.208727523567351_REALK, &
      0.000000000000000_REALK,      8.523316069109530_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.957465816712426_REALK,      0.000000000000000_REALK, &
     11.433285471643517_REALK,      0.000000000000000_REALK,     -0.379343806355558_REALK, &
      0.000000000000000_REALK,      3.841479391629507_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.737274525228956_REALK,      0.000000000000000_REALK, &
      1.714949344254524_REALK,      0.000000000000000_REALK,      3.983673442567496_REALK, &
    ! results of test 4, ket-major order, 001DPG Z
      0.000000000000000_REALK,      0.000000000000000_REALK,     40.450589160619927_REALK, &
      0.000000000000000_REALK,     33.544811693933106_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     23.757785071702841_REALK,      0.000000000000000_REALK, &
     15.547639797720844_REALK,      0.000000000000000_REALK,     35.171184202552809_REALK, &
      0.000000000000000_REALK,     16.025286580774761_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,   -140.452772625661964_REALK,      0.000000000000000_REALK, &
    -51.713672827213898_REALK,      0.000000000000000_REALK,    -56.404357231962358_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     24.088107280132753_REALK, &
      0.000000000000000_REALK,     11.773339095620512_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.389622697376290_REALK,      0.000000000000000_REALK, &
      6.483814656941637_REALK,      0.000000000000000_REALK,      2.774822593312539_REALK, &
      0.000000000000000_REALK,      2.291265261480000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -21.840695517316966_REALK,      0.000000000000000_REALK, &
    -16.632911313220543_REALK,      0.000000000000000_REALK,    -33.349494085108333_REALK, &
    -39.773231224138449_REALK,    -25.177656045159491_REALK,      0.000000000000000_REALK, &
    -22.218730091803508_REALK,      0.000000000000000_REALK,    -14.540446897198144_REALK, &
    -14.873884261603534_REALK,      0.000000000000000_REALK,     -6.777089349302360_REALK, &
      0.000000000000000_REALK,    -11.744103895082965_REALK,      0.000000000000000_REALK, &
     -4.324092256247593_REALK,      0.000000000000000_REALK,     -4.716308685717682_REALK, &
    148.003008230103262_REALK,      0.000000000000000_REALK,     45.902285131534846_REALK, &
      0.000000000000000_REALK,     34.857952166605877_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     17.647635308657215_REALK, &
      0.000000000000000_REALK,      5.496747712991643_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.435326786511525_REALK,      0.000000000000000_REALK, &
      2.331121360944660_REALK,      0.000000000000000_REALK,     -1.099363978721219_REALK, &
      0.000000000000000_REALK,     -0.992039322362549_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -14.228884723745866_REALK,      0.000000000000000_REALK, &
     -9.846616594763036_REALK,      0.000000000000000_REALK,    -26.653231506570663_REALK, &
    -24.333922716656865_REALK,    -10.014178346338221_REALK,      0.000000000000000_REALK, &
     -5.539863854521206_REALK,      0.000000000000000_REALK,     -6.664557516223103_REALK, &
     -1.601966892998872_REALK,      0.000000000000000_REALK,     -1.322798473969300_REALK, &
      0.000000000000000_REALK,      1.312865896101081_REALK,      0.000000000000000_REALK, &
      0.999820816085607_REALK,      0.000000000000000_REALK,      2.004671206640312_REALK, &
     13.131438069508324_REALK,      0.000000000000000_REALK,     10.989799633852938_REALK, &
      0.000000000000000_REALK,     15.124418039288484_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     12.367827621491610_REALK, &
      0.000000000000000_REALK,      6.966007535803493_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.496394779787356_REALK,      0.000000000000000_REALK, &
      2.722830061241236_REALK,      0.000000000000000_REALK,     -2.759231941790421_REALK, &
      0.000000000000000_REALK,     -2.095346119869426_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -46.513009154951945_REALK,      0.000000000000000_REALK, &
    -28.542910340156446_REALK,      0.000000000000000_REALK,    -43.584649717363916_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     14.600440281539338_REALK, &
      0.000000000000000_REALK,      2.186462581938514_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.494536814314225_REALK,      0.000000000000000_REALK, &
     -1.172679564075390_REALK,      0.000000000000000_REALK,     -1.794368549577246_REALK, &
      0.000000000000000_REALK,     -2.237814375269032_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.628039477241498_REALK,      0.000000000000000_REALK, &
     -6.381966003389985_REALK,      0.000000000000000_REALK,    -25.222258128471875_REALK, &
    -22.126535128620258_REALK,     -5.751934634413436_REALK,      0.000000000000000_REALK, &
     -1.988362596438445_REALK,      0.000000000000000_REALK,     -3.229309565890854_REALK, &
      0.511964635415871_REALK,      0.000000000000000_REALK,      0.461984438113324_REALK, &
      0.000000000000000_REALK,      2.940772496232183_REALK,      0.000000000000000_REALK, &
      2.035061765206252_REALK,      0.000000000000000_REALK,      5.508589862944483_REALK, &
     13.141520759293124_REALK,      0.000000000000000_REALK,      6.606870921617566_REALK, &
      0.000000000000000_REALK,      9.936466112649144_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.973960094621198_REALK, &
      0.000000000000000_REALK,      1.832476780189521_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.465608214836980_REALK,      0.000000000000000_REALK, &
     -0.933558660554004_REALK,      0.000000000000000_REALK,     -2.271330545562895_REALK, &
      0.000000000000000_REALK,     -3.125857961111404_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -7.889957903680951_REALK,      0.000000000000000_REALK, &
    -10.014407124605016_REALK,      0.000000000000000_REALK,    -28.110868075355711_REALK, &
    -15.506733199399747_REALK,     -7.289404953782353_REALK,      0.000000000000000_REALK, &
     -3.458263339554496_REALK,      0.000000000000000_REALK,     -3.771944828946314_REALK, &
      1.284951301342190_REALK,      0.000000000000000_REALK,      0.975785211351773_REALK, &
      0.000000000000000_REALK,      9.613134177101472_REALK,      0.000000000000000_REALK, &
      5.899141592641695_REALK,      0.000000000000000_REALK,      9.007911838152497_REALK, &
     53.466131773495441_REALK,      0.000000000000000_REALK,     27.637024126468887_REALK, &
      0.000000000000000_REALK,     29.382373604584014_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.527158156089253_REALK, &
      0.000000000000000_REALK,     -0.616492137384812_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.179027477394831_REALK,      0.000000000000000_REALK, &
     -6.748357211337580_REALK,      0.000000000000000_REALK,     -2.216153612103001_REALK, &
      0.000000000000000_REALK,     -3.006182141616757_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.000146883384657_REALK,      0.000000000000000_REALK, &
     -5.514148098100527_REALK,      0.000000000000000_REALK,    -28.461811112396486_REALK, &
    -14.471952381077795_REALK,     -1.696809754790899_REALK,      0.000000000000000_REALK, &
      0.497969785155871_REALK,      0.000000000000000_REALK,      1.180820059653353_REALK, &
      1.406677913619094_REALK,      0.000000000000000_REALK,      1.754312990612715_REALK, &
      0.000000000000000_REALK,      2.141378260896220_REALK,      0.000000000000000_REALK, &
      2.428235145951097_REALK,      0.000000000000000_REALK,      9.596662472860809_REALK, &
      3.001750400785303_REALK,      0.000000000000000_REALK,      3.559675324193847_REALK, &
      0.000000000000000_REALK,      7.398974803372297_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.506113764720835_REALK, &
      0.000000000000000_REALK,     -0.465191437186864_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.595367037970415_REALK,      0.000000000000000_REALK, &
     -4.318405880004785_REALK,      0.000000000000000_REALK,     -2.513807840422892_REALK, &
      0.000000000000000_REALK,     -3.780665116121008_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.833915942949377_REALK,      0.000000000000000_REALK, &
     -6.728605772879260_REALK,      0.000000000000000_REALK,    -25.498578107218403_REALK, &
     -6.912587322760786_REALK,     -1.422098188068071_REALK,      0.000000000000000_REALK, &
      0.468840369408491_REALK,      0.000000000000000_REALK,      0.940039228972539_REALK, &
      1.780587668973847_REALK,      0.000000000000000_REALK,      2.450486192505870_REALK, &
      0.000000000000000_REALK,      3.002001745483443_REALK,      0.000000000000000_REALK, &
      3.810320414259812_REALK,      0.000000000000000_REALK,     10.695731974679125_REALK, &
      5.383957168456799_REALK,      0.000000000000000_REALK,      7.509790652198012_REALK, &
      0.000000000000000_REALK,     14.469208156089746_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.927227217679949_REALK, &
      0.000000000000000_REALK,     -0.982558907629420_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.624575140728975_REALK,      0.000000000000000_REALK, &
     -7.061665583440170_REALK,      0.000000000000000_REALK,    -10.515441993539762_REALK, &
      0.000000000000000_REALK,    -11.179519323703435_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -31.784288430652285_REALK,      0.000000000000000_REALK, &
    -27.306393543176551_REALK,      0.000000000000000_REALK,    -53.609791868576266_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.542563021201498_REALK, &
      0.000000000000000_REALK,     -2.834069537491897_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.559852396830057_REALK,      0.000000000000000_REALK, &
    -18.000886027401670_REALK,      0.000000000000000_REALK,     -1.957545065921382_REALK, &
      0.000000000000000_REALK,     -3.412159551898129_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.707023173704343_REALK,      0.000000000000000_REALK, &
     -5.809563045465269_REALK,      0.000000000000000_REALK,    -38.223928155775916_REALK, &
    -15.306948749451635_REALK,      0.930912429475754_REALK,      0.000000000000000_REALK, &
      2.732389036959765_REALK,      0.000000000000000_REALK,      8.462094880874270_REALK, &
      2.228828440570373_REALK,      0.000000000000000_REALK,      3.023375373520258_REALK, &
      0.000000000000000_REALK,      2.983085484039782_REALK,      0.000000000000000_REALK, &
      3.289738388076036_REALK,      0.000000000000000_REALK,     16.980304290861074_REALK, &
      4.135980378909412_REALK,      0.000000000000000_REALK,      2.839679493139128_REALK, &
      0.000000000000000_REALK,      6.419977488300431_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.783056107039151_REALK, &
      0.000000000000000_REALK,     -2.199818787359754_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.442122930527621_REALK,      0.000000000000000_REALK, &
     -9.651548582757924_REALK,      0.000000000000000_REALK,     -2.123700770228028_REALK, &
      0.000000000000000_REALK,     -4.414225191275854_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.743865723617676_REALK,      0.000000000000000_REALK, &
     -5.185718708621530_REALK,      0.000000000000000_REALK,    -28.692373179899501_REALK, &
     -5.877129684852171_REALK,      0.702446089255850_REALK,      0.000000000000000_REALK, &
      2.000508690091874_REALK,      0.000000000000000_REALK,      5.415060161505997_REALK, &
      2.528185040181647_REALK,      0.000000000000000_REALK,      3.802287841900354_REALK, &
      0.000000000000000_REALK,      3.480511747034960_REALK,      0.000000000000000_REALK, &
      4.014283315476410_REALK,      0.000000000000000_REALK,     15.212440752102248_REALK, &
      6.406950149061164_REALK,      0.000000000000000_REALK,      5.368467040639321_REALK, &
      0.000000000000000_REALK,     11.303539609394514_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.419473419657113_REALK, &
      0.000000000000000_REALK,     -3.072784385275139_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.832112747333077_REALK,      0.000000000000000_REALK, &
    -10.756903983411586_REALK,      0.000000000000000_REALK,     -4.480337879111489_REALK, &
      0.000000000000000_REALK,     -8.632323374221336_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.411049869212913_REALK,      0.000000000000000_REALK, &
    -11.392203859425816_REALK,      0.000000000000000_REALK,    -41.115088665429333_REALK, &
     -6.864689950438241_REALK,      1.483678775992904_REALK,      0.000000000000000_REALK, &
      5.798980759174197_REALK,      0.000000000000000_REALK,      8.854967559168498_REALK, &
     10.575582871319545_REALK,      0.000000000000000_REALK,     11.243458253298277_REALK, &
      0.000000000000000_REALK,     18.962492832576729_REALK,      0.000000000000000_REALK, &
     16.290982665090873_REALK,      0.000000000000000_REALK,     31.983578813846840_REALK, &
     43.444342960799808_REALK,      0.000000000000000_REALK,     31.439366205018484_REALK, &
      0.000000000000000_REALK,     42.974798669142679_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,   -165.807060800342100_REALK, &
      0.000000000000000_REALK,     -7.099405677005866_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -14.647747284119427_REALK,      0.000000000000000_REALK, &
    -65.580870091098774_REALK,      0.000000000000000_REALK,     -1.504791410264310_REALK, &
      0.000000000000000_REALK,     -3.304546466826037_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.083494137533933_REALK,      0.000000000000000_REALK, &
     -8.989950689888294_REALK,      0.000000000000000_REALK,    -67.082987447739683_REALK, &
    146.233189399576588_REALK,     15.504400093438228_REALK,      0.000000000000000_REALK, &
     13.045664909803763_REALK,      0.000000000000000_REALK,     51.500247542289671_REALK, &
      3.518127373289729_REALK,      0.000000000000000_REALK,      6.132380873650312_REALK, &
      0.000000000000000_REALK,      3.874698552839104_REALK,      0.000000000000000_REALK, &
      6.072340114992532_REALK,      0.000000000000000_REALK,     39.952865727842671_REALK, &
      1.030682044927126_REALK,      0.000000000000000_REALK,      2.159225646998336_REALK, &
      0.000000000000000_REALK,      6.272841891246556_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -46.293749297986402_REALK, &
      0.000000000000000_REALK,     -8.649828675796071_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.912363845684842_REALK,      0.000000000000000_REALK, &
    -30.517240380542322_REALK,      0.000000000000000_REALK,     -2.968123345071543_REALK, &
      0.000000000000000_REALK,     -6.710364709784054_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.290424724549268_REALK,      0.000000000000000_REALK, &
     -6.047785415100475_REALK,      0.000000000000000_REALK,    -43.702724754358080_REALK, &
     47.043575402450756_REALK,     12.034592010212895_REALK,      0.000000000000000_REALK, &
      6.986874716023553_REALK,      0.000000000000000_REALK,     27.612926409390504_REALK, &
      3.816744729143196_REALK,      0.000000000000000_REALK,      7.933307256956080_REALK, &
      0.000000000000000_REALK,      2.867975745040261_REALK,      0.000000000000000_REALK, &
      5.420278167737467_REALK,      0.000000000000000_REALK,     29.990181239299400_REALK, &
      1.975348717952813_REALK,      0.000000000000000_REALK,      3.904166541259285_REALK, &
      0.000000000000000_REALK,     11.361025411182405_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -29.624276385373356_REALK, &
      0.000000000000000_REALK,    -10.878284812582192_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -7.214526123652981_REALK,      0.000000000000000_REALK, &
    -27.340011301005994_REALK,      0.000000000000000_REALK,     -5.611292538142795_REALK, &
      0.000000000000000_REALK,    -11.814819199717672_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.398499119899437_REALK,      0.000000000000000_REALK, &
    -10.331682861342953_REALK,      0.000000000000000_REALK,    -50.339212308128310_REALK, &
     37.450927419384769_REALK,     16.810342117553496_REALK,      0.000000000000000_REALK, &
     10.963613390873977_REALK,      0.000000000000000_REALK,     30.775330563786863_REALK, &
      8.052125904273828_REALK,      0.000000000000000_REALK,     15.514132311248934_REALK, &
      0.000000000000000_REALK,      6.701033278299060_REALK,      0.000000000000000_REALK, &
     11.907493894529885_REALK,      0.000000000000000_REALK,     42.974798669142679_REALK, &
      5.904995125200766_REALK,      0.000000000000000_REALK,     11.531181643353499_REALK, &
      0.000000000000000_REALK,     28.565065010182245_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -48.443045604754175_REALK, &
      0.000000000000000_REALK,    -32.167354562148880_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -29.278381912943640_REALK,      0.000000000000000_REALK, &
    -57.481335208904483_REALK,      0.000000000000000_REALK,    -32.861425739357799_REALK, &
      0.000000000000000_REALK,    -44.918626728056026_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -48.804343592629728_REALK,      0.000000000000000_REALK, &
    -53.908195827991570_REALK,      0.000000000000000_REALK,   -129.355455370934237_REALK, &
    ! results of test 4, ket-major order, 002DPG Z
      0.000000000000000_REALK,      0.000000000000000_REALK,    -39.393306208413350_REALK, &
      0.000000000000000_REALK,    -25.894301606550240_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -29.644203409156415_REALK,      0.000000000000000_REALK, &
    -35.662518760583318_REALK,      0.000000000000000_REALK,    -34.686323790206764_REALK, &
      0.000000000000000_REALK,    -28.641675666216685_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -82.754719642547741_REALK,      0.000000000000000_REALK, &
    -63.022347959274960_REALK,      0.000000000000000_REALK,   -126.361728317934862_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -19.710992173534834_REALK, &
      0.000000000000000_REALK,     -3.109446350860185_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.346726507870900_REALK,      0.000000000000000_REALK, &
    -15.394016007568950_REALK,      0.000000000000000_REALK,     12.177463843985196_REALK, &
      0.000000000000000_REALK,     -2.991422062877704_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     48.132434826116061_REALK,      0.000000000000000_REALK, &
      3.954587886758373_REALK,      0.000000000000000_REALK,    -43.235395509387075_REALK, &
     34.106654247843345_REALK,     20.602556086397318_REALK,      0.000000000000000_REALK, &
     18.071169820116623_REALK,      0.000000000000000_REALK,     21.739947734150824_REALK, &
     19.486076567377488_REALK,      0.000000000000000_REALK,     16.090315261586390_REALK, &
      0.000000000000000_REALK,     22.828589773659981_REALK,      0.000000000000000_REALK, &
     17.385248048081628_REALK,      0.000000000000000_REALK,     34.857952166605870_REALK, &
     39.236085550400546_REALK,      0.000000000000000_REALK,     32.836976143296063_REALK, &
      0.000000000000000_REALK,     45.191010835857654_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -15.359949337922515_REALK, &
      0.000000000000000_REALK,      1.285656891895725_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.603497630344714_REALK,      0.000000000000000_REALK, &
    -10.197717890909558_REALK,      0.000000000000000_REALK,      5.909728786689200_REALK, &
      0.000000000000000_REALK,      1.055790804758439_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     11.042025459954784_REALK,      0.000000000000000_REALK, &
      3.447376487334571_REALK,      0.000000000000000_REALK,    -22.505220459228909_REALK, &
     20.119934215398388_REALK,      2.784149111689203_REALK,      0.000000000000000_REALK, &
     -1.684564620459460_REALK,      0.000000000000000_REALK,     11.050377897109367_REALK, &
     -7.524624942772380_REALK,      0.000000000000000_REALK,      1.848441461791504_REALK, &
      0.000000000000000_REALK,    -16.837479037307116_REALK,      0.000000000000000_REALK, &
     -1.383376737225735_REALK,      0.000000000000000_REALK,     15.124418039288486_REALK, &
    -51.445833460275459_REALK,      0.000000000000000_REALK,     -9.963602348387832_REALK, &
      0.000000000000000_REALK,      4.079303139056220_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -19.465605558835797_REALK, &
      0.000000000000000_REALK,    -11.550206524193092_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -10.742587518623134_REALK,      0.000000000000000_REALK, &
    -21.539215364319336_REALK,      0.000000000000000_REALK,    -11.486888196258649_REALK, &
      0.000000000000000_REALK,    -15.808522888408206_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -18.678354835893661_REALK,      0.000000000000000_REALK, &
    -23.707686660432902_REALK,      0.000000000000000_REALK,    -66.548487972480473_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -13.396185734304181_REALK, &
      0.000000000000000_REALK,      5.670400971408676_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.279204414741558_REALK,      0.000000000000000_REALK, &
     -7.619013266308860_REALK,      0.000000000000000_REALK,      7.424560422643186_REALK, &
      0.000000000000000_REALK,      3.935106940830772_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     11.922285399913751_REALK,      0.000000000000000_REALK, &
      4.433248363913347_REALK,      0.000000000000000_REALK,    -13.155474251685090_REALK, &
     17.675337002689101_REALK,     -1.306247713455782_REALK,      0.000000000000000_REALK, &
     -2.193282787433199_REALK,      0.000000000000000_REALK,      8.590935079234203_REALK, &
     -4.158462484598663_REALK,      0.000000000000000_REALK,     -0.742921817844007_REALK, &
      0.000000000000000_REALK,     -4.875256032111275_REALK,      0.000000000000000_REALK, &
     -1.522079719503315_REALK,      0.000000000000000_REALK,      9.936466112649146_REALK, &
     -7.473763111601676_REALK,      0.000000000000000_REALK,     -4.308159933358890_REALK, &
      0.000000000000000_REALK,     -1.282776194770537_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -11.227358521477250_REALK, &
      0.000000000000000_REALK,     -1.557195518241505_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.973432194854167_REALK,      0.000000000000000_REALK, &
    -10.642506160253699_REALK,      0.000000000000000_REALK,      4.399112520316065_REALK, &
      0.000000000000000_REALK,     -1.801086884613625_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     12.274430043334512_REALK,      0.000000000000000_REALK, &
      1.680790113831804_REALK,      0.000000000000000_REALK,    -25.726441892051508_REALK, &
     22.399887567622436_REALK,     11.735192303074411_REALK,      0.000000000000000_REALK, &
      9.049953425143391_REALK,      0.000000000000000_REALK,     18.145432422430638_REALK, &
      8.082907922358597_REALK,      0.000000000000000_REALK,     11.123886009190919_REALK, &
      0.000000000000000_REALK,      8.246835004488229_REALK,      0.000000000000000_REALK, &
     10.467376915390014_REALK,      0.000000000000000_REALK,     29.382373604584011_REALK, &
     10.005739144560563_REALK,      0.000000000000000_REALK,     13.956464352351130_REALK, &
      0.000000000000000_REALK,     26.890095501944522_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -14.129997693324817_REALK, &
      0.000000000000000_REALK,     10.777149029569193_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.138094270334998_REALK,      0.000000000000000_REALK, &
     -6.607322196813277_REALK,      0.000000000000000_REALK,      6.277564228674703_REALK, &
      0.000000000000000_REALK,      6.128052210671676_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.947333856634135_REALK,      0.000000000000000_REALK, &
      3.308214208532803_REALK,      0.000000000000000_REALK,     -8.803745453774754_REALK, &
     19.593672873090547_REALK,     -7.037519221850079_REALK,      0.000000000000000_REALK, &
     -4.384989255560784_REALK,      0.000000000000000_REALK,      7.807360451313513_REALK, &
     -6.208936166092585_REALK,      0.000000000000000_REALK,     -3.290811362764546_REALK, &
      0.000000000000000_REALK,     -6.705397888736395_REALK,      0.000000000000000_REALK, &
     -2.493372136506956_REALK,      0.000000000000000_REALK,      7.398974803372294_REALK, &
    -12.040933105414858_REALK,      0.000000000000000_REALK,     -4.963756140547719_REALK, &
      0.000000000000000_REALK,     -4.384751448649146_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -10.662186159078143_REALK, &
      0.000000000000000_REALK,      0.761287349990829_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.272869406420126_REALK,      0.000000000000000_REALK, &
     -8.309567206406673_REALK,      0.000000000000000_REALK,      2.423019207516405_REALK, &
      0.000000000000000_REALK,      0.721466103151489_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.259395935728604_REALK,      0.000000000000000_REALK, &
      1.695999970369969_REALK,      0.000000000000000_REALK,    -15.500597257407851_REALK, &
     16.421479551108746_REALK,      1.932631122042316_REALK,      0.000000000000000_REALK, &
     -0.997496100150726_REALK,      0.000000000000000_REALK,     10.905596144037068_REALK, &
     -3.678845247565141_REALK,      0.000000000000000_REALK,      1.506194691614000_REALK, &
      0.000000000000000_REALK,     -6.903453032470874_REALK,      0.000000000000000_REALK, &
     -0.945319299333190_REALK,      0.000000000000000_REALK,     14.469208156089744_REALK, &
    -15.185831720703089_REALK,      0.000000000000000_REALK,     -4.901776568276491_REALK, &
      0.000000000000000_REALK,      2.809642996563499_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -22.520246823023793_REALK, &
      0.000000000000000_REALK,    -11.398876029933957_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.753551913441152_REALK,      0.000000000000000_REALK, &
    -24.571593701731707_REALK,      0.000000000000000_REALK,     -7.849472098961583_REALK, &
      0.000000000000000_REALK,    -15.123676674269452_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -9.189158586136456_REALK,      0.000000000000000_REALK, &
    -16.328802621326638_REALK,      0.000000000000000_REALK,    -58.931544401802618_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -14.833455985536132_REALK, &
      0.000000000000000_REALK,     21.109495870577661_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.633708555937035_REALK,      0.000000000000000_REALK, &
     -5.867005574393908_REALK,      0.000000000000000_REALK,      8.174879986753472_REALK, &
      0.000000000000000_REALK,      9.825795731258445_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.647269509181012_REALK,      0.000000000000000_REALK, &
      2.843905661476716_REALK,      0.000000000000000_REALK,     -6.001388221232292_REALK, &
     23.498033667542579_REALK,    -15.893458421967544_REALK,      0.000000000000000_REALK, &
     -5.182863619655926_REALK,      0.000000000000000_REALK,      8.275512252754050_REALK, &
     -6.439635290651118_REALK,      0.000000000000000_REALK,     -6.286263244991934_REALK, &
      0.000000000000000_REALK,     -3.607756738704810_REALK,      0.000000000000000_REALK, &
     -2.412457386094664_REALK,      0.000000000000000_REALK,      6.419977488300432_REALK, &
     -4.122938411191139_REALK,      0.000000000000000_REALK,     -3.952280347339314_REALK, &
      0.000000000000000_REALK,     -6.430248909036941_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -11.513801876341436_REALK, &
      0.000000000000000_REALK,      4.121662141312686_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.557744790508682_REALK,      0.000000000000000_REALK, &
     -7.589997891346727_REALK,      0.000000000000000_REALK,      3.619732402197725_REALK, &
      0.000000000000000_REALK,      3.197503351264027_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.221639370201762_REALK,      0.000000000000000_REALK, &
      2.616329448478970_REALK,      0.000000000000000_REALK,    -10.869383489313709_REALK, &
     17.731100512067531_REALK,     -1.122698480929586_REALK,      0.000000000000000_REALK, &
     -1.594238339711347_REALK,      0.000000000000000_REALK,     10.407533215932409_REALK, &
     -2.485575524241554_REALK,      0.000000000000000_REALK,     -0.740092559728968_REALK, &
      0.000000000000000_REALK,     -2.376857513964526_REALK,      0.000000000000000_REALK, &
     -1.236778333392734_REALK,      0.000000000000000_REALK,     11.303539609394516_REALK, &
     -2.646433258150951_REALK,      0.000000000000000_REALK,     -2.542507158893834_REALK, &
      0.000000000000000_REALK,     -1.059861934672372_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -16.082884110302714_REALK, &
      0.000000000000000_REALK,     -1.886472651734228_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.969725087496997_REALK,      0.000000000000000_REALK, &
    -14.842767047148730_REALK,      0.000000000000000_REALK,      3.574534882482390_REALK, &
      0.000000000000000_REALK,     -2.048883044473373_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      7.243887585247590_REALK,      0.000000000000000_REALK, &
      1.388711038672363_REALK,      0.000000000000000_REALK,    -27.328928046164265_REALK, &
     37.450927419384762_REALK,     16.810342117553496_REALK,      0.000000000000000_REALK, &
     10.963613390873977_REALK,      0.000000000000000_REALK,     30.775330563786866_REALK, &
      8.052125904273828_REALK,      0.000000000000000_REALK,     15.514132311248934_REALK, &
      0.000000000000000_REALK,      6.701033278299059_REALK,      0.000000000000000_REALK, &
     11.907493894529884_REALK,      0.000000000000000_REALK,     42.974798669142672_REALK, &
      5.904995125200766_REALK,      0.000000000000000_REALK,     11.531181643353499_REALK, &
      0.000000000000000_REALK,     28.565065010182249_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -16.659928811830177_REALK, &
      0.000000000000000_REALK,     55.218102775284841_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.245035527675758_REALK,      0.000000000000000_REALK, &
     -4.674542550071669_REALK,      0.000000000000000_REALK,     12.303039011103074_REALK, &
      0.000000000000000_REALK,     18.450101318512420_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.277492160108329_REALK,      0.000000000000000_REALK, &
      1.824904965180403_REALK,      0.000000000000000_REALK,     -3.349244018476458_REALK, &
     46.221456336719754_REALK,    -51.777565791838541_REALK,      0.000000000000000_REALK, &
     -8.896322758499759_REALK,      0.000000000000000_REALK,     11.264147191313929_REALK, &
    -12.087076183959436_REALK,      0.000000000000000_REALK,    -14.528059343279729_REALK, &
      0.000000000000000_REALK,     -4.857473934775327_REALK,      0.000000000000000_REALK, &
     -2.972540670665260_REALK,      0.000000000000000_REALK,      6.272841891246568_REALK, &
     -7.688231672738569_REALK,      0.000000000000000_REALK,     -5.196132093315705_REALK, &
      0.000000000000000_REALK,    -10.409150271785339_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -20.298252632615490_REALK, &
      0.000000000000000_REALK,     12.069085937804116_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.566970556574754_REALK,      0.000000000000000_REALK, &
     -9.492342043691460_REALK,      0.000000000000000_REALK,      4.131049153099102_REALK, &
      0.000000000000000_REALK,      6.721100725502992_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.293168903425689_REALK,      0.000000000000000_REALK, &
      2.555684256314337_REALK,      0.000000000000000_REALK,     -9.521581472169995_REALK, &
     35.877322939164188_REALK,    -10.109650841591026_REALK,      0.000000000000000_REALK, &
     -4.910650489893647_REALK,      0.000000000000000_REALK,     14.572144571163792_REALK, &
     -5.352002889559953_REALK,      0.000000000000000_REALK,     -4.727710580194408_REALK, &
      0.000000000000000_REALK,     -4.412591772924797_REALK,      0.000000000000000_REALK, &
     -2.734670772948430_REALK,      0.000000000000000_REALK,     11.361025411182402_REALK, &
     -5.581166374802065_REALK,      0.000000000000000_REALK,     -3.834634827412698_REALK, &
      0.000000000000000_REALK,     -4.742273430409933_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -25.527693277117510_REALK, &
      0.000000000000000_REALK,      1.420914199292302_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.828654850298926_REALK,      0.000000000000000_REALK, &
    -16.712996964914932_REALK,      0.000000000000000_REALK,      2.657509367362458_REALK, &
      0.000000000000000_REALK,      1.107801411551635_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.517970830471370_REALK,      0.000000000000000_REALK, &
      1.834287688060264_REALK,      0.000000000000000_REALK,    -21.554329247993895_REALK, &
     50.114708696188771_REALK,      4.627157485831525_REALK,      0.000000000000000_REALK, &
     -1.861788945343617_REALK,      0.000000000000000_REALK,     28.496838911345165_REALK, &
     -5.285175503101619_REALK,      0.000000000000000_REALK,      3.029402938110588_REALK, &
      0.000000000000000_REALK,     -7.571541754199610_REALK,      0.000000000000000_REALK, &
     -1.451524956742730_REALK,      0.000000000000000_REALK,     28.565065010182249_REALK, &
    -11.731462535750399_REALK,      0.000000000000000_REALK,     -5.301455522343250_REALK, &
      0.000000000000000_REALK,      3.906944307472268_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -75.486014104819475_REALK, &
      0.000000000000000_REALK,    -29.785802601266543_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -17.605981506325804_REALK,      0.000000000000000_REALK, &
    -63.540953059365165_REALK,      0.000000000000000_REALK,    -12.052757895597153_REALK, &
      0.000000000000000_REALK,    -29.857114690250796_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -9.938420255105584_REALK,      0.000000000000000_REALK, &
    -22.705988813261865_REALK,      0.000000000000000_REALK,   -100.157639020750906_REALK, &
    ! results of test 4, ket-major order, 003DPG Z
     44.929213900362619_REALK,     41.175136869932231_REALK,      0.000000000000000_REALK, &
     48.867911952498687_REALK,      0.000000000000000_REALK,     31.980283111877203_REALK, &
     81.809891952152952_REALK,      0.000000000000000_REALK,     37.275599141763109_REALK, &
      0.000000000000000_REALK,    146.805706178273738_REALK,      0.000000000000000_REALK, &
     54.052776008241231_REALK,      0.000000000000000_REALK,     58.955628573023546_REALK, &
    560.785595981811980_REALK,      0.000000000000000_REALK,    173.924439997829296_REALK, &
      0.000000000000000_REALK,    132.077298388855382_REALK,      0.000000000000000_REALK, &
     34.106654247843352_REALK,     20.602556086397318_REALK,      0.000000000000000_REALK, &
     18.071169820116623_REALK,      0.000000000000000_REALK,     21.739947734150824_REALK, &
     19.486076567377491_REALK,      0.000000000000000_REALK,     16.090315261586390_REALK, &
      0.000000000000000_REALK,     22.828589773659985_REALK,      0.000000000000000_REALK, &
     17.385248048081625_REALK,      0.000000000000000_REALK,     34.857952166605877_REALK, &
     39.236085550400553_REALK,      0.000000000000000_REALK,     32.836976143296063_REALK, &
      0.000000000000000_REALK,     45.191010835857647_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.848639792922734_REALK, &
      0.000000000000000_REALK,     -7.902207412350591_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -10.559939822455691_REALK,      0.000000000000000_REALK, &
    -20.158699821850735_REALK,      0.000000000000000_REALK,    -16.684924096686810_REALK, &
      0.000000000000000_REALK,    -22.176122000300566_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -48.330927480249130_REALK,      0.000000000000000_REALK, &
    -51.909010371611316_REALK,      0.000000000000000_REALK,    -93.825633219213785_REALK, &
     37.060423240298604_REALK,     16.054707694707549_REALK,      0.000000000000000_REALK, &
     12.532763788400979_REALK,      0.000000000000000_REALK,     20.354523898924437_REALK, &
     11.812130299978916_REALK,      0.000000000000000_REALK,     10.658979160004598_REALK, &
      0.000000000000000_REALK,     14.872482977364225_REALK,      0.000000000000000_REALK, &
     10.291996915672030_REALK,      0.000000000000000_REALK,     27.858805491036733_REALK, &
     31.110684090066275_REALK,      0.000000000000000_REALK,     15.640828624871059_REALK, &
      0.000000000000000_REALK,     23.523172383506125_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.769322861126575_REALK, &
      0.000000000000000_REALK,     -4.016678383758940_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.735822297316593_REALK,      0.000000000000000_REALK, &
    -13.109948680814345_REALK,      0.000000000000000_REALK,     -3.994658919554788_REALK, &
      0.000000000000000_REALK,     -9.621934702868867_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.495550010847503_REALK,      0.000000000000000_REALK, &
    -14.429799331222018_REALK,      0.000000000000000_REALK,    -47.946041125915180_REALK, &
     -7.908267360868453_REALK,     -6.195046975817444_REALK,      0.000000000000000_REALK, &
     -6.637024117147710_REALK,      0.000000000000000_REALK,      5.166493163189979_REALK, &
     -9.026907672298012_REALK,      0.000000000000000_REALK,      4.892397730319955_REALK, &
      0.000000000000000_REALK,    -14.803047140280588_REALK,      0.000000000000000_REALK, &
      6.483210618536859_REALK,      0.000000000000000_REALK,     20.087287541377293_REALK, &
    -38.539561178587455_REALK,      0.000000000000000_REALK,     14.217867770443991_REALK, &
      0.000000000000000_REALK,     30.670858249769015_REALK,      0.000000000000000_REALK, &
     46.895625484939210_REALK,     14.002119502911986_REALK,      0.000000000000000_REALK, &
      9.612234049885716_REALK,      0.000000000000000_REALK,     22.793187704421165_REALK, &
      6.385559245589517_REALK,      0.000000000000000_REALK,      7.963635049933838_REALK, &
      0.000000000000000_REALK,      5.882605906668177_REALK,      0.000000000000000_REALK, &
      6.670633896494695_REALK,      0.000000000000000_REALK,     26.363106592631926_REALK, &
      5.578560628844436_REALK,      0.000000000000000_REALK,      6.615428321362671_REALK, &
      0.000000000000000_REALK,     13.750520203514045_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -7.191818504532824_REALK, &
      0.000000000000000_REALK,     -3.122700739317068_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.518501386046439_REALK,      0.000000000000000_REALK, &
    -11.931604288898290_REALK,      0.000000000000000_REALK,     -2.401517474084637_REALK, &
      0.000000000000000_REALK,     -6.321435169592622_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.770379425455268_REALK,      0.000000000000000_REALK, &
     -7.611036014412265_REALK,      0.000000000000000_REALK,    -34.141146766809868_REALK, &
     -6.820400914627672_REALK,     -3.573174913293360_REALK,      0.000000000000000_REALK, &
     -2.755563412175525_REALK,      0.000000000000000_REALK,      3.943179797243674_REALK, &
     -2.461113807829584_REALK,      0.000000000000000_REALK,      2.417329141413073_REALK, &
      0.000000000000000_REALK,     -2.511026934291222_REALK,      0.000000000000000_REALK, &
      2.274663299392004_REALK,      0.000000000000000_REALK,     12.955733124601233_REALK, &
     -3.046584595885550_REALK,      0.000000000000000_REALK,      3.032876097629570_REALK, &
      0.000000000000000_REALK,     11.856799103659942_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.203920652234340_REALK, &
      0.000000000000000_REALK,      3.300786161728238_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.653537407831861_REALK,      0.000000000000000_REALK, &
     -5.173969953510256_REALK,      0.000000000000000_REALK,      5.027375741965272_REALK, &
      0.000000000000000_REALK,     -4.956920817573724_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     10.280104307407383_REALK,      0.000000000000000_REALK, &
     -8.190763955915099_REALK,      0.000000000000000_REALK,    -34.647269216914900_REALK, &
     78.780631242009406_REALK,     14.769123107270904_REALK,      0.000000000000000_REALK, &
     10.136137129278641_REALK,      0.000000000000000_REALK,     31.391193916128802_REALK, &
      5.091229498470461_REALK,      0.000000000000000_REALK,      6.906183359126729_REALK, &
      0.000000000000000_REALK,      5.226312592395646_REALK,      0.000000000000000_REALK, &
      5.763563013958823_REALK,      0.000000000000000_REALK,     29.749190431464545_REALK, &
      5.928230225358297_REALK,      0.000000000000000_REALK,      4.070201562705773_REALK, &
      0.000000000000000_REALK,      9.201954822207835_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -9.837578256422704_REALK, &
      0.000000000000000_REALK,     -2.837880862627215_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.939951463452596_REALK,      0.000000000000000_REALK, &
    -13.418814444302177_REALK,      0.000000000000000_REALK,     -1.293898820567006_REALK, &
      0.000000000000000_REALK,     -4.707120118029311_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.367687114781191_REALK,      0.000000000000000_REALK, &
     -4.524042330949551_REALK,      0.000000000000000_REALK,    -29.629725180861815_REALK, &
     -9.210011398726589_REALK,     -3.393305382704474_REALK,      0.000000000000000_REALK, &
     -2.259615010001121_REALK,      0.000000000000000_REALK,      4.365283832749019_REALK, &
     -1.758405186653040_REALK,      0.000000000000000_REALK,      1.887427515484607_REALK, &
      0.000000000000000_REALK,     -1.856679115905360_REALK,      0.000000000000000_REALK, &
      1.528329377586522_REALK,      0.000000000000000_REALK,     11.751781272935343_REALK, &
     -2.796159891684997_REALK,      0.000000000000000_REALK,      1.672153493052144_REALK, &
      0.000000000000000_REALK,      7.143913194020448_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.919318830433202_REALK, &
      0.000000000000000_REALK,      1.983807274448655_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.523427390345004_REALK,      0.000000000000000_REALK, &
     -3.965936997966379_REALK,      0.000000000000000_REALK,      1.366085551734171_REALK, &
      0.000000000000000_REALK,     -2.441011746972653_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.599238346076253_REALK,      0.000000000000000_REALK, &
     -2.635523085498755_REALK,      0.000000000000000_REALK,    -20.493924504677842_REALK, &
    -19.975264813898040_REALK,    -13.308421775023250_REALK,      0.000000000000000_REALK, &
    -12.162487348480202_REALK,      0.000000000000000_REALK,     -3.880369325487929_REALK, &
    -13.658126686416590_REALK,      0.000000000000000_REALK,     -3.033905786337348_REALK, &
      0.000000000000000_REALK,    -18.783040859998724_REALK,      0.000000000000000_REALK, &
     -3.371577211485860_REALK,      0.000000000000000_REALK,      7.303792475959234_REALK, &
    -35.206318657260091_REALK,      0.000000000000000_REALK,     -5.323245786890300_REALK, &
      0.000000000000000_REALK,      8.028827488338736_REALK,      0.000000000000000_REALK, &
    146.233189399576588_REALK,     15.504400093438226_REALK,      0.000000000000000_REALK, &
     13.045664909803763_REALK,      0.000000000000000_REALK,     51.500247542289678_REALK, &
      3.518127373289729_REALK,      0.000000000000000_REALK,      6.132380873650312_REALK, &
      0.000000000000000_REALK,      3.874698552839104_REALK,      0.000000000000000_REALK, &
      6.072340114992532_REALK,      0.000000000000000_REALK,     39.952865727842664_REALK, &
      1.030682044927126_REALK,      0.000000000000000_REALK,      2.159225646998336_REALK, &
      0.000000000000000_REALK,      6.272841891246557_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -16.099028335025206_REALK, &
      0.000000000000000_REALK,     -3.008048366279366_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.056072677673549_REALK,      0.000000000000000_REALK, &
    -18.574467477201345_REALK,      0.000000000000000_REALK,     -1.032189065667986_REALK, &
      0.000000000000000_REALK,     -4.084296270167157_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.144271995206279_REALK,      0.000000000000000_REALK, &
     -3.681014144827473_REALK,      0.000000000000000_REALK,    -31.486404909056610_REALK, &
    -14.324002463566254_REALK,     -3.664337247489992_REALK,      0.000000000000000_REALK, &
     -2.127389548706292_REALK,      0.000000000000000_REALK,      6.000558764622693_REALK, &
     -1.162136602827228_REALK,      0.000000000000000_REALK,      1.723985197634957_REALK, &
      0.000000000000000_REALK,     -0.873251900731696_REALK,      0.000000000000000_REALK, &
      1.177879417193869_REALK,      0.000000000000000_REALK,     13.223737119528284_REALK, &
     -0.601461510106320_REALK,      0.000000000000000_REALK,      0.848413544090461_REALK, &
      0.000000000000000_REALK,      5.009480011040657_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.155671036271607_REALK, &
      0.000000000000000_REALK,      1.893206004526564_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.255582512540542_REALK,      0.000000000000000_REALK, &
     -4.412768811810402_REALK,      0.000000000000000_REALK,      0.976563209126473_REALK, &
      0.000000000000000_REALK,     -1.906951138669591_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.113564974851592_REALK,      0.000000000000000_REALK, &
     -1.667567997763508_REALK,      0.000000000000000_REALK,    -17.505871043083928_REALK, &
    -21.174022361381681_REALK,     -9.504238864731466_REALK,      0.000000000000000_REALK, &
     -6.198612720595822_REALK,      0.000000000000000_REALK,     -3.635455823129328_REALK, &
     -4.552514602495672_REALK,      0.000000000000000_REALK,     -1.832667322121161_REALK, &
      0.000000000000000_REALK,     -3.788633239710516_REALK,      0.000000000000000_REALK, &
     -1.406619107730517_REALK,      0.000000000000000_REALK,      5.601515409332900_REALK, &
     -3.338568827006764_REALK,      0.000000000000000_REALK,     -1.362165756952739_REALK, &
      0.000000000000000_REALK,      3.723290318472688_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     19.263915770599024_REALK, &
      0.000000000000000_REALK,     12.791706242090946_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     11.642874142806248_REALK,      0.000000000000000_REALK, &
      5.004886060381830_REALK,      0.000000000000000_REALK,     13.067711363768121_REALK, &
      0.000000000000000_REALK,      3.911054048165471_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     19.407589933105410_REALK,      0.000000000000000_REALK, &
      4.693773672085010_REALK,      0.000000000000000_REALK,    -14.304034061114042_REALK, &
    516.659356294024974_REALK,     17.413487597137213_REALK,      0.000000000000000_REALK, &
     28.122417703094627_REALK,      0.000000000000000_REALK,    125.909642367586599_REALK, &
      2.224929105541006_REALK,      0.000000000000000_REALK,      4.885980584752629_REALK, &
      0.000000000000000_REALK,      6.358661607003993_REALK,      0.000000000000000_REALK, &
      9.396582458748677_REALK,      0.000000000000000_REALK,     70.117272594263909_REALK, &
      1.273017559505851_REALK,      0.000000000000000_REALK,      0.956478254517522_REALK, &
      0.000000000000000_REALK,      3.500736397751680_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -43.928906558026384_REALK, &
      0.000000000000000_REALK,     -4.094380930326818_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.122290242290199_REALK,      0.000000000000000_REALK, &
    -35.954969320456868_REALK,      0.000000000000000_REALK,     -0.784852342852895_REALK, &
      0.000000000000000_REALK,     -3.990690744080641_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.856473691566853_REALK,      0.000000000000000_REALK, &
     -3.915387486995820_REALK,      0.000000000000000_REALK,    -42.691172178020409_REALK, &
    -43.922565447543441_REALK,     -6.460041954820328_REALK,      0.000000000000000_REALK, &
     -3.456265005131534_REALK,      0.000000000000000_REALK,     12.732284444014368_REALK, &
     -1.336244356738098_REALK,      0.000000000000000_REALK,      2.156081913127959_REALK, &
      0.000000000000000_REALK,     -1.047197616193402_REALK,      0.000000000000000_REALK, &
      1.373688462547889_REALK,      0.000000000000000_REALK,     20.141705948659240_REALK, &
     -0.836669528392005_REALK,      0.000000000000000_REALK,      0.683295797199466_REALK, &
      0.000000000000000_REALK,      4.388305197367022_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     11.787281379180092_REALK, &
      0.000000000000000_REALK,      2.650779106688141_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.394758114811845_REALK,      0.000000000000000_REALK, &
     -7.157007123078269_REALK,      0.000000000000000_REALK,      0.710196295820478_REALK, &
      0.000000000000000_REALK,     -1.916649217233022_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.528762283010862_REALK,      0.000000000000000_REALK, &
     -1.297506801060107_REALK,      0.000000000000000_REALK,    -19.887328693965884_REALK, &
    -52.190303111114694_REALK,    -15.085683196330494_REALK,      0.000000000000000_REALK, &
     -7.831237892027615_REALK,      0.000000000000000_REALK,     -6.200641903435544_REALK, &
     -4.690763909850601_REALK,      0.000000000000000_REALK,     -2.063588500379623_REALK, &
      0.000000000000000_REALK,     -3.781216328751727_REALK,      0.000000000000000_REALK, &
     -1.275674374081063_REALK,      0.000000000000000_REALK,      6.858209056344660_REALK, &
     -4.010996674753289_REALK,      0.000000000000000_REALK,     -0.983093078588791_REALK, &
      0.000000000000000_REALK,      2.936559577992384_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     30.017852912013907_REALK, &
      0.000000000000000_REALK,     11.844655622027538_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      7.001214324214566_REALK,      0.000000000000000_REALK, &
      5.532495532235460_REALK,      0.000000000000000_REALK,      4.792913203653314_REALK, &
      0.000000000000000_REALK,      2.599651809989779_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.952123329512135_REALK,      0.000000000000000_REALK, &
      1.977004996242256_REALK,      0.000000000000000_REALK,    -11.075360338884476_REALK, &
   -102.222241055900312_REALK,    -53.430814463833535_REALK,      0.000000000000000_REALK, &
    -38.066379098449545_REALK,      0.000000000000000_REALK,    -33.602588155289574_REALK, &
    -32.903262076692492_REALK,      0.000000000000000_REALK,    -20.222293516694549_REALK, &
      0.000000000000000_REALK,    -34.544887002591025_REALK,      0.000000000000000_REALK, &
    -17.156610130958992_REALK,      0.000000000000000_REALK,     -9.100049682230324_REALK, &
    -45.607274190024988_REALK,      0.000000000000000_REALK,    -19.079655089634919_REALK, &
      0.000000000000000_REALK,     -7.046007364205233_REALK,      0.000000000000000_REALK, &
    ! results of test 5, ket-major order, XDIPVEL
   -368.081576156876679_REALK,   -252.275650762442581_REALK,      0.000000000000000_REALK, &
   -267.576145315328347_REALK,      0.000000000000000_REALK,    -58.369323476769061_REALK, &
   -212.812013375536452_REALK,      0.000000000000000_REALK,    -32.321663121852929_REALK, &
      0.000000000000000_REALK,   -347.178460395950651_REALK,      0.000000000000000_REALK, &
    -42.609514401027205_REALK,      0.000000000000000_REALK,    -27.884644122487078_REALK, &
   1493.591423951312436_REALK,      0.000000000000000_REALK,    154.409607912918915_REALK, &
      0.000000000000000_REALK,     70.354702968744220_REALK,      0.000000000000000_REALK, &
   -237.316939587498979_REALK,   -106.418651285549601_REALK,      0.000000000000000_REALK, &
    -72.117952837457210_REALK,      0.000000000000000_REALK,    -28.919738658995044_REALK, &
    -34.690097216891402_REALK,      0.000000000000000_REALK,     -9.548263837597904_REALK, &
      0.000000000000000_REALK,    -18.429659043415967_REALK,      0.000000000000000_REALK, &
     -4.678405413096594_REALK,      0.000000000000000_REALK,     -5.628207258982632_REALK, &
    127.919849816262015_REALK,      0.000000000000000_REALK,     35.685695941600102_REALK, &
      0.000000000000000_REALK,     29.466891195056860_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     43.810135632764215_REALK, &
      0.000000000000000_REALK,     30.227830871237565_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     18.019552085425982_REALK,      0.000000000000000_REALK, &
     11.792408437694146_REALK,      0.000000000000000_REALK,     12.911119117323972_REALK, &
      0.000000000000000_REALK,      5.882781277481658_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,   -151.035428973562375_REALK,      0.000000000000000_REALK, &
    -55.610128680575734_REALK,      0.000000000000000_REALK,    -60.654240790337965_REALK, &
   -189.451652162756744_REALK,    -60.864740075256634_REALK,      0.000000000000000_REALK, &
    -31.947986982321318_REALK,      0.000000000000000_REALK,    -17.295628097505062_REALK, &
     -8.909570141355884_REALK,      0.000000000000000_REALK,     -2.679926483751512_REALK, &
      0.000000000000000_REALK,      8.332022125918709_REALK,      0.000000000000000_REALK, &
      1.921964345200057_REALK,      0.000000000000000_REALK,      3.121471836360725_REALK, &
    121.574584081994246_REALK,      0.000000000000000_REALK,     20.373785730774198_REALK, &
      0.000000000000000_REALK,     18.384808836312011_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     24.598579749427053_REALK, &
      0.000000000000000_REALK,      9.814431302044669_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.700947657652063_REALK,      0.000000000000000_REALK, &
      3.249289420359949_REALK,      0.000000000000000_REALK,     -2.145102620162118_REALK, &
      0.000000000000000_REALK,     -1.771284091362302_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -24.330475600553722_REALK,      0.000000000000000_REALK, &
    -18.529018114446949_REALK,      0.000000000000000_REALK,    -37.151246007032697_REALK, &
    -44.257211340685600_REALK,    -25.711218109747914_REALK,      0.000000000000000_REALK, &
    -18.521865235818655_REALK,      0.000000000000000_REALK,    -12.121133691516972_REALK, &
     -7.453876664895813_REALK,      0.000000000000000_REALK,     -3.396260671940497_REALK, &
      0.000000000000000_REALK,      9.078889618930353_REALK,      0.000000000000000_REALK, &
      3.342780057742844_REALK,      0.000000000000000_REALK,      3.645986645635922_REALK, &
    164.874949961916059_REALK,      0.000000000000000_REALK,     51.135021204657370_REALK, &
      0.000000000000000_REALK,     38.831664220694179_REALK,      0.000000000000000_REALK, &
   -193.706713632843247_REALK,    -36.761912833559968_REALK,      0.000000000000000_REALK, &
    -11.922304524514065_REALK,      0.000000000000000_REALK,     -9.423661675534200_REALK, &
      2.367549647182789_REALK,      0.000000000000000_REALK,      0.984215614619604_REALK, &
      0.000000000000000_REALK,     10.760807668304754_REALK,      0.000000000000000_REALK, &
      4.067438225208238_REALK,      0.000000000000000_REALK,      9.644988091442833_REALK, &
     25.764347231784374_REALK,      0.000000000000000_REALK,     10.184358994999654_REALK, &
      0.000000000000000_REALK,     12.701239646270103_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     18.098578918374461_REALK, &
      0.000000000000000_REALK,      3.712510371556063_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.895042765015098_REALK,      0.000000000000000_REALK, &
     -1.453643398906157_REALK,      0.000000000000000_REALK,     -4.210777575645122_REALK, &
      0.000000000000000_REALK,     -3.799703295373921_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -16.691043114473906_REALK,      0.000000000000000_REALK, &
    -11.550469717461985_REALK,      0.000000000000000_REALK,    -31.265292034716101_REALK, &
    -30.841601688859878_REALK,    -10.270067005236037_REALK,      0.000000000000000_REALK, &
     -3.741631068187574_REALK,      0.000000000000000_REALK,     -4.501250592660736_REALK, &
      0.998956398533598_REALK,      0.000000000000000_REALK,      0.824872227582946_REALK, &
      0.000000000000000_REALK,      5.028531389178368_REALK,      0.000000000000000_REALK, &
      3.829507927787099_REALK,      0.000000000000000_REALK,      7.678280102720219_REALK, &
     15.403694894472887_REALK,      0.000000000000000_REALK,     12.891468521208120_REALK, &
      0.000000000000000_REALK,     17.741539022647558_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     12.683858224711301_REALK, &
      0.000000000000000_REALK,      4.704850317922435_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.556704791736422_REALK,      0.000000000000000_REALK, &
     -1.697905570760429_REALK,      0.000000000000000_REALK,    -10.568394281946100_REALK, &
      0.000000000000000_REALK,     -8.025582632809336_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -54.561594690103163_REALK,      0.000000000000000_REALK, &
    -33.481959854875775_REALK,      0.000000000000000_REALK,    -51.126513545205746_REALK, &
   -140.168445601901226_REALK,    -11.454492788479527_REALK,      0.000000000000000_REALK, &
      3.692933594604102_REALK,      0.000000000000000_REALK,      3.812287104020728_REALK, &
      8.730404374702454_REALK,      0.000000000000000_REALK,      3.947558144133365_REALK, &
      0.000000000000000_REALK,     16.329150167377964_REALK,      0.000000000000000_REALK, &
      6.002580486735293_REALK,      0.000000000000000_REALK,     18.589741402767334_REALK, &
     32.178013078482017_REALK,      0.000000000000000_REALK,      7.364255105825086_REALK, &
      0.000000000000000_REALK,      9.989511586443433_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.313256210732290_REALK, &
      0.000000000000000_REALK,     -0.991047832988569_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.188628956831898_REALK,      0.000000000000000_REALK, &
     -7.561095366137721_REALK,      0.000000000000000_REALK,     -3.874984360227746_REALK, &
      0.000000000000000_REALK,     -4.832616859732261_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -7.115777401523780_REALK,      0.000000000000000_REALK, &
     -8.068999808521925_REALK,      0.000000000000000_REALK,    -31.889608296412867_REALK, &
    -17.939306433318006_REALK,     -2.881102958383884_REALK,      0.000000000000000_REALK, &
      0.901255964165071_REALK,      0.000000000000000_REALK,      1.463734286496647_REALK, &
      3.300998457768357_REALK,      0.000000000000000_REALK,      2.978740741509009_REALK, &
      0.000000000000000_REALK,      6.350672738090728_REALK,      0.000000000000000_REALK, &
      4.394767459633417_REALK,      0.000000000000000_REALK,     11.895939421613262_REALK, &
     16.615401654301696_REALK,      0.000000000000000_REALK,      8.353356970742787_REALK, &
      0.000000000000000_REALK,     12.563110351537722_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.493206779515719_REALK, &
      0.000000000000000_REALK,     -0.830598317579516_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.002105795554918_REALK,      0.000000000000000_REALK, &
     -6.019313611811878_REALK,      0.000000000000000_REALK,     -4.904995878933219_REALK, &
      0.000000000000000_REALK,     -6.750369490400300_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -9.975620174132931_REALK,      0.000000000000000_REALK, &
    -12.661654594834204_REALK,      0.000000000000000_REALK,    -35.541804672250557_REALK, &
    -12.572236774835890_REALK,     -3.651210855483261_REALK,      0.000000000000000_REALK, &
      1.567511109900016_REALK,      0.000000000000000_REALK,      1.709692075116795_REALK, &
      8.284990740800923_REALK,      0.000000000000000_REALK,      6.291578079741552_REALK, &
      0.000000000000000_REALK,     20.759806895754675_REALK,      0.000000000000000_REALK, &
     12.739345780241841_REALK,      0.000000000000000_REALK,     19.452813915722633_REALK, &
     67.599577749800176_REALK,      0.000000000000000_REALK,     34.942702964280606_REALK, &
      0.000000000000000_REALK,     37.149424936355366_REALK,      0.000000000000000_REALK, &
   -159.934503395555510_REALK,      5.783899699880886_REALK,      0.000000000000000_REALK, &
     22.396921670558012_REALK,      0.000000000000000_REALK,     29.472038366609656_REALK, &
     10.776715898919161_REALK,      0.000000000000000_REALK,      6.261562800050882_REALK, &
      0.000000000000000_REALK,     17.206359458634335_REALK,      0.000000000000000_REALK, &
      8.988472724507288_REALK,      0.000000000000000_REALK,     35.483708460990002_REALK, &
      6.553990365628093_REALK,      0.000000000000000_REALK,      4.576757095716737_REALK, &
      0.000000000000000_REALK,      7.977658196858384_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.756611049278956_REALK, &
      0.000000000000000_REALK,     -4.950036063192255_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.036910994158355_REALK,      0.000000000000000_REALK, &
    -18.696061552348134_REALK,      0.000000000000000_REALK,     -4.393511434624525_REALK, &
      0.000000000000000_REALK,     -5.959738323925989_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.974479358809809_REALK,      0.000000000000000_REALK, &
     -7.691436469480196_REALK,      0.000000000000000_REALK,    -39.700096566639601_REALK, &
    -17.150440564222365_REALK,      1.496497181371506_REALK,      0.000000000000000_REALK, &
      3.998377668461710_REALK,      0.000000000000000_REALK,      9.481226969447041_REALK, &
      3.897146525256106_REALK,      0.000000000000000_REALK,      4.860256004153977_REALK, &
      0.000000000000000_REALK,      4.245269742911059_REALK,      0.000000000000000_REALK, &
      4.813961821703113_REALK,      0.000000000000000_REALK,     19.025326619275166_REALK, &
      4.187006241785560_REALK,      0.000000000000000_REALK,      4.965230552557087_REALK, &
      0.000000000000000_REALK,     10.320496226611368_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.210260858361950_REALK, &
      0.000000000000000_REALK,     -3.735188578610963_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.419902415712555_REALK,      0.000000000000000_REALK, &
    -11.963975766568646_REALK,      0.000000000000000_REALK,     -4.983609182608159_REALK, &
      0.000000000000000_REALK,     -7.495146242322710_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.137466213310390_REALK,      0.000000000000000_REALK, &
     -9.385428702596126_REALK,      0.000000000000000_REALK,    -35.566816502681014_REALK, &
     -8.191978172828716_REALK,      1.254215992139703_REALK,      0.000000000000000_REALK, &
      3.764487161664786_REALK,      0.000000000000000_REALK,      7.547911485081903_REALK, &
      4.933048980062629_REALK,      0.000000000000000_REALK,      6.788976821099273_REALK, &
      0.000000000000000_REALK,      5.951450713305195_REALK,      0.000000000000000_REALK, &
      7.553937695567864_REALK,      0.000000000000000_REALK,     21.204225409194169_REALK, &
      7.509839013909092_REALK,      0.000000000000000_REALK,     10.475068255851591_REALK, &
      0.000000000000000_REALK,     20.182445831403221_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.581660830345608_REALK, &
      0.000000000000000_REALK,     -7.889317206231479_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -12.812205811996519_REALK,      0.000000000000000_REALK, &
    -19.564070228571573_REALK,      0.000000000000000_REALK,    -20.846801587416589_REALK, &
      0.000000000000000_REALK,    -22.163330968599862_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -44.334470319396857_REALK,      0.000000000000000_REALK, &
    -38.088456713796766_REALK,      0.000000000000000_REALK,    -74.777880637853912_REALK, &
   1631.939744209949822_REALK,     66.678922075088806_REALK,      0.000000000000000_REALK, &
    128.369292562735581_REALK,      0.000000000000000_REALK,    191.578261966378278_REALK, &
     12.009561885415737_REALK,      0.000000000000000_REALK,      8.791064556827514_REALK, &
      0.000000000000000_REALK,     40.434008834936115_REALK,      0.000000000000000_REALK, &
     19.917267796142742_REALK,      0.000000000000000_REALK,     89.173558675782814_REALK, &
      9.810088580821398_REALK,      0.000000000000000_REALK,      2.456927723261620_REALK, &
      0.000000000000000_REALK,      5.395453331119860_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,   -161.233261343850870_REALK, &
      0.000000000000000_REALK,    -17.914231205804722_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -16.154208905158963_REALK,      0.000000000000000_REALK, &
    -63.771817168195319_REALK,      0.000000000000000_REALK,     -4.783772117008109_REALK, &
      0.000000000000000_REALK,     -8.338502140930380_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.326361400534545_REALK,      0.000000000000000_REALK, &
     -9.914530792662015_REALK,      0.000000000000000_REALK,    -65.232498511700086_REALK, &
    151.880563314988393_REALK,     27.080259882614119_REALK,      0.000000000000000_REALK, &
     17.271505975686832_REALK,      0.000000000000000_REALK,     53.489133620763035_REALK, &
      7.896080203772298_REALK,      0.000000000000000_REALK,     10.710925076546836_REALK, &
      0.000000000000000_REALK,      7.289947705231664_REALK,      0.000000000000000_REALK, &
      8.039334085890911_REALK,      0.000000000000000_REALK,     41.495803912284821_REALK, &
      7.058414635254074_REALK,      0.000000000000000_REALK,      4.846163051452691_REALK, &
      0.000000000000000_REALK,     10.956256778319199_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -51.869135307490311_REALK, &
      0.000000000000000_REALK,    -13.905114834447943_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.651719520405454_REALK,      0.000000000000000_REALK, &
    -34.192583113556687_REALK,      0.000000000000000_REALK,     -5.189816932619979_REALK, &
      0.000000000000000_REALK,    -10.787310982432464_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.682648418622781_REALK,      0.000000000000000_REALK, &
     -8.849885510553761_REALK,      0.000000000000000_REALK,    -48.966060817381326_REALK, &
     58.314807334973636_REALK,     20.434169797568266_REALK,      0.000000000000000_REALK, &
     12.645270248112194_REALK,      0.000000000000000_REALK,     34.228743664634948_REALK, &
      8.956612130336497_REALK,      0.000000000000000_REALK,     13.470381663736459_REALK, &
      0.000000000000000_REALK,      8.505538563705132_REALK,      0.000000000000000_REALK, &
      9.809948658989468_REALK,      0.000000000000000_REALK,     37.175568097223696_REALK, &
     10.934024477021602_REALK,      0.000000000000000_REALK,      9.161761627727889_REALK, &
      0.000000000000000_REALK,     19.290485471346052_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -41.292508171176749_REALK, &
      0.000000000000000_REALK,    -19.423154299919059_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -13.576042485843718_REALK,      0.000000000000000_REALK, &
    -38.108530495761059_REALK,      0.000000000000000_REALK,    -10.948874584800778_REALK, &
      0.000000000000000_REALK,    -21.095334447976306_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -10.941021010386971_REALK,      0.000000000000000_REALK, &
    -19.441798819744914_REALK,      0.000000000000000_REALK,    -70.166518450060451_REALK, &
     68.113704025608030_REALK,     43.160243180804045_REALK,      0.000000000000000_REALK, &
     36.655516282707488_REALK,      0.000000000000000_REALK,     55.972492585778092_REALK, &
     37.466163403859824_REALK,      0.000000000000000_REALK,     39.832248422444557_REALK, &
      0.000000000000000_REALK,     46.339798792192802_REALK,      0.000000000000000_REALK, &
     39.811266666927416_REALK,      0.000000000000000_REALK,     78.160219754530303_REALK, &
     74.141595965299175_REALK,      0.000000000000000_REALK,     53.654046251333824_REALK, &
      0.000000000000000_REALK,     73.340277294390361_REALK,      0.000000000000000_REALK, &
    ! results of test 5, ket-major order, YDIPVEL
    268.081400799919891_REALK,    174.035363909044975_REALK,      0.000000000000000_REALK, &
    158.616345528919794_REALK,      0.000000000000000_REALK,     63.606121350670271_REALK, &
    190.803764182147404_REALK,      0.000000000000000_REALK,     52.517716229715788_REALK, &
      0.000000000000000_REALK,    230.377654580037586_REALK,      0.000000000000000_REALK, &
     58.481823440395729_REALK,      0.000000000000000_REALK,     70.354702968744220_REALK, &
    484.690210523204769_REALK,      0.000000000000000_REALK,    135.213631844042283_REALK, &
      0.000000000000000_REALK,    111.650488312102596_REALK,      0.000000000000000_REALK, &
    144.158937528096743_REALK,     21.715090492174152_REALK,      0.000000000000000_REALK, &
    -14.007850403117398_REALK,      0.000000000000000_REALK,     30.629485031450596_REALK, &
    -69.037371553160995_REALK,      0.000000000000000_REALK,      5.653063152095154_REALK, &
      0.000000000000000_REALK,   -164.022232624932315_REALK,      0.000000000000000_REALK, &
     -4.492052927448399_REALK,      0.000000000000000_REALK,     29.466891195056863_REALK, &
   -600.698879868927520_REALK,      0.000000000000000_REALK,    -38.779459012668617_REALK, &
      0.000000000000000_REALK,      9.526263494862029_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -50.607608673017324_REALK, &
      0.000000000000000_REALK,    -32.014912171960987_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -32.853907962456049_REALK,      0.000000000000000_REALK, &
    -39.523852029286438_REALK,      0.000000000000000_REALK,    -37.299824668698484_REALK, &
      0.000000000000000_REALK,    -30.799732108515894_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -72.698254151001990_REALK,      0.000000000000000_REALK, &
    -55.363786971017014_REALK,      0.000000000000000_REALK,   -111.006080135326002_REALK, &
    122.286075202492327_REALK,     -9.572344611272168_REALK,      0.000000000000000_REALK, &
    -17.146748322875830_REALK,      0.000000000000000_REALK,     22.387537455393847_REALK, &
    -35.573058824432330_REALK,      0.000000000000000_REALK,     -2.118411281893910_REALK, &
      0.000000000000000_REALK,    -45.101874832714842_REALK,      0.000000000000000_REALK, &
     -4.693678208371160_REALK,      0.000000000000000_REALK,     18.384808836312008_REALK, &
    -81.714711163707264_REALK,      0.000000000000000_REALK,    -15.701150783286911_REALK, &
      0.000000000000000_REALK,     -2.805057764826317_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -27.425156738343528_REALK, &
      0.000000000000000_REALK,     -4.057971881811810_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.775702226274909_REALK,      0.000000000000000_REALK, &
    -18.208003514771452_REALK,      0.000000000000000_REALK,     13.565661711541690_REALK, &
      0.000000000000000_REALK,     -3.332436068901574_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     44.734336670515503_REALK,      0.000000000000000_REALK, &
      3.675398233197309_REALK,      0.000000000000000_REALK,    -40.183023065153407_REALK, &
     51.657559819178431_REALK,     28.665646300575418_REALK,      0.000000000000000_REALK, &
     23.583715789530544_REALK,      0.000000000000000_REALK,     28.371641335068414_REALK, &
     23.048082479157177_REALK,      0.000000000000000_REALK,     19.031584525616747_REALK, &
      0.000000000000000_REALK,     25.430987124137005_REALK,      0.000000000000000_REALK, &
     19.367119197648464_REALK,      0.000000000000000_REALK,     38.831664220694179_REALK, &
     36.466060089950325_REALK,      0.000000000000000_REALK,     30.518720927844328_REALK, &
      0.000000000000000_REALK,     42.000574051892343_REALK,      0.000000000000000_REALK, &
    112.967069255110957_REALK,    -45.040310344531605_REALK,      0.000000000000000_REALK, &
    -30.838191373128456_REALK,      0.000000000000000_REALK,     18.302201874366201_REALK, &
    -48.331820122646256_REALK,      0.000000000000000_REALK,     -8.538816666172448_REALK, &
      0.000000000000000_REALK,    -57.553152816264060_REALK,      0.000000000000000_REALK, &
     -7.133627264746941_REALK,      0.000000000000000_REALK,     12.701239646270103_REALK, &
   -121.462407871754522_REALK,      0.000000000000000_REALK,    -16.690560652313554_REALK, &
      0.000000000000000_REALK,     -8.846199280562121_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -22.746091741392647_REALK, &
      0.000000000000000_REALK,      1.784628089201305_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.302771658193903_REALK,      0.000000000000000_REALK, &
    -12.936725286703453_REALK,      0.000000000000000_REALK,      6.932345007255728_REALK, &
      0.000000000000000_REALK,      1.238484265227013_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     10.959673282656432_REALK,      0.000000000000000_REALK, &
      3.421665718895505_REALK,      0.000000000000000_REALK,    -22.337374993547041_REALK, &
     31.559276468769632_REALK,      4.122963541282409_REALK,      0.000000000000000_REALK, &
     -2.338354314201049_REALK,      0.000000000000000_REALK,     15.339096236159747_REALK, &
     -9.545665688290645_REALK,      0.000000000000000_REALK,      2.344914779518027_REALK, &
      0.000000000000000_REALK,    -19.751027154063486_REALK,      0.000000000000000_REALK, &
     -1.622755487368680_REALK,      0.000000000000000_REALK,     17.741539022647558_REALK, &
    -51.062146933401657_REALK,      0.000000000000000_REALK,     -9.889293124043032_REALK, &
      0.000000000000000_REALK,      4.048879418645533_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -28.826035822259257_REALK, &
      0.000000000000000_REALK,    -16.032911369344504_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -13.627941573151460_REALK,      0.000000000000000_REALK, &
    -27.324438177264419_REALK,      0.000000000000000_REALK,    -13.474573015194164_REALK, &
      0.000000000000000_REALK,    -18.544020998794444_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -18.539050394451674_REALK,      0.000000000000000_REALK, &
    -23.530873119993736_REALK,      0.000000000000000_REALK,    -66.052164820507798_REALK, &
    132.269150381151718_REALK,    -94.065437100770325_REALK,      0.000000000000000_REALK, &
    -33.008199566534628_REALK,      0.000000000000000_REALK,     17.568136073029471_REALK, &
    -45.059065464197076_REALK,      0.000000000000000_REALK,    -14.661966312102955_REALK, &
      0.000000000000000_REALK,    -28.068422208675038_REALK,      0.000000000000000_REALK, &
     -6.256322823071021_REALK,      0.000000000000000_REALK,      9.989511586443433_REALK, &
    -37.578074839513356_REALK,      0.000000000000000_REALK,    -12.007543477237650_REALK, &
      0.000000000000000_REALK,    -11.721561209092901_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -22.714812963400519_REALK, &
      0.000000000000000_REALK,      8.749902016221135_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.965637532483454_REALK,      0.000000000000000_REALK, &
    -10.621664004972891_REALK,      0.000000000000000_REALK,      9.387197706293769_REALK, &
      0.000000000000000_REALK,      4.975328470131388_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     12.825891340689335_REALK,      0.000000000000000_REALK, &
      4.769250181030952_REALK,      0.000000000000000_REALK,    -14.152545223298370_REALK, &
     33.269132689082063_REALK,     -2.214897067232918_REALK,      0.000000000000000_REALK, &
     -3.384418417792649_REALK,      0.000000000000000_REALK,     13.256529926197084_REALK, &
     -5.797311245540121_REALK,      0.000000000000000_REALK,     -1.035707073250141_REALK, &
      0.000000000000000_REALK,     -6.164000242042247_REALK,      0.000000000000000_REALK, &
     -1.924432213945290_REALK,      0.000000000000000_REALK,     12.563110351537720_REALK, &
     -8.040209604120790_REALK,      0.000000000000000_REALK,     -4.634681131184143_REALK, &
      0.000000000000000_REALK,     -1.379999516591753_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -19.037310615613311_REALK, &
      0.000000000000000_REALK,     -2.402882666219449_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.357061517543908_REALK,      0.000000000000000_REALK, &
    -14.836714500148565_REALK,      0.000000000000000_REALK,      5.561991095728443_REALK, &
      0.000000000000000_REALK,     -2.277193222176212_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     13.204725497163485_REALK,      0.000000000000000_REALK, &
      1.808179442396803_REALK,      0.000000000000000_REALK,    -27.676283298200328_REALK, &
     42.161845717248461_REALK,     19.898402690198154_REALK,      0.000000000000000_REALK, &
     13.964833548922291_REALK,      0.000000000000000_REALK,     27.999916855754069_REALK, &
     11.268379399478285_REALK,      0.000000000000000_REALK,     15.507805996574429_REALK, &
      0.000000000000000_REALK,     10.426835560825714_REALK,      0.000000000000000_REALK, &
     13.234364188268087_REALK,      0.000000000000000_REALK,     37.149424936355366_REALK, &
     10.764087483792657_REALK,      0.000000000000000_REALK,     15.014243433960624_REALK, &
      0.000000000000000_REALK,     28.928131770037503_REALK,      0.000000000000000_REALK, &
    145.996836624073325_REALK,   -198.264262423764819_REALK,      0.000000000000000_REALK, &
    -40.608694137727369_REALK,      0.000000000000000_REALK,     17.139003025243390_REALK, &
    -65.242748222172452_REALK,      0.000000000000000_REALK,    -26.139503699779731_REALK, &
      0.000000000000000_REALK,    -30.888126485271286_REALK,      0.000000000000000_REALK, &
     -6.300683129475772_REALK,      0.000000000000000_REALK,      7.977658196858385_REALK, &
    -59.246813350100140_REALK,      0.000000000000000_REALK,    -13.347424192342570_REALK, &
      0.000000000000000_REALK,    -16.042934436337756_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -25.908377017156603_REALK, &
      0.000000000000000_REALK,     18.363760423821219_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      6.417845484897529_REALK,      0.000000000000000_REALK, &
    -10.247415877417513_REALK,      0.000000000000000_REALK,      8.756291196561296_REALK, &
      0.000000000000000_REALK,      8.547743626304687_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.890515781553314_REALK,      0.000000000000000_REALK, &
      3.938907009073205_REALK,      0.000000000000000_REALK,    -10.482130989138419_REALK, &
     37.774488810997440_REALK,    -12.903802620669488_REALK,      0.000000000000000_REALK, &
     -7.471817632772150_REALK,      0.000000000000000_REALK,     13.303378887771510_REALK, &
     -9.629551754109348_REALK,      0.000000000000000_REALK,     -5.103779050557536_REALK, &
      0.000000000000000_REALK,     -9.353057071783860_REALK,      0.000000000000000_REALK, &
     -3.477892331060445_REALK,      0.000000000000000_REALK,     10.320496226611370_REALK, &
    -14.336470619819607_REALK,      0.000000000000000_REALK,     -5.910068883358306_REALK, &
      0.000000000000000_REALK,     -5.220680139025152_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -19.549892705715333_REALK, &
      0.000000000000000_REALK,      1.297198217317053_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.974116257191086_REALK,      0.000000000000000_REALK, &
    -12.887458548104158_REALK,      0.000000000000000_REALK,      3.379760203640965_REALK, &
      0.000000000000000_REALK,      1.006340525961691_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.880781801695964_REALK,      0.000000000000000_REALK, &
      2.019333014605779_REALK,      0.000000000000000_REALK,    -18.455700669124081_REALK, &
     31.658842095669691_REALK,      3.543619527172108_REALK,      0.000000000000000_REALK, &
     -1.699686935441418_REALK,      0.000000000000000_REALK,     18.582628329493428_REALK, &
     -5.705587842930244_REALK,      0.000000000000000_REALK,      2.335984675421368_REALK, &
      0.000000000000000_REALK,     -9.629315258612799_REALK,      0.000000000000000_REALK, &
     -1.318583252542561_REALK,      0.000000000000000_REALK,     20.182445831403221_REALK, &
    -18.080926818161480_REALK,      0.000000000000000_REALK,     -5.836273247329419_REALK, &
      0.000000000000000_REALK,      3.345285944184851_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -41.292508171176749_REALK, &
      0.000000000000000_REALK,    -19.423154299919059_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -13.576042485843717_REALK,      0.000000000000000_REALK, &
    -38.108530495761059_REALK,      0.000000000000000_REALK,    -10.948874584800777_REALK, &
      0.000000000000000_REALK,    -21.095334447976299_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -10.941021010386971_REALK,      0.000000000000000_REALK, &
    -19.441798819744907_REALK,      0.000000000000000_REALK,    -70.166518450060451_REALK, &
    198.782079067839192_REALK,   -618.235218390498972_REALK,      0.000000000000000_REALK, &
    -43.992043127041207_REALK,      0.000000000000000_REALK,     16.147699755886784_REALK, &
   -115.673363262100239_REALK,      0.000000000000000_REALK,    -57.822712749070078_REALK, &
      0.000000000000000_REALK,    -10.289858387015085_REALK,      0.000000000000000_REALK, &
     -4.899707475797649_REALK,      0.000000000000000_REALK,      5.395453331119860_REALK, &
    -43.570504444004733_REALK,      0.000000000000000_REALK,    -16.575667708777356_REALK, &
      0.000000000000000_REALK,    -24.857496458634589_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -42.038704390991001_REALK, &
      0.000000000000000_REALK,     50.185603788629606_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      9.315957802483425_REALK,      0.000000000000000_REALK, &
    -11.795471315941615_REALK,      0.000000000000000_REALK,     13.951152388000732_REALK, &
      0.000000000000000_REALK,     16.768585447404671_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      6.544389054949806_REALK,      0.000000000000000_REALK, &
      4.004851676346596_REALK,      0.000000000000000_REALK,     -8.451289367217845_REALK, &
     80.731214507358459_REALK,    -45.042800612554110_REALK,      0.000000000000000_REALK, &
    -12.321712545920560_REALK,      0.000000000000000_REALK,     19.674159042496324_REALK, &
    -12.946729365234587_REALK,      0.000000000000000_REALK,    -12.638378615895656_REALK, &
      0.000000000000000_REALK,     -6.156954490104537_REALK,      0.000000000000000_REALK, &
     -4.117070914496795_REALK,      0.000000000000000_REALK,     10.956256778319199_REALK, &
     -5.806014253988650_REALK,      0.000000000000000_REALK,     -5.565689744509520_REALK, &
      0.000000000000000_REALK,     -9.055220597335309_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -32.630650198303186_REALK, &
      0.000000000000000_REALK,      9.798817766312338_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.142283389267276_REALK,      0.000000000000000_REALK, &
    -15.259505258725873_REALK,      0.000000000000000_REALK,      6.177392014154761_REALK, &
      0.000000000000000_REALK,      5.456820967024782_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.945007156075714_REALK,      0.000000000000000_REALK, &
      3.684373753866079_REALK,      0.000000000000000_REALK,    -15.306509381689066_REALK, &
     60.918002720733945_REALK,     -3.181779728610420_REALK,      0.000000000000000_REALK, &
     -3.790133793432318_REALK,      0.000000000000000_REALK,     24.742814399455987_REALK, &
     -4.997188843275743_REALK,      0.000000000000000_REALK,     -1.487938003250785_REALK, &
      0.000000000000000_REALK,     -4.056316598606449_REALK,      0.000000000000000_REALK, &
     -2.110671107991641_REALK,      0.000000000000000_REALK,     19.290485471346052_REALK, &
     -3.726766613187118_REALK,      0.000000000000000_REALK,     -3.580415551524280_REALK, &
      0.000000000000000_REALK,     -1.492521324903787_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -45.579641826344528_REALK, &
      0.000000000000000_REALK,     -4.484890100572001_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.949608588040498_REALK,      0.000000000000000_REALK, &
    -29.841020386610591_REALK,      0.000000000000000_REALK,      6.100258467713711_REALK, &
      0.000000000000000_REALK,     -3.496599292583713_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     10.201004812508831_REALK,      0.000000000000000_REALK, &
      1.955614001731741_REALK,      0.000000000000000_REALK,    -38.485208838328575_REALK, &
    128.668589796520479_REALK,     47.641291663947740_REALK,      0.000000000000000_REALK, &
     26.064836465043374_REALK,      0.000000000000000_REALK,     73.165108044621718_REALK, &
     16.188602334168454_REALK,      0.000000000000000_REALK,     31.190783841715476_REALK, &
      0.000000000000000_REALK,     11.435903227215629_REALK,      0.000000000000000_REALK, &
     20.321186629156664_REALK,      0.000000000000000_REALK,     73.340277294390347_REALK, &
      8.315546449490537_REALK,      0.000000000000000_REALK,     16.238468371226396_REALK, &
      0.000000000000000_REALK,     40.225964609379986_REALK,      0.000000000000000_REALK, &
    ! results of test 5, ket-major order, ZDIPVEL
      0.000000000000000_REALK,      0.000000000000000_REALK,    -71.646396619838185_REALK, &
      0.000000000000000_REALK,    -66.483141539920339_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -99.111811226098368_REALK,      0.000000000000000_REALK, &
    -64.861043905918038_REALK,      0.000000000000000_REALK,   -161.393834429899812_REALK, &
      0.000000000000000_REALK,    -73.536973740040580_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,   -572.275483209269282_REALK,      0.000000000000000_REALK, &
   -210.707603363557325_REALK,      0.000000000000000_REALK,   -229.819819050918937_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -50.607608673017317_REALK, &
      0.000000000000000_REALK,    -32.014912171960987_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -32.853907962456063_REALK,      0.000000000000000_REALK, &
    -39.523852029286431_REALK,      0.000000000000000_REALK,    -37.299824668698484_REALK, &
      0.000000000000000_REALK,    -30.799732108515890_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -72.698254151001990_REALK,      0.000000000000000_REALK, &
    -55.363786971017014_REALK,      0.000000000000000_REALK,   -111.006080135325973_REALK, &
    -59.346952150658275_REALK,    -50.607608673017317_REALK,      0.000000000000000_REALK, &
    -57.804184117816604_REALK,      0.000000000000000_REALK,     13.750159185285716_REALK, &
    -86.744200991959303_REALK,      0.000000000000000_REALK,     14.366441000216813_REALK, &
      0.000000000000000_REALK,   -151.035428973562375_REALK,      0.000000000000000_REALK, &
     20.213607522666855_REALK,      0.000000000000000_REALK,     38.587345497901389_REALK, &
   -471.319534588135070_REALK,      0.000000000000000_REALK,     53.133586634013348_REALK, &
      0.000000000000000_REALK,     70.620453091746384_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -50.516463188864023_REALK, &
      0.000000000000000_REALK,    -23.400166364043397_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -20.650570436029948_REALK,      0.000000000000000_REALK, &
    -33.538693983493879_REALK,      0.000000000000000_REALK,    -21.295328997903074_REALK, &
      0.000000000000000_REALK,    -19.216387072406029_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -39.513674176625884_REALK,      0.000000000000000_REALK, &
    -27.344096703399018_REALK,      0.000000000000000_REALK,    -74.016138717269598_REALK, &
    -49.422108258305215_REALK,    -27.425156738343524_REALK,      0.000000000000000_REALK, &
    -22.563143883744878_REALK,      0.000000000000000_REALK,      9.866469333135338_REALK, &
    -22.050689800650556_REALK,      0.000000000000000_REALK,      6.618388512154012_REALK, &
      0.000000000000000_REALK,    -24.330475600553722_REALK,      0.000000000000000_REALK, &
      6.735073426949993_REALK,      0.000000000000000_REALK,     23.635082175148799_REALK, &
    -34.888012051438238_REALK,      0.000000000000000_REALK,     10.613133747355885_REALK, &
      0.000000000000000_REALK,     25.563854628483188_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     10.779631264129824_REALK, &
      0.000000000000000_REALK,      9.029446852836827_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     10.936002332034318_REALK,      0.000000000000000_REALK, &
     -8.512969108415160_REALK,      0.000000000000000_REALK,     16.274030495212610_REALK, &
      0.000000000000000_REALK,     -8.820188789819186_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     39.329194890491927_REALK,      0.000000000000000_REALK, &
    -17.224795105780448_REALK,      0.000000000000000_REALK,    -53.368528725850112_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -60.349185952614846_REALK, &
      0.000000000000000_REALK,    -19.130043647801532_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -14.474656151860151_REALK,      0.000000000000000_REALK, &
    -34.323296011526629_REALK,      0.000000000000000_REALK,    -10.645016017012454_REALK, &
      0.000000000000000_REALK,    -13.275739743349789_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -13.224215992567705_REALK,      0.000000000000000_REALK, &
    -14.995718709389532_REALK,      0.000000000000000_REALK,    -59.264792057693690_REALK, &
    -55.615806156436840_REALK,    -22.746091741392647_REALK,      0.000000000000000_REALK, &
    -16.643968179501520_REALK,      0.000000000000000_REALK,      9.825641173121500_REALK, &
    -14.336296417105237_REALK,      0.000000000000000_REALK,      4.702342788595687_REALK, &
      0.000000000000000_REALK,    -16.691043114473906_REALK,      0.000000000000000_REALK, &
      4.198455697024438_REALK,      0.000000000000000_REALK,     19.890523896039888_REALK, &
    -29.542402083184026_REALK,      0.000000000000000_REALK,      5.398659419156672_REALK, &
      0.000000000000000_REALK,     14.210712971771084_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.777058388962942_REALK, &
      0.000000000000000_REALK,      4.881760367658329_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.149486236902592_REALK,      0.000000000000000_REALK, &
     -5.937867452441230_REALK,      0.000000000000000_REALK,      4.102788009074026_REALK, &
      0.000000000000000_REALK,     -4.029796990217645_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.644838880772461_REALK,      0.000000000000000_REALK, &
     -5.113488691708699_REALK,      0.000000000000000_REALK,    -29.124747756361163_REALK, &
    -38.976706597947029_REALK,    -28.826035822259257_REALK,      0.000000000000000_REALK, &
    -28.948052575009086_REALK,      0.000000000000000_REALK,     -5.743500871593929_REALK, &
    -35.981865666605927_REALK,      0.000000000000000_REALK,     -4.970514083809957_REALK, &
      0.000000000000000_REALK,    -54.561594690103163_REALK,      0.000000000000000_REALK, &
     -6.090612071603113_REALK,      0.000000000000000_REALK,      8.625241879119585_REALK, &
   -120.192935933090965_REALK,      0.000000000000000_REALK,    -11.301641439584259_REALK, &
      0.000000000000000_REALK,     11.143257357312541_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -91.329855070638999_REALK, &
      0.000000000000000_REALK,    -18.362774719378336_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -13.789890138531389_REALK,      0.000000000000000_REALK, &
    -42.706714589560590_REALK,      0.000000000000000_REALK,     -7.697353715964177_REALK, &
      0.000000000000000_REALK,    -10.441355306900729_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -9.996739721462651_REALK,      0.000000000000000_REALK, &
    -11.024376804906083_REALK,      0.000000000000000_REALK,    -56.903391905851869_REALK, &
    -84.448801302326629_REALK,    -22.714812963400515_REALK,      0.000000000000000_REALK, &
    -14.190612362043597_REALK,      0.000000000000000_REALK,     12.231276833085117_REALK, &
     -8.516872554457844_REALK,      0.000000000000000_REALK,      3.860846081968408_REALK, &
      0.000000000000000_REALK,     -7.115777401523779_REALK,      0.000000000000000_REALK, &
      2.932983596689775_REALK,      0.000000000000000_REALK,     20.287704818200382_REALK, &
     -5.741661436231061_REALK,      0.000000000000000_REALK,      2.474932279009892_REALK, &
      0.000000000000000_REALK,      9.003643357664146_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     10.677104168671530_REALK, &
      0.000000000000000_REALK,      4.218971014330597_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.074133897940817_REALK,      0.000000000000000_REALK, &
     -5.938828935456613_REALK,      0.000000000000000_REALK,      2.658506496656801_REALK, &
      0.000000000000000_REALK,     -2.853573425494394_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.551402167368902_REALK,      0.000000000000000_REALK, &
     -2.923344275010952_REALK,      0.000000000000000_REALK,    -22.478467671456915_REALK, &
    -40.337315790789816_REALK,    -19.037310615613311_REALK,      0.000000000000000_REALK, &
    -13.360513308795834_REALK,      0.000000000000000_REALK,     -4.872975071975088_REALK, &
    -10.780746681145290_REALK,      0.000000000000000_REALK,     -2.698906301459367_REALK, &
      0.000000000000000_REALK,     -9.975620174132931_REALK,      0.000000000000000_REALK, &
     -2.303247081593286_REALK,      0.000000000000000_REALK,      5.996040818381408_REALK, &
    -10.298277711684792_REALK,      0.000000000000000_REALK,     -2.613008972675587_REALK, &
      0.000000000000000_REALK,      4.669096740792727_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     23.157189929675553_REALK, &
      0.000000000000000_REALK,     16.546652712571142_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     16.546674754661304_REALK,      0.000000000000000_REALK, &
      5.279118268915298_REALK,      0.000000000000000_REALK,     20.649517417036993_REALK, &
      0.000000000000000_REALK,      4.586916772336586_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     35.927657853495397_REALK,      0.000000000000000_REALK, &
      6.449055474232404_REALK,      0.000000000000000_REALK,    -13.970483217551541_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,   -161.233261343850870_REALK, &
      0.000000000000000_REALK,    -17.914231205804722_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -16.154208905158967_REALK,      0.000000000000000_REALK, &
    -63.771817168195312_REALK,      0.000000000000000_REALK,     -4.783772117008108_REALK, &
      0.000000000000000_REALK,     -8.338502140930379_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.326361400534545_REALK,      0.000000000000000_REALK, &
     -9.914530792662013_REALK,      0.000000000000000_REALK,    -65.232498511700072_REALK, &
   -145.308018202186844_REALK,    -25.908377017156603_REALK,      0.000000000000000_REALK, &
    -16.524091364405759_REALK,      0.000000000000000_REALK,     18.601281832536049_REALK, &
     -7.554381817745369_REALK,      0.000000000000000_REALK,      3.724811425225386_REALK, &
      0.000000000000000_REALK,     -6.974479358809810_REALK,      0.000000000000000_REALK, &
      2.795743900767207_REALK,      0.000000000000000_REALK,     25.256623816499925_REALK, &
     -6.752965750930061_REALK,      0.000000000000000_REALK,      1.685292668331846_REALK, &
      0.000000000000000_REALK,      6.668579224827673_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     15.793306855856832_REALK, &
      0.000000000000000_REALK,      4.233880980365026_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.634307674622794_REALK,      0.000000000000000_REALK, &
     -7.430382468167779_REALK,      0.000000000000000_REALK,      1.580214724164732_REALK, &
      0.000000000000000_REALK,     -2.344188098814930_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.425790172421145_REALK,      0.000000000000000_REALK, &
     -1.923166609686150_REALK,      0.000000000000000_REALK,    -21.590877056100510_REALK, &
    -55.791267169017324_REALK,    -19.549892705715333_REALK,      0.000000000000000_REALK, &
    -12.098053360346791_REALK,      0.000000000000000_REALK,     -5.957011068356593_REALK, &
     -8.569019827545160_REALK,      0.000000000000000_REALK,     -2.344322463367912_REALK, &
      0.000000000000000_REALK,     -8.137466213310390_REALK,      0.000000000000000_REALK, &
     -1.707277757961889_REALK,      0.000000000000000_REALK,      6.000260411550254_REALK, &
    -10.460860778052041_REALK,      0.000000000000000_REALK,     -1.594470307083116_REALK, &
      0.000000000000000_REALK,      3.113548554001714_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     23.345977032373213_REALK, &
      0.000000000000000_REALK,     10.981471803610930_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      7.675629069349364_REALK,      0.000000000000000_REALK, &
      4.501718635143991_REALK,      0.000000000000000_REALK,      6.190279687721118_REALK, &
      0.000000000000000_REALK,      2.491968568811993_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      6.185839430250521_REALK,      0.000000000000000_REALK, &
      2.296638230574161_REALK,      0.000000000000000_REALK,     -9.145798153545963_REALK, &
    -65.166122170911677_REALK,    -41.292508171176756_REALK,      0.000000000000000_REALK, &
    -35.069269635060579_REALK,      0.000000000000000_REALK,    -22.258084089929476_REALK, &
    -35.844836462473900_REALK,      0.000000000000000_REALK,    -15.839736519130879_REALK, &
      0.000000000000000_REALK,    -44.334470319396864_REALK,      0.000000000000000_REALK, &
    -15.831392890732712_REALK,      0.000000000000000_REALK,     -6.805391574572039_REALK, &
    -70.933160510616204_REALK,      0.000000000000000_REALK,    -21.336128123952694_REALK, &
      0.000000000000000_REALK,     -6.385720341415646_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,   -469.904924497791228_REALK, &
      0.000000000000000_REALK,    -16.878089492300809_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -29.448937919381731_REALK,      0.000000000000000_REALK, &
   -131.848736502003874_REALK,      0.000000000000000_REALK,     -2.568059018697501_REALK, &
      0.000000000000000_REALK,     -5.639499467469042_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.566912758314405_REALK,      0.000000000000000_REALK, &
    -12.659850000782846_REALK,      0.000000000000000_REALK,    -94.467766063279214_REALK, &
   -480.665882221765855_REALK,    -42.038704390991001_REALK,      0.000000000000000_REALK, &
    -29.672551430849147_REALK,      0.000000000000000_REALK,     42.578260790628818_REALK, &
     -6.767024320974095_REALK,      0.000000000000000_REALK,      4.287510807515904_REALK, &
      0.000000000000000_REALK,     -6.326361400534544_REALK,      0.000000000000000_REALK, &
      3.603811733028169_REALK,      0.000000000000000_REALK,     41.499966448566660_REALK, &
     -1.388619760914135_REALK,      0.000000000000000_REALK,      1.057417734256099_REALK, &
      0.000000000000000_REALK,      5.376587332827091_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     39.947848711040365_REALK, &
      0.000000000000000_REALK,      6.261420386310239_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.619295276943769_REALK,      0.000000000000000_REALK, &
    -13.332859860140267_REALK,      0.000000000000000_REALK,      1.542320770113038_REALK, &
      0.000000000000000_REALK,     -2.488594170605030_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.410870899115306_REALK,      0.000000000000000_REALK, &
     -1.850746264400700_REALK,      0.000000000000000_REALK,    -27.136565574699208_REALK, &
   -154.631392275101604_REALK,    -32.630650198303186_REALK,      0.000000000000000_REALK, &
    -15.891746475590484_REALK,      0.000000000000000_REALK,    -11.424867584908135_REALK, &
     -7.341406853302884_REALK,      0.000000000000000_REALK,     -2.775815016155714_REALK, &
      0.000000000000000_REALK,     -4.682648418622781_REALK,      0.000000000000000_REALK, &
     -1.609858555368732_REALK,      0.000000000000000_REALK,      8.260765092932846_REALK, &
     -2.661352526655902_REALK,      0.000000000000000_REALK,     -0.956834957354930_REALK, &
      0.000000000000000_REALK,      2.582267723484568_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     47.467407962682088_REALK, &
      0.000000000000000_REALK,     14.621856168664570_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      8.200633421672466_REALK,      0.000000000000000_REALK, &
      6.493123045195934_REALK,      0.000000000000000_REALK,      5.414176358820876_REALK, &
      0.000000000000000_REALK,      2.381836367766757_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.094366143505583_REALK,      0.000000000000000_REALK, &
      1.718693609789213_REALK,      0.000000000000000_REALK,     -9.239944235948949_REALK, &
   -123.100529653865436_REALK,    -45.579641826344528_REALK,      0.000000000000000_REALK, &
    -24.936895471244174_REALK,      0.000000000000000_REALK,    -29.094918808739113_REALK, &
    -15.488049762909812_REALK,      0.000000000000000_REALK,    -12.403362035660281_REALK, &
      0.000000000000000_REALK,    -10.941021010386971_REALK,      0.000000000000000_REALK, &
     -8.080945834344458_REALK,      0.000000000000000_REALK,     -6.385720341415646_REALK, &
     -7.955695899927299_REALK,      0.000000000000000_REALK,     -6.457407519318764_REALK, &
      0.000000000000000_REALK,     -3.502465083791431_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     92.971769271573592_REALK, &
      0.000000000000000_REALK,     51.788021390692606_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     39.861950943233893_REALK,      0.000000000000000_REALK, &
     35.187605239459280_REALK,      0.000000000000000_REALK,     37.977623066812939_REALK, &
      0.000000000000000_REALK,     23.340987861124610_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     46.541717658170157_REALK,      0.000000000000000_REALK, &
     23.114798569944799_REALK,      0.000000000000000_REALK,     12.260336615196316_REALK, &
    ! results of test 6, ket-major order, dd/dxdx
    174.976487279415153_REALK,     83.425475493187960_REALK,      0.000000000000000_REALK, &
    -52.612579125725922_REALK,      0.000000000000000_REALK,    -11.476959750345431_REALK, &
   -102.139183985921591_REALK,      0.000000000000000_REALK,    -15.512791049574323_REALK, &
      0.000000000000000_REALK,   -637.827306098159511_REALK,      0.000000000000000_REALK, &
    -78.281100024357670_REALK,      0.000000000000000_REALK,    -51.228948425739524_REALK, &
   -451.285870818400383_REALK,      0.000000000000000_REALK,    -46.654575844686214_REALK, &
      0.000000000000000_REALK,    -21.257542649397678_REALK,      0.000000000000000_REALK, &
     49.486840642074228_REALK,     -0.392414163477017_REALK,      0.000000000000000_REALK, &
    -35.815628031111579_REALK,      0.000000000000000_REALK,    -14.362285142813327_REALK, &
    -41.683640362618853_REALK,      0.000000000000000_REALK,    -11.473199207410453_REALK, &
      0.000000000000000_REALK,    -87.417205732909395_REALK,      0.000000000000000_REALK, &
    -22.191030638992121_REALK,      0.000000000000000_REALK,    -26.696215633012898_REALK, &
    -13.194296716646241_REALK,      0.000000000000000_REALK,     -3.680802170029073_REALK, &
      0.000000000000000_REALK,     -3.039363369353210_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.161547976021758_REALK, &
      0.000000000000000_REALK,     15.011917339246649_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     21.652303939310880_REALK,      0.000000000000000_REALK, &
     14.169764623392510_REALK,      0.000000000000000_REALK,     61.241173993635179_REALK, &
      0.000000000000000_REALK,     27.903733867449965_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     15.578553816827510_REALK,      0.000000000000000_REALK, &
      5.735908377912416_REALK,      0.000000000000000_REALK,      6.256183471604487_REALK, &
      4.055692875547155_REALK,    -20.217718311920571_REALK,      0.000000000000000_REALK, &
    -31.559393663608567_REALK,      0.000000000000000_REALK,    -17.085255984690878_REALK, &
    -30.205947885746198_REALK,      0.000000000000000_REALK,     -9.085704295663144_REALK, &
      0.000000000000000_REALK,    -46.856938930490386_REALK,      0.000000000000000_REALK, &
    -10.808584589504921_REALK,      0.000000000000000_REALK,    -17.554275900758352_REALK, &
      8.702014755151014_REALK,      0.000000000000000_REALK,      1.458306317773701_REALK, &
      0.000000000000000_REALK,      1.315940161113924_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.171022428294382_REALK, &
      0.000000000000000_REALK,      9.695055316538909_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      9.156971985715879_REALK,      0.000000000000000_REALK, &
     11.016004738716010_REALK,      0.000000000000000_REALK,     12.063451219110691_REALK, &
      0.000000000000000_REALK,      9.961201403838219_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.741516611178089_REALK,      0.000000000000000_REALK, &
     -1.326262312537560_REALK,      0.000000000000000_REALK,     -2.659196355608380_REALK, &
      0.947437801026942_REALK,     -8.540612587131669_REALK,      0.000000000000000_REALK, &
    -18.296578018670360_REALK,      0.000000000000000_REALK,    -11.973700566220096_REALK, &
    -25.270737702768500_REALK,      0.000000000000000_REALK,    -11.514278605525631_REALK, &
      0.000000000000000_REALK,    -51.057110747167634_REALK,      0.000000000000000_REALK, &
    -18.798850825956837_REALK,      0.000000000000000_REALK,    -20.503999030980573_REALK, &
     11.801350242380725_REALK,      0.000000000000000_REALK,      3.660121170785002_REALK, &
      0.000000000000000_REALK,      2.779476628006799_REALK,      0.000000000000000_REALK, &
    -94.117068724294867_REALK,    -35.890080899627080_REALK,      0.000000000000000_REALK, &
    -28.527723202527849_REALK,      0.000000000000000_REALK,    -22.548963690798431_REALK, &
    -16.713073859908196_REALK,      0.000000000000000_REALK,     -6.947802881678030_REALK, &
      0.000000000000000_REALK,    -13.533350455121559_REALK,      0.000000000000000_REALK, &
     -5.115421504877861_REALK,      0.000000000000000_REALK,    -12.130037818762844_REALK, &
      6.021495233625277_REALK,      0.000000000000000_REALK,      2.380229881014219_REALK, &
      0.000000000000000_REALK,      2.968460768794373_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     17.669359711765637_REALK, &
      0.000000000000000_REALK,      8.883305073150854_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      6.318311363511973_REALK,      0.000000000000000_REALK, &
     10.261600858421572_REALK,      0.000000000000000_REALK,      5.295692514570337_REALK, &
      0.000000000000000_REALK,      4.778704155566106_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.900934716251995_REALK,      0.000000000000000_REALK, &
     -2.699509431546095_REALK,      0.000000000000000_REALK,     -7.307144453195862_REALK, &
    -14.985134439994926_REALK,    -10.026505892969285_REALK,      0.000000000000000_REALK, &
     -8.952985156498867_REALK,      0.000000000000000_REALK,    -10.770604853164807_REALK, &
     -7.051861443068992_REALK,      0.000000000000000_REALK,     -5.822961508319495_REALK, &
      0.000000000000000_REALK,     -6.324142170552435_REALK,      0.000000000000000_REALK, &
     -4.816188008829432_REALK,      0.000000000000000_REALK,     -9.656603735123705_REALK, &
      3.600063085350004_REALK,      0.000000000000000_REALK,      3.012919968689182_REALK, &
      0.000000000000000_REALK,      4.146450585414280_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     12.383052532258715_REALK, &
      0.000000000000000_REALK,     11.257778838230687_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     10.989134776253808_REALK,      0.000000000000000_REALK, &
     11.985903334713782_REALK,      0.000000000000000_REALK,     13.291361389791614_REALK, &
      0.000000000000000_REALK,     10.093389429889948_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -12.751822485925112_REALK,      0.000000000000000_REALK, &
     -7.825211322639214_REALK,      0.000000000000000_REALK,    -11.948995053309297_REALK, &
   -156.649938336140139_REALK,    -36.757820418834619_REALK,      0.000000000000000_REALK, &
    -26.122310227259838_REALK,      0.000000000000000_REALK,    -26.966568408411216_REALK, &
    -10.216257435953912_REALK,      0.000000000000000_REALK,     -4.619404613229888_REALK, &
      0.000000000000000_REALK,     -5.702266755953119_REALK,      0.000000000000000_REALK, &
     -2.096147981284670_REALK,      0.000000000000000_REALK,     -6.491682868747044_REALK, &
     12.845100713761267_REALK,      0.000000000000000_REALK,      2.939727766454632_REALK, &
      0.000000000000000_REALK,      3.987700610854629_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     23.468464595952451_REALK, &
      0.000000000000000_REALK,      7.010269283262416_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.731311047300954_REALK,      0.000000000000000_REALK, &
      8.847940306418375_REALK,      0.000000000000000_REALK,      1.353174799096909_REALK, &
      0.000000000000000_REALK,      1.687587546262044_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.840538263078837_REALK,      0.000000000000000_REALK, &
     -3.221053921104131_REALK,      0.000000000000000_REALK,    -12.729972770249866_REALK, &
    -20.048672399162786_REALK,     -9.245548197381646_REALK,      0.000000000000000_REALK, &
     -6.375118124108067_REALK,      0.000000000000000_REALK,    -10.353861000373964_REALK, &
     -3.862805042337770_REALK,      0.000000000000000_REALK,     -3.485701342586143_REALK, &
      0.000000000000000_REALK,     -2.217704513777977_REALK,      0.000000000000000_REALK, &
     -1.534687116496533_REALK,      0.000000000000000_REALK,     -4.154154943728453_REALK, &
      6.632681363157962_REALK,      0.000000000000000_REALK,      3.334566100320966_REALK, &
      0.000000000000000_REALK,      5.015052276534519_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     11.209808226204194_REALK, &
      0.000000000000000_REALK,      5.875314670633344_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.513042963534385_REALK,      0.000000000000000_REALK, &
      7.043758204854920_REALK,      0.000000000000000_REALK,      1.712862864988836_REALK, &
      0.000000000000000_REALK,      2.357281740994039_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.982155315383788_REALK,      0.000000000000000_REALK, &
     -5.054390029515642_REALK,      0.000000000000000_REALK,    -14.187888464411865_REALK, &
    -14.050524046752232_REALK,    -11.716848176126737_REALK,      0.000000000000000_REALK, &
    -11.087936040148133_REALK,      0.000000000000000_REALK,    -12.093666359055232_REALK, &
     -9.695037552645029_REALK,      0.000000000000000_REALK,     -7.362360159088840_REALK, &
      0.000000000000000_REALK,     -7.249486685361078_REALK,      0.000000000000000_REALK, &
     -4.448679030485595_REALK,      0.000000000000000_REALK,     -6.793074530171895_REALK, &
     26.984990722891496_REALK,      0.000000000000000_REALK,     13.948733804430498_REALK, &
      0.000000000000000_REALK,     14.829632382892612_REALK,      0.000000000000000_REALK, &
   -583.847917824442447_REALK,    -51.156242423761952_REALK,      0.000000000000000_REALK, &
    -31.525415065919105_REALK,      0.000000000000000_REALK,    -41.484193944716921_REALK, &
     -4.151383744987715_REALK,      0.000000000000000_REALK,     -2.412066001383413_REALK, &
      0.000000000000000_REALK,      1.521581428612797_REALK,      0.000000000000000_REALK, &
      0.794862690279311_REALK,      0.000000000000000_REALK,      3.137871898024292_REALK, &
      3.718492915818078_REALK,      0.000000000000000_REALK,      2.596683529944714_REALK, &
      0.000000000000000_REALK,      4.526229645592869_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     50.914885398563449_REALK, &
      0.000000000000000_REALK,      6.967562050660868_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.325526107039728_REALK,      0.000000000000000_REALK, &
      7.202057356962719_REALK,      0.000000000000000_REALK,     -0.388524104787779_REALK, &
      0.000000000000000_REALK,     -0.527027647822806_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.957062894578772_REALK,      0.000000000000000_REALK, &
     -4.363837971782862_REALK,      0.000000000000000_REALK,    -22.524373641827218_REALK, &
    -62.608435331980694_REALK,    -13.235909432920110_REALK,      0.000000000000000_REALK, &
     -5.628028594405349_REALK,      0.000000000000000_REALK,    -13.345566857025906_REALK, &
     -1.501250556155625_REALK,      0.000000000000000_REALK,     -1.872257556139842_REALK, &
      0.000000000000000_REALK,      0.375414893301199_REALK,      0.000000000000000_REALK, &
      0.425705096046846_REALK,      0.000000000000000_REALK,      1.682435132590181_REALK, &
      2.375553240086829_REALK,      0.000000000000000_REALK,      2.817089071707480_REALK, &
      0.000000000000000_REALK,      5.855469716227421_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     19.548859101489018_REALK, &
      0.000000000000000_REALK,      5.257569411647508_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.702625476548129_REALK,      0.000000000000000_REALK, &
      4.608737484463270_REALK,      0.000000000000000_REALK,     -0.440707239550058_REALK, &
      0.000000000000000_REALK,     -0.662805827954056_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.616898832441875_REALK,      0.000000000000000_REALK, &
     -5.324946817979459_REALK,      0.000000000000000_REALK,    -20.179302657663637_REALK, &
    -29.905175540766017_REALK,    -11.093030770740906_REALK,      0.000000000000000_REALK, &
     -5.298809453703345_REALK,      0.000000000000000_REALK,    -10.624274440394396_REALK, &
     -1.900298712626742_REALK,      0.000000000000000_REALK,     -2.615235317007526_REALK, &
      0.000000000000000_REALK,      0.526294763307724_REALK,      0.000000000000000_REALK, &
      0.668004834962717_REALK,      0.000000000000000_REALK,      1.875118072961043_REALK, &
      4.260806259131416_REALK,      0.000000000000000_REALK,      5.943168196641391_REALK, &
      0.000000000000000_REALK,     11.450776955904606_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     22.833740926698695_REALK, &
      0.000000000000000_REALK,     11.104829635587508_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.935490871638729_REALK,      0.000000000000000_REALK, &
      7.536429826533312_REALK,      0.000000000000000_REALK,     -1.843510605346058_REALK, &
      0.000000000000000_REALK,     -1.959933063068591_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -25.153746742413034_REALK,      0.000000000000000_REALK, &
    -21.609988505243049_REALK,      0.000000000000000_REALK,    -42.426217296567842_REALK, &
   -228.039679589211119_REALK,      3.178077221199665_REALK,      0.000000000000000_REALK, &
     28.157451758629890_REALK,      0.000000000000000_REALK,     42.022165594502837_REALK, &
      4.700154437409890_REALK,      0.000000000000000_REALK,      3.440538587548925_REALK, &
      0.000000000000000_REALK,     22.940768451438903_REALK,      0.000000000000000_REALK, &
     11.300324698495439_REALK,      0.000000000000000_REALK,     50.593795186698962_REALK, &
      7.970106155490207_REALK,      0.000000000000000_REALK,      1.996105805715607_REALK, &
      0.000000000000000_REALK,      4.383480888244738_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -7.684763628895877_REALK, &
      0.000000000000000_REALK,     -3.929437413732517_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.322235348204869_REALK,      0.000000000000000_REALK, &
    -24.958228476992389_REALK,      0.000000000000000_REALK,     -2.714136233899997_REALK, &
      0.000000000000000_REALK,     -4.730959218706755_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.139787630341072_REALK,      0.000000000000000_REALK, &
     -8.054959162537592_REALK,      0.000000000000000_REALK,    -52.997476387983298_REALK, &
    -21.223084441114672_REALK,      1.290710083468133_REALK,      0.000000000000000_REALK, &
      3.788457399744715_REALK,      0.000000000000000_REALK,     11.732694552332179_REALK, &
      3.090270632850819_REALK,      0.000000000000000_REALK,      4.191909955385833_REALK, &
      0.000000000000000_REALK,      4.136048023621158_REALK,      0.000000000000000_REALK, &
      4.561222275067424_REALK,      0.000000000000000_REALK,     23.543191899278877_REALK, &
      5.734536795357900_REALK,      0.000000000000000_REALK,      3.937215617237401_REALK, &
      0.000000000000000_REALK,      8.901298787528546_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.472207292409783_REALK, &
      0.000000000000000_REALK,     -3.050048748674300_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.386003443176544_REALK,      0.000000000000000_REALK, &
    -13.381872109993846_REALK,      0.000000000000000_REALK,     -2.944511117921161_REALK, &
      0.000000000000000_REALK,     -6.120323227703970_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.804369825795907_REALK,      0.000000000000000_REALK, &
     -7.189998989503750_REALK,      0.000000000000000_REALK,    -39.781975413930660_REALK, &
     -8.148640308047526_REALK,      0.973941502753235_REALK,      0.000000000000000_REALK, &
      2.773705298812385_REALK,      0.000000000000000_REALK,      7.507980913928067_REALK, &
      3.505328558211851_REALK,      0.000000000000000_REALK,      5.271872092794835_REALK, &
      0.000000000000000_REALK,      4.825729537263972_REALK,      0.000000000000000_REALK, &
      5.565803816908043_REALK,      0.000000000000000_REALK,     21.092049102789769_REALK, &
      8.883236381673303_REALK,      0.000000000000000_REALK,      7.443379551846417_REALK, &
      0.000000000000000_REALK,     15.672357668425493_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.968099896354587_REALK, &
      0.000000000000000_REALK,     -4.260415550183982_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.313224324177305_REALK,      0.000000000000000_REALK, &
    -14.914447373000151_REALK,      0.000000000000000_REALK,     -6.211988469388079_REALK, &
      0.000000000000000_REALK,    -11.968716358357884_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.888920643663702_REALK,      0.000000000000000_REALK, &
    -15.795290651093893_REALK,      0.000000000000000_REALK,    -57.006070434617754_REALK, &
     -9.517892616282611_REALK,      2.057120622914161_REALK,      0.000000000000000_REALK, &
      8.040286822595027_REALK,      0.000000000000000_REALK,     12.277412520787129_REALK, &
     14.663045651084534_REALK,      0.000000000000000_REALK,     15.589054868198046_REALK, &
      0.000000000000000_REALK,     26.291496312367634_REALK,      0.000000000000000_REALK, &
     22.587447465148497_REALK,      0.000000000000000_REALK,     44.345232025398637_REALK, &
     60.235581515148922_REALK,      0.000000000000000_REALK,     43.590681243258125_REALK, &
      0.000000000000000_REALK,     59.584558354766315_REALK,      0.000000000000000_REALK, &
    ! results of test 6, ket-major order, dd/dxdy
   -280.602821009373656_REALK,   -136.234743431554449_REALK,      0.000000000000000_REALK, &
   -110.963881217691934_REALK,      0.000000000000000_REALK,    -44.497192712002217_REALK, &
    -63.414321266148697_REALK,      0.000000000000000_REALK,    -17.454452973875007_REALK, &
      0.000000000000000_REALK,    -69.608179852298051_REALK,      0.000000000000000_REALK, &
    -17.670174182258322_REALK,      0.000000000000000_REALK,    -21.257542649397678_REALK, &
    164.933660696234085_REALK,      0.000000000000000_REALK,     46.011408507709277_REALK, &
      0.000000000000000_REALK,     37.993182771236420_REALK,      0.000000000000000_REALK, &
   -128.156690029150724_REALK,    -14.330732114057307_REALK,      0.000000000000000_REALK, &
      7.142310178904210_REALK,      0.000000000000000_REALK,    -15.617334310340601_REALK, &
     15.702740339517355_REALK,      0.000000000000000_REALK,     -1.285804786642102_REALK, &
      0.000000000000000_REALK,     16.918078065981348_REALK,      0.000000000000000_REALK, &
      0.463332932901074_REALK,      0.000000000000000_REALK,     -3.039363369353210_REALK, &
   -250.218363293270272_REALK,      0.000000000000000_REALK,    -16.153405789046364_REALK, &
      0.000000000000000_REALK,      3.968121366407270_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     33.398160743904029_REALK, &
      0.000000000000000_REALK,     16.323734656077828_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      7.472711869912259_REALK,      0.000000000000000_REALK, &
      8.989809021849620_REALK,      0.000000000000000_REALK,      3.847291525627825_REALK, &
      0.000000000000000_REALK,      3.176839285042009_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -30.282124334759970_REALK,      0.000000000000000_REALK, &
    -23.061531535780269_REALK,      0.000000000000000_REALK,    -46.239073549002690_REALK, &
    -79.868424493305824_REALK,      4.636516213361050_REALK,      0.000000000000000_REALK, &
      5.584554153487782_REALK,      0.000000000000000_REALK,     -7.291435841283408_REALK, &
      3.428150040449531_REALK,      0.000000000000000_REALK,      0.204149768440084_REALK, &
      0.000000000000000_REALK,     -3.228283141931689_REALK,      0.000000000000000_REALK, &
     -0.335962136606033_REALK,      0.000000000000000_REALK,      1.315940161113924_REALK, &
    -40.798441219535455_REALK,      0.000000000000000_REALK,     -7.839255235543219_REALK, &
      0.000000000000000_REALK,     -1.400506502512074_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     13.283807576417644_REALK, &
      0.000000000000000_REALK,      1.321647889184620_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.267492423022805_REALK,      0.000000000000000_REALK, &
      1.754692175720288_REALK,      0.000000000000000_REALK,      0.970997262862168_REALK, &
      0.000000000000000_REALK,     -0.238527715814525_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     22.334915942987895_REALK,      0.000000000000000_REALK, &
      1.835049241929939_REALK,      0.000000000000000_REALK,    -20.062540529116173_REALK, &
    -33.738983846644807_REALK,    -13.884658277197934_REALK,      0.000000000000000_REALK, &
     -7.681021234293644_REALK,      0.000000000000000_REALK,     -9.240408996243325_REALK, &
     -2.221127097142951_REALK,      0.000000000000000_REALK,     -1.834060084158446_REALK, &
      0.000000000000000_REALK,      1.820288564944154_REALK,      0.000000000000000_REALK, &
      1.386251561502696_REALK,      0.000000000000000_REALK,      2.779476628006799_REALK, &
     18.206738883373287_REALK,      0.000000000000000_REALK,     15.237357192337097_REALK, &
      0.000000000000000_REALK,     20.970005611473479_REALK,      0.000000000000000_REALK, &
    -59.617572838823818_REALK,     15.108306412991803_REALK,      0.000000000000000_REALK, &
      4.886915859696319_REALK,      0.000000000000000_REALK,     -2.900342614941437_REALK, &
     -2.289514485068815_REALK,      0.000000000000000_REALK,     -0.404490134924355_REALK, &
      0.000000000000000_REALK,    -13.450992266387011_REALK,      0.000000000000000_REALK, &
     -1.667230385722373_REALK,      0.000000000000000_REALK,      2.968460768794374_REALK, &
    -71.671907210163212_REALK,      0.000000000000000_REALK,     -9.848679400636176_REALK, &
      0.000000000000000_REALK,     -5.219919357012023_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.629941292549419_REALK, &
      0.000000000000000_REALK,     -0.282809299911697_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.156454764855143_REALK,      0.000000000000000_REALK, &
     -0.612822357157318_REALK,      0.000000000000000_REALK,      1.620187852752570_REALK, &
      0.000000000000000_REALK,      0.289451428087583_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      6.467027126595609_REALK,      0.000000000000000_REALK, &
      2.019038747921148_REALK,      0.000000000000000_REALK,    -13.180722298429087_REALK, &
    -16.655185232508174_REALK,     -1.383005490743721_REALK,      0.000000000000000_REALK, &
      0.370558073441878_REALK,      0.000000000000000_REALK,     -2.430780448921398_REALK, &
     -0.452185326509678_REALK,      0.000000000000000_REALK,      0.111080367764650_REALK, &
      0.000000000000000_REALK,     -4.616096608132845_REALK,      0.000000000000000_REALK, &
     -0.379261090708916_REALK,      0.000000000000000_REALK,      4.146450585414281_REALK, &
    -30.130486634404466_REALK,      0.000000000000000_REALK,     -5.835422758199260_REALK, &
      0.000000000000000_REALK,      2.389141752439972_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      9.669395671192285_REALK, &
      0.000000000000000_REALK,      2.540729055732768_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.645565789871466_REALK,      0.000000000000000_REALK, &
     -1.294379082858114_REALK,      0.000000000000000_REALK,     -3.149199801422956_REALK, &
      0.000000000000000_REALK,     -4.334002063080964_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -10.939426633453637_REALK,      0.000000000000000_REALK, &
    -13.884975478264849_REALK,      0.000000000000000_REALK,    -38.975718586480696_REALK, &
    -30.067647743934632_REALK,      9.320974488726812_REALK,      0.000000000000000_REALK, &
     -1.536494274133019_REALK,      0.000000000000000_REALK,      0.817776820240954_REALK, &
     -9.871972899847048_REALK,      0.000000000000000_REALK,     -3.212284422688702_REALK, &
      0.000000000000000_REALK,    -11.204598284780507_REALK,      0.000000000000000_REALK, &
     -2.497453667016210_REALK,      0.000000000000000_REALK,      3.987700610854629_REALK, &
    -26.060262045617108_REALK,      0.000000000000000_REALK,     -8.327188949336978_REALK, &
      0.000000000000000_REALK,     -8.128861257455981_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.250818139730129_REALK, &
      0.000000000000000_REALK,      0.407298020603920_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.307009176605800_REALK,      0.000000000000000_REALK, &
     -2.327096182047763_REALK,      0.000000000000000_REALK,      3.747263687886490_REALK, &
      0.000000000000000_REALK,      1.986095136670145_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      8.894710299408834_REALK,      0.000000000000000_REALK, &
      3.307458139076477_REALK,      0.000000000000000_REALK,     -9.814740076673349_REALK, &
     -7.562795705264363_REALK,      0.219474864468203_REALK,      0.000000000000000_REALK, &
     -0.157540841018209_REALK,      0.000000000000000_REALK,      0.617076441428375_REALK, &
     -1.270130636717821_REALK,      0.000000000000000_REALK,     -0.226912654622840_REALK, &
      0.000000000000000_REALK,     -2.460599531598445_REALK,      0.000000000000000_REALK, &
     -0.768211683693552_REALK,      0.000000000000000_REALK,      5.015052276534519_REALK, &
     -5.575856934660058_REALK,      0.000000000000000_REALK,     -3.214134978770510_REALK, &
      0.000000000000000_REALK,     -0.957024785830453_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.886413246472297_REALK, &
      0.000000000000000_REALK,     -0.111851464379863_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.297318073213561_REALK,      0.000000000000000_REALK, &
     -3.250569934359031_REALK,      0.000000000000000_REALK,      2.220284254948335_REALK, &
      0.000000000000000_REALK,     -0.909029908472145_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      9.157430447572615_REALK,      0.000000000000000_REALK, &
      1.253966050565477_REALK,      0.000000000000000_REALK,    -19.193404619053045_REALK, &
     -9.584302323007840_REALK,     -1.971739137756381_REALK,      0.000000000000000_REALK, &
      0.650047172184873_REALK,      0.000000000000000_REALK,      1.303364390970428_REALK, &
      2.468784803032235_REALK,      0.000000000000000_REALK,      3.397599105909382_REALK, &
      0.000000000000000_REALK,      4.162275420112794_REALK,      0.000000000000000_REALK, &
      5.283009254371230_REALK,      0.000000000000000_REALK,     14.829632382892612_REALK, &
      7.464856614065348_REALK,      0.000000000000000_REALK,     10.412324739272540_REALK, &
      0.000000000000000_REALK,     20.061557108418427_REALK,      0.000000000000000_REALK, &
    -20.400919802899871_REALK,     -9.449749884638914_REALK,      0.000000000000000_REALK, &
     -8.907405527729331_REALK,      0.000000000000000_REALK,      3.759393241483003_REALK, &
    -25.533903358927130_REALK,      0.000000000000000_REALK,    -10.230157059718495_REALK, &
      0.000000000000000_REALK,    -17.524786139560767_REALK,      0.000000000000000_REALK, &
     -3.574775712921702_REALK,      0.000000000000000_REALK,      4.526229645592869_REALK, &
    -48.134467684416656_REALK,      0.000000000000000_REALK,    -10.843978302428457_REALK, &
      0.000000000000000_REALK,    -13.033918037514328_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.234855337699584_REALK, &
      0.000000000000000_REALK,      4.028040413076836_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.511737332490371_REALK,      0.000000000000000_REALK, &
     -4.010507432974619_REALK,      0.000000000000000_REALK,      4.967997352271514_REALK, &
      0.000000000000000_REALK,      4.849675136438357_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.785689313891936_REALK,      0.000000000000000_REALK, &
      3.200124722654573_REALK,      0.000000000000000_REALK,     -8.516100138230520_REALK, &
     -5.278431606110758_REALK,     -0.615026156682985_REALK,      0.000000000000000_REALK, &
     -1.638922676474541_REALK,      0.000000000000000_REALK,      2.918059621432715_REALK, &
     -3.768695381161980_REALK,      0.000000000000000_REALK,     -1.997454193659557_REALK, &
      0.000000000000000_REALK,     -5.306580346084691_REALK,      0.000000000000000_REALK, &
     -1.973228105865077_REALK,      0.000000000000000_REALK,      5.855469716227421_REALK, &
    -11.647518959045067_REALK,      0.000000000000000_REALK,     -4.801575031515277_REALK, &
      0.000000000000000_REALK,     -4.241488195451735_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.931794737397882_REALK, &
      0.000000000000000_REALK,      0.284536866226282_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.772605310229307_REALK,      0.000000000000000_REALK, &
     -5.043734822280815_REALK,      0.000000000000000_REALK,      1.917551548490626_REALK, &
      0.000000000000000_REALK,      0.570960576371029_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.152901492273946_REALK,      0.000000000000000_REALK, &
      1.640586459245462_REALK,      0.000000000000000_REALK,    -14.994145291861820_REALK, &
     -4.423859540939744_REALK,      0.168897398899485_REALK,      0.000000000000000_REALK, &
     -0.372821661115535_REALK,      0.000000000000000_REALK,      4.076048487067473_REALK, &
     -2.232982707766128_REALK,      0.000000000000000_REALK,      0.914228915480806_REALK, &
      0.000000000000000_REALK,     -5.463319073692160_REALK,      0.000000000000000_REALK, &
     -0.748115607433608_REALK,      0.000000000000000_REALK,     11.450776955904606_REALK, &
    -14.689664108856670_REALK,      0.000000000000000_REALK,     -4.741620521612890_REALK, &
      0.000000000000000_REALK,      2.717843358493927_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.968099896354581_REALK, &
      0.000000000000000_REALK,     -4.260415550183980_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.313224324177305_REALK,      0.000000000000000_REALK, &
    -14.914447373000153_REALK,      0.000000000000000_REALK,     -6.211988469388081_REALK, &
      0.000000000000000_REALK,    -11.968716358357884_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.888920643663701_REALK,      0.000000000000000_REALK, &
    -15.795290651093886_REALK,      0.000000000000000_REALK,    -57.006070434617747_REALK, &
     80.220827628067340_REALK,   -302.459089047250188_REALK,      0.000000000000000_REALK, &
    -25.656222573929799_REALK,      0.000000000000000_REALK,      9.417361630548283_REALK, &
    -79.772727098879542_REALK,      0.000000000000000_REALK,    -39.876730079999227_REALK, &
      0.000000000000000_REALK,     -8.359890228698086_REALK,      0.000000000000000_REALK, &
     -3.980717237283751_REALK,      0.000000000000000_REALK,      4.383480888244739_REALK, &
    -42.898411575026024_REALK,      0.000000000000000_REALK,    -16.319981248228178_REALK, &
      0.000000000000000_REALK,    -24.474059399006730_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -20.566586723945807_REALK, &
      0.000000000000000_REALK,     29.268316024555929_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      6.424636912806702_REALK,      0.000000000000000_REALK, &
     -8.134603228897138_REALK,      0.000000000000000_REALK,     11.334471101633666_REALK, &
      0.000000000000000_REALK,     13.623465781389836_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      6.443439174479480_REALK,      0.000000000000000_REALK, &
      3.943075199637469_REALK,      0.000000000000000_REALK,     -8.320924768738557_REALK, &
     32.580023680047788_REALK,    -22.036280102058008_REALK,      0.000000000000000_REALK, &
     -7.186040408652943_REALK,      0.000000000000000_REALK,     11.473997738443488_REALK, &
     -8.928554330487758_REALK,      0.000000000000000_REALK,     -8.715903989181317_REALK, &
      0.000000000000000_REALK,     -5.002154718214225_REALK,      0.000000000000000_REALK, &
     -3.344872165820253_REALK,      0.000000000000000_REALK,      8.901298787528548_REALK, &
     -5.716454107116597_REALK,      0.000000000000000_REALK,     -5.479836701585949_REALK, &
      0.000000000000000_REALK,     -8.915540112379722_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -15.963886301547404_REALK, &
      0.000000000000000_REALK,      5.714684558930044_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.546313152040286_REALK,      0.000000000000000_REALK, &
    -10.523532076352238_REALK,      0.000000000000000_REALK,      5.018758975647141_REALK, &
      0.000000000000000_REALK,      4.433338396527578_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.853302986784746_REALK,      0.000000000000000_REALK, &
      3.627540780316092_REALK,      0.000000000000000_REALK,    -15.070400207933460_REALK, &
     24.584170859981622_REALK,     -1.556621443808876_REALK,      0.000000000000000_REALK, &
     -2.210411458009783_REALK,      0.000000000000000_REALK,     14.430044803890278_REALK, &
     -3.446250464360912_REALK,      0.000000000000000_REALK,     -1.026138334064218_REALK, &
      0.000000000000000_REALK,     -3.295512943111818_REALK,      0.000000000000000_REALK, &
     -1.714793159249026_REALK,      0.000000000000000_REALK,     15.672357668425493_REALK, &
     -3.669279712426307_REALK,      0.000000000000000_REALK,     -3.525186175806298_REALK, &
      0.000000000000000_REALK,     -1.469498572423249_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -22.298918818934709_REALK, &
      0.000000000000000_REALK,     -2.615594331629504_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.344523833814588_REALK,      0.000000000000000_REALK, &
    -20.579496510871710_REALK,      0.000000000000000_REALK,      4.956092614561834_REALK, &
      0.000000000000000_REALK,     -2.840776341162329_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     10.043650136945784_REALK,      0.000000000000000_REALK, &
      1.925447855119232_REALK,      0.000000000000000_REALK,    -37.891558736006751_REALK, &
     51.925710866976978_REALK,     23.307539345987912_REALK,      0.000000000000000_REALK, &
     15.201049966446764_REALK,      0.000000000000000_REALK,     42.669995826690489_REALK, &
     11.164272566275660_REALK,      0.000000000000000_REALK,     21.510344449546640_REALK, &
      0.000000000000000_REALK,      9.290982640361646_REALK,      0.000000000000000_REALK, &
     16.509740284765680_REALK,      0.000000000000000_REALK,     59.584558354766315_REALK, &
      8.187275741090859_REALK,      0.000000000000000_REALK,     15.987983348509626_REALK, &
      0.000000000000000_REALK,     39.605462636617673_REALK,      0.000000000000000_REALK, &
    ! results of test 6, ket-major order, dd/dydy
    144.770217602728707_REALK,     23.436250586006636_REALK,      0.000000000000000_REALK, &
    -15.708808897628352_REALK,      0.000000000000000_REALK,     34.348791081088891_REALK, &
    -86.368797009189990_REALK,      0.000000000000000_REALK,      7.072231356425133_REALK, &
      0.000000000000000_REALK,   -211.482325075089733_REALK,      0.000000000000000_REALK, &
     -5.791835547254617_REALK,      0.000000000000000_REALK,     37.993182771236427_REALK, &
   -948.081094181907019_REALK,      0.000000000000000_REALK,    -61.205494407673292_REALK, &
      0.000000000000000_REALK,     15.035270782666762_REALK,      0.000000000000000_REALK, &
     19.412979685477392_REALK,    -65.433618635457051_REALK,      0.000000000000000_REALK, &
    -67.244034377713660_REALK,      0.000000000000000_REALK,      4.124680584416033_REALK, &
    -94.565210569710260_REALK,      0.000000000000000_REALK,    -17.034254522202268_REALK, &
      0.000000000000000_REALK,   -118.068525658342907_REALK,      0.000000000000000_REALK, &
    -21.563891160104497_REALK,      0.000000000000000_REALK,      3.968121366407270_REALK, &
   -228.351218604873537_REALK,      0.000000000000000_REALK,    -53.118877860067485_REALK, &
      0.000000000000000_REALK,    -28.705286435178405_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -27.329290648606040_REALK, &
      0.000000000000000_REALK,     -4.311247365467636_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.253736303163000_REALK,      0.000000000000000_REALK, &
    -21.343803194494345_REALK,      0.000000000000000_REALK,     16.884053619685460_REALK, &
      0.000000000000000_REALK,     -4.147606690179926_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     66.735620886409947_REALK,      0.000000000000000_REALK, &
      5.483036104990481_REALK,      0.000000000000000_REALK,    -59.945875873765161_REALK, &
     -9.315432377491405_REALK,    -57.276855613671621_REALK,      0.000000000000000_REALK, &
    -21.662064060699823_REALK,      0.000000000000000_REALK,     -1.705423867099685_REALK, &
    -11.995431001413406_REALK,      0.000000000000000_REALK,    -12.675675819331470_REALK, &
      0.000000000000000_REALK,     23.333935573615708_REALK,      0.000000000000000_REALK, &
     -5.929681600003451_REALK,      0.000000000000000_REALK,     -1.400506502512074_REALK, &
    109.472030600319968_REALK,      0.000000000000000_REALK,     -5.294514362491338_REALK, &
      0.000000000000000_REALK,    -16.784277531626909_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.693173796655724_REALK, &
      0.000000000000000_REALK,     12.227800047325376_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     13.324629443814459_REALK,      0.000000000000000_REALK, &
     -2.451957599066427_REALK,      0.000000000000000_REALK,     18.581814854894471_REALK, &
      0.000000000000000_REALK,     10.041558470047869_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     32.201227190153844_REALK,      0.000000000000000_REALK, &
     17.643578281640263_REALK,      0.000000000000000_REALK,     -5.411195613958071_REALK, &
     27.896288789649859_REALK,      3.860222743357070_REALK,      0.000000000000000_REALK, &
     -2.335648846267040_REALK,      0.000000000000000_REALK,     15.321348954342133_REALK, &
    -10.432892483153898_REALK,      0.000000000000000_REALK,      2.562864086773914_REALK, &
      0.000000000000000_REALK,    -23.345164685226329_REALK,      0.000000000000000_REALK, &
     -1.918051846163480_REALK,      0.000000000000000_REALK,     20.970005611473479_REALK, &
    -71.329648092671945_REALK,      0.000000000000000_REALK,    -13.814534656039719_REALK, &
      0.000000000000000_REALK,      5.655953802301435_REALK,      0.000000000000000_REALK, &
    -46.426884928735198_REALK,    -66.285380769052480_REALK,      0.000000000000000_REALK, &
    -11.807583667467195_REALK,      0.000000000000000_REALK,     -7.521786888573615_REALK, &
    -10.967707824771495_REALK,      0.000000000000000_REALK,    -12.566492319986656_REALK, &
      0.000000000000000_REALK,      8.899422496360561_REALK,      0.000000000000000_REALK, &
     -2.731382646986915_REALK,      0.000000000000000_REALK,     -5.219919357012023_REALK, &
     12.397632100586060_REALK,      0.000000000000000_REALK,     -3.787508771688688_REALK, &
      0.000000000000000_REALK,    -13.018864283695386_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.732737591899101_REALK, &
      0.000000000000000_REALK,     10.678458574184267_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.172502557946258_REALK,      0.000000000000000_REALK, &
      0.985485791370079_REALK,      0.000000000000000_REALK,      2.337624847583115_REALK, &
      0.000000000000000_REALK,      7.410565260644573_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.670103764730552_REALK,      0.000000000000000_REALK, &
      4.322705425035572_REALK,      0.000000000000000_REALK,      1.701602622363123_REALK, &
      4.249889763908544_REALK,    -12.423638027453402_REALK,      0.000000000000000_REALK, &
    -11.225161132247464_REALK,      0.000000000000000_REALK,      2.065619854947355_REALK, &
    -13.075351299348997_REALK,      0.000000000000000_REALK,     -7.065881649027709_REALK, &
      0.000000000000000_REALK,    -14.217430277581155_REALK,      0.000000000000000_REALK, &
     -7.789962245381964_REALK,      0.000000000000000_REALK,      2.389141752439972_REALK, &
    -19.410895987300005_REALK,      0.000000000000000_REALK,    -13.546041305187815_REALK, &
      0.000000000000000_REALK,    -12.200401922160140_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -15.566732590028202_REALK, &
      0.000000000000000_REALK,     -2.159051586041842_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.349663738165301_REALK,      0.000000000000000_REALK, &
    -14.755834791191750_REALK,      0.000000000000000_REALK,      6.099369509418219_REALK, &
      0.000000000000000_REALK,     -2.497206965516785_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     17.018497255083307_REALK,      0.000000000000000_REALK, &
      2.330415492827795_REALK,      0.000000000000000_REALK,    -35.669711683329403_REALK, &
   -107.632646780158126_REALK,    -73.551127282379795_REALK,      0.000000000000000_REALK, &
     14.542774229806540_REALK,      0.000000000000000_REALK,    -14.295888187723541_REALK, &
      9.053234228427620_REALK,      0.000000000000000_REALK,    -11.464403756250848_REALK, &
      0.000000000000000_REALK,     42.063864963960647_REALK,      0.000000000000000_REALK, &
      2.756414815697860_REALK,      0.000000000000000_REALK,     -8.128861257455981_REALK, &
     61.675565847406233_REALK,      0.000000000000000_REALK,      2.412546786924308_REALK, &
      0.000000000000000_REALK,     -9.165258430836944_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      9.335269247784138_REALK, &
      0.000000000000000_REALK,     12.877144548972568_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.284173006201660_REALK,      0.000000000000000_REALK, &
      4.365261272707173_REALK,      0.000000000000000_REALK,      2.130191693065462_REALK, &
      0.000000000000000_REALK,      7.322141867386284_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.983262781408404_REALK,      0.000000000000000_REALK, &
      1.826090248362487_REALK,      0.000000000000000_REALK,      5.816372796633096_REALK, &
     -2.534355242898632_REALK,    -13.253005890495674_REALK,      0.000000000000000_REALK, &
     -4.275649656362405_REALK,      0.000000000000000_REALK,     -1.009847669762838_REALK, &
     -1.954885223191213_REALK,      0.000000000000000_REALK,     -6.197232433812556_REALK, &
      0.000000000000000_REALK,      3.189011211995946_REALK,      0.000000000000000_REALK, &
     -2.431199963630511_REALK,      0.000000000000000_REALK,     -0.957024785830453_REALK, &
     10.771353888187267_REALK,      0.000000000000000_REALK,     -1.562839956975761_REALK, &
      0.000000000000000_REALK,     -8.257332583459693_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.563635183389130_REALK, &
      0.000000000000000_REALK,      7.240555044604450_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      6.514510700234670_REALK,      0.000000000000000_REALK, &
     -1.997967258425969_REALK,      0.000000000000000_REALK,      7.618639692118047_REALK, &
      0.000000000000000_REALK,      6.861817725918546_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      9.505189913725362_REALK,      0.000000000000000_REALK, &
      8.680081317726412_REALK,      0.000000000000000_REALK,     -3.726991434941479_REALK, &
     22.768381397612270_REALK,      2.679593050711664_REALK,      0.000000000000000_REALK, &
     -1.383028342858980_REALK,      0.000000000000000_REALK,     15.120609053707391_REALK, &
     -5.100718935749064_REALK,      0.000000000000000_REALK,      2.088338939922806_REALK, &
      0.000000000000000_REALK,     -9.571637629520870_REALK,      0.000000000000000_REALK, &
     -1.310685208525467_REALK,      0.000000000000000_REALK,     20.061557108418427_REALK, &
    -21.055155680754837_REALK,      0.000000000000000_REALK,     -6.796313211915349_REALK, &
      0.000000000000000_REALK,      3.895570014735283_REALK,      0.000000000000000_REALK, &
   -238.529999072147689_REALK,    -86.864325553260329_REALK,      0.000000000000000_REALK, &
     44.649322426703023_REALK,      0.000000000000000_REALK,    -28.001746272321267_REALK, &
      7.580925618802679_REALK,      0.000000000000000_REALK,    -11.452343107227360_REALK, &
      0.000000000000000_REALK,     40.579329931831822_REALK,      0.000000000000000_REALK, &
      6.927610910174317_REALK,      0.000000000000000_REALK,    -13.033918037514328_REALK, &
     13.029247972783329_REALK,      0.000000000000000_REALK,      1.550913055657715_REALK, &
      0.000000000000000_REALK,     -7.028794108789502_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     21.082672596739954_REALK, &
      0.000000000000000_REALK,     14.358890172047499_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.827578576060052_REALK,      0.000000000000000_REALK, &
      8.338728194481803_REALK,      0.000000000000000_REALK,     -1.759307574582889_REALK, &
      0.000000000000000_REALK,      6.683604507806386_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.827637640663593_REALK,      0.000000000000000_REALK, &
     -1.735406235341299_REALK,      0.000000000000000_REALK,      8.529725177837506_REALK, &
    -15.524452009191418_REALK,    -18.990399123296033_REALK,      0.000000000000000_REALK, &
     -2.860871793016042_REALK,      0.000000000000000_REALK,     -5.467384830451282_REALK, &
     -2.185187933220434_REALK,      0.000000000000000_REALK,     -7.511181320454501_REALK, &
      0.000000000000000_REALK,      1.446259717171489_REALK,      0.000000000000000_REALK, &
     -1.331644394723552_REALK,      0.000000000000000_REALK,     -4.241488195451736_REALK, &
      1.463319322247000_REALK,      0.000000000000000_REALK,     -1.341143548338573_REALK, &
      0.000000000000000_REALK,     -7.683223500051370_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.489259534953101_REALK, &
      0.000000000000000_REALK,      7.761884680592025_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.493967487088540_REALK,      0.000000000000000_REALK, &
      0.981732780480480_REALK,      0.000000000000000_REALK,      1.139673721177253_REALK, &
      0.000000000000000_REALK,      6.021515453572222_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.007763820725923_REALK,      0.000000000000000_REALK, &
      2.551091338053766_REALK,      0.000000000000000_REALK,      1.405906856342907_REALK, &
      4.263297642223448_REALK,    -10.677913076793399_REALK,      0.000000000000000_REALK, &
     -8.159268083897999_REALK,      0.000000000000000_REALK,      2.502405972525450_REALK, &
     -7.815333980019888_REALK,      0.000000000000000_REALK,     -7.038972756981126_REALK, &
      0.000000000000000_REALK,     -6.931493599916893_REALK,      0.000000000000000_REALK, &
     -6.329797578657534_REALK,      0.000000000000000_REALK,      2.717843358493927_REALK, &
     -6.873330067360233_REALK,      0.000000000000000_REALK,     -7.994342718437447_REALK, &
      0.000000000000000_REALK,    -10.080278724937072_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -22.298918818934709_REALK, &
      0.000000000000000_REALK,     -2.615594331629500_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.344523833814586_REALK,      0.000000000000000_REALK, &
    -20.579496510871710_REALK,      0.000000000000000_REALK,      4.956092614561830_REALK, &
      0.000000000000000_REALK,     -2.840776341162325_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     10.043650136945788_REALK,      0.000000000000000_REALK, &
      1.925447855119229_REALK,      0.000000000000000_REALK,    -37.891558736006743_REALK, &
   -901.685940364641510_REALK,   -105.404953600178047_REALK,      0.000000000000000_REALK, &
    153.084408885570980_REALK,      0.000000000000000_REALK,    -73.246813331415368_REALK, &
     22.724617700681019_REALK,      0.000000000000000_REALK,     -9.858384273576705_REALK, &
      0.000000000000000_REALK,     90.614167773464118_REALK,      0.000000000000000_REALK, &
     17.050102003187956_REALK,      0.000000000000000_REALK,    -24.474059399006730_REALK, &
     35.142711869585327_REALK,      0.000000000000000_REALK,      3.256373820150732_REALK, &
      0.000000000000000_REALK,     -4.238036240737130_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     68.682941022873834_REALK, &
      0.000000000000000_REALK,     21.987515915828148_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -10.242910107523111_REALK,      0.000000000000000_REALK, &
     19.271470718860559_REALK,      0.000000000000000_REALK,     -1.621063665035373_REALK, &
      0.000000000000000_REALK,      7.346719209827850_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.597702511666105_REALK,      0.000000000000000_REALK, &
     -4.403340653158183_REALK,      0.000000000000000_REALK,     13.807737835523252_REALK, &
    -65.694186967741445_REALK,    -35.219617992735522_REALK,      0.000000000000000_REALK, &
      5.428708200782062_REALK,      0.000000000000000_REALK,    -16.009642496497165_REALK, &
      2.601247323441784_REALK,      0.000000000000000_REALK,     -9.882131236203398_REALK, &
      0.000000000000000_REALK,      9.226927696027193_REALK,      0.000000000000000_REALK, &
      1.813901805729899_REALK,      0.000000000000000_REALK,     -8.915540112379722_REALK, &
      9.529205952198627_REALK,      0.000000000000000_REALK,      1.118254282034299_REALK, &
      0.000000000000000_REALK,     -7.080408099429140_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     13.410451841370506_REALK, &
      0.000000000000000_REALK,     14.420823519157397_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.968920311374294_REALK,      0.000000000000000_REALK, &
      6.271308084627886_REALK,      0.000000000000000_REALK,      1.401805902579292_REALK, &
      0.000000000000000_REALK,      8.030749628964360_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.919274233241547_REALK,      0.000000000000000_REALK, &
      1.410703722362321_REALK,      0.000000000000000_REALK,      6.290625705438782_REALK, &
     -4.640573621952900_REALK,    -19.038422195490330_REALK,      0.000000000000000_REALK, &
     -4.788203540750637_REALK,      0.000000000000000_REALK,     -1.884842685361246_REALK, &
     -1.685079550408992_REALK,      0.000000000000000_REALK,     -8.903190768323556_REALK, &
      0.000000000000000_REALK,      2.098578618497168_REALK,      0.000000000000000_REALK, &
     -2.666481824509270_REALK,      0.000000000000000_REALK,     -1.469498572423249_REALK, &
      4.992695965133260_REALK,      0.000000000000000_REALK,     -1.207335807602775_REALK, &
      0.000000000000000_REALK,     -8.930615423746099_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.137924404955512_REALK, &
      0.000000000000000_REALK,     13.514223602638230_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      9.359005353748302_REALK,      0.000000000000000_REALK, &
     -4.018502997403691_REALK,      0.000000000000000_REALK,      8.355941333670199_REALK, &
      0.000000000000000_REALK,     10.536228007633056_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      7.343014292463057_REALK,      0.000000000000000_REALK, &
      9.387834062871045_REALK,      0.000000000000000_REALK,     -5.182561623861958_REALK, &
     69.484043607265704_REALK,      6.415553854105394_REALK,      0.000000000000000_REALK, &
     -2.581370372718923_REALK,      0.000000000000000_REALK,     39.510867150580061_REALK, &
     -7.327895835050389_REALK,      0.000000000000000_REALK,      4.200267173690319_REALK, &
      0.000000000000000_REALK,    -10.497942642197764_REALK,      0.000000000000000_REALK, &
     -2.012539352523793_REALK,      0.000000000000000_REALK,     39.605462636617673_REALK, &
    -16.265672805817932_REALK,      0.000000000000000_REALK,     -7.350468081728912_REALK, &
      0.000000000000000_REALK,      5.416978282310286_REALK,      0.000000000000000_REALK, &
    ! results of test 6, ket-major order, dd/dxdz
      0.000000000000000_REALK,      0.000000000000000_REALK,     56.084741871199434_REALK, &
      0.000000000000000_REALK,     46.509881413638198_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     32.940169001916118_REALK,      0.000000000000000_REALK, &
     21.556802579540030_REALK,      0.000000000000000_REALK,     48.764846896839380_REALK, &
      0.000000000000000_REALK,     22.219059844244157_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,   -194.737769245480109_REALK,      0.000000000000000_REALK, &
    -71.701007374931976_REALK,      0.000000000000000_REALK,    -78.204641302115704_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     33.398160743904029_REALK, &
      0.000000000000000_REALK,     16.323734656077828_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      7.472711869912261_REALK,      0.000000000000000_REALK, &
      8.989809021849618_REALK,      0.000000000000000_REALK,      3.847291525627825_REALK, &
      0.000000000000000_REALK,      3.176839285042009_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -30.282124334759970_REALK,      0.000000000000000_REALK, &
    -23.061531535780272_REALK,      0.000000000000000_REALK,    -46.239073549002676_REALK, &
     52.759191218819794_REALK,     33.398160743904029_REALK,      0.000000000000000_REALK, &
     29.473145466777336_REALK,      0.000000000000000_REALK,     -7.010918812265697_REALK, &
     19.730207473017181_REALK,      0.000000000000000_REALK,     -3.267686581255301_REALK, &
      0.000000000000000_REALK,     15.578553816827510_REALK,      0.000000000000000_REALK, &
     -2.084933149554041_REALK,      0.000000000000000_REALK,     -3.980092899877139_REALK, &
   -196.325990417231964_REALK,      0.000000000000000_REALK,     22.132551814255038_REALK, &
      0.000000000000000_REALK,     29.416625833398687_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     24.468446355453217_REALK, &
      0.000000000000000_REALK,      7.621240704062906_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.990080589498243_REALK,      0.000000000000000_REALK, &
      3.232099766949792_REALK,      0.000000000000000_REALK,     -1.524268156496974_REALK, &
      0.000000000000000_REALK,     -1.375462520455677_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -19.728348669473643_REALK,      0.000000000000000_REALK, &
    -13.652333908638944_REALK,      0.000000000000000_REALK,    -36.954705483860216_REALK, &
     32.278948483645394_REALK,     13.283807576417642_REALK,      0.000000000000000_REALK, &
      7.348629403022374_REALK,      0.000000000000000_REALK,     -3.213427482405569_REALK, &
      2.125009083563018_REALK,      0.000000000000000_REALK,     -0.637809330865535_REALK, &
      0.000000000000000_REALK,     -1.741516611178088_REALK,      0.000000000000000_REALK, &
      0.482080270155944_REALK,      0.000000000000000_REALK,      1.691742031283763_REALK, &
    -17.418852599202793_REALK,      0.000000000000000_REALK,      5.298915056789422_REALK, &
      0.000000000000000_REALK,     12.763496383355546_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.221284560873039_REALK, &
      0.000000000000000_REALK,     -2.940816181365039_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.053894662866903_REALK,      0.000000000000000_REALK, &
      0.820388697451990_REALK,      0.000000000000000_REALK,      1.164855751425859_REALK, &
      0.000000000000000_REALK,     -0.631327785916659_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     19.636242031582217_REALK,      0.000000000000000_REALK, &
     -8.599978885489133_REALK,      0.000000000000000_REALK,    -26.645786923636997_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     20.243510450354286_REALK, &
      0.000000000000000_REALK,      3.031530369857748_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.685675293046667_REALK,      0.000000000000000_REALK, &
     -1.625920215590513_REALK,      0.000000000000000_REALK,     -2.487891993988854_REALK, &
      0.000000000000000_REALK,     -3.102729631310515_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -7.803276735195337_REALK,      0.000000000000000_REALK, &
     -8.848595863700210_REALK,      0.000000000000000_REALK,    -34.970660895126237_REALK, &
     29.350848848114808_REALK,      7.629941292549419_REALK,      0.000000000000000_REALK, &
      2.637562984175597_REALK,      0.000000000000000_REALK,     -1.557065429020372_REALK, &
     -0.679121088879147_REALK,      0.000000000000000_REALK,      0.222753496576972_REALK, &
      0.000000000000000_REALK,     -3.900934716251995_REALK,      0.000000000000000_REALK, &
      0.981238947790281_REALK,      0.000000000000000_REALK,      4.648698985338851_REALK, &
    -17.432227287202327_REALK,      0.000000000000000_REALK,      3.185612929373268_REALK, &
      0.000000000000000_REALK,      8.385383752464609_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.944173486612581_REALK, &
      0.000000000000000_REALK,     -0.773610614036676_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.196564268030343_REALK,      0.000000000000000_REALK, &
     -0.281281224424919_REALK,      0.000000000000000_REALK,      0.958880045318470_REALK, &
      0.000000000000000_REALK,     -0.941821003682866_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.330877228337308_REALK,      0.000000000000000_REALK, &
     -3.017340866643489_REALK,      0.000000000000000_REALK,    -17.185779989783548_REALK, &
     20.569681589003789_REALK,      9.669395671192287_REALK,      0.000000000000000_REALK, &
      4.587386319919037_REALK,      0.000000000000000_REALK,      0.910170287224745_REALK, &
     -1.704487901230400_REALK,      0.000000000000000_REALK,     -0.235456971499181_REALK, &
      0.000000000000000_REALK,    -12.751822485925114_REALK,      0.000000000000000_REALK, &
     -1.423462866304443_REALK,      0.000000000000000_REALK,      2.015841984923703_REALK, &
    -70.922823797541696_REALK,      0.000000000000000_REALK,     -6.668813921716945_REALK, &
      0.000000000000000_REALK,      6.575355464511559_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      9.049904783417754_REALK, &
      0.000000000000000_REALK,     -0.854766348484043_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.021221597407928_REALK,      0.000000000000000_REALK, &
     -9.356597273519537_REALK,      0.000000000000000_REALK,     -3.072696983180812_REALK, &
      0.000000000000000_REALK,     -4.168071539351634_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.932703653812825_REALK,      0.000000000000000_REALK, &
     -7.645366338016378_REALK,      0.000000000000000_REALK,    -39.462301107337709_REALK, &
     19.197044833499717_REALK,      2.250818139730129_REALK,      0.000000000000000_REALK, &
     -0.660556920009264_REALK,      0.000000000000000_REALK,      0.569352072096192_REALK, &
     -1.865958252415725_REALK,      0.000000000000000_REALK,      0.845871246973762_REALK, &
      0.000000000000000_REALK,     -2.840538263078837_REALK,      0.000000000000000_REALK, &
      1.170814046206087_REALK,      0.000000000000000_REALK,      8.098623460847236_REALK, &
     -3.981821906641704_REALK,      0.000000000000000_REALK,      1.716356785482132_REALK, &
      0.000000000000000_REALK,      6.243994836565878_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.057997694339646_REALK, &
      0.000000000000000_REALK,      0.196388318399055_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.673510784529843_REALK,      0.000000000000000_REALK, &
     -1.301135691645439_REALK,      0.000000000000000_REALK,      1.061245876631864_REALK, &
      0.000000000000000_REALK,     -1.139114399487259_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.462884847248462_REALK,      0.000000000000000_REALK, &
     -2.027328919368520_REALK,      0.000000000000000_REALK,    -15.588737858548743_REALK, &
      9.169547083642193_REALK,      1.886413246472297_REALK,      0.000000000000000_REALK, &
     -0.621916750020364_REALK,      0.000000000000000_REALK,     -0.226831465951074_REALK, &
     -2.361949542893804_REALK,      0.000000000000000_REALK,     -0.591302318251666_REALK, &
      0.000000000000000_REALK,     -3.982155315383788_REALK,      0.000000000000000_REALK, &
     -0.919430315960893_REALK,      0.000000000000000_REALK,      2.393552019762125_REALK, &
     -7.141819183957943_REALK,      0.000000000000000_REALK,     -1.812112484375381_REALK, &
      0.000000000000000_REALK,      3.238002082359230_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.294653415939313_REALK, &
      0.000000000000000_REALK,      0.770227927690704_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.625204452817438_REALK,      0.000000000000000_REALK, &
      1.156599941630590_REALK,      0.000000000000000_REALK,      8.243054978735822_REALK, &
      0.000000000000000_REALK,      1.831045557803711_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     24.915703700788324_REALK,      0.000000000000000_REALK, &
      4.472397171035982_REALK,      0.000000000000000_REALK,     -9.688480719359918_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -7.684763628895853_REALK, &
      0.000000000000000_REALK,     -3.929437413732516_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.322235348204869_REALK,      0.000000000000000_REALK, &
    -24.958228476992389_REALK,      0.000000000000000_REALK,     -2.714136233899997_REALK, &
      0.000000000000000_REALK,     -4.730959218706755_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.139787630341071_REALK,      0.000000000000000_REALK, &
     -8.054959162537591_REALK,      0.000000000000000_REALK,    -52.997476387983276_REALK, &
     20.304667516147592_REALK,     -1.234855337699584_REALK,      0.000000000000000_REALK, &
     -3.624514057527128_REALK,      0.000000000000000_REALK,      4.080140081728209_REALK, &
     -2.956540926416597_REALK,      0.000000000000000_REALK,      1.457770825932349_REALK, &
      0.000000000000000_REALK,     -3.957062894578772_REALK,      0.000000000000000_REALK, &
      1.586202192783995_REALK,      0.000000000000000_REALK,     14.329678791057658_REALK, &
     -5.486377972623334_REALK,      0.000000000000000_REALK,      1.369198795608582_REALK, &
      0.000000000000000_REALK,      5.417819002376731_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.752746853188360_REALK, &
      0.000000000000000_REALK,      0.928690164730377_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.030982897171077_REALK,      0.000000000000000_REALK, &
     -2.908011587984958_REALK,      0.000000000000000_REALK,      0.896555675164599_REALK, &
      0.000000000000000_REALK,     -1.330006050131414_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.158368646320595_REALK,      0.000000000000000_REALK, &
     -1.562457046907666_REALK,      0.000000000000000_REALK,    -17.541287289054281_REALK, &
      7.796012526956403_REALK,     -0.931794737397882_REALK,      0.000000000000000_REALK, &
     -2.653674777406872_REALK,      0.000000000000000_REALK,     -1.306654016971398_REALK, &
     -3.353637455800953_REALK,      0.000000000000000_REALK,     -0.917492056250555_REALK, &
      0.000000000000000_REALK,     -4.616898832441875_REALK,      0.000000000000000_REALK, &
     -0.968646564024458_REALK,      0.000000000000000_REALK,      3.404326919738315_REALK, &
     -8.498819372729631_REALK,      0.000000000000000_REALK,     -1.295411096906268_REALK, &
      0.000000000000000_REALK,      2.529570685445218_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.112725213669207_REALK, &
      0.000000000000000_REALK,      2.408755679617182_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.003993182634397_REALK,      0.000000000000000_REALK, &
      1.761827202425909_REALK,      0.000000000000000_REALK,      3.512136863435497_REALK, &
      0.000000000000000_REALK,      1.413851249792108_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.025621992476002_REALK,      0.000000000000000_REALK, &
      1.865880246404526_REALK,      0.000000000000000_REALK,     -7.430410190480086_REALK, &
      9.106011219256326_REALK,     -1.968099896354581_REALK,      0.000000000000000_REALK, &
     -7.692347977044573_REALK,      0.000000000000000_REALK,     -4.882249613515832_REALK, &
    -14.028510678805365_REALK,      0.000000000000000_REALK,     -6.199161018372094_REALK, &
      0.000000000000000_REALK,    -25.153746742413034_REALK,      0.000000000000000_REALK, &
     -8.982149656559747_REALK,      0.000000000000000_REALK,     -3.861128709027178_REALK, &
    -57.628920937500929_REALK,      0.000000000000000_REALK,    -17.334319124038398_REALK, &
      0.000000000000000_REALK,     -5.188013194891502_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,   -229.891489799674275_REALK, &
      0.000000000000000_REALK,     -9.843325971168635_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -20.309101609431583_REALK,      0.000000000000000_REALK, &
    -90.927876381308423_REALK,      0.000000000000000_REALK,     -2.086393290331466_REALK, &
      0.000000000000000_REALK,     -4.581753676254300_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.434764621690798_REALK,      0.000000000000000_REALK, &
    -12.464566631530117_REALK,      0.000000000000000_REALK,    -93.010562096291054_REALK, &
   -193.978325738538359_REALK,    -20.566586723945807_REALK,      0.000000000000000_REALK, &
    -17.305074502854694_REALK,      0.000000000000000_REALK,     24.831702689973991_REALK, &
     -4.666795960668825_REALK,      0.000000000000000_REALK,      2.956829644578390_REALK, &
      0.000000000000000_REALK,     -5.139787630341072_REALK,      0.000000000000000_REALK, &
      2.927879992112231_REALK,      0.000000000000000_REALK,     33.716223387726416_REALK, &
     -1.367199732595832_REALK,      0.000000000000000_REALK,      1.041106632794364_REALK, &
      0.000000000000000_REALK,      5.293651272022967_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     19.543677828633260_REALK, &
      0.000000000000000_REALK,      3.651669339298575_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.496002936853284_REALK,      0.000000000000000_REALK, &
     -9.194844526657395_REALK,      0.000000000000000_REALK,      1.253042738844370_REALK, &
      0.000000000000000_REALK,     -2.021832887057934_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.389107637880550_REALK,      0.000000000000000_REALK, &
     -1.822197745569772_REALK,      0.000000000000000_REALK,    -26.717972940896502_REALK, &
    -62.403302771350930_REALK,    -15.963886301547404_REALK,      0.000000000000000_REALK, &
     -9.268089310805243_REALK,      0.000000000000000_REALK,     -6.662999142585932_REALK, &
     -5.062911883208449_REALK,      0.000000000000000_REALK,     -1.914307041103503_REALK, &
      0.000000000000000_REALK,     -3.804369825795907_REALK,      0.000000000000000_REALK, &
     -1.307913121875051_REALK,      0.000000000000000_REALK,      6.711374130194653_REALK, &
     -2.620300074364406_REALK,      0.000000000000000_REALK,     -0.942075386405866_REALK, &
      0.000000000000000_REALK,      2.542435186659608_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     23.222470258494173_REALK, &
      0.000000000000000_REALK,      8.527487464583182_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.655467028331571_REALK,      0.000000000000000_REALK, &
      4.477903279514761_REALK,      0.000000000000000_REALK,      4.398692220650138_REALK, &
      0.000000000000000_REALK,      1.935098601782328_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.015783460089169_REALK,      0.000000000000000_REALK, &
      1.692182057218526_REALK,      0.000000000000000_REALK,     -9.097414313241186_REALK, &
    -49.678655221813891_REALK,    -22.298918818934709_REALK,      0.000000000000000_REALK, &
    -14.543233162994330_REALK,      0.000000000000000_REALK,    -16.968198330133628_REALK, &
    -10.681145012019229_REALK,      0.000000000000000_REALK,     -8.553827665037891_REALK, &
      0.000000000000000_REALK,     -8.888920643663702_REALK,      0.000000000000000_REALK, &
     -6.565281812276869_REALK,      0.000000000000000_REALK,     -5.188013194891503_REALK, &
     -7.832976033578816_REALK,      0.000000000000000_REALK,     -6.357799364646118_REALK, &
      0.000000000000000_REALK,     -3.448438125951446_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     45.484559605320960_REALK, &
      0.000000000000000_REALK,     30.202848265674785_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     27.490309303260290_REALK,      0.000000000000000_REALK, &
     24.266703680692508_REALK,      0.000000000000000_REALK,     30.854531524561306_REALK, &
      0.000000000000000_REALK,     18.963146917027654_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     45.823792608936976_REALK,      0.000000000000000_REALK, &
     22.758243338717108_REALK,      0.000000000000000_REALK,     12.071215903478556_REALK, &
    ! results of test 6, ket-major order, dd/dydz
      0.000000000000000_REALK,      0.000000000000000_REALK,    -54.618819057965105_REALK, &
      0.000000000000000_REALK,    -35.902449177481898_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -41.101688026795358_REALK,      0.000000000000000_REALK, &
    -49.446082261548753_REALK,      0.000000000000000_REALK,    -48.092587935121678_REALK, &
      0.000000000000000_REALK,    -39.711683311209413_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,   -114.739418784392456_REALK,      0.000000000000000_REALK, &
    -87.380485445534688_REALK,      0.000000000000000_REALK,   -175.200536312816638_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -27.329290648606044_REALK, &
      0.000000000000000_REALK,     -4.311247365467643_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.253736303163005_REALK,      0.000000000000000_REALK, &
    -21.343803194494342_REALK,      0.000000000000000_REALK,     16.884053619685474_REALK, &
      0.000000000000000_REALK,     -4.147606690179931_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     66.735620886409933_REALK,      0.000000000000000_REALK, &
      5.483036104990488_REALK,      0.000000000000000_REALK,    -59.945875873765154_REALK, &
    -45.242476859764203_REALK,    -27.329290648606037_REALK,      0.000000000000000_REALK, &
    -23.971406766384696_REALK,      0.000000000000000_REALK,     10.482278132483051_REALK, &
    -25.848280566626240_REALK,      0.000000000000000_REALK,      7.758213675294900_REALK, &
      0.000000000000000_REALK,    -30.282124334759967_REALK,      0.000000000000000_REALK, &
      8.382587100516684_REALK,      0.000000000000000_REALK,     29.416625833398683_REALK, &
    -52.046667482606317_REALK,      0.000000000000000_REALK,     15.832895330425909_REALK, &
      0.000000000000000_REALK,     38.136694044380249_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -21.296569757029562_REALK, &
      0.000000000000000_REALK,      1.782563280613429_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.609749464472946_REALK,      0.000000000000000_REALK, &
    -14.139135855746094_REALK,      0.000000000000000_REALK,      8.193838962744572_REALK, &
      0.000000000000000_REALK,      1.463853950797580_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     15.309768300227317_REALK,      0.000000000000000_REALK, &
      4.779787499689382_REALK,      0.000000000000000_REALK,    -31.203488166720863_REALK, &
    -26.689092736725961_REALK,     -3.693173796655723_REALK,      0.000000000000000_REALK, &
      2.234574969039476_REALK,      0.000000000000000_REALK,      5.328123876056230_REALK, &
      9.981414986587563_REALK,      0.000000000000000_REALK,      0.891256858160469_REALK, &
      0.000000000000000_REALK,     22.334915942987895_REALK,      0.000000000000000_REALK, &
     -0.667018150132342_REALK,      0.000000000000000_REALK,     12.763496383355548_REALK, &
     68.242898085055430_REALK,      0.000000000000000_REALK,     -4.804116932314331_REALK, &
      0.000000000000000_REALK,      3.442523919049540_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.217729813421846_REALK, &
      0.000000000000000_REALK,      4.876112187630183_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.535162364112066_REALK,      0.000000000000000_REALK, &
     -6.489765589269411_REALK,      0.000000000000000_REALK,      4.849381300187193_REALK, &
      0.000000000000000_REALK,     -4.763107946277389_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      7.885378799886441_REALK,      0.000000000000000_REALK, &
     -7.143125990788427_REALK,      0.000000000000000_REALK,    -40.684893468318627_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -18.573811520612750_REALK, &
      0.000000000000000_REALK,      7.862010946858136_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.933116921039170_REALK,      0.000000000000000_REALK, &
    -10.563761893737233_REALK,      0.000000000000000_REALK,     10.294153025994765_REALK, &
      0.000000000000000_REALK,      5.456025773461868_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     16.530248706980423_REALK,      0.000000000000000_REALK, &
      6.146698856565854_REALK,      0.000000000000000_REALK,    -18.240065049961377_REALK, &
    -23.446334534067088_REALK,      1.732737591899101_REALK,      0.000000000000000_REALK, &
      2.909389617530139_REALK,      0.000000000000000_REALK,      4.142262530704088_REALK, &
      5.516200485820123_REALK,      0.000000000000000_REALK,     -0.358212136503787_REALK, &
      0.000000000000000_REALK,      6.467027126595609_REALK,      0.000000000000000_REALK, &
     -0.733896104753848_REALK,      0.000000000000000_REALK,      8.385383752464609_REALK, &
      9.913946767539660_REALK,      0.000000000000000_REALK,     -2.077251114534542_REALK, &
      0.000000000000000_REALK,     -1.082534830766859_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.739816522483646_REALK, &
      0.000000000000000_REALK,      0.657396041284288_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.410950624927601_REALK,      0.000000000000000_REALK, &
     -3.206587106084438_REALK,      0.000000000000000_REALK,     -1.857158668993432_REALK, &
      0.000000000000000_REALK,     -0.542667478334084_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.181855216627721_REALK,      0.000000000000000_REALK, &
      0.506422061297523_REALK,      0.000000000000000_REALK,    -15.728044011004924_REALK, &
    -29.713450858451164_REALK,    -15.566732590028202_REALK,      0.000000000000000_REALK, &
    -12.004763218452704_REALK,      0.000000000000000_REALK,     -4.378492843532515_REALK, &
    -10.721977359008680_REALK,      0.000000000000000_REALK,     -2.684193694017769_REALK, &
      0.000000000000000_REALK,    -10.939426633453637_REALK,      0.000000000000000_REALK, &
     -2.525778049683610_REALK,      0.000000000000000_REALK,      6.575355464511559_REALK, &
    -13.272612975259584_REALK,      0.000000000000000_REALK,     -3.367694848222329_REALK, &
      0.000000000000000_REALK,      6.017619229113735_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -19.591241801794858_REALK, &
      0.000000000000000_REALK,     14.942517129497691_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.737467705819475_REALK,      0.000000000000000_REALK, &
     -9.161052225881605_REALK,      0.000000000000000_REALK,      8.703842803057460_REALK, &
      0.000000000000000_REALK,      8.496544390096279_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      6.859478392223236_REALK,      0.000000000000000_REALK, &
      4.586839000130731_REALK,      0.000000000000000_REALK,    -12.206393071658690_REALK, &
    -25.991007066154619_REALK,      9.335269247784138_REALK,      0.000000000000000_REALK, &
      5.816688247501380_REALK,      0.000000000000000_REALK,      3.764448964274997_REALK, &
      8.236153824321805_REALK,      0.000000000000000_REALK,     -1.586719545412972_REALK, &
      0.000000000000000_REALK,      8.894710299408832_REALK,      0.000000000000000_REALK, &
     -1.202220931819103_REALK,      0.000000000000000_REALK,      6.243994836565878_REALK, &
     15.972297764332858_REALK,      0.000000000000000_REALK,     -2.393357752434088_REALK, &
      0.000000000000000_REALK,     -3.700291747515016_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.501219590157488_REALK, &
      0.000000000000000_REALK,     -0.321390142921129_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.537363034410363_REALK,      0.000000000000000_REALK, &
     -2.503672599290328_REALK,      0.000000000000000_REALK,     -1.022917942106509_REALK, &
      0.000000000000000_REALK,      0.217377736879544_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.376008317533427_REALK,      0.000000000000000_REALK, &
      0.511004791072471_REALK,      0.000000000000000_REALK,     -9.476400851868130_REALK, &
    -21.783092624545748_REALK,     -2.563635183389129_REALK,      0.000000000000000_REALK, &
      1.323178576849939_REALK,      0.000000000000000_REALK,     -2.631520349556145_REALK, &
      4.879988220895159_REALK,      0.000000000000000_REALK,     -0.363444779086458_REALK, &
      0.000000000000000_REALK,      9.157430447572615_REALK,      0.000000000000000_REALK, &
      0.228105546929099_REALK,      0.000000000000000_REALK,      3.238002082359230_REALK, &
     20.144005777512657_REALK,      0.000000000000000_REALK,      1.182798685925118_REALK, &
      0.000000000000000_REALK,      0.628757964873818_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     17.653621484568351_REALK, &
      0.000000000000000_REALK,      8.935578919865227_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      6.861909344946516_REALK,      0.000000000000000_REALK, &
      4.024476025576481_REALK,      0.000000000000000_REALK,      6.153201178375986_REALK, &
      0.000000000000000_REALK,      2.477042186721415_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      7.203381415672369_REALK,      0.000000000000000_REALK, &
      2.674424600764423_REALK,      0.000000000000000_REALK,    -10.650239663281326_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -20.566586723945807_REALK, &
      0.000000000000000_REALK,     29.268316024555929_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      6.424636912806702_REALK,      0.000000000000000_REALK, &
     -8.134603228897136_REALK,      0.000000000000000_REALK,     11.334471101633664_REALK, &
      0.000000000000000_REALK,     13.623465781389832_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      6.443439174479480_REALK,      0.000000000000000_REALK, &
      3.943075199637469_REALK,      0.000000000000000_REALK,     -8.320924768738555_REALK, &
    -31.170141659995227_REALK,     21.082672596739954_REALK,      0.000000000000000_REALK, &
      6.875068591473587_REALK,      0.000000000000000_REALK,      3.990176157869576_REALK, &
      8.542176213048693_REALK,      0.000000000000000_REALK,     -3.031026594626943_REALK, &
      0.000000000000000_REALK,      4.785689313891936_REALK,      0.000000000000000_REALK, &
     -1.163206536328644_REALK,      0.000000000000000_REALK,      5.417819002376731_REALK, &
      5.469077802445125_REALK,      0.000000000000000_REALK,     -1.905657840808768_REALK, &
      0.000000000000000_REALK,     -5.426487054336274_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.860743358795478_REALK, &
      0.000000000000000_REALK,     -1.740028367324174_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.079794592393082_REALK,      0.000000000000000_REALK, &
     -2.286866364662768_REALK,      0.000000000000000_REALK,     -1.528130362461138_REALK, &
      0.000000000000000_REALK,      0.963407759735852_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.782235420786845_REALK,      0.000000000000000_REALK, &
      0.788300062826713_REALK,      0.000000000000000_REALK,     -6.645075234645436_REALK, &
    -23.520304829257569_REALK,      1.489259534953101_REALK,      0.000000000000000_REALK, &
      2.114757157627102_REALK,      0.000000000000000_REALK,     -2.511337765004490_REALK, &
      3.297115932906419_REALK,      0.000000000000000_REALK,      0.178584334662601_REALK, &
      0.000000000000000_REALK,      3.152901492273946_REALK,      0.000000000000000_REALK, &
      0.298434611847667_REALK,      0.000000000000000_REALK,      2.529570685445218_REALK, &
      3.510493716937249_REALK,      0.000000000000000_REALK,      0.613506977441082_REALK, &
      0.000000000000000_REALK,     -0.237181960094897_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     12.607372854066298_REALK, &
      0.000000000000000_REALK,      1.478805911694460_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.760167496088897_REALK,      0.000000000000000_REALK, &
      2.431033202793714_REALK,      0.000000000000000_REALK,     -2.802077894377946_REALK, &
      0.000000000000000_REALK,      0.335577772926960_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.678483478075587_REALK,      0.000000000000000_REALK, &
     -0.227451029405409_REALK,      0.000000000000000_REALK,     -4.938944607454018_REALK, &
    -49.678655221813891_REALK,    -22.298918818934705_REALK,      0.000000000000000_REALK, &
    -14.543233162994326_REALK,      0.000000000000000_REALK,    -16.968198330133628_REALK, &
    -10.681145012019231_REALK,      0.000000000000000_REALK,     -8.553827665037891_REALK, &
      0.000000000000000_REALK,     -8.888920643663702_REALK,      0.000000000000000_REALK, &
     -6.565281812276867_REALK,      0.000000000000000_REALK,     -5.188013194891503_REALK, &
     -7.832976033578813_REALK,      0.000000000000000_REALK,     -6.357799364646118_REALK, &
      0.000000000000000_REALK,     -3.448438125951446_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -23.098991297602517_REALK, &
      0.000000000000000_REALK,     76.559899497932449_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.885741759122442_REALK,      0.000000000000000_REALK, &
     -6.481253245674361_REALK,      0.000000000000000_REALK,     17.058163588894356_REALK, &
      0.000000000000000_REALK,     25.581065478117466_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.771242879990203_REALK,      0.000000000000000_REALK, &
      2.530230734222630_REALK,      0.000000000000000_REALK,     -4.643726831617602_REALK, &
    -61.312761830658651_REALK,     68.682941022873834_REALK,      0.000000000000000_REALK, &
     11.800972139149936_REALK,      0.000000000000000_REALK,      5.431196304078520_REALK, &
     16.033506558022157_REALK,      0.000000000000000_REALK,     -7.004945946684707_REALK, &
      0.000000000000000_REALK,      6.443439174479480_REALK,      0.000000000000000_REALK, &
     -1.433260026705766_REALK,      0.000000000000000_REALK,      5.293651272022967_REALK, &
     10.198439313887860_REALK,      0.000000000000000_REALK,     -2.505401690993716_REALK, &
      0.000000000000000_REALK,     -8.784281914359646_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.569245653069173_REALK, &
      0.000000000000000_REALK,     -5.095165780076306_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.505856069967309_REALK,      0.000000000000000_REALK, &
     -2.860042657764235_REALK,      0.000000000000000_REALK,     -1.743991250800001_REALK, &
      0.000000000000000_REALK,      2.025067648594051_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.968099472062879_REALK,      0.000000000000000_REALK, &
      0.770027666427509_REALK,      0.000000000000000_REALK,     -5.821086844307358_REALK, &
    -47.591268878801301_REALK,     13.410451841370506_REALK,      0.000000000000000_REALK, &
      6.513977874843922_REALK,      0.000000000000000_REALK,     -3.516258485021825_REALK, &
      7.099431833001269_REALK,      0.000000000000000_REALK,      1.140796563000912_REALK, &
      0.000000000000000_REALK,      5.853302986784746_REALK,      0.000000000000000_REALK, &
      0.659876057512456_REALK,      0.000000000000000_REALK,      2.542435186659608_REALK, &
      7.403417196174963_REALK,      0.000000000000000_REALK,      0.925297383854683_REALK, &
      0.000000000000000_REALK,     -1.061253046962454_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     20.011158759932410_REALK, &
      0.000000000000000_REALK,     -1.113854640825240_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.433482537149329_REALK,      0.000000000000000_REALK, &
      2.737350145753563_REALK,      0.000000000000000_REALK,     -2.083221593075430_REALK, &
      0.000000000000000_REALK,     -0.181442045477708_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.973837334006509_REALK,      0.000000000000000_REALK, &
     -0.300430119194442_REALK,      0.000000000000000_REALK,     -3.895346280206895_REALK, &
    -66.477161085494387_REALK,     -6.137924404955512_REALK,      0.000000000000000_REALK, &
      2.469663035998310_REALK,      0.000000000000000_REALK,    -15.711935682619519_REALK, &
      7.010785304864298_REALK,      0.000000000000000_REALK,     -1.670282948519686_REALK, &
      0.000000000000000_REALK,     10.043650136945784_REALK,      0.000000000000000_REALK, &
      0.800308652935510_REALK,      0.000000000000000_REALK,     -3.448438125951446_REALK, &
     15.561785053672910_REALK,      0.000000000000000_REALK,      2.922995369783396_REALK, &
      0.000000000000000_REALK,     -0.471654998896513_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     70.875975386275144_REALK, &
      0.000000000000000_REALK,     27.966741085260612_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     16.530759064332329_REALK,      0.000000000000000_REALK, &
     26.824872349895326_REALK,      0.000000000000000_REALK,     11.316678752687471_REALK, &
      0.000000000000000_REALK,     12.604678585067543_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      9.331466732383063_REALK,      0.000000000000000_REALK, &
      9.585711610665381_REALK,      0.000000000000000_REALK,      9.346528768618263_REALK, &
    ! results of test 6, ket-major order, dd/dzdz
    -59.598602238831020_REALK,    -54.618819057965105_REALK,      0.000000000000000_REALK, &
    -64.823285204989517_REALK,      0.000000000000000_REALK,     15.419826507110127_REALK, &
   -108.520821674530893_REALK,      0.000000000000000_REALK,     17.973051386186782_REALK, &
      0.000000000000000_REALK,   -194.737769245480109_REALK,      0.000000000000000_REALK, &
     26.062446831973652_REALK,      0.000000000000000_REALK,     49.752654952774542_REALK, &
   -743.882093069873576_REALK,      0.000000000000000_REALK,     83.860567485620038_REALK, &
      0.000000000000000_REALK,    111.460032110355002_REALK,      0.000000000000000_REALK, &
    -45.242476859764203_REALK,    -27.329290648606040_REALK,      0.000000000000000_REALK, &
    -23.971406766384703_REALK,      0.000000000000000_REALK,     10.482278132483057_REALK, &
    -25.848280566626240_REALK,      0.000000000000000_REALK,      7.758213675294905_REALK, &
      0.000000000000000_REALK,    -30.282124334759970_REALK,      0.000000000000000_REALK, &
      8.382587100516691_REALK,      0.000000000000000_REALK,     29.416625833398680_REALK, &
    -52.046667482606331_REALK,      0.000000000000000_REALK,     15.832895330425918_REALK, &
      0.000000000000000_REALK,     38.136694044380249_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     33.752540055689778_REALK, &
      0.000000000000000_REALK,     30.142437533400106_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     40.280178669741176_REALK,      0.000000000000000_REALK, &
      7.991875816107296_REALK,      0.000000000000000_REALK,     63.643518334873029_REALK, &
      0.000000000000000_REALK,      8.791678762791159_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    184.355065171765318_REALK,      0.000000000000000_REALK, &
     20.579222285817863_REALK,      0.000000000000000_REALK,    -29.143338602523496_REALK, &
    -49.160651428256095_REALK,    -21.296569757029562_REALK,      0.000000000000000_REALK, &
    -16.624711165313901_REALK,      0.000000000000000_REALK,      9.814272939931399_REALK, &
    -15.668790842922034_REALK,      0.000000000000000_REALK,      5.139404451648883_REALK, &
      0.000000000000000_REALK,    -19.728348669473643_REALK,      0.000000000000000_REALK, &
      4.962457846173198_REALK,      0.000000000000000_REALK,     23.510045953885886_REALK, &
    -41.268322445472919_REALK,      0.000000000000000_REALK,      7.541486201958663_REALK, &
      0.000000000000000_REALK,     19.851205174440807_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     25.821125773795675_REALK, &
      0.000000000000000_REALK,     15.321348954342128_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     14.250042343453583_REALK,      0.000000000000000_REALK, &
      5.197412667410257_REALK,      0.000000000000000_REALK,     15.237357192337093_REALK, &
      0.000000000000000_REALK,      3.814596572972901_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     24.776837689812933_REALK,      0.000000000000000_REALK, &
      5.720664791162460_REALK,      0.000000000000000_REALK,    -14.892600915555770_REALK, &
     10.490316654192011_REALK,      8.217729813421847_REALK,      0.000000000000000_REALK, &
      8.804012491396445_REALK,      0.000000000000000_REALK,    -14.709153788504024_REALK, &
     11.974193027303324_REALK,      0.000000000000000_REALK,    -13.928796252460668_REALK, &
      0.000000000000000_REALK,     19.636242031582217_REALK,      0.000000000000000_REALK, &
    -18.457886039752481_REALK,      0.000000000000000_REALK,    -11.298303166790022_REALK, &
     51.122727903396296_REALK,      0.000000000000000_REALK,    -40.478676149248862_REALK, &
      0.000000000000000_REALK,    -17.251142254907613_REALK,      0.000000000000000_REALK, &
    -62.207047205771865_REALK,    -18.573811520612750_REALK,      0.000000000000000_REALK, &
    -12.750628467173403_REALK,      0.000000000000000_REALK,     10.990115338148406_REALK, &
     -8.470444339274495_REALK,      0.000000000000000_REALK,      3.839799366576433_REALK, &
      0.000000000000000_REALK,     -7.803276735195337_REALK,      0.000000000000000_REALK, &
      3.216357310426525_REALK,      0.000000000000000_REALK,     22.247825653522071_REALK, &
     -7.399960674162144_REALK,      0.000000000000000_REALK,      3.189739022283702_REALK, &
      0.000000000000000_REALK,     11.604063999745495_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     27.432706927639163_REALK, &
      0.000000000000000_REALK,     11.911331487358215_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      9.606653779808225_REALK,      0.000000000000000_REALK, &
      4.730260413940420_REALK,      0.000000000000000_REALK,      9.160426532822751_REALK, &
      0.000000000000000_REALK,      2.506120201273935_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     14.381858179447169_REALK,      0.000000000000000_REALK, &
      3.017379850716913_REALK,      0.000000000000000_REALK,    -10.604639333250299_REALK, &
      9.047261813253613_REALK,      4.739816522483646_REALK,      0.000000000000000_REALK, &
      3.655254866250837_REALK,      0.000000000000000_REALK,    -11.226345650976825_REALK, &
      3.264667466085946_REALK,      0.000000000000000_REALK,     -6.882205197097985_REALK, &
      0.000000000000000_REALK,      3.330877228337308_REALK,      0.000000000000000_REALK, &
     -6.476031464863983_REALK,      0.000000000000000_REALK,     -7.287086436545928_REALK, &
      4.041294466442186_REALK,      0.000000000000000_REALK,     -8.634684985040572_REALK, &
      0.000000000000000_REALK,     -6.668979601398640_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.963115103710741_REALK, &
      0.000000000000000_REALK,      5.467218788878347_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      6.051494214793309_REALK,      0.000000000000000_REALK, &
     13.349942175744975_REALK,      0.000000000000000_REALK,      8.327035369305069_REALK, &
      0.000000000000000_REALK,     12.789909272561559_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     17.027331268154491_REALK,      0.000000000000000_REALK, &
     21.133911903074985_REALK,      0.000000000000000_REALK,     21.722456824199281_REALK, &
   -104.502507342525490_REALK,    -19.591241801794855_REALK,      0.000000000000000_REALK, &
    -13.445585901988117_REALK,      0.000000000000000_REALK,     15.135787333226773_REALK, &
     -6.753515929721067_REALK,      0.000000000000000_REALK,      3.329931409658938_REALK, &
      0.000000000000000_REALK,     -6.932703653812825_REALK,      0.000000000000000_REALK, &
      2.778997966563813_REALK,      0.000000000000000_REALK,     25.105341805112914_REALK, &
     -7.863797393937780_REALK,      0.000000000000000_REALK,      1.962515520151301_REALK, &
      0.000000000000000_REALK,      7.765529674461188_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     37.524779166224278_REALK, &
      0.000000000000000_REALK,     10.824905265746184_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      7.399814096698590_REALK,      0.000000000000000_REALK, &
      5.319861875318314_REALK,      0.000000000000000_REALK,      4.935489836994766_REALK, &
      0.000000000000000_REALK,      1.866128260614025_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.216950311642777_REALK,      0.000000000000000_REALK, &
      1.793547441813240_REALK,      0.000000000000000_REALK,     -9.203339045184741_REALK, &
     12.217080120410829_REALK,      4.501219590157488_REALK,      0.000000000000000_REALK, &
      2.997379310766489_REALK,      0.000000000000000_REALK,    -12.428087911516803_REALK, &
      2.332524480095259_REALK,      0.000000000000000_REALK,     -5.373560113795951_REALK, &
      0.000000000000000_REALK,      2.462884847248462_REALK,      0.000000000000000_REALK, &
     -4.351197445605166_REALK,      0.000000000000000_REALK,     -6.609911233556487_REALK, &
      3.709106096320151_REALK,      0.000000000000000_REALK,     -4.760668815460455_REALK, &
      0.000000000000000_REALK,     -4.018168052655857_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.491718184533917_REALK, &
      0.000000000000000_REALK,      3.285856118198366_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.523311248864794_REALK,      0.000000000000000_REALK, &
     10.232960390420990_REALK,      0.000000000000000_REALK,      2.262699923507259_REALK, &
      0.000000000000000_REALK,      6.298329129315950_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.648879844123234_REALK,      0.000000000000000_REALK, &
      6.800209724909375_REALK,      0.000000000000000_REALK,     12.848873815253716_REALK, &
     26.497188775635763_REALK,     17.653621484568351_REALK,      0.000000000000000_REALK, &
     16.133539467758997_REALK,      0.000000000000000_REALK,     -9.248611185527816_REALK, &
     18.117505049531616_REALK,      0.000000000000000_REALK,     -7.231119679008618_REALK, &
      0.000000000000000_REALK,     24.915703700788324_REALK,      0.000000000000000_REALK, &
     -8.035937843905577_REALK,      0.000000000000000_REALK,    -17.669900656618186_REALK, &
     46.701181698855542_REALK,      0.000000000000000_REALK,    -12.687614605281622_REALK, &
      0.000000000000000_REALK,    -19.423961534372406_REALK,      0.000000000000000_REALK, &
   -193.978325738538331_REALK,    -20.566586723945807_REALK,      0.000000000000000_REALK, &
    -17.305074502854694_REALK,      0.000000000000000_REALK,     24.831702689974009_REALK, &
     -4.666795960668826_REALK,      0.000000000000000_REALK,      2.956829644578392_REALK, &
      0.000000000000000_REALK,     -5.139787630341071_REALK,      0.000000000000000_REALK, &
      2.927879992112233_REALK,      0.000000000000000_REALK,     33.716223387726409_REALK, &
     -1.367199732595832_REALK,      0.000000000000000_REALK,      1.041106632794365_REALK, &
      0.000000000000000_REALK,      5.293651272022966_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     61.408658443778933_REALK, &
      0.000000000000000_REALK,     11.473997738443485_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      7.842750641300939_REALK,      0.000000000000000_REALK, &
      7.363810103824863_REALK,      0.000000000000000_REALK,      3.937215617237400_REALK, &
      0.000000000000000_REALK,      1.619211004470893_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.364748397114602_REALK,      0.000000000000000_REALK, &
      1.459330620663745_REALK,      0.000000000000000_REALK,     -9.780045475385965_REALK, &
     19.000789267920652_REALK,      4.860743358795478_REALK,      0.000000000000000_REALK, &
      2.821982236358899_REALK,      0.000000000000000_REALK,    -17.083762408638140_REALK, &
      1.541574203650319_REALK,      0.000000000000000_REALK,     -4.908235160706169_REALK, &
      0.000000000000000_REALK,      1.158368646320595_REALK,      0.000000000000000_REALK, &
     -3.353456386095488_REALK,      0.000000000000000_REALK,     -7.437828062480212_REALK, &
      0.797838693156034_REALK,      0.000000000000000_REALK,     -2.415457623207434_REALK, &
      0.000000000000000_REALK,     -2.817633976520020_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.539535788656384_REALK, &
      0.000000000000000_REALK,      3.135789757960432_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.079669499085204_REALK,      0.000000000000000_REALK, &
     11.385881441509408_REALK,      0.000000000000000_REALK,      1.617519119344626_REALK, &
      0.000000000000000_REALK,      4.920339248576121_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.844440401421774_REALK,      0.000000000000000_REALK, &
      4.302679865615019_REALK,      0.000000000000000_REALK,     10.975483393009853_REALK, &
     28.087340662372817_REALK,     12.607372854066297_REALK,      0.000000000000000_REALK, &
      8.222459773870362_REALK,      0.000000000000000_REALK,     -8.664875574970765_REALK, &
      6.038910620210513_REALK,      0.000000000000000_REALK,     -4.368044913505696_REALK, &
      0.000000000000000_REALK,      5.025621992476002_REALK,      0.000000000000000_REALK, &
     -3.352586344831439_REALK,      0.000000000000000_REALK,    -13.551620084390352_REALK, &
      4.428611549024475_REALK,      0.000000000000000_REALK,     -3.246634636952228_REALK, &
      0.000000000000000_REALK,     -9.007672419460443_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -7.590927416818382_REALK, &
      0.000000000000000_REALK,     -5.040559498768800_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.587863318842031_REALK,      0.000000000000000_REALK, &
     14.032353297087250_REALK,      0.000000000000000_REALK,     -5.149319050579092_REALK, &
      0.000000000000000_REALK,     10.965542772750796_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -7.647542081886773_REALK,      0.000000000000000_REALK, &
     13.160077905597415_REALK,      0.000000000000000_REALK,     32.863564432414378_REALK, &
   -685.348636124024210_REALK,    -23.098991297602513_REALK,      0.000000000000000_REALK, &
    -37.304387083155021_REALK,      0.000000000000000_REALK,     60.709432561571347_REALK, &
     -2.951368458500145_REALK,      0.000000000000000_REALK,      2.355856971948226_REALK, &
      0.000000000000000_REALK,     -8.434764621690798_REALK,      0.000000000000000_REALK, &
      4.530718842193321_REALK,      0.000000000000000_REALK,     59.171966342299278_REALK, &
     -1.688657792684511_REALK,      0.000000000000000_REALK,      0.461181931719865_REALK, &
      0.000000000000000_REALK,      2.954271446062641_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    167.563853078111805_REALK, &
      0.000000000000000_REALK,     15.617740080756729_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     11.909765674118395_REALK,      0.000000000000000_REALK, &
     14.254274944338057_REALK,      0.000000000000000_REALK,      2.993766359563192_REALK, &
      0.000000000000000_REALK,      1.582101282772772_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.266961166661553_REALK,      0.000000000000000_REALK, &
      1.552247458642807_REALK,      0.000000000000000_REALK,    -13.260377185153889_REALK, &
     58.263283066166423_REALK,      8.569245653069173_REALK,      0.000000000000000_REALK, &
      4.584735529306984_REALK,      0.000000000000000_REALK,    -36.249177933751618_REALK, &
      1.772528139213089_REALK,      0.000000000000000_REALK,     -6.138426866944632_REALK, &
      0.000000000000000_REALK,      1.389107637880550_REALK,      0.000000000000000_REALK, &
     -3.910930338023472_REALK,      0.000000000000000_REALK,    -11.328911364241211_REALK, &
      1.109842129411996_REALK,      0.000000000000000_REALK,     -1.945362675722529_REALK, &
      0.000000000000000_REALK,     -2.468247761482157_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     19.523726490754441_REALK, &
      0.000000000000000_REALK,      4.390587159291648_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.310191390055787_REALK,      0.000000000000000_REALK, &
     18.466599555659826_REALK,      0.000000000000000_REALK,      1.176325378881422_REALK, &
      0.000000000000000_REALK,      4.945362352537092_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.875809260850023_REALK,      0.000000000000000_REALK, &
      3.347843323874828_REALK,      0.000000000000000_REALK,     12.468562419702296_REALK, &
     69.230437076893679_REALK,     20.011158759932414_REALK,      0.000000000000000_REALK, &
     10.388137063774638_REALK,      0.000000000000000_REALK,    -14.778831924292527_REALK, &
      6.222298326416825_REALK,      0.000000000000000_REALK,     -4.918430717812591_REALK, &
      0.000000000000000_REALK,      5.015783460089169_REALK,      0.000000000000000_REALK, &
     -3.040487978224540_REALK,      0.000000000000000_REALK,    -16.591910724026118_REALK, &
      5.320587089060242_REALK,      0.000000000000000_REALK,     -2.343139242785347_REALK, &
      0.000000000000000_REALK,     -7.104352456091835_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -11.828505968220517_REALK, &
      0.000000000000000_REALK,     -4.667375115979598_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.758821747228255_REALK,      0.000000000000000_REALK, &
     15.511628234142444_REALK,      0.000000000000000_REALK,     -1.888642822014967_REALK, &
      0.000000000000000_REALK,      7.288723900420994_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.557330383598762_REALK,      0.000000000000000_REALK, &
      5.542989838865884_REALK,      0.000000000000000_REALK,     25.445676132624445_REALK, &
    135.597802760651689_REALK,     70.875975386275144_REALK,      0.000000000000000_REALK, &
     50.495051874093292_REALK,      0.000000000000000_REALK,     -0.482788389673722_REALK, &
     43.646177144732562_REALK,      0.000000000000000_REALK,     -0.290545730504912_REALK, &
      0.000000000000000_REALK,     45.823792608936969_REALK,      0.000000000000000_REALK, &
     -0.246499232115895_REALK,      0.000000000000000_REALK,    -28.543043111119712_REALK, &
     60.498049213068114_REALK,      0.000000000000000_REALK,     -0.274128763941799_REALK, &
      0.000000000000000_REALK,    -22.100372962852429_REALK,      0.000000000000000_REALK, &
    ! results of test 7, ket-major order, 01ODGXXX
   -185.369835469723512_REALK,     -4.965204610457830_REALK,      0.000000000000000_REALK, &
   -204.749384787095266_REALK,      0.000000000000000_REALK,    -44.664232150528676_REALK, &
    207.129386169144937_REALK,      0.000000000000000_REALK,     31.458591722364087_REALK, &
      0.000000000000000_REALK,   -574.740077412470669_REALK,      0.000000000000000_REALK, &
    -70.538349577979147_REALK,      0.000000000000000_REALK,    -46.161914835671482_REALK, &
   6098.778431475643629_REALK,      0.000000000000000_REALK,    630.500397398250129_REALK, &
      0.000000000000000_REALK,    287.279197066840936_REALK,      0.000000000000000_REALK, &
    -70.144901771295110_REALK,     -5.106412211496388_REALK,      0.000000000000000_REALK, &
    -30.391374364012570_REALK,      0.000000000000000_REALK,    -12.187126360558997_REALK, &
     41.513391269536136_REALK,      0.000000000000000_REALK,     11.426339054534491_REALK, &
      0.000000000000000_REALK,    -14.365456213600721_REALK,      0.000000000000000_REALK, &
     -3.646699483315819_REALK,      0.000000000000000_REALK,     -4.387046160187603_REALK, &
    419.023667869613860_REALK,      0.000000000000000_REALK,    116.894690115780037_REALK, &
      0.000000000000000_REALK,     96.523915928627702_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.102193636923472_REALK, &
      0.000000000000000_REALK,     12.738372181617073_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -21.563869122275928_REALK,      0.000000000000000_REALK, &
    -14.111890849524826_REALK,      0.000000000000000_REALK,     10.063892984214579_REALK, &
      0.000000000000000_REALK,      4.585480211911127_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,   -494.742758982798136_REALK,      0.000000000000000_REALK, &
   -182.160627329580819_REALK,      0.000000000000000_REALK,   -198.683491923418188_REALK, &
    -30.377172863823301_REALK,      1.370040310490277_REALK,      0.000000000000000_REALK, &
     -1.897620235171855_REALK,      0.000000000000000_REALK,     -1.027311482128561_REALK, &
     25.547794817883752_REALK,      0.000000000000000_REALK,      7.684569608593588_REALK, &
      0.000000000000000_REALK,     22.314933944572779_REALK,      0.000000000000000_REALK, &
      5.147430810769042_REALK,      0.000000000000000_REALK,      8.359967938821754_REALK, &
    319.630816608161354_REALK,      0.000000000000000_REALK,     53.564565486278589_REALK, &
      0.000000000000000_REALK,     48.335361423668346_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.553703930976374_REALK, &
      0.000000000000000_REALK,      0.582949512461295_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -7.744846886747505_REALK,      0.000000000000000_REALK, &
     -9.317192423229901_REALK,      0.000000000000000_REALK,     -5.745042745907212_REALK, &
      0.000000000000000_REALK,     -4.743876924290350_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -63.967068803007379_REALK,      0.000000000000000_REALK, &
    -48.714500942678804_REALK,      0.000000000000000_REALK,    -97.674059005867903_REALK, &
     -7.096316891508521_REALK,      0.578748963662829_REALK,      0.000000000000000_REALK, &
     -1.100146506384416_REALK,      0.000000000000000_REALK,     -0.719961122401042_REALK, &
     21.373658730025969_REALK,      0.000000000000000_REALK,      9.738625928992279_REALK, &
      0.000000000000000_REALK,     24.315204529555871_REALK,      0.000000000000000_REALK, &
      8.952678599799306_REALK,      0.000000000000000_REALK,      9.764730569674182_REALK, &
    433.471480017688634_REALK,      0.000000000000000_REALK,    134.438696281264555_REALK, &
      0.000000000000000_REALK,    102.092033781858902_REALK,      0.000000000000000_REALK, &
     -1.255931455901969_REALK,      7.481839118835676_REALK,      0.000000000000000_REALK, &
      7.648666167505757_REALK,      0.000000000000000_REALK,      6.045680353448016_REALK, &
     14.992761565712630_REALK,      0.000000000000000_REALK,      6.232650731021302_REALK, &
      0.000000000000000_REALK,     16.525578523154820_REALK,      0.000000000000000_REALK, &
      6.246442818297250_REALK,      0.000000000000000_REALK,     14.811993018842019_REALK, &
     53.834126133740909_REALK,      0.000000000000000_REALK,     21.280029406362672_REALK, &
      0.000000000000000_REALK,     26.539004890007455_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.683449671400457_REALK, &
      0.000000000000000_REALK,     -2.381733532896188_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.667954115748042_REALK,      0.000000000000000_REALK, &
     -9.205352423044445_REALK,      0.000000000000000_REALK,     -6.466571805276526_REALK, &
      0.000000000000000_REALK,     -5.835277156504006_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -34.875625306733795_REALK,      0.000000000000000_REALK, &
    -24.134492447249098_REALK,      0.000000000000000_REALK,    -65.328248368300748_REALK, &
     -0.199966934470106_REALK,      2.090179295640247_REALK,      0.000000000000000_REALK, &
      2.400415700143439_REALK,      0.000000000000000_REALK,      2.887743980097059_REALK, &
      6.325998323025201_REALK,      0.000000000000000_REALK,      5.223591676333089_REALK, &
      0.000000000000000_REALK,      7.722412005632222_REALK,      0.000000000000000_REALK, &
      5.881048701585001_REALK,      0.000000000000000_REALK,     11.791681876632783_REALK, &
     32.185735055290309_REALK,      0.000000000000000_REALK,     26.936484599295767_REALK, &
      0.000000000000000_REALK,     37.070617041429585_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.581437670914057_REALK, &
      0.000000000000000_REALK,     -3.018361875917506_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -9.857999724938640_REALK,      0.000000000000000_REALK, &
    -10.752168772383486_REALK,      0.000000000000000_REALK,    -16.230085598906967_REALK, &
      0.000000000000000_REALK,    -12.325041026725483_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,   -114.005441091923728_REALK,      0.000000000000000_REALK, &
    -69.959934704210141_REALK,      0.000000000000000_REALK,   -106.827902690876684_REALK, &
     34.051959801860953_REALK,     12.691532150539478_REALK,      0.000000000000000_REALK, &
     13.307911317152877_REALK,      0.000000000000000_REALK,     13.738015427616231_REALK, &
     12.566013245855762_REALK,      0.000000000000000_REALK,      5.681875179997750_REALK, &
      0.000000000000000_REALK,     18.131918147337608_REALK,      0.000000000000000_REALK, &
      6.665276327467742_REALK,      0.000000000000000_REALK,     20.642082780801235_REALK, &
     52.067010663408503_REALK,      0.000000000000000_REALK,     11.916048022849012_REALK, &
      0.000000000000000_REALK,     16.163956581937274_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.103058602209995_REALK, &
      0.000000000000000_REALK,     -3.571354949826089_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.589518650908362_REALK,      0.000000000000000_REALK, &
    -10.882980953250909_REALK,      0.000000000000000_REALK,     -4.302789705628933_REALK, &
      0.000000000000000_REALK,     -5.366146580803923_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -11.513988043324456_REALK,      0.000000000000000_REALK, &
    -13.056390338603579_REALK,      0.000000000000000_REALK,    -51.600344967588583_REALK, &
      4.358103130254907_REALK,      3.192250543133582_REALK,      0.000000000000000_REALK, &
      3.247779614203886_REALK,      0.000000000000000_REALK,      5.274734997952672_REALK, &
      4.751256478458402_REALK,      0.000000000000000_REALK,      4.287418315036309_REALK, &
      0.000000000000000_REALK,      7.051798598657848_REALK,      0.000000000000000_REALK, &
      4.879957807838042_REALK,      0.000000000000000_REALK,     13.209272844418550_REALK, &
     26.885261467242621_REALK,      0.000000000000000_REALK,     13.516506609967490_REALK, &
      0.000000000000000_REALK,     20.328278164462425_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.870459126334755_REALK, &
      0.000000000000000_REALK,     -2.993156651036279_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.321048553228001_REALK,      0.000000000000000_REALK, &
     -8.663834036847328_REALK,      0.000000000000000_REALK,     -5.446516375819844_REALK, &
      0.000000000000000_REALK,     -7.495622601888112_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -16.141478987962262_REALK,      0.000000000000000_REALK, &
    -20.487731893131787_REALK,      0.000000000000000_REALK,    -57.509937557466834_REALK, &
      3.054248760752348_REALK,      4.045527009923210_REALK,      0.000000000000000_REALK, &
      5.648706727269925_REALK,      0.000000000000000_REALK,      6.161072202472825_REALK, &
     11.924911942494639_REALK,      0.000000000000000_REALK,      9.055714958227531_REALK, &
      0.000000000000000_REALK,     23.051727464687836_REALK,      0.000000000000000_REALK, &
     14.145792804296722_REALK,      0.000000000000000_REALK,     21.600440074335474_REALK, &
    109.382388743400895_REALK,      0.000000000000000_REALK,     56.540535408824006_REALK, &
      0.000000000000000_REALK,     60.111216301114034_REALK,      0.000000000000000_REALK, &
    105.225676447000566_REALK,     16.507263077888080_REALK,      0.000000000000000_REALK, &
     20.013722082814077_REALK,      0.000000000000000_REALK,     26.335993569095855_REALK, &
      8.584219113753841_REALK,      0.000000000000000_REALK,      4.987662992540953_REALK, &
      0.000000000000000_REALK,     13.946478425957700_REALK,      0.000000000000000_REALK, &
      7.285535399630650_REALK,      0.000000000000000_REALK,     28.761038946901536_REALK, &
      7.891620127672138_REALK,      0.000000000000000_REALK,      5.510845515648413_REALK, &
      0.000000000000000_REALK,      9.605849945734986_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -16.429381206157846_REALK, &
      0.000000000000000_REALK,     -4.423315289746630_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.808716053216388_REALK,      0.000000000000000_REALK, &
    -14.892393047652062_REALK,      0.000000000000000_REALK,     -3.561125907226206_REALK, &
      0.000000000000000_REALK,     -4.830618711576313_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.397928379124597_REALK,      0.000000000000000_REALK, &
     -9.261212096311121_REALK,      0.000000000000000_REALK,    -47.802645969528541_REALK, &
     11.283785996265063_REALK,      4.271006405717267_REALK,      0.000000000000000_REALK, &
      3.572920449327492_REALK,      0.000000000000000_REALK,      8.472353672604820_REALK, &
      3.104281490296878_REALK,      0.000000000000000_REALK,      3.871448675081047_REALK, &
      0.000000000000000_REALK,      3.440969777727711_REALK,      0.000000000000000_REALK, &
      3.901918639510696_REALK,      0.000000000000000_REALK,     15.420827856143109_REALK, &
      5.041548871608271_REALK,      0.000000000000000_REALK,      5.978604053583628_REALK, &
      0.000000000000000_REALK,     12.426847036062956_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.308089585386622_REALK, &
      0.000000000000000_REALK,     -3.337736642508812_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.520683959172736_REALK,      0.000000000000000_REALK, &
     -9.529933832826256_REALK,      0.000000000000000_REALK,     -4.039424964690694_REALK, &
      0.000000000000000_REALK,     -6.075131443072164_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -9.798273811020170_REALK,      0.000000000000000_REALK, &
    -11.300937890399439_REALK,      0.000000000000000_REALK,    -42.825788463434897_REALK, &
      5.389746592347377_REALK,      3.579535333085195_REALK,      0.000000000000000_REALK, &
      3.363917637704696_REALK,      0.000000000000000_REALK,      6.744757381845414_REALK, &
      3.929432096097531_REALK,      0.000000000000000_REALK,      5.407775906605936_REALK, &
      0.000000000000000_REALK,      4.823901254405695_REALK,      0.000000000000000_REALK, &
      6.122784390012244_REALK,      0.000000000000000_REALK,     17.186917018641786_REALK, &
      9.042551699275029_REALK,      0.000000000000000_REALK,     12.612966280840080_REALK, &
      0.000000000000000_REALK,     24.301560860395110_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -7.368065961667968_REALK, &
      0.000000000000000_REALK,     -7.049834986753612_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -10.205593527033516_REALK,      0.000000000000000_REALK, &
    -15.583807458055951_REALK,      0.000000000000000_REALK,    -16.897209969842287_REALK, &
      0.000000000000000_REALK,    -17.964312435994600_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -53.382867353163384_REALK,      0.000000000000000_REALK, &
    -45.862080178044614_REALK,      0.000000000000000_REALK,    -90.039593442368343_REALK, &
    286.712824181068868_REALK,     14.482563624344682_REALK,      0.000000000000000_REALK, &
     35.171537736210787_REALK,      0.000000000000000_REALK,     52.489983668759095_REALK, &
      4.378477232343740_REALK,      0.000000000000000_REALK,      3.205069125533785_REALK, &
      0.000000000000000_REALK,     19.545191674832804_REALK,      0.000000000000000_REALK, &
      9.627707663214187_REALK,      0.000000000000000_REALK,     43.105156942519095_REALK, &
      7.716385524034441_REALK,      0.000000000000000_REALK,      1.932561705348787_REALK, &
      0.000000000000000_REALK,      4.243937007994961_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -35.019626789157329_REALK, &
      0.000000000000000_REALK,     -4.908269308738633_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.889543396554513_REALK,      0.000000000000000_REALK, &
    -23.250094566331878_REALK,      0.000000000000000_REALK,     -2.312403485326881_REALK, &
      0.000000000000000_REALK,     -4.030706509730758_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.976167455442853_REALK,      0.000000000000000_REALK, &
     -7.798537317558572_REALK,      0.000000000000000_REALK,    -51.310352915297990_REALK, &
     26.683647727038714_REALK,      5.881792544157973_REALK,      0.000000000000000_REALK, &
      4.732170849100722_REALK,      0.000000000000000_REALK,     14.655335743168305_REALK, &
      2.878773407959363_REALK,      0.000000000000000_REALK,      3.905016855107075_REALK, &
      0.000000000000000_REALK,      3.523851067548631_REALK,      0.000000000000000_REALK, &
      3.886093171918922_REALK,      0.000000000000000_REALK,     20.058447444026861_REALK, &
      5.551983355235615_REALK,      0.000000000000000_REALK,      3.811878160860506_REALK, &
      0.000000000000000_REALK,      8.617934538033268_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -11.265899760414971_REALK, &
      0.000000000000000_REALK,     -3.809822905171178_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.154266350608662_REALK,      0.000000000000000_REALK, &
    -12.466020668042580_REALK,      0.000000000000000_REALK,     -2.508679441591921_REALK, &
      0.000000000000000_REALK,     -5.214423869480381_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.683261386879156_REALK,      0.000000000000000_REALK, &
     -6.961112316203097_REALK,      0.000000000000000_REALK,    -38.515554650434638_REALK, &
     10.245233111029753_REALK,      4.438271570597383_REALK,      0.000000000000000_REALK, &
      3.464641666531778_REALK,      0.000000000000000_REALK,      9.378236223241977_REALK, &
      3.265424889415486_REALK,      0.000000000000000_REALK,      4.911066697385103_REALK, &
      0.000000000000000_REALK,      4.111449403989367_REALK,      0.000000000000000_REALK, &
      4.741981623512724_REALK,      0.000000000000000_REALK,     17.970110434690085_REALK, &
      8.600447131422674_REALK,      0.000000000000000_REALK,      7.206426753073656_REALK, &
      0.000000000000000_REALK,     15.173443299349692_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.968671930904838_REALK, &
      0.000000000000000_REALK,     -5.321694860022605_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.949588794057854_REALK,      0.000000000000000_REALK, &
    -13.893706925012507_REALK,      0.000000000000000_REALK,     -5.292521284675006_REALK, &
      0.000000000000000_REALK,    -10.197167362592817_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.605950440422809_REALK,      0.000000000000000_REALK, &
    -15.292462829250857_REALK,      0.000000000000000_REALK,    -55.191337242197243_REALK, &
     11.966785241859453_REALK,      9.374341222917119_REALK,      0.000000000000000_REALK, &
     10.043140757728123_REALK,      0.000000000000000_REALK,     15.335744210075596_REALK, &
     13.659511063953497_REALK,      0.000000000000000_REALK,     14.522144479102783_REALK, &
      0.000000000000000_REALK,     22.399961707087186_REALK,      0.000000000000000_REALK, &
     19.244167477914335_REALK,      0.000000000000000_REALK,     37.781474567256126_REALK, &
     58.318039956734275_REALK,      0.000000000000000_REALK,     42.203014008360896_REALK, &
      0.000000000000000_REALK,     57.687741489865417_REALK,      0.000000000000000_REALK, &
    ! results of test 7, ket-major order, 02ODGXXX
    108.400036960979691_REALK,    124.377243122153786_REALK,      0.000000000000000_REALK, &
     88.730759848736810_REALK,      0.000000000000000_REALK,     35.581575528399256_REALK, &
    206.530021740416288_REALK,      0.000000000000000_REALK,     56.846284564521561_REALK, &
      0.000000000000000_REALK,    182.002620741007462_REALK,      0.000000000000000_REALK, &
     46.201725385510571_REALK,      0.000000000000000_REALK,     55.581520460865597_REALK, &
    941.564555150001866_REALK,      0.000000000000000_REALK,    262.667494315643125_REALK, &
      0.000000000000000_REALK,    216.893471494680398_REALK,      0.000000000000000_REALK, &
     58.816088396128229_REALK,     12.428841567311713_REALK,      0.000000000000000_REALK, &
     -7.916467867035197_REALK,      0.000000000000000_REALK,     17.310103053452938_REALK, &
    -61.202593487958360_REALK,      0.000000000000000_REALK,      5.011519388350687_REALK, &
      0.000000000000000_REALK,   -135.273796598351737_REALK,      0.000000000000000_REALK, &
     -3.704723709048681_REALK,      0.000000000000000_REALK,     24.302182588996018_REALK, &
  -1021.734231833013496_REALK,      0.000000000000000_REALK,    -65.960337355472333_REALK, &
      0.000000000000000_REALK,     16.203308912920818_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -28.965753125648881_REALK, &
      0.000000000000000_REALK,    -18.093070398501695_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -29.125447975212367_REALK,      0.000000000000000_REALK, &
    -35.038446487841121_REALK,      0.000000000000000_REALK,    -30.762225429071062_REALK, &
      0.000000000000000_REALK,    -25.401414368370130_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,   -123.653126965681594_REALK,      0.000000000000000_REALK, &
    -94.168772820987499_REALK,      0.000000000000000_REALK,   -188.811259379423603_REALK, &
     43.200695491209189_REALK,     -4.419484490250125_REALK,      0.000000000000000_REALK, &
     -8.852421462657992_REALK,      0.000000000000000_REALK,     11.558104973278638_REALK, &
    -26.032399579881698_REALK,      0.000000000000000_REALK,     -1.550255468245399_REALK, &
      0.000000000000000_REALK,    -35.596093615444246_REALK,      0.000000000000000_REALK, &
     -3.704427133586933_REALK,      0.000000000000000_REALK,     14.509981655235265_REALK, &
   -119.682805462693565_REALK,      0.000000000000000_REALK,    -22.996566321722035_REALK, &
      0.000000000000000_REALK,     -4.108405671369874_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -12.662002860308659_REALK, &
      0.000000000000000_REALK,     -2.095025640137734_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.031261630487819_REALK,      0.000000000000000_REALK, &
    -13.324634954441105_REALK,      0.000000000000000_REALK,     10.706529740294153_REALK, &
      0.000000000000000_REALK,     -2.630083709736626_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     65.519792421635060_REALK,      0.000000000000000_REALK, &
      5.383142955255913_REALK,      0.000000000000000_REALK,    -58.853746943740845_REALK, &
     18.249359200316913_REALK,     13.234728206421375_REALK,      0.000000000000000_REALK, &
     12.175660824620497_REALK,      0.000000000000000_REALK,     14.647542610182224_REALK, &
     16.866609520669027_REALK,      0.000000000000000_REALK,     13.927332351551142_REALK, &
      0.000000000000000_REALK,     20.071090209919962_REALK,      0.000000000000000_REALK, &
     15.285257887348575_REALK,      0.000000000000000_REALK,     30.647407895352114_REALK, &
     53.409726517822179_REALK,      0.000000000000000_REALK,     44.699003248752717_REALK, &
      0.000000000000000_REALK,     61.515808622311852_REALK,      0.000000000000000_REALK, &
     34.440892090545269_REALK,    -17.015720914666659_REALK,      0.000000000000000_REALK, &
    -13.768675964530530_REALK,      0.000000000000000_REALK,      8.171590998853283_REALK, &
    -29.063916809644393_REALK,      0.000000000000000_REALK,     -5.134742631431708_REALK, &
      0.000000000000000_REALK,    -40.956595703093285_REALK,      0.000000000000000_REALK, &
     -5.076508818057994_REALK,      0.000000000000000_REALK,      9.038593224963691_REALK, &
   -149.885162355565512_REALK,      0.000000000000000_REALK,    -20.596227565476998_REALK, &
      0.000000000000000_REALK,    -10.916250045007365_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.593216743186430_REALK, &
      0.000000000000000_REALK,      0.796803080313695_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.986092815693923_REALK,      0.000000000000000_REALK, &
     -7.779386469780349_REALK,      0.000000000000000_REALK,      4.933270165805677_REALK, &
      0.000000000000000_REALK,      0.881343538163402_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     13.524286551846934_REALK,      0.000000000000000_REALK, &
      4.222351020281307_REALK,      0.000000000000000_REALK,    -27.564422080615849_REALK, &
      9.621650295821974_REALK,      1.557609093346866_REALK,      0.000000000000000_REALK, &
     -1.044031488518194_REALK,      0.000000000000000_REALK,      6.848619723154921_REALK, &
     -5.740202474335573_REALK,      0.000000000000000_REALK,      1.410093969245826_REALK, &
      0.000000000000000_REALK,    -14.055439090405438_REALK,      0.000000000000000_REALK, &
     -1.154802772201097_REALK,      0.000000000000000_REALK,     12.625425460547291_REALK, &
    -63.010920970853256_REALK,      0.000000000000000_REALK,    -12.203432580095127_REALK, &
      0.000000000000000_REALK,      4.996335571270358_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -10.890150997534130_REALK, &
      0.000000000000000_REALK,     -7.158395210067317_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.195043330950018_REALK,      0.000000000000000_REALK, &
    -16.431311629461597_REALK,      0.000000000000000_REALK,     -9.588921062534101_REALK, &
      0.000000000000000_REALK,    -13.196496344552443_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -22.877272293369277_REALK,      0.000000000000000_REALK, &
    -29.037204183226596_REALK,      0.000000000000000_REALK,    -81.508671049165542_REALK, &
     29.579412061240021_REALK,    -26.924300997127798_REALK,      0.000000000000000_REALK, &
    -11.808202968497577_REALK,      0.000000000000000_REALK,      6.284744980118134_REALK, &
    -21.540540348429570_REALK,      0.000000000000000_REALK,     -7.009170600400422_REALK, &
      0.000000000000000_REALK,    -16.988538931767646_REALK,      0.000000000000000_REALK, &
     -3.786667560408832_REALK,      0.000000000000000_REALK,      6.046196869704613_REALK, &
    -37.866437703941088_REALK,      0.000000000000000_REALK,    -12.099685760913216_REALK, &
      0.000000000000000_REALK,    -11.811508950701821_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.501649066541653_REALK, &
      0.000000000000000_REALK,      3.130150093577261_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.851880185457265_REALK,      0.000000000000000_REALK, &
     -5.077699231209679_REALK,      0.000000000000000_REALK,      5.681643681570513_REALK, &
      0.000000000000000_REALK,      3.011339960072126_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     12.924313380180237_REALK,      0.000000000000000_REALK, &
      4.805847975070444_REALK,      0.000000000000000_REALK,    -14.261147606389310_REALK, &
      7.439991728189554_REALK,     -0.633968832270978_REALK,      0.000000000000000_REALK, &
     -1.210726429566744_REALK,      0.000000000000000_REALK,      4.742330635482504_REALK, &
     -2.771411601871458_REALK,      0.000000000000000_REALK,     -0.495121009960253_REALK, &
      0.000000000000000_REALK,     -3.730788902519617_REALK,      0.000000000000000_REALK, &
     -1.164771263062052_REALK,      0.000000000000000_REALK,      7.603879110997129_REALK, &
     -8.101907758748153_REALK,      0.000000000000000_REALK,     -4.670246282736152_REALK, &
      0.000000000000000_REALK,     -1.390589218571254_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.449039487707774_REALK, &
      0.000000000000000_REALK,     -0.859596300458951_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.648744887911235_REALK,      0.000000000000000_REALK, &
     -7.092709181519075_REALK,      0.000000000000000_REALK,      3.366420155911860_REALK, &
      0.000000000000000_REALK,     -1.378281451749768_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     13.306054596235564_REALK,      0.000000000000000_REALK, &
      1.822054868576473_REALK,      0.000000000000000_REALK,    -27.888662787109265_REALK, &
      9.428673308471135_REALK,      5.695509423073371_REALK,      0.000000000000000_REALK, &
      4.995715947323050_REALK,      0.000000000000000_REALK,     10.016562723069836_REALK, &
      5.386862302076361_REALK,      0.000000000000000_REALK,      7.413525277177683_REALK, &
      0.000000000000000_REALK,      6.310889174436030_REALK,      0.000000000000000_REALK, &
      8.010158518283076_REALK,      0.000000000000000_REALK,     22.484856723759723_REALK, &
     10.846687859491501_REALK,      0.000000000000000_REALK,     15.129458230416557_REALK, &
      0.000000000000000_REALK,     29.150117568282692_REALK,      0.000000000000000_REALK, &
     25.649945409139484_REALK,    -43.062705659104942_REALK,      0.000000000000000_REALK, &
    -11.126260726141401_REALK,      0.000000000000000_REALK,      4.695866742186668_REALK, &
    -23.786370426486933_REALK,      0.000000000000000_REALK,     -9.530008080747605_REALK, &
      0.000000000000000_REALK,    -14.930855733243050_REALK,      0.000000000000000_REALK, &
     -3.045655451842951_REALK,      0.000000000000000_REALK,      3.856279974870435_REALK, &
    -46.602153396824669_REALK,      0.000000000000000_REALK,    -10.498770726932204_REALK, &
      0.000000000000000_REALK,    -12.618995845726108_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.627261312531953_REALK, &
      0.000000000000000_REALK,      5.031434541944777_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.339834758705781_REALK,      0.000000000000000_REALK, &
     -3.736029468661762_REALK,      0.000000000000000_REALK,      4.232659454967750_REALK, &
      0.000000000000000_REALK,      4.131850696414366_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.633341516888583_REALK,      0.000000000000000_REALK, &
      3.098251842980339_REALK,      0.000000000000000_REALK,     -8.244998315687802_REALK, &
      6.636538148803075_REALK,     -2.802686915655009_REALK,      0.000000000000000_REALK, &
     -2.047182083680176_REALK,      0.000000000000000_REALK,      3.644954982841379_REALK, &
     -3.510766963468124_REALK,      0.000000000000000_REALK,     -1.860749008580966_REALK, &
      0.000000000000000_REALK,     -4.521127102680831_REALK,      0.000000000000000_REALK, &
     -1.681160839443508_REALK,      0.000000000000000_REALK,      4.988772638201024_REALK, &
    -11.276731442852897_REALK,      0.000000000000000_REALK,     -4.648721528034771_REALK, &
      0.000000000000000_REALK,     -4.106464515432005_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.246207889215601_REALK, &
      0.000000000000000_REALK,      0.355415653859857_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.719728427113358_REALK,      0.000000000000000_REALK, &
     -4.698543075428299_REALK,      0.000000000000000_REALK,      1.633725245122334_REALK, &
      0.000000000000000_REALK,      0.486449873183946_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.052531918527864_REALK,      0.000000000000000_REALK, &
      1.588359973891713_REALK,      0.000000000000000_REALK,    -14.516821158735944_REALK, &
      5.562090181182702_REALK,      0.769668939832993_REALK,      0.000000000000000_REALK, &
     -0.465692394155766_REALK,      0.000000000000000_REALK,      5.091401537554991_REALK, &
     -2.080158019564798_REALK,      0.000000000000000_REALK,      0.851659353940061_REALK, &
      0.000000000000000_REALK,     -4.654666154802918_REALK,      0.000000000000000_REALK, &
     -0.637383310553692_REALK,      0.000000000000000_REALK,      9.755890736732324_REALK, &
    -14.222032840105651_REALK,      0.000000000000000_REALK,     -4.590675612047475_REALK, &
      0.000000000000000_REALK,      2.631323440231622_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.968671930904838_REALK, &
      0.000000000000000_REALK,     -5.321694860022611_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.949588794057850_REALK,      0.000000000000000_REALK, &
    -13.893706925012498_REALK,      0.000000000000000_REALK,     -5.292521284675004_REALK, &
      0.000000000000000_REALK,    -10.197167362592813_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.605950440422813_REALK,      0.000000000000000_REALK, &
    -15.292462829250866_REALK,      0.000000000000000_REALK,    -55.191337242197278_REALK, &
     15.944494137851121_REALK,    -70.165018448817918_REALK,      0.000000000000000_REALK, &
     -7.037618026485873_REALK,      0.000000000000000_REALK,      2.583224938203814_REALK, &
    -26.610427946850059_REALK,      0.000000000000000_REALK,    -13.302000459812641_REALK, &
      0.000000000000000_REALK,     -3.418900416752156_REALK,      0.000000000000000_REALK, &
     -1.627973029454649_REALK,      0.000000000000000_REALK,      1.792689165247453_REALK, &
    -24.155230712641661_REALK,      0.000000000000000_REALK,     -9.189452425004241_REALK, &
      0.000000000000000_REALK,    -13.780849442968366_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.771074797125506_REALK, &
      0.000000000000000_REALK,      8.028431615985555_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.143117627669978_REALK,      0.000000000000000_REALK, &
     -2.713524796895419_REALK,      0.000000000000000_REALK,      4.635399139574074_REALK, &
      0.000000000000000_REALK,      5.571517276352590_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.628170697421359_REALK,      0.000000000000000_REALK, &
      2.220266151299433_REALK,      0.000000000000000_REALK,     -4.685344984857987_REALK, &
      6.475525271143193_REALK,     -5.112016983105690_REALK,      0.000000000000000_REALK, &
     -1.971163423347462_REALK,      0.000000000000000_REALK,      3.147369535294750_REALK, &
     -2.978369429272242_REALK,      0.000000000000000_REALK,     -2.907433950556634_REALK, &
      0.000000000000000_REALK,     -2.045704953404004_REALK,      0.000000000000000_REALK, &
     -1.367934808814650_REALK,      0.000000000000000_REALK,      3.640317432619721_REALK, &
     -3.218820062233241_REALK,      0.000000000000000_REALK,     -3.085585571459114_REALK, &
      0.000000000000000_REALK,     -5.020160897232952_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.703331846932602_REALK, &
      0.000000000000000_REALK,      1.567563851292483_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.182972101384508_REALK,      0.000000000000000_REALK, &
     -3.510418939508324_REALK,      0.000000000000000_REALK,      2.052495509392697_REALK, &
      0.000000000000000_REALK,      1.813079128654059_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.295876907458650_REALK,      0.000000000000000_REALK, &
      2.042595081051119_REALK,      0.000000000000000_REALK,     -8.485838533154778_REALK, &
      4.886289256180174_REALK,     -0.361107919311404_REALK,      0.000000000000000_REALK, &
     -0.606325871940619_REALK,      0.000000000000000_REALK,      3.958226630682916_REALK, &
     -1.149593388665315_REALK,      0.000000000000000_REALK,     -0.342297188464803_REALK, &
      0.000000000000000_REALK,     -1.347748626643367_REALK,      0.000000000000000_REALK, &
     -0.701289955539677_REALK,      0.000000000000000_REALK,      6.409441834550678_REALK, &
     -2.066097432252584_REALK,      0.000000000000000_REALK,     -1.984961266752162_REALK, &
      0.000000000000000_REALK,     -0.827445020585492_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.172944398026753_REALK, &
      0.000000000000000_REALK,     -0.717469368891220_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.448503591436679_REALK,      0.000000000000000_REALK, &
     -6.864867593234052_REALK,      0.000000000000000_REALK,      2.026867176702940_REALK, &
      0.000000000000000_REALK,     -1.161777385946864_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.655376909018853_REALK,      0.000000000000000_REALK, &
      1.084180869592944_REALK,      0.000000000000000_REALK,    -21.335972818693669_REALK, &
     10.320626413390347_REALK,      5.406926051914128_REALK,      0.000000000000000_REALK, &
      4.169716837976129_REALK,      0.000000000000000_REALK,     11.704573070126651_REALK, &
      3.724155880187340_REALK,      0.000000000000000_REALK,      7.175378000768196_REALK, &
      0.000000000000000_REALK,      3.799684392042123_REALK,      0.000000000000000_REALK, &
      6.751901806831001_REALK,      0.000000000000000_REALK,     24.367984006750454_REALK, &
      4.610089911795323_REALK,      0.000000000000000_REALK,      9.002511100853109_REALK, &
      0.000000000000000_REALK,     22.301037552294584_REALK,      0.000000000000000_REALK, &
    ! results of test 7, ket-major order, 03ODGXXX
      0.000000000000000_REALK,      0.000000000000000_REALK,    -51.203278983397105_REALK, &
      0.000000000000000_REALK,    -37.190994700433897_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,   -107.280716473272662_REALK,      0.000000000000000_REALK, &
    -70.206962977980524_REALK,      0.000000000000000_REALK,   -127.504123137415178_REALK, &
      0.000000000000000_REALK,    -58.095573402932644_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,  -1111.708673029596866_REALK,      0.000000000000000_REALK, &
   -409.322917031006625_REALK,      0.000000000000000_REALK,   -446.450518271758312_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -28.965753125648884_REALK, &
      0.000000000000000_REALK,    -18.093070398501695_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -29.125447975212367_REALK,      0.000000000000000_REALK, &
    -35.038446487841121_REALK,      0.000000000000000_REALK,    -30.762225429071062_REALK, &
      0.000000000000000_REALK,    -25.401414368370126_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,   -123.653126965681608_REALK,      0.000000000000000_REALK, &
    -94.168772820987499_REALK,      0.000000000000000_REALK,   -188.811259379423603_REALK, &
    -24.213244378646976_REALK,    -28.965753125648881_REALK,      0.000000000000000_REALK, &
    -32.667750795442778_REALK,      0.000000000000000_REALK,      7.770834940720714_REALK, &
    -76.899944932876863_REALK,      0.000000000000000_REALK,     12.736050469823393_REALK, &
      0.000000000000000_REALK,   -124.563210554718594_REALK,      0.000000000000000_REALK, &
     16.670736575039836_REALK,      0.000000000000000_REALK,     31.824080447006370_REALK, &
   -801.671717325956820_REALK,      0.000000000000000_REALK,     90.375404621833638_REALK, &
      0.000000000000000_REALK,    120.118976095209632_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -23.323097384372772_REALK, &
      0.000000000000000_REALK,    -12.080899016547928_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -15.112107839711527_REALK,      0.000000000000000_REALK, &
    -24.543649380132248_REALK,      0.000000000000000_REALK,    -16.807073484031797_REALK, &
      0.000000000000000_REALK,    -15.166294432705381_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -57.873390387724641_REALK,      0.000000000000000_REALK, &
    -40.049314985029241_REALK,      0.000000000000000_REALK,   -108.407152213408864_REALK, &
    -17.459628546138035_REALK,    -12.662002860308656_REALK,      0.000000000000000_REALK, &
    -11.648766017929383_REALK,      0.000000000000000_REALK,      5.093802232390575_REALK, &
    -16.136716573507005_REALK,      0.000000000000000_REALK,      4.843343249553728_REALK, &
      0.000000000000000_REALK,    -19.202525181001683_REALK,      0.000000000000000_REALK, &
      5.315572913583296_REALK,      0.000000000000000_REALK,     18.653694571141472_REALK, &
    -51.098450938255404_REALK,      0.000000000000000_REALK,     15.544442408780100_REALK, &
      0.000000000000000_REALK,     37.441897509101317_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.976880285561074_REALK, &
      0.000000000000000_REALK,      4.661669233772026_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      8.002977307042928_REALK,      0.000000000000000_REALK, &
     -6.229799200996578_REALK,      0.000000000000000_REALK,     12.844076108960117_REALK, &
      0.000000000000000_REALK,     -6.961224273554163_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     57.603194260248422_REALK,      0.000000000000000_REALK, &
    -25.228159928875648_REALK,      0.000000000000000_REALK,    -78.165793531715508_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -22.799241340522691_REALK, &
      0.000000000000000_REALK,     -8.541206875167795_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.704207728538506_REALK,      0.000000000000000_REALK, &
    -20.640013502085953_REALK,      0.000000000000000_REALK,     -7.575321175776251_REALK, &
      0.000000000000000_REALK,     -9.447425183876488_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -16.318742529490173_REALK,      0.000000000000000_REALK, &
    -18.504784918873035_REALK,      0.000000000000000_REALK,    -73.133022267393685_REALK, &
    -16.955896890950491_REALK,     -8.593216743186426_REALK,      0.000000000000000_REALK, &
     -7.431220652816946_REALK,      0.000000000000000_REALK,      4.386965105039986_REALK, &
     -8.621006313600750_REALK,      0.000000000000000_REALK,      2.827712659514329_REALK, &
      0.000000000000000_REALK,    -11.877860225742921_REALK,      0.000000000000000_REALK, &
      2.987750351563466_REALK,      0.000000000000000_REALK,     14.154709267336772_REALK, &
    -36.455458196470929_REALK,      0.000000000000000_REALK,      6.661970215484872_REALK, &
      0.000000000000000_REALK,     17.536084277294918_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.315873599802132_REALK, &
      0.000000000000000_REALK,      2.179614745414173_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.495257213282411_REALK,      0.000000000000000_REALK, &
     -3.570684597155992_REALK,      0.000000000000000_REALK,      2.919670279047826_REALK, &
      0.000000000000000_REALK,     -2.867727622512552_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      6.965756787967827_REALK,      0.000000000000000_REALK, &
     -6.310068244072252_REALK,      0.000000000000000_REALK,    -35.940070862387707_REALK, &
    -11.883043039323635_REALK,    -10.890150997534128_REALK,      0.000000000000000_REALK, &
    -12.924764325083022_REALK,      0.000000000000000_REALK,     -2.564365771200312_REALK, &
    -21.637379840781691_REALK,      0.000000000000000_REALK,     -2.988975119629913_REALK, &
      0.000000000000000_REALK,    -38.827710825376379_REALK,      0.000000000000000_REALK, &
     -4.334267090412727_REALK,      0.000000000000000_REALK,      6.137987706985538_REALK, &
   -148.318628224007114_REALK,      0.000000000000000_REALK,    -13.946276808912129_REALK, &
      0.000000000000000_REALK,     13.750830132843435_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -26.141296779513997_REALK, &
      0.000000000000000_REALK,     -6.569015390074475_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.592273538506221_REALK,      0.000000000000000_REALK, &
    -20.415996188297484_REALK,      0.000000000000000_REALK,     -4.658857997184757_REALK, &
      0.000000000000000_REALK,     -6.319677316129246_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -10.073451700810612_REALK,      0.000000000000000_REALK, &
    -11.108974562709703_REALK,      0.000000000000000_REALK,    -57.340051451497430_REALK, &
    -18.885324995292766_REALK,     -6.501649066541654_REALK,      0.000000000000000_REALK, &
     -5.076485031560707_REALK,      0.000000000000000_REALK,      4.375561263734641_REALK, &
     -4.071501151028153_REALK,      0.000000000000000_REALK,      1.845682105275740_REALK, &
      0.000000000000000_REALK,     -4.306856314075864_REALK,      0.000000000000000_REALK, &
      1.775201528898204_REALK,      0.000000000000000_REALK,     12.279224695205171_REALK, &
     -5.785721222300463_REALK,      0.000000000000000_REALK,      2.493924166281640_REALK, &
      0.000000000000000_REALK,      9.072734613669011_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.056101957056083_REALK, &
      0.000000000000000_REALK,      1.509275474265256_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.469593401081183_REALK,      0.000000000000000_REALK, &
     -2.839064303458999_REALK,      0.000000000000000_REALK,      1.609073028153771_REALK, &
      0.000000000000000_REALK,     -1.727138165204248_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.578654561380378_REALK,      0.000000000000000_REALK, &
     -2.945777141315371_REALK,      0.000000000000000_REALK,    -22.650960683762147_REALK, &
     -9.020652826315873_REALK,     -5.449039487707771_REALK,      0.000000000000000_REALK, &
     -4.779529177154003_REALK,      0.000000000000000_REALK,     -1.743235907015325_REALK, &
     -5.153748895567466_REALK,      0.000000000000000_REALK,     -1.290215398040370_REALK, &
      0.000000000000000_REALK,     -6.037789029851708_REALK,      0.000000000000000_REALK, &
     -1.394050667480493_REALK,      0.000000000000000_REALK,      3.629130705040398_REALK, &
    -10.377303603040371_REALK,      0.000000000000000_REALK,     -2.633060419040397_REALK, &
      0.000000000000000_REALK,      4.704925987400422_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.628270394856170_REALK, &
      0.000000000000000_REALK,      5.919324175359548_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      7.910157734370427_REALK,      0.000000000000000_REALK, &
      2.523688827191882_REALK,      0.000000000000000_REALK,     12.498213399865589_REALK, &
      0.000000000000000_REALK,      2.776252030993544_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     36.203355913469949_REALK,      0.000000000000000_REALK, &
      6.498543589771831_REALK,      0.000000000000000_REALK,    -14.077688511470020_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -35.019626789157336_REALK, &
      0.000000000000000_REALK,     -4.908269308738639_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.889543396554510_REALK,      0.000000000000000_REALK, &
    -23.250094566331860_REALK,      0.000000000000000_REALK,     -2.312403485326881_REALK, &
      0.000000000000000_REALK,     -4.030706509730757_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.976167455442856_REALK,      0.000000000000000_REALK, &
     -7.798537317558576_REALK,      0.000000000000000_REALK,    -51.310352915298019_REALK, &
    -25.528928027347177_REALK,     -5.627261312531952_REALK,      0.000000000000000_REALK, &
     -4.527388843369718_REALK,      0.000000000000000_REALK,      5.096512357853825_REALK, &
     -2.754196123806774_REALK,      0.000000000000000_REALK,      1.358001413850795_REALK, &
      0.000000000000000_REALK,     -3.371358414066540_REALK,      0.000000000000000_REALK, &
      1.351420548907494_REALK,      0.000000000000000_REALK,     12.208672050497123_REALK, &
     -5.311724428936205_REALK,      0.000000000000000_REALK,      1.325611674404310_REALK, &
      0.000000000000000_REALK,      5.245347967289058_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.430282977897717_REALK, &
      0.000000000000000_REALK,      1.160029020170525_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.960422727021485_REALK,      0.000000000000000_REALK, &
     -2.708988119207522_REALK,      0.000000000000000_REALK,      0.763852028555395_REALK, &
      0.000000000000000_REALK,     -1.133145266407818_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.121493099286561_REALK,      0.000000000000000_REALK, &
     -1.512717735933643_REALK,      0.000000000000000_REALK,    -16.982877350629547_REALK, &
     -9.801876467205892_REALK,     -4.246207889215599_REALK,      0.000000000000000_REALK, &
     -3.314711266249121_REALK,      0.000000000000000_REALK,     -1.632144537084954_REALK, &
     -3.124115482012000_REALK,      0.000000000000000_REALK,     -0.854699166302938_REALK, &
      0.000000000000000_REALK,     -3.933528766240095_REALK,      0.000000000000000_REALK, &
     -0.825272387849707_REALK,      0.000000000000000_REALK,      2.900435628864251_REALK, &
     -8.228267666665836_REALK,      0.000000000000000_REALK,     -1.254172935821617_REALK, &
      0.000000000000000_REALK,      2.449044245884425_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.070711811493905_REALK, &
      0.000000000000000_REALK,      3.008782258039469_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.798400761386186_REALK,      0.000000000000000_REALK, &
      1.641248260216048_REALK,      0.000000000000000_REALK,      2.992288088753504_REALK, &
      0.000000000000000_REALK,      1.204580122735838_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.865636170391231_REALK,      0.000000000000000_REALK, &
      1.806481750938761_REALK,      0.000000000000000_REALK,     -7.193870258799849_REALK, &
    -11.448929407375813_REALK,     -8.968671930904835_REALK,      0.000000000000000_REALK, &
     -9.608529545709603_REALK,      0.000000000000000_REALK,     -6.098429218359369_REALK, &
    -13.068403480947923_REALK,      0.000000000000000_REALK,     -5.774892238122423_REALK, &
      0.000000000000000_REALK,    -21.430616086874238_REALK,      0.000000000000000_REALK, &
     -7.652657192417741_REALK,      0.000000000000000_REALK,     -3.289623922532654_REALK, &
    -55.794359900907338_REALK,      0.000000000000000_REALK,    -16.782497817244764_REALK, &
      0.000000000000000_REALK,     -5.022857805724947_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -53.330652663906243_REALK, &
      0.000000000000000_REALK,     -2.700068885653664_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.774669798779196_REALK,      0.000000000000000_REALK, &
    -30.331540500122561_REALK,      0.000000000000000_REALK,     -0.853261310218669_REALK, &
      0.000000000000000_REALK,     -1.873775746412055_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.749445911008716_REALK,      0.000000000000000_REALK, &
     -7.018546180693477_REALK,      0.000000000000000_REALK,    -52.372372394702438_REALK, &
    -38.554654309327645_REALK,     -4.771074797125497_REALK,      0.000000000000000_REALK, &
     -4.746860295588601_REALK,      0.000000000000000_REALK,      6.811448488791752_REALK, &
     -1.556740532388951_REALK,      0.000000000000000_REALK,      0.986333363163517_REALK, &
      0.000000000000000_REALK,     -2.101991962892955_REALK,      0.000000000000000_REALK, &
      1.197399708774855_REALK,      0.000000000000000_REALK,     13.788746866064868_REALK, &
     -0.769842606254949_REALK,      0.000000000000000_REALK,      0.586226155894562_REALK, &
      0.000000000000000_REALK,      2.980748309628080_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.533778501163123_REALK, &
      0.000000000000000_REALK,      1.001669434966905_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.832611704798959_REALK,      0.000000000000000_REALK, &
     -3.067197984291318_REALK,      0.000000000000000_REALK,      0.512450310332658_REALK, &
      0.000000000000000_REALK,     -0.826858381039067_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.782178506050622_REALK,      0.000000000000000_REALK, &
     -1.026042814459810_REALK,      0.000000000000000_REALK,    -15.044351920414984_REALK, &
    -12.403126776919832_REALK,     -3.703331846932602_REALK,      0.000000000000000_REALK, &
     -2.542278864975305_REALK,      0.000000000000000_REALK,     -1.827690835671612_REALK, &
     -1.688876095490299_REALK,      0.000000000000000_REALK,     -0.638570742633515_REALK, &
      0.000000000000000_REALK,     -1.555853154416189_REALK,      0.000000000000000_REALK, &
     -0.534890362806907_REALK,      0.000000000000000_REALK,      2.744715442785850_REALK, &
     -1.475438145814103_REALK,      0.000000000000000_REALK,     -0.530463657553776_REALK, &
      0.000000000000000_REALK,      1.431593997327764_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.387191567781992_REALK, &
      0.000000000000000_REALK,      2.339128425022492_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.886539464504739_REALK,      0.000000000000000_REALK, &
      1.493730086785070_REALK,      0.000000000000000_REALK,      1.798910064000599_REALK, &
      0.000000000000000_REALK,      0.791387115751695_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.824286546629246_REALK,      0.000000000000000_REALK, &
      0.952833601505742_REALK,      0.000000000000000_REALK,     -5.122570593097867_REALK, &
     -9.874007167228482_REALK,     -5.172944398026750_REALK,      0.000000000000000_REALK, &
     -3.989274710115638_REALK,      0.000000000000000_REALK,     -4.654453635995448_REALK, &
     -3.562995149706819_REALK,      0.000000000000000_REALK,     -2.853368852090553_REALK, &
      0.000000000000000_REALK,     -3.635255208109538_REALK,      0.000000000000000_REALK, &
     -2.684968834523132_REALK,      0.000000000000000_REALK,     -2.121714518839151_REALK, &
     -4.410590889287049_REALK,      0.000000000000000_REALK,     -3.579948647029271_REALK, &
      0.000000000000000_REALK,     -1.941745987143330_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     10.551592196804974_REALK, &
      0.000000000000000_REALK,      8.284778041398679_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      9.170162805695311_REALK,      0.000000000000000_REALK, &
      8.094838841377614_REALK,      0.000000000000000_REALK,     12.618415768892655_REALK, &
      0.000000000000000_REALK,      7.755258636650192_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     25.802453796250749_REALK,      0.000000000000000_REALK, &
     12.814708010802107_REALK,      0.000000000000000_REALK,      6.797058315800045_REALK, &
    ! results of test 7, ket-major order, 01ODGXXY
    -62.554719018127237_REALK,    -13.100634587427733_REALK,      0.000000000000000_REALK, &
    -13.448464213459742_REALK,      0.000000000000000_REALK,    -12.847839755572940_REALK, &
     -0.395518470850695_REALK,      0.000000000000000_REALK,      0.989779343619558_REALK, &
      0.000000000000000_REALK,     29.785590523684601_REALK,      0.000000000000000_REALK, &
     -3.377603115927000_REALK,      0.000000000000000_REALK,     -9.680265992288396_REALK, &
   -573.632345636412651_REALK,      0.000000000000000_REALK,     -4.077858517921617_REALK, &
      0.000000000000000_REALK,     30.614348694467257_REALK,      0.000000000000000_REALK, &
    -44.661503772400621_REALK,     -9.697622334846777_REALK,      0.000000000000000_REALK, &
     -9.860739459095237_REALK,      0.000000000000000_REALK,     -6.353875798318760_REALK, &
      4.442042311234995_REALK,      0.000000000000000_REALK,      1.424876225881305_REALK, &
      0.000000000000000_REALK,     -1.217338353620433_REALK,      0.000000000000000_REALK, &
     -0.263172772595932_REALK,      0.000000000000000_REALK,     -0.508734801536020_REALK, &
    180.465086847225848_REALK,      0.000000000000000_REALK,     23.046583419339616_REALK, &
      0.000000000000000_REALK,     22.177993702773222_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.870336239608498_REALK, &
      0.000000000000000_REALK,      2.219256803366059_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.595255134606825_REALK,      0.000000000000000_REALK, &
     -1.706010990189422_REALK,      0.000000000000000_REALK,     -0.023668319099300_REALK, &
      0.000000000000000_REALK,      0.177688894975982_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     27.234826266866538_REALK,      0.000000000000000_REALK, &
     -9.265060632679333_REALK,      0.000000000000000_REALK,    -44.256359850813105_REALK, &
    -28.762375530839325_REALK,     -3.594704140523127_REALK,      0.000000000000000_REALK, &
     -1.621083878443293_REALK,      0.000000000000000_REALK,     -1.558499185244382_REALK, &
      3.147640305665492_REALK,      0.000000000000000_REALK,      1.712786937090125_REALK, &
      0.000000000000000_REALK,      2.569764698228779_REALK,      0.000000000000000_REALK, &
      1.729606069379772_REALK,      0.000000000000000_REALK,      4.988495078695106_REALK, &
    -10.286358473300078_REALK,      0.000000000000000_REALK,      7.840071424897078_REALK, &
      0.000000000000000_REALK,     12.798513125766613_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.965545128200718_REALK, &
      0.000000000000000_REALK,      0.509457260495293_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.453429505643368_REALK,      0.000000000000000_REALK, &
     -2.809599807026177_REALK,      0.000000000000000_REALK,     -1.694552468314115_REALK, &
      0.000000000000000_REALK,     -1.630687433684959_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -16.745543320896466_REALK,      0.000000000000000_REALK, &
    -10.860508217651313_REALK,      0.000000000000000_REALK,    -34.990438905637767_REALK, &
     -3.752401995052739_REALK,     -0.686517888693490_REALK,      0.000000000000000_REALK, &
     -0.212830451280062_REALK,      0.000000000000000_REALK,     -0.609975568157993_REALK, &
     -0.130713496645499_REALK,      0.000000000000000_REALK,      0.981325994462884_REALK, &
      0.000000000000000_REALK,     -2.002502550373568_REALK,      0.000000000000000_REALK, &
      0.681234657585379_REALK,      0.000000000000000_REALK,      3.254049524792511_REALK, &
    -45.799088225253733_REALK,      0.000000000000000_REALK,     -0.976734680948958_REALK, &
      0.000000000000000_REALK,     12.221323182717551_REALK,      0.000000000000000_REALK, &
    -13.584278280508912_REALK,      0.754953716281056_REALK,      0.000000000000000_REALK, &
      2.715995444716299_REALK,      0.000000000000000_REALK,      3.126067300730874_REALK, &
      4.206610477414871_REALK,      0.000000000000000_REALK,      2.001452392058709_REALK, &
      0.000000000000000_REALK,      7.640212947167967_REALK,      0.000000000000000_REALK, &
      2.771177477972078_REALK,      0.000000000000000_REALK,      9.568742814274403_REALK, &
     31.822111317833674_REALK,      0.000000000000000_REALK,      5.721501182822448_REALK, &
      0.000000000000000_REALK,      8.166655046866145_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.544488868075741_REALK, &
      0.000000000000000_REALK,     -0.671543918034532_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.501456827796347_REALK,      0.000000000000000_REALK, &
     -4.330471619483344_REALK,      0.000000000000000_REALK,     -1.259190618877720_REALK, &
      0.000000000000000_REALK,     -2.055563883304832_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.034147575271932_REALK,      0.000000000000000_REALK, &
     -6.126490956780647_REALK,      0.000000000000000_REALK,    -29.449836900847689_REALK, &
     -1.595631252218588_REALK,      0.177987778066469_REALK,      0.000000000000000_REALK, &
      0.569855901905085_REALK,      0.000000000000000_REALK,      1.101578732101309_REALK, &
      1.471027084520901_REALK,      0.000000000000000_REALK,      1.415586372326949_REALK, &
      0.000000000000000_REALK,      2.689494765407715_REALK,      0.000000000000000_REALK, &
      1.744301719048491_REALK,      0.000000000000000_REALK,      5.619799875862927_REALK, &
     15.666969753279405_REALK,      0.000000000000000_REALK,      6.002326516256709_REALK, &
      0.000000000000000_REALK,      9.626847015121433_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.213105601725498_REALK, &
      0.000000000000000_REALK,     -0.384755096457198_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.591374212932694_REALK,      0.000000000000000_REALK, &
     -2.824813674907606_REALK,      0.000000000000000_REALK,      0.156872951881251_REALK, &
      0.000000000000000_REALK,     -1.962861646015267_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      7.093125991511583_REALK,      0.000000000000000_REALK, &
     -4.021703788538593_REALK,      0.000000000000000_REALK,    -26.894627891761520_REALK, &
     20.212085213446347_REALK,      4.098014348838684_REALK,      0.000000000000000_REALK, &
      7.236799359903080_REALK,      0.000000000000000_REALK,     10.393036676878079_REALK, &
      2.674356615016102_REALK,      0.000000000000000_REALK,      1.905154789463636_REALK, &
      0.000000000000000_REALK,      5.565178804588400_REALK,      0.000000000000000_REALK, &
      3.539111165621645_REALK,      0.000000000000000_REALK,     15.247947463482156_REALK, &
     -3.412643011827030_REALK,      0.000000000000000_REALK,      2.184591607643039_REALK, &
      0.000000000000000_REALK,      4.668769835280336_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.024715171241309_REALK, &
      0.000000000000000_REALK,     -1.454144283623233_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.029546257775339_REALK,      0.000000000000000_REALK, &
     -7.007925809406045_REALK,      0.000000000000000_REALK,     -1.494659296703705_REALK, &
      0.000000000000000_REALK,     -2.133420320774844_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.570787379459692_REALK,      0.000000000000000_REALK, &
     -4.973603404831610_REALK,      0.000000000000000_REALK,    -28.622689704606433_REALK, &
      2.039599227859639_REALK,      1.079412753626267_REALK,      0.000000000000000_REALK, &
      1.090875242354047_REALK,      0.000000000000000_REALK,      3.146280459055573_REALK, &
      0.922202070666092_REALK,      0.000000000000000_REALK,      1.505447420867607_REALK, &
      0.000000000000000_REALK,      0.792627098385751_REALK,      0.000000000000000_REALK, &
      1.600457008069019_REALK,      0.000000000000000_REALK,      7.693343250965783_REALK, &
     -0.988367990069720_REALK,      0.000000000000000_REALK,      2.259947188213022_REALK, &
      0.000000000000000_REALK,      6.148745800969837_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.770633462117755_REALK, &
      0.000000000000000_REALK,     -1.028486532810720_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.277486214602392_REALK,      0.000000000000000_REALK, &
     -4.115811382766600_REALK,      0.000000000000000_REALK,     -1.568020846750676_REALK, &
      0.000000000000000_REALK,     -2.514874318700649_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.827002394771694_REALK,      0.000000000000000_REALK, &
     -5.217676744436826_REALK,      0.000000000000000_REALK,    -23.534471313451316_REALK, &
      0.798271638257676_REALK,      0.618439906885208_REALK,      0.000000000000000_REALK, &
      0.429659698442151_REALK,      0.000000000000000_REALK,      2.052352918293717_REALK, &
     -0.114890119801981_REALK,      0.000000000000000_REALK,      1.437554447474896_REALK, &
      0.000000000000000_REALK,     -1.852976407264071_REALK,      0.000000000000000_REALK, &
      1.050611852388436_REALK,      0.000000000000000_REALK,      7.025831914619665_REALK, &
    -13.201859402542505_REALK,      0.000000000000000_REALK,     -0.469249295533834_REALK, &
      0.000000000000000_REALK,      8.220027780495807_REALK,      0.000000000000000_REALK, &
    104.758221486394632_REALK,      3.427655496372906_REALK,      0.000000000000000_REALK, &
     16.233136143779117_REALK,      0.000000000000000_REALK,     25.171412133763958_REALK, &
      0.849993266572325_REALK,      0.000000000000000_REALK,      0.944123367979056_REALK, &
      0.000000000000000_REALK,     10.969520848582100_REALK,      0.000000000000000_REALK, &
      5.303629645076192_REALK,      0.000000000000000_REALK,     24.671729433912446_REALK, &
      4.633025786368841_REALK,      0.000000000000000_REALK,      0.444767060189019_REALK, &
      0.000000000000000_REALK,      1.482064592788407_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -14.687641123424660_REALK, &
      0.000000000000000_REALK,     -1.829181855739753_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.817005570319087_REALK,      0.000000000000000_REALK, &
    -12.136819368039616_REALK,      0.000000000000000_REALK,     -0.838912556278529_REALK, &
      0.000000000000000_REALK,     -1.792870403551919_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.317873627043945_REALK,      0.000000000000000_REALK, &
     -4.422074863367058_REALK,      0.000000000000000_REALK,    -31.753530778757124_REALK, &
      9.334163307260146_REALK,      2.055024921354661_REALK,      0.000000000000000_REALK, &
      1.948612895203298_REALK,      0.000000000000000_REALK,      6.728466793265008_REALK, &
      1.189695199586639_REALK,      0.000000000000000_REALK,      1.698126067876435_REALK, &
      0.000000000000000_REALK,      1.755243822823804_REALK,      0.000000000000000_REALK, &
      1.909930593738988_REALK,      0.000000000000000_REALK,     10.991497771780345_REALK, &
      3.462356940082554_REALK,      0.000000000000000_REALK,      1.867557981635307_REALK, &
      0.000000000000000_REALK,      4.442803071166889_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.446384602785151_REALK, &
      0.000000000000000_REALK,     -1.445413843668053_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.273906383778350_REALK,      0.000000000000000_REALK, &
     -6.123625333633918_REALK,      0.000000000000000_REALK,     -0.867850112618417_REALK, &
      0.000000000000000_REALK,     -2.361201077469914_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.990377584587551_REALK,      0.000000000000000_REALK, &
     -3.332918150951669_REALK,      0.000000000000000_REALK,    -22.429716341468534_REALK, &
      3.289217662983197_REALK,      1.453477127412275_REALK,      0.000000000000000_REALK, &
      1.226543175195875_REALK,      0.000000000000000_REALK,      3.951682847315177_REALK, &
      1.248088362575421_REALK,      0.000000000000000_REALK,      2.001749770747247_REALK, &
      0.000000000000000_REALK,      1.853633834348308_REALK,      0.000000000000000_REALK, &
      2.003658038507743_REALK,      0.000000000000000_REALK,      9.037553481921641_REALK, &
      5.113863211043205_REALK,      0.000000000000000_REALK,      3.265370525329701_REALK, &
      0.000000000000000_REALK,      7.332042229601329_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.900424972960483_REALK, &
      0.000000000000000_REALK,     -1.380228276726728_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.836249358079044_REALK,      0.000000000000000_REALK, &
     -5.592310247799970_REALK,      0.000000000000000_REALK,      0.180198040068875_REALK, &
      0.000000000000000_REALK,     -3.156601212734788_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.858784503375616_REALK,      0.000000000000000_REALK, &
     -3.063028005555219_REALK,      0.000000000000000_REALK,    -26.336065681416180_REALK, &
    387.917791923009531_REALK,    -16.440805815275251_REALK,      0.000000000000000_REALK, &
     40.232644235815634_REALK,      0.000000000000000_REALK,     62.847959013613981_REALK, &
     -8.756294685194153_REALK,      0.000000000000000_REALK,     -3.116875208605697_REALK, &
      0.000000000000000_REALK,     17.218983998443235_REALK,      0.000000000000000_REALK, &
      9.306793786342681_REALK,      0.000000000000000_REALK,     43.614806250655882_REALK, &
    -16.430708570487617_REALK,      0.000000000000000_REALK,     -3.023835377229775_REALK, &
      0.000000000000000_REALK,     -3.229077319015570_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -41.667140366324020_REALK, &
      0.000000000000000_REALK,     -1.167740450490173_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.094304038472303_REALK,      0.000000000000000_REALK, &
    -23.697976537249438_REALK,      0.000000000000000_REALK,     -0.243194963785496_REALK, &
      0.000000000000000_REALK,     -0.810380707640005_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.638623367160541_REALK,      0.000000000000000_REALK, &
     -5.277690162693115_REALK,      0.000000000000000_REALK,    -40.918437762985782_REALK, &
     30.885151187847246_REALK,      3.027910263183332_REALK,      0.000000000000000_REALK, &
      3.484217704259505_REALK,      0.000000000000000_REALK,     15.011443839897456_REALK, &
      0.805802046781763_REALK,      0.000000000000000_REALK,      1.722108734675948_REALK, &
      0.000000000000000_REALK,      1.267394200795235_REALK,      0.000000000000000_REALK, &
      2.417954098930490_REALK,      0.000000000000000_REALK,     17.362568991776520_REALK, &
     -0.434697097354784_REALK,      0.000000000000000_REALK,      0.834809525160070_REALK, &
      0.000000000000000_REALK,      2.973502778609417_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -11.137872155732751_REALK, &
      0.000000000000000_REALK,     -2.100329858094482_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.834548750197762_REALK,      0.000000000000000_REALK, &
    -10.557681292777284_REALK,      0.000000000000000_REALK,     -1.021165316330064_REALK, &
      0.000000000000000_REALK,     -2.429288112162216_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.746659113998517_REALK,      0.000000000000000_REALK, &
     -3.167648880913412_REALK,      0.000000000000000_REALK,    -25.521392255126401_REALK, &
      9.349851316650053_REALK,      2.392645322856540_REALK,      0.000000000000000_REALK, &
      1.575633084540534_REALK,      0.000000000000000_REALK,      7.574015481723930_REALK, &
      0.833597484998810_REALK,      0.000000000000000_REALK,      2.268008324406169_REALK, &
      0.000000000000000_REALK,      0.541530302885687_REALK,      0.000000000000000_REALK, &
      1.822412182854193_REALK,      0.000000000000000_REALK,     12.264384082454713_REALK, &
     -0.377690278396572_REALK,      0.000000000000000_REALK,      1.439342585038455_REALK, &
      0.000000000000000_REALK,      5.482522959341508_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.541362201185930_REALK, &
      0.000000000000000_REALK,     -2.475867305418550_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.924576925684043_REALK,      0.000000000000000_REALK, &
     -8.680855995215600_REALK,      0.000000000000000_REALK,     -1.785477697733039_REALK, &
      0.000000000000000_REALK,     -4.009100277668549_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.074279850924823_REALK,      0.000000000000000_REALK, &
     -4.652336179076576_REALK,      0.000000000000000_REALK,    -26.980055338497646_REALK, &
      6.099009571797412_REALK,      2.284741318378407_REALK,      0.000000000000000_REALK, &
      1.034316314207577_REALK,      0.000000000000000_REALK,      6.916857594601573_REALK, &
     -0.173085917509324_REALK,      0.000000000000000_REALK,      3.032015314419713_REALK, &
      0.000000000000000_REALK,     -2.109951571403790_REALK,      0.000000000000000_REALK, &
      1.674838475152329_REALK,      0.000000000000000_REALK,     14.400343714578380_REALK, &
     -8.408160393692635_REALK,      0.000000000000000_REALK,     -0.418405658600050_REALK, &
      0.000000000000000_REALK,      9.423487846740223_REALK,      0.000000000000000_REALK, &
    ! results of test 7, ket-major order, 02ODGXXY
     74.374922259521938_REALK,     42.889862362053705_REALK,      0.000000000000000_REALK, &
     33.970411119809668_REALK,      0.000000000000000_REALK,     21.889207596293353_REALK, &
     53.913678692023261_REALK,      0.000000000000000_REALK,     17.293918795813894_REALK, &
      0.000000000000000_REALK,     73.535241581726098_REALK,      0.000000000000000_REALK, &
     15.897366047014918_REALK,      0.000000000000000_REALK,     30.730927371772541_REALK, &
    454.986647259241977_REALK,      0.000000000000000_REALK,     58.104799681406980_REALK, &
      0.000000000000000_REALK,     55.914920575766146_REALK,      0.000000000000000_REALK, &
     61.561623512152245_REALK,     18.339944042264268_REALK,      0.000000000000000_REALK, &
     17.094656427985150_REALK,      0.000000000000000_REALK,     16.470468791959139_REALK, &
     20.410592308096245_REALK,      0.000000000000000_REALK,      6.433238673324489_REALK, &
      0.000000000000000_REALK,     36.111142441006656_REALK,      0.000000000000000_REALK, &
      7.153512672018722_REALK,      0.000000000000000_REALK,     20.676936277786702_REALK, &
    168.729864492439532_REALK,      0.000000000000000_REALK,     18.030360137891616_REALK, &
      0.000000000000000_REALK,     17.049031461038236_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -16.011528547131803_REALK, &
      0.000000000000000_REALK,     -7.229584580658278_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.716361114392832_REALK,      0.000000000000000_REALK, &
    -16.849449120085239_REALK,      0.000000000000000_REALK,     -9.431436993570909_REALK, &
      0.000000000000000_REALK,     -9.075980870812810_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -35.616755685617932_REALK,      0.000000000000000_REALK, &
    -23.099642716700139_REALK,      0.000000000000000_REALK,    -74.422542759748652_REALK, &
     55.967357669537328_REALK,      1.763839268999601_REALK,      0.000000000000000_REALK, &
      3.819951421295188_REALK,      0.000000000000000_REALK,     13.279050814352621_REALK, &
     -5.328664911951759_REALK,      0.000000000000000_REALK,      0.532264294586488_REALK, &
      0.000000000000000_REALK,     -8.195970416387460_REALK,      0.000000000000000_REALK, &
      1.408415531363650_REALK,      0.000000000000000_REALK,     14.687952290000704_REALK, &
    -52.815755096393893_REALK,      0.000000000000000_REALK,     -3.776173592346376_REALK, &
      0.000000000000000_REALK,      1.131571832669535_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -12.245459659555578_REALK, &
      0.000000000000000_REALK,     -3.306567527931293_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.835286702242368_REALK,      0.000000000000000_REALK, &
    -11.085739605872416_REALK,      0.000000000000000_REALK,     -3.867909517560191_REALK, &
      0.000000000000000_REALK,     -3.657392894485140_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -13.719972853280732_REALK,      0.000000000000000_REALK, &
     -8.153660590442449_REALK,      0.000000000000000_REALK,    -39.279704994614519_REALK, &
     12.166900456561784_REALK,      5.375049578492630_REALK,      0.000000000000000_REALK, &
      4.480050886668017_REALK,      0.000000000000000_REALK,      8.660310016947225_REALK, &
      5.056573818058455_REALK,      0.000000000000000_REALK,      4.865999452239928_REALK, &
      0.000000000000000_REALK,      7.640578848533577_REALK,      0.000000000000000_REALK, &
      4.955382323639613_REALK,      0.000000000000000_REALK,     15.965275194726253_REALK, &
     28.059280760137142_REALK,      0.000000000000000_REALK,     10.750066387177970_REALK, &
      0.000000000000000_REALK,     17.241521971767298_REALK,      0.000000000000000_REALK, &
     57.509854356462426_REALK,     -8.710551337400435_REALK,      0.000000000000000_REALK, &
      2.402995694148384_REALK,      0.000000000000000_REALK,     12.219132947125489_REALK, &
     -5.968979896375705_REALK,      0.000000000000000_REALK,     -2.267607257618271_REALK, &
      0.000000000000000_REALK,      1.725407636594691_REALK,      0.000000000000000_REALK, &
      0.770595311336485_REALK,      0.000000000000000_REALK,     11.755335118470621_REALK, &
      3.580268041291038_REALK,      0.000000000000000_REALK,     -3.352876942319598_REALK, &
      0.000000000000000_REALK,     -3.821260024474869_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -10.565351146895376_REALK, &
      0.000000000000000_REALK,     -0.324469452725655_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.791219416875316_REALK,      0.000000000000000_REALK, &
     -8.251395122528082_REALK,      0.000000000000000_REALK,      1.041689443528508_REALK, &
      0.000000000000000_REALK,     -0.312153666630996_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.586330438300500_REALK,      0.000000000000000_REALK, &
     -1.333323977569899_REALK,      0.000000000000000_REALK,    -23.174740850686412_REALK, &
     10.602097130531670_REALK,      2.630839170052460_REALK,      0.000000000000000_REALK, &
      2.337998979039829_REALK,      0.000000000000000_REALK,      6.757890580977277_REALK, &
      2.172913493823350_REALK,      0.000000000000000_REALK,      2.054649504224534_REALK, &
      0.000000000000000_REALK,      3.784770624880026_REALK,      0.000000000000000_REALK, &
      2.249256278999802_REALK,      0.000000000000000_REALK,     10.835639050263969_REALK, &
     11.422140323155604_REALK,      0.000000000000000_REALK,      3.661686759333420_REALK, &
      0.000000000000000_REALK,      5.770656851638708_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.890493729501073_REALK, &
      0.000000000000000_REALK,     -2.966323676582959_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.783833765812145_REALK,      0.000000000000000_REALK, &
     -8.968969347842052_REALK,      0.000000000000000_REALK,     -2.965496791633398_REALK, &
      0.000000000000000_REALK,     -4.756219752385627_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -7.233211189740043_REALK,      0.000000000000000_REALK, &
     -7.818632502272023_REALK,      0.000000000000000_REALK,    -35.266152225955878_REALK, &
     67.786591177060942_REALK,    -23.128341499079585_REALK,      0.000000000000000_REALK, &
      1.599155726692037_REALK,      0.000000000000000_REALK,     12.410038072094357_REALK, &
    -12.423226717799366_REALK,      0.000000000000000_REALK,     -5.118426211426778_REALK, &
      0.000000000000000_REALK,     -3.779260322705169_REALK,      0.000000000000000_REALK, &
      0.437746110506127_REALK,      0.000000000000000_REALK,     10.191213663467883_REALK, &
    -27.823308250920533_REALK,      0.000000000000000_REALK,     -5.483333802522362_REALK, &
      0.000000000000000_REALK,     -6.777475795548672_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -10.940818493601164_REALK, &
      0.000000000000000_REALK,      1.627769979360107_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.476161602674763_REALK,      0.000000000000000_REALK, &
     -7.263785709105808_REALK,      0.000000000000000_REALK,      1.172888831303113_REALK, &
      0.000000000000000_REALK,      1.336736564244718_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.470576243684010_REALK,      0.000000000000000_REALK, &
     -0.630501174304960_REALK,      0.000000000000000_REALK,    -16.030360959263788_REALK, &
     10.784549461875050_REALK,      0.290524819097300_REALK,      0.000000000000000_REALK, &
      0.567965731080430_REALK,      0.000000000000000_REALK,      5.923147945115047_REALK, &
     -0.643674452235708_REALK,      0.000000000000000_REALK,      0.192884109203873_REALK, &
      0.000000000000000_REALK,     -0.904738866748659_REALK,      0.000000000000000_REALK, &
      0.466417595606260_REALK,      0.000000000000000_REALK,      8.106887064369678_REALK, &
     -3.973636061190869_REALK,      0.000000000000000_REALK,     -0.852310425126653_REALK, &
      0.000000000000000_REALK,      0.425673611209102_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.050908404551135_REALK, &
      0.000000000000000_REALK,     -1.474901251020267_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.389846861094069_REALK,      0.000000000000000_REALK, &
     -6.695492666871433_REALK,      0.000000000000000_REALK,     -1.280915338569345_REALK, &
      0.000000000000000_REALK,     -2.018666084979348_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.096699770107714_REALK,      0.000000000000000_REALK, &
     -3.067236253061268_REALK,      0.000000000000000_REALK,    -20.686682670402142_REALK, &
      7.033450134251376_REALK,      2.655999331474705_REALK,      0.000000000000000_REALK, &
      1.998335918309549_REALK,      0.000000000000000_REALK,      6.438248511143176_REALK, &
      1.832421874695842_REALK,      0.000000000000000_REALK,      2.938934595957332_REALK, &
      0.000000000000000_REALK,      2.530290483322524_REALK,      0.000000000000000_REALK, &
      2.735080021050246_REALK,      0.000000000000000_REALK,     12.336652009734365_REALK, &
      6.333188061558518_REALK,      0.000000000000000_REALK,      4.043949705757668_REALK, &
      0.000000000000000_REALK,      9.080258974287558_REALK,      0.000000000000000_REALK, &
     85.748966922542223_REALK,    -46.064752962828003_REALK,      0.000000000000000_REALK, &
      6.144354904203535_REALK,      0.000000000000000_REALK,     13.892499057319002_REALK, &
    -16.639962023524205_REALK,      0.000000000000000_REALK,     -8.733032195233712_REALK, &
      0.000000000000000_REALK,      4.819270811434685_REALK,      0.000000000000000_REALK, &
      1.421339440389539_REALK,      0.000000000000000_REALK,      9.641023578683511_REALK, &
    -12.177793946890324_REALK,      0.000000000000000_REALK,     -5.746323947682079_REALK, &
      0.000000000000000_REALK,     -9.047406232371035_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -12.608794739683361_REALK, &
      0.000000000000000_REALK,      4.311951728868240_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.308026111522882_REALK,      0.000000000000000_REALK, &
     -7.171188597946291_REALK,      0.000000000000000_REALK,      2.420992081006870_REALK, &
      0.000000000000000_REALK,      2.992379421200148_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.918353362040543_REALK,      0.000000000000000_REALK, &
     -0.319114518167714_REALK,      0.000000000000000_REALK,    -12.382231616714934_REALK, &
     12.590058059775416_REALK,     -1.653840015150452_REALK,      0.000000000000000_REALK, &
      0.401136161988703_REALK,      0.000000000000000_REALK,      6.119281992692115_REALK, &
     -0.825319465516664_REALK,      0.000000000000000_REALK,     -0.940613191374077_REALK, &
      0.000000000000000_REALK,      0.207768011304524_REALK,      0.000000000000000_REALK, &
      0.278377790780432_REALK,      0.000000000000000_REALK,      7.077697316221530_REALK, &
      0.304339127160110_REALK,      0.000000000000000_REALK,     -0.855029537173574_REALK, &
      0.000000000000000_REALK,     -1.624122729203734_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.018011888349433_REALK, &
      0.000000000000000_REALK,     -0.162492714322243_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.328201198988009_REALK,      0.000000000000000_REALK, &
     -5.704523327701826_REALK,      0.000000000000000_REALK,      0.376310628552658_REALK, &
      0.000000000000000_REALK,     -0.187942678477238_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.659549680969834_REALK,      0.000000000000000_REALK, &
     -0.566693123078216_REALK,      0.000000000000000_REALK,    -13.789711342621839_REALK, &
      6.963033722955658_REALK,      1.498522972079675_REALK,      0.000000000000000_REALK, &
      1.170858449063411_REALK,      0.000000000000000_REALK,      5.640530895236470_REALK, &
      0.901333813048257_REALK,      0.000000000000000_REALK,      1.420462340374363_REALK, &
      0.000000000000000_REALK,      1.367249540277462_REALK,      0.000000000000000_REALK, &
      1.354240859059616_REALK,      0.000000000000000_REALK,      9.133548445346792_REALK, &
      2.912802206001280_REALK,      0.000000000000000_REALK,      1.556300449319733_REALK, &
      0.000000000000000_REALK,      3.433725224981912_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.541362201185928_REALK, &
      0.000000000000000_REALK,     -2.475867305418551_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.924576925684043_REALK,      0.000000000000000_REALK, &
     -8.680855995215598_REALK,      0.000000000000000_REALK,     -1.785477697733039_REALK, &
      0.000000000000000_REALK,     -4.009100277668549_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.074279850924824_REALK,      0.000000000000000_REALK, &
     -4.652336179076577_REALK,      0.000000000000000_REALK,    -26.980055338497650_REALK, &
    129.624349822584179_REALK,    -98.296536696407756_REALK,      0.000000000000000_REALK, &
     17.498681038186700_REALK,      0.000000000000000_REALK,     17.216850713102041_REALK, &
    -30.514721137212824_REALK,      0.000000000000000_REALK,    -15.321467204741452_REALK, &
      0.000000000000000_REALK,      9.696749185308974_REALK,      0.000000000000000_REALK, &
      3.316672796169143_REALK,      0.000000000000000_REALK,      9.789765343668687_REALK, &
    -31.386797176366137_REALK,      0.000000000000000_REALK,     -8.131700845904234_REALK, &
      0.000000000000000_REALK,    -12.248801547527750_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -17.241942791768448_REALK, &
      0.000000000000000_REALK,      8.948918685128760_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.188623346483139_REALK,      0.000000000000000_REALK, &
     -8.062497517466332_REALK,      0.000000000000000_REALK,      3.231879390092568_REALK, &
      0.000000000000000_REALK,      5.088492400082964_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.073988838911178_REALK,      0.000000000000000_REALK, &
     -0.950249169434943_REALK,      0.000000000000000_REALK,    -10.742653945300004_REALK, &
     18.442010610577192_REALK,     -5.351551561980869_REALK,      0.000000000000000_REALK, &
      0.315640726301125_REALK,      0.000000000000000_REALK,      7.348465252855564_REALK, &
     -2.024602728498762_REALK,      0.000000000000000_REALK,     -2.502436744173792_REALK, &
      0.000000000000000_REALK,     -0.516505392077359_REALK,      0.000000000000000_REALK, &
      0.179478157468232_REALK,      0.000000000000000_REALK,      6.964083391357664_REALK, &
     -2.737637165103519_REALK,      0.000000000000000_REALK,     -1.618575864998761_REALK, &
      0.000000000000000_REALK,     -3.334303285604026_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -7.594624236386845_REALK, &
      0.000000000000000_REALK,      0.963865788604345_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.232798958405978_REALK,      0.000000000000000_REALK, &
     -5.918865001801637_REALK,      0.000000000000000_REALK,      0.480890455232049_REALK, &
      0.000000000000000_REALK,      0.913448114530985_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.138905158449107_REALK,      0.000000000000000_REALK, &
     -0.310186594608419_REALK,      0.000000000000000_REALK,    -11.041001334360432_REALK, &
      8.802129100430342_REALK,      0.201669265757284_REALK,      0.000000000000000_REALK, &
      0.336314555637208_REALK,      0.000000000000000_REALK,      5.845543020542773_REALK, &
     -0.314697239742286_REALK,      0.000000000000000_REALK,      0.157170798959463_REALK, &
      0.000000000000000_REALK,     -0.370947590159507_REALK,      0.000000000000000_REALK, &
      0.318722689785432_REALK,      0.000000000000000_REALK,      7.755685946233905_REALK, &
     -1.172941800839062_REALK,      0.000000000000000_REALK,     -0.419309715974323_REALK, &
      0.000000000000000_REALK,      0.293185095538707_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -7.000447551560812_REALK, &
      0.000000000000000_REALK,     -1.455577134621760_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.132510824717904_REALK,      0.000000000000000_REALK, &
     -7.638111354595657_REALK,      0.000000000000000_REALK,     -0.875303131661613_REALK, &
      0.000000000000000_REALK,     -1.931214788253699_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.523478139867483_REALK,      0.000000000000000_REALK, &
     -2.112576232619247_REALK,      0.000000000000000_REALK,    -18.318946011529707_REALK, &
      9.567597348716056_REALK,      3.072792178276002_REALK,      0.000000000000000_REALK, &
      1.972153775022317_REALK,      0.000000000000000_REALK,      8.895452653992868_REALK, &
      1.493141198958651_REALK,      0.000000000000000_REALK,      3.352689760809612_REALK, &
      0.000000000000000_REALK,      1.729053527096849_REALK,      0.000000000000000_REALK, &
      2.616592720813216_REALK,      0.000000000000000_REALK,     15.174272384559918_REALK, &
      3.115727801768305_REALK,      0.000000000000000_REALK,      2.785293120399421_REALK, &
      0.000000000000000_REALK,      8.040959324941793_REALK,      0.000000000000000_REALK, &
    ! results of test 7, ket-major order, 03ODGXXY
      0.000000000000000_REALK,      0.000000000000000_REALK,    -17.117411142645796_REALK, &
      0.000000000000000_REALK,     -7.645376526122806_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -7.224693467191885_REALK,      0.000000000000000_REALK, &
    -20.706090110285558_REALK,      0.000000000000000_REALK,      1.429722112692980_REALK, &
      0.000000000000000_REALK,    -10.733577710411051_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     68.664152764017189_REALK,      0.000000000000000_REALK, &
    -23.358971796494956_REALK,      0.000000000000000_REALK,   -111.578661225848748_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -16.011528547131807_REALK, &
      0.000000000000000_REALK,     -7.229584580658277_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.716361114392832_REALK,      0.000000000000000_REALK, &
    -16.849449120085243_REALK,      0.000000000000000_REALK,     -9.431436993570907_REALK, &
      0.000000000000000_REALK,     -9.075980870812808_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -35.616755685617939_REALK,      0.000000000000000_REALK, &
    -23.099642716700139_REALK,      0.000000000000000_REALK,    -74.422542759748666_REALK, &
    -10.317827364118862_REALK,     -5.350434023067735_REALK,      0.000000000000000_REALK, &
     -2.889526843405331_REALK,      0.000000000000000_REALK,      3.010199897545518_REALK, &
      0.749978916986919_REALK,      0.000000000000000_REALK,      2.046594744425455_REALK, &
      0.000000000000000_REALK,     10.663095668006266_REALK,      0.000000000000000_REALK, &
      1.318550874679465_REALK,      0.000000000000000_REALK,     11.023464776437345_REALK, &
     93.196440758954225_REALK,      0.000000000000000_REALK,     -0.722452057071038_REALK, &
      0.000000000000000_REALK,     15.821383436018911_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -16.443009136006438_REALK, &
      0.000000000000000_REALK,     -5.279494193829066_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.161174368759381_REALK,      0.000000000000000_REALK, &
    -14.885755429891644_REALK,      0.000000000000000_REALK,     -3.577231431201735_REALK, &
      0.000000000000000_REALK,     -5.839646215562547_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.434107553850601_REALK,      0.000000000000000_REALK, &
    -10.972442823205574_REALK,      0.000000000000000_REALK,    -52.744165269621654_REALK, &
    -11.640384749822726_REALK,     -5.142447360887466_REALK,      0.000000000000000_REALK, &
     -4.286179229112964_REALK,      0.000000000000000_REALK,      3.011693338024803_REALK, &
     -4.837753458099199_REALK,      0.000000000000000_REALK,      1.692190938253409_REALK, &
      0.000000000000000_REALK,     -7.309937138535731_REALK,      0.000000000000000_REALK, &
      1.723274559717443_REALK,      0.000000000000000_REALK,      9.717342760064543_REALK, &
    -26.845031322266081_REALK,      0.000000000000000_REALK,      3.738423134764500_REALK, &
      0.000000000000000_REALK,     10.494136597168714_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.959526875018433_REALK, &
      0.000000000000000_REALK,      0.921014236033737_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.618959354826316_REALK,      0.000000000000000_REALK, &
     -2.110108307734969_REALK,      0.000000000000000_REALK,     -0.135696202127897_REALK, &
      0.000000000000000_REALK,     -1.211782022927798_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.868060597761980_REALK,      0.000000000000000_REALK, &
     -1.565239747017195_REALK,      0.000000000000000_REALK,    -21.238908126388857_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -19.553887984561641_REALK, &
      0.000000000000000_REALK,     -4.193990373302439_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.422685221250048_REALK,      0.000000000000000_REALK, &
    -15.271319779057613_REALK,      0.000000000000000_REALK,     -2.826752819099888_REALK, &
      0.000000000000000_REALK,     -4.034800385194920_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.849275744060234_REALK,      0.000000000000000_REALK, &
     -7.452891227094311_REALK,      0.000000000000000_REALK,    -42.890792777741865_REALK, &
    -13.620258972482745_REALK,     -4.018801909237952_REALK,      0.000000000000000_REALK, &
     -3.010110195598598_REALK,      0.000000000000000_REALK,      3.155692453102275_REALK, &
     -1.922651403376233_REALK,      0.000000000000000_REALK,      1.140853757656586_REALK, &
      0.000000000000000_REALK,     -1.434174256219485_REALK,      0.000000000000000_REALK, &
      1.052608682613586_REALK,      0.000000000000000_REALK,      8.855882563402279_REALK, &
      1.416966827772680_REALK,      0.000000000000000_REALK,      1.177685237054265_REALK, &
      0.000000000000000_REALK,      5.608042331146142_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.098043108165189_REALK, &
      0.000000000000000_REALK,      0.903197243993825_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.847632038562587_REALK,      0.000000000000000_REALK, &
     -1.949044691312523_REALK,      0.000000000000000_REALK,      0.902945470994998_REALK, &
      0.000000000000000_REALK,     -1.033573033821702_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.202394992620690_REALK,      0.000000000000000_REALK, &
     -1.699065252747610_REALK,      0.000000000000000_REALK,    -15.550100298900436_REALK, &
     -5.330785722481087_REALK,     -2.302536698950054_REALK,      0.000000000000000_REALK, &
     -1.185582905087862_REALK,      0.000000000000000_REALK,     -1.030171237376936_REALK, &
      0.239528468974044_REALK,      0.000000000000000_REALK,     -0.545191186490761_REALK, &
      0.000000000000000_REALK,      3.352763318453782_REALK,      0.000000000000000_REALK, &
     -0.345800303530178_REALK,      0.000000000000000_REALK,      2.144647235620091_REALK, &
     18.926753017367567_REALK,      0.000000000000000_REALK,      0.122375564597518_REALK, &
      0.000000000000000_REALK,      1.988105385595310_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -26.839338761531870_REALK, &
      0.000000000000000_REALK,     -2.980180296434426_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.135879143637797_REALK,      0.000000000000000_REALK, &
    -17.819069519514109_REALK,      0.000000000000000_REALK,     -1.145151981020901_REALK, &
      0.000000000000000_REALK,     -2.447345768012996_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.870536222262679_REALK,      0.000000000000000_REALK, &
     -5.476453040729888_REALK,      0.000000000000000_REALK,    -39.324689328037756_REALK, &
    -19.095831519876448_REALK,     -3.592727124444840_REALK,      0.000000000000000_REALK, &
     -3.037376348457899_REALK,      0.000000000000000_REALK,      3.812229844523460_REALK, &
     -1.671103017526897_REALK,      0.000000000000000_REALK,      0.867016518978920_REALK, &
      0.000000000000000_REALK,     -2.292299014859147_REALK,      0.000000000000000_REALK, &
      0.906653471588371_REALK,      0.000000000000000_REALK,      9.132179161928656_REALK, &
     -4.102347973478669_REALK,      0.000000000000000_REALK,      0.804312245601483_REALK, &
      0.000000000000000_REALK,      3.348894403972827_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.473949615350071_REALK, &
      0.000000000000000_REALK,      0.717037599741218_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.569484244456282_REALK,      0.000000000000000_REALK, &
     -1.953745553554505_REALK,      0.000000000000000_REALK,      0.360707542549252_REALK, &
      0.000000000000000_REALK,     -0.700420203163319_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.373454885473631_REALK,      0.000000000000000_REALK, &
     -0.896968483446266_REALK,      0.000000000000000_REALK,    -12.248197352766697_REALK, &
     -6.729081574528994_REALK,     -2.541062468951457_REALK,      0.000000000000000_REALK, &
     -1.911859066453383_REALK,      0.000000000000000_REALK,     -1.120482773702739_REALK, &
     -1.753124858841712_REALK,      0.000000000000000_REALK,     -0.511478483955646_REALK, &
      0.000000000000000_REALK,     -2.420793599803338_REALK,      0.000000000000000_REALK, &
     -0.476000583540875_REALK,      0.000000000000000_REALK,      1.991176690871039_REALK, &
     -6.059122945299223_REALK,      0.000000000000000_REALK,     -0.703790165163595_REALK, &
      0.000000000000000_REALK,      1.465584017641693_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.996554534132012_REALK, &
      0.000000000000000_REALK,      1.271385825687974_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.694155424375896_REALK,      0.000000000000000_REALK, &
      0.969901287751895_REALK,      0.000000000000000_REALK,     -0.139071227402025_REALK, &
      0.000000000000000_REALK,      0.509005292709266_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.701870898829715_REALK,      0.000000000000000_REALK, &
      0.448105619378494_REALK,      0.000000000000000_REALK,     -4.251242299572375_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -41.667140366324013_REALK, &
      0.000000000000000_REALK,     -1.167740450490174_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.094304038472302_REALK,      0.000000000000000_REALK, &
    -23.697976537249435_REALK,      0.000000000000000_REALK,     -0.243194963785496_REALK, &
      0.000000000000000_REALK,     -0.810380707640005_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.638623367160541_REALK,      0.000000000000000_REALK, &
     -5.277690162693117_REALK,      0.000000000000000_REALK,    -40.918437762985796_REALK, &
    -29.548613812246206_REALK,     -2.896879166327219_REALK,      0.000000000000000_REALK, &
     -3.333440162062918_REALK,      0.000000000000000_REALK,      5.220351848638464_REALK, &
     -0.770931420884247_REALK,      0.000000000000000_REALK,      0.598877337350345_REALK, &
      0.000000000000000_REALK,     -1.212548436606476_REALK,      0.000000000000000_REALK, &
      0.840863229739862_REALK,      0.000000000000000_REALK,     10.567812457382043_REALK, &
      0.415885827364675_REALK,      0.000000000000000_REALK,      0.290311811069610_REALK, &
      0.000000000000000_REALK,      1.809836995938325_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.391300657587575_REALK, &
      0.000000000000000_REALK,      0.639516231584724_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.558590213276948_REALK,      0.000000000000000_REALK, &
     -2.294287323125710_REALK,      0.000000000000000_REALK,      0.310928206066120_REALK, &
      0.000000000000000_REALK,     -0.527908047742139_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.531829250602024_REALK,      0.000000000000000_REALK, &
     -0.688361058650712_REALK,      0.000000000000000_REALK,    -11.253289181990979_REALK, &
     -8.945241811421774_REALK,     -2.289104955477244_REALK,      0.000000000000000_REALK, &
     -1.507448457730269_REALK,      0.000000000000000_REALK,     -1.318146365481416_REALK, &
     -0.797524027299618_REALK,      0.000000000000000_REALK,     -0.394713601643857_REALK, &
      0.000000000000000_REALK,     -0.518095886605023_REALK,      0.000000000000000_REALK, &
     -0.317164125295865_REALK,      0.000000000000000_REALK,      1.979512406899726_REALK, &
      0.361345946118322_REALK,      0.000000000000000_REALK,     -0.250496477295189_REALK, &
      0.000000000000000_REALK,      0.884897451528357_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.698358333580705_REALK, &
      0.000000000000000_REALK,      1.399806982125929_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.088118176735464_REALK,      0.000000000000000_REALK, &
      1.025459934935315_REALK,      0.000000000000000_REALK,      1.009474192032404_REALK, &
      0.000000000000000_REALK,      0.473590589701406_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.738137739011878_REALK,      0.000000000000000_REALK, &
      0.549575336593818_REALK,      0.000000000000000_REALK,     -3.516693513488516_REALK, &
     -5.835078396674549_REALK,     -2.185870435505918_REALK,      0.000000000000000_REALK, &
     -0.989556863178039_REALK,      0.000000000000000_REALK,     -2.750565337835742_REALK, &
      0.165595722737914_REALK,      0.000000000000000_REALK,     -1.205714605739312_REALK, &
      0.000000000000000_REALK,      2.018644615555086_REALK,      0.000000000000000_REALK, &
     -0.666018143820557_REALK,      0.000000000000000_REALK,     -1.253834470961205_REALK, &
      8.044302028296631_REALK,      0.000000000000000_REALK,      0.166383662806336_REALK, &
      0.000000000000000_REALK,     -0.820500825057759_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -78.000430982304493_REALK, &
      0.000000000000000_REALK,      3.193926481655397_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -7.782991213076687_REALK,      0.000000000000000_REALK, &
    -36.473748274838812_REALK,      0.000000000000000_REALK,      1.700682266380709_REALK, &
      0.000000000000000_REALK,      1.816115577777581_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.837301815004847_REALK,      0.000000000000000_REALK, &
     -6.222140056249092_REALK,      0.000000000000000_REALK,    -48.598446691703145_REALK, &
    -58.306338388635474_REALK,     -1.386562749726381_REALK,      0.000000000000000_REALK, &
     -4.994335831256579_REALK,      0.000000000000000_REALK,      8.444891519558976_REALK, &
     -0.194575612581216_REALK,      0.000000000000000_REALK,      0.235674639641982_REALK, &
      0.000000000000000_REALK,     -1.957895571521895_REALK,      0.000000000000000_REALK, &
      1.032253203435826_REALK,      0.000000000000000_REALK,     14.007324722395463_REALK, &
     -0.540122782059035_REALK,      0.000000000000000_REALK,      0.056542053577322_REALK, &
      0.000000000000000_REALK,      0.549602433956803_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.672733158371829_REALK, &
      0.000000000000000_REALK,      0.537316448632437_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.615684991009268_REALK,      0.000000000000000_REALK, &
     -3.155292979431011_REALK,      0.000000000000000_REALK,      0.142960645571771_REALK, &
      0.000000000000000_REALK,     -0.363423198142504_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.257997485014569_REALK,      0.000000000000000_REALK, &
     -0.585484970216404_REALK,      0.000000000000000_REALK,    -11.942784007241588_REALK, &
    -15.585627838438748_REALK,     -2.493909620198097_REALK,      0.000000000000000_REALK, &
     -1.798548435292703_REALK,      0.000000000000000_REALK,     -1.882831677043174_REALK, &
     -0.817014727109509_REALK,      0.000000000000000_REALK,     -0.353559834428637_REALK, &
      0.000000000000000_REALK,     -0.939854389745408_REALK,      0.000000000000000_REALK, &
     -0.310055559913621_REALK,      0.000000000000000_REALK,      2.316764486364706_REALK, &
     -1.210935109703650_REALK,      0.000000000000000_REALK,     -0.198025876675032_REALK, &
      0.000000000000000_REALK,      0.611657051492796_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.314627162595623_REALK, &
      0.000000000000000_REALK,      1.313986597201797_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.861655866999915_REALK,      0.000000000000000_REALK, &
      1.211569513906267_REALK,      0.000000000000000_REALK,      0.457688504671202_REALK, &
      0.000000000000000_REALK,      0.364251747228088_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.341155200007836_REALK,      0.000000000000000_REALK, &
      0.335829800752860_REALK,      0.000000000000000_REALK,     -3.206257313951479_REALK, &
     -9.153565007624843_REALK,     -2.939818842036145_REALK,      0.000000000000000_REALK, &
     -1.886809940546053_REALK,      0.000000000000000_REALK,     -3.537375665147132_REALK, &
     -1.428526361643455_REALK,      0.000000000000000_REALK,     -1.333234365240812_REALK, &
      0.000000000000000_REALK,     -1.654229717774230_REALK,      0.000000000000000_REALK, &
     -1.040517191899296_REALK,      0.000000000000000_REALK,     -1.321220254503694_REALK, &
     -2.980896450808262_REALK,      0.000000000000000_REALK,     -1.107602781740412_REALK, &
      0.000000000000000_REALK,     -0.700124398489342_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.813361620234916_REALK, &
      0.000000000000000_REALK,      2.104018586725192_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.948488476597228_REALK,      0.000000000000000_REALK, &
      3.666767493378891_REALK,      0.000000000000000_REALK,     -0.159358513388580_REALK, &
      0.000000000000000_REALK,      1.613766812075367_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.228956766070846_REALK,      0.000000000000000_REALK, &
      1.022817007030197_REALK,      0.000000000000000_REALK,      2.375912128928656_REALK, &
    ! results of test 7, ket-major order, 01ODGXYY
    -49.992119802308927_REALK,    -14.483082142544113_REALK,      0.000000000000000_REALK, &
    -15.236615478920513_REALK,      0.000000000000000_REALK,     -8.763555640431658_REALK, &
     -5.650453211442888_REALK,      0.000000000000000_REALK,     -1.253019071852316_REALK, &
      0.000000000000000_REALK,    -21.778107911161829_REALK,      0.000000000000000_REALK, &
     -2.859093386704864_REALK,      0.000000000000000_REALK,     -4.933344418301242_REALK, &
    207.543875941262939_REALK,      0.000000000000000_REALK,     16.617744623475890_REALK, &
      0.000000000000000_REALK,     11.055228756988194_REALK,      0.000000000000000_REALK, &
    -41.593531724808415_REALK,     -7.446236920259318_REALK,      0.000000000000000_REALK, &
     -4.697997492194758_REALK,      0.000000000000000_REALK,     -5.492911517990814_REALK, &
     -0.292525883676501_REALK,      0.000000000000000_REALK,     -0.269102981855533_REALK, &
      0.000000000000000_REALK,      0.084579564347655_REALK,      0.000000000000000_REALK, &
     -0.147767387339144_REALK,      0.000000000000000_REALK,     -0.518310100365382_REALK, &
    -35.043910121863050_REALK,      0.000000000000000_REALK,      2.099450236660760_REALK, &
      0.000000000000000_REALK,      5.794034139907119_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.716598286030131_REALK, &
      0.000000000000000_REALK,      1.751154942207285_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.296359400688208_REALK,      0.000000000000000_REALK, &
      0.511365946280367_REALK,      0.000000000000000_REALK,      0.248379638123011_REALK, &
      0.000000000000000_REALK,      0.165238651829365_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -16.201372125857798_REALK,      0.000000000000000_REALK, &
     -6.380889849045667_REALK,      0.000000000000000_REALK,    -18.350296791613680_REALK, &
    -39.850119378163207_REALK,     -4.285210647974727_REALK,      0.000000000000000_REALK, &
     -2.479192795538647_REALK,      0.000000000000000_REALK,     -3.046315593051579_REALK, &
      0.547390860966659_REALK,      0.000000000000000_REALK,      0.243937269194963_REALK, &
      0.000000000000000_REALK,      2.489206434632433_REALK,      0.000000000000000_REALK, &
      0.759252132677532_REALK,      0.000000000000000_REALK,      2.798800014660469_REALK, &
     25.123615544239037_REALK,      0.000000000000000_REALK,      2.923538312657702_REALK, &
      0.000000000000000_REALK,      3.908504890548442_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.493140437376096_REALK, &
      0.000000000000000_REALK,      0.544842957949320_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.170071759940552_REALK,      0.000000000000000_REALK, &
     -0.596545100725033_REALK,      0.000000000000000_REALK,     -0.181381442403275_REALK, &
      0.000000000000000_REALK,     -0.500574031848312_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.519912551814745_REALK,      0.000000000000000_REALK, &
     -2.724988713965457_REALK,      0.000000000000000_REALK,    -15.930321289234229_REALK, &
     -4.514587906709903_REALK,     -1.113622551665049_REALK,      0.000000000000000_REALK, &
     -0.600028031550150_REALK,      0.000000000000000_REALK,     -1.035343914975723_REALK, &
      0.285870671124655_REALK,      0.000000000000000_REALK,      0.190180180030698_REALK, &
      0.000000000000000_REALK,      1.399713217196456_REALK,      0.000000000000000_REALK, &
      0.551275274081826_REALK,      0.000000000000000_REALK,      1.585368989686080_REALK, &
     19.068594831921274_REALK,      0.000000000000000_REALK,      4.580386260133438_REALK, &
      0.000000000000000_REALK,      5.078629205153548_REALK,      0.000000000000000_REALK, &
    -31.051813920397873_REALK,     -1.072209885352659_REALK,      0.000000000000000_REALK, &
      0.299910249102491_REALK,      0.000000000000000_REALK,      0.464711430933866_REALK, &
      0.418790170875347_REALK,      0.000000000000000_REALK,      0.458943194216627_REALK, &
      0.000000000000000_REALK,      1.546465005257538_REALK,      0.000000000000000_REALK, &
      1.403893446148457_REALK,      0.000000000000000_REALK,      6.526005705280570_REALK, &
     -8.203596355286793_REALK,      0.000000000000000_REALK,      0.625765959464979_REALK, &
      0.000000000000000_REALK,      2.057290606906621_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.695662577022427_REALK, &
      0.000000000000000_REALK,     -0.054740697045326_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.590682317605576_REALK,      0.000000000000000_REALK, &
     -2.177408015100446_REALK,      0.000000000000000_REALK,     -0.575006225694716_REALK, &
      0.000000000000000_REALK,     -0.768731039197684_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.893638800498204_REALK,      0.000000000000000_REALK, &
     -2.647833542340735_REALK,      0.000000000000000_REALK,    -16.267667085740051_REALK, &
     -2.981657903104863_REALK,     -0.303274492063838_REALK,      0.000000000000000_REALK, &
      0.038164921324221_REALK,      0.000000000000000_REALK,      0.133867591206669_REALK, &
      0.141110977708524_REALK,      0.000000000000000_REALK,      0.389436152418302_REALK, &
      0.000000000000000_REALK,     -0.102257238366251_REALK,      0.000000000000000_REALK, &
      0.535955170723781_REALK,      0.000000000000000_REALK,      3.133201257861963_REALK, &
     -3.519518304693237_REALK,      0.000000000000000_REALK,      0.632553859888218_REALK, &
      0.000000000000000_REALK,      2.909522530806064_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.576300740138875_REALK, &
      0.000000000000000_REALK,     -0.042677347555143_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.428880661006457_REALK,      0.000000000000000_REALK, &
     -1.233383995623903_REALK,      0.000000000000000_REALK,     -0.900877749492873_REALK, &
      0.000000000000000_REALK,     -0.998872974681009_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.881392421092525_REALK,      0.000000000000000_REALK, &
     -3.204217016002547_REALK,      0.000000000000000_REALK,    -12.900656251267399_REALK, &
    -11.382783417242445_REALK,      0.120288627585094_REALK,      0.000000000000000_REALK, &
      4.624448905172762_REALK,      0.000000000000000_REALK,      7.330359925372043_REALK, &
     -0.109523748854547_REALK,      0.000000000000000_REALK,      0.102054229153615_REALK, &
      0.000000000000000_REALK,      5.738558056116728_REALK,      0.000000000000000_REALK, &
      2.587525033980079_REALK,      0.000000000000000_REALK,     12.304702811464567_REALK, &
      4.185677438351398_REALK,      0.000000000000000_REALK,     -0.082067260382647_REALK, &
      0.000000000000000_REALK,      0.229410819608348_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.957791062840309_REALK, &
      0.000000000000000_REALK,     -0.398053908982669_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.071965308350759_REALK,      0.000000000000000_REALK, &
     -4.983036096758111_REALK,      0.000000000000000_REALK,     -0.203237579596691_REALK, &
      0.000000000000000_REALK,     -0.668171154327721_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.884806523612573_REALK,      0.000000000000000_REALK, &
     -2.409703566623341_REALK,      0.000000000000000_REALK,    -18.669198467260223_REALK, &
     -0.977517846187466_REALK,      0.230618057390200_REALK,      0.000000000000000_REALK, &
      0.512314832102860_REALK,      0.000000000000000_REALK,      1.888525165604309_REALK, &
      0.439055205878681_REALK,      0.000000000000000_REALK,      0.586976887550199_REALK, &
      0.000000000000000_REALK,      0.939802073195450_REALK,      0.000000000000000_REALK, &
      0.859968926370435_REALK,      0.000000000000000_REALK,      5.283447004719332_REALK, &
      2.827184267243976_REALK,      0.000000000000000_REALK,      0.986965611021636_REALK, &
      0.000000000000000_REALK,      2.199138797428885_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.563973158873459_REALK, &
      0.000000000000000_REALK,     -0.337768562041484_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.409237147892738_REALK,      0.000000000000000_REALK, &
     -2.392405963375240_REALK,      0.000000000000000_REALK,     -0.205442168120078_REALK, &
      0.000000000000000_REALK,     -0.944960824408916_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.175518756555368_REALK,      0.000000000000000_REALK, &
     -1.533227812488777_REALK,      0.000000000000000_REALK,    -12.548579064677865_REALK, &
     -0.332226626859941_REALK,      0.179796157502052_REALK,      0.000000000000000_REALK, &
      0.371979856661978_REALK,      0.000000000000000_REALK,      1.069747469668372_REALK, &
      0.687879623037535_REALK,      0.000000000000000_REALK,      0.762705445519929_REALK, &
      0.000000000000000_REALK,      1.585388859395120_REALK,      0.000000000000000_REALK, &
      1.040672316838184_REALK,      0.000000000000000_REALK,      4.189902170386819_REALK, &
      6.437421144141754_REALK,      0.000000000000000_REALK,      2.577176033789280_REALK, &
      0.000000000000000_REALK,      4.000520702876224_REALK,      0.000000000000000_REALK, &
    106.784316366819297_REALK,     -8.140885150529190_REALK,      0.000000000000000_REALK, &
     16.816191757340555_REALK,      0.000000000000000_REALK,     26.318712888769259_REALK, &
     -5.559857151346693_REALK,      0.000000000000000_REALK,     -2.143050453185585_REALK, &
      0.000000000000000_REALK,      9.049257864026172_REALK,      0.000000000000000_REALK, &
      5.044683209464642_REALK,      0.000000000000000_REALK,     23.686023135423415_REALK, &
    -13.620934121804972_REALK,      0.000000000000000_REALK,     -2.420020575759217_REALK, &
      0.000000000000000_REALK,     -2.798395381620391_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -14.381027245573533_REALK, &
      0.000000000000000_REALK,     -0.124822187456332_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.388280665995819_REALK,      0.000000000000000_REALK, &
    -11.357217201583010_REALK,      0.000000000000000_REALK,      0.040186051011639_REALK, &
      0.000000000000000_REALK,     -0.112336086965957_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.305467515944957_REALK,      0.000000000000000_REALK, &
     -3.118617004933949_REALK,      0.000000000000000_REALK,    -24.717091251652150_REALK, &
      8.242830818337060_REALK,      0.780919923245961_REALK,      0.000000000000000_REALK, &
      1.311117194998708_REALK,      0.000000000000000_REALK,      6.094734837837701_REALK, &
      0.187587897925744_REALK,      0.000000000000000_REALK,      0.616720699703688_REALK, &
      0.000000000000000_REALK,      0.433265103861613_REALK,      0.000000000000000_REALK, &
      1.179964702120472_REALK,      0.000000000000000_REALK,      9.141786364667825_REALK, &
     -1.070415996607883_REALK,      0.000000000000000_REALK,      0.244952285851676_REALK, &
      0.000000000000000_REALK,      1.342189864013002_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.704992952188281_REALK, &
      0.000000000000000_REALK,     -0.717929474338986_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.793749677099164_REALK,      0.000000000000000_REALK, &
     -4.876611497657821_REALK,      0.000000000000000_REALK,     -0.483289562808839_REALK, &
      0.000000000000000_REALK,     -1.076857000990344_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.132697341378484_REALK,      0.000000000000000_REALK, &
     -1.727463942231807_REALK,      0.000000000000000_REALK,    -14.858385548664964_REALK, &
      2.374479801707131_REALK,      0.662649439163826_REALK,      0.000000000000000_REALK, &
      0.500536591300612_REALK,      0.000000000000000_REALK,      2.926143758163819_REALK, &
      0.189622728923604_REALK,      0.000000000000000_REALK,      0.872197036713446_REALK, &
      0.000000000000000_REALK,     -0.085946645124331_REALK,      0.000000000000000_REALK, &
      0.750778943976610_REALK,      0.000000000000000_REALK,      6.144689563968372_REALK, &
     -1.377694073625419_REALK,      0.000000000000000_REALK,      0.412682280439150_REALK, &
      0.000000000000000_REALK,      2.657468172749816_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.098678327367862_REALK, &
      0.000000000000000_REALK,     -0.932862487759836_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.960538561483477_REALK,      0.000000000000000_REALK, &
     -3.867271703476704_REALK,      0.000000000000000_REALK,     -1.261971303500801_REALK, &
      0.000000000000000_REALK,     -1.958943533503089_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.184652381080771_REALK,      0.000000000000000_REALK, &
     -2.926633029458308_REALK,      0.000000000000000_REALK,    -15.149650711760330_REALK, &
    680.908657116673112_REALK,    -75.011708449934218_REALK,      0.000000000000000_REALK, &
     64.823446706344015_REALK,      0.000000000000000_REALK,     90.439047253713213_REALK, &
    -25.381548291171111_REALK,      0.000000000000000_REALK,    -11.692064335256434_REALK, &
      0.000000000000000_REALK,     28.826488394631806_REALK,      0.000000000000000_REALK, &
     12.286535298041567_REALK,      0.000000000000000_REALK,     51.425029192188092_REALK, &
    -20.783299698442697_REALK,      0.000000000000000_REALK,     -6.763789738782031_REALK, &
      0.000000000000000_REALK,     -9.347262491882200_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -62.110480803947588_REALK, &
      0.000000000000000_REALK,      3.599189130632901_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.185716833933856_REALK,      0.000000000000000_REALK, &
    -29.043455446885048_REALK,      0.000000000000000_REALK,      1.769836795874203_REALK, &
      0.000000000000000_REALK,      2.046554134872355_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.956930301245180_REALK,      0.000000000000000_REALK, &
     -4.945193362722472_REALK,      0.000000000000000_REALK,    -38.698156565717966_REALK, &
     47.869162260588332_REALK,      0.294572386981035_REALK,      0.000000000000000_REALK, &
      4.011045937427806_REALK,      0.000000000000000_REALK,     19.074106559373067_REALK, &
     -0.049275548515246_REALK,      0.000000000000000_REALK,      0.137744868280306_REALK, &
      0.000000000000000_REALK,      1.686060557618191_REALK,      0.000000000000000_REALK, &
      2.280742231226496_REALK,      0.000000000000000_REALK,     18.076382499529142_REALK, &
      0.669729264761335_REALK,      0.000000000000000_REALK,     -0.039393512830288_REALK, &
      0.000000000000000_REALK,      0.183534376224066_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -14.383184798987756_REALK, &
      0.000000000000000_REALK,     -1.035763967064013_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.446855475019796_REALK,      0.000000000000000_REALK, &
    -11.209524852236232_REALK,      0.000000000000000_REALK,     -0.179141273870279_REALK, &
      0.000000000000000_REALK,     -0.981585459303117_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.424720369337738_REALK,      0.000000000000000_REALK, &
     -1.927822941133107_REALK,      0.000000000000000_REALK,    -20.910154026728797_REALK, &
     12.332561907719541_REALK,      1.694267687898508_REALK,      0.000000000000000_REALK, &
      1.333078839096882_REALK,      0.000000000000000_REALK,      8.190123135271563_REALK, &
      0.592602599648358_REALK,      0.000000000000000_REALK,      1.320426318597793_REALK, &
      0.000000000000000_REALK,      0.828377020196040_REALK,      0.000000000000000_REALK, &
      1.263348452129836_REALK,      0.000000000000000_REALK,     10.866402432575521_REALK, &
      1.357090747101541_REALK,      0.000000000000000_REALK,      0.789597099573192_REALK, &
      0.000000000000000_REALK,      2.463112225253530_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.905512305602867_REALK, &
      0.000000000000000_REALK,     -1.464828832957677_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.920594170037497_REALK,      0.000000000000000_REALK, &
     -7.534528551530298_REALK,      0.000000000000000_REALK,     -0.301807469011848_REALK, &
      0.000000000000000_REALK,     -1.943489655876863_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.140419381941134_REALK,      0.000000000000000_REALK, &
     -1.717268675108243_REALK,      0.000000000000000_REALK,    -18.070517088595043_REALK, &
      6.985729994807875_REALK,      2.201495866595153_REALK,      0.000000000000000_REALK, &
      1.613195781231432_REALK,      0.000000000000000_REALK,      6.494967143525376_REALK, &
      1.547410771277107_REALK,      0.000000000000000_REALK,      2.402027934912067_REALK, &
      0.000000000000000_REALK,      2.329035968769357_REALK,      0.000000000000000_REALK, &
      2.140338340689986_REALK,      0.000000000000000_REALK,     11.079413763208839_REALK, &
      5.150097437421288_REALK,      0.000000000000000_REALK,      2.886527127291089_REALK, &
      0.000000000000000_REALK,      5.760929373118537_REALK,      0.000000000000000_REALK, &
    ! results of test 7, ket-major order, 02ODGXYY
     60.726767193803063_REALK,     18.456513357445722_REALK,      0.000000000000000_REALK, &
     13.895885763667778_REALK,      0.000000000000000_REALK,     16.247107643362497_REALK, &
      7.037640998547990_REALK,      0.000000000000000_REALK,      6.474128559619663_REALK, &
      0.000000000000000_REALK,     -3.328373522442185_REALK,      0.000000000000000_REALK, &
      5.814939616837810_REALK,      0.000000000000000_REALK,     20.396529915660519_REALK, &
   -103.772642345187265_REALK,      0.000000000000000_REALK,      6.216928926392687_REALK, &
      0.000000000000000_REALK,     17.157395691449199_REALK,      0.000000000000000_REALK, &
     61.032459653543640_REALK,      7.283160321648070_REALK,      0.000000000000000_REALK, &
      7.970808328682244_REALK,      0.000000000000000_REALK,     14.480818227111929_REALK, &
     -0.219600565853788_REALK,      0.000000000000000_REALK,      2.197800139216189_REALK, &
      0.000000000000000_REALK,     -1.835622634117681_REALK,      0.000000000000000_REALK, &
      2.938835867141071_REALK,      0.000000000000000_REALK,     16.017226698922133_REALK, &
    -29.645595310671645_REALK,      0.000000000000000_REALK,     -0.155620567504903_REALK, &
      0.000000000000000_REALK,      4.672432016703905_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -12.079395173522995_REALK, &
      0.000000000000000_REALK,     -3.327584184876589_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.117623691929064_REALK,      0.000000000000000_REALK, &
    -10.935402444089862_REALK,      0.000000000000000_REALK,     -1.333668234050118_REALK, &
      0.000000000000000_REALK,     -3.680639409527780_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.264573516279262_REALK,      0.000000000000000_REALK, &
     -6.627938771265636_REALK,      0.000000000000000_REALK,    -38.747020701595588_REALK, &
     67.987718428696027_REALK,     -1.000797758609916_REALK,      0.000000000000000_REALK, &
      7.497167627395663_REALK,      0.000000000000000_REALK,     14.445367312230315_REALK, &
     -0.708502839925761_REALK,      0.000000000000000_REALK,     -0.260536465824817_REALK, &
      0.000000000000000_REALK,      6.640836774471467_REALK,      0.000000000000000_REALK, &
      2.404199989223130_REALK,      0.000000000000000_REALK,     13.897068998223464_REALK, &
     11.117316519689654_REALK,      0.000000000000000_REALK,     -0.397978025859566_REALK, &
      0.000000000000000_REALK,     -0.439043215455228_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -11.521526018895583_REALK, &
      0.000000000000000_REALK,     -1.339783666920328_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.650978670222602_REALK,      0.000000000000000_REALK, &
     -8.998154654266386_REALK,      0.000000000000000_REALK,      0.042929250576387_REALK, &
      0.000000000000000_REALK,     -1.288929914999158_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.579251321156484_REALK,      0.000000000000000_REALK, &
     -2.782147910572766_REALK,      0.000000000000000_REALK,    -25.272078133513446_REALK, &
     10.458318794740494_REALK,      2.647560874311687_REALK,      0.000000000000000_REALK, &
      1.900510072558305_REALK,      0.000000000000000_REALK,      6.666244725517810_REALK, &
      0.749227894006949_REALK,      0.000000000000000_REALK,      2.067708927148255_REALK, &
      0.000000000000000_REALK,     -0.348843306659352_REALK,      0.000000000000000_REALK, &
      1.828373002865761_REALK,      0.000000000000000_REALK,     10.688693579882019_REALK, &
     -7.024871892933212_REALK,      0.000000000000000_REALK,      1.262561932173973_REALK, &
      0.000000000000000_REALK,      5.807335345084076_REALK,      0.000000000000000_REALK, &
     87.251838333870992_REALK,    -13.054624836493787_REALK,      0.000000000000000_REALK, &
      7.105984866189361_REALK,      0.000000000000000_REALK,     15.973640461654890_REALK, &
     -7.417576817205428_REALK,      0.000000000000000_REALK,     -2.889058601374938_REALK, &
      0.000000000000000_REALK,      0.476731058765242_REALK,      0.000000000000000_REALK, &
      1.945162178122779_REALK,      0.000000000000000_REALK,     13.117669904188109_REALK, &
    -20.181431143328666_REALK,      0.000000000000000_REALK,     -3.273952139689644_REALK, &
      0.000000000000000_REALK,     -3.825497122343436_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -12.934153554134976_REALK, &
      0.000000000000000_REALK,      0.187022437934713_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.485588743115587_REALK,      0.000000000000000_REALK, &
     -8.587192978373032_REALK,      0.000000000000000_REALK,      0.139218942318776_REALK, &
      0.000000000000000_REALK,      0.153584188362902_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.811177809794000_REALK,      0.000000000000000_REALK, &
     -1.967116713752298_REALK,      0.000000000000000_REALK,    -18.950972479489771_REALK, &
     11.760562001157167_REALK,      1.199621117463576_REALK,      0.000000000000000_REALK, &
      1.185131819861474_REALK,      0.000000000000000_REALK,      6.459198772911996_REALK, &
     -0.026526583351028_REALK,      0.000000000000000_REALK,      0.796447791768943_REALK, &
      0.000000000000000_REALK,     -0.202631178176194_REALK,      0.000000000000000_REALK, &
      0.973238883347317_REALK,      0.000000000000000_REALK,      8.840568471955615_REALK, &
     -2.230410345681091_REALK,      0.000000000000000_REALK,     -0.035124717867152_REALK, &
      0.000000000000000_REALK,      1.757671013237590_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.968850154214411_REALK, &
      0.000000000000000_REALK,     -1.484275774104715_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.129777207989884_REALK,      0.000000000000000_REALK, &
     -6.604693008927081_REALK,      0.000000000000000_REALK,     -0.441663924608832_REALK, &
      0.000000000000000_REALK,     -2.031496796052609_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.285423634508861_REALK,      0.000000000000000_REALK, &
     -2.493291676394535_REALK,      0.000000000000000_REALK,    -20.406144134415147_REALK, &
    122.269123617354012_REALK,    -32.436920404921857_REALK,      0.000000000000000_REALK, &
     12.462767183511829_REALK,      0.000000000000000_REALK,     19.809261213930313_REALK, &
    -11.518715271291454_REALK,      0.000000000000000_REALK,     -6.149445117810640_REALK, &
      0.000000000000000_REALK,      8.296271078234634_REALK,      0.000000000000000_REALK, &
      2.882942605121859_REALK,      0.000000000000000_REALK,     13.747098607085231_REALK, &
     -6.817420683679392_REALK,      0.000000000000000_REALK,     -3.977789691850200_REALK, &
      0.000000000000000_REALK,     -6.370814493832825_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -16.229471066603832_REALK, &
      0.000000000000000_REALK,      2.433849921131866_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.368740298607752_REALK,      0.000000000000000_REALK, &
     -9.230430050323058_REALK,      0.000000000000000_REALK,      1.445509700711278_REALK, &
      0.000000000000000_REALK,      1.689026889963857_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.115844777343316_REALK,      0.000000000000000_REALK, &
     -1.418012579282580_REALK,      0.000000000000000_REALK,    -15.937849248270716_REALK, &
     14.883872198030678_REALK,     -0.190017751592280_REALK,      0.000000000000000_REALK, &
      1.251514954921822_REALK,      0.000000000000000_REALK,      7.234169269952081_REALK, &
     -0.097963336334843_REALK,      0.000000000000000_REALK,     -0.108071640609495_REALK, &
      0.000000000000000_REALK,      0.799668102056744_REALK,      0.000000000000000_REALK, &
      0.868517977916985_REALK,      0.000000000000000_REALK,      8.367200676186954_REALK, &
      0.945022653875088_REALK,      0.000000000000000_REALK,     -0.101489846812135_REALK, &
      0.000000000000000_REALK,     -0.186603387562331_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.562647998123137_REALK, &
      0.000000000000000_REALK,     -0.670957104940678_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.684833015360737_REALK,      0.000000000000000_REALK, &
     -6.220788408421862_REALK,      0.000000000000000_REALK,      0.015508204837878_REALK, &
      0.000000000000000_REALK,     -0.776043873547524_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.147717019609126_REALK,      0.000000000000000_REALK, &
     -1.182476363457853_REALK,      0.000000000000000_REALK,    -15.037694045196355_REALK, &
      6.868605857560851_REALK,      1.508047635635705_REALK,      0.000000000000000_REALK, &
      0.951766145295266_REALK,      0.000000000000000_REALK,      5.564037901905884_REALK, &
      0.310782935660806_REALK,      0.000000000000000_REALK,      1.429490847870181_REALK, &
      0.000000000000000_REALK,     -0.126019750714480_REALK,      0.000000000000000_REALK, &
      1.100833839700734_REALK,      0.000000000000000_REALK,      9.009685554904244_REALK, &
     -1.791438536710183_REALK,      0.000000000000000_REALK,      0.536617638668263_REALK, &
      0.000000000000000_REALK,      3.455550100623570_REALK,      0.000000000000000_REALK, &
    212.574588552027677_REALK,    -77.893695056063123_REALK,      0.000000000000000_REALK, &
     25.580866005869314_REALK,      0.000000000000000_REALK,     28.234393935310599_REALK, &
    -24.899454662891770_REALK,      0.000000000000000_REALK,    -12.141279177959248_REALK, &
      0.000000000000000_REALK,     12.330699383387115_REALK,      0.000000000000000_REALK, &
      4.848557568365545_REALK,      0.000000000000000_REALK,     16.054509378828865_REALK, &
    -27.335681578347138_REALK,      0.000000000000000_REALK,     -6.635319249169615_REALK, &
      0.000000000000000_REALK,     -9.706388898442526_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -24.585220210459159_REALK, &
      0.000000000000000_REALK,      6.301463579624047_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.410918032415687_REALK,      0.000000000000000_REALK, &
    -11.496284340290371_REALK,      0.000000000000000_REALK,      2.237210543690111_REALK, &
      0.000000000000000_REALK,      3.583108827170576_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.848848693346843_REALK,      0.000000000000000_REALK, &
     -1.927417011164380_REALK,      0.000000000000000_REALK,    -15.317909128897512_REALK, &
     23.737723057095284_REALK,     -3.020644516927116_REALK,      0.000000000000000_REALK, &
      1.402576488837945_REALK,      0.000000000000000_REALK,      9.458612553173973_REALK, &
     -1.208836206896778_REALK,      0.000000000000000_REALK,     -1.412482294657658_REALK, &
      0.000000000000000_REALK,      0.065154062276065_REALK,      0.000000000000000_REALK, &
      0.797526500698586_REALK,      0.000000000000000_REALK,      8.963853583066086_REALK, &
     -1.985724898157150_REALK,      0.000000000000000_REALK,     -0.966408412711457_REALK, &
      0.000000000000000_REALK,     -1.882023338611696_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.978307803646803_REALK, &
      0.000000000000000_REALK,      0.110743244999219_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.726315414922650_REALK,      0.000000000000000_REALK, &
     -6.997237806684390_REALK,      0.000000000000000_REALK,      0.057080482618475_REALK, &
      0.000000000000000_REALK,      0.104950512340576_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.534625247291231_REALK,      0.000000000000000_REALK, &
     -0.967759077227350_REALK,      0.000000000000000_REALK,    -13.052588956991517_REALK, &
      9.598730609354771_REALK,      0.832723037906059_REALK,      0.000000000000000_REALK, &
      0.701762552839274_REALK,      0.000000000000000_REALK,      6.374570524856402_REALK, &
     -0.012969044415803_REALK,      0.000000000000000_REALK,      0.648982107849615_REALK, &
      0.000000000000000_REALK,     -0.083079825569738_REALK,      0.000000000000000_REALK, &
      0.665054915651351_REALK,      0.000000000000000_REALK,      8.457583300501508_REALK, &
     -0.658374719573391_REALK,      0.000000000000000_REALK,     -0.017280247945301_REALK, &
      0.000000000000000_REALK,      1.210605803065719_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.905512305602866_REALK, &
      0.000000000000000_REALK,     -1.464828832957677_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.920594170037498_REALK,      0.000000000000000_REALK, &
     -7.534528551530296_REALK,      0.000000000000000_REALK,     -0.301807469011848_REALK, &
      0.000000000000000_REALK,     -1.943489655876863_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.140419381941134_REALK,      0.000000000000000_REALK, &
     -1.717268675108243_REALK,      0.000000000000000_REALK,    -18.070517088595043_REALK, &
    388.283460632568222_REALK,   -187.948456246569918_REALK,      0.000000000000000_REALK, &
     65.042958212931978_REALK,      0.000000000000000_REALK,     45.581750675659883_REALK, &
    -52.522504441197029_REALK,      0.000000000000000_REALK,    -24.779449949100986_REALK, &
      0.000000000000000_REALK,     35.056176349176461_REALK,      0.000000000000000_REALK, &
     10.091806156423059_REALK,      0.000000000000000_REALK,     21.216848282787979_REALK, &
    -35.732170822405429_REALK,      0.000000000000000_REALK,    -10.745104483238304_REALK, &
      0.000000000000000_REALK,    -15.208211122435728_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -41.638300152396589_REALK, &
      0.000000000000000_REALK,     15.206660369880069_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.973735240076073_REALK,      0.000000000000000_REALK, &
    -16.468996796201967_REALK,      0.000000000000000_REALK,      4.838690581301459_REALK, &
      0.000000000000000_REALK,      7.078214442691744_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.587754266179688_REALK,      0.000000000000000_REALK, &
     -3.052594619878550_REALK,      0.000000000000000_REALK,    -16.846216035588000_REALK, &
     40.884955876690071_REALK,     -9.293000321839390_REALK,      0.000000000000000_REALK, &
      3.019616892190363_REALK,      0.000000000000000_REALK,     14.398819837346897_REALK, &
     -2.294969743830902_REALK,      0.000000000000000_REALK,     -3.675615766429596_REALK, &
      0.000000000000000_REALK,      1.348240592925267_REALK,      0.000000000000000_REALK, &
      1.405535165369538_REALK,      0.000000000000000_REALK,     11.170317484950509_REALK, &
     -0.804674903511842_REALK,      0.000000000000000_REALK,     -1.408521353600461_REALK, &
      0.000000000000000_REALK,     -3.759805046495983_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -13.948964139858438_REALK, &
      0.000000000000000_REALK,      1.769100126807080_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.818116647165291_REALK,      0.000000000000000_REALK, &
     -9.195277940776775_REALK,      0.000000000000000_REALK,      0.704736442766129_REALK, &
      0.000000000000000_REALK,      1.372432623112985_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.041020228627335_REALK,      0.000000000000000_REALK, &
     -0.836855453371380_REALK,      0.000000000000000_REALK,    -13.168251646430377_REALK, &
     14.930828980058424_REALK,     -0.163317140282619_REALK,      0.000000000000000_REALK, &
      0.909692601104797_REALK,      0.000000000000000_REALK,      8.763872182981871_REALK, &
     -0.058554158410408_REALK,      0.000000000000000_REALK,     -0.107660072987094_REALK, &
      0.000000000000000_REALK,      0.389866116678227_REALK,      0.000000000000000_REALK, &
      0.705721391255589_REALK,      0.000000000000000_REALK,      9.518372345942241_REALK, &
      0.334629201324143_REALK,      0.000000000000000_REALK,     -0.059895330272410_REALK, &
      0.000000000000000_REALK,     -0.154176409076260_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -9.400813825319720_REALK, &
      0.000000000000000_REALK,     -0.812834492605480_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.682224975968680_REALK,      0.000000000000000_REALK, &
     -8.675937021361115_REALK,      0.000000000000000_REALK,      0.012601318766380_REALK, &
      0.000000000000000_REALK,     -0.882813121267083_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.087176796046624_REALK,      0.000000000000000_REALK, &
     -0.976991693007660_REALK,      0.000000000000000_REALK,    -15.974383875773206_REALK, &
     11.483792437230342_REALK,      2.160237005912753_REALK,      0.000000000000000_REALK, &
      1.153022072638386_REALK,      0.000000000000000_REALK,      9.436815927787919_REALK, &
      0.309599385626852_REALK,      0.000000000000000_REALK,      1.993665714773937_REALK, &
      0.000000000000000_REALK,     -0.102398379839187_REALK,      0.000000000000000_REALK, &
      1.252288164559704_REALK,      0.000000000000000_REALK,     13.177608725725502_REALK, &
     -1.057236819143061_REALK,      0.000000000000000_REALK,      0.443366980940897_REALK, &
      0.000000000000000_REALK,      3.670794447833632_REALK,      0.000000000000000_REALK, &
    ! results of test 7, ket-major order, 03ODGXYY
      0.000000000000000_REALK,      0.000000000000000_REALK,    -11.690731869002777_REALK, &
      0.000000000000000_REALK,     -5.179621545525063_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -7.129868449162432_REALK,      0.000000000000000_REALK, &
    -12.302535090480600_REALK,      0.000000000000000_REALK,     -9.774231132763195_REALK, &
      0.000000000000000_REALK,     -6.502468508495534_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -47.975787783710537_REALK,      0.000000000000000_REALK, &
    -18.895203127916517_REALK,      0.000000000000000_REALK,    -54.339221258764233_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -12.079395173522999_REALK, &
      0.000000000000000_REALK,     -3.327584184876589_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.117623691929064_REALK,      0.000000000000000_REALK, &
    -10.935402444089863_REALK,      0.000000000000000_REALK,     -1.333668234050117_REALK, &
      0.000000000000000_REALK,     -3.680639409527779_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.264573516279261_REALK,      0.000000000000000_REALK, &
     -6.627938771265636_REALK,      0.000000000000000_REALK,    -38.747020701595602_REALK, &
     -8.499164621393023_REALK,     -3.684296220621283_REALK,      0.000000000000000_REALK, &
     -3.506038087688466_REALK,      0.000000000000000_REALK,      2.198971771050366_REALK, &
     -5.013585999145064_REALK,      0.000000000000000_REALK,      1.212366844198612_REALK, &
      0.000000000000000_REALK,     -9.846488994287245_REALK,      0.000000000000000_REALK, &
      1.409615865075316_REALK,      0.000000000000000_REALK,      7.095065805410564_REALK, &
    -44.373108248362250_REALK,      0.000000000000000_REALK,      3.874299517259729_REALK, &
      0.000000000000000_REALK,      7.518503368201666_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -14.802992049902166_REALK, &
      0.000000000000000_REALK,     -2.725938964466798_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.136224240192730_REALK,      0.000000000000000_REALK, &
    -11.560934861618581_REALK,      0.000000000000000_REALK,     -1.961592903600855_REALK, &
      0.000000000000000_REALK,     -2.622471347064139_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.775631810414055_REALK,      0.000000000000000_REALK, &
     -5.285010566346935_REALK,      0.000000000000000_REALK,    -32.469863026943557_REALK, &
    -10.005740988981803_REALK,     -2.532989181229321_REALK,      0.000000000000000_REALK, &
     -1.818266578614202_REALK,      0.000000000000000_REALK,      2.318240893247149_REALK, &
     -0.716805482437949_REALK,      0.000000000000000_REALK,      0.719062618853216_REALK, &
      0.000000000000000_REALK,      0.333747310698616_REALK,      0.000000000000000_REALK, &
      0.635831602030370_REALK,      0.000000000000000_REALK,      6.505725576676840_REALK, &
      6.720874551731630_REALK,      0.000000000000000_REALK,      0.439066194227588_REALK, &
      0.000000000000000_REALK,      3.534663034775659_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.531874945915899_REALK, &
      0.000000000000000_REALK,      0.647093875540952_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.693351829844145_REALK,      0.000000000000000_REALK, &
     -1.423084549346142_REALK,      0.000000000000000_REALK,      0.935763843813297_REALK, &
      0.000000000000000_REALK,     -0.740501351789861_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.966627160388534_REALK,      0.000000000000000_REALK, &
     -1.389812971221448_REALK,      0.000000000000000_REALK,    -11.353822503293086_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -20.720421359584524_REALK, &
      0.000000000000000_REALK,     -1.749191133478241_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.959364709109843_REALK,      0.000000000000000_REALK, &
    -13.756621650055447_REALK,      0.000000000000000_REALK,     -0.436924453504645_REALK, &
      0.000000000000000_REALK,     -1.436448500476832_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.438847327561742_REALK,      0.000000000000000_REALK, &
     -3.918591742402388_REALK,      0.000000000000000_REALK,    -30.359322185670457_REALK, &
    -14.456226935440323_REALK,     -2.335140042181182_REALK,      0.000000000000000_REALK, &
     -2.153870975228328_REALK,      0.000000000000000_REALK,      2.885994239377642_REALK, &
     -1.159642894213347_REALK,      0.000000000000000_REALK,      0.563528740305616_REALK, &
      0.000000000000000_REALK,     -1.932974463859586_REALK,      0.000000000000000_REALK, &
      0.642928097479805_REALK,      0.000000000000000_REALK,      6.913386004821320_REALK, &
     -4.398533402024317_REALK,      0.000000000000000_REALK,      0.558143316455072_REALK, &
      0.000000000000000_REALK,      2.176657772460754_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.817417651235136_REALK, &
      0.000000000000000_REALK,      0.451937797308239_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.343998758004372_REALK,      0.000000000000000_REALK, &
     -1.435264337244667_REALK,      0.000000000000000_REALK,      0.134479471214589_REALK, &
      0.000000000000000_REALK,     -0.441464107212875_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.086906847723398_REALK,      0.000000000000000_REALK, &
     -0.541816647744446_REALK,      0.000000000000000_REALK,     -8.997794428234467_REALK, &
     -4.913202895082596_REALK,     -1.820539170109223_REALK,      0.000000000000000_REALK, &
     -1.563875504726686_REALK,      0.000000000000000_REALK,     -0.818114499976440_REALK, &
     -1.816843773286337_REALK,      0.000000000000000_REALK,     -0.366447746203411_REALK, &
      0.000000000000000_REALK,     -3.260810193872512_REALK,      0.000000000000000_REALK, &
     -0.389362200330018_REALK,      0.000000000000000_REALK,      1.453847003317585_REALK, &
    -10.015340087120537_REALK,      0.000000000000000_REALK,     -0.729370057602435_REALK, &
      0.000000000000000_REALK,      1.050014765006440_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -32.728125693528426_REALK, &
      0.000000000000000_REALK,     -0.237348346289606_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.914282221194906_REALK,      0.000000000000000_REALK, &
    -18.613956896841191_REALK,      0.000000000000000_REALK,      0.058923022805139_REALK, &
      0.000000000000000_REALK,     -0.164713417902598_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.997837787259167_REALK,      0.000000000000000_REALK, &
     -4.055189603288780_REALK,      0.000000000000000_REALK,    -32.140045189474222_REALK, &
    -22.812027308918577_REALK,     -1.700298253283517_REALK,      0.000000000000000_REALK, &
     -2.385191837801518_REALK,      0.000000000000000_REALK,      4.030199510880251_REALK, &
     -0.294143306165456_REALK,      0.000000000000000_REALK,      0.351505890360929_REALK, &
      0.000000000000000_REALK,     -0.607786121637989_REALK,      0.000000000000000_REALK, &
      0.601666751096486_REALK,      0.000000000000000_REALK,      8.158529124415908_REALK, &
      1.331646933166183_REALK,      0.000000000000000_REALK,      0.110766371188959_REALK, &
      0.000000000000000_REALK,      1.062268222538015_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.567335801081212_REALK, &
      0.000000000000000_REALK,      0.415661949341356_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.396108716667481_REALK,      0.000000000000000_REALK, &
     -1.736857500218648_REALK,      0.000000000000000_REALK,      0.215765085092533_REALK, &
      0.000000000000000_REALK,     -0.343120748716159_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.448463465666350_REALK,      0.000000000000000_REALK, &
     -0.488132103042799_REALK,      0.000000000000000_REALK,     -8.519142097355987_REALK, &
     -6.571370840284507_REALK,     -1.442787730739821_REALK,      0.000000000000000_REALK, &
     -0.910579005938817_REALK,      0.000000000000000_REALK,     -0.968339232405257_REALK, &
     -0.297333980637619_REALK,      0.000000000000000_REALK,     -0.248781926859772_REALK, &
      0.000000000000000_REALK,      0.120566317578621_REALK,      0.000000000000000_REALK, &
     -0.191583992441245_REALK,      0.000000000000000_REALK,      1.454193232884188_REALK, &
      1.713915051529792_REALK,      0.000000000000000_REALK,     -0.093390433617491_REALK, &
      0.000000000000000_REALK,      0.557737286345559_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.700336542267790_REALK, &
      0.000000000000000_REALK,      1.002888938265343_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.890066319585563_REALK,      0.000000000000000_REALK, &
      0.748734082848155_REALK,      0.000000000000000_REALK,      1.046164447921349_REALK, &
      0.000000000000000_REALK,      0.339303039449601_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.341272406778044_REALK,      0.000000000000000_REALK, &
      0.449545378099109_REALK,      0.000000000000000_REALK,     -2.567694946215498_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -62.110480803947588_REALK, &
      0.000000000000000_REALK,      3.599189130632902_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.185716833933856_REALK,      0.000000000000000_REALK, &
    -29.043455446885048_REALK,      0.000000000000000_REALK,      1.769836795874203_REALK, &
      0.000000000000000_REALK,      2.046554134872355_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.956930301245181_REALK,      0.000000000000000_REALK, &
     -4.945193362722473_REALK,      0.000000000000000_REALK,    -38.698156565717980_REALK, &
    -45.797651452340723_REALK,     -0.281824934244747_REALK,      0.000000000000000_REALK, &
     -3.837470202667137_REALK,      0.000000000000000_REALK,      6.633175895692548_REALK, &
      0.047143177140623_REALK,      0.000000000000000_REALK,      0.047901899739744_REALK, &
      0.000000000000000_REALK,     -1.613097244630747_REALK,      0.000000000000000_REALK, &
      0.793146685291292_REALK,      0.000000000000000_REALK,     11.002278536857297_REALK, &
     -0.640747111219553_REALK,      0.000000000000000_REALK,     -0.013699414907804_REALK, &
      0.000000000000000_REALK,      0.111709094912001_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.379445497756457_REALK, &
      0.000000000000000_REALK,      0.315373257431559_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.440543925739288_REALK,      0.000000000000000_REALK, &
     -2.435939298938896_REALK,      0.000000000000000_REALK,      0.054545600037675_REALK, &
      0.000000000000000_REALK,     -0.213308113154006_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.129320434611430_REALK,      0.000000000000000_REALK, &
     -0.418934765354061_REALK,      0.000000000000000_REALK,     -9.220030308318572_REALK, &
    -11.798877295773506_REALK,     -1.620949216009643_REALK,      0.000000000000000_REALK, &
     -1.275390609492978_REALK,      0.000000000000000_REALK,     -1.425370870927534_REALK, &
     -0.566958058733175_REALK,      0.000000000000000_REALK,     -0.229800844340171_REALK, &
      0.000000000000000_REALK,     -0.792529475146085_REALK,      0.000000000000000_REALK, &
     -0.219867278398074_REALK,      0.000000000000000_REALK,      1.753873516112466_REALK, &
     -1.298363415816945_REALK,      0.000000000000000_REALK,     -0.137417800307978_REALK, &
      0.000000000000000_REALK,      0.397554510417769_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.904241685079037_REALK, &
      0.000000000000000_REALK,      0.828185591168787_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.520485950156793_REALK,      0.000000000000000_REALK, &
      0.890045539573386_REALK,      0.000000000000000_REALK,      0.170636043965660_REALK, &
      0.000000000000000_REALK,      0.229582287410523_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.079390373965853_REALK,      0.000000000000000_REALK, &
      0.202859052703272_REALK,      0.000000000000000_REALK,     -2.355386949120476_REALK, &
     -6.683426497015970_REALK,     -2.106227383367090_REALK,      0.000000000000000_REALK, &
     -1.543385650056613_REALK,      0.000000000000000_REALK,     -2.582795908550430_REALK, &
     -1.480447449043694_REALK,      0.000000000000000_REALK,     -0.955193118828821_REALK, &
      0.000000000000000_REALK,     -2.228248260059539_REALK,      0.000000000000000_REALK, &
     -0.851129341702437_REALK,      0.000000000000000_REALK,     -0.964681897161229_REALK, &
     -4.927229895953364_REALK,      0.000000000000000_REALK,     -1.147859610301372_REALK, &
      0.000000000000000_REALK,     -0.501602737820514_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,   -133.373792392171055_REALK, &
      0.000000000000000_REALK,     14.644029575713702_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -12.603743016071514_REALK,      0.000000000000000_REALK, &
    -52.752695272492886_REALK,      0.000000000000000_REALK,      4.932375440268959_REALK, &
      0.000000000000000_REALK,      6.816327788008542_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.049605622750735_REALK,      0.000000000000000_REALK, &
     -7.735457611652705_REALK,      0.000000000000000_REALK,    -53.960985724698340_REALK, &
    -98.819283882867197_REALK,      5.078162226435365_REALK,      0.000000000000000_REALK, &
     -7.412194665181820_REALK,      0.000000000000000_REALK,     12.650130204356042_REALK, &
      1.736963559749062_REALK,      0.000000000000000_REALK,     -0.730080339175578_REALK, &
      0.000000000000000_REALK,     -2.062977523281597_REALK,      0.000000000000000_REALK, &
      1.254083965616378_REALK,      0.000000000000000_REALK,     17.176213052281032_REALK, &
      2.000063377458838_REALK,      0.000000000000000_REALK,     -0.387495896160348_REALK, &
      0.000000000000000_REALK,     -1.307072500183497_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.564909762010636_REALK, &
      0.000000000000000_REALK,      0.052530180671707_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.712377799358512_REALK,      0.000000000000000_REALK, &
     -4.029590250979160_REALK,      0.000000000000000_REALK,     -0.008746912929034_REALK, &
      0.000000000000000_REALK,     -0.029084573924087_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.323216715303887_REALK,      0.000000000000000_REALK, &
     -0.520068787107097_REALK,      0.000000000000000_REALK,    -11.709005299266316_REALK, &
    -22.883996443005710_REALK,     -1.461378455575188_REALK,      0.000000000000000_REALK, &
     -1.733731873143405_REALK,      0.000000000000000_REALK,     -2.443397094499419_REALK, &
     -0.175813874751092_REALK,      0.000000000000000_REALK,     -0.175240979193981_REALK, &
      0.000000000000000_REALK,     -0.296316952501263_REALK,      0.000000000000000_REALK, &
     -0.244664308969661_REALK,      0.000000000000000_REALK,      2.461136749216485_REALK, &
      0.471531500185649_REALK,      0.000000000000000_REALK,     -0.032714360394257_REALK, &
      0.000000000000000_REALK,      0.232741572841225_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.828821228055355_REALK, &
      0.000000000000000_REALK,      0.935027455826468_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.732713258146652_REALK,      0.000000000000000_REALK, &
      1.316776408019912_REALK,      0.000000000000000_REALK,      0.325545999601664_REALK, &
      0.000000000000000_REALK,      0.212180941914329_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.491444139954990_REALK,      0.000000000000000_REALK, &
      0.219236399453941_REALK,      0.000000000000000_REALK,     -2.675194124102819_REALK, &
    -10.986837842038259_REALK,     -2.066753976446639_REALK,      0.000000000000000_REALK, &
     -1.103125697334885_REALK,      0.000000000000000_REALK,     -3.752654790922415_REALK, &
     -0.296201648059156_REALK,      0.000000000000000_REALK,     -0.792803341009738_REALK, &
      0.000000000000000_REALK,      0.097967148111562_REALK,      0.000000000000000_REALK, &
     -0.497986314060912_REALK,      0.000000000000000_REALK,     -1.147371228953860_REALK, &
      1.011485496280757_REALK,      0.000000000000000_REALK,     -0.176309810204667_REALK, &
      0.000000000000000_REALK,     -0.319615191535139_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.486406480944483_REALK, &
      0.000000000000000_REALK,      2.037324161094183_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.486843364306205_REALK,      0.000000000000000_REALK, &
      3.460596417584956_REALK,      0.000000000000000_REALK,      1.425457758932778_REALK, &
      0.000000000000000_REALK,      1.279153444224871_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.316979758721725_REALK,      0.000000000000000_REALK, &
      1.230904415012322_REALK,      0.000000000000000_REALK,      1.721437203055682_REALK, &
    ! results of test 7, ket-major order, 01ODGYYY
    -45.689239517356945_REALK,     -7.320285628415112_REALK,      0.000000000000000_REALK, &
     -3.903895088078118_REALK,      0.000000000000000_REALK,     -7.245268911964196_REALK, &
      1.307300215052037_REALK,      0.000000000000000_REALK,     -0.937878092167418_REALK, &
      0.000000000000000_REALK,      6.241168893124736_REALK,      0.000000000000000_REALK, &
     -0.621666306536911_REALK,      0.000000000000000_REALK,     -3.461265835336423_REALK, &
    -49.080468183147907_REALK,      0.000000000000000_REALK,     -0.948535331388699_REALK, &
      0.000000000000000_REALK,      2.041483272273793_REALK,      0.000000000000000_REALK, &
    -53.050085872436021_REALK,     -5.985417158641223_REALK,      0.000000000000000_REALK, &
     -5.178558142208937_REALK,      0.000000000000000_REALK,     -6.464749722185091_REALK, &
     -1.524365202209579_REALK,      0.000000000000000_REALK,     -0.537033137691645_REALK, &
      0.000000000000000_REALK,     -1.527513176514407_REALK,      0.000000000000000_REALK, &
     -0.335941239196717_REALK,      0.000000000000000_REALK,     -1.258135550356752_REALK, &
     21.278594648261464_REALK,      0.000000000000000_REALK,      1.568114173041850_REALK, &
      0.000000000000000_REALK,      1.657337638093674_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.438065662270915_REALK, &
      0.000000000000000_REALK,      0.877121336268990_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.262902512452152_REALK,      0.000000000000000_REALK, &
      1.463768383144168_REALK,      0.000000000000000_REALK,     -0.079312763085679_REALK, &
      0.000000000000000_REALK,      0.170700735923221_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.715138548614120_REALK,      0.000000000000000_REALK, &
     -0.811343283040616_REALK,      0.000000000000000_REALK,     -7.528891188055812_REALK, &
    -60.335433353388900_REALK,     -2.468629273521217_REALK,      0.000000000000000_REALK, &
     -3.287646684548865_REALK,      0.000000000000000_REALK,     -5.508208582343331_REALK, &
      0.022819346365745_REALK,      0.000000000000000_REALK,     -0.108695855112396_REALK, &
      0.000000000000000_REALK,      0.048831914179080_REALK,      0.000000000000000_REALK, &
      0.197782092211775_REALK,      0.000000000000000_REALK,      0.994107751488096_REALK, &
     -9.520750823361480_REALK,      0.000000000000000_REALK,     -0.052181695187964_REALK, &
      0.000000000000000_REALK,      0.745674379374567_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.498793176396648_REALK, &
      0.000000000000000_REALK,      0.552003476908755_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.193946360564875_REALK,      0.000000000000000_REALK, &
      0.726349678510571_REALK,      0.000000000000000_REALK,     -0.094260900132374_REALK, &
      0.000000000000000_REALK,     -0.099624211218581_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.016593035343500_REALK,      0.000000000000000_REALK, &
     -1.330509170718846_REALK,      0.000000000000000_REALK,     -8.304829795828464_REALK, &
     -5.493560287443081_REALK,     -0.746062728800833_REALK,      0.000000000000000_REALK, &
     -0.270231184588393_REALK,      0.000000000000000_REALK,     -1.504572400052955_REALK, &
      0.045789024841348_REALK,      0.000000000000000_REALK,     -0.098549337250817_REALK, &
      0.000000000000000_REALK,     -0.163209674382328_REALK,      0.000000000000000_REALK, &
      0.048770650435109_REALK,      0.000000000000000_REALK,      0.452569125759631_REALK, &
     -5.417907204097404_REALK,      0.000000000000000_REALK,     -0.314121478187302_REALK, &
      0.000000000000000_REALK,      1.126778873280414_REALK,      0.000000000000000_REALK, &
    -82.898783773620679_REALK,      0.593295714930949_REALK,      0.000000000000000_REALK, &
     -2.528606455882820_REALK,      0.000000000000000_REALK,     -4.032953101855793_REALK, &
     -0.038742340611496_REALK,      0.000000000000000_REALK,     -0.015884127394722_REALK, &
      0.000000000000000_REALK,      2.178040117457310_REALK,      0.000000000000000_REALK, &
      0.862664641220888_REALK,      0.000000000000000_REALK,      4.127672021771887_REALK, &
      4.320972144895881_REALK,      0.000000000000000_REALK,     -0.166655810391782_REALK, &
      0.000000000000000_REALK,     -0.204983649533163_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.763927575477231_REALK, &
      0.000000000000000_REALK,      0.150576701225414_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.092105470700225_REALK,      0.000000000000000_REALK, &
     -0.462947688304926_REALK,      0.000000000000000_REALK,      0.010784716932835_REALK, &
      0.000000000000000_REALK,     -0.154113182345921_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.097822061992598_REALK,      0.000000000000000_REALK, &
     -1.188615216746178_REALK,      0.000000000000000_REALK,     -9.957183916317918_REALK, &
     -6.894365066739102_REALK,     -0.577630279382067_REALK,      0.000000000000000_REALK, &
     -0.268674487710096_REALK,      0.000000000000000_REALK,     -1.006214435805008_REALK, &
      0.043896514988945_REALK,      0.000000000000000_REALK,      0.046394164227977_REALK, &
      0.000000000000000_REALK,      0.416781880630088_REALK,      0.000000000000000_REALK, &
      0.274984642240085_REALK,      0.000000000000000_REALK,      1.716411055653872_REALK, &
      2.562299597879258_REALK,      0.000000000000000_REALK,      0.566481722326833_REALK, &
      0.000000000000000_REALK,      0.997856210392293_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.574422285634977_REALK, &
      0.000000000000000_REALK,      0.136520698934053_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.022712085125846_REALK,      0.000000000000000_REALK, &
     -0.210757667119057_REALK,      0.000000000000000_REALK,      0.064921448269758_REALK, &
      0.000000000000000_REALK,     -0.232878428929052_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.980844627143011_REALK,      0.000000000000000_REALK, &
     -0.488496679936253_REALK,      0.000000000000000_REALK,     -6.346233211245359_REALK, &
    -76.168792712225553_REALK,      2.296516143679476_REALK,      0.000000000000000_REALK, &
      1.327867370846208_REALK,      0.000000000000000_REALK,      2.071631064600368_REALK, &
     -1.988360066092215_REALK,      0.000000000000000_REALK,     -0.791447615666888_REALK, &
      0.000000000000000_REALK,      3.645198352903438_REALK,      0.000000000000000_REALK, &
      2.158346627423838_REALK,      0.000000000000000_REALK,     10.101832501608746_REALK, &
    -10.347928432570974_REALK,      0.000000000000000_REALK,     -1.677217931779629_REALK, &
      0.000000000000000_REALK,     -2.002801437774159_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.129783340621359_REALK, &
      0.000000000000000_REALK,      0.015994391675586_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.676277623095580_REALK,      0.000000000000000_REALK, &
     -3.235848660554129_REALK,      0.000000000000000_REALK,      0.063409848290531_REALK, &
      0.000000000000000_REALK,      0.077992972992547_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.440268158779996_REALK,      0.000000000000000_REALK, &
     -1.711357478446675_REALK,      0.000000000000000_REALK,    -13.647486414954935_REALK, &
     -5.713203423444510_REALK,     -0.116855425560035_REALK,      0.000000000000000_REALK, &
      0.092744847559779_REALK,      0.000000000000000_REALK,      0.466161374059266_REALK, &
     -0.008454574796034_REALK,      0.000000000000000_REALK,      0.120815542523098_REALK, &
      0.000000000000000_REALK,      0.037219717067383_REALK,      0.000000000000000_REALK, &
      0.452248921849824_REALK,      0.000000000000000_REALK,      3.788547906312731_REALK, &
     -1.301185606968516_REALK,      0.000000000000000_REALK,     -0.021394763496759_REALK, &
      0.000000000000000_REALK,      0.509550553274957_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.780875229326642_REALK, &
      0.000000000000000_REALK,     -0.046716222785413_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.215571557423201_REALK,      0.000000000000000_REALK, &
     -1.345563888337643_REALK,      0.000000000000000_REALK,     -0.215537160016562_REALK, &
      0.000000000000000_REALK,     -0.379668196194256_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.826813519663823_REALK,      0.000000000000000_REALK, &
     -0.909192675556093_REALK,      0.000000000000000_REALK,     -7.945053535586577_REALK, &
     -1.560566935383870_REALK,     -0.105947229829469_REALK,      0.000000000000000_REALK, &
      0.022869747657195_REALK,      0.000000000000000_REALK,      0.212220702640237_REALK, &
     -0.050894543054017_REALK,      0.000000000000000_REALK,      0.182562797709529_REALK, &
      0.000000000000000_REALK,     -0.373195563104039_REALK,      0.000000000000000_REALK, &
      0.185865109007405_REALK,      0.000000000000000_REALK,      2.414639394782498_REALK, &
     -2.221369828280061_REALK,      0.000000000000000_REALK,     -0.214652370301548_REALK, &
      0.000000000000000_REALK,      1.077965315493592_REALK,      0.000000000000000_REALK, &
   -106.892564597897973_REALK,     -4.282728179562858_REALK,      0.000000000000000_REALK, &
     14.482941726188965_REALK,      0.000000000000000_REALK,     19.697699358486865_REALK, &
     -9.860709758343889_REALK,      0.000000000000000_REALK,     -4.636417096311788_REALK, &
      0.000000000000000_REALK,     14.300072374287343_REALK,      0.000000000000000_REALK, &
      5.812384781771423_REALK,      0.000000000000000_REALK,     23.715611818035974_REALK, &
    -11.510223293798497_REALK,      0.000000000000000_REALK,     -4.187738990115709_REALK, &
      0.000000000000000_REALK,     -5.907111696164013_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.128194165631030_REALK, &
      0.000000000000000_REALK,      0.992434841143724_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.170690840896372_REALK,      0.000000000000000_REALK, &
    -10.159607826146159_REALK,      0.000000000000000_REALK,      1.000627498061868_REALK, &
      0.000000000000000_REALK,      1.194870477963614_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.556931035019986_REALK,      0.000000000000000_REALK, &
     -2.765608224768045_REALK,      0.000000000000000_REALK,    -21.573389167973321_REALK, &
     -7.339707732849301_REALK,     -0.024151772763669_REALK,      0.000000000000000_REALK, &
      0.848017559419122_REALK,      0.000000000000000_REALK,      4.057588762455508_REALK, &
     -0.063772507695473_REALK,      0.000000000000000_REALK,     -0.078439037538318_REALK, &
      0.000000000000000_REALK,      0.859263365213983_REALK,      0.000000000000000_REALK, &
      1.020995136947153_REALK,      0.000000000000000_REALK,      8.142084536229468_REALK, &
      0.702208256180515_REALK,      0.000000000000000_REALK,     -0.081250525627064_REALK, &
      0.000000000000000_REALK,     -0.166561142096495_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.703910708568200_REALK, &
      0.000000000000000_REALK,     -0.151496512691585_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.454835465254440_REALK,      0.000000000000000_REALK, &
     -3.810215716066842_REALK,      0.000000000000000_REALK,      0.012764106717290_REALK, &
      0.000000000000000_REALK,     -0.303997641331295_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.047691670252223_REALK,      0.000000000000000_REALK, &
     -0.965819022470314_REALK,      0.000000000000000_REALK,    -11.327107798701931_REALK, &
     -1.831243678976629_REALK,      0.070542201289997_REALK,      0.000000000000000_REALK, &
      0.270315710239558_REALK,      0.000000000000000_REALK,      1.687268313577370_REALK, &
      0.216769879859011_REALK,      0.000000000000000_REALK,      0.381839629273171_REALK, &
      0.000000000000000_REALK,      0.493276590876350_REALK,      0.000000000000000_REALK, &
      0.542423959915904_REALK,      0.000000000000000_REALK,      4.740015528480623_REALK, &
      1.249210505486041_REALK,      0.000000000000000_REALK,      0.460299359790071_REALK, &
      0.000000000000000_REALK,      1.135142722853048_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.320456463107427_REALK, &
      0.000000000000000_REALK,     -0.228924413387668_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.186928125741386_REALK,      0.000000000000000_REALK, &
     -2.428449421295229_REALK,      0.000000000000000_REALK,      0.128061511970592_REALK, &
      0.000000000000000_REALK,     -0.643113644447697_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.796993329410503_REALK,      0.000000000000000_REALK, &
     -0.555704765468677_REALK,      0.000000000000000_REALK,     -9.282030724643265_REALK, &
   1305.695397718787490_REALK,   -219.331144813106960_REALK,      0.000000000000000_REALK, &
    131.158660180032314_REALK,      0.000000000000000_REALK,    153.279467480316100_REALK, &
    -64.984109371380796_REALK,      0.000000000000000_REALK,    -28.916997956319168_REALK, &
      0.000000000000000_REALK,     51.328590933693832_REALK,      0.000000000000000_REALK, &
     20.350054958138170_REALK,      0.000000000000000_REALK,     71.346693757705708_REALK, &
    -54.710316763712711_REALK,      0.000000000000000_REALK,    -13.294511607446839_REALK, &
      0.000000000000000_REALK,    -17.747601776878817_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,   -107.760592227569859_REALK, &
      0.000000000000000_REALK,     13.264715292674239_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -10.446099229505014_REALK,      0.000000000000000_REALK, &
    -42.622029277305337_REALK,      0.000000000000000_REALK,      4.377158017184644_REALK, &
      0.000000000000000_REALK,      6.174301068022165_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.257790069481799_REALK,      0.000000000000000_REALK, &
     -6.411219087370793_REALK,      0.000000000000000_REALK,    -43.598278751637750_REALK, &
     82.533262707441324_REALK,     -5.429332851648177_REALK,      0.000000000000000_REALK, &
      6.210311840971115_REALK,      0.000000000000000_REALK,     29.066475793615972_REALK, &
     -1.798341735617164_REALK,      0.000000000000000_REALK,     -2.147437936035951_REALK, &
      0.000000000000000_REALK,      1.627353848515047_REALK,      0.000000000000000_REALK, &
      2.890701698937726_REALK,      0.000000000000000_REALK,     22.549192673497931_REALK, &
     -2.269871956198059_REALK,      0.000000000000000_REALK,     -1.103719446627409_REALK, &
      0.000000000000000_REALK,     -2.196624593540614_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -22.197930839560051_REALK, &
      0.000000000000000_REALK,      0.224412834126777_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.834946741110549_REALK,      0.000000000000000_REALK, &
    -14.633068214480803_REALK,      0.000000000000000_REALK,      0.084925634211778_REALK, &
      0.000000000000000_REALK,      0.174095004535839_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.947790948977643_REALK,      0.000000000000000_REALK, &
     -1.876975847228004_REALK,      0.000000000000000_REALK,    -20.955530202427692_REALK, &
     18.571752377500221_REALK,      0.828794958789076_REALK,      0.000000000000000_REALK, &
      1.301277004696267_REALK,      0.000000000000000_REALK,     10.900966334004902_REALK, &
     -0.022939831128001_REALK,      0.000000000000000_REALK,      0.546348813113912_REALK, &
      0.000000000000000_REALK,      0.049848850964724_REALK,      0.000000000000000_REALK, &
      1.009504767926943_REALK,      0.000000000000000_REALK,     11.839453420957577_REALK, &
     -0.856265504244285_REALK,      0.000000000000000_REALK,     -0.023465263597072_REALK, &
      0.000000000000000_REALK,      0.782407960275837_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -9.230572028178093_REALK, &
      0.000000000000000_REALK,     -1.092437083324111_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.974851927820186_REALK,      0.000000000000000_REALK, &
     -8.518822207915285_REALK,      0.000000000000000_REALK,     -0.481119534375374_REALK, &
      0.000000000000000_REALK,     -1.186487286268941_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.906829242934780_REALK,      0.000000000000000_REALK, &
     -1.396053016148370_REALK,      0.000000000000000_REALK,    -15.685099578714027_REALK, &
      8.454819635726654_REALK,      1.252381301645529_REALK,      0.000000000000000_REALK, &
      0.534798383459751_REALK,      0.000000000000000_REALK,      6.947755024405703_REALK, &
     -0.230153940551325_REALK,      0.000000000000000_REALK,      1.155812837239900_REALK, &
      0.000000000000000_REALK,     -0.833042782681992_REALK,      0.000000000000000_REALK, &
      0.580840299526815_REALK,      0.000000000000000_REALK,      9.701873803028937_REALK, &
     -2.436345163388733_REALK,      0.000000000000000_REALK,     -0.329595801901492_REALK, &
      0.000000000000000_REALK,      2.128115718816057_REALK,      0.000000000000000_REALK, &
    ! results of test 7, ket-major order, 02ODGYYY
     59.927206873469522_REALK,      9.788455696139927_REALK,      0.000000000000000_REALK, &
     11.389729398968546_REALK,      0.000000000000000_REALK,     14.218581301152929_REALK, &
      8.384370235441304_REALK,      0.000000000000000_REALK,      2.953809657017096_REALK, &
      0.000000000000000_REALK,     19.094487972701248_REALK,      0.000000000000000_REALK, &
      4.199391566633449_REALK,      0.000000000000000_REALK,     15.727166549969382_REALK, &
     80.624911102675995_REALK,      0.000000000000000_REALK,      5.941607887656023_REALK, &
      0.000000000000000_REALK,      6.279676921677671_REALK,      0.000000000000000_REALK, &
     69.500263487066078_REALK,      2.075421120235371_REALK,      0.000000000000000_REALK, &
      8.999528090411697_REALK,      0.000000000000000_REALK,     14.766738134040878_REALK, &
      0.812267605876679_REALK,      0.000000000000000_REALK,      0.540291861280102_REALK, &
      0.000000000000000_REALK,      6.402194823439418_REALK,      0.000000000000000_REALK, &
      2.885978600627490_REALK,      0.000000000000000_REALK,     14.206241647709218_REALK, &
      3.228799297894290_REALK,      0.000000000000000_REALK,      0.456264449540314_REALK, &
      0.000000000000000_REALK,      0.910473224198126_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -11.312879689788632_REALK, &
      0.000000000000000_REALK,     -1.800648686406224_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.359133418079959_REALK,      0.000000000000000_REALK, &
     -8.835204717402965_REALK,      0.000000000000000_REALK,     -1.639042820145139_REALK, &
      0.000000000000000_REALK,     -1.732302024287131_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.025479954004919_REALK,      0.000000000000000_REALK, &
     -3.975495400548449_REALK,      0.000000000000000_REALK,    -24.814419458541586_REALK, &
     93.658839309384788_REALK,     -7.965546625393991_REALK,      0.000000000000000_REALK, &
      9.310636885344614_REALK,      0.000000000000000_REALK,     17.146602911210536_REALK, &
     -4.857363680436282_REALK,      0.000000000000000_REALK,     -1.762818256440101_REALK, &
      0.000000000000000_REALK,      2.766286430715174_REALK,      0.000000000000000_REALK, &
      2.548654277295023_REALK,      0.000000000000000_REALK,     14.080915211994716_REALK, &
    -13.509238676348193_REALK,      0.000000000000000_REALK,     -2.143931449139546_REALK, &
      0.000000000000000_REALK,     -2.334205392724362_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -13.221903908090807_REALK, &
      0.000000000000000_REALK,     -0.387840914219017_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.783286474163096_REALK,      0.000000000000000_REALK, &
     -8.778235075458998_REALK,      0.000000000000000_REALK,     -0.159608445580550_REALK, &
      0.000000000000000_REALK,     -0.318497783913218_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.746092185666520_REALK,      0.000000000000000_REALK, &
     -2.361308030227648_REALK,      0.000000000000000_REALK,    -19.372580976401196_REALK, &
     11.547586906907336_REALK,      1.612272371039740_REALK,      0.000000000000000_REALK, &
      1.693470746468307_REALK,      0.000000000000000_REALK,      6.342227452382933_REALK, &
      1.012787444474969_REALK,      0.000000000000000_REALK,      1.070413608889864_REALK, &
      0.000000000000000_REALK,      2.107807194499632_REALK,      0.000000000000000_REALK, &
      1.390690512779254_REALK,      0.000000000000000_REALK,      8.680472304497673_REALK, &
      6.065880410176613_REALK,      0.000000000000000_REALK,      1.341065028082392_REALK, &
      0.000000000000000_REALK,      2.362282866453819_REALK,      0.000000000000000_REALK, &
    138.144491124530333_REALK,    -24.611489426325690_REALK,      0.000000000000000_REALK, &
     15.122597063013169_REALK,      0.000000000000000_REALK,     22.381286697657284_REALK, &
     -8.800789824681408_REALK,      0.000000000000000_REALK,     -4.665886946277485_REALK, &
      0.000000000000000_REALK,      9.413561740359665_REALK,      0.000000000000000_REALK, &
      3.498226255139446_REALK,      0.000000000000000_REALK,     15.532015649820089_REALK, &
     -5.035876156891727_REALK,      0.000000000000000_REALK,     -3.039201006383836_REALK, &
      0.000000000000000_REALK,     -4.833850797015168_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -17.421219446253016_REALK, &
      0.000000000000000_REALK,      1.485063360211761_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.793395869911121_REALK,      0.000000000000000_REALK, &
     -9.908230947887343_REALK,      0.000000000000000_REALK,      0.946584914856141_REALK, &
      0.000000000000000_REALK,      1.030594338179756_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.672202554757061_REALK,      0.000000000000000_REALK, &
     -1.857955015830344_REALK,      0.000000000000000_REALK,    -17.108183508627750_REALK, &
     15.214998581778268_REALK,      0.394052496102732_REALK,      0.000000000000000_REALK, &
      1.502306544571923_REALK,      0.000000000000000_REALK,      7.395110205073394_REALK, &
      0.112310692610255_REALK,      0.000000000000000_REALK,      0.224115375449053_REALK, &
      0.000000000000000_REALK,      0.770931609573369_REALK,      0.000000000000000_REALK, &
      1.042560647934539_REALK,      0.000000000000000_REALK,      8.553348532412350_REALK, &
      0.274462679543396_REALK,      0.000000000000000_REALK,      0.116353683069954_REALK, &
      0.000000000000000_REALK,      0.386971901488121_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.443803288508817_REALK, &
      0.000000000000000_REALK,     -0.901756051723982_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.978578634286140_REALK,      0.000000000000000_REALK, &
     -6.108134523559767_REALK,      0.000000000000000_REALK,     -0.592104717682740_REALK, &
      0.000000000000000_REALK,     -1.042991055943395_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.536579905839677_REALK,      0.000000000000000_REALK, &
     -1.689676284398610_REALK,      0.000000000000000_REALK,    -14.765372509349630_REALK, &
    254.481742775591982_REALK,    -64.947333186223688_REALK,      0.000000000000000_REALK, &
     29.104196664670148_REALK,      0.000000000000000_REALK,     33.800548898213592_REALK, &
    -21.384281178006333_REALK,      0.000000000000000_REALK,    -10.123331593273802_REALK, &
      0.000000000000000_REALK,     13.270742860094821_REALK,      0.000000000000000_REALK, &
      5.516364183187092_REALK,      0.000000000000000_REALK,     19.219510450241376_REALK, &
    -24.375717920611173_REALK,      0.000000000000000_REALK,     -5.698579926794345_REALK, &
      0.000000000000000_REALK,     -8.093133511877735_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -27.777354042278834_REALK, &
      0.000000000000000_REALK,      4.781230842024115_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.925461209321992_REALK,      0.000000000000000_REALK, &
    -12.988956680367583_REALK,      0.000000000000000_REALK,      1.709324288764227_REALK, &
      0.000000000000000_REALK,      2.718681179114093_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.097840241631455_REALK,      0.000000000000000_REALK, &
     -2.338770387269860_REALK,      0.000000000000000_REALK,    -17.306779496724896_REALK, &
     25.480810855444243_REALK,     -1.843108096914563_REALK,      0.000000000000000_REALK, &
      1.837729834414161_REALK,      0.000000000000000_REALK,     10.153169149486599_REALK, &
     -0.791600441987597_REALK,      0.000000000000000_REALK,     -0.861854991358060_REALK, &
      0.000000000000000_REALK,      0.378063889621684_REALK,      0.000000000000000_REALK, &
      1.044961366266749_REALK,      0.000000000000000_REALK,      9.622079469738011_REALK, &
     -1.329223453195976_REALK,      0.000000000000000_REALK,     -0.632847793835352_REALK, &
      0.000000000000000_REALK,     -1.148355072746579_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -9.178051160458727_REALK, &
      0.000000000000000_REALK,     -0.229655659814845_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.871862055639542_REALK,      0.000000000000000_REALK, &
     -7.152907649875858_REALK,      0.000000000000000_REALK,     -0.065440283857793_REALK, &
      0.000000000000000_REALK,     -0.217642883407029_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.515413208745874_REALK,      0.000000000000000_REALK, &
     -1.161688711405252_REALK,      0.000000000000000_REALK,    -13.342974182178022_REALK, &
      9.424904685389158_REALK,      1.119166982974506_REALK,      0.000000000000000_REALK, &
      1.002769763062424_REALK,      0.000000000000000_REALK,      6.259131759413061_REALK, &
      0.495159334217608_REALK,      0.000000000000000_REALK,      0.872221992888381_REALK, &
      0.000000000000000_REALK,      0.864211794205722_REALK,      0.000000000000000_REALK, &
      0.950317108675855_REALK,      0.000000000000000_REALK,      8.304422711715631_REALK, &
      1.790532545613816_REALK,      0.000000000000000_REALK,      0.659761490004965_REALK, &
      0.000000000000000_REALK,      1.627035619904797_REALK,      0.000000000000000_REALK, &
    498.220670977754821_REALK,   -166.212572773721831_REALK,      0.000000000000000_REALK, &
     70.399280358342338_REALK,      0.000000000000000_REALK,     58.487606886398389_REALK, &
    -47.389803101170315_REALK,      0.000000000000000_REALK,    -21.913753431177284_REALK, &
      0.000000000000000_REALK,     35.407166516018670_REALK,      0.000000000000000_REALK, &
     10.922871751961887_REALK,      0.000000000000000_REALK,     27.224111916234456_REALK, &
    -32.502734300080043_REALK,      0.000000000000000_REALK,     -9.695051505631525_REALK, &
      0.000000000000000_REALK,    -13.449410271450992_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -49.846913787635813_REALK, &
      0.000000000000000_REALK,     12.679229518916866_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.658782957229096_REALK,      0.000000000000000_REALK, &
    -19.715710306725370_REALK,      0.000000000000000_REALK,      4.155589804066188_REALK, &
      0.000000000000000_REALK,      5.901776150716298_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.785034358866250_REALK,      0.000000000000000_REALK, &
     -3.473037782773851_REALK,      0.000000000000000_REALK,    -20.167294901578984_REALK, &
     46.193439988250503_REALK,     -7.051057138121137_REALK,      0.000000000000000_REALK, &
      3.664069854861506_REALK,      0.000000000000000_REALK,     16.268356068774164_REALK, &
     -1.753454781523930_REALK,      0.000000000000000_REALK,     -2.788870751028251_REALK, &
      0.000000000000000_REALK,      1.529813327298100_REALK,      0.000000000000000_REALK, &
      1.705507424699372_REALK,      0.000000000000000_REALK,     12.620666436501002_REALK, &
     -0.594395351066618_REALK,      0.000000000000000_REALK,     -1.076170397883583_REALK, &
      0.000000000000000_REALK,     -2.852749305166500_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -14.973252321724589_REALK, &
      0.000000000000000_REALK,      1.079452663065346_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.071939664247610_REALK,      0.000000000000000_REALK, &
     -9.870497579258673_REALK,      0.000000000000000_REALK,      0.461493191877956_REALK, &
      0.000000000000000_REALK,      0.837417864284979_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.238024562801788_REALK,      0.000000000000000_REALK, &
     -1.096492238385486_REALK,      0.000000000000000_REALK,    -14.135211228664636_REALK, &
     15.263000026728292_REALK,      0.338681656031871_REALK,      0.000000000000000_REALK, &
      1.091986270570584_REALK,      0.000000000000000_REALK,      8.958844920248509_REALK, &
      0.067129788881481_REALK,      0.000000000000000_REALK,      0.223261880196304_REALK, &
      0.000000000000000_REALK,      0.375856073383226_REALK,      0.000000000000000_REALK, &
      0.847141187213302_REALK,      0.000000000000000_REALK,      9.730130695660666_REALK, &
      0.097186270479639_REALK,      0.000000000000000_REALK,      0.068667383928427_REALK, &
      0.000000000000000_REALK,      0.319725911540175_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -9.230572028178090_REALK, &
      0.000000000000000_REALK,     -1.092437083324111_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.974851927820186_REALK,      0.000000000000000_REALK, &
     -8.518822207915283_REALK,      0.000000000000000_REALK,     -0.481119534375374_REALK, &
      0.000000000000000_REALK,     -1.186487286268941_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.906829242934780_REALK,      0.000000000000000_REALK, &
     -1.396053016148370_REALK,      0.000000000000000_REALK,    -15.685099578714023_REALK, &
   1785.757997631048966_REALK,   -638.726358228797608_REALK,      0.000000000000000_REALK, &
    239.949910671693345_REALK,      0.000000000000000_REALK,    145.062794984545945_REALK, &
   -146.828650981843595_REALK,      0.000000000000000_REALK,    -59.739221640064009_REALK, &
      0.000000000000000_REALK,     91.169653177920281_REALK,      0.000000000000000_REALK, &
     26.724932227855529_REALK,      0.000000000000000_REALK,     48.470033023470926_REALK, &
    -91.738279557465944_REALK,      0.000000000000000_REALK,    -21.040132837570059_REALK, &
      0.000000000000000_REALK,    -25.681387464536755_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,   -143.458940570370487_REALK, &
      0.000000000000000_REALK,     42.072525930477134_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -16.150155504119361_REALK,      0.000000000000000_REALK, &
    -40.252568270772237_REALK,      0.000000000000000_REALK,     10.133576262765255_REALK, &
      0.000000000000000_REALK,     14.057751482372256_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -7.501855870886521_REALK,      0.000000000000000_REALK, &
     -6.942815619741073_REALK,      0.000000000000000_REALK,    -28.840399261556023_REALK, &
    155.324352693130578_REALK,    -31.099730880857567_REALK,      0.000000000000000_REALK, &
     10.864377636203638_REALK,      0.000000000000000_REALK,     37.852471769502579_REALK, &
     -6.144301889743182_REALK,      0.000000000000000_REALK,     -8.726148649273620_REALK, &
      0.000000000000000_REALK,      2.911006512301587_REALK,      0.000000000000000_REALK, &
      3.630129578451522_REALK,      0.000000000000000_REALK,     21.079498214126843_REALK, &
     -3.766179249541029_REALK,      0.000000000000000_REALK,     -2.641383553343046_REALK, &
      0.000000000000000_REALK,     -6.252162827669203_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -39.903173521545568_REALK, &
      0.000000000000000_REALK,      5.354392498660222_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.521700405150111_REALK,      0.000000000000000_REALK, &
    -18.660452135996330_REALK,      0.000000000000000_REALK,      1.124847536121815_REALK, &
      0.000000000000000_REALK,      2.981784328393029_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.972382730955859_REALK,      0.000000000000000_REALK, &
     -1.806762888105315_REALK,      0.000000000000000_REALK,    -18.717932255559681_REALK, &
     46.657065560589693_REALK,     -2.647691428715857_REALK,      0.000000000000000_REALK, &
      2.058032160560895_REALK,      0.000000000000000_REALK,     18.950508257487598_REALK, &
     -0.682346820705159_REALK,      0.000000000000000_REALK,     -1.238175182977935_REALK, &
      0.000000000000000_REALK,      0.248790845325804_REALK,      0.000000000000000_REALK, &
      1.146088570313966_REALK,      0.000000000000000_REALK,     14.774572460266503_REALK, &
     -0.616116473418450_REALK,      0.000000000000000_REALK,     -0.488891904029870_REALK, &
      0.000000000000000_REALK,     -1.241989155814138_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -21.974337289768350_REALK, &
      0.000000000000000_REALK,     -0.428643649448119_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.252551729812423_REALK,      0.000000000000000_REALK, &
    -14.386612548307173_REALK,      0.000000000000000_REALK,     -0.071773334200350_REALK, &
      0.000000000000000_REALK,     -0.334187694195592_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.398170535538713_REALK,      0.000000000000000_REALK, &
     -1.256409986979194_REALK,      0.000000000000000_REALK,    -18.554050137177875_REALK, &
     28.762716010308083_REALK,      2.679539734252806_REALK,      0.000000000000000_REALK, &
      1.871632038774243_REALK,      0.000000000000000_REALK,     16.355407546464541_REALK, &
      0.711365607202719_REALK,      0.000000000000000_REALK,      1.754296361985781_REALK, &
      0.000000000000000_REALK,      0.947846773712078_REALK,      0.000000000000000_REALK, &
      1.459199025171289_REALK,      0.000000000000000_REALK,     16.394565070401050_REALK, &
      1.383234442751861_REALK,      0.000000000000000_REALK,      0.713556839218817_REALK, &
      0.000000000000000_REALK,      2.262471623980927_REALK,      0.000000000000000_REALK, &
    ! results of test 7, ket-major order, 03ODGYYY
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.893325794508653_REALK, &
      0.000000000000000_REALK,     -1.929142127175991_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.446026186527643_REALK,      0.000000000000000_REALK, &
     -8.051073355272420_REALK,      0.000000000000000_REALK,      0.991439304161651_REALK, &
      0.000000000000000_REALK,     -2.133823261973322_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     10.287700279649233_REALK,      0.000000000000000_REALK, &
     -3.074191747632522_REALK,      0.000000000000000_REALK,    -28.527080513200904_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -11.312879689788636_REALK, &
      0.000000000000000_REALK,     -1.800648686406224_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.359133418079959_REALK,      0.000000000000000_REALK, &
     -8.835204717402966_REALK,      0.000000000000000_REALK,     -1.639042820145137_REALK, &
      0.000000000000000_REALK,     -1.732302024287131_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.025479954004921_REALK,      0.000000000000000_REALK, &
     -3.975495400548449_REALK,      0.000000000000000_REALK,    -24.814419458541593_REALK, &
     -7.366620029579821_REALK,     -1.468481596768896_REALK,      0.000000000000000_REALK, &
     -0.843354216729498_REALK,      0.000000000000000_REALK,      1.706780119172695_REALK, &
      0.532868003138501_REALK,      0.000000000000000_REALK,      0.416871193345534_REALK, &
      0.000000000000000_REALK,      2.715138548614120_REALK,      0.000000000000000_REALK, &
      0.294913446141036_REALK,      0.000000000000000_REALK,      4.789771031737882_REALK, &
     15.487892505603387_REALK,      0.000000000000000_REALK,     -0.326398628213518_REALK, &
      0.000000000000000_REALK,      2.049194546827174_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -16.088182199446724_REALK, &
      0.000000000000000_REALK,     -0.949093606908014_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.125072213959054_REALK,      0.000000000000000_REALK, &
    -10.681203423142316_REALK,      0.000000000000000_REALK,      0.054541967868912_REALK, &
      0.000000000000000_REALK,     -0.779402583492527_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.231579839459485_REALK,      0.000000000000000_REALK, &
     -2.813877723146029_REALK,      0.000000000000000_REALK,    -23.572218841430217_REALK, &
    -11.047871642273773_REALK,     -1.542502199916491_REALK,      0.000000000000000_REALK, &
     -1.620186761767190_REALK,      0.000000000000000_REALK,      2.205561247715331_REALK, &
     -0.968959643055207_REALK,      0.000000000000000_REALK,      0.372245049948116_REALK, &
      0.000000000000000_REALK,     -2.016593035343500_REALK,      0.000000000000000_REALK, &
      0.483623951613221_REALK,      0.000000000000000_REALK,      5.283411884432448_REALK, &
     -5.803382880706295_REALK,      0.000000000000000_REALK,      0.466366285159557_REALK, &
      0.000000000000000_REALK,      1.437815009737020_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.338054351641085_REALK, &
      0.000000000000000_REALK,      0.262007569218803_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.159554603557531_REALK,      0.000000000000000_REALK, &
     -1.056698052261305_REALK,      0.000000000000000_REALK,     -0.099971064737836_REALK, &
      0.000000000000000_REALK,     -0.255935525457512_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.707014333384148_REALK,      0.000000000000000_REALK, &
     -0.251307129517708_REALK,      0.000000000000000_REALK,     -6.624530130258634_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -25.827055879345661_REALK, &
      0.000000000000000_REALK,      0.308737278554272_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.069935759233539_REALK,      0.000000000000000_REALK, &
    -14.689008145844113_REALK,      0.000000000000000_REALK,      0.174193954849759_REALK, &
      0.000000000000000_REALK,      0.214255431645481_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.676646014087771_REALK,      0.000000000000000_REALK, &
     -3.180448130745146_REALK,      0.000000000000000_REALK,    -25.362978339984320_REALK, &
    -17.712190563869665_REALK,     -0.922564819328431_REALK,      0.000000000000000_REALK, &
     -1.712767907203493_REALK,      0.000000000000000_REALK,      3.129211655783754_REALK, &
      0.036718372306807_REALK,      0.000000000000000_REALK,      0.190723579000017_REALK, &
      0.000000000000000_REALK,     -0.097822061992598_REALK,      0.000000000000000_REALK, &
      0.432047219757092_REALK,      0.000000000000000_REALK,      6.334615534851633_REALK, &
      2.313525076654628_REALK,      0.000000000000000_REALK,     -0.013827140618670_REALK, &
      0.000000000000000_REALK,      0.576376108668922_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.962033144583823_REALK, &
      0.000000000000000_REALK,      0.274570029933507_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.297961255036277_REALK,      0.000000000000000_REALK, &
     -1.327357325603000_REALK,      0.000000000000000_REALK,      0.180286242323642_REALK, &
      0.000000000000000_REALK,     -0.226652149409120_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.467863553491033_REALK,      0.000000000000000_REALK, &
     -0.367183169483809_REALK,      0.000000000000000_REALK,     -6.510577677993071_REALK, &
     -4.838101656553355_REALK,     -0.836445432272681_REALK,      0.000000000000000_REALK, &
     -0.422347665274222_REALK,      0.000000000000000_REALK,     -0.712929426488225_REALK, &
      0.221035927332357_REALK,      0.000000000000000_REALK,     -0.144229467661988_REALK, &
      0.000000000000000_REALK,      0.980844627143011_REALK,      0.000000000000000_REALK, &
     -0.088861099787876_REALK,      0.000000000000000_REALK,      1.070634249681314_REALK, &
      3.949624692070739_REALK,      0.000000000000000_REALK,      0.069425771835247_REALK, &
      0.000000000000000_REALK,      0.323344034352639_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -49.629463817202776_REALK, &
      0.000000000000000_REALK,      3.681560533890689_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.958427952580822_REALK,      0.000000000000000_REALK, &
    -23.207212415204967_REALK,      0.000000000000000_REALK,      1.753081539700306_REALK, &
      0.000000000000000_REALK,      2.093391777967486_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.231598019098343_REALK,      0.000000000000000_REALK, &
     -3.964032893669711_REALK,      0.000000000000000_REALK,    -30.921814421837190_REALK, &
    -36.140734555914023_REALK,      0.366591402837469_REALK,      0.000000000000000_REALK, &
     -3.009692795366380_REALK,      0.000000000000000_REALK,      5.234500934144716_REALK, &
      0.139369232591230_REALK,      0.000000000000000_REALK,     -0.062309691196174_REALK, &
      0.000000000000000_REALK,     -1.440268158779995_REALK,      0.000000000000000_REALK, &
      0.622057693824127_REALK,      0.000000000000000_REALK,      8.682332292182787_REALK, &
     -0.962941498504988_REALK,      0.000000000000000_REALK,     -0.040499539030948_REALK, &
      0.000000000000000_REALK,     -0.145308625453028_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.400380517255335_REALK, &
      0.000000000000000_REALK,      0.171118373909692_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.316347509563497_REALK,      0.000000000000000_REALK, &
     -1.891362853487227_REALK,      0.000000000000000_REALK,     -0.006809013184733_REALK, &
      0.000000000000000_REALK,     -0.115738847871651_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.020813886861016_REALK,      0.000000000000000_REALK, &
     -0.300830318944757_REALK,      0.000000000000000_REALK,     -7.158808448460261_REALK, &
     -9.017047288257281_REALK,     -1.070735667447301_REALK,      0.000000000000000_REALK, &
     -0.959375471115979_REALK,      0.000000000000000_REALK,     -1.089310128774879_REALK, &
     -0.473731595268415_REALK,      0.000000000000000_REALK,     -0.151797451773506_REALK, &
      0.000000000000000_REALK,     -0.826813519663822_REALK,      0.000000000000000_REALK, &
     -0.165388761863313_REALK,      0.000000000000000_REALK,      1.340361462871828_REALK, &
     -1.713048266683539_REALK,      0.000000000000000_REALK,     -0.114821815750593_REALK, &
      0.000000000000000_REALK,      0.262608963843271_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.874456277580546_REALK, &
      0.000000000000000_REALK,      0.480134423136499_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.241413457177297_REALK,      0.000000000000000_REALK, &
      0.655286530630721_REALK,      0.000000000000000_REALK,     -0.126849599004435_REALK, &
      0.000000000000000_REALK,      0.133098619806516_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.645865473170002_REALK,      0.000000000000000_REALK, &
      0.094090734280254_REALK,      0.000000000000000_REALK,     -1.734128506415345_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,   -107.760592227569859_REALK, &
      0.000000000000000_REALK,     13.264715292674239_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -10.446099229505014_REALK,      0.000000000000000_REALK, &
    -42.622029277305337_REALK,      0.000000000000000_REALK,      4.377158017184644_REALK, &
      0.000000000000000_REALK,      6.174301068022166_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.257790069481800_REALK,      0.000000000000000_REALK, &
     -6.411219087370793_REALK,      0.000000000000000_REALK,    -43.598278751637757_REALK, &
    -78.961682640765176_REALK,      5.194381556228854_REALK,      0.000000000000000_REALK, &
     -5.941564123366883_REALK,      0.000000000000000_REALK,     10.108103674832437_REALK, &
      1.720519518424932_REALK,      0.000000000000000_REALK,     -0.746789031007574_REALK, &
      0.000000000000000_REALK,     -1.556931035019986_REALK,      0.000000000000000_REALK, &
      1.005265057702470_REALK,      0.000000000000000_REALK,     13.724676305203682_REALK, &
      2.171644536528472_REALK,      0.000000000000000_REALK,     -0.383827426264346_REALK, &
      0.000000000000000_REALK,     -1.336986292455048_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.758908380406969_REALK, &
      0.000000000000000_REALK,     -0.068330052751908_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.558711395027409_REALK,      0.000000000000000_REALK, &
     -3.179908729190817_REALK,      0.000000000000000_REALK,     -0.025858472347450_REALK, &
      0.000000000000000_REALK,      0.037832545882905_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.288586906330132_REALK,      0.000000000000000_REALK, &
     -0.407885194929533_REALK,      0.000000000000000_REALK,     -9.240038277398311_REALK, &
    -17.768070341690617_REALK,     -0.792929327683886_REALK,      0.000000000000000_REALK, &
     -1.244964981413342_REALK,      0.000000000000000_REALK,     -1.897153390836913_REALK, &
      0.021947122965232_REALK,      0.000000000000000_REALK,     -0.095084001878389_REALK, &
      0.000000000000000_REALK,     -0.047691670252223_REALK,      0.000000000000000_REALK, &
     -0.175689506311411_REALK,      0.000000000000000_REALK,      1.910927183960644_REALK, &
      0.819211100887157_REALK,      0.000000000000000_REALK,      0.004083785146753_REALK, &
      0.000000000000000_REALK,      0.126283248649951_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.218785007492826_REALK, &
      0.000000000000000_REALK,      0.617642574553026_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.551162225905693_REALK,      0.000000000000000_REALK, &
      1.006319062528967_REALK,      0.000000000000000_REALK,      0.272015580956982_REALK, &
      0.000000000000000_REALK,      0.140158433229338_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.512703529416930_REALK,      0.000000000000000_REALK, &
      0.164914201536666_REALK,      0.000000000000000_REALK,     -2.044461631187914_REALK, &
     -8.088942118132998_REALK,     -1.198185212140493_REALK,      0.000000000000000_REALK, &
     -0.511655287168669_REALK,      0.000000000000000_REALK,     -2.762852044376264_REALK, &
      0.220194159496092_REALK,      0.000000000000000_REALK,     -0.459621827348142_REALK, &
      0.000000000000000_REALK,      0.796993329410502_REALK,      0.000000000000000_REALK, &
     -0.230977604041393_REALK,      0.000000000000000_REALK,     -0.844739823455618_REALK, &
      2.330913710230907_REALK,      0.000000000000000_REALK,      0.131067435726012_REALK, &
      0.000000000000000_REALK,     -0.185294524862255_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,   -375.965288828229234_REALK, &
      0.000000000000000_REALK,     55.518154394211955_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -30.088841062541615_REALK,      0.000000000000000_REALK, &
   -105.490591216066292_REALK,      0.000000000000000_REALK,     13.895846470957441_REALK, &
      0.000000000000000_REALK,     18.550357982391617_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -10.875190791278305_REALK,      0.000000000000000_REALK, &
    -12.934938964249403_REALK,      0.000000000000000_REALK,    -75.582525530875373_REALK, &
   -321.254061972618331_REALK,     31.127846828207819_REALK,      0.000000000000000_REALK, &
    -19.187718721419557_REALK,      0.000000000000000_REALK,     28.457270916532689_REALK, &
      6.191836491066078_REALK,      0.000000000000000_REALK,     -3.174716766943032_REALK, &
      0.000000000000000_REALK,     -5.257790069481800_REALK,      0.000000000000000_REALK, &
      2.330400404543751_REALK,      0.000000000000000_REALK,     27.736590605734715_REALK, &
      2.438716358529622_REALK,      0.000000000000000_REALK,     -0.967538670279946_REALK, &
      0.000000000000000_REALK,     -3.981130945381614_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     21.708019909220635_REALK, &
      0.000000000000000_REALK,     -1.255354843296730_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.301389256154941_REALK,      0.000000000000000_REALK, &
     -7.245195839814637_REALK,      0.000000000000000_REALK,     -0.351265404988972_REALK, &
      0.000000000000000_REALK,      0.498939306471004_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.314952353606796_REALK,      0.000000000000000_REALK, &
     -0.665472452525013_REALK,      0.000000000000000_REALK,    -14.746253547331520_REALK, &
    -66.176097422852251_REALK,      0.526621806262230_REALK,      0.000000000000000_REALK, &
     -3.370487027135298_REALK,      0.000000000000000_REALK,     -4.889389788310174_REALK, &
      0.120134031916362_REALK,      0.000000000000000_REALK,      0.044798516387938_REALK, &
      0.000000000000000_REALK,     -0.947790948977643_REALK,      0.000000000000000_REALK, &
     -0.341435561203254_REALK,      0.000000000000000_REALK,      3.535279528523284_REALK, &
     -0.446338889628138_REALK,      0.000000000000000_REALK,      0.015657549513667_REALK, &
      0.000000000000000_REALK,     -0.041674881883439_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     15.117137258481730_REALK, &
      0.000000000000000_REALK,      0.593051775569090_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.843896214646670_REALK,      0.000000000000000_REALK, &
      2.067891138854843_REALK,      0.000000000000000_REALK,     -0.013866882875043_REALK, &
      0.000000000000000_REALK,      0.096605538361558_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.029856815855376_REALK,      0.000000000000000_REALK, &
      0.176864268509486_REALK,      0.000000000000000_REALK,     -2.942682385045593_REALK, &
    -27.518025811520857_REALK,     -2.563584174169741_REALK,      0.000000000000000_REALK, &
     -1.790638225340088_REALK,      0.000000000000000_REALK,     -6.503909682713920_REALK, &
     -0.680581664590267_REALK,      0.000000000000000_REALK,     -0.697615456090271_REALK, &
      0.000000000000000_REALK,     -0.906829242934780_REALK,      0.000000000000000_REALK, &
     -0.580266718628468_REALK,      0.000000000000000_REALK,     -1.427470845773990_REALK, &
     -1.323375757887013_REALK,      0.000000000000000_REALK,     -0.283753811855651_REALK, &
      0.000000000000000_REALK,     -0.196992861277820_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     11.540402209077071_REALK, &
      0.000000000000000_REALK,      1.502733646963522_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.581579775376138_REALK,      0.000000000000000_REALK, &
      4.367767983971748_REALK,      0.000000000000000_REALK,     -0.233295827688068_REALK, &
      0.000000000000000_REALK,      0.677285728830390_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.836672644234565_REALK,      0.000000000000000_REALK, &
      0.337241380365879_REALK,      0.000000000000000_REALK,      1.521851384206156_REALK, &
    ! results of test 7, ket-major order, 01ODGXXZ
      0.000000000000000_REALK,      0.000000000000000_REALK,     12.763288160987697_REALK, &
      0.000000000000000_REALK,     22.724245558027288_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.420499652076494_REALK,      0.000000000000000_REALK, &
     -2.892876423833626_REALK,      0.000000000000000_REALK,     37.577496208540467_REALK, &
      0.000000000000000_REALK,     17.121690934879854_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,   -371.349576173438663_REALK,      0.000000000000000_REALK, &
   -136.728169389295772_REALK,      0.000000000000000_REALK,   -149.130086653750254_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.549308367691828_REALK, &
      0.000000000000000_REALK,      5.251954490202044_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.399696614631277_REALK,      0.000000000000000_REALK, &
     -2.886878907077082_REALK,      0.000000000000000_REALK,      0.509252924883735_REALK, &
      0.000000000000000_REALK,      0.420507436729581_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -49.045554262338833_REALK,      0.000000000000000_REALK, &
    -37.350932973101635_REALK,      0.000000000000000_REALK,    -74.889758912478996_REALK, &
    -15.197509444764227_REALK,     -6.845545459332619_REALK,      0.000000000000000_REALK, &
     -9.911526230960435_REALK,      0.000000000000000_REALK,     -6.486330237416754_REALK, &
      6.622506196280301_REALK,      0.000000000000000_REALK,      3.017457674076422_REALK, &
      0.000000000000000_REALK,     -2.155351939660321_REALK,      0.000000000000000_REALK, &
     -0.793584654481429_REALK,      0.000000000000000_REALK,     -0.865566684747607_REALK, &
    332.356154380867110_REALK,      0.000000000000000_REALK,    103.078357298605098_REALK, &
      0.000000000000000_REALK,     78.277158486356669_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.863099566257000_REALK, &
      0.000000000000000_REALK,      0.851321628321056_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.519902874426877_REALK,      0.000000000000000_REALK, &
     -4.092586770681837_REALK,      0.000000000000000_REALK,     -3.019737912358106_REALK, &
      0.000000000000000_REALK,     -2.724938064436886_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -27.209703613070168_REALK,      0.000000000000000_REALK, &
    -18.829551601322372_REALK,      0.000000000000000_REALK,    -50.968613753264684_REALK, &
     -6.349742312732072_REALK,     -1.624670341286806_REALK,      0.000000000000000_REALK, &
     -0.857999341348909_REALK,      0.000000000000000_REALK,     -1.032188896597992_REALK, &
      2.812461257143922_REALK,      0.000000000000000_REALK,      2.322344784593735_REALK, &
      0.000000000000000_REALK,      3.606185937536314_REALK,      0.000000000000000_REALK, &
      2.746312306330482_REALK,      0.000000000000000_REALK,      5.506439870393015_REALK, &
     25.111071234446342_REALK,      0.000000000000000_REALK,     21.015645049476770_REALK, &
      0.000000000000000_REALK,     28.922219847802147_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.006519359636987_REALK, &
      0.000000000000000_REALK,      1.078876671792775_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.382745755466257_REALK,      0.000000000000000_REALK, &
     -4.780282345718354_REALK,      0.000000000000000_REALK,     -7.579070685312044_REALK, &
      0.000000000000000_REALK,     -5.755506129136762_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -88.946197669741267_REALK,      0.000000000000000_REALK, &
    -54.582221002464834_REALK,      0.000000000000000_REALK,    -83.346335564151673_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.754967233053659_REALK, &
      0.000000000000000_REALK,     -1.086428987155238_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.532174112093274_REALK,      0.000000000000000_REALK, &
     -6.004464678833346_REALK,      0.000000000000000_REALK,     -2.666523970555283_REALK, &
      0.000000000000000_REALK,     -3.325507279267652_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -9.111610800241591_REALK,      0.000000000000000_REALK, &
    -10.332193048468845_REALK,      0.000000000000000_REALK,    -40.834006317686004_REALK, &
     -2.324266729156793_REALK,      0.297424056529259_REALK,      0.000000000000000_REALK, &
      0.987995303276920_REALK,      0.000000000000000_REALK,      1.604608077843696_REALK, &
      2.621409687982557_REALK,      0.000000000000000_REALK,      2.365496360473615_REALK, &
      0.000000000000000_REALK,      4.370139208581374_REALK,      0.000000000000000_REALK, &
      3.024206470717241_REALK,      0.000000000000000_REALK,      8.186047909143298_REALK, &
     21.275689867879770_REALK,      0.000000000000000_REALK,     10.696306713669058_REALK, &
      0.000000000000000_REALK,     16.086811813307325_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.360613190735074_REALK, &
      0.000000000000000_REALK,     -0.910537371520762_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.384051164366977_REALK,      0.000000000000000_REALK, &
     -4.780095240540161_REALK,      0.000000000000000_REALK,     -3.375314032462727_REALK, &
      0.000000000000000_REALK,     -4.645185730555964_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -12.773582335258745_REALK,      0.000000000000000_REALK, &
    -16.212995748084371_REALK,      0.000000000000000_REALK,    -45.510570811617448_REALK, &
     -1.628894169094579_REALK,      0.376924379158824_REALK,      0.000000000000000_REALK, &
      1.718372666582382_REALK,      0.000000000000000_REALK,      1.874237516785833_REALK, &
      6.579329033514314_REALK,      0.000000000000000_REALK,      4.996307614782460_REALK, &
      0.000000000000000_REALK,     14.285611905895594_REALK,      0.000000000000000_REALK, &
      8.766427870230334_REALK,      0.000000000000000_REALK,     13.386220376377761_REALK, &
     86.559908771872514_REALK,      0.000000000000000_REALK,     44.743433043702844_REALK, &
      0.000000000000000_REALK,     47.569096441995924_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.717465632801604_REALK, &
      0.000000000000000_REALK,     -2.277615189418798_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.025158567926540_REALK,      0.000000000000000_REALK, &
     -9.368789907006592_REALK,      0.000000000000000_REALK,     -2.463393817267666_REALK, &
      0.000000000000000_REALK,     -3.341560107023396_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.722405057438578_REALK,      0.000000000000000_REALK, &
     -7.413449629912535_REALK,      0.000000000000000_REALK,    -38.265240487559623_REALK, &
      2.828029507816076_REALK,      1.746282369851392_REALK,      0.000000000000000_REALK, &
      1.839737245237038_REALK,      0.000000000000000_REALK,      4.362510956337053_REALK, &
      1.952900450702653_REALK,      0.000000000000000_REALK,      2.435524576643632_REALK, &
      0.000000000000000_REALK,      2.380276321783223_REALK,      0.000000000000000_REALK, &
      2.699135751574412_REALK,      0.000000000000000_REALK,     10.667292588809591_REALK, &
      4.035677860276780_REALK,      0.000000000000000_REALK,      4.785775290265436_REALK, &
      0.000000000000000_REALK,      9.947488903442311_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.579182652514395_REALK, &
      0.000000000000000_REALK,     -1.718638436848399_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.214858836784320_REALK,      0.000000000000000_REALK, &
     -5.995272057468279_REALK,      0.000000000000000_REALK,     -2.794255171698325_REALK, &
      0.000000000000000_REALK,     -4.202446536805851_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -7.843358796093478_REALK,      0.000000000000000_REALK, &
     -9.046216947630068_REALK,      0.000000000000000_REALK,    -34.281347013035543_REALK, &
      1.350819876223703_REALK,      1.463561243096998_REALK,      0.000000000000000_REALK, &
      1.732119328086352_REALK,      0.000000000000000_REALK,      3.472952040621012_REALK, &
      2.472001890118688_REALK,      0.000000000000000_REALK,      3.402026536034171_REALK, &
      0.000000000000000_REALK,      3.336913334375374_REALK,      0.000000000000000_REALK, &
      4.235410261741433_REALK,      0.000000000000000_REALK,     11.888977313523910_REALK, &
      7.238415539058548_REALK,      0.000000000000000_REALK,     10.096474331263599_REALK, &
      0.000000000000000_REALK,     19.453004152507511_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.012574195987911_REALK, &
      0.000000000000000_REALK,     -3.630039958025656_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.420328910547921_REALK,      0.000000000000000_REALK, &
     -9.803758036643227_REALK,      0.000000000000000_REALK,    -11.688573685170473_REALK, &
      0.000000000000000_REALK,    -12.426737312627893_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -42.732116931066997_REALK,      0.000000000000000_REALK, &
    -36.711849138879927_REALK,      0.000000000000000_REALK,    -72.075229866366783_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -19.164246747115197_REALK, &
      0.000000000000000_REALK,     -3.012608724838126_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.011451006795426_REALK,      0.000000000000000_REALK, &
    -15.835967065080711_REALK,      0.000000000000000_REALK,     -1.694014725707878_REALK, &
      0.000000000000000_REALK,     -2.952804830911805_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.018108957926222_REALK,      0.000000000000000_REALK, &
     -6.297089664884547_REALK,      0.000000000000000_REALK,    -41.431601836029159_REALK, &
     12.478701596132039_REALK,      3.218769986049249_REALK,      0.000000000000000_REALK, &
      2.904522610860802_REALK,      0.000000000000000_REALK,      8.995185379639876_REALK, &
      1.960773137769950_REALK,      0.000000000000000_REALK,      2.659762012134346_REALK, &
      0.000000000000000_REALK,      2.581493946669505_REALK,      0.000000000000000_REALK, &
      2.846864355842685_REALK,      0.000000000000000_REALK,     14.694366947909932_REALK, &
      4.483063372300474_REALK,      0.000000000000000_REALK,      3.077979574004074_REALK, &
      0.000000000000000_REALK,      6.958728836228754_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.165185144226196_REALK, &
      0.000000000000000_REALK,     -2.338401787320918_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.148415263440012_REALK,      0.000000000000000_REALK, &
     -8.490782356541743_REALK,      0.000000000000000_REALK,     -1.837802071785318_REALK, &
      0.000000000000000_REALK,     -3.819969515282816_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.974125309391502_REALK,      0.000000000000000_REALK, &
     -5.620893590361899_REALK,      0.000000000000000_REALK,    -31.100178309139224_REALK, &
      4.791219254697452_REALK,      2.428813191577746_REALK,      0.000000000000000_REALK, &
      2.126535659819710_REALK,      0.000000000000000_REALK,      5.756195207021436_REALK, &
      2.224126910742145_REALK,      0.000000000000000_REALK,      3.344996737640153_REALK, &
      0.000000000000000_REALK,      3.011955257183984_REALK,      0.000000000000000_REALK, &
      3.473868963716410_REALK,      0.000000000000000_REALK,     13.164498277279918_REALK, &
      6.944608269390501_REALK,      0.000000000000000_REALK,      5.818977787713433_REALK, &
      0.000000000000000_REALK,     12.252109477750025_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.908043221380152_REALK, &
      0.000000000000000_REALK,     -3.266362002118908_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.371234680563229_REALK,      0.000000000000000_REALK, &
     -9.463199586077813_REALK,      0.000000000000000_REALK,     -3.877181923160118_REALK, &
      0.000000000000000_REALK,     -7.470215203510699_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.949052029651722_REALK,      0.000000000000000_REALK, &
    -12.348214249855504_REALK,      0.000000000000000_REALK,    -44.565382607901789_REALK, &
      5.596309156294396_REALK,      5.130042914770886_REALK,      0.000000000000000_REALK, &
      6.164301827864571_REALK,      0.000000000000000_REALK,      9.412808039466057_REALK, &
      9.303685484665115_REALK,      0.000000000000000_REALK,      9.891237260532899_REALK, &
      0.000000000000000_REALK,     16.409707573907351_REALK,      0.000000000000000_REALK, &
     14.097843779614960_REALK,      0.000000000000000_REALK,     27.677857554708794_REALK, &
     47.090103148066042_REALK,      0.000000000000000_REALK,     34.077693356762111_REALK, &
      0.000000000000000_REALK,     46.581155662160448_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -53.330652663906221_REALK, &
      0.000000000000000_REALK,     -2.700068885653662_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.774669798779198_REALK,      0.000000000000000_REALK, &
    -30.331540500122568_REALK,      0.000000000000000_REALK,     -0.853261310218669_REALK, &
      0.000000000000000_REALK,     -1.873775746412055_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.749445911008713_REALK,      0.000000000000000_REALK, &
     -7.018546180693473_REALK,      0.000000000000000_REALK,    -52.372372394702410_REALK, &
     40.298551224939914_REALK,      4.986879160357707_REALK,      0.000000000000000_REALK, &
      4.961569393014392_REALK,      0.000000000000000_REALK,     19.586740400365898_REALK, &
      1.627154729104622_REALK,      0.000000000000000_REALK,      2.836262443192983_REALK, &
      0.000000000000000_REALK,      2.197068870373979_REALK,      0.000000000000000_REALK, &
      3.443196742930529_REALK,      0.000000000000000_REALK,     22.654458501953957_REALK, &
      0.804663983092715_REALK,      0.000000000000000_REALK,      1.685729481813640_REALK, &
      0.000000000000000_REALK,      4.897271633249592_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -14.890052645549165_REALK, &
      0.000000000000000_REALK,     -3.289730765688780_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.734503265780711_REALK,      0.000000000000000_REALK, &
    -14.114404265582177_REALK,      0.000000000000000_REALK,     -1.683013869584440_REALK, &
      0.000000000000000_REALK,     -3.804975590144926_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.568868137321407_REALK,      0.000000000000000_REALK, &
     -4.721567747256972_REALK,      0.000000000000000_REALK,    -34.119162884352747_REALK, &
     12.964142688427707_REALK,      3.870840260664946_REALK,      0.000000000000000_REALK, &
      2.657270747296086_REALK,      0.000000000000000_REALK,     10.501837313131750_REALK, &
      1.765267023292349_REALK,      0.000000000000000_REALK,      3.669201552678698_REALK, &
      0.000000000000000_REALK,      1.626227213417299_REALK,      0.000000000000000_REALK, &
      3.073458301001978_REALK,      0.000000000000000_REALK,     17.005321244786526_REALK, &
      1.542174888180364_REALK,      0.000000000000000_REALK,      3.048022632400789_REALK, &
      0.000000000000000_REALK,      8.869668395189670_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -9.528436163706763_REALK, &
      0.000000000000000_REALK,     -4.137264397619193_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.336761025048887_REALK,      0.000000000000000_REALK, &
    -12.644917014646735_REALK,      0.000000000000000_REALK,     -3.181769107968916_REALK, &
      0.000000000000000_REALK,     -6.699352509313619_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.995373513077496_REALK,      0.000000000000000_REALK, &
     -8.066050169571712_REALK,      0.000000000000000_REALK,    -39.300336394695165_REALK, &
     10.320626413390348_REALK,      5.406926051914126_REALK,      0.000000000000000_REALK, &
      4.169716837976126_REALK,      0.000000000000000_REALK,     11.704573070126644_REALK, &
      3.724155880187341_REALK,      0.000000000000000_REALK,      7.175378000768197_REALK, &
      0.000000000000000_REALK,      3.799684392042125_REALK,      0.000000000000000_REALK, &
      6.751901806831004_REALK,      0.000000000000000_REALK,     24.367984006750465_REALK, &
      4.610089911795320_REALK,      0.000000000000000_REALK,      9.002511100853104_REALK, &
      0.000000000000000_REALK,     22.301037552294574_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -15.581358397275102_REALK, &
      0.000000000000000_REALK,    -12.233992130969161_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -13.541424893218082_REALK,      0.000000000000000_REALK, &
    -26.585457687098465_REALK,      0.000000000000000_REALK,    -18.633401939138484_REALK, &
      0.000000000000000_REALK,    -25.470192103550332_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -38.102048736327340_REALK,      0.000000000000000_REALK, &
    -42.086678224185832_REALK,      0.000000000000000_REALK,   -100.989123140208974_REALK, &
    ! results of test 7, ket-major order, 02ODGXXZ
      0.000000000000000_REALK,      0.000000000000000_REALK,    -28.965753125648742_REALK, &
      0.000000000000000_REALK,    -18.093070398501713_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -29.125447975212289_REALK,      0.000000000000000_REALK, &
    -35.038446487841028_REALK,      0.000000000000000_REALK,    -30.762225429071130_REALK, &
      0.000000000000000_REALK,    -25.401414368370183_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,   -123.653126965681565_REALK,      0.000000000000000_REALK, &
    -94.168772820987485_REALK,      0.000000000000000_REALK,   -188.811259379423547_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -12.662002860308611_REALK, &
      0.000000000000000_REALK,     -2.095025640137737_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.031261630487816_REALK,      0.000000000000000_REALK, &
    -13.324634954441086_REALK,      0.000000000000000_REALK,     10.706529740294165_REALK, &
      0.000000000000000_REALK,     -2.630083709736629_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     65.519792421635032_REALK,      0.000000000000000_REALK, &
      5.383142955255911_REALK,      0.000000000000000_REALK,    -58.853746943740823_REALK, &
     18.249359200317539_REALK,     13.234728206421323_REALK,      0.000000000000000_REALK, &
     12.175660824620516_REALK,      0.000000000000000_REALK,     14.647542610182247_REALK, &
     16.866609520669002_REALK,      0.000000000000000_REALK,     13.927332351551120_REALK, &
      0.000000000000000_REALK,     20.071090209919987_REALK,      0.000000000000000_REALK, &
     15.285257887348592_REALK,      0.000000000000000_REALK,     30.647407895352149_REALK, &
     53.409726517822158_REALK,      0.000000000000000_REALK,     44.699003248752696_REALK, &
      0.000000000000000_REALK,     61.515808622311823_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.593216743186408_REALK, &
      0.000000000000000_REALK,      0.796803080313696_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.986092815693919_REALK,      0.000000000000000_REALK, &
     -7.779386469780332_REALK,      0.000000000000000_REALK,      4.933270165805684_REALK, &
      0.000000000000000_REALK,      0.881343538163404_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     13.524286551846929_REALK,      0.000000000000000_REALK, &
      4.222351020281305_REALK,      0.000000000000000_REALK,    -27.564422080615838_REALK, &
      9.621650295822146_REALK,      1.557609093346862_REALK,      0.000000000000000_REALK, &
     -1.044031488518195_REALK,      0.000000000000000_REALK,      6.848619723154930_REALK, &
     -5.740202474335560_REALK,      0.000000000000000_REALK,      1.410093969245823_REALK, &
      0.000000000000000_REALK,    -14.055439090405459_REALK,      0.000000000000000_REALK, &
     -1.154802772201099_REALK,      0.000000000000000_REALK,     12.625425460547309_REALK, &
    -63.010920970853228_REALK,      0.000000000000000_REALK,    -12.203432580095122_REALK, &
      0.000000000000000_REALK,      4.996335571270356_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -10.890150997534104_REALK, &
      0.000000000000000_REALK,     -7.158395210067327_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.195043330950000_REALK,      0.000000000000000_REALK, &
    -16.431311629461561_REALK,      0.000000000000000_REALK,     -9.588921062534116_REALK, &
      0.000000000000000_REALK,    -13.196496344552463_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -22.877272293369266_REALK,      0.000000000000000_REALK, &
    -29.037204183226581_REALK,      0.000000000000000_REALK,    -81.508671049165500_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.501649066541628_REALK, &
      0.000000000000000_REALK,      3.130150093577265_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.851880185457260_REALK,      0.000000000000000_REALK, &
     -5.077699231209670_REALK,      0.000000000000000_REALK,      5.681643681570522_REALK, &
      0.000000000000000_REALK,      3.011339960072131_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     12.924313380180232_REALK,      0.000000000000000_REALK, &
      4.805847975070441_REALK,      0.000000000000000_REALK,    -14.261147606389303_REALK, &
      7.439991728189631_REALK,     -0.633968832270975_REALK,      0.000000000000000_REALK, &
     -1.210726429566746_REALK,      0.000000000000000_REALK,      4.742330635482511_REALK, &
     -2.771411601871453_REALK,      0.000000000000000_REALK,     -0.495121009960253_REALK, &
      0.000000000000000_REALK,     -3.730788902519622_REALK,      0.000000000000000_REALK, &
     -1.164771263062054_REALK,      0.000000000000000_REALK,      7.603879110997140_REALK, &
     -8.101907758748149_REALK,      0.000000000000000_REALK,     -4.670246282736151_REALK, &
      0.000000000000000_REALK,     -1.390589218571253_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.449039487707752_REALK, &
      0.000000000000000_REALK,     -0.859596300458952_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.648744887911234_REALK,      0.000000000000000_REALK, &
     -7.092709181519063_REALK,      0.000000000000000_REALK,      3.366420155911865_REALK, &
      0.000000000000000_REALK,     -1.378281451749770_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     13.306054596235557_REALK,      0.000000000000000_REALK, &
      1.822054868576472_REALK,      0.000000000000000_REALK,    -27.888662787109251_REALK, &
      9.428673308471234_REALK,      5.695509423073349_REALK,      0.000000000000000_REALK, &
      4.995715947323057_REALK,      0.000000000000000_REALK,     10.016562723069850_REALK, &
      5.386862302076351_REALK,      0.000000000000000_REALK,      7.413525277177670_REALK, &
      0.000000000000000_REALK,      6.310889174436039_REALK,      0.000000000000000_REALK, &
      8.010158518283088_REALK,      0.000000000000000_REALK,     22.484856723759755_REALK, &
     10.846687859491496_REALK,      0.000000000000000_REALK,     15.129458230416548_REALK, &
      0.000000000000000_REALK,     29.150117568282678_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.627261312531941_REALK, &
      0.000000000000000_REALK,      5.031434541944781_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.339834758705779_REALK,      0.000000000000000_REALK, &
     -3.736029468661759_REALK,      0.000000000000000_REALK,      4.232659454967754_REALK, &
      0.000000000000000_REALK,      4.131850696414371_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.633341516888581_REALK,      0.000000000000000_REALK, &
      3.098251842980338_REALK,      0.000000000000000_REALK,     -8.244998315687800_REALK, &
      6.636538148803118_REALK,     -2.802686915655003_REALK,      0.000000000000000_REALK, &
     -2.047182083680177_REALK,      0.000000000000000_REALK,      3.644954982841382_REALK, &
     -3.510766963468122_REALK,      0.000000000000000_REALK,     -1.860749008580964_REALK, &
      0.000000000000000_REALK,     -4.521127102680836_REALK,      0.000000000000000_REALK, &
     -1.681160839443510_REALK,      0.000000000000000_REALK,      4.988772638201030_REALK, &
    -11.276731442852894_REALK,      0.000000000000000_REALK,     -4.648721528034769_REALK, &
      0.000000000000000_REALK,     -4.106464515432003_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.246207889215592_REALK, &
      0.000000000000000_REALK,      0.355415653859857_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.719728427113357_REALK,      0.000000000000000_REALK, &
     -4.698543075428296_REALK,      0.000000000000000_REALK,      1.633725245122336_REALK, &
      0.000000000000000_REALK,      0.486449873183947_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.052531918527863_REALK,      0.000000000000000_REALK, &
      1.588359973891712_REALK,      0.000000000000000_REALK,    -14.516821158735938_REALK, &
      5.562090181182738_REALK,      0.769668939832991_REALK,      0.000000000000000_REALK, &
     -0.465692394155766_REALK,      0.000000000000000_REALK,      5.091401537554995_REALK, &
     -2.080158019564797_REALK,      0.000000000000000_REALK,      0.851659353940060_REALK, &
      0.000000000000000_REALK,     -4.654666154802923_REALK,      0.000000000000000_REALK, &
     -0.637383310553692_REALK,      0.000000000000000_REALK,      9.755890736732335_REALK, &
    -14.222032840105646_REALK,      0.000000000000000_REALK,     -4.590675612047473_REALK, &
      0.000000000000000_REALK,      2.631323440231621_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.968671930904819_REALK, &
      0.000000000000000_REALK,     -5.321694860022615_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.949588794057846_REALK,      0.000000000000000_REALK, &
    -13.893706925012490_REALK,      0.000000000000000_REALK,     -5.292521284675010_REALK, &
      0.000000000000000_REALK,    -10.197167362592824_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.605950440422809_REALK,      0.000000000000000_REALK, &
    -15.292462829250860_REALK,      0.000000000000000_REALK,    -55.191337242197257_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.771074797125503_REALK, &
      0.000000000000000_REALK,      8.028431615985555_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.143117627669978_REALK,      0.000000000000000_REALK, &
     -2.713524796895419_REALK,      0.000000000000000_REALK,      4.635399139574075_REALK, &
      0.000000000000000_REALK,      5.571517276352591_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.628170697421358_REALK,      0.000000000000000_REALK, &
      2.220266151299432_REALK,      0.000000000000000_REALK,     -4.685344984857986_REALK, &
      6.475525271143193_REALK,     -5.112016983105687_REALK,      0.000000000000000_REALK, &
     -1.971163423347462_REALK,      0.000000000000000_REALK,      3.147369535294750_REALK, &
     -2.978369429272243_REALK,      0.000000000000000_REALK,     -2.907433950556634_REALK, &
      0.000000000000000_REALK,     -2.045704953404005_REALK,      0.000000000000000_REALK, &
     -1.367934808814651_REALK,      0.000000000000000_REALK,      3.640317432619722_REALK, &
     -3.218820062233240_REALK,      0.000000000000000_REALK,     -3.085585571459114_REALK, &
      0.000000000000000_REALK,     -5.020160897232951_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.703331846932600_REALK, &
      0.000000000000000_REALK,      1.567563851292483_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.182972101384508_REALK,      0.000000000000000_REALK, &
     -3.510418939508324_REALK,      0.000000000000000_REALK,      2.052495509392697_REALK, &
      0.000000000000000_REALK,      1.813079128654059_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.295876907458649_REALK,      0.000000000000000_REALK, &
      2.042595081051119_REALK,      0.000000000000000_REALK,     -8.485838533154777_REALK, &
      4.886289256180174_REALK,     -0.361107919311403_REALK,      0.000000000000000_REALK, &
     -0.606325871940619_REALK,      0.000000000000000_REALK,      3.958226630682916_REALK, &
     -1.149593388665315_REALK,      0.000000000000000_REALK,     -0.342297188464803_REALK, &
      0.000000000000000_REALK,     -1.347748626643367_REALK,      0.000000000000000_REALK, &
     -0.701289955539677_REALK,      0.000000000000000_REALK,      6.409441834550679_REALK, &
     -2.066097432252584_REALK,      0.000000000000000_REALK,     -1.984961266752161_REALK, &
      0.000000000000000_REALK,     -0.827445020585492_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.172944398026750_REALK, &
      0.000000000000000_REALK,     -0.717469368891220_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.448503591436679_REALK,      0.000000000000000_REALK, &
     -6.864867593234054_REALK,      0.000000000000000_REALK,      2.026867176702940_REALK, &
      0.000000000000000_REALK,     -1.161777385946864_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.655376909018852_REALK,      0.000000000000000_REALK, &
      1.084180869592944_REALK,      0.000000000000000_REALK,    -21.335972818693666_REALK, &
     10.320626413390347_REALK,      5.406926051914126_REALK,      0.000000000000000_REALK, &
      4.169716837976129_REALK,      0.000000000000000_REALK,     11.704573070126651_REALK, &
      3.724155880187341_REALK,      0.000000000000000_REALK,      7.175378000768197_REALK, &
      0.000000000000000_REALK,      3.799684392042124_REALK,      0.000000000000000_REALK, &
      6.751901806831002_REALK,      0.000000000000000_REALK,     24.367984006750458_REALK, &
      4.610089911795322_REALK,      0.000000000000000_REALK,      9.002511100853107_REALK, &
      0.000000000000000_REALK,     22.301037552294581_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.206033444307832_REALK, &
      0.000000000000000_REALK,     13.630834949787223_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.361424790776474_REALK,      0.000000000000000_REALK, &
     -1.499171931946465_REALK,      0.000000000000000_REALK,      5.168382807688257_REALK, &
      0.000000000000000_REALK,      7.750701787472948_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.761912129990364_REALK,      0.000000000000000_REALK, &
      1.088395899770287_REALK,      0.000000000000000_REALK,     -1.997530570957472_REALK, &
      6.978320596775418_REALK,     -9.964064640876909_REALK,      0.000000000000000_REALK, &
     -2.196096951658087_REALK,      0.000000000000000_REALK,      2.780604973694108_REALK, &
     -3.876444627509649_REALK,      0.000000000000000_REALK,     -4.659292018373784_REALK, &
      0.000000000000000_REALK,     -2.040575889471696_REALK,      0.000000000000000_REALK, &
     -1.248734404853602_REALK,      0.000000000000000_REALK,      2.635157716463964_REALK, &
     -4.585356491846414_REALK,      0.000000000000000_REALK,     -3.099037469313114_REALK, &
      0.000000000000000_REALK,     -6.208146008734194_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.906191769256770_REALK, &
      0.000000000000000_REALK,      2.979307693393622_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.143962662274695_REALK,      0.000000000000000_REALK, &
     -3.044287779585919_REALK,      0.000000000000000_REALK,      1.735412153153714_REALK, &
      0.000000000000000_REALK,      2.823466739159452_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.367674306109695_REALK,      0.000000000000000_REALK, &
      1.524241710529305_REALK,      0.000000000000000_REALK,     -5.678788995247261_REALK, &
      5.416606949803875_REALK,     -1.945499231989518_REALK,      0.000000000000000_REALK, &
     -1.212215975551267_REALK,      0.000000000000000_REALK,      3.597198880995906_REALK, &
     -1.716440149122536_REALK,      0.000000000000000_REALK,     -1.516223443957126_REALK, &
      0.000000000000000_REALK,     -1.853685372853776_REALK,      0.000000000000000_REALK, &
     -1.148807655965239_REALK,      0.000000000000000_REALK,      4.772652379617216_REALK, &
     -3.328676678607131_REALK,      0.000000000000000_REALK,     -2.287023654878235_REALK, &
      0.000000000000000_REALK,     -2.828350547414671_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.912544304772459_REALK, &
      0.000000000000000_REALK,      0.350759007551985_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.586467658689701_REALK,      0.000000000000000_REALK, &
     -5.360023078220301_REALK,      0.000000000000000_REALK,      1.116392926426652_REALK, &
      0.000000000000000_REALK,      0.465376218398490_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.501748956749265_REALK,      0.000000000000000_REALK, &
      1.093991871783061_REALK,      0.000000000000000_REALK,    -12.855268643261214_REALK, &
      7.566107423105763_REALK,      0.890449282179468_REALK,      0.000000000000000_REALK, &
     -0.459590904971768_REALK,      0.000000000000000_REALK,      7.034571784764050_REALK, &
     -1.695007946721867_REALK,      0.000000000000000_REALK,      0.971559421424438_REALK, &
      0.000000000000000_REALK,     -3.180728452115219_REALK,      0.000000000000000_REALK, &
     -0.609771018736853_REALK,      0.000000000000000_REALK,     11.999896185478040_REALK, &
     -6.996789403198992_REALK,      0.000000000000000_REALK,     -3.161853665493497_REALK, &
      0.000000000000000_REALK,      2.330149923430842_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -14.526513800328654_REALK, &
      0.000000000000000_REALK,     -7.352758220561895_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.646412034103212_REALK,      0.000000000000000_REALK, &
    -20.378210773644071_REALK,      0.000000000000000_REALK,     -5.063242231176839_REALK, &
      0.000000000000000_REALK,    -12.542673246261062_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.927396802705048_REALK,      0.000000000000000_REALK, &
    -13.542132656831900_REALK,      0.000000000000000_REALK,    -59.735255106876970_REALK, &
    ! results of test 7, ket-major order, 03ODGXXZ
     25.308453321519988_REALK,     30.275926655644163_REALK,      0.000000000000000_REALK, &
     34.145372391919686_REALK,      0.000000000000000_REALK,     22.345515337661826_REALK, &
     80.378268865008280_REALK,      0.000000000000000_REALK,     36.623298948655545_REALK, &
      0.000000000000000_REALK,    130.197430406421205_REALK,      0.000000000000000_REALK, &
     47.937731616922449_REALK,      0.000000000000000_REALK,     52.285919587361562_REALK, &
    837.932782564974787_REALK,      0.000000000000000_REALK,    259.880052211902409_REALK, &
      0.000000000000000_REALK,    197.351534963867891_REALK,      0.000000000000000_REALK, &
     18.249359200317539_REALK,     13.234728206421323_REALK,      0.000000000000000_REALK, &
     12.175660824620516_REALK,      0.000000000000000_REALK,     14.647542610182247_REALK, &
     16.866609520669002_REALK,      0.000000000000000_REALK,     13.927332351551120_REALK, &
      0.000000000000000_REALK,     20.071090209919991_REALK,      0.000000000000000_REALK, &
     15.285257887348592_REALK,      0.000000000000000_REALK,     30.647407895352153_REALK, &
     53.409726517822158_REALK,      0.000000000000000_REALK,     44.699003248752696_REALK, &
      0.000000000000000_REALK,     61.515808622311823_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.684214238503018_REALK, &
      0.000000000000000_REALK,     -5.324204142638178_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -9.140392163156406_REALK,      0.000000000000000_REALK, &
    -17.448813626687695_REALK,      0.000000000000000_REALK,    -14.669527115365852_REALK, &
      0.000000000000000_REALK,    -19.497434996522941_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -65.789988549111257_REALK,      0.000000000000000_REALK, &
    -70.660617869160774_REALK,      0.000000000000000_REALK,   -127.719198801383484_REALK, &
     17.722842849078987_REALK,      8.981903516342218_REALK,      0.000000000000000_REALK, &
      7.767348236057829_REALK,      0.000000000000000_REALK,     12.614988838170646_REALK, &
      9.010950059410037_REALK,      0.000000000000000_REALK,      8.131262224161649_REALK, &
      0.000000000000000_REALK,     12.415117378810844_REALK,      0.000000000000000_REALK, &
      8.591460482079677_REALK,      0.000000000000000_REALK,     23.255722714969146_REALK, &
     38.104404665968275_REALK,      0.000000000000000_REALK,     19.156906402564328_REALK, &
      0.000000000000000_REALK,     28.811210866772594_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.787138698865990_REALK, &
      0.000000000000000_REALK,     -2.489390232326576_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.849893058833797_REALK,      0.000000000000000_REALK, &
    -10.000998113308773_REALK,      0.000000000000000_REALK,     -3.334625391743143_REALK, &
      0.000000000000000_REALK,     -8.032111983532509_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -7.955757752700724_REALK,      0.000000000000000_REALK, &
    -17.673636213649417_REALK,      0.000000000000000_REALK,    -58.724370955776600_REALK, &
     -3.781850486067005_REALK,     -3.465856574538744_REALK,      0.000000000000000_REALK, &
     -4.113384600507014_REALK,      0.000000000000000_REALK,      3.202003343815401_REALK, &
     -6.886227307036044_REALK,      0.000000000000000_REALK,      3.732193135285919_REALK, &
      0.000000000000000_REALK,    -12.357154356160128_REALK,      0.000000000000000_REALK, &
      5.411996163868043_REALK,      0.000000000000000_REALK,     16.768284961407382_REALK, &
    -47.203302587185533_REALK,      0.000000000000000_REALK,     17.414062173747329_REALK, &
      0.000000000000000_REALK,     37.565705428345666_REALK,      0.000000000000000_REALK, &
     19.739542484714431_REALK,      6.795730441583091_REALK,      0.000000000000000_REALK, &
      5.306103653417965_REALK,      0.000000000000000_REALK,     12.582196388872628_REALK, &
      4.255662529891085_REALK,      0.000000000000000_REALK,      5.307372773518439_REALK, &
      0.000000000000000_REALK,      4.501663233672216_REALK,      0.000000000000000_REALK, &
      5.104701527447001_REALK,      0.000000000000000_REALK,     20.174363123476709_REALK, &
      6.047419882939757_REALK,      0.000000000000000_REALK,      7.171432816901812_REALK, &
      0.000000000000000_REALK,     14.906205168683584_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.490447280601351_REALK, &
      0.000000000000000_REALK,     -1.723779686951992_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.678457840239976_REALK,      0.000000000000000_REALK, &
     -7.951829955821585_REALK,      0.000000000000000_REALK,     -1.837760864764655_REALK, &
      0.000000000000000_REALK,     -4.837477257271380_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.087267132283237_REALK,      0.000000000000000_REALK, &
     -8.250717987242083_REALK,      0.000000000000000_REALK,    -37.010595298798165_REALK, &
     -2.870877448053566_REALK,     -1.734189850780717_REALK,      0.000000000000000_REALK, &
     -1.521114135661654_REALK,      0.000000000000000_REALK,      2.176696969679731_REALK, &
     -1.640211829686187_REALK,      0.000000000000000_REALK,      1.611031493698978_REALK, &
      0.000000000000000_REALK,     -1.921562961755797_REALK,      0.000000000000000_REALK, &
      1.740685727774032_REALK,      0.000000000000000_REALK,      9.914372711280187_REALK, &
     -3.302639782196411_REALK,      0.000000000000000_REALK,      3.287779130778585_REALK, &
      0.000000000000000_REALK,     12.853323181027838_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.040313364305124_REALK, &
      0.000000000000000_REALK,      1.822085627649267_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.434903764898047_REALK,      0.000000000000000_REALK, &
     -3.448197599473238_REALK,      0.000000000000000_REALK,      3.847198486270658_REALK, &
      0.000000000000000_REALK,     -3.793282866595189_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     11.144112491287521_REALK,      0.000000000000000_REALK, &
     -8.879170111973439_REALK,      0.000000000000000_REALK,    -37.559255638194955_REALK, &
     26.683647727038895_REALK,      5.881792544157960_REALK,      0.000000000000000_REALK, &
      4.732170849100731_REALK,      0.000000000000000_REALK,     14.655335743168331_REALK, &
      2.878773407959359_REALK,      0.000000000000000_REALK,      3.905016855107070_REALK, &
      0.000000000000000_REALK,      3.523851067548634_REALK,      0.000000000000000_REALK, &
      3.886093171918925_REALK,      0.000000000000000_REALK,     20.058447444026875_REALK, &
      5.551983355235617_REALK,      0.000000000000000_REALK,      3.811878160860506_REALK, &
      0.000000000000000_REALK,      8.617934538033269_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.917808391258619_REALK, &
      0.000000000000000_REALK,     -1.324896942500330_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.096921811793587_REALK,      0.000000000000000_REALK, &
     -7.587504393625042_REALK,      0.000000000000000_REALK,     -0.872413706518264_REALK, &
      0.000000000000000_REALK,     -3.173784567944101_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.280884143796298_REALK,      0.000000000000000_REALK, &
     -4.236915026068370_REALK,      0.000000000000000_REALK,    -27.749216000532094_REALK, &
     -3.119506607794028_REALK,     -1.351381402611268_REALK,      0.000000000000000_REALK, &
     -1.054926955322155_REALK,      0.000000000000000_REALK,      2.037982383024028_REALK, &
     -0.994268691536171_REALK,      0.000000000000000_REALK,      1.067222788259741_REALK, &
      0.000000000000000_REALK,     -1.251869376163609_REALK,      0.000000000000000_REALK, &
      1.030478949271104_REALK,      0.000000000000000_REALK,      7.923660564139535_REALK, &
     -2.618696067302996_REALK,      0.000000000000000_REALK,      1.566026960476808_REALK, &
      0.000000000000000_REALK,      6.690510597039515_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.560865875894216_REALK, &
      0.000000000000000_REALK,      0.926162978523949_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.861403372525176_REALK,      0.000000000000000_REALK, &
     -2.242490536091087_REALK,      0.000000000000000_REALK,      0.921085745396378_REALK, &
      0.000000000000000_REALK,     -1.645856748596326_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.497739517687719_REALK,      0.000000000000000_REALK, &
     -2.468254394108645_REALK,      0.000000000000000_REALK,    -19.193237004649195_REALK, &
     -6.765786477528803_REALK,     -5.300069300140432_REALK,      0.000000000000000_REALK, &
     -5.678195485022060_REALK,      0.000000000000000_REALK,     -1.811594532672374_REALK, &
     -7.722820571967636_REALK,      0.000000000000000_REALK,     -1.715484894677383_REALK, &
      0.000000000000000_REALK,    -12.664500528081970_REALK,      0.000000000000000_REALK, &
     -2.273292258351330_REALK,      0.000000000000000_REALK,      4.924595775425104_REALK, &
    -32.971879929379000_REALK,      0.000000000000000_REALK,     -4.985395452123624_REALK, &
      0.000000000000000_REALK,      7.519262053393129_REALK,      0.000000000000000_REALK, &
     40.298551224939906_REALK,      4.986879160357707_REALK,      0.000000000000000_REALK, &
      4.961569393014395_REALK,      0.000000000000000_REALK,     19.586740400365908_REALK, &
      1.627154729104622_REALK,      0.000000000000000_REALK,      2.836262443192983_REALK, &
      0.000000000000000_REALK,      2.197068870373978_REALK,      0.000000000000000_REALK, &
      3.443196742930528_REALK,      0.000000000000000_REALK,     22.654458501953954_REALK, &
      0.804663983092715_REALK,      0.000000000000000_REALK,      1.685729481813640_REALK, &
      0.000000000000000_REALK,      4.897271633249594_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.178137072193021_REALK, &
      0.000000000000000_REALK,     -1.144030665360939_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.950945780490876_REALK,      0.000000000000000_REALK, &
     -8.590801124936748_REALK,      0.000000000000000_REALK,     -0.585281779625891_REALK, &
      0.000000000000000_REALK,     -2.315916985591996_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.893344815635393_REALK,      0.000000000000000_REALK, &
     -2.873805280858392_REALK,      0.000000000000000_REALK,    -24.581757402383872_REALK, &
     -3.947370288470652_REALK,     -1.178607811066751_REALK,      0.000000000000000_REALK, &
     -0.809095660884840_REALK,      0.000000000000000_REALK,      2.282151880596178_REALK, &
     -0.537495055896083_REALK,      0.000000000000000_REALK,      0.797353355803889_REALK, &
      0.000000000000000_REALK,     -0.495159698471693_REALK,      0.000000000000000_REALK, &
      0.667892525129388_REALK,      0.000000000000000_REALK,      7.498250710119407_REALK, &
     -0.469567134482613_REALK,      0.000000000000000_REALK,      0.662365105764413_REALK, &
      0.000000000000000_REALK,      3.910952129948400_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.658284634909801_REALK, &
      0.000000000000000_REALK,      0.720030219362070_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.580714342116333_REALK,      0.000000000000000_REALK, &
     -2.040931688572881_REALK,      0.000000000000000_REALK,      0.553740271008221_REALK, &
      0.000000000000000_REALK,     -1.081297790514633_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.869371531702560_REALK,      0.000000000000000_REALK, &
     -1.301887341263622_REALK,      0.000000000000000_REALK,    -13.667012043497191_REALK, &
     -5.835080451104716_REALK,     -3.056970308038573_REALK,      0.000000000000000_REALK, &
     -2.357476400497285_REALK,      0.000000000000000_REALK,     -1.382648294771029_REALK, &
     -2.105564943727988_REALK,      0.000000000000000_REALK,     -0.847619481518804_REALK, &
      0.000000000000000_REALK,     -2.148267288079206_REALK,      0.000000000000000_REALK, &
     -0.797594706252306_REALK,      0.000000000000000_REALK,      3.176225186278771_REALK, &
     -2.606454729070574_REALK,      0.000000000000000_REALK,     -1.063456697452795_REALK, &
      0.000000000000000_REALK,      2.906810720744252_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.196100431124957_REALK, &
      0.000000000000000_REALK,      4.864983012670705_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.384898189209748_REALK,      0.000000000000000_REALK, &
      2.314789419964936_REALK,      0.000000000000000_REALK,      7.409779484220802_REALK, &
      0.000000000000000_REALK,      2.217683513283440_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     15.151703374154394_REALK,      0.000000000000000_REALK, &
      3.664476971637447_REALK,      0.000000000000000_REALK,    -11.167305260201465_REALK, &
     78.003051251309685_REALK,      3.351048149666645_REALK,      0.000000000000000_REALK, &
      6.942144239541554_REALK,      0.000000000000000_REALK,     31.081356791336376_REALK, &
      0.713556723437396_REALK,      0.000000000000000_REALK,      1.566982196489839_REALK, &
      0.000000000000000_REALK,      2.671209714923945_REALK,      0.000000000000000_REALK, &
      3.947409675527592_REALK,      0.000000000000000_REALK,     29.455560197048651_REALK, &
      0.759243422829295_REALK,      0.000000000000000_REALK,      0.570455464969048_REALK, &
      0.000000000000000_REALK,      2.087882500288377_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.453670191969717_REALK, &
      0.000000000000000_REALK,     -1.010716194106928_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.001349296640808_REALK,      0.000000000000000_REALK, &
    -11.531113524338071_REALK,      0.000000000000000_REALK,     -0.329708566453701_REALK, &
      0.000000000000000_REALK,     -1.676448998811862_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.510811506324294_REALK,      0.000000000000000_REALK, &
     -2.335185540161465_REALK,      0.000000000000000_REALK,    -25.461543281160086_REALK, &
     -6.631243743012724_REALK,     -1.243169211148057_REALK,      0.000000000000000_REALK, &
     -0.853194431894902_REALK,      0.000000000000000_REALK,      3.143021202600671_REALK, &
     -0.428546753481344_REALK,      0.000000000000000_REALK,      0.691476749332256_REALK, &
      0.000000000000000_REALK,     -0.439917174195877_REALK,      0.000000000000000_REALK, &
      0.577072691271233_REALK,      0.000000000000000_REALK,      8.461327859613869_REALK, &
     -0.499000058380891_REALK,      0.000000000000000_REALK,      0.407526067489575_REALK, &
      0.000000000000000_REALK,      2.617239513775310_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.268342124744461_REALK, &
      0.000000000000000_REALK,      0.654356645295372_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.447312693206403_REALK,      0.000000000000000_REALK, &
     -2.295322821587185_REALK,      0.000000000000000_REALK,      0.298346312816685_REALK, &
      0.000000000000000_REALK,     -0.805165037173051_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.315360367670053_REALK,      0.000000000000000_REALK, &
     -0.773849109484053_REALK,      0.000000000000000_REALK,    -11.861048887965888_REALK, &
     -7.879471916658575_REALK,     -2.903085925752829_REALK,      0.000000000000000_REALK, &
     -1.933176001956496_REALK,      0.000000000000000_REALK,     -1.530656109508616_REALK, &
     -1.504374282126849_REALK,      0.000000000000000_REALK,     -0.661813198985470_REALK, &
      0.000000000000000_REALK,     -1.588450906156913_REALK,      0.000000000000000_REALK, &
     -0.535897959622735_REALK,      0.000000000000000_REALK,      2.881064568384686_REALK, &
     -2.392208042659457_REALK,      0.000000000000000_REALK,     -0.586328875335606_REALK, &
      0.000000000000000_REALK,      1.751400464737142_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.776629747294675_REALK, &
      0.000000000000000_REALK,      2.923906068956637_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.245358533369878_REALK,      0.000000000000000_REALK, &
      1.774325921029311_REALK,      0.000000000000000_REALK,      2.013454576397612_REALK, &
      0.000000000000000_REALK,      1.092087549149548_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.357095251150394_REALK,      0.000000000000000_REALK, &
      1.179110240144877_REALK,      0.000000000000000_REALK,     -6.605481935399672_REALK, &
    -15.433082960699181_REALK,    -10.282215492182447_REALK,      0.000000000000000_REALK, &
     -9.396855461307892_REALK,      0.000000000000000_REALK,     -8.294948757917817_REALK, &
    -10.552400891954584_REALK,      0.000000000000000_REALK,     -6.485489117934466_REALK, &
      0.000000000000000_REALK,    -14.511959192895153_REALK,      0.000000000000000_REALK, &
     -7.207319163910250_REALK,      0.000000000000000_REALK,     -3.822839241938754_REALK, &
    -27.200742600431983_REALK,      0.000000000000000_REALK,    -11.379342357445482_REALK, &
      0.000000000000000_REALK,     -4.202325968352062_REALK,      0.000000000000000_REALK, &
    ! results of test 7, ket-major order, 01ODGXYZ
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.067885716059340_REALK, &
      0.000000000000000_REALK,      4.192183469263830_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.730632531910191_REALK,      0.000000000000000_REALK, &
      2.094004833829818_REALK,      0.000000000000000_REALK,     -0.314346405457756_REALK, &
      0.000000000000000_REALK,      2.359942216053388_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     18.948960967436420_REALK,      0.000000000000000_REALK, &
     -6.446278399916213_REALK,      0.000000000000000_REALK,    -30.791899575806003_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.459813547033844_REALK, &
      0.000000000000000_REALK,      2.444217720783685_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.362303396544001_REALK,      0.000000000000000_REALK, &
      0.700362521238595_REALK,      0.000000000000000_REALK,      0.239668663000081_REALK, &
      0.000000000000000_REALK,      0.230635925597001_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -12.027740229716105_REALK,      0.000000000000000_REALK, &
     -7.800724592889110_REALK,      0.000000000000000_REALK,    -25.132412942110051_REALK, &
     -7.386632844428536_REALK,     -2.256258324489818_REALK,      0.000000000000000_REALK, &
     -1.021094409441482_REALK,      0.000000000000000_REALK,     -2.926473344373186_REALK, &
      0.032583584979475_REALK,      0.000000000000000_REALK,     -0.244619872880207_REALK, &
      0.000000000000000_REALK,      0.283223516460230_REALK,      0.000000000000000_REALK, &
     -0.096350276917210_REALK,      0.000000000000000_REALK,     -0.460235792945955_REALK, &
    -32.895889095685156_REALK,      0.000000000000000_REALK,     -0.701554484717656_REALK, &
      0.000000000000000_REALK,      8.778150561510991_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.755017887901150_REALK, &
      0.000000000000000_REALK,      0.864439507230310_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.281550980808670_REALK,      0.000000000000000_REALK, &
     -0.812043682680577_REALK,      0.000000000000000_REALK,     -0.486510348103049_REALK, &
      0.000000000000000_REALK,     -0.794203105885595_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.234160915745709_REALK,      0.000000000000000_REALK, &
     -4.511173667972336_REALK,      0.000000000000000_REALK,    -21.685060777923027_REALK, &
     -6.183141821812021_REALK,     -1.554366155408915_REALK,      0.000000000000000_REALK, &
     -0.733542426349224_REALK,      0.000000000000000_REALK,     -1.417998362847326_REALK, &
      0.275844840008383_REALK,      0.000000000000000_REALK,      0.265448679022623_REALK, &
      0.000000000000000_REALK,      1.039133404365762_REALK,      0.000000000000000_REALK, &
      0.673941517518117_REALK,      0.000000000000000_REALK,      2.171308102908486_REALK, &
     11.536199417660155_REALK,      0.000000000000000_REALK,      4.419746559282952_REALK, &
      0.000000000000000_REALK,      7.088622029572809_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.861049890327094_REALK, &
      0.000000000000000_REALK,      0.495272903311005_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.110893624507690_REALK,      0.000000000000000_REALK, &
     -0.529704914619000_REALK,      0.000000000000000_REALK,      0.060610612311996_REALK, &
      0.000000000000000_REALK,     -0.758385972992821_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.222944654982682_REALK,      0.000000000000000_REALK, &
     -2.961336980536975_REALK,      0.000000000000000_REALK,    -19.803560963547650_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.239871235418842_REALK, &
      0.000000000000000_REALK,     -0.084221238783631_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.832976776037980_REALK,      0.000000000000000_REALK, &
     -2.876228824580246_REALK,      0.000000000000000_REALK,     -0.828612535505614_REALK, &
      0.000000000000000_REALK,     -1.182730288564807_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.431543197159420_REALK,      0.000000000000000_REALK, &
     -3.733959493700258_REALK,      0.000000000000000_REALK,    -21.488638168038708_REALK, &
     -4.058765148164289_REALK,     -0.481170672484992_REALK,      0.000000000000000_REALK, &
      0.063181394930447_REALK,      0.000000000000000_REALK,      0.182226509987127_REALK, &
      0.378494899899948_REALK,      0.000000000000000_REALK,      0.617873445517596_REALK, &
      0.000000000000000_REALK,      0.439418368555515_REALK,      0.000000000000000_REALK, &
      0.887264905352334_REALK,      0.000000000000000_REALK,      4.265052692447460_REALK, &
     -0.742022581898088_REALK,      0.000000000000000_REALK,      1.696667500768473_REALK, &
      0.000000000000000_REALK,      4.616203965032118_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.789296671573899_REALK, &
      0.000000000000000_REALK,     -0.059567960924601_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.524312438997513_REALK,      0.000000000000000_REALK, &
     -1.689232400228863_REALK,      0.000000000000000_REALK,     -0.869282874309317_REALK, &
      0.000000000000000_REALK,     -1.394201601858162_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.623897997287516_REALK,      0.000000000000000_REALK, &
     -3.917198865519225_REALK,      0.000000000000000_REALK,    -17.668630857199023_REALK, &
     -1.588545955436710_REALK,     -0.275682443891656_REALK,      0.000000000000000_REALK, &
      0.024885062965028_REALK,      0.000000000000000_REALK,      0.118868331806257_REALK, &
     -0.047153791752533_REALK,      0.000000000000000_REALK,      0.590008463443089_REALK, &
      0.000000000000000_REALK,     -1.027257169872297_REALK,      0.000000000000000_REALK, &
      0.582440528593859_REALK,      0.000000000000000_REALK,      3.894996277511753_REALK, &
     -9.911366918144646_REALK,      0.000000000000000_REALK,     -0.352291431252557_REALK, &
      0.000000000000000_REALK,      6.171230046136208_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.535943485317432_REALK, &
      0.000000000000000_REALK,     -0.678183415045082_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.498131997000374_REALK,      0.000000000000000_REALK, &
     -6.454569216565104_REALK,      0.000000000000000_REALK,     -0.532673131536158_REALK, &
      0.000000000000000_REALK,     -1.138395039090844_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.765211031825211_REALK,      0.000000000000000_REALK, &
     -3.367696686004227_REALK,      0.000000000000000_REALK,    -24.182372229476488_REALK, &
     -1.291243986541625_REALK,      0.354817156661246_REALK,      0.000000000000000_REALK, &
      0.722463402817547_REALK,      0.000000000000000_REALK,      2.494631451517697_REALK, &
      0.632700362383949_REALK,      0.000000000000000_REALK,      0.903092639940343_REALK, &
      0.000000000000000_REALK,      1.114503790312362_REALK,      0.000000000000000_REALK, &
      1.212723188810970_REALK,      0.000000000000000_REALK,      6.979124933282142_REALK, &
      2.636809270117481_REALK,      0.000000000000000_REALK,      1.422266474449760_REALK, &
      0.000000000000000_REALK,      3.383482560027433_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.767705308966564_REALK, &
      0.000000000000000_REALK,     -0.535898436547637_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.677485318037623_REALK,      0.000000000000000_REALK, &
     -3.256649240107788_REALK,      0.000000000000000_REALK,     -0.551047226236744_REALK, &
      0.000000000000000_REALK,     -1.499260396938036_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.754236735596287_REALK,      0.000000000000000_REALK, &
     -2.538233240840453_REALK,      0.000000000000000_REALK,    -17.081683084321060_REALK, &
     -0.455014808284967_REALK,      0.250954923349844_REALK,      0.000000000000000_REALK, &
      0.454750432082202_REALK,      0.000000000000000_REALK,      1.465117183487180_REALK, &
      0.663754850454998_REALK,      0.000000000000000_REALK,      1.064564945537159_REALK, &
      0.000000000000000_REALK,      1.176977185374094_REALK,      0.000000000000000_REALK, &
      1.272236055965243_REALK,      0.000000000000000_REALK,      5.738454954108928_REALK, &
      3.894538360527890_REALK,      0.000000000000000_REALK,      2.486791344901733_REALK, &
      0.000000000000000_REALK,      5.583825484915101_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.500782511842590_REALK, &
      0.000000000000000_REALK,     -0.511730380068616_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.444731786833965_REALK,      0.000000000000000_REALK, &
     -2.974086742197400_REALK,      0.000000000000000_REALK,      0.114417949262756_REALK, &
      0.000000000000000_REALK,     -2.004305026089056_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.938714559465351_REALK,      0.000000000000000_REALK, &
     -2.332694398482465_REALK,      0.000000000000000_REALK,    -20.056621350404530_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -18.308909176908035_REALK, &
      0.000000000000000_REALK,     -0.614118108215401_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.108265361119957_REALK,      0.000000000000000_REALK, &
    -14.459207586176028_REALK,      0.000000000000000_REALK,     -0.165861233100303_REALK, &
      0.000000000000000_REALK,     -0.552687199429100_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.798259469341218_REALK,      0.000000000000000_REALK, &
     -4.058773053373129_REALK,      0.000000000000000_REALK,    -31.468056566205291_REALK, &
     10.677009161544348_REALK,      1.330490490037490_REALK,      0.000000000000000_REALK, &
      1.832360251160503_REALK,      0.000000000000000_REALK,      7.894562090976510_REALK, &
      0.491656283373778_REALK,      0.000000000000000_REALK,      1.050736447540453_REALK, &
      0.000000000000000_REALK,      0.864374663422233_REALK,      0.000000000000000_REALK, &
      1.649067242947819_REALK,      0.000000000000000_REALK,     11.841433958744179_REALK, &
     -0.334300955670881_REALK,      0.000000000000000_REALK,      0.642004797737106_REALK, &
      0.000000000000000_REALK,      2.286752836925072_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.894079313591119_REALK, &
      0.000000000000000_REALK,     -1.104569597242155_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.119341187817213_REALK,      0.000000000000000_REALK, &
     -6.441718988159332_REALK,      0.000000000000000_REALK,     -0.696444268127012_REALK, &
      0.000000000000000_REALK,     -1.656797145661788_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.343256751871963_REALK,      0.000000000000000_REALK, &
     -2.436059625341537_REALK,      0.000000000000000_REALK,    -19.627059561377280_REALK, &
      3.232247352774196_REALK,      1.051349469236421_REALK,      0.000000000000000_REALK, &
      0.828630033937299_REALK,      0.000000000000000_REALK,      3.983196828779887_REALK, &
      0.508615537700715_REALK,      0.000000000000000_REALK,      1.383814483832311_REALK, &
      0.000000000000000_REALK,      0.369328716350487_REALK,      0.000000000000000_REALK, &
      1.242902102741808_REALK,      0.000000000000000_REALK,      8.364424309895933_REALK, &
     -0.290460234917383_REALK,      0.000000000000000_REALK,      1.106916988045666_REALK, &
      0.000000000000000_REALK,      4.216298374082619_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.874332276749388_REALK, &
      0.000000000000000_REALK,     -1.302065835912221_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.174271450572546_REALK,      0.000000000000000_REALK, &
     -5.296582966196642_REALK,      0.000000000000000_REALK,     -1.217712439474263_REALK, &
      0.000000000000000_REALK,     -2.734243774321651_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.364254784349527_REALK,      0.000000000000000_REALK, &
     -3.577848668030438_REALK,      0.000000000000000_REALK,    -20.748834852126119_REALK, &
      2.108430056837503_REALK,      1.003935497448438_REALK,      0.000000000000000_REALK, &
      0.543949965860011_REALK,      0.000000000000000_REALK,      3.637595579573347_REALK, &
     -0.105607548711057_REALK,      0.000000000000000_REALK,      1.849969712255773_REALK, &
      0.000000000000000_REALK,     -1.439006647044002_REALK,      0.000000000000000_REALK, &
      1.142255457960940_REALK,      0.000000000000000_REALK,      9.821168696876653_REALK, &
     -6.466240681500055_REALK,      0.000000000000000_REALK,     -0.321772131397374_REALK, &
      0.000000000000000_REALK,      7.247071609376399_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -78.000430982304479_REALK, &
      0.000000000000000_REALK,      3.193926481655396_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -7.782991213076687_REALK,      0.000000000000000_REALK, &
    -36.473748274838812_REALK,      0.000000000000000_REALK,      1.700682266380709_REALK, &
      0.000000000000000_REALK,      1.816115577777581_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.837301815004847_REALK,      0.000000000000000_REALK, &
     -6.222140056249091_REALK,      0.000000000000000_REALK,    -48.598446691703131_REALK, &
     60.943639785784463_REALK,      1.449279496792783_REALK,      0.000000000000000_REALK, &
      5.220238695844134_REALK,      0.000000000000000_REALK,     24.283806619844825_REALK, &
      0.203376620311991_REALK,      0.000000000000000_REALK,      0.677696967570567_REALK, &
      0.000000000000000_REALK,      2.046454737968419_REALK,      0.000000000000000_REALK, &
      2.968307777180311_REALK,      0.000000000000000_REALK,     23.013574745350528_REALK, &
      0.564553514756768_REALK,      0.000000000000000_REALK,      0.162590163743429_REALK, &
      0.000000000000000_REALK,      0.902978758953794_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -18.630662117842586_REALK, &
      0.000000000000000_REALK,     -1.764680432756908_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.022062155628151_REALK,      0.000000000000000_REALK, &
    -14.519793282380002_REALK,      0.000000000000000_REALK,     -0.469518203912973_REALK, &
      0.000000000000000_REALK,     -1.672373927064658_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.847327705422898_REALK,      0.000000000000000_REALK, &
     -2.694241324942063_REALK,      0.000000000000000_REALK,    -27.085101105802835_REALK, &
     16.290594042966703_REALK,      2.606713673882142_REALK,      0.000000000000000_REALK, &
      1.879900041864555_REALK,      0.000000000000000_REALK,     10.818674348198771_REALK, &
      0.853969784498556_REALK,      0.000000000000000_REALK,      2.031540449379632_REALK, &
      0.000000000000000_REALK,      0.982365707788925_REALK,      0.000000000000000_REALK, &
      1.781566654870438_REALK,      0.000000000000000_REALK,     14.353883001859355_REALK, &
      1.265707900191565_REALK,      0.000000000000000_REALK,      1.137848644881610_REALK, &
      0.000000000000000_REALK,      3.789618584911160_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -9.400090012678699_REALK, &
      0.000000000000000_REALK,     -2.324075031279873_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.524028395962983_REALK,      0.000000000000000_REALK, &
    -10.256334860198219_REALK,      0.000000000000000_REALK,     -0.809523040855494_REALK, &
      0.000000000000000_REALK,     -3.083510974899436_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.603408195957219_REALK,      0.000000000000000_REALK, &
     -2.842909839692000_REALK,      0.000000000000000_REALK,    -24.598390342541350_REALK, &
      9.567597348716058_REALK,      3.072792178276001_REALK,      0.000000000000000_REALK, &
      1.972153775022316_REALK,      0.000000000000000_REALK,      8.895452653992866_REALK, &
      1.493141198958651_REALK,      0.000000000000000_REALK,      3.352689760809612_REALK, &
      0.000000000000000_REALK,      1.729053527096850_REALK,      0.000000000000000_REALK, &
      2.616592720813217_REALK,      0.000000000000000_REALK,     15.174272384559925_REALK, &
      3.115727801768304_REALK,      0.000000000000000_REALK,      2.785293120399420_REALK, &
      0.000000000000000_REALK,      8.040959324941792_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.584493146472417_REALK, &
      0.000000000000000_REALK,     -3.106968793223484_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.400616950873243_REALK,      0.000000000000000_REALK, &
    -12.042573540236479_REALK,      0.000000000000000_REALK,      0.235322031448134_REALK, &
      0.000000000000000_REALK,     -5.300010307799046_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.291462897390733_REALK,      0.000000000000000_REALK, &
     -3.359184635406322_REALK,      0.000000000000000_REALK,    -35.300753857141210_REALK, &
    ! results of test 7, ket-major order, 02ODGXYZ
      0.000000000000000_REALK,      0.000000000000000_REALK,    -16.011528547131814_REALK, &
      0.000000000000000_REALK,     -7.229584580658285_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.716361114392818_REALK,      0.000000000000000_REALK, &
    -16.849449120085215_REALK,      0.000000000000000_REALK,     -9.431436993570916_REALK, &
      0.000000000000000_REALK,     -9.075980870812817_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -35.616755685617932_REALK,      0.000000000000000_REALK, &
    -23.099642716700139_REALK,      0.000000000000000_REALK,    -74.422542759748652_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -12.245459659555578_REALK, &
      0.000000000000000_REALK,     -3.306567527931295_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.835286702242366_REALK,      0.000000000000000_REALK, &
    -11.085739605872408_REALK,      0.000000000000000_REALK,     -3.867909517560193_REALK, &
      0.000000000000000_REALK,     -3.657392894485143_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -13.719972853280730_REALK,      0.000000000000000_REALK, &
     -8.153660590442447_REALK,      0.000000000000000_REALK,    -39.279704994614512_REALK, &
     12.166900456561846_REALK,      5.375049578492629_REALK,      0.000000000000000_REALK, &
      4.480050886668021_REALK,      0.000000000000000_REALK,      8.660310016947232_REALK, &
      5.056573818058451_REALK,      0.000000000000000_REALK,      4.865999452239924_REALK, &
      0.000000000000000_REALK,      7.640578848533582_REALK,      0.000000000000000_REALK, &
      4.955382323639616_REALK,      0.000000000000000_REALK,     15.965275194726264_REALK, &
     28.059280760137138_REALK,      0.000000000000000_REALK,     10.750066387177968_REALK, &
      0.000000000000000_REALK,     17.241521971767295_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -10.565351146895374_REALK, &
      0.000000000000000_REALK,     -0.324469452725655_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.791219416875315_REALK,      0.000000000000000_REALK, &
     -8.251395122528075_REALK,      0.000000000000000_REALK,      1.041689443528509_REALK, &
      0.000000000000000_REALK,     -0.312153666630996_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.586330438300499_REALK,      0.000000000000000_REALK, &
     -1.333323977569898_REALK,      0.000000000000000_REALK,    -23.174740850686408_REALK, &
     10.602097130531702_REALK,      2.630839170052459_REALK,      0.000000000000000_REALK, &
      2.337998979039831_REALK,      0.000000000000000_REALK,      6.757890580977282_REALK, &
      2.172913493823348_REALK,      0.000000000000000_REALK,      2.054649504224532_REALK, &
      0.000000000000000_REALK,      3.784770624880028_REALK,      0.000000000000000_REALK, &
      2.249256278999803_REALK,      0.000000000000000_REALK,     10.835639050263977_REALK, &
     11.422140323155602_REALK,      0.000000000000000_REALK,      3.661686759333419_REALK, &
      0.000000000000000_REALK,      5.770656851638706_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.890493729501073_REALK, &
      0.000000000000000_REALK,     -2.966323676582962_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.783833765812142_REALK,      0.000000000000000_REALK, &
     -8.968969347842044_REALK,      0.000000000000000_REALK,     -2.965496791633400_REALK, &
      0.000000000000000_REALK,     -4.756219752385630_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -7.233211189740041_REALK,      0.000000000000000_REALK, &
     -7.818632502272020_REALK,      0.000000000000000_REALK,    -35.266152225955864_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -10.940818493601155_REALK, &
      0.000000000000000_REALK,      1.627769979360108_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.476161602674763_REALK,      0.000000000000000_REALK, &
     -7.263785709105802_REALK,      0.000000000000000_REALK,      1.172888831303114_REALK, &
      0.000000000000000_REALK,      1.336736564244719_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.470576243684009_REALK,      0.000000000000000_REALK, &
     -0.630501174304960_REALK,      0.000000000000000_REALK,    -16.030360959263785_REALK, &
     10.784549461875073_REALK,      0.290524819097300_REALK,      0.000000000000000_REALK, &
      0.567965731080430_REALK,      0.000000000000000_REALK,      5.923147945115049_REALK, &
     -0.643674452235708_REALK,      0.000000000000000_REALK,      0.192884109203873_REALK, &
      0.000000000000000_REALK,     -0.904738866748660_REALK,      0.000000000000000_REALK, &
      0.466417595606261_REALK,      0.000000000000000_REALK,      8.106887064369683_REALK, &
     -3.973636061190868_REALK,      0.000000000000000_REALK,     -0.852310425126653_REALK, &
      0.000000000000000_REALK,      0.425673611209102_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.050908404551131_REALK, &
      0.000000000000000_REALK,     -1.474901251020268_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.389846861094068_REALK,      0.000000000000000_REALK, &
     -6.695492666871426_REALK,      0.000000000000000_REALK,     -1.280915338569346_REALK, &
      0.000000000000000_REALK,     -2.018666084979349_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.096699770107713_REALK,      0.000000000000000_REALK, &
     -3.067236253061267_REALK,      0.000000000000000_REALK,    -20.686682670402135_REALK, &
      7.033450134251392_REALK,      2.655999331474703_REALK,      0.000000000000000_REALK, &
      1.998335918309550_REALK,      0.000000000000000_REALK,      6.438248511143179_REALK, &
      1.832421874695841_REALK,      0.000000000000000_REALK,      2.938934595957329_REALK, &
      0.000000000000000_REALK,      2.530290483322526_REALK,      0.000000000000000_REALK, &
      2.735080021050248_REALK,      0.000000000000000_REALK,     12.336652009734374_REALK, &
      6.333188061558516_REALK,      0.000000000000000_REALK,      4.043949705757667_REALK, &
      0.000000000000000_REALK,      9.080258974287556_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -12.608794739683360_REALK, &
      0.000000000000000_REALK,      4.311951728868241_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.308026111522882_REALK,      0.000000000000000_REALK, &
     -7.171188597946288_REALK,      0.000000000000000_REALK,      2.420992081006871_REALK, &
      0.000000000000000_REALK,      2.992379421200149_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.918353362040543_REALK,      0.000000000000000_REALK, &
     -0.319114518167714_REALK,      0.000000000000000_REALK,    -12.382231616714932_REALK, &
     12.590058059775433_REALK,     -1.653840015150452_REALK,      0.000000000000000_REALK, &
      0.401136161988703_REALK,      0.000000000000000_REALK,      6.119281992692116_REALK, &
     -0.825319465516664_REALK,      0.000000000000000_REALK,     -0.940613191374077_REALK, &
      0.000000000000000_REALK,      0.207768011304524_REALK,      0.000000000000000_REALK, &
      0.278377790780432_REALK,      0.000000000000000_REALK,      7.077697316221533_REALK, &
      0.304339127160110_REALK,      0.000000000000000_REALK,     -0.855029537173574_REALK, &
      0.000000000000000_REALK,     -1.624122729203734_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.018011888349432_REALK, &
      0.000000000000000_REALK,     -0.162492714322243_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.328201198988009_REALK,      0.000000000000000_REALK, &
     -5.704523327701823_REALK,      0.000000000000000_REALK,      0.376310628552658_REALK, &
      0.000000000000000_REALK,     -0.187942678477238_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.659549680969834_REALK,      0.000000000000000_REALK, &
     -0.566693123078216_REALK,      0.000000000000000_REALK,    -13.789711342621837_REALK, &
      6.963033722955668_REALK,      1.498522972079674_REALK,      0.000000000000000_REALK, &
      1.170858449063411_REALK,      0.000000000000000_REALK,      5.640530895236471_REALK, &
      0.901333813048257_REALK,      0.000000000000000_REALK,      1.420462340374362_REALK, &
      0.000000000000000_REALK,      1.367249540277463_REALK,      0.000000000000000_REALK, &
      1.354240859059616_REALK,      0.000000000000000_REALK,      9.133548445346795_REALK, &
      2.912802206001279_REALK,      0.000000000000000_REALK,      1.556300449319732_REALK, &
      0.000000000000000_REALK,      3.433725224981912_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.541362201185927_REALK, &
      0.000000000000000_REALK,     -2.475867305418552_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.924576925684042_REALK,      0.000000000000000_REALK, &
     -8.680855995215593_REALK,      0.000000000000000_REALK,     -1.785477697733040_REALK, &
      0.000000000000000_REALK,     -4.009100277668550_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.074279850924824_REALK,      0.000000000000000_REALK, &
     -4.652336179076577_REALK,      0.000000000000000_REALK,    -26.980055338497646_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -17.241942791768444_REALK, &
      0.000000000000000_REALK,      8.948918685128758_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.188623346483138_REALK,      0.000000000000000_REALK, &
     -8.062497517466332_REALK,      0.000000000000000_REALK,      3.231879390092568_REALK, &
      0.000000000000000_REALK,      5.088492400082965_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.073988838911178_REALK,      0.000000000000000_REALK, &
     -0.950249169434943_REALK,      0.000000000000000_REALK,    -10.742653945300006_REALK, &
     18.442010610577192_REALK,     -5.351551561980869_REALK,      0.000000000000000_REALK, &
      0.315640726301125_REALK,      0.000000000000000_REALK,      7.348465252855563_REALK, &
     -2.024602728498762_REALK,      0.000000000000000_REALK,     -2.502436744173792_REALK, &
      0.000000000000000_REALK,     -0.516505392077359_REALK,      0.000000000000000_REALK, &
      0.179478157468232_REALK,      0.000000000000000_REALK,      6.964083391357665_REALK, &
     -2.737637165103519_REALK,      0.000000000000000_REALK,     -1.618575864998761_REALK, &
      0.000000000000000_REALK,     -3.334303285604026_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -7.594624236386844_REALK, &
      0.000000000000000_REALK,      0.963865788604344_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.232798958405978_REALK,      0.000000000000000_REALK, &
     -5.918865001801636_REALK,      0.000000000000000_REALK,      0.480890455232049_REALK, &
      0.000000000000000_REALK,      0.913448114530985_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.138905158449107_REALK,      0.000000000000000_REALK, &
     -0.310186594608419_REALK,      0.000000000000000_REALK,    -11.041001334360434_REALK, &
      8.802129100430342_REALK,      0.201669265757284_REALK,      0.000000000000000_REALK, &
      0.336314555637208_REALK,      0.000000000000000_REALK,      5.845543020542773_REALK, &
     -0.314697239742286_REALK,      0.000000000000000_REALK,      0.157170798959463_REALK, &
      0.000000000000000_REALK,     -0.370947590159507_REALK,      0.000000000000000_REALK, &
      0.318722689785432_REALK,      0.000000000000000_REALK,      7.755685946233907_REALK, &
     -1.172941800839062_REALK,      0.000000000000000_REALK,     -0.419309715974323_REALK, &
      0.000000000000000_REALK,      0.293185095538707_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -7.000447551560811_REALK, &
      0.000000000000000_REALK,     -1.455577134621760_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.132510824717904_REALK,      0.000000000000000_REALK, &
     -7.638111354595657_REALK,      0.000000000000000_REALK,     -0.875303131661613_REALK, &
      0.000000000000000_REALK,     -1.931214788253700_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.523478139867483_REALK,      0.000000000000000_REALK, &
     -2.112576232619247_REALK,      0.000000000000000_REALK,    -18.318946011529711_REALK, &
      9.567597348716056_REALK,      3.072792178276002_REALK,      0.000000000000000_REALK, &
      1.972153775022316_REALK,      0.000000000000000_REALK,      8.895452653992866_REALK, &
      1.493141198958651_REALK,      0.000000000000000_REALK,      3.352689760809612_REALK, &
      0.000000000000000_REALK,      1.729053527096850_REALK,      0.000000000000000_REALK, &
      2.616592720813217_REALK,      0.000000000000000_REALK,     15.174272384559922_REALK, &
      3.115727801768305_REALK,      0.000000000000000_REALK,      2.785293120399421_REALK, &
      0.000000000000000_REALK,      8.040959324941793_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -25.390323564714393_REALK, &
      0.000000000000000_REALK,     19.189769441568888_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.402301021181652_REALK,      0.000000000000000_REALK, &
    -10.042512684508445_REALK,      0.000000000000000_REALK,      5.929900704922681_REALK, &
      0.000000000000000_REALK,      8.932224427282900_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.034986280353627_REALK,      0.000000000000000_REALK, &
     -2.088138047393844_REALK,      0.000000000000000_REALK,    -10.272534527566213_REALK, &
     28.673164780926797_REALK,    -13.197299828872080_REALK,      0.000000000000000_REALK, &
      1.488722174389328_REALK,      0.000000000000000_REALK,     10.098084368546692_REALK, &
     -3.315318460702058_REALK,      0.000000000000000_REALK,     -5.219864591126956_REALK, &
      0.000000000000000_REALK,      0.783187588134927_REALK,      0.000000000000000_REALK, &
      0.692952597060015_REALK,      0.000000000000000_REALK,      7.833892614859375_REALK, &
     -1.437371349645452_REALK,      0.000000000000000_REALK,     -2.034753119703322_REALK, &
      0.000000000000000_REALK,     -5.339424596823057_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -10.837052233488675_REALK, &
      0.000000000000000_REALK,      3.134241879129208_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.184111836156787_REALK,      0.000000000000000_REALK, &
     -7.143878667011570_REALK,      0.000000000000000_REALK,      1.180318157874843_REALK, &
      0.000000000000000_REALK,      2.431482389528398_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.325185698790230_REALK,      0.000000000000000_REALK, &
     -0.188328882747812_REALK,      0.000000000000000_REALK,    -10.230510988863829_REALK, &
     12.629778140958861_REALK,     -1.421448362039815_REALK,      0.000000000000000_REALK, &
      0.291575100370649_REALK,      0.000000000000000_REALK,      7.413236162212659_REALK, &
     -0.493305848198922_REALK,      0.000000000000000_REALK,     -0.937031068139991_REALK, &
      0.000000000000000_REALK,      0.101294158825289_REALK,      0.000000000000000_REALK, &
      0.226198152254025_REALK,      0.000000000000000_REALK,      8.051457233409302_REALK, &
      0.107765415607418_REALK,      0.000000000000000_REALK,     -0.504604924830304_REALK, &
      0.000000000000000_REALK,     -1.341891021159118_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.620637489183256_REALK, &
      0.000000000000000_REALK,     -0.196852648292449_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.326951315240757_REALK,      0.000000000000000_REALK, &
     -7.955918426838421_REALK,      0.000000000000000_REALK,      0.305774281107432_REALK, &
      0.000000000000000_REALK,     -0.213800106232816_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.389240374417700_REALK,      0.000000000000000_REALK, &
     -0.468216102107075_REALK,      0.000000000000000_REALK,    -14.648665005490797_REALK, &
     11.641668726680132_REALK,      2.146593185786387_REALK,      0.000000000000000_REALK, &
      1.418442589472902_REALK,      0.000000000000000_REALK,      9.566550899143703_REALK, &
      0.897901276886745_REALK,      0.000000000000000_REALK,      1.981073940663028_REALK, &
      0.000000000000000_REALK,      1.110969804070541_REALK,      0.000000000000000_REALK, &
      1.540559291150208_REALK,      0.000000000000000_REALK,     13.358771175396221_REALK, &
      1.719021711300769_REALK,      0.000000000000000_REALK,      1.285854548807362_REALK, &
      0.000000000000000_REALK,      3.647610112489860_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -13.118451504466947_REALK, &
      0.000000000000000_REALK,     -4.199163347693951_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.684146623182686_REALK,      0.000000000000000_REALK, &
    -15.566034276672692_REALK,      0.000000000000000_REALK,     -2.031126322901049_REALK, &
      0.000000000000000_REALK,     -5.863729036864829_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.540047284794152_REALK,      0.000000000000000_REALK, &
     -4.942127683962117_REALK,      0.000000000000000_REALK,    -35.029656928822455_REALK, &
    ! results of test 7, ket-major order, 03ODGXYZ
     10.784521402450762_REALK,      5.592443854491836_REALK,      0.000000000000000_REALK, &
      3.020225381365621_REALK,      0.000000000000000_REALK,      8.656015536702791_REALK, &
     -0.783901823145392_REALK,      0.000000000000000_REALK,      5.885109463835231_REALK, &
      0.000000000000000_REALK,    -11.145406817708782_REALK,      0.000000000000000_REALK, &
      3.791574395595739_REALK,      0.000000000000000_REALK,     18.111190795746403_REALK, &
    -97.411884743528105_REALK,      0.000000000000000_REALK,     -2.077455465874166_REALK, &
      0.000000000000000_REALK,     25.994013667543808_REALK,      0.000000000000000_REALK, &
     12.166900456561850_REALK,      5.375049578492629_REALK,      0.000000000000000_REALK, &
      4.480050886668021_REALK,      0.000000000000000_REALK,      8.660310016947234_REALK, &
      5.056573818058451_REALK,      0.000000000000000_REALK,      4.865999452239923_REALK, &
      0.000000000000000_REALK,      7.640578848533583_REALK,      0.000000000000000_REALK, &
      4.955382323639616_REALK,      0.000000000000000_REALK,     15.965275194726267_REALK, &
     28.059280760137138_REALK,      0.000000000000000_REALK,     10.750066387177966_REALK, &
      0.000000000000000_REALK,     17.241521971767295_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.238022601432425_REALK, &
      0.000000000000000_REALK,     -1.051912429864037_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.706928311690696_REALK,      0.000000000000000_REALK, &
     -5.910124131754192_REALK,      0.000000000000000_REALK,      0.154981884230559_REALK, &
      0.000000000000000_REALK,     -3.394035344005206_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.417804701668148_REALK,      0.000000000000000_REALK, &
     -4.384021979780318_REALK,      0.000000000000000_REALK,    -34.703368401395977_REALK, &
     14.236327979907562_REALK,      4.200579605848790_REALK,      0.000000000000000_REALK, &
      3.146262937201251_REALK,      0.000000000000000_REALK,      9.074388357192477_REALK, &
      2.009616412198375_REALK,      0.000000000000000_REALK,      3.280595371567620_REALK, &
      0.000000000000000_REALK,      1.499044558046225_REALK,      0.000000000000000_REALK, &
      3.026841213502393_REALK,      0.000000000000000_REALK,     14.549924368002449_REALK, &
     -1.481058806412982_REALK,      0.000000000000000_REALK,      3.386506563102117_REALK, &
      0.000000000000000_REALK,      9.213829472845269_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.396225310667942_REALK, &
      0.000000000000000_REALK,     -1.031563216294568_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.968100863624778_REALK,      0.000000000000000_REALK, &
     -5.459007019577283_REALK,      0.000000000000000_REALK,     -1.031275660319200_REALK, &
      0.000000000000000_REALK,     -2.894896393103666_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.515408098559677_REALK,      0.000000000000000_REALK, &
     -4.758848877509815_REALK,      0.000000000000000_REALK,    -25.408126262428155_REALK, &
     -1.696554873105243_REALK,     -0.732796263153723_REALK,      0.000000000000000_REALK, &
     -0.377318946926442_REALK,      0.000000000000000_REALK,      1.286326538838258_REALK, &
      0.076231387349071_REALK,      0.000000000000000_REALK,      0.680754680852327_REALK, &
      0.000000000000000_REALK,      1.067037251619981_REALK,      0.000000000000000_REALK, &
      0.431784630972412_REALK,      0.000000000000000_REALK,      5.858932553358565_REALK, &
      6.023553887798971_REALK,      0.000000000000000_REALK,     -0.152804631633784_REALK, &
      0.000000000000000_REALK,      5.431278006801872_REALK,      0.000000000000000_REALK, &
     19.959570601062008_REALK,      3.755232686048072_REALK,      0.000000000000000_REALK, &
      3.174762387589053_REALK,      0.000000000000000_REALK,     10.962302135012330_REALK, &
      1.746690036789326_REALK,      0.000000000000000_REALK,      2.493159495812522_REALK, &
      0.000000000000000_REALK,      2.395983855335250_REALK,      0.000000000000000_REALK, &
      2.607137998667010_REALK,      0.000000000000000_REALK,     15.003870610278575_REALK, &
      4.287904610047625_REALK,      0.000000000000000_REALK,      2.312849488820854_REALK, &
      0.000000000000000_REALK,      5.502123582306344_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.825557140626828_REALK, &
      0.000000000000000_REALK,     -0.818945825523627_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.650421602531395_REALK,      0.000000000000000_REALK, &
     -5.472173490357267_REALK,      0.000000000000000_REALK,     -0.411972728225420_REALK, &
      0.000000000000000_REALK,     -1.961780980582558_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.426531774052592_REALK,      0.000000000000000_REALK, &
     -2.512285772254575_REALK,      0.000000000000000_REALK,    -20.012973475691350_REALK, &
     -2.141571004935541_REALK,     -0.808708535476069_REALK,      0.000000000000000_REALK, &
     -0.608460738199073_REALK,      0.000000000000000_REALK,      1.399094321245901_REALK, &
     -0.557942614329193_REALK,      0.000000000000000_REALK,      0.638659209348679_REALK, &
      0.000000000000000_REALK,     -0.770432238761384_REALK,      0.000000000000000_REALK, &
      0.594359617989499_REALK,      0.000000000000000_REALK,      5.439668463825486_REALK, &
     -1.928352609679975_REALK,      0.000000000000000_REALK,      0.878789791810159_REALK, &
      0.000000000000000_REALK,      4.003809003190313_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.922399042079415_REALK, &
      0.000000000000000_REALK,      0.391357825919770_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.213674835950891_REALK,      0.000000000000000_REALK, &
     -1.325207472536710_REALK,      0.000000000000000_REALK,     -0.042808887832770_REALK, &
      0.000000000000000_REALK,     -0.695470380313182_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.831689562300816_REALK,      0.000000000000000_REALK, &
     -0.612261188623122_REALK,      0.000000000000000_REALK,    -11.342309227786235_REALK, &
     30.885151187847285_REALK,      3.027910263183331_REALK,      0.000000000000000_REALK, &
      3.484217704259508_REALK,      0.000000000000000_REALK,     15.011443839897469_REALK, &
      0.805802046781763_REALK,      0.000000000000000_REALK,      1.722108734675947_REALK, &
      0.000000000000000_REALK,      1.267394200795235_REALK,      0.000000000000000_REALK, &
      2.417954098930490_REALK,      0.000000000000000_REALK,     17.362568991776524_REALK, &
     -0.434697097354785_REALK,      0.000000000000000_REALK,      0.834809525160070_REALK, &
      0.000000000000000_REALK,      2.973502778609418_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.873285749072587_REALK, &
      0.000000000000000_REALK,     -0.730406813254879_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.637979268460407_REALK,      0.000000000000000_REALK, &
     -6.425984307951493_REALK,      0.000000000000000_REALK,     -0.355118555131972_REALK, &
      0.000000000000000_REALK,     -1.478598079952178_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.607414931698246_REALK,      0.000000000000000_REALK, &
     -1.928004969782062_REALK,      0.000000000000000_REALK,    -18.387340718558693_REALK, &
     -2.846877435397836_REALK,     -0.728521529365983_REALK,      0.000000000000000_REALK, &
     -0.479754610306668_REALK,      0.000000000000000_REALK,      1.645907583587034_REALK, &
     -0.253816856533475_REALK,      0.000000000000000_REALK,      0.492860373706151_REALK, &
      0.000000000000000_REALK,     -0.164887156774786_REALK,      0.000000000000000_REALK, &
      0.396027977420821_REALK,      0.000000000000000_REALK,      5.407802965418056_REALK, &
      0.115000537946690_REALK,      0.000000000000000_REALK,      0.312783210149359_REALK, &
      0.000000000000000_REALK,      2.417439287466074_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.138428199889046_REALK, &
      0.000000000000000_REALK,      0.430888410239809_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.334944401130587_REALK,      0.000000000000000_REALK, &
     -1.401119047602413_REALK,      0.000000000000000_REALK,      0.310736219591044_REALK, &
      0.000000000000000_REALK,     -0.647082127141083_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.535033341527702_REALK,      0.000000000000000_REALK, &
     -0.750902542323781_REALK,      0.000000000000000_REALK,     -9.382533969740798_REALK, &
     -3.448260802980162_REALK,     -1.291748084729053_REALK,      0.000000000000000_REALK, &
     -0.584782227700916_REALK,      0.000000000000000_REALK,     -0.817080751348279_REALK, &
      0.097859394688467_REALK,      0.000000000000000_REALK,     -0.358168621707506_REALK, &
      0.000000000000000_REALK,      1.192925378163311_REALK,      0.000000000000000_REALK, &
     -0.197846820025980_REALK,      0.000000000000000_REALK,      1.877001166146713_REALK, &
      4.753809543898777_REALK,      0.000000000000000_REALK,      0.049425798525059_REALK, &
      0.000000000000000_REALK,      1.228296909301838_REALK,      0.000000000000000_REALK, &
     60.943639785784463_REALK,      1.449279496792783_REALK,      0.000000000000000_REALK, &
      5.220238695844135_REALK,      0.000000000000000_REALK,     24.283806619844825_REALK, &
      0.203376620311991_REALK,      0.000000000000000_REALK,      0.677696967570567_REALK, &
      0.000000000000000_REALK,      2.046454737968419_REALK,      0.000000000000000_REALK, &
      2.968307777180310_REALK,      0.000000000000000_REALK,     23.013574745350528_REALK, &
      0.564553514756768_REALK,      0.000000000000000_REALK,      0.162590163743429_REALK, &
      0.000000000000000_REALK,      0.902978758953795_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.478964479735379_REALK, &
      0.000000000000000_REALK,     -0.613681992062235_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.703188582309441_REALK,      0.000000000000000_REALK, &
     -8.837543130905507_REALK,      0.000000000000000_REALK,     -0.163278779170601_REALK, &
      0.000000000000000_REALK,     -1.017898562603581_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.294665110204165_REALK,      0.000000000000000_REALK, &
     -1.639863147579234_REALK,      0.000000000000000_REALK,    -19.513942556522217_REALK, &
     -4.960220544636931_REALK,     -0.793701855504683_REALK,      0.000000000000000_REALK, &
     -0.572398942906950_REALK,      0.000000000000000_REALK,      2.351003664704141_REALK, &
     -0.260019889906821_REALK,      0.000000000000000_REALK,      0.441473593507453_REALK, &
      0.000000000000000_REALK,     -0.299114357233964_REALK,      0.000000000000000_REALK, &
      0.387151845014398_REALK,      0.000000000000000_REALK,      6.329137324862923_REALK, &
     -0.385387439738578_REALK,      0.000000000000000_REALK,      0.247265630510515_REALK, &
      0.000000000000000_REALK,      1.670977562632251_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.635947868777041_REALK, &
      0.000000000000000_REALK,      0.404471190081380_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.265234801259190_REALK,      0.000000000000000_REALK, &
     -1.655406579619854_REALK,      0.000000000000000_REALK,      0.140885618289528_REALK, &
      0.000000000000000_REALK,     -0.497688933303793_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.105014351016572_REALK,      0.000000000000000_REALK, &
     -0.458855109358355_REALK,      0.000000000000000_REALK,     -8.554290571098948_REALK, &
     -5.409332536356663_REALK,     -1.737296637973715_REALK,      0.000000000000000_REALK, &
     -1.115017197432379_REALK,      0.000000000000000_REALK,     -1.050810001319132_REALK, &
     -0.844192849523034_REALK,      0.000000000000000_REALK,     -0.396049540030727_REALK, &
      0.000000000000000_REALK,     -0.977573068800014_REALK,      0.000000000000000_REALK, &
     -0.309095209356793_REALK,      0.000000000000000_REALK,      1.977878273309030_REALK, &
     -1.761571600292949_REALK,      0.000000000000000_REALK,     -0.329023601312446_REALK, &
      0.000000000000000_REALK,      1.048092346196885_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.413719159117028_REALK, &
      0.000000000000000_REALK,      1.235520690067080_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.556970905352149_REALK,      0.000000000000000_REALK, &
      1.048543987776329_REALK,      0.000000000000000_REALK,     -0.093578422582461_REALK, &
      0.000000000000000_REALK,      0.461470625429632_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.308886822160583_REALK,      0.000000000000000_REALK, &
      0.292483399957444_REALK,      0.000000000000000_REALK,     -3.903532202082989_REALK, &
    129.713874912441497_REALK,     -4.710200963142877_REALK,      0.000000000000000_REALK, &
      9.748009439884351_REALK,      0.000000000000000_REALK,     45.682493113151487_REALK, &
     -1.744589643662131_REALK,      0.000000000000000_REALK,     -1.863003155449481_REALK, &
      0.000000000000000_REALK,      2.798285274999934_REALK,      0.000000000000000_REALK, &
      4.537386876973372_REALK,      0.000000000000000_REALK,     35.439567780021072_REALK, &
     -1.939352058064970_REALK,      0.000000000000000_REALK,     -1.070729482588503_REALK, &
      0.000000000000000_REALK,     -1.905674888401333_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -12.453992412639222_REALK, &
      0.000000000000000_REALK,     -0.295176822005330_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.058903408326637_REALK,      0.000000000000000_REALK, &
    -14.368958934409960_REALK,      0.000000000000000_REALK,     -0.041232304252168_REALK, &
      0.000000000000000_REALK,     -0.400787968262409_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.448059851896664_REALK,      0.000000000000000_REALK, &
     -1.895768795715327_REALK,      0.000000000000000_REALK,    -24.357460567079830_REALK, &
     -9.433694020019409_REALK,     -0.792400347471141_REALK,      0.000000000000000_REALK, &
     -0.771130654017651_REALK,      0.000000000000000_REALK,      3.951928623202887_REALK, &
     -0.146651533120609_REALK,      0.000000000000000_REALK,      0.372805879310587_REALK, &
      0.000000000000000_REALK,     -0.188140156315115_REALK,      0.000000000000000_REALK, &
      0.426954680625837_REALK,      0.000000000000000_REALK,      8.709066485020967_REALK, &
      0.046867568537657_REALK,      0.000000000000000_REALK,      0.107062411302136_REALK, &
      0.000000000000000_REALK,      1.083282851248859_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.776681188368546_REALK, &
      0.000000000000000_REALK,      0.442825195251873_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.318060421677896_REALK,      0.000000000000000_REALK, &
     -2.376577571022487_REALK,      0.000000000000000_REALK,      0.144406909199035_REALK, &
      0.000000000000000_REALK,     -0.446040213425330_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.179397327646770_REALK,      0.000000000000000_REALK, &
     -0.422423357483723_REALK,      0.000000000000000_REALK,     -9.428107896986480_REALK, &
     -8.838167613863419_REALK,     -1.937784407764118_REALK,      0.000000000000000_REALK, &
     -1.079203264592475_REALK,      0.000000000000000_REALK,     -1.517461697604260_REALK, &
     -0.469504881103900_REALK,      0.000000000000000_REALK,     -0.373655819468458_REALK, &
      0.000000000000000_REALK,     -0.248781466430046_REALK,      0.000000000000000_REALK, &
     -0.244898012107943_REALK,      0.000000000000000_REALK,      2.338107102862831_REALK, &
      0.126022173024948_REALK,      0.000000000000000_REALK,     -0.140481366366470_REALK, &
      0.000000000000000_REALK,      0.759128008818129_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.216698117715750_REALK, &
      0.000000000000000_REALK,      1.669843999837701_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.067380752374796_REALK,      0.000000000000000_REALK, &
      1.355330868422075_REALK,      0.000000000000000_REALK,      0.807699968392829_REALK, &
      0.000000000000000_REALK,      0.510553479869666_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.010078048082328_REALK,      0.000000000000000_REALK, &
      0.430309871268569_REALK,      0.000000000000000_REALK,     -3.873554496964831_REALK, &
     -9.667557634380412_REALK,     -3.102873666812465_REALK,      0.000000000000000_REALK, &
     -1.187959021199553_REALK,      0.000000000000000_REALK,     -4.592538159270092_REALK, &
      0.163472753013863_REALK,      0.000000000000000_REALK,     -1.655430248957568_REALK, &
      0.000000000000000_REALK,      1.625427760912167_REALK,      0.000000000000000_REALK, &
     -0.745871424186760_REALK,      0.000000000000000_REALK,     -1.732592390590054_REALK, &
      4.704484816950140_REALK,      0.000000000000000_REALK,      0.135333242390920_REALK, &
      0.000000000000000_REALK,     -0.823476324236624_REALK,      0.000000000000000_REALK, &
    ! results of test 7, ket-major order, 01ODGYYZ
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.998064317036707_REALK, &
      0.000000000000000_REALK,      3.137310239753754_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.781604970658339_REALK,      0.000000000000000_REALK, &
      3.074146153632565_REALK,      0.000000000000000_REALK,      2.252901792300253_REALK, &
      0.000000000000000_REALK,      1.498780083894346_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -9.846488994287256_REALK,      0.000000000000000_REALK, &
     -3.878027193271501_REALK,      0.000000000000000_REALK,    -11.152511898183580_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.386274340100869_REALK, &
      0.000000000000000_REALK,      1.512949743655797_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.566816223056577_REALK,      0.000000000000000_REALK, &
      1.988169235116176_REALK,      0.000000000000000_REALK,      0.106690255508436_REALK, &
      0.000000000000000_REALK,      0.294442312571555_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.333747310698616_REALK,      0.000000000000000_REALK, &
     -1.749251199640413_REALK,      0.000000000000000_REALK,    -10.226146436143891_REALK, &
     -7.864134195027304_REALK,     -2.354764094197106_REALK,      0.000000000000000_REALK, &
     -1.666190676184776_REALK,      0.000000000000000_REALK,     -2.874999645134100_REALK, &
     -0.952751557026076_REALK,      0.000000000000000_REALK,     -0.633833691042535_REALK, &
      0.000000000000000_REALK,     -0.823324364403273_REALK,      0.000000000000000_REALK, &
     -0.324265255959897_REALK,      0.000000000000000_REALK,     -0.932528820719673_REALK, &
     12.240697443717227_REALK,      0.000000000000000_REALK,      2.940285997990540_REALK, &
      0.000000000000000_REALK,      3.260122944405080_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.195214119330624_REALK, &
      0.000000000000000_REALK,      0.835658725428498_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.257831656590142_REALK,      0.000000000000000_REALK, &
      0.950434267072264_REALK,      0.000000000000000_REALK,     -0.112810666392669_REALK, &
      0.000000000000000_REALK,     -0.150817603242199_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.932974463859586_REALK,      0.000000000000000_REALK, &
     -1.768774534338668_REALK,      0.000000000000000_REALK,    -10.866935105338879_REALK, &
     -7.461650135719989_REALK,     -1.286886280855679_REALK,      0.000000000000000_REALK, &
     -0.582616795753806_REALK,      0.000000000000000_REALK,     -2.043591453563710_REALK, &
     -0.061594661057617_REALK,      0.000000000000000_REALK,     -0.169988105825015_REALK, &
      0.000000000000000_REALK,     -0.020061882268550_REALK,      0.000000000000000_REALK, &
      0.105149226676455_REALK,      0.000000000000000_REALK,      0.614703817188611_REALK, &
     -2.351067108613245_REALK,      0.000000000000000_REALK,      0.422551169126300_REALK, &
      0.000000000000000_REALK,      1.943584926046726_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.445420025550922_REALK, &
      0.000000000000000_REALK,      0.651502443110471_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.187205555356760_REALK,      0.000000000000000_REALK, &
      0.538369660518306_REALK,      0.000000000000000_REALK,     -0.176743511143436_REALK, &
      0.000000000000000_REALK,     -0.195969227601405_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.260810193872512_REALK,      0.000000000000000_REALK, &
     -2.140443260413467_REALK,      0.000000000000000_REALK,     -8.617744238305427_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.423524085531795_REALK, &
      0.000000000000000_REALK,      0.277514703265117_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.128265607971216_REALK,      0.000000000000000_REALK, &
     -0.596243320109437_REALK,      0.000000000000000_REALK,     -0.086394142642714_REALK, &
      0.000000000000000_REALK,     -0.284032481253166_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.607786121637989_REALK,      0.000000000000000_REALK, &
     -1.655259478733818_REALK,      0.000000000000000_REALK,    -12.824136608055106_REALK, &
     -9.021330914018488_REALK,     -0.874454243912517_REALK,      0.000000000000000_REALK, &
     -0.357174984093760_REALK,      0.000000000000000_REALK,     -1.316639503128721_REALK, &
      0.052534986418170_REALK,      0.000000000000000_REALK,      0.070234499904210_REALK, &
      0.000000000000000_REALK,      0.399499908081408_REALK,      0.000000000000000_REALK, &
      0.365563682861132_REALK,      0.000000000000000_REALK,      2.245937365898315_REALK, &
      1.942032879604480_REALK,      0.000000000000000_REALK,      0.677960644394580_REALK, &
      0.000000000000000_REALK,      1.510619559150297_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.138465338797016_REALK, &
      0.000000000000000_REALK,      0.235485043990132_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.048967117844165_REALK,      0.000000000000000_REALK, &
     -0.286262440599317_REALK,      0.000000000000000_REALK,     -0.087331289875701_REALK, &
      0.000000000000000_REALK,     -0.401692838587070_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.120566317578621_REALK,      0.000000000000000_REALK, &
     -1.053195880535899_REALK,      0.000000000000000_REALK,     -8.619796529809221_REALK, &
     -3.066057925224713_REALK,     -0.681748492490396_REALK,      0.000000000000000_REALK, &
     -0.259336429595631_REALK,      0.000000000000000_REALK,     -0.745805140746788_REALK, &
      0.082307978973374_REALK,      0.000000000000000_REALK,      0.091261234771751_REALK, &
      0.000000000000000_REALK,      0.673932013629341_REALK,      0.000000000000000_REALK, &
      0.442378780359700_REALK,      0.000000000000000_REALK,      1.781083038312807_REALK, &
      4.421955677466824_REALK,      0.000000000000000_REALK,      1.770298686270787_REALK, &
      0.000000000000000_REALK,      2.748014280688413_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.966071202381362_REALK, &
      0.000000000000000_REALK,     -0.012296028623059_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.862279110796729_REALK,      0.000000000000000_REALK, &
     -4.100477506324820_REALK,      0.000000000000000_REALK,      0.021449079218139_REALK, &
      0.000000000000000_REALK,     -0.059958756029317_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.613097244630748_REALK,      0.000000000000000_REALK, &
     -2.182044406579118_REALK,      0.000000000000000_REALK,    -17.294137313830085_REALK, &
     -7.358195026586792_REALK,     -0.215365979499481_REALK,      0.000000000000000_REALK, &
      0.129156000919538_REALK,      0.000000000000000_REALK,      0.600382316182561_REALK, &
      0.067727854654048_REALK,      0.000000000000000_REALK,      0.222664523530236_REALK, &
      0.000000000000000_REALK,      0.231252817861883_REALK,      0.000000000000000_REALK, &
      0.629799538229307_REALK,      0.000000000000000_REALK,      4.879377171801994_REALK, &
     -0.748952254930872_REALK,      0.000000000000000_REALK,      0.171389036991652_REALK, &
      0.000000000000000_REALK,      0.939107906069661_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.021781379158622_REALK, &
      0.000000000000000_REALK,     -0.070722053071679_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.286580122474373_REALK,      0.000000000000000_REALK, &
     -1.760680930751568_REALK,      0.000000000000000_REALK,     -0.257953092106118_REALK, &
      0.000000000000000_REALK,     -0.574766381353560_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.792529475146086_REALK,      0.000000000000000_REALK, &
     -1.208677765416680_REALK,      0.000000000000000_REALK,    -10.396165039171608_REALK, &
     -2.119646254146588_REALK,     -0.182748757308053_REALK,      0.000000000000000_REALK, &
      0.049307037305958_REALK,      0.000000000000000_REALK,      0.288249614421752_REALK, &
      0.068462522186402_REALK,      0.000000000000000_REALK,      0.314903225556711_REALK, &
      0.000000000000000_REALK,     -0.045873539534181_REALK,      0.000000000000000_REALK, &
      0.400724048252487_REALK,      0.000000000000000_REALK,      3.279693573032502_REALK, &
     -0.963949610540655_REALK,      0.000000000000000_REALK,      0.288746922210037_REALK, &
      0.000000000000000_REALK,      1.859386244876062_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.578783944644673_REALK, &
      0.000000000000000_REALK,     -0.091894751122558_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.346798577099645_REALK,      0.000000000000000_REALK, &
     -1.396262865232726_REALK,      0.000000000000000_REALK,     -0.673570101525202_REALK, &
      0.000000000000000_REALK,     -1.045575118137364_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.228248260059540_REALK,      0.000000000000000_REALK, &
     -2.047716414659407_REALK,      0.000000000000000_REALK,    -10.599958425457288_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.914885004421507_REALK, &
      0.000000000000000_REALK,      0.970230058754737_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.707970954546175_REALK,      0.000000000000000_REALK, &
    -12.714586826601186_REALK,      0.000000000000000_REALK,      1.010191097749045_REALK, &
      0.000000000000000_REALK,      1.168136391405718_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.062977523281597_REALK,      0.000000000000000_REALK, &
     -3.450139745019270_REALK,      0.000000000000000_REALK,    -26.998751764250255_REALK, &
     -9.300900511333865_REALK,      0.018567188751104_REALK,      0.000000000000000_REALK, &
      1.081253914226564_REALK,      0.000000000000000_REALK,      5.141789124190980_REALK, &
     -0.021571752754119_REALK,      0.000000000000000_REALK,      0.060301677631700_REALK, &
      0.000000000000000_REALK,      0.962373123636170_REALK,      0.000000000000000_REALK, &
      1.301806756202770_REALK,      0.000000000000000_REALK,     10.317674896973324_REALK, &
      0.467253631005347_REALK,      0.000000000000000_REALK,     -0.027483884722534_REALK, &
      0.000000000000000_REALK,      0.128047418885834_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.906586356385148_REALK, &
      0.000000000000000_REALK,     -0.279209927054832_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.633401545361074_REALK,      0.000000000000000_REALK, &
     -4.907283752078039_REALK,      0.000000000000000_REALK,     -0.102250625891068_REALK, &
      0.000000000000000_REALK,     -0.560271373597544_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.296316952501263_REALK,      0.000000000000000_REALK, &
     -1.344994636751993_REALK,      0.000000000000000_REALK,    -14.588500022246851_REALK, &
     -2.396196756674878_REALK,      0.106791367237463_REALK,      0.000000000000000_REALK, &
      0.359356819949672_REALK,      0.000000000000000_REALK,      2.207803858683508_REALK, &
      0.259428401027493_REALK,      0.000000000000000_REALK,      0.578053637820207_REALK, &
      0.000000000000000_REALK,      0.472822744635376_REALK,      0.000000000000000_REALK, &
      0.721096635956317_REALK,      0.000000000000000_REALK,      6.202347599245299_REALK, &
      0.946808826418723_REALK,      0.000000000000000_REALK,      0.550882470304385_REALK, &
      0.000000000000000_REALK,      1.718452800824682_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.435261267069995_REALK, &
      0.000000000000000_REALK,     -0.394872542976435_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.403015905886639_REALK,      0.000000000000000_REALK, &
     -3.298451096534802_REALK,      0.000000000000000_REALK,     -0.172266289830043_REALK, &
      0.000000000000000_REALK,     -1.109309035449452_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.097967148111562_REALK,      0.000000000000000_REALK, &
     -1.198096105509158_REALK,      0.000000000000000_REALK,    -12.607355192697357_REALK, &
     -1.357315996612771_REALK,      0.138762460761397_REALK,      0.000000000000000_REALK, &
      0.434867682913856_REALK,      0.000000000000000_REALK,      1.750842238225086_REALK, &
      0.677422445266609_REALK,      0.000000000000000_REALK,      1.051555067000010_REALK, &
      0.000000000000000_REALK,      1.329371955353649_REALK,      0.000000000000000_REALK, &
      1.221666733891133_REALK,      0.000000000000000_REALK,      6.323930646013840_REALK, &
      3.593096276782790_REALK,      0.000000000000000_REALK,      2.013858960908378_REALK, &
      0.000000000000000_REALK,      4.019258690322049_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,   -133.373792392171026_REALK, &
      0.000000000000000_REALK,     14.644029575713699_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -12.603743016071514_REALK,      0.000000000000000_REALK, &
    -52.752695272492886_REALK,      0.000000000000000_REALK,      4.932375440268959_REALK, &
      0.000000000000000_REALK,      6.816327788008542_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.049605622750734_REALK,      0.000000000000000_REALK, &
     -7.735457611652704_REALK,      0.000000000000000_REALK,    -53.960985724698325_REALK, &
    103.289059256385485_REALK,     -5.307856710857621_REALK,      0.000000000000000_REALK, &
      7.747461668507043_REALK,      0.000000000000000_REALK,     36.376229923967458_REALK, &
     -1.815529570744119_REALK,      0.000000000000000_REALK,     -2.099391061735787_REALK, &
      0.000000000000000_REALK,      2.156289736924187_REALK,      0.000000000000000_REALK, &
      3.606195820934201_REALK,      0.000000000000000_REALK,     28.219954256413846_REALK, &
     -2.090529870219886_REALK,      0.000000000000000_REALK,     -1.114268358160364_REALK, &
      0.000000000000000_REALK,     -2.147477214722619_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -28.129287133899137_REALK, &
      0.000000000000000_REALK,     -0.172522136994840_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.339625311039664_REALK,      0.000000000000000_REALK, &
    -18.543069641495524_REALK,      0.000000000000000_REALK,      0.028727030657967_REALK, &
      0.000000000000000_REALK,     -0.133839235797368_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.061523827324532_REALK,      0.000000000000000_REALK, &
     -2.393213983816758_REALK,      0.000000000000000_REALK,    -26.554913174910443_REALK, &
     23.919081091765861_REALK,      1.527479252661137_REALK,      0.000000000000000_REALK, &
      1.812151709094105_REALK,      0.000000000000000_REALK,     14.039660470466004_REALK, &
      0.183766255063995_REALK,      0.000000000000000_REALK,      1.006927549326376_REALK, &
      0.000000000000000_REALK,      0.309719905497927_REALK,      0.000000000000000_REALK, &
      1.405831182703836_REALK,      0.000000000000000_REALK,     15.248364327813988_REALK, &
     -0.492859724845384_REALK,      0.000000000000000_REALK,      0.187975386185816_REALK, &
      0.000000000000000_REALK,      1.441987446671248_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -12.078276097332251_REALK, &
      0.000000000000000_REALK,     -1.653802229242759_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.295964960352511_REALK,      0.000000000000000_REALK, &
    -11.146945859605090_REALK,      0.000000000000000_REALK,     -0.575799883209220_REALK, &
      0.000000000000000_REALK,     -1.796181536632809_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.869227324974606_REALK,      0.000000000000000_REALK, &
     -1.855908307806563_REALK,      0.000000000000000_REALK,    -20.524076162076248_REALK, &
     11.483792437230342_REALK,      2.160237005912752_REALK,      0.000000000000000_REALK, &
      1.153022072638386_REALK,      0.000000000000000_REALK,      9.436815927787919_REALK, &
      0.309599385626852_REALK,      0.000000000000000_REALK,      1.993665714773936_REALK, &
      0.000000000000000_REALK,     -0.102398379839186_REALK,      0.000000000000000_REALK, &
      1.252288164559704_REALK,      0.000000000000000_REALK,     13.177608725725504_REALK, &
     -1.057236819143061_REALK,      0.000000000000000_REALK,      0.443366980940897_REALK, &
      0.000000000000000_REALK,      3.670794447833631_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -9.578367151130720_REALK, &
      0.000000000000000_REALK,     -3.008482258729491_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.195596541996785_REALK,      0.000000000000000_REALK, &
    -11.365456611878900_REALK,      0.000000000000000_REALK,     -2.104949452920818_REALK, &
      0.000000000000000_REALK,     -4.201057047969484_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.421444967405659_REALK,      0.000000000000000_REALK, &
     -4.042595273781092_REALK,      0.000000000000000_REALK,    -25.576716514762566_REALK, &
    ! results of test 7, ket-major order, 02ODGYYZ
      0.000000000000000_REALK,      0.000000000000000_REALK,    -12.079395173522993_REALK, &
      0.000000000000000_REALK,     -3.327584184876591_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.117623691929062_REALK,      0.000000000000000_REALK, &
    -10.935402444089853_REALK,      0.000000000000000_REALK,     -1.333668234050118_REALK, &
      0.000000000000000_REALK,     -3.680639409527780_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.264573516279262_REALK,      0.000000000000000_REALK, &
     -6.627938771265636_REALK,      0.000000000000000_REALK,    -38.747020701595588_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -11.521526018895580_REALK, &
      0.000000000000000_REALK,     -1.339783666920328_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.650978670222601_REALK,      0.000000000000000_REALK, &
     -8.998154654266383_REALK,      0.000000000000000_REALK,      0.042929250576387_REALK, &
      0.000000000000000_REALK,     -1.288929914999158_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.579251321156484_REALK,      0.000000000000000_REALK, &
     -2.782147910572766_REALK,      0.000000000000000_REALK,    -25.272078133513443_REALK, &
     10.458318794740487_REALK,      2.647560874311687_REALK,      0.000000000000000_REALK, &
      1.900510072558306_REALK,      0.000000000000000_REALK,      6.666244725517813_REALK, &
      0.749227894006948_REALK,      0.000000000000000_REALK,      2.067708927148254_REALK, &
      0.000000000000000_REALK,     -0.348843306659352_REALK,      0.000000000000000_REALK, &
      1.828373002865761_REALK,      0.000000000000000_REALK,     10.688693579882020_REALK, &
     -7.024871892933211_REALK,      0.000000000000000_REALK,      1.262561932173973_REALK, &
      0.000000000000000_REALK,      5.807335345084075_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -12.934153554134973_REALK, &
      0.000000000000000_REALK,      0.187022437934713_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.485588743115586_REALK,      0.000000000000000_REALK, &
     -8.587192978373027_REALK,      0.000000000000000_REALK,      0.139218942318776_REALK, &
      0.000000000000000_REALK,      0.153584188362902_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.811177809794000_REALK,      0.000000000000000_REALK, &
     -1.967116713752298_REALK,      0.000000000000000_REALK,    -18.950972479489767_REALK, &
     11.760562001157162_REALK,      1.199621117463576_REALK,      0.000000000000000_REALK, &
      1.185131819861474_REALK,      0.000000000000000_REALK,      6.459198772911998_REALK, &
     -0.026526583351028_REALK,      0.000000000000000_REALK,      0.796447791768943_REALK, &
      0.000000000000000_REALK,     -0.202631178176194_REALK,      0.000000000000000_REALK, &
      0.973238883347318_REALK,      0.000000000000000_REALK,      8.840568471955617_REALK, &
     -2.230410345681091_REALK,      0.000000000000000_REALK,     -0.035124717867152_REALK, &
      0.000000000000000_REALK,      1.757671013237590_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.968850154214409_REALK, &
      0.000000000000000_REALK,     -1.484275774104716_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.129777207989883_REALK,      0.000000000000000_REALK, &
     -6.604693008927077_REALK,      0.000000000000000_REALK,     -0.441663924608832_REALK, &
      0.000000000000000_REALK,     -2.031496796052609_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.285423634508861_REALK,      0.000000000000000_REALK, &
     -2.493291676394535_REALK,      0.000000000000000_REALK,    -20.406144134415143_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -16.229471066603825_REALK, &
      0.000000000000000_REALK,      2.433849921131866_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.368740298607751_REALK,      0.000000000000000_REALK, &
     -9.230430050323054_REALK,      0.000000000000000_REALK,      1.445509700711278_REALK, &
      0.000000000000000_REALK,      1.689026889963857_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.115844777343316_REALK,      0.000000000000000_REALK, &
     -1.418012579282580_REALK,      0.000000000000000_REALK,    -15.937849248270714_REALK, &
     14.883872198030678_REALK,     -0.190017751592280_REALK,      0.000000000000000_REALK, &
      1.251514954921822_REALK,      0.000000000000000_REALK,      7.234169269952081_REALK, &
     -0.097963336334843_REALK,      0.000000000000000_REALK,     -0.108071640609495_REALK, &
      0.000000000000000_REALK,      0.799668102056744_REALK,      0.000000000000000_REALK, &
      0.868517977916985_REALK,      0.000000000000000_REALK,      8.367200676186956_REALK, &
      0.945022653875088_REALK,      0.000000000000000_REALK,     -0.101489846812135_REALK, &
      0.000000000000000_REALK,     -0.186603387562331_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.562647998123134_REALK, &
      0.000000000000000_REALK,     -0.670957104940678_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.684833015360737_REALK,      0.000000000000000_REALK, &
     -6.220788408421860_REALK,      0.000000000000000_REALK,      0.015508204837878_REALK, &
      0.000000000000000_REALK,     -0.776043873547524_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.147717019609126_REALK,      0.000000000000000_REALK, &
     -1.182476363457853_REALK,      0.000000000000000_REALK,    -15.037694045196353_REALK, &
      6.868605857560851_REALK,      1.508047635635704_REALK,      0.000000000000000_REALK, &
      0.951766145295266_REALK,      0.000000000000000_REALK,      5.564037901905884_REALK, &
      0.310782935660806_REALK,      0.000000000000000_REALK,      1.429490847870180_REALK, &
      0.000000000000000_REALK,     -0.126019750714480_REALK,      0.000000000000000_REALK, &
      1.100833839700734_REALK,      0.000000000000000_REALK,      9.009685554904246_REALK, &
     -1.791438536710182_REALK,      0.000000000000000_REALK,      0.536617638668263_REALK, &
      0.000000000000000_REALK,      3.455550100623570_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -24.585220210459156_REALK, &
      0.000000000000000_REALK,      6.301463579624047_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.410918032415687_REALK,      0.000000000000000_REALK, &
    -11.496284340290369_REALK,      0.000000000000000_REALK,      2.237210543690112_REALK, &
      0.000000000000000_REALK,      3.583108827170576_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.848848693346843_REALK,      0.000000000000000_REALK, &
     -1.927417011164379_REALK,      0.000000000000000_REALK,    -15.317909128897510_REALK, &
     23.737723057095284_REALK,     -3.020644516927115_REALK,      0.000000000000000_REALK, &
      1.402576488837945_REALK,      0.000000000000000_REALK,      9.458612553173973_REALK, &
     -1.208836206896777_REALK,      0.000000000000000_REALK,     -1.412482294657657_REALK, &
      0.000000000000000_REALK,      0.065154062276065_REALK,      0.000000000000000_REALK, &
      0.797526500698587_REALK,      0.000000000000000_REALK,      8.963853583066088_REALK, &
     -1.985724898157150_REALK,      0.000000000000000_REALK,     -0.966408412711456_REALK, &
      0.000000000000000_REALK,     -1.882023338611695_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.978307803646802_REALK, &
      0.000000000000000_REALK,      0.110743244999219_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.726315414922650_REALK,      0.000000000000000_REALK, &
     -6.997237806684389_REALK,      0.000000000000000_REALK,      0.057080482618475_REALK, &
      0.000000000000000_REALK,      0.104950512340576_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.534625247291231_REALK,      0.000000000000000_REALK, &
     -0.967759077227350_REALK,      0.000000000000000_REALK,    -13.052588956991515_REALK, &
      9.598730609354771_REALK,      0.832723037906059_REALK,      0.000000000000000_REALK, &
      0.701762552839274_REALK,      0.000000000000000_REALK,      6.374570524856402_REALK, &
     -0.012969044415803_REALK,      0.000000000000000_REALK,      0.648982107849615_REALK, &
      0.000000000000000_REALK,     -0.083079825569738_REALK,      0.000000000000000_REALK, &
      0.665054915651351_REALK,      0.000000000000000_REALK,      8.457583300501510_REALK, &
     -0.658374719573391_REALK,      0.000000000000000_REALK,     -0.017280247945301_REALK, &
      0.000000000000000_REALK,      1.210605803065719_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.905512305602865_REALK, &
      0.000000000000000_REALK,     -1.464828832957677_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.920594170037497_REALK,      0.000000000000000_REALK, &
     -7.534528551530294_REALK,      0.000000000000000_REALK,     -0.301807469011848_REALK, &
      0.000000000000000_REALK,     -1.943489655876863_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.140419381941134_REALK,      0.000000000000000_REALK, &
     -1.717268675108243_REALK,      0.000000000000000_REALK,    -18.070517088595039_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -41.638300152396582_REALK, &
      0.000000000000000_REALK,     15.206660369880067_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.973735240076073_REALK,      0.000000000000000_REALK, &
    -16.468996796201964_REALK,      0.000000000000000_REALK,      4.838690581301459_REALK, &
      0.000000000000000_REALK,      7.078214442691744_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.587754266179688_REALK,      0.000000000000000_REALK, &
     -3.052594619878550_REALK,      0.000000000000000_REALK,    -16.846216035588000_REALK, &
     40.884955876690064_REALK,     -9.293000321839388_REALK,      0.000000000000000_REALK, &
      3.019616892190362_REALK,      0.000000000000000_REALK,     14.398819837346895_REALK, &
     -2.294969743830902_REALK,      0.000000000000000_REALK,     -3.675615766429596_REALK, &
      0.000000000000000_REALK,      1.348240592925267_REALK,      0.000000000000000_REALK, &
      1.405535165369538_REALK,      0.000000000000000_REALK,     11.170317484950509_REALK, &
     -0.804674903511842_REALK,      0.000000000000000_REALK,     -1.408521353600461_REALK, &
      0.000000000000000_REALK,     -3.759805046495983_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -13.948964139858434_REALK, &
      0.000000000000000_REALK,      1.769100126807080_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.818116647165291_REALK,      0.000000000000000_REALK, &
     -9.195277940776773_REALK,      0.000000000000000_REALK,      0.704736442766129_REALK, &
      0.000000000000000_REALK,      1.372432623112985_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.041020228627335_REALK,      0.000000000000000_REALK, &
     -0.836855453371380_REALK,      0.000000000000000_REALK,    -13.168251646430377_REALK, &
     14.930828980058422_REALK,     -0.163317140282619_REALK,      0.000000000000000_REALK, &
      0.909692601104797_REALK,      0.000000000000000_REALK,      8.763872182981871_REALK, &
     -0.058554158410408_REALK,      0.000000000000000_REALK,     -0.107660072987094_REALK, &
      0.000000000000000_REALK,      0.389866116678227_REALK,      0.000000000000000_REALK, &
      0.705721391255589_REALK,      0.000000000000000_REALK,      9.518372345942241_REALK, &
      0.334629201324143_REALK,      0.000000000000000_REALK,     -0.059895330272410_REALK, &
      0.000000000000000_REALK,     -0.154176409076260_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -9.400813825319718_REALK, &
      0.000000000000000_REALK,     -0.812834492605479_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.682224975968680_REALK,      0.000000000000000_REALK, &
     -8.675937021361113_REALK,      0.000000000000000_REALK,      0.012601318766380_REALK, &
      0.000000000000000_REALK,     -0.882813121267083_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.087176796046624_REALK,      0.000000000000000_REALK, &
     -0.976991693007660_REALK,      0.000000000000000_REALK,    -15.974383875773206_REALK, &
     11.483792437230340_REALK,      2.160237005912752_REALK,      0.000000000000000_REALK, &
      1.153022072638386_REALK,      0.000000000000000_REALK,      9.436815927787917_REALK, &
      0.309599385626852_REALK,      0.000000000000000_REALK,      1.993665714773936_REALK, &
      0.000000000000000_REALK,     -0.102398379839187_REALK,      0.000000000000000_REALK, &
      1.252288164559704_REALK,      0.000000000000000_REALK,     13.177608725725502_REALK, &
     -1.057236819143061_REALK,      0.000000000000000_REALK,      0.443366980940897_REALK, &
      0.000000000000000_REALK,      3.670794447833632_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,   -111.803337653632738_REALK, &
      0.000000000000000_REALK,     47.574417308322460_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -14.921372551535038_REALK,      0.000000000000000_REALK, &
    -31.370449718297607_REALK,      0.000000000000000_REALK,     11.231125040339169_REALK, &
      0.000000000000000_REALK,     15.896106084626563_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -7.427490201367120_REALK,      0.000000000000000_REALK, &
     -6.414572193583474_REALK,      0.000000000000000_REALK,    -22.476486190999346_REALK, &
    129.746087109157855_REALK,    -37.299036538008181_REALK,      0.000000000000000_REALK, &
      9.549144810660875_REALK,      0.000000000000000_REALK,     31.619060465075581_REALK, &
     -7.154309516661709_REALK,      0.000000000000000_REALK,    -10.465586938750144_REALK, &
      0.000000000000000_REALK,      2.704803083345750_REALK,      0.000000000000000_REALK, &
      3.190669009017422_REALK,      0.000000000000000_REALK,     17.608200929772153_REALK, &
     -4.223509521554664_REALK,      0.000000000000000_REALK,     -3.075577312433412_REALK, &
      0.000000000000000_REALK,     -7.498445907593002_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -35.317557843348780_REALK, &
      0.000000000000000_REALK,      7.056866827002160_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.078172480890753_REALK,      0.000000000000000_REALK, &
    -16.516019642904958_REALK,      0.000000000000000_REALK,      1.472231328131956_REALK, &
      0.000000000000000_REALK,      3.929867845432854_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.856971139119090_REALK,      0.000000000000000_REALK, &
     -1.488981365861997_REALK,      0.000000000000000_REALK,    -16.566894229269000_REALK, &
     43.465355447955858_REALK,     -4.339265076234000_REALK,      0.000000000000000_REALK, &
      1.570713751074981_REALK,      0.000000000000000_REALK,     17.654144499539132_REALK, &
     -1.041997324380250_REALK,      0.000000000000000_REALK,     -2.029228282225326_REALK, &
      0.000000000000000_REALK,      0.042875647939540_REALK,      0.000000000000000_REALK, &
      0.874707942781318_REALK,      0.000000000000000_REALK,     13.763875542989609_REALK, &
     -0.920415463999050_REALK,      0.000000000000000_REALK,     -0.746576433643870_REALK, &
      0.000000000000000_REALK,     -2.035478949863686_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -21.496106365006717_REALK, &
      0.000000000000000_REALK,      0.206698100654098_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.043453632906940_REALK,      0.000000000000000_REALK, &
    -14.073514458820409_REALK,      0.000000000000000_REALK,      0.062604504653370_REALK, &
      0.000000000000000_REALK,      0.161150087587060_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.413012350894995_REALK,      0.000000000000000_REALK, &
     -1.046667801520926_REALK,      0.000000000000000_REALK,    -18.150255454399989_REALK, &
     29.293194126866975_REALK,      1.993727925895949_REALK,      0.000000000000000_REALK, &
      1.309813404718929_REALK,      0.000000000000000_REALK,     16.657054504550565_REALK, &
     -0.018631845384201_REALK,      0.000000000000000_REALK,      1.305294936469389_REALK, &
      0.000000000000000_REALK,     -0.091119960586991_REALK,      0.000000000000000_REALK, &
      1.021182798609213_REALK,      0.000000000000000_REALK,     16.696934220700754_REALK, &
     -0.508612139210694_REALK,      0.000000000000000_REALK,     -0.018689237385883_REALK, &
      0.000000000000000_REALK,      1.683405847883709_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -23.146708976955679_REALK, &
      0.000000000000000_REALK,     -3.827667074239934_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.851587114897219_REALK,      0.000000000000000_REALK, &
    -19.483926473336261_REALK,      0.000000000000000_REALK,     -0.463421273331741_REALK, &
      0.000000000000000_REALK,     -3.836831136013064_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.151868837240290_REALK,      0.000000000000000_REALK, &
     -2.387945045979424_REALK,      0.000000000000000_REALK,    -30.711910672791582_REALK, &
    ! results of test 7, ket-major order, 03ODGYYZ
      8.883597246559678_REALK,      3.850943618463180_REALK,      0.000000000000000_REALK, &
      3.664622546988360_REALK,      0.000000000000000_REALK,      6.323279005657794_REALK, &
      5.240359583727574_REALK,      0.000000000000000_REALK,      3.486235664323621_REALK, &
      0.000000000000000_REALK,     10.291863543595378_REALK,      0.000000000000000_REALK, &
      4.053437394248723_REALK,      0.000000000000000_REALK,     11.656960231309098_REALK, &
     46.380184384737476_REALK,      0.000000000000000_REALK,     11.140787308705038_REALK, &
      0.000000000000000_REALK,     12.352654248147422_REALK,      0.000000000000000_REALK, &
     10.458318794740491_REALK,      2.647560874311687_REALK,      0.000000000000000_REALK, &
      1.900510072558305_REALK,      0.000000000000000_REALK,      6.666244725517814_REALK, &
      0.749227894006948_REALK,      0.000000000000000_REALK,      2.067708927148254_REALK, &
      0.000000000000000_REALK,     -0.348843306659352_REALK,      0.000000000000000_REALK, &
      1.828373002865761_REALK,      0.000000000000000_REALK,     10.688693579882024_REALK, &
     -7.024871892933211_REALK,      0.000000000000000_REALK,      1.262561932173973_REALK, &
      0.000000000000000_REALK,      5.807335345084075_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.749591085090682_REALK, &
      0.000000000000000_REALK,     -0.739061422005518_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.791893740125982_REALK,      0.000000000000000_REALK, &
     -3.985864756698334_REALK,      0.000000000000000_REALK,     -1.068758310363944_REALK, &
      0.000000000000000_REALK,     -2.074042783854842_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.388255971182012_REALK,      0.000000000000000_REALK, &
     -3.892675626995617_REALK,      0.000000000000000_REALK,    -18.551607396723195_REALK, &
     15.110108289474558_REALK,      2.440762659995634_REALK,      0.000000000000000_REALK, &
      2.251294464496101_REALK,      0.000000000000000_REALK,      8.298854503070377_REALK, &
      1.212095644799702_REALK,      0.000000000000000_REALK,      1.620461662842175_REALK, &
      0.000000000000000_REALK,      2.020406403423534_REALK,      0.000000000000000_REALK, &
      1.848779413389042_REALK,      0.000000000000000_REALK,     11.358466282361372_REALK, &
      4.597487042522966_REALK,      0.000000000000000_REALK,      1.604975544275749_REALK, &
      0.000000000000000_REALK,      3.576177273986059_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.075716251489637_REALK, &
      0.000000000000000_REALK,     -0.516168988398238_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.392889224992755_REALK,      0.000000000000000_REALK, &
     -4.019978673085872_REALK,      0.000000000000000_REALK,     -0.153592226697121_REALK, &
      0.000000000000000_REALK,     -1.236480451632742_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.099258393392732_REALK,      0.000000000000000_REALK, &
     -1.517554162069490_REALK,      0.000000000000000_REALK,    -14.701969281324809_REALK, &
     -1.563656606765197_REALK,     -0.579397627577165_REALK,      0.000000000000000_REALK, &
     -0.497712860092059_REALK,      0.000000000000000_REALK,      1.021541230181939_REALK, &
     -0.578221545135606_REALK,      0.000000000000000_REALK,      0.457566124869821_REALK, &
      0.000000000000000_REALK,     -1.037772612272782_REALK,      0.000000000000000_REALK, &
      0.486178329711706_REALK,      0.000000000000000_REALK,      3.971744813723340_REALK, &
     -3.187442698916485_REALK,      0.000000000000000_REALK,      0.910730204540464_REALK, &
      0.000000000000000_REALK,      2.868521025754908_REALK,      0.000000000000000_REALK, &
     23.843856663260919_REALK,      1.777205825991403_REALK,      0.000000000000000_REALK, &
      2.493078389077878_REALK,      0.000000000000000_REALK,     11.589087359492844_REALK, &
      0.307447941197440_REALK,      0.000000000000000_REALK,      1.010776875877140_REALK, &
      0.000000000000000_REALK,      0.635277389861343_REALK,      0.000000000000000_REALK, &
      1.730129866011638_REALK,      0.000000000000000_REALK,     13.404195557533663_REALK, &
     -1.391879738284894_REALK,      0.000000000000000_REALK,      0.318515534711701_REALK, &
      0.000000000000000_REALK,      1.745271821956343_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.932215741226984_REALK, &
      0.000000000000000_REALK,     -0.474737473132469_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.452405257528237_REALK,      0.000000000000000_REALK, &
     -4.864699782391358_REALK,      0.000000000000000_REALK,     -0.246430474209514_REALK, &
      0.000000000000000_REALK,     -0.961034184671644_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.512200870972267_REALK,      0.000000000000000_REALK, &
     -1.367191111044866_REALK,      0.000000000000000_REALK,    -13.919874077757155_REALK, &
     -2.091378607669387_REALK,     -0.459175941947979_REALK,      0.000000000000000_REALK, &
     -0.289797288860789_REALK,      0.000000000000000_REALK,      1.209119812365124_REALK, &
     -0.094628341871477_REALK,      0.000000000000000_REALK,      0.310642331383545_REALK, &
      0.000000000000000_REALK,      0.038370961480921_REALK,      0.000000000000000_REALK, &
      0.239221951606081_REALK,      0.000000000000000_REALK,      3.972690673557542_REALK, &
      0.545463855449800_REALK,      0.000000000000000_REALK,      0.116612257144427_REALK, &
      0.000000000000000_REALK,      1.523674891104896_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.831217256855743_REALK, &
      0.000000000000000_REALK,      0.308709147599728_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.273980103222345_REALK,      0.000000000000000_REALK, &
     -1.023019573294053_REALK,      0.000000000000000_REALK,      0.322030209571911_REALK, &
      0.000000000000000_REALK,     -0.463600707630003_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.720690179558032_REALK,      0.000000000000000_REALK, &
     -0.614228377489971_REALK,      0.000000000000000_REALK,     -6.850606959177465_REALK, &
     47.869162260588325_REALK,      0.294572386981035_REALK,      0.000000000000000_REALK, &
      4.011045937427807_REALK,      0.000000000000000_REALK,     19.074106559373067_REALK, &
     -0.049275548515246_REALK,      0.000000000000000_REALK,      0.137744868280306_REALK, &
      0.000000000000000_REALK,      1.686060557618192_REALK,      0.000000000000000_REALK, &
      2.280742231226496_REALK,      0.000000000000000_REALK,     18.076382499529146_REALK, &
      0.669729264761335_REALK,      0.000000000000000_REALK,     -0.039393512830288_REALK, &
      0.000000000000000_REALK,      0.183534376224066_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.001869650615649_REALK, &
      0.000000000000000_REALK,     -0.360195354816227_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.503155774640254_REALK,      0.000000000000000_REALK, &
     -6.822732075587563_REALK,      0.000000000000000_REALK,     -0.062297836916302_REALK, &
      0.000000000000000_REALK,     -0.597446786228561_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.147699967363154_REALK,      0.000000000000000_REALK, &
     -1.173378853243584_REALK,      0.000000000000000_REALK,    -15.065092167523687_REALK, &
     -3.755064227942490_REALK,     -0.515876914706926_REALK,      0.000000000000000_REALK, &
     -0.405900793296358_REALK,      0.000000000000000_REALK,      1.779793797805499_REALK, &
     -0.180437839272664_REALK,      0.000000000000000_REALK,      0.286941543305817_REALK, &
      0.000000000000000_REALK,     -0.252227310032043_REALK,      0.000000000000000_REALK, &
      0.274537965111230_REALK,      0.000000000000000_REALK,      4.791383154933485_REALK, &
     -0.413212028177449_REALK,      0.000000000000000_REALK,      0.171587166319079_REALK, &
      0.000000000000000_REALK,      1.086073748696356_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.201803187408561_REALK, &
      0.000000000000000_REALK,      0.254931985137171_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.160215920108221_REALK,      0.000000000000000_REALK, &
     -1.216097983202535_REALK,      0.000000000000000_REALK,      0.052525165721283_REALK, &
      0.000000000000000_REALK,     -0.313685698411324_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.024437934989106_REALK,      0.000000000000000_REALK, &
     -0.277172879249607_REALK,      0.000000000000000_REALK,     -6.284169483989117_REALK, &
     -3.949595198651201_REALK,     -1.244682733374641_REALK,      0.000000000000000_REALK, &
     -0.912069363799004_REALK,      0.000000000000000_REALK,     -0.767243298135269_REALK, &
     -0.874875804979534_REALK,      0.000000000000000_REALK,     -0.283748908080644_REALK, &
      0.000000000000000_REALK,     -1.316791414293760_REALK,      0.000000000000000_REALK, &
     -0.252835805223953_REALK,      0.000000000000000_REALK,      1.444137234912785_REALK, &
     -2.911764429278433_REALK,      0.000000000000000_REALK,     -0.340982262782880_REALK, &
      0.000000000000000_REALK,      0.750903684367296_REALK,      0.000000000000000_REALK, &
    103.289059256385485_REALK,     -5.307856710857621_REALK,      0.000000000000000_REALK, &
      7.747461668507043_REALK,      0.000000000000000_REALK,     36.376229923967458_REALK, &
     -1.815529570744119_REALK,      0.000000000000000_REALK,     -2.099391061735787_REALK, &
      0.000000000000000_REALK,      2.156289736924187_REALK,      0.000000000000000_REALK, &
      3.606195820934201_REALK,      0.000000000000000_REALK,     28.219954256413850_REALK, &
     -2.090529870219886_REALK,      0.000000000000000_REALK,     -1.114268358160365_REALK, &
      0.000000000000000_REALK,     -2.147477214722620_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -9.782188685944252_REALK, &
      0.000000000000000_REALK,     -0.059995978161567_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.813623755840576_REALK,      0.000000000000000_REALK, &
    -11.286329946237341_REALK,      0.000000000000000_REALK,      0.009990058864467_REALK, &
      0.000000000000000_REALK,     -0.081461904860728_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.369153556010322_REALK,      0.000000000000000_REALK, &
     -1.456641385461928_REALK,      0.000000000000000_REALK,    -19.131959237088385_REALK, &
     -7.282970598081848_REALK,     -0.465092552829746_REALK,      0.000000000000000_REALK, &
     -0.551770679064234_REALK,      0.000000000000000_REALK,      3.050955427155723_REALK, &
     -0.055953831479396_REALK,      0.000000000000000_REALK,      0.218815196979471_REALK, &
      0.000000000000000_REALK,     -0.094304666501533_REALK,      0.000000000000000_REALK, &
      0.305500854921504_REALK,      0.000000000000000_REALK,      6.723545942082319_REALK, &
      0.150067758508638_REALK,      0.000000000000000_REALK,      0.040848888465767_REALK, &
      0.000000000000000_REALK,      0.635823530784566_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.102046896708452_REALK, &
      0.000000000000000_REALK,      0.287820034559161_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.225543703521861_REALK,      0.000000000000000_REALK, &
     -1.799154158886339_REALK,      0.000000000000000_REALK,      0.100209528898943_REALK, &
      0.000000000000000_REALK,     -0.289909677722456_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.151276273722591_REALK,      0.000000000000000_REALK, &
     -0.299549777361185_REALK,      0.000000000000000_REALK,     -7.137414633596176_REALK, &
     -6.492711786184538_REALK,     -1.221355779974761_REALK,      0.000000000000000_REALK, &
     -0.651896143340231_REALK,      0.000000000000000_REALK,     -1.114760647180348_REALK, &
     -0.175041441321954_REALK,      0.000000000000000_REALK,     -0.235509529853003_REALK, &
      0.000000000000000_REALK,      0.057894042521412_REALK,      0.000000000000000_REALK, &
     -0.147931418336789_REALK,      0.000000000000000_REALK,      1.717624761982013_REALK, &
      0.597741033195993_REALK,      0.000000000000000_REALK,     -0.052374451975554_REALK, &
      0.000000000000000_REALK,      0.478466736338615_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.808944208931949_REALK, &
      0.000000000000000_REALK,      1.196356424456904_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.873103379922373_REALK,      0.000000000000000_REALK, &
      0.989587579340980_REALK,      0.000000000000000_REALK,      0.837056556957179_REALK, &
      0.000000000000000_REALK,      0.365785028859145_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.360575637700494_REALK,      0.000000000000000_REALK, &
      0.351987800213419_REALK,      0.000000000000000_REALK,     -2.828255083247360_REALK, &
    415.596400968768876_REALK,    -35.919010546858530_REALK,      0.000000000000000_REALK, &
     24.198104926667085_REALK,      0.000000000000000_REALK,    101.280647640986047_REALK, &
     -7.292828495467338_REALK,      0.000000000000000_REALK,    -10.078370985507112_REALK, &
      0.000000000000000_REALK,      6.323240253255856_REALK,      0.000000000000000_REALK, &
      8.085346384136052_REALK,      0.000000000000000_REALK,     56.401738942551255_REALK, &
     -3.211131352774723_REALK,      0.000000000000000_REALK,     -3.135125452972184_REALK, &
      0.000000000000000_REALK,     -7.221011120901842_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -31.028355814233137_REALK, &
      0.000000000000000_REALK,      1.401691595087271_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.854242320137959_REALK,      0.000000000000000_REALK, &
    -25.396115423253871_REALK,      0.000000000000000_REALK,      0.405023038089953_REALK, &
      0.000000000000000_REALK,      1.366193759143926_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.476632028501409_REALK,      0.000000000000000_REALK, &
     -2.325240965683253_REALK,      0.000000000000000_REALK,    -30.154105445729087_REALK, &
    -26.688494102705278_REALK,     -0.128846510710729_REALK,      0.000000000000000_REALK, &
     -1.367704237885872_REALK,      0.000000000000000_REALK,      7.736467458939120_REALK, &
      0.012932863004595_REALK,      0.000000000000000_REALK,      0.043003378810220_REALK, &
      0.000000000000000_REALK,     -0.337836393342510_REALK,      0.000000000000000_REALK, &
      0.543592441254421_REALK,      0.000000000000000_REALK,     12.238624837868636_REALK, &
     -0.094520969462572_REALK,      0.000000000000000_REALK,     -0.006613289621943_REALK, &
      0.000000000000000_REALK,      0.087525408746393_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.993186885735359_REALK, &
      0.000000000000000_REALK,      0.336447640719158_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.361751627767507_REALK,      0.000000000000000_REALK, &
     -3.638946068336822_REALK,      0.000000000000000_REALK,      0.034194090227393_REALK, &
      0.000000000000000_REALK,     -0.243268896151043_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.057102367273574_REALK,      0.000000000000000_REALK, &
     -0.336528027575752_REALK,      0.000000000000000_REALK,    -10.111617232749511_REALK, &
    -21.278794539290050_REALK,     -2.293443950914472_REALK,      0.000000000000000_REALK, &
     -1.406746573552337_REALK,      0.000000000000000_REALK,     -2.528097696501369_REALK, &
     -0.481340313857161_REALK,      0.000000000000000_REALK,     -0.313722918728899_REALK, &
      0.000000000000000_REALK,     -0.513673049413941_REALK,      0.000000000000000_REALK, &
     -0.229152859286008_REALK,      0.000000000000000_REALK,      2.796198004574865_REALK, &
     -0.592738661303467_REALK,      0.000000000000000_REALK,     -0.100879588078395_REALK, &
      0.000000000000000_REALK,      0.446438832964807_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      9.204546215708671_REALK, &
      0.000000000000000_REALK,      1.522114375666275_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.736304205857073_REALK,      0.000000000000000_REALK, &
      1.696460801641210_REALK,      0.000000000000000_REALK,      0.184284622577286_REALK, &
      0.000000000000000_REALK,      0.334071966123989_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.060392331907568_REALK,      0.000000000000000_REALK, &
      0.207917802015999_REALK,      0.000000000000000_REALK,     -3.396101193303154_REALK, &
    -20.211820780911243_REALK,     -4.997167456631907_REALK,      0.000000000000000_REALK, &
     -2.854611657276915_REALK,      0.000000000000000_REALK,     -6.644048130368024_REALK, &
     -2.107629293293033_REALK,      0.000000000000000_REALK,     -1.891309127029803_REALK, &
      0.000000000000000_REALK,     -2.421780953989952_REALK,      0.000000000000000_REALK, &
     -1.286580453384534_REALK,      0.000000000000000_REALK,     -1.799300928787564_REALK, &
     -3.771983091889618_REALK,      0.000000000000000_REALK,     -1.222153593133473_REALK, &
      0.000000000000000_REALK,     -0.658984502724140_REALK,      0.000000000000000_REALK, &
    ! results of test 7, ket-major order, 01ODGXZZ
    -23.298701998020881_REALK,    -14.269839882327945_REALK,      0.000000000000000_REALK, &
    -18.722905955536451_REALK,      0.000000000000000_REALK,    -12.252699352432467_REALK, &
     -8.128646337465343_REALK,      0.000000000000000_REALK,     -3.703710580839425_REALK, &
      0.000000000000000_REALK,    -28.625908408876619_REALK,      0.000000000000000_REALK, &
    -10.539847908762203_REALK,      0.000000000000000_REALK,    -11.495863939169439_REALK, &
    231.240828744045757_REALK,      0.000000000000000_REALK,     71.718018315945685_REALK, &
      0.000000000000000_REALK,     54.462283190854464_REALK,      0.000000000000000_REALK, &
    -12.499517690994383_REALK,     -5.339519978213833_REALK,      0.000000000000000_REALK, &
     -4.116414382841264_REALK,      0.000000000000000_REALK,     -4.952121773293051_REALK, &
     -0.701075808737352_REALK,      0.000000000000000_REALK,     -0.578902107145616_REALK, &
      0.000000000000000_REALK,     -0.510040130559600_REALK,      0.000000000000000_REALK, &
     -0.388424088924042_REALK,      0.000000000000000_REALK,     -0.778802135846762_REALK, &
     18.036407413602394_REALK,      0.000000000000000_REALK,     15.094805499657797_REALK, &
      0.000000000000000_REALK,     20.773822654174737_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.594476390188001_REALK, &
      0.000000000000000_REALK,      5.176115219503065_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.092508214006117_REALK,      0.000000000000000_REALK, &
      1.191604080946771_REALK,      0.000000000000000_REALK,      1.071944228282895_REALK, &
      0.000000000000000_REALK,      0.814028768451968_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -63.886954247558890_REALK,      0.000000000000000_REALK, &
    -39.204507300719584_REALK,      0.000000000000000_REALK,    -59.864768437426754_REALK, &
     -9.006636588568682_REALK,     -2.597402430075057_REALK,      0.000000000000000_REALK, &
     -1.271789007650046_REALK,      0.000000000000000_REALK,     -2.065518842265283_REALK, &
      0.491562897506731_REALK,      0.000000000000000_REALK,      0.443574405910937_REALK, &
      0.000000000000000_REALK,      1.688479818504886_REALK,      0.000000000000000_REALK, &
      1.168455133596431_REALK,      0.000000000000000_REALK,      3.162822973868020_REALK, &
     15.666118268516929_REALK,      0.000000000000000_REALK,      7.876106817370630_REALK, &
      0.000000000000000_REALK,     11.845345462152231_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.149232744864598_REALK, &
      0.000000000000000_REALK,      1.172081907994757_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.447053775505969_REALK,      0.000000000000000_REALK, &
     -0.896356444233028_REALK,      0.000000000000000_REALK,     -1.304111689105598_REALK, &
      0.000000000000000_REALK,     -1.794748859223799_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -9.405685682555230_REALK,      0.000000000000000_REALK, &
    -11.938259603036961_REALK,      0.000000000000000_REALK,    -33.511204065768084_REALK, &
     -6.312037098941638_REALK,     -3.291678251605552_REALK,      0.000000000000000_REALK, &
     -2.211961394105164_REALK,      0.000000000000000_REALK,     -2.412597168901161_REALK, &
      1.233746124534036_REALK,      0.000000000000000_REALK,      0.936900271337424_REALK, &
      0.000000000000000_REALK,      5.519496347103306_REALK,      0.000000000000000_REALK, &
      3.387062936163917_REALK,      0.000000000000000_REALK,      5.172000678420003_REALK, &
     63.737428800344176_REALK,      0.000000000000000_REALK,     32.946330678581703_REALK, &
      0.000000000000000_REALK,     35.026976582877836_REALK,      0.000000000000000_REALK, &
     -5.627726980633083_REALK,     -0.778441666014452_REALK,      0.000000000000000_REALK, &
      0.106554041146576_REALK,      0.000000000000000_REALK,      0.252668240069269_REALK, &
      0.801519411108433_REALK,      0.000000000000000_REALK,      0.999600478206223_REALK, &
      0.000000000000000_REALK,      1.319582865838729_REALK,      0.000000000000000_REALK, &
      1.496352863638119_REALK,      0.000000000000000_REALK,      5.913757321476041_REALK, &
      3.029806848945289_REALK,      0.000000000000000_REALK,      3.592946526947246_REALK, &
      0.000000000000000_REALK,      7.468130770821673_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.149724280357786_REALK, &
      0.000000000000000_REALK,     -0.099540231187980_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.909033714395909_REALK,      0.000000000000000_REALK, &
     -2.460610282110317_REALK,      0.000000000000000_REALK,     -1.549085378705948_REALK, &
      0.000000000000000_REALK,     -2.329761630539526_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.888443781166790_REALK,      0.000000000000000_REALK, &
     -6.791496004860702_REALK,      0.000000000000000_REALK,    -25.736905562636206_REALK, &
     -2.688106839900054_REALK,     -0.652412846891173_REALK,      0.000000000000000_REALK, &
      0.100321018468000_REALK,      0.000000000000000_REALK,      0.201146699396597_REALK, &
      1.014571684139851_REALK,      0.000000000000000_REALK,      1.396277165462414_REALK, &
      0.000000000000000_REALK,      1.849925414345044_REALK,      0.000000000000000_REALK, &
      2.348036133470609_REALK,      0.000000000000000_REALK,      6.591037608405995_REALK, &
      5.434279378842072_REALK,      0.000000000000000_REALK,      7.579982381687119_REALK, &
      0.000000000000000_REALK,     14.604447444619924_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.342917569692093_REALK, &
      0.000000000000000_REALK,     -0.210244929297687_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.635064294062344_REALK,      0.000000000000000_REALK, &
     -4.023708615230530_REALK,      0.000000000000000_REALK,     -6.479937400498625_REALK, &
      0.000000000000000_REALK,     -6.889162189261148_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -32.081366508970639_REALK,      0.000000000000000_REALK, &
    -27.561618099715258_REALK,      0.000000000000000_REALK,    -54.110866290365252_REALK, &
     -1.726244534774754_REALK,      0.555747427940534_REALK,      0.000000000000000_REALK, &
      1.076874372620876_REALK,      0.000000000000000_REALK,      3.335035016111432_REALK, &
      1.042772867580538_REALK,      0.000000000000000_REALK,      1.414507169161618_REALK, &
      0.000000000000000_REALK,      1.639136825790379_REALK,      0.000000000000000_REALK, &
      1.807635539766449_REALK,      0.000000000000000_REALK,      9.330286451793009_REALK, &
      3.414143389365331_REALK,      0.000000000000000_REALK,      2.344080987147641_REALK, &
      0.000000000000000_REALK,      5.299523134424239_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.064470528037438_REALK, &
      0.000000000000000_REALK,     -0.866980669470654_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.142564176271363_REALK,      0.000000000000000_REALK, &
     -4.515544045040908_REALK,      0.000000000000000_REALK,     -1.166924701978715_REALK, &
      0.000000000000000_REALK,     -2.425515161085253_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.264989231903846_REALK,      0.000000000000000_REALK, &
     -4.280674864520699_REALK,      0.000000000000000_REALK,    -23.684801967843800_REALK, &
     -0.662794601634894_REALK,      0.419354812558116_REALK,      0.000000000000000_REALK, &
      0.788429653107637_REALK,      0.000000000000000_REALK,      2.134154190800884_REALK, &
      1.182828932068805_REALK,      0.000000000000000_REALK,      1.778926777895205_REALK, &
      0.000000000000000_REALK,      1.912461110378602_REALK,      0.000000000000000_REALK, &
      2.205756303920096_REALK,      0.000000000000000_REALK,      8.358886119869755_REALK, &
      5.288769407358325_REALK,      0.000000000000000_REALK,      4.431528822353207_REALK, &
      0.000000000000000_REALK,      9.330775656150351_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.847414511855480_REALK, &
      0.000000000000000_REALK,     -1.211029144215205_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.792880567068606_REALK,      0.000000000000000_REALK, &
     -5.032692247143125_REALK,      0.000000000000000_REALK,     -2.461842561645232_REALK, &
      0.000000000000000_REALK,     -4.743263044428584_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.292153618880632_REALK,      0.000000000000000_REALK, &
     -9.403965670460146_REALK,      0.000000000000000_REALK,    -33.939427973606321_REALK, &
     -0.774166929270716_REALK,      0.885744606624669_REALK,      0.000000000000000_REALK, &
      2.285462898001008_REALK,      0.000000000000000_REALK,      3.489871868856501_REALK, &
      4.947859905376737_REALK,      0.000000000000000_REALK,      5.260330041963017_REALK, &
      0.000000000000000_REALK,     10.419453440727521_REALK,      0.000000000000000_REALK, &
      8.951520081315588_REALK,      0.000000000000000_REALK,     17.574240542161473_REALK, &
     35.862166339397803_REALK,      0.000000000000000_REALK,     25.952372705163310_REALK, &
      0.000000000000000_REALK,     35.474569834455458_REALK,      0.000000000000000_REALK, &
     13.931225332481143_REALK,      2.191278710765525_REALK,      0.000000000000000_REALK, &
      2.609303812451149_REALK,      0.000000000000000_REALK,     10.300723894363445_REALK, &
      0.992800713004778_REALK,      0.000000000000000_REALK,      1.730532029624588_REALK, &
      0.000000000000000_REALK,      1.498421457312474_REALK,      0.000000000000000_REALK, &
      2.348292286566928_REALK,      0.000000000000000_REALK,     15.450551951675800_REALK, &
      0.618821566048517_REALK,      0.000000000000000_REALK,      1.296399217298974_REALK, &
      0.000000000000000_REALK,      3.766214674856776_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.542820532677466_REALK, &
      0.000000000000000_REALK,     -1.730079003013689_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.668444151881532_REALK,      0.000000000000000_REALK, &
     -8.611836580666498_REALK,      0.000000000000000_REALK,     -1.147831153199380_REALK, &
      0.000000000000000_REALK,     -2.595028833963164_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.975571216198207_REALK,      0.000000000000000_REALK, &
     -3.631090752107229_REALK,      0.000000000000000_REALK,    -26.239118752661781_REALK, &
      4.481709330611142_REALK,      1.700881369533878_REALK,      0.000000000000000_REALK, &
      1.397466434994690_REALK,      0.000000000000000_REALK,      5.522946867875626_REALK, &
      1.077069271914203_REALK,      0.000000000000000_REALK,      2.238745862639735_REALK, &
      0.000000000000000_REALK,      1.109102124156523_REALK,      0.000000000000000_REALK, &
      2.096127221352237_REALK,      0.000000000000000_REALK,     11.597787663953602_REALK, &
      1.185999497276503_REALK,      0.000000000000000_REALK,      2.344061842415343_REALK, &
      0.000000000000000_REALK,      6.821160387403444_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.186878935907740_REALK, &
      0.000000000000000_REALK,     -2.175799411578411_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.035908857062412_REALK,      0.000000000000000_REALK, &
     -7.715235928998333_REALK,      0.000000000000000_REALK,     -2.169996201704438_REALK, &
      0.000000000000000_REALK,     -4.569020882967122_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.841659283019899_REALK,      0.000000000000000_REALK, &
     -6.203143054291698_REALK,      0.000000000000000_REALK,    -30.223666306680684_REALK, &
      3.567844693342621_REALK,      2.375851021702531_REALK,      0.000000000000000_REALK, &
      2.192866244598203_REALK,      0.000000000000000_REALK,      6.155469109833311_REALK, &
      2.272275983996602_REALK,      0.000000000000000_REALK,      4.378022733684001_REALK, &
      0.000000000000000_REALK,      2.591420187516511_REALK,      0.000000000000000_REALK, &
      4.604859993897379_REALK,      0.000000000000000_REALK,     16.619192324611504_REALK, &
      3.545359452869832_REALK,      0.000000000000000_REALK,      6.923322200140248_REALK, &
      0.000000000000000_REALK,     17.150466868886308_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.846586380550576_REALK, &
      0.000000000000000_REALK,     -6.433892137794109_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.262235943895384_REALK,      0.000000000000000_REALK, &
    -16.220990465875140_REALK,      0.000000000000000_REALK,    -12.708153879391313_REALK, &
      0.000000000000000_REALK,    -17.370908524744706_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -29.302131031201171_REALK,      0.000000000000000_REALK, &
    -32.366484241497126_REALK,      0.000000000000000_REALK,    -77.665023722442257_REALK, &
     78.003051251309685_REALK,      3.351048149666644_REALK,      0.000000000000000_REALK, &
      6.942144239541553_REALK,      0.000000000000000_REALK,     31.081356791336372_REALK, &
      0.713556723437396_REALK,      0.000000000000000_REALK,      1.566982196489839_REALK, &
      0.000000000000000_REALK,      2.671209714923946_REALK,      0.000000000000000_REALK, &
      3.947409675527593_REALK,      0.000000000000000_REALK,     29.455560197048655_REALK, &
      0.759243422829295_REALK,      0.000000000000000_REALK,      0.570455464969048_REALK, &
      0.000000000000000_REALK,      2.087882500288377_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -24.309050234011771_REALK, &
      0.000000000000000_REALK,     -2.906376778007444_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.879441686399889_REALK,      0.000000000000000_REALK, &
    -18.945241025589212_REALK,      0.000000000000000_REALK,     -0.948097326072705_REALK, &
      0.000000000000000_REALK,     -2.754350677630818_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.468870003840926_REALK,      0.000000000000000_REALK, &
     -3.836633192835490_REALK,      0.000000000000000_REALK,    -35.340294360428906_REALK, &
     21.778648518800985_REALK,      4.082875905069363_REALK,      0.000000000000000_REALK, &
      2.802102044584954_REALK,      0.000000000000000_REALK,     14.463321929657576_REALK, &
      1.407453786897474_REALK,      0.000000000000000_REALK,      3.181986435277705_REALK, &
      0.000000000000000_REALK,      1.444797067562379_REALK,      0.000000000000000_REALK, &
      2.655530323423712_REALK,      0.000000000000000_REALK,     19.189488851847745_REALK, &
      1.638839907489393_REALK,      0.000000000000000_REALK,      1.875323241202439_REALK, &
      0.000000000000000_REALK,      5.935650917384336_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -13.033801723821790_REALK, &
      0.000000000000000_REALK,     -3.759906708255427_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.570240568299536_REALK,      0.000000000000000_REALK, &
    -14.221037756089652_REALK,      0.000000000000000_REALK,     -1.714285796603129_REALK, &
      0.000000000000000_REALK,     -4.988528099765754_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.812047864792912_REALK,      0.000000000000000_REALK, &
     -4.794505287007649_REALK,      0.000000000000000_REALK,    -34.107177911852126_REALK, &
     13.936583508670903_REALK,      5.134747590325678_REALK,      0.000000000000000_REALK, &
      3.419248024891800_REALK,      0.000000000000000_REALK,     12.957507955373611_REALK, &
      2.660817632566498_REALK,      0.000000000000000_REALK,      5.602466639994304_REALK, &
      0.000000000000000_REALK,      2.809525681064628_REALK,      0.000000000000000_REALK, &
      4.536552679562533_REALK,      0.000000000000000_REALK,     22.103513198025393_REALK, &
      4.231147405469240_REALK,      0.000000000000000_REALK,      4.963466986105291_REALK, &
      0.000000000000000_REALK,     13.436735751135819_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -14.526513800328651_REALK, &
      0.000000000000000_REALK,     -7.352758220561893_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.646412034103212_REALK,      0.000000000000000_REALK, &
    -20.378210773644071_REALK,      0.000000000000000_REALK,     -5.063242231176840_REALK, &
      0.000000000000000_REALK,    -12.542673246261064_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.927396802705047_REALK,      0.000000000000000_REALK, &
    -13.542132656831898_REALK,      0.000000000000000_REALK,    -59.735255106876956_REALK, &
     22.789773552691649_REALK,     15.183574356694818_REALK,      0.000000000000000_REALK, &
     13.876178117873518_REALK,      0.000000000000000_REALK,     27.242668265739567_REALK, &
     15.582552583775605_REALK,      0.000000000000000_REALK,     21.299954193484737_REALK, &
      0.000000000000000_REALK,     21.429565606183932_REALK,      0.000000000000000_REALK, &
     23.670623025886066_REALK,      0.000000000000000_REALK,     56.798862833345353_REALK, &
     40.166878251577401_REALK,      0.000000000000000_REALK,     37.372581552147253_REALK, &
      0.000000000000000_REALK,     62.437188997877797_REALK,      0.000000000000000_REALK, &
    ! results of test 7, ket-major order, 02ODGXZZ
     18.249359200317709_REALK,     13.234728206421332_REALK,      0.000000000000000_REALK, &
     12.175660824620527_REALK,      0.000000000000000_REALK,     14.647542610182262_REALK, &
     16.866609520668973_REALK,      0.000000000000000_REALK,     13.927332351551099_REALK, &
      0.000000000000000_REALK,     20.071090209920001_REALK,      0.000000000000000_REALK, &
     15.285257887348607_REALK,      0.000000000000000_REALK,     30.647407895352178_REALK, &
     53.409726517822151_REALK,      0.000000000000000_REALK,     44.699003248752696_REALK, &
      0.000000000000000_REALK,     61.515808622311823_REALK,      0.000000000000000_REALK, &
      9.621650295822196_REALK,      1.557609093346862_REALK,      0.000000000000000_REALK, &
     -1.044031488518196_REALK,      0.000000000000000_REALK,      6.848619723154936_REALK, &
     -5.740202474335556_REALK,      0.000000000000000_REALK,      1.410093969245822_REALK, &
      0.000000000000000_REALK,    -14.055439090405466_REALK,      0.000000000000000_REALK, &
     -1.154802772201100_REALK,      0.000000000000000_REALK,     12.625425460547318_REALK, &
    -63.010920970853213_REALK,      0.000000000000000_REALK,    -12.203432580095120_REALK, &
      0.000000000000000_REALK,      4.996335571270356_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -10.890150997534104_REALK, &
      0.000000000000000_REALK,     -7.158395210067333_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.195043330949995_REALK,      0.000000000000000_REALK, &
    -16.431311629461550_REALK,      0.000000000000000_REALK,     -9.588921062534123_REALK, &
      0.000000000000000_REALK,    -13.196496344552472_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -22.877272293369266_REALK,      0.000000000000000_REALK, &
    -29.037204183226578_REALK,      0.000000000000000_REALK,    -81.508671049165486_REALK, &
      7.439991728189653_REALK,     -0.633968832270975_REALK,      0.000000000000000_REALK, &
     -1.210726429566747_REALK,      0.000000000000000_REALK,      4.742330635482515_REALK, &
     -2.771411601871450_REALK,      0.000000000000000_REALK,     -0.495121009960252_REALK, &
      0.000000000000000_REALK,     -3.730788902519624_REALK,      0.000000000000000_REALK, &
     -1.164771263062055_REALK,      0.000000000000000_REALK,      7.603879110997145_REALK, &
     -8.101907758748146_REALK,      0.000000000000000_REALK,     -4.670246282736150_REALK, &
      0.000000000000000_REALK,     -1.390589218571253_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.449039487707752_REALK, &
      0.000000000000000_REALK,     -0.859596300458953_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.648744887911233_REALK,      0.000000000000000_REALK, &
     -7.092709181519056_REALK,      0.000000000000000_REALK,      3.366420155911867_REALK, &
      0.000000000000000_REALK,     -1.378281451749771_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     13.306054596235553_REALK,      0.000000000000000_REALK, &
      1.822054868576472_REALK,      0.000000000000000_REALK,    -27.888662787109244_REALK, &
      9.428673308471261_REALK,      5.695509423073349_REALK,      0.000000000000000_REALK, &
      4.995715947323061_REALK,      0.000000000000000_REALK,     10.016562723069857_REALK, &
      5.386862302076346_REALK,      0.000000000000000_REALK,      7.413525277177663_REALK, &
      0.000000000000000_REALK,      6.310889174436043_REALK,      0.000000000000000_REALK, &
      8.010158518283093_REALK,      0.000000000000000_REALK,     22.484856723759769_REALK, &
     10.846687859491494_REALK,      0.000000000000000_REALK,     15.129458230416544_REALK, &
      0.000000000000000_REALK,     29.150117568282667_REALK,      0.000000000000000_REALK, &
      6.636538148803132_REALK,     -2.802686915655000_REALK,      0.000000000000000_REALK, &
     -2.047182083680178_REALK,      0.000000000000000_REALK,      3.644954982841384_REALK, &
     -3.510766963468118_REALK,      0.000000000000000_REALK,     -1.860749008580963_REALK, &
      0.000000000000000_REALK,     -4.521127102680839_REALK,      0.000000000000000_REALK, &
     -1.681160839443511_REALK,      0.000000000000000_REALK,      4.988772638201033_REALK, &
    -11.276731442852890_REALK,      0.000000000000000_REALK,     -4.648721528034768_REALK, &
      0.000000000000000_REALK,     -4.106464515432002_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.246207889215588_REALK, &
      0.000000000000000_REALK,      0.355415653859858_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.719728427113357_REALK,      0.000000000000000_REALK, &
     -4.698543075428292_REALK,      0.000000000000000_REALK,      1.633725245122337_REALK, &
      0.000000000000000_REALK,      0.486449873183947_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.052531918527862_REALK,      0.000000000000000_REALK, &
      1.588359973891712_REALK,      0.000000000000000_REALK,    -14.516821158735933_REALK, &
      5.562090181182750_REALK,      0.769668939832990_REALK,      0.000000000000000_REALK, &
     -0.465692394155767_REALK,      0.000000000000000_REALK,      5.091401537554997_REALK, &
     -2.080158019564795_REALK,      0.000000000000000_REALK,      0.851659353940059_REALK, &
      0.000000000000000_REALK,     -4.654666154802926_REALK,      0.000000000000000_REALK, &
     -0.637383310553693_REALK,      0.000000000000000_REALK,      9.755890736732340_REALK, &
    -14.222032840105642_REALK,      0.000000000000000_REALK,     -4.590675612047472_REALK, &
      0.000000000000000_REALK,      2.631323440231620_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.968671930904812_REALK, &
      0.000000000000000_REALK,     -5.321694860022617_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.949588794057842_REALK,      0.000000000000000_REALK, &
    -13.893706925012475_REALK,      0.000000000000000_REALK,     -5.292521284675013_REALK, &
      0.000000000000000_REALK,    -10.197167362592829_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.605950440422808_REALK,      0.000000000000000_REALK, &
    -15.292462829250855_REALK,      0.000000000000000_REALK,    -55.191337242197243_REALK, &
      6.475525271143202_REALK,     -5.112016983105686_REALK,      0.000000000000000_REALK, &
     -1.971163423347462_REALK,      0.000000000000000_REALK,      3.147369535294751_REALK, &
     -2.978369429272241_REALK,      0.000000000000000_REALK,     -2.907433950556633_REALK, &
      0.000000000000000_REALK,     -2.045704953404006_REALK,      0.000000000000000_REALK, &
     -1.367934808814651_REALK,      0.000000000000000_REALK,      3.640317432619724_REALK, &
     -3.218820062233239_REALK,      0.000000000000000_REALK,     -3.085585571459113_REALK, &
      0.000000000000000_REALK,     -5.020160897232951_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.703331846932599_REALK, &
      0.000000000000000_REALK,      1.567563851292483_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.182972101384508_REALK,      0.000000000000000_REALK, &
     -3.510418939508323_REALK,      0.000000000000000_REALK,      2.052495509392698_REALK, &
      0.000000000000000_REALK,      1.813079128654060_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.295876907458649_REALK,      0.000000000000000_REALK, &
      2.042595081051119_REALK,      0.000000000000000_REALK,     -8.485838533154775_REALK, &
      4.886289256180181_REALK,     -0.361107919311403_REALK,      0.000000000000000_REALK, &
     -0.606325871940619_REALK,      0.000000000000000_REALK,      3.958226630682918_REALK, &
     -1.149593388665315_REALK,      0.000000000000000_REALK,     -0.342297188464803_REALK, &
      0.000000000000000_REALK,     -1.347748626643368_REALK,      0.000000000000000_REALK, &
     -0.701289955539677_REALK,      0.000000000000000_REALK,      6.409441834550681_REALK, &
     -2.066097432252584_REALK,      0.000000000000000_REALK,     -1.984961266752161_REALK, &
      0.000000000000000_REALK,     -0.827445020585492_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.172944398026750_REALK, &
      0.000000000000000_REALK,     -0.717469368891221_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.448503591436679_REALK,      0.000000000000000_REALK, &
     -6.864867593234051_REALK,      0.000000000000000_REALK,      2.026867176702941_REALK, &
      0.000000000000000_REALK,     -1.161777385946865_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.655376909018851_REALK,      0.000000000000000_REALK, &
      1.084180869592944_REALK,      0.000000000000000_REALK,    -21.335972818693662_REALK, &
     10.320626413390361_REALK,      5.406926051914125_REALK,      0.000000000000000_REALK