  ! number of test cases
  integer, parameter :: NUM_TESTS = 8
  ! ID of block of sub-shells on bra center
  integer, parameter :: BRA_BLOCK(NUM_TESTS) = &
    (/12,    12,    12,    12,    12,    12,    12,    12/)
  ! ID of block of sub-shells on ket center
  integer, parameter :: KET_BLOCK(NUM_TESTS) = &
    (/6,    6,    6,    6,    6,    6,    6,    6/)
  ! orders of electronic derivatives
  integer, parameter :: ORDER_ELEC(NUM_TESTS) = &
    (/0,    0,    0,    0,    1,    2,    0,    0/)
  ! indices of dipole origin
  integer, parameter :: IDX_DIPORG(NUM_TESTS) = &
    (/-1,    -1,    -1,    -1,    -1,    -1,    -1,    -1/)
  ! coordinates of dipole origin
  real(REALK), parameter :: DIP_ORIGIN(3*NUM_TESTS) =                      &
    (/0.0_REALK, 0.0_REALK, 0.0_REALK,    0.0_REALK, 0.0_REALK, 0.0_REALK, &
      0.0_REALK, 0.0_REALK, 0.0_REALK,    0.0_REALK, 0.0_REALK, 0.0_REALK, &
      0.0_REALK, 0.0_REALK, 0.0_REALK,    0.0_REALK, 0.0_REALK, 0.0_REALK, &
      0.0_REALK, 0.0_REALK, 0.0_REALK,    0.0_REALK, 0.0_REALK, 0.0_REALK/)
  ! scale constants
  real(REALK), parameter :: SCAL_CONST(NUM_TESTS) =                      &
    (/1.0_REALK,    1.0_REALK,    1.0_REALK,   -1.0_REALK,    1.0_REALK, &
     -0.25_REALK,  -1.0_REALK,   -1.0_REALK/)
  ! orders of Cartesian multipole moments
  integer, parameter :: ORDER_MOM(NUM_TESTS) = &
    (/0,    3,    0,    1,    0,    0,    3,    0/)
  ! orders of partial geometric derivatives on bra center
  integer, parameter :: ORDER_GEO_BRA(NUM_TESTS) = &
    (/0,    0,    1,    0,    0,    0,    0,    0/)
  ! orders of partial geometric derivatives on ket center
  integer, parameter :: ORDER_GEO_KET(NUM_TESTS) = &
    (/0,    0,    0,    0,    0,    0,    0,    1/)
  ! orders of geometric derivatives on dipole origin
  integer, parameter :: ORDER_GEO_MOM(NUM_TESTS) = &
    (/0,    0,    0,    0,    0,    0,    0,    0/)
  ! numbers of differentiated centers of total geometric derivatives
  integer, parameter :: NUM_CENTS(NUM_TESTS) = &
    (/0,    0,    0,    1,    0,    0,    1,    0/)
  ! indices of differentiated centers
  integer, parameter :: IDX_CENT(3*NUM_TESTS) =                            &
    (/0, 0, 0,    0, 0, 0,    0, 0, 0,    1, 0, 0,    0, 0, 0,    0, 0, 0, &
      1, 0, 0,    0, 0, 0/)
  ! orders of geometric derivatives of differentiated centers
  integer, parameter :: ORDER_CENT(3*NUM_TESTS) =                          &
    (/0, 0, 0,    0, 0, 0,    0, 0, 0,    1, 0, 0,    0, 0, 0,    0, 0, 0, &
      1, 0, 0,    0, 0, 0/)
  ! referenced results from Dalton
  real(REALK) REF_CONTR_INTS(81900)
    ! results of test 1, ket-major order, OVERLAP
  data REF_CONTR_INTS(1:1260)                                                              &
    /14.861017618986345_REALK,     13.730033534525871_REALK,      0.000000000000000_REALK, &
     16.458460609878731_REALK,      0.000000000000000_REALK,      2.586822640005127_REALK, &
     24.277491051392065_REALK,      0.000000000000000_REALK,      2.903164574634262_REALK, &
      0.000000000000000_REALK,     49.549842407664904_REALK,      0.000000000000000_REALK, &
      4.931275824220198_REALK,      0.000000000000000_REALK,      2.325187558284665_REALK, &
      9.382279279395854_REALK,     14.057994662807792_REALK,      0.000000000000000_REALK, &
     21.057471857098466_REALK,      0.000000000000000_REALK,      2.538675035037558_REALK, &
     35.592917412157625_REALK,      0.000000000000000_REALK,      3.457412149590654_REALK, &
      0.000000000000000_REALK,     76.631752467376430_REALK,      0.000000000000000_REALK, &
      6.357607811798670_REALK,      0.000000000000000_REALK,      2.299407119321252_REALK, &
     10.875840787063188_REALK,      7.294368807303750_REALK,      0.000000000000000_REALK, &
      6.507758257062164_REALK,      0.000000000000000_REALK,      1.651016836935933_REALK, &
      6.960856039128613_REALK,      0.000000000000000_REALK,      1.329426786477019_REALK, &
      0.000000000000000_REALK,      9.547415806702920_REALK,      0.000000000000000_REALK, &
      1.605263074215828_REALK,      0.000000000000000_REALK,      1.221764665443327_REALK, &
      9.383546344734343_REALK,      4.910819750452618_REALK,      0.000000000000000_REALK, &
      2.820017351718780_REALK,      0.000000000000000_REALK,      1.148894103505634_REALK, &
      0.448856009188451_REALK,      0.000000000000000_REALK,      0.806920893759341_REALK, &
      0.000000000000000_REALK,     -5.223628504280318_REALK,      0.000000000000000_REALK, &
      0.632730705708349_REALK,      0.000000000000000_REALK,      0.773336280841197_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.126408842959509_REALK, &
      0.000000000000000_REALK,     -1.998354858585787_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.465732935530024_REALK,      0.000000000000000_REALK, &
     -1.162638584438493_REALK,      0.000000000000000_REALK,     -4.122109853875349_REALK, &
      0.000000000000000_REALK,     -1.478797369364352_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.277981528424028_REALK, &
      0.000000000000000_REALK,     -3.354840097114491_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.467685418647517_REALK,      0.000000000000000_REALK, &
     -1.615863696319991_REALK,      0.000000000000000_REALK,     -7.749102194649033_REALK, &
      0.000000000000000_REALK,     -2.258188596845486_REALK,      0.000000000000000_REALK, &
     10.858894100394007_REALK,      5.683498541090964_REALK,      0.000000000000000_REALK, &
      4.281895923811618_REALK,      0.000000000000000_REALK,      1.432577299672486_REALK, &
      3.957781664868499_REALK,      0.000000000000000_REALK,      0.886286079776608_REALK, &
      0.000000000000000_REALK,      4.850610798980714_REALK,      0.000000000000000_REALK, &
      0.867404473933112_REALK,      0.000000000000000_REALK,      0.870612444417928_REALK, &
      4.812797077273400_REALK,      3.964345243586067_REALK,      0.000000000000000_REALK, &
      3.943478021814958_REALK,      0.000000000000000_REALK,      0.989029689348303_REALK, &
      4.980738767970413_REALK,      0.000000000000000_REALK,      0.723524625919795_REALK, &
      0.000000000000000_REALK,      8.596174205955235_REALK,      0.000000000000000_REALK, &
      0.801870307001414_REALK,      0.000000000000000_REALK,      0.603330514011256_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.561079860028817_REALK, &
      0.000000000000000_REALK,     -1.054492306721790_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.959540269847395_REALK,      0.000000000000000_REALK, &
     -0.730305465565006_REALK,      0.000000000000000_REALK,     -1.118477348810795_REALK, &
      0.000000000000000_REALK,     -0.640840899115770_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.159781315882660_REALK, &
      0.000000000000000_REALK,     -0.798536815737268_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.519552855967174_REALK,      0.000000000000000_REALK, &
     -0.635008021120563_REALK,      0.000000000000000_REALK,     -0.090322455096615_REALK, &
      0.000000000000000_REALK,     -0.487125546062360_REALK,      0.000000000000000_REALK, &
      2.330075536306309_REALK,      1.889497098478143_REALK,      0.000000000000000_REALK, &
      1.955802634184317_REALK,      0.000000000000000_REALK,      0.922197036541731_REALK, &
      2.463976444147849_REALK,      0.000000000000000_REALK,      0.883945846410661_REALK, &
      0.000000000000000_REALK,      3.981012673510611_REALK,      0.000000000000000_REALK, &
      1.188589343510825_REALK,      0.000000000000000_REALK,      0.934069684991423_REALK, &
      2.593795150231284_REALK,      3.386631414100798_REALK,      0.000000000000000_REALK, &
      4.421265226262227_REALK,      0.000000000000000_REALK,      1.599074532217590_REALK, &
      6.363004260879309_REALK,      0.000000000000000_REALK,      1.854261732864872_REALK, &
      0.000000000000000_REALK,     10.836431736615738_REALK,      0.000000000000000_REALK, &
      2.697071938556826_REALK,      0.000000000000000_REALK,      1.625786144837337_REALK, &
     13.553819778609764_REALK,      5.343479805231405_REALK,      0.000000000000000_REALK, &
      3.316514204470399_REALK,      0.000000000000000_REALK,      1.520103231189125_REALK, &
      2.421429350274113_REALK,      0.000000000000000_REALK,      0.700857830313399_REALK, &
      0.000000000000000_REALK,      2.248073732627181_REALK,      0.000000000000000_REALK, &
      0.546741169107122_REALK,      0.000000000000000_REALK,      0.751786031849580_REALK, &
     14.338348317939641_REALK,      4.578797683765997_REALK,      0.000000000000000_REALK, &
      1.793211253384380_REALK,      0.000000000000000_REALK,      1.263698006298025_REALK, &
     -0.049514460064658_REALK,      0.000000000000000_REALK,      0.506272906030351_REALK, &
      0.000000000000000_REALK,     -2.546075735300223_REALK,      0.000000000000000_REALK, &
      0.251710238473685_REALK,      0.000000000000000_REALK,      0.532149894649049_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.603836457546004_REALK, &
      0.000000000000000_REALK,     -0.830938185201470_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.628758516798892_REALK,      0.000000000000000_REALK, &
     -0.631083889591612_REALK,      0.000000000000000_REALK,     -0.611711346963680_REALK, &
      0.000000000000000_REALK,     -0.410950853960249_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.090025331863612_REALK, &
      0.000000000000000_REALK,     -1.120359785893613_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.921414150420564_REALK,      0.000000000000000_REALK, &
     -0.693275793026096_REALK,      0.000000000000000_REALK,     -1.082598408359959_REALK, &
      0.000000000000000_REALK,     -0.471789414132946_REALK,      0.000000000000000_REALK, &
      2.035010758559748_REALK,      1.180552844240125_REALK,      0.000000000000000_REALK, &
      0.899617706571326_REALK,      0.000000000000000_REALK,      0.684698442236909_REALK, &
      0.810754590326983_REALK,      0.000000000000000_REALK,      0.464528585384229_REALK, &
      0.000000000000000_REALK,      0.882058788925636_REALK,      0.000000000000000_REALK, &
      0.444917168734531_REALK,      0.000000000000000_REALK,      0.564376938729578_REALK, &
      3.718929769880425_REALK,      1.687474290500135_REALK,      0.000000000000000_REALK, &
      0.804514602017602_REALK,      0.000000000000000_REALK,      0.983294037406028_REALK, &
      0.103787841375451_REALK,      0.000000000000000_REALK,      0.559746840922009_REALK, &
      0.000000000000000_REALK,     -0.932302242276278_REALK,      0.000000000000000_REALK, &
      0.338785341571807_REALK,      0.000000000000000_REALK,      0.690117174365541_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.032442178571901_REALK, &
      0.000000000000000_REALK,     -0.828744097637172_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.861576917306129_REALK,      0.000000000000000_REALK, &
     -0.677082361656465_REALK,      0.000000000000000_REALK,     -1.142490271443414_REALK, &
      0.000000000000000_REALK,     -0.683109567602665_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.379176900215118_REALK, &
      0.000000000000000_REALK,     -2.871277913149427_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.099154847348775_REALK,      0.000000000000000_REALK, &
     -1.868160407401365_REALK,      0.000000000000000_REALK,     -4.149130443969812_REALK, &
      0.000000000000000_REALK,     -2.015183785175997_REALK,      0.000000000000000_REALK, &
     20.683834690751045_REALK,      6.123263880219523_REALK,      0.000000000000000_REALK, &
      3.289199928140536_REALK,      0.000000000000000_REALK,      1.973800551269796_REALK, &
      1.990393021408364_REALK,      0.000000000000000_REALK,      0.669572394406592_REALK, &
      0.000000000000000_REALK,      1.626350331494557_REALK,      0.000000000000000_REALK, &
      0.437168360355164_REALK,      0.000000000000000_REALK,      0.787014930242819_REALK, &
     10.178235112033907_REALK,      4.701110620120084_REALK,      0.000000000000000_REALK, &
      3.362907070790971_REALK,      0.000000000000000_REALK,      1.590359241639932_REALK, &
      3.228738925175942_REALK,      0.000000000000000_REALK,      0.628202127460413_REALK, &
      0.000000000000000_REALK,      4.705108970360358_REALK,      0.000000000000000_REALK, &
      0.458940964328295_REALK,      0.000000000000000_REALK,      0.651116122410402_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.060923743807084_REALK, &
      0.000000000000000_REALK,     -0.798925237965323_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.491683083619789_REALK,      0.000000000000000_REALK, &
     -0.676079459986054_REALK,      0.000000000000000_REALK,     -0.366865154557458_REALK, &
      0.000000000000000_REALK,     -0.318556041552428_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.732134012460053_REALK, &
      0.000000000000000_REALK,     -0.729260453108563_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.328449478982286_REALK,      0.000000000000000_REALK, &
     -0.694387152059497_REALK,      0.000000000000000_REALK,      0.009733566088232_REALK, &
      0.000000000000000_REALK,     -0.298569798585674_REALK,      0.000000000000000_REALK, &
      2.512868960795084_REALK,      1.126568380607972_REALK,      0.000000000000000_REALK, &
      0.716737440789744_REALK,      0.000000000000000_REALK,      0.719388190958221_REALK, &
      0.550110616055306_REALK,      0.000000000000000_REALK,      0.369567163602001_REALK, &
      0.000000000000000_REALK,      0.532713022835614_REALK,      0.000000000000000_REALK, &
      0.285785241372371_REALK,      0.000000000000000_REALK,      0.478070294860222_REALK, &
      2.130394342692141_REALK,      1.535662224413704_REALK,      0.000000000000000_REALK, &
      1.327250367998279_REALK,      0.000000000000000_REALK,      0.998628630782582_REALK, &
      1.412651647898920_REALK,      0.000000000000000_REALK,      0.615624490290746_REALK, &
      0.000000000000000_REALK,      1.941761509437277_REALK,      0.000000000000000_REALK, &
      0.543395536336612_REALK,      0.000000000000000_REALK,      0.681421724076078_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.928299636498967_REALK, &
      0.000000000000000_REALK,     -0.529527665338113_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.400112992837236_REALK,      0.000000000000000_REALK, &
     -0.507542890928864_REALK,      0.000000000000000_REALK,     -0.368506652553963_REALK, &
      0.000000000000000_REALK,     -0.351898252274117_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.347788030013298_REALK, &
      0.000000000000000_REALK,     -0.806286945192360_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.442071286415826_REALK,      0.000000000000000_REALK, &
     -0.900514129784938_REALK,      0.000000000000000_REALK,     -0.061207926645896_REALK, &
      0.000000000000000_REALK,     -0.550175934633933_REALK,      0.000000000000000_REALK, &
      1.617616242692606_REALK,      1.123593683189747_REALK,      0.000000000000000_REALK, &
      0.982132914711717_REALK,      0.000000000000000_REALK,      0.771822991071707_REALK, &
      1.027438889568688_REALK,      0.000000000000000_REALK,      0.614318872671636_REALK, &
      0.000000000000000_REALK,      1.311631080996048_REALK,      0.000000000000000_REALK, &
      0.652677619718431_REALK,      0.000000000000000_REALK,      0.718082266824657_REALK, &
      3.444445979396402_REALK,      3.935622362150446_REALK,      0.000000000000000_REALK, &
      4.464175430505207_REALK,      0.000000000000000_REALK,      2.690990351159186_REALK, &
      5.414081448633246_REALK,      0.000000000000000_REALK,      2.629555588632940_REALK, &
      0.000000000000000_REALK,      7.343417737356136_REALK,      0.000000000000000_REALK, &
      3.046163533333759_REALK,      0.000000000000000_REALK,      2.570704383240833_REALK, &
     47.042633529543146_REALK,      9.509605675334916_REALK,      0.000000000000000_REALK, &
      4.342885533788503_REALK,      0.000000000000000_REALK,      3.422896164538098_REALK, &
      1.971071057749334_REALK,      0.000000000000000_REALK,      0.796140592044431_REALK, &
      0.000000000000000_REALK,      1.278844132797252_REALK,      0.000000000000000_REALK, &
      0.436706549526230_REALK,      0.000000000000000_REALK,      1.032586165423071_REALK, &
    103.156093382457669_REALK,     17.726213958957704_REALK,      0.000000000000000_REALK, &
      4.917761162733340_REALK,      0.000000000000000_REALK,      6.062381477221383_REALK, &
     -0.844744501616983_REALK,      0.000000000000000_REALK,      1.168684968326301_REALK, &
      0.000000000000000_REALK,     -4.631253416566044_REALK,      0.000000000000000_REALK, &
      0.373472727410518_REALK,      0.000000000000000_REALK,      1.381198112298592_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.792761786060281_REALK, &
      0.000000000000000_REALK,     -1.042050963642632_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.529139071989745_REALK,      0.000000000000000_REALK, &
     -0.952585748640261_REALK,      0.000000000000000_REALK,     -0.311488188100715_REALK, &
      0.000000000000000_REALK,     -0.314355842830062_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -9.612747789405738_REALK, &
      0.000000000000000_REALK,     -2.611985960229853_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.340135304584584_REALK,      0.000000000000000_REALK, &
     -1.901298360462349_REALK,      0.000000000000000_REALK,     -1.019520177263403_REALK, &
      0.000000000000000_REALK,     -0.595091234554482_REALK,      0.000000000000000_REALK, &
      4.820208322388273_REALK,      1.535176951148703_REALK,      0.000000000000000_REALK, &
      0.765203039093121_REALK,      0.000000000000000_REALK,      1.052177865549293_REALK, &
      0.444045601264919_REALK,      0.000000000000000_REALK,      0.385573301935292_REALK, &
      0.000000000000000_REALK,      0.316385653994324_REALK,      0.000000000000000_REALK, &
      0.230839042122644_REALK,      0.000000000000000_REALK,      0.529018047536551_REALK, &
     16.375836100035919_REALK,      4.407932890239096_REALK,      0.000000000000000_REALK, &
      1.365651898083716_REALK,      0.000000000000000_REALK,      2.887175023547962_REALK, &
     -0.028422600221444_REALK,      0.000000000000000_REALK,      0.871841825131018_REALK, &
      0.000000000000000_REALK,     -1.049063821330841_REALK,      0.000000000000000_REALK, &
      0.311137765047862_REALK,      0.000000000000000_REALK,      1.096313032368436_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.382342323419701_REALK, &
      0.000000000000000_REALK,     -0.575154863281723_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.345908238385064_REALK,      0.000000000000000_REALK, &
     -0.578645883619499_REALK,      0.000000000000000_REALK,     -0.258270035928064_REALK, &
      0.000000000000000_REALK,     -0.289178581651311_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.036098581785682_REALK, &
      0.000000000000000_REALK,     -2.559689716291860_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.586747750147331_REALK,      0.000000000000000_REALK, &
     -1.989792545718381_REALK,      0.000000000000000_REALK,     -1.338194470213040_REALK, &
      0.000000000000000_REALK,     -0.971960886299768_REALK,      0.000000000000000_REALK, &
      2.171161182924961_REALK,      1.017515317068929_REALK,      0.000000000000000_REALK, &
      0.622693129577857_REALK,      0.000000000000000_REALK,      0.789885549345437_REALK, &
      0.446032434726147_REALK,      0.000000000000000_REALK,      0.425929988373048_REALK, &
      0.000000000000000_REALK,      0.372413158979728_REALK,      0.000000000000000_REALK, &
      0.313080054627199_REALK,      0.000000000000000_REALK,      0.555998386473827_REALK, &
     12.742175673660286_REALK,      4.873510869174648_REALK,      0.000000000000000_REALK, &
      1.838077177813521_REALK,      0.000000000000000_REALK,      3.744225244024000_REALK, &
      0.178730838591938_REALK,      0.000000000000000_REALK,      1.606546922249312_REALK, &
      0.000000000000000_REALK,     -1.152414132098475_REALK,      0.000000000000000_REALK, &
      0.697951439763999_REALK,      0.000000000000000_REALK,      1.990450892908776_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.483098555351139_REALK, &
      0.000000000000000_REALK,     -0.956060283546587_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.789986790731405_REALK,      0.000000000000000_REALK, &
     -0.869151152593021_REALK,      0.000000000000000_REALK,     -0.803949457855089_REALK, &
      0.000000000000000_REALK,     -0.672968350242781_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -16.265388895872043_REALK, &
      0.000000000000000_REALK,    -10.933363608492401_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -8.894981297939905_REALK,      0.000000000000000_REALK, &
     -7.506611894350304_REALK,      0.000000000000000_REALK,     -8.547865600388061_REALK, &
      0.000000000000000_REALK,     -5.812236694828642_REALK,      0.000000000000000_REALK, &
     18.493261608736802_REALK,      4.259029748003720_REALK,      0.000000000000000_REALK, &
     17.773651145745877_REALK,      0.000000000000000_REALK,      8.014081434880085_REALK, &
      9.106296619621670_REALK,      0.000000000000000_REALK,      2.159014384445270_REALK, &
      0.000000000000000_REALK,    117.870625920888102_REALK,      0.000000000000000_REALK, &
     22.172765707681808_REALK,      0.000000000000000_REALK,     29.992883605191555_REALK, &
      7.211510901217586_REALK,      2.380542571589090_REALK,      0.000000000000000_REALK, &
     14.949251052353748_REALK,      0.000000000000000_REALK,      4.944344124656303_REALK, &
     10.141601224974886_REALK,      0.000000000000000_REALK,      2.018829574478735_REALK, &
      0.000000000000000_REALK,    141.495253110973948_REALK,      0.000000000000000_REALK, &
     22.240612146046264_REALK,      0.000000000000000_REALK,     22.067708865404903_REALK, &
     14.039144287235580_REALK,      3.510543058213750_REALK,      0.000000000000000_REALK, &
      6.874141483659812_REALK,      0.000000000000000_REALK,      5.383530140197364_REALK, &
      4.070034972321750_REALK,      0.000000000000000_REALK,      1.516086610631551_REALK, &
      0.000000000000000_REALK,     22.217674259210654_REALK,      0.000000000000000_REALK, &
      7.363626418299619_REALK,      0.000000000000000_REALK,     17.300620677491739_REALK, &
      7.168079772235083_REALK,      1.674648420178619_REALK,      0.000000000000000_REALK, &
      1.935749185049040_REALK,      0.000000000000000_REALK,      2.568940440171968_REALK, &
     -0.114862946761856_REALK,      0.000000000000000_REALK,      0.785797406335896_REALK, &
      0.000000000000000_REALK,    -10.826236650860800_REALK,      0.000000000000000_REALK, &
      2.284483336297360_REALK,      0.000000000000000_REALK,      9.095240756665365_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.209919780658525_REALK, &
      0.000000000000000_REALK,     -2.532732998123486_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.116650326302171_REALK,      0.000000000000000_REALK, &
     -2.863172222474592_REALK,      0.000000000000000_REALK,    -11.443238403755984_REALK, &
      0.000000000000000_REALK,     -8.139241675406398_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.139207304222840_REALK, &
      0.000000000000000_REALK,     -2.915728025987037_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.034943183670996_REALK,      0.000000000000000_REALK, &
     -3.011348885565755_REALK,      0.000000000000000_REALK,    -17.285931684109016_REALK, &
      0.000000000000000_REALK,    -10.323029667255936_REALK,      0.000000000000000_REALK, &
     14.956772190856501_REALK,      2.514996398571509_REALK,      0.000000000000000_REALK, &
      4.504149282177697_REALK,      0.000000000000000_REALK,      4.827738058796714_REALK, &
      2.160661054348503_REALK,      0.000000000000000_REALK,      0.946217781617092_REALK, &
      0.000000000000000_REALK,     10.153475755808756_REALK,      0.000000000000000_REALK, &
      3.866683829564757_REALK,      0.000000000000000_REALK,     12.433426724456737_REALK, &
      4.184368352804180_REALK,      1.253847069014752_REALK,      0.000000000000000_REALK, &
      2.399813293220593_REALK,      0.000000000000000_REALK,      2.335612263719227_REALK, &
      2.307100166264818_REALK,      0.000000000000000_REALK,      0.636533021786422_REALK, &
      0.000000000000000_REALK,     12.113542022019992_REALK,      0.000000000000000_REALK, &
      2.271880762998839_REALK,      0.000000000000000_REALK,      6.633306749434855_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.374882596059869_REALK, &
      0.000000000000000_REALK,     -1.179463570108471_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.140899002060071_REALK,      0.000000000000000_REALK, &
     -2.680508182343128_REALK,      0.000000000000000_REALK,     -2.718219641669754_REALK, &
      0.000000000000000_REALK,     -3.037607611371717_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.366101804161420_REALK, &
      0.000000000000000_REALK,     -0.711221281175916_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.522582045151969_REALK,      0.000000000000000_REALK, &
     -2.080562129847400_REALK,      0.000000000000000_REALK,      0.098419733646523_REALK, &
      0.000000000000000_REALK,     -2.019919572289525_REALK,      0.000000000000000_REALK, &
      2.300281131486351_REALK,      1.117286122872805_REALK,      0.000000000000000_REALK, &
      1.646681616356769_REALK,      0.000000000000000_REALK,      2.227450138846975_REALK, &
      1.772982296159916_REALK,      0.000000000000000_REALK,      1.261070589067336_REALK, &
      0.000000000000000_REALK,      7.514866069983849_REALK,      0.000000000000000_REALK, &
      4.240887754499437_REALK,      0.000000000000000_REALK,      9.561012405962229_REALK, &
      1.627657912089535_REALK,      1.550515245296332_REALK,      0.000000000000000_REALK, &
      2.746911814651526_REALK,      0.000000000000000_REALK,      2.725556734077892_REALK, &
      3.954205919698200_REALK,      0.000000000000000_REALK,      2.361422326862999_REALK, &
      0.000000000000000_REALK,     16.544282250792527_REALK,      0.000000000000000_REALK, &
      7.801427044750587_REALK,      0.000000000000000_REALK,     12.901295134305094_REALK, &
     20.384132956877604_REALK,      1.142577853558069_REALK,      0.000000000000000_REALK, &
      4.105758421082951_REALK,      0.000000000000000_REALK,      5.368691260624994_REALK, &
      0.530536594627093_REALK,      0.000000000000000_REALK,      0.365094065621853_REALK, &
      0.000000000000000_REALK,      5.758961146528913_REALK,      0.000000000000000_REALK, &
      2.681945928801506_REALK,      0.000000000000000_REALK,     10.520740525421083_REALK, &
     14.215842443962501_REALK,      0.451211668017702_REALK,      0.000000000000000_REALK, &
      1.628906119889113_REALK,      0.000000000000000_REALK,      3.219153617287557_REALK, &
     -0.944860486319781_REALK,      0.000000000000000_REALK,      0.140900861278540_REALK, &
      0.000000000000000_REALK,     -2.730087471205866_REALK,      0.000000000000000_REALK, &
      0.992119783836786_REALK,      0.000000000000000_REALK,      5.882081143764418_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.969672274562980_REALK, &
      0.000000000000000_REALK,     -0.668705517314028_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.885312454588096_REALK,      0.000000000000000_REALK, &
     -2.846746208781455_REALK,      0.000000000000000_REALK,     -0.997440665999004_REALK, &
      0.000000000000000_REALK,     -1.310426860858330_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.656842364695720_REALK, &
      0.000000000000000_REALK,     -0.646415616467520_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.852463556356026_REALK,      0.000000000000000_REALK, &
     -2.488974049218867_REALK,      0.000000000000000_REALK,     -1.427004710117815_REALK, &
      0.000000000000000_REALK,     -1.181139380313954_REALK,      0.000000000000000_REALK, &
      2.397526949958869_REALK,      0.725519947509580_REALK,      0.000000000000000_REALK, &
      0.806289495079867_REALK,      0.000000000000000_REALK,      1.894353124155944_REALK, &
      0.622361126264390_REALK,      0.000000000000000_REALK,      0.695487908770055_REALK, &
      0.000000000000000_REALK,      1.589111881900656_REALK,      0.000000000000000_REALK, &
      1.580042910703818_REALK,      0.000000000000000_REALK,      6.187106166492842_REALK, &
      3.110149285976322_REALK,      0.809039608095026_REALK,      0.000000000000000_REALK, &
      0.530695475819497_REALK,      0.000000000000000_REALK,      2.112864228142975_REALK, &
     -0.036929418799771_REALK,      0.000000000000000_REALK,      0.757921740520478_REALK, &
      0.000000000000000_REALK,     -1.531803162673274_REALK,      0.000000000000000_REALK, &
      0.969693970065706_REALK,      0.000000000000000_REALK,      6.434423616274413_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.370164834906975_REALK, &
      0.000000000000000_REALK,     -0.891216458847982_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.970989848940174_REALK,      0.000000000000000_REALK, &
     -2.189080807887632_REALK,      0.000000000000000_REALK,     -2.455421648009605_REALK, &
      0.000000000000000_REALK,     -2.910782988612606_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.100418126315492_REALK, &
      0.000000000000000_REALK,     -2.398084964822909_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.927280494440090_REALK,      0.000000000000000_REALK, &
     -4.840871981886684_REALK,      0.000000000000000_REALK,     -7.337354339478718_REALK, &
      0.000000000000000_REALK,     -7.303022279406477_REALK,      0.000000000000000_REALK, &
     34.161332748598731_REALK,     -1.445206963281875_REALK,      0.000000000000000_REALK, &
      5.358177774711502_REALK,      0.000000000000000_REALK,      7.252744256260846_REALK, &
     -1.158547343247654_REALK,      0.000000000000000_REALK,     -0.379638493241694_REALK, &
      0.000000000000000_REALK,      5.761151297573705_REALK,      0.000000000000000_REALK, &
      2.563230153700857_REALK,      0.000000000000000_REALK,     10.408642764225633_REALK, &
     12.991396178668937_REALK,     -0.954313670155388_REALK,      0.000000000000000_REALK, &
      3.442263250178515_REALK,      0.000000000000000_REALK,      4.798001345312882_REALK, &
      0.026584830632186_REALK,      0.000000000000000_REALK,     -0.322925964206781_REALK, &
      0.000000000000000_REALK,      6.728462593180709_REALK,      0.000000000000000_REALK, &
      1.635075007402170_REALK,      0.000000000000000_REALK,      6.837151764725930_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.351881237632861_REALK, &
      0.000000000000000_REALK,     -0.273722938831349_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.874263190351438_REALK,      0.000000000000000_REALK, &
     -3.429560632762126_REALK,      0.000000000000000_REALK,     -0.190279609123231_REALK, &
      0.000000000000000_REALK,     -0.392828450308318_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.159225400848544_REALK, &
      0.000000000000000_REALK,     -0.140664607383792_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.540937121835368_REALK,      0.000000000000000_REALK, &
     -3.207108754554845_REALK,      0.000000000000000_REALK,      0.448056186152806_REALK, &
      0.000000000000000_REALK,     -0.200447061055557_REALK,      0.000000000000000_REALK, &
      3.350937737181727_REALK,      0.542055196141361_REALK,      0.000000000000000_REALK, &
      0.663747646626618_REALK,      0.000000000000000_REALK,      2.134298559598445_REALK, &
      0.325146621890412_REALK,      0.000000000000000_REALK,      0.427174148364799_REALK, &
      0.000000000000000_REALK,      0.833776313172467_REALK,      0.000000000000000_REALK, &
      0.952565249128711_REALK,      0.000000000000000_REALK,      5.104998989378992_REALK, &
      2.242672026283245_REALK,      0.634381852447937_REALK,      0.000000000000000_REALK, &
      0.851034197915688_REALK,      0.000000000000000_REALK,      2.484800690676432_REALK, &
      0.778051031047309_REALK,      0.000000000000000_REALK,      0.643996972223014_REALK, &
      0.000000000000000_REALK,      2.155391808844106_REALK,      0.000000000000000_REALK, &
      1.212723705008033_REALK,      0.000000000000000_REALK,      5.901401508861919_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.535569735389426_REALK, &
      0.000000000000000_REALK,     -0.521429988148275_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.515063835243462_REALK,      0.000000000000000_REALK, &
     -2.016878535123303_REALK,      0.000000000000000_REALK,     -0.669638813071810_REALK, &
      0.000000000000000_REALK,     -1.247201124021592_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.073530850546323_REALK, &
      0.000000000000000_REALK,     -0.756650903979900_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.528709812841257_REALK,      0.000000000000000_REALK, &
     -3.508264474070403_REALK,      0.000000000000000_REALK,      0.052536183226521_REALK, &
      0.000000000000000_REALK,     -1.797045856910615_REALK,      0.000000000000000_REALK, &
      1.546075333220000_REALK,      0.722423398487367_REALK,      0.000000000000000_REALK, &
      0.727982785955761_REALK,      0.000000000000000_REALK,      1.641225340252260_REALK, &
      0.800420597818004_REALK,      0.000000000000000_REALK,      0.948859704707900_REALK, &
      0.000000000000000_REALK,      1.851302197347961_REALK,      0.000000000000000_REALK, &
      1.741251883376932_REALK,      0.000000000000000_REALK,      5.495873635818912_REALK, &
      2.617099566788035_REALK,      2.353441877882515_REALK,      0.000000000000000_REALK, &
      2.922372210618726_REALK,      0.000000000000000_REALK,      4.832755105599933_REALK, &
      4.000572716063102_REALK,      0.000000000000000_REALK,      3.981853720570102_REALK, &
      0.000000000000000_REALK,      8.831292378828953_REALK,      0.000000000000000_REALK, &
      6.940633845568767_REALK,      0.000000000000000_REALK,     16.068910368073464_REALK, &
     78.506008625060034_REALK,     -8.897459439187598_REALK,      0.000000000000000_REALK, &
      9.905036674529054_REALK,      0.000000000000000_REALK,     12.321353550156310_REALK, &
     -4.427033386316184_REALK,      0.000000000000000_REALK,     -1.768414677175050_REALK, &
      0.000000000000000_REALK,      8.120915511050548_REALK,      0.000000000000000_REALK, &
      3.267565930866747_REALK,      0.000000000000000_REALK,     12.194049271776889_REALK, &
    136.187305715220447_REALK,    -16.958650002512837_REALK,      0.000000000000000_REALK, &
     11.767020701369532_REALK,      0.000000000000000_REALK,     17.199425275615148_REALK, &
     -7.570542150304189_REALK,      0.000000000000000_REALK,     -2.660076859502300_REALK, &
      0.000000000000000_REALK,      2.139275789930224_REALK,      0.000000000000000_REALK, &
      2.689452203318691_REALK,      0.000000000000000_REALK,     11.793222781855381_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.212530861766741_REALK, &
      0.000000000000000_REALK,      0.346864819192007_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.205896024169987_REALK,      0.000000000000000_REALK, &
     -4.896845064132408_REALK,      0.000000000000000_REALK,      0.349198258901710_REALK, &
      0.000000000000000_REALK,      0.343281010374031_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -16.490887660889971_REALK, &
      0.000000000000000_REALK,      0.715815410675456_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.855797802519054_REALK,      0.000000000000000_REALK, &
     -7.760115690733425_REALK,      0.000000000000000_REALK,     -0.013468811963103_REALK, &
      0.000000000000000_REALK,      0.490817017051695_REALK,      0.000000000000000_REALK, &
      6.655056111229388_REALK,      0.309945863703304_REALK,      0.000000000000000_REALK, &
      0.798789239884629_REALK,      0.000000000000000_REALK,      3.133491334435663_REALK, &
      0.089518853307428_REALK,      0.000000000000000_REALK,      0.184809883624263_REALK, &
      0.000000000000000_REALK,      0.565841254887699_REALK,      0.000000000000000_REALK, &
      0.790536145989806_REALK,      0.000000000000000_REALK,      5.168526813937803_REALK, &
     18.763472046790643_REALK,      0.483468859485709_REALK,      0.000000000000000_REALK, &
      1.199070904587401_REALK,      0.000000000000000_REALK,      7.109053234110681_REALK, &
     -0.508540392277506_REALK,      0.000000000000000_REALK,      0.227505902630930_REALK, &
      0.000000000000000_REALK,     -0.754144607322233_REALK,      0.000000000000000_REALK, &
      0.822173420474035_REALK,      0.000000000000000_REALK,      8.124171516823957_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.416739398165832_REALK, &
      0.000000000000000_REALK,     -0.390296785952428_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.448143388539765_REALK,      0.000000000000000_REALK, &
     -2.401695366994492_REALK,      0.000000000000000_REALK,     -0.294007754401195_REALK, &
      0.000000000000000_REALK,     -0.643773729775504_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.540341300586844_REALK, &
      0.000000000000000_REALK,     -1.427519023680558_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.376432259454818_REALK,      0.000000000000000_REALK, &
     -6.698046207267862_REALK,      0.000000000000000_REALK,     -1.182564205113294_REALK, &
      0.000000000000000_REALK,     -1.631357792661223_REALK,      0.000000000000000_REALK, &
      2.348249456660478_REALK,      0.590433044184864_REALK,      0.000000000000000_REALK, &
      0.470599075869591_REALK,      0.000000000000000_REALK,      1.842764158197202_REALK, &
      0.315037953633346_REALK,      0.000000000000000_REALK,      0.586757640404031_REALK, &
      0.000000000000000_REALK,      0.468410033615308_REALK,      0.000000000000000_REALK, &
      0.776228073623949_REALK,      0.000000000000000_REALK,      4.255357658798035_REALK, &
     12.315246054280877_REALK,      2.600633921921021_REALK,      0.000000000000000_REALK, &
      1.171967180578787_REALK,      0.000000000000000_REALK,      7.776611525906176_REALK, &
     -0.059628171761624_REALK,      0.000000000000000_REALK,      2.039633495211520_REALK, &
      0.000000000000000_REALK,     -1.269411079454107_REALK,      0.000000000000000_REALK, &
      1.339315106184001_REALK,      0.000000000000000_REALK,     12.441872818484436_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.858415695038474_REALK, &
      0.000000000000000_REALK,     -0.866945938757983_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.819188522814092_REALK,      0.000000000000000_REALK, &
     -2.585586064991391_REALK,      0.000000000000000_REALK,     -1.206275603565753_REALK, &
      0.000000000000000_REALK,     -2.001973515627084_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -16.610337472476026_REALK, &
      0.000000000000000_REALK,     -8.826395434757762_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -7.877567072082195_REALK,      0.000000000000000_REALK, &
    -18.238092084427265_REALK,      0.000000000000000_REALK,    -10.134155527050151_REALK, &
      0.000000000000000_REALK,    -14.121431818868079_REALK,      0.000000000000000_REALK/
    ! results of test 2, ket-major order, CM030000
  data REF_CONTR_INTS(1261:2520)                                                           &
     /7.013127527083945_REALK,      7.619013231716389_REALK,      0.000000000000000_REALK, &
     11.318877867400632_REALK,      0.000000000000000_REALK,      1.779019935149369_REALK, &
     20.044020341067124_REALK,      0.000000000000000_REALK,      2.396915301678094_REALK, &
      0.000000000000000_REALK,     60.751486447825805_REALK,      0.000000000000000_REALK, &
      6.046080509012108_REALK,      0.000000000000000_REALK,      2.850838540990649_REALK, &
      6.733865527697717_REALK,      7.314577889626193_REALK,      0.000000000000000_REALK, &
     11.694317957558205_REALK,      0.000000000000000_REALK,      1.409859324619569_REALK, &
     23.376724469153107_REALK,      0.000000000000000_REALK,      2.270759945338901_REALK, &
      0.000000000000000_REALK,     74.426329062159951_REALK,      0.000000000000000_REALK, &
      6.174639047312996_REALK,      0.000000000000000_REALK,      2.233231335578979_REALK, &
      4.368786122961311_REALK,      3.500705181005103_REALK,      0.000000000000000_REALK, &
      3.865420827386808_REALK,      0.000000000000000_REALK,      0.980656412818176_REALK, &
      5.089620979160317_REALK,      0.000000000000000_REALK,      0.972046889732567_REALK, &
      0.000000000000000_REALK,     10.130766575531815_REALK,      0.000000000000000_REALK, &
      1.703345263938726_REALK,      0.000000000000000_REALK,      1.296414955254102_REALK, &
      1.253859241974520_REALK,      1.300113514884639_REALK,      0.000000000000000_REALK, &
      1.104262972839217_REALK,      0.000000000000000_REALK,      0.449884188634984_REALK, &
      0.236177607408798_REALK,      0.000000000000000_REALK,      0.424583033656650_REALK, &
      0.000000000000000_REALK,     -4.113854957977169_REALK,      0.000000000000000_REALK, &
      0.498305411384018_REALK,      0.000000000000000_REALK,      0.609038964106139_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.020503713224634_REALK, &
      0.000000000000000_REALK,     -1.186965186130659_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.802888323955508_REALK,      0.000000000000000_REALK, &
     -0.850095117220694_REALK,      0.000000000000000_REALK,     -4.373972347469389_REALK, &
      0.000000000000000_REALK,     -1.569152455999963_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.867828245223924_REALK, &
      0.000000000000000_REALK,     -1.313688973148308_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.350792305842416_REALK,      0.000000000000000_REALK, &
     -0.850229948765964_REALK,      0.000000000000000_REALK,     -6.102785153501406_REALK, &
      0.000000000000000_REALK,     -1.778430519622148_REALK,      0.000000000000000_REALK, &
      3.630237488062240_REALK,      2.294924020085265_REALK,      0.000000000000000_REALK, &
      2.147549436087988_REALK,      0.000000000000000_REALK,      0.718497279430711_REALK, &
      2.491824833675227_REALK,      0.000000000000000_REALK,      0.558006946904534_REALK, &
      0.000000000000000_REALK,      4.363942447625375_REALK,      0.000000000000000_REALK, &
      0.780376608210309_REALK,      0.000000000000000_REALK,      0.783262718671358_REALK, &
      2.275854011265156_REALK,      1.414019688019895_REALK,      0.000000000000000_REALK, &
      1.475057832659921_REALK,      0.000000000000000_REALK,      0.369946524853455_REALK, &
      2.243875576738350_REALK,      0.000000000000000_REALK,      0.325955508389719_REALK, &
      0.000000000000000_REALK,      5.463564537638595_REALK,      0.000000000000000_REALK, &
      0.509653488651171_REALK,      0.000000000000000_REALK,      0.383465379115228_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.630344081581095_REALK, &
      0.000000000000000_REALK,     -0.528871882678467_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.604127886725306_REALK,      0.000000000000000_REALK, &
     -0.459801335535293_REALK,      0.000000000000000_REALK,     -1.006259001486696_REALK, &
      0.000000000000000_REALK,     -0.576544463722668_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.413675780914639_REALK, &
      0.000000000000000_REALK,     -0.298692671343571_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.234064065320264_REALK,      0.000000000000000_REALK, &
     -0.286077840257019_REALK,      0.000000000000000_REALK,     -0.057407231495663_REALK, &
      0.000000000000000_REALK,     -0.309607715604502_REALK,      0.000000000000000_REALK, &
      0.778967681580850_REALK,      0.762954762076273_REALK,      0.000000000000000_REALK, &
      0.980916612378344_REALK,      0.000000000000000_REALK,      0.462520285645863_REALK, &
      1.551322991770541_REALK,      0.000000000000000_REALK,      0.556533532726681_REALK, &
      0.000000000000000_REALK,      3.581592279907964_REALK,      0.000000000000000_REALK, &
      1.069336564795516_REALK,      0.000000000000000_REALK,      0.840353208348667_REALK, &
      1.226542279318011_REALK,      1.207958238085582_REALK,      0.000000000000000_REALK, &
      1.653774121774744_REALK,      0.000000000000000_REALK,      0.598133779548483_REALK, &
      2.866600823854721_REALK,      0.000000000000000_REALK,      0.835364553148701_REALK, &
      0.000000000000000_REALK,      6.887429539259326_REALK,      0.000000000000000_REALK, &
      1.714207535341797_REALK,      0.000000000000000_REALK,      1.033318696655051_REALK, &
      3.560711068048706_REALK,      1.731029586691009_REALK,      0.000000000000000_REALK, &
      1.352270637954572_REALK,      0.000000000000000_REALK,      0.619804662204115_REALK, &
      1.264580326615202_REALK,      0.000000000000000_REALK,      0.366019774175203_REALK, &
      0.000000000000000_REALK,      1.665951963887718_REALK,      0.000000000000000_REALK, &
      0.405166659435067_REALK,      0.000000000000000_REALK,      0.557116698623366_REALK, &
      0.998162160730069_REALK,      0.631223155554352_REALK,      0.000000000000000_REALK, &
      0.383255162396655_REALK,      0.000000000000000_REALK,      0.270084622606517_REALK, &
     -0.015183016473144_REALK,      0.000000000000000_REALK,      0.155242526367603_REALK, &
      0.000000000000000_REALK,     -1.170431374754741_REALK,      0.000000000000000_REALK, &
      0.115711232141278_REALK,      0.000000000000000_REALK,      0.244629381653580_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.519565612937804_REALK, &
      0.000000000000000_REALK,     -0.338805517036113_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.328366239735891_REALK,      0.000000000000000_REALK, &
     -0.329580654967699_REALK,      0.000000000000000_REALK,     -0.453313298855020_REALK, &
      0.000000000000000_REALK,     -0.304538224116135_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.288126376460119_REALK, &
      0.000000000000000_REALK,     -0.239449574541176_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.282540619571635_REALK,      0.000000000000000_REALK, &
     -0.212584723173834_REALK,      0.000000000000000_REALK,     -0.497670641071732_REALK, &
      0.000000000000000_REALK,     -0.216881660243797_REALK,      0.000000000000000_REALK, &
      0.534615735634721_REALK,      0.382442149408176_REALK,      0.000000000000000_REALK, &
      0.366808804358701_REALK,      0.000000000000000_REALK,      0.279177938705093_REALK, &
      0.423412850977629_REALK,      0.000000000000000_REALK,      0.242597914393326_REALK, &
      0.000000000000000_REALK,      0.653656305995717_REALK,      0.000000000000000_REALK, &
      0.329709217390503_REALK,      0.000000000000000_REALK,      0.418235779282336_REALK, &
      0.258892788234387_REALK,      0.232631559665298_REALK,      0.000000000000000_REALK, &
      0.171945371112750_REALK,      0.000000000000000_REALK,      0.210155114339410_REALK, &
      0.031825299180437_REALK,      0.000000000000000_REALK,      0.171639668400126_REALK, &
      0.000000000000000_REALK,     -0.428579472317104_REALK,      0.000000000000000_REALK, &
      0.155739669321301_REALK,      0.000000000000000_REALK,      0.317246962427562_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.334461441382445_REALK, &
      0.000000000000000_REALK,     -0.337910902990347_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.449954577187133_REALK,      0.000000000000000_REALK, &
     -0.353603145163826_REALK,      0.000000000000000_REALK,     -0.846651016739323_REALK, &
      0.000000000000000_REALK,     -0.506223487771555_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.465846026281682_REALK, &
      0.000000000000000_REALK,     -0.613665612912665_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.950318735954605_REALK,      0.000000000000000_REALK, &
     -0.572849026385647_REALK,      0.000000000000000_REALK,     -1.907355850512320_REALK, &
      0.000000000000000_REALK,     -0.926380270376712_REALK,      0.000000000000000_REALK, &
      4.100284278113774_REALK,      1.513756454671704_REALK,      0.000000000000000_REALK, &
      1.037264787752418_REALK,      0.000000000000000_REALK,      0.622447359420894_REALK, &
      0.820113603462510_REALK,      0.000000000000000_REALK,      0.275887939341377_REALK, &
      0.000000000000000_REALK,      0.951852859037254_REALK,      0.000000000000000_REALK, &
      0.255861203841790_REALK,      0.000000000000000_REALK,      0.460615647778800_REALK, &
      2.683063490695676_REALK,      0.946494792205342_REALK,      0.000000000000000_REALK, &
      0.694646059390850_REALK,      0.000000000000000_REALK,      0.328506484706745_REALK, &
      0.799334802862877_REALK,      0.000000000000000_REALK,      0.155523204368172_REALK, &
      0.000000000000000_REALK,      1.597877821880888_REALK,      0.000000000000000_REALK, &
      0.155858576936773_REALK,      0.000000000000000_REALK,      0.221122192498122_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.509489167999453_REALK, &
      0.000000000000000_REALK,     -0.251944860602205_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.202591137092946_REALK,      0.000000000000000_REALK, &
     -0.278569084694551_REALK,      0.000000000000000_REALK,     -0.214714898435048_REALK, &
      0.000000000000000_REALK,     -0.186441059495848_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.348737980165484_REALK, &
      0.000000000000000_REALK,     -0.150636901156564_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.081313821159577_REALK,      0.000000000000000_REALK, &
     -0.171908547010114_REALK,      0.000000000000000_REALK,      0.003305566242604_REALK, &
      0.000000000000000_REALK,     -0.101395751394670_REALK,      0.000000000000000_REALK, &
      0.498141531633661_REALK,      0.278503456838321_REALK,      0.000000000000000_REALK, &
      0.226026549202582_REALK,      0.000000000000000_REALK,      0.226862475832449_REALK, &
      0.226665384566547_REALK,      0.000000000000000_REALK,      0.152274980369755_REALK, &
      0.000000000000000_REALK,      0.311780557984997_REALK,      0.000000000000000_REALK, &
      0.167261317443801_REALK,      0.000000000000000_REALK,      0.279799848883302_REALK, &
      0.561588843128981_REALK,      0.309181471240708_REALK,      0.000000000000000_REALK, &
      0.274158404781078_REALK,      0.000000000000000_REALK,      0.206277910321453_REALK, &
      0.349728377752212_REALK,      0.000000000000000_REALK,      0.152409374677854_REALK, &
      0.000000000000000_REALK,      0.659431624401708_REALK,      0.000000000000000_REALK, &
      0.184539759119509_REALK,      0.000000000000000_REALK,      0.231414121778695_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.229488650841768_REALK, &
      0.000000000000000_REALK,     -0.166989059162020_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.164860962040417_REALK,      0.000000000000000_REALK, &
     -0.209125948852516_REALK,      0.000000000000000_REALK,     -0.215675616756814_REALK, &
      0.000000000000000_REALK,     -0.205955230574165_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.271355952770943_REALK, &
      0.000000000000000_REALK,     -0.166547584404235_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.109443027995606_REALK,      0.000000000000000_REALK, &
     -0.222939141593077_REALK,      0.000000000000000_REALK,     -0.020786508692337_REALK, &
      0.000000000000000_REALK,     -0.186842415260112_REALK,      0.000000000000000_REALK, &
      0.320670056935807_REALK,      0.277768070040427_REALK,      0.000000000000000_REALK, &
      0.309720269846603_REALK,      0.000000000000000_REALK,      0.243398038582903_REALK, &
      0.423341822945841_REALK,      0.000000000000000_REALK,      0.253121498579851_REALK, &
      0.000000000000000_REALK,      0.767657355411798_REALK,      0.000000000000000_REALK, &
      0.381992149125526_REALK,      0.000000000000000_REALK,      0.420271478699723_REALK, &
      0.907983275220810_REALK,      0.792375753491019_REALK,      0.000000000000000_REALK, &
      0.922125353437292_REALK,      0.000000000000000_REALK,      0.555854147599703_REALK, &
      1.340357281191755_REALK,      0.000000000000000_REALK,      0.650995743777069_REALK, &
      0.000000000000000_REALK,      2.493860272577155_REALK,      0.000000000000000_REALK, &
      1.034491907073419_REALK,      0.000000000000000_REALK,      0.873023674152633_REALK, &
      5.448588428703844_REALK,      1.475649414286650_REALK,      0.000000000000000_REALK, &
      0.912013210398870_REALK,      0.000000000000000_REALK,      0.718813907388238_REALK, &
      0.569710047410256_REALK,      0.000000000000000_REALK,      0.230113111678871_REALK, &
      0.000000000000000_REALK,      0.541021581819082_REALK,      0.000000000000000_REALK, &
      0.184750949827356_REALK,      0.000000000000000_REALK,      0.436840883305877_REALK, &
      1.738280360528735_REALK,      0.611516941966486_REALK,      0.000000000000000_REALK, &
      0.289771569574122_REALK,      0.000000000000000_REALK,      0.357216574347651_REALK, &
     -0.080671151764411_REALK,      0.000000000000000_REALK,      0.111606719267389_REALK, &
      0.000000000000000_REALK,     -0.730668076249314_REALK,      0.000000000000000_REALK, &
      0.058922407116077_REALK,      0.000000000000000_REALK,      0.217910202024896_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.588540355847250_REALK, &
      0.000000000000000_REALK,     -0.218832441554568_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.152940120856989_REALK,      0.000000000000000_REALK, &
     -0.275331358494937_REALK,      0.000000000000000_REALK,     -0.131776678582085_REALK, &
      0.000000000000000_REALK,     -0.132989854651000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.331619495605938_REALK, &
      0.000000000000000_REALK,     -0.153907285521913_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.127979830983270_REALK,      0.000000000000000_REALK, &
     -0.181569608671840_REALK,      0.000000000000000_REALK,     -0.160848647140272_REALK, &
      0.000000000000000_REALK,     -0.093886930477485_REALK,      0.000000000000000_REALK, &
      0.558287861856482_REALK,      0.238220494742981_REALK,      0.000000000000000_REALK, &
      0.160693915338243_REALK,      0.000000000000000_REALK,      0.220959107856830_REALK, &
      0.128345063743067_REALK,      0.000000000000000_REALK,      0.111444477489568_REALK, &
      0.000000000000000_REALK,      0.133848576694382_REALK,      0.000000000000000_REALK, &
      0.097657642954205_REALK,      0.000000000000000_REALK,      0.223803803410374_REALK, &
      0.275948742789155_REALK,      0.152064374698036_REALK,      0.000000000000000_REALK, &
      0.080468953433202_REALK,      0.000000000000000_REALK,      0.170122381003085_REALK, &
     -0.002714292773276_REALK,      0.000000000000000_REALK,      0.083258883668467_REALK, &
      0.000000000000000_REALK,     -0.165509717402360_REALK,      0.000000000000000_REALK, &
      0.049087884377659_REALK,      0.000000000000000_REALK,      0.172964176709131_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.214504439988369_REALK, &
      0.000000000000000_REALK,     -0.120783481226248_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.099979855173245_REALK,      0.000000000000000_REALK, &
     -0.167249360440124_REALK,      0.000000000000000_REALK,     -0.109262465839866_REALK, &
      0.000000000000000_REALK,     -0.122338484934031_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.208232652200192_REALK, &
      0.000000000000000_REALK,     -0.150825809177844_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.151530750799740_REALK,      0.000000000000000_REALK, &
     -0.190020599279523_REALK,      0.000000000000000_REALK,     -0.211125561754085_REALK, &
      0.000000000000000_REALK,     -0.153345266843292_REALK,      0.000000000000000_REALK, &
      0.251468993348485_REALK,      0.157892549167932_REALK,      0.000000000000000_REALK, &
      0.130766596490102_REALK,      0.000000000000000_REALK,      0.165877283686494_REALK, &
      0.128919329688956_REALK,      0.000000000000000_REALK,      0.123109003562021_REALK, &
      0.000000000000000_REALK,      0.157551300580113_REALK,      0.000000000000000_REALK, &
      0.132450125896043_REALK,      0.000000000000000_REALK,      0.235217974438341_REALK, &
      0.214718035529032_REALK,      0.168125831621935_REALK,      0.000000000000000_REALK, &
      0.108305891886250_REALK,      0.000000000000000_REALK,      0.220622756961391_REALK, &
      0.017068382898535_REALK,      0.000000000000000_REALK,      0.153421526074857_REALK, &
      0.000000000000000_REALK,     -0.181815189367733_REALK,      0.000000000000000_REALK, &
      0.110115078994302_REALK,      0.000000000000000_REALK,      0.314031385021629_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.230139249644145_REALK, &
      0.000000000000000_REALK,     -0.200774255215413_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.228334442957611_REALK,      0.000000000000000_REALK, &
     -0.251215775506263_REALK,      0.000000000000000_REALK,     -0.340114949301887_REALK, &
      0.000000000000000_REALK,     -0.284702718669977_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.561121562705326_REALK, &
      0.000000000000000_REALK,     -0.644231760900834_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.849450200450151_REALK,      0.000000000000000_REALK, &
     -0.716864124248823_REALK,      0.000000000000000_REALK,     -1.348587942074701_REALK, &
      0.000000000000000_REALK,     -0.916990590349733_REALK,      0.000000000000000_REALK, &
     62.303562399123912_REALK,    -25.610925055313754_REALK,      0.000000000000000_REALK, &
     54.872746972354328_REALK,      0.000000000000000_REALK,     24.741942957357551_REALK, &
    -43.722845405317273_REALK,      0.000000000000000_REALK,    -10.366261511353958_REALK, &
      0.000000000000000_REALK,    355.687227286053940_REALK,      0.000000000000000_REALK, &
     66.908693274623957_REALK,      0.000000000000000_REALK,     90.506735876706799_REALK, &
     41.293262004080553_REALK,    -24.962030887493949_REALK,      0.000000000000000_REALK, &
     51.061478039039116_REALK,      0.000000000000000_REALK,     16.888171725421618_REALK, &
    -57.514777276591886_REALK,      0.000000000000000_REALK,    -11.449132218845330_REALK, &
      0.000000000000000_REALK,    431.665661228058468_REALK,      0.000000000000000_REALK, &
     67.850393119620932_REALK,      0.000000000000000_REALK,     67.322909636425791_REALK, &
     26.806670934527911_REALK,     -4.200636385240346_REALK,      0.000000000000000_REALK, &
     14.857397408270078_REALK,      0.000000000000000_REALK,     11.635670715018192_REALK, &
     -4.243881394660786_REALK,      0.000000000000000_REALK,     -1.580844342446337_REALK, &
      0.000000000000000_REALK,     59.182970955202293_REALK,      0.000000000000000_REALK, &
     19.615072367825316_REALK,      0.000000000000000_REALK,     46.085027582870993_REALK, &
      9.612361021266313_REALK,     -2.237704754527885_REALK,      0.000000000000000_REALK, &
      3.833953160534612_REALK,      0.000000000000000_REALK,      5.088054483449505_REALK, &
      0.132080459440986_REALK,      0.000000000000000_REALK,     -0.903585406628681_REALK, &
      0.000000000000000_REALK,    -27.567436244812271_REALK,      0.000000000000000_REALK, &
      5.817104387858189_REALK,      0.000000000000000_REALK,     23.159707087194946_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.644340002432563_REALK, &
      0.000000000000000_REALK,     -5.474112043170483_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.207060381516138_REALK,      0.000000000000000_REALK, &
      2.985469021102288_REALK,      0.000000000000000_REALK,    -30.482256521615192_REALK, &
      0.000000000000000_REALK,    -21.681139891285039_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.858459302800795_REALK, &
      0.000000000000000_REALK,     -5.774903467263577_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.489869460755214_REALK,      0.000000000000000_REALK, &
      3.462738468370098_REALK,      0.000000000000000_REALK,    -44.016109660411566_REALK, &
      0.000000000000000_REALK,    -26.286092885541770_REALK,      0.000000000000000_REALK, &
     15.888362959125210_REALK,     -0.111962316050346_REALK,      0.000000000000000_REALK, &
      6.693714246025866_REALK,      0.000000000000000_REALK,      7.174606567352650_REALK, &
      0.137855008239085_REALK,      0.000000000000000_REALK,      0.060370810969296_REALK, &
      0.000000000000000_REALK,     23.505162572940641_REALK,      0.000000000000000_REALK, &
      8.951322110567336_REALK,      0.000000000000000_REALK,     28.783219020334563_REALK, &
      6.406735002992360_REALK,     -0.121938531306970_REALK,      0.000000000000000_REALK, &
      3.021963098048022_REALK,      0.000000000000000_REALK,      2.941117999573944_REALK, &
     -0.012299047122467_REALK,      0.000000000000000_REALK,     -0.003393328882912_REALK, &
      0.000000000000000_REALK,     25.090969474969260_REALK,      0.000000000000000_REALK, &
      4.705782237065959_REALK,      0.000000000000000_REALK,     13.739672249919140_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.105724746148165_REALK, &
      0.000000000000000_REALK,     -1.752826473390437_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.072791908296963_REALK,      0.000000000000000_REALK, &
     -0.171022417800402_REALK,      0.000000000000000_REALK,     -6.292642649966994_REALK, &
      0.000000000000000_REALK,     -7.032021590955866_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.132855474747922_REALK, &
      0.000000000000000_REALK,     -0.895604867400195_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.002785861356460_REALK,      0.000000000000000_REALK, &
      0.011091383048895_REALK,      0.000000000000000_REALK,      0.203858337071895_REALK, &
      0.000000000000000_REALK,     -4.183891073154340_REALK,      0.000000000000000_REALK, &
      2.443555404783461_REALK,     -0.049739213176926_REALK,      0.000000000000000_REALK, &
      2.447169377287383_REALK,      0.000000000000000_REALK,      3.310262114470490_REALK, &
      0.113120236305909_REALK,      0.000000000000000_REALK,      0.080459124348110_REALK, &
      0.000000000000000_REALK,     17.396815921660327_REALK,      0.000000000000000_REALK, &
      9.817599265559325_REALK,      0.000000000000000_REALK,     22.133617725484374_REALK, &
      2.492125940894548_REALK,     -0.150789961912235_REALK,      0.000000000000000_REALK, &
      3.459046652053860_REALK,      0.000000000000000_REALK,      3.432155282782895_REALK, &
     -0.021079693742575_REALK,      0.000000000000000_REALK,     -0.012588636115074_REALK, &
      0.000000000000000_REALK,     34.268431164503369_REALK,      0.000000000000000_REALK, &
     16.159218128373247_REALK,      0.000000000000000_REALK,     26.722654844799806_REALK, &
     12.780931161898202_REALK,      0.334588099571270_REALK,      0.000000000000000_REALK, &
      4.235724416341450_REALK,      0.000000000000000_REALK,      5.538634845064798_REALK, &
      0.246471055046588_REALK,      0.000000000000000_REALK,      0.169611522478135_REALK, &
      0.000000000000000_REALK,     11.346581669950277_REALK,      0.000000000000000_REALK, &
      5.284098597171210_REALK,      0.000000000000000_REALK,     20.728467958495646_REALK, &
      3.066352215249809_REALK,      0.054231333375614_REALK,      0.000000000000000_REALK, &
      1.063797137383087_REALK,      0.000000000000000_REALK,      2.102347312133639_REALK, &
     -0.308409699246821_REALK,      0.000000000000000_REALK,      0.045991120255002_REALK, &
      0.000000000000000_REALK,     -4.355104401311574_REALK,      0.000000000000000_REALK, &
      1.582654505684174_REALK,      0.000000000000000_REALK,      9.383244217726586_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.869627395281052_REALK, &
      0.000000000000000_REALK,     -0.689873099324283_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.411289055152897_REALK,      0.000000000000000_REALK, &
     -1.322511111644265_REALK,      0.000000000000000_REALK,     -1.965205475384862_REALK, &
      0.000000000000000_REALK,     -2.581865899232102_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.319327079105178_REALK, &
      0.000000000000000_REALK,     -0.422157590275787_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.278250633655621_REALK,      0.000000000000000_REALK, &
     -0.812420192257818_REALK,      0.000000000000000_REALK,     -2.276393910185383_REALK, &
      0.000000000000000_REALK,     -1.884183334058398_REALK,      0.000000000000000_REALK, &
      1.503258783243034_REALK,      0.212458468088049_REALK,      0.000000000000000_REALK, &
      0.831812238005129_REALK,      0.000000000000000_REALK,      1.954318047539585_REALK, &
      0.289129920468890_REALK,      0.000000000000000_REALK,      0.323102384232680_REALK, &
      0.000000000000000_REALK,      3.130944504034718_REALK,      0.000000000000000_REALK, &
      3.113076381689531_REALK,      0.000000000000000_REALK,     12.190133538420730_REALK, &
      0.670858107101589_REALK,      0.097238834477472_REALK,      0.000000000000000_REALK, &
      0.346583711059645_REALK,      0.000000000000000_REALK,      1.379857862975326_REALK, &
     -0.012054045131847_REALK,      0.000000000000000_REALK,      0.247391460888583_REALK, &
      0.000000000000000_REALK,     -2.443571045273046_REALK,      0.000000000000000_REALK, &
      1.546880281858926_REALK,      0.000000000000000_REALK,     10.264354862872727_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.401233794951732_REALK, &
      0.000000000000000_REALK,     -0.919427527835910_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.451092148838530_REALK,      0.000000000000000_REALK, &
     -1.016979906318320_REALK,      0.000000000000000_REALK,     -4.837789586425196_REALK, &
      0.000000000000000_REALK,     -5.734964356149796_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.372640649455491_REALK, &
      0.000000000000000_REALK,     -1.566128268309099_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.955486772886178_REALK,      0.000000000000000_REALK, &
     -1.580097690232702_REALK,      0.000000000000000_REALK,    -11.704732729216186_REALK, &
      0.000000000000000_REALK,    -11.649965360952828_REALK,      0.000000000000000_REALK, &
     13.748454593446121_REALK,     -0.507199132505874_REALK,      0.000000000000000_REALK, &
      3.894889578857044_REALK,      0.000000000000000_REALK,      5.272060616418543_REALK, &
     -0.668454351409719_REALK,      0.000000000000000_REALK,     -0.219042410523048_REALK, &
      0.000000000000000_REALK,      9.377565530082277_REALK,      0.000000000000000_REALK, &
      4.172231815042892_REALK,      0.000000000000000_REALK,     16.942399975131682_REALK, &
      6.321871482645241_REALK,     -0.274763588197084_REALK,      0.000000000000000_REALK, &
      1.625476081426160_REALK,      0.000000000000000_REALK,      2.265671117702045_REALK, &
      0.010613950528600_REALK,      0.000000000000000_REALK,     -0.128927667658018_REALK, &
      0.000000000000000_REALK,      7.894009682979136_REALK,      0.000000000000000_REALK, &
      1.918313100813171_REALK,      0.000000000000000_REALK,      8.021526684185702_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.527304008751492_REALK, &
      0.000000000000000_REALK,     -0.198970744677420_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.504429134703767_REALK,      0.000000000000000_REALK, &
     -1.978775180621393_REALK,      0.000000000000000_REALK,     -0.309722729264726_REALK, &
      0.000000000000000_REALK,     -0.639416384776829_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.909596219992507_REALK, &
      0.000000000000000_REALK,     -0.066423436613600_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.215968268885362_REALK,      0.000000000000000_REALK, &
     -1.280432970653287_REALK,      0.000000000000000_REALK,      0.525671328780762_REALK, &
      0.000000000000000_REALK,     -0.235169776005141_REALK,      0.000000000000000_REALK, &
      1.348607083457475_REALK,      0.190235677130195_REALK,      0.000000000000000_REALK, &
      0.482481899730566_REALK,      0.000000000000000_REALK,      1.551433634244651_REALK, &
      0.187601892590380_REALK,      0.000000000000000_REALK,      0.246469356602850_REALK, &
      0.000000000000000_REALK,      1.357157903056300_REALK,      0.000000000000000_REALK, &
      1.550513531756342_REALK,      0.000000000000000_REALK,      8.309530522843007_REALK, &
      1.091328763506225_REALK,      0.182649625083257_REALK,      0.000000000000000_REALK, &
      0.401868082900374_REALK,      0.000000000000000_REALK,      1.173351308792633_REALK, &
      0.310635612711562_REALK,      0.000000000000000_REALK,      0.257114747064351_REALK, &
      0.000000000000000_REALK,      2.528762488309537_REALK,      0.000000000000000_REALK, &
      1.422799419263210_REALK,      0.000000000000000_REALK,      6.923679816741236_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.538912181770249_REALK, &
      0.000000000000000_REALK,     -0.379030392856202_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.297179622333891_REALK,      0.000000000000000_REALK, &
     -1.163691100692325_REALK,      0.000000000000000_REALK,     -1.089987317936268_REALK, &
      0.000000000000000_REALK,     -2.030099482829131_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.597005779704164_REALK, &
      0.000000000000000_REALK,     -0.357299211890615_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.211086535593284_REALK,      0.000000000000000_REALK, &
     -1.400668903413870_REALK,      0.000000000000000_REALK,      0.061636835065003_REALK, &
      0.000000000000000_REALK,     -2.108341571161788_REALK,      0.000000000000000_REALK, &
      0.622228256527672_REALK,      0.253536365603071_REALK,      0.000000000000000_REALK, &
      0.529174784007438_REALK,      0.000000000000000_REALK,      1.193015936215147_REALK, &
      0.461823709395914_REALK,      0.000000000000000_REALK,      0.547469555030306_REALK, &
      0.000000000000000_REALK,      3.013409434139880_REALK,      0.000000000000000_REALK, &
      2.834277872136973_REALK,      0.000000000000000_REALK,      8.945766653732640_REALK, &
      1.273532643526513_REALK,      0.677597057658194_REALK,      0.000000000000000_REALK, &
      1.379977585717445_REALK,      0.000000000000000_REALK,      2.282082240844149_REALK, &
      1.597222170862796_REALK,      0.000000000000000_REALK,      1.589748642260840_REALK, &
      0.000000000000000_REALK,     10.361105020090472_REALK,      0.000000000000000_REALK, &
      8.142934589316377_REALK,      0.000000000000000_REALK,     18.852469235551112_REALK, &
     18.753445713973839_REALK,     -2.519674224293877_REALK,      0.000000000000000_REALK, &
      4.866139596553249_REALK,      0.000000000000000_REALK,      6.053226087262147_REALK, &
     -2.373158895192499_REALK,      0.000000000000000_REALK,     -0.947977721265643_REALK, &
      0.000000000000000_REALK,     10.382240445437988_REALK,      0.000000000000000_REALK, &
      4.177442200872172_REALK,      0.000000000000000_REALK,     15.589566394433287_REALK, &
      5.023221526694780_REALK,     -1.239005236378358_REALK,      0.000000000000000_REALK, &
      1.918252406944977_REALK,      0.000000000000000_REALK,      2.803839626897154_REALK, &
     -1.790120673336685_REALK,      0.000000000000000_REALK,     -0.628998357623338_REALK, &
      0.000000000000000_REALK,      1.444497442274111_REALK,      0.000000000000000_REALK, &
      1.815991583272689_REALK,      0.000000000000000_REALK,      7.963106124392918_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.325709093707433_REALK, &
      0.000000000000000_REALK,      0.170407509510990_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.646433542896232_REALK,      0.000000000000000_REALK, &
     -2.625006501700532_REALK,      0.000000000000000_REALK,      0.446434922529671_REALK, &
      0.000000000000000_REALK,      0.438869975337920_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.204830346834352_REALK, &
      0.000000000000000_REALK,      0.116691783698204_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.438819564816592_REALK,      0.000000000000000_REALK, &
     -1.834946989220332_REALK,      0.000000000000000_REALK,     -0.009094509704056_REALK, &
      0.000000000000000_REALK,      0.331413055340053_REALK,      0.000000000000000_REALK, &
      1.589753901531951_REALK,      0.087773662699723_REALK,      0.000000000000000_REALK, &
      0.392428627699966_REALK,      0.000000000000000_REALK,      1.539419464964156_REALK, &
      0.047987544812878_REALK,      0.000000000000000_REALK,      0.099069327237978_REALK, &
      0.000000000000000_REALK,      0.723403654944870_REALK,      0.000000000000000_REALK, &
      1.010666388205568_REALK,      0.000000000000000_REALK,      6.607738752850792_REALK, &
      0.692084157227297_REALK,      0.035322413543525_REALK,      0.000000000000000_REALK, &
      0.195471794194665_REALK,      0.000000000000000_REALK,      1.158913443217247_REALK, &
     -0.120248807994040_REALK,      0.000000000000000_REALK,      0.053795753529935_REALK, &
      0.000000000000000_REALK,     -0.509219036418539_REALK,      0.000000000000000_REALK, &
      0.555153949093789_REALK,      0.000000000000000_REALK,      5.485662499378424_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.684397159662685_REALK, &
      0.000000000000000_REALK,     -0.191744736232476_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.240232086824135_REALK,      0.000000000000000_REALK, &
     -1.287454651085958_REALK,      0.000000000000000_REALK,     -0.375876241399488_REALK, &
      0.000000000000000_REALK,     -0.823036964969121_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.623960491567285_REALK, &
      0.000000000000000_REALK,     -0.232713264693778_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.325469404195655_REALK,      0.000000000000000_REALK, &
     -1.583811403270873_REALK,      0.000000000000000_REALK,     -0.798499650045956_REALK, &
      0.000000000000000_REALK,     -1.101537338021264_REALK,      0.000000000000000_REALK, &
      0.560947747562515_REALK,      0.167204912005736_REALK,      0.000000000000000_REALK, &
      0.231195589924382_REALK,      0.000000000000000_REALK,      0.905311906655699_REALK, &
      0.168879485819812_REALK,      0.000000000000000_REALK,      0.314537748450478_REALK, &
      0.000000000000000_REALK,      0.598842038121476_REALK,      0.000000000000000_REALK, &
      0.992374134405991_REALK,      0.000000000000000_REALK,      5.440291348291835_REALK, &
      0.454243578441635_REALK,      0.190003275419086_REALK,      0.000000000000000_REALK, &
      0.191053361939282_REALK,      0.000000000000000_REALK,      1.267738381365247_REALK, &
     -0.014099600908961_REALK,      0.000000000000000_REALK,      0.482289116594033_REALK, &
      0.000000000000000_REALK,     -0.857141031603822_REALK,      0.000000000000000_REALK, &
      0.904342139703721_REALK,      0.000000000000000_REALK,      8.401092345361764_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.526285301643273_REALK, &
      0.000000000000000_REALK,     -0.425912603787692_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.439134824635592_REALK,      0.000000000000000_REALK, &
     -1.386031238975131_REALK,      0.000000000000000_REALK,     -1.542171365118088_REALK, &
      0.000000000000000_REALK,     -2.559436848758740_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.213557394212392_REALK, &
      0.000000000000000_REALK,     -1.438873502228278_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.862719392000751_REALK,      0.000000000000000_REALK, &
     -4.312555829471152_REALK,      0.000000000000000_REALK,     -6.842858600718072_REALK, &
      0.000000000000000_REALK,     -9.535176455331412_REALK,      0.000000000000000_REALK/
    ! results of test 2, ket-major order, CM020100
  data REF_CONTR_INTS(2521:3780)                                                           &
     /2.437451181495476_REALK,      1.501987809788685_REALK,      0.000000000000000_REALK, &
      1.107154195696193_REALK,      0.000000000000000_REALK,      0.547131872513034_REALK, &
      0.448582047051994_REALK,      0.000000000000000_REALK,      0.417059564696657_REALK, &
      0.000000000000000_REALK,     -2.082311492406181_REALK,      0.000000000000000_REALK, &
      0.487881123402526_REALK,      0.000000000000000_REALK,      0.723301181484846_REALK, &
      0.270817966712200_REALK,     -0.399579848778321_REALK,      0.000000000000000_REALK, &
     -1.821390023259121_REALK,      0.000000000000000_REALK,      0.097169376867400_REALK, &
     -5.478139993129083_REALK,      0.000000000000000_REALK,     -0.130492316586232_REALK, &
      0.000000000000000_REALK,    -20.027179921188058_REALK,      0.000000000000000_REALK, &
     -0.821913373131847_REALK,      0.000000000000000_REALK,      0.131544824479653_REALK, &
      2.369759897762771_REALK,      1.339017461693874_REALK,      0.000000000000000_REALK, &
      1.164206212471702_REALK,      0.000000000000000_REALK,      0.469023320112152_REALK, &
      1.274840570682943_REALK,      0.000000000000000_REALK,      0.325579861952858_REALK, &
      0.000000000000000_REALK,      2.238713005625605_REALK,      0.000000000000000_REALK, &
      0.423049304513805_REALK,      0.000000000000000_REALK,      0.511301143857342_REALK, &
      1.453180533581448_REALK,      0.928137973911452_REALK,      0.000000000000000_REALK, &
      1.146816075883075_REALK,      0.000000000000000_REALK,      0.236218617592388_REALK, &
      2.181572498276204_REALK,      0.000000000000000_REALK,      0.213951536676096_REALK, &
      0.000000000000000_REALK,      6.399860507280921_REALK,      0.000000000000000_REALK, &
      0.396241286933872_REALK,      0.000000000000000_REALK,      0.244850689663923_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.351684171107253_REALK, &
      0.000000000000000_REALK,     -0.226914030074071_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.173037491748907_REALK,      0.000000000000000_REALK, &
     -0.256534258489637_REALK,      0.000000000000000_REALK,     -0.088688278478817_REALK, &
      0.000000000000000_REALK,     -0.247368090581101_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.089348812143350_REALK, &
      0.000000000000000_REALK,      0.091800885907449_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.386069227949993_REALK,      0.000000000000000_REALK, &
     -0.061789247489869_REALK,      0.000000000000000_REALK,      1.331560829163928_REALK, &
      0.000000000000000_REALK,      0.095155540470499_REALK,      0.000000000000000_REALK, &
      2.459288048981949_REALK,      1.074232642438035_REALK,      0.000000000000000_REALK, &
      0.779223569873577_REALK,      0.000000000000000_REALK,      0.428082528835227_REALK, &
      0.644412709225132_REALK,      0.000000000000000_REALK,      0.227142500752060_REALK, &
      0.000000000000000_REALK,      0.705810668873246_REALK,      0.000000000000000_REALK, &
      0.233470580442604_REALK,      0.000000000000000_REALK,      0.384785626418027_REALK, &
      0.621540930698909_REALK,      0.275213747751048_REALK,      0.000000000000000_REALK, &
     -0.023069936135675_REALK,      0.000000000000000_REALK,      0.168177731341305_REALK, &
     -0.617922582743138_REALK,      0.000000000000000_REALK,      0.067685852643424_REALK, &
      0.000000000000000_REALK,     -2.485541829124530_REALK,      0.000000000000000_REALK, &
     -0.006965204901576_REALK,      0.000000000000000_REALK,      0.152327126323899_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.339163968706014_REALK, &
      0.000000000000000_REALK,     -0.197682580973954_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.178010345113580_REALK,      0.000000000000000_REALK, &
     -0.215144882886916_REALK,      0.000000000000000_REALK,     -0.231919265271205_REALK, &
      0.000000000000000_REALK,     -0.177688671291870_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.183974736257554_REALK, &
      0.000000000000000_REALK,     -0.157170543558570_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.219667403840307_REALK,      0.000000000000000_REALK, &
     -0.135739805771322_REALK,      0.000000000000000_REALK,     -0.483852400292059_REALK, &
      0.000000000000000_REALK,     -0.142357356423454_REALK,      0.000000000000000_REALK, &
      0.298275017314338_REALK,      0.164087924192330_REALK,      0.000000000000000_REALK, &
      0.105063310024795_REALK,      0.000000000000000_REALK,      0.155760107588638_REALK, &
      0.037318182280638_REALK,      0.000000000000000_REALK,      0.104087345622837_REALK, &
      0.000000000000000_REALK,     -0.134354693488454_REALK,      0.000000000000000_REALK, &
      0.094437050891658_REALK,      0.000000000000000_REALK,      0.233343831824939_REALK, &
      0.055917615118965_REALK,     -0.071497513384724_REALK,      0.000000000000000_REALK, &
     -0.283609603141107_REALK,      0.000000000000000_REALK,      0.045390885080484_REALK, &
     -0.738187866946589_REALK,      0.000000000000000_REALK,     -0.052752126609321_REALK, &
      0.000000000000000_REALK,     -2.086422173435828_REALK,      0.000000000000000_REALK, &
     -0.256879644527205_REALK,      0.000000000000000_REALK,      0.068521389350656_REALK, &
      2.948296582425308_REALK,      0.988687355581749_REALK,      0.000000000000000_REALK, &
      0.655720214521080_REALK,      0.000000000000000_REALK,      0.447568826463051_REALK, &
      0.489489097780887_REALK,      0.000000000000000_REALK,      0.180192075378123_REALK, &
      0.000000000000000_REALK,      0.564872557348326_REALK,      0.000000000000000_REALK, &
      0.161745935514014_REALK,      0.000000000000000_REALK,      0.331204240497828_REALK, &
      1.900386229099689_REALK,      0.658222535731058_REALK,      0.000000000000000_REALK, &
      0.558663293844992_REALK,      0.000000000000000_REALK,      0.232677758790113_REALK, &
      0.803967428179222_REALK,      0.000000000000000_REALK,      0.108155775168839_REALK, &
      0.000000000000000_REALK,      1.906495952632401_REALK,      0.000000000000000_REALK, &
      0.125347959278494_REALK,      0.000000000000000_REALK,      0.156618570909332_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.351890562868235_REALK, &
      0.000000000000000_REALK,     -0.156350530016504_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.116739789092141_REALK,      0.000000000000000_REALK, &
     -0.192400227851281_REALK,      0.000000000000000_REALK,     -0.109415753589872_REALK, &
      0.000000000000000_REALK,     -0.115700548125248_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.217154022953119_REALK, &
      0.000000000000000_REALK,     -0.065677796753976_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.004894662473346_REALK,      0.000000000000000_REALK, &
     -0.107044929679175_REALK,      0.000000000000000_REALK,      0.134530844623107_REALK, &
      0.000000000000000_REALK,     -0.044208620203189_REALK,      0.000000000000000_REALK, &
      0.325178677416417_REALK,      0.162498186687140_REALK,      0.000000000000000_REALK, &
      0.122531061843461_REALK,      0.000000000000000_REALK,      0.148092128766452_REALK, &
      0.115964101613311_REALK,      0.000000000000000_REALK,      0.088847759625008_REALK, &
      0.000000000000000_REALK,      0.159944178558548_REALK,      0.000000000000000_REALK, &
      0.090673891646933_REALK,      0.000000000000000_REALK,      0.182648783575221_REALK, &
      0.358586258464748_REALK,      0.202941349911583_REALK,      0.000000000000000_REALK, &
      0.213150467039273_REALK,      0.000000000000000_REALK,      0.131712773448222_REALK, &
      0.340017877408335_REALK,      0.000000000000000_REALK,      0.100038867504527_REALK, &
      0.000000000000000_REALK,      0.772439015076527_REALK,      0.000000000000000_REALK, &
      0.143474484668993_REALK,      0.000000000000000_REALK,      0.147762771821073_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.128037255061347_REALK, &
      0.000000000000000_REALK,     -0.071647144863945_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.047220345204420_REALK,      0.000000000000000_REALK, &
     -0.116676412340921_REALK,      0.000000000000000_REALK,     -0.019008922287163_REALK, &
      0.000000000000000_REALK,     -0.088365694821464_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.058609503303539_REALK, &
      0.000000000000000_REALK,      0.051187113916390_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.180517181332212_REALK,      0.000000000000000_REALK, &
     -0.048152075612350_REALK,      0.000000000000000_REALK,      0.482143103380326_REALK, &
      0.000000000000000_REALK,      0.057424573454754_REALK,      0.000000000000000_REALK, &
      4.027121316504255_REALK,      0.984367051775506_REALK,      0.000000000000000_REALK, &
      0.599508700220931_REALK,      0.000000000000000_REALK,      0.531284542211517_REALK, &
      0.341974592648295_REALK,      0.000000000000000_REALK,      0.153502426203122_REALK, &
      0.000000000000000_REALK,      0.305512738122438_REALK,      0.000000000000000_REALK, &
      0.121445391944641_REALK,      0.000000000000000_REALK,      0.322874677744771_REALK, &
      1.240835906300001_REALK,      0.348967679643669_REALK,      0.000000000000000_REALK, &
      0.073611236523223_REALK,      0.000000000000000_REALK,      0.254991750376347_REALK, &
     -0.326949469015083_REALK,      0.000000000000000_REALK,      0.063689384843760_REALK, &
      0.000000000000000_REALK,     -1.181291300217180_REALK,      0.000000000000000_REALK, &
      0.014968173907170_REALK,      0.000000000000000_REALK,      0.155550743804833_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.423188101621591_REALK, &
      0.000000000000000_REALK,     -0.142927131566224_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.096683055321417_REALK,      0.000000000000000_REALK, &
     -0.197976151950754_REALK,      0.000000000000000_REALK,     -0.078651600504338_REALK, &
      0.000000000000000_REALK,     -0.086860331665845_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.234882672339263_REALK, &
      0.000000000000000_REALK,     -0.107032013887446_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.102926710597821_REALK,      0.000000000000000_REALK, &
     -0.128603883262382_REALK,      0.000000000000000_REALK,     -0.161780861666867_REALK, &
      0.000000000000000_REALK,     -0.065291952961415_REALK,      0.000000000000000_REALK, &
      0.385594517588236_REALK,      0.147833539945339_REALK,      0.000000000000000_REALK, &
      0.092597208615155_REALK,      0.000000000000000_REALK,      0.152610555274232_REALK, &
      0.065402875959424_REALK,      0.000000000000000_REALK,      0.069159589448493_REALK, &
      0.000000000000000_REALK,      0.056707369415341_REALK,      0.000000000000000_REALK, &
      0.056273600145100_REALK,      0.000000000000000_REALK,      0.154575310527922_REALK, &
      0.171829232930367_REALK,      0.066300176240069_REALK,      0.000000000000000_REALK, &
     -0.004843805899442_REALK,      0.000000000000000_REALK,      0.105932710316362_REALK, &
     -0.110467034251739_REALK,      0.000000000000000_REALK,      0.036300932889326_REALK, &
      0.000000000000000_REALK,     -0.351478381905431_REALK,      0.000000000000000_REALK, &
     -0.002954831320591_REALK,      0.000000000000000_REALK,      0.107702254802700_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.140025004272608_REALK, &
      0.000000000000000_REALK,     -0.070473440092414_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.054199994914549_REALK,      0.000000000000000_REALK, &
     -0.109177658101106_REALK,      0.000000000000000_REALK,     -0.055899685412508_REALK, &
      0.000000000000000_REALK,     -0.071380736847991_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.132960917148257_REALK, &
      0.000000000000000_REALK,     -0.098999442603171_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.117810906908244_REALK,      0.000000000000000_REALK, &
     -0.121332139269768_REALK,      0.000000000000000_REALK,     -0.205263484295027_REALK, &
      0.000000000000000_REALK,     -0.100653170873560_REALK,      0.000000000000000_REALK, &
      0.140300618454462_REALK,      0.067744260611687_REALK,      0.000000000000000_REALK, &
      0.037454857420739_REALK,      0.000000000000000_REALK,      0.092546938606105_REALK, &
      0.011362515411901_REALK,      0.000000000000000_REALK,      0.052820278505229_REALK, &
      0.000000000000000_REALK,     -0.032383618889599_REALK,      0.000000000000000_REALK, &
      0.037937062781707_REALK,      0.000000000000000_REALK,      0.131233782924371_REALK, &
      0.046376419179907_REALK,     -0.051672176010864_REALK,      0.000000000000000_REALK, &
     -0.178641569801616_REALK,      0.000000000000000_REALK,      0.047651765406007_REALK, &
     -0.395901169464643_REALK,      0.000000000000000_REALK,     -0.047152921253780_REALK, &
      0.000000000000000_REALK,     -0.885117620107567_REALK,      0.000000000000000_REALK, &
     -0.181625673615531_REALK,      0.000000000000000_REALK,      0.067826864713656_REALK, &
      6.491028630539452_REALK,      1.084569195232545_REALK,      0.000000000000000_REALK, &
      0.663251430915509_REALK,      0.000000000000000_REALK,      0.727989139312299_REALK, &
      0.291576043187979_REALK,      0.000000000000000_REALK,      0.142253520309227_REALK, &
      0.000000000000000_REALK,      0.269860451886634_REALK,      0.000000000000000_REALK, &
      0.109339758672502_REALK,      0.000000000000000_REALK,      0.360036117971447_REALK, &
      5.855127610265785_REALK,      0.981059532428710_REALK,      0.000000000000000_REALK, &
      0.683713088966150_REALK,      0.000000000000000_REALK,      0.516036639900558_REALK, &
      0.712250242431175_REALK,      0.000000000000000_REALK,      0.108474733931233_REALK, &
      0.000000000000000_REALK,      1.429077409791635_REALK,      0.000000000000000_REALK, &
      0.095971729123629_REALK,      0.000000000000000_REALK,      0.217305750416266_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.594797584970999_REALK, &
      0.000000000000000_REALK,     -0.143916315920696_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.088032546298649_REALK,      0.000000000000000_REALK, &
     -0.234043297667355_REALK,      0.000000000000000_REALK,     -0.052855300370187_REALK, &
      0.000000000000000_REALK,     -0.071175610869397_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.538850575915445_REALK, &
      0.000000000000000_REALK,     -0.098621419383673_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.017199648276786_REALK,      0.000000000000000_REALK, &
     -0.178740446177868_REALK,      0.000000000000000_REALK,      0.071064753896759_REALK, &
      0.000000000000000_REALK,     -0.041529999789194_REALK,      0.000000000000000_REALK, &
      0.551664499520554_REALK,      0.160013525574356_REALK,      0.000000000000000_REALK, &
      0.090645271726214_REALK,      0.000000000000000_REALK,      0.185612691171449_REALK, &
      0.057012460925790_REALK,      0.000000000000000_REALK,      0.062962752612097_REALK, &
      0.000000000000000_REALK,      0.052186980636392_REALK,      0.000000000000000_REALK, &
      0.044829750860847_REALK,      0.000000000000000_REALK,      0.152995123065367_REALK, &
      0.753169714522225_REALK,      0.226180895027066_REALK,      0.000000000000000_REALK, &
      0.159379436880276_REALK,      0.000000000000000_REALK,      0.199139896494554_REALK, &
      0.185899357920508_REALK,      0.000000000000000_REALK,      0.075025760203309_REALK, &
      0.000000000000000_REALK,      0.340267392689466_REALK,      0.000000000000000_REALK, &
      0.067115521368530_REALK,      0.000000000000000_REALK,      0.139764767652628_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.170854565691576_REALK, &
      0.000000000000000_REALK,     -0.064840625455941_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.040791241485913_REALK,      0.000000000000000_REALK, &
     -0.112047546331608_REALK,      0.000000000000000_REALK,     -0.030325837605117_REALK, &
      0.000000000000000_REALK,     -0.053446234784149_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.223857838059496_REALK, &
      0.000000000000000_REALK,     -0.056211086592832_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.003395341325307_REALK,      0.000000000000000_REALK, &
     -0.123758643687045_REALK,      0.000000000000000_REALK,      0.072032347626561_REALK, &
      0.000000000000000_REALK,     -0.039451308328684_REALK,      0.000000000000000_REALK, &
      0.182535434258227_REALK,      0.078898271342662_REALK,      0.000000000000000_REALK, &
      0.050815246273050_REALK,      0.000000000000000_REALK,      0.102359596023381_REALK, &
      0.040520200605056_REALK,      0.000000000000000_REALK,      0.051742004540336_REALK, &
      0.000000000000000_REALK,      0.044330373147468_REALK,      0.000000000000000_REALK, &
      0.041885524142102_REALK,      0.000000000000000_REALK,      0.118120837795914_REALK, &
      0.426349611122108_REALK,      0.209206402102393_REALK,      0.000000000000000_REALK, &
      0.182427242572230_REALK,      0.000000000000000_REALK,      0.187879782808333_REALK, &
      0.235864425135440_REALK,      0.000000000000000_REALK,      0.115658673376259_REALK, &
      0.000000000000000_REALK,      0.413589878292892_REALK,      0.000000000000000_REALK, &
      0.128035123149291_REALK,      0.000000000000000_REALK,      0.184606723787121_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.103610572500819_REALK, &
      0.000000000000000_REALK,     -0.049521692108753_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.027499571472319_REALK,      0.000000000000000_REALK, &
     -0.095127891525953_REALK,      0.000000000000000_REALK,     -0.008780903288838_REALK, &
      0.000000000000000_REALK,     -0.057146999286917_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.100698086093049_REALK, &
      0.000000000000000_REALK,      0.073015119137078_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.208702659629373_REALK,      0.000000000000000_REALK, &
     -0.077938579817888_REALK,      0.000000000000000_REALK,      0.430259441316693_REALK, &
      0.000000000000000_REALK,      0.071743120677189_REALK,      0.000000000000000_REALK, &
     18.923042036934813_REALK,     -2.187583224517802_REALK,      0.000000000000000_REALK, &
      7.268169195928910_REALK,      0.000000000000000_REALK,      8.213712422776760_REALK, &
     -1.048552843141997_REALK,      0.000000000000000_REALK,     -0.823263012304650_REALK, &
      0.000000000000000_REALK,      5.919371865791701_REALK,      0.000000000000000_REALK, &
      9.595601493461293_REALK,      0.000000000000000_REALK,     32.531787194086590_REALK, &
      5.507895275701661_REALK,     -0.061649281704229_REALK,      0.000000000000000_REALK, &
     -2.734892538089308_REALK,      0.000000000000000_REALK,      2.915461788201989_REALK, &
      4.546191535708308_REALK,      0.000000000000000_REALK,     -0.024893986199191_REALK, &
      0.000000000000000_REALK,    -90.975464543830839_REALK,      0.000000000000000_REALK, &
     -4.149543491402888_REALK,      0.000000000000000_REALK,     13.270542062452693_REALK, &
     11.934351899084822_REALK,     -0.062570188282263_REALK,      0.000000000000000_REALK, &
      4.413854472779361_REALK,      0.000000000000000_REALK,      5.389119051002966_REALK, &
      0.066358143046408_REALK,      0.000000000000000_REALK,      0.033738253569202_REALK, &
      0.000000000000000_REALK,     14.306281573175852_REALK,      0.000000000000000_REALK, &
      5.902527607669219_REALK,      0.000000000000000_REALK,     21.620167254538682_REALK, &
      4.735201987627029_REALK,     -0.077528938737641_REALK,      0.000000000000000_REALK, &
      2.443752967160602_REALK,      0.000000000000000_REALK,      2.173773035863581_REALK, &
     -0.012479694285412_REALK,      0.000000000000000_REALK,     -0.002157490206419_REALK, &
      0.000000000000000_REALK,     29.357922754295711_REALK,      0.000000000000000_REALK, &
      3.805396999079719_REALK,      0.000000000000000_REALK,     10.154957761913638_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.074631938467566_REALK, &
      0.000000000000000_REALK,     -0.912826875983037_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.035609460463269_REALK,      0.000000000000000_REALK, &
     -0.120726083787107_REALK,      0.000000000000000_REALK,     -1.554748525677607_REALK, &
      0.000000000000000_REALK,     -3.662095705515789_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.076126358560218_REALK, &
      0.000000000000000_REALK,     -0.024674120504196_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.001987252091226_REALK,      0.000000000000000_REALK, &
      0.006355376807098_REALK,      0.000000000000000_REALK,      7.016776367997944_REALK, &
      0.000000000000000_REALK,     -0.115267163314010_REALK,      0.000000000000000_REALK, &
      9.906353797703202_REALK,      0.105402586307136_REALK,      0.000000000000000_REALK, &
      3.073517870955990_REALK,      0.000000000000000_REALK,      4.292932622551587_REALK, &
     -0.018823027848735_REALK,      0.000000000000000_REALK,      0.053431347856047_REALK, &
      0.000000000000000_REALK,      7.539408710814247_REALK,      0.000000000000000_REALK, &
      3.834237045177490_REALK,      0.000000000000000_REALK,     16.066398815555093_REALK, &
      2.329934869479855_REALK,     -0.022235912898836_REALK,      0.000000000000000_REALK, &
      0.545017235484868_REALK,      0.000000000000000_REALK,      1.597446074830109_REALK, &
     -0.543451263237690_REALK,      0.000000000000000_REALK,     -0.018857263512720_REALK, &
      0.000000000000000_REALK,     -8.470352850092041_REALK,      0.000000000000000_REALK, &
      0.810844429923517_REALK,      0.000000000000000_REALK,      7.129757561117395_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.653210112525025_REALK, &
      0.000000000000000_REALK,     -0.385535877055083_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.271205188773874_REALK,      0.000000000000000_REALK, &
     -0.993388245058163_REALK,      0.000000000000000_REALK,     -0.945974961062015_REALK, &
      0.000000000000000_REALK,     -1.442876863692811_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.236013854010777_REALK, &
      0.000000000000000_REALK,     -0.268409251803503_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.225011288870291_REALK,      0.000000000000000_REALK, &
     -0.600457753812319_REALK,      0.000000000000000_REALK,     -2.309829354210094_REALK, &
      0.000000000000000_REALK,     -1.197970261827719_REALK,      0.000000000000000_REALK, &
      1.061162321019866_REALK,      0.110642897426023_REALK,      0.000000000000000_REALK, &
      0.406918649271663_REALK,      0.000000000000000_REALK,      1.379568640114066_REALK, &
      0.071436492199449_REALK,      0.000000000000000_REALK,      0.168263398858474_REALK, &
      0.000000000000000_REALK,      0.313151308753437_REALK,      0.000000000000000_REALK, &
      1.522902379213142_REALK,      0.000000000000000_REALK,      8.605112135959704_REALK, &
      0.384402561513886_REALK,      0.002678952300192_REALK,      0.000000000000000_REALK, &
     -0.247230251782250_REALK,      0.000000000000000_REALK,      0.790660337018882_REALK, &
     -0.414898601817271_REALK,      0.000000000000000_REALK,      0.006815691763035_REALK, &
      0.000000000000000_REALK,     -8.064043715033666_REALK,      0.000000000000000_REALK, &
     -1.103443668462435_REALK,      0.000000000000000_REALK,      5.881488588731164_REALK, &
     10.894987231048578_REALK,     -0.639363467453256_REALK,      0.000000000000000_REALK, &
      3.058084353218117_REALK,      0.000000000000000_REALK,      4.177853787623176_REALK, &
     -0.751396361193191_REALK,      0.000000000000000_REALK,     -0.276119784392009_REALK, &
      0.000000000000000_REALK,      7.452738117780738_REALK,      0.000000000000000_REALK, &
      3.275840450225454_REALK,      0.000000000000000_REALK,     13.426034914525600_REALK, &
      5.020428440730737_REALK,     -0.311862840066489_REALK,      0.000000000000000_REALK, &
      1.389465907599489_REALK,      0.000000000000000_REALK,      1.799251969591462_REALK, &
      0.127350308122991_REALK,      0.000000000000000_REALK,     -0.146335796758257_REALK, &
      0.000000000000000_REALK,      8.660456607952852_REALK,      0.000000000000000_REALK, &
      1.639784604731166_REALK,      0.000000000000000_REALK,      6.370186552181498_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.183795896847283_REALK, &
      0.000000000000000_REALK,     -0.062680146470629_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.366022858843590_REALK,      0.000000000000000_REALK, &
     -1.533726046799101_REALK,      0.000000000000000_REALK,      0.023653566773730_REALK, &
      0.000000000000000_REALK,     -0.201430178685361_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.691146939861557_REALK, &
      0.000000000000000_REALK,      0.027234914929189_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.110647438993780_REALK,      0.000000000000000_REALK, &
     -0.972923270692739_REALK,      0.000000000000000_REALK,      0.926289764463966_REALK, &
      0.000000000000000_REALK,      0.096424231716206_REALK,      0.000000000000000_REALK, &
      1.012989919036071_REALK,      0.106313289649060_REALK,      0.000000000000000_REALK, &
      0.318149955747695_REALK,      0.000000000000000_REALK,      1.165340632435498_REALK, &
      0.090304395780085_REALK,      0.000000000000000_REALK,      0.137739505509281_REALK, &
      0.000000000000000_REALK,      0.826026326775381_REALK,      0.000000000000000_REALK, &
      1.022413093195733_REALK,      0.000000000000000_REALK,      6.241603469842611_REALK, &
      0.806598388679349_REALK,      0.116129261536575_REALK,      0.000000000000000_REALK, &
      0.324976278045644_REALK,      0.000000000000000_REALK,      0.867221048940625_REALK, &
      0.315198197242485_REALK,      0.000000000000000_REALK,      0.163474442902010_REALK, &
      0.000000000000000_REALK,      2.958802124796852_REALK,      0.000000000000000_REALK, &
      1.150566763950471_REALK,      0.000000000000000_REALK,      5.117274620319637_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.380422391678614_REALK, &
      0.000000000000000_REALK,     -0.197389265090408_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.145378878773390_REALK,      0.000000000000000_REALK, &
     -0.821458795468875_REALK,      0.000000000000000_REALK,     -0.269307550076372_REALK, &
      0.000000000000000_REALK,     -1.057223516975553_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.342085082564446_REALK, &
      0.000000000000000_REALK,     -0.009843675633245_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.150575389659871_REALK,      0.000000000000000_REALK, &
     -0.802585090059295_REALK,      0.000000000000000_REALK,      2.121531519850343_REALK, &
      0.000000000000000_REALK,     -0.058085296188555_REALK,      0.000000000000000_REALK, &
     15.108342313925929_REALK,     -2.359376474008500_REALK,      0.000000000000000_REALK, &
      3.996918163238737_REALK,      0.000000000000000_REALK,      4.876661773244014_REALK, &
     -2.189113604400357_REALK,      0.000000000000000_REALK,     -0.887668854915222_REALK, &
      0.000000000000000_REALK,      8.705066952032828_REALK,      0.000000000000000_REALK, &
      3.431240365642742_REALK,      0.000000000000000_REALK,     12.559425569311291_REALK, &
      4.060388586621453_REALK,     -1.164082102752939_REALK,      0.000000000000000_REALK, &
      1.532680402781545_REALK,      0.000000000000000_REALK,      2.266409784889808_REALK, &
     -1.793251962937833_REALK,      0.000000000000000_REALK,     -0.590962579714817_REALK, &
      0.000000000000000_REALK,     -0.057577960586397_REALK,      0.000000000000000_REALK, &
      1.450974179008612_REALK,      0.000000000000000_REALK,      6.436766734198837_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.843012296898804_REALK, &
      0.000000000000000_REALK,      0.214811755735324_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.507549254709918_REALK,      0.000000000000000_REALK, &
     -2.080191058788536_REALK,      0.000000000000000_REALK,      0.501828697189153_REALK, &
      0.000000000000000_REALK,      0.553229316081151_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.956799668596188_REALK, &
      0.000000000000000_REALK,      0.132447793811904_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.375105381043403_REALK,      0.000000000000000_REALK, &
     -1.457198248525664_REALK,      0.000000000000000_REALK,     -0.109119465925366_REALK, &
      0.000000000000000_REALK,      0.376161256852295_REALK,      0.000000000000000_REALK, &
      1.232200095623984_REALK,      0.027650627951370_REALK,      0.000000000000000_REALK, &
      0.284753275179400_REALK,      0.000000000000000_REALK,      1.193186448610915_REALK, &
     -0.003664815295388_REALK,      0.000000000000000_REALK,      0.031209009907917_REALK, &
      0.000000000000000_REALK,      0.480676557590064_REALK,      0.000000000000000_REALK, &
      0.733357721229508_REALK,      0.000000000000000_REALK,      5.121582853342923_REALK, &
      0.525872729988093_REALK,     -0.014482884008964_REALK,      0.000000000000000_REALK, &
      0.100146440654388_REALK,      0.000000000000000_REALK,      0.880587960062783_REALK, &
     -0.211891411867978_REALK,      0.000000000000000_REALK,     -0.022057316598392_REALK, &
      0.000000000000000_REALK,     -0.990393000716567_REALK,      0.000000000000000_REALK, &
      0.284423091556643_REALK,      0.000000000000000_REALK,      4.168221861772831_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.514076658694253_REALK, &
      0.000000000000000_REALK,     -0.107156627974755_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.158409730675815_REALK,      0.000000000000000_REALK, &
     -0.967056008205597_REALK,      0.000000000000000_REALK,     -0.180932486335752_REALK, &
      0.000000000000000_REALK,     -0.459954560409622_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.461167655364264_REALK, &
      0.000000000000000_REALK,     -0.147959896256756_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.263195411862202_REALK,      0.000000000000000_REALK, &
     -1.170591089110407_REALK,      0.000000000000000_REALK,     -0.810227932323204_REALK, &
      0.000000000000000_REALK,     -0.700361238415159_REALK,      0.000000000000000_REALK, &
      0.395977472681141_REALK,      0.087076011112491_REALK,      0.000000000000000_REALK, &
      0.113099799295108_REALK,      0.000000000000000_REALK,      0.639066869139567_REALK, &
      0.041725733718078_REALK,      0.000000000000000_REALK,      0.163803157161030_REALK, &
      0.000000000000000_REALK,      0.059895078859640_REALK,      0.000000000000000_REALK, &
      0.485464776658085_REALK,      0.000000000000000_REALK,      3.840344895057449_REALK, &
      0.260282156920787_REALK,      0.005234634027271_REALK,      0.000000000000000_REALK, &
     -0.136285028028814_REALK,      0.000000000000000_REALK,      0.726415729298882_REALK, &
     -0.485306354781590_REALK,      0.000000000000000_REALK,      0.013287176313866_REALK, &
      0.000000000000000_REALK,     -2.828656347918840_REALK,      0.000000000000000_REALK, &
     -0.645098796514913_REALK,      0.000000000000000_REALK,      4.813836760539776_REALK, &
     25.537282688686165_REALK,     -6.129677995338668_REALK,      0.000000000000000_REALK, &
      6.545480703225678_REALK,      0.000000000000000_REALK,      6.725907188738252_REALK, &
     -4.885971019778482_REALK,      0.000000000000000_REALK,     -1.958649078749424_REALK, &
      0.000000000000000_REALK,     12.478455761996061_REALK,      0.000000000000000_REALK, &
      4.275610867391134_REALK,      0.000000000000000_REALK,     13.180404850202141_REALK, &
     19.214860786202085_REALK,     -4.696824605877476_REALK,      0.000000000000000_REALK, &
      4.357765372089804_REALK,      0.000000000000000_REALK,      4.351172914964987_REALK, &
     -2.776918996172474_REALK,      0.000000000000000_REALK,     -1.466687763527454_REALK, &
      0.000000000000000_REALK,     10.426376739180260_REALK,      0.000000000000000_REALK, &
      2.654189327536864_REALK,      0.000000000000000_REALK,      7.950522155553218_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.999766574749389_REALK, &
      0.000000000000000_REALK,      0.627328160981277_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.785613710426090_REALK,      0.000000000000000_REALK, &
     -2.875594791062879_REALK,      0.000000000000000_REALK,      1.010575410301437_REALK, &
      0.000000000000000_REALK,      1.229341842467074_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.578122073510410_REALK, &
      0.000000000000000_REALK,      0.600137663248782_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.544439932307785_REALK,      0.000000000000000_REALK, &
     -2.415227573134793_REALK,      0.000000000000000_REALK,      1.109175507400391_REALK, &
      0.000000000000000_REALK,      1.096579676627209_REALK,      0.000000000000000_REALK, &
      1.860585301459293_REALK,     -0.132136521801347_REALK,      0.000000000000000_REALK, &
      0.358692251960332_REALK,      0.000000000000000_REALK,      1.470100504454604_REALK, &
     -0.114898247509749_REALK,      0.000000000000000_REALK,     -0.126666887016989_REALK, &
      0.000000000000000_REALK,      0.533054655383181_REALK,      0.000000000000000_REALK, &
      0.702910249101250_REALK,      0.000000000000000_REALK,      4.801463771717863_REALK, &
      2.178307500247758_REALK,     -0.150664095738903_REALK,      0.000000000000000_REALK, &
      0.380929139303654_REALK,      0.000000000000000_REALK,      1.479822211725200_REALK, &
      0.040944212172307_REALK,      0.000000000000000_REALK,     -0.141144626954977_REALK, &
      0.000000000000000_REALK,      1.225367156665843_REALK,      0.000000000000000_REALK, &
      0.696038889034564_REALK,      0.000000000000000_REALK,      4.506585354696882_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.733961261292471_REALK, &
      0.000000000000000_REALK,     -0.022055849637137_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.167908924776482_REALK,      0.000000000000000_REALK, &
     -1.172633007281516_REALK,      0.000000000000000_REALK,      0.005075440872559_REALK, &
      0.000000000000000_REALK,     -0.072036138118638_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.001700254138173_REALK, &
      0.000000000000000_REALK,      0.022399770975830_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.106722291102156_REALK,      0.000000000000000_REALK, &
     -1.564015722056458_REALK,      0.000000000000000_REALK,      0.393181943970798_REALK, &
      0.000000000000000_REALK,      0.068215275475934_REALK,      0.000000000000000_REALK, &
      0.518978346807174_REALK,      0.065914940549116_REALK,      0.000000000000000_REALK, &
      0.111950401860038_REALK,      0.000000000000000_REALK,      0.683432187390930_REALK, &
      0.041426139465523_REALK,      0.000000000000000_REALK,      0.105310782785431_REALK, &
      0.000000000000000_REALK,      0.177243788255290_REALK,      0.000000000000000_REALK, &
      0.365638809817051_REALK,      0.000000000000000_REALK,      3.125000521757650_REALK, &
      1.049921938231377_REALK,      0.168309666273523_REALK,      0.000000000000000_REALK, &
      0.267281694094754_REALK,      0.000000000000000_REALK,      1.188765287266720_REALK, &
      0.304016740621339_REALK,      0.000000000000000_REALK,      0.262792150784016_REALK, &
      0.000000000000000_REALK,      1.255921867954324_REALK,      0.000000000000000_REALK, &
      0.813967893333439_REALK,      0.000000000000000_REALK,      5.068298791468806_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.393107318533467_REALK, &
      0.000000000000000_REALK,     -0.115762012799886_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.111151578971382_REALK,      0.000000000000000_REALK, &
     -0.879281915814378_REALK,      0.000000000000000_REALK,     -0.096310672017010_REALK, &
      0.000000000000000_REALK,     -0.529322962941504_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.826323835493705_REALK, &
      0.000000000000000_REALK,     -0.013493468483278_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.242056371634666_REALK,      0.000000000000000_REALK, &
     -1.806265747499183_REALK,      0.000000000000000_REALK,      1.500876434083585_REALK, &
      0.000000000000000_REALK,     -0.057529380054294_REALK,      0.000000000000000_REALK/
    ! results of test 2, ket-major order, CM010200
  data REF_CONTR_INTS(3781:5040)                                                           &
     /1.666509039228760_REALK,      0.928882953426401_REALK,      0.000000000000000_REALK, &
      0.882551866294805_REALK,      0.000000000000000_REALK,      0.329835779276164_REALK, &
      1.167579677551918_REALK,      0.000000000000000_REALK,      0.225856340487418_REALK, &
      0.000000000000000_REALK,      2.675539741103298_REALK,      0.000000000000000_REALK, &
      0.320701735855454_REALK,      0.000000000000000_REALK,      0.359567219789101_REALK, &
      1.275493317157132_REALK,      1.077469966560440_REALK,      0.000000000000000_REALK, &
      1.688223580902664_REALK,      0.000000000000000_REALK,      0.207335056563569_REALK, &
      3.626692505897314_REALK,      0.000000000000000_REALK,      0.248375092440665_REALK, &
      0.000000000000000_REALK,     10.957961858702989_REALK,      0.000000000000000_REALK, &
      0.583305290531335_REALK,      0.000000000000000_REALK,      0.214911644596528_REALK, &
      1.740297043671596_REALK,      0.691011860640982_REALK,      0.000000000000000_REALK, &
      0.468569507393008_REALK,      0.000000000000000_REALK,      0.302929443213374_REALK, &
      0.327129235447985_REALK,      0.000000000000000_REALK,      0.146111890362129_REALK, &
      0.000000000000000_REALK,      0.213255867753734_REALK,      0.000000000000000_REALK, &
      0.140392563955040_REALK,      0.000000000000000_REALK,      0.272290709654699_REALK, &
      0.381060373815326_REALK,      0.041535353276440_REALK,      0.000000000000000_REALK, &
     -0.338976299068825_REALK,      0.000000000000000_REALK,      0.103108043263165_REALK, &
     -1.203926581819097_REALK,      0.000000000000000_REALK,      0.010215172113803_REALK, &
      0.000000000000000_REALK,     -4.026023945085988_REALK,      0.000000000000000_REALK, &
     -0.102342692494118_REALK,      0.000000000000000_REALK,      0.093390199795736_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.238513538929780_REALK, &
      0.000000000000000_REALK,     -0.137133371975413_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.134944617729044_REALK,      0.000000000000000_REALK, &
     -0.151298404708995_REALK,      0.000000000000000_REALK,     -0.212406340989265_REALK, &
      0.000000000000000_REALK,     -0.123263499171409_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.161479280240513_REALK, &
      0.000000000000000_REALK,     -0.182458368337911_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.323371549211423_REALK,      0.000000000000000_REALK, &
     -0.119142261496462_REALK,      0.000000000000000_REALK,     -0.804366517952623_REALK, &
      0.000000000000000_REALK,     -0.165261825694727_REALK,      0.000000000000000_REALK, &
      2.152649443851538_REALK,      0.662842915882612_REALK,      0.000000000000000_REALK, &
      0.435861470217559_REALK,      0.000000000000000_REALK,      0.326784893729524_REALK, &
      0.321007405508486_REALK,      0.000000000000000_REALK,      0.120805672276749_REALK, &
      0.000000000000000_REALK,      0.400921356175373_REALK,      0.000000000000000_REALK, &
      0.107513570107554_REALK,      0.000000000000000_REALK,      0.241823237308922_REALK, &
      1.413024583118805_REALK,      0.532535625517404_REALK,      0.000000000000000_REALK, &
      0.566848737968112_REALK,      0.000000000000000_REALK,      0.173006617329140_REALK, &
      0.992507288187986_REALK,      0.000000000000000_REALK,      0.087503542124833_REALK, &
      0.000000000000000_REALK,      2.561881043765872_REALK,      0.000000000000000_REALK, &
      0.127184537281605_REALK,      0.000000000000000_REALK,      0.116453112256379_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.249012760627626_REALK, &
      0.000000000000000_REALK,     -0.100574183273471_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.070198987277737_REALK,      0.000000000000000_REALK, &
     -0.136150601744246_REALK,      0.000000000000000_REALK,     -0.055543739757800_REALK, &
      0.000000000000000_REALK,     -0.074425639176033_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.133134905643251_REALK, &
      0.000000000000000_REALK,     -0.009912115629711_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.071919339552928_REALK,      0.000000000000000_REALK, &
     -0.065628149175491_REALK,      0.000000000000000_REALK,      0.262112543609140_REALK, &
      0.000000000000000_REALK,     -0.006671980135471_REALK,      0.000000000000000_REALK, &
      0.228678528061226_REALK,      0.112725785805244_REALK,      0.000000000000000_REALK, &
      0.092887339159135_REALK,      0.000000000000000_REALK,      0.104144251685969_REALK, &
      0.106207263467254_REALK,      0.000000000000000_REALK,      0.061634124816712_REALK, &
      0.000000000000000_REALK,      0.191153133526345_REALK,      0.000000000000000_REALK, &
      0.068737317701918_REALK,      0.000000000000000_REALK,      0.128445860325177_REALK, &
      0.314740230636685_REALK,      0.235593430771344_REALK,      0.000000000000000_REALK, &
      0.313777991347938_REALK,      0.000000000000000_REALK,      0.115607633349861_REALK, &
      0.565252948889986_REALK,      0.000000000000000_REALK,      0.116134538457243_REALK, &
      0.000000000000000_REALK,      1.322584649423696_REALK,      0.000000000000000_REALK, &
      0.211208242864523_REALK,      0.000000000000000_REALK,      0.129695122957570_REALK, &
      3.005019836541519_REALK,      0.663493335045135_REALK,      0.000000000000000_REALK, &
      0.401954973465489_REALK,      0.000000000000000_REALK,      0.396442138867410_REALK, &
      0.206049494206433_REALK,      0.000000000000000_REALK,      0.103465304446473_REALK, &
      0.000000000000000_REALK,      0.165751133632827_REALK,      0.000000000000000_REALK, &
      0.081425973098680_REALK,      0.000000000000000_REALK,      0.240927634179695_REALK, &
      0.888501124124126_REALK,      0.166382585014905_REALK,      0.000000000000000_REALK, &
     -0.100233906666308_REALK,      0.000000000000000_REALK,      0.182586960694371_REALK, &
     -0.574655117045394_REALK,      0.000000000000000_REALK,      0.030366148805340_REALK, &
      0.000000000000000_REALK,     -1.718949024038409_REALK,      0.000000000000000_REALK, &
     -0.020381651188580_REALK,      0.000000000000000_REALK,      0.111382181984926_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.308983715217322_REALK, &
      0.000000000000000_REALK,     -0.095822239569706_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.064265852576005_REALK,      0.000000000000000_REALK, &
     -0.144548976494788_REALK,      0.000000000000000_REALK,     -0.051579792750133_REALK, &
      0.000000000000000_REALK,     -0.058233530742428_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.174646071983616_REALK, &
      0.000000000000000_REALK,     -0.086594361894087_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.104434776095693_REALK,      0.000000000000000_REALK, &
     -0.095622903256027_REALK,      0.000000000000000_REALK,     -0.199720385012791_REALK, &
      0.000000000000000_REALK,     -0.052824522291602_REALK,      0.000000000000000_REALK, &
      0.272863115523442_REALK,      0.095095536541252_REALK,      0.000000000000000_REALK, &
      0.055681360400597_REALK,      0.000000000000000_REALK,      0.107993733506235_REALK, &
      0.033201072080705_REALK,      0.000000000000000_REALK,      0.044487660026330_REALK, &
      0.000000000000000_REALK,      0.017133743942984_REALK,      0.000000000000000_REALK, &
      0.033838931622023_REALK,      0.000000000000000_REALK,      0.109384078065894_REALK, &
      0.105346741459518_REALK,      0.010006045355382_REALK,      0.000000000000000_REALK, &
     -0.071172082468905_REALK,      0.000000000000000_REALK,      0.064946258884402_REALK, &
     -0.215227930916506_REALK,      0.000000000000000_REALK,      0.005478549251785_REALK, &
      0.000000000000000_REALK,     -0.569316663735151_REALK,      0.000000000000000_REALK, &
     -0.043416582496639_REALK,      0.000000000000000_REALK,      0.066031148471140_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.098471130159072_REALK, &
      0.000000000000000_REALK,     -0.048887769610077_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.041087486179488_REALK,      0.000000000000000_REALK, &
     -0.076778054299547_REALK,      0.000000000000000_REALK,     -0.051196469715602_REALK, &
      0.000000000000000_REALK,     -0.049517165800989_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.116703160651154_REALK, &
      0.000000000000000_REALK,     -0.114927876144973_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.173428987710060_REALK,      0.000000000000000_REALK, &
     -0.106496288120208_REALK,      0.000000000000000_REALK,     -0.341234380620109_REALK, &
      0.000000000000000_REALK,     -0.116847679659407_REALK,      0.000000000000000_REALK, &
      4.936179568597047_REALK,      0.733419641345752_REALK,      0.000000000000000_REALK, &
      0.466477336984879_REALK,      0.000000000000000_REALK,      0.553607959565459_REALK, &
      0.188969164812805_REALK,      0.000000000000000_REALK,      0.096196283560307_REALK, &
      0.000000000000000_REALK,      0.188255574155285_REALK,      0.000000000000000_REALK, &
      0.076900730363619_REALK,      0.000000000000000_REALK,      0.273793728335466_REALK, &
      4.460302930727911_REALK,      0.753736341316086_REALK,      0.000000000000000_REALK, &
      0.648225068094353_REALK,      0.000000000000000_REALK,      0.393104965513632_REALK, &
      0.841280200980223_REALK,      0.000000000000000_REALK,      0.083339844704587_REALK, &
      0.000000000000000_REALK,      1.822210310285953_REALK,      0.000000000000000_REALK, &
      0.090990331544431_REALK,      0.000000000000000_REALK,      0.165538574043427_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.443835286073869_REALK, &
      0.000000000000000_REALK,     -0.097003974529014_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.059023530098117_REALK,      0.000000000000000_REALK, &
     -0.174642057396596_REALK,      0.000000000000000_REALK,     -0.031846833482764_REALK, &
      0.000000000000000_REALK,     -0.047974526721950_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.385844203899152_REALK, &
      0.000000000000000_REALK,     -0.047021221884072_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.023420173624237_REALK,      0.000000000000000_REALK, &
     -0.127987179085618_REALK,      0.000000000000000_REALK,      0.124905309041686_REALK, &
      0.000000000000000_REALK,     -0.019800884504978_REALK,      0.000000000000000_REALK, &
      0.402788608569587_REALK,      0.107277423215304_REALK,      0.000000000000000_REALK, &
      0.060252498745542_REALK,      0.000000000000000_REALK,      0.135522002366982_REALK, &
      0.037388824891937_REALK,      0.000000000000000_REALK,      0.042211943237447_REALK, &
      0.000000000000000_REALK,      0.037039992081857_REALK,      0.000000000000000_REALK, &
      0.029798625521964_REALK,      0.000000000000000_REALK,      0.111706830493877_REALK, &
      0.560016330146038_REALK,      0.182991887811236_REALK,      0.000000000000000_REALK, &
      0.161714638582860_REALK,      0.000000000000000_REALK,      0.148069673899841_REALK, &
      0.229494953574712_REALK,      0.000000000000000_REALK,      0.060699669140640_REALK, &
      0.000000000000000_REALK,      0.457239147001148_REALK,      0.000000000000000_REALK, &
      0.068098887120332_REALK,      0.000000000000000_REALK,      0.103921534224447_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.120903972877000_REALK, &
      0.000000000000000_REALK,     -0.041709439344299_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.024528944795785_REALK,      0.000000000000000_REALK, &
     -0.079289619494664_REALK,      0.000000000000000_REALK,     -0.015394587859713_REALK, &
      0.000000000000000_REALK,     -0.034379873300657_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.137244945970848_REALK, &
      0.000000000000000_REALK,     -0.008483396482787_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.049889181736760_REALK,      0.000000000000000_REALK, &
     -0.075875155918104_REALK,      0.000000000000000_REALK,      0.140343888506984_REALK, &
      0.000000000000000_REALK,     -0.005954004994445_REALK,      0.000000000000000_REALK, &
      0.128366148595082_REALK,      0.054732116198320_REALK,      0.000000000000000_REALK, &
      0.038521603779537_REALK,      0.000000000000000_REALK,      0.071983322945844_REALK, &
      0.037110964182326_REALK,      0.000000000000000_REALK,      0.035893681276442_REALK, &
      0.000000000000000_REALK,      0.052980294837232_REALK,      0.000000000000000_REALK, &
      0.031752233501543_REALK,      0.000000000000000_REALK,      0.083067252549089_REALK, &
      0.374217839554008_REALK,      0.242866493359316_REALK,      0.000000000000000_REALK, &
      0.268550449532492_REALK,      0.000000000000000_REALK,      0.164906838388729_REALK, &
      0.392106035312779_REALK,      0.000000000000000_REALK,      0.134267480092385_REALK, &
      0.000000000000000_REALK,      0.708156389709290_REALK,      0.000000000000000_REALK, &
      0.188480017528502_REALK,      0.000000000000000_REALK,      0.162033991683352_REALK, &
      9.432795583767088_REALK,      0.825170705999673_REALK,      0.000000000000000_REALK, &
      0.635461664744910_REALK,      0.000000000000000_REALK,      0.900145326126600_REALK, &
      0.143806317635740_REALK,      0.000000000000000_REALK,      0.090231539293154_REALK, &
      0.000000000000000_REALK,      0.150646643131715_REALK,      0.000000000000000_REALK, &
      0.084459364013833_REALK,      0.000000000000000_REALK,      0.358915600967978_REALK, &
      3.849761854783698_REALK,      0.289968322904153_REALK,      0.000000000000000_REALK, &
     -0.021952040181656_REALK,      0.000000000000000_REALK,      0.601529074193756_REALK, &
     -0.788069748286838_REALK,      0.000000000000000_REALK,      0.038748017663082_REALK, &
      0.000000000000000_REALK,     -1.918775762796830_REALK,      0.000000000000000_REALK, &
     -0.002995827799539_REALK,      0.000000000000000_REALK,      0.246274720862617_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.750569938422225_REALK, &
      0.000000000000000_REALK,     -0.109656531482900_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.069156651033882_REALK,      0.000000000000000_REALK, &
     -0.246222074045726_REALK,      0.000000000000000_REALK,     -0.028630280643041_REALK, &
      0.000000000000000_REALK,     -0.043723428600810_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.538823736240440_REALK, &
      0.000000000000000_REALK,     -0.120046820968177_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.118730676866441_REALK,      0.000000000000000_REALK, &
     -0.216006542783990_REALK,      0.000000000000000_REALK,     -0.165379091769741_REALK, &
      0.000000000000000_REALK,     -0.049148908328344_REALK,      0.000000000000000_REALK, &
      0.695395037837666_REALK,      0.131515932766035_REALK,      0.000000000000000_REALK, &
      0.067282387082848_REALK,      0.000000000000000_REALK,      0.199078816315626_REALK, &
      0.028639784554551_REALK,      0.000000000000000_REALK,      0.043143382219360_REALK, &
      0.000000000000000_REALK,      0.018203436865008_REALK,      0.000000000000000_REALK, &
      0.026827555166358_REALK,      0.000000000000000_REALK,      0.132298068848843_REALK, &
      0.393296816366504_REALK,      0.064451362055582_REALK,      0.000000000000000_REALK, &
     -0.033735572703289_REALK,      0.000000000000000_REALK,      0.184359042524921_REALK, &
     -0.162985359378427_REALK,      0.000000000000000_REALK,      0.025837606918514_REALK, &
      0.000000000000000_REALK,     -0.388287739591202_REALK,      0.000000000000000_REALK, &
     -0.013811832390278_REALK,      0.000000000000000_REALK,      0.125798773171463_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.183737858558399_REALK, &
      0.000000000000000_REALK,     -0.048118441911215_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.026797835817262_REALK,      0.000000000000000_REALK, &
     -0.100457697320139_REALK,      0.000000000000000_REALK,     -0.016994082880613_REALK, &
      0.000000000000000_REALK,     -0.031977168935826_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.202957128283462_REALK, &
      0.000000000000000_REALK,     -0.087434795924846_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.088860286850370_REALK,      0.000000000000000_REALK, &
     -0.135604232779859_REALK,      0.000000000000000_REALK,     -0.135342542034281_REALK, &
      0.000000000000000_REALK,     -0.059661787722488_REALK,      0.000000000000000_REALK, &
      0.189430686183731_REALK,      0.056548773873932_REALK,      0.000000000000000_REALK, &
      0.027961153047613_REALK,      0.000000000000000_REALK,      0.090384205445244_REALK, &
      0.013844317672804_REALK,      0.000000000000000_REALK,      0.030917741472680_REALK, &
      0.000000000000000_REALK,      0.005645084035773_REALK,      0.000000000000000_REALK, &
      0.018581618172379_REALK,      0.000000000000000_REALK,      0.084090906700183_REALK, &
      0.139895843366966_REALK,      0.011628078477441_REALK,      0.000000000000000_REALK, &
     -0.071862836911095_REALK,      0.000000000000000_REALK,      0.109294315230849_REALK, &
     -0.183130719425567_REALK,      0.000000000000000_REALK,      0.007769210542017_REALK, &
      0.000000000000000_REALK,     -0.385803204252066_REALK,      0.000000000000000_REALK, &
     -0.049036144884592_REALK,      0.000000000000000_REALK,      0.104408912171023_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.097593463636791_REALK, &
      0.000000000000000_REALK,     -0.040916098265478_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.028554711007679_REALK,      0.000000000000000_REALK, &
     -0.074702190339645_REALK,      0.000000000000000_REALK,     -0.028112981303758_REALK, &
      0.000000000000000_REALK,     -0.038067179822277_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.226035605213265_REALK, &
      0.000000000000000_REALK,     -0.193405497714009_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.245942175142314_REALK,      0.000000000000000_REALK, &
     -0.211433513664487_REALK,      0.000000000000000_REALK,     -0.385401557780068_REALK, &
      0.000000000000000_REALK,     -0.184760365455085_REALK,      0.000000000000000_REALK, &
      9.143184070509873_REALK,     -0.036848040440962_REALK,      0.000000000000000_REALK, &
      3.298557754275748_REALK,      0.000000000000000_REALK,      4.128729224499416_REALK, &
      0.048693125035339_REALK,      0.000000000000000_REALK,      0.019868703707862_REALK, &
      0.000000000000000_REALK,     13.386226420351745_REALK,      0.000000000000000_REALK, &
      4.411071622360041_REALK,      0.000000000000000_REALK,     16.563712090525502_REALK, &
      3.777411411706986_REALK,     -0.076305444227413_REALK,      0.000000000000000_REALK, &
      2.856210424567605_REALK,      0.000000000000000_REALK,      1.734083380938721_REALK, &
     -0.018697545181803_REALK,      0.000000000000000_REALK,     -0.002123442566062_REALK, &
      0.000000000000000_REALK,     43.439321304608754_REALK,      0.000000000000000_REALK, &
      4.447673199561774_REALK,      0.000000000000000_REALK,      8.100911732062825_REALK, &
      7.747149736611206_REALK,     -0.022677835949006_REALK,      0.000000000000000_REALK, &
      2.307155524118628_REALK,      0.000000000000000_REALK,      3.357238446682681_REALK, &
     -0.146525480788287_REALK,      0.000000000000000_REALK,     -0.011495992495695_REALK, &
      0.000000000000000_REALK,      5.222194856957159_REALK,      0.000000000000000_REALK, &
      2.878194157631499_REALK,      0.000000000000000_REALK,     12.564541898460810_REALK, &
      1.785650631442194_REALK,     -0.070854051794765_REALK,      0.000000000000000_REALK, &
      0.125498570486625_REALK,      0.000000000000000_REALK,      1.224274819687144_REALK, &
     -0.781945094000639_REALK,      0.000000000000000_REALK,     -0.060088089556590_REALK, &
      0.000000000000000_REALK,    -13.285437663556795_REALK,      0.000000000000000_REALK, &
      0.186709355626000_REALK,      0.000000000000000_REALK,      5.464211149336211_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.500439432826910_REALK, &
      0.000000000000000_REALK,     -0.227044891172154_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.202676817721760_REALK,      0.000000000000000_REALK, &
     -0.761057798098283_REALK,      0.000000000000000_REALK,     -0.694149579006133_REALK, &
      0.000000000000000_REALK,     -0.849720713398479_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.188275268466008_REALK, &
      0.000000000000000_REALK,     -0.264173449644681_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.262988770777206_REALK,      0.000000000000000_REALK, &
     -0.479003002918416_REALK,      0.000000000000000_REALK,     -3.460672811759610_REALK, &
      0.000000000000000_REALK,     -1.179064933538331_REALK,      0.000000000000000_REALK, &
      8.683297262294319_REALK,     -0.680998130308470_REALK,      0.000000000000000_REALK, &
      2.450883420695674_REALK,      0.000000000000000_REALK,      3.329746569408579_REALK, &
     -0.745062068674789_REALK,      0.000000000000000_REALK,     -0.294100408428299_REALK, &
      0.000000000000000_REALK,      6.173757277449480_REALK,      0.000000000000000_REALK, &
      2.625402742685291_REALK,      0.000000000000000_REALK,     10.700540509541080_REALK, &
      4.031540892549486_REALK,     -0.296651417410394_REALK,      0.000000000000000_REALK, &
      1.268550360861187_REALK,      0.000000000000000_REALK,      1.444848378389072_REALK, &
      0.333052402302808_REALK,      0.000000000000000_REALK,     -0.139198121574731_REALK, &
      0.000000000000000_REALK,     10.151138643827872_REALK,      0.000000000000000_REALK, &
      1.497085564092833_REALK,      0.000000000000000_REALK,      5.115433449849251_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.925773928303284_REALK, &
      0.000000000000000_REALK,      0.013485912715449_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.274757361496003_REALK,      0.000000000000000_REALK, &
     -1.199432766296744_REALK,      0.000000000000000_REALK,      0.184128200400637_REALK, &
      0.000000000000000_REALK,      0.043338600194257_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.529691617456520_REALK, &
      0.000000000000000_REALK,      0.086783217842153_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.025478268424616_REALK,      0.000000000000000_REALK, &
     -0.745643612366356_REALK,      0.000000000000000_REALK,      1.332792443301055_REALK, &
      0.000000000000000_REALK,      0.307252845402549_REALK,      0.000000000000000_REALK, &
      0.776075095626092_REALK,      0.062608672020103_REALK,      0.000000000000000_REALK, &
      0.237759538749184_REALK,      0.000000000000000_REALK,      0.892794514297774_REALK, &
      0.066264711956831_REALK,      0.000000000000000_REALK,      0.081115799850692_REALK, &
      0.000000000000000_REALK,      0.772903523730386_REALK,      0.000000000000000_REALK, &
      0.764068833132647_REALK,      0.000000000000000_REALK,      4.781837329958432_REALK, &
      0.643447516288259_REALK,      0.114296610190119_REALK,      0.000000000000000_REALK, &
      0.379825884843682_REALK,      0.000000000000000_REALK,      0.691808014800750_REALK, &
      0.472241739210964_REALK,      0.000000000000000_REALK,      0.160894630941343_REALK, &
      0.000000000000000_REALK,      4.377978552893460_REALK,      0.000000000000000_REALK, &
      1.344759813908137_REALK,      0.000000000000000_REALK,      4.082202110520922_REALK, &
     12.219773658485561_REALK,     -2.157308846366753_REALK,      0.000000000000000_REALK, &
      3.314446321384632_REALK,      0.000000000000000_REALK,      3.944291295485328_REALK, &
     -1.982231920551172_REALK,      0.000000000000000_REALK,     -0.811644896204028_REALK, &
      0.000000000000000_REALK,      7.372147999418220_REALK,      0.000000000000000_REALK, &
      2.845357733938610_REALK,      0.000000000000000_REALK,     10.158185097257027_REALK, &
      3.295767874339293_REALK,     -1.079042664330901_REALK,      0.000000000000000_REALK, &
      1.203091329874456_REALK,      0.000000000000000_REALK,      1.839617169583094_REALK, &
     -1.830822393896037_REALK,      0.000000000000000_REALK,     -0.547791118021060_REALK, &
      0.000000000000000_REALK,     -1.705493198946906_REALK,      0.000000000000000_REALK, &
      1.138955291311165_REALK,      0.000000000000000_REALK,      5.224645022175103_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.468879521623443_REALK, &
      0.000000000000000_REALK,      0.228800066739394_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.406772315566097_REALK,      0.000000000000000_REALK, &
     -1.657910830253371_REALK,      0.000000000000000_REALK,      0.497598267117497_REALK, &
      0.000000000000000_REALK,      0.589255015435553_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.768336215815453_REALK, &
      0.000000000000000_REALK,      0.125987519894336_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.342462570604318_REALK,      0.000000000000000_REALK, &
     -1.170169916141184_REALK,      0.000000000000000_REALK,     -0.285374262536875_REALK, &
      0.000000000000000_REALK,      0.357813614460504_REALK,      0.000000000000000_REALK, &
      0.963627873706561_REALK,     -0.005949155770628_REALK,      0.000000000000000_REALK, &
      0.213751837283666_REALK,      0.000000000000000_REALK,      0.933117701007943_REALK, &
     -0.028528291381831_REALK,      0.000000000000000_REALK,     -0.006714757499027_REALK, &
      0.000000000000000_REALK,      0.332942110341649_REALK,      0.000000000000000_REALK, &
      0.550499586704351_REALK,      0.000000000000000_REALK,      4.005274802774296_REALK, &
      0.403026275395887_REALK,     -0.046149263957697_REALK,      0.000000000000000_REALK, &
      0.023060252636356_REALK,      0.000000000000000_REALK,      0.674878284163169_REALK, &
     -0.304880053059269_REALK,      0.000000000000000_REALK,     -0.070284960182492_REALK, &
      0.000000000000000_REALK,     -1.553395083570803_REALK,      0.000000000000000_REALK, &
      0.065492775420193_REALK,      0.000000000000000_REALK,      3.194504746447019_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.393846063576748_REALK, &
      0.000000000000000_REALK,     -0.063105320113768_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.118382617436958_REALK,      0.000000000000000_REALK, &
     -0.740884060088284_REALK,      0.000000000000000_REALK,     -0.132766948796927_REALK, &
      0.000000000000000_REALK,     -0.270870596817163_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.367887150038157_REALK, &
      0.000000000000000_REALK,     -0.145624921423465_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.307617623041757_REALK,      0.000000000000000_REALK, &
     -0.933815315587852_REALK,      0.000000000000000_REALK,     -1.213913820780062_REALK, &
      0.000000000000000_REALK,     -0.689308744413179_REALK,      0.000000000000000_REALK, &
     20.906198390919386_REALK,     -5.395464519285986_REALK,      0.000000000000000_REALK, &
      5.545799576332011_REALK,      0.000000000000000_REALK,      5.506190762769324_REALK, &
     -4.307397382727754_REALK,      0.000000000000000_REALK,     -1.724041885750122_REALK, &
      0.000000000000000_REALK,     10.821773997782548_REALK,      0.000000000000000_REALK, &
      3.622603443816272_REALK,      0.000000000000000_REALK,     10.790191032855679_REALK, &
     15.901930767733974_REALK,     -4.106155123602535_REALK,      0.000000000000000_REALK, &
      3.850430715919522_REALK,      0.000000000000000_REALK,      3.600965483023340_REALK, &
     -2.217213988902071_REALK,      0.000000000000000_REALK,     -1.282238103461874_REALK, &
      0.000000000000000_REALK,     10.438638678969093_REALK,      0.000000000000000_REALK, &
      2.345186406333011_REALK,      0.000000000000000_REALK,      6.579732962506235_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.426240272431503_REALK, &
      0.000000000000000_REALK,      0.573600951848357_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.651470549609939_REALK,      0.000000000000000_REALK, &
     -2.325808930601169_REALK,      0.000000000000000_REALK,      0.915071210738888_REALK, &
      0.000000000000000_REALK,      1.124055470239239_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.092630231007191_REALK, &
      0.000000000000000_REALK,      0.556295936159346_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.427363043859765_REALK,      0.000000000000000_REALK, &
     -1.960410752552983_REALK,      0.000000000000000_REALK,      1.132413849073831_REALK, &
      0.000000000000000_REALK,      1.016471478361069_REALK,      0.000000000000000_REALK, &
      1.482885194062922_REALK,     -0.140741110296172_REALK,      0.000000000000000_REALK, &
      0.287471760723819_REALK,      0.000000000000000_REALK,      1.171669081836966_REALK, &
     -0.113929652042474_REALK,      0.000000000000000_REALK,     -0.134915298764502_REALK, &
      0.000000000000000_REALK,      0.441575969253326_REALK,      0.000000000000000_REALK, &
      0.563343216463737_REALK,      0.000000000000000_REALK,      3.826763293962155_REALK, &
      1.749240302390975_REALK,     -0.143315303433625_REALK,      0.000000000000000_REALK, &
      0.347779527718705_REALK,      0.000000000000000_REALK,      1.188337575309570_REALK, &
      0.107079193017837_REALK,      0.000000000000000_REALK,     -0.134260156282577_REALK, &
      0.000000000000000_REALK,      1.436283611823142_REALK,      0.000000000000000_REALK, &
      0.635467469211723_REALK,      0.000000000000000_REALK,      3.618910887330691_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.573985939551556_REALK, &
      0.000000000000000_REALK,      0.004745414294953_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.126041890632113_REALK,      0.000000000000000_REALK, &
     -0.917044119261001_REALK,      0.000000000000000_REALK,      0.039509127864048_REALK, &
      0.000000000000000_REALK,      0.015498895993825_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.767698151028981_REALK, &
      0.000000000000000_REALK,      0.071376180511818_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.024574442972363_REALK,      0.000000000000000_REALK, &
     -1.198653961644476_REALK,      0.000000000000000_REALK,      0.565730016535322_REALK, &
      0.000000000000000_REALK,      0.217365874913960_REALK,      0.000000000000000_REALK, &
      0.397601360642866_REALK,      0.038817789456868_REALK,      0.000000000000000_REALK, &
      0.083662673617145_REALK,      0.000000000000000_REALK,      0.523593266049550_REALK, &
      0.030398201277504_REALK,      0.000000000000000_REALK,      0.062018288413030_REALK, &
      0.000000000000000_REALK,      0.165845014936295_REALK,      0.000000000000000_REALK, &
      0.273248866455430_REALK,      0.000000000000000_REALK,      2.394135453058046_REALK, &
      0.837553946218082_REALK,      0.165653549008706_REALK,      0.000000000000000_REALK, &
      0.312393589380082_REALK,      0.000000000000000_REALK,      0.948313413809146_REALK, &
      0.455489262300001_REALK,      0.000000000000000_REALK,      0.258644992844665_REALK, &
      0.000000000000000_REALK,      1.858319269116868_REALK,      0.000000000000000_REALK, &
      0.951349671363698_REALK,      0.000000000000000_REALK,      4.043132635706048_REALK, &
     42.446708937556231_REALK,    -13.387019767814650_REALK,      0.000000000000000_REALK, &
     11.004155031077776_REALK,      0.000000000000000_REALK,      9.011800760515261_REALK, &
     -9.363297815847758_REALK,      0.000000000000000_REALK,     -3.516609138187972_REALK, &
      0.000000000000000_REALK,     17.586503501150958_REALK,      0.000000000000000_REALK, &
      5.264137021503776_REALK,      0.000000000000000_REALK,     12.933120411299202_REALK, &
     18.424358565972668_REALK,     -9.641778061011568_REALK,      0.000000000000000_REALK, &
      8.120636295038247_REALK,      0.000000000000000_REALK,      6.804510921713805_REALK, &
     -9.122117929965661_REALK,      0.000000000000000_REALK,     -3.262638453573626_REALK, &
      0.000000000000000_REALK,      8.821102758483642_REALK,      0.000000000000000_REALK, &
      3.857302154195036_REALK,      0.000000000000000_REALK,      9.696427847387056_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.463338848904796_REALK, &
      0.000000000000000_REALK,      1.292570479972265_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.180899588674490_REALK,      0.000000000000000_REALK, &
     -3.517396355974060_REALK,      0.000000000000000_REALK,      1.544869663326354_REALK, &
      0.000000000000000_REALK,      1.855008793671588_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.533929403198772_REALK, &
      0.000000000000000_REALK,      1.280088125504411_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.278674617195122_REALK,      0.000000000000000_REALK, &
     -3.587492023814892_REALK,      0.000000000000000_REALK,      1.051410719503716_REALK, &
      0.000000000000000_REALK,      1.824125538198750_REALK,      0.000000000000000_REALK, &
      2.737736469441647_REALK,     -0.464963079278769_REALK,      0.000000000000000_REALK, &
      0.488428737118955_REALK,      0.000000000000000_REALK,      1.743734877092572_REALK, &
     -0.298295751419880_REALK,      0.000000000000000_REALK,     -0.366420631747224_REALK, &
      0.000000000000000_REALK,      0.605381105637662_REALK,      0.000000000000000_REALK, &
      0.700959534877364_REALK,      0.000000000000000_REALK,      4.170815158577106_REALK, &
      1.766413898993951_REALK,     -0.545939852781632_REALK,      0.000000000000000_REALK, &
      0.426646467802907_REALK,      0.000000000000000_REALK,      1.957123656424594_REALK, &
     -0.617430171461315_REALK,      0.000000000000000_REALK,     -0.554214485881913_REALK, &
      0.000000000000000_REALK,     -0.303462526845348_REALK,      0.000000000000000_REALK, &
      0.607971203072371_REALK,      0.000000000000000_REALK,      4.648168580438250_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.949759344769478_REALK, &
      0.000000000000000_REALK,      0.101150403549365_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.183639137687059_REALK,      0.000000000000000_REALK, &
     -1.247451803621632_REALK,      0.000000000000000_REALK,      0.122584322426007_REALK, &
      0.000000000000000_REALK,      0.241940241009177_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.166215315895380_REALK, &
      0.000000000000000_REALK,      0.134035037113373_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.346478267458826_REALK,      0.000000000000000_REALK, &
     -1.973152104679116_REALK,      0.000000000000000_REALK,     -0.152331996737732_REALK, &
      0.000000000000000_REALK,      0.318333206051184_REALK,      0.000000000000000_REALK, &
      0.647677914472251_REALK,     -0.003846650595549_REALK,      0.000000000000000_REALK, &
      0.094497719816173_REALK,      0.000000000000000_REALK,      0.687537911454627_REALK, &
     -0.012879221688806_REALK,      0.000000000000000_REALK,     -0.005052344312005_REALK, &
      0.000000000000000_REALK,      0.082020950835986_REALK,      0.000000000000000_REALK, &
      0.226027779473809_REALK,      0.000000000000000_REALK,      2.302317292157272_REALK, &
      0.648023078380582_REALK,     -0.070047431497999_REALK,      0.000000000000000_REALK, &
      0.024533238058421_REALK,      0.000000000000000_REALK,      1.196644132433190_REALK, &
     -0.308455059425402_REALK,      0.000000000000000_REALK,     -0.118515196125277_REALK, &
      0.000000000000000_REALK,     -0.829198024724949_REALK,      0.000000000000000_REALK, &
      0.058266439090460_REALK,      0.000000000000000_REALK,      3.978841651684090_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.424426661928532_REALK, &
      0.000000000000000_REALK,     -0.046497135297968_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.089073915764585_REALK,      0.000000000000000_REALK, &
     -0.780442467853693_REALK,      0.000000000000000_REALK,     -0.054512336337500_REALK, &
      0.000000000000000_REALK,     -0.155702190161122_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.930659477939301_REALK, &
      0.000000000000000_REALK,     -0.258211312834749_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.518707883332727_REALK,      0.000000000000000_REALK, &
     -2.204452090149303_REALK,      0.000000000000000_REALK,     -1.079973100021364_REALK, &
      0.000000000000000_REALK,     -0.858552596045331_REALK,      0.000000000000000_REALK/
    ! results of test 2, ket-major order, CM000300
  data REF_CONTR_INTS(5041:6300)                                                           &
     /1.234674085579904_REALK,      0.425169732518382_REALK,      0.000000000000000_REALK, &
      0.233071431813933_REALK,      0.000000000000000_REALK,      0.214916835407371_REALK, &
      0.036540949724682_REALK,      0.000000000000000_REALK,      0.089900560151597_REALK, &
      0.000000000000000_REALK,     -0.375408218154059_REALK,      0.000000000000000_REALK, &
      0.069832747075421_REALK,      0.000000000000000_REALK,      0.193179827649158_REALK, &
      0.169984505316538_REALK,     -0.229740533453385_REALK,      0.000000000000000_REALK, &
     -0.804020853706996_REALK,      0.000000000000000_REALK,      0.045994731891853_REALK, &
     -2.178112089545260_REALK,      0.000000000000000_REALK,     -0.056502206087517_REALK, &
      0.000000000000000_REALK,     -6.663666476749802_REALK,      0.000000000000000_REALK, &
     -0.242747529003749_REALK,      0.000000000000000_REALK,      0.041659768384588_REALK, &
      1.589615616383101_REALK,      0.453239927050510_REALK,      0.000000000000000_REALK, &
      0.303654094186749_REALK,      0.000000000000000_REALK,      0.241313034853049_REALK, &
      0.235479472258495_REALK,      0.000000000000000_REALK,      0.082604720934663_REALK, &
      0.000000000000000_REALK,      0.351384621726146_REALK,      0.000000000000000_REALK, &
      0.074902091546420_REALK,      0.000000000000000_REALK,      0.178573429839462_REALK, &
      1.114228153426078_REALK,      0.513566913886506_REALK,      0.000000000000000_REALK, &
      0.687120919857660_REALK,      0.000000000000000_REALK,      0.136422852128774_REALK, &
      1.359848045001461_REALK,      0.000000000000000_REALK,      0.084386700025048_REALK, &
      0.000000000000000_REALK,      3.623458861221109_REALK,      0.000000000000000_REALK, &
      0.154170152273539_REALK,      0.000000000000000_REALK,      0.091828081252310_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.176665014540850_REALK, &
      0.000000000000000_REALK,     -0.061881859105821_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.034917719182668_REALK,      0.000000000000000_REALK, &
     -0.096593636311120_REALK,      0.000000000000000_REALK,     -0.006204340004131_REALK, &
      0.000000000000000_REALK,     -0.045793033236262_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.059389200849049_REALK, &
      0.000000000000000_REALK,      0.054825938695295_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.170586111607903_REALK,      0.000000000000000_REALK, &
     -0.029275593157955_REALK,      0.000000000000000_REALK,      0.474207072655458_REALK, &
      0.000000000000000_REALK,      0.036904086629808_REALK,      0.000000000000000_REALK, &
      2.258749534049874_REALK,      0.448370860961806_REALK,      0.000000000000000_REALK, &
      0.270639732782426_REALK,      0.000000000000000_REALK,      0.297989213101198_REALK, &
      0.116909688249325_REALK,      0.000000000000000_REALK,      0.069919055978437_REALK, &
      0.000000000000000_REALK,      0.066554578083629_REALK,      0.000000000000000_REALK, &
      0.054824806398042_REALK,      0.000000000000000_REALK,      0.181095370761159_REALK, &
      0.626524005431690_REALK,      0.018661924751746_REALK,      0.000000000000000_REALK, &
     -0.276626200744991_REALK,      0.000000000000000_REALK,      0.128750668792462_REALK, &
     -0.880450665942439_REALK,      0.000000000000000_REALK,      0.003405950111635_REALK, &
      0.000000000000000_REALK,     -2.441434235082284_REALK,      0.000000000000000_REALK, &
     -0.056249416197819_REALK,      0.000000000000000_REALK,      0.078540824424628_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.228167823758023_REALK, &
      0.000000000000000_REALK,     -0.065521504162959_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.044772457729208_REALK,      0.000000000000000_REALK, &
     -0.106741629959585_REALK,      0.000000000000000_REALK,     -0.037837078421179_REALK, &
      0.000000000000000_REALK,     -0.039819028902869_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.137715629730882_REALK, &
      0.000000000000000_REALK,     -0.083509904440119_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.126593418331009_REALK,      0.000000000000000_REALK, &
     -0.075402602469263_REALK,      0.000000000000000_REALK,     -0.273639678356844_REALK, &
      0.000000000000000_REALK,     -0.050942933375526_REALK,      0.000000000000000_REALK, &
      0.193585927685437_REALK,      0.058510925988205_REALK,      0.000000000000000_REALK, &
      0.027696497935001_REALK,      0.000000000000000_REALK,      0.076617416923184_REALK, &
      0.003708622080338_REALK,      0.000000000000000_REALK,      0.027372622079479_REALK, &
      0.000000000000000_REALK,     -0.030161647375495_REALK,      0.000000000000000_REALK, &
      0.016831842703720_REALK,      0.000000000000000_REALK,      0.077603813127257_REALK, &
      0.046993376809062_REALK,     -0.055345483217740_REALK,      0.000000000000000_REALK, &
     -0.168813685983206_REALK,      0.000000000000000_REALK,      0.028971413579663_REALK, &
     -0.389384672966292_REALK,      0.000000000000000_REALK,     -0.030302976341114_REALK, &
      0.000000000000000_REALK,     -0.942303478203963_REALK,      0.000000000000000_REALK, &
     -0.102980172418782_REALK,      0.000000000000000_REALK,      0.029455364240495_REALK, &
      3.775958182959544_REALK,      0.496734160876121_REALK,      0.000000000000000_REALK, &
      0.334545430616491_REALK,      0.000000000000000_REALK,      0.423485506558843_REALK, &
      0.127145579535376_REALK,      0.000000000000000_REALK,      0.065152305037879_REALK, &
      0.000000000000000_REALK,      0.143982130510790_REALK,      0.000000000000000_REALK, &
      0.055151206531291_REALK,      0.000000000000000_REALK,      0.209440044590019_REALK, &
      3.461538074365152_REALK,      0.645352034179745_REALK,      0.000000000000000_REALK, &
      0.696547894062825_REALK,      0.000000000000000_REALK,      0.305079683259398_REALK, &
      1.068066701523355_REALK,      0.000000000000000_REALK,      0.071355904392799_REALK, &
      0.000000000000000_REALK,      2.394275317027182_REALK,      0.000000000000000_REALK, &
      0.097773330494103_REALK,      0.000000000000000_REALK,      0.128470663478887_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.333612688150517_REALK, &
      0.000000000000000_REALK,     -0.065552663876167_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.039741049291934_REALK,      0.000000000000000_REALK, &
     -0.131271235208907_REALK,      0.000000000000000_REALK,     -0.018069461361880_REALK, &
      0.000000000000000_REALK,     -0.032419888361188_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.272076927688531_REALK, &
      0.000000000000000_REALK,     -0.005274028555675_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.064635150578627_REALK,      0.000000000000000_REALK, &
     -0.090249790244972_REALK,      0.000000000000000_REALK,      0.191372110442395_REALK, &
      0.000000000000000_REALK,     -0.002220921237741_REALK,      0.000000000000000_REALK, &
      0.297437682718019_REALK,      0.073354350340348_REALK,      0.000000000000000_REALK, &
      0.041976451646284_REALK,      0.000000000000000_REALK,      0.100075695994707_REALK, &
      0.027427095458973_REALK,      0.000000000000000_REALK,      0.028863758841150_REALK, &
      0.000000000000000_REALK,      0.032463433054760_REALK,      0.000000000000000_REALK, &
      0.020759978248056_REALK,      0.000000000000000_REALK,      0.082489474873352_REALK, &
      0.441595970007696_REALK,      0.176473788017795_REALK,      0.000000000000000_REALK, &
      0.196026741835587_REALK,      0.000000000000000_REALK,      0.116759043896938_REALK, &
      0.314434229018138_REALK,      0.000000000000000_REALK,      0.058537570560097_REALK, &
      0.000000000000000_REALK,      0.646707325826133_REALK,      0.000000000000000_REALK, &
      0.082547894747254_REALK,      0.000000000000000_REALK,      0.081946415202866_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.085776737194215_REALK, &
      0.000000000000000_REALK,     -0.025663222557508_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.012200956729443_REALK,      0.000000000000000_REALK, &
     -0.056252947622674_REALK,      0.000000000000000_REALK,     -0.001719604364445_REALK, &
      0.000000000000000_REALK,     -0.021153445212499_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.061222619435512_REALK, &
      0.000000000000000_REALK,      0.046923400903335_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.118332587266194_REALK,      0.000000000000000_REALK, &
     -0.033846607337882_REALK,      0.000000000000000_REALK,      0.253906446511857_REALK, &
      0.000000000000000_REALK,      0.032932819290207_REALK,      0.000000000000000_REALK, &
      7.316413023849051_REALK,      0.533648399120372_REALK,      0.000000000000000_REALK, &
      0.465287116896020_REALK,      0.000000000000000_REALK,      0.698184851876052_REALK, &
      0.081185460752582_REALK,      0.000000000000000_REALK,      0.058353885012949_REALK, &
      0.000000000000000_REALK,      0.095277164286916_REALK,      0.000000000000000_REALK, &
      0.061841423577680_REALK,      0.000000000000000_REALK,      0.278387754093152_REALK, &
      2.926150049902525_REALK,      0.054271846402249_REALK,      0.000000000000000_REALK, &
     -0.259926048516398_REALK,      0.000000000000000_REALK,      0.457213821754379_REALK, &
     -1.106005966292377_REALK,      0.000000000000000_REALK,      0.007252262736635_REALK, &
      0.000000000000000_REALK,     -2.569167080889426_REALK,      0.000000000000000_REALK, &
     -0.035472497113071_REALK,      0.000000000000000_REALK,      0.187189964970539_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.574152674448663_REALK, &
      0.000000000000000_REALK,     -0.074268729769490_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.049597353967218_REALK,      0.000000000000000_REALK, &
     -0.188348953355130_REALK,      0.000000000000000_REALK,     -0.019263532376967_REALK, &
      0.000000000000000_REALK,     -0.029613224670119_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.418168655209161_REALK, &
      0.000000000000000_REALK,     -0.102784562534627_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.127581617870933_REALK,      0.000000000000000_REALK, &
     -0.167637688240324_REALK,      0.000000000000000_REALK,     -0.209960844010862_REALK, &
      0.000000000000000_REALK,     -0.042081489545837_REALK,      0.000000000000000_REALK, &
      0.522699783407810_REALK,      0.088874912361389_REALK,      0.000000000000000_REALK, &
      0.045301808568440_REALK,      0.000000000000000_REALK,      0.149639339522512_REALK, &
      0.016249825298993_REALK,      0.000000000000000_REALK,      0.029155131496811_REALK, &
      0.000000000000000_REALK,      0.007309283705452_REALK,      0.000000000000000_REALK, &
      0.018063223098923_REALK,      0.000000000000000_REALK,      0.099443004579944_REALK, &
      0.277332115878167_REALK,      0.007229040639806_REALK,      0.000000000000000_REALK, &
     -0.093103657407421_REALK,      0.000000000000000_REALK,      0.130000247184975_REALK, &
     -0.249715984330595_REALK,      0.000000000000000_REALK,      0.002898016496350_REALK, &
      0.000000000000000_REALK,     -0.551487546892777_REALK,      0.000000000000000_REALK, &
     -0.038117986682579_REALK,      0.000000000000000_REALK,      0.088706642125493_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.135680507627216_REALK, &
      0.000000000000000_REALK,     -0.032902515179759_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.018669400984662_REALK,      0.000000000000000_REALK, &
     -0.074182596196556_REALK,      0.000000000000000_REALK,     -0.012466247194219_REALK, &
      0.000000000000000_REALK,     -0.021865406370764_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.160040065101208_REALK, &
      0.000000000000000_REALK,     -0.084320402537938_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.107714382955681_REALK,      0.000000000000000_REALK, &
     -0.106929529529890_REALK,      0.000000000000000_REALK,     -0.185434699957574_REALK, &
      0.000000000000000_REALK,     -0.057536658073946_REALK,      0.000000000000000_REALK, &
      0.134393815179523_REALK,      0.034793653237616_REALK,      0.000000000000000_REALK, &
      0.013908173436710_REALK,      0.000000000000000_REALK,      0.064124131345724_REALK, &
      0.001546436274220_REALK,      0.000000000000000_REALK,      0.019023244926387_REALK, &
      0.000000000000000_REALK,     -0.009937409748775_REALK,      0.000000000000000_REALK, &
      0.009242693526840_REALK,      0.000000000000000_REALK,      0.059659276968366_REALK, &
      0.062405139354894_REALK,     -0.064317280141215_REALK,      0.000000000000000_REALK, &
     -0.170452092496690_REALK,      0.000000000000000_REALK,      0.048754321847774_REALK, &
     -0.331315247932522_REALK,      0.000000000000000_REALK,     -0.042973092405286_REALK, &
      0.000000000000000_REALK,     -0.638561497363930_REALK,      0.000000000000000_REALK, &
     -0.116309261682642_REALK,      0.000000000000000_REALK,      0.046575027228180_REALK, &
     20.457951024715527_REALK,      0.485524138186440_REALK,      0.000000000000000_REALK, &
      0.926180647914053_REALK,      0.000000000000000_REALK,      1.488552762524031_REALK, &
      0.045368372376199_REALK,      0.000000000000000_REALK,      0.040647897297172_REALK, &
      0.000000000000000_REALK,      0.183487946583758_REALK,      0.000000000000000_REALK, &
      0.093133736047534_REALK,      0.000000000000000_REALK,      0.449052181310334_REALK, &
     41.920865562491691_REALK,      2.010394816637743_REALK,      0.000000000000000_REALK, &
      3.180908371893899_REALK,      0.000000000000000_REALK,      2.463647764877023_REALK, &
      3.085120660975134_REALK,      0.000000000000000_REALK,      0.132544840542125_REALK, &
      0.000000000000000_REALK,      5.606181795645064_REALK,      0.000000000000000_REALK, &
      0.241569788768243_REALK,      0.000000000000000_REALK,      0.561295203048887_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.341598989876708_REALK, &
      0.000000000000000_REALK,     -0.090815754379966_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.074851513627002_REALK,      0.000000000000000_REALK, &
     -0.336954480727941_REALK,      0.000000000000000_REALK,     -0.012705185256352_REALK, &
      0.000000000000000_REALK,     -0.027396417264053_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.763577586296209_REALK, &
      0.000000000000000_REALK,     -0.030154002382272_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.103581831690657_REALK,      0.000000000000000_REALK, &
     -0.546605991226189_REALK,      0.000000000000000_REALK,      0.349237093781852_REALK, &
      0.000000000000000_REALK,     -0.006870014914952_REALK,      0.000000000000000_REALK, &
      1.342861669683392_REALK,      0.142711278496577_REALK,      0.000000000000000_REALK, &
      0.077188024666801_REALK,      0.000000000000000_REALK,      0.293126195142405_REALK, &
      0.023316160476279_REALK,      0.000000000000000_REALK,      0.035843202851736_REALK, &
      0.000000000000000_REALK,      0.020263517100890_REALK,      0.000000000000000_REALK, &
      0.023285335743753_REALK,      0.000000000000000_REALK,      0.147379119551331_REALK, &
      3.953424683435445_REALK,      0.621269742345091_REALK,      0.000000000000000_REALK, &
      0.530468427430290_REALK,      0.000000000000000_REALK,      0.697016563537039_REALK, &
      0.613098331832623_REALK,      0.000000000000000_REALK,      0.122880488326909_REALK, &
      0.000000000000000_REALK,      0.986517242426991_REALK,      0.000000000000000_REALK, &
      0.120857124110991_REALK,      0.000000000000000_REALK,      0.264669906101944_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.287539877454775_REALK, &
      0.000000000000000_REALK,     -0.045373932863981_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.021863332241023_REALK,      0.000000000000000_REALK, &
     -0.120363649182102_REALK,      0.000000000000000_REALK,     -0.007629089207349_REALK, &
      0.000000000000000_REALK,     -0.022813281060828_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.785771891048312_REALK, &
      0.000000000000000_REALK,     -0.012049590522052_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.111306820840833_REALK,      0.000000000000000_REALK, &
     -0.259028746840053_REALK,      0.000000000000000_REALK,      0.236554107201183_REALK, &
      0.000000000000000_REALK,     -0.004575449363577_REALK,      0.000000000000000_REALK, &
      0.317337462880815_REALK,      0.063223917005585_REALK,      0.000000000000000_REALK, &
      0.029055061781541_REALK,      0.000000000000000_REALK,      0.115449869943702_REALK, &
      0.015088874378249_REALK,      0.000000000000000_REALK,      0.026465412149921_REALK, &
      0.000000000000000_REALK,      0.013706353598013_REALK,      0.000000000000000_REALK, &
      0.014608416084386_REALK,      0.000000000000000_REALK,      0.081264863574861_REALK, &
      1.513041056109916_REALK,      0.509665201343154_REALK,      0.000000000000000_REALK, &
      0.447862946807338_REALK,      0.000000000000000_REALK,      0.444599624320210_REALK, &
      0.541480511489990_REALK,      0.000000000000000_REALK,      0.168010512867510_REALK, &
      0.000000000000000_REALK,      0.799391686320534_REALK,      0.000000000000000_REALK, &
      0.170061732072081_REALK,      0.000000000000000_REALK,      0.236351624579078_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.123217897966394_REALK, &
      0.000000000000000_REALK,     -0.029605746701549_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.011187155153462_REALK,      0.000000000000000_REALK, &
     -0.072210290847613_REALK,      0.000000000000000_REALK,     -0.001210054064420_REALK, &
      0.000000000000000_REALK,     -0.020839408202941_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.294690021785831_REALK, &
      0.000000000000000_REALK,      0.178676749287739_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.339630061263340_REALK,      0.000000000000000_REALK, &
     -0.136001889462679_REALK,      0.000000000000000_REALK,      0.523087478006335_REALK, &
      0.000000000000000_REALK,      0.094985550276242_REALK,      0.000000000000000_REALK, &
      6.092933375028094_REALK,     -0.098105331191620_REALK,      0.000000000000000_REALK, &
      1.734438304433414_REALK,      0.000000000000000_REALK,      2.640381414477229_REALK, &
     -0.240232616383634_REALK,      0.000000000000000_REALK,     -0.049732176990019_REALK, &
      0.000000000000000_REALK,      3.054003971474601_REALK,      0.000000000000000_REALK, &
      2.163725046884120_REALK,      0.000000000000000_REALK,      9.881688011436026_REALK, &
      1.351458912198127_REALK,     -0.118704941364118_REALK,      0.000000000000000_REALK, &
     -0.364826597552309_REALK,      0.000000000000000_REALK,      0.926585014398718_REALK, &
     -1.139265479763935_REALK,      0.000000000000000_REALK,     -0.100668246442102_REALK, &
      0.000000000000000_REALK,    -20.410056733904078_REALK,      0.000000000000000_REALK, &
     -0.542767448904745_REALK,      0.000000000000000_REALK,      4.135555256930927_REALK, &
      6.953670629852341_REALK,     -0.672040247137829_REALK,      0.000000000000000_REALK, &
      1.995084221036752_REALK,      0.000000000000000_REALK,      2.666494100701815_REALK, &
     -0.695753569310541_REALK,      0.000000000000000_REALK,     -0.290231797074043_REALK, &
      0.000000000000000_REALK,      5.287867226556706_REALK,      0.000000000000000_REALK, &
      2.137147585873863_REALK,      0.000000000000000_REALK,      8.569099043498683_REALK, &
      3.273662336386505_REALK,     -0.248180687485766_REALK,      0.000000000000000_REALK, &
      1.240707703276670_REALK,      0.000000000000000_REALK,      1.173235208121695_REALK, &
      0.629026952828814_REALK,      0.000000000000000_REALK,     -0.116454139375818_REALK, &
      0.000000000000000_REALK,     12.489218723170294_REALK,      0.000000000000000_REALK, &
      1.464226923220694_REALK,      0.000000000000000_REALK,      4.153796839816533_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.728097307688972_REALK, &
      0.000000000000000_REALK,      0.058340660737886_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.206552912112752_REALK,      0.000000000000000_REALK, &
     -0.943322922795143_REALK,      0.000000000000000_REALK,      0.301883324963578_REALK, &
      0.000000000000000_REALK,      0.187484720102896_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.400893906413310_REALK, &
      0.000000000000000_REALK,      0.145391781054126_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.074065783736298_REALK,      0.000000000000000_REALK, &
     -0.564335871481330_REALK,      0.000000000000000_REALK,      1.941829975010857_REALK, &
      0.000000000000000_REALK,      0.514754344650797_REALK,      0.000000000000000_REALK, &
      9.917586444694720_REALK,     -1.942082791665780_REALK,      0.000000000000000_REALK, &
      2.767483344208519_REALK,      0.000000000000000_REALK,      3.201192671753681_REALK, &
     -1.777094255132045_REALK,      0.000000000000000_REALK,     -0.730670338888151_REALK, &
      0.000000000000000_REALK,      6.267974210683882_REALK,      0.000000000000000_REALK, &
      2.375805601733318_REALK,      0.000000000000000_REALK,      8.244398107431216_REALK, &
      2.681756599156738_REALK,     -0.998151109767032_REALK,      0.000000000000000_REALK, &
      0.902184099919802_REALK,      0.000000000000000_REALK,      1.496891065315245_REALK, &
     -1.929078318601748_REALK,      0.000000000000000_REALK,     -0.506725387649332_REALK, &
      0.000000000000000_REALK,     -3.637056026998345_REALK,      0.000000000000000_REALK, &
      0.854089235642389_REALK,      0.000000000000000_REALK,      4.251278245522172_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.176293299626794_REALK, &
      0.000000000000000_REALK,      0.225790419317370_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.331123472249916_REALK,      0.000000000000000_REALK, &
     -1.327671447723865_REALK,      0.000000000000000_REALK,      0.464667019011611_REALK, &
      0.000000000000000_REALK,      0.581503925746665_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.623898751974747_REALK, &
      0.000000000000000_REALK,      0.105402055971796_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.334946063271983_REALK,      0.000000000000000_REALK, &
     -0.950192813056510_REALK,      0.000000000000000_REALK,     -0.538978555741308_REALK, &
      0.000000000000000_REALK,      0.299349416914207_REALK,      0.000000000000000_REALK, &
      0.757868459036952_REALK,     -0.025736313575085_REALK,      0.000000000000000_REALK, &
      0.160691106582178_REALK,      0.000000000000000_REALK,      0.733872995436348_REALK, &
     -0.046772930160280_REALK,      0.000000000000000_REALK,     -0.029048340846751_REALK, &
      0.000000000000000_REALK,      0.194708653182466_REALK,      0.000000000000000_REALK, &
      0.413846210094373_REALK,      0.000000000000000_REALK,      3.150045287837360_REALK, &
      0.305028006118912_REALK,     -0.077315912546025_REALK,      0.000000000000000_REALK, &
     -0.067036568427806_REALK,      0.000000000000000_REALK,      0.510777559574828_REALK, &
     -0.444199116515895_REALK,      0.000000000000000_REALK,     -0.117751516898550_REALK, &
      0.000000000000000_REALK,     -2.386438639715816_REALK,      0.000000000000000_REALK, &
     -0.190388673975797_REALK,      0.000000000000000_REALK,      2.417741653168846_REALK, &
     17.160532537166869_REALK,     -4.724132392150252_REALK,      0.000000000000000_REALK, &
      4.716813518007143_REALK,      0.000000000000000_REALK,      4.519672298785419_REALK, &
     -3.783501715803018_REALK,      0.000000000000000_REALK,     -1.509527509407805_REALK, &
      0.000000000000000_REALK,      9.418763174199256_REALK,      0.000000000000000_REALK, &
      3.081096721759506_REALK,      0.000000000000000_REALK,      8.856962936982017_REALK, &
     13.212865893308587_REALK,     -3.558635691437382_REALK,      0.000000000000000_REALK, &
      3.452193793808696_REALK,      0.000000000000000_REALK,      2.992031263911771_REALK, &
     -1.645782599189480_REALK,      0.000000000000000_REALK,     -1.111263004573738_REALK, &
      0.000000000000000_REALK,     10.801844577593684_REALK,      0.000000000000000_REALK, &
      2.102631771504015_REALK,      0.000000000000000_REALK,      5.467080099718321_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.969140207497202_REALK, &
      0.000000000000000_REALK,      0.516375084515101_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.543962315411609_REALK,      0.000000000000000_REALK, &
     -1.887629981350962_REALK,      0.000000000000000_REALK,      0.820372114272399_REALK, &
      0.000000000000000_REALK,      1.011912962442045_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.702767047185766_REALK, &
      0.000000000000000_REALK,      0.514592633258533_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.320474542114640_REALK,      0.000000000000000_REALK, &
     -1.595180447521880_REALK,      0.000000000000000_REALK,      1.193187832536818_REALK, &
      0.000000000000000_REALK,      0.940270637771094_REALK,      0.000000000000000_REALK, &
      1.187509181123405_REALK,     -0.138889794753253_REALK,      0.000000000000000_REALK, &
      0.234009650957184_REALK,      0.000000000000000_REALK,      0.938284229615680_REALK, &
     -0.106389743071806_REALK,      0.000000000000000_REALK,     -0.133140616235319_REALK, &
      0.000000000000000_REALK,      0.378212973221117_REALK,      0.000000000000000_REALK, &
      0.458576345453377_REALK,      0.000000000000000_REALK,      3.064510026642882_REALK, &
      1.420405310984052_REALK,     -0.119898603026671_REALK,      0.000000000000000_REALK, &
      0.340146321656153_REALK,      0.000000000000000_REALK,      0.964945182719872_REALK, &
      0.202237539887610_REALK,      0.000000000000000_REALK,     -0.112323002462044_REALK, &
      0.000000000000000_REALK,      1.767098333098918_REALK,      0.000000000000000_REALK, &
      0.621519971581948_REALK,      0.000000000000000_REALK,      2.938601538803101_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.451425131408434_REALK, &
      0.000000000000000_REALK,      0.020528874187762_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.094753856335306_REALK,      0.000000000000000_REALK, &
     -0.721231538124717_REALK,      0.000000000000000_REALK,      0.064776318130835_REALK, &
      0.000000000000000_REALK,      0.067048916307434_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.581027716070184_REALK, &
      0.000000000000000_REALK,      0.119579686804531_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.071438346919706_REALK,      0.000000000000000_REALK, &
     -0.907194022493453_REALK,      0.000000000000000_REALK,      0.824247998548662_REALK, &
      0.000000000000000_REALK,      0.364162708873173_REALK,      0.000000000000000_REALK, &
     35.174997182888674_REALK,    -11.608704089995534_REALK,      0.000000000000000_REALK, &
      9.449202518928152_REALK,      0.000000000000000_REALK,      7.467953919117862_REALK, &
     -8.196176018975068_REALK,      0.000000000000000_REALK,     -3.049466990670063_REALK, &
      0.000000000000000_REALK,     15.364394905233834_REALK,      0.000000000000000_REALK, &
      4.520283171501681_REALK,      0.000000000000000_REALK,     10.717496960780878_REALK, &
     15.432696140514393_REALK,     -8.469171963602296_REALK,      0.000000000000000_REALK, &
      6.939207695269991_REALK,      0.000000000000000_REALK,      5.699625800464163_REALK, &
     -8.435993473495824_REALK,      0.000000000000000_REALK,     -2.865845484466327_REALK, &
      0.000000000000000_REALK,      6.323245728570832_REALK,      0.000000000000000_REALK, &
      3.296123581809255_REALK,      0.000000000000000_REALK,      8.121966584688350_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.663663288218865_REALK, &
      0.000000000000000_REALK,      1.131742049595066_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.004378731434964_REALK,      0.000000000000000_REALK, &
     -2.887200890575238_REALK,      0.000000000000000_REALK,      1.356971856213045_REALK, &
      0.000000000000000_REALK,      1.624198824509593_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.936331189142715_REALK, &
      0.000000000000000_REALK,      1.109399707142218_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.146425660778978_REALK,      0.000000000000000_REALK, &
     -2.980836207648452_REALK,      0.000000000000000_REALK,      0.780435932400630_REALK, &
      0.000000000000000_REALK,      1.580894547452281_REALK,      0.000000000000000_REALK, &
      2.221950983488663_REALK,     -0.418575576949966_REALK,      0.000000000000000_REALK, &
      0.407826304528842_REALK,      0.000000000000000_REALK,      1.415217815281364_REALK, &
     -0.267425653215779_REALK,      0.000000000000000_REALK,     -0.329864314340557_REALK, &
      0.000000000000000_REALK,      0.514709302915732_REALK,      0.000000000000000_REALK, &
      0.585284433548120_REALK,      0.000000000000000_REALK,      3.385039775373221_REALK, &
      1.437325779934930_REALK,     -0.505012904432227_REALK,      0.000000000000000_REALK, &
      0.319937190120798_REALK,      0.000000000000000_REALK,      1.592505747096828_REALK, &
     -0.650566194180066_REALK,      0.000000000000000_REALK,     -0.512667221063980_REALK, &
      0.000000000000000_REALK,     -0.647150169178353_REALK,      0.000000000000000_REALK, &
      0.455910485763573_REALK,      0.000000000000000_REALK,      3.782201065080232_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.760576709705584_REALK, &
      0.000000000000000_REALK,      0.099819866125939_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.149487137115748_REALK,      0.000000000000000_REALK, &
     -0.998971785368558_REALK,      0.000000000000000_REALK,      0.114471643981430_REALK, &
      0.000000000000000_REALK,      0.238757747083305_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.946981627501111_REALK, &
      0.000000000000000_REALK,      0.112134666162602_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.338873621983984_REALK,      0.000000000000000_REALK, &
     -1.602224534293371_REALK,      0.000000000000000_REALK,     -0.287705271193765_REALK, &
      0.000000000000000_REALK,      0.266319826202060_REALK,      0.000000000000000_REALK, &
      0.509381968275053_REALK,     -0.016640782282021_REALK,      0.000000000000000_REALK, &
      0.071040059162635_REALK,      0.000000000000000_REALK,      0.540730827429629_REALK, &
     -0.021115843515007_REALK,      0.000000000000000_REALK,     -0.021856667150161_REALK, &
      0.000000000000000_REALK,      0.047966863829968_REALK,      0.000000000000000_REALK, &
      0.169919727771783_REALK,      0.000000000000000_REALK,      1.810713145635608_REALK, &
      0.490452359026231_REALK,     -0.117353574538857_REALK,      0.000000000000000_REALK, &
     -0.071318563495098_REALK,      0.000000000000000_REALK,      0.905672895374990_REALK, &
     -0.449407770389574_REALK,      0.000000000000000_REALK,     -0.198553774278966_REALK, &
      0.000000000000000_REALK,     -1.273874384635552_REALK,      0.000000000000000_REALK, &
     -0.169381584526709_REALK,      0.000000000000000_REALK,      3.011362310022881_REALK, &
     96.312319396971617_REALK,    -33.433481727817174_REALK,      0.000000000000000_REALK, &
     23.089515610015411_REALK,      0.000000000000000_REALK,     15.116016713997823_REALK, &
    -19.372778977728924_REALK,      0.000000000000000_REALK,     -6.645072135550438_REALK, &
      0.000000000000000_REALK,     28.669606753756462_REALK,      0.000000000000000_REALK, &
      7.616984878159422_REALK,      0.000000000000000_REALK,     14.959837963675188_REALK, &
    205.346797938833902_REALK,    -69.354711825477182_REALK,      0.000000000000000_REALK, &
     42.539444307659807_REALK,      0.000000000000000_REALK,     25.933745353045001_REALK, &
    -28.187512430973445_REALK,      0.000000000000000_REALK,    -10.878747069906266_REALK, &
      0.000000000000000_REALK,     42.577775470589017_REALK,      0.000000000000000_REALK, &
      9.722750144212188_REALK,      0.000000000000000_REALK,     17.782131182602999_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.456220137924239_REALK, &
      0.000000000000000_REALK,      2.786210658773621_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.126610244798384_REALK,      0.000000000000000_REALK, &
     -5.042148460761243_REALK,      0.000000000000000_REALK,      2.470412980668528_REALK, &
      0.000000000000000_REALK,      2.757423518149470_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -19.589800423124988_REALK, &
      0.000000000000000_REALK,      6.352590345080058_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.741075407709598_REALK,      0.000000000000000_REALK, &
     -9.218370821987905_REALK,      0.000000000000000_REALK,      4.273971551239176_REALK, &
      0.000000000000000_REALK,      4.355814917118688_REALK,      0.000000000000000_REALK, &
      5.602608027283821_REALK,     -1.281510305817730_REALK,      0.000000000000000_REALK, &
      0.917672083525235_REALK,      0.000000000000000_REALK,      2.637952770091740_REALK, &
     -0.638400326227143_REALK,      0.000000000000000_REALK,     -0.764119797088758_REALK, &
      0.000000000000000_REALK,      0.925431625318606_REALK,      0.000000000000000_REALK, &
      0.908190691573728_REALK,      0.000000000000000_REALK,      4.351162384361976_REALK, &
     17.439644595412705_REALK,     -3.813043103745424_REALK,      0.000000000000000_REALK, &
      2.541230022166651_REALK,      0.000000000000000_REALK,      6.607485091436759_REALK, &
     -0.885788897634199_REALK,      0.000000000000000_REALK,     -1.794303389076684_REALK, &
      0.000000000000000_REALK,      2.983843163723638_REALK,      0.000000000000000_REALK, &
      1.742458908428772_REALK,      0.000000000000000_REALK,      7.550983289887361_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.602499629583285_REALK, &
      0.000000000000000_REALK,      0.301387577362418_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.275352632850866_REALK,      0.000000000000000_REALK, &
     -1.592524183162456_REALK,      0.000000000000000_REALK,      0.241814647539976_REALK, &
      0.000000000000000_REALK,      0.497122732674145_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.473494374975603_REALK, &
      0.000000000000000_REALK,      1.136406291414743_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.517454963102698_REALK,      0.000000000000000_REALK, &
     -4.292769685479447_REALK,      0.000000000000000_REALK,      0.988799273562496_REALK, &
      0.000000000000000_REALK,      1.298676394762732_REALK,      0.000000000000000_REALK, &
      1.163101749242153_REALK,     -0.113029455087851_REALK,      0.000000000000000_REALK, &
      0.136582116171696_REALK,      0.000000000000000_REALK,      0.912731911748421_REALK, &
     -0.053854274520804_REALK,      0.000000000000000_REALK,     -0.112325854754728_REALK, &
      0.000000000000000_REALK,      0.111482868838888_REALK,      0.000000000000000_REALK, &
      0.225284915257286_REALK,      0.000000000000000_REALK,      2.107703643904047_REALK, &
      5.624373395981457_REALK,     -0.385410517732624_REALK,      0.000000000000000_REALK, &
      0.751165863926067_REALK,      0.000000000000000_REALK,      3.551578814130603_REALK, &
      0.326543313081912_REALK,      0.000000000000000_REALK,     -0.302270994294193_REALK, &
      0.000000000000000_REALK,      1.464401077881250_REALK,      0.000000000000000_REALK, &
      0.858426588626048_REALK,      0.000000000000000_REALK,      5.682203844570680_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.612288045913248_REALK, &
      0.000000000000000_REALK,      0.019969810844112_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.079940353328082_REALK,      0.000000000000000_REALK, &
     -0.851867234817627_REALK,      0.000000000000000_REALK,      0.031822677914964_REALK, &
      0.000000000000000_REALK,      0.046114792900779_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.112827383788064_REALK, &
      0.000000000000000_REALK,      0.440125190384661_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.192246821050300_REALK,      0.000000000000000_REALK, &
     -3.417873511752967_REALK,      0.000000000000000_REALK,      1.138429060895728_REALK, &
      0.000000000000000_REALK,      0.704160369170441_REALK,      0.000000000000000_REALK/
    ! results of test 2, ket-major order, CM020001
  data REF_CONTR_INTS(6301:7560)                                                           &
     /0.000000000000000_REALK,      0.000000000000000_REALK,     -1.020503713224634_REALK, &
      0.000000000000000_REALK,     -1.186965186130659_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.802888323955508_REALK,      0.000000000000000_REALK, &
     -0.850095117220694_REALK,      0.000000000000000_REALK,     -4.373972347469388_REALK, &
      0.000000000000000_REALK,     -1.569152455999963_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.867828245223924_REALK, &
      0.000000000000000_REALK,     -1.313688973148308_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.350792305842416_REALK,      0.000000000000000_REALK, &
     -0.850229948765964_REALK,      0.000000000000000_REALK,     -6.102785153501406_REALK, &
      0.000000000000000_REALK,     -1.778430519622148_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.630344081581095_REALK, &
      0.000000000000000_REALK,     -0.528871882678467_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.604127886725306_REALK,      0.000000000000000_REALK, &
     -0.459801335535293_REALK,      0.000000000000000_REALK,     -1.006259001486697_REALK, &
      0.000000000000000_REALK,     -0.576544463722668_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.413675780914639_REALK, &
      0.000000000000000_REALK,     -0.298692671343571_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.234064065320264_REALK,      0.000000000000000_REALK, &
     -0.286077840257019_REALK,      0.000000000000000_REALK,     -0.057407231495663_REALK, &
      0.000000000000000_REALK,     -0.309607715604502_REALK,      0.000000000000000_REALK, &
      0.778967681580850_REALK,      0.762954762076273_REALK,      0.000000000000000_REALK, &
      0.980916612378344_REALK,      0.000000000000000_REALK,      0.462520285645863_REALK, &
      1.551322991770541_REALK,      0.000000000000000_REALK,      0.556533532726681_REALK, &
      0.000000000000000_REALK,      3.581592279907965_REALK,      0.000000000000000_REALK, &
      1.069336564795516_REALK,      0.000000000000000_REALK,      0.840353208348667_REALK, &
      1.226542279318010_REALK,      1.207958238085582_REALK,      0.000000000000000_REALK, &
      1.653774121774744_REALK,      0.000000000000000_REALK,      0.598133779548483_REALK, &
      2.866600823854721_REALK,      0.000000000000000_REALK,      0.835364553148701_REALK, &
      0.000000000000000_REALK,      6.887429539259326_REALK,      0.000000000000000_REALK, &
      1.714207535341797_REALK,      0.000000000000000_REALK,      1.033318696655051_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.519565612937804_REALK, &
      0.000000000000000_REALK,     -0.338805517036113_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.328366239735891_REALK,      0.000000000000000_REALK, &
     -0.329580654967699_REALK,      0.000000000000000_REALK,     -0.453313298855020_REALK, &
      0.000000000000000_REALK,     -0.304538224116135_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.288126376460119_REALK, &
      0.000000000000000_REALK,     -0.239449574541176_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.282540619571635_REALK,      0.000000000000000_REALK, &
     -0.212584723173834_REALK,      0.000000000000000_REALK,     -0.497670641071732_REALK, &
      0.000000000000000_REALK,     -0.216881660243797_REALK,      0.000000000000000_REALK, &
      0.534615735634721_REALK,      0.382442149408176_REALK,      0.000000000000000_REALK, &
      0.366808804358701_REALK,      0.000000000000000_REALK,      0.279177938705093_REALK, &
      0.423412850977629_REALK,      0.000000000000000_REALK,      0.242597914393326_REALK, &
      0.000000000000000_REALK,      0.653656305995717_REALK,      0.000000000000000_REALK, &
      0.329709217390503_REALK,      0.000000000000000_REALK,      0.418235779282336_REALK, &
      0.258892788234387_REALK,      0.232631559665298_REALK,      0.000000000000000_REALK, &
      0.171945371112750_REALK,      0.000000000000000_REALK,      0.210155114339410_REALK, &
      0.031825299180437_REALK,      0.000000000000000_REALK,      0.171639668400126_REALK, &
      0.000000000000000_REALK,     -0.428579472317104_REALK,      0.000000000000000_REALK, &
      0.155739669321301_REALK,      0.000000000000000_REALK,      0.317246962427562_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.334461441382445_REALK, &
      0.000000000000000_REALK,     -0.337910902990347_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.449954577187133_REALK,      0.000000000000000_REALK, &
     -0.353603145163826_REALK,      0.000000000000000_REALK,     -0.846651016739323_REALK, &
      0.000000000000000_REALK,     -0.506223487771555_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.465846026281682_REALK, &
      0.000000000000000_REALK,     -0.613665612912665_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.950318735954605_REALK,      0.000000000000000_REALK, &
     -0.572849026385647_REALK,      0.000000000000000_REALK,     -1.907355850512320_REALK, &
      0.000000000000000_REALK,     -0.926380270376712_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.509489167999453_REALK, &
      0.000000000000000_REALK,     -0.251944860602205_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.202591137092946_REALK,      0.000000000000000_REALK, &
     -0.278569084694551_REALK,      0.000000000000000_REALK,     -0.214714898435048_REALK, &
      0.000000000000000_REALK,     -0.186441059495848_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.348737980165484_REALK, &
      0.000000000000000_REALK,     -0.150636901156564_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.081313821159577_REALK,      0.000000000000000_REALK, &
     -0.171908547010114_REALK,      0.000000000000000_REALK,      0.003305566242604_REALK, &
      0.000000000000000_REALK,     -0.101395751394670_REALK,      0.000000000000000_REALK, &
      0.498141531633661_REALK,      0.278503456838321_REALK,      0.000000000000000_REALK, &
      0.226026549202582_REALK,      0.000000000000000_REALK,      0.226862475832449_REALK, &
      0.226665384566547_REALK,      0.000000000000000_REALK,      0.152274980369755_REALK, &
      0.000000000000000_REALK,      0.311780557984997_REALK,      0.000000000000000_REALK, &
      0.167261317443801_REALK,      0.000000000000000_REALK,      0.279799848883302_REALK, &
      0.561588843128981_REALK,      0.309181471240708_REALK,      0.000000000000000_REALK, &
      0.274158404781078_REALK,      0.000000000000000_REALK,      0.206277910321453_REALK, &
      0.349728377752212_REALK,      0.000000000000000_REALK,      0.152409374677854_REALK, &
      0.000000000000000_REALK,      0.659431624401708_REALK,      0.000000000000000_REALK, &
      0.184539759119509_REALK,      0.000000000000000_REALK,      0.231414121778695_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.229488650841768_REALK, &
      0.000000000000000_REALK,     -0.166989059162020_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.164860962040417_REALK,      0.000000000000000_REALK, &
     -0.209125948852516_REALK,      0.000000000000000_REALK,     -0.215675616756814_REALK, &
      0.000000000000000_REALK,     -0.205955230574165_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.271355952770943_REALK, &
      0.000000000000000_REALK,     -0.166547584404235_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.109443027995606_REALK,      0.000000000000000_REALK, &
     -0.222939141593077_REALK,      0.000000000000000_REALK,     -0.020786508692337_REALK, &
      0.000000000000000_REALK,     -0.186842415260112_REALK,      0.000000000000000_REALK, &
      0.320670056935807_REALK,      0.277768070040427_REALK,      0.000000000000000_REALK, &
      0.309720269846603_REALK,      0.000000000000000_REALK,      0.243398038582903_REALK, &
      0.423341822945841_REALK,      0.000000000000000_REALK,      0.253121498579851_REALK, &
      0.000000000000000_REALK,      0.767657355411798_REALK,      0.000000000000000_REALK, &
      0.381992149125526_REALK,      0.000000000000000_REALK,      0.420271478699723_REALK, &
      0.907983275220810_REALK,      0.792375753491019_REALK,      0.000000000000000_REALK, &
      0.922125353437292_REALK,      0.000000000000000_REALK,      0.555854147599702_REALK, &
      1.340357281191755_REALK,      0.000000000000000_REALK,      0.650995743777069_REALK, &
      0.000000000000000_REALK,      2.493860272577155_REALK,      0.000000000000000_REALK, &
      1.034491907073419_REALK,      0.000000000000000_REALK,      0.873023674152633_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.588540355847251_REALK, &
      0.000000000000000_REALK,     -0.218832441554568_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.152940120856989_REALK,      0.000000000000000_REALK, &
     -0.275331358494937_REALK,      0.000000000000000_REALK,     -0.131776678582085_REALK, &
      0.000000000000000_REALK,     -0.132989854651000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.331619495605939_REALK, &
      0.000000000000000_REALK,     -0.153907285521913_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.127979830983270_REALK,      0.000000000000000_REALK, &
     -0.181569608671840_REALK,      0.000000000000000_REALK,     -0.160848647140272_REALK, &
      0.000000000000000_REALK,     -0.093886930477485_REALK,      0.000000000000000_REALK, &
      0.558287861856483_REALK,      0.238220494742982_REALK,      0.000000000000000_REALK, &
      0.160693915338243_REALK,      0.000000000000000_REALK,      0.220959107856830_REALK, &
      0.128345063743067_REALK,      0.000000000000000_REALK,      0.111444477489568_REALK, &
      0.000000000000000_REALK,      0.133848576694382_REALK,      0.000000000000000_REALK, &
      0.097657642954205_REALK,      0.000000000000000_REALK,      0.223803803410374_REALK, &
      0.275948742789156_REALK,      0.152064374698037_REALK,      0.000000000000000_REALK, &
      0.080468953433202_REALK,      0.000000000000000_REALK,      0.170122381003085_REALK, &
     -0.002714292773276_REALK,      0.000000000000000_REALK,      0.083258883668467_REALK, &
      0.000000000000000_REALK,     -0.165509717402360_REALK,      0.000000000000000_REALK, &
      0.049087884377659_REALK,      0.000000000000000_REALK,      0.172964176709131_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.214504439988369_REALK, &
      0.000000000000000_REALK,     -0.120783481226248_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.099979855173245_REALK,      0.000000000000000_REALK, &
     -0.167249360440124_REALK,      0.000000000000000_REALK,     -0.109262465839866_REALK, &
      0.000000000000000_REALK,     -0.122338484934031_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.208232652200192_REALK, &
      0.000000000000000_REALK,     -0.150825809177844_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.151530750799740_REALK,      0.000000000000000_REALK, &
     -0.190020599279523_REALK,      0.000000000000000_REALK,     -0.211125561754085_REALK, &
      0.000000000000000_REALK,     -0.153345266843292_REALK,      0.000000000000000_REALK, &
      0.251468993348485_REALK,      0.157892549167932_REALK,      0.000000000000000_REALK, &
      0.130766596490102_REALK,      0.000000000000000_REALK,      0.165877283686494_REALK, &
      0.128919329688956_REALK,      0.000000000000000_REALK,      0.123109003562021_REALK, &
      0.000000000000000_REALK,      0.157551300580113_REALK,      0.000000000000000_REALK, &
      0.132450125896043_REALK,      0.000000000000000_REALK,      0.235217974438341_REALK, &
      0.214718035529032_REALK,      0.168125831621935_REALK,      0.000000000000000_REALK, &
      0.108305891886250_REALK,      0.000000000000000_REALK,      0.220622756961391_REALK, &
      0.017068382898535_REALK,      0.000000000000000_REALK,      0.153421526074857_REALK, &
      0.000000000000000_REALK,     -0.181815189367733_REALK,      0.000000000000000_REALK, &
      0.110115078994302_REALK,      0.000000000000000_REALK,      0.314031385021629_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.230139249644146_REALK, &
      0.000000000000000_REALK,     -0.200774255215413_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.228334442957612_REALK,      0.000000000000000_REALK, &
     -0.251215775506263_REALK,      0.000000000000000_REALK,     -0.340114949301887_REALK, &
      0.000000000000000_REALK,     -0.284702718669977_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.561121562705327_REALK, &
      0.000000000000000_REALK,     -0.644231760900834_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.849450200450151_REALK,      0.000000000000000_REALK, &
     -0.716864124248824_REALK,      0.000000000000000_REALK,     -1.348587942074701_REALK, &
      0.000000000000000_REALK,     -0.916990590349733_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.804745371243785_REALK, &
      0.000000000000000_REALK,     -0.215742722099053_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.133921067600572_REALK,      0.000000000000000_REALK, &
     -0.316654379956197_REALK,      0.000000000000000_REALK,     -0.088053897357081_REALK, &
      0.000000000000000_REALK,     -0.106698256815359_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.754872879337001_REALK, &
      0.000000000000000_REALK,     -0.172820213194183_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.067706634376598_REALK,      0.000000000000000_REALK, &
     -0.250396531600700_REALK,      0.000000000000000_REALK,      0.017534439080069_REALK, &
      0.000000000000000_REALK,     -0.072775503155160_REALK,      0.000000000000000_REALK, &
      0.767216326763468_REALK,      0.244993026162889_REALK,      0.000000000000000_REALK, &
      0.143389126117644_REALK,      0.000000000000000_REALK,      0.258137123641279_REALK, &
      0.095521422201409_REALK,      0.000000000000000_REALK,      0.096400821384409_REALK, &
      0.000000000000000_REALK,      0.087938998057292_REALK,      0.000000000000000_REALK, &
      0.070914882570203_REALK,      0.000000000000000_REALK,      0.212774895671101_REALK, &
      1.063363926968480_REALK,      0.325238088364285_REALK,      0.000000000000000_REALK, &
      0.198173567149616_REALK,      0.000000000000000_REALK,      0.281155997472462_REALK, &
      0.184828167668752_REALK,      0.000000000000000_REALK,      0.107883713271546_REALK, &
      0.000000000000000_REALK,      0.285185877020619_REALK,      0.000000000000000_REALK, &
      0.083451934208420_REALK,      0.000000000000000_REALK,      0.197327122051387_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.247373927318716_REALK, &
      0.000000000000000_REALK,     -0.104484854257497_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.070789437434579_REALK,      0.000000000000000_REALK, &
     -0.162229446256129_REALK,      0.000000000000000_REALK,     -0.059510709634625_REALK, &
      0.000000000000000_REALK,     -0.086123815320510_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.359503955890029_REALK, &
      0.000000000000000_REALK,     -0.128924298826679_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.056405968502465_REALK,      0.000000000000000_REALK, &
     -0.198749895767565_REALK,      0.000000000000000_REALK,      0.001769911557137_REALK, &
      0.000000000000000_REALK,     -0.090484503544881_REALK,      0.000000000000000_REALK, &
      0.279626208954554_REALK,      0.135222686206369_REALK,      0.000000000000000_REALK, &
      0.093736188923673_REALK,      0.000000000000000_REALK,      0.156804764523947_REALK, &
      0.079201466014759_REALK,      0.000000000000000_REALK,      0.088679925739554_REALK, &
      0.000000000000000_REALK,      0.086413576287438_REALK,      0.000000000000000_REALK, &
      0.077264004252861_REALK,      0.000000000000000_REALK,      0.180949426097079_REALK, &
      0.667714334351977_REALK,      0.318726288275769_REALK,      0.000000000000000_REALK, &
      0.234641577412065_REALK,      0.000000000000000_REALK,      0.294242145045914_REALK, &
      0.242600428544565_REALK,      0.000000000000000_REALK,      0.176206173910836_REALK, &
      0.000000000000000_REALK,      0.353081913206787_REALK,      0.000000000000000_REALK, &
      0.164681342744095_REALK,      0.000000000000000_REALK,      0.289116144297628_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.185707280937596_REALK, &
      0.000000000000000_REALK,     -0.115420939509251_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.096009586312837_REALK,      0.000000000000000_REALK, &
     -0.170503276356972_REALK,      0.000000000000000_REALK,     -0.099628306323343_REALK, &
      0.000000000000000_REALK,     -0.133193355617680_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.466221748245730_REALK, &
      0.000000000000000_REALK,     -0.237569395632088_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.126531174772442_REALK,      0.000000000000000_REALK, &
     -0.360847582593661_REALK,      0.000000000000000_REALK,     -0.018549662028111_REALK, &
      0.000000000000000_REALK,     -0.233430692457565_REALK,      0.000000000000000_REALK, &
      0.300007617152949_REALK,      0.224776052450882_REALK,      0.000000000000000_REALK, &
      0.214075129892606_REALK,      0.000000000000000_REALK,      0.235527540549626_REALK, &
      0.246540313649196_REALK,      0.000000000000000_REALK,      0.206373456096966_REALK, &
      0.000000000000000_REALK,      0.354608477798257_REALK,      0.000000000000000_REALK, &
      0.247038232628505_REALK,      0.000000000000000_REALK,      0.349449257395331_REALK, &
      1.799280308700708_REALK,      1.361395632886474_REALK,      0.000000000000000_REALK, &
      1.315352388308503_REALK,      0.000000000000000_REALK,      1.110046165653601_REALK, &
      1.549637144641131_REALK,      0.000000000000000_REALK,      1.053696711766708_REALK, &
      0.000000000000000_REALK,      2.225494713246019_REALK,      0.000000000000000_REALK, &
      1.292437597071928_REALK,      0.000000000000000_REALK,      1.402338882780909_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.644340002432563_REALK, &
      0.000000000000000_REALK,     -5.474112043170483_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.207060381516138_REALK,      0.000000000000000_REALK, &
      2.985469021102288_REALK,      0.000000000000000_REALK,    -30.482256521615192_REALK, &
      0.000000000000000_REALK,    -21.681139891285039_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.858459302800795_REALK, &
      0.000000000000000_REALK,     -5.774903467263577_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.489869460755213_REALK,      0.000000000000000_REALK, &
      3.462738468370098_REALK,      0.000000000000000_REALK,    -44.016109660411573_REALK, &
      0.000000000000000_REALK,    -26.286092885541773_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.105724746148165_REALK, &
      0.000000000000000_REALK,     -1.752826473390437_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.072791908296963_REALK,      0.000000000000000_REALK, &
     -0.171022417800402_REALK,      0.000000000000000_REALK,     -6.292642649966994_REALK, &
      0.000000000000000_REALK,     -7.032021590955866_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.132855474747922_REALK, &
      0.000000000000000_REALK,     -0.895604867400195_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.002785861356460_REALK,      0.000000000000000_REALK, &
      0.011091383048895_REALK,      0.000000000000000_REALK,      0.203858337071895_REALK, &
      0.000000000000000_REALK,     -4.183891073154340_REALK,      0.000000000000000_REALK, &
      2.443555404783461_REALK,     -0.049739213176926_REALK,      0.000000000000000_REALK, &
      2.447169377287383_REALK,      0.000000000000000_REALK,      3.310262114470490_REALK, &
      0.113120236305909_REALK,      0.000000000000000_REALK,      0.080459124348110_REALK, &
      0.000000000000000_REALK,     17.396815921660327_REALK,      0.000000000000000_REALK, &
      9.817599265559325_REALK,      0.000000000000000_REALK,     22.133617725484374_REALK, &
      2.492125940894548_REALK,     -0.150789961912235_REALK,      0.000000000000000_REALK, &
      3.459046652053860_REALK,      0.000000000000000_REALK,      3.432155282782895_REALK, &
     -0.021079693742575_REALK,      0.000000000000000_REALK,     -0.012588636115074_REALK, &
      0.000000000000000_REALK,     34.268431164503369_REALK,      0.000000000000000_REALK, &
     16.159218128373247_REALK,      0.000000000000000_REALK,     26.722654844799806_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.869627395281052_REALK, &
      0.000000000000000_REALK,     -0.689873099324283_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.411289055152897_REALK,      0.000000000000000_REALK, &
     -1.322511111644265_REALK,      0.000000000000000_REALK,     -1.965205475384862_REALK, &
      0.000000000000000_REALK,     -2.581865899232102_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.319327079105178_REALK, &
      0.000000000000000_REALK,     -0.422157590275787_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.278250633655621_REALK,      0.000000000000000_REALK, &
     -0.812420192257818_REALK,      0.000000000000000_REALK,     -2.276393910185383_REALK, &
      0.000000000000000_REALK,     -1.884183334058398_REALK,      0.000000000000000_REALK, &
      1.503258783243034_REALK,      0.212458468088049_REALK,      0.000000000000000_REALK, &
      0.831812238005129_REALK,      0.000000000000000_REALK,      1.954318047539585_REALK, &
      0.289129920468890_REALK,      0.000000000000000_REALK,      0.323102384232680_REALK, &
      0.000000000000000_REALK,      3.130944504034718_REALK,      0.000000000000000_REALK, &
      3.113076381689531_REALK,      0.000000000000000_REALK,     12.190133538420730_REALK, &
      0.670858107101589_REALK,      0.097238834477472_REALK,      0.000000000000000_REALK, &
      0.346583711059645_REALK,      0.000000000000000_REALK,      1.379857862975326_REALK, &
     -0.012054045131847_REALK,      0.000000000000000_REALK,      0.247391460888583_REALK, &
      0.000000000000000_REALK,     -2.443571045273046_REALK,      0.000000000000000_REALK, &
      1.546880281858926_REALK,      0.000000000000000_REALK,     10.264354862872727_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.401233794951732_REALK, &
      0.000000000000000_REALK,     -0.919427527835910_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.451092148838530_REALK,      0.000000000000000_REALK, &
     -1.016979906318320_REALK,      0.000000000000000_REALK,     -4.837789586425196_REALK, &
      0.000000000000000_REALK,     -5.734964356149796_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.372640649455491_REALK, &
      0.000000000000000_REALK,     -1.566128268309099_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.955486772886178_REALK,      0.000000000000000_REALK, &
     -1.580097690232702_REALK,      0.000000000000000_REALK,    -11.704732729216186_REALK, &
      0.000000000000000_REALK,    -11.649965360952828_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.527304008751492_REALK, &
      0.000000000000000_REALK,     -0.198970744677420_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.504429134703767_REALK,      0.000000000000000_REALK, &
     -1.978775180621393_REALK,      0.000000000000000_REALK,     -0.309722729264726_REALK, &
      0.000000000000000_REALK,     -0.639416384776829_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.909596219992508_REALK, &
      0.000000000000000_REALK,     -0.066423436613600_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.215968268885362_REALK,      0.000000000000000_REALK, &
     -1.280432970653287_REALK,      0.000000000000000_REALK,      0.525671328780762_REALK, &
      0.000000000000000_REALK,     -0.235169776005141_REALK,      0.000000000000000_REALK, &
      1.348607083457475_REALK,      0.190235677130195_REALK,      0.000000000000000_REALK, &
      0.482481899730566_REALK,      0.000000000000000_REALK,      1.551433634244651_REALK, &
      0.187601892590380_REALK,      0.000000000000000_REALK,      0.246469356602850_REALK, &
      0.000000000000000_REALK,      1.357157903056300_REALK,      0.000000000000000_REALK, &
      1.550513531756342_REALK,      0.000000000000000_REALK,      8.309530522843007_REALK, &
      1.091328763506225_REALK,      0.182649625083257_REALK,      0.000000000000000_REALK, &
      0.401868082900374_REALK,      0.000000000000000_REALK,      1.173351308792633_REALK, &
      0.310635612711562_REALK,      0.000000000000000_REALK,      0.257114747064351_REALK, &
      0.000000000000000_REALK,      2.528762488309537_REALK,      0.000000000000000_REALK, &
      1.422799419263210_REALK,      0.000000000000000_REALK,      6.923679816741236_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.538912181770249_REALK, &
      0.000000000000000_REALK,     -0.379030392856202_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.297179622333891_REALK,      0.000000000000000_REALK, &
     -1.163691100692325_REALK,      0.000000000000000_REALK,     -1.089987317936268_REALK, &
      0.000000000000000_REALK,     -2.030099482829131_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.597005779704164_REALK, &
      0.000000000000000_REALK,     -0.357299211890615_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.211086535593284_REALK,      0.000000000000000_REALK, &
     -1.400668903413871_REALK,      0.000000000000000_REALK,      0.061636835065003_REALK, &
      0.000000000000000_REALK,     -2.108341571161788_REALK,      0.000000000000000_REALK, &
      0.622228256527672_REALK,      0.253536365603071_REALK,      0.000000000000000_REALK, &
      0.529174784007438_REALK,      0.000000000000000_REALK,      1.193015936215147_REALK, &
      0.461823709395914_REALK,      0.000000000000000_REALK,      0.547469555030306_REALK, &
      0.000000000000000_REALK,      3.013409434139880_REALK,      0.000000000000000_REALK, &
      2.834277872136973_REALK,      0.000000000000000_REALK,      8.945766653732640_REALK, &
      1.273532643526513_REALK,      0.677597057658195_REALK,      0.000000000000000_REALK, &
      1.379977585717445_REALK,      0.000000000000000_REALK,      2.282082240844149_REALK, &
      1.597222170862796_REALK,      0.000000000000000_REALK,      1.589748642260841_REALK, &
      0.000000000000000_REALK,     10.361105020090472_REALK,      0.000000000000000_REALK, &
      8.142934589316377_REALK,      0.000000000000000_REALK,     18.852469235551112_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.325709093707433_REALK, &
      0.000000000000000_REALK,      0.170407509510990_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.646433542896232_REALK,      0.000000000000000_REALK, &
     -2.625006501700532_REALK,      0.000000000000000_REALK,      0.446434922529671_REALK, &
      0.000000000000000_REALK,      0.438869975337920_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.204830346834352_REALK, &
      0.000000000000000_REALK,      0.116691783698204_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.438819564816591_REALK,      0.000000000000000_REALK, &
     -1.834946989220331_REALK,      0.000000000000000_REALK,     -0.009094509704056_REALK, &
      0.000000000000000_REALK,      0.331413055340053_REALK,      0.000000000000000_REALK, &
      1.589753901531950_REALK,      0.087773662699723_REALK,      0.000000000000000_REALK, &
      0.392428627699965_REALK,      0.000000000000000_REALK,      1.539419464964155_REALK, &
      0.047987544812878_REALK,      0.000000000000000_REALK,      0.099069327237978_REALK, &
      0.000000000000000_REALK,      0.723403654944870_REALK,      0.000000000000000_REALK, &
      1.010666388205568_REALK,      0.000000000000000_REALK,      6.607738752850792_REALK, &
      0.692084157227295_REALK,      0.035322413543525_REALK,      0.000000000000000_REALK, &
      0.195471794194665_REALK,      0.000000000000000_REALK,      1.158913443217246_REALK, &
     -0.120248807994039_REALK,      0.000000000000000_REALK,      0.053795753529935_REALK, &
      0.000000000000000_REALK,     -0.509219036418539_REALK,      0.000000000000000_REALK, &
      0.555153949093789_REALK,      0.000000000000000_REALK,      5.485662499378424_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.684397159662685_REALK, &
      0.000000000000000_REALK,     -0.191744736232476_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.240232086824135_REALK,      0.000000000000000_REALK, &
     -1.287454651085958_REALK,      0.000000000000000_REALK,     -0.375876241399488_REALK, &
      0.000000000000000_REALK,     -0.823036964969121_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.623960491567285_REALK, &
      0.000000000000000_REALK,     -0.232713264693778_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.325469404195654_REALK,      0.000000000000000_REALK, &
     -1.583811403270873_REALK,      0.000000000000000_REALK,     -0.798499650045956_REALK, &
      0.000000000000000_REALK,     -1.101537338021264_REALK,      0.000000000000000_REALK, &
      0.560947747562515_REALK,      0.167204912005736_REALK,      0.000000000000000_REALK, &
      0.231195589924382_REALK,      0.000000000000000_REALK,      0.905311906655699_REALK, &
      0.168879485819812_REALK,      0.000000000000000_REALK,      0.314537748450478_REALK, &
      0.000000000000000_REALK,      0.598842038121476_REALK,      0.000000000000000_REALK, &
      0.992374134405991_REALK,      0.000000000000000_REALK,      5.440291348291835_REALK, &
      0.454243578441634_REALK,      0.190003275419086_REALK,      0.000000000000000_REALK, &
      0.191053361939282_REALK,      0.000000000000000_REALK,      1.267738381365247_REALK, &
     -0.014099600908961_REALK,      0.000000000000000_REALK,      0.482289116594033_REALK, &
      0.000000000000000_REALK,     -0.857141031603822_REALK,      0.000000000000000_REALK, &
      0.904342139703721_REALK,      0.000000000000000_REALK,      8.401092345361764_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.526285301643273_REALK, &
      0.000000000000000_REALK,     -0.425912603787692_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.439134824635592_REALK,      0.000000000000000_REALK, &
     -1.386031238975131_REALK,      0.000000000000000_REALK,     -1.542171365118088_REALK, &
      0.000000000000000_REALK,     -2.559436848758740_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.213557394212391_REALK, &
      0.000000000000000_REALK,     -1.438873502228278_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.862719392000750_REALK,      0.000000000000000_REALK, &
     -4.312555829471150_REALK,      0.000000000000000_REALK,     -6.842858600718072_REALK, &
      0.000000000000000_REALK,     -9.535176455331412_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.723503111410353_REALK, &
      0.000000000000000_REALK,      0.669949291607843_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.956463412000856_REALK,      0.000000000000000_REALK, &
     -3.569373111163676_REALK,      0.000000000000000_REALK,      1.095537490333488_REALK, &
      0.000000000000000_REALK,      1.312864219607824_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.189467712714712_REALK, &
      0.000000000000000_REALK,      0.638763971677457_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.681403121414625_REALK,      0.000000000000000_REALK, &
     -2.987946320510269_REALK,      0.000000000000000_REALK,      1.107238718926739_REALK, &
      0.000000000000000_REALK,      1.167158191191225_REALK,      0.000000000000000_REALK, &
      2.347884581401607_REALK,     -0.104822268774508_REALK,      0.000000000000000_REALK, &
      0.456843746872740_REALK,      0.000000000000000_REALK,      1.855129299802869_REALK, &
     -0.102215338646677_REALK,      0.000000000000000_REALK,     -0.100483275136350_REALK, &
      0.000000000000000_REALK,      0.670727306256096_REALK,      0.000000000000000_REALK, &
      0.895252546325363_REALK,      0.000000000000000_REALK,      6.058998073849622_REALK, &
      2.742989015543888_REALK,     -0.132741071519980_REALK,      0.000000000000000_REALK, &
      0.445632527771832_REALK,      0.000000000000000_REALK,      1.863435750580855_REALK, &
      0.003412475783016_REALK,      0.000000000000000_REALK,     -0.124354040220439_REALK, &
      0.000000000000000_REALK,      1.116922656369187_REALK,      0.000000000000000_REALK, &
      0.814265797872491_REALK,      0.000000000000000_REALK,      5.674825121861133_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.946938555561580_REALK, &
      0.000000000000000_REALK,     -0.070013697700128_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.231401267947132_REALK,      0.000000000000000_REALK, &
     -1.512901926409044_REALK,      0.000000000000000_REALK,     -0.066458450613736_REALK, &
      0.000000000000000_REALK,     -0.228670238539837_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.318305431421176_REALK, &
      0.000000000000000_REALK,     -0.054630968058490_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.208306931189868_REALK,      0.000000000000000_REALK, &
     -2.058350701916397_REALK,      0.000000000000000_REALK,      0.223131554367697_REALK, &
      0.000000000000000_REALK,     -0.166370742792325_REALK,      0.000000000000000_REALK, &
      0.690922842876072_REALK,      0.117947374121806_REALK,      0.000000000000000_REALK, &
      0.169775420644303_REALK,      0.000000000000000_REALK,      0.909862449426236_REALK, &
      0.086060286426932_REALK,      0.000000000000000_REALK,      0.188441803827433_REALK, &
      0.000000000000000_REALK,      0.291210824886596_REALK,      0.000000000000000_REALK, &
      0.554499865200853_REALK,      0.000000000000000_REALK,      4.160355162725566_REALK, &
      1.420545871042655_REALK,      0.264719649776340_REALK,      0.000000000000000_REALK, &
      0.330522531201913_REALK,      0.000000000000000_REALK,      1.608401119144371_REALK, &
      0.299616010889902_REALK,      0.000000000000000_REALK,      0.413322940148086_REALK, &
      0.000000000000000_REALK,      1.073383069896434_REALK,      0.000000000000000_REALK, &
      1.006558751929644_REALK,      0.000000000000000_REALK,      6.857415450866440_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.556881843274087_REALK, &
      0.000000000000000_REALK,     -0.222288284873389_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.227213089956620_REALK,      0.000000000000000_REALK, &
     -1.245604217858373_REALK,      0.000000000000000_REALK,     -0.389804931390485_REALK, &
      0.000000000000000_REALK,     -1.016415408911092_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.442097685169061_REALK, &
      0.000000000000000_REALK,     -0.489776972989963_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.339330623829419_REALK,      0.000000000000000_REALK, &
     -3.152289140627818_REALK,      0.000000000000000_REALK,      0.043604948762244_REALK, &
      0.000000000000000_REALK,     -2.088163295886450_REALK,      0.000000000000000_REALK, &
      0.531303398387097_REALK,      0.261990363903564_REALK,      0.000000000000000_REALK, &
      0.310342804567354_REALK,      0.000000000000000_REALK,      0.979527921244812_REALK, &
      0.353094169791961_REALK,      0.000000000000000_REALK,      0.586006360699235_REALK, &
      0.000000000000000_REALK,      1.077665619037063_REALK,      0.000000000000000_REALK, &
      1.419045582121471_REALK,      0.000000000000000_REALK,      5.758587296164655_REALK, &
      2.762857534924223_REALK,      1.636769997118730_REALK,      0.000000000000000_REALK, &
      1.891639338218311_REALK,      0.000000000000000_REALK,      4.379511100986618_REALK, &
      2.567602874857624_REALK,      0.000000000000000_REALK,      3.577824401692960_REALK, &
      0.000000000000000_REALK,      7.329958669110840_REALK,      0.000000000000000_REALK, &
      8.065001118791599_REALK,      0.000000000000000_REALK,     24.006906220020142_REALK/
    ! results of test 2, ket-major order, CM010101
  data REF_CONTR_INTS(7561:8820)                                                           &
     /0.000000000000000_REALK,      0.000000000000000_REALK,     -0.351684171107253_REALK, &
      0.000000000000000_REALK,     -0.226914030074071_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.173037491748907_REALK,      0.000000000000000_REALK, &
     -0.256534258489637_REALK,      0.000000000000000_REALK,     -0.088688278478817_REALK, &
      0.000000000000000_REALK,     -0.247368090581101_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.089348812143350_REALK, &
      0.000000000000000_REALK,      0.091800885907449_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.386069227949993_REALK,      0.000000000000000_REALK, &
     -0.061789247489869_REALK,      0.000000000000000_REALK,      1.331560829163928_REALK, &
      0.000000000000000_REALK,      0.095155540470499_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.339163968706014_REALK, &
      0.000000000000000_REALK,     -0.197682580973954_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.178010345113580_REALK,      0.000000000000000_REALK, &
     -0.215144882886916_REALK,      0.000000000000000_REALK,     -0.231919265271205_REALK, &
      0.000000000000000_REALK,     -0.177688671291870_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.183974736257554_REALK, &
      0.000000000000000_REALK,     -0.157170543558570_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.219667403840307_REALK,      0.000000000000000_REALK, &
     -0.135739805771322_REALK,      0.000000000000000_REALK,     -0.483852400292059_REALK, &
      0.000000000000000_REALK,     -0.142357356423454_REALK,      0.000000000000000_REALK, &
      0.298275017314338_REALK,      0.164087924192330_REALK,      0.000000000000000_REALK, &
      0.105063310024795_REALK,      0.000000000000000_REALK,      0.155760107588638_REALK, &
      0.037318182280638_REALK,      0.000000000000000_REALK,      0.104087345622837_REALK, &
      0.000000000000000_REALK,     -0.134354693488454_REALK,      0.000000000000000_REALK, &
      0.094437050891658_REALK,      0.000000000000000_REALK,      0.233343831824939_REALK, &
      0.055917615118965_REALK,     -0.071497513384724_REALK,      0.000000000000000_REALK, &
     -0.283609603141107_REALK,      0.000000000000000_REALK,      0.045390885080484_REALK, &
     -0.738187866946589_REALK,      0.000000000000000_REALK,     -0.052752126609321_REALK, &
      0.000000000000000_REALK,     -2.086422173435828_REALK,      0.000000000000000_REALK, &
     -0.256879644527205_REALK,      0.000000000000000_REALK,      0.068521389350656_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.351890562868235_REALK, &
      0.000000000000000_REALK,     -0.156350530016504_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.116739789092141_REALK,      0.000000000000000_REALK, &
     -0.192400227851281_REALK,      0.000000000000000_REALK,     -0.109415753589872_REALK, &
      0.000000000000000_REALK,     -0.115700548125248_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.217154022953119_REALK, &
      0.000000000000000_REALK,     -0.065677796753976_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.004894662473346_REALK,      0.000000000000000_REALK, &
     -0.107044929679175_REALK,      0.000000000000000_REALK,      0.134530844623107_REALK, &
      0.000000000000000_REALK,     -0.044208620203189_REALK,      0.000000000000000_REALK, &
      0.325178677416417_REALK,      0.162498186687140_REALK,      0.000000000000000_REALK, &
      0.122531061843461_REALK,      0.000000000000000_REALK,      0.148092128766452_REALK, &
      0.115964101613311_REALK,      0.000000000000000_REALK,      0.088847759625008_REALK, &
      0.000000000000000_REALK,      0.159944178558548_REALK,      0.000000000000000_REALK, &
      0.090673891646933_REALK,      0.000000000000000_REALK,      0.182648783575221_REALK, &
      0.358586258464748_REALK,      0.202941349911583_REALK,      0.000000000000000_REALK, &
      0.213150467039273_REALK,      0.000000000000000_REALK,      0.131712773448222_REALK, &
      0.340017877408335_REALK,      0.000000000000000_REALK,      0.100038867504527_REALK, &
      0.000000000000000_REALK,      0.772439015076527_REALK,      0.000000000000000_REALK, &
      0.143474484668993_REALK,      0.000000000000000_REALK,      0.147762771821073_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.128037255061347_REALK, &
      0.000000000000000_REALK,     -0.071647144863945_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.047220345204420_REALK,      0.000000000000000_REALK, &
     -0.116676412340921_REALK,      0.000000000000000_REALK,     -0.019008922287163_REALK, &
      0.000000000000000_REALK,     -0.088365694821464_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.058609503303539_REALK, &
      0.000000000000000_REALK,      0.051187113916390_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.180517181332212_REALK,      0.000000000000000_REALK, &
     -0.048152075612350_REALK,      0.000000000000000_REALK,      0.482143103380326_REALK, &
      0.000000000000000_REALK,      0.057424573454754_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.423188101621591_REALK, &
      0.000000000000000_REALK,     -0.142927131566224_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.096683055321417_REALK,      0.000000000000000_REALK, &
     -0.197976151950754_REALK,      0.000000000000000_REALK,     -0.078651600504338_REALK, &
      0.000000000000000_REALK,     -0.086860331665845_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.234882672339263_REALK, &
      0.000000000000000_REALK,     -0.107032013887446_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.102926710597821_REALK,      0.000000000000000_REALK, &
     -0.128603883262382_REALK,      0.000000000000000_REALK,     -0.161780861666867_REALK, &
      0.000000000000000_REALK,     -0.065291952961415_REALK,      0.000000000000000_REALK, &
      0.385594517588236_REALK,      0.147833539945339_REALK,      0.000000000000000_REALK, &
      0.092597208615155_REALK,      0.000000000000000_REALK,      0.152610555274232_REALK, &
      0.065402875959424_REALK,      0.000000000000000_REALK,      0.069159589448493_REALK, &
      0.000000000000000_REALK,      0.056707369415341_REALK,      0.000000000000000_REALK, &
      0.056273600145100_REALK,      0.000000000000000_REALK,      0.154575310527922_REALK, &
      0.171829232930367_REALK,      0.066300176240069_REALK,      0.000000000000000_REALK, &
     -0.004843805899442_REALK,      0.000000000000000_REALK,      0.105932710316362_REALK, &
     -0.110467034251739_REALK,      0.000000000000000_REALK,      0.036300932889326_REALK, &
      0.000000000000000_REALK,     -0.351478381905431_REALK,      0.000000000000000_REALK, &
     -0.002954831320591_REALK,      0.000000000000000_REALK,      0.107702254802700_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.140025004272608_REALK, &
      0.000000000000000_REALK,     -0.070473440092414_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.054199994914549_REALK,      0.000000000000000_REALK, &
     -0.109177658101106_REALK,      0.000000000000000_REALK,     -0.055899685412508_REALK, &
      0.000000000000000_REALK,     -0.071380736847991_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.132960917148257_REALK, &
      0.000000000000000_REALK,     -0.098999442603171_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.117810906908244_REALK,      0.000000000000000_REALK, &
     -0.121332139269768_REALK,      0.000000000000000_REALK,     -0.205263484295027_REALK, &
      0.000000000000000_REALK,     -0.100653170873560_REALK,      0.000000000000000_REALK, &
      0.140300618454462_REALK,      0.067744260611687_REALK,      0.000000000000000_REALK, &
      0.037454857420739_REALK,      0.000000000000000_REALK,      0.092546938606105_REALK, &
      0.011362515411901_REALK,      0.000000000000000_REALK,      0.052820278505229_REALK, &
      0.000000000000000_REALK,     -0.032383618889599_REALK,      0.000000000000000_REALK, &
      0.037937062781707_REALK,      0.000000000000000_REALK,      0.131233782924371_REALK, &
      0.046376419179907_REALK,     -0.051672176010864_REALK,      0.000000000000000_REALK, &
     -0.178641569801616_REALK,      0.000000000000000_REALK,      0.047651765406007_REALK, &
     -0.395901169464643_REALK,      0.000000000000000_REALK,     -0.047152921253780_REALK, &
      0.000000000000000_REALK,     -0.885117620107567_REALK,      0.000000000000000_REALK, &
     -0.181625673615531_REALK,      0.000000000000000_REALK,      0.067826864713656_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.594797584970999_REALK, &
      0.000000000000000_REALK,     -0.143916315920696_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.088032546298649_REALK,      0.000000000000000_REALK, &
     -0.234043297667355_REALK,      0.000000000000000_REALK,     -0.052855300370187_REALK, &
      0.000000000000000_REALK,     -0.071175610869397_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.538850575915445_REALK, &
      0.000000000000000_REALK,     -0.098621419383673_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.017199648276786_REALK,      0.000000000000000_REALK, &
     -0.178740446177868_REALK,      0.000000000000000_REALK,      0.071064753896759_REALK, &
      0.000000000000000_REALK,     -0.041529999789194_REALK,      0.000000000000000_REALK, &
      0.551664499520554_REALK,      0.160013525574356_REALK,      0.000000000000000_REALK, &
      0.090645271726214_REALK,      0.000000000000000_REALK,      0.185612691171449_REALK, &
      0.057012460925790_REALK,      0.000000000000000_REALK,      0.062962752612097_REALK, &
      0.000000000000000_REALK,      0.052186980636392_REALK,      0.000000000000000_REALK, &
      0.044829750860847_REALK,      0.000000000000000_REALK,      0.152995123065367_REALK, &
      0.753169714522225_REALK,      0.226180895027066_REALK,      0.000000000000000_REALK, &
      0.159379436880276_REALK,      0.000000000000000_REALK,      0.199139896494554_REALK, &
      0.185899357920508_REALK,      0.000000000000000_REALK,      0.075025760203309_REALK, &
      0.000000000000000_REALK,      0.340267392689466_REALK,      0.000000000000000_REALK, &
      0.067115521368530_REALK,      0.000000000000000_REALK,      0.139764767652628_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.170854565691576_REALK, &
      0.000000000000000_REALK,     -0.064840625455941_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.040791241485913_REALK,      0.000000000000000_REALK, &
     -0.112047546331608_REALK,      0.000000000000000_REALK,     -0.030325837605117_REALK, &
      0.000000000000000_REALK,     -0.053446234784149_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.223857838059496_REALK, &
      0.000000000000000_REALK,     -0.056211086592832_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.003395341325307_REALK,      0.000000000000000_REALK, &
     -0.123758643687045_REALK,      0.000000000000000_REALK,      0.072032347626561_REALK, &
      0.000000000000000_REALK,     -0.039451308328684_REALK,      0.000000000000000_REALK, &
      0.182535434258227_REALK,      0.078898271342662_REALK,      0.000000000000000_REALK, &
      0.050815246273050_REALK,      0.000000000000000_REALK,      0.102359596023381_REALK, &
      0.040520200605056_REALK,      0.000000000000000_REALK,      0.051742004540336_REALK, &
      0.000000000000000_REALK,      0.044330373147468_REALK,      0.000000000000000_REALK, &
      0.041885524142102_REALK,      0.000000000000000_REALK,      0.118120837795914_REALK, &
      0.426349611122108_REALK,      0.209206402102393_REALK,      0.000000000000000_REALK, &
      0.182427242572230_REALK,      0.000000000000000_REALK,      0.187879782808333_REALK, &
      0.235864425135440_REALK,      0.000000000000000_REALK,      0.115658673376259_REALK, &
      0.000000000000000_REALK,      0.413589878292892_REALK,      0.000000000000000_REALK, &
      0.128035123149291_REALK,      0.000000000000000_REALK,      0.184606723787121_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.103610572500819_REALK, &
      0.000000000000000_REALK,     -0.049521692108753_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.027499571472319_REALK,      0.000000000000000_REALK, &
     -0.095127891525953_REALK,      0.000000000000000_REALK,     -0.008780903288838_REALK, &
      0.000000000000000_REALK,     -0.057146999286917_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.100698086093049_REALK, &
      0.000000000000000_REALK,      0.073015119137078_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.208702659629373_REALK,      0.000000000000000_REALK, &
     -0.077938579817888_REALK,      0.000000000000000_REALK,      0.430259441316693_REALK, &
      0.000000000000000_REALK,      0.071743120677189_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.986992246091565_REALK, &
      0.000000000000000_REALK,     -0.162158318918452_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.098328995041904_REALK,      0.000000000000000_REALK, &
     -0.323779657909783_REALK,      0.000000000000000_REALK,     -0.044176011221348_REALK, &
      0.000000000000000_REALK,     -0.064657504513207_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.707324543674683_REALK, &
      0.000000000000000_REALK,     -0.156252354560682_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.125230759856360_REALK,      0.000000000000000_REALK, &
     -0.283556048164243_REALK,      0.000000000000000_REALK,     -0.140014347263611_REALK, &
      0.000000000000000_REALK,     -0.063971978503509_REALK,      0.000000000000000_REALK, &
      0.931920696899751_REALK,      0.195118690965601_REALK,      0.000000000000000_REALK, &
      0.100350484732249_REALK,      0.000000000000000_REALK,      0.266791764600059_REALK, &
      0.047532650804593_REALK,      0.000000000000000_REALK,      0.064008064159388_REALK, &
      0.000000000000000_REALK,      0.033552602132950_REALK,      0.000000000000000_REALK, &
      0.040012821807439_REALK,      0.000000000000000_REALK,      0.177296790761521_REALK, &
      0.549258519016639_REALK,      0.135179064950792_REALK,      0.000000000000000_REALK, &
      0.024775221320820_REALK,      0.000000000000000_REALK,      0.257466550581485_REALK, &
     -0.092730361438337_REALK,      0.000000000000000_REALK,      0.054191306939313_REALK, &
      0.000000000000000_REALK,     -0.266838005284462_REALK,      0.000000000000000_REALK, &
      0.010143334673012_REALK,      0.000000000000000_REALK,      0.175684228732425_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.251649752818385_REALK, &
      0.000000000000000_REALK,     -0.071772804608715_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.040315292475898_REALK,      0.000000000000000_REALK, &
     -0.137588164451597_REALK,      0.000000000000000_REALK,     -0.025913477864064_REALK, &
      0.000000000000000_REALK,     -0.047696704357253_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.272958401640972_REALK, &
      0.000000000000000_REALK,     -0.108070803768037_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.087577121053114_REALK,      0.000000000000000_REALK, &
     -0.182375041213849_REALK,      0.000000000000000_REALK,     -0.109632439718598_REALK, &
      0.000000000000000_REALK,     -0.073742922199410_REALK,      0.000000000000000_REALK, &
      0.267692589800210_REALK,      0.087909545762175_REALK,      0.000000000000000_REALK, &
      0.046498948718974_REALK,      0.000000000000000_REALK,      0.127725779387214_REALK, &
      0.027271956438524_REALK,      0.000000000000000_REALK,      0.048064076772293_REALK, &
      0.000000000000000_REALK,      0.018683474368620_REALK,      0.000000000000000_REALK, &
      0.030900932770609_REALK,      0.000000000000000_REALK,      0.118832450257750_REALK, &
      0.228181670575256_REALK,      0.077047787113324_REALK,      0.000000000000000_REALK, &
     -0.004890817035355_REALK,      0.000000000000000_REALK,      0.178268051669952_REALK, &
     -0.093992946775935_REALK,      0.000000000000000_REALK,      0.051478882004558_REALK, &
      0.000000000000000_REALK,     -0.238182885908867_REALK,      0.000000000000000_REALK, &
     -0.003337285627151_REALK,      0.000000000000000_REALK,      0.170299555932016_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.138776970881158_REALK, &
      0.000000000000000_REALK,     -0.058981995352333_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.037667556117737_REALK,      0.000000000000000_REALK, &
     -0.106225799425521_REALK,      0.000000000000000_REALK,     -0.030695608889003_REALK, &
      0.000000000000000_REALK,     -0.054875179172409_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.257524313905717_REALK, &
      0.000000000000000_REALK,     -0.166600455105629_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.167069364141951_REALK,      0.000000000000000_REALK, &
     -0.240888025104493_REALK,      0.000000000000000_REALK,     -0.231831465689087_REALK, &
      0.000000000000000_REALK,     -0.159153495294203_REALK,      0.000000000000000_REALK, &
      0.162335623699369_REALK,      0.067140460599242_REALK,      0.000000000000000_REALK, &
      0.031347444135200_REALK,      0.000000000000000_REALK,      0.108438644882553_REALK, &
      0.007896646255986_REALK,      0.000000000000000_REALK,      0.051392165830307_REALK, &
      0.000000000000000_REALK,     -0.017782477531139_REALK,      0.000000000000000_REALK, &
      0.029164774830700_REALK,      0.000000000000000_REALK,      0.129713459371006_REALK, &
      0.102643077890961_REALK,     -0.100080850528246_REALK,      0.000000000000000_REALK, &
     -0.300625599974640_REALK,      0.000000000000000_REALK,      0.112266572742930_REALK, &
     -0.561433218547651_REALK,      0.000000000000000_REALK,     -0.093615542815710_REALK, &
      0.000000000000000_REALK,     -0.999681535571331_REALK,      0.000000000000000_REALK, &
     -0.287187780973019_REALK,      0.000000000000000_REALK,      0.137890685840209_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.074631938467566_REALK, &
      0.000000000000000_REALK,     -0.912826875983037_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.035609460463269_REALK,      0.000000000000000_REALK, &
     -0.120726083787108_REALK,      0.000000000000000_REALK,     -1.554748525677607_REALK, &
      0.000000000000000_REALK,     -3.662095705515789_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.076126358560218_REALK, &
      0.000000000000000_REALK,     -0.024674120504196_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.001987252091226_REALK,      0.000000000000000_REALK, &
      0.006355376807098_REALK,      0.000000000000000_REALK,      7.016776367997946_REALK, &
      0.000000000000000_REALK,     -0.115267163314010_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.653210112525025_REALK, &
      0.000000000000000_REALK,     -0.385535877055083_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.271205188773874_REALK,      0.000000000000000_REALK, &
     -0.993388245058163_REALK,      0.000000000000000_REALK,     -0.945974961062015_REALK, &
      0.000000000000000_REALK,     -1.442876863692811_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.236013854010777_REALK, &
      0.000000000000000_REALK,     -0.268409251803503_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.225011288870291_REALK,      0.000000000000000_REALK, &
     -0.600457753812319_REALK,      0.000000000000000_REALK,     -2.309829354210094_REALK, &
      0.000000000000000_REALK,     -1.197970261827719_REALK,      0.000000000000000_REALK, &
      1.061162321019866_REALK,      0.110642897426023_REALK,      0.000000000000000_REALK, &
      0.406918649271663_REALK,      0.000000000000000_REALK,      1.379568640114066_REALK, &
      0.071436492199449_REALK,      0.000000000000000_REALK,      0.168263398858474_REALK, &
      0.000000000000000_REALK,      0.313151308753437_REALK,      0.000000000000000_REALK, &
      1.522902379213142_REALK,      0.000000000000000_REALK,      8.605112135959704_REALK, &
      0.384402561513886_REALK,      0.002678952300192_REALK,      0.000000000000000_REALK, &
     -0.247230251782250_REALK,      0.000000000000000_REALK,      0.790660337018882_REALK, &
     -0.414898601817271_REALK,      0.000000000000000_REALK,      0.006815691763035_REALK, &
      0.000000000000000_REALK,     -8.064043715033666_REALK,      0.000000000000000_REALK, &
     -1.103443668462435_REALK,      0.000000000000000_REALK,      5.881488588731164_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.183795896847283_REALK, &
      0.000000000000000_REALK,     -0.062680146470629_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.366022858843590_REALK,      0.000000000000000_REALK, &
     -1.533726046799101_REALK,      0.000000000000000_REALK,      0.023653566773730_REALK, &
      0.000000000000000_REALK,     -0.201430178685361_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.691146939861557_REALK, &
      0.000000000000000_REALK,      0.027234914929189_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.110647438993780_REALK,      0.000000000000000_REALK, &
     -0.972923270692739_REALK,      0.000000000000000_REALK,      0.926289764463966_REALK, &
      0.000000000000000_REALK,      0.096424231716206_REALK,      0.000000000000000_REALK, &
      1.012989919036071_REALK,      0.106313289649060_REALK,      0.000000000000000_REALK, &
      0.318149955747695_REALK,      0.000000000000000_REALK,      1.165340632435498_REALK, &
      0.090304395780085_REALK,      0.000000000000000_REALK,      0.137739505509281_REALK, &
      0.000000000000000_REALK,      0.826026326775381_REALK,      0.000000000000000_REALK, &
      1.022413093195733_REALK,      0.000000000000000_REALK,      6.241603469842611_REALK, &
      0.806598388679349_REALK,      0.116129261536575_REALK,      0.000000000000000_REALK, &
      0.324976278045644_REALK,      0.000000000000000_REALK,      0.867221048940625_REALK, &
      0.315198197242485_REALK,      0.000000000000000_REALK,      0.163474442902010_REALK, &
      0.000000000000000_REALK,      2.958802124796852_REALK,      0.000000000000000_REALK, &
      1.150566763950471_REALK,      0.000000000000000_REALK,      5.117274620319637_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.380422391678614_REALK, &
      0.000000000000000_REALK,     -0.197389265090408_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.145378878773390_REALK,      0.000000000000000_REALK, &
     -0.821458795468875_REALK,      0.000000000000000_REALK,     -0.269307550076372_REALK, &
      0.000000000000000_REALK,     -1.057223516975553_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.342085082564446_REALK, &
      0.000000000000000_REALK,     -0.009843675633245_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.150575389659871_REALK,      0.000000000000000_REALK, &
     -0.802585090059295_REALK,      0.000000000000000_REALK,      2.121531519850343_REALK, &
      0.000000000000000_REALK,     -0.058085296188555_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.843012296898804_REALK, &
      0.000000000000000_REALK,      0.214811755735324_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.507549254709918_REALK,      0.000000000000000_REALK, &
     -2.080191058788536_REALK,      0.000000000000000_REALK,      0.501828697189153_REALK, &
      0.000000000000000_REALK,      0.553229316081151_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.956799668596188_REALK, &
      0.000000000000000_REALK,      0.132447793811904_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.375105381043403_REALK,      0.000000000000000_REALK, &
     -1.457198248525664_REALK,      0.000000000000000_REALK,     -0.109119465925366_REALK, &
      0.000000000000000_REALK,      0.376161256852295_REALK,      0.000000000000000_REALK, &
      1.232200095623984_REALK,      0.027650627951370_REALK,      0.000000000000000_REALK, &
      0.284753275179400_REALK,      0.000000000000000_REALK,      1.193186448610916_REALK, &
     -0.003664815295388_REALK,      0.000000000000000_REALK,      0.031209009907917_REALK, &
      0.000000000000000_REALK,      0.480676557590064_REALK,      0.000000000000000_REALK, &
      0.733357721229508_REALK,      0.000000000000000_REALK,      5.121582853342923_REALK, &
      0.525872729988093_REALK,     -0.014482884008964_REALK,      0.000000000000000_REALK, &
      0.100146440654388_REALK,      0.000000000000000_REALK,      0.880587960062783_REALK, &
     -0.211891411867978_REALK,      0.000000000000000_REALK,     -0.022057316598392_REALK, &
      0.000000000000000_REALK,     -0.990393000716567_REALK,      0.000000000000000_REALK, &
      0.284423091556643_REALK,      0.000000000000000_REALK,      4.168221861772831_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.514076658694253_REALK, &
      0.000000000000000_REALK,     -0.107156627974755_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.158409730675815_REALK,      0.000000000000000_REALK, &
     -0.967056008205597_REALK,      0.000000000000000_REALK,     -0.180932486335752_REALK, &
      0.000000000000000_REALK,     -0.459954560409622_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.461167655364264_REALK, &
      0.000000000000000_REALK,     -0.147959896256756_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.263195411862202_REALK,      0.000000000000000_REALK, &
     -1.170591089110407_REALK,      0.000000000000000_REALK,     -0.810227932323204_REALK, &
      0.000000000000000_REALK,     -0.700361238415159_REALK,      0.000000000000000_REALK, &
      0.395977472681141_REALK,      0.087076011112491_REALK,      0.000000000000000_REALK, &
      0.113099799295108_REALK,      0.000000000000000_REALK,      0.639066869139567_REALK, &
      0.041725733718078_REALK,      0.000000000000000_REALK,      0.163803157161030_REALK, &
      0.000000000000000_REALK,      0.059895078859640_REALK,      0.000000000000000_REALK, &
      0.485464776658085_REALK,      0.000000000000000_REALK,      3.840344895057449_REALK, &
      0.260282156920787_REALK,      0.005234634027271_REALK,      0.000000000000000_REALK, &
     -0.136285028028814_REALK,      0.000000000000000_REALK,      0.726415729298882_REALK, &
     -0.485306354781590_REALK,      0.000000000000000_REALK,      0.013287176313866_REALK, &
      0.000000000000000_REALK,     -2.828656347918840_REALK,      0.000000000000000_REALK, &
     -0.645098796514913_REALK,      0.000000000000000_REALK,      4.813836760539776_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.999766574749390_REALK, &
      0.000000000000000_REALK,      0.627328160981277_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.785613710426090_REALK,      0.000000000000000_REALK, &
     -2.875594791062879_REALK,      0.000000000000000_REALK,      1.010575410301437_REALK, &
      0.000000000000000_REALK,      1.229341842467074_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.578122073510410_REALK, &
      0.000000000000000_REALK,      0.600137663248782_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.544439932307785_REALK,      0.000000000000000_REALK, &
     -2.415227573134792_REALK,      0.000000000000000_REALK,      1.109175507400391_REALK, &
      0.000000000000000_REALK,      1.096579676627209_REALK,      0.000000000000000_REALK, &
      1.860585301459293_REALK,     -0.132136521801347_REALK,      0.000000000000000_REALK, &
      0.358692251960332_REALK,      0.000000000000000_REALK,      1.470100504454604_REALK, &
     -0.114898247509749_REALK,      0.000000000000000_REALK,     -0.126666887016989_REALK, &
      0.000000000000000_REALK,      0.533054655383181_REALK,      0.000000000000000_REALK, &
      0.702910249101250_REALK,      0.000000000000000_REALK,      4.801463771717863_REALK, &
      2.178307500247759_REALK,     -0.150664095738903_REALK,      0.000000000000000_REALK, &
      0.380929139303654_REALK,      0.000000000000000_REALK,      1.479822211725200_REALK, &
      0.040944212172307_REALK,      0.000000000000000_REALK,     -0.141144626954977_REALK, &
      0.000000000000000_REALK,      1.225367156665843_REALK,      0.000000000000000_REALK, &
      0.696038889034564_REALK,      0.000000000000000_REALK,      4.506585354696882_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.733961261292471_REALK, &
      0.000000000000000_REALK,     -0.022055849637137_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.167908924776482_REALK,      0.000000000000000_REALK, &
     -1.172633007281516_REALK,      0.000000000000000_REALK,      0.005075440872559_REALK, &
      0.000000000000000_REALK,     -0.072036138118638_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.001700254138173_REALK, &
      0.000000000000000_REALK,      0.022399770975830_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.106722291102156_REALK,      0.000000000000000_REALK, &
     -1.564015722056457_REALK,      0.000000000000000_REALK,      0.393181943970798_REALK, &
      0.000000000000000_REALK,      0.068215275475934_REALK,      0.000000000000000_REALK, &
      0.518978346807174_REALK,      0.065914940549116_REALK,      0.000000000000000_REALK, &
      0.111950401860038_REALK,      0.000000000000000_REALK,      0.683432187390930_REALK, &
      0.041426139465523_REALK,      0.000000000000000_REALK,      0.105310782785431_REALK, &
      0.000000000000000_REALK,      0.177243788255290_REALK,      0.000000000000000_REALK, &
      0.365638809817051_REALK,      0.000000000000000_REALK,      3.125000521757650_REALK, &
      1.049921938231378_REALK,      0.168309666273523_REALK,      0.000000000000000_REALK, &
      0.267281694094754_REALK,      0.000000000000000_REALK,      1.188765287266720_REALK, &
      0.304016740621339_REALK,      0.000000000000000_REALK,      0.262792150784016_REALK, &
      0.000000000000000_REALK,      1.255921867954324_REALK,      0.000000000000000_REALK, &
      0.813967893333439_REALK,      0.000000000000000_REALK,      5.068298791468806_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.393107318533467_REALK, &
      0.000000000000000_REALK,     -0.115762012799886_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.111151578971382_REALK,      0.000000000000000_REALK, &
     -0.879281915814378_REALK,      0.000000000000000_REALK,     -0.096310672017010_REALK, &
      0.000000000000000_REALK,     -0.529322962941504_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.826323835493705_REALK, &
      0.000000000000000_REALK,     -0.013493468483278_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.242056371634666_REALK,      0.000000000000000_REALK, &
     -1.806265747499183_REALK,      0.000000000000000_REALK,      1.500876434083585_REALK, &
      0.000000000000000_REALK,     -0.057529380054294_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.452045550729339_REALK, &
      0.000000000000000_REALK,      1.468463150890822_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.393767546721971_REALK,      0.000000000000000_REALK, &
     -4.296560445426539_REALK,      0.000000000000000_REALK,      1.752377998513675_REALK, &
      0.000000000000000_REALK,      2.107437931077934_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.270170868088049_REALK, &
      0.000000000000000_REALK,      1.464228511728938_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.447153417394344_REALK,      0.000000000000000_REALK, &
     -4.334892461554625_REALK,      0.000000000000000_REALK,      1.316824814557037_REALK, &
      0.000000000000000_REALK,      2.086525582721921_REALK,      0.000000000000000_REALK, &
      3.384895735521310_REALK,     -0.508514556170498_REALK,      0.000000000000000_REALK, &
      0.589000243643397_REALK,      0.000000000000000_REALK,      2.155927283444557_REALK, &
     -0.329428297868654_REALK,      0.000000000000000_REALK,     -0.400741979801235_REALK, &
      0.000000000000000_REALK,      0.714836850330105_REALK,      0.000000000000000_REALK, &
      0.845292886045683_REALK,      0.000000000000000_REALK,      5.156732432612318_REALK, &
      2.176223298542342_REALK,     -0.588965416114245_REALK,      0.000000000000000_REALK, &
      0.543527048927964_REALK,      0.000000000000000_REALK,      2.411177868145932_REALK, &
     -0.604759844888001_REALK,      0.000000000000000_REALK,     -0.597892173709002_REALK, &
      0.000000000000000_REALK,     -0.010244985685630_REALK,      0.000000000000000_REALK, &
      0.774526027464414_REALK,      0.000000000000000_REALK,      5.726547309248070_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.191668973347856_REALK, &
      0.000000000000000_REALK,      0.094966300007790_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.229135326820180_REALK,      0.000000000000000_REALK, &
     -1.565185558120022_REALK,      0.000000000000000_REALK,      0.123626497285073_REALK, &
      0.000000000000000_REALK,      0.227148569905816_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.452273633328917_REALK, &
      0.000000000000000_REALK,      0.140907964328942_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.379503845658404_REALK,      0.000000000000000_REALK, &
     -2.457142122141367_REALK,      0.000000000000000_REALK,     -0.058247670899256_REALK, &
      0.000000000000000_REALK,      0.334656407824447_REALK,      0.000000000000000_REALK, &
      0.828191888095253_REALK,      0.017878554298676_REALK,      0.000000000000000_REALK, &
      0.125886801987722_REALK,      0.000000000000000_REALK,      0.879161244040026_REALK, &
     -0.001654496864397_REALK,      0.000000000000000_REALK,      0.023482406284134_REALK, &
      0.000000000000000_REALK,      0.118415625640292_REALK,      0.000000000000000_REALK, &
      0.301106887803169_REALK,      0.000000000000000_REALK,      2.943994943443101_REALK, &
      0.845547017966865_REALK,     -0.021982773689334_REALK,      0.000000000000000_REALK, &
      0.106543345730918_REALK,      0.000000000000000_REALK,      1.561393276725541_REALK, &
     -0.214376038654006_REALK,      0.000000000000000_REALK,     -0.037193265755125_REALK, &
      0.000000000000000_REALK,     -0.528669060808290_REALK,      0.000000000000000_REALK, &
      0.253040440472702_REALK,      0.000000000000000_REALK,      5.191632529432837_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.553992690046164_REALK, &
      0.000000000000000_REALK,     -0.078954931534041_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.119191274124534_REALK,      0.000000000000000_REALK, &
     -1.018690532371265_REALK,      0.000000000000000_REALK,     -0.074288462895992_REALK, &
      0.000000000000000_REALK,     -0.264391681016286_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.166635065506588_REALK, &
      0.000000000000000_REALK,     -0.262351517074837_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.443802710780963_REALK,      0.000000000000000_REALK, &
     -2.763407206996932_REALK,      0.000000000000000_REALK,     -0.720829071072524_REALK, &
      0.000000000000000_REALK,     -0.872318774836887_REALK,      0.000000000000000_REALK, &
      0.443576942721723_REALK,      0.093837121018539_REALK,      0.000000000000000_REALK, &
      0.083333967096863_REALK,      0.000000000000000_REALK,      0.659226354851944_REALK, &
      0.031395441078154_REALK,      0.000000000000000_REALK,      0.172549184283635_REALK, &
      0.000000000000000_REALK,      0.024592119600126_REALK,      0.000000000000000_REALK, &
      0.279055496831077_REALK,      0.000000000000000_REALK,      2.838229800737817_REALK, &
      0.697509711203754_REALK,      0.013242272176448_REALK,      0.000000000000000_REALK, &
     -0.241650506404119_REALK,      0.000000000000000_REALK,      1.803237112230929_REALK, &
     -0.818328383034511_REALK,      0.000000000000000_REALK,      0.031366955658514_REALK, &
      0.000000000000000_REALK,     -2.516548302410755_REALK,      0.000000000000000_REALK, &
     -0.803487915890434_REALK,      0.000000000000000_REALK,      7.708838483019431_REALK/
    ! results of test 2, ket-major order, CM000201
  data REF_CONTR_INTS(8821:10080)                                                          &
     /0.000000000000000_REALK,      0.000000000000000_REALK,     -0.238513538929780_REALK, &
      0.000000000000000_REALK,     -0.137133371975413_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.134944617729044_REALK,      0.000000000000000_REALK, &
     -0.151298404708995_REALK,      0.000000000000000_REALK,     -0.212406340989265_REALK, &
      0.000000000000000_REALK,     -0.123263499171409_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.161479280240513_REALK, &
      0.000000000000000_REALK,     -0.182458368337911_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.323371549211423_REALK,      0.000000000000000_REALK, &
     -0.119142261496462_REALK,      0.000000000000000_REALK,     -0.804366517952623_REALK, &
      0.000000000000000_REALK,     -0.165261825694727_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.249012760627626_REALK, &
      0.000000000000000_REALK,     -0.100574183273471_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.070198987277737_REALK,      0.000000000000000_REALK, &
     -0.136150601744246_REALK,      0.000000000000000_REALK,     -0.055543739757800_REALK, &
      0.000000000000000_REALK,     -0.074425639176033_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.133134905643251_REALK, &
      0.000000000000000_REALK,     -0.009912115629711_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.071919339552928_REALK,      0.000000000000000_REALK, &
     -0.065628149175491_REALK,      0.000000000000000_REALK,      0.262112543609140_REALK, &
      0.000000000000000_REALK,     -0.006671980135471_REALK,      0.000000000000000_REALK, &
      0.228678528061226_REALK,      0.112725785805244_REALK,      0.000000000000000_REALK, &
      0.092887339159135_REALK,      0.000000000000000_REALK,      0.104144251685969_REALK, &
      0.106207263467254_REALK,      0.000000000000000_REALK,      0.061634124816712_REALK, &
      0.000000000000000_REALK,      0.191153133526345_REALK,      0.000000000000000_REALK, &
      0.068737317701918_REALK,      0.000000000000000_REALK,      0.128445860325177_REALK, &
      0.314740230636685_REALK,      0.235593430771344_REALK,      0.000000000000000_REALK, &
      0.313777991347938_REALK,      0.000000000000000_REALK,      0.115607633349861_REALK, &
      0.565252948889986_REALK,      0.000000000000000_REALK,      0.116134538457243_REALK, &
      0.000000000000000_REALK,      1.322584649423696_REALK,      0.000000000000000_REALK, &
      0.211208242864523_REALK,      0.000000000000000_REALK,      0.129695122957570_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.308983715217322_REALK, &
      0.000000000000000_REALK,     -0.095822239569706_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.064265852576005_REALK,      0.000000000000000_REALK, &
     -0.144548976494788_REALK,      0.000000000000000_REALK,     -0.051579792750133_REALK, &
      0.000000000000000_REALK,     -0.058233530742428_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.174646071983616_REALK, &
      0.000000000000000_REALK,     -0.086594361894087_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.104434776095693_REALK,      0.000000000000000_REALK, &
     -0.095622903256027_REALK,      0.000000000000000_REALK,     -0.199720385012791_REALK, &
      0.000000000000000_REALK,     -0.052824522291602_REALK,      0.000000000000000_REALK, &
      0.272863115523442_REALK,      0.095095536541252_REALK,      0.000000000000000_REALK, &
      0.055681360400597_REALK,      0.000000000000000_REALK,      0.107993733506235_REALK, &
      0.033201072080705_REALK,      0.000000000000000_REALK,      0.044487660026330_REALK, &
      0.000000000000000_REALK,      0.017133743942984_REALK,      0.000000000000000_REALK, &
      0.033838931622023_REALK,      0.000000000000000_REALK,      0.109384078065894_REALK, &
      0.105346741459518_REALK,      0.010006045355382_REALK,      0.000000000000000_REALK, &
     -0.071172082468905_REALK,      0.000000000000000_REALK,      0.064946258884402_REALK, &
     -0.215227930916506_REALK,      0.000000000000000_REALK,      0.005478549251785_REALK, &
      0.000000000000000_REALK,     -0.569316663735151_REALK,      0.000000000000000_REALK, &
     -0.043416582496639_REALK,      0.000000000000000_REALK,      0.066031148471140_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.098471130159072_REALK, &
      0.000000000000000_REALK,     -0.048887769610077_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.041087486179488_REALK,      0.000000000000000_REALK, &
     -0.076778054299547_REALK,      0.000000000000000_REALK,     -0.051196469715602_REALK, &
      0.000000000000000_REALK,     -0.049517165800989_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.116703160651154_REALK, &
      0.000000000000000_REALK,     -0.114927876144973_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.173428987710060_REALK,      0.000000000000000_REALK, &
     -0.106496288120208_REALK,      0.000000000000000_REALK,     -0.341234380620109_REALK, &
      0.000000000000000_REALK,     -0.116847679659407_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.443835286073869_REALK, &
      0.000000000000000_REALK,     -0.097003974529014_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.059023530098117_REALK,      0.000000000000000_REALK, &
     -0.174642057396596_REALK,      0.000000000000000_REALK,     -0.031846833482764_REALK, &
      0.000000000000000_REALK,     -0.047974526721950_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.385844203899152_REALK, &
      0.000000000000000_REALK,     -0.047021221884072_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.023420173624237_REALK,      0.000000000000000_REALK, &
     -0.127987179085618_REALK,      0.000000000000000_REALK,      0.124905309041686_REALK, &
      0.000000000000000_REALK,     -0.019800884504978_REALK,      0.000000000000000_REALK, &
      0.402788608569587_REALK,      0.107277423215304_REALK,      0.000000000000000_REALK, &
      0.060252498745542_REALK,      0.000000000000000_REALK,      0.135522002366982_REALK, &
      0.037388824891937_REALK,      0.000000000000000_REALK,      0.042211943237447_REALK, &
      0.000000000000000_REALK,      0.037039992081857_REALK,      0.000000000000000_REALK, &
      0.029798625521964_REALK,      0.000000000000000_REALK,      0.111706830493877_REALK, &
      0.560016330146038_REALK,      0.182991887811236_REALK,      0.000000000000000_REALK, &
      0.161714638582860_REALK,      0.000000000000000_REALK,      0.148069673899841_REALK, &
      0.229494953574712_REALK,      0.000000000000000_REALK,      0.060699669140640_REALK, &
      0.000000000000000_REALK,      0.457239147001148_REALK,      0.000000000000000_REALK, &
      0.068098887120332_REALK,      0.000000000000000_REALK,      0.103921534224447_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.120903972877000_REALK, &
      0.000000000000000_REALK,     -0.041709439344299_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.024528944795785_REALK,      0.000000000000000_REALK, &
     -0.079289619494664_REALK,      0.000000000000000_REALK,     -0.015394587859713_REALK, &
      0.000000000000000_REALK,     -0.034379873300657_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.137244945970847_REALK, &
      0.000000000000000_REALK,     -0.008483396482787_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.049889181736760_REALK,      0.000000000000000_REALK, &
     -0.075875155918104_REALK,      0.000000000000000_REALK,      0.140343888506984_REALK, &
      0.000000000000000_REALK,     -0.005954004994445_REALK,      0.000000000000000_REALK, &
      0.128366148595082_REALK,      0.054732116198320_REALK,      0.000000000000000_REALK, &
      0.038521603779537_REALK,      0.000000000000000_REALK,      0.071983322945844_REALK, &
      0.037110964182326_REALK,      0.000000000000000_REALK,      0.035893681276442_REALK, &
      0.000000000000000_REALK,      0.052980294837232_REALK,      0.000000000000000_REALK, &
      0.031752233501543_REALK,      0.000000000000000_REALK,      0.083067252549089_REALK, &
      0.374217839554008_REALK,      0.242866493359316_REALK,      0.000000000000000_REALK, &
      0.268550449532492_REALK,      0.000000000000000_REALK,      0.164906838388729_REALK, &
      0.392106035312779_REALK,      0.000000000000000_REALK,      0.134267480092385_REALK, &
      0.000000000000000_REALK,      0.708156389709290_REALK,      0.000000000000000_REALK, &
      0.188480017528502_REALK,      0.000000000000000_REALK,      0.162033991683352_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.750569938422225_REALK, &
      0.000000000000000_REALK,     -0.109656531482900_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.069156651033882_REALK,      0.000000000000000_REALK, &
     -0.246222074045726_REALK,      0.000000000000000_REALK,     -0.028630280643041_REALK, &
      0.000000000000000_REALK,     -0.043723428600810_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.538823736240440_REALK, &
      0.000000000000000_REALK,     -0.120046820968177_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.118730676866441_REALK,      0.000000000000000_REALK, &
     -0.216006542783990_REALK,      0.000000000000000_REALK,     -0.165379091769741_REALK, &
      0.000000000000000_REALK,     -0.049148908328344_REALK,      0.000000000000000_REALK, &
      0.695395037837666_REALK,      0.131515932766036_REALK,      0.000000000000000_REALK, &
      0.067282387082848_REALK,      0.000000000000000_REALK,      0.199078816315626_REALK, &
      0.028639784554551_REALK,      0.000000000000000_REALK,      0.043143382219360_REALK, &
      0.000000000000000_REALK,      0.018203436865008_REALK,      0.000000000000000_REALK, &
      0.026827555166358_REALK,      0.000000000000000_REALK,      0.132298068848843_REALK, &
      0.393296816366504_REALK,      0.064451362055582_REALK,      0.000000000000000_REALK, &
     -0.033735572703289_REALK,      0.000000000000000_REALK,      0.184359042524921_REALK, &
     -0.162985359378427_REALK,      0.000000000000000_REALK,      0.025837606918514_REALK, &
      0.000000000000000_REALK,     -0.388287739591202_REALK,      0.000000000000000_REALK, &
     -0.013811832390278_REALK,      0.000000000000000_REALK,      0.125798773171463_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.183737858558399_REALK, &
      0.000000000000000_REALK,     -0.048118441911215_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.026797835817262_REALK,      0.000000000000000_REALK, &
     -0.100457697320139_REALK,      0.000000000000000_REALK,     -0.016994082880613_REALK, &
      0.000000000000000_REALK,     -0.031977168935826_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.202957128283462_REALK, &
      0.000000000000000_REALK,     -0.087434795924846_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.088860286850370_REALK,      0.000000000000000_REALK, &
     -0.135604232779859_REALK,      0.000000000000000_REALK,     -0.135342542034281_REALK, &
      0.000000000000000_REALK,     -0.059661787722488_REALK,      0.000000000000000_REALK, &
      0.189430686183731_REALK,      0.056548773873932_REALK,      0.000000000000000_REALK, &
      0.027961153047613_REALK,      0.000000000000000_REALK,      0.090384205445244_REALK, &
      0.013844317672804_REALK,      0.000000000000000_REALK,      0.030917741472680_REALK, &
      0.000000000000000_REALK,      0.005645084035773_REALK,      0.000000000000000_REALK, &
      0.018581618172379_REALK,      0.000000000000000_REALK,      0.084090906700183_REALK, &
      0.139895843366966_REALK,      0.011628078477441_REALK,      0.000000000000000_REALK, &
     -0.071862836911095_REALK,      0.000000000000000_REALK,      0.109294315230849_REALK, &
     -0.183130719425567_REALK,      0.000000000000000_REALK,      0.007769210542017_REALK, &
      0.000000000000000_REALK,     -0.385803204252066_REALK,      0.000000000000000_REALK, &
     -0.049036144884592_REALK,      0.000000000000000_REALK,      0.104408912171023_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.097593463636791_REALK, &
      0.000000000000000_REALK,     -0.040916098265478_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.028554711007679_REALK,      0.000000000000000_REALK, &
     -0.074702190339645_REALK,      0.000000000000000_REALK,     -0.028112981303758_REALK, &
      0.000000000000000_REALK,     -0.038067179822277_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.226035605213265_REALK, &
      0.000000000000000_REALK,     -0.193405497714009_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.245942175142314_REALK,      0.000000000000000_REALK, &
     -0.211433513664487_REALK,      0.000000000000000_REALK,     -0.385401557780068_REALK, &
      0.000000000000000_REALK,     -0.184760365455085_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.729676685234179_REALK, &
      0.000000000000000_REALK,     -0.140426730935823_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.102227776636937_REALK,      0.000000000000000_REALK, &
     -0.434423634557052_REALK,      0.000000000000000_REALK,     -0.022505087606315_REALK, &
      0.000000000000000_REALK,     -0.042362576207300_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.635874918585516_REALK, &
      0.000000000000000_REALK,     -0.161109416378230_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.008747997918413_REALK,      0.000000000000000_REALK, &
     -0.719137043122212_REALK,      0.000000000000000_REALK,      0.248844216918387_REALK, &
      0.000000000000000_REALK,     -0.036705710884616_REALK,      0.000000000000000_REALK, &
      1.755476627696090_REALK,      0.210710804560622_REALK,      0.000000000000000_REALK, &
      0.107628025668563_REALK,      0.000000000000000_REALK,      0.383193739277180_REALK, &
      0.034653468787075_REALK,      0.000000000000000_REALK,      0.052921886696572_REALK, &
      0.000000000000000_REALK,      0.026494399219545_REALK,      0.000000000000000_REALK, &
      0.032468180445712_REALK,      0.000000000000000_REALK,      0.192663626957040_REALK, &
      5.094114617003936_REALK,      0.725609524359463_REALK,      0.000000000000000_REALK, &
      0.493667320544493_REALK,      0.000000000000000_REALK,      0.898128217665301_REALK, &
      0.482916925590073_REALK,      0.000000000000000_REALK,      0.143517777562101_REALK, &
      0.000000000000000_REALK,      0.750808345907916_REALK,      0.000000000000000_REALK, &
      0.112472693082996_REALK,      0.000000000000000_REALK,      0.341035670416102_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.382540437761187_REALK, &
      0.000000000000000_REALK,     -0.067143752329171_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.032471489091634_REALK,      0.000000000000000_REALK, &
     -0.160130704152147_REALK,      0.000000000000000_REALK,     -0.013446019709484_REALK, &
      0.000000000000000_REALK,     -0.033758794900055_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.114337523301309_REALK, &
      0.000000000000000_REALK,     -0.107429541491563_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.040331383872666_REALK,      0.000000000000000_REALK, &
     -0.367340007330244_REALK,      0.000000000000000_REALK,      0.154394826898968_REALK, &
      0.000000000000000_REALK,     -0.040792956934711_REALK,      0.000000000000000_REALK, &
      0.429736790418529_REALK,      0.092462122157282_REALK,      0.000000000000000_REALK, &
      0.041705289629904_REALK,      0.000000000000000_REALK,      0.156341631124959_REALK, &
      0.020569268181848_REALK,      0.000000000000000_REALK,      0.038704469559087_REALK, &
      0.000000000000000_REALK,      0.015638618007072_REALK,      0.000000000000000_REALK, &
      0.020968746458509_REALK,      0.000000000000000_REALK,      0.110048468054894_REALK, &
      1.918784946312336_REALK,      0.528489802327317_REALK,      0.000000000000000_REALK, &
      0.369469970777501_REALK,      0.000000000000000_REALK,      0.563825457899382_REALK, &
      0.395208388202666_REALK,      0.000000000000000_REALK,      0.174216019654202_REALK, &
      0.000000000000000_REALK,      0.565191019455497_REALK,      0.000000000000000_REALK, &
      0.140294488809480_REALK,      0.000000000000000_REALK,      0.299732738544971_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.173678014354393_REALK, &
      0.000000000000000_REALK,     -0.048117070781888_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.022490786359316_REALK,      0.000000000000000_REALK, &
     -0.101781803920946_REALK,      0.000000000000000_REALK,     -0.010832889235969_REALK, &
      0.000000000000000_REALK,     -0.033869481140332_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.660617211270198_REALK, &
      0.000000000000000_REALK,     -0.032303406771091_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.143188501503121_REALK,      0.000000000000000_REALK, &
     -0.304880322719608_REALK,      0.000000000000000_REALK,      0.289130629415871_REALK, &
      0.000000000000000_REALK,     -0.017172670088194_REALK,      0.000000000000000_REALK, &
      0.228257269123291_REALK,      0.078622439251097_REALK,      0.000000000000000_REALK, &
      0.044439502540213_REALK,      0.000000000000000_REALK,      0.116258510774822_REALK, &
      0.034027340921585_REALK,      0.000000000000000_REALK,      0.046075686236905_REALK, &
      0.000000000000000_REALK,      0.037281262148152_REALK,      0.000000000000000_REALK, &
      0.031280850407421_REALK,      0.000000000000000_REALK,      0.105215224828448_REALK, &
      2.136972080172817_REALK,      1.169017805494152_REALK,      0.000000000000000_REALK, &
      1.022596836940188_REALK,      0.000000000000000_REALK,      0.879114133927393_REALK, &
      1.125395800697151_REALK,      0.000000000000000_REALK,      0.539511414058890_REALK, &
      0.000000000000000_REALK,      1.458914277349022_REALK,      0.000000000000000_REALK, &
      0.543618146483562_REALK,      0.000000000000000_REALK,      0.600868216642837_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.500439432826911_REALK, &
      0.000000000000000_REALK,     -0.227044891172154_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.202676817721760_REALK,      0.000000000000000_REALK, &
     -0.761057798098283_REALK,      0.000000000000000_REALK,     -0.694149579006133_REALK, &
      0.000000000000000_REALK,     -0.849720713398479_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.188275268466008_REALK, &
      0.000000000000000_REALK,     -0.264173449644681_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.262988770777206_REALK,      0.000000000000000_REALK, &
     -0.479003002918416_REALK,      0.000000000000000_REALK,     -3.460672811759610_REALK, &
      0.000000000000000_REALK,     -1.179064933538331_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.925773928303285_REALK, &
      0.000000000000000_REALK,      0.013485912715449_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.274757361496003_REALK,      0.000000000000000_REALK, &
     -1.199432766296744_REALK,      0.000000000000000_REALK,      0.184128200400637_REALK, &
      0.000000000000000_REALK,      0.043338600194257_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.529691617456520_REALK, &
      0.000000000000000_REALK,      0.086783217842153_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.025478268424616_REALK,      0.000000000000000_REALK, &
     -0.745643612366356_REALK,      0.000000000000000_REALK,      1.332792443301055_REALK, &
      0.000000000000000_REALK,      0.307252845402549_REALK,      0.000000000000000_REALK, &
      0.776075095626093_REALK,      0.062608672020103_REALK,      0.000000000000000_REALK, &
      0.237759538749184_REALK,      0.000000000000000_REALK,      0.892794514297774_REALK, &
      0.066264711956831_REALK,      0.000000000000000_REALK,      0.081115799850692_REALK, &
      0.000000000000000_REALK,      0.772903523730386_REALK,      0.000000000000000_REALK, &
      0.764068833132647_REALK,      0.000000000000000_REALK,      4.781837329958432_REALK, &
      0.643447516288259_REALK,      0.114296610190119_REALK,      0.000000000000000_REALK, &
      0.379825884843682_REALK,      0.000000000000000_REALK,      0.691808014800749_REALK, &
      0.472241739210964_REALK,      0.000000000000000_REALK,      0.160894630941343_REALK, &
      0.000000000000000_REALK,      4.377978552893460_REALK,      0.000000000000000_REALK, &
      1.344759813908137_REALK,      0.000000000000000_REALK,      4.082202110520922_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.468879521623443_REALK, &
      0.000000000000000_REALK,      0.228800066739394_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.406772315566097_REALK,      0.000000000000000_REALK, &
     -1.657910830253371_REALK,      0.000000000000000_REALK,      0.497598267117497_REALK, &
      0.000000000000000_REALK,      0.589255015435553_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.768336215815453_REALK, &
      0.000000000000000_REALK,      0.125987519894336_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.342462570604318_REALK,      0.000000000000000_REALK, &
     -1.170169916141184_REALK,      0.000000000000000_REALK,     -0.285374262536875_REALK, &
      0.000000000000000_REALK,      0.357813614460504_REALK,      0.000000000000000_REALK, &
      0.963627873706561_REALK,     -0.005949155770628_REALK,      0.000000000000000_REALK, &
      0.213751837283666_REALK,      0.000000000000000_REALK,      0.933117701007943_REALK, &
     -0.028528291381831_REALK,      0.000000000000000_REALK,     -0.006714757499027_REALK, &
      0.000000000000000_REALK,      0.332942110341649_REALK,      0.000000000000000_REALK, &
      0.550499586704351_REALK,      0.000000000000000_REALK,      4.005274802774296_REALK, &
      0.403026275395887_REALK,     -0.046149263957697_REALK,      0.000000000000000_REALK, &
      0.023060252636356_REALK,      0.000000000000000_REALK,      0.674878284163169_REALK, &
     -0.304880053059269_REALK,      0.000000000000000_REALK,     -0.070284960182492_REALK, &
      0.000000000000000_REALK,     -1.553395083570803_REALK,      0.000000000000000_REALK, &
      0.065492775420193_REALK,      0.000000000000000_REALK,      3.194504746447019_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.393846063576748_REALK, &
      0.000000000000000_REALK,     -0.063105320113768_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.118382617436958_REALK,      0.000000000000000_REALK, &
     -0.740884060088284_REALK,      0.000000000000000_REALK,     -0.132766948796927_REALK, &
      0.000000000000000_REALK,     -0.270870596817163_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.367887150038157_REALK, &
      0.000000000000000_REALK,     -0.145624921423465_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.307617623041757_REALK,      0.000000000000000_REALK, &
     -0.933815315587852_REALK,      0.000000000000000_REALK,     -1.213913820780062_REALK, &
      0.000000000000000_REALK,     -0.689308744413179_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.426240272431503_REALK, &
      0.000000000000000_REALK,      0.573600951848357_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.651470549609939_REALK,      0.000000000000000_REALK, &
     -2.325808930601169_REALK,      0.000000000000000_REALK,      0.915071210738888_REALK, &
      0.000000000000000_REALK,      1.124055470239239_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.092630231007191_REALK, &
      0.000000000000000_REALK,      0.556295936159346_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.427363043859765_REALK,      0.000000000000000_REALK, &
     -1.960410752552983_REALK,      0.000000000000000_REALK,      1.132413849073831_REALK, &
      0.000000000000000_REALK,      1.016471478361069_REALK,      0.000000000000000_REALK, &
      1.482885194062922_REALK,     -0.140741110296172_REALK,      0.000000000000000_REALK, &
      0.287471760723819_REALK,      0.000000000000000_REALK,      1.171669081836966_REALK, &
     -0.113929652042474_REALK,      0.000000000000000_REALK,     -0.134915298764502_REALK, &
      0.000000000000000_REALK,      0.441575969253326_REALK,      0.000000000000000_REALK, &
      0.563343216463737_REALK,      0.000000000000000_REALK,      3.826763293962155_REALK, &
      1.749240302390975_REALK,     -0.143315303433625_REALK,      0.000000000000000_REALK, &
      0.347779527718705_REALK,      0.000000000000000_REALK,      1.188337575309570_REALK, &
      0.107079193017837_REALK,      0.000000000000000_REALK,     -0.134260156282577_REALK, &
      0.000000000000000_REALK,      1.436283611823142_REALK,      0.000000000000000_REALK, &
      0.635467469211723_REALK,      0.000000000000000_REALK,      3.618910887330691_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.573985939551556_REALK, &
      0.000000000000000_REALK,      0.004745414294953_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.126041890632113_REALK,      0.000000000000000_REALK, &
     -0.917044119261001_REALK,      0.000000000000000_REALK,      0.039509127864048_REALK, &
      0.000000000000000_REALK,      0.015498895993825_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.767698151028981_REALK, &
      0.000000000000000_REALK,      0.071376180511818_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.024574442972363_REALK,      0.000000000000000_REALK, &
     -1.198653961644476_REALK,      0.000000000000000_REALK,      0.565730016535322_REALK, &
      0.000000000000000_REALK,      0.217365874913960_REALK,      0.000000000000000_REALK, &
      0.397601360642866_REALK,      0.038817789456868_REALK,      0.000000000000000_REALK, &
      0.083662673617145_REALK,      0.000000000000000_REALK,      0.523593266049550_REALK, &
      0.030398201277504_REALK,      0.000000000000000_REALK,      0.062018288413030_REALK, &
      0.000000000000000_REALK,      0.165845014936295_REALK,      0.000000000000000_REALK, &
      0.273248866455430_REALK,      0.000000000000000_REALK,      2.394135453058046_REALK, &
      0.837553946218082_REALK,      0.165653549008706_REALK,      0.000000000000000_REALK, &
      0.312393589380082_REALK,      0.000000000000000_REALK,      0.948313413809146_REALK, &
      0.455489262300001_REALK,      0.000000000000000_REALK,      0.258644992844665_REALK, &
      0.000000000000000_REALK,      1.858319269116868_REALK,      0.000000000000000_REALK, &
      0.951349671363698_REALK,      0.000000000000000_REALK,      4.043132635706048_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.463338848904796_REALK, &
      0.000000000000000_REALK,      1.292570479972265_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.180899588674490_REALK,      0.000000000000000_REALK, &
     -3.517396355974061_REALK,      0.000000000000000_REALK,      1.544869663326354_REALK, &
      0.000000000000000_REALK,      1.855008793671588_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.533929403198772_REALK, &
      0.000000000000000_REALK,      1.280088125504411_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.278674617195122_REALK,      0.000000000000000_REALK, &
     -3.587492023814892_REALK,      0.000000000000000_REALK,      1.051410719503716_REALK, &
      0.000000000000000_REALK,      1.824125538198750_REALK,      0.000000000000000_REALK, &
      2.737736469441647_REALK,     -0.464963079278769_REALK,      0.000000000000000_REALK, &
      0.488428737118955_REALK,      0.000000000000000_REALK,      1.743734877092572_REALK, &
     -0.298295751419880_REALK,      0.000000000000000_REALK,     -0.366420631747224_REALK, &
      0.000000000000000_REALK,      0.605381105637662_REALK,      0.000000000000000_REALK, &
      0.700959534877364_REALK,      0.000000000000000_REALK,      4.170815158577106_REALK, &
      1.766413898993950_REALK,     -0.545939852781632_REALK,      0.000000000000000_REALK, &
      0.426646467802907_REALK,      0.000000000000000_REALK,      1.957123656424594_REALK, &
     -0.617430171461315_REALK,      0.000000000000000_REALK,     -0.554214485881913_REALK, &
      0.000000000000000_REALK,     -0.303462526845348_REALK,      0.000000000000000_REALK, &
      0.607971203072371_REALK,      0.000000000000000_REALK,      4.648168580438250_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.949759344769478_REALK, &
      0.000000000000000_REALK,      0.101150403549365_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.183639137687059_REALK,      0.000000000000000_REALK, &
     -1.247451803621632_REALK,      0.000000000000000_REALK,      0.122584322426007_REALK, &
      0.000000000000000_REALK,      0.241940241009177_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.166215315895380_REALK, &
      0.000000000000000_REALK,      0.134035037113373_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.346478267458826_REALK,      0.000000000000000_REALK, &
     -1.973152104679115_REALK,      0.000000000000000_REALK,     -0.152331996737732_REALK, &
      0.000000000000000_REALK,      0.318333206051184_REALK,      0.000000000000000_REALK, &
      0.647677914472251_REALK,     -0.003846650595549_REALK,      0.000000000000000_REALK, &
      0.094497719816173_REALK,      0.000000000000000_REALK,      0.687537911454627_REALK, &
     -0.012879221688806_REALK,      0.000000000000000_REALK,     -0.005052344312005_REALK, &
      0.000000000000000_REALK,      0.082020950835986_REALK,      0.000000000000000_REALK, &
      0.226027779473809_REALK,      0.000000000000000_REALK,      2.302317292157273_REALK, &
      0.648023078380582_REALK,     -0.070047431497999_REALK,      0.000000000000000_REALK, &
      0.024533238058421_REALK,      0.000000000000000_REALK,      1.196644132433190_REALK, &
     -0.308455059425402_REALK,      0.000000000000000_REALK,     -0.118515196125277_REALK, &
      0.000000000000000_REALK,     -0.829198024724949_REALK,      0.000000000000000_REALK, &
      0.058266439090460_REALK,      0.000000000000000_REALK,      3.978841651684090_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.424426661928532_REALK, &
      0.000000000000000_REALK,     -0.046497135297968_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.089073915764585_REALK,      0.000000000000000_REALK, &
     -0.780442467853693_REALK,      0.000000000000000_REALK,     -0.054512336337500_REALK, &
      0.000000000000000_REALK,     -0.155702190161122_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.930659477939301_REALK, &
      0.000000000000000_REALK,     -0.258211312834748_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.518707883332727_REALK,      0.000000000000000_REALK, &
     -2.204452090149302_REALK,      0.000000000000000_REALK,     -1.079973100021364_REALK, &
      0.000000000000000_REALK,     -0.858552596045331_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -10.204370821697809_REALK, &
      0.000000000000000_REALK,      3.213025060949132_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.476563368978800_REALK,      0.000000000000000_REALK, &
     -6.084509602689995_REALK,      0.000000000000000_REALK,      2.822195669368768_REALK, &
      0.000000000000000_REALK,      3.179828072068480_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -23.387326747396678_REALK, &
      0.000000000000000_REALK,      7.232143411778651_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.378008855251529_REALK,      0.000000000000000_REALK, &
    -11.005372481385759_REALK,      0.000000000000000_REALK,      4.621586377729353_REALK, &
      0.000000000000000_REALK,      4.958902816732800_REALK,      0.000000000000000_REALK, &
      6.825501170856471_REALK,     -1.463621848877046_REALK,      0.000000000000000_REALK, &
      1.078954135582652_REALK,      0.000000000000000_REALK,      3.213744319295947_REALK, &
     -0.726798638107584_REALK,      0.000000000000000_REALK,     -0.872706544068690_REALK, &
      0.000000000000000_REALK,      1.063283120551542_REALK,      0.000000000000000_REALK, &
      1.067806376769002_REALK,      0.000000000000000_REALK,      5.300899831724887_REALK, &
     20.988937843574458_REALK,     -4.399704784233625_REALK,      0.000000000000000_REALK, &
      2.834380315240653_REALK,      0.000000000000000_REALK,      7.952231659754710_REALK, &
     -1.193343237445771_REALK,      0.000000000000000_REALK,     -2.070368729252729_REALK, &
      0.000000000000000_REALK,      2.883513129362367_REALK,      0.000000000000000_REALK, &
      1.943464852487228_REALK,      0.000000000000000_REALK,      9.087749355339694_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.974490756447092_REALK, &
      0.000000000000000_REALK,      0.334788037677479_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.329773085336178_REALK,      0.000000000000000_REALK, &
     -1.962199691671942_REALK,      0.000000000000000_REALK,      0.269728356740963_REALK, &
      0.000000000000000_REALK,      0.552215010364248_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.726698063162699_REALK, &
      0.000000000000000_REALK,      1.228502238240023_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.690042730485609_REALK,      0.000000000000000_REALK, &
     -5.275636284735720_REALK,      0.000000000000000_REALK,      0.938435643410539_REALK, &
      0.000000000000000_REALK,      1.403922936513586_REALK,      0.000000000000000_REALK, &
      1.452406760769827_REALK,     -0.114536068207869_REALK,      0.000000000000000_REALK, &
      0.167785821049092_REALK,      0.000000000000000_REALK,      1.139760988458267_REALK, &
     -0.057670961316393_REALK,      0.000000000000000_REALK,     -0.113823089315039_REALK, &
      0.000000000000000_REALK,      0.130159881728575_REALK,      0.000000000000000_REALK, &
      0.276753762029147_REALK,      0.000000000000000_REALK,      2.631964936945598_REALK, &
      6.926460034939154_REALK,     -0.460682809482564_REALK,      0.000000000000000_REALK, &
      0.768022738339949_REALK,      0.000000000000000_REALK,      4.373797218831259_REALK, &
      0.172895667488904_REALK,      0.000000000000000_REALK,     -0.361305788165182_REALK, &
      0.000000000000000_REALK,      1.190253666081211_REALK,      0.000000000000000_REALK, &
      0.877690495431365_REALK,      0.000000000000000_REALK,      6.997678686823479_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.778522738007970_REALK, &
      0.000000000000000_REALK,      0.004616182308899_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.106336920321376_REALK,      0.000000000000000_REALK, &
     -1.083147084931758_REALK,      0.000000000000000_REALK,      0.019409659069836_REALK, &
      0.000000000000000_REALK,      0.010659805084228_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.112905048952631_REALK, &
      0.000000000000000_REALK,      0.262707286464506_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.066131968952596_REALK,      0.000000000000000_REALK, &
     -4.515955268314143_REALK,      0.000000000000000_REALK,      0.781371010398405_REALK, &
      0.000000000000000_REALK,      0.420307821188183_REALK,      0.000000000000000_REALK, &
      0.649048789707449_REALK,      0.052650299683278_REALK,      0.000000000000000_REALK, &
      0.081384285936297_REALK,      0.000000000000000_REALK,      0.713067932575243_REALK, &
      0.025645847511078_REALK,      0.000000000000000_REALK,      0.073251577428099_REALK, &
      0.000000000000000_REALK,      0.081474721725622_REALK,      0.000000000000000_REALK, &
      0.187934653994811_REALK,      0.000000000000000_REALK,      2.117101534799223_REALK, &
      5.527431849181949_REALK,      0.887480733386722_REALK,      0.000000000000000_REALK, &
      1.149796354840816_REALK,      0.000000000000000_REALK,      4.886509457672944_REALK, &
      1.225761323930733_REALK,      0.000000000000000_REALK,      0.974450721755824_REALK, &
      0.000000000000000_REALK,      2.566660354784291_REALK,      0.000000000000000_REALK, &
      1.839569839181270_REALK,      0.000000000000000_REALK,     10.051677960719404_REALK/
    ! results of test 2, ket-major order, CM010002
  data REF_CONTR_INTS(10081:11340)                                                         &
     /0.778967681580850_REALK,      0.762954762076273_REALK,      0.000000000000000_REALK, &
      0.980916612378344_REALK,      0.000000000000000_REALK,      0.462520285645863_REALK, &
      1.551322991770541_REALK,      0.000000000000000_REALK,      0.556533532726681_REALK, &
      0.000000000000000_REALK,      3.581592279907964_REALK,      0.000000000000000_REALK, &
      1.069336564795516_REALK,      0.000000000000000_REALK,      0.840353208348667_REALK, &
      1.226542279318010_REALK,      1.207958238085582_REALK,      0.000000000000000_REALK, &
      1.653774121774744_REALK,      0.000000000000000_REALK,      0.598133779548483_REALK, &
      2.866600823854720_REALK,      0.000000000000000_REALK,      0.835364553148701_REALK, &
      0.000000000000000_REALK,      6.887429539259326_REALK,      0.000000000000000_REALK, &
      1.714207535341797_REALK,      0.000000000000000_REALK,      1.033318696655052_REALK, &
      0.534615735634721_REALK,      0.382442149408176_REALK,      0.000000000000000_REALK, &
      0.366808804358701_REALK,      0.000000000000000_REALK,      0.279177938705093_REALK, &
      0.423412850977629_REALK,      0.000000000000000_REALK,      0.242597914393326_REALK, &
      0.000000000000000_REALK,      0.653656305995717_REALK,      0.000000000000000_REALK, &
      0.329709217390503_REALK,      0.000000000000000_REALK,      0.418235779282336_REALK, &
      0.258892788234387_REALK,      0.232631559665298_REALK,      0.000000000000000_REALK, &
      0.171945371112750_REALK,      0.000000000000000_REALK,      0.210155114339410_REALK, &
      0.031825299180437_REALK,      0.000000000000000_REALK,      0.171639668400126_REALK, &
      0.000000000000000_REALK,     -0.428579472317104_REALK,      0.000000000000000_REALK, &
      0.155739669321301_REALK,      0.000000000000000_REALK,      0.317246962427562_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.334461441382445_REALK, &
      0.000000000000000_REALK,     -0.337910902990347_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.449954577187133_REALK,      0.000000000000000_REALK, &
     -0.353603145163826_REALK,      0.000000000000000_REALK,     -0.846651016739323_REALK, &
      0.000000000000000_REALK,     -0.506223487771555_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.465846026281682_REALK, &
      0.000000000000000_REALK,     -0.613665612912665_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.950318735954605_REALK,      0.000000000000000_REALK, &
     -0.572849026385648_REALK,      0.000000000000000_REALK,     -1.907355850512320_REALK, &
      0.000000000000000_REALK,     -0.926380270376712_REALK,      0.000000000000000_REALK, &
      0.498141531633661_REALK,      0.278503456838321_REALK,      0.000000000000000_REALK, &
      0.226026549202582_REALK,      0.000000000000000_REALK,      0.226862475832449_REALK, &
      0.226665384566547_REALK,      0.000000000000000_REALK,      0.152274980369755_REALK, &
      0.000000000000000_REALK,      0.311780557984997_REALK,      0.000000000000000_REALK, &
      0.167261317443801_REALK,      0.000000000000000_REALK,      0.279799848883302_REALK, &
      0.561588843128981_REALK,      0.309181471240707_REALK,      0.000000000000000_REALK, &
      0.274158404781078_REALK,      0.000000000000000_REALK,      0.206277910321453_REALK, &
      0.349728377752212_REALK,      0.000000000000000_REALK,      0.152409374677854_REALK, &
      0.000000000000000_REALK,      0.659431624401708_REALK,      0.000000000000000_REALK, &
      0.184539759119509_REALK,      0.000000000000000_REALK,      0.231414121778695_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.229488650841768_REALK, &
      0.000000000000000_REALK,     -0.166989059162020_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.164860962040417_REALK,      0.000000000000000_REALK, &
     -0.209125948852516_REALK,      0.000000000000000_REALK,     -0.215675616756814_REALK, &
      0.000000000000000_REALK,     -0.205955230574165_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.271355952770943_REALK, &
      0.000000000000000_REALK,     -0.166547584404235_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.109443027995606_REALK,      0.000000000000000_REALK, &
     -0.222939141593077_REALK,      0.000000000000000_REALK,     -0.020786508692337_REALK, &
      0.000000000000000_REALK,     -0.186842415260112_REALK,      0.000000000000000_REALK, &
      0.320670056935807_REALK,      0.277768070040427_REALK,      0.000000000000000_REALK, &
      0.309720269846603_REALK,      0.000000000000000_REALK,      0.243398038582903_REALK, &
      0.423341822945841_REALK,      0.000000000000000_REALK,      0.253121498579851_REALK, &
      0.000000000000000_REALK,      0.767657355411798_REALK,      0.000000000000000_REALK, &
      0.381992149125526_REALK,      0.000000000000000_REALK,      0.420271478699723_REALK, &
      0.907983275220810_REALK,      0.792375753491019_REALK,      0.000000000000000_REALK, &
      0.922125353437292_REALK,      0.000000000000000_REALK,      0.555854147599703_REALK, &
      1.340357281191755_REALK,      0.000000000000000_REALK,      0.650995743777069_REALK, &
      0.000000000000000_REALK,      2.493860272577155_REALK,      0.000000000000000_REALK, &
      1.034491907073419_REALK,      0.000000000000000_REALK,      0.873023674152633_REALK, &
      0.558287861856482_REALK,      0.238220494742982_REALK,      0.000000000000000_REALK, &
      0.160693915338243_REALK,      0.000000000000000_REALK,      0.220959107856830_REALK, &
      0.128345063743067_REALK,      0.000000000000000_REALK,      0.111444477489568_REALK, &
      0.000000000000000_REALK,      0.133848576694382_REALK,      0.000000000000000_REALK, &
      0.097657642954205_REALK,      0.000000000000000_REALK,      0.223803803410374_REALK, &
      0.275948742789156_REALK,      0.152064374698037_REALK,      0.000000000000000_REALK, &
      0.080468953433202_REALK,      0.000000000000000_REALK,      0.170122381003085_REALK, &
     -0.002714292773276_REALK,      0.000000000000000_REALK,      0.083258883668467_REALK, &
      0.000000000000000_REALK,     -0.165509717402360_REALK,      0.000000000000000_REALK, &
      0.049087884377659_REALK,      0.000000000000000_REALK,      0.172964176709131_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.214504439988369_REALK, &
      0.000000000000000_REALK,     -0.120783481226248_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.099979855173245_REALK,      0.000000000000000_REALK, &
     -0.167249360440124_REALK,      0.000000000000000_REALK,     -0.109262465839866_REALK, &
      0.000000000000000_REALK,     -0.122338484934031_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.208232652200192_REALK, &
      0.000000000000000_REALK,     -0.150825809177844_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.151530750799740_REALK,      0.000000000000000_REALK, &
     -0.190020599279524_REALK,      0.000000000000000_REALK,     -0.211125561754085_REALK, &
      0.000000000000000_REALK,     -0.153345266843292_REALK,      0.000000000000000_REALK, &
      0.251468993348485_REALK,      0.157892549167932_REALK,      0.000000000000000_REALK, &
      0.130766596490102_REALK,      0.000000000000000_REALK,      0.165877283686494_REALK, &
      0.128919329688956_REALK,      0.000000000000000_REALK,      0.123109003562021_REALK, &
      0.000000000000000_REALK,      0.157551300580113_REALK,      0.000000000000000_REALK, &
      0.132450125896043_REALK,      0.000000000000000_REALK,      0.235217974438341_REALK, &
      0.214718035529032_REALK,      0.168125831621935_REALK,      0.000000000000000_REALK, &
      0.108305891886250_REALK,      0.000000000000000_REALK,      0.220622756961391_REALK, &
      0.017068382898535_REALK,      0.000000000000000_REALK,      0.153421526074857_REALK, &
      0.000000000000000_REALK,     -0.181815189367733_REALK,      0.000000000000000_REALK, &
      0.110115078994302_REALK,      0.000000000000000_REALK,      0.314031385021629_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.230139249644146_REALK, &
      0.000000000000000_REALK,     -0.200774255215413_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.228334442957612_REALK,      0.000000000000000_REALK, &
     -0.251215775506263_REALK,      0.000000000000000_REALK,     -0.340114949301887_REALK, &
      0.000000000000000_REALK,     -0.284702718669977_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.561121562705327_REALK, &
      0.000000000000000_REALK,     -0.644231760900834_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.849450200450151_REALK,      0.000000000000000_REALK, &
     -0.716864124248824_REALK,      0.000000000000000_REALK,     -1.348587942074701_REALK, &
      0.000000000000000_REALK,     -0.916990590349733_REALK,      0.000000000000000_REALK, &
      0.767216326763468_REALK,      0.244993026162889_REALK,      0.000000000000000_REALK, &
      0.143389126117644_REALK,      0.000000000000000_REALK,      0.258137123641279_REALK, &
      0.095521422201409_REALK,      0.000000000000000_REALK,      0.096400821384409_REALK, &
      0.000000000000000_REALK,      0.087938998057292_REALK,      0.000000000000000_REALK, &
      0.070914882570203_REALK,      0.000000000000000_REALK,      0.212774895671101_REALK, &
      1.063363926968480_REALK,      0.325238088364285_REALK,      0.000000000000000_REALK, &
      0.198173567149616_REALK,      0.000000000000000_REALK,      0.281155997472462_REALK, &
      0.184828167668752_REALK,      0.000000000000000_REALK,      0.107883713271546_REALK, &
      0.000000000000000_REALK,      0.285185877020619_REALK,      0.000000000000000_REALK, &
      0.083451934208420_REALK,      0.000000000000000_REALK,      0.197327122051387_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.247373927318716_REALK, &
      0.000000000000000_REALK,     -0.104484854257497_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.070789437434579_REALK,      0.000000000000000_REALK, &
     -0.162229446256129_REALK,      0.000000000000000_REALK,     -0.059510709634625_REALK, &
      0.000000000000000_REALK,     -0.086123815320510_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.359503955890029_REALK, &
      0.000000000000000_REALK,     -0.128924298826679_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.056405968502465_REALK,      0.000000000000000_REALK, &
     -0.198749895767565_REALK,      0.000000000000000_REALK,      0.001769911557137_REALK, &
      0.000000000000000_REALK,     -0.090484503544881_REALK,      0.000000000000000_REALK, &
      0.279626208954554_REALK,      0.135222686206369_REALK,      0.000000000000000_REALK, &
      0.093736188923673_REALK,      0.000000000000000_REALK,      0.156804764523947_REALK, &
      0.079201466014759_REALK,      0.000000000000000_REALK,      0.088679925739554_REALK, &
      0.000000000000000_REALK,      0.086413576287438_REALK,      0.000000000000000_REALK, &
      0.077264004252861_REALK,      0.000000000000000_REALK,      0.180949426097079_REALK, &
      0.667714334351977_REALK,      0.318726288275769_REALK,      0.000000000000000_REALK, &
      0.234641577412065_REALK,      0.000000000000000_REALK,      0.294242145045914_REALK, &
      0.242600428544565_REALK,      0.000000000000000_REALK,      0.176206173910836_REALK, &
      0.000000000000000_REALK,      0.353081913206787_REALK,      0.000000000000000_REALK, &
      0.164681342744095_REALK,      0.000000000000000_REALK,      0.289116144297628_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.185707280937596_REALK, &
      0.000000000000000_REALK,     -0.115420939509251_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.096009586312837_REALK,      0.000000000000000_REALK, &
     -0.170503276356972_REALK,      0.000000000000000_REALK,     -0.099628306323343_REALK, &
      0.000000000000000_REALK,     -0.133193355617680_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.466221748245730_REALK, &
      0.000000000000000_REALK,     -0.237569395632088_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.126531174772442_REALK,      0.000000000000000_REALK, &
     -0.360847582593661_REALK,      0.000000000000000_REALK,     -0.018549662028111_REALK, &
      0.000000000000000_REALK,     -0.233430692457565_REALK,      0.000000000000000_REALK, &
      0.300007617152948_REALK,      0.224776052450882_REALK,      0.000000000000000_REALK, &
      0.214075129892606_REALK,      0.000000000000000_REALK,      0.235527540549626_REALK, &
      0.246540313649196_REALK,      0.000000000000000_REALK,      0.206373456096966_REALK, &
      0.000000000000000_REALK,      0.354608477798257_REALK,      0.000000000000000_REALK, &
      0.247038232628505_REALK,      0.000000000000000_REALK,      0.349449257395331_REALK, &
      1.799280308700708_REALK,      1.361395632886474_REALK,      0.000000000000000_REALK, &
      1.315352388308503_REALK,      0.000000000000000_REALK,      1.110046165653601_REALK, &
      1.549637144641131_REALK,      0.000000000000000_REALK,      1.053696711766708_REALK, &
      0.000000000000000_REALK,      2.225494713246019_REALK,      0.000000000000000_REALK, &
      1.292437597071928_REALK,      0.000000000000000_REALK,      1.402338882780909_REALK, &
      1.260864008438978_REALK,      0.292499410174724_REALK,      0.000000000000000_REALK, &
      0.152659949241794_REALK,      0.000000000000000_REALK,      0.360962187932097_REALK, &
      0.079186668616842_REALK,      0.000000000000000_REALK,      0.095953498459804_REALK, &
      0.000000000000000_REALK,      0.059417103167855_REALK,      0.000000000000000_REALK, &
      0.060870212659587_REALK,      0.000000000000000_REALK,      0.239877859807835_REALK, &
      0.769453310959304_REALK,      0.236882362575830_REALK,      0.000000000000000_REALK, &
      0.097527974094219_REALK,      0.000000000000000_REALK,      0.360683508670701_REALK, &
     -0.022880187214544_REALK,      0.000000000000000_REALK,      0.094962669134672_REALK, &
      0.000000000000000_REALK,     -0.165048207800698_REALK,      0.000000000000000_REALK, &
      0.039929366055237_REALK,      0.000000000000000_REALK,      0.246115092986662_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.349976841279529_REALK, &
      0.000000000000000_REALK,     -0.109889689225777_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.063773591795903_REALK,      0.000000000000000_REALK, &
     -0.191347977309439_REALK,      0.000000000000000_REALK,     -0.043416688554842_REALK, &
      0.000000000000000_REALK,     -0.073027326262180_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.385376777997648_REALK, &
      0.000000000000000_REALK,     -0.155401019265141_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.108894038148890_REALK,      0.000000000000000_REALK, &
     -0.257486508375097_REALK,      0.000000000000000_REALK,     -0.109000715101491_REALK, &
      0.000000000000000_REALK,     -0.106039049158693_REALK,      0.000000000000000_REALK, &
      0.387582075930800_REALK,      0.141658350952290_REALK,      0.000000000000000_REALK, &
      0.080694636917394_REALK,      0.000000000000000_REALK,      0.184929372761954_REALK, &
      0.053517845142957_REALK,      0.000000000000000_REALK,      0.077450950253195_REALK, &
      0.000000000000000_REALK,      0.044099320383379_REALK,      0.000000000000000_REALK, &
      0.053625718839437_REALK,      0.000000000000000_REALK,      0.172053054562388_REALK, &
      0.366447804305149_REALK,      0.176714817873654_REALK,      0.000000000000000_REALK, &
      0.081249937846109_REALK,      0.000000000000000_REALK,      0.286289148236672_REALK, &
     -0.002309506885026_REALK,      0.000000000000000_REALK,      0.118070636401205_REALK, &
      0.000000000000000_REALK,     -0.112159336580370_REALK,      0.000000000000000_REALK, &
      0.055441503499436_REALK,      0.000000000000000_REALK,      0.273492161697744_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.212592576424353_REALK, &
      0.000000000000000_REALK,     -0.101088448626648_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.069483342412095_REALK,      0.000000000000000_REALK, &
     -0.162727405269185_REALK,      0.000000000000000_REALK,     -0.059998153709074_REALK, &
      0.000000000000000_REALK,     -0.094049831605583_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.403313786041563_REALK, &
      0.000000000000000_REALK,     -0.253816059868389_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.214887966220159_REALK,      0.000000000000000_REALK, &
     -0.377259373856781_REALK,      0.000000000000000_REALK,     -0.238452292642230_REALK, &
      0.000000000000000_REALK,     -0.242470604682591_REALK,      0.000000000000000_REALK, &
      0.290963620303132_REALK,      0.156485263557433_REALK,      0.000000000000000_REALK, &
      0.109443710656177_REALK,      0.000000000000000_REALK,      0.194360917072794_REALK, &
      0.089595508143051_REALK,      0.000000000000000_REALK,      0.119780480249397_REALK, &
      0.000000000000000_REALK,      0.086514495866532_REALK,      0.000000000000000_REALK, &
      0.101823330927943_REALK,      0.000000000000000_REALK,      0.232493009732269_REALK, &
      0.475226859579306_REALK,      0.325633203853351_REALK,      0.000000000000000_REALK, &
      0.182261742131186_REALK,      0.000000000000000_REALK,      0.519782647759560_REALK, &
      0.024204922554501_REALK,      0.000000000000000_REALK,      0.304597023073326_REALK, &
      0.000000000000000_REALK,     -0.205348174715174_REALK,      0.000000000000000_REALK, &
      0.174114730360114_REALK,      0.000000000000000_REALK,      0.638419647418330_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.319323247710943_REALK, &
      0.000000000000000_REALK,     -0.235250225353504_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.222160917915014_REALK,      0.000000000000000_REALK, &
     -0.314258918393463_REALK,      0.000000000000000_REALK,     -0.261469264766788_REALK, &
      0.000000000000000_REALK,     -0.281404480676257_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.521525482628652_REALK, &
      0.000000000000000_REALK,     -1.517796690893676_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.686464793603429_REALK,      0.000000000000000_REALK, &
     -1.829871832782617_REALK,      0.000000000000000_REALK,     -2.132396653081351_REALK, &
      0.000000000000000_REALK,     -1.864223887483993_REALK,      0.000000000000000_REALK, &
      2.443555404783461_REALK,     -0.049739213176926_REALK,      0.000000000000000_REALK, &
      2.447169377287383_REALK,      0.000000000000000_REALK,      3.310262114470492_REALK, &
      0.113120236305909_REALK,      0.000000000000000_REALK,      0.080459124348110_REALK, &
      0.000000000000000_REALK,     17.396815921660327_REALK,      0.000000000000000_REALK, &
      9.817599265559327_REALK,      0.000000000000000_REALK,     22.133617725484378_REALK, &
      2.492125940894548_REALK,     -0.150789961912235_REALK,      0.000000000000000_REALK, &
      3.459046652053860_REALK,      0.000000000000000_REALK,      3.432155282782896_REALK, &
     -0.021079693742575_REALK,      0.000000000000000_REALK,     -0.012588636115074_REALK, &
      0.000000000000000_REALK,     34.268431164503376_REALK,      0.000000000000000_REALK, &
     16.159218128373254_REALK,      0.000000000000000_REALK,     26.722654844799813_REALK, &
      1.503258783243034_REALK,      0.212458468088049_REALK,      0.000000000000000_REALK, &
      0.831812238005129_REALK,      0.000000000000000_REALK,      1.954318047539585_REALK, &
      0.289129920468890_REALK,      0.000000000000000_REALK,      0.323102384232680_REALK, &
      0.000000000000000_REALK,      3.130944504034718_REALK,      0.000000000000000_REALK, &
      3.113076381689531_REALK,      0.000000000000000_REALK,     12.190133538420731_REALK, &
      0.670858107101589_REALK,      0.097238834477472_REALK,      0.000000000000000_REALK, &
      0.346583711059645_REALK,      0.000000000000000_REALK,      1.379857862975326_REALK, &
     -0.012054045131847_REALK,      0.000000000000000_REALK,      0.247391460888583_REALK, &
      0.000000000000000_REALK,     -2.443571045273046_REALK,      0.000000000000000_REALK, &
      1.546880281858926_REALK,      0.000000000000000_REALK,     10.264354862872727_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.401233794951732_REALK, &
      0.000000000000000_REALK,     -0.919427527835910_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.451092148838531_REALK,      0.000000000000000_REALK, &
     -1.016979906318321_REALK,      0.000000000000000_REALK,     -4.837789586425197_REALK, &
      0.000000000000000_REALK,     -5.734964356149797_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.372640649455491_REALK, &
      0.000000000000000_REALK,     -1.566128268309100_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.955486772886179_REALK,      0.000000000000000_REALK, &
     -1.580097690232702_REALK,      0.000000000000000_REALK,    -11.704732729216188_REALK, &
      0.000000000000000_REALK,    -11.649965360952828_REALK,      0.000000000000000_REALK, &
      1.348607083457475_REALK,      0.190235677130195_REALK,      0.000000000000000_REALK, &
      0.482481899730566_REALK,      0.000000000000000_REALK,      1.551433634244652_REALK, &
      0.187601892590380_REALK,      0.000000000000000_REALK,      0.246469356602850_REALK, &
      0.000000000000000_REALK,      1.357157903056300_REALK,      0.000000000000000_REALK, &
      1.550513531756342_REALK,      0.000000000000000_REALK,      8.309530522843009_REALK, &
      1.091328763506225_REALK,      0.182649625083257_REALK,      0.000000000000000_REALK, &
      0.401868082900374_REALK,      0.000000000000000_REALK,      1.173351308792633_REALK, &
      0.310635612711562_REALK,      0.000000000000000_REALK,      0.257114747064351_REALK, &
      0.000000000000000_REALK,      2.528762488309537_REALK,      0.000000000000000_REALK, &
      1.422799419263211_REALK,      0.000000000000000_REALK,      6.923679816741236_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.538912181770249_REALK, &
      0.000000000000000_REALK,     -0.379030392856202_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.297179622333891_REALK,      0.000000000000000_REALK, &
     -1.163691100692325_REALK,      0.000000000000000_REALK,     -1.089987317936269_REALK, &
      0.000000000000000_REALK,     -2.030099482829131_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.597005779704164_REALK, &
      0.000000000000000_REALK,     -0.357299211890615_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.211086535593284_REALK,      0.000000000000000_REALK, &
     -1.400668903413871_REALK,      0.000000000000000_REALK,      0.061636835065003_REALK, &
      0.000000000000000_REALK,     -2.108341571161788_REALK,      0.000000000000000_REALK, &
      0.622228256527672_REALK,      0.253536365603071_REALK,      0.000000000000000_REALK, &
      0.529174784007438_REALK,      0.000000000000000_REALK,      1.193015936215147_REALK, &
      0.461823709395914_REALK,      0.000000000000000_REALK,      0.547469555030306_REALK, &
      0.000000000000000_REALK,      3.013409434139881_REALK,      0.000000000000000_REALK, &
      2.834277872136973_REALK,      0.000000000000000_REALK,      8.945766653732640_REALK, &
      1.273532643526513_REALK,      0.677597057658195_REALK,      0.000000000000000_REALK, &
      1.379977585717445_REALK,      0.000000000000000_REALK,      2.282082240844149_REALK, &
      1.597222170862796_REALK,      0.000000000000000_REALK,      1.589748642260841_REALK, &
      0.000000000000000_REALK,     10.361105020090474_REALK,      0.000000000000000_REALK, &
      8.142934589316377_REALK,      0.000000000000000_REALK,     18.852469235551112_REALK, &
      1.589753901531950_REALK,      0.087773662699723_REALK,      0.000000000000000_REALK, &
      0.392428627699966_REALK,      0.000000000000000_REALK,      1.539419464964156_REALK, &
      0.047987544812878_REALK,      0.000000000000000_REALK,      0.099069327237978_REALK, &
      0.000000000000000_REALK,      0.723403654944870_REALK,      0.000000000000000_REALK, &
      1.010666388205568_REALK,      0.000000000000000_REALK,      6.607738752850794_REALK, &
      0.692084157227295_REALK,      0.035322413543525_REALK,      0.000000000000000_REALK, &
      0.195471794194665_REALK,      0.000000000000000_REALK,      1.158913443217246_REALK, &
     -0.120248807994039_REALK,      0.000000000000000_REALK,      0.053795753529935_REALK, &
      0.000000000000000_REALK,     -0.509219036418539_REALK,      0.000000000000000_REALK, &
      0.555153949093790_REALK,      0.000000000000000_REALK,      5.485662499378424_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.684397159662685_REALK, &
      0.000000000000000_REALK,     -0.191744736232476_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.240232086824135_REALK,      0.000000000000000_REALK, &
     -1.287454651085959_REALK,      0.000000000000000_REALK,     -0.375876241399488_REALK, &
      0.000000000000000_REALK,     -0.823036964969121_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.623960491567285_REALK, &
      0.000000000000000_REALK,     -0.232713264693778_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.325469404195654_REALK,      0.000000000000000_REALK, &
     -1.583811403270873_REALK,      0.000000000000000_REALK,     -0.798499650045956_REALK, &
      0.000000000000000_REALK,     -1.101537338021264_REALK,      0.000000000000000_REALK, &
      0.560947747562515_REALK,      0.167204912005736_REALK,      0.000000000000000_REALK, &
      0.231195589924382_REALK,      0.000000000000000_REALK,      0.905311906655699_REALK, &
      0.168879485819812_REALK,      0.000000000000000_REALK,      0.314537748450478_REALK, &
      0.000000000000000_REALK,      0.598842038121476_REALK,      0.000000000000000_REALK, &
      0.992374134405991_REALK,      0.000000000000000_REALK,      5.440291348291835_REALK, &
      0.454243578441634_REALK,      0.190003275419086_REALK,      0.000000000000000_REALK, &
      0.191053361939282_REALK,      0.000000000000000_REALK,      1.267738381365247_REALK, &
     -0.014099600908961_REALK,      0.000000000000000_REALK,      0.482289116594033_REALK, &
      0.000000000000000_REALK,     -0.857141031603823_REALK,      0.000000000000000_REALK, &
      0.904342139703721_REALK,      0.000000000000000_REALK,      8.401092345361764_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.526285301643273_REALK, &
      0.000000000000000_REALK,     -0.425912603787692_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.439134824635592_REALK,      0.000000000000000_REALK, &
     -1.386031238975131_REALK,      0.000000000000000_REALK,     -1.542171365118088_REALK, &
      0.000000000000000_REALK,     -2.559436848758740_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.213557394212391_REALK, &
      0.000000000000000_REALK,     -1.438873502228278_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.862719392000750_REALK,      0.000000000000000_REALK, &
     -4.312555829471150_REALK,      0.000000000000000_REALK,     -6.842858600718072_REALK, &
      0.000000000000000_REALK,     -9.535176455331412_REALK,      0.000000000000000_REALK, &
      2.347884581401607_REALK,     -0.104822268774508_REALK,      0.000000000000000_REALK, &
      0.456843746872740_REALK,      0.000000000000000_REALK,      1.855129299802870_REALK, &
     -0.102215338646677_REALK,      0.000000000000000_REALK,     -0.100483275136350_REALK, &
      0.000000000000000_REALK,      0.670727306256096_REALK,      0.000000000000000_REALK, &
      0.895252546325363_REALK,      0.000000000000000_REALK,      6.058998073849623_REALK, &
      2.742989015543889_REALK,     -0.132741071519980_REALK,      0.000000000000000_REALK, &
      0.445632527771832_REALK,      0.000000000000000_REALK,      1.863435750580855_REALK, &
      0.003412475783016_REALK,      0.000000000000000_REALK,     -0.124354040220439_REALK, &
      0.000000000000000_REALK,      1.116922656369187_REALK,      0.000000000000000_REALK, &
      0.814265797872491_REALK,      0.000000000000000_REALK,      5.674825121861133_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.946938555561581_REALK, &
      0.000000000000000_REALK,     -0.070013697700128_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.231401267947132_REALK,      0.000000000000000_REALK, &
     -1.512901926409045_REALK,      0.000000000000000_REALK,     -0.066458450613736_REALK, &
      0.000000000000000_REALK,     -0.228670238539837_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.318305431421177_REALK, &
      0.000000000000000_REALK,     -0.054630968058490_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.208306931189868_REALK,      0.000000000000000_REALK, &
     -2.058350701916397_REALK,      0.000000000000000_REALK,      0.223131554367697_REALK, &
      0.000000000000000_REALK,     -0.166370742792325_REALK,      0.000000000000000_REALK, &
      0.690922842876072_REALK,      0.117947374121806_REALK,      0.000000000000000_REALK, &
      0.169775420644303_REALK,      0.000000000000000_REALK,      0.909862449426236_REALK, &
      0.086060286426932_REALK,      0.000000000000000_REALK,      0.188441803827433_REALK, &
      0.000000000000000_REALK,      0.291210824886597_REALK,      0.000000000000000_REALK, &
      0.554499865200853_REALK,      0.000000000000000_REALK,      4.160355162725566_REALK, &
      1.420545871042655_REALK,      0.264719649776340_REALK,      0.000000000000000_REALK, &
      0.330522531201913_REALK,      0.000000000000000_REALK,      1.608401119144371_REALK, &
      0.299616010889902_REALK,      0.000000000000000_REALK,      0.413322940148086_REALK, &
      0.000000000000000_REALK,      1.073383069896435_REALK,      0.000000000000000_REALK, &
      1.006558751929644_REALK,      0.000000000000000_REALK,      6.857415450866440_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.556881843274087_REALK, &
      0.000000000000000_REALK,     -0.222288284873389_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.227213089956620_REALK,      0.000000000000000_REALK, &
     -1.245604217858373_REALK,      0.000000000000000_REALK,     -0.389804931390485_REALK, &
      0.000000000000000_REALK,     -1.016415408911092_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.442097685169061_REALK, &
      0.000000000000000_REALK,     -0.489776972989963_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.339330623829419_REALK,      0.000000000000000_REALK, &
     -3.152289140627818_REALK,      0.000000000000000_REALK,      0.043604948762244_REALK, &
      0.000000000000000_REALK,     -2.088163295886450_REALK,      0.000000000000000_REALK, &
      0.531303398387097_REALK,      0.261990363903564_REALK,      0.000000000000000_REALK, &
      0.310342804567354_REALK,      0.000000000000000_REALK,      0.979527921244812_REALK, &
      0.353094169791962_REALK,      0.000000000000000_REALK,      0.586006360699235_REALK, &
      0.000000000000000_REALK,      1.077665619037064_REALK,      0.000000000000000_REALK, &
      1.419045582121471_REALK,      0.000000000000000_REALK,      5.758587296164656_REALK, &
      2.762857534924224_REALK,      1.636769997118730_REALK,      0.000000000000000_REALK, &
      1.891639338218311_REALK,      0.000000000000000_REALK,      4.379511100986617_REALK, &
      2.567602874857624_REALK,      0.000000000000000_REALK,      3.577824401692959_REALK, &
      0.000000000000000_REALK,      7.329958669110840_REALK,      0.000000000000000_REALK, &
      8.065001118791599_REALK,      0.000000000000000_REALK,     24.006906220020142_REALK, &
      4.201550183639268_REALK,     -0.543063404240941_REALK,      0.000000000000000_REALK, &
      0.717091841993126_REALK,      0.000000000000000_REALK,      2.676075537161065_REALK, &
     -0.357124314537010_REALK,      0.000000000000000_REALK,     -0.427968680802415_REALK, &
      0.000000000000000_REALK,      0.852561858545339_REALK,      0.000000000000000_REALK, &
      1.029121191748049_REALK,      0.000000000000000_REALK,      6.400867793903856_REALK, &
      2.692267374642717_REALK,     -0.626872651753313_REALK,      0.000000000000000_REALK, &
      0.680260586586473_REALK,      0.000000000000000_REALK,      2.982936315964440_REALK, &
     -0.603703842578996_REALK,      0.000000000000000_REALK,     -0.636373957011446_REALK, &
      0.000000000000000_REALK,      0.257022921067532_REALK,      0.000000000000000_REALK, &
      0.969371314286262_REALK,      0.000000000000000_REALK,      7.084473592559807_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.503774756504669_REALK, &
      0.000000000000000_REALK,      0.075335591464280_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.291835245041806_REALK,      0.000000000000000_REALK, &
     -1.975117741745135_REALK,      0.000000000000000_REALK,      0.109980130764170_REALK, &
      0.000000000000000_REALK,      0.180194151638173_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.828745768598852_REALK, &
      0.000000000000000_REALK,      0.124145531017137_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.443965138369407_REALK,      0.000000000000000_REALK, &
     -3.094105790801978_REALK,      0.000000000000000_REALK,     -0.004854624275693_REALK, &
      0.000000000000000_REALK,      0.294845629595972_REALK,      0.000000000000000_REALK, &
      1.068512565444824_REALK,      0.056753365505137_REALK,      0.000000000000000_REALK, &
      0.173489084255327_REALK,      0.000000000000000_REALK,      1.134271960172628_REALK, &
      0.021664186602503_REALK,      0.000000000000000_REALK,      0.074542133805658_REALK, &
      0.000000000000000_REALK,      0.178211928662072_REALK,      0.000000000000000_REALK, &
      0.414966123557878_REALK,      0.000000000000000_REALK,      3.798269018197848_REALK, &
      1.112797188283371_REALK,      0.053613950274529_REALK,      0.000000000000000_REALK, &
      0.207957654944500_REALK,      0.000000000000000_REALK,      2.054899386107031_REALK, &
     -0.121658838757892_REALK,      0.000000000000000_REALK,      0.090710932520319_REALK, &
      0.000000000000000_REALK,     -0.271819721599723_REALK,      0.000000000000000_REALK, &
      0.493899419488156_REALK,      0.000000000000000_REALK,      6.832540306563702_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.737537908265516_REALK, &
      0.000000000000000_REALK,     -0.141280971670875_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.180756373942474_REALK,      0.000000000000000_REALK, &
     -1.356196386548674_REALK,      0.000000000000000_REALK,     -0.154329765639070_REALK, &
      0.000000000000000_REALK,     -0.473099182912625_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.578458897725919_REALK, &
      0.000000000000000_REALK,     -0.412629905673262_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.548809733559951_REALK,      0.000000000000000_REALK, &
     -3.738893869121067_REALK,      0.000000000000000_REALK,     -0.710394863015855_REALK, &
      0.000000000000000_REALK,     -1.371994405792914_REALK,      0.000000000000000_REALK, &
      0.628377885251016_REALK,      0.180187716023267_REALK,      0.000000000000000_REALK, &
      0.170349070500354_REALK,      0.000000000000000_REALK,      0.933870142622527_REALK, &
      0.127068968569572_REALK,      0.000000000000000_REALK,      0.331332025964473_REALK, &
      0.000000000000000_REALK,      0.245876544508398_REALK,      0.000000000000000_REALK, &
      0.570437795766212_REALK,      0.000000000000000_REALK,      4.020679770009829_REALK, &
      1.217291692074804_REALK,      0.480659215984965_REALK,      0.000000000000000_REALK, &
      0.338761655117948_REALK,      0.000000000000000_REALK,      3.147003576153012_REALK, &
     -0.023774886727899_REALK,      0.000000000000000_REALK,      1.138536960558080_REALK, &
      0.000000000000000_REALK,     -0.762565876762027_REALK,      0.000000000000000_REALK, &
      1.126382478169204_REALK,      0.000000000000000_REALK,     13.453439988285536_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.794009000567219_REALK, &
      0.000000000000000_REALK,     -0.439348097732698_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.462581778609546_REALK,      0.000000000000000_REALK, &
     -1.877189561279475_REALK,      0.000000000000000_REALK,     -0.886472957840951_REALK, &
      0.000000000000000_REALK,     -1.891567069041823_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.297981506453589_REALK, &
      0.000000000000000_REALK,     -3.571825325875024_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.397310248089819_REALK,      0.000000000000000_REALK, &
    -13.089373850210078_REALK,      0.000000000000000_REALK,     -8.522964583916711_REALK, &
      0.000000000000000_REALK,    -15.269552927880639_REALK,      0.000000000000000_REALK/
    ! results of test 2, ket-major order, CM000102
  data REF_CONTR_INTS(11341:12600)                                                         &
     /0.298275017314338_REALK,      0.164087924192330_REALK,      0.000000000000000_REALK, &
      0.105063310024795_REALK,      0.000000000000000_REALK,      0.155760107588638_REALK, &
      0.037318182280638_REALK,      0.000000000000000_REALK,      0.104087345622837_REALK, &
      0.000000000000000_REALK,     -0.134354693488454_REALK,      0.000000000000000_REALK, &
      0.094437050891658_REALK,      0.000000000000000_REALK,      0.233343831824939_REALK, &
      0.055917615118965_REALK,     -0.071497513384724_REALK,      0.000000000000000_REALK, &
     -0.283609603141107_REALK,      0.000000000000000_REALK,      0.045390885080484_REALK, &
     -0.738187866946589_REALK,      0.000000000000000_REALK,     -0.052752126609321_REALK, &
      0.000000000000000_REALK,     -2.086422173435828_REALK,      0.000000000000000_REALK, &
     -0.256879644527205_REALK,      0.000000000000000_REALK,      0.068521389350656_REALK, &
      0.325178677416417_REALK,      0.162498186687140_REALK,      0.000000000000000_REALK, &
      0.122531061843461_REALK,      0.000000000000000_REALK,      0.148092128766452_REALK, &
      0.115964101613311_REALK,      0.000000000000000_REALK,      0.088847759625008_REALK, &
      0.000000000000000_REALK,      0.159944178558548_REALK,      0.000000000000000_REALK, &
      0.090673891646933_REALK,      0.000000000000000_REALK,      0.182648783575221_REALK, &
      0.358586258464748_REALK,      0.202941349911583_REALK,      0.000000000000000_REALK, &
      0.213150467039273_REALK,      0.000000000000000_REALK,      0.131712773448222_REALK, &
      0.340017877408335_REALK,      0.000000000000000_REALK,      0.100038867504527_REALK, &
      0.000000000000000_REALK,      0.772439015076527_REALK,      0.000000000000000_REALK, &
      0.143474484668993_REALK,      0.000000000000000_REALK,      0.147762771821073_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.128037255061347_REALK, &
      0.000000000000000_REALK,     -0.071647144863945_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.047220345204420_REALK,      0.000000000000000_REALK, &
     -0.116676412340921_REALK,      0.000000000000000_REALK,     -0.019008922287163_REALK, &
      0.000000000000000_REALK,     -0.088365694821464_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.058609503303539_REALK, &
      0.000000000000000_REALK,      0.051187113916390_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.180517181332212_REALK,      0.000000000000000_REALK, &
     -0.048152075612350_REALK,      0.000000000000000_REALK,      0.482143103380326_REALK, &
      0.000000000000000_REALK,      0.057424573454754_REALK,      0.000000000000000_REALK, &
      0.385594517588236_REALK,      0.147833539945339_REALK,      0.000000000000000_REALK, &
      0.092597208615155_REALK,      0.000000000000000_REALK,      0.152610555274232_REALK, &
      0.065402875959424_REALK,      0.000000000000000_REALK,      0.069159589448493_REALK, &
      0.000000000000000_REALK,      0.056707369415341_REALK,      0.000000000000000_REALK, &
      0.056273600145100_REALK,      0.000000000000000_REALK,      0.154575310527922_REALK, &
      0.171829232930367_REALK,      0.066300176240069_REALK,      0.000000000000000_REALK, &
     -0.004843805899442_REALK,      0.000000000000000_REALK,      0.105932710316362_REALK, &
     -0.110467034251739_REALK,      0.000000000000000_REALK,      0.036300932889326_REALK, &
      0.000000000000000_REALK,     -0.351478381905431_REALK,      0.000000000000000_REALK, &
     -0.002954831320591_REALK,      0.000000000000000_REALK,      0.107702254802701_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.140025004272608_REALK, &
      0.000000000000000_REALK,     -0.070473440092414_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.054199994914549_REALK,      0.000000000000000_REALK, &
     -0.109177658101106_REALK,      0.000000000000000_REALK,     -0.055899685412508_REALK, &
      0.000000000000000_REALK,     -0.071380736847991_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.132960917148257_REALK, &
      0.000000000000000_REALK,     -0.098999442603171_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.117810906908244_REALK,      0.000000000000000_REALK, &
     -0.121332139269768_REALK,      0.000000000000000_REALK,     -0.205263484295027_REALK, &
      0.000000000000000_REALK,     -0.100653170873560_REALK,      0.000000000000000_REALK, &
      0.140300618454462_REALK,      0.067744260611687_REALK,      0.000000000000000_REALK, &
      0.037454857420739_REALK,      0.000000000000000_REALK,      0.092546938606105_REALK, &
      0.011362515411901_REALK,      0.000000000000000_REALK,      0.052820278505229_REALK, &
      0.000000000000000_REALK,     -0.032383618889599_REALK,      0.000000000000000_REALK, &
      0.037937062781707_REALK,      0.000000000000000_REALK,      0.131233782924371_REALK, &
      0.046376419179907_REALK,     -0.051672176010864_REALK,      0.000000000000000_REALK, &
     -0.178641569801616_REALK,      0.000000000000000_REALK,      0.047651765406007_REALK, &
     -0.395901169464643_REALK,      0.000000000000000_REALK,     -0.047152921253780_REALK, &
      0.000000000000000_REALK,     -0.885117620107567_REALK,      0.000000000000000_REALK, &
     -0.181625673615531_REALK,      0.000000000000000_REALK,      0.067826864713656_REALK, &
      0.551664499520554_REALK,      0.160013525574356_REALK,      0.000000000000000_REALK, &
      0.090645271726214_REALK,      0.000000000000000_REALK,      0.185612691171449_REALK, &
      0.057012460925790_REALK,      0.000000000000000_REALK,      0.062962752612097_REALK, &
      0.000000000000000_REALK,      0.052186980636392_REALK,      0.000000000000000_REALK, &
      0.044829750860847_REALK,      0.000000000000000_REALK,      0.152995123065367_REALK, &
      0.753169714522225_REALK,      0.226180895027066_REALK,      0.000000000000000_REALK, &
      0.159379436880276_REALK,      0.000000000000000_REALK,      0.199139896494554_REALK, &
      0.185899357920508_REALK,      0.000000000000000_REALK,      0.075025760203309_REALK, &
      0.000000000000000_REALK,      0.340267392689466_REALK,      0.000000000000000_REALK, &
      0.067115521368530_REALK,      0.000000000000000_REALK,      0.139764767652628_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.170854565691576_REALK, &
      0.000000000000000_REALK,     -0.064840625455941_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.040791241485913_REALK,      0.000000000000000_REALK, &
     -0.112047546331608_REALK,      0.000000000000000_REALK,     -0.030325837605117_REALK, &
      0.000000000000000_REALK,     -0.053446234784149_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.223857838059496_REALK, &
      0.000000000000000_REALK,     -0.056211086592832_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.003395341325307_REALK,      0.000000000000000_REALK, &
     -0.123758643687045_REALK,      0.000000000000000_REALK,      0.072032347626561_REALK, &
      0.000000000000000_REALK,     -0.039451308328684_REALK,      0.000000000000000_REALK, &
      0.182535434258227_REALK,      0.078898271342662_REALK,      0.000000000000000_REALK, &
      0.050815246273050_REALK,      0.000000000000000_REALK,      0.102359596023381_REALK, &
      0.040520200605056_REALK,      0.000000000000000_REALK,      0.051742004540336_REALK, &
      0.000000000000000_REALK,      0.044330373147468_REALK,      0.000000000000000_REALK, &
      0.041885524142102_REALK,      0.000000000000000_REALK,      0.118120837795914_REALK, &
      0.426349611122108_REALK,      0.209206402102393_REALK,      0.000000000000000_REALK, &
      0.182427242572230_REALK,      0.000000000000000_REALK,      0.187879782808333_REALK, &
      0.235864425135440_REALK,      0.000000000000000_REALK,      0.115658673376259_REALK, &
      0.000000000000000_REALK,      0.413589878292892_REALK,      0.000000000000000_REALK, &
      0.128035123149291_REALK,      0.000000000000000_REALK,      0.184606723787121_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.103610572500819_REALK, &
      0.000000000000000_REALK,     -0.049521692108753_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.027499571472319_REALK,      0.000000000000000_REALK, &
     -0.095127891525953_REALK,      0.000000000000000_REALK,     -0.008780903288838_REALK, &
      0.000000000000000_REALK,     -0.057146999286917_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.100698086093049_REALK, &
      0.000000000000000_REALK,      0.073015119137078_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.208702659629373_REALK,      0.000000000000000_REALK, &
     -0.077938579817888_REALK,      0.000000000000000_REALK,      0.430259441316693_REALK, &
      0.000000000000000_REALK,      0.071743120677189_REALK,      0.000000000000000_REALK, &
      0.931920696899751_REALK,      0.195118690965601_REALK,      0.000000000000000_REALK, &
      0.100350484732249_REALK,      0.000000000000000_REALK,      0.266791764600059_REALK, &
      0.047532650804593_REALK,      0.000000000000000_REALK,      0.064008064159388_REALK, &
      0.000000000000000_REALK,      0.033552602132950_REALK,      0.000000000000000_REALK, &
      0.040012821807439_REALK,      0.000000000000000_REALK,      0.177296790761521_REALK, &
      0.549258519016639_REALK,      0.135179064950792_REALK,      0.000000000000000_REALK, &
      0.024775221320820_REALK,      0.000000000000000_REALK,      0.257466550581485_REALK, &
     -0.092730361438337_REALK,      0.000000000000000_REALK,      0.054191306939313_REALK, &
      0.000000000000000_REALK,     -0.266838005284462_REALK,      0.000000000000000_REALK, &
      0.010143334673012_REALK,      0.000000000000000_REALK,      0.175684228732425_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.251649752818385_REALK, &
      0.000000000000000_REALK,     -0.071772804608715_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.040315292475898_REALK,      0.000000000000000_REALK, &
     -0.137588164451597_REALK,      0.000000000000000_REALK,     -0.025913477864064_REALK, &
      0.000000000000000_REALK,     -0.047696704357253_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.272958401640972_REALK, &
      0.000000000000000_REALK,     -0.108070803768037_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.087577121053114_REALK,      0.000000000000000_REALK, &
     -0.182375041213849_REALK,      0.000000000000000_REALK,     -0.109632439718598_REALK, &
      0.000000000000000_REALK,     -0.073742922199410_REALK,      0.000000000000000_REALK, &
      0.267692589800210_REALK,      0.087909545762175_REALK,      0.000000000000000_REALK, &
      0.046498948718974_REALK,      0.000000000000000_REALK,      0.127725779387214_REALK, &
      0.027271956438524_REALK,      0.000000000000000_REALK,      0.048064076772293_REALK, &
      0.000000000000000_REALK,      0.018683474368620_REALK,      0.000000000000000_REALK, &
      0.030900932770609_REALK,      0.000000000000000_REALK,      0.118832450257750_REALK, &
      0.228181670575256_REALK,      0.077047787113324_REALK,      0.000000000000000_REALK, &
     -0.004890817035355_REALK,      0.000000000000000_REALK,      0.178268051669952_REALK, &
     -0.093992946775935_REALK,      0.000000000000000_REALK,      0.051478882004558_REALK, &
      0.000000000000000_REALK,     -0.238182885908867_REALK,      0.000000000000000_REALK, &
     -0.003337285627151_REALK,      0.000000000000000_REALK,      0.170299555932016_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.138776970881158_REALK, &
      0.000000000000000_REALK,     -0.058981995352333_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.037667556117737_REALK,      0.000000000000000_REALK, &
     -0.106225799425521_REALK,      0.000000000000000_REALK,     -0.030695608889003_REALK, &
      0.000000000000000_REALK,     -0.054875179172409_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.257524313905717_REALK, &
      0.000000000000000_REALK,     -0.166600455105629_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.167069364141951_REALK,      0.000000000000000_REALK, &
     -0.240888025104493_REALK,      0.000000000000000_REALK,     -0.231831465689087_REALK, &
      0.000000000000000_REALK,     -0.159153495294203_REALK,      0.000000000000000_REALK, &
      0.162335623699369_REALK,      0.067140460599242_REALK,      0.000000000000000_REALK, &
      0.031347444135200_REALK,      0.000000000000000_REALK,      0.108438644882553_REALK, &
      0.007896646255986_REALK,      0.000000000000000_REALK,      0.051392165830307_REALK, &
      0.000000000000000_REALK,     -0.017782477531139_REALK,      0.000000000000000_REALK, &
      0.029164774830700_REALK,      0.000000000000000_REALK,      0.129713459371006_REALK, &
      0.102643077890961_REALK,     -0.100080850528246_REALK,      0.000000000000000_REALK, &
     -0.300625599974640_REALK,      0.000000000000000_REALK,      0.112266572742930_REALK, &
     -0.561433218547651_REALK,      0.000000000000000_REALK,     -0.093615542815710_REALK, &
      0.000000000000000_REALK,     -0.999681535571331_REALK,      0.000000000000000_REALK, &
     -0.287187780973019_REALK,      0.000000000000000_REALK,      0.137890685840209_REALK, &
      2.308434872003004_REALK,      0.311595756161896_REALK,      0.000000000000000_REALK, &
      0.153028746246680_REALK,      0.000000000000000_REALK,      0.503896079574469_REALK, &
      0.053469682853723_REALK,      0.000000000000000_REALK,      0.078260036722457_REALK, &
      0.000000000000000_REALK,      0.037979170486361_REALK,      0.000000000000000_REALK, &
      0.046164230140379_REALK,      0.000000000000000_REALK,      0.253350815395308_REALK, &
      6.687144709027781_REALK,      0.944449805154593_REALK,      0.000000000000000_REALK, &
      0.520693853515071_REALK,      0.000000000000000_REALK,      1.178990621597243_REALK, &
      0.408850341330846_REALK,      0.000000000000000_REALK,      0.186802036776461_REALK, &
      0.000000000000000_REALK,      0.588825142829781_REALK,      0.000000000000000_REALK, &
      0.118630173680546_REALK,      0.000000000000000_REALK,      0.447684249467098_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.512654436619610_REALK, &
      0.000000000000000_REALK,     -0.099615314931408_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.048430648964803_REALK,      0.000000000000000_REALK, &
     -0.214596178127105_REALK,      0.000000000000000_REALK,     -0.022315983499988_REALK, &
      0.000000000000000_REALK,     -0.050084972451156_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.556227643507752_REALK, &
      0.000000000000000_REALK,     -0.225320683749056_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.029619149211089_REALK,      0.000000000000000_REALK, &
     -0.513008547248832_REALK,      0.000000000000000_REALK,      0.087842786353029_REALK, &
      0.000000000000000_REALK,     -0.085558374550047_REALK,      0.000000000000000_REALK, &
      0.588573078701778_REALK,      0.137915226755399_REALK,      0.000000000000000_REALK, &
      0.062742415495305_REALK,      0.000000000000000_REALK,      0.214127524596757_REALK, &
      0.031365109812334_REALK,      0.000000000000000_REALK,      0.057731053226410_REALK, &
      0.000000000000000_REALK,      0.022033812893679_REALK,      0.000000000000000_REALK, &
      0.031545873782210_REALK,      0.000000000000000_REALK,      0.150723808372099_REALK, &
      2.580586730152566_REALK,      0.653221833671527_REALK,      0.000000000000000_REALK, &
      0.364134727707523_REALK,      0.000000000000000_REALK,      0.758292635958850_REALK, &
      0.320133338303479_REALK,      0.000000000000000_REALK,      0.215333781867356_REALK, &
      0.000000000000000_REALK,      0.420602819821856_REALK,      0.000000000000000_REALK, &
      0.138268599675373_REALK,      0.000000000000000_REALK,      0.403112568278162_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.245431816726843_REALK, &
      0.000000000000000_REALK,     -0.074801795796180_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.037401816720162_REALK,      0.000000000000000_REALK, &
     -0.143832212378246_REALK,      0.000000000000000_REALK,     -0.021339735935636_REALK, &
      0.000000000000000_REALK,     -0.052652789764904_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.077521213285711_REALK, &
      0.000000000000000_REALK,     -0.214042759752843_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.009745075375814_REALK,      0.000000000000000_REALK, &
     -0.497284977804500_REALK,      0.000000000000000_REALK,      0.148398040193492_REALK, &
      0.000000000000000_REALK,     -0.113786317463323_REALK,      0.000000000000000_REALK, &
      0.324579651240025_REALK,      0.113337012644970_REALK,      0.000000000000000_REALK, &
      0.058621761408395_REALK,      0.000000000000000_REALK,      0.165318489202611_REALK, &
      0.037153297161056_REALK,      0.000000000000000_REALK,      0.066419722962041_REALK, &
      0.000000000000000_REALK,      0.031194470840784_REALK,      0.000000000000000_REALK, &
      0.041263705586627_REALK,      0.000000000000000_REALK,      0.149615042321007_REALK, &
      2.434670715982770_REALK,      1.006997736485763_REALK,      0.000000000000000_REALK, &
      0.694653542940771_REALK,      0.000000000000000_REALK,      1.001582312533764_REALK, &
      0.676961866627561_REALK,      0.000000000000000_REALK,      0.464737808279904_REALK, &
      0.000000000000000_REALK,      0.852060628382167_REALK,      0.000000000000000_REALK, &
      0.369281673696189_REALK,      0.000000000000000_REALK,      0.684574339926238_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.208370571270800_REALK, &
      0.000000000000000_REALK,     -0.079981278162781_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.035300408922935_REALK,      0.000000000000000_REALK, &
     -0.157002349073003_REALK,      0.000000000000000_REALK,     -0.008650544920150_REALK, &
      0.000000000000000_REALK,     -0.072383932220352_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.678582687925232_REALK, &
      0.000000000000000_REALK,      0.389241730973508_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.838605647004170_REALK,      0.000000000000000_REALK, &
     -0.402649121850144_REALK,      0.000000000000000_REALK,      1.240963594245549_REALK, &
      0.000000000000000_REALK,      0.266043936397841_REALK,      0.000000000000000_REALK, &
      1.061162321019866_REALK,      0.110642897426023_REALK,      0.000000000000000_REALK, &
      0.406918649271663_REALK,      0.000000000000000_REALK,      1.379568640114067_REALK, &
      0.071436492199449_REALK,      0.000000000000000_REALK,      0.168263398858474_REALK, &
      0.000000000000000_REALK,      0.313151308753437_REALK,      0.000000000000000_REALK, &
      1.522902379213143_REALK,      0.000000000000000_REALK,      8.605112135959706_REALK, &
      0.384402561513886_REALK,      0.002678952300192_REALK,      0.000000000000000_REALK, &
     -0.247230251782250_REALK,      0.000000000000000_REALK,      0.790660337018882_REALK, &
     -0.414898601817271_REALK,      0.000000000000000_REALK,      0.006815691763035_REALK, &
      0.000000000000000_REALK,     -8.064043715033666_REALK,      0.000000000000000_REALK, &
     -1.103443668462436_REALK,      0.000000000000000_REALK,      5.881488588731164_REALK, &
      1.012989919036071_REALK,      0.106313289649060_REALK,      0.000000000000000_REALK, &
      0.318149955747695_REALK,      0.000000000000000_REALK,      1.165340632435499_REALK, &
      0.090304395780085_REALK,      0.000000000000000_REALK,      0.137739505509281_REALK, &
      0.000000000000000_REALK,      0.826026326775381_REALK,      0.000000000000000_REALK, &
      1.022413093195734_REALK,      0.000000000000000_REALK,      6.241603469842612_REALK, &
      0.806598388679349_REALK,      0.116129261536575_REALK,      0.000000000000000_REALK, &
      0.324976278045644_REALK,      0.000000000000000_REALK,      0.867221048940625_REALK, &
      0.315198197242485_REALK,      0.000000000000000_REALK,      0.163474442902010_REALK, &
      0.000000000000000_REALK,      2.958802124796852_REALK,      0.000000000000000_REALK, &
      1.150566763950471_REALK,      0.000000000000000_REALK,      5.117274620319637_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.380422391678614_REALK, &
      0.000000000000000_REALK,     -0.197389265090408_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.145378878773390_REALK,      0.000000000000000_REALK, &
     -0.821458795468875_REALK,      0.000000000000000_REALK,     -0.269307550076372_REALK, &
      0.000000000000000_REALK,     -1.057223516975554_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.342085082564446_REALK, &
      0.000000000000000_REALK,     -0.009843675633245_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.150575389659871_REALK,      0.000000000000000_REALK, &
     -0.802585090059295_REALK,      0.000000000000000_REALK,      2.121531519850343_REALK, &
      0.000000000000000_REALK,     -0.058085296188555_REALK,      0.000000000000000_REALK, &
      1.232200095623984_REALK,      0.027650627951370_REALK,      0.000000000000000_REALK, &
      0.284753275179400_REALK,      0.000000000000000_REALK,      1.193186448610916_REALK, &
     -0.003664815295388_REALK,      0.000000000000000_REALK,      0.031209009907917_REALK, &
      0.000000000000000_REALK,      0.480676557590064_REALK,      0.000000000000000_REALK, &
      0.733357721229509_REALK,      0.000000000000000_REALK,      5.121582853342924_REALK, &
      0.525872729988093_REALK,     -0.014482884008964_REALK,      0.000000000000000_REALK, &
      0.100146440654388_REALK,      0.000000000000000_REALK,      0.880587960062783_REALK, &
     -0.211891411867978_REALK,      0.000000000000000_REALK,     -0.022057316598392_REALK, &
      0.000000000000000_REALK,     -0.990393000716567_REALK,      0.000000000000000_REALK, &
      0.284423091556643_REALK,      0.000000000000000_REALK,      4.168221861772831_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.514076658694253_REALK, &
      0.000000000000000_REALK,     -0.107156627974755_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.158409730675815_REALK,      0.000000000000000_REALK, &
     -0.967056008205597_REALK,      0.000000000000000_REALK,     -0.180932486335752_REALK, &
      0.000000000000000_REALK,     -0.459954560409622_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.461167655364264_REALK, &
      0.000000000000000_REALK,     -0.147959896256756_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.263195411862202_REALK,      0.000000000000000_REALK, &
     -1.170591089110407_REALK,      0.000000000000000_REALK,     -0.810227932323204_REALK, &
      0.000000000000000_REALK,     -0.700361238415159_REALK,      0.000000000000000_REALK, &
      0.395977472681142_REALK,      0.087076011112491_REALK,      0.000000000000000_REALK, &
      0.113099799295108_REALK,      0.000000000000000_REALK,      0.639066869139567_REALK, &
      0.041725733718078_REALK,      0.000000000000000_REALK,      0.163803157161030_REALK, &
      0.000000000000000_REALK,      0.059895078859640_REALK,      0.000000000000000_REALK, &
      0.485464776658085_REALK,      0.000000000000000_REALK,      3.840344895057449_REALK, &
      0.260282156920787_REALK,      0.005234634027271_REALK,      0.000000000000000_REALK, &
     -0.136285028028814_REALK,      0.000000000000000_REALK,      0.726415729298882_REALK, &
     -0.485306354781591_REALK,      0.000000000000000_REALK,      0.013287176313866_REALK, &
      0.000000000000000_REALK,     -2.828656347918840_REALK,      0.000000000000000_REALK, &
     -0.645098796514913_REALK,      0.000000000000000_REALK,      4.813836760539776_REALK, &
      1.860585301459293_REALK,     -0.132136521801347_REALK,      0.000000000000000_REALK, &
      0.358692251960332_REALK,      0.000000000000000_REALK,      1.470100504454604_REALK, &
     -0.114898247509749_REALK,      0.000000000000000_REALK,     -0.126666887016989_REALK, &
      0.000000000000000_REALK,      0.533054655383181_REALK,      0.000000000000000_REALK, &
      0.702910249101250_REALK,      0.000000000000000_REALK,      4.801463771717864_REALK, &
      2.178307500247759_REALK,     -0.150664095738903_REALK,      0.000000000000000_REALK, &
      0.380929139303654_REALK,      0.000000000000000_REALK,      1.479822211725200_REALK, &
      0.040944212172307_REALK,      0.000000000000000_REALK,     -0.141144626954977_REALK, &
      0.000000000000000_REALK,      1.225367156665843_REALK,      0.000000000000000_REALK, &
      0.696038889034565_REALK,      0.000000000000000_REALK,      4.506585354696882_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.733961261292471_REALK, &
      0.000000000000000_REALK,     -0.022055849637137_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.167908924776482_REALK,      0.000000000000000_REALK, &
     -1.172633007281516_REALK,      0.000000000000000_REALK,      0.005075440872559_REALK, &
      0.000000000000000_REALK,     -0.072036138118638_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.001700254138173_REALK, &
      0.000000000000000_REALK,      0.022399770975830_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.106722291102156_REALK,      0.000000000000000_REALK, &
     -1.564015722056457_REALK,      0.000000000000000_REALK,      0.393181943970799_REALK, &
      0.000000000000000_REALK,      0.068215275475934_REALK,      0.000000000000000_REALK, &
      0.518978346807174_REALK,      0.065914940549116_REALK,      0.000000000000000_REALK, &
      0.111950401860038_REALK,      0.000000000000000_REALK,      0.683432187390930_REALK, &
      0.041426139465523_REALK,      0.000000000000000_REALK,      0.105310782785431_REALK, &
      0.000000000000000_REALK,      0.177243788255290_REALK,      0.000000000000000_REALK, &
      0.365638809817051_REALK,      0.000000000000000_REALK,      3.125000521757650_REALK, &
      1.049921938231378_REALK,      0.168309666273524_REALK,      0.000000000000000_REALK, &
      0.267281694094754_REALK,      0.000000000000000_REALK,      1.188765287266720_REALK, &
      0.304016740621339_REALK,      0.000000000000000_REALK,      0.262792150784016_REALK, &
      0.000000000000000_REALK,      1.255921867954324_REALK,      0.000000000000000_REALK, &
      0.813967893333439_REALK,      0.000000000000000_REALK,      5.068298791468806_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.393107318533467_REALK, &
      0.000000000000000_REALK,     -0.115762012799886_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.111151578971382_REALK,      0.000000000000000_REALK, &
     -0.879281915814378_REALK,      0.000000000000000_REALK,     -0.096310672017010_REALK, &
      0.000000000000000_REALK,     -0.529322962941504_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.826323835493705_REALK, &
      0.000000000000000_REALK,     -0.013493468483278_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.242056371634666_REALK,      0.000000000000000_REALK, &
     -1.806265747499183_REALK,      0.000000000000000_REALK,      1.500876434083585_REALK, &
      0.000000000000000_REALK,     -0.057529380054294_REALK,      0.000000000000000_REALK, &
      3.384895735521311_REALK,     -0.508514556170498_REALK,      0.000000000000000_REALK, &
      0.589000243643397_REALK,      0.000000000000000_REALK,      2.155927283444557_REALK, &
     -0.329428297868654_REALK,      0.000000000000000_REALK,     -0.400741979801236_REALK, &
      0.000000000000000_REALK,      0.714836850330105_REALK,      0.000000000000000_REALK, &
      0.845292886045683_REALK,      0.000000000000000_REALK,      5.156732432612320_REALK, &
      2.176223298542341_REALK,     -0.588965416114245_REALK,      0.000000000000000_REALK, &
      0.543527048927963_REALK,      0.000000000000000_REALK,      2.411177868145932_REALK, &
     -0.604759844888001_REALK,      0.000000000000000_REALK,     -0.597892173709002_REALK, &
      0.000000000000000_REALK,     -0.010244985685630_REALK,      0.000000000000000_REALK, &
      0.774526027464414_REALK,      0.000000000000000_REALK,      5.726547309248070_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.191668973347856_REALK, &
      0.000000000000000_REALK,      0.094966300007790_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.229135326820180_REALK,      0.000000000000000_REALK, &
     -1.565185558120023_REALK,      0.000000000000000_REALK,      0.123626497285073_REALK, &
      0.000000000000000_REALK,      0.227148569905816_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.452273633328917_REALK, &
      0.000000000000000_REALK,      0.140907964328942_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.379503845658404_REALK,      0.000000000000000_REALK, &
     -2.457142122141367_REALK,      0.000000000000000_REALK,     -0.058247670899256_REALK, &
      0.000000000000000_REALK,      0.334656407824447_REALK,      0.000000000000000_REALK, &
      0.828191888095253_REALK,      0.017878554298676_REALK,      0.000000000000000_REALK, &
      0.125886801987722_REALK,      0.000000000000000_REALK,      0.879161244040026_REALK, &
     -0.001654496864397_REALK,      0.000000000000000_REALK,      0.023482406284134_REALK, &
      0.000000000000000_REALK,      0.118415625640292_REALK,      0.000000000000000_REALK, &
      0.301106887803169_REALK,      0.000000000000000_REALK,      2.943994943443102_REALK, &
      0.845547017966864_REALK,     -0.021982773689334_REALK,      0.000000000000000_REALK, &
      0.106543345730918_REALK,      0.000000000000000_REALK,      1.561393276725541_REALK, &
     -0.214376038654006_REALK,      0.000000000000000_REALK,     -0.037193265755125_REALK, &
      0.000000000000000_REALK,     -0.528669060808291_REALK,      0.000000000000000_REALK, &
      0.253040440472702_REALK,      0.000000000000000_REALK,      5.191632529432837_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.553992690046164_REALK, &
      0.000000000000000_REALK,     -0.078954931534041_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.119191274124534_REALK,      0.000000000000000_REALK, &
     -1.018690532371265_REALK,      0.000000000000000_REALK,     -0.074288462895992_REALK, &
      0.000000000000000_REALK,     -0.264391681016286_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.166635065506588_REALK, &
      0.000000000000000_REALK,     -0.262351517074837_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.443802710780963_REALK,      0.000000000000000_REALK, &
     -2.763407206996931_REALK,      0.000000000000000_REALK,     -0.720829071072524_REALK, &
      0.000000000000000_REALK,     -0.872318774836887_REALK,      0.000000000000000_REALK, &
      0.443576942721723_REALK,      0.093837121018539_REALK,      0.000000000000000_REALK, &
      0.083333967096863_REALK,      0.000000000000000_REALK,      0.659226354851944_REALK, &
      0.031395441078154_REALK,      0.000000000000000_REALK,      0.172549184283635_REALK, &
      0.000000000000000_REALK,      0.024592119600126_REALK,      0.000000000000000_REALK, &
      0.279055496831077_REALK,      0.000000000000000_REALK,      2.838229800737817_REALK, &
      0.697509711203754_REALK,      0.013242272176448_REALK,      0.000000000000000_REALK, &
     -0.241650506404119_REALK,      0.000000000000000_REALK,      1.803237112230929_REALK, &
     -0.818328383034511_REALK,      0.000000000000000_REALK,      0.031366955658514_REALK, &
      0.000000000000000_REALK,     -2.516548302410755_REALK,      0.000000000000000_REALK, &
     -0.803487915890434_REALK,      0.000000000000000_REALK,      7.708838483019431_REALK, &
      8.337467655900054_REALK,     -1.662791147729720_REALK,      0.000000000000000_REALK, &
      1.273445492740430_REALK,      0.000000000000000_REALK,      3.925644234136187_REALK, &
     -0.824422909585208_REALK,      0.000000000000000_REALK,     -0.991464234533383_REALK, &
      0.000000000000000_REALK,      1.226058813000370_REALK,      0.000000000000000_REALK, &
      1.260288248380147_REALK,      0.000000000000000_REALK,      6.475140768106633_REALK, &
     25.361669888090081_REALK,     -5.032601318543276_REALK,      0.000000000000000_REALK, &
      3.207839667915962_REALK,      0.000000000000000_REALK,      9.608960478677126_REALK, &
     -1.494586233716697_REALK,      0.000000000000000_REALK,     -2.368190800902332_REALK, &
      0.000000000000000_REALK,      2.880125957389092_REALK,      0.000000000000000_REALK, &
      2.199536743000436_REALK,      0.000000000000000_REALK,     10.981046344200211_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.441230343359921_REALK, &
      0.000000000000000_REALK,      0.366146470500048_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.397676084244687_REALK,      0.000000000000000_REALK, &
     -2.426033857793542_REALK,      0.000000000000000_REALK,      0.297879379860865_REALK, &
      0.000000000000000_REALK,      0.603939072628394_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.287297249898080_REALK, &
      0.000000000000000_REALK,      1.325320597600197_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.879081200101013_REALK,      0.000000000000000_REALK, &
     -6.499588009365266_REALK,      0.000000000000000_REALK,      0.919177941698444_REALK, &
      0.000000000000000_REALK,      1.514566215093275_REALK,      0.000000000000000_REALK, &
      1.822343821118346_REALK,     -0.107533595848016_REALK,      0.000000000000000_REALK, &
      0.209354386140668_REALK,      0.000000000000000_REALK,      1.430065220687735_REALK, &
     -0.058161262398885_REALK,      0.000000000000000_REALK,     -0.106864206848469_REALK, &
      0.000000000000000_REALK,      0.157124335857456_REALK,      0.000000000000000_REALK, &
      0.345318892856746_REALK,      0.000000000000000_REALK,      3.302342821442604_REALK, &
      8.625435752681385_REALK,     -0.484305285271183_REALK,      0.000000000000000_REALK, &
      0.841229047036104_REALK,      0.000000000000000_REALK,      5.446636047271576_REALK, &
      0.066110667197119_REALK,      0.000000000000000_REALK,     -0.379832499076767_REALK, &
      0.000000000000000_REALK,      1.015466401281074_REALK,      0.000000000000000_REALK, &
      0.961350103592327_REALK,      0.000000000000000_REALK,      8.714123466625036_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.995504404131617_REALK, &
      0.000000000000000_REALK,     -0.021455202132925_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.141658601482891_REALK,      0.000000000000000_REALK, &
     -1.385030443851787_REALK,      0.000000000000000_REALK,      0.002493413099486_REALK, &
      0.000000000000000_REALK,     -0.049544896079768_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.366559796008285_REALK, &
      0.000000000000000_REALK,      0.082444633605919_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.287198991637569_REALK,      0.000000000000000_REALK, &
     -5.892463768323091_REALK,      0.000000000000000_REALK,      0.543052275557824_REALK, &
      0.000000000000000_REALK,      0.131903933027163_REALK,      0.000000000000000_REALK, &
      0.847185903325234_REALK,      0.089403374640192_REALK,      0.000000000000000_REALK, &
      0.108901653769210_REALK,      0.000000000000000_REALK,      0.930748366179537_REALK, &
      0.034949714491550_REALK,      0.000000000000000_REALK,      0.124385582972651_REALK, &
      0.000000000000000_REALK,      0.087074599928384_REALK,      0.000000000000000_REALK, &
      0.251478456622438_REALK,      0.000000000000000_REALK,      2.763395610056609_REALK, &
      6.928953038475544_REALK,      0.901710750867465_REALK,      0.000000000000000_REALK, &
      0.983757439439379_REALK,      0.000000000000000_REALK,      6.125520038622172_REALK, &
      0.818135559550640_REALK,      0.000000000000000_REALK,      0.990075230866904_REALK, &
      0.000000000000000_REALK,      1.734645343648035_REALK,      0.000000000000000_REALK, &
      1.573922640338706_REALK,      0.000000000000000_REALK,     12.600355182671699_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.746464592273205_REALK, &
      0.000000000000000_REALK,     -0.157653248218345_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.131284314701710_REALK,      0.000000000000000_REALK, &
     -1.335272225730045_REALK,      0.000000000000000_REALK,     -0.066240394905634_REALK, &
      0.000000000000000_REALK,     -0.468073122519672_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.197784974111695_REALK, &
      0.000000000000000_REALK,     -0.069529714965751_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.911952725049098_REALK,      0.000000000000000_REALK, &
     -8.749473542190227_REALK,      0.000000000000000_REALK,      2.902157958934735_REALK, &
      0.000000000000000_REALK,     -0.143024445074782_REALK,      0.000000000000000_REALK/
    ! results of test 2, ket-major order, CM000003
  data REF_CONTR_INTS(12601:13860)                                                         &
     /0.000000000000000_REALK,      0.000000000000000_REALK,     -0.334461441382445_REALK, &
      0.000000000000000_REALK,     -0.337910902990347_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.449954577187133_REALK,      0.000000000000000_REALK, &
     -0.353603145163826_REALK,      0.000000000000000_REALK,     -0.846651016739323_REALK, &
      0.000000000000000_REALK,     -0.506223487771555_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.465846026281682_REALK, &
      0.000000000000000_REALK,     -0.613665612912665_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.950318735954605_REALK,      0.000000000000000_REALK, &
     -0.572849026385647_REALK,      0.000000000000000_REALK,     -1.907355850512320_REALK, &
      0.000000000000000_REALK,     -0.926380270376712_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.229488650841768_REALK, &
      0.000000000000000_REALK,     -0.166989059162020_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.164860962040417_REALK,      0.000000000000000_REALK, &
     -0.209125948852516_REALK,      0.000000000000000_REALK,     -0.215675616756814_REALK, &
      0.000000000000000_REALK,     -0.205955230574165_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.271355952770943_REALK, &
      0.000000000000000_REALK,     -0.166547584404235_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.109443027995606_REALK,      0.000000000000000_REALK, &
     -0.222939141593077_REALK,      0.000000000000000_REALK,     -0.020786508692337_REALK, &
      0.000000000000000_REALK,     -0.186842415260112_REALK,      0.000000000000000_REALK, &
      0.320670056935807_REALK,      0.277768070040427_REALK,      0.000000000000000_REALK, &
      0.309720269846603_REALK,      0.000000000000000_REALK,      0.243398038582903_REALK, &
      0.423341822945841_REALK,      0.000000000000000_REALK,      0.253121498579851_REALK, &
      0.000000000000000_REALK,      0.767657355411798_REALK,      0.000000000000000_REALK, &
      0.381992149125526_REALK,      0.000000000000000_REALK,      0.420271478699723_REALK, &
      0.907983275220810_REALK,      0.792375753491019_REALK,      0.000000000000000_REALK, &
      0.922125353437292_REALK,      0.000000000000000_REALK,      0.555854147599702_REALK, &
      1.340357281191755_REALK,      0.000000000000000_REALK,      0.650995743777069_REALK, &
      0.000000000000000_REALK,      2.493860272577155_REALK,      0.000000000000000_REALK, &
      1.034491907073419_REALK,      0.000000000000000_REALK,      0.873023674152633_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.214504439988369_REALK, &
      0.000000000000000_REALK,     -0.120783481226248_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.099979855173245_REALK,      0.000000000000000_REALK, &
     -0.167249360440124_REALK,      0.000000000000000_REALK,     -0.109262465839866_REALK, &
      0.000000000000000_REALK,     -0.122338484934031_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.208232652200192_REALK, &
      0.000000000000000_REALK,     -0.150825809177844_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.151530750799740_REALK,      0.000000000000000_REALK, &
     -0.190020599279523_REALK,      0.000000000000000_REALK,     -0.211125561754085_REALK, &
      0.000000000000000_REALK,     -0.153345266843292_REALK,      0.000000000000000_REALK, &
      0.251468993348485_REALK,      0.157892549167932_REALK,      0.000000000000000_REALK, &
      0.130766596490102_REALK,      0.000000000000000_REALK,      0.165877283686494_REALK, &
      0.128919329688956_REALK,      0.000000000000000_REALK,      0.123109003562021_REALK, &
      0.000000000000000_REALK,      0.157551300580113_REALK,      0.000000000000000_REALK, &
      0.132450125896043_REALK,      0.000000000000000_REALK,      0.235217974438341_REALK, &
      0.214718035529032_REALK,      0.168125831621935_REALK,      0.000000000000000_REALK, &
      0.108305891886250_REALK,      0.000000000000000_REALK,      0.220622756961391_REALK, &
      0.017068382898535_REALK,      0.000000000000000_REALK,      0.153421526074857_REALK, &
      0.000000000000000_REALK,     -0.181815189367733_REALK,      0.000000000000000_REALK, &
      0.110115078994302_REALK,      0.000000000000000_REALK,      0.314031385021629_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.230139249644146_REALK, &
      0.000000000000000_REALK,     -0.200774255215413_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.228334442957612_REALK,      0.000000000000000_REALK, &
     -0.251215775506263_REALK,      0.000000000000000_REALK,     -0.340114949301887_REALK, &
      0.000000000000000_REALK,     -0.284702718669978_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.561121562705327_REALK, &
      0.000000000000000_REALK,     -0.644231760900834_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.849450200450151_REALK,      0.000000000000000_REALK, &
     -0.716864124248824_REALK,      0.000000000000000_REALK,     -1.348587942074701_REALK, &
      0.000000000000000_REALK,     -0.916990590349733_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.247373927318716_REALK, &
      0.000000000000000_REALK,     -0.104484854257497_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.070789437434579_REALK,      0.000000000000000_REALK, &
     -0.162229446256129_REALK,      0.000000000000000_REALK,     -0.059510709634625_REALK, &
      0.000000000000000_REALK,     -0.086123815320510_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.359503955890029_REALK, &
      0.000000000000000_REALK,     -0.128924298826679_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.056405968502465_REALK,      0.000000000000000_REALK, &
     -0.198749895767565_REALK,      0.000000000000000_REALK,      0.001769911557137_REALK, &
      0.000000000000000_REALK,     -0.090484503544881_REALK,      0.000000000000000_REALK, &
      0.279626208954554_REALK,      0.135222686206369_REALK,      0.000000000000000_REALK, &
      0.093736188923673_REALK,      0.000000000000000_REALK,      0.156804764523947_REALK, &
      0.079201466014759_REALK,      0.000000000000000_REALK,      0.088679925739554_REALK, &
      0.000000000000000_REALK,      0.086413576287438_REALK,      0.000000000000000_REALK, &
      0.077264004252861_REALK,      0.000000000000000_REALK,      0.180949426097079_REALK, &
      0.667714334351977_REALK,      0.318726288275769_REALK,      0.000000000000000_REALK, &
      0.234641577412065_REALK,      0.000000000000000_REALK,      0.294242145045914_REALK, &
      0.242600428544565_REALK,      0.000000000000000_REALK,      0.176206173910836_REALK, &
      0.000000000000000_REALK,      0.353081913206787_REALK,      0.000000000000000_REALK, &
      0.164681342744095_REALK,      0.000000000000000_REALK,      0.289116144297628_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.185707280937596_REALK, &
      0.000000000000000_REALK,     -0.115420939509251_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.096009586312837_REALK,      0.000000000000000_REALK, &
     -0.170503276356972_REALK,      0.000000000000000_REALK,     -0.099628306323343_REALK, &
      0.000000000000000_REALK,     -0.133193355617680_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.466221748245730_REALK, &
      0.000000000000000_REALK,     -0.237569395632088_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.126531174772442_REALK,      0.000000000000000_REALK, &
     -0.360847582593661_REALK,      0.000000000000000_REALK,     -0.018549662028111_REALK, &
      0.000000000000000_REALK,     -0.233430692457565_REALK,      0.000000000000000_REALK, &
      0.300007617152948_REALK,      0.224776052450882_REALK,      0.000000000000000_REALK, &
      0.214075129892606_REALK,      0.000000000000000_REALK,      0.235527540549626_REALK, &
      0.246540313649196_REALK,      0.000000000000000_REALK,      0.206373456096966_REALK, &
      0.000000000000000_REALK,      0.354608477798257_REALK,      0.000000000000000_REALK, &
      0.247038232628505_REALK,      0.000000000000000_REALK,      0.349449257395331_REALK, &
      1.799280308700708_REALK,      1.361395632886474_REALK,      0.000000000000000_REALK, &
      1.315352388308503_REALK,      0.000000000000000_REALK,      1.110046165653601_REALK, &
      1.549637144641131_REALK,      0.000000000000000_REALK,      1.053696711766708_REALK, &
      0.000000000000000_REALK,      2.225494713246019_REALK,      0.000000000000000_REALK, &
      1.292437597071928_REALK,      0.000000000000000_REALK,      1.402338882780909_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.349976841279529_REALK, &
      0.000000000000000_REALK,     -0.109889689225777_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.063773591795903_REALK,      0.000000000000000_REALK, &
     -0.191347977309439_REALK,      0.000000000000000_REALK,     -0.043416688554842_REALK, &
      0.000000000000000_REALK,     -0.073027326262180_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.385376777997648_REALK, &
      0.000000000000000_REALK,     -0.155401019265141_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.108894038148890_REALK,      0.000000000000000_REALK, &
     -0.257486508375097_REALK,      0.000000000000000_REALK,     -0.109000715101491_REALK, &
      0.000000000000000_REALK,     -0.106039049158693_REALK,      0.000000000000000_REALK, &
      0.387582075930800_REALK,      0.141658350952290_REALK,      0.000000000000000_REALK, &
      0.080694636917394_REALK,      0.000000000000000_REALK,      0.184929372761954_REALK, &
      0.053517845142957_REALK,      0.000000000000000_REALK,      0.077450950253195_REALK, &
      0.000000000000000_REALK,      0.044099320383379_REALK,      0.000000000000000_REALK, &
      0.053625718839437_REALK,      0.000000000000000_REALK,      0.172053054562388_REALK, &
      0.366447804305149_REALK,      0.176714817873654_REALK,      0.000000000000000_REALK, &
      0.081249937846109_REALK,      0.000000000000000_REALK,      0.286289148236672_REALK, &
     -0.002309506885026_REALK,      0.000000000000000_REALK,      0.118070636401205_REALK, &
      0.000000000000000_REALK,     -0.112159336580370_REALK,      0.000000000000000_REALK, &
      0.055441503499436_REALK,      0.000000000000000_REALK,      0.273492161697744_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.212592576424354_REALK, &
      0.000000000000000_REALK,     -0.101088448626648_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.069483342412095_REALK,      0.000000000000000_REALK, &
     -0.162727405269185_REALK,      0.000000000000000_REALK,     -0.059998153709074_REALK, &
      0.000000000000000_REALK,     -0.094049831605583_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.403313786041563_REALK, &
      0.000000000000000_REALK,     -0.253816059868389_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.214887966220159_REALK,      0.000000000000000_REALK, &
     -0.377259373856781_REALK,      0.000000000000000_REALK,     -0.238452292642230_REALK, &
      0.000000000000000_REALK,     -0.242470604682591_REALK,      0.000000000000000_REALK, &
      0.290963620303132_REALK,      0.156485263557433_REALK,      0.000000000000000_REALK, &
      0.109443710656177_REALK,      0.000000000000000_REALK,      0.194360917072794_REALK, &
      0.089595508143051_REALK,      0.000000000000000_REALK,      0.119780480249397_REALK, &
      0.000000000000000_REALK,      0.086514495866532_REALK,      0.000000000000000_REALK, &
      0.101823330927943_REALK,      0.000000000000000_REALK,      0.232493009732269_REALK, &
      0.475226859579306_REALK,      0.325633203853351_REALK,      0.000000000000000_REALK, &
      0.182261742131186_REALK,      0.000000000000000_REALK,      0.519782647759560_REALK, &
      0.024204922554501_REALK,      0.000000000000000_REALK,      0.304597023073326_REALK, &
      0.000000000000000_REALK,     -0.205348174715174_REALK,      0.000000000000000_REALK, &
      0.174114730360114_REALK,      0.000000000000000_REALK,      0.638419647418330_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.319323247710943_REALK, &
      0.000000000000000_REALK,     -0.235250225353504_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.222160917915014_REALK,      0.000000000000000_REALK, &
     -0.314258918393463_REALK,      0.000000000000000_REALK,     -0.261469264766788_REALK, &
      0.000000000000000_REALK,     -0.281404480676257_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.521525482628652_REALK, &
      0.000000000000000_REALK,     -1.517796690893676_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.686464793603429_REALK,      0.000000000000000_REALK, &
     -1.829871832782617_REALK,      0.000000000000000_REALK,     -2.132396653081351_REALK, &
      0.000000000000000_REALK,     -1.864223887483993_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.693607868191558_REALK, &
      0.000000000000000_REALK,     -0.149331777071747_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.073675981062182_REALK,      0.000000000000000_REALK, &
     -0.290342942537023_REALK,      0.000000000000000_REALK,     -0.037177147925899_REALK, &
      0.000000000000000_REALK,     -0.075081607139128_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.180110952211121_REALK, &
      0.000000000000000_REALK,     -0.394842913901699_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.116596157892819_REALK,      0.000000000000000_REALK, &
     -0.718670920093782_REALK,      0.000000000000000_REALK,      0.021674232322937_REALK, &
      0.000000000000000_REALK,     -0.149929058237979_REALK,      0.000000000000000_REALK, &
      0.818546192234397_REALK,      0.211158829451860_REALK,      0.000000000000000_REALK, &
      0.099250407186767_REALK,      0.000000000000000_REALK,      0.297793555726087_REALK, &
      0.052550615218615_REALK,      0.000000000000000_REALK,      0.088390686866883_REALK, &
      0.000000000000000_REALK,      0.037128636407464_REALK,      0.000000000000000_REALK, &
      0.049901502727146_REALK,      0.000000000000000_REALK,      0.209616110363350_REALK, &
      3.643405711020269_REALK,      0.939304004592062_REALK,      0.000000000000000_REALK, &
      0.452767805718007_REALK,      0.000000000000000_REALK,      1.070596732206613_REALK, &
      0.318288664308427_REALK,      0.000000000000000_REALK,      0.309640421072744_REALK, &
      0.000000000000000_REALK,      0.352516834187841_REALK,      0.000000000000000_REALK, &
      0.171924196488625_REALK,      0.000000000000000_REALK,      0.569135156857089_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.355351536243320_REALK, &
      0.000000000000000_REALK,     -0.120536387133922_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.064907403359269_REALK,      0.000000000000000_REALK, &
     -0.208249273918589_REALK,      0.000000000000000_REALK,     -0.041876595313922_REALK, &
      0.000000000000000_REALK,     -0.084845249812940_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.730442597362540_REALK, &
      0.000000000000000_REALK,     -0.490922954753582_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.161892535105442_REALK,      0.000000000000000_REALK, &
     -0.798613612438662_REALK,      0.000000000000000_REALK,      0.003646298018172_REALK, &
      0.000000000000000_REALK,     -0.260977363794628_REALK,      0.000000000000000_REALK, &
      0.497223882852483_REALK,      0.194246781781784_REALK,      0.000000000000000_REALK, &
      0.108136453238643_REALK,      0.000000000000000_REALK,      0.253251554108800_REALK, &
      0.072620459881692_REALK,      0.000000000000000_REALK,      0.113835869952116_REALK, &
      0.000000000000000_REALK,      0.060807649346401_REALK,      0.000000000000000_REALK, &
      0.076116968552610_REALK,      0.000000000000000_REALK,      0.229195428585191_REALK, &
      3.812984682242601_REALK,      1.534162662455814_REALK,      0.000000000000000_REALK, &
      0.893477316064602_REALK,      0.000000000000000_REALK,      1.568597342805265_REALK, &
      0.696295080777311_REALK,      0.000000000000000_REALK,      0.708028794367263_REALK, &
      0.000000000000000_REALK,      0.727404640749699_REALK,      0.000000000000000_REALK, &
      0.474977493512975_REALK,      0.000000000000000_REALK,      1.072125053650811_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.373474745714854_REALK, &
      0.000000000000000_REALK,     -0.186413546783213_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.123244744405438_REALK,      0.000000000000000_REALK, &
     -0.281404480676257_REALK,      0.000000000000000_REALK,     -0.098149257635491_REALK, &
      0.000000000000000_REALK,     -0.168706300340052_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.141767826664046_REALK, &
      0.000000000000000_REALK,     -1.266476366470874_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.508425517310982_REALK,      0.000000000000000_REALK, &
     -1.864223887483993_REALK,      0.000000000000000_REALK,     -0.053501336756260_REALK, &
      0.000000000000000_REALK,     -0.865627529319765_REALK,      0.000000000000000_REALK, &
      0.746851784678365_REALK,      0.452045706598285_REALK,      0.000000000000000_REALK, &
      0.345747525631252_REALK,      0.000000000000000_REALK,      0.489079017415918_REALK, &
      0.316476709339482_REALK,      0.000000000000000_REALK,      0.340605860949817_REALK, &
      0.000000000000000_REALK,      0.349344078320395_REALK,      0.000000000000000_REALK, &
      0.312905295283124_REALK,      0.000000000000000_REALK,      0.540982278551034_REALK, &
     14.384713738267688_REALK,      9.174151602445839_REALK,      0.000000000000000_REALK, &
      7.012109909786449_REALK,      0.000000000000000_REALK,      7.608378461834253_REALK, &
      6.226726878379328_REALK,      0.000000000000000_REALK,      5.443646223482668_REALK, &
      0.000000000000000_REALK,      6.418820026058301_REALK,      0.000000000000000_REALK, &
      4.792726921104118_REALK,      0.000000000000000_REALK,      6.355888253643176_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.401233794951732_REALK, &
      0.000000000000000_REALK,     -0.919427527835910_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.451092148838531_REALK,      0.000000000000000_REALK, &
     -1.016979906318321_REALK,      0.000000000000000_REALK,     -4.837789586425197_REALK, &
      0.000000000000000_REALK,     -5.734964356149797_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.372640649455491_REALK, &
      0.000000000000000_REALK,     -1.566128268309100_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.955486772886178_REALK,      0.000000000000000_REALK, &
     -1.580097690232702_REALK,      0.000000000000000_REALK,    -11.704732729216188_REALK, &
      0.000000000000000_REALK,    -11.649965360952828_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.538912181770250_REALK, &
      0.000000000000000_REALK,     -0.379030392856202_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.297179622333891_REALK,      0.000000000000000_REALK, &
     -1.163691100692325_REALK,      0.000000000000000_REALK,     -1.089987317936269_REALK, &
      0.000000000000000_REALK,     -2.030099482829131_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.597005779704164_REALK, &
      0.000000000000000_REALK,     -0.357299211890615_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.211086535593284_REALK,      0.000000000000000_REALK, &
     -1.400668903413870_REALK,      0.000000000000000_REALK,      0.061636835065003_REALK, &
      0.000000000000000_REALK,     -2.108341571161788_REALK,      0.000000000000000_REALK, &
      0.622228256527672_REALK,      0.253536365603071_REALK,      0.000000000000000_REALK, &
      0.529174784007438_REALK,      0.000000000000000_REALK,      1.193015936215147_REALK, &
      0.461823709395914_REALK,      0.000000000000000_REALK,      0.547469555030306_REALK, &
      0.000000000000000_REALK,      3.013409434139881_REALK,      0.000000000000000_REALK, &
      2.834277872136973_REALK,      0.000000000000000_REALK,      8.945766653732640_REALK, &
      1.273532643526513_REALK,      0.677597057658195_REALK,      0.000000000000000_REALK, &
      1.379977585717445_REALK,      0.000000000000000_REALK,      2.282082240844149_REALK, &
      1.597222170862796_REALK,      0.000000000000000_REALK,      1.589748642260840_REALK, &
      0.000000000000000_REALK,     10.361105020090474_REALK,      0.000000000000000_REALK, &
      8.142934589316377_REALK,      0.000000000000000_REALK,     18.852469235551116_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.684397159662685_REALK, &
      0.000000000000000_REALK,     -0.191744736232476_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.240232086824135_REALK,      0.000000000000000_REALK, &
     -1.287454651085959_REALK,      0.000000000000000_REALK,     -0.375876241399488_REALK, &
      0.000000000000000_REALK,     -0.823036964969121_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.623960491567285_REALK, &
      0.000000000000000_REALK,     -0.232713264693778_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.325469404195654_REALK,      0.000000000000000_REALK, &
     -1.583811403270873_REALK,      0.000000000000000_REALK,     -0.798499650045956_REALK, &
      0.000000000000000_REALK,     -1.101537338021264_REALK,      0.000000000000000_REALK, &
      0.560947747562515_REALK,      0.167204912005736_REALK,      0.000000000000000_REALK, &
      0.231195589924382_REALK,      0.000000000000000_REALK,      0.905311906655699_REALK, &
      0.168879485819812_REALK,      0.000000000000000_REALK,      0.314537748450478_REALK, &
      0.000000000000000_REALK,      0.598842038121476_REALK,      0.000000000000000_REALK, &
      0.992374134405991_REALK,      0.000000000000000_REALK,      5.440291348291835_REALK, &
      0.454243578441634_REALK,      0.190003275419086_REALK,      0.000000000000000_REALK, &
      0.191053361939282_REALK,      0.000000000000000_REALK,      1.267738381365247_REALK, &
     -0.014099600908961_REALK,      0.000000000000000_REALK,      0.482289116594033_REALK, &
      0.000000000000000_REALK,     -0.857141031603823_REALK,      0.000000000000000_REALK, &
      0.904342139703721_REALK,      0.000000000000000_REALK,      8.401092345361766_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.526285301643273_REALK, &
      0.000000000000000_REALK,     -0.425912603787692_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.439134824635592_REALK,      0.000000000000000_REALK, &
     -1.386031238975131_REALK,      0.000000000000000_REALK,     -1.542171365118088_REALK, &
      0.000000000000000_REALK,     -2.559436848758740_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.213557394212391_REALK, &
      0.000000000000000_REALK,     -1.438873502228277_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.862719392000750_REALK,      0.000000000000000_REALK, &
     -4.312555829471151_REALK,      0.000000000000000_REALK,     -6.842858600718072_REALK, &
      0.000000000000000_REALK,     -9.535176455331413_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.946938555561581_REALK, &
      0.000000000000000_REALK,     -0.070013697700128_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.231401267947132_REALK,      0.000000000000000_REALK, &
     -1.512901926409045_REALK,      0.000000000000000_REALK,     -0.066458450613736_REALK, &
      0.000000000000000_REALK,     -0.228670238539837_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.318305431421177_REALK, &
      0.000000000000000_REALK,     -0.054630968058490_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.208306931189868_REALK,      0.000000000000000_REALK, &
     -2.058350701916397_REALK,      0.000000000000000_REALK,      0.223131554367697_REALK, &
      0.000000000000000_REALK,     -0.166370742792325_REALK,      0.000000000000000_REALK, &
      0.690922842876072_REALK,      0.117947374121806_REALK,      0.000000000000000_REALK, &
      0.169775420644303_REALK,      0.000000000000000_REALK,      0.909862449426236_REALK, &
      0.086060286426932_REALK,      0.000000000000000_REALK,      0.188441803827433_REALK, &
      0.000000000000000_REALK,      0.291210824886597_REALK,      0.000000000000000_REALK, &
      0.554499865200853_REALK,      0.000000000000000_REALK,      4.160355162725566_REALK, &
      1.420545871042655_REALK,      0.264719649776340_REALK,      0.000000000000000_REALK, &
      0.330522531201913_REALK,      0.000000000000000_REALK,      1.608401119144371_REALK, &
      0.299616010889902_REALK,      0.000000000000000_REALK,      0.413322940148086_REALK, &
      0.000000000000000_REALK,      1.073383069896435_REALK,      0.000000000000000_REALK, &
      1.006558751929644_REALK,      0.000000000000000_REALK,      6.857415450866441_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.556881843274087_REALK, &
      0.000000000000000_REALK,     -0.222288284873389_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.227213089956620_REALK,      0.000000000000000_REALK, &
     -1.245604217858373_REALK,      0.000000000000000_REALK,     -0.389804931390485_REALK, &
      0.000000000000000_REALK,     -1.016415408911092_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.442097685169061_REALK, &
      0.000000000000000_REALK,     -0.489776972989963_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.339330623829419_REALK,      0.000000000000000_REALK, &
     -3.152289140627818_REALK,      0.000000000000000_REALK,      0.043604948762244_REALK, &
      0.000000000000000_REALK,     -2.088163295886450_REALK,      0.000000000000000_REALK, &
      0.531303398387097_REALK,      0.261990363903564_REALK,      0.000000000000000_REALK, &
      0.310342804567354_REALK,      0.000000000000000_REALK,      0.979527921244812_REALK, &
      0.353094169791962_REALK,      0.000000000000000_REALK,      0.586006360699235_REALK, &
      0.000000000000000_REALK,      1.077665619037064_REALK,      0.000000000000000_REALK, &
      1.419045582121471_REALK,      0.000000000000000_REALK,      5.758587296164656_REALK, &
      2.762857534924224_REALK,      1.636769997118730_REALK,      0.000000000000000_REALK, &
      1.891639338218311_REALK,      0.000000000000000_REALK,      4.379511100986618_REALK, &
      2.567602874857624_REALK,      0.000000000000000_REALK,      3.577824401692960_REALK, &
      0.000000000000000_REALK,      7.329958669110840_REALK,      0.000000000000000_REALK, &
      8.065001118791601_REALK,      0.000000000000000_REALK,     24.006906220020142_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.503774756504669_REALK, &
      0.000000000000000_REALK,      0.075335591464280_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.291835245041806_REALK,      0.000000000000000_REALK, &
     -1.975117741745136_REALK,      0.000000000000000_REALK,      0.109980130764170_REALK, &
      0.000000000000000_REALK,      0.180194151638173_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.828745768598852_REALK, &
      0.000000000000000_REALK,      0.124145531017137_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.443965138369407_REALK,      0.000000000000000_REALK, &
     -3.094105790801977_REALK,      0.000000000000000_REALK,     -0.004854624275693_REALK, &
      0.000000000000000_REALK,      0.294845629595972_REALK,      0.000000000000000_REALK, &
      1.068512565444825_REALK,      0.056753365505137_REALK,      0.000000000000000_REALK, &
      0.173489084255327_REALK,      0.000000000000000_REALK,      1.134271960172628_REALK, &
      0.021664186602503_REALK,      0.000000000000000_REALK,      0.074542133805658_REALK, &
      0.000000000000000_REALK,      0.178211928662072_REALK,      0.000000000000000_REALK, &
      0.414966123557878_REALK,      0.000000000000000_REALK,      3.798269018197849_REALK, &
      1.112797188283371_REALK,      0.053613950274529_REALK,      0.000000000000000_REALK, &
      0.207957654944500_REALK,      0.000000000000000_REALK,      2.054899386107031_REALK, &
     -0.121658838757892_REALK,      0.000000000000000_REALK,      0.090710932520319_REALK, &
      0.000000000000000_REALK,     -0.271819721599723_REALK,      0.000000000000000_REALK, &
      0.493899419488156_REALK,      0.000000000000000_REALK,      6.832540306563704_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.737537908265516_REALK, &
      0.000000000000000_REALK,     -0.141280971670875_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.180756373942474_REALK,      0.000000000000000_REALK, &
     -1.356196386548674_REALK,      0.000000000000000_REALK,     -0.154329765639070_REALK, &
      0.000000000000000_REALK,     -0.473099182912625_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.578458897725919_REALK, &
      0.000000000000000_REALK,     -0.412629905673262_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.548809733559951_REALK,      0.000000000000000_REALK, &
     -3.738893869121067_REALK,      0.000000000000000_REALK,     -0.710394863015855_REALK, &
      0.000000000000000_REALK,     -1.371994405792914_REALK,      0.000000000000000_REALK, &
      0.628377885251016_REALK,      0.180187716023267_REALK,      0.000000000000000_REALK, &
      0.170349070500354_REALK,      0.000000000000000_REALK,      0.933870142622527_REALK, &
      0.127068968569572_REALK,      0.000000000000000_REALK,      0.331332025964473_REALK, &
      0.000000000000000_REALK,      0.245876544508398_REALK,      0.000000000000000_REALK, &
      0.570437795766212_REALK,      0.000000000000000_REALK,      4.020679770009830_REALK, &
      1.217291692074803_REALK,      0.480659215984965_REALK,      0.000000000000000_REALK, &
      0.338761655117948_REALK,      0.000000000000000_REALK,      3.147003576153013_REALK, &
     -0.023774886727899_REALK,      0.000000000000000_REALK,      1.138536960558080_REALK, &
      0.000000000000000_REALK,     -0.762565876762027_REALK,      0.000000000000000_REALK, &
      1.126382478169205_REALK,      0.000000000000000_REALK,     13.453439988285536_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.794009000567219_REALK, &
      0.000000000000000_REALK,     -0.439348097732698_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.462581778609546_REALK,      0.000000000000000_REALK, &
     -1.877189561279475_REALK,      0.000000000000000_REALK,     -0.886472957840951_REALK, &
      0.000000000000000_REALK,     -1.891567069041823_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.297981506453590_REALK, &
      0.000000000000000_REALK,     -3.571825325875025_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.397310248089819_REALK,      0.000000000000000_REALK, &
    -13.089373850210077_REALK,      0.000000000000000_REALK,     -8.522964583916712_REALK, &
      0.000000000000000_REALK,    -15.269552927880639_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.030212035724624_REALK, &
      0.000000000000000_REALK,      0.391022727486866_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.484159860450395_REALK,      0.000000000000000_REALK, &
     -3.011349180939451_REALK,      0.000000000000000_REALK,      0.322922985170921_REALK, &
      0.000000000000000_REALK,      0.644971131614424_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -10.252449748521432_REALK, &
      0.000000000000000_REALK,      1.410621429900334_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.100229131222340_REALK,      0.000000000000000_REALK, &
     -8.040824100152721_REALK,      0.000000000000000_REALK,      0.917572917758735_REALK, &
      0.000000000000000_REALK,      1.612047352076327_REALK,      0.000000000000000_REALK, &
      2.299627410933764_REALK,     -0.085305071849978_REALK,      0.000000000000000_REALK, &
      0.266641505820210_REALK,      0.000000000000000_REALK,      1.804608517232704_REALK, &
     -0.051741199374828_REALK,      0.000000000000000_REALK,     -0.084774053834151_REALK, &
      0.000000000000000_REALK,      0.197705022313693_REALK,      0.000000000000000_REALK, &
      0.439810941040534_REALK,      0.000000000000000_REALK,      4.167247686459812_REALK, &
     10.861402956742134_REALK,     -0.426692253349428_REALK,      0.000000000000000_REALK, &
      0.984117485344059_REALK,      0.000000000000000_REALK,      6.858564664369952_REALK, &
      0.005509961941869_REALK,      0.000000000000000_REALK,     -0.334647566019561_REALK, &
      0.000000000000000_REALK,      0.925598033375242_REALK,      0.000000000000000_REALK, &
      1.124641915083476_REALK,      0.000000000000000_REALK,     10.973081140439096_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.284375010260852_REALK, &
      0.000000000000000_REALK,     -0.068107012921435_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.195224762724166_REALK,      0.000000000000000_REALK, &
     -1.786931813812992_REALK,      0.000000000000000_REALK,     -0.032649059558106_REALK, &
      0.000000000000000_REALK,     -0.157274438925825_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -7.062756446249599_REALK, &
      0.000000000000000_REALK,     -0.201074830183700_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.560572116387387_REALK,      0.000000000000000_REALK, &
     -7.754881720496510_REALK,      0.000000000000000_REALK,      0.308183272925502_REALK, &
      0.000000000000000_REALK,     -0.321701483455859_REALK,      0.000000000000000_REALK, &
      1.127869970628056_REALK,      0.159977285704767_REALK,      0.000000000000000_REALK, &
      0.165151922372220_REALK,      0.000000000000000_REALK,      1.239117799652554_REALK, &
      0.072605907248140_REALK,      0.000000000000000_REALK,      0.222574013842920_REALK, &
      0.000000000000000_REALK,      0.143063214352497_REALK,      0.000000000000000_REALK, &
      0.381373001317426_REALK,      0.000000000000000_REALK,      3.678945687498919_REALK, &
      9.374883285166437_REALK,      1.418222491043851_REALK,      0.000000000000000_REALK, &
      1.216521767693322_REALK,      0.000000000000000_REALK,      8.287837297229759_REALK, &
      0.806292812095672_REALK,      0.000000000000000_REALK,      1.557203303709152_REALK, &
      0.000000000000000_REALK,      1.482527688748071_REALK,      0.000000000000000_REALK, &
      1.946324445310964_REALK,      0.000000000000000_REALK,     17.048298427373751_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.057453164786481_REALK, &
      0.000000000000000_REALK,     -0.302728583440880_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.268367890787167_REALK,      0.000000000000000_REALK, &
     -1.891567069041823_REALK,      0.000000000000000_REALK,     -0.268099391798543_REALK, &
      0.000000000000000_REALK,     -0.898802371206974_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -10.816354291658515_REALK, &
      0.000000000000000_REALK,     -2.523743496417046_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.278435618133222_REALK,      0.000000000000000_REALK, &
    -15.269552927880639_REALK,      0.000000000000000_REALK,      0.084316367573961_REALK, &
      0.000000000000000_REALK,     -5.191406483744910_REALK,      0.000000000000000_REALK, &
      1.214227632386002_REALK,      0.497488906847032_REALK,      0.000000000000000_REALK, &
      0.422647723703733_REALK,      0.000000000000000_REALK,      1.715134343207369_REALK, &
      0.417049640997384_REALK,      0.000000000000000_REALK,      0.889905732700201_REALK, &
      0.000000000000000_REALK,      0.741195079280849_REALK,      0.000000000000000_REALK, &
      1.254842776761882_REALK,      0.000000000000000_REALK,      6.223849748329593_REALK, &
     25.526844596876316_REALK,     12.276480549733076_REALK,      0.000000000000000_REALK, &
      9.747319169071972_REALK,      0.000000000000000_REALK,     29.014624268716368_REALK, &
      9.673500526994456_REALK,      0.000000000000000_REALK,     17.330827418145066_REALK, &
      0.000000000000000_REALK,     14.173517157800873_REALK,      0.000000000000000_REALK, &
     20.050490870126566_REALK,      0.000000000000000_REALK,     72.946918224397464_REALK/
    ! results of test 3, ket-major order, 1DOVL001
  data REF_CONTR_INTS(13861:15120)                                                         &
    /21.578818408654001_REALK,      9.032095652812361_REALK,      0.000000000000000_REALK, &
     -4.187608634636775_REALK,      0.000000000000000_REALK,     -0.658178251315764_REALK, &
    -28.782908284490571_REALK,      0.000000000000000_REALK,     -3.441933909463378_REALK, &
      0.000000000000000_REALK,   -136.359522158011004_REALK,      0.000000000000000_REALK, &
    -13.570707440151212_REALK,      0.000000000000000_REALK,     -6.398839006729168_REALK, &
     64.808457510703192_REALK,     45.480441173591899_REALK,      0.000000000000000_REALK, &
     32.960848851312441_REALK,      0.000000000000000_REALK,      3.973738380387094_REALK, &
     10.655557405207052_REALK,      0.000000000000000_REALK,      1.035055744568994_REALK, &
      0.000000000000000_REALK,   -105.269570561925377_REALK,      0.000000000000000_REALK, &
     -8.733490003821924_REALK,      0.000000000000000_REALK,     -3.158711528893073_REALK, &
      8.508323327151508_REALK,      0.220472395407811_REALK,      0.000000000000000_REALK, &
     -5.300880331640139_REALK,      0.000000000000000_REALK,     -1.344832172987215_REALK, &
    -11.992504208685881_REALK,      0.000000000000000_REALK,     -2.290401675073462_REALK, &
      0.000000000000000_REALK,    -29.572719588095826_REALK,      0.000000000000000_REALK, &
     -4.972234971224447_REALK,      0.000000000000000_REALK,     -3.784364752233052_REALK, &
     10.098804464972780_REALK,      5.498957920893442_REALK,      0.000000000000000_REALK, &
      1.764399924760265_REALK,      0.000000000000000_REALK,      0.718828438607779_REALK, &
     -0.102552090883603_REALK,      0.000000000000000_REALK,     -0.184360737382806_REALK, &
      0.000000000000000_REALK,      8.303477408882667_REALK,      0.000000000000000_REALK, &
     -1.005788431633407_REALK,      0.000000000000000_REALK,     -1.229294987607263_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.064270735907159_REALK, &
      0.000000000000000_REALK,      1.627755602940450_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.248085643578535_REALK,      0.000000000000000_REALK, &
      2.003050779772291_REALK,      0.000000000000000_REALK,     12.768062194840100_REALK, &
      0.000000000000000_REALK,      4.580512760439631_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.670564876385116_REALK, &
      0.000000000000000_REALK,     -2.099022408966304_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.020751581160469_REALK,      0.000000000000000_REALK, &
      0.369183429091510_REALK,      0.000000000000000_REALK,     12.317969197018224_REALK, &
      0.000000000000000_REALK,      3.589615529423321_REALK,      0.000000000000000_REALK, &
      1.369876512200395_REALK,     -3.456468018839264_REALK,      0.000000000000000_REALK, &
     -6.006565788410715_REALK,      0.000000000000000_REALK,     -2.009593402215801_REALK, &
     -8.983417083846371_REALK,      0.000000000000000_REALK,     -2.011702055450537_REALK, &
      0.000000000000000_REALK,    -16.862466066519488_REALK,      0.000000000000000_REALK, &
     -3.015409628560151_REALK,      0.000000000000000_REALK,     -3.026561686658477_REALK, &
     26.952817417941258_REALK,      9.555765959400826_REALK,      0.000000000000000_REALK, &
      3.287746977763454_REALK,      0.000000000000000_REALK,      0.824571445329534_REALK, &
     -1.935969132495210_REALK,      0.000000000000000_REALK,     -0.281227626589949_REALK, &
      0.000000000000000_REALK,    -14.928644872839630_REALK,      0.000000000000000_REALK, &
     -1.392577297817659_REALK,      0.000000000000000_REALK,     -1.047780881218305_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.949384005649439_REALK, &
      0.000000000000000_REALK,      1.479222644921078_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.177975235294354_REALK,      0.000000000000000_REALK, &
      1.657655512940236_REALK,      0.000000000000000_REALK,      3.888229157543608_REALK, &
      0.000000000000000_REALK,      2.227793233307496_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.795568533439717_REALK, &
      0.000000000000000_REALK,     -0.665754186545394_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.201945602592212_REALK,      0.000000000000000_REALK, &
      0.246822004735901_REALK,      0.000000000000000_REALK,      0.156859531214041_REALK, &
      0.000000000000000_REALK,      0.845972186163362_REALK,      0.000000000000000_REALK, &
      0.293944827100113_REALK,     -1.149113744881096_REALK,      0.000000000000000_REALK, &
     -2.743564393063916_REALK,      0.000000000000000_REALK,     -1.293641244071724_REALK, &
     -5.592761288232476_REALK,      0.000000000000000_REALK,     -2.006390167585056_REALK, &
      0.000000000000000_REALK,    -13.839430516990362_REALK,      0.000000000000000_REALK, &
     -4.131963643875451_REALK,      0.000000000000000_REALK,     -3.247161856449543_REALK, &
     14.525874659010467_REALK,      8.163228779395611_REALK,      0.000000000000000_REALK, &
      3.686086572594665_REALK,      0.000000000000000_REALK,      1.333176559228605_REALK, &
     -2.473243511226650_REALK,      0.000000000000000_REALK,     -0.720735145050835_REALK, &
      0.000000000000000_REALK,    -18.819213897809604_REALK,      0.000000000000000_REALK, &
     -4.683901024169830_REALK,      0.000000000000000_REALK,     -2.823440220493131_REALK, &
     -9.464638014202675_REALK,     -7.201453989309058_REALK,      0.000000000000000_REALK, &
     -6.839419708690412_REALK,      0.000000000000000_REALK,     -3.134804604371979_REALK, &
     -6.920217000664946_REALK,      0.000000000000000_REALK,     -2.002985662924623_REALK, &
      0.000000000000000_REALK,     -8.778717002774494_REALK,      0.000000000000000_REALK, &
     -2.135021608810140_REALK,      0.000000000000000_REALK,     -2.935720801529766_REALK, &
      4.187306267328455_REALK,      0.490327132926316_REALK,      0.000000000000000_REALK, &
     -0.624127389316744_REALK,      0.000000000000000_REALK,     -0.439830240897166_REALK, &
      0.052115780614889_REALK,      0.000000000000000_REALK,     -0.532870754674208_REALK, &
      0.000000000000000_REALK,      5.243412599072212_REALK,      0.000000000000000_REALK, &
     -0.518374460519636_REALK,      0.000000000000000_REALK,     -1.095914557258352_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.161504277434768_REALK, &
      0.000000000000000_REALK,      1.713586811390694_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.796932616172347_REALK,      0.000000000000000_REALK, &
      1.803578312579406_REALK,      0.000000000000000_REALK,      2.388729837657292_REALK, &
      0.000000000000000_REALK,      1.604761087951301_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.223813367502444_REALK, &
      0.000000000000000_REALK,      0.389941356293375_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.969822101585396_REALK,      0.000000000000000_REALK, &
      0.729698134399135_REALK,      0.000000000000000_REALK,      2.229513464751976_REALK, &
      0.000000000000000_REALK,      0.971607609261430_REALK,      0.000000000000000_REALK, &
     -1.421048862931805_REALK,     -1.591041287630547_REALK,      0.000000000000000_REALK, &
     -1.855219876434487_REALK,      0.000000000000000_REALK,     -1.412006622505192_REALK, &
     -2.317060251505085_REALK,      0.000000000000000_REALK,     -1.327578941548252_REALK, &
      0.000000000000000_REALK,     -3.444435284931249_REALK,      0.000000000000000_REALK, &
     -1.737399382106410_REALK,      0.000000000000000_REALK,     -2.203889203495630_REALK, &
      1.086059397349913_REALK,      0.180705610488399_REALK,      0.000000000000000_REALK, &
     -0.280011402603447_REALK,      0.000000000000000_REALK,     -0.342235606283805_REALK, &
     -0.109240499937850_REALK,      0.000000000000000_REALK,     -0.589154027394729_REALK, &
      0.000000000000000_REALK,      1.919992110021930_REALK,      0.000000000000000_REALK, &
     -0.697697756492359_REALK,      0.000000000000000_REALK,     -1.421233876406156_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.391431261390454_REALK, &
      0.000000000000000_REALK,      1.709062095136012_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.462305674888850_REALK,      0.000000000000000_REALK, &
      1.935037612992931_REALK,      0.000000000000000_REALK,      4.461418958756212_REALK, &
      0.000000000000000_REALK,      2.667539542336693_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.361864016618995_REALK, &
      0.000000000000000_REALK,      0.999348618047431_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.261973853801230_REALK,      0.000000000000000_REALK, &
      1.966307172054675_REALK,      0.000000000000000_REALK,      8.544758721617551_REALK, &
      0.000000000000000_REALK,      4.150088664739545_REALK,      0.000000000000000_REALK, &
    -29.453493680452237_REALK,    -12.753584720675677_REALK,      0.000000000000000_REALK, &
     -9.086786158663662_REALK,      0.000000000000000_REALK,     -5.452846868867733_REALK, &
     -6.957783297081264_REALK,      0.000000000000000_REALK,     -2.340612920101810_REALK, &
      0.000000000000000_REALK,     -7.155501404700518_REALK,      0.000000000000000_REALK, &
     -1.923422497622227_REALK,      0.000000000000000_REALK,     -3.462652744502863_REALK, &
     45.648056370814068_REALK,      7.655174867030909_REALK,      0.000000000000000_REALK, &
      0.356949419183347_REALK,      0.000000000000000_REALK,      0.168805677839537_REALK, &
     -3.413349996667938_REALK,      0.000000000000000_REALK,     -0.664121125729280_REALK, &
      0.000000000000000_REALK,    -10.259719829601947_REALK,      0.000000000000000_REALK, &
     -1.000743179806741_REALK,      0.000000000000000_REALK,     -1.419790494662208_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.292509041526632_REALK, &
      0.000000000000000_REALK,      2.207121170118241_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.718768258264154_REALK,      0.000000000000000_REALK, &
      2.363359559441288_REALK,      0.000000000000000_REALK,      1.614107414580956_REALK, &
      0.000000000000000_REALK,      1.401560388719890_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.820565145130512_REALK, &
      0.000000000000000_REALK,     -0.077405973370909_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.347229383970300_REALK,      0.000000000000000_REALK, &
      0.734090441530322_REALK,      0.000000000000000_REALK,     -0.021224516081830_REALK, &
      0.000000000000000_REALK,      0.651046023028685_REALK,      0.000000000000000_REALK, &
     -3.578290542501679_REALK,     -2.346425953016919_REALK,      0.000000000000000_REALK, &
     -1.980068101255898_REALK,      0.000000000000000_REALK,     -1.987391097871250_REALK, &
     -1.923012397435151_REALK,      0.000000000000000_REALK,     -1.291889697362508_REALK, &
      0.000000000000000_REALK,     -2.343793160296257_REALK,      0.000000000000000_REALK, &
     -1.257377734970209_REALK,      0.000000000000000_REALK,     -2.103379942299570_REALK, &
      9.554540642541825_REALK,      2.500635235909484_REALK,      0.000000000000000_REALK, &
      0.140878483405858_REALK,      0.000000000000000_REALK,      0.105997549808554_REALK, &
     -1.493423472567074_REALK,      0.000000000000000_REALK,     -0.650824331288449_REALK, &
      0.000000000000000_REALK,     -4.234105774856399_REALK,      0.000000000000000_REALK, &
     -1.184900497435862_REALK,      0.000000000000000_REALK,     -1.485873338718749_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.933470170787017_REALK, &
      0.000000000000000_REALK,      1.462879960216960_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.398668237159656_REALK,      0.000000000000000_REALK, &
      1.774209119040448_REALK,      0.000000000000000_REALK,      1.621329561613085_REALK, &
      0.000000000000000_REALK,      1.548257094241892_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.194705440302818_REALK, &
      0.000000000000000_REALK,     -0.085581804885805_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.467347797075982_REALK,      0.000000000000000_REALK, &
      0.952003235050462_REALK,      0.000000000000000_REALK,      0.133466872434545_REALK, &
      0.000000000000000_REALK,      1.199685486965720_REALK,      0.000000000000000_REALK, &
     -2.303463090567446_REALK,     -2.340230228598728_REALK,      0.000000000000000_REALK, &
     -2.713253061639104_REALK,      0.000000000000000_REALK,     -2.132248153177364_REALK, &
     -3.591600788247569_REALK,      0.000000000000000_REALK,     -2.147464116575372_REALK, &
      0.000000000000000_REALK,     -5.770821858468377_REALK,      0.000000000000000_REALK, &
     -2.871604926854870_REALK,      0.000000000000000_REALK,     -3.159367677093602_REALK, &
     15.447890769177887_REALK,      6.408672296268860_REALK,      0.000000000000000_REALK, &
      0.473841469153831_REALK,      0.000000000000000_REALK,      0.285630088091711_REALK, &
     -5.723644841815511_REALK,      0.000000000000000_REALK,     -2.779906882439962_REALK, &
      0.000000000000000_REALK,    -16.012680907416499_REALK,      0.000000000000000_REALK, &
     -6.642308308698128_REALK,      0.000000000000000_REALK,     -5.605546418356514_REALK, &
   -138.084338924072114_REALK,    -32.033262444902739_REALK,      0.000000000000000_REALK, &
    -16.718653264862141_REALK,      0.000000000000000_REALK,    -13.177002638293777_REALK, &
     -8.672179326534662_REALK,      0.000000000000000_REALK,     -3.502803187230817_REALK, &
      0.000000000000000_REALK,     -6.507102555710486_REALK,      0.000000000000000_REALK, &
     -2.222080261104156_REALK,      0.000000000000000_REALK,     -5.254075851541640_REALK, &
    -61.946088390955737_REALK,    -19.070599296124005_REALK,      0.000000000000000_REALK, &
     -7.851647939885066_REALK,      0.000000000000000_REALK,     -9.679137205184293_REALK, &
      1.842006629130886_REALK,      0.000000000000000_REALK,     -2.548374632687145_REALK, &
      0.000000000000000_REALK,     13.287474007284651_REALK,      0.000000000000000_REALK, &
     -1.071526153189115_REALK,      0.000000000000000_REALK,     -3.962779050360447_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     12.775980185906937_REALK, &
      0.000000000000000_REALK,      4.011546841359845_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.328068743605272_REALK,      0.000000000000000_REALK, &
      4.191119545706496_REALK,      0.000000000000000_REALK,      1.584935593699231_REALK, &
      0.000000000000000_REALK,      1.599526991462002_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     10.341794454862704_REALK, &
      0.000000000000000_REALK,      4.170270475731821_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.922230461698117_REALK,      0.000000000000000_REALK, &
      4.145873902965362_REALK,      0.000000000000000_REALK,      2.925093195468961_REALK, &
      0.000000000000000_REALK,      1.707369171987277_REALK,      0.000000000000000_REALK, &
    -14.148767399582258_REALK,     -5.171268699717150_REALK,      0.000000000000000_REALK, &
     -2.945775150711046_REALK,      0.000000000000000_REALK,     -4.050532018451777_REALK, &
     -1.953680496798206_REALK,      0.000000000000000_REALK,     -1.696418201038892_REALK, &
      0.000000000000000_REALK,     -1.609855216048441_REALK,      0.000000000000000_REALK, &
     -1.174571069633361_REALK,      0.000000000000000_REALK,     -2.691785965825606_REALK, &
     -9.833825198940085_REALK,     -4.742237799260907_REALK,      0.000000000000000_REALK, &
     -2.180386065400012_REALK,      0.000000000000000_REALK,     -4.609634562474008_REALK, &
      0.061976867472734_REALK,      0.000000000000000_REALK,     -1.901093666038511_REALK, &
      0.000000000000000_REALK,      3.009856512721772_REALK,      0.000000000000000_REALK, &
     -0.892681655244755_REALK,      0.000000000000000_REALK,     -3.145418661249644_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.656442753420520_REALK, &
      0.000000000000000_REALK,      2.214153391332418_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.521902653893294_REALK,      0.000000000000000_REALK, &
      2.545885319344774_REALK,      0.000000000000000_REALK,      1.314147336450567_REALK, &
      0.000000000000000_REALK,      1.471418321796615_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.493886265372918_REALK, &
      0.000000000000000_REALK,      4.086774819397171_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.459980939722214_REALK,      0.000000000000000_REALK, &
      4.338839794509047_REALK,      0.000000000000000_REALK,      3.839397813137192_REALK, &
      0.000000000000000_REALK,      2.788641400319136_REALK,      0.000000000000000_REALK, &
     -6.373013884384700_REALK,     -3.427517008188618_REALK,      0.000000000000000_REALK, &
     -2.397159778407148_REALK,      0.000000000000000_REALK,     -3.040794539871617_REALK, &
     -1.962422026435094_REALK,      0.000000000000000_REALK,     -1.873976701751987_REALK, &
      0.000000000000000_REALK,     -1.894938215243311_REALK,      0.000000000000000_REALK, &
     -1.593035438298881_REALK,      0.000000000000000_REALK,     -2.829069179588857_REALK, &
     -7.651782019770401_REALK,     -5.243125980907410_REALK,      0.000000000000000_REALK, &
     -2.934655508668070_REALK,      0.000000000000000_REALK,     -5.977992312129044_REALK, &
     -0.389731319808868_REALK,      0.000000000000000_REALK,     -3.503154001154802_REALK, &
      0.000000000000000_REALK,      3.306377658176163_REALK,      0.000000000000000_REALK, &
     -2.002484161423298_REALK,      0.000000000000000_REALK,     -5.710778945435564_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.995841770646915_REALK, &
      0.000000000000000_REALK,      3.680511553105002_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.475728126533934_REALK,      0.000000000000000_REALK, &
      3.824029898626579_REALK,      0.000000000000000_REALK,      4.090710851859765_REALK, &
      0.000000000000000_REALK,      3.424243783484856_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     17.498982848057629_REALK, &
      0.000000000000000_REALK,     17.456098214603056_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     19.395941003981260_REALK,      0.000000000000000_REALK, &
     16.368533734446775_REALK,      0.000000000000000_REALK,     24.524579366925529_REALK, &
      0.000000000000000_REALK,     16.675819062388008_REALK,      0.000000000000000_REALK, &
     22.592722061535262_REALK,     38.809554618550386_REALK,      0.000000000000000_REALK, &
      8.763371249755906_REALK,      0.000000000000000_REALK,      3.951375565084180_REALK, &
     64.923703440059583_REALK,      0.000000000000000_REALK,     15.392778807195397_REALK, &
      0.000000000000000_REALK,    -48.113979618687054_REALK,      0.000000000000000_REALK, &
     -9.050770614091331_REALK,      0.000000000000000_REALK,    -12.242889008279279_REALK, &
     25.573011644088101_REALK,     38.774142367498897_REALK,      0.000000000000000_REALK, &
     14.781545942541815_REALK,      0.000000000000000_REALK,      4.888877013195698_REALK, &
     85.699483336386422_REALK,      0.000000000000000_REALK,     17.059697737964736_REALK, &
      0.000000000000000_REALK,    -30.425795593312781_REALK,      0.000000000000000_REALK, &
     -4.782410039544084_REALK,      0.000000000000000_REALK,     -4.745230559960544_REALK, &
     23.630258070772019_REALK,     13.716096563614354_REALK,      0.000000000000000_REALK, &
      3.728979751139395_REALK,      0.000000000000000_REALK,      2.920375574195569_REALK, &
     11.742531315092291_REALK,      0.000000000000000_REALK,      4.374088827933973_REALK, &
      0.000000000000000_REALK,    -17.990621398365384_REALK,      0.000000000000000_REALK, &
     -5.962649981498847_REALK,      0.000000000000000_REALK,    -14.009068318051016_REALK, &
      7.983155504234931_REALK,      6.464357313669902_REALK,      0.000000000000000_REALK, &
      2.259752572980420_REALK,      0.000000000000000_REALK,      2.998926624559054_REALK, &
     -0.397245417677865_REALK,      0.000000000000000_REALK,      2.717625027827931_REALK, &
      0.000000000000000_REALK,      5.006937656168573_REALK,      0.000000000000000_REALK, &
     -1.056532016643789_REALK,      0.000000000000000_REALK,     -4.206383520430999_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.634411430571372_REALK, &
      0.000000000000000_REALK,     -1.373918486765968_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.106786037154156_REALK,      0.000000000000000_REALK, &
     -8.260589825775199_REALK,      0.000000000000000_REALK,      9.266090018754426_REALK, &
      0.000000000000000_REALK,      6.590699536938661_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.257614085369646_REALK, &
      0.000000000000000_REALK,     -3.403759102534973_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -10.496137410835974_REALK,      0.000000000000000_REALK, &
    -10.414538191332534_REALK,      0.000000000000000_REALK,      7.994429187379834_REALK, &
      0.000000000000000_REALK,      4.774213573339858_REALK,      0.000000000000000_REALK, &
     22.963938133244866_REALK,      5.052467687275590_REALK,      0.000000000000000_REALK, &
      1.363940221900322_REALK,      0.000000000000000_REALK,      1.461928925234951_REALK, &
      2.304710481094863_REALK,      0.000000000000000_REALK,      1.009301312809935_REALK, &
      0.000000000000000_REALK,    -12.656900838845139_REALK,      0.000000000000000_REALK, &
     -4.820047339746552_REALK,      0.000000000000000_REALK,    -15.498992948150407_REALK, &
     26.941104735571443_REALK,      5.373618970688037_REALK,      0.000000000000000_REALK, &
      3.747086925768969_REALK,      0.000000000000000_REALK,      3.646842944728830_REALK, &
      4.311118477504801_REALK,      0.000000000000000_REALK,      1.189445223008329_REALK, &
      0.000000000000000_REALK,     -8.685961798304916_REALK,      0.000000000000000_REALK, &
     -1.629042065635323_REALK,      0.000000000000000_REALK,     -4.756383303685560_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.770987976158125_REALK, &
      0.000000000000000_REALK,     -0.357163518070453_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.216961763913202_REALK,      0.000000000000000_REALK, &
     -2.859215373032915_REALK,      0.000000000000000_REALK,      3.388419620062888_REALK, &
      0.000000000000000_REALK,      3.786555387445317_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.854709678829733_REALK, &
      0.000000000000000_REALK,     -1.110506376288316_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.976512916001543_REALK,      0.000000000000000_REALK, &
     -3.887802520557017_REALK,      0.000000000000000_REALK,     -0.070571435266337_REALK, &
      0.000000000000000_REALK,      1.448374406813633_REALK,      0.000000000000000_REALK, &
      3.531745547666734_REALK,      2.244556706507651_REALK,      0.000000000000000_REALK, &
      0.498645837095109_REALK,      0.000000000000000_REALK,      0.674513353425524_REALK, &
      1.891185511272843_REALK,      0.000000000000000_REALK,      1.345145087969533_REALK, &
      0.000000000000000_REALK,     -9.367719680679068_REALK,      0.000000000000000_REALK, &
     -5.286514398447639_REALK,      0.000000000000000_REALK,    -11.918360653198119_REALK, &
     10.479694564628556_REALK,      6.645051332306746_REALK,      0.000000000000000_REALK, &
      4.289049225620284_REALK,      0.000000000000000_REALK,      4.255705238635021_REALK, &
      7.388951053594198_REALK,      0.000000000000000_REALK,      4.412626541054531_REALK, &
      0.000000000000000_REALK,    -11.863004507643980_REALK,      0.000000000000000_REALK, &
     -5.593978801558374_REALK,      0.000000000000000_REALK,     -9.250816687763846_REALK, &
     18.030917141007329_REALK,      0.863262874057076_REALK,      0.000000000000000_REALK, &
     -0.875759042581793_REALK,      0.000000000000000_REALK,     -1.145142854528215_REALK, &
     -0.080576994101268_REALK,      0.000000000000000_REALK,     -0.055449864665222_REALK, &
      0.000000000000000_REALK,     -9.969655575544655_REALK,      0.000000000000000_REALK, &
     -4.642864659453556_REALK,      0.000000000000000_REALK,    -18.213034741750590_REALK, &
     11.987955223356387_REALK,      0.543859594964662_REALK,      0.000000000000000_REALK, &
      1.113153320074508_REALK,      0.000000000000000_REALK,      2.199888313488222_REALK, &
     -0.550757751676060_REALK,      0.000000000000000_REALK,      0.082130899419076_REALK, &
      0.000000000000000_REALK,      2.869051228409991_REALK,      0.000000000000000_REALK, &
     -1.042619518446977_REALK,      0.000000000000000_REALK,     -6.181484040022538_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.243705157389139_REALK, &
      0.000000000000000_REALK,      0.142635012475388_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.134459747270149_REALK,      0.000000000000000_REALK, &
      0.432358964105050_REALK,      0.000000000000000_REALK,      1.726724602586625_REALK, &
      0.000000000000000_REALK,      2.268552283526704_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.202375547370996_REALK, &
      0.000000000000000_REALK,     -0.441744113324230_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.496899720627670_REALK,      0.000000000000000_REALK, &
     -1.450819217413965_REALK,      0.000000000000000_REALK,      1.499640454634223_REALK, &
      0.000000000000000_REALK,      1.241260371967633_REALK,      0.000000000000000_REALK, &
      2.120748028355787_REALK,      0.548159088785479_REALK,      0.000000000000000_REALK, &
     -0.171981700781278_REALK,      0.000000000000000_REALK,     -0.404065877281951_REALK, &
     -0.094523147522204_REALK,      0.000000000000000_REALK,     -0.105629518660929_REALK, &
      0.000000000000000_REALK,     -2.750999308808342_REALK,      0.000000000000000_REALK, &
     -2.735299512099085_REALK,      0.000000000000000_REALK,    -10.710841056192979_REALK, &
      2.622730979553922_REALK,      0.975160849678354_REALK,      0.000000000000000_REALK, &
      0.362663890597457_REALK,      0.000000000000000_REALK,      1.443878073577452_REALK, &
     -0.021526102491688_REALK,      0.000000000000000_REALK,      0.441791438841256_REALK, &
      0.000000000000000_REALK,      1.609773236902514_REALK,      0.000000000000000_REALK, &
     -1.019052211821600_REALK,      0.000000000000000_REALK,     -6.761941210707204_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.035213862784380_REALK, &
      0.000000000000000_REALK,      0.190096638108576_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.147472283953263_REALK,      0.000000000000000_REALK, &
      0.332473863501052_REALK,      0.000000000000000_REALK,      4.250715971255789_REALK, &
      0.000000000000000_REALK,      5.039017127092977_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.737031344528276_REALK, &
      0.000000000000000_REALK,     -1.638790724535493_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.706307382926547_REALK,      0.000000000000000_REALK, &
     -2.821736973338946_REALK,      0.000000000000000_REALK,      7.710831870036225_REALK, &
      0.000000000000000_REALK,      7.674752279120920_REALK,      0.000000000000000_REALK, &
      1.359446316058182_REALK,      0.451568229273068_REALK,      0.000000000000000_REALK, &
     -5.070083304173500_REALK,      0.000000000000000_REALK,     -6.862784160812630_REALK, &
      1.367996282162825_REALK,      0.000000000000000_REALK,      0.448271751989611_REALK, &
      0.000000000000000_REALK,    -13.160721763372875_REALK,      0.000000000000000_REALK, &
     -5.855419711430151_REALK,      0.000000000000000_REALK,    -23.777409111267200_REALK, &
     69.318115933764943_REALK,     -2.297412483287417_REALK,      0.000000000000000_REALK, &
      2.921613659487305_REALK,      0.000000000000000_REALK,      4.072293502821906_REALK, &
      0.000722373425234_REALK,      0.000000000000000_REALK,     -0.008774670716862_REALK, &
      0.000000000000000_REALK,     -9.144272535269410_REALK,      0.000000000000000_REALK, &
     -2.222137862287664_REALK,      0.000000000000000_REALK,     -9.291985834181029_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.359785383279578_REALK, &
      0.000000000000000_REALK,      0.259005609833998_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.032317583742385_REALK,      0.000000000000000_REALK, &
      4.049576586071097_REALK,      0.000000000000000_REALK,      0.434673013008501_REALK, &
      0.000000000000000_REALK,      0.897373748441914_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -7.605511793880448_REALK, &
      0.000000000000000_REALK,     -0.119388788268182_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.014698555237859_REALK,      0.000000000000000_REALK, &
     -0.087144814581598_REALK,      0.000000000000000_REALK,     -0.608927793021711_REALK, &
      0.000000000000000_REALK,      0.272416251082898_REALK,      0.000000000000000_REALK, &
      0.133350182666363_REALK,     -0.169370139577773_REALK,      0.000000000000000_REALK, &
     -0.628059762635864_REALK,      0.000000000000000_REALK,     -2.019543200715146_REALK, &
     -0.383928522642000_REALK,      0.000000000000000_REALK,     -0.504401179809360_REALK, &
      0.000000000000000_REALK,     -1.904671046423478_REALK,      0.000000000000000_REALK, &
     -2.176031414158594_REALK,      0.000000000000000_REALK,    -11.661813382650031_REALK, &
     11.966211897576148_REALK,      1.527209378387692_REALK,      0.000000000000000_REALK, &
      0.722313477097475_REALK,      0.000000000000000_REALK,      2.108969335395040_REALK, &
      0.021141507203129_REALK,      0.000000000000000_REALK,      0.017498937837945_REALK, &
      0.000000000000000_REALK,     -2.929270966050010_REALK,      0.000000000000000_REALK, &
     -1.648144121335280_REALK,      0.000000000000000_REALK,     -8.020260644946735_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.479802909861757_REALK, &
      0.000000000000000_REALK,      0.493394132923912_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.608180076365652_REALK,      0.000000000000000_REALK, &
      2.381501587918186_REALK,      0.000000000000000_REALK,      1.529716830124717_REALK, &
      0.000000000000000_REALK,      2.849094934050218_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.991813288969264_REALK, &
      0.000000000000000_REALK,     -0.642205855817811_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.014366310011186_REALK,      0.000000000000000_REALK, &
     -0.095327935687204_REALK,      0.000000000000000_REALK,     -0.071398951949744_REALK, &
      0.000000000000000_REALK,      2.442263272834707_REALK,      0.000000000000000_REALK, &
      0.061525890443504_REALK,     -0.225727845996231_REALK,      0.000000000000000_REALK, &
     -0.688841155330787_REALK,      0.000000000000000_REALK,     -1.552981171186969_REALK, &
     -0.945125297091559_REALK,      0.000000000000000_REALK,     -1.120400090596083_REALK, &
      0.000000000000000_REALK,     -4.229097946009224_REALK,      0.000000000000000_REALK, &
     -3.977700007066967_REALK,      0.000000000000000_REALK,    -12.554723879258407_REALK, &
     13.964042716108288_REALK,      5.665670437329368_REALK,      0.000000000000000_REALK, &
      2.480357238281239_REALK,      0.000000000000000_REALK,      4.101790683424793_REALK, &
      0.108705127964989_REALK,      0.000000000000000_REALK,      0.108196488091435_REALK, &
      0.000000000000000_REALK,    -12.002109431730441_REALK,      0.000000000000000_REALK, &
     -9.432622470951920_REALK,      0.000000000000000_REALK,    -21.838346236687421_REALK, &
   -118.979834224311460_REALK,     15.378512926367295_REALK,      0.000000000000000_REALK, &
    -20.306664148908684_REALK,      0.000000000000000_REALK,    -25.260440382456654_REALK, &
     10.113074909004215_REALK,      0.000000000000000_REALK,      4.039750446819079_REALK, &
      0.000000000000000_REALK,    -24.142914915235593_REALK,      0.000000000000000_REALK, &
     -9.714245412538858_REALK,      0.000000000000000_REALK,    -36.252057251438565_REALK, &
    -45.883289804433495_REALK,     10.683552392224041_REALK,      0.000000000000000_REALK, &
    -11.593422678170354_REALK,      0.000000000000000_REALK,    -16.945683372393951_REALK, &
     10.288695181613646_REALK,      0.000000000000000_REALK,      3.615159842414137_REALK, &
      0.000000000000000_REALK,     -4.380343975043946_REALK,      0.000000000000000_REALK, &
     -5.506875649427108_REALK,      0.000000000000000_REALK,    -24.147598267606316_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     14.194671285559910_REALK, &
      0.000000000000000_REALK,     -0.711119768644262_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.754737938637816_REALK,      0.000000000000000_REALK, &
     11.186308444031612_REALK,      0.000000000000000_REALK,     -1.038142047130074_REALK, &
      0.000000000000000_REALK,     -1.020550480324381_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     10.388873070279383_REALK, &
      0.000000000000000_REALK,     -0.705255036607761_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.522109715492407_REALK,      0.000000000000000_REALK, &
     10.546333846487514_REALK,      0.000000000000000_REALK,      0.027578505591138_REALK, &
      0.000000000000000_REALK,     -1.004988404772980_REALK,      0.000000000000000_REALK, &
    -10.086074769757257_REALK,     -0.535715448214570_REALK,      0.000000000000000_REALK, &
     -1.637625922356361_REALK,      0.000000000000000_REALK,     -6.424080821985053_REALK, &
     -0.204496056448200_REALK,      0.000000000000000_REALK,     -0.422178021695868_REALK, &
      0.000000000000000_REALK,     -1.682206550935612_REALK,      0.000000000000000_REALK, &
     -2.350208776840375_REALK,      0.000000000000000_REALK,    -15.365669416978298_REALK, &
     -6.321659872327319_REALK,     -0.304574060409232_REALK,      0.000000000000000_REALK, &
     -1.181381096436745_REALK,      0.000000000000000_REALK,     -7.004173875131080_REALK, &
      0.691128452864008_REALK,      0.000000000000000_REALK,     -0.309190390557889_REALK, &
      0.000000000000000_REALK,      1.544173407909959_REALK,      0.000000000000000_REALK, &
     -1.683468024911447_REALK,      0.000000000000000_REALK,    -16.634912582778380_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.177131497859110_REALK, &
      0.000000000000000_REALK,      0.800161171650713_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.023734691562577_REALK,      0.000000000000000_REALK, &
      5.486411109999466_REALK,      0.000000000000000_REALK,      0.874064529949689_REALK, &
      0.000000000000000_REALK,      1.913894358522050_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.380215035912338_REALK, &
      0.000000000000000_REALK,      1.406458936605049_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.870631148272696_REALK,      0.000000000000000_REALK, &
      9.102935347394293_REALK,      0.000000000000000_REALK,      2.421397940066253_REALK, &
      0.000000000000000_REALK,      3.340339900007775_REALK,      0.000000000000000_REALK, &
     -3.558891044953816_REALK,     -1.020514031472830_REALK,      0.000000000000000_REALK, &
     -0.964791721270930_REALK,      0.000000000000000_REALK,     -3.777915629770872_REALK, &
     -0.719669843494123_REALK,      0.000000000000000_REALK,     -1.340383831117717_REALK, &
      0.000000000000000_REALK,     -1.392550331502475_REALK,      0.000000000000000_REALK, &
     -2.307671876504463_REALK,      0.000000000000000_REALK,    -12.650881264613320_REALK, &
     -4.149167947437581_REALK,     -1.638338473505936_REALK,      0.000000000000000_REALK, &
     -1.154677231749250_REALK,      0.000000000000000_REALK,     -7.661883726716690_REALK, &
      0.081037272009324_REALK,      0.000000000000000_REALK,     -2.771950396392333_REALK, &
      0.000000000000000_REALK,      2.599224092524410_REALK,      0.000000000000000_REALK, &
     -2.742358364299434_REALK,      0.000000000000000_REALK,    -25.475762823683862_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.212115771254651_REALK, &
      0.000000000000000_REALK,      1.777356368491767_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.871346830458201_REALK,      0.000000000000000_REALK, &
      5.906489352386338_REALK,      0.000000000000000_REALK,      3.586173162568094_REALK, &
      0.000000000000000_REALK,      5.951727509610205_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     10.464123654502290_REALK, &
      0.000000000000000_REALK,      8.696180247894883_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     10.705955368614354_REALK,      0.000000000000000_REALK, &
     24.786358285229682_REALK,      0.000000000000000_REALK,     20.750520953878652_REALK, &
      0.000000000000000_REALK,     28.914798679973003_REALK,      0.000000000000000_REALK/
    ! results of test 3, ket-major order, 1DOVL002
  data REF_CONTR_INTS(15121:16380)                                                         &
   /-58.548788719033148_REALK,    -41.883399814949165_REALK,      0.000000000000000_REALK, &
    -40.171303901448383_REALK,      0.000000000000000_REALK,    -10.191450954864177_REALK, &
    -46.370332746342470_REALK,      0.000000000000000_REALK,     -8.856089266077861_REALK, &
      0.000000000000000_REALK,    -71.585593920407220_REALK,      0.000000000000000_REALK, &
    -12.036106198031272_REALK,      0.000000000000000_REALK,     -9.160672476978005_REALK, &
    -20.842584358697390_REALK,    -18.728381504507681_REALK,      0.000000000000000_REALK, &
    -13.842741340714607_REALK,      0.000000000000000_REALK,     -5.639626257266616_REALK, &
     -2.562147394806922_REALK,      0.000000000000000_REALK,     -4.606043415791206_REALK, &
      0.000000000000000_REALK,     34.503486431951522_REALK,      0.000000000000000_REALK, &
     -4.179358333311439_REALK,      0.000000000000000_REALK,     -5.108096383859572_REALK, &
    -33.176698866965225_REALK,    -11.982970382632484_REALK,      0.000000000000000_REALK, &
     -4.105822040336164_REALK,      0.000000000000000_REALK,     -5.036418746444697_REALK, &
      3.398840413337183_REALK,      0.000000000000000_REALK,     -2.183942467000220_REALK, &
      0.000000000000000_REALK,     17.031325608052938_REALK,      0.000000000000000_REALK, &
     -1.012779554849125_REALK,      0.000000000000000_REALK,     -3.726987107049885_REALK, &
    -12.500974714007551_REALK,      3.654659718027620_REALK,      0.000000000000000_REALK, &
     11.148556440642349_REALK,      0.000000000000000_REALK,     -1.530582959720323_REALK, &
     20.131731408046583_REALK,      0.000000000000000_REALK,      0.600515074043454_REALK, &
      0.000000000000000_REALK,     36.754212096926111_REALK,      0.000000000000000_REALK, &
      2.501415099455899_REALK,      0.000000000000000_REALK,     -1.030256252493006_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.377532768527326_REALK, &
      0.000000000000000_REALK,      6.095971674346316_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      6.018285029253223_REALK,      0.000000000000000_REALK, &
      4.580512760439631_REALK,      0.000000000000000_REALK,      7.873284975640717_REALK, &
      0.000000000000000_REALK,      4.511064107063818_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.281983886630688_REALK, &
      0.000000000000000_REALK,      4.469394585246675_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.936962901421231_REALK,      0.000000000000000_REALK, &
      3.589615529423321_REALK,      0.000000000000000_REALK,      0.557817213188905_REALK, &
      0.000000000000000_REALK,      3.008410414519546_REALK,      0.000000000000000_REALK, &
    -27.612700938654850_REALK,     -5.036935743479729_REALK,      0.000000000000000_REALK, &
     -0.163286483020697_REALK,      0.000000000000000_REALK,     -3.642850568542406_REALK, &
      3.133121445405015_REALK,      0.000000000000000_REALK,     -0.785460927261611_REALK, &
      0.000000000000000_REALK,      6.347923555592708_REALK,      0.000000000000000_REALK, &
     -0.033077736690731_REALK,      0.000000000000000_REALK,     -2.213849848697874_REALK, &
     -6.745007267164154_REALK,     -0.128519724909376_REALK,      0.000000000000000_REALK, &
      1.325286855017152_REALK,      0.000000000000000_REALK,     -1.386098839196176_REALK, &
      1.448316199685685_REALK,      0.000000000000000_REALK,     -0.023455874848139_REALK, &
      0.000000000000000_REALK,      0.224624075723633_REALK,      0.000000000000000_REALK, &
      0.269485000656461_REALK,      0.000000000000000_REALK,     -0.845551689832161_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.762066440423277_REALK, &
      0.000000000000000_REALK,      1.732288346526820_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.605385362041409_REALK,      0.000000000000000_REALK, &
      2.227793233307496_REALK,      0.000000000000000_REALK,     -0.546129095785215_REALK, &
      0.000000000000000_REALK,      1.052754215881542_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.545087152658806_REALK, &
      0.000000000000000_REALK,     -0.594275595956878_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.053981807990159_REALK,      0.000000000000000_REALK, &
      0.845972186163362_REALK,      0.000000000000000_REALK,     -4.051070652720109_REALK, &
      0.000000000000000_REALK,     -0.362521575069464_REALK,      0.000000000000000_REALK, &
     -9.179929919489004_REALK,     -5.763901612165967_REALK,      0.000000000000000_REALK, &
     -4.773662850456000_REALK,      0.000000000000000_REALK,     -3.633231642281247_REALK, &
     -4.706227976870538_REALK,      0.000000000000000_REALK,     -2.696472459945803_REALK, &
      0.000000000000000_REALK,     -5.751444258757945_REALK,      0.000000000000000_REALK, &
     -2.901072273037338_REALK,      0.000000000000000_REALK,     -3.680006984551770_REALK, &
     -5.762074717451477_REALK,     -4.511747703691475_REALK,      0.000000000000000_REALK, &
     -2.906447238356998_REALK,      0.000000000000000_REALK,     -3.552318668106818_REALK, &
     -0.458039294766790_REALK,      0.000000000000000_REALK,     -2.470289822642938_REALK, &
      0.000000000000000_REALK,      4.879109029305625_REALK,      0.000000000000000_REALK, &
     -1.772998652264910_REALK,      0.000000000000000_REALK,     -3.611658091162211_REALK, &
    -28.098024036907596_REALK,      0.213448511339736_REALK,      0.000000000000000_REALK, &
      3.043525149786454_REALK,      0.000000000000000_REALK,     -3.151281175801052_REALK, &
      5.378898935859294_REALK,      0.000000000000000_REALK,      0.027996187127859_REALK, &
      0.000000000000000_REALK,      7.651687418293939_REALK,      0.000000000000000_REALK, &
      0.501737787330507_REALK,      0.000000000000000_REALK,     -1.558505450017691_REALK, &
    -13.443400589293722_REALK,      8.263101921921045_REALK,      0.000000000000000_REALK, &
      9.405029730660587_REALK,      0.000000000000000_REALK,     -1.184822557372308_REALK, &
     11.339590078214901_REALK,      0.000000000000000_REALK,      0.913642600473051_REALK, &
      0.000000000000000_REALK,     15.200616795168724_REALK,      0.000000000000000_REALK, &
      1.320169205880632_REALK,      0.000000000000000_REALK,     -0.498935027151412_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.078339474286109_REALK, &
      0.000000000000000_REALK,      0.736409487114967_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.023977174761877_REALK,      0.000000000000000_REALK, &
      1.604761087951301_REALK,      0.000000000000000_REALK,     -0.484252569206132_REALK, &
      0.000000000000000_REALK,      0.364200506107382_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.929114987736770_REALK, &
      0.000000000000000_REALK,      0.036320835506326_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.309660166691420_REALK,      0.000000000000000_REALK, &
      0.971607609261430_REALK,      0.000000000000000_REALK,     -0.314801656064485_REALK, &
      0.000000000000000_REALK,      0.015294895372098_REALK,      0.000000000000000_REALK, &
     -6.207790317055785_REALK,     -1.939376818114438_REALK,      0.000000000000000_REALK, &
     -0.567579504587295_REALK,      0.000000000000000_REALK,     -2.088669232800359_REALK, &
      0.395874509027620_REALK,      0.000000000000000_REALK,     -0.763113632939945_REALK, &
      0.000000000000000_REALK,      1.573476084396624_REALK,      0.000000000000000_REALK, &
     -0.280703530364212_REALK,      0.000000000000000_REALK,     -1.721629077722735_REALK, &
     -4.954443161303669_REALK,      1.255827871534009_REALK,      0.000000000000000_REALK, &
      3.180539453931907_REALK,      0.000000000000000_REALK,     -1.309966770180124_REALK, &
      4.655009408850949_REALK,      0.000000000000000_REALK,      0.416566751736781_REALK, &
      0.000000000000000_REALK,      6.559814566251032_REALK,      0.000000000000000_REALK, &
      1.339341936840764_REALK,      0.000000000000000_REALK,     -0.919389858535430_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.067570642039764_REALK, &
      0.000000000000000_REALK,      2.528079796624879_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.102910411852460_REALK,      0.000000000000000_REALK, &
      2.667539542336693_REALK,      0.000000000000000_REALK,      2.182171705228681_REALK, &
      0.000000000000000_REALK,      2.083822378537802_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.506787797328321_REALK, &
      0.000000000000000_REALK,      3.825182001611945_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.037319542336661_REALK,      0.000000000000000_REALK, &
      4.150088664739545_REALK,      0.000000000000000_REALK,      0.298674133244840_REALK, &
      0.000000000000000_REALK,      2.684673855391543_REALK,      0.000000000000000_REALK, &
    -34.731101028983112_REALK,      5.741573273795580_REALK,      0.000000000000000_REALK, &
      4.799503853606666_REALK,      0.000000000000000_REALK,     -3.314291928075967_REALK, &
      5.598972318981981_REALK,      0.000000000000000_REALK,      0.627834932447559_REALK, &
      0.000000000000000_REALK,      5.252490659866498_REALK,      0.000000000000000_REALK, &
      0.637903221463852_REALK,      0.000000000000000_REALK,     -1.321510032460471_REALK, &
     -9.140072498300192_REALK,      6.394433844948511_REALK,      0.000000000000000_REALK, &
      3.856664836922030_REALK,      0.000000000000000_REALK,     -1.428145312711879_REALK, &
      1.509201094912626_REALK,      0.000000000000000_REALK,      0.854478286069115_REALK, &
      0.000000000000000_REALK,     -2.874957969086986_REALK,      0.000000000000000_REALK, &
      0.526324826136726_REALK,      0.000000000000000_REALK,     -0.584703388960519_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.272440229957429_REALK, &
      0.000000000000000_REALK,     -0.031913548648297_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.451211645258232_REALK,      0.000000000000000_REALK, &
      1.401560388719890_REALK,      0.000000000000000_REALK,     -0.814944524080200_REALK, &
      0.000000000000000_REALK,     -0.012724912477647_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.624020486007222_REALK, &
      0.000000000000000_REALK,     -1.316055844316343_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.722650975459961_REALK,      0.000000000000000_REALK, &
      0.651046023028685_REALK,      0.000000000000000_REALK,     -2.229139715865524_REALK, &
      0.000000000000000_REALK,     -0.538812336100358_REALK,      0.000000000000000_REALK, &
     -6.389886343025060_REALK,     -0.998408375181731_REALK,      0.000000000000000_REALK, &
     -0.027332176689534_REALK,      0.000000000000000_REALK,     -1.829306998675724_REALK, &
      0.435487228567246_REALK,      0.000000000000000_REALK,     -0.327524682641340_REALK, &
      0.000000000000000_REALK,      0.697153757778255_REALK,      0.000000000000000_REALK, &
     -0.010898178702432_REALK,      0.000000000000000_REALK,     -1.215668184769466_REALK, &
     -2.985691084138680_REALK,     -0.049784485081032_REALK,      0.000000000000000_REALK, &
      0.446049770353541_REALK,      0.000000000000000_REALK,     -1.399551500650994_REALK, &
      0.410775662301677_REALK,      0.000000000000000_REALK,     -0.019957870790303_REALK, &
      0.000000000000000_REALK,      0.050739593438079_REALK,      0.000000000000000_REALK, &
      0.182619240527797_REALK,      0.000000000000000_REALK,     -0.954994446493589_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.831773478614511_REALK, &
      0.000000000000000_REALK,      0.869892172737093_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.252436043215534_REALK,      0.000000000000000_REALK, &
      1.548257094241892_REALK,      0.000000000000000_REALK,     -0.179934090899660_REALK, &
      0.000000000000000_REALK,      0.578087898500370_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.795553990362403_REALK, &
      0.000000000000000_REALK,     -0.600043285949249_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.747668922813663_REALK,      0.000000000000000_REALK, &
      1.199685486965720_REALK,      0.000000000000000_REALK,     -2.745249064408206_REALK, &
      0.000000000000000_REALK,     -0.409444029369946_REALK,      0.000000000000000_REALK, &
     -6.373013884384699_REALK,     -3.427517008188617_REALK,      0.000000000000000_REALK, &
     -2.397159778407148_REALK,      0.000000000000000_REALK,     -3.040794539871617_REALK, &
     -1.962422026435094_REALK,      0.000000000000000_REALK,     -1.873976701751987_REALK, &
      0.000000000000000_REALK,     -1.894938215243311_REALK,      0.000000000000000_REALK, &
     -1.593035438298881_REALK,      0.000000000000000_REALK,     -2.829069179588857_REALK, &
     -7.651782019770399_REALK,     -5.243125980907410_REALK,      0.000000000000000_REALK, &
     -2.934655508668070_REALK,      0.000000000000000_REALK,     -5.977992312129043_REALK, &
     -0.389731319808866_REALK,      0.000000000000000_REALK,     -3.503154001154802_REALK, &
      0.000000000000000_REALK,      3.306377658176164_REALK,      0.000000000000000_REALK, &
     -2.002484161423297_REALK,      0.000000000000000_REALK,     -5.710778945435564_REALK, &
    -61.899045022555185_REALK,     19.697708660398874_REALK,      0.000000000000000_REALK, &
      8.759913400686875_REALK,      0.000000000000000_REALK,     -4.503872081549531_REALK, &
      8.227811035662587_REALK,      0.000000000000000_REALK,      1.649084722354313_REALK, &
      0.000000000000000_REALK,      5.989335253113601_REALK,      0.000000000000000_REALK, &
      0.880868612722881_REALK,      0.000000000000000_REALK,     -1.358684511211526_REALK, &
    -61.743964250781730_REALK,     62.287274472090864_REALK,      0.000000000000000_REALK, &
     31.071743938471826_REALK,      0.000000000000000_REALK,     -3.628631648703101_REALK, &
     25.888815510173831_REALK,      0.000000000000000_REALK,      4.106584833179312_REALK, &
      0.000000000000000_REALK,     24.159958192936951_REALK,      0.000000000000000_REALK, &
      2.359701614230574_REALK,      0.000000000000000_REALK,     -0.826714584400052_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.368586615586751_REALK, &
      0.000000000000000_REALK,     -0.977095235452922_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.772104180527676_REALK,      0.000000000000000_REALK, &
      1.599526991462002_REALK,      0.000000000000000_REALK,     -0.876215764478377_REALK, &
      0.000000000000000_REALK,     -0.294760627822210_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.632263917657344_REALK, &
      0.000000000000000_REALK,     -3.552813957438310_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.536900246456562_REALK,      0.000000000000000_REALK, &
      1.707369171987277_REALK,      0.000000000000000_REALK,     -0.476551682706151_REALK, &
      0.000000000000000_REALK,     -0.809440968008996_REALK,      0.000000000000000_REALK, &
     -9.992631709557807_REALK,      0.061323565693082_REALK,      0.000000000000000_REALK, &
      0.702217614817916_REALK,      0.000000000000000_REALK,     -2.181238900930599_REALK, &
      0.986391121362467_REALK,      0.000000000000000_REALK,      0.015401957209581_REALK, &
      0.000000000000000_REALK,      1.076870430387502_REALK,      0.000000000000000_REALK, &
      0.211838209318048_REALK,      0.000000000000000_REALK,     -1.096691711889103_REALK, &
    -15.353715769476747_REALK,      7.954751717065624_REALK,      0.000000000000000_REALK, &
      7.162567532949371_REALK,      0.000000000000000_REALK,     -2.706968023952713_REALK, &
      6.509222458394651_REALK,      0.000000000000000_REALK,      1.573364528944634_REALK, &
      0.000000000000000_REALK,      6.263135428626649_REALK,      0.000000000000000_REALK, &
      1.631854543118450_REALK,      0.000000000000000_REALK,     -1.027885146781678_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.515109809391044_REALK, &
      0.000000000000000_REALK,      0.509724436094218_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.013190918391941_REALK,      0.000000000000000_REALK, &
      1.471418321796615_REALK,      0.000000000000000_REALK,     -0.204455792863608_REALK, &
      0.000000000000000_REALK,      0.256281218977610_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.459431832627599_REALK, &
      0.000000000000000_REALK,      0.082982333267626_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.533259200093235_REALK,      0.000000000000000_REALK, &
      2.788641400319136_REALK,      0.000000000000000_REALK,     -0.389124750328777_REALK, &
      0.000000000000000_REALK,      0.031509905937688_REALK,      0.000000000000000_REALK, &
     -6.623116517412377_REALK,     -1.671543656540007_REALK,      0.000000000000000_REALK, &
     -0.392864497234849_REALK,      0.000000000000000_REALK,     -2.409541986047897_REALK, &
      0.217788308835099_REALK,      0.000000000000000_REALK,     -0.699705015002636_REALK, &
      0.000000000000000_REALK,      0.664335763699989_REALK,      0.000000000000000_REALK, &
     -0.197525927961913_REALK,      0.000000000000000_REALK,     -1.696070345246544_REALK, &
    -16.975417400400662_REALK,      3.626894238441711_REALK,      0.000000000000000_REALK, &
      7.266589032376336_REALK,      0.000000000000000_REALK,     -4.988142369580625_REALK, &
      8.016292893958200_REALK,      0.000000000000000_REALK,      1.195601268265784_REALK, &
      0.000000000000000_REALK,      8.108553929502298_REALK,      0.000000000000000_REALK, &
      2.759256433047825_REALK,      0.000000000000000_REALK,     -2.651724131536839_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.843046969799631_REALK, &
      0.000000000000000_REALK,      2.916457195991702_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.928175435165135_REALK,      0.000000000000000_REALK, &
      3.424243783484856_REALK,      0.000000000000000_REALK,      1.535554221524243_REALK, &
      0.000000000000000_REALK,      2.052886644824826_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     36.133303016648490_REALK, &
      0.000000000000000_REALK,     14.565676662908128_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.847374564880096_REALK,      0.000000000000000_REALK, &
     16.675819062388008_REALK,      0.000000000000000_REALK,      0.615316000247656_REALK, &
      0.000000000000000_REALK,      7.743194447443924_REALK,      0.000000000000000_REALK, &
    -42.569402484578895_REALK,     -6.016415895994814_REALK,      0.000000000000000_REALK, &
    -23.555325500808287_REALK,      0.000000000000000_REALK,    -18.447511605223255_REALK, &
     -8.187604218231648_REALK,      0.000000000000000_REALK,     -3.049879721630588_REALK, &
      0.000000000000000_REALK,    -88.662336940815507_REALK,      0.000000000000000_REALK, &
    -29.385448674264893_REALK,      0.000000000000000_REALK,    -69.040235350336260_REALK, &
    -11.433179793251675_REALK,     -1.657204505242454_REALK,      0.000000000000000_REALK, &
     -5.906694485779328_REALK,      0.000000000000000_REALK,     -7.838797737566850_REALK, &
      0.205432510644916_REALK,      0.000000000000000_REALK,     -1.405399553056327_REALK, &
      0.000000000000000_REALK,     41.644852767591260_REALK,      0.000000000000000_REALK, &
     -8.787630943071514_REALK,      0.000000000000000_REALK,    -34.986299894618391_REALK, &
    -19.832059378190362_REALK,      2.093097996306802_REALK,      0.000000000000000_REALK, &
      1.949540854743892_REALK,      0.000000000000000_REALK,     -7.604914318157121_REALK, &
      8.312884865752062_REALK,      0.000000000000000_REALK,      0.903939303497713_REALK, &
      0.000000000000000_REALK,     50.473983007852176_REALK,      0.000000000000000_REALK, &
      2.088361226732205_REALK,      0.000000000000000_REALK,    -24.439305525730489_REALK, &
     -4.990028002127127_REALK,      4.128029115926409_REALK,      0.000000000000000_REALK, &
      7.897667692154029_REALK,      0.000000000000000_REALK,     -1.788356873748600_REALK, &
     11.774001319332749_REALK,      0.000000000000000_REALK,      1.937000347946496_REALK, &
      0.000000000000000_REALK,     67.622872789381191_REALK,      0.000000000000000_REALK, &
      9.320468983115095_REALK,      0.000000000000000_REALK,     -6.331612859226931_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.086986092114821_REALK, &
      0.000000000000000_REALK,      3.577804329111118_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.805185439873636_REALK,      0.000000000000000_REALK, &
      6.590699536938661_REALK,      0.000000000000000_REALK,     10.288782689434889_REALK, &
      0.000000000000000_REALK,     11.497703912542791_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.391514213767257_REALK, &
      0.000000000000000_REALK,      2.029771564850409_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.199155871077603_REALK,      0.000000000000000_REALK, &
      4.774213573339858_REALK,      0.000000000000000_REALK,     -0.350151052671843_REALK, &
      0.000000000000000_REALK,      7.186332845502661_REALK,      0.000000000000000_REALK, &
    -11.918947886218486_REALK,      7.380674627580811_REALK,      0.000000000000000_REALK, &
      2.529327352476006_REALK,      0.000000000000000_REALK,     -3.847190931094640_REALK, &
      8.606152633647305_REALK,      0.000000000000000_REALK,      2.776833230025202_REALK, &
      0.000000000000000_REALK,     14.850455198203784_REALK,      0.000000000000000_REALK, &
      2.171355468210914_REALK,      0.000000000000000_REALK,     -9.908111408323172_REALK, &
     -2.086759650901681_REALK,      3.458794437951016_REALK,      0.000000000000000_REALK, &
      0.751872020201991_REALK,      0.000000000000000_REALK,     -1.164778294151415_REALK, &
      1.748015775933997_REALK,      0.000000000000000_REALK,      1.755905428767346_REALK, &
      0.000000000000000_REALK,     -9.640531021264060_REALK,      0.000000000000000_REALK, &
      0.711790197912268_REALK,      0.000000000000000_REALK,     -3.308054097937641_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.354820756711827_REALK, &
      0.000000000000000_REALK,     -0.703233885576398_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.323564654719393_REALK,      0.000000000000000_REALK, &
      3.786555387445317_REALK,      0.000000000000000_REALK,     -5.551855714924355_REALK, &
      0.000000000000000_REALK,     -1.811118764104703_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.951005914153812_REALK, &
      0.000000000000000_REALK,     -1.753169274926086_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.132083725708466_REALK,      0.000000000000000_REALK, &
      1.448374406813633_REALK,      0.000000000000000_REALK,    -10.088493343332502_REALK, &
      0.000000000000000_REALK,     -4.979126786117536_REALK,      0.000000000000000_REALK, &
     -5.294987730431703_REALK,     -1.578307358190466_REALK,      0.000000000000000_REALK, &
     -2.182338403708613_REALK,      0.000000000000000_REALK,     -5.127338999525722_REALK, &
     -1.594114263268097_REALK,      0.000000000000000_REALK,     -1.781421024728103_REALK, &
      0.000000000000000_REALK,     -5.652685580962340_REALK,      0.000000000000000_REALK, &
     -5.620426025607922_REALK,      0.000000000000000_REALK,    -22.008372232033715_REALK, &
     -2.580500231606986_REALK,     -1.079384540574274_REALK,      0.000000000000000_REALK, &
     -1.085349949084547_REALK,      0.000000000000000_REALK,     -4.321116698604595_REALK, &
      0.080098046814358_REALK,      0.000000000000000_REALK,     -1.643894028849560_REALK, &
      0.000000000000000_REALK,      4.869309629343972_REALK,      0.000000000000000_REALK, &
     -3.082471887391485_REALK,      0.000000000000000_REALK,    -20.453803489558467_REALK, &
     -5.333681995736963_REALK,     13.407942204040642_REALK,      0.000000000000000_REALK, &
      2.089963485580469_REALK,      0.000000000000000_REALK,     -1.404763792408669_REALK, &
     10.511778020644332_REALK,      0.000000000000000_REALK,      4.284312106743671_REALK, &
      0.000000000000000_REALK,      6.781495715790758_REALK,      0.000000000000000_REALK, &
      1.365196995691213_REALK,      0.000000000000000_REALK,     -2.752841361512299_REALK, &
     -1.207513309010606_REALK,     10.748702764432291_REALK,      0.000000000000000_REALK, &
      3.001226122313751_REALK,      0.000000000000000_REALK,     -0.273439358374097_REALK, &
      9.547005655385993_REALK,      0.000000000000000_REALK,      3.356521084193496_REALK, &
      0.000000000000000_REALK,     15.375487958318324_REALK,      0.000000000000000_REALK, &
      1.827960356559978_REALK,      0.000000000000000_REALK,     -0.499632103674052_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.366511211643798_REALK, &
      0.000000000000000_REALK,     -1.962427400598369_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.497151596581785_REALK,      0.000000000000000_REALK, &
      2.268552283526704_REALK,      0.000000000000000_REALK,     -3.972916805862730_REALK, &
      0.000000000000000_REALK,     -3.845665261680273_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.324976908817734_REALK, &
      0.000000000000000_REALK,     -1.783167017808158_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.267080567507742_REALK,      0.000000000000000_REALK, &
      1.241260371967633_REALK,      0.000000000000000_REALK,     -1.081195685429005_REALK, &
      0.000000000000000_REALK,     -3.258226956087218_REALK,      0.000000000000000_REALK, &
     -3.386808758396092_REALK,      0.432578186118478_REALK,      0.000000000000000_REALK, &
      0.228667727474842_REALK,      0.000000000000000_REALK,     -2.676012360360086_REALK, &
      1.271147894978496_REALK,      0.000000000000000_REALK,      0.414672124558107_REALK, &
      0.000000000000000_REALK,      3.610135119852971_REALK,      0.000000000000000_REALK, &
      0.448108060328365_REALK,      0.000000000000000_REALK,     -8.740066656670496_REALK, &
     -2.165117091460371_REALK,      1.994292663410354_REALK,      0.000000000000000_REALK, &
      2.165185730735963_REALK,      0.000000000000000_REALK,     -1.470861374055087_REALK, &
      3.785442023981660_REALK,      0.000000000000000_REALK,      1.868286486144025_REALK, &
      0.000000000000000_REALK,      9.567953643391906_REALK,      0.000000000000000_REALK, &
      3.956256728823309_REALK,      0.000000000000000_REALK,     -4.479296414518811_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.153964917676612_REALK, &
      0.000000000000000_REALK,      1.258955486821485_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.286847691687753_REALK,      0.000000000000000_REALK, &
      5.039017127092976_REALK,      0.000000000000000_REALK,      2.207705446302054_REALK, &
      0.000000000000000_REALK,      4.111847551825289_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.915424570243186_REALK, &
      0.000000000000000_REALK,      1.669416567083639_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.156616575257546_REALK,      0.000000000000000_REALK, &
      7.674752279120920_REALK,      0.000000000000000_REALK,     -0.148628514374880_REALK, &
      0.000000000000000_REALK,      5.083967649962902_REALK,      0.000000000000000_REALK, &
      7.119556385490888_REALK,     22.076201878928984_REALK,      0.000000000000000_REALK, &
      0.167468312923395_REALK,      0.000000000000000_REALK,      1.511542950095012_REALK, &
     12.669751186831029_REALK,      0.000000000000000_REALK,      5.799152807002788_REALK, &
      0.000000000000000_REALK,     -3.111420920282463_REALK,      0.000000000000000_REALK, &
      0.080113024898240_REALK,      0.000000000000000_REALK,      2.169263113991823_REALK, &
      1.682475241569538_REALK,     12.975244525163671_REALK,      0.000000000000000_REALK, &
     -2.704413019665567_REALK,      0.000000000000000_REALK,      0.621374205011224_REALK, &
      5.088470198070804_REALK,      0.000000000000000_REALK,      4.390635364601851_REALK, &
      0.000000000000000_REALK,    -15.999094587118623_REALK,      0.000000000000000_REALK, &
     -1.284596155717864_REALK,      0.000000000000000_REALK,      0.885458222411277_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.138706789925853_REALK, &
      0.000000000000000_REALK,     -3.212088640036258_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.445028167083354_REALK,      0.000000000000000_REALK, &
      0.897373748441914_REALK,      0.000000000000000_REALK,     -3.770101880275153_REALK, &
      0.000000000000000_REALK,     -4.609770040120150_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.268348972825676_REALK, &
      0.000000000000000_REALK,     -3.350893076161842_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.996665554115568_REALK,      0.000000000000000_REALK, &
      0.272416251082898_REALK,      0.000000000000000_REALK,     -4.527223865390640_REALK, &
      0.000000000000000_REALK,     -4.775022527133914_REALK,      0.000000000000000_REALK, &
     -2.670339010969770_REALK,      1.590750998761374_REALK,      0.000000000000000_REALK, &
      0.372730780570974_REALK,      0.000000000000000_REALK,     -1.700807699741284_REALK, &
      1.295095059297694_REALK,      0.000000000000000_REALK,      1.253613484371306_REALK, &
      0.000000000000000_REALK,      1.219479721218381_REALK,      0.000000000000000_REALK, &
      0.534917736668461_REALK,      0.000000000000000_REALK,     -4.068138241137567_REALK, &
     -1.118428661166390_REALK,      1.749971329843395_REALK,      0.000000000000000_REALK, &
      0.266632743245261_REALK,      0.000000000000000_REALK,     -1.239179102949033_REALK, &
      0.589504303557966_REALK,      0.000000000000000_REALK,      1.776495077132926_REALK, &
      0.000000000000000_REALK,     -1.715362984531509_REALK,      0.000000000000000_REALK, &
      0.379951650658441_REALK,      0.000000000000000_REALK,     -2.943050303927117_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.169185638991086_REALK, &
      0.000000000000000_REALK,     -0.310893228001815_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.146074675942457_REALK,      0.000000000000000_REALK, &
      2.849094934050218_REALK,      0.000000000000000_REALK,     -1.367710693534740_REALK, &
      0.000000000000000_REALK,     -0.743621180652739_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.443479611873005_REALK, &
      0.000000000000000_REALK,     -1.865153858317266_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.157084419640559_REALK,      0.000000000000000_REALK, &
      2.442263272834707_REALK,      0.000000000000000_REALK,     -5.385210009492616_REALK, &
      0.000000000000000_REALK,     -4.429740314800348_REALK,      0.000000000000000_REALK, &
     -3.558891044953816_REALK,     -1.020514031472830_REALK,      0.000000000000000_REALK, &
     -0.964791721270930_REALK,      0.000000000000000_REALK,     -3.777915629770872_REALK, &
     -0.719669843494123_REALK,      0.000000000000000_REALK,     -1.340383831117717_REALK, &
      0.000000000000000_REALK,     -1.392550331502476_REALK,      0.000000000000000_REALK, &
     -2.307671876504464_REALK,      0.000000000000000_REALK,    -12.650881264613322_REALK, &
     -4.149167947437576_REALK,     -1.638338473505936_REALK,      0.000000000000000_REALK, &
     -1.154677231749249_REALK,      0.000000000000000_REALK,     -7.661883726716689_REALK, &
      0.081037272009325_REALK,      0.000000000000000_REALK,     -2.771950396392332_REALK, &
      0.000000000000000_REALK,      2.599224092524407_REALK,      0.000000000000000_REALK, &
     -2.742358364299433_REALK,      0.000000000000000_REALK,    -25.475762823683858_REALK, &
     49.988115970775347_REALK,     40.526351018788510_REALK,      0.000000000000000_REALK, &
     -3.432639369353385_REALK,      0.000000000000000_REALK,      7.845530055205596_REALK, &
     18.710298983404098_REALK,      0.000000000000000_REALK,      8.054815472192519_REALK, &
      0.000000000000000_REALK,    -11.052282466911771_REALK,      0.000000000000000_REALK, &
     -1.132391108161579_REALK,      0.000000000000000_REALK,      7.764470004609991_REALK, &
     55.905598383597834_REALK,     74.450813237353330_REALK,      0.000000000000000_REALK, &
    -10.054076650868398_REALK,      0.000000000000000_REALK,      7.060453665908589_REALK, &
     30.891069969589850_REALK,      0.000000000000000_REALK,     11.678104414824647_REALK, &
      0.000000000000000_REALK,     -1.078031463854113_REALK,      0.000000000000000_REALK, &
     -2.297944338439543_REALK,      0.000000000000000_REALK,      4.841179381794748_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.711571880647155_REALK, &
      0.000000000000000_REALK,     -5.298519843685138_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.037689935127181_REALK,      0.000000000000000_REALK, &
     -1.020550480324381_REALK,      0.000000000000000_REALK,     -3.818795218810084_REALK, &
      0.000000000000000_REALK,     -5.243775513654058_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.135683480002585_REALK, &
      0.000000000000000_REALK,     -9.732523256092700_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.458006948985962_REALK,      0.000000000000000_REALK, &
     -1.004988404772980_REALK,      0.000000000000000_REALK,     -2.577998303840646_REALK, &
      0.000000000000000_REALK,     -6.673351763178879_REALK,      0.000000000000000_REALK, &
     -1.741352111280608_REALK,      3.637158040455713_REALK,      0.000000000000000_REALK, &
      0.406609491552383_REALK,      0.000000000000000_REALK,     -0.819904694971993_REALK, &
      1.773680315665553_REALK,      0.000000000000000_REALK,      2.168710193929611_REALK, &
      0.000000000000000_REALK,      0.666309417307220_REALK,      0.000000000000000_REALK, &
      0.402408400520169_REALK,      0.000000000000000_REALK,     -1.352389060172539_REALK, &
     -1.593795254066755_REALK,     11.517129176426995_REALK,      0.000000000000000_REALK, &
      2.209263552646646_REALK,      0.000000000000000_REALK,     -0.603852809180458_REALK, &
      5.138364945258606_REALK,      0.000000000000000_REALK,      5.419614557569034_REALK, &
      0.000000000000000_REALK,      4.247241691341152_REALK,      0.000000000000000_REALK, &
      1.514837667112881_REALK,      0.000000000000000_REALK,     -0.690078359402200_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.925882842483814_REALK, &
      0.000000000000000_REALK,     -1.145390739701100_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.251657140883412_REALK,      0.000000000000000_REALK, &
      1.913894358522050_REALK,      0.000000000000000_REALK,     -1.171065496256432_REALK, &
      0.000000000000000_REALK,     -1.889260929342053_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.259099134771568_REALK, &
      0.000000000000000_REALK,     -3.937876461325834_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.431242258100266_REALK,      0.000000000000000_REALK, &
      3.340339900007776_REALK,      0.000000000000000_REALK,     -0.895990957314859_REALK, &
      0.000000000000000_REALK,     -4.500175020545748_REALK,      0.000000000000000_REALK, &
     -3.317198093165548_REALK,      0.352035055899724_REALK,      0.000000000000000_REALK, &
      0.133464248123685_REALK,      0.000000000000000_REALK,     -2.603136448892787_REALK, &
      0.643452514463827_REALK,      0.000000000000000_REALK,      0.349843662670326_REALK, &
      0.000000000000000_REALK,      1.064131186800760_REALK,      0.000000000000000_REALK, &
      0.220142158220950_REALK,      0.000000000000000_REALK,     -6.011228607533408_REALK, &
     -8.573205742210286_REALK,      6.410594856925734_REALK,      0.000000000000000_REALK, &
      4.781511680237360_REALK,      0.000000000000000_REALK,     -5.413654773520528_REALK, &
      6.112172748330607_REALK,      0.000000000000000_REALK,      5.027721850508690_REALK, &
      0.000000000000000_REALK,      7.928999403179576_REALK,      0.000000000000000_REALK, &
      5.464274878904447_REALK,      0.000000000000000_REALK,     -8.661356421230629_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.277863330953822_REALK, &
      0.000000000000000_REALK,      1.224670320595075_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.085666200106039_REALK,      0.000000000000000_REALK, &
      5.951727509610205_REALK,      0.000000000000000_REALK,      1.084580003557496_REALK, &
      0.000000000000000_REALK,      2.828039716892085_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     26.334145139729305_REALK, &
      0.000000000000000_REALK,      6.144457340986721_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.112556062044227_REALK,      0.000000000000000_REALK, &
     28.914798679973000_REALK,      0.000000000000000_REALK,     -0.205281687477622_REALK, &
      0.000000000000000_REALK,      9.830574218666737_REALK,      0.000000000000000_REALK/
    ! results of test 3, ket-major order, 1DOVL003
  data REF_CONTR_INTS(16381:17640)                                                         &
     /0.000000000000000_REALK,      0.000000000000000_REALK,     12.209587161337501_REALK, &
      0.000000000000000_REALK,     12.335510502417661_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     16.425689030404968_REALK,      0.000000000000000_REALK, &
      7.745015515490882_REALK,      0.000000000000000_REALK,     30.907178242688616_REALK, &
      0.000000000000000_REALK,     11.087878659224391_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     12.501230293251162_REALK, &
      0.000000000000000_REALK,     16.468048920163149_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     25.502317718550895_REALK,      0.000000000000000_REALK, &
      9.223628235199078_REALK,      0.000000000000000_REALK,     51.184926763798529_REALK, &
      0.000000000000000_REALK,     14.915949621647256_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.377532768527326_REALK, &
      0.000000000000000_REALK,      6.095971674346316_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      6.018285029253223_REALK,      0.000000000000000_REALK, &
      4.580512760439629_REALK,      0.000000000000000_REALK,      7.873284975640716_REALK, &
      0.000000000000000_REALK,      4.511064107063818_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.281983886630690_REALK, &
      0.000000000000000_REALK,      4.469394585246675_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.936962901421232_REALK,      0.000000000000000_REALK, &
      3.589615529423321_REALK,      0.000000000000000_REALK,      0.557817213188908_REALK, &
      0.000000000000000_REALK,      3.008410414519546_REALK,      0.000000000000000_REALK, &
      9.671464072433743_REALK,      8.377532768527326_REALK,      0.000000000000000_REALK, &
      9.341216610459950_REALK,      0.000000000000000_REALK,     -2.085933847353481_REALK, &
     12.768062194840098_REALK,      0.000000000000000_REALK,     -2.169264405147246_REALK, &
      0.000000000000000_REALK,     23.152677876284958_REALK,      0.000000000000000_REALK, &
     -3.273692581597515_REALK,      0.000000000000000_REALK,     -4.173680944286847_REALK, &
      8.344424410208857_REALK,      7.281983886630689_REALK,      0.000000000000000_REALK, &
      8.474391014111333_REALK,      0.000000000000000_REALK,     -4.944991743065289_REALK, &
     12.317969197018224_REALK,      0.000000000000000_REALK,     -5.791390766173672_REALK, &
      0.000000000000000_REALK,     22.918735512041497_REALK,      0.000000000000000_REALK, &
     -9.203050765809666_REALK,      0.000000000000000_REALK,     -7.344780697013846_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.830530914734441_REALK, &
      0.000000000000000_REALK,      4.409227071396122_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.649786208748017_REALK,      0.000000000000000_REALK, &
      3.663284417237143_REALK,      0.000000000000000_REALK,      3.988649916176913_REALK, &
      0.000000000000000_REALK,      2.679595690577732_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.588035945067877_REALK, &
      0.000000000000000_REALK,      4.047492236325485_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.066409726357447_REALK,      0.000000000000000_REALK, &
      3.059583387690254_REALK,      0.000000000000000_REALK,      5.665668738974966_REALK, &
      0.000000000000000_REALK,      2.469061947986520_REALK,      0.000000000000000_REALK, &
      7.584348092057158_REALK,      4.762066440423276_REALK,      0.000000000000000_REALK, &
      3.943943041996059_REALK,      0.000000000000000_REALK,     -1.421576946812006_REALK, &
      3.888229157543608_REALK,      0.000000000000000_REALK,     -1.055050562194703_REALK, &
      0.000000000000000_REALK,      4.751774324319903_REALK,      0.000000000000000_REALK, &
     -1.135104466335632_REALK,      0.000000000000000_REALK,     -2.335930053365533_REALK, &
      1.973272488466079_REALK,      1.545087152658806_REALK,      0.000000000000000_REALK, &
      0.995338078011720_REALK,      0.000000000000000_REALK,     -1.962704994138220_REALK, &
      0.156859531214041_REALK,      0.000000000000000_REALK,     -1.364869153040838_REALK, &
      0.000000000000000_REALK,     -1.670893226461585_REALK,      0.000000000000000_REALK, &
     -0.979606176845403_REALK,      0.000000000000000_REALK,     -2.641957742099134_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.096159137619856_REALK, &
      0.000000000000000_REALK,     -0.956292917411945_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.087562797168844_REALK,      0.000000000000000_REALK, &
      1.059311695339401_REALK,      0.000000000000000_REALK,     -1.619976210467592_REALK, &
      0.000000000000000_REALK,      1.200517439536802_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.948902948583890_REALK, &
      0.000000000000000_REALK,      1.089449164175544_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.436490510177775_REALK,      0.000000000000000_REALK, &
      3.817393384087544_REALK,      0.000000000000000_REALK,      2.280573693318197_REALK, &
      0.000000000000000_REALK,      4.883092478005739_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      9.030438649538032_REALK, &
      0.000000000000000_REALK,      3.814242173398460_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.584183704067790_REALK,      0.000000000000000_REALK, &
      3.553332586284229_REALK,      0.000000000000000_REALK,      2.172451309525271_REALK, &
      0.000000000000000_REALK,      1.886381088611596_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      9.647483267783709_REALK, &
      0.000000000000000_REALK,      3.459753350034372_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.513684699194594_REALK,      0.000000000000000_REALK, &
      3.200136625719711_REALK,      0.000000000000000_REALK,     -0.047496534747906_REALK, &
      0.000000000000000_REALK,      1.456920380942887_REALK,      0.000000000000000_REALK, &
      8.433574557777296_REALK,      4.078339474286109_REALK,      0.000000000000000_REALK, &
      2.827099580562477_REALK,      0.000000000000000_REALK,     -1.343824985817979_REALK, &
      2.388729837657292_REALK,      0.000000000000000_REALK,     -0.759991574944114_REALK, &
      0.000000000000000_REALK,      2.606248323964255_REALK,      0.000000000000000_REALK, &
     -0.662156534175242_REALK,      0.000000000000000_REALK,     -1.796993633538033_REALK, &
      6.136337466412071_REALK,      2.929114987736770_REALK,      0.000000000000000_REALK, &
      2.156371113477831_REALK,      0.000000000000000_REALK,     -2.617638069261469_REALK, &
      2.229513464751975_REALK,      0.000000000000000_REALK,     -1.567566022181965_REALK, &
      0.000000000000000_REALK,      3.244845379612821_REALK,      0.000000000000000_REALK, &
     -1.465038776130367_REALK,      0.000000000000000_REALK,     -2.432344893617435_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.884528533212160_REALK, &
      0.000000000000000_REALK,     -0.549752889658613_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.457296117453453_REALK,      0.000000000000000_REALK, &
      0.718968044003764_REALK,      0.000000000000000_REALK,     -0.474532173502725_REALK, &
      0.000000000000000_REALK,      0.561641796033587_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.788419517281383_REALK, &
      0.000000000000000_REALK,      0.401749487083899_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.213974676450648_REALK,      0.000000000000000_REALK, &
      1.921559648281264_REALK,      0.000000000000000_REALK,      0.031369011928263_REALK, &
      0.000000000000000_REALK,      1.243048369820754_REALK,      0.000000000000000_REALK, &
      5.428968800785847_REALK,      4.067570642039765_REALK,      0.000000000000000_REALK, &
      3.873925643090010_REALK,      0.000000000000000_REALK,      0.352687364375603_REALK, &
      4.461418958756212_REALK,      0.000000000000000_REALK,      0.309030995432941_REALK, &
      0.000000000000000_REALK,      6.417031609832160_REALK,      0.000000000000000_REALK, &
      0.369923886448416_REALK,      0.000000000000000_REALK,     -0.924215874479916_REALK, &
      9.921300714539557_REALK,      7.506787797328321_REALK,      0.000000000000000_REALK, &
      7.252903578664796_REALK,      0.000000000000000_REALK,     -2.483416594686616_REALK, &
      8.544758721617551_REALK,      0.000000000000000_REALK,     -2.357350514541345_REALK, &
      0.000000000000000_REALK,     12.271463307835539_REALK,      0.000000000000000_REALK, &
     -2.891466206971178_REALK,      0.000000000000000_REALK,     -5.327016188642624_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     12.775980185906935_REALK, &
      0.000000000000000_REALK,      4.011546841359845_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.328068743605272_REALK,      0.000000000000000_REALK, &
      4.191119545706496_REALK,      0.000000000000000_REALK,      1.584935593699231_REALK, &
      0.000000000000000_REALK,      1.599526991462001_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     10.341794454862704_REALK, &
      0.000000000000000_REALK,      4.170270475731821_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.922230461698117_REALK,      0.000000000000000_REALK, &
      4.145873902965362_REALK,      0.000000000000000_REALK,      2.925093195468961_REALK, &
      0.000000000000000_REALK,      1.707369171987277_REALK,      0.000000000000000_REALK, &
     11.689542074189989_REALK,      4.272440229957429_REALK,      0.000000000000000_REALK, &
      2.433764128906156_REALK,      0.000000000000000_REALK,     -1.584854340897325_REALK, &
      1.614107414580956_REALK,      0.000000000000000_REALK,     -0.663758671119298_REALK, &
      0.000000000000000_REALK,      1.330043087845806_REALK,      0.000000000000000_REALK, &
     -0.459575198991359_REALK,      0.000000000000000_REALK,     -1.708644511055314_REALK, &
      3.367678774223799_REALK,      1.624020486007222_REALK,      0.000000000000000_REALK, &
      0.746692128801760_REALK,      0.000000000000000_REALK,     -2.546886589355904_REALK, &
     -0.021224516081830_REALK,      0.000000000000000_REALK,     -1.050380436349446_REALK, &
      0.000000000000000_REALK,     -1.030751481371144_REALK,      0.000000000000000_REALK, &
     -0.493218910413295_REALK,      0.000000000000000_REALK,     -2.300899745899662_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.012583883879153_REALK, &
      0.000000000000000_REALK,     -0.481486868673010_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.330950938682375_REALK,      0.000000000000000_REALK, &
      0.686179214687037_REALK,      0.000000000000000_REALK,     -0.285772742069054_REALK, &
      0.000000000000000_REALK,      0.396583719170183_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.682036952802596_REALK, &
      0.000000000000000_REALK,      0.429223939365061_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.363393314950164_REALK,      0.000000000000000_REALK, &
      2.008954541217928_REALK,      0.000000000000000_REALK,      0.403242538914202_REALK, &
      0.000000000000000_REALK,      1.291187061594046_REALK,      0.000000000000000_REALK, &
      5.265307700451099_REALK,      2.831773478614512_REALK,      0.000000000000000_REALK, &
      1.980504682625121_REALK,      0.000000000000000_REALK,      0.291042989792464_REALK, &
      1.621329561613086_REALK,      0.000000000000000_REALK,      0.179363575844340_REALK, &
      0.000000000000000_REALK,      1.565575245496733_REALK,      0.000000000000000_REALK, &
      0.152473898097512_REALK,      0.000000000000000_REALK,     -0.614892508004647_REALK, &
      2.620419152431702_REALK,      1.795553990362404_REALK,      0.000000000000000_REALK, &
      1.004998244962258_REALK,      0.000000000000000_REALK,     -1.162867719394523_REALK, &
      0.133466872434545_REALK,      0.000000000000000_REALK,     -0.681450308282489_REALK, &
      0.000000000000000_REALK,     -1.132297720749378_REALK,      0.000000000000000_REALK, &
     -0.389532817764470_REALK,      0.000000000000000_REALK,     -2.425142623301481_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.302835328577121_REALK, &
      0.000000000000000_REALK,     -1.696533321276293_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.602138316177109_REALK,      0.000000000000000_REALK, &
     -0.166483001784953_REALK,      0.000000000000000_REALK,     -1.885614857541143_REALK, &
      0.000000000000000_REALK,     -0.149077909700123_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.294346251984429_REALK, &
      0.000000000000000_REALK,     -1.291174206782624_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.434658446162251_REALK,      0.000000000000000_REALK, &
      3.811916504273466_REALK,      0.000000000000000_REALK,     -1.814008143256063_REALK, &
      0.000000000000000_REALK,      3.883477343631681_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     25.320305047632353_REALK, &
      0.000000000000000_REALK,      5.451388777667954_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.689557602686869_REALK,      0.000000000000000_REALK, &
      6.359419098833769_REALK,      0.000000000000000_REALK,      1.357159815298884_REALK, &
      0.000000000000000_REALK,      1.644522171744616_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     58.504457569314233_REALK, &
      0.000000000000000_REALK,     10.595823336182809_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.128921014440612_REALK,      0.000000000000000_REALK, &
     11.571553908744832_REALK,      0.000000000000000_REALK,     -0.581639757370457_REALK, &
      0.000000000000000_REALK,      2.414056463647814_REALK,      0.000000000000000_REALK, &
     24.687493947734477_REALK,      6.368586615586751_REALK,      0.000000000000000_REALK, &
      2.993409351822925_REALK,      0.000000000000000_REALK,     -2.552106257837466_REALK, &
      1.584935593699231_REALK,      0.000000000000000_REALK,     -0.757512782764905_REALK, &
      0.000000000000000_REALK,      1.119806060174584_REALK,      0.000000000000000_REALK, &
     -0.427658473249786_REALK,      0.000000000000000_REALK,     -2.081680080089664_REALK, &
     33.483131662241782_REALK,      8.632263917657346_REALK,      0.000000000000000_REALK, &
      4.160965111688049_REALK,      0.000000000000000_REALK,     -9.524246645950937_REALK, &
      2.925093195468961_REALK,      0.000000000000000_REALK,     -2.754624269938246_REALK, &
      0.000000000000000_REALK,      3.239652267263648_REALK,      0.000000000000000_REALK, &
     -1.529472678652441_REALK,      0.000000000000000_REALK,     -4.788155278988532_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.692548464126262_REALK, &
      0.000000000000000_REALK,     -0.574117897650380_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.309155623829725_REALK,      0.000000000000000_REALK, &
      0.878133114703221_REALK,      0.000000000000000_REALK,     -0.199459295521050_REALK, &
      0.000000000000000_REALK,      0.357770387786017_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.926321482061436_REALK, &
      0.000000000000000_REALK,      0.830191299452566_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.273773659979538_REALK,      0.000000000000000_REALK, &
      4.252719891318522_REALK,      0.000000000000000_REALK,     -0.006166191376032_REALK, &
      0.000000000000000_REALK,      1.389737926960929_REALK,      0.000000000000000_REALK, &
      8.997814697603237_REALK,      3.515109809391045_REALK,      0.000000000000000_REALK, &
      1.956848417488458_REALK,      0.000000000000000_REALK,      0.379227936292395_REALK, &
      1.314147336450567_REALK,      0.000000000000000_REALK,      0.170461903737989_REALK, &
      0.000000000000000_REALK,      1.100381497921880_REALK,      0.000000000000000_REALK, &
      0.113980271523382_REALK,      0.000000000000000_REALK,     -0.606171136363364_REALK, &
     21.024943956497506_REALK,      8.459431832627599_REALK,      0.000000000000000_REALK, &
      4.926668230309155_REALK,      0.000000000000000_REALK,     -3.509296092392919_REALK, &
      3.839397813137192_REALK,      0.000000000000000_REALK,     -1.584015612911291_REALK, &
      0.000000000000000_REALK,      4.010937121432045_REALK,      0.000000000000000_REALK, &
     -1.062628768055101_REALK,      0.000000000000000_REALK,     -4.072644342372906_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.693354915211359_REALK, &
      0.000000000000000_REALK,     -1.344342149639977_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.888793263606078_REALK,      0.000000000000000_REALK, &
     -0.149077909700123_REALK,      0.000000000000000_REALK,     -0.707814352938137_REALK, &
      0.000000000000000_REALK,     -0.089374492358814_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.672669933876068_REALK, &
      0.000000000000000_REALK,     -1.077378563082875_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.432512416162619_REALK,      0.000000000000000_REALK, &
      3.883477343631681_REALK,      0.000000000000000_REALK,     -0.045513042993525_REALK, &
      0.000000000000000_REALK,      1.803240973740630_REALK,      0.000000000000000_REALK, &
      9.653647836174189_REALK,      5.843046969799631_REALK,      0.000000000000000_REALK, &
      4.469059217834127_REALK,      0.000000000000000_REALK,      1.811698385266843_REALK, &
      4.090710851859765_REALK,      0.000000000000000_REALK,      1.261708366790227_REALK, &
      0.000000000000000_REALK,      4.515547495424822_REALK,      0.000000000000000_REALK, &
      1.159096992549553_REALK,      0.000000000000000_REALK,      0.078360397804389_REALK, &
     56.655617089868265_REALK,     36.133303016648490_REALK,      0.000000000000000_REALK, &
     27.617888076845006_REALK,      0.000000000000000_REALK,     -2.797261161047646_REALK, &
     24.524579366925529_REALK,      0.000000000000000_REALK,     -2.001385739657424_REALK, &
      0.000000000000000_REALK,     25.281157218838903_REALK,      0.000000000000000_REALK, &
     -1.762071765904233_REALK,      0.000000000000000_REALK,    -11.824233594654904_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.787390234715579_REALK, &
      0.000000000000000_REALK,      8.678807429153172_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.258021186060472_REALK,      0.000000000000000_REALK, &
      5.759783669102944_REALK,      0.000000000000000_REALK,     45.665637510518536_REALK, &
      0.000000000000000_REALK,     32.480635886919693_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.116924328407710_REALK, &
      0.000000000000000_REALK,      8.896976316016673_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.427999328441814_REALK,      0.000000000000000_REALK, &
      5.385800899502727_REALK,      0.000000000000000_REALK,     66.493104035198101_REALK, &
      0.000000000000000_REALK,     39.709186531976371_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.086986092114821_REALK, &
      0.000000000000000_REALK,      3.577804329111118_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.805185439873636_REALK,      0.000000000000000_REALK, &
      6.590699536938663_REALK,      0.000000000000000_REALK,     10.288782689434893_REALK, &
      0.000000000000000_REALK,     11.497703912542793_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.391514213767257_REALK, &
      0.000000000000000_REALK,      2.029771564850410_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.199155871077604_REALK,      0.000000000000000_REALK, &
      4.774213573339858_REALK,      0.000000000000000_REALK,     -0.350151052671840_REALK, &
      0.000000000000000_REALK,      7.186332845502661_REALK,      0.000000000000000_REALK, &
     12.484467384188038_REALK,      5.086986092114821_REALK,      0.000000000000000_REALK, &
     10.617430600697588_REALK,      0.000000000000000_REALK,      0.282842126983384_REALK, &
      9.266090018754426_REALK,      0.000000000000000_REALK,      0.129794958057873_REALK, &
      0.000000000000000_REALK,     60.461432602990122_REALK,      0.000000000000000_REALK, &
      0.671955132770827_REALK,      0.000000000000000_REALK,    -13.566877755744658_REALK, &
      6.374295775640051_REALK,      3.391514213767257_REALK,      0.000000000000000_REALK, &
      6.907074851853642_REALK,      0.000000000000000_REALK,     -2.901228800887828_REALK, &
      7.994429187379834_REALK,      0.000000000000000_REALK,     -2.021059742962373_REALK, &
      0.000000000000000_REALK,     51.859485735397001_REALK,      0.000000000000000_REALK, &
    -10.352175715425400_REALK,      0.000000000000000_REALK,    -28.631436784575691_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.460271173033565_REALK, &
      0.000000000000000_REALK,      1.809947593403386_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.267637151084263_REALK,      0.000000000000000_REALK, &
      7.291648761164853_REALK,      0.000000000000000_REALK,      3.548031158016674_REALK, &
      0.000000000000000_REALK,      4.661365323390552_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.544640517598148_REALK, &
      0.000000000000000_REALK,      1.322014579711824_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.848950459110981_REALK,      0.000000000000000_REALK, &
      5.398459179522447_REALK,      0.000000000000000_REALK,      4.536175368622069_REALK, &
      0.000000000000000_REALK,      3.754616453541590_REALK,      0.000000000000000_REALK, &
     11.254927408405994_REALK,      3.354820756711827_REALK,      0.000000000000000_REALK, &
      4.638737909278308_REALK,      0.000000000000000_REALK,      0.214632795328983_REALK, &
      3.388419620062888_REALK,      0.000000000000000_REALK,      0.074571112663037_REALK, &
      0.000000000000000_REALK,     12.015243304650177_REALK,      0.000000000000000_REALK, &
      0.235273647583587_REALK,      0.000000000000000_REALK,     -8.250580473962414_REALK, &
      2.273583592764694_REALK,      0.951005914153812_REALK,      0.000000000000000_REALK, &
      0.956261815605389_REALK,      0.000000000000000_REALK,     -1.611685608073120_REALK, &
     -0.070571435266337_REALK,      0.000000000000000_REALK,     -0.613137883628496_REALK, &
      0.000000000000000_REALK,     -4.290169148511706_REALK,      0.000000000000000_REALK, &
     -1.149697155784554_REALK,      0.000000000000000_REALK,    -12.758824396011621_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.230222977691807_REALK, &
      0.000000000000000_REALK,     -2.614157520545937_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.695312592643981_REALK,      0.000000000000000_REALK, &
     -1.403080532039515_REALK,      0.000000000000000_REALK,     -9.465507327657406_REALK, &
      0.000000000000000_REALK,     -2.590919969547949_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.050829703338274_REALK, &
      0.000000000000000_REALK,     -1.245932843966685_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.612944616738928_REALK,      0.000000000000000_REALK, &
      2.599437630362599_REALK,      0.000000000000000_REALK,     -5.925289654755172_REALK, &
      0.000000000000000_REALK,      5.747426229418915_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.938493923825760_REALK, &
      0.000000000000000_REALK,      0.660884497522678_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.184279872609440_REALK,      0.000000000000000_REALK, &
      8.568495556841087_REALK,      0.000000000000000_REALK,      0.627325240385276_REALK, &
      0.000000000000000_REALK,      1.295100421718040_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.489126170549058_REALK, &
      0.000000000000000_REALK,      0.310351609617659_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.183365290545023_REALK,      0.000000000000000_REALK, &
      7.015937767898882_REALK,      0.000000000000000_REALK,     -1.267582097032667_REALK, &
      0.000000000000000_REALK,      0.567078669705466_REALK,      0.000000000000000_REALK, &
     13.862764357589402_REALK,      2.366511211643798_REALK,      0.000000000000000_REALK, &
      3.406395771061145_REALK,      0.000000000000000_REALK,      0.215711645289891_REALK, &
      1.726724602586625_REALK,      0.000000000000000_REALK,      0.044676084358294_REALK, &
      0.000000000000000_REALK,      5.842891265510258_REALK,      0.000000000000000_REALK, &
      0.131461715241602_REALK,      0.000000000000000_REALK,     -6.309468164992651_REALK, &
      7.110127558109665_REALK,      1.324976908817734_REALK,      0.000000000000000_REALK, &
      1.654334017352063_REALK,      0.000000000000000_REALK,     -2.044772781070226_REALK, &
      1.499640454634223_REALK,      0.000000000000000_REALK,     -0.525460650174332_REALK, &
      0.000000000000000_REALK,      5.372505528510194_REALK,      0.000000000000000_REALK, &
     -1.279645925382504_REALK,      0.000000000000000_REALK,    -10.414426594942300_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.418017794505351_REALK, &
      0.000000000000000_REALK,     -1.364356411299562_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.394583777503472_REALK,      0.000000000000000_REALK, &
     -1.260926146221404_REALK,      0.000000000000000_REALK,     -2.392536599945948_REALK, &
      0.000000000000000_REALK,     -1.028918131573025_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.248724691488137_REALK, &
      0.000000000000000_REALK,     -0.424102060342178_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.293829282795217_REALK,      0.000000000000000_REALK, &
      1.900074883189670_REALK,      0.000000000000000_REALK,      0.037757897228790_REALK, &
      0.000000000000000_REALK,      1.258662024170217_REALK,      0.000000000000000_REALK, &
      6.396083635244228_REALK,      3.153964917676612_REALK,      0.000000000000000_REALK, &
      3.736054652831021_REALK,      0.000000000000000_REALK,      3.468676064307995_REALK, &
      4.250715971255789_REALK,      0.000000000000000_REALK,      2.075148847524941_REALK, &
      0.000000000000000_REALK,     12.973452552935328_REALK,      0.000000000000000_REALK, &
      5.025083346895787_REALK,      0.000000000000000_REALK,      6.152075405169786_REALK, &
      8.297205981997802_REALK,      4.915424570243187_REALK,      0.000000000000000_REALK, &
      5.680829009258998_REALK,      0.000000000000000_REALK,      1.371616829398005_REALK, &
      7.710831870036226_REALK,      0.000000000000000_REALK,      1.120536984342241_REALK, &
      0.000000000000000_REALK,     22.012780662181758_REALK,      0.000000000000000_REALK, &
      2.525873552679482_REALK,      0.000000000000000_REALK,     -8.811528392452498_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     14.194671285559910_REALK, &
      0.000000000000000_REALK,     -0.711119768644262_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.754737938637817_REALK,      0.000000000000000_REALK, &
     11.186308444031617_REALK,      0.000000000000000_REALK,     -1.038142047130075_REALK, &
      0.000000000000000_REALK,     -1.020550480324381_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     10.388873070279386_REALK, &
      0.000000000000000_REALK,     -0.705255036607761_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.522109715492408_REALK,      0.000000000000000_REALK, &
     10.546333846487514_REALK,      0.000000000000000_REALK,      0.027578505591138_REALK, &
      0.000000000000000_REALK,     -1.004988404772980_REALK,      0.000000000000000_REALK, &
     21.438772882693332_REALK,      1.138706789925853_REALK,      0.000000000000000_REALK, &
      3.480907193101661_REALK,      0.000000000000000_REALK,      0.268915011152862_REALK, &
      0.434673013008501_REALK,      0.000000000000000_REALK,      0.017672568350060_REALK, &
      0.000000000000000_REALK,      3.575666947802675_REALK,      0.000000000000000_REALK, &
      0.098380832518899_REALK,      0.000000000000000_REALK,     -5.760339325620707_REALK, &
      5.569781389173433_REALK,      0.268348972825676_REALK,      0.000000000000000_REALK, &
      1.040871318189451_REALK,      0.000000000000000_REALK,     -2.612409480779787_REALK, &
     -0.608927793021711_REALK,      0.000000000000000_REALK,     -0.115321510010960_REALK, &
      0.000000000000000_REALK,     -1.360514245108708_REALK,      0.000000000000000_REALK, &
     -0.627898151484137_REALK,      0.000000000000000_REALK,    -10.376648460273982_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.526844832563594_REALK, &
      0.000000000000000_REALK,     -0.867151409277285_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.109442712251537_REALK,      0.000000000000000_REALK, &
     -1.372878687060331_REALK,      0.000000000000000_REALK,     -0.947242025480361_REALK, &
      0.000000000000000_REALK,     -0.478918681341796_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.366801029056801_REALK, &
      0.000000000000000_REALK,     -0.357299756431006_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.475219031465954_REALK,      0.000000000000000_REALK, &
      2.253656950457882_REALK,      0.000000000000000_REALK,     -0.615136973921593_REALK, &
      0.000000000000000_REALK,      0.826983818433818_REALK,      0.000000000000000_REALK, &
      7.564712593227414_REALK,      2.169185638991086_REALK,      0.000000000000000_REALK, &
      2.050743333120071_REALK,      0.000000000000000_REALK,      3.306994053594782_REALK, &
      1.529716830124717_REALK,      0.000000000000000_REALK,      1.173303427983043_REALK, &
      0.000000000000000_REALK,      2.959979076728517_REALK,      0.000000000000000_REALK, &
      2.020017893758791_REALK,      0.000000000000000_REALK,      4.295415499147782_REALK, &
      3.655678869303805_REALK,      1.443479611873005_REALK,      0.000000000000000_REALK, &
      1.017343527773758_REALK,      0.000000000000000_REALK,      0.985608431556380_REALK, &
     -0.071398951949744_REALK,      0.000000000000000_REALK,      0.356577805143891_REALK, &
      0.000000000000000_REALK,     -2.290080496137787_REALK,      0.000000000000000_REALK, &
      0.352771149055396_REALK,      0.000000000000000_REALK,     -4.937969405406972_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.819667664217444_REALK, &
      0.000000000000000_REALK,     -2.666861230118344_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.807890639561933_REALK,      0.000000000000000_REALK, &
     -4.642775351410659_REALK,      0.000000000000000_REALK,     -5.380927731369615_REALK, &
      0.000000000000000_REALK,     -4.678334647088954_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.282818041655046_REALK, &
      0.000000000000000_REALK,     -4.390270931794375_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -5.404906903038664_REALK,      0.000000000000000_REALK, &
     -1.856330013008660_REALK,      0.000000000000000_REALK,    -10.475910844356815_REALK, &
      0.000000000000000_REALK,     -2.165522179259488_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     28.603262281537578_REALK, &
      0.000000000000000_REALK,     -3.691004292930422_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.570159220341038_REALK,      0.000000000000000_REALK, &
     17.055125402755568_REALK,      0.000000000000000_REALK,     -3.048186309302981_REALK, &
      0.000000000000000_REALK,     -3.652868820549558_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     58.242868377715425_REALK, &
      0.000000000000000_REALK,     -8.013561664549341_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      6.250262332117493_REALK,      0.000000000000000_REALK, &
     27.407341925148941_REALK,      0.000000000000000_REALK,     -5.212615519884456_REALK, &
      0.000000000000000_REALK,     -5.494702088688609_REALK,      0.000000000000000_REALK, &
     46.140018725283639_REALK,     -1.711571880647155_REALK,      0.000000000000000_REALK, &
      5.349929302889438_REALK,      0.000000000000000_REALK,      0.427839474639156_REALK, &
     -1.038142047130074_REALK,      0.000000000000000_REALK,     -0.020098368321487_REALK, &
      0.000000000000000_REALK,      3.966778873944783_REALK,      0.000000000000000_REALK, &
      0.104271081599395_REALK,      0.000000000000000_REALK,     -6.319921156955286_REALK, &
     54.363580970309378_REALK,     -2.135683480002585_REALK,      0.000000000000000_REALK, &
      4.925712710583966_REALK,      0.000000000000000_REALK,     -8.719346297380254_REALK, &
      0.027578505591138_REALK,      0.000000000000000_REALK,      0.425440038621845_REALK, &
      0.000000000000000_REALK,      4.632810681434027_REALK,      0.000000000000000_REALK, &
     -1.429765963876433_REALK,      0.000000000000000_REALK,    -16.664929939895874_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -7.883210222978841_REALK, &
      0.000000000000000_REALK,     -0.418025807283314_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.198246487973320_REALK,      0.000000000000000_REALK, &
     -1.808912504668341_REALK,      0.000000000000000_REALK,     -0.200392718655306_REALK, &
      0.000000000000000_REALK,     -0.159209040344163_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.115701075662538_REALK, &
      0.000000000000000_REALK,     -0.174112411294617_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.485404179128565_REALK,      0.000000000000000_REALK, &
      4.674335164663063_REALK,      0.000000000000000_REALK,      0.266858525856788_REALK, &
      0.000000000000000_REALK,      0.193908896465505_REALK,      0.000000000000000_REALK, &
     13.577836474822535_REALK,      1.925882842483814_REALK,      0.000000000000000_REALK, &
      1.988177585953375_REALK,      0.000000000000000_REALK,      4.387928265536995_REALK, &
      0.874064529949689_REALK,      0.000000000000000_REALK,      0.788172687688949_REALK, &
      0.000000000000000_REALK,      1.722263186915964_REALK,      0.000000000000000_REALK, &
      1.350507088722829_REALK,      0.000000000000000_REALK,      3.930330498956179_REALK, &
     28.153944490788799_REALK,      4.259099134771568_REALK,      0.000000000000000_REALK, &
      3.653366690299654_REALK,      0.000000000000000_REALK,      2.595663500803065_REALK, &
      2.421397940066253_REALK,      0.000000000000000_REALK,      0.487699701841256_REALK, &
      0.000000000000000_REALK,      4.452215668766012_REALK,      0.000000000000000_REALK, &
      0.609568352060083_REALK,      0.000000000000000_REALK,     -6.257431268279476_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.418784700305595_REALK, &
      0.000000000000000_REALK,     -1.837575094995215_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.629004261182363_REALK,      0.000000000000000_REALK, &
     -4.678334647088953_REALK,      0.000000000000000_REALK,     -1.627374461151853_REALK, &
      0.000000000000000_REALK,     -2.222970754208198_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -13.294806297120488_REALK, &
      0.000000000000000_REALK,     -3.102032350619078_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.571375479030702_REALK,      0.000000000000000_REALK, &
     -2.165522179259488_REALK,      0.000000000000000_REALK,      0.103636562222921_REALK, &
      0.000000000000000_REALK,     -0.736243289846043_REALK,      0.000000000000000_REALK, &
     10.441036558855576_REALK,      4.277863330953822_REALK,      0.000000000000000_REALK, &
      3.634310583128717_REALK,      0.000000000000000_REALK,      6.651611141368908_REALK, &
      3.586173162568094_REALK,      0.000000000000000_REALK,      3.451220547148150_REALK, &
      0.000000000000000_REALK,      6.373471261569045_REALK,      0.000000000000000_REALK, &
      4.866514525600905_REALK,      0.000000000000000_REALK,     11.799513835596789_REALK, &
     54.757357196160896_REALK,     26.334145139729308_REALK,      0.000000000000000_REALK, &
     20.908868521539588_REALK,      0.000000000000000_REALK,     18.879254141152025_REALK, &
     20.750520953878652_REALK,      0.000000000000000_REALK,     11.276833788138577_REALK, &
      0.000000000000000_REALK,     30.403457771298079_REALK,      0.000000000000000_REALK, &
     13.046466129844347_REALK,      0.000000000000000_REALK,      5.089808587914938_REALK/
    ! results of test 4, ket-major order, 01 DPG X
  data REF_CONTR_INTS(17641:18900)                                                         &
     /7.805017388863392_REALK,     -0.170026926273168_REALK,      0.000000000000000_REALK, &
    -12.680827760531944_REALK,      0.000000000000000_REALK,     -1.993081438324823_REALK, &
    -38.413628702395279_REALK,      0.000000000000000_REALK,     -4.593600129266789_REALK, &
      0.000000000000000_REALK,   -172.773679987949890_REALK,      0.000000000000000_REALK, &
    -17.194699918043305_REALK,      0.000000000000000_REALK,     -8.107618341181508_REALK, &
     13.063143093845929_REALK,     11.765826913811200_REALK,      0.000000000000000_REALK, &
      4.550751188764806_REALK,      0.000000000000000_REALK,      0.548635587025146_REALK, &
    -18.791820289397837_REALK,      0.000000000000000_REALK,     -1.825393154181168_REALK, &
      0.000000000000000_REALK,   -164.771693692143003_REALK,      0.000000000000000_REALK, &
    -13.669970648608476_REALK,      0.000000000000000_REALK,     -4.944128162795565_REALK, &
      0.102372942633275_REALK,     -3.736470641393762_REALK,      0.000000000000000_REALK, &
     -7.827617014702936_REALK,      0.000000000000000_REALK,     -1.985864713142384_REALK, &
    -14.059996011369925_REALK,      0.000000000000000_REALK,     -2.685263882804727_REALK, &
      0.000000000000000_REALK,    -34.986617658128104_REALK,      0.000000000000000_REALK, &
     -5.882505439730667_REALK,      0.000000000000000_REALK,     -4.477171004542021_REALK, &
      9.207744812159429_REALK,      2.913312775199504_REALK,      0.000000000000000_REALK, &
     -0.022009567462359_REALK,      0.000000000000000_REALK,     -0.008966846343268_REALK, &
     -0.349806722543611_REALK,      0.000000000000000_REALK,     -0.628857244683579_REALK, &
      0.000000000000000_REALK,     11.344196548413695_REALK,      0.000000000000000_REALK, &
     -1.374106424660636_REALK,      0.000000000000000_REALK,     -1.679460696849549_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.089232587933147_REALK, &
      0.000000000000000_REALK,      2.403647442728137_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.980449968190334_REALK,      0.000000000000000_REALK, &
      2.348374074680093_REALK,      0.000000000000000_REALK,     15.105520103260616_REALK, &
      0.000000000000000_REALK,      5.419070374988030_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.944641821306012_REALK, &
      0.000000000000000_REALK,      0.026183732308549_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.481798977089821_REALK,      0.000000000000000_REALK, &
      1.259290222512285_REALK,      0.000000000000000_REALK,     16.828788321721191_REALK, &
      0.000000000000000_REALK,      4.904126559729603_REALK,      0.000000000000000_REALK, &
     -5.347712412890575_REALK,     -5.564454427391341_REALK,      0.000000000000000_REALK, &
     -6.885571538961359_REALK,      0.000000000000000_REALK,     -2.303678944444368_REALK, &
     -9.480377511317009_REALK,      0.000000000000000_REALK,     -2.122988919245155_REALK, &
      0.000000000000000_REALK,    -18.507924683731936_REALK,      0.000000000000000_REALK, &
     -3.309656729676116_REALK,      0.000000000000000_REALK,     -3.321897018287415_REALK, &
      1.470501567135901_REALK,     -0.365143978338122_REALK,      0.000000000000000_REALK, &
     -2.160224520963822_REALK,      0.000000000000000_REALK,     -0.541787268769439_REALK, &
     -5.811420423583645_REALK,      0.000000000000000_REALK,     -0.844193197819402_REALK, &
      0.000000000000000_REALK,    -19.493596150981521_REALK,      0.000000000000000_REALK, &
     -1.818406136920783_REALK,      0.000000000000000_REALK,     -1.368176249563639_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.528382153324420_REALK, &
      0.000000000000000_REALK,      1.695693296710009_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.298460290574556_REALK,      0.000000000000000_REALK, &
      1.749356608928659_REALK,      0.000000000000000_REALK,      4.267646980994707_REALK, &
      0.000000000000000_REALK,      2.445183830783138_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.106823986727387_REALK, &
      0.000000000000000_REALK,      0.437435887991608_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.606203259989318_REALK,      0.000000000000000_REALK, &
      0.740913899522424_REALK,      0.000000000000000_REALK,      0.204824776794169_REALK, &
      0.000000000000000_REALK,      1.104657542094423_REALK,      0.000000000000000_REALK, &
     -1.147499345078408_REALK,     -1.849920505680573_REALK,      0.000000000000000_REALK, &
     -3.145059850445273_REALK,      0.000000000000000_REALK,     -1.482953761863926_REALK, &
     -5.902151469563254_REALK,      0.000000000000000_REALK,     -2.117383179047130_REALK, &
      0.000000000000000_REALK,    -15.189897887045388_REALK,      0.000000000000000_REALK, &
     -4.535165355713010_REALK,      0.000000000000000_REALK,     -3.564023603545193_REALK, &
      0.792507926680643_REALK,     -0.311932486130046_REALK,      0.000000000000000_REALK, &
     -2.421954808070815_REALK,      0.000000000000000_REALK,     -0.875967862946361_REALK, &
     -7.424218502447553_REALK,      0.000000000000000_REALK,     -2.163513287293233_REALK, &
      0.000000000000000_REALK,    -24.573841680049199_REALK,      0.000000000000000_REALK, &
     -6.116166320122782_REALK,      0.000000000000000_REALK,     -3.686805057227016_REALK, &
    -12.557807161028492_REALK,     -7.392313676309692_REALK,      0.000000000000000_REALK, &
     -6.504382690836303_REALK,      0.000000000000000_REALK,     -2.981242514174532_REALK, &
     -6.541263510951516_REALK,      0.000000000000000_REALK,     -1.893301471411796_REALK, &
      0.000000000000000_REALK,     -8.828427610593288_REALK,      0.000000000000000_REALK, &
     -2.147111441737510_REALK,      0.000000000000000_REALK,     -2.952344696044670_REALK, &
      1.727412946815125_REALK,     -0.768246611792477_REALK,      0.000000000000000_REALK, &
     -1.095760438020173_REALK,      0.000000000000000_REALK,     -0.772195846023685_REALK, &
      0.060482464704774_REALK,      0.000000000000000_REALK,     -0.618417996075869_REALK, &
      0.000000000000000_REALK,      5.534243296831104_REALK,      0.000000000000000_REALK, &
     -0.547126576284852_REALK,      0.000000000000000_REALK,     -1.156700465166489_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.218790490809758_REALK, &
      0.000000000000000_REALK,      1.629644746189903_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.698531961162112_REALK,      0.000000000000000_REALK, &
      1.704813736922637_REALK,      0.000000000000000_REALK,      2.402256325879580_REALK, &
      0.000000000000000_REALK,      1.613848252859430_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.350671724469826_REALK, &
      0.000000000000000_REALK,      0.684607531552125_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.125517651985260_REALK,      0.000000000000000_REALK, &
      0.846844106299863_REALK,      0.000000000000000_REALK,      2.353175477680615_REALK, &
      0.000000000000000_REALK,      1.025498718078492_REALK,      0.000000000000000_REALK, &
     -1.885466465840294_REALK,     -1.633208555881245_REALK,      0.000000000000000_REALK, &
     -1.764339748976526_REALK,      0.000000000000000_REALK,     -1.342837817527003_REALK, &
     -2.190177226290737_REALK,      0.000000000000000_REALK,     -1.254880256995234_REALK, &
      0.000000000000000_REALK,     -3.463939840272572_REALK,      0.000000000000000_REALK, &
     -1.747237628319519_REALK,      0.000000000000000_REALK,     -2.216369007986015_REALK, &
      0.448038176388141_REALK,     -0.283130309679325_REALK,      0.000000000000000_REALK, &
     -0.491607037953084_REALK,      0.000000000000000_REALK,     -0.600852076461790_REALK, &
     -0.126778004739995_REALK,      0.000000000000000_REALK,     -0.683737003401945_REALK, &
      0.000000000000000_REALK,      2.026486236604310_REALK,      0.000000000000000_REALK, &
     -0.736396203641338_REALK,      0.000000000000000_REALK,     -1.500063919273070_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.428308277535546_REALK, &
      0.000000000000000_REALK,      1.625341678482199_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.327468959775632_REALK,      0.000000000000000_REALK, &
      1.829074280325767_REALK,      0.000000000000000_REALK,      4.486682314221933_REALK, &
      0.000000000000000_REALK,      2.682644826171257_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.566970061473095_REALK, &
      0.000000000000000_REALK,      1.754524313770778_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.785652179679051_REALK,      0.000000000000000_REALK, &
      2.281978754407551_REALK,      0.000000000000000_REALK,      9.018701615531549_REALK, &
      0.000000000000000_REALK,      4.380277145871286_REALK,      0.000000000000000_REALK, &
    -28.260375574444783_REALK,    -10.792658439727459_REALK,      0.000000000000000_REALK, &
     -7.471011351952328_REALK,      0.000000000000000_REALK,     -4.483244146658742_REALK, &
     -5.851034956099647_REALK,      0.000000000000000_REALK,     -1.968300452812192_REALK, &
      0.000000000000000_REALK,     -6.482732366426599_REALK,      0.000000000000000_REALK, &
     -1.742579949946998_REALK,      0.000000000000000_REALK,     -3.137089876851768_REALK, &
     -6.949861453881020_REALK,     -4.339032616268588_REALK,      0.000000000000000_REALK, &
     -4.079964242261570_REALK,      0.000000000000000_REALK,     -1.929464211068729_REALK, &
     -5.251160215524677_REALK,      0.000000000000000_REALK,     -1.021696115875434_REALK, &
      0.000000000000000_REALK,    -10.810830607119524_REALK,      0.000000000000000_REALK, &
     -1.054499067986790_REALK,      0.000000000000000_REALK,     -1.496055914812157_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.632514696792199_REALK, &
      0.000000000000000_REALK,      1.814659994102104_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.445370275437685_REALK,      0.000000000000000_REALK, &
      1.987428870043138_REALK,      0.000000000000000_REALK,      1.462347051251969_REALK, &
      0.000000000000000_REALK,      1.269783958044818_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.598725616803369_REALK, &
      0.000000000000000_REALK,      0.884757297583780_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.534184050433128_REALK,      0.000000000000000_REALK, &
      1.129338194127175_REALK,      0.000000000000000_REALK,     -0.022364611499109_REALK, &
      0.000000000000000_REALK,      0.686017590080237_REALK,      0.000000000000000_REALK, &
     -3.433339207317715_REALK,     -1.985651439941345_REALK,      0.000000000000000_REALK, &
     -1.627980564725542_REALK,      0.000000000000000_REALK,     -1.634001416310284_REALK, &
     -1.617126069897293_REALK,      0.000000000000000_REALK,     -1.086393676828642_REALK, &
      0.000000000000000_REALK,     -2.123426846157927_REALK,      0.000000000000000_REALK, &
     -1.139157534643332_REALK,      0.000000000000000_REALK,     -1.905617574455446_REALK, &
     -1.454667273930131_REALK,     -1.417386021674263_REALK,      0.000000000000000_REALK, &
     -1.610253845250570_REALK,      0.000000000000000_REALK,     -1.211561609977304_REALK, &
     -2.297510050750838_REALK,      0.000000000000000_REALK,     -1.001240083523093_REALK, &
      0.000000000000000_REALK,     -4.461544863294285_REALK,      0.000000000000000_REALK, &
     -1.248548574115181_REALK,      0.000000000000000_REALK,     -1.565688462776157_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.636189637167381_REALK, &
      0.000000000000000_REALK,      1.202756684100484_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.176187357119961_REALK,      0.000000000000000_REALK, &
      1.491992367639728_REALK,      0.000000000000000_REALK,      1.468890163142006_REALK, &
      0.000000000000000_REALK,      1.402688058980486_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.243981836337794_REALK, &
      0.000000000000000_REALK,      0.978207793477150_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.718976419416166_REALK,      0.000000000000000_REALK, &
      1.464579230910350_REALK,      0.000000000000000_REALK,      0.140636174624262_REALK, &
      0.000000000000000_REALK,      1.264127753662966_REALK,      0.000000000000000_REALK, &
     -2.210153157637489_REALK,     -1.980408338578337_REALK,      0.000000000000000_REALK, &
     -2.230793601860908_REALK,      0.000000000000000_REALK,     -1.753100587976223_REALK, &
     -3.020298400096340_REALK,      0.000000000000000_REALK,     -1.805875100813074_REALK, &
      0.000000000000000_REALK,     -5.228242093307339_REALK,      0.000000000000000_REALK, &
     -2.601613101589670_REALK,      0.000000000000000_REALK,     -2.862320044306375_REALK, &
     -2.351922713386695_REALK,     -3.632502013800858_REALK,      0.000000000000000_REALK, &
     -5.416050977394376_REALK,      0.000000000000000_REALK,     -3.264777818085244_REALK, &
     -8.805360162442952_REALK,      0.000000000000000_REALK,     -4.276659714996135_REALK, &
      0.000000000000000_REALK,    -16.872817555550441_REALK,      0.000000000000000_REALK, &
     -6.999106326316131_REALK,      0.000000000000000_REALK,     -5.906653767907908_REALK, &
    -72.433927843658736_REALK,    -18.125197657475209_REALK,      0.000000000000000_REALK, &
    -10.307137498301945_REALK,      0.000000000000000_REALK,     -8.123691295986774_REALK, &
     -5.885739307859820_REALK,      0.000000000000000_REALK,     -2.377324733553372_REALK, &
      0.000000000000000_REALK,     -4.975834133999402_REALK,      0.000000000000000_REALK, &
     -1.699174512315816_REALK,      0.000000000000000_REALK,     -4.017672956726339_REALK, &
    -67.280560918585394_REALK,    -13.716128371226516_REALK,      0.000000000000000_REALK, &
     -4.810142575386091_REALK,      0.000000000000000_REALK,     -5.929714414110885_REALK, &
      1.096207295845293_REALK,      0.000000000000000_REALK,     -1.516578073455032_REALK, &
      0.000000000000000_REALK,      8.372728857349754_REALK,      0.000000000000000_REALK, &
     -0.675192135035819_REALK,      0.000000000000000_REALK,     -2.497034010532321_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.228959789401594_REALK, &
      0.000000000000000_REALK,      2.473139685340303_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.580041786464390_REALK,      0.000000000000000_REALK, &
      2.844479585267226_REALK,      0.000000000000000_REALK,      1.211964397333547_REALK, &
      0.000000000000000_REALK,      1.223122109146009_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.438118652126758_REALK, &
      0.000000000000000_REALK,      2.554826161307339_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.739065593790115_REALK,      0.000000000000000_REALK, &
      2.467275170572850_REALK,      0.000000000000000_REALK,      1.843165389803476_REALK, &
      0.000000000000000_REALK,      1.075850769575168_REALK,      0.000000000000000_REALK, &
     -7.421919132057278_REALK,     -2.926029388467827_REALK,      0.000000000000000_REALK, &
     -1.816085843545380_REALK,      0.000000000000000_REALK,     -2.497174251660709_REALK, &
     -1.325947453579602_REALK,      0.000000000000000_REALK,     -1.151345574447807_REALK, &
      0.000000000000000_REALK,     -1.231019868863307_REALK,      0.000000000000000_REALK, &
     -0.898167928206524_REALK,      0.000000000000000_REALK,     -2.058347839995457_REALK, &
    -10.680662694702242_REALK,     -3.410755027230078_REALK,      0.000000000000000_REALK, &
     -1.335766443459853_REALK,      0.000000000000000_REALK,     -2.823993082177349_REALK, &
      0.036883414653781_REALK,      0.000000000000000_REALK,     -1.131370926596491_REALK, &
      0.000000000000000_REALK,      1.896576615444875_REALK,      0.000000000000000_REALK, &
     -0.562498293595675_REALK,      0.000000000000000_REALK,     -1.981997299039168_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.634728368102729_REALK, &
      0.000000000000000_REALK,      1.365037188417518_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.032903257125715_REALK,      0.000000000000000_REALK, &
      1.727872168362834_REALK,      0.000000000000000_REALK,      1.004898742233080_REALK, &
      0.000000000000000_REALK,      1.125160307264944_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.670591430343926_REALK, &
      0.000000000000000_REALK,      2.503674350315546_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.059089413483124_REALK,      0.000000000000000_REALK, &
      2.582112226430399_REALK,      0.000000000000000_REALK,      2.419288786361925_REALK, &
      0.000000000000000_REALK,      1.757184120356645_REALK,      0.000000000000000_REALK, &
     -3.343046948300104_REALK,     -1.939372343189548_REALK,      0.000000000000000_REALK, &
     -1.477861586696722_REALK,      0.000000000000000_REALK,     -1.874665795744104_REALK, &
     -1.331880260392905_REALK,      0.000000000000000_REALK,     -1.271853120214774_REALK, &
      0.000000000000000_REALK,     -1.449016389783650_REALK,      0.000000000000000_REALK, &
     -1.218158165280797_REALK,      0.000000000000000_REALK,     -2.163325208220405_REALK, &
     -8.310713391098689_REALK,     -3.771008341371600_REALK,      0.000000000000000_REALK, &
     -1.797853331480658_REALK,      0.000000000000000_REALK,     -3.662287911539189_REALK, &
     -0.231935276147988_REALK,      0.000000000000000_REALK,     -2.084782385581009_REALK, &
      0.000000000000000_REALK,      2.083421093936369_REALK,      0.000000000000000_REALK, &
     -1.261809198312849_REALK,      0.000000000000000_REALK,     -3.598487090035324_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.826768572642061_REALK, &
      0.000000000000000_REALK,      2.269054692441754_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.358949104659406_REALK,      0.000000000000000_REALK, &
      2.595338754113539_REALK,      0.000000000000000_REALK,      3.128074056730943_REALK, &
      0.000000000000000_REALK,      2.618441764998253_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     12.585776219346805_REALK, &
      0.000000000000000_REALK,     10.694101654207946_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     11.542831443761504_REALK,      0.000000000000000_REALK, &
      9.741173467142479_REALK,      0.000000000000000_REALK,     15.453475451184220_REALK, &
      0.000000000000000_REALK,     10.507799406196661_REALK,      0.000000000000000_REALK, &
    -13.043257158127945_REALK,     48.236594928691190_REALK,      0.000000000000000_REALK, &
    -12.701234578698482_REALK,      0.000000000000000_REALK,     -5.726945319367743_REALK, &
     88.295764690638904_REALK,      0.000000000000000_REALK,     20.934067274057689_REALK, &
      0.000000000000000_REALK,   -123.493613184668604_REALK,      0.000000000000000_REALK, &
    -23.230511674524848_REALK,      0.000000000000000_REALK,    -31.423686243240127_REALK, &
    -18.874051461878516_REALK,     41.025680183657933_REALK,      0.000000000000000_REALK, &
    -13.167072793436986_REALK,      0.000000000000000_REALK,     -4.354903050136526_REALK, &
    109.783711800423987_REALK,      0.000000000000000_REALK,     21.854005029594813_REALK, &
      0.000000000000000_REALK,   -141.137181759495746_REALK,      0.000000000000000_REALK, &
    -22.184329508475439_REALK,      0.000000000000000_REALK,    -22.011863781108925_REALK, &
      3.238562720918497_REALK,     14.703205621526282_REALK,      0.000000000000000_REALK, &
     -3.015653313755370_REALK,      0.000000000000000_REALK,     -2.361729176738534_REALK, &
     15.323270501120458_REALK,      0.000000000000000_REALK,      5.707912928468475_REALK, &
      0.000000000000000_REALK,    -34.241380819169891_REALK,      0.000000000000000_REALK, &
    -11.348655734952489_REALK,      0.000000000000000_REALK,    -26.663328218542631_REALK, &
      6.301565218788764_REALK,      7.292943930281645_REALK,      0.000000000000000_REALK, &
      0.004593487369285_REALK,      0.000000000000000_REALK,      0.006096035351851_REALK, &
     -0.461869455847524_REALK,      0.000000000000000_REALK,      3.159729318308602_REALK, &
      0.000000000000000_REALK,     13.801291029790452_REALK,      0.000000000000000_REALK, &
     -2.912260316648412_REALK,      0.000000000000000_REALK,    -11.594616736811270_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -9.255805840659233_REALK, &
      0.000000000000000_REALK,      1.111097971550952_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -7.968974646847097_REALK,      0.000000000000000_REALK, &
    -10.779554169591075_REALK,      0.000000000000000_REALK,     17.636062146564182_REALK, &
      0.000000000000000_REALK,     12.544016557957692_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -9.316056276028430_REALK, &
      0.000000000000000_REALK,     -0.006918954151233_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -12.203653103872592_REALK,      0.000000000000000_REALK, &
    -12.108779291784472_REALK,      0.000000000000000_REALK,     22.036112971398577_REALK, &
      0.000000000000000_REALK,     13.159802555732247_REALK,      0.000000000000000_REALK, &
      6.398768536133870_REALK,      4.477713431068178_REALK,      0.000000000000000_REALK, &
     -2.041798664963326_REALK,      0.000000000000000_REALK,     -2.188486327983763_REALK, &
      2.931452855176155_REALK,      0.000000000000000_REALK,      1.283770451620532_REALK, &
      0.000000000000000_REALK,    -20.492397730358267_REALK,      0.000000000000000_REALK, &
     -7.803989967440889_REALK,      0.000000000000000_REALK,    -25.093941396675760_REALK, &
      2.697355254793298_REALK,      2.738151342884074_REALK,      0.000000000000000_REALK, &
      0.256413692643900_REALK,      0.000000000000000_REALK,      0.249553982727096_REALK, &
      3.775651008798580_REALK,      0.000000000000000_REALK,      1.041708800070212_REALK, &
      0.000000000000000_REALK,    -18.735288867076989_REALK,      0.000000000000000_REALK, &
     -3.513781707197207_REALK,      0.000000000000000_REALK,    -10.259337679159650_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.228254045861600_REALK, &
      0.000000000000000_REALK,      0.534668589327041_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.547902032262563_REALK,      0.000000000000000_REALK, &
     -3.636749664478096_REALK,      0.000000000000000_REALK,      5.486085686834993_REALK, &
      0.000000000000000_REALK,      6.130695026811981_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.983293243665060_REALK, &
      0.000000000000000_REALK,     -0.075992109681376_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.855223997123833_REALK,      0.000000000000000_REALK, &
     -3.404913501065899_REALK,      0.000000000000000_REALK,     -0.152219898749392_REALK, &
      0.000000000000000_REALK,      3.124088446328452_REALK,      0.000000000000000_REALK, &
      0.984100469044745_REALK,      1.989222362932700_REALK,      0.000000000000000_REALK, &
     -0.746465562143031_REALK,      0.000000000000000_REALK,     -1.009736674973443_REALK, &
      2.405474011666267_REALK,      0.000000000000000_REALK,      1.710943496417485_REALK, &
      0.000000000000000_REALK,    -15.166985976046877_REALK,      0.000000000000000_REALK, &
     -8.559232393428422_REALK,      0.000000000000000_REALK,    -19.296650096965866_REALK, &
      1.049231628768620_REALK,      3.386015333119091_REALK,      0.000000000000000_REALK, &
      0.293500250103503_REALK,      0.000000000000000_REALK,      0.291218516319436_REALK, &
      6.471197821409257_REALK,      0.000000000000000_REALK,      3.864551145629093_REALK, &
      0.000000000000000_REALK,    -25.588049020146546_REALK,      0.000000000000000_REALK, &
    -12.065999275285114_REALK,      0.000000000000000_REALK,    -19.953659355887929_REALK, &
      2.579240956474114_REALK,      0.516350795491966_REALK,      0.000000000000000_REALK, &
     -2.987761645273176_REALK,      0.000000000000000_REALK,     -3.906798254724833_REALK, &
     -0.048970865697515_REALK,      0.000000000000000_REALK,     -0.033699791184234_REALK, &
      0.000000000000000_REALK,    -14.242765582860272_REALK,      0.000000000000000_REALK, &
     -6.632850300240263_REALK,      0.000000000000000_REALK,    -26.019352666059596_REALK, &
     11.013984071332118_REALK,      0.405910120497252_REALK,      0.000000000000000_REALK, &
      0.099199480715119_REALK,      0.000000000000000_REALK,      0.196044672727278_REALK, &
     -0.327394473888738_REALK,      0.000000000000000_REALK,      0.048822195463411_REALK, &
      0.000000000000000_REALK,      4.797471993370802_REALK,      0.000000000000000_REALK, &
     -1.743411860325397_REALK,      0.000000000000000_REALK,    -10.336342643805494_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.342046527985763_REALK, &
      0.000000000000000_REALK,      0.486617207275051_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.081718241028114_REALK,      0.000000000000000_REALK, &
      0.262767220351945_REALK,      0.000000000000000_REALK,      2.466818793733032_REALK, &
      0.000000000000000_REALK,      3.240880102818201_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.390096003354095_REALK, &
      0.000000000000000_REALK,     -0.039366353098413_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.295378906815717_REALK,      0.000000000000000_REALK, &
     -0.862430338833053_REALK,      0.000000000000000_REALK,      2.507617504348528_REALK, &
      0.000000000000000_REALK,      2.075568331450085_REALK,      0.000000000000000_REALK, &
      0.303363391352781_REALK,      0.327875077287083_REALK,      0.000000000000000_REALK, &
     -0.586737109523092_REALK,      0.000000000000000_REALK,     -1.378521341609689_REALK, &
     -0.057446674627733_REALK,      0.000000000000000_REALK,     -0.064196598914281_REALK, &
      0.000000000000000_REALK,     -3.930109518535428_REALK,      0.000000000000000_REALK, &
     -3.907680606871016_REALK,      0.000000000000000_REALK,    -15.301631756751840_REALK, &
      2.409645072406975_REALK,      0.727812217825932_REALK,      0.000000000000000_REALK, &
      0.032319060611511_REALK,      0.000000000000000_REALK,      0.128672261522107_REALK, &
     -0.012796055940555_REALK,      0.000000000000000_REALK,      0.262620136072192_REALK, &
      0.000000000000000_REALK,      2.691775574881464_REALK,      0.000000000000000_REALK, &
     -1.704003887273242_REALK,      0.000000000000000_REALK,    -11.306951670279455_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.619201308914027_REALK, &
      0.000000000000000_REALK,      0.648538486752917_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.089626642097182_REALK,      0.000000000000000_REALK, &
      0.202061805594059_REALK,      0.000000000000000_REALK,      6.072622136157291_REALK, &
      0.000000000000000_REALK,      7.198798310069246_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.789136860696636_REALK, &
      0.000000000000000_REALK,     -0.146042046448546_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.014303668401709_REALK,      0.000000000000000_REALK, &
     -1.677363757527407_REALK,      0.000000000000000_REALK,     12.893635211453091_REALK, &
      0.000000000000000_REALK,     12.833304874638443_REALK,      0.000000000000000_REALK, &
    -14.622454495891928_REALK,      0.700118007633770_REALK,      0.000000000000000_REALK, &
     -6.274938989715285_REALK,      0.000000000000000_REALK,     -8.493657663028021_REALK, &
      1.304599877551695_REALK,      0.000000000000000_REALK,      0.427497706229820_REALK, &
      0.000000000000000_REALK,    -16.685091207728430_REALK,      0.000000000000000_REALK, &
     -7.423469145639359_REALK,      0.000000000000000_REALK,    -30.144869471299526_REALK, &
      0.105441475736005_REALK,      0.048410754733337_REALK,      0.000000000000000_REALK, &
     -1.717991632657868_REALK,      0.000000000000000_REALK,     -2.394623991730223_REALK, &
     -0.015322393646088_REALK,      0.000000000000000_REALK,      0.186121130902680_REALK, &
      0.000000000000000_REALK,    -13.374376431184595_REALK,      0.000000000000000_REALK, &
     -3.250089948390568_REALK,      0.000000000000000_REALK,    -13.590421311290291_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.108231207682084_REALK, &
      0.000000000000000_REALK,      0.320555758593651_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.984477378268546_REALK,      0.000000000000000_REALK, &
      3.861908973884001_REALK,      0.000000000000000_REALK,      0.551076073028859_REALK, &
      0.000000000000000_REALK,      1.137685539545760_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.160262281481209_REALK, &
      0.000000000000000_REALK,      0.070203991075908_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.311773719126440_REALK,      0.000000000000000_REALK, &
      1.848444456276087_REALK,      0.000000000000000_REALK,     -0.890615354241832_REALK, &
      0.000000000000000_REALK,      0.398434919114911_REALK,      0.000000000000000_REALK, &
     -1.434339079833376_REALK,     -0.262593949234940_REALK,      0.000000000000000_REALK, &
     -0.777312019546306_REALK,      0.000000000000000_REALK,     -2.499467880764473_REALK, &
     -0.366136304724065_REALK,      0.000000000000000_REALK,     -0.481025954526606_REALK, &
      0.000000000000000_REALK,     -2.414731555129442_REALK,      0.000000000000000_REALK, &
     -2.758760747998176_REALK,      0.000000000000000_REALK,    -14.784783345131411_REALK, &
      0.018202096586927_REALK,     -0.032181142559906_REALK,      0.000000000000000_REALK, &
     -0.424740795477810_REALK,      0.000000000000000_REALK,     -1.240133739098315_REALK, &
     -0.448436340986795_REALK,      0.000000000000000_REALK,     -0.371173142000121_REALK, &
      0.000000000000000_REALK,     -4.284339997280969_REALK,      0.000000000000000_REALK, &
     -2.410568998962209_REALK,      0.000000000000000_REALK,    -11.730401136668736_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.743893470650180_REALK, &
      0.000000000000000_REALK,      0.610644420661194_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.579995474769552_REALK,      0.000000000000000_REALK, &
      2.271136786333337_REALK,      0.000000000000000_REALK,      1.939366646566570_REALK, &
      0.000000000000000_REALK,      3.612067004288817_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.105186791908222_REALK, &
      0.000000000000000_REALK,      0.377635243850994_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.304726405407115_REALK,      0.000000000000000_REALK, &
      2.022018121161560_REALK,      0.000000000000000_REALK,     -0.104427821511752_REALK, &
      0.000000000000000_REALK,      3.572044493311453_REALK,      0.000000000000000_REALK, &
     -0.661783788519133_REALK,     -0.349971764091441_REALK,      0.000000000000000_REALK, &
     -0.852537515458102_REALK,      0.000000000000000_REALK,     -1.922031950313956_REALK, &
     -0.901325802514058_REALK,      0.000000000000000_REALK,     -1.068477919172139_REALK, &
      0.000000000000000_REALK,     -5.361627289466894_REALK,      0.000000000000000_REALK, &
     -5.042906354847614_REALK,      0.000000000000000_REALK,    -15.916810398367334_REALK, &
      0.021241045740971_REALK,     -0.119386215551941_REALK,      0.000000000000000_REALK, &
     -1.458520351427068_REALK,      0.000000000000000_REALK,     -2.411969169898526_REALK, &
     -2.305764171057128_REALK,      0.000000000000000_REALK,     -2.294975318512932_REALK, &
      0.000000000000000_REALK,    -17.554237244035143_REALK,      0.000000000000000_REALK, &
    -13.796115893657007_REALK,      0.000000000000000_REALK,    -31.940677848070713_REALK, &
    -76.932989074321185_REALK,     10.493857457267113_REALK,      0.000000000000000_REALK, &
    -16.288701362836548_REALK,      0.000000000000000_REALK,    -20.262302398185163_REALK, &
      8.394267776431033_REALK,      0.000000000000000_REALK,      3.353158886459320_REALK, &
      0.000000000000000_REALK,    -26.443791200788624_REALK,      0.000000000000000_REALK, &
    -10.640035731571464_REALK,      0.000000000000000_REALK,    -39.706963136879445_REALK, &
    -54.852023764542167_REALK,      8.413946054903008_REALK,      0.000000000000000_REALK, &
     -8.497953259782818_REALK,      0.000000000000000_REALK,    -12.421148546997424_REALK, &
      7.477662265506336_REALK,      0.000000000000000_REALK,      2.627441464657549_REALK, &
      0.000000000000000_REALK,     -4.117042392978672_REALK,      0.000000000000000_REALK, &
     -5.175858478403149_REALK,      0.000000000000000_REALK,    -22.696091065623708_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      9.686037774694951_REALK, &
      0.000000000000000_REALK,     -0.570414591964298_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.286545696426210_REALK,      0.000000000000000_REALK, &
      9.285095715581809_REALK,      0.000000000000000_REALK,     -1.137079413461499_REALK, &
      0.000000000000000_REALK,     -1.117811329175167_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.181868200336359_REALK, &
      0.000000000000000_REALK,     -0.516950386757141_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.833029778421974_REALK,      0.000000000000000_REALK, &
      7.664910005715956_REALK,      0.000000000000000_REALK,      0.025920767250379_REALK, &
      0.000000000000000_REALK,     -0.944578756936744_REALK,      0.000000000000000_REALK, &
     -6.521709204953400_REALK,     -0.365556902552061_REALK,      0.000000000000000_REALK, &
     -1.313598304364336_REALK,      0.000000000000000_REALK,     -5.152984915332024_REALK, &
     -0.169740130721466_REALK,      0.000000000000000_REALK,     -0.350425107628118_REALK, &
      0.000000000000000_REALK,     -1.842524771582911_REALK,      0.000000000000000_REALK, &
     -2.574189172733588_REALK,      0.000000000000000_REALK,    -16.830053667898309_REALK, &
     -7.557344711467164_REALK,     -0.239870561768506_REALK,      0.000000000000000_REALK, &
     -0.865949738761256_REALK,      0.000000000000000_REALK,     -5.134044006377011_REALK, &
      0.502301318230756_REALK,      0.000000000000000_REALK,     -0.224714725776265_REALK, &
      0.000000000000000_REALK,      1.451353459613150_REALK,      0.000000000000000_REALK, &
     -1.582275105624546_REALK,      0.000000000000000_REALK,    -15.634991383549012_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.850355084960003_REALK, &
      0.000000000000000_REALK,      0.641837884921946_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.849741864894825_REALK,      0.000000000000000_REALK, &
      4.553946688154857_REALK,      0.000000000000000_REALK,      0.957364924954402_REALK, &
      0.000000000000000_REALK,      2.096292969379025_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.237245947227545_REALK, &
      0.000000000000000_REALK,      1.030931299311498_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.359545375113903_REALK,      0.000000000000000_REALK, &
      6.615870618287523_REALK,      0.000000000000000_REALK,      2.275848204232404_REALK, &
      0.000000000000000_REALK,      3.139552750569590_REALK,      0.000000000000000_REALK, &
     -2.301197742148021_REALK,     -0.696369592475714_REALK,      0.000000000000000_REALK, &
     -0.773893935009694_REALK,      0.000000000000000_REALK,     -3.030401203076844_REALK, &
     -0.597355545298410_REALK,      0.000000000000000_REALK,     -1.112573663583049_REALK, &
      0.000000000000000_REALK,     -1.525263636645719_REALK,      0.000000000000000_REALK, &
     -2.527598406259827_REALK,      0.000000000000000_REALK,    -13.856539852041262_REALK, &
     -4.960199232138142_REALK,     -1.290291003373029_REALK,      0.000000000000000_REALK, &
     -0.846375864826927_REALK,      0.000000000000000_REALK,     -5.616143877349305_REALK, &
      0.058896618114082_REALK,      0.000000000000000_REALK,     -2.014610066201554_REALK, &
      0.000000000000000_REALK,      2.442985262970622_REALK,      0.000000000000000_REALK, &
     -2.577515762891006_REALK,      0.000000000000000_REALK,    -23.944419921388533_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.191855948697914_REALK, &
      0.000000000000000_REALK,      1.425681091163067_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.553294773230189_REALK,      0.000000000000000_REALK, &
      4.902628892665012_REALK,      0.000000000000000_REALK,      3.927943856562984_REALK, &
      0.000000000000000_REALK,      6.518941068246983_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.241132603505505_REALK, &
      0.000000000000000_REALK,      6.374280946765237_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      7.780920424112214_REALK,      0.000000000000000_REALK, &
     18.014336393209540_REALK,      0.000000000000000_REALK,     19.503211375689638_REALK, &
      0.000000000000000_REALK,     27.176736034456813_REALK,      0.000000000000000_REALK/
    ! results of test 4, ket-major order, 01 DPG Y
  data REF_CONTR_INTS(18901:20160)                                                         &
     /6.125010305613347_REALK,      1.526526627452819_REALK,      0.000000000000000_REALK, &
     -0.378040898133266_REALK,      0.000000000000000_REALK,     -0.186819708841098_REALK, &
     -0.625694281380857_REALK,      0.000000000000000_REALK,     -0.581725876772864_REALK, &
      0.000000000000000_REALK,      5.228858248575579_REALK,      0.000000000000000_REALK, &
     -1.225110290045886_REALK,      0.000000000000000_REALK,     -1.816269738127037_REALK, &
      4.015487146496454_REALK,     -2.404686710528524_REALK,      0.000000000000000_REALK, &
     -4.615081360686021_REALK,      0.000000000000000_REALK,      0.246210078173034_REALK, &
     -2.297448366986007_REALK,      0.000000000000000_REALK,     -0.054726487461306_REALK, &
      0.000000000000000_REALK,     29.796314817089719_REALK,      0.000000000000000_REALK, &
      1.222837649363857_REALK,      0.000000000000000_REALK,     -0.195711578873260_REALK, &
      3.597609631677719_REALK,      0.069458572728587_REALK,      0.000000000000000_REALK, &
     -1.411476390476078_REALK,      0.000000000000000_REALK,     -0.568640963971061_REALK, &
     -2.825410978087749_REALK,      0.000000000000000_REALK,     -0.721578005407454_REALK, &
      0.000000000000000_REALK,     -7.006234977351935_REALK,      0.000000000000000_REALK, &
     -1.323967309333940_REALK,      0.000000000000000_REALK,     -1.600158639830787_REALK, &
      4.012018007982169_REALK,      2.362453223479992_REALK,      0.000000000000000_REALK, &
      1.386429560163795_REALK,      0.000000000000000_REALK,      0.285573668679986_REALK, &
     -0.807617086034034_REALK,      0.000000000000000_REALK,     -0.079204755624388_REALK, &
      0.000000000000000_REALK,    -12.764922946676371_REALK,      0.000000000000000_REALK, &
     -0.790328084533787_REALK,      0.000000000000000_REALK,     -0.488370048604147_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.018242839451433_REALK, &
      0.000000000000000_REALK,      0.275109162523143_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.383500525517650_REALK,      0.000000000000000_REALK, &
      0.568553219014619_REALK,      0.000000000000000_REALK,      0.277557202373859_REALK, &
      0.000000000000000_REALK,      0.774158618882797_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.227425657817447_REALK, &
      0.000000000000000_REALK,      0.110981581569918_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.142922641869913_REALK,      0.000000000000000_REALK, &
      0.022874349601232_REALK,      0.000000000000000_REALK,     -2.655881540504323_REALK, &
      0.000000000000000_REALK,     -0.189793690139558_REALK,      0.000000000000000_REALK, &
      0.687919317305123_REALK,     -1.271453844675295_REALK,      0.000000000000000_REALK, &
     -1.836956443860142_REALK,      0.000000000000000_REALK,     -1.009169884293153_REALK, &
     -2.099410719243478_REALK,      0.000000000000000_REALK,     -0.739999993867358_REALK, &
      0.000000000000000_REALK,     -2.787885889093345_REALK,      0.000000000000000_REALK, &
     -0.922186877358269_REALK,      0.000000000000000_REALK,     -1.519867105337579_REALK, &
     10.003913794506699_REALK,      1.661402995575476_REALK,      0.000000000000000_REALK, &
     -0.041982854627732_REALK,      0.000000000000000_REALK,      0.306051183020202_REALK, &
      0.446378871204387_REALK,      0.000000000000000_REALK,     -0.048895339551035_REALK, &
      0.000000000000000_REALK,      6.345707767936749_REALK,      0.000000000000000_REALK, &
      0.017782502926040_REALK,      0.000000000000000_REALK,     -0.388898475758710_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.401431975673247_REALK, &
      0.000000000000000_REALK,      0.466020671086636_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.579933979137458_REALK,      0.000000000000000_REALK, &
      0.700913353906829_REALK,      0.000000000000000_REALK,      0.916059328049917_REALK, &
      0.000000000000000_REALK,      0.701853572342801_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.110613769937827_REALK, &
      0.000000000000000_REALK,     -0.286020214498008_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.158684745476271_REALK,      0.000000000000000_REALK, &
      0.098056589886589_REALK,      0.000000000000000_REALK,      1.235298436377402_REALK, &
      0.000000000000000_REALK,      0.363445173963312_REALK,      0.000000000000000_REALK, &
      0.083434368887774_REALK,     -0.194213258690062_REALK,      0.000000000000000_REALK, &
     -0.247678242580156_REALK,      0.000000000000000_REALK,     -0.367191836070511_REALK, &
     -0.121577664097999_REALK,      0.000000000000000_REALK,     -0.339102699263868_REALK, &
      0.000000000000000_REALK,      0.530688427688233_REALK,      0.000000000000000_REALK, &
     -0.373017486415646_REALK,      0.000000000000000_REALK,     -0.921686232216115_REALK, &
      0.900013134477735_REALK,     -0.431614277572459_REALK,      0.000000000000000_REALK, &
     -0.516115028220194_REALK,      0.000000000000000_REALK,      0.082602696364262_REALK, &
      0.533256877134342_REALK,      0.000000000000000_REALK,      0.038107418934206_REALK, &
      0.000000000000000_REALK,      5.326736101572913_REALK,      0.000000000000000_REALK, &
      0.655826080495000_REALK,      0.000000000000000_REALK,     -0.174938400785405_REALK, &
     -5.447888019187728_REALK,     -3.049745119143967_REALK,      0.000000000000000_REALK, &
     -2.643585626626974_REALK,      0.000000000000000_REALK,     -1.804407566462153_REALK, &
     -2.304244350402952_REALK,      0.000000000000000_REALK,     -0.848244779219342_REALK, &
      0.000000000000000_REALK,     -2.881996848028763_REALK,      0.000000000000000_REALK, &
     -0.825232648088093_REALK,      0.000000000000000_REALK,     -1.689814038142222_REALK, &
      2.286623802834840_REALK,      0.251800542158575_REALK,      0.000000000000000_REALK, &
     -0.576687243630558_REALK,      0.000000000000000_REALK,     -0.240184556331414_REALK, &
     -2.034142436527317_REALK,      0.000000000000000_REALK,     -0.273648215481434_REALK, &
      0.000000000000000_REALK,     -7.284996029720961_REALK,      0.000000000000000_REALK, &
     -0.478972632706933_REALK,      0.000000000000000_REALK,     -0.598462150249867_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.085455903245327_REALK, &
      0.000000000000000_REALK,      0.630338984087934_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.549546457116828_REALK,      0.000000000000000_REALK, &
      0.905714019070981_REALK,      0.000000000000000_REALK,      0.558242479420452_REALK, &
      0.000000000000000_REALK,      0.590307690955052_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.083071450373210_REALK, &
      0.000000000000000_REALK,      0.067796735520425_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.012384134357358_REALK,      0.000000000000000_REALK, &
      0.270837631530206_REALK,      0.000000000000000_REALK,     -0.514061762156444_REALK, &
      0.000000000000000_REALK,      0.168927514488026_REALK,      0.000000000000000_REALK, &
     -0.600867983008317_REALK,     -0.501248497738955_REALK,      0.000000000000000_REALK, &
     -0.493993240914949_REALK,      0.000000000000000_REALK,     -0.597044614995619_REALK, &
     -0.545894948842432_REALK,      0.000000000000000_REALK,     -0.418246185849738_REALK, &
      0.000000000000000_REALK,     -0.816040029684141_REALK,      0.000000000000000_REALK, &
     -0.462620933740671_REALK,      0.000000000000000_REALK,     -0.931879610209980_REALK, &
      0.431465910149976_REALK,      0.077634446042438_REALK,      0.000000000000000_REALK, &
     -0.220027262699579_REALK,      0.000000000000000_REALK,     -0.135962174547066_REALK, &
     -0.860289570661629_REALK,      0.000000000000000_REALK,     -0.253111380586589_REALK, &
      0.000000000000000_REALK,     -2.951600893914448_REALK,      0.000000000000000_REALK, &
     -0.548236700810560_REALK,      0.000000000000000_REALK,     -0.564622864565102_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.394948910277277_REALK, &
      0.000000000000000_REALK,      0.288850882063354_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.222287307632880_REALK,      0.000000000000000_REALK, &
      0.549248114372100_REALK,      0.000000000000000_REALK,      0.096984095621847_REALK, &
      0.000000000000000_REALK,      0.450844443824324_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.022420843873243_REALK, &
      0.000000000000000_REALK,     -0.052838545075483_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.456732009531477_REALK,      0.000000000000000_REALK, &
      0.121831030682150_REALK,      0.000000000000000_REALK,     -1.842338342776567_REALK, &
      0.000000000000000_REALK,     -0.219427578143391_REALK,      0.000000000000000_REALK, &
    -18.767030015943615_REALK,     -5.747235621585571_REALK,      0.000000000000000_REALK, &
     -3.920580208999155_REALK,      0.000000000000000_REALK,     -3.474417737013725_REALK, &
     -2.349821784379939_REALK,      0.000000000000000_REALK,     -1.054766502546106_REALK, &
      0.000000000000000_REALK,     -2.087675567915229_REALK,      0.000000000000000_REALK, &
     -0.829878908345569_REALK,      0.000000000000000_REALK,     -2.206315783651951_REALK, &
     25.609015582079945_REALK,      2.288391648190445_REALK,      0.000000000000000_REALK, &
      0.027338559469986_REALK,      0.000000000000000_REALK,      0.094701671392524_REALK, &
      1.019145323350461_REALK,      0.000000000000000_REALK,     -0.198528350286422_REALK, &
      0.000000000000000_REALK,      6.048946890990139_REALK,      0.000000000000000_REALK, &
     -0.076646369107207_REALK,      0.000000000000000_REALK,     -0.796516649158814_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.470787424146189_REALK, &
      0.000000000000000_REALK,      0.934694163973023_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.664341604489690_REALK,      0.000000000000000_REALK, &
      1.360360344430735_REALK,      0.000000000000000_REALK,      0.537453939758580_REALK, &
      0.000000000000000_REALK,      0.593547075497473_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.540267414548728_REALK, &
      0.000000000000000_REALK,     -0.039750739357995_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.320836354527851_REALK,      0.000000000000000_REALK, &
      0.400875543815360_REALK,      0.000000000000000_REALK,      0.828418731282950_REALK, &
      0.000000000000000_REALK,      0.334335447827321_REALK,      0.000000000000000_REALK, &
     -1.796932179794210_REALK,     -0.863127412997478_REALK,      0.000000000000000_REALK, &
     -0.605553819938487_REALK,      0.000000000000000_REALK,     -0.998020416504432_REALK, &
     -0.449405031819459_REALK,      0.000000000000000_REALK,     -0.475218666469700_REALK, &
      0.000000000000000_REALK,     -0.387501321145261_REALK,      0.000000000000000_REALK, &
     -0.384537223762088_REALK,      0.000000000000000_REALK,     -1.056267248217733_REALK, &
      3.546300909918005_REALK,      0.434770262209531_REALK,      0.000000000000000_REALK, &
     -0.001798946491018_REALK,      0.000000000000000_REALK,      0.039342467775107_REALK, &
      0.344340554157196_REALK,      0.000000000000000_REALK,     -0.113154874050917_REALK, &
      0.000000000000000_REALK,      1.799788134464568_REALK,      0.000000000000000_REALK, &
      0.015130575944143_REALK,      0.000000000000000_REALK,     -0.551502596541300_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.817537209333310_REALK, &
      0.000000000000000_REALK,      0.460872001331396_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.372426289851523_REALK,      0.000000000000000_REALK, &
      0.750196198456799_REALK,      0.000000000000000_REALK,      0.381982133403127_REALK, &
      0.000000000000000_REALK,      0.487769581239575_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.871904964518493_REALK, &
      0.000000000000000_REALK,     -0.036767513723920_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.367232389692836_REALK,      0.000000000000000_REALK, &
      0.378208542994105_REALK,      0.000000000000000_REALK,      1.051076830018077_REALK, &
      0.000000000000000_REALK,      0.515406898291712_REALK,      0.000000000000000_REALK, &
     -0.653823341998532_REALK,     -0.395525456732027_REALK,      0.000000000000000_REALK, &
     -0.244941854355939_REALK,      0.000000000000000_REALK,     -0.605225071410712_REALK, &
     -0.078075643086435_REALK,      0.000000000000000_REALK,     -0.362945797017886_REALK, &
      0.000000000000000_REALK,      0.221288612618828_REALK,      0.000000000000000_REALK, &
     -0.259237240236104_REALK,      0.000000000000000_REALK,     -0.896766413014506_REALK, &
      0.957140614153183_REALK,     -0.338845637933660_REALK,      0.000000000000000_REALK, &
     -0.066345892427611_REALK,      0.000000000000000_REALK,      0.017697442454875_REALK, &
      1.234077016807311_REALK,      0.000000000000000_REALK,      0.146981976520309_REALK, &
      0.000000000000000_REALK,      4.532353260644451_REALK,      0.000000000000000_REALK, &
      0.930036523200221_REALK,      0.000000000000000_REALK,     -0.347315774153125_REALK, &
    -95.825536181511211_REALK,    -14.843661089550148_REALK,      0.000000000000000_REALK, &
     -8.331184669062278_REALK,      0.000000000000000_REALK,     -9.144363169048457_REALK, &
     -3.326935719488370_REALK,      0.000000000000000_REALK,     -1.623138556807344_REALK, &
      0.000000000000000_REALK,     -2.732916382698531_REALK,      0.000000000000000_REALK, &
     -1.107299775373952_REALK,      0.000000000000000_REALK,     -3.646138581212685_REALK, &
    -41.747069360037564_REALK,    -10.563151440470984_REALK,      0.000000000000000_REALK, &
     -8.642554106596172_REALK,      0.000000000000000_REALK,     -6.523020625611365_REALK, &
     -9.268222487411494_REALK,      0.000000000000000_REALK,     -1.411537558633516_REALK, &
      0.000000000000000_REALK,    -17.562910944987326_REALK,      0.000000000000000_REALK, &
     -1.179462302241909_REALK,      0.000000000000000_REALK,     -2.670619181469660_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.140535253077488_REALK, &
      0.000000000000000_REALK,      1.807750950753940_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.004467375152874_REALK,      0.000000000000000_REALK, &
      2.670476622163287_REALK,      0.000000000000000_REALK,      0.535273380312941_REALK, &
      0.000000000000000_REALK,      0.720805852186395_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.801849988745179_REALK, &
      0.000000000000000_REALK,      1.246635418932144_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.223812022008376_REALK,      0.000000000000000_REALK, &
      2.325876670846853_REALK,      0.000000000000000_REALK,     -0.873363426966630_REALK, &
      0.000000000000000_REALK,      0.510390607846286_REALK,      0.000000000000000_REALK, &
     -8.144093866748010_REALK,     -2.189981564855834_REALK,      0.000000000000000_REALK, &
     -1.138606662462850_REALK,      0.000000000000000_REALK,     -2.331504366204616_REALK, &
     -0.650522555406447_REALK,      0.000000000000000_REALK,     -0.718416466497723_REALK, &
      0.000000000000000_REALK,     -0.528505208331461_REALK,      0.000000000000000_REALK, &
     -0.453997463145769_REALK,      0.000000000000000_REALK,     -1.549404054485053_REALK, &
     -5.370101286419571_REALK,     -2.435308937060642_REALK,      0.000000000000000_REALK, &
     -2.014654142133599_REALK,      0.000000000000000_REALK,     -2.517250814722013_REALK, &
     -2.419032675360167_REALK,      0.000000000000000_REALK,     -0.976279678723519_REALK, &
      0.000000000000000_REALK,     -4.181779009549561_REALK,      0.000000000000000_REALK, &
     -0.824828603926884_REALK,      0.000000000000000_REALK,     -1.717664942928355_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.338354509676310_REALK, &
      0.000000000000000_REALK,      0.814471254114432_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.465435489342546_REALK,      0.000000000000000_REALK, &
      1.278482896248534_REALK,      0.000000000000000_REALK,      0.307114205993017_REALK, &
      0.000000000000000_REALK,      0.541257859808647_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.410296385077646_REALK, &
      0.000000000000000_REALK,      0.710542719028107_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.044182194612159_REALK,      0.000000000000000_REALK, &
      1.610420855058760_REALK,      0.000000000000000_REALK,     -0.885254848936499_REALK, &
      0.000000000000000_REALK,      0.484844144965487_REALK,      0.000000000000000_REALK, &
     -2.694727886058624_REALK,     -1.079819715984769_REALK,      0.000000000000000_REALK, &
     -0.638296701629870_REALK,      0.000000000000000_REALK,     -1.285751763768199_REALK, &
     -0.462342863562646_REALK,      0.000000000000000_REALK,     -0.590385688827645_REALK, &
      0.000000000000000_REALK,     -0.448940191787528_REALK,      0.000000000000000_REALK, &
     -0.424180847269733_REALK,      0.000000000000000_REALK,     -1.196227051773186_REALK, &
     -3.039873418972627_REALK,     -2.252543127788453_REALK,      0.000000000000000_REALK, &
     -2.305992586498073_REALK,      0.000000000000000_REALK,     -2.374916049818298_REALK, &
     -3.069207757036195_REALK,      0.000000000000000_REALK,     -1.505019238450609_REALK, &
      0.000000000000000_REALK,     -5.082889247591779_REALK,      0.000000000000000_REALK, &
     -1.573511308970552_REALK,      0.000000000000000_REALK,     -2.268758450385001_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.418037899524393_REALK, &
      0.000000000000000_REALK,      0.622048205026827_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.313775115409251_REALK,      0.000000000000000_REALK, &
      1.085426555546161_REALK,      0.000000000000000_REALK,      0.088925495696710_REALK, &
      0.000000000000000_REALK,      0.578736044801720_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.084224858947345_REALK, &
      0.000000000000000_REALK,     -0.922956029254839_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.715762758545443_REALK,      0.000000000000000_REALK, &
      1.014183014721643_REALK,      0.000000000000000_REALK,     -5.287752923186198_REALK, &
      0.000000000000000_REALK,     -0.881700340888221_REALK,      0.000000000000000_REALK, &
     12.196470677603802_REALK,      9.485251141322676_REALK,      0.000000000000000_REALK, &
      1.887554333287562_REALK,      0.000000000000000_REALK,      2.133113313415193_REALK, &
      4.791581974388441_REALK,      0.000000000000000_REALK,      3.762072875716271_REALK, &
      0.000000000000000_REALK,     -1.202589008034607_REALK,      0.000000000000000_REALK, &
     -1.949457669352500_REALK,      0.000000000000000_REALK,     -6.609209655743959_REALK, &
      7.718123970510762_REALK,      0.247059235988823_REALK,      0.000000000000000_REALK, &
     -1.384114117709561_REALK,      0.000000000000000_REALK,      1.475499225103872_REALK, &
    -19.851051232017987_REALK,      0.000000000000000_REALK,      0.108700170577459_REALK, &
      0.000000000000000_REALK,      9.817995107079120_REALK,      0.000000000000000_REALK, &
      0.447815220284777_REALK,      0.000000000000000_REALK,     -1.432145663567083_REALK, &
     16.040956433762993_REALK,      3.907878883525767_REALK,      0.000000000000000_REALK, &
      1.623681096305448_REALK,      0.000000000000000_REALK,      1.982442054403109_REALK, &
      2.451149418023364_REALK,      0.000000000000000_REALK,      1.246229879329810_REALK, &
      0.000000000000000_REALK,     -6.292725203325231_REALK,      0.000000000000000_REALK, &
     -2.596271019140700_REALK,      0.000000000000000_REALK,     -9.509792652049752_REALK, &
      5.086264889959623_REALK,      2.538126357596823_REALK,      0.000000000000000_REALK, &
      2.147995315479286_REALK,      0.000000000000000_REALK,      1.910689975908394_REALK, &
      6.172094010466399_REALK,      0.000000000000000_REALK,      1.067031938133843_REALK, &
      0.000000000000000_REALK,     -7.747836629812920_REALK,      0.000000000000000_REALK, &
     -1.004280667512006_REALK,      0.000000000000000_REALK,     -2.679990487761776_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.661206628599405_REALK, &
      0.000000000000000_REALK,     -0.335792616606121_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.315348867276547_REALK,      0.000000000000000_REALK, &
     -4.459402515348538_REALK,      0.000000000000000_REALK,      0.683867794878888_REALK, &
      0.000000000000000_REALK,      1.610800250590388_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.492208977907052_REALK, &
      0.000000000000000_REALK,     -0.021687910344786_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.982837115158970_REALK,      0.000000000000000_REALK, &
     -3.143184618809053_REALK,      0.000000000000000_REALK,     -1.851794400515797_REALK, &
      0.000000000000000_REALK,      0.030420106954203_REALK,      0.000000000000000_REALK, &
     17.798648900697565_REALK,      0.522598891989673_REALK,      0.000000000000000_REALK, &
      0.811238582204664_REALK,      0.000000000000000_REALK,      1.133096575467665_REALK, &
     -0.036777239927522_REALK,      0.000000000000000_REALK,      0.104396461374029_REALK, &
      0.000000000000000_REALK,     -5.637192850558444_REALK,      0.000000000000000_REALK, &
     -2.866847320190786_REALK,      0.000000000000000_REALK,    -12.012797291034046_REALK, &
     19.170613296334363_REALK,     -0.351436784729379_REALK,      0.000000000000000_REALK, &
      0.885363669415538_REALK,      0.000000000000000_REALK,      2.595001820899849_REALK, &
     -2.241850911220531_REALK,      0.000000000000000_REALK,     -0.077790183313322_REALK, &
      0.000000000000000_REALK,      4.020908516976587_REALK,      0.000000000000000_REALK, &
     -0.384910915982334_REALK,      0.000000000000000_REALK,     -3.384522865675387_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.238695491278637_REALK, &
      0.000000000000000_REALK,     -0.101760130060319_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.529892341300229_REALK,      0.000000000000000_REALK, &
     -1.940924601678215_REALK,      0.000000000000000_REALK,      0.707302587225063_REALK, &
      0.000000000000000_REALK,      1.078834621152521_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.730179659476875_REALK, &
      0.000000000000000_REALK,     -0.436022541324615_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.928218953772382_REALK,      0.000000000000000_REALK, &
     -2.477014690358394_REALK,      0.000000000000000_REALK,      1.096484725899582_REALK, &
      0.000000000000000_REALK,      0.568681011773365_REALK,      0.000000000000000_REALK, &
      1.906579955064894_REALK,      0.548580994330421_REALK,      0.000000000000000_REALK, &
      0.107403998274168_REALK,      0.000000000000000_REALK,      0.364129754453664_REALK, &
      0.139575685395177_REALK,      0.000000000000000_REALK,      0.328760252631422_REALK, &
      0.000000000000000_REALK,     -0.234142276477971_REALK,      0.000000000000000_REALK, &
     -1.138669454526974_REALK,      0.000000000000000_REALK,     -6.434016044455413_REALK, &
      3.162849293958256_REALK,      0.042340621997673_REALK,      0.000000000000000_REALK, &
     -0.401617909778080_REALK,      0.000000000000000_REALK,      1.284403302625096_REALK, &
     -1.711544109782220_REALK,      0.000000000000000_REALK,      0.028116163901300_REALK, &
      0.000000000000000_REALK,      3.828032034662888_REALK,      0.000000000000000_REALK, &
      0.523808880580021_REALK,      0.000000000000000_REALK,     -2.791964865864213_REALK, &
     15.483618731499572_REALK,     -0.939241863231658_REALK,      0.000000000000000_REALK, &
     -0.719797845479100_REALK,      0.000000000000000_REALK,     -0.983364030456936_REALK, &
      0.164174775117642_REALK,      0.000000000000000_REALK,      0.060330214317387_REALK, &
      0.000000000000000_REALK,     -8.681705620034421_REALK,      0.000000000000000_REALK, &
     -3.816031369625959_REALK,      0.000000000000000_REALK,    -15.640007864240447_REALK, &
     10.400675879651921_REALK,     -1.028220143294198_REALK,      0.000000000000000_REALK, &
      1.473916876023377_REALK,      0.000000000000000_REALK,      1.908609507937329_REALK, &
      0.135131100953478_REALK,      0.000000000000000_REALK,     -0.155276556580841_REALK, &
      0.000000000000000_REALK,     -7.291180366592196_REALK,      0.000000000000000_REALK, &
     -1.380523667132851_REALK,      0.000000000000000_REALK,     -5.363017358477843_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.739027517899468_REALK, &
      0.000000000000000_REALK,      0.014753364908458_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.079973398384761_REALK,      0.000000000000000_REALK, &
      0.335108262203272_REALK,      0.000000000000000_REALK,     -0.027554074804188_REALK, &
      0.000000000000000_REALK,      0.234646312093679_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.278729987164502_REALK, &
      0.000000000000000_REALK,      0.028890237976795_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.117407727309712_REALK,      0.000000000000000_REALK, &
     -1.032366506604709_REALK,      0.000000000000000_REALK,     -0.779837143717459_REALK, &
      0.000000000000000_REALK,     -0.081178914343539_REALK,      0.000000000000000_REALK, &
      1.439629928203007_REALK,      0.156177037537057_REALK,      0.000000000000000_REALK, &
     -0.074884674925816_REALK,      0.000000000000000_REALK,     -0.274292524205102_REALK, &
     -0.019730869931001_REALK,      0.000000000000000_REALK,     -0.030095104940211_REALK, &
      0.000000000000000_REALK,     -0.962239285767051_REALK,      0.000000000000000_REALK, &
     -1.191010519478355_REALK,      0.000000000000000_REALK,     -7.270853083228272_REALK, &
      1.671006469814825_REALK,      0.382881288172483_REALK,      0.000000000000000_REALK, &
      0.344728156264204_REALK,      0.000000000000000_REALK,      0.919930264057061_REALK, &
      0.334456037364217_REALK,      0.000000000000000_REALK,      0.173462332150546_REALK, &
      0.000000000000000_REALK,     -2.490995675809925_REALK,      0.000000000000000_REALK, &
     -0.968654446240815_REALK,      0.000000000000000_REALK,     -4.308199201399210_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.558850566483746_REALK, &
      0.000000000000000_REALK,      0.046460578362812_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.031764253810832_REALK,      0.000000000000000_REALK, &
      0.179482920040169_REALK,      0.000000000000000_REALK,      0.313716762090114_REALK, &
      0.000000000000000_REALK,      1.231561233456084_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.127863686927982_REALK, &
      0.000000000000000_REALK,     -0.010441968787134_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.159775178255446_REALK,      0.000000000000000_REALK, &
     -0.851621079108930_REALK,      0.000000000000000_REALK,     -1.786103165788589_REALK, &
      0.000000000000000_REALK,      0.048901621511362_REALK,      0.000000000000000_REALK, &
      1.267272063040218_REALK,      1.494837662224426_REALK,      0.000000000000000_REALK, &
     -5.243373075197963_REALK,      0.000000000000000_REALK,     -6.397468247875034_REALK, &
      3.659563964654336_REALK,      0.000000000000000_REALK,      1.483925250596372_REALK, &
      0.000000000000000_REALK,    -15.362951809022160_REALK,      0.000000000000000_REALK, &
     -6.055551401615715_REALK,      0.000000000000000_REALK,    -22.165234435706669_REALK, &
     65.745229185517289_REALK,     -8.028002341466729_REALK,      0.000000000000000_REALK, &
      2.611979312498721_REALK,      0.000000000000000_REALK,      3.862393921807465_REALK, &
     -0.093042350838135_REALK,      0.000000000000000_REALK,     -0.030661919691394_REALK, &
      0.000000000000000_REALK,      0.078834177331667_REALK,      0.000000000000000_REALK, &
     -1.986634374797539_REALK,      0.000000000000000_REALK,     -8.813045911988491_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.167683167013367_REALK, &
      0.000000000000000_REALK,     -0.281801660744016_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.848475364225039_REALK,      0.000000000000000_REALK, &
      3.477477013087186_REALK,      0.000000000000000_REALK,     -0.885641676713466_REALK, &
      0.000000000000000_REALK,     -0.976354963049222_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.598495038828905_REALK, &
      0.000000000000000_REALK,      0.225716265957958_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.019462232405499_REALK,      0.000000000000000_REALK, &
     -0.075606302673676_REALK,      0.000000000000000_REALK,      0.149403404349347_REALK, &
      0.000000000000000_REALK,     -0.515029760102561_REALK,      0.000000000000000_REALK, &
      0.103355664361697_REALK,     -0.017518696359483_REALK,      0.000000000000000_REALK, &
     -0.373554722706720_REALK,      0.000000000000000_REALK,     -1.565286413887444_REALK, &
      0.006126509818932_REALK,      0.000000000000000_REALK,     -0.052172426228577_REALK, &
      0.000000000000000_REALK,     -0.848311774128095_REALK,      0.000000000000000_REALK, &
     -1.294250738346391_REALK,      0.000000000000000_REALK,     -9.038716301136249_REALK, &
      8.514855762671884_REALK,     -0.099880091327057_REALK,      0.000000000000000_REALK, &
      0.170668608233602_REALK,      0.000000000000000_REALK,      1.500689596047032_REALK, &
     -0.010993923603636_REALK,      0.000000000000000_REALK,     -0.001144437386330_REALK, &
      0.000000000000000_REALK,      1.356019154749366_REALK,      0.000000000000000_REALK, &
     -0.389424359748899_REALK,      0.000000000000000_REALK,     -5.707015984280553_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.325705184887714_REALK, &
      0.000000000000000_REALK,      0.140573850903305_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.264815193175234_REALK,      0.000000000000000_REALK, &
      1.616637579848706_REALK,      0.000000000000000_REALK,      0.319314840836878_REALK, &
      0.000000000000000_REALK,      0.811740999219181_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.180407127914402_REALK, &
      0.000000000000000_REALK,     -0.252151842876526_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.013655816558735_REALK,      0.000000000000000_REALK, &
     -0.060735774476763_REALK,      0.000000000000000_REALK,      1.109342044166631_REALK, &
      0.000000000000000_REALK,      0.958915555590373_REALK,      0.000000000000000_REALK, &
      0.033214179179641_REALK,     -0.055169025512100_REALK,      0.000000000000000_REALK, &
     -0.148370423965281_REALK,      0.000000000000000_REALK,     -0.838362427761651_REALK, &
     -0.069753342725796_REALK,      0.000000000000000_REALK,     -0.273831440286224_REALK, &
      0.000000000000000_REALK,     -0.105704552898740_REALK,      0.000000000000000_REALK, &
     -0.856762160460376_REALK,      0.000000000000000_REALK,     -6.777550807810189_REALK, &
      4.214451325186249_REALK,      0.036100249396731_REALK,      0.000000000000000_REALK, &
     -0.232255643882795_REALK,      0.000000000000000_REALK,      1.237950752002137_REALK, &
     -0.025179977526187_REALK,      0.000000000000000_REALK,      0.000689401236298_REALK, &
      0.000000000000000_REALK,      3.872919323143573_REALK,      0.000000000000000_REALK, &
      0.883251723454303_REALK,      0.000000000000000_REALK,     -6.590974340898721_REALK, &
   -118.878121195720169_REALK,     27.038546248188307_REALK,      0.000000000000000_REALK, &
    -24.561798689294921_REALK,      0.000000000000000_REALK,    -25.238845833165175_REALK, &
     17.718126065216900_REALK,      0.000000000000000_REALK,      7.102701009548072_REALK, &
      0.000000000000000_REALK,    -34.292040172232078_REALK,      0.000000000000000_REALK, &
    -11.749804817351496_REALK,      0.000000000000000_REALK,    -36.221066230483238_REALK, &
    -48.379974085677411_REALK,     17.950923620607668_REALK,      0.000000000000000_REALK, &
    -17.894833871513892_REALK,      0.000000000000000_REALK,    -17.867762444995787_REALK, &
     11.500697004545216_REALK,      0.000000000000000_REALK,      6.074333313954447_REALK, &
      0.000000000000000_REALK,    -33.390489491382411_REALK,      0.000000000000000_REALK, &
     -8.500045899571683_REALK,      0.000000000000000_REALK,    -25.461560916786315_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     13.232232969955456_REALK, &
      0.000000000000000_REALK,     -2.354037648381481_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.848891797259034_REALK,      0.000000000000000_REALK, &
     10.427845522269001_REALK,      0.000000000000000_REALK,     -2.777161952416411_REALK, &
      0.000000000000000_REALK,     -3.378353912643379_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      9.853395923764094_REALK, &
      0.000000000000000_REALK,     -2.464419918671608_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.254815033235516_REALK,      0.000000000000000_REALK, &
     10.002740646713931_REALK,      0.000000000000000_REALK,     -3.552136475634689_REALK, &
      0.000000000000000_REALK,     -3.511798305857403_REALK,      0.000000000000000_REALK, &
     -8.661175413930961_REALK,      0.582865765300788_REALK,      0.000000000000000_REALK, &
     -1.345986228286918_REALK,      0.000000000000000_REALK,     -5.516525719134784_REALK, &
      0.416658556878326_REALK,      0.000000000000000_REALK,      0.459335485898430_REALK, &
      0.000000000000000_REALK,     -1.464887323002487_REALK,      0.000000000000000_REALK, &
     -1.931667424190797_REALK,      0.000000000000000_REALK,    -13.194901010646218_REALK, &
     -5.484633044455870_REALK,      0.575827266701116_REALK,      0.000000000000000_REALK, &
     -1.564256696405999_REALK,      0.000000000000000_REALK,     -6.076777976116563_REALK, &
     -0.169571737214002_REALK,      0.000000000000000_REALK,      0.584554893630735_REALK, &
      0.000000000000000_REALK,     -3.924240432822955_REALK,      0.000000000000000_REALK, &
     -2.229065742710666_REALK,      0.000000000000000_REALK,    -14.432347371696304_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.237567376773539_REALK, &
      0.000000000000000_REALK,      0.082764179327845_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.608892579309571_REALK,      0.000000000000000_REALK, &
      4.252350119790576_REALK,      0.000000000000000_REALK,     -0.013947817391287_REALK, &
      0.000000000000000_REALK,      0.197962487452986_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.828425853985722_REALK, &
      0.000000000000000_REALK,     -0.091982965154504_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.441993711479708_REALK,      0.000000000000000_REALK, &
      6.477420102822194_REALK,      0.000000000000000_REALK,     -1.259165853754713_REALK, &
      0.000000000000000_REALK,     -0.218459537374248_REALK,      0.000000000000000_REALK, &
     -2.415886277400635_REALK,     -0.290756573157540_REALK,      0.000000000000000_REALK, &
     -0.420091870764638_REALK,      0.000000000000000_REALK,     -2.564566999060593_REALK, &
     -0.150224706301813_REALK,      0.000000000000000_REALK,     -0.381891279720183_REALK, &
      0.000000000000000_REALK,     -0.487083596164206_REALK,      0.000000000000000_REALK, &
     -1.004811892907474_REALK,      0.000000000000000_REALK,     -8.587812905241874_REALK, &
     -2.643537037754317_REALK,     -0.643267359846735_REALK,      0.000000000000000_REALK, &
     -1.097572059146615_REALK,      0.000000000000000_REALK,     -4.881574731881197_REALK, &
     -1.259094854050361_REALK,      0.000000000000000_REALK,     -1.088361923954382_REALK, &
      0.000000000000000_REALK,     -4.022091948427254_REALK,      0.000000000000000_REALK, &
     -2.606733582390159_REALK,      0.000000000000000_REALK,    -16.231235621841748_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.734030795867471_REALK, &
      0.000000000000000_REALK,      0.434394872305890_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.403071913564509_REALK,      0.000000000000000_REALK, &
      3.188563290326456_REALK,      0.000000000000000_REALK,      0.264671326069089_REALK, &
      0.000000000000000_REALK,      1.454632260231808_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.158149878169418_REALK, &
      0.000000000000000_REALK,      0.055409907657091_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.002484045097078_REALK,      0.000000000000000_REALK, &
      7.480706171231200_REALK,      0.000000000000000_REALK,     -4.806559368971300_REALK, &
      0.000000000000000_REALK,      0.184237938854650_REALK,      0.000000000000000_REALK/
    ! results of test 4, ket-major order, 01 DPG Z
  data REF_CONTR_INTS(20161:21420)                                                         &
     /0.000000000000000_REALK,      0.000000000000000_REALK,     -1.037176255026364_REALK, &
      0.000000000000000_REALK,      0.405292584142349_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.514717032660308_REALK,      0.000000000000000_REALK, &
      1.185735490241599_REALK,      0.000000000000000_REALK,     10.983410249385265_REALK, &
      0.000000000000000_REALK,      3.940273005623677_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.222623349730048_REALK, &
      0.000000000000000_REALK,     -3.328656364805943_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.985886441557696_REALK,      0.000000000000000_REALK, &
     -0.356573473807706_REALK,      0.000000000000000_REALK,      9.079686127072153_REALK, &
      0.000000000000000_REALK,      2.645937962884116_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.032697706704399_REALK, &
      0.000000000000000_REALK,      0.641200989988218_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.338920020727160_REALK,      0.000000000000000_REALK, &
      1.019051143363653_REALK,      0.000000000000000_REALK,      3.149169632183911_REALK, &
      0.000000000000000_REALK,      1.804342931667368_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.052957329155276_REALK, &
      0.000000000000000_REALK,     -0.361100927745660_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.086650404022144_REALK,      0.000000000000000_REALK, &
      0.105905878401861_REALK,      0.000000000000000_REALK,      0.114502321697554_REALK, &
      0.000000000000000_REALK,      0.617531996032063_REALK,      0.000000000000000_REALK, &
      1.182576191227907_REALK,      0.039576592797572_REALK,      0.000000000000000_REALK, &
     -1.189257216260955_REALK,      0.000000000000000_REALK,     -0.560756725322195_REALK, &
     -3.438175025415405_REALK,      0.000000000000000_REALK,     -1.233437332636469_REALK, &
      0.000000000000000_REALK,    -11.208885213534776_REALK,      0.000000000000000_REALK, &
     -3.346576012202185_REALK,      0.000000000000000_REALK,     -2.629953918553770_REALK, &
      3.386303076911913_REALK,      3.074698927970761_REALK,      0.000000000000000_REALK, &
      1.999310418191411_REALK,      0.000000000000000_REALK,      0.723106669271229_REALK, &
     -1.061214241568240_REALK,      0.000000000000000_REALK,     -0.309251554428360_REALK, &
      0.000000000000000_REALK,    -13.737409943433455_REALK,      0.000000000000000_REALK, &
     -3.419094381565956_REALK,      0.000000000000000_REALK,     -2.061018912389679_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.614954033263752_REALK, &
      0.000000000000000_REALK,      0.798706560988433_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.069773444363220_REALK,      0.000000000000000_REALK, &
      1.073729847331026_REALK,      0.000000000000000_REALK,      1.790544978915900_REALK, &
      0.000000000000000_REALK,      1.202897398899181_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.739353607393787_REALK, &
      0.000000000000000_REALK,     -0.435752254341489_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.204103501564695_REALK,      0.000000000000000_REALK, &
      0.153568313273767_REALK,      0.000000000000000_REALK,      1.270577069320656_REALK, &
      0.000000000000000_REALK,      0.553709303945545_REALK,      0.000000000000000_REALK, &
      0.149544292719455_REALK,     -0.452655711641119_REALK,      0.000000000000000_REALK, &
     -0.864722042405199_REALK,      0.000000000000000_REALK,     -0.658139375290093_REALK, &
     -1.379422635963754_REALK,      0.000000000000000_REALK,     -0.790351671611005_REALK, &
      0.000000000000000_REALK,     -2.581881051346937_REALK,      0.000000000000000_REALK, &
     -1.302320459584989_REALK,      0.000000000000000_REALK,     -1.651992069256438_REALK, &
      4.166967946268559_REALK,      1.404343980820811_REALK,      0.000000000000000_REALK, &
      0.312907564064518_REALK,      0.000000000000000_REALK,      0.382441960944239_REALK, &
     -0.022990163364543_REALK,      0.000000000000000_REALK,     -0.123990162479936_REALK, &
      0.000000000000000_REALK,      1.094183994328032_REALK,      0.000000000000000_REALK, &
     -0.397610862069530_REALK,      0.000000000000000_REALK,     -0.809946744907529_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.395866098963643_REALK, &
      0.000000000000000_REALK,      0.796597580845027_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.465892042469503_REALK,      0.000000000000000_REALK, &
      1.151991918669302_REALK,      0.000000000000000_REALK,      3.344192042778519_REALK, &
      0.000000000000000_REALK,      1.999535258568593_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.812206838742024_REALK, &
      0.000000000000000_REALK,     -1.116753599378652_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.686497332330274_REALK,      0.000000000000000_REALK, &
      0.413818347006185_REALK,      0.000000000000000_REALK,      4.869571171561737_REALK, &
      0.000000000000000_REALK,      2.365093360695289_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.571590952985113_REALK, &
      0.000000000000000_REALK,      1.015734756136780_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.953687191817896_REALK,      0.000000000000000_REALK, &
      1.311349410057085_REALK,      0.000000000000000_REALK,      1.095481896694511_REALK, &
      0.000000000000000_REALK,      0.951227916492390_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.133408395656685_REALK, &
      0.000000000000000_REALK,      0.155496844475218_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.205734571450842_REALK,      0.000000000000000_REALK, &
      0.434951042067678_REALK,      0.000000000000000_REALK,     -0.012631045410876_REALK, &
      0.000000000000000_REALK,      0.387447791494563_REALK,      0.000000000000000_REALK, &
     -0.920470246522629_REALK,     -0.859083059333373_REALK,      0.000000000000000_REALK, &
     -0.911243123935797_REALK,      0.000000000000000_REALK,     -0.914613225352063_REALK, &
     -1.067015453841988_REALK,      0.000000000000000_REALK,     -0.716826513226642_REALK, &
      0.000000000000000_REALK,     -1.590713823322313_REALK,      0.000000000000000_REALK, &
     -0.853372293270961_REALK,      0.000000000000000_REALK,     -1.427547279595224_REALK, &
      0.675727068762002_REALK,      0.118276202739442_REALK,      0.000000000000000_REALK, &
     -0.283003477252290_REALK,      0.000000000000000_REALK,     -0.212932979194721_REALK, &
     -0.884858402851917_REALK,      0.000000000000000_REALK,     -0.385615593232347_REALK, &
      0.000000000000000_REALK,     -2.519783353857010_REALK,      0.000000000000000_REALK, &
     -0.705153037778570_REALK,      0.000000000000000_REALK,     -0.884266738700080_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.707890000668413_REALK, &
      0.000000000000000_REALK,      0.673229018762370_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.776074364282725_REALK,      0.000000000000000_REALK, &
      0.984449476710864_REALK,      0.000000000000000_REALK,      1.100383510588043_REALK, &
      0.000000000000000_REALK,      1.050789806706369_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.103806193675505_REALK, &
      0.000000000000000_REALK,      0.171920848284790_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.276905133000340_REALK,      0.000000000000000_REALK, &
      0.564065101125412_REALK,      0.000000000000000_REALK,      0.079428247978366_REALK, &
      0.000000000000000_REALK,      0.713951819029034_REALK,      0.000000000000000_REALK, &
     -0.592536914944883_REALK,     -0.856814655388589_REALK,      0.000000000000000_REALK, &
     -1.248660687149191_REALK,      0.000000000000000_REALK,     -0.981277596904516_REALK, &
     -1.992859510527652_REALK,      0.000000000000000_REALK,     -1.191556228141439_REALK, &
      0.000000000000000_REALK,     -3.916611012311292_REALK,      0.000000000000000_REALK, &
     -1.948935481871239_REALK,      0.000000000000000_REALK,     -2.144237777481718_REALK, &
      1.092523266009695_REALK,      0.303120348349589_REALK,      0.000000000000000_REALK, &
     -0.951875546889169_REALK,      0.000000000000000_REALK,     -0.573787466926058_REALK, &
     -3.391278713809702_REALK,      0.000000000000000_REALK,     -1.647104126363193_REALK, &
      0.000000000000000_REALK,     -9.529399818194314_REALK,      0.000000000000000_REALK, &
     -3.952942792982375_REALK,      0.000000000000000_REALK,     -3.335949384667079_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.436198003341311_REALK, &
      0.000000000000000_REALK,      1.431088721697671_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.050902714474644_REALK,      0.000000000000000_REALK, &
      1.891893836626964_REALK,      0.000000000000000_REALK,      0.900476209232832_REALK, &
      0.000000000000000_REALK,      0.908766266315947_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.174629137278980_REALK, &
      0.000000000000000_REALK,     -0.057159798922513_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.398930289205531_REALK,      0.000000000000000_REALK, &
      0.565976810110501_REALK,      0.000000000000000_REALK,      0.823645212540073_REALK, &
      0.000000000000000_REALK,      0.480759535020686_REALK,      0.000000000000000_REALK, &
     -2.601710809669004_REALK,     -1.390852437319123_REALK,      0.000000000000000_REALK, &
     -1.050882804452259_REALK,      0.000000000000000_REALK,     -1.444996386111416_REALK, &
     -0.881901852314683_REALK,      0.000000000000000_REALK,     -0.765772272512515_REALK, &
      0.000000000000000_REALK,     -0.914634214868983_REALK,      0.000000000000000_REALK, &
     -0.667328886083880_REALK,      0.000000000000000_REALK,     -1.529329792458906_REALK, &
      5.695173405333668_REALK,      0.997177863009019_REALK,      0.000000000000000_REALK, &
      0.029885454623862_REALK,      0.000000000000000_REALK,      0.063181941370612_REALK, &
      0.008460814432337_REALK,      0.000000000000000_REALK,     -0.259529101465473_REALK, &
      0.000000000000000_REALK,      0.847512794114034_REALK,      0.000000000000000_REALK, &
     -0.251360528547813_REALK,      0.000000000000000_REALK,     -0.885684266670732_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.252386044683027_REALK, &
      0.000000000000000_REALK,      0.789882325135796_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.686995018740651_REALK,      0.000000000000000_REALK, &
      1.149226284743335_REALK,      0.000000000000000_REALK,      0.746628706305016_REALK, &
      0.000000000000000_REALK,      0.835981725613633_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.365507151441756_REALK, &
      0.000000000000000_REALK,     -0.056015365976313_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.472341663335792_REALK,      0.000000000000000_REALK, &
      0.592319680712018_REALK,      0.000000000000000_REALK,      1.081094316148885_REALK, &
      0.000000000000000_REALK,      0.785223234056877_REALK,      0.000000000000000_REALK, &
     -1.171885765375143_REALK,     -0.921857026120618_REALK,      0.000000000000000_REALK, &
     -0.855168457118866_REALK,      0.000000000000000_REALK,     -1.084780246398668_REALK, &
     -0.885847825666758_REALK,      0.000000000000000_REALK,     -0.845923131841726_REALK, &
      0.000000000000000_REALK,     -1.076603230803922_REALK,      0.000000000000000_REALK, &
     -0.905078110653598_REALK,      0.000000000000000_REALK,     -1.607326821746578_REALK, &
      4.431462282561592_REALK,      1.102502527803049_REALK,      0.000000000000000_REALK, &
      0.040223846332863_REALK,      0.000000000000000_REALK,      0.081937332484810_REALK, &
     -0.053204437556050_REALK,      0.000000000000000_REALK,     -0.478235463331698_REALK, &
      0.000000000000000_REALK,      0.931006961837894_REALK,      0.000000000000000_REALK, &
     -0.563857758548850_REALK,      0.000000000000000_REALK,     -1.608036197126548_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.343670017290922_REALK, &
      0.000000000000000_REALK,      1.312994408895168_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.568962313928001_REALK,      0.000000000000000_REALK, &
      1.726187601520518_REALK,      0.000000000000000_REALK,      2.324124598875854_REALK, &
      0.000000000000000_REALK,      1.945473414755471_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.679612676525239_REALK, &
      0.000000000000000_REALK,     -0.239261954284453_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.647850145821596_REALK,      0.000000000000000_REALK, &
      2.234561572792175_REALK,      0.000000000000000_REALK,      6.905609850796157_REALK, &
      0.000000000000000_REALK,      4.695562711368018_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     11.013928485739193_REALK, &
      0.000000000000000_REALK,      2.709971475421305_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.528063754898805_REALK,      0.000000000000000_REALK, &
      3.613084106260162_REALK,      0.000000000000000_REALK,      0.891734735361352_REALK, &
      0.000000000000000_REALK,      1.080548898578759_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.127780505838524_REALK, &
      0.000000000000000_REALK,      2.184553824328145_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.881038873548392_REALK,      0.000000000000000_REALK, &
      3.258308143258674_REALK,      0.000000000000000_REALK,     -0.215492729731458_REALK, &
      0.000000000000000_REALK,      0.894387996152756_REALK,      0.000000000000000_REALK, &
    -11.326235033600346_REALK,     -3.353030369708668_REALK,      0.000000000000000_REALK, &
     -1.801128853310727_REALK,      0.000000000000000_REALK,     -3.242492886939606_REALK, &
     -1.089916812175532_REALK,      0.000000000000000_REALK,     -1.099950916903829_REALK, &
      0.000000000000000_REALK,     -0.890571133297543_REALK,      0.000000000000000_REALK, &
     -0.718165418453625_REALK,      0.000000000000000_REALK,     -2.154802580893928_REALK, &
     -7.581786524393091_REALK,     -3.501866164121771_REALK,      0.000000000000000_REALK, &
     -2.505035817257145_REALK,      0.000000000000000_REALK,     -3.553984792398893_REALK, &
     -2.405093712635869_REALK,      0.000000000000000_REALK,     -1.403846847360554_REALK, &
      0.000000000000000_REALK,     -3.504844542754003_REALK,      0.000000000000000_REALK, &
     -1.025597968764424_REALK,      0.000000000000000_REALK,     -2.425088135795570_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.385615925337731_REALK, &
      0.000000000000000_REALK,      1.312447399831028_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.807720364775488_REALK,      0.000000000000000_REALK, &
      1.851067507471361_REALK,      0.000000000000000_REALK,      0.602673686231004_REALK, &
      0.000000000000000_REALK,      0.872188511448876_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.870809674631776_REALK, &
      0.000000000000000_REALK,      1.629682459274541_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.733987908399045_REALK,      0.000000000000000_REALK, &
      2.586251493626753_REALK,      0.000000000000000_REALK,     -0.021751655190632_REALK, &
      0.000000000000000_REALK,      1.112026029361033_REALK,      0.000000000000000_REALK, &
     -4.128056264827563_REALK,     -1.850688489484118_REALK,      0.000000000000000_REALK, &
     -1.177432062256212_REALK,      0.000000000000000_REALK,     -1.969644375187550_REALK, &
     -0.903703141860901_REALK,      0.000000000000000_REALK,     -1.011854092396370_REALK, &
      0.000000000000000_REALK,     -0.875122963266651_REALK,      0.000000000000000_REALK, &
     -0.782463905100989_REALK,      0.000000000000000_REALK,     -1.832501381967395_REALK, &
     -4.760804287170432_REALK,     -3.431753058635935_REALK,      0.000000000000000_REALK, &
     -2.966013904322434_REALK,      0.000000000000000_REALK,     -3.719401749124815_REALK, &
     -3.156860627547876_REALK,      0.000000000000000_REALK,     -2.292899217396853_REALK, &
      0.000000000000000_REALK,     -4.339265427784419_REALK,      0.000000000000000_REALK, &
     -2.023881797513814_REALK,      0.000000000000000_REALK,     -3.553146288833785_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.541632154238439_REALK, &
      0.000000000000000_REALK,      1.449816942574724_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.095486853532583_REALK,      0.000000000000000_REALK, &
      1.945473414755471_REALK,      0.000000000000000_REALK,      1.008950472839021_REALK, &
      0.000000000000000_REALK,      1.348868650776080_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.019849222981428_REALK, &
      0.000000000000000_REALK,      3.003023327996168_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.646498673530278_REALK,      0.000000000000000_REALK, &
      4.695562711368019_REALK,      0.000000000000000_REALK,      0.227969499781560_REALK, &
      0.000000000000000_REALK,      2.868789636844578_REALK,      0.000000000000000_REALK, &
     -4.428942222956985_REALK,     -3.076336261710296_REALK,      0.000000000000000_REALK, &
     -2.689024639912154_REALK,      0.000000000000000_REALK,     -2.958491069156774_REALK, &
     -2.813069848967586_REALK,      0.000000000000000_REALK,     -2.354758693945978_REALK, &
      0.000000000000000_REALK,     -3.591172072985927_REALK,      0.000000000000000_REALK, &
     -2.501792420428276_REALK,      0.000000000000000_REALK,     -3.538923891147739_REALK, &
    -12.828871520029693_REALK,    -14.658262587770803_REALK,      0.000000000000000_REALK, &
    -16.626863473370683_REALK,      0.000000000000000_REALK,    -14.031666502081295_REALK, &
    -20.164797392370076_REALK,      0.000000000000000_REALK,    -13.711326409062568_REALK, &
      0.000000000000000_REALK,    -27.350628586997843_REALK,      0.000000000000000_REALK, &
    -15.883650713250910_REALK,      0.000000000000000_REALK,    -17.234302875563014_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -11.465725621317757_REALK, &
      0.000000000000000_REALK,     -1.421635026572535_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -10.085624973149267_REALK,      0.000000000000000_REALK, &
    -13.642726392065665_REALK,      0.000000000000000_REALK,      6.192823742808207_REALK, &
      0.000000000000000_REALK,      4.404774882551299_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -11.455263580251286_REALK, &
      0.000000000000000_REALK,     -2.922646980138273_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -15.238596287543590_REALK,      0.000000000000000_REALK, &
    -15.120128177350228_REALK,      0.000000000000000_REALK,      4.750181287289546_REALK, &
      0.000000000000000_REALK,      2.836772888476302_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.603136641921468_REALK, &
      0.000000000000000_REALK,     -0.644794980781430_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.688801034322633_REALK,      0.000000000000000_REALK, &
     -6.317257846821223_REALK,      0.000000000000000_REALK,      2.767866045165240_REALK, &
      0.000000000000000_REALK,      3.093087415440265_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.349395047826487_REALK, &
      0.000000000000000_REALK,     -0.787213390857292_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.377806042275802_REALK,      0.000000000000000_REALK, &
     -5.485475630913299_REALK,      0.000000000000000_REALK,     -0.053800165102869_REALK, &
      0.000000000000000_REALK,      1.104168874038926_REALK,      0.000000000000000_REALK, &
      3.284381600531101_REALK,      3.106508485805505_REALK,      0.000000000000000_REALK, &
      0.900216054213739_REALK,      0.000000000000000_REALK,      1.217713463873531_REALK, &
      4.178456307826183_REALK,      0.000000000000000_REALK,      2.972014085484820_REALK, &
      0.000000000000000_REALK,     -7.652119906063030_REALK,      0.000000000000000_REALK, &
     -4.318344638928985_REALK,      0.000000000000000_REALK,     -9.735637691003639_REALK, &
      2.676889540858153_REALK,      4.936530578415431_REALK,      0.000000000000000_REALK, &
      3.040412064755031_REALK,      0.000000000000000_REALK,      3.016775250397330_REALK, &
     10.425403741107457_REALK,      0.000000000000000_REALK,      6.225973472492091_REALK, &
      0.000000000000000_REALK,     -9.043766769354017_REALK,      0.000000000000000_REALK, &
     -4.264572230534526_REALK,      0.000000000000000_REALK,     -7.052364221582830_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.311718802548742_REALK, &
      0.000000000000000_REALK,     -0.182088310038976_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.803594213559983_REALK,      0.000000000000000_REALK, &
     -2.583978988429510_REALK,      0.000000000000000_REALK,      1.469378127734027_REALK, &
      0.000000000000000_REALK,      1.930453241959871_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.046938368049819_REALK, &
      0.000000000000000_REALK,     -0.685781969565933_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.147842463171743_REALK,      0.000000000000000_REALK, &
     -3.351404388051920_REALK,      0.000000000000000_REALK,      1.080612794230714_REALK, &
      0.000000000000000_REALK,      0.894428951136131_REALK,      0.000000000000000_REALK, &
      2.700890341311653_REALK,      1.053395024796663_REALK,      0.000000000000000_REALK, &
      0.219552385556776_REALK,      0.000000000000000_REALK,      0.515831782546256_REALK, &
      0.564914451636657_REALK,      0.000000000000000_REALK,      0.631291309855773_REALK, &
      0.000000000000000_REALK,     -2.340997636634773_REALK,      0.000000000000000_REALK, &
     -2.327637696167198_REALK,      0.000000000000000_REALK,     -9.114525590258999_REALK, &
      5.519794358383294_REALK,      1.536851825920960_REALK,      0.000000000000000_REALK, &
      0.563014536431008_REALK,      0.000000000000000_REALK,      2.241536489665083_REALK, &
     -0.049725474740326_REALK,      0.000000000000000_REALK,      1.020541876592670_REALK, &
      0.000000000000000_REALK,      1.159972412208191_REALK,      0.000000000000000_REALK, &
     -0.734309917207536_REALK,      0.000000000000000_REALK,     -4.872528054005045_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.989366143821001_REALK, &
      0.000000000000000_REALK,     -0.242677972095065_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.881363206842992_REALK,      0.000000000000000_REALK, &
     -1.987019002293573_REALK,      0.000000000000000_REALK,      3.617200488147687_REALK, &
      0.000000000000000_REALK,      4.288015321456641_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.889554987012132_REALK, &
      0.000000000000000_REALK,     -2.544127011271454_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.941584162841799_REALK,      0.000000000000000_REALK, &
     -6.518235739414092_REALK,      0.000000000000000_REALK,      5.556280871974375_REALK, &
      0.000000000000000_REALK,      5.530282595231969_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.243650029950778_REALK, &
      0.000000000000000_REALK,      0.046832819762302_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.110214187917108_REALK,      0.000000000000000_REALK, &
      0.432348341121874_REALK,      0.000000000000000_REALK,      0.360796463905627_REALK, &
      0.000000000000000_REALK,      0.744857089237442_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.998963119367339_REALK, &
      0.000000000000000_REALK,     -0.070460616307884_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.229163402708928_REALK,      0.000000000000000_REALK, &
     -1.358664298278757_REALK,      0.000000000000000_REALK,     -0.442559168089025_REALK, &
      0.000000000000000_REALK,      0.197987858059354_REALK,      0.000000000000000_REALK, &
      1.916598657348354_REALK,      0.279461246906421_REALK,      0.000000000000000_REALK, &
     -0.113564372919688_REALK,      0.000000000000000_REALK,     -0.365169321166027_REALK, &
     -0.040989682833653_REALK,      0.000000000000000_REALK,     -0.053851806161807_REALK, &
      0.000000000000000_REALK,     -1.580955241956975_REALK,      0.000000000000000_REALK, &
     -1.806195498869464_REALK,      0.000000000000000_REALK,     -9.679784355752416_REALK, &
      2.260874122870167_REALK,      0.602200709888033_REALK,      0.000000000000000_REALK, &
      0.426293402437879_REALK,      0.000000000000000_REALK,      1.244666951578117_REALK, &
      0.329614690060514_REALK,      0.000000000000000_REALK,      0.272823830222893_REALK, &
      0.000000000000000_REALK,     -2.128948188436863_REALK,      0.000000000000000_REALK, &
     -1.197845293954177_REALK,      0.000000000000000_REALK,     -5.828999627806816_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.791676264739247_REALK, &
      0.000000000000000_REALK,      0.089214432512919_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.064931639526090_REALK,      0.000000000000000_REALK, &
      0.254258251210034_REALK,      0.000000000000000_REALK,      1.269727833494759_REALK, &
      0.000000000000000_REALK,      2.364865880267224_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.968344058638103_REALK, &
      0.000000000000000_REALK,     -0.379015660128906_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.223983407434141_REALK,      0.000000000000000_REALK, &
     -1.486246352908843_REALK,      0.000000000000000_REALK,     -0.051891638285231_REALK, &
      0.000000000000000_REALK,      1.774998636400838_REALK,      0.000000000000000_REALK, &
      0.884291544700868_REALK,      0.372451634395926_REALK,      0.000000000000000_REALK, &
     -0.124554729502340_REALK,      0.000000000000000_REALK,     -0.280806610061696_REALK, &
     -0.100905204696054_REALK,      0.000000000000000_REALK,     -0.119618214464239_REALK, &
      0.000000000000000_REALK,     -3.510325092118932_REALK,      0.000000000000000_REALK, &
     -3.301654471470681_REALK,      0.000000000000000_REALK,    -10.420936762548418_REALK, &
      2.638340612529001_REALK,      2.234055662330577_REALK,      0.000000000000000_REALK, &
      1.463851859191659_REALK,      0.000000000000000_REALK,      2.420785935701408_REALK, &
      1.694808545005974_REALK,      0.000000000000000_REALK,      1.686878402057170_REALK, &
      0.000000000000000_REALK,     -8.722944865206189_REALK,      0.000000000000000_REALK, &
     -6.855482048088239_REALK,      0.000000000000000_REALK,    -15.871767479997251_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.473506912928208_REALK, &
      0.000000000000000_REALK,     -0.223549772772291_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.080649672256222_REALK,      0.000000000000000_REALK, &
      4.388250651449399_REALK,      0.000000000000000_REALK,     -0.787881154559789_REALK, &
      0.000000000000000_REALK,     -0.774530318801135_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.309019460553618_REALK, &
      0.000000000000000_REALK,      0.198865023918315_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.022768024097079_REALK,      0.000000000000000_REALK, &
     -0.095205685017469_REALK,      0.000000000000000_REALK,      0.012451955287276_REALK, &
      0.000000000000000_REALK,     -0.453761739885049_REALK,      0.000000000000000_REALK, &
      0.133346906275988_REALK,     -0.055611038848757_REALK,      0.000000000000000_REALK, &
     -0.514809064479707_REALK,      0.000000000000000_REALK,     -2.019493580896362_REALK, &
     -0.080221277414037_REALK,      0.000000000000000_REALK,     -0.165615224003855_REALK, &
      0.000000000000000_REALK,     -1.276683516695212_REALK,      0.000000000000000_REALK, &
     -1.783653026743782_REALK,      0.000000000000000_REALK,    -11.661526853960504_REALK, &
     11.206127335323474_REALK,      0.243598297717202_REALK,      0.000000000000000_REALK, &
      0.333121165826145_REALK,      0.000000000000000_REALK,      1.975009227733670_REALK, &
     -0.006239074046750_REALK,      0.000000000000000_REALK,      0.002791176854665_REALK, &
      0.000000000000000_REALK,      0.697208852290917_REALK,      0.000000000000000_REALK, &
     -0.760101685150511_REALK,      0.000000000000000_REALK,     -7.510819866725056_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.433615686794171_REALK, &
      0.000000000000000_REALK,      0.251541098969518_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.401598476355059_REALK,      0.000000000000000_REALK, &
      2.152251321160364_REALK,      0.000000000000000_REALK,      0.663357170553207_REALK, &
      0.000000000000000_REALK,      1.452519239603521_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.303095353359302_REALK, &
      0.000000000000000_REALK,     -0.396587724369060_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.016886884340915_REALK,      0.000000000000000_REALK, &
     -0.082175588980340_REALK,      0.000000000000000_REALK,      1.093283999119109_REALK, &
      0.000000000000000_REALK,      1.508194957908366_REALK,      0.000000000000000_REALK, &
      0.047051714512457_REALK,     -0.105936548290849_REALK,      0.000000000000000_REALK, &
     -0.303294859140103_REALK,      0.000000000000000_REALK,     -1.187637044879643_REALK, &
     -0.282317591665064_REALK,      0.000000000000000_REALK,     -0.525816023179017_REALK, &
      0.000000000000000_REALK,     -1.056853603030411_REALK,      0.000000000000000_REALK, &
     -1.751370332635879_REALK,      0.000000000000000_REALK,     -9.601182193243227_REALK, &
      7.355046822142731_REALK,      1.310342918547992_REALK,      0.000000000000000_REALK, &
      0.325591315751861_REALK,      0.000000000000000_REALK,      2.160467648556870_REALK, &
     -0.000731553647542_REALK,      0.000000000000000_REALK,      0.025023429009966_REALK, &
      0.000000000000000_REALK,      1.173574183516515_REALK,      0.000000000000000_REALK, &
     -1.238200656707005_REALK,      0.000000000000000_REALK,    -11.502547102904096_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.333440253659439_REALK, &
      0.000000000000000_REALK,      0.558735152405083_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.734106250416097_REALK,      0.000000000000000_REALK, &
      2.317042827673619_REALK,      0.000000000000000_REALK,      2.721668252997230_REALK, &
      0.000000000000000_REALK,      4.516967552619898_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.369204868970524_REALK, &
      0.000000000000000_REALK,     -2.452114487992525_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.096646647969982_REALK,      0.000000000000000_REALK, &
     -0.223755691217726_REALK,      0.000000000000000_REALK,      9.369055848639485_REALK, &
      0.000000000000000_REALK,     13.055304215588734_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     16.424698191275766_REALK, &
      0.000000000000000_REALK,     -2.513972674978371_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.468448593329352_REALK,      0.000000000000000_REALK, &
     12.943712212247371_REALK,      0.000000000000000_REALK,     -3.010646216587049_REALK, &
      0.000000000000000_REALK,     -3.607881729772312_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     12.189914698898932_REALK, &
      0.000000000000000_REALK,     -2.623035932472624_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.822052371042313_REALK,      0.000000000000000_REALK, &
     12.374673278334329_REALK,      0.000000000000000_REALK,     -3.545933907207120_REALK, &
      0.000000000000000_REALK,     -3.737826120487514_REALK,      0.000000000000000_REALK, &
    -10.929593066887987_REALK,      0.462380204026195_REALK,      0.000000000000000_REALK, &
     -1.714297948754424_REALK,      0.000000000000000_REALK,     -6.961339353107507_REALK, &
      0.370666188687865_REALK,      0.000000000000000_REALK,      0.364385160923948_REALK, &
      0.000000000000000_REALK,     -1.843225489551111_REALK,      0.000000000000000_REALK, &
     -2.460243227882518_REALK,      0.000000000000000_REALK,    -16.650730612414513_REALK, &
     -6.906411603283910_REALK,      0.507326765660141_REALK,      0.000000000000000_REALK, &
     -1.829956266873425_REALK,      0.000000000000000_REALK,     -7.652057956230188_REALK, &
     -0.014132875344910_REALK,      0.000000000000000_REALK,      0.515016152735293_REALK, &
      0.000000000000000_REALK,     -3.576946733570105_REALK,      0.000000000000000_REALK, &
     -2.607687622190320_REALK,      0.000000000000000_REALK,    -18.173637241103012_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.177028866477969_REALK, &
      0.000000000000000_REALK,      0.262725142181875_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.839136544310532_REALK,      0.000000000000000_REALK, &
      5.486276309850127_REALK,      0.000000000000000_REALK,      0.182634446256673_REALK, &
      0.000000000000000_REALK,      0.628408607264050_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.038467921169613_REALK, &
      0.000000000000000_REALK,      0.224337937950485_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.862709680355595_REALK,      0.000000000000000_REALK, &
      8.524723906049173_REALK,      0.000000000000000_REALK,     -0.714579187735754_REALK, &
      0.000000000000000_REALK,      0.532802590760532_REALK,      0.000000000000000_REALK, &
     -3.216301845955675_REALK,     -0.520276192724967_REALK,      0.000000000000000_REALK, &
     -0.637079214396084_REALK,      0.000000000000000_REALK,     -3.414242487452869_REALK, &
     -0.312082695118029_REALK,      0.000000000000000_REALK,     -0.683351502220475_REALK, &
      0.000000000000000_REALK,     -0.800276372018216_REALK,      0.000000000000000_REALK, &
     -1.523820897043697_REALK,      0.000000000000000_REALK,    -11.433070653296701_REALK, &
     -3.576709360179742_REALK,     -1.011739337266844_REALK,      0.000000000000000_REALK, &
     -1.357265773079948_REALK,      0.000000000000000_REALK,     -6.604777533500583_REALK, &
     -1.240869094022819_REALK,      0.000000000000000_REALK,     -1.711789903206704_REALK, &
      0.000000000000000_REALK,     -3.437511132790935_REALK,      0.000000000000000_REALK, &
     -3.223506139238943_REALK,      0.000000000000000_REALK,    -21.960884809558571_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.456454561820883_REALK, &
      0.000000000000000_REALK,      0.834132793540768_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.823948843581431_REALK,      0.000000000000000_REALK, &
      4.516967552619898_REALK,      0.000000000000000_REALK,      1.071222803649101_REALK, &
      0.000000000000000_REALK,      2.793210850673358_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.511592953147679_REALK, &
      0.000000000000000_REALK,      2.011232091998851_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.405348407499278_REALK,      0.000000000000000_REALK, &
     13.055304215588730_REALK,      0.000000000000000_REALK,     -0.139644923624009_REALK, &
      0.000000000000000_REALK,      6.687346556889201_REALK,      0.000000000000000_REALK, &
     -2.473260391683779_REALK,     -1.155662430615951_REALK,      0.000000000000000_REALK, &
     -1.164555795985779_REALK,      0.000000000000000_REALK,     -3.675660918273290_REALK, &
     -1.280434736092789_REALK,      0.000000000000000_REALK,     -2.125050380335400_REALK, &
      0.000000000000000_REALK,     -2.961532532959907_REALK,      0.000000000000000_REALK, &
     -3.899678697146254_REALK,      0.000000000000000_REALK,    -15.825171853139278_REALK, &
     -6.956437386110901_REALK,     -6.255616436264899_REALK,      0.000000000000000_REALK, &
     -7.767873855494848_REALK,      0.000000000000000_REALK,    -17.984131062343799_REALK, &
    -10.633807731676031_REALK,      0.000000000000000_REALK,    -14.817671828401988_REALK, &
      0.000000000000000_REALK,    -23.474205281062478_REALK,      0.000000000000000_REALK, &
    -25.828179994018708_REALK,      0.000000000000000_REALK,    -76.882158578436986_REALK/
    ! results of test 4, ket-major order, 02 DPG X
  data REF_CONTR_INTS(21421:22680)                                                         &
   /-43.400990205619493_REALK,    -32.913945870608764_REALK,      0.000000000000000_REALK, &
    -33.858650042951595_REALK,      0.000000000000000_REALK,     -8.589932060886118_REALK, &
    -41.903420167884370_REALK,      0.000000000000000_REALK,     -8.002971028712803_REALK, &
      0.000000000000000_REALK,    -73.176280884939786_REALK,      0.000000000000000_REALK, &
    -12.303557736593977_REALK,      0.000000000000000_REALK,     -9.364229666315330_REALK, &
    -28.326440566777880_REALK,    -16.729966226610969_REALK,      0.000000000000000_REALK, &
    -11.302078974337480_REALK,      0.000000000000000_REALK,     -4.604543260365808_REALK, &
     -2.145230759297416_REALK,      0.000000000000000_REALK,     -3.856540819720945_REALK, &
      0.000000000000000_REALK,     32.238710565534966_REALK,      0.000000000000000_REALK, &
     -3.905029247494032_REALK,      0.000000000000000_REALK,     -4.772805820214337_REALK, &
    -23.063377095086242_REALK,     -8.884916516138359_REALK,      0.000000000000000_REALK, &
     -3.272798700517482_REALK,      0.000000000000000_REALK,     -4.014588203456698_REALK, &
      2.923768545469562_REALK,      0.000000000000000_REALK,     -1.878682583940716_REALK, &
      0.000000000000000_REALK,     16.490085326990826_REALK,      0.000000000000000_REALK, &
     -0.980594327255255_REALK,      0.000000000000000_REALK,     -3.608546793256532_REALK, &
     -3.585610385288457_REALK,      1.799814953711481_REALK,      0.000000000000000_REALK, &
      7.066813270689772_REALK,      0.000000000000000_REALK,     -0.970201301776789_REALK, &
     14.839280684662747_REALK,      0.000000000000000_REALK,      0.442645074011869_REALK, &
      0.000000000000000_REALK,     31.349633698529210_REALK,      0.000000000000000_REALK, &
      2.133590753873646_REALK,      0.000000000000000_REALK,     -0.878760672276155_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.211621733410873_REALK, &
      0.000000000000000_REALK,      4.859170216875379_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.177081100116742_REALK,      0.000000000000000_REALK, &
      3.940273005623677_REALK,      0.000000000000000_REALK,      7.623079027427091_REALK, &
      0.000000000000000_REALK,      4.367706528130446_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.586167934375367_REALK, &
      0.000000000000000_REALK,      2.833046335203413_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.164861827890839_REALK,      0.000000000000000_REALK, &
      2.645937962884115_REALK,      0.000000000000000_REALK,      0.475792142084014_REALK, &
      0.000000000000000_REALK,      2.566034180281501_REALK,      0.000000000000000_REALK, &
    -17.913765144121637_REALK,     -3.490535672164998_REALK,      0.000000000000000_REALK, &
     -0.121894585652771_REALK,      0.000000000000000_REALK,     -2.719415302680915_REALK, &
      2.537589866757484_REALK,      0.000000000000000_REALK,     -0.636163559084555_REALK, &
      0.000000000000000_REALK,      5.770256537558190_REALK,      0.000000000000000_REALK, &
     -0.030067631520100_REALK,      0.000000000000000_REALK,     -2.012387428857176_REALK, &
     -8.182190999595482_REALK,     -0.104202478419234_REALK,      0.000000000000000_REALK, &
      0.957851758648629_REALK,      0.000000000000000_REALK,     -1.001803651608466_REALK, &
      1.057223403210992_REALK,      0.000000000000000_REALK,     -0.017122020617889_REALK, &
      0.000000000000000_REALK,      0.179137758870913_REALK,      0.000000000000000_REALK, &
      0.214914358184477_REALK,      0.000000000000000_REALK,     -0.674327692782194_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.300054562942257_REALK, &
      0.000000000000000_REALK,      1.293166258007055_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.490316059229872_REALK,      0.000000000000000_REALK, &
      1.804342931667367_REALK,      0.000000000000000_REALK,     -0.496430834068408_REALK, &
      0.000000000000000_REALK,      0.956952591415575_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.252740859773023_REALK, &
      0.000000000000000_REALK,     -0.429512993775141_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.499339465821129_REALK,      0.000000000000000_REALK, &
      0.617531996032063_REALK,      0.000000000000000_REALK,     -3.230729900248499_REALK, &
      0.000000000000000_REALK,     -0.289111050501102_REALK,      0.000000000000000_REALK, &
     -5.955487982959791_REALK,     -3.994314244361494_REALK,      0.000000000000000_REALK, &
     -3.563575162119178_REALK,      0.000000000000000_REALK,     -2.712234702000822_REALK, &
     -3.811686406944702_REALK,      0.000000000000000_REALK,     -2.183937427763691_REALK, &
      0.000000000000000_REALK,     -5.228057418123845_REALK,      0.000000000000000_REALK, &
     -2.637071965788580_REALK,      0.000000000000000_REALK,     -3.345122885445172_REALK, &
     -6.989821363372704_REALK,     -3.658078890679596_REALK,      0.000000000000000_REALK, &
     -2.100636241988287_REALK,      0.000000000000000_REALK,     -2.567440151273846_REALK, &
     -0.334353687490897_REALK,      0.000000000000000_REALK,     -1.803230685245962_REALK, &
      0.000000000000000_REALK,      3.891090721156866_REALK,      0.000000000000000_REALK, &
     -1.413966886784952_REALK,      0.000000000000000_REALK,     -2.880298268004151_REALK, &
    -16.367527964013799_REALK,      0.134573303325913_REALK,      0.000000000000000_REALK, &
      2.085476491341991_REALK,      0.000000000000000_REALK,     -2.159312798911079_REALK, &
      4.031917017097484_REALK,      0.000000000000000_REALK,      0.020985392111039_REALK, &
      0.000000000000000_REALK,      6.442749699020986_REALK,      0.000000000000000_REALK, &
      0.422465111497175_REALK,      0.000000000000000_REALK,     -1.312267473840803_REALK, &
     -2.689705334094755_REALK,      2.852892494369532_REALK,      0.000000000000000_REALK, &
      4.387562752392332_REALK,      0.000000000000000_REALK,     -0.552734384663752_REALK, &
      6.462317163210625_REALK,      0.000000000000000_REALK,      0.520675634423537_REALK, &
      0.000000000000000_REALK,     10.272583040385813_REALK,      0.000000000000000_REALK, &
      0.892170888689157_REALK,      0.000000000000000_REALK,     -0.337180495188791_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.571278720541649_REALK, &
      0.000000000000000_REALK,      0.504600618623847_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.017972819362684_REALK,      0.000000000000000_REALK, &
      1.202897398899180_REALK,      0.000000000000000_REALK,     -0.407742491812164_REALK, &
      0.000000000000000_REALK,      0.306658201365707_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.011296997498101_REALK, &
      0.000000000000000_REALK,      0.016944119217806_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.176472182518933_REALK,      0.000000000000000_REALK, &
      0.553709303945546_REALK,      0.000000000000000_REALK,     -0.212743087780571_REALK, &
      0.000000000000000_REALK,      0.010336296541192_REALK,      0.000000000000000_REALK, &
     -3.616132631806489_REALK,     -1.222722722071173_REALK,      0.000000000000000_REALK, &
     -0.388915371330968_REALK,      0.000000000000000_REALK,     -1.431192570726774_REALK, &
      0.296739758195250_REALK,      0.000000000000000_REALK,     -0.572014994019983_REALK, &
      0.000000000000000_REALK,      1.324872804517070_REALK,      0.000000000000000_REALK, &
     -0.236353432504877_REALK,      0.000000000000000_REALK,     -1.449618184324244_REALK, &
     -0.991266466390992_REALK,      0.433583168012831_REALK,      0.000000000000000_REALK, &
      1.483761013013378_REALK,      0.000000000000000_REALK,     -0.611115708542296_REALK, &
      2.652842562229553_REALK,      0.000000000000000_REALK,      0.237397159051033_REALK, &
      0.000000000000000_REALK,      4.433125363884174_REALK,      0.000000000000000_REALK, &
      0.905127828105032_REALK,      0.000000000000000_REALK,     -0.621324042014899_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.564489273666348_REALK, &
      0.000000000000000_REALK,      1.732284349438596_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.576300349957198_REALK,      0.000000000000000_REALK, &
      1.999535258568592_REALK,      0.000000000000000_REALK,      1.837396815695969_REALK, &
      0.000000000000000_REALK,      1.754586311254603_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.591769866351092_REALK, &
      0.000000000000000_REALK,      1.784494738669509_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.161047705831991_REALK,      0.000000000000000_REALK, &
      2.365093360695289_REALK,      0.000000000000000_REALK,      0.201844101270158_REALK, &
      0.000000000000000_REALK,      1.814303688296899_REALK,      0.000000000000000_REALK, &
    -18.218648729219677_REALK,      3.248721563450414_REALK,      0.000000000000000_REALK, &
      2.958919319579647_REALK,      0.000000000000000_REALK,     -2.043278371230276_REALK, &
      3.799978093236632_REALK,      0.000000000000000_REALK,      0.426106587700224_REALK, &
      0.000000000000000_REALK,      4.016460796509321_REALK,      0.000000000000000_REALK, &
      0.487790164112673_REALK,      0.000000000000000_REALK,     -1.010528829328018_REALK, &
     -9.927167646826872_REALK,      4.599062363837474_REALK,      0.000000000000000_REALK, &
      2.362702438151427_REALK,      0.000000000000000_REALK,     -0.874922388918785_REALK, &
      0.898149455586662_REALK,      0.000000000000000_REALK,      0.508513550666374_REALK, &
      0.000000000000000_REALK,     -1.811574083851136_REALK,      0.000000000000000_REALK, &
      0.331648818858919_REALK,      0.000000000000000_REALK,     -0.368434431936124_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.417450416763578_REALK, &
      0.000000000000000_REALK,     -0.019674870264106_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.306233763932287_REALK,      0.000000000000000_REALK, &
      0.951227916492390_REALK,      0.000000000000000_REALK,     -0.623169643557494_REALK, &
      0.000000000000000_REALK,     -0.009730452734738_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.168042656535920_REALK, &
      0.000000000000000_REALK,     -0.806253196373499_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.025176857471578_REALK,      0.000000000000000_REALK, &
      0.387447791494563_REALK,      0.000000000000000_REALK,     -1.404629835276401_REALK, &
      0.000000000000000_REALK,     -0.339517472823671_REALK,      0.000000000000000_REALK, &
     -3.351897614937781_REALK,     -0.564923699987577_REALK,      0.000000000000000_REALK, &
     -0.016850430402729_REALK,      0.000000000000000_REALK,     -1.127777367186891_REALK, &
      0.295561727074364_REALK,      0.000000000000000_REALK,     -0.222288403679350_REALK, &
      0.000000000000000_REALK,      0.533097708987965_REALK,      0.000000000000000_REALK, &
     -0.008333590737463_REALK,      0.000000000000000_REALK,     -0.929593962536301_REALK, &
     -3.242803154941397_REALK,     -0.035806446229806_REALK,      0.000000000000000_REALK, &
      0.273262760575350_REALK,      0.000000000000000_REALK,     -0.857405007365293_REALK, &
      0.244459097404684_REALK,      0.000000000000000_REALK,     -0.011877244752474_REALK, &
      0.000000000000000_REALK,      0.031972130892319_REALK,      0.000000000000000_REALK, &
      0.115072389547939_REALK,      0.000000000000000_REALK,     -0.601762950308087_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.602286189530827_REALK, &
      0.000000000000000_REALK,      0.536293090780347_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.171326339819586_REALK,      0.000000000000000_REALK, &
      1.050789806706369_REALK,      0.000000000000000_REALK,     -0.137591529210334_REALK, &
      0.000000000000000_REALK,      0.442050739662279_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.291414530128808_REALK, &
      0.000000000000000_REALK,     -0.367603562833881_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.040065433865651_REALK,      0.000000000000000_REALK, &
      0.713951819029034_REALK,      0.000000000000000_REALK,     -1.729841657607887_REALK, &
      0.000000000000000_REALK,     -0.257999664819353_REALK,      0.000000000000000_REALK, &
     -3.343046948300105_REALK,     -1.939372343189547_REALK,      0.000000000000000_REALK, &
     -1.477861586696722_REALK,      0.000000000000000_REALK,     -1.874665795744104_REALK, &
     -1.331880260392905_REALK,      0.000000000000000_REALK,     -1.271853120214774_REALK, &
      0.000000000000000_REALK,     -1.449016389783650_REALK,      0.000000000000000_REALK, &
     -1.218158165280797_REALK,      0.000000000000000_REALK,     -2.163325208220406_REALK, &
     -8.310713391098689_REALK,     -3.771008341371600_REALK,      0.000000000000000_REALK, &
     -1.797853331480658_REALK,      0.000000000000000_REALK,     -3.662287911539190_REALK, &
     -0.231935276147988_REALK,      0.000000000000000_REALK,     -2.084782385581009_REALK, &
      0.000000000000000_REALK,      2.083421093936369_REALK,      0.000000000000000_REALK, &
     -1.261809198312849_REALK,      0.000000000000000_REALK,     -3.598487090035323_REALK, &
    -23.462344282789100_REALK,      8.568188815673256_REALK,      0.000000000000000_REALK, &
      4.354691329349216_REALK,      0.000000000000000_REALK,     -2.238945958128296_REALK, &
      4.674605151863030_REALK,      0.000000000000000_REALK,      0.936922336398223_REALK, &
      0.000000000000000_REALK,      3.935349563639610_REALK,      0.000000000000000_REALK, &
      0.578783080960565_REALK,      0.000000000000000_REALK,     -0.892736551279301_REALK, &
     -4.787934127292849_REALK,      8.653311495389495_REALK,      0.000000000000000_REALK, &
      6.406099355917224_REALK,      0.000000000000000_REALK,     -0.748119414013203_REALK, &
      7.289750284304796_REALK,      0.000000000000000_REALK,      1.156328606205500_REALK, &
      0.000000000000000_REALK,      8.951065114137123_REALK,      0.000000000000000_REALK, &
      0.874249973043714_REALK,      0.000000000000000_REALK,     -0.306290930500660_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.770233510510855_REALK, &
      0.000000000000000_REALK,     -0.485729476439988_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.438668579580352_REALK,      0.000000000000000_REALK, &
      0.908766266315947_REALK,      0.000000000000000_REALK,     -0.575725882868478_REALK, &
      0.000000000000000_REALK,     -0.193675267630952_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.199244455998314_REALK, &
      0.000000000000000_REALK,     -0.732487988106106_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.432759042380753_REALK,      0.000000000000000_REALK, &
      0.480759535020686_REALK,      0.000000000000000_REALK,     -0.176558465378530_REALK, &
      0.000000000000000_REALK,     -0.299891198189940_REALK,      0.000000000000000_REALK, &
     -3.787628151215093_REALK,      0.026674772115247_REALK,      0.000000000000000_REALK, &
      0.349083469058506_REALK,      0.000000000000000_REALK,     -1.084328314064942_REALK, &
      0.560415035990386_REALK,      0.000000000000000_REALK,      0.008750573902173_REALK, &
      0.000000000000000_REALK,      0.707567935209299_REALK,      0.000000000000000_REALK, &
      0.139190305663486_REALK,      0.000000000000000_REALK,     -0.720591696313263_REALK, &
     -1.190603496316667_REALK,      1.105120509119342_REALK,      0.000000000000000_REALK, &
      1.476715286737693_REALK,      0.000000000000000_REALK,     -0.558098900051147_REALK, &
      1.832861231060892_REALK,      0.000000000000000_REALK,      0.443026623511683_REALK, &
      0.000000000000000_REALK,      2.320439985557828_REALK,      0.000000000000000_REALK, &
      0.604588640245412_REALK,      0.000000000000000_REALK,     -0.380822963567337_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.529016652339797_REALK, &
      0.000000000000000_REALK,      0.253392069154801_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.007494379101015_REALK,      0.000000000000000_REALK, &
      0.835981725613633_REALK,      0.000000000000000_REALK,     -0.134339618876922_REALK, &
      0.000000000000000_REALK,      0.168392006900642_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.175233614605179_REALK, &
      0.000000000000000_REALK,      0.017108568889822_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.150154664432606_REALK,      0.000000000000000_REALK, &
      0.785223234056877_REALK,      0.000000000000000_REALK,     -0.144167508482424_REALK, &
      0.000000000000000_REALK,      0.011674160093168_REALK,      0.000000000000000_REALK, &
     -2.510440022134958_REALK,     -0.727094806294371_REALK,      0.000000000000000_REALK, &
     -0.195299147544494_REALK,      0.000000000000000_REALK,     -1.197821384115842_REALK, &
      0.123735747707787_REALK,      0.000000000000000_REALK,     -0.397535219724734_REALK, &
      0.000000000000000_REALK,      0.436508117729397_REALK,      0.000000000000000_REALK, &
     -0.129786285382559_REALK,      0.000000000000000_REALK,     -1.114419115142738_REALK, &
     -1.316358307774028_REALK,      0.503869303514510_REALK,      0.000000000000000_REALK, &
      1.498161526182772_REALK,      0.000000000000000_REALK,     -1.028411397965630_REALK, &
      2.257220821085371_REALK,      0.000000000000000_REALK,      0.336656371236088_REALK, &
      0.000000000000000_REALK,      3.004152309571718_REALK,      0.000000000000000_REALK, &
      1.022281735819945_REALK,      0.000000000000000_REALK,     -0.982441905592952_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.541632154238439_REALK, &
      0.000000000000000_REALK,      1.449816942574724_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.095486853532583_REALK,      0.000000000000000_REALK, &
      1.945473414755471_REALK,      0.000000000000000_REALK,      1.008950472839021_REALK, &
      0.000000000000000_REALK,      1.348868650776080_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.019849222981428_REALK, &
      0.000000000000000_REALK,      3.003023327996167_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.646498673530278_REALK,      0.000000000000000_REALK, &
      4.695562711368019_REALK,      0.000000000000000_REALK,      0.227969499781560_REALK, &
      0.000000000000000_REALK,      2.868789636844578_REALK,      0.000000000000000_REALK, &
    -52.918014428023859_REALK,      0.661033388671281_REALK,      0.000000000000000_REALK, &
    -30.512219248394615_REALK,      0.000000000000000_REALK,    -23.895849737527989_REALK, &
     -0.956869388166543_REALK,      0.000000000000000_REALK,     -0.356433514057731_REALK, &
      0.000000000000000_REALK,   -123.112077856012490_REALK,      0.000000000000000_REALK, &
    -40.803161408150963_REALK,      0.000000000000000_REALK,    -95.865810928509575_REALK, &
    -22.370753870151503_REALK,      0.594350249567152_REALK,      0.000000000000000_REALK, &
     -7.738403252826878_REALK,      0.000000000000000_REALK,    -10.269665725336024_REALK, &
     -0.002417668800100_REALK,      0.000000000000000_REALK,      0.016539692965016_REALK, &
      0.000000000000000_REALK,     57.106237633233640_REALK,      0.000000000000000_REALK, &
    -12.050193661837849_REALK,      0.000000000000000_REALK,    -47.975579763472723_REALK, &
    -19.978286427698830_REALK,      1.191753983357370_REALK,      0.000000000000000_REALK, &
      2.219404634249460_REALK,      0.000000000000000_REALK,     -8.657619069493823_REALK, &
      5.555766311752316_REALK,      0.000000000000000_REALK,      0.604131491214526_REALK, &
      0.000000000000000_REALK,     66.917800923103556_REALK,      0.000000000000000_REALK, &
      2.768724251546650_REALK,      0.000000000000000_REALK,    -32.401337964854413_REALK, &
     -2.644238902401649_REALK,      1.357152707428928_REALK,      0.000000000000000_REALK, &
      8.006224865335875_REALK,      0.000000000000000_REALK,     -1.812938683774281_REALK, &
      6.995951734979013_REALK,      0.000000000000000_REALK,      1.150939309189683_REALK, &
      0.000000000000000_REALK,     86.419338177836991_REALK,      0.000000000000000_REALK, &
     11.911188149852542_REALK,      0.000000000000000_REALK,     -8.091549062059311_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.896393742318006_REALK, &
      0.000000000000000_REALK,      4.073059299652455_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.874794973917649_REALK,      0.000000000000000_REALK, &
      4.404774882551288_REALK,      0.000000000000000_REALK,     13.640744611844257_REALK, &
      0.000000000000000_REALK,     15.243517860927131_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.115012168819204_REALK, &
      0.000000000000000_REALK,      2.057671733846373_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.712522138332074_REALK,      0.000000000000000_REALK, &
      2.836772888476302_REALK,      0.000000000000000_REALK,     -0.447479099688960_REALK, &
      0.000000000000000_REALK,      9.183847163197026_REALK,      0.000000000000000_REALK, &
    -10.110736382809918_REALK,      5.252281204803329_REALK,      0.000000000000000_REALK, &
      2.549004479880547_REALK,      0.000000000000000_REALK,     -3.877120495580092_REALK, &
      7.030025889691800_REALK,      0.000000000000000_REALK,      2.268285298835162_REALK, &
      0.000000000000000_REALK,     18.674660642503202_REALK,      0.000000000000000_REALK, &
      2.730510678755963_REALK,      0.000000000000000_REALK,    -12.459592361918288_REALK, &
     -3.081541272122727_REALK,      2.852783624819095_REALK,      0.000000000000000_REALK, &
      0.712885611034973_REALK,      0.000000000000000_REALK,     -1.104381681503899_REALK, &
      1.332600605227113_REALK,      0.000000000000000_REALK,      1.338615285578124_REALK, &
      0.000000000000000_REALK,    -11.394826365939062_REALK,      0.000000000000000_REALK, &
      0.841315244595750_REALK,      0.000000000000000_REALK,     -3.910023418003605_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.387378240481672_REALK, &
      0.000000000000000_REALK,     -0.708704756220379_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.264307176097865_REALK,      0.000000000000000_REALK, &
      3.093087415440263_REALK,      0.000000000000000_REALK,     -6.981538278024942_REALK, &
      0.000000000000000_REALK,     -2.277507850871536_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.784381421814502_REALK, &
      0.000000000000000_REALK,     -1.662263146150412_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.625394977774661_REALK,      0.000000000000000_REALK, &
      1.104168874038925_REALK,      0.000000000000000_REALK,    -11.924304759524857_REALK, &
      0.000000000000000_REALK,     -5.885182575177940_REALK,      0.000000000000000_REALK, &
     -4.491690508564957_REALK,     -1.123164817732078_REALK,      0.000000000000000_REALK, &
     -2.199316099682826_REALK,      0.000000000000000_REALK,     -5.167227589921576_REALK, &
     -1.302168927156512_REALK,      0.000000000000000_REALK,     -1.455172416454391_REALK, &
      0.000000000000000_REALK,     -7.108333282336742_REALK,      0.000000000000000_REALK, &
     -7.067766428278651_REALK,      0.000000000000000_REALK,    -27.675844089737524_REALK, &
     -3.810653499545664_REALK,     -0.890266998364122_REALK,      0.000000000000000_REALK, &
     -1.029071891027484_REALK,      0.000000000000000_REALK,     -4.097056194763843_REALK, &
      0.061062781658987_REALK,      0.000000000000000_REALK,     -1.253223344968764_REALK, &
      0.000000000000000_REALK,      5.755381900228011_REALK,      0.000000000000000_REALK, &
     -3.643391827404654_REALK,      0.000000000000000_REALK,    -24.175798902828280_REALK, &
     -3.913470671921135_REALK,      9.690314166630172_REALK,      0.000000000000000_REALK, &
      1.879331082106304_REALK,      0.000000000000000_REALK,     -1.263187742898723_REALK, &
      8.945130383844859_REALK,      0.000000000000000_REALK,      3.645789544322791_REALK, &
      0.000000000000000_REALK,      8.014184762124136_REALK,      0.000000000000000_REALK, &
      1.613352189354055_REALK,      0.000000000000000_REALK,     -3.253232062154949_REALK, &
     -0.332849644520419_REALK,      4.764265631932986_REALK,      0.000000000000000_REALK, &
      2.039184996825397_REALK,      0.000000000000000_REALK,     -0.185788545885425_REALK, &
      6.879393274516179_REALK,      0.000000000000000_REALK,      2.418646160468726_REALK, &
      0.000000000000000_REALK,     16.237787041694673_REALK,      0.000000000000000_REALK, &
      1.930477333203778_REALK,      0.000000000000000_REALK,     -0.527652827711657_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.710347253195208_REALK, &
      0.000000000000000_REALK,     -1.764648442791942_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.423057435500157_REALK,      0.000000000000000_REALK, &
      1.930453241959871_REALK,      0.000000000000000_REALK,     -4.695083601187419_REALK, &
      0.000000000000000_REALK,     -4.544701232889357_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.587284074006911_REALK, &
      0.000000000000000_REALK,     -1.211573963892132_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.192453249342130_REALK,      0.000000000000000_REALK, &
      0.894428951136131_REALK,      0.000000000000000_REALK,     -1.141832073101592_REALK, &
      0.000000000000000_REALK,     -3.440957164408581_REALK,      0.000000000000000_REALK, &
     -2.484995685528751_REALK,      0.312636977496503_REALK,      0.000000000000000_REALK, &
      0.205621950183845_REALK,      0.000000000000000_REALK,     -2.406316301515943_REALK, &
      1.081699369545440_REALK,      0.000000000000000_REALK,      0.352870486175930_REALK, &
      0.000000000000000_REALK,      4.266358201681941_REALK,      0.000000000000000_REALK, &
      0.529561757372551_REALK,      0.000000000000000_REALK,    -10.328769928548173_REALK, &
     -0.596812017606786_REALK,      0.883952250288491_REALK,      0.000000000000000_REALK, &
      1.471136821258029_REALK,      0.000000000000000_REALK,     -0.999377695696855_REALK, &
      2.727718547664095_REALK,      0.000000000000000_REALK,      1.346252212639865_REALK, &
      0.000000000000000_REALK,     10.104550444667451_REALK,      0.000000000000000_REALK, &
      4.178134340780344_REALK,      0.000000000000000_REALK,     -4.730507511225559_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.279463206039606_REALK, &
      0.000000000000000_REALK,      1.132074408809470_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.095059310013014_REALK,      0.000000000000000_REALK, &
      4.288015321456640_REALK,      0.000000000000000_REALK,      2.609005459638380_REALK, &
      0.000000000000000_REALK,      4.859268128310410_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.178717642454545_REALK, &
      0.000000000000000_REALK,      1.134286147830894_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.833436218248372_REALK,      0.000000000000000_REALK, &
      5.530282595231964_REALK,      0.000000000000000_REALK,     -0.156964004738273_REALK, &
      0.000000000000000_REALK,      5.369090350222068_REALK,      0.000000000000000_REALK, &
      4.603542753189221_REALK,     15.064168871499389_REALK,      0.000000000000000_REALK, &
      0.134332321495251_REALK,      0.000000000000000_REALK,      1.212462644314810_REALK, &
     10.516414154939403_REALK,      0.000000000000000_REALK,      4.813535148946734_REALK, &
      0.000000000000000_REALK,     -3.407946614672972_REALK,      0.000000000000000_REALK, &
      0.087747983634560_REALK,      0.000000000000000_REALK,      2.375998964804888_REALK, &
      2.011346011307777_REALK,     10.218792726973815_REALK,      0.000000000000000_REALK, &
     -1.982328780226366_REALK,      0.000000000000000_REALK,      0.455465922152803_REALK, &
      3.698220320227209_REALK,      0.000000000000000_REALK,      3.191044909771708_REALK, &
      0.000000000000000_REALK,    -15.037392277802132_REALK,      0.000000000000000_REALK, &
     -1.207379343056004_REALK,      0.000000000000000_REALK,      0.832233509433967_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.777020951006009_REALK, &
      0.000000000000000_REALK,     -2.576531143906382_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.369391667338080_REALK,      0.000000000000000_REALK, &
      0.744857089237443_REALK,      0.000000000000000_REALK,     -4.129401411458513_REALK, &
      0.000000000000000_REALK,     -5.049091911750158_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.211341106249196_REALK, &
      0.000000000000000_REALK,     -2.456197236159700_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.724360890646104_REALK,      0.000000000000000_REALK, &
      0.197987858059355_REALK,      0.000000000000000_REALK,     -4.255093363103066_REALK, &
      0.000000000000000_REALK,     -4.487996897878607_REALK,      0.000000000000000_REALK, &
     -1.726655305035662_REALK,      1.085482992467100_REALK,      0.000000000000000_REALK, &
      0.298980685795398_REALK,      0.000000000000000_REALK,     -1.364278667020137_REALK, &
      1.074982121807314_REALK,      0.000000000000000_REALK,      1.040550709911991_REALK, &
      0.000000000000000_REALK,      1.335698992218401_REALK,      0.000000000000000_REALK, &
      0.585896648674048_REALK,      0.000000000000000_REALK,     -4.455841334912625_REALK, &
     -1.337046139514526_REALK,      1.378208654421547_REALK,      0.000000000000000_REALK, &
      0.195441212877738_REALK,      0.000000000000000_REALK,     -0.908315550091062_REALK, &
      0.428442480631214_REALK,      0.000000000000000_REALK,      1.291128755264691_REALK, &
      0.000000000000000_REALK,     -1.612252865733398_REALK,      0.000000000000000_REALK, &
      0.357112834506867_REALK,      0.000000000000000_REALK,     -2.766144151000186_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.480190250053028_REALK, &
      0.000000000000000_REALK,     -0.249378573926036_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.121247984045350_REALK,      0.000000000000000_REALK, &
      2.364865880267224_REALK,      0.000000000000000_REALK,     -1.498056723055204_REALK, &
      0.000000000000000_REALK,     -0.814490019233581_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.136827820912051_REALK, &
      0.000000000000000_REALK,     -1.367153665511410_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.567735119326187_REALK,      0.000000000000000_REALK, &
      1.774998636400838_REALK,      0.000000000000000_REALK,     -5.061506135246315_REALK, &
      0.000000000000000_REALK,     -4.163469528836888_REALK,      0.000000000000000_REALK, &
     -2.301197742148022_REALK,     -0.696369592475714_REALK,      0.000000000000000_REALK, &
     -0.773893935009694_REALK,      0.000000000000000_REALK,     -3.030401203076845_REALK, &
     -0.597355545298410_REALK,      0.000000000000000_REALK,     -1.112573663583049_REALK, &
      0.000000000000000_REALK,     -1.525263636645720_REALK,      0.000000000000000_REALK, &
     -2.527598406259828_REALK,      0.000000000000000_REALK,    -13.856539852041262_REALK, &
     -4.960199232138143_REALK,     -1.290291003373029_REALK,      0.000000000000000_REALK, &
     -0.846375864826927_REALK,      0.000000000000000_REALK,     -5.616143877349306_REALK, &
      0.058896618114082_REALK,      0.000000000000000_REALK,     -2.014610066201554_REALK, &
      0.000000000000000_REALK,      2.442985262970622_REALK,      0.000000000000000_REALK, &
     -2.577515762891006_REALK,      0.000000000000000_REALK,    -23.944419921388530_REALK, &
     25.169276682062744_REALK,     23.271229614495617_REALK,      0.000000000000000_REALK, &
     -2.337998249998805_REALK,      0.000000000000000_REALK,      5.343653546349374_REALK, &
     14.199879492364120_REALK,      0.000000000000000_REALK,      6.113072225078596_REALK, &
      0.000000000000000_REALK,    -10.916167522997645_REALK,      0.000000000000000_REALK, &
     -1.118445088175418_REALK,      0.000000000000000_REALK,      7.668846281423005_REALK, &
      6.257584540423371_REALK,     15.582149161016160_REALK,      0.000000000000000_REALK, &
     -3.290946700981673_REALK,      0.000000000000000_REALK,      2.311060230205114_REALK, &
     13.947609335331812_REALK,      0.000000000000000_REALK,      5.272774245616430_REALK, &
      0.000000000000000_REALK,     -0.733341698833200_REALK,      0.000000000000000_REALK, &
     -1.563199648135192_REALK,      0.000000000000000_REALK,      3.293260754662086_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.982826759255679_REALK, &
      0.000000000000000_REALK,     -3.608864430303769_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.028604168076400_REALK,      0.000000000000000_REALK, &
     -0.774530318801135_REALK,      0.000000000000000_REALK,     -3.771764653079974_REALK, &
      0.000000000000000_REALK,     -5.179195531005583_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.446986904495247_REALK, &
      0.000000000000000_REALK,     -3.185694362007794_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.658303883700838_REALK,      0.000000000000000_REALK, &
     -0.453761739885049_REALK,      0.000000000000000_REALK,     -1.753709162595895_REALK, &
      0.000000000000000_REALK,     -4.539614364709743_REALK,      0.000000000000000_REALK, &
     -0.876779855342805_REALK,      2.088545792450279_REALK,      0.000000000000000_REALK, &
      0.276944991125430_REALK,      0.000000000000000_REALK,     -0.558443674312173_REALK, &
      1.346106054359101_REALK,      0.000000000000000_REALK,      1.645907606018345_REALK, &
      0.000000000000000_REALK,      0.658103449966290_REALK,      0.000000000000000_REALK, &
      0.397452519503614_REALK,      0.000000000000000_REALK,     -1.335733644277539_REALK, &
     -0.178395524434175_REALK,      2.410472323003953_REALK,      0.000000000000000_REALK, &
      0.723146326873641_REALK,      0.000000000000000_REALK,     -0.197655884200893_REALK, &
      2.320020217797018_REALK,      0.000000000000000_REALK,      2.447007069404335_REALK, &
      0.000000000000000_REALK,      2.889228692962213_REALK,      0.000000000000000_REALK, &
      1.030483492833778_REALK,      0.000000000000000_REALK,     -0.469432714517254_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.105889395699117_REALK, &
      0.000000000000000_REALK,     -0.780134834114676_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.190991126176392_REALK,      0.000000000000000_REALK, &
      1.452519239603521_REALK,      0.000000000000000_REALK,     -1.156643179886947_REALK, &
      0.000000000000000_REALK,     -1.865993640779135_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.891406220076968_REALK, &
      0.000000000000000_REALK,     -1.288963870009315_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.194709945326918_REALK,      0.000000000000000_REALK, &
      1.508194957908367_REALK,      0.000000000000000_REALK,     -0.609506821282713_REALK, &
      0.000000000000000_REALK,     -3.061289123060698_REALK,      0.000000000000000_REALK, &
     -1.670226512735676_REALK,      0.202147205762400_REALK,      0.000000000000000_REALK, &
      0.090903571559677_REALK,      0.000000000000000_REALK,     -1.773017147200610_REALK, &
      0.488337902699975_REALK,      0.000000000000000_REALK,      0.265508202487425_REALK, &
      0.000000000000000_REALK,      1.051025825329745_REALK,      0.000000000000000_REALK, &
      0.217430986333235_REALK,      0.000000000000000_REALK,     -5.937197017477788_REALK, &
     -0.959609793391706_REALK,      1.341702540615671_REALK,      0.000000000000000_REALK, &
      1.565106437538778_REALK,      0.000000000000000_REALK,     -1.772022427900650_REALK, &
      2.759703622040283_REALK,      0.000000000000000_REALK,      2.270063817363398_REALK, &
      0.000000000000000_REALK,      5.393781246038017_REALK,      0.000000000000000_REALK, &
      3.717127706329824_REALK,      0.000000000000000_REALK,     -5.891974441485106_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.456454561820883_REALK, &
      0.000000000000000_REALK,      0.834132793540768_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.823948843581431_REALK,      0.000000000000000_REALK, &
      4.516967552619898_REALK,      0.000000000000000_REALK,      1.071222803649101_REALK, &
      0.000000000000000_REALK,      2.793210850673358_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.511592953147680_REALK, &
      0.000000000000000_REALK,      2.011232091998851_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.405348407499278_REALK,      0.000000000000000_REALK, &
     13.055304215588729_REALK,      0.000000000000000_REALK,     -0.139644923624009_REALK, &
      0.000000000000000_REALK,      6.687346556889200_REALK,      0.000000000000000_REALK/
    ! results of test 4, ket-major order, 02 DPG Y
  data REF_CONTR_INTS(22681:23940)                                                         &
   /-24.756427103150099_REALK,    -13.195126613407048_REALK,      0.000000000000000_REALK, &
    -10.696496333466582_REALK,      0.000000000000000_REALK,     -4.309293465492396_REALK, &
    -10.924761410899201_REALK,      0.000000000000000_REALK,     -2.790060493700022_REALK, &
      0.000000000000000_REALK,    -16.959735154069524_REALK,      0.000000000000000_REALK, &
     -3.204878938764395_REALK,      0.000000000000000_REALK,     -3.873445127625938_REALK, &
     -8.280269617063661_REALK,     -8.046056342380329_REALK,      0.000000000000000_REALK, &
    -10.877344483607262_REALK,      0.000000000000000_REALK,     -2.240491157237551_REALK, &
    -20.177394679668208_REALK,      0.000000000000000_REALK,     -1.978840767953494_REALK, &
      0.000000000000000_REALK,    -53.042156196438675_REALK,      0.000000000000000_REALK, &
     -3.284054739804624_REALK,      0.000000000000000_REALK,     -2.029326812855400_REALK, &
    -21.327970845717918_REALK,     -8.089863824770235_REALK,      0.000000000000000_REALK, &
     -5.706229270234047_REALK,      0.000000000000000_REALK,     -3.237711883925761_REALK, &
     -5.187685410697215_REALK,      0.000000000000000_REALK,     -1.474408814760267_REALK, &
      0.000000000000000_REALK,     -7.607604763997648_REALK,      0.000000000000000_REALK, &
     -1.407550615540442_REALK,      0.000000000000000_REALK,     -2.395930730789963_REALK, &
    -14.754194462905550_REALK,     -5.836976736365982_REALK,      0.000000000000000_REALK, &
     -4.369541635013720_REALK,      0.000000000000000_REALK,     -1.806460627747618_REALK, &
     -3.919377635940320_REALK,      0.000000000000000_REALK,     -0.959102293364935_REALK, &
      0.000000000000000_REALK,     -2.863472630019336_REALK,      0.000000000000000_REALK, &
     -0.980399344230685_REALK,      0.000000000000000_REALK,     -1.215953271137618_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.542306917459365_REALK, &
      0.000000000000000_REALK,      1.920501163471278_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.602501225927170_REALK,      0.000000000000000_REALK, &
      1.936797203321291_REALK,      0.000000000000000_REALK,      1.854930831516981_REALK, &
      0.000000000000000_REALK,      1.421185059400492_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.892961299362765_REALK, &
      0.000000000000000_REALK,      1.920133922975082_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.307805688774376_REALK,      0.000000000000000_REALK, &
      1.426070006180434_REALK,      0.000000000000000_REALK,      4.392915915937512_REALK, &
      0.000000000000000_REALK,      1.292468315556365_REALK,      0.000000000000000_REALK, &
    -21.016162901657694_REALK,     -4.416088706394125_REALK,      0.000000000000000_REALK, &
     -2.159695340191027_REALK,      0.000000000000000_REALK,     -2.772591538399977_REALK, &
     -0.630522124327280_REALK,      0.000000000000000_REALK,     -0.688645896403188_REALK, &
      0.000000000000000_REALK,      0.164453484073955_REALK,      0.000000000000000_REALK, &
     -0.437499984527090_REALK,      0.000000000000000_REALK,     -1.684972041069420_REALK, &
     -5.985510528655122_REALK,     -1.082547905717677_REALK,      0.000000000000000_REALK, &
      0.146019906968581_REALK,      0.000000000000000_REALK,     -1.230022276796376_REALK, &
      1.155843547003536_REALK,      0.000000000000000_REALK,     -0.197573627017441_REALK, &
      0.000000000000000_REALK,      1.625889556090659_REALK,      0.000000000000000_REALK, &
      0.029691816964996_REALK,      0.000000000000000_REALK,     -0.750341451320686_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.061341775261736_REALK, &
      0.000000000000000_REALK,      1.169491067836529_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.841358353751028_REALK,      0.000000000000000_REALK, &
      1.432159037907806_REALK,      0.000000000000000_REALK,      0.833562508979487_REALK, &
      0.000000000000000_REALK,      0.710728473449123_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.823579107549204_REALK, &
      0.000000000000000_REALK,      0.949137018551863_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.805033286180022_REALK,      0.000000000000000_REALK, &
      0.998453195083875_REALK,      0.000000000000000_REALK,      0.788689030072153_REALK, &
      0.000000000000000_REALK,      0.578995081176316_REALK,      0.000000000000000_REALK, &
     -3.881587831892706_REALK,     -1.815884381300989_REALK,      0.000000000000000_REALK, &
     -1.271093099252554_REALK,      0.000000000000000_REALK,     -1.536254400285385_REALK, &
     -1.108778280152947_REALK,      0.000000000000000_REALK,     -0.849508293876626_REALK, &
      0.000000000000000_REALK,     -1.362606161937862_REALK,      0.000000000000000_REALK, &
     -0.772474525790700_REALK,      0.000000000000000_REALK,     -1.556032612208814_REALK, &
     -2.289137056761132_REALK,     -1.938329599798536_REALK,      0.000000000000000_REALK, &
     -2.283827101648785_REALK,      0.000000000000000_REALK,     -1.411252838488751_REALK, &
     -3.607145962031143_REALK,      0.000000000000000_REALK,     -1.061281835283517_REALK, &
      0.000000000000000_REALK,     -7.500646746011911_REALK,      0.000000000000000_REALK, &
     -1.393186265276358_REALK,      0.000000000000000_REALK,     -1.434826998648723_REALK, &
    -25.453057320273263_REALK,     -2.142764069833376_REALK,      0.000000000000000_REALK, &
     -1.042101626571433_REALK,      0.000000000000000_REALK,     -2.854639895481775_REALK, &
      0.168802674436333_REALK,      0.000000000000000_REALK,     -0.281047750079761_REALK, &
      0.000000000000000_REALK,      0.047477472113872_REALK,      0.000000000000000_REALK, &
     -0.171794790105861_REALK,      0.000000000000000_REALK,     -1.411797801196002_REALK, &
    -21.242015950274681_REALK,     -1.838155636628188_REALK,      0.000000000000000_REALK, &
     -1.545755425498723_REALK,      0.000000000000000_REALK,     -1.872146819904447_REALK, &
     -1.602676717143531_REALK,      0.000000000000000_REALK,     -0.203242960306211_REALK, &
      0.000000000000000_REALK,     -2.684206643019134_REALK,      0.000000000000000_REALK, &
     -0.216975253774450_REALK,      0.000000000000000_REALK,     -0.788370898754706_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.104044292888115_REALK, &
      0.000000000000000_REALK,      0.645640481624100_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.317132144965168_REALK,      0.000000000000000_REALK, &
      1.221391580546663_REALK,      0.000000000000000_REALK,      0.097452959921036_REALK, &
      0.000000000000000_REALK,      0.319309561168379_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.599292766382912_REALK, &
      0.000000000000000_REALK,      0.305937819576057_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.034118310734751_REALK,      0.000000000000000_REALK, &
      0.862203307514122_REALK,      0.000000000000000_REALK,     -0.251230679341381_REALK, &
      0.000000000000000_REALK,      0.128832029207272_REALK,      0.000000000000000_REALK, &
     -3.990739748683344_REALK,     -1.309299269086175_REALK,      0.000000000000000_REALK, &
     -0.788816161646351_REALK,      0.000000000000000_REALK,     -1.342721790439210_REALK, &
     -0.604227373221412_REALK,      0.000000000000000_REALK,     -0.515188235986746_REALK, &
      0.000000000000000_REALK,     -0.702845123813037_REALK,      0.000000000000000_REALK, &
     -0.390118881307178_REALK,      0.000000000000000_REALK,     -1.106766376125881_REALK, &
     -5.847449461311079_REALK,     -2.005723825631587_REALK,      0.000000000000000_REALK, &
     -1.246573907550540_REALK,      0.000000000000000_REALK,     -1.546079798523635_REALK, &
     -0.906267791991792_REALK,      0.000000000000000_REALK,     -0.665312402967953_REALK, &
      0.000000000000000_REALK,     -0.511066579768498_REALK,      0.000000000000000_REALK, &
     -0.524938846361389_REALK,      0.000000000000000_REALK,     -1.085103927524573_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.719907760514192_REALK, &
      0.000000000000000_REALK,      0.796457144182342_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.559946313049040_REALK,      0.000000000000000_REALK, &
      1.127926805480789_REALK,      0.000000000000000_REALK,      0.514115466189291_REALK, &
      0.000000000000000_REALK,      0.656496374366516_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.982270617224297_REALK, &
      0.000000000000000_REALK,      1.643368376355484_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.600884242487546_REALK,      0.000000000000000_REALK, &
      1.648732829257974_REALK,      0.000000000000000_REALK,      2.352115213708494_REALK, &
      0.000000000000000_REALK,      1.153385149496057_REALK,      0.000000000000000_REALK, &
    -36.334949681743474_REALK,      1.153611271085809_REALK,      0.000000000000000_REALK, &
     -0.013945298943669_REALK,      0.000000000000000_REALK,     -3.467342723651474_REALK, &
      1.424970261171740_REALK,      0.000000000000000_REALK,      0.126146165852918_REALK, &
      0.000000000000000_REALK,      1.127683129813615_REALK,      0.000000000000000_REALK, &
     -0.001853473065504_REALK,      0.000000000000000_REALK,     -1.382536087563138_REALK, &
    -12.910513072011813_REALK,      2.514055021141844_REALK,      0.000000000000000_REALK, &
      2.175805635976604_REALK,      0.000000000000000_REALK,     -2.017280358763905_REALK, &
      3.721583139160972_REALK,      0.000000000000000_REALK,      0.335949276767603_REALK, &
      0.000000000000000_REALK,      4.892551133151737_REALK,      0.000000000000000_REALK, &
      0.296935453685069_REALK,      0.000000000000000_REALK,     -0.825903815076769_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.870260269110238_REALK, &
      0.000000000000000_REALK,      0.320373306682879_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.154494662048240_REALK,      0.000000000000000_REALK, &
      1.269626535483527_REALK,      0.000000000000000_REALK,     -0.025574902377303_REALK, &
      0.000000000000000_REALK,      0.127742681725608_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.566126690802617_REALK, &
      0.000000000000000_REALK,      0.292761179906292_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.283124792564677_REALK,      0.000000000000000_REALK, &
      1.028722599886817_REALK,      0.000000000000000_REALK,      0.315054626951738_REALK, &
      0.000000000000000_REALK,      0.119860670005800_REALK,      0.000000000000000_REALK, &
     -4.863374017863621_REALK,     -0.875345681293799_REALK,      0.000000000000000_REALK, &
     -0.361506804125245_REALK,      0.000000000000000_REALK,     -1.392294580914850_REALK, &
     -0.087639224095932_REALK,      0.000000000000000_REALK,     -0.287154358470835_REALK, &
      0.000000000000000_REALK,      0.018060923922260_REALK,      0.000000000000000_REALK, &
     -0.144143871095740_REALK,      0.000000000000000_REALK,     -0.925251052486219_REALK, &
     -2.649498319508463_REALK,     -0.419344891219667_REALK,      0.000000000000000_REALK, &
      0.049145696815606_REALK,      0.000000000000000_REALK,     -1.241960150780328_REALK, &
      0.327823716009347_REALK,      0.000000000000000_REALK,     -0.168109224026591_REALK, &
      0.000000000000000_REALK,      0.367266842547903_REALK,      0.000000000000000_REALK, &
      0.020120960538914_REALK,      0.000000000000000_REALK,     -0.847460808844734_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.820433745857250_REALK, &
      0.000000000000000_REALK,      0.587275858569768_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.350833018213475_REALK,      0.000000000000000_REALK, &
      0.995312472168439_REALK,      0.000000000000000_REALK,      0.274635271071972_REALK, &
      0.000000000000000_REALK,      0.390274884130040_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.119190970986307_REALK, &
      0.000000000000000_REALK,      0.958348785147252_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.684977661736974_REALK,      0.000000000000000_REALK, &
      1.415921028076650_REALK,      0.000000000000000_REALK,      0.534463110501614_REALK, &
      0.000000000000000_REALK,      0.653936469786066_REALK,      0.000000000000000_REALK, &
     -2.694727886058625_REALK,     -1.079819715984769_REALK,      0.000000000000000_REALK, &
     -0.638296701629870_REALK,      0.000000000000000_REALK,     -1.285751763768199_REALK, &
     -0.462342863562646_REALK,      0.000000000000000_REALK,     -0.590385688827645_REALK, &
      0.000000000000000_REALK,     -0.448940191787528_REALK,      0.000000000000000_REALK, &
     -0.424180847269733_REALK,      0.000000000000000_REALK,     -1.196227051773186_REALK, &
     -3.039873418972627_REALK,     -2.252543127788453_REALK,      0.000000000000000_REALK, &
     -2.305992586498073_REALK,      0.000000000000000_REALK,     -2.374916049818299_REALK, &
     -3.069207757036195_REALK,      0.000000000000000_REALK,     -1.505019238450609_REALK, &
      0.000000000000000_REALK,     -5.082889247591779_REALK,      0.000000000000000_REALK, &
     -1.573511308970552_REALK,      0.000000000000000_REALK,     -2.268758450385001_REALK, &
    -75.725582937583241_REALK,      9.352742860055645_REALK,      0.000000000000000_REALK, &
      0.605563367484582_REALK,      0.000000000000000_REALK,     -5.509912773732899_REALK, &
      2.638666556115957_REALK,      0.000000000000000_REALK,      0.783008096451043_REALK, &
      0.000000000000000_REALK,      0.899839211432804_REALK,      0.000000000000000_REALK, &
      0.060893497347829_REALK,      0.000000000000000_REALK,     -1.662177124094038_REALK, &
   -137.355901935332781_REALK,     17.314116769283530_REALK,      0.000000000000000_REALK, &
     -2.357015424736384_REALK,      0.000000000000000_REALK,     -8.072270365963707_REALK, &
     -2.847476291665630_REALK,      0.000000000000000_REALK,      1.141515500995216_REALK, &
      0.000000000000000_REALK,     -7.992734528422908_REALK,      0.000000000000000_REALK, &
     -0.179000352008898_REALK,      0.000000000000000_REALK,     -1.839113000942845_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.662681785644064_REALK, &
      0.000000000000000_REALK,     -0.196320419994846_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.002243403472845_REALK,      0.000000000000000_REALK, &
      1.673391600826655_REALK,      0.000000000000000_REALK,     -0.223001889564364_REALK, &
      0.000000000000000_REALK,     -0.059224043012734_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     12.193224525374081_REALK, &
      0.000000000000000_REALK,     -1.396835120272096_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.867069439418239_REALK,      0.000000000000000_REALK, &
      2.411688968308636_REALK,      0.000000000000000_REALK,     -1.175142738284772_REALK, &
      0.000000000000000_REALK,     -0.318242268085787_REALK,      0.000000000000000_REALK, &
     -9.051989824966622_REALK,     -0.615614193682787_REALK,      0.000000000000000_REALK, &
     -0.240438991825058_REALK,      0.000000000000000_REALK,     -1.975911142423049_REALK, &
      0.030955305409478_REALK,      0.000000000000000_REALK,     -0.154616962688826_REALK, &
      0.000000000000000_REALK,      0.006681805337048_REALK,      0.000000000000000_REALK, &
     -0.072533306490274_REALK,      0.000000000000000_REALK,     -0.993456229118314_REALK, &
    -24.260518988844893_REALK,     -1.769562065779593_REALK,      0.000000000000000_REALK, &
     -1.177197514694071_REALK,      0.000000000000000_REALK,     -4.277300044713466_REALK, &
     -0.919978518519704_REALK,      0.000000000000000_REALK,     -0.350000387829909_REALK, &
      0.000000000000000_REALK,     -1.105978129057989_REALK,      0.000000000000000_REALK, &
     -0.268202024436653_REALK,      0.000000000000000_REALK,     -1.624168865456233_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.675367416447161_REALK, &
      0.000000000000000_REALK,      0.446896375146869_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.174468605465053_REALK,      0.000000000000000_REALK, &
      1.119903743428146_REALK,      0.000000000000000_REALK,      0.041145516729472_REALK, &
      0.000000000000000_REALK,      0.224692284044520_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.506888620732526_REALK, &
      0.000000000000000_REALK,      0.698977150424025_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.058754418707900_REALK,      0.000000000000000_REALK, &
      2.474636690683869_REALK,      0.000000000000000_REALK,     -0.310544984406367_REALK, &
      0.000000000000000_REALK,      0.265414376713446_REALK,      0.000000000000000_REALK, &
     -4.257736327462565_REALK,     -1.128481513912952_REALK,      0.000000000000000_REALK, &
     -0.545999040224777_REALK,      0.000000000000000_REALK,     -1.548998031300022_REALK, &
     -0.332412556921124_REALK,      0.000000000000000_REALK,     -0.472380228618792_REALK, &
      0.000000000000000_REALK,     -0.296747536693701_REALK,      0.000000000000000_REALK, &
     -0.274519504424046_REALK,      0.000000000000000_REALK,     -1.090335690743602_REALK, &
    -20.035126471686958_REALK,     -5.792631579519353_REALK,      0.000000000000000_REALK, &
     -2.848051538381324_REALK,      0.000000000000000_REALK,     -5.887222733678955_REALK, &
     -1.560664527799584_REALK,      0.000000000000000_REALK,     -1.909533944955994_REALK, &
      0.000000000000000_REALK,     -0.631726839496239_REALK,      0.000000000000000_REALK, &
     -1.081457131250550_REALK,      0.000000000000000_REALK,     -3.129680236440660_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.470639778088229_REALK, &
      0.000000000000000_REALK,      0.918813232300142_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.513419268717851_REALK,      0.000000000000000_REALK, &
      1.447887197394741_REALK,      0.000000000000000_REALK,      0.361773627880093_REALK, &
      0.000000000000000_REALK,      0.646750247618809_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     14.354913286367914_REALK, &
      0.000000000000000_REALK,      6.257681960742066_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.594747955002999_REALK,      0.000000000000000_REALK, &
      6.624911553462084_REALK,      0.000000000000000_REALK,      4.845729724556842_REALK, &
      0.000000000000000_REALK,      3.326618414898532_REALK,      0.000000000000000_REALK, &
    -28.897438556164968_REALK,     -1.714148374898241_REALK,      0.000000000000000_REALK, &
    -10.256514994831456_REALK,      0.000000000000000_REALK,    -12.522746433173305_REALK, &
     -1.709089869637400_REALK,      0.000000000000000_REALK,     -0.868946970894826_REALK, &
      0.000000000000000_REALK,    -31.012142932643535_REALK,      0.000000000000000_REALK, &
    -12.795080880843946_REALK,      0.000000000000000_REALK,    -46.866665785648422_REALK, &
     -7.284360292388422_REALK,     -0.650674805024998_REALK,      0.000000000000000_REALK, &
     -5.614575789015500_REALK,      0.000000000000000_REALK,     -4.994291003216730_REALK, &
     -3.191852472253702_REALK,      0.000000000000000_REALK,     -0.551807623787118_REALK, &
      0.000000000000000_REALK,    -64.442087733685625_REALK,      0.000000000000000_REALK, &
     -8.353034011587791_REALK,      0.000000000000000_REALK,    -22.290632906899258_REALK, &
    -19.689533645564563_REALK,      1.270988072593687_REALK,      0.000000000000000_REALK, &
     -4.763600230655423_REALK,      0.000000000000000_REALK,     -7.550260589863843_REALK, &
      1.090374123231897_REALK,      0.000000000000000_REALK,      0.548897411932659_REALK, &
      0.000000000000000_REALK,    -14.894909838355272_REALK,      0.000000000000000_REALK, &
     -5.102800486148438_REALK,      0.000000000000000_REALK,    -24.263669205845776_REALK, &
     -9.127334340444406_REALK,      0.249717129993039_REALK,      0.000000000000000_REALK, &
     -2.999095578935218_REALK,      0.000000000000000_REALK,     -3.271110121982749_REALK, &
     -1.200578728918745_REALK,      0.000000000000000_REALK,      0.117175086246010_REALK, &
      0.000000000000000_REALK,    -15.777372306999474_REALK,      0.000000000000000_REALK, &
     -3.539396491527912_REALK,      0.000000000000000_REALK,    -11.581247130434253_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.453204871414533_REALK, &
      0.000000000000000_REALK,      1.019358964285105_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.221440413818928_REALK,      0.000000000000000_REALK, &
      4.473972473064978_REALK,      0.000000000000000_REALK,      2.147692267080746_REALK, &
      0.000000000000000_REALK,      3.275832458634831_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.160817193167822_REALK, &
      0.000000000000000_REALK,      0.796957293457936_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.139850983865434_REALK,      0.000000000000000_REALK, &
      3.041768992519959_REALK,      0.000000000000000_REALK,      5.440377959770213_REALK, &
      0.000000000000000_REALK,      2.821598486064986_REALK,      0.000000000000000_REALK, &
    -16.189601244807204_REALK,      5.515360550000157_REALK,      0.000000000000000_REALK, &
     -3.193678826969336_REALK,      0.000000000000000_REALK,     -5.225669889796095_REALK, &
      4.848894886131608_REALK,      0.000000000000000_REALK,      2.075045605394806_REALK, &
      0.000000000000000_REALK,     -5.479245881493140_REALK,      0.000000000000000_REALK, &
     -2.741682280809112_REALK,      0.000000000000000_REALK,    -13.458266142379273_REALK, &
     -4.047893454562189_REALK,      2.732515311147422_REALK,      0.000000000000000_REALK, &
     -0.529728744520439_REALK,      0.000000000000000_REALK,     -2.259435307211511_REALK, &
      4.179154059186831_REALK,      0.000000000000000_REALK,      1.387199660201836_REALK, &
      0.000000000000000_REALK,      6.292457258006236_REALK,      0.000000000000000_REALK, &
     -0.501489239885166_REALK,      0.000000000000000_REALK,     -6.416958716157538_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.330710891111867_REALK, &
      0.000000000000000_REALK,     -0.427023427660051_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.790613164172815_REALK,      0.000000000000000_REALK, &
      3.759342803495649_REALK,      0.000000000000000_REALK,     -0.728218892145450_REALK, &
      0.000000000000000_REALK,     -1.099762338547615_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.739499043797285_REALK, &
      0.000000000000000_REALK,     -0.106054581358802_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.809646990091069_REALK,      0.000000000000000_REALK, &
      2.649243141620766_REALK,      0.000000000000000_REALK,      1.028709797658640_REALK, &
      0.000000000000000_REALK,     -0.301202635927073_REALK,      0.000000000000000_REALK, &
     -3.594402873078315_REALK,     -0.449678519554004_REALK,      0.000000000000000_REALK, &
     -0.950238898658644_REALK,      0.000000000000000_REALK,     -3.480597683960858_REALK, &
     -0.332757234690128_REALK,      0.000000000000000_REALK,     -0.507548016515956_REALK, &
      0.000000000000000_REALK,     -1.977185569867350_REALK,      0.000000000000000_REALK, &
     -2.447259062797096_REALK,      0.000000000000000_REALK,    -14.939969724188455_REALK, &
     -1.644100220720047_REALK,     -0.423803051019590_REALK,      0.000000000000000_REALK, &
     -1.031673393877133_REALK,      0.000000000000000_REALK,     -2.753089819917868_REALK, &
     -1.244501894780444_REALK,      0.000000000000000_REALK,     -0.645448659667356_REALK, &
      0.000000000000000_REALK,     -7.534868236606183_REALK,      0.000000000000000_REALK, &
     -2.930026611489065_REALK,      0.000000000000000_REALK,    -13.031621706464991_REALK, &
    -14.581013691459143_REALK,     10.906065803249170_REALK,      0.000000000000000_REALK, &
     -4.441471203649567_REALK,      0.000000000000000_REALK,     -3.840288961124446_REALK, &
      7.621716737561525_REALK,      0.000000000000000_REALK,      3.484874043066983_REALK, &
      0.000000000000000_REALK,    -10.692106111037480_REALK,      0.000000000000000_REALK, &
     -2.901238794603795_REALK,      0.000000000000000_REALK,     -7.525611315917939_REALK, &
    -11.932919573582307_REALK,      7.350134465129896_REALK,      0.000000000000000_REALK, &
     -4.286228341249380_REALK,      0.000000000000000_REALK,     -2.702189572058281_REALK, &
      2.495902974146346_REALK,      0.000000000000000_REALK,      2.295242676679302_REALK, &
      0.000000000000000_REALK,    -15.765342656172635_REALK,      0.000000000000000_REALK, &
     -2.610618183253510_REALK,      0.000000000000000_REALK,     -4.937477429882170_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.214450908219729_REALK, &
      0.000000000000000_REALK,     -1.466464139613109_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.627733111035619_REALK,      0.000000000000000_REALK, &
      3.081392520875135_REALK,      0.000000000000000_REALK,     -2.238428343422243_REALK, &
      0.000000000000000_REALK,     -2.873752271034546_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.570188356062884_REALK, &
      0.000000000000000_REALK,     -1.408736849183890_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.188170659248197_REALK,      0.000000000000000_REALK, &
      2.407795134875330_REALK,      0.000000000000000_REALK,     -2.584921371846089_REALK, &
      0.000000000000000_REALK,     -2.574063074409185_REALK,      0.000000000000000_REALK, &
     -3.362469006767236_REALK,      0.262673661716223_REALK,      0.000000000000000_REALK, &
     -0.558737528732479_REALK,      0.000000000000000_REALK,     -2.656780841590258_REALK, &
      0.166732343087715_REALK,      0.000000000000000_REALK,      0.251800596665988_REALK, &
      0.000000000000000_REALK,     -1.065353552663450_REALK,      0.000000000000000_REALK, &
     -1.094928405498419_REALK,      0.000000000000000_REALK,     -8.677255005107464_REALK, &
     -3.960247832586391_REALK,      0.120640873958866_REALK,      0.000000000000000_REALK, &
     -0.822217293223788_REALK,      0.000000000000000_REALK,     -2.690374387422970_REALK, &
     -0.385996319372339_REALK,      0.000000000000000_REALK,      0.113018374198159_REALK, &
      0.000000000000000_REALK,     -2.232338861409789_REALK,      0.000000000000000_REALK, &
     -1.502366588092105_REALK,      0.000000000000000_REALK,     -8.193147607155545_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.141009788659273_REALK, &
      0.000000000000000_REALK,      0.358691376911110_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.560322235640802_REALK,      0.000000000000000_REALK, &
      3.420642041343716_REALK,      0.000000000000000_REALK,      0.460838960072875_REALK, &
      0.000000000000000_REALK,      1.171514223855894_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.131737994782858_REALK, &
      0.000000000000000_REALK,      0.655469675502558_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.099415491397002_REALK,      0.000000000000000_REALK, &
      4.889773603398046_REALK,      0.000000000000000_REALK,      2.309275632983151_REALK, &
      0.000000000000000_REALK,      1.996138466271570_REALK,      0.000000000000000_REALK, &
    -10.593286253178665_REALK,     19.751368680148687_REALK,      0.000000000000000_REALK, &
     -7.733840635177544_REALK,      0.000000000000000_REALK,     -2.249045626910445_REALK, &
     12.508925130849729_REALK,      0.000000000000000_REALK,      5.188447077617870_REALK, &
      0.000000000000000_REALK,    -15.977541919996339_REALK,      0.000000000000000_REALK, &
     -3.699693133281944_REALK,      0.000000000000000_REALK,     -3.227676540606918_REALK, &
     -7.112210234901145_REALK,     13.618253874346250_REALK,      0.000000000000000_REALK, &
     -6.124971525931477_REALK,      0.000000000000000_REALK,     -2.626691835572983_REALK, &
     12.776597570798613_REALK,      0.000000000000000_REALK,      4.608220442310052_REALK, &
      0.000000000000000_REALK,     -3.863513636706565_REALK,      0.000000000000000_REALK, &
     -2.909361409991268_REALK,      0.000000000000000_REALK,     -3.743035782289444_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.112952610923746_REALK, &
      0.000000000000000_REALK,     -2.612723827489909_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.945748479603073_REALK,      0.000000000000000_REALK, &
      2.453205669712907_REALK,      0.000000000000000_REALK,     -2.733566913872481_REALK, &
      0.000000000000000_REALK,     -3.749602633299397_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.651885230984307_REALK, &
      0.000000000000000_REALK,     -2.291394154982305_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.423396962006908_REALK,      0.000000000000000_REALK, &
      2.692078994452285_REALK,      0.000000000000000_REALK,     -1.183566022492103_REALK, &
      0.000000000000000_REALK,     -3.265236598094016_REALK,      0.000000000000000_REALK, &
     -3.627142612649640_REALK,      1.188721322391849_REALK,      0.000000000000000_REALK, &
     -0.470632004554090_REALK,      0.000000000000000_REALK,     -2.310220559379029_REALK, &
      0.729684921637454_REALK,      0.000000000000000_REALK,      0.936788397474176_REALK, &
      0.000000000000000_REALK,     -0.449941038902188_REALK,      0.000000000000000_REALK, &
     -0.675418880872056_REALK,      0.000000000000000_REALK,     -5.525784369686037_REALK, &
     -2.169526353920999_REALK,      1.382511605893189_REALK,      0.000000000000000_REALK, &
     -0.187855146264663_REALK,      0.000000000000000_REALK,     -2.403757892141634_REALK, &
      1.409386194930659_REALK,      0.000000000000000_REALK,      1.403465885448636_REALK, &
      0.000000000000000_REALK,      1.119632127973304_REALK,      0.000000000000000_REALK, &
     -0.267693577462415_REALK,      0.000000000000000_REALK,     -5.708924866630525_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.153596497868477_REALK, &
      0.000000000000000_REALK,     -0.188783126894999_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.356925764504594_REALK,      0.000000000000000_REALK, &
      2.828619534342484_REALK,      0.000000000000000_REALK,     -0.179398171920057_REALK, &
      0.000000000000000_REALK,     -0.451547731069124_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.640289999487699_REALK, &
      0.000000000000000_REALK,     -0.112828871942175_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.819140865189985_REALK,      0.000000000000000_REALK, &
      4.467180029660776_REALK,      0.000000000000000_REALK,      0.549122461668244_REALK, &
      0.000000000000000_REALK,     -0.267968564891810_REALK,      0.000000000000000_REALK, &
     -2.415886277400634_REALK,     -0.290756573157540_REALK,      0.000000000000000_REALK, &
     -0.420091870764638_REALK,      0.000000000000000_REALK,     -2.564566999060593_REALK, &
     -0.150224706301813_REALK,      0.000000000000000_REALK,     -0.381891279720183_REALK, &
      0.000000000000000_REALK,     -0.487083596164206_REALK,      0.000000000000000_REALK, &
     -1.004811892907474_REALK,      0.000000000000000_REALK,     -8.587812905241872_REALK, &
     -2.643537037754317_REALK,     -0.643267359846735_REALK,      0.000000000000000_REALK, &
     -1.097572059146615_REALK,      0.000000000000000_REALK,     -4.881574731881198_REALK, &
     -1.259094854050361_REALK,      0.000000000000000_REALK,     -1.088361923954382_REALK, &
      0.000000000000000_REALK,     -4.022091948427253_REALK,      0.000000000000000_REALK, &
     -2.606733582390159_REALK,      0.000000000000000_REALK,    -16.231235621841748_REALK, &
      9.383242566334909_REALK,     39.105833020657172_REALK,      0.000000000000000_REALK, &
    -16.062104563558613_REALK,      0.000000000000000_REALK,      1.472680258894006_REALK, &
     21.967830220168587_REALK,      0.000000000000000_REALK,      7.772480397303306_REALK, &
      0.000000000000000_REALK,    -27.358871583883907_REALK,      0.000000000000000_REALK, &
     -5.298716943155471_REALK,      0.000000000000000_REALK,      1.457464520064748_REALK, &
    -42.252527309606627_REALK,     78.288755479934593_REALK,      0.000000000000000_REALK, &
    -39.961914733886047_REALK,      0.000000000000000_REALK,     -5.336174192968477_REALK, &
     28.622654336947537_REALK,      0.000000000000000_REALK,     12.280111139775279_REALK, &
      0.000000000000000_REALK,    -50.497268678258642_REALK,      0.000000000000000_REALK, &
     -9.133633938229980_REALK,      0.000000000000000_REALK,     -3.658883366857956_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.546671434688909_REALK, &
      0.000000000000000_REALK,     -4.740535508129994_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.740555850449929_REALK,      0.000000000000000_REALK, &
      1.518491151489031_REALK,      0.000000000000000_REALK,     -3.770320567288922_REALK, &
      0.000000000000000_REALK,     -4.691556274676633_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      9.028025809648085_REALK, &
      0.000000000000000_REALK,    -10.214834277874813_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.302103259454644_REALK,      0.000000000000000_REALK, &
      4.248317384876027_REALK,      0.000000000000000_REALK,     -6.473074536009106_REALK, &
      0.000000000000000_REALK,     -7.004060565297113_REALK,      0.000000000000000_REALK, &
     -4.760441098012174_REALK,      2.958476723898217_REALK,      0.000000000000000_REALK, &
     -0.864103301478933_REALK,      0.000000000000000_REALK,     -2.241423765540116_REALK, &
      1.286032574360139_REALK,      0.000000000000000_REALK,      1.764036249801685_REALK, &
      0.000000000000000_REALK,     -1.050542725558829_REALK,      0.000000000000000_REALK, &
     -0.855175382416124_REALK,      0.000000000000000_REALK,     -3.697108942437189_REALK, &
    -15.750245104229098_REALK,      7.875596707272069_REALK,      0.000000000000000_REALK, &
     -3.155179805426672_REALK,      0.000000000000000_REALK,     -5.967410009034406_REALK, &
      1.343338509691263_REALK,      0.000000000000000_REALK,      3.706018914126314_REALK, &
      0.000000000000000_REALK,     -4.354933045968777_REALK,      0.000000000000000_REALK, &
     -2.163429170796931_REALK,      0.000000000000000_REALK,     -6.819510394434714_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.615941907094034_REALK, &
      0.000000000000000_REALK,     -0.855916731036492_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.317757241548123_REALK,      0.000000000000000_REALK, &
      2.599657854447478_REALK,      0.000000000000000_REALK,     -0.659803949319044_REALK, &
      0.000000000000000_REALK,     -1.411788992758400_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.261794549517866_REALK, &
      0.000000000000000_REALK,     -3.110999487542329_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.303830191614581_REALK,      0.000000000000000_REALK, &
      6.479586669893618_REALK,      0.000000000000000_REALK,     -2.142134125909901_REALK, &
      0.000000000000000_REALK,     -3.555226356200867_REALK,      0.000000000000000_REALK, &
     -3.293358607841434_REALK,      0.213765603890921_REALK,      0.000000000000000_REALK, &
     -0.326112849391790_REALK,      0.000000000000000_REALK,     -2.584428662554099_REALK, &
      0.084399577599152_REALK,      0.000000000000000_REALK,      0.212434928183505_REALK, &
      0.000000000000000_REALK,     -0.314025902832228_REALK,      0.000000000000000_REALK, &
     -0.537905750026492_REALK,      0.000000000000000_REALK,     -5.968028113579057_REALK, &
    -15.681377969264867_REALK,      0.387796525718151_REALK,      0.000000000000000_REALK, &
     -1.815752586687499_REALK,      0.000000000000000_REALK,     -9.902196360541758_REALK, &
     -0.623249852798421_REALK,      0.000000000000000_REALK,      0.304142300273132_REALK, &
      0.000000000000000_REALK,     -1.849947664831906_REALK,      0.000000000000000_REALK, &
     -2.075028131113912_REALK,      0.000000000000000_REALK,    -15.842615685649001_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.903947096807181_REALK, &
      0.000000000000000_REALK,      0.348923125682129_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.472723319420365_REALK,      0.000000000000000_REALK, &
      4.040218325223199_REALK,      0.000000000000000_REALK,      0.226396470504013_REALK, &
      0.000000000000000_REALK,      0.805742117675973_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     16.778132125855485_REALK, &
      0.000000000000000_REALK,      2.412522757259838_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.958622957388529_REALK,      0.000000000000000_REALK, &
     18.422330023281919_REALK,      0.000000000000000_REALK,      3.189509097790289_REALK, &
      0.000000000000000_REALK,      3.859817507603819_REALK,      0.000000000000000_REALK/
    ! results of test 4, ket-major order, 02 DPG Z
  data REF_CONTR_INTS(23941:25200)                                                         &
     /0.000000000000000_REALK,      0.000000000000000_REALK,      6.211621733410870_REALK, &
      0.000000000000000_REALK,      4.859170216875379_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.177081100116741_REALK,      0.000000000000000_REALK, &
      3.940273005623677_REALK,      0.000000000000000_REALK,      7.623079027427091_REALK, &
      0.000000000000000_REALK,      4.367706528130445_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.586167934375363_REALK, &
      0.000000000000000_REALK,      2.833046335203413_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.164861827890839_REALK,      0.000000000000000_REALK, &
      2.645937962884114_REALK,      0.000000000000000_REALK,      0.475792142084014_REALK, &
      0.000000000000000_REALK,      2.566034180281501_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.300054562942255_REALK, &
      0.000000000000000_REALK,      1.293166258007054_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.490316059229872_REALK,      0.000000000000000_REALK, &
      1.804342931667367_REALK,      0.000000000000000_REALK,     -0.496430834068408_REALK, &
      0.000000000000000_REALK,      0.956952591415576_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.252740859773023_REALK, &
      0.000000000000000_REALK,     -0.429512993775141_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.499339465821129_REALK,      0.000000000000000_REALK, &
      0.617531996032063_REALK,      0.000000000000000_REALK,     -3.230729900248499_REALK, &
      0.000000000000000_REALK,     -0.289111050501102_REALK,      0.000000000000000_REALK, &
     -5.955487982959789_REALK,     -3.994314244361493_REALK,      0.000000000000000_REALK, &
     -3.563575162119177_REALK,      0.000000000000000_REALK,     -2.712234702000821_REALK, &
     -3.811686406944702_REALK,      0.000000000000000_REALK,     -2.183937427763691_REALK, &
      0.000000000000000_REALK,     -5.228057418123846_REALK,      0.000000000000000_REALK, &
     -2.637071965788581_REALK,      0.000000000000000_REALK,     -3.345122885445173_REALK, &
     -6.989821363372716_REALK,     -3.658078890679596_REALK,      0.000000000000000_REALK, &
     -2.100636241988287_REALK,      0.000000000000000_REALK,     -2.567440151273846_REALK, &
     -0.334353687490897_REALK,      0.000000000000000_REALK,     -1.803230685245962_REALK, &
      0.000000000000000_REALK,      3.891090721156866_REALK,      0.000000000000000_REALK, &
     -1.413966886784952_REALK,      0.000000000000000_REALK,     -2.880298268004151_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.571278720541648_REALK, &
      0.000000000000000_REALK,      0.504600618623847_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.017972819362684_REALK,      0.000000000000000_REALK, &
      1.202897398899180_REALK,      0.000000000000000_REALK,     -0.407742491812164_REALK, &
      0.000000000000000_REALK,      0.306658201365707_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.011296997498101_REALK, &
      0.000000000000000_REALK,      0.016944119217806_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.176472182518933_REALK,      0.000000000000000_REALK, &
      0.553709303945545_REALK,      0.000000000000000_REALK,     -0.212743087780571_REALK, &
      0.000000000000000_REALK,      0.010336296541192_REALK,      0.000000000000000_REALK, &
     -3.616132631806488_REALK,     -1.222722722071173_REALK,      0.000000000000000_REALK, &
     -0.388915371330968_REALK,      0.000000000000000_REALK,     -1.431192570726774_REALK, &
      0.296739758195250_REALK,      0.000000000000000_REALK,     -0.572014994019983_REALK, &
      0.000000000000000_REALK,      1.324872804517070_REALK,      0.000000000000000_REALK, &
     -0.236353432504877_REALK,      0.000000000000000_REALK,     -1.449618184324244_REALK, &
     -0.991266466390994_REALK,      0.433583168012831_REALK,      0.000000000000000_REALK, &
      1.483761013013378_REALK,      0.000000000000000_REALK,     -0.611115708542296_REALK, &
      2.652842562229552_REALK,      0.000000000000000_REALK,      0.237397159051033_REALK, &
      0.000000000000000_REALK,      4.433125363884175_REALK,      0.000000000000000_REALK, &
      0.905127828105032_REALK,      0.000000000000000_REALK,     -0.621324042014899_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.564489273666347_REALK, &
      0.000000000000000_REALK,      1.732284349438596_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.576300349957197_REALK,      0.000000000000000_REALK, &
      1.999535258568592_REALK,      0.000000000000000_REALK,      1.837396815695969_REALK, &
      0.000000000000000_REALK,      1.754586311254603_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.591769866351092_REALK, &
      0.000000000000000_REALK,      1.784494738669509_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.161047705831991_REALK,      0.000000000000000_REALK, &
      2.365093360695287_REALK,      0.000000000000000_REALK,      0.201844101270158_REALK, &
      0.000000000000000_REALK,      1.814303688296899_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.417450416763578_REALK, &
      0.000000000000000_REALK,     -0.019674870264106_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.306233763932287_REALK,      0.000000000000000_REALK, &
      0.951227916492390_REALK,      0.000000000000000_REALK,     -0.623169643557493_REALK, &
      0.000000000000000_REALK,     -0.009730452734738_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.168042656535920_REALK, &
      0.000000000000000_REALK,     -0.806253196373499_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.025176857471578_REALK,      0.000000000000000_REALK, &
      0.387447791494563_REALK,      0.000000000000000_REALK,     -1.404629835276401_REALK, &
      0.000000000000000_REALK,     -0.339517472823671_REALK,      0.000000000000000_REALK, &
     -3.351897614937781_REALK,     -0.564923699987577_REALK,      0.000000000000000_REALK, &
     -0.016850430402729_REALK,      0.000000000000000_REALK,     -1.127777367186891_REALK, &
      0.295561727074364_REALK,      0.000000000000000_REALK,     -0.222288403679350_REALK, &
      0.000000000000000_REALK,      0.533097708987965_REALK,      0.000000000000000_REALK, &
     -0.008333590737463_REALK,      0.000000000000000_REALK,     -0.929593962536301_REALK, &
     -3.242803154941400_REALK,     -0.035806446229806_REALK,      0.000000000000000_REALK, &
      0.273262760575350_REALK,      0.000000000000000_REALK,     -0.857405007365293_REALK, &
      0.244459097404684_REALK,      0.000000000000000_REALK,     -0.011877244752474_REALK, &
      0.000000000000000_REALK,      0.031972130892319_REALK,      0.000000000000000_REALK, &
      0.115072389547939_REALK,      0.000000000000000_REALK,     -0.601762950308087_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.602286189530827_REALK, &
      0.000000000000000_REALK,      0.536293090780347_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.171326339819586_REALK,      0.000000000000000_REALK, &
      1.050789806706369_REALK,      0.000000000000000_REALK,     -0.137591529210334_REALK, &
      0.000000000000000_REALK,      0.442050739662279_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.291414530128808_REALK, &
      0.000000000000000_REALK,     -0.367603562833881_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.040065433865651_REALK,      0.000000000000000_REALK, &
      0.713951819029034_REALK,      0.000000000000000_REALK,     -1.729841657607887_REALK, &
      0.000000000000000_REALK,     -0.257999664819353_REALK,      0.000000000000000_REALK, &
     -3.343046948300104_REALK,     -1.939372343189547_REALK,      0.000000000000000_REALK, &
     -1.477861586696722_REALK,      0.000000000000000_REALK,     -1.874665795744105_REALK, &
     -1.331880260392905_REALK,      0.000000000000000_REALK,     -1.271853120214774_REALK, &
      0.000000000000000_REALK,     -1.449016389783650_REALK,      0.000000000000000_REALK, &
     -1.218158165280797_REALK,      0.000000000000000_REALK,     -2.163325208220405_REALK, &
     -8.310713391098695_REALK,     -3.771008341371599_REALK,      0.000000000000000_REALK, &
     -1.797853331480658_REALK,      0.000000000000000_REALK,     -3.662287911539190_REALK, &
     -0.231935276147988_REALK,      0.000000000000000_REALK,     -2.084782385581009_REALK, &
      0.000000000000000_REALK,      2.083421093936369_REALK,      0.000000000000000_REALK, &
     -1.261809198312849_REALK,      0.000000000000000_REALK,     -3.598487090035324_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.770233510510855_REALK, &
      0.000000000000000_REALK,     -0.485729476439988_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.438668579580352_REALK,      0.000000000000000_REALK, &
      0.908766266315947_REALK,      0.000000000000000_REALK,     -0.575725882868478_REALK, &
      0.000000000000000_REALK,     -0.193675267630952_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.199244455998314_REALK, &
      0.000000000000000_REALK,     -0.732487988106106_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.432759042380753_REALK,      0.000000000000000_REALK, &
      0.480759535020686_REALK,      0.000000000000000_REALK,     -0.176558465378530_REALK, &
      0.000000000000000_REALK,     -0.299891198189940_REALK,      0.000000000000000_REALK, &
     -3.787628151215093_REALK,      0.026674772115247_REALK,      0.000000000000000_REALK, &
      0.349083469058506_REALK,      0.000000000000000_REALK,     -1.084328314064942_REALK, &
      0.560415035990385_REALK,      0.000000000000000_REALK,      0.008750573902173_REALK, &
      0.000000000000000_REALK,      0.707567935209299_REALK,      0.000000000000000_REALK, &
      0.139190305663486_REALK,      0.000000000000000_REALK,     -0.720591696313263_REALK, &
     -1.190603496316669_REALK,      1.105120509119342_REALK,      0.000000000000000_REALK, &
      1.476715286737693_REALK,      0.000000000000000_REALK,     -0.558098900051147_REALK, &
      1.832861231060892_REALK,      0.000000000000000_REALK,      0.443026623511683_REALK, &
      0.000000000000000_REALK,      2.320439985557827_REALK,      0.000000000000000_REALK, &
      0.604588640245412_REALK,      0.000000000000000_REALK,     -0.380822963567337_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.529016652339797_REALK, &
      0.000000000000000_REALK,      0.253392069154801_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.007494379101015_REALK,      0.000000000000000_REALK, &
      0.835981725613633_REALK,      0.000000000000000_REALK,     -0.134339618876922_REALK, &
      0.000000000000000_REALK,      0.168392006900642_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.175233614605179_REALK, &
      0.000000000000000_REALK,      0.017108568889822_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.150154664432606_REALK,      0.000000000000000_REALK, &
      0.785223234056877_REALK,      0.000000000000000_REALK,     -0.144167508482424_REALK, &
      0.000000000000000_REALK,      0.011674160093168_REALK,      0.000000000000000_REALK, &
     -2.510440022134958_REALK,     -0.727094806294371_REALK,      0.000000000000000_REALK, &
     -0.195299147544494_REALK,      0.000000000000000_REALK,     -1.197821384115842_REALK, &
      0.123735747707787_REALK,      0.000000000000000_REALK,     -0.397535219724734_REALK, &
      0.000000000000000_REALK,      0.436508117729397_REALK,      0.000000000000000_REALK, &
     -0.129786285382559_REALK,      0.000000000000000_REALK,     -1.114419115142738_REALK, &
     -1.316358307774030_REALK,      0.503869303514510_REALK,      0.000000000000000_REALK, &
      1.498161526182773_REALK,      0.000000000000000_REALK,     -1.028411397965630_REALK, &
      2.257220821085371_REALK,      0.000000000000000_REALK,      0.336656371236088_REALK, &
      0.000000000000000_REALK,      3.004152309571717_REALK,      0.000000000000000_REALK, &
      1.022281735819945_REALK,      0.000000000000000_REALK,     -0.982441905592952_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.541632154238439_REALK, &
      0.000000000000000_REALK,      1.449816942574724_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.095486853532583_REALK,      0.000000000000000_REALK, &
      1.945473414755471_REALK,      0.000000000000000_REALK,      1.008950472839021_REALK, &
      0.000000000000000_REALK,      1.348868650776080_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.019849222981428_REALK, &
      0.000000000000000_REALK,      3.003023327996168_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.646498673530278_REALK,      0.000000000000000_REALK, &
      4.695562711368019_REALK,      0.000000000000000_REALK,      0.227969499781560_REALK, &
      0.000000000000000_REALK,      2.868789636844577_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.302252659510170_REALK, &
      0.000000000000000_REALK,     -1.458125860113063_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.700546448727510_REALK,      0.000000000000000_REALK, &
      1.080548898578760_REALK,      0.000000000000000_REALK,     -0.731556166635766_REALK, &
      0.000000000000000_REALK,     -0.439873288064390_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.521923760980751_REALK, &
      0.000000000000000_REALK,     -4.807869876262475_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.552862666384057_REALK,      0.000000000000000_REALK, &
      0.894387996152757_REALK,      0.000000000000000_REALK,     -2.301842197307848_REALK, &
      0.000000000000000_REALK,     -1.095381546381116_REALK,      0.000000000000000_REALK, &
     -6.479183260636566_REALK,      0.933354788770063_REALK,      0.000000000000000_REALK, &
      0.682696927009017_REALK,      0.000000000000000_REALK,     -1.414306759733891_REALK, &
      0.696846082671694_REALK,      0.000000000000000_REALK,      0.234420330186635_REALK, &
      0.000000000000000_REALK,      0.565261965122968_REALK,      0.000000000000000_REALK, &
      0.205949397270567_REALK,      0.000000000000000_REALK,     -0.711090610389881_REALK, &
    -11.337824044811335_REALK,      4.427441362979427_REALK,      0.000000000000000_REALK, &
      1.799358030560431_REALK,      0.000000000000000_REALK,     -1.998938081915037_REALK, &
      0.515561370999749_REALK,      0.000000000000000_REALK,      0.875700391697925_REALK, &
      0.000000000000000_REALK,     -0.746425883833616_REALK,      0.000000000000000_REALK, &
      0.409949443877371_REALK,      0.000000000000000_REALK,     -0.759033259926167_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.083594003701612_REALK, &
      0.000000000000000_REALK,     -0.013618458651162_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.168472917639581_REALK,      0.000000000000000_REALK, &
      0.872188511448876_REALK,      0.000000000000000_REALK,     -0.263107831871605_REALK, &
      0.000000000000000_REALK,     -0.006847141193503_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.373366109536577_REALK, &
      0.000000000000000_REALK,     -1.842049350101054_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.765435305452666_REALK,      0.000000000000000_REALK, &
      1.112026029361033_REALK,      0.000000000000000_REALK,     -1.736255904080501_REALK, &
      0.000000000000000_REALK,     -0.699459746053059_REALK,      0.000000000000000_REALK, &
     -3.576153079329286_REALK,     -0.486906215606638_REALK,      0.000000000000000_REALK, &
     -0.011663451225520_REALK,      0.000000000000000_REALK,     -1.301032674047681_REALK, &
      0.162601751888540_REALK,      0.000000000000000_REALK,     -0.203818021481490_REALK, &
      0.000000000000000_REALK,      0.225078650472811_REALK,      0.000000000000000_REALK, &
     -0.005864195015774_REALK,      0.000000000000000_REALK,     -0.915793519858268_REALK, &
    -11.110822207511520_REALK,     -0.103410822831416_REALK,      0.000000000000000_REALK, &
      0.624324334822803_REALK,      0.000000000000000_REALK,     -3.264860103696622_REALK, &
      0.420977822657575_REALK,      0.000000000000000_REALK,     -0.034089251795434_REALK, &
      0.000000000000000_REALK,      0.039520590858659_REALK,      0.000000000000000_REALK, &
      0.237067340604065_REALK,      0.000000000000000_REALK,     -1.735617727324827_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.301676919320820_REALK, &
      0.000000000000000_REALK,      0.618681358814345_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.157090496092925_REALK,      0.000000000000000_REALK, &
      1.348868650776080_REALK,      0.000000000000000_REALK,     -0.096820636533166_REALK, &
      0.000000000000000_REALK,      0.435488201458129_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.216117172494793_REALK, &
      0.000000000000000_REALK,     -1.399775130729723_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.985124344717063_REALK,      0.000000000000000_REALK, &
      2.868789636844578_REALK,      0.000000000000000_REALK,     -3.563747681318333_REALK, &
      0.000000000000000_REALK,     -0.744128218055093_REALK,      0.000000000000000_REALK, &
     -5.944517112350057_REALK,     -2.785899666023825_REALK,      0.000000000000000_REALK, &
     -1.704898739729501_REALK,      0.000000000000000_REALK,     -3.027727044188760_REALK, &
     -1.221211700791713_REALK,      0.000000000000000_REALK,     -1.632641267835256_REALK, &
      0.000000000000000_REALK,     -1.019646267550210_REALK,      0.000000000000000_REALK, &
     -1.200073794458435_REALK,      0.000000000000000_REALK,     -2.740126116792522_REALK, &
    -47.458353413248012_REALK,    -18.151437173378451_REALK,      0.000000000000000_REALK, &
     -6.845935775773332_REALK,      0.000000000000000_REALK,    -19.523563103891210_REALK, &
     -0.665684693178129_REALK,      0.000000000000000_REALK,     -8.377038818900605_REALK, &
      0.000000000000000_REALK,      4.292177298466041_REALK,      0.000000000000000_REALK, &
     -3.639337403494313_REALK,      0.000000000000000_REALK,    -13.344215605249142_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.896393742318006_REALK, &
      0.000000000000000_REALK,      4.073059299652455_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.874794973917649_REALK,      0.000000000000000_REALK, &
      4.404774882551287_REALK,      0.000000000000000_REALK,     13.640744611844257_REALK, &
      0.000000000000000_REALK,     15.243517860927131_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.115012168819193_REALK, &
      0.000000000000000_REALK,      2.057671733846373_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.712522138332074_REALK,      0.000000000000000_REALK, &
      2.836772888476302_REALK,      0.000000000000000_REALK,     -0.447479099688960_REALK, &
      0.000000000000000_REALK,      9.183847163197026_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.387378240481672_REALK, &
      0.000000000000000_REALK,     -0.708704756220379_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.264307176097865_REALK,      0.000000000000000_REALK, &
      3.093087415440262_REALK,      0.000000000000000_REALK,     -6.981538278024943_REALK, &
      0.000000000000000_REALK,     -2.277507850871536_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.784381421814500_REALK, &
      0.000000000000000_REALK,     -1.662263146150412_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.625394977774661_REALK,      0.000000000000000_REALK, &
      1.104168874038925_REALK,      0.000000000000000_REALK,    -11.924304759524860_REALK, &
      0.000000000000000_REALK,     -5.885182575177940_REALK,      0.000000000000000_REALK, &
     -4.491690508564955_REALK,     -1.123164817732078_REALK,      0.000000000000000_REALK, &
     -2.199316099682826_REALK,      0.000000000000000_REALK,     -5.167227589921576_REALK, &
     -1.302168927156512_REALK,      0.000000000000000_REALK,     -1.455172416454390_REALK, &
      0.000000000000000_REALK,     -7.108333282336742_REALK,      0.000000000000000_REALK, &
     -7.067766428278651_REALK,      0.000000000000000_REALK,    -27.675844089737524_REALK, &
     -3.810653499545673_REALK,     -0.890266998364119_REALK,      0.000000000000000_REALK, &
     -1.029071891027484_REALK,      0.000000000000000_REALK,     -4.097056194763842_REALK, &
      0.061062781658987_REALK,      0.000000000000000_REALK,     -1.253223344968764_REALK, &
      0.000000000000000_REALK,      5.755381900228013_REALK,      0.000000000000000_REALK, &
     -3.643391827404655_REALK,      0.000000000000000_REALK,    -24.175798902828284_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.710347253195208_REALK, &
      0.000000000000000_REALK,     -1.764648442791942_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.423057435500157_REALK,      0.000000000000000_REALK, &
      1.930453241959871_REALK,      0.000000000000000_REALK,     -4.695083601187418_REALK, &
      0.000000000000000_REALK,     -4.544701232889356_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.587284074006910_REALK, &
      0.000000000000000_REALK,     -1.211573963892132_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.192453249342130_REALK,      0.000000000000000_REALK, &
      0.894428951136131_REALK,      0.000000000000000_REALK,     -1.141832073101592_REALK, &
      0.000000000000000_REALK,     -3.440957164408581_REALK,      0.000000000000000_REALK, &
     -2.484995685528750_REALK,      0.312636977496503_REALK,      0.000000000000000_REALK, &
      0.205621950183845_REALK,      0.000000000000000_REALK,     -2.406316301515943_REALK, &
      1.081699369545440_REALK,      0.000000000000000_REALK,      0.352870486175930_REALK, &
      0.000000000000000_REALK,      4.266358201681940_REALK,      0.000000000000000_REALK, &
      0.529561757372551_REALK,      0.000000000000000_REALK,    -10.328769928548171_REALK, &
     -0.596812017606788_REALK,      0.883952250288490_REALK,      0.000000000000000_REALK, &
      1.471136821258029_REALK,      0.000000000000000_REALK,     -0.999377695696855_REALK, &
      2.727718547664096_REALK,      0.000000000000000_REALK,      1.346252212639865_REALK, &
      0.000000000000000_REALK,     10.104550444667453_REALK,      0.000000000000000_REALK, &
      4.178134340780344_REALK,      0.000000000000000_REALK,     -4.730507511225559_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.279463206039606_REALK, &
      0.000000000000000_REALK,      1.132074408809470_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.095059310013014_REALK,      0.000000000000000_REALK, &
      4.288015321456640_REALK,      0.000000000000000_REALK,      2.609005459638380_REALK, &
      0.000000000000000_REALK,      4.859268128310409_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.178717642454543_REALK, &
      0.000000000000000_REALK,      1.134286147830894_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.833436218248372_REALK,      0.000000000000000_REALK, &
      5.530282595231964_REALK,      0.000000000000000_REALK,     -0.156964004738273_REALK, &
      0.000000000000000_REALK,      5.369090350222068_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.777020951006009_REALK, &
      0.000000000000000_REALK,     -2.576531143906382_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.369391667338080_REALK,      0.000000000000000_REALK, &
      0.744857089237442_REALK,      0.000000000000000_REALK,     -4.129401411458512_REALK, &
      0.000000000000000_REALK,     -5.049091911750157_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.211341106249196_REALK, &
      0.000000000000000_REALK,     -2.456197236159701_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.724360890646105_REALK,      0.000000000000000_REALK, &
      0.197987858059355_REALK,      0.000000000000000_REALK,     -4.255093363103066_REALK, &
      0.000000000000000_REALK,     -4.487996897878607_REALK,      0.000000000000000_REALK, &
     -1.726655305035662_REALK,      1.085482992467100_REALK,      0.000000000000000_REALK, &
      0.298980685795398_REALK,      0.000000000000000_REALK,     -1.364278667020137_REALK, &
      1.074982121807314_REALK,      0.000000000000000_REALK,      1.040550709911991_REALK, &
      0.000000000000000_REALK,      1.335698992218401_REALK,      0.000000000000000_REALK, &
      0.585896648674048_REALK,      0.000000000000000_REALK,     -4.455841334912624_REALK, &
     -1.337046139514527_REALK,      1.378208654421547_REALK,      0.000000000000000_REALK, &
      0.195441212877738_REALK,      0.000000000000000_REALK,     -0.908315550091062_REALK, &
      0.428442480631214_REALK,      0.000000000000000_REALK,      1.291128755264691_REALK, &
      0.000000000000000_REALK,     -1.612252865733398_REALK,      0.000000000000000_REALK, &
      0.357112834506867_REALK,      0.000000000000000_REALK,     -2.766144151000186_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.480190250053028_REALK, &
      0.000000000000000_REALK,     -0.249378573926036_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.121247984045350_REALK,      0.000000000000000_REALK, &
      2.364865880267224_REALK,      0.000000000000000_REALK,     -1.498056723055203_REALK, &
      0.000000000000000_REALK,     -0.814490019233581_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.136827820912051_REALK, &
      0.000000000000000_REALK,     -1.367153665511410_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.567735119326187_REALK,      0.000000000000000_REALK, &
      1.774998636400839_REALK,      0.000000000000000_REALK,     -5.061506135246315_REALK, &
      0.000000000000000_REALK,     -4.163469528836888_REALK,      0.000000000000000_REALK, &
     -2.301197742148021_REALK,     -0.696369592475713_REALK,      0.000000000000000_REALK, &
     -0.773893935009694_REALK,      0.000000000000000_REALK,     -3.030401203076844_REALK, &
     -0.597355545298410_REALK,      0.000000000000000_REALK,     -1.112573663583049_REALK, &
      0.000000000000000_REALK,     -1.525263636645719_REALK,      0.000000000000000_REALK, &
     -2.527598406259827_REALK,      0.000000000000000_REALK,    -13.856539852041260_REALK, &
     -4.960199232138146_REALK,     -1.290291003373028_REALK,      0.000000000000000_REALK, &
     -0.846375864826927_REALK,      0.000000000000000_REALK,     -5.616143877349306_REALK, &
      0.058896618114082_REALK,      0.000000000000000_REALK,     -2.014610066201554_REALK, &
      0.000000000000000_REALK,      2.442985262970622_REALK,      0.000000000000000_REALK, &
     -2.577515762891006_REALK,      0.000000000000000_REALK,    -23.944419921388533_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.982826759255679_REALK, &
      0.000000000000000_REALK,     -3.608864430303769_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.028604168076400_REALK,      0.000000000000000_REALK, &
     -0.774530318801135_REALK,      0.000000000000000_REALK,     -3.771764653079974_REALK, &
      0.000000000000000_REALK,     -5.179195531005583_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.446986904495247_REALK, &
      0.000000000000000_REALK,     -3.185694362007794_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.658303883700839_REALK,      0.000000000000000_REALK, &
     -0.453761739885048_REALK,      0.000000000000000_REALK,     -1.753709162595895_REALK, &
      0.000000000000000_REALK,     -4.539614364709743_REALK,      0.000000000000000_REALK, &
     -0.876779855342805_REALK,      2.088545792450279_REALK,      0.000000000000000_REALK, &
      0.276944991125430_REALK,      0.000000000000000_REALK,     -0.558443674312173_REALK, &
      1.346106054359101_REALK,      0.000000000000000_REALK,      1.645907606018345_REALK, &
      0.000000000000000_REALK,      0.658103449966290_REALK,      0.000000000000000_REALK, &
      0.397452519503614_REALK,      0.000000000000000_REALK,     -1.335733644277539_REALK, &
     -0.178395524434175_REALK,      2.410472323003953_REALK,      0.000000000000000_REALK, &
      0.723146326873641_REALK,      0.000000000000000_REALK,     -0.197655884200893_REALK, &
      2.320020217797018_REALK,      0.000000000000000_REALK,      2.447007069404334_REALK, &
      0.000000000000000_REALK,      2.889228692962213_REALK,      0.000000000000000_REALK, &
      1.030483492833778_REALK,      0.000000000000000_REALK,     -0.469432714517254_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.105889395699117_REALK, &
      0.000000000000000_REALK,     -0.780134834114676_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.190991126176392_REALK,      0.000000000000000_REALK, &
      1.452519239603521_REALK,      0.000000000000000_REALK,     -1.156643179886947_REALK, &
      0.000000000000000_REALK,     -1.865993640779135_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.891406220076968_REALK, &
      0.000000000000000_REALK,     -1.288963870009315_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.194709945326918_REALK,      0.000000000000000_REALK, &
      1.508194957908367_REALK,      0.000000000000000_REALK,     -0.609506821282713_REALK, &
      0.000000000000000_REALK,     -3.061289123060698_REALK,      0.000000000000000_REALK, &
     -1.670226512735676_REALK,      0.202147205762400_REALK,      0.000000000000000_REALK, &
      0.090903571559677_REALK,      0.000000000000000_REALK,     -1.773017147200609_REALK, &
      0.488337902699975_REALK,      0.000000000000000_REALK,      0.265508202487425_REALK, &
      0.000000000000000_REALK,      1.051025825329745_REALK,      0.000000000000000_REALK, &
      0.217430986333235_REALK,      0.000000000000000_REALK,     -5.937197017477789_REALK, &
     -0.959609793391707_REALK,      1.341702540615671_REALK,      0.000000000000000_REALK, &
      1.565106437538778_REALK,      0.000000000000000_REALK,     -1.772022427900650_REALK, &
      2.759703622040282_REALK,      0.000000000000000_REALK,      2.270063817363398_REALK, &
      0.000000000000000_REALK,      5.393781246038017_REALK,      0.000000000000000_REALK, &
      3.717127706329824_REALK,      0.000000000000000_REALK,     -5.891974441485107_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.456454561820882_REALK, &
      0.000000000000000_REALK,      0.834132793540768_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.823948843581431_REALK,      0.000000000000000_REALK, &
      4.516967552619898_REALK,      0.000000000000000_REALK,      1.071222803649101_REALK, &
      0.000000000000000_REALK,      2.793210850673358_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.511592953147679_REALK, &
      0.000000000000000_REALK,      2.011232091998851_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.405348407499278_REALK,      0.000000000000000_REALK, &
     13.055304215588730_REALK,      0.000000000000000_REALK,     -0.139644923624009_REALK, &
      0.000000000000000_REALK,      6.687346556889201_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.050802029328469_REALK, &
      0.000000000000000_REALK,     -5.585339025960215_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.526183137763052_REALK,      0.000000000000000_REALK, &
     -3.607881729772310_REALK,      0.000000000000000_REALK,     -4.279991857257825_REALK, &
      0.000000000000000_REALK,     -5.527631278892502_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -7.943189651477216_REALK, &
      0.000000000000000_REALK,    -11.687920701254153_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.774219811797483_REALK,      0.000000000000000_REALK, &
     -3.737826120487509_REALK,      0.000000000000000_REALK,     -7.066350358649982_REALK, &
      0.000000000000000_REALK,     -8.014119685846287_REALK,      0.000000000000000_REALK, &
      1.502974661602216_REALK,      4.086440864672344_REALK,      0.000000000000000_REALK, &
      0.026134809205561_REALK,      0.000000000000000_REALK,      0.707666171297978_REALK, &
      1.774462582958849_REALK,      0.000000000000000_REALK,      2.436601836249890_REALK, &
      0.000000000000000_REALK,     -0.334844556157340_REALK,      0.000000000000000_REALK, &
      0.025864784243372_REALK,      0.000000000000000_REALK,      1.167257602239079_REALK, &
      2.654772997686504_REALK,     10.949335788978448_REALK,      0.000000000000000_REALK, &
     -1.459232508658926_REALK,      0.000000000000000_REALK,      1.005833169786986_REALK, &
      1.990446673987045_REALK,      0.000000000000000_REALK,      5.152428068543108_REALK, &
      0.000000000000000_REALK,     -4.153847967913087_REALK,      0.000000000000000_REALK, &
     -1.000559832050837_REALK,      0.000000000000000_REALK,      1.149458432727916_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.632344909430402_REALK, &
      0.000000000000000_REALK,     -1.503818644135326_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.186985320991853_REALK,      0.000000000000000_REALK, &
      0.628408607264050_REALK,      0.000000000000000_REALK,     -1.217191234917280_REALK, &
      0.000000000000000_REALK,     -2.480468638957587_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.679349743212347_REALK, &
      0.000000000000000_REALK,     -5.424170133281053_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.169590992997614_REALK,      0.000000000000000_REALK, &
      0.532802590760534_REALK,      0.000000000000000_REALK,     -3.526211977398022_REALK, &
      0.000000000000000_REALK,     -6.198700030514225_REALK,      0.000000000000000_REALK, &
     -1.691166550582250_REALK,      0.883373406690217_REALK,      0.000000000000000_REALK, &
      0.174503122385631_REALK,      0.000000000000000_REALK,     -1.327125231995978_REALK, &
      0.544153793601080_REALK,      0.000000000000000_REALK,      0.877874469950796_REALK, &
      0.000000000000000_REALK,      0.393713505619655_REALK,      0.000000000000000_REALK, &
      0.287833592279086_REALK,      0.000000000000000_REALK,     -3.064631192785470_REALK, &
     -5.294296408308523_REALK,      4.430211008597260_REALK,      0.000000000000000_REALK, &
      0.431604748225002_REALK,      0.000000000000000_REALK,     -3.343147695867930_REALK, &
      0.691785645573516_REALK,      0.000000000000000_REALK,      3.474540068028920_REALK, &
      0.000000000000000_REALK,     -1.336080052917440_REALK,      0.000000000000000_REALK, &
      0.493234596307560_REALK,      0.000000000000000_REALK,     -5.348732967672727_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.007648074348830_REALK, &
      0.000000000000000_REALK,     -0.242587240991823_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.102292477158962_REALK,      0.000000000000000_REALK, &
      2.793210850673357_REALK,      0.000000000000000_REALK,     -0.735950698831698_REALK, &
      0.000000000000000_REALK,     -0.560188599984029_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.090499082421893_REALK, &
      0.000000000000000_REALK,     -5.031948012222898_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -4.218911914047046_REALK,      0.000000000000000_REALK, &
      6.687346556889203_REALK,      0.000000000000000_REALK,     -6.990815490498566_REALK, &
      0.000000000000000_REALK,     -8.050660237912238_REALK,      0.000000000000000_REALK, &
     -3.756500246889901_REALK,     -0.944517146575489_REALK,      0.000000000000000_REALK, &
     -0.752818462142574_REALK,      0.000000000000000_REALK,     -4.127023895962484_REALK, &
     -0.503966964517629_REALK,      0.000000000000000_REALK,     -1.314092632154862_REALK, &
      0.000000000000000_REALK,     -0.749316646036393_REALK,      0.000000000000000_REALK, &
     -1.738427456553635_REALK,      0.000000000000000_REALK,    -12.253150401449696_REALK, &
    -32.734802740538186_REALK,     -6.912670527183215_REALK,      0.000000000000000_REALK, &
     -3.115172389210659_REALK,      0.000000000000000_REALK,    -28.939103647270070_REALK, &
      0.158495935184113_REALK,      0.000000000000000_REALK,     -7.590087909591436_REALK, &
      0.000000000000000_REALK,      3.374185225323969_REALK,      0.000000000000000_REALK, &
     -4.983993162715807_REALK,      0.000000000000000_REALK,    -59.528494286955748_REALK/
    ! results of test 4, ket-major order, 03 DPG X
  data REF_CONTR_INTS(25201:26460)                                                         &
     /0.000000000000000_REALK,      0.000000000000000_REALK,      9.594867959771186_REALK, &
      0.000000000000000_REALK,     10.397066877071287_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     14.843381710310430_REALK,      0.000000000000000_REALK, &
      6.998928412434067_REALK,      0.000000000000000_REALK,     31.593959518762009_REALK, &
      0.000000000000000_REALK,     11.334259852445440_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     11.167284292390100_REALK, &
      0.000000000000000_REALK,     13.445544120766519_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     21.352540651679895_REALK,      0.000000000000000_REALK, &
      7.722745007792253_REALK,      0.000000000000000_REALK,     47.825197100317318_REALK, &
      0.000000000000000_REALK,     13.936880947111547_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.211621733410872_REALK, &
      0.000000000000000_REALK,      4.859170216875379_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.177081100116741_REALK,      0.000000000000000_REALK, &
      3.940273005623677_REALK,      0.000000000000000_REALK,      7.623079027427091_REALK, &
      0.000000000000000_REALK,      4.367706528130446_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.586167934375367_REALK, &
      0.000000000000000_REALK,      2.833046335203413_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.164861827890839_REALK,      0.000000000000000_REALK, &
      2.645937962884115_REALK,      0.000000000000000_REALK,      0.475792142084014_REALK, &
      0.000000000000000_REALK,      2.566034180281501_REALK,      0.000000000000000_REALK, &
      6.723291664989020_REALK,      6.211621733410872_REALK,      0.000000000000000_REALK, &
      7.445992856880506_REALK,      0.000000000000000_REALK,     -1.662722231483992_REALK, &
     10.983410249385267_REALK,      0.000000000000000_REALK,     -1.866056143644849_REALK, &
      0.000000000000000_REALK,     22.416906500087688_REALK,      0.000000000000000_REALK, &
     -3.169657562025288_REALK,      0.000000000000000_REALK,     -4.041045100234797_REALK, &
      2.393401755382616_REALK,      3.586167934375366_REALK,      0.000000000000000_REALK, &
      5.371721370240970_REALK,      0.000000000000000_REALK,     -3.134516424561571_REALK, &
      9.079686127072147_REALK,      0.000000000000000_REALK,     -4.268886336297196_REALK, &
      0.000000000000000_REALK,     19.548615577480021_REALK,      0.000000000000000_REALK, &
     -7.849774323994588_REALK,      0.000000000000000_REALK,     -6.264756372417773_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.426463405901766_REALK, &
      0.000000000000000_REALK,      3.291521116592842_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.956048994759896_REALK,      0.000000000000000_REALK, &
      2.966981516105861_REALK,      0.000000000000000_REALK,      3.625679019806940_REALK, &
      0.000000000000000_REALK,      2.435749960779928_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.530722388197052_REALK, &
      0.000000000000000_REALK,      2.925327103339351_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.968345952826390_REALK,      0.000000000000000_REALK, &
      2.233395692352055_REALK,      0.000000000000000_REALK,      4.518372294400534_REALK, &
      0.000000000000000_REALK,      1.969077546344384_REALK,      0.000000000000000_REALK, &
      4.920352804103401_REALK,      3.300054562942257_REALK,      0.000000000000000_REALK, &
      2.944183094942988_REALK,      0.000000000000000_REALK,     -1.061217865064888_REALK, &
      3.149169632183911_REALK,      0.000000000000000_REALK,     -0.854510641286672_REALK, &
      0.000000000000000_REALK,      4.319358388579075_REALK,      0.000000000000000_REALK, &
     -1.031808891572753_REALK,      0.000000000000000_REALK,     -2.123358220001845_REALK, &
      2.393724981361623_REALK,      1.252740859773023_REALK,      0.000000000000000_REALK, &
      0.719381109730493_REALK,      0.000000000000000_REALK,     -1.418546047768211_REALK, &
      0.114502321697554_REALK,      0.000000000000000_REALK,     -0.996309791486621_REALK, &
      0.000000000000000_REALK,     -1.332537783123452_REALK,      0.000000000000000_REALK, &
     -0.781236181076603_REALK,      0.000000000000000_REALK,     -2.106961987162954_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.759625051239672_REALK, &
      0.000000000000000_REALK,     -0.713879843415033_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.880843076672159_REALK,      0.000000000000000_REALK, &
      0.857961834761711_REALK,      0.000000000000000_REALK,     -1.472556850641935_REALK, &
      0.000000000000000_REALK,      1.091269222647884_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.769360805055274_REALK, &
      0.000000000000000_REALK,      0.787399945840647_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.048591037081565_REALK,      0.000000000000000_REALK, &
      2.786572176570298_REALK,      0.000000000000000_REALK,      1.818758114173110_REALK, &
      0.000000000000000_REALK,      3.894267522532309_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.693438440599283_REALK, &
      0.000000000000000_REALK,      2.613585232067427_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.937053359057475_REALK,      0.000000000000000_REALK, &
      2.663508330029193_REALK,      0.000000000000000_REALK,      1.829212205809426_REALK, &
      0.000000000000000_REALK,      1.588339999597246_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.330859629263421_REALK, &
      0.000000000000000_REALK,      1.614017750692343_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.862633529415414_REALK,      0.000000000000000_REALK, &
      1.823725346186673_REALK,      0.000000000000000_REALK,     -0.032098177587341_REALK, &
      0.000000000000000_REALK,      0.984587388665911_REALK,      0.000000000000000_REALK, &
      4.912685932281209_REALK,      2.571278720541649_REALK,      0.000000000000000_REALK, &
      1.937177918296332_REALK,      0.000000000000000_REALK,     -0.920812307596019_REALK, &
      1.790544978915900_REALK,      0.000000000000000_REALK,     -0.569674760654035_REALK, &
      0.000000000000000_REALK,      2.194470929987174_REALK,      0.000000000000000_REALK, &
     -0.557538302082590_REALK,      0.000000000000000_REALK,     -1.513075424897739_REALK, &
      1.227735460651118_REALK,      1.011296997498101_REALK,      0.000000000000000_REALK, &
      1.005973808566109_REALK,      0.000000000000000_REALK,     -1.221160551411583_REALK, &
      1.270577069320656_REALK,      0.000000000000000_REALK,     -0.893339947894045_REALK, &
      0.000000000000000_REALK,      2.192867833223671_REALK,      0.000000000000000_REALK, &
     -0.990073803450380_REALK,      0.000000000000000_REALK,     -1.643779672840979_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.557670446391287_REALK, &
      0.000000000000000_REALK,     -0.376700264004984_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.342780189737593_REALK,      0.000000000000000_REALK, &
      0.538924327438580_REALK,      0.000000000000000_REALK,     -0.399557881925621_REALK, &
      0.000000000000000_REALK,      0.472904513023064_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.272207234585773_REALK, &
      0.000000000000000_REALK,      0.187421107194973_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.121941993897644_REALK,      0.000000000000000_REALK, &
      1.095077318454162_REALK,      0.000000000000000_REALK,      0.021199191076928_REALK, &
      0.000000000000000_REALK,      0.840052596172180_REALK,      0.000000000000000_REALK, &
      3.162457208588835_REALK,      2.564489273666347_REALK,      0.000000000000000_REALK, &
      2.654481385980327_REALK,      0.000000000000000_REALK,      0.241667530577263_REALK, &
      3.344192042778518_REALK,      0.000000000000000_REALK,      0.231643565747271_REALK, &
      0.000000000000000_REALK,      5.403164846228443_REALK,      0.000000000000000_REALK, &
      0.311477309224376_REALK,      0.000000000000000_REALK,     -0.778193256156763_REALK, &
      1.985016757910739_REALK,      2.591769866351092_REALK,      0.000000000000000_REALK, &
      3.383569270887098_REALK,      0.000000000000000_REALK,     -1.158544572591659_REALK, &
      4.869571171561735_REALK,      0.000000000000000_REALK,     -1.343430105034458_REALK, &
      0.000000000000000_REALK,      8.293059916940630_REALK,      0.000000000000000_REALK, &
     -1.954054043979416_REALK,      0.000000000000000_REALK,     -3.599999716636733_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.228959789401592_REALK, &
      0.000000000000000_REALK,      2.473139685340302_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.580041786464389_REALK,      0.000000000000000_REALK, &
      2.844479585267226_REALK,      0.000000000000000_REALK,      1.211964397333547_REALK, &
      0.000000000000000_REALK,      1.223122109146010_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.438118652126758_REALK, &
      0.000000000000000_REALK,      2.554826161307340_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.739065593790116_REALK,      0.000000000000000_REALK, &
      2.467275170572851_REALK,      0.000000000000000_REALK,      1.843165389803476_REALK, &
      0.000000000000000_REALK,      1.075850769575168_REALK,      0.000000000000000_REALK, &
      6.131900646552488_REALK,      2.417450416763578_REALK,      0.000000000000000_REALK, &
      1.500428360925018_REALK,      0.000000000000000_REALK,     -0.977071020471584_REALK, &
      1.095481896694511_REALK,      0.000000000000000_REALK,     -0.450487744134408_REALK, &
      0.000000000000000_REALK,      1.017053863763874_REALK,      0.000000000000000_REALK, &
     -0.351426759099402_REALK,      0.000000000000000_REALK,     -1.306561808145877_REALK, &
      3.657685623237390_REALK,      1.168042656535920_REALK,      0.000000000000000_REALK, &
      0.457444809924526_REALK,      0.000000000000000_REALK,     -1.560295075879324_REALK, &
     -0.012631045410876_REALK,      0.000000000000000_REALK,     -0.625098020566140_REALK, &
      0.000000000000000_REALK,     -0.649499119855347_REALK,      0.000000000000000_REALK, &
     -0.310788055121991_REALK,      0.000000000000000_REALK,     -1.449847404390119_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.572944546989281_REALK, &
      0.000000000000000_REALK,     -0.296839181985421_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.224613776472069_REALK,      0.000000000000000_REALK, &
      0.465704389179611_REALK,      0.000000000000000_REALK,     -0.218523951694280_REALK, &
      0.000000000000000_REALK,      0.303258599344446_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.490540766616700_REALK, &
      0.000000000000000_REALK,      0.262954778528320_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.216261112641995_REALK,      0.000000000000000_REALK, &
      1.195560640378208_REALK,      0.000000000000000_REALK,      0.254091969642007_REALK, &
      0.000000000000000_REALK,      0.813605292090752_REALK,      0.000000000000000_REALK, &
      2.761985327379140_REALK,      1.602286189530826_REALK,      0.000000000000000_REALK, &
      1.220991533017255_REALK,      0.000000000000000_REALK,      0.179429530966623_REALK, &
      1.100383510588043_REALK,      0.000000000000000_REALK,      0.121732635937912_REALK, &
      0.000000000000000_REALK,      1.197159976993258_REALK,      0.000000000000000_REALK, &
      0.116593340922795_REALK,      0.000000000000000_REALK,     -0.470194392031671_REALK, &
      2.846075918542577_REALK,      1.291414530128807_REALK,      0.000000000000000_REALK, &
      0.615690474572147_REALK,      0.000000000000000_REALK,     -0.712405799321105_REALK, &
      0.079428247978366_REALK,      0.000000000000000_REALK,     -0.405541862814984_REALK, &
      0.000000000000000_REALK,     -0.713485632892465_REALK,      0.000000000000000_REALK, &
     -0.245453173597427_REALK,      0.000000000000000_REALK,     -1.528135566938702_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.303000141645545_REALK, &
      0.000000000000000_REALK,     -1.045921698106933_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.087358564565110_REALK,      0.000000000000000_REALK, &
     -0.112990692512322_REALK,      0.000000000000000_REALK,     -1.441887029042714_REALK, &
      0.000000000000000_REALK,     -0.113996505412409_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.930931381513668_REALK, &
      0.000000000000000_REALK,     -0.791009998389761_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.853787945633598_REALK,      0.000000000000000_REALK, &
      2.268531837537019_REALK,      0.000000000000000_REALK,     -1.143046324695030_REALK, &
      0.000000000000000_REALK,      2.447064265492670_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     11.013928485739191_REALK, &
      0.000000000000000_REALK,      2.709971475421305_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.528063754898805_REALK,      0.000000000000000_REALK, &
      3.613084106260162_REALK,      0.000000000000000_REALK,      0.891734735361352_REALK, &
      0.000000000000000_REALK,      1.080548898578759_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.127780505838524_REALK, &
      0.000000000000000_REALK,      2.184553824328144_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.881038873548392_REALK,      0.000000000000000_REALK, &
      3.258308143258675_REALK,      0.000000000000000_REALK,     -0.215492729731458_REALK, &
      0.000000000000000_REALK,      0.894387996152756_REALK,      0.000000000000000_REALK, &
      9.357599657150699_REALK,      2.770233510510854_REALK,      0.000000000000000_REALK, &
      1.488071074829808_REALK,      0.000000000000000_REALK,     -1.268692335669810_REALK, &
      0.900476209232832_REALK,      0.000000000000000_REALK,     -0.430378522497237_REALK, &
      0.000000000000000_REALK,      0.735779198197014_REALK,      0.000000000000000_REALK, &
     -0.280997058098461_REALK,      0.000000000000000_REALK,     -1.367787650651110_REALK, &
      2.596448587640812_REALK,      1.199244455998313_REALK,      0.000000000000000_REALK, &
      0.857871253533826_REALK,      0.000000000000000_REALK,     -1.963625550758961_REALK, &
      0.823645212540073_REALK,      0.000000000000000_REALK,     -0.775644719900141_REALK, &
      0.000000000000000_REALK,      1.200264427606356_REALK,      0.000000000000000_REALK, &
     -0.566657004436129_REALK,      0.000000000000000_REALK,     -1.773972013385170_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.736231562276438_REALK, &
      0.000000000000000_REALK,     -0.285403076099619_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.175645802464091_REALK,      0.000000000000000_REALK, &
      0.498908587499254_REALK,      0.000000000000000_REALK,     -0.131056622883911_REALK, &
      0.000000000000000_REALK,      0.235076428344020_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.406541649711671_REALK, &
      0.000000000000000_REALK,      0.171161553057416_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.077088950434473_REALK,      0.000000000000000_REALK, &
      1.197477189507759_REALK,      0.000000000000000_REALK,     -0.002284523014168_REALK, &
      0.000000000000000_REALK,      0.514886432189685_REALK,      0.000000000000000_REALK, &
      3.410550617557689_REALK,      1.529016652339796_REALK,      0.000000000000000_REALK, &
      0.972780260113022_REALK,      0.000000000000000_REALK,      0.188520197687114_REALK, &
      0.746628706305016_REALK,      0.000000000000000_REALK,      0.096847398409632_REALK, &
      0.000000000000000_REALK,      0.723016105240190_REALK,      0.000000000000000_REALK, &
      0.074891819016123_REALK,      0.000000000000000_REALK,     -0.398290497386730_REALK, &
      1.630378740905987_REALK,      1.175233614605178_REALK,      0.000000000000000_REALK, &
      1.015737199672403_REALK,      0.000000000000000_REALK,     -0.723515856777069_REALK, &
      1.081094316148885_REALK,      0.000000000000000_REALK,     -0.446025746524615_REALK, &
      0.000000000000000_REALK,      1.486019100527412_REALK,      0.000000000000000_REALK, &
     -0.393695188503979_REALK,      0.000000000000000_REALK,     -1.508881116605552_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.171566391757429_REALK, &
      0.000000000000000_REALK,     -0.668293718777729_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.504965117816362_REALK,      0.000000000000000_REALK, &
     -0.084698148959986_REALK,      0.000000000000000_REALK,     -0.465076137376830_REALK, &
      0.000000000000000_REALK,     -0.058724358320387_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.371302897071766_REALK, &
      0.000000000000000_REALK,     -0.222124452773270_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.121786472133025_REALK,      0.000000000000000_REALK, &
      1.093506192228267_REALK,      0.000000000000000_REALK,     -0.016862206802024_REALK, &
      0.000000000000000_REALK,      0.668085898308847_REALK,      0.000000000000000_REALK, &
      3.659138990506043_REALK,      2.541632154238439_REALK,      0.000000000000000_REALK, &
      2.221639933646431_REALK,      0.000000000000000_REALK,      0.900623886201761_REALK, &
      2.324124598875855_REALK,      0.000000000000000_REALK,      0.716835669412200_REALK, &
      0.000000000000000_REALK,      2.966983331994313_REALK,      0.000000000000000_REALK, &
      0.761595678163876_REALK,      0.000000000000000_REALK,      0.051487442975548_REALK, &
      4.393358376952310_REALK,      5.019849222981426_REALK,      0.000000000000000_REALK, &
      5.694013679155350_REALK,      0.000000000000000_REALK,     -0.576714746285367_REALK, &
      6.905609850796157_REALK,      0.000000000000000_REALK,     -0.563548465897865_REALK, &
      0.000000000000000_REALK,      9.366460099782836_REALK,      0.000000000000000_REALK, &
     -0.652833046582112_REALK,      0.000000000000000_REALK,     -4.380780959358851_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.416126718025132_REALK, &
      0.000000000000000_REALK,     11.242029964044898_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.497626658361588_REALK,      0.000000000000000_REALK, &
      0.673134720307293_REALK,      0.000000000000000_REALK,     63.409015761588115_REALK, &
      0.000000000000000_REALK,     45.100983259583288_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.759227059137050_REALK, &
      0.000000000000000_REALK,     11.655993149796917_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.063880369188606_REALK,      0.000000000000000_REALK, &
     -0.063383749521451_REALK,      0.000000000000000_REALK,     91.179839707834631_REALK, &
      0.000000000000000_REALK,     54.451921224755985_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.896393742318006_REALK, &
      0.000000000000000_REALK,      4.073059299652456_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.874794973917649_REALK,      0.000000000000000_REALK, &
      4.404774882551289_REALK,      0.000000000000000_REALK,     13.640744611844257_REALK, &
      0.000000000000000_REALK,     15.243517860927133_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.115012168819204_REALK, &
      0.000000000000000_REALK,      2.057671733846373_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.712522138332074_REALK,      0.000000000000000_REALK, &
      2.836772888476302_REALK,      0.000000000000000_REALK,     -0.447479099688960_REALK, &
      0.000000000000000_REALK,      9.183847163197028_REALK,      0.000000000000000_REALK, &
     12.576518683322515_REALK,      2.896393742318006_REALK,      0.000000000000000_REALK, &
     12.087140734532541_REALK,      0.000000000000000_REALK,      0.321994343365718_REALK, &
      6.192823742808191_REALK,      0.000000000000000_REALK,      0.086746113660748_REALK, &
      0.000000000000000_REALK,     80.159041734889684_REALK,      0.000000000000000_REALK, &
      0.890870050755074_REALK,      0.000000000000000_REALK,    -17.986803709661000_REALK, &
      3.377768793717583_REALK,      1.115012168819204_REALK,      0.000000000000000_REALK, &
      7.002015858502677_REALK,      0.000000000000000_REALK,     -2.941107561257936_REALK, &
      4.750181287289545_REALK,      0.000000000000000_REALK,     -1.200886260481169_REALK, &
      0.000000000000000_REALK,     66.274357338449832_REALK,      0.000000000000000_REALK, &
    -13.229668263490607_REALK,      0.000000000000000_REALK,    -36.589835893398309_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.597298021140198_REALK, &
      0.000000000000000_REALK,      1.824028241903107_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.852343150204307_REALK,      0.000000000000000_REALK, &
      5.956259637914856_REALK,      0.000000000000000_REALK,      4.461700125731041_REALK, &
      0.000000000000000_REALK,      5.861733824534862_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.923588726037347_REALK, &
      0.000000000000000_REALK,      1.253464879836626_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.409548205896336_REALK,      0.000000000000000_REALK, &
      4.115517759604681_REALK,      0.000000000000000_REALK,      5.361626924584157_REALK, &
      0.000000000000000_REALK,      4.437847092077994_REALK,      0.000000000000000_REALK, &
      9.547453778670631_REALK,      2.387378240481672_REALK,      0.000000000000000_REALK, &
      4.674825383976986_REALK,      0.000000000000000_REALK,      0.216302550275787_REALK, &
      2.767866045165238_REALK,      0.000000000000000_REALK,      0.060914194177161_REALK, &
      0.000000000000000_REALK,     15.109340976873911_REALK,      0.000000000000000_REALK, &
      0.295859990020967_REALK,      0.000000000000000_REALK,    -10.375223412245786_REALK, &
      3.357426272689402_REALK,      0.784381421814502_REALK,      0.000000000000000_REALK, &
      0.906677294021557_REALK,      0.000000000000000_REALK,     -1.528115754591874_REALK, &
     -0.053800165102869_REALK,      0.000000000000000_REALK,     -0.467425938632868_REALK, &
      0.000000000000000_REALK,     -5.070854750632786_REALK,      0.000000000000000_REALK, &
     -1.358908491107295_REALK,      0.000000000000000_REALK,    -15.080558146162916_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.298711200417127_REALK, &
      0.000000000000000_REALK,     -2.634494591798091_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.201694312626812_REALK,      0.000000000000000_REALK, &
     -1.146121023579860_REALK,      0.000000000000000_REALK,    -11.903011375335465_REALK, &
      0.000000000000000_REALK,     -3.258119063518336_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.866715216511340_REALK, &
      0.000000000000000_REALK,     -1.181328168776804_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.229629046863523_REALK,      0.000000000000000_REALK, &
      1.981682435114448_REALK,      0.000000000000000_REALK,     -7.003519477807504_REALK, &
      0.000000000000000_REALK,      6.793290098939528_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.460112445314945_REALK, &
      0.000000000000000_REALK,      0.594278697425000_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.858740568619984_REALK,      0.000000000000000_REALK, &
      7.291469606646127_REALK,      0.000000000000000_REALK,      0.741355682152090_REALK, &
      0.000000000000000_REALK,      1.530513989854078_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.319487682329753_REALK, &
      0.000000000000000_REALK,      0.210868598459701_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.852710840961808_REALK,      0.000000000000000_REALK, &
      5.055553210830932_REALK,      0.000000000000000_REALK,     -1.338671540394638_REALK, &
      0.000000000000000_REALK,      0.598881980170469_REALK,      0.000000000000000_REALK, &
     10.171495373841406_REALK,      1.710347253195208_REALK,      0.000000000000000_REALK, &
      3.063089616004774_REALK,      0.000000000000000_REALK,      0.193971618433797_REALK, &
      1.469378127734027_REALK,      0.000000000000000_REALK,      0.038017678725687_REALK, &
      0.000000000000000_REALK,      6.904967887506849_REALK,      0.000000000000000_REALK, &
      0.155357832437870_REALK,      0.000000000000000_REALK,     -7.456355610053667_REALK, &
      1.959898423107851_REALK,      0.587284074006910_REALK,      0.000000000000000_REALK, &
      1.124038299827095_REALK,      0.000000000000000_REALK,     -1.389322166055520_REALK, &
      1.080612794230713_REALK,      0.000000000000000_REALK,     -0.378637092436713_REALK, &
      0.000000000000000_REALK,      5.673810215894918_REALK,      0.000000000000000_REALK, &
     -1.351411940971404_REALK,      0.000000000000000_REALK,    -10.998495896095800_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.470301986080131_REALK, &
      0.000000000000000_REALK,     -1.226852731407472_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.186738694107127_REALK,      0.000000000000000_REALK, &
     -1.073001043229616_REALK,      0.000000000000000_REALK,     -2.827433823701129_REALK, &
      0.000000000000000_REALK,     -1.215947094433024_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.553485965868298_REALK, &
      0.000000000000000_REALK,     -0.288156414520938_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.211727872055566_REALK,      0.000000000000000_REALK, &
      1.369158335537163_REALK,      0.000000000000000_REALK,      0.039875462554773_REALK, &
      0.000000000000000_REALK,      1.329251205643019_REALK,      0.000000000000000_REALK, &
      4.692984272719925_REALK,      2.279463206039606_REALK,      0.000000000000000_REALK, &
      3.359524547656445_REALK,      0.000000000000000_REALK,      3.119093125974708_REALK, &
      3.617200488147686_REALK,      0.000000000000000_REALK,      1.765874143321969_REALK, &
      0.000000000000000_REALK,     15.331668723136696_REALK,      0.000000000000000_REALK, &
      5.938505025273768_REALK,      0.000000000000000_REALK,      7.270353183700446_REALK, &
      2.287115215221530_REALK,      2.178717642454545_REALK,      0.000000000000000_REALK, &
      3.859842881908786_REALK,      0.000000000000000_REALK,      0.931945926735217_REALK, &
      5.556280871974369_REALK,      0.000000000000000_REALK,      0.807437941505964_REALK, &
      0.000000000000000_REALK,     23.247317129513483_REALK,      0.000000000000000_REALK, &
      2.667531395025986_REALK,      0.000000000000000_REALK,     -9.305702813228891_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      9.686037774694951_REALK, &
      0.000000000000000_REALK,     -0.570414591964298_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.286545696426210_REALK,      0.000000000000000_REALK, &
      9.285095715581809_REALK,      0.000000000000000_REALK,     -1.137079413461499_REALK, &
      0.000000000000000_REALK,     -1.117811329175167_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.181868200336357_REALK, &
      0.000000000000000_REALK,     -0.516950386757141_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.833029778421974_REALK,      0.000000000000000_REALK, &
      7.664910005715955_REALK,      0.000000000000000_REALK,      0.025920767250379_REALK, &
      0.000000000000000_REALK,     -0.944578756936744_REALK,      0.000000000000000_REALK, &
     13.862423751924206_REALK,      0.777020951006008_REALK,      0.000000000000000_REALK, &
      2.792160116718613_REALK,      0.000000000000000_REALK,      0.215706345292969_REALK, &
      0.360796463905627_REALK,      0.000000000000000_REALK,      0.014668957993735_REALK, &
      0.000000000000000_REALK,      3.916436374946003_REALK,      0.000000000000000_REALK, &
      0.107756756067918_REALK,      0.000000000000000_REALK,     -6.309313142477226_REALK, &
      6.658497732495324_REALK,      0.211341106249196_REALK,      0.000000000000000_REALK, &
      0.762956381127857_REALK,      0.000000000000000_REALK,     -1.914890389089455_REALK, &
     -0.442559168089025_REALK,      0.000000000000000_REALK,     -0.083813864497726_REALK, &
      0.000000000000000_REALK,     -1.278734011592715_REALK,      0.000000000000000_REALK, &
     -0.590155321787760_REALK,      0.000000000000000_REALK,     -9.752910239784592_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.088989464165957_REALK, &
      0.000000000000000_REALK,     -0.695573149706109_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.920883044281368_REALK,      0.000000000000000_REALK, &
     -1.139545729408053_REALK,      0.000000000000000_REALK,     -1.037516407043608_REALK, &
      0.000000000000000_REALK,     -0.524560752337635_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.076438782163897_REALK, &
      0.000000000000000_REALK,     -0.261899933623541_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.345381737598150_REALK,      0.000000000000000_REALK, &
      1.637922519849788_REALK,      0.000000000000000_REALK,     -0.578161216003226_REALK, &
      0.000000000000000_REALK,      0.777273989941680_REALK,      0.000000000000000_REALK, &
      4.891383107728587_REALK,      1.480190250053028_REALK,      0.000000000000000_REALK, &
      1.644974550229908_REALK,      0.000000000000000_REALK,      2.652658169390988_REALK, &
      1.269727833494760_REALK,      0.000000000000000_REALK,      0.973890062727116_REALK, &
      0.000000000000000_REALK,      3.242072009056251_REALK,      0.000000000000000_REALK, &
      2.212530325851627_REALK,      0.000000000000000_REALK,      4.704778647437266_REALK, &
      4.370248625790816_REALK,      1.136827820912051_REALK,      0.000000000000000_REALK, &
      0.745710562631565_REALK,      0.000000000000000_REALK,      0.722448807079618_REALK, &
     -0.051891638285231_REALK,      0.000000000000000_REALK,      0.259155155359881_REALK, &
      0.000000000000000_REALK,     -2.152424225049199_REALK,      0.000000000000000_REALK, &
      0.331566147306112_REALK,      0.000000000000000_REALK,     -4.641149072565292_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.288803390929987_REALK, &
      0.000000000000000_REALK,     -2.139184744228863_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.330664622530508_REALK,      0.000000000000000_REALK, &
     -3.853694338885520_REALK,      0.000000000000000_REALK,     -5.893742735475437_REALK, &
      0.000000000000000_REALK,     -5.124190886203442_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.160539901756467_REALK, &
      0.000000000000000_REALK,     -3.218058912526396_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.928201553648145_REALK,      0.000000000000000_REALK, &
     -1.349151534337195_REALK,      0.000000000000000_REALK,     -9.846205982225237_REALK, &
      0.000000000000000_REALK,     -2.035353083169099_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     16.424698191275770_REALK, &
      0.000000000000000_REALK,     -2.513972674978372_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.468448593329352_REALK,      0.000000000000000_REALK, &
     12.943712212247371_REALK,      0.000000000000000_REALK,     -3.010646216587049_REALK, &
      0.000000000000000_REALK,     -3.607881729772313_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     12.189914698898932_REALK, &
      0.000000000000000_REALK,     -2.623035932472624_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.822052371042312_REALK,      0.000000000000000_REALK, &
     12.374673278334331_REALK,      0.000000000000000_REALK,     -3.545933907207120_REALK, &
      0.000000000000000_REALK,     -3.737826120487514_REALK,      0.000000000000000_REALK, &
     23.231739681710746_REALK,     -0.982826759255680_REALK,      0.000000000000000_REALK, &
      3.643879825957079_REALK,      0.000000000000000_REALK,      0.291404903153338_REALK, &
     -0.787881154559788_REALK,      0.000000000000000_REALK,     -0.015253332317747_REALK, &
      0.000000000000000_REALK,      3.917925808022594_REALK,      0.000000000000000_REALK, &
      0.102986925818338_REALK,      0.000000000000000_REALK,     -6.242087848188882_REALK, &
      6.084984575385019_REALK,     -0.446986904495247_REALK,      0.000000000000000_REALK, &
      1.612306983305090_REALK,      0.000000000000000_REALK,     -2.854056610917306_REALK, &
      0.012451955287276_REALK,      0.000000000000000_REALK,      0.192090188528513_REALK, &
      0.000000000000000_REALK,      3.151515859610604_REALK,      0.000000000000000_REALK, &
     -0.972612614788151_REALK,      0.000000000000000_REALK,    -11.336485476377081_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.526733608787754_REALK, &
      0.000000000000000_REALK,     -0.284720735480823_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.909389836392344_REALK,      0.000000000000000_REALK, &
     -1.372844955674126_REALK,      0.000000000000000_REALK,     -0.197924771989790_REALK, &
      0.000000000000000_REALK,     -0.157248293352586_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.279982880527475_REALK, &
      0.000000000000000_REALK,     -0.056991276817100_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.219164563315142_REALK,      0.000000000000000_REALK, &
      2.110506396939483_REALK,      0.000000000000000_REALK,      0.181533184569858_REALK, &
      0.000000000000000_REALK,      0.131908468649418_REALK,      0.000000000000000_REALK, &
      6.836511365589507_REALK,      1.105889395699117_REALK,      0.000000000000000_REALK, &
      1.354163725483770_REALK,      0.000000000000000_REALK,      2.988653191342467_REALK, &
      0.663357170553207_REALK,      0.000000000000000_REALK,      0.598170942873923_REALK, &
      0.000000000000000_REALK,      1.701052567499185_REALK,      0.000000000000000_REALK, &
      1.333874850342436_REALK,      0.000000000000000_REALK,      3.881926314840275_REALK, &
      3.151306718669988_REALK,      0.891406220076968_REALK,      0.000000000000000_REALK, &
      1.195836820667117_REALK,      0.000000000000000_REALK,      0.849624538528713_REALK, &
      1.093283999119109_REALK,      0.000000000000000_REALK,      0.220201013462337_REALK, &
      0.000000000000000_REALK,      3.028664293741382_REALK,      0.000000000000000_REALK, &
      0.414664975785156_REALK,      0.000000000000000_REALK,     -4.256680282972812_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.685824379736823_REALK, &
      0.000000000000000_REALK,     -1.251587159052334_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.236306497392417_REALK,      0.000000000000000_REALK, &
     -3.550546587873315_REALK,      0.000000000000000_REALK,     -1.607332448638140_REALK, &
      0.000000000000000_REALK,     -2.195593645413011_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.782530449037613_REALK, &
      0.000000000000000_REALK,     -1.015371523920749_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.709490843865748_REALK,      0.000000000000000_REALK, &
     -0.977753680692883_REALK,      0.000000000000000_REALK,      0.070499809282074_REALK, &
      0.000000000000000_REALK,     -0.500836870753259_REALK,      0.000000000000000_REALK, &
      5.257116274416219_REALK,      2.456454561820883_REALK,      0.000000000000000_REALK, &
      2.475358133793029_REALK,      0.000000000000000_REALK,      4.530465782988010_REALK, &
      2.721668252997230_REALK,      0.000000000000000_REALK,      2.619248143204098_REALK, &
      0.000000000000000_REALK,      6.294978453779898_REALK,      0.000000000000000_REALK, &
      4.806580719738406_REALK,      0.000000000000000_REALK,     11.654196325955281_REALK, &
      6.129060447829265_REALK,      5.511592953147679_REALK,      0.000000000000000_REALK, &
      6.843987197598784_REALK,      0.000000000000000_REALK,      6.179644465655868_REALK, &
      9.369055848639480_REALK,      0.000000000000000_REALK,      5.091596774448525_REALK, &
      0.000000000000000_REALK,     20.682256613082288_REALK,      0.000000000000000_REALK, &
      8.874989233825129_REALK,      0.000000000000000_REALK,      3.462393261930339_REALK/
    ! results of test 4, ket-major order, 03 DPG Y
  data REF_CONTR_INTS(26461:27720)                                                         &
     /0.000000000000000_REALK,      0.000000000000000_REALK,      3.465613629728924_REALK, &
      0.000000000000000_REALK,      2.084841211718257_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.482846840593208_REALK,      0.000000000000000_REALK, &
      2.198373374813344_REALK,      0.000000000000000_REALK,      0.671872504645038_REALK, &
      0.000000000000000_REALK,      1.873977276801941_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.774567571673060_REALK, &
      0.000000000000000_REALK,     -0.870714913153566_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -3.570759712169571_REALK,      0.000000000000000_REALK, &
      0.571489617946652_REALK,      0.000000000000000_REALK,    -11.035999519867689_REALK, &
      0.000000000000000_REALK,     -0.788650789318088_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.542306917459364_REALK, &
      0.000000000000000_REALK,      1.920501163471279_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.602501225927169_REALK,      0.000000000000000_REALK, &
      1.936797203321290_REALK,      0.000000000000000_REALK,      1.854930831516981_REALK, &
      0.000000000000000_REALK,      1.421185059400493_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.892961299362765_REALK, &
      0.000000000000000_REALK,      1.920133922975082_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.307805688774376_REALK,      0.000000000000000_REALK, &
      1.426070006180434_REALK,      0.000000000000000_REALK,      4.392915915937513_REALK, &
      0.000000000000000_REALK,      1.292468315556365_REALK,      0.000000000000000_REALK, &
      2.745183540275272_REALK,      1.415898074499856_REALK,      0.000000000000000_REALK, &
      0.843288431461059_REALK,      0.000000000000000_REALK,     -0.592079050386927_REALK, &
      0.277557202373859_REALK,      0.000000000000000_REALK,     -0.366630293093916_REALK, &
      0.000000000000000_REALK,     -0.887815304528138_REALK,      0.000000000000000_REALK, &
     -0.295536138101089_REALK,      0.000000000000000_REALK,     -1.184672780129929_REALK, &
      0.517014757812607_REALK,     -0.385020229061263_REALK,      0.000000000000000_REALK, &
     -1.186559368929391_REALK,      0.000000000000000_REALK,     -0.306388263916486_REALK, &
     -2.655881540504321_REALK,      0.000000000000000_REALK,      0.306208120491624_REALK, &
      0.000000000000000_REALK,     -6.487096459889955_REALK,      0.000000000000000_REALK, &
      1.288584169732153_REALK,      0.000000000000000_REALK,     -0.455077525611893_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.932305892556825_REALK, &
      0.000000000000000_REALK,      1.621924080135308_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.116194932519918_REALK,      0.000000000000000_REALK, &
      1.839614076857488_REALK,      0.000000000000000_REALK,      0.932141334547282_REALK, &
      0.000000000000000_REALK,      0.985683137928909_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.074077414921831_REALK, &
      0.000000000000000_REALK,      0.703712894870993_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.051925981394893_REALK,      0.000000000000000_REALK, &
      1.135607012170230_REALK,      0.000000000000000_REALK,     -1.306340464768689_REALK, &
      0.000000000000000_REALK,      0.429280806381683_REALK,      0.000000000000000_REALK, &
      3.206921351814247_REALK,      1.500261915232920_REALK,      0.000000000000000_REALK, &
      1.050161886495072_REALK,      0.000000000000000_REALK,     -0.601091274905051_REALK, &
      0.916059328049917_REALK,      0.000000000000000_REALK,     -0.332387671803484_REALK, &
      0.000000000000000_REALK,      1.125768882241534_REALK,      0.000000000000000_REALK, &
     -0.302246618433087_REALK,      0.000000000000000_REALK,     -0.987710990260027_REALK, &
      0.783934849500326_REALK,      0.663797791666544_REALK,      0.000000000000000_REALK, &
      0.782116409293980_REALK,      0.000000000000000_REALK,     -0.779736632009367_REALK, &
      1.235298436377401_REALK,      0.000000000000000_REALK,     -0.586372832201241_REALK, &
      0.000000000000000_REALK,      2.568661566428666_REALK,      0.000000000000000_REALK, &
     -0.769754601458649_REALK,      0.000000000000000_REALK,     -1.049587807585910_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.311137796674783_REALK, &
      0.000000000000000_REALK,     -0.161624351444875_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.098180907646756_REALK,      0.000000000000000_REALK, &
      0.300678884632928_REALK,      0.000000000000000_REALK,     -0.035215685671652_REALK, &
      0.000000000000000_REALK,      0.202901066221966_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.058793369564179_REALK, &
      0.000000000000000_REALK,     -0.057602429952032_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.201133187079915_REALK,      0.000000000000000_REALK, &
      0.236523050473660_REALK,      0.000000000000000_REALK,     -0.491715271971110_REALK, &
      0.000000000000000_REALK,     -0.258183678195284_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.197960920745526_REALK, &
      0.000000000000000_REALK,      1.615294143213862_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.998843642824975_REALK,      0.000000000000000_REALK, &
      2.045314146822971_REALK,      0.000000000000000_REALK,      0.723367295565746_REALK, &
      0.000000000000000_REALK,      0.798863885873506_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.268342812583306_REALK, &
      0.000000000000000_REALK,      1.776707244558118_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.398628984797319_REALK,      0.000000000000000_REALK, &
      1.747545585043352_REALK,      0.000000000000000_REALK,      1.853847640365360_REALK, &
      0.000000000000000_REALK,      0.748180790269308_REALK,      0.000000000000000_REALK, &
      4.235140029453503_REALK,      1.500207835342111_REALK,      0.000000000000000_REALK, &
      0.864597005158689_REALK,      0.000000000000000_REALK,     -0.674836862000479_REALK, &
      0.558242479420452_REALK,      0.000000000000000_REALK,     -0.279561160299126_REALK, &
      0.000000000000000_REALK,      0.430893257082940_REALK,      0.000000000000000_REALK, &
     -0.202503852474934_REALK,      0.000000000000000_REALK,     -0.902407350279690_REALK, &
      2.277587165604628_REALK,      0.509267434519298_REALK,      0.000000000000000_REALK, &
     -0.027535760991609_REALK,      0.000000000000000_REALK,     -0.971572848361278_REALK, &
     -0.514061762156443_REALK,      0.000000000000000_REALK,     -0.272543184510847_REALK, &
      0.000000000000000_REALK,     -1.379283967604092_REALK,      0.000000000000000_REALK, &
      0.018707799103236_REALK,      0.000000000000000_REALK,     -0.902798704007100_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.374008867343220_REALK, &
      0.000000000000000_REALK,     -0.173196517407420_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.121765184810767_REALK,      0.000000000000000_REALK, &
      0.304004239204481_REALK,      0.000000000000000_REALK,     -0.111798869455419_REALK, &
      0.000000000000000_REALK,      0.176942049661388_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.313220571023902_REALK, &
      0.000000000000000_REALK,      0.172598951373424_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.168136946955476_REALK,      0.000000000000000_REALK, &
      0.763390551728744_REALK,      0.000000000000000_REALK,      0.247036894001753_REALK, &
      0.000000000000000_REALK,      0.534036388434021_REALK,      0.000000000000000_REALK, &
      1.540978251169260_REALK,      0.687465581942290_REALK,      0.000000000000000_REALK, &
      0.349722826842498_REALK,      0.000000000000000_REALK,      0.100108064331912_REALK, &
      0.096984095621847_REALK,      0.000000000000000_REALK,      0.052229743945387_REALK, &
      0.000000000000000_REALK,     -0.246068247625271_REALK,      0.000000000000000_REALK, &
      0.033395278899084_REALK,      0.000000000000000_REALK,     -0.262332795456989_REALK, &
      0.614716921617524_REALK,     -0.396906282990822_REALK,      0.000000000000000_REALK, &
     -1.015530281630354_REALK,      0.000000000000000_REALK,     -0.153870772402092_REALK, &
     -1.842338342776566_REALK,      0.000000000000000_REALK,      0.124640159771947_REALK, &
      0.000000000000000_REALK,     -3.473410046557948_REALK,      0.000000000000000_REALK, &
      0.404854615760748_REALK,      0.000000000000000_REALK,     -0.330058234006576_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.140535253077486_REALK, &
      0.000000000000000_REALK,      1.807750950753940_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.004467375152874_REALK,      0.000000000000000_REALK, &
      2.670476622163287_REALK,      0.000000000000000_REALK,      0.535273380312941_REALK, &
      0.000000000000000_REALK,      0.720805852186395_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.801849988745179_REALK, &
      0.000000000000000_REALK,      1.246635418932144_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.223812022008376_REALK,      0.000000000000000_REALK, &
      2.325876670846854_REALK,      0.000000000000000_REALK,     -0.873363426966630_REALK, &
      0.000000000000000_REALK,      0.510390607846286_REALK,      0.000000000000000_REALK, &
      6.728552758193926_REALK,      1.809336525303154_REALK,      0.000000000000000_REALK, &
      0.940703180066802_REALK,      0.000000000000000_REALK,     -0.912249254855370_REALK, &
      0.537453939758580_REALK,      0.000000000000000_REALK,     -0.281095285832658_REALK, &
      0.000000000000000_REALK,      0.436644669796576_REALK,      0.000000000000000_REALK, &
     -0.177635887568657_REALK,      0.000000000000000_REALK,     -0.983503431072666_REALK, &
      1.839037785586867_REALK,      0.833992678342565_REALK,      0.000000000000000_REALK, &
      0.689935793509595_REALK,      0.000000000000000_REALK,     -1.390815748010148_REALK, &
      0.828418731282950_REALK,      0.000000000000000_REALK,     -0.539407969873239_REALK, &
      0.000000000000000_REALK,      1.432086509985206_REALK,      0.000000000000000_REALK, &
     -0.455729164945140_REALK,      0.000000000000000_REALK,     -1.256486101330133_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.508495479635189_REALK, &
      0.000000000000000_REALK,     -0.177113841932942_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.101212986060543_REALK,      0.000000000000000_REALK, &
      0.344582838462027_REALK,      0.000000000000000_REALK,     -0.066784649133812_REALK, &
      0.000000000000000_REALK,      0.145882412834789_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.253147519782604_REALK, &
      0.000000000000000_REALK,      0.074626559677539_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.004640347574624_REALK,      0.000000000000000_REALK, &
      0.745651474418736_REALK,      0.000000000000000_REALK,     -0.092976146324254_REALK, &
      0.000000000000000_REALK,      0.224490853071830_REALK,      0.000000000000000_REALK, &
      2.226351887267958_REALK,      0.892134109358284_REALK,      0.000000000000000_REALK, &
      0.527353085876537_REALK,      0.000000000000000_REALK,      0.123062914166450_REALK, &
      0.381982133403126_REALK,      0.000000000000000_REALK,      0.056507473212687_REALK, &
      0.000000000000000_REALK,      0.370909006593053_REALK,      0.000000000000000_REALK, &
      0.040599540805311_REALK,      0.000000000000000_REALK,     -0.259997548774935_REALK, &
      1.041031031394035_REALK,      0.771402940973008_REALK,      0.000000000000000_REALK, &
      0.789707171925735_REALK,      0.000000000000000_REALK,     -0.461980053905770_REALK, &
      1.051076830018077_REALK,      0.000000000000000_REALK,     -0.292763556405217_REALK, &
      0.000000000000000_REALK,      1.740679530554416_REALK,      0.000000000000000_REALK, &
     -0.306086962271854_REALK,      0.000000000000000_REALK,     -0.963452249259569_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.653645155751843_REALK, &
      0.000000000000000_REALK,     -0.286733377151829_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.144634769107033_REALK,      0.000000000000000_REALK, &
     -0.047255140774220_REALK,      0.000000000000000_REALK,     -0.040990243987471_REALK, &
      0.000000000000000_REALK,     -0.025195857912708_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.080196797418006_REALK, &
      0.000000000000000_REALK,      0.068268235221742_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.200876666851088_REALK,      0.000000000000000_REALK, &
      0.236183706793204_REALK,      0.000000000000000_REALK,      0.391118914566252_REALK, &
      0.000000000000000_REALK,     -0.205331041605905_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     17.571375772041410_REALK, &
      0.000000000000000_REALK,      2.526079496968509_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.340251556813987_REALK,      0.000000000000000_REALK, &
      4.413206810395598_REALK,      0.000000000000000_REALK,      0.520651533664298_REALK, &
      0.000000000000000_REALK,      0.762043198491398_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     39.427665433902220_REALK, &
      0.000000000000000_REALK,      5.868996815392356_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.444101081659632_REALK,      0.000000000000000_REALK, &
      7.798369133220606_REALK,      0.000000000000000_REALK,      2.926572898044868_REALK, &
      0.000000000000000_REALK,      1.337139101682161_REALK,      0.000000000000000_REALK, &
     15.730254107106168_REALK,      2.869919999583782_REALK,      0.000000000000000_REALK, &
      1.291534901038749_REALK,      0.000000000000000_REALK,     -1.626138320443142_REALK, &
      0.535273380312941_REALK,      0.000000000000000_REALK,     -0.341363196643447_REALK, &
      0.000000000000000_REALK,      0.326712499992547_REALK,      0.000000000000000_REALK, &
     -0.184517310868520_REALK,      0.000000000000000_REALK,     -1.326394517760135_REALK, &
     18.784371310569604_REALK,      2.580476735968341_REALK,      0.000000000000000_REALK, &
      0.318686026772865_REALK,      0.000000000000000_REALK,     -5.343197501825649_REALK, &
     -0.873363426966630_REALK,      0.000000000000000_REALK,     -0.823450709189911_REALK, &
      0.000000000000000_REALK,     -1.910040901254697_REALK,      0.000000000000000_REALK, &
     -0.117141470292131_REALK,      0.000000000000000_REALK,     -2.686202938257739_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.974238474389750_REALK, &
      0.000000000000000_REALK,     -0.243133297632917_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.119495424810484_REALK,      0.000000000000000_REALK, &
      0.505457352691654_REALK,      0.000000000000000_REALK,     -0.066414529312530_REALK, &
      0.000000000000000_REALK,      0.151512249546336_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.598019329954037_REALK, &
      0.000000000000000_REALK,      0.426332962750608_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.252964026342584_REALK,      0.000000000000000_REALK, &
      2.322345180755623_REALK,      0.000000000000000_REALK,      0.240673964809646_REALK, &
      0.000000000000000_REALK,      0.713680194238163_REALK,      0.000000000000000_REALK, &
      4.518487972372628_REALK,      1.293025093027460_REALK,      0.000000000000000_REALK, &
      0.598452666097253_REALK,      0.000000000000000_REALK,      0.190439226246937_REALK, &
      0.307114205993017_REALK,      0.000000000000000_REALK,      0.062704020895619_REALK, &
      0.000000000000000_REALK,      0.181927011065529_REALK,      0.000000000000000_REALK, &
      0.034857987346411_REALK,      0.000000000000000_REALK,     -0.304404689461642_REALK, &
      7.803700949464636_REALK,      1.470790038946840_REALK,      0.000000000000000_REALK, &
     -0.062911044405503_REALK,      0.000000000000000_REALK,     -1.302524149639696_REALK, &
     -0.885254848936498_REALK,      0.000000000000000_REALK,     -0.275403174953247_REALK, &
      0.000000000000000_REALK,     -1.704926003999438_REALK,      0.000000000000000_REALK, &
      0.013569228226575_REALK,      0.000000000000000_REALK,     -1.511618703344296_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.138842426635297_REALK, &
      0.000000000000000_REALK,     -0.423527339103640_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.236660824072216_REALK,      0.000000000000000_REALK, &
     -0.063035230701217_REALK,      0.000000000000000_REALK,     -0.166759703264564_REALK, &
      0.000000000000000_REALK,     -0.028156924888953_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.061789040603246_REALK, &
      0.000000000000000_REALK,     -0.462861599575549_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.339859456175841_REALK,      0.000000000000000_REALK, &
      1.542814408406607_REALK,      0.000000000000000_REALK,     -0.358423810204824_REALK, &
      0.000000000000000_REALK,      0.774705410081152_REALK,      0.000000000000000_REALK, &
      2.740126514972476_REALK,      0.987541222737090_REALK,      0.000000000000000_REALK, &
      0.403449153902916_REALK,      0.000000000000000_REALK,      0.514239059353327_REALK, &
      0.088925495696710_REALK,      0.000000000000000_REALK,      0.213243027091457_REALK, &
      0.000000000000000_REALK,     -0.173153714494003_REALK,      0.000000000000000_REALK, &
      0.104638734494587_REALK,      0.000000000000000_REALK,      0.022242100332581_REALK, &
      3.510342799990548_REALK,     -1.910475609504132_REALK,      0.000000000000000_REALK, &
     -3.866975667402599_REALK,      0.000000000000000_REALK,     -0.173316364391569_REALK, &
     -5.287752923186196_REALK,      0.000000000000000_REALK,      0.105819239361073_REALK, &
      0.000000000000000_REALK,     -7.155774602402691_REALK,      0.000000000000000_REALK, &
      0.246720119366463_REALK,      0.000000000000000_REALK,     -0.732621325058799_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.044587359439820_REALK, &
      0.000000000000000_REALK,      2.121144364623726_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.917140916653799_REALK,      0.000000000000000_REALK, &
      3.109365592964874_REALK,      0.000000000000000_REALK,      3.370273628126790_REALK, &
      0.000000000000000_REALK,      7.938431441571613_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.638903412325231_REALK, &
      0.000000000000000_REALK,      0.056689330492793_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.508266897834532_REALK,      0.000000000000000_REALK, &
      1.625474527653438_REALK,      0.000000000000000_REALK,    -15.402170041067093_REALK, &
      0.000000000000000_REALK,      0.253017105919307_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.453204871414534_REALK, &
      0.000000000000000_REALK,      1.019358964285105_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.221440413818928_REALK,      0.000000000000000_REALK, &
      4.473972473064979_REALK,      0.000000000000000_REALK,      2.147692267080746_REALK, &
      0.000000000000000_REALK,      3.275832458634831_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.160817193167822_REALK, &
      0.000000000000000_REALK,      0.796957293457937_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.139850983865434_REALK,      0.000000000000000_REALK, &
      3.041768992519959_REALK,      0.000000000000000_REALK,      5.440377959770212_REALK, &
      0.000000000000000_REALK,      2.821598486064986_REALK,      0.000000000000000_REALK, &
      6.739623493000440_REALK,      1.243285090756008_REALK,      0.000000000000000_REALK, &
      2.286902673361567_REALK,      0.000000000000000_REALK,      0.152689689128570_REALK, &
      0.683867794878887_REALK,      0.000000000000000_REALK,      0.031722543228257_REALK, &
      0.000000000000000_REALK,      1.511208485239099_REALK,      0.000000000000000_REALK, &
      0.144733320829210_REALK,      0.000000000000000_REALK,     -7.323952655368202_REALK, &
      1.923809589022957_REALK,      0.021609888944982_REALK,      0.000000000000000_REALK, &
     -0.646764543552429_REALK,      0.000000000000000_REALK,     -0.875612300330878_REALK, &
     -1.851794400515794_REALK,      0.000000000000000_REALK,     -0.012877692335565_REALK, &
      0.000000000000000_REALK,    -16.734358700473010_REALK,      0.000000000000000_REALK, &
      0.969356832663368_REALK,      0.000000000000000_REALK,     -8.641179288254875_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.007159388121674_REALK, &
      0.000000000000000_REALK,      0.187210817647410_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.348735610155402_REALK,      0.000000000000000_REALK, &
      5.651534830574002_REALK,      0.000000000000000_REALK,     -0.056617433833474_REALK, &
      0.000000000000000_REALK,      0.482145459197691_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.522277141355356_REALK, &
      0.000000000000000_REALK,     -0.086460271149407_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.436870986842693_REALK,      0.000000000000000_REALK, &
      3.841407928236389_REALK,      0.000000000000000_REALK,     -2.358884112479183_REALK, &
      0.000000000000000_REALK,     -0.245553386185797_REALK,      0.000000000000000_REALK, &
      7.640195874403676_REALK,      0.955828295051998_REALK,      0.000000000000000_REALK, &
      2.019810124125582_REALK,      0.000000000000000_REALK,      0.145699437933246_REALK, &
      0.707302587225063_REALK,      0.000000000000000_REALK,      0.021246196040203_REALK, &
      0.000000000000000_REALK,      4.202668862462227_REALK,      0.000000000000000_REALK, &
      0.102443402628716_REALK,      0.000000000000000_REALK,     -5.600751440788788_REALK, &
      1.448556074866965_REALK,      0.373397239635865_REALK,      0.000000000000000_REALK, &
      0.908969382246564_REALK,      0.000000000000000_REALK,     -1.026844575136587_REALK, &
      1.096484725899581_REALK,      0.000000000000000_REALK,     -0.240738769187116_REALK, &
      0.000000000000000_REALK,      6.638694539361995_REALK,      0.000000000000000_REALK, &
     -1.092838275470118_REALK,      0.000000000000000_REALK,     -8.128961101680620_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.743805802693236_REALK, &
      0.000000000000000_REALK,     -0.638913299806422_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.580547008544387_REALK,      0.000000000000000_REALK, &
     -0.757439963220353_REALK,      0.000000000000000_REALK,     -0.698585445476296_REALK, &
      0.000000000000000_REALK,     -0.633233924990309_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.317148173048078_REALK, &
      0.000000000000000_REALK,     -0.007938775630581_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.151032877331645_REALK,      0.000000000000000_REALK, &
      0.784529493982658_REALK,      0.000000000000000_REALK,      1.372508023641146_REALK, &
      0.000000000000000_REALK,      0.036621177063934_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.675717816681842_REALK, &
      0.000000000000000_REALK,     -0.719051410049493_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.795288281115057_REALK,      0.000000000000000_REALK, &
      7.357990570703930_REALK,      0.000000000000000_REALK,     -1.278168556851788_REALK, &
      0.000000000000000_REALK,     -1.409087046046340_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.497519591159349_REALK, &
      0.000000000000000_REALK,     -0.586750292662189_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.566883951006742_REALK,      0.000000000000000_REALK, &
      6.086984256794231_REALK,      0.000000000000000_REALK,      0.311007450734331_REALK, &
      0.000000000000000_REALK,     -1.072118091548105_REALK,      0.000000000000000_REALK, &
     10.744606354631989_REALK,      0.244778633656748_REALK,      0.000000000000000_REALK, &
      2.026041633916683_REALK,      0.000000000000000_REALK,      0.167191525078547_REALK, &
     -0.027554074804188_REALK,      0.000000000000000_REALK,      0.004621043345390_REALK, &
      0.000000000000000_REALK,      2.602335697174517_REALK,      0.000000000000000_REALK, &
      0.078190241606193_REALK,      0.000000000000000_REALK,     -4.890276570474483_REALK, &
      5.059388144694766_REALK,     -0.086654008632837_REALK,      0.000000000000000_REALK, &
      0.390886911635014_REALK,      0.000000000000000_REALK,     -1.455008940780762_REALK, &
     -0.779837143717459_REALK,      0.000000000000000_REALK,      0.034365332266093_REALK, &
      0.000000000000000_REALK,     -2.487042165129734_REALK,      0.000000000000000_REALK, &
     -0.302355412215796_REALK,      0.000000000000000_REALK,     -7.410644326366144_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.320257119802841_REALK, &
      0.000000000000000_REALK,     -0.388721352652506_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.607232934438636_REALK,      0.000000000000000_REALK, &
     -0.855956008485079_REALK,      0.000000000000000_REALK,     -0.499420826497580_REALK, &
      0.000000000000000_REALK,     -0.293151001132312_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.795593240313608_REALK, &
      0.000000000000000_REALK,     -0.166516881019144_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.279297800361542_REALK,      0.000000000000000_REALK, &
      1.210584481479144_REALK,      0.000000000000000_REALK,     -0.586653189597270_REALK, &
      0.000000000000000_REALK,      0.494193483410490_REALK,      0.000000000000000_REALK, &
      3.452866206041297_REALK,      0.770844953752298_REALK,      0.000000000000000_REALK, &
      0.804713842238142_REALK,      0.000000000000000_REALK,      1.872532481620072_REALK, &
      0.313716762090114_REALK,      0.000000000000000_REALK,      0.507176858066597_REALK, &
      0.000000000000000_REALK,      0.324266077345199_REALK,      0.000000000000000_REALK, &
      1.082359468318600_REALK,      0.000000000000000_REALK,      3.321140634634218_REALK, &
      2.504158105004662_REALK,      0.031319868467366_REALK,      0.000000000000000_REALK, &
     -0.531941358676136_REALK,      0.000000000000000_REALK,      0.413964099210032_REALK, &
     -1.786103165788588_REALK,      0.000000000000000_REALK,      0.007139784256863_REALK, &
      0.000000000000000_REALK,     -7.103228317290317_REALK,      0.000000000000000_REALK, &
     -0.236517699664349_REALK,      0.000000000000000_REALK,     -2.659384410765910_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     13.232232969955458_REALK, &
      0.000000000000000_REALK,     -2.354037648381481_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.848891797259034_REALK,      0.000000000000000_REALK, &
     10.427845522269001_REALK,      0.000000000000000_REALK,     -2.777161952416411_REALK, &
      0.000000000000000_REALK,     -3.378353912643380_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      9.853395923764094_REALK, &
      0.000000000000000_REALK,     -2.464419918671608_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.254815033235516_REALK,      0.000000000000000_REALK, &
     10.002740646713931_REALK,      0.000000000000000_REALK,     -3.552136475634689_REALK, &
      0.000000000000000_REALK,     -3.511798305857403_REALK,      0.000000000000000_REALK, &
     18.410033321704415_REALK,     -1.238928626709118_REALK,      0.000000000000000_REALK, &
      2.861003285242426_REALK,      0.000000000000000_REALK,      0.230924332428898_REALK, &
     -0.885641676713466_REALK,      0.000000000000000_REALK,     -0.019227997084120_REALK, &
      0.000000000000000_REALK,      3.113737240056449_REALK,      0.000000000000000_REALK, &
      0.080860496826592_REALK,      0.000000000000000_REALK,     -4.946553588177140_REALK, &
      4.832307918238196_REALK,     -0.507340169864239_REALK,      0.000000000000000_REALK, &
      1.378208889989605_REALK,      0.000000000000000_REALK,     -2.266510323760862_REALK, &
      0.149403404349347_REALK,      0.000000000000000_REALK,      0.218026675719636_REALK, &
      0.000000000000000_REALK,      3.457503530846006_REALK,      0.000000000000000_REALK, &
     -0.831394620315562_REALK,      0.000000000000000_REALK,     -9.002716088072086_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.508619529247603_REALK, &
      0.000000000000000_REALK,     -0.089693273411107_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.659869632461070_REALK,      0.000000000000000_REALK, &
     -1.064076448580154_REALK,      0.000000000000000_REALK,      0.015115541637999_REALK, &
      0.000000000000000_REALK,     -0.049536659651026_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.972581274534136_REALK, &
      0.000000000000000_REALK,      0.023367543971698_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.112285002672697_REALK,      0.000000000000000_REALK, &
      1.603645667981096_REALK,      0.000000000000000_REALK,      0.319881115007011_REALK, &
      0.000000000000000_REALK,     -0.054085065531990_REALK,      0.000000000000000_REALK, &
      5.135162924521350_REALK,      0.618026762479051_REALK,      0.000000000000000_REALK, &
      0.892939464834604_REALK,      0.000000000000000_REALK,      2.244890740573041_REALK, &
      0.319314840836878_REALK,      0.000000000000000_REALK,      0.334288087643435_REALK, &
      0.000000000000000_REALK,      1.035335829986242_REALK,      0.000000000000000_REALK, &
      0.879560922070636_REALK,      0.000000000000000_REALK,      2.915862056198403_REALK, &
      2.329122998047990_REALK,      0.566759148941376_REALK,      0.000000000000000_REALK, &
      0.967030266065390_REALK,      0.000000000000000_REALK,      0.627955394081196_REALK, &
      1.109342044166631_REALK,      0.000000000000000_REALK,      0.140004563772471_REALK, &
      0.000000000000000_REALK,      3.543716892767136_REALK,      0.000000000000000_REALK, &
      0.335324665482216_REALK,      0.000000000000000_REALK,     -3.146101864243078_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.601852719752774_REALK, &
      0.000000000000000_REALK,     -0.651794352585489_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.604795345655399_REALK,      0.000000000000000_REALK, &
     -2.506359051465912_REALK,      0.000000000000000_REALK,     -0.397130092045992_REALK, &
      0.000000000000000_REALK,     -1.143408613856631_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.594393539822673_REALK, &
      0.000000000000000_REALK,     -0.027973719493593_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.506104569744027_REALK,      0.000000000000000_REALK, &
     -0.560254121414469_REALK,      0.000000000000000_REALK,      2.426593892720527_REALK, &
      0.000000000000000_REALK,     -0.013798171215597_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     28.578810033362807_REALK, &
      0.000000000000000_REALK,     -6.489534505351901_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.527807518010002_REALK,      0.000000000000000_REALK, &
     17.040545381956004_REALK,      0.000000000000000_REALK,     -5.340428087842213_REALK, &
      0.000000000000000_REALK,     -6.422484606665105_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     61.412084329601093_REALK, &
      0.000000000000000_REALK,    -13.464700512355400_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      9.647487993103605_REALK,      0.000000000000000_REALK, &
     28.898679622747657_REALK,      0.000000000000000_REALK,     -5.826658350469169_REALK, &
      0.000000000000000_REALK,     -9.232413891079290_REALK,      0.000000000000000_REALK, &
     43.011596727298055_REALK,     -5.665859427077834_REALK,      0.000000000000000_REALK, &
      5.532783896842880_REALK,      0.000000000000000_REALK,      0.398830764607268_REALK, &
     -2.777161952416410_REALK,      0.000000000000000_REALK,     -0.066532133947025_REALK, &
      0.000000000000000_REALK,      4.630553990364325_REALK,      0.000000000000000_REALK, &
      0.107834950429708_REALK,      0.000000000000000_REALK,     -5.891412870240624_REALK, &
     51.561500800939136_REALK,     -7.462861851241898_REALK,      0.000000000000000_REALK, &
      4.403682758525665_REALK,      0.000000000000000_REALK,     -8.269922125652041_REALK, &
     -3.552136475634689_REALK,      0.000000000000000_REALK,      1.486643626712887_REALK, &
      0.000000000000000_REALK,     -0.039940172101777_REALK,      0.000000000000000_REALK, &
     -1.278238519741650_REALK,      0.000000000000000_REALK,    -15.805963902797808_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -6.769518184699796_REALK, &
      0.000000000000000_REALK,      0.454817819590072_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.984854507300778_REALK,      0.000000000000000_REALK, &
     -1.553360337795989_REALK,      0.000000000000000_REALK,      0.408298049429594_REALK, &
      0.000000000000000_REALK,      0.173221622509263_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.305944465064122_REALK, &
      0.000000000000000_REALK,      0.329176666456132_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.642719559298425_REALK,      0.000000000000000_REALK, &
      4.055424306707422_REALK,      0.000000000000000_REALK,     -0.065475041046830_REALK, &
      0.000000000000000_REALK,     -0.366603871947385_REALK,      0.000000000000000_REALK, &
     10.523767432407023_REALK,      0.199202508928201_REALK,      0.000000000000000_REALK, &
      1.182519834888909_REALK,      0.000000000000000_REALK,      3.400949529936066_REALK, &
     -0.013947817391287_REALK,      0.000000000000000_REALK,      0.081524157852630_REALK, &
      0.000000000000000_REALK,      0.767070063017775_REALK,      0.000000000000000_REALK, &
      0.803248880208568_REALK,      0.000000000000000_REALK,      3.046279440778997_REALK, &
     20.033639596328371_REALK,     -0.278546751068983_REALK,      0.000000000000000_REALK, &
      0.863219402891331_REALK,      0.000000000000000_REALK,      1.847008937076143_REALK, &
     -1.259165853754712_REALK,      0.000000000000000_REALK,     -0.031895751459770_REALK, &
      0.000000000000000_REALK,     -2.061021256788333_REALK,      0.000000000000000_REALK, &
      0.144029130797051_REALK,      0.000000000000000_REALK,     -4.452630886891213_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.357271318279055_REALK, &
      0.000000000000000_REALK,     -0.523546978349092_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.709304850441906_REALK,      0.000000000000000_REALK, &
     -3.175799520756840_REALK,      0.000000000000000_REALK,     -0.339700006439974_REALK, &
      0.000000000000000_REALK,     -0.633350780870881_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.470448364933553_REALK, &
      0.000000000000000_REALK,     -1.217963316256495_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.493662274434421_REALK,      0.000000000000000_REALK, &
     -1.379707488217319_REALK,      0.000000000000000_REALK,     -1.610225257475788_REALK, &
      0.000000000000000_REALK,     -0.289074135120970_REALK,      0.000000000000000_REALK, &
      5.636496385297429_REALK,      1.045531401768707_REALK,      0.000000000000000_REALK, &
      0.782799050067465_REALK,      0.000000000000000_REALK,      3.590810351385203_REALK, &
      0.264671326069089_REALK,      0.000000000000000_REALK,      0.843495730768991_REALK, &
      0.000000000000000_REALK,      0.159302276447124_REALK,      0.000000000000000_REALK, &
      1.048205116388365_REALK,      0.000000000000000_REALK,      6.369857696379724_REALK, &
     16.526175212343666_REALK,      0.167794653379460_REALK,      0.000000000000000_REALK, &
     -1.957864232773173_REALK,      0.000000000000000_REALK,      5.697898470471070_REALK, &
     -4.806559368971299_REALK,      0.000000000000000_REALK,      0.071853193132281_REALK, &
      0.000000000000000_REALK,     -9.810786992288149_REALK,      0.000000000000000_REALK, &
     -1.221644747222700_REALK,      0.000000000000000_REALK,      1.536141859802369_REALK/
    ! results of test 4, ket-major order, 03 DPG Z
  data REF_CONTR_INTS(27721:28980)                                                         &
    /-8.137725953997332_REALK,     -7.518411801115001_REALK,      0.000000000000000_REALK, &
     -9.012467752998225_REALK,      0.000000000000000_REALK,     -4.249544871489119_REALK, &
    -13.294080802006800_REALK,      0.000000000000000_REALK,     -4.769220718279112_REALK, &
      0.000000000000000_REALK,    -27.132935907577220_REALK,      0.000000000000000_REALK, &
     -8.100933386245487_REALK,      0.000000000000000_REALK,     -6.366232658519462_REALK, &
     -6.988877524013226_REALK,    -10.471826728432431_REALK,      0.000000000000000_REALK, &
    -15.685750486857497_REALK,      0.000000000000000_REALK,     -5.673191459599130_REALK, &
    -26.513231285085478_REALK,      0.000000000000000_REALK,     -7.726298485887849_REALK, &
      0.000000000000000_REALK,    -57.083136889896409_REALK,      0.000000000000000_REALK, &
    -14.207382135793260_REALK,      0.000000000000000_REALK,     -8.564163491739025_REALK, &
     -5.955487982959789_REALK,     -3.994314244361493_REALK,      0.000000000000000_REALK, &
     -3.563575162119177_REALK,      0.000000000000000_REALK,     -2.712234702000821_REALK, &
     -3.811686406944702_REALK,      0.000000000000000_REALK,     -2.183937427763691_REALK, &
      0.000000000000000_REALK,     -5.228057418123846_REALK,      0.000000000000000_REALK, &
     -2.637071965788581_REALK,      0.000000000000000_REALK,     -3.345122885445173_REALK, &
     -6.989821363372716_REALK,     -3.658078890679596_REALK,      0.000000000000000_REALK, &
     -2.100636241988287_REALK,      0.000000000000000_REALK,     -2.567440151273846_REALK, &
     -0.334353687490897_REALK,      0.000000000000000_REALK,     -1.803230685245962_REALK, &
      0.000000000000000_REALK,      3.891090721156867_REALK,      0.000000000000000_REALK, &
     -1.413966886784952_REALK,      0.000000000000000_REALK,     -2.880298268004151_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.366783791719838_REALK, &
      0.000000000000000_REALK,      1.284475015170755_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.584889858857865_REALK,      0.000000000000000_REALK, &
      2.020600419200204_REALK,      0.000000000000000_REALK,      2.649553003233414_REALK, &
      0.000000000000000_REALK,      2.570066592012236_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.047342333479302_REALK, &
      0.000000000000000_REALK,      4.142240042955138_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.516276455729082_REALK,      0.000000000000000_REALK, &
      4.402435872890289_REALK,      0.000000000000000_REALK,      9.567860308822143_REALK, &
      0.000000000000000_REALK,      6.152456119377796_REALK,      0.000000000000000_REALK, &
     -5.946208168112799_REALK,     -3.112219820549316_REALK,      0.000000000000000_REALK, &
     -2.344718005515286_REALK,      0.000000000000000_REALK,     -2.353389607268505_REALK, &
     -2.167236685952599_REALK,      0.000000000000000_REALK,     -1.455960840430643_REALK, &
      0.000000000000000_REALK,     -2.656139868993541_REALK,      0.000000000000000_REALK, &
     -1.424942776015703_REALK,      0.000000000000000_REALK,     -2.383687869315668_REALK, &
     -3.585061616622279_REALK,     -2.953048246087967_REALK,      0.000000000000000_REALK, &
     -2.937504213248849_REALK,      0.000000000000000_REALK,     -2.210190240759886_REALK, &
     -3.710161698649758_REALK,      0.000000000000000_REALK,     -1.616864573813839_REALK, &
      0.000000000000000_REALK,     -6.403306372731564_REALK,      0.000000000000000_REALK, &
     -1.791944110451794_REALK,      0.000000000000000_REALK,     -2.247110186852236_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.003409413637530_REALK, &
      0.000000000000000_REALK,      0.677792042716806_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.616760080109802_REALK,      0.000000000000000_REALK, &
      1.269229793003586_REALK,      0.000000000000000_REALK,      0.718919466885174_REALK, &
      0.000000000000000_REALK,      1.113745412138833_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.431988550468432_REALK, &
      0.000000000000000_REALK,      0.985957922932241_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.641494849864817_REALK,      0.000000000000000_REALK, &
      1.730085339574724_REALK,      0.000000000000000_REALK,      0.111521646173543_REALK, &
      0.000000000000000_REALK,      1.327178142234540_REALK,      0.000000000000000_REALK, &
      0.832381672282525_REALK,      0.674992175188204_REALK,      0.000000000000000_REALK, &
      0.698678751796009_REALK,      0.000000000000000_REALK,     -0.680529505964468_REALK, &
      0.880215598630669_REALK,      0.000000000000000_REALK,     -0.652302280663389_REALK, &
      0.000000000000000_REALK,      1.422152172717833_REALK,      0.000000000000000_REALK, &
     -0.877112034286450_REALK,      0.000000000000000_REALK,     -1.712262941148186_REALK, &
     -0.608778392320540_REALK,     -0.794861547749707_REALK,      0.000000000000000_REALK, &
     -1.037695955375129_REALK,      0.000000000000000_REALK,     -2.757619104809249_REALK, &
     -1.493433089317576_REALK,      0.000000000000000_REALK,     -3.197691837899330_REALK, &
      0.000000000000000_REALK,     -2.543371819675107_REALK,      0.000000000000000_REALK, &
     -4.651125982536243_REALK,      0.000000000000000_REALK,     -5.225785861474071_REALK, &
     -7.421919132057277_REALK,     -2.926029388467826_REALK,      0.000000000000000_REALK, &
     -1.816085843545380_REALK,      0.000000000000000_REALK,     -2.497174251660709_REALK, &
     -1.325947453579602_REALK,      0.000000000000000_REALK,     -1.151345574447807_REALK, &
      0.000000000000000_REALK,     -1.231019868863307_REALK,      0.000000000000000_REALK, &
     -0.898167928206524_REALK,      0.000000000000000_REALK,     -2.058347839995457_REALK, &
    -10.680662694702249_REALK,     -3.410755027230077_REALK,      0.000000000000000_REALK, &
     -1.335766443459854_REALK,      0.000000000000000_REALK,     -2.823993082177350_REALK, &
      0.036883414653781_REALK,      0.000000000000000_REALK,     -1.131370926596491_REALK, &
      0.000000000000000_REALK,      1.896576615444876_REALK,      0.000000000000000_REALK, &
     -0.562498293595675_REALK,      0.000000000000000_REALK,     -1.981997299039168_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.030891910556724_REALK, &
      0.000000000000000_REALK,      0.534099003216049_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.404144740326823_REALK,      0.000000000000000_REALK, &
      1.096788278771223_REALK,      0.000000000000000_REALK,      0.393187395269400_REALK, &
      0.000000000000000_REALK,      0.714209453304695_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.580566098480313_REALK, &
      0.000000000000000_REALK,      1.383314564421933_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.137675263062559_REALK,      0.000000000000000_REALK, &
      1.888836433404303_REALK,      0.000000000000000_REALK,      1.336690378001966_REALK, &
      0.000000000000000_REALK,      1.285394706223699_REALK,      0.000000000000000_REALK, &
      0.726974568819392_REALK,      0.421733345290702_REALK,      0.000000000000000_REALK, &
      0.321373826445930_REALK,      0.000000000000000_REALK,     -0.505268911270286_REALK, &
      0.289628920261060_REALK,      0.000000000000000_REALK,     -0.342795949446317_REALK, &
      0.000000000000000_REALK,      0.315101188067622_REALK,      0.000000000000000_REALK, &
     -0.328323827811735_REALK,      0.000000000000000_REALK,     -1.034571330761249_REALK, &
     -0.872853851337845_REALK,     -0.396059760371329_REALK,      0.000000000000000_REALK, &
     -0.188824127445455_REALK,      0.000000000000000_REALK,     -1.695699836727133_REALK, &
     -0.024359593397086_REALK,      0.000000000000000_REALK,     -0.965288703736992_REALK, &
      0.000000000000000_REALK,      0.218816609383813_REALK,      0.000000000000000_REALK, &
     -0.584238515169235_REALK,      0.000000000000000_REALK,     -2.218252741304243_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.270557963073644_REALK, &
      0.000000000000000_REALK,     -0.217177600469761_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.225781647258981_REALK,      0.000000000000000_REALK, &
      0.564091669144143_REALK,      0.000000000000000_REALK,     -0.299396757599300_REALK, &
      0.000000000000000_REALK,      0.569113062190256_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.448245518701450_REALK, &
      0.000000000000000_REALK,      2.080267914759667_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.245366901715177_REALK,      0.000000000000000_REALK, &
      4.136692244938383_REALK,      0.000000000000000_REALK,      3.006084119274782_REALK, &
      0.000000000000000_REALK,      4.462248050668668_REALK,      0.000000000000000_REALK, &
    -11.326235033600346_REALK,     -3.353030369708668_REALK,      0.000000000000000_REALK, &
     -1.801128853310727_REALK,      0.000000000000000_REALK,     -3.242492886939606_REALK, &
     -1.089916812175532_REALK,      0.000000000000000_REALK,     -1.099950916903829_REALK, &
      0.000000000000000_REALK,     -0.890571133297543_REALK,      0.000000000000000_REALK, &
     -0.718165418453626_REALK,      0.000000000000000_REALK,     -2.154802580893928_REALK, &
     -7.581786524393091_REALK,     -3.501866164121771_REALK,      0.000000000000000_REALK, &
     -2.505035817257145_REALK,      0.000000000000000_REALK,     -3.553984792398894_REALK, &
     -2.405093712635869_REALK,      0.000000000000000_REALK,     -1.403846847360554_REALK, &
      0.000000000000000_REALK,     -3.504844542754003_REALK,      0.000000000000000_REALK, &
     -1.025597968764424_REALK,      0.000000000000000_REALK,     -2.425088135795570_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.324692181530647_REALK, &
      0.000000000000000_REALK,      0.513522161865704_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.316037281155698_REALK,      0.000000000000000_REALK, &
      1.174988047485308_REALK,      0.000000000000000_REALK,      0.235808531673546_REALK, &
      0.000000000000000_REALK,      0.553632469896448_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.138675662171723_REALK, &
      0.000000000000000_REALK,      0.900422006165978_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.405538429416759_REALK,      0.000000000000000_REALK, &
      1.891864341567256_REALK,      0.000000000000000_REALK,     -0.012018089102400_REALK, &
      0.000000000000000_REALK,      0.813456230775359_REALK,      0.000000000000000_REALK, &
      0.897681656762605_REALK,      0.402448271731825_REALK,      0.000000000000000_REALK, &
      0.256042819323277_REALK,      0.000000000000000_REALK,     -0.530867993271107_REALK, &
      0.196518090249710_REALK,      0.000000000000000_REALK,     -0.272719765192369_REALK, &
      0.000000000000000_REALK,      0.190303082404576_REALK,      0.000000000000000_REALK, &
     -0.210893422356248_REALK,      0.000000000000000_REALK,     -0.876360792246952_REALK, &
     -0.500015601786151_REALK,     -0.360428609808526_REALK,      0.000000000000000_REALK, &
     -0.311513168325876_REALK,      0.000000000000000_REALK,     -1.722144487559651_REALK, &
     -0.331557331750035_REALK,      0.000000000000000_REALK,     -1.061650236815361_REALK, &
      0.000000000000000_REALK,     -0.455742408909865_REALK,      0.000000000000000_REALK, &
     -0.937090724840591_REALK,      0.000000000000000_REALK,     -2.190302840681629_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.243266755258462_REALK, &
      0.000000000000000_REALK,     -0.138766053439616_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.104852124979126_REALK,      0.000000000000000_REALK, &
      0.422844741968878_REALK,      0.000000000000000_REALK,     -0.096569484822867_REALK, &
      0.000000000000000_REALK,      0.293173893953730_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.976485132941532_REALK, &
      0.000000000000000_REALK,      0.584162492419089_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.320284814282801_REALK,      0.000000000000000_REALK, &
      1.994020322013205_REALK,      0.000000000000000_REALK,      0.044345719843872_REALK, &
      0.000000000000000_REALK,      1.218261832942779_REALK,      0.000000000000000_REALK, &
      2.041522747813437_REALK,      1.418038471048692_REALK,      0.000000000000000_REALK, &
      1.239507018934714_REALK,      0.000000000000000_REALK,      0.128800895130054_REALK, &
      1.296685709307166_REALK,      0.000000000000000_REALK,      0.102516796740564_REALK, &
      0.000000000000000_REALK,      1.655352250998265_REALK,      0.000000000000000_REALK, &
      0.108918058445446_REALK,      0.000000000000000_REALK,     -0.666594823849110_REALK, &
      0.948912397555915_REALK,      1.084226860830980_REALK,      0.000000000000000_REALK, &
      1.229838248650144_REALK,      0.000000000000000_REALK,     -3.267705097444553_REALK, &
      1.491528402162909_REALK,      0.000000000000000_REALK,     -3.193104054530806_REALK, &
      0.000000000000000_REALK,      2.023042362426698_REALK,      0.000000000000000_REALK, &
     -3.698996579915871_REALK,      0.000000000000000_REALK,     -6.951485342599682_REALK, &
    -25.760016550189654_REALK,     -5.207353015824748_REALK,      0.000000000000000_REALK, &
     -2.378115229363468_REALK,      0.000000000000000_REALK,     -5.623018221931065_REALK, &
     -1.079336322387982_REALK,      0.000000000000000_REALK,     -1.307872877554535_REALK, &
      0.000000000000000_REALK,     -0.700280650854329_REALK,      0.000000000000000_REALK, &
     -0.717406771220009_REALK,      0.000000000000000_REALK,     -2.827162800536084_REALK, &
    -76.841168444955002_REALK,    -13.204290197976960_REALK,      0.000000000000000_REALK, &
     -3.663249561774432_REALK,      0.000000000000000_REALK,    -13.547638176106885_REALK, &
      0.629251771885525_REALK,      0.000000000000000_REALK,     -2.611666908826147_REALK, &
      0.000000000000000_REALK,      3.449829401489751_REALK,      0.000000000000000_REALK, &
     -0.834601616314077_REALK,      0.000000000000000_REALK,     -5.144285389399911_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.437859187900436_REALK, &
      0.000000000000000_REALK,      0.669795167551374_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.340112725525865_REALK,      0.000000000000000_REALK, &
      1.655540413667114_REALK,      0.000000000000000_REALK,      0.200214087811873_REALK, &
      0.000000000000000_REALK,      0.546332760930368_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     11.868914065487886_REALK, &
      0.000000000000000_REALK,      3.225033838544671_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.654672640404744_REALK,      0.000000000000000_REALK, &
      5.180105306053826_REALK,      0.000000000000000_REALK,      1.258807329295214_REALK, &
      0.000000000000000_REALK,      1.621331678291762_REALK,      0.000000000000000_REALK, &
      1.721941199597337_REALK,      0.548417052552909_REALK,      0.000000000000000_REALK, &
      0.273356367805010_REALK,      0.000000000000000_REALK,     -0.776448041639968_REALK, &
      0.158628084966085_REALK,      0.000000000000000_REALK,     -0.284531394357001_REALK, &
      0.000000000000000_REALK,      0.113023640502003_REALK,      0.000000000000000_REALK, &
     -0.170346220024884_REALK,      0.000000000000000_REALK,     -0.969754197732820_REALK, &
     -3.843501354760260_REALK,     -1.034566780702520_REALK,      0.000000000000000_REALK, &
     -0.320526224636809_REALK,      0.000000000000000_REALK,     -4.978960544648698_REALK, &
      0.006670945030812_REALK,      0.000000000000000_REALK,     -1.503499446032021_REALK, &
      0.000000000000000_REALK,      0.246221212393926_REALK,      0.000000000000000_REALK, &
     -0.536560008828210_REALK,      0.000000000000000_REALK,     -3.523893448405508_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.362251495587146_REALK, &
      0.000000000000000_REALK,     -0.150722947484236_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.090647428330862_REALK,      0.000000000000000_REALK, &
      0.482082152510603_REALK,      0.000000000000000_REALK,     -0.067681286462269_REALK, &
      0.000000000000000_REALK,      0.240920806746977_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.373210323009790_REALK, &
      0.000000000000000_REALK,      1.854519328887100_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.149613702780849_REALK,      0.000000000000000_REALK, &
      4.406023894039739_REALK,      0.000000000000000_REALK,      0.969534508430610_REALK, &
      0.000000000000000_REALK,      2.152225817874246_REALK,      0.000000000000000_REALK, &
      2.740127619349789_REALK,      1.284161602251891_REALK,      0.000000000000000_REALK, &
      0.785873778581925_REALK,      0.000000000000000_REALK,      0.131815153192988_REALK, &
      0.562918038112874_REALK,      0.000000000000000_REALK,      0.071078685656936_REALK, &
      0.000000000000000_REALK,      0.470006368368702_REALK,      0.000000000000000_REALK, &
      0.052246424050360_REALK,      0.000000000000000_REALK,     -0.516132570897214_REALK, &
      3.510349281393135_REALK,      1.342606303320141_REALK,      0.000000000000000_REALK, &
      0.506372935480754_REALK,      0.000000000000000_REALK,     -4.546662127795209_REALK, &
      0.049238661189622_REALK,      0.000000000000000_REALK,     -1.950851129903359_REALK, &
      0.000000000000000_REALK,     -0.317479229927860_REALK,      0.000000000000000_REALK, &
     -0.847531644438316_REALK,      0.000000000000000_REALK,     -5.382412033614036_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.730596263640538_REALK, &
      0.000000000000000_REALK,     -1.115606477095586_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.921818838965467_REALK,      0.000000000000000_REALK, &
     -0.062319280775655_REALK,      0.000000000000000_REALK,     -0.938111579233820_REALK, &
      0.000000000000000_REALK,     -0.048252715821395_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.485887500962196_REALK, &
      0.000000000000000_REALK,      2.343164113093605_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.906311882628910_REALK,      0.000000000000000_REALK, &
     12.792144701838209_REALK,      0.000000000000000_REALK,      1.831920407624533_REALK, &
      0.000000000000000_REALK,      9.904731174065434_REALK,      0.000000000000000_REALK, &
     -5.916742925414304_REALK,     -1.362636005685714_REALK,      0.000000000000000_REALK, &
     -5.686510411213339_REALK,      0.000000000000000_REALK,     -7.692087091514367_REALK, &
     -2.913472876813481_REALK,      0.000000000000000_REALK,     -2.072268270784523_REALK, &
      0.000000000000000_REALK,    -37.711584185998426_REALK,      0.000000000000000_REALK, &
    -21.281895656926736_REALK,      0.000000000000000_REALK,    -47.979687314852555_REALK, &
     -3.833742107499988_REALK,     -1.265530402769898_REALK,      0.000000000000000_REALK, &
     -7.947235193851074_REALK,      0.000000000000000_REALK,     -7.885451685914238_REALK, &
     -5.391419937685342_REALK,      0.000000000000000_REALK,     -3.219715834959905_REALK, &
      0.000000000000000_REALK,    -75.220895772524116_REALK,      0.000000000000000_REALK, &
    -35.470280409536869_REALK,      0.000000000000000_REALK,    -58.657544758803212_REALK, &
     -4.491690508564956_REALK,     -1.123164817732078_REALK,      0.000000000000000_REALK, &
     -2.199316099682827_REALK,      0.000000000000000_REALK,     -5.167227589921577_REALK, &
     -1.302168927156512_REALK,      0.000000000000000_REALK,     -1.455172416454391_REALK, &
      0.000000000000000_REALK,     -7.108333282336742_REALK,      0.000000000000000_REALK, &
     -7.067766428278652_REALK,      0.000000000000000_REALK,    -27.675844089737524_REALK, &
     -3.810653499545672_REALK,     -0.890266998364119_REALK,      0.000000000000000_REALK, &
     -1.029071891027483_REALK,      0.000000000000000_REALK,     -4.097056194763842_REALK, &
      0.061062781658987_REALK,      0.000000000000000_REALK,     -1.253223344968765_REALK, &
      0.000000000000000_REALK,      5.755381900228011_REALK,      0.000000000000000_REALK, &
     -3.643391827404655_REALK,      0.000000000000000_REALK,    -24.175798902828284_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.088791419758602_REALK, &
      0.000000000000000_REALK,     -0.101761593674605_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.085043986324641_REALK,      0.000000000000000_REALK, &
      1.717051198894732_REALK,      0.000000000000000_REALK,     -0.459772971579482_REALK, &
      0.000000000000000_REALK,      4.881122611888062_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.272492087711502_REALK, &
      0.000000000000000_REALK,      1.734399857210233_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.805314136807474_REALK,      0.000000000000000_REALK, &
      4.993031320680203_REALK,      0.000000000000000_REALK,     10.282412206301514_REALK, &
      0.000000000000000_REALK,     17.116319766195467_REALK,      0.000000000000000_REALK, &
     -4.785276817015101_REALK,     -0.804649145376301_REALK,      0.000000000000000_REALK, &
     -1.441059666172924_REALK,      0.000000000000000_REALK,     -4.633766440362917_REALK, &
     -0.691282926614477_REALK,      0.000000000000000_REALK,     -0.908200102891405_REALK, &
      0.000000000000000_REALK,     -3.248507868301909_REALK,      0.000000000000000_REALK, &
     -3.711325997126887_REALK,      0.000000000000000_REALK,    -19.889782334510400_REALK, &
     -2.224469929696323_REALK,     -0.666562995007842_REALK,      0.000000000000000_REALK, &
     -1.275774993393498_REALK,      0.000000000000000_REALK,     -3.724934429774747_REALK, &
     -1.226487372034105_REALK,      0.000000000000000_REALK,     -1.015170114223134_REALK, &
      0.000000000000000_REALK,     -6.439731806125075_REALK,      0.000000000000000_REALK, &
     -3.623292703970243_REALK,      0.000000000000000_REALK,    -17.631802645530655_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.095419390020263_REALK, &
      0.000000000000000_REALK,     -0.047389161299001_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.045839692047056_REALK,      0.000000000000000_REALK, &
      1.607507139113512_REALK,      0.000000000000000_REALK,     -0.109214182031374_REALK, &
      0.000000000000000_REALK,      1.821660516938693_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.812615838293123_REALK, &
      0.000000000000000_REALK,      0.423064866654978_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.310854173096403_REALK,      0.000000000000000_REALK, &
      3.449720465384563_REALK,      0.000000000000000_REALK,     -0.058544271091750_REALK, &
      0.000000000000000_REALK,      3.349170777932544_REALK,      0.000000000000000_REALK, &
      2.392703141233571_REALK,      1.162177083166801_REALK,      0.000000000000000_REALK, &
      1.712842931299675_REALK,      0.000000000000000_REALK,      0.891642987127733_REALK, &
      1.844218191987770_REALK,      0.000000000000000_REALK,      0.504803554254633_REALK, &
      0.000000000000000_REALK,      7.816802653152843_REALK,      0.000000000000000_REALK, &
      1.697617270774329_REALK,      0.000000000000000_REALK,     -2.290659222261785_REALK, &
      0.659457303132002_REALK,      0.628202397158210_REALK,      0.000000000000000_REALK, &
      1.112931067257259_REALK,      0.000000000000000_REALK,     -1.793610807342675_REALK, &
      1.602074952276169_REALK,      0.000000000000000_REALK,     -1.553984385357036_REALK, &
      0.000000000000000_REALK,      6.703034878720958_REALK,      0.000000000000000_REALK, &
     -5.133895649724600_REALK,      0.000000000000000_REALK,    -22.206997947533985_REALK, &
     -6.521709204953400_REALK,     -0.365556902552061_REALK,      0.000000000000000_REALK, &
     -1.313598304364337_REALK,      0.000000000000000_REALK,     -5.152984915332025_REALK, &
     -0.169740130721466_REALK,      0.000000000000000_REALK,     -0.350425107628118_REALK, &
      0.000000000000000_REALK,     -1.842524771582911_REALK,      0.000000000000000_REALK, &
     -2.574189172733588_REALK,      0.000000000000000_REALK,    -16.830053667898309_REALK, &
     -7.557344711467171_REALK,     -0.239870561768506_REALK,      0.000000000000000_REALK, &
     -0.865949738761256_REALK,      0.000000000000000_REALK,     -5.134044006377011_REALK, &
      0.502301318230756_REALK,      0.000000000000000_REALK,     -0.224714725776265_REALK, &
      0.000000000000000_REALK,      1.451353459613150_REALK,      0.000000000000000_REALK, &
     -1.582275105624546_REALK,      0.000000000000000_REALK,    -15.634991383549011_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.119317189602977_REALK, &
      0.000000000000000_REALK,     -0.026867632392082_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.035570589693272_REALK,      0.000000000000000_REALK, &
      1.707200479373402_REALK,      0.000000000000000_REALK,     -0.040075741044603_REALK, &
      0.000000000000000_REALK,      0.785866108520695_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.580403582531823_REALK, &
      0.000000000000000_REALK,      0.384515682843978_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.507081818757877_REALK,      0.000000000000000_REALK, &
      4.126896569068656_REALK,      0.000000000000000_REALK,      0.848843494114589_REALK, &
      0.000000000000000_REALK,      1.958413370255635_REALK,      0.000000000000000_REALK, &
      2.493856157769716_REALK,      0.754670302543448_REALK,      0.000000000000000_REALK, &
      0.838685055150041_REALK,      0.000000000000000_REALK,      0.758305045235043_REALK, &
      0.647366707230370_REALK,      0.000000000000000_REALK,      0.278402153957061_REALK, &
      0.000000000000000_REALK,      1.652960127155593_REALK,      0.000000000000000_REALK, &
      0.632487415147808_REALK,      0.000000000000000_REALK,     -1.482327519055578_REALK, &
      1.260099339814497_REALK,      0.327788212817024_REALK,      0.000000000000000_REALK, &
      0.215015086812068_REALK,      0.000000000000000_REALK,     -1.390415421063357_REALK, &
     -0.014962219485460_REALK,      0.000000000000000_REALK,     -0.498766585160597_REALK, &
      0.000000000000000_REALK,     -0.620621062375926_REALK,      0.000000000000000_REALK, &
     -0.638127822759594_REALK,      0.000000000000000_REALK,    -11.075572688839705_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.918638556023011_REALK, &
      0.000000000000000_REALK,     -1.247968285380880_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.359674773590333_REALK,      0.000000000000000_REALK, &
     -1.664613530997887_REALK,      0.000000000000000_REALK,     -3.438321087465831_REALK, &
      0.000000000000000_REALK,     -2.213407897590836_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.060121775440973_REALK, &
      0.000000000000000_REALK,     -0.819973947703488_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.000921059208056_REALK,      0.000000000000000_REALK, &
      3.491720447549489_REALK,      0.000000000000000_REALK,     -2.508851642746520_REALK, &
      0.000000000000000_REALK,      5.267669196237378_REALK,      0.000000000000000_REALK, &
    -10.929593066887989_REALK,      0.462380204026195_REALK,      0.000000000000000_REALK, &
     -1.714297948754424_REALK,      0.000000000000000_REALK,     -6.961339353107508_REALK, &
      0.370666188687865_REALK,      0.000000000000000_REALK,      0.364385160923948_REALK, &
      0.000000000000000_REALK,     -1.843225489551111_REALK,      0.000000000000000_REALK, &
     -2.460243227882519_REALK,      0.000000000000000_REALK,    -16.650730612414513_REALK, &
     -6.906411603283909_REALK,      0.507326765660141_REALK,      0.000000000000000_REALK, &
     -1.829956266873424_REALK,      0.000000000000000_REALK,     -7.652057956230188_REALK, &
     -0.014132875344910_REALK,      0.000000000000000_REALK,      0.515016152735293_REALK, &
      0.000000000000000_REALK,     -3.576946733570105_REALK,      0.000000000000000_REALK, &
     -2.607687622190320_REALK,      0.000000000000000_REALK,    -18.173637241103012_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.174852371154892_REALK, &
      0.000000000000000_REALK,     -0.010997796649474_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.035126646040906_REALK,      0.000000000000000_REALK, &
      2.056715677088001_REALK,      0.000000000000000_REALK,     -0.007645162866558_REALK, &
      0.000000000000000_REALK,      0.235580156955732_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.879242520321070_REALK, &
      0.000000000000000_REALK,      0.083673330566693_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.321772558520226_REALK,      0.000000000000000_REALK, &
      5.317615151494328_REALK,      0.000000000000000_REALK,     -0.266523001582948_REALK, &
      0.000000000000000_REALK,      0.332355529704975_REALK,      0.000000000000000_REALK, &
      3.485573628407779_REALK,      0.563834199557755_REALK,      0.000000000000000_REALK, &
      0.690416078857152_REALK,      0.000000000000000_REALK,      0.854354631744021_REALK, &
      0.338210548662795_REALK,      0.000000000000000_REALK,      0.170996794509124_REALK, &
      0.000000000000000_REALK,      0.867276254326718_REALK,      0.000000000000000_REALK, &
      0.381309601213725_REALK,      0.000000000000000_REALK,     -1.223072674538717_REALK, &
      0.908634692386748_REALK,      0.257024367629030_REALK,      0.000000000000000_REALK, &
      0.344802622751429_REALK,      0.000000000000000_REALK,     -1.635176152147719_REALK, &
      0.315232968071799_REALK,      0.000000000000000_REALK,     -0.423795958760676_REALK, &
      0.000000000000000_REALK,      0.873272484897276_REALK,      0.000000000000000_REALK, &
     -0.798058729222877_REALK,      0.000000000000000_REALK,    -10.158081791834730_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.150254644347397_REALK, &
      0.000000000000000_REALK,     -0.730157170904059_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.721242662148955_REALK,      0.000000000000000_REALK, &
     -1.533668052750012_REALK,      0.000000000000000_REALK,     -0.937693635566330_REALK, &
      0.000000000000000_REALK,     -0.948392521391419_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.708999598491289_REALK, &
      0.000000000000000_REALK,     -0.258720619940849_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.180781031024492_REALK,      0.000000000000000_REALK, &
      2.530510793377520_REALK,      0.000000000000000_REALK,      0.017963626055554_REALK, &
      0.000000000000000_REALK,      1.296208986157356_REALK,      0.000000000000000_REALK, &
      3.711040941196220_REALK,      1.734031163333516_REALK,      0.000000000000000_REALK, &
      1.747375347837267_REALK,      0.000000000000000_REALK,      2.889240442735749_REALK, &
      1.921247655179227_REALK,      0.000000000000000_REALK,      1.670388438496198_REALK, &
      0.000000000000000_REALK,      4.443676256431936_REALK,      0.000000000000000_REALK, &
      3.065328836361473_REALK,      0.000000000000000_REALK,      6.158322690136368_REALK, &
      3.511960881041237_REALK,      3.158151075265162_REALK,      0.000000000000000_REALK, &
      3.921614986980056_REALK,      0.000000000000000_REALK,      1.346889360055935_REALK, &
      5.368483132576377_REALK,      0.000000000000000_REALK,      1.109743053878423_REALK, &
      0.000000000000000_REALK,     11.850964234253334_REALK,      0.000000000000000_REALK, &
      1.934355388256364_REALK,      0.000000000000000_REALK,    -12.606517106143123_REALK, &
    -25.117249783315337_REALK,      2.846657409859128_REALK,      0.000000000000000_REALK, &
     -3.169022150332956_REALK,      0.000000000000000_REALK,    -11.826299166444672_REALK, &
      1.416387169729136_REALK,      0.000000000000000_REALK,      1.697362301752838_REALK, &
      0.000000000000000_REALK,     -2.598209575708137_REALK,      0.000000000000000_REALK, &
     -3.136279799715850_REALK,      0.000000000000000_REALK,    -19.506849653512134_REALK, &
    -72.399115189476063_REALK,      9.015460351035610_REALK,      0.000000000000000_REALK, &
     -6.255516127008528_REALK,      0.000000000000000_REALK,    -27.430379766655740_REALK, &
      4.024608243097069_REALK,      0.000000000000000_REALK,      4.242404458019387_REALK, &
      0.000000000000000_REALK,     -1.137269538624157_REALK,      0.000000000000000_REALK, &
     -4.289253513946976_REALK,      0.000000000000000_REALK,    -31.347227634567908_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.329967757838843_REALK, &
      0.000000000000000_REALK,      0.013936532913965_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.048451179542544_REALK,      0.000000000000000_REALK, &
      2.936649644115119_REALK,      0.000000000000000_REALK,      0.014030287188015_REALK, &
      0.000000000000000_REALK,     -0.205866439257046_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      9.809485984082908_REALK, &
      0.000000000000000_REALK,     -0.425797651563924_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.103907982847787_REALK,      0.000000000000000_REALK, &
     12.866825521830696_REALK,      0.000000000000000_REALK,      0.008011825978758_REALK, &
      0.000000000000000_REALK,     -0.813809635478861_REALK,      0.000000000000000_REALK, &
      6.922446758555569_REALK,      0.322399045727098_REALK,      0.000000000000000_REALK, &
      0.830883450415708_REALK,      0.000000000000000_REALK,      1.254329120480943_REALK, &
      0.093115592949245_REALK,      0.000000000000000_REALK,      0.073978956391260_REALK, &
      0.000000000000000_REALK,      0.588575948164437_REALK,      0.000000000000000_REALK, &
      0.316449737010800_REALK,      0.000000000000000_REALK,     -1.238292882505933_REALK, &
      7.602155576711011_REALK,      0.195880883726637_REALK,      0.000000000000000_REALK, &
      0.485812196242228_REALK,      0.000000000000000_REALK,     -4.678264279458920_REALK, &
     -0.206038795458248_REALK,      0.000000000000000_REALK,     -0.149715117132258_REALK, &
      0.000000000000000_REALK,     -0.305547108653692_REALK,      0.000000000000000_REALK, &
     -0.541048775112373_REALK,      0.000000000000000_REALK,    -13.984135570993686_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.384154425110191_REALK, &
      0.000000000000000_REALK,     -0.546531660091123_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.627534119964166_REALK,      0.000000000000000_REALK, &
     -1.826289185318728_REALK,      0.000000000000000_REALK,     -0.411698358469531_REALK, &
      0.000000000000000_REALK,     -0.489536273683456_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.920187346862615_REALK, &
      0.000000000000000_REALK,     -0.488109648506810_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.470641620329306_REALK,      0.000000000000000_REALK, &
      4.831300019512882_REALK,      0.000000000000000_REALK,     -0.404352578788297_REALK, &
      0.000000000000000_REALK,      1.176698202972171_REALK,      0.000000000000000_REALK, &
      5.636497579752011_REALK,      1.417215030163967_REALK,      0.000000000000000_REALK, &
      1.129577841335789_REALK,      0.000000000000000_REALK,      3.244032736826324_REALK, &
      0.756184850015755_REALK,      0.000000000000000_REALK,      1.032937929461263_REALK, &
      0.000000000000000_REALK,      1.124323488424839_REALK,      0.000000000000000_REALK, &
      1.366484837942159_REALK,      0.000000000000000_REALK,      4.768280233742439_REALK, &
     16.526181476585322_REALK,      3.489865160500868_REALK,      0.000000000000000_REALK, &
      1.572696333104491_REALK,      0.000000000000000_REALK,      2.167342456354639_REALK, &
     -0.080016751862385_REALK,      0.000000000000000_REALK,      0.568446071254642_REALK, &
      0.000000000000000_REALK,     -1.703459092492459_REALK,      0.000000000000000_REALK, &
      0.373267262020197_REALK,      0.000000000000000_REALK,     -9.761003013017996_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.130001658179122_REALK, &
      0.000000000000000_REALK,     -2.393132018446517_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.261301651518068_REALK,      0.000000000000000_REALK, &
     -5.482827593173709_REALK,      0.000000000000000_REALK,     -3.329823280676297_REALK, &
      0.000000000000000_REALK,     -4.245256338941361_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,    -21.239640286246281_REALK, &
      0.000000000000000_REALK,    -11.286312777754540_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -10.073045849854312_REALK,      0.000000000000000_REALK, &
     -3.929790240727872_REALK,      0.000000000000000_REALK,    -12.958545746351662_REALK, &
      0.000000000000000_REALK,     -3.042767011483401_REALK,      0.000000000000000_REALK/
    ! results of test 5, ket-major order, XDIPVEL
  data REF_CONTR_INTS(28981:30240)                                                         &
    /21.578818408654001_REALK,      9.032095652812361_REALK,      0.000000000000000_REALK, &
     -4.187608634636775_REALK,      0.000000000000000_REALK,     -0.658178251315764_REALK, &
    -28.782908284490571_REALK,      0.000000000000000_REALK,     -3.441933909463378_REALK, &
      0.000000000000000_REALK,   -136.359522158011004_REALK,      0.000000000000000_REALK, &
    -13.570707440151212_REALK,      0.000000000000000_REALK,     -6.398839006729168_REALK, &
     64.808457510703192_REALK,     45.480441173591899_REALK,      0.000000000000000_REALK, &
     32.960848851312441_REALK,      0.000000000000000_REALK,      3.973738380387094_REALK, &
     10.655557405207052_REALK,      0.000000000000000_REALK,      1.035055744568994_REALK, &
      0.000000000000000_REALK,   -105.269570561925377_REALK,      0.000000000000000_REALK, &
     -8.733490003821924_REALK,      0.000000000000000_REALK,     -3.158711528893073_REALK, &
      8.508323327151508_REALK,      0.220472395407811_REALK,      0.000000000000000_REALK, &
     -5.300880331640139_REALK,      0.000000000000000_REALK,     -1.344832172987215_REALK, &
    -11.992504208685881_REALK,      0.000000000000000_REALK,     -2.290401675073462_REALK, &
      0.000000000000000_REALK,    -29.572719588095826_REALK,      0.000000000000000_REALK, &
     -4.972234971224447_REALK,      0.000000000000000_REALK,     -3.784364752233052_REALK, &
     10.098804464972780_REALK,      5.498957920893442_REALK,      0.000000000000000_REALK, &
      1.764399924760265_REALK,      0.000000000000000_REALK,      0.718828438607779_REALK, &
     -0.102552090883603_REALK,      0.000000000000000_REALK,     -0.184360737382806_REALK, &
      0.000000000000000_REALK,      8.303477408882667_REALK,      0.000000000000000_REALK, &
     -1.005788431633407_REALK,      0.000000000000000_REALK,     -1.229294987607263_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.064270735907159_REALK, &
      0.000000000000000_REALK,      1.627755602940450_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.248085643578535_REALK,      0.000000000000000_REALK, &
      2.003050779772291_REALK,      0.000000000000000_REALK,     12.768062194840100_REALK, &
      0.000000000000000_REALK,      4.580512760439631_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.670564876385116_REALK, &
      0.000000000000000_REALK,     -2.099022408966304_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.020751581160469_REALK,      0.000000000000000_REALK, &
      0.369183429091510_REALK,      0.000000000000000_REALK,     12.317969197018224_REALK, &
      0.000000000000000_REALK,      3.589615529423321_REALK,      0.000000000000000_REALK, &
      1.369876512200395_REALK,     -3.456468018839264_REALK,      0.000000000000000_REALK, &
     -6.006565788410715_REALK,      0.000000000000000_REALK,     -2.009593402215801_REALK, &
     -8.983417083846371_REALK,      0.000000000000000_REALK,     -2.011702055450537_REALK, &
      0.000000000000000_REALK,    -16.862466066519488_REALK,      0.000000000000000_REALK, &
     -3.015409628560151_REALK,      0.000000000000000_REALK,     -3.026561686658477_REALK, &
     26.952817417941258_REALK,      9.555765959400826_REALK,      0.000000000000000_REALK, &
      3.287746977763454_REALK,      0.000000000000000_REALK,      0.824571445329534_REALK, &
     -1.935969132495210_REALK,      0.000000000000000_REALK,     -0.281227626589949_REALK, &
      0.000000000000000_REALK,    -14.928644872839630_REALK,      0.000000000000000_REALK, &
     -1.392577297817659_REALK,      0.000000000000000_REALK,     -1.047780881218305_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.949384005649439_REALK, &
      0.000000000000000_REALK,      1.479222644921078_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.177975235294354_REALK,      0.000000000000000_REALK, &
      1.657655512940236_REALK,      0.000000000000000_REALK,      3.888229157543608_REALK, &
      0.000000000000000_REALK,      2.227793233307496_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.795568533439717_REALK, &
      0.000000000000000_REALK,     -0.665754186545394_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.201945602592212_REALK,      0.000000000000000_REALK, &
      0.246822004735901_REALK,      0.000000000000000_REALK,      0.156859531214041_REALK, &
      0.000000000000000_REALK,      0.845972186163362_REALK,      0.000000000000000_REALK, &
      0.293944827100113_REALK,     -1.149113744881096_REALK,      0.000000000000000_REALK, &
     -2.743564393063916_REALK,      0.000000000000000_REALK,     -1.293641244071724_REALK, &
     -5.592761288232476_REALK,      0.000000000000000_REALK,     -2.006390167585056_REALK, &
      0.000000000000000_REALK,    -13.839430516990362_REALK,      0.000000000000000_REALK, &
     -4.131963643875451_REALK,      0.000000000000000_REALK,     -3.247161856449543_REALK, &
     14.525874659010467_REALK,      8.163228779395611_REALK,      0.000000000000000_REALK, &
      3.686086572594665_REALK,      0.000000000000000_REALK,      1.333176559228605_REALK, &
     -2.473243511226650_REALK,      0.000000000000000_REALK,     -0.720735145050835_REALK, &
      0.000000000000000_REALK,    -18.819213897809604_REALK,      0.000000000000000_REALK, &
     -4.683901024169830_REALK,      0.000000000000000_REALK,     -2.823440220493131_REALK, &
     -9.464638014202675_REALK,     -7.201453989309058_REALK,      0.000000000000000_REALK, &
     -6.839419708690412_REALK,      0.000000000000000_REALK,     -3.134804604371979_REALK, &
     -6.920217000664946_REALK,      0.000000000000000_REALK,     -2.002985662924623_REALK, &
      0.000000000000000_REALK,     -8.778717002774494_REALK,      0.000000000000000_REALK, &
     -2.135021608810140_REALK,      0.000000000000000_REALK,     -2.935720801529766_REALK, &
      4.187306267328455_REALK,      0.490327132926316_REALK,      0.000000000000000_REALK, &
     -0.624127389316744_REALK,      0.000000000000000_REALK,     -0.439830240897166_REALK, &
      0.052115780614889_REALK,      0.000000000000000_REALK,     -0.532870754674208_REALK, &
      0.000000000000000_REALK,      5.243412599072212_REALK,      0.000000000000000_REALK, &
     -0.518374460519636_REALK,      0.000000000000000_REALK,     -1.095914557258352_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.161504277434768_REALK, &
      0.000000000000000_REALK,      1.713586811390694_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.796932616172347_REALK,      0.000000000000000_REALK, &
      1.803578312579406_REALK,      0.000000000000000_REALK,      2.388729837657292_REALK, &
      0.000000000000000_REALK,      1.604761087951301_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.223813367502444_REALK, &
      0.000000000000000_REALK,      0.389941356293375_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.969822101585396_REALK,      0.000000000000000_REALK, &
      0.729698134399135_REALK,      0.000000000000000_REALK,      2.229513464751976_REALK, &
      0.000000000000000_REALK,      0.971607609261430_REALK,      0.000000000000000_REALK, &
     -1.421048862931805_REALK,     -1.591041287630547_REALK,      0.000000000000000_REALK, &
     -1.855219876434487_REALK,      0.000000000000000_REALK,     -1.412006622505192_REALK, &
     -2.317060251505085_REALK,      0.000000000000000_REALK,     -1.327578941548252_REALK, &
      0.000000000000000_REALK,     -3.444435284931249_REALK,      0.000000000000000_REALK, &
     -1.737399382106410_REALK,      0.000000000000000_REALK,     -2.203889203495630_REALK, &
      1.086059397349913_REALK,      0.180705610488399_REALK,      0.000000000000000_REALK, &
     -0.280011402603447_REALK,      0.000000000000000_REALK,     -0.342235606283805_REALK, &
     -0.109240499937850_REALK,      0.000000000000000_REALK,     -0.589154027394729_REALK, &
      0.000000000000000_REALK,      1.919992110021930_REALK,      0.000000000000000_REALK, &
     -0.697697756492359_REALK,      0.000000000000000_REALK,     -1.421233876406156_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.391431261390454_REALK, &
      0.000000000000000_REALK,      1.709062095136012_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.462305674888850_REALK,      0.000000000000000_REALK, &
      1.935037612992931_REALK,      0.000000000000000_REALK,      4.461418958756212_REALK, &
      0.000000000000000_REALK,      2.667539542336693_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.361864016618995_REALK, &
      0.000000000000000_REALK,      0.999348618047431_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.261973853801230_REALK,      0.000000000000000_REALK, &
      1.966307172054675_REALK,      0.000000000000000_REALK,      8.544758721617551_REALK, &
      0.000000000000000_REALK,      4.150088664739545_REALK,      0.000000000000000_REALK, &
    -29.453493680452237_REALK,    -12.753584720675677_REALK,      0.000000000000000_REALK, &
     -9.086786158663662_REALK,      0.000000000000000_REALK,     -5.452846868867733_REALK, &
     -6.957783297081264_REALK,      0.000000000000000_REALK,     -2.340612920101810_REALK, &
      0.000000000000000_REALK,     -7.155501404700518_REALK,      0.000000000000000_REALK, &
     -1.923422497622227_REALK,      0.000000000000000_REALK,     -3.462652744502863_REALK, &
     45.648056370814068_REALK,      7.655174867030909_REALK,      0.000000000000000_REALK, &
      0.356949419183347_REALK,      0.000000000000000_REALK,      0.168805677839537_REALK, &
     -3.413349996667938_REALK,      0.000000000000000_REALK,     -0.664121125729280_REALK, &
      0.000000000000000_REALK,    -10.259719829601947_REALK,      0.000000000000000_REALK, &
     -1.000743179806741_REALK,      0.000000000000000_REALK,     -1.419790494662208_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.292509041526632_REALK, &
      0.000000000000000_REALK,      2.207121170118241_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.718768258264154_REALK,      0.000000000000000_REALK, &
      2.363359559441288_REALK,      0.000000000000000_REALK,      1.614107414580956_REALK, &
      0.000000000000000_REALK,      1.401560388719890_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.820565145130512_REALK, &
      0.000000000000000_REALK,     -0.077405973370909_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.347229383970300_REALK,      0.000000000000000_REALK, &
      0.734090441530322_REALK,      0.000000000000000_REALK,     -0.021224516081830_REALK, &
      0.000000000000000_REALK,      0.651046023028685_REALK,      0.000000000000000_REALK, &
     -3.578290542501679_REALK,     -2.346425953016919_REALK,      0.000000000000000_REALK, &
     -1.980068101255898_REALK,      0.000000000000000_REALK,     -1.987391097871250_REALK, &
     -1.923012397435151_REALK,      0.000000000000000_REALK,     -1.291889697362508_REALK, &
      0.000000000000000_REALK,     -2.343793160296257_REALK,      0.000000000000000_REALK, &
     -1.257377734970209_REALK,      0.000000000000000_REALK,     -2.103379942299570_REALK, &
      9.554540642541825_REALK,      2.500635235909484_REALK,      0.000000000000000_REALK, &
      0.140878483405858_REALK,      0.000000000000000_REALK,      0.105997549808554_REALK, &
     -1.493423472567074_REALK,      0.000000000000000_REALK,     -0.650824331288449_REALK, &
      0.000000000000000_REALK,     -4.234105774856399_REALK,      0.000000000000000_REALK, &
     -1.184900497435862_REALK,      0.000000000000000_REALK,     -1.485873338718749_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.933470170787017_REALK, &
      0.000000000000000_REALK,      1.462879960216960_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.398668237159656_REALK,      0.000000000000000_REALK, &
      1.774209119040448_REALK,      0.000000000000000_REALK,      1.621329561613085_REALK, &
      0.000000000000000_REALK,      1.548257094241892_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.194705440302818_REALK, &
      0.000000000000000_REALK,     -0.085581804885805_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.467347797075982_REALK,      0.000000000000000_REALK, &
      0.952003235050462_REALK,      0.000000000000000_REALK,      0.133466872434545_REALK, &
      0.000000000000000_REALK,      1.199685486965720_REALK,      0.000000000000000_REALK, &
     -2.303463090567446_REALK,     -2.340230228598728_REALK,      0.000000000000000_REALK, &
     -2.713253061639104_REALK,      0.000000000000000_REALK,     -2.132248153177364_REALK, &
     -3.591600788247569_REALK,      0.000000000000000_REALK,     -2.147464116575372_REALK, &
      0.000000000000000_REALK,     -5.770821858468377_REALK,      0.000000000000000_REALK, &
     -2.871604926854870_REALK,      0.000000000000000_REALK,     -3.159367677093602_REALK, &
     15.447890769177887_REALK,      6.408672296268860_REALK,      0.000000000000000_REALK, &
      0.473841469153831_REALK,      0.000000000000000_REALK,      0.285630088091711_REALK, &
     -5.723644841815511_REALK,      0.000000000000000_REALK,     -2.779906882439962_REALK, &
      0.000000000000000_REALK,    -16.012680907416499_REALK,      0.000000000000000_REALK, &
     -6.642308308698128_REALK,      0.000000000000000_REALK,     -5.605546418356514_REALK, &
   -138.084338924072114_REALK,    -32.033262444902739_REALK,      0.000000000000000_REALK, &
    -16.718653264862141_REALK,      0.000000000000000_REALK,    -13.177002638293777_REALK, &
     -8.672179326534662_REALK,      0.000000000000000_REALK,     -3.502803187230817_REALK, &
      0.000000000000000_REALK,     -6.507102555710486_REALK,      0.000000000000000_REALK, &
     -2.222080261104156_REALK,      0.000000000000000_REALK,     -5.254075851541640_REALK, &
    -61.946088390955737_REALK,    -19.070599296124005_REALK,      0.000000000000000_REALK, &
     -7.851647939885066_REALK,      0.000000000000000_REALK,     -9.679137205184293_REALK, &
      1.842006629130886_REALK,      0.000000000000000_REALK,     -2.548374632687145_REALK, &
      0.000000000000000_REALK,     13.287474007284651_REALK,      0.000000000000000_REALK, &
     -1.071526153189115_REALK,      0.000000000000000_REALK,     -3.962779050360447_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     12.775980185906937_REALK, &
      0.000000000000000_REALK,      4.011546841359845_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.328068743605272_REALK,      0.000000000000000_REALK, &
      4.191119545706496_REALK,      0.000000000000000_REALK,      1.584935593699231_REALK, &
      0.000000000000000_REALK,      1.599526991462002_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     10.341794454862704_REALK, &
      0.000000000000000_REALK,      4.170270475731821_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.922230461698117_REALK,      0.000000000000000_REALK, &
      4.145873902965362_REALK,      0.000000000000000_REALK,      2.925093195468961_REALK, &
      0.000000000000000_REALK,      1.707369171987277_REALK,      0.000000000000000_REALK, &
    -14.148767399582258_REALK,     -5.171268699717150_REALK,      0.000000000000000_REALK, &
     -2.945775150711046_REALK,      0.000000000000000_REALK,     -4.050532018451777_REALK, &
     -1.953680496798206_REALK,      0.000000000000000_REALK,     -1.696418201038892_REALK, &
      0.000000000000000_REALK,     -1.609855216048441_REALK,      0.000000000000000_REALK, &
     -1.174571069633361_REALK,      0.000000000000000_REALK,     -2.691785965825606_REALK, &
     -9.833825198940085_REALK,     -4.742237799260907_REALK,      0.000000000000000_REALK, &
     -2.180386065400012_REALK,      0.000000000000000_REALK,     -4.609634562474008_REALK, &
      0.061976867472734_REALK,      0.000000000000000_REALK,     -1.901093666038511_REALK, &
      0.000000000000000_REALK,      3.009856512721772_REALK,      0.000000000000000_REALK, &
     -0.892681655244755_REALK,      0.000000000000000_REALK,     -3.145418661249644_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.656442753420520_REALK, &
      0.000000000000000_REALK,      2.214153391332418_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.521902653893294_REALK,      0.000000000000000_REALK, &
      2.545885319344774_REALK,      0.000000000000000_REALK,      1.314147336450567_REALK, &
      0.000000000000000_REALK,      1.471418321796615_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.493886265372918_REALK, &
      0.000000000000000_REALK,      4.086774819397171_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.459980939722214_REALK,      0.000000000000000_REALK, &
      4.338839794509047_REALK,      0.000000000000000_REALK,      3.839397813137192_REALK, &
      0.000000000000000_REALK,      2.788641400319136_REALK,      0.000000000000000_REALK, &
     -6.373013884384700_REALK,     -3.427517008188618_REALK,      0.000000000000000_REALK, &
     -2.397159778407148_REALK,      0.000000000000000_REALK,     -3.040794539871617_REALK, &
     -1.962422026435094_REALK,      0.000000000000000_REALK,     -1.873976701751987_REALK, &
      0.000000000000000_REALK,     -1.894938215243311_REALK,      0.000000000000000_REALK, &
     -1.593035438298881_REALK,      0.000000000000000_REALK,     -2.829069179588857_REALK, &
     -7.651782019770401_REALK,     -5.243125980907410_REALK,      0.000000000000000_REALK, &
     -2.934655508668070_REALK,      0.000000000000000_REALK,     -5.977992312129044_REALK, &
     -0.389731319808868_REALK,      0.000000000000000_REALK,     -3.503154001154802_REALK, &
      0.000000000000000_REALK,      3.306377658176163_REALK,      0.000000000000000_REALK, &
     -2.002484161423298_REALK,      0.000000000000000_REALK,     -5.710778945435564_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.995841770646915_REALK, &
      0.000000000000000_REALK,      3.680511553105002_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.475728126533934_REALK,      0.000000000000000_REALK, &
      3.824029898626579_REALK,      0.000000000000000_REALK,      4.090710851859765_REALK, &
      0.000000000000000_REALK,      3.424243783484856_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     17.498982848057629_REALK, &
      0.000000000000000_REALK,     17.456098214603056_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     19.395941003981260_REALK,      0.000000000000000_REALK, &
     16.368533734446775_REALK,      0.000000000000000_REALK,     24.524579366925529_REALK, &
      0.000000000000000_REALK,     16.675819062388008_REALK,      0.000000000000000_REALK, &
     22.592722061535262_REALK,     38.809554618550386_REALK,      0.000000000000000_REALK, &
      8.763371249755906_REALK,      0.000000000000000_REALK,      3.951375565084180_REALK, &
     64.923703440059583_REALK,      0.000000000000000_REALK,     15.392778807195397_REALK, &
      0.000000000000000_REALK,    -48.113979618687054_REALK,      0.000000000000000_REALK, &
     -9.050770614091331_REALK,      0.000000000000000_REALK,    -12.242889008279279_REALK, &
     25.573011644088101_REALK,     38.774142367498897_REALK,      0.000000000000000_REALK, &
     14.781545942541815_REALK,      0.000000000000000_REALK,      4.888877013195698_REALK, &
     85.699483336386422_REALK,      0.000000000000000_REALK,     17.059697737964736_REALK, &
      0.000000000000000_REALK,    -30.425795593312781_REALK,      0.000000000000000_REALK, &
     -4.782410039544084_REALK,      0.000000000000000_REALK,     -4.745230559960544_REALK, &
     23.630258070772019_REALK,     13.716096563614354_REALK,      0.000000000000000_REALK, &
      3.728979751139395_REALK,      0.000000000000000_REALK,      2.920375574195569_REALK, &
     11.742531315092291_REALK,      0.000000000000000_REALK,      4.374088827933973_REALK, &
      0.000000000000000_REALK,    -17.990621398365384_REALK,      0.000000000000000_REALK, &
     -5.962649981498847_REALK,      0.000000000000000_REALK,    -14.009068318051016_REALK, &
      7.983155504234931_REALK,      6.464357313669902_REALK,      0.000000000000000_REALK, &
      2.259752572980420_REALK,      0.000000000000000_REALK,      2.998926624559054_REALK, &
     -0.397245417677865_REALK,      0.000000000000000_REALK,      2.717625027827931_REALK, &
      0.000000000000000_REALK,      5.006937656168573_REALK,      0.000000000000000_REALK, &
     -1.056532016643789_REALK,      0.000000000000000_REALK,     -4.206383520430999_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.634411430571372_REALK, &
      0.000000000000000_REALK,     -1.373918486765968_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -6.106786037154156_REALK,      0.000000000000000_REALK, &
     -8.260589825775199_REALK,      0.000000000000000_REALK,      9.266090018754426_REALK, &
      0.000000000000000_REALK,      6.590699536938661_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -8.257614085369646_REALK, &
      0.000000000000000_REALK,     -3.403759102534973_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,    -10.496137410835974_REALK,      0.000000000000000_REALK, &
    -10.414538191332534_REALK,      0.000000000000000_REALK,      7.994429187379834_REALK, &
      0.000000000000000_REALK,      4.774213573339858_REALK,      0.000000000000000_REALK, &
     22.963938133244866_REALK,      5.052467687275590_REALK,      0.000000000000000_REALK, &
      1.363940221900322_REALK,      0.000000000000000_REALK,      1.461928925234951_REALK, &
      2.304710481094863_REALK,      0.000000000000000_REALK,      1.009301312809935_REALK, &
      0.000000000000000_REALK,    -12.656900838845139_REALK,      0.000000000000000_REALK, &
     -4.820047339746552_REALK,      0.000000000000000_REALK,    -15.498992948150407_REALK, &
     26.941104735571443_REALK,      5.373618970688037_REALK,      0.000000000000000_REALK, &
      3.747086925768969_REALK,      0.000000000000000_REALK,      3.646842944728830_REALK, &
      4.311118477504801_REALK,      0.000000000000000_REALK,      1.189445223008329_REALK, &
      0.000000000000000_REALK,     -8.685961798304916_REALK,      0.000000000000000_REALK, &
     -1.629042065635323_REALK,      0.000000000000000_REALK,     -4.756383303685560_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.770987976158125_REALK, &
      0.000000000000000_REALK,     -0.357163518070453_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.216961763913202_REALK,      0.000000000000000_REALK, &
     -2.859215373032915_REALK,      0.000000000000000_REALK,      3.388419620062888_REALK, &
      0.000000000000000_REALK,      3.786555387445317_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -5.854709678829733_REALK, &
      0.000000000000000_REALK,     -1.110506376288316_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.976512916001543_REALK,      0.000000000000000_REALK, &
     -3.887802520557017_REALK,      0.000000000000000_REALK,     -0.070571435266337_REALK, &
      0.000000000000000_REALK,      1.448374406813633_REALK,      0.000000000000000_REALK, &
      3.531745547666734_REALK,      2.244556706507651_REALK,      0.000000000000000_REALK, &
      0.498645837095109_REALK,      0.000000000000000_REALK,      0.674513353425524_REALK, &
      1.891185511272843_REALK,      0.000000000000000_REALK,      1.345145087969533_REALK, &
      0.000000000000000_REALK,     -9.367719680679068_REALK,      0.000000000000000_REALK, &
     -5.286514398447639_REALK,      0.000000000000000_REALK,    -11.918360653198119_REALK, &
     10.479694564628556_REALK,      6.645051332306746_REALK,      0.000000000000000_REALK, &
      4.289049225620284_REALK,      0.000000000000000_REALK,      4.255705238635021_REALK, &
      7.388951053594198_REALK,      0.000000000000000_REALK,      4.412626541054531_REALK, &
      0.000000000000000_REALK,    -11.863004507643980_REALK,      0.000000000000000_REALK, &
     -5.593978801558374_REALK,      0.000000000000000_REALK,     -9.250816687763846_REALK, &
     18.030917141007329_REALK,      0.863262874057076_REALK,      0.000000000000000_REALK, &
     -0.875759042581793_REALK,      0.000000000000000_REALK,     -1.145142854528215_REALK, &
     -0.080576994101268_REALK,      0.000000000000000_REALK,     -0.055449864665222_REALK, &
      0.000000000000000_REALK,     -9.969655575544655_REALK,      0.000000000000000_REALK, &
     -4.642864659453556_REALK,      0.000000000000000_REALK,    -18.213034741750590_REALK, &
     11.987955223356387_REALK,      0.543859594964662_REALK,      0.000000000000000_REALK, &
      1.113153320074508_REALK,      0.000000000000000_REALK,      2.199888313488222_REALK, &
     -0.550757751676060_REALK,      0.000000000000000_REALK,      0.082130899419076_REALK, &
      0.000000000000000_REALK,      2.869051228409991_REALK,      0.000000000000000_REALK, &
     -1.042619518446977_REALK,      0.000000000000000_REALK,     -6.181484040022538_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.243705157389139_REALK, &
      0.000000000000000_REALK,      0.142635012475388_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.134459747270149_REALK,      0.000000000000000_REALK, &
      0.432358964105050_REALK,      0.000000000000000_REALK,      1.726724602586625_REALK, &
      0.000000000000000_REALK,      2.268552283526704_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.202375547370996_REALK, &
      0.000000000000000_REALK,     -0.441744113324230_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.496899720627670_REALK,      0.000000000000000_REALK, &
     -1.450819217413965_REALK,      0.000000000000000_REALK,      1.499640454634223_REALK, &
      0.000000000000000_REALK,      1.241260371967633_REALK,      0.000000000000000_REALK, &
      2.120748028355787_REALK,      0.548159088785479_REALK,      0.000000000000000_REALK, &
     -0.171981700781278_REALK,      0.000000000000000_REALK,     -0.404065877281951_REALK, &
     -0.094523147522204_REALK,      0.000000000000000_REALK,     -0.105629518660929_REALK, &
      0.000000000000000_REALK,     -2.750999308808342_REALK,      0.000000000000000_REALK, &
     -2.735299512099085_REALK,      0.000000000000000_REALK,    -10.710841056192979_REALK, &
      2.622730979553922_REALK,      0.975160849678354_REALK,      0.000000000000000_REALK, &
      0.362663890597457_REALK,      0.000000000000000_REALK,      1.443878073577452_REALK, &
     -0.021526102491688_REALK,      0.000000000000000_REALK,      0.441791438841256_REALK, &
      0.000000000000000_REALK,      1.609773236902514_REALK,      0.000000000000000_REALK, &
     -1.019052211821600_REALK,      0.000000000000000_REALK,     -6.761941210707204_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.035213862784380_REALK, &
      0.000000000000000_REALK,      0.190096638108576_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.147472283953263_REALK,      0.000000000000000_REALK, &
      0.332473863501052_REALK,      0.000000000000000_REALK,      4.250715971255789_REALK, &
      0.000000000000000_REALK,      5.039017127092977_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -3.737031344528276_REALK, &
      0.000000000000000_REALK,     -1.638790724535493_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.706307382926547_REALK,      0.000000000000000_REALK, &
     -2.821736973338946_REALK,      0.000000000000000_REALK,      7.710831870036225_REALK, &
      0.000000000000000_REALK,      7.674752279120920_REALK,      0.000000000000000_REALK, &
      1.359446316058182_REALK,      0.451568229273068_REALK,      0.000000000000000_REALK, &
     -5.070083304173500_REALK,      0.000000000000000_REALK,     -6.862784160812630_REALK, &
      1.367996282162825_REALK,      0.000000000000000_REALK,      0.448271751989611_REALK, &
      0.000000000000000_REALK,    -13.160721763372875_REALK,      0.000000000000000_REALK, &
     -5.855419711430151_REALK,      0.000000000000000_REALK,    -23.777409111267200_REALK, &
     69.318115933764943_REALK,     -2.297412483287417_REALK,      0.000000000000000_REALK, &
      2.921613659487305_REALK,      0.000000000000000_REALK,      4.072293502821906_REALK, &
      0.000722373425234_REALK,      0.000000000000000_REALK,     -0.008774670716862_REALK, &
      0.000000000000000_REALK,     -9.144272535269410_REALK,      0.000000000000000_REALK, &
     -2.222137862287664_REALK,      0.000000000000000_REALK,     -9.291985834181029_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.359785383279578_REALK, &
      0.000000000000000_REALK,      0.259005609833998_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.032317583742385_REALK,      0.000000000000000_REALK, &
      4.049576586071097_REALK,      0.000000000000000_REALK,      0.434673013008501_REALK, &
      0.000000000000000_REALK,      0.897373748441914_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -7.605511793880448_REALK, &
      0.000000000000000_REALK,     -0.119388788268182_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.014698555237859_REALK,      0.000000000000000_REALK, &
     -0.087144814581598_REALK,      0.000000000000000_REALK,     -0.608927793021711_REALK, &
      0.000000000000000_REALK,      0.272416251082898_REALK,      0.000000000000000_REALK, &
      0.133350182666363_REALK,     -0.169370139577773_REALK,      0.000000000000000_REALK, &
     -0.628059762635864_REALK,      0.000000000000000_REALK,     -2.019543200715146_REALK, &
     -0.383928522642000_REALK,      0.000000000000000_REALK,     -0.504401179809360_REALK, &
      0.000000000000000_REALK,     -1.904671046423478_REALK,      0.000000000000000_REALK, &
     -2.176031414158594_REALK,      0.000000000000000_REALK,    -11.661813382650031_REALK, &
     11.966211897576148_REALK,      1.527209378387692_REALK,      0.000000000000000_REALK, &
      0.722313477097475_REALK,      0.000000000000000_REALK,      2.108969335395040_REALK, &
      0.021141507203129_REALK,      0.000000000000000_REALK,      0.017498937837945_REALK, &
      0.000000000000000_REALK,     -2.929270966050010_REALK,      0.000000000000000_REALK, &
     -1.648144121335280_REALK,      0.000000000000000_REALK,     -8.020260644946735_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.479802909861757_REALK, &
      0.000000000000000_REALK,      0.493394132923912_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.608180076365652_REALK,      0.000000000000000_REALK, &
      2.381501587918186_REALK,      0.000000000000000_REALK,      1.529716830124717_REALK, &
      0.000000000000000_REALK,      2.849094934050218_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -4.991813288969264_REALK, &
      0.000000000000000_REALK,     -0.642205855817811_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.014366310011186_REALK,      0.000000000000000_REALK, &
     -0.095327935687204_REALK,      0.000000000000000_REALK,     -0.071398951949744_REALK, &
      0.000000000000000_REALK,      2.442263272834707_REALK,      0.000000000000000_REALK, &
      0.061525890443504_REALK,     -0.225727845996231_REALK,      0.000000000000000_REALK, &
     -0.688841155330787_REALK,      0.000000000000000_REALK,     -1.552981171186969_REALK, &
     -0.945125297091559_REALK,      0.000000000000000_REALK,     -1.120400090596083_REALK, &
      0.000000000000000_REALK,     -4.229097946009224_REALK,      0.000000000000000_REALK, &
     -3.977700007066967_REALK,      0.000000000000000_REALK,    -12.554723879258407_REALK, &
     13.964042716108288_REALK,      5.665670437329368_REALK,      0.000000000000000_REALK, &
      2.480357238281239_REALK,      0.000000000000000_REALK,      4.101790683424793_REALK, &
      0.108705127964989_REALK,      0.000000000000000_REALK,      0.108196488091435_REALK, &
      0.000000000000000_REALK,    -12.002109431730441_REALK,      0.000000000000000_REALK, &
     -9.432622470951920_REALK,      0.000000000000000_REALK,    -21.838346236687421_REALK, &
   -118.979834224311460_REALK,     15.378512926367295_REALK,      0.000000000000000_REALK, &
    -20.306664148908684_REALK,      0.000000000000000_REALK,    -25.260440382456654_REALK, &
     10.113074909004215_REALK,      0.000000000000000_REALK,      4.039750446819079_REALK, &
      0.000000000000000_REALK,    -24.142914915235593_REALK,      0.000000000000000_REALK, &
     -9.714245412538858_REALK,      0.000000000000000_REALK,    -36.252057251438565_REALK, &
    -45.883289804433495_REALK,     10.683552392224041_REALK,      0.000000000000000_REALK, &
    -11.593422678170354_REALK,      0.000000000000000_REALK,    -16.945683372393951_REALK, &
     10.288695181613646_REALK,      0.000000000000000_REALK,      3.615159842414137_REALK, &
      0.000000000000000_REALK,     -4.380343975043946_REALK,      0.000000000000000_REALK, &
     -5.506875649427108_REALK,      0.000000000000000_REALK,    -24.147598267606316_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     14.194671285559910_REALK, &
      0.000000000000000_REALK,     -0.711119768644262_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.754737938637816_REALK,      0.000000000000000_REALK, &
     11.186308444031612_REALK,      0.000000000000000_REALK,     -1.038142047130074_REALK, &
      0.000000000000000_REALK,     -1.020550480324381_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     10.388873070279383_REALK, &
      0.000000000000000_REALK,     -0.705255036607761_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.522109715492407_REALK,      0.000000000000000_REALK, &
     10.546333846487514_REALK,      0.000000000000000_REALK,      0.027578505591138_REALK, &
      0.000000000000000_REALK,     -1.004988404772980_REALK,      0.000000000000000_REALK, &
    -10.086074769757257_REALK,     -0.535715448214570_REALK,      0.000000000000000_REALK, &
     -1.637625922356361_REALK,      0.000000000000000_REALK,     -6.424080821985053_REALK, &
     -0.204496056448200_REALK,      0.000000000000000_REALK,     -0.422178021695868_REALK, &
      0.000000000000000_REALK,     -1.682206550935612_REALK,      0.000000000000000_REALK, &
     -2.350208776840375_REALK,      0.000000000000000_REALK,    -15.365669416978298_REALK, &
     -6.321659872327319_REALK,     -0.304574060409232_REALK,      0.000000000000000_REALK, &
     -1.181381096436745_REALK,      0.000000000000000_REALK,     -7.004173875131080_REALK, &
      0.691128452864008_REALK,      0.000000000000000_REALK,     -0.309190390557889_REALK, &
      0.000000000000000_REALK,      1.544173407909959_REALK,      0.000000000000000_REALK, &
     -1.683468024911447_REALK,      0.000000000000000_REALK,    -16.634912582778380_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.177131497859110_REALK, &
      0.000000000000000_REALK,      0.800161171650713_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.023734691562577_REALK,      0.000000000000000_REALK, &
      5.486411109999466_REALK,      0.000000000000000_REALK,      0.874064529949689_REALK, &
      0.000000000000000_REALK,      1.913894358522050_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.380215035912338_REALK, &
      0.000000000000000_REALK,      1.406458936605049_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.870631148272696_REALK,      0.000000000000000_REALK, &
      9.102935347394293_REALK,      0.000000000000000_REALK,      2.421397940066253_REALK, &
      0.000000000000000_REALK,      3.340339900007775_REALK,      0.000000000000000_REALK, &
     -3.558891044953816_REALK,     -1.020514031472830_REALK,      0.000000000000000_REALK, &
     -0.964791721270930_REALK,      0.000000000000000_REALK,     -3.777915629770872_REALK, &
     -0.719669843494123_REALK,      0.000000000000000_REALK,     -1.340383831117717_REALK, &
      0.000000000000000_REALK,     -1.392550331502475_REALK,      0.000000000000000_REALK, &
     -2.307671876504463_REALK,      0.000000000000000_REALK,    -12.650881264613320_REALK, &
     -4.149167947437581_REALK,     -1.638338473505936_REALK,      0.000000000000000_REALK, &
     -1.154677231749250_REALK,      0.000000000000000_REALK,     -7.661883726716690_REALK, &
      0.081037272009324_REALK,      0.000000000000000_REALK,     -2.771950396392333_REALK, &
      0.000000000000000_REALK,      2.599224092524410_REALK,      0.000000000000000_REALK, &
     -2.742358364299434_REALK,      0.000000000000000_REALK,    -25.475762823683862_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.212115771254651_REALK, &
      0.000000000000000_REALK,      1.777356368491767_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.871346830458201_REALK,      0.000000000000000_REALK, &
      5.906489352386338_REALK,      0.000000000000000_REALK,      3.586173162568094_REALK, &
      0.000000000000000_REALK,      5.951727509610205_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     10.464123654502290_REALK, &
      0.000000000000000_REALK,      8.696180247894883_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     10.705955368614354_REALK,      0.000000000000000_REALK, &
     24.786358285229682_REALK,      0.000000000000000_REALK,     20.750520953878652_REALK, &
      0.000000000000000_REALK,     28.914798679973003_REALK,      0.000000000000000_REALK/
    ! results of test 5, ket-major order, YDIPVEL
  data REF_CONTR_INTS(30241:31500)                                                         &
   /-58.548788719033148_REALK,    -41.883399814949165_REALK,      0.000000000000000_REALK, &
    -40.171303901448383_REALK,      0.000000000000000_REALK,    -10.191450954864177_REALK, &
    -46.370332746342470_REALK,      0.000000000000000_REALK,     -8.856089266077861_REALK, &
      0.000000000000000_REALK,    -71.585593920407220_REALK,      0.000000000000000_REALK, &
    -12.036106198031272_REALK,      0.000000000000000_REALK,     -9.160672476978005_REALK, &
    -20.842584358697390_REALK,    -18.728381504507681_REALK,      0.000000000000000_REALK, &
    -13.842741340714607_REALK,      0.000000000000000_REALK,     -5.639626257266616_REALK, &
     -2.562147394806922_REALK,      0.000000000000000_REALK,     -4.606043415791206_REALK, &
      0.000000000000000_REALK,     34.503486431951522_REALK,      0.000000000000000_REALK, &
     -4.179358333311439_REALK,      0.000000000000000_REALK,     -5.108096383859572_REALK, &
    -33.176698866965225_REALK,    -11.982970382632484_REALK,      0.000000000000000_REALK, &
     -4.105822040336164_REALK,      0.000000000000000_REALK,     -5.036418746444697_REALK, &
      3.398840413337183_REALK,      0.000000000000000_REALK,     -2.183942467000220_REALK, &
      0.000000000000000_REALK,     17.031325608052938_REALK,      0.000000000000000_REALK, &
     -1.012779554849125_REALK,      0.000000000000000_REALK,     -3.726987107049885_REALK, &
    -12.500974714007551_REALK,      3.654659718027620_REALK,      0.000000000000000_REALK, &
     11.148556440642349_REALK,      0.000000000000000_REALK,     -1.530582959720323_REALK, &
     20.131731408046583_REALK,      0.000000000000000_REALK,      0.600515074043454_REALK, &
      0.000000000000000_REALK,     36.754212096926111_REALK,      0.000000000000000_REALK, &
      2.501415099455899_REALK,      0.000000000000000_REALK,     -1.030256252493006_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.377532768527326_REALK, &
      0.000000000000000_REALK,      6.095971674346316_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      6.018285029253223_REALK,      0.000000000000000_REALK, &
      4.580512760439631_REALK,      0.000000000000000_REALK,      7.873284975640717_REALK, &
      0.000000000000000_REALK,      4.511064107063818_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.281983886630688_REALK, &
      0.000000000000000_REALK,      4.469394585246675_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.936962901421231_REALK,      0.000000000000000_REALK, &
      3.589615529423321_REALK,      0.000000000000000_REALK,      0.557817213188905_REALK, &
      0.000000000000000_REALK,      3.008410414519546_REALK,      0.000000000000000_REALK, &
    -27.612700938654850_REALK,     -5.036935743479729_REALK,      0.000000000000000_REALK, &
     -0.163286483020697_REALK,      0.000000000000000_REALK,     -3.642850568542406_REALK, &
      3.133121445405015_REALK,      0.000000000000000_REALK,     -0.785460927261611_REALK, &
      0.000000000000000_REALK,      6.347923555592708_REALK,      0.000000000000000_REALK, &
     -0.033077736690731_REALK,      0.000000000000000_REALK,     -2.213849848697874_REALK, &
     -6.745007267164154_REALK,     -0.128519724909376_REALK,      0.000000000000000_REALK, &
      1.325286855017152_REALK,      0.000000000000000_REALK,     -1.386098839196176_REALK, &
      1.448316199685685_REALK,      0.000000000000000_REALK,     -0.023455874848139_REALK, &
      0.000000000000000_REALK,      0.224624075723633_REALK,      0.000000000000000_REALK, &
      0.269485000656461_REALK,      0.000000000000000_REALK,     -0.845551689832161_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.762066440423277_REALK, &
      0.000000000000000_REALK,      1.732288346526820_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.605385362041409_REALK,      0.000000000000000_REALK, &
      2.227793233307496_REALK,      0.000000000000000_REALK,     -0.546129095785215_REALK, &
      0.000000000000000_REALK,      1.052754215881542_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.545087152658806_REALK, &
      0.000000000000000_REALK,     -0.594275595956878_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.053981807990159_REALK,      0.000000000000000_REALK, &
      0.845972186163362_REALK,      0.000000000000000_REALK,     -4.051070652720109_REALK, &
      0.000000000000000_REALK,     -0.362521575069464_REALK,      0.000000000000000_REALK, &
     -9.179929919489004_REALK,     -5.763901612165967_REALK,      0.000000000000000_REALK, &
     -4.773662850456000_REALK,      0.000000000000000_REALK,     -3.633231642281247_REALK, &
     -4.706227976870538_REALK,      0.000000000000000_REALK,     -2.696472459945803_REALK, &
      0.000000000000000_REALK,     -5.751444258757945_REALK,      0.000000000000000_REALK, &
     -2.901072273037338_REALK,      0.000000000000000_REALK,     -3.680006984551770_REALK, &
     -5.762074717451477_REALK,     -4.511747703691475_REALK,      0.000000000000000_REALK, &
     -2.906447238356998_REALK,      0.000000000000000_REALK,     -3.552318668106818_REALK, &
     -0.458039294766790_REALK,      0.000000000000000_REALK,     -2.470289822642938_REALK, &
      0.000000000000000_REALK,      4.879109029305625_REALK,      0.000000000000000_REALK, &
     -1.772998652264910_REALK,      0.000000000000000_REALK,     -3.611658091162211_REALK, &
    -28.098024036907596_REALK,      0.213448511339736_REALK,      0.000000000000000_REALK, &
      3.043525149786454_REALK,      0.000000000000000_REALK,     -3.151281175801052_REALK, &
      5.378898935859294_REALK,      0.000000000000000_REALK,      0.027996187127859_REALK, &
      0.000000000000000_REALK,      7.651687418293939_REALK,      0.000000000000000_REALK, &
      0.501737787330507_REALK,      0.000000000000000_REALK,     -1.558505450017691_REALK, &
    -13.443400589293722_REALK,      8.263101921921045_REALK,      0.000000000000000_REALK, &
      9.405029730660587_REALK,      0.000000000000000_REALK,     -1.184822557372308_REALK, &
     11.339590078214901_REALK,      0.000000000000000_REALK,      0.913642600473051_REALK, &
      0.000000000000000_REALK,     15.200616795168724_REALK,      0.000000000000000_REALK, &
      1.320169205880632_REALK,      0.000000000000000_REALK,     -0.498935027151412_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.078339474286109_REALK, &
      0.000000000000000_REALK,      0.736409487114967_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.023977174761877_REALK,      0.000000000000000_REALK, &
      1.604761087951301_REALK,      0.000000000000000_REALK,     -0.484252569206132_REALK, &
      0.000000000000000_REALK,      0.364200506107382_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.929114987736770_REALK, &
      0.000000000000000_REALK,      0.036320835506326_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.309660166691420_REALK,      0.000000000000000_REALK, &
      0.971607609261430_REALK,      0.000000000000000_REALK,     -0.314801656064485_REALK, &
      0.000000000000000_REALK,      0.015294895372098_REALK,      0.000000000000000_REALK, &
     -6.207790317055785_REALK,     -1.939376818114438_REALK,      0.000000000000000_REALK, &
     -0.567579504587295_REALK,      0.000000000000000_REALK,     -2.088669232800359_REALK, &
      0.395874509027620_REALK,      0.000000000000000_REALK,     -0.763113632939945_REALK, &
      0.000000000000000_REALK,      1.573476084396624_REALK,      0.000000000000000_REALK, &
     -0.280703530364212_REALK,      0.000000000000000_REALK,     -1.721629077722735_REALK, &
     -4.954443161303669_REALK,      1.255827871534009_REALK,      0.000000000000000_REALK, &
      3.180539453931907_REALK,      0.000000000000000_REALK,     -1.309966770180124_REALK, &
      4.655009408850949_REALK,      0.000000000000000_REALK,      0.416566751736781_REALK, &
      0.000000000000000_REALK,      6.559814566251032_REALK,      0.000000000000000_REALK, &
      1.339341936840764_REALK,      0.000000000000000_REALK,     -0.919389858535430_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.067570642039764_REALK, &
      0.000000000000000_REALK,      2.528079796624879_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.102910411852460_REALK,      0.000000000000000_REALK, &
      2.667539542336693_REALK,      0.000000000000000_REALK,      2.182171705228681_REALK, &
      0.000000000000000_REALK,      2.083822378537802_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.506787797328321_REALK, &
      0.000000000000000_REALK,      3.825182001611945_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.037319542336661_REALK,      0.000000000000000_REALK, &
      4.150088664739545_REALK,      0.000000000000000_REALK,      0.298674133244840_REALK, &
      0.000000000000000_REALK,      2.684673855391543_REALK,      0.000000000000000_REALK, &
    -34.731101028983112_REALK,      5.741573273795580_REALK,      0.000000000000000_REALK, &
      4.799503853606666_REALK,      0.000000000000000_REALK,     -3.314291928075967_REALK, &
      5.598972318981981_REALK,      0.000000000000000_REALK,      0.627834932447559_REALK, &
      0.000000000000000_REALK,      5.252490659866498_REALK,      0.000000000000000_REALK, &
      0.637903221463852_REALK,      0.000000000000000_REALK,     -1.321510032460471_REALK, &
     -9.140072498300192_REALK,      6.394433844948511_REALK,      0.000000000000000_REALK, &
      3.856664836922030_REALK,      0.000000000000000_REALK,     -1.428145312711879_REALK, &
      1.509201094912626_REALK,      0.000000000000000_REALK,      0.854478286069115_REALK, &
      0.000000000000000_REALK,     -2.874957969086986_REALK,      0.000000000000000_REALK, &
      0.526324826136726_REALK,      0.000000000000000_REALK,     -0.584703388960519_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.272440229957429_REALK, &
      0.000000000000000_REALK,     -0.031913548648297_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.451211645258232_REALK,      0.000000000000000_REALK, &
      1.401560388719890_REALK,      0.000000000000000_REALK,     -0.814944524080200_REALK, &
      0.000000000000000_REALK,     -0.012724912477647_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.624020486007222_REALK, &
      0.000000000000000_REALK,     -1.316055844316343_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.722650975459961_REALK,      0.000000000000000_REALK, &
      0.651046023028685_REALK,      0.000000000000000_REALK,     -2.229139715865524_REALK, &
      0.000000000000000_REALK,     -0.538812336100358_REALK,      0.000000000000000_REALK, &
     -6.389886343025060_REALK,     -0.998408375181731_REALK,      0.000000000000000_REALK, &
     -0.027332176689534_REALK,      0.000000000000000_REALK,     -1.829306998675724_REALK, &
      0.435487228567246_REALK,      0.000000000000000_REALK,     -0.327524682641340_REALK, &
      0.000000000000000_REALK,      0.697153757778255_REALK,      0.000000000000000_REALK, &
     -0.010898178702432_REALK,      0.000000000000000_REALK,     -1.215668184769466_REALK, &
     -2.985691084138680_REALK,     -0.049784485081032_REALK,      0.000000000000000_REALK, &
      0.446049770353541_REALK,      0.000000000000000_REALK,     -1.399551500650994_REALK, &
      0.410775662301677_REALK,      0.000000000000000_REALK,     -0.019957870790303_REALK, &
      0.000000000000000_REALK,      0.050739593438079_REALK,      0.000000000000000_REALK, &
      0.182619240527797_REALK,      0.000000000000000_REALK,     -0.954994446493589_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.831773478614511_REALK, &
      0.000000000000000_REALK,      0.869892172737093_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.252436043215534_REALK,      0.000000000000000_REALK, &
      1.548257094241892_REALK,      0.000000000000000_REALK,     -0.179934090899660_REALK, &
      0.000000000000000_REALK,      0.578087898500370_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.795553990362403_REALK, &
      0.000000000000000_REALK,     -0.600043285949249_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.747668922813663_REALK,      0.000000000000000_REALK, &
      1.199685486965720_REALK,      0.000000000000000_REALK,     -2.745249064408206_REALK, &
      0.000000000000000_REALK,     -0.409444029369946_REALK,      0.000000000000000_REALK, &
     -6.373013884384699_REALK,     -3.427517008188617_REALK,      0.000000000000000_REALK, &
     -2.397159778407148_REALK,      0.000000000000000_REALK,     -3.040794539871617_REALK, &
     -1.962422026435094_REALK,      0.000000000000000_REALK,     -1.873976701751987_REALK, &
      0.000000000000000_REALK,     -1.894938215243311_REALK,      0.000000000000000_REALK, &
     -1.593035438298881_REALK,      0.000000000000000_REALK,     -2.829069179588857_REALK, &
     -7.651782019770399_REALK,     -5.243125980907410_REALK,      0.000000000000000_REALK, &
     -2.934655508668070_REALK,      0.000000000000000_REALK,     -5.977992312129043_REALK, &
     -0.389731319808866_REALK,      0.000000000000000_REALK,     -3.503154001154802_REALK, &
      0.000000000000000_REALK,      3.306377658176164_REALK,      0.000000000000000_REALK, &
     -2.002484161423297_REALK,      0.000000000000000_REALK,     -5.710778945435564_REALK, &
    -61.899045022555185_REALK,     19.697708660398874_REALK,      0.000000000000000_REALK, &
      8.759913400686875_REALK,      0.000000000000000_REALK,     -4.503872081549531_REALK, &
      8.227811035662587_REALK,      0.000000000000000_REALK,      1.649084722354313_REALK, &
      0.000000000000000_REALK,      5.989335253113601_REALK,      0.000000000000000_REALK, &
      0.880868612722881_REALK,      0.000000000000000_REALK,     -1.358684511211526_REALK, &
    -61.743964250781730_REALK,     62.287274472090864_REALK,      0.000000000000000_REALK, &
     31.071743938471826_REALK,      0.000000000000000_REALK,     -3.628631648703101_REALK, &
     25.888815510173831_REALK,      0.000000000000000_REALK,      4.106584833179312_REALK, &
      0.000000000000000_REALK,     24.159958192936951_REALK,      0.000000000000000_REALK, &
      2.359701614230574_REALK,      0.000000000000000_REALK,     -0.826714584400052_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      6.368586615586751_REALK, &
      0.000000000000000_REALK,     -0.977095235452922_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.772104180527676_REALK,      0.000000000000000_REALK, &
      1.599526991462002_REALK,      0.000000000000000_REALK,     -0.876215764478377_REALK, &
      0.000000000000000_REALK,     -0.294760627822210_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.632263917657344_REALK, &
      0.000000000000000_REALK,     -3.552813957438310_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.536900246456562_REALK,      0.000000000000000_REALK, &
      1.707369171987277_REALK,      0.000000000000000_REALK,     -0.476551682706151_REALK, &
      0.000000000000000_REALK,     -0.809440968008996_REALK,      0.000000000000000_REALK, &
     -9.992631709557807_REALK,      0.061323565693082_REALK,      0.000000000000000_REALK, &
      0.702217614817916_REALK,      0.000000000000000_REALK,     -2.181238900930599_REALK, &
      0.986391121362467_REALK,      0.000000000000000_REALK,      0.015401957209581_REALK, &
      0.000000000000000_REALK,      1.076870430387502_REALK,      0.000000000000000_REALK, &
      0.211838209318048_REALK,      0.000000000000000_REALK,     -1.096691711889103_REALK, &
    -15.353715769476747_REALK,      7.954751717065624_REALK,      0.000000000000000_REALK, &
      7.162567532949371_REALK,      0.000000000000000_REALK,     -2.706968023952713_REALK, &
      6.509222458394651_REALK,      0.000000000000000_REALK,      1.573364528944634_REALK, &
      0.000000000000000_REALK,      6.263135428626649_REALK,      0.000000000000000_REALK, &
      1.631854543118450_REALK,      0.000000000000000_REALK,     -1.027885146781678_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.515109809391044_REALK, &
      0.000000000000000_REALK,      0.509724436094218_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.013190918391941_REALK,      0.000000000000000_REALK, &
      1.471418321796615_REALK,      0.000000000000000_REALK,     -0.204455792863608_REALK, &
      0.000000000000000_REALK,      0.256281218977610_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.459431832627599_REALK, &
      0.000000000000000_REALK,      0.082982333267626_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.533259200093235_REALK,      0.000000000000000_REALK, &
      2.788641400319136_REALK,      0.000000000000000_REALK,     -0.389124750328777_REALK, &
      0.000000000000000_REALK,      0.031509905937688_REALK,      0.000000000000000_REALK, &
     -6.623116517412377_REALK,     -1.671543656540007_REALK,      0.000000000000000_REALK, &
     -0.392864497234849_REALK,      0.000000000000000_REALK,     -2.409541986047897_REALK, &
      0.217788308835099_REALK,      0.000000000000000_REALK,     -0.699705015002636_REALK, &
      0.000000000000000_REALK,      0.664335763699989_REALK,      0.000000000000000_REALK, &
     -0.197525927961913_REALK,      0.000000000000000_REALK,     -1.696070345246544_REALK, &
    -16.975417400400662_REALK,      3.626894238441711_REALK,      0.000000000000000_REALK, &
      7.266589032376336_REALK,      0.000000000000000_REALK,     -4.988142369580625_REALK, &
      8.016292893958200_REALK,      0.000000000000000_REALK,      1.195601268265784_REALK, &
      0.000000000000000_REALK,      8.108553929502298_REALK,      0.000000000000000_REALK, &
      2.759256433047825_REALK,      0.000000000000000_REALK,     -2.651724131536839_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.843046969799631_REALK, &
      0.000000000000000_REALK,      2.916457195991702_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.928175435165135_REALK,      0.000000000000000_REALK, &
      3.424243783484856_REALK,      0.000000000000000_REALK,      1.535554221524243_REALK, &
      0.000000000000000_REALK,      2.052886644824826_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     36.133303016648490_REALK, &
      0.000000000000000_REALK,     14.565676662908128_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      5.847374564880096_REALK,      0.000000000000000_REALK, &
     16.675819062388008_REALK,      0.000000000000000_REALK,      0.615316000247656_REALK, &
      0.000000000000000_REALK,      7.743194447443924_REALK,      0.000000000000000_REALK, &
    -42.569402484578895_REALK,     -6.016415895994814_REALK,      0.000000000000000_REALK, &
    -23.555325500808287_REALK,      0.000000000000000_REALK,    -18.447511605223255_REALK, &
     -8.187604218231648_REALK,      0.000000000000000_REALK,     -3.049879721630588_REALK, &
      0.000000000000000_REALK,    -88.662336940815507_REALK,      0.000000000000000_REALK, &
    -29.385448674264893_REALK,      0.000000000000000_REALK,    -69.040235350336260_REALK, &
    -11.433179793251675_REALK,     -1.657204505242454_REALK,      0.000000000000000_REALK, &
     -5.906694485779328_REALK,      0.000000000000000_REALK,     -7.838797737566850_REALK, &
      0.205432510644916_REALK,      0.000000000000000_REALK,     -1.405399553056327_REALK, &
      0.000000000000000_REALK,     41.644852767591260_REALK,      0.000000000000000_REALK, &
     -8.787630943071514_REALK,      0.000000000000000_REALK,    -34.986299894618391_REALK, &
    -19.832059378190362_REALK,      2.093097996306802_REALK,      0.000000000000000_REALK, &
      1.949540854743892_REALK,      0.000000000000000_REALK,     -7.604914318157121_REALK, &
      8.312884865752062_REALK,      0.000000000000000_REALK,      0.903939303497713_REALK, &
      0.000000000000000_REALK,     50.473983007852176_REALK,      0.000000000000000_REALK, &
      2.088361226732205_REALK,      0.000000000000000_REALK,    -24.439305525730489_REALK, &
     -4.990028002127127_REALK,      4.128029115926409_REALK,      0.000000000000000_REALK, &
      7.897667692154029_REALK,      0.000000000000000_REALK,     -1.788356873748600_REALK, &
     11.774001319332749_REALK,      0.000000000000000_REALK,      1.937000347946496_REALK, &
      0.000000000000000_REALK,     67.622872789381191_REALK,      0.000000000000000_REALK, &
      9.320468983115095_REALK,      0.000000000000000_REALK,     -6.331612859226931_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.086986092114821_REALK, &
      0.000000000000000_REALK,      3.577804329111118_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.805185439873636_REALK,      0.000000000000000_REALK, &
      6.590699536938661_REALK,      0.000000000000000_REALK,     10.288782689434889_REALK, &
      0.000000000000000_REALK,     11.497703912542791_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.391514213767257_REALK, &
      0.000000000000000_REALK,      2.029771564850409_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.199155871077603_REALK,      0.000000000000000_REALK, &
      4.774213573339858_REALK,      0.000000000000000_REALK,     -0.350151052671843_REALK, &
      0.000000000000000_REALK,      7.186332845502661_REALK,      0.000000000000000_REALK, &
    -11.918947886218486_REALK,      7.380674627580811_REALK,      0.000000000000000_REALK, &
      2.529327352476006_REALK,      0.000000000000000_REALK,     -3.847190931094640_REALK, &
      8.606152633647305_REALK,      0.000000000000000_REALK,      2.776833230025202_REALK, &
      0.000000000000000_REALK,     14.850455198203784_REALK,      0.000000000000000_REALK, &
      2.171355468210914_REALK,      0.000000000000000_REALK,     -9.908111408323172_REALK, &
     -2.086759650901681_REALK,      3.458794437951016_REALK,      0.000000000000000_REALK, &
      0.751872020201991_REALK,      0.000000000000000_REALK,     -1.164778294151415_REALK, &
      1.748015775933997_REALK,      0.000000000000000_REALK,      1.755905428767346_REALK, &
      0.000000000000000_REALK,     -9.640531021264060_REALK,      0.000000000000000_REALK, &
      0.711790197912268_REALK,      0.000000000000000_REALK,     -3.308054097937641_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.354820756711827_REALK, &
      0.000000000000000_REALK,     -0.703233885576398_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.323564654719393_REALK,      0.000000000000000_REALK, &
      3.786555387445317_REALK,      0.000000000000000_REALK,     -5.551855714924355_REALK, &
      0.000000000000000_REALK,     -1.811118764104703_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.951005914153812_REALK, &
      0.000000000000000_REALK,     -1.753169274926086_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.132083725708466_REALK,      0.000000000000000_REALK, &
      1.448374406813633_REALK,      0.000000000000000_REALK,    -10.088493343332502_REALK, &
      0.000000000000000_REALK,     -4.979126786117536_REALK,      0.000000000000000_REALK, &
     -5.294987730431703_REALK,     -1.578307358190466_REALK,      0.000000000000000_REALK, &
     -2.182338403708613_REALK,      0.000000000000000_REALK,     -5.127338999525722_REALK, &
     -1.594114263268097_REALK,      0.000000000000000_REALK,     -1.781421024728103_REALK, &
      0.000000000000000_REALK,     -5.652685580962340_REALK,      0.000000000000000_REALK, &
     -5.620426025607922_REALK,      0.000000000000000_REALK,    -22.008372232033715_REALK, &
     -2.580500231606986_REALK,     -1.079384540574274_REALK,      0.000000000000000_REALK, &
     -1.085349949084547_REALK,      0.000000000000000_REALK,     -4.321116698604595_REALK, &
      0.080098046814358_REALK,      0.000000000000000_REALK,     -1.643894028849560_REALK, &
      0.000000000000000_REALK,      4.869309629343972_REALK,      0.000000000000000_REALK, &
     -3.082471887391485_REALK,      0.000000000000000_REALK,    -20.453803489558467_REALK, &
     -5.333681995736963_REALK,     13.407942204040642_REALK,      0.000000000000000_REALK, &
      2.089963485580469_REALK,      0.000000000000000_REALK,     -1.404763792408669_REALK, &
     10.511778020644332_REALK,      0.000000000000000_REALK,      4.284312106743671_REALK, &
      0.000000000000000_REALK,      6.781495715790758_REALK,      0.000000000000000_REALK, &
      1.365196995691213_REALK,      0.000000000000000_REALK,     -2.752841361512299_REALK, &
     -1.207513309010606_REALK,     10.748702764432291_REALK,      0.000000000000000_REALK, &
      3.001226122313751_REALK,      0.000000000000000_REALK,     -0.273439358374097_REALK, &
      9.547005655385993_REALK,      0.000000000000000_REALK,      3.356521084193496_REALK, &
      0.000000000000000_REALK,     15.375487958318324_REALK,      0.000000000000000_REALK, &
      1.827960356559978_REALK,      0.000000000000000_REALK,     -0.499632103674052_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.366511211643798_REALK, &
      0.000000000000000_REALK,     -1.962427400598369_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.497151596581785_REALK,      0.000000000000000_REALK, &
      2.268552283526704_REALK,      0.000000000000000_REALK,     -3.972916805862730_REALK, &
      0.000000000000000_REALK,     -3.845665261680273_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.324976908817734_REALK, &
      0.000000000000000_REALK,     -1.783167017808158_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.267080567507742_REALK,      0.000000000000000_REALK, &
      1.241260371967633_REALK,      0.000000000000000_REALK,     -1.081195685429005_REALK, &
      0.000000000000000_REALK,     -3.258226956087218_REALK,      0.000000000000000_REALK, &
     -3.386808758396092_REALK,      0.432578186118478_REALK,      0.000000000000000_REALK, &
      0.228667727474842_REALK,      0.000000000000000_REALK,     -2.676012360360086_REALK, &
      1.271147894978496_REALK,      0.000000000000000_REALK,      0.414672124558107_REALK, &
      0.000000000000000_REALK,      3.610135119852971_REALK,      0.000000000000000_REALK, &
      0.448108060328365_REALK,      0.000000000000000_REALK,     -8.740066656670496_REALK, &
     -2.165117091460371_REALK,      1.994292663410354_REALK,      0.000000000000000_REALK, &
      2.165185730735963_REALK,      0.000000000000000_REALK,     -1.470861374055087_REALK, &
      3.785442023981660_REALK,      0.000000000000000_REALK,      1.868286486144025_REALK, &
      0.000000000000000_REALK,      9.567953643391906_REALK,      0.000000000000000_REALK, &
      3.956256728823309_REALK,      0.000000000000000_REALK,     -4.479296414518811_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      3.153964917676612_REALK, &
      0.000000000000000_REALK,      1.258955486821485_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.286847691687753_REALK,      0.000000000000000_REALK, &
      5.039017127092976_REALK,      0.000000000000000_REALK,      2.207705446302054_REALK, &
      0.000000000000000_REALK,      4.111847551825289_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.915424570243186_REALK, &
      0.000000000000000_REALK,      1.669416567083639_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.156616575257546_REALK,      0.000000000000000_REALK, &
      7.674752279120920_REALK,      0.000000000000000_REALK,     -0.148628514374880_REALK, &
      0.000000000000000_REALK,      5.083967649962902_REALK,      0.000000000000000_REALK, &
      7.119556385490888_REALK,     22.076201878928984_REALK,      0.000000000000000_REALK, &
      0.167468312923395_REALK,      0.000000000000000_REALK,      1.511542950095012_REALK, &
     12.669751186831029_REALK,      0.000000000000000_REALK,      5.799152807002788_REALK, &
      0.000000000000000_REALK,     -3.111420920282463_REALK,      0.000000000000000_REALK, &
      0.080113024898240_REALK,      0.000000000000000_REALK,      2.169263113991823_REALK, &
      1.682475241569538_REALK,     12.975244525163671_REALK,      0.000000000000000_REALK, &
     -2.704413019665567_REALK,      0.000000000000000_REALK,      0.621374205011224_REALK, &
      5.088470198070804_REALK,      0.000000000000000_REALK,      4.390635364601851_REALK, &
      0.000000000000000_REALK,    -15.999094587118623_REALK,      0.000000000000000_REALK, &
     -1.284596155717864_REALK,      0.000000000000000_REALK,      0.885458222411277_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.138706789925853_REALK, &
      0.000000000000000_REALK,     -3.212088640036258_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.445028167083354_REALK,      0.000000000000000_REALK, &
      0.897373748441914_REALK,      0.000000000000000_REALK,     -3.770101880275153_REALK, &
      0.000000000000000_REALK,     -4.609770040120150_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.268348972825676_REALK, &
      0.000000000000000_REALK,     -3.350893076161842_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.996665554115568_REALK,      0.000000000000000_REALK, &
      0.272416251082898_REALK,      0.000000000000000_REALK,     -4.527223865390640_REALK, &
      0.000000000000000_REALK,     -4.775022527133914_REALK,      0.000000000000000_REALK, &
     -2.670339010969770_REALK,      1.590750998761374_REALK,      0.000000000000000_REALK, &
      0.372730780570974_REALK,      0.000000000000000_REALK,     -1.700807699741284_REALK, &
      1.295095059297694_REALK,      0.000000000000000_REALK,      1.253613484371306_REALK, &
      0.000000000000000_REALK,      1.219479721218381_REALK,      0.000000000000000_REALK, &
      0.534917736668461_REALK,      0.000000000000000_REALK,     -4.068138241137567_REALK, &
     -1.118428661166390_REALK,      1.749971329843395_REALK,      0.000000000000000_REALK, &
      0.266632743245261_REALK,      0.000000000000000_REALK,     -1.239179102949033_REALK, &
      0.589504303557966_REALK,      0.000000000000000_REALK,      1.776495077132926_REALK, &
      0.000000000000000_REALK,     -1.715362984531509_REALK,      0.000000000000000_REALK, &
      0.379951650658441_REALK,      0.000000000000000_REALK,     -2.943050303927117_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.169185638991086_REALK, &
      0.000000000000000_REALK,     -0.310893228001815_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.146074675942457_REALK,      0.000000000000000_REALK, &
      2.849094934050218_REALK,      0.000000000000000_REALK,     -1.367710693534740_REALK, &
      0.000000000000000_REALK,     -0.743621180652739_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.443479611873005_REALK, &
      0.000000000000000_REALK,     -1.865153858317266_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -2.157084419640559_REALK,      0.000000000000000_REALK, &
      2.442263272834707_REALK,      0.000000000000000_REALK,     -5.385210009492616_REALK, &
      0.000000000000000_REALK,     -4.429740314800348_REALK,      0.000000000000000_REALK, &
     -3.558891044953816_REALK,     -1.020514031472830_REALK,      0.000000000000000_REALK, &
     -0.964791721270930_REALK,      0.000000000000000_REALK,     -3.777915629770872_REALK, &
     -0.719669843494123_REALK,      0.000000000000000_REALK,     -1.340383831117717_REALK, &
      0.000000000000000_REALK,     -1.392550331502476_REALK,      0.000000000000000_REALK, &
     -2.307671876504464_REALK,      0.000000000000000_REALK,    -12.650881264613322_REALK, &
     -4.149167947437576_REALK,     -1.638338473505936_REALK,      0.000000000000000_REALK, &
     -1.154677231749249_REALK,      0.000000000000000_REALK,     -7.661883726716689_REALK, &
      0.081037272009325_REALK,      0.000000000000000_REALK,     -2.771950396392332_REALK, &
      0.000000000000000_REALK,      2.599224092524407_REALK,      0.000000000000000_REALK, &
     -2.742358364299433_REALK,      0.000000000000000_REALK,    -25.475762823683858_REALK, &
     49.988115970775347_REALK,     40.526351018788510_REALK,      0.000000000000000_REALK, &
     -3.432639369353385_REALK,      0.000000000000000_REALK,      7.845530055205596_REALK, &
     18.710298983404098_REALK,      0.000000000000000_REALK,      8.054815472192519_REALK, &
      0.000000000000000_REALK,    -11.052282466911771_REALK,      0.000000000000000_REALK, &
     -1.132391108161579_REALK,      0.000000000000000_REALK,      7.764470004609991_REALK, &
     55.905598383597834_REALK,     74.450813237353330_REALK,      0.000000000000000_REALK, &
    -10.054076650868398_REALK,      0.000000000000000_REALK,      7.060453665908589_REALK, &
     30.891069969589850_REALK,      0.000000000000000_REALK,     11.678104414824647_REALK, &
      0.000000000000000_REALK,     -1.078031463854113_REALK,      0.000000000000000_REALK, &
     -2.297944338439543_REALK,      0.000000000000000_REALK,      4.841179381794748_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.711571880647155_REALK, &
      0.000000000000000_REALK,     -5.298519843685138_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.037689935127181_REALK,      0.000000000000000_REALK, &
     -1.020550480324381_REALK,      0.000000000000000_REALK,     -3.818795218810084_REALK, &
      0.000000000000000_REALK,     -5.243775513654058_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.135683480002585_REALK, &
      0.000000000000000_REALK,     -9.732523256092700_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.458006948985962_REALK,      0.000000000000000_REALK, &
     -1.004988404772980_REALK,      0.000000000000000_REALK,     -2.577998303840646_REALK, &
      0.000000000000000_REALK,     -6.673351763178879_REALK,      0.000000000000000_REALK, &
     -1.741352111280608_REALK,      3.637158040455713_REALK,      0.000000000000000_REALK, &
      0.406609491552383_REALK,      0.000000000000000_REALK,     -0.819904694971993_REALK, &
      1.773680315665553_REALK,      0.000000000000000_REALK,      2.168710193929611_REALK, &
      0.000000000000000_REALK,      0.666309417307220_REALK,      0.000000000000000_REALK, &
      0.402408400520169_REALK,      0.000000000000000_REALK,     -1.352389060172539_REALK, &
     -1.593795254066755_REALK,     11.517129176426995_REALK,      0.000000000000000_REALK, &
      2.209263552646646_REALK,      0.000000000000000_REALK,     -0.603852809180458_REALK, &
      5.138364945258606_REALK,      0.000000000000000_REALK,      5.419614557569034_REALK, &
      0.000000000000000_REALK,      4.247241691341152_REALK,      0.000000000000000_REALK, &
      1.514837667112881_REALK,      0.000000000000000_REALK,     -0.690078359402200_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      1.925882842483814_REALK, &
      0.000000000000000_REALK,     -1.145390739701100_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.251657140883412_REALK,      0.000000000000000_REALK, &
      1.913894358522050_REALK,      0.000000000000000_REALK,     -1.171065496256432_REALK, &
      0.000000000000000_REALK,     -1.889260929342053_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.259099134771568_REALK, &
      0.000000000000000_REALK,     -3.937876461325834_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.431242258100266_REALK,      0.000000000000000_REALK, &
      3.340339900007776_REALK,      0.000000000000000_REALK,     -0.895990957314859_REALK, &
      0.000000000000000_REALK,     -4.500175020545748_REALK,      0.000000000000000_REALK, &
     -3.317198093165548_REALK,      0.352035055899724_REALK,      0.000000000000000_REALK, &
      0.133464248123685_REALK,      0.000000000000000_REALK,     -2.603136448892787_REALK, &
      0.643452514463827_REALK,      0.000000000000000_REALK,      0.349843662670326_REALK, &
      0.000000000000000_REALK,      1.064131186800760_REALK,      0.000000000000000_REALK, &
      0.220142158220950_REALK,      0.000000000000000_REALK,     -6.011228607533408_REALK, &
     -8.573205742210286_REALK,      6.410594856925734_REALK,      0.000000000000000_REALK, &
      4.781511680237360_REALK,      0.000000000000000_REALK,     -5.413654773520528_REALK, &
      6.112172748330607_REALK,      0.000000000000000_REALK,      5.027721850508690_REALK, &
      0.000000000000000_REALK,      7.928999403179576_REALK,      0.000000000000000_REALK, &
      5.464274878904447_REALK,      0.000000000000000_REALK,     -8.661356421230629_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      4.277863330953822_REALK, &
      0.000000000000000_REALK,      1.224670320595075_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.085666200106039_REALK,      0.000000000000000_REALK, &
      5.951727509610205_REALK,      0.000000000000000_REALK,      1.084580003557496_REALK, &
      0.000000000000000_REALK,      2.828039716892085_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     26.334145139729305_REALK, &
      0.000000000000000_REALK,      6.144457340986721_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.112556062044227_REALK,      0.000000000000000_REALK, &
     28.914798679973000_REALK,      0.000000000000000_REALK,     -0.205281687477622_REALK, &
      0.000000000000000_REALK,      9.830574218666737_REALK,      0.000000000000000_REALK/
    ! results of test 5, ket-major order, ZDIPVEL
  data REF_CONTR_INTS(31501:32760)                                                         &
     /0.000000000000000_REALK,      0.000000000000000_REALK,     12.209587161337501_REALK, &
      0.000000000000000_REALK,     12.335510502417661_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     16.425689030404968_REALK,      0.000000000000000_REALK, &
      7.745015515490882_REALK,      0.000000000000000_REALK,     30.907178242688616_REALK, &
      0.000000000000000_REALK,     11.087878659224391_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     12.501230293251162_REALK, &
      0.000000000000000_REALK,     16.468048920163149_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     25.502317718550895_REALK,      0.000000000000000_REALK, &
      9.223628235199078_REALK,      0.000000000000000_REALK,     51.184926763798529_REALK, &
      0.000000000000000_REALK,     14.915949621647256_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      8.377532768527326_REALK, &
      0.000000000000000_REALK,      6.095971674346316_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      6.018285029253223_REALK,      0.000000000000000_REALK, &
      4.580512760439629_REALK,      0.000000000000000_REALK,      7.873284975640716_REALK, &
      0.000000000000000_REALK,      4.511064107063818_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.281983886630690_REALK, &
      0.000000000000000_REALK,      4.469394585246675_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.936962901421232_REALK,      0.000000000000000_REALK, &
      3.589615529423321_REALK,      0.000000000000000_REALK,      0.557817213188908_REALK, &
      0.000000000000000_REALK,      3.008410414519546_REALK,      0.000000000000000_REALK, &
      9.671464072433743_REALK,      8.377532768527326_REALK,      0.000000000000000_REALK, &
      9.341216610459950_REALK,      0.000000000000000_REALK,     -2.085933847353481_REALK, &
     12.768062194840098_REALK,      0.000000000000000_REALK,     -2.169264405147246_REALK, &
      0.000000000000000_REALK,     23.152677876284958_REALK,      0.000000000000000_REALK, &
     -3.273692581597515_REALK,      0.000000000000000_REALK,     -4.173680944286847_REALK, &
      8.344424410208857_REALK,      7.281983886630689_REALK,      0.000000000000000_REALK, &
      8.474391014111333_REALK,      0.000000000000000_REALK,     -4.944991743065289_REALK, &
     12.317969197018224_REALK,      0.000000000000000_REALK,     -5.791390766173672_REALK, &
      0.000000000000000_REALK,     22.918735512041497_REALK,      0.000000000000000_REALK, &
     -9.203050765809666_REALK,      0.000000000000000_REALK,     -7.344780697013846_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      7.830530914734441_REALK, &
      0.000000000000000_REALK,      4.409227071396122_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.649786208748017_REALK,      0.000000000000000_REALK, &
      3.663284417237143_REALK,      0.000000000000000_REALK,      3.988649916176913_REALK, &
      0.000000000000000_REALK,      2.679595690577732_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      5.588035945067877_REALK, &
      0.000000000000000_REALK,      4.047492236325485_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      4.066409726357447_REALK,      0.000000000000000_REALK, &
      3.059583387690254_REALK,      0.000000000000000_REALK,      5.665668738974966_REALK, &
      0.000000000000000_REALK,      2.469061947986520_REALK,      0.000000000000000_REALK, &
      7.584348092057158_REALK,      4.762066440423276_REALK,      0.000000000000000_REALK, &
      3.943943041996059_REALK,      0.000000000000000_REALK,     -1.421576946812006_REALK, &
      3.888229157543608_REALK,      0.000000000000000_REALK,     -1.055050562194703_REALK, &
      0.000000000000000_REALK,      4.751774324319903_REALK,      0.000000000000000_REALK, &
     -1.135104466335632_REALK,      0.000000000000000_REALK,     -2.335930053365533_REALK, &
      1.973272488466079_REALK,      1.545087152658806_REALK,      0.000000000000000_REALK, &
      0.995338078011720_REALK,      0.000000000000000_REALK,     -1.962704994138220_REALK, &
      0.156859531214041_REALK,      0.000000000000000_REALK,     -1.364869153040838_REALK, &
      0.000000000000000_REALK,     -1.670893226461585_REALK,      0.000000000000000_REALK, &
     -0.979606176845403_REALK,      0.000000000000000_REALK,     -2.641957742099134_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.096159137619856_REALK, &
      0.000000000000000_REALK,     -0.956292917411945_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.087562797168844_REALK,      0.000000000000000_REALK, &
      1.059311695339401_REALK,      0.000000000000000_REALK,     -1.619976210467592_REALK, &
      0.000000000000000_REALK,      1.200517439536802_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.948902948583890_REALK, &
      0.000000000000000_REALK,      1.089449164175544_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.436490510177775_REALK,      0.000000000000000_REALK, &
      3.817393384087544_REALK,      0.000000000000000_REALK,      2.280573693318197_REALK, &
      0.000000000000000_REALK,      4.883092478005739_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      9.030438649538032_REALK, &
      0.000000000000000_REALK,      3.814242173398460_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.584183704067790_REALK,      0.000000000000000_REALK, &
      3.553332586284229_REALK,      0.000000000000000_REALK,      2.172451309525271_REALK, &
      0.000000000000000_REALK,      1.886381088611596_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      9.647483267783709_REALK, &
      0.000000000000000_REALK,      3.459753350034372_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      1.513684699194594_REALK,      0.000000000000000_REALK, &
      3.200136625719711_REALK,      0.000000000000000_REALK,     -0.047496534747906_REALK, &
      0.000000000000000_REALK,      1.456920380942887_REALK,      0.000000000000000_REALK, &
      8.433574557777296_REALK,      4.078339474286109_REALK,      0.000000000000000_REALK, &
      2.827099580562477_REALK,      0.000000000000000_REALK,     -1.343824985817979_REALK, &
      2.388729837657292_REALK,      0.000000000000000_REALK,     -0.759991574944114_REALK, &
      0.000000000000000_REALK,      2.606248323964255_REALK,      0.000000000000000_REALK, &
     -0.662156534175242_REALK,      0.000000000000000_REALK,     -1.796993633538033_REALK, &
      6.136337466412071_REALK,      2.929114987736770_REALK,      0.000000000000000_REALK, &
      2.156371113477831_REALK,      0.000000000000000_REALK,     -2.617638069261469_REALK, &
      2.229513464751975_REALK,      0.000000000000000_REALK,     -1.567566022181965_REALK, &
      0.000000000000000_REALK,      3.244845379612821_REALK,      0.000000000000000_REALK, &
     -1.465038776130367_REALK,      0.000000000000000_REALK,     -2.432344893617435_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -0.884528533212160_REALK, &
      0.000000000000000_REALK,     -0.549752889658613_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.457296117453453_REALK,      0.000000000000000_REALK, &
      0.718968044003764_REALK,      0.000000000000000_REALK,     -0.474532173502725_REALK, &
      0.000000000000000_REALK,      0.561641796033587_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.788419517281383_REALK, &
      0.000000000000000_REALK,      0.401749487083899_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.213974676450648_REALK,      0.000000000000000_REALK, &
      1.921559648281264_REALK,      0.000000000000000_REALK,      0.031369011928263_REALK, &
      0.000000000000000_REALK,      1.243048369820754_REALK,      0.000000000000000_REALK, &
      5.428968800785847_REALK,      4.067570642039765_REALK,      0.000000000000000_REALK, &
      3.873925643090010_REALK,      0.000000000000000_REALK,      0.352687364375603_REALK, &
      4.461418958756212_REALK,      0.000000000000000_REALK,      0.309030995432941_REALK, &
      0.000000000000000_REALK,      6.417031609832160_REALK,      0.000000000000000_REALK, &
      0.369923886448416_REALK,      0.000000000000000_REALK,     -0.924215874479916_REALK, &
      9.921300714539557_REALK,      7.506787797328321_REALK,      0.000000000000000_REALK, &
      7.252903578664796_REALK,      0.000000000000000_REALK,     -2.483416594686616_REALK, &
      8.544758721617551_REALK,      0.000000000000000_REALK,     -2.357350514541345_REALK, &
      0.000000000000000_REALK,     12.271463307835539_REALK,      0.000000000000000_REALK, &
     -2.891466206971178_REALK,      0.000000000000000_REALK,     -5.327016188642624_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     12.775980185906935_REALK, &
      0.000000000000000_REALK,      4.011546841359845_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.328068743605272_REALK,      0.000000000000000_REALK, &
      4.191119545706496_REALK,      0.000000000000000_REALK,      1.584935593699231_REALK, &
      0.000000000000000_REALK,      1.599526991462001_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     10.341794454862704_REALK, &
      0.000000000000000_REALK,      4.170270475731821_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.922230461698117_REALK,      0.000000000000000_REALK, &
      4.145873902965362_REALK,      0.000000000000000_REALK,      2.925093195468961_REALK, &
      0.000000000000000_REALK,      1.707369171987277_REALK,      0.000000000000000_REALK, &
     11.689542074189989_REALK,      4.272440229957429_REALK,      0.000000000000000_REALK, &
      2.433764128906156_REALK,      0.000000000000000_REALK,     -1.584854340897325_REALK, &
      1.614107414580956_REALK,      0.000000000000000_REALK,     -0.663758671119298_REALK, &
      0.000000000000000_REALK,      1.330043087845806_REALK,      0.000000000000000_REALK, &
     -0.459575198991359_REALK,      0.000000000000000_REALK,     -1.708644511055314_REALK, &
      3.367678774223799_REALK,      1.624020486007222_REALK,      0.000000000000000_REALK, &
      0.746692128801760_REALK,      0.000000000000000_REALK,     -2.546886589355904_REALK, &
     -0.021224516081830_REALK,      0.000000000000000_REALK,     -1.050380436349446_REALK, &
      0.000000000000000_REALK,     -1.030751481371144_REALK,      0.000000000000000_REALK, &
     -0.493218910413295_REALK,      0.000000000000000_REALK,     -2.300899745899662_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.012583883879153_REALK, &
      0.000000000000000_REALK,     -0.481486868673010_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.330950938682375_REALK,      0.000000000000000_REALK, &
      0.686179214687037_REALK,      0.000000000000000_REALK,     -0.285772742069054_REALK, &
      0.000000000000000_REALK,      0.396583719170183_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      0.682036952802596_REALK, &
      0.000000000000000_REALK,      0.429223939365061_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.363393314950164_REALK,      0.000000000000000_REALK, &
      2.008954541217928_REALK,      0.000000000000000_REALK,      0.403242538914202_REALK, &
      0.000000000000000_REALK,      1.291187061594046_REALK,      0.000000000000000_REALK, &
      5.265307700451099_REALK,      2.831773478614512_REALK,      0.000000000000000_REALK, &
      1.980504682625121_REALK,      0.000000000000000_REALK,      0.291042989792464_REALK, &
      1.621329561613086_REALK,      0.000000000000000_REALK,      0.179363575844340_REALK, &
      0.000000000000000_REALK,      1.565575245496733_REALK,      0.000000000000000_REALK, &
      0.152473898097512_REALK,      0.000000000000000_REALK,     -0.614892508004647_REALK, &
      2.620419152431702_REALK,      1.795553990362404_REALK,      0.000000000000000_REALK, &
      1.004998244962258_REALK,      0.000000000000000_REALK,     -1.162867719394523_REALK, &
      0.133466872434545_REALK,      0.000000000000000_REALK,     -0.681450308282489_REALK, &
      0.000000000000000_REALK,     -1.132297720749378_REALK,      0.000000000000000_REALK, &
     -0.389532817764470_REALK,      0.000000000000000_REALK,     -2.425142623301481_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -2.302835328577121_REALK, &
      0.000000000000000_REALK,     -1.696533321276293_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.602138316177109_REALK,      0.000000000000000_REALK, &
     -0.166483001784953_REALK,      0.000000000000000_REALK,     -1.885614857541143_REALK, &
      0.000000000000000_REALK,     -0.149077909700123_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.294346251984429_REALK, &
      0.000000000000000_REALK,     -1.291174206782624_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -1.434658446162251_REALK,      0.000000000000000_REALK, &
      3.811916504273466_REALK,      0.000000000000000_REALK,     -1.814008143256063_REALK, &
      0.000000000000000_REALK,      3.883477343631681_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     25.320305047632353_REALK, &
      0.000000000000000_REALK,      5.451388777667954_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      2.689557602686869_REALK,      0.000000000000000_REALK, &
      6.359419098833769_REALK,      0.000000000000000_REALK,      1.357159815298884_REALK, &
      0.000000000000000_REALK,      1.644522171744616_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     58.504457569314233_REALK, &
      0.000000000000000_REALK,     10.595823336182809_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      3.128921014440612_REALK,      0.000000000000000_REALK, &
     11.571553908744832_REALK,      0.000000000000000_REALK,     -0.581639757370457_REALK, &
      0.000000000000000_REALK,      2.414056463647814_REALK,      0.000000000000000_REALK, &
     24.687493947734477_REALK,      6.368586615586751_REALK,      0.000000000000000_REALK, &
      2.993409351822925_REALK,      0.000000000000000_REALK,     -2.552106257837466_REALK, &
      1.584935593699231_REALK,      0.000000000000000_REALK,     -0.757512782764905_REALK, &
      0.000000000000000_REALK,      1.119806060174584_REALK,      0.000000000000000_REALK, &
     -0.427658473249786_REALK,      0.000000000000000_REALK,     -2.081680080089664_REALK, &
     33.483131662241782_REALK,      8.632263917657346_REALK,      0.000000000000000_REALK, &
      4.160965111688049_REALK,      0.000000000000000_REALK,     -9.524246645950937_REALK, &
      2.925093195468961_REALK,      0.000000000000000_REALK,     -2.754624269938246_REALK, &
      0.000000000000000_REALK,      3.239652267263648_REALK,      0.000000000000000_REALK, &
     -1.529472678652441_REALK,      0.000000000000000_REALK,     -4.788155278988532_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,     -1.692548464126262_REALK, &
      0.000000000000000_REALK,     -0.574117897650380_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,     -0.309155623829725_REALK,      0.000000000000000_REALK, &
      0.878133114703221_REALK,      0.000000000000000_REALK,     -0.199459295521050_REALK, &
      0.000000000000000_REALK,      0.357770387786017_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.000000000000000_REALK,      2.926321482061436_REALK, &
      0.000000000000000_REALK,      0.830191299452566_REALK,      0.000000000000000_REALK, &
      0.000000000000000_REALK,      0.273773659979538_REALK,      0.000000000000000_REALK, &
      4.252719891318522_REALK,      0.000000000000000_REALK,     -0.006166191376032_REALK, &
      0.000000000000000_REALK,      1.389737926960929_REALK,      0.000000000000000_REALK, &
      8.997814697603237_REALK,      3.515109809391045_REALK,      0.000000000000000_REALK, &
      1.956848417488458_REALK,      0.000000000000000_REALK,      0.379227936292395_REALK, &
      1.314147336450567_REALK,      0.000000000000000_REALK,      0.170461903737989_REALK, &
      0.000000000000000_REALK,      1.100381497921880_REALK,      0.000000000000000_REALK, &
      0.113980271523382_REALK,      0.000000000000000_REALK,     -0.606171136363364_REALK, &
 