  ! maximum order of Boys functions
  integer, parameter :: MAX_ORDER_BOYS = 30
  ! minimum argument of Boys functions
  real(REALK), parameter :: MIN_ARG_BOYS = 0.0_REALK
  ! step of argument of Boys functions
  real(REALK), parameter :: STEP_ARG_BOYS = 0.05_REALK
  ! number of steps
  integer, parameter :: NUM_STEPS = 400
  ! referenced Boys functions computed by GenHeader.BoysGamma (orders run quickly)
  real(REALK), parameter :: REF_BOYS((MAX_ORDER_BOYS+1)*(NUM_STEPS+1)) = (/ &
    1.0000000000000000000000000_REALK,  0.3333333333333333148296163_REALK,  &
    0.2000000000000000111022302_REALK,  0.1428571428571428492126927_REALK,  &
    0.1111111111111111049432054_REALK,  0.0909090909090909116141432_REALK,  &
    0.0769230769230769273470116_REALK,  0.0666666666666666657414808_REALK,  &
    0.0588235294117647050660125_REALK,  0.0526315789473684181309920_REALK,  &
    0.0476190476190476164042309_REALK,  0.0434782608695652161845402_REALK,  &
    0.0400000000000000008326673_REALK,  0.0370370370370370349810685_REALK,  &
    0.0344827586206896546938694_REALK,  0.0322580645161290313627234_REALK,  &
    0.0303030303030303038713811_REALK,  0.0285714285714285705364279_REALK,  &
    0.0270270270270270285273284_REALK,  0.0256410256410256401360392_REALK,  &
    0.0243902439024390252364505_REALK,  0.0232558139534883717702840_REALK,  &
    0.0222222222222222230703093_REALK,  0.0212765957446808505471036_REALK,  &
    0.0204081632653061208204637_REALK,  0.0196078431372549016886708_REALK,  &
    0.0188679245283018860723789_REALK,  0.0181818181818181809350499_REALK,  &
    0.0175438596491228060436640_REALK,  0.0169491525423728812971280_REALK,  &
    0.0163934426229508205252738_REALK,                                      &
    0.9835803858429590373901874_REALK,  0.3235096134224493824582680_REALK,  &
    0.1929941576663466162866456_REALK,  0.1374136383101806357931451_REALK,  &
    0.1066604367055141999731660_REALK,  0.0871450584891440560575404_REALK,  &
    0.0736621887987115725460185_REALK,  0.0637902988253660763184882_REALK,  &
    0.0562505787977778948238949_REALK,  0.0503041506151281209158199_REALK,  &
    0.0454943718671642211015538_REALK,  0.0415238470972966247640734_REALK,  &
    0.0381905873710053286873567_REALK,  0.0353525977441626476638348_REALK,  &
    0.0329071459167073337992449_REALK,  0.0307780708379645114025625_REALK,  &
    0.0289077147617515621547124_REALK,  0.0272516263708367685592027_REALK,  &
    0.0257749847857989822230707_REALK,  0.0244501257384393891336494_REALK,  &
    0.0232547929841015292573569_REALK,  0.0221708784744563125457262_REALK,  &
    0.0211834990088896023274767_REALK,  0.0202803089931028433789972_REALK,  &
    0.0194509817511532394351814_REALK,  0.0186868130579837463112192_REALK,  &
    0.0179804145645492130523024_REALK,  0.0173254742038405178117255_REALK,  &
    0.0167165671053072228957603_REALK,  0.0161490050176242051771514_REALK,  &
    0.0156187153910288031161135_REALK,                                      &
    0.9676433126355922231809359_REALK,  0.3140294729981613630620529_REALK,  &
    0.1862550047926217200444654_REALK,  0.1321880296357391126882419_REALK,  &
    0.1023939470710653054652539_REALK,  0.0835405280181416159956953_REALK,  &
    0.0705419508179837007055824_REALK,  0.0610397129891414522151472_REALK,  &
    0.0537913840058186279446950_REALK,  0.0480805503147777174577371_REALK,  &
    0.0434651897241010373718062_REALK,  0.0396578308508159713130503_REALK,  &
    0.0364634576640221405585685_REALK,  0.0337451178229993056789660_REALK,  &
    0.0314038159251097334645486_REALK,  0.0293662189611292069602033_REALK,  &
    0.0275768487952277562003101_REALK,  0.0259929610328038865341149_REALK,  &
    0.0245810905609475764677097_REALK,  0.0233146635955109038373934_REALK,  &
    0.0221723109447862463949885_REALK,  0.0211366535013734133108265_REALK,  &
    0.0201934126154592608060057_REALK,  0.0193307482985552100962501_REALK,  &
    0.0185387599806349431807995_REALK,  0.0178091050758187666169796_REALK,  &
    0.0171347041539430290646440_REALK,  0.0165095106151409501404892_REALK,  &
    0.0159283289839908526186463_REALK,  0.0153866702574977452094851_REALK,  &
    0.0148806357819127408476101_REALK,                                      &
    0.9521719302734491519046856_REALK,  0.3048798461613036470119198_REALK,  &
    0.1797718735295084357961315_REALK,  0.1271713040749465062351220_REALK,  &
    0.0983038403318936826469354_REALK,  0.0800886218732861920877042_REALK,  &
    0.0675562139369726699644758_REALK,  0.0584093491852886795290267_REALK,  &
    0.0514408711809167459860781_REALK,  0.0459561121684117640517897_REALK,  &
    0.0415271825825492824080243_REALK,  0.0378761926949267788145015_REALK,  &
    0.0348148518608613136149366_REALK,  0.0322110669882515951445434_REALK,  &
    0.0299694408591142380515748_REALK,  0.0280193616308478318788211_REALK,  &
    0.0263074471040617464956402_REALK,  0.0247925933632726740174501_REALK,  &
    0.0234426376316655797615862_REALK,  0.0222320531552067796043914_REALK,  &
    0.0211403220933575088091860_REALK,  0.0201507646753292489483211_REALK,  &
    0.0192496820469973198286517_REALK,  0.0184257189660683474985436_REALK,  &
    0.0176693832671521826316319_REALK,  0.0169726788847076939803493_REALK,  &
    0.0163288223167345966646558_REALK,  0.0157320212062268122155118_REALK,  &
    0.0151772997247058682307452_REALK,  0.0146603596105025456297621_REALK,  &
    0.0141774686486347105407457_REALK,                                      &
    0.9371500287979788179626439_REALK,  0.2960481892999921593734314_REALK,  &
    0.1735345370549857546560446_REALK,  0.1223548304923680468681013_REALK,  &
    0.0943826509214874681541474_REALK,  0.0767827630385134601853636_REALK,  &
    0.0646991008641662201927858_REALK,  0.0558938953904389718152501_REALK,  &
    0.0491941944465071959169400_REALK,  0.0439263812815963369806660_REALK,  &
    0.0396762281808754821432750_REALK,  0.0361750968010021017873257_REALK,  &
    0.0332411833626607630676197_REALK,  0.0307470774713549943601976_REALK,  &
    0.0286008466215032473856095_REALK,  0.0267344973640433955508477_REALK,  &
    0.0250966630183949088173101_REALK,  0.0236478163226194748602893_REALK,  &
    0.0223570455342598228831719_REALK,  0.0211998292240567348665436_REALK,  &
    0.0201564666505585562972236_REALK,  0.0192109489873202657350681_REALK,  &
    0.0183501334419568611078244_REALK,  0.0175631295251904573362367_REALK,  &
    0.0168408365149202432498043_REALK,  0.0161755903828116193166053_REALK,  &
    0.0155608911135129337338645_REALK,  0.0149911898455290411302787_REALK,  &
    0.0144617210653000798775691_REALK,  0.0139683691102574676634607_REALK,  &
    0.0135075610680176969036204_REALK,                                      &
    0.9225620128255850316278952_REALK,  0.2875224595083601952794083_REALK,  &
    0.1675331909073505265439508_REALK,  0.1177303429306965354417258_REALK,  &
    0.0906232348869400600177570_REALK,  0.0736166618221104490649154_REALK,  &
    0.0619649939436205943188440_REALK,  0.0534882763913239120401322_REALK,  &
    0.0470467255969075973109916_REALK,  0.0419871041520468862850990_REALK,  &
    0.0379083916349716582017138_REALK,  0.0345508825259994850620515_REALK,  &
    0.0317390300531631835978530_REALK,  0.0293499365153595988264801_REALK,  &
    0.0272950056866077955808336_REALK,  0.0255087636804569965753853_REALK,  &
    0.0239417820455196696249889_REALK,  0.0225560488614909432358857_REALK,  &
    0.0213218541615723886084588_REALK,  0.0202156418135400230140508_REALK,  &
    0.0192184953133095817734421_REALK,  0.0183150495485612935242514_REALK,  &
    0.0174926950334620412430553_REALK,  0.0167409868687874788251158_REALK,  &
    0.0160511995232050751203356_REALK,  0.0154159871312893638484187_REALK,  &
    0.0148291212486931084368891_REALK,  0.0142852862186510914943582_REALK,  &
    0.0137799179088192915582090_REALK,  0.0133090754625761441276577_REALK,  &
    0.0128693384411741346823321_REALK,                                      &
    0.9083928770327505120008027_REALK,  0.2792910939183877450098237_REALK,  &
    0.1617584351224091721022091_REALK,  0.1132899248838797473526441_REALK,  &
    0.0870187558423999585333064_REALK,  0.0705843031664688397297525_REALK,  &
    0.0593485235823989279446700_REALK,  0.0511876431491141148377721_REALK,  &
    0.0449940442583249833319314_REALK,  0.0401342195163447365557907_REALK,  &
    0.0362199168813887861784195_REALK,  0.0330000563790786086149076_REALK,  &
    0.0303051267284858254213997_REALK,  0.0280165792173849327595381_REALK,  &
    0.0260490303127928445048322_REALK,  0.0243394306487994781240669_REALK,  &
    0.0228402157184406234824436_REALK,  0.0215148300447113270672528_REALK,  &
    0.0203347181386436537398055_REALK,  0.0192772507468279806486233_REALK,  &
    0.0183242640742869340730881_REALK,  0.0174610106067546004549040_REALK,  &
    0.0166753923478742231700789_REALK,  0.0159573916210433465467933_REALK,  &
    0.0152986425122104852808436_REALK,  0.0146921040276646909517044_REALK,  &
    0.0141318078819493604669777_REALK,  0.0136126617693355603938565_REALK,  &
    0.0131302943862360264881683_REALK,  0.0126809322228672253368709_REALK,  &
    0.0122613007790870649771353_REALK,                                      &
    0.8946281826525670499705711_REALK,  0.2713429899055049832057307_REALK,  &
    0.1562012571397159432784463_REALK,  0.1090259942569519330257677_REALK,  &
    0.0835626715427859739770966_REALK,  0.0676799345233716626024645_REALK,  &
    0.0568445571976786412360383_REALK,  0.0489873626444406531921238_REALK,  &
    0.0430319284969966422971233_REALK,  0.0383638496146151974919292_REALK,  &
    0.0346072185128219397820537_REALK,  0.0315192843579220408067876_REALK,  &
    0.0289363578764187459602120_REALK,  0.0267440817025095811665381_REALK,  &
    0.0248601660700683117777299_REALK,  0.0232238947332462919437290_REALK,  &
    0.0217894957313196982462422_REALK,  0.0205218134497677437422247_REALK,  &
    0.0193934014616649642859247_REALK,  0.0183825205184120904489120_REALK,  &
    0.0174717292847907934572049_REALK,  0.0166468727967286622693166_REALK,  &
    0.0158963436294534826709324_REALK,  0.0152105337238470413735447_REALK,  &
    0.0145814218601479361758777_REALK,  0.0140022591836304662743506_REALK,  &
    0.0134673266377646691505099_REALK,  0.0129717458325949858144455_REALK,  &
    0.0125113301057384121439675_REALK,  0.0120824661548108776981669_REALK,  &
    0.0116820191644733135244438_REALK,                                      &
    0.8812540349399244909989193_REALK,  0.2636674861303563432990416_REALK,  &
    0.1508530154442878079557033_REALK,  0.1049312889822491962066309_REALK,  &
    0.0802487210501311026833449_REALK,  0.0648980542694253814683947_REALK,  &
    0.0544481886600496275963046_REALK,  0.0468830081812585328093768_REALK,  &
    0.0411563458540493143367200_REALK,  0.0366722918539976114327139_REALK,  &
    0.0330668739878948111932111_REALK,  0.0301053846376908920690063_REALK,  &
    0.0276297507890642078665078_REALK,  0.0255296546137099913953428_REALK,  &
    0.0237257856681604463455759_REALK,  0.0221596729262697918205749_REALK,  &
    0.0207872683484018883071087_REALK,  0.0195747618270268076978713_REALK,  &
    0.0184957723878767070491147_REALK,  0.0175294153947485494005054_REALK,  &
    0.0166589429494433220735328_REALK,  0.0158707686144187974652819_REALK,  &
    0.0151537554804586447471104_REALK,  0.0144986882312519802656903_REALK,  &
    0.0138978760415047527393417_REALK,  0.0133448499976197808292167_REALK,  &
    0.0128341298037048020391770_REALK,  0.0123610419508987084274976_REALK,  &
    0.0119215765797371746337330_REALK,  0.0115122737617099589468861_REALK,  &
    0.0111301323815619929852305_REALK,                                      &
    0.8682570615644649159037272_REALK,  0.2562543443807685505930749_REALK,  &
    0.1457054239117026583905101_REALK,  0.1009988532630451130156501_REALK,  &
    0.0770709124661582839488361_REALK,  0.0622334006373909121023758_REALK,  &
    0.0521547282105853521327887_REALK,  0.0448703501287073119874194_REALK,  &
    0.0393634447875966103636003_REALK,  0.0350560108526312627641452_REALK,  &
    0.0315956161980228272811999_REALK,  0.0287553205963399574618400_REALK,  &
    0.0263824689933851198875292_REALK,  0.0243706369031751954312703_REALK,  &
    0.0226433830710614202030850_REALK,  0.0211443971544534106699054_REALK,  &
    0.0198312890736441656269751_REALK,  0.0186715420094271042361633_REALK,  &
    0.0176397985646464007525314_REALK,  0.0167159947446005631432886_REALK,  &
    0.0158840482418310703638387_REALK,  0.0151309181036662129121728_REALK,  &
    0.0144459187065276665334901_REALK,  0.0138202113021932502384681_REALK,  &
    0.0132464217570082334191062_REALK,  0.0127183494129297844366100_REALK,  &
    0.0122307427084912823112006_REALK,  0.0117791243647419521106690_REALK,  &
    0.0113596538211556252057077_REALK,  0.0109690179823220389926375_REALK,  &
    0.0106043437058105857739854_REALK,                                      &
    0.8556243918921486724116221_REALK,  0.2490937321795152759040803_REALK,  &
    0.1407505368259126254937286_REALK,  0.0972220244169301472947353_REALK,  &
    0.0740235112058776345556055_REALK,  0.0596809411402653838818466_REALK,  &
    0.0499596928302852988368343_REALK,  0.0429453470810749471375800_REALK,  &
    0.0376495465034910256618694_REALK,  0.0335116308467135470827714_REALK,  &
    0.0301903263749237656121682_REALK,  0.0274661941607642866303163_REALK,  &
    0.0251918059849457476317980_REALK,  0.0232644899110135035258384_REALK,  &
    0.0216105678847308933787641_REALK,  0.0201758089445646000836820_REALK,  &
    0.0189194175688669544155296_REALK,  0.0178101200599754608266956_REALK,  &
    0.0168235423865115071850873_REALK,  0.0159404085882904889004408_REALK,  &
    0.0151452752306940798682211_REALK,  0.0144256247458208562012283_REALK,  &
    0.0137712043576607885697616_REALK,  0.0131735363821033658882076_REALK,  &
    0.0126255502462296644028417_REALK,  0.0121213023526274329272345_REALK,  &
    0.0116557602713579303022051_REALK,  0.0112246346693385037202040_REALK,  &
    0.0108242471009826531774811_REALK,  0.0104514250433660506323097_REALK,  &
    0.0101034178459645587744298_REALK,                                      &
    0.8433436371179779955653544_REALK,  0.2421762061249919384398055_REALK,  &
    0.1359807345404448197800917_REALK,  0.0935944202924886697880780_REALK,  &
    0.0711010287881217728500616_REALK,  0.0572358624660089868041446_REALK,  &
    0.0478587970414656865836278_REALK,  0.0411041374168785722531538_REALK,  &
    0.0360111371569930699410023_REALK,  0.0320359284439952901601956_REALK,  &
    0.0288480273231122436028429_REALK,  0.0262352394589729677465417_REALK,  &
    0.0240551792508117527613631_REALK,  0.0222087917180093692703924_REALK,  &
    0.0206250600052416549479162_REALK,  0.0192517543377479748156755_REALK,  &
    0.0180496128088178248161100_REALK,  0.0169885566459123601990022_REALK,  &
    0.0160451565695035949787872_REALK,  0.0152008933555879341414929_REALK,  &
    0.0144409368067643893718266_REALK,  0.0137532715425961113431264_REALK,  &
    0.0131280599555877574430296_REALK,  0.0125571705645127849187981_REALK,  &
    0.0120338237741966624233525_REALK,  0.0115523223228732700718080_REALK,  &
    0.0111078437145849858586066_REALK,  0.0106962786295611653880622_REALK,  &
    0.0103141038594366865610574_REALK,  0.0099582814612683839827767_REALK,  &
    0.0096261780312256964992068_REALK,                                      &
    0.8314028712140213439596437_REALK,  0.2354926959333289715470272_REALK,  &
    0.1313887097549671090224166_REALK,  0.0901099272340076529186348_REALK,  &
    0.0682982121200224473467344_REALK,  0.0548935608218130074997809_REALK,  &
    0.0458479441215968314127238_REALK,  0.0393430312389433795017268_REALK,  &
    0.0344448604084372708711292_REALK,  0.0306258257078390154493075_REALK,  &
    0.0275658769624299929135169_REALK,  0.0250598167641694694052212_REALK,  &
    0.0229701245682273590131839_REALK,  0.0212012317597159369308990_REALK,  &
    0.0196846845152535837586427_REALK,  0.0183701790402750371467011_REALK,  &
    0.0172199284620836758075146_REALK,  0.0162050026289457110850734_REALK,  &
    0.0153028799325662535207870_REALK,  0.0144957678424363183011803_REALK,  &
    0.0137694248008225997997878_REALK,  0.0131123172830815443862251_REALK,  &
    0.0125150058987331738724613_REALK,  0.0119696911241400968245463_REALK,  &
    0.0114698722837971878868446_REALK,  0.0110100881767022686086310_REALK,  &
    0.0105857174314867383962957_REALK,  0.0101928231456395665399661_REALK,  &
    0.0098280307634617293521817_REALK,  0.0094884311860676008587578_REALK,  &
    0.0091715032366372489791573_REALK,                                      &
    0.8197906126584276753632707_REALK,  0.2290344891518548420261681_REALK,  &
    0.1269674543804220623322010_REALK,  0.0867626885700724659322702_REALK,  &
    0.0656100332534549496310561_REALK,  0.0526496327077528997184785_REALK,  &
    0.0439232177109737109699239_REALK,  0.0376585026781859275035735_REALK,  &
    0.0329475103167484878463611_REALK,  0.0292783835566988240306507_REALK,  &
    0.0263411621663555625683095_REALK,  0.0239374067172702445494004_REALK,  &
    0.0219342905663079783262770_REALK,  0.0202396056897579633415685_REALK,  &
    0.0187873668172683777610743_REALK,  0.0175291237998227468486423_REALK,  &
    0.0164285084872994903426591_REALK,  0.0154576948614366417589228_REALK,  &
    0.0145950333763609409881701_REALK,  0.0138234293571843115666642_REALK,  &
    0.0131292062839787095074318_REALK,  0.0125012929862407199538277_REALK,  &
    0.0119306320364092072888740_REALK,  0.0114097422133830009999267_REALK,  &
    0.0109323902061404677060752_REALK,  0.0104933410306719075016924_REALK,  &
    0.0100881660024948090204067_REALK,  0.0097130933624674682669298_REALK,  &
    0.0093648909036135874472961_REALK,  0.0090407728807317642993890_REALK,  &
    0.0087383255401239107867939_REALK,                                      &
    0.8084958069125837143431568_REALK,  0.2227932165151242926981467_REALK,  &
    0.1227102469671165763109855_REALK,  0.0835470936029810568035359_REALK,  &
    0.0630316795924698858311075_REALK,  0.0504998661005853777261621_REALK,  &
    0.0420808737964497719952206_REALK,  0.0360471825445980442736982_REALK,  &
    0.0315160245554008053292527_REALK,  0.0279907954645739684429451_REALK,  &
    0.0251712928824969067731487_REALK,  0.0228656048150183248413025_REALK,  &
    0.0209454335385801451718812_REALK,  0.0193218104807822525781358_REALK,  &
    0.0179311279926511607518691_REALK,  0.0167267199967695012752245_REALK,  &
    0.0156735829346023591845949_REALK,  0.0147449521789057447912485_REALK,  &
    0.0139200160502110405202902_REALK,  0.0131823500474275955018921_REALK,  &
    0.0125188200416170916651204_REALK,  0.0119187985106366627074959_REALK,  &
    0.0113735944042601157255579_REALK,  0.0108760317144977036035725_REALK,  &
    0.0104201334214166652786249_REALK,  0.0100008813271505615088985_REALK,  &
    0.0096140313523285919616868_REALK,  0.0092559699157206461878067_REALK,  &
    0.0089236011237309609961388_REALK,  0.0086142573294630073871270_REALK,  &
    0.0083256276049345281919933_REALK,                                      &
    0.7975078096149834649963850_REALK,  0.2167608379159792209023294_REALK,  &
    0.1186106406712820332538527_REALK,  0.0804577670769302810693802_REALK,  &
    0.0605585445316646278635098_REALK,  0.0484402320293111296467536_REALK,  &
    0.0403173330542718338920238_REALK,  0.0345058513096793972874110_REALK,  &
    0.0301474779361175643233040_REALK,  0.0267603814486555950657998_REALK,  &
    0.0240537965222941546583613_REALK,  0.0218421161514416838078656_REALK,  &
    0.0200014124947625708539345_REALK,  0.0184458397520332675889598_REALK,  &
    0.0171140803759222380475702_REALK,  0.0159611854404880827706936_REALK,  &
    0.0149534639427431944452840_REALK,  0.0140651715796730660684721_REALK,  &
    0.0132763016983645457808061_REALK,  0.0125710733989813222555298_REALK,  &
    0.0119368732128362405736643_REALK,  0.0113634993235129707483955_REALK,  &
    0.0108426121133598923895747_REALK,  0.0103673282401219243875623_REALK,  &
    0.0099319163631438993344869_REALK,  0.0095315660353603830212688_REALK,  &
    0.0091622100415748829183027_REALK,  0.0088203863083028220121173_REALK,  &
    0.0085031294770934288951292_REALK,  0.0082078849688697157194195_REALK,  &
    0.0079324402815316805842594_REALK,                                      &
    0.7868163704617204823321686_REALK,  0.2109296289653117550955130_REALK,  &
    0.1146624517366960915865093_REALK,  0.0774895591039118092346882_REALK,  &
    0.0581862185063504525062150_REALK,  0.0464668765249577689346872_REALK,  &
    0.0386291735358213969564467_REALK,  0.0330314324052851382429452_REALK,  &
    0.0288390762262852144715009_REALK,  0.0255845823310168023201339_REALK,  &
    0.0229863126075608228959801_REALK,  0.0208647504009729714558041_REALK,  &
    0.0191001844407234500078374_REALK,  0.0176097793130413488027486_REALK,  &
    0.0163344233343087202880994_REALK,  0.0152308203610831069396703_REALK,  &
    0.0142665419227219654463301_REALK,  0.0134168245828770252292550_REALK,  &
    0.0126624351771749670686473_REALK,  0.0119882108989076297672627_REALK,  &
    0.0113820380876094896793749_REALK,  0.0108341234217296782799123_REALK,  &
    0.0103364643857210627975185_REALK,  0.0098824582751420256970798_REALK,  &
    0.0094666092590326850197968_REALK,  0.0090843059846143232177740_REALK,  &
    0.0087316506863157790363505_REALK,  0.0084053264109479677856918_REALK,  &
    0.0081024928030721931476732_REALK,  0.0078207035361768286602091_REALK,  &
    0.0075578403232599488878463_REALK,                                      &
    0.7764116177447979438852599_REALK,  0.2052921681153360156102394_REALK,  &
    0.1108597484689889806075414_REALK,  0.0746375355271872015228141_REALK,  &
    0.0559104804362257692962324_REALK,  0.0445761129278265458286690_REALK,  &
    0.0370131236808034988494676_REALK,  0.0316209858245403499510395_REALK,  &
    0.0275881502466935393802494_REALK,  0.0244609542618015943227228_REALK,  &
    0.0219665876620608116476241_REALK,  0.0199314170320882243225835_REALK,  &
    0.0182397998760603363699317_REALK,  0.0168118029134018999448674_REALK,  &
    0.0155904392430143336895076_REALK,  0.0145340035874654636277592_REALK,  &
    0.0136112819192372239140987_REALK,  0.0127984537565299268113694_REALK,  &
    0.0120770291351905527388322_REALK,  0.0114324388548963182948848_REALK,  &
    0.0108530490542517073226936_REALK,  0.0103294583974084912270097_REALK,  &
    0.0098539877293162270177618_REALK,  0.0094203034532372321302462_REALK,  &
    0.0090231355020136232159000_REALK,  0.0086580633234960950594949_REALK,  &
    0.0083213514997469775757999_REALK,  0.0080098220810959873394719_REALK,  &
    0.0077207544185596719762965_REALK,  0.0074518058289217347853195_REALK,  &
    0.0072009482103870684280289_REALK,                                      &
    0.7662840435206961231529021_REALK,  0.1998413243222760815598349_REALK,  &
    0.1071968406812384422277518_REALK,  0.0718969687031073972915962_REALK,  &
    0.0537272895450847595699706_REALK,  0.0427644145362022082279552_REALK,  &
    0.0354660556431251119957615_REALK,  0.0302717020111261322923291_REALK,  &
    0.0263921502368294133566984_REALK,  0.0233871634919447617118049_REALK,  &
    0.0209924703368621103083402_REALK,  0.0190401207408359939010634_REALK,  &
    0.0174183984992383258938453_REALK,  0.0160501681890886892245529_REALK,  &
    0.0148804896471084885378744_REALK,  0.0138691889030827762707698_REALK,  &
    0.0129862201416478147131262_REALK,  0.0122086694076551198484548_REALK,  &
    0.0115187608485186870205252_REALK,  0.0109024953636623744140932_REALK,  &
    0.0103486996901282091859686_REALK,  0.0098483486414760214311404_REALK,  &
    0.0093940732460386870000812_REALK,  0.0089797979617469957103193_REALK,  &
    0.0086004691452826968062206_REALK,  0.0082518490990318126010461_REALK,  &
    0.0079303579500112249267563_REALK,  0.0076329508944423243507749_REALK,  &
    0.0073570219187391022036548_REALK,  0.0071003275708452669168214_REALK,  &
    0.0068609260773750428349937_REALK,                                      &
    0.7564244893828001581326248_REALK,  0.1945702452254204628534495_REALK,  &
    0.1036682695904002082798456_REALK,  0.0692633286828946564961385_REALK,  &
    0.0516327775398743582524475_REALK,  0.0410284075812463386312423_REALK,  &
    0.0339849789153731304813810_REALK,  0.0289808960238679587384514_REALK,  &
    0.0252486404755359189477915_REALK,  0.0223609813840046425803543_REALK,  &
    0.0200619067587301663779797_REALK,  0.0181889570941222850075647_REALK,  &
    0.0166342051106902963364398_REALK,  0.0153232127961884061206899_REALK,  &
    0.0142030116013605201691350_REALK,  0.0132349015710296353393050_REALK,  &
    0.0123899606565352569248484_REALK,  0.0116461464269274651839314_REALK,  &
    0.0109863692041919508435299_REALK,  0.0103971774213683573750977_REALK,  &
    0.0098678399888749591256643_REALK,  0.0093896926786173218887344_REALK,  &
    0.0089556640663385599782087_REALK,  0.0085599260688077882797131_REALK,  &
    0.0081976325155068818090198_REALK,  0.0078647209501790486807504_REALK,  &
    0.0075577605287503223444046_REALK,  0.0072738339838239723239566_REALK,  &
    0.0070104450820086912019025_REALK,  0.0067654453789425224655152_REALK,  &
    0.0065369757384793744300899_REALK,                                      &
    0.7468241328124272104815873_REALK,  0.1894723458204923272063525_REALK,  &
    0.1002687981450173793085412_REALK,  0.0667322747768222396258508_REALK,  &
    0.0496232411331567480061722_REALK,  0.0393648645134841435044848_REALK,  &
    0.0325670342384417263459362_REALK,  0.0277460019641500334197648_REALK,  &
    0.0241552941454041894542293_REALK,  0.0213802796502142941625912_REALK,  &
    0.0191729360913146344713720_REALK,  0.0173761083730824480997335_REALK,  &
    0.0158855257047271040959924_REALK,  0.0146293507233682101159600_REALK,  &
    0.0135565141797495316428046_REALK,  0.0126297350206479325890330_REALK,  &
    0.0118211722343218774561313_REALK,  0.0111096212805897702480262_REALK,  &
    0.0104786518246015505212432_REALK,  0.0099153381694070622659476_REALK,  &
    0.0094093737177159235407498_REALK,  0.0089524406274551927148453_REALK,  &
    0.0085377529045650383393573_REALK,  0.0081597197669928279301077_REALK,  &
    0.0078136939386101705168342_REALK,  0.0074957809102297367001566_REALK,  &
    0.0072026926251350497504289_REALK,  0.0069316339803580642384140_REALK,  &
    0.0066802138741261880491851_REALK,  0.0064463748268721804760006_REALK,  &
    0.0062283368070088010459706_REALK,                                      &
    0.7374744740842673618175240_REALK,  0.1845412976062440479907423_REALK,  &
    0.0969934017655128682955379_REALK,  0.0642996474840042547826968_REALK,  &
    0.0476951348937498034730176_REALK,  0.0377706975869488287278486_REALK,  &
    0.0312094877834675973882206_REALK,  0.0265645676542490757898740_REALK,  &
    0.0231098884298004889070732_REALK,  0.0204430258073583330513667_REALK,  &
    0.0183236862993584811998282_REALK,  0.0165998396073202443556927_REALK,  &
    0.0151707437415286340576248_REALK,  0.0139670687747911245052412_REALK,  &
    0.0129395751467639066184523_REALK,  0.0120523476880949574618906_REALK,  &
    0.0112785853427560638084781_REALK,  0.0105978891427592081947440_REALK,  &
    0.0099944623263908717591963_REALK,  0.0094558842691938021357556_REALK,  &
    0.0089722558987631491345116_REALK,  0.0085355917800639339448887_REALK,  &
    0.0081393797293304020329385_REALK,  0.0077782565279592985607593_REALK,  &
    0.0074477655728246690627903_REALK,  0.0071441733129796987714077_REALK,  &
    0.0068643285003837347171829_REALK,  0.0066055530519923081472777_REALK,  &
    0.0063655565468681710519783_REALK,  0.0061423686001547571008952_REALK,  &
    0.0059342849037983787588435_REALK,                                      &
    0.7283673237030938718561401_REALK,  0.1797710181840972143429980_REALK,  &
    0.0938372594791873626540735_REALK,  0.0619614607717532822617201_REALK,  &
    0.0458450644109970120720909_REALK,  0.0362429527276789051337680_REALK,  &
    0.0299097255938130177077561_REALK,  0.0254342495552225301980176_REALK,  &
    0.0221102998319358187706563_REALK,  0.0195472788385587653570141_REALK,  &
    0.0175123701066077393229126_REALK,  0.0158584947912194240693395_REALK,  &
    0.0144883165908940361732427_REALK,  0.0133349232155785847597773_REALK,  &
    0.0123508377829737170383595_REALK,  0.0115014600037090571754694_REALK,  &
    0.0107609892804094581242325_REALK,  0.0101098011615599822632383_REALK,  &
    0.0095327077075106902981361_REALK,  0.0090177733999160826494634_REALK,  &
    0.0085554904084762534860475_REALK,  0.0081381922952029096818283_REALK,  &
    0.0077596295434752627154240_REALK,  0.0074146571628670530224037_REALK,  &
    0.0070990013439417394211506_REALK,  0.0068090827977591149994252_REALK,  &
    0.0065418813580142131519635_REALK,  0.0062948310348523517712693_REALK,  &
    0.0060657378267273192803954_REALK,  0.0058527147388056904170339_REALK,  &
    0.0056541299506618746678610_REALK,                                      &
    0.7194947903495531038586819_REALK,  0.1751556612915215749293196_REALK,  &
    0.0907957454328311014402075_REALK,  0.0597138946891749081147260_REALK,  &
    0.0440697797587700709764924_REALK,  0.0347788036738597705621601_REALK,  &
    0.0286652482753932506820416_REALK,  0.0243528079135038877378605_REALK,  &
    0.0211544997058720103677576_REALK,  0.0186911850525089927310685_REALK,  &
    0.0167372811385292953600956_REALK,  0.0151504932739400764718507_REALK,  &
    0.0138367721398126048565347_REALK,  0.0127315365722882149757123_REALK,  &
    0.0117890078577078463717420_REALK,  0.0109758515193372780532899_REALK,  &
    0.0102672294436530163463939_REALK,  0.0096442618528241978725912_REALK,  &
    0.0090923458564335559589642_REALK,  0.0086000118734725853469891_REALK,  &
    0.0081581276897285254223746_REALK,  0.0077593329999195550031321_REALK,  &
    0.0073976302684730620151665_REALK,  0.0070680837835810552544080_REALK,  &
    0.0067665949779377350392640_REALK,  0.0064897324086519228569792_REALK,  &
    0.0062346015053006877820740_REALK,  0.0059987436529931152662254_REALK,  &
    0.0057800571893779914903200_REALK,  0.0055767349632553694233073_REALK,  &
    0.0053872145447889478730996_REALK,                                      &
    0.7108492693138486195891801_REALK,  0.1706896072506861039563830_REALK,  &
    0.0878644207666067628137441_REALK,  0.0575532883003465819959921_REALK,  &
    0.0423661692459266908672433_REALK,  0.0333755463754742132120867_REALK,  &
    0.0274736659241726736968570_REALK,  0.0233181021258510520755003_REALK,  &
    0.0202405499898183661999784_REALK,  0.0178729741311290796224043_REALK,  &
    0.0159967902413543257289508_REALK,  0.0144743263150994352916889_REALK,  &
    0.0132147055562854137678030_REALK,  0.0121555945812224942131907_REALK,  &
    0.0112528507420020032481212_REALK,  0.0104743581691071948464034_REALK,  &
    0.0097962047208835778544511_REALK,  0.0092002266153981705071319_REALK,  &
    0.0086723831778068079939592_REALK,  0.0082016523611041364238972_REALK,  &
    0.0077792625711907382665689_REALK,  0.0073981472944245323802859_REALK,  &
    0.0070525507283549148870860_REALK,  0.0067377378599044312340594_REALK,  &
    0.0064497781263772530416234_REALK,  0.0061853817834528470806510_REALK,  &
    0.0059417746016204508671676_REALK,  0.0057166008223678904318077_REALK,  &
    0.0055078472158467091726597_REALK,  0.0053137830796065911587167_REALK,  &
    0.0051329124102446185493043_REALK,                                      &
    0.7024234313969670573385429_REALK,  0.1663674538147107140328984_REALK,  &
    0.0850390258335768089992257_REALK,  0.0554761329230775770970929_REALK,  &
    0.0407312534405411749705017_REALK,  0.0320305936418722389524838_REALK,  &
    0.0263326932801618146529066_REALK,  0.0223280863127652655364397_REALK,  &
    0.0193665991325156564006882_REALK,  0.0170909553570304066638652_REALK,  &
    0.0152893419693550247639990_REALK,  0.0138285537985060446447561_REALK,  &
    0.0126207762021795805856827_REALK,  0.0116058432777202402697014_REALK,  &
    0.0107411886553022573737026_REALK,  0.0099958696574306456217318_REALK,  &
    0.0093468650080640106048158_REALK,  0.0087766993623690468806497_REALK,  &
    0.0082718723290915868728845_REALK,  0.0078217917264787190090303_REALK,  &
    0.0074180321889912616273310_REALK,  0.0070538091553803755270891_REALK,  &
    0.0067235987284660564747285_REALK,  0.0064228583683133017717681_REALK,  &
    0.0061478185802140419488615_REALK,  0.0058953254281204582262776_REALK,  &
    0.0056627199895803352960866_REALK,  0.0054477450350268637191409_REALK,  &
    0.0052484720265150754114902_REALK,  0.0050632434604655600363099_REALK,  &
    0.0048906269229123658023872_REALK,                                      &
    0.6942102122600064539881259_REALK,  0.1621840073946129723303500_REALK,  &
    0.0823154727499331717588404_REALK,  0.0534790656598666744314663_REALK,  &
    0.0391621794557900707034470_REALK,  0.0307414700261915731227536_REALK,  &
    0.0252401450977289519561619_REALK,  0.0213808050909475612366695_REALK,  &
    0.0185308782039235245275854_REALK,  0.0163435140125719018111550_REALK,  &
    0.0146134512326359516931618_REALK,  0.0132118010966699988423256_REALK,  &
    0.0120537046882299141853379_REALK,  0.0110810862198986326970784_REALK,  &
    0.0102528980397114839739903_REALK,  0.0095393269683160825805901_REALK,  &
    0.0089182088399174710285910_REALK,  0.0083727302627938388762674_REALK,  &
    0.0078899100629899378972487_REALK,  0.0074595689602363242365346_REALK,  &
    0.0070736140058475375017033_REALK,  0.0067255312329754634442791_REALK,  &
    0.0064100192245888356831762_REALK,  0.0061227200278794677301697_REALK,  &
    0.0058600185678162513072675_REALK,  0.0056188910726869449943632_REALK,  &
    0.0053967891050066916364125_REALK,  0.0051915498197473665051294_REALK,  &
    0.0050013257892667058526759_REALK,  0.0048245295977632808581692_REALK,  &
    0.0046597897053933974576001_REALK,                                      &
    0.6862028022029846852092305_REALK,  0.1581342746507751195750302_REALK,  &
    0.0796898382616422762403374_REALK,  0.0515588632082666642464375_REALK,  &
    0.0376562154859166747788990_REALK,  0.0295058069360587052476497_REALK,  &
    0.0241939317225016332912890_REALK,  0.0204743895357886764030386_REALK,  &
    0.0177316971818291674312107_REALK,  0.0156291079426681932262877_REALK,  &
    0.0139677000980756044895559_REALK,  0.0126227560791466048017995_REALK,  &
    0.0115122700646224235265791_REALK,  0.0105801818406185913629125_REALK,  &
    0.0097869070558556908040471_REALK,  0.0091037199903425541913649_REALK,  &
    0.0085092811313805891831885_REALK,  0.0079874135887658161137015_REALK,  &
    0.0075256351707089878810830_REALK,  0.0071141632112369989834888_REALK,  &
    0.0067452239230925605667499_REALK,  0.0064125630373713052995166_REALK,  &
    0.0061110925781759110539393_REALK,  0.0058366316192689400577098_REALK,  &
    0.0055857131332403822318589_REALK,  0.0053554381047741473828583_REALK,  &
    0.0051433639620693848495958_REALK,  0.0049474182754764726641095_REALK,  &
    0.0047658312982650150035902_REALK,  0.0045970827241518233061135_REALK,  &
    0.0044398592885431876001179_REALK,                                      &
    0.6783946363552791902762351_REALK,  0.1542134544334545775967626_REALK,  &
    0.0771583569138419023136777_REALK,  0.0497124359384296457542440_REALK,  &
    0.0362107455812147108198396_REALK,  0.0283213379604735256134251_REALK,  &
    0.0231920548655723292308384_REALK,  0.0196070533252977879934420_REALK,  &
    0.0169674414063788053796955_REALK,  0.0149462642738688554489013_REALK,  &
    0.0133507347363935480882846_REALK,  0.0120601662580922530665362_REALK,  &
    0.0109953071408984866252911_REALK,  0.0101020409217344522834203_REALK,  &
    0.0093421931947227608572515_REALK,  0.0086880852519126312849540_REALK,  &
    0.0081191710241731700897772_REALK,  0.0076198856628957884612463_REALK,  &
    0.0071782265213389071650818_REALK,  0.0067847919099758074654161_REALK,  &
    0.0064321144812318226807735_REALK,  0.0061141892103207910735829_REALK,  &
    0.0058261328936383494428441_REALK,  0.0055639343829002388397420_REALK,  &
    0.0053242685909661996435105_REALK,  0.0051043560770503374618423_REALK,  &
    0.0049018557099848175662160_REALK,  0.0047147816741390305428361_REALK,  &
    0.0045414386200147219274648_REALK,  0.0043803704997246468294536_REALK,  &
    0.0042303198364818314636260_REALK,                                      &
    0.6707793852606290796458666_REALK,  0.1504169300575279033527210_REALK,  &
    0.0747174145099262498881387_REALK,  0.0479368222261495335878578_REALK,  &
    0.0348232646514652355307362_REALK,  0.0271858944032377161659220_REALK,  &
    0.0222326035661439373736226_REALK,  0.0187770890572666500351051_REALK,  &
    0.0162365681948973758497168_REALK,  0.0142935762825715084040068_REALK,  &
    0.0127612625086418254860554_REALK,  0.0115228360647174014191885_REALK,  &
    0.0105017039292078177142864_REALK,  0.0096456241849650556363649_REALK,  &
    0.0089177810000891349212493_REALK,  0.0082915037616511037127376_REALK,  &
    0.0077470098335816195422865_REALK,  0.0072693229015157873051933_REALK,  &
    0.0068469011928472094108411_REALK,  0.0064707089798444715478265_REALK,  &
    0.0061335731448745271082723_REALK,  0.0058297278779509643584222_REALK,  &
    0.0055544864338251970919957_REALK,  0.0053040004925297892096614_REALK,  &
    0.0050750810534832329831700_REALK,  0.0048650632851323797126164_REALK,  &
    0.0046717032579137000858349_REALK,  0.0044930981295273168807380_REALK,  &
    0.0043276238035191757352882_REALK,  0.0041738857609624948480365_REALK,  &
    0.0040306799320654366700079_REALK,                                      &
    0.6633509458403348268973332_REALK,  0.1467402618973016326098247_REALK,  &
    0.0723635418478250497242854_REALK,  0.0462291830302318310086385_REALK,  &
    0.0334913736877309395345570_REALK,  0.0260974010137162044931092_REALK,  &
    0.0213137503341494817521440_REALK,  0.0179828647318377304875625_REALK,  &
    0.0155376036097120834300611_REALK,  0.0136697004055584356990716_REALK,  &
    0.0121980491857269519179185_REALK,  0.0110096242506120302329098_REALK,  &
    0.0100303992052155274694591_REALK,  0.0092099399939863050429389_REALK,  &
    0.0085127398964000167841393_REALK,  0.0079130989490573625660952_REALK,  &
    0.0073919690907826062289954_REALK,  0.0069349399491321975230740_REALK,  &
    0.0065309126903996938401376_REALK,  0.0061712031321194422278653_REALK,  &
    0.0058489206680759370932110_REALK,  0.0055585290808945978652256_REALK,  &
    0.0052955301100123149116161_REALK,  0.0050562316007085623265072_REALK,  &
    0.0048375750282907180668812_REALK,  0.0046370054126061753876908_REALK,  &
    0.0044523719648275790483627_REALK,  0.0042818513291439574616759_REALK,  &
    0.0041238876514964111982819_REALK,  0.0039771453289539357781046_REALK,  &
    0.0038404714199507840322045_REALK,                                      &
    0.6561034327190093939918825_REALK,  0.1431791802878281394395543_REALK,  &
    0.0700934087215291934391814_REALK,  0.0445867967035170689737988_REALK,  &
    0.0322127751928633423994519_REALK,  0.0250538719061377604391261_REALK,  &
    0.0204337474647652700410205_REALK,  0.0172228203920017503003592_REALK,  &
    0.0148691393720268624084602_REALK,  0.0130733533863591506324342_REALK,  &
    0.0116599162948646788845464_REALK,  0.0105194414081983128594899_REALK,  &
    0.0095803801812316020936056_REALK,  0.0087940421625959542401008_REALK,  &
    0.0081261821172087765619008_REALK,  0.0075520347007459725369172_REALK,  &
    0.0070532586762523134457648_REALK,  0.0066159878998655911527815_REALK,  &
    0.0062295492479209207958846_REALK,  0.0058855962407518905288306_REALK,  &
    0.0055775095363159842704048_REALK,  0.0052999732781328166147938_REALK,  &
    0.0050486700428929330228267_REALK,  0.0048200574527223760679107_REALK,  &
    0.0046112020810351438820929_REALK,  0.0044196542399938618800315_REALK,  &
    0.0042433523912716823028868_REALK,  0.0040805493260182099796163_REALK,  &
    0.0039297545497613325243824_REALK,  0.0037896888740804883684288_REALK,  &
    0.0036592483045180279090103_REALK,                                      &
    0.6490311698978618037969568_REALK,  0.1397295787197520011702068_REALK,  &
    0.0679038181764376608251510_REALK,  0.0430070540273540594111701_REALK,  &
    0.0309852688115071842056558_REALK,  0.0240534066590341287505961_REALK,  &
    0.0195909235171000638275896_REALK,  0.0164954649148890894472252_REALK,  &
    0.0142298299152128614880608_REALK,  0.0125033095512383837094594_REALK,  &
    0.0111457385871481240435799_REALK,  0.0100512476048296474362420_REALK,  &
    0.0091506802863833072714250_REALK,  0.0083970278640399485803325_REALK,  &
    0.0077572607295071666771991_REALK,  0.0072075134878290354409347_REALK,  &
    0.0067301250400138186436028_REALK,  0.0063117526018128420825515_REALK,  &
    0.0059421322089987446690706_REALK,  0.0056132417932180794784003_REALK,  &
    0.0053187224815151555590287_REALK,  0.0050534699210832405985583_REALK,  &
    0.0048133401912260698543577_REALK,  0.0045949345657867934553109_REALK,  &
    0.0043954395616637234600610_REALK,  0.0042125064146464703471184_REALK,  &
    0.0040441591100972857503182_REALK,  0.0038887233876565940708658_REALK,  &
    0.0037447713520179170230973_REALK,  0.0036110778344883910119523_REALK,  &
    0.0034865857000499975160146_REALK,                                      &
    0.6421286827611666359061360_REALK,  0.1363875073152765460271496_REALK,  &
    0.0657917010075985686512468_REALK,  0.0414874534597693203630264_REALK,  &
    0.0298067471507972893418614_REALK,  0.0230941865867943900425541_REALK,  &
    0.0187836799496922113306141_REALK,  0.0157993729470437965778373_REALK,  &
    0.0136183895711827346319822_REALK,  0.0119583982088945686012016_REALK,  &
    0.0106544416206796072749130_REALK,  0.0096040501253083290778001_REALK,  &
    0.0087403770488901598445519_REALK,  0.0080180356368183235138414_REALK,  &
    0.0074051677494969495724186_REALK,  0.0068787745801993736144420_REALK,  &
    0.0064218495046747215912464_REALK,  0.0060215530404581678672327_REALK,  &
    0.0056680144834191682756686_REALK,  0.0053535234138649048091230_REALK,  &
    0.0050719710666594121362127_REALK,  0.0048184560946306709619535_REALK,  &
    0.0045890010449587629454138_REALK,  0.0043803449704213365950567_REALK,  &
    0.0041897893906206228401001_REALK,  0.0040150822786841761091736_REALK,  &
    0.0038543295733745649295221_REALK,  0.0037059268994235417329919_REALK,  &
    0.0035685063174366303019591_REALK,  0.0034408943857969854010492_REALK,  &
    0.0033220788306873314313372_REALK,                                      &
    0.6353906904021526802495146_REALK,  0.1331491665733580131991687_REALK,  &
    0.0637541104903941863168981_REALK,  0.0400255965880106714949171_REALK,  &
    0.0286751917833353020537146_REALK,  0.0221744711756715201511625_REALK,  &
    0.0180104879057800433550529_REALK,  0.0151331819771781984906855_REALK,  &
    0.0130335898838054315557189_REALK,  0.0114375011682228099052505_REALK,  &
    0.0101849994539702694978933_REALK,  0.0091769013178355004350939_REALK,  &
    0.0083485900757300553903795_REALK,  0.0076562434825050611555963_REALK,  &
    0.0070691323455594305691374_REALK,  0.0065650923436734540811210_REALK,  &
    0.0061277466473949500358476_REALK,  0.0057447397974408143453418_REALK,  &
    0.0054065790757927686613349_REALK,  0.0051058534563522429278182_REALK,  &
    0.0048366943367652900226394_REALK,  0.0045943952219536622963436_REALK,  &
    0.0043751383797861831750908_REALK,  0.0041757950110721730671570_REALK,  &
    0.0039937769022521654380120_REALK,  0.0038269247522423176927076_REALK,  &
    0.0036734230328296867650051_REALK,  0.0035317343197761633631637_REALK,  &
    0.0034005480985162669579913_REALK,  0.0032787404596143539942110_REALK,  &
    0.0031653420777978105368766_REALK,                                      &
    0.6288120982551425042217375_REALK,  0.1300109013727706042118371_REALK,  &
    0.0617882173336762874349404_REALK,  0.0386191837765532605675212_REALK,  &
    0.0275886694244079216931098_REALK,  0.0212925946769217666609819_REALK,  &
    0.0172698851416269796854586_REALK,  0.0144955895402015689371611_REALK,  &
    0.0124742570435938931322495_REALK,  0.0109395503687574318502085_REALK,  &
    0.0097364324445559664172878_REALK,  0.0087688965386372424298811_REALK,  &
    0.0079744791252032189154964_REALK,  0.0073108670513246220429293_REALK,  &
    0.0067484191243769430651467_REALK,  0.0062657746161392559314240_REALK,  &
    0.0058471627571061897399307_REALK,  0.0054806935811597687693841_REALK,  &
    0.0051572376828995574946091_REALK,  0.0048696716619538093703823_REALK,  &
    0.0046123575330722366150127_REALK,  0.0043807758301476458842605_REALK,  &
    0.0041712620702580539486237_REALK,  0.0039808142031909155358904_REALK,  &
    0.0038069497427220158440597_REALK,  0.0036475982694100100856005_REALK,  &
    0.0035010195112752627577546_REALK,  0.0033657401848984475588311_REALK,  &
    0.0032405047768484050024762_REALK,  0.0031242368085462953082587_REALK,  &
    0.0030160080725105229033922_REALK,                                      &
    0.6223879910213150346010025_REALK,  0.1269691952221468911332636_REALK,  &
    0.0598913048457927268963807_REALK,  0.0372660100020492240924241_REALK,  &
    0.0265453282757660800894595_REALK,  0.0204469628500856190345125_REALK,  &
    0.0165604730914875875047443_REALK,  0.0138853505465977855592996_REALK,  &
    0.0119392694381612093218470_REALK,  0.0104635256186538499328931_REALK,  &
    0.0093078051480101255815702_REALK,  0.0083791721907294485632844_REALK,  &
    0.0076172422681084726858725_REALK,  0.0069811579114237914608920_REALK,  &
    0.0064423264963487320358682_REALK,  0.0059801611590354067024555_REALK,  &
    0.0055794743634752777192154_REALK,  0.0052288238258604725211542_REALK,  &
    0.0049194293565365948550649_REALK,  0.0046444438806297946159551_REALK,  &
    0.0043984508674931076591119_REALK,  0.0041771103737864301308491_REALK,  &
    0.0039769049586750463212703_REALK,  0.0037949541441084249683569_REALK,  &
    0.0036288768198638270655321_REALK,  0.0034766877643731424786522_REALK,  &
    0.0033367188226229456925187_REALK,  0.0032075581603971110682127_REALK,  &
    0.0030880029445152458109081_REALK,  0.0029770221154942831491563_REALK,  &
    0.0028737268312712701927303_REALK,                                      &
    0.6161136258760123718403179_REALK,  0.1240206647465904588045760_REALK,  &
    0.0580607643043631604928834_REALK,  0.0359639608670779264976147_REALK,  &
    0.0255433945286264521556951_REALK,  0.0196360498497325682010217_REALK,  &
    0.0158809140630894081447355_REALK,  0.0133012747314958171274135_REALK,  &
    0.0114275553131918394811350_REALK,  0.0100084524353063857027291_REALK,  &
    0.0088982243127550906397483_REALK,  0.0080069038524944111112625_REALK,  &
    0.0072761141334443226250106_REALK,  0.0066664018979678673487710_REALK,  &
    0.0061501851166228917525136_REALK,  0.0057076221806586910009762_REALK,  &
    0.0053240868342681541350303_REALK,  0.0049885673560057849224014_REALK,  &
    0.0046926192288045415895725_REALK,  0.0044296608519297890615984_REALK,  &
    0.0041944883544955298415591_REALK,  0.0039829341136995996888737_REALK,  &
    0.0037916217771500767240445_REALK,  0.0036177874751693356487892_REALK,  &
    0.0034591473025218405674963_REALK,  0.0033137977053901909729738_REALK,  &
    0.0031801396381812563340930_REALK,  0.0030568201378322768652085_REALK,  &
    0.0029426868289589348283430_REALK,  0.0028367521451428323250865_REALK,  &
    0.0027381649323785029262468_REALK,                                      &
    0.6099844259460110995618720_REALK,  0.1211620544008884803321990_REALK,  &
    0.0562940905210606093445058_REALK,  0.0347110087849126225378882_REALK,  &
    0.0245811690188825031355702_REALK,  0.0188583952492914347365272_REALK,  &
    0.0152299285577818348247359_REALK,  0.0127422242180338842615361_REALK,  &
    0.0109380905389140966471606_REALK,  0.0095733999839222282124407_REALK,  &
    0.0085068369662861902102957_REALK,  0.0076513044919407236649223_REALK,  &
    0.0069503642347373221360707_REALK,  0.0063659175383680381005158_REALK,  &
    0.0058713563982372993579895_REALK,  0.0054475569279599156055638_REALK,  &
    0.0050804330379269607015358_REALK,  0.0047593871128828180161463_REALK,  &
    0.0044762972969118654947840_REALK,  0.0042248370429221575317325_REALK,  &
    0.0040000066977180365190847_REALK,  0.0037978040483696937773539_REALK,  &
    0.0036149881203318837488703_REALK,  0.0034489068927106569795171_REALK,  &
    0.0032973696670435090512463_REALK,  0.0031585511743417375545018_REALK,  &
    0.0030309185970506654847489_REALK,  0.0029131753739606823516706_REALK,  &
    0.0028042174592641379120284_REALK,  0.0027030989356363731984656_REALK,  &
    0.0026090047315554835624662_REALK,                                      &
    0.6039959740456658510154853_REALK,  0.1183902313997826222236043_REALK,  &
    0.0545888775930344696818430_REALK,  0.0335052093278612322935217_REALK,  &
    0.0236570240278244012244180_REALK,  0.0181126011958733477980044_REALK,  &
    0.0146062927097674998683230_REALK,  0.0122071111898625246638961_REALK,  &
    0.0104698964772882863877301_REALK,  0.0091574791095864385009895_REALK,  &
    0.0081328285886227667800252_REALK,  0.0073116227627087696655517_REALK,  &
    0.0066392953732790794402208_REALK,  0.0060790545501189455906976_REALK,  &
    0.0056052310940249957041392_REALK,  0.0051993923436441510585460_REALK,  &
    0.0048479720683217908047680_REALK,  0.0045407709405397879420807_REALK,  &
    0.0042699772647129489305806_REALK,  0.0040295095404782339115757_REALK,  &
    0.0038145642287529951675040_REALK,  0.0036212978954767265082904_REALK,  &
    0.0034465994664064666767878_REALK,  0.0032879242055839910316428_REALK,  &
    0.0031431707887009849820836_REALK,  0.0030105889897016763212534_REALK,  &
    0.0028887094585307391408913_REALK,  0.0027762896706707471637665_REALK,  &
    0.0026722718718916295757571_REALK,  0.0025757500285401410851371_REALK,  &
    0.0024859436147064502449500_REALK,                                      &
    0.5981440066613039618914627_REALK,  0.1157021808561727455044732_REALK,  &
    0.0529428148329764633461814_REALK,  0.0323446977320674053379967_REALK,  &
    0.0227694002219647959051052_REALK,  0.0173973296902676100028629_REALK,  &
    0.0140088358390827710103776_REALK,  0.0116948956678658080865496_REALK,  &
    0.0100220379453436515826414_REALK,  0.0087598404585573289016232_REALK,  &
    0.0077754213689941427747887_REALK,  0.0069871413780660581588355_REALK,  &
    0.0063422421147266844210222_REALK,  0.0058051924078887078700673_REALK,  &
    0.0053512279440955570070093_REALK,  0.0049625817855397909642012_REALK,  &
    0.0046261880287801759870092_REALK,  0.0043322304282833066710334_REALK,  &
    0.0040731954383262051339054_REALK,  0.0038432369953641837452551_REALK,  &
    0.0036377398956474607874534_REALK,  0.0034530131212333098518485_REALK,  &
    0.0032860702441049440339360_REALK,  0.0031344694370275946390669_REALK,  &
    0.0029961950759209727418453_REALK,  0.0028695688708789950788214_REALK,  &
    0.0027531822945537028947405_REALK,  0.0026458445936834566226958_REALK,  &
    0.0025465423539947039388576_REALK,  0.0024544077352709231694405_REALK,  &
    0.0023686932860931433734997_REALK,                                      &
    0.5924244081736952383110406_REALK,  0.1130950011185100079202925_REALK,  &
    0.0513536828701770114991021_REALK,  0.0312276855519709600761402_REALK,  &
    0.0219168037258518147436526_REALK,  0.0167112999865517246333990_REALK,  &
    0.0134364381132353084835618_REALK,  0.0112045833864036041560563_REALK,  &
    0.0095936212703048792671545_REALK,  0.0083796726847265041310253_REALK,  &
    0.0074338725419510311501203_REALK,  0.0066771755593091151187446_REALK,  &
    0.0060585693356842509893490_REALK,  0.0055437389766591575052113_REALK,  &
    0.0051087923858519120740018_REALK,  0.0047366038053419561373869_REALK,  &
    0.0044145888726332361759463_REALK,  0.0041332998070956446581836_REALK,  &
    0.0038855096733035662109890_REALK,  0.0036655986157139342114519_REALK,  &
    0.0034691322987899560897906_REALK,  0.0032925660152644457660809_REALK,  &
    0.0031330329435528807974221_REALK,  0.0029881899687989833466761_REALK,  &
    0.0028561036453042675138658_REALK,  0.0027351646419772621468547_REALK,  &
    0.0026240227202521731672547_REALK,  0.0025215367281856844970667_REALK,  &
    0.0024267357225387195703015_REALK,  0.0023387884382683656742108_REALK,  &
    0.0022569790902510398176994_REALK,                                      &
    0.5868332053088468613921691_REALK,  0.1105658992990156130886703_REALK,  &
    0.0498193499152534483020993_REALK,  0.0301524574579250977113265_REALK,  &
    0.0210978033220223203103583_REALK,  0.0160532861060045210777059_REALK,  &
    0.0128880283126352052081032_REALK,  0.0107352237645894424411530_REALK,  &
    0.0091837924323475862015131_REALK,  0.0080162007373635758150643_REALK,  &
    0.0071074727992681092578198_REALK,  0.0063810715551543689683101_REALK,  &
    0.0057876708370401420272744_REALK,  0.0052941292078623842717877_REALK,  &
    0.0048773953236433912478143_REALK,  0.0045209609839707122838637_REALK,  &
    0.0042127052976452493415760_REALK,  0.0039435348974550758077706_REALK,  &
    0.0037064983709398425550108_REALK,  0.0034961932075695204696908_REALK,  &
    0.0033083587719592213310937_REALK,  0.0031395908088919341656642_REALK,  &
    0.0029871372688979060637526_REALK,  0.0028487497255772075040181_REALK,  &
    0.0027225735355110311855520_REALK,  0.0026070654731095866535329_REALK,  &
    0.0025009311608584928326993_REALK,  0.0024030769696472219741634_REALK,  &
    0.0023125726375276822732729_REALK,  0.0022286219252605193180683_REALK,  &
    0.0021505393660450496627623_REALK,                                      &
    0.5813665618077853425305079_REALK,  0.1081121869847183197821394_REALK,  &
    0.0483377681815483212224294_REALK,  0.0291173681707545817243243_REALK,  &
    0.0203110277725081465882706_REALK,  0.0154221144602503038023578_REALK,  &
    0.0123625816951759264633592_REALK,  0.0102859079683232518265257_REALK,  &
    0.0087917352910120739883926_REALK,  0.0076686842264437442284741_REALK,  &
    0.0067955447741706977507481_REALK,  0.0060982052288576201262704_REALK,  &
    0.0055289680209833526325358_REALK,  0.0050558238956017092016748_REALK,  &
    0.0046565319552904728059306_REALK,  0.0043151788209133436213794_REALK,  &
    0.0040200896918178132335986_REALK,  0.0037625121061606479552775_REALK,  &
    0.0035357595214248584494787_REALK,  0.0033346382602842993339576_REALK,  &
    0.0031550545064163290284731_REALK,  0.0029937388347842700496437_REALK,  &
    0.0028480493307503902504496_REALK,  0.0027158283977375134894683_REALK,  &
    0.0025952969581781986513347_REALK,  0.0024849751574968293246770_REALK,  &
    0.0023836221532184554555700_REALK,  0.0022901898481583111456816_REALK,  &
    0.0022037869477234436725588_REALK,  0.0021236507550552357129203_REALK,  &
    0.0020491248313401293733305_REALK,                                      &
    0.5760207733063745783042009_REALK,  0.1057312761236456344349222_REALK,  &
    0.0469069704565006906360480_REALK,  0.0281208395273112518597536_REALK,  &
    0.0195551632565556486598179_REALK,  0.0148166615787879551308093_REALK,  &
    0.0118591179555303880693851_REALK,  0.0098557670589911623021395_REALK,  &
    0.0084166698914849326362830_REALK,  0.0073364158620249520642576_REALK,  &
    0.0064974415945773080285908_REALK,  0.0058279807099521612617776_REALK,  &
    0.0052819086287649768055030_REALK,  0.0048283084901797924948230_REALK,  &
    0.0044457206528454645474979_REALK,  0.0041188046750420754041344_REALK,  &
    0.0038363151281751023402578_REALK,  0.0035898274698737808047211_REALK,  &
    0.0033729097916475876510478_REALK,  0.0031805690746878547033039_REALK,  &
    0.0030088717160209397898096_REALK,  0.0028546777260282621586918_REALK,  &
    0.0027154508765638621890781_REALK,  0.0025891207006909834099917_REALK,  &
    0.0024739805841230725833024_REALK,  0.0023686114226584777282814_REALK,  &
    0.0022718236802833175966287_REALK,  0.0021826128847006061838021_REALK,  &
    0.0021001250673181098491127_REALK,  0.0020236296533627990724968_REALK,  &
    0.0019524979968344438521072_REALK,                                      &
    0.5707922624166007485868590_REALK,  0.1034206750788303763588516_REALK,  &
    0.0455250668165836647194311_REALK,  0.0271613576713453409861021_REALK,  &
    0.0188289509194562616756219_REALK,  0.0142358519362759759069315_REALK,  &
    0.0113766992749270001022976_REALK,  0.0094439702249303307535211_REALK,  &
    0.0080578508471312784017249_REALK,  0.0070187199643038204743828_REALK,  &
    0.0062125455022018450865207_REALK,  0.0055698291076387374323731_REALK,  &
    0.0050459655364059130891463_REALK,  0.0046110919662853168399241_REALK,  &
    0.0042445018950753414521682_REALK,  0.0039314067545158006694583_REALK,  &
    0.0036609744062500696078211_REALK,  0.0034250957431973243910717_REALK,  &
    0.0032175836555650822422281_REALK,  0.0030336379320096552685004_REALK,  &
    0.0028694788414471137684425_REALK,  0.0027220906527704851612937_REALK,  &
    0.0025890385571702852728071_REALK,  0.0024683356690664436279559_REALK,  &
    0.0023583448631685089563748_REALK,  0.0022577052740875287566158_REALK,  &
    0.0021652765370217181596646_REALK,  0.0020800959778416142249846_REALK,  &
    0.0020013453820945156097499_REALK,  0.0019283249372269190436563_REALK,  &
    0.0018604326076720628137251_REALK,                                      &
    0.5656775740011072972635020_REALK,  0.1011779848431094419591858_REALK,  &
    0.0441902414796792666895620_REALK,  0.0262374703642592778385367_REALK,  &
    0.0181311845276111091584959_REALK,  0.0136786558751513902254526_REALK,  &
    0.0109144284573612204009008_REALK,  0.0090497230919330540199752_REALK,  &
    0.0077145657948244020923889_REALK,  0.0067149510411328282993848_REALK,  &
    0.0059402665345043587780127_REALK,  0.0053232072829973667987824_REALK,  &
    0.0048206356056816985697355_REALK,  0.0044037057433128409117407_REALK,  &
    0.0040524372492702076531401_REALK,  0.0037525731534854148488400_REALK,  &
    0.0034936791380965454521801_REALK,  0.0032679495292135727312066_REALK,  &
    0.0030694325651461381969376_REALK,  0.0028935133016528731542127_REALK,  &
    0.0027365597916648156870401_REALK,  0.0025956755946638251052183_REALK,  &
    0.0024685232277696948430257_REALK,  0.0023531959840941557571270_REALK,  &
    0.0022481233760046439619507_REALK,  0.0021520003698750757130387_REALK,  &
    0.0020637337262661148429288_REALK,  0.0019824008194131589009890_REALK,  &
    0.0019072176836782978991830_REALK,  0.0018375139667082070107224_REALK,  &
    0.0017727131115175766198216_REALK,                                      &
    0.5606733706331120670185442_REALK,  0.0990008954079920344693022_REALK,  &
    0.0429007497890268874041197_REALK,  0.0253477844105499741655940_REALK,  &
    0.0174607082251702488973066_REALK,  0.0131440876193580184760901_REALK,  &
    0.0104714471483805630913633_REALK,  0.0086722661092335437404977_REALK,  &
    0.0073861339197773961950944_REALK,  0.0064244924299289565480797_REALK,  &
    0.0056800412666171322742525_REALK,  0.0050875966773213099347828_REALK,  &
    0.0046054385878384384092610_REALK,  0.0042057026554067284199179_REALK,  &
    0.0038691084000918936521007_REALK,  0.0035819109334289064329460_REALK,  &
    0.0033340588767546038007072_REALK,  0.0031180384505004694536967_REALK,  &
    0.0029281241599931179774019_REALK,  0.0027598790859990644450117_REALK,  &
    0.0026098132209391123811915_REALK,  0.0024751446474369654532355_REALK,  &
    0.0023536292817532148205495_REALK,  0.0022434373326267282797164_REALK,  &
    0.0021430622165759488466363_REALK,  0.0020512524248240170468560_REALK,  &
    0.0019669598830796548687150_REALK,  0.0018893003378025556831393_REALK,  &
    0.0018175226305514962342469_REALK,  0.0017509846225285650728881_REALK,  &
    0.0016891341518375643446226_REALK,                                      &
    0.5557764282341627337657997_REALK,  0.0968871822801563031823946_REALK,  &
    0.0416549153231367680350061_REALK,  0.0244909631929731870514377_REALK,  &
    0.0168164143877916234803838_REALK,  0.0126312033751483712706865_REALK,  &
    0.0100469341327540789832184_REALK,  0.0083108730075813538190621_REALK,  &
    0.0070719045467308033758869_REALK,  0.0061467550010439802807283_REALK,  &
    0.0054313316105048361007168_REALK,  0.0048625021939977192478310_REALK,  &
    0.0043999160776114938642412_REALK,  0.0040166559689323345916367_REALK,  &
    0.0036941162232834111843471_REALK,  0.0034190452470431180638510_REALK,  &
    0.0031817602851925137590061_REALK,  0.0029750283587375680842413_REALK,  &
    0.0027933415138340542648032_REALK,  0.0026324339005098329295762_REALK,  &
    0.0024889518396813926567890_REALK,  0.0023602233619843247282299_REALK,  &
    0.0022440940158153475925129_REALK,  0.0021388077963079756699250_REALK,  &
    0.0020429194035546261593028_REALK,  0.0019552286426594376461674_REALK,  &
    0.0018747307262954194390092_REALK,  0.0018005781675509689200576_REALK,  &
    0.0017320512345606487586425_REALK,  0.0016685348084464449343323_REALK,  &
    0.0016095000851933875373606_REALK,                                      &
    0.5509836318825066525661782_REALK,  0.0948347031394155409733671_REALK,  &
    0.0404511271263012575638562_REALK,  0.0236657243126807623201380_REALK,  &
    0.0161972415692642549012170_REALK,  0.0121390995151036129584554_REALK,  &
    0.0096401037075039448798197_REALK,  0.0079648493261593265174492_REALK,  &
    0.0067712557944937801224228_REALK,  0.0058811759198007318785728_REALK,  &
    0.0051936236687435376191413_REALK,  0.0046474511314783311863308_REALK,  &
    0.0042036305152308326912869_REALK,  0.0038361584451837406686825_REALK,  &
    0.0035270799021613142079645_REALK,  0.0032636185027159337994351_REALK,  &
    0.0030364463438415003476711_REALK,  0.0028386005811017848976530_REALK,  &
    0.0026647824161618225390080_REALK,  0.0025108903874728194516308_REALK,  &
    0.0023737017575651245433754_REALK,  0.0022506501144488703924917_REALK,  &
    0.0021396670248837912527151_REALK,  0.0020390672694694123717740_REALK,  &
    0.0019474643195289281522725_REALK,  0.0018637071750097695174014_REALK,  &
    0.0017868325359441208140948_REALK,  0.0017160281440138354467490_REALK,  &
    0.0016506043717124188347639_REALK,  0.0015899719771909125252268_REALK,  &
    0.0015336245214068410219060_REALK,                                      &
    0.5462919717851478784709229_REALK,  0.0928413946322497879437563_REALK,  &
    0.0392878370545701530169858_REALK,  0.0228708373297903909404649_REALK,  &
    0.0156021725369267887095770_REALK,  0.0116669108416884437229299_REALK,  &
    0.0092502041269348356244961_REALK,  0.0076335310052507735975591_REALK,  &
    0.0064835932909725890738173_REALK,  0.0056272174645270126719376_REALK,  &
    0.0049664266404229008219917_REALK,  0.0044419921649963998652733_REALK,  &
    0.0040161642342036911815240_REALK,  0.0036638214462387311276537_REALK,  &
    0.0033676360849093610327909_REALK,  0.0031152895676945999148266_REALK,  &
    0.0028977955949267557474169_REALK,  0.0027084512017367962793957_REALK,  &
    0.0025421586873779463203182_REALK,  0.0023949745618170219588206_REALK,  &
    0.0022638018573929471859152_REALK,  0.0021461755058423794342848_REALK,  &
    0.0020401096254646371337682_REALK,  0.0019439869044020436847364_REALK,  &
    0.0018564771765994291310986_REALK,  0.0017764766058948066890927_REALK,  &
    0.0017030616553470217296867_REALK,  0.0016354538218987853953612_REALK,  &
    0.0015729923161068898491977_REALK,  0.0015151126788384241574070_REALK,  &
    0.0014613298855136063782167_REALK,                                      &
    0.5416985394069586678966743_REALK,  0.0909052692952559415751068_REALK,  &
    0.0381635572322774480058527_REALK,  0.0221051216000458690402741_REALK,  &
    0.0150302323919937180080053_REALK,  0.0112138089268216164379188_REALK,  &
    0.0088765161164480049782455_REALK,  0.0073162830417001440200253_REALK,  &
    0.0062083489459508279031952_REALK,  0.0053843658980413378056795_REALK,  &
    0.0047492717767906658665744_REALK,  0.0042456943747942715167154_REALK,  &
    0.0038371185527677018761716_REALK,  0.0034992740819685696530839_REALK,  &
    0.0032154380807839573648554_REALK,  0.0029737330081533439908592_REALK,  &
    0.0027655014218824695675092_REALK,  0.0025842903766604588371159_REALK,  &
    0.0024251955258752250915721_REALK,  0.0022844251874961129036845_REALK,  &
    0.0021590031982735447685373_REALK,  0.0020465617898161106436028_REALK,  &
    0.0019451943060665389997194_REALK,  0.0018533485827140375006017_REALK,  &
    0.0017697485071385536149757_REALK,  0.0016933354605170346848103_REALK,  &
    0.0016232240167087374094895_REALK,  0.0015586680165510910425070_REALK,  &
    0.0014990342959132550541834_REALK,  0.0014437821305687806219126_REALK,  &
    0.0013924470004716580848192_REALK,                                      &
    0.5372005237504814401106046_REALK,  0.0890244126031053406578053_REALK,  &
    0.0370768576144196310151457_REALK,  0.0213674442034161894687916_REALK,  &
    0.0144804867710729822521953_REALK,  0.0107790005241005758251926_REALK,  &
    0.0085183514520716513418463_REALK,  0.0070124982043456626085165_REALK,  &
    0.0059449797790098570307582_REALK,  0.0051521303901603159383638_REALK,  &
    0.0045417113843677246395880_REALK,  0.0040581463187285239310742_REALK,  &
    0.0036661129070042724857614_REALK,  0.0033421623963025216992595_REALK,  &
    0.0030701550934296439887561_REALK,  0.0028386383644473617109127_REALK,  &
    0.0026392713622181446925241_REALK,  0.0024658416805509114980155_REALK,  &
    0.0023136308855670412523708_REALK,  0.0021789931830089662168071_REALK,  &
    0.0020590684467337787115493_REALK,  0.0019515823272598254584098_REALK,  &
    0.0018547042034305280533424_REALK,  0.0017669444115462474946543_REALK,  &
    0.0016870786785269222072398_REALK,  0.0016140917372088603703312_REALK,  &
    0.0015471346890994870301728_REALK,  0.0014854923669113486751903_REALK,  &
    0.0014285580703443912474471_REALK,  0.0013758138067875044611987_REALK,  &
    0.0013268146896402508837925_REALK,                                      &
    0.5327952077803301822456206_REALK,  0.0871969801358302987193127_REALK,  &
    0.0360263636503889150830560_REALK,  0.0206567179606632414512468_REALK,  &
    0.0139520401253232055605036_REALK,  0.0103617260504677878574231_REALK,  &
    0.0081750516027766263749132_REALK,  0.0067215958067295290129239_REALK,  &
    0.0056929668000968757304858_REALK,  0.0049300419889089005381910_REALK,  &
    0.0043433178733659665374245_REALK,  0.0038789551472180349746266_REALK,  &
    0.0035027840236953318268920_REALK,  0.0031921485909347153443749_REALK,  &
    0.0029314714895863364790829_REALK,  0.0027097094599197453328177_REALK,  &
    0.0025188264522797141654886_REALK,  0.0023528414839247028741975_REALK,  &
    0.0022072148824407019848670_REALK,  0.0020784410546935781077815_REALK,  &
    0.0019637713344565622779203_REALK,  0.0018610210664696754962605_REALK,  &
    0.0017684326033521702119244_REALK,  0.0016845762434751546630929_REALK,  &
    0.0016082774307362868865257_REALK,  0.0015385624614432770809747_REALK,  &
    0.0014746174477691597563128_REALK,  0.0014157569191200372431261_REALK,  &
    0.0013613995266363706961726_REALK,  0.0013110490486494456949945_REALK,  &
    0.0012642793980920858688821_REALK,                                      &
    0.5284799649863473058886143_REALK,  0.0854211948604809978569108_REALK,  &
    0.0350107540447580287135132_REALK,  0.0199718995340815545780355_REALK,  &
    0.0134440340738557640581918_REALK,  0.0099612581342503839915148_REALK,  &
    0.0078459864327786055931968_REALK,  0.0064430205345133500713373_REALK,  &
    0.0054518139403612166440927_REALK,  0.0047176526382205390477975_REALK,  &
    0.0041536828493408351967164_REALK,  0.0037077457585940184689455_REALK,  &
    0.0033467851310949388483895_REALK,  0.0030489102847451867925321_REALK,  &
    0.0027990861015500536311540_REALK,  0.0025866637417040951735236_REALK,  &
    0.0024039006024217227965034_REALK,  0.0022450383592901522987473_REALK,  &
    0.0021057092287789388150576_REALK,  0.0019825423564946084709071_REALK,  &
    0.0018728961413962184976573_REALK,  0.0017746720476842802773076_REALK,  &
    0.0016861824649396586501410_REALK,  0.0016060552189879546188672_REALK,  &
    0.0015331634356822085567956_REALK,  0.0014665732608665079609450_REALK,  &
    0.0014055043637855005496384_REALK,  0.0013492997297929777700265_REALK,  &
    0.0012974022960859749823564_REALK,  0.0012493366920648086518947_REALK,  &
    0.0012046948318656179165859_REALK,                                      &
    0.5242522560799179887069954_REALK,  0.0836953445224018904857743_REALK,  &
    0.0340287586109996945116229_REALK,  0.0193119876087801331521199_REALK,  &
    0.0129556458281369704654828_REALK,  0.0095769002266409431617378_REALK,  &
    0.0075305529611532423181486_REALK,  0.0061762413251426435609193_REALK,  &
    0.0052210470309876607156174_REALK,  0.0045145342400150414302606_REALK,  &
    0.0039724162461051209724316_REALK,  0.0035441599930000084600623_REALK,  &
    0.0031977852058713818715618_REALK,  0.0029121398072867918892237_REALK,  &
    0.0026727115618246639720812_REALK,  0.0024692316520378504787758_REALK,  &
    0.0022942400011755907825173_REALK,  0.0021421925149249080623515_REALK,  &
    0.0020088866937572518248101_REALK,  0.0018910811749655897281291_REALK,  &
    0.0017862372030818486276504_REALK,  0.0016923389308451564257141_REALK,  &
    0.0016077659672061785783859_REALK,  0.0015312013304674247388820_REALK,  &
    0.0014615638773202400350210_REALK,  0.0013979579603609177621687_REALK,  &
    0.0013396354130360821604179_REALK,  0.0012859664880372815264076_REALK,  &
    0.0012364173882442744747956_REALK,  0.0011905327133117998231887_REALK,  &
    0.0011479216143070710212659_REALK,                                      &
    0.5201096258180751830124677_REALK,  0.0820177791415816342945888_REALK,  &
    0.0330791562142012454672546_REALK,  0.0186760211510336240903207_REALK,  &
    0.0124860866842888239280907_REALK,  0.0092079852738181037358212_REALK,  &
    0.0072281741762109438104167_REALK,  0.0059207502974150333710512_REALK,  &
    0.0050002128278585139184442_REALK,  0.0043202777586386943708963_REALK,  &
    0.0037991454980209481313846_REALK,  0.0033878558630753420437276_REALK,  &
    0.0030554682545562571356623_REALK,  0.0027815435247658332543197_REALK,  &
    0.0025520736684749071275513_REALK,  0.0023571560286704804944302_REALK,  &
    0.0021896025470655266879916_REALK,  0.0020440752549900679212180_REALK,  &
    0.0019165305891848199125460_REALK,  0.0018038516383250570700864_REALK,  &
    0.0017035984409748353846092_REALK,  0.0016138345454911233803341_REALK,  &
    0.0015330040769464502170560_REALK,  0.0014598430066736871584671_REALK,  &
    0.0013933140515080834863360_REALK,  0.0013325581961926393544798_REALK,  &
    0.0012768581036796159636909_REALK,  0.0012256101553217337973151_REALK,  &
    0.0011783028424066899729483_REALK,  0.0011344998914218900470940_REALK,  &
    0.0010938269586916924379361_REALK,                                      &
    0.5160496999502517390112644_REALK,  0.0803869086097216550834688_REALK,  &
    0.0321607727990046443622418_REALK,  0.0180630777403832896987890_REALK,  &
    0.0120346005803236028725012_REALK,  0.0088538744470305231343277_REALK,  &
    0.0069382979021925215989963_REALK,  0.0056760617287130235575354_REALK,  &
    0.0047888780799749024533196_REALK,  0.0041344923657429429042498_REALK,  &
    0.0036335147498732355691997_REALK,  0.0032385068197367528064490_REALK,  &
    0.0029195326279134957946082_REALK,  0.0026568411970173842415188_REALK,  &
    0.0024369107797597719736182_REALK,  0.0022501915330166988304939_REALK,  &
    0.0020897573067858161814658_REALK,  0.0019504684647532310320939_REALK,  &
    0.0018284342792149216750525_REALK,  0.0017206574484409887723646_REALK,  &
    0.0016247929148000045309480_REALK,  0.0015389804617476918538466_REALK,  &
    0.0014617261368968965939974_REALK,  0.0013918167167582921883717_REALK,  &
    0.0013282569847019962561846_REALK,  0.0012702230483438560568882_REALK,  &
    0.0012170271211749989371392_REALK,  0.0011680906223573044640934_REALK,  &
    0.0011229233955813262228057_REALK,  0.0010811074865431846356301_REALK,  &
    0.0010422843563525807826509_REALK,                                      &
    0.5120701822827481430877583_REALK,  0.0788012003838518687581782_REALK,  &
    0.0312724794991635426932852_REALK,  0.0174722719723121311385938_REALK,  &
    0.0116004627154789111131983_REALK,  0.0085139559280867256607639_REALK,  &
    0.0066603957159563518738987_REALK,  0.0054417110777629819351464_REALK,  &
    0.0045866286396616488818534_REALK,  0.0039568046237656567115648_REALK,  &
    0.0034751841026103790464885_REALK,  0.0030958010514501197937842_REALK,  &
    0.0027896903667147545345661_REALK,  0.0025377653640451408069423_REALK,  &
    0.0023269732366916367517773_REALK,  0.0021481041047673463464940_REALK,  &
    0.0019944839985138987543956_REALK,  0.0018611641197502210281350_REALK,  &
    0.0017444007129053806792740_REALK,  0.0016413114346709664365803_REALK,  &
    0.0015496423958207610968585_REALK,  0.0014676065814213754435330_REALK,  &
    0.0013937694732261344914004_REALK,  0.0013269665928912243498677_REALK,  &
    0.0012662430706000182487059_REALK,  0.0012108086901714552093695_REALK,  &
    0.0011600039900579771703915_REALK,  0.0011132743821837792329993_REALK,  &
    0.0010701501661553329460691_REALK,  0.0010302309335251170520353_REALK,  &
    0.0009931732795818990541109_REALK,                                      &
    0.5081688518561892076164099_REALK,  0.0772591772725011588507371_REALK,  &
    0.0304131908252662785940856_REALK,  0.0169027539284574528088978_REALK,  &
    0.0111829782289440352732734_REALK,  0.0081876437478074527709371_REALK,  &
    0.0063939619114321416537550_REALK,  0.0052172540508788846011501_REALK,  &
    0.0043930686126696606372266_REALK,  0.0037868577062630153287626_REALK,  &
    0.0033238288933161047079834_REALK,  0.0029594408154586032341782_REALK,  &
    0.0026656665774772072413645_REALK,  0.0024240607607623745542447_REALK,  &
    0.0022220228122290927239013_REALK,  0.0020506704417307826913974_REALK,  &
    0.0019035724991901491458951_REALK,  0.0017759638177699201173898_REALK,  &
    0.0016642419785619405776800_REALK,  0.0015656351285354868415473_REALK,  &
    0.0014779769600765252108437_REALK,  0.0013995507482551187289355_REALK,  &
    0.0013289790214470627565529_REALK,  0.0012651440706246980943961_REALK,  &
    0.0012071297238861759728440_REALK,  0.0011541780545747332489825_REALK,  &
    0.0011056567516743098181925_REALK,  0.0010610342186960161365433_REALK,  &
    0.0010198603525167200620910_REALK,  0.0009817515500033320487855_REALK,  &
    0.0009463788986041358694545_REALK,                                      &
    0.5043435602314387811162533_REALK,  0.0757594153105957957006211_REALK,  &
    0.0295818629273205610519248_REALK,  0.0163537077114564964597232_REALK,  &
    0.0107814809353885820986108_REALK,  0.0078743766751055554314886_REALK,  &
    0.0061385125097162011528762_REALK,  0.0050022657097410936841153_REALK,  &
    0.0042078195463754238664356_REALK,  0.0036243106534196906955148_REALK,  &
    0.0031791390078516942180320_REALK,  0.0028291417995036042404289_REALK,  &
    0.0025471988367864835042798_REALK,  0.0023154837586330523357958_REALK,  &
    0.0021218321858713744265668_REALK,  0.0019576775037343577268167_REALK,  &
    0.0018168223746501622941490_REALK,  0.0016946783325985572288969_REALK,  &
    0.0015877788788476725635040_REALK,  0.0014934583582499470939819_REALK,  &
    0.0014096346006473017484217_REALK,  0.0013346583764458938396735_REALK,  &
    0.0012672069698848687033937_REALK,  0.0012062075461592193514893_REALK,  &
    0.0011507810502698681554001_REALK,  0.0011002005158933405963573_REALK,  &
    0.0010538596571159359726461_REALK,  0.0010112489098801189131571_REALK,  &
    0.0009719369459237511789038_REALK,  0.0009355562582981367166640_REALK,  &
    0.0009017918119543664665083_REALK,                                      &
    0.5005922288796277319633532_REALK,  0.0743005417194240597167365_REALK,  &
    0.0287774919290379183056672_REALK,  0.0158243500416473149849939_REALK,  &
    0.0103953321148180805738592_REALK,  0.0075736171544625923920946_REALK,  &
    0.0058935843127783070494186_REALK,  0.0047963396188486964039077_REALK,  &
    0.0040305196543589574126321_REALK,  0.0034688376611412079751628_REALK,  &
    0.0030408182246790334442299_REALK,  0.0027046325126424300248906_REALK,  &
    0.0024340366228910010303055_REALK,  0.0022118018329728393600586_REALK,  &
    0.0020261844424796188017524_REALK,  0.0018689220394702359649697_REALK,  &
    0.0017340424315469807510504_REALK,  0.0016171271885097370044765_REALK,  &
    0.0015148405256885900341951_REALK,  0.0014246188621863679815011_REALK,  &
    0.0013444608580536557013857_REALK,  0.0012727820965670506598438_REALK,  &
    0.0012083124198757674155891_REALK,  0.0011500220497162125937729_REALK,  &
    0.0010970675320526404074306_REALK,  0.0010487515867932976562638_REALK,  &
    0.0010044928746420962208108_REALK,  0.0009638029450640337976799_REALK,  &
    0.0009262684569477509614888_REALK,  0.0008915373204722030001101_REALK,  &
    0.0008593077896260764569902_REALK,                                      &
    0.4969128466721304815401083_REALK,  0.0728812329481568904610000_REALK,  &
    0.0279991123307924104357536_REALK,  0.0153139289129684240398088_REALK,  &
    0.0100239193543905022454332_REALK,  0.0072848502896704359077518_REALK,  &
    0.0056587339988414643923709_REALK,  0.0045990870308679314415468_REALK,  &
    0.0038608230757195632042167_REALK,  0.0033201274022055886868399_REALK,  &
    0.0029085835884432751849427_REALK,  0.0025856537038307907810930_REALK,  &
    0.0023259407733145754347548_REALK,  0.0021127930547268918178017_REALK,  &
    0.0019348725942045419314702_REALK,  0.0017842101352216453453298_REALK,  &
    0.0016550502900504976497992_REALK,  0.0015431382545336436162842_REALK,  &
    0.0014452639540516475959164_REALK,  0.0013589619203795461239992_REALK,  &
    0.0012823084679426438505651_REALK,  0.0012137814180791200828480_REALK,  &
    0.0011521610619103807553881_REALK,  0.0010964589342595913723510_REALK,  &
    0.0010458657284908117173633_REALK,  0.0009997126294342734056236_REALK,  &
    0.0009574422109015656061695_REALK,  0.0009185862555201774895877_REALK,  &
    0.0008827486548471782587533_REALK,  0.0008495920859242983092310_REALK,  &
    0.0008188275283832541955389_REALK,                                      &
    0.4933034674664972807356378_REALK,  0.0715002127935645964695865_REALK,  &
    0.0272457954783577246948845_REALK,  0.0148217223055156274019728_REALK,  &
    0.0096666554399316186041435_REALK,  0.0070075828718007011214342_REALK,  &
    0.0054335372575821513571603_REALK,  0.0044101361081790120197144_REALK,  &
    0.0036983991675627277996574_REALK,  0.0031778823780200192959666_REALK,  &
    0.0027821648119587690482779_REALK,  0.0024719578069990460339467_REALK,  &
    0.0022226829672917450958503_REALK,  0.0020182456055958183926968_REALK,  &
    0.0018476991244518825661253_REALK,  0.0017033567844547256239784_REALK,  &
    0.0015796719763581435792832_REALK,  0.0014725473575839076283145_REALK,  &
    0.0013788937537138519235508_REALK,  0.0012963400032336759061524_REALK,  &
    0.0012230370252496922632568_REALK,  0.0011575224076503679102729_REALK,  &
    0.0010986248669723505493045_REALK,  0.0010453955788437725715756_REALK,  &
    0.0009970579902566947642917_REALK,  0.0009529705802442272645492_REALK,  &
    0.0009125988453039498085606_REALK,  0.0008754939577887882505916_REALK,  &
    0.0008412763192608950241907_REALK,  0.0008096227509254090614135_REALK,  &
    0.0007802564186602000458753_REALK,                                      &
    0.4897622077845121824068997_REALK,  0.0701562505947102982295505_REALK,  &
    0.0265166480946507354676811_REALK,  0.0143470369523261680883008_REALK,  &
    0.0093229772949870171050435_REALK,  0.0067413424494557764102276_REALK,  &
    0.0052175879633824043257739_REALK,  0.0042291311790007774309985_REALK,  &
    0.0035429318291633721087208_REALK,  0.0030418182995954777189662_REALK,  &
    0.0026613037053043585994372_REALK,  0.0023633084114102107485544_REALK,  &
    0.0021240452318857169777822_REALK,  0.0019279573154339006788721_REALK,  &
    0.0017644755528670424526289_REALK,  0.0016261854773090991897050_REALK,  &
    0.0015077415340962155472504_REALK,  0.0014051979135638941950659_REALK,  &
    0.0013155817181829021662864_REALK,  0.0012366124366251581186138_REALK,  &
    0.0011665126640648267562772_REALK,  0.0011038773825455803524742_REALK,  &
    0.0010475817923583752126759_REALK,  0.0009967151059001447873514_REALK,  &
    0.0009505321873344640482353_REALK,  0.0009084176876598498663259_REALK,  &
    0.0008698590769196194987661_REALK,  0.0008344261091209042441319_REALK,  &
    0.0008017550036380517979734_REALK,  0.0007715361295316080624679_REALK,  &
    0.0007435043224998298758838_REALK,                                      &
    0.4862872445787074782153070_REALK,  0.0688481594995362239375325_REALK,  &
    0.0258108108718287272698166_REALK,  0.0138892071580648725909191_REALK,  &
    0.0089923449653433774886313_REALK,  0.0064856764394413011706741_REALK,  &
    0.0050104973849434365426592_REALK,  0.0040557320265450155782894_REALK,  &
    0.0033941188563774240573301_REALK,  0.0029116634964144855711454_REALK,  &
    0.0025457536307927925572914_REALK,  0.0022594797561425483158060_REALK,  &
    0.0020298194707010159057448_REALK,  0.0018417352208928464921828_REALK,  &
    0.0016850220203668804866415_REALK,  0.0015525278090642679988675_REALK,  &
    0.0014391006537338973253481_REALK,  0.0013409405756148412656309_REALK,  &
    0.0012551865099688897485508_REALK,  0.0011796450826348885143613_REALK,  &
    0.0011126077524674579666275_REALK,  0.0010527246183759692444576_REALK,  &
    0.0009989155012991449492099_REALK,  0.0009503061118060867869597_REALK,  &
    0.0009061814497175314873229_REALK,  0.0008659512622211462760241_REALK,  &
    0.0008291240833163028437283_REALK,  0.0007952874744680237797598_REALK,  &
    0.0007640928098491334618733_REALK,  0.0007352434353350750708550_REALK,  &
    0.0007084853620073130325840_REALK,                                      &
    0.4828768130838127503601243_REALK,  0.0675747948003898035729264_REALK,  &
    0.0251274571212014297127979_REALK,  0.0134475936673889556044470_REALK,  &
    0.0086742406470428357057045_REALK,  0.0062401512760826578080087_REALK,  &
    0.0048118934296468565334215_REALK,  0.0038896132097225918217154_REALK,  &
    0.0032516713249392259488246_REALK,  0.0027871583519283125301991_REALK,  &
    0.0024352789826360674886596_REALK,  0.0021602562475935504181235_REALK,  &
    0.0019398070141532918093941_REALK,  0.0017593951443321948196336_REALK,  &
    0.0016091668932923174854116_REALK,  0.0014822231067026466790060_REALK,  &
    0.0013735983191730529676816_REALK,  0.0012796328987076863430844_REALK,  &
    0.0011975733414438659730356_REALK,  0.0011253100351792388877925_REALK,  &
    0.0010612006016288255249441_REALK,  0.0010039480705366669519019_REALK,  &
    0.0009525150957328228432108_REALK,  0.0009060624101117159762478_REALK,  &
    0.0008639039203046414800921_REALK,  0.0008254734384375732097680_REALK,  &
    0.0007902996907690626677070_REALK,  0.0007579873044728080823743_REALK,  &
    0.0007282021734491967964245_REALK,  0.0007006600735399308487253_REALK,  &
    0.0006751177178205996533278_REALK,                                      &
    0.4795292047497636822583900_REALK,  0.0663350523356594778956463_REALK,  &
    0.0244657914785273711277824_REALK,  0.0130215825808644679317805_REALK,  &
    0.0083681677560009243288519_REALK,  0.0060043515974870613483017_REALK,  &
    0.0046214199211212954321315_REALK,  0.0037304634139898227261634_REALK,  &
    0.0031153130013436315659536_REALK,  0.0026680547644771165916033_REALK,  &
    0.0023296546901821115621578_REALK,  0.0020654319989521336374538_REALK,  &
    0.0018538181903065811730741_REALK,  0.0016807612920626238857402_REALK,  &
    0.0015367463857978681199962_REALK,  0.0014151180727303531384914_REALK,  &
    0.0013110904707158148492507_REALK,  0.0012211390198174339270093_REALK,  &
    0.0011426136705620260503730_REALK,  0.0010734853298432689081010_REALK,  &
    0.0010121751885137917400387_REALK,  0.0009574371086896339005934_REALK,  &
    0.0009082748616133012528606_REALK,  0.0008638827868289085127468_REALK,  &
    0.0008236025194199471507681_REALK,  0.0007868909478705765668874_REALK,  &
    0.0007532961553065731360665_REALK,  0.0007224391239408075541389_REALK,  &
    0.0006939996590895089294271_REALK,  0.0006677054428740906901613_REALK,  &
    0.0006433234371233397018777_REALK,                                      &
    0.4762427652530321076085329_REALK,  0.0651278669548096961205985_REALK,  &
    0.0238250486623681062559044_REALK,  0.0126105843163991839656068_REALK,  &
    0.0080736500374217895492635_REALK,  0.0057778794671279444863932_REALK,  &
    0.0044387359085413784914875_REALK,  0.0035779848309870280857747_REALK,  &
    0.0029847797800704950824113_REALK,  0.0025541156324812176042771_REALK,  &
    0.0022286657436495697741374_REALK,  0.0019748103906345373242948_REALK,  &
    0.0017716719153335735298382_REALK,  0.0016056658710313744583414_REALK,  &
    0.0014676041996354290217891_REALK,  0.0013510664454561033698959_REALK,  &
    0.0012514396836489794645475_REALK,  0.0011653293529544442048290_REALK,  &
    0.0010901849107470427870797_REALK,  0.0010240546672521295707564_REALK,  &
    0.0009654208915451332204474_REALK,  0.0009130862636800608778120_REALK,  &
    0.0008660940261641957883809_REALK,  0.0008236707672151347180492_REALK,  &
    0.0007851847204096024926065_REALK,  0.0007501149029036288922584_REALK,  &
    0.0007180279540821202623538_REALK,  0.0006885605302979711786135_REALK,  &
    0.0006614057655974054598241_REALK,  0.0006363027468713650406859_REALK,  &
    0.0006130282507477147462688_REALK,                                      &
    0.4730158925831752791957285_REALK,  0.0639522110442184571477142_REALK,  &
    0.0232044922832735471540655_REALK,  0.0122140326142463426922768_REALK,  &
    0.0077902307132835420244721_REALK,  0.0055603536292005689006812_REALK,  &
    0.0042635150062519337060829_REALK,  0.0034318925656822082959074_REALK,  &
    0.0028598191459659658662795_REALK,  0.0024451143628048616421311_REALK,  &
    0.0021321067413368646574490_REALK,  0.0018882036507255411331846_REALK,  &
    0.0016931953026984719601344_REALK,  0.0015339487231005833559744_REALK,  &
    0.0014015911805286499630663_REALK,  0.0012899286749656730614172_REALK,  &
    0.0011945148617199864184146_REALK,  0.0011120802983611017666216_REALK,  &
    0.0010401701542856424051453_REALK,  0.0009769071493479415148331_REALK,  &
    0.0009208322386234246313338_REALK,  0.0008707949863032624082670_REALK,  &
    0.0008258765265177164891647_REALK,  0.0007853343935115172621056_REALK,  &
    0.0007485623357932307117210_REALK,  0.0007150605906957667153370_REALK,  &
    0.0006844135865819962272552_REALK,  0.0006562730015620051602157_REALK,  &
    0.0006303447402670448417028_REALK,  0.0006063788140801750978226_REALK,  &
    0.0005841613989366361463576_REALK,                                      &
    0.4698470352016234641290282_REALK,  0.0628070931113292735270548_REALK,  &
    0.0226034137016670536035612_REALK,  0.0118313835837166817649413_REALK,  &
    0.0075174716662426118232720_REALK,  0.0053514087962664271327928_REALK,  &
    0.0040954447623731699695826_REALK,  0.0032919140697903821919656_REALK,  &
    0.0027401896606481799048560_REALK,  0.0023408344012429294772604_REALK,  &
    0.0020397814573281632458124_REALK,  0.0018054324545104141579166_REALK,  &
    0.0016182232902030044361524_REALK,  0.0014654569761080981759455_REALK,  &
    0.0013385649903714348044753_REALK,  0.0012315716140647522697932_REALK,  &
    0.0011401909448126806932017_REALK,  0.0010612739652142689182612_REALK,  &
    0.0009924579085973169335216_REALK,  0.0009319370279688770838944_REALK,  &
    0.0008783086669239356268288_REALK,  0.0008304674173661172418420_REALK,  &
    0.0007875307892034913393939_REALK,  0.0007487860131198127277424_REALK,  &
    0.0007136513134732285369016_REALK,  0.0006816472768385723173673_REALK,  &
    0.0006523753852068959633789_REALK,  0.0006255017133781226200059_REALK,  &
    0.0006007444019254995623211_REALK,  0.0005778639267763201496295_REALK,  &
    0.0005566554653549403213972_REALK,                                      &
    0.4667346902698534250042428_REALK,  0.0616915564247343534143297_REALK,  &
    0.0220211309323892490130703_REALK,  0.0114621147898178576268746_REALK,  &
    0.0072549526583782584371329_REALK,  0.0051506949677697011144573_REALK,  &
    0.0039342260551024389736430_REALK,  0.0031577886002946732590946_REALK,  &
    0.0026256604718564368824985_REALK,  0.0022410687841295704424149_REALK,  &
    0.0019515024287637249694738_REALK,  0.0017263255422251720053867_REALK,  &
    0.0015465982840759883668730_REALK,  0.0014000447109380825209263_REALK,  &
    0.0012783897945195321979583_REALK,  0.0011758682234967797290703_REALK,  &
    0.0010883486301634787401377_REALK,  0.0010127979072049714780179_REALK,  &
    0.0009469418447795605129486_REALK,  0.0008890434651555270033699_REALK,  &
    0.0008377542939191635461976_REALK,  0.0007920121685135451646345_REALK,  &
    0.0007509695199778696666007_REALK,  0.0007139420767274286261372_REALK,  &
    0.0006803715425281118807724_REALK,  0.0006497980182589247963310_REALK,  &
    0.0006218393347838367278199_REALK,  0.0005961753646906824957372_REALK,  &
    0.0005725359723588973855438_REALK,  0.0005506916577770441670672_REALK,  &
    0.0005304462189586045669717_REALK,                                      &
    0.4636774019442062577667230_REALK,  0.0606046777079046819491914_REALK,  &
    0.0214569875939474227766190_REALK,  0.0111057243781173230201542_REALK,  &
    0.0070022705832678546963854_REALK,  0.0049578767780719609770124_REALK,  &
    0.0037795725154859808637975_REALK,  0.0030292667019479386537884_REALK,  &
    0.0025160108447120324744184_REALK,  0.0021456197101127681518828_REALK,  &
    0.0018670905617847279641536_REALK,  0.0016507193541925992228553_REALK,  &
    0.0014781698193246184478561_REALK,  0.0013375726438643025656416_REALK,  &
    0.0012209359634782757098037_REALK,  0.0011226972907746630026687_REALK,  &
    0.0010388741064891796311159_REALK,  0.0009665448703958844436923_REALK,  &
    0.0009035205578560895518792_REALK,  0.0008481303046364947403890_REALK,  &
    0.0007990776991014975376079_REALK,  0.0007553421133151312508516_REALK,  &
    0.0007161095035080666587265_REALK,  0.0006807229459125925356833_REALK,  &
    0.0006486466681387934333711_REALK,  0.0006194394849317757818091_REALK,  &
    0.0005927349005871900347597_REALK,  0.0005682260116428604129410_REALK,  &
    0.0005456539157034905745958_REALK,  0.0005247987149730680943305_REALK,  &
    0.0005054724633498228940701_REALK,                                      &
    0.4606737597347239643319483_REALK,  0.0595455658843792659529193_REALK,  &
    0.0209103519006003379931968_REALK,  0.0107617302361981258956858_REALK,  &
    0.0067590387499495323611609_REALK,  0.0047726328727110160429770_REALK,  &
    0.0036312099754884767134622_REALK,  0.0029061097126842185336959_REALK,  &
    0.0024110297139051948059341_REALK,  0.0020542981311825955770267_REALK,  &
    0.0017863747553032872233958_REALK,  0.0015784576825498151855104_REALK,  &
    0.0014127942356014255072955_REALK,  0.0012779078234630633637003_REALK,  &
    0.0011660797883215532049633_REALK,  0.0010719431619958623685268_REALK,  &
    0.0009916588004269105954130_REALK,  0.0009224125527852973039158_REALK,  &
    0.0008620973381822357242688_REALK,  0.0008091058539708453857184_REALK,  &
    0.0007621917159051452318741_REALK,  0.0007203741881309027542818_REALK,  &
    0.0006828714124483961167913_REALK,  0.0006490527097839183861758_REALK,  &
    0.0006184039152176393130261_REALK,  0.0005905017899875690708111_REALK,  &
    0.0005649948644671533293238_REALK,  0.0005415889093155653016137_REALK,  &
    0.0005200357854247714085513_REALK,  0.0005001247932131603138317_REALK,  &
    0.0004816758932631581965542_REALK,                                      &
    0.4577223969254834434750023_REALK,  0.0585133608723167678022925_REALK,  &
    0.0203806156954879635900824_REALK,  0.0104296691901487083298239_REALK,  &
    0.0065248861973921015028344_REALK,  0.0045946553116472327663034_REALK,  &
    0.0034888759402405683518467_REALK,  0.0027880892909172894957026_REALK,  &
    0.0023105152558675649474007_REALK,  0.0019669233620823157147883_REALK,  &
    0.0017091915417871124480836_REALK,  0.0015093913388094537010586_REALK,  &
    0.0013503343678754123335928_REALK,  0.0012209233414251421251384_REALK,  &
    0.0011137032092080074302531_REALK,  0.0010234954860395949899354_REALK,  &
    0.0009465991347145863909693_REALK,  0.0008803033750326938423544_REALK,  &
    0.0008225799534871697932248_REALK,  0.0007718826768494400957302_REALK,  &
    0.0007270132333498055023091_REALK,  0.0006870292022976527213443_REALK,  &
    0.0006511796254674984260266_REALK,  0.0006188590102294774537156_REALK,  &
    0.0005895739203305261182109_REALK,  0.0005629183278184712955344_REALK,  &
    0.0005385551687030005942741_REALK,  0.0005162023609350900859444_REALK,  &
    0.0004956220785257636155668_REALK,  0.0004766124331930767432305_REALK,  &
    0.0004590009578448910119823_REALK,                                      &
    0.4548219890540113330423821_REALK,  0.0575072324264003023608360_REALK,  &
    0.0198671935230922448722968_REALK,  0.0101090962345936081351327_REALK,  &
    0.0062994570381528225411216_REALK,  0.0044236489983155088956401_REALK,  &
    0.0033523190833948664051067_REALK,  0.0026749869637498822731725_REALK,  &
    0.0022142744800318883875712_REALK,  0.0018833227072710607193778_REALK,  &
    0.0016353847442854708548604_REALK,  0.0014433778365314324770158_REALK,  &
    0.0012906592512285093403424_REALK,  0.0011664980566271560599029_REALK,  &
    0.0010636935563898670085992_REALK,  0.0009772489705729499234049_REALK,  &
    0.0009035962975669690035521_REALK,  0.0008401242618267790434466_REALK,  &
    0.0007848804410571268630123_REALK,  0.0007363773950806064413563_REALK,  &
    0.0006934630069512607046175_REALK,  0.0006552316571990080386681_REALK,  &
    0.0006209620538064220679475_REALK,  0.0005900728753706624288636_REALK,  &
    0.0005620905715215914529720_REALK,  0.0005366256198065651140602_REALK,  &
    0.0005133547672167144667113_REALK,  0.0004920075741969141174328_REALK,  &
    0.0004723560966428323563970_REALK,  0.0004542068870175932954365_REALK,  &
    0.0004373947304038566124586_REALK,                                      &
    0.4519712524474596149204331_REALK,  0.0565263790251702702427394_REALK,  &
    0.0193695217393875240841083_REALK,  0.0097995837948384317828143_REALK,  &
    0.0060824098299609771073326_REALK,  0.0042593311333530481030407_REALK,  &
    0.0032212987645681536233444_REALK,  0.0025665936951605756305428_REALK,  &
    0.0021221228383214527785094_REALK,  0.0018033311046446174382568_REALK,  &
    0.0015648051489581778824428_REALK,  0.0013802810884152800011138_REALK,  &
    0.0012336438391297153450987_REALK,  0.0011145163318522842248182_REALK,  &
    0.0010159433031376333220891_REALK,  0.0009331031493192056686103_REALK,  &
    0.0008625560227275975815064_REALK,  0.0008017864334006718747896_REALK,  &
    0.0007489149095865969526023_REALK,  0.0007025104998076870397097_REALK,  &
    0.0006614654784650205029614_REALK,  0.0006249095738026578302632_REALK,  &
    0.0005921499759669258044700_REALK,  0.0005626285608350249265938_REALK,  &
    0.0005358908556684871494699_REALK,  0.0005115631673145453915327_REALK,  &
    0.0004893354837994673151719_REALK,  0.0004689485243692522939418_REALK,  &
    0.0004501838137030599517815_REALK,  0.0004328559901195111751966_REALK,  &
    0.0004168067843270494682827_REALK,                                      &
    0.4491689428133180950197811_REALK,  0.0555700268019403767483233_REALK,  &
    0.0188870576581096072388277_REALK,  0.0095007210197624591963006_REALK,  &
    0.0058734169740207765875173_REALK,  0.0041014306919233490048016_REALK,  &
    0.0030955845678934724475584_REALK,  0.0024627094732776518698492_REALK,  &
    0.0020338838520503462956035_REALK,  0.0017267907852569705246665_REALK,  &
    0.0014973101924032870563980_REALK,  0.0013199711171547826981526_REALK,  &
    0.0011791687345691997078345_REALK,  0.0010648677825783050502478_REALK,  &
    0.0009703498300307835961603_REALK,  0.0008909621600669714218748_REALK,  &
    0.0008233883797011619896933_REALK,  0.0007652052067222356052795_REALK,  &
    0.0007146033502469331969917_REALK,  0.0006702061715271881913933_REALK,  &
    0.0006309486040497537832558_REALK,  0.0005959943282678984051437_REALK,  &
    0.0005646778801483725608590_REALK,  0.0005364633984804835714968_REALK,  &
    0.0005109147130137055943175_REALK,  0.0004876733115967234037137_REALK,  &
    0.0004664418770201876488293_REALK,  0.0004469718238562142608242_REALK,  &
    0.0004290537498330970213843_REALK,  0.0004125100392349313228879_REALK,  &
    0.0003971890748680436712681_REALK,                                      &
    0.4464138538825274116206288_REALK,  0.0546374285175285842597326_REALK,  &
    0.0184192787316386427654002_REALK,  0.0092121131041524167981649_REALK,  &
    0.0056721641388798055977150_REALK,  0.0039496879236043443833770_REALK,  &
    0.0029749558607491568933134_REALK,  0.0023631429158890524672154_REALK,  &
    0.0019493887554527448806307_REALK,  0.0016535509483195196412525_REALK,  &
    0.0014327636631110943384038_REALK,  0.0012623237794267385195046_REALK,  &
    0.0011271199334628983351747_REALK,  0.0010174470372779642352717_REALK,  &
    0.0009268152000898168896628_REALK,  0.0008507345329231300132961_REALK,  &
    0.0007860075736939242056073_REALK,  0.0007302998059096211646429_REALK,  &
    0.0006818694565426353885323_REALK,  0.0006393921084965469448652_REALK,  &
    0.0006018436904565222693789_REALK,  0.0005684204952452597686685_REALK,  &
    0.0005384833140694550955574_REALK,  0.0005115176522206648073582_REALK,  &
    0.0004871048985342157043588_REALK,  0.0004649011003041444252057_REALK,  &
    0.0004446211115008498102573_REALK,  0.0004260265979154630481759_REALK,  &
    0.0004089168512238612542171_REALK,  0.0003931216761481112070831_REALK,  &
    0.0003784958265300260760351_REALK,                                      &
    0.4437048161029471526894952_REALK,  0.0537278625731088879668995_REALK,  &
    0.0179656817650556653587213_REALK,  0.0089333806392267595120060_REALK,  &
    0.0054783497087595445229624_REALK,  0.0038038538738543021221206_REALK,  &
    0.0028592013717734692315742_REALK,  0.0022677108933757119876851_REALK,  &
    0.0018684761550947863971428_REALK,  0.0015834674507878979728831_REALK,  &
    0.0013710354164029241261918_REALK,  0.0012072205024144901704813_REALK,  &
    0.0010773885797653599393636_REALK,  0.0009721535087021635239066_REALK,  &
    0.0008852459442495497514078_REALK,  0.0008123329883354574480411_REALK,  &
    0.0007503317548116668605357_REALK,  0.0006969931814427893137370_REALK,  &
    0.0006506404525456819902540_REALK,  0.0006099993631396424462188_REALK,  &
    0.0005740852388682309709322_REALK,  0.0005421256985076542420435_REALK,  &
    0.0005135067418281189519438_REALK,  0.0004877343806175258623947_REALK,  &
    0.0004644068498274267985625_REALK,  0.0004431941602730620735802_REALK,  &
    0.0004238228352581010420323_REALK,  0.0004060643662395481629304_REALK,  &
    0.0003897263756694108508515_REALK,  0.0003746457769328121411266_REALK,  &
    0.0003606834257783593901750_REALK,                                      &
    0.4410406953812107677670440_REALK,  0.0528406320615595753720228_REALK,  &
    0.0175257821619930753698213_REALK,  0.0086641589901538997725572_REALK,  &
    0.0052916842552928845463955_REALK,  0.0036636899261127250579384_REALK,  &
    0.0027481187873132245126639_REALK,  0.0021762381682922170116068_REALK,  &
    0.0017909917044561373278971_REALK,  0.0015164025108775163169089_REALK,  &
    0.0013120011022423312772173_REALK,  0.0011545480322943462662272_REALK,  &
    0.0010298707317544721247249_REALK,  0.0009288911756409608082297_REALK,  &
    0.0008455528566964634010900_REALK,  0.0007756742444329204786910_REALK,  &
    0.0007162828360857887615223_REALK,  0.0006652118377621071615077_REALK,  &
    0.0006208469291174780347459_REALK,  0.0005819621860765630079124_REALK,  &
    0.0005476107960314681964709_REALK,  0.0005170504685695067811912_REALK,  &
    0.0004896914074693233627153_REALK,  0.0004650593059231847140912_REALK,  &
    0.0004427685612069261590976_REALK,  0.0004225025763006802471088_REALK,  &
    0.0004039990628250457764190_REALK,  0.0003870389301241600145051_REALK,  &
    0.0003714377835118501413637_REALK,  0.0003570393464301175787644_REALK,  &
    0.0003437103188303644541943_REALK,                                      &
    0.4384203918710842806660821_REALK,  0.0519750638557519503701876_REALK,  &
    0.0170991132009583150785925_REALK,  0.0084040976994195111526853_REALK,  &
    0.0051118900316596401975366_REALK,  0.0035289673636349680983793_REALK,  &
    0.0026415143654927330553461_REALK,  0.0020885570508533376002380_REALK,  &
    0.0017167877930008041287985_REALK,  0.0014522244248790314863351_REALK,  &
    0.0012555419053343274630313_REALK,  0.0011041981941391817555881_REALK,  &
    0.0009844671389762512346555_REALK,  0.0008875683746805998431892_REALK,  &
    0.0008076507996151361832779_REALK,  0.0007406788332525388388050_REALK,  &
    0.0006837863199179193334984_REALK,  0.0006348856688639268816554_REALK,  &
    0.0005924226877461845472070_REALK,  0.0005552178774216391362109_REALK,  &
    0.0005223608123395442979359_REALK,  0.0004931381069663948960718_REALK,  &
    0.0004669832049458486197477_REALK,  0.0004434406892678690952601_REALK,  &
    0.0004221404637155878403557_REALK,  0.0004027787756259867350123_REALK,  &
    0.0003851040638804468217195_REALK,  0.0003689062649592671542208_REALK,  &
    0.0003540086337365631213338_REALK,  0.0003402614177148373430029_REALK,  &
    0.0003275369142817194682490_REALK,                                      &
    0.4358428388065174186039030_REALK,  0.0511305077322873335887721_REALK,  &
    0.0166852253408659410849335_REALK,  0.0081528599149473766904972_REALK,  &
    0.0049387004881549234625027_REALK,  0.0033994669501991540278008_REALK,  &
    0.0025392025671255482981159_REALK,  0.0020045070696183978423144_REALK,  &
    0.0016457232490871631994112_REALK,  0.0013908072966732315349503_REALK,  &
    0.0012015442969549006927560_REALK,  0.0010560676627184972103946_REALK,  &
    0.0009410830293614895871238_REALK,  0.0008480976014970843671406_REALK,  &
    0.0007714585169097589595344_REALK,  0.0007072709254416956843256_REALK,  &
    0.0006527711325526069268202_REALK,  0.0006059478015213085435112_REALK,  &
    0.0005653045916444804580916_REALK,  0.0005297066450103025611607_REALK,  &
    0.0004982785065415233551750_REALK,  0.0004703345568830742001211_REALK,  &
    0.0004453305541720602579552_REALK,  0.0004228292117050660211403_REALK,  &
    0.0004024753107776636519739_REALK,  0.0003839774178468815255330_REALK,  &
    0.0003670942571255533175105_REALK,  0.0003516244177918381058102_REALK,  &
    0.0003373984849743883775164_REALK,  0.0003242729563144560790168_REALK,  &
    0.0003121254903404600865649_REALK,                                      &
    0.4333070013776528783822073_REALK,  0.0503063355292528088802406_REALK,  &
    0.0162836855545667388844855_REALK,  0.0079101218419252092295402_REALK,  &
    0.0047718598082677017233055_REALK,  0.0032749785288620309950391_REALK,  &
    0.0024410057027262456810779_REALK,  0.0019239346566971970292625_REALK,  &
    0.0015776630560968049176579_REALK,  0.0013320307793724330165663_REALK,  &
    0.0011498997979785235534073_REALK,  0.0010100577436981345112038_REALK,  &
    0.0008996279060485057104887_REALK,  0.0008103953212479814453492_REALK,  &
    0.0007368984564868678822577_REALK,  0.0006753781630439514111972_REALK,  &
    0.0006231694662057869977048_REALK,  0.0005783344457754820751999_REALK,  &
    0.0005394324237695971666767_REALK,  0.0005053714692313894312967_REALK,  &
    0.0004753097367674240193366_REALK,  0.0004485882798325173826531_REALK,  &
    0.0004246842828847862219045_REALK,  0.0004031778608386728658501_REALK,  &
    0.0003837280692244784811341_REALK,  0.0003660552900174811178681_REALK,  &
    0.0003499281091610605630947_REALK,  0.0003351534097206893773185_REALK,  &
    0.0003215688011787363044351_REALK,  0.0003090367689558073949208_REALK,  &
    0.0002974401064503894628194_REALK,                                      &
    0.4308118756481242317413205_REALK,  0.0495019403366245974718041_REALK,  &
    0.0158940766892138145294222_REALK,  0.0076755722173323147686230_REALK,  &
    0.0046111224643867231368088_REALK,  0.0031553006379765242452040_REALK,  &
    0.0023467535949123854467635_REALK,  0.0018466928468313446691507_REALK,  &
    0.0015124780811895824437358_REALK,  0.0012757798285410923942729_REALK,  &
    0.0011005047525955988837326_REALK,  0.0009660741647654552200289_REALK,  &
    0.0008600153534675869038476_REALK,  0.0007743817876442845226856_REALK,  &
    0.0007038966007045122531133_REALK,  0.0006449314999944275430058_REALK,  &
    0.0005949166284939838740542_REALK,  0.0005519847523599679924369_REALK,  &
    0.0005147487514430172791599_REALK,  0.0004821579741564149704063_REALK,  &
    0.0004534028775740953087769_REALK,  0.0004278501381024029585724_REALK,  &
    0.0004049975140387570204589_REALK,  0.0003844418227698088953367_REALK,  &
    0.0003658558154408558978077_REALK,  0.0003489712066814722873920_REALK,  &
    0.0003335660381282446319655_REALK,  0.0003194551428951534566628_REALK,  &
    0.0003064828617566526473143_REALK,  0.0002945174166251441597204_REALK,  &
    0.0002834465190959427945833_REALK,                                      &
    0.4283564875120469683800195_REALK,  0.0487167357180056173615590_REALK,  &
    0.0155159968523550084035234_REALK,  0.0074489118062089172342399_REALK,  &
    0.0044562527922897814808278_REALK,  0.0030402401437186815300051_REALK,  &
    0.0022562832555183798786957_REALK,  0.0017726409897340824738804_REALK,  &
    0.0014500448161190589938668_REALK,  0.0012219444664734997827577_REALK,  &
    0.0010532601122349703227921_REALK,  0.0009240268762276625767738_REALK,  &
    0.0008221628522631752684566_REALK,  0.0007399808703035527486860_REALK,  &
    0.0006723823046113729237291_REALK,  0.0006158650499683115519395_REALK,  &
    0.0005679508988256955215324_REALK,  0.0005268406767351403556521_REALK,  &
    0.0004911987972624574233516_REALK,  0.0004600143046719579274090_REALK,  &
    0.0004325087027302434755822_REALK,  0.0004080732826989127352661_REALK,  &
    0.0003862255584769411480978_REALK,  0.0003665783791133129534100_REALK,  &
    0.0003488176363913458887835_REALK,  0.0003326859146090486974399_REALK,  &
    0.0003179703218896572829502_REALK,  0.0003044933119003144137392_REALK,  &
    0.0002921056759433194064887_REALK,  0.0002806811317376081997207_REALK,  &
    0.0002701121015905529510089_REALK,                                      &
    0.4259398916891634079284756_REALK,  0.0479501549624374995284271_REALK,  &
    0.0151490588226873921368076_REALK,  0.0072298529187483804789305_REALK,  &
    0.0043070245836090304686339_REALK,  0.0029296118884046956631906_REALK,  &
    0.0021694385767733405552538_REALK,  0.0017016444750991234404619_REALK,  &
    0.0013902451295681290347611_REALK,  0.0011704195570299154825766_REALK,  &
    0.0010080712292287723891304_REALK,  0.0008838298606515470300093_REALK,  &
    0.0007859916026493760305219_REALK,  0.0007071198900038978135685_REALK,  &
    0.0006422881416167804504228_REALK,  0.0005881159412425327566096_REALK,  &
    0.0005422133914322795414376_REALK,  0.0005028468494260750947314_REALK,  &
    0.0004687303160130099695564_REALK,  0.0004388910093349291069269_REALK,  &
    0.0004125802734722392763056_REALK,  0.0003892130465303387338791_REALK,  &
    0.0003683258126283270642541_REALK,  0.0003495468088457910757136_REALK,  &
    0.0003325745352966594605738_REALK,  0.0003171620020157660366396_REALK,  &
    0.0003031050105352215860363_REALK,  0.0002902333193215983898720_REALK,  &
    0.0002784039012194244292094_REALK,  0.0002674957392216244234096_REALK,  &
    0.0002574057676598704509814_REALK,                                      &
    0.4235611707566725447904332_REALK,  0.0472016503650796240276755_REALK,  &
    0.0147928894844550577053477_REALK,  0.0070181189473328053560208_REALK,  &
    0.0041632206954999740472489_REALK,  0.0028232383539103325133246_REALK,  &
    0.0020860700359234276256293_REALK,  0.0016335744697154805371575_REALK,  &
    0.0013329660304887743643709_REALK,  0.0011211045905550943470319_REALK,  &
    0.0009648476597778058621094_REALK,  0.0008454009511326493692476_REALK,  &
    0.0007514263558127709822718_REALK,  0.0006757294614758003028013_REALK,  &
    0.0006135497562490473425975_REALK,  0.0005616241782462802999143_REALK,  &
    0.0005176479247304391264478_REALK,  0.0004799504523706468392397_REALK,  &
    0.0004472934772980374936412_REALK,  0.0004187409286836208549033_REALK,  &
    0.0003935728319748666229061_REALK,  0.0003712268425850181411546_REALK,  &
    0.0003512576609972304221390_REALK,  0.0003333082947581079914963_REALK,  &
    0.0003170893417415148601846_REALK,  0.0003023638120522463470369_REALK,  &
    0.0002889358430097204452972_REALK,  0.0002766421952914267594868_REALK,  &
    0.0002653457655803063454381_REALK,  0.0002549305813330292953996_REALK,  &
    0.0002452978986401081881383_REALK,                                      &
    0.4212194342163276816748407_REALK,  0.0464706925355976366298627_REALK,  &
    0.0144471292845141513483398_REALK,  0.0068134439226707173634101_REALK,  &
    0.0040246326767757484993426_REALK,  0.0027209493395355965374149_REALK,  &
    0.0020060344127071786171634_REALK,  0.0015683076661505504240807_REALK,  &
    0.0012780994419533920573168_REALK,  0.0010739034784249090314495_REALK,  &
    0.0009235029757960056115071_REALK,  0.0008086616578008696707910_REALK,  &
    0.0007183952529944980002277_REALK,  0.0006457433433856888619490_REALK,  &
    0.0005861057236755777555270_REALK,  0.0005363325094912998851349_REALK,  &
    0.0004942008967229417557010_REALK,  0.0004581011009987077530099_REALK,  &
    0.0004268407536234652814057_REALK,  0.0003995190887499715454503_REALK,  &
    0.0003754436997932269906922_REALK,  0.0003540740668697544830772_REALK,  &
    0.0003349823832194245083922_REALK,  0.0003178258342960980139397_REALK,  &
    0.0003023266260054615034263_REALK,  0.0002882573603635621667211_REALK,  &
    0.0002754301676673953864008_REALK,  0.0002636885208299472450715_REALK,  &
    0.0002529009934748549211572_REALK,  0.0002429564460225037709346_REALK,  &
    0.0002337602741203753903103_REALK,                                      &
    0.4189138175954439935466667_REALK,  0.0457567697331515144121283_REALK,  &
    0.0141114317111302386975602_REALK,  0.0066155720882309842698077_REALK,  &
    0.0038910604098001612578817_REALK,  0.0026225816536860659111685_REALK,  &
    0.0019291945191181234485478_REALK,  0.0015057260424876587733695_REALK,  &
    0.0012255419850471279807208_REALK,  0.0010287243567871640070877_REALK,  &
    0.0008839545852315367890223_REALK,  0.0007735370021872865157336_REALK,  &
    0.0006868296719002394594769_REALK,  0.0006170982951809679453031_REALK,  &
    0.0005598974156731059172165_REALK,  0.0005121863015870449205649_REALK,  &
    0.0004718211661576367297981_REALK,  0.0004372507317760154646816_REALK,  &
    0.0004073268136814879201643_REALK,  0.0003811825995302950756405_REALK,  &
    0.0003581521810433728751806_REALK,  0.0003377160058857143912561_REALK,  &
    0.0003194630654708187356139_REALK,  0.0003030641545833105319173_REALK,  &
    0.0002882526174179883896032_REALK,  0.0002748102565265424191907_REALK,  &
    0.0002625568665683295703321_REALK,  0.0002513423548006828590201_REALK,  &
    0.0002410407352407063265049_REALK,  0.0002315454986881655707366_REALK,  &
    0.0002227660058658888306976_REALK,                                      &
    0.4166434815805158398127617_REALK,  0.0450593872269192743940103_REALK,  &
    0.0137854627936128352333478_REALK,  0.0064242574922024325151382_REALK,  &
    0.0037623117674638589108538_REALK,  0.0025279788187702692016379_REALK,  &
    0.0018554189409145155267161_REALK,  0.0014457166326273763676258_REALK,  &
    0.0011751947723520393771640_REALK,  0.0009854793990824825978408_REALK,  &
    0.0008461235604805382318552_REALK,  0.0007399553590943337352814_REALK,  &
    0.0006566640801030356952572_REALK,  0.0005897339404815157446957_REALK,  &
    0.0005348688727509543806848_REALK,  0.0004891334190594932634574_REALK,  &
    0.0004504599391779960659843_REALK,  0.0004173534949590577622369_REALK,  &
    0.0003887084205916473177503_REALK,  0.0003636905581831765556754_REALK,  &
    0.0003416594701001657882582_REALK,  0.0003221157484293876802767_REALK,  &
    0.0003046645160245908508581_REALK,  0.0002889896314293679061014_REALK,  &
    0.0002748351265486593218712_REALK,  0.0002619916291824577543774_REALK,  &
    0.0002502862833403169296083_REALK,  0.0002395751643104972921153_REALK,  &
    0.0002297374998705626258574_REALK,  0.0002206712171532778103862_REALK,  &
    0.0002122894748667862466554_REALK,                                      &
    0.4144076111821895502806967_REALK,  0.0443780666811359192358566_REALK,  &
    0.0134689006219291355914702_REALK,  0.0062392635962409924432759_REALK,  &
    0.0036382022845971749222538_REALK,  0.0024369907887386746229985_REALK,  &
    0.0017845817903596452799753_REALK,  0.0013881713066838130034297_REALK,  &
    0.0011269632105939037837461_REALK,  0.0009440846369498600253178_REALK,  &
    0.0008099344745268855600903_REALK,  0.0007078483056276863158093_REALK,  &
    0.0006278358951191327684896_REALK,  0.0005635926367171101552395_REALK,  &
    0.0005109666821438797528962_REALK,  0.0004671241097054839230482_REALK,  &
    0.0004300706612106982348193_REALK,  0.0003983656523187180560630_REALK,  &
    0.0003709443348684193482792_REALK,  0.0003470039567339340720598_REALK,  &
    0.0003259285636011779486998_REALK,  0.0003072381015160042497421_REALK,  &
    0.0002905531847621443128707_REALK,  0.0002755702121366905847817_REALK,  &
    0.0002620434710518418450903_REALK,  0.0002497720546909494077938_REALK,  &
    0.0002385901544379774932847_REALK,  0.0002283597583912220011209_REALK,  &
    0.0002189650909521468030543_REALK,  0.0002103083297164276695927_REALK,  &
    0.0002023062713644593023365_REALK,                                      &
    0.4122054149303925885128308_REALK,  0.0437123455636694580039858_REALK,  &
    0.0131614348854755171952524_REALK,  0.0060603629002982635845531_REALK,  &
    0.0035185548432015495076697_REALK,  0.0023494736787152557984382_REALK,  &
    0.0017165624696993766508391_REALK,  0.0013329865610280744545740_REALK,  &
    0.0010807568120421268912518_REALK,  0.0009044597891394105370483_REALK,  &
    0.0007753152444581782546523_REALK,  0.0006771504770639275938918_REALK,  &
    0.0006002853508518240371883_REALK,  0.0005386193507241402150115_REALK,  &
    0.0004881398614041513065939_REALK,  0.0004461108952268352583967_REALK,  &
    0.0004106089138476403787442_REALK,  0.0003802454796020185022638_REALK,  &
    0.0003539952218953498199946_REALK,  0.0003310855940754748542171_REALK,  &
    0.0003109241765554257358115_REALK,  0.0002930495102324861774780_REALK,  &
    0.0002770970864525372067549_REALK,  0.0002627753419272414888395_REALK,  &
    0.0002498484049942135639712_REALK,  0.0002381234891394655005942_REALK,  &
    0.0002274415436390250387557_REALK,  0.0002176702248081324177990_REALK,  &
    0.0002086985456319298830492_REALK,  0.0002004327561289408535499_REALK,  &
    0.0001927931377145703742849_REALK,                                      &
    0.4100361240984644606299980_REALK,  0.0430617765771958010967424_REALK,  &
    0.0128627664302197741719169_REALK,  0.0058873365828554166667708_REALK,  &
    0.0034031993709079996074385_REALK,  0.0022652895061966108608553_REALK,  &
    0.0016512454449052946497262_REALK,  0.0012800633175511077089387_REALK,  &
    0.0010364890142713044374201_REALK,  0.0008665280980718981316407_REALK,  &
    0.0007421969820239320957816_REALK,  0.0006477994292429123824456_REALK,  &
    0.0005739553701122027291881_REALK,  0.0005147615400281313436867_REALK,  &
    0.0004663397473350487936090_REALK,  0.0004260484669003233599432_REALK,  &
    0.0003920323164910266403906_REALK,  0.0003629531735118681282093_REALK,  &
    0.0003378235636959152571671_REALK,  0.0003158999920650912285325_REALK,  &
    0.0002966126623650553535867_REALK,  0.0002795179813358870230498_REALK,  &
    0.0002642657276236121512494_REALK,  0.0002505758938192526670725_REALK,  &
    0.0002382220515012145720026_REALK,  0.0002270192035501241193621_REALK,  &
    0.0002168147796250229747926_REALK,  0.0002074818698476068137056_REALK,  &
    0.0001989140764596705312356_REALK,  0.0001910215513610239617456_REALK,  &
    0.0001837279139523592262802_REALK,                                      &
    0.4078989919551832543653802_REALK,  0.0424259271120731307203044_REALK,  &
    0.0125726068334599556247655_REALK,  0.0057199741559153154460415_REALK,  &
    0.0032919725520969577749197_REALK,  0.0021843059433166787768055_REALK,  &
    0.0015885200292327322866420_REALK,  0.0012293067317371998009579_REALK,  &
    0.0009940770079108725894995_REALK,  0.0008302161737009557942665_REALK,  &
    0.0007105138509172705292560_REALK,  0.0006197355071879632332221_REALK,  &
    0.0005487914429390807835932_REALK,  0.0004919690395511934618775_REALK,  &
    0.0004455198900198246731580_REALK,  0.0004068935860509726928913_REALK,  &
    0.0003743004325408854238849_REALK,  0.0003464507629950387235067_REALK,  &
    0.0003223935748011329347623_REALK,  0.0003014133155261783684684_REALK,  &
    0.0002829619365771397125967_REALK,  0.0002666130104220077292124_REALK,  &
    0.0002520300368564364523923_REALK,  0.0002389441017919011558696_REALK,  &
    0.0002271378385663341869030_REALK,  0.0002164337221334750667630_REALK,  &
    0.0002066853965012001358246_REALK,  0.0001977711609433834179239_REALK,  &
    0.0001895890159776943096823_REALK,  0.0001820528520247437112393_REALK,  &
    0.0001750894859323520996036_REALK,                                      &
    0.4057932930436236595994615_REALK,  0.0418043787200529579073383_REALK,  &
    0.0122906779954777105323682_REALK,  0.0055580731341334657993891_REALK,  &
    0.0031847175511382783477665_REALK,  0.0021063960796972483295597_REALK,  &
    0.0015282801761630625692751_REALK,  0.0011806260091578066155626_REALK,  &
    0.0009534415720259464344447_REALK,  0.0007954538443495180397025_REALK,  &
    0.0006802029304758129123892_REALK,  0.0005929017196706726179276_REALK,  &
    0.0005247415104531414622654_REALK,  0.0004701939534955701946797_REALK,  &
    0.0004256359517115519599390_REALK,  0.0003886049891067820693559_REALK,  &
    0.0003573746799146932154843_REALK,  0.0003307020246383388876327_REALK,  &
    0.0003076711220232967156953_REALK,  0.0002875932959727680996755_REALK,  &
    0.0002699414041912931157101_REALK,  0.0002543055124970906356353_REALK,  &
    0.0002403622983425522826022_REALK,  0.0002278534970836007642232_REALK,  &
    0.0002165704378745846492467_REALK,  0.0002063427634456968084564_REALK,  &
    0.0001970300771168215843866_REALK,  0.0001885156720074627448476_REALK,  &
    0.0001807017639252481904042_REALK,  0.0001735058253282486552798_REALK,  &
    0.0001668577359206356201197_REALK,                                      &
    0.4037183224858261754164346_REALK,  0.0411967266080006389028512_REALK,  &
    0.0120167117473939464439292_REALK,  0.0054014387174947629810529_REALK,  &
    0.0030812837472336774766180_REALK,  0.0020314381954253182827053_REALK,  &
    0.0014704242813185928930725_REALK,  0.0011339342300126739083999_REALK,  &
    0.0009145069167885531025847_REALK,  0.0007621740142068080502147_REALK,  &
    0.0006512040855113869876683_REALK,  0.0005672436194499061272445_REALK,  &
    0.0005017558539924805690105_REALK,  0.0004493905521658362526953_REALK,  &
    0.0004066456103601590282674_REALK,  0.0003711432970233994135291_REALK,  &
    0.0003412182456984736225736_REALK,  0.0003156724019822475333502_REALK,  &
    0.0002936236479540347914761_REALK,  0.0002744091588832532147349_REALK,  &
    0.0002575218903569572999161_REALK,  0.0002425677557932535131392_REALK,  &
    0.0002292360885510267393909_REALK,  0.0002172788474766903349909_REALK,  &
    0.0002064957064983722364974_REALK,  0.0001967231843125309155833_REALK,  &
    0.0001878265990540529321688_REALK,  0.0001796940313379967772093_REALK,  &
    0.0001722317369343551033464_REALK,  0.0001653606204414607159028_REALK,  &
    0.0001590134955235584417535_REALK,                                      &
    0.4016733953122963440840465_REALK,  0.0406025791508320132994214_REALK,  &
    0.0117504494745639450486996_REALK,  0.0052498834869684511336696_REALK,  &
    0.0029815264803663256779065_REALK,  0.0019593155437186786892168_REALK,  &
    0.0014148549929566686059884_REALK,  0.0010891481813619496160639_REALK,  &
    0.0008772005331137621916837_REALK,  0.0007303125271864105167580_REALK,  &
    0.0006234598419913443042434_REALK,  0.0005427091889270571015841_REALK,  &
    0.0004797869892883009136121_REALK,  0.0004295151735032797738617_REALK,  &
    0.0003885084675631726150100_REALK,  0.0003544709288769378905878_REALK,  &
    0.0003257960047380733191978_REALK,  0.0003013289285701681980388_REALK,  &
    0.0002802200980134241696876_REALK,  0.0002618315543578258867453_REALK,  &
    0.0002456755743020003191456_REALK,  0.0002313732986759004948887_REALK,  &
    0.0002186262158595786420350_REALK,  0.0002071960994283798763917_REALK,  &
    0.0001968906313307245900535_REALK,  0.0001875529263896775437198_REALK,  &
    0.0001790537831595575310288_REALK,  0.0001712858719825584221264_REALK,  &
    0.0001641593205994856374125_REALK,  0.0001575983221592557926866_REALK,  &
    0.0001515385008423062655585_REALK,                                      &
    0.3996578458153926538543033_REALK,  0.0400215574229049186882889_REALK,  &
    0.0114916417548765765338503_REALK,  0.0051032271125978105261178_REALK,  &
    0.0028853068078837072231446_REALK,  0.0018899161428601049875220_REALK,  &
    0.0013614790306670212973600_REALK,  0.0010461881967088722603099_REALK,  &
    0.0008414530489498708853979_REALK,  0.0006998080368595372378893_REALK,  &
    0.0005969152683068235359237_REALK,  0.0005192487309713198634364_REALK,  &
    0.0004587895654506134440059_REALK,  0.0004105261291164308506789_REALK,  &
    0.0003711859607366647072213_REALK,  0.0003385520194325473616881_REALK,  &
    0.0003110744419882249876645_REALK,  0.0002876401545599034811039_REALK,  &
    0.0002674308508849355687370_REALK,  0.0002498324910018639120890_REALK,  &
    0.0002343759263416680233526_REALK,  0.0002206969294983685621510_REALK,  &
    0.0002085086630107607034296_REALK,  0.0001975823229142756342659_REALK,  &
    0.0001877332761272018462045_REALK,  0.0001788109652355758787817_REALK,  &
    0.0001706914444989723748155_REALK,  0.0001632717844409400367520_REALK,  &
    0.0001564658238089211182101_REALK,  0.0001502009067534680380931_REALK,  &
    0.0001444153497479874943572_REALK,                                      &
    0.3976710269256991669983847_REALK,  0.0394532947471360681546138_REALK,  &
    0.0112400480113491012257310_REALK,  0.0049612960735043818566448_REALK,  &
    0.0027924912712604605183331_REALK,  0.0018231325769991917930268_REALK,  &
    0.0013102070119130316237788_REALK,  0.0010049780026078055858441_REALK,  &
    0.0008071980919257565768171_REALK,  0.0006706018821904790325542_REALK,  &
    0.0005715178618754526360113_REALK,  0.0004968147646800353742225_REALK,  &
    0.0004387202685443132251820_REALK,  0.0003923836146015889691022_REALK,  &
    0.0003546412793121992866260_REALK,  0.0003233523405052235216890_REALK,  &
    0.0002970215784454330060910_REALK,  0.0002745760767320365859472_REALK,  &
    0.0002552276521787124707701_REALK,  0.0002383852728848696238100_REALK,  &
    0.0002235976478240169450229_REALK,  0.0002105146092659193428603_REALK,  &
    0.0001988605322608455363686_REALK,  0.0001884156588571660271431_REALK,  &
    0.0001790027310338100836364_REALK,  0.0001704772617782499433831_REALK,  &
    0.0001627203456200558367127_REALK,  0.0001556332715970608598487_REALK,  &
    0.0001491334352309368178023_REALK,  0.0001431511999102184776525_REALK,  &
    0.0001376274611768532997805_REALK,                                      &
    0.3957123096105135129363362_REALK,  0.0388974362611428023384086_REALK,  &
    0.0109954361784342959096339_REALK,  0.0048239233893086026425112_REALK,  &
    0.0027029516726074765374521_REALK,  0.0017588618054381784105988_REALK,  &
    0.0012609532860734502888317_REALK,  0.0009654445719869385886605_REALK,  &
    0.0007743721580718627333154_REALK,  0.0006426379688136205211788_REALK,  &
    0.0005472174408373309565864_REALK,  0.0004753619258498504988354_REALK,  &
    0.0004195377295461091707654_REALK,  0.0003750496239567295119616_REALK,  &
    0.0003388392847746217570633_REALK,  0.0003088392259378621579335_REALK,  &
    0.0002836069004988285482266_REALK,  0.0002621080717375855358153_REALK,  &
    0.0002435835511730112458873_REALK,  0.0002274644394315946305165_REALK,  &
    0.0002133166138746721393789_REALK,  0.0002008034169776077920103_REALK,  &
    0.0001896599930951682285753_REALK,  0.0001796752690197128818003_REALK,  &
    0.0001706790644841064464622_REALK,  0.0001625327160635860657047_REALK,  &
    0.0001551221520157325449527_REALK,  0.0001483527057748405125759_REALK,  &
    0.0001421451818530805697328_REALK,  0.0001364328366540036975921_REALK,  &
    0.0001311590363500808728223_REALK,                                      &
    0.3937810822936159693696823_REALK,  0.0383536384997385654260782_REALK,  &
    0.0107575823814811209061526_REALK,  0.0046909483624900218459719_REALK,  &
    0.0026165648605122539434309_REALK,  0.0016970049800350420557415_REALK,  &
    0.0012136357756563442931302_REALK,  0.0009275179838887210280463_REALK,  &
    0.0007429144863440045746042_REALK,  0.0006158626556031377569100_REALK,  &
    0.0005239660406141827568224_REALK,  0.0004548468719446978293305_REALK,  &
    0.0004012024364823426453817_REALK,  0.0003584878679012092322215_REALK,  &
    0.0003237464343639845322162_REALK,  0.0002949815000296248973695_REALK,  &
    0.0002708012925407913260890_REALK,  0.0002502088324346252190024_REALK,  &
    0.0002324728404906524785369_REALK,  0.0002170457081086882961639_REALK,  &
    0.0002035098188101433513714_REALK,  0.0001915414975207428531501_REALK,  &
    0.0001808862323896584902490_REALK,  0.0001713412882453758218863_REALK,  &
    0.0001627432773540835985859_REALK,  0.0001549591231776089054941_REALK,  &
    0.0001478793896833235444258_REALK,  0.0001414132878178051076334_REALK,  &
    0.0001354848894775178235177_REALK,  0.0001300302231645607785315_REALK,  &
    0.0001249950218270028297080_REALK,                                      &
    0.3918767502955189385716039_REALK,  0.0378215689931375859123008_REALK,  &
    0.0105262706288134430532288_REALK,  0.0045622163312305447427364_REALK,  &
    0.0025332125248135489194168_REALK,  0.0016374672703731666528748_REALK,  &
    0.0011681758243714903712507_REALK,  0.0008911312893444835701862_REALK,  &
    0.0007127669386913364516986_REALK,  0.0005902246462977520568768_REALK,  &
    0.0005017178151119268967109_REALK,  0.0004352281913563548214514_REALK,  &
    0.0003836766505569161214532_REALK,  0.0003426636959222833372918_REALK,  &
    0.0003093307082731361259270_REALK,  0.0002817494092554265606825_REALK,  &
    0.0002585769726865297900298_REALK,  0.0002388523071705706186420_REALK,  &
    0.0002218709985739621679858_REALK,  0.0002071059197765638215747_REALK,  &
    0.0001941553240951319439945_REALK,  0.0001827080119985052028119_REALK,  &
    0.0001725194069039306271098_REALK,  0.0001633947789373797136302_REALK,  &
    0.0001551772592687422397308_REALK,  0.0001477391312404737323902_REALK,  &
    0.0001409754046812191155286_REALK,  0.0001347990080969571678824_REALK,  &
    0.0001291371450801032658758_REALK,  0.0001239285003970700359526_REALK,  &
    0.0001191210743050533213318_REALK,                                      &
    0.3899987352934263240555879_REALK,  0.0373009058802508883245785_REALK,  &
    0.0103012925159136434910545_REALK,  0.0044375784323035039405370_REALK,  &
    0.0024527809999303267982085_REALK,  0.0015801576963622133379511_REALK,  &
    0.0011244980517613808058269_REALK,  0.0008562203831122118611457_REALK,  &
    0.0006838738854214621585084_REALK,  0.0005656748859536602121179_REALK,  &
    0.0004804289423570317382577_REALK,  0.0004164663167626695815943_REALK,  &
    0.0003669243260873080066109_REALK,  0.0003275440218777276365353_REALK,  &
    0.0002955615401802435919520_REALK,  0.0002691145571247519161645_REALK,  &
    0.0002469074314587542352470_REALK,  0.0002280136418734721528729_REALK,  &
    0.0002117546348281019845134_REALK,  0.0001976229865822958658723_REALK,  &
    0.0001852322087249871278118_REALK,  0.0001742830903769271994053_REALK,  &
    0.0001645405979966692658085_REALK,  0.0001558176876706803709073_REALK,  &
    0.0001479637469592036706431_REALK,  0.0001408562013746515132612_REALK,  &
    0.0001343943245888371462640_REALK,  0.0001284946093559446566451_REALK,  &
    0.0001230872609451330102533_REALK,  0.0001181135094204180656938_REALK,  &
    0.0001135235270837424599588_REALK,                                      &
    0.3881464748001623443762753_REALK,  0.0367913375364809225320784_REALK,  &
    0.0100824469412194219625212_REALK,  0.0043168913735900336925422_REALK,  &
    0.0023751610763816785251712_REALK,  0.0015249889679494533535620_REALK,  &
    0.0010825302141041575308689_REALK,  0.0008227238810185833134750_REALK,  &
    0.0006561820956267292457090_REALK,  0.0005421664620090012190814_REALK,  &
    0.0004600575343663729720699_REALK,  0.0003985234423974081145389_REALK,  &
    0.0003509110340749642875310_REALK,  0.0003130972529916683328929_REALK,  &
    0.0002824097509629088409606_REALK,  0.0002570498420349651082402_REALK,  &
    0.0002357673733003015398464_REALK,  0.0002176691248220357429322_REALK,  &
    0.0002021014373087060066007_REALK,  0.0001885758422751289994750_REALK,  &
    0.0001767205219201195922664_REALK,  0.0001662477863427071580506_REALK,  &
    0.0001569317684591928913074_REALK,  0.0001485928038368189831129_REALK,  &
    0.0001410862845740119353791_REALK,  0.0001342945695544150227097_REALK,  &
    0.0001281210217802261706454_REALK,  0.0001224855513068534985759_REALK,  &
    0.0001173212404919441186101_REALK,  0.0001125717583923033064414_REALK,  &
    0.0001081893581139592533944_REALK,                                      &
    0.3863194216613614617727990_REALK,  0.0362925622154457241941294_REALK,  &
    0.0098695398330624576482828_REALK,  0.0042000172158219899534726_REALK,  &
    0.0023002478201497658649721_REALK,  0.0014718773316349058593450_REALK,  &
    0.0010422030713145315466289_REALK,  0.0007905830026578594769276_REALK,  &
    0.0006296406324463346649775_REALK,  0.0005196545097529810730216_REALK,  &
    0.0004405635510595464540001_REALK,  0.0003813634450542004302939_REALK,  &
    0.0003356038892443058679199_REALK,  0.0002992932220882169665373_REALK,  &
    0.0002698474854476618119137_REALK,  0.0002455293979810328677121_REALK,  &
    0.0002251326607838706667965_REALK,  0.0002077961339701253856791_REALK,  &
    0.0001928901228355299739964_REALK,  0.0001799443948317339548454_REALK,  &
    0.0001686012380244021027949_REALK,  0.0001585840342684835025961_REALK,  &
    0.0001496757213679426130794_REALK,  0.0001417037202262891391457_REALK,  &
    0.0001345291858527811212388_REALK,  0.0001280392102480916536461_REALK,  &
    0.0001221410784258276352367_REALK,  0.0001167579768940471622281_REALK,  &
    0.0001118257457134498057943_REALK,  0.0001072903910938251015881_REALK,  &
    0.0001031061595575540707978_REALK,                                      &
    0.3845170435702341404926585_REALK,  0.0358042877040871607152717_REALK,  &
    0.0096623838872972895447377_REALK,  0.0040868231631675687107186_REALK,  &
    0.0022279403995530914356360_REALK,  0.0014207424234969447725957_REALK,  &
    0.0010034502595807706388370_REALK,  0.0007597414592113011216207_REALK,  &
    0.0006042007529489925926267_REALK,  0.0004980961220021368641292_REALK,  &
    0.0004219087180311684582949_REALK,  0.0003649518086551251441763_REALK,  &
    0.0003209714803922328026434_REALK,  0.0002861031229146807747764_REALK,  &
    0.0002578481520552976897706_REALK,  0.0002345285379899487477901_REALK,  &
    0.0002149802613941683056015_REALK,  0.0001983730867072954840227_REALK,  &
    0.0001841003894193583888608_REALK,  0.0001717094812835877229266_REALK,  &
    0.0001608562135046890187191_REALK,  0.0001512746081869825081137_REALK,  &
    0.0001427560608613226411905_REALK,  0.0001351347954574832999856_REALK,  &
    0.0001282774980746645659795_REALK,  0.0001220758017687208045205_REALK,  &
    0.0001164407531409883796375_REALK,  0.0001112986801473715871421_REALK,  &
    0.0001065880661504980194028_REALK,  0.0001022571569498184780849_REALK,  &
    0.0000982621087857605532206_REALK,                                      &
    0.3827388225992542913900252_REALK,  0.0353262309906395149949887_REALK,  &
    0.0094607983151875768568217_REALK,  0.0039771813622921882089289_REALK,  &
    0.0021581419193115731862409_REALK,  0.0013715071284479143053081_REALK,  &
    0.0009662081694874394667896_REALK,  0.0007301453461612351708218_REALK,  &
    0.0005798158124305682588687_REALK,  0.0004774502627951543215663_REALK,  &
    0.0004040564480090152706462_REALK,  0.0003492555522222284781694_REALK,  &
    0.0003069838038971742905613_REALK,  0.0002734994484128891955275_REALK,  &
    0.0002463863652090206540594_REALK,  0.0002240237001542200894789_REALK,  &
    0.0002052881967634894843505_REALK,  0.0001893793919423990995167_REALK,  &
    0.0001757128708946317069937_REALK,  0.0001638528246439140568375_REALK,  &
    0.0001534681459533803241611_REALK,  0.0001443030826801028668714_REALK,  &
    0.0001361571547507410345160_REALK,  0.0001288711181655988538552_REALK,  &
    0.0001223169676982842422452_REALK,  0.0001163906932527596435481_REALK,  &
    0.0001110069492036615674798_REALK,  0.0001060950755497744779545_REALK,  &
    0.0001015960893295480389157_REALK,  0.0000974603824647338662151_REALK,  &
    0.0000936459407483963536751_REALK,                                      &
    0.3809842547481366303863126_REALK,  0.0348581179449559130922864_REALK,  &
    0.0092646086011347328348364_REALK,  0.0038709687095426830935607_REALK,  &
    0.0020907592614987152365713_REALK,  0.0013240974454514599974869_REALK,  &
    0.0009304158293845749905585_REALK,  0.0007017430406839615230491_REALK,  &
    0.0005564411729302562361482_REALK,  0.0004576776849260813214218_REALK,  &
    0.0003869717658317476326711_REALK,  0.0003342431610975933457298_REALK,  &
    0.0002936122002437021065099_REALK,  0.0002614559318036957904011_REALK,  &
    0.0002354378903784334333901_REALK,  0.0002139923961446244351278_REALK,  &
    0.0001960354942472835920644_REALK,  0.0001807954044025612762477_REALK,  &
    0.0001677090936552825747863_REALK,  0.0001563569928363667954629_REALK,  &
    0.0001464205350005209330024_REALK,  0.0001376537955933950971819_REALK,  &
    0.0001298640988799358575445_REALK,  0.0001228984728689289107357_REALK,  &
    0.0001166340076136073306825_REALK,  0.0001109708731901999721314_REALK,  &
    0.0001058271842673559463323_REALK,  0.0001011351688478892834212_REALK,  &
    0.0000968382725945597281443_REALK,  0.0000928889440071417935409_REALK,  &
    0.0000892469216489559307674_REALK,                                      &
    0.3792528495074992678226522_REALK,  0.0343996830107107243179598_REALK,  &
    0.0090736462698513629249186_REALK,  0.0037680666659178413055442_REALK,  &
    0.0020257029330892242606488_REALK,  0.0012784423584450170172100_REALK,  &
    0.0008960147937745740554308_REALK,  0.0006744851035153311309689_REALK,  &
    0.0005340341157777641831195_REALK,  0.0004387408511440045780737_REALK,  &
    0.0003706212367874981523583_REALK,  0.0003198845212646896042294_REALK,  &
    0.0002808292934252752518810_REALK,  0.0002499474903559220835027_REALK,  &
    0.0002249795916383067753089_REALK,  0.0002044131620879422123541_REALK,  &
    0.0001872021407315474289187_REALK,  0.0001726023810448347353512_REALK,  &
    0.0001600714353960483633550_REALK,  0.0001492053595322415083212_REALK,  &
    0.0001396976450463330125806_REALK,  0.0001313118124905790788572_REALK,  &
    0.0001238626831506912907236_REALK,  0.0001172033074338324156903_REALK,  &
    0.0001112156659300725039400_REALK,  0.0001058039394331453732527_REALK,  &
    0.0001008895614989003836764_REALK,  0.0000964075292375570045041_REALK,  &
    0.0000923036162672783924580_REALK,  0.0000885322418791234999266_REALK,  &
    0.0000850548238638490792856_REALK,                                      &
    0.3775441294376290501944027_REALK,  0.0339506689090149985088551_REALK,  &
    0.0088877486625982670548352_REALK,  0.0036683610795024785763974_REALK,  &
    0.0019628869198230259641991_REALK,  0.0012344737127221061968180_REALK,  &
    0.0008629490364981007733541_REALK,  0.0006483241850919298828598_REALK,  &
    0.0005125537579922628253146_REALK,  0.0004206038588549448160522_REALK,  &
    0.0003549728981618077879034_REALK,  0.0003061508566303539329717_REALK,  &
    0.0002686089330940061282137_REALK,  0.0002389501717169186325879_REALK,  &
    0.0002149893816266106407777_REALK,  0.0001952655117006972171605_REALK,  &
    0.0001787690385688672659124_REALK,  0.0001647824394825940974487_REALK,  &
    0.0001527830857660710070934_REALK,  0.0001423820668073232163613_REALK,  &
    0.0001332844697292269301771_REALK,  0.0001252628927667507523300_REALK,  &
    0.0001181393591369251158804_REALK,  0.0001117727020634181836099_REALK,  &
    0.0001060495962287770032977_REALK,  0.0001008780706132803787600_REALK,  &
    0.0000961827420739224336031_REALK,  0.0000919012628594408515501_REALK,  &
    0.0000879816380731982786330_REALK,  0.0000843801756098338595971_REALK,  &
    0.0000810599020469205820867_REALK,                                      &
    0.3758576297617897132852249_REALK,  0.0335108263530012190356544_REALK,  &
    0.0087067587221195952285058_REALK,  0.0035717420150560229806513_REALK,  &
    0.0019022285461185613458096_REALK,  0.0011921260965397225631973_REALK,  &
    0.0008311648485099834256576_REALK,  0.0006232149357796091561357_REALK,  &
    0.0004919609723619833025615_REALK,  0.0004032323681691520706957_REALK,  &
    0.0003399961938502484774631_REALK,  0.0002930146691332502430390_REALK,  &
    0.0002569261393323089685305_REALK,  0.0002284411026875341117238_REALK,  &
    0.0002054461737916460839157_REALK,  0.0001865298915749219119120_REALK,  &
    0.0001707179635447247196753_REALK,  0.0001573185183333132152080_REALK,  &
    0.0001458280088459359470111_REALK,  0.0001358719895336486793713_REALK,  &
    0.0001271666980483030613084_REALK,  0.0001194934573427312206545_REALK,  &
    0.0001126812092127292677440_REALK,  0.0001065943397384389360570_REALK,  &
    0.0001011240292099553395077_REALK,  0.0000961819989019559352808_REALK,  &
    0.0000916959189660890251414_REALK,  0.0000876059875429349721194_REALK,  &
    0.0000838623487734545253322_REALK,  0.0000804231204153771855143_REALK,  &
    0.0000772528703631688098714_REALK,                                      &
    0.3741928979735357763125592_REALK,  0.0330799137729511430472407_REALK,  &
    0.0085305247859259383108599_REALK,  0.0034781035904595321468780_REALK,  &
    0.0018436483407798026287749_REALK,  0.0011513367277263652620894_REALK,  &
    0.0008006107400452763551285_REALK,  0.0005991139200094341629721_REALK,  &
    0.0004722183110409457641038_REALK,  0.0003865935331440294837023_REALK,  &
    0.0003256619118976450530031_REALK,  0.0002804496815506796062248_REALK,  &
    0.0002457570499270279374728_REALK,  0.0002183984403297124896222_REALK,  &
    0.0001963298368231508096455_REALK,  0.0001781876385168275529498_REALK,  &
    0.0001630315247802438419038_REALK,  0.0001501943393986693851046_REALK,  &
    0.0001391909073634414360180_REALK,  0.0001296607014253922445998_REALK,  &
    0.0001213306820631570171875_REALK,  0.0001139905578666511060809_REALK,  &
    0.0001074759171234878951705_REALK,  0.0001016564780423251162719_REALK,  &
    0.0000964277456702073196932_REALK,  0.0000917049840497578458692_REALK,  &
    0.0000874187919691666882318_REALK,  0.0000835118087395439961202_REALK,  &
    0.0000799362289457156860060_REALK,  0.0000766519047698905817145_REALK,  &
    0.0000736248807982715160235_REALK,                                      &
    0.3725494934575149241773317_REALK,  0.0326576970515577644227356_REALK,  &
    0.0083589003875894855172257_REALK,  0.0033873438197376364022784_REALK,  &
    0.0017870699082523293192704_REALK,  0.0011120453450760021518046_REALK,  &
    0.0007712373469844181154281_REALK,  0.0005759795341491402926107_REALK,  &
    0.0004532899325066362021877_REALK,  0.0003706559360797058899802_REALK,  &
    0.0003119421248320602187837_REALK,  0.0002684307828815145021729_REALK,  &
    0.0002350788700320977997818_REALK,  0.0002088013253000291235845_REALK,  &
    0.0001876211511671374944973_REALK,  0.0001702209388437935400507_REALK,  &
    0.0001556931264818991610295_REALK,  0.0001433943715920834953686_REALK,  &
    0.0001328571885673309176806_REALK,  0.0001237344426618654062711_REALK,  &
    0.0001157634060973973641646_REALK,  0.0001087418473523154243245_REALK,  &
    0.0001025117399325133131461_REALK,  0.0000969479223053962730098_REALK,  &
    0.0000919500507470316164396_REALK,  0.0000874367886453494998471_REALK,  &
    0.0000833415438938623351958_REALK,  0.0000796092965896067725510_REALK,  &
    0.0000761942068598461293020_REALK,  0.0000730577890353097342355_REALK,  &
    0.0000701675024930216873625_REALK,                                      &
    0.3709269871232621085255232_REALK,  0.0322439492689290188587314_REALK,  &
    0.0081917440657294556677348_REALK,  0.0032993644623838603094357_REALK,  &
    0.0017324198051943641082917_REALK,  0.0010741941043226318000525_REALK,  &
    0.0007429973412348843311154_REALK,  0.0005537719279458081867232_REALK,  &
    0.0004351415317294615682162_REALK,  0.0003553895247306644187765_REALK,  &
    0.0002988101326676613012437_REALK,  0.0002569339761885625897028_REALK,  &
    0.0002248698241110230397737_REALK,  0.0001996298373073950992596_REALK,  &
    0.0001793017675288052250031_REALK,  0.0001626127895494815342632_REALK,  &
    0.0001486869314528641993108_REALK,  0.0001369037965327387338949_REALK,  &
    0.0001268129316819847267686_REALK,  0.0001180800890142235715953_REALK,  &
    0.0001104524573757385391129_REALK,  0.0001037355521871914339812_REALK,  &
    0.0000977774812787668759755_REALK,  0.0000924580000064260812756_REALK,  &
    0.0000876807493711180698610_REALK,  0.0000833676545362761208620_REALK,  &
    0.0000794548178841030698985_REALK,  0.0000758894640689654163953_REALK,  &
    0.0000726276373966533965324_REALK,  0.0000696324450998159726056_REALK,  &
    0.0000668727020541992053576_REALK,                                      &
    0.3693249610515078606987061_REALK,  0.0318384504569563658860076_REALK,  &
    0.0080289191803790804086161_REALK,  0.0032140708787291956058385_REALK,  &
    0.0016796274221386685819579_REALK,  0.0010377274784989863175982_REALK,  &
    0.0007158453449547131242775_REALK,  0.0005324529293827468586636_REALK,  &
    0.0004177402734114388834635_REALK,  0.0003407655523030249096299_REALK,  &
    0.0002862404084563313091082_REALK,  0.0002459363287889814852355_REALK,  &
    0.0002151091100553831586377_REALK,  0.0001908649525978197520823_REALK,  &
    0.0001713541672723004755108_REALK,  0.0001553469612510498948366_REALK,  &
    0.0001419978262845988914963_REALK,  0.0001307084757288763188568_REALK,  &
    0.0001210448568696551204221_REALK,  0.0001126851224058761347623_REALK,  &
    0.0001053859980277809373170_REALK,  0.0000989604454460313938575_REALK,  &
    0.0000932624658843186069620_REALK,  0.0000881765363725822720218_REALK,  &
    0.0000836101228697122284949_REALK,  0.0000794882803570662793474_REALK,  &
    0.0000757496958000580962976_REALK,  0.0000723437461646438476071_REALK,  &
    0.0000692282819605017491187_REALK,  0.0000663679369772918935572_REALK,  &
    0.0000637328247957021608305_REALK,                                      &
    0.3677430081525415173082649_REALK,  0.0314409873626866898099763_REALK,  &
    0.0078702937364382979240629_REALK,  0.0031313718911047997393859_REALK,  &
    0.0016286248700308433336181_REALK,  0.0010025921624915320150284_REALK,  &
    0.0006897378484509528867585_REALK,  0.0005119859728005656451452_REALK,  &
    0.0004010547281579898769126_REALK,  0.0003267565201129318222702_REALK,  &
    0.0002742085462732654610983_REALK,  0.0002354159246864446781555_REALK,  &
    0.0002057768553803803672324_REALK,  0.0001824885033735946973221_REALK,  &
    0.0001637616246302787948157_REALK,  0.0001484079628364045222878_REALK,  &
    0.0001356113881510960896600_REALK,  0.0001247949192767541229040_REALK,  &
    0.0001155402956302255490463_REALK,  0.0001075376028398738559397_REALK,  &
    0.0001005527383947621048550_REALK,  0.0000944058214490885481496_REALK,  &
    0.0000889565152530170038343_REALK,  0.0000840938311215464455060_REALK,  &
    0.0000797289066669693463922_REALK,  0.0000757898001125620362399_REALK,  &
    0.0000722176776176556612947_REALK,  0.0000689639800310300400037_REALK,  &
    0.0000659882893388693164997_REALK,  0.0000632567023223839982335_REALK,  &
    0.0000607405768659346434967_REALK,                                      &
    0.3661807318361883223367670_REALK,  0.0310513532203504361017821_REALK,  &
    0.0077157402139284674003061_REALK,  0.0030511796505601792954543_REALK,  &
    0.0015793468714387186302428_REALK,  0.0009687369816119859120690_REALK,  &
    0.0006646331315934701474205_REALK,  0.0004923360301390483856690_REALK,  &
    0.0003850548114527761918435_REALK,  0.0003133361227870897912536_REALK,  &
    0.0002626912115270492497146_REALK,  0.0002253518191435717574374_REALK,  &
    0.0001968540754028982224869_REALK,  0.0001744831390584820852638_REALK,  &
    0.0001565081706402360176879_REALK,  0.0001417810077332157909450_REALK,  &
    0.0001295138531317482888904_REALK,  0.0001191502560050804388533_REALK,  &
    0.0001102871625717618213726_REALK,  0.0001026261416296537950761_REALK,  &
    0.0000959419115784818294420_REALK,  0.0000900614715067974227515_REALK,  &
    0.0000848499245046192900012_REALK,  0.0000802006362922762716054_REALK,  &
    0.0000760282690298076251111_REALK,  0.0000722637627668702372825_REALK,  &
    0.0000688506617967599236210_REALK,  0.0000657423860803463716877_REALK,  &
    0.0000629001774641738738581_REALK,  0.0000602915348179147768479_REALK,  &
    0.0000578890082195518846384_REALK,                                      &
    0.3646377456929754123926557_REALK,  0.0306693475317124548962244_REALK,  &
    0.0075651354047770345487289_REALK,  0.0029734095089082035467953_REALK,  &
    0.0015317306562363608522098_REALK,  0.0009361128040134648669798_REALK,  &
    0.0006404911885915037187550_REALK,  0.0004734695451628103649196_REALK,  &
    0.0003697117253113394699966_REALK,  0.0003004791958918972476049_REALK,  &
    0.0002516660934896344900720_REALK,  0.0002157239952977920945717_REALK,  &
    0.0001883226333119372524188_REALK,  0.0001668322893245814144119_REALK,  &
    0.0001495785587284176548859_REALK,  0.0001354519817250651747293_REALK,  &
    0.0001236920859922586231512_REALK,  0.0001137622049979782274179_REALK,  &
    0.0001052739284882134041801_REALK,  0.0000979398758725023187892_REALK,  &
    0.0000915432491745094364553_REALK,  0.0000859176607954674546831_REALK,  &
    0.0000809334402912463389415_REALK,  0.0000764881351133673837968_REALK,  &
    0.0000724997908101601115692_REALK,  0.0000689021127906366652460_REALK,  &
    0.0000656409265723769725807_REALK,  0.0000626715499633576339066_REALK,  &
    0.0000599568160352815569358_REALK,  0.0000574655673934423898369_REALK,  &
    0.0000551714963936214767139_REALK,                                      &
    0.3631136731860785116232648_REALK,  0.0302947758544260502266976_REALK,  &
    0.0074183602558713993002648_REALK,  0.0028979798958780255899170_REALK,  &
    0.0014857158615745953873788_REALK,  0.0009046724567867950490829_REALK,  &
    0.0006172736559870785648038_REALK,  0.0004553543705397923081236_REALK,  &
    0.0003549979024948225975536_REALK,  0.0002881616658826460547656_REALK,  &
    0.0002411118599463670886338_REALK,  0.0002065133227281691868753_REALK,  &
    0.0001801652020453265758138_REALK,  0.0001595201288003938978281_REALK,  &
    0.0001429582318657244242865_REALK,  0.0001294074122434904050138_REALK,  &
    0.0001181335513562772730365_REALK,  0.0001086190484326595193749_REALK,  &
    0.0001004895946835814376672_REALK,  0.0000934684441079002286019_REALK,  &
    0.0000873469581344213851989_REALK,  0.0000819651063111570673744_REALK,  &
    0.0000771982397454836535280_REALK,  0.0000729479218603606353703_REALK,  &
    0.0000691354461368459802164_REALK,  0.0000656971716215965233394_REALK,  &
    0.0000625811121254535643581_REALK,  0.0000597444053983665513828_REALK,  &
    0.0000571514099581265166776_REALK,  0.0000547722562356862437008_REALK,  &
    0.0000525817310501693174741_REALK,                                      &
    0.3616081473536584822703333_REALK,  0.0299274495980826754637505_REALK,  &
    0.0072752997181318064534583_REALK,  0.0028248122011660567985680_REALK,  &
    0.0014412444359580031498502_REALK,  0.0008743706455796397330679_REALK,  &
    0.0005949437437258063218759_REALK,  0.0004379597076474261432497_REALK,  &
    0.0003408869531704196973766_REALK,  0.0002763605022692312688549_REALK,  &
    0.0002310081138707532075541_REALK,  0.0001977015178849548333786_REALK,  &
    0.0001723652278906343221325_REALK,  0.0001525315433832925382344_REALK,  &
    0.0001366332912235439418520_REALK,  0.0001236344390680361765740_REALK,  &
    0.0001128262862035635006068_REALK,  0.0001037096056709359097586_REALK,  &
    0.0000959236684847028915580_REALK,  0.0000892019631056373713549_REALK,  &
    0.0000833436987044578348610_REALK,  0.0000781949558513683561480_REALK,  &
    0.0000736359104118734347213_REALK,  0.0000695719826556639401195_REALK,  &
    0.0000659275840124877915210_REALK,  0.0000626416199954645398469_REALK,  &
    0.0000596642035918576839749_REALK,  0.0000569542178085082802523_REALK,  &
    0.0000544774835668010836017_REALK,  0.0000522053655534377456047_REALK,  &
    0.0000501136992488733959525_REALK,                                      &
    0.3601208105212077015266914_REALK,  0.0295671858276625974804031_REALK,  &
    0.0071358426013634346229964_REALK,  0.0027538306611840442268690_REALK,  &
    0.0013982605472560396576986_REALK,  0.0008451638775879442757460_REALK,  &
    0.0005734661691716664904880_REALK,  0.0004212560489868941919316_REALK,  &
    0.0003273536139101810541092_REALK,  0.0002650536718994085183879_REALK,  &
    0.0002213353520329362702102_REALK,  0.0001892711062976378173263_REALK,  &
    0.0001649068957318545569461_REALK,  0.0001458520980831525199264_REALK,  &
    0.0001305904662607338068223_REALK,  0.0001181207863695094538187_REALK,  &
    0.0001077588736334339811858_REALK,  0.0000990232085465357842261_REALK,  &
    0.0000915661398874842430559_REALK,  0.0000851310057311296773533_REALK,  &
    0.0000795245633903975189354_REALK,  0.0000745987679765347619799_REALK,  &
    0.0000702384311157648870850_REALK,  0.0000663526771668774401330_REALK,  &
    0.0000628689107729735543757_REALK,  0.0000597284811062392536024_REALK,  &
    0.0000568835148700767869703_REALK,  0.0000542945687292433048772_REALK,  &
    0.0000519288655882796769750_REALK,  0.0000497589530612927479760_REALK,  &
    0.0000477616714153751532271_REALK,                                      &
    0.3586513140235459418114772_REALK,  0.0292138070741032908339552_REALK,  &
    0.0069998814346577103301383_REALK,  0.0026849622503117005593853_REALK,  &
    0.0013567104944832871198795_REALK,  0.0008170103877757198046136_REALK,  &
    0.0005528070939382881323482_REALK,  0.0004052151230911424785279_REALK,  &
    0.0003143736989247004572946_REALK,  0.0002542200952650897505941_REALK,  &
    0.0002120749254549929155907_REALK,  0.0001812053864810691909681_REALK,  &
    0.0001577750958671145394257_REALK,  0.0001394680063272193883562_REALK,  &
    0.0001248170861761563473716_REALK,  0.0001128547360346519287709_REALK,  &
    0.0001029204178351151509037_REALK,  0.0000945496777928684538827_REALK,  &
    0.0000874074592839855569245_REALK,  0.0000812465798378410862003_REALK,  &
    0.0000758810569008200888836_REALK,  0.0000711684929055587288870_REALK,  &
    0.0000669981537256734104285_REALK,  0.0000632827211614364165378_REALK,  &
    0.0000599524733689913620909_REALK,  0.0000569511045569512630018_REALK,  &
    0.0000542326731900560324480_REALK,  0.0000517593409497692417509_REALK,  &
    0.0000494996748156982155874_REALK,  0.0000474273561482747290784_REALK,  &
    0.0000455201879723301429284_REALK,                                      &
    0.3571993179361148684769489_REALK,  0.0288671411517135885482777_REALK,  &
    0.0068673123321222008172415_REALK,  0.0026181365764693731792989_REALK,  &
    0.0013165426231908864546094_REALK,  0.0007898700681853875913904_REALK,  &
    0.0005329340634147610627006_REALK,  0.0003898098418174133247653_REALK,  &
    0.0003019240534328044775481_REALK,  0.0002438396047414600413105_REALK,  &
    0.0002032090016300847512987_REALK,  0.0001734883954629317596562_REALK,  &
    0.0001509553923259930434137_REALK,  0.0001333661006595227602016_REALK,  &
    0.0001193010526641796325035_REALK,  0.0001078251022132932409594_REALK,  &
    0.0000983005202092986427173_REALK,  0.0000902793005584660488393_REALK,  &
    0.0000834385162202136258791_REALK,  0.0000775401081390397349698_REALK,  &
    0.0000724050770231574736388_REALK,  0.0000678964543017669702090_REALK,  &
    0.0000639077857673374236840_REALK,  0.0000603551698774368455282_REALK,  &
    0.0000571716434310411662648_REALK,  0.0000543031510636855660685_REALK,  &
    0.0000517056044073347758879_REALK,  0.0000493427043537427261724_REALK,  &
    0.0000471843064567609019652_REALK,  0.0000452051786989921390667_REALK,  &
    0.0000433840466018556921313_REALK,                                      &
    0.3557644908152365892384239_REALK,  0.0285270209821726489218818_REALK,  &
    0.0067380348637275976411698_REALK,  0.0025532857808340529877367_REALK,  &
    0.0012777072443179539936592_REALK,  0.0007637044002069236225960_REALK,  &
    0.0005138159488693902184411_REALK,  0.0003750142499198650335689_REALK,  &
    0.0002899825090727615821938_REALK,  0.0002338929046726790576382_REALK,  &
    0.0001947205284262225983768_REALK,  0.0001661048758592686914928_REALK,  &
    0.0001444339926183418150105_REALK,  0.0001275338047711948750648_REALK,  &
    0.0001140308139134285343817_REALK,  0.0001030212070317502521177_REALK,  &
    0.0000938892565877836893793_REALK,  0.0000862028089597672957101_REALK,  &
    0.0000796506191367862847498_REALK,  0.0000740034090133340959018_REALK,  &
    0.0000690888963890546036481_REALK,  0.0000647753319077008836522_REALK,  &
    0.0000609603738496285470325_REALK,  0.0000575634021723834805959_REALK,  &
    0.0000545201020811516708065_REALK,  0.0000517785778774778555141_REALK,  &
    0.0000492965189883552248645_REALK,  0.0000470391024263786390559_REALK,  &
    0.0000449774191254115755290_REALK,  0.0000430872785365066468489_REALK,  &
    0.0000413482901095297739774_REALK,                                      &
    0.3543465094470123477599088_REALK,  0.0281932844248627724470513_REALK,  &
    0.0066119519310688483482163_REALK,  0.0024903444415293233236974_REALK,  &
    0.0012401565563582039354584_REALK,  0.0007384763896796905967637_REALK,  &
    0.0004954228920199116315004_REALK,  0.0003608034768024900493764_REALK,  &
    0.0002785278412647722388190_REALK,  0.0002243615332218726235013_REALK,  &
    0.0001865931995990302095026_REALK,  0.0001590402444281531415139_REALK,  &
    0.0001381977188495851684852_REALK,  0.0001219591068009539337790_REALK,  &
    0.0001089953397918433126036_REALK,  0.0000984328574188602994314_REALK,  &
    0.0000896771555005569046687_REALK,  0.0000823113596232526368484_REALK,  &
    0.0000760354760468918473458_REALK,  0.0000706286782005831245126_REALK,  &
    0.0000659251450876019022855_REALK,  0.0000617981449891172768566_REALK,  &
    0.0000581492878643451624704_REALK,  0.0000549011054134267346451_REALK,  &
    0.0000519918254562671118503_REALK,  0.0000493716248903523118648_REALK,  &
    0.0000469998986544174499947_REALK,  0.0000448432393965137726243_REALK,  &
    0.0000428739224464448726265_REALK,  0.0000410687554575684372698_REALK,  &
    0.0000394081948615060807892_REALK,                                      &
    0.3529450586045521642830636_REALK,  0.0278657741132954973883873_REALK,  &
    0.0064889696478458401551759_REALK,  0.0024292494811270076704446_REALK,  &
    0.0012038445707031862359077_REALK,  0.0007141505047063310745656_REALK,  &
    0.0004777262519635504874234_REALK,  0.0003471536903569237553224_REALK,  &
    0.0002675397284384889049977_REALK,  0.0002152278259067778550580_REALK,  &
    0.0001788114218412597243319_REALK,  0.0001522805620347259685822_REALK,  &
    0.0001322339801404602143038_REALK,  0.0001166305338478258355698_REALK,  &
    0.0001041840981636810858782_REALK,  0.0000940503229934808475041_REALK,  &
    0.0000856551774419840990455_REALK,  0.0000785965141711555942807_REALK,  &
    0.0000725851761080609518464_REALK,  0.0000674084713467737207124_REALK,  &
    0.0000629067940869257151426_REALK,  0.0000589582365504011545235_REALK,  &
    0.0000554682059236774203850_REALK,  0.0000523622610743321607115_REALK,  &
    0.0000495810709098967476098_REALK,  0.0000470768013933383421368_REALK,  &
    0.0000448104836532796840581_REALK,  0.0000427500679837241484116_REALK,  &
    0.0000408689652441222226993_REALK,  0.0000391449398322243636563_REALK,  &
    0.0000375592597676465791740_REALK,                                      &
    0.3515598308132348304155812_REALK,  0.0275443372973994994590274_REALK,  &
    0.0063689972248769585738692_REALK,  0.0023699400778050142349351_REALK,  &
    0.0011687270400294472519342_REALK,  0.0006906926160632998953903_REALK,  &
    0.0004606985543649748230700_REALK,  0.0003340420527939802312900_REALK,  &
    0.0002569987130431957041143_REALK,  0.0002064748807459221052914_REALK,  &
    0.0001713602833001101090338_REALK,  0.0001458125049638732797022_REALK,  &
    0.0001265307462919664806527_REALK,  0.0001115371276407915447334_REALK,  &
    0.0000995870322866334570146_REALK,  0.0000898643149646672002211_REALK,  &
    0.0000818146950900443600948_REALK,  0.0000750502206071137210105_REALK,  &
    0.0000692921720462901104915_REALK,  0.0000643356873583948382384_REALK,  &
    0.0000600271394264783513060_REALK,  0.0000562492582853941198539_REALK,  &
    0.0000529111000008518735571_REALK,  0.0000499411310060804633786_REALK,  &
    0.0000472823638602093361582_REALK,  0.0000448888734558401141157_REALK,  &
    0.0000427232606288745789215_REALK,  0.0000407547777219881382808_REALK,  &
    0.0000389579242872630933619_REALK,  0.0000373113817411686938728_REALK,  &
    0.0000357971957848697919040_REALK,                                      &
    0.3501905261237115429828748_REALK,  0.0272288256914482440507186_REALK,  &
    0.0062519468594664688934626_REALK,  0.0023123575800123763630822_REALK,  &
    0.0011347613896025544009960_REALK,  0.0006680699400975825472115_REALK,  &
    0.0004443134428046463025620_REALK,  0.0003214466783817554180851_REALK,  &
    0.0002468861642619061408377_REALK,  0.0001980865249436304892199_REALK,  &
    0.0001642255234964876619511_REALK,  0.0001396233375197112778435_REALK,  &
    0.0001210765226390172192477_REALK,  0.0001066684213126186384687_REALK,  &
    0.0000951945392395902738368_REALK,  0.0000858659659979836087720_REALK,  &
    0.0000781474744346525028752_REALK,  0.0000716647955601241093068_REALK,  &
    0.0000661492633930024157961_REALK,  0.0000614035525286836894078_REALK,  &
    0.0000572797871441189809945_REALK,  0.0000536651562292930067732_REALK,  &
    0.0000504722222410662624010_REALK,  0.0000476322443495349030990_REALK,  &
    0.0000450904852542338054218_REALK,  0.0000428028518971517197710_REALK,  &
    0.0000407334510609978696794_REALK,  0.0000388527838327306691444_REALK,  &
    0.0000371363935645517418533_REALK,  0.0000355638406254280499993_REALK,  &
    0.0000341179159161193347048_REALK,                                      &
    0.3488368518923778416329640_REALK,  0.0269190953274140790107971_REALK,  &
    0.0061377336289539542735216_REALK,  0.0022564454244987258192678_REALK,  &
    0.0011019066513763455927161_REALK,  0.0006462509840039451806601_REALK,  &
    0.0004285456321943550365289_REALK,  0.0003093465930070072168571_REALK,  &
    0.0002371842423541782683000_REALK,  0.0001900472830453342595793_REALK,  &
    0.0001573935045833439955523_REALK,  0.0001337008858537982992042_REALK,  &
    0.0001158603260388484042275_REALK,  0.0001020144172275192330848_REALK,  &
    0.0000909974493338602905424_REALK,  0.0000820468110035462003162_REALK,  &
    0.0000746456567731558268044_REALK,  0.0000684329073471254918301_REALK,  &
    0.0000631495804971478157238_REALK,  0.0000586056053998640886864_REALK,  &
    0.0000546586389037577097326_REALK,  0.0000512001570789034709348_REALK,  &
    0.0000481460919113665481101_REALK,  0.0000454303850600999998958_REALK,  &
    0.0000430004596192627830246_REALK,  0.0000408139808223011754228_REALK,  &
    0.0000388365002481491777288_REALK,  0.0000370397166213724680006_REALK,  &
    0.0000354001740650606303495_REALK,  0.0000338982754242024469427_REALK,  &
    0.0000325175256815307155210_REALK,                                      &
    0.3474985225690448431556945_REALK,  0.0266150064135436369150423_REALK,  &
    0.0060262753882810264627334_REALK,  0.0022021490575713504982136_REALK,  &
    0.0010701234007709141491521_REALK,  0.0006252054933815889359652_REALK,  &
    0.0004133708641707616233442_REALK,  0.0002977216954801786331399_REALK,  &
    0.0002278758645557783638937_REALK,  0.0001823423464977427669101_REALK,  &
    0.0001508511838830418189377_REALK,  0.0001280335129666382407328_REALK,  &
    0.0001108716619427009455589_REALK,  0.0000975655658146120470173_REALK,  &
    0.0000869870064628424537797_REALK,  0.0000783987688034517719903_REALK,  &
    0.0000713017415330330166755_REALK,  0.0000653475598163473140158_REALK,  &
    0.0000602865692765082558831_REALK,  0.0000559356823271722335567_REALK,  &
    0.0000521578782909335071779_REALK,  0.0000488487551500539355829_REALK,  &
    0.0000459274829595961392534_REALK,  0.0000433305800157120208195_REALK,  &
    0.0000410075436739143757794_REALK,  0.0000389177266957122387206_REALK,  &
    0.0000370280668079799569711_REALK,  0.0000353114113727206926484_REALK,  &
    0.0000337452640401600937508_REALK,  0.0000323108351778100691756_REALK,  &
    0.0000309923140394792058483_REALK,                                      &
    0.3461752594915563641109202_REALK,  0.0263164231979578985831658_REALK,  &
    0.0059174926714172376707168_REALK,  0.0021494158594487261688954_REALK,  &
    0.0010393736960178021067058_REALK,  0.0006049044019734613197858_REALK,  &
    0.0003987658643816946739576_REALK,  0.0002865527205079514009092_REALK,  &
    0.0002189446724665188265084_REALK,  0.0001749575445513699512110_REALK,  &
    0.0001445860876464236620658_REALK,  0.0001226100948295438689082_REALK,  &
    0.0001061005025016511062533_REALK,  0.0000933127453613293559751_REALK,  &
    0.0000831548493471760566485_REALK,  0.0000749141246381865527713_REALK,  &
    0.0000681085698836568449515_REALK,  0.0000624020769353279575620_REALK,  &
    0.0000575539766739404965259_REALK,  0.0000533879037120549190506_REALK,  &
    0.0000497719577452112720570_REALK,  0.0000466056999424261948067_REALK,  &
    0.0000438114121539262066775_REALK,  0.0000413280876808257361245_REALK,  &
    0.0000391072154725899897329_REALK,  0.0000371097679274077322533_REALK,  &
    0.0000353040126709849679042_REALK,  0.0000336638987217038882080_REALK,  &
    0.0000321678497241113781589_REALK,  0.0000307978500737744506741_REALK,  &
    0.0000295387447362452789875_REALK,                                      &
    0.3448667906871042410088535_REALK,  0.0260232138370876005251109_REALK,  &
    0.0058113085964935536076315_REALK,  0.0020981950715848389325824_REALK,  &
    0.0010096210199656047330763_REALK,  0.0005853197834956474273488_REALK,  &
    0.0003847083015836532770941_REALK,  0.0002758212032605757840775_REALK,  &
    0.0002103750008606628636113_REALK,  0.0001678793164457100320353_REALK,  &
    0.0001385862859788333377627_REALK,  0.0001174199975763338846084_REALK,  &
    0.0001015372656596807640367_REALK,  0.0000892472427230404322801_REALK,  &
    0.0000794929936344085347850_REALK,  0.0000715855134734821575921_REALK,  &
    0.0000650593091007613456194_REALK,  0.0000595900880891842458045_REALK,  &
    0.0000549458367858766298999_REALK,  0.0000509566608734503701666_REALK,  &
    0.0000474955860997470214716_REALK,  0.0000444659842834651327249_REALK,  &
    0.0000417931277758407752616_REALK,  0.0000394183873003751351276_REALK,  &
    0.0000372951640583127531784_REALK,  0.0000353859849476858309529_REALK,  &
    0.0000336603935442478417674_REALK,  0.0000320933954770639447021_REALK,  &
    0.0000306642964917152360317_REALK,  0.0000293558229151398930134_REALK,  &
    0.0000281534480640434751930_REALK,                                      &
    0.3435728506800042603153145_REALK,  0.0257352502687622879118390_REALK,  &
    0.0057076487744978218405456_REALK,  0.0020484377268438543756579_REALK,  &
    0.0009808302242436939526876_REALK,  0.0005664248054682252632094_REALK,  &
    0.0003711767484725284472862_REALK,  0.0002655094454644377254329_REALK,  &
    0.0002021518478571968817966_REALK,  0.0001610946848200374556179_REALK,  &
    0.0001328403688808170684914_REALK,  0.0001124530557166399086623_REALK,  &
    0.0000971727951892380350336_REALK,  0.0000853607349071516498728_REALK,  &
    0.0000759938148140777301656_REALK,  0.0000684059040708586286583_REALK,  &
    0.0000621474376489293984247_REALK,  0.0000569055140563021961725_REALK,  &
    0.0000524564576319353243904_REALK,  0.0000486366035275004907025_REALK,  &
    0.0000453237166997485322879_REALK,  0.0000424248330243485967167_REALK,  &
    0.0000398680988406872541122_REALK,  0.0000375971685988780153042_REALK,  &
    0.0000355672796001064479713_REALK,  0.0000337424507473218829290_REALK,  &
    0.0000320934498231239523206_REALK,  0.0000305962958766703421926_REALK,  &
    0.0000292311404324079900227_REALK,  0.0000279814209910814073838_REALK,  &
    0.0000268332130081170199063_REALK,                                      &
    0.3422931803057058242067967_REALK,  0.0254524080897785345833917_REALK,  &
    0.0056064412213926960448784_REALK,  0.0020000965824097014476857_REALK,  &
    0.0009529674756861513697237_REALK,  0.0005481936849628266800183_REALK,  &
    0.0003581506441729561383315_REALK,  0.0002556004829533543702171_REALK,  &
    0.0001942608463900630981838_REALK,  0.0001545912302953424859783_REALK,  &
    0.0001273374233535834898923_REALK,  0.0001076995513247588768298_REALK,  &
    0.0000929983416265650695686_REALK,  0.0000816452714918392317240_REALK,  &
    0.0000726500319109083545020_REALK,  0.0000653685837867813826279_REALK,  &
    0.0000593667309490100397035_REALK,  0.0000543425536301376336796_REALK,  &
    0.0000500804085359216803828_REALK,  0.0000464226278474344126275_REALK,  &
    0.0000432515360728691697226_REALK,  0.0000404776922622503978425_REALK,  &
    0.0000380320048211409139508_REALK,  0.0000358603219610345325683_REALK,  &
    0.0000339196439921744929817_REALK,  0.0000321754218614249054759_REALK,  &
    0.0000305995979297887059074_REALK,  0.0000291691632541286415112_REALK,  &
    0.0000278650803211649193366_REALK,  0.0000266714683308127421238_REALK,  &
    0.0000255749797645132941331_REALK,                                      &
    0.3410275265308135850261806_REALK,  0.0251745664377794400867749_REALK,  &
    0.0055076162735220113644830_REALK,  0.0019531260553199173909955_REALK,  &
    0.0009260002049220922726996_REALK,  0.0005306016461857521616247_REALK,  &
    0.0003456102583149698302158_REALK,  0.0002460780546150698969848_REALK,  &
    0.0001866882369211019172036_REALK,  0.0001483570671753744237703_REALK,  &
    0.0001220670115215509611692_REALK,  0.0001031501941601032105913_REALK,  &
    0.0000890055440660146720503_REALK,  0.0000780932578414221897521_REALK,  &
    0.0000694546919205346645950_REALK,  0.0000624671440669881535782_REALK,  &
    0.0000567112477989230363991_REALK,  0.0000518956708572797180521_REALK,  &
    0.0000478125080898983767573_REALK,  0.0000443098650766715572154_REALK,  &
    0.0000412744531258522746289_REALK,  0.0000386202190643534216366_REALK,  &
    0.0000362807258500750642112_REALK,  0.0000342039290712749889439_REALK,  &
    0.0000323485218932402897665_REALK,  0.0000306813297761192674013_REALK,  &
    0.0000291754220585843955364_REALK,  0.0000278087220973180280863_REALK,  &
    0.0000265629699675055910466_REALK,  0.0000254229383227120049192_REALK,  &
    0.0000243758326110252130660_REALK,                                      &
    0.3397756422789119934435575_REALK,  0.0249016078772843485467092_REALK,  &
    0.0054111065061770756770554_REALK,  0.0019074821605176896927025_REALK,  &
    0.0008998970570425751788410_REALK,  0.0005136248798189985403234_REALK,  &
    0.0003335366566297188052441_REALK,  0.0002369265726721716885331_REALK,  &
    0.0001794208413410134999536_REALK,  0.0001423808202170896708427_REALK,  &
    0.0001170191497264637294894_REALK,  0.0000987961026772743916352_REALK,  &
    0.0000851864127744493668162_REALK,  0.0000746974390820909374790_REALK,  &
    0.0000664011549537978432167_REALK,  0.0000596954666040692762965_REALK,  &
    0.0000541753174177461491027_REALK,  0.0000495595828632953934239_REALK,  &
    0.0000456478126743050261621_REALK,  0.0000422936706694475119165_REALK,  &
    0.0000393880888429154628794_REALK,  0.0000368482716702007230851_REALK,  &
    0.0000346103333804274399454_REALK,  0.0000326242539907681874120_REALK,  &
    0.0000308503521853901356911_REALK,  0.0000292567727381865716918_REALK,  &
    0.0000278176663090220204638_REALK,  0.0000265118504803947183622_REALK,  &
    0.0000253218109247732307463_REALK,  0.0000242329466814151621163_REALK,  &
    0.0000232329931146095718748_REALK,                                      &
    0.3385372862619865919064921_REALK,  0.0246334182897137987655611_REALK,  &
    0.0053168466551995448646228_REALK,  0.0018631224513204467686800_REALK,  &
    0.0008746278442580667769266_REALK,  0.0004972405040448898408054_REALK,  &
    0.0003219116679989908946444_REALK,  0.0002281310942393631544921_REALK,  &
    0.0001724460380060465879842_REALK,  0.0001366516024230059330683_REALK,  &
    0.0001121842885495988962957_REALK,  0.0000946287858856910125928_REALK,  &
    0.0000815333125885609182482_REALK,  0.0000714508848033884905963_REALK,  &
    0.0000634830800572173134608_REALK,  0.0000570477101278615885143_REALK,  &
    0.0000517535270843871945132_REALK,  0.0000473292482392087776556_REALK,  &
    0.0000435816055083736403168_REALK,  0.0000403696139344679938085_REALK,  &
    0.0000375882664625286911351_REALK,  0.0000351579001500777966116_REALK,  &
    0.0000330170812807107445699_REALK,  0.0000311177346514145182770_REALK,  &
    0.0000294217398327645822842_REALK,  0.0000278985079487499860866_REALK,  &
    0.0000265232271882204457896_REALK,  0.0000252755728516846547968_REALK,  &
    0.0000241387455427045629014_REALK,  0.0000230987447464621910699_REALK,  &
    0.0000221438136593914649164_REALK,                                      &
    0.3373122228172485970176808_REALK,  0.0243698867672608732171113_REALK,  &
    0.0052247735415024724667243_REALK,  0.0018200059622075250020945_REALK,  &
    0.0008501635004640699508002_REALK,  0.0004814265271831970208552_REALK,  &
    0.0003107178528961343196360_REALK,  0.0002196772941015388488917_REALK,  &
    0.0001657517378604765818147_REALK,  0.0001311589938101150737415_REALK,  &
    0.0001075532937205563185044_REALK,  0.0000906401260205196620395_REALK,  &
    0.0000780389470596696877046_REALK,  0.0000683469744524084119562_REALK,  &
    0.0000606944116787325722395_REALK,  0.0000545182977996188562774_REALK,  &
    0.0000494407103434543805675_REALK,  0.0000451998559627157648461_REALK,  &
    0.0000416093862062720485913_REALK,  0.0000385334681582283350302_REALK,  &
    0.0000358710021103179451849_REALK,  0.0000335453374981538863554_REALK,  &
    0.0000314973973458043917978_REALK,  0.0000296809747472963099803_REALK,  &
    0.0000280594481213340365315_REALK,  0.0000266034441229616592367_REALK,  &
    0.0000252891464653997124525_REALK,  0.0000240970531607010201235_REALK,  &
    0.0000230110503471051983050_REALK,  0.0000220177130968450612488_REALK,  &
    0.0000211057712800979233752_REALK,                                      &
    0.3361002217491713128794117_REALK,  0.0241109055104659873725037_REALK,  &
    0.0051348259983959674418452_REALK,  0.0017780931538335122393119_REALK,  &
    0.0008264760376360118536085_REALK,  0.0004661618118726679822934_REALK,  &
    0.0002999384731586562718650_REALK,  0.0002115514386596057717655_REALK,  &
    0.0001593263615971274294297_REALK,  0.0001258930211120243964056_REALK,  &
    0.0001031174278729818052274_REALK,  0.0000868223619883877950273_REALK,  &
    0.0000746963433121507935008_REALK,  0.0000653793833891912152872_REALK,  &
    0.0000580293667492183523745_REALK,  0.0000521019051822533115154_REALK,  &
    0.0000472319357522178680285_REALK,  0.0000431668148294361898897_REALK,  &
    0.0000397268608155586306816_REALK,  0.0000367812011857296213197_REALK,  &
    0.0000342324958668650794935_REALK,  0.0000320069911401042256826_REALK,  &
    0.0000300478752036302940089_REALK,  0.0000283107360049894526456_REALK,  &
    0.0000267603912619049462884_REALK,  0.0000253686343985135003161_REALK,  &
    0.0000241126043618816344604_REALK,  0.0000229735883083247194889_REALK,  &
    0.0000219361297312118686540_REALK,  0.0000209873554665492492309_REALK,  &
    0.0000201164617865029458107_REALK,                                      &
    0.3349010581765592409198007_REALK,  0.0238563697293574794588977_REALK,  &
    0.0050469448016084239930223_REALK,  0.0017373458601776861891935_REALK,  &
    0.0008035385039778062277877_REALK,  0.0004514260407318384724085_REALK,  &
    0.0002895574630354075078287_REALK,  0.0002037403609932700776410_REALK,  &
    0.0001531588178103240448918_REALK,  0.0001208441383729281435851_REALK,  &
    0.0000988683331093655063185_REALK,  0.0000831680735530113926686_REALK,  &
    0.0000714988375831959282721_REALK,  0.0000625420695732419279315_REALK,  &
    0.0000554824223516439080464_REALK,  0.0000497934487602259560532_REALK,  &
    0.0000451224961437493476599_REALK,  0.0000412257433706578619572_REALK,  &
    0.0000379299323156084318290_REALK,  0.0000351089664373570181925_REALK,  &
    0.0000326691232501718432555_REALK,  0.0000305394348358947425432_REALK,  &
    0.0000286652665992114239521_REALK,  0.0000270039308150003697269_REALK,  &
    0.0000255216273393213752144_REALK,  0.0000241912695765888239674_REALK,  &
    0.0000229909130608217455365_REALK,  0.0000219026019049315137600_REALK,  &
    0.0000209115099440516936707_REALK,  0.0000200052929468868978687_REALK,  &
    0.0000191735941651299293643_REALK,                                      &
    0.3337145123844734717621918_REALK,  0.0236061775480259881943024_REALK,  &
    0.0049610726018986502430796_REALK,  0.0016977272377437053682558_REALK,  &
    0.0007813249437516974664833_REALK,  0.0004371996834367570974704_REALK,  &
    0.0002795594014537108483107_REALK,  0.0001962314369922865393663_REALK,  &
    0.0001472384820976806261289_REALK,  0.0001160032083938699167328_REALK,  &
    0.0000947980143387610501345_REALK,  0.0000796701662274452618957_REALK,  &
    0.0000684400614130665151894_REALK,  0.0000598292608524588138182_REALK,  &
    0.0000530483039510198887555_REALK,  0.0000475880749838710604251_REALK,  &
    0.0000431078983824825407735_REALK,  0.0000393724602351002830121_REALK,  &
    0.0000362146915547181835228_REALK,  0.0000335130943416717317599_REALK,  &
    0.0000311774270934886844203_REALK,  0.0000291394009592930469698_REALK,  &
    0.0000273464740384825486191_REALK,  0.0000257576152074263204587_REALK,  &
    0.0000243403515916333411200_REALK,  0.0000230686716796491255647_REALK,  &
    0.0000219215105216372385937_REALK,  0.0000208816383219696448750_REALK,  &
    0.0000199348333617973547994_REALK,  0.0000190692584620867615775_REALK,  &
    0.0000182749852451149356924_REALK,                                      &
    0.3325403696808446052379793_REALK,  0.0233602299125055395956352_REALK,  &
    0.0048771538601585012404072_REALK,  0.0016592017167272254344473_REALK,  &
    0.0007598103587200474590829_REALK,  0.0004234639651559523459978_REALK,  &
    0.0002699294854541950416417_REALK,  0.0001890125625097625774833_REALK,  &
    0.0001415551770690518808803_REALK,  0.0001113614849935197031973_REALK,  &
    0.0000908988233528851480910_REALK,  0.0000763218568411750146116_REALK,  &
    0.0000655139284564171980093_REALK,  0.0000572354428270794725439_REALK,  &
    0.0000507219741595239397057_REALK,  0.0000454811498141053288441_REALK,  &
    0.0000411838535895325073681_REALK,  0.0000376029750132865424567_REALK,  &
    0.0000345774086055733041907_REALK,  0.0000319900841648104600494_REALK,  &
    0.0000297541098001197614007_REALK,  0.0000278037731365494893772_REALK,  &
    0.0000260885437750510407705_REALK,  0.0000245689821557323424741_REALK,  &
    0.0000232138900037685926611_REALK,  0.0000219982878111808752872_REALK,  &
    0.0000209019545848107320271_REALK,  0.0000199083570231739300665_REALK,  &
    0.0000190038530287796969358_REALK,  0.0000181770915052480595202_REALK,  &
    0.0000174185546157559241606_REALK,                                      &
    0.3313784202576124382488842_REALK,  0.0231184305018392634301083_REALK,  &
    0.0047951347849095708741896_REALK,  0.0016217349540725122924306_REALK,  &
    0.0007389706711326329011472_REALK,  0.0004102008362855079619952_REALK,  &
    0.0002606535047433323755255_REALK,  0.0001820721314931743957562_REALK,  &
    0.0001360991532228448793254_REALK,  0.0001069105960473730433050_REALK,  &
    0.0000871634436076330952701_REALK,  0.0000731166597517037447932_REALK,  &
    0.0000627146218865911697464_REALK,  0.0000547553472625067345057_REALK,  &
    0.0000484986220123601659716_REALK,  0.0000434682487445819435942_REALK,  &
    0.0000393462678161614451584_REALK,  0.0000359134794840832834921_REALK,  &
    0.0000330145245197195681707_REALK,  0.0000305365962180903204319_REALK,  &
    0.0000283960259576634247206_REALK,  0.0000265295792275009812344_REALK,  &
    0.0000248886591238887487762_REALK,  0.0000234353551932913188767_REALK,  &
    0.0000221396932009619870445_REALK,  0.0000209776843032317510107_REALK,  &
    0.0000199299173534179515982_REALK,  0.0000189805271622532093433_REALK,  &
    0.0000181164274554543612344_REALK,  0.0000173267331223743073889_REALK,  &
    0.0000166023197838571309900_REALK,                                      &
    0.3302284590562344357422830_REALK,  0.0228806856422123436334282_REALK,  &
    0.0047149632721014134162374_REALK,  0.0015852937883423878859951_REALK,  &
    0.0007187826881958356631253_REALK,  0.0003973929434295724125864_REALK,  &
    0.0002517178173158760999713_REALK,  0.0001753990150506743491820_REALK,  &
    0.0001308610706516277700975_REALK,  0.0001026425272709020674938_REALK,  &
    0.0000835848756785041057575_REALK,  0.0000700483736716601604723_REALK,  &
    0.0000600365823660765923373_REALK,  0.0000523839410260583762148_REALK,  &
    0.0000463736527310342464990_REALK,  0.0000415451472793972582487_REALK,  &
    0.0000375912331447665336065_REALK,  0.0000343003392639311508079_REALK,  &
    0.0000315226434625642449217_REALK,  0.0000291494444262634924345_REALK,  &
    0.0000271001752949718412525_REALK,  0.0000253139846331366042472_REALK,  &
    0.0000237441340866803457543_REALK,  0.0000223541823280514128324_REALK,  &
    0.0000211153306278986116571_REALK,  0.0000200045411382200223204_REALK,  &
    0.0000190031798383701012404_REALK,  0.0000180960224345098341105_REALK,  &
    0.0000172705156612060594236_REALK,  0.0000165162211327815356418_REALK,  &
    0.0000158243915595441263808_REALK,                                      &
    0.3290902856374135487804722_REALK,  0.0226469042240393762799311_REALK,  &
    0.0046365888471224551634076_REALK,  0.0015498461963289469293242_REALK,  &
    0.0006992240679627640233609_REALK,  0.0003850236015739535370798_REALK,  &
    0.0002431093261014442212346_REALK,  0.0001689825414121532039247_REALK,  &
    0.0001258319815406724114393_REALK,  0.0000985496067137160046889_REALK,  &
    0.0000801564233598659728244_REALK,  0.0000671110690837680318741_REALK,  &
    0.0000574744965575252740749_REALK,  0.0000501164155238336157393_REALK,  &
    0.0000443426779517899996726_REALK,  0.0000397078118454736032667_REALK,  &
    0.0000359150191977330817111_REALK,  0.0000327600858401822436425_REALK,  &
    0.0000300985252112992245337_REALK,  0.0000278255892396912894867_REALK,  &
    0.0000258636959658900341557_REALK,  0.0000241542859144097891012_REALK,  &
    0.0000226524072742809295662_REALK,  0.0000213230302413858816663_REALK,  &
    0.0000201384850001784793518_REALK,  0.0000190766466321522272661_REALK,  &
    0.0000181196268549797692791_REALK,  0.0000172528161704398805265_REALK,  &
    0.0000164641724504586917045_REALK,  0.0000157436855747300544206_REALK,  &
    0.0000150829696597605843390_REALK,                                      &
    0.3279637040549002735545514_REALK,  0.0224169976218976940707250_REALK,  &
    0.0045599626089383041641079_REALK,  0.0015153612513354574459212_REALK,  &
    0.0006802732865859147321289_REALK,  0.0003730767674026977203348_REALK,  &
    0.0002348154565914954141573_REALK,  0.0001628124767462734801080_REALK,  &
    0.0001210033134246752854280_REALK,  0.0000946244899332627630723_REALK,  &
    0.0000768716803793253517950_REALK,  0.0000642990762172594888671_REALK,  &
    0.0000550232861508989472277_REALK,  0.0000479481766149749530814_REALK,  &
    0.0000424015063979778409980_REALK,  0.0000379523911196930820318_REALK,  &
    0.0000343140650353863818525_REALK,  0.0000312894089708151243077_REALK,  &
    0.0000287390779989520039059_REALK,  0.0000265621308744778207621_REALK,  &
    0.0000246838581445746101052_REALK,  0.0000230479047077888666043_REALK,  &
    0.0000216110361124020162148_REALK,  0.0000203395787578257520515_REALK,  &
    0.0000192069470153402131610_REALK,  0.0000181918923669752278822_REALK,  &
    0.0000172772421590326307611_REALK,  0.0000164489766599240626614_REALK,  &
    0.0000156955439110950214815_REALK,  0.0000150073443656543907348_REALK,  &
    0.0000143763385191627111876_REALK,                                      &
    0.3268485227332284526191586_REALK,  0.0221908796172022373949240_REALK,  &
    0.0044850371762755894891606_REALK,  0.0014818090830627473827863_REALK,  &
    0.0006619096068764403987400_REALK,  0.0003615370137096873479066_REALK,  &
    0.0002268241354048300439158_REALK,  0.0001568790067964105617269_REALK,  &
    0.0001163668531694285685277_REALK,  0.0000908601458180088525102_REALK,  &
    0.0000737245176997693797477_REALK,  0.0000616069735605169997716_REALK,  &
    0.0000526780973834238476928_REALK,  0.0000458748349816355522170_REALK,  &
    0.0000405461349760953041984_REALK,  0.0000362752077517830966180_REALK,  &
    0.0000327849714251510500449_REALK,  0.0000298851494336343027675_REALK,  &
    0.0000274413516885476250606_REALK,  0.0000253563028653541702349_REALK,  &
    0.0000235580579179084050783_REALK,  0.0000219923819237200960470_REALK,  &
    0.0000206176913173066188615_REALK,  0.0000194016155730098725275_REALK,  &
    0.0000183186103112859956601_REALK,  0.0000173482683603717602056_REALK,  &
    0.0000164741038111152777047_REALK,  0.0000156826626961601917130_REALK,  &
    0.0000149628631247113518074_REALK,  0.0000143054991668692965960_REALK,  &
    0.0000137028632986215377171_REALK,                                      &
    0.3257445543492518691408577_REALK,  0.0219684663235217743360028_REALK,  &
    0.0044117666357726854908794_REALK,  0.0014491608390360712077527_REALK,  &
    0.0006441130481164139337177_REALK,  0.0003503895048593345636426_REALK,  &
    0.0002191237697515612881712_REALK,  0.0001511727193000493010486_REALK,  &
    0.0001119147316467003640912_REALK,  0.0000872498430313739753526_REALK,  &
    0.0000707090713828736146165_REALK,  0.0000590295768858631084521_REALK,  &
    0.0000504342910300862253578_REALK,  0.0000438921969339584180578_REALK,  &
    0.0000387727402761688905272_REALK,  0.0000346727504648198476080_REALK,  &
    0.0000313244934648539537442_REALK,  0.0000285442921088244503996_REALK,  &
    0.0000262025312621144540178_REALK,  0.0000242054659168010841434_REALK,  &
    0.0000224838114611934171731_REALK,  0.0000209853722148212815254_REALK,  &
    0.0000196701516289013663178_REALK,  0.0000185070312277693743111_REALK,  &
    0.0000174714666605122542970_REALK,  0.0000165438584618604534371_REALK,  &
    0.0000157083797584662432237_REALK,  0.0000149521193289955510469_REALK,  &
    0.0000142644460787286302659_REALK,  0.0000136365314431042498872_REALK,  &
    0.0000130609860819986753344_REALK,                                      &
    0.3246516157173496841537030_REALK,  0.0217496761144399981813269_REALK,  &
    0.0043401064920218944062635_REALK,  0.0014173886475111220888817_REALK,  &
    0.0006268643570727582773477_REALK,  0.0003396199732524207010043_REALK,  &
    0.0002117032277572394893296_REALK,  0.0001456845871577424939187_REALK,  &
    0.0001076394090719722500130_REALK,  0.0000837871370489777869163_REALK,  &
    0.0000678197309890483539035_REALK,  0.0000565619287635071041429_REALK,  &
    0.0000482874328434164642510_REALK,  0.0000419962556303126423253_REALK,  &
    0.0000370776704580322907161_REALK,  0.0000331416665160526430190_REALK,  &
    0.0000299295335438842080968_REALK,  0.0000272639593794913226345_REALK,  &
    0.0000250199306099627871063_REALK,  0.0000231071020385816662058_REALK,  &
    0.0000214587494839546282421_REALK,  0.0000200246387012336355977_REALK,  &
    0.0000187662987892140528028_REALK,  0.0000176538143168373243752_REALK,  &
    0.0000166636013891004918430_REALK,  0.0000157768359645755164235_REALK,  &
    0.0000149783236241334148431_REALK,  0.0000142556738178063456567_REALK,  &
    0.0000135986877708456457462_REALK,  0.0000129988987076800622514_REALK,  &
    0.0000124492222523065657855_REALK,                                      &
    0.3235695276781786478004221_REALK,  0.0215344295538687190150196_REALK,  &
    0.0042700136194305550463302_REALK,  0.0013864655818003298378555_REALK,  &
    0.0006101449801636316463971_REALK,  0.0003292146967549901119023_REALK,  &
    0.0002045518196104704220038_REALK,  0.0001404059523192187309767_REALK,  &
    0.0001035336609760298225147_REALK,  0.0000804658577629783990006_REALK,  &
    0.0000650511284899169597027_REALK,  0.0000541992885426946548731_REALK,  &
    0.0000462332844222764033858_REALK,  0.0000401831826939386225084_REALK,  &
    0.0000354574375059003870812_REALK,  0.0000316787545015523449524_REALK,  &
    0.0000285971346266859054728_REALK,  0.0000260414048355199148491_REALK,  &
    0.0000238909866063582597331_REALK,  0.0000220588089524950491495_REALK,  &
    0.0000204806119332979794470_REALK,  0.0000191080479411589067697_REALK,  &
    0.0000179041127547999020457_REALK,  0.0000168400469212110924424_REALK,  &
    0.0000158931890099392866746_REALK,  0.0000150454594226133210610_REALK,  &
    0.0000142822706936958281694_REALK,  0.0000135917317745364853529_REALK,  &
    0.0000129640584967786590728_REALK,  0.0000123911309445694393445_REALK,  &
    0.0000118661570387844026982_REALK,                                      &
    0.3224981149908488498034842_REALK,  0.0213226493287240227714197_REALK,  &
    0.0042014462158315238338169_REALK,  0.0013563656259630170984598_REALK,  &
    0.0005939370367301360790005_REALK,  0.0003191604770500105787284_REALK,  &
    0.0001976592794989439131042_REALK,  0.0001353285103556430436084_REALK,  &
    0.0000995905647826873606900_REALK,  0.0000772800976284518235286_REALK,  &
    0.0000623981276704982048718_REALK,  0.0000519371227790990156706_REALK,  &
    0.0000442677944902791431427_REALK,  0.0000384493202080077233428_REALK,  &
    0.0000339087098344466076087_REALK,  0.0000302809574889333288838_REALK,  &
    0.0000273244738437662073227_REALK,  0.0000248740072667692948942_REALK,  &
    0.0000228132534583357402631_REALK,  0.0000210582947577722407601_REALK,  &
    0.0000195472429428508928109_REALK,  0.0000182335651351540562945_REALK,  &
    0.0000170816671321562615514_REALK,  0.0000160639002537062836181_REALK,  &
    0.0000151584890601412252998_REALK,  0.0000143480686642955007236_REALK,  &
    0.0000136186340902651282299_REALK,  0.0000129587734879464597769_REALK,  &
    0.0000123591003126485750725_REALK,  0.0000118118271989998706355_REALK,  &
    0.0000113104422268168216371_REALK,                                      &
    0.3214372062284094333506346_REALK,  0.0211142601838795289370676_REALK,  &
    0.0041343637577761823548306_REALK,  0.0013270636418052830351327_REALK,  &
    0.0005782232933681822825700_REALK,  0.0003094446188732254804897_REALK,  &
    0.0001910157483003203351870_REALK,  0.0001304442956883917537937_REALK,  &
    0.0000958034869661360933115_REALK,  0.0000742242003278750968071_REALK,  &
    0.0000598558139992774490990_REALK,  0.0000497710960884351297380_REALK,  &
    0.0000423870905653548769973_REALK,  0.0000367911730719253898922_REALK,  &
    0.0000324283052303534453996_REALK,  0.0000289453564631344800598_REALK,  &
    0.0000261088563760892384755_REALK,  0.0000237592649322587388656_REALK,  &
    0.0000217843973150299026584_REALK,  0.0000201033728431247149505_REALK,  &
    0.0000186565860158718137512_REALK,  0.0000173992495532982875987_REALK,  &
    0.0000162971248257377385388_REALK,  0.0000153236305077361452593_REALK,  &
    0.0000144578421330911400427_REALK,  0.0000136830809921620306186_REALK,  &
    0.0000129859011289239167604_REALK,  0.0000123553504205497612718_REALK,  &
    0.0000117824236637913829016_REALK,  0.0000112596523286503373172_REALK,  &
    0.0000107807930230105099555_REALK,                                      &
    0.3203866336765307520906276_REALK,  0.0209091888593142781471723_REALK,  &
    0.0040687269574457892579167_REALK,  0.0012985353371376912121754_REALK,  &
    0.0005629871392772266150764_REALK,  0.0003000549100962595413383_REALK,  &
    0.0001846117569958552397536_REALK,  0.0001257456674460032477764_REALK,  &
    0.0000921660707625998658560_REALK,  0.0000712927499308450379712_REALK,  &
    0.0000574194849453454704883_REALK,  0.0000476970624071884673287_REALK,  &
    0.0000405874710028149594397_REALK,  0.0000352054017024905927056_REALK,  &
    0.0000310131841140505123706_REALK,  0.0000276691640709280902224_REALK,  &
    0.0000249477096193793643263_REALK,  0.0000226947900926303721000_REALK,  &
    0.0000208021911254771306530_REALK,  0.0000191919570340119584188_REALK,  &
    0.0000178066794316467288657_REALK,  0.0000166032501748528696578_REALK,  &
    0.0000155487338886536248278_REALK,  0.0000146175748998133770746_REALK,  &
    0.0000137896660960102492277_REALK,  0.0000130489875609307957188_REALK,  &
    0.0000123826298421695856058_REALK,  0.0000117800818701125780574_REALK,  &
    0.0000112327041721520207461_REALK,  0.0000107333339078682846581_REALK,  &
    0.0000102759850681021115145_REALK,                                      &
    0.3193462332352761112730377_REALK,  0.0207073640293759346497904_REALK,  &
    0.0040044977211195461122561_REALK,  0.0012707572352409696788550_REALK,  &
    0.0005482125625844149960364_REALK,  0.0002909796026216192928876_REALK,  &
    0.0001784382107760399066923_REALK,  0.0001212252959221898072125_REALK,  &
    0.0000886722244120812511841_REALK,  0.0000684805605271806552489_REALK,  &
    0.0000550846407227037712672_REALK,  0.0000457110566422064585495_REALK,  &
    0.0000388653973950616696709_REALK,  0.0000336888150642692714301_REALK,  &
    0.0000296604431070436150059_REALK,  0.0000264497186504850821046_REALK,  &
    0.0000238385776154700631884_REALK,  0.0000216783037937475041702_REALK,  &
    0.0000198645097334008589526_REALK,  0.0000183220569642229081991_REALK,  &
    0.0000169956518647985992338_REALK,  0.0000158438015305158998950_REALK,  &
    0.0000148348235665834133983_REALK,  0.0000139441478967181189057_REALK,  &
    0.0000131524524843476069396_REALK,  0.0000124443499250807766194_REALK,  &
    0.0000118074456683322375378_REALK,  0.0000112316517879749528048_REALK,  &
    0.0000107086795747943257706_REALK,  0.0000102316592776927859114_REALK,  &
    0.0000097948515907194536528_REALK,                                      &
    0.3183158443238595092239507_REALK,  0.0205087162440828266185555_REALK,  &
    0.0039416391091401797863725_REALK,  0.0012437066454919494095516_REALK,  &
    0.0005338841276043844018967_REALK,  0.0002822073940557272070037_REALK,  &
    0.0001724863738088588548027_REALK,  0.0001168761496089986757401_REALK,  &
    0.0000853161099070509295911_REALK,  0.0000657826663125274662021_REALK,  &
    0.0000528469754427314929320_REALK,  0.0000438092866917208395333_REALK,  &
    0.0000372174873118639499723_REALK,  0.0000322383640142525433581_REALK,  &
    0.0000283673088909116667743_REALK,  0.0000252844785329519290500_REALK,  &
    0.0000227791157384401533252_REALK,  0.0000207076308898603765564_REALK,  &
    0.0000189693251980280053865_REALK,  0.0000174917736613773760806_REALK,  &
    0.0000162217182076150091569_REALK,  0.0000151192197378405098802_REALK,  &
    0.0000141538005259001851261_REALK,  0.0000133018376186983008875_REALK,  &
    0.0000125447630647181869532_REALK,  0.0000118677967480975974285_REALK,  &
    0.0000112590382953087068848_REALK,  0.0000107088057468178909410_REALK,  &
    0.0000102091468064067646717_REALK,  0.0000097534727348057463024_REALK,  &
    0.0000093362806953454647571_REALK,                                      &
    0.3172953097882877937507828_REALK,  0.0203131778723915391859922_REALK,  &
    0.0038801152973201810149340_REALK,  0.0012173616351039177278098_REALK,  &
    0.0005199869529966433560550_REALK,  0.0002737274101275643189111_REALK,  &
    0.0001667478546425269088881_REALK,  0.0001126914827803246921690_REALK,  &
    0.0000820921322259670591419_REALK,  0.0000631943121065159705120_REALK,  &
    0.0000507023686566678794614_REALK,  0.0000419881258211691354596_REALK,  &
    0.0000356405073658398364339_REALK,  0.0000308511349465520609624_REALK,  &
    0.0000271311323446870061480_REALK,  0.0000241710166035985885393_REALK,  &
    0.0000217670856238313928832_REALK,  0.0000197806952952978724392_REALK,  &
    0.0000181147023304900366733_REALK,  0.0000166992953364321667525_REALK,  &
    0.0000154831755859657167664_REALK,  0.0000144278987208209307576_REALK,  &
    0.0000135041452574044575628_REALK,  0.0000126892024104752350853_REALK,  &
    0.0000119652265584962708942_REALK,  0.0000113180206658038196493_REALK,  &
    0.0000107361586523207173260_REALK,  0.0000102103480508470057550_REALK,  &
    0.0000097329592190258313374_REALK,  0.0000092976728528638720981_REALK,  &
    0.0000088992127781527977993_REALK,                                      &
    0.3162844758117931420748903_REALK,  0.0201206830473592591934651_REALK,  &
    0.0038198915397340779155633_REALK,  0.0011917010019374290382549_REALK,  &
    0.0005065066907840286031944_REALK,  0.0002655291878218790603203_REALK,  &
    0.0001612145922157906671127_REALK,  0.0001086648236020716895003_REALK,  &
    0.0000789949290304662682599_REALK,  0.0000607109442844060525593_REALK,  &
    0.0000486468772707616308251_REALK,  0.0000402441053779134430123_REALK,  &
    0.0000341313665884873516281_REALK,  0.0000295243437235308091434_REALK,  &
    0.0000259493829479345477281_REALK,  0.0000231070151106594015729_REALK,  &
    0.0000208003503297888134749_REALK,  0.0000188955154541576634511_REALK,  &
    0.0000172987944358450666761_REALK,  0.0000159428933677396999385_REALK,  &
    0.0000147783995598146386210_REALK,  0.0000137683066050730185706_REALK,  &
    0.0000128844086474765301132_REALK,  0.0000121048675722096495800_REALK,  &
    0.0000114125355185410718215_REALK,  0.0000107937752965455485747_REALK,  &
    0.0000102376160427426653518_REALK,  0.0000097351389816947449230_REALK,  &
    0.0000092790239325132270091_REALK,  0.0000088632099299675488224_REALK,  &
    0.0000084826380646707602156_REALK,                                      &
    0.3152831918279604406230021_REALK,  0.0199311676131329988670426_REALK,  &
    0.0037609341328442981271241_REALK,  0.0011667042483393926313728_REALK,  &
    0.0004934295061972568353578_REALK,  0.0002576026591972293048292_REALK,  &
    0.0001558788424500273553201_REALK,  0.0001047899627462828308407_REALK,  &
    0.0000760193608060225967712_REALK,  0.0000583282021040059495782_REALK,  &
    0.0000466767278175331482167_REALK,  0.0000385739078296903195923_REALK,  &
    0.0000326871101027714509239_REALK,  0.0000282553298803924247420_REALK,  &
    0.0000248196434374369413625_REALK,  0.0000220902607105434081183_REALK,  &
    0.0000198768697194784026898_REALK,  0.0000180502000179553048818_REALK,  &
    0.0000165198392512247042635_REALK,  0.0000152209184706469888721_REALK,  &
    0.0000141058404997556823088_REALK,  0.0000131389822804362118008_REALK,  &
    0.0000122932087088395385332_REALK,  0.0000115475222429550948501_REALK,  &
    0.0000108854433518858823482_REALK,  0.0000102938723913496197698_REALK,  &
    0.0000097622754113755858040_REALK,  0.0000092820921736592676773_REALK,  &
    0.0000088462993096312041261_REALK,  0.0000084490835563215330574_REALK,  &
    0.0000080855942635368793152_REALK,                                      &
    0.3142913104364611354135661_REALK,  0.0197445690737001813830354_REALK,  &
    0.0037032103809102067705494_REALK,  0.0011423515559699861949411_REALK,  &
    0.0004807420583120531969688_REALK,  0.0002499381358603913012503_REALK,  &
    0.0001507331653984936292723_REALK,  0.0001010609424875574244079_REALK,  &
    0.0000731605014267363386099_REALK,  0.0000560419094104566765631_REALK,  &
    0.0000447883090673220675697_REALK,  0.0000369743601122959555808_REALK,  &
    0.0000313049130789023875203_REALK,  0.0000270415510908368819231_REALK,  &
    0.0000237396047059331856389_REALK,  0.0000211186397386043627335_REALK,  &
    0.0000189946960546212909298_REALK,  0.0000172429437216505579379_REALK,  &
    0.0000157761550710388915241_REALK,  0.0000145317970440365217411_REALK,  &
    0.0000134640201313941240479_REALK,  0.0000125385321232014566785_REALK,  &
    0.0000117292274634845634744_REALK,  0.0000110159164294685854503_REALK,  &
    0.0000103827614815574800983_REALK,  0.0000098171791174885628388_REALK,  &
    0.0000093090547398525943335_REALK,  0.0000088501721121970580220_REALK,  &
    0.0000084337925498481938183_REALK,  0.0000080543402964203720417_REALK,  &
    0.0000077071643308521122585_REALK,                                      &
    0.3133086873213071221755399_REALK,  0.0195608265433377878639298_REALK,  &
    0.0036466885626319288198072_REALK,  0.0011186237615785708365140_REALK,  &
    0.0004684314814467177806416_REALK,  0.0002425262940698717404556_REALK,  &
    0.0001457704129291298358190_REALK,  0.0000974720462610110854797_REALK,  &
    0.0000704136291257907069932_REALK,  0.0000538480667022457336096_REALK,  &
    0.0000429781649650097657424_REALK,  0.0000354424272726682661476_REALK,  &
    0.0000299820749605537539926_REALK,  0.0000258805778819583768419_REALK,  &
    0.0000227070609318976614622_REALK,  0.0000201901336951577801894_REALK,  &
    0.0000181519697904614024729_REALK,  0.0000164720234489195206955_REALK,  &
    0.0000150661370506048136958_REALK,  0.0000138740276856166552447_REALK,  &
    0.0000128515282397835878036_REALK,  0.0000119656268705386541965_REALK,  &
    0.0000111912079706655506354_REALK,  0.0000105088581735900025787_REALK,  &
    0.0000099033566410136029967_REALK,  0.0000093626154691976348543_REALK,  &
    0.0000088769225641602685718_REALK,  0.0000084383917498741574804_REALK,  &
    0.0000080405573962856717872_REALK,  0.0000076780714803603203041_REALK,  &
    0.0000073464743399219386872_REALK,                                      &
    0.3123351811715407433389657_REALK,  0.0193798806986993470136138_REALK,  &
    0.0035913378989824128184605_REALK,  0.0010955023336913578997642_REALK,  &
    0.0004564853672893354110535_REALK,  0.0002353581604424108950947_REALK,  &
    0.0001409837169183424966917_REALK,  0.0000940177886619409069590_REALK,  &
    0.0000677742178539078110946_REALK,  0.0000517428435425606791714_REALK,  &
    0.0000412429878774812702039_REALK,  0.0000339752063941555089953_REALK,  &
    0.0000287160139493398394641_REALK,  0.0000247700885870990939787_REALK,  &
    0.0000217199049298427704358_REALK,  0.0000193028149369092983875_REALK,  &
    0.0000173469155629181364981_REALK,  0.0000157357944779561277702_REALK,  &
    0.0000143882536799544216428_REALK,  0.0000132461778681432418352_REALK,  &
    0.0000122670195264835113198_REALK,  0.0000114189986400383727117_REALK,  &
    0.0000106779514931952802624_REALK,  0.0000100252108517135505466_REALK,  &
    0.0000094461482949893922162_REALK,  0.0000089291517995828121912_REALK,  &
    0.0000084648956085410298001_REALK,  0.0000080458102342527560824_REALK,  &
    0.0000076656919504783694349_REALK,  0.0000073194110991336883647_REALK,  &
    0.0000070026914514089147934_REALK,                                      &
    0.3113706536042807893061024_REALK,  0.0192016737324816021137419_REALK,  &
    0.0035371285221830832921908_REALK,  0.0010729693501750957405211_REALK,  &
    0.0004448917477251113669449_REALK,  0.0002284250982374774340163_REALK,  &
    0.0001363664779341594948149_REALK,  0.0000906929058682226968456_REALK,  &
    0.0000652379290089183085316_REALK,  0.0000497225713007866084239_REALK,  &
    0.0000395796121380295168172_REALK,  0.0000325699207913427766603_REALK,  &
    0.0000275042617359268294131_REALK,  0.0000237078645258831110533_REALK,  &
    0.0000207761237111095757298_REALK,  0.0000184548425644020676188_REALK,  &
    0.0000165778383591109204848_REALK,  0.0000150326868994932883714_REALK,  &
    0.0000137410434199631521437_REALK,  0.0000126468807691215314430_REALK,  &
    0.0000117092106121525442919_REALK,  0.0000108974380876164839605_REALK,  &
    0.0000101883147955950778329_REALK,  0.0000095638906001797817087_REALK,  &
    0.0000090101061808383189954_REALK,  0.0000085158064680380013049_REALK,  &
    0.0000080720365303126814940_REALK,  0.0000076715307424509290781_REALK,  &
    0.0000073083365898726044838_REALK,  0.0000069775337990039310821_REALK,  &
    0.0000066750219791583924520_REALK,                                      &
    0.3104149690900465663467855_REALK,  0.0190261493086146260544922_REALK,  &
    0.0034840314457801027821227_REALK,  0.0010510074766424731731312_REALK,  &
    0.0004336390783355281003907_REALK,  0.0002217187941958005756998_REALK,  &
    0.0001319123543880737709291_REALK,  0.0000874923464672856831571_REALK,  &
    0.0000628006035203118188935_REALK,  0.0000477837362096379368874_REALK,  &
    0.0000379850078745348759888_REALK,  0.0000312239144623942924714_REALK,  &
    0.0000263444584666789348491_REALK,  0.0000226917854011515520145_REALK,  &
    0.0000198737942455758133929_REALK,  0.0000176444584965337379167_REALK,  &
    0.0000158431198628429928453_REALK,  0.0000143612021991173486490_REALK,  &
    0.0000131231114933073787857_REALK,  0.0000120748322468814464896_REALK,  &
    0.0000111768771779245900251_REALK,  0.0000103997916973439146409_REALK,  &
    0.0000097212075679498180817_REALK,  0.0000091238638607079126442_REALK,  &
    0.0000085942479647280753743_REALK,  0.0000081216435977592497909_REALK,  &
    0.0000076974517703995434868_REALK,  0.0000073146984173603220005_REALK,  &
    0.0000069676719832279297059_REALK,  0.0000066516529702933110542_REALK,  &
    0.0000063627095471842856639_REALK,                                      &
    0.3094679948802863123091811_REALK,  0.0188532525189215906247231_REALK,  &
    0.0034320185357800386122262_REALK,  0.0010295999456663444595467_REALK,  &
    0.0004227162225422115564462_REALK,  0.0002152312459090098431622_REALK,  &
    0.0001276152521357906298102_REALK,  0.0000844112626703131418331_REALK,  &
    0.0000604582542733264572885_REALK,  0.0000459229727240492832576_REALK,  &
    0.0000364562751088288498577_REALK,  0.0000299346467873942168340_REALK,  &
    0.0000252343479352392807572_REALK,  0.0000217198249029781221945_REALK,  &
    0.0000190110794151381497501_REALK,  0.0000168699837235894855734_REALK,  &
    0.0000151412149670204157769_REALK,  0.0000137199099963127956869_REALK,  &
    0.0000125331268230982133770_REALK,  0.0000115287879562495329294_REALK,  &
    0.0000106688512391214173844_REALK,  0.0000099249591970631809889_REALK,  &
    0.0000092755899696081790839_REALK,  0.0000087041450402578428953_REALK,  &
    0.0000081976370073157240855_REALK,  0.0000077457709381910777710_REALK,  &
    0.0000073402895046097052078_REALK,  0.0000069744984007423430734_REALK,  &
    0.0000066429171993104907127_REALK,  0.0000063410189261311031050_REALK,  &
    0.0000060650333335119781139_REALK,                                      &
    0.3085296009370356862255846_REALK,  0.0186829298411960026404799_REALK,  &
    0.0033810624828052330756445_REALK,  0.0010087305367711817561532_REALK,  &
    0.0004121124363694911741512_REALK,  0.0002089547496984093014841_REALK,  &
    0.0001234693145079293228814_REALK,  0.0000814450018970555008951_REALK,  &
    0.0000582070588578281167508_REALK,  0.0000441370571685702802866_REALK,  &
    0.0000349906381152222922793_REALK,  0.0000286996874616969547948_REALK,  &
    0.0000241717729889310486838_REALK,  0.0000207900465104006461055_REALK,  &
    0.0000181862241502514486999_REALK,  0.0000161298147306441126442_REALK,  &
    0.0000144706484453516070506_REALK,  0.0000131074449330262591954_REALK,  &
    0.0000119698191123792869789_REALK,  0.0000110075605973554933452_REALK,  &
    0.0000101840185451634901334_REALK,  0.0000094718910939416461930_REALK,  &
    0.0000088504702871407155807_REALK,  0.0000083037942799798664692_REALK,  &
    0.0000078193802337809023534_REALK,  0.0000073873378274911229171_REALK,  &
    0.0000069997376909318770698_REALK,  0.0000066501539586499787120_REALK,  &
    0.0000063333279044900352359_REALK,  0.0000060449171669247712399_REALK,  &
    0.0000057813063967816715846_REALK,                                      &
    0.3075996598646393853648817_REALK,  0.0185151290986464676924239_REALK,  &
    0.0033311367752308102679892_REALK,  0.0009883835571714520012998_REALK,  &
    0.0004018173538007355671993_REALK,  0.0002028818889818474703254_REALK,  &
    0.0001194689127525523479351_REALK,  0.0000785890987153753270379_REALK,  &
    0.0000560433526278722064307_REALK,  0.0000424229016605948827797_REALK,  &
    0.0000335854400267077702062_REALK,  0.0000275167116537898482004_REALK,  &
    0.0000231546711403141191167_REALK,  0.0000199005994819218731933_REALK,  &
    0.0000173975517412009681459_REALK,  0.0000154224200835469673297_REALK,  &
    0.0000138300117760241947384_REALK,  0.0000125225037048702296353_REALK,  &
    0.0000114319760579825860152_REALK,  0.0000105100172914098922674_REALK,  &
    0.0000097213160998211387828_REALK,  0.0000090395863243805157558_REALK,  &
    0.0000084449027012293373265_REALK,  0.0000079219153281548689959_REALK,  &
    0.0000074586261033327140891_REALK,  0.0000070455332503225677712_REALK,  &
    0.0000066750222083431971312_REALK,  0.0000063409246948335385862_REALK,  &
    0.0000060381946450540186871_REALK,  0.0000057626667265132330454_REALK,  &
    0.0000055108740817067189093_REALK,                                      &
    0.3066780468434661677257225_REALK,  0.0183497994206609296719002_REALK,  &
    0.0032822156732667160349004_REALK,  0.0009685438232278408086234_REALK,  &
    0.0003918209727045655205169_REALK,  0.0001970055231085299240774_REALK,  &
    0.0001156086368721668692977_REALK,  0.0000758392671203311882940_REALK,  &
    0.0000539636220584627557847_REALK,  0.0000407775482973187950678_REALK,  &
    0.0000322381376778693411601_REALK,  0.0000263834953776415677017_REALK,  &
    0.0000221810703746775581815_REALK,  0.0000190497150262453625693_REALK,  &
    0.0000166434603161666533268_REALK,  0.0000147463371700715705826_REALK,  &
    0.0000132179601103937769850_REALK,  0.0000119638422284044048635_REALK,  &
    0.0000109184406925459992943_REALK,  0.0000100350770775785061678_REALK,  &
    0.0000092797297962226675397_REALK,  0.0000086270900129634598872_REALK,  &
    0.0000080579851574124237518_REALK,  0.0000075576535122706418524_REALK,  &
    0.0000071145626735375483345_REALK,  0.0000067195839865092355084_REALK,  &
    0.0000063654050828339408700_REALK,  0.0000060461048479975125017_REALK,  &
    0.0000057568412102529179766_REALK,  0.0000054936185961539587435_REALK,  &
    0.0000052531124996673428146_REALK,                                      &
    0.3057646395655544968583683_REALK,  0.0181868912048437879336316_REALK,  &
    0.0032342741839495553306250_REALK,  0.0009491966425933885719360_REALK,  &
    0.0003821136413080280635340_REALK,  0.0001913187766424645052787_REALK,  &
    0.0001118832868385869665565_REALK,  0.0000731913931382608621678_REALK,  &
    0.0000519644983866109650013_REALK,  0.0000391981635948535179028_REALK,  &
    0.0000309462966740099959095_REALK,  0.0000252979110699619133714_REALK,  &
    0.0000212490851446594023171_REALK,  0.0000182357026450975120394_REALK,  &
    0.0000159224194784989311446_REALK,  0.0000141001690891442235676_REALK,  &
    0.0000126332093800371569572_REALK,  0.0000114302729382366334202_REALK,  &
    0.0000104281088487760203131_REALK,  0.0000095817085253490330533_REALK,  &
    0.0000088582921612954114264_REALK,  0.0000082334913353729194261_REALK,  &
    0.0000076888573358443682980_REALK,  0.0000072101938056040931952_REALK,  &
    0.0000067864157550323020484_REALK,  0.0000064087528462939693467_REALK,  &
    0.0000060701827965560082901_REALK,  0.0000057650216689655931068_REALK,  &
    0.0000054886230722774415151_REALK,  0.0000052371542226762234369_REALK,  &
    0.0000050074270808958530564_REALK,                                      &
    0.3048593181721251377247484_REALK,  0.0180263560802815074601835_REALK,  &
    0.0031872880370104649319640_REALK,  0.0009303277970227610479959_REALK,  &
    0.0003726860451947731109161_REALK,  0.0001858150290760530163638_REALK,  &
    0.0001082878641697586488213_REALK,  0.0000706415277419646206762_REALK,  &
    0.0000500427515243673747252_REALK,  0.0000376820331684368651278_REALK,  &
    0.0000297075866764875304814_REALK,  0.0000242579233632293473179_REALK,  &
    0.0000203569125435867627439_REALK,  0.0000174569466403555406881_REALK,  &
    0.0000152329670959725558789_REALK,  0.0000134825816813930591024_REALK,  &
    0.0000120745335358299300463_REALK,  0.0000109206622079718738738_REALK,  &
    0.0000099599267403170386515_REALK,  0.0000091489274570454735467_REALK,  &
    0.0000084560802045627873240_REALK,  0.0000078579214804386552469_REALK,  &
    0.0000073366987154556250465_REALK,  0.0000068787589838960431986_REALK,  &
    0.0000064734471523936209549_REALK,  0.0000061123369881438183971_REALK,  &
    0.0000057886846761935318339_REALK,  0.0000054970338739998101659_REALK,  &
    0.0000052329258995462222658_REALK,  0.0000049926840773058850007_REALK,  &
    0.0000047732511948750412431_REALK,                                      &
    0.3039619651929003629753367_REALK,  0.0178681468719935135358590_REALK,  &
    0.0031412336615864646510721_REALK,  0.0009119235258189223964839_REALK,  &
    0.0003635291948071654299229_REALK,  0.0001804879049561085389147_REALK,  &
    0.0001048175638533263982462_REALK,  0.0000681858800636823687673_REALK,  &
    0.0000481952842320347880499_REALK,  0.0000362265566431733631821_REALK,  &
    0.0000285197768946851864700_REALK,  0.0000232615850457497029774_REALK,  &
    0.0000195028286495058183439_REALK,  0.0000167119027780590176011_REALK,  &
    0.0000145737062351145355531_REALK,  0.0000128923006945693869609_REALK,  &
    0.0000115407619130004064856_REALK,  0.0000104339278893157637296_REALK,  &
    0.0000095128886538477040448_REALK,  0.0000087357947753953141593_REALK,  &
    0.0000080722133664570877500_REALK,  0.0000074995517067116060294_REALK,  &
    0.0000070007267281149662176_REALK,  0.0000065626078679135694150_REALK,  &
    0.0000061749529871348747410_REALK,  0.0000058296663152334415945_REALK,  &
    0.0000055202713568386881576_REALK,  0.0000052415301706944921465_REALK,  &
    0.0000049891641398561132015_REALK,  0.0000047596462918323678682_REALK,  &
    0.0000045500448357333701926_REALK,                                      &
    0.3030724654871722045790250_REALK,  0.0177122175665271365530007_REALK,  &
    0.0030960881637440537846040_REALK,  0.0008939705098925249115993_REALK,  &
    0.0003546344134321391026142_REALK,  0.0001753312644053308874681_REALK,  &
    0.0001014677666023710428389_REALK,  0.0000658208108931420928303_REALK,  &
    0.0000464191265402946244231_REALK,  0.0000348292427851996743262_REALK,  &
    0.0000273807317754795697502_REALK,  0.0000223070332004080075007_REALK,  &
    0.0000186851850322390913221_REALK,  0.0000159990951022155149035_REALK,  &
    0.0000139433022340189568432_REALK,  0.0000123281090776875827713_REALK,  &
    0.0000110307767163871484181_REALK,  0.0000099690369638995084497_REALK,  &
    0.0000090860347472743436625_REALK,  0.0000083414143912898458733_REALK,  &
    0.0000077058515615326618931_REALK,  0.0000071575914891663791078_REALK,  &
    0.0000066801949985999939581_REALK,  0.0000062610336478894248715_REALK,  &
    0.0000058902620989887022831_REALK,  0.0000055601019469213571202_REALK,  &
    0.0000052643333178299315497_REALK,  0.0000049979278530346827843_REALK,  &
    0.0000047567796701062891644_REALK,  0.0000045375053589449528416_REALK,  &
    0.0000043372933695706706019_REALK,                                      &
    0.3021907061865631849428837_REALK,  0.0175585232786567221885399_REALK,  &
    0.0030518293047850347105010_REALK,  0.0008764558564103254109656_REALK,  &
    0.0003459933256514359446905_REALK,  0.0001703391940229851070701_REALK,  &
    0.0000982340314293754274418_REALK,  0.0000635428264485059262527_REALK,  &
    0.0000447114304104657310978_REALK,  0.0000334877048436241738015_REALK,  &
    0.0000262884068814698005007_REALK,  0.0000213924855141446125832_REALK,  &
    0.0000179024054161480021313_REALK,  0.0000153171128916351092478_REALK,  &
    0.0000133404799073585131168_REALK,  0.0000117888443980127639518_REALK,  &
    0.0000105435106203963977850_REALK,  0.0000095250033026453694170_REALK,  &
    0.0000086784489491287026311_REALK,  0.0000079649312471036261399_REALK,  &
    0.0000073561933121780118748_REALK,  0.0000068312867518442564138_REALK,  &
    0.0000063743916663792610743_REALK,  0.0000059733622860168704031_REALK,  &
    0.0000056187345218147095971_REALK,  0.0000053030347617061926287_REALK,  &
    0.0000050202894871763841382_REALK,  0.0000047656714623703998716_REALK,  &
    0.0000045352405094648123919_REALK,  0.0000043257508937157883715_REALK,  &
    0.0000041345063407938846940_REALK,                                      &
    0.3013165766394252931270614_REALK,  0.0174070202191484169063074_REALK,  &
    0.0030084354803056410215811_REALK,  0.0008593670840098583015021_REALK,  &
    0.0003375978462376502935854_REALK,  0.0001655059981492019722648_REALK,  &
    0.0000951120885250614065852_REALK,  0.0000613485724085630361371_REALK,  &
    0.0000430694646225887654931_REALK,  0.0000321996560940087333093_REALK,  &
    0.0000252408449496247860248_REALK,  0.0000205162367505468994024_REALK,  &
    0.0000171529824916138778565_REALK,  0.0000146646077533345702026_REALK,  &
    0.0000127640208775939059649_REALK,  0.0000112733963752929061214_REALK,  &
    0.0000100779444784058713850_REALK,  0.0000091008855277302831027_REALK,  &
    0.0000082892569545030612396_REALK,  0.0000076055294311534637333_REALK,  &
    0.0000070224739686315584697_REALK,  0.0000065199181824413449576_REALK,  &
    0.0000060826377853940585298_REALK,  0.0000056989509933569587252_REALK,  &
    0.0000053597600306426430253_REALK,  0.0000050578840083141059743_REALK,  &
    0.0000047875859113501040699_REALK,  0.0000045442315112079619441_REALK,  &
    0.0000043240395929931351872_REALK,  0.0000041238964533494817371_REALK,  &
    0.0000039412163346798225217_REALK,                                      &
    0.3004499683568244705611505_REALK,  0.0172576656635538387696283_REALK,  &
    0.0029658856999812575547248_REALK,  0.0008426921085585433682935_REALK,  &
    0.0003294401694782855892323_REALK,  0.0001608261904779848471773_REALK,  &
    0.0000920978324293218259455_REALK,  0.0000592348281950316610722_REALK,  &
    0.0000414906098814850739709_REALK,  0.0000309629055745755586118_REALK,  &
    0.0000242361721223737029132_REALK,  0.0000196766553782881137324_REALK,  &
    0.0000164354748685628215387_REALK,  0.0000140402908463470481380_REALK,  &
    0.0000122127610266514742782_REALK,  0.0000107807045278885536328_REALK,  &
    0.0000096331051366040286547_REALK,  0.0000086957849724309931733_REALK,  &
    0.0000079176243130721348179_REALK,  0.0000072624303790825233502_REALK,  &
    0.0000067039640112979731641_REALK,  0.0000062227996250335634350_REALK,  &
    0.0000058042857982074383690_REALK,  0.0000054371867776840451797_REALK,  &
    0.0000051127567565239108772_REALK,  0.0000048240959817265245487_REALK,  &
    0.0000045656944873802586933_REALK,  0.0000043331032668689955104_REALK,  &
    0.0000041226936028829249260_REALK,  0.0000039314784124534086967_REALK,  &
    0.0000037569778935125298386_REALK,                                      &
    0.2995907749600610903151221_REALK,  0.0171104179219968774439131_REALK,  &
    0.0029241595680499928543161_REALK,  0.0008264192294362409513253_REALK,  &
    0.0003215127589107391365038_REALK,  0.0001562944860046229034536_REALK,  &
    0.0000891873154820057114679_REALK,  0.0000571985014943042103662_REALK,  &
    0.0000399723541313605981056_REALK,  0.0000297753540067075018474_REALK,  &
    0.0000232725943435251537343_REALK,  0.0000188721803484729567179_REALK,  &
    0.0000157485041656643752050_REALK,  0.0000134429302300491069908_REALK,  &
    0.0000116855880626041450614_REALK,  0.0000103097559257012095032_REALK,  &
    0.0000092080633474848239833_REALK,  0.0000083088437343569875471_REALK,  &
    0.0000075627546049569336782_REALK,  0.0000069348911581517211643_REALK,  &
    0.0000063999674315522890321_REALK,  0.0000059392765473081308766_REALK,  &
    0.0000055387180810569797558_REALK,  0.0000051874850589607527304_REALK,  &
    0.0000048771698660229658494_REALK,  0.0000046011427611072719409_REALK,  &
    0.0000043541117543266807290_REALK,  0.0000041318055922036105632_REALK,  &
    0.0000039307418545970725785_REALK,  0.0000037480548912158647672_REALK,  &
    0.0000035813664837705634425_REALK,                                      &
    0.2987388921296761923329655_REALK,  0.0169652363099193556617017_REALK,  &
    0.0028832372644694652906450_REALK,  0.0008105371163211279230548_REALK,  &
    0.0003138083374518419702177_REALK,  0.0001519057932938125063393_REALK,  &
    0.0000863767415418443824503_REALK,  0.0000552366230084375478548_REALK,  &
    0.0000385122880699480157397_REALK,  0.0000286349898916841765981_REALK,  &
    0.0000223483939117342418493_REALK,  0.0000181013180142580529664_REALK,  &
    0.0000150907522291169928630_REALK,  0.0000128713483313891548855_REALK,  &
    0.0000111814391961380135259_REALK,  0.0000098595830450299856240_REALK,  &
    0.0000088019317784347585410_REALK,  0.0000079392428177767088182_REALK,  &
    0.0000072238877003813056958_REALK,  0.0000066222028306039677257_REALK,  &
    0.0000061098201873908625031_REALK,  0.0000056687245788379184931_REALK,  &
    0.0000052853455565086675401_REALK,  0.0000049492883492849632410_REALK,  &
    0.0000046524703023246863435_REALK,  0.0000043885210067292637775_REALK,  &
    0.0000041523577413474031101_REALK,  0.0000039398798406780938087_REALK,  &
    0.0000037477452353306388926_REALK,  0.0000035732047339981284421_REALK,  &
    0.0000034139775119552398172_REALK,                                      &
    0.2978942175558981220184762_REALK,  0.0168220811197526444458195_REALK,  &
    0.0028430995267221272591873_REALK,  0.0007950347964595673704719_REALK,  &
    0.0003063198779062530573668_REALK,  0.0001476552070553663505159_REALK,  &
    0.0000836624599623014819898_REALK,  0.0000533463414256286146305_REALK,  &
    0.0000371081008535670454776_REALK,  0.0000275398857759517271936_REALK,  &
    0.0000214619261845644165778_REALK,  0.0000173626391864157653350_REALK,  &
    0.0000144609584752129131084_REALK,  0.0000123244195256514611921_REALK,  &
    0.0000106992989218246746617_REALK,  0.0000094292617207132006058_REALK,  &
    0.0000084138631110630393079_REALK,  0.0000075862003609483888349_REALK,  &
    0.0000069002980992601575019_REALK,  0.0000063236888924481728146_REALK,  &
    0.0000058328887304624512693_REALK,  0.0000054105481170999380997_REALK,  &
    0.0000050436063705651805149_REALK,  0.0000047220649943017655822_REALK,  &
    0.0000044381535850785578605_REALK,  0.0000041857508131389320325_REALK,  &
    0.0000039599748697056779610_REALK,  0.0000037568888032830175491_REALK,  &
    0.0000035732851923318986566_REALK,  0.0000034065265359673646995_REALK,  &
    0.0000032544253867674161887_REALK,                                      &
    0.2970566508904819991165880_REALK,  0.0166809135934831466452355_REALK,  &
    0.0028037276322453608817797_REALK,  0.0007799016424013929848005_REALK,  &
    0.0002990405938386370469050_REALK,  0.0001435380010149281794843_REALK,  &
    0.0000810409598136066554406_REALK,  0.0000515249186008356733785_REALK,  &
    0.0000357575759848609045738_REALK,  0.0000264881946775630863202_REALK,  &
    0.0000206116164264993151432_REALK,  0.0000166547763187906477033_REALK,  &
    0.0000138579173511333948401_REALK,  0.0000118010678256361590551_REALK,  &
    0.0000102381968994474582309_REALK,  0.0000090179091911216479861_REALK,  &
    0.0000080430482271213582626_REALK,  0.0000072489699445500926253_REALK,  &
    0.0000065912933470362204067_REALK,  0.0000060387037841756996778_REALK,  &
    0.0000055685686011707688910_REALK,  0.0000051641789980893711696_REALK,  &
    0.0000048129646312264284669_REALK,  0.0000045053079732123061611_REALK,  &
    0.0000042337386662340217400_REALK,  0.0000039923746159246364319_REALK,  &
    0.0000037765269061877556016_REALK,  0.0000035824157048280911733_REALK,  &
    0.0000034069627687378772851_REALK,  0.0000032476377155080966892_REALK,  &
    0.0000031023426254476186553_REALK,                                      &
    0.2962260936999003835268240_REALK,  0.0165416958960812633672166_REALK,  &
    0.0027651033814635773977475_REALK,  0.0007651273601828006802605_REALK,  &
    0.0002919639307951871925496_REALK,  0.0001395496210676497165527_REALK,  &
    0.0000785088643406923363584_REALK,  0.0000497697249376115652604_REALK,  &
    0.0000344585873753306667694_REALK,  0.0000254781466667523877486_REALK,  &
    0.0000197959567945554118311_REALK,  0.0000159764208178720658012_REALK,  &
    0.0000132804759086760555426_REALK,  0.0000113002646743658797027_REALK,  &
    0.0000097972059308449400337_REALK,  0.0000086246822317738097095_REALK,  &
    0.0000076887144770522048305_REALK,  0.0000069268389774842611712_REALK,  &
    0.0000062962125232512881695_REALK,  0.0000057666314700862525186_REALK,  &
    0.0000053162830886932683971_REALK,  0.0000049290752285290723270_REALK,  &
    0.0000045929092056422203135_REALK,  0.0000042985337546450721853_REALK,  &
    0.0000040387668392493494216_REALK,  0.0000038079561495791976021_REALK,  &
    0.0000036015979655186502248_REALK,  0.0000034160632473036659477_REALK,  &
    0.0000032483976846899394246_REALK,  0.0000030961736302553456548_REALK,  &
    0.0000029573790021962110618_REALK,                                      &
    0.2954024494198403405498254_REALK,  0.0164043910897640962676114_REALK,  &
    0.0027272090814003118082465_REALK,  0.0007507019779397155296793_REALK,  &
    0.0002850835578606293759484_REALK,  0.0001356856787032769014450_REALK,  &
    0.0000760629256471870106695_REALK,  0.0000480782349625973347068_REALK,  &
    0.0000332090955751266161435_REALK,  0.0000245080455939152702660_REALK,  &
    0.0000190135034554283399906_REALK,  0.0000153263204709619948465_REALK,  &
    0.0000127275314858580692343_REALK,  0.0000108210268366540896104_REALK,  &
    0.0000093754400279432843589_REALK,  0.0000082487753735376042290_REALK,  &
    0.0000073501240273880471396_REALK,  0.0000066191271565069692424_REALK,  &
    0.0000060144247995036951603_REALK,  0.0000055068840830531027420_REALK,  &
    0.0000050754819529106168623_REALK,  0.0000047047197768141983361_REALK,  &
    0.0000043829525731294097121_REALK,  0.0000041012812057858131370_REALK,  &
    0.0000038528006991807109630_REALK,  0.0000036320794540653940477_REALK,  &
    0.0000034347915594806760617_REALK,  0.0000032574526980997934866_REALK,  &
    0.0000030972274616005486383_REALK,  0.0000029517867346970854589_REALK,  &
    0.0000028192007366915962226_REALK,                                      &
    0.2945856233109681587833961_REALK,  0.0162689631090634813370688_REALK,  &
    0.0026900275298492445572029_REALK,  0.0007366158349351993551643_REALK,  &
    0.0002783933595374185436533_REALK,  0.0001319419446915828027667_REALK,  &
    0.0000737000195960382819584_REALK,  0.0000464480230844961132432_REALK,  &
    0.0000320071441628908334850_REALK,  0.0000235762659585649678835_REALK,  &
    0.0000182628738283765658802_REALK,  0.0000147032769876679684476_REALK,  &
    0.0000121980294915604735220_REALK,  0.0000103624143850770792269_REALK,  &
    0.0000089720525678432022691_REALK,  0.0000078894192015655536225_REALK,  &
    0.0000070265722833930335873_REALK,  0.0000063251849962901183285_REALK,  &
    0.0000057453280635933327269_REALK,  0.0000052589006317035625268_REALK,  &
    0.0000048456402053768321211_REALK,  0.0000044906194199631341350_REALK,  &
    0.0000041826297314529296359_REALK,  0.0000039131105522797665278_REALK,  &
    0.0000036754231512723717168_REALK,  0.0000034643479278027770836_REALK,  &
    0.0000032757296905426272575_REALK,  0.0000031062230209746775043_REALK,  &
    0.0000029531065875409389691_REALK,  0.0000028141457773875199197_REALK,  &
    0.0000026874897208146746768_REALK,                                      &
    0.2937755224159203648603977_REALK,  0.0161353767366719941245279_REALK,  &
    0.0026535420000838392390330_REALK,  0.0007228595709851145080863_REALK,  &
    0.0002718874279343783161370_REALK,  0.0001283143430175434380330_REALK,  &
    0.0000714171409177397141337_REALK,  0.0000448767595296978793161_REALK,  &
    0.0000308508562887557062095_REALK,  0.0000226812499131171157530_REALK,  &
    0.0000175427439483027917803_REALK,  0.0000141061436496836925693_REALK,  &
    0.0000116909612886049997743_REALK,  0.0000099235287760994714550_REALK,  &
    0.0000085862345310203237709_REALK,  0.0000075458787312899360610_REALK,  &
    0.0000067173863835094942305_REALK,  0.0000060443924266867314802_REALK,  &
    0.0000054883476068089348201_REALK,  0.0000050221457671327684498_REALK,  &
    0.0000046262569465968223406_REALK,  0.0000042863036439755487303_REALK,  &
    0.0000039914971538919866501_REALK,  0.0000037336023865398425794_REALK,  &
    0.0000035062364657834047026_REALK,  0.0000033043834249051661743_REALK,  &
    0.0000031240519879146916962_REALK,  0.0000029620300477672475455_REALK,  &
    0.0000028157057218178703386_REALK,  0.0000026829350359067058928_REALK,  &
    0.0000025619427817792123492_REALK,                                      &
    0.2929720555174838980683205_REALK,  0.0160035975800402949231760_REALK,  &
    0.0026177362260860342901836_REALK,  0.0007094241162668696700291_REALK,  &
    0.0002655600552525480052314_REALK,  0.0001247989450560914282632_REALK,  &
    0.0000692113985175161995286_REALK,  0.0000433622064470629725065_REALK,  &
    0.0000297384313639062906388_REALK,  0.0000218215043956256458002_REALK,  &
    0.0000168518459437392205413_REALK,  0.0000135338230640472734808_REALK,  &
    0.0000112053621708540083655_REALK,  0.0000095035110122891942750_REALK,  &
    0.0000082172128188714863494_REALK,  0.0000072174518579680410193_REALK,  &
    0.0000064219237623250826591_REALK,  0.0000057761574541130161097_REALK,  &
    0.0000052429348714480247286_REALK,  0.0000047961086063998857398_REALK,  &
    0.0000044168542570019663789_REALK,  0.0000040913235951159345065_REALK,  &
    0.0000038091317947281726379_REALK,  0.0000035623567222026762486_REALK,  &
    0.0000033448613768888226056_REALK,  0.0000031518253945953883998_REALK,  &
    0.0000029794148840384743580_REALK,  0.0000028245456889388220422_REALK,  &
    0.0000026847109368949387659_REALK,  0.0000025578535877896091822_REALK,  &
    0.0000024422709799523510873_REALK,                                      &
    0.2921751330979281413569026_REALK,  0.0158735920487005979784279_REALK,  &
    0.0025825943882752553856785_REALK,  0.0006963006814966948626253_REALK,  &
    0.0002594057265565092250913_REALK,  0.0001213919639767113651868_REALK,  &
    0.0000670800109731919475204_REALK,  0.0000419022141746957664434_REALK,  &
    0.0000286681418903990890259_REALK,  0.0000209955983858527137401_REALK,  &
    0.0000161889656246798542159_REALK,  0.0000129852650152816670849_REALK,  &
    0.0000107403094301296265448_REALK,  0.0000091015398867471940947_REALK,  &
    0.0000078642486470152491237_REALK,  0.0000069034678764320926762_REALK,  &
    0.0000061395707789295120738_REALK,  0.0000055199148841076101050_REALK,  &
    0.0000050085662557975576297_REALK,  0.0000045803016101856786445_REALK,  &
    0.0000042169761391384860512_REALK,  0.0000039052510797600670185_REALK,  &
    0.0000036351301409016197722_REALK,  0.0000033989920925804768566_REALK,  &
    0.0000031909362235972734456_REALK,  0.0000030063300608247501643_REALK,  &
    0.0000028414908296178062489_REALK,  0.0000026934571811223506507_REALK,  &
    0.0000025598229959042200791_REALK,  0.0000024386146157307543907_REALK,  &
    0.0000023281989397294402818_REALK,                                      &
    0.2913846672994531705747079_REALK,  0.0157453273322914477638790_REALK,  &
    0.0025481010997196189456215_REALK,  0.0006834807484614434120590_REALK,  &
    0.0002534191128199302176643_REALK,  0.0001180897493685392811652_REALK,  &
    0.0000650203022158127975179_REALK,  0.0000404947176618471066400_REALK,  &
    0.0000276383304252060584211_REALK,  0.0000202021602793031970378_REALK,  &
    0.0000155529401754252066576_REALK,  0.0000124594644120288820924_REALK,  &
    0.0000102949205089334376768_REALK,  0.0000087168303060509250510_REALK,  &
    0.0000075266360109177780281_REALK,  0.0000066032860678498640666_REALK,  &
    0.0000058697414076729954817_REALK,  0.0000052751251022602020711_REALK,  &
    0.0000047847419739304587169_REALK,  0.0000043742595121098147231_REALK,  &
    0.0000040261875086966376837_REALK,  0.0000037276776105495547619_REALK,  &
    0.0000034691073076883924559_REALK,  0.0000032431446910585731076_REALK,  &
    0.0000030441161307220054458_REALK,  0.0000028675696402154261664_REALK,  &
    0.0000027099675453832161294_REALK,  0.0000025684663699413728633_REALK,  &
    0.0000024407566640746933985_REALK,  0.0000023249447454518958552_REALK,  &
    0.0000022194642119063015091_REALK,                                      &
    0.2906005718857194164428392_REALK,  0.0156187713792602812096222_REALK,  &
    0.0025142413928119717106413_REALK,  0.0006709560608914883622633_REALK,  &
    0.0002475950642345292932421_REALK,  0.0001148887820770209711478_REALK,  &
    0.0000630296973854331836137_REALK,  0.0000391377330393794900282_REALK,  &
    0.0000266474066727160245692_REALK,  0.0000194398753740860278760_REALK,  &
    0.0000149426559478204798030_REALK,  0.0000119554593239815274509_REALK,  &
    0.0000098683512351291476029_REALK,  0.0000083486316881750433387_REALK,  &
    0.0000072037002205673084782_REALK,  0.0000063162943504451539621_REALK,  &
    0.0000056118759884744961450_REALK,  0.0000050412729108325170308_REALK,  &
    0.0000045709849677939097317_REALK,  0.0000041775382973226227076_REALK,  &
    0.0000038440732321187053759_REALK,  0.0000035582134967039486673_REALK,  &
    0.0000033106961763493134407_REALK,  0.0000030944675514809515593_REALK,  &
    0.0000029040722280339100303_REALK,  0.0000027352315965317773771_REALK,  &
    0.0000025845473088680186857_REALK,  0.0000024492890264425575603_REALK,  &
    0.0000023272400524822153833_REALK,  0.0000022165834146940878704_REALK,  &
    0.0000021158166660633790606_REALK,                                      &
    0.2898227622044262097311673_REALK,  0.0154938928762209538608774_REALK,  &
    0.0024810007063940354120335_REALK,  0.0006587186156618061267862_REALK,  &
    0.0002419286037720984306430_REALK,  0.0001117856692435552281185_REALK,  &
    0.0000611057188547970369210_REALK,  0.0000378293543325111672406_REALK,  &
    0.0000256938447001745763566_REALK,  0.0000187074834656986705556_REALK,  &
    0.0000143570463504743940707_REALK,  0.0000114723291051101594499_REALK,  &
    0.0000094597941349267384767_REALK,  0.0000079962264320195689454_REALK,  &
    0.0000068947965010761825121_REALK,  0.0000060419079912731261914_REALK,  &
    0.0000053654400339606913962_REALK,  0.0000048178664185186662370_REALK,  &
    0.0000043668398691846040019_REALK,  0.0000039897142280977243556_REALK,  &
    0.0000036702372086314832899_REALK,  0.0000033964869764431974802_REALK,  &
    0.0000031595465717996923235_REALK,  0.0000029526297666622439100_REALK,  &
    0.0000027704909058140566068_REALK,  0.0000026090179299725954740_REALK,  &
    0.0000024649462745560426562_REALK,  0.0000023356541955651224927_REALK,  &
    0.0000022190139926032367393_REALK,  0.0000021132822718705642776_REALK,  &
    0.0000020170179115487386325_REALK,                                      &
    0.2890511551509061249909394_REALK,  0.0153706612279441209162334_REALK,  &
    0.0024483648733125387871035_REALK,  0.0006467606543088331560315_REALK,  &
    0.0002364149209896382894738_REALK,  0.0001087771395398995518365_REALK,  &
    0.0000592459824139501435168_REALK,  0.0000365677503098255318693_REALK,  &
    0.0000247761802707845751252_REALK,  0.0000180037765450375526147_REALK,  &
    0.0000137950898297383871185_REALK,  0.0000110091925993550104884_REALK,  &
    0.0000090684768206665690411_REALK,  0.0000076589284553208976310_REALK,  &
    0.0000065993086562250817732_REALK,  0.0000057795683762710693457_REALK,  &
    0.0000051299230908388695737_REALK,  0.0000046044359809068935975_REALK,  &
    0.0000041718720093143748251_REALK,  0.0000038103829142552381720_REALK,  &
    0.0000035043014946447646284_REALK,  0.0000032421433895639888457_REALK,  &
    0.0000030153244784371581730_REALK,  0.0000028173157432468039545_REALK,  &
    0.0000026430731051045839023_REALK,  0.0000024886444996539313956_REALK,  &
    0.0000023508938258359911924_REALK,  0.0000022273035751422928439_REALK,  &
    0.0000021158314402231049282_REALK,  0.0000020148046029830907182_REALK,  &
    0.0000019228407457111713315_REALK,                                      &
    0.2882856691327046472217432_REALK,  0.0152490465379594083983328_REALK,  &
    0.0024163201083918744820067_REALK,  0.0006350746548511946578883_REALK,  &
    0.0002310493660680723018632_REALK,  0.0001058600385894632690473_REALK,  &
    0.0000574481936091164805520_REALK,  0.0000353511614627894285557_REALK,  &
    0.0000238930082894204363236_REALK,  0.0000173275965951509111520_REALK,  &
    0.0000132558079384165470774_REALK,  0.0000105652064251297578138_REALK,  &
    0.0000086936604500629792078_REALK,  0.0000073360817978720169091_REALK,  &
    0.0000063166477921031113826_REALK,  0.0000055287418359363563102_REALK,  &
    0.0000049048376530281597512_REALK,  0.0000044005331893193047981_REALK,  &
    0.0000039856664737768906237_REALK,  0.0000036391584263465698748_REALK,  &
    0.0000033459054685567157394_REALK,  0.0000030948443883085144662_REALK,  &
    0.0000028777112923530194894_REALK,  0.0000026882244912218239054_REALK,  &
    0.0000025215336410386681924_REALK,  0.0000023738403777302947318_REALK,  &
    0.0000022421319572724725846_REALK,  0.0000021239909240024792847_REALK,  &
    0.0000020174569073197522023_REALK,  0.0000019209247854725301590_REALK,  &
    0.0000018330686280997561174_REALK,                                      &
    0.2875262240351148523842539_REALK,  0.0151290195897487971671280_REALK,  &
    0.0023848529968083526792144_REALK,  0.0006236533239028454632044_REALK,  &
    0.0002258274440753798531934_REALK,  0.0001030313245679325312746_REALK,  &
    0.0000557101442294503503374_REALK,  0.0000341778971102712776208_REALK,  &
    0.0000230429803561246398038_REALK,  0.0000166778334824431006406_REALK,  &
    0.0000127382634883535966378_REALK,  0.0000101395633351433958608_REALK,  &
    0.0000083346382537156754567_REALK,  0.0000070270592871153458108_REALK,  &
    0.0000060462510981269730839_REALK,  0.0000052889185241043410658_REALK,  &
    0.0000046897181241860315829_REALK,  0.0000042057299058124873243_REALK,  &
    0.0000038078272008282882989_REALK,  0.0000034756724496287122533_REALK,  &
    0.0000031947050340957044888_REALK,  0.0000029542671847485761658_REALK,  &
    0.0000027464031082361823527_REALK,  0.0000025650689464698805365_REALK,  &
    0.0000024056005577043681442_REALK,  0.0000022643472336744552699_REALK,  &
    0.0000021384146857734244573_REALK,  0.0000020254814978047800124_REALK,  &
    0.0000019236659206085897209_REALK,  0.0000018314277677361213762_REALK,  &
    0.0000017474951794069025372_REALK,                                      &
    0.2867727411876379584043661_REALK,  0.0150105518285115722976197_REALK,  &
    0.0023539504828517182968839_REALK,  0.0006124895890676277081938_REALK,  &
    0.0002207448094453659721316_REALK,  0.0001002880639759890564911_REALK,  &
    0.0000540297089355485109143_REALK,  0.0000330463326227867985711_REALK,  &
    0.0000222248024227695937106_REALK,  0.0000160534229382293065281_REALK,  &
    0.0000122415587832175442321_REALK,  0.0000097314906482023636673_REALK,  &
    0.0000079907341278404051471_REALK,  0.0000067312612633040687544_REALK,  &
    0.0000057875806828432758134_REALK,  0.0000050596113474111425833_REALK,  &
    0.0000044841198273739481142_REALK,  0.0000040196173422218218720_REALK,  &
    0.0000036379761209875734246_REALK,  0.0000033195734769443530906_REALK,  &
    0.0000030503718604150025626_REALK,  0.0000028201038329901779528_REALK,  &
    0.0000026211100393546940730_REALK,  0.0000024475753248198452366_REALK,  &
    0.0000022950145130696583691_REALK,  0.0000021599187473042578230_REALK,  &
    0.0000020395074892990891073_REALK,  0.0000019315515113062128229_REALK,  &
    0.0000018342445054942131543_REALK,  0.0000017461085731029019778_REALK,  &
    0.0000016659237039878954961_REALK,                                      &
    0.2860251433313418245596438_REALK,  0.0148936153434818183138866_REALK,  &
    0.0023235998590601355043295_REALK,  0.0006015765916046781573018_REALK,  &
    0.0002157972606636402433146_REALK,  0.0000976274275771827314274_REALK,  &
    0.0000524048420238622784549_REALK,  0.0000319549067614248021594_REALK,  &
    0.0000214372325484644648381_REALK,  0.0000154533446267209654504_REALK,  &
    0.0000117648339279606229605_REALK,  0.0000093402487498083087953_REALK,  &
    0.0000076613012893092057151_REALK,  0.0000064481143615561169842_REALK,  &
    0.0000055401224620395895436_REALK,  0.0000048403549431403948566_REALK,  &
    0.0000042876180597134692005_REALK,  0.0000038418051812338711480_REALK,  &
    0.0000034757523360589858212_REALK,  0.0000031705260387150480384_REALK,  &
    0.0000029125926572412949242_REALK,  0.0000026920605445853646122_REALK,  &
    0.0000025015555690790040155_REALK,  0.0000023354825061303090150_REALK,  &
    0.0000021895281925661463915_REALK,  0.0000020603200492129773105_REALK,  &
    0.0000019451867718232829932_REALK,  0.0000018419876258218830627_REALK,  &
    0.0000017489886942370271027_REALK,  0.0000016647718271174655836_REALK,  &
    0.0000015881667348477740192_REALK,                                      &
    0.2852833545870899767393780_REALK,  0.0147781828507800826189023_REALK,  &
    0.0022937887557153316224479_REALK,  0.0005909076793545234816685_REALK,  &
    0.0002109807351527102621622_REALK,  0.0000950466864943024148825_REALK,  &
    0.0000508335743213974661182_REALK,  0.0000309021191266223611165_REALK,  &
    0.0000206790787494808231493_REALK,  0.0000148766202956900663441_REALK,  &
    0.0000113072652115936161959_REALK,  0.0000089651296585030907185_REALK,  &
    0.0000073457209902184658314_REALK,  0.0000061770703482438549836_REALK,  &
    0.0000053033850967993636827_REALK,  0.0000046307047032552629021_REALK,  &
    0.0000040998071899771006168_REALK,  0.0000036719207375589529067_REALK,  &
    0.0000033208113357621104503_REALK,  0.0000030282099683337930516_REALK,  &
    0.0000027810684834539830415_REALK,  0.0000025698570356092240554_REALK,  &
    0.0000023874759324787713463_REALK,  0.0000022285414470046180539_REALK,  &
    0.0000020889057499927891265_REALK,  0.0000019653271873208396659_REALK,  &
    0.0000018552393533163746049_REALK,  0.0000017565864606949526862_REALK,  &
    0.0000016677040571951772863_REALK,  0.0000015872313070346254187_REALK,  &
    0.0000015140456000356321965_REALK,                                      &
    0.2845473004246154014040826_REALK,  0.0146642276767815563087716_REALK,  &
    0.0022645051306851259054209_REALK,  0.0005804763999161035052318_REALK,  &
    0.0002062913043484279639918_REALK,  0.0000925432084578674615674_REALK,  &
    0.0000493140102053257634181_REALK,  0.0000298865277121656269246_REALK,  &
    0.0000199491969396526672121_REALK,  0.0000143223120062305943486_REALK,  &
    0.0000108680635600597574593_REALK,  0.0000086054556550532696835_REALK,  &
    0.0000070434012893300049855_REALK,  0.0000059176050092798450299_REALK,  &
    0.0000050768989792439508303_REALK,  0.0000044302358425182322823_REALK,  &
    0.0000039202997971568683612_REALK,  0.0000035096081573687740874_REALK,  &
    0.0000031728242502415348494_REALK,  0.0000028923197013255084372_REALK,  &
    0.0000026555140875501324304_REALK,  0.0000024532259039346903942_REALK,  &
    0.0000022786195265963641140_REALK,  0.0000021265146208048849899_REALK,  &
    0.0000019929222744642677825_REALK,  0.0000018747266183262104073_REALK,  &
    0.0000017694619835780212230_REALK,  0.0000016751541276501460715_REALK,  &
    0.0000015902052560586015972_REALK,  0.0000015133095124802485894_REALK,  &
    0.0000014433900094388103839_REALK,                                      &
    0.2838169076324131845368015_REALK,  0.0145517237419837078965523_REALK,  &
    0.0022357372596010388100807_REALK,  0.0005702764940653500327916_REALK,  &
    0.0002017251689603375124776_REALK,  0.0000901144542006240226867_REALK,  &
    0.0000478443247423587409719_REALK,  0.0000289067465599894849945_REALK,  &
    0.0000192464889573832408456_REALK,  0.0000137895204381869796508_REALK,  &
    0.0000104464730561376813335_REALK,  0.0000082605779716934480615_REALK,  &
    0.0000067537758778502407500_REALK,  0.0000056692170879686081285_REALK,  &
    0.0000048602152638093870535_REALK,  0.0000042385425086976440627_REALK,  &
    0.0000037487258481414349723_REALK,  0.0000033545276542460503347_REALK,  &
    0.0000030314771368073814008_REALK,  0.0000027625636067181538542_REALK,  &
    0.0000025356572785199333422_REALK,  0.0000023419120353050336189_REALK,  &
    0.0000021747463480639540604_REALK,  0.0000020291754836927747898_REALK,  &
    0.0000019013632821892622272_REALK,  0.0000017883147228926297171_REALK,  &
    0.0000016876608788027811083_REALK,  0.0000015975057869578803136_REALK,  &
    0.0000015163156180418141000_REALK,  0.0000014428372562827015013_REALK,  &
    0.0000013760376610159178311_REALK,                                      &
    0.2830921042884271265904772_REALK,  0.0144406455453568848684709_REALK,  &
    0.0022074737263591058360201_REALK,  0.0005603018894062934338041_REALK,  &
    0.0001972786544087692570636_REALK,  0.0000877579739921809147624_REALK,  &
    0.0000464227609429496395742_REALK,  0.0000279614435115392097775_REALK,  &
    0.0000185699006755566733160_REALK,  0.0000132773832679737987329_REALK,  &
    0.0000100417695234349732531_REALK,  0.0000079298755387733428548_REALK,  &
    0.0000064763029571229499784_REALK,  0.0000054314272701988437650_REALK,  &
    0.0000046529049419995378257_REALK,  0.0000040552369329495081341_REALK,  &
    0.0000035847319127172335054_REALK,  0.0000032063547799740407594_REALK,  &
    0.0000028964702993324325538_REALK,  0.0000026386633491389110380_REALK,  &
    0.0000024212383257264885184_REALK,  0.0000022356720368678282758_REALK,  &
    0.0000020756274567928386624_REALK,  0.0000019363079654847599025_REALK,  &
    0.0000018140242319187017110_REALK,  0.0000017058973434612577661_REALK,  &
    0.0000016096512798135829791_REALK,  0.0000015234652243848464109_REALK,  &
    0.0000014458667300505215043_REALK,  0.0000013756532745255737045_REALK,  &
    0.0000013118338655526572403_REALK,                                      &
    0.2823728197315082955043408_REALK,  0.0143309681491620693333244_REALK,  &
    0.0021797034139325226556605_REALK,  0.0005505466942460455906719_REALK,  &
    0.0001929482064318174643069_REALK,  0.0000854714043081646475094_REALK,  &
    0.0000450476271255988240097_REALK,  0.0000270493380516381262571_REALK,  &
    0.0000179184201908151260769_REALK,  0.0000127850736156519607288_REALK,  &
    0.0000096532591716686848543_REALK,  0.0000076127537862704805439_REALK,  &
    0.0000062104641659242395841_REALK,  0.0000052037772148524139156_REALK,  &
    0.0000044545579586548486332_REALK,  0.0000038799486185521603180_REALK,  &
    0.0000034279804141930874479_REALK,  0.0000030647797285714435956_REALK,  &
    0.0000027675176388064808248_REALK,  0.0000025203532802195831003_REALK,  &
    0.0000023120093864492201228_REALK,  0.0000021342736968986908659_REALK,  &
    0.0000019810444645243444203_REALK,  0.0000018477059841665988969_REALK,  &
    0.0000017307100629602046793_REALK,  0.0000016272893436313383970_REALK,  &
    0.0000015352570309484059800_REALK,  0.0000014528644479569504929_REALK,  &
    0.0000013786980518842361710_REALK,  0.0000013116038549180696530_REALK,  &
    0.0000012506311890686817670_REALK,                                      &
    0.2816589845336201491932115_REALK,  0.0142226671642204042372848_REALK,  &
    0.0021524154954851025707552_REALK,  0.0005410051916853202873606_REALK,  &
    0.0001887303868556093860553_REALK,  0.0000832524646285004503400_REALK,  &
    0.0000437172943867338164334_REALK,  0.0000261691992409779976780_REALK,  &
    0.0000172910760888128568671_REALK,  0.0000123117985582648185736_REALK,  &
    0.0000092802773005482896496_REALK,  0.0000073086434977443635777_REALK,  &
    0.0000059557635551487769370_REALK,  0.0000049858286274012314146_REALK,  &
    0.0000042647823678614760307_REALK,  0.0000037123235662529284357_REALK,  &
    0.0000032781489140234990104_REALK,  0.0000029295066720504807581_REALK,  &
    0.0000026443460336157822002_REALK,  0.0000024073798579600230250_REALK,  &
    0.0000022077339598113788935_REALK,  0.0000020374954694995541468_REALK,  &
    0.0000018907890470861256115_REALK,  0.0000017631729829646775082_REALK,  &
    0.0000016512347547052767259_REALK,  0.0000015523141881002043746_REALK,  &
    0.0000014643101786330241156_REALK,  0.0000013855433036047872105_REALK,  &
    0.0000013146565475802206547_REALK,  0.0000012505424826210005942_REALK,  &
    0.0000011922891120436309840_REALK,                                      &
    0.2809505304727696883837496_REALK,  0.0141157187356197397903879_REALK,  &
    0.0021255994257749961408310_REALK,  0.0005316718339164913610315_REALK,  &
    0.0001846218695215395616191_REALK,  0.0000810989543596509464014_REALK,  &
    0.0000424301941718270464216_REALK,  0.0000253198437335150811122_REALK,  &
    0.0000166869357822072391555_REALK,  0.0000118567977065689144083_REALK,  &
    0.0000089221870596988348538_REALK,  0.0000070169997144157867974_REALK,  &
    0.0000057117266077769049127_REALK,  0.0000047771623747548485174_REALK,  &
    0.0000040832035267124745776_REALK,  0.0000035520235345658773745_REALK,  &
    0.0000031349294288814354724_REALK,  0.0000028002531264464974388_REALK,  &
    0.0000025266947481822246268_REALK,  0.0000022995010927608392001_REALK,  &
    0.0000021081863658729038509_REALK,  0.0000019451259831149289651_REALK,  &
    0.0000018046624792532740818_REALK,  0.0000016825214889244197884_REALK,  &
    0.0000015754209066655995609_REALK,  0.0000014808035422017043884_REALK,  &
    0.0000013966505887178111011_REALK,  0.0000013213491088061407412_REALK,  &
    0.0000012535963340470848591_REALK,  0.0000011923295027075588910_REALK,  &
    0.0000011366737046706016649_REALK,                                      &
    0.2802473905066427128929263_REALK,  0.0140100995288440118013984_REALK,  &
    0.0020992449328384775800171_REALK,  0.0005225412367214952264957_REALK,  &
    0.0001806194363643990957128_REALK,  0.0000790087498758553391813_REALK,  &
    0.0000411848159435961806273_REALK,  0.0000245001338752132757155_REALK,  &
    0.0000161051039182857120451_REALK,  0.0000114193418424186079557_REALK,  &
    0.0000085783782621734706788_REALK,  0.0000067373006871578957442_REALK,  &
    0.0000054778993021073054217_REALK,  0.0000045773776395099149877_REALK,  &
    0.0000039094633252141174949_REALK,  0.0000033987253334362398139_REALK,  &
    0.0000029980277787019371555_REALK,  0.0000026767493467339127498_REALK,  &
    0.0000024143148686601411106_REALK,  0.0000021964860188970243599_REALK,  &
    0.0000020131512487249227965_REALK,  0.0000018569635717618519887_REALK,  &
    0.0000017224751911637053446_REALK,  0.0000016055726919940908545_REALK,  &
    0.0000015030993380618571092_REALK,  0.0000014125968901273354997_REALK,  &
    0.0000013321255817004065302_REALK,  0.0000012601363033818389479_REALK,  &
    0.0000011953783461758322176_REALK,  0.0000011368317984767865942_REALK,  &
    0.0000010836573173822953626_REALK,                                      &
    0.2795494987469222536446978_REALK,  0.0139057867163115359693260_REALK,  &
    0.0020733420099439936988561_REALK,  0.0005136081741621705042469_REALK,  &
    0.0001767199736355647360711_REALK,  0.0000769798016746139906899_REALK,  &
    0.0000399797049433041069410_REALK,  0.0000237089758807269771325_REALK,  &
    0.0000155447208532618430337_REALK,  0.0000109987316141845777430_REALK,  &
    0.0000082482662492122522089_REALK,  0.0000064690468742843699416_REALK,  &
    0.0000052538472163282893881_REALK,  0.0000043860911118341502869_REALK,  &
    0.0000037432194507055098823_REALK,  0.0000032521201497571562845_REALK,  &
    0.0000028671629642850746143_REALK,  0.0000025587377493067608054_REALK,  &
    0.0000023069687644475729311_REALK,  0.0000020981141902596730816_REALK,  &
    0.0000019224231024768826805_REALK,  0.0000017728158279209650719_REALK,  &
    0.0000016440463452865496949_REALK,  0.0000015321560436594075483_REALK,  &
    0.0000014341087060522506961_REALK,  0.0000013475411709562310227_REALK,  &
    0.0000012705895849962834055_REALK,  0.0000012017661166399033087_REALK,  &
    0.0000011398700176544041664_REALK,  0.0000010839224848735759342_REALK,  &
    0.0000010331182859303270456_REALK,                                      &
    0.2788567904342699743658329_REALK,  0.0138027579643091400513066_REALK,  &
    0.0020478809078070358933032_REALK,  0.0005048675734559346373054_REALK,  &
    0.0001729204682656554630405_REALK,  0.0000750101316418613133039_REALK,  &
    0.0000388134600413452172745_REALK,  0.0000229453180847617582152_REALK,  &
    0.0000150049611904022486917_REALK,  0.0000105942962876998941356_REALK,  &
    0.0000079312908040097593836_REALK,  0.0000062117599831140493560_REALK,  &
    0.0000050391546725902259735_REALK,  0.0000042029362172997653923_REALK,  &
    0.0000035841446852372669643_REALK,  0.0000031119129032960758335_REALK,  &
    0.0000027420665731127381251_REALK,  0.0000024459723607633499724_REALK,  &
    0.0000022044295743276051763_REALK,  0.0000020041751992485547695_REALK,  &
    0.0000018358058190788406617_REALK,  0.0000016924991760857464921_REALK,  &
    0.0000015692034329894273430_REALK,  0.0000014621088742190053973_REALK,  &
    0.0000013682951417322882987_REALK,  0.0000012854904316625050531_REALK,  &
    0.0000012119038014597300074_REALK,  0.0000011461062501022412570_REALK,  &
    0.0000010869449767486735909_REALK,  0.0000010334806163055731956_REALK,  &
    0.0000009849406503330973536_REALK,                                      &
    0.2781692019139517246806292_REALK,  0.0137009914203091633794207_REALK,  &
    0.0020228521270567382910055_REALK,  0.0004963145100299500012131_REALK,  &
    0.0001692180043612778912732_REALK,  0.0000730978304224528564748_REALK,  &
    0.0000376847316734617272067_REALK,  0.0000222081492649898892973_REALK,  &
    0.0000144850323792679741710_REALK,  0.0000102053925503373198842_REALK,  &
    0.0000076269151123498071993_REALK,  0.0000059649820533811737967_REALK,  &
    0.0000048334239188206088117_REALK,  0.0000040275623790545753866_REALK,  &
    0.0000034319262344219318844_REALK,  0.0000029778216316516286994_REALK,  &
    0.0000026224822120932292557_REALK,  0.0000023382182917915174322_REALK,  &
    0.0000021064807161081796632_REALK,  0.0000019144682177484889826_REALK,  &
    0.0000017531122569696062222_REALK,  0.0000016158384660121134605_REALK,  &
    0.0000014977818897937106670_REALK,  0.0000013952760278329689959_REALK,  &
    0.0000013055119030759120618_REALK,  0.0000012263054963060404626_REALK,  &
    0.0000011559358933940457531_REALK,  0.0000010930305750825918622_REALK,  &
    0.0000010364827563465530145_REALK,  0.0000009853909081795281794_REALK,  &
    0.0000009390138870386180391_REALK,                                      &
    0.2774866706120870940566192_REALK,  0.0136004657006570071897666_REALK,  &
    0.0019982464109454360634555_REALK,  0.0004879442027472085372831_REALK,  &
    0.0001656097598307025814228_REALK,  0.0000712410548917743308671_REALK,  &
    0.0000365922198590877748698_REALK,  0.0000214964970335301228414_REALK,  &
    0.0000139841733734718191146_REALK,  0.0000098314033659261854635_REALK,  &
    0.0000073346247680623154728_REALK,  0.0000057282745806461831965_REALK,  &
    0.0000046362743466046551965_REALK,  0.0000038596343127936142024_REALK,  &
    0.0000032862650863382549514_REALK,  0.0000028495769029256639310_REALK,  &
    0.0000025081649660082684667_REALK,  0.0000022352512350071614925_REALK,  &
    0.0000020129154186825696982_REALK,  0.0000018288015591729524895_REALK,  &
    0.0000016741638295891399728_REALK,  0.0000015426665847562674167_REALK,  &
    0.0000014296247284506136509_REALK,  0.0000013315095145172219024_REALK,  &
    0.0000012456190440285450426_REALK,  0.0000011698536506506329154_REALK,  &
    0.0000011025596813262099657_REALK,  0.0000010424188444197216884_REALK,  &
    0.0000009883685175960083501_REALK,  0.0000009395434715119923462_REALK,  &
    0.0000008952326536804431579_REALK,                                      &
    0.2768091350125065908116540_REALK,  0.0135011598786173719899395_REALK,  &
    0.0019740547382927665920338_REALK,  0.0004797520092982157993711_REALK,  &
    0.0001620930031335171084359_REALK,  0.0000694380257244509117029_REALK,  &
    0.0000355346722984658492067_REALK,  0.0000208094262941290794177_REALK,  &
    0.0000135016533444646992122_REALK,  0.0000094717368783165807161_REALK,  &
    0.0000070539268213465882172_REALK,  0.0000055012176779447919978_REALK,  &
    0.0000044473417435277990225_REALK,  0.0000036988313530627060337_REALK,  &
    0.0000031468753991357456173_REALK,  0.0000027269212548549716694_REALK,  &
    0.0000023988808804924095944_REALK,  0.0000021368569856506851579_REALK,  &
    0.0000019235362754812026647_REALK,  0.0000017469922606046227528_REALK,  &
    0.0000015987901128375607572_REALK,  0.0000014728240866307445942_REALK,  &
    0.0000013645821890103252327_REALK,  0.0000012706681782953552440_REALK,  &
    0.0000011884830989986188373_REALK,  0.0000011160083414889259091_REALK,  &
    0.0000010516548568548575827_REALK,  0.0000009941564177023299967_REALK,  &
    0.0000009424927864984704843_REALK,  0.0000008958335600000788190_REALK,  &
    0.0000008534965458339115863_REALK,                                      &
    0.2761365346341966842125260_REALK,  0.0134030534727675228884314_REALK,  &
    0.0019502683166561574686776_REALK,  0.0004717334217521878115924_REALK,  &
    0.0001586650901494949107533_REALK,  0.0000676870250562978205194_REALK,  &
    0.0000345108825453182996258_REALK,  0.0000201460377623018980857_REALK,  &
    0.0000130367704489713348294_REALK,  0.0000091258253614948560558_REALK,  &
    0.0000067843488680914052530_REALK,  0.0000052834092739902994282_REALK,  &
    0.0000042662775784494067827_REALK,  0.0000035448468094910925507_REALK,  &
    0.0000030134839160456535139_REALK,  0.0000026096086592041439786_REALK,  &
    0.0000022944064684276476271_REALK,  0.0000020428309840967530847_REALK,  &
    0.0000018381548183334157123_REALK,  0.0000016688656841076410015_REALK,  &
    0.0000015268284706057728470_REALK,  0.0000014061588402484387477_REALK,  &
    0.0000013025114050953344012_REALK,  0.0000012126173807558955774_REALK,  &
    0.0000011339767820295204948_REALK,  0.0000010646488899868216938_REALK,  &
    0.0000010031067089130404877_REALK,  0.0000009481339993530519696_REALK,  &
    0.0000008987512028494764160_REALK,  0.0000008541613289660326258_REALK,  &
    0.0000008137098652076310011_REALK,                                      &
    0.2754688100093179992100545_REALK,  0.0133061264357265830043930_REALK,  &
    0.0019268785757199061343947_REALK,  0.0004638840622619246935321_REALK,  &
    0.0001553234611621151582250_REALK,  0.0000659863942358138362045_REALK,  &
    0.0000335196882519933834197_REALK,  0.0000195054665458079685687_REALK,  &
    0.0000125888506477985454853_REALK,  0.0000087931242142457078395_REALK,  &
    0.0000065254381784048144362_REALK,  0.0000050744643463194046042_REALK,  &
    0.0000040927483182443088105_REALK,  0.0000033973873516144332888_REALK,  &
    0.0000028858294065652180082_REALK,  0.0000024974040102754897869_REALK,  &
    0.0000021945282386884366805_REALK,  0.0000019529778791801445229_REALK,  &
    0.0000017565911108027307797_REALK,  0.0000015942551363290587686_REALK,  &
    0.0000014581236975431862947_REALK,  0.0000013425256918638272594_REALK,  &
    0.0000012432760856258586546_REALK,  0.0000011572286992982908438_REALK,  &
    0.0000010819786999676323305_REALK,  0.0000010156602183925368527_REALK,  &
    0.0000009568058628178496717_REALK,  0.0000009042473889689180388_REALK,  &
    0.0000008570442809469353131_REALK,  0.0000008144316056176590388_REALK,  &
    0.0000007757813987320091731_REALK,                                      &
    0.2748059026617777345080640_REALK,  0.0132103591432100632430124_REALK,  &
    0.0019038771608952786539709_REALK,  0.0004561996789167301947533_REALK,  &
    0.0001520656379523417254737_REALK,  0.0000643345316616669054329_REALK,  &
    0.0000325599694841313661475_REALK,  0.0000188868807829473143642_REALK,  &
    0.0000121572465738368241928_REALK,  0.0000084731109974433821538_REALK,  &
    0.0000062767608626452386713_REALK,  0.0000048740141878435755190_REALK,  &
    0.0000039264347746152825568_REALK,  0.0000032561724210085982986_REALK,  &
    0.0000027636621326359969819_REALK,  0.0000023900826364442576685_REALK,  &
    0.0000020990422462196105256_REALK,  0.0000018671111113866955823_REALK,  &
    0.0000016786733601024719765_REALK,  0.0000015230015055474919471_REALK,  &
    0.0000013925276782667501937_REALK,  0.0000012817861442564014062_REALK,  &
    0.0000011867462112798760199_REALK,  0.0000011043796393841799533_REALK,  &
    0.0000010323730789736806990_REALK,  0.0000009689325894859293581_REALK,  &
    0.0000009126480315085637836_REALK,  0.0000008623972433437547139_REALK,  &
    0.0000008172771815145923295_REALK,  0.0000007765536700926509790_REALK,  &
    0.0000007396242080318842454_REALK,                                      &
    0.2741477550863419820892375_REALK,  0.0131157323833992218303779_REALK,  &
    0.0018812559271243758322184_REALK,  0.0004486761417379745049694_REALK,  &
    0.0001488892209984502023636_REALK,  0.0000627298907027674712339_REALK,  &
    0.0000316306471020206023776_REALK,  0.0000182894803362706335939_REALK,  &
    0.0000117413364471697677436_REALK,  0.0000081652845121375371065_REALK,  &
    0.0000060379010733206436965_REALK,  0.0000046817057053359699501_REALK,  &
    0.0000037670314796419167672_REALK,  0.0000031209336695137048392_REALK,  &
    0.0000026467433386917733768_REALK,  0.0000022874298336770630995_REALK,  &
    0.0000020077536624773796277_REALK,  0.0000017850525150020079751_REALK,  &
    0.0000016042375467396792132_REALK,  0.0000014549529153663523654_REALK,  &
    0.0000013298990622524384260_REALK,  0.0000012238080504372464726_REALK,  &
    0.0000011327977450043145260_REALK,  0.0000010539533601427163664_REALK,  &
    0.0000009850495037557971160_REALK,  0.0000009243613581733558834_REALK,  &
    0.0000008705337784033148375_REALK,  0.0000008224888496250845422_REALK,  &
    0.0000007793594943142740284_REALK,  0.0000007404410467799662160_REALK,  &
    0.0000007051554287945797250_REALK,                                      &
    0.2734943107282718499639884_REALK,  0.0130222273466153379284371_REALK,  &
    0.0018590069328807750856369_REALK,  0.0004413094388121013736219_REALK,  &
    0.0001457918867778553438132_REALK,  0.0000611709776976643228742_REALK,  &
    0.0000307306812059314447285_REALK,  0.0000177124955393981735091_REALK,  &
    0.0000113405230352964529663_REALK,  0.0000078691639166806002381_REALK,  &
    0.0000058084602412944892557_REALK,  0.0000044972007484493684186_REALK,  &
    0.0000036142460887899204321_REALK,  0.0000029914144223810046019_REALK,  &
    0.0000025348447645018920374_REALK,  0.0000021892404200384775531_REALK,  &
    0.0000019204763653069467388_REALK,  0.0000017066319383515090567_REALK,  &
    0.0000015331270710741039815_REALK,  0.0000013899643942854725940_REALK,  &
    0.0000012701029536850473617_REALK,  0.0000011684653214923692417_REALK,  &
    0.0000010813123559249885183_REALK,  0.0000010058384127084473150_REALK,  &
    0.0000009399026689309348784_REALK,  0.0000008818467346604424777_REALK,  &
    0.0000008303682913302443666_REALK,  0.0000007844319090836157906_REALK,  &
    0.0000007432050309453230407_REALK,  0.0000007060113054350364685_REALK,  &
    0.0000006722960795676322167_REALK,                                      &
    0.2728455139634685666649716_REALK,  0.0129298256152891363063295_REALK,  &
    0.0018371224343601733237918_REALK,  0.0004340956725560717716604_REALK,  &
    0.0001427713851670497089211_REALK,  0.0000596563500301276847682_REALK,  &
    0.0000298590696428270818393_REALK,  0.0000171551859947392949096_REALK,  &
    0.0000109542326565562320965_REALK,  0.0000075842878812181473434_REALK,  &
    0.0000055880563448053021197_REALK,  0.0000043201754679221721788_REALK,  &
    0.0000034677988101638244185_REALK,  0.0000028673691652295278445_REALK,  &
    0.0000024277481797840785232_REALK,  0.0000020953183102362809080_REALK,  &
    0.0000018370325473730641810_REALK,  0.0000016316868813060585571_REALK,  &
    0.0000014651924160170636728_REALK,  0.0000013278975604207660142_REALK,  &
    0.0000012130106155761445463_REALK,  0.0000011156376479084793020_REALK,  &
    0.0000010321771560337203572_REALK,  0.0000009599284906997459039_REALK,  &
    0.0000008968321419495267416_REALK,  0.0000008412935586623027119_REALK,  &
    0.0000007920611670153754063_REALK,  0.0000007481403309981934481_REALK,  &
    0.0000007087316273529833453_REALK,  0.0000006731858716287405516_REALK,  &
    0.0000006409708795423216462_REALK,                                      &
    0.2722013100791125239652501_REALK,  0.0128385091542160822974949_REALK,  &
    0.0018155948798545633576101_REALK,  0.0004270310561104393451762_REALK,  &
    0.0001398255369359232105127_REALK,  0.0000581846142779153421669_REALK,  &
    0.0000290148465719606387704_REALK,  0.0000166168394199993047324_REALK,  &
    0.0000105819142249286007325_REALK,  0.0000073102137779378833853_REALK,  &
    0.0000053763232098734276620_REALK,  0.0000041503197016904844142_REALK,  &
    0.0000033274218588385926771_REALK,  0.0000027485630537482019372_REALK,  &
    0.0000023252449396083876126_REALK,  0.0000020054761092990794484_REALK,  &
    0.0000017572523423004074488_REALK,  0.0000015600621492646216903_REALK,  &
    0.0000014002908251301466412_REALK,  0.0000012686203206751045651_REALK,  &
    0.0000011584991874917819490_REALK,  0.0000010652102337575436439_REALK,  &
    0.0000009852844490599573705_REALK,  0.0000009161221922733548278_REALK,  &
    0.0000008557421370445460794_REALK,  0.0000008026110841358602994_REALK,  &
    0.0000007555262056332695594_REALK,  0.0000007135320361820938572_REALK,  &
    0.0000006758609555901967701_REALK,  0.0000006418898460913979881_REALK,  &
    0.0000006111080749004433764_REALK,                                      &
    0.2715616452547832126995786_REALK,  0.0127482603010885212763137_REALK,  &
    0.0017944169043036530767493_REALK,  0.0004201119098554231844934_REALK,  &
    0.0001369522313328737004017_REALK,  0.0000567544244318362063194_REALK,  &
    0.0000281970810869693038348_REALK,  0.0000160967705414483111992_REALK,  &
    0.0000102230383344588137459_REALK,  0.0000070465169055421561625_REALK,  &
    0.0000051729098407299934999_REALK,  0.0000039873363876797107919_REALK,  &
    0.0000031928589351587371166_REALK,  0.0000026347714451275625549_REALK,  &
    0.0000022271355596568903100_REALK,  0.0000019195347245210495322_REALK,  &
    0.0000016809734677183278529_REALK,  0.0000014916095228616307797_REALK,  &
    0.0000013382859954180951239_REALK,  0.0000012120065836956523349_REALK,  &
    0.0000011064514162618982060_REALK,  0.0000010170735431448706147_REALK,  &
    0.0000009405314909613722543_REALK,  0.0000008743227932164341005_REALK,  &
    0.0000008165412996910872253_REALK,  0.0000007657127740428116885_REALK,  &
    0.0000007206812149498032183_REALK,  0.0000006805287696989457017_REALK,  &
    0.0000006445183443986069073_REALK,  0.0000006120518325337198074_REALK,  &
    0.0000005826392733210068436_REALK,                                      &
    0.2709264665440451747002726_REALK,  0.0126590617572958849534892_REALK,  &
    0.0017735813240174970635554_REALK,  0.0004133346580455268251195_REALK,  &
    0.0001341494237572651913697_REALK,  0.0000553644801823445977950_REALK,  &
    0.0000274048758921765548920_REALK,  0.0000155943200320132227771_REALK,  &
    0.0000098770963816348632144_REALK,  0.0000067927897464757253267_REALK,  &
    0.0000049774797789638501280_REALK,  0.0000038309410021041692828_REALK,  &
    0.0000030638647259431528181_REALK,  0.0000025257794502507846637_REALK,  &
    0.0000021332293104466645968_REALK,  0.0000018373229948477253425_REALK,  &
    0.0000016080408844423942660_REALK,  0.0000014261874426816147973_REALK,  &
    0.0000012790477841422810642_REALK,  0.0000011579359859837484574_REALK,  &
    0.0000010567553990726198207_REALK,  0.0000009711230583535110057_REALK,  &
    0.0000008978202614947915656_REALK,  0.0000008344380305632469464_REALK,  &
    0.0000007791425010869255854_REALK,  0.0000007305161046751227483_REALK,  &
    0.0000006874478236083463906_REALK,  0.0000006490559223378597840_REALK,  &
    0.0000006146326081948784876_REALK,  0.0000005836037735465103557_REALK,  &
    0.0000005554992862631849640_REALK,                                      &
    0.2702957218564878694166964_REALK,  0.0125708965789847106758748_REALK,  &
    0.0017530811315645369093813_REALK,  0.0004066958255584231045864_REALK,  &
    0.0001314151335159242971543_REALK,  0.0000540135252710106670356_REALK,  &
    0.0000266373660309082902994_REALK,  0.0000151088534923357559685_REALK,  &
    0.0000095435997241138164970_REALK,  0.0000065486412555044552504_REALK,  &
    0.0000047897104901393273944_REALK,  0.0000036808610221551794484_REALK,  &
    0.0000029402044275804597099_REALK,  0.0000024213815057173292810_REALK,  &
    0.0000020433438296641242802_REALK,  0.0000017586773369149111438_REALK,  &
    0.0000015383064710592207571_REALK,  0.0000013636607082960373239_REALK,  &
    0.0000012224519290126904071_REALK,  0.0000011062936305525732467_REALK,  &
    0.0000010093043383702936660_REALK,  0.0000009272590491438616614_REALK,  &
    0.0000008570572463533360238_REALK,  0.0000007963798962470350760_REALK,  &
    0.0000007434626421870393437_REALK,  0.0000006969423790965786369_REALK,  &
    0.0000006557513031319055762_REALK,  0.0000006190423604373023064_REALK,  &
    0.0000005861358840680491756_REALK,  0.0000005564807941995037735_REALK,  &
    0.0000005296259786596234999_REALK,                                      &
    0.2696693599402059660086195_REALK,  0.0124837481683701279761012_REALK,  &
    0.0017329094908194080451591_REALK,  0.0004001920347539754743704_REALK,  &
    0.0001287474416604933262747_REALK,  0.0000527003459043179521754_REALK,  &
    0.0000258937176637187703063_REALK,  0.0000146397604730172304266_REALK,  &
    0.0000092220788742632633413_REALK,  0.0000063136961783010944930_REALK,  &
    0.0000046092927766920700837_REALK,  0.0000035368354120074783328_REALK,  &
    0.0000028216532900462922440_REALK,  0.0000023213809648141480593_REALK,  &
    0.0000019573047517967512312_REALK,  0.0000016834414069876936836_REALK,  &
    0.0000014716287132151312210_REALK,  0.0000013039001909688468435_REALK,  &
    0.0000011683797811452870454_REALK,  0.0000010569698375557134999_REALK,  &
    0.0000009639963080324535949_REALK,  0.0000008853863526925226673_REALK,  &
    0.0000008181532293799381282_REALK,  0.0000007600644403206146798_REALK,  &
    0.0000007094224668470869532_REALK,  0.0000006649165492748116633_REALK,  &
    0.0000006255203982334667053_REALK,  0.0000005904202636667594710_REALK,  &
    0.0000005589634764120438690_REALK,  0.0000005306210529774899713_REALK,  &
    0.0000005049601256713064532_REALK,                                      &
    0.2690473303647082370382293_REALK,  0.0123976002652911639762001_REALK,  &
    0.0017130597321651421655053_REALK,  0.0003938200024394378868584_REALK,  &
    0.0001261444889025877837390_REALK,  0.0000514237692273447161108_REALK,  &
    0.0000251731268945107083035_REALK,  0.0000141864535363469934485_REALK,  &
    0.0000089120827260504806186_REALK,  0.0000060875943987533961724_REALK,  &
    0.0000044359302159633604056_REALK,  0.0000033986141311208068768_REALK,  &
    0.0000027079961809156255320_REALK,  0.0000022255897065890064404_REALK,  &
    0.0000018749453542854086238_REALK,  0.0000016114657780814565122_REALK,  &
    0.0000014078724069408242297_REALK,  0.0000012467825594072521868_REALK,  &
    0.0000011167180502002189784_REALK,  0.0000010098599063363482017_REALK,  &
    0.0000009207340302860779871_REALK,  0.0000008454141636783259125_REALK,  &
    0.0000007810230943897938043_REALK,  0.0000007254115833009800887_REALK,  &
    0.0000006769463836514462025_REALK,  0.0000006343670464982398277_REALK,  &
    0.0000005966871650461057679_REALK,  0.0000005631249703932804732_REALK,  &
    0.0000005330537088350666244_REALK,  0.0000005059655997091659939_REALK,  &
    0.0000004814452761719565584_REALK,                                      &
    0.2684295835042422861960176_REALK,  0.0123124369390021307785199_REALK,  &
    0.0016935253478445237793754_REALK,  0.0003875765369370109568112_REALK,  &
    0.0001236044736038209058970_REALK,  0.0000501826618549819955094_REALK,  &
    0.0000244748186426156577806_REALK,  0.0000137483673558817890434_REALK,  &
    0.0000086131778138736838382_REALK,  0.0000058699903137647771868_REALK,  &
    0.0000042693386222821175151_REALK,  0.0000032659576638597947658_REALK,  &
    0.0000025990271684860074912_REALK,  0.0000021338277622187923406_REALK,  &
    0.0000017961062194553596747_REALK,  0.0000015426076315791271230_REALK,  &
    0.0000013469083753748857347_REALK,  0.0000011921900179628567542_REALK,  &
    0.0000010673585611431170869_REALK,  0.0000009648638883722304756_REALK,  &
    0.0000008794246628778098826_REALK,  0.0000008072558340463202804_REALK,  &
    0.0000007455856361564692132_REALK,  0.0000006923449372137961780_REALK,  &
    0.0000006459622960214522336_REALK,  0.0000006052256196913347558_REALK,  &
    0.0000005691868169026178111_REALK,  0.0000005370948302778978498_REALK,  &
    0.0000005083477830047786163_REALK,  0.0000004824582401601547283_REALK,  &
    0.0000004590276226453459368_REALK,                                      &
    0.2678160705215242853860502_REALK,  0.0122282425801928367609106_REALK,  &
    0.0016742999874555892711459_REALK,  0.0003814585352500841019217_REALK,  &
    0.0001211256498378759097678_REALK,  0.0000489759284584373073292_REALK,  &
    0.0000237980455589819357828_REALK,  0.0000133249578523132110823_REALK,  &
    0.0000083249476019905142897_REALK,  0.0000056605522343713644549_REALK,  &
    0.0000041092455320525134735_REALK,  0.0000031386365694975855815_REALK,  &
    0.0000024945491231661391617_REALK,  0.0000020459229579017266310_REALK,  &
    0.0000017206349115178312594_REALK,  0.0000014767304626900209354_REALK,  &
    0.0000012886131982778431680_REALK,  0.0000011400100567151943271_REALK,  &
    0.0000010201980220970924368_REALK,  0.0000009218863706158242062_REALK,  &
    0.0000008399795960233416854_REALK,  0.0000007708286820023369220_REALK,  &
    0.0000007117633801367366818_REALK,  0.0000006607916349336719516_REALK,  &
    0.0000006164014402181150831_REALK,  0.0000005774271812594563506_REALK,  &
    0.0000005429575773116892628_REALK,  0.0000005122710637631790267_REALK,  &
    0.0000004847896441036137496_REALK,  0.0000004600454069771502359_REALK,  &
    0.0000004376558771938853540_REALK,                                      &
    0.2672067433518622858734659_REALK,  0.0121450018932305441043962_REALK,  &
    0.0016553774535864268589030_REALK,  0.0003754629803246314402078_REALK,  &
    0.0001187063255219169828451_REALK,  0.0000478025104048639704079_REALK,  &
    0.0000231420869846935430664_REALK,  0.0000129157013641259302262_REALK,  &
    0.0000080469918032565072093_REALK,  0.0000054589618120506844620_REALK,  &
    0.0000039553897108507806552_REALK,  0.0000030164310517100398930_REALK,  &
    0.0000023943733363220564821_REALK,  0.0000019617105735366291694_REALK,  &
    0.0000016483856679655978241_REALK,  0.0000014137037991253160130_REALK,  &
    0.0000012328689537563136158_REALK,  0.0000010901352128960242628_REALK,  &
    0.0000009751378027779827184_REALK,  0.0000008808362687518023627_REALK,  &
    0.0000008023142586851977502_REALK,  0.0000007360538098112500171_REALK,  &
    0.0000006794824105289996580_REALK,  0.0000006306821674345172670_REALK,  &
    0.0000005881982308716529900_REALK,  0.0000005509096601120793850_REALK,  &
    0.0000005179405397940930050_REALK,  0.0000004885976281291447239_REALK,  &
    0.0000004623258525844375657_REALK,  0.0000004386760366848485065_REALK,  &
    0.0000004172811533709293747_REALK,                                      &
    0.2666015546876613906412956_REALK,  0.0120626998886167648844525_REALK,  &
    0.0016367516975845884923818_REALK,  0.0003695869384023553689059_REALK,  &
    0.0001163448606147329843826_REALK,  0.0000466613844480410892325_REALK,  &
    0.0000225062479501159963535_REALK,  0.0000125200938516117428912_REALK,  &
    0.0000077789257259406099763_REALK,  0.0000052649134891448810651_REALK,  &
    0.0000038075206815775671227_REALK,  0.0000028991305467077163191_REALK,  &
    0.0000022983191558094566678_REALK,  0.0000018810330164863366571_REALK,  &
    0.0000015792191047168542613_REALK,  0.0000013534029323936770686_REALK,  &
    0.0000011795629716432359066_REALK,  0.0000010424628431374649457_REALK,  &
    0.0000009320837230281961102_REALK,  0.0000008416266299165070665_REALK,  &
    0.0000007663479337491051351_REALK,  0.0000007028559299920723951_REALK,  &
    0.0000006486722062792063118_REALK,  0.0000006019502285826051365_REALK,  &
    0.0000005612901136875065257_REALK,  0.0000005256138615293979043_REALK,  &
    0.0000004940795342583913626_REALK,  0.0000004660210898102353674_REALK,  &
    0.0000004409054619309744892_REALK,  0.0000004183014524514176395_REALK,  &
    0.0000003978568535631348299_REALK,                                      &
    0.2660004579633017396389505_REALK,  0.0119813218756523367364286_REALK,  &
    0.0016184168154566285630080_REALK,  0.0003638275564623103105685_REALK,  &
    0.0001140396653791133355820_REALK,  0.0000455515614681155359329_REALK,  &
    0.0000218898582130367487172_REALK,  0.0000121376501328658919311_REALK,  &
    0.0000075203796474384373784_REALK,  0.0000050781139723693029738_REALK,  &
    0.0000036653982727550326400_REALK,  0.0000027865333291892123478_REALK,  &
    0.0000022062136374548045655_REALK,  0.0000018037395097529445764_REALK,  &
    0.0000015130019343907381878_REALK,  0.0000012957086611475960337_REALK,  &
    0.0000011285875980054182498_REALK,  0.0000009968949060506181435_REALK,  &
    0.0000008909458509872550178_REALK,  0.0000008041744444447511737_REALK,  &
    0.0000007320035816887490751_REALK,  0.0000006711631995217853649_REALK,  &
    0.0000006192654846658460243_REALK,  0.0000005745325671219930116_REALK,  &
    0.0000005356174249945323007_REALK,  0.0000005014833335530400750_REALK,  &
    0.0000004713209996103502220_REALK,  0.0000004444905026798917471_REALK,  &
    0.0000004204799021414039771_REALK,  0.0000003988752523515610422_REALK,  &
    0.0000003793385616615963935_REALK,                                      &
    0.2654034073403773730248645_REALK,  0.0119008534553043665571437_REALK,  &
    0.0016003670438934111501517_REALK,  0.0003581820597478487791174_REALK,  &
    0.0001117891987060498745939_REALK,  0.0000444720852584941432574_REALK,  &
    0.0000212922713342334717480_REALK,  0.0000117679031504487040678_REALK,  &
    0.0000072709982137534202507_REALK,  0.0000048982817284205840125_REALK,  &
    0.0000035287921860969528974_REALK,  0.0000026784461353366314483_REALK,  &
    0.0000021178912117808721235_REALK,  0.0000017296857939234477711_REALK,  &
    0.0000014496066971257190695_REALK,  0.0000012405070460366360412_REALK,  &
    0.0000010798399702738374506_REALK,  0.0000009533377546640043649_REALK,  &
    0.0000008516383104578995315_REALK,  0.0000007684004662292879226_REALK,  &
    0.0000006992076723279351563_REALK,  0.0000006409070616778497289_REALK,  &
    0.0000005911980521129276776_REALK,  0.0000005483688455180561224_REALK,  &
    0.0000005111232578170052549_REALK,  0.0000004784642395966118210_REALK,  &
    0.0000004496138623048305290_REALK,  0.0000004239572920236212239_REALK,  &
    0.0000004010028686668248664_REALK,  0.0000003803532028690332081_REALK,  &
    0.0000003616839407732661635_REALK,                                      &
    0.2648103576932872016413967_REALK,  0.0118212805132688180548284_REALK,  &
    0.0015825967564169986147998_REALK,  0.0003526477493758621854954_REALK,  &
    0.0001095919664984532792716_REALK,  0.0000434220313580535154790_REALK,  &
    0.0000207128637889690877117_REALK,  0.0000114104032674516576014_REALK,  &
    0.0000070304398636649072384_REALK,  0.0000047251465007420724281_REALK,  &
    0.0000033974815825186763646_REALK,  0.0000025746838021076638149_REALK,  &
    0.0000020331933653033502793_REALK,  0.0000016587338422724486154_REALK,  &
    0.0000013889115033783446964_REALK,  0.0000011876891755487228602_REALK,  &
    0.0000010332218025147036025_REALK,  0.0000009117019382725098024_REALK,  &
    0.0000008140790970471916478_REALK,  0.0000007342290412975482678_REALK,  &
    0.0000006678900243269389563_REALK,  0.0000006120220951662260071_REALK,  &
    0.0000005644086618958319145_REALK,  0.0000005234015053406987751_REALK,  &
    0.0000004877533341665939445_REALK,  0.0000004565052369858267929_REALK,  &
    0.0000004289094205623145822_REALK,  0.0000004043751439340043667_REALK,  &
    0.0000003824302165486361108_REALK,  0.0000003626931373924583939_REALK,  &
    0.0000003448526357354492179_REALK,                                      &
    0.2642212645951680927147720_REALK,  0.0117425892132228485570389_REALK,  &
    0.0015651004596450878748881_REALK,  0.0003472220000253943496434_REALK,  &
    0.0001074465201121641266249_REALK,  0.0000424005059269070788230_REALK,  &
    0.0000201510341129737888125_REALK,  0.0000110647175917596285585_REALK,  &
    0.0000067983762765478548918_REALK,  0.0000045584488465442658922_REALK,  &
    0.0000032712546857899278601_REALK,  0.0000024750689221120425016_REALK,  &
    0.0000019519683357559651762_REALK,  0.0000015907515884369654678_REALK,  &
    0.0000013307997881657905037_REALK,  0.0000011371509423440207548_REALK,  &
    0.0000009886391803820815084_REALK,  0.0000008719020132684857955_REALK,  &
    0.0000007781899026813201864_REALK,  0.0000007015879442284980207_REALK,  &
    0.0000006379836520374977900_REALK,  0.0000005844458701986511657_REALK,  &
    0.0000005388388784210811804_REALK,  0.0000004995756388836050604_REALK,  &
    0.0000004654558832649646459_REALK,  0.0000004355573611518181353_REALK,  &
    0.0000004091612339855435517_REALK,  0.0000003856998998740574510_REALK,  &
    0.0000003647198595113583605_REALK,  0.0000003458548594701947524_REALK,  &
    0.0000003288061802077366873_REALK,                                      &
    0.2636360843041608004178045_REALK,  0.0116647659902610143639601_REALK,  &
    0.0015478727896690823440107_REALK,  0.0003419022577028151899450_REALK,  &
    0.0001053514548521202576865_REALK,  0.0000414066446640395542374_REALK,  &
    0.0000196062020815330444320_REALK,  0.0000107304293273513890518_REALK,  &
    0.0000065744918428532122206_REALK,  0.0000043979396932175406703_REALK,  &
    0.0000031499084030683612737_REALK,  0.0000023794315133914765011_REALK,  &
    0.0000018740708206290102753_REALK,  0.0000015256126661034198080_REALK,  &
    0.0000012751600762391105212_REALK,  0.0000010887928296082357140_REALK,  &
    0.0000009460023653127008771_REALK,  0.0000008338563625456075532_REALK,  &
    0.0000007438959481109866240_REALK,  0.0000006704082220494837060_REALK,  &
    0.0000006094246193868070057_REALK,  0.0000005581188111978222674_REALK,  &
    0.0000005144329477751323217_REALK,  0.0000004768388667297675780_REALK,  &
    0.0000004441815254208279091_REALK,  0.0000004155739152138317955_REALK,  &
    0.0000003903250183237581827_REALK,  0.0000003678894561668572645_REALK,  &
    0.0000003478316737782787460_REALK,  0.0000003298000506005906944_REALK,  &
    0.0000003135079081259628397_REALK,                                      &
    0.2630547737499989158216351_REALK,  0.0115877975445098681250844_REALK,  &
    0.0015309085085420557834079_REALK,  0.0003366860375808523246459_REALK,  &
    0.0001033054085216314547631_REALK,  0.0000404396117651872723047_REALK,  &
    0.0000190778079203580768711_REALK,  0.0000104071371515296594865_REALK,  &
    0.0000063584831563001398494_REALK,  0.0000042433799133114813109_REALK,  &
    0.0000030332479615853068026_REALK,  0.0000022876087034519622106_REALK,  &
    0.0000017993616984345055139_REALK,  0.0000014631961601731723588_REALK,  &
    0.0000012218857576979720946_REALK,  0.0000010425197069739916316_REALK,  &
    0.0000009052256075445803114_REALK,  0.0000007974870230854309260_REALK,  &
    0.0000007111258230422371170_REALK,  0.0000006406240452700888802_REALK,  &
    0.0000005821519004670339743_REALK,  0.0000005329840658245241328_REALK,  &
    0.0000004911376742521090027_REALK,  0.0000004551412209873679528_REALK,  &
    0.0000004238831612984360047_REALK,  0.0000003965103647000867518_REALK,  &
    0.0000003723585451441642100_REALK,  0.0000003509036681810174690_REALK,  &
    0.0000003317274063887497749_REALK,  0.0000003144921823447871234_REALK,  &
    0.0000002989228693132519056_REALK,                                      &
    0.2624772905209142304094883_REALK,  0.0115116708349154214102716_REALK,  &
    0.0015142025008729684005387_REALK,  0.0003315709219088706937763_REALK,  &
    0.0001013070600227852557712_REALK,  0.0000394985989194068535450_REALK,  &
    0.0000185653115469686119275_REALK,  0.0000100944546170175933960_REALK,  &
    0.0000061500585268716158566_REALK,  0.0000040945399172906426195_REALK,  &
    0.0000029210865607864533911_REALK,  0.0000021994444269265164756_REALK,  &
    0.0000017277077621367983473_REALK,  0.0000014033863688960099563_REALK,  &
    0.0000011708748735790030263_REALK,  0.0000009982406355789564934_REALK,  &
    0.0000008662269675595068235_REALK,  0.0000007627195213540595596_REALK,  &
    0.0000006798113335439247105_REALK,  0.0000006121725657251834946_REALK,  &
    0.0000005561072465215441097_REALK,  0.0000005089873800347502469_REALK,  &
    0.0000004689023025834779667_REALK,  0.0000004344350339327010118_REALK,  &
    0.0000004045158663265771106_REALK,  0.0000003783242371671734197_REALK,  &
    0.0000003552215461813470246_REALK,  0.0000003347042589921267663_REALK,  &
    0.0000003163705878059669158_REALK,  0.0000002998964325591646771_REALK,  &
    0.0000002850177490526275675_REALK,                                      &
    0.2619035928508466337660820_REALK,  0.0114363730731983741228941_REALK,  &
    0.0014977497705236373411880_REALK,  0.0003265545579918935803661_REALK,  &
    0.0000993551280060886660497_REALK,  0.0000385828243428372748389_REALK,  &
    0.0000180681918413705553327_REALK,  0.0000097920095779036239861_REALK,  &
    0.0000059489375137436745352_REALK,  0.0000039511992633108381596_REALK,  &
    0.0000028132450392612110101_REALK,  0.0000021147891362734133834_REALK,  &
    0.0000016589814642124068655_REALK,  0.0000013460725764841059675_REALK,  &
    0.0000011220299109714600626_REALK,  0.0000009558686818492691427_REALK,  &
    0.0000008289281455678273226_REALK,  0.0000007294827161534458916_REALK,  &
    0.0000006498873563994152055_REALK,  0.0000005849937809150280934_REALK,  &
    0.0000005312350590332716735_REALK,  0.0000004860769788882046961_REALK,  &
    0.0000004476784056056117030_REALK,  0.0000004146748318090994716_REALK,  &
    0.0000003860367900088850947_REALK,  0.0000003609750264895802820_REALK,  &
    0.0000003388756221460332200_REALK,  0.0000003192547323107266943_REALK,  &
    0.0000003017264486142278163_REALK,  0.0000002859796055539992194_REALK,  &
    0.0000002717607914350163788_REALK,                                      &
    0.2613336396069535494390834_REALK,  0.0113618917179719534221727_REALK,  &
    0.0014815454374050968620879_REALK,  0.0003216346562359501874521_REALK,  &
    0.0000974483695675226410399_REALK,  0.0000376915318482205565788_REALK,  &
    0.0000175859459448606721414_REALK,  0.0000094994436384590462852_REALK,  &
    0.0000057548504773154346276_REALK,  0.0000038131462832926810498_REALK,  &
    0.0000027095515558230551278_REALK,  0.0000020334995249414505037_REALK,  &
    0.0000015930606728270665823_REALK,  0.0000012911488357411362795_REALK,  &
    0.0000010752576072339040815_REALK,  0.0000009153207396153323790_REALK,  &
    0.0000007932543186715095947_REALK,  0.0000006977086485882147622_REALK,  &
    0.0000006212917000850877941_REALK,  0.0000005590304045442408306_REALK,  &
    0.0000005074822686345529957_REALK,  0.0000004642034528428675200_REALK,  &
    0.0000004274197771135882665_REALK,  0.0000003958172335426449622_REALK,  &
    0.0000003684050599075485525_REALK,  0.0000003444241016017131575_REALK,  &
    0.0000003232841557850630686_REALK,  0.0000003045202894772926028_REALK,  &
    0.0000002877618401139327422_REALK,  0.0000002727100559940558961_REALK,  &
    0.0000002591217263051621162_REALK,                                      &
    0.2607673902774090834988385_REALK,  0.0112882144690175378887176_REALK,  &
    0.0014655847343700712914066_REALK,  0.0003168089882574196035694_REALK,  &
    0.0000955855789912542604591_REALK,  0.0000368239899488019179516_REALK,  &
    0.0000171180885858379731304_REALK,  0.0000092164116238930648381_REALK,  &
    0.0000055675381495425125915_REALK,  0.0000036801777245999526083_REALK,  &
    0.0000026098412841313924138_REALK,  0.0000019554382624586768517_REALK,  &
    0.0000015298284386400767319_REALK,  0.0000012385137602613901570_REALK,  &
    0.0000010304687629044843311_REALK,  0.0000008765173601846901032_REALK,  &
    0.0000007591339853576348849_REALK,  0.0000006673323988241564377_REALK,  &
    0.0000005939649720728051714_REALK,  0.0000005342277429753256707_REALK,  &
    0.0000004847982195702872704_REALK,  0.0000004433196492821569707_REALK,  &
    0.0000004080823296609919707_REALK,  0.0000003778208541463512578_REALK,  &
    0.0000003515816900828786981_REALK,  0.0000003286346194847407813_REALK,  &
    0.0000003084122289938360678_REALK,  0.0000002904677503337451397_REALK,  &
    0.0000002744451586316934924_REALK,  0.0000002600576163654722125_REALK,  &
    0.0000002470716996363158964_REALK,                                      &
    0.2602048049594855028132656_REALK,  0.0112153292617133276687369_REALK,  &
    0.0014498630041984365401236_REALK,  0.0003120753850541351523754_REALK,  &
    0.0000937655865363232074667_REALK,  0.0000359794909952871073814_REALK,  &
    0.0000166641514315478686873_REALK,  0.0000089425810721497728885_REALK,  &
    0.0000053867512218102994707_REALK,  0.0000035520984066606681082_REALK,  &
    0.0000025139561202717722687_REALK,  0.0000018804737409249867304_REALK,  &
    0.0000014691727717684010385_REALK,  0.0000011880703257742467027_REALK,  &
    0.0000009875780629162466736_REALK,  0.0000008393825900139509647_REALK,  &
    0.0000007264988169907262570_REALK,  0.0000006382919493295803173_REALK,  &
    0.0000005678504521675837128_REALK,  0.0000005105335773255600365_REALK,  &
    0.0000004631345594590171723_REALK,  0.0000004233805690332818000_REALK,  &
    0.0000003896239970768738096_REALK,  0.0000003606462125953366970_REALK,  &
    0.0000003355294937816055297_REALK,  0.0000003135714422004854040_REALK,  &
    0.0000002942265437921098633_REALK,  0.0000002770654777902682762_REALK,  &
    0.0000002617462733714343279_REALK,  0.0000002479935278415475835_REALK,  &
    0.0000002355832071725770693_REALK,                                      &
    0.2596458443479093269878888_REALK,  0.0111432242616114618449785_REALK,  &
    0.0014343756966726229056669_REALK,  0.0003074317352360876067462_REALK,  &
    0.0000919872572656797867722_REALK,  0.0000351573503445855862202_REALK,  &
    0.0000162236824647282172108_REALK,  0.0000086776317458881123504_REALK,  &
    0.0000052122499496157841353_REALK,  0.0000034287208918967558620_REALK,  &
    0.0000024217444027366763720_REALK,  0.0000018084798324118562490_REALK,  &
    0.0000014109864284634748528_REALK,  0.0000011397256802280297942_REALK,  &
    0.0000009465039057460424158_REALK,  0.0000008038438156378302605_REALK,  &
    0.0000006952835159870692599_REALK,  0.0000006105280543046911283_REALK,  &
    0.0000005428939716047441140_REALK,  0.0000004878980509485679928_REALK,  &
    0.0000004424451341081633267_REALK,  0.0000004043432676463863256_REALK,  &
    0.0000003720046414815725846_REALK,  0.0000003442556439655322323_REALK,  &
    0.0000003202130001762214030_REALK,  0.0000002992010577837416944_REALK,  &
    0.0000002806953469826934506_REALK,  0.0000002642833059145456615_REALK,  &
    0.0000002496364576406067460_REALK,  0.0000002364903743879996167_REALK,  &
    0.0000002246300311853312592_REALK,                                      &
    0.2590904697234855946774701_REALK,  0.0110718878591591785714998_REALK,  &
    0.0014191183657400333398280_REALK,  0.0003028759833136499901932_REALK,  &
    0.0000902494899160167677677_REALK,  0.0000343569055591193774535_REALK,  &
    0.0000157962453841690448470_REALK,  0.0000084212551638222337682_REALK,  &
    0.0000050438037733579560397_REALK,  0.0000033098651703558931021_REALK,  &
    0.0000023330606442737006063_REALK,  0.0000017393356567944586455_REALK,  &
    0.0000013551667070732935461_REALK,  0.0000010933909622254285226_REALK,  &
    0.0000009071682401422682472_REALK,  0.0000007698316155285759163_REALK,  &
    0.0000006654256803687374728_REALK,  0.0000005839841150175628215_REALK,  &
    0.0000005190437976434838133_REALK,  0.0000004662735620534842108_REALK,  &
    0.0000004226858871507934020_REALK,  0.0000003861667612147509361_REALK,  &
    0.0000003551859645930302823_REALK,  0.0000003286132156379979659_REALK,  &
    0.0000003055983749670293137_REALK,  0.0000002854915048131351126_REALK,  &
    0.0000002677883583210411741_REALK,  0.0000002520924713785412936_REALK,  &
    0.0000002380883232932729434_REALK,  0.0000002255220199555180308_REALK,  &
    0.0000002141871801973610609_REALK,                                      &
    0.2585386429419818665742525_REALK,  0.0110013086645597713691958_REALK,  &
    0.0014040866667596645436800_REALK,  0.0002984061280413244257419_REALK,  &
    0.0000885512158068966175181_REALK,  0.0000335775156355263496976_REALK,  &
    0.0000153814190282378559713_REALK,  0.0000081731541506336990836_REALK,  &
    0.0000048811909545661805011_REALK,  0.0000031953583574648863727_REALK,  &
    0.0000022477652750907479626_REALK,  0.0000016729253595619359362_REALK,  &
    0.0000013016152528818830722_REALK,  0.0000010489811274402975451_REALK,  &
    0.0000008694964090930930442_REALK,  0.0000007372796185744518014_REALK,  &
    0.0000006368656744088401343_REALK,  0.0000005586060607783572086_REALK,  &
    0.0000004962505234060623056_REALK,  0.0000004456146612265554770_REALK,  &
    0.0000004038147642823564584_REALK,  0.0000003688119365266536539_REALK,  &
    0.0000003391314231253533789_REALK,  0.0000003136846473804548102_REALK,  &
    0.0000002916533446672763579_REALK,  0.0000002724123004892136931_REALK,  &
    0.0000002554767020318943999_REALK,  0.0000002404655481059657595_REALK,  &
    0.0000002270757582394896292_REALK,  0.0000002150635486149132568_REALK,  &
    0.0000002042308315353068165_REALK,                                      &
    0.2579903264232660253796325_REALK,  0.0109314755027691071220808_REALK,  &
    0.0013892763538301800517460_REALK,  0.0002940202208150773034896_REALK,  &
    0.0000868913977877315248577_REALK,  0.0000328185602616316333892_REALK,  &
    0.0000149787968204606363793_REALK,  0.0000079330424046996417850_REALK,  &
    0.0000047241982269244777397_REALK,  0.0000030850344043491245066_REALK,  &
    0.0000021657243969303562713_REALK,  0.0000016091378991720651315_REALK,  &
    0.0000012502378714356175669_REALK,  0.0000010064147826615929300_REALK,  &
    0.0000008334170007112754605_REALK,  0.0000007061243688792445402_REALK,  &
    0.0000006095465050923629902_REALK,  0.0000005343422352953791426_REALK,  &
    0.0000004744669627229527623_REALK,  0.0000004258779536301795279_REALK,  &
    0.0000003857916218855999649_REALK,  0.0000003522414653488463934_REALK,  &
    0.0000003238061480899782871_REALK,  0.0000002994372351259358679_REALK,  &
    0.0000002783471244000897103_REALK,  0.0000002599343720562606194_REALK,  &
    0.0000002437328415166216553_REALK,  0.0000002293763849705113907_REALK,  &
    0.0000002165738668771713667_REALK,  0.0000002050912074966832886_REALK,  &
    0.0000001947382765774367879_REALK,                                      &
    0.2574454831406914334657188_REALK,  0.0108623774086238269326321_REALK,  &
    0.0013746832771968267149915_REALK,  0.0002897163641214110579511_REALK,  &
    0.0000852690292212314996821_REALK,  0.0000320794391006072766989_REALK,  &
    0.0000145879862362864626973_REALK,  0.0000077006440829127932411_REALK,  &
    0.0000045726204614768351436_REALK,  0.0000029787338201863034463_REALK,  &
    0.0000020868095475463685254_REALK,  0.0000015478668435351464550_REALK,  &
    0.0000012009443499838552967_REALK,  0.0000009656140271268195451_REALK,  &
    0.0000007988617057271411366_REALK,  0.0000006763051965989993495_REALK,  &
    0.0000005834137041298815412_REALK,  0.0000005111432881685693757_REALK,  &
    0.0000004536480497556685913_REALK,  0.0000004070220056653562071_REALK,  &
    0.0000003685781398421084645_REALK,  0.0000003364197226512942094_REALK,  &
    0.0000003091768678191897405_REALK,  0.0000002858397782773297168_REALK,  &
    0.0000002656503490440358617_REALK,  0.0000002480299914121130794_REALK,  &
    0.0000002325305171024000904_REALK,  0.0000002188000464023753868_REALK,  &
    0.0000002065589133097041164_REALK,  0.0000001955823524034663471_REALK,  &
    0.0000001856878685702014166_REALK,                                      &
    0.2569040766107214546210002_REALK,  0.0107940036220972278291352_REALK,  &
    0.0013603033807346347813100_REALK,  0.0002854927100363779295458_REALK,  &
    0.0000836831330019859623249_REALK,  0.0000313595711012812586468_REALK,  &
    0.0000142086082901980854368_REALK,  0.0000074756934018989767626_REALK,  &
    0.0000044262603454245870357_REALK,  0.0000028763034060856517213_REALK,  &
    0.0000020108974751364662586_REALK,  0.0000014890101752305219390_REALK,  &
    0.0000011536482866774079160_REALK,  0.0000009265043008216804825_REALK,  &
    0.0000007657651812943543748_REALK,  0.0000006477640945444134328_REALK,  &
    0.0000005584152152729916782_REALK,  0.0000004889620712869437936_REALK,  &
    0.0000004337507431791443166_REALK,  0.0000003890072558928120695_REALK,  &
    0.0000003521377383378176263_REALK,  0.0000003213127085912235307_REALK,  &
    0.0000002952118345396228698_REALK,  0.0000002728625103741035052_REALK,  &
    0.0000002535350075715653646_REALK,  0.0000002366727127574562537_REALK,  &
    0.0000002218446866912009986_REALK,  0.0000002087127557669850868_REALK,  &
    0.0000001970082672186867301_REALK,  0.0000001865153959699800738_REALK,  &
    0.0000001770589728928299029_REALK,                                      &
    0.2563660708827887879657226_REALK,  0.0107263435836791529154333_REALK,  &
    0.0013461326995054560470844_REALK,  0.0002813474587728130213958_REALK,  &
    0.0000821327606088970927625_REALK,  0.0000306583938335993014409_REALK,  &
    0.0000138402970423657644284_REALK,  0.0000072579342549667156929_REALK,  &
    0.0000042849280739518938525_REALK,  0.0000027775960000055135350_REALK,  &
    0.0000019378699223035254250_REALK,  0.0000014324701050763008591_REALK,  &
    0.0000011082669271842856035_REALK,  0.0000008890142394375207497_REALK,  &
    0.0000007340649208268825662_REALK,  0.0000006204456002899263025_REALK,  &
    0.0000005345012866919353199_REALK,  0.0000004677535399072522413_REALK,  &
    0.0000004147339347156300117_REALK,  0.0000003717959300179026637_REALK,  &
    0.0000003364354984789876435_REALK,  0.0000003068879740831813087_REALK,  &
    0.0000002818807543316441723_REALK,  0.0000002604770329654217305_REALK,  &
    0.0000002419743804319801811_REALK,  0.0000002258373131429604835_REALK,  &
    0.0000002116514691732393352_REALK,  0.0000001990918413862459644_REALK,  &
    0.0000001879003522674984192_REALK,  0.0000001778697582509128240_REALK,  &
    0.0000001688319196549587072_REALK,                                      &
    0.2558314305293830637211272_REALK,  0.0106593869298762366354394_REALK,  &
    0.0013321673573864743506806_REALK,  0.0002772788572741269005374_REALK,  &
    0.0000806169911902316596759_REALK,  0.0000299753628482815250445_REALK,  &
    0.0000134826991240736904839_REALK,  0.0000070471198441512422113_REALK,  &
    0.0000041484410545391830715_REALK,  0.0000026824702322432472749_REALK,  &
    0.0000018676134191372275899_REALK,  0.0000013781528936897318365_REALK,  &
    0.0000010647210083973155456_REALK,  0.0000008530755356918626680_REALK,  &
    0.0000007037011295980011322_REALK,  0.0000005942966835422477348_REALK,  &
    0.0000005116243681867279772_REALK,  0.0000004474746582014058847_REALK,  &
    0.0000003965583618217146915_REALK,  0.0000003553519597531313261_REALK,  &
    0.0000003214380865434955047_REALK,  0.0000002931145497897970183_REALK,  &
    0.0000002691547203180426808_REALK,  0.0000002486562525409892108_REALK,  &
    0.0000002309429798374240024_REALK,  0.0000002154997357794057133_REALK,  &
    0.0000002019280904758916861_REALK,  0.0000001899156850789146850_REALK,  &
    0.0000001792145969171761135_REALK,  0.0000001696258196229452640_REALK,  &
    0.0000001609879585177346667_REALK,                                      &
    0.2553001206363593178494398_REALK,  0.0105931234888289819290330_REALK,  &
    0.0013184035647678872971850_REALK,  0.0002732851978530526364415_REALK,  &
    0.0000791349306801038027311_REALK,  0.0000293099510597538459632_REALK,  &
    0.0000131354732811794894769_REALK,  0.0000068430123267413626122_REALK,  &
    0.0000040166236232470469434_REALK,  0.0000025907902910511725133_REALK,  &
    0.0000018000190850251344424_REALK,  0.0000013259686806913381110_REALK,  &
    0.0000010229346089225748942_REALK,  0.0000008186228067302018205_REALK,  &
    0.0000006746166058443514079_REALK,  0.0000005692666385319390153_REALK,  &
    0.0000004897390130134218819_REALK,  0.0000004280843090695570945_REALK,  &
    0.0000003791865243389274619_REALK,  0.0000003396409053806507731_REALK,  &
    0.0000003071136817003630653_REALK,  0.0000002799628783754534794_REALK,  &
    0.0000002570061489326909005_REALK,  0.0000002373743203777821353_REALK,  &
    0.0000002204164928169809242_REALK,  0.0000002056370359819757496_REALK,  &
    0.0000001926528321250679590_REALK,  0.0000001811636731021573335_REALK,  &
    0.0000001709313875415830575_REALK,  0.0000001617648758922642315_REALK,  &
    0.0000001535092156339015252_REALK,                                      &
    0.2547721067934642369401388_REALK,  0.0105275432760422553435387_REALK,  &
    0.0013048376163175665239102_REALK,  0.0002693648168738092276396_REALK,  &
    0.0000776857109452485262036_REALK,  0.0000286616481514705090329_REALK,  &
    0.0000127982899348977457050_REALK,  0.0000066453824757033287229_REALK,  &
    0.0000038893067724751971041_REALK,  0.0000025024256979515800039_REALK,  &
    0.0000017349824388194155886_REALK,  0.0000012758313212213893564_REALK,  &
    0.0000009828350060513088830_REALK,  0.0000007855934673401954959_REALK,  &
    0.0000006467566271295465913_REALK,  0.0000005453069812027600051_REALK,  &
    0.0000004688017841171654374_REALK,  0.0000004095432080254647651_REALK,  &
    0.0000003625826049273254017_REALK,  0.0000003246298818454921490_REALK,  &
    0.0000002934319070381856053_REALK,  0.0000002674047498725399091_REALK,  &
    0.0000002454087191268196097_REALK,  0.0000002266065751676356345_REALK,  &
    0.0000002103717269102764089_REALK,  0.0000001962273296261800414_REALK,  &
    0.0000001838049822018584446_REALK,  0.0000001728161493821634930_REALK,  &
    0.0000001630320237342532146_REALK,  0.0000001542690955042204663_REALK,  &
    0.0000001463786526073933752_REALK,                                      &
    0.2542473550850717911586685_REALK,  0.0104626364902259440248233_REALK,  &
    0.0012914658888105543400188_REALK,  0.0002655160934761898795277_REALK,  &
    0.0000762684889609864145269_REALK,  0.0000280299600027785474705_REALK,  &
    0.0000124708307592265452894_REALK,  0.0000064540093534397607679_REALK,  &
    0.0000037663278897217039365_REALK,  0.0000024172510923419757487_REALK,  &
    0.0000016724032170015871180_REALK,  0.0000012276582294516234661_REALK,  &
    0.0000009443525389312039917_REALK,  0.0000007539276087210386827_REALK,  &
    0.0000006200688417328775204_REALK,  0.0000005223713509833172780_REALK,  &
    0.0000004487711645729965086_REALK,  0.0000003918138209691311577_REALK,  &
    0.0000003467123931094944776_REALK,  0.0000003102874882177929771_REALK,  &
    0.0000002803637637504093006_REALK,  0.0000002554132400167812406_REALK,  &
    0.0000002343373143770622388_REALK,  0.0000002163294882966601354_REALK,  &
    0.0000002007865583779442693_REALK,  0.0000001872497439983709277_REALK,  &
    0.0000001753647885826274116_REALK,  0.0000001648543709267643642_REALK,  &
    0.0000001554986757042440710_REALK,  0.0000001471214787564935404_REALK,  &
    0.0000001395800273775407976_REALK,                                      &
    0.2537258320811250911219759_REALK,  0.0103983935092425393287296_REALK,  &
    0.0012782848390213322024855_REALK,  0.0002617374483401455043628_REALK,  &
    0.0000748824460153240447366_REALK,  0.0000274144081365083971426_REALK,  &
    0.0000121527882743639687395_REALK,  0.0000062686799983450891441_REALK,  &
    0.0000036475305068879062387_REALK,  0.0000023351460249993014913_REALK,  &
    0.0000016121851995030854655_REALK,  0.0000011813702287890747474_REALK,  &
    0.0000009074204776654551744_REALK,  0.0000007235678825624997637_REALK,  &
    0.0000005945031648391797069_REALK,  0.0000005004154169354454240_REALK,  &
    0.0000004296074720445648204_REALK,  0.0000003748602856704565791_REALK,  &
    0.0000003315432127604382488_REALK,  0.0000002965837403698683587_REALK,  &
    0.0000002678815683325169290_REALK,  0.0000002439626514148269778_REALK,  &
    0.0000002237679673658242474_REALK,  0.0000002065206116537172302_REALK,  &
    0.0000001916398828120184941_REALK,  0.0000001786843709294106925_REALK,  &
    0.0000001673134143560828609_REALK,  0.0000001572604653180731662_REALK,  &
    0.0000001483143436632250381_REALK,  0.0000001403058189218142179_REALK,  &
    0.0000001330978569375275110_REALK,                                      &
    0.2532075048282777518515729_REALK,  0.0103348048861585956742504_REALK,  &
    0.0012652910016768840941598_REALK,  0.0002580273424894813567333_REALK,  &
    0.0000735267869401730735177_REALK,  0.0000268145291865072883252_REALK,  &
    0.0000118438654554878011467_REALK,  0.0000060891891236413239101_REALK,  &
    0.0000035327640596935036107_REALK,  0.0000022559947601085935699_REALK,  &
    0.0000015542360428544592707_REALK,  0.0000011368914084822313518_REALK,  &
    0.0000008719748980800931840_REALK,  0.0000006944593901989136673_REALK,  &
    0.0000005700116793159824209_REALK,  0.0000004793967880830430174_REALK,  &
    0.0000004112727770794005686_REALK,  0.0000003586483367955563705_REALK,  &
    0.0000003170438528863502934_REALK,  0.0000002834900067210585293_REALK,  &
    0.0000002559588926527444221_REALK,  0.0000002330284574136123066_REALK,  &
    0.0000002136778072104602158_REALK,  0.0000001971585278506824981_REALK,  &
    0.0000001829115680348169302_REALK,  0.0000001705122221051888889_REALK,  &
    0.0000001596328953157361637_REALK,  0.0000001500173901879556824_REALK,  &
    0.0000001414628191105590609_REALK,  0.0000001338066651907193983_REALK,  &
    0.0000001269173818009607903_REALK,                                      &
    0.2526923408412303229120255_REALK,  0.0102718613453970410154259_REALK,  &
    0.0012524809874686197198879_REALK,  0.0002543842761333338863515_REALK,  &
    0.0000722007393687095199450_REALK,  0.0000262298743843618842808_REALK,  &
    0.0000115437753562966447917_REALK,  0.0000059153388279989087685_REALK,  &
    0.0000034218836567845678810_REALK,  0.0000021796860854574959327_REALK,  &
    0.0000014984671203499678407_REALK,  0.0000010941489863522800116_REALK,  &
    0.0000008379545619113500488_REALK,  0.0000006665495766138434469_REALK,  &
    0.0000005465485408735959848_REALK,  0.0000004592749277337859009_REALK,  &
    0.0000003937308250676477511_REALK,  0.0000003431452343150025219_REALK,  &
    0.0000003031845015423575928_REALK,  0.0000002709789469099169876_REALK,  &
    0.0000002445705067643645514_REALK,  0.0000002225872485469817757_REALK,  &
    0.0000002040450091234536802_REALK,  0.0000001882228027427734886_REALK,  &
    0.0000001745824091799629187_REALK,  0.0000001627151864526450347_REALK,  &
    0.0000001523060994309577400_REALK,  0.0000001431088945836392119_REALK,  &
    0.0000001349286479275195730_REALK,  0.0000001276092873489931619_REALK,  &
    0.0000001210245321344463466_REALK,                                      &
    0.2521803080942565666866528_REALK,  0.0102095537789874679646118_REALK,  &
    0.0012398514811213080886315_REALK,  0.0002508067875441476364540_REALK,  &
    0.0000709035530179328069532_REALK,  0.0000256600090645871359405_REALK,  &
    0.0000112522407467354420993_REALK,  0.0000057469383174683320986_REALK,  &
    0.0000033147498581348984874_REALK,  0.0000021061131304534544586_REALK,  &
    0.0000014447933689280427520_REALK,  0.0000010530731773844520845_REALK,  &
    0.0000008053008021760850097_REALK,  0.0000006397881290813436736_REALK,  &
    0.0000005240698874130877187_REALK,  0.0000004400110716148447006_REALK,  &
    0.0000003769469616990755460_REALK,  0.0000003283196951407482585_REALK,  &
    0.0000002899366827462902850_REALK,  0.0000002590244532599102130_REALK,  &
    0.0000002336923243337437229_REALK,  0.0000002126166814409130330_REALK,  &
    0.0000001948487463913477290_REALK,  0.0000001796939401424178317_REALK,  &
    0.0000001666340858542757662_REALK,  0.0000001552759895047242818_REALK,  &
    0.0000001453166882043675666_REALK,  0.0000001365194821351657139_REALK,  &
    0.0000001286970951960003053_REALK,  0.0000001216996421084608049_REALK,  &
    0.0000001154058954779845013_REALK,                                      &
    0.2516713750129150883871887_REALK,  0.0101478732429115953150855_REALK,  &
    0.0012273992395172277775073_REALK,  0.0002472934519709114268432_REALK,  &
    0.0000696344989955179245744_REALK,  0.0000251045121875857048601_REALK,  &
    0.0000109689937643510885553_REALK,  0.0000055838036382672775145_REALK,  &
    0.0000032112284623577993915_REALK,  0.0000020351731916349560807_REALK,  &
    0.0000013931331424809851153_REALK,  0.0000010135970679260083655_REALK,  &
    0.0000007739574134984859991_REALK,  0.0000006141268802389730535_REALK,  &
    0.0000005025337523756616456_REALK,  0.0000004215681496515551515_REALK,  &
    0.0000003608880617605851401_REALK,  0.0000003141418278453042482_REALK,  &
    0.0000002772731962520159595_REALK,  0.0000002476015949108425122_REALK,  &
    0.0000002233013505639973061_REALK,  0.0000002030954300640397187_REALK,  &
    0.0000001860691445652393162_REALK,  0.0000001715533386250039954_REALK,  &
    0.0000001590491212838488396_REALK,  0.0000001481781546521367488_REALK,  &
    0.0000001386490798275472802_REALK,  0.0000001302343759404954201_REALK,  &
    0.0000001227541116609493321_REALK,  0.0000001160643410136418551_REALK,  &
    0.0000001100486859785967289_REALK,                                      &
    0.2511655104659408777045826_REALK,  0.0100868109535411573651764_REALK,  &
    0.0012151210898737930827390_REALK,  0.0002438428805864634760052_REALK,  &
    0.0000683928691300891383699_REALK,  0.0000245629758797099537757_REALK,  &
    0.0000106937755787463920196_REALK,  0.0000054257574199870987542_REALK,  &
    0.0000031111903025615330133_REALK,  0.0000019667675653623191205_REALK,  &
    0.0000013434080713196677735_REALK,  0.0000009756564952485417879_REALK,  &
    0.0000007438705471763856931_REALK,  0.0000005895197153970010329_REALK,  &
    0.0000004818999819154503704_REALK,  0.0000004039107112258545658_REALK,  &
    0.0000003455224611235829739_REALK,  0.0000003005830703234470233_REALK,  &
    0.0000002651680600520672626_REALK,  0.0000002366865644940619175_REALK,  &
    0.0000002133756324997617270_REALK,  0.0000001940031392155001850_REALK,  &
    0.0000001776872377607291119_REALK,  0.0000001637832503296611850_REALK,  &
    0.0000001518108433521973532_REALK,  0.0000001414059661941161534_REALK,  &
    0.0000001322884140512263484_REALK,  0.0000001242394850879777825_REALK,  &
    0.0000001170863017596210798_REALK,  0.0000001106906198503614320_REALK,  &
    0.0000001049407150661451320_REALK,                                      &
    0.2506626837573130428538093_REALK,  0.0100263582841656380406636_REALK,  &
    0.0012030139279729933250718_REALK,  0.0002404537194677155845842_REALK,  &
    0.0000671779753240772089856_REALK,  0.0000240350049897846469065_REALK,  &
    0.0000104263360686220969882_REALK,  0.0000052726286288003455614_REALK,  &
    0.0000030145110503970587206_REALK,  0.0000019008013873868540581_REALK,  &
    0.0000012955429275308604255_REALK,  0.0000009391899322427780121_REALK,  &
    0.0000007149886107802091538_REALK,  0.0000005659224838970619774_REALK,  &
    0.0000004621301557256791748_REALK,  0.0000003870048537586417634_REALK,  &
    0.0000003308198917775698617_REALK,  0.0000002876161302632413439_REALK,  &
    0.0000002535964554853957237_REALK,  0.0000002262566272352373375_REALK,  &
    0.0000002038942116038229315_REALK,  0.0000001853203801471214403_REALK,  &
    0.0000001696849269699013727_REALK,  0.0000001563667416626752999_REALK,  &
    0.0000001449033474426814927_REALK,  0.0000001349444341045124373_REALK,  &
    0.0000001262205186900525968_REALK,  0.0000001185213727397655608_REALK,  &
    0.0000001116808931443397627_REALK,  0.0000001055663094859430166_REALK,  &
    0.0000001000703635036773709_REALK,                                      &
    0.2501628646184940740759828_REALK,  0.0099665067616072477302280_REALK,  &
    0.0011910747164410181390265_REALK,  0.0002371246486076852898282_REALK,  &
    0.0000659891489283508607790_REALK,  0.0000235202166614728086144_REALK,  &
    0.0000101664335109167602628_REALK,  0.0000051242523302680375257_REALK,  &
    0.0000029210710279613708646_REALK,  0.0000018371834790100848384_REALK,  &
    0.0000012494654959761541675_REALK,  0.0000009041383770242662602_REALK,  &
    0.0000006872621720863748799_REALK,  0.0000005432929143414032722_REALK,  &
    0.0000004431875113556833859_REALK,  0.0000003708181544671198852_REALK,  &
    0.0000003167514197725341097_REALK,  0.0000002752149282989398672_REALK,  &
    0.0000002425346748315873043_REALK,  0.0000002162900723736458038_REALK,  &
    0.0000001948370785012768292_REALK,  0.0000001770286082216025040_REALK,  &
    0.0000001620449402923772051_REALK,  0.0000001492876558154132064_REALK,  &
    0.0000001383114610013642308_REALK,  0.0000001287792604333357376_REALK,  &
    0.0000001204318776856538014_REALK,  0.0000001130672257031673243_REALK,  &
    0.0000001065257076288464778_REALK,  0.0000001006798080738645327_REALK,  &
    0.0000000954265547477239275_REALK,                                      &
    0.2496660232008360846833739_REALK,  0.0099072480629207107516443_REALK,  &
    0.0011793004830765074948673_REALK,  0.0002338543809582698407984_REALK,  &
    0.0000648257401378472000947_REALK,  0.0000230182399208922815290_REALK,  &
    0.0000099138342815744374216_REALK,  0.0000049804694613622430355_REALK,  &
    0.0000028307550272339065444_REALK,  0.0000017758261995570332877_REALK,  &
    0.0000012051064506922395912_REALK,  0.0000008704452472380102026_REALK,  &
    0.0000006606438671561545110_REALK,  0.0000005215905335224058515_REALK,  &
    0.0000004250368718637197393_REALK,  0.0000003553196051551097101_REALK,  &
    0.0000003032893859392550926_REALK,  0.0000002633545437244520345_REALK,  &
    0.0000002319600712784417394_REALK,  0.0000002067661667921871470_REALK,  &
    0.0000001861851297919090099_REALK,  0.0000001691101225130592938_REALK,  &
    0.0000001547507949969184723_REALK,  0.0000001425305770127844487_REALK,  &
    0.0000001320207097405405684_REALK,  0.0000001228968072677543474_REALK,  &
    0.0000001149096006554056060_REALK,  0.0000001078648254205286117_REALK,  &
    0.0000001016091334916642442_REALK,  0.0000000960200545589513306_REALK,  &
    0.0000000909987295571023072_REALK,                                      &
    0.2491721300681496442663843_REALK,  0.0098485740121754556525291_REALK,  &
    0.0011676883192259207133040_REALK,  0.0002306416615027282888874_REALK,  &
    0.0000636871174074513844926_REALK,  0.0000225287152789124329099_REALK,  &
    0.0000096683125674884913032_REALK,  0.0000048411266113348848332_REALK,  &
    0.0000027434521367369712710_REALK,  0.0000017166453048992358207_REALK,  &
    0.0000011623992364627519537_REALK,  0.0000008380562788592845108_REALK,  &
    0.0000006350883123788838947_REALK,  0.0000005007765888891009701_REALK,  &
    0.0000004076445766572263027_REALK,  0.0000003404795499004653149_REALK,  &
    0.0000002904073492623125345_REALK,  0.0000002520111626513206623_REALK,  &
    0.0000002218510111548796892_REALK,  0.0000001976651107570213687_REALK,  &
    0.0000001779201268358085710_REALK,  0.0000001615480272604858225_REALK,  &
    0.0000001477867613289711905_REALK,  0.0000001360807964120895630_REALK,  &
    0.0000001260172854067317061_REALK,  0.0000001172840661799227627_REALK,  &
    0.0000001096413938576344167_REALK,  0.0000001029025203113328336_REALK,  &
    0.0000000969200990729433792_REALK,  0.0000000915765034221278529_REALK,  &
    0.0000000867768217916067335_REALK,                                      &
    0.2486811561894319844157053_REALK,  0.0097904765773178716731229_REALK,  &
    0.0011562353782045501748160_REALK,  0.0002274852663568785373499_REALK,  &
    0.0000625726668874060257090_REALK,  0.0000220512943475833719537_REALK,  &
    0.0000094296500891882160223_REALK,  0.0000047060758110791503148_REALK,  &
    0.0000026590555751240479532_REALK,  0.0000016595598117745033904_REALK,  &
    0.0000011212799553416983730_REALK,  0.0000008069194292968215423_REALK,  &
    0.0000006105520203067121587_REALK,  0.0000004808139743949367267_REALK,  &
    0.0000003909784153790085372_REALK,  0.0000003262696255100347339_REALK,  &
    0.0000002780800327864017163_REALK,  0.0000002411620285005827288_REALK,  &
    0.0000002121868283261450377_REALK,  0.0000001889679956705101529_REALK,  &
    0.0000001700246564217898615_REALK,  0.0000001543261950888574827_REALK,  &
    0.0000001411378279836391494_REALK,  0.0000001299242795758807590_REALK,  &
    0.0000001202880150405492403_REALK,  0.0000001119286290925417642_REALK,  &
    0.0000001046155325072121018_REALK,  0.0000000981691994033783755_REALK,  &
    0.0000000924480476043101705_REALK,  0.0000000873391006066596123_REALK,  &
    0.0000000827512353447463169_REALK,                                      &
    0.2481930729317502193342904_REALK,  0.0097329478671114334764614_REALK,  &
    0.0011449388737617902100929_REALK,  0.0002243840018980510506511_REALK,  &
    0.0000614817918775571281391_REALK,  0.0000215856394701711250944_REALK,  &
    0.0000091976358338522342620_REALK,  0.0000045751743306442605615_REALK,  &
    0.0000025774625314122945797_REALK,  0.0000016044918676611207421_REALK,  &
    0.0000010816872579180748669_REALK,  0.0000007769847846129072201_REALK,  &
    0.0000005869933191155494419_REALK,  0.0000004616671595779758913_REALK,  &
    0.0000003750075647041115680_REALK,  0.0000003126627046183884306_REALK,  &
    0.0000002662832719419448749_REALK,  0.0000002307853947228919158_REALK,  &
    0.0000002029477806529749408_REALK,  0.0000001806567637454776292_REALK,  &
    0.0000001624820932322814003_REALK,  0.0000001474292319165936027_REALK,  &
    0.0000001347896691671792055_REALK,  0.0000001240476354459875955_REALK,  &
    0.0000001148203316592530764_REALK,  0.0000001068186604961983287_REALK,  &
    0.0000000998208343786538874_REALK,  0.0000000936542671928712171_REALK,  &
    0.0000000881829132140207991_REALK,  0.0000000832982605705364316_REALK,  &
    0.0000000789128221573054957_REALK,                                      &
    0.2477078520532750294247393_REALK,  0.0096759801281524580873761_REALK,  &
    0.0011337960785892712244072_REALK,  0.0002213367039208718513050_REALK,  &
    0.0000604139122997681793066_REALK,  0.0000211314233642920470848_REALK,  &
    0.0000089720657982490343115_REALK,  0.0000044482844845781350116_REALK,  &
    0.0000024985740115872978682_REALK,  0.0000015513666259744873056_REALK,  &
    0.0000010435622391202365165_REALK,  0.0000007482044706831163010_REALK,  &
    0.0000005643722755341610634_REALK,  0.0000004433021217311236057_REALK,  &
    0.0000003597025279180895152_REALK,  0.0000002996328413120101177_REALK,  &
    0.0000002549939651810573347_REALK,  0.0000002208604796460025920_REALK,  &
    0.0000001941150084208192468_REALK,  0.0000001727141695130140260_REALK,  &
    0.0000001552765640222772855_REALK,  0.0000001408424434717250928_REALK,  &
    0.0000001287286131737114622_REALK,  0.0000001184380867492117450_REALK,  &
    0.0000001096022462959285460_REALK,  0.0000001019428709555997342_REALK,  &
    0.0000000952466346366546346_REALK,  0.0000000893476196759952318_REALK,  &
    0.0000000841150980524455874_REALK,  0.0000000794448444121909790_REALK,  &
    0.0000000752528612610188583_REALK,                                      &
    0.2472254656964622543391386_REALK,  0.0096195657419594279846642_REALK,  &
    0.0011228043228705606153967_REALK,  0.0002183422368189854873705_REALK,  &
    0.0000593684641878607682517_REALK,  0.0000206883287776603353207_REALK,  &
    0.0000087527427412212966762_REALK,  0.0000043252734447860141005_REALK,  &
    0.0000024222946913196075441_REALK,  0.0000015001121263640869348_REALK,  &
    0.0000010068483383673673469_REALK,  0.0000007205325681260090734_REALK,  &
    0.0000005426506210903474274_REALK,  0.0000004256862810265512581_REALK,  &
    0.0000003450350771533258876_REALK,  0.0000002871552191661580657_REALK,  &
    0.0000002441900268200213378_REALK,  0.0000002113674233534790136_REALK,  &
    0.0000001856704946496305818_REALK,  0.0000001651237430801584974_REALK,  &
    0.0000001483929134338456428_REALK,  0.0000001345518033428566490_REALK,  &
    0.0000001229416124072566029_REALK,  0.0000001130834417684943509_REALK,  &
    0.0000001046223213324081227_REALK,  0.0000000972904918448174009_REALK,  &
    0.0000000908827618369382076_REALK,  0.0000000852396214973331741_REALK,  &
    0.0000000802354504854884825_REALK,  0.0000000757701390193190853_REALK,  &
    0.0000000717630388040282749_REALK,                                      &
    0.2467458863813781211327125_REALK,  0.0095636972221338090865972_REALK,  &
    0.0011119609928711457046829_REALK,  0.0002153994927918551083052_REALK,  &
    0.0000583448991944619815451_REALK,  0.0000202560481559802754573_REALK,  &
    0.0000085394759453455949751_REALK,  0.0000042060130606056645464_REALK,  &
    0.0000023485327745433455144_REALK,  0.0000014506591798980711103_REALK,  &
    0.0000009714912438835938887_REALK,  0.0000006939250308406538276_REALK,  &
    0.0000005217916815297815468_REALK,  0.0000004087884384642619825_REALK,  &
    0.0000003309781981654406665_REALK,  0.0000002752061015864800857_REALK,  &
    0.0000002338503419889236573_REALK,  0.0000002022872465026276924_REALK,  &
    0.0000001775970271986590484_REALK,  0.0000001578697550575093365_REALK,  &
    0.0000001418166713711709786_REALK,  0.0000001285439224942392226_REALK,  &
    0.0000001174162147823887884_REALK,  0.0000001079720674163131339_REALK,  &
    0.0000000998696450658943619_REALK,  0.0000000928512512543505335_REALK,  &
    0.0000000867195150428361362_REALK,  0.0000000813210841629329989_REALK,  &
    0.0000000765352443059964906_REALK,  0.0000000722658371928325539_REALK,  &
    0.0000000684354290120343643_REALK,                                      &
    0.2462690869991644992964552_REALK,  0.0095083672115903721672181_REALK,  &
    0.0011012635295674618254869_REALK,  0.0002125073910758093671553_REALK,  &
    0.0000573426841141628281656_REALK,  0.0000198342833225334946466_REALK,  &
    0.0000083320809874139161843_REALK,  0.0000040903796858120849427_REALK,  &
    0.0000022771998576576564909_REALK,  0.0000014029412589317462992_REALK,  &
    0.0000009374388009982709414_REALK,  0.0000006683396079967488976_REALK,  &
    0.0000005017603092693924996_REALK,  0.0000003925787165207277846_REALK,  &
    0.0000003175060375371314509_REALK,  0.0000002637627843524668882_REALK,  &
    0.0000002239547235937665726_REALK,  0.0000001936018109940652816_REALK,  &
    0.0000001698781625847272645_REALK,  0.0000001509371830805772109_REALK,  &
    0.0000001355340218646552539_REALK,  0.0000001228060201777186439_REALK,  &
    0.0000001121405364399211947_REALK,  0.0000001030928635501356584_REALK,  &
    0.0000000953338074520628073_REALK,  0.0000000886153510155671611_REALK,  &
    0.0000000827476420056348793_REALK,  0.0000000775832452683674101_REALK,  &
    0.0000000730061589155317898_REALK,  0.0000000689240187002825847_REALK,  &
    0.0000000652624760412649556_REALK,                                      &
    0.2457950408056411573110012_REALK,  0.0094535684798551598145844_REALK,  &
    0.0010907094273137885563629_REALK,  0.0002096648771985369836580_REALK,  &
    0.0000563613004224145297603_REALK,  0.0000194227451690288357902_REALK,  &
    0.0000081303795173975416098_REALK,  0.0000039782540122764234119_REALK,  &
    0.0000022082107991217417013_REALK,  0.0000013568943914649450299_REALK,  &
    0.0000009046409242635733560_REALK,  0.0000006437357693290000082_REALK,  &
    0.0000004825228187533064360_REALK,  0.0000003770285023789058961_REALK,  &
    0.0000003045938522018985087_REALK,  0.0000002528035502643864061_REALK,  &
    0.0000002144838712005755344_REALK,  0.0000001852937824091494926_REALK,  &
    0.0000001624981914361246467_REALK,  0.0000001443116798521364819_REALK,  &
    0.0000001295317733558556888_REALK,  0.0000001173258961772700673_REALK,  &
    0.0000001071032357169823359_REALK,  0.0000000984352384724293812_REALK,  &
    0.0000000910048769701192754_REALK,  0.0000000845734447905718832_REALK,  &
    0.0000000789583183591550194_REALK,  0.0000000740177486943915557_REALK,  &
    0.0000000696402604311728809_REALK,  0.0000000657371322152210835_REALK,  &
    0.0000000622369766814226096_REALK,                                      &
    0.2453237214150412737190265_REALK,  0.0093992939204291282850878_REALK,  &
    0.0010802962325458394764188_REALK,  0.0002068709222562533300242_REALK,  &
    0.0000554002438296087506230_REALK,  0.0000190211533572986242078_REALK,  &
    0.0000079341990455670572362_REALK,  0.0000038695209100148338850_REALK,  &
    0.0000021414835942236723342_REALK,  0.0000013124570598014489295_REALK,  &
    0.0000008730495132276966236_REALK,  0.0000006200746335937561109_REALK,  &
    0.0000004640469245851250016_REALK,  0.0000003621103936261860477_REALK,  &
    0.0000002922179611847659113_REALK,  0.0000002423076257997547093_REALK,  &
    0.0000002054193317550878692_REALK,  0.0000001773465941353722393_REALK,  &
    0.0000001554421055077968146_REALK,  0.0000001379795426361611585_REALK,  &
    0.0000001237973303381482971_REALK,  0.0000001120919043248839781_REALK,  &
    0.0000001022934883136160249_REALK,  0.0000000939890855604625497_REALK,  &
    0.0000000868733785577438338_REALK,  0.0000000807166171779653489_REALK,  &
    0.0000000753431277812859976_REALK,  0.0000000706166257250395755_REALK,  &
    0.0000000664299836740442136_REALK,  0.0000000626979781009902391_REALK,  &
    0.0000000593520638687287545_REALK,                                      &
    0.2448551027938773716474685_REALK,  0.0093455365482157572859512_REALK,  &
    0.0010700215425199521325494_REALK,  0.0002041245222127953038143_REALK,  &
    0.0000544590238498108200334_REALK,  0.0000186292360314417473986_REALK,  &
    0.0000077433727374555605193_REALK,  0.0000037640692733740005341_REALK,  &
    0.0000020769392548124619943_REALK,  0.0000012695701033316169544_REALK,  &
    0.0000008426183717090544872_REALK,  0.0000005973189000521625500_REALK,  &
    0.0000004463016823158867826_REALK,  0.0000003477981463119735921_REALK,  &
    0.0000002803556994618248283_REALK,  0.0000002322551396896723431_REALK,  &
    0.0000001967434620555876343_REALK,  0.0000001697444131034664547_REALK,  &
    0.0000001486955661869438350_REALK,  0.0000001319276841371525347_REALK,  &
    0.0000001183186662910484831_REALK,  0.0000001070929272293690491_REALK,  &
    0.0000000977009636007398477_REALK,  0.0000000897447609736560251_REALK,  &
    0.0000000829302725663488431_REALK,  0.0000000770363637873143011_REALK,  &
    0.0000000718940430774621215_REALK,  0.0000000673722770451137176_REALK,  &
    0.0000000633681149983897463_REALK,  0.0000000597996919994137214_REALK,  &
    0.0000000566011909710671972_REALK,                                      &
    0.2443891592549342350881858_REALK,  0.0092922894970108096956984_REALK,  &
    0.0010598830040867868607785_REALK,  0.0002014246972199238729356_REALK,  &
    0.0000535371633836323265070_REALK,  0.0000182467295400286798389_REALK,  &
    0.0000075577392163642102236_REALK,  0.0000036617918731101912442_REALK,  &
    0.0000020145016937914883845_REALK,  0.0000012281766252668667989_REALK,  &
    0.0000008133031304233368319_REALK,  0.0000005754327828499386327_REALK,  &
    0.0000004292574317723132779_REALK,  0.0000003340666252612583252_REALK,  &
    0.0000002689853738447636130_REALK,  0.0000002226270833293313951_REALK,  &
    0.0000001884393929000989294_REALK,  0.0000001624721070633642236_REALK,  &
    0.0000001422448744213356620_REALK,  0.0000001261436047016226298_REALK,  &
    0.0000001130842978489195947_REALK,  0.0000001023183521623181510_REALK,  &
    0.0000000933158020168432730_REALK,  0.0000000856930623886397713_REALK,  &
    0.0000000791669346893294106_REALK,  0.0000000735245722372800683_REALK,  &
    0.0000000686034081431387544_REALK,  0.0000000642774555760315286_REALK,  &
    0.0000000604477759218660623_REALK,  0.0000000570357291866760874_REALK,  &
    0.0000000539781168090193321_REALK,                                      &
    0.2439258654513855317791382_REALK,  0.0092395460170525741533387_REALK,  &
    0.0010498783124984901581750_REALK,  0.0001987704909581389668000_REALK,  &
    0.0000526341983147496499953_REALK,  0.0000178733781679986721165_REALK,  &
    0.0000073771423731213429031_REALK,  0.0000035625852141286193425_REALK,  &
    0.0000019540976141798251826_REALK,  0.0000011882219031619360264_REALK,  &
    0.0000007850611728217758870_REALK,  0.0000005543819481695225178_REALK,  &
    0.0000004128857428150431591_REALK,  0.0000003208917565452316413_REALK,  &
    0.0000002580862208007314294_REALK,  0.0000002134052729408841761_REALK,  &
    0.0000001804909948327856441_REALK,  0.0000001555152133295447111_REALK,  &
    0.0000001360769420057657098_REALK,  0.0000001206153657814934808_REALK,  &
    0.0000001080832601475884163_REALK,  0.0000000977580480480775865_REALK,  &
    0.0000000891285935032355183_REALK,  0.0000000818252087145344221_REALK,  &
    0.0000000755751368182272663_REALK,  0.0000000701735040345190321_REALK,  &
    0.0000000654639207643374621_REALK,  0.0000000613252501109094438_REALK,  &
    0.0000000576624075196265008_REALK,  0.0000000543998496604840642_REALK,  &
    0.0000000514768913782838157_REALK,                                      &
    0.2434651963710321165290651_REALK,  0.0091872994726309425289612_REALK,  &
    0.0010400052102483273077510_REALK,  0.0001961609699973388722116_REALK,  &
    0.0000517496771195930500386_REALK,  0.0000175089338778936317751_REALK,  &
    0.0000072014311828178789450_REALK,  0.0000034663493986594816417_REALK,  &
    0.0000018956564025560774939_REALK,  0.0000011496533030678167319_REALK,  &
    0.0000007578515640049944592_REALK,  0.0000005341334540358012388_REALK,  &
    0.0000003971593634214058888_REALK,  0.0000003082504820143004297_REALK,  &
    0.0000002476383661218829734_REALK,  0.0000002045723134105083348_REALK,  &
    0.0000001728828454177213064_REALK,  0.0000001488599089293810219_REALK,  &
    0.0000001301792641649891492_REALK,  0.0000001153315646018272951_REALK,  &
    0.0000001033050832949087424_REALK,  0.0000000934023435069853949_REALK,  &
    0.0000000851303569299690960_REALK,  0.0000000781328207431113198_REALK,  &
    0.0000000721470287837751104_REALK,  0.0000000669757772924103603_REALK,  &
    0.0000000624686162172338797_REALK,  0.0000000585090697115941692_REALK,  &
    0.0000000550057555464726905_REALK,  0.0000000518861039242544085_REALK,  &
    0.0000000490918422405610658_REALK,                                      &
    0.2430071273306575185824130_REALK,  0.0091355433397536881662271_REALK,  &
    0.0010302614859417904766281_REALK,  0.0001935952231766736397842_REALK,  &
    0.0000508831604897474009774_REALK,  0.0000171531560600861760759_REALK,  &
    0.0000070304595282523933773_REALK,  0.0000033729879946558970038_REALK,  &
    0.0000018391100267069240070_REALK,  0.0000011124201971647907143_REALK,  &
    0.0000007316349825825848811_REALK,  0.0000005146556926616552544_REALK,  &
    0.0000003820521699918729241_REALK,  0.0000002961207158031044226_REALK,  &
    0.0000002376227863627632747_REALK,  0.0000001961115637250335005_REALK,  &
    0.0000001656001979714946455_REALK,  0.0000001424929820911661479_REALK,  &
    0.0000001245398933743076821_REALK,  0.0000001102813099780136514_REALK,  &
    0.0000000987397699138434835_REALK,  0.0000000892420059035076292_REALK,  &
    0.0000000813125204667870334_REALK,  0.0000000746079026906449273_REALK,  &
    0.0000000688751209408277360_REALK,  0.0000000639243502506141490_REALK,  &
    0.0000000596108516295869428_REALK,  0.0000000558226288321001371_REALK,  &
    0.0000000524718562530544368_REALK,  0.0000000494888194357054556_REALK,  &
    0.0000000468175615515922742_REALK,                                      &
    0.2425516339704997248460927_REALK,  0.0090842712038684547692924_REALK,  &
    0.0010206449731982557282972_REALK,  0.0001910723610029714698844_REALK,  &
    0.0000500342209666239476785_REALK,  0.0000168058112916732180567_REALK,  &
    0.0000068640860298301440548_REALK,  0.0000032824079092079168438_REALK,  &
    0.0000017843929373100461589_REALK,  0.0000010764738847314708767_REALK,  &
    0.0000007063736553542109296_REALK,  0.0000004959183352246416129_REALK,  &
    0.0000003675391197837541876_REALK,  0.0000002844813027211001932_REALK,  &
    0.0000002280212719673842104_REALK,  0.0000001880071039368410188_REALK,  &
    0.0000001586289516891967929_REALK,  0.0000001364018050113463373_REALK,  &
    0.0000001191474143616727132_REALK,  0.0000001054541992300140796_REALK,  &
    0.0000000943777737089896554_REALK,  0.0000000852682213531111089_REALK,  &
    0.0000000776669028555525685_REALK,  0.0000000712428245902384400_REALK,  &
    0.0000000657522675580782795_REALK,  0.0000000610125055582527699_REALK,  &
    0.0000000568842910685522476_REALK,  0.0000000532599331345604384_REALK,  &
    0.0000000500550228636832998_REALK,  0.0000000472025876887412564_REALK,  &
    0.0000000446488936964513745_REALK,                                      &
    0.2420986922488347625748162_REALK,  0.0090334767576389033566509_REALK,  &
    0.0010111535495822602213900_REALK,  0.0001885915150671327409227_REALK,  &
    0.0000492024425879770851934_REALK,  0.0000164666731037183023420_REALK,  &
    0.0000067021738816700763129_REALK,  0.0000031945192667749164347_REALK,  &
    0.0000017314419734880779155_REALK,  0.0000010417675163117193804_REALK,  &
    0.0000006820312946932620654_REALK,  0.0000004778922789707189792_REALK,  &
    0.0000003535962053799727211_REALK,  0.0000002733119784461228090_REALK,  &
    0.0000002188163920112696258_REALK,  0.0000001802437035889401459_REALK,  &
    0.0000001519556231012645854_REALK,  0.0000001305743078432256570_REALK,  &
    0.0000001139909202376752140_REALK,  0.0000001008402961436839823_REALK,  &
    0.0000000902099790097170049_REALK,  0.0000000814725756438489052_REALK,  &
    0.0000000741856955426210375_REALK,  0.0000000680303054953249911_REALK,  &
    0.0000000627716509752621571_REALK,  0.0000000582338352852474846_REALK,  &
    0.0000000542828913210572032_REALK,  0.0000000508152659654022254_REALK,  &
    0.0000000477498326848469366_REALK,  0.0000000450222518989916307_REALK,  &
    0.0000000425809235036291620_REALK,                                      &
    0.2416482784366702774025981_REALK,  0.0089831537987735479711127_REALK,  &
    0.0010017851355635246438092_REALK,  0.0001861518374779105747339_REALK,  &
    0.0000483874205458566659628_REALK,  0.0000161355217565382975573_REALK,  &
    0.0000065445906936837012786_REALK,  0.0000031092352920467824060_REALK,  &
    0.0000016801962720770285939_REALK,  0.0000010082560209472052528_REALK,  &
    0.0000006585730385192278707_REALK,  0.0000004605495965455065772_REALK,  &
    0.0000003402004111047205338_REALK,  0.0000002625933314419445594_REALK,  &
    0.0000002099914604870935939_REALK,  0.0000001728067915351706657_REALK,  &
    0.0000001455673188015103108_REALK,  0.0000001249989538520502755_REALK,  &
    0.0000001090599897023099285_REALK,  0.0000000964301099314417216_REALK,  &
    0.0000000862276812452252138_REALK,  0.0000000778470360306532956_REALK,  &
    0.0000000708614456315396802_REALK,  0.0000000649633974568636396_REALK,  &
    0.0000000599267664923009780_REALK,  0.0000000555822266279974536_REALK,  &
    0.0000000518008883345047053_REALK,  0.0000000484831754609326297_REALK,  &
    0.0000000455511148149314163_REALK,  0.0000000429428952647353160_REALK,  &
    0.0000000406089650107705950_REALK,                                      &
    0.2412003691125468030076462_REALK,  0.0089332962279059409393955_REALK,  &
    0.0009925376935048682656287_REALK,  0.0001837525003125169457355_REALK,  &
    0.0000475887608556012866212_REALK,  0.0000158121440227417548049_REALK,  &
    0.0000063912083393990818728_REALK,  0.0000030264721972519994985_REALK,  &
    0.0000016305971804591079949_REALK,  0.0000009758960363489164463_REALK,  &
    0.0000006359653927498271914_REALK,  0.0000004438634874578625498_REALK,  &
    0.0000003273296713017315898_REALK,  0.0000002523067665244151265_REALK,  &
    0.0000002015305040657437399_REALK,  0.0000001656824270934263325_REALK,  &
    0.0000001394517093893390120_REALK,  0.0000001196647156838543578_REALK,  &
    0.0000001043446652796613359_REALK,  0.0000000922145751467919900_REALK,  &
    0.0000000824225683089187831_REALK,  0.0000000743839338622808188_REALK,  &
    0.0000000676870396182953908_REALK,  0.0000000620354702384895480_REALK,  &
    0.0000000572114079564786328_REALK,  0.0000000530518482771631121_REALK,  &
    0.0000000494327842870818400_REALK,  0.0000000462584622530087857_REALK,  &
    0.0000000434539384270901784_REALK,  0.0000000409598297762964045_REALK,  &
    0.0000000387285507562012015_REALK,                                      &
    0.2407549411574431696969611_REALK,  0.0088838980465247366358206_REALK,  &
    0.0009834092266771757035598_REALK,  0.0001813926950835100643765_REALK,  &
    0.0000468060800354913421405_REALK,  0.0000154963329777367855280_REALK,  &
    0.0000062419028093117867207_REALK,  0.0000029461490737379373004_REALK,  &
    0.0000015825881728160105491_REALK,  0.0000009446458418862368939_REALK,  &
    0.0000006141761761285366772_REALK,  0.0000004278082315846534862_REALK,  &
    0.0000003149628303945344520_REALK,  0.0000002424344700039916922_REALK,  &
    0.0000001934182312676245160_REALK,  0.0000001588572724725456639_REALK,  &
    0.0000001335970045717255769_REALK,  0.0000001145610526978506121_REALK,  &
    0.0000000998354325339357274_REALK,  0.0000000881850325092421657_REALK,  &
    0.0000000787867027714122482_REALK,  0.0000000710759480026830734_REALK,  &
    0.0000000646556878730704319_REALK,  0.0000000592401967355360377_REALK,  &
    0.0000000546196540153143732_REALK,  0.0000000506371374168000510_REALK,  &
    0.0000000471733352583618961_REALK,  0.0000000441361677467902004_REALK,  &
    0.0000000414536015984617755_REALK,  0.0000000390685855482321364_REALK,  &
    0.0000000369354215716069675_REALK,                                      &
    0.2403119717497846641318660_REALK,  0.0088349533549523778103163_REALK,  &
    0.0009743977783006316272310_REALK,  0.0001790716322214411812628_REALK,  &
    0.0000460390047966960036193_REALK,  0.0000151878877974377673619_REALK,  &
    0.0000060965540695536287125_REALK,  0.0000028681877876558997266_REALK,  &
    0.0000015361147696647712533_REALK,  0.0000009144652942773675933_REALK,  &
    0.0000005931744673276934510_REALK,  0.0000004123591446295907353_REALK,  &
    0.0000003030796046516127891_REALK,  0.0000002329593763357944354_REALK,  &
    0.0000001856400029819751365_REALK,  0.0000001523185664161975692_REALK,  &
    0.0000001279919293729936378_REALK,  0.0000001096778893144131695_REALK,  &
    0.0000000955232002223456180_REALK,  0.0000000843332105981641710_REALK,  &
    0.0000000753125049033709828_REALK,  0.0000000679160890103489057_REALK,  &
    0.0000000617609098341283544_REALK,  0.0000000565715390654067995_REALK,  &
    0.0000000521458550043162278_REALK,  0.0000000483327873255445683_REALK,  &
    0.0000000450175394722807975_REALK,  0.0000000421115629439034727_REALK,  &
    0.0000000395456206602199633_REALK,  0.0000000372649006498455278_REALK,  &
    0.0000000352255168523602668_REALK,                                      &
    0.2398714383605508038144194_REALK,  0.0087864563503710548658665_REALK,  &
    0.0009655014306114347586232_REALK,  0.0001767885405727535137656_REALK,  &
    0.0000452871717431601141565_REALK,  0.0000148866135629098088637_REALK,  &
    0.0000059550459256778273087_REALK,  0.0000027925128795900581568_REALK,  &
    0.0000014911244605438707563_REALK,  0.0000008853157658696926990_REALK,  &
    0.0000005729305542315373366_REALK,  0.0000003974925354527141015_REALK,  &
    0.0000002916605455827559917_REALK,  0.0000002238651362111976236_REALK,  &
    0.0000001781818042746936358_REALK,  0.0000001460540990096316982_REALK,  &
    0.0000001226257014027623430_REALK,  0.0000001050055943328912841_REALK,  &
    0.0000000913992813424188363_REALK,  0.0000000806512083760547547_REALK,  &
    0.0000000719927364711695646_REALK,  0.0000000648976840408335079_REALK,  &
    0.0000000589965198810488683_REALK,  0.0000000540237352983153486_REALK,  &
    0.0000000497846204402058980_REALK,  0.0000000461337355519014357_REALK,  &
    0.0000000429606260858519209_REALK,  0.0000000401801377856022935_REALK,  &
    0.0000000377257200441377022_REALK,  0.0000000355447114107180065_REALK,  &
    0.0000000335949652831201169_REALK,                                      &
    0.2394333187484808389555724_REALK,  0.0087384013248947289831392_REALK,  &
    0.0009567183039532465346072_REALK,  0.0001745426669124451872928_REALK,  &
    0.0000445502270810905768770_REALK,  0.0000145923210717000277539_REALK,  &
    0.0000058172658913673702804_REALK,  0.0000027190514679759663568_REALK,  &
    0.0000014475666297228160804_REALK,  0.0000008571600854034132826_REALK,  &
    0.0000005534158853076829085_REALK,  0.0000003831856651907667784_REALK,  &
    0.0000002806870048961061637_REALK,  0.0000002151360860280405716_REALK,  &
    0.0000001710302174278358486_REALK,  0.0000001400521875975516009_REALK,  &
    0.0000001174880091346624022_REALK,  0.0000001005349611755290469_REALK,  &
    0.0000000874553750331835696_REALK,  0.0000000771314785034105182_REALK,  &
    0.0000000688204852700240873_REALK,  0.0000000620143624392937641_REALK,  &
    0.0000000563566138560327108_REALK,  0.0000000515912867988006152_REALK,  &
    0.0000000475308070915798046_REALK,  0.0000000440351526369744201_REALK,  &
    0.0000000409980444982234975_REALK,  0.0000000383375909916608159_REALK,  &
    0.0000000359898226024462706_REALK,  0.0000000339041431790169852_REALK,  &
    0.0000000320400759973605713_REALK,                                      &
    0.2389975909553742061675052_REALK,  0.0086907826636859700913940_REALK,  &
    0.0009480465558926500771117_REALK,  0.0001723332754710260540567_REALK,  &
    0.0000438278263377144604676_REALK,  0.0000143048266556143721092_REALK,  &
    0.0000056831050618808476635_REALK,  0.0000026477331561605911664_REALK,  &
    0.0000014053924848136026458_REALK,  0.0000008299624811562349643_REALK,  &
    0.0000005346030229794068193_REALK,  0.0000003694167080921005440_REALK,  &
    0.0000002701411009484920117_REALK,  0.0000002067572186791818012_REALK,  &
    0.0000001641723961564774816_REALK,  0.0000001343016537637487163_REALK,  &
    0.0000001125689911505964237_REALK,  0.0000000962571890158138904_REALK,  &
    0.0000000836835492915906308_REALK,  0.0000000737668114092389167_REALK,  &
    0.0000000657891503609283051_REALK,  0.0000000592600419913919113_REALK,  &
    0.0000000538355562034566626_REALK,  0.0000000492689461498463210_REALK,  &
    0.0000000453795076002897533_REALK,  0.0000000420324313592530010_REALK,  &
    0.0000000391254541558938865_REALK,  0.0000000365798203719128206_REALK,  &
    0.0000000343340403789246171_REALK,  0.0000000323395015114138040_REALK,  &
    0.0000000305573301504964527_REALK,                                      &
    0.2385642333014846017125166_REALK,  0.0086435948431164335431509_REALK,  &
    0.0009394843803579094269202_REALK,  0.0001701596474753095820844_REALK,  &
    0.0000431196340889914694677_REALK,  0.0000140239520047072706760_REALK,  &
    0.0000055524579920571551022_REALK,  0.0000025784899429616133216_REALK,  &
    0.0000013645549881674531345_REALK,  0.0000008036885263711671033_REALK,  &
    0.0000005164655989148435312_REALK,  0.0000003561647139930880869_REALK,  &
    0.0000002600056866245844977_REALK,  0.0000001987141556018877106_REALK,  &
    0.0000001575960409510315897_REALK,  0.0000001287918013252701533_REALK,  &
    0.0000001078592163072785419_REALK,  0.0000000921638647513649039_REALK,  &
    0.0000000800762244672216801_REALK,  0.0000000705503200827794604_REALK,  &
    0.0000000628924279791992489_REALK,  0.0000000566289158023433299_REALK,  &
    0.0000000514279676992115053_REALK,  0.0000000470517056326826692_REALK,  &
    0.0000000433260396280285515_REALK,  0.0000000401211764772080018_REALK,  &
    0.0000000373387148309816886_REALK,  0.0000000349029135883890615_REALK,  &
    0.0000000327546658101059043_REALK,  0.0000000308472637744025051_REALK,  &
    0.0000000291433728872195332_REALK,                                      &
    0.2381332243810042326170873_REALK,  0.0085968324289698392487447_REALK,  &
    0.0009310300068003555347060_REALK,  0.0001680210807026032875707_REALK,  &
    0.0000424253236959767622517_REALK,  0.0000137495239972608056185_REALK,  &
    0.0000054252225787076643814_REALK,  0.0000025112561365896438955_REALK,  &
    0.0000013250087909450591528_REALK,  0.0000007783050868736279300_REALK,  &
    0.0000004989782711527945397_REALK,  0.0000003434095723661438204_REALK,  &
    0.0000002502643185832055957_REALK,  0.0000001909931200329828610_REALK,  &
    0.0000001512893754954520266_REALK,  0.0000001235123952960869094_REALK,  &
    0.0000001033496647838329813_REALK,  0.0000000882469457833916909_REALK,  &
    0.0000000766261575000809211_REALK,  0.0000000674754255536633839_REALK,  &
    0.0000000601242980839836992_REALK,  0.0000000541154397753368653_REALK,  &
    0.0000000491287137427060702_REALK,  0.0000000449347862366521807_REALK,  &
    0.0000000413659355038316120_REALK,  0.0000000382971949466159418_REALK,  &
    0.0000000356338773505730440_REALK,  0.0000000333031393470707428_REALK,  &
    0.0000000312481633365486548_REALK,  0.0000000294240711377886847_REALK,  &
    0.0000000277950056845854085_REALK,                                      &
    0.2377045430576376350284562_REALK,  0.0085504900746863204963333_REALK,  &
    0.0009226816993777361280982_REALK,  0.0001659168890478699115009_REALK,  &
    0.0000417445770495392543681_REALK,  0.0000134813745355379614862_REALK,  &
    0.0000053012999472309209640_REALK,  0.0000024459682718023029962_REALK,  &
    0.0000012867101697531144004_REALK,  0.0000007537802707879493194_REALK,  &
    0.0000004821166829882401817_REALK,  0.0000003311319778724850691_REALK,  &
    0.0000002409012278118417431_REALK,  0.0000001835809114171968164_REALK,  &
    0.0000001452411241138982406_REALK,  0.0000001184536417771621303_REALK,  &
    0.0000000990317099710088182_REALK,  0.0000000844987435663782700_REALK,  &
    0.0000000733264268678171913_REALK,  0.0000000645358430291827493_REALK,  &
    0.0000000574790115194303701_REALK,  0.0000000517143206618233619_REALK,  &
    0.0000000469328931856274190_REALK,  0.0000000429136271746505438_REALK,  &
    0.0000000394949323493021091_REALK,  0.0000000365564865905715103_REALK,  &
    0.0000000340071747561568840_REALK,  0.0000000317769389992219847_REALK,  &
    0.0000000298111614050094619_REALK,  0.0000000280667209419987137_REALK,  &
    0.0000000265091790532361003_REALK,                                      &
    0.2372781684602616458779067_REALK,  0.0085045625196470773371482_REALK,  &
    0.0009144377561588901007564_REALK,  0.0001638464021034498373838_REALK,  &
    0.0000410770843231522746154_REALK,  0.0000132193403871028762532_REALK,  &
    0.0000051805943422914496550_REALK,  0.0000023825650301644695023_REALK,  &
    0.0000012496169657443328404_REALK,  0.0000007300833802671503424_REALK,  &
    0.0000004658574235439320402_REALK,  0.0000003193133973556421944_REALK,  &
    0.0000002319012914329613707_REALK,  0.0000001764648809184185286_REALK,  &
    0.0000001394404902006124088_REALK,  0.0000001136061687318144094_REALK,  &
    0.0000000948971011643766316_REALK,  0.0000000809119078933422869_REALK,  &
    0.0000000701704182102814414_REALK,  0.0000000617255686587905562_REALK,  &
    0.0000000549510777595938766_REALK,  0.0000000494205046574626230_REALK,  &
    0.0000000448358276727859348_REALK,  0.0000000409838758808322169_REALK,  &
    0.0000000377089626594608080_REALK,  0.0000000348952352011985893_REALK,  &
    0.0000000324550138731527328_REALK,  0.0000000303209185332234110_REALK,  &
    0.0000000284404448432674105_REALK,  0.0000000267721594217228359_REALK,  &
    0.0000000252829855799818032_REALK,                                      &
    0.2368540799786706674279202_REALK,  0.0084590445874982694157707_REALK,  &
    0.0009062965083491324397649_REALK,  0.0001618089647509485555152_REALK,  &
    0.0000404225437334834294457_REALK,  0.0000129632630315088316246_REALK,  &
    0.0000050630130224104845233_REALK,  0.0000023209871632940267473_REALK,  &
    0.0000012136885260823868821_REALK,  0.0000007071848651534647172_REALK,  &
    0.0000004501779899575808411_REALK,  0.0000003079360382144870238_REALK,  &
    0.0000002232500057082017679_REALK,  0.0000001696329079857664366_REALK,  &
    0.0000001338771355897172965_REALK,  0.0000001089610076070809584_REALK,  &
    0.0000000909379470255690227_REALK,  0.0000000774794118835787235_REALK,  &
    0.0000000671518106007753666_REALK,  0.0000000590388668973260716_REALK,  &
    0.0000000525352532104335019_REALK,  0.0000000472291665187216192_REALK,  &
    0.0000000428330514714809420_REALK,  0.0000000391413784683242395_REALK,  &
    0.0000000360041453181311680_REALK,  0.0000000333098000530315558_REALK,  &
    0.0000000309739672714651486_REALK,  0.0000000289318409387179698_REALK,  &
    0.0000000271329475902119043_REALK,  0.0000000255374747692315693_REALK,  &
    0.0000000241136532957537647_REALK,                                      &
    0.2364322572594041438343027_REALK,  0.0084139311845131386363716_REALK,  &
    0.0008982563195357468749380_REALK,  0.0001598039367649041464763_REALK,  &
    0.0000397806613085195775992_REALK,  0.0000127129885121618297960_REALK,  &
    0.0000049484661583221143340_REALK,  0.0000022611774189771809159_REALK,  &
    0.0000011788856476771890528_REALK,  0.0000006850562784905161637_REALK,  &
    0.0000004350567511171212037_REALK,  0.0000002969828180971829568_REALK,  &
    0.0000002149334601888438622_REALK,  0.0000001630733779285547448_REALK,  &
    0.0000001285411608235686630_REALK,  0.0000001045095757635159827_REALK,  &
    0.0000000871466997772342952_REALK,  0.0000000741945376412811120_REALK,  &
    0.0000000642645634347398617_REALK,  0.0000000564702584397388535_REALK,  &
    0.0000000502265300434554168_REALK,  0.0000000451356991762620982_REALK,  &
    0.0000000409203017669237460_REALK,  0.0000000373821706257247826_REALK,  &
    0.0000000343767770277709834_REALK,  0.0000000317967078089711108_REALK,  &
    0.0000000295607655988894609_REALK,  0.0000000276066189257092660_REALK,  &
    0.0000000258857457646019499_REALK,  0.0000000243598905214795752_REALK,  &
    0.0000000229985393536866688_REALK,                                      &
    0.2360126802016557501229244_REALK,  0.0083692172979913659336404_REALK,  &
    0.0008903155849530098881611_REALK,  0.0001578306924278664261779_REALK,  &
    0.0000391511506629733471870_REALK,  0.0000124683672931753067743_REALK,  &
    0.0000048368667349543232665_REALK,  0.0000022030804700421909385_REALK,  &
    0.0000011451705230998738348_REALK,  0.0000006636702338113984940_REALK,  &
    0.0000004204729128794378678_REALK,  0.0000002864373358599921114_REALK,  &
    0.0000002069383129632411461_REALK,  0.0000001567751604561919051_REALK,  &
    0.0000001234230862801673180_REALK,  0.0000001002436596776051701_REALK,  &
    0.0000000835161400989124807_REALK,  0.0000000710508625548824770_REALK,  &
    0.0000000615029039079605669_REALK,  0.0000000540145087013517106_REALK,  &
    0.0000000480201255367482807_REALK,  0.0000000431357038223495382_REALK,  &
    0.0000000390935094022908916_REALK,  0.0000000357024689321519644_REALK,  &
    0.0000000328233241345642858_REALK,  0.0000000303526448006118819_REALK,  &
    0.0000000282122902700273484_REALK,  0.0000000263423079820938666_REALK,  &
    0.0000000246960510566934418_REALK,  0.0000000232367592558539788_REALK,  &
    0.0000000219351240028007019_REALK,                                      &
    0.2355953289532612127121780_REALK,  0.0083248979946947011115954_REALK,  &
    0.0008824727307661817555379_REALK,  0.0001558886201565282852207_REALK,  &
    0.0000385337327807257589546_REALK,  0.0000122292541210379105191_REALK,  &
    0.0000047281304568995769817_REALK,  0.0000021466428458846486289_REALK,  &
    0.0000011125066885904868412_REALK,  0.0000006430003641300113757_REALK,  &
    0.0000004064064847106453450_REALK,  0.0000002762838437372647834_REALK,  &
    0.0000001992517669539976323_REALK,  0.0000001507275891410244108_REALK,  &
    0.0000001185138341218627410_REALK,  0.0000000961553988825119455_REALK,  &
    0.0000000800393626925406186_REALK,  0.0000000680422462082994841_REALK,  &
    0.0000000588613150576521375_REALK,  0.0000000516666168188750429_REALK,  &
    0.0000000459114719002533785_REALK,  0.0000000412249804505808245_REALK,  &
    0.0000000373487900429684379_REALK,  0.0000000340986625715417855_REALK,  &
    0.0000000313404148305124507_REALK,  0.0000000289744496655890860_REALK,  &
    0.0000000269255664942077354_REALK,  0.0000000251360997538532708_REALK,  &
    0.0000000235612044276672367_REALK,  0.0000000221655565801433696_REALK,  &
    0.0000000209210048434454985_REALK,                                      &
    0.2351801839067634014579511_REALK,  0.0082809684193179220607073_REALK,  &
    0.0008747262133739214370540_REALK,  0.0001539771221385637144444_REALK,  &
    0.0000379281358040686064300_REALK,  0.0000119955078909232313954_REALK,  &
    0.0000046221756572449963156_REALK,  0.0000020918128665418066451_REALK,  &
    0.0000010808589740749811985_REALK,  0.0000006230212825660934215_REALK,  &
    0.0000003928382476886668065_REALK,  0.0000002665072206712810713_REALK,  &
    0.0000001918615472197827877_REALK,  0.0000001449204417639767759_REALK,  &
    0.0000001138047110292149368_REALK,  0.0000000922372706144227783_REALK,  &
    0.0000000767097624876578453_REALK,  0.0000000651628178765864930_REALK,  &
    0.0000000563345243409481403_REALK,  0.0000000494218051485015696_REALK,  &
    0.0000000438962065631665749_REALK,  0.0000000393995188271900232_REALK,  &
    0.0000000356824357454767652_REALK,  0.0000000325673054277755581_REALK,  &
    0.0000000299248317150640038_REALK,  0.0000000276591063253707896_REALK,  &
    0.0000000256977566266286294_REALK,  0.0000000239853157328765969_REALK,  &
    0.0000000224786701024859471_REALK,  0.0000000211438754029595172_REALK,  &
    0.0000000199538913513021168_REALK,                                      &
    0.2347672256955534997313606_REALK,  0.0082374237929942421138074_REALK,  &
    0.0008670745187286016441089_REALK,  0.0001520956139798394497580_REALK,  &
    0.0000373340948295190189188_REALK,  0.0000117669915174767319440_REALK,  &
    0.0000045189232096371871673_REALK,  0.0000020385405792175167616_REALK,  &
    0.0000010501934551115271295_REALK,  0.0000006037085445372541618_REALK,  &
    0.0000003797497238113546458_REALK,  0.0000002570929467527800714_REALK,  &
    0.0000001847558792185869648_REALK,  0.0000001393439215045769028_REALK,  &
    0.0000001092873916855911609_REALK,  0.0000000884820751332605092_REALK,  &
    0.0000000735210214577845783_REALK,  0.0000000624069645797420386_REALK,  &
    0.0000000539174927265536844_REALK,  0.0000000472755092385357590_REALK,  &
    0.0000000419701629024092184_REALK,  0.0000000376554898741951787_REALK,  &
    0.0000000340909069124971728_REALK,  0.0000000311051085430930554_REALK,  &
    0.0000000285735046996892424_REALK,  0.0000000264037372877396117_REALK,  &
    0.0000000245261538277364381_REALK,  0.0000000228874012380987484_REALK,  &
    0.0000000214460298424990859_REALK,  0.0000000201694204715157182_REALK,  &
    0.0000000190315996573761451_REALK,                                      &
    0.2343564351900854492161130_REALK,  0.0081942594118342426678936_REALK,  &
    0.0008595161616740067036385_REALK,  0.0001502435243616749213896_REALK,  &
    0.0000367513517099857348362_REALK,  0.0000115435718099209641194_REALK,  &
    0.0000044182964434614877154_REALK,  0.0000019867776971631915553_REALK,  &
    0.0000010204774066893645438_REALK,  0.0000005850386114540959449_REALK,  &
    0.0000003671231465557961778_REALK,  0.0000002480270787251632958_REALK,  &
    0.0000001779234679911438484_REALK,  0.0000001339886389386899126_REALK,  &
    0.0000001049539029794595902_REALK,  0.0000000848829216878427508_REALK,  &
    0.0000000704670960206665939_REALK,  0.0000000597693196695785421_REALK,  &
    0.0000000516054042763360694_REALK,  0.0000000452233682549782043_REALK,  &
    0.0000000401293613920311348_REALK,  0.0000000359892374454973872_REALK,  &
    0.0000000325708246162358759_REALK,  0.0000000297089329230266552_REALK,  &
    0.0000000272835042395171728_REALK,  0.0000000252055972588923097_REALK,  &
    0.0000000234081760164837013_REALK,  0.0000000218399196762790490_REALK,  &
    0.0000000204609774847309554_REALK,  0.0000000192400031642514872_REALK,  &
    0.0000000181520475719860674_REALK,                                      &
    0.2339477934941630865584017_REALK,  0.0081514706454975088129045_REALK,  &
    0.0008520496852999272794152_REALK,  0.0001484202947078405883646_REALK,  &
    0.0000361796548630756998320_REALK,  0.0000113251193513264776221_REALK,  &
    0.0000043202210620202052398_REALK,  0.0000019364775408240879462_REALK,  &
    0.0000009916792588066194222_REALK,  0.0000005669888158571842265_REALK,  &
    0.0000003549414326367652573_REALK,  0.0000002392962265073424541_REALK,  &
    0.0000001713534782250014640_REALK,  0.0000001288455948088391968_REALK,  &
    0.0000001007966088929371368_REALK,  0.0000000814332150969985316_REALK,  &
    0.0000000675422049963625752_REALK,  0.0000000572447519257358316_REALK,  &
    0.0000000493936561947536219_REALK,  0.0000000432612158395313175_REALK,  &
    0.0000000383700011543683491_REALK,  0.0000000343972704779709780_REALK,  &
    0.0000000311189632732196030_REALK,  0.0000000283757826719007514_REALK,  &
    0.0000000260520348769334699_REALK,  0.0000000240620670508158016_REALK,  &
    0.0000000223413601038414023_REALK,  0.0000000208405470694165162_REALK,  &
    0.0000000195213137354212393_REALK,  0.0000000183535365263990089_REALK,  &
    0.0000000173132498413308183_REALK,                                      &
    0.2335412819412978069344433_REALK,  0.0081090529357961283613010_REALK,  &
    0.0008446736603131637342867_REALK,  0.0001466253788609913255494_REALK,  &
    0.0000356187590853357502387_REALK,  0.0000111115083819011202949_REALK,  &
    0.0000042246250635987101337_REALK,  0.0000018875949811636730695_REALK,  &
    0.0000009637685537564456841_REALK,  0.0000005495373279371568039_REALK,  &
    0.0000003431881549144625056_REALK,  0.0000002308875306921615606_REALK,  &
    0.0000001650355151614674395_REALK,  0.0000001239061635335842033_REALK,  &
    0.0000000968081960464341463_REALK,  0.0000000781266429193450437_REALK,  &
    0.0000000647408180982719539_REALK,  0.0000000548283551379687601_REALK,  &
    0.0000000472778493249817957_REALK,  0.0000000413850713803771807_REALK,  &
    0.0000000366884518946264900_REALK,  0.0000000328762555003551018_REALK,  &
    0.0000000297322436543684668_REALK,  0.0000000271027984436501222_REALK,  &
    0.0000000248764290827115745_REALK,  0.0000000229706477702577363_REALK,  &
    0.0000000213233564935301386_REALK,  0.0000000198870668363763257_REALK,  &
    0.0000000186249412059461522_REALK,  0.0000000175080305371336880_REALK,  &
    0.0000000165133136257444458_REALK,                                      &
    0.2331368820911348116453610_REALK,  0.0080670017953292250806330_REALK,  &
    0.0008373866844244809252984_REALK,  0.0001448582427682429689311_REALK,  &
    0.0000350684253722324703988_REALK,  0.0000109026166861560456887_REALK,  &
    0.0000041314386653125974265_REALK,  0.0000018400863850823991772_REALK,  &
    0.0000009367159050537563714_REALK,  0.0000005326631233817104804_REALK,  &
    0.0000003318475164038085441_REALK,  0.0000002227886409791540613_REALK,  &
    0.0000001589596063092775260_REALK,  0.0000001191620774238583771_REALK,  &
    0.0000000929816598706478277_REALK,  0.0000000749571631856875650_REALK,  &
    0.0000000620576449333524516_REALK,  0.0000000525154381528786322_REALK,  &
    0.0000000452537790715690448_REALK,  0.0000000395911316770113712_REALK,  &
    0.0000000350812462014194459_REALK,  0.0000000314230094835906732_REALK,  &
    0.0000000284077262149469426_REALK,  0.0000000258872511934322119_REALK,  &
    0.0000000237541413809301460_REALK,  0.0000000219289552762342387_REALK,  &
    0.0000000203519238375608602_REALK,  0.0000000189773648168962912_REALK,  &
    0.0000000177698596798229568_REALK,  0.0000000167015875974902882_REALK,  &
    0.0000000157504341892564308_REALK,                                      &
    0.2327345757259479397394131_REALK,  0.0080253128061477715243788_REALK,  &
    0.0008301873817510602594077_REALK,  0.0001431183641756115089254_REALK,  &
    0.0000345284207436797498775_REALK,  0.0000106983254838120622694_REALK,  &
    0.0000040405942296332689767_REALK,  0.0000017939095628505039298_REALK,  &
    0.0000009104929579375747096_REALK,  0.0000005163459524955477002_REALK,  &
    0.0000003209043253395696195_REALK,  0.0000002149876955021750744_REALK,  &
    0.0000001531161839304187433_REALK,  0.0000001146054115756057473_REALK,  &
    0.0000000893102913783954856_REALK,  0.0000000719189926691582065_REALK,  &
    0.0000000594876244888280233_REALK,  0.0000000503015153642559744_REALK,  &
    0.0000000433174267303823823_REALK,  0.0000000378757629812505701_REALK,  &
    0.0000000335450721965819972_REALK,  0.0000000300344930169645524_REALK,  &
    0.0000000271426047297097286_REALK,  0.0000000247265362161742444_REALK,  &
    0.0000000226827427445620934_REALK,  0.0000000209347148936437178_REALK,  &
    0.0000000194249240347561003_REALK,  0.0000000181094245266960283_REALK,  &
    0.0000000169541616000139026_REALK,  0.0000000159323982287202911_REALK,  &
    0.0000000150228907905729500_REALK,                                      &
    0.2323343448471991701254069_REALK,  0.0079839816184488782840889_REALK,  &
    0.0008230744022340144615615_REALK,  0.0001414052323310398425176_REALK,  &
    0.0000339985180749301124409_REALK,  0.0000104985193243147173682_REALK,  &
    0.0000039520261934930969079_REALK,  0.0000017490237174775784154_REALK,  &
    0.0000008850723513866302818_REALK,  0.0000005005663105415801577_REALK,  &
    0.0000003103439712535151779_REALK,  0.0000002074733010141267106_REALK,  &
    0.0000001474960682650236071_REALK,  0.0000001102285694093765544_REALK,  &
    0.0000000857876645099805504_REALK,  0.0000000690065956693023967_REALK,  &
    0.0000000570259150836989055_REALK,  0.0000000481822976271241620_REALK,  &
    0.0000000414649512074450147_REALK,  0.0000000362354933973446195_REALK,  &
    0.0000000320767665183402320_REALK,  0.0000000287078037951620506_REALK,  &
    0.0000000259342002192175564_REALK,  0.0000000236181674588337014_REALK,  &
    0.0000000216599152492252696_REALK,  0.0000000199857563711105413_REALK,  &
    0.0000000185403174609583816_REALK,  0.0000000172813226329230238_REALK,  &
    0.0000000161760277662557204_REALK,  0.0000000151987369712655238_REALK,  &
    0.0000000143290427660459986_REALK,                                      &
    0.2319361716721636823557162_REALK,  0.0079430039492988657734429_REALK,  &
    0.0008160464210705412405056_REALK,  0.0001397183476957505475664_REALK,  &
    0.0000334784959326528546732_REALK,  0.0000103030859848316860443_REALK,  &
    0.0000038656709998752785738_REALK,  0.0000017053893959448023361_REALK,  &
    0.0000008604276815884119654_REALK,  0.0000004853054092538561631_REALK,  &
    0.0000003001524020216736432_REALK,  0.0000002002345138926284392_REALK,  &
    0.0000001420904514637004498_REALK,  0.0000001060242688288394370_REALK,  &
    0.0000000824076240269957656_REALK,  0.0000000662146732874131345_REALK,  &
    0.0000000546678847643636496_REALK,  0.0000000461536835764927141_REALK,  &
    0.0000000396926811091390680_REALK,  0.0000000346670056249227770_REALK,  &
    0.0000000306733076226570178_REALK,  0.0000000274401704020049775_REALK,  &
    0.0000000247799551539660157_REALK,  0.0000000225597720937696591_REALK,  &
    0.0000000206834469731769920_REALK,  0.0000000190800090717565573_REALK,  &
    0.0000000176961584201769561_REALK,  0.0000000164912246396912665_REALK,  &
    0.0000000154337232326241577_REALK,  0.0000000144989584749714069_REALK,  &
    0.0000000136673257956480974_REALK,                                      &
    0.2315400386306177837880682_REALK,  0.0079023755813843587353373_REALK,  &
    0.0008091021381603077586298_REALK,  0.0001380572216636681028273_REALK,  &
    0.0000329681384160277512791_REALK,  0.0000101119163716104497639_REALK,  &
    0.0000037814670317969776101_REALK,  0.0000016629684422285734099_REALK,  &
    0.0000008365334668042689141_REALK,  0.0000004705451494747119592_REALK,  &
    0.0000002903161018415019937_REALK,  0.0000001932608219320146628_REALK,  &
    0.0000001368908821970245488_REALK,  0.0000001019855289714027081_REALK,  &
    0.0000000791642739305242877_REALK,  0.0000000635381531713887081_REALK,  &
    0.0000000524091021245576730_REALK,  0.0000000442117513326577466_REALK,  &
    0.0000000379971071870145288_REALK,  0.0000000331671300292156257_REALK,  &
    0.0000000293318093882557555_REALK,  0.0000000262289463773026493_REALK,  &
    0.0000000236774279235664517_REALK,  0.0000000215490853411937027_REALK,  &
    0.0000000197512271321701729_REALK,  0.0000000182154973861036943_REALK,  &
    0.0000000168905908064079638_REALK,  0.0000000157373807739287026_REALK,  &
    0.0000000147255933959923100_REALK,  0.0000000138314937716050900_REALK,  &
    0.0000000130362483433851829_REALK,                                      &
    0.2311459283615883708584704_REALK,  0.0078620923617907061131671_REALK,  &
    0.0008022402775656643173635_REALK,  0.0001364213762886644398017_REALK,  &
    0.0000324672350026892369591_REALK,  0.0000099249044245787695667_REALK,  &
    0.0000036993545485979285805_REALK,  0.0000016217239520471343476_REALK,  &
    0.0000008133651135754995861_REALK,  0.0000004562680948706178550_REALK,  &
    0.0000002808220701004902293_REALK,  0.0000001865421268885364872_REALK,  &
    0.0000001318892509132319909_REALK,  0.0000000981056575252879637_REALK,  &
    0.0000000760519663807981478_REALK,  0.0000000609721797093808148_REALK,  &
    0.0000000502453275307304027_REALK,  0.0000000423527505757406178_REALK,  &
    0.0000000363748751212111456_REALK,  0.0000000317328380237241802_REALK,  &
    0.0000000280495150114935495_REALK,  0.0000000250716045538744676_REALK,  &
    0.0000000226242875588189525_REALK,  0.0000000205839455292356814_REALK,  &
    0.0000000188612414383247106_REALK,  0.0000000173903363568234057_REALK,  &
    0.0000000161218439663487809_REALK,  0.0000000150181220622163187_REALK,  &
    0.0000000140500602664823151_REALK,  0.0000000131948467211616995_REALK,  &
    0.0000000124343882639873342_REALK,                                      &
    0.2307538237101630640424332_REALK,  0.0078221502008070670913797_REALK,  &
    0.0007954595869853103894467_REALK,  0.0001348103440193899795613_REALK,  &
    0.0000319755803993620869407_REALK,  0.0000097419470250749391960_REALK,  &
    0.0000036192756244500407828_REALK,  0.0000015816202292644892480_REALK,  &
    0.0000007908988842176011724_REALK,  0.0000004424574466830886145_REALK,  &
    0.0000002716578010993416676_REALK,  0.0000001800687277470534249_REALK,  &
    0.0000001270777757164110957_REALK,  0.0000000943782385885479820_REALK,  &
    0.0000000730652910963625804_REALK,  0.0000000585121046524206771_REALK,  &
    0.0000000481725047348114956_REALK,  0.0000000405730949729037362_REALK,  &
    0.0000000348227786272388317_REALK,  0.0000000303612357511774267_REALK,  &
    0.0000000268237911778917871_REALK,  0.0000000239657316523885426_REALK,  &
    0.0000000216183086950712240_REALK,  0.0000000196622893806813496_REALK,  &
    0.0000000180115676726749841_REALK,  0.0000000166027275055249683_REALK,  &
    0.0000000153882287536834100_REALK,  0.0000000143318565897328170_REALK,  &
    0.0000000134056189114307977_REALK,  0.0000000125875906238451373_REALK,  &
    0.0000000118603895680937728_REALK,                                      &
    0.2303637077243592401476491_REALK,  0.0077825450707574746200823_REALK,  &
    0.0007887588372410282147248_REALK,  0.0001332236674414578642307_REALK,  &
    0.0000314929743970343412984_REALK,  0.0000095629439065986644454_REALK,  &
    0.0000035411740890066483626_REALK,  0.0000015426227438884425646_REALK,  &
    0.0000007691118655519633276_REALK,  0.0000004290970194727990577_REALK,  &
    0.0000002628112645944140410_REALK,  0.0000001738313046788570777_REALK,  &
    0.0000001224489888386889279_REALK,  0.0000000907971210465775390_REALK,  &
    0.0000000701990652117931270_REALK,  0.0000000561534781470762269_REALK,  &
    0.0000000461867528571229119_REALK,  0.0000000388693549424502054_REALK,  &
    0.0000000333377528715285354_REALK,  0.0000000290495580492577619_REALK,  &
    0.0000000256521224977203677_REALK,  0.0000000229090231222300316_REALK,  &
    0.0000000206573667657892380_REALK,  0.0000000187821475159456779_REALK,  &
    0.0000000172003714615174001_REALK,  0.0000000158509548522242693_REALK,  &
    0.0000000146881337660439697_REALK,  0.0000000136770659328312122_REALK,  &
    0.0000000127908340647701745_REALK,  0.0000000120083649899783872_REALK,  &
    0.0000000113129593385203258_REALK,                                      &
    0.2299755636520512958043128_REALK,  0.0077432730048572519232497_REALK,  &
    0.0007821368217771336537464_REALK,  0.0001316608990267602600967_REALK,  &
    0.0000310192217305196149936_REALK,  0.0000093877975684776907955_REALK,  &
    0.0000034649954701133166466_REALK,  0.0000015046980916021569176_REALK,  &
    0.0000007479819388263732783_REALK,  0.0000004161712178168108327_REALK,  &
    0.0000002542708871256007466_REALK,  0.0000001678209036615674038_REALK,  &
    0.0000001179957236810432566_REALK,  0.0000000873564074456908554_REALK,  &
    0.0000000674483235738920359_REALK,  0.0000000538920401600610995_REALK,  &
    0.0000000442843587229906065_REALK,  0.0000000372382507397178955_REALK,  &
    0.0000000319168681818544581_REALK,  0.0000000277951626882002047_REALK,  &
    0.0000000245321061936277331_REALK,  0.0000000218992782171607874_REALK,  &
    0.0000000197394334157859394_REALK,  0.0000000179416401623336266_REALK,  &
    0.0000000164259022471585490_REALK,  0.0000000151333811185765125_REALK,  &
    0.0000000140200217561725478_REALK,  0.0000000130523017571744016_REALK,  &
    0.0000000122043368941259484_REALK,  0.0000000114558724604746477_REALK,  &
    0.0000000107908647905368557_REALK,                                      &
    0.2295893749379538106847320_REALK,  0.0077043300960941418775718_REALK,  &
    0.0007755923561722831514192_REALK,  0.0001301216008896988348114_REALK,  &
    0.0000305541319422651436221_REALK,  0.0000092164131923488521787_REALK,  &
    0.0000033906869385049297266_REALK,  0.0000014678139547709265694_REALK,  &
    0.0000007274877507776318872_REALK,  0.0000004036650139204451631_REALK,  &
    0.0000002460255340972478387_REALK,  0.0000001620289217332795517_REALK,  &
    0.0000001137111023984885866_REALK,  0.0000000840504433413335855_REALK,  &
    0.0000000648083094572326759_REALK,  0.0000000517237122774922631_REALK,  &
    0.0000000424617695373081726_REALK,  0.0000000356766458503585691_REALK,  &
    0.0000000305573240393320718_REALK,  0.0000000265955248679466664_REALK,  &
    0.0000000234614470288403611_REALK,  0.0000000209343952950329320_REALK,  &
    0.0000000188625721240249538_REALK,  0.0000000171389730600889542_REALK,  &
    0.0000000156864894440839947_REALK,  0.0000000144484441063642109_REALK,  &
    0.0000000133824262091977741_REALK,  0.0000000124561825737251731_REALK,  &
    0.0000000116448219182693282_REALK,  0.0000000109288758708343279_REALK,  &
    0.0000000102929304694213836_REALK,                                      &
    0.2292051252206605271855011_REALK,  0.0076657124961335334351054_REALK,  &
    0.0007691242776633024427757_REALK,  0.0001286053445501222447598_REALK,  &
    0.0000300975192502674747809_REALK,  0.0000090486985613561659626_REALK,  &
    0.0000033181972544167180203_REALK,  0.0000014319390648682079660_REALK,  &
    0.0000007076086857914779248_REALK,  0.0000003915639261069298043_REALK,  &
    0.0000002380644925810615493_REALK,  0.0000001564470928543267091_REALK,  &
    0.0000001095885240064077082_REALK,  0.0000000808738071004105031_REALK,  &
    0.0000000622744656807076105_REALK,  0.0000000496445898622938772_REALK,  &
    0.0000000407155858820466842_REALK,  0.0000000341815406772441543_REALK,  &
    0.0000000292564433393191219_REALK,  0.0000000254482319631062575_REALK,  &
    0.0000000224379524649907405_REALK,  0.0000000200123673313274710_REALK,  &
    0.0000000180249340263933181_REALK,  0.0000000163724335561797086_REALK,  &
    0.0000000149805387719907203_REALK,  0.0000000137946532431313882_REALK,  &
    0.0000000127739480783201528_REALK,  0.0000000118873906452522203_REALK,  &
    0.0000000111110440679250264_REALK,  0.0000000104261954519661724_REALK,  &
    0.0000000098180355788657988_REALK,                                      &
    0.2288227983297373424598220_REALK,  0.0076274164142472282434948_REALK,  &
    0.0007627314446807061023431_REALK,  0.0001271117107027676428402_REALK,  &
    0.0000296492024199623905906_REALK,  0.0000088845639819719890722_REALK,  &
    0.0000032474767160396674646_REALK,  0.0000013970431662671285869_REALK,  &
    0.0000006883248391168368025_REALK,  0.0000003798539981494799282_REALK,  &
    0.0000002303774548112764619_REALK,  0.0000001510674743511660006_REALK,  &
    0.0000001056216529858332049_REALK,  0.0000000778213001381333874_REALK,  &
    0.0000000598424261075927431_REALK,  0.0000000476509345539452205_REALK,  &
    0.0000000390425550223491907_REALK,  0.0000000327500665078563316_REALK,  &
    0.0000000280116669091052710_REALK,  0.0000000243509785045023033_REALK,  &
    0.0000000214595280391253783_REALK,  0.0000000191312776367438295_REALK,  &
    0.0000000172247539292718503_REALK,  0.0000000156403868771803127_REALK,  &
    0.0000000143065287575214539_REALK,  0.0000000131705862872245095_REALK,  &
    0.0000000121932526715538211_REALK,  0.0000000113446690363508627_REALK,  &
    0.0000000106018158832492390_REALK,  0.0000000099467061614456380_REALK,  &
    0.0000000093651114341156257_REALK,                                      &
    0.2284423782828682580881008_REALK,  0.0075894381162651151570553_REALK,  &
    0.0007564127363955834354101_REALK,  0.0001256402889930110502656_REALK,  &
    0.0000292090046399599024001_REALK,  0.0000087239222083506535457_REALK,  &
    0.0000031784771097532490480_REALK,  0.0000013630969813457760846_REALK,  &
    0.0000006696169910930981592_REALK,  0.0000003685217794119030316_REALK,  &
    0.0000002229545023435804594_REALK,  0.0000001458824339179670246_REALK,  &
    0.0000001018044083664072762_REALK,  0.0000000748879375706243501_REALK,  &
    0.0000000575080075123746173_REALK,  0.0000000457391670954978764_REALK,  &
    0.0000000374395645075096799_REALK,  0.0000000313794797496156778_REALK,  &
    0.0000000268205482708362014_REALK,  0.0000000233015613865967309_REALK,  &
    0.0000000205241729499295411_REALK,  0.0000000182892957695256811_REALK,  &
    0.0000000164603465051568485_REALK,  0.0000000149412725730123413_REALK,  &
    0.0000000136630073969167525_REALK,  0.0000000125748861848684680_REALK,  &
    0.0000000116390666825214526_REALK,  0.0000000108268188003074846_REALK,  &
    0.0000000101160048416122266_REALK,  0.0000000094893351391197112_REALK,  &
    0.0000000089331390340091613_REALK,                                      &
    0.2280638492830533436972473_REALK,  0.0075517739235492539057182_REALK,  &
    0.0007501670522775465924786_REALK,  0.0001241906777987376972634_REALK,  &
    0.0000287767534015003222147_REALK,  0.0000085666883691274438583_REALK,  &
    0.0000031111516620711183186_REALK,  0.0000013300721768566379337_REALK,  &
    0.0000006514665823508438380_REALK,  0.0000003575543057652405554_REALK,  &
    0.0000002157860908505129355_REALK,  0.0000001408846371525394775_REALK,  &
    0.0000000981309532666996214_REALK,  0.0000000720689392653446765_REALK,  &
    0.0000000552672017983520471_REALK,  0.0000000439058604734476874_REALK,  &
    0.0000000359036360537353052_REALK,  0.0000000300671564211647236_REALK,  &
    0.0000000256807486386322490_REALK,  0.0000000222978752905732319_REALK,  &
    0.0000000196299758436513731_REALK,  0.0000000174846736336299833_REALK,  &
    0.0000000157301026619869320_REALK,  0.0000000142736011236865314_REALK,  &
    0.0000000130485889721583525_REALK,  0.0000000120062580722414048_REALK,  &
    0.0000000111101753586165257_REALK,  0.0000000103326962964436327_REALK,  &
    0.0000000096525308096132828_REALK,  0.0000000090530592812540119_REALK,  &
    0.0000000085211467463544218_REALK,                                      &
    0.2276871957158571324608687_REALK,  0.0075144202119897642380697_REALK,  &
    0.0007439933116634334271666_REALK,  0.0001227624840181486688250_REALK,  &
    0.0000283522803815108204617_REALK,  0.0000084127798965786955264_REALK,  &
    0.0000030454549932377159883_REALK,  0.0000012979413315124572607_REALK,  &
    0.0000006338556899479868520_REALK,  0.0000003469390812492712713_REALK,  &
    0.0000002088630355271715252_REALK,  0.0000001360670356042159889_REALK,  &
    0.0000000945956848724129667_REALK,  0.0000000693597212721934428_REALK,  &
    0.0000000531161685507053838_REALK,  0.0000000421477333566866582_REALK,  &
    0.0000000344319196961859126_REALK,  0.0000000288105868881606414_REALK,  &
    0.0000000245900321393654716_REALK,  0.0000000213379083133224265_REALK,  &
    0.0000000187751107906505892_REALK,  0.0000000167157417542514819_REALK,  &
    0.0000000150324860782162280_REALK,  0.0000000136359507015469912_REALK,  &
    0.0000000124619510135263968_REALK,  0.0000000114634664158397920_REALK,  &
    0.0000000106054198001636919_REALK,  0.0000000098612106318752799_REALK,  &
    0.0000000092103636135409031_REALK,  0.0000000086369029276884023_REALK,  &
    0.0000000081282081013453764_REALK,                                      &
    0.2273124021467070321467219_REALK,  0.0074773734110220330811858_REALK,  &
    0.0007378904533364758324201_REALK,  0.0001213553228633271983137_REALK,  &
    0.0000279354213291466298673_REALK,  0.0000082621164580620674427_REALK,  &
    0.0000029813430724161173365_REALK,  0.0000012666779047426566549_REALK,  &
    0.0000006167670044048384652_REALK,  0.0000003366640604489964511_REALK,  &
    0.0000002021764970821767009_REALK,  0.0000001314228553122681474_REALK,  &
    0.0000000911932248338620415_REALK,  0.0000000667558876188747425_REALK,  &
    0.0000000510512279104230546_REALK,  0.0000000404616438213649081_REALK,  &
    0.0000000330216881983403442_REALK,  0.0000000276073708326469190_REALK,  &
    0.0000000235462612470359729_REALK,  0.0000000204197377930120636_REALK,  &
    0.0000000179578334439049181_REALK,  0.0000000159809057226098511_REALK,  &
    0.0000000143660298960349666_REALK,  0.0000000130269640818689602_REALK,  &
    0.0000000119018314018117891_REALK,  0.0000000109453322847376109_REALK,  &
    0.0000000101236943845016417_REALK,  0.0000000094113212219023617_REALK,  &
    0.0000000087885207227589659_REALK,  0.0000000082399356567266921_REALK,  &
    0.0000000077534396879645101_REALK,                                      &
    0.2269394533182401418880403_REALK,  0.0074406300026647002182623_REALK,  &
    0.0007318574351156509035302_REALK,  0.0001199688176593936031434_REALK,  &
    0.0000275260159557050837064_REALK,  0.0000081146198896588694812_REALK,  &
    0.0000029187731744097502848_REALK,  0.0000012362562065762812830_REALK,  &
    0.0000006001838076030831282_REALK,  0.0000003267176315574502622_REALK,  &
    0.0000001957179682898810342_REALK,  0.0000001269455858143384093_REALK,  &
    0.0000000879184100649049569_REALK,  0.0000000642532224548341116_REALK,  &
    0.0000000490688537550932552_REALK,  0.0000000388445833490989688_REALK,  &
    0.0000000316703317072749210_REALK,  0.0000000264552124455699416_REALK,  &
    0.0000000225473924211401881_REALK,  0.0000000195415263223608361_REALK,  &
    0.0000000171764773712095960_REALK,  0.0000000152786428022757883_REALK,  &
    0.0000000137293335654975113_REALK,  0.0000000124453456949904248_REALK,  &
    0.0000000113670256037496627_REALK,  0.0000000104507307486413225_REALK,  &
    0.0000000096639443091973718_REALK,  0.0000000089820354635173814_REALK,  &
    0.0000000083860650407632875_REALK,  0.0000000078612701827317645_REALK,  &
    0.0000000073959991485572608_REALK,                                      &
    0.2265683341476975865003141_REALK,  0.0074041865205779341593817_REALK,  &
    0.0007258932334549355290532_REALK,  0.0001186025996490817463165_REALK,  &
    0.0000271239078278037734431_REALK,  0.0000079702141319430526629_REALK,  &
    0.0000028577038378626463272_REALK,  0.0000012066513686090798009_REALK,  &
    0.0000005840899515150204027_REALK,  0.0000003170886000973456250_REALK,  &
    0.0000001894792610808168091_REALK,  0.0000001226289696052477622_REALK,  &
    0.0000000847662839262787032_REALK,  0.0000000618476825287710477_REALK,  &
    0.0000000471656671732107898_REALK,  0.0000000372936710864883710_REALK,  &
    0.0000000303753526439399025_REALK,  0.0000000253519158324653011_REALK,  &
    0.0000000215914719398604584_REALK,  0.0000000187015179411196854_REALK,  &
    0.0000000164294505531731789_REALK,  0.0000000146074986896577243_REALK,  &
    0.0000000131210598326376664_REALK,  0.0000000118898588134682513_REALK,  &
    0.0000000108563840345238153_REALK,  0.0000000099785883959183326_REALK,  &
    0.0000000092251632488647259_REALK,  0.0000000085724065167731047_REALK,  &
    0.0000000080021027988874942_REALK,  0.0000000075000603516341726_REALK,  &
    0.0000000070550832669885554_REALK,                                      &
    0.2261990297243658132320121_REALK,  0.0073680395491414960029708_REALK,  &
    0.0007199968430522023579710_REALK,  0.0001172563078025777680725_REALK,  &
    0.0000267289442637188677120_REALK,  0.0000078288251678043914390_REALK,  &
    0.0000027980948248851246671_REALK,  0.0000011778393160140608241_REALK,  &
    0.0000005684698377308130374_REALK,  0.0000003077661732752073541_REALK,  &
    0.0000001834524941483383514_REALK,  0.0000001184669920273664785_REALK,  &
    0.0000000817320877770188365_REALK,  0.0000000595353899853587331_REALK,  &
    0.0000000453384302192097479_REALK,  0.0000000358061483544668348_REALK,  &
    0.0000000291343608180297619_REALK,  0.0000000242953806228021326_REALK,  &
    0.0000000206766319193201240_REALK,  0.0000000178980344996707840_REALK,  &
    0.0000000157152320394854334_REALK,  0.0000000139660844216270867_REALK,  &
    0.0000000125399318649839474_REALK,  0.0000000113593228680562614_REALK,  &
    0.0000000103688095414881442_REALK,  0.0000000095278809660577217_REALK,  &
    0.0000000088063911203253482_REALK,  0.0000000081815311889996058_REALK,  &
    0.0000000076357815478836439_REALK,  0.0000000071554992297852648_REALK,  &
    0.0000000067299261460058014_REALK,                                      &
    0.2258315253070631301035576_REALK,  0.0073321857225521298515036_REALK,  &
    0.0007141672764674944409030_REALK,  0.0001159295886324646643805_REALK,  &
    0.0000263409762327821858564_REALK,  0.0000076903809622557949124_REALK,  &
    0.0000027399070820536534801_REALK,  0.0000011497967405563736101_REALK,  &
    0.0000005533083977527406354_REALK,  0.0000002987399449427076966_REALK,  &
    0.0000001776300810503329071_REALK,  0.0000001144538715745389630_REALK,  &
    0.0000000788112528783507772_REALK,  0.0000000573126254674537217_REALK,  &
    0.0000000435840399370149489_REALK,  0.0000000343793733965013796_REALK,  &
    0.0000000279450687574789016_REALK,  0.0000000232835977738832605_REALK,  &
    0.0000000198010865105431672_REALK,  0.0000000171294721860033752_REALK,  &
    0.0000000150323687562640463_REALK,  0.0000000133530734235595389_REALK,  &
    0.0000000119847305081774492_REALK,  0.0000000108526108865842187_REALK,  &
    0.0000000099032550035149994_REALK,  0.0000000090976310912678311_REALK,  &
    0.0000000084067119510863566_REALK,  0.0000000078085479170903741_REALK,  &
    0.0000000072862882428175625_REALK,  0.0000000068268172817986485_REALK,  &
    0.0000000064197974696405737_REALK,                                      &
    0.2254658063216710139897714_REALK,  0.0072966217239397992630479_REALK,  &
    0.0007084035637504271188877_REALK,  0.0001146220960136225909326_REALK,  &
    0.0000259598582577397968068_REALK,  0.0000075548114041572723542_REALK,  &
    0.0000026831027027356502775_REALK,  0.0000011225010745749212086_REALK,  &
    0.0000005385910740267128108_REALK,  0.0000002899998811409620795_REALK,  &
    0.0000001720047187857568833_REALK,  0.0000001105840505923140750_REALK,  &
    0.0000000759993926351079876_REALK,  0.0000000551758215106572146_REALK,  &
    0.0000000418995226404322654_REALK,  0.0000000330108163551502718_REALK,  &
    0.0000000268052872430829111_REALK,  0.0000000223146455606259757_REALK,  &
    0.0000000189631282661336164_REALK,  0.0000000163942982086910744_REALK,  &
    0.0000000143794724576232206_REALK,  0.0000000127671986913968782_REALK,  &
    0.0000000114542916676917330_REALK,  0.0000000103686470500886680_REALK,  &
    0.0000000094587210406398890_REALK,  0.0000000086869061421674675_REALK,  &
    0.0000000080252518463476725_REALK,  0.0000000074526348433021077_REALK,  &
    0.0000000069528474169331105_REALK,  0.0000000065132806332293989_REALK,  &
    0.0000000061240008466713932_REALK,                                      &
    0.2251018583587091614894860_REALK,  0.0072613442845023525376580_REALK,  &
    0.0007027047520764772257917_REALK,  0.0001133334910079395282294_REALK,  &
    0.0000255854483199779024114_REALK,  0.0000074220482497915974459_REALK,  &
    0.0000026276448906918057355_REALK,  0.0000010959304658945767343_REALK,  &
    0.0000005243038016824856009_REALK,  0.0000002815363062045373459_REALK,  &
    0.0000001665693768266003701_REALK,  0.0000001068521863579680970_REALK,  &
    0.0000000732922951603764673_REALK,  0.0000000531215562176713754_REALK,  &
    0.0000000402820284392107355_REALK,  0.0000000316980544669518742_REALK,  &
    0.0000000257129210391583841_REALK,  0.0000000213866857429233803_REALK,  &
    0.0000000181611246690557669_REALK,  0.0000000156910476288214673_REALK,  &
    0.0000000137552168149172554_REALK,  0.0000000122072501016132553_REALK,  &
    0.0000000109475038099281018_REALK,  0.0000000099064043608119125_REALK,  &
    0.0000000090342538289212897_REALK,  0.0000000082948161727597564_REALK,  &
    0.0000000076611770499724128_REALK,  0.0000000071130079802238848_REALK,  &
    0.0000000066347194403458115_REALK,  0.0000000062141894141324778_REALK,  &
    0.0000000058418722313619401_REALK,                                      &
    0.2247396671709533388927582_REALK,  0.0072263501826581198403399_REALK,  &
    0.0006970699053919147914968_REALK,  0.0001120634416936902230666_REALK,  &
    0.0000252176077675248543118_REALK,  0.0000072920250682287841338_REALK,  &
    0.0000025734979249102297536_REALK,  0.0000010700637536342286741_REALK,  &
    0.0000005104329909551429839_REALK,  0.0000002733398894028602572_REALK,  &
    0.0000001613172865866837850_REALK,  0.0000001032531425244977998_REALK,  &
    0.0000000706859161496774863_REALK,  0.0000000511465472004326908_REALK,  &
    0.0000000387288260001031458_REALK,  0.0000000304387674660613907_REALK,  &
    0.0000000246659648115569268_REALK,  0.0000000204979599026655082_REALK,  &
    0.0000000173935148162321665_REALK,  0.0000000150183203341514689_REALK,  &
    0.0000000131583346374092004_REALK,  0.0000000116720718432571834_REALK,  &
    0.0000000104633055772211555_REALK,  0.0000000094649024169284458_REALK,  &
    0.0000000086289430156641579_REALK,  0.0000000079205119600987596_REALK,  &
    0.0000000073136920950660269_REALK,  0.0000000067889194607723843_REALK,  &
    0.0000000063311988596143685_REALK,  0.0000000059288761797277983_REALK,  &
    0.0000000055727784178605816_REALK,                                      &
    0.2243792186710952818451403_REALK,  0.0071916362432160978179763_REALK,  &
    0.0006914981040671569359826_REALK,  0.0001108116229994482470657_REALK,  &
    0.0000248562012257416025708_REALK,  0.0000071646771884190645023_REALK,  &
    0.0000025206271256285298792_REALK,  0.0000010448804448772861509_REALK,  &
    0.0000004969655102615295758_REALK,  0.0000002654016320976421713_REALK,  &
    0.0000001562419313094754697_REALK,  0.0000000997819809134429045_REALK,  &
    0.0000000681763720515903687_REALK,  0.0000000492476457785318192_REALK,  &
    0.0000000372372975327177511_REALK,  0.0000000292307331874758997_REALK,  &
    0.0000000236624992247496913_REALK,  0.0000000196467859428578754_REALK,  &
    0.0000000166588062500150273_REALK,  0.0000000143747781490701110_REALK,  &
    0.0000000125876152184028079_REALK,  0.0000000111605599665048119_REALK,  &
    0.0000000100006835115428452_REALK,  0.0000000090432052890981975_REALK,  &
    0.0000000082419197303861087_REALK,  0.0000000075631831342742106_REALK,  &
    0.0000000069820380400132977_REALK,  0.0000000064796558692672883_REALK,  &
    0.0000000060416128144275141_REALK,  0.0000000056567044045767422_REALK,  &
    0.0000000053161156048225489_REALK,                                      &
    0.2240204989294434789748323_REALK,  0.0071571993365632255792996_REALK,  &
    0.0006859884445583116097805_REALK,  0.0001095777165423974359136_REALK,  &
    0.0000245010965106154153601_REALK,  0.0000070399416479558903580_REALK,  &
    0.0000024689988215014509736_REALK,  0.0000010203606921725077177_REALK,  &
    0.0000004838886699063336343_REALK,  0.0000002577128553957923206_REALK,  &
    0.0000001513370363578492373_REALK,  0.0000000964339536420275649_REALK,  &
    0.0000000657599335222767000_REALK,  0.0000000474218314229247501_REALK,  &
    0.0000000358049339904024161_REALK,  0.0000000280718233610957186_REALK,  &
    0.0000000227006872100508851_REALK,  0.0000000188315547416070473_REALK,  &
    0.0000000159555719308908531_REALK,  0.0000000137591420742360205_REALK,  &
    0.0000000120419018011447184_REALK,  0.0000000106716600424141611_REALK,  &
    0.0000000095586698819307925_REALK,  0.0000000086404194941698338_REALK,  &
    0.0000000078723546871120081_REALK,  0.0000000072220563945405995_REALK,  &
    0.0000000066654907860125600_REALK,  0.0000000061845366498176795_REALK,  &
    0.0000000057653195278148298_REALK,  0.0000000053970670468392587_REALK,  &
    0.0000000050713080269695126_REALK,                                      &
    0.2236634941716641178377500_REALK,  0.0071230363778683860112584_REALK,  &
    0.0006805400390767007371556_REALK,  0.0001083614104709155188423_REALK,  &
    0.0000241521645445748904719_REALK,  0.0000069177571434527739837_REALK,  &
    0.0000024185803178733634766_REALK,  0.0000009964852718342937266_REALK,  &
    0.0000004711902063935513386_REALK,  0.0000002502651882781361243_REALK,  &
    0.0000001465965598894169017_REALK,  0.0000000932044955707280480_REALK,  &
    0.0000000634330191519060805_REALK,  0.0000000456662064344188857_REALK,  &
    0.0000000344293304768285911_REALK,  0.0000000269599995882526004_REALK,  &
    0.0000000217787703974180804_REALK,  0.0000000180507269540731056_REALK,  &
    0.0000000152824473450850287_REALK,  0.0000000131701896500399196_REALK,  &
    0.0000000115200891590655862_REALK,  0.0000000102043649288150753_REALK,  &
    0.0000000091363406108965256_REALK,  0.0000000082556920615748904_REALK,  &
    0.0000000075194563737936800_REALK,  0.0000000068963938076114579_REALK,  &
    0.0000000063633594723339023_REALK,  0.0000000059029125884331797_REALK,  &
    0.0000000055017068664628491_REALK,  0.0000000051493851793465598_REALK,  &
    0.0000000048378066504635119_REALK,                                      &
    0.2233081907765618323580270_REALK,  0.0070891443263027690072087_REALK,  &
    0.0006751520152661491741899_REALK,  0.0001071623993113058785154_REALK,  &
    0.0000238092792747469899218_REALK,  0.0000067980639824797443993_REALK,  &
    0.0000023693398661163894238_REALK,  0.0000009732355630127664774_REALK,  &
    0.0000004588582673200181341_REALK,  0.0000002430505561850597594_REALK,  &
    0.0000001420146839017527378_REALK,  0.0000000900892170579645291_REALK,  &
    0.0000000611921894515003448_REALK,  0.0000000439779908468756459_REALK,  &
    0.0000000331081818493561957_REALK,  0.0000000258933094927111690_REALK,  &
    0.0000000208950657035912764_REALK,  0.0000000173028299557962836_REALK,  &
    0.0000000146381277410143439_REALK,  0.0000000126067524383049446_REALK,  &
    0.0000000110211212851735424_REALK,  0.0000000097577126374981103_REALK,  &
    0.0000000087328132952854622_REALK,  0.0000000078882086881561960_REALK,  &
    0.0000000071824693248385630_REALK,  0.0000000065854911843228703_REALK,  &
    0.0000000060749849456996195_REALK,  0.0000000056341643654335049_REALK,  &
    0.0000000052501909678705220_REALK,  0.0000000049131066843711064_REALK,  &
    0.0000000046150879291102239_REALK,                                      &
    0.2229545752738984754071083_REALK,  0.0070555201842761282315930_REALK,  &
    0.0006698235158878352180772_REALK,  0.0001059803838185564850167_REALK,  &
    0.0000234723175935792141577_REALK,  0.0000066808040370069860973_REALK,  &
    0.0000023212466339963508522_REALK,  0.0000009505935275050768261_REALK,  &
    0.0000004468813968286079924_REALK,  0.0000002360611700409555715_REALK,  &
    0.0000001375858056324688404_REALK,  0.0000000870838970091679515_REALK,  &
    0.0000000590341410892001593_REALK,  0.0000000423545175455020022_REALK,  &
    0.0000000318392785106461015_REALK,  0.0000000248698830384998207_REALK,  &
    0.0000000200479620696629936_REALK,  0.0000000165864549210992117_REALK,  &
    0.0000000140213654888083416_REALK,  0.0000000120677136168913513_REALK,  &
    0.0000000105439891856525472_REALK,  0.0000000093307842980892128_REALK,  &
    0.0000000083472453172687889_REALK,  0.0000000075371919773721533_REALK,  &
    0.0000000068606724729224056_REALK,  0.0000000062886765310463776_REALK,  &
    0.0000000057997383003550672_REALK,  0.0000000053777011748948775_REALK,  &
    0.0000000050102149312368419_REALK,  0.0000000046877050091251387_REALK,  &
    0.0000000044026526185520513_REALK,                                      &
    0.2226026343422500830548927_REALK,  0.0070221609966886608042436_REALK,  &
    0.0006645536985125072943978_REALK,  0.0001048150708310106177246_REALK,  &
    0.0000231411592617531257517_REALK,  0.0000065659206983052948264_REALK,  &
    0.0000022742706770302198225_REALK,  0.0000009285416902805242008_REALK,  &
    0.0000004352485215996094003_REALK,  0.0000002292895157000981664_REALK,  &
    0.0000001333045292997356583_REALK,  0.0000000841844762080190107_REALK,  &
    0.0000000569557013654319681_REALK,  0.0000000407932275910268372_REALK,  &
    0.0000000306205023803622428_REALK,  0.0000000238879290072635746_REALK,  &
    0.0000000192359173414804039_REALK,  0.0000000159002540305553719_REALK,  &
    0.0000000134309675573879074_REALK,  0.0000000115520056821169772_REALK,  &
    0.0000000100877287729436587_REALK,  0.0000000089227022142096437_REALK,  &
    0.0000000079788320413491004_REALK,  0.0000000072018997590051762_REALK,  &
    0.0000000065533775764352849_REALK,  0.0000000060053085724002170_REALK,  &
    0.0000000055370194855571170_REALK,  0.0000000051329594080214879_REALK,  &
    0.0000000047812475691148704_REALK,  0.0000000044726779791575645_REALK,  &
    0.0000000042000246457430291_REALK,                                      &
    0.2222523548069008092475940_REALK,  0.0069890638501980632130151_REALK,  &
    0.0006593417352198688470566_REALK,  0.0001036661731288360081826_REALK,  &
    0.0000228156868333173467472_REALK,  0.0000064533588332545850427_REALK,  &
    0.0000022283829108000041635_REALK,  0.0000009070631206930747690_REALK,  &
    0.0000004239489373596173038_REALK,  0.0000002227283437972706958_REALK,  &
    0.0000001291656581694294430_REALK,  0.0000000813870509181676565_REALK,  &
    0.0000000549538229169046750_REALK,  0.0000000392916657409536986_REALK,  &
    0.0000000294498230391656211_REALK,  0.0000000229457316281607581_REALK,  &
    0.0000000184574552865629562_REALK,  0.0000000152429378017700404_REALK,  &
    0.0000000128657931038259993_REALK,  0.0000000110586082541281640_REALK,  &
    0.0000000096514188537959171_REALK,  0.0000000085326280077152012_REALK,  &
    0.0000000076268050934423075_REALK,  0.0000000068816234856798029_REALK,  &
    0.0000000062599277190774025_REALK,  0.0000000057347753419657081_REALK,  &
    0.0000000052862559773571333_REALK,  0.0000000048994013974730074_REALK,  &
    0.0000000045627822170041212_REALK,  0.0000000042675466669478628_REALK,  &
    0.0000000040067500311207040_REALK,                                      &
    0.2219037236377727762004497_REALK,  0.0069562258725014503371598_REALK,  &
    0.0006541868123049480922976_REALK,  0.0001025334092961828453367_REALK,  &
    0.0000224957855829709049971_REALK,  0.0000063430647420134835920_REALK,  &
    0.0000021835550841893515227_REALK,  0.0000008861414143559119816_REALK,  &
    0.0000004129722958881095306_REALK,  0.0000002163706599871435584_REALK,  &
    0.0000001251641869356659799_REALK,  0.0000000786878667442320788_REALK,  &
    0.0000000530255786397916979_REALK,  0.0000000378474761594611331_REALK,  &
    0.0000000283252940375382188_REALK,  0.0000000220416473536246284_REALK,  &
    0.0000000177111627415165021_REALK,  0.0000000146132725379954999_REALK,  &
    0.0000000123247511699644760_REALK,  0.0000000105865459805862662_REALK,  &
    0.0000000092341792079900380_REALK,  0.0000000081597608470097245_REALK,  &
    0.0000000072904307182894483_REALK,  0.0000000065756867026659244_REALK,  &
    0.0000000059796958782857647_REALK,  0.0000000054764928378691371_REALK,  &
    0.0000000050469015117034638_REALK,  0.0000000046765142198213023_REALK,  &
    0.0000000043543355981878805_REALK,  0.0000000040718543131261361_REALK,  &
    0.0000000038223958610176072_REALK,                                      &
    0.2215567279473922013277587_REALK,  0.0069236442316317967082817_REALK,  &
    0.0006490881299912710329300_REALK,  0.0001014165035869261396019_REALK,  &
    0.0000221813434354301155333_REALK,  0.0000062349861170047424892_REALK,  &
    0.0000021397597535104032555_REALK,  0.0000008657606756536245194_REALK,  &
    0.0000004023085925026596672_REALK,  0.0000002102097155570610905_REALK,  &
    0.0000001212952944020281838_REALK,  0.0000000760833127413541527_REALK,  &
    0.0000000511681568228714602_REALK,  0.0000000364583983078914495_REALK,  &
    0.0000000272450493623066196_REALK,  0.0000000211741017746134507_REALK,  &
    0.0000000169956868841798828_REALK,  0.0000000140100778893335567_REALK,  &
    0.0000000118067984814819107_REALK,  0.0000000101348865342366346_REALK,  &
    0.0000000088351687536240365_REALK,  0.0000000078033357556039708_REALK,  &
    0.0000000069690082116159587_REALK,  0.0000000062834435876081850_REALK,  &
    0.0000000057120835593225657_REALK,  0.0000000052299037402359388_REALK,  &
    0.0000000048184348760241478_REALK,  0.0000000044638085534381246_REALK,  &
    0.0000000041554467412450757_REALK,  0.0000000038851652978657957_REALK,  &
    0.0000000036465493079633085_REALK,                                      &
    0.2212113549888894692418972_REALK,  0.0068913161352685357169401_REALK,  &
    0.0006440449021506580804669_REALK,  0.0001003151857938880506423_REALK,  &
    0.0000218722508968140803636_REALK,  0.0000061290720031726597089_REALK,  &
    0.0000020969702574895630162_REALK,  0.0000008459055008685368545_REALK,  &
    0.0000003919481540044785672_REALK,  0.0000002042389983984999107_REALK,  &
    0.0000001175543364513150060_REALK,  0.0000000735699157630319742_REALK,  &
    0.0000000493788564817896293_REALK,  0.0000000351222630081138109_REALK,  &
    0.0000000262073000540431776_REALK,  0.0000000203415866692511225_REALK,  &
    0.0000000163097326249998888_REALK,  0.0000000134322245215172668_REALK,  &
    0.0000000113109373448232227_REALK,  0.0000000097027387001298677_REALK,  &
    0.0000000084535837950397011_REALK,  0.0000000074626219972692392_REALK,  &
    0.0000000066618684236226311_REALK,  0.0000000060042775569698763_REALK,  &
    0.0000000054565194920028852_REALK,  0.0000000049944761876590670_REALK,  &
    0.0000000046003587565832600_REALK,  0.0000000042608175892405953_REALK,  &
    0.0000000039656759477864893_REALK,  0.0000000037070641601102588_REALK,  &
    0.0000000034788166966422712_REALK,                                      &
    0.2208675921540340092441568_REALK,  0.0068592388300620201271873_REALK,  &
    0.0006390563560294762338390_REALK,  0.0000992291911214425329055_REALK,  &
    0.0000215684009879865362202_REALK,  0.0000060252727594704214622_REALK,  &
    0.0000020551606930820942880_REALK,  0.0000008265609618986344092_REALK,  &
    0.0000003818816270667178221_REALK,  0.0000001984522243230746196_REALK,  &
    0.0000001139368392921496124_REALK,  0.0000000711443350373895192_REALK,  &
    0.0000000476550828859863036_REALK,  0.0000000338369886713806776_REALK,  &
    0.0000000252103309688224130_REALK,  0.0000000195426571790263111_REALK,  &
    0.0000000156520601123792718_REALK,  0.0000000128786318874942608_REALK,  &
    0.0000000108362136376118864_REALK,  0.0000000092892505484608478_REALK,  &
    0.0000000080886563496513642_REALK,  0.0000000071369215343014217_REALK,  &
    0.0000000063683723305515544_REALK,  0.0000000057375999361373021_REALK,  &
    0.0000000052124583871818243_REALK,  0.0000000047697026099600232_REALK,  &
    0.0000000043921986390297539_REALK,  0.0000000040670959918440175_REALK,  &
    0.0000000037846038080814883_REALK,  0.0000000035371546624051075_REALK,  &
    0.0000000033188226133758248_REALK,                                      &
    0.2205254269713022852172912_REALK,  0.0068274096009715073626878_REALK,  &
    0.0006341217319811769202037_REALK,  0.0000981582600614048291377_REALK,  &
    0.0000212696891797933247757_REALK,  0.0000059235400215365508289_REALK,  &
    0.0000020143058920864643986_REALK,  0.0000008077125905453491891_REALK,  &
    0.0000003720999670486373096_REALK,  0.0000001928433287095226014_REALK,  &
    0.0000001104384929712592599_REALK,  0.0000000688033569624517660_REALK,  &
    0.0000000459943432701900320_REALK,  0.0000000326005776856190428_REALK,  &
    0.0000000242524976780948272_REALK,  0.0000000187759291069812996_REALK,  &
    0.0000000150214823469710632_REALK,  0.0000000123482660972380270_REALK,  &
    0.0000000103817148883615655_REALK,  0.0000000088936076891679995_REALK,  &
    0.0000000077396525501021297_REALK,  0.0000000068255675555706376_REALK,  &
    0.0000000060879096712162321_REALK,  0.0000000054828486902624215_REALK,  &
    0.0000000049793797502501780_REALK,  0.0000000045550986146442824_REALK,  &
    0.0000000041935017596780440_REALK,  0.0000000038822189087828043_REALK,  &
    0.0000000036118302623468796_REALK,  0.0000000033750588992109642_REALK,  &
    0.0000000031662090570958569_REALK,                                      &
    0.2201848471039785370972908_REALK,  0.0067958257706163633857233_REALK,  &
    0.0006292402832049613127519_REALK,  0.0000971021382721130312757_REALK,  &
    0.0000209760133301372026816_REALK,  0.0000058238266655212713783_REALK,  &
    0.0000019743813985305036871_REALK,  0.0000007893463633503361616_REALK,  &
    0.0000003625944272194252991_REALK,  0.0000001874064584686595688_REALK,  &
    0.0000001070551451407058819_REALK,  0.0000000665438901113939397_REALK,  &
    0.0000000443942427227283854_REALK,  0.0000000314111129543996128_REALK,  &
    0.0000000233322235007139398_REALK,  0.0000000180400763325629881_REALK,  &
    0.0000000144168629001169570_REALK,  0.0000000118401378814258461_REALK,  &
    0.0000000099465684414889900_REALK,  0.0000000085150316046121165_REALK,  &
    0.0000000074058711183398529_REALK,  0.0000000065279230711812914_REALK,  &
    0.0000000058198976455288123_REALK,  0.0000000052394872130596934_REALK,  &
    0.0000000047567867490167998_REALK,  0.0000000043502019245730453_REALK,  &
    0.0000000040038361051716776_REALK,  0.0000000037057810255690857_REALK,  &
    0.0000000034469737055753513_REALK,  0.0000000032204164466706531_REALK,  &
    0.0000000030206346298737630_REALK,                                      &
    0.2198458403482878853463234_REALK,  0.0067644846986401746535833_REALK,  &
    0.0006244112754904102783465_REALK,  0.0000960605764606109745500_REALK,  &
    0.0000206872736228333079867_REALK,  0.0000057260867730247777167_REALK,  &
    0.0000019353634468024035162_REALK,  0.0000007714486869611327725_REALK,  &
    0.0000003533565483760786122_REALK,  0.0000001821359643138122990_REALK,  &
    0.0000001037827950697845376_REALK,  0.0000000643629604391089134_REALK,  &
    0.0000000428524802432328823_REALK,  0.0000000302667545811195564_REALK,  &
    0.0000000224479966614090342_REALK,  0.0000000173338283380438444_REALK,  &
    0.0000000138371137318437652_REALK,  0.0000000113533006448124409_REALK,  &
    0.0000000095299397038154671_REALK,  0.0000000081527780568226335_REALK,  &
    0.0000000070866419083583152_REALK,  0.0000000062433795707155749_REALK,  &
    0.0000000055637796721948261_REALK,  0.0000000050070031709024686_REALK,  &
    0.0000000045442051334763014_REALK,  0.0000000041545713644894396_REALK,  &
    0.0000000038227894582929576_REALK,  0.0000000035373956644643528_REALK,  &
    0.0000000032896701338801291_REALK,  0.0000000030728835518993545_REALK,  &
    0.0000000028817737651577646_REALK,                                      &
    0.2195083946315606604482440_REALK,  0.0067333837810875070764571_REALK,  &
    0.0006196339869679333466415_REALK,  0.0000950333302678456066492_REALK,  &
    0.0000204033725081907848327_REALK,  0.0000056302755971109642852_REALK,  &
    0.0000018972289405006434510_REALK,  0.0000007540063840064028002_REALK,  &
    0.0000003443781488403808494_REALK,  0.0000001770263933247498736_REALK,  &
    0.0000001006175878917367841_REALK,  0.0000000622577066818050555_REALK,  &
    0.0000000413668449626346199_REALK,  0.0000000291657366922158549_REALK,  &
    0.0000000215983675702515848_REALK,  0.0000000166559678416462145_REALK,  &
    0.0000000132811931040308878_REALK,  0.0000000108868486053187017_REALK,  &
    0.0000000091310304689119625_REALK,  0.0000000078061355659544379_REALK,  &
    0.0000000067813245144967477_REALK,  0.0000000059713557421698962_REALK,  &
    0.0000000053190242028735086_REALK,  0.0000000047849073996834493_REALK,  &
    0.0000000043411822050764636_REALK,  0.0000000039677858941448433_REALK,  &
    0.0000000036499684877839431_REALK,  0.0000000033766939249362267_REALK,  &
    0.0000000031395723304253569_REALK,  0.0000000029321323599574929_REALK,  &
    0.0000000027493159919590552_REALK,                                      &
    0.2191724980104277076264907_REALK,  0.0067025204497929780425580_REALK,  &
    0.0006149077078648817681894_REALK,  0.0000940201601567923532727_REALK,  &
    0.0000201242146452675015099_REALK,  0.0000055363495293611132594_REALK,  &
    0.0000018599554319777726774_REALK,  0.0000007370066794621396707_REALK,  &
    0.0000003356513148205816104_REALK,  0.0000001720724817936027757_REALK,  &
    0.0000000975558090758218884_REALK,  0.0000000602253759416875643_REALK,  &
    0.0000000399352125186464078_REALK,  0.0000000281063643934887890_REALK,  &
    0.0000000207819462178936403_REALK,  0.0000000160053285327167540_REALK,  &
    0.0000000127481035845609991_REALK,  0.0000000104399150150285405_REALK,  &
    0.0000000087490773158081537_REALK,  0.0000000074744239567530594_REALK,  &
    0.0000000064893069423330909_REALK,  0.0000000057112962488250999_REALK,  &
    0.0000000050851235902263633_REALK,  0.0000000045727328520217674_REALK,  &
    0.0000000041472858332093229_REALK,  0.0000000037894436858771608_REALK,  &
    0.0000000034849978801423929_REALK,  0.0000000032233238638675878_REALK,  &
    0.0000000029963490891022226_REALK,  0.0000000027978501767506528_REALK,  &
    0.0000000026229652333092822_REALK,                                      &
    0.2188381386690458341170995_REALK,  0.0066718921717823873734909_REALK,  &
    0.0006102317402671848236770_REALK,  0.0000930208313034276121399_REALK,  &
    0.0000198497068457467925608_REALK,  0.0000054442660679336170318_REALK,  &
    0.0000018235211025540041094_REALK,  0.0000007204371874909638257_REALK,  &
    0.0000003271683911239638251_REALK,  0.0000001672691483417360196_REALK,  &
    0.0000000945938791156872349_REALK,  0.0000000582633194491155723_REALK,  &
    0.0000000385555415802199649_REALK,  0.0000000270870108538737073_REALK,  &
    0.0000000199973996815898484_REALK,  0.0000000153807929045019593_REALK,  &
    0.0000000122368901384487250_REALK,  0.0000000100116704594621725_REALK,  &
    0.0000000083833500787420741_REALK,  0.0000000071569929699698980_REALK,  &
    0.0000000062100043393410056_REALK,  0.0000000054626705614188362_REALK,  &
    0.0000000048615930073953777_REALK,  0.0000000043700335925106525_REALK,  &
    0.0000000039621035167548346_REALK,  0.0000000036191612445898427_REALK,  &
    0.0000000033275195114523995_REALK,  0.0000000030769497136748284_REALK,  &
    0.0000000028596844741974507_REALK,  0.0000000026697387661831997_REALK,  &
    0.0000000025024391373892871_REALK,                                      &
    0.2185053049173531491966571_REALK,  0.0066414964486856443992568_REALK,  &
    0.0006056053978863673538033_REALK,  0.0000920351134904677514736_REALK,  &
    0.0000195797580193867954768_REALK,  0.0000053539837865967314872_REALK,  &
    0.0000017879047433773671692_REALK,  0.0000007042858987372978816_REALK,  &
    0.0000003189219722070150174_REALK,  0.0000001626114872969781347_REALK,  &
    0.0000000917283484253468102_REALK,  0.0000000563689884949425231_REALK,  &
    0.0000000372258705147417535_REALK,  0.0000000261061145112422191_REALK,  &
    0.0000000192434497372299883_REALK,  0.0000000147812901802733786_REALK,  &
    0.0000000117466383021216452_REALK,  0.0000000096013212316516121_REALK,  &
    0.0000000080331503847760682_REALK,  0.0000000068532209358067308_REALK,  &
    0.0000000059428577826074523_REALK,  0.0000000052249718431073635_REALK,  &
    0.0000000046479694165635083_REALK,  0.0000000041763838388049529_REALK,  &
    0.0000000037852414886066381_REALK,  0.0000000034565725681779451_REALK,  &
    0.0000000031771916573980895_REALK,  0.0000000029372511365782666_REALK,  &
    0.0000000027292771143808747_REALK,  0.0000000025475136799706147_REALK,  &
    0.0000000023874684398052183_REALK,                                      &
    0.2181739851893530202087135_REALK,  0.0066113308161611893110088_REALK,  &
    0.0006010280058318124424277_REALK,  0.0000910627810037969434229_REALK,  &
    0.0000193142791209943992666_REALK,  0.0000052654623047026132752_REALK,  &
    0.0000017530857369080418989_REALK,  0.0000006885411680618545795_REALK,  &
    0.0000003109048935504385103_REALK,  0.0000001580947623210335048_REALK,  &
    0.0000000889558924344329396_REALK,  0.0000000545399305260528508_REALK,  &
    0.0000000359443141919959870_REALK,  0.0000000251621763950469655_REALK,  &
    0.0000000185188705728157915_REALK,  0.0000000142057943287366306_REALK,  &
    0.0000000112764724371965515_REALK,  0.0000000092081077777010438_REALK,  &
    0.0000000076978102562482002_REALK,  0.0000000065625135066010876_REALK,  &
    0.0000000056873331210331038_REALK,  0.0000000049977158848184406_REALK,  &
    0.0000000044438105843589170_REALK,  0.0000000039913770464485449_REALK,  &
    0.0000000036163238612040296_REALK,  0.0000000033013283465349132_REALK,  &
    0.0000000030336882396948131_REALK,  0.0000000028039225133478057_REALK,  &
    0.0000000026048395294176682_REALK,  0.0000000024309036185895416_REALK,  &
    0.0000000022777963555586672_REALK,                                      &
    0.2178441680414270609222882_REALK,  0.0065813928433317023594662_REALK,  &
    0.0005964989003881387150466_REALK,  0.0000901036125315099304962_REALK,  &
    0.0000190531830988777635730_REALK,  0.0000051786622580720369330_REALK,  &
    0.0000017190440390053474845_REALK,  0.0000006731917026995197654_REALK,  &
    0.0000003031102233467487996_REALK,  0.0000001537144002773207750_REALK,  &
    0.0000000862733068747336172_REALK,  0.0000000527737853974016613_REALK,  &
    0.0000000347090609191790407_REALK,  0.0000000242537575608478563_REALK,  &
    0.0000000178224865990175629_REALK,  0.0000000136533221648367557_REALK,  &
    0.0000000108255540602577027_REALK,  0.0000000088313032106673035_REALK,  &
    0.0000000073766907751646444_REALK,  0.0000000062843024460930157_REALK,  &
    0.0000000054429198695533887_REALK,  0.0000000047804400887092528_REALK,  &
    0.0000000042486941419663721_REALK,  0.0000000038146250354403781_REALK,  &
    0.0000000034549918111868208_REALK,  0.0000000031530951973638804_REALK,  &
    0.0000000028966981072551453_REALK,  0.0000000026766722649278062_REALK,  &
    0.0000000024860974880852023_REALK,  0.0000000023196498219166651_REALK,  &
    0.0000000021731779993254734_REALK,                                      &
    0.2175158421506756811769634_REALK,  0.0065516801322307921182087_REALK,  &
    0.0005920174287975608472950_REALK,  0.0000891573910654954436029_REALK,  &
    0.0000187963848447322953630_REALK,  0.0000050935452707600855648_REALK,  &
    0.0000016857601615965399239_REALK,  0.0000006582265508252776114_REALK,  &
    0.0000002955312544886554209_REALK,  0.0000001494659853298595592_REALK,  &
    0.0000000836775032503472318_REALK,  0.0000000510682817741412206_REALK,  &
    0.0000000335183695014892690_REALK,  0.0000000233794766319707360_REALK,  &
    0.0000000171531703526327359_REALK,  0.0000000131229315322452944_REALK,  &
    0.0000000103930802452952324_REALK,  0.0000000084702118897270194_REALK,  &
    0.0000000070691808067664384_REALK,  0.0000000060180444727275117_REALK,  &
    0.0000000052091301530291873_REALK,  0.0000000045727024975419378_REALK,  &
    0.0000000040622166879066060_REALK,  0.0000000036457571566263408_REALK,  &
    0.0000000033009028013744761_REALK,  0.0000000030115549370948074_REALK,  &
    0.0000000027659243504828572_REALK,  0.0000000025552222054152765_REALK,  &
    0.0000000023727893958445087_REALK,  0.0000000022135054881726651_REALK,  &
    0.0000000020733798327223581_REALK,                                      &
    0.2171889963132861423034115_REALK,  0.0065221903172604624512876_REALK,  &
    0.0005875829490471078412825_REALK,  0.0000882239038054906794762_REALK,  &
    0.0000185438011449169793787_REALK,  0.0000050100739276742793865_REALK,  &
    0.0000016532151559074417792_REALK,  0.0000006436350905134382207_REALK,  &
    0.0000002881614968469164616_REALK,  0.0000001453452532642140609_REALK,  &
    0.0000000811655044841085530_REALK,  0.0000000494212336776884967_REALK,  &
    0.0000000323705664230505590_REALK,  0.0000000225380074437541044_REALK,  &
    0.0000000165098404889522128_REALK,  0.0000000126137195639748298_REALK,  &
    0.0000000099782820956146133_REALK,  0.0000000081241680617425686_REALK,  &
    0.0000000067746957796318902_REALK,  0.0000000057632201545684208_REALK,  &
    0.0000000049854976975649766_REALK,  0.0000000043740808678952809_REALK,  &
    0.0000000038839929315388818_REALK,  0.0000000034844194960959992_REALK,  &
    0.0000000031537298383561458_REALK,  0.0000000028764038852913454_REALK,  &
    0.0000000026410836471653154_REALK,  0.0000000024393069249401950_REALK,  &
    0.0000000022646657108847043_REALK,  0.0000000021122352198550783_REALK,  &
    0.0000000019781791373032235_REALK,                                      &
    0.2168636194429275632078458_REALK,  0.0064929210646590919051024_REALK,  &
    0.0005831948296605793738423_REALK,  0.0000873029420655380855067_REALK,  &
    0.0000182953506330790833970_REALK,  0.0000049282117480175618952_REALK,  &
    0.0000016213905962355687897_REALK,  0.0000006294070190759645703_REALK,  &
    0.0000002809946698267750157_REALK,  0.0000001413480860218560677_REALK,  &
    0.0000000787344407332360065_REALK,  0.0000000478305371698435207_REALK,  &
    0.0000000312640431431502605_REALK,  0.0000000217280767860351158_REALK,  &
    0.0000000158914598592145819_REALK,  0.0000000121248210177257032_REALK,  &
    0.0000000095804232821651188_REALK,  0.0000000077925345624630033_REALK,  &
    0.0000000064926765197911507_REALK,  0.0000000055193328535057493_REALK,  &
    0.0000000047715768671119751_REALK,  0.0000000041841717852217870_REALK,  &
    0.0000000037136548754297300_REALK,  0.0000000033302741158429807_REALK,  &
    0.0000000030131607640550255_REALK,  0.0000000027473522010034511_REALK,  &
    0.0000000025219056385027295_REALK,  0.0000000023286732010617353_REALK,  &
    0.0000000021614883872220138_REALK,  0.0000000020156144954032746_REALK,  &
    0.0000000018873635120841590_REALK,                                      &
    0.2165397005691719889419744_REALK,  0.0064638700719796852653398_REALK,  &
    0.0005788524494951197618339_REALK,  0.0000863943011827777735540_REALK,  &
    0.0000180509537440865705505_REALK,  0.0000048479231595293977499_REALK,  &
    0.0000015902685642471385292_REALK,  0.0000006155323427662256655_REALK,  &
    0.0000002740246951925116356_REALK,  0.0000001374705064396553450_REALK,  &
    0.0000000763815453674390205_REALK,  0.0000000462941671693127089_REALK,  &
    0.0000000301972535029835367_REALK,  0.0000000209484622397117353_REALK,  &
    0.0000000152970336694917530_REALK,  0.0000000116554066827168946_REALK,  &
    0.0000000091987986453725446_REALK,  0.0000000074747015747177953_REALK,  &
    0.0000000062225881364442120_REALK,  0.0000000052859077165430751_REALK,  &
    0.0000000045669417433114896_REALK,  0.0000000040025898188515465_REALK,  &
    0.0000000035508510348170621_REALK,  0.0000000031829983290305920_REALK,  &
    0.0000000028788975797072368_REALK,  0.0000000026241232495943999_REALK,  &
    0.0000000024081323338826401_REALK,  0.0000000022230794373592773_REALK,  &
    0.0000000020630303435975370_REALK,  0.0000000019234291653974195_REALK,  &
    0.0000000018007303944538636_REALK,                                      &
    0.2162172288359417715586375_REALK,  0.0064350350675782238066280_REALK,  &
    0.0005745551975422971127325_REALK,  0.0000854977804285119878311_REALK,  &
    0.0000178105326692291840451_REALK,  0.0000047691734734993824894_REALK,  &
    0.0000015598316337800550410_REALK,  0.0000006020013668350405450_REALK,  &
    0.0000002672456901500670241_REALK,  0.0000001337086731865411938_REALK,  &
    0.0000000741041511030037905_REALK,  0.0000000448101743952298925_REALK,  &
    0.0000000291687112383015579_REALK,  0.0000000201979901033983079_REALK,  &
    0.0000000147256077175118980_REALK,  0.0000000112046818548954985_REALK,  &
    0.0000000088327328576906824_REALK,  0.0000000071700854410843585_REALK,  &
    0.0000000059639189569820995_REALK,  0.0000000050624907120531028_REALK,  &
    0.0000000043711852466283963_REALK,  0.0000000038289667151312593_REALK,  &
    0.0000000033952456924787946_REALK,  0.0000000030422840082795274_REALK,  &
    0.0000000027506558007672886_REALK,  0.0000000025064529986382368_REALK,  &
    0.0000000022995175430712080_REALK,  0.0000000021222951279589128_REALK,  &
    0.0000000019690749569757622_REALK,  0.0000000018354749721506523_REALK,  &
    0.0000000017180866033789637_REALK,                                      &
    0.2158961934999817922076204_REALK,  0.0064064138101118019846814_REALK,  &
    0.0005703024727335716508730_REALK,  0.0000846131829214781603764_REALK,  &
    0.0000175740113126499251602_REALK,  0.0000046919288605283334135_REALK,  &
    0.0000015300628561355247567_REALK,  0.0000005888046859263310397_REALK,  &
    0.0000002606519606780562377_REALK,  0.0000001300588758896879747_REALK,  &
    0.0000000718996862866350637_REALK,  0.0000000433766824324886269_REALK,  &
    0.0000000281769875935539543_REALK,  0.0000000194755334063613716_REALK,  &
    0.0000000141762667040738361_REALK,  0.0000000107718848775569854_REALK,  &
    0.0000000084815791442076001_REALK,  0.0000000068781275286165744_REALK,  &
    0.0000000057161795091131074_REALK,  0.0000000048486477089826515_REALK,  &
    0.0000000041839182969095838_REALK,  0.0000000036629506269680226_REALK,  &
    0.0000000032465181873933112_REALK,  0.0000000029078369254667354_REALK,  &
    0.0000000026281638413194692_REALK,  0.0000000023940894415485515_REALK,  &
    0.0000000021958263345550419_REALK,  0.0000000020261003467936874_REALK,  &
    0.0000000018794155795010094_REALK,  0.0000000017515570916048983_REALK,  &
    0.0000000016392479038640870_REALK,                                      &
    0.2155765839293568852941263_REALK,  0.0063780040880464248034820_REALK,  &
    0.0005660936837500466422765_REALK,  0.0000837403155432703944459_REALK,  &
    0.0000173413152489703598135_REALK,  0.0000046161563270129803840_REALK,  &
    0.0000015009457458416660675_REALK,  0.0000005759331748002131172_REALK,  &
    0.0000002542379950978916093_REALK,  0.0000001265175304428905101_REALK,  &
    0.0000000697656713230905816_REALK,  0.0000000419918849139184730_REALK,  &
    0.0000000272207090333037532_REALK,  0.0000000187800100040868380_REALK,  &
    0.0000000136481326158546503_REALK,  0.0000000103562857445362648_REALK,  &
    0.0000000081447180587623488_REALK,  0.0000000065982931433342177_REALK,  &
    0.0000000054789015479953740_REALK,  0.0000000046439635970819484_REALK,  &
    0.0000000040047690115899023_REALK,  0.0000000035042053781280236_REALK,  &
    0.0000000031043622356522397_REALK,  0.0000000027793761215945040_REALK,  &
    0.0000000025111624266414864_REALK,  0.0000000022867920476620228_REALK,  &
    0.0000000020968345188255813_REALK,  0.0000000019342852604525868_REALK,  &
    0.0000000017938550778235555_REALK,  0.0000000016714896964935618_REALK,  &
    0.0000000015640385916764052_REALK,                                      &
    0.2152583896019733267213070_REALK,  0.0063498037191741787607646_REALK,  &
    0.0005619282488363981599086_REALK,  0.0000828789888558508831178_REALK,  &
    0.0000171123716820740597218_REALK,  0.0000045418236923310020996_REALK,  &
    0.0000014724642668730229434_REALK,  0.0000005633779793717918051_REALK,  &
    0.0000002479984578740802032_REALK,  0.0000001230811744900827925_REALK,  &
    0.0000000676997152408854392_REALK,  0.0000000406540428145438618_REALK,  &
    0.0000000262985550468717194_REALK,  0.0000000181103807529863101_REALK,  &
    0.0000000131403631765508413_REALK,  0.0000000099571847632571141_REALK,  &
    0.0000000078215563131390639_REALK,  0.0000000063300704922722392_REALK,  &
    0.0000000052516371263708676_REALK,  0.0000000044480414463175263_REALK,  &
    0.0000000038333819398474123_REALK,  0.0000000033524097607134542_REALK,  &
    0.0000000029684852821569392_REALK,  0.0000000026566333053541767_REALK,  &
    0.0000000023994040326279559_REALK,  0.0000000021843312375579393_REALK,  &
    0.0000000020023281554541968_REALK,  0.0000000018466496635255107_REALK,  &
    0.0000000017122053937565452_REALK,  0.0000000015950955397806807_REALK,  &
    0.0000000014922910973894742_REALK,                                      &
    0.2149416001041246082614578_REALK,  0.0063218105501396306550310_REALK,  &
    0.0005578055956188736428519_REALK,  0.0000820290170210935428970_REALK,  &
    0.0000168871094050137344111_REALK,  0.0000044688995667039919672_REALK,  &
    0.0000014446028193104721584_REALK,  0.0000005511305080543614386_REALK,  &
    0.0000002419281836361050373_REALK,  0.0000001197464630772333420_REALK,  &
    0.0000000656995123905759340_REALK,  0.0000000393614818533600868_REALK,  &
    0.0000000254092560423362006_REALK,  0.0000000174656477608986125_REALK,  &
    0.0000000126521503634238548_REALK,  0.0000000095739112750423530_REALK,  &
    0.0000000075115256570135584_REALK,  0.0000000060729696909880578_REALK,  &
    0.0000000050339577057862710_REALK,  0.0000000042605017037129624_REALK,  &
    0.0000000036694173310868419_REALK,  0.0000000032072568643149802_REALK,  &
    0.0000000028386078816968267_REALK,  0.0000000025393522790737047_REALK,  &
    0.0000000022926523508414866_REALK,  0.0000000020864878824524511_REALK,  &
    0.0000000019121030828594775_REALK,  0.0000000017630025354029650_REALK,  &
    0.0000000016342871252738959_REALK,  0.0000000015222055574340567_REALK,  &
    0.0000000014238456088458404_REALK,                                      &
    0.2146262051290603600772755_REALK,  0.0062940224559752096580856_REALK,  &
    0.0005537251609272694774511_REALK,  0.0000811902177223052998450_REALK,  &
    0.0000166654587610087961730_REALK,  0.0000043973533297167762516_REALK,  &
    0.0000014173462264266112581_REALK,  0.0000005391824233961542814_REALK,  &
    0.0000002360221714136429603_REALK,  0.0000001165101644661243899_REALK,  &
    0.0000000637628392703599978_REALK,  0.0000000381125899982543183_REALK,  &
    0.0000000245515913261806676_REALK,  0.0000000168448527101885232_REALK,  &
    0.0000000121827189864517018_REALK,  0.0000000092058224302056047_REALK,  &
    0.0000000072140818064306482_REALK,  0.0000000058265218145196887_REALK,  &
    0.0000000048254533070704329_REALK,  0.0000000040809814259389688_REALK,  &
    0.0000000035125504362032858_REALK,  0.0000000030684534354030990_REALK,  &
    0.0000000027144631080717131_REALK,  0.0000000024272883907958920_REALK,  &
    0.0000000021906817780151700_REALK,  0.0000000019930528265588702_REALK,  &
    0.0000000018259644697188672_REALK,  0.0000000016831616175369862_REALK,  &
    0.0000000015599291269046242_REALK,  0.0000000014526584896326544_REALK,  &
    0.0000000013585497111800486_REALK,                                      &
    0.2143121944755784491487560_REALK,  0.0062664373396454061196370_REALK,  &
    0.0005496863906207791802133_REALK,  0.0000803624120876705741803_REALK,  &
    0.0000164473516055009064411_REALK,  0.0000043271551094720806275_REALK,  &
    0.0000013906797221821618536_REALK,  0.0000005275256340001506171_REALK,  &
    0.0000002302755790771726937_REALK,  0.0000001133691561037714334_REALK,  &
    0.0000000618875514739387341_REALK,  0.0000000369058150698760660_REALK,  &
    0.0000000237243871650349818_REALK,  0.0000000162470752503778311_REALK,  &
    0.0000000117313253274049557_REALK,  0.0000000088523020155494313_REALK,  &
    0.0000000069287034186865553_REALK,  0.0000000055902779898743399_REALK,  &
    0.0000000046257316983231387_REALK,  0.0000000039091335460527363_REALK,  &
    0.0000000033624708401492593_REALK,  0.0000000029357192655896778_REALK,  &
    0.0000000025957959899825413_REALK,  0.0000000023202080112942140_REALK,  &
    0.0000000020932769288852271_REALK,  0.0000000019038264313574572_REALK,  &
    0.0000000017437263870256326_REALK,  0.0000000016069530102165514_REALK,  &
    0.0000000014889681286245263_REALK,  0.0000000013863005195509872_REALK,  &
    0.0000000012962580435835443_REALK,                                      &
    0.2139995580466394486940374_REALK,  0.0062390531315995685288089_REALK,  &
    0.0005456887394176252294511_REALK,  0.0000795454246155673959850_REALK,  &
    0.0000162327212692363598821_REALK,  0.0000042582757623604247123_REALK,  &
    0.0000013645889391195348062_REALK,  0.0000005161522867168903124_REALK,  &
    0.0000002246837179763481252_REALK,  0.0000001103204207414957649_REALK,  &
    0.0000000600715807557960725_REALK,  0.0000000357396624404403566_REALK,  &
    0.0000000229265149261083050_REALK,  0.0000000156714314573788328_REALK,  &
    0.0000000112972558362861741_REALK,  0.0000000085127593320024856_REALK,  &
    0.0000000066548911115878391_REALK,  0.0000000053638085282153121_REALK,  &
    0.0000000044344176187441113_REALK,  0.0000000037446261728547957_REALK,  &
    0.0000000032188818243942326_REALK,  0.0000000028087866074504637_REALK,  &
    0.0000000024823629724709997_REALK,  0.0000000022178880348857888_REALK,  &
    0.0000000020002321712833068_REALK,  0.0000000018186181407659106_REALK,  &
    0.0000000016652113998380890_REALK,  0.0000000015342107879535267_REALK,  &
    0.0000000014212483723857700_REALK,  0.0000000013229849289030170_REALK,  &
    0.0000000012368319720310659_REALK,                                      &
    0.2136882858480036451176431_REALK,  0.0062118677893331503137020_REALK,  &
    0.0005417316707283777264120_REALK,  0.0000787390831017042622762_REALK,  &
    0.0000160215025223449959713_REALK,  0.0000041906868534256688034_REALK,  &
    0.0000013390598966401273831_REALK,  0.0000005050547591005723952_REALK,  &
    0.0000002192420477687969977_REALK,  0.0000001073610426978947688_REALK,  &
    0.0000000583129322092450890_REALK,  0.0000000346126928236098208_REALK,  &
    0.0000000221568892930539764_REALK,  0.0000000151170723565226778_REALK,  &
    0.0000000108798258826785977_REALK,  0.0000000081866281202241256_REALK,  &
    0.0000000063921665251447094_REALK,  0.0000000051467020949943131_REALK,  &
    0.0000000042511520367103095_REALK,  0.0000000035871419214043897_REALK,  &
    0.0000000030814997579303010_REALK,  0.0000000026873996166620272_REALK,  &
    0.0000000023739314027469948_REALK,  0.0000000021201154029548075_REALK,  &
    0.0000000019113511824682233_REALK,  0.0000000017372460662492925_REALK,  &
    0.0000000015902501778122993_REALK,  0.0000000014647766326186982_REALK,  &
    0.0000000013566212654668535_REALK,  0.0000000012625717694662997_REALK,  &
    0.0000000011801392772250970_REALK,                                      &
    0.2133783679868891669517694_REALK,  0.0061848792969571540767415_REALK,  &
    0.0005378146564928722823604_REALK,  0.0000779432185680286617434_REALK,  &
    0.0000158136315393863205513_REALK,  0.0000041243606373073705702_REALK,  &
    0.0000013140789896524205205_REALK,  0.0000004942256521190986056_REALK,  &
    0.0000002139461714322872752_REALK,  0.0000001044882042601830851_REALK,  &
    0.0000000566096815527800372_REALK,  0.0000000335235201517627100_REALK,  &
    0.0000000214144665541442126_REALK,  0.0000000145831825066967492_REALK,  &
    0.0000000104783785596592812_REALK,  0.0000000078733655321029369_REALK,  &
    0.0000000061400714238441656_REALK,  0.0000000049385649163562127_REALK,  &
    0.0000000040755914405768693_REALK,  0.0000000034363772732978786_REALK,  &
    0.0000000029500535155376469_REALK,  0.0000000025713138192601841_REALK,  &
    0.0000000022702790392933566_REALK,  0.0000000020266866491488083_REALK,  &
    0.0000000018264465257224612_REALK,  0.0000000016595365909517343_REALK,  &
    0.0000000015186811236513117_REALK,  0.0000000013984994835058640_REALK,  &
    0.0000000012949450498624982_REALK,  0.0000000012049275498432997_REALK,  &
    0.0000000011260538570489210_REALK,                                      &
    0.2130697946706523182580639_REALK,  0.0061580856647757038768720_REALK,  &
    0.0005339371770206406122780_REALK,  0.0000771576651933600501454_REALK,  &
    0.0000156090458653345295307_REALK,  0.0000040592700397417659036_REALK,  &
    0.0000012896329775784330695_REALK,  0.0000004836577831090750622_REALK,  &
    0.0000002087918304534823551_REALK,  0.0000001016991822186001204_REALK,  &
    0.0000000549599725204556703_REALK,  0.0000000324708095371079217_REALK,  &
    0.0000000206982429597643493_REALK,  0.0000000140689786430194550_REALK,  &
    0.0000000100922835380314994_REALK,  0.0000000075724511461640961_REALK,  &
    0.0000000058981668377298025_REALK,  0.0000000047390200202152065_REALK,  &
    0.0000000039074071607485294_REALK,  0.0000000032920419653774687_REALK,  &
    0.0000000028242839220833993_REALK,  0.0000000024602956028838958_REALK,  &
    0.0000000021711935831899390_REALK,  0.0000000019374074652575799_REALK,  &
    0.0000000017453392462852672_REALK,  0.0000000015853239919752561_REALK,  &
    0.0000000014503500186445289_REALK,  0.0000000013352352035411748_REALK,  &
    0.0000000012360844869690730_REALK,  0.0000000011499249367514551_REALK,  &
    0.0000000010744554428526004_REALK,                                      &
    0.2127625562054877572659706_REALK,  0.0061314849288714610639484_REALK,  &
    0.0005300987208347652558660_REALK,  0.0000763822602457003168620_REALK,  &
    0.0000154076843824748146734_REALK,  0.0000039953886396036675480_REALK,  &
    0.0000012657089737064634386_REALK,  0.0000004733441789670885290_REALK,  &
    0.0000002037749001867514861_REALK,  0.0000000989913445287816585_REALK,  &
    0.0000000533620143521844239_REALK,  0.0000000314532753132513347_REALK,  &
    0.0000000200072531463610593_REALK,  0.0000000135737083755900484_REALK,  &
    0.0000000097209359687285256_REALK,  0.0000000072833860249877660_REALK,  &
    0.0000000056660322405927607_REALK,  0.0000000045477065104757506_REALK,  &
    0.0000000037462847216311716_REALK,  0.0000000031538584055994581_REALK,  &
    0.0000000027039432216809017_REALK,  0.0000000023541217309183154_REALK,  &
    0.0000000020764722306465585_REALK,  0.0000000018520922868312059_REALK,  &
    0.0000000016678584857352960_REALK,  0.0000000015144500799705836_REALK,  &
    0.0000000013851096845085651_REALK,  0.0000000012748462608905359_REALK,  &
    0.0000000011799105568567403_REALK,  0.0000000010974424701666222_REALK,  &
    0.0000000010252293289273423_REALK,                                      &
    0.2124566429951501300710248_REALK,  0.0061050751506987856534470_REALK,  &
    0.0005262987845190785201471_REALK,  0.0000756168440161773038619_REALK,  &
    0.0000152094872781844410410_REALK,  0.0000039326906514723433949_REALK,  &
    0.0000012422944348785447759_REALK,  0.0000004632780695689274004_REALK,  &
    0.0000001988913853767673730_REALK,  0.0000000963621470972021957_REALK,  &
    0.0000000518140793800124829_REALK,  0.0000000304696791539613418_REALK,  &
    0.0000000193405686241006606_REALK,  0.0000000130966489419571553_REALK,  &
    0.0000000093637554313343677_REALK,  0.0000000070056918128243809_REALK,  &
    0.0000000054432647636537016_REALK,  0.0000000043642788729357230_REALK,  &
    0.0000000035919232221363718_REALK,  0.0000000030215611148459063_REALK,  &
    0.0000000025887945705914374_REALK,  0.0000000022525788785012150_REALK,  &
    0.0000000019859212457799947_REALK,  0.0000000017705638976348317_REALK,  &
    0.0000000015938411139778412_REALK,  0.0000000014467638552444991_REALK,  &
    0.0000000013228196607776099_REALK,  0.0000000012172014252530376_REALK,  &
    0.0000000011263001714514617_REALK,  0.0000000010473642916759906_REALK,  &
    0.0000000009782661145539134_REALK,                                      &
    0.2121520455396955495697142_REALK,  0.0060788544166844480851064_REALK,  &
    0.0005225368725686244369272_REALK,  0.0000748612597545778734763_REALK,  &
    0.0000150143960135727937708_REALK,  0.0000038711509087048869454_REALK,  &
    0.0000012193771515014089278_REALK,  0.0000004534528814087030808_REALK,  &
    0.0000001941374158388528422_REALK,  0.0000000938091306849832475_REALK,  &
    0.0000000503145007065931015_REALK,  0.0000000295188282660135485_REALK,  &
    0.0000000186972963256082863_REALK,  0.0000000126371060110494091_REALK,  &
    0.0000000090201849267550710_REALK,  0.0000000067389098716708915_REALK,  &
    0.0000000052294784431867022_REALK,  0.0000000041884063114778520_REALK,  &
    0.0000000034440347434711507_REALK,  0.0000000028948961935200871_REALK,  &
    0.0000000024786115527994253_REALK,  0.0000000021554631894038611_REALK,  &
    0.0000000018993555527158364_REALK,  0.0000000016926530520811172_REALK,  &
    0.0000000015231313780294860_REALK,  0.0000000013821211796235886_REALK,  &
    0.0000000012633458970263694_REALK,  0.0000000011621754781608840_REALK,  &
    0.0000000010751359009818748_REALK,  0.0000000009995798854264500_REALK,  &
    0.0000000009334614580395099_REALK,                                      &
    0.2118487544342424200305430_REALK,  0.0060528208378357395771929_REALK,  &
    0.0005188124972433045883555_REALK,  0.0000741153536064275905715_REALK,  &
    0.0000148223532929553050735_REALK,  0.0000038107448470011510604_REALK,  &
    0.0000011969452378701491264_REALK,  0.0000004438622314501286063_REALK,  &
    0.0000001895092422912711361_REALK,  0.0000000913299179255476881_REALK,  &
    0.0000000488616699722276013_REALK,  0.0000000285995736531240017_REALK,  &
    0.0000000180765772132689179_REALK,  0.0000000121944125364080906_REALK,  &
    0.0000000086896899121593937_REALK,  0.0000000064826004541480552_REALK,  &
    0.0000000050243035006042976_REALK,  0.0000000040197721132143219_REALK,  &
    0.0000000033023437830018048_REALK,  0.0000000027736208118178972_REALK,  &
    0.0000000023731777172416588_REALK,  0.0000000020625798528419375_REALK,  &
    0.0000000018165983461360954_REALK,  0.0000000016181981148195541_REALK,  &
    0.0000000014555805668308363_REALK,  0.0000000013203844633506245_REALK,  &
    0.0000000012065604592411685_REALK,  0.0000000011096489366383566_REALK,  &
    0.0000000010263057130762877_REALK,  0.0000000009539838310830652_REALK,  &
    0.0000000008907158421846184_REALK,                                      &
    0.2115467603677524122129938_REALK,  0.0060269725493558284207252_REALK,  &
    0.0005151251784246342916782_REALK,  0.0000733789745515770256128_REALK,  &
    0.0000146333030341373446280_REALK,  0.0000037514484884449475850_REALK,  &
    0.0000011749871227941887363_REALK,  0.0000004344999211825086118_REALK,  &
    0.0000001850032323338811444_REALK,  0.0000000889222104517828510_REALK,  &
    0.0000000474540352069935215_REALK,  0.0000000277108084481043486_REALK,  &
    0.0000000174775849426780374_REALK,  0.0000000117679276566538185_REALK,  &
    0.0000000083717573763889624_REALK,  0.0000000062363419115919604_REALK,  &
    0.0000000048273856535883232_REALK,  0.0000000038580730413109158_REALK,  &
    0.0000000031665867130336588_REALK,  0.0000000026575027226166619_REALK,  &
    0.0000000022722861357164501_REALK,  0.0000000019737426993154910_REALK,  &
    0.0000000017374807194348683_REALK,  0.0000000015470447166999541_REALK,  &
    0.0000000013910466913531488_REALK,  0.0000000012614223663220622_REALK,  &
    0.0000000011523412496872531_REALK,  0.0000000010595077896018059_REALK,  &
    0.0000000009797027239230266_REALK,  0.0000000009104755682396142_REALK,  &
    0.0000000008499343506477456_REALK,                                      &
    0.2112460541218300069665759_REALK,  0.0060013077102661948128426_REALK,  &
    0.0005114744434755301048454_REALK,  0.0000726519743442534789374_REALK,  &
    0.0000144471903394842785245_REALK,  0.0000036932384260065550922_REALK,  &
    0.0000011534915405154645096_REALK,  0.0000004253599308742416070_REALK,  &
    0.0000001806158665677808201_REALK,  0.0000000865837861285379322_REALK,  &
    0.0000000460900987646159691_REALK,  0.0000000268514663104885424_REALK,  &
    0.0000000168995245799289122_REALK,  0.0000000113570356412069354_REALK,  &
    0.0000000080658949541150346_REALK,  0.0000000059997299358408177_REALK,  &
    0.0000000046383854569126983_REALK,  0.0000000037030187542721835_REALK,  &
    0.0000000030365112634030724_REALK,  0.0000000025463197959708767_REALK,  &
    0.0000000021757389805433425_REALK,  0.0000000018887738146175655_REALK,  &
    0.0000000016618413096822906_REALK,  0.0000000014790454263626262_REALK,  &
    0.0000000013293941792984149_REALK,  0.0000000012051095130080860_REALK,  &
    0.0000000011005717396497998_REALK,  0.0000000010116432464119705_REALK,  &
    0.0000000009352249609352379_REALK,  0.0000000008689591717490975_REALK,  &
    0.0000000008110264547005378_REALK,                                      &
    0.2109466265695409403768679_REALK,  0.0059758245030360028493543_REALK,  &
    0.0005078598271030590471931_REALK,  0.0000719342074545403282375_REALK,  &
    0.0000142639614677552639341_REALK,  0.0000036360918084922355592_REALK,  &
    0.0000011324475219091535626_REALK,  0.0000004164364140169276396_REALK,  &
    0.0000001763437348507778605_REALK,  0.0000000843124963864523833_REALK,  &
    0.0000000447684153348765048_REALK,  0.0000000260205198869958235_REALK,  &
    0.0000000163416313705226612_REALK,  0.0000000109611448793657790_REALK,  &
    0.0000000077716300770941161_REALK,  0.0000000057723768332655709_REALK,  &
    0.0000000044569776716651202_REALK,  0.0000000035543312505239594_REALK,  &
    0.0000000029118760268238580_REALK,  0.0000000024398595742501312_REALK,  &
    0.0000000020833471210849936_REALK,  0.0000000018075031711906606_REALK,  &
    0.0000000015895259586329674_REALK,  0.0000000014140594367430454_REALK,  &
    0.0000000012704935837243210_REALK,  0.0000000011513262204260382_REALK,  &
    0.0000000010511407144553222_REALK,  0.0000000009659514970163715_REALK,  &
    0.0000000008927751363865982_REALK,  0.0000000008293431374668864_REALK,  &
    0.0000000007739058098893209_REALK,                                      &
    0.2106484686742488010580132_REALK,  0.0059505211332182639596966_REALK,  &
    0.0005042808712240818809838_REALK,  0.0000712255310112460928362_REALK,  &
    0.0000140835638066786770286_REALK,  0.0000035799863259268491535_REALK,  &
    0.0000011118443859575631833_REALK,  0.0000004077236919534101171_REALK,  &
    0.0000001721835326837160200_REALK,  0.0000000821062636532646400_REALK,  &
    0.0000000434875900314808997_REALK,  0.0000000252169793323021061_REALK,  &
    0.0000000158031695577780781_REALK,  0.0000000105796869109278919_REALK,  &
    0.0000000074885091609448866_REALK,  0.0000000055539108296552829_REALK,  &
    0.0000000042828506616302096_REALK,  0.0000000034117443371806131_REALK,  &
    0.0000000027924499859806570_REALK,  0.0000000023379188469966075_REALK,  &
    0.0000000019949297382842677_REALK,  0.0000000017297682760466275_REALK,  &
    0.0000000015203873890508559_REALK,  0.0000000013519522658102951_REALK,  &
    0.0000000012142213049570378_REALK,  0.0000000010999582385675558_REALK,  &
    0.0000000010039420302073544_REALK,  0.0000000009223334831464842_REALK,  &
    0.0000000008522604315099704_REALK,  0.0000000007915401779226881_REALK,  &
    0.0000000007384900621422213_REALK,                                      &
    0.2103515714884700016362729_REALK,  0.0059253958290926460675263_REALK,  &
    0.0005007371248337141259738_REALK,  0.0000705258047461262841185_REALK,  &
    0.0000139059458462477764031_REALK,  0.0000035249001953561166701_REALK,  &
    0.0000010916717314881530416_REALK,  0.0000003992162486833279409_REALK,  &
    0.0000001681320577228751569_REALK,  0.0000000799630788789021693_REALK,  &
    0.0000000422462765524307277_REALK,  0.0000000244398908876956313_REALK,  &
    0.0000000152834312487084282_REALK,  0.0000000102121154966157753_REALK,  &
    0.0000000072160968259373401_REALK,  0.0000000053439754046290824_REALK,  &
    0.0000000041157058156521423_REALK,  0.0000000032750031219344072_REALK,  &
    0.0000000026780120614042888_REALK,  0.0000000022403032446227755_REALK,  &
    0.0000000019103139564066803_REALK,  0.0000000016554138345020778_REALK,  &
    0.0000000014542848956546018_REALK,  0.0000000012925954708903399_REALK,  &
    0.0000000011604593251829659_REALK,  0.0000000010508965027074896_REALK,  &
    0.0000000009588743816966449_REALK,  0.0000000008806946800583467_REALK,  &
    0.0000000008135922905735039_REALK,  0.0000000007554670274602431_REALK,  &
    0.0000000007047006628818103_REALK,                                      &
    0.2100559261527460142016110_REALK,  0.0059004468413147957706055_REALK,  &
    0.0004972281438765483200723_REALK,  0.0000698348909394234560691_REALK,  &
    0.0000137310571527162139188_REALK,  0.0000034708121470555899199_REALK,  &
    0.0000010719194291669823009_REALK,  0.0000003909087258399958819_REALK,  &
    0.0000001641862064138489869_REALK,  0.0000000778809991508010383_REALK,  &
    0.0000000410431754100647287_REALK,  0.0000000236883355152933647_REALK,  &
    0.0000000147817353254166228_REALK,  0.0000000098579057266432586_REALK,  &
    0.0000000069539751503497974_REALK,  0.0000000051422286543041714_REALK,  &
    0.0000000039552569948458828_REALK,  0.0000000031438635270505549_REALK,  &
    0.0000000025683506792093740_REALK,  0.0000000021468268501076000_REALK,  &
    0.0000000018293344912157626_REALK,  0.0000000015842914290149173_REALK,  &
    0.0000000013910840500203680_REALK,  0.0000000012358663759550986_REALK,  &
    0.0000000011090949551397156_REALK,  0.0000000010040368970486206_REALK,  &
    0.0000000009158410809708886_REALK,  0.0000000008409448883298084_REALK,  &
    0.0000000007766862244726026_REALK,  0.0000000007210442564051151_REALK,  &
    0.0000000006724626927243294_REALK,                                      &
    0.2097615238945333138165239_REALK,  0.0058756724425720260884809_REALK,  &
    0.0004937534911205629329853_REALK,  0.0000691526543666899347427_REALK,  &
    0.0000135588483432729998008_REALK,  0.0000034177014111337118215_REALK,  &
    0.0000010525776137391417975_REALK,  0.0000003827959178326435767_REALK,  &
    0.0000001603429707424702692_REALK,  0.0000000758581453960372292_REALK,  &
    0.0000000398770322280459961_REALK,  0.0000000229614275855882508_REALK,  &
    0.0000000142974264001418640_REALK,  0.0000000095165531658286031_REALK,  &
    0.0000000067017429550114028_REALK,  0.0000000049483426810046318_REALK,  &
    0.0000000038012300035764181_REALK,  0.0000000030180918244974084_REALK,  &
    0.0000000024632633578135500_REALK,  0.0000000020573118278889713_REALK,  &
    0.0000000017518333138432509_REALK,  0.0000000015162592124400042_REALK,  &
    0.0000000013306564188082462_REALK,  0.0000000011816478112858861_REALK,  &
    0.0000000010600205923521321_REALK,  0.0000000009592800291817934_REALK,  &
    0.0000000008747498460729842_REALK,  0.0000000008029980352493676_REALK,  &
    0.0000000007414616233963691_REALK,  0.0000000006881960938411078_REALK,  &
    0.0000000006417046933658238_REALK,                                      &
    0.2094683560271104194594471_REALK,  0.0058510709272452422757826_REALK,  &
    0.0004903127360336600364457_REALK,  0.0000684789622468604431034_REALK,  &
    0.0000133892710613778264799_REALK,  0.0000033655477045168625156_REALK,  &
    0.0000010336366765080653924_REALK,  0.0000003748727671482713171_REALK,  &
    0.0000001565994350985288324_REALK,  0.0000000738927001669902781_REALK,  &
    0.0000000387466361026837322_REALK,  0.0000000222583136161905291_REALK,  &
    0.0000000138298738121688425_REALK,  0.0000000091875730337285844_REALK,  &
    0.0000000064590151177076729_REALK,  0.0000000047620030088487332_REALK,  &
    0.0000000036533620831724321_REALK,  0.0000000028974641912836159_REALK,  &
    0.0000000023625563127985684_REALK,  0.0000000019715880691846271_REALK,  &
    0.0000000016776593296497973_REALK,  0.0000000014511816150531689_REALK,  &
    0.0000000012728792947080643_REALK,  0.0000000011298278649476441_REALK,  &
    0.0000000010131334903855162_REALK,  0.0000000009165310148646256_REALK,  &
    0.0000000008355125994792566_REALK,  0.0000000007667719853537224_REALK,  &
    0.0000000007078415781485428_REALK,  0.0000000006568502585957772_REALK,  &
    0.0000000006123585072741237_REALK,                                      &
    0.2091764139485011997354746_REALK,  0.0058266406110769825357765_REALK,  &
    0.0004869054546627701483483_REALK,  0.0000678136841915417021460_REALK,  &
    0.0000132222779527378233802_REALK,  0.0000033143312183046351123_REALK,  &
    0.0000010150872580458767589_REALK,  0.0000003671343598075875385_REALK,  &
    0.0000001529527732481839659_REALK,  0.0000000719829055073849276_REALK,  &
    0.0000000376508180260809177_REALK,  0.0000000215781710597128396_REALK,  &
    0.0000000133784706648854206_REALK,  0.0000000088704994183322180_REALK,  &
    0.0000000062254219161827737_REALK,  0.0000000045829080241028255_REALK,  &
    0.0000000035114014273866085_REALK,  0.0000000027817662841156015_REALK,  &
    0.0000000022660440791096366_REALK,  0.0000000018894928530097111_REALK,  &
    0.0000000016066680714030531_REALK,  0.0000000013889290647219045_REALK,  &
    0.0000000012176354395273793_REALK,  0.0000000010802996455354899_REALK,  &
    0.0000000009683355386116677_REALK,  0.0000000008756992726452281_REALK,  &
    0.0000000007980452757910152_REALK,  0.0000000007321883596912425_REALK,  &
    0.0000000006757527097217290_REALK,  0.0000000006269377980537390_REALK,  &
    0.0000000005843591248234681_REALK,                                      &
    0.2088856891404153037772318_REALK,  0.0058023798308454305194815_REALK,  &
    0.0004835312295154597949688_REALK,  0.0000671566921554876206449_REALK,  &
    0.0000130578226419074619881_REALK,  0.0000032640326054839565218_REALK,  &
    0.0000009969202411271891803_REALK,  0.0000003595759209696874118_REALK,  &
    0.0000001494002454111277331_REALK,  0.0000000701270608956794085_REALK,  &
    0.0000000365884493686998934_REALK,  0.0000000209202071388329298_REALK,  &
    0.0000000129426329013456848_REALK,  0.0000000085648845219147082_REALK,  &
    0.0000000060006083985273575_REALK,  0.0000000044107684392383451_REALK,  &
    0.0000000033751067186576763_REALK,  0.0000000026707928325275290_REALK,  &
    0.0000000021735491498263958_REALK,  0.0000000018108705221906625_REALK,  &
    0.0000000015387214061312042_REALK,  0.0000000013293777196296301_REALK,  &
    0.0000000011648128388711438_REALK,  0.0000000010329610556802508_REALK,  &
    0.0000000009255330520072050_REALK,  0.0000000008366983278789171_REALK,  &
    0.0000000007622676382530990_REALK,  0.0000000006991723634083796_REALK,  &
    0.0000000006451250067430212_REALK,  0.0000000005983929344344259_REALK,  &
    0.0000000005576445385255179_REALK,                                      &
    0.2085961731672041352680935_REALK,  0.0057782869440443007311159_REALK,  &
    0.0004801896494439898579847_REALK,  0.0000665078603882294177143_REALK,  &
    0.0000128958597094941318295_REALK,  0.0000032146329689911207160_REALK,  &
    0.0000009791267438790747189_REALK,  0.0000003521928106803394654_REALK,  &
    0.0000001459391954387083404_REALK,  0.0000000683235212628897841_REALK,  &
    0.0000000355584404190356043_REALK,  0.0000000202836577266489535_REALK,  &
    0.0000000125217984167646926_REALK,  0.0000000082702979377118172_REALK,  &
    0.0000000057842337797922109_REALK,  0.0000000042453067796746052_REALK,  &
    0.0000000032442466842712591_REALK,  0.0000000025643472496740037_REALK,  &
    0.0000000020849016307719962_REALK,  0.0000000017355721737075931_REALK,  &
    0.0000000014736872550380902_REALK,  0.0000000012724092129872864_REALK,  &
    0.0000000011143044678873408_REALK,  0.0000000009877145758229836_REALK,  &
    0.0000000008846365705251850_REALK,  0.0000000007994456257067601_REALK,  &
    0.0000000007281031036931863_REALK,  0.0000000006676526212747400_REALK,  &
    0.0000000006158916704263275_REALK,  0.0000000005711529181877951_REALK,  &
    0.0000000005321556040265871_REALK,                                      &
    0.2083078576748332577661671_REALK,  0.0057543603285684441842052_REALK,  &
    0.0004768803095317619309898_REALK,  0.0000658670653868304153879_REALK,  &
    0.0000127363446699520418157_REALK,  0.0000031661138501110334292_REALK,  &
    0.0000009616981131401219866_REALK,  0.0000003449805197589127608_REALK,  &
    0.0000001425670480893576059_REALK,  0.0000000665706950820478726_REALK,  &
    0.0000000345597389781757984_REALK,  0.0000000196677862705178445_REALK,  &
    0.0000000121154262064354898_REALK,  0.0000000079863259561309783_REALK,  &
    0.0000000055759708637179802_REALK,  0.0000000040862568922341291_REALK,  &
    0.0000000031185996715555896_REALK,  0.0000000024622412600107523_REALK,  &
    0.0000000019999389102605056_REALK,  0.0000000016634553627263265_REALK,  &
    0.0000000014114393258944976_REALK,  0.0000000012179104091914022_REALK,  &
    0.0000000010660080675769154_REALK,  0.0000000009444670577904867_REALK,  &
    0.0000000008455606676023997_REALK,  0.0000000007638623525848766_REALK,  &
    0.0000000006954785754939910_REALK,  0.0000000006375610207799956_REALK,  &
    0.0000000005879889666838204_REALK,  0.0000000005451578881776667_REALK,  &
    0.0000000005078359075562682_REALK,                                      &
    0.2080207343898697325279556_REALK,  0.0057305983824050875721778_REALK,  &
    0.0004736028109820995053887_REALK,  0.0000652341858497369324896_REALK,  &
    0.0000125792339499479738607_REALK,  0.0000031184572172034340233_REALK,  &
    0.0000009446259180217823238_REALK,  0.0000003379346658191765125_REALK,  &
    0.0000001392813063978121073_REALK,  0.0000000648670425266043947_REALK,  &
    0.0000000335913290071189299_REALK,  0.0000000190718827576427371_REALK,  &
    0.0000000117229955476230514_REALK,  0.0000000077125708992702462_REALK,  &
    0.0000000053755054885187472_REALK,  0.0000000039333634743795368_REALK,  &
    0.0000000029979532412864924_REALK,  0.0000000023642945431236427_REALK,  &
    0.0000000019185053433129826_REALK,  0.0000000015943838197111472_REALK,  &
    0.0000000013518568573462261_REALK,  0.0000000011657731709126394_REALK,  &
    0.0000000010198259311894475_REALK,  0.0000000009031295277261560_REALK,  &
    0.0000000008082237673846465_REALK,  0.0000000007298732659719674_REALK,  &
    0.0000000006643242842287452_REALK,  0.0000000006088325624533663_REALK,  &
    0.0000000005613560850652781_REALK,  0.0000000005203507383375741_REALK,  &
    0.0000000004846316395275707_REALK,                                      &
    0.2077347951184854157880011_REALK,  0.0057069995233305671755719_REALK,  &
    0.0004703567610093109681822_REALK,  0.0000646091026316969685656_REALK,  &
    0.0000124244848672827731210_REALK,  0.0000030716454547461321389_REALK,  &
    0.0000009279019436654314107_REALK,  0.0000003310509894193642957_REALK,  &
    0.0000001360795491347448532_REALK,  0.0000000632110736951898733_REALK,  &
    0.0000000326522293248037539_REALK,  0.0000000184952627207452767_REALK,  &
    0.0000000113440052140491884_REALK,  0.0000000074486504825680906_REALK,  &
    0.0000000051825359957029582_REALK,  0.0000000037863816233416100_REALK,  &
    0.0000000028821037785120622_REALK,  0.0000000022703343929985660_REALK,  &
    0.0000000018404519497032374_REALK,  0.0000000015282271800348796_REALK,  &
    0.0000000012948243746046422_REALK,  0.0000000011158941366219582_REALK,  &
    0.0000000009756647002470586_REALK,  0.0000000008636169979496350_REALK,  &
    0.0000000007725479702714702_REALK,  0.0000000006974065318008685_REALK,  &
    0.0000000006345736356069467_REALK,  0.0000000005814052170719004_REALK,  &
    0.0000000005359350042089001_REALK,  0.0000000004966769904987860_REALK,  &
    0.0000000004624914740021327_REALK,                                      &
    0.2074500317454747444489982_REALK,  0.0056835621886124551571662_REALK,  &
    0.0004671417727319784668136_REALK,  0.0000639916986997189494090_REALK,  &
    0.0000122720556103529098308_REALK,  0.0000030256613526856118505_REALK,  &
    0.0000009115181851887776831_REALK,  0.0000003243253503370621631_REALK,  &
    0.0000001329594283535503714_REALK,  0.0000000616013469002469133_REALK,  &
    0.0000000317414923548862288_REALK,  0.0000000179372662822265001_REALK,  &
    0.0000000109779727216401552_REALK,  0.0000000071941972024564342_REALK,  &
    0.0000000049967727209583591_REALK,  0.0000000036450764042862610_REALK,  &
    0.0000000027708561200419196_REALK,  0.0000000021801953920558912_REALK,  &
    0.0000000017656361252222495_REALK,  0.0000000014648607255309514_REALK,  &
    0.0000000012402314560099442_REALK,  0.0000000010681745080839398_REALK,  &
    0.0000000009334351697607006_REALK,  0.0000000008258482873393830_REALK,  &
    0.0000000007384588864001946_REALK,  0.0000000006663935693771613_REALK,  &
    0.0000000006061630653942663_REALK,  0.0000000005552197894397930_REALK,  &
    0.0000000005116703635026086_REALK,  0.0000000004740846731042220_REALK,  &
    0.0000000004413664537480980_REALK,                                      &
    0.2071664362332876208050436_REALK,  0.0056602848347169706921811_REALK,  &
    0.0004639574650684267251126_REALK,  0.0000633818590900447572691_REALK,  &
    0.0000121219052181370965326_REALK,  0.0000029804880960857477966_REALK,  &
    0.0000008954668418155116084_REALK,  0.0000003177537239646491386_REALK,  &
    0.0000001299186670211540886_REALK,  0.0000000600364670181454267_REALK,  &
    0.0000000308582029193788674_REALK,  0.0000000173972572352857807_REALK,  &
    0.0000000106244336042643814_REALK,  0.0000000069488577489375114_REALK,  &
    0.0000000048179375061698430_REALK,  0.0000000035092224367056992_REALK,  &
    0.0000000026640231978792419_REALK,  0.0000000020937190993037925_REALK,  &
    0.0000000016939213655774968_REALK,  0.0000000014041651374554781_REALK,  &
    0.0000000011879725099799620_REALK,  0.0000000010225198473683543_REALK,  &
    0.0000000008930521022224809_REALK,  0.0000000007897458498501360_REALK,  &
    0.0000000007058854767065511_REALK,  0.0000000006367689033640628_REALK,  &
    0.0000000005790319009855194_REALK,  0.0000000005302197884354122_REALK,  &
    0.0000000004885093406680656_REALK,  0.0000000004525242055350398_REALK,  &
    0.0000000004212098806303559_REALK,                                      &
    0.2068840006210767579197807_REALK,  0.0056371659370215631765233_REALK,  &
    0.0004608034626343149981441_REALK,  0.0000627794708661101439782_REALK,  &
    0.0000119739935606931376257_REALK,  0.0000029361092550655437757_REALK,  &
    0.0000008797403111822403345_REALK,  0.0000003113321978211544477_REALK,  &
    0.0000001269550567298245305_REALK,  0.0000000585150838984812138_REALK,  &
    0.0000000300014770773402375_REALK,  0.0000000168746221605283102_REALK,  &
    0.0000000102829407182396397_REALK,  0.0000000067122924420499925_REALK,  &
    0.0000000046457632316783031_REALK,  0.0000000033786034982538021_REALK,  &
    0.0000000025614256979049449_REALK,  0.0000000020107537519920270_REALK,  &
    0.0000000016251770023696033_REALK,  0.0000000013460262603520163_REALK,  &
    0.0000000011379465618793607_REALK,  0.0000000009788398829508853_REALK,  &
    0.0000000008544340499763386_REALK,  0.0000000007552356107950760_REALK,  &
    0.0000000006747599012155813_REALK,  0.0000000006084700225288275_REALK,  &
    0.0000000005531222293246236_REALK,  0.0000000005063513030367470_REALK,  &
    0.0000000004664015349936087_REALK,  0.0000000004319482877896123_REALK,  &
    0.0000000004019772110853114_REALK,                                      &
    0.2066027170237589027923519_REALK,  0.0056142039895325582254948_REALK,  &
    0.0004576793956423084726130_REALK,  0.0000621844230774679020569_REALK,  &
    0.0000118282813201508607022_REALK,  0.0000028925087750172316229_REALK,  &
    0.0000008643311838170091906_REALK,  0.0000003050569681765631373_REALK,  &
    0.0000001240664554870882850_REALK,  0.0000000570358908303506201_REALK,  &
    0.0000000291704610068767434_REALK,  0.0000000163687695766525544_REALK,  &
    0.0000000099530635744405197_REALK,  0.0000000064841746912341121_REALK,  &
    0.0000000044799933679272693_REALK,  0.0000000032530121452797021_REALK,  &
    0.0000000024628917331541683_REALK,  0.0000000019311539801763647_REALK,  &
    0.0000000015592779506134369_REALK,  0.0000000012903348763342402_REALK,  &
    0.0000000010900570503651454_REALK,  0.0000000009370483244938509_REALK,  &
    0.0000000008175031855879782_REALK,  0.0000000007222468105397125_REALK,  &
    0.0000000006450173742328517_REALK,  0.0000000005814372449405572_REALK,  &
    0.0000000005283787708796383_REALK,  0.0000000004835628840495419_REALK,  &
    0.0000000004452988559545510_REALK,  0.0000000004123117952666199_REALK,  &
    0.0000000003836259564438344_REALK,                                      &
    0.2063225776310907699784281_REALK,  0.0055913975046077762573460_REALK,  &
    0.0004545848998037804321488_REALK,  0.0000615966067196495618754_REALK,  &
    0.0000116847299721873467478_REALK,  0.0000028496709670962663933_REALK,  &
    0.0000008492322377838773270_REALK,  0.0000002989243367847303769_REALK,  &
    0.0000001212507855809511450_REALK,  0.0000000555976230634772726_REALK,  &
    0.0000000283643299287861791_REALK,  0.0000000158791291238659003_REALK,  &
    0.0000000096343876968850297_REALK,  0.0000000062641904766468147_REALK,  &
    0.0000000043203815456803810_REALK,  0.0000000031322493493461423_REALK,  &
    0.0000000023682565310534516_REALK,  0.0000000018547805336288914_REALK,  &
    0.0000000014961044672941089_REALK,  0.0000000012369864893231555_REALK,  &
    0.0000000010442116327844046_REALK,  0.0000000008970626859160525_REALK,  &
    0.0000000007821851398518108_REALK,  0.0000000006907118552702811_REALK,  &
    0.0000000006165960261204559_REALK,  0.0000000005556135893237113_REALK,  &
    0.0000000005047487593943273_REALK,  0.0000000004618054312748273_REALK,  &
    0.0000000004251554169717513_REALK,  0.0000000003935716784154813_REALK,  &
    0.0000000003661155878768457_REALK,                                      &
    0.2060435747067579925762004_REALK,  0.0055687450126840091699232_REALK,  &
    0.0004515196162324964525812_REALK,  0.0000610159146949410983530_REALK,  &
    0.0000115433017679709642805_REALK,  0.0000028075804989750456765_REALK,  &
    0.0000008344364334882035632_REALK,  0.0000002929307077212075135_REALK,  &
    0.0000001185060315177335456_REALK,  0.0000000541990563821486409_REALK,  &
    0.0000000275822870702392846_REALK,  0.0000000154051507787312043_REALK,  &
    0.0000000093265140067255974_REALK,  0.0000000060520378515180889_REALK,  &
    0.0000000041666911440275130_REALK,  0.0000000030161241490493840_REALK,  &
    0.0000000022773621340151457_REALK,  0.0000000017815000205548543_REALK,  &
    0.0000000014355419204715863_REALK,  0.0000000011858811187967058_REALK,  &
    0.0000000010003219992189417_REALK,  0.0000000008588041163785424_REALK,  &
    0.0000000007484088470893742_REALK,  0.0000000006605661745149009_REALK,  &
    0.0000000005894367713575550_REALK,  0.0000000005309446522851368_REALK,  &
    0.0000000004821818271505692_REALK,  0.0000000004410320858651243_REALK,  &
    0.0000000004059274340705824_REALK,  0.0000000003756868670284391_REALK,  &
    0.0000000003494074457488507_REALK,                                      &
    0.2057657005874779787557571_REALK,  0.0055462450620092727110455_REALK,  &
    0.0004484831913502397527857_REALK,  0.0000604422417740504955871_REALK,  &
    0.0000114039597165613884296_REALK,  0.0000027662223858524714012_REALK,  &
    0.0000008199369086375032830_REALK,  0.0000002870725843224186896_REALK,  &
    0.0000001158302380299318038_REALK,  0.0000000528390057300008062_REALK,  &
    0.0000000268235626669596903_REALK,  0.0000000149463040992006222_REALK,  &
    0.0000000090290582306146523_REALK,  0.0000000058474264646780524_REALK,  &
    0.0000000040186948954311818_REALK,  0.0000000029044533164876986_REALK,  &
    0.0000000021900571128115409_REALK,  0.0000000017111846576002917_REALK,  &
    0.0000000013774805684689674_REALK,  0.0000000011369231026291551_REALK,  &
    0.0000000009583036947904653_REALK,  0.0000000008221972388301465_REALK,  &
    0.0000000007161063974093236_REALK,  0.0000000006317480851107531_REALK,  &
    0.0000000005634831825982346_REALK,  0.0000000005073784911456404_REALK,  &
    0.0000000004606298954883203_REALK,  0.0000000004211981276299289_REALK,  &
    0.0000000003875731292139020_REALK,  0.0000000003586181789590736_REALK,  &
    0.0000000003334646531745225_REALK,                                      &
    0.2054889476821158966757253_REALK,  0.0055238962183797261223939_REALK,  &
    0.0004454752767943300504130_REALK,  0.0000598754845586437913049_REALK,  &
    0.0000112666675677528249226_REALK,  0.0000027255819817116673062_REALK,  &
    0.0000008057269733528752829_REALK,  0.0000002813465662227420822_REALK,  &
    0.0000001132215081516063591_REALK,  0.0000000515163238837616424_REALK,  &
    0.0000000260874130024219483_REALK,  0.0000000145020774986421066_REALK,  &
    0.0000000087416503324568227_REALK,  0.0000000056500771024205884_REALK,  &
    0.0000000038761745070962754_REALK,  0.0000000027970610377531495_REALK,  &
    0.0000000021061962921766963_REALK,  0.0000000016437120306574322_REALK,  &
    0.0000000013218153486998707_REALK,  0.0000000010900209086161546_REALK,  &
    0.0000000009180759498563292_REALK,  0.0000000007871699957724413_REALK,  &
    0.0000000006852128956139824_REALK,  0.0000000006041986613240498_REALK,  &
    0.0000000005386813704531127_REALK,  0.0000000004848655121190384_REALK,  &
    0.0000000004400470703412887_REALK,  0.0000000004022608770621942_REALK,  &
    0.0000000003700526380926452_REALK,  0.0000000003423282330619816_REALK,  &
    0.0000000003182520335828599_REALK,                                      &
    0.2052133084708139265650573_REALK,  0.0055016970648811619123975_REALK,  &
    0.0004424955293269940722993_REALK,  0.0000593155414447282694577_REALK,  &
    0.0000111313897953483094671_REALK,  0.0000026856449708184680668_REALK,  &
    0.0000007918001054262002379_REALK,  0.0000002757493464861855041_REALK,  &
    0.0000001106780013588980743_REALK,  0.0000000502299001741389907_REALK,  &
    0.0000000253731194826476582_REALK,  0.0000000140719775477136170_REALK,  &
    0.0000000084639339676013432_REALK,  0.0000000054597212489048396_REALK,  &
    0.0000000037389202979771503_REALK,  0.0000000026937786068486391_REALK,  &
    0.0000000020256404881079037_REALK,  0.0000000015789648659967282_REALK,  &
    0.0000000012684456757105101_REALK,  0.0000000010450869543004378_REALK,  &
    0.0000000008795615177435352_REALK,  0.0000000007536535019196227_REALK,  &
    0.0000000006556663264520267_REALK,  0.0000000005778616108433765_REALK,  &
    0.0000000005149798687334008_REALK,  0.0000000004633583635939344_REALK,  &
    0.0000000004203895425578461_REALK,  0.0000000003841796018681659_REALK,  &
    0.0000000003533279221680064_REALK,  0.0000000003267813661579838_REALK,  &
    0.0000000003037360321029058_REALK,                                      &
    0.2049387755041329195471178_REALK,  0.0054796462016349955018168_REALK,  &
    0.0004395436107465472788149_REALK,  0.0000587623125868614625054_REALK,  &
    0.0000109980915808532613367_REALK,  0.0000026463973594535048631_REALK,  &
    0.0000007781499457184568684_REALK,  0.0000002702777088294565962_REALK,  &
    0.0000001081979317733578643_REALK,  0.0000000489786592521074373_REALK,  &
    0.0000000246799877452346607_REALK,  0.0000000136555283029856391_REALK,  &
    0.0000000081955659585669649_REALK,  0.0000000052761006643291193_REALK,  &
    0.0000000036067308507652685_REALK,  0.0000000025944441324579601_REALK,  &
    0.0000000019482562563618044_REALK,  0.0000000015168308112747322_REALK,  &
    0.0000000012172752480307461_REALK,  0.0000000010020374347292092_REALK,  &
    0.0000000008426865196838030_REALK,  0.0000000007215819034430637_REALK,  &
    0.0000000006274074259301260_REALK,  0.0000000005526831563794246_REALK,  &
    0.0000000004923295249082307_REALK,  0.0000000004428118342844503_REALK,  &
    0.0000000004016154927872110_REALK,  0.0000000003669154277929667_REALK,  &
    0.0000000003373626847686742_REALK,  0.0000000003119435538382052_REALK,  &
    0.0000000002898846405932945_REALK,                                      &
    0.2046653414022069628064315_REALK,  0.0054577422455486385155510_REALK,  &
    0.0004366191878003435966962_REALK,  0.0000582156998631650247369_REALK,  &
    0.0000108667387975766597050_REALK,  0.0000026078254678709230818_REALK,  &
    0.0000007647702936946619795_REALK,  0.0000002649285249333408631_REALK,  &
    0.0000001057795664258610068_REALK,  0.0000000477615598989149754_REALK,  &
    0.0000000240073468013082416_REALK,  0.0000000132522706612572742_REALK,  &
    0.0000000079362157914291168_REALK,  0.0000000050989669801440680_REALK,  &
    0.0000000034794126782283880_REALK,  0.0000000024989022570212749_REALK,  &
    0.0000000018739156516622446_REALK,  0.0000000014572022259874388_REALK,  &
    0.0000000011682118634462580_REALK,  0.0000000009607921577916317_REALK,  &
    0.0000000008073802966279509_REALK,  0.0000000006908922435045503_REALK,  &
    0.0000000006003795584098756_REALK,  0.0000000005286119226165089_REALK,  &
    0.0000000004706833955373425_REALK,  0.0000000004231827560267932_REALK,  &
    0.0000000003836850007210877_REALK,  0.0000000003504312535437937_REALK,  &
    0.0000000003221222910555600_REALK,  0.0000000002977823349290991_REALK,  &
    0.0000000002766673261464422_REALK,                                      &
    0.2043929988539103237421557_REALK,  0.0054359838300701932706227_REALK,  &
    0.0004337219320994564059069_REALK,  0.0000576756068411239338801_REALK,  &
    0.0000107372979951288634846_REALK,  0.0000025699159224770621939_REALK,  &
    0.0000007516551030911027539_REALK,  0.0000002596987518394181194_REALK,  &
    0.0000001034212235789641703_REALK,  0.0000000465775938781960847_REALK,  &
    0.0000000233545482091358438_REALK,  0.0000000128617617385541139_REALK,  &
    0.0000000076855651320352812_REALK,  0.0000000049280813106027661_REALK,  &
    0.0000000033567799032993807_REALK,  0.0000000024070038875921279_REALK,  &
    0.0000000018024959971579231_REALK,  0.0000000013999759809572844_REALK,  &
    0.0000000011211672423214506_REALK,  0.0000000009212743867998946_REALK,  &
    0.0000000007735752676323904_REALK,  0.0000000006615243337954815_REALK,  &
    0.0000000005745285992283932_REALK,  0.0000000005055988282728584_REALK,  &
    0.0000000004499966464522938_REALK,  0.0000000004044299110091691_REALK,  &
    0.0000000003665599584906746_REALK,  0.0000000003346916696220090_REALK,  &
    0.0000000003075736916753397_REALK,  0.0000000002842667394488315_REALK,  &
    0.0000000002640549629059349_REALK,                                      &
    0.2041217406160363012634917_REALK,  0.0054143696049473609074876_REALK,  &
    0.0004308515200350484966423_REALK,  0.0000571419387441508277396_REALK,  &
    0.0000106097363843050310585_REALK,  0.0000025326556482225218660_REALK,  &
    0.0000007387984777106517545_REALK,  0.0000002545854294292389165_REALK,  &
    0.0000001011212711056343918_REALK,  0.0000000454257848286370757_REALK,  &
    0.0000000227209652781946283_REALK,  0.0000000124835742728360830_REALK,  &
    0.0000000074433073612483572_REALK,  0.0000000047632138799745907_REALK,  &
    0.0000000032386539523381213_REALK,  0.0000000023186059379744984_REALK,  &
    0.0000000017338796636881334_REALK,  0.0000000013450532664599936_REALK,  &
    0.0000000010760568586189022_REALK,  0.0000000008834106899929180_REALK,  &
    0.0000000007412067945240554_REALK,  0.0000000006334206318121862_REALK,  &
    0.0000000005498028225930254_REALK,  0.0000000004835969830376490_REALK,  &
    0.0000000004302264574695622_REALK,  0.0000000003865139432318838_REALK,  &
    0.0000000003502039880280889_REALK,  0.0000000003196628808838687_REALK,  &
    0.0000000002936853499322555_REALK,  0.0000000002713672198931454_REALK,  &
    0.0000000002520197670431992_REALK,                                      &
    0.2038515595124882617827922_REALK,  0.0053928982359904903062797_REALK,  &
    0.0004280076326963965730604_REALK,  0.0000566146024188968343565_REALK,  &
    0.0000104840218223437857701_REALK,  0.0000024960318612013593905_REALK,  &
    0.0000007261946673421239744_REALK,  0.0000002495856779831996761_REALK,  &
    0.0000000988781249223632469_REALK,  0.0000000443051871957013463_REALK,  &
    0.0000000221059923025307281_REALK,  0.0000000121172960494836336_REALK,  &
    0.0000000072091471284513081_REALK,  0.0000000046041436647782720_REALK,  &
    0.0000000031248632610145370_REALK,  0.0000000022335710816602487_REALK,  &
    0.0000000016679538584339623_REALK,  0.0000000012923394086152632_REALK,  &
    0.0000000010327997782769843_REALK,  0.0000000008471307966556652_REALK,  &
    0.0000000007102130525636818_REALK,  0.0000000006065261236097059_REALK,  &
    0.0000000005261527945119886_REALK,  0.0000000004625615891633736_REALK,  &
    0.0000000004113319314289522_REALK,  0.0000000003693972740040999_REALK,  &
    0.0000000003345823622101819_REALK,  0.0000000003053126326580912_REALK,  &
    0.0000000002804271723156401_REALK,  0.0000000002590555856964864_REALK,  &
    0.0000000002405352347467940_REALK,                                      &
    0.2035824484334824713283041_REALK,  0.0053715684048396975316941_REALK,  &
    0.0004251899557905314350897_REALK,  0.0000560935063032903422856_REALK,  &
    0.0000103601227985508882398_REALK,  0.0000024600320614513015875_REALK,  &
    0.0000007138380637997535331_REALK,  0.0000002446966958164415478_REALK,  &
    0.0000000966902474747483319_REALK,  0.0000000432148852009778433_REALK,  &
    0.0000000215090438222933430_REALK,  0.0000000117625293486675118_REALK,  &
    0.0000000069827999225776064_REALK,  0.0000000044506580504163223_REALK,  &
    0.0000000030152429922844147_REALK,  0.0000000021517675151078231_REALK,  &
    0.0000000016046104225509488_REALK,  0.0000000012417436936812656_REALK,  &
    0.0000000009913185046222358_REALK,  0.0000000008123674595609860_REALK,  &
    0.0000000006805349068394987_REALK,  0.0000000005807882117878038_REALK,  &
    0.0000000005035312705333526_REALK,  0.0000000004424498475023561_REALK,  &
    0.0000000003932740073601377_REALK,  0.0000000003530440212924972_REALK,  &
    0.0000000003196619296109636_REALK,  0.0000000002916101402564559_REALK,  &
    0.0000000002677704422280695_REALK,  0.0000000002473049407213219_REALK,  &
    0.0000000002295760830843448_REALK,                                      &
    0.2033144003347620576427346_REALK,  0.0053503788087359378453089_REALK,  &
    0.0004223981795634573007010_REALK,  0.0000555785603952855099415_REALK,  &
    0.0000102380084202779205181_REALK,  0.0000024246440259490457581_REALK,  &
    0.0000007017231970789990205_REALK,  0.0000002399157569891961024_REALK,  &
    0.0000000945561462736948510_REALK,  0.0000000421539918477703972_REALK,  &
    0.0000000209295539123710597_REALK,  0.0000000114188904137435539_REALK,  &
    0.0000000067639916599622250_REALK,  0.0000000043025525016189043_REALK,  &
    0.0000000029096347659519265_REALK,  0.0000000020730687309228557_REALK,  &
    0.0000000015437456373966153_REALK,  0.0000000011931791999092429_REALK,  &
    0.0000000009515388305075257_REALK,  0.0000000007790563234537166_REALK,  &
    0.0000000006521157941357228_REALK,  0.0000000005561566084744071_REALK,  &
    0.0000000004818930980753202_REALK,  0.0000000004232208677855829_REALK,  &
    0.0000000003760153775890834_REALK,  0.0000000003374199227454752_REALK,  &
    0.0000000003054110426968874_REALK,  0.0000000002785260217209983_REALK,  &
    0.0000000002556877567662579_REALK,  0.0000000002360896236352447_REALK,  &
    0.0000000002191181936037424_REALK,                                      &
    0.2030474082368229349349065_REALK,  0.0053293281602960120707513_REALK,  &
    0.0004196319987229187725708_REALK,  0.0000550696762223034988189_REALK,  &
    0.0000101176483992465529057_REALK,  0.0000023898558017949627105_REALK,  &
    0.0000006898447316250317505_REALK,  0.0000002352402090890955820_REALK,  &
    0.0000000924743724804608948_REALK,  0.0000000411216479616000487_REALK,  &
    0.0000000203669754971004674_REALK,  0.0000000110860089398487299_REALK,  &
    0.0000000065524582883372052_REALK,  0.0000000041596302461301026_REALK,  &
    0.0000000028078863993343727_REALK,  0.0000000019973533005203038_REALK,  &
    0.0000000014852600389831019_REALK,  0.0000000011465626366291199_REALK,  &
    0.0000000009133896968804640_REALK,  0.0000000007471357993098162_REALK,  &
    0.0000000006249016100317489_REALK,  0.0000000005325832330821063_REALK,  &
    0.0000000004611951231406132_REALK,  0.0000000004048355829515620_REALK,  &
    0.0000000003595204086049898_REALK,  0.0000000003224922622249761_REALK,  &
    0.0000000002917994893070923_REALK,  0.0000000002660322336588644_REALK,  &
    0.0000000002441529664137673_REALK,  0.0000000002253851510422911_REALK,  &
    0.0000000002091385585465073_REALK,                                      &
    0.2027814652241501647278454_REALK,  0.0053084151872913694011902_REALK,  &
    0.0004168911123626766346978_REALK,  0.0000545667668113487106560_REALK,  &
    0.0000099990130382088643178_REALK,  0.0000023556556995816084771_REALK,  &
    0.0000006781974627103498111_REALK,  0.0000002306674710830425788_REALK,  &
    0.0000000904435195388302566_REALK,  0.0000000401170212643401078_REALK,  &
    0.0000000198207796900560121_REALK,  0.0000000107635275819071724_REALK,  &
    0.0000000063479454063231067_REALK,  0.0000000040217019710930722_REALK,  &
    0.0000000027098516585652007_REALK,  0.0000000019245046658656666_REALK,  &
    0.0000000014290582403013972_REALK,  0.0000000011018141902519363_REALK,  &
    0.0000000008768030574998749_REALK,  0.0000000007165469441144883_REALK,  &
    0.0000000005988406009984992_REALK,  0.0000000005100221146234600_REALK,  &
    0.0000000004413961012169213_REALK,  0.0000000003872566673413406_REALK,  &
    0.0000000003437550655162452_REALK,  0.0000000003082297996851826_REALK,  &
    0.0000000002787984272675862_REALK,  0.0000000002541020100225066_REALK,  &
    0.0000000002331411175108807_REALK,  0.0000000002151681632407798_REALK,  &
    0.0000000001996152295519270_REALK,                                      &
    0.2025165644444662238488064_REALK,  0.0052876386324306684852403_REALK,  &
    0.0004141752238882616334210_REALK,  0.0000540697466597839281402_REALK,  &
    0.0000098820732179348121853_REALK,  0.0000023220322869407105316_REALK,  &
    0.0000006667763129181133661_REALK,  0.0000002261950312363289435_REALK,  &
    0.0000000884622218527639549_REALK,  0.0000000391393054807549023_REALK,  &
    0.0000000192904551579704689_REALK,  0.0000000104511014812873511_REALK,  &
    0.0000000061502078977946436_REALK,  0.0000000038885855316133635_REALK,  &
    0.0000000026153900200910334_REALK,  0.0000000018544109399103329_REALK,  &
    0.0000000013750487611787483_REALK,  0.0000000010588573768883758_REALK,  &
    0.0000000008417137495305134_REALK,  0.0000000006872333459152720_REALK,  &
    0.0000000005738832612694871_REALK,  0.0000000004884292983805442_REALK,  &
    0.0000000004224566121746441_REALK,  0.0000000003704484585844618_REALK,  &
    0.0000000003286868399319951_REALK,  0.0000000002946027042452701_REALK,  &
    0.0000000002663803219956757_REALK,  0.0000000002427098036996466_REALK,  &
    0.0000000002226283973735394_REALK,  0.0000000002054163724860927_REALK,  &
    0.0000000001905272687364322_REALK,                                      &
    0.2022526991079888758484628_REALK,  0.0052669972531460195960817_REALK,  &
    0.0004114840409441747467664_REALK,  0.0000535785317067480961221_REALK,  &
    0.0000097668003845179682081_REALK,  0.0000022889743822634124787_REALK,  &
    0.0000006555763287278876175_REALK,  0.0000002218204450967680184_REALK,  &
    0.0000000865291535079393666_REALK,  0.0000000381877194762583737_REALK,  &
    0.0000000187755075078713935_REALK,  0.0000000101483978103815555_REALK,  &
    0.0000000059590095805241726_REALK,  0.0000000037601056710014797_REALK,  &
    0.0000000025243664419373032_REALK,  0.0000000017869647153524546_REALK,  &
    0.0000000013231438653457956_REALK,  0.0000000010176189012959357_REALK,  &
    0.0000000008080593697580714_REALK,  0.0000000006591410139167020_REALK,  &
    0.0000000005499822342735343_REALK,  0.0000000004677627567335285_REALK,  &
    0.0000000004043389789816169_REALK,  0.0000000003543768830084731_REALK,  &
    0.0000000003142846811132982_REALK,  0.0000000002815824903100057_REALK,  &
    0.0000000002545188869573611_REALK,  0.0000000002318312307836633_REALK,  &
    0.0000000002125920819389071_REALK,  0.0000000001961085136424492_REALK,  &
    0.0000000001818547020379455_REALK,                                      &
    0.2019898624867008662953083_REALK,  0.0052464898213828211476217_REALK,  &
    0.0004088172753424990308116_REALK,  0.0000530930393052011104986_REALK,  &
    0.0000096531665369910326930_REALK,  0.0000022564710485887360982_REALK,  &
    0.0000006445926772006012776_REALK,  0.0000002175413335416851062_REALK,  &
    0.0000000846430270356449903_REALK,  0.0000000372615064247537979_REALK,  &
    0.0000000182754586965552846_REALK,  0.0000000098550953344082404_REALK,  &
    0.0000000057741228685310613_REALK,  0.0000000036360937522164362_REALK,  &
    0.0000000024366511443350679_REALK,  0.0000000017220628813707331_REALK,  &
    0.0000000012732594044038709_REALK,  0.0000000009780285218801085_REALK,  &
    0.0000000007757801561781790_REALK,  0.0000000006322182733934837_REALK,  &
    0.0000000005270922184260282_REALK,  0.0000000004479823039616485_REALK,  &
    0.0000000003870071900625221_REALK,  0.0000000003390093844122040_REALK,  &
    0.0000000003005189302449289_REALK,  0.0000000002691419565989104_REALK,  &
    0.0000000002431890268467676_REALK,  0.0000000002214430174009085_REALK,  &
    0.0000000002030104858209456_REALK,  0.0000000001872242971129866_REALK,  &
    0.0000000001735784747200668_REALK,                                      &
    0.2017280479136288884323136_REALK,  0.0052261151233931402507182_REALK,  &
    0.0004061746429928946369725_REALK,  0.0000526131881945799412671_REALK,  &
    0.0000095411442152427926707_REALK,  0.0000022245115876553742118_REALK,  &
    0.0000006338206427596221050_REALK,  0.0000002133553808856836652_REALK,  &
    0.0000000828025922175532849_REALK,  0.0000000363599330054587480_REALK,  &
    0.0000000177898464615548701_REALK,  0.0000000095708839897656495_REALK,  &
    0.0000000055953284475883866_REALK,  0.0000000035163875000521096_REALK,  &
    0.0000000023521193993188802_REALK,  0.0000000016596064479935040_REALK,  &
    0.0000000012253146683963858_REALK,  0.0000000009400189214865959_REALK,  &
    0.0000000007448188747236422_REALK,  0.0000000006064156652092352_REALK,  &
    0.0000000005051698770845017_REALK,  0.0000000004290495148385109_REALK,  &
    0.0000000003704268251387971_REALK,  0.0000000003243148560504619_REALK,  &
    0.0000000002873612576858368_REALK,  0.0000000002572551279509872_REALK,  &
    0.0000000002323667833627435_REALK,  0.0000000002115229489773902_REALK,  &
    0.0000000001938629146647233_REALK,  0.0000000001787443639427661_REALK,  &
    0.0000000001656804089358844_REALK,                                      &
    0.2014672487821337898417084_REALK,  0.0052058719595325540427377_REALK,  &
    0.0004035558638339468593911_REALK,  0.0000521388984740520899908_REALK,  &
    0.0000094307064882285769283_REALK,  0.0000021930855341121065627_REALK,  &
    0.0000006232556240649747246_REALK,  0.0000002092603330471839432_REALK,  &
    0.0000000810066349299511212_REALK,  0.0000000354822886276619610_REALK,  &
    0.0000000173182237727887938_REALK,  0.0000000092954644782923445_REALK,  &
    0.0000000054224149633610576_REALK,  0.0000000034008307536272742_REALK,  &
    0.0000000022706513289221052_REALK,  0.0000000015995003777801036_REALK,  &
    0.0000000011792322427010937_REALK,  0.0000000009035255837334687_REALK,  &
    0.0000000007151207109049152_REALK,  0.0000000005816858497372393_REALK,  &
    0.0000000004841737524832394_REALK,  0.0000000004109276468517289_REALK,  &
    0.0000000003545649843920757_REALK,  0.0000000003102635756845590_REALK,  &
    0.0000000002747846030626142_REALK,  0.0000000002458971997782290_REALK,  &
    0.0000000002220292834635272_REALK,  0.0000000002020498218324534_REALK,  &
    0.0000000001851296196933917_REALK,  0.0000000001706502429941112_REALK,  &
    0.0000000001581431632558554_REALK,                                      &
    0.2012074585452101049831697_REALK,  0.0051857591440603954119348_REALK,  &
    0.0004009606617658355537208_REALK,  0.0000516700915763508165967_REALK,  &
    0.0000093218269424662289090_REALK,  0.0000021621826498822194138_REALK,  &
    0.0000006128931309777957259_REALK,  0.0000002052539957717888148_REALK,  &
    0.0000000792539760260539345_REALK,  0.0000000346278846823963579_REALK,  &
    0.0000000168601583041132078_REALK,  0.0000000090285478768154401_REALK,  &
    0.0000000052551787216705360_REALK,  0.0000000032892732287583786_REALK,  &
    0.0000000021921317116118027_REALK,  0.0000000015416534245052567_REALK,  &
    0.0000000011349378709722841_REALK,  0.0000000008684866746429683_REALK,  &
    0.0000000006866331661485912_REALK,  0.0000000005579835149886561_REALK,  &
    0.0000000004640641834695702_REALK,  0.0000000003935815658843850_REALK,  &
    0.0000000003393902208012898_REALK,  0.0000000002968271435597900_REALK,  &
    0.0000000002627631180765923_REALK,  0.0000000002350444850467736_REALK,  &
    0.0000000002121546899857491_REALK,  0.0000000001930033969924341_REALK,  &
    0.0000000001767917543465369_REALK,  0.0000000001629243100983037_REALK,  &
    0.0000000001509501940686011_REALK,                                      &
    0.2009486707147959960728656_REALK,  0.0051657755049433224520117_REALK,  &
    0.0003983887645842989306752_REALK,  0.0000512066902421788743591_REALK,  &
    0.0000092144796708101706914_REALK,  0.0000021317929186775103177_REALK,  &
    0.0000006027287816122423723_REALK,  0.0000002013342329106110973_REALK,  &
    0.0000000775434702550844676_REALK,  0.0000000337960538200528442_REALK,  &
    0.0000000164152319240263257_REALK,  0.0000000087698552613926207_REALK,  &
    0.0000000050934234004023198_REALK,  0.0000000031815702898117759_REALK,  &
    0.0000000021164497966205147_REALK,  0.0000000014859779785505119_REALK,  &
    0.0000000010923603238736762_REALK,  0.0000000008348429293432249_REALK,  &
    0.0000000006593059586280908_REALK,  0.0000000005352652887624570_REALK,  &
    0.0000000004448032268729014_REALK,  0.0000000003769776752033156_REALK,  &
    0.0000000003248724755106090_REALK,  0.0000000002839784231773124_REALK,  &
    0.0000000002512721119011208_REALK,  0.0000000002246743636703126_REALK,  &
    0.0000000002027221545194335_REALK,  0.0000000001843643561221078_REALK,  &
    0.0000000001688313329135245_REALK,  0.0000000001555497490923104_REALK,  &
    0.0000000001440857187677737_REALK,                                      &
    0.2006908788610925753470582_REALK,  0.0051459198836621734829411_REALK,  &
    0.0003958399039158641856059_REALK,  0.0000507486184951667126507_REALK,  &
    0.0000091086392614960889143_REALK,  0.0000021019065406575713192_REALK,  &
    0.0000005927582994721484392_REALK,  0.0000001974989647517547793_REALK,  &
    0.0000000758740052168417050_REALK,  0.0000000329861492529952347_REALK,  &
    0.0000000159830402048054970_REALK,  0.0000000085191173456774455_REALK,  &
    0.0000000049369597725919538_REALK,  0.0000000030775827306488148_REALK,  &
    0.0000000020434991258467426_REALK,  0.0000000014323899187194991_REALK,  &
    0.0000000010514312733540871_REALK,  0.0000000008025375436202561_REALK,  &
    0.0000000006330909283900955_REALK,  0.0000000005134896546394477_REALK,  &
    0.0000000004263545823446990_REALK,  0.0000000003610838476060941_REALK,  &
    0.0000000003109830160914581_REALK,  0.0000000002716914847338627_REALK,  &
    0.0000000002402879990511905_REALK,  0.0000000002147652342054741_REALK,  &
    0.0000000001937117724354871_REALK,  0.0000000001761142594765556_REALK,  &
    0.0000000001612311910696325_REALK,  0.0000000001485105146531760_REALK,  &
    0.0000000001375346806421129_REALK,                                      &
    0.2004340766118930527994735_REALK,  0.0051261911350220139629852_REALK,  &
    0.0003933138151543145522374_REALK,  0.0000502958016173716288152_REALK,  &
    0.0000090042807874490835230_REALK,  0.0000020725139272301662467_REALK,  &
    0.0000005829775106698104838_REALK,  0.0000001937461664032045838_REALK,  &
    0.0000000742445003505327534_REALK,  0.0000000321975440822715906_REALK,  &
    0.0000000155631919493842129_REALK,  0.0000000082760741328601250_REALK,  &
    0.0000000047856054402441233_REALK,  0.0000000029771765642932351_REALK,  &
    0.0000000019731773630097122_REALK,  0.0000000013808084702057301_REALK,  &
    0.0000000010120851722286452_REALK,  0.0000000007715160701101759_REALK,  &
    0.0000000006079419465887053_REALK,  0.0000000004926168716507530_REALK,  &
    0.0000000004086835205151409_REALK,  0.0000000003458693605852486_REALK,  &
    0.0000000002976943775684920_REALK,  0.0000000002599415511085536_REALK,  &
    0.0000000002297882496128993_REALK,  0.0000000002052964677441092_REALK,  &
    0.0000000001851045399670546_REALK,  0.0000000001682355057804656_REALK,  &
    0.0000000001539749482273183_REALK,  0.0000000001417912968470436_REALK,  &
    0.0000000001312827153897195_REALK,                                      &
    0.2001782576519211820365030_REALK,  0.0051065881269653388627172_REALK,  &
    0.0003908102373983708796752_REALK,  0.0000498481661253054821503_REALK,  &
    0.0000089013797958484370052_REALK,  0.0000020436056959886820762_REALK,  &
    0.0000005733823412243854714_REALK,  0.0000001900738662254445444_REALK,  &
    0.0000000726539059566857524_REALK,  0.0000000314296306475528289_REALK,  &
    0.0000000151553087353040088_REALK,  0.0000000080404745806581005_REALK,  &
    0.0000000046391845784579011_REALK,  0.0000000028802228209658388_REALK,  &
    0.0000000019053861297574240_REALK,  0.0000000013311560684535377_REALK,  &
    0.0000000009742591388385981_REALK,  0.0000000007417263189307976_REALK,  &
    0.0000000005838148286477331_REALK,  0.0000000004726088974586595_REALK,  &
    0.0000000003917568143189101_REALK,  0.0000000003313048343747132_REALK,  &
    0.0000000002849803060848474_REALK,  0.0000000002487049462814178_REALK,  &
    0.0000000002197513417255055_REALK,  0.0000000001962483639021268_REALK,  &
    0.0000000001768823132505548_REALK,  0.0000000001607112939462451_REALK,  &
    0.0000000001470469716188016_REALK,  0.0000000001353774873133864_REALK,  &
    0.0000000001253161191812063_REALK,                                      &
    0.1999234157221789764946607_REALK,  0.0050871097403883645815537_REALK,  &
    0.0003883289133905566160865_REALK,  0.0000494056397464774716874_REALK,  &
    0.0000087999122979420872463_REALK,  0.0000020151726657827097326_REALK,  &
    0.0000005639688144374435740_REALK,  0.0000001864801443121755867_REALK,  &
    0.0000000711012022510016578_REALK,  0.0000000306818198994595436_REALK,  &
    0.0000000147590244751008473_REALK,  0.0000000078120762788511410_REALK,  &
    0.0000000044975276894480457_REALK,  0.0000000027865973541458820_REALK,  &
    0.0000000018400308484394609_REALK,  0.0000000012833582286635210_REALK,  &
    0.0000000009378928465725482_REALK,  0.0000000007131182625604649_REALK,  &
    0.0000000005606672511793419_REALK,  0.0000000004534293148948502_REALK,  &
    0.0000000003755426733493957_REALK,  0.0000000003173621727495443_REALK,  &
    0.0000000002728157050881022_REALK,  0.0000000002379590460737073_REALK,  &
    0.0000000002101567162136439_REALK,  0.0000000001876021088091767_REALK,  &
    0.0000000001690277692366402_REALK,  0.0000000001535255865464117_REALK,  &
    0.0000000001404323420301473_REALK,  0.0000000001292551470089133_REALK,  &
    0.0000000001196218181999462_REALK,                                      &
    0.1996695446193035017312667_REALK,  0.0050677548689603332116027_REALK,  &
    0.0003858695894572240813261_REALK,  0.0000489681513964403361430_REALK,  &
    0.0000086998547591043479181_REALK,  0.0000019872058519179714825_REALK,  &
    0.0000005547330483433165193_REALK,  0.0000001829631310175659486_REALK,  &
    0.0000000695853984490475408_REALK,  0.0000000299535407934718747_REALK,  &
    0.0000000143739849925114135_REALK,  0.0000000075906451388762407_REALK,  &
    0.0000000043604713660694834_REALK,  0.0000000026961806543330251_REALK,  &
    0.0000000017770205912684218_REALK,  0.0000000012373434207047795_REALK,  &
    0.0000000009029284180414303_REALK,  0.0000000006856439447804925_REALK,  &
    0.0000000005384586724949554_REALK,  0.0000000004350432617080570_REALK,  &
    0.0000000003600106811065607_REALK,  0.0000000003040145064556616_REALK,  &
    0.0000000002611765839232897_REALK,  0.0000000002276822311048768_REALK,  &
    0.0000000002009847332719093_REALK,  0.0000000001793397350078153_REALK,  &
    0.0000000001615243683853442_REALK,  0.0000000001466630749595796_REALK,  &
    0.0000000001341168211106871_REALK,  0.0000000001234109754389122_REALK,  &
    0.0000000001141873395908643_REALK,                                      &
    0.1994166381949329658329617_REALK,  0.0050485224189458057300617_REALK,  &
    0.0003834320154497158992385_REALK,  0.0000485356311563276229164_REALK,  &
    0.0000086011840891304914663_REALK,  0.0000019596964614819111686_REALK,  &
    0.0000005456712532319522774_REALK,  0.0000001795210055285182792_REALK,  &
    0.0000000681055318807307573_REALK,  0.0000000292442397046459185_REALK,  &
    0.0000000139998476139079293_REALK,  0.0000000073759550950166470_REALK,  &
    0.0000000042278580644676893_REALK,  0.0000000026088576701970408_REALK,  &
    0.0000000017162679356053421_REALK,  0.0000000011930429492062221_REALK,  &
    0.0000000008693103237084514_REALK,  0.0000000006592573935055665_REALK,  &
    0.0000000005171502565515342_REALK,  0.0000000004174173633796870_REALK,  &
    0.0000000003451317350100920_REALK,  0.0000000002912361391520171_REALK,  &
    0.0000000002500400087247473_REALK,  0.0000000002178538418659402_REALK,  &
    0.0000000001922166311086065_REALK,  0.0000000001714440831750084_REALK,  &
    0.0000000001543563190637004_REALK,  0.0000000001401091461130902_REALK,  &
    0.0000000001280868201850862_REALK,  0.0000000001178322813073582_REALK,  &
    0.0000000001090007837525349_REALK,                                      &
    0.1991646903550807756744234_REALK,  0.0050294113090298495777342_REALK,  &
    0.0003810159446866371950845_REALK,  0.0000481080102508703709593_REALK,  &
    0.0000085038776327619486773_REALK,  0.0000019326358887913656104_REALK,  &
    0.0000005367797292420600358_REALK,  0.0000001761519944804884716_REALK,  &
    0.0000000666606671335325474_REALK,  0.0000000285533798623892668_REALK,  &
    0.0000000136362807743928745_REALK,  0.0000000071677878167376790_REALK,  &
    0.0000000040995358854931385_REALK,  0.0000000025245176368154094_REALK,  &
    0.0000000016576888251156007_REALK,  0.0000000011503908386089420_REALK,  &
    0.0000000008369852847838112_REALK,  0.0000000006339145373340299_REALK,  &
    0.0000000004967048001831475_REALK,  0.0000000004005196688721751_REALK,  &
    0.0000000003308779890549676_REALK,  0.0000000002790024957529143_REALK,  &
    0.0000000002393840555034592_REALK,  0.0000000002084541358135712_REALK,  &
    0.0000000001838344864595829_REALK,  0.0000000001638987655828640_REALK,  &
    0.0000000001475085435678703_REALK,  0.0000000001338498507489581_REALK,  &
    0.0000000001223293704988517_REALK,  0.0000000001125069545201045_REALK,  &
    0.0000000001040507979103012_REALK,                                      &
    0.1989136950595194741620020_REALK,  0.0050104204701461110826877_REALK,  &
    0.0003786211338972159524789_REALK,  0.0000476852210268821689832_REALK,  &
    0.0000084079131604361972860_REALK,  0.0000019060157109588839318_REALK,  &
    0.0000005280548640224093508_REALK,  0.0000001728543706154470582_REALK,  &
    0.0000000652498952235172064_REALK,  0.0000000278804408045773234_REALK,  &
    0.0000000132829636380074723_REALK,  0.0000000069659324317401610_REALK,  &
    0.0000000039753583645327735_REALK,  0.0000000024430539107115060_REALK,  &
    0.0000000016012024365525975_REALK,  0.0000000011093237229711026_REALK,  &
    0.0000000008059021802023070_REALK,  0.0000000006095731256575225_REALK,  &
    0.0000000004770866634745754_REALK,  0.0000000003843195891810261_REALK,  &
    0.0000000003172227989921276_REALK,  0.0000000002672900730630904_REALK,  &
    0.0000000002291877653309912_REALK,  0.0000000001994642463935013_REALK,  &
    0.0000000001758211768872039_REALK,  0.0000000001566881312191568_REALK,  &
    0.0000000001409666456953247_REALK,  0.0000000001278718731430633_REALK,  &
    0.0000000001168320948311343_REALK,  0.0000000001074234394786421_REALK,  &
    0.0000000000993265509110154_REALK,                                      &
    0.1986636463211720327048937_REALK,  0.0049915488453076625741112_REALK,  &
    0.0003762473431657272979201_REALK,  0.0000472671969322008796231_REALK,  &
    0.0000083132688592554002306_REALK,  0.0000018798276835743062629_REALK,  &
    0.0000005194931304591999867_REALK,  0.0000001696264514806129077_REALK,  &
    0.0000000638723327931655340_REALK,  0.0000000272249178503167986_REALK,  &
    0.0000000129395857315279815_REALK,  0.0000000067701852593186511_REALK,  &
    0.0000000038551842694252155_REALK,  0.0000000023643638114177145_REALK,  &
    0.0000000015467310519365059_REALK,  0.0000000010697807403254596_REALK,  &
    0.0000000007760119575096450_REALK,  0.0000000005861926521762070_REALK,  &
    0.0000000004582617031397428_REALK,  0.0000000003687878385669614_REALK,  &
    0.0000000003041406699222640_REALK,  0.0000000002560763926032044_REALK,  &
    0.0000000002194311015259403_REALK,  0.0000000001908661439060780_REALK,  &
    0.0000000001681603447834243_REALK,  0.0000000001497972324920251_REALK,  &
    0.0000000001347168797961770_REALK,  0.0000000001221625022108535_REALK,  &
    0.0000000001115831804118518_REALK,  0.0000000001025707096047764_REALK,  &
    0.0000000000948177091828253_REALK,                                      &
    0.1984145382055123862929946_REALK,  0.0049727953894406285231811_REALK,  &
    0.0003738943358769588362449_REALK,  0.0000468538724950768312779_REALK,  &
    0.0000082199233241681540091_REALK,  0.0000018540637364983684775_REALK,  &
    0.0000005110910844675084208_REALK,  0.0000001664665981666453433_REALK,  &
    0.0000000625271213351182923_REALK,  0.0000000265863215906904864_REALK,  &
    0.0000000126058465913448300_REALK,  0.0000000065803495536285988_REALK,  &
    0.0000000037388774061402843_REALK,  0.0000000022883484692994164_REALK,  &
    0.0000000014941999359053602_REALK,  0.0000000010317034313983714_REALK,  &
    0.0000000007472675474909566_REALK,  0.0000000005637342816727127_REALK,  &
    0.0000000004401972087740467_REALK,  0.0000000003538963783503586_REALK,  &
    0.0000000002916072061955777_REALK,  0.0000000002453399555277779_REALK,  &
    0.0000000002100949087527312_REALK,  0.0000000001826425981306423_REALK,  &
    0.0000000001608363629994915_REALK,  0.0000000001432117934464884_REALK,  &
    0.0000000001287461212358495_REALK,  0.0000000001167096039358299_REALK,  &
    0.0000000001065713530829674_REALK,  0.0000000000979382430393140_REALK,  &
    0.0000000000905144138059942_REALK,                                      &
    0.1981663648299736291136242_REALK,  0.0049541590692204996379533_REALK,  &
    0.0003715618786626969792704_REALK,  0.0000464451833039965678463_REALK,  &
    0.0000081278555493588380344_REALK,  0.0000018287159697651773460_REALK,  &
    0.0000005028453628448628390_REALK,  0.0000001633732140840194730_REALK,  &
    0.0000000612134264409463375_REALK,  0.0000000259641773968412292_REALK,  &
    0.0000000122814554229386205_REALK,  0.0000000063962352564818133_REALK,  &
    0.0000000036263064319160784_REALK,  0.0000000022149126793865849_REALK,  &
    0.0000000014435372180249820_REALK,  0.0000000009950356425071478_REALK,  &
    0.0000000007196237823820751_REALK,  0.0000000005421607799042497_REALK,  &
    0.0000000004228618418552524_REALK,  0.0000000003396183631551444_REALK,  &
    0.0000000002795990635153022_REALK,  0.0000000002350601995422194_REALK,  &
    0.0000000002011608739469227_REALK,  0.0000000001747771426293236_REALK,  &
    0.0000000001538343020284913_REALK,  0.0000000001369181794239421_REALK,  &
    0.0000000001230418382045590_REALK,  0.0000000001115015950600778_REALK,  &
    0.0000000001017858526466442_REALK,  0.0000000000935159994605023_REALK,  &
    0.0000000000864072586432773_REALK/)
