  ! water molecule using cc-pV6Z basis sets
  !
  ! number of atoms
  integer, parameter :: NUM_ATOMS = 3
  ! coordinates of atoms
  real(REALK), parameter :: COORDS(3*NUM_ATOMS) = (/ &
     0.00000_REALK, -0.224905893_REALK, 0.0_REALK,   &  !coordinates of oxygen
     1.45235_REALK,  0.899623000_REALK, 0.0_REALK,   &  !coordinates of the first hydrogen
    -1.45235_REALK,  0.899623000_REALK, 0.0_REALK/)     !coordinates of the second hydrogen
  ! number of blocks of sub-shells
  integer, parameter :: NUM_SUB_BLOCK = 19
  ! index of atomic center of each block
  integer, parameter :: IDX_CENT_BLOCK(NUM_SUB_BLOCK) = (/ &
    1, 1, 1, 1, 1, 1, 1,                                   &  !oxygen
    2, 2, 2, 2, 2, 2,                                      &  !the first hydrogen
    2, 2, 2, 2, 2, 2/)                                        !the second hydrogen
  ! angular number of each block
  integer, parameter :: ANGULAR_BLOCK(NUM_SUB_BLOCK) = (/ &
    0, 1, 2, 3, 4, 5, 6,                                  &  !oxygen
    0, 1, 2, 3, 4, 5,                                     &  !the first hydrogen
    0, 1, 2, 3, 4, 5/)                                       !the second hydrogen
  ! number of primitives of each block
  integer, parameter :: NUM_PRIM_BLOCK(NUM_SUB_BLOCK) = (/ &
    16, 10, 5, 4, 3, 2, 1,                                 &  !oxygen
    10, 5, 4, 3, 2, 1,                                     &  !the first hydrogen
    10, 5, 4, 3, 2, 1/)                                       !the second hydrogen
  ! start index of primitives of each block
  integer, parameter :: START_PRIM_BLOCK(NUM_SUB_BLOCK+1) = (/ &
    0, 16, 26, 31, 35, 38, 40,                                 & !oxygen
    41, 51, 56, 60, 63, 65,                                    & !the first hydrogen
    66, 76, 81, 85, 88, 90, 91/)                                 !the second hydrogen
  ! exponents of each block
  real(REALK), parameter :: EXPONENT_BLOCK(91) = (/      &
    570800.0_REALK,   85480.0_REALK,    19460.0_REALK,   &  !s-type functions of oxygen
    5512.0_REALK,     1798.0_REALK,     648.9_REALK,     &
    253.1_REALK,      104.9_REALK,      45.65_REALK,     &
    20.62_REALK,      9.587_REALK,      4.493_REALK,     &
    1.837_REALK,      0.8349_REALK,     0.3658_REALK,    &
    0.157_REALK,                                         &
    525.6_REALK,      124.6_REALK,      40.34_REALK,     &  !p-type functions of oxygen
    15.18_REALK,      6.245_REALK,      2.732_REALK,     &
    1.227_REALK,      0.5492_REALK,     0.2418_REALK,    &
    0.1025_REALK,                                        &
    8.253_REALK,      3.597_REALK,      1.568_REALK,     &  !d-type functions of oxygen
    0.684_REALK,      0.298_REALK,                       &
    5.43_REALK,       2.416_REALK,      1.075_REALK,     &  !f-type functions of oxygen
    0.478_REALK,                                         &
    5.211_REALK,      2.19_REALK,       0.92_REALK,      &  !g-type functions of oxygen
    3.872_REALK,      1.505_REALK,                       &  !h-type functions of oxygen
    2.773_REALK,                                         &  !i-type functions of oxygen
    1776.77556_REALK, 254.017712_REALK, 54.698039_REALK, &  !s-type functions of the first hydrogen
    15.018344_REALK,  4.915078_REALK,   1.794924_REALK,  &
    0.710716_REALK,   0.304802_REALK,   0.138046_REALK,  &
    0.062157_REALK,                                      &
    8.649_REALK,      3.43_REALK,       1.36_REALK,      &  !p-type functions of the first hydrogen
    0.539_REALK,      0.214_REALK,                       &
    4.453_REALK,      1.958_REALK,      0.861_REALK,     &  !d-type functions of the first hydrogen
    0.378_REALK,                                         &
    4.1_REALK,        1.78_REALK,       0.773_REALK,     &  !f-type functions of the first hydrogen
    3.199_REALK,      1.326_REALK,                       &  !g-type functions of the first hydrogen
    2.653_REALK,                                         &  !h-type functions of the first hydrogen
    1776.77556_REALK, 254.017712_REALK, 54.698039_REALK, &  !s-type functions of the second hydrogen
    15.018344_REALK,  4.915078_REALK,   1.794924_REALK,  &
    0.710716_REALK,   0.304802_REALK,   0.138046_REALK,  &
    0.062157_REALK,                                      &
    8.649_REALK,      3.43_REALK,       1.36_REALK,      &  !p-type functions of the second hydrogen
    0.539_REALK,      0.214_REALK,                       &
    4.453_REALK,      1.958_REALK,      0.861_REALK,     &  !d-type functions of the second hydrogen
    0.378_REALK,                                         &
    4.1_REALK,        1.78_REALK,       0.773_REALK,     &  !f-type functions of the second hydrogen
    3.199_REALK,      1.326_REALK,                       &  !g-type functions of the second hydrogen
    2.653_REALK/)                                           !h-type functions of the second hydrogen
  ! number of contractions of each block
  integer, parameter :: NUM_CONTR_BLOCK(NUM_SUB_BLOCK) = (/ &
    7, 6, 5, 4, 3, 2, 1,                                    &  !oxygen
    6, 5, 4, 3, 2, 1,                                       &  !the first hydrogen
    6, 5, 4, 3, 2, 1/)                                         !the second hydrogen
  ! total number of contraction coefficients
  integer, parameter :: TOTAL_NCONTR = 457
  ! start index of contractions of each block
  integer, parameter :: START_CONTR_BLOCK(NUM_SUB_BLOCK+1) = (/ &
    0, 112, 172, 197, 213, 222, 226,                            & !oxygen
    227, 287, 312, 328, 337, 341,                               & !the first hydrogen
    342, 402, 427, 443, 452, 456, TOTAL_NCONTR/)                  !the second hydrogen
  ! contraction coefficients of each block
  real(REALK), parameter :: CONTR_COEF_BLOCK(TOTAL_NCONTR) = (/                &
    ! 1s, 2s, 3s, 4s, 5s, 6s, 7s of oxygen
    0.00000555_REALK, -0.00000126_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,                    &
    0.00004311_REALK, -0.00000977_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,                    &
    0.00022667_REALK, -0.00005148_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,                    &
    0.00095637_REALK, -0.00021696_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,                    &
    0.00347320_REALK, -0.00079162_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,                    &
    0.01119778_REALK, -0.00255900_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,                    &
    0.03238766_REALK, -0.00753313_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,                    &
    0.08285977_REALK, -0.01978897_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,                    &
    0.17958381_REALK, -0.04606288_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,                    &
    0.30522110_REALK, -0.08919560_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,                    &
    0.34089349_REALK, -0.13754216_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,                    &
    0.17742611_REALK, -0.10511948_REALK,  1.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,                    &
    0.02049107_REALK,  0.14477143_REALK,  0.00000000_REALK,  1.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,                    &
   -0.00096807_REALK,  0.44146336_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    1.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,                    &
    0.00105715_REALK,  0.44468145_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  1.00000000_REALK,  0.00000000_REALK,                    &
   -0.00009721_REALK,  0.12824259_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,  1.00000000_REALK,                    &
    ! 2p, 3p, 4p, 5p, 6p, 7p of oxygen
    0.00016664_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,                                       &
    0.00143336_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,                                       &
    0.00754762_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,                                       &
    0.02859456_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,                                       &
    0.08438858_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,                                       &
    0.18748342_REALK,  1.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,                                       &
    0.29790579_REALK,  0.00000000_REALK,  1.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,                                       &
    0.33855755_REALK,  0.00000000_REALK,  0.00000000_REALK,  1.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,                                       &
    0.24726093_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    1.00000000_REALK,  0.00000000_REALK,                                       &
    0.07003350_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  1.00000000_REALK,                                       &
    ! 3d, 4d, 5d, 6d, 7d of oxygen
    1.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,                                                          &
    0.00000000_REALK,  1.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,                                                          &
    0.00000000_REALK,  0.00000000_REALK,  1.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,                                                          &
    0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,  1.00000000_REALK, &
    0.00000000_REALK,                                                          &
    0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    1.00000000_REALK,                                                          &
    ! 4f, 5f, 6f, 7f of oxygen
    1.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  1.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,  1.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,  1.00000000_REALK, &
    ! 5g, 6g, 7g of oxygen
    1.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,                    &
    0.00000000_REALK,  1.00000000_REALK,  0.00000000_REALK,                    &
    0.00000000_REALK,  0.00000000_REALK,  1.00000000_REALK,                    &
    ! 6h, 7h of oxygen
    1.00000000_REALK,  0.00000000_REALK,                                       &
    0.00000000_REALK,  1.00000000_REALK,                                       &
    ! 7i of oxygen
    1.00000000_REALK,                                                          &
    ! 1s, 2s, 3s, 4s, 5s, 6s of the first hydrogen
    0.00004400_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,                                       &
    0.00037200_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,                                       &
    0.00209400_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,                                       &
    0.00886300_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,                                       &
    0.03054000_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,                                       &
    0.09034200_REALK,  1.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,                                       &
    0.21323900_REALK,  0.00000000_REALK,  1.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,                                       &
    0.35235000_REALK,  0.00000000_REALK,  0.00000000_REALK,  1.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,                                       &
    0.33965700_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    1.00000000_REALK,  0.00000000_REALK,                                       &
    0.10733000_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  1.00000000_REALK,                                       &
    ! 2p, 3p, 4p, 5p, 6p of the first hydrogen
    1.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,                                                          &
    0.00000000_REALK,  1.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,                                                          &
    0.00000000_REALK,  0.00000000_REALK,  1.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,                                                          &
    0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,  1.00000000_REALK, &
    0.00000000_REALK,                                                          &
    0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    1.00000000_REALK,                                                          &
    ! 3d, 4d, 5d, 6d of the first hydrogen
    1.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  1.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,  1.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,  1.00000000_REALK, &
    ! 4f, 5f, 6f of the first hydrogen
    1.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,                    &
    0.00000000_REALK,  1.00000000_REALK,  0.00000000_REALK,                    &
    0.00000000_REALK,  0.00000000_REALK,  1.00000000_REALK,                    &
    ! 5g, 6g of the first hydrogen
    1.00000000_REALK,  0.00000000_REALK,                                       &
    0.00000000_REALK,  1.00000000_REALK,                                       &
    ! 6h of the first hydrogen
    1.00000000_REALK,                                                          &
    ! 1s, 2s, 3s, 4s, 5s, 6s of the second hydrogen
    0.00004400_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,                                       &
    0.00037200_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,                                       &
    0.00209400_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,                                       &
    0.00886300_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,                                       &
    0.03054000_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,                                       &
    0.09034200_REALK,  1.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,                                       &
    0.21323900_REALK,  0.00000000_REALK,  1.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,                                       &
    0.35235000_REALK,  0.00000000_REALK,  0.00000000_REALK,  1.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,                                       &
    0.33965700_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    1.00000000_REALK,  0.00000000_REALK,                                       &
    0.10733000_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  1.00000000_REALK,                                       &
    ! 2p, 3p, 4p, 5p, 6p of the second hydrogen
    1.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,                                                          &
    0.00000000_REALK,  1.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,                                                          &
    0.00000000_REALK,  0.00000000_REALK,  1.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,                                                          &
    0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,  1.00000000_REALK, &
    0.00000000_REALK,                                                          &
    0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    1.00000000_REALK,                                                          &
    ! 3d, 4d, 5d, 6d of the second hydrogen
    1.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  1.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,  1.00000000_REALK,  0.00000000_REALK, &
    0.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,  1.00000000_REALK, &
    ! 4f, 5f, 6f of the second hydrogen
    1.00000000_REALK,  0.00000000_REALK,  0.00000000_REALK,                    &
    0.00000000_REALK,  1.00000000_REALK,  0.00000000_REALK,                    &
    0.00000000_REALK,  0.00000000_REALK,  1.00000000_REALK,                    &
    ! 5g, 6g of the second hydrogen
    1.00000000_REALK,  0.00000000_REALK,                                       &
    0.00000000_REALK,  1.00000000_REALK,                                       &
    ! 6h of the second hydrogen
    1.00000000_REALK/)
  ! referenced normalized contracted CGTO coefficients of each block
  real(REALK), parameter :: REF_NRM_CGTO(TOTAL_NCONTR) = (/                        &
    ! 1s, 2s, 3s, 4s, 5s, 6s, 7s of oxygen
    0.082142146495720_REALK,  -0.018648487328340_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.153598331801200_REALK,  -0.034809921200850_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.266171322560100_REALK,  -0.060451315555650_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.436031577478100_REALK,  -0.098917167131740_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.683489974801300_REALK,  -0.155782659884400_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    1.026066130900000_REALK,  -0.234484266631200_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    1.464734029076000_REALK,  -0.340686294280000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    1.935688324691000_REALK,  -0.462290424160200_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    2.247800992108000_REALK,  -0.576556358009600_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    2.104946876727000_REALK,  -0.615134405180000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    1.323703886967000_REALK,  -0.534082044125100_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.390238340230000_REALK,  -0.231204141463700_REALK,   2.199441454031000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.023043932536960_REALK,   0.162807655677600_REALK,   0.000000000000000_REALK, &
    1.124584153184000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
   -0.000602618830828_REALK,   0.274808778375700_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.622495101155600_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.000354388386149_REALK,   0.149070559097200_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.335229993072900_REALK, &
    0.000000000000000_REALK,                                                       &
   -0.000017280080981_REALK,   0.022796444215990_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.177760323327700_REALK,                                                       &
    ! 2p, 3p, 4p, 5p, 6p, 7p of oxygen
    0.597776093137800_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.850536436478100_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    1.093754829435000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    1.221274311980000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    1.187515596329000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.938650304977200_REALK,   5.006577654235000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.548371325334200_REALK,   0.000000000000000_REALK,   1.840754162837000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.228158027519100_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.673912091399100_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.059760738917820_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.241690988834000_REALK,   0.000000000000000_REALK, &
    0.005789629235446_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.082669425512110_REALK, &
    ! 3d, 4d, 5d, 6d, 7d of oxygen
  114.562059521899997_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,  26.783408779039998_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,   0.000000000000000_REALK,   6.263624088837000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    1.466622223699000_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.342648271769900_REALK,                            &
    ! 4f, 5f, 6f, 7f of oxygen
  256.625433376300009_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.000000000000000_REALK,  41.492363276770000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.000000000000000_REALK,   0.000000000000000_REALK,   6.709175058115000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    1.083210463690000_REALK,                                                       &
    ! 5g, 6g, 7g of oxygen
 1067.979769656999906_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,  98.458086396390001_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   9.066644762138001_REALK, &
    ! 6h, 7h of oxygen
 1857.162704609999992_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,  86.110021034720006_REALK,                            &
    ! 7i of oxygen
 2090.027868892999777_REALK,                                                       &
    ! 1s, 2s, 3s, 4s, 5s, 6s of the first hydrogen
    0.008581974454952_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.016869454995880_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.030016884002950_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.048190052263500_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.071850030298370_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.099846848443690_REALK,   1.105209579776000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.117638321394400_REALK,   0.000000000000000_REALK,   0.551673549347900_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.103014354914300_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.292363701379800_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.054823726458820_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.161409080159900_REALK,   0.000000000000000_REALK, &
    0.009522451631775_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.088721244705630_REALK, &
    ! 2p, 3p, 4p, 5p, 6p of the first hydrogen
   21.142067705290000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,   6.653616078396000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,   0.000000000000000_REALK,   2.093455450377000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.658303318505100_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.207470954306000_REALK,                            &
    ! 3d, 4d, 5d, 6d of the first hydrogen
   38.914575744590003_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.000000000000000_REALK,   9.239368455468000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.000000000000000_REALK,   0.000000000000000_REALK,   2.193944305643000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.519494236029400_REALK,                                                       &
    ! 4f, 5f, 6f of the first hydrogen
  136.384104618099997_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,  20.866282576610001_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   3.194507709182000_REALK, &
    ! 5g, 6g of the first hydrogen
  279.138175226600026_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,  24.775633391050000_REALK,                            &
    ! 6h of the first hydrogen
  543.508240352399980_REALK,                                                       &
    ! 1s, 2s, 3s, 4s, 5s, 6s of the second hydrogen
    0.008581974454952_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.016869454995880_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.030016884002950_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.048190052263500_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.071850030298370_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.099846848443690_REALK,   1.105209579776000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.117638321394400_REALK,   0.000000000000000_REALK,   0.551673549347900_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.103014354914300_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.292363701379800_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.054823726458820_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.161409080159900_REALK,   0.000000000000000_REALK, &
    0.009522451631775_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.088721244705630_REALK, &
    ! 2p, 3p, 4p, 5p, 6p of the second hydrogen
   21.142067705290000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,   6.653616078396000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,   0.000000000000000_REALK,   2.093455450377000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.658303318505100_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.207470954306000_REALK,                            &
    ! 3d, 4d, 5d, 6d of the second hydrogen
   38.914575744590003_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.000000000000000_REALK,   9.239368455468000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.000000000000000_REALK,   0.000000000000000_REALK,   2.193944305643000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.519494236029400_REALK,                                                       &
    ! 4f, 5f, 6f of the second hydrogen
  136.384104618099997_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,  20.866282576610001_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   3.194507709182000_REALK, &
    ! 5g, 6g of the second hydrogen
  279.138175226600026_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,  24.775633391050000_REALK,                            &
    ! 6h of the second hydrogen
  543.508240352399980_REALK/)
  ! referenced normalized contracted SGTO coefficients of each block
  real(REALK), parameter :: REF_NRM_SGTO(TOTAL_NCONTR) = (/                        &
    ! 1s, 2s, 3s, 4s, 5s, 6s, 7s of oxygen
    0.291186327756000_REALK,  -0.066107166357350_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.544491909387200_REALK,  -0.123397957764300_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.943552771344400_REALK,  -0.214294334097800_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    1.545691697235000_REALK,  -0.350652227606600_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    2.422908875784000_REALK,  -0.552235150832900_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    3.637309729995000_REALK,  -0.831225082734500_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    5.192346940776000_REALK,  -1.207701468495000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    6.861836450504000_REALK,  -1.638776885079000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    7.968247049064000_REALK,  -2.043839074036000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    7.461842395214000_REALK,  -2.180594690571000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    4.692408103828000_REALK,  -1.893271551618000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    1.383358897823000_REALK,  -0.819597341765200_REALK,   7.796816950078000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.081688613930290_REALK,   0.577138112525300_REALK,   0.000000000000000_REALK, &
    3.986547025956000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
   -0.002136228134660_REALK,   0.974171754989200_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   2.206687678426000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.001256274119493_REALK,   0.528441373056800_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   1.188359384322000_REALK, &
    0.000000000000000_REALK,                                                       &
   -0.000061256292156_REALK,   0.080811290675160_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.630143939240700_REALK,                                                       &
    ! 2p, 3p, 4p, 5p, 6p, 7p of oxygen
    1.223440482960000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    1.740753303059000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    2.238537057813000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    2.499525242355000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    2.430432851653000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    1.921091853011000_REALK,  10.246729257969999_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    1.122326046173000_REALK,   0.000000000000000_REALK,   3.767385795190000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.466960406385300_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    1.379264483874000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.122309520442400_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.494657687887600_REALK,   0.000000000000000_REALK, &
    0.011849364451480_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.169195662114300_REALK, &
    ! 3d, 4d, 5d, 6d, 7d of oxygen
  104.857648699199999_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,  24.514619241660000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,   0.000000000000000_REALK,   5.733040214467000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    1.342386463275000_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.313622959106900_REALK,                            &
    ! 4f, 5f, 6f, 7f of oxygen
   88.778944686480003_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.000000000000000_REALK,  14.354182186059999_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.000000000000000_REALK,   0.000000000000000_REALK,   2.321022797857000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.374734026064800_REALK,                                                       &
    ! 5g, 6g, 7g of oxygen
  123.155001499299999_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,  11.353778528650000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   1.045527903243000_REALK, &
    ! 6h, 7h of oxygen
   64.571762212270002_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,   2.993962666030000_REALK,                            &
    ! 7i of oxygen
   20.154549083429998_REALK,                                                       &
    ! 1s, 2s, 3s, 4s, 5s, 6s of the first hydrogen
    0.030422307342100_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.059800660940240_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.106407083286400_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.170829287419500_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.254701725780100_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.353947862049600_REALK,   3.917865951463000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.417016991539200_REALK,   0.000000000000000_REALK,   1.955631813969000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.365176380132700_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    1.036402336751000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.194345050165800_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.572180291401100_REALK,   0.000000000000000_REALK, &
    0.033756212129600_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.314508623671300_REALK, &
    ! 2p, 3p, 4p, 5p, 6p of the first hydrogen
   43.270485088069996_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,  13.617646074890001_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,   0.000000000000000_REALK,   4.284577748534000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    1.347318735512000_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.424621137329000_REALK,                            &
    ! 3d, 4d, 5d, 6d of the first hydrogen
   35.618170009629999_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.000000000000000_REALK,   8.456712944488000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.000000000000000_REALK,   0.000000000000000_REALK,   2.008097988346000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.475488519761000_REALK,                                                       &
    ! 4f, 5f, 6f of the first hydrogen
   47.181749371869998_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   7.218639720580000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   1.105132174480000_REALK, &
    ! 5g, 6g of the first hydrogen
   32.189057663130001_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,   2.857023376389000_REALK,                            &
    ! 6h of the first hydrogen
   18.897259119689998_REALK,                                                       &
    ! 1s, 2s, 3s, 4s, 5s, 6s of the second hydrogen
    0.030422307342100_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.059800660940240_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.106407083286400_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.170829287419500_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.254701725780100_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.353947862049600_REALK,   3.917865951463000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.417016991539200_REALK,   0.000000000000000_REALK,   1.955631813969000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.365176380132700_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    1.036402336751000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.194345050165800_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.572180291401100_REALK,   0.000000000000000_REALK, &
    0.033756212129600_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.314508623671300_REALK, &
    ! 2p, 3p, 4p, 5p, 6p of the second hydrogen
   43.270485088069996_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,  13.617646074890001_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,   0.000000000000000_REALK,   4.284577748534000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    1.347318735512000_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.424621137329000_REALK,                            &
    ! 3d, 4d, 5d, 6d of the second hydrogen
   35.618170009629999_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.000000000000000_REALK,   8.456712944488000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.000000000000000_REALK,   0.000000000000000_REALK,   2.008097988346000_REALK, &
    0.000000000000000_REALK,                                                       &
    0.000000000000000_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.475488519761000_REALK,                                                       &
    ! 4f, 5f, 6f of the second hydrogen
   47.181749371869998_REALK,   0.000000000000000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   7.218639720580000_REALK,   0.000000000000000_REALK, &
    0.000000000000000_REALK,   0.000000000000000_REALK,   1.105132174480000_REALK, &
    ! 5g, 6g of the second hydrogen
   32.189057663130001_REALK,   0.000000000000000_REALK,                            &
    0.000000000000000_REALK,   2.857023376389000_REALK,                            &
    ! 6h of the second hydrogen
   18.897259119689998_REALK/)
