# set cdash buildname
set(BUILDNAME
    "${CMAKE_SYSTEM_NAME}-${CMAKE_HOST_SYSTEM_PROCESSOR}-${CMAKE_Fortran_COMPILER_ID}-${BLAS_TYPE}-${cmake_build_type_tolower}"
    CACHE STRING
    "Name of build on the dashboard"
    )

# set ctest own timeout
set(DART_TESTING_TIMEOUT
    "1500"
    CACHE STRING
    "Set timeout in seconds for every single test"
    )
message(STATUS "Set CDash default timeout for single test set to ${DART_TESTING_TIMEOUT} seconds. Overwritten by test's TIMEOUT property label and, ultimatively, by pam timeout setting.")

macro(dirac_test _name _label _timeout)
    add_test(${_name} ${PYTHON_EXECUTABLE} ${PROJECT_SOURCE_DIR}/test/${_name}/test --binary-dir=${PROJECT_BINARY_DIR} --work-dir=${PROJECT_BINARY_DIR}/test/${_name} --verbose)
    if(NOT "${_label}" STREQUAL "")
        #miro: test's TIMEOUT marker goes after the LABEL marker
        if(NOT "${_timeout}" STREQUAL "")
            set_tests_properties(${_name} PROPERTIES LABELS "${_label}" TIMEOUT "${_timeout}")
            message(STATUS "Test's '${_name}' timeout set to ${_timeout} seconds. Can be overwritten by pam's timeout setting.")
        else()
            set_tests_properties(${_name} PROPERTIES LABELS "${_label}")
        endif()
    endif()
endmacro()

# activate ctest
include(CTest)
enable_testing()
# these tests appear also in release-xx versions
# Labeled as long
dirac_test(cc_frozen_open_shell "long;cc;frozen" "")
dirac_test(geo_opt "long;geoopt" "")
dirac_test(response_pv_nmr "long;pvc;response" "")
dirac_test(response_pv_nsr "long;pvc;response" "")
dirac_test(bedecd_isotropic "long;response;bed;ecd" "")
dirac_test(bedecd_anisotropic "long;response;bed;ecd" "")
dirac_test(eomee_energy_symmetry "long;cc;eomcc" "")
dirac_test(electrostatic_potential "long;elp" "")
dirac_test(cc_gradient "long;cc;cc_gradient" "")
dirac_test(ihfscc_newshift "long;fscc" "")
dirac_test(eomee_energy_symmetry_cvs "long;cc;eomcc" "")
dirac_test(eomip_energy_symmetry "long;cc;eomcc" "")
dirac_test(eomip_energy_symmetry_2h1p_starts "long;cc;eomcc" "")
dirac_test(eomea_energy_symmetry "long;cc;eomcc" "")
dirac_test(eomee_energy_symmetry_eigenvalue_shift "long;cc;eomcc" "")
dirac_test(dft_geo_opt "long;dft;geoopt" "")
dirac_test(geo_opt_xyz "long;geoopt" "")
dirac_test(fde_export_density "long;fde" "")
dirac_test(eomip_energy_symmetry_cvs "long;cc;eomcc" "")
dirac_test(eomip_energy_symmetry_eigenvalue_shift "long;cc;eomcc" "")
dirac_test(fscc_restart "long;fscc;restart" "")
dirac_test(spinrot "long;response" "")
dirac_test(cc_mcscf "long;cc" "")
dirac_test(fde_static-vemb_dipole "long;fde" "")
dirac_test(dft_alda "long;dft" "")
dirac_test(dft_alda_xcfun "long;dft" "")
dirac_test(response_nmr_spin-spin "long;response;nmr" "")
dirac_test(fde_interaction_energy "long;fde" "")
dirac_test(frozen_orbitals "long;frozen" "")
dirac_test(krci_energy_q_corrections "long;krci;qcorr;ci" "")
dirac_test(fde_response_mag "long;fde;magnetizabilities;lao" "")
dirac_test(dft_minnesota "long;dft" "")
dirac_test(visual_lao_symmetry "long;visual;lao" "")
dirac_test(efg "long;efg" "")
dirac_test(eomcc_long "long;cc;eomcc" "")
dirac_test(mcscf_energy "long;mcscf" "")
dirac_test(mp2_properties "long;mp2;property" "")
dirac_test(dft_overlap_diagnostic "long;dft" "")
dirac_test(dft_response "long;response;dft" "")
dirac_test(symmetry_scf_energy "long;scf" "")
dirac_test(fde_open-shell "long;fde" "")
dirac_test(fde_response_shield "long;fde;shielding;lao" "")
dirac_test(xyz_input "long;input;xyz" "")
# Labeled as medium
dirac_test(visual_lao_current "medium;visual;lao" "")
dirac_test(visual_lao_current_derivs "medium;visual;lao" "")
dirac_test(cc_restart "medium;cc;restart" "")
dirac_test(atomic_supersymmetry "medium;scf" "")
dirac_test(nmqm_property_krci "medium;krci;property" "")
dirac_test(geo_opt_saddle "medium;geoopt" "")
dirac_test(cc_essential "medium;cc" "")
dirac_test(dft_response_xcfun "medium;response;dft" "")
dirac_test(dft_ao_eval "medium;dft" "")
dirac_test(dft_response_symmetry "medium;response;dft" "")
dirac_test(fscc_highspin "medium;fscc" "")
dirac_test(cc_energy_and_mp2_dipole "medium;cc" "")
dirac_test(spinorbit-from-spinfree "medium;scf;resolve" "")
dirac_test(eomcc_restart "medium;cc;eomcc;restart" "")
dirac_test(rotg "medium;response" "")
dirac_test(geo_opt_symm_xyz "medium;geoopt" "")
dirac_test(visual_lao_shielding "medium;visual;lao" "")
dirac_test(nucl_anapole_cc_finite_field "medium;cc" "")
dirac_test(response_qr "medium;response;qr" "")
dirac_test(fde_response_autodiff "medium;fde" "")
dirac_test(molecular_mean_field_hamiltonian_schemes "medium;meanfield" "")
dirac_test(magn_hyperfine_finite_field "medium;cc" "")
dirac_test(response_excitation_energies "medium;response" "")
dirac_test(cosci_energy "medium;ci;cosci" "")
dirac_test(projection_analysis "medium;projection" "")
dirac_test(cisd_energy "medium;ci" "")
dirac_test(eedm_mhyp_ensps_krci "medium;krci;property" "")
dirac_test(general_property_krci "medium;krci;property" "")
dirac_test(e_edm_finite_field "medium;cc" "")
dirac_test(eomcc "medium;cc;eomcc" "")
dirac_test(dft_lao_mag_prop "medium;dft;lao;property" "")
dirac_test(fscc "medium;fscc" "")
dirac_test(visual_general "medium;visual" "")
dirac_test(mcscf_properties "medium;mcscf" "")
dirac_test(ne_sps_finite_field "medium;cc" "")
dirac_test(fscc_intensities "medium;cc;fscc" "")
dirac_test(london_properties_symmetry "medium;lao" "")
dirac_test(krci_energy "medium;krci" "")
dirac_test(cc_linear "medium;cc" "")
dirac_test(open-shells "medium" "")
dirac_test(basis_automatic_augmentation "medium;basis" "")
dirac_test(ecp_nio6 "medium;ecp" "")
# Labeled as short
dirac_test(reladc_dip "short;reladc" "")
dirac_test(x2c-SCF_to_4c-SCF "short;x2c;4c;scf" "")
dirac_test(xyz_symmetry_recognition "short" "")
dirac_test(nmqm_operator "short;cc" "")
dirac_test(visual_div_rot "short;visual" "")
dirac_test(bed_isotropic "short;response;bed" "")
dirac_test(localization "short;localization" "")
dirac_test(krci_properties_perm_dipmom "short;krci" "")
dirac_test(huckel_start "short;huckel" "")
dirac_test(cosci_tmom "short;ci" "")
dirac_test(reladc_sipeigv "short;reladc" "")
dirac_test(bed_anisotropic "short;response;bed" "")
dirac_test(response_lao_magnetiz_dft "short;response;magnetizabilities;lao;dft" "")
dirac_test(dft_pp86 "short;dft" "")
dirac_test(bss_energy "short" "")
dirac_test(acmoin "short" "")
dirac_test(dft_cam "short;dft" "")
dirac_test(visual_frac_occupation "short;visual" "")
dirac_test(eomee_fc_cvs "short;cc;eomcc" "")
dirac_test(response_lao_shield "short;response;shielding;lao" "")
dirac_test(response_lao_magnetiz "short;response;magnetizabilities;lao" "")
dirac_test(krci_properties_omega_tdm "short;krci;property" "")
dirac_test(response_hf_polarizability "short;response;polarizabilities" "")
dirac_test(count_cc_memory "short;cc" "")
dirac_test(reladc_fano "short;reladc" "")
dirac_test(cosci_methods "short;ci" "")
dirac_test(response_nonrel "short;response;nonel" "")
dirac_test(eomip_fc_cvs "short;cc;eomcc" "")
dirac_test(symmetry_recognition "short" "")
dirac_test(reladc_sip "short;reladc" "")
dirac_test(ecp "short;ecp" "")
dirac_test(scf_levelshift "short;scf;levelshift" "")
dirac_test(basis_input "short;basis" "")
dirac_test(visual_gamma5 "short;visual" "")
dirac_test(pvc_scf "short;pvc;scf" "")
dirac_test(cosci_energy_spinfree "short;ci" "")
dirac_test(density_at_nuclei "short" "")
dirac_test(dft_erf_xcfun "short;dft" "")
dirac_test(mp2_natural_orbitals "short;mp2" "")
dirac_test(ffpt_dipmom_polariz_relcc "short;cc" "")
dirac_test(mp2_srdft_energies "short;mp2;srdft" "")
dirac_test(operators_mo_mtx_elements "short;operators" "")
dirac_test(response_C6 "short;response" "")
dirac_test(bsse "short;basis" "")
dirac_test(import_mos "short;import;scf;mcscf" "")
dirac_test(stex "short;stex" "")
dirac_test(zora "short;zora" "")
dirac_test(dft_grid_export_import "short;dft;grid" "")
dirac_test(cosci_average "short;ci;cosci" "")
dirac_test(linear_structures "short;structures" "")
dirac_test(gaunt "short;gaunt" "")
dirac_test(dft_ac "short;dft" "")
dirac_test(dft_betasigma "short;dft" "")
dirac_test(lucita_short "short;krci" "")
dirac_test(projection_analysis_overlaps "short;projection" "")
dirac_test(lucita_large "short;krci" "")
dirac_test(lucita_q_corrections "short;qcorr;ci" "")
dirac_test(basis_contraction "short;basis" "")
dirac_test(response_nmr_levy-leblond "short;response;nmr" "")
dirac_test(blockd_twocomp "short;twocomp" "")
dirac_test(dft_cosci "short;dft;cosci" "")
dirac_test(molecular_mean_field_restart "short;x2c;mp2" "")
dirac_test(dirrci_property "short;ci;dirrci;property" "")
dirac_test(laplace "short;mp2;laplace" "")
dirac_test(response_complex "short;response;complex" "")
dirac_test(mp2_energy "short;mp2" "")
dirac_test(dirac_mointegral_export "short;cc" "")
dirac_test(response_rkbimp_shield "short;response;shield" "")
dirac_test(free-particle_projection "short;projection" "")
dirac_test(atomic_start "short" "")
dirac_test(checkpoint_from_Dformat "short" "")
dirac_test(tutorial_checkpoint "short" "")
dirac_test(cosci_energy_blockd "short;cosci" "")
dirac_test(visual_elf "short;visual" "")
dirac_test(visual_density_derivs "short;visual" "")
dirac_test(visual_custom_output "short;visual" "")
dirac_test(polprp_ph "short;polprp" "")
dirac_test(pam_test "short;pam" "")
dirac_test(basis_input_scripted "short;basis" "3600")
dirac_test(nqcc "short;nqcc" "")
# disabled some tests waiting for code verification/efficiency improvement
#dirac_test(eomcc_expval "cc" "")
