!vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvC
!                                                                      C
!  Module name: USR1                                                   C
!  Purpose: This routine is called from the time loop and is           C
!           user-definable.  The user may insert code in this routine  C
!           or call appropriate user defined subroutines.  This        C
!           can be used for setting or checking errors in quantities   C
!           that vary with time.  This routine is not called from an   C
!           IJK loop, hence all indices are undefined.                 C               C
!                                                                      C
!  Author:                                            Date: dd-mmm-yy  C
!  Reviewer:                                          Date: dd-mmm-yy  C
!                                                                      C
!  Revision Number:                                                    C
!  Purpose:                                                            C
!  Author:                                            Date: dd-mmm-yy  C
!  Reviewer:                                          Date: dd-mmm-yy  C
!                                                                      C
!  Literature/Document References:                                     C
!                                                                      C
!  Variables referenced:                                               C
!  Variables modified:                                                 C
!                                                                      C
!  Local variables:                                                    C
!                                                                      C
!^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^C
!
      SUBROUTINE USR1

!      USE USR
!      USE FLDVAR
      USE usr
      USE discretelement
      USE EXIT, ONLY: MFIX_EXIT
      USE RUN
      USE COMPAR, ONLY: myPE
      USE Geometry
      USE indices
      USE eos
      USE fldvar


!from set_fluidbed.f
      USE bc
      USE bodyforce
      USE compar
      USE constant
      USE discretelement
      USE eos, ONLY: EOSG
      USE exit, only: mfix_exit
      USE fldvar
      USE functions
      USE funits
      USE geometry
      USE ic
      USE indices
      USE machine, only: start_log, end_log
      USE mpi_utility
      USE param
      USE param1
      USE physprop
      USE scales
      USE sendrecv 
      USE visc_s

      use RXNS

      use cutcell, only: xg_e, yg_n, zg_t
      use usr
      use param, only: DIMENSION_I, DIMENSION_J, DIMENSION_K
      USE mpi_utility, only: global_all_sum
      IMPLICIT NONE
      INTEGER  :: IJK, M, COUNT_CELLS, I,J,K, COUNT_CELLS_
      double precision :: SUM_ROPS, MF_m, SUMM, SAUTER, xi, ANGLE ! mass fraction
      DOUBLE PRECISION :: SUM_VEL, MEAN_BED_VELOCITY, V_S_TOT
      DOUBLE PRECISION :: EXPORT_DT, MINI, MAXI, TIME_START, peclet_sum, peclet_sum_slip, PECLET_AVERAGE, PECLET_AVERAGE_slip
!-----------------------------------------------
!
!  Include files defining common blocks here
!
!
!  Define local variables here
!
!
!  Include files defining statement functions here
!
!
!  Insert user-defined code here
      DO IJK = IJKSTART3, IJKEND3
         
        IF(EP_G(IJK)>0.5) THEN
          U_G(IJK) = 1.0
      !  V_G(IJK) = 0.0
      
        ENDIF
        ENDDO!
      
      !  DO IJK = IJKSTART3, IJKEND3
      !   xi = RO_S(IJK,1)/((RO_G(IJK)*((1.0/EP_S(IJK,1))-1.0))+RO_S(IJK,1))
      !  DO M = 1,MMAX
      !  write(111,*) IJK, X_S(IJK,M,1), M !xi, RO_S(IJK,1), RO_G(IJK), EP_S(IJK,1)  
      !  ENDDO
     !    IF(EP_G(IJK) <1.0) THEN
     !    U_S(IJK,MMAX) = ReactionRates(IJK,5)
     !    ENDIF
      !  ENDDO

      ! check for division by zero and set a value to identify empty cells:

       DO IJK = IJKSTART3, IJKEND3

        SUM_ROPS = SUM(ROP_S(IJK,1:MMAX))
        
        SAUTER = 0.0
        SUMM = 0.0
        DO M = 1,MMAX

           IF(SUM_ROPS>1.0D-12) THEN       ! ADJUST THRESHOLD

             MF_m = ROP_S(IJK,M)/SUM_ROPS
             SUMM = SUMM+(MF_m/D_P(IJK,M))
             SAUTER = 1.0D0/SUMM
!           IF(TIME>8.0) THEN
!           IF(IJK==22) THEN
!           write(89898,*) IJK, MF_m, SUMM, SAUTER
!           ENDIF
         !  ENDIF

           ELSE

              MF_m = -1.0D0               ! ADJUST VALUE TO INDICATE EMPTY CELL
              SAUTER = -1.0D0
           ENDIF
        !   SAUTER  = 1.0/SUMM
        !   write(111,*) IJK, M, D_P(IJK,M), MF_m, SUMM, SAUTER

          IF(M==2) THEN
           ReactionRates(IJK,13) = MF_m ! proportion of fines
          ENDIF
        ENDDO
          ReactionRates(IJK,12) = 1.0D0/(((1.0D0-MF_m)/D_P(IJK,1)) + (MF_m/D_P(IJK,2)))  !SAUTER  ! ERIC
          
        ENDDO

      ! calculate distance of flow from origin
         SUM_VEL = 0.0
         MEAN_BED_VELOCITY = 0.0
         COUNT_CELLS = 0
         
        DO IJK = IJKSTART3, IJKEND3
         IF(EP_G(IJK)<0.55) THEN  ! MAKES SURE THAT THE DILUTE PART DOESNOT COUNT 
          SUM_VEL = SUM_VEL + MAX(U_S(IJK,1),U_S(IJK,2)) 
          COUNT_CELLS = COUNT_CELLS + 1
         ENDIF
        ENDDO
        CALL GLOBAL_ALL_SUM(COUNT_CELLS)
        CALL GLOBAL_ALL_SUM(SUM_VEL)
        MEAN_BED_VELOCITY = SUM_VEL/COUNT_CELLS
        IF(TIME>0.0) THEN 
         DISTANCE =  DISTANCE + MEAN_BED_VELOCITY_OLD*DT! distance from source, using velocity of time step before
        ELSE
         DISTANCE = 0.0
        ENDIF
      
        MEAN_BED_VELOCITY_OLD = MEAN_BED_VELOCITY
      !  write(45,*) time, ReactionRates(IJK,14)
       
      !! Rotate gravity vector for rotating drum
      DELAY = 1.389E+01
      IF (TIME > DELAY) THEN
       ANGLE = 0.0 !ATAN(2.0D0/3.0D0*EXP(-DISTANCE/3000.0))
!Kelfoun 2011 slope (took derivative)   convert RPM to rad/s
      ELSE
       DISTANCE = 0.0
       ANGLE = ATAN(2.0D0/3.0D0*EXP(-DISTANCE/3000.0))
      ENDIF

   !    GRAVITY_X = sin(ANGLE)*GRAVITY
   !    GRAVITY_Y = -cos(ANGLE)*GRAVITY
   !    GRAV(1) = GRAVITY_X
   !    GRAV(2) = GRAVITY_Y
      
    !   WRITE(46,*) TIME, DT, MEAN_BED_VELOCITY, DISTANCE, ANGLE

       DO IJK = IJKSTART3,IJKEND3
        ReactionRates(IJK,14) = MEAN_BED_VELOCITY
        ReactionRates(IJK,15) = DISTANCE
        ReactionRates(IJK,16) = ANGLE*180/PI
       ENDDO

    !   DO IJK = IJKSTART3, IJKEND3
    !    WRITE(33,*) TIME, ep_star_array(ijk) 
    !   ENDDO

       
       DO IJK = IJKSTART3, IJKEND3
       ReactionRates(IJK,26) =(EP_G(IJK)**3.0d0)*(ReactionRates(IJK,12)**2.0d0)/(150*(1-EP_G(IJK))**2.0d0)! permeability
       ReactionRates(IJK,27) =ReactionRates(IJK,26)/(EP_G(IJK)*(1/P_G(IJK))*mu_g(IJK))! Diffusioncoefficient
       V_S_TOT = (ReactionRates(IJK,13)*V_S(IJK,2)+(1-ReactionRates(IJK,13))*V_S(IJK,1))
       ReactionRates(IJK,28) =ReactionRates(IJK,12)*V_S_TOT/ReactionRates(IJK,27)
       ReactionRates(IJK,30) =ReactionRates(IJK,12)*(V_S_TOT-V_G(IJK))/ReactionRates(IJK,27) ! Peclet VS-VG
! Peclet=deborah number = d*u_0/D
     !   if(time>1.0 .and. time<1.1)then
     !  write(11,*) ijk,ReactionRates(IJK,13),V_S(IJK,1),V_S(IJK,2),V_S_TOT
     !  ReactionRates(IJK,12),P_G(IJK),mu_g(IJK),ReactionRates(IJK,13),V_S(IJK,2),V_S(IJK,1),ReactionRates(IJK,26),ReactionRates(IJK,27),ReactionRates(IJK,28)
     !  endif
       ENDDO
       COUNT_CELLS_ = 0
       peclet_sum = 0.0
       PECLET_AVERAGE = 0.0
       DO IJK = IJKSTART3, IJKEND3
       IF(EP_G(IJK)<0.6 .and. ABS(ReactionRates(IJK,28))>0.0) THEN  !MAKES SURE THAT THE DILUTE PART DOESNOT COUNT
          peclet_sum = ReactionRates(IJK,28) + peclet_sum
          peclet_sum_slip = ReactionRates(IJK,30) + peclet_sum_slip
          COUNT_CELLS_ = COUNT_CELLS_ + 1
     !      write(12,*) IJK, EP_G(IJK),peclet_sum,COUNT_CELLS_
        ENDIF
        ENDDO
        CALL GLOBAL_ALL_SUM(COUNT_CELLS_)
        CALL GLOBAL_ALL_SUM(peclet_sum)
        CALL GLOBAL_ALL_SUM(peclet_sum_slip)
         PECLET_AVERAGE = peclet_sum/COUNT_CELLS_
         PECLET_AVERAGE_SLIP = peclet_sum_slip/COUNT_CELLS_
         DO IJK = IJKSTART3, IJKEND3
         ReactionRates(IJK,29) = PECLET_AVERAGE
         ReactionRates(IJK,31) = PECLET_AVERAGE_SLIP
         ENDDO
 
      !######################### !EXPORT AT REGULAR TIME STEPS

      NNN = ONE
      EXPORT_DT = 1.000E-01
      time_start = 0.0 - EXPORT_DT

      IF (TIME<((EXPORT_DT*NNN) + 0.5*DT)) THEN
      NNN = 1
      MINI = (EXPORT_DT*NNN) - 0.5*DT
      MAXI = (EXPORT_DT*NNN) + 0.5*DT
      MMM = 1
      ELSE
      MINI = (EXPORT_DT*MMM) - 0.5*DT
      MAXI = (EXPORT_DT*MMM) + 0.5*DT
      ENDIF

      MAXI = MAX(MAXI, MAXI_OLD)
      IF((TIME<MAXI .AND. TIME>MINI) )THEN
        MMM = MMM+1
 
      IF(TIME>time_start) THEN
      I = INT((IMIN3+IMAX3-1.0)/2.0)
      J = 3
      K = 1
      IJK = FUNIJK(I,J,K)
      IF (myPE == PE_IO) THEN
      write(123,123) TIME, P_G(IJK),EP_G(IJK),ReactionRates(IJK,1),ReactionRates(IJK,2),ReactionRates(IJK,3),ReactionRates(IJK,4),ReactionRates(IJK,5),ReactionRates(IJK,6),ReactionRates(IJK,7),&
      ReactionRates(IJK,8),ReactionRates(IJK,9),ReactionRates(IJK,10),ReactionRates(IJK,11),ReactionRates(IJK,12),ReactionRates(IJK,13),ReactionRates(IJK,14),ReactionRates(IJK,15),ReactionRates(IJK,16),DELAY, &
      mu_s(ijk,1),mu_s(ijk,2),P_s(IJK,1),P_s(IJK,2),I2_devD_s(ijk),RO_G(ijk),mu_g(ijk),ReactionRates(IJK,28),ReactionRates(IJK,29),ReactionRates(IJK,30),ReactionRates(IJK,31)
      ENDIF
      
      123 format (31(E20.10,2x))
    !  CLOSE (123)
      ENDIF
      ENDIF ! IF((TIME<MAXI .AND. TIME>MINI)
      MAXI_OLD = MAXI
       !###########################
      
   
       DO IJK = IJKSTART3,IJKEND3
       ReactionRates(IJK,17)=mu_s(ijk,1)
       ReactionRates(IJK,18)=mu_s(ijk,2)
       ReactionRates(IJK,19) = P_s(IJK,1)
       ReactionRates(IJK,20) = P_s(IJK,2)
       ReactionRates(IJK,21) = I2_devD_s(ijk)
       ReactionRates(IJK,22) = RO_G(ijk)
       ReactionRates(IJK,23) = mu_g(ijk)
       ReactionRates(IJK,24) = V_S(IJK,1)
       ReactionRates(IJK,25) = V_S(IJK,2)
       ENDDO 
      
      

      RETURN
      END SUBROUTINE USR1
