!vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvC
!                                                                      C
!  Module name: USR0                                                   C
!  Purpose: This routine is called before the time loop starts and is  C
!           user-definable.  The user may insert code in this routine  C
!           or call appropriate user defined subroutines.  This        C
!           can be used for setting constants and checking errors in   C
!           data.  This routine is not called from an IJK loop, hence  C
!           all indices are undefined.                                 C
!                                                                      C
!  Author:                                            Date: dd-mmm-yy  C
!  Reviewer:                                          Date: dd-mmm-yy  C
!                                                                      C
!  Revision Number:                                                    C
!  Purpose:                                                            C
!  Author:                                            Date: dd-mmm-yy  C
!  Reviewer:                                          Date: dd-mmm-yy  C
!                                                                      C
!  Literature/Document References:                                     C
!                                                                      C
!  Variables referenced:                                               C
!  Variables modified:                                                 C
!                                                                      C
!  Local variables:                                                    C
!                                                                      C
!^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^C
!
      SUBROUTINE USR0
!...Translated by Pacific-Sierra Research VAST-90 2.06G5  12:17:31  12/09/98
!...Switches: -xf

      USE usr
      USE discretelement
      USE EXIT, ONLY: MFIX_EXIT
      USE RUN
      USE COMPAR, ONLY: myPE
      USE Geometry
      USE indices
      USE eos
      USE fldvar


!from set_fluidbed.f
      USE bc
      USE bodyforce
      USE compar
      USE constant
      USE discretelement
      USE eos, ONLY: EOSG
      USE exit, only: mfix_exit
      USE fldvar
      USE functions
      USE funits
      USE geometry
      USE ic
      USE indices
      USE machine, only: start_log, end_log
      USE mpi_utility
      USE param
      USE param1
      USE physprop
      USE scales
      USE sendrecv

      use RXNS

      use cutcell, only: xg_e, yg_n, zg_t
      use usr
      use param, only: DIMENSION_I, DIMENSION_J, DIMENSION_K
      IMPLICIT NONE
      
 


!-----------------------------------------------
!
!  Include files defining common blocks here
!
!
!  Define local variables here
   !     INTEGER :: I, IJK
        DOUBLE PRECISION :: TOP_PRESSURE, MIXTURE_DENSITY, MOL_WEIGHT
        DOUBLE PRECISION :: GAS_TEMP
         
     



!-----------------------------------------------
! Local variables
!-----------------------------------------------
! indices
      INTEGER :: I, J, K, IJK, M
! Local loop counter
      INTEGER :: L, J_CHECK, CELL_BELOW, I_CHECK, CELL_LEFT, CELL_BEHIND, K_CHECK
! Gas pressure at the axial location j
      DOUBLE PRECISION :: PJ
! Bed weight per unit area
      DOUBLE PRECISION :: BED_WEIGHT
! Total area of a x-z plane
      DOUBLE PRECISION :: AREA, NO, FILTER_BINARY
! x-z plane area of one cell
      DOUBLE PRECISION :: dAREA, X_LENGTH, Z_LENGTH
! Average pressure drop per unit length
      DOUBLE PRECISION :: DPoDX, DPoDY, DPoDZ, HEIGHT, TOP_TROPOSPHERE
      double precision :: thickness_bed
!-----------------------------------------------

 integer :: BCV, MM
  

      IF(.NOT.ALLOCATED(XG_C)) Allocate( XG_C(0:DIMENSION_I) )
      IF(.NOT.ALLOCATED(YG_C)) Allocate( YG_C(0:DIMENSION_J) )
      IF(.NOT.ALLOCATED(ZG_C)) Allocate( ZG_C(0:DIMENSION_K) )

 !############# CALCULATE THE X_COORDINATE OF THE EACH CELL CENTER
      IF (DO_I) THEN
        XG_C(0:1) = X_MIN
        DO I = IMIN1, IMAX2
           XG_C(I) = XG_C(I-1) + DX(I) ! East face location
        END DO
        DO I = IMIN1, IMAX2
           XG_C(I) = XG_C(I) - 0.5*DX(I) ! Cell center
        END DO
      ENDIF

 !############# CALCULATE THE Y_COORDINATE OF THE EACH CELL CENTER
      IF (DO_J) THEN
        YG_C(0:1) = Y_MIN
        DO J = JMIN1, JMAX2
           YG_C(J) = YG_C(J-1) + DY(J) ! North location
        END DO
        DO J = JMIN1, JMAX2
           YG_C(J) = YG_C(J) - 0.5* DY(J) ! cell center
        END DO
      ENDIF

 !############# CALCULATE THE Z_COORDINATE OF THE EACH CELL CENTER
      IF (DO_K) THEN
        ZG_C(0:1) = Z_MIN
        DO K = KMIN1, KMAX2
           ZG_C(K) = ZG_C(K-1) + DZ(K) ! Top location
        END DO
        DO K = KMIN1, KMAX2
           ZG_C(K) = ZG_C(K) - 0.5*DZ(K) ! Top location
        END DO
      ELSE
         ZG_C = ZERO
      ENDIF



      
   !##### ERIC: THIS CREATES A FILTER THAT HAS 0.0 VALUE IF GHOSTCELL AND 1.0 IF NOT
   ! for the LES filtering
        DO IJK = IJKSTART3, IJKEND3
           I = I_OF(IJK)
           J = J_OF(IJK)
           K = K_OF(IJK)
           IF(FLUID_AT(IJK)) THEN
              FILTER_BINARY  = 1.0 
           ELSE
              FILTER_BINARY = 0.0
           ENDIF
         !  ReactionRates(IJK,3) = FILTER_BINARY
           ReactionRates(IJK,4) = XG_C(I)
           ReactionRates(IJK,5) = YG_C(J)
           ReactionRates(IJK,6) = ZG_C(K)
         
         ! IF(ReactionRates(IJK,4)<9.62) THEN  !9.65 LENGTH OF CHANNEL TO BREAK OF SLOPE
         !  ReactionRates(IJK,7) = ReactionRates(IJK,5) - (9.62 - ReactionRates(IJK,4))* SIN(6*PI/180)-0.5*DY(J)  !HEIGHT OF CHANNEL
         !  ELSE
         !  ReactionRates(IJK,7) = ReactionRates(IJK,5) -0.5*DY(J)
         !  ENDIF
         !  ReactionRates(IJK,7) = MAX(0.0,ReactionRates(IJK,7))
        ENDDO
     
   ! thickness_bed = 5.0
   ! DO IJK = IJKSTART3, IJKEND3
   !  DO MM=1,SMAX
   !    U_S(IJK,MM) = 14.0*(ReactionRates(IJK,5)/thickness_bed)**0.485 ! 14 is max vel at top of bed
   !  ENDDO
   ! ENDDO


      RETURN
      END SUBROUTINE USR0
