## Lesson 5: **Open Science communities**



* Why engage with Open Science communities?
* What is a Community of Practice (CoP)?
    * Communities list
* How to engage with Open Science communities
    * Pathways for contribution
    * Pathways for collaboration
    * Pathways for engagement
        * Case Study: FORRT
* How to build and lead a community
    * Guidelines for building communities
    * Mountain of engagement

 


# Lesson 5: **Open Science communities. **(_Where to find (sustainable) support and help for identifying and using OS tools and resources?)_

This lesson is the fifth of OpenCore Module 5: Open Science Tools and Resources. It provides a curated list of communities supporting the dissemination of open principles and practices in research and beyond. The lesson complements the previous modules of the OpenCore Course by providing  supportive environments fostering the gradual integration of the Open Science concepts explained in them.

The transition to open science requires a profound cultural change in academia and research, and communities are at the heart of a comprehensive change strategy. Hence, it is often extremely helpful to gain the support and help of communities and initiatives that help implement, contextualize, and sustain your open science work. These communities and initiatives can often turn out to be reservoirs of knowledge that could help sustain your open science project in the long run. In this lesson,  you will be introduced to a number of communities that you could participate in and engage with to enhance your open science project experience.  

Fostering a culture of open scholarship practices through communities can bring unique benefits to learners, practitioners, and trainers. Even if different communities have different missions and scope, all are working towards integrating open scholarship principles into research and education and positively contributing to the advancement of research transparency, reproducibility, rigor, and ethics. 


## Why engage with Open Science Communities?



* Communities offer a low-entry point into improved research and pedagogical practices. As pedagogical communities welcome scholars from all levels, including early career researchers, they are an accessible space for all wishing to learn and practice open scholarship. By cutting across career stages, these communities, then, become essential to instilling the new and improved values and norms of open scholarship.
* Communities facilitate the co-creation of open scholarship training materials which are crucial in facilitating the integration of open scholarship into research projects. 
* Communities also offer a much-needed environment wherein scholars share individual experiences, identify common hurdles, and iteratively enhance their knowledge and advance addressing the unique challenges ensuing from members’ needs. 
* Through peer-to-peer exchanges, communities help create a culture of open scholarship, benefiting those within the community, and those that interact with it. 


## What is a community of practice?

<span style="text-decoration:underline;">📖</span>Communities of practice<span style="text-decoration:underline;">📖</span> are social learning spaces, where individuals come together to learn a new skill, exchange knowledge and experiences, gain new skills, and then apply what they've learned  in the contexts of their day-to-day work out of the community (ref)

Well-designed and managed communities of practice can support behavioral changes in individuals by connecting them and providing a safe environment where members can exchange ideas and best practices. They can also empower members with the freedom to set and accomplish goals that they are unable to attain on their own. (ref)


### Communities of practice list

List of communities sorted by country: [https://docs.google.com/spreadsheets/d/1cge1elDTEnTSxV_sa-HKmaIrHKV8rQMhkq_XhA9fjsQ/edit#gid=1101212462](https://docs.google.com/spreadsheets/d/1cge1elDTEnTSxV_sa-HKmaIrHKV8rQMhkq_XhA9fjsQ/edit#gid=1101212462)  

Old list: 

Repository where the map is created (WIP) [https://github.com/Open-Science-Community-Saudi-Arabia/CoP](https://github.com/Open-Science-Community-Saudi-Arabia/CoP) 

 Table will have Global CoPs whereas I added some of the local CoPs to a map here:

https://rpubs.com/batool/cops


<table>
  <tr>
   <td><strong><em>Software Communities</em></strong>
   </td>
   <td><strong><em>Data Communities</em></strong>
   </td>
   <td><strong><em>Gender Inclusive Communities</em></strong>
   </td>
   <td><strong><em>Research-based Communities</em></strong>
   </td>
   <td><strong><em>Pedagogical & Education Communities</em></strong>
   </td>
   <td><strong><em>Community of communities</em></strong>
   </td>
  </tr>
  <tr>
   <td><a href="https://pydata.org/">PyData</a>
   </td>
   <td><a href="https://www.openaire.eu/">OpenAIRE</a>
   </td>
   <td>R-Ladies
   </td>
   <td>UKRN (and other national networks)
   </td>
   <td>FORRT
   </td>
   <td><a href="https://www.cscce.org/">CSCCE</a>
   </td>
  </tr>
  <tr>
   <td><a href="https://scientific-python.org/specs/">SPEC</a>
   </td>
   <td><a href="https://spdf.gsfc.nasa.gov/">SPDF</a>
   </td>
   <td>PyLadies
   </td>
   <td>PSA
   </td>
   <td>ReproducibiliTea
   </td>
   <td><a href="https://openlifesci.org/">OLS</a>
   </td>
  </tr>
  <tr>
   <td><a href="https://ropensci.org/">rOpenSci</a>
   </td>
   <td><a href="https://ccmc.gsfc.nasa.gov/">CCMC</a>
   </td>
   <td>Julia Gender Inclusive Community
   </td>
   <td>SIPS
   </td>
   <td>ProjectTIER
   </td>
   <td><a href="https://www.ukrn.org/international-networks/">Reproducibility Networks</a>
   </td>
  </tr>
  <tr>
   <td><a href="https://www.pyopensci.org/">pyOpenSci</a>
   </td>
   <td><a href="https://www.rd-alliance.org/">RDA</a>
   </td>
   <td><a href="https://www.linkedin.com/company/84894279/">Women of Color Code</a>
   </td>
   <td>CREP
   </td>
   <td>SIOS
   </td>
   <td><strong><em><a href="https://deeplearningindaba.com/2022/">Deep Learning Indaba</a> (collective African ML community)</em></strong>
   </td>
  </tr>
  <tr>
   <td><a href="https://heliopython.org/">PyHC</a>
   </td>
   <td>
   </td>
   <td>Women who code
   </td>
   <td>OpenMOOC
   </td>
   <td>CREP
   </td>
   <td><strong><em><a href="https://deeplearningindaba.com/2022/indabax/">Deep Learning IndabaX</a> chapters - different countries in Africa</em></strong>
   </td>
  </tr>
  <tr>
   <td><a href="https://society-rse.org/">Research Software Engineering</a>
   </td>
   <td>
   </td>
   <td>
   </td>
   <td>IGDORE
   </td>
   <td>NowhereLab
   </td>
   <td><strong><em><a href="https://www.astronomiskungdom.se/swedish-astronomical-youth-association/">Swedish Youth Astronomical Society</a> - </em></strong>official emails can be sent to: kansli@astronomiskungdom.se
   </td>
  </tr>
  <tr>
   <td><a href="https://numfocus.org/">NumFOCUS</a>
   </td>
   <td>
   </td>
   <td>
   </td>
   <td>Centre for HelioAnalytics
   </td>
   <td>RIOT
   </td>
   <td>
   </td>
  </tr>
  <tr>
   <td>
   </td>
   <td>
   </td>
   <td>
   </td>
   <td>FORRT
   </td>
   <td>ReplicationWiki
   </td>
   <td>
   </td>
  </tr>
  <tr>
   <td>
   </td>
   <td>
   </td>
   <td>
   </td>
   <td><strong><em>z</em></strong>
   </td>
   <td>Open Education Group
   </td>
   <td>
   </td>
  </tr>
  <tr>
   <td>
   </td>
   <td>
   </td>
   <td>
   </td>
   <td><strong><a href="https://www.masakhane.io/">Masakhane</a><em> - A grassroots NLP community for Africa, by Africans</em></strong>
   </td>
   <td>Open Education Network
   </td>
   <td>
   </td>
  </tr>
  <tr>
   <td>
   </td>
   <td>
   </td>
   <td>
   </td>
   <td><strong><a href="https://www.sisonkebiotik.africa/">SisonkeBiotik </a><em>- Lowering barriers in participatory research for machine learning and health across Africa </em></strong>
   </td>
   <td>NASA HEAT
   </td>
   <td>
   </td>
  </tr>
  <tr>
   <td>
   </td>
   <td>
   </td>
   <td>
   </td>
   <td><strong><a href="https://bhki.org/">Bioinformatics Hub of Kenya Initiative</a></strong>
   </td>
   <td>The Carpentries
   </td>
   <td>
   </td>
  </tr>
  <tr>
   <td>
   </td>
   <td>
   </td>
   <td>
   </td>
   <td>
   </td>
   <td>ABRIR
   </td>
   <td>
   </td>
  </tr>
  <tr>
   <td>
   </td>
   <td>
   </td>
   <td>
   </td>
   <td>
   </td>
   <td>Open Hardware Community
   </td>
   <td>
   </td>
  </tr>
  <tr>
   <td>
   </td>
   <td>
   </td>
   <td>
   </td>
   <td>
   </td>
   <td><strong><em><a href="https://www.astronomiskungdom.se/swedish-astronomical-youth-association/">Swedish Youth Astronomical Society</a> - </em></strong>official emails can be sent to: <a href="mailto:kansli@astronomiskungdom.se">kansli@astronomiskungdom.se</a>
   </td>
   <td>
   </td>
  </tr>
</table>



## How to engage with Open Science communities

There are various ways through which you can start engaging with a community. Usually the websites of most of the communities provide information on where a new member can join a community platform and get involved. If there is a **newsletter** available, you can subscribe to it to know more about the activities taking place within the community. Communities may also have a presence on **platforms like Twitter, Facebook, and LinkedIn** where they might make announcements about their upcoming initiatives. **Community co-working platforms** are excellent places to get to know more and interact with current members. Some of the communities also provide onboarding calls that provide a chance of joining the community in a more formal way. 

For individuals  who prefer written interactions and discussions, **GitHub discussions, Discourse, StackOverFlow,** and **Slack spaces** could be excellent to start with. Such written platforms tend to have lots of past knowledge and interactions available that give newcomers an idea of the discussions that take place within a particular community. While all these are excellent places to start with and ask questions, one should be mindful of the fact that most communities are volunteer-run and located across various time zones, hence sometimes it might take longer than usual to receive a response. Always try to be kind, patient, and appreciative.


### **Pathways for contribution**

It is no surprise that newcomers in a community often go on to become future contributors if they find the right pathway. These pathways are explained using personas in the [Contributor Pathways](https://the-turing-way.netlify.app/project-design/persona/persona-contributors.html?highlight=community%20practice) subchapter of The Turing Way book. This subchapter defines the different phases of community membership, as below:



1. Discovery - How an individual first hears about the project or group or community
2. First Contact - How they first engage with the project or group or community, their initial interaction.
3. Participation - How they first participate or contribute.
4. Sustained Participation - How their contribution or involvement can continue.
5. Networked Participation - How they may network within the community.
6. Leadership - How they may take on some additional responsibility on the project, or begin to lead.

Top Tip: Many communities and open source projects participate in [Google Summer of Code](https://summerofcode.withgoogle.com/archive/) and [Outreachy. ](https://www.outreachy.org/)There are many contributors who had their first contact with open science through [Google Summer of Code](https://summerofcode.withgoogle.com/archive/) and [Outreachy](https://www.outreachy.org/), and then developed into core contributors with leadership positions. 



<p id="gdcalert5" ><span style="color: red; font-weight: bold">>>>>>  gd2md-html alert: inline image link here (to images/image5.png). Store image on your image server and adjust path/filename/extension if necessary. </span><br>(<a href="#">Back to top</a>)(<a href="#gdcalert6">Next alert</a>)<br><span style="color: red; font-weight: bold">>>>>> </span></p>


![alt_text](images/image5.png "image_tooltip")



### Pathways for collaboration

There are different ways to collaborate with a community or open project. Contributions spread over many pathways which include sharing resources, reviewing and updating other contributions, fixing typos, improving documentations, mentoring other contributions, or helping in localisating the project and the resources within the project to different languages to support and satisfy the needs of multiple locales**. Many of the communities have a low-entry point and don't require expertise in open science or its digital tools.  **

The image below shows some pathways of collaboration in the Turing Way, which is an open-source, community-led guide to reproducible, ethical and inclusive data science. Other communities of practices have similar pathways that allow you to interact with their community members without little know-how in open science. 



<p id="gdcalert6" ><span style="color: red; font-weight: bold">>>>>>  gd2md-html alert: inline image link here (to images/image6.png). Store image on your image server and adjust path/filename/extension if necessary. </span><br>(<a href="#">Back to top</a>)(<a href="#gdcalert7">Next alert</a>)<br><span style="color: red; font-weight: bold">>>>>> </span></p>


![alt_text](images/image6.png "image_tooltip")



### Pathways for engagement

Communities of Practice are designed to offer plural and creative ways to engage with its members. Perhaps the easiest way a member can interact with the community is to introduce yourself on the community’s platform. Another low-stake engagement is to share a relevant resource with the community in appropriate channels. Asking a question, or raising a point of discussion on the community platform, is not only welcomed but potentially instructive and beneficial to other members and the community. 

Frequently, communities provide opportunities to give feedback—positive or negative, anonymous or not—which can be very useful to community managers and organizers. Communities of Practice often hold regular meetings—and some also hold seminars featuring pertinent content—and attending these meetings is another form to engage with OSCs. 

Some communities offer ways for members to submit resources they know to a database so that others can find it, enriching the community. Reading and learning from a Community of Practice’s own resources and approach is certainly one of the best ways to engage with it. Members can also engage with the community of practice by spreading the word or taking part in ambassadorship programs, which aim to (briefly) train members on the main issues a community is trying to tackle or improve. 

As open communities tend to produce resources themselves, and most do so in one language (at least at first), translation efforts are fairly commonplace. These are extremely advantageous to those who would otherwise be disenfranchised and help foster an inclusive and accessible community atmosphere. A mutually beneficial pathway is to contribute to a community’s existing projects and resources which often require constant review and update of its substantive content. 

Folks with technical skills can volunteer their expert skills to maintain and improve the community's internal documentation, resources, modus operandi, databases, code of conduct, and website. Some communities offer mentored contributions on a community-supervised project - for example, in the context of STEM & Data Science - while others offer different types of mentorships such as helping with the supervision of Bachelor/Undergraduate or Master/Graduate  theses. 

Research- and education-oriented communities of practice often tackle projects collaboratively where members can take part in the process of science-making. Members can join these projects and contribute to them, and be acknowledged for their efforts and work. Some communities extend further on this open-collaboration ethos to allow its members to propose new ideas for research and educational projects. 


#### Case study: FORRT

FORRT stands for the Framework for Open and Reproducible Research Training. It is an interdisciplinary Community of Practice of almost 500 early-career scholars aiming to integrate open scholarship principles into higher education and to advance research transparency, reproducibility, rigor, and ethics through pedagogical reform and meta-scientific research.  \
Anyone interested in engaging with FORRT can visit its website ([forrt.org](https://forrt.org/)) and find an explanation of the initiative’s mission, its projects, its open educational resources, and its publications. 

Interested individuals can find ways to get involved in several places, with specific attention to FORRT’s [Slack community](https://join.slack.com/t/forrt/shared_invite/zt-alobr3z7-NOR0mTBfD1vKXn9qlOKqaQ). Once a member enters the community, they are given access to three main channels:[ #-welcome-and-introductions](https://forrt.slack.com/archives/CM8812VSS), where anyone can introduce themselves and be welcomed by our community members; [#-general-interest-posts-and-announcements](https://forrt.slack.com/archives/CM63UEYF7), where anyone can share resources, links, and projects, ask a question, publicize other relevant communities of practice, start discussions, etc.; and [#-forrt-community](https://forrt.slack.com/archives/CM6344P5E), where organizers post about onboarding, projects, people, etc.  \
 \
After joining the Slack, a bot sends a DM to users with onboarding information and the ‘[Getting Started with FORRT](https://docs.google.com/document/d/17ECRs6J8spO3CU6siheGL8weQ-TzdyAUpXIiIE8cUeI/edit?usp=sharing)’ document, containing important links, a code of conduct,  a description of FORRT’s collaborative projects (their teams, leads, and Slack channels), how FORRT is structured organizationally,  and a description of FORRT’s contributorship model and guidelines. Folks can [submit resources](https://forrt.org/resources) to a database of curated open science resources, give [(anonymous) feedback](https://forrt.org/feedback/), subscribe to [mentorship programs](https://forrt.org/dei), and learn how to [contribute to FORRT’s research & educational projects](https://forrt.org/about/get-involved/) (including inclusion, reviewing, and translations efforts— e.g., project [Reversals](https://forrt.org/reversals), [Glossary](https://forrt.org/glossary) and [Summary](https://forrt.org/summaries)). Lastly, members can propose research and educational projects in the [#team-ideas](https://forrt.org/reversals) channel. 


## How to build and lead a community

_ \
_As individuals,  we look for opportunities to apply our knowledge to address problems. The most recent example of this is how the research community has reacted to the pandemic by organizing an unexpectedly large number of hackathons, data modeling initiatives, task forces, and working groups. While joining existing communities can provide rich learning experiences, at times we might realize the need to build a new community. Such communities might come into existence when we discover a lack of a community of our interest close to our geographical region, when we meet like-minded individuals closer to our existing time zones, or when we learn how other communities are developing in their local regions.

A key aspect in building community is to design and build projects that empower others to collaborate within inclusive spaces. Openness shouldn’t be a thoughtless default, but something that is consciously designed into what you and your team are doing, while carefully thinking about the ethics and implications at every step.  


### Guidelines for building communities

In this section, we have assembled suggestions from the Turing Way, which are derived from the experiences of community and technical specialists to assist researchers in addressing this challenge, particularly when launching a community or a team-oriented project.



<p id="gdcalert7" ><span style="color: red; font-weight: bold">>>>>>  gd2md-html alert: inline image link here (to images/image7.png). Store image on your image server and adjust path/filename/extension if necessary. </span><br>(<a href="#">Back to top</a>)(<a href="#gdcalert8">Next alert</a>)<br><span style="color: red; font-weight: bold">>>>>> </span></p>


![alt_text](images/image7.png "image_tooltip")




* Choose a Communication Platform
* Provide a Project Summary File
* Select a Code of Conduct
* Provide Contribution Guidelines and Interaction Pathways
* Create a Basic Management/Leadership Structure
* Provide Contact Details Wherever Useful
* Identify Failed Approaches, and Stop Them
* Have Documentation and Dissemination Plans for Your Project

You can find more details about these guidelines within the [Turing Way](https://the-turing-way.netlify.app/collaboration/new-community.html) and contribute to refining them further. 



<p id="gdcalert8" ><span style="color: red; font-weight: bold">>>>>>  gd2md-html alert: inline image link here (to images/image8.png). Store image on your image server and adjust path/filename/extension if necessary. </span><br>(<a href="#">Back to top</a>)(<a href="#gdcalert9">Next alert</a>)<br><span style="color: red; font-weight: bold">>>>>> </span></p>


![alt_text](images/image8.png "image_tooltip")



### Mountain of engagement



1. **_Leading_**: A high-touch relationship; we maintain relationships and co-branded events and trainings with alumni and allies to increase the impact, prestige, and reach of both parties’ work.
2. **_Collaborating:_** A high-touch relationship; we offer professional development through our own events in return for co-creation, localization, and spread.
3. **_Participating:_** A high-touch relationship; we offer community management and professional development through our own trainings and events in return for soliciting ideas & learning through use.
4. **_Endorsing:_** A low-touch relationship; we share information with people who gain social capital by spreading it and networking with others who share common interests.
5. **_Learning:_** A low-touch relationship; we gift resources like open curriculum and get back aggregate data (like downloads, registrations, and views) showing people use our resources and pay attention to us.



<p id="gdcalert9" ><span style="color: red; font-weight: bold">>>>>>  gd2md-html alert: inline image link here (to images/image9.png). Store image on your image server and adjust path/filename/extension if necessary. </span><br>(<a href="#">Back to top</a>)(<a href="#gdcalert10">Next alert</a>)<br><span style="color: red; font-weight: bold">>>>>> </span></p>


![alt_text](images/image9.png "image_tooltip")


Model describes four modes of member engagement that can occur within a community – CONVEY/CONSUME, CONTRIBUTE, COLLABORATE, and CO-CREATE (Need to expand).



<p id="gdcalert10" ><span style="color: red; font-weight: bold">>>>>>  gd2md-html alert: inline image link here (to images/image10.png). Store image on your image server and adjust path/filename/extension if necessary. </span><br>(<a href="#">Back to top</a>)(<a href="#gdcalert11">Next alert</a>)<br><span style="color: red; font-weight: bold">>>>>> </span></p>


![alt_text](images/image10.png "image_tooltip")



## _Open Science Skills with the Communities; learning and practicing_

_Skills for Open Science are vast https://libereurope.eu/article/open-science-skills-diagram/ _

_Many of them - as you saw from the Modules XYZ, and Lessons XYZ of this Module are digital, data and information skills. _



* _Data skills - The Carpentries teaches foundational coding and data science skills to researchers worldwide._
* _Conceptualization, mentoring, Community building, ethos, inclusivity - Open Life Science_
* _Open Hardware - OHM_
* _FORRT?_
* _Scientific Collaboration and Community Engagement - CSCCE_
* _TOPS (this course) community - future is now_


## _Self-assessment: Questions for reflections_



* _Idea: envision questions on reflection in relation to communities, are you a part of any community? What is the value that you take from it? What do you bring to it? Does the balance seem right? What next 3 simple steps could be done to change it, to improve?_
