# Lesson 4: Providing Equitable Opportunities and Credit for Contributors to Results

## Introduction

> **If I have seen further it is by standing on the shoulders of Giants.**
> 
> *Turnbull, H. W. ed., 1959. The Correspondence of Isaac Newton: 1661–1675, Volume 1, London, UK: Published for the Royal Society at the University Press. p. 416*

If you are a researcher, regardless of your career stage, chances are you are not working alone. And even if you are working alone on any given project, your work likely builds on the work of others. And just like that, others after you will build on your work, advancing our understanding of the world and beyond.

In the previous lessons of this module, we defined open results and talked about ways you can frame your research so that all your outputs are open. We also spent some time explaining why sharing your results openly avoids "reinventing the wheel" by reusing existing work, saves time and increases efficiency, and facilitates collaboration and onboarding of new members.

In this lesson, we will talk about authorship and contributorship, and dive deeper into why open results matter, specifically talking about how openly communicating your results can open up doors to unforeseen opportunities for collaborations. We will also provide you with guidelines on how to ensure contributions to your current or future work happen equitably, maximizing the chances of fair and successful collaborations. Finally, we will briefly go over how you can contribute to others' open results in a way that helps your colleagues improve their work and work towards shared research goals.

## How do we define contributors to each research object and determine their suitable form of credit?

### Defining authors and contributors to your project

Too often conversations about contribution and authorship take place towards the end of a project or right when a scientific publication is drafted. However, as we learned in the previous lessons, research outputs are generated throughout the lifetime of a research project. To share them as open results in different stages of research, we should build an agreement for how authorship and contributorship in the project will be managed. This requires collaboratively defining what is considered authorship in your project, who among the current contributors is going to get authorship, who will get acknowledged as a contributor, who goes first and last in the list of a scientific publication, and who makes these decisions.

First and foremost, we need to remember that _anyone_ who has contributed to the research project must have their contributions recognized. With that shared understanding, in this lesson, we will explore what those recognitions as contributors or authors in your research project might look like.

**First, let's define what a contributor is:**

A **contributor** of research output is an individual who has contributed to any activity that made it possible for the open result to be published or shared. This includes the person(s) who first conceptualized the idea and designed the work, the project lead, external advisors, general mentors, the students, researchers, research assistants who conducted or helped conduct the experiments, the people who set up the tools essential for conducting the research, data stewards, the software developers, support staff, the project management team, the colleague(s) who provided feedback to the open results, as well as any collaborator. [[reference](https://the-turing-way.netlify.app/collaboration/shared-ownership/shared-ownership-projects.html)]

Depending on the type of contributions, some of these people should be recognized as authors of the open result, while others are appropriately acknowledged as contributors.

**Now, let's define authorship:**

According to the definition provided by the International Committee of Medical Journal Editors (ICMJE) which is widely accepted in biomedical disciplines:

An **author** of an open result is a contributor who has given a substantial contribution to the conception or design of the work or the acquisition, analysis, or interpretation of the data for the work. Additionally, an author is a contributor who has contributed to drafting or revising critically the work providing important intellectual content. An author is also someone who has approved the final version of the open result and agrees to be accountable for all aspects of the work and for the integrity of all other co-authors. [[reference](https://www.icmje.org/recommendations/browse/roles-and-responsibilities/defining-the-role-of-authors-and-contributors.html)]

There are several other definitions of authorship which vary across disciplines and describe how they relate to different research outputs. For instance, the [COPE Authorship Discussion Document](https://publicationethics.org/files/COPE_DD_A4_Authorship_SEPT19_SCREEN_AW.pdf) indicates that minimum requirements for authorship are 1) substantial contribution to carrying out the work and 2) accountability for the work conducted and shared in a publication. Authoring a research manuscript that is published in a peer-reviewed journal, for example, is widely considered one of the most valuable currencies for career advancement, promotion, funding opportunities, and overall chance of being recognized by the research community.

Given the weight traditionally placed on authorship in scientific publication and the fuzziness of the definitions (that often contain relative terms such as "substantial" or "extensive" leaving too much room for interpretation), it is not surprising that determining who amongst the contributors gets to be an author can lead to biased or unfair decisions, disputes between contributors, or at the very least leave someone resentful and feeling unappreciated.

To avoid these challenges, in the next section, we are going to provide some tips on how to determine who amongst the contributors is recognized as an author, as well as how to ensure all contributions to the open result are recognized fairly beyond authoring papers.

### How to fairly determine authorship contributions

We established that _all__contributors to an open result should be acknowledged for their contributions_. That said, the research team should first decide who amongst the contributors gets to be recognized as an author and how all the other "non-author" contributors are properly acknowledged in the open result (next section).

The National Institute of Health (NIH) provides a useful schematic representation to help with the first decision (Learn more: Colbert, M. C., Nussenblatt, R. B., & Gottesman, M. M. (2018). Integrity in Research: Principles for the Conduct of Research. Principles and Practice of Clinical Research (Fourth Edition). Academic Press. doi: [10.1016/B978-0-12-849905-4.00003-4](https://www.sciencedirect.com/science/article/pii/B9780128499054000034?via%3Dihub)):

![General guide for authorship contributions should be given based on contribution, originality, and active involvement. Authorship and aknoledgement should be decided on case by case basis for all stages of research cycle.](figures/authorship-guide.jpg)

*Figure 1: Example authorship guidelines from NIH: [https://oir.nih.gov/system/files/media/file/2021-08/guidelines-authorship\_contributions.pdf](https://oir.nih.gov/system/files/media/file/2021-08/guidelines-authorship_contributions.pdf) (Colbert et al, 2018) DOI: [10.1016/B978-0-12-849905-4.00003-4](https://doi.org/10.1016/B978-0-12-849905-4.00003-4)*

Even if guidelines like this one can help establish authorship and contributorship(see others cited below), it is rarely an easy "yes-no" (or for the image: "purple and green" decision). The power imbalance between project leads and students, for example, can often mean that members treated unfairly are the contributors with the least power.

Power dynamics amongst the team of contributors need to be acknowledged and discussed openly. Hierarchies and power imbalances can be due to many factors. The most obvious and somewhat accepted in academia are levels of seniority: those with more experience, and those who have been around longer tend to hold the most power. But other, sneakier factors are the legacy of a whole set of systems and structures that have oppressed groups of people for longer than we can remember. Academia and science are no exception. These systems of oppression include sexism, racism, white supremacy, heterosexism, ableism, and many more. It is important to recognize the implications of living in a society where people with less power and privileges continue to get disadvantaged by those systems and to become aware of the resulting biases that may consciously or unconsciously affect our choices.

We can even go further and try our best to correct those biases by intentionally deciding to make up for some of the inevitable shortcomings of which we may be unaware or may not have the lived experience.

**That is bringing an equity lens to our work.**

Equity is another word for fairness or levelling the playing field. **Equity** is an approach that recognizes that the magnitude of systemic barriers posed to a particular person will vary based on their gender identity, race, geographic location, class, age, ability, sexual orientation and other factors. Equity recognizes that different people will need different amounts of resources or support to succeed and overcome these barriers.

If you decide to bring an equity lens to this discussion, consider how you, with your powers and privileges, may be able to help others get a seat at the table. Let's say, for example, that you are a postdoc and the leading author of a research project. A rotating student spends 4 months in the lab helping you set up and perfect the experimental protocol that you will then use to carry out the experiments needed to answer your research question. They may even help you collect some preliminary data, but then they leave and later decide to join another lab. It may be tempting to not include them as authors in the final work and not even acknowledge them as contributors—which would be unethical. However, if you think that they have provided significant help and contributed to the success of your experiment, you should consider giving them authorship, perhaps contacting them to help write the methods section of the manuscript. You would give this student a huge opportunity to be cited and seen as a professional researcher.

Another aspect that can lead to unfair and unethical authorship recognition is the position of the author in the author list. Usually, the first author slot is reserved for the main contributor who has provided the largest contribution to the open result, someone who has been responsible for the work ideation, implementation, and completion carrying it all the way to publication. The last author is generally the group leader or principal investigator who has overseen the project from ideation to completion, providing mentorship and substantial contribution to the open result composition. The authors in the middle tend to be grouped as all the other contributors who have passed the "authorship test", while disregarding the specific contribution each of them made to the project. Once again it seems that even if a contributor is recognized as an author, every time an open result is set to be published or shared, there is an opportunity for the genuine mistake, misunderstandings, and even plain exploitation and unethical behaviour [Fleming, N., 2021].

One of the best ways to avoid conflicts and unfair authorship assignments is to _be intentional about it and plan ahead_ by creating an authorship and contributorship document or guideline for your project!

Below are some tips to guide you in implementing your version of a more ethical and just authorship assignment approach by **establishing authorship and contributor guidelines for your research group** [[reference](https://the-turing-way.netlify.app/communication/aa/aa-tips.html)] **.**

- **Search for existing guidelines** (some are linked in this lesson) and use them as a starting place to create your own set of guidelines. In doing so, seek advice from open science colleagues where you are (starting with librarians).
- **The guidelines should include language to help guide the discussion around explicit recognition of power dynamics.** These are not easy conversations and having language in the guidelines that acknowledge the need for having a conversation around power dynamics helps make it happen as part of the shared norms of the group. This can include prompts to assess the position of the contributor within the team (such as the principal investigator (PI) whose name is attached to the grant funding, the student who just joined the group, and the staff scientist who has worked in the lab for 4 years) and their role and responsibilities in the context of the project implementation (such as the student is the one who wrote the first draft of the research proposal and is going to carry out the experiments, the PI co-wrote and submitted the research proposal and will supervise the whole project, the staff scientist is the one who is going to carry on the statistical analysis and the postdoc is going to help mentor the new student and teach them the technique).
- **Make sure all members of your research group have the opportunity to contribute to the guidelines.** You can draft the initial document, but then ask for constructive and honest input from the other members of your team. If new members join, make sure they are properly onboarded and have a chance to comment on the existing guidelines, especially if they are brought in as contributors to an ongoing project.
- **Re-evaluate and seek explicit agreement over the guidelines at the beginning of every new research project.** If someone does not agree to the guidelines, try to mediate an open conversation about why they don't agree, trying to find a common ground amongst the contributors. If the disagreement remains, you can consider having your team vote and follow what the majority chooses.
- **The guidelines should include instructions for contributors on how to report unethical deviations from the policy** to someone other than the group leader (this could be the Chair of the department, a dedicated office at the research institution, or the funder of the project).
- **At the time of publication of the open result check for any existing policy associated with the platform used for publication (such as provided by a journal).** If the policy does not align with yours, present your reasoning and negotiate with the platform. Also make sure that if the criteria you use to determine authorship deviate, you have a space to clearly state the change in the open result.
- **Make the guidelines publicly available.** If you have a group's website you can post it there, and/or you can decide to create a version of the record and point to a permanent identifier such that the link never breaks by publishing the guidelines on a public repository (such as GitLab/GitHub or [Zenodo](https://zenodo.org/)).

Speaking of power imbalances, one thing you may be wondering if you are not the group leader is, _how on earth am I going to bring this up to my research group is not at all on board with open science practices or simply has never thought of having explicit authorship and contributorship guidelines?_ Well, there is no one right way to do this, but one suggestion we can give you is to learn about it and then present an outline of the guidelines to your next group meeting. Even if the work should not be on one person, oftentimes the main barrier to having something done is to initiate discussion and create that initial draft to which others can contribute. So, if you are up for it and are committed to implementing open results practices, we recommend that you take that first step and then try to persuade others to join in. In most cases, your colleagues will be grateful and hopefully contribute to composing the guidelines. Check out the lesson on why and incentives for additional resources around the benefits of adopting open science practices (as discussed in the Ethos of Open Science module [addlink-ethos]).

#### Resources for additional contexts

- The Contributor Roles Taxonomy or CRediT ([https://credit.niso.org/](https://credit.niso.org/)) is a high-level taxonomy that is increasingly being used to attribute different kinds of contributions made to scientific scholarly output. These include ​​​​conceptualization, data curation, formal analysis, funding acquisition, investigation, methodology, project administration, resources, software, supervision, validation, visualization, writing of original draft, reviewing, and editing. In practice, the success of this authorship approach relies on all authors openly acknowledging the importance of everyone's contributions ([see an example by Living with Machine team](https://livingwithmachines.ac.uk/highlighting-authors-contributions-and-interdisciplinary-collaborations-in-living-with-machines)).
- The Committee on Publication Ethics (COPE) ([https://publicationethics.org/authorship](https://publicationethics.org/authorship)) offers guidelines to understand ethical authorship.
- The Declaration on Research Assessment (DORA) ([https://sfdora.org/](https://sfdora.org/)) is also a good resource to understand what researchers, institutions, funders and publishers can do to improve how researchers and the outputs of scholarly research are evaluated.
- The [Authorship and Contributions on Academic Articles](https://the-turing-way.netlify.app/communication/aa.html#) in The Turing Way offers content to learn more about academic authorship practices, misconducts, discipline-specific authorship traditions, large and equitable authorships, as well as "​​Tips on How to Get Authorship Right."

In the next section, we provide information on how to create **contributor guidelines** as a way to: a) acknowledge non-author contributors, and b) invite others who are not currently part of the research team to contribute to your project.

## How to create contributor guidelines that ensure equity, access, inclusion, diversity

![A hand drawn illustration shows that the traditional acknowledgement system is broken then it shows how we try to acknowledge them fairly. We have a contributors bot that catches all the contributors information and stores them in contributors record](figures/acknowledgement.jpg)

*Figure 2: The process of acknowledging contributors in *The Turing Way*. _The Turing Way_ project illustration by Scriberia. Used under a CC-BY 4.0 licence. DOI: [10.5281/zenodo.3332807](https://doi.org/10.5281/zenodo.3332807).*

### Contributor Guidelines

In addition to providing guidelines on how to assign authorship, you also want to have a system in place to fairly recognize the contributions of non-authoring contributors. Additionally, you may want to consider guiding contributions to your results after they are made open. Let's take a look at how you can go about this.

#### Crediting non-authors project contributors

The CRediT taxonomy captures some of those "non-author contributors" roles such as funding acquisition and project administration, but there is more to open results than scholarly outputs. This may include work associated with maintenance, community management, data stewardship, library and archiving, equity, diversity and inclusion efforts, funding, project management, scientific event organisation, training activities and more. We must ensure that there are processes in place to acknowledge, value and reward this hidden labour [D'Ignazio, C., & Klein, L., 2020].

You can consider adding a section to your authorship guidelines that specifically talks about how you will acknowledge non-authors contributors to different components of your open results.

#### Inviting others to provide feedback and contribute

Often in academia, external feedback is not sought out until we submit our manuscripts for publication to a journal or a conference in which case 2-3 reviewers, presumably experts in the field, are recruited by an editor to anonymously review your work. The process of peer review is a much-dreaded one as the expectation tends to be the one that feedback will set us back, keeping us from publishing our work, or attending a conference.

But it does not have to be that way. Together, we can build a future in which feedback from outside of those who are directly involved in the project is sought out sooner and is welcomed with a much more positive attitude. Of course, what you don't want is to get showered with non-constructive opinions or personal attacks, which is why it is important that you set the rules for contributions.

**Contributor guidelines** are documents that are often used in open source projects to guide potential project contributors in providing constructive feedback. They contain information about the project itself, links to various parts of the project, and, most importantly, a detailed description of _how_ to report errors (often called "bugs" in code jargon), suggest changes, and even request integration of large parts of code improving or adding features.

In the context of scientific research, the practice of having a document that accompanies results and explicitly states how and what type of feedback should be provided is not common. However, when you begin to make more and more of your results open at different stages of your research cycle, you may want to invite feedback to aspects of your work that you think need it the most. You also may benefit from guiding the way that feedback is received so that a) other people feel like it is okay to contribute, and b) your corresponding author's email doesn't get filled with non-constructive, not actionable and unclear advice.

Let's say, for example, that you and your team are drafting a research manuscript and are getting pretty close to having all the information in place for it to be shared as a preprint. This does not necessarily mean that it is in a stage that you would consider "final"—if such a stage even exists!—but it contains enough information so that others who are in the same or similar fields of research can understand what the work is about and correctly interpret your results. This may be a good time to solicit feedback from colleagues or the broader community, and maybe even guide it towards aspects of your work that you think would most benefit from review or contribution.

Maybe you want to drive the attention of your contributors to the Methods section where a statistical analysis that is uncommonly used for the kind of experiment you conducted is described. Or maybe you would like some feedback from people with data visualization expertise so that you can best present your data.

Where should you put your contributor guidelines? You may have one place on your website where you can write general contributor guidelines to any open result you and your team share and link to the guidelines in your open result themselves. The contributor guidelines document can be part of the authorship and contributorship document you prepared following the tips in the previous section. You may even want to publish a version of the record that has a permanent identifier so that the links would never "break". Repositories such as GitLab/Github and [Zenodo](https://zenodo.org/) would allow you to post versions of the original documents that would be linked to one another.

General contributor guidelines that also include the authorship guidelines we talked about in the previous section may look something like the sample template provided in 'Assessment 1' at the end of this lesson

#### Additional resources for reference

- For additional tips on how to acknowledge contributors, check out [Acknowledging Contributors The Turing Way](https://the-turing-way.netlify.app/community-handbook/acknowledgement.html).
- If working with online repositories such as GitHub, an app like '[all-contributors](https://allcontributors.org/)' bot is a great way to automate capturing all kinds of contributions, from fixing bugs to organizing events to improving accessibility in the project.
- More systematic work is being undertaken by [hidden REF](https://hidden-ref.org/) who constructed a broad set of categories ([https://hidden-ref.org/categories](https://hidden-ref.org/categories/)) that can be used for celebrating everyone who contributes to the research.
- There are several [research infrastructure roles](https://the-turing-way.netlify.app/collaboration/research-infrastructure-roles.html) like community managers, data stewards, product managers, ethicists and science communicators, who are also being recognised as valued members in research projects with an intention to provide leadership paths for technical and subject matter experts, even when their contributions can't be assessed in tangible or traditional outputs [[reference](https://the-turing-way.netlify.app/collaboration/research-infrastructure-roles.html)].

- The Declaration on Research Assessment (DORA) ([https://sfdora.org/](https://sfdora.org/)) is also a good resource to understand what researchers, institutions, funders and publishers can do to improve the ways in which researchers and the outputs of scholarly research are evaluated.

## How to ensure your open results are properly attributed and cited by others

A citation is a reference to a source, which can include any of the research objects described previously in this module, used in your underlying research work. Citation (and other forms of acknowledgement) have been the primary means by which researchers and scholars receive credit for their work. Put differently, citations have largely been the "reputation currency" of science. In this section, we will discuss various ways that you can ensure that your work is citable and that when it is cited, you are properly credited.

### Persistent Identifiers (PIDs)

Persistent identifiers or PIDs are an invaluable part of the citation process. They are long-lasting references to digital resources which allow you to reliably find and verify resources leveraging underlying metadata which is associated with the identifiers. More importantly, by using PIDs, you can take advantage of scholarly systems that can help you be more productive and efficient in sharing research outputs while further supporting the acknowledgement of your research. Also, by using PIDs you will be making your research findable, accessible, interoperable, and reusable or FAIR, essentially machine-readable, and responding to International and national efforts to open up science. The best way to understand the value of PIDs though is to look at two examples, ORCID iDs and DOIs (Digital Object Identifiers).

### ORCIDs

ORCID iDs or ORCIDs are long-lasting unique identifiers for researchers. [ORCID](https://orcid.org/) is an acronym for 'Open Researcher and Contributor ID'. A freely available service for researchers, ORCID is used globally. It is used to authenticate via a wide array of research systems but it is also increasingly recommended and even required by manuscript systems for preprints and journals ([introduction video](https://vimeo.com/495762735?embedded=true&source=video_title&owner=13723853) by ORCID).

ORCIDs address the challenges around disambiguating author names and distinguishing their works. So for instance, authors that share a common name do not have to worry about their research being mixed up and not associated with themselves. They are also useful towards supporting life changes where your name can change but where your work can still be associated via your ORCID. Of course, they also keep your data intact even if you change your legal name at any time.

While you can use ORCID for your profile, it also facilitates interoperability where entering your information once can save time on entering it into other research information systems. ORCID supports an array of research activities you are associated with from your roles and grants to peer reviews you have done and data you have created. By entering your ORCID and/or authenticating with other systems, they can reuse this information so you do not have to enter it again, but you can also have greater control over your record as well.

One way to demonstrate the benefit of interoperability via ORCID is by enabling auto-updating with [Crossref](https://www.crossref.org/) (digital identifier service for primarily preprints and journals) and [DataCite](https://datacite.org/) (Digital identifier service for data, software and other research objects). ORCID provides instructions on how to enable auto-updates with these services so you do not have to re-enter information from works and resources you have authored [[reference](https://support.orcid.org/hc/en-us/articles/360006896394-Auto-updates-time-saving-and-trust-building)]. By enabling this feature, you will get notifications when new works are connected with your profile and ready to be made public.

A good practice is to consistently use your ORCID and to provide ORCIDs upfront in research projects, for instance, creating a contributors resource (see [this example by The Turing Way](https://the-turing-way.netlify.app/afterword/contributors-record.html)) where this information can be easily accessed when resources are created over the life of a project (versus always having to dig up this information in various places).

### Digital Object Identifiers (DOIs)

Digital Object Identifiers or DOIs are unique, persistent identifiers provided for objects. The services mentioned above, Crossref and DataCite, both use DOIs, where Crossref primarily is for works such as journal articles, preprints, and book chapters, to name a few, while DataCite has been mainly used for datasets, software, and presentations. The two overlap in the types of research objects they cover, but DataCite is used more often by repositories to provide DOIs and Crossref is more widely used by publishers. Through these services, publishers and repositories are committed at least to the persistence of the overarching metadata about these objects and that links to them do not break or rot. URLs or links used on the web are known to break, move, or not be available while DOIs are intended to ensure that information about the objects that they are linked to is not lost.

While one of the advantages of using DOIs is maintaining persistent links to research objects that might normally be lost on project websites, another advantage is that you can use the underlying metadata associated with DOIs to help with certain tasks such as citing and reporting your activities. One such service that demonstrates this value is [CrossCite](https://citation.crosscite.org/). Enter a DOI, choose a citation style and then format. What normally takes time re-entering information and formatting took very little time. More and more, scholarly services are leveraging DOIs to automate workflows and help researchers reduce the amount of time it takes to do certain tasks like the one described above, but of course, a system like this is dependent on quality metadata and researchers using it.

Another advantage of using DOIs is that you can publish more aspects of your research, beyond just a paper, from data and software to presentations, and if done from the start, can be used to support the transparency and replicability of your research. Not only does this practice help towards recording how your research progressed, it can be used to respond to open science recommendations and requirements, but it is also just good scientific practice.

How can you use DOIs? One way to start and test how you can use DOIs is via a [sandbox](https://sandbox.zenodo.org/) service such as the one Zenodo provides. Anything you do in the Zenodo sandbox is not permanent and will be removed periodically. Once you are comfortable, you can move to use the actual public [Zenodo](https://zenodo.org/) service or some of the other repositories listed at [re3data](https://www.re3data.org/).

### All the PIDs

There are a number of persistent identifiers beyond the two examples above. A brief list can be found via [Project Thor](https://project-thor.readme.io/docs/project-glossary) but absent are other identifiers such as [RAiDs](https://ardc.edu.au/services/ardc-identifier-services/raid-research-activity-identifier-service/) (Research Activity Identifiers), [RRID - Research Resource Identification](https://scicrunch.org/resources), [ROR ids (Research Organization Registry)](https://ror.org/) and [IGSNs (International Generic Sample Number Organization)](https://www.igsn.org/). Determining what identifiers to use can be challenging but thankfully [national PID strategies](https://www.rd-alliance.org/national-pid-strategies-opportunities-collaboration-and-alignment) are highlighting identifiers to focus on, at least to start. ORCIDs for people. RORs for organisations. Crossref/DataCite DOIs for research works/objects. RAiDs for research projects. Grant ID (Crossref) for research funding.

### Limitations

Not all the systems are ready for identifiers. For instance, identifiers can be lost in research publications and it is best to provide context/annotate them. In the case of journal articles, you can include a bracketed description such as [Data set] or [Software] with the citation and DOI in your references section along with describing the identifiers used in data/software availability or sharing sections. Also, it is important to maintain consistency when using identifiers and citations so that it is clear what other researchers should cite and credit. For example, use the same citation/DOI on GitHub as compared to your website and in your publications.

## Self-assessment #1: Develop a contributor guideline for a future project you are considering

### Determining authorship and acknowledging project contributors

Many examples and templates for creating contribution guidelines and acknowledging contributors are available online. If you are starting a project from scratch, read this chapter for_ [_setting up your project_](https://the-turing-way.netlify.app/project-design/project-repo.html)_. You can directly clone/fork to start your repo with this_ [_template repository_](https://github.com/alan-turing-institute/reproducible-project-template) _by making changes appropriate for your project.

Following the guidelines, the specific contributions of all author and non-author contributors to a scientific work should always be outlined in a project output or open results. Below we provide one way to determine and attribute authorship. If your research team has previously developed contribution guidelines, we recommend reusing them as your team might be already familiar with them.

### TEMPLATE FOR ADDING YOUR AUTHORSHIP GUIDELINES

---

[HEADER]: Authorship guideline for [ADD PROJECT NAME]

Anyone who has contributed to the open results and is not already an author will be acknowledged as a contributor in the acknowledgements section of the open results.

**How to contribute to our open results**

_Our team is committed to openly sharing our results with the research community. We welcome contributions to our work in the form of general feedback or specific suggestions on particular aspects of our work._

_Open results for which we are seeking feedback are linked and listed below:_

- New research proposal - Link to pre-registered proposal
- Preprint - Link/persistent identifier (PID), like Digital Object Identifier (DOI) - particularly the methods section
- Protocols - Link/PID to a protocols repository such as [_protocols.io_](https://protocols.io/)
- Data - Link/PID
- Source code - Link/PID

We welcome feedback that is positive or negative as long as it is provided constructively. We would love to hear suggestions on how you would address any issue you may identify with the work, with as much clarity and examples as you may be able to provide.

Here are three ways you can provide us feedback:

1. You can send us an email at [provide a team email]. In the body of your email please specify what result you are providing us feedback on, and be as specific as you can in referring to the part that you are talking about so that we are most likely to understand the feedback. We also welcome questions. We will not respond to your email if the content is an attack on the work or our team. Without your explicit consent, we will not share the content of your email associated with your name outside of our team.
2. You can publicly review our preprint by leaving a comment on the preprint server (if this option is available)_
3. You can review our preprint on [add a link from the preprint server like_ [_PREreview.org_](https://prereview.org/) or [ArXiv](https://arxiv.org/)], where your review can be opened and attributed with an ORCID iD.

We thank you in advance for your time and willingness to help us improve our work.

**What to expect after you contribute**

If your feedback came via email and is not an attack on our work or team, we will make sure to reply to you in a timely manner—please give our team up to 2 weeks to get back to you.

If you wrote a review on PREreview or on the comment section of the preprint server, we would appreciate a quick email from you to let us know of your contribution. All reasonable feedback and comments will be addressed openly, or, if you prefer, we can reply via email.

If you give us consent either in the email or by posting your review under your real name, we will acknowledge you and your feedback in the next version of the open result.

If your feedback results in a substantial intellectual contribution to the work, we will contact you to discuss opportunities for authorship in the next version of the open result.

---

## Assessment #2: A case study

- Identify the contributors to each research object, at each stage in the research process.
- Were these contributors credited? If so, was their contribution credited fairly with best practices from open science? If not, what could have been done differently?
- Identify contributors that could have added value to different stages of your project and attribute their work fairly

## Assessment #3: Give citations for the Research Objects reused in your work

Generate a citation from a DOI associated with a dataset that you preserved in a repository, like, Zenodo, using the crosscite tool. Don't have a dataset DOI, note this for your future research. In the meantime, find a DOI for another one of your research objects, like a paper, and generate a citation using CrossCite.

## References

- Fleming, N. (2021). The authorship rows that sour scientific collaborations. In Nature (Vol. 594, Issue 7863, pp. 459–462). Springer Science and Business Media LLC. [https://doi.org/10.1038/d41586-021-01574-y](https://doi.org/10.1038/d41586-021-01574-y)
- D'Ignazio, C., & Klein, L. (2020). 7. Show Your Work. In Data Feminism. Retrieved from [https://data-feminism.mitpress.mit.edu/pub/0vgzaln4](https://data-feminism.mitpress.mit.edu/pub/0vgzaln4)
- "PREreview. Catalyzing change in peer review through equity, openness, and collaboration" [https://prereview.org/](https://prereview.org/).
- "Auto-updates: time-saving and trust-building." ORCID, [https://support.orcid.org/hc/en-us/articles/360006896394-Auto-updates-time-saving-and-trust-building](https://support.orcid.org/hc/en-us/articles/360006896394-Auto-updates-time-saving-and-trust-building)
- The Turing Way Chapters: Project Ownership; Tips for Getting Authorship Right and Acknowledging Contributors; Research Infrastructure Roles; Creating project repositories. [https://the-turing-way.netlify.app/welcome.html](https://the-turing-way.netlify.app/welcome.html), The Turing Way Community, Zenodo, 27 July 2022, doi:10.5281/zenodo.6909298.
- "ICMJE | Recommendations | Defining the Role of Authors and Contributors.", [www.icmje.org/recommendations/browse/roles-and-responsibilities/defining-the-role-of-authors-and-contributors.html](http://www.icmje.org/recommendations/browse/roles-and-responsibilities/defining-the-role-of-authors-and-contributors.html).
- Colbert, Melissa C., Robert B. Nussenblatt, and Michael M. Gottesman. "Integrity in Research: Principles for the Conduct of Research." Principles and Practice of Clinical Research. Academic Press, 2018. 33-46.
