# Open Results Training Module

Welcome to the Open Results Module!

Recap: In Open Ethos, we learned about the ethics and principles underlying responsible open science practices. In Open Software, we explored and identified the right tools and methods that allow us to ensure reproducibility through version control, code testing, workflow, and a virtual research environment. In Open Data we developed a data management plan that can ensure the Findability, Accessibility, Interoperability and Reusability (FAIR) of our data throughout the research process, and not just at the end when the final report from the project is released.

In this module, we will explore the different stages of the research process—including identifying the different types of Research Objects in a study and the various ways in which they can be shared and disseminated as open results. We will define a Research Object and provide an overview of how they relate to the research lifecycle (Lesson 1). Specifically, we will discuss the different stages of the research process, from ideation and planning all the way through and beyond dissemination. Then, we will consider how these Research Objects can be shared (Lessons 2-3). By the end of the module, we will have looked at the important concepts and practices for publishing and sharing research components before, during and after the project. Lastly, we address ethical contributorship, – making sure collaboration is fair and inclusive, and that credit is assigned transparently and equitably (Lesson 4).

## Objectives:

1. Identify research stages and elements of research objects that can be considered results
2. Identify the guiding practices and principles related to open results and the advantages of implementing them across stages of a research process
3. Identify paths for publicly communicating results
4. Create open results contributor guidelines and opportunities for open and equitable collaborations
5. Give credit to contributors in open results
6. Contribute and provide constructive feedback to others' results
7. Apply open result principles to new and ongoing research projects

## Overview and key messages

This module addresses different questions discussed systematically across the following four lessons:

Lesson 1: The Research Process and Its Results

1. What are the different stages of the research process?
2. What are "Research Objects"?

Lesson 2: Results in the Context of Open Science

1. What are the advantages of making results open throughout the research process?
2. What resources are available to help make results open?
3. What are the guiding principles to turn a research result into an open result?

Lesson 3: Applying Open Result Framework to your Research

1. How can you apply an open framework across different research objects?
2. How can you share your results, and select \*\*tools\*\*that support open science?
3. Using a checklist to achieve open results

Lesson 4: Providing Equitable Opportunities and Credit for Contributors to Results

1. How can you define contributors to each digital research object and determine their suitable form of recognition?
2. How can you create contributor guidelines that ensure equity, access, inclusion, and diversity?
3. How can you ensure your open results are properly attributed and cited by others?
