# Lesson 6: Sharing & Reusing Open Data 
## Learning Objectives
- Communicate best practices for responsibly sharing data
- Understand regulations and use conditions of data 
- Find and Reuse Open data sets

## Introduction:

In addition to the ethical considerations discussed in lessons 3 and 4, Open Data may be subject to strict controls and guidelines for sharing, managing and reusing it. 

This lesson will cover the leading practices for sharing, finding and reusing Open Data as part of the Open Science environment. 
Data sharing and reuse may be limited in various ways. 
This can include the introduction of partial or total restrictions to address safety concerns, legal rights, ethical principles, protection of community interests and well being (see lesson 4 CARE and FAIR principles), and commercial interests. 
A well documented dataset will include details on what you are allowed and not allowed to do with the data, and this information is typically outlined in the documents below.


## 6.1 Policies for Responsible Sharing of Open Data

Policies can reshape scientific data sharing practices, stimulating the free flow of research data and ideas. 
Policies set the tone to make Open and FAIR science the new normal science. 
Policies exist at several levels [[1](https://doi.org/10.5281/zenodo.6532282)]:


* Policies at the institutional level describe how, when and sometimes where and to whom a dataset should be made available. 
These policies exist to help guide data creators determine the intellectual property rights and responsibilities associated with a given dataset.  

A major driver of open data policies are **funders**. Funders can require data management plans (lesson 5) or Open Data for the projects that they fund. Non-compliance could affect later grant funding. 
For example, the US National Institutes of Health requires that sharing plans are indicated early on in the data management plan during the application stage [[2](https://grants.nih.gov/grants/guide/notice-files/NOT-OD-21-013.html)].

At the national level, some policies even have the weight of **law** behind them. For example both Spain ([https://www.congreso.es/public_oficiales/L14/CONG/BOCG/A/BOCG-14-A-92-4.PDF](https://www.congreso.es/public_oficiales/L14/CONG/BOCG/A/BOCG-14-A-92-4.PDF)) and the United States ([https://www.congress.gov/bill/115th-congress/house-bill/4174](https://www.congress.gov/bill/115th-congress/house-bill/4174)) have laws that outline how data generated with governmental funds will be shared.

At the international level several initiatives and guidelines exist to expand Open Data sharing such as the OECD work on [Enhanced Access to Data and Models ](https://legalinstruments.oecd.org/en/instruments/OECD-LEGAL-0347), UNESCO, and Horizon Europe [[3](https://doi.org/10.3389/fdata.2019.00043)].


## 6.2 Licenses for Open Data
A license is a legal document that tells users how they can use the dataset assigned said license. 
It is imperative to understand the licensing conditions of a dataset before data reuse. 
Without a good understanding of what a license allows, it will open researchers up to copyright infringement or other intellectual property issues. 

It is equally important to recognize that a dataset without a license does not mean that the data is open; in fact, using a licenseless dataset is not ethical. 
Contacting the author and getting explicit permission (while suggesting they apply a license) is the best path forward. 

In other instances, understanding when and where the license applies is crucial. 
For example, data created using US Government public research funds is, by default, in the Public Domain. 
However, that only applies to the jurisdiction of the United States [[6](https://resources.data.gov/open-licenses)]. 
In order for this to apply internationally, data creators need to select an open license such as Creative Commons Zero (CC0). 
While not a license per se, international public domain statements like the Creative Commons Zero (CC0) [[7](https://creativecommons.org/publicdomain/zero/1.0/)] are also open and considered appropriate for many datasets.

An open license has language that describes the user’s ability to access, reuse and redistribute the dataset. There are many broadly open licenses available to choose from:  


* Creative Commons License [https://creativecommons.org](https://creativecommons.org) 

* The British Open Government License- [https://www.nationalarchives.gov.uk/doc/open-government-licence/version/3](https://www.nationalarchives.gov.uk/doc/open-government-licence/version/3)

* The World Bank Terms of Use - [https://www.worldbank.org/en/about/legal/terms-and-conditions](https://www.worldbank.org/en/about/legal/terms-and-conditions) - among others)

More information on licenses, and copyright can be found at: 

* Digital Curation Center, DCC ([https://www.dcc.ac.uk/guidance/how-guides/license-research-data#x1-13000doc](https://www.dcc.ac.uk/guidance/how-guides/license-research-data#x1-13000doc)) 

* Open Data Commons (https://opendatacommons.org/licenses/),[5](https://creativecommons.org/about/program-areas/open-data/)].
* The Turing Way [https://the-turing-way.netlify.app/reproducible-research/licensing/licensing-data.html](https://the-turing-way.netlify.app/reproducible-research/licensing/licensing-data.html)

In general, it is recommended to use the most open license possible (CC-0 or CC-BY-4) to enable Open Data. 
However, before choosing a license it is a best practice to check with one’s institution to see if there is a standard license that one should use.

Keep in mind that regardless of which license is chosen, reference or use of someone else’s work must be attributed properly.
More on that in the next section.  


## 6.3 Citations and Acknowledgements

Acknowledgements and citations contribute towards fostering a culture of sharing data without fear of ideas or recognition being stolen. If a researcher can trust that their work will be cited, and used to further the development of science, the idea of making data open is more appealing and mutually beneficial.

Further, data citation aids transparency and allows the original authors and new researchers to easily track how the data is being used to answer different questions, and gain insights from related as well as unrelated fields they wouldn’t ordinarily read about.

Use of standard citation practices are recommended to ensure due credit is given.
See [The Turing Way for more information about citation](https://the-turing-way.netlify.app/communication/citable/citable-cite.html).

## 6.4 Data Access/Availability Statements

Sharing data relies on clear statements and methods for accessing the data. This is typically indicated in the Data Availability/Access Statement which includes elements such as; DOI or identifier for the data and citation to the correct references [[9](https://jie.yale.edu/datastatements)], [[10](https://think.f1000research.com/wp-content/uploads/2021/02/F1000Research-Open-Data-How-to-Write-a-Data-Availability-Statement.pdf)].
It can also include clear instructions for downloading, using, sharing and citing the data [[11](https://doi.org/10.5281/zenodo.6505587)]. 
An example of what to include in a good Availability Statement is available in [[10](https://think.f1000research.com/wp-content/uploads/2021/02/F1000Research-Open-Data-How-to-Write-a-Data-Availability-Statement.pdf)] & [[11](https://doi.org/10.5281/zenodo.6505587)].

In other words, Data Availability/Access Statements outline the restrictions on specific datasets, as well as what the users need to provide or abide by in order to gain access to the data. 
At times you may need to submit a Data Access Request specifying what you intend to do with this data and how you intend to fulfil the requirements as set by the data owner.



## 6.5 Where to share and find data

Ideally, you have been planning to share your data from the beginning of your research project. 
Deciding early on what metadata will be collected, how the data will be documented and under which license you want to (or must) release the data will help you decide on the repository.
In addition to sharing data, the reusability of openly shared data relies on the prospects of it being found in the first place. 
The data findability is thus a key step in accessing and utilizing data.  

The most common way to share and find Open Data is through data repositories. 
Many repositories can help you to make the Open Data FAIR (by providing data with a persistent identifier (PID) that is globally unique, such as a Digital Object Identifier (DOI), a license, metadata guidelines, preservation actions and suggested citation).  

Depending on your needs, different types of repositories might be a better fit. 

These types of repositories are briefly summarized here:

#### Domain Specific Repositories:  

The first step in finding Open Data related to your field is to identify discipline specific repositories.
It is highly recommended to use domain repositories that are ideal for your type of data if they are available.

These are specialized repositories (typically for specific data types) where they provide support and information on required standards for metadata and more.

Examples include: CUAHSI’s HydroShare, a common platform for hydrology data, and ModelDB, an open source neuroscience repository for model neurons [[8](https://senselab.med.yale.edu/ModelDB)].

Finding the right repository can be a challenge.
Often the best way to find a good fit for your data is to:

* Consider where you/your community members would normally search for data,
* Check whether your funder requires/advises the use of specific repositories,
* Check with librarians/research support staff if possible,
* Search for a domain specific repository using one of the following resources: 
	* [Register of Research Data Repositories](https://www.re3data.org/), a global registry of research data repositories that covers research data repositories from different academic disciplines 
	* [FAIRsharing](http://fairsharing.org), a resource on data and metadata standards, databases and data policies 
	* Recommended repositories by publishers (such as recommended data repositories suggested by [Scientific Data](https://www.nature.com/sdata/policies/repositories#envgeo) and [PLOS One](https://journals.plos.org/plosone/s/recommended-repositories))
	* [World Data System](https://www.worlddatasystem.org/) represents a network of repositories.

#### Institutional Repositories:

Many universities and organizations support research data and software management aiding their researchers to comply with requirements.
Such services are often provided through the library or other research support service groups, such as an institutional repository.

#### National Repositories:

In certain contexts, national funders will instruct authors to use their national repositories for data and/or software preservation. 
These repositories are often used to archive and preserve data and other digital objects that are funded by governmental funding. 
These repositories may be open to general data and digital objects. 
One example is the UK Data Services ([https://ukdataservice.ac.uk/](https://ukdataservice.ac.uk/)), which is a UK funded research infrastructure to support curation and access to social science data.

#### General Repositories:
There are a handful of general repositories that can be used to deposit data, softwares, research papers, presentations, and other digital objects. 
They are not designed for a specific community and are accessible to everyone. 
When using a general repository, make sure you provide documentation about your data that is in line with your community standards. 

Common general repositories include: 

* _[Zenodo](https://zenodo.org)_
* _[Mendeley Data](https://data.mendeley.com)_
* _[Figshare](https://figshare.com)_
* _[Dryad](https://datadryad.org/stash)_


Please refer to the [Generalist Repository Comparison Chart](https://fairsharing.org/collection/GeneralRepositoryComparison) a tool for additional repositories and guidance. 
Dataverse has also published a [comparative review of eight data repositories](https://dataverse.org/blog/comparative-review-various-data-repositories).

A final note about choosing a repository: Some repositories may charge fees to users who deposit data, especially when the number or the volume of data files are substantial. 
You should check if fees apply, or whether there's an agreement in place with your institute and the repository of your choice.

### Web-searches

To explore a wide variety of datasets from projects or popular topics you can use a general search engine. 
Some disciplines or large institutions, such as NASA and the National Institute of Health’s National Center for Biotechnology Information (NCBI), offer their own portal where you can search for their datasets, related publications and tools for analysis (for example, [EMBL's European Bioinformatics Institute](https://www.ebi.ac.uk)). 
There are also an increasing number of international and national data portals to enable data discoveries.

### **Generic data search portals:**

* Google [https://datasetsearch.research.google.com](https://datasetsearch.research.google.com)
* Kaggle [https://www.kaggle.com/datasets](https://www.kaggle.com/datasets)
* Wikidata [https://www.wikidata.org/wiki/Wikidata:Main_Page](https://www.wikidata.org/wiki/Wikidata:Main_Page)
* Open Data Network [https://www.opendatanetwork.com](https://www.opendatanetwork.com)
* Awesome Public Datasets [https://github.com/awesomedata/awesome-public-datasets#readme](https://github.com/awesomedata/awesome-public-datasets#readme)

### **Examples of Discipline specific data search portals:**

* NASA Earth [https://www.earthdata.nasa.gov](https://www.earthdata.nasa.gov)
* CERN [https://opendata.cern.ch/](https://opendata.cern.ch)
* NCBI National Center for Biotechnology Information [https://www.ncbi.nlm.nih.gov](https://www.ncbi.nlm.nih.gov)
* EMBL's European Bioinformatics Institute [https://www.ebi.ac.uk/](https://www.ebi.ac.uk/)
* ISPCR [https://www.icpsr.umich.edu/web/pages](https://www.icpsr.umich.edu/web/pages)
* International Monetary Fund [https://www.imf.org/en/Data](https://www.imf.org/en/Data)
* NOAA Climate Data Online [https://www.ncdc.noaa.gov/cdo-web/datasets](https://www.ncdc.noaa.gov/cdo-web/datasets)  
* Federal Reserve Economic Research [https://fred.stlouisfed.org](https://fred.stlouisfed.org)
* USGS EarthExplorer [https://earthexplorer.usgs.gov](https://earthexplorer.usgs.gov)
* Open Science Data Cloud (OSDC) [https://www.opensciencedatacloud.org](https://www.opensciencedatacloud.org)
* NASA Planetary Data System [https://pds.nasa.gov](https://pds.nasa.gov)


### **Examples of National or International data search portals**

* US Federal data [https://data.gov](https://data.gov)
* EU Data Portal [https://data.europa.eu/en](https://data.europa.eu/en)
* WHO [https://apps.who.int/gho/data/node.home](https://apps.who.int/gho/data/node.home)
* THE WORLD BANK [https://data.worldbank.org](https://data.worldbank.org/)
* DATA.GOV.UK [https://www.data.gov.uk/](https://www.data.gov.uk)
* UNICEF [https://data.unicef.org](https://data.unicef.org)


### Literature search

While not ideal, datasets are often attached to scholarly publications in the form of supplementary material, or places that have no preservation policies for the long term (GitHub repository or personal/institutional websites). 
In addition, there are emerging journals and special collections/issues focused on describing and publishing data (such as Nucleic Acids Research database issues[ https://doi.org/10.1093/nar/gkab1195](https://doi.org/10.1093/nar/gkab1195), Scientific Data, Earth System Science Data - see [The Turing Way for an overview of data journals](https://the-turing-way.netlify.app/reproducible-research/rdm/rdm-article.html)). 
While the datasets are openly available, they are often not properly indexed and therefore not very findable nor machine readable.

Finding academic publications can be a challenge in itself depending on the discipline and field of study. For life and   biomedical research it is less challenging, since there are a number of repositories and search engines (PubMed, EuropePMC) indexing research outputs from various journals. 

In other disciplines (such as arts and humanities), however, search is often carried out with general search engines or research databases such as Google Scholar and JSTOR. In that case, it is advisable to reach out to library personnel and community members for further advice on where to find related literature and data. See lesson 5.4 Help section.

**Generic:**

* Google Scholar [https://scholar.google.com](https://scholar.google.com)
* Open knowledge map: A visual interface allowing the exploration of interconnected topics with relevant documents and concepts [https://openknowledgemaps.org/](https://openknowledgemaps.org)
* JSTOR a wide range of scholarly content [https://www.jstor.org/](https://www.jstor.org)
* ResearchGate [https://www.researchgate.net/search](https://www.researchgate.net/search)

**Discipline specific:**

* EuropePMC Life sciences [https://europepmc.org](https://europepmc.org)
* Pubmed biomedical literature [https://pubmed.ncbi.nlm.nih.gov/](https://pubmed.ncbi.nlm.nih.gov)
* arXiv is a pre-print server for the fields of physics, mathematics, computer science, quantitative biology, quantitative finance, statistics, electrical engineering and systems science, and economics [https://arxiv.org](https://arxiv.org)
* Biorxiv Preprint server for biology [https://www.biorxiv.org](https://www.biorxiv.org)
* EarthArXiv ([https://eartharxiv.org](https://eartharxiv.org)) and Earth and Space Science Open Archive ([https://essoar.org](https://essoar.org))
* ASAPbio provides a catalog of preprint servers [https://asapbio.org/preprint-servers](https://asapbio.org/preprint-servers)  

## 6.6 How to evaluate the quality of open data and reuse it

Data reuse is contingent on a number of factors including quality of data, access and reuse conditions, data findability, and more. Below we outline a few essential elements that enable you to assess the relevance and quality of datasets .

### Documentation

Dataset discovery relies on the quality of documentation and metadata (see lesson 1. What is Open Data) associated with the datasets. 
Search engines rely on [key information about the datasets which allows them to be indexed and searched](https://www.blog.google/products/search/making-it-easier-discover-datasets).

A general rule of thumb for data documentation and metadata is that you should be able to understand what the dataset is about, what is the stage of the data, and what to expect before downloading and processing it.

Some core descriptors to look for are:

* Who created this data?
* When was it published?
* How was the data collected?
* What are the tools used for processing and handling the data?
* What are the terms for using it?
* What are the disciplines that used the data?
* What are the communities that have developed around it?


Ideally a fully documented data reuse plan should accompany the datasets providing detailed information on What, Who, Where, When and How. 
See 5.3 Documenting your Data (Metadata)and Data Reuse Planning Template by Mozilla Open Science.

[https://github.com/mozillascience/working-open-workshop/blob/8931bf19bedb99166b931f82dbd2fba815dc6fe1/handouts/data_reuse_plan_template.md](https://github.com/mozillascience/working-open-workshop/blob/8931bf19bedb99166b931f82dbd2fba815dc6fe1/handouts/data_reuse_plan_template.md)

## Formats
As noted previously, the format of data is key for its interoperability. 
Data formats are in two classes. 
Closed, proprietary formats are those where the specification for the way the data is stored is not publicly available and hence is tied explicitly to the software (or hardware) developed by an organization. 
On the other hand, open formats are publicly available.

The format of a file should be described in the metadata associated with the data set. 
If metadata is not available then inspecting the file name (the postfix to the file name that comes after the period) can give an indication of what the file type is. 
Opening the file with software for a specific data format provides a similar test.

If the format isn’t clear or is using a closed format where there isn’t software to access the data it is worth contacting the authors of the data set to see if they can help.
Note that authors are not obliged to reply to you. You can also ask advice from the communities outlined in Lesson 5.

## Tools

Many of the details here are discussed in the Open Tools lesson. 
To ensure that you can reuse data you can check if a previously published analysis of the data can be reproduced. 
In reproducing such an analysis one can determine if you have all the necessary software, source code, and documentation needed to reproduce the results. 
If the results can be reproduced then you can be more confident in reusing the data. 
As described above, you can contact the authors if there is an issue or contact the communities described in lesson 5. 

## Data Cleaning

Data cleaning refers to the preliminary step where the quality of data is assessed. 
During data cleaning any errors, inconsistencies or formatting issues are detected and resolved prior to using the datasets. 
Data cleaning also includes making decisions on what to do with missing or incomplete data.

Each research community has their own measures of quality and pipelines for cleaning data, with norms established on how to deal with missing values or how to normalize data. 
It is therefore advisable to consult with data managers, librarians and other community members for common practices. 
See lesson 5.4 Help.

Data cleaning is important to provide access to accurate and consistent data. 
This is often highlighted in the phrase 'Garbage in-Garbage out', meaning that flawed data (such as duplicated or missing information) will produce incorrect or misleading outputs.
Data quality can be reduced in several ways, including misspellings or typos during data entry, missing values, mixed formats, replicated entries of the same real-world entity or other invalid data.

Data cleaning requires significant human intervention (including in some cases sectoral or community efforts), which may consume time and energy. 
Anecdotally, preparing data in this fashion can take up to 80% of the time involved in the analysis of data.

(Hellerstein, J. M. (2008). Quantitative data cleaning for large databases. United Nations Economic Commission for Europe (UNECE), 25, 1-42. [https://dataresponsibly.github.io/courses/documents/Hellerstein_2008.pdf](https://dataresponsibly.github.io/courses/documents/Hellerstein_2008.pdf)), (Chu, X., Ilyas, I. F., Krishnan, S., & Wang, J. (2016, June). Data cleaning: Overview and emerging challenges. In _Proceedings of the 2016 international conference on management of data_ (pp. 2201-2206. [https://doi.org/10.1145/2882903.2912574](https://doi.org/10.1145/2882903.2912574)).

**Guides:**

* Harvard- Analysis Ready Datasets [https://datamanagement.hms.harvard.edu/analyze/analysis-ready-datasets](https://datamanagement.hms.harvard.edu/analyze/analysis-ready-datasets)
* [https://en.wikipedia.org/wiki/Data_cleansing#Data_quality](https://en.wikipedia.org/wiki/Data_cleansing#Data_quality)
* [https://www.kaggle.com/learn/data-cleaning](https://www.kaggle.com/learn/data-cleaning)
* [https://towardsdatascience.com/the-ultimate-guide-to-data-cleaning-3969843991d4](https://towardsdatascience.com/the-ultimate-guide-to-data-cleaning-3969843991d4) _ _
* Carpentries [https://datacarpentry.org/lessons/](https://datacarpentry.org/lessons/)


**Tools:**

* [https://openrefine.org/](https://openrefine.org/)
* See more in tools module


## Summary


Over the present decade, there has been a surge of interest from both industry and academia in Open Data, not only for record keeping but also to support a variety of decision-making tasks. 
Creating new data is costly and sometimes redundant. 
Therefore there is an increased emphasis on reuse of Open Data.


In summary, sharing Open Data requires;

1. Planning for open data;

2. Identifying appropriate repository(ies);

3. Describing the data and data processing steps;

4. Ensuring that an appropriate license is assigned to the data;

5. Citing other data that you use in paper or presentation references and describing access in a Data Access/Availability Statement.  

What to look for before deciding on reusing open data:
1. Find a dataset
2. Check if you can access it (information available in the Data Access/Availability Statement)
3. Check license: Is it fully open or partly open?
4. What are you allowed to use it for?
5. Documentation:
   1. Is it raw or processed data?
   2. Can you understand what this dataset is about?
   3. Is the dataset missing parts of the data?
   4. Which units of measurements are used?
   5. What quality controls were in place?
6. What file formats is the data in?
7. Can you open it and use it with available software?
8. Is all necessary software or source code included and made available?
9. Do you understand the provenance of the data? Can you identify who owns this data?
10. Can you contact the original authors?
11. How can you cite the data?



## Assessment

Assuming that you have a dataset that you want to deposit into a repository and share it publicly:

1. Can you find a domain specific repository via [re3data.org](https://www.re3data.org/) or [fairsharing.org](http://fairsharing.org)?
2. If you want to deposit it into a general repository, which one will you choose and why?
3. Can you choose a license? Why would you choose this license?
4. What does the license allow reusers to do?


## References
1. https://doi.org/10.5281/zenodo.6532282 
2. https://grants.nih.gov/grants/guide/notice-files/NOT-OD-21-013.html 
3. https://doi.org/10.3389/fdata.2019.00043
4. https://opendatacommons.org/licenses/
5. https://creativecommons.org/about/program-areas/open-data/
6. https://resources.data.gov/open-licenses/
7. https://creativecommons.org/publicdomain/zero/1.0/ 
8. https://senselab.med.yale.edu/ModelDB/
9. https://jie.yale.edu/datastatements
10. https://think.f1000research.com/wp-content/uploads/2021/02/F1000Research-Open-Data-How-to-Write-a-Data-Availability-Statement.pdf
11. https://doi.org/10.5281/zenodo.6505587

