### Lesson 4: WHERE: Impact of Open Science on academia,  communities and society as a whole: Where open science happens.

#### Introduction

We have so far explored the fundamental parts of what Open Science is: why to pursue it and who the stakeholders of open research are. Where you are in the world when performing open science can have an impact on how you perform it, too. Laws across the world vary, and the advantage of open science means people from around the world can participate, co-create, and consume content together. This can affect your work from social and legal perspectives, and may present technical challenges as well. 

Legal frameworks that affect responsible Open Science
Open Science promises to make research work more accessible, all-encompassing, participatory, understandable and re-usable for wider audiences. Keep in mind, making the process open does not in itself result in  wide participation unless it's partnered with sufficient financial resources, technological advancements, knowledge and skills. It's important that all these are available across regions, institutions and socio-demographics (review by Hellauer et al. 2022) 

#### Data protection, privacy, and data sovereignty 
**⚠️Caution:** To perform open science responsibly, it is important to consider not only what you should share, but also what not to share. 

Individuals may have a right to privacy in their communications, for medical records, and for their physical locations. Similarly, certain countries, communities, and especially Indigenous peoples may historically have been exploited, and may wish to retain more rights over their knowledge to protect from further exploitation. Globally, there are laws around the world that may cover some of these issues, but not all countries and regions have equal levels of protection, and some have none at all. 

We share some case studies:

##### European case: General Data Protection regulation
There are protective laws and legal frameworks in certain places around the globe that affect open science. European researchers have to abide by the General Data Protection regulation (GDPR) while making a data sharing statement stating the non-availability of data sharing. This hinders sharing particular data. Here, the scientific society should come forward to allow responsible Open Science data sharing possibilities in the global scientific space (Giske Ursin & Heidi Beate Bentzen, 2021) 

##### South African case: Protection of Personal Information Act (POPI Act) and Open Science

The POPI Act No. 4 of 2013 is regulation by the government of South Africa to safeguard  the personal information of South African citizens, like the General Data Protection Regulation (GDPR) in Europe. The regulation states that if one is obtaining personal information of South African citizens through phones, focus groups, interviews, containing identifiers such as names, contact information then you have to be POPI Act compliant. 

In the research context, one needs to make sure that if the personal identifiers are collected then they must not be shared with third parties and stored securely in an access-controlled location to prevent a data breach. The act doesn't impede open data sharing, but personal identifiers should be removed from shared datasets. The POPI act affects the research process, in a way to make sure that storing of data of only de-identified datasets on cloud storage & onsite data storage is strictly controlled to specific designated individuals to ensure data safety (POPIA Code of Conduct for Research, 2021).

##### United States case: 

In the United States, there is no federal-level legislation similar to POPI or  GDPR, but there are some state-level laws, such as the California Privacy Rights Act, and the Virginia Consumer Data Protection Act. 

**📝 Exercise:** Check what laws, if any, apply in your state. 

##### Summary: Working in a global society with varied data protection laws

Given the broad variation of data protection laws around the world, it may seem tricky to navigate. By practicing responsible Open Science, however, our response can get a little bit clearer. We can consider relevant legislation (if any) to be a bare minimum, and instead ensure that we are involving relevant stakeholders, as discussed in lesson 4, and listening to their needs respectfully, even if it means we are more cautious than local legislation may require. 

#### Whose laws apply to my community? 

Social, cultural, and legal norms will vary from country to country, and international communities. Avoiding culture clashes can be made more manageable by setting out explicit cultural norms for your community, such as may be specified in a code of conduct, which we discussed in lesson one of this module. Try to avoid assumptions that tie to a specific physical location or culture. Some examples why this is important: 

- Laws are not uniform. If activity X is legal to do in one country, but not another, a code of conduct which says "obey the law" becomes impossible to interpret fairly or to enforce. 
- Hosting a conference in a country that doesn't have strong human rights records might result in someone breaking the law by being LGBTQIA+, or by not wearing religious garb. 
- "We plan to release this in the summer" might be clear if you're all in the same country, but if your collaboration is spread across the northern and southern hemisphere, is summer in the middle of the year or the end of the year? Consider using a month name instead - "we plan to release this by March" is unambiguous. 

#### Equity and Open Science 
Many countries in Asia, Africa and Latin America face many challenges, including lack of funding, inadequate access to literature and poor infrastructure. Across these regions, young scientists are working to build practices for open science from bottom-up. The aim is that scientific communities will incorporate these principles as they grow but these communities' needs differ from those that are part of mature research systems.  

The reasons for falling behind are lack of funding, poor infrastructure, inadequate access to research resources. There are government policies, which want greater productivity at the expense of quality. The open science collaborations can bridge the gap for developing countries by providing new ways and provide researchers access that might be currently out of reach (Onie, S. 2020). 

##### Equitable terminology: what words should we use?

When talking about equity from a global perspective, it can be very hard to choose appropriate language, and historically many phrases have come and gone as we learn more equitable ways to communicate. Common phrases you may see include "Higher Income Country" and "Lower or Middle Income Country". These are terms defined by the World Bank. Some people prefer to use "Global North" when referring to more privileged / high income countries, and "Global South" for lower income / more exploited and marginalized countries - but some "Global South" countries are in the northern hemisphere, and vice versa! Other times, people use "minority" and "majority", but again sometimes the phrase "minority" might be used for a populace that is not actually a minority! An older phrase is "first world country" or "third world country".  Many of these terms also have accidental or intentional negative connotations. For this module, we aim to use the phrases "marginalized" and "privileged" when referring to the inequitable distributions of resources and power amongst humanity. 

The Global North have ascendency over authorship and synergies in research networks, which margins out the Global South (Cash-Gibson L et al 2018). 

In richer regions, a compulsion for the goal of excellence nurtures cumulative benefit in funding allocation for the highest funded institutions (Noble P et al) 
Across many countries, very few women have higher positions, senior positions are given at a later age, given less grant funding and few have high-impact publications (Gesiarz F et al 2020)
(Brown JVE et al 2020 ) 
These are the impartialities, which are the societal imbalances (Zuckerman H. (1988). The above stated societal imbalances, which Open Science is focused to minimize in order to elevate the underrepresented societies, groups and create avenues for Global South countries to come forward & contribute to the global science community. 

Prainsack & Lionello (2018) stated that open science is a political assignment greater than its technological part. The Open Science policy in Europe is shifting across nations, institutions & funding organizations. (Sveinsdottir T et al 2020). 
The emphasis on policies drive the incentive/reward structures and resource allocation and later helps in establishing strategies. Open Science started as a bottom-up approach by the researchers but has gone to the top-end level making it to the national and institutional policies setting wider goals like economic growth.  The European Commission favors Open Science but in 2016 EU publication, the concern of Open Science perceived potential is being given that greater importance for fostering Europe's competitive advantage in global markets (link to EU publication, 2016) 
Open Science positions to cover literature in languages other than English, supporting the value of 📖bibliodiversity📖. We see a diverse set of communities in organizations working for Open Science data, software, tools, resources together as multilingual teams' covering different languages of the world.  Research indicates that there is a demand for regionally focused titles, in  regional languages (Snijder 2022)..

#### A global perspective on open science 
##### UNESCO on Open Science Infrastructure 

UNESCO's recommendation on Open Science states the potential of open science is in minimizing the present inequalities in Science, Technology and Innovation and pace towards SDGs 2030 implementation agenda, specifically in Africa, least developed countries, small island developing states and landlocked developing countries. 

Open Science infrastructures are shared infrastructures (referred as virtual/physical, knowledge-based resources such as journals, collections, and open access publication platforms, archives, repositories, scientific data, present research informations systems, sets of instruments, open bibliometrics, scientometrics systems for assessing & analyzing scientific areas, open computational & data manipulation service infrastructures, multidisciplinary data analysis & digital infrastructures) where open science happens and serves the needs of diverse communities. Please see UNESCO Recommendation on Open Science

UNESCO on Open Science policies clearly recommends monitoring Open Science through combining qualitative and quantitative methods to assess the efficacy and efficiency of Open Science as per the member states' particular conditions, constitutional structures and constitutional provisions. Also, gathering & communicating progress, good practice, research work & innovation in open science and its outcomes with support of UNESCO and diverse stakeholders approach. 

##### Organisation for Economic Co-operation and Development (OECD) and Open Science

The OECD's recommendation regarding research data from public funding helped gain collaboration and global sharing of data as a policy priority, with the objective of making the global science system more effective and seamless. There has been progression in a number of OECD member states and partner economics, with 58 countries successfully delineating their policies for open data & research publications.
- For IT infrastructure,  academic institutions and data repositories, international networks have been established in the form of repository networks such as OpenAIRE.
- "Science clouds" - national and international computational resources -  are being initiated such as European Open Science Cloud, the Australian cloud NECTAR, the National Research Data Infrastructure in Germany, the National Institute of Health Data Commons in the USA & Research Center for Open Science and Data Platform in Japan.

#### Questions/Reflection:

- What strengths do marginalized communities bring to open science? What challenges may they face compared to privileged communities? 
- Name at least one data privacy law, and describe ways you can keep personal data safe. Do all countries have data privacy laws? 
- Bonus: You're working on an open science consortium that gathers data in the Netherlands, Kenya, and India. You plan to use servers in the EU to store your data. What concerns should you take into account? 

