### Lesson 3: WHO: Stakeholders of Open Science: Who practices responsible Open Science and for whom?


#### Introduction

In previous lessons, we learned about the concept and motivation and aspiration of open science. Now let's think about "who" is practicing open science and for whom.  In the first section of this lesson we dive deeper into understanding who the stakeholders for Open Science are. In the second part we cover essential topics about barriers to participation, and to  include diverse stakeholders in open science communities and ways to overcome them.

In this module we offer you a person-centered approach to making open science happen. Our  intention is to prevent harmful consequences of science's misuse (even unintentional misuses) and to increase the impact of science, by leveraging other researchers' works and improving society. 

#### Who performs and benefits from open science? Stakeholders partaking in open science:

As briefly discussed in previous lessons, Open science doesn't only concern researchers; many other stakeholders are affected by the outcomes of open science as well.  Stakeholders are any individuals who can affect or be affected by open science projects. Although there are different ways to categorize stakeholders depending on your science projects, mainly there are three large groups; 1. Researchers, 2. Public, and 3. Policy-makers. 

- Researchers
- Organizations
- Research Teams
- General public
- Decision Makers (regulatory, funding bodies, etc)
- Government 

##### Researchers: 

Individuals engaged in creating new knowledge (e.g. researchers, students, faculty staff at universities, researcher centers,  researchers at libraries). Responsible for creating an open science environment as well as open outputs and processes.

##### Public:

Lay people who can drive/improve/conduct science (i.e. people who may not have an academic background or research experience). This may also be referred to as "citizen science", but you do not have to be a citizen of any particular country in order to participate in science! 

##### Policy-makers: 

Those with decision-making power (e.g. government, regulatory bodies)

#### How each group contributes to Open Science

Let's take a look at these groups, how they can contribute to open science (input) and what benefits they experience from open science (this was also discussed in Lesson 2). Note that overlap among researchers, the general public, and policy-makers can happen. 

Researchers' contribution to open science manifests by sharing and communication their research via open access publications (more about it in the Lesson How and Module Open Results)
As a result, community of researchers benefits from  increased visibility and credit, reproducibility,  access to more data and attraction of funding, reduced work's duplication, conservation of resources and increased accessibility  

The general public contributes to open science research by above mentioned "citizen science" projects, as e.g. as volunteers to collect or manage (e.g. categorize) some type of data.

As a result,  individuals boost their understanding of science and feel empowered by having opportunities to exert influence. Disinformation in the public arena is decreased, and the routes of access to trustworthy sources of information are strengthened. 

Policy-makers play important role in ensuring and facilitating open science by setting data management processes, open access legislation, developing ethical guidelines for experiments
As a result, higher quality of research done with open science principles and efficient communication between stakeholders leads to better-informed decisions

This figure briefly shows how three groups of stakeholders interact with each other. Healthy interactions will foster respect and overcome power dynamics. Each group should focus on empowering other groups and be aware that open science cannot exist without the others. 
Resources and tools for interactions are described in greater detail in Lesson 5, (and in the tools and results modules).

#### Case scenarios

Now let's take a look at examples of successful interactions  around the world!

##### Case Scenario #1:  Trend: Public  —> Policy-makers

The public has many opportunities to join research projects and can play prominent roles in science. There are more than 30 ways to define Citizen Science (Haklay et al., 2021), and the principle is "active public involvement in scientific research" (Irwin, 2018). 
Citizen Science contributes to policy making at various stages of the policy cycle, including policy preparation, formulation, implementation, monitoring, and evaluation Scade et al (2021). That is to say, citizens are capable of setting trends and informing the directions in policy making. 

In 2015, the United Nations adopted the 2030 Agenda for Sustainable Development for peace and prosperity for people and the planet, now and into the future (United Nations, 2021). This agenda has 17 specific goals that require a large amount of data. Citizens have been contributing by providing the water and air quality, marine litter, biodiversity, health, and gender issues data (Fritz et al, 2019), and Scade (2021) describe this as " a source of information for policy making." This is a powerful example of citizens influencing  global policy trends. 

##### Case Scenario #2: Officialize: Policy-makers—> Researchers/Public

Policy-makers can implement new regulations for both researchers and the public.  Bothwell and Smith (2017)  reported that policy can shape knowledge. For example, policies such as dispersion of research funding (i.e. which science disciplines including Citizen Science receive the most funding), and data management plans for the public can impact the amount of knowledge produced. 

Most importantly, policy-makers are mindful that researchers and citizen scientists conduct science projects safely and ethically. National Institute of Health (2022) states that policy sometimes sets the rules of the road for conducting research, helping ensure that scientific investigations are carried out safely, securely, adhering to the highest standards of research integrity, and in a way that addresses evolving ethical concerns. We can find these ethical policies, for example, NIH Guidelines for Human Stem Cell Research. Some countries have legislation requiring research to be published openly, such as Spain's open access legislature. Policies on open access for European countries are monitored and reported by corresponding OpenAire National Open Access Desks.

##### Case Scenario #3: Participate: Public —>Researchers

Currently, NASA has 28 Citizen Science projects that are open to people around the world (NASA, 2022).  According to NASA Citizen Science policy, Citizen Science is defined as a form of open collaboration in which individuals or organizations participate voluntarily in the scientific process in various ways. The projects vary from  Earth and planetary science to biological science such as researching meteorites, mosquitos, and the surface of Mars. 

One of the evaluation criteria for NASA Citizen Science is;  two-way communication between volunteers and NASA scientists and including diverse citizen scientists, with scientists giving feedback to and receiving feedback from the volunteers (NASA SMD Policy Document SPD-33, 2018). Also NASA creates opportunities for citizen scientists to be co-authors for publications and 191 NASA Citizen Scientists joined scientific publications since 2011 (NASA, 2022). 

In addition to citizen science, there is an emerging concept called community science and co creation. Community science refers to science projects that honor community priorities. They can be initiated by a science practitioner or a community member, but they must become a collaborative endeavor (ASTC, 2021). Co-creation in science refers to the collaboration between a variety of actors (people from different societal roles) actively joining forces to tackle jointly defined challenges (Stier and Smit, 2021). We can also state that community science, which prioritizes community needs, succeeds through efforts of co-creation. 

Charles et al (2020) introduced a successful case of community science. One example is protecting one of the remote islands in Canada that is facing the threats of sea level changes (e.g. salt water intrusion to groundwater and losing archaeological sites). As a result of community science and co-creation through public, universities, and policy makers, now climate-related mapping and visualization techniques for vulnerability assessments are available for use within the community. This provides opportunity for all the residents to explore adaptation options to ongoing sea level changes. The community was also able to work with archaeologists on preservation initiatives. 


##### Case Scenario #4: Share:  Researchers —>Policy-makers/Public

About 2,000 researchers work together to create a report for the Intergovernmental Panel on Climate Change on the current situation, which  is a technical report that most people would have trouble understanding (Woolston, 2016). Some climate researchers break down their results to explain to policy-makers and citizens. Policy makers can utilize the results to officialize the restriction of CO2 emission level (e.g. Paris Agreement) and the public can be aware about what they can do in their daily lives to achieve the CO2 emission goal. This shows that each group is playing a significant role in addressing the climate science project, which is considered as one of the critical issues that our generation is facing.

#### How diverse stakeholders are included in open science:

Stakeholders are incredibly diverse in terms of culture, communication, and ability. To make science truly open, we must ensure that open science is accessible to everyone, so that we can all fully participate and benefit from the work. The best way to include stakeholders is to remove existing  barriers and design for inclusion.

Creating a more inclusive environment will both increase the amount of people who feel welcomed to contribute back to your research and will broaden the scope of people that can comprehend and interact with the products of the research.   Small actions towards conforming to accessibility and diversity guidelines will go a long way towards making your work truly open to all, maximize the visibility and impact of research..

Let's look at some factors and potential barriers for participation in the open science, with possible solutions:

##### Socioeconomic status:

Instabilities in the electric, electronic and internet access (e.g. load-shedding, internet speed, electronic device performance)

**Possible solution(s):** open science materials and communication channels should require less resources whenever possible 

##### Neurodivergence:

Diversity of neural architecture leads to different learning and socialization styles

**Possible solution(s):** employ multimodal communication strategies using different visual and audio outputs, varied pace of events and conversations

##### Disability/impairments

- Sensory - e.g. colorblind, blind, deaf, auditory and/or visual processing conditions
- Physical - e.g. conditions that affect energy levels, neuromuscular coordination conditions
- Mental - conditions that affect mental health (e.g. depression, schizophrenia, etc) 

**Possible solution(s):** employ multimodal strategies and universal design to provide proactive accommodations for as many as possible - captions, transcripts, colorblind-friendly palette, document formatting that are compatible with screen readers, normalizing flexible work schedules and  rolling deadlines with collaboration

##### Intersecting Identities and intersectionality

Epistemic oppression - e.g. dominance of  English as the international language for all science. Non-native English speakers are disadvantaged by default.

**Possible solution(s):** Proactive translation of open science results/communications in other languages

##### Microaggressions/macroaggressions:

Use of words with negative connotations towards individuals and groups and negative behavior/ostracization

**Possible solution(s):** Employ language and communication with neutral connotations that do not use pejorative terms or vilify a group
(example) in biology, we use males to identify the parent with testes and the female with ovaries; should change language to "parents with testes/ovaries" etc) Gender Inclusive Biology for more detail

**⚠️ Caution:** Full participation in open science requires respect of an individual's identity, autonomy, and lived experiences. _Microaggressions, macroaggressions, and epistemic oppression are identity barriers to open science._

This list is not comprehensive, but is meant to be a starting point in preparing your work in open science for diverse stakeholders. 

#### Activity/exercise

Now let's practice by looking at some typical case scenarios and solutions, reflecting on things you could do for inclusion: 

##### Case Scenario #1: Accessible figures and writing

You have finished your project and are busy typing your paper to submit to an open science preprint journal.  In your paper, you have several figures that use multiple colors at once - red, green, and blue. In addition, you have formatted your paper to use a serif font at size 10. **You want to make sure that your paper is easily readable for everyone. What are some things you can do?**

- Colorblind people have high difficulty with red, green, and blue colors. You can check your figures by running a color blind simulator, e.g. open source RGBind.  Consider using colorblind-friendly palettes with colors such as green, magenta, and others. Avoid using color hues to convey information if at all possible. 
- Legally blind and dyslexic people have difficulty with font size and font types. Consider using a font size of 12 or higher, and use a 'Sans-Serif font' such as Arial or Verdana to assist people with dyslexia in reading your manuscript.

**Bonus question:** What should you do if a journal insists on using a font size and font type that is inaccessible to some people?

##### Case Scenario #2: Organizing an inclusive physical event

 You are the head organizer for an open source code hackathon for your organization. Your boss initially suggests using the large seminar room with one projector and screen that is hard to see from the back of the room. When starting the hackathon, you find out that a couple of attendees are deaf and a couple of other attendees have visual difficulties. What are some quick things you could do to help them fully participate in the hackathon?

- If doing a presentation on Powerpoint, you can turn on 'Always use subtitles' for live transcription.
Check if your font size on your presentation is large enough to comfortably see at the back of the room.
- If possible, consider simulcasting the presentation on Zoom or other virtual platform with captions/transcription.
- Use text for communicating with deaf attendees.

##### Case Scenario #3: Organizing an inclusive virtual meeting and preparing in advance

You are organizing a virtual open science meeting with established and prospective members from different countries. You are unsure of what the prospective members need in order to participate fully, and no one emailed you to let you know about accommodations they need. What should you do?

Being proactive with small things you can do ahead of time by implementing some of the accommodations before the meeting (see possible solutions to barriers that we have just considered). While it is difficult to preconceive every possible accommodation that you might need to provide for your members, if you communicate your willingness to do everything you can to help members thrive, you are doing incredibly important work to not only recruit prospective members to open science, but also to retain them.

**Bonus tip:** Subtitles and closed captioning are not only for deaf/hard-of-hearing people, they are also very beneficial for non-native English speakers to understand the conversation fully. Consider using a third-party app such as otter.ai for accurate closed captioning and simultaneous transcripts that can be saved for members to read through. 

**What are some other accommodations that could be useful for everyone in general?**

#### Summary 

In the first part of this lesson, we learned about the types of stakeholders and how they can interact to empower each other. Successful examples were introduced, and you can reflect and analyze how to develop these interactions in your science projects. These arrangements may initially take time, but the outcome is essential to advance science, and is also rewarding.

In the second part of the lesson, we studied how diverse stakeholders can be included in open science with case scenarios designing for inclusion. Taking measures to maximize diversity, inclusion, and accessibility of your science project will  enrich the project,  boost its visibility and engagement of participants. Healthy interactions among stakeholders with diverse members creates the strength of science projects and rewarding results, and a diverse team drives innovation to success. Remember that what you learned here is not an optional choice but an integral part of responsible Open Science. 

To learn more about joining, contributing to, and creating your own communities, consider visiting the Tools module. 

#### Questions/Reflection:

- What steps can you take to make these open science resources more inclusive? 
    - Written resources and images
    - Conferences - virtual, physical, or hybrid
- Communication with the general public and policy makers should not be something that researchers only do when they have spare time, after the research is done and published. It should be treated as a critical part of a science project, to certain extent at all stages of development 
Explain multiple possible communication channels and strategies for researchers, and why each is important. 

