# Opensciency - A core open science curriculum by and for the research community.
<!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->
[![All Contributors](https://img.shields.io/badge/all_contributors-42-orange.svg?style=flat-square)](#contributors-)
<!-- ALL-CONTRIBUTORS-BADGE:END -->
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.7662732.svg)](10.5281/zenodo.7662732)
<a rel="license" href="http://creativecommons.org/licenses/by/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>.

Opensciency is core open science curriculum material, drafted to introduce those beginning their open science journey to important definitions, tools, and resources; and provide for participants at all levels recommended practices. The material is made available under a [CC-BY 4.0 International](https://creativecommons.org/licenses/by/4.0/) license and is structured into five modules:

- Ethos of Open Science
- Open Tools and Resources
- Open Data
- Open Software
- Open Results

## Citation

**The latest release version (V1.0.0) can be found at this DOI 10.5281/zenodo.7662732.**

To credit and cite the material, use the following citation - where possible, please include all authors name as listed in the [CITATION file](https://github.com/opensciency/sprint-content/blob/main/CITATION.cff):
> OpenSciency Contributors (2023, February 22). Opensciency - A core open science curriculum by and for the research community. Zenodo. https://doi.org/10.5281/zenodo.7662732

Shared under the CC-BY 4.0 License, all materials remain open for anyone to build open science curriculums or reuse for other purposes. Please include all author names where possible from the GitHub README contributors table.

## Details

Opensciency is a result of the work of more than 40 open science experts and practitioners from across the world and from different disciplines. The first draft of the curriculum material was developed from [June 27 - July 1, 2022](https://github.com/nasa/Transform-to-Open-Science/blob/main/docs/Area2_Capacity_Sharing/OpenCore/OpenCore_leads.md) as part of the Transform to Open Science (TOPS) [OpenCore](https://github.com/nasa/Transform-to-Open-Science/tree/main/docs/Area2_Capacity_Sharing/OpenCore) sprint. More information about the NASA TOPS initiative is available via their [website](https://science.nasa.gov/open-science/transform-to-open-science). After the TOPS Community Panel on  [October 6, 2022](https://github.com/nasa/Transform-to-Open-Science/blob/main/docs/Area1_Engagement/Community_Panels/20221005_community_panel.md), the original contributors created the Opensciency repository to allow all contributors to further engage with the curriculum and invite review on the initial draft material from the wider research community. 

We encourage the wider community to reuse the material, and we are especially interested in creative approaches to displaying the material. An example we like is [Elements of AI](https://course.elementsofai.com/).

Let us know if you have a creative approach to displaying and reusing the material by [submitting an issue](https://github.com/opensciency/sprint-content/issues). Please provide your contact details so we can add you to the contributors list.

## Contributors ✨

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tbody>
    <tr>
      <td align="center"><a href="http://yo-yehudi.com"><img src="https://avatars.githubusercontent.com/u/9271438?v=4?s=100" width="100px;" alt="Yo Yehudi"/><br /><sub><b>Yo Yehudi</b></sub></a><br /><a href="#mentoring-yochannah" title="Mentoring">🧑‍🏫</a></td>
      <td align="center"><a href="http://natashabatalha.github.io"><img src="https://avatars.githubusercontent.com/u/6554465?v=4?s=100" width="100px;" alt="Natasha Batalha"/><br /><sub><b>Natasha Batalha</b></sub></a><br /><a href="#mentoring-natashabatalha" title="Mentoring">🧑‍🏫</a></td>
      <td align="center"><a href="https://shilaan.rbind.io"><img src="https://avatars.githubusercontent.com/u/61210785?v=4?s=100" width="100px;" alt="Shilaan Alzahawi"/><br /><sub><b>Shilaan Alzahawi</b></sub></a><br /><a href="#mentoring-shilaan" title="Mentoring">🧑‍🏫</a></td>
      <td align="center"><a href="https://github.com/selgebali"><img src="https://avatars.githubusercontent.com/u/23166543?v=4?s=100" width="100px;" alt="Sara"/><br /><sub><b>Sara</b></sub></a><br /><a href="#mentoring-selgebali" title="Mentoring">🧑‍🏫</a></td>
      <td align="center"><a href="https://github.com/camriddell"><img src="https://avatars.githubusercontent.com/u/96146940?v=4?s=100" width="100px;" alt="Cameron"/><br /><sub><b>Cameron</b></sub></a><br /><a href="#mentoring-camriddell" title="Mentoring">🧑‍🏫</a></td>
      <td align="center"><a href="http://talks.dutc.io"><img src="https://avatars.githubusercontent.com/u/3922744?v=4?s=100" width="100px;" alt="James Powell"/><br /><sub><b>James Powell</b></sub></a><br /><a href="#mentoring-dutc" title="Mentoring">🧑‍🏫</a></td>
      <td align="center"><a href="https://github.com/dasaderi"><img src="https://avatars.githubusercontent.com/u/13750121?v=4?s=100" width="100px;" alt="Daniela Saderi"/><br /><sub><b>Daniela Saderi</b></sub></a><br /><a href="#content-dasaderi" title="Content">🖋</a></td>
    </tr>
    <tr>
      <td align="center"><a href="https://github.com/smhall97"><img src="https://avatars.githubusercontent.com/u/43542098?v=4?s=100" width="100px;" alt="smhall97"/><br /><sub><b>smhall97</b></sub></a><br /><a href="#content-smhall97" title="Content">🖋</a></td>
      <td align="center"><a href="https://github.com/Jannatul-Ferdush"><img src="https://avatars.githubusercontent.com/u/38519049?v=4?s=100" width="100px;" alt="Jannatul Ferdush"/><br /><sub><b>Jannatul Ferdush</b></sub></a><br /><a href="#content-Jannatul-Ferdush" title="Content">🖋</a></td>
      <td align="center"><a href="http://flavioazevedo.com/publications"><img src="https://avatars.githubusercontent.com/u/18330492?v=4?s=100" width="100px;" alt="Flavio Azevedo"/><br /><sub><b>Flavio Azevedo</b></sub></a><br /><a href="#content-flavioazevedo" title="Content">🖋</a></td>
      <td align="center"><a href="https://www.michaeljfox.org/"><img src="https://avatars.githubusercontent.com/u/3680365?v=4?s=100" width="100px;" alt="Chris Erdmann"/><br /><sub><b>Chris Erdmann</b></sub></a><br /><a href="#mentoring-libcce" title="Mentoring">🧑‍🏫</a></td>
      <td align="center"><a href="https://github.com/geo-yrao"><img src="https://avatars.githubusercontent.com/u/38257268?v=4?s=100" width="100px;" alt="Yuhan (Douglas) Rao"/><br /><sub><b>Yuhan (Douglas) Rao</b></sub></a><br /><a href="#content-geo-yrao" title="Content">🖋</a></td>
      <td align="center"><a href="https://batool-almarzouq.netlify.app/"><img src="https://avatars.githubusercontent.com/u/53487593?v=4?s=100" width="100px;" alt="Batool Almarzouq"/><br /><sub><b>Batool Almarzouq</b></sub></a><br /><a href="#content-BatoolMM" title="Content">🖋</a></td>
      <td align="center"><a href="https://github.com/EstherPlomp"><img src="https://avatars.githubusercontent.com/u/46314469?v=4?s=100" width="100px;" alt="Esther Plomp"/><br /><sub><b>Esther Plomp</b></sub></a><br /><a href="#content-EstherPlomp" title="Content">🖋</a></td>
    </tr>
    <tr>
      <td align="center"><a href="https://github.com/TomoCoral"><img src="https://avatars.githubusercontent.com/u/98495490?v=4?s=100" width="100px;" alt="TomoCoral"/><br /><sub><b>TomoCoral</b></sub></a><br /><a href="#content-TomoCoral" title="Content">🖋</a></td>
      <td align="center"><a href="https://github.com/melibleq"><img src="https://avatars.githubusercontent.com/u/16723182?v=4?s=100" width="100px;" alt="Melissa Black"/><br /><sub><b>Melissa Black</b></sub></a><br /><a href="#content-melibleq" title="Content">🖋</a></td>
      <td align="center"><a href="http://malvikasharan.github.io/"><img src="https://avatars.githubusercontent.com/u/5370471?v=4?s=100" width="100px;" alt="Malvika Sharan"/><br /><sub><b>Malvika Sharan</b></sub></a><br /><a href="#content-malvikasharan" title="Content">🖋</a></td>
      <td align="center"><a href="https://saranjeetkaur.github.io/About-Me/"><img src="https://avatars.githubusercontent.com/u/28556616?v=4?s=100" width="100px;" alt="Saranjeet Kaur"/><br /><sub><b>Saranjeet Kaur</b></sub></a><br /><a href="#content-SaranjeetKaur" title="Content">🖋</a></td>
      <td align="center"><a href="https://github.com/michelusp"><img src="https://avatars.githubusercontent.com/u/29486679?v=4?s=100" width="100px;" alt="Michel Lacerda"/><br /><sub><b>Michel Lacerda</b></sub></a><br /><a href="#content-michelusp" title="Content">🖋</a></td>
      <td align="center"><a href="https://www.tiki-toki.com/timeline/entry/1753034/A-History-of-Research-Ethics/"><img src="https://avatars.githubusercontent.com/u/64027166?v=4?s=100" width="100px;" alt="Ismael-KG"/><br /><sub><b>Ismael-KG</b></sub></a><br /><a href="#content-Ismael-KG" title="Content">🖋</a></td>
      <td align="center"><a href="https://github.com/andreamedinasmith"><img src="https://avatars.githubusercontent.com/u/6033782?v=4?s=100" width="100px;" alt="andreamedinasmith"/><br /><sub><b>andreamedinasmith</b></sub></a><br /><a href="#content-andreamedinasmith" title="Content">🖋</a></td>
    </tr>
    <tr>
      <td align="center"><a href="https://github.com/aosman12"><img src="https://avatars.githubusercontent.com/u/68354949?v=4?s=100" width="100px;" alt="aosman12"/><br /><sub><b>aosman12</b></sub></a><br /><a href="#content-aosman12" title="Content">🖋</a></td>
      <td align="center"><a href="https://github.com/eliocamp"><img src="https://avatars.githubusercontent.com/u/8617595?v=4?s=100" width="100px;" alt="Elio Campitelli"/><br /><sub><b>Elio Campitelli</b></sub></a><br /><a href="#content-eliocamp" title="Content">🖋</a></td>
      <td align="center"><a href="https://github.com/smklusza"><img src="https://avatars.githubusercontent.com/u/28989267?v=4?s=100" width="100px;" alt="Stephen Klusza"/><br /><sub><b>Stephen Klusza</b></sub></a><br /><a href="#content-smklusza" title="Content">🖋</a></td>
      <td align="center"><a href="https://psychonautgirl.space"><img src="https://avatars.githubusercontent.com/u/17600982?v=4?s=100" width="100px;" alt="Mariana Meireles"/><br /><sub><b>Mariana Meireles</b></sub></a><br /><a href="#content-marimeireles" title="Content">🖋</a></td>
      <td align="center"><a href="https://github.com/karegapauline"><img src="https://avatars.githubusercontent.com/u/27417671?v=4?s=100" width="100px;" alt="Pauline Karega"/><br /><sub><b>Pauline Karega</b></sub></a><br /><a href="#content-karegapauline" title="Content">🖋</a></td>
      <td align="center"><a href="http://www.mn.uio.no/geo/english/people/adm/annefou/"><img src="https://avatars.githubusercontent.com/u/8168508?v=4?s=100" width="100px;" alt="Anne Fouilloux"/><br /><sub><b>Anne Fouilloux</b></sub></a><br /><a href="#content-annefou" title="Content">🖋</a></td>
      <td align="center"><a href="https://github.com/camachoreina"><img src="https://avatars.githubusercontent.com/u/12454015?v=4?s=100" width="100px;" alt="Reina Camacho Toro"/><br /><sub><b>Reina Camacho Toro</b></sub></a><br /><a href="#content-camachoreina" title="Content">🖋</a></td>
    </tr>
    <tr>
      <td align="center"><a href="https://github.com/Sierra-MC"><img src="https://avatars.githubusercontent.com/u/88336748?v=4?s=100" width="100px;" alt="Sierra V. Brown"/><br /><sub><b>Sierra V. Brown</b></sub></a><br /><a href="#content-Sierra-MC" title="Content">🖋</a></td>
      <td align="center"><a href="https://github.com/shmuhammad2004"><img src="https://avatars.githubusercontent.com/u/38854463?v=4?s=100" width="100px;" alt="Shamsudddeen Hassan Muhammad"/><br /><sub><b>Shamsudddeen Hassan Muhammad</b></sub></a><br /><a href="#content-shmuhammad2004" title="Content">🖋</a></td>
      <td align="center"><a href="https://github.com/likeajumprope"><img src="https://avatars.githubusercontent.com/u/23728822?v=4?s=100" width="100px;" alt="Johanna Bayer"/><br /><sub><b>Johanna Bayer</b></sub></a><br /><a href="#content-likeajumprope" title="Content">🖋</a></td>
      <td align="center"><a href="http://www.shanahanlab.org"><img src="https://avatars.githubusercontent.com/u/3338109?v=4?s=100" width="100px;" alt="Hugh Shanahan"/><br /><sub><b>Hugh Shanahan</b></sub></a><br /><a href="#content-hughshanahan" title="Content">🖋</a></td>
      <td align="center"><a href="https://github.com/MiguelSilan"><img src="https://avatars.githubusercontent.com/u/32735330?v=4?s=100" width="100px;" alt="MiguelSilan"/><br /><sub><b>MiguelSilan</b></sub></a><br /><a href="#content-MiguelSilan" title="Content">🖋</a></td>
      <td align="center"><a href="https://github.com/Elpapado"><img src="https://avatars.githubusercontent.com/u/16916017?v=4?s=100" width="100px;" alt="Elli Papadopoulou"/><br /><sub><b>Elli Papadopoulou</b></sub></a><br /><a href="#content-Elpapado" title="Content">🖋</a></td>
      <td align="center"><a href="https://danieljdunleavy.netlify.app/"><img src="https://avatars.githubusercontent.com/u/30324612?v=4?s=100" width="100px;" alt="dunldj"/><br /><sub><b>dunldj</b></sub></a><br /><a href="#content-dunldj" title="Content">🖋</a></td>
    </tr>
    <tr>
      <td align="center"><a href="https://github.com/AnaVaz-NOAA"><img src="https://avatars.githubusercontent.com/u/94488549?v=4?s=100" width="100px;" alt="Ana Vaz"/><br /><sub><b>Ana Vaz</b></sub></a><br /><a href="#content-AnaVaz-NOAA" title="Content">🖋</a></td>
      <td align="center"><a href="http://tysonswetnam.com"><img src="https://avatars.githubusercontent.com/u/11527041?v=4?s=100" width="100px;" alt="Tyson L. Swetnam"/><br /><sub><b>Tyson L. Swetnam</b></sub></a><br /><a href="#content-tyson-swetnam" title="Content">🖋</a></td>
      <td align="center"><a href="https://github.com/BabatundeOnabajo"><img src="https://avatars.githubusercontent.com/u/36359216?v=4?s=100" width="100px;" alt="Babatunde Valentine Onabajo"/><br /><sub><b>Babatunde Valentine Onabajo</b></sub></a><br /><a href="#content-BabatundeOnabajo" title="Content">🖋</a></td>
      <td align="center"><a href="https://cheginit.github.io"><img src="https://avatars.githubusercontent.com/u/13016644?v=4?s=100" width="100px;" alt="Taher Chegini"/><br /><sub><b>Taher Chegini</b></sub></a><br /><a href="#content-cheginit" title="Content">🖋</a></td>
      <td align="center"><a href="https://github.com/ee2110"><img src="https://avatars.githubusercontent.com/u/52744798?v=4?s=100" width="100px;" alt="ee2110"/><br /><sub><b>ee2110</b></sub></a><br /><a href="#content-ee2110" title="Content">🖋</a></td>
      <td align="center"><a href="https://github.com/rebeccaringuette"><img src="https://avatars.githubusercontent.com/u/49281118?v=4?s=100" width="100px;" alt="rebeccaringuette"/><br /><sub><b>rebeccaringuette</b></sub></a><br /><a href="#content-rebeccaringuette" title="Content">🖋</a></td>
      <td align="center"><a href="https://github.com/msundukova"><img src="https://avatars.githubusercontent.com/u/34685833?v=4?s=100" width="100px;" alt="Mayya"/><br /><sub><b>Mayya</b></sub></a><br /><a href="#content-msundukova" title="Content">🖋</a></td>
    </tr>
  </tbody>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!
