################## Analyses of " Acoustic cues and season affect mobbing responses in a bird community " ########
################## Revision for Peer Community In Ecology #####
################## Hurdle models assessed with BIC #########
################## October 2022 - A. Salis ####



#### Data set #### 

DataA<-read.table("CompleteV2.txt", h=T)

# Making sure our variables are seen as factors : 
DataA$Species<-as.factor(DataA$Species)
DataA$NbEmet<-as.factor(DataA$NbEmet)
DataA$Season<-as.factor(DataA$Season)
DataA$Playback<-as.factor(DataA$Playback)
DataA$Point<-as.factor(DataA$Point)
DataA$NbEmet <- as.ordered(factor(DataA$NbEmet, levels =  c("three","one")))
summary(DataA)

# packages
library(glmmTMB)# hurdle
library(DHARMa)# check model


# Two subset for each season: 
DataWinter<-DataA[DataA$Season=="Winter",]
DataSpring<-DataA[DataA$Season=="Spring",]




################################### 1. Selection of the distribution of the model ##########

##### Winter- Community
Hurdle_Poisson<-glmmTMB(Nb_Total ~ Species * NbEmet + (1|Point)+ (1|Playback), 
                          zi=~Species * NbEmet+ (1|Point)+ (1|Playback),
                          family=truncated_poisson, data=DataWinter,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))

Hurdle_NegBinom1<-glmmTMB(Nb_Total ~ Species * NbEmet + (1|Point)+ (1|Playback), 
                          zi=~Species * NbEmet+ (1|Point)+ (1|Playback),
                          family=truncated_nbinom1, data=DataWinter,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))


Hurdle_NegBinom2<-glmmTMB(Nb_Total ~ Species * NbEmet + (1|Point)+ (1|Playback), 
                 zi=~Species * NbEmet+ (1|Point)+ (1|Playback),
                 family=truncated_nbinom2, data=DataWinter,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))


AA<-BIC(Hurdle_Poisson, Hurdle_NegBinom1, Hurdle_NegBinom2)


######## Weighted BIC : 
bicmin <- min(AA$BIC)
delta <- AA$BIC-bicmin
expw <- exp(-delta/2)
w <-expw/sum(expw)
result <- data.frame(w,AA,delta)
result[order(w,decreasing =TRUE),]


##### Winter- Coal
Hurdle_Poisson<-glmmTMB(Nb_Coal_Mob ~ Species * NbEmet + (1|Point)+ (1|Playback), 
                        zi=~Species * NbEmet+ (1|Point)+ (1|Playback),
                        family=truncated_poisson, data=DataWinter,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))

Hurdle_NegBinom1<-glmmTMB(Nb_Coal_Mob ~ Species * NbEmet + (1|Point)+ (1|Playback), 
                          zi=~Species * NbEmet+ (1|Point)+ (1|Playback),
                          family=truncated_nbinom1, data=DataWinter,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))


Hurdle_NegBinom2<-glmmTMB(Nb_Coal_Mob ~ Species * NbEmet + (1|Point)+ (1|Playback), 
                          zi=~Species * NbEmet+ (1|Point)+ (1|Playback),
                          family=truncated_nbinom2, data=DataWinter,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))

AA<-BIC(Hurdle_Poisson, Hurdle_NegBinom1, Hurdle_NegBinom2)

######## Weighted BIC : 
bicmin <- min(AA$BIC)
delta <- AA$BIC-bicmin
expw <- exp(-delta/2)
w <-expw/sum(expw)
result <- data.frame(w,AA,delta)
result[order(w,decreasing =TRUE),]




##### Winter- Crested
Hurdle_Poisson<-glmmTMB(Nb_Crested_Mob ~ Species * NbEmet + (1|Point)+ (1|Playback), 
                        zi=~Species * NbEmet+ (1|Point)+ (1|Playback),
                        family=truncated_poisson, data=DataWinter,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))

Hurdle_NegBinom1<-glmmTMB(Nb_Crested_Mob ~ Species * NbEmet + (1|Point)+ (1|Playback), 
                          zi=~Species * NbEmet+ (1|Point)+ (1|Playback),
                          family=truncated_nbinom1, data=DataWinter,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))


Hurdle_NegBinom2<-glmmTMB(Nb_Crested_Mob ~ Species * NbEmet + (1|Point)+ (1|Playback), 
                          zi=~Species * NbEmet+ (1|Point)+ (1|Playback),
                          family=truncated_nbinom2, data=DataWinter,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))

AA<-BIC(Hurdle_Poisson, Hurdle_NegBinom1, Hurdle_NegBinom2)

######## Weighted BIC : 
bicmin <- min(AA$BIC)
delta <- AA$BIC-bicmin
expw <- exp(-delta/2)
w <-expw/sum(expw)
result <- data.frame(w,AA,delta)
result[order(w,decreasing =TRUE),]



##### Spring- Community
Hurdle_Poisson<-glmmTMB(Nb_Total ~ Species * NbEmet + (1|Point)+ (1|Playback), 
                        zi=~Species * NbEmet+ (1|Point)+ (1|Playback),
                        family=truncated_poisson, data=DataSpring,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))

Hurdle_NegBinom1<-glmmTMB(Nb_Total ~ Species * NbEmet + (1|Point)+ (1|Playback), 
                          zi=~Species * NbEmet+ (1|Point)+ (1|Playback),
                          family=truncated_nbinom1, data=DataSpring,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))


Hurdle_NegBinom2<-glmmTMB(Nb_Total ~ Species * NbEmet + (1|Point)+ (1|Playback), 
                          zi=~Species * NbEmet+ (1|Point)+ (1|Playback),
                          family=truncated_nbinom2, data=DataSpring,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))

AA<-BIC(Hurdle_Poisson, Hurdle_NegBinom1, Hurdle_NegBinom2)

######## Weighted BIC : 
bicmin <- min(AA$BIC)
delta <- AA$BIC-bicmin
expw <- exp(-delta/2)
w <-expw/sum(expw)
result <- data.frame(w,AA,delta)
result[order(w,decreasing =TRUE),]




##### Spring- Coal
Hurdle_Poisson<-glmmTMB(Nb_Coal_Mob ~ Species * NbEmet + (1|Point)+ (1|Playback), 
                        zi=~Species * NbEmet+ (1|Point)+ (1|Playback),
                        family=truncated_poisson, data=DataSpring,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))

Hurdle_NegBinom1<-glmmTMB(Nb_Coal_Mob ~ Species * NbEmet + (1|Point)+ (1|Playback), 
                          zi=~Species * NbEmet+ (1|Point)+ (1|Playback),
                          family=truncated_nbinom1, data=DataSpring,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))


Hurdle_NegBinom2<-glmmTMB(Nb_Coal_Mob ~ Species * NbEmet + (1|Point)+ (1|Playback), 
                          zi=~Species * NbEmet+ (1|Point)+ (1|Playback),
                          family=truncated_nbinom2, data=DataSpring,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))


AA<-BIC(Hurdle_Poisson, Hurdle_NegBinom1, Hurdle_NegBinom2)

######## Weighted BIC : 
bicmin <- min(AA$BIC)
delta <- AA$BIC-bicmin
expw <- exp(-delta/2)
w <-expw/sum(expw)
result <- data.frame(w,AA,delta)
result[order(w,decreasing =TRUE),]





##### Spring- Crested
Hurdle_Poisson<-glmmTMB(Nb_Crested_Mob ~ Species * NbEmet, 
                        zi=~Species * NbEmet,
                        family=truncated_poisson, data=DataSpring,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))

Hurdle_NegBinom1<-glmmTMB(Nb_Crested_Mob ~ Species * NbEmet, 
                          zi=~Species * NbEmet,
                          family=truncated_nbinom1, data=DataSpring,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))


Hurdle_NegBinom2<-glmmTMB(Nb_Crested_Mob ~ Species * NbEmet, 
                          zi=~Species * NbEmet,
                          family=truncated_nbinom2, data=DataSpring,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))

AA<-BIC(Hurdle_Poisson, Hurdle_NegBinom1, Hurdle_NegBinom2)

######## Weighted BIC : 
bicmin <- min(AA$BIC)
delta <- AA$BIC-bicmin
expw <- exp(-delta/2)
w <-expw/sum(expw)
result <- data.frame(w,AA,delta)
result[order(w,decreasing =TRUE),]



############## CCL : NegBinom for the community, and Poisson for the individual species #########





################################### 2. Model selection with BIC ########################

######################## 2A. General Community - WINTER ###########


# We create the four models with the interaction, or not, in the presence/absence and in the count parts of the model.


# SP*Nb - SP*Nb
Hurdle1<-glmmTMB(Nb_Total ~ Species * NbEmet + (1|Point)+ (1|Playback), 
                 zi=~Species * NbEmet+ (1|Point)+ (1|Playback),
                 family=truncated_nbinom2, data=DataWinter,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))
summary(testResiduals(Hurdle1))
summary(Hurdle1)

# SP*NB - SP+Nb
Hurdle2<-glmmTMB(Nb_Total ~ Species * NbEmet + (1|Point)+ (1|Playback), 
                 zi=~Species + NbEmet+ (1|Point)+ (1|Playback),
                 family=truncated_nbinom2, data=DataWinter,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))
summary(testResiduals(Hurdle2))
summary(Hurdle2)

# SP+NB - SP*NB
Hurdle3<-glmmTMB(Nb_Total ~ Species + NbEmet + (1|Point)+ (1|Playback), 
                 zi=~Species * NbEmet+ (1|Point)+ (1|Playback),
                 family=truncated_nbinom2, data=DataWinter,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))
summary(testResiduals(Hurdle3))
summary(Hurdle3)

# SP+NB - SP+NB
Hurdle4<-glmmTMB(Nb_Total ~ Species + NbEmet + (1|Point)+ (1|Playback), 
                 zi=~Species + NbEmet+ (1|Point)+ (1|Playback),
                 family=truncated_nbinom2, data=DataWinter,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))
summary(testResiduals(Hurdle4))
summary(Hurdle4)





######## List of all the BIC : 

AA<-BIC(Hurdle1, Hurdle2, Hurdle3, Hurdle4)
AA
######## Weighted BIC : 

bicmin <- min(AA$BIC)
delta <- AA$BIC-bicmin
expw <- exp(-delta/2)
w <-expw/sum(expw)
result <- data.frame(w,AA,delta)
result[order(w,decreasing =TRUE),]

# Hurdle 4 > other models (additive effect in both parts)





######################## 2B. General Community - SPRING ###########

# SP*Nb - SP*Nb
Hurdle5<-glmmTMB(Nb_Total ~ Species * NbEmet + (1|Point)+ (1|Playback), 
                 zi=~Species * NbEmet+ (1|Point)+ (1|Playback),
                 family=truncated_nbinom1, data=DataSpring,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))
summary(testResiduals(Hurdle5))
summary(Hurdle5)

# SP*NB - SP+Nb
Hurdle6<-glmmTMB(Nb_Total ~ Species * NbEmet + (1|Point)+ (1|Playback), 
                 zi=~Species + NbEmet+ (1|Point)+ (1|Playback),
                 family=truncated_nbinom1, data=DataSpring,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))
summary(testResiduals(Hurdle6))
summary(Hurdle6)


# SP+NB - SP*NB
Hurdle7<-glmmTMB(Nb_Total ~ Species + NbEmet + (1|Point)+ (1|Playback), 
                 zi=~Species * NbEmet+ (1|Point)+ (1|Playback),
                 family=truncated_nbinom1, data=DataSpring,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))
summary(testResiduals(Hurdle7))
summary(Hurdle7)

# SP+NB - SP+NB
Hurdle8<-glmmTMB(Nb_Total ~ Species + NbEmet + (1|Point)+ (1|Playback), 
                 zi=~Species + NbEmet+ (1|Point)+ (1|Playback),
                 family=truncated_nbinom1, data=DataSpring,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))
summary(testResiduals(Hurdle8))
summary(Hurdle8)


######### List of all the BIC :
AA<-BIC( Hurdle5, Hurdle6, Hurdle7, Hurdle8)
AA

######## Weighted BIC : 

bicmin <- min(AA$BIC)
delta <- AA$BIC-bicmin
expw <- exp(-delta/2)
w <-expw/sum(expw)
result <- data.frame(w,AA,delta)
result[order(w,decreasing =TRUE),]

# Hurdle 7 is the best supported model (interaction on occurrence only), but Hurdle 8 has a similar BIC.


######################## 2C. Coal - WINTER ###########


# SP*Nb - SP*Nb
Hurdle9<-glmmTMB(Nb_Coal_Mob ~ Species * NbEmet + (1|Point)+ (1|Playback), 
                 zi=~Species * NbEmet+ (1|Point)+ (1|Playback),
                 family=truncated_poisson, data=DataWinter,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))
summary(testResiduals(Hurdle9))
summary(Hurdle9)

# SP*NB - SP+Nb
Hurdle10<-glmmTMB(Nb_Coal_Mob ~ Species * NbEmet + (1|Point)+ (1|Playback), 
                 zi=~Species + NbEmet+ (1|Point)+ (1|Playback),
                 family=truncated_poisson, data=DataWinter,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))
summary(testResiduals(Hurdle10))
summary(Hurdle10)

# SP+NB - SP*NB
Hurdle11<-glmmTMB(Nb_Coal_Mob ~ Species + NbEmet + (1|Point)+ (1|Playback), 
                 zi=~Species * NbEmet+ (1|Point)+ (1|Playback),
                 family=truncated_poisson, data=DataWinter,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))
summary(testResiduals(Hurdle11))
summary(Hurdle11)

# SP+NB - SP+NB
Hurdle12<-glmmTMB(Nb_Coal_Mob ~ Species + NbEmet + (1|Point)+ (1|Playback), 
                 zi=~Species + NbEmet+ (1|Point)+ (1|Playback),
                 family=truncated_poisson, data=DataWinter,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))
summary(testResiduals(Hurdle12))
summary(Hurdle12)


###### List of all the BIC:
AA<-BIC(Hurdle9, Hurdle10, Hurdle11, Hurdle12)
AA

######## Weighted BIC : 

bicmin <- min(AA$BIC)
delta <- AA$BIC-bicmin
expw <- exp(-delta/2)
w <-expw/sum(expw)
result <- data.frame(w,AA,delta)
result[order(w,decreasing =TRUE),]

# Hurdle 12 is the best supported model (additive effect on both parts)





######################## 2D. Coal - SPRING ###########

# SP*Nb - SP*Nb
Hurdle13<-glmmTMB(Nb_Coal_Mob ~ Species * NbEmet + (1|Point)+ (1|Playback), 
                 zi=~Species * NbEmet+ (1|Point)+ (1|Playback),
                 family=truncated_poisson, data=DataSpring,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))
summary(testResiduals(Hurdle13))
summary(Hurdle13)

# SP*NB - SP+Nb
Hurdle14<-glmmTMB(Nb_Coal_Mob ~ Species * NbEmet + (1|Point)+ (1|Playback), 
                 zi=~Species + NbEmet+ (1|Point)+ (1|Playback),
                 family=truncated_poisson, data=DataSpring,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))
summary(testResiduals(Hurdle14))
summary(Hurdle14)

# SP+NB - SP*NB
Hurdle15<-glmmTMB(Nb_Coal_Mob ~ Species + NbEmet + (1|Point)+ (1|Playback), 
                 zi=~Species * NbEmet+ (1|Point)+ (1|Playback),
                 family=truncated_poisson, data=DataSpring,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))
summary(testResiduals(Hurdle15))
summary(Hurdle15)

# SP+NB - SP+NB
Hurdle16<-glmmTMB(Nb_Coal_Mob ~ Species + NbEmet + (1|Point)+ (1|Playback), 
                 zi=~Species + NbEmet+ (1|Point)+ (1|Playback),
                 family=truncated_poisson, data=DataSpring,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))
summary(testResiduals(Hurdle16))
summary(Hurdle16)


####### List of all the BIC: 

AA<-BIC(Hurdle13, Hurdle14, Hurdle15, Hurdle16)
AA


######## Weighted BIC : 

bicmin <- min(AA$BIC)
delta <- AA$BIC-bicmin
expw <- exp(-delta/2)
w <-expw/sum(expw)
result <- data.frame(w,AA,delta)
result[order(w,decreasing =TRUE),]

# Hurdle 16 is the best supported model (additive effect)


######################## 2E. Crested - WINTER ###########


# SP*Nb - SP*Nb
Hurdle17<-glmmTMB(Nb_Crested_Mob ~ Species * NbEmet  , 
                 zi=~Species * NbEmet ,
                 family=truncated_poisson, data=DataWinter,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))

summary(testResiduals(Hurdle17))
summary(Hurdle17)


# SP*NB - SP+Nb
Hurdle18<-glmmTMB(Nb_Crested_Mob ~ Species * NbEmet  , 
                 zi=~Species + NbEmet ,
                 family=truncated_poisson, data=DataWinter,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))
summary(testResiduals(Hurdle18))
summary(Hurdle18)

# SP+NB - SP*NB
Hurdle19<-glmmTMB(Nb_Crested_Mob ~ Species + NbEmet  , 
                 zi=~Species * NbEmet ,
                 family=truncated_poisson, data=DataWinter,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))
summary(testResiduals(Hurdle19))
summary(Hurdle19)

# SP+NB - SP+NB
Hurdle20<-glmmTMB(Nb_Crested_Mob ~ Species + NbEmet  , 
                 zi=~Species + NbEmet ,
                 family=truncated_poisson, data=DataWinter,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))
summary(testResiduals(Hurdle20))
summary(Hurdle20)


####### List of all the BIC: 

AA<-BIC( Hurdle17, Hurdle18, Hurdle19, Hurdle20)
AA

######## Weighted BIC : 

bicmin <- min(AA$BIC)
delta <- AA$BIC-bicmin
expw <- exp(-delta/2)
w <-expw/sum(expw)
result <- data.frame(w,AA,delta)
result[order(w,decreasing =TRUE),]

# Hurdle 20 has the best BIC, shortly followed by Hurdle 19

######################## 2F. Crested - SPRING ###########

# SP*Nb - SP*Nb
Hurdle21<-glmmTMB(Nb_Crested_Mob ~ Species * NbEmet  , 
                 zi=~Species * NbEmet ,
                 family=truncated_poisson, data=DataSpring,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))
summary(testResiduals(Hurdle21))
summary(Hurdle21)

# SP*NB - SP+Nb
Hurdle22<-glmmTMB(Nb_Crested_Mob ~ Species * NbEmet  , 
                 zi=~Species + NbEmet ,
                 family=truncated_poisson, data=DataSpring,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))
summary(testResiduals(Hurdle22))
summary(Hurdle22)

# SP+NB - SP*NB
Hurdle23<-glmmTMB(Nb_Crested_Mob ~ Species + NbEmet  , 
                 zi=~Species * NbEmet ,
                 family=truncated_poisson, data=DataSpring,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))
summary(testResiduals(Hurdle23))
summary(Hurdle23)


# SP+NB - SP+NB
Hurdle24<-glmmTMB(Nb_Crested_Mob ~ Species + NbEmet  , 
                 zi=~Species + NbEmet ,
                 family=truncated_poisson, data=DataSpring,  control = glmmTMBControl(optimizer = optim, optArgs = list(method="BFGS")))
summary(testResiduals(Hurdle24))
summary(Hurdle24)

####### List of all the BIC: 

AA<-BIC(Hurdle21, Hurdle22, Hurdle23, Hurdle24)


######## Weighted BIC : 
bicmin <- min(AA$BIC)
delta <- AA$BIC-bicmin
expw <- exp(-delta/2)
w <-expw/sum(expw)
result <- data.frame(w,AA,delta)
result[order(w,decreasing =TRUE),]

# Hurdle 23 selected, but HUrdle 24 quite close






