var http=require("http");
var fs=require("fs");

//创建web服务器
var server = http.createServer();
/*
    提供数据服务,注册request请求事件，当客户端请求，自动执行回调函数
    request 请求对象，获取客户端的一些请求信息
    response 响应对象，给客户端发送响应消息
*/
server.on('request', function (request, response) {
    //response使用Write来向客户端发送数据，但是一定要用end来结束响应数据
    var pathname = request.url.slice(1); // request.url 返回的是/index.html
    // 读取文件内容
    fs.readFile(pathname, function (err, data) {
        if (err) {
            // 读取失败了
        } else {
            // 将读取到的内容返回
            response.setHeader('content-type', 'text/html;charset=utf-8'); //这个很重要，设置编码方式是utf-8
            response.write(data.toString());
        }
        response.end();
    });
});

//绑定端口号启动服务器
server.listen(6060, function () {
    console.log('服务器启动成功，可以通过"http://127.0.0.1:6060/"来进行访问');
});
