const path = require("path");
const fs = require("fs");
const fse = require("fs-extra");
const shell = require("shelljs");

// import * as path from 'path';
// import * as fs from 'fs';
// import * as fse from 'fs-extra';
// import shell from 'shelljs';

module.exports = function (babel) {
  const { types: t, template } = babel;

  // Determine if a package is installed
  const hasPkg = (pkg) => {
    const pkgPath = path.join(process.cwd(), `package.json`);
    const pkgJson = fs.existsSync(pkgPath) ? fse.readJsonSync(pkgPath) : {};
    const { dependencies = {}, devDependencies = {} } = pkgJson;
    return dependencies[pkg] || devDependencies[pkg];
  };

  // Install a package
  const installPkg = (pkg) => {
    console.log(`Begin install ${pkg}`);
    const npm = shell.which("npm");
    if (!npm) {
      console.log("Please install npm");
      return;
    }
    const { code } = shell.exec(`${npm.stdout} install ${pkg} -S`);
    if (code) {
      console.log(`Install ${pkg} failure, please install manually`);
    }
  };

  // Babel core logic
  const visitor = {
    // import package
    Program(path, state) {
      const pkgName = state.opts.pkgName;
      const statements = state.opts.statements;

      if (!!pkgName) {
        const bodyPath = path.get("body");

        const isImport = bodyPath.some((nodePath) => {
          if (nodePath.isImportDeclaration()) {
            return (
              nodePath.get("source").isStringLiteral() &&
              nodePath.get("source").node.value === pkgName
            );
          }
        });

        if (!isImport) {
          const importDefaultSpecifier = [
            t.ImportDefaultSpecifier(t.Identifier(statements)),
          ];
          const importDeclaration = t.ImportDeclaration(
            importDefaultSpecifier,
            t.StringLiteral(pkgName)
          );
          path.get("body")[0].insertBefore(importDeclaration);
        }

        if (!hasPkg(pkgName)) {
          installPkg(pkgName);
        }
      }
    },

    FunctionDeclaration(path, state) {
      const type = state.opts.type;
      const functionName = state.opts.functionName;

      // add method
      if (type === "add") {
        // const lineNumber = state.opts.lineNumber;
        const statements = state.opts.statements;
        const waitValue = state.opts.waitValue;

        path.traverse(
          {
            Identifier(path) {
              if (path.isIdentifier({ name: `${functionName}` })) {
                let functionPath = this.functionPath;

                functionPath.traverse({
                  BlockStatement(path) {
                    // position in function lineNumber
                    // add statements
                    path.node.body.splice(
                      lineNumber,
                      0,
                      t.expressionStatement(
                        // await method
                        t.awaitExpression(
                          t.callExpression(t.identifier(statements), [
                            t.numericLiteral(waitValue),
                          ])
                        )
                        // t.callExpression(t.identifier(statements), [
                        //   t.numericLiteral(waitValue),
                        // ])
                      )
                    );
                  },
                });
              }
            },
          },
          { functionPath: path }
        );
      }

      // update method
      if (type === "update") {
        const methodName = state.opts.methodName;
        const waitValue = state.opts.waitValue;
        console.log("methodName", methodName.split("."));
        let nameArr = methodName.split(".");
        let packageName = "";
        let funcName = "";
        if (nameArr.length > 1) {
          packageName = nameArr[0];
          funcName = nameArr[1];
        } else {
          funcName = nameArr[0];
        }

        path.traverse(
          {
            Identifier(path) {
              if (path.isIdentifier({ name: `${functionName}` })) {
                let functionPath = this.functionPath;

                functionPath.traverse({
                  CallExpression(path) {
                    if (!!packageName) {
                      let { callee } = path.node;
                      if (
                        callee.type === "MemberExpression" &&
                        callee.object.name === `${packageName}` &&
                        callee.property.name === `${funcName}`
                      ) {
                        console.log("hello", path.node.arguments[0].value);
                        path.node.arguments.splice(
                          0,
                          1,
                          t.numericLiteral(waitValue)
                        );
                      }
                    } else {
                      let { callee } = path.node;
                      console.log("callee", callee.name);
                      if (callee.name === `${funcName}`) {
                        path.node.arguments.splice(
                          0,
                          1,
                          t.numericLiteral(waitValue)
                        );
                      }
                    }
                  },
                });
              }
            },
          },
          { functionPath: path }
        );
      }
    },

    CallExpression(path, state) {
      const type = state.opts.type;
      // const lineNumber = state.opts.lineNumber;
      const statements = state.opts.statements;
      const waitValue = state.opts.waitValue;
      const functionName = state.opts.functionName;

      const getLineNumber = () => {
        const variableName = state.opts.variableName;
        const functionName = state.opts.functionName;
        let nodeArr = [];
        let lineArr = [];
        let funcLine = [];

        let { callee } = path.node;
        if (callee.type === "Identifier" && callee.name === `${functionName}`) {
          funcLine.push(callee.loc.start.line);
          path.traverse(
            {
              Identifier(path) {
                if (path.isIdentifier({ name: `${variableName}` })) {
                  nodeArr.push(path.node);

                  if (lineArr.indexOf(path.node.loc.start.line - funcLine[0]) == -1) {
                    // Exclude the expect statement
                    lineArr.push(path.node.loc.start.line - funcLine[0]);

                    // if (
                    //   !path.parent.callee ||
                    //   path.parent.callee.name !== "expect"
                    // ) {
                    //   lineArr.push(path.node.loc.start.line);
                    // }
                  }
                }
              },
            },
            { functionPath: path }
          );
          console.log("line", lineArr);
        }
        return lineArr;
      };

      let { callee } = path.node;

      if (callee.type === "Identifier" && callee.name === `${functionName}`) {
        if (type === "add") {
          const lineNumber = getLineNumber();
          console.log("get line number", lineNumber[0]);

          path.traverse(
            {
              Identifier(path) {
                if (path.isIdentifier({ name: `${functionName}` })) {
                  let functionPath = this.functionPath;

                  let sm = t.expressionStatement(
                    t.awaitExpression(
                      t.callExpression(t.identifier(statements), [
                        t.numericLiteral(waitValue),
                      ])
                    )
                  );

                  functionPath.traverse({
                    BlockStatement(path) {
                      let len = lineNumber.length;
                      for (let i = 0; i < len; i++) {
                        path.node.body.splice(
                          lineNumber[i] - 1 + i,
                          0,
                          sm
                        );
                      }
                    },
                  });
                }
              },
            },
            { functionPath: path }
          );
        } else if (type === "update") {
          path.traverse(
            {
              Identifier(path) {
                if (path.isIdentifier({ name: `${functionName}` })) {
                  let functionPath = this.functionPath;

                  functionPath.traverse({
                    BlockStatement(path) {
                      path.node.body.splice(
                        lineNumber,
                        1,
                        t.expressionStatement(
                          // t.callExpression(t.identifier(statements), [
                          //   t.numericLiteral(waitValue),
                          // ])
                          t.awaitExpression(
                            t.callExpression(t.identifier(statements), [
                              t.numericLiteral(waitValue),
                            ])
                          )
                        )
                      );
                    },
                  });
                }
              },
            },
            { functionPath: path }
          );
        }
      }
    },
  };

  return {
    name: "plugin_handle_wait",
    visitor,
  };
};
