/**
 * Based on function name
 * Add wait time
 * 
 * function name: add
 * modify: add page.wait(200)
 * example:
 * function add(foo, bar) {
    console.log(a, b)
    let a = 12;
    return foo + bar
  }
 */
const babel = require('babel-core')
const t = require('babel-types')
var fs = require('fs');
let code = fs.readFileSync('code/code2.js', "utf8");

const visitor = {

  FunctionDeclaration(path, state) { 
    path.traverse({
        Identifier(path){
            if(path.isIdentifier({ name: `${state.opts.name}` })){ // function name

                let functionPath = this.functionPath;

                functionPath.traverse({
                    BlockStatement(path){
                        // position in function state.opts.lineNumber
                        path.node.body.splice(state.opts.lineNumber, 0,
                          t.expressionStatement(
                              t.awaitExpression(t.callExpression(t.identifier(state.opts.statements), [t.numericLiteral(state.opts.wait)]))
                          )
                        )
                    }
                })
            }
        }   
    },{functionPath:path})
  },
}

const result = babel.transform(code, {
  plugins: [
   [
    { visitor }, 
    { 
      name: 'add', 
      statements: 'page.wait', 
      lineNumber: 0,
      wait:  300
    }
   ]
  ]
})

// fs.writeFileSync('./code.js', result.code);

console.log(result.code)
