

describe('selector is visible', () => {

    test('should return false when selector is removed from DOM', async () => {
      // Given
      browser = await launchBrowser({
        headless: true,
        executablePath: getChromePath(),
      });

      const page = await browser.newPage();
      await page.goto(`file:${path.join(__dirname, 'is-visible.test1.html')}`);
  
      // When
      const previousVisibilityStatus = await SUT.isVisible('#visible-then-removed', page);
      // await page.waitFor(450);
      const currentVisibilityStatus = await SUT.isVisible('#visible-then-removed', page);
  
      // Then
      expect(previousVisibilityStatus).toBe(true);
      expect(currentVisibilityStatus).toBe(false);
    });
    
  });
  