## load package
require(abcrf)

## load input files
m1<-read.table("model1",h=T)
m2<-read.table("model2",h=T)
m3<-read.table("model3",h=T)
m4<-read.table("model4",h=T)
m5<-read.table("model5",h=T)
m6<-read.table("model6",h=T)
obs<-read.table("OBS",h=T)

stat<-colnames(obs)

sm1<-cbind(m1[,stat])
sm2<-cbind(m2[,stat])
sm3<-cbind(m3[,stat])
sm4<-cbind(m4[,stat])
sm5<-cbind(m5[,stat])
sm6<-cbind(m6[,stat])

s<-rbind(sm1[(1:50000),], sm2[(1:50000),], sm3[(1:50000),], sm4[(1:50000),], sm5[(1:50000),], sm6[(1:50000),])
i<-factor(c(rep(1,50000),rep(2,50000),rep(3,50000),rep(4,50000),rep(5,50000),rep(6,50000)))
f<-apply(s,2,var)!=0
da<-data.frame(i,s[,f])

## constructs a random forest from a reference table towards performing an ABC model choice
a<-abcrf(i~.,data=da,lda=T,ntree=500,paral=T,ncores=8)

## predicts the best model for new data and evaluate the posterior probability
b<-predict(object=a,obs=rbind(obs[,f],obs[,f]),training=da,ntree=500,paral=T,paral.predict=T,ncores=8,ncores.predict=8)

## provides both a variable importance plot of a model choice ABC-RF object and the projection of the reference table on the LDA axes
plot(a,da,obs,pdf=T)

