import numpy
import matplotlib.pyplot as plt
import matplotlib.font_manager
plt.rcParams["font.family"] = "Times New Roman"
plt.rcParams["font.size"] = "12"
plt.rcParams["figure.figsize"] = (5,4)
import sys
from paraview.simple import *


paraview.simple._DisableFirstRenderCameraReset()

controlDict = OpenFOAMReader(registrationName='controlDict', FileName='./system/controlDict')
controlDict.MeshRegions = ['copper/internalMesh', 'air/internalMesh', 'water/internalMesh']
controlDict.CellArrays = ['Nu', 'T', 'U', 'p', 'p_rgh', 'rho']

animationScene1 = GetAnimationScene()

animationScene1.UpdateAnimationUsingDataTimeSteps()

renderView1 = GetActiveViewOrCreate('RenderView')

controlDictDisplay = Show(controlDict, renderView1, 'UnstructuredGridRepresentation')

pLUT = GetColorTransferFunction('p')
pLUT.RGBPoints = [0.0, 0.231373, 0.298039, 0.752941, 50276.54296875, 0.865003, 0.865003, 0.865003, 100553.0859375, 0.705882, 0.0156863, 0.14902]
pLUT.ScalarRangeInitialized = 1.0

pPWF = GetOpacityTransferFunction('p')
pPWF.Points = [0.0, 0.0, 0.5, 0.0, 100553.0859375, 1.0, 0.5, 0.0]
pPWF.ScalarRangeInitialized = 1

controlDictDisplay.Representation = 'Surface'
controlDictDisplay.ColorArrayName = ['POINTS', 'p']
controlDictDisplay.LookupTable = pLUT
controlDictDisplay.SelectTCoordArray = 'None'
controlDictDisplay.SelectNormalArray = 'None'
controlDictDisplay.SelectTangentArray = 'None'
controlDictDisplay.OSPRayScaleArray = 'p'
controlDictDisplay.OSPRayScaleFunction = 'PiecewiseFunction'
controlDictDisplay.SelectOrientationVectors = 'U'
controlDictDisplay.ScaleFactor = 0.2649999976158142
controlDictDisplay.SelectScaleArray = 'p'
controlDictDisplay.GlyphType = 'Arrow'
controlDictDisplay.GlyphTableIndexArray = 'p'
controlDictDisplay.GaussianRadius = 0.013249999880790711
controlDictDisplay.SetScaleArray = ['POINTS', 'p']
controlDictDisplay.ScaleTransferFunction = 'PiecewiseFunction'
controlDictDisplay.OpacityArray = ['POINTS', 'p']
controlDictDisplay.OpacityTransferFunction = 'PiecewiseFunction'
controlDictDisplay.DataAxesGrid = 'GridAxesRepresentation'
controlDictDisplay.PolarAxes = 'PolarAxesRepresentation'
controlDictDisplay.ScalarOpacityFunction = pPWF
controlDictDisplay.ScalarOpacityUnitDistance = 0.037559598395472175
controlDictDisplay.OpacityArrayName = ['POINTS', 'p']
controlDictDisplay.ExtractedBlockIndex = 3

controlDictDisplay.ScaleTransferFunction.Points = [0.0, 0.0, 0.5, 0.0, 100553.0859375, 1.0, 0.5, 0.0]

controlDictDisplay.OpacityTransferFunction.Points = [0.0, 0.0, 0.5, 0.0, 100553.0859375, 1.0, 0.5, 0.0]

renderView1.ResetCamera()

controlDictDisplay.SetScalarBarVisibility(renderView1, True)

renderView1.Update()

controlDict.MeshRegions = ['air/airToCopper']

renderView1.Update()

animationScene1.GoToLast()

clip1 = Clip(registrationName='Clip1', Input=controlDict)
clip1.ClipType = 'Plane'
clip1.HyperTreeGridClipper = 'Plane'
clip1.Scalars = ['POINTS', 'p']
clip1.Value = 100001.28515625

clip1.ClipType.Origin = [0.03999999910593033, 0.0, 2.8219074010849e-06]

clip1.HyperTreeGridClipper.Origin = [0.03999999910593033, 0.0, 2.8219074010849e-06]

clip1.ClipType.Normal = [0.0, 1.0, 0.0]

clip1Display = Show(clip1, renderView1, 'UnstructuredGridRepresentation')

clip1Display.Representation = 'Surface'
clip1Display.ColorArrayName = ['POINTS', 'p']
clip1Display.LookupTable = pLUT
clip1Display.SelectTCoordArray = 'None'
clip1Display.SelectNormalArray = 'None'
clip1Display.SelectTangentArray = 'None'
clip1Display.OSPRayScaleArray = 'p'
clip1Display.OSPRayScaleFunction = 'PiecewiseFunction'
clip1Display.SelectOrientationVectors = 'U'
clip1Display.ScaleFactor = 0.007999999821186066
clip1Display.SelectScaleArray = 'p'
clip1Display.GlyphType = 'Arrow'
clip1Display.GlyphTableIndexArray = 'p'
clip1Display.GaussianRadius = 0.0003999999910593033
clip1Display.SetScaleArray = ['POINTS', 'p']
clip1Display.ScaleTransferFunction = 'PiecewiseFunction'
clip1Display.OpacityArray = ['POINTS', 'p']
clip1Display.OpacityTransferFunction = 'PiecewiseFunction'
clip1Display.DataAxesGrid = 'GridAxesRepresentation'
clip1Display.PolarAxes = 'PolarAxesRepresentation'
clip1Display.ScalarOpacityFunction = pPWF
clip1Display.ScalarOpacityUnitDistance = 0.009054337616378028
clip1Display.OpacityArrayName = ['POINTS', 'p']
clip1Display.ExtractedBlockIndex = 5

clip1Display.ScaleTransferFunction.Points = [100000.1015625, 0.0, 0.5, 0.0, 100002.46875, 1.0, 0.5, 0.0]

clip1Display.OpacityTransferFunction.Points = [100000.1015625, 0.0, 0.5, 0.0, 100002.46875, 1.0, 0.5, 0.0]

Hide(controlDict, renderView1)

clip1Display.SetScalarBarVisibility(renderView1, True)

renderView1.Update()

slice1 = Slice(registrationName='Slice1', Input=clip1)
slice1.SliceType = 'Plane'
slice1.HyperTreeGridSlicer = 'Plane'
slice1.SliceOffsetValues = [0.0]

slice1.SliceType.Origin = [0.03999999910593033, -0.011049294844269753, 2.8219074010849e-06]

slice1.HyperTreeGridSlicer.Origin = [0.03999999910593033, -0.011049294844269753, 2.8219074010849e-06]

slice1Display = Show(slice1, renderView1, 'GeometryRepresentation')

slice1Display.Representation = 'Surface'
slice1Display.ColorArrayName = ['POINTS', 'p']
slice1Display.LookupTable = pLUT
slice1Display.SelectTCoordArray = 'None'
slice1Display.SelectNormalArray = 'None'
slice1Display.SelectTangentArray = 'None'
slice1Display.OSPRayScaleArray = 'p'
slice1Display.OSPRayScaleFunction = 'PiecewiseFunction'
slice1Display.SelectOrientationVectors = 'U'
slice1Display.ScaleFactor = 0.004419435560703277
slice1Display.SelectScaleArray = 'p'
slice1Display.GlyphType = 'Arrow'
slice1Display.GlyphTableIndexArray = 'p'
slice1Display.GaussianRadius = 0.0002209717780351639
slice1Display.SetScaleArray = ['POINTS', 'p']
slice1Display.ScaleTransferFunction = 'PiecewiseFunction'
slice1Display.OpacityArray = ['POINTS', 'p']
slice1Display.OpacityTransferFunction = 'PiecewiseFunction'
slice1Display.DataAxesGrid = 'GridAxesRepresentation'
slice1Display.PolarAxes = 'PolarAxesRepresentation'

slice1Display.ScaleTransferFunction.Points = [100000.1015625, 0.0, 0.5, 0.0, 100002.46875, 1.0, 0.5, 0.0]

slice1Display.OpacityTransferFunction.Points = [100000.1015625, 0.0, 0.5, 0.0, 100002.46875, 1.0, 0.5, 0.0]

Hide(clip1, renderView1)

slice1Display.SetScalarBarVisibility(renderView1, True)

renderView1.Update()

layout1 = GetLayout()

layout1.SplitHorizontal(0, 0.5)

SetActiveView(None)

spreadSheetView1 = CreateView('SpreadSheetView')
spreadSheetView1.ColumnToSort = ''
spreadSheetView1.BlockSize = 1024

slice1Display_1 = Show(slice1, spreadSheetView1, 'SpreadSheetRepresentation')

AssignViewToLayout(view=spreadSheetView1, layout=layout1, hint=2)

spreadSheetView1.HiddenColumnLabels = []

spreadSheetView1.HiddenColumnLabels = ['Block Name', 'Block Number', 'Point ID', 'Nu', 'Points', 'Points_Magnitude', 'T', 'U', 'U_Magnitude', 'p', 'p_rgh', 'rho']

spreadSheetView1.HiddenColumnLabels = ['Block Name', 'Block Number', 'Point ID', 'Points', 'Points_Magnitude', 'T', 'U', 'U_Magnitude', 'p', 'p_rgh', 'rho']

spreadSheetView1.HiddenColumnLabels = ['Block Name', 'Block Number', 'Point ID', 'Points_Magnitude', 'T', 'U', 'U_Magnitude', 'p', 'p_rgh', 'rho']

spreadSheetView1.ColumnToSort = 'Points_2'
spreadSheetView1.InvertOrder = 1


ExportView('./results/nuForcedConvectionCHT.csv', view=spreadSheetView1)

layout1.SetSize(1138, 784)


renderView1.CameraPosition = [0.03999999910593033, 0.0, 6.594829254903311]
renderView1.CameraFocalPoint = [0.03999999910593033, 0.0, 0.6620000004768372]
renderView1.CameraParallelScale = 1.53552920238696

# Graph

xLabel='theta'
yLabel='Nu'

for i in ["ForcedConvectionCHT"]:
    qwRaw = numpy.genfromtxt("./results/nu"+i+".csv",delimiter=',')[1:,:]


    theta=numpy.arccos((-qwRaw[:,3])/0.0221*0.999999999)*180/numpy.pi
    NuNum=qwRaw[:,0]
    NuExp = numpy.genfromtxt("./results/NuExpForced.dat")


    plt.plot(theta,NuNum, color='r', linewidth=.7, label="chtMultiRegionFoam")
plt.scatter(NuExp[:,0],NuExp[:,1], color='b', marker='s', s=20, label="Experimental")


plt.tick_params(axis='both', which='both', direction='in')
plt.tick_params(bottom='True', top='True', left='True', right='True', which='both')
plt.minorticks_on()

plt.axis([0,180, 0, 14])
ax = plt.gca()
ax.xaxis.set_major_locator(matplotlib.ticker.MultipleLocator(20))
ax.yaxis.set_major_locator(matplotlib.ticker.MultipleLocator(2))

plt.xlabel(xLabel)
plt.ylabel(yLabel)
plt.tight_layout()
plt.legend(frameon=False)
plt.savefig("./results/NuCHT.png", dpi = 600)
