# Regression model of frequency-dependent selection

Source codes and data of Sato et al. "Detecting frequency-dependent selection through the effects of genotype similarity on fitness components". A vignette-style instruction is available in Rmarkdown and its output HTML as `index.Rmd` and `index.html`, respectively (see also <https://yassato.github.io/RegressionFDS/> for viewing). A developer version is available at <https://github.com/yassato/RegressionFDS>.

## application

This directory includes source codes and/or input data for empirical analyses on *Arabidopsis halleri*, *Ischnura elegans*, and *Arabidopsis thaliana*, proceeding as follows.

### GLMM analysis of *Arabidopsis halleri*

-   Ahal_FieldSurvey.R\
    Poisson GLMM of the flower number in wild *Arabidopsis halleri* in a natural population. Data are available via Dryad repository (<https://doi.org/10.5061/dryad.53k2d>).

### GLMM analysis of *Ischnura elegans*

-   damselfly_cage_data.R\
    Poisson GLMM of the egg number in *Ischnura elegans* in semi-field cages. The original data are generated by Takahashi et al. (2014) Nature Communications 5:4468.

### Branch number GWAS in *Arabidopsis thaliana*

-   pheno_branchNum.csv\
    Accession list and phenotype data as an input file for "BranchNo2019GWAS.R", including the following columns.
    - IndivID: Plant ID
    - Name: Name of the accession
    - Source: CS number of ABRC seed stock
    - gwasID: GWAS genotype ID assigned to the accession
    - Block: Experimental block ID
    - position_X: cell-tray position along x-axis within a block
    - position_Y: cell-tray position along y-axis within a block
    - edge: Edge of the block (1) or not (0).
    - InitLeafLen: The length of largest leaf at the start of field experiment
    - Bolting: Presence (1) or absence (0) of inflorescence 2 wk after the start of experiment
    - BranchNo: No. of reproductive branches. Dead plants are considered zero numbers.

-   subsetSNP.py\
    Python script to extract genotype data from .hdf available at AraGWAS Catalog (<https://aragwas.1001genomes.org>).

-   reshapeSNP.R\
    R script to prepare genotype data for for "BranchNo2019GWAS.R" after subsetSNP.py.

-   BranchNo2019GWAS.R\
    Field GWAS of the branch number using 199 accessions of *A. thaliana*.

-   BranchNo2019GWASfigure.R\
    Manhattan and QQ plots for the output from "BranchNo2019GWAS.R".


## simulation

This directory includes source codes for simulations, numerical examples, and their figure presentation, proceeding as follows.

### Ising model simulation

-   IsingGenoWeighted.R\
    R script for the forward Ising simulation when transition probabilities follow Mendelian inheritance.

### Fitness function

-   AsymFDSfitnessFunctions.R\
    Numerical analysis and figure presentation for fitness functions in response to allele frequency.

### GWAS simulation

-   SLiM codes (xxxx.slim) for forward genetic simulations of
    negative frequency-dependent selection (NFDS); positive frequency-dependent selection (PFDS); overdominance (OD); and spatiotemporally varying selection (STVS).
-   outputSLiM_and_GWAS.R
    GWAS simulation and power analysis using the SLiM output.
-   outputFigures.R\
    Figure presentations for the GWAS simulation.
-   /output\
    A folder to save SLiM and R outputs, including the following input data for the vignette (index.Rmd)
    - toy1.rds: Single-locus example data with split subpopulations
    - toy2.rds: Single-locus example data with continuous space
    - toy3.rds: GWAS example with with split subpopulations
    - toy4.rds: GWAS example with with continuous space

### Vignette

-   toydata.R\
    R script to create input toy data for index.Rmd in the top directory
