package org.waterproofingdata.wpdauth.security;

import org.waterproofingdata.wpdauth.security.JwtTokenFilterConfigurer;
import org.waterproofingdata.wpdauth.security.JwtTokenProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled = true)
public class WebSecurityConfig extends WebSecurityConfigurerAdapter {
	  @Autowired
	  private JwtTokenProvider jwtTokenProvider;

	  @Override
	  protected void configure(HttpSecurity http) throws Exception {

	    // Disable CSRF (cross site request forgery)
	    http.csrf().disable();

	    // No session will be created or used by spring security
	    http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);

	    // Entry points
	    http.authorizeRequests()//
	        .antMatchers("/users/login").permitAll()//
	        .antMatchers("/users/signup").permitAll()//
	        .antMatchers("/users/existsByUsername").permitAll()//
			.antMatchers("/users/existsByNickname").permitAll()//
			.antMatchers("/forgotpasswords/findallforgotpasswordquestions").permitAll()//
			.antMatchers("/forgotpasswords/loginbyusernameandanswers").permitAll()//
	        .antMatchers("/h2-console/**/**").permitAll()
	        // Disallow everything else..
			.anyRequest().authenticated();
			
	    // If a user try to access a resource without having enough permissions
	    http.exceptionHandling().accessDeniedPage("/login");

	    // Apply JWT
	    http.apply(new JwtTokenFilterConfigurer(jwtTokenProvider));

	    // Optional, if you want to test the API from a browser
	    // http.httpBasic();
	  }

	  @Override
	  public void configure(WebSecurity web) throws Exception {
	    // Allow swagger to be accessed without authentication
	    web.ignoring().antMatchers("/v2/api-docs")//
	        .antMatchers("/swagger-resources/**")//
	        .antMatchers("/swagger-ui.html")//
	        .antMatchers("/configuration/**")//
	        .antMatchers("/webjars/**")//
	        .antMatchers("/public")
	        
	        // Un-secure H2 Database (for testing purposes, H2 console shouldn't be unprotected in production)
	        .and()
	        .ignoring()
	        .antMatchers("/h2-console/**/**");;
	  }

	  @Bean
	  public PasswordEncoder passwordEncoder() {
	    return new BCryptPasswordEncoder(12);
	  }

	  @Override
	  @Bean
	  public AuthenticationManager authenticationManagerBean() throws Exception {
	    return super.authenticationManagerBean();
	  }
}
