```
# Title of Dataset
---

Compiled trace element compositions for magmatic zircons from I-type granitoids, S-type granitoids and TTGs, and detrital zircons


## Description of the data and file structure

The dataset consists of four sheets. Sheet is compiled zircon trace element compositions for I- and S-type granitoids, and Archean TTGs. Sheet 2 is compiled zircon trace element compositions for detrital zircons from the Gangdese magmatic belt, southern Tibet. Sheet 3 is compiled zircon trace element compositions for detrital zircons from the Western Dharwar Craton, southern India. Sheet 4 is compiled zircon trace element compositions for detrital zircons from the Jack Hills, Australia.
Sheet 5 is references of the above data.

Some elements of the compiled zircon, which are below detection of limit, are indicated by b.d.l.


## Sharing/Access information

As a condition of using these data, I kindly ask you use the following citation:

Zhong S., et al. I-type and S-type granites in the Earth’s earliest continental crust, Nature Comms Earth and Environ., (2023).


Data was derived from the following sources:
  * 
References for Sheet 1:																							
Bai, B., Liu, X., Zhou, H. (2020). Genesis and tectonic setting of granite in the central region of the Beishan orogenic belt (Gansu section, China). Acta Petrologica Sinica, 36(6): 1731-1754.																							
Ballard, J.R., Palin, M.J., Campbell, I.H. (2002). Relative oxidation states of magmas inferred from Ce (IV)/Ce (III) in zircon: application to porphyry copper deposits of northern Chile. Contributions to Mineralogy and Petrology 144, 347-364.																							
Burnham, A. D., & Berry, A. J. (2017). Formation of Hadean granites by melting of igneous crust. Nature Geoscience, 10(6), 457-461.																							
Cao, H. W., Li, G. M., Zhang, R. Q., Zhang, Y. H., Zhang, L. K., Dai, Z. W., ... & Xia, X. B. (2021). Genesis of the Cuonadong tin polymetallic deposit in the Tethyan Himalaya: Evidence from geology, geochronology, fluid inclusions and multiple isotopes. Gondwana Research, 92, 72-101.																							
Cao, H. W., Zhang, Y. H., Pei, Q. M., Zhang, R. Q., Tang, L., Lin, B., & Cai, G. J. (2017). U–Pb dating of zircon and cassiterite from the Early Cretaceous Jiaojiguan iron-tin polymetallic deposit, implications for magmatism and metallogeny of the Tengchong area, western Yunnan, China. International Geology Review, 59(2), 234-258.																							
Cao, H. W., Zhang, Y. H., Santosh, M., Li, G. M., Hollis, S. P., Zhang, L. K., ... & Duan, Z. M. (2019). Petrogenesis and metallogenic implications of Cretaceous magmatism in Central Lhasa, Tibetan Plateau: A case study from the Lunggar Fe skarn deposit and perspective review. Geological Journal, 54(4), 2323-2346.																							
Cao, H. W., Zhang, Y. H., Santosh, M., Zhang, S. T., Tang, L., & Pei, Q. M. (2018). Mineralogy, zircon U–P b–H f isotopes, and whole‐rock geochemistry of L ate C retaceous–E ocene granites from the T engchong terrane, western Y unnan, C hina: R ecord of the closure of the N eo‐T ethyan O cean. Geological Journal, 53(4), 1423-1441.																							
Cao, M., Qin, K., Li, G., Evans, N. J., McInnes, B. I., Lu, W., & Deng, G. (2017). Petrogenesis of the Baishan granite stock, Eastern Tianshan, NW China: Geodynamic setting and implications for potential mineralization. Lithos, 292, 278-293.																							
Chelle-Michou, C., Chiaradia, M., Béguelin, P., & Ulianov, A. (2015). Petrological evolution of the magmatic suite associated with the Coroccohuayco Cu (–Au–Fe) Porphyry–skarn deposit, Peru. Journal of Petrology, 56(9), 1829-1862.																							
Chelle-Michou, C., Chiaradia, M., Ovtcharova, M., Ulianov, A., & Wotzlaw, J. F. (2014). Zircon petrochronology reveals the temporal link between porphyry systems and the magmatic evolution of their hidden plutonic roots (the Eocene Coroccohuayco deposit, Peru). Lithos, 198, 129-140.																							
Chen, L., Wang, Z., Yan, Z., Gong, J., & Ma, S. (2018). Zircon and cassiterite U-Pb ages, petrogeochemistry and metallogenesis of Sn deposits in the Sibao area, northern Guangxi: constraints on the neoproterozoic granitic magmatism and related Sn mineralization in the western Jiangnan Orogen, South China. Mineralogy and Petrology, 112(4), 437-463.																							
Chen, S., Chen, H., Zhu, K., & Tao, Y. (2021). Petrogenesis of the Middle–Late Triassic S-and I-type granitoids in the eastern Pamir and implications for the Tanymas–Jinshajiang Paleo-Tethys Ocean. International Journal of Earth Sciences, 110(4), 1213-1232.																							
Chen, Y., Cui, Y., Song, S., Wu, K., Sun, W., & Xiao, T. (2021). Petrogenesis and tectonic implications of cambrian Nb-enriched I-and aluminous A-type granites in the North Qilian suture zone. International Geology Review, 63(9), 1090-1109.																							
Chen, Y., Pei, X., Li, Z., Li, R., Liu, C., & Wang, M. (2017). Magmatic events recorded in granitic gneisses from the Hatu area, eastern East Kunlun Orogen: Response to the assembly of Rodinia. Geological Journal, 52, 403-418.																							
Chen, Y., Zhang, Z., Palin, R. M., Tian, Z., Xiang, H., Dong, X., ... & Li, Y. (2021). Late Triassic orogenic assembly of the Tibetan Plateau: constraints from magmatism and metamorphism in the east Lhasa terrane. Journal of Petrology.																							
Chen, Z. H., & Xing, G. F. (2013). Petrogenesis of a Palaeoproterozoic S-type granite, central Wuyishan terrane, SE China: implications for early crustal evolution of the Cathaysia Block. International Geology Review, 55(12), 1445-1461.																							
Chicharro Álvarez, E., Villaseca González, C., Valverde-Vaquero, P., & López García, J. Á. (2014). Zircon U-Pb and Hf isotopic constraints on the genesis of a post-kinematic S-type Variscan tin granite: the Logrosán cupola (Central Iberian Zone). Journal of Iberian Geology, 40(3), 451-470.																							
Cui, Z., Xia, X. P., Huang, X. L., Xu, J., Yang, Q., Zhang, W. F., ... & Wang, X. (2022). Meso-to Neoarchean geodynamic transition of the North China Craton indicated by H2O-in-zircon for TTG suite. Precambrian Research, 371, 106574.																							
Dang, Y., Chen, M., Fu, B., Mao, J., Fanning, C. M., & Li, Z. (2018). Petrogenesis of the Yupo W-bearing and Dali Mo-bearing granitoids in the Dayaoshan area, South China: Constraints of geochronology and geochemistry. Ore Geology Reviews, 92, 643-655.																							
Dang, Y., Chen, M., Mao, J., & Fu, B. (2020). Weakly fractionated I-type granitoids and their relationship to tungsten mineralization: A case study from the early Paleozoic Shangmushui deposit, Dayaoshan area, South China. Ore Geology Reviews, 117, 103281.																							
Dong, Y. C., Wang, M., Fan, J. J., Xie, C. M., Yu, Y. P., & Hao, Y. J. (2020). Late Jurassic I-type rhyolites from the Duobuza region, north-central Tibet: evidence for the occurrence of juvenile lower crust and crustal growth in the Southern Qiangtang Terrane. International Geology Review, 62(11), 1450-1466.																							
Dou, J., Siebel, W., He, J., Chen, F., 2019. Different melting conditions and petrogenesis of peraluminous granites in western Qinling, China, and tectonic implications. Lithos 336, 97-111.																							
Du, B., Wang, C., Yang, L., Shi, K., Chen, Q., & Zhu, J. (2020). Petrogenesis of the Cenozoic Lianhuashan pluton (SW China): Constrained by zircon U–Pb geochronology, Lu–Hf isotope, and geochemistry. Geological Journal, 55(5), 3377-3400.																							
Duan, P., Liu, C., Mo, X., Deng, J., Qin, J., Zhang, Y., & Tian, S. (2018). Discriminating characters of ore-forming intrusions in the super-large Chalukou porphyry Mo deposit, NE China. Geoscience Frontiers, 9(5), 1417-1431.																							
Duan, X.X., Chen, B., Sun, K.K., Wang, Z.Q., Yan, X., Zhang, Z., 2019. Accessory mineral chemistry as a monitor of petrogenetic and metallogenetic process: A comparative study of zircon and apatite from Wushan Cu- and Zhuxiling W(Mo)-mineralization-related granitoids. Ore Geology Reviews 111, 102940.																							
Emo, R. B. (2018). Archean crustal evolution constrained by strontium isotopes in apatite and uranium-lead geochronology and trace element geochemistry of zircon (Doctoral dissertation, University of British Columbia).																							
Fan, W., Jiang, N., Zhai, M., & Hu, J. (2020). Zircon constraints on granite derivation in the northern North China Craton. Lithos, 356, 105370.																							
Feng, Y., Lan, T., Pan, L., Liu, T., & Dong, S. (2019). Metallogenic controls on the granite-related W–Sn deposits in the Hunan–Jiangxi region, China: evidence from zircon trace element geochemistry. Acta Geochimica, 38(4), 530-540.																							
Fu, L., Wei, J., Kusky, T.M., Chen, H., Tan, J., Li, Y., Shi, W., Chen, C., Zhao, S., 2012. The Cretaceous Duimiangou adakite-like intrusion from the Chifeng region, northern North China Craton: crustal contamination of basaltic magma in an intracontinental extensional environment. Lithos 134, 273-288.																							
Gao, P., Zheng, Y. F., Chen, Y. X., Zhao, Z. F., & Xia, X. P. (2018). Relict zircon U-Pb age and O isotope evidence for reworking of Neoproterozoic crustal rocks in the origin of Triassic S-type granites in South China. Lithos, 300, 261-277.																							
Gao, P., Zheng, Y.-F., Zhao, Z.-F., 2016. Distinction between S-type and peraluminous I-type granites: Zircon versus whole-rock geochemistry. Lithos 258, 77-91.																							
Guan, Q., Zhu, D.-C., Zhao, Z.-D., Dong, G.-C., Zhang, L.-L., Li, X.-W., Liu, M., Mo, X.-X., Liu, Y.-S., Yuan, H.-L., 2012. Crustal thickening prior to 38 Ma in southern Tibet: evidence from lower crust-derived adakitic magmatism in the Gangdese Batholith. Gondwana Research 21, 88-99.																							
Guitreau, M., Gannoun, A., Deng, Z., Chaussidon, M., Moynier, F., Barbarin, B., & Marin-Carbonne, J. (2021). Stable isotope geochemistry of silicon in granitoid zircon. Geochimica et Cosmochimica Acta.																							
Guo, J., Wu, K., Seltmann, R., Zhang, R., Ling, M., Li, C., & Sun, W. (2021). Unraveling the link between mantle upwelling and formation of Sn-bearing granitic rocks in the world-class Dachang tin district, South China. GSA Bulletin.																							
Harlaux, M., Kouzmanov, K., Gialli, S., Clark, A. H., Laurent, O., Corthay, G., ... & Fontboté, L. (2021). The upper Oligocene San Rafael intrusive complex (Eastern Cordillera, southeast Peru), host of the largest-known high-grade tin deposit. Lithos, 400, 106409.																							
He, J., Wang, B., Wang, L., Wang, Q., & Yan, G. (2019). Geochemistry and geochronology of the Late Cretaceous Tongchanggou Mo–Cu deposit, Yidun Terrane, SE Tibet; implications for post-collisional metallogenesis. Journal of Asian Earth Sciences, 172, 308-327.																							
Hu, X.L., Ding, Z.J., He, M.C., Yao, S.Z., Zhu, B.P., Shen, J., and Chen, B., 2014a, A porphyry-skarn metallogenic system in the Lesser Xing’an Range, NE China: implications from U-Pb and Re-Os geochronology and Sr-Nd-Hf isotopes of the Luming Mo and Xulaojiugou Pb-Zn deposits: Journal of Asian Earth Sciences, v. 90, p. 88–100.																							
Hu, X.L., Ding, Z.J., He, M.C., Yao, S.Z., Zhu, B.P., Shen, J., and Chen, B., 2014b, Two epochs of magmatism and metallogeny in the Cuihongshan Fe-polymetallic deposit, Heilongjiang Province, NE China: Constrains from U-Pb and Re-Os geochronology and Lu-Hf isotopes: Journal of Geochemical Exploration, v. 143, p. 116–126.																							
Hu, Y. B., Liu, J. Q., Ling, M. X., Liu, Y., Ding, X., Liu, D. Y., & Sun, W. D. (2017). Constraints on the origin of adakites and porphyry Cu-Mo mineralization in Chongjiang, Southern Gangdese, the Tibetan Plateau. Lithos, 292, 424-436.																							
LaFlamme, C., McFarlane, C. R., & Corrigan, D. (2014). U–Pb, Lu–Hf and REE in zircon from 3.2 to 2.6 Ga Archean gneisses of the Repulse Bay block, Melville Peninsula, Nunavut. Precambrian Research, 252, 223-239.																							
Lan, T.-G., Hu, R.-Z., Chen, Y.-H., Wang, H., Tang, Y.-W., Liu, L., 2019. Generation of high-Mg diorites and associated iron mineralization within an intracontinental setting: Insights from ore-barren and ore-bearing intrusions in the eastern North China Craton. Gondwana Research 72, 97-119.																							
Laurent, O., Moyen, J. F., Wotzlaw, J. F., Björnsen, J., & Bachmann, O. (2022). Early Earth zircons formed in residual granitic melts produced by tonalite differentiation. Geology, 50 (4), 437–441.																							
Li JX, Qin KZ, Li GM, Cao MJ, Xiao B, Chen L, Zhao JX, Evans NJ, McInnes BIA (2012) Petrogenesis and thermal history of the Yulong porphyry copper deposit, Eastern Tibet: insights from U-Pb and U-Th/He dating, and zircon Hf isotope and trace element analysis. Mineral Petrol 105:201–221																							
Li, C. Y., Zhang, H., Wang, F. Y., Liu, J. Q., Sun, Y. L., Hao, X. L., ... & Sun, W. (2012). The formation of the Dabaoshan porphyry molybdenum deposit induced by slab rollback. Lithos, 150, 101-110.																							
Li, H., Cao, J., Algeo, T. J., Jiang, W., Liu, B., & Wu, Q. (2019). Zircons reveal multi-stage genesis of the Xiangdong (Dengfuxian) tungsten deposit, South China. Ore Geology Reviews, 111, 102979.																							
Li, H., Ling, M.-x., Ding, X., Zhang, H., Li, C.-y., Liu, D.-y., Sun, W.-d., 2014. The geochemical characteristics of Haiyang A-type granite complex in Shandong, eastern China. Lithos 200, 142-156.																							
LI, H., ZHAO, Z., CHEN, Z., GUO, N., GAN, J., LI, X., & YIN, Z. (2021). Genetic relationship between the two-period magmatism and W mineralization in the Dahutang ore-field, Jiangxi Province: Evidence from zircon geochemistry. Acta Petrologica Sinica, 37(5), 1508-1530.																							
Li, J., Wang, K. Y., Fu, L. J., Zhang, M., Liu, Q. Z., Tang, W. H., & Wang, C. H. (2020). Adakitic rocks and A‐type felsic dykes in the Changlingzi area, NE China: Constraints on multistage tectonism in the southern Great Xing'an Range. Geological Journal, 55(7), 5451-5478.																							
Li, L., Shu, Q., Xing, K., Zhao, Z., & Niu, X. (2021). Geochronology, geochemistry and Sr-Nd-Hf isotopes of the Heihuashan granite porphyry, NE China, and implications for Cu-Mo mineralization. Ore Geology Reviews, 104435.																							
Li, N., Chen, Y. J., Pirajno, F., Gong, H. J., Mao, S. D., & Ni, Z. Y. (2012). LA-ICP-MS zircon U–Pb dating, trace element and Hf isotope geochemistry of the Heyu granite batholith, eastern Qinling, central China: implications for Mesozoic tectono-magmatic evolution. Lithos, 142, 34-47.																							
Li, N., Yang, F., & Zhang, Z. (2020). Petrogenesis of Early Devonian granodiorite in the Xiaobaishitou W–(Mo) ore district of East Tianshan, Northwest China, and tectonic implications: U–Pb geochronological, geochemical, and Sr–Nd isotopic evidence. Geological Journal, 55(6), 4302-4323.																							
Li, N., Yang, F., Zhang, Z., & Yang, C. (2019). Geochemistry and chronology of the biotite granite in the Xiaobaishitou W-(Mo) deposit, eastern Tianshan, China: Petrogenesis and tectonic implications. Ore Geology Reviews, 107, 999-1019.																							
Li, X. H., Fan, H. R., Santosh, M., Yang, K. F., Peng, H. W., Hollings, P., & Hu, F. F. (2019). Mesozoic felsic dikes in the Jiaobei Terrane, southeastern North China Craton: Constraints from zircon geochronology and geochemistry, and implications for gold metallogeny. Journal of Geochemical Exploration, 201, 40-55.																							
Li, Z., Pei, X., Li, R., Pei, L., Liu, C., Chen, Y., ... & Xu, T. (2017). Early Ordovician island‐arc‐type Manite granodiorite pluton from the Buqingshan Tectonic Mélange Belt in the southern margin of the East Kunlun Orogen: constraints on subduction of the Proto‐Tethyan Ocean. Geological Journal, 52(3), 510-528.																							
Liu, B., Wu, J. H., Li, H., Mathur, R., Wu, Q. H., Zheng, H., & Jiang, J. B. (2021). Late Paleozoic tectonic evolution of the Kangguer Shear Zone and Yamansu Arc Belt, Eastern Tianshan (NW China): constraints from structure, petrogenesis and geochronology of granitoids. Lithos, 380, 105821.																							
Liu, C., Zhao, G., Liu, F., & Cai, J. (2019). A Palaeoarchean–Mesoarchean micro-continent entrained in the Jiao-Liao-Ji Belt at the southeastern North China Craton: evidence from the zircon record in the Bengbu area. Geological Magazine, 156(9), 1565-1586.																							
Liu, J., Li, W., Zhu, X., Wang, B., Jiang, J., & Liu, H. (2020). Magmatic evolution and related W–Mo mineralization in the Larong deposit, eastern Tibet: Evidence from zircon U–Pb ages, geochemistry and Sr–Nd–Hf isotopes. Ore Geology Reviews, 120, 103411.																							
Liu, K., Lu, G., Wang, Z., Huang, S., Xue, E., & Wang, W. (2019). The Paleoproterozoic bimodal magmatism in the SW Yangtze block: Implications for initial breakup of the Columbia supercontinent. Lithos, 332, 23-38.																							
Liu, L., Hu, R. Z., Zhong, H., Yang, J. H., Kang, L. F., Zhang, X. C., ... & Tang, Y. W. (2020). Petrogenesis of multistage S-type granites from the Malay Peninsula in the Southeast Asian tin belt and their relationship to Tethyan evolution. Gondwana Research, 84, 20-37.																							
Liu, W. Z., Sun, F. Y., Huang, W. P., Wang, L. L., Su, B., & Huan, F. M. (2014). Zircon U-Pb ages and petrochemical characteristics of Bangzishan granite in Fu'anpu of Jilin and their geological significance. Global Geology, 33(2), 289-298.																							
Lu YJ, Loucks RR, Fiorentini ML, McCuaig TC, Evans NJ, Yang ZM, Hou ZQ, Kirkland CL, Parra-Avila LA, Kobussen A (2016) Zircon compositions as a pathfinder for porphyry Cu ± Mo ± Au mineral deposits. Soc Econ Geol Spec Publ 19:329–347																							
Lu, W. J., Chen, H. Y., Zhang, L., Han, J. S., Xiao, B., Li, D. F., ... & Jiang, H. J. (2017). Age and geochemistry of the intrusive rocks from the Shaquanzi-Hongyuan Pb–Zn mineral district: Implications for the Late Carboniferous tectonic setting and Pb–Zn mineralization in the Eastern Tianshan, NW China. Lithos, 294, 97-111.																							
"Lu, Y, Smithies, RH, Wingate, MTD, Evans, NJ, McCuaig, TC, Champion, DC and Outhwaite, M 2019, Zircon fingerprinting of
magmatic–hydrothermal systems in the Archean Yilgarn Craton: Geological Survey of Western Australia, Report 197, 22p."																							
Mao, A., Sun, D., Gou, J., & Zheng, H. (2020). Genesis of Early–Middle Jurassic Intrusive Rocks in the Erguna Block (NE China) in Response to the Late-Stage Southward Subduction of the Mongol–Okhotsk Oceanic Plate: Constraints from Geochemistry and Zircon U–Pb Geochronology and Lu–Hf Isotopes. Minerals, 10(4), 372.																							
Mao, S., Chen, Y. J., Zhou, Z., Lu, Y., Guo, J., Qin, Y., & Yu, J. (2014). Zircon geochronology and Hf isotope geochemistry of the granitoids in the Yangshan gold field, western Qinling, China: implications for petrogenesis, ore genesis and tectonic setting. Geological Journal, 49(4-5), 359-382.																							
Meng, X., Richards, J. P., Kontak, D. J., Simon, A. C., Kleinsasser, J. M., Marsh, J. H., ... & Jugo, P. J. (2021). Variable Modes of Formation for Tonalite–Trondhjemite–Granodiorite–Diorite (TTG)-related Porphyry-type Cu±Au Deposits in the Neoarchean Southern Abitibi Subprovince (Canada): Evidence from Petrochronology and Oxybarometry. Journal of Petrology, 62(11), egab079.																							
Mitra, A., Dey, S., Zong, K., Liu, Y., & Mitra, A. (2019). Building the core of a Paleoarchean continent: Evidence from granitoids of Singhbhum Craton, eastern India. Precambrian Research, 335, 105436.																							
Muñoz M, Charrier R, Fanning CM, Maksaev V, Deckart K (2012) Zircon trace element and O-Hf isotope analyses of mineralized intrusions from El Teniente ore deposit, Chilean Andes: Constraints on the source and magmatic evolution of porphyry Cu-Mo related magmas. J Petrol 53:1091–1122																							
Omidianfar, S., Monsef, I., Rahgoshay, M., Zheng, J., & Cousens, B. (2020). The middle Eocene high-K magmatism in Eastern Iran Magmatic Belt: constraints from U-Pb zircon geochronology and Sr-Nd isotopic ratios. International Geology Review, 62(13-14), 1751-1768.																							
Orejana, D., Villaseca, C., Valverde-Vaquero, P., Belousova, E. A., & Armstrong, R. A. (2012). U–Pb geochronology and zircon composition of late Variscan S-and I-type granitoids from the Spanish Central System batholith. International Journal of Earth Sciences, 101(7), 1789-1815.																							
"Ou Q, Lai J-Q, Carvalho BB, Zi F, Jiang Z-Q, Wang K, and Liu Y-Z. Early Silurian granitic rocks and associated enclaves as evidence of rapid cooling in a cognate magma system: the case of the Xuehuading–Panshanchong pluton, South China Block.Geological magazine https://doi.org/10.1017/
S0016756820001144"																							
Qi, H., Lu, S., Yang, X., Zhou, Y., Zhao, L., Deng, J., & Li, J. (2019). Formation of the Granodiorite-Hosting Magushan Cu–Mo Polymetallic Deposit in Southern Anhui, Eastern China: Evidences from Geochronology and Geochemistry. Minerals, 9(8), 475.																							
Qiu, J. T., & Qiu, L. (2016). Geochronology and magma oxygen fugacity of Ehu S-type granitic pluton in Zhe-Gan-Wan region, SE China. Geochemistry, 76(3), 441-448.																							
Qiu, Z., Li, S., Yan, Q., Wang, H., Wei, X., Li, P., ... & Bu, A. (2017). Late Jurassic Sn metallogeny in eastern Guangdong, SE China coast: Evidence from geochronology, geochemistry and Sr–Nd–Hf–S isotopes of the Dadaoshan Sn deposit. Ore Geology Reviews, 83, 63-83.																							
Qu, P., Li, N. B., Niu, H. C., Yang, W. B., Shan, Q., & Zhang, Z. Y. (2019). Zircon and apatite as tools to monitor the evolution of fractionated I-type granites from the central Great Xing’an Range, NE China. Lithos, 348, 105207.																							
Santosh, M., Li, S.-S., 2018. Anorthosites from an Archean continental arc in the Dharwar Craton, southern India: implications for terrane assembly and cratonization. Precambrian Research 308, 126-147.																							
Sepahi, A. A., Vahidpour, H., Lentz, D. R., McFarlane, C. R., Maanijou, M., Salami, S., ... & Mohammadi, R. (2020). Rare sapphire-bearing syenitoid pegmatites and associated granitoids of the Hamedan region, Sanandaj–Sirjan zone, Iran: analysis of petrology, lithogeochemistry and zircon geochronology/trace element geochemistry. Geological Magazine, 157(9), 1499-1525.																							
Shaji, E., Santosh, M., He, X. F., Fan, H. R., Dev, S. D., Yang, K. F., ... & Pradeepkumar, A. P. (2014). Convergent margin processes during Archean–Proterozoic transition in southern India: Geochemistry and zircon U–Pb geochronology of gold-bearing amphibolites, associated metagabbros, and TTG gneisses from Nilambur. Precambrian Research, 250, 68-96.																							
Shen P, Hattori K, Pan H, Jackson S, Seitmuratova E (2015) Oxidation condition and metal fertility of granitic magmas: zircon trace-element data from porphyry Cu deposits in the Central Asian Orogenic Belt. Econ Geol 110:1861–1878																							
Shu, Q., & Chiaradia, M. (2021). Mesozoic Mo mineralization in northeastern China did not require regional-scale pre-enrichment. Economic Geology, 116(5), 1227-1237.																							
Shu, Q., Chang, Z., Lai, Y., Hu, X., Wu, H., Zhang, Y., ... & Zhang, C. (2019). Zircon trace elements and magma fertility: insights from porphyry (-skarn) Mo deposits in NE China. Mineralium Deposita, 54(5), 645-656.																							
Shu, Q., Lai, Y., Zhou Y., Xu, J., and Wu, H., 2015, Zircon U-Pb geochronology and Sr-Nd-Pb-Hf isotopic constraints on the timing and origin of Mesozoic granitoids hosting the Mo deposits in northern Xilamulun district, NE China: Lithos. V. 238, p. 64–75.																							
Shuai, X., Li, S. M., Zhu, D. C., Wang, Q., Zhang, L. L., & Zhao, Z. (2021). Tetrad effect of rare earth elements caused by fractional crystallization in high-silica granites: An example from central Tibet. Lithos, 384, 105968.																							
Smith, W. D., Darling, J. R., Bullen, D. S., Lasalle, S., Pereira, I., Moreira, H., ... & Tapster, S. (2019). Zircon perspectives on the age and origin of evolved S-type granites from the Cornubian Batholith, Southwest England. Lithos, 336, 14-26.																							
Song, S. W., Zhu, D. C., Wang, Q., Cawood, P. A., Zhan, Q. Y., Li, S. M., ... & Zhao, Z. D. (2021). Generation of syn-collisional S-type granites in collision zones: An example from the Late Triassic Tanggula Batholith in northern Tibet. Gondwana Research.																							
Sun, K., Chen, B., Deng, J., & Ma, X. (2018). Source of copper in the giant Shimensi W-Cu-Mo polymetallic deposit, South China: Constraints from chalcopyrite geochemistry and oxygen fugacity of ore-related granites. Ore Geology Reviews, 101, 919-935.																							
Vezinet, A., Pearson, D. G., Thomassot, E., Stern, R. A., Sarkar, C., Luo, Y., & Fisher, C. M. (2018). Hydrothermally-altered mafic crust as source for early Earth TTG: Pb/Hf/O isotope and trace element evidence in zircon from TTG of the Eoarchean Saglek Block, N. Labrador. Earth and Planetary Science Letters, 503, 95-107.																							
Volante, S., Collins, W. J., Blereau, E., Pourteau, A., Spencer, C., Evans, N. J., ... & Li, J. (2020). Reassessing zircon-monazite thermometry with thermodynamic modelling: insights from the Georgetown igneous complex, NE Australia. Contributions to Mineralogy and Petrology, 175(12), 1-22.																							
Wan, J., Wang, A., Pan, J., Liu, C., Zhao, Y., Zhou, Z., & Luo, X. (2021). Episodic crustal growth and reworking at the southeastern margin of the North China Craton: evidence from zircon U–Pb and Lu–Hf isotopes of Archean tonalite–trondhjemite–granodiorite gneisses in the Bengbu-Wuhe area. Acta Geochimica, 40(3), 366-389.																							
Wang S, Zhou T, Yuan F, Fan Y, Cooke DR, Zhang L, Fu B, White NC (2016) Geochemical characteristics of the Shujiadian Cu deposit related intrusion in Tongling: Petrogenesis and implications for the formation of porphyry Cu systems in the Middle-Lower Yangtze River Valley metallogenic belt, eastern China. Lithos 252:185–199																							
Wang, F., Liu, S.-A., Li, S., He, Y., 2013. Contrasting zircon Hf–O isotopes and trace elements between ore-bearing and ore-barren adakitic rocks in central-eastern China: implications for genetic relation to Cu–Au mineralization. Lithos 156, 97-111.																							
Wang, M. X., Santosh, M., Yang, C. X., Jang, Y., Yu, B., & Gao, P. (2022). Trondhjemites from the Qianxi Complex, North China Craton: Implications for Neoarchean crustal growth. Geological Journal.																							
Wang, Q., Zhu, D.-C., Zhao, Z.-D., Guan, Q., Zhang, X.-Q., Sui, Q.-L., Hu, Z.-C., Mo, X.-X., 2012. Magmatic zircons from I-, S-and A-type granitoids in Tibet: Trace element characteristics and their application to detrital zircon provenance study. Journal of Asian Earth Sciences 53, 59-66.																							
Wang, T., Li, G., Wang, Q., Santosh, M., Zhang, Q., & Deng, J. (2019). Petrogenesis and metallogenic implications of Late Cretaceous I-and S-type granites in Dachang–Kunlunguan ore belt, southwestern South China Block. Ore Geology Reviews, 113, 103079.																							
Wang, Z., Zhao, Z., Li, X., Asimow, P. D., Liu, D., Mo, X., ... & Sheikh, L. (2021). Late Cretaceous adakitic and A-type granitoids in Chanang, southern Tibet: Implications for Neo-Tethyan slab rollback. Gondwana Research, 96, 89-104.																							
Wei, W., Lai, C., Yan, B., Zhu, X., Song, S., & Liu, L. (2018). Petrogenesis and Metallogenic Implications of Neoproterozoic Granodiorite in the Super-Large Shimensi Tungsten-Copper Deposit in Northern Jiangxi, South China. Minerals, 8(10), 429.																							
Wei, W.F., Shen, N.P., Yan, B., Lai, C., Yang, J.H., Gao, W., Liang, F., 2018. Petrogenesis of ore-forming granites with implications for W-mineralization in the super-large Shimensi tungsten-dominated polymetallic deposit in northern Jiangxi Province, South China. Ore Geology Reviews 95, 1123–1139.																							
Wu, H., Zhang, L., Pirajno, F., Shu, Q., Zhang, M., Zhu, M., and Xiang, P., 2016a, The Mesozoic Caosiyao giant porphyry Mo deposit in Inner Mongolia, North China and Paleo-Pacific subduction-related magmatism in the northern North China Craton: Journal of Asian Earth Sciences, v.127, p. 281–299.																							
Wu, H.Y., Zhang, L.C., Gao, J., Zhang, M., Zhu, M.T., and Xiang, P., 2018, U–Pb geochronology, isotope systematics, and geochemical characteristics of the Triassic Dasuji porphyry Mo deposit, Inner Mongolia, North China: Implications for tectonic evolution and constraints on the origin of ore-related granitoids: Journal of Asian Earth Sciences, v. 165, p. 132–144.																							
Wu, K., Ling, M.X., Hu, Y.B., Guo, J., Jiang, X.Y., Sun, S.J., Liang, H.Y., Liu, X., Sun, W., 2018. Melt‐fluxed melting of the heterogeneously mixed lower arc crust: A case study from the qinling orogenic belt, Central China. Geochemistry, Geophysics, Geosystems 19, 1767-1788.																							
Wu, P., Wu, Y. B., Zhou, G. Y., Zhang, W. X., & He, Y. (2021). Geochronology, geochemistry, and isotope compositions of “Grenvillian” S-type granites in the North Qinling unit, central China: Petrogenesis and tectonic significance. Precambrian Research, 360, 106247.																							
Wu, Q., Cao, J., Kong, H., Shao, Y., Li, H., Xi, X., Deng, X., 2016. Petrogenesis and tectonic setting of the early Mesozoic Xitian granitic pluton in the middle Qin-Hang Belt, South China: Constraints from zircon U–Pb ages and bulk-rock trace element and Sr–Nd–Pb isotopic compositions. Journal of Asian Earth Sciences 128, 130-148.																							
Wu, T., Zhou, J. X., Wang, X. C., Li, W. X., Wilde, S. A., Sun, H. R., ... & Li, Z. (2018). Identification of ca. 850 Ma high-temperature strongly peraluminous granitoids in southeastern Guizhou Province, South China: A result of early extension along the southern margin of the Yangtze Block. Precambrian Research, 308, 18-34.																							
Xia, R., Wang, C., Qing, M., Li, W., Carranza, E. J. M., Guo, X., ... & Zeng, G. (2015). Zircon U–Pb dating, geochemistry and Sr–Nd–Pb–Hf–O isotopes for the Nan'getan granodiorites and mafic microgranular enclaves in the East Kunlun Orogen: Record of closure of the Paleo-Tethys. Lithos, 234, 47-60.																							
Xiang, L., Wang, R., Romer, R. L., Che, X., Hu, H., Xie, L., & Tian, E. (2020). Neoproterozoic Nb-Ta-W-Sn bearing tourmaline leucogranite in the western part of Jiangnan Orogen: Implications for episodic mineralization in South China. Lithos, 360, 105450.																							
Xu, L.-L., Bi, X.-W., Hu, R.-Z., Tang, Y.-Y., Wang, X.-S., Huang, M.-L., Wang, Y.-J., Ma, R., Liu, G., 2019. Contrasting whole-rock and mineral compositions of ore-bearing (Tongchang) and ore-barren (Shilicun) granitic plutons in SW China: Implications for petrogenesis and ore genesis. Lithos 336, 54-66.																							
Xu, P. Y., Zheng, Y. C., Yang, Z. S., Hou, Z. Q., Shen, Y., Wang, Z. X., ... & Zhou, L. M. (2020). Metallogeny of the continental collision-related Jiagang W-Mo deposit, Tibet: Evidence from geochronology and petrogenesis. Ore Geology Reviews, 122, 103519.																							
Yan, Q. H., Li, S. S., Qiu, Z. W., Wang, H., Wei, X. P., Dong, R., & Zhang, X. Y. (2017). Geochronology, geochemistry and Sr–Nd–Hf–S–Pb isotopes of the early cretaceous Taoxihu Sn deposit and related granitoids, SE China. Ore Geology Reviews, 89, 350-368.																							
Yang, J. H., Kang, L. F., Peng, J. T., Zhong, H., Gao, J. F., & Liu, L. (2018). In-situ elemental and isotopic compositions of apatite and zircon from the Shuikoushan and Xihuashan granitic plutons: Implication for Jurassic granitoid-related Cu-Pb-Zn and W mineralization in the Nanling Range, South China. Ore Geology Reviews, 93, 382-403.																							
Yang, M., Zhao, F., Liu, X., Qing, H., Raharimahefa, T., & Duan, W. (2020). Petrogenesis and geodynamic setting of granitoids at Machangqing Cu–Mo (Au) deposit, western Yangtze craton, southwestern China: constraints from zircon U–Pb and molybdenite Re–Os geochronology, Lu–Hf isotopes, and geochemistry. Canadian Journal of Earth Sciences, 57(9), 1066-1088.																							
Yang, Y., Pan, X., Hou, Z., & Deng, Y. (2021). Redox states and protoliths of Late Mesozoic granitoids in the eastern Jiangnan Orogen: Implications for W, Mo, Cu, Sn, and (Au) mineralization. Ore Geology Reviews, 104038.																							
Yang, Y., Pan, X., Hou, Z., Deng, Y., Ouyang, Y., Meng, D., & Xie, T. (2021). Petrogenesis, redox state, and mineralization potential of Triassic granitoids in the Mengshan district, South China. Frontiers in Earth Science, 9.																							
Zeng, Q.D., Yang, J.H., Zhang, Z.L., Liu, J.M., and Duan, X.X., 2014, Petrogenesis of the Yangchang Mo‐bearing granite in the Xilamulun metallogenic belt, NE China: geochemistry, zircon U-Pb ages and Sr-Nd-Pb isotopes: Geological Journal, v. 49, p. 1–14.																							
Zeng, Q.D., Yang, J.H., Liu, J.M., Chu, S.X., Duan, X.X., Zhang, Z.L., Zhang, W.Q., and Zhang, S., 2012, Genesis of the Chehugou Mo-bearing granitic complex on the northern margin of the North China Craton: Geochemistry, zircon U-Pb age and Sr-Nd-Pb isotopes: Geological Magazine, v. 149, p. 753–767.																							
Zhang, A. P., Zheng, Y. C., Xu, B., Fu, Q., Ma, W., Zhang, C., ... & Fei, F. (2019). Metallogeny of the Lietinggang-Leqingla Fe–Cu–(Mo)–Pb–Zn polymetallic deposit, evidence from Geochronology, Petrogenesis, and Magmatic oxidation state, Lhasa terrane. Ore Geology Reviews, 106, 318-339.																							
Zhang, C. C., Sun, W. D., Wang, J. T., Zhang, L. P., Sun, S. J., & Wu, K. (2017). Oxygen fugacity and porphyry mineralization: A zircon perspective of Dexing porphyry Cu deposit, China. Geochimica et Cosmochimica Acta, 206, 343-363.																							
Zhang, D. H., Wei, J. H., Fu, L. B., Schmitt, A. K., Wang, D. Z., Tan, J., & Liu, J. K. (2017). Petrogenesis and thermal overprint of S-type granites in Helanshan region, North China Craton: Constraints on the 1.90 Ga khondalites decompression melting and 1.32 Ga tectono-thermal event. Precambrian Research, 303, 660-672.																							
Zhang, D., Zhao, K. D., Wang, B. D., Cheng, K. D., Luo, X. L., Zhang, W., ... & Jiang, S. Y. (2020). Cretaceous granitic magmatism and mineralization in the Shanhu W-Sn ore deposit in the Nanling Range in South China. Ore Geology Reviews, 126, 103758.																							
Zhang, L. K., Li, G. M., Santosh, M., Cao, H. W., Dong, S. L., Zhang, Z., ... & Zhang, S. T. (2019). Cambrian magmatism in the Tethys Himalaya and implications for the evolution of the Proto‐Tethys along the northern Gondwana margin: A case study and overview. Geological Journal, 54(4), 2545-2565.																							
Zhang, L., Hu, Y., Liang, J., Ireland, T., Chen, Y., Zhang, R., ... & Sun, W. (2017). Adakitic rocks associated with the Shilu copper–molybdenum deposit in the Yangchun Basin, South China, and their tectonic implications. Acta Geochimica, 36(2), 132-150.																							
Zhang, S., Zhang, R., Lu, J., Ma, D., Ding, T., Gao, S., & Zhang, Q. (2019). Neoproterozoic tin mineralization in South China: geology and cassiterite U–Pb age of the Baotan tin deposit in northern Guangxi. Mineralium Deposita, 54(8), 1125-1142.																							
Zhang, W., Jiang, S.Y., Gao, T.S., Ouyang, Y.P., Zhang, D., 2020. The effect of magma differentiation and degassing on ore metal enrichment during the formation of the world-class Zhuxi W-Cu skarn deposit: Evidence from U-Pb ages, Hf isotopes and trace elements of zircon, and whole-rock geochemistry. Ore Geology Reviews 127, 103801.																							
Zhang, Y., 2013, Research on characteristics of geology, geochemistry and metallogenic mechanism of the Jurassic molybdenum deposits in the middle-eastern area of Jilin. Ph. D. Dissertation, Changchun: Jilin University, 1–144 (available online; in Chinese with English abstract).																							
Zhang, Z. J., Cheng, Q. M., Wu, G. P., & Hu, X. L. (2021). Petrogenesis of the Quanzigou porphyry Mo deposit at the northern margin of the North China Craton: Constrains from geochronology, geochemistry, and Sr–Nd–Hf isotopes characteristics. Journal of Geochemical Exploration, 231, 106681.																							
Zhao, L., Zhou, X., Zhai, M., Santosh, M., Ma, X., Shan, H., & Cui, X. (2014). Paleoproterozoic tectonic transition from collision to extension in the eastern Cathaysia Block, South China: Evidence from geochemistry, zircon U–Pb geochronology and Nd–Hf isotopes of a granite–charnockite suite in southwestern Zhejiang. Lithos, 184, 259-280.																							
Zhong, S., Seltmann, R., Qu, H., & Song, Y. (2019). Characterization of the zircon Ce anomaly for estimation of oxidation state of magmas: a revised Ce/Ce* method. Mineralogy and Petrology, 113(6), 755-763.																							
Zhou, T., Zeng, Q., Chen, P., Li, X., Cen, C., & Yang, Y. (2019). The formation of the C aosiyao giant porphyry M o deposit on the northern margin of the N orth C hina C raton: Constraints from U―P b and R e―O s geochronology, whole‐rock geochemistry, H f isotopes, and oxygen fugacity of the magma. Geological Journal, 54(4), 2160-2184.																							
Zhou, T., Zeng, Q., Gao, S., Chu, S., & Yang, J. (2020). Geochronology, geochemistry and fluid inclusions of the Yechangping giant porphyry-skarn Mo-W deposit, East Qinling, China. Ore Geology Reviews, 103823.																							
Zhou, Y., Xu, B., Hou, Z. Q., Wang, R., Zheng, Y. C., & He, W. Y. (2019). Petrogenesis of Cenozoic high–Sr/Y shoshonites and associated mafic microgranular enclaves in an intracontinental setting: implications for porphyry Cu-Au mineralization in western Yunnan, China. Lithos, 324, 39-54.																							
Zhu, D.-C., Zhao, Z.-D., Niu, Y., Dilek, Y., Wang, Q., Ji, W.-H., Dong, G.-C., Sui, Q.-L., Liu, Y.-S., Yuan, H.-L., 2012. Cambrian bimodal volcanism in the Lhasa Terrane, southern Tibet: record of an early Paleozoic Andean-type magmatic arc in the Australian proto-Tethyan margin. Chemical Geology 328, 290-308.																							
Zhu, Z., Campbell, I. H., Allen, C. M., & Burnham, A. D. (2020). S-type granites: Their origin and distribution through time as determined from detrital zircons. Earth and Planetary Science Letters, 536, 116140.																							
Zong, K., Liu, Y., Zhang, Z., He, Z., Hu, Z., Guo, J., & Chen, K. (2013). The generation and evolution of Archean continental crust in the Dunhuang block, northeastern Tarim craton, northwestern China. Precambrian Research, 235, 251-263.																							
																							
References for Sheet 2:																							
Tang, M., Ji, W. Q., Chu, X., Wu, A., & Chen, C. (2021). Reconstructing crustal thickness evolution from europium anomalies in detrital zircons. Geology, 49(1), 76-80.																							
Zhong, S., Seltmann, R., Qu, H., & Song, Y. (2019). Characterization of the zircon Ce anomaly for estimation of oxidation state of magmas: a revised Ce/Ce* method. Mineralogy and Petrology, 113(6), 755-763.																							
																							
References for Sheet 3:																							
Ranjan, S., Upadhyay, D., & Srikantappa, C. (2022). Eoarchean to Neoarchean crustal evolution of the Western Dharwar Craton, southern India: Clues from U-Pb-Hf isotope composition of detrital zircon. Precambrian Research, 371, 106559.																							
Zhong, S., Seltmann, R., Qu, H., & Song, Y. (2019). Characterization of the zircon Ce anomaly for estimation of oxidation state of magmas: a revised Ce/Ce* method. Mineralogy and Petrology, 113(6), 755-763.																							
																							
References for Sheet 4:																							
Balica, C., Ducea, M.N., Gehrels, G.E., Kirk, J., Roban, R.D., Luffi, P., Chapman, J.B., Triantafyllou, A., Guo, J., Stoica, A.M., Ruiz, J., Balintoni, I., Profeta, L., Hoffman, D. and Petrescu, L. (2020) A zircon petrochronologic view on granitoids and continental evolution. Earth and Planetary Science Letters 531.																							
Bell E. A. and Harrison T. M. (2013) Post-Hadean transitions in Jack Hills zircon provenance: a signal of the Late Heavy Bombardment? Earth Planet. Sci. Lett. 364, 1–11.																							
Bell E. A., Boehnke P., Harrison T. M. and Mao W. L. (2015a) Potentially biogenic carbon preserved in a 4.1 Ga zircon. Proc. Natl. Acad. Sci. 112, 14518–14521.																							
Bell E. A., Boehnke P., Hopkins-Wielicki M. D. and Harrison T. M. (2015b) Distinguishing primary and secondary inclusion assemblages in Jack Hills zircons. Lithos 234–235, 15–26.																							
Bell E. A., Harrison T. M., Kohl I. E. and Young E. D. (2014) Eoarchean crustal evolution of the Jack Hills zircon source and loss of Hadean crust. Geochim. Cosmochim. Acta 146, 27–42.																							
Bell E. A., Harrison T. M., McCulloch M. T. and Young E. D. (2011) Early Archean crustal evolution of the Jack Hills Zircon source terrane inferred from Lu-Hf, 207Pb/206Pb, and d18O systematics of Jack Hills zircons. Geochim. Cosmochim. Acta 75, 4816–4829																							
Cavosie A. J., Valley J. W., Wilde S. A. and E.I.M.F. (2006) Correlated microanalysis of zircon: trace element, d18O, and U– Th–Pb isotopic constraints on the igneous origin of complex >3900 Ma detrital grains. Geochim. Cosmochim. Acta 70, 5601–5616																							
Cavosie A. J., Wilde S. A., Liu D., Weiblen P. W. and Valley J. W. (2004) Internal zoning and U–Th–Pb chemistry of Jack Hills detrital zircons: a mineral record of early Archean to Mesoproterozoic (4348–1576 Ma) magmatism. Precambr. Res. 135, 251–279																							
Crowley, J. L., Myers, J. S., Sylvester, P. J., & Cox, R. A. (2005). Detrital zircon from the Jack Hills and Mount Narryer, Western Australia: evidence for diverse> 4.0 Ga source rocks. The Journal of Geology, 113(3), 239-263.																							
Holden P., Lanc P., Ireland T. R., Harrison T. M., Foster J. J. and Bruce Z. (2009) Mass-spectrometric mining of Hadean zircons by automated SHRIMP multi-collector and single-collector U/ Pb zircon age dating: the first 100,000 grains. Int. J. Mass Spectrom. 286, 53–63.																							
Maas, R., Kinny, P. D., Williams, I. S., Froude, D. O., & Compston, W. (1992). The Earth's oldest known crust: a geochronological and geochemical study of 3900–4200 Ma old detrital zircons from Mt. Narryer and Jack Hills, Western Australia. Geochimica et Cosmochimica Acta, 56(3), 1281-1300.																							
Peck, W. H., Valley, J. W., Wilde, S. A., & Graham, C. M. (2001). Oxygen isotope ratios and rare earth elements in 3.3 to 4.4 Ga zircons: Ion microprobe evidence for high δ18O continental crust and oceans in the Early Archean. Geochimica et Cosmochimica Acta, 65(22), 4215-4229.																							
Turner, S., Wilde, S., Wörner, G., Schaefer, B., & Lai, Y. J. (2020). An andesitic source for Jack Hills zircon supports onset of plate tectonics in the Hadean. Nature communications, 11(1), 1-5.																							
Zhong, S., Seltmann, R., Qu, H., & Song, Y. (2019). Characterization of the zircon Ce anomaly for estimation of oxidation state of magmas: a revised Ce/Ce* method. Mineralogy and Petrology, 113(6), 755-763.																							

```