## plots from VAS model

## vaccine efficacies

vas_VEs <- map2_df(.x = vas_fit,
                   .y = vas_pred,
                   .f = calculate_VEs,
                   .id = "Analysis",
                   conf_level = c(0.5, 0.95))

vas_VEs %>%
    filter(age_CASE    == 25,
           age_CONTACT == 25,
           Analysis    == "Main") %>%
    pretty_VEs(., unfill = FALSE) %>%
    select(-Analysis, -Case, -Contact) %>%
    separate(Vaccine, into = c("Doses", "Vaccine"), remove = T) %>%
    arrange(Variant, rev(Vaccine), Doses) %>%
    select(Variant, Vaccine, Doses, everything()) %>%
    mutate_at(.vars = vars(Variant, Vaccine),
              .funs = unfill_for_table) %T>%
    write_csv("figures/ves.csv") %>%
    kable(format = 'simple',
          align = 'llrrr',
          caption = 'Vaccine efficacies by variant, vaccine product and number of doses')


vas_VEs %>%
    filter(age_CASE    == 25,
           age_CONTACT == 25) %>%
    pretty_VEs(., unfill = FALSE) %>%
    select(-Case, -Contact) %>%
    separate(Vaccine, into = c("Doses", "Vaccine"), remove = T) %>%
    mutate(Analysis = factor(Analysis, levels = names(min_SIs), ordered = T)) %>%
    arrange(Analysis, Variant, rev(Vaccine), Doses) %>%
    select(Analysis, Variant, Vaccine, Doses, everything()) %>%
    mutate_at(.vars = vars(Variant, Vaccine, Analysis),
              .funs = unfill_for_table) %T>%
    write_csv("figures/ves_all.csv") %>%
    kable(format = 'simple',
          align = 'lllrrr',
          caption = 'Vaccine efficacies by variant, vaccine product and number of doses, all analyses')


vas_VEs %>%
    filter(age_CASE    == 25,
           age_CONTACT == 25) %>%
    pretty_VEs(., unfill = FALSE) %>%
    select(-Case, -Contact) %>%
    separate(Vaccine, into = c("Doses", "Vaccine"), remove = T) %>%
    mutate(Analysis = factor(Analysis, levels = names(min_SIs), ordered = T)) %>%
    select(Analysis, Variant, Vaccine, Doses, everything()) %>%
    gather(Effect, value, `Infection protection`, `Transmission reduction`) %>%
    spread(Analysis, value) %>%
    arrange(Variant, Effect, rev(Vaccine), Doses) %>%
    mutate_at(.vars = vars(Variant, Vaccine, Effect),
              .funs = unfill_for_table) %>%
    select(Variant, Effect, Vaccine, Doses, everything()) %>%
    kable(format = 'simple',
          align = 'lllrrrr',
          caption = 'Vaccine efficacies by variant, vaccine product and number of doses, all analyses')
    

## end vaccine efficacies

## predicted values

vas_pred_df <- map(.x = vas_pred, ~as.data.frame(.x[grep(x = names(vas_pred$Main),
                                      pattern = 'pred', value = T)]))

plot_vas_sar_data <- 
    map(vas_fit, 'vas_prd') %>%
    map(mmcc:::tidy.mcmc.list) %>%
    map2(.x = ., .y = vas_pred_df,
         .f = ~cbind(.x, .y) %>%
             rename_all(.funs = ~sub("_pred", replacement = "", x = .)) %>%
             mutate(
                 case_status    = c(0:2)[1 + (dwp1_CASE >= 21)    + 
                                             (dwp2_CASE >= 7)],
                 contact_status = c(0:2)[1 + (dwp1_CONTACT >= 21) +
                                             (dwp2_CONTACT >= 7)]) %>%
             mutate_at(.vars = vars(case_status, contact_status),
                       .funs = ~factor(., ordered = T)) %>%
             mutate_at(.vars = vars(vax_CONTACT, vax_CASE),
                       .funs = ~factor(., levels = c("None", 
                                                     "ChAdOx1",
                                                     "BNT162b2"))) %>%
             mutate(vax_CONTACT = fct_rev(vax_CONTACT)) %>%
             mutate(median_numeric = median) %>%
             mutate_at(.vars = vars(median, `2.5%`, `97.5%`),
                       .funs = function(x){sprintf("%0.2f", x)}) %>%
             mutate(age_CONTACT_label = 
                        case_when(age_CONTACT == 15 ~ "Contact:\nChild <18",
                                  age_CONTACT == 25 ~ "Contact:\nAdult 18+",
                                  TRUE              ~ "Contact:\nUnknown age"),
                    age_CASE_label = 
                        case_when(age_CASE    == 25 ~ "Case: Adult <50",
                                  age_CASE    == 55 ~ "Case: Adult 50+")))


sar_plots <-
    map(.x = plot_vas_sar_data, 
        .f = ~filter(., 
                     age_CASE    == 25, 
                     age_CONTACT == 25) %>% 
            plot_pred(white = 1/3)  +
            facet_nested(
                age_CONTACT_label + vax_CONTACT ~ 
                    age_CASE_label + Variant + vax_CASE,
                switch = 'y',
                space  = 'free', 
                scales = 'free',
                nest_line = TRUE))

sar_plots %>%
    map2(.x = ., .y = names(.),
         .f = ~ggsave(filename = paste0("figures/plot_vas_sar_",.y,".pdf"),
                      plot     = .x,
                      device   = cairo_pdf,
                      width    = 8, 
                      height   = 4))

sar_plots_all <- 
    map(
        .x = plot_vas_sar_data, 
        .f = ~plot_pred(.x, white = 1/3) + 
            facet_nested(
                age_CONTACT_label + vax_CONTACT ~ 
                    Variant + age_CASE_label + vax_CASE,
                switch = 'y',
                space  = 'free', 
                scales = 'free',
                nest_line = TRUE))


sar_plots_all %>%
    map2(.x = ., .y = names(.),
         .f = ~ggsave(filename = paste0("figures/plot_vas_sar_all_",.y,".pdf"),
                      plot     = .x,
                      device   = cairo_pdf,
                      width    = 15, 
                      height   = 5))
