# hhSAR vaccine and swab model

model_file     <- list('Main'        = 'hhSARjagsModelStrongPriors.R',
                       'Sensitivity' = 'hhSARjagsModelStrongPriors.R',
                       'Flat priors' = 'hhSARjagsModelWeakPriors.R')


if (file.exists('results/vas_fit.RDS')){
    vas_fit <- readRDS('results/vas_fit.RDS')
} else {
    
    vas_fit <- map2(.x = vas_list,
                    .y = model_file,
                    .f = ~fit_model(vas_list = .x,
                                    n.burn   = 1e4,
                                    n.post   = 1e4,
                                    n.pred   = 1e4, 
                                    file     = .y))
    mkdir('results')
    saveRDS(object = vas_fit, file =  'results/vas_fit.RDS') # save results
    
}


