# hhSAR plot options

plot_SI_data <-
    dat_SI %>% 
    filter(Covid == 1) %>% 
    count(SerialInterval) %>%
    na.omit %>%
    mutate(d = n/sum(n))

plot_SI_data %>%
    group_by(SerialInterval < -2) %>%
    summarise(n = sum(n))


dsn_parms <- map(.x = min_SIs[c("Main", "Sensitivity")], 
                 ~get_dsn(dat_SI = dat_SI %>% 
                              filter(Covid == 1),
                          min_SI = .x))

dsn_SIs <- dsn_parms %>%
    map2_df(.x = .,
            .y = names(.),
            ~get_sn(dat_SI = dat_SI %>% 
                        filter(Covid == 1),
                    dsn = .x, n = 1001, r = c(-7, 15)) %>%
               mutate(min_SI = .y),
           .id = "Analysis")


map_df(.x = min_SIs, 
    ~filter(dat_SI, Covid == 1, SerialInterval >= .x),
    .id = "Analysis") %>%
    nest(data = -Analysis) %>%
    mutate(Q = map(.x = data, ~quantile(.x$SerialInterval, 
                                        probs = c(0.025, 0.5, 0.975)))) %>%
    unnest_wider(Q)

dsn_SI_qs <- map(dsn_parms, ~get_sn_quantiles_from_parms(parms = .x$estimate)) %>%
    map_df(~tibble(SerialInterval = round(.x), Q = names(.x)) %>%
            spread(Q, SerialInterval), .id = "Analysis")

plot_SI <- plot_SI_data %>%
    bind_cols(as.data.frame(min_SIs)) %>%
    mutate_at(.vars = vars(one_of(names(min_SIs))),
              .funs = function(x){ifelse(x <= .$SerialInterval, .$d, NA)}) %>%
    select(-d) %>%
    pivot_longer(cols = one_of(names(min_SIs)), names_to = "Analysis", values_to = "d") %>%
    ggplot(data = ., aes(x = as.integer(SerialInterval))) +
    geom_col( aes(y = d),
              show.legend = TRUE,
              fill = 'grey80') +
    geom_point(data = dsn_SI_qs, aes(x = `50.0%`, y = 0)) +
    geom_segment(data = dsn_SI_qs, aes(x = `2.5%`, xend = `97.5%`, y = 0, yend = 0)) +
    geom_line(data = dsn_SIs, aes(x = x, y = d)) +
    theme(panel.grid = element_blank(),
          axis.ticks = element_line()) +
    facet_grid(Analysis ~ .) +
    ggplot2::labs(
        # title    = "Distribution of serial intervals",
        # subtitle = "For contacts with confirmed SARS-CoV-2",
        x        = "Serial interval (days)",
        y        = "Density") +
    scale_x_continuous(breaks = pretty_breaks(n = 6),
                       limits = c(NA, 15)) +
    scale_fill_manual(values = my_palette, name = "Analysis") +
    theme(legend.position = 'none')



ggsave(filename = "figures/plot_SI.pdf", plot_SI, 
       device = cairo_pdf, width = 4, height = 3)

vaccine_provision <- dat_clean %>% 
    mutate(Covid = 0L + grepl(x = FLCORC, 
                              pattern = "SARS CoV-2 detected in this sample")) %>%
    group_by(NickID, HOCONUMBER, RoundedAge, ReCodedVaccineType, STATUS) %>% 
    summarise(Covid = max(Covid)) %>%
    mutate(Covid = ifelse(Covid, "Ever positive", "Always negative")) %>%
    inner_join(Variants$Sensitivity) %>%
    mutate(Variant = cut(p_delta,breaks = c(0,0.5,1), 
                         include.lowest = TRUE, 
                         labels = c("Alpha", "Delta"))) %>%
    mutate(STATUS = str_to_title(STATUS)) %>%
    ggplot(data = ., aes(x = RoundedAge)) +
    geom_histogram(aes(alpha = factor(Covid),
                       fill  = Variant,
                       group = interaction(Covid, Variant)),
                   binwidth = 5, center = 2.5,
                   color = 'black') +
    facet_grid(ReCodedVaccineType ~ STATUS) +
    geom_vline(xintercept = 18, lty = 2) +
    geom_vline(xintercept = 50, lty = 2) +
    theme(panel.grid.minor = element_blank()) +
    scale_alpha_manual(values = setNames(c(1/3, 1),
                                         c("Always negative", "Ever positive")),
                       name = "HOCO swab PCR positivity") +
    theme(legend.position = 'bottom') +
    scale_fill_manual(values = lineage_cols[1:2],
                      breaks = names(lineage_cols)[1:2],
                      name = 'Household variant') +
    theme(legend.direction = 'vertical')

ggsave(filename = 'vaccine_provision.png', bg = 'white',
       plot = vaccine_provision, width = 6, height = 4, dpi = 450, units = 'in')
