# here we want to sample from the priors and show how the posteriors compare

vas_list_blank <- setNames(map(vas_list, ~replace(.x, 'Covid', list(rep(NA, .x$n))))[1], "Prior")
vas_fit_blank  <- map(vas_list_blank, fit_model, n.post = 1e4, n.pred = 0,
                      file = 'hhSARjagsModelStrongPriors.R')

vas_ORs_blank  <- map_df(vas_fit_blank, calculate_ORs,
                         .id = "Analysis", conf_level = c(0.5, 0.95)) 

pretty_ors(vas_ORs_blank) %>% 
    knitr::kable(format = 'simple')


plot_vas_ORs_with_prior <-
    bind_rows(vas_ORs,
              vas_ORs_blank) %>%
    mutate(Analysis = factor(Analysis, levels = c(names(min_SIs), "Prior"))) %>%
    filter(!(Effect == "Transmission reduction" & Analysis == "Prior")) %>%
    mutate_if(is.numeric, ~pmax(., 0.01)) %>%
    arrange(Effect, Vaccine, Dose) %>%
    unite(col = "Vaccine status", Dose, Vaccine, sep = " ") %>%
    mutate(`Vaccine status` = fct_rev(fct_inorder(factor(`Vaccine status`)))) %>%
    ggplot(data = .,
           aes(x = `Vaccine status`, y = median,
               color = Variant,
               group = rev(Variant))) +
    geom_linerange(aes(ymin = `2.5%`,  ymax = `25.0%`),
                   position = position_dodge(w = 0.5),
                   show.legend = FALSE) +
    geom_linerange(aes(ymin = `75.0%`,  ymax = `97.5%`),
                   position = position_dodge(w = 0.5),
                   show.legend = FALSE) +
    geom_linerange(aes(ymin = `25.0%`, ymax = `75.0%`), 
                   size = 2,
                   position = position_dodge(w = 0.5)) +
    geom_point(pch = 124, size = 2, color = 'white', 
               position = position_dodge(w = 0.5),
               show.legend = FALSE) +
    geom_hline(yintercept = 1, lty = 2) +
    facet_grid(Analysis ~ Effect) + #,
    coord_flip() + 
    # labeller = labeller(Effect = function(x){sub(x = x, pattern = " ",
    # replacement = "\n")})) +
    scale_color_manual(values = lineage_cols[c("Alpha", "Delta")],
                       name = "Variant", drop = T) +
    scale_y_continuous(trans = 'log10', 
                       labels = function(x){sprintf("%g",x)}) +
    theme(panel.grid.minor = element_blank(),
          axis.ticks = element_line()#,
          #legend.position = 'none'
    ) +
    xlab(NULL) + 
    #annotation_logticks(sides = 'b') +
    ylab("Odds ratio") +
    scale_alpha_manual(values = c("Prior" = 0.5, "Posterior" = 1))

ggsave("figures/plot_vas_ORs_with_prior.pdf",
       plot = plot_vas_ORs_with_prior,
       device = cairo_pdf,
       width = 8, height = 8)

vas_ORs_blank