model{
    
    for (i in 1:n){
        
        Covid[i] ~ dbern(p[i])
        # need a random intercept per ID
        logit(p[i]) <- beta.0[group[i]] +  
            beta.1[group[i]]*time[i] + 
            beta.2[group[i]]*time[i]^2 +
            alpha[ID[i]]
        
    }
    
    for (d in 1:nID){
        alpha[d] ~ dnorm(0, tau.a)
    }
    
    #https://bmjopen.bmj.com/content/10/8/e039652
    for (t in 1:nt){
        time[time_na[t]] <- -exp(time_[t])
        # time_[t] ~ dnorm(1.63, 4)
        time_[t] ~ dgamma(4.744, 0.866)T(min_time[t],)
    }
    
    for (g in 1:ng){ # v looping over vaccine products
        beta.0[g]  ~ dnorm(beta.00,  tau.b0)
        beta.1[g]  ~ dnorm(beta.10,  tau.b1)
        beta.2[g]  ~ dnorm(beta.20,  tau.b2)
    }
    
    beta.00  ~ dnorm(0, 1e-6)
    beta.10  ~ dnorm(0, 1e-6)
    beta.20  ~ dnorm(0, 1e-6)
    
    sigma.b0 ~ dexp(0.3) # pc prior for pr(1/sqrt(tau) > 10) = 0.05
    sigma.b1 ~ dexp(0.3) # pc prior for pr(1/sqrt(tau) > 10) = 0.05
    sigma.b2 ~ dexp(0.3) # pc prior for pr(1/sqrt(tau) > 10) = 0.05
    sigma.a  ~ dexp(0.3) # pc prior for pr(1/sqrt(tau) > 10) = 0.05
    
    tau.b0 <- 1/sigma.b0^2
    tau.b1 <- 1/sigma.b1^2
    tau.b2 <- 1/sigma.b2^2
    tau.a  <- 1/sigma.a^2
    
    # predictions
    for (i in 1:n_pred){
        
        # we don't predict for the alpha random effect
        logit(p_pred[i]) <- beta.0[group_pred[i]] +
            beta.1[group_pred[i]]*time_pred[i] + 
            beta.2[group_pred[i]]*time_pred[i]^2
        
    }
    
}


