#          _/        _/
#         _/        _/          _/_/_/    _/_/    _/_/_/    
#        _/_/_/    _/_/_/    _/        _/    _/  _/    _/   
#       _/    _/  _/    _/    _/_/    _/_/_/_/  _/_/_/      
#      _/    _/  _/    _/        _/  _/    _/  _/    _/     
#     _/    _/  _/    _/  _/_/_/    _/    _/  _/    _/      
#     
#    household Secondary Attack Rates
#   
#    Paper title:  Effectiveness of BNT162b2 and ChAdOx1 against SARS-CoV-2
#                  household transmission
#     
#    Source:       https://github.com/samclifford/hhSAR 
# 
#    Institution:  London School of Hygiene & Tropical Medicine
#    Code authors: Samuel Clifford, Jada Hackman
#    Co-authors:   Stefan Flasche, Stephane Hue, Pauline Waight (HSA), Liz Miller

# setup
source("hhSARloadPackages.R")       # load all necessary packages, resolve namespace conflicts
source("hhSARfunctions.R")          # define all custom functions
source("hhSARprepData.R")           # load and prepare data for analysis

# summary of data
source("hhSARsummaryStatistics.R", echo = F, print.eval = TRUE)  # 
source("hhSARsummaryPlots.R")       # plots for summary statistics
source("hhSARsummaryPatients.R", echo = F, print.eval = T)

# model with vaccines and swabs
source("hhSARdefineModel.R")
source("hhSARvasModel.R")
source("hhSARvasPlots.R", print.eval = T)

# positivity model
source("hhSARposModel.R")

# additional analyses
source("hhSARsummaryTransmissionPairs.R") # what number of cases and contacts are sequenced?
source("hhSARsamplePriors.R")             # how far are the posteriors from the priors
source("hhSARcalculateORs.R",
       echo = F, print.eval = TRUE)       # odds ratios (exp(beta)) for model parameters
source("hhSARcalculateRORs.R",
       echo = F, print.eval = TRUE)       # ratio of odds ratios for comparing vaccines
source("hhSARcalculateRRs.R",
       echo = F, print.eval = TRUE)       # relative risks for variant and age effects
source("hhSARcalculateTotalParticipants.R",
       echo = F, print.eval = TRUE)       # How many cases and contacts, and by age
source("hhSARdates.R",
       echo = F, print.eval = TRUE)       # 

# convert plots
source("hhSARconvertPlots.R")
