# hhSAR load packages

# load packages required for analysis

# setting up
if (!require(pacman)){
    install.packages('pacman')
    require(pacman)
}

if (!require(mmcc)){
    p_load('remotes')   
    remotes::install_github('njtierney/mmcc')
    p_load('mmcc')
}

if (!require(words2number)){
    remotes::install_github('benmarwick/words2number')
    p_load(words2number)
}

pacman::p_load('tidyverse', 
               'sn',
               'readxl',
               'here',
               'magrittr',
               'lubridate', 
               'rjags',
               'scales',
               'knitr',
               'kableExtra',
               'conflicted',
               'MASS',
               'ggh4x',
               'pdftools',
               'patchwork',
               'mgcv',
               'data.table',
               'words2number',
               'philentropy')

lapply(c('select', 'filter'), FUN = function(x){conflict_prefer(x, 'dplyr')})
conflict_prefer('sd','sn')
conflict_prefer('collapse','dplyr')

theme_set(theme_minimal(base_family = "Roboto"))
