model{
    
    for (i in 1:n){
        
        d[i]     ~ dbern(p_delta[i]) # probability of being delta
        d_[i]    <- d[i] + 1         # alpha = 1, delta = 2
        
        Covid[i] ~ dbern(p[i])
        logit(p[i]) <- beta.0 + delta*d[i] +
            beta.1[vax_con[i], d_[i]]*step(dwp1_CONTACT[i] - k1) +
            beta.2[vax_con[i], d_[i]]*step(dwp2_CONTACT[i] - k2) +
            gamma.1[vax_case[i], d_[i]]*step(dwp1_CASE[i] - k1) +
            gamma.2[vax_case[i], d_[i]]*step(dwp2_CASE[i] - k2) +
            epsilon_contact*step(18 - age_CONTACT[i]) + # 20 from Davies et al. https://www.nature.com/articles/s41591-020-0962-9/figures/8 
            epsilon_case*step(age_CASE[i] - 50)
        
    }
    
    
    # table s3 https://www.nejm.org/doi/suppl/10.1056/NEJMoa2108891/suppl_file/nejmoa2108891_appendix.pdf
    
    # described in terms of log-odds
    # beta.1[1,1] ~ dnorm(log(.50), 2)                # 1 dose AZ against alpha
    # beta.1[2,1] ~ dnorm(log(.43), 0.25)             # 1 dose  P against alpha
    # beta.2[1,1] ~ dnorm(log(0.25) - log(.50), 2)    # 2 dose AZ against alpha
    # beta.2[2,1] ~ dnorm(log(0.06) - log(.43), 0.25) # 2 dose  P against alpha
    # 
    # beta.1[1,2] ~ dnorm(log(0.65), 2)                # 1 dose AZ against delta
    # beta.1[2,2] ~ dnorm(log(0.67), 0.25)             # 1 dose  P against delta
    # beta.2[1,2] ~ dnorm(log(0.33) - log(0.65), 2)    # 2 dose AZ against delta
    # beta.2[2,2] ~ dnorm(log(0.12) - log(0.67), 0.25) # 2 dose  P against delta
    
    # weakly informative priors
    
    beta.1[1,1] ~ dnorm(0, tau.b)                      # 1 dose AZ against alpha
    beta.1[2,1] ~ dnorm(0, tau.b)                      # 1 dose  P against alpha
    beta.2[1,1] ~ dnorm(0, tau.b)                      # 2 dose AZ against alpha
    beta.2[2,1] ~ dnorm(0, tau.b)                      # 2 dose  P against alpha
    
    beta.1[1,2] ~ dnorm(0, tau.b)                      # 1 dose AZ against delta
    beta.1[2,2] ~ dnorm(0, tau.b)                      # 1 dose  P against delta
    beta.2[1,2] ~ dnorm(0, tau.b)                      # 2 dose AZ against delta
    beta.2[2,2] ~ dnorm(0, tau.b)                      # 2 dose  P against delta
    
    for (v in 1:2){ # v looping over vaccine products
    
        for (k in 1:2){ # loop over variants as well
            gamma.1[v,k] ~ dnorm(gamma.10, tau.g)
            gamma.2[v,k] ~ dnorm(gamma.20, tau.g)
        }
            
    }
    
    
    for (k in 1:2){
        Beta.1[1:3,k]  <- beta.1[1:3,k]
        Beta.2[1:3,k]  <- beta.2[1:3,k]  + beta.1[1:3,k]
        Gamma.1[1:3,k] <- gamma.1[1:3,k]
        Gamma.2[1:3,k] <- gamma.2[1:3,k] + gamma.1[1:3,k]
        
        beta.1[3,k]  <- 0
        beta.2[3,k]  <- 0
        gamma.1[3,k] <- 0
        gamma.2[3,k] <- 0
    }
    
    
    # can use priors if you really want to, but fixed k is the decision
    #k1 ~ dnorm(14, 1/9)
    #k2 ~ dnorm(14, 1/9)
    k1 <- 21
    k2 <- 7
    
    # intercept (alpha effect)
    beta.0   ~ dnorm(0, 1e-6)
    # effect of delta variant sans vaccination status stuff
    delta    ~ dnorm(0, 1e-6)
    # random effect means
    gamma.10 ~ dnorm(0, 1e-6)
    gamma.20 ~ dnorm(0, 1e-6)
    
    
    epsilon_contact ~ dnorm(0, 1e-6)
    epsilon_case    ~ dnorm(0, 1e-6)
    #epsilon_contact ~ dnorm(log(0.5), 24) # for Davies et al.
    ## epsilon_contact ~ dnorm(log(0.45), 170) # for Dattner https://doi.org/10.1101/2020.06.03.20121145 using geometric mean of precision derived from one-sided SDs
    
    # epsilon_case    ~ dnorm(log(1.86), 4.67) # 
    
    sigma.b ~ dexp(0.3) # pc prior for pr(1/sqrt(tau) > 10) = 0.05
    sigma.g ~ dexp(0.3)
    
    tau.b <- 1/sigma.b^2
    tau.g <- 1/sigma.g^2

    # predictions
    for (i in 1:n_pred){
        
        d_pred[i]    <- p_delta_pred[i] + 1         # alpha = 1, delta = 2
        
        logit(p_pred[i]) <- beta.0 + delta*p_delta_pred[i] +
            beta.1[vax_con_pred[i], d_pred[i]]*step(dwp1_CONTACT_pred[i] - k1) +
            beta.2[vax_con_pred[i], d_pred[i]]*step(dwp2_CONTACT_pred[i] - k2) +
            gamma.1[vax_case_pred[i], d_pred[i]]*step(dwp1_CASE_pred[i] - k1) +
            gamma.2[vax_case_pred[i], d_pred[i]]*step(dwp2_CASE_pred[i] - k2) +
            epsilon_contact*step(18 - age_CONTACT_pred[i]) + # 20 from Davies et al. https://www.nature.com/articles/s41591-020-0962-9/figures/8 
            epsilon_case*step(age_CASE_pred[i] - 50)
        
    }
    
    # VEs from SARs
    for (i in 1:n_idx){ # needs to be an index of counterfactuals
        
        VE[i] <- 1 - p_pred[idx[i]]/p_pred[idx_cf[i]]
        
    }
        
}


