# read all PDF figures in and convert them to PNG
p_load(pdftools)

list(`Figure 1`  = 'hocotree.pdf',
     `Figure 2`  = 'plot_vas_sar_Main.pdf',
     `Figure 3`  = 'pcr_pos_plot_bayes_variants.pdf',
     `Figure A1` = 'plot_SI.pdf',
     `Figure A2` = 'combo_plot.pdf',
     `Figure A3` = 'lineages_plot.pdf',
     `Figure A4` = 'plot_vas_ORs_with_prior.pdf',
     `Figure A5` = 'plot_vas_sar_all_Main.pdf',
     `Figure A6` = 'plot_vas_sar_all_Sensitivity.pdf',
     `Figure A7` = 'pcr_pos_plot_RRs_variants.pdf') %>%
    map(~paste0('figures/',.x)) %>%
    {map2(.x = ., .y = names(.),
          ~file.copy(from = .x, to = paste0("figures/",.y,".pdf")))} %>%
    names %>%
    {paste0("figures/",.,".pdf")} %>%
    map(~pdftools::pdf_convert(pdf = .x, dpi = 300, 
                               filenames = sub(x = .x,
                                               pattern = 'pdf', 
                                               replacement = 'png')))
